-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-06818342-2
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-09-17 16:05:54','Actividad Generica 1','000001',NULL),(2,NULL,'2022-09-17 16:05:54','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Ringo022021',NULL,1,40719,'2022-11-28'),(2,NULL,'Ringo022021',NULL,1,40719,'2022-11-28'),(3,NULL,'Ringo022021',NULL,1,40719,'2022-12-06'),(4,NULL,'Ringo022021',NULL,1,40719,'2022-12-06'),(5,NULL,'Ringo022021',NULL,1,40719,'2022-12-06'),(6,NULL,'Ringo022021',NULL,1,40719,'2022-12-06'),(7,NULL,'Ringo022021',NULL,1,40719,'2023-02-21'),(8,NULL,'Ringo022021',NULL,1,40719,'2023-02-21'),(9,NULL,'Ringo022021',NULL,1,40719,'2023-02-21'),(10,NULL,'Ringo022021',NULL,1,40719,'2023-03-12'),(11,NULL,'Ringocho1947',NULL,1,40719,'2023-04-11');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'grupo.nimbus.argentina@gmail.com','2604576704',NULL,1,40719,'2022-09-19'),(2,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-09-29'),(3,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-09-29'),(4,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-09-29'),(5,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-11-10'),(6,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-11-10'),(7,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-11-28'),(8,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-11-28'),(9,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-12-06'),(10,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-12-06'),(11,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-12-06'),(12,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2022-12-06'),(13,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2023-02-21'),(14,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2023-02-21'),(15,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2023-02-21'),(16,'grupo.nimbus.argentina@gmail.com','2604576704','',1,40719,'2023-03-12'),(17,'grupo.nimbus.argentina@gmail.com','2604677419','',1,40719,'2023-04-11');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(9,5,3,110,NULL,0.00,'2022-12-17 13:23:32','2022-12-17 13:23:32',NULL),(10,5,3,62,NULL,0.00,'2022-12-17 13:23:32','2022-12-17 13:23:32',NULL),(11,6,3,491,NULL,0.00,'2022-12-17 13:24:01','2022-12-17 13:24:01',NULL),(12,6,3,518,NULL,0.00,'2022-12-17 13:24:01','2022-12-17 13:24:01',NULL),(15,8,21,163,NULL,0.00,'2022-12-17 13:26:16','2022-12-17 13:26:16',NULL),(16,8,21,491,NULL,0.00,'2022-12-17 13:26:16','2022-12-17 13:26:16',NULL),(17,9,21,163,NULL,0.00,'2022-12-17 13:27:16','2022-12-17 13:27:16',NULL),(18,9,21,62,NULL,0.00,'2022-12-17 13:27:16','2022-12-17 13:27:16',NULL),(29,15,3,63,NULL,0.00,'2023-01-05 19:09:25','2023-01-05 19:09:25',NULL),(30,15,3,191,NULL,0.00,'2023-01-05 19:09:25','2023-01-05 19:09:25',NULL),(33,17,21,163,NULL,0.00,'2023-01-05 19:10:54','2023-01-05 19:10:54',NULL),(34,17,21,63,NULL,0.00,'2023-01-05 19:10:54','2023-01-05 19:10:54',NULL),(35,18,21,163,NULL,0.00,'2023-03-14 10:52:10','2023-03-14 10:52:10',NULL),(36,18,21,493,NULL,0.00,'2023-03-14 10:52:10','2023-03-14 10:52:10',NULL),(37,19,21,163,NULL,0.00,'2023-03-14 10:52:58','2023-03-14 10:52:58',NULL),(38,19,21,494,NULL,0.00,'2023-03-14 10:52:58','2023-03-14 10:52:58',NULL),(39,20,10,74,NULL,0.00,'2023-03-14 10:56:05','2023-03-14 10:56:05',NULL),(40,20,10,163,NULL,0.00,'2023-03-14 10:56:05','2023-03-14 10:56:05',NULL),(41,21,20,564,NULL,0.00,'2023-05-01 21:20:28','2023-05-01 21:20:28',NULL),(42,21,20,163,NULL,0.00,'2023-05-01 21:20:28','2023-05-01 21:20:28',NULL),(43,21,20,5,NULL,0.00,'2023-05-01 21:20:28','2023-05-01 21:20:28',NULL),(44,21,20,563,NULL,0.00,'2023-05-01 21:20:28','2023-05-01 21:20:28',NULL),(45,21,20,483,NULL,0.00,'2023-05-01 21:20:28','2023-05-01 21:20:28',NULL),(46,21,20,484,NULL,0.00,'2023-05-01 21:20:28','2023-05-01 21:20:28',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,7851,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2023-04-13 18:58:07','2023-04-13 18:58:07'),(3,7851,1,2,NULL,0.00,'2022-12-17 13:21:20','2022-12-17 13:22:35','2022-12-17 13:22:35'),(4,7851,21,2,'Egreso Servicios WR 1595',0.00,'2022-12-17 13:22:28','2022-12-17 13:24:16','2022-12-17 13:24:16'),(5,7851,3,2,'Egreso Sueldos 1595',0.00,'2022-12-17 13:23:32','2022-12-17 13:23:32',NULL),(6,7851,3,2,'Egreso Servicios WR 1595',0.00,'2022-12-17 13:24:01','2022-12-17 13:24:01',NULL),(7,7851,3,2,'Egreso Servicios WR 1595',0.00,'2022-12-17 13:25:27','2022-12-17 13:25:41','2022-12-17 13:25:41'),(8,7851,21,2,'Pago Servicios WR 1595',0.00,'2022-12-17 13:26:16','2022-12-17 13:26:16',NULL),(9,7851,21,2,'Pago Sueldos 1595',0.00,'2022-12-17 13:27:16','2022-12-17 13:27:16',NULL),(10,7851,19,2,'Egreso SUSS',0.00,'2023-01-05 19:06:19','2023-01-05 19:06:36','2023-01-05 19:06:36'),(11,7851,3,2,'Egreso SUSS',0.00,'2023-01-05 19:07:00','2023-01-05 19:09:35','2023-01-05 19:09:35'),(12,7851,3,2,'Egreso SUSS',0.00,'2023-01-05 19:07:13','2023-01-05 19:07:22','2023-01-05 19:07:22'),(13,7851,21,2,'Pago SUSS',0.00,'2023-01-05 19:08:03','2023-01-05 19:09:39','2023-01-05 19:09:39'),(14,7851,21,2,'Pago SUSS',0.00,'2023-01-05 19:08:27','2023-01-05 19:09:30','2023-01-05 19:09:30'),(15,7851,3,2,'Egreso SUSS 1595',0.00,'2023-01-05 19:09:25','2023-01-05 19:09:25',NULL),(16,7851,3,2,'Egreso SUSS 1595',0.00,'2023-01-05 19:10:07','2023-01-05 19:10:27','2023-01-05 19:10:27'),(17,7851,21,2,'Pago SUSS 1595',0.00,'2023-01-05 19:10:54','2023-01-05 19:10:54',NULL),(18,7851,21,2,'Banco Santander Tarjeta Visa',0.00,'2023-03-14 10:52:10','2023-03-14 10:52:10',NULL),(19,7851,21,2,'Banco Santander Tarjeta AMEX',0.00,'2023-03-14 10:52:58','2023-03-14 10:52:58',NULL),(20,7851,10,2,'IVA Pago',0.00,'2023-03-14 10:56:05','2023-03-14 10:56:05',NULL),(21,7851,20,2,'Ventas NO Fiscal',0.00,'2023-05-01 21:20:28','2023-05-01 21:20:28',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1658 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7851,40719,11,3,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',2970.01,NULL,NULL,1,'2022-09-29 15:36:49','2022-09-29 15:36:49',NULL),(2,7851,40719,11,15,NULL,1,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',477.20,NULL,NULL,1,'2022-09-29 15:38:24','2022-09-29 15:38:37','2022-09-29 15:38:37'),(3,7851,40719,11,3,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',13622.18,NULL,NULL,1,'2022-09-29 15:41:04','2022-09-29 16:02:05','2022-09-29 16:02:05'),(4,7851,40719,11,3,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',5099.30,NULL,NULL,1,'2022-09-29 15:43:29','2022-09-29 15:43:29',NULL),(5,7851,40719,11,3,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',5500.31,NULL,NULL,1,'2022-09-29 15:45:44','2022-09-29 15:45:44',NULL),(6,7851,40719,11,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',3549.99,NULL,NULL,1,'2022-09-29 15:47:06','2022-09-29 15:47:06',NULL),(7,7851,40719,11,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',17379.07,NULL,NULL,1,'2022-09-29 15:51:13','2022-09-29 15:51:13',NULL),(8,7851,40719,11,3,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',47446.58,NULL,NULL,1,'2022-09-29 15:53:05','2022-09-29 15:53:05',NULL),(9,7851,40719,11,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1850.01,NULL,NULL,1,'2022-09-29 15:53:54','2022-09-29 15:53:54',NULL),(10,7851,40719,11,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',7450.31,NULL,NULL,1,'2022-09-29 15:55:14','2022-09-29 15:55:14',NULL),(11,7851,40719,11,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',20000.00,NULL,NULL,1,'2022-09-29 15:56:56','2022-09-29 15:57:34','2022-09-29 15:57:34'),(12,7851,40719,11,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',20000.00,NULL,NULL,1,'2022-09-29 15:57:34','2022-09-29 15:57:34',NULL),(13,7851,40719,11,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',16300.00,NULL,NULL,1,'2022-09-29 15:59:57','2022-09-29 15:59:57',NULL),(14,7851,40719,11,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',18000.00,NULL,NULL,1,'2022-09-29 16:01:03','2022-12-02 13:53:55','2022-12-02 13:53:55'),(15,7851,40719,11,3,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',13903.63,NULL,NULL,1,'2022-09-29 16:02:05','2022-09-29 16:02:05',NULL),(16,7851,40719,11,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1604.46,NULL,NULL,1,'2022-09-29 16:03:40','2022-09-29 16:05:19','2022-09-29 16:05:19'),(17,7851,40719,11,3,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',2999.96,NULL,NULL,1,'2022-09-29 16:05:02','2022-09-29 16:05:02',NULL),(18,7851,40719,11,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1604.46,NULL,NULL,1,'2022-09-29 16:05:19','2022-09-29 16:05:19',NULL),(19,7851,40719,11,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',722995.00,NULL,NULL,1,'2022-09-29 16:08:30','2022-09-29 16:12:01','2022-09-29 16:12:01'),(20,7851,40719,11,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',722995.00,NULL,NULL,1,'2022-09-29 16:12:01','2022-09-29 16:19:13','2022-09-29 16:19:13'),(21,7851,40719,11,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',722955.00,NULL,NULL,1,'2022-09-29 16:19:13','2022-09-29 16:26:35','2022-09-29 16:26:35'),(22,7851,40719,11,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',722955.00,NULL,NULL,1,'2022-09-29 16:26:35','2022-11-07 18:22:53','2022-11-07 18:22:53'),(23,7851,40719,11,3,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',17001.19,NULL,NULL,1,'2022-09-29 19:36:22','2022-09-29 19:36:22',NULL),(24,7851,40719,11,3,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',12100.72,NULL,NULL,1,'2022-09-29 19:38:18','2022-09-29 19:38:18',NULL);
INSERT INTO `balance_libro` VALUES (25,7851,40719,11,3,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',1499.96,NULL,NULL,1,'2022-09-29 19:47:57','2022-09-29 19:47:57',NULL),(26,7851,40719,11,3,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1999.95,NULL,NULL,1,'2022-09-29 19:49:12','2022-09-29 19:49:12',NULL),(27,7851,40719,11,3,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1500.00,NULL,NULL,1,'2022-09-29 19:49:53','2022-09-29 19:49:53',NULL),(28,7851,40719,11,3,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',5500.00,NULL,NULL,1,'2022-09-30 17:03:05','2022-09-30 17:03:18','2022-09-30 17:03:18'),(29,7851,40719,11,3,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',5500.00,NULL,NULL,1,'2022-09-30 17:03:18','2022-09-30 17:03:18',NULL),(30,7851,40719,11,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',3000.01,NULL,NULL,1,'2022-10-01 23:36:04','2022-10-01 23:36:04',NULL),(31,7851,40719,11,3,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1499.99,NULL,NULL,1,'2022-10-01 23:38:12','2022-10-01 23:38:12',NULL),(32,7851,40719,11,3,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',6440.00,NULL,NULL,1,'2022-10-01 23:42:08','2022-10-01 23:43:43','2022-10-01 23:43:43'),(33,7851,40719,11,3,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1080.00,NULL,NULL,1,'2022-10-01 23:43:20','2022-10-01 23:43:20',NULL),(34,7851,40719,11,3,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',6440.00,NULL,NULL,1,'2022-10-01 23:43:43','2022-10-01 23:43:43',NULL),(35,7851,40719,11,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',19436.00,NULL,NULL,1,'2022-10-01 23:45:34','2023-01-05 20:53:18','2023-01-05 20:53:18'),(36,7851,40719,11,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',268.00,NULL,NULL,1,'2022-10-01 23:46:11','2023-01-05 20:49:26','2023-01-05 20:49:26'),(37,7851,40719,11,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',15680.00,NULL,NULL,1,'2022-10-01 23:50:32','2022-10-01 23:50:32',NULL),(38,7851,40719,11,3,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',216.00,NULL,NULL,1,'2022-10-01 23:52:39','2022-10-01 23:52:39',NULL),(39,7851,40719,11,3,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',13024.00,NULL,NULL,1,'2022-10-01 23:54:02','2022-10-01 23:54:02',NULL),(40,7851,40719,11,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',212.00,NULL,NULL,1,'2022-10-01 23:54:37','2023-01-05 20:47:01','2023-01-05 20:47:01'),(41,7851,40719,10,15,NULL,86,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',26924.00,NULL,NULL,1,'2022-11-04 21:50:02','2022-12-21 12:20:42','2022-12-21 12:20:42'),(42,7851,40719,11,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30',NULL,30000.00,'',NULL,1,'2022-11-04 22:11:09','2022-12-02 10:52:03','2022-12-02 10:52:03'),(43,7851,40719,11,15,NULL,88,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',72830.12,NULL,NULL,1,'2022-11-07 18:14:55','2022-11-07 18:22:35','2022-11-07 18:22:35'),(44,7851,40719,11,16,NULL,80,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',667.90,NULL,NULL,1,'2022-11-07 18:15:25','2022-11-07 18:15:42','2022-11-07 18:15:42'),(45,7851,40719,10,16,NULL,89,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',0.00,NULL,NULL,1,'2022-11-07 18:16:34','2022-11-07 18:17:13','2022-11-07 18:17:13'),(46,7851,40719,11,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',722995.00,NULL,NULL,1,'2022-11-07 18:22:53','2022-11-07 18:22:53',NULL),(47,7851,40719,12,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',8001.00,NULL,NULL,1,'2022-11-07 18:28:22','2023-01-05 15:28:15','2023-01-05 15:28:15'),(48,7851,40719,12,3,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1369.96,NULL,NULL,1,'2022-11-07 18:31:01','2023-01-05 15:23:42','2023-01-05 15:23:42');
INSERT INTO `balance_libro` VALUES (49,7851,40719,12,3,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',6300.01,NULL,NULL,1,'2022-11-07 18:33:24','2023-01-05 15:16:35','2023-01-05 15:16:35'),(50,7851,40719,12,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1800.01,NULL,NULL,1,'2022-11-07 18:37:04','2023-01-05 15:03:26','2023-01-05 15:03:26'),(51,7851,40719,12,3,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',15500.00,NULL,NULL,1,'2022-11-07 18:38:04','2023-01-05 14:53:10','2023-01-05 14:53:10'),(52,7851,40719,12,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',10308.08,NULL,NULL,1,'2022-11-07 18:40:24','2022-11-07 18:41:33','2022-11-07 18:41:33'),(53,7851,40719,12,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',10308.08,NULL,NULL,1,'2022-11-07 18:41:33','2023-01-05 14:57:13','2023-01-05 14:57:13'),(54,7851,40719,12,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',22.86,NULL,NULL,1,'2022-11-07 18:43:08','2022-11-07 18:43:36','2022-11-07 18:43:36'),(55,7851,40719,12,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.07,NULL,NULL,1,'2022-11-07 18:43:36','2022-11-07 18:43:36',NULL),(56,7851,40719,12,3,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1299.93,NULL,NULL,1,'2022-11-07 18:45:08','2022-11-07 18:45:08',NULL),(57,7851,40719,12,3,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1500.00,NULL,NULL,1,'2022-11-07 18:46:01','2022-11-07 18:46:01',NULL),(58,7851,40719,12,3,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3000.01,NULL,NULL,1,'2022-11-07 18:47:45','2022-11-07 18:47:45',NULL),(59,7851,40719,12,3,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',39998.99,NULL,NULL,1,'2022-11-07 18:48:35','2022-11-07 18:48:35',NULL),(60,7851,40719,12,3,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',19999.99,NULL,NULL,1,'2022-11-07 18:49:34','2022-11-07 18:49:34',NULL),(61,7851,40719,12,3,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1499.96,NULL,NULL,1,'2022-11-07 18:50:22','2022-11-07 18:50:22',NULL),(62,7851,40719,12,3,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',6602.41,NULL,NULL,1,'2022-11-07 18:52:14','2022-11-07 18:52:14',NULL),(63,7851,40719,12,3,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',6751.10,NULL,NULL,1,'2022-11-07 18:57:52','2022-11-07 18:57:52',NULL),(64,7851,40719,12,3,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1500.01,NULL,NULL,1,'2022-11-07 19:00:05','2022-11-07 19:00:05',NULL),(65,7851,40719,12,3,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',238000.01,NULL,NULL,1,'2022-11-07 19:05:10','2022-11-07 19:05:10',NULL),(66,7851,40719,12,3,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',18503.01,NULL,NULL,1,'2022-11-07 19:06:11','2022-11-07 19:06:11',NULL),(67,7851,40719,12,3,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',8000.00,NULL,NULL,1,'2022-11-07 19:07:00','2022-11-07 19:07:00',NULL),(68,7851,40719,12,3,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1604.46,NULL,NULL,1,'2022-11-07 19:07:53','2022-11-07 19:25:06','2022-11-07 19:25:06'),(69,7851,40719,12,3,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',224850.02,NULL,NULL,1,'2022-11-07 19:25:06','2022-11-07 19:25:06',NULL),(70,7851,40719,12,3,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1604.46,NULL,NULL,1,'2022-11-07 19:27:06','2022-11-07 19:27:06',NULL),(71,7851,40719,12,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1799382.00,NULL,NULL,1,'2022-11-07 19:39:59','2022-11-25 18:27:20','2022-11-25 18:27:20'),(72,7851,40719,3053,3,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-30','2020-08-30',1000.01,NULL,NULL,1,'2022-11-10 17:23:39','2023-01-07 17:51:18','2023-01-07 17:51:18');
INSERT INTO `balance_libro` VALUES (73,7851,40719,3053,3,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',1698.84,NULL,NULL,1,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(74,7851,40719,3053,3,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',849.42,NULL,NULL,1,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(75,7851,40719,3053,3,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',2548.26,NULL,NULL,1,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(76,7851,40719,3053,3,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',1450.06,NULL,NULL,1,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(77,7851,40719,3053,3,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',440.00,NULL,NULL,1,'2022-11-10 18:04:38','2022-11-25 18:13:16','2022-11-25 18:13:16'),(78,7851,40719,3053,3,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',5756.45,NULL,NULL,1,'2022-11-10 18:04:38','2022-11-10 18:06:57','2022-11-10 18:06:57'),(79,7851,40719,3053,3,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-19','2020-12-19',900.00,NULL,NULL,1,'2022-11-10 18:04:38','2022-11-25 18:13:11','2022-11-25 18:13:11'),(80,7851,40719,3053,3,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',5883.53,NULL,NULL,1,'2022-11-10 18:06:57','2023-02-23 11:07:56','2023-02-23 11:07:56'),(81,7851,40719,13,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',306918.00,NULL,NULL,1,'2022-11-12 15:24:25','2022-11-25 18:24:40','2022-11-25 18:24:40'),(82,7851,40719,13,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',306918.00,NULL,NULL,1,'2022-11-12 15:24:25','2022-11-25 18:24:28','2022-11-25 18:24:28'),(83,7851,40719,13,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1175516.00,NULL,NULL,1,'2022-11-12 15:24:25','2022-11-25 17:47:37','2022-11-25 17:47:37'),(84,7851,40719,13,3,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2890.00,NULL,NULL,1,'2022-11-12 15:24:43','2022-11-12 15:57:20','2022-11-12 15:57:20'),(85,7851,40719,13,3,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22800.01,NULL,NULL,1,'2022-11-12 15:24:43','2022-11-12 15:40:43','2022-11-12 15:40:43'),(86,7851,40719,13,3,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1481.06,NULL,NULL,1,'2022-11-12 15:24:43','2022-11-12 15:52:32','2022-11-12 15:52:32'),(87,7851,40719,13,3,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1660.00,NULL,NULL,1,'2022-11-12 15:24:43','2022-11-12 15:51:54','2022-11-12 15:51:54'),(88,7851,40719,13,3,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5944.63,NULL,NULL,1,'2022-11-12 15:24:43','2022-11-12 15:52:18','2022-11-12 15:52:18'),(89,7851,40719,13,3,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2130.00,NULL,NULL,1,'2022-11-12 15:24:43','2022-11-12 15:51:49','2022-11-12 15:51:49'),(90,7851,40719,13,3,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1080.00,NULL,NULL,1,'2022-11-12 15:24:43','2022-11-12 15:51:44','2022-11-12 15:51:44'),(91,7851,40719,13,3,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22800.01,NULL,NULL,1,'2022-11-12 15:40:43','2022-11-12 15:52:43','2022-11-12 15:52:43'),(92,7851,40719,13,3,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5944.63,NULL,NULL,1,'2022-11-12 15:52:18','2022-11-12 15:58:03','2022-11-12 15:58:03'),(93,7851,40719,13,3,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1481.06,NULL,NULL,1,'2022-11-12 15:52:32','2022-11-12 15:57:50','2022-11-12 15:57:50'),(94,7851,40719,13,3,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22800.01,NULL,NULL,1,'2022-11-12 15:52:43','2022-11-12 15:57:30','2022-11-12 15:57:30'),(95,7851,40719,12,3,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2890.00,NULL,NULL,1,'2022-11-12 15:57:20','2022-11-25 18:10:52','2022-11-25 18:10:52');
INSERT INTO `balance_libro` VALUES (96,7851,40719,13,3,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22800.01,NULL,NULL,1,'2022-11-12 15:57:30','2022-11-12 15:57:40','2022-11-12 15:57:40'),(97,7851,40719,12,3,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22800.01,NULL,NULL,1,'2022-11-12 15:57:40','2022-11-12 15:57:40',NULL),(98,7851,40719,12,3,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1481.06,NULL,NULL,1,'2022-11-12 15:57:50','2022-11-12 15:57:50',NULL),(99,7851,40719,12,3,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5944.63,NULL,NULL,1,'2022-11-12 15:58:03','2022-11-12 15:58:03',NULL),(100,7851,40719,12,3,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1660.00,NULL,NULL,1,'2022-11-12 16:04:49','2022-11-25 18:13:05','2022-11-25 18:13:05'),(101,7851,40719,12,3,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2130.00,NULL,NULL,1,'2022-11-12 16:04:49','2022-11-25 18:12:59','2022-11-25 18:12:59'),(102,7851,40719,12,3,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1080.00,NULL,NULL,1,'2022-11-12 16:04:49','2022-11-25 18:12:52','2022-11-25 18:12:52'),(103,7851,40719,13,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1298945.18,NULL,NULL,1,'2022-11-25 17:47:37','2022-11-25 18:24:55','2022-11-25 18:24:55'),(104,7851,40719,13,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',306918.00,NULL,NULL,1,'2022-11-25 17:50:19','2022-11-25 18:22:55','2022-11-25 18:22:55'),(105,7851,40719,13,3,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2085.80,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(106,7851,40719,13,3,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',5750.00,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(107,7851,40719,13,3,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2230.00,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 18:12:41','2022-11-25 18:12:41'),(108,7851,40719,13,3,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',4000.00,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(109,7851,40719,13,3,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1556.66,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(110,7851,40719,13,3,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',13142.34,NULL,NULL,1,'2022-11-25 17:50:46','2022-12-03 19:58:40','2022-12-03 19:58:40'),(111,7851,40719,13,3,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',4000.01,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(112,7851,40719,13,3,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',6640.00,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(113,7851,40719,13,3,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',60649.99,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(114,7851,40719,13,3,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',17050.00,NULL,NULL,1,'2022-11-25 17:50:46','2022-12-19 17:57:01','2022-12-19 17:57:01'),(115,7851,40719,13,3,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',39788.33,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(116,7851,40719,13,3,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',13999.99,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(117,7851,40719,13,3,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',10002.50,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(118,7851,40719,13,3,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',67500.00,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(119,7851,40719,13,3,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1700.00,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL);
INSERT INTO `balance_libro` VALUES (120,7851,40719,13,3,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2499.99,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(121,7851,40719,13,3,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',107045.28,NULL,NULL,1,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(122,7851,40719,13,3,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',17370.88,NULL,NULL,1,'2022-11-25 17:58:58','2023-01-05 14:27:06','2023-01-05 14:27:06'),(123,7851,40719,13,3,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',10400.26,NULL,NULL,1,'2022-11-25 17:59:54','2023-01-05 14:32:36','2023-01-05 14:32:36'),(124,7851,40719,13,3,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1999.99,NULL,NULL,1,'2022-11-25 18:00:32','2023-01-05 15:43:43','2023-01-05 15:43:43'),(125,7851,40719,13,3,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',12701.10,NULL,NULL,1,'2022-11-25 18:01:08','2023-01-05 17:51:10','2023-01-05 17:51:10'),(126,7851,40719,13,3,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1500.00,NULL,NULL,1,'2022-11-25 18:02:18','2023-01-05 17:52:38','2023-01-05 17:52:38'),(127,7851,40719,13,3,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',13901.30,NULL,NULL,1,'2022-11-25 18:03:19','2023-01-05 17:55:29','2023-01-05 17:55:29'),(128,7851,40719,13,3,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',4999.99,NULL,NULL,1,'2022-11-25 18:04:06','2023-01-05 17:58:01','2023-01-05 17:58:01'),(129,7851,40719,13,3,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',19000.01,NULL,NULL,1,'2022-11-25 18:04:41','2023-01-05 17:59:57','2023-01-05 17:59:57'),(130,7851,40719,13,3,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6201.06,NULL,NULL,1,'2022-11-25 18:06:30','2023-01-05 18:04:22','2023-01-05 18:04:22'),(131,7851,40719,13,3,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',24600.00,NULL,NULL,1,'2022-11-25 18:08:40','2023-01-05 18:08:08','2023-01-05 18:08:08'),(132,7851,40719,13,3,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',11639.99,NULL,NULL,1,'2022-11-25 18:09:12','2022-11-25 18:10:56','2022-11-25 18:10:56'),(133,7851,40719,13,3,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',11639.99,NULL,NULL,1,'2022-11-25 18:12:29','2023-01-05 18:08:33','2023-01-05 18:08:33'),(134,7851,40719,13,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',306918.00,NULL,NULL,1,'2022-11-25 18:22:55','2022-11-25 18:27:52','2022-11-25 18:27:52'),(135,7851,40719,13,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',306918.00,NULL,NULL,1,'2022-11-25 18:24:28','2022-11-25 18:43:46','2022-11-25 18:43:46'),(136,7851,40719,13,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',306918.00,NULL,NULL,1,'2022-11-25 18:24:40','2022-11-29 21:48:34','2022-11-29 21:48:34'),(137,7851,40719,13,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1175515.99,NULL,NULL,1,'2022-11-25 18:24:55','2022-11-25 18:24:55',NULL),(138,7851,40719,12,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1799382.00,NULL,NULL,1,'2022-11-25 18:27:20','2022-11-25 18:27:20',NULL),(139,7851,40719,13,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',306918.00,NULL,NULL,1,'2022-11-25 18:27:52','2022-11-29 21:48:15','2022-11-29 21:48:15'),(140,7851,40719,13,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',306918.00,NULL,NULL,1,'2022-11-25 18:43:46','2022-11-25 18:43:46',NULL),(141,7851,40719,13,22,NULL,NULL,NULL,NULL,3,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',200000.00,'',NULL,1,'2022-11-28 12:26:27','2022-11-28 12:26:54','2022-11-28 12:26:54'),(142,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',200000.00,NULL,NULL,1,'2022-11-28 14:46:11','2022-11-28 22:37:20','2022-11-28 22:37:20');
INSERT INTO `balance_libro` VALUES (143,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',80000.00,NULL,NULL,1,'2022-11-28 14:59:42','2022-11-29 19:30:18','2022-11-29 19:30:18'),(144,7851,40719,13,20,NULL,NULL,NULL,135,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1175515.99,NULL,NULL,1,'2022-11-28 15:06:49','2022-11-28 15:22:07','2022-11-28 15:22:07'),(145,7851,40719,13,20,NULL,NULL,NULL,136,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',306918.00,NULL,NULL,1,'2022-11-28 15:13:58','2022-11-28 15:22:11','2022-11-28 15:22:11'),(146,7851,40719,12,20,NULL,NULL,NULL,137,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1799382.00,NULL,NULL,1,'2022-11-28 15:21:29','2022-11-28 15:21:29',NULL),(147,7851,40719,13,21,NULL,NULL,NULL,138,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',107045.28,NULL,NULL,1,'2022-11-28 15:24:57','2022-11-28 15:24:57',NULL),(148,7851,40719,13,21,NULL,NULL,NULL,139,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',36239.99,NULL,NULL,1,'2022-11-28 15:37:50','2023-01-05 18:07:35','2023-01-05 18:07:35'),(149,7851,40719,13,3,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',7302.76,NULL,NULL,1,'2022-11-28 15:41:43','2023-01-05 18:11:40','2023-01-05 18:11:40'),(150,7851,40719,11,21,NULL,NULL,NULL,141,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',13903.63,NULL,NULL,1,'2022-11-28 15:46:05','2022-11-28 15:46:05',NULL),(151,7851,40719,13,21,NULL,NULL,NULL,142,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',10002.50,NULL,NULL,1,'2022-11-28 15:49:11','2022-11-28 15:49:11',NULL),(152,7851,40719,13,21,NULL,NULL,NULL,143,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',19000.01,NULL,NULL,1,'2022-11-28 15:51:17','2023-01-05 17:59:36','2023-01-05 17:59:36'),(153,7851,40719,13,21,NULL,NULL,NULL,144,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',13901.30,NULL,NULL,1,'2022-11-28 15:52:09','2023-01-05 17:55:12','2023-01-05 17:55:12'),(154,7851,40719,13,21,NULL,NULL,NULL,145,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',4999.99,NULL,NULL,1,'2022-11-28 15:52:51','2022-11-28 19:04:40','2022-11-28 19:04:40'),(155,7851,40719,13,21,NULL,NULL,NULL,146,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6201.06,NULL,NULL,1,'2022-11-28 15:57:35','2022-11-29 20:07:54','2022-11-29 20:07:54'),(156,7851,40719,13,20,NULL,NULL,NULL,147,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',33904.11,NULL,NULL,1,'2022-11-28 16:00:27','2022-11-28 16:49:25','2022-11-28 16:49:25'),(157,7851,40719,13,21,NULL,NULL,NULL,148,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',17370.88,NULL,NULL,1,'2022-11-28 16:01:43','2022-11-28 18:56:36','2022-11-28 18:56:36'),(158,7851,40719,13,21,NULL,NULL,NULL,149,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',13999.99,NULL,NULL,1,'2022-11-28 16:03:59','2022-11-28 16:03:59',NULL),(159,7851,40719,13,21,NULL,NULL,NULL,150,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2499.99,NULL,NULL,1,'2022-11-28 16:04:47','2022-11-28 16:04:47',NULL),(160,7851,40719,13,21,NULL,NULL,NULL,151,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',60649.99,NULL,NULL,1,'2022-11-28 16:08:08','2022-11-28 16:08:08',NULL),(161,7851,40719,13,21,NULL,NULL,NULL,152,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',69200.00,NULL,NULL,1,'2022-11-28 16:09:22','2022-11-28 16:09:22',NULL),(162,7851,40719,13,21,NULL,NULL,NULL,153,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2085.80,NULL,NULL,1,'2022-11-28 16:10:20','2022-11-28 16:10:20',NULL),(163,7851,40719,13,21,NULL,NULL,NULL,154,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',4000.01,NULL,NULL,1,'2022-11-28 16:11:24','2022-11-28 16:11:24',NULL),(164,7851,40719,13,21,NULL,NULL,NULL,155,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',6640.00,NULL,NULL,1,'2022-11-28 16:12:10','2022-11-28 16:12:10',NULL),(165,7851,40719,13,21,NULL,NULL,NULL,156,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',5750.00,NULL,NULL,1,'2022-11-28 16:13:01','2022-11-28 16:13:01',NULL);
INSERT INTO `balance_libro` VALUES (166,7851,40719,13,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1900.00,NULL,NULL,1,'2022-11-28 16:17:58','2022-11-28 16:18:47','2022-11-28 16:18:47'),(167,7851,40719,13,3,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1900.00,NULL,NULL,1,'2022-11-28 16:19:38','2023-01-05 18:44:52','2023-01-05 18:44:52'),(168,7851,40719,13,3,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1500.00,NULL,NULL,1,'2022-11-28 16:20:23','2023-01-05 18:50:30','2023-01-05 18:50:30'),(169,7851,40719,13,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',18800.00,NULL,NULL,1,'2022-11-28 16:21:13','2023-01-05 18:52:41','2023-01-05 18:52:41'),(170,7851,40719,13,3,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1500.02,NULL,NULL,1,'2022-11-28 16:22:07','2023-01-05 18:53:52','2023-01-05 18:53:52'),(171,7851,40719,13,3,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',4000.00,NULL,NULL,1,'2022-11-28 16:22:50','2023-01-05 18:55:59','2023-01-05 18:55:59'),(172,7851,40719,13,3,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1800.05,NULL,NULL,1,'2022-11-28 16:24:05','2023-01-05 15:42:20','2023-01-05 15:42:20'),(173,7851,40719,13,20,NULL,NULL,NULL,164,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',39704.16,NULL,NULL,1,'2022-11-28 16:51:16','2022-11-28 16:51:24','2022-11-28 16:51:24'),(174,7851,40719,13,21,NULL,NULL,NULL,165,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',39704.16,NULL,NULL,1,'2022-11-28 16:53:16','2022-11-28 18:56:42','2022-11-28 18:56:42'),(175,7851,40719,13,21,NULL,NULL,NULL,166,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1900.00,NULL,NULL,1,'2022-11-28 16:54:59','2022-12-03 16:11:33','2022-12-03 16:11:33'),(176,7851,40719,13,21,NULL,NULL,NULL,167,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1500.00,NULL,NULL,1,'2022-11-28 16:55:41','2023-01-05 18:50:06','2023-01-05 18:50:06'),(177,7851,40719,13,21,NULL,NULL,NULL,168,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',39788.33,NULL,NULL,1,'2022-11-28 16:58:54','2022-11-28 16:58:54',NULL),(178,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',50000.00,NULL,NULL,1,'2022-11-28 17:09:04','2022-11-28 17:59:23','2022-11-28 17:59:23'),(181,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',100000.00,NULL,NULL,1,'2022-11-28 17:22:09','2022-11-28 17:59:23','2022-11-28 17:59:23'),(182,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',50000.00,NULL,NULL,1,'2022-11-28 17:25:12','2022-11-28 17:59:23','2022-11-28 17:59:23'),(183,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',200000.00,NULL,NULL,1,'2022-11-28 17:26:14','2022-11-28 17:59:23','2022-11-28 17:59:23'),(184,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',90000.00,NULL,NULL,1,'2022-11-28 17:33:30','2022-11-28 17:59:23','2022-11-28 17:59:23'),(185,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',50000.00,NULL,NULL,1,'2022-11-28 18:00:45','2022-11-28 18:00:45',NULL),(186,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',50000.00,NULL,NULL,1,'2022-11-28 18:03:28','2022-12-21 19:59:29','2022-12-21 19:59:29'),(187,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',13019.38,NULL,NULL,1,'2022-11-28 18:04:26','2022-11-28 18:04:26',NULL),(188,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',15000.00,NULL,NULL,1,'2022-11-28 18:27:04','2022-12-21 20:17:59','2022-12-21 20:17:59'),(189,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',6000.00,'Equivocación YPF Monte Comán',NULL,1,'2022-11-28 18:37:57','2022-11-28 18:48:35','2022-11-28 18:48:35');
INSERT INTO `balance_libro` VALUES (190,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',71.97,NULL,NULL,1,'2022-11-28 18:39:22','2022-11-28 18:51:35','2022-11-28 18:51:35'),(191,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',60000.00,NULL,NULL,1,'2022-11-28 18:42:51','2022-11-29 00:47:58','2022-11-29 00:47:58'),(192,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',6000.00,'Equivocación YPF Monte Comán',NULL,1,'2022-11-28 18:48:35','2022-11-28 18:48:35',NULL),(193,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',719.70,NULL,NULL,1,'2022-11-28 18:51:35','2022-12-06 19:05:14','2022-12-06 19:05:14'),(194,7851,40719,13,21,NULL,NULL,NULL,169,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',18800.00,NULL,NULL,1,'2022-11-28 18:54:26','2023-01-05 18:52:27','2023-01-05 18:52:27'),(195,7851,40719,13,21,NULL,NULL,NULL,170,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',17370.88,NULL,NULL,1,'2022-11-28 19:00:50','2023-01-05 14:23:09','2023-01-05 14:23:09'),(196,7851,40719,13,21,NULL,NULL,NULL,171,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',12701.10,NULL,NULL,1,'2022-11-28 19:01:45','2023-01-05 17:50:49','2023-01-05 17:50:49'),(197,7851,40719,13,21,NULL,NULL,NULL,172,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',15500.00,NULL,NULL,1,'2022-11-28 19:02:58','2023-01-05 14:52:17','2023-01-05 14:52:17'),(198,7851,40719,13,21,NULL,NULL,NULL,173,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',4999.99,NULL,NULL,1,'2022-11-28 19:06:19','2023-01-05 17:57:24','2023-01-05 17:57:24'),(199,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',100000.00,NULL,NULL,1,'2022-11-28 19:16:12','2022-11-28 19:16:12',NULL),(200,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',200000.00,NULL,NULL,1,'2022-11-28 19:20:14','2022-11-28 19:20:14',NULL),(201,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',90000.00,NULL,NULL,1,'2022-11-28 19:21:15','2022-11-28 19:21:15',NULL),(202,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',200000.00,NULL,NULL,1,'2022-11-28 22:37:20','2022-11-28 23:11:08','2022-11-28 23:11:08'),(203,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',212328.77,NULL,NULL,1,'2022-11-28 22:39:23','2022-11-28 22:49:50','2022-11-28 22:49:50'),(204,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',7077.99,NULL,NULL,1,'2022-11-28 22:41:04','2022-11-28 22:49:55','2022-11-28 22:49:55'),(205,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',206124.67,NULL,NULL,1,'2022-11-28 22:41:46','2022-11-28 22:49:30','2022-11-28 22:49:30'),(206,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',200000.00,NULL,NULL,1,'2022-11-28 22:51:50','2022-11-28 22:51:50',NULL),(207,7851,40719,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',212328.77,NULL,NULL,1,'2022-11-28 23:00:39','2022-11-28 23:00:39',NULL),(208,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',7007.99,NULL,NULL,1,'2022-11-28 23:02:19','2022-12-06 22:13:36','2022-12-06 22:13:36'),(209,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',206124.67,NULL,NULL,1,'2022-11-28 23:03:28','2022-11-28 23:03:28',NULL),(210,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',200000.00,NULL,NULL,1,'2022-11-28 23:11:08','2022-11-28 23:11:15','2022-11-28 23:11:15'),(211,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',200000.00,NULL,NULL,1,'2022-11-28 23:11:15','2022-11-28 23:11:15',NULL),(212,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',150000.00,NULL,NULL,1,'2022-11-28 23:13:36','2022-11-28 23:13:36',NULL);
INSERT INTO `balance_libro` VALUES (213,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',68000.00,NULL,NULL,1,'2022-11-28 23:14:15','2022-11-28 23:14:15',NULL),(214,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',69000.00,NULL,NULL,1,'2022-11-28 23:14:51','2022-11-28 23:14:51',NULL),(215,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',10000.00,NULL,NULL,1,'2022-11-28 23:22:42','2022-11-28 23:22:42',NULL),(216,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',29880.00,'Pago de Sueldos',NULL,1,'2022-11-28 23:26:40','2022-12-02 10:49:51','2022-12-02 10:49:51'),(217,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',50120.00,'Honorarios Walter Rozas',NULL,1,'2022-11-28 23:29:43','2022-11-29 23:24:44','2022-11-29 23:24:44'),(218,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',80000.00,NULL,NULL,1,'2022-11-28 23:32:50','2022-11-28 23:32:50',NULL),(219,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',6818.00,NULL,NULL,1,'2022-11-28 23:36:16','2022-11-28 23:36:16',NULL),(220,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',61000.00,NULL,NULL,1,'2022-11-28 23:38:17','2022-11-28 23:38:17',NULL),(221,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',46783.24,NULL,NULL,1,'2022-11-28 23:42:56','2022-11-28 23:42:56',NULL),(222,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',13343.41,NULL,NULL,1,'2022-11-28 23:43:32','2022-11-28 23:43:32',NULL),(223,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',60000.00,NULL,NULL,1,'2022-11-29 00:47:58','2022-11-29 00:47:58',NULL),(224,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3082.17,NULL,NULL,1,'2022-11-29 10:17:04','2023-02-03 23:49:46','2023-02-03 23:49:46'),(225,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',846.56,NULL,NULL,1,'2022-11-29 10:22:55','2023-02-03 23:54:03','2023-02-03 23:54:03'),(226,7851,40719,11,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',64476.54,NULL,NULL,1,'2022-11-29 10:45:46','2022-11-29 10:47:09','2022-11-29 10:47:09'),(227,7851,40719,12,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',74069.77,NULL,NULL,1,'2022-11-29 10:47:09','2022-11-30 18:32:43','2022-11-30 18:32:43'),(228,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',24000.00,'Pago de Sueldos',NULL,1,'2022-11-29 10:58:56','2022-12-02 10:57:05','2022-12-02 10:57:05'),(229,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16000.00,NULL,NULL,1,'2022-11-29 11:05:37','2022-11-29 16:32:29','2022-11-29 16:32:29'),(230,7851,40719,12,3,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1050.00,NULL,NULL,1,'2022-11-29 11:14:55','2022-12-21 14:55:11','2022-12-21 14:55:11'),(231,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16000.00,'Honorarios Walter Rozas',NULL,1,'2022-11-29 16:32:29','2022-11-29 23:32:41','2022-11-29 23:32:41'),(232,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',130000.00,'Extracciones efectivo Familia HP',NULL,1,'2022-11-29 16:37:34','2022-11-29 16:37:34',NULL),(233,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',80000.00,NULL,NULL,1,'2022-11-29 19:30:18','2022-11-29 19:30:18',NULL),(234,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',235000.00,NULL,NULL,1,'2022-11-29 19:53:54','2022-11-29 22:38:20','2022-11-29 22:38:20'),(235,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',300000.00,NULL,NULL,1,'2022-11-29 19:55:27','2022-11-29 19:55:27',NULL);
INSERT INTO `balance_libro` VALUES (236,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',300000.00,NULL,NULL,1,'2022-11-29 19:56:54','2022-11-30 14:48:03','2022-11-30 14:48:03'),(237,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',83697.10,NULL,NULL,1,'2022-11-29 19:58:54','2022-11-29 19:58:54',NULL),(238,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',112966.76,NULL,NULL,1,'2022-11-29 20:00:18','2022-11-29 22:38:48','2022-11-29 22:38:48'),(239,7851,40719,13,21,NULL,NULL,NULL,175,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6201.06,NULL,NULL,1,'2022-11-29 20:08:53','2023-01-05 18:03:12','2023-01-05 18:03:12'),(240,7851,40719,13,21,NULL,NULL,NULL,176,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',13142.34,NULL,NULL,1,'2022-11-29 20:10:26','2022-12-03 19:57:07','2022-12-03 19:57:07'),(241,7851,40719,13,21,NULL,NULL,NULL,177,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',7302.76,NULL,NULL,1,'2022-11-29 20:12:34','2023-01-05 18:10:59','2023-01-05 18:10:59'),(242,7851,40719,13,21,NULL,NULL,NULL,178,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',10400.26,NULL,NULL,1,'2022-11-29 20:13:14','2023-01-05 14:30:22','2023-01-05 14:30:22'),(243,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',4000.00,NULL,NULL,1,'2022-11-29 20:22:35','2022-11-29 22:10:12','2022-11-29 22:10:12'),(244,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',3000.00,NULL,NULL,1,'2022-11-29 20:25:08','2022-11-29 20:25:08',NULL),(245,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5000.00,NULL,NULL,1,'2022-11-29 20:26:10','2022-11-29 20:26:10',NULL),(246,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',45190.00,NULL,NULL,1,'2022-11-29 20:27:58','2022-11-29 20:27:58',NULL),(247,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',81267.58,'Tarjeta Naranja',NULL,1,'2022-11-29 20:30:10','2022-11-30 15:09:00','2022-11-30 15:09:00'),(248,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2429.52,NULL,NULL,1,'2022-11-29 20:32:17','2022-11-30 15:08:01','2022-11-30 15:08:01'),(249,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2921.10,NULL,NULL,1,'2022-11-29 20:33:00','2022-11-29 20:35:07','2022-11-29 20:35:07'),(250,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1359.15,'Resma papel A4',NULL,1,'2022-11-29 20:34:11','2022-11-29 20:34:11',NULL),(251,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5857.60,NULL,NULL,1,'2022-11-29 20:35:07','2022-11-29 20:35:07',NULL),(252,7851,40719,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',500.48,NULL,NULL,1,'2022-11-29 20:39:23','2022-11-29 20:39:23',NULL),(253,7851,40719,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',104214.71,NULL,NULL,1,'2022-11-29 20:42:27','2022-11-29 23:10:29','2022-11-29 23:10:29'),(254,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',10254.03,NULL,NULL,1,'2022-11-29 20:48:26','2022-11-29 20:48:26',NULL),(255,7851,40719,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',15885.00,NULL,NULL,1,'2022-11-29 20:55:10','2022-11-29 20:55:10',NULL),(256,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1050.00,NULL,NULL,1,'2022-11-29 20:57:45','2022-11-29 20:57:45',NULL),(257,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1856.72,NULL,NULL,1,'2022-11-29 21:29:27','2022-11-29 21:29:57','2022-11-29 21:29:57'),(258,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1856.72,NULL,NULL,1,'2022-11-29 21:29:57','2023-01-04 23:47:55','2023-01-04 23:47:55');
INSERT INTO `balance_libro` VALUES (259,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1856.72,NULL,NULL,1,'2022-11-29 21:31:26','2023-01-04 23:48:26','2023-01-04 23:48:26'),(260,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',899.96,NULL,NULL,1,'2022-11-29 21:35:18','2023-01-04 23:19:09','2023-01-04 23:19:09'),(261,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',899.96,NULL,NULL,1,'2022-11-29 21:36:10','2023-01-04 23:17:50','2023-01-04 23:17:50'),(262,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',18801.15,'Pago de SUSS',NULL,1,'2022-11-29 21:38:12','2023-02-01 01:26:16','2023-02-01 01:26:16'),(263,7851,40719,13,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',53966.06,'IVA 2022 OCT',NULL,1,'2022-11-29 21:42:28','2023-02-01 00:33:43','2023-02-01 00:33:43'),(264,7851,40719,13,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',306918.00,NULL,NULL,1,'2022-11-29 21:53:08','2022-11-29 21:53:08',NULL),(265,7851,40719,13,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',306918.00,NULL,NULL,1,'2022-11-29 21:53:20','2022-11-29 21:53:20',NULL),(266,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',4000.00,'Legalización Manifestaciones de Bienes',NULL,1,'2022-11-29 22:10:12','2022-11-29 22:10:12',NULL),(267,7851,40719,13,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',90446.52,NULL,NULL,1,'2022-11-29 22:19:48','2023-01-31 02:57:38','2023-01-31 02:57:38'),(268,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1290.08,'ATM Impuesto a determinar',NULL,1,'2022-11-29 22:22:21','2022-11-29 22:22:21',NULL),(269,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',235000.00,'Extracciones efectivo Familia HP',NULL,1,'2022-11-29 22:38:20','2022-11-29 22:38:20',NULL),(270,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',112966.76,'Personales Familia HP',NULL,1,'2022-11-29 22:38:48','2022-11-29 22:38:48',NULL),(271,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',14330.00,NULL,NULL,1,'2022-11-29 22:45:23','2022-11-29 22:45:23',NULL),(272,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',88000.00,NULL,NULL,1,'2022-11-29 22:56:55','2022-11-29 22:56:55',NULL),(273,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',66095.25,NULL,NULL,1,'2022-11-29 22:58:15','2022-11-29 22:58:15',NULL),(274,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',19000.00,NULL,NULL,1,'2022-11-29 23:03:36','2022-11-30 19:42:11','2022-11-30 19:42:11'),(275,7851,40719,12,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',90442.66,NULL,NULL,1,'2022-11-29 23:05:56','2023-01-31 23:08:31','2023-01-31 23:08:31'),(276,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',100000.00,NULL,NULL,1,'2022-11-29 23:07:26','2022-11-29 23:07:26',NULL),(277,7851,40719,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4214.71,NULL,NULL,1,'2022-11-29 23:10:29','2022-11-29 23:10:29',NULL),(278,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',100000.00,NULL,NULL,1,'2022-11-29 23:11:13','2022-11-29 23:11:13',NULL),(279,7851,40719,12,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',100000.00,NULL,NULL,1,'2022-11-29 23:13:01','2022-11-29 23:13:01',NULL),(280,7851,40719,12,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',10.64,NULL,NULL,1,'2022-11-29 23:15:14','2022-11-29 23:15:14',NULL),(281,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',10254.03,NULL,NULL,1,'2022-11-29 23:17:07','2022-11-29 23:17:07',NULL);
INSERT INTO `balance_libro` VALUES (282,7851,40719,12,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',30000.00,'Honorarios Walter Rozas',NULL,1,'2022-11-29 23:23:38','2022-11-29 23:32:23','2022-11-29 23:32:23'),(283,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',50120.00,'Honorarios Walter Rozas 2022 OCT',NULL,1,'2022-11-29 23:24:44','2022-12-02 10:59:45','2022-12-02 10:59:45'),(284,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',855.00,'AsociART',NULL,1,'2022-11-29 23:31:18','2022-11-29 23:31:18',NULL),(285,7851,40719,12,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',30000.00,'Honorarios Walter Rozas 2022 SEP',NULL,1,'2022-11-29 23:32:23','2022-11-29 23:33:04','2022-11-29 23:33:04'),(286,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16000.00,'Honorarios Walter Rozas 2022 SEP',NULL,1,'2022-11-29 23:32:41','2022-11-29 23:32:41',NULL),(287,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',30000.00,'Honorarios Walter Rozas 2022 SEP',NULL,1,'2022-11-29 23:33:04','2022-11-29 23:40:56','2022-11-29 23:40:56'),(288,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16000.00,NULL,NULL,1,'2022-11-29 23:34:58','2022-11-29 23:35:26','2022-11-29 23:35:26'),(289,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16000.00,'Honorarios Walter Rozas 2022 SEP',NULL,1,'2022-11-29 23:35:26','2022-12-02 11:13:12','2022-12-02 11:13:12'),(290,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',30000.00,NULL,NULL,1,'2022-11-29 23:36:51','2022-11-29 23:37:02','2022-11-29 23:37:02'),(291,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',30000.00,'Honorarios Walter Rozas 2022 SEP',NULL,1,'2022-11-29 23:37:02','2022-12-02 11:12:04','2022-12-02 11:12:04'),(292,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',50120.00,'Honorarios Walter Rozas 2022 OCT',NULL,1,'2022-11-29 23:38:19','2022-12-02 10:59:22','2022-12-02 10:59:22'),(293,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',30000.00,'Honorarios Walter Rozas 2022 SEP',NULL,1,'2022-11-29 23:40:56','2022-12-02 10:58:30','2022-12-02 10:58:30'),(294,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',7279.47,NULL,NULL,1,'2022-11-29 23:42:34','2022-11-29 23:42:51','2022-11-29 23:42:51'),(295,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',7279.47,'Ecogas 2022 SEP',NULL,1,'2022-11-29 23:42:51','2022-11-29 23:42:51',NULL),(296,7851,40719,12,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',15226.95,NULL,NULL,1,'2022-11-29 23:43:59','2022-11-29 23:44:36','2022-11-29 23:44:36'),(297,7851,40719,12,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',15226.95,'IVA 2022 SEP',NULL,1,'2022-11-29 23:44:36','2023-02-01 00:33:00','2023-02-01 00:33:00'),(298,7851,40719,11,20,NULL,NULL,NULL,183,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',722995.00,NULL,NULL,1,'2022-11-30 09:49:55','2022-11-30 09:49:55',NULL),(299,7851,40719,12,21,NULL,NULL,NULL,184,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',238000.01,'KUU191',NULL,1,'2022-11-30 10:01:59','2022-11-30 10:01:59',NULL),(300,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',4976.00,NULL,NULL,1,'2022-11-30 12:30:37','2022-11-30 12:31:37','2022-11-30 12:31:37'),(301,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',300000.00,NULL,NULL,1,'2022-11-30 14:48:03','2022-11-30 14:48:03',NULL),(302,7851,40719,12,21,NULL,NULL,NULL,185,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',10308.08,NULL,NULL,1,'2022-11-30 15:29:07','2023-01-05 14:56:51','2023-01-05 14:56:51');
INSERT INTO `balance_libro` VALUES (303,7851,40719,12,21,NULL,NULL,NULL,186,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',19999.99,NULL,NULL,1,'2022-11-30 16:52:43','2022-11-30 16:54:15','2022-11-30 16:54:15'),(304,7851,40719,12,21,NULL,NULL,NULL,187,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',19999.99,NULL,NULL,1,'2022-11-30 16:55:10','2022-11-30 16:55:10',NULL),(305,7851,40719,12,21,NULL,NULL,NULL,188,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',18503.01,NULL,NULL,1,'2022-11-30 16:56:54','2022-11-30 16:56:54',NULL),(306,7851,40719,12,21,NULL,NULL,NULL,189,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1604.46,NULL,NULL,1,'2022-11-30 17:03:08','2022-11-30 17:03:08',NULL),(307,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1859.94,NULL,NULL,1,'2022-11-30 18:04:14','2022-11-30 18:04:14',NULL),(308,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',900.15,NULL,NULL,1,'2022-11-30 18:06:17','2022-11-30 18:06:17',NULL),(309,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1050.00,NULL,NULL,1,'2022-11-30 18:08:06','2022-11-30 18:08:06',NULL),(310,7851,40719,12,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',501.28,NULL,NULL,1,'2022-11-30 18:09:46','2022-11-30 18:09:46',NULL),(311,7851,40719,12,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',16300.00,NULL,NULL,1,'2022-11-30 18:12:23','2022-11-30 18:12:23',NULL),(312,7851,40719,13,3,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1210.00,NULL,NULL,1,'2022-11-30 18:34:37','2022-11-30 18:35:44','2022-11-30 18:35:44'),(313,7851,40719,13,3,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1210.00,NULL,NULL,1,'2022-11-30 18:35:44','2022-11-30 18:36:13','2022-11-30 18:36:13'),(314,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1880.00,'Seguro BFN849',NULL,1,'2022-11-30 18:44:40','2022-11-30 18:44:40',NULL),(315,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',4926.00,NULL,NULL,1,'2022-11-30 18:47:29','2022-11-30 18:47:42','2022-11-30 18:47:42'),(316,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',4926.00,'Seguro KUU191',NULL,1,'2022-11-30 18:47:42','2022-11-30 18:47:42',NULL),(317,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',100000.00,NULL,NULL,1,'2022-11-30 18:48:40','2022-11-30 18:49:45','2022-11-30 18:49:45'),(318,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',19000.00,'Estudio Contable HP',NULL,1,'2022-11-30 19:14:43','2022-11-30 19:14:43',NULL),(319,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',88950.24,NULL,NULL,1,'2022-11-30 19:33:28','2022-12-03 17:10:37','2022-12-03 17:10:37'),(320,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1880.00,'Seguro BFN849',NULL,1,'2022-11-30 19:35:02','2022-11-30 19:35:02',NULL),(321,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4926.00,'Seguro KUU191',NULL,1,'2022-11-30 19:35:50','2022-11-30 19:35:50',NULL),(322,7851,40719,14,3,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7780.00,NULL,NULL,1,'2022-12-01 11:17:51','2022-12-06 16:14:00','2022-12-06 16:14:00'),(323,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',5000.00,NULL,NULL,1,'2022-12-01 15:40:29','2022-12-01 15:40:29',NULL),(324,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',28500.00,NULL,NULL,1,'2022-12-01 15:55:49','2022-12-01 15:55:49',NULL),(325,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',80000.00,NULL,NULL,1,'2022-12-01 15:56:59','2022-12-01 15:56:59',NULL),(326,7851,40719,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2146.60,NULL,NULL,1,'2022-12-01 15:59:47','2023-01-05 04:15:39','2023-01-05 04:15:39');
INSERT INTO `balance_libro` VALUES (327,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',80000.00,NULL,NULL,1,'2022-12-01 16:00:20','2022-12-01 16:00:20',NULL),(328,7851,40719,14,3,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7450.00,NULL,NULL,1,'2022-12-02 10:31:52','2022-12-06 16:13:46','2022-12-06 16:13:46'),(329,7851,40719,14,3,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',88950.94,NULL,NULL,1,'2022-12-02 10:33:29','2022-12-02 10:33:41','2022-12-02 10:33:41'),(330,7851,40719,13,3,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',88950.94,NULL,NULL,1,'2022-12-02 10:33:41','2022-12-02 10:33:41',NULL),(331,7851,40719,13,20,NULL,NULL,NULL,196,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',88950.94,NULL,NULL,1,'2022-12-02 10:34:42','2022-12-02 10:34:50','2022-12-02 10:34:50'),(332,7851,40719,13,21,NULL,NULL,NULL,197,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',88950.94,NULL,NULL,1,'2022-12-02 10:35:16','2022-12-02 10:35:16',NULL),(333,7851,40719,14,21,NULL,NULL,NULL,198,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7450.00,NULL,NULL,1,'2022-12-02 10:35:45','2022-12-06 16:09:09','2022-12-06 16:09:09'),(334,7851,40719,14,21,NULL,NULL,NULL,199,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7780.00,NULL,NULL,1,'2022-12-02 10:37:27','2022-12-06 16:09:26','2022-12-06 16:09:26'),(335,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2220.00,NULL,NULL,1,'2022-12-02 10:38:21','2022-12-03 16:01:51','2022-12-03 16:01:51'),(336,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',29880.00,'2022-11 Sueldo',NULL,1,'2022-12-02 10:41:42','2022-12-02 10:41:42',NULL),(337,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',29880.00,NULL,NULL,1,'2022-12-02 10:42:51','2022-12-02 10:42:57','2022-12-02 10:42:57'),(338,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',29880.00,'2022-11 Sueldo',NULL,1,'2022-12-02 10:42:57','2022-12-02 10:42:57',NULL),(339,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',50120.00,'Servicios WR 2022-11',NULL,1,'2022-12-02 10:43:55','2022-12-02 10:55:43','2022-12-02 10:55:43'),(340,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',50120.00,NULL,NULL,1,'2022-12-02 10:44:43','2022-12-02 10:44:51','2022-12-02 10:44:51'),(341,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',50120.00,'Servicios WR 2022-11',NULL,1,'2022-12-02 10:44:51','2022-12-02 10:55:29','2022-12-02 10:55:29'),(342,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',29880.00,NULL,NULL,1,'2022-12-02 10:47:57','2022-12-02 10:48:15','2022-12-02 10:48:15'),(343,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',29880.00,'2022-09 Sueldo',NULL,1,'2022-12-02 10:48:15','2022-12-02 10:49:04','2022-12-02 10:49:04'),(344,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',29880.00,'2022-10 Sueldo',NULL,1,'2022-12-02 10:49:04','2022-12-02 10:49:58','2022-12-02 10:49:58'),(345,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',29880.00,'2022-10 Sueldo',NULL,1,'2022-12-02 10:49:51','2022-12-02 10:49:51',NULL),(346,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',29880.00,'2022-10 Sueldo',NULL,1,'2022-12-02 10:49:58','2022-12-02 10:49:58',NULL),(347,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',24000.00,NULL,NULL,1,'2022-12-02 10:50:40','2022-12-02 10:55:58','2022-12-02 10:55:58'),(348,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',30000.00,'2022-08 Sueldo',NULL,1,'2022-12-02 10:51:25','2022-12-02 10:52:27','2022-12-02 10:52:27');
INSERT INTO `balance_libro` VALUES (349,7851,40719,11,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',30000.00,'2022-08 Sueldo',NULL,1,'2022-12-02 10:52:03','2022-12-02 10:57:28','2022-12-02 10:57:28'),(350,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',30000.00,'2022-08 Sueldo',NULL,1,'2022-12-02 10:52:27','2022-12-02 10:57:36','2022-12-02 10:57:36'),(351,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',50120.00,'2022-11 Servicios WR',NULL,1,'2022-12-02 10:55:29','2022-12-02 11:00:06','2022-12-02 11:00:06'),(352,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',50120.00,'2022-11 Servicios WR',NULL,1,'2022-12-02 10:55:43','2022-12-02 11:00:27','2022-12-02 11:00:27'),(353,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',24000.00,'2022-09 Sueldo',NULL,1,'2022-12-02 10:55:58','2022-12-02 10:55:58',NULL),(354,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',24000.00,'2022-09 Sueldo',NULL,1,'2022-12-02 10:57:05','2022-12-02 10:57:05',NULL),(355,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',30000.00,'2022-08 Sueldo',NULL,1,'2022-12-02 10:57:28','2022-12-02 11:18:49','2022-12-02 11:18:49'),(356,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',30000.00,'2022-08 Sueldo',NULL,1,'2022-12-02 10:57:36','2022-12-02 11:19:37','2022-12-02 11:19:37'),(357,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',30000.00,'2022-09 Servicios WR',NULL,1,'2022-12-02 10:58:30','2022-12-02 10:58:30',NULL),(358,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',50120.00,'2022-10 Servicios WR',NULL,1,'2022-12-02 10:59:22','2022-12-02 11:03:42','2022-12-02 11:03:42'),(359,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',50120.00,'2022-11 Servicios WR',NULL,1,'2022-12-02 10:59:45','2022-12-02 11:03:32','2022-12-02 11:03:32'),(360,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',50120.00,'2022-11 Servicios WR',NULL,1,'2022-12-02 11:00:27','2022-12-02 11:00:27',NULL),(361,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',50120.00,NULL,NULL,1,'2022-12-02 11:01:05','2022-12-02 11:03:13','2022-12-02 11:03:13'),(362,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',50120.00,'2022-11 Servicios WR',NULL,1,'2022-12-02 11:03:13','2022-12-02 11:03:13',NULL),(363,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',50120.00,'2022-10 Servicios WR',NULL,1,'2022-12-02 11:03:32','2022-12-02 11:03:32',NULL),(364,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',50120.00,'2022-10 Servicios WR',NULL,1,'2022-12-02 11:03:42','2022-12-02 11:17:48','2022-12-02 11:17:48'),(365,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',30000.00,NULL,NULL,1,'2022-12-02 11:06:05','2022-12-02 11:08:00','2022-12-02 11:08:00'),(366,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',30000.00,'2022-08 Servicios WR',NULL,1,'2022-12-02 11:07:40','2022-12-02 11:07:40',NULL),(367,7851,40719,11,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',30000.00,'2022-08 Servicios WR',NULL,1,'2022-12-02 11:08:00','2022-12-02 11:08:00',NULL),(368,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',30000.00,'2022-09 Servicios WR',NULL,1,'2022-12-02 11:12:04','2022-12-02 11:12:04',NULL),(369,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16000.00,'Honorarios Walter Rozas 2022 SEP',NULL,1,'2022-12-02 11:13:12','2022-12-02 11:13:21','2022-12-02 11:13:21');
INSERT INTO `balance_libro` VALUES (370,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16000.00,'2022-09 Servicios WR',NULL,1,'2022-12-02 11:13:21','2022-12-02 11:13:21',NULL),(371,7851,40719,11,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',16000.00,NULL,NULL,1,'2022-12-02 11:14:48','2022-12-02 11:15:00','2022-12-02 11:15:00'),(372,7851,40719,11,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',16000.00,'2022-08 Sueldo',NULL,1,'2022-12-02 11:15:00','2022-12-02 11:15:20','2022-12-02 11:15:20'),(373,7851,40719,11,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',16000.00,'2022-08 Servicios WR',NULL,1,'2022-12-02 11:15:20','2022-12-02 11:15:20',NULL),(374,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',16000.00,NULL,NULL,1,'2022-12-02 11:15:50','2022-12-02 11:15:56','2022-12-02 11:15:56'),(375,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',16000.00,'2022-08 Servicios WR',NULL,1,'2022-12-02 11:15:57','2022-12-02 11:15:57',NULL),(376,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',50120.00,'2022-10 Servicios WR',NULL,1,'2022-12-02 11:17:48','2022-12-02 11:17:48',NULL),(377,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',24000.00,'2022-08 Sueldo',NULL,1,'2022-12-02 11:18:49','2022-12-02 11:19:44','2022-12-02 11:19:44'),(378,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',24000.00,'2022-08 Sueldo',NULL,1,'2022-12-02 11:19:37','2022-12-02 11:19:37',NULL),(379,7851,40719,11,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',24000.00,'2022-08 Sueldo',NULL,1,'2022-12-02 11:19:44','2022-12-02 11:19:44',NULL),(380,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',17741.88,NULL,NULL,1,'2022-12-02 12:43:50','2022-12-02 12:44:07','2022-12-02 12:44:07'),(381,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',17741.88,'Gastos Casa Las Heras 175 Servicios',NULL,1,'2022-12-02 12:44:07','2022-12-02 12:44:07',NULL),(382,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',75124.87,NULL,NULL,1,'2022-12-02 12:45:21','2022-12-02 12:45:21',NULL),(383,7851,40719,11,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',90438.88,'2022-09 Jubilación',NULL,1,'2022-12-02 12:48:05','2022-12-02 12:48:05',NULL),(384,7851,40719,11,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',260000.00,'R M Poblet',NULL,1,'2022-12-02 12:49:11','2022-12-02 12:49:11',NULL),(385,7851,40719,11,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',4.36,NULL,NULL,1,'2022-12-02 12:51:33','2022-12-02 12:51:33',NULL),(386,7851,40719,11,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',503.37,NULL,NULL,1,'2022-12-02 12:52:14','2022-12-02 12:52:14',NULL),(387,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',8386.57,'2022-09 Banco Supervielle Cuota préstamo',NULL,1,'2022-12-02 12:56:19','2022-12-02 12:56:45','2022-12-02 12:56:45'),(388,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',9869.60,'2022-09 Banco Supervielle Cuota préstamo',NULL,1,'2022-12-02 12:56:45','2023-03-03 11:42:27','2023-03-03 11:42:27'),(389,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',106948.00,NULL,NULL,1,'2022-12-02 12:59:14','2022-12-02 12:59:14',NULL),(390,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',40846.28,'2022-08 Tarjeta Naranja',NULL,1,'2022-12-02 13:01:07','2022-12-02 13:01:07',NULL),(391,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',5559.50,NULL,NULL,1,'2022-12-02 13:02:20','2022-12-02 13:02:20',NULL);
INSERT INTO `balance_libro` VALUES (392,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',160000.00,NULL,NULL,1,'2022-12-02 13:03:28','2022-12-02 13:05:50','2022-12-02 13:05:50'),(393,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',350000.00,NULL,NULL,1,'2022-12-02 13:05:29','2022-12-02 13:06:03','2022-12-02 13:06:03'),(394,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',160000.00,'2022-09 Familia HP Efectivo',NULL,1,'2022-12-02 13:05:50','2022-12-02 13:05:50',NULL),(395,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',350000.00,'2022-09 Familia HP BBVA',NULL,1,'2022-12-02 13:06:03','2022-12-02 13:06:03',NULL),(396,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1050.00,'2022-09 Banco Supervielle Mantenimiento',NULL,1,'2022-12-02 13:08:16','2022-12-02 13:08:16',NULL),(397,7851,40719,11,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',64476.54,'2022-09 Banco Supervielle saldo inicial',NULL,1,'2022-12-02 13:10:50','2022-12-02 13:10:50',NULL),(398,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',15797.25,'21402-0167-OC22 Sellado ATM',NULL,1,'2022-12-02 13:13:25','2022-12-02 13:13:25',NULL),(399,7851,40719,11,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',942.09,'A determinar',NULL,1,'2022-12-02 13:14:55','2022-12-02 13:15:32','2022-12-02 13:15:32'),(400,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',942.09,'A determinar',NULL,1,'2022-12-02 13:15:32','2022-12-02 13:15:32',NULL),(401,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2504.97,'2022-08 Banco Supervielle Tarjeta VISA',NULL,1,'2022-12-02 13:19:39','2022-12-02 13:19:39',NULL),(402,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',899.96,'2022-08 Banco Supervielle Tarjeta MasterCard',NULL,1,'2022-12-02 13:20:18','2022-12-02 13:20:18',NULL),(403,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',12500.00,'EAHP Viaje Carolina',NULL,1,'2022-12-02 13:26:36','2022-12-02 13:26:36',NULL),(404,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',45237.00,NULL,NULL,1,'2022-12-02 13:28:19','2022-12-02 13:29:20','2022-12-02 13:29:20'),(405,7851,40719,11,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',45237.00,NULL,NULL,1,'2022-12-02 13:29:02','2022-12-02 13:29:26','2022-12-02 13:29:26'),(406,7851,40719,11,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',45237.00,NULL,NULL,1,'2022-12-02 13:29:20','2022-12-02 23:28:30','2022-12-02 23:28:30'),(407,7851,40719,11,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',45237.00,NULL,NULL,1,'2022-12-02 13:29:26','2022-12-02 13:29:26',NULL),(408,7851,40719,11,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',48000.00,NULL,NULL,1,'2022-12-02 13:31:11','2022-12-02 13:36:53','2022-12-02 13:36:53'),(409,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',578.95,'2022-09 Asociart',NULL,1,'2022-12-02 13:33:10','2022-12-02 13:33:10',NULL),(410,7851,40719,11,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',48000.00,'Movimiento entre cuentas',NULL,1,'2022-12-02 13:36:53','2022-12-02 23:20:00','2022-12-02 23:20:00'),(411,7851,40719,11,21,NULL,NULL,NULL,200,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1604.46,NULL,NULL,1,'2022-12-02 13:38:15','2022-12-02 13:38:15',NULL),(412,7851,40719,11,21,NULL,NULL,NULL,201,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',47446.58,NULL,NULL,1,'2022-12-02 13:40:04','2022-12-02 13:40:04',NULL),(413,7851,40719,11,21,NULL,NULL,NULL,202,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',17379.07,NULL,NULL,1,'2022-12-02 13:40:52','2022-12-02 13:40:52',NULL);
INSERT INTO `balance_libro` VALUES (414,7851,40719,11,21,NULL,NULL,NULL,203,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',3549.99,NULL,NULL,1,'2022-12-02 13:41:46','2022-12-02 13:41:46',NULL),(415,7851,40719,11,21,NULL,NULL,NULL,204,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',5099.30,NULL,NULL,1,'2022-12-02 13:42:59','2022-12-02 13:42:59',NULL),(416,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',3974.00,'2022-09 Seguro KUU191',NULL,1,'2022-12-02 13:44:39','2022-12-02 13:44:39',NULL),(417,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1880.00,'2022-09 Seguro BFN849',NULL,1,'2022-12-02 13:45:15','2022-12-02 13:45:15',NULL),(418,7851,40719,11,21,NULL,NULL,NULL,205,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',20000.00,NULL,NULL,1,'2022-12-02 13:47:35','2022-12-02 13:47:35',NULL),(419,7851,40719,11,21,NULL,NULL,NULL,206,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',18000.00,NULL,NULL,1,'2022-12-02 13:48:33','2022-12-02 13:50:06','2022-12-02 13:50:06'),(420,7851,40719,11,21,NULL,NULL,NULL,207,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',16300.00,NULL,NULL,1,'2022-12-02 13:49:31','2022-12-02 13:50:12','2022-12-02 13:50:12'),(421,7851,40719,11,21,NULL,NULL,NULL,208,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',17001.19,NULL,NULL,1,'2022-12-02 13:50:57','2022-12-02 13:50:57',NULL),(422,7851,40719,11,21,NULL,NULL,NULL,209,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',16300.00,NULL,NULL,1,'2022-12-02 13:53:07','2022-12-02 13:53:07',NULL),(423,7851,40719,11,21,NULL,NULL,NULL,210,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',5500.31,NULL,NULL,1,'2022-12-02 14:23:17','2022-12-02 14:23:17',NULL),(424,7851,40719,11,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6698.71,'Diferencias combustible 2022-09',NULL,1,'2022-12-02 14:26:09','2023-01-31 21:36:39','2023-01-31 21:36:39'),(425,7851,40719,11,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',48000.00,'Movimiento entre cuentas',NULL,1,'2022-12-02 23:20:00','2022-12-02 23:20:00',NULL),(426,7851,40719,11,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',32737.00,NULL,NULL,1,'2022-12-02 23:28:30','2022-12-03 00:24:17','2022-12-03 00:24:17'),(427,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2650.00,NULL,NULL,1,'2022-12-02 23:53:34','2022-12-02 23:53:34',NULL),(428,7851,40719,11,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',45237.00,NULL,NULL,1,'2022-12-03 00:24:17','2022-12-03 00:24:17',NULL),(429,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',20000.00,NULL,NULL,1,'2022-12-03 15:33:31','2022-12-03 15:33:46','2022-12-03 15:33:46'),(430,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',20000.00,'Extracción efectivo Familia HP',NULL,1,'2022-12-03 15:33:46','2022-12-03 15:33:46',NULL),(431,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1050.00,NULL,NULL,1,'2022-12-03 15:41:48','2022-12-03 18:34:47','2022-12-03 18:34:47'),(432,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',10000.00,'Extracción efectivo Familia HP',NULL,1,'2022-12-03 15:42:44','2022-12-03 15:55:21','2022-12-03 15:55:21'),(433,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1000.00,NULL,NULL,1,'2022-12-03 15:43:40','2022-12-03 15:43:40',NULL),(434,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1452.30,'2022-11 Banco Supervielle Tarjeta Visa',NULL,1,'2022-12-03 15:48:36','2023-01-04 23:58:24','2023-01-04 23:58:24'),(435,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',415.17,'2022-11 Banco Supervielle Tarjeta Mastercard',NULL,1,'2022-12-03 15:49:49','2023-01-04 23:40:08','2023-01-04 23:40:08');
INSERT INTO `balance_libro` VALUES (436,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2200.00,'Extracción efectivo Familia HP',NULL,1,'2022-12-03 15:55:21','2022-12-03 16:03:28','2022-12-03 16:03:28'),(437,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2220.00,'Personales JCH',NULL,1,'2022-12-03 16:03:28','2023-01-30 23:26:55','2023-01-30 23:26:55'),(438,7851,40719,14,21,NULL,NULL,NULL,211,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1900.00,NULL,NULL,1,'2022-12-03 16:11:59','2022-12-06 16:09:47','2022-12-06 16:09:47'),(439,7851,40719,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',9.75,'2022-11 Intereses',NULL,1,'2022-12-03 18:33:44','2022-12-03 18:33:44',NULL),(440,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1050.00,'2022-11 Banco Supervielle Mantenimiento',NULL,1,'2022-12-03 18:34:47','2022-12-03 18:34:56','2022-12-03 18:34:56'),(441,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1050.00,'2022-12 Banco Supervielle Mantenimiento',NULL,1,'2022-12-03 18:34:56','2023-01-30 23:24:16','2023-01-30 23:24:16'),(442,7851,40719,13,3,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',13142.34,NULL,NULL,1,'2022-12-03 19:58:40','2022-12-03 19:58:40',NULL),(443,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',20000.00,NULL,NULL,1,'2022-12-05 14:03:57','2022-12-05 14:03:57',NULL),(444,7851,40719,13,20,NULL,NULL,NULL,213,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',306918.00,NULL,NULL,1,'2022-12-06 11:18:08','2022-12-06 11:18:08',NULL),(445,7851,40719,13,20,NULL,NULL,NULL,214,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1175515.99,NULL,NULL,1,'2022-12-06 11:34:29','2022-12-06 11:34:29',NULL),(446,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',240000.00,'2022-12 Inversiones HP',NULL,1,'2022-12-06 12:46:55','2022-12-06 12:46:55',NULL),(447,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',63000.00,'2022-12 Banco Santander Pago Tarjetas',NULL,1,'2022-12-06 12:47:44','2022-12-06 12:47:44',NULL),(448,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',120000.00,'2022-12 Inversión 1595',NULL,1,'2022-12-06 12:57:13','2022-12-06 12:57:13',NULL),(449,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',300000.00,'2022-12 Gastos 1595',NULL,1,'2022-12-06 12:58:43','2022-12-06 12:58:43',NULL),(450,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',100000.00,'2022-12 Impuestos',NULL,1,'2022-12-06 12:59:29','2022-12-06 12:59:29',NULL),(451,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',100000.00,'2022-12 Inversiones HP Binance',NULL,1,'2022-12-06 13:00:32','2022-12-06 13:00:32',NULL),(452,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',300000.00,'2022-12 Gastos HP BBVA',NULL,1,'2022-12-06 13:01:10','2022-12-06 13:01:10',NULL),(453,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',20000.00,'2022-12 Gastos Personales EAHP',NULL,1,'2022-12-06 13:07:29','2022-12-06 13:07:29',NULL),(454,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',20000.00,NULL,NULL,1,'2022-12-06 13:08:12','2022-12-06 13:08:31','2022-12-06 13:08:31'),(455,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',20000.00,'2022-12 Gastos Personales MPHP',NULL,1,'2022-12-06 13:08:31','2022-12-06 13:08:31',NULL),(456,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',18801.15,'2022-11 Pago de SUSS',NULL,1,'2022-12-06 14:08:39','2022-12-06 14:08:39',NULL),(457,7851,40719,13,21,NULL,NULL,NULL,215,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1900.00,NULL,NULL,1,'2022-12-06 16:10:48','2023-01-05 18:44:29','2023-01-05 18:44:29');
INSERT INTO `balance_libro` VALUES (458,7851,40719,14,3,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7450.00,NULL,NULL,1,'2022-12-06 16:13:46','2022-12-06 16:13:46',NULL),(459,7851,40719,14,3,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7780.00,NULL,NULL,1,'2022-12-06 16:14:00','2022-12-06 16:14:00',NULL),(460,7851,40719,14,21,NULL,NULL,NULL,218,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7780.00,NULL,NULL,1,'2022-12-06 16:14:58','2023-01-30 23:17:18','2023-01-30 23:17:18'),(461,7851,40719,14,21,NULL,NULL,NULL,219,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7450.00,NULL,NULL,1,'2022-12-06 16:15:31','2022-12-06 16:15:31',NULL),(462,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',719.70,'A determinar',NULL,1,'2022-12-06 19:05:14','2022-12-06 19:05:14',NULL),(463,7851,40719,13,21,NULL,NULL,NULL,220,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',13142.34,NULL,NULL,1,'2022-12-06 21:32:59','2022-12-06 21:32:59',NULL),(464,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',7007.99,'0358-OC22 Sellado 1° Cuota',NULL,1,'2022-12-06 22:13:36','2022-12-12 18:28:23','2022-12-12 18:28:23'),(465,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',7007.99,'0358-OC22 Sellado 1° Cuota',NULL,1,'2022-12-12 18:28:23','2023-02-12 22:20:22','2023-02-12 22:20:22'),(466,7851,40719,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',219254.53,NULL,NULL,1,'2022-12-12 18:35:44','2022-12-12 18:36:11','2022-12-12 18:36:11'),(467,7851,40719,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',219254.53,'2022-12 Banco Santander Liquidación Plazo Fijo',NULL,1,'2022-12-12 18:36:11','2022-12-12 18:36:11',NULL),(468,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',220000.00,'2022-12 Banco Santander Constitución Plazo Fijo',NULL,1,'2022-12-12 18:37:18','2022-12-12 18:37:18',NULL),(469,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',440000.00,NULL,NULL,1,'2022-12-12 18:53:58','2022-12-12 18:55:00','2022-12-12 18:55:00'),(470,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',440000.00,'2022-12 Banco Santander Constitución Plazo Fijo',NULL,1,'2022-12-12 18:55:00','2022-12-12 18:55:00',NULL),(471,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',31200.00,NULL,NULL,1,'2022-12-12 19:03:23','2022-12-12 19:03:41','2022-12-12 19:03:41'),(472,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',31200.00,'2022-12 Binance Staking USDT',NULL,1,'2022-12-12 19:03:41','2022-12-12 19:03:41',NULL),(473,7851,40719,14,3,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1200.00,NULL,NULL,1,'2022-12-15 12:03:43','2022-12-15 12:05:10','2022-12-15 12:05:10'),(474,7851,40719,14,3,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2085.80,NULL,NULL,1,'2022-12-15 12:03:43','2022-12-15 12:03:43',NULL),(475,7851,40719,14,3,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',719.70,NULL,NULL,1,'2022-12-15 12:03:43','2022-12-15 12:03:43',NULL),(476,7851,40719,14,3,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1175.00,NULL,NULL,1,'2022-12-15 12:03:43','2022-12-15 12:05:02','2022-12-15 12:05:02'),(477,7851,40719,14,3,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',8851.49,NULL,NULL,1,'2022-12-15 12:03:43','2022-12-15 12:04:47','2022-12-15 12:04:47'),(478,7851,40719,14,3,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',6680.66,NULL,NULL,1,'2022-12-15 12:03:43','2022-12-15 12:04:26','2022-12-15 12:04:26'),(479,7851,40719,14,3,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',6680.66,NULL,NULL,1,'2022-12-15 12:04:26','2022-12-15 12:04:26',NULL);
INSERT INTO `balance_libro` VALUES (480,7851,40719,14,3,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',8851.49,NULL,NULL,1,'2022-12-15 12:04:47','2022-12-15 12:04:47',NULL),(481,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',30760.26,'2022-11 Banco Santander Tarjeta VISA','contabilidad/40719/0YWc3RubnFDMNnoEr59czYa79bpWoY9m3fDv1Ynx.bin',1,'2022-12-15 12:31:37','2022-12-15 12:31:37',NULL),(482,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',31551.71,'2022-11 Banco Santander Tarjeta AMEX','contabilidad/40719/MnLLstS73aCYCVehRXNVe2feGc6xbxQLkpnBQWtX.bin',1,'2022-12-15 12:33:37','2022-12-15 12:33:37',NULL),(483,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',506.92,'2022-10 AsociART',NULL,1,'2022-12-15 20:20:00','2022-12-15 20:20:00',NULL),(484,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',160000.00,'Movimiento para pagar sueldos',NULL,1,'2022-12-16 23:28:46','2022-12-16 23:28:46',NULL),(485,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',29880.00,'2022-11 Sueldo',NULL,1,'2022-12-17 13:16:38','2022-12-17 13:16:38',NULL),(486,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',14940.00,'2022-12 2° SAC',NULL,1,'2022-12-17 13:17:21','2022-12-17 13:17:21',NULL),(487,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',10000.00,NULL,NULL,1,'2022-12-17 13:39:24','2022-12-17 13:39:34','2022-12-17 13:39:34'),(488,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',10000.00,'Extracción efectivo Familia HP',NULL,1,'2022-12-17 13:39:34','2022-12-17 13:39:34',NULL),(489,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',40000.00,'Extracción efectivo Familia HP',NULL,1,'2022-12-17 13:42:05','2022-12-17 13:42:05',NULL),(490,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4987.00,NULL,NULL,1,'2022-12-17 13:49:11','2022-12-22 18:27:53','2022-12-22 18:27:53'),(491,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',8386.56,NULL,NULL,1,'2022-12-17 13:50:38','2022-12-17 13:51:11','2022-12-17 13:51:11'),(492,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',8386.56,'2022-12 Banco Supervielle Préstamo Personal',NULL,1,'2022-12-17 13:51:11','2023-01-30 21:00:44','2023-01-30 21:00:44'),(493,7851,40719,13,15,NULL,331,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',170028.92,NULL,NULL,1,'2022-12-21 12:17:17','2023-01-05 10:40:35','2023-01-05 10:40:35'),(494,7851,40719,11,15,NULL,300,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',68700.88,NULL,NULL,1,'2022-12-21 12:18:11','2022-12-21 12:21:00','2022-12-21 12:21:00'),(495,7851,40719,10,15,NULL,86,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',26924.00,NULL,NULL,1,'2022-12-21 12:21:24','2023-01-05 10:40:25','2023-01-05 10:40:25'),(496,7851,40719,11,3,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',16300.00,NULL,NULL,1,'2022-12-21 12:41:15','2023-01-05 11:13:25','2023-01-05 11:13:25'),(497,7851,40719,11,15,NULL,332,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',74005.92,NULL,NULL,1,'2022-12-21 13:13:02','2022-12-21 13:15:12','2022-12-21 13:15:12'),(498,7851,40719,11,15,NULL,337,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',72830.80,NULL,NULL,1,'2022-12-21 13:26:16','2023-01-05 10:40:30','2023-01-05 10:40:30'),(499,7851,40719,12,15,NULL,343,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',170982.00,NULL,NULL,1,'2022-12-21 15:00:44','2023-01-05 10:40:04','2023-01-05 10:40:04'),(500,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',39124.01,'2022-11 IVA',NULL,1,'2022-12-21 17:32:18','2023-02-01 00:32:01','2023-02-01 00:32:01');
INSERT INTO `balance_libro` VALUES (501,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',28500.00,NULL,NULL,1,'2022-12-21 17:36:09','2022-12-21 17:36:25','2022-12-21 17:36:25'),(502,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',28500.00,'Retiro FCI',NULL,1,'2022-12-21 17:36:25','2022-12-21 17:36:25',NULL),(503,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',120000.00,NULL,NULL,1,'2022-12-21 17:38:07','2022-12-21 17:38:18','2022-12-21 17:38:18'),(504,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',120000.00,'Retiro FCI',NULL,1,'2022-12-21 17:38:18','2022-12-21 17:38:18',NULL),(505,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5090.56,'Intereses FCI 0358-OC22',NULL,1,'2022-12-21 17:50:52','2022-12-21 17:53:17','2022-12-21 17:53:17'),(506,7851,40719,14,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5090.56,'Intereses FCI 1595',NULL,1,'2022-12-21 17:52:59','2022-12-21 17:52:59',NULL),(507,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1272.64,'Intereses FCI 0358-OC22',NULL,1,'2022-12-21 17:53:17','2022-12-21 17:54:17','2022-12-21 17:54:17'),(508,7851,40719,14,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1272.64,'Intereses FCI 0358-OC22',NULL,1,'2022-12-21 17:54:17','2022-12-21 17:54:17',NULL),(509,7851,40719,14,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',157063.24,'2022-12 Jubilación',NULL,1,'2022-12-21 18:33:23','2022-12-21 18:33:23',NULL),(510,7851,40719,14,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2064174.00,NULL,NULL,1,'2022-12-21 18:59:06','2022-12-24 01:04:03','2022-12-24 01:04:03'),(511,7851,40719,14,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2064174.00,NULL,NULL,1,'2022-12-21 18:59:06','2022-12-24 01:03:46','2022-12-24 01:03:46'),(512,7851,40719,14,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2064174.00,NULL,NULL,1,'2022-12-21 18:59:06','2022-12-24 01:03:04','2022-12-24 01:03:04'),(513,7851,40719,14,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',982940.00,NULL,NULL,1,'2022-12-21 18:59:06','2022-12-24 01:02:31','2022-12-24 01:02:31'),(514,7851,40719,14,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',50120.00,'2022-11 Egreso Servicios WR 1595',NULL,1,'2022-12-21 19:07:31','2022-12-21 19:07:31',NULL),(515,7851,40719,14,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',25060.00,'2022-12 2°SAC Egreso Servicios WR 1595',NULL,1,'2022-12-21 19:09:02','2022-12-21 19:09:02',NULL),(516,7851,40719,14,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',40000.00,'2022-12 Bono Fin de Año',NULL,1,'2022-12-21 19:09:59','2022-12-21 19:09:59',NULL),(517,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',40000.00,'2022-12 Bono Fin de Año',NULL,1,'2022-12-21 19:11:02','2022-12-21 19:11:02',NULL),(518,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',25060.00,'2022-12 2°SAC Pago Servicios WR 1595',NULL,1,'2022-12-21 19:11:41','2022-12-21 19:11:41',NULL),(519,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',50120.00,'2022-11 Pago Servicios WR 1595',NULL,1,'2022-12-21 19:12:16','2022-12-21 19:12:16',NULL),(520,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',154863.21,'Retiro FCI',NULL,1,'2022-12-21 19:36:59','2022-12-21 19:36:59',NULL),(521,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',50000.00,NULL,NULL,1,'2022-12-21 20:01:07','2022-12-21 20:01:07',NULL),(522,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',15000.00,'Pago a GIMENEZ, Jonatan',NULL,1,'2022-12-21 20:17:59','2022-12-21 20:17:59',NULL);
INSERT INTO `balance_libro` VALUES (523,7851,40719,14,3,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1200.00,NULL,NULL,1,'2022-12-21 20:31:26','2022-12-21 20:31:54','2022-12-21 20:31:54'),(524,7851,40719,14,3,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1175.00,NULL,NULL,1,'2022-12-21 20:31:26','2022-12-21 20:32:11','2022-12-21 20:32:11'),(525,7851,40719,14,3,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1631.58,NULL,NULL,1,'2022-12-21 20:31:26','2022-12-21 20:31:26',NULL),(526,7851,40719,14,3,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',12873.41,NULL,NULL,1,'2022-12-21 20:31:26','2023-01-05 10:05:33','2023-01-05 10:05:33'),(527,7851,40719,14,3,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1610.00,NULL,NULL,1,'2022-12-21 20:31:26','2022-12-21 20:32:04','2022-12-21 20:32:04'),(528,7851,40719,14,21,NULL,NULL,NULL,239,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2085.80,NULL,NULL,1,'2022-12-21 20:36:20','2022-12-21 20:36:20',NULL),(529,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',7007.99,'0358-OC22 Sellado 2° Cuota',NULL,1,'2022-12-21 20:46:48','2023-02-12 22:19:52','2023-02-12 22:19:52'),(530,7851,40719,14,3,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',324500.22,NULL,NULL,1,'2022-12-22 13:02:05','2022-12-22 13:02:05',NULL),(531,7851,40719,14,21,NULL,NULL,NULL,241,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',324500.22,NULL,NULL,1,'2022-12-22 15:38:21','2023-01-04 23:08:19','2023-01-04 23:08:19'),(532,7851,40719,14,21,NULL,NULL,NULL,242,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',8851.49,NULL,NULL,1,'2022-12-22 18:03:21','2022-12-22 18:03:21',NULL),(533,7851,40719,14,21,NULL,NULL,NULL,243,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',6680.66,NULL,NULL,1,'2022-12-22 18:04:39','2023-04-01 18:50:32','2023-04-01 18:50:32'),(534,7851,40719,14,3,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7400.01,NULL,NULL,1,'2022-12-22 18:09:21','2022-12-22 18:09:21',NULL),(535,7851,40719,14,21,NULL,NULL,NULL,245,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7400.01,NULL,NULL,1,'2022-12-22 18:10:47','2022-12-22 18:10:47',NULL),(536,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3820.00,'Carne Navidad',NULL,1,'2022-12-22 18:14:08','2022-12-22 18:14:08',NULL),(537,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',6900.00,'Salida Mikelinos',NULL,1,'2022-12-22 18:16:37','2022-12-22 18:16:37',NULL),(538,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',8386.56,'2022-12 Banco Supervielle Préstamo Personal',NULL,1,'2022-12-22 18:18:33','2023-03-03 11:42:42','2023-03-03 11:42:42'),(539,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1856.72,'2022-11 Banco Supervielle Tarjeta Visa',NULL,1,'2022-12-22 18:24:47','2022-12-22 18:26:27','2022-12-22 18:26:27'),(540,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',899.96,'2022-12 Banco Supervielle Tarjeta Mastercard',NULL,1,'2022-12-22 18:26:13','2022-12-22 18:26:36','2022-12-22 18:26:36'),(541,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1856.72,'2022-11 Banco Supervielle Tarjeta Visa',NULL,1,'2022-12-22 18:26:27','2023-01-04 23:47:12','2023-01-04 23:47:12'),(542,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',899.96,'2022-11 Banco Supervielle Tarjeta Mastercard',NULL,1,'2022-12-22 18:26:36','2023-01-04 23:19:44','2023-01-04 23:19:44'),(543,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4987.00,'Tubos fluorescentes',NULL,1,'2022-12-22 18:27:53','2022-12-22 18:27:53',NULL),(544,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',124000.00,'Banco Santander Constitución FCI 1595',NULL,1,'2022-12-22 19:06:30','2022-12-22 19:06:30',NULL);
INSERT INTO `balance_libro` VALUES (545,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',31000.00,'Banco Santander Constitución FCI 0358-OC22',NULL,1,'2022-12-22 19:07:32','2022-12-22 19:07:32',NULL),(546,7851,40719,14,3,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',51360.00,NULL,NULL,1,'2022-12-24 00:49:01','2022-12-24 00:49:01',NULL),(547,7851,40719,14,3,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2022-12-24 00:50:33','2022-12-24 00:54:39','2022-12-24 00:54:39'),(548,7851,40719,14,3,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',10000.01,NULL,NULL,1,'2022-12-24 00:51:31','2022-12-24 00:51:31',NULL),(549,7851,40719,14,3,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',19958.00,NULL,NULL,1,'2022-12-24 00:52:12','2022-12-24 00:52:12',NULL),(550,7851,40719,14,3,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',8080.00,NULL,NULL,1,'2022-12-24 00:53:39','2022-12-24 00:53:39',NULL),(551,7851,40719,14,3,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11500.00,NULL,NULL,1,'2022-12-24 00:54:25','2022-12-24 00:54:25',NULL),(552,7851,40719,14,3,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2022-12-24 00:54:39','2022-12-24 00:54:39',NULL),(553,7851,40719,14,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',982940.00,NULL,NULL,1,'2022-12-24 01:02:31','2022-12-24 01:04:35','2022-12-24 01:04:35'),(554,7851,40719,14,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2064174.00,NULL,NULL,1,'2022-12-24 01:03:04','2022-12-24 01:04:28','2022-12-24 01:04:28'),(555,7851,40719,14,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2280912.27,NULL,NULL,1,'2022-12-24 01:03:46','2022-12-24 01:04:20','2022-12-24 01:04:20'),(556,7851,40719,14,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2064174.00,NULL,NULL,1,'2022-12-24 01:04:03','2022-12-24 01:04:03',NULL),(557,7851,40719,14,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2064174.00,NULL,NULL,1,'2022-12-24 01:04:20','2022-12-24 01:04:20',NULL),(558,7851,40719,14,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2064174.00,NULL,NULL,1,'2022-12-24 01:04:28','2022-12-24 01:04:28',NULL),(559,7851,40719,14,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',982940.00,NULL,NULL,1,'2022-12-24 01:04:35','2022-12-30 19:06:11','2022-12-30 19:06:11'),(560,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',40000.00,'Extracción efectivo Familia HP',NULL,1,'2022-12-24 19:41:56','2022-12-24 19:41:56',NULL),(561,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',10000.00,'Extracción efectivo Familia HP',NULL,1,'2022-12-24 19:42:28','2022-12-24 19:42:28',NULL),(562,7851,40719,14,20,NULL,NULL,NULL,260,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',10000.01,NULL,NULL,1,'2022-12-24 19:57:16','2022-12-24 19:57:23','2022-12-24 19:57:23'),(563,7851,40719,14,21,NULL,NULL,NULL,261,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',10000.01,NULL,NULL,1,'2022-12-24 19:57:53','2022-12-24 19:57:53',NULL),(564,7851,40719,14,21,NULL,NULL,NULL,262,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',19958.00,NULL,NULL,1,'2022-12-24 19:58:34','2022-12-24 19:58:34',NULL),(565,7851,40719,14,21,NULL,NULL,NULL,263,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11500.00,NULL,NULL,1,'2022-12-24 20:19:09','2022-12-24 20:19:09',NULL),(566,7851,40719,14,21,NULL,NULL,NULL,264,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',8080.00,NULL,NULL,1,'2022-12-24 20:20:34','2022-12-24 20:20:34',NULL),(567,7851,40719,14,21,NULL,NULL,NULL,265,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7400.01,NULL,NULL,1,'2022-12-24 20:22:41','2022-12-24 20:23:48','2022-12-24 20:23:48');
INSERT INTO `balance_libro` VALUES (568,7851,40719,14,21,NULL,NULL,NULL,266,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7400.01,NULL,NULL,1,'2022-12-24 20:26:30','2022-12-24 20:26:46','2022-12-24 20:26:46'),(569,7851,40719,14,21,NULL,NULL,NULL,267,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2022-12-24 20:29:32','2022-12-24 20:29:32',NULL),(570,7851,40719,14,21,NULL,NULL,NULL,268,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',51360.00,NULL,NULL,1,'2022-12-24 20:33:27','2023-01-04 23:06:35','2023-01-04 23:06:35'),(571,7851,40719,14,21,NULL,NULL,NULL,269,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',224850.02,NULL,NULL,1,'2022-12-24 20:37:01','2022-12-24 20:37:18','2022-12-24 20:37:18'),(572,7851,40719,12,21,NULL,NULL,NULL,270,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',224850.02,NULL,NULL,1,'2022-12-24 20:37:48','2023-01-04 23:00:50','2023-01-04 23:00:50'),(573,7851,40719,14,21,NULL,NULL,NULL,271,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',719.70,NULL,NULL,1,'2022-12-24 20:38:43','2022-12-24 20:38:43',NULL),(574,7851,40719,11,21,NULL,NULL,NULL,272,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7350.01,NULL,NULL,1,'2022-12-24 20:43:13','2022-12-24 20:43:13',NULL),(575,7851,40719,14,3,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',5544.19,NULL,NULL,1,'2022-12-26 22:52:53','2022-12-26 22:52:53',NULL),(576,7851,40719,14,21,NULL,NULL,NULL,274,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',5544.19,NULL,NULL,1,'2022-12-26 22:53:32','2022-12-26 22:53:32',NULL),(577,7851,40719,14,21,NULL,NULL,NULL,275,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',12873.41,NULL,NULL,1,'2022-12-27 20:59:15','2023-01-05 10:04:17','2023-01-05 10:04:17'),(578,7851,40719,14,21,NULL,NULL,NULL,276,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3188.24,NULL,NULL,1,'2022-12-27 21:00:17','2022-12-27 21:00:17',NULL),(579,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',506.92,'2022-12 Diferencia alícuota AsociART',NULL,1,'2022-12-27 21:01:52','2022-12-27 21:01:52',NULL),(580,7851,40719,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',90950.00,'Acreditación crédito ANSES',NULL,1,'2022-12-27 21:25:49','2022-12-27 21:26:52','2022-12-27 21:26:52'),(581,7851,40719,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',90950.00,'Acreditación crédito ANSES NC',NULL,1,'2022-12-27 21:26:43','2022-12-27 21:26:43',NULL),(582,7851,40719,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',90950.00,'Acreditación crédito ANSES C',NULL,1,'2022-12-27 21:26:52','2022-12-27 21:26:52',NULL),(583,7851,40719,14,3,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',8004.00,NULL,NULL,1,'2022-12-27 21:32:52','2022-12-27 21:32:52',NULL),(584,7851,40719,14,3,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1080.00,NULL,NULL,1,'2022-12-27 21:33:30','2022-12-27 21:33:30',NULL),(585,7851,40719,14,3,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',13024.00,NULL,NULL,1,'2022-12-27 21:35:51','2022-12-27 21:36:44','2022-12-27 21:36:44'),(586,7851,40719,14,3,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',212.00,NULL,NULL,1,'2022-12-27 21:36:34','2022-12-27 21:36:34',NULL),(587,7851,40719,14,3,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',13024.00,NULL,NULL,1,'2022-12-27 21:36:44','2023-01-13 21:09:13','2023-01-13 21:09:13'),(588,7851,40719,14,3,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',11496.00,NULL,NULL,1,'2022-12-29 16:34:02','2022-12-29 16:34:02',NULL),(589,7851,40719,14,3,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',7014.40,NULL,NULL,1,'2022-12-29 16:34:51','2022-12-29 16:34:51',NULL),(590,7851,40719,14,3,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',20111.03,NULL,NULL,1,'2022-12-29 16:35:23','2022-12-29 16:35:23',NULL);
INSERT INTO `balance_libro` VALUES (591,7851,40719,14,21,NULL,NULL,NULL,285,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',33806.09,NULL,NULL,1,'2022-12-29 16:36:23','2022-12-29 16:36:23',NULL),(592,7851,40719,14,21,NULL,NULL,NULL,286,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',11496.00,NULL,NULL,1,'2022-12-29 16:37:37','2023-01-04 23:04:57','2023-01-04 23:04:57'),(593,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',103070.02,'Tarjeta Naranja',NULL,1,'2022-12-29 16:55:16','2022-12-29 16:55:32','2022-12-29 16:55:32'),(594,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',103070.02,'2022-12 Tarjeta Naranja',NULL,1,'2022-12-29 16:55:32','2022-12-29 16:55:46','2022-12-29 16:55:46'),(595,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',103070.02,'2022-12 Tarjeta Naranja',NULL,1,'2022-12-29 16:55:46','2022-12-29 16:55:46',NULL),(596,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2981.40,'2022-12 Ecogas',NULL,1,'2022-12-29 16:56:44','2022-12-29 16:56:44',NULL),(597,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',30000.00,'Extracción efectivo Familia HP',NULL,1,'2022-12-29 16:57:23','2022-12-29 16:57:23',NULL),(598,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',120000.00,'2022-12 Movimiento para pagar tarjetas',NULL,1,'2022-12-29 17:38:11','2022-12-29 17:38:11',NULL),(599,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',250000.00,'2022-12 Ahorro',NULL,1,'2022-12-29 17:38:37','2022-12-29 17:38:37',NULL),(600,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',250000.00,'2022-12 Ahorro',NULL,1,'2022-12-29 17:38:37','2023-01-30 14:32:00','2023-01-30 14:32:00'),(601,7851,40719,14,3,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2500.00,NULL,NULL,1,'2022-12-30 15:55:21','2022-12-30 15:55:21',NULL),(602,7851,40719,14,3,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1999.96,NULL,NULL,1,'2022-12-30 15:56:35','2022-12-30 15:56:35',NULL),(603,7851,40719,14,3,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',153450.00,NULL,NULL,1,'2022-12-30 15:57:45','2022-12-30 15:57:45',NULL),(604,7851,40719,14,21,NULL,NULL,NULL,290,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2500.00,NULL,NULL,1,'2022-12-30 16:00:14','2022-12-30 16:00:14',NULL),(605,7851,40719,14,21,NULL,NULL,NULL,291,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1999.96,NULL,NULL,1,'2022-12-30 16:00:47','2022-12-30 16:00:47',NULL),(606,7851,40719,14,21,NULL,NULL,NULL,292,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',153450.00,NULL,NULL,1,'2022-12-30 16:01:13','2022-12-30 16:01:13',NULL),(607,7851,40719,14,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',982940.00,NULL,NULL,1,'2022-12-30 19:06:11','2022-12-30 19:06:48','2022-12-30 19:06:48'),(608,7851,40719,14,3,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',80000.00,NULL,NULL,1,'2022-12-31 13:06:39','2022-12-31 13:06:39',NULL),(609,7851,40719,14,21,NULL,NULL,NULL,295,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',80000.00,NULL,NULL,1,'2022-12-31 13:07:25','2022-12-31 13:07:25',NULL),(610,7851,40719,18,3,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2500.00,NULL,NULL,1,'2023-01-02 10:14:07','2023-01-02 10:14:07',NULL),(611,7851,40719,14,3,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4500.00,NULL,NULL,1,'2023-01-02 10:15:58','2023-01-02 10:15:58',NULL),(612,7851,40719,14,21,NULL,NULL,NULL,298,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4500.00,NULL,NULL,1,'2023-01-02 10:16:41','2023-01-05 01:20:29','2023-01-05 01:20:29'),(613,7851,40719,18,21,NULL,NULL,NULL,299,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2500.00,NULL,NULL,1,'2023-01-02 10:17:10','2023-01-02 10:17:10',NULL);
INSERT INTO `balance_libro` VALUES (614,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1449.99,'2023-01 Banco Supervielle Mantenimiento',NULL,1,'2023-01-04 19:55:41','2023-01-04 20:00:41','2023-01-04 20:00:41'),(615,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',20000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-04 19:56:40','2023-01-04 19:57:17','2023-01-04 19:57:17'),(616,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',40000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-04 19:57:09','2023-01-04 19:57:09',NULL),(617,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',20000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-04 19:57:17','2023-01-04 19:57:17',NULL),(618,7851,40719,14,3,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1050.00,NULL,NULL,1,'2023-01-04 20:02:47','2023-01-04 20:04:50','2023-01-04 20:04:50'),(619,7851,40719,18,3,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1449.99,NULL,NULL,1,'2023-01-04 20:04:04','2023-01-04 20:04:04',NULL),(620,7851,40719,14,3,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1050.00,NULL,NULL,1,'2023-01-04 20:04:50','2023-01-04 20:04:50',NULL),(621,7851,40719,14,21,NULL,NULL,NULL,303,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1050.00,NULL,NULL,1,'2023-01-04 20:06:06','2023-01-04 20:06:06',NULL),(622,7851,40719,18,21,NULL,NULL,NULL,304,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1449.99,NULL,NULL,1,'2023-01-04 20:06:47','2023-01-30 13:22:53','2023-01-30 13:22:53'),(623,7851,40719,14,3,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1200.00,NULL,NULL,1,'2023-01-04 21:02:04','2023-01-04 21:02:41','2023-01-04 21:02:41'),(624,7851,40719,14,3,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1175.00,NULL,NULL,1,'2023-01-04 21:02:04','2023-01-04 21:02:49','2023-01-04 21:02:49'),(625,7851,40719,14,3,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1610.00,NULL,NULL,1,'2023-01-04 21:02:04','2023-01-04 21:02:44','2023-01-04 21:02:44'),(626,7851,40719,14,21,NULL,NULL,NULL,308,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',224850.02,NULL,NULL,1,'2023-01-04 23:01:53','2023-01-04 23:03:28','2023-01-04 23:03:28'),(627,7851,40719,12,21,NULL,NULL,NULL,309,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',224850.02,NULL,NULL,1,'2023-01-04 23:04:13','2023-01-04 23:04:13',NULL),(628,7851,40719,14,21,NULL,NULL,NULL,310,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',11496.00,NULL,NULL,1,'2023-01-04 23:05:40','2023-01-04 23:05:40',NULL),(629,7851,40719,14,21,NULL,NULL,NULL,311,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',324500.22,NULL,NULL,1,'2023-01-04 23:10:53','2023-01-04 23:10:53',NULL),(630,7851,40719,14,21,NULL,NULL,NULL,312,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',51360.00,NULL,NULL,1,'2023-01-04 23:12:07','2023-01-04 23:12:07',NULL),(631,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',899.96,'2022-10 Banco Supervielle Tarjeta Mastercard',NULL,1,'2023-01-04 23:17:50','2023-01-04 23:17:50',NULL),(632,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',899.96,NULL,NULL,1,'2023-01-04 23:19:09','2023-01-04 23:19:09',NULL),(633,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',899.96,'2022-11 Banco Supervielle Tarjeta Mastercard',NULL,1,'2023-01-04 23:19:44','2023-01-04 23:19:44',NULL),(634,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',899.96,'2022-08 Banco Supervielle Tarjeta MasterCard',NULL,1,'2023-01-04 23:34:16','2023-01-04 23:34:16',NULL),(635,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',900.15,'2022-09 Banco Supervielle Tarjeta Mastercard',NULL,1,'2023-01-04 23:37:05','2023-01-04 23:37:05',NULL);
INSERT INTO `balance_libro` VALUES (636,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',899.96,'2022-11 Banco Supervielle Tarjeta Mastercard',NULL,1,'2023-01-04 23:38:08','2023-01-04 23:38:08',NULL),(637,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',415.17,'2022-11 Banco Supervielle Seguro de vida',NULL,1,'2023-01-04 23:40:08','2023-01-04 23:40:08',NULL),(638,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1856.72,'2022-11 Banco Supervielle Tarjeta Visa',NULL,1,'2023-01-04 23:47:12','2023-01-04 23:47:12',NULL),(639,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1856.72,'2022-10 Banco Supervielle Tarjeta Visa',NULL,1,'2023-01-04 23:47:55','2023-01-04 23:49:49','2023-01-04 23:49:49'),(640,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1856.72,'2022-10 Banco Supervielle Tarjeta Visa',NULL,1,'2023-01-04 23:48:26','2023-01-04 23:48:26',NULL),(641,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1856.72,'2022-10 Banco Supervielle Tarjeta Visa',NULL,1,'2023-01-04 23:49:49','2023-01-04 23:49:49',NULL),(642,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2504.97,'2022-08 Banco Supervielle Tarjeta VISA',NULL,1,'2023-01-04 23:52:36','2023-01-04 23:52:36',NULL),(643,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1859.94,'2022-09 Banco Supervielle Tarjeta Visa',NULL,1,'2023-01-04 23:57:21','2023-01-04 23:57:21',NULL),(644,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1452.30,'2022-11 Banco Supervielle Seguro de vida',NULL,1,'2023-01-04 23:58:24','2023-01-04 23:58:24',NULL),(645,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1856.72,'2022-11 Banco Supervielle Tarjeta Visa',NULL,1,'2023-01-04 23:59:18','2023-01-04 23:59:18',NULL),(646,7851,40719,12,21,NULL,NULL,NULL,313,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5944.63,NULL,NULL,1,'2023-01-05 00:28:13','2023-01-05 00:28:13',NULL),(647,7851,40719,14,21,NULL,NULL,NULL,314,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4500.00,NULL,NULL,1,'2023-01-05 01:21:01','2023-01-05 01:21:01',NULL),(648,7851,40719,12,21,NULL,NULL,NULL,315,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',39998.99,NULL,NULL,1,'2023-01-05 01:41:53','2023-01-05 01:41:53',NULL),(649,7851,40719,14,3,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',889.66,NULL,NULL,1,'2023-01-05 01:49:08','2023-01-05 01:49:08',NULL),(650,7851,40719,12,21,NULL,NULL,NULL,317,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2370.72,NULL,NULL,1,'2023-01-05 01:54:19','2023-01-05 01:54:19',NULL),(651,7851,40719,14,3,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',8552.00,NULL,NULL,1,'2023-01-05 01:58:11','2023-01-05 01:58:11',NULL),(652,7851,40719,14,3,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',7296.01,NULL,NULL,1,'2023-01-05 01:59:27','2023-01-05 01:59:27',NULL),(653,7851,40719,14,21,NULL,NULL,NULL,320,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',15848.01,NULL,NULL,1,'2023-01-05 02:00:17','2023-01-05 02:00:17',NULL),(654,7851,40719,12,21,NULL,NULL,NULL,321,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',19436.00,NULL,NULL,1,'2023-01-05 02:22:32','2023-01-05 20:53:00','2023-01-05 20:53:00'),(655,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4926.00,'2022-12 Seguro KUU191',NULL,1,'2023-01-05 02:30:46','2023-01-05 02:31:55','2023-01-05 02:31:55'),(656,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4859.00,'2022-12 Seguro KUU191',NULL,1,'2023-01-05 02:31:55','2023-01-05 02:38:40','2023-01-05 02:38:40'),(657,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',67.00,'2022-12 Seguro accidentes personales',NULL,1,'2023-01-05 02:33:45','2023-01-05 02:33:45',NULL);
INSERT INTO `balance_libro` VALUES (658,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4859.00,'2022-12 Seguro KUU191',NULL,1,'2023-01-05 02:38:40','2023-01-05 02:38:40',NULL),(659,7851,40719,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2146.60,NULL,NULL,1,'2023-01-05 04:20:51','2023-01-05 04:21:16','2023-01-05 04:21:16'),(660,7851,40719,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2146.60,'2022-12 Banco Santander FCI 1595 Intereses',NULL,1,'2023-01-05 04:21:16','2023-01-30 23:28:39','2023-01-30 23:28:39'),(661,7851,40719,14,3,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',12873.41,NULL,NULL,1,'2023-01-05 10:05:33','2023-01-30 15:02:54','2023-01-30 15:02:54'),(662,7851,40719,11,3,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',18000.00,NULL,NULL,1,'2023-01-05 11:13:25','2023-01-05 11:13:25',NULL),(663,7851,40719,10,15,NULL,86,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',26924.00,NULL,NULL,1,'2023-01-05 11:20:07','2023-01-05 14:24:09','2023-01-05 14:24:09'),(664,7851,40719,14,15,NULL,443,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',392286.46,NULL,NULL,1,'2023-01-05 12:15:47','2023-01-05 14:23:49','2023-01-05 14:23:49'),(665,7851,40719,13,15,NULL,331,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',170028.92,NULL,NULL,1,'2023-01-05 12:15:57','2023-01-05 14:23:56','2023-01-05 14:23:56'),(666,7851,40719,12,15,NULL,343,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',170982.00,NULL,NULL,1,'2023-01-05 12:16:04','2023-01-05 14:24:25','2023-01-05 14:24:25'),(667,7851,40719,11,15,NULL,445,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',72830.12,NULL,NULL,1,'2023-01-05 12:16:25','2023-01-05 14:24:30','2023-01-05 14:24:30'),(668,7851,40719,13,3,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',17370.88,NULL,NULL,1,'2023-01-05 14:27:06','2023-01-05 14:27:06',NULL),(669,7851,40719,13,21,NULL,NULL,NULL,325,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',17370.88,NULL,NULL,1,'2023-01-05 14:28:24','2023-01-05 14:28:24',NULL),(670,7851,40719,13,21,NULL,NULL,NULL,326,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',10400.26,NULL,NULL,1,'2023-01-05 14:31:51','2023-01-05 14:32:10','2023-01-05 14:32:10'),(671,7851,40719,13,3,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',10400.26,NULL,NULL,1,'2023-01-05 14:32:36','2023-01-05 14:44:48','2023-01-05 14:44:48'),(672,7851,40719,13,3,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',10400.26,NULL,NULL,1,'2023-01-05 14:44:48','2023-01-05 14:44:48',NULL),(673,7851,40719,13,21,NULL,NULL,NULL,329,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',10400.26,NULL,NULL,1,'2023-01-05 14:46:12','2023-01-05 14:46:12',NULL),(674,7851,40719,12,3,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',15500.00,NULL,NULL,1,'2023-01-05 14:53:10','2023-01-05 14:53:10',NULL),(675,7851,40719,12,21,NULL,NULL,NULL,331,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',15500.00,NULL,NULL,1,'2023-01-05 14:53:58','2023-01-05 14:53:58',NULL),(676,7851,40719,12,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',10308.08,NULL,NULL,1,'2023-01-05 14:57:13','2023-01-05 14:57:13',NULL),(677,7851,40719,12,21,NULL,NULL,NULL,333,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',10308.08,NULL,NULL,1,'2023-01-05 14:57:59','2023-01-05 14:57:59',NULL),(678,7851,40719,12,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1800.01,NULL,NULL,1,'2023-01-05 15:03:26','2023-01-05 15:03:26',NULL),(679,7851,40719,12,21,NULL,NULL,NULL,335,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1800.01,NULL,NULL,1,'2023-01-05 15:05:15','2023-01-05 15:05:15',NULL),(680,7851,40719,12,21,NULL,NULL,NULL,336,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',6300.01,NULL,NULL,1,'2023-01-05 15:07:41','2023-01-05 15:07:54','2023-01-05 15:07:54');
INSERT INTO `balance_libro` VALUES (681,7851,40719,12,3,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',6300.01,NULL,NULL,1,'2023-01-05 15:16:35','2023-01-05 15:16:35',NULL),(682,7851,40719,12,21,NULL,NULL,NULL,338,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',6300.01,NULL,NULL,1,'2023-01-05 15:21:03','2023-01-05 15:21:03',NULL),(683,7851,40719,12,3,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1369.96,NULL,NULL,1,'2023-01-05 15:23:42','2023-01-05 15:23:42',NULL),(684,7851,40719,12,21,NULL,NULL,NULL,340,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1369.96,NULL,NULL,1,'2023-01-05 15:25:09','2023-01-05 15:25:09',NULL),(685,7851,40719,12,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',8001.00,NULL,NULL,1,'2023-01-05 15:28:15','2023-01-05 15:28:15',NULL),(686,7851,40719,12,21,NULL,NULL,NULL,342,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',8001.00,NULL,NULL,1,'2023-01-05 15:30:03','2023-01-05 15:30:03',NULL),(687,7851,40719,13,3,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1800.05,NULL,NULL,1,'2023-01-05 15:42:20','2023-01-05 15:42:20',NULL),(688,7851,40719,13,3,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1999.99,NULL,NULL,1,'2023-01-05 15:43:43','2023-01-05 15:43:43',NULL),(689,7851,40719,13,3,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',12701.10,NULL,NULL,1,'2023-01-05 17:51:10','2023-01-05 17:51:10',NULL),(690,7851,40719,13,21,NULL,NULL,NULL,346,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',12701.10,NULL,NULL,1,'2023-01-05 17:51:41','2023-01-05 17:51:41',NULL),(691,7851,40719,13,3,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1500.00,NULL,NULL,1,'2023-01-05 17:52:38','2023-01-05 17:52:38',NULL),(692,7851,40719,13,21,NULL,NULL,NULL,348,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1500.00,NULL,NULL,1,'2023-01-05 17:53:28','2023-01-05 17:53:28',NULL),(693,7851,40719,13,3,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',13901.30,NULL,NULL,1,'2023-01-05 17:55:29','2023-01-05 17:55:29',NULL),(694,7851,40719,13,21,NULL,NULL,NULL,350,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',13901.30,NULL,NULL,1,'2023-01-05 17:56:01','2023-01-05 17:56:01',NULL),(695,7851,40719,13,3,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',4999.99,NULL,NULL,1,'2023-01-05 17:58:01','2023-01-05 17:58:01',NULL),(696,7851,40719,13,21,NULL,NULL,NULL,352,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',4999.99,NULL,NULL,1,'2023-01-05 17:58:30','2023-01-05 17:58:30',NULL),(697,7851,40719,13,3,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',19000.01,NULL,NULL,1,'2023-01-05 17:59:57','2023-01-05 17:59:57',NULL),(698,7851,40719,13,21,NULL,NULL,NULL,354,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',19000.01,NULL,NULL,1,'2023-01-05 18:00:35','2023-01-05 18:00:35',NULL),(699,7851,40719,13,3,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6201.06,NULL,NULL,1,'2023-01-05 18:04:22','2023-01-05 18:04:22',NULL),(700,7851,40719,13,3,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',24600.00,NULL,NULL,1,'2023-01-05 18:08:08','2023-01-05 18:08:08',NULL),(701,7851,40719,13,3,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',11639.99,NULL,NULL,1,'2023-01-05 18:08:33','2023-01-05 18:08:33',NULL),(702,7851,40719,13,21,NULL,NULL,NULL,358,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',36239.99,NULL,NULL,1,'2023-01-05 18:09:41','2023-01-05 18:09:41',NULL),(703,7851,40719,13,3,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',7302.76,NULL,NULL,1,'2023-01-05 18:11:40','2023-01-05 18:11:40',NULL),(704,7851,40719,13,21,NULL,NULL,NULL,360,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',7302.76,NULL,NULL,1,'2023-01-05 18:12:07','2023-01-05 18:12:07',NULL),(705,7851,40719,13,3,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1900.00,NULL,NULL,1,'2023-01-05 18:44:52','2023-01-05 18:44:52',NULL);
INSERT INTO `balance_libro` VALUES (706,7851,40719,13,21,NULL,NULL,NULL,362,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1900.00,NULL,NULL,1,'2023-01-05 18:45:27','2023-01-05 18:45:27',NULL),(707,7851,40719,13,3,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1500.00,NULL,NULL,1,'2023-01-05 18:50:30','2023-01-05 18:50:30',NULL),(708,7851,40719,13,21,NULL,NULL,NULL,364,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1500.00,NULL,NULL,1,'2023-01-05 18:51:07','2023-01-05 18:51:07',NULL),(709,7851,40719,13,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',18800.00,NULL,NULL,1,'2023-01-05 18:52:41','2023-01-05 18:52:41',NULL),(710,7851,40719,13,21,NULL,NULL,NULL,366,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',18800.00,NULL,NULL,1,'2023-01-05 18:53:12','2023-01-05 18:53:12',NULL),(711,7851,40719,13,3,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1500.02,NULL,NULL,1,'2023-01-05 18:53:52','2023-01-05 18:53:52',NULL),(712,7851,40719,13,21,NULL,NULL,NULL,368,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1500.00,NULL,NULL,1,'2023-01-05 18:55:25','2023-01-05 18:55:25',NULL),(713,7851,40719,13,3,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',4000.00,NULL,NULL,1,'2023-01-05 18:55:59','2023-01-05 18:55:59',NULL),(714,7851,40719,13,21,NULL,NULL,NULL,370,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',4000.00,NULL,NULL,1,'2023-01-05 18:56:41','2023-01-05 18:56:41',NULL),(715,7851,40719,14,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',29880.00,'2022-12 Egreso Sueldos 1595',NULL,1,'2023-01-05 19:01:06','2023-01-05 19:01:06',NULL),(716,7851,40719,14,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',14940.00,'2022-12 2° SAC',NULL,1,'2023-01-05 19:02:48','2023-01-05 19:02:48',NULL),(717,7851,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',15226.95,'2022-09 Egreso SUSS 1595',NULL,1,'2023-01-05 19:13:55','2023-01-05 19:13:55',NULL),(718,7851,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',18801.15,'2022-10 Egreso SUSS 1595',NULL,1,'2023-01-05 19:14:35','2023-01-05 19:14:35',NULL),(719,7851,40719,14,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',18801.15,'2022-11 Egreso SUSS 1595',NULL,1,'2023-01-05 19:15:28','2023-01-05 19:15:28',NULL),(720,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',15226.95,'2022-09 Pago SUSS 1595',NULL,1,'2023-01-05 19:18:52','2023-02-01 01:24:41','2023-02-01 01:24:41'),(721,7851,40719,11,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',212.00,NULL,NULL,1,'2023-01-05 20:47:01','2023-01-05 20:47:01',NULL),(722,7851,40719,11,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',268.00,NULL,NULL,1,'2023-01-05 20:49:26','2023-01-05 20:49:46','2023-01-05 20:49:46'),(723,7851,40719,11,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',268.00,NULL,NULL,1,'2023-01-05 20:49:46','2023-01-05 20:49:46',NULL),(724,7851,40719,11,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',19436.00,NULL,NULL,1,'2023-01-05 20:53:18','2023-01-05 20:58:28','2023-01-05 20:58:28'),(725,7851,40719,11,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',19436.00,NULL,NULL,1,'2023-01-05 20:58:28','2023-01-05 20:58:28',NULL),(726,7851,40719,14,21,NULL,NULL,NULL,376,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',10000.01,NULL,NULL,1,'2023-01-07 17:31:15','2023-01-07 17:31:15',NULL),(727,7851,40719,3053,3,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-30','2020-08-30',1000.01,NULL,NULL,1,'2023-01-07 17:51:18','2023-01-07 17:51:18',NULL),(728,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1094.00,'2022-12 Las Heras 175 Electricidad',NULL,1,'2023-01-09 16:23:50','2023-01-09 16:23:50',NULL);
INSERT INTO `balance_libro` VALUES (729,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1842.50,'2022-12 Las Heras 175 Electricidad1',NULL,1,'2023-01-09 16:28:33','2023-01-09 16:28:33',NULL),(730,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25000.00,'2022-12 RMPoblet',NULL,1,'2023-01-09 16:29:48','2023-01-09 16:29:48',NULL),(731,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',860.00,'2023-01 Acta defunción',NULL,1,'2023-01-09 16:30:42','2023-01-09 16:30:42',NULL),(732,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',860.00,'2023-01 Acta defunción',NULL,1,'2023-01-09 16:31:21','2023-01-09 16:31:21',NULL),(733,7851,40719,14,20,NULL,NULL,NULL,378,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2064174.00,NULL,NULL,1,'2023-01-09 16:35:22','2023-01-09 16:35:22',NULL),(734,7851,40719,18,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',982940.00,NULL,NULL,1,'2023-01-09 16:38:21','2023-01-09 16:38:21',NULL),(735,7851,40719,3,21,NULL,NULL,NULL,380,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',982940.00,NULL,NULL,1,'2023-01-09 17:20:27','2023-01-09 17:22:11','2023-01-09 17:22:11'),(736,7851,40719,18,20,NULL,NULL,NULL,381,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',982940.00,NULL,NULL,1,'2023-01-09 17:24:34','2023-01-09 17:24:34',NULL),(737,7851,40719,18,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',19145.67,'2022-12 Egreso SUSS 1595',NULL,1,'2023-01-09 17:39:03','2023-01-09 17:39:03',NULL),(738,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',19145.67,'2022-12 Pago SUSS 1595',NULL,1,'2023-01-09 17:39:37','2023-01-09 17:39:37',NULL),(739,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7625.00,'2023-01 Las Heras 175 Internet',NULL,1,'2023-01-09 19:35:34','2023-01-09 19:35:34',NULL),(740,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',24000.00,'Tarjeta cumpleaños Marcelo Russo',NULL,1,'2023-01-12 19:14:42','2023-01-12 19:14:42',NULL),(741,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',12990.52,'Gastos farmacia',NULL,1,'2023-01-12 19:16:05','2023-01-12 19:16:05',NULL),(742,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4250.00,'Compra alambre',NULL,1,'2023-01-12 19:16:44','2023-01-14 21:53:31','2023-01-14 21:53:31'),(743,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',860.00,'2023-01 Acta defunción',NULL,1,'2023-01-12 19:18:12','2023-01-12 19:18:12',NULL),(744,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',860.00,'2023-01 Acta defunción',NULL,1,'2023-01-12 19:19:00','2023-01-12 19:19:00',NULL),(745,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',25000.00,'2023-01 Transferencia para Plazo fijo',NULL,1,'2023-01-12 19:19:46','2023-01-12 19:19:46',NULL),(746,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',670.00,'2022-12 Banco Supervielle Tarjeta Mastercard Mínimo',NULL,1,'2023-01-12 19:21:45','2023-01-12 19:21:45',NULL),(747,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',764.00,'2022-12 Banco Supervielle Tarjeta Visa Mínimo',NULL,1,'2023-01-12 19:24:37','2023-01-12 19:24:37',NULL),(748,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1092.72,'2022-12 Banco Supervielle Tarjeta Visa Total',NULL,1,'2023-01-12 19:35:48','2023-01-12 19:35:48',NULL),(749,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',229.96,'2022-12 Banco Supervielle Tarjeta Mastercard Total',NULL,1,'2023-01-12 19:36:44','2023-01-12 19:36:44',NULL);
INSERT INTO `balance_libro` VALUES (750,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',90446.52,'2022-11 Jubilación',NULL,1,'2023-01-12 19:41:56','2023-01-12 19:43:21','2023-01-12 19:43:21'),(751,7851,40719,12,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',90442.66,'2022-10 Jubilación',NULL,1,'2023-01-12 19:43:13','2023-03-31 18:19:53','2023-03-31 18:19:53'),(752,7851,40719,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',90446.52,'2022-11 Jubilación',NULL,1,'2023-01-12 19:43:21','2023-03-31 18:19:38','2023-03-31 18:19:38'),(753,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',39092.47,'2022-12 Banco Santander Tarjeta Visa Total',NULL,1,'2023-01-13 20:51:31','2023-01-13 20:51:31',NULL),(754,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',85160.73,'2022-12 Banco Santander Tarjeta AMEX Total',NULL,1,'2023-01-13 20:52:41','2023-01-13 20:52:41',NULL),(755,7851,40719,18,3,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',25419.99,NULL,NULL,1,'2023-01-13 21:09:13','2023-01-31 18:40:09','2023-01-31 18:40:09'),(756,7851,40719,28,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',440000.00,'2023-01  Plazo fijo Capital',NULL,1,'2023-01-14 17:50:20','2023-01-14 17:51:07','2023-01-14 17:51:07'),(757,7851,40719,28,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',440000.00,'2023-01 Liquidación plazo fijo Capital',NULL,1,'2023-01-14 17:51:07','2023-01-14 17:51:27','2023-01-14 17:51:27'),(758,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',440000.00,'2023-01 Liquidación plazo fijo Capital',NULL,1,'2023-01-14 17:51:27','2023-01-14 17:54:36','2023-01-14 17:54:36'),(759,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',467123.29,'2023-01 Liquidación plazo fijo',NULL,1,'2023-01-14 17:53:07','2023-01-14 17:53:07',NULL),(760,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',233561.64,'2023-01 Liquidación plazo fijo Capital',NULL,1,'2023-01-14 17:54:36','2023-01-30 15:10:50','2023-01-30 15:10:50'),(761,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',950000.00,'2023-01 Plazo fijo Constitución',NULL,1,'2023-01-14 17:57:49','2023-01-14 17:57:49',NULL),(762,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',173.40,'2022-12 LRT ART',NULL,1,'2023-01-14 18:27:43','2023-01-14 18:27:43',NULL),(763,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',173.40,'2022-12 LRT ART',NULL,1,'2023-01-14 18:28:25','2023-01-14 18:28:25',NULL),(764,7851,40719,14,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',115.63,NULL,NULL,1,'2023-01-14 20:12:35','2023-01-14 20:13:52','2023-01-14 20:13:52'),(765,7851,40719,14,3,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',115.63,NULL,NULL,1,'2023-01-14 20:14:32','2023-01-14 20:14:32',NULL),(766,7851,40719,14,15,NULL,535,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',392286.46,NULL,NULL,1,'2023-01-14 20:35:35','2023-01-30 15:02:53','2023-01-30 15:02:53'),(767,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',60000.00,'2023-01 IVA transferencia para pagar',NULL,1,'2023-01-14 21:17:32','2023-01-28 21:06:19','2023-01-28 21:06:19'),(768,7851,40719,13,15,NULL,495,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',170028.92,NULL,NULL,1,'2023-01-14 21:21:07','2023-01-14 21:22:32','2023-01-14 21:22:32'),(769,7851,40719,13,15,NULL,495,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',170028.92,NULL,NULL,1,'2023-01-14 21:23:00','2023-01-14 21:23:00',NULL),(770,7851,40719,12,15,NULL,463,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',170982.00,NULL,NULL,1,'2023-01-14 21:24:55','2023-01-14 21:24:55',NULL);
INSERT INTO `balance_libro` VALUES (771,7851,40719,11,15,NULL,505,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',72830.12,NULL,NULL,1,'2023-01-14 21:26:10','2023-01-14 21:26:10',NULL),(772,7851,40719,10,15,NULL,86,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',26924.00,NULL,NULL,1,'2023-01-14 21:26:31','2023-01-14 21:26:31',NULL),(773,7851,40719,18,3,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2085.80,NULL,NULL,1,'2023-01-14 21:50:01','2023-01-14 21:50:01',NULL),(774,7851,40719,18,3,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',8800.70,NULL,NULL,1,'2023-01-14 21:50:01','2023-01-14 21:51:09','2023-01-14 21:51:09'),(775,7851,40719,18,3,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4250.00,NULL,NULL,1,'2023-01-14 21:50:01','2023-01-14 21:50:01',NULL),(776,7851,40719,18,3,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',8800.69,NULL,NULL,1,'2023-01-14 21:51:09','2023-01-14 21:51:09',NULL),(777,7851,40719,18,21,NULL,NULL,NULL,389,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4250.00,NULL,NULL,1,'2023-01-14 22:06:41','2023-01-14 22:06:41',NULL),(778,7851,40719,18,21,NULL,NULL,NULL,390,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2085.80,NULL,NULL,1,'2023-01-14 22:09:14','2023-01-14 22:09:14',NULL),(779,7851,40719,18,21,NULL,NULL,NULL,391,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8800.69,NULL,NULL,1,'2023-01-14 22:10:21','2023-01-14 22:10:21',NULL),(780,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8386.57,'2023-01 Préstamo Supervielle',NULL,1,'2023-01-17 19:08:38','2023-01-30 20:39:02','2023-01-30 20:39:02'),(781,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2004.07,'2023-02 LH175AGUA',NULL,1,'2023-01-17 19:09:49','2023-01-28 18:13:05','2023-01-28 18:13:05'),(782,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1648.25,'2023-01 LH167AGUA Las Heras 175',NULL,1,'2023-01-17 19:11:23','2023-01-17 19:11:23',NULL),(783,7851,40719,18,3,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1629.77,NULL,NULL,1,'2023-01-27 18:21:09','2023-01-30 13:32:21','2023-01-30 13:32:21'),(784,7851,40719,18,3,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',16752.22,NULL,NULL,1,'2023-01-27 18:21:09','2023-01-28 13:20:55','2023-01-28 13:20:55'),(785,7851,40719,18,3,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',498.90,NULL,NULL,1,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(786,7851,40719,18,3,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',21864.99,NULL,NULL,1,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(787,7851,40719,18,3,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4289.99,NULL,NULL,1,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(788,7851,40719,18,3,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',27899.00,NULL,NULL,1,'2023-01-27 18:21:10','2023-01-31 18:00:49','2023-01-31 18:00:49'),(789,7851,40719,18,3,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4232.92,NULL,NULL,1,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(790,7851,40719,18,3,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',7401.06,NULL,NULL,1,'2023-01-27 18:31:35','2023-01-27 18:33:34','2023-01-27 18:33:34'),(791,7851,40719,18,3,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',7401.06,NULL,NULL,1,'2023-01-27 18:33:34','2023-01-27 18:33:34',NULL),(792,7851,40719,18,3,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2500.01,NULL,NULL,1,'2023-01-27 18:37:49','2023-01-27 18:41:51','2023-01-27 18:41:51'),(793,7851,40719,18,3,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3000.09,NULL,NULL,1,'2023-01-27 18:39:03','2023-01-27 18:41:31','2023-01-27 18:41:31');
INSERT INTO `balance_libro` VALUES (794,7851,40719,18,3,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3499.99,NULL,NULL,1,'2023-01-27 18:40:09','2023-01-27 18:41:20','2023-01-27 18:41:20'),(795,7851,40719,18,3,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10000.00,NULL,NULL,1,'2023-01-27 18:41:05','2023-01-27 18:41:05',NULL),(796,7851,40719,18,3,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3499.99,NULL,NULL,1,'2023-01-27 18:41:20','2023-01-27 18:41:20',NULL),(797,7851,40719,18,3,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3000.09,NULL,NULL,1,'2023-01-27 18:41:31','2023-01-27 18:41:31',NULL),(798,7851,40719,18,3,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2500.01,NULL,NULL,1,'2023-01-27 18:41:51','2023-01-27 18:41:51',NULL),(799,7851,40719,18,3,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2500.00,NULL,NULL,1,'2023-01-27 18:43:20','2023-01-27 18:43:20',NULL),(800,7851,40719,18,3,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2000.00,NULL,NULL,1,'2023-01-27 18:45:44','2023-01-27 18:45:44',NULL),(801,7851,40719,18,3,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',25419.99,NULL,NULL,1,'2023-01-27 18:46:48','2023-01-27 18:48:17','2023-01-27 18:48:17'),(802,7851,40719,18,3,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',264.00,NULL,NULL,1,'2023-01-27 18:48:07','2023-01-27 18:48:07',NULL),(803,7851,40719,18,3,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',25419.99,NULL,NULL,1,'2023-01-27 18:48:17','2023-01-27 18:48:17',NULL),(806,7851,40719,18,3,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',16752.22,NULL,NULL,1,'2023-01-28 13:20:55','2023-01-30 13:32:04','2023-01-30 13:32:04'),(807,7851,40719,18,3,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5613.14,NULL,NULL,1,'2023-01-28 16:36:44','2023-01-28 16:38:07','2023-01-28 16:38:07'),(808,7851,40719,18,3,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4798.44,NULL,NULL,1,'2023-01-28 16:37:56','2023-01-28 16:37:56',NULL),(809,7851,40719,18,3,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5613.14,NULL,NULL,1,'2023-01-28 16:38:07','2023-01-28 16:38:07',NULL),(810,7851,40719,18,3,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9801.61,NULL,NULL,1,'2023-01-28 16:52:26','2023-01-28 16:53:11','2023-01-28 16:53:11'),(811,7851,40719,18,3,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8799.99,NULL,NULL,1,'2023-01-28 16:52:26','2023-01-28 16:52:26',NULL),(812,7851,40719,18,3,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9801.61,NULL,NULL,1,'2023-01-28 16:53:11','2023-01-28 16:53:11',NULL),(813,7851,40719,18,3,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',125.61,NULL,NULL,1,'2023-01-28 17:13:22','2023-01-28 17:13:22',NULL),(814,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',100000.00,'2023-01 Banco Supervielle FCI Salud Suscripción',NULL,1,'2023-01-28 18:08:18','2023-01-28 18:08:18',NULL),(815,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',30000.00,'2023-01 Extracción efectivo',NULL,1,'2023-01-28 18:09:12','2023-01-28 18:09:26','2023-01-28 18:09:26'),(816,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',30000.00,'2023-01 Extracción efectivo Familia HP',NULL,1,'2023-01-28 18:09:26','2023-01-28 18:09:36','2023-01-28 18:09:36'),(817,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',30000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-28 18:09:36','2023-01-28 18:09:36',NULL),(818,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',20000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-28 18:10:03','2023-01-28 18:10:03',NULL);
INSERT INTO `balance_libro` VALUES (819,7851,40719,18,21,NULL,NULL,NULL,421,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9801.61,NULL,NULL,1,'2023-01-28 18:11:19','2023-01-28 18:11:19',NULL),(820,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2004.07,'2023-02 LH175AGUA Las Heras 175',NULL,1,'2023-01-28 18:13:05','2023-01-28 18:13:05',NULL),(821,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1861.03,'2023-01 LH175GAS Las Heras 175',NULL,1,'2023-01-28 20:39:58','2023-01-28 20:39:58',NULL),(822,7851,40719,18,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',104624.37,'2023-01 Jubilación',NULL,1,'2023-01-28 20:42:19','2023-03-31 18:18:49','2023-03-31 18:18:49'),(823,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',40000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-28 20:45:25','2023-01-28 20:45:25',NULL),(824,7851,40719,18,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2000.00,'R M Poblet Transferencia',NULL,1,'2023-01-28 20:48:32','2023-01-28 20:48:32',NULL),(825,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',20000.00,'2023-01 Transferencia para Orden de compra',NULL,1,'2023-01-28 20:51:25','2023-01-28 20:51:25',NULL),(826,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5000.00,'Personales EAHP',NULL,1,'2023-01-28 21:01:22','2023-01-28 21:01:22',NULL),(827,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',860.00,'Personales EAHP',NULL,1,'2023-01-28 21:02:04','2023-01-28 21:02:04',NULL),(828,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',860.00,'Personales EAHP',NULL,1,'2023-01-28 21:02:38','2023-01-28 21:02:38',NULL),(829,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',40000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-28 21:03:44','2023-01-28 21:03:44',NULL),(830,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',60000.00,'2023-01 IVA transferencia para pagar',NULL,1,'2023-01-28 21:06:19','2023-01-28 21:06:19',NULL),(831,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8386.57,'2023-01 Banco Supervielle Préstamo Pago Cuota',NULL,1,'2023-01-28 21:08:37','2023-01-28 21:08:37',NULL),(832,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',6000.00,'Personales EAHP',NULL,1,'2023-01-28 21:10:13','2023-01-28 21:10:13',NULL),(833,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-28 21:10:43','2023-01-31 19:04:36','2023-01-31 19:04:36'),(834,7851,40719,18,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',15000.00,'R M Poblet',NULL,1,'2023-01-28 21:14:40','2023-01-28 21:14:40',NULL),(835,7851,40719,18,21,NULL,NULL,NULL,422,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1449.99,NULL,NULL,1,'2023-01-30 13:23:37','2023-01-30 13:23:37',NULL),(836,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7077.99,'2023-01 OC0358 Sellado Cuota 3',NULL,1,'2023-01-30 13:27:41','2023-02-12 22:19:19','2023-02-12 22:19:19'),(837,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',60000.00,'2023-01 Fondo IVA202212',NULL,1,'2023-01-30 13:30:57','2023-01-30 13:30:57',NULL),(838,7851,40719,18,3,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',16752.22,NULL,NULL,1,'2023-01-30 13:32:04','2023-01-30 13:32:04',NULL),(839,7851,40719,18,3,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1629.77,NULL,NULL,1,'2023-01-30 13:32:21','2023-01-30 13:32:21',NULL),(840,7851,40719,18,21,NULL,NULL,NULL,425,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',16752.22,NULL,NULL,1,'2023-01-30 13:33:58','2023-01-30 13:33:58',NULL);
INSERT INTO `balance_libro` VALUES (841,7851,40719,18,21,NULL,NULL,NULL,426,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1629.77,NULL,NULL,1,'2023-01-30 13:34:36','2023-01-30 13:34:36',NULL),(842,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',60000.00,'2023-01 Fondo IVA202212 Suscripción',NULL,1,'2023-01-30 13:36:41','2023-01-30 13:36:41',NULL),(843,7851,40719,14,21,NULL,NULL,NULL,427,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',12873.41,NULL,NULL,1,'2023-01-30 14:33:56','2023-01-30 14:36:58','2023-01-30 14:36:58'),(844,7851,40719,14,3,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',12873.41,NULL,NULL,1,'2023-01-30 15:02:54','2023-01-30 15:02:54',NULL),(845,7851,40719,14,15,NULL,588,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',392286.46,NULL,NULL,1,'2023-01-30 15:04:11','2023-01-30 15:04:11',NULL),(846,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',233561.64,'2023-01 Liquidación plazo fijo Capital',NULL,1,'2023-01-30 15:10:50','2023-01-30 15:10:50',NULL),(847,7851,40719,14,21,NULL,NULL,NULL,429,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',12873.41,NULL,NULL,1,'2023-01-30 15:11:59','2023-01-30 15:11:59',NULL),(848,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2940.78,'Gastos bancarios, intereses, entre otros',NULL,1,'2023-01-30 19:09:17','2023-01-30 19:09:17',NULL),(849,7851,40719,14,20,NULL,NULL,NULL,430,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',7780.00,NULL,NULL,1,'2023-01-30 23:18:05','2023-02-01 01:05:15','2023-02-01 01:05:15'),(850,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',10000.00,'2022-12 Gastos Personales EAHP',NULL,1,'2023-01-30 23:44:18','2023-01-30 23:44:18',NULL),(851,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',135000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-30 23:46:39','2023-01-30 23:46:39',NULL),(852,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2271.00,'2022-12 Seguro BFN849',NULL,1,'2023-01-30 23:55:36','2023-01-31 00:08:04','2023-01-31 00:08:04'),(853,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',100000.00,'Devolución de parte de EAHP Inversión en Binance',NULL,1,'2023-01-30 23:57:38','2023-01-30 23:58:11','2023-01-30 23:58:11'),(854,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',100000.00,'Devolución de parte de EAHP Inversión en Binance',NULL,1,'2023-01-30 23:58:11','2023-01-30 23:58:11',NULL),(855,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',15.40,'2022-12',NULL,1,'2023-01-31 00:05:38','2023-01-31 00:05:38',NULL),(856,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2271.00,'2022-12 Seguro BFN849',NULL,1,'2023-01-31 00:08:04','2023-01-31 00:08:04',NULL),(857,7851,40719,13,21,NULL,NULL,NULL,431,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6201.06,NULL,NULL,1,'2023-01-31 02:55:46','2023-01-31 02:55:46',NULL),(858,7851,40719,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',9.75,'2022-11 Banco Supervielle CA Intereses',NULL,1,'2023-01-31 02:56:59','2023-01-31 02:56:59',NULL),(859,7851,40719,18,3,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',27899.00,NULL,NULL,1,'2023-01-31 17:58:40','2023-01-31 18:00:13','2023-01-31 18:00:13'),(860,7851,40719,18,3,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',27899.00,NULL,NULL,1,'2023-01-31 17:58:40','2023-01-31 18:00:24','2023-01-31 18:00:24'),(861,7851,40719,18,3,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',51999.00,NULL,NULL,1,'2023-01-31 17:58:40','2023-01-31 18:01:21','2023-01-31 18:01:21'),(862,7851,40719,18,3,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4500.00,NULL,NULL,1,'2023-01-31 17:58:40','2023-01-31 18:01:09','2023-01-31 18:01:09');
INSERT INTO `balance_libro` VALUES (863,7851,40719,18,3,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6573.00,NULL,NULL,1,'2023-01-31 17:58:40','2023-01-31 18:01:33','2023-01-31 18:01:33'),(864,7851,40719,18,3,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',27899.00,NULL,NULL,1,'2023-01-31 18:00:13','2023-01-31 18:28:11','2023-01-31 18:28:11'),(865,7851,40719,18,3,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',27899.00,NULL,NULL,1,'2023-01-31 18:00:24','2023-01-31 18:27:57','2023-01-31 18:27:57'),(866,7851,40719,18,3,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',27899.00,NULL,NULL,1,'2023-01-31 18:00:49','2023-01-31 18:31:40','2023-01-31 18:31:40'),(867,7851,40719,18,3,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4500.00,NULL,NULL,1,'2023-01-31 18:01:09','2023-01-31 18:01:09',NULL),(868,7851,40719,18,3,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',51999.00,NULL,NULL,1,'2023-01-31 18:01:21','2023-01-31 18:26:38','2023-01-31 18:26:38'),(869,7851,40719,18,3,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6573.00,NULL,NULL,1,'2023-01-31 18:01:33','2023-01-31 18:01:33',NULL),(870,7851,40719,18,3,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',51999.00,NULL,NULL,1,'2023-01-31 18:26:38','2023-01-31 18:26:38',NULL),(871,7851,40719,18,3,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',27899.00,NULL,NULL,1,'2023-01-31 18:27:57','2023-01-31 18:27:57',NULL),(872,7851,40719,18,3,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',27899.00,NULL,NULL,1,'2023-01-31 18:28:11','2023-01-31 18:28:11',NULL),(873,7851,40719,18,3,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',27899.00,NULL,NULL,1,'2023-01-31 18:31:40','2023-01-31 18:31:40',NULL),(874,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7000.00,'Extracción efectivo Familia HP',NULL,1,'2023-01-31 19:04:36','2023-01-31 19:04:36',NULL),(875,7851,40719,18,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',29880.00,'2023-01 Egreso Sueldos 1595',NULL,1,'2023-01-31 20:31:29','2023-01-31 20:31:29',NULL),(876,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',29880.00,'2023-01 Pago Sueldos 1595',NULL,1,'2023-01-31 20:31:59','2023-01-31 20:31:59',NULL),(877,7851,40719,18,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',50120.00,'2023-01 Egreso Servicios WR 1595',NULL,1,'2023-01-31 20:32:32','2023-01-31 20:32:32',NULL),(878,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',50120.00,'2023-01 Pago Servicios WR 1595',NULL,1,'2023-01-31 20:32:53','2023-01-31 20:32:53',NULL),(879,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',80000.00,'2023-01 Transferencia para pago Sueldos',NULL,1,'2023-01-31 20:33:54','2023-01-31 20:33:54',NULL),(880,7851,40719,11,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6698.71,'Diferencias combustible 2022-09',NULL,1,'2023-01-31 21:36:39','2023-01-31 22:33:49','2023-01-31 22:33:49'),(881,7851,40719,11,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6698.71,'Diferencias combustible 2022-09',NULL,1,'2023-01-31 22:33:49','2023-01-31 22:33:49',NULL),(882,7851,40719,12,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1497.09,'2022-10 Diferencia combustible 20000-18503.01',NULL,1,'2023-02-01 00:16:15','2023-02-01 00:16:15',NULL),(883,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',39124.01,'2022-11 IVA',NULL,1,'2023-02-01 00:32:01','2023-02-01 00:33:53','2023-02-01 00:33:53'),(884,7851,40719,12,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',15226.95,'2022-09 IVA',NULL,1,'2023-02-01 00:33:00','2023-02-01 01:22:57','2023-02-01 01:22:57');
INSERT INTO `balance_libro` VALUES (885,7851,40719,13,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',53966.06,'2022-10 IVA',NULL,1,'2023-02-01 00:33:43','2023-02-01 00:33:43',NULL),(886,7851,40719,14,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',39124.01,'2022-11 IVA',NULL,1,'2023-02-01 00:33:53','2023-02-01 00:33:53',NULL),(887,7851,40719,14,21,NULL,NULL,NULL,447,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',7780.00,NULL,NULL,1,'2023-02-01 01:06:37','2023-02-01 01:06:37',NULL),(888,7851,40719,12,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',15226.95,'2022-09 Cargas sociales',NULL,1,'2023-02-01 01:22:57','2023-02-01 01:23:36','2023-02-01 01:23:36'),(889,7851,40719,12,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',15226.95,'2022-09 Pago SUSS 1595',NULL,1,'2023-02-01 01:23:36','2023-02-01 01:23:36',NULL),(890,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',18801.15,'2022-10 Pago de SUSS',NULL,1,'2023-02-01 01:26:16','2023-02-01 01:26:16',NULL),(891,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',899.96,'2023-01 Banco Supervielle Tarjeta Mastercard',NULL,1,'2023-02-01 01:37:48','2023-02-01 01:38:11','2023-02-01 01:38:11'),(892,7851,40719,18,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',899.96,'2023-01 Banco Supervielle Tarjeta Mastercard',NULL,1,'2023-02-01 01:38:11','2023-02-01 01:38:11',NULL),(893,7851,40719,18,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1856.72,'2023-01 Banco Supervielle Tarjeta Visa',NULL,1,'2023-02-01 01:42:21','2023-02-01 01:42:21',NULL),(894,7851,40719,18,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15.62,'2023-01 Banco Supervielle CA ARS Intereses',NULL,1,'2023-02-03 19:29:00','2023-02-03 19:29:00',NULL),(895,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',97349.57,'2023-01 Tarjeta Naranja Pago',NULL,1,'2023-02-03 19:31:35','2023-02-03 19:31:35',NULL),(896,7851,40719,18,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',25000.00,'2023-01 Extracción efectivo JCH Tanque agua',NULL,1,'2023-02-03 19:32:59','2023-02-03 19:32:59',NULL),(897,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',251.65,'2023-02 Préstamo Supervielle IVA',NULL,1,'2023-02-03 19:38:38','2023-02-03 19:42:01','2023-02-03 19:42:01'),(898,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1198.34,'2023-02 Banco Supervielle Comisión Paquete',NULL,1,'2023-02-03 19:41:11','2023-02-03 19:41:23','2023-02-03 19:41:23'),(899,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1198.34,'2023-02 Banco Supervielle Comisión Paquete',NULL,1,'2023-02-03 19:41:23','2023-02-03 19:41:23',NULL),(900,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',251.65,'2023-02 Banco Supervielle Comisión Paquete IVA',NULL,1,'2023-02-03 19:42:01','2023-02-03 19:42:01',NULL),(901,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2047.78,'2023-02 Banco Supervielle Préstamo Seguro Vida',NULL,1,'2023-02-03 19:44:15','2023-02-03 19:44:15',NULL),(902,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',585.38,'2023-02 Banco Supervielle Préstamo Seguro Vida',NULL,1,'2023-02-03 19:57:45','2023-02-03 19:57:53','2023-02-03 19:57:53'),(903,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',585.38,'2023-02 Banco Supervielle Préstamo Seguro Vida',NULL,1,'2023-02-03 19:57:53','2023-02-03 19:57:53',NULL),(904,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',40000.00,'Extracción efectivo Familia HP',NULL,1,'2023-02-03 20:08:58','2023-02-03 20:08:58',NULL);
INSERT INTO `balance_libro` VALUES (905,7851,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',40000.00,'Personales EAHP',NULL,1,'2023-02-03 21:05:14','2023-02-03 21:05:14',NULL),(906,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3297.83,'Ajuste Gastos varios VER EXCEL',NULL,1,'2023-02-03 23:49:46','2023-02-03 23:51:59','2023-02-03 23:51:59'),(907,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3297.83,'Ajuste Gastos varios VER EXCEL',NULL,1,'2023-02-03 23:51:59','2023-02-03 23:51:59',NULL),(908,7851,40719,13,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',846.57,'Diferencia compra Cánulas Inyectores',NULL,1,'2023-02-03 23:54:03','2023-02-03 23:54:03',NULL),(909,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',10900.00,'2022-11 Carga combustible sin factura',NULL,1,'2023-02-04 00:51:14','2023-02-04 00:51:14',NULL),(910,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4.71,'2023-02 Ajuste MercadoPago WR para cuadrar',NULL,1,'2023-02-04 00:56:51','2023-02-04 00:56:51',NULL),(911,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',17713.05,'2023-02 Banco Santander Tarjeta Visa 1° Pago',NULL,1,'2023-02-04 18:47:06','2023-02-04 18:47:06',NULL),(912,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',7500.00,'2023-02 Banco Santander CA Descubierto',NULL,1,'2023-02-04 18:55:58','2023-02-04 18:55:58',NULL),(913,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',50000.00,'2023-02 Transferencia para pago de tarjeta',NULL,1,'2023-02-04 19:49:11','2023-02-04 19:49:11',NULL),(914,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',15109.41,'2023-02 Banco Santander Tarjeta Visa 2° Pago',NULL,1,'2023-02-04 19:50:55','2023-02-04 19:50:55',NULL),(915,7851,40719,19,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',18815.95,'2023-01 Egreso SUSS 1595',NULL,1,'2023-02-04 20:00:22','2023-02-12 22:46:29','2023-02-12 22:46:29'),(916,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',30000.00,'2023-02 Transferencia para pagar SUSS',NULL,1,'2023-02-05 15:23:03','2023-02-05 15:23:03',NULL),(917,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7500.00,'2023-02 Compensación descubierto',NULL,1,'2023-02-06 09:46:39','2023-02-06 09:46:39',NULL),(918,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',15109.41,'2023-02 Banco Santander Tarjeta Visa 2° Pago (repetido)',NULL,1,'2023-02-06 09:49:35','2023-02-06 09:49:35',NULL),(919,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',138.83,'Ajuste para cuadrar con Taxes',NULL,1,'2023-02-06 09:51:50','2023-02-06 09:51:50',NULL),(920,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',20000.00,'2023-02 Transferencia para pago de tarjeta',NULL,1,'2023-02-06 09:55:21','2023-02-10 19:48:40','2023-02-10 19:48:40'),(921,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',18115.95,'2023-01 Pago SUSS',NULL,1,'2023-02-06 09:58:06','2023-02-06 09:58:06',NULL),(922,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1401.50,'2023-01 LH167ELEC C1 Las Heras 175',NULL,1,'2023-02-06 20:00:22','2023-02-06 20:00:22',NULL),(923,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1401.50,'2023-01 LH167ELEC C2 Las Heras 175',NULL,1,'2023-02-06 20:00:56','2023-02-06 20:00:56',NULL),(924,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7303.00,'2023-01 LH175ELEC C1 Las Heras 175',NULL,1,'2023-02-06 20:01:57','2023-02-06 20:01:57',NULL);
INSERT INTO `balance_libro` VALUES (925,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7303.00,'2023-01 LH175ELEC C2 Las Heras 175',NULL,1,'2023-02-06 20:03:07','2023-02-06 20:03:07',NULL),(926,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',231.89,'2023-02 Banco Supervielle Tarjeta Mastercard Saldo',NULL,1,'2023-02-07 19:01:33','2023-02-07 19:01:33',NULL),(927,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',890.00,'2023-02 Banco Supervielle Tarjeta Mastercard Mínimo',NULL,1,'2023-02-07 19:28:17','2023-02-07 19:28:17',NULL),(928,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',991.00,'2023-02 Banco Supervielle Tarjeta Visa Mínimo',NULL,1,'2023-02-07 19:29:45','2023-02-07 19:29:45',NULL),(929,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1471.30,'2023-02 Banco Supervielle Tarjeta Visa Saldo',NULL,1,'2023-02-07 19:31:09','2023-02-07 19:31:09',NULL),(930,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1.93,'2023-02 Banco Santander CA Intereses',NULL,1,'2023-02-07 19:56:12','2023-02-07 19:57:24','2023-02-07 19:57:24'),(931,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1.93,'2023-02 Banco Santander CA Intereses',NULL,1,'2023-02-07 19:57:24','2023-02-07 19:57:24',NULL),(932,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',37905.56,'2023-01 Banco Santander Tarjeta AMEX Total',NULL,1,'2023-02-07 19:58:37','2023-02-07 19:58:37',NULL),(933,7851,40719,18,3,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1500.00,NULL,NULL,1,'2023-02-07 20:06:19','2023-02-07 20:06:19',NULL),(934,7851,40719,18,3,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3900.00,NULL,NULL,1,'2023-02-07 20:06:49','2023-02-07 20:06:49',NULL),(935,7851,40719,19,3,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3000.00,NULL,NULL,1,'2023-02-07 20:07:34','2023-02-07 20:12:17','2023-02-07 20:12:17'),(936,7851,40719,18,3,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2499.99,NULL,NULL,1,'2023-02-07 20:08:10','2023-02-07 20:08:10',NULL),(937,7851,40719,18,3,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1999.93,NULL,NULL,1,'2023-02-07 20:09:08','2023-02-07 20:09:08',NULL),(938,7851,40719,18,3,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2000.00,NULL,NULL,1,'2023-02-07 20:10:15','2023-02-07 20:10:15',NULL),(939,7851,40719,18,3,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3000.09,NULL,NULL,1,'2023-02-07 20:11:40','2023-02-07 20:11:40',NULL),(940,7851,40719,18,3,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3000.00,NULL,NULL,1,'2023-02-07 20:12:17','2023-02-07 20:12:17',NULL),(941,7851,40719,18,3,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2501.97,NULL,NULL,1,'2023-02-07 20:14:40','2023-02-07 20:14:40',NULL),(942,7851,40719,18,15,NULL,632,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',96052.57,NULL,NULL,1,'2023-02-07 21:09:39','2023-02-07 21:09:48','2023-02-07 21:09:48'),(943,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',25000.00,'2023-02 Personal EAHP',NULL,1,'2023-02-10 18:31:05','2023-02-10 18:31:05',NULL),(944,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',40000.00,'Extracción efectivo Familia HP',NULL,1,'2023-02-10 18:33:11','2023-02-10 18:33:11',NULL),(945,7851,40719,18,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8000.00,NULL,NULL,1,'2023-02-10 18:45:24','2023-02-10 18:45:24',NULL),(946,7851,40719,18,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8000.00,NULL,NULL,1,'2023-02-10 18:46:03','2023-02-10 18:46:03',NULL);
INSERT INTO `balance_libro` VALUES (947,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',20000.00,'2023-02 Transferencia para pago de tarjeta',NULL,1,'2023-02-10 19:48:40','2023-02-10 19:48:40',NULL),(948,7851,40719,18,21,NULL,NULL,NULL,459,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2501.97,NULL,NULL,1,'2023-02-10 20:31:40','2023-02-12 23:22:58','2023-02-12 23:22:58'),(949,7851,40719,18,20,NULL,NULL,NULL,460,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5000.09,NULL,NULL,1,'2023-02-10 20:34:08','2023-02-10 20:49:14','2023-02-10 20:49:14'),(950,7851,40719,18,21,NULL,NULL,NULL,461,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7499.92,NULL,NULL,1,'2023-02-10 20:35:18','2023-02-10 20:35:18',NULL),(951,7851,40719,18,21,NULL,NULL,NULL,462,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5400.00,NULL,NULL,1,'2023-02-10 20:36:11','2023-02-10 20:36:11',NULL),(952,7851,40719,18,21,NULL,NULL,NULL,463,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6573.00,NULL,NULL,1,'2023-02-10 20:42:35','2023-02-10 20:42:35',NULL),(953,7851,40719,18,21,NULL,NULL,NULL,464,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4500.00,NULL,NULL,1,'2023-02-10 20:43:17','2023-02-10 20:43:17',NULL),(954,7851,40719,18,21,NULL,NULL,NULL,465,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',51999.00,NULL,NULL,1,'2023-02-10 20:46:34','2023-02-10 20:46:34',NULL),(955,7851,40719,18,21,NULL,NULL,NULL,466,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',55798.00,NULL,NULL,1,'2023-02-10 20:49:02','2023-02-10 20:49:02',NULL),(956,7851,40719,18,21,NULL,NULL,NULL,467,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5000.09,NULL,NULL,1,'2023-02-10 20:49:53','2023-02-10 20:49:53',NULL),(957,7851,40719,18,20,NULL,NULL,NULL,468,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',27899.00,NULL,NULL,1,'2023-02-10 20:50:53','2023-02-10 20:50:53',NULL),(958,7851,40719,18,21,NULL,NULL,NULL,469,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8799.99,NULL,NULL,1,'2023-02-10 20:53:51','2023-02-10 20:53:51',NULL),(959,7851,40719,18,21,NULL,NULL,NULL,470,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',25419.99,NULL,NULL,1,'2023-02-10 20:58:02','2023-02-10 20:58:13','2023-02-10 20:58:13'),(960,7851,40719,18,21,NULL,NULL,NULL,471,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2000.00,NULL,NULL,1,'2023-02-10 21:01:08','2023-02-10 21:01:08',NULL),(961,7851,40719,18,21,NULL,NULL,NULL,472,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',28901.15,NULL,NULL,1,'2023-02-10 21:05:04','2023-03-03 11:43:07','2023-03-03 11:43:07'),(962,7851,40719,18,21,NULL,NULL,NULL,473,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4289.99,NULL,NULL,1,'2023-02-10 21:05:43','2023-02-10 21:05:43',NULL),(963,7851,40719,18,21,NULL,NULL,NULL,474,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',21864.99,NULL,NULL,1,'2023-02-10 21:07:37','2023-02-10 21:07:37',NULL),(964,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',40000.00,'2023-02 Transferencia para gastos operativos',NULL,1,'2023-02-12 14:26:58','2023-02-12 14:26:58',NULL),(965,7851,40719,18,15,NULL,637,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',97572.94,NULL,NULL,1,'2023-02-12 19:29:56','2023-02-12 19:29:56',NULL),(966,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7007.99,'2023-01 OC0358 Sellado 3° Cuota',NULL,1,'2023-02-12 22:19:19','2023-02-12 22:19:19',NULL),(967,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',7007.99,'2022-12 OC0358 Sellado 2° Cuota',NULL,1,'2023-02-12 22:19:52','2023-02-12 22:19:52',NULL),(968,7851,40719,13,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',7007.99,'2022-11 OC0358 Sellado 1° Cuota',NULL,1,'2023-02-12 22:20:22','2023-02-12 22:20:22',NULL),(969,7851,40719,19,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',18115.95,'2023-01 Egreso SUSS 1595',NULL,1,'2023-02-12 22:46:29','2023-02-12 22:46:29',NULL);
INSERT INTO `balance_libro` VALUES (970,7851,40719,18,21,NULL,NULL,NULL,475,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2501.97,NULL,NULL,1,'2023-02-12 23:23:23','2023-02-12 23:23:23',NULL),(971,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',8000.00,'2023-02 Transferencia para plazo fijo',NULL,1,'2023-02-13 11:50:22','2023-02-13 11:50:22',NULL),(972,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1012465.75,'2023-02 Banco Santander Plazo Fijo Liquidación',NULL,1,'2023-02-13 11:52:23','2023-02-13 11:52:23',NULL),(973,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1020000.00,'2023-02 Banco Santander Plazo Fijo Constitución',NULL,1,'2023-02-13 11:53:13','2023-02-13 11:59:19','2023-02-13 11:59:19'),(974,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1020000.00,'2023-02 Banco Santander FCI Ahorro Familia HP',NULL,1,'2023-02-13 11:59:19','2023-02-13 12:00:07','2023-02-13 12:00:07'),(975,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1020000.00,'2023-02 Banco Santander FCI Ahorro Familia HP',NULL,1,'2023-02-13 12:00:07','2023-02-13 12:00:07',NULL),(976,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1.93,'2023-02 Banco Santander CA Intereses',NULL,1,'2023-02-13 12:56:20','2023-02-13 12:56:20',NULL),(977,7851,40719,19,3,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2085.80,NULL,NULL,1,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(978,7851,40719,19,3,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',999.99,NULL,NULL,1,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(979,7851,40719,19,3,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',7500.00,NULL,NULL,1,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(980,7851,40719,19,3,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',11375.00,NULL,NULL,1,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(981,7851,40719,19,3,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9228.19,NULL,NULL,1,'2023-02-17 18:39:55','2023-03-03 12:54:25','2023-03-03 12:54:25'),(982,7851,40719,19,3,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1785.57,NULL,NULL,1,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(983,7851,40719,19,3,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',15077.78,NULL,NULL,1,'2023-02-17 18:39:55','2023-03-12 18:35:42','2023-03-12 18:35:42'),(984,7851,40719,19,3,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2003.91,NULL,NULL,1,'2023-02-17 18:39:55','2023-03-03 12:53:46','2023-03-03 12:53:46'),(985,7851,40719,18,21,NULL,NULL,NULL,484,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',999.99,NULL,NULL,1,'2023-02-17 18:47:16','2023-02-17 18:47:16',NULL),(986,7851,40719,19,21,NULL,NULL,NULL,485,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',2085.80,NULL,NULL,1,'2023-02-17 18:48:57','2023-02-17 18:48:57',NULL),(987,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',51000.00,'2023-02 Transferencia para FCI IVA2023-01',NULL,1,'2023-02-17 18:50:25','2023-02-17 18:50:25',NULL),(988,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',51000.00,'2023-02 Banco Santander FCI 2023-01 Constitución',NULL,1,'2023-02-17 18:54:47','2023-02-17 18:54:47',NULL),(989,7851,40719,19,21,NULL,NULL,NULL,486,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',7500.00,NULL,NULL,1,'2023-02-17 19:05:40','2023-03-18 20:49:21','2023-03-18 20:49:21'),(990,7851,40719,19,21,NULL,NULL,NULL,487,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',11375.00,NULL,NULL,1,'2023-02-17 22:07:11','2023-02-17 22:07:11',NULL),(991,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1423.57,'2023-02 Personales Familia HP',NULL,1,'2023-02-17 22:45:44','2023-02-17 22:45:44',NULL);
INSERT INTO `balance_libro` VALUES (992,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8386.56,'2023-02 Banco Supervielle Préstamo Pago Cuota',NULL,1,'2023-02-17 22:47:37','2023-02-17 22:47:37',NULL),(993,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',40000.00,'Extracción efectivo Familia HP',NULL,1,'2023-02-17 22:58:11','2023-02-17 22:58:11',NULL),(994,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',8575.00,'2023-02 LH175INTE',NULL,1,'2023-02-17 23:02:17','2023-02-17 23:02:17',NULL),(995,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1822.97,'2023-02 LH175GAS',NULL,1,'2023-02-17 23:05:41','2023-02-17 23:05:41',NULL),(996,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3450.00,'2023-02 Personales Familia HP',NULL,1,'2023-02-17 23:06:32','2023-02-17 23:06:32',NULL),(997,7851,40719,19,3,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',21999.95,NULL,NULL,1,'2023-02-17 23:07:37','2023-02-17 23:07:37',NULL),(998,7851,40719,19,3,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',6300.53,NULL,NULL,1,'2023-02-17 23:12:51','2023-02-17 23:12:51',NULL),(999,7851,40719,19,21,NULL,NULL,NULL,490,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',21999.95,NULL,NULL,1,'2023-02-17 23:13:40','2023-02-17 23:13:40',NULL),(1000,7851,40719,19,20,NULL,NULL,NULL,491,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',6300.53,NULL,NULL,1,'2023-02-17 23:15:33','2023-02-17 23:26:46','2023-02-17 23:26:46'),(1001,7851,40719,19,21,NULL,NULL,NULL,492,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',6300.53,NULL,NULL,1,'2023-02-17 23:27:29','2023-02-17 23:27:29',NULL),(1002,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',22901.08,'2023-02 Transferencia para pago de tarjeta',NULL,1,'2023-02-21 18:40:38','2023-02-21 18:40:38',NULL),(1003,7851,40719,19,3,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',498.90,NULL,NULL,1,'2023-02-21 18:44:32','2023-02-21 18:44:32',NULL),(1004,7851,40719,19,21,NULL,NULL,NULL,494,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',498.90,NULL,NULL,1,'2023-02-21 18:46:45','2023-06-06 00:30:30','2023-06-06 00:30:30'),(1005,7851,40719,18,21,NULL,NULL,NULL,495,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',498.90,NULL,NULL,1,'2023-02-21 18:54:19','2023-06-06 00:30:42','2023-06-06 00:30:42'),(1006,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',124000.00,'2023-02 Banco Santander FCI 1595 Rescate',NULL,1,'2023-02-22 12:37:09','2023-02-22 12:37:09',NULL),(1007,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',31000.00,'2023-02 Banco Santander FCI OC358 Rescate',NULL,1,'2023-02-22 12:37:48','2023-02-22 12:41:01','2023-02-22 12:41:01'),(1008,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3535.27,'2023-02 Banco Santander FCI 1595 Intereses',NULL,1,'2023-02-22 12:39:35','2023-02-23 11:02:33','2023-02-23 11:02:33'),(1009,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',883.82,'2023-02 Banco Santander FCI 0358 Intereses',NULL,1,'2023-02-22 12:40:50','2023-02-23 11:02:52','2023-02-23 11:02:52'),(1010,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',31000.00,'2023-02 Banco Santander FCI 0358 Rescate',NULL,1,'2023-02-22 12:41:01','2023-02-22 12:41:01',NULL),(1011,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1500.00,'2023-02 Personales MAP Formulario CENAT Licencia Conducir',NULL,1,'2023-02-23 10:43:20','2023-02-23 10:43:20',NULL),(1012,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',80000.00,'2023-02 Apoyo a 1595',NULL,1,'2023-02-23 10:44:28','2023-02-23 10:44:28',NULL);
INSERT INTO `balance_libro` VALUES (1013,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',10000.00,'2023-02 Apoyo a 1595',NULL,1,'2023-02-23 10:45:02','2023-02-23 10:45:02',NULL),(1014,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',115556.88,'2023-02 OC0082 Sellado',NULL,1,'2023-02-23 10:48:08','2023-02-23 10:48:08',NULL),(1015,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',7077.99,'2023-02 OC0358 Sellado 4° Cuota',NULL,1,'2023-02-23 10:49:30','2023-02-23 10:49:30',NULL),(1016,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',7077.99,'2023-02 OC0358 Sellado 5° Cuota',NULL,1,'2023-02-23 10:50:35','2023-02-23 10:50:35',NULL),(1017,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',7078.01,'2023-02 OC0358 Sellado 6° Cuota',NULL,1,'2023-02-23 10:51:20','2023-02-23 10:51:20',NULL),(1018,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3931.04,'2023-02 Banco Santander FCI 1595 Intereses',NULL,1,'2023-02-23 11:02:33','2023-02-23 11:02:33',NULL),(1019,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',982.76,'2023-02 Banco Santander FCI 0358 Intereses',NULL,1,'2023-02-23 11:02:52','2023-02-23 11:02:52',NULL),(1020,7851,40719,19,21,NULL,NULL,NULL,496,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1785.57,NULL,NULL,1,'2023-02-23 11:06:31','2023-03-12 18:33:11','2023-03-12 18:33:11'),(1021,7851,40719,19,21,NULL,NULL,NULL,497,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',15077.78,NULL,NULL,1,'2023-02-23 11:07:16','2023-03-12 18:33:03','2023-03-12 18:33:03'),(1022,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',80000.00,'2023-02 Transferencia para pago de tarjeta',NULL,1,'2023-03-02 18:49:11','2023-03-02 18:49:28','2023-03-02 18:49:28'),(1023,7851,40719,19,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',28800.00,'2023-02 Egreso Sueldos 1595',NULL,1,'2023-03-02 18:50:59','2023-03-02 18:50:59',NULL),(1024,7851,40719,19,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',51200.00,'2023-02 Egreso Servicios WR 1595',NULL,1,'2023-03-02 18:52:02','2023-03-02 18:52:02',NULL),(1025,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',51200.00,'2023-02 Pago Servicios WR 1595',NULL,1,'2023-03-02 18:53:24','2023-03-02 18:53:24',NULL),(1026,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',28800.00,'2023-02 Pago Sueldos 1595',NULL,1,'2023-03-02 18:54:04','2023-03-02 18:54:04',NULL),(1027,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',200588.02,'2023-02 Banco Santander FCI Ahorro Familia HP Rescate',NULL,1,'2023-03-02 21:42:56','2023-03-02 21:46:12','2023-03-02 21:46:12'),(1028,7851,40719,19,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',200588.02,'2023-02 Banco Santander FCI Ahorro Familia HP Rescate',NULL,1,'2023-03-02 21:46:12','2023-03-02 21:47:47','2023-03-02 21:47:47'),(1029,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',30000.00,'2023-02 Transferencia para combustible',NULL,1,'2023-03-02 21:47:37','2023-03-02 21:47:37',NULL),(1030,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',200588.02,'2023-02 Banco Santander FCI Ahorro Familia HP Rescate',NULL,1,'2023-03-02 21:47:47','2023-03-02 21:47:47',NULL),(1031,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',50000.00,'2023-03 Apoyo a Banco Supervielle',NULL,1,'2023-03-02 21:48:59','2023-03-03 10:34:52','2023-03-03 10:34:52'),(1032,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',40000.00,'2023-02 Extracción efectivo Familia HP',NULL,1,'2023-03-03 10:25:14','2023-03-03 10:25:14',NULL);
INSERT INTO `balance_libro` VALUES (1033,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3.41,'2023-02 Banco Supervielle CA ARS Intereses',NULL,1,'2023-03-03 10:26:41','2023-03-03 12:08:15','2023-03-03 12:08:15'),(1034,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15000.00,'2023-02 Extracción efectivo Familia HP',NULL,1,'2023-03-03 10:27:59','2023-03-03 10:27:59',NULL),(1035,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1449.99,'2023-02 Banco Supervielle Mantenimiento',NULL,1,'2023-03-03 10:30:19','2023-03-03 10:30:51','2023-03-03 10:30:51'),(1036,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1198.34,'2023-02 Banco Supervielle Mantenimiento',NULL,1,'2023-03-03 10:30:51','2023-03-31 18:15:49','2023-03-31 18:15:49'),(1037,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',251.65,'2023-02 Banco Supervielle Mantenimiento',NULL,1,'2023-03-03 10:31:49','2023-03-31 18:15:17','2023-03-31 18:15:17'),(1038,7851,40719,19,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',20010.00,'2023-02 Personales Familia HP',NULL,1,'2023-03-03 10:33:50','2023-03-03 10:33:50',NULL),(1039,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',50000.00,'2023-03 Apoyo a Banco Supervielle',NULL,1,'2023-03-03 10:34:52','2023-03-03 10:34:52',NULL),(1040,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',50000.00,'2023-03 Estudio HP',NULL,1,'2023-03-03 10:36:28','2023-03-03 10:37:56','2023-03-03 10:37:56'),(1041,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',50000.00,'2023-03 Estudio HP',NULL,1,'2023-03-03 10:37:39','2023-03-03 10:37:39',NULL),(1042,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',50000.00,'2023-03 Estudio HP',NULL,1,'2023-03-03 10:37:56','2023-03-03 10:37:56',NULL),(1043,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',93789.21,'2023-02 Jubilación',NULL,1,'2023-03-03 10:40:45','2023-03-31 18:18:33','2023-03-31 18:18:33'),(1044,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3310.37,'2023-02 Seguro de vida',NULL,1,'2023-03-03 10:41:50','2023-03-03 10:42:46','2023-03-03 10:42:46'),(1045,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',585.38,'2023-03 Seguro de vida',NULL,1,'2023-03-03 10:42:37','2023-03-03 10:42:37',NULL),(1046,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3310.37,'2023-03 Seguro de vida',NULL,1,'2023-03-03 10:42:46','2023-03-03 10:42:46',NULL),(1047,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',20000.00,'2023-03 Extracción efectivo Familia HP',NULL,1,'2023-03-03 10:43:31','2023-03-03 10:43:31',NULL),(1048,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',20000.00,'2023-03 Extracción efectivo Familia HP',NULL,1,'2023-03-03 10:44:06','2023-03-03 10:44:06',NULL),(1049,7851,40719,11,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',9869.60,'2022-09 Banco Supervielle Préstamo Pago Cuota',NULL,1,'2023-03-03 11:42:27','2023-03-03 11:42:27',NULL),(1050,7851,40719,14,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',8386.56,'2022-12 Banco Supervielle Préstamo Pago Cuota',NULL,1,'2023-03-03 11:42:42','2023-03-03 11:42:42',NULL),(1051,7851,40719,18,21,NULL,NULL,NULL,498,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',7401.06,NULL,NULL,1,'2023-03-03 11:43:49','2023-03-03 11:43:49',NULL),(1052,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',415.17,'2023-01 Banco Supervielle Préstamo Seguro Vida',NULL,1,'2023-03-03 11:45:18','2023-03-03 11:45:18',NULL);
INSERT INTO `balance_libro` VALUES (1053,7851,40719,18,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1452.30,'2023-01 Banco Supervielle Préstamo Seguro Vida',NULL,1,'2023-03-03 11:46:11','2023-03-03 11:46:11',NULL),(1054,7851,40719,18,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.06,'2023-01 Banco Supervielle CA ARS Ajuste',NULL,1,'2023-03-03 12:03:43','2023-03-03 12:09:57','2023-03-03 12:09:57'),(1055,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3.41,'2023-02 Banco Supervielle CA ARS Intereses',NULL,1,'2023-03-03 12:08:15','2023-03-03 12:08:15',NULL),(1056,7851,40719,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.53,'2023-02 Banco Supervielle CA ARS Ajuste',NULL,1,'2023-03-03 12:09:41','2023-03-03 12:09:41',NULL),(1057,7851,40719,18,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.06,'2023-01 Banco Supervielle CA ARS Ajuste',NULL,1,'2023-03-03 12:09:57','2023-03-03 12:09:57',NULL),(1058,7851,40719,19,3,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3400.00,NULL,NULL,1,'2023-03-03 12:52:03','2023-03-07 22:55:25','2023-03-07 22:55:25'),(1059,7851,40719,19,3,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',20000.01,NULL,NULL,1,'2023-03-03 12:52:03','2023-03-03 12:52:03',NULL),(1060,7851,40719,19,3,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4500.00,NULL,NULL,1,'2023-03-03 12:52:03','2023-03-03 12:52:03',NULL),(1061,7851,40719,19,3,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2003.90,NULL,NULL,1,'2023-03-03 12:53:46','2023-03-03 12:53:46',NULL),(1062,7851,40719,19,3,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9228.20,NULL,NULL,1,'2023-03-03 12:54:25','2023-03-03 12:54:25',NULL),(1063,7851,40719,19,3,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',3000.00,NULL,NULL,1,'2023-03-03 18:22:39','2023-03-03 18:22:39',NULL),(1064,7851,40719,19,3,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',2000.00,NULL,NULL,1,'2023-03-03 18:24:33','2023-03-03 18:24:33',NULL),(1065,7851,40719,19,3,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',14000.00,NULL,NULL,1,'2023-03-03 18:31:07','2023-03-03 18:31:07',NULL),(1066,7851,40719,19,21,NULL,NULL,NULL,507,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',14000.00,NULL,NULL,1,'2023-03-03 18:39:31','2023-03-03 18:39:31',NULL),(1067,7851,40719,19,21,NULL,NULL,NULL,508,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',2000.00,NULL,NULL,1,'2023-03-03 18:40:59','2023-03-03 18:40:59',NULL),(1068,7851,40719,19,21,NULL,NULL,NULL,509,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',3000.00,NULL,NULL,1,'2023-03-03 18:46:28','2023-03-03 18:46:28',NULL),(1069,7851,40719,19,21,NULL,NULL,NULL,510,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9228.20,NULL,NULL,1,'2023-03-03 18:51:03','2023-03-03 18:51:03',NULL),(1070,7851,40719,19,21,NULL,NULL,NULL,511,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3400.00,NULL,NULL,1,'2023-03-03 18:55:13','2023-03-07 22:54:43','2023-03-07 22:54:43'),(1071,7851,40719,19,21,NULL,NULL,NULL,512,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',20000.01,NULL,NULL,1,'2023-03-03 18:58:39','2023-03-03 18:58:39',NULL),(1072,7851,40719,19,21,NULL,NULL,NULL,513,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2003.90,NULL,NULL,1,'2023-03-03 19:00:53','2023-03-03 19:00:53',NULL),(1073,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',20000.00,'2023-03 RM Poblet Villa María',NULL,1,'2023-03-07 20:23:17','2023-03-07 20:23:17',NULL),(1074,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',17000.00,'2023-02 Personales EAHP',NULL,1,'2023-03-07 20:46:33','2023-03-07 20:47:48','2023-03-07 20:47:48'),(1075,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',30000.00,'2023-03 Extracción efectivo Familia HP',NULL,1,'2023-03-07 20:47:40','2023-03-07 20:47:40',NULL);
INSERT INTO `balance_libro` VALUES (1076,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',17000.00,'2023-03 Personales EAHP',NULL,1,'2023-03-07 20:47:48','2023-03-07 20:47:48',NULL),(1077,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10.00,'2023-03 Personales Familia HP',NULL,1,'2023-03-07 20:50:59','2023-03-07 20:50:59',NULL),(1078,7851,40719,20,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1568772.24,NULL,NULL,1,'2023-03-07 21:04:26','2023-03-07 21:04:26',NULL),(1079,7851,40719,20,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8000.00,NULL,NULL,1,'2023-03-07 21:04:26','2023-03-07 21:04:26',NULL),(1080,7851,40719,20,20,NULL,NULL,NULL,516,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1568772.24,NULL,NULL,1,'2023-03-07 21:08:54','2023-04-10 16:22:21','2023-04-10 16:22:21'),(1081,7851,40719,19,3,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3399.99,NULL,NULL,1,'2023-03-07 22:55:25','2023-03-07 22:55:25',NULL),(1082,7851,40719,19,21,NULL,NULL,NULL,518,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3399.99,NULL,NULL,1,'2023-03-07 22:56:03','2023-03-07 22:56:03',NULL),(1083,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',200374.80,'2023-03 Banco Santander FCI Ahorro Familia HP Rescate',NULL,1,'2023-03-07 22:59:17','2023-03-07 22:59:17',NULL),(1084,7851,40719,20,3,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',34400.00,NULL,NULL,1,'2023-03-07 23:00:17','2023-04-01 19:22:45','2023-04-01 19:22:45'),(1085,7851,40719,20,3,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2085.80,NULL,NULL,1,'2023-03-07 23:00:17','2023-04-01 19:23:08','2023-04-01 19:23:08'),(1086,7851,40719,20,3,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',10504.61,NULL,NULL,1,'2023-03-07 23:00:17','2023-03-07 23:00:50','2023-03-07 23:00:50'),(1087,7851,40719,20,3,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10700.40,NULL,NULL,1,'2023-03-07 23:00:17','2023-03-07 23:00:39','2023-03-07 23:00:39'),(1088,7851,40719,20,3,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10700.40,NULL,NULL,1,'2023-03-07 23:00:39','2023-04-01 19:24:20','2023-04-01 19:24:20'),(1089,7851,40719,20,3,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',10504.60,NULL,NULL,1,'2023-03-07 23:00:50','2023-04-01 19:23:37','2023-04-01 19:23:37'),(1090,7851,40719,20,21,NULL,NULL,NULL,525,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',34400.00,NULL,NULL,1,'2023-03-07 23:01:35','2023-04-01 19:11:39','2023-04-01 19:11:39'),(1091,7851,40719,20,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',0.34,'2023-03 Banco Santander CA Intereses',NULL,1,'2023-03-07 23:03:46','2023-03-07 23:03:46',NULL),(1092,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',52.40,'2023-03 Intereses por descubierto',NULL,1,'2023-03-07 23:06:13','2023-03-07 23:07:50','2023-03-07 23:07:50'),(1093,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',11.00,'2023-03 Banco Santander CC ARS Descubierto IVA',NULL,1,'2023-03-07 23:07:29','2023-03-07 23:07:29',NULL),(1094,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',52.40,'2023-03 Banco Santander CC ARS Descubierto Intereses',NULL,1,'2023-03-07 23:07:50','2023-03-14 10:38:51','2023-03-14 10:38:51'),(1095,7851,40719,20,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1.23,'2023-03 Banco Santander CC ARS Descubierto Sellos',NULL,1,'2023-03-07 23:08:45','2023-03-07 23:09:00','2023-03-07 23:09:00'),(1096,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1.23,'2023-03 Banco Santander CC ARS Descubierto Sellos',NULL,1,'2023-03-07 23:09:00','2023-03-07 23:09:00',NULL);
INSERT INTO `balance_libro` VALUES (1097,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',200000.00,'2023-03 Personales Familia HP',NULL,1,'2023-03-08 15:21:07','2023-03-08 15:22:34','2023-03-08 15:22:34'),(1098,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',200000.00,'2023-03 Banco Supervielle FCI Salud Suscripción',NULL,1,'2023-03-08 15:22:10','2023-03-08 15:22:10',NULL),(1099,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',300000.00,'2023-03 Personales Familia HP',NULL,1,'2023-03-08 15:22:34','2023-03-08 15:22:34',NULL),(1100,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',200000.00,'2023-03 Transferencia entre cuentas',NULL,1,'2023-03-08 15:23:10','2023-03-08 15:23:10',NULL),(1101,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',70802.19,'2023-02 Tarjeta Naranja Pago',NULL,1,'2023-03-08 15:24:48','2023-03-08 15:24:48',NULL),(1102,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',140000.00,'2023-03 Banco Supervielle FCI Finca La Llave Suscripción',NULL,1,'2023-03-08 15:26:45','2023-03-08 15:26:45',NULL),(1103,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',200000.00,'2023-03 Movimiento entre cuentas',NULL,1,'2023-03-09 13:11:46','2023-03-09 13:11:46',NULL),(1104,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8325.00,'2023-03 LH175INTE',NULL,1,'2023-03-09 13:12:40','2023-03-09 13:12:40',NULL),(1105,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',42364.00,'2023-03 AE327IR ATM Patente',NULL,1,'2023-03-09 13:13:48','2023-03-09 13:13:48',NULL),(1106,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1405.29,'2023-03 LH175AGUA',NULL,1,'2023-03-09 13:14:48','2023-03-09 13:16:00','2023-03-09 13:16:00'),(1107,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1405.29,'2023-03 LH175AGUA',NULL,1,'2023-03-09 13:15:39','2023-03-09 13:15:53','2023-03-09 13:15:53'),(1108,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1405.29,'2023-03 LH175AGUA C2',NULL,1,'2023-03-09 13:15:53','2023-03-09 13:15:53',NULL),(1109,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1405.29,'2023-03 LH175AGUA C1',NULL,1,'2023-03-09 13:16:00','2023-03-09 13:16:00',NULL),(1110,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1155.78,'2023-02 LH167AGUA Las Heras 175',NULL,1,'2023-03-09 13:16:50','2023-03-09 13:17:54','2023-03-09 13:17:54'),(1111,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1155.78,'2023-03 LH167AGUA',NULL,1,'2023-03-09 13:17:33','2023-03-09 13:18:06','2023-03-09 13:18:06'),(1112,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1155.78,'2023-03 LH167AGUA C1',NULL,1,'2023-03-09 13:17:54','2023-03-09 13:17:54',NULL),(1113,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1155.78,'2023-03 LH167AGUA C2',NULL,1,'2023-03-09 13:18:06','2023-03-09 13:18:06',NULL),(1114,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',200000.00,'2023-03 Movimiento entre cuentas',NULL,1,'2023-03-09 13:19:05','2023-03-09 13:22:26','2023-03-09 13:22:26'),(1115,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',100000.00,'2023-03 Movimiento entre cuentas',NULL,1,'2023-03-09 13:22:26','2023-03-09 13:22:26',NULL),(1116,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',50000.00,'2023-03 Movimiento entre cuentas',NULL,1,'2023-03-09 13:22:59','2023-03-09 13:22:59',NULL);
INSERT INTO `balance_libro` VALUES (1117,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',50000.00,'2023-03 Movimiento entre cuentas',NULL,1,'2023-03-09 13:23:29','2023-03-09 13:23:29',NULL),(1118,7851,40719,19,3,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',26001.00,NULL,NULL,1,'2023-03-10 10:38:19','2023-03-10 10:38:19',NULL),(1119,7851,40719,19,3,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',2500.08,NULL,NULL,1,'2023-03-10 10:39:26','2023-03-10 10:39:26',NULL),(1120,7851,40719,19,3,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3000.01,NULL,NULL,1,'2023-03-10 10:39:53','2023-03-10 10:39:53',NULL),(1121,7851,40719,19,3,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1999.94,NULL,NULL,1,'2023-03-10 10:40:23','2023-03-10 11:59:59','2023-03-10 11:59:59'),(1122,7851,40719,19,3,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1000.08,NULL,NULL,1,'2023-03-10 10:40:56','2023-03-10 10:40:56',NULL),(1123,7851,40719,20,3,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',10000.00,NULL,NULL,1,'2023-03-10 10:46:31','2023-04-01 19:24:49','2023-04-01 19:24:49'),(1124,7851,40719,20,3,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',15100.00,NULL,NULL,1,'2023-03-10 10:46:31','2023-04-01 19:25:08','2023-04-01 19:25:08'),(1125,7851,40719,20,3,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10200.29,NULL,NULL,1,'2023-03-10 10:52:55','2023-03-10 10:52:55',NULL),(1126,7851,40719,20,3,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5000.59,NULL,NULL,1,'2023-03-10 10:54:17','2023-03-10 12:48:21','2023-03-10 12:48:21'),(1127,7851,40719,20,3,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8500.97,NULL,NULL,1,'2023-03-10 10:56:29','2023-03-10 10:56:29',NULL),(1128,7851,40719,20,3,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2000.06,NULL,NULL,1,'2023-03-10 10:57:07','2023-03-10 10:57:07',NULL),(1129,7851,40719,20,3,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3000.01,NULL,NULL,1,'2023-03-10 10:58:31','2023-03-10 10:58:31',NULL),(1130,7851,40719,20,3,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',16309.99,NULL,NULL,1,'2023-03-10 10:59:26','2023-03-10 10:59:26',NULL),(1131,7851,40719,19,21,NULL,NULL,NULL,539,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',26001.00,NULL,NULL,1,'2023-03-10 11:03:53','2023-03-10 11:03:53',NULL),(1132,7851,40719,20,21,NULL,NULL,NULL,540,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2085.80,NULL,NULL,1,'2023-03-10 11:05:20','2023-04-01 19:22:02','2023-04-01 19:22:02'),(1133,7851,40719,20,21,NULL,NULL,NULL,541,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',16309.99,NULL,NULL,1,'2023-03-10 11:20:19','2023-03-10 11:20:19',NULL),(1134,7851,40719,19,21,NULL,NULL,NULL,542,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5500.09,NULL,NULL,1,'2023-03-10 11:54:29','2023-03-10 11:54:29',NULL),(1135,7851,40719,19,3,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1999.94,NULL,NULL,1,'2023-03-10 11:59:59','2023-03-10 11:59:59',NULL),(1136,7851,40719,19,21,NULL,NULL,NULL,544,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3000.02,NULL,NULL,1,'2023-03-10 12:02:32','2023-03-10 12:02:32',NULL),(1137,7851,40719,19,21,NULL,NULL,NULL,545,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4500.00,NULL,NULL,1,'2023-03-10 12:05:08','2023-03-10 13:13:35','2023-03-10 13:13:35'),(1138,7851,40719,19,21,NULL,NULL,NULL,546,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',7500.00,NULL,NULL,1,'2023-03-10 12:08:52','2023-03-10 12:08:52',NULL),(1139,7851,40719,20,3,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5000.59,NULL,NULL,1,'2023-03-10 12:48:21','2023-03-10 12:48:21',NULL),(1140,7851,40719,20,21,NULL,NULL,NULL,548,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',15100.00,NULL,NULL,1,'2023-03-10 12:51:45','2023-04-01 19:21:11','2023-04-01 19:21:11');
INSERT INTO `balance_libro` VALUES (1141,7851,40719,20,21,NULL,NULL,NULL,549,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',13501.04,NULL,NULL,1,'2023-03-10 12:54:40','2023-03-10 12:54:40',NULL),(1142,7851,40719,20,21,NULL,NULL,NULL,550,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5000.59,NULL,NULL,1,'2023-03-10 13:02:41','2023-03-10 13:02:41',NULL),(1143,7851,40719,20,21,NULL,NULL,NULL,551,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',10504.60,NULL,NULL,1,'2023-03-10 13:05:06','2023-04-01 19:21:37','2023-04-01 19:21:37'),(1144,7851,40719,20,21,NULL,NULL,NULL,552,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10700.40,NULL,NULL,1,'2023-03-10 13:07:54','2023-04-01 19:21:49','2023-04-01 19:21:49'),(1145,7851,40719,20,21,NULL,NULL,NULL,553,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10200.29,NULL,NULL,1,'2023-03-10 13:08:51','2023-03-10 13:08:51',NULL),(1146,7851,40719,19,21,NULL,NULL,NULL,554,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4500.00,NULL,NULL,1,'2023-03-10 13:14:03','2023-03-10 13:14:03',NULL),(1147,7851,40719,19,3,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',15077.78,NULL,NULL,1,'2023-03-12 18:35:42','2023-03-12 18:35:42',NULL),(1148,7851,40719,19,21,NULL,NULL,NULL,556,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',15077.78,NULL,NULL,1,'2023-03-12 18:36:44','2023-03-12 18:36:44',NULL),(1149,7851,40719,19,21,NULL,NULL,NULL,557,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1785.57,NULL,NULL,1,'2023-03-12 18:37:14','2023-03-12 18:37:14',NULL),(1150,7851,40719,20,3,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',7600.00,NULL,NULL,1,'2023-03-12 18:50:30','2023-04-01 19:22:25','2023-04-01 19:22:25'),(1151,7851,40719,20,3,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',34998.04,NULL,NULL,1,'2023-03-12 18:50:30','2023-04-01 19:20:21','2023-04-01 19:20:21'),(1152,7851,40719,20,3,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',6401.31,NULL,NULL,1,'2023-03-12 18:57:34','2023-03-12 18:57:34',NULL),(1153,7851,40719,20,3,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3900.98,NULL,NULL,1,'2023-03-12 19:00:43','2023-03-12 19:00:43',NULL),(1154,7851,40719,20,3,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3625.00,NULL,NULL,1,'2023-03-12 19:06:42','2023-03-12 19:06:42',NULL),(1155,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3566.72,'2023-03 Banco Supervielle Tarjeta Visa',NULL,1,'2023-03-14 10:11:48','2023-03-14 10:11:48',NULL),(1156,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',4820.00,'2023-03 Personales JCH Comida Realicó',NULL,1,'2023-03-14 10:12:44','2023-03-14 10:12:44',NULL),(1157,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',100000.00,'2023-03 Movimiento entre cuentas',NULL,1,'2023-03-14 10:14:21','2023-03-14 10:14:21',NULL),(1158,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',40000.00,'2023-03 Extracción efectivo Familia HP',NULL,1,'2023-03-14 10:23:51','2023-03-14 10:23:51',NULL),(1159,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',40000.00,'2023-03 Movimiento entre cuentas',NULL,1,'2023-03-14 10:26:50','2023-03-14 10:31:00','2023-03-14 10:31:00'),(1160,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',40000.00,'2023-03 Movimiento entre cuentas',NULL,1,'2023-03-14 10:27:37','2023-03-14 10:31:08','2023-03-14 10:31:08'),(1161,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',40000.00,'2023-03 Extracción efectivo Familia HP',NULL,1,'2023-03-14 10:31:00','2023-03-14 10:31:00',NULL),(1162,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',40000.00,'2023-03 Extracción efectivo Familia HP',NULL,1,'2023-03-14 10:31:08','2023-03-14 10:31:08',NULL);
INSERT INTO `balance_libro` VALUES (1163,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',35140.01,'2023-03 Banco Supervielle Tarjeta Mastercard',NULL,1,'2023-03-14 10:33:03','2023-03-14 10:33:03',NULL),(1164,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',52.40,'2023-03 Banco Santander CC ARS Descubierto Intereses',NULL,1,'2023-03-14 10:38:51','2023-03-14 10:38:51',NULL),(1165,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',0.39,'2023-03 Impuesto débitos y créditos bancarios descubierto',NULL,1,'2023-03-14 10:40:24','2023-03-14 10:40:24',NULL),(1166,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',65.02,'2023-03 Banco Supervielle Compensación CA CC',NULL,1,'2023-03-14 10:41:10','2023-03-14 10:41:10',NULL),(1167,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',12989.50,'2023 ATM Patente KUU191',NULL,1,'2023-03-14 10:43:44','2023-03-14 10:49:29','2023-03-14 10:49:29'),(1168,7851,40719,20,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',12045.95,'2023-03 Egreso deuda AFIP',NULL,1,'2023-03-14 10:46:45','2023-03-14 10:46:45',NULL),(1169,7851,40719,20,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',10989.09,'2023-03 Pago deuda AFIP',NULL,1,'2023-03-14 10:47:23','2023-03-14 10:47:23',NULL),(1170,7851,40719,20,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1056.86,'2023-03 Pago deuda AFIP',NULL,1,'2023-03-14 10:48:05','2023-03-14 10:48:05',NULL),(1171,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',21802.20,'2023 ATM Patente KLG771',NULL,1,'2023-03-14 10:48:49','2023-03-14 10:49:18','2023-03-14 10:49:18'),(1172,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',21802.20,'2023 KLG771 ATM Patente',NULL,1,'2023-03-14 10:49:18','2023-03-14 10:49:18',NULL),(1173,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',12989.50,'2023 KUU191 ATM Patente',NULL,1,'2023-03-14 10:49:29','2023-03-14 10:49:29',NULL),(1174,7851,40719,20,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',18125.95,'2023-03 Egreso SUSS 1595',NULL,1,'2023-03-14 10:50:18','2023-03-14 10:50:18',NULL),(1175,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',18125.95,'2023-03 Pago SUSS 1595',NULL,1,'2023-03-14 10:50:40','2023-03-14 10:50:40',NULL),(1176,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',35164.09,'2023-03 Banco Santander Tarjeta Visa',NULL,1,'2023-03-14 10:53:33','2023-03-14 10:53:33',NULL),(1177,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',91638.09,'2023-03 Banco Santander Tarjeta AMEX',NULL,1,'2023-03-14 10:53:58','2023-03-14 10:53:58',NULL),(1178,7851,40719,20,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',57635.38,'2022-12 IVA Pago',NULL,1,'2023-03-14 10:56:53','2023-03-14 10:56:53',NULL),(1179,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',50000.00,'2023-03 Movimiento entre cuentas',NULL,1,'2023-03-14 11:08:03','2023-03-14 11:08:03',NULL),(1180,7851,40719,20,21,NULL,NULL,NULL,563,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3900.98,NULL,NULL,1,'2023-03-14 11:34:31','2023-03-14 11:34:31',NULL),(1181,7851,40719,20,21,NULL,NULL,NULL,564,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',7600.00,NULL,NULL,1,'2023-03-14 11:35:04','2023-04-01 19:21:01','2023-04-01 19:21:01'),(1182,7851,40719,20,21,NULL,NULL,NULL,565,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',6401.31,NULL,NULL,1,'2023-03-14 11:35:34','2023-03-14 11:35:34',NULL),(1183,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3060.00,'2023-03 Pago Google',NULL,1,'2023-03-14 11:46:58','2023-03-14 11:46:58',NULL);
INSERT INTO `balance_libro` VALUES (1184,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',260798.60,'2023-03 Banco Santander FCI Ahorro Familia HP Suscripción',NULL,1,'2023-03-14 11:54:16','2023-03-14 11:54:16',NULL),(1185,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',64904.54,'2023-03 Banco Santander FCI Ahorro Familia HP Suscripción',NULL,1,'2023-03-14 11:59:34','2023-03-14 11:59:34',NULL),(1186,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',64904.54,'2023-03 Banco Santander FCI IVA2022-12',NULL,1,'2023-03-14 12:00:27','2023-03-14 12:00:27',NULL),(1187,7851,40719,19,15,NULL,700,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',28541.55,NULL,NULL,1,'2023-03-22 10:48:59','2023-03-22 10:48:59',NULL),(1188,7851,40719,20,3,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2999.94,NULL,NULL,1,'2023-03-23 17:44:42','2023-03-23 17:44:42',NULL),(1189,7851,40719,20,3,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',25200.01,NULL,NULL,1,'2023-03-23 17:46:30','2023-03-23 17:46:30',NULL),(1190,7851,40719,20,3,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',18000.00,NULL,NULL,1,'2023-03-23 17:48:24','2023-03-23 17:48:24',NULL),(1191,7851,40719,20,21,NULL,NULL,NULL,569,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',18000.00,NULL,NULL,1,'2023-03-23 17:51:13','2023-03-23 17:51:13',NULL),(1192,7851,40719,20,21,NULL,NULL,NULL,570,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',25200.01,NULL,NULL,1,'2023-03-23 17:52:07','2023-03-23 17:52:07',NULL),(1193,7851,40719,20,21,NULL,NULL,NULL,571,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2999.94,NULL,NULL,1,'2023-03-23 17:53:22','2023-03-23 17:53:22',NULL),(1194,7851,40719,20,20,NULL,NULL,NULL,572,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',27500.01,NULL,NULL,1,'2023-03-23 17:56:22','2023-03-28 11:33:44','2023-03-28 11:33:44'),(1195,7851,40719,20,3,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6100.22,NULL,NULL,1,'2023-03-23 23:51:16','2023-03-23 23:51:16',NULL),(1196,7851,40719,20,3,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6600.29,NULL,NULL,1,'2023-03-23 23:52:34','2023-03-23 23:52:34',NULL),(1197,7851,40719,20,3,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',29200.00,NULL,NULL,1,'2023-03-23 23:53:43','2023-03-23 23:53:43',NULL),(1198,7851,40719,20,3,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',8301.68,NULL,NULL,1,'2023-03-23 23:55:41','2023-03-23 23:55:41',NULL),(1199,7851,40719,20,3,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',7499.95,NULL,NULL,1,'2023-03-23 23:57:33','2023-03-23 23:57:33',NULL),(1200,7851,40719,20,3,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5500.16,NULL,NULL,1,'2023-03-23 23:59:13','2023-03-23 23:59:13',NULL),(1201,7851,40719,20,3,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',6401.38,NULL,NULL,1,'2023-03-24 00:00:50','2023-03-24 00:00:50',NULL),(1202,7851,40719,20,21,NULL,NULL,NULL,580,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6100.22,NULL,NULL,1,'2023-03-24 00:01:56','2023-03-24 00:02:07','2023-03-24 00:02:07'),(1203,7851,40719,20,21,NULL,NULL,NULL,581,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6100.22,NULL,NULL,1,'2023-03-24 00:02:38','2023-03-24 00:02:38',NULL),(1204,7851,40719,20,21,NULL,NULL,NULL,582,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',29200.00,NULL,NULL,1,'2023-03-24 00:03:36','2023-03-24 00:03:36',NULL),(1205,7851,40719,20,21,NULL,NULL,NULL,583,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',6401.38,NULL,NULL,1,'2023-03-24 00:14:42','2023-03-24 00:14:42',NULL),(1206,7851,40719,20,21,NULL,NULL,NULL,584,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5500.16,NULL,NULL,1,'2023-03-24 00:15:36','2023-03-24 00:15:36',NULL),(1207,7851,40719,20,21,NULL,NULL,NULL,585,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',7499.95,NULL,NULL,1,'2023-03-24 00:16:22','2023-03-24 00:16:22',NULL);
INSERT INTO `balance_libro` VALUES (1208,7851,40719,20,21,NULL,NULL,NULL,586,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',8301.68,NULL,NULL,1,'2023-03-24 00:17:10','2023-03-24 00:17:10',NULL),(1209,7851,40719,20,20,NULL,NULL,NULL,587,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6600.29,NULL,NULL,1,'2023-03-24 00:18:16','2023-03-28 11:31:55','2023-03-28 11:31:55'),(1210,7851,40719,20,3,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',22100.00,NULL,NULL,1,'2023-03-25 15:17:24','2023-03-25 15:17:24',NULL),(1211,7851,40719,20,21,NULL,NULL,NULL,589,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',22100.00,NULL,NULL,1,'2023-03-25 15:18:20','2023-03-25 15:18:20',NULL),(1212,7851,40719,20,3,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',9600.20,NULL,NULL,1,'2023-03-28 00:11:15','2023-03-28 00:11:15',NULL),(1213,7851,40719,20,21,NULL,NULL,NULL,591,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',9600.20,NULL,NULL,1,'2023-03-28 00:17:11','2023-03-28 00:17:11',NULL),(1214,7851,40719,20,3,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',7329.99,NULL,NULL,1,'2023-03-28 11:31:07','2023-03-28 11:31:07',NULL),(1215,7851,40719,20,21,NULL,NULL,NULL,593,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',6600.29,NULL,NULL,1,'2023-03-28 11:32:41','2023-03-28 11:32:41',NULL),(1216,7851,40719,20,21,NULL,NULL,NULL,594,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',7329.99,NULL,NULL,1,'2023-03-28 11:33:25','2023-03-28 11:33:25',NULL),(1217,7851,40719,10,21,NULL,NULL,NULL,595,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',27500.01,NULL,NULL,1,'2023-03-28 11:34:45','2023-03-28 11:34:45',NULL),(1218,7851,40719,20,3,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2500.01,NULL,NULL,1,'2023-03-30 12:33:18','2023-03-30 12:33:18',NULL),(1219,7851,40719,20,3,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',20800.00,NULL,NULL,1,'2023-03-30 12:34:33','2023-03-30 12:34:33',NULL),(1220,7851,40719,20,21,NULL,NULL,NULL,598,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',20800.00,NULL,NULL,1,'2023-03-31 16:58:46','2023-04-01 00:43:25','2023-04-01 00:43:25'),(1221,7851,40719,20,21,NULL,NULL,NULL,599,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2500.01,NULL,NULL,1,'2023-03-31 16:59:27','2023-03-31 16:59:27',NULL),(1222,7851,40719,20,3,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6305.32,NULL,NULL,1,'2023-03-31 17:00:59','2023-03-31 17:00:59',NULL),(1223,7851,40719,20,3,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6000.00,NULL,NULL,1,'2023-03-31 17:02:16','2023-03-31 17:02:16',NULL),(1224,7851,40719,20,21,NULL,NULL,NULL,602,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6305.32,NULL,NULL,1,'2023-03-31 17:03:06','2023-03-31 17:03:06',NULL),(1225,7851,40719,20,21,NULL,NULL,NULL,603,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',10000.00,'En realidad se pagaron $5000 con MP JCH CA ARS pero la factura la hicieron por $10.0000',NULL,1,'2023-03-31 17:09:45','2023-04-01 19:21:21','2023-04-01 19:21:21'),(1226,7851,40719,20,21,NULL,NULL,NULL,604,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6000.00,NULL,NULL,1,'2023-03-31 17:10:12','2023-03-31 17:10:12',NULL),(1227,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1352.52,'2023-03 LH175GAS',NULL,1,'2023-03-31 18:14:16','2023-03-31 18:14:16',NULL),(1228,7851,40719,20,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',111689.83,'2023-03 Jubilación',NULL,1,'2023-03-31 18:18:03','2023-03-31 18:18:03',NULL),(1229,7851,40719,19,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',93789.21,'2023-02 Jubilación',NULL,1,'2023-03-31 18:18:33','2023-03-31 18:18:33',NULL),(1230,7851,40719,18,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',104624.37,'2023-01 Jubilación',NULL,1,'2023-03-31 18:18:49','2023-03-31 18:18:49',NULL);
INSERT INTO `balance_libro` VALUES (1231,7851,40719,13,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',90446.52,'2022-11 Jubilación',NULL,1,'2023-03-31 18:19:38','2023-03-31 18:19:38',NULL),(1232,7851,40719,12,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',90442.66,'2022-10 Jubilación',NULL,1,'2023-03-31 18:19:53','2023-03-31 18:19:53',NULL),(1233,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5000.00,'2023-02 Personales MPHP',NULL,1,'2023-03-31 18:21:57','2023-03-31 18:21:57',NULL),(1234,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',8386.56,'2023-03 Banco Supervielle Préstamo Pago Cuota',NULL,1,'2023-03-31 18:28:00','2023-03-31 18:28:00',NULL),(1235,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',24000.00,'2023-03 Personales Familia HP (Cabaña Merlo)',NULL,1,'2023-03-31 18:34:13','2023-03-31 18:34:13',NULL),(1236,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1198.34,'2023-03 Banco Supervielle Mantenimiento',NULL,1,'2023-03-31 18:39:29','2023-03-31 18:39:29',NULL),(1237,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',251.65,'2023-03 Banco Supervielle Mantenimiento IVA',NULL,1,'2023-03-31 18:40:52','2023-03-31 18:40:52',NULL),(1238,7851,40719,20,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.01,'2023-03 Banco Supervielle CA ARS Ajuste',NULL,1,'2023-03-31 18:46:47','2023-03-31 18:46:47',NULL),(1239,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',202525.35,'2023-03 Banco Santander FCI Ahorro Familia HP Rescate',NULL,1,'2023-03-31 19:09:16','2023-03-31 19:09:16',NULL),(1240,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2085.80,'2023-03 Banco Santander Traspaso CC a CA',NULL,1,'2023-03-31 19:18:44','2023-03-31 19:18:44',NULL),(1241,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2085.80,'2023-03 Banco Santander Traspaso CA a CC',NULL,1,'2023-03-31 19:19:40','2023-03-31 19:19:40',NULL),(1242,7851,40719,20,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',52290.00,'2023-03 Egreso Sueldos 1595',NULL,1,'2023-03-31 19:20:53','2023-03-31 19:20:53',NULL),(1243,7851,40719,20,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',87710.00,'2023-03 Egreso Servicios WR 1595',NULL,1,'2023-03-31 19:21:25','2023-04-01 19:37:58','2023-04-01 19:37:58'),(1244,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',87710.00,'2023-03 Pago Servicios WR 1595',NULL,1,'2023-03-31 19:22:14','2023-03-31 19:22:14',NULL),(1245,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',52290.00,'2023-03 Pago Sueldos 1595',NULL,1,'2023-03-31 19:22:40','2023-03-31 19:22:40',NULL),(1246,7851,40719,20,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.57,'2023-03 Banco Santander CA ARS Redondeo',NULL,1,'2023-03-31 19:28:47','2023-03-31 19:28:47',NULL),(1247,7851,40719,20,21,NULL,NULL,NULL,605,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',20800.00,NULL,NULL,1,'2023-04-01 00:43:59','2023-04-01 00:43:59',NULL),(1248,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',20000.00,'2023-03 Movimiento entre cuentas Combustible',NULL,1,'2023-04-01 00:52:38','2023-04-01 00:52:38',NULL),(1249,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',10000.00,'2023-03 Gastos personales EAHP',NULL,1,'2023-04-01 01:01:45','2023-04-01 01:01:45',NULL),(1250,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',4000.00,'2023-03 Gastos personales EAHP Compensación por sellos',NULL,1,'2023-04-01 01:06:41','2023-04-01 01:08:02','2023-04-01 01:08:02');
INSERT INTO `balance_libro` VALUES (1251,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',4100.00,'2023-03 Compra sellos',NULL,1,'2023-04-01 01:07:29','2023-04-01 01:07:29',NULL),(1252,7851,40719,20,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',4000.00,'2023-03 Compra sellos (pagó EAHP en efectivo)',NULL,1,'2023-04-01 01:08:02','2023-04-01 01:08:02',NULL),(1253,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.31,'2023-03 MP JCH Redondeo',NULL,1,'2023-04-01 01:14:08','2023-04-01 01:14:08',NULL),(1254,7851,40719,10,20,NULL,NULL,NULL,606,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',24000.00,NULL,NULL,1,'2023-04-01 18:47:08','2023-04-01 18:47:08',NULL),(1255,7851,40719,10,21,NULL,NULL,NULL,607,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',28273.83,NULL,NULL,1,'2023-04-01 18:51:27','2023-04-01 18:52:14','2023-04-01 18:52:14'),(1256,7851,40719,10,21,NULL,NULL,NULL,608,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',25273.82,NULL,NULL,1,'2023-04-01 18:54:26','2023-04-01 18:54:26',NULL),(1257,7851,40719,10,21,NULL,NULL,NULL,609,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',4232.92,NULL,NULL,1,'2023-04-01 18:57:25','2023-04-01 18:57:25',NULL),(1258,7851,40719,20,21,NULL,NULL,NULL,610,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',34998.04,NULL,NULL,1,'2023-04-01 19:19:50','2023-04-01 19:19:58','2023-04-01 19:19:58'),(1259,7851,40719,20,3,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',34998.04,NULL,NULL,1,'2023-04-01 19:20:21','2023-04-01 19:25:54','2023-04-01 19:25:54'),(1260,7851,40719,20,3,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',7600.00,NULL,NULL,1,'2023-04-01 19:22:25','2023-04-01 19:25:39','2023-04-01 19:25:39'),(1261,7851,40719,20,3,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',34400.00,NULL,NULL,1,'2023-04-01 19:22:45','2023-04-01 19:22:45',NULL),(1262,7851,40719,20,3,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2085.80,NULL,NULL,1,'2023-04-01 19:23:08','2023-04-01 19:23:08',NULL),(1263,7851,40719,20,3,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',10504.60,NULL,NULL,1,'2023-04-01 19:23:37','2023-04-01 19:23:37',NULL),(1264,7851,40719,20,3,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10700.40,NULL,NULL,1,'2023-04-01 19:24:20','2023-04-01 19:24:20',NULL),(1265,7851,40719,20,3,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',10000.00,NULL,NULL,1,'2023-04-01 19:24:49','2023-04-01 19:24:49',NULL),(1266,7851,40719,20,3,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',15100.00,NULL,NULL,1,'2023-04-01 19:25:08','2023-04-01 19:25:08',NULL),(1267,7851,40719,20,3,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',7600.00,NULL,NULL,1,'2023-04-01 19:25:39','2023-04-01 19:25:39',NULL),(1268,7851,40719,20,3,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',34998.04,NULL,NULL,1,'2023-04-01 19:25:54','2023-04-01 19:25:54',NULL),(1269,7851,40719,20,21,NULL,NULL,NULL,621,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',34998.04,NULL,NULL,1,'2023-04-01 19:27:58','2023-04-01 19:27:58',NULL),(1270,7851,40719,20,21,NULL,NULL,NULL,622,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',7600.00,NULL,NULL,1,'2023-04-01 19:30:52','2023-04-01 19:30:52',NULL),(1271,7851,40719,20,21,NULL,NULL,NULL,623,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',15100.00,NULL,NULL,1,'2023-04-01 19:31:25','2023-04-01 19:31:25',NULL),(1272,7851,40719,20,21,NULL,NULL,NULL,624,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',10000.00,NULL,NULL,1,'2023-04-01 19:32:38','2023-04-01 19:32:38',NULL),(1273,7851,40719,20,21,NULL,NULL,NULL,625,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',10504.60,NULL,NULL,1,'2023-04-01 19:33:48','2023-04-01 19:33:48',NULL),(1274,7851,40719,20,21,NULL,NULL,NULL,626,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10700.40,NULL,NULL,1,'2023-04-01 19:34:39','2023-04-01 19:34:39',NULL);
INSERT INTO `balance_libro` VALUES (1275,7851,40719,20,21,NULL,NULL,NULL,627,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2085.80,NULL,NULL,1,'2023-04-01 19:35:21','2023-04-01 19:35:21',NULL),(1276,7851,40719,20,21,NULL,NULL,NULL,628,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',34400.00,NULL,NULL,1,'2023-04-01 19:36:13','2023-04-01 19:36:13',NULL),(1277,7851,40719,20,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',87710.00,'2023-03 Egreso Servicios WR 1595',NULL,1,'2023-04-01 19:37:58','2023-04-01 19:37:58',NULL),(1278,7851,40719,10,21,NULL,NULL,NULL,629,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',49200.62,NULL,NULL,1,'2023-04-01 19:43:03','2023-04-01 19:43:03',NULL),(1279,7851,40719,10,21,NULL,NULL,NULL,630,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',10652.82,NULL,NULL,1,'2023-04-01 19:43:44','2023-04-01 19:43:44',NULL),(1280,7851,40719,10,21,NULL,NULL,NULL,631,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',22800.01,NULL,NULL,1,'2023-04-01 19:44:17','2023-04-01 19:44:17',NULL),(1281,7851,40719,20,3,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',17677.43,NULL,NULL,1,'2023-04-05 12:09:58','2023-04-05 12:11:19','2023-04-05 12:11:19'),(1282,7851,40719,20,21,NULL,NULL,NULL,633,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',17677.43,NULL,NULL,1,'2023-04-05 12:11:18','2023-04-13 19:01:28','2023-04-13 19:01:28'),(1283,7851,40719,20,3,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',17677.43,NULL,NULL,1,'2023-04-05 12:11:19','2023-04-05 12:11:19',NULL),(1286,7851,40719,20,3,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1785.57,NULL,NULL,1,'2023-04-05 12:13:41','2023-04-05 12:14:13','2023-04-05 12:14:13'),(1287,7851,40719,20,21,NULL,NULL,NULL,638,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1785.57,NULL,NULL,1,'2023-04-05 12:14:13','2023-04-13 19:01:32','2023-04-13 19:01:32'),(1288,7851,40719,20,3,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1785.57,NULL,NULL,1,'2023-04-05 12:14:13','2023-04-05 12:14:13',NULL),(1289,7851,40719,20,20,NULL,NULL,NULL,640,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1568772.24,NULL,NULL,1,'2023-04-10 16:27:56','2023-04-10 16:27:56',NULL),(1290,7851,40719,21,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',2483889.38,NULL,NULL,1,'2023-04-10 16:29:56','2023-04-10 16:29:56',NULL),(1291,7851,40719,21,20,NULL,NULL,NULL,642,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',2483889.38,NULL,NULL,1,'2023-04-10 16:33:50','2023-04-10 16:33:50',NULL),(1292,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',400000.00,'2023-04 Personales Familia HP BBVA',NULL,1,'2023-04-10 16:38:44','2023-04-10 16:38:44',NULL),(1293,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',400000.00,'2023-04 Personales Familia HP',NULL,1,'2023-04-10 16:39:30','2023-04-10 16:39:30',NULL),(1294,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',87071.65,'2023-03 Tarjeta Naranja Pago',NULL,1,'2023-04-10 16:40:46','2023-04-10 16:40:46',NULL),(1295,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',150000.00,'2023-04 Banco Supervielle FCI Salud Suscripción',NULL,1,'2023-04-10 16:44:50','2023-04-10 16:44:50',NULL),(1296,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',9300.00,'2023-04 LH175INTE',NULL,1,'2023-04-10 16:48:03','2023-04-10 16:48:03',NULL),(1297,7851,40719,21,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',33566.15,'2023-04 Egreso SUSS 1595',NULL,1,'2023-04-13 18:59:07','2023-04-13 18:59:07',NULL),(1298,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',33566.15,'2023-04 Pago SUSS 1595',NULL,1,'2023-04-13 18:59:42','2023-04-13 18:59:42',NULL),(1299,7851,40719,21,21,NULL,NULL,NULL,643,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',17677.43,NULL,NULL,1,'2023-04-13 19:02:01','2023-04-13 19:02:01',NULL);
INSERT INTO `balance_libro` VALUES (1300,7851,40719,21,21,NULL,NULL,NULL,644,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1785.57,NULL,NULL,1,'2023-04-13 19:02:29','2023-04-13 19:02:29',NULL),(1301,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',10000.00,'2023-04 Movimientos para gastos Nimbus',NULL,1,'2023-04-13 19:47:46','2023-04-13 19:47:46',NULL),(1302,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',24732.55,'2023-04 Banco Santander Tarjeta AMEX',NULL,1,'2023-04-13 20:00:18','2023-04-13 20:00:18',NULL),(1303,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',46323.10,'2023-04 Banco Santander Tarjeta Visa',NULL,1,'2023-04-13 20:19:45','2023-04-13 20:19:45',NULL),(1304,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',501594.19,'2023-04 Banco Santander FCI Rescate',NULL,1,'2023-04-13 21:05:49','2023-04-13 21:05:49',NULL),(1305,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',750000.00,'2023-04 Banco Santander FCI Suscripción',NULL,1,'2023-04-13 21:22:54','2023-04-13 21:22:54',NULL),(1306,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',400000.00,'2023-04 Transferencia para compra de USD',NULL,1,'2023-04-13 21:25:01','2023-04-13 21:25:01',NULL),(1307,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',400000.00,'2023-04 Movimiento para compra de USD',NULL,1,'2023-04-13 21:25:56','2023-04-13 21:26:09','2023-04-13 21:26:09'),(1308,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',400000.00,'2023-04 Transferencia para compra de USD',NULL,1,'2023-04-13 21:26:09','2023-04-13 21:26:09',NULL),(1309,7851,40719,21,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1.85,'2023-04 Banco Santander CA Intereses',NULL,1,'2023-04-13 21:27:53','2023-04-13 21:27:53',NULL),(1310,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',0.29,'2023-04 Transferencia de CA a CC por descubierto',NULL,1,'2023-04-13 21:29:10','2023-04-13 21:29:10',NULL),(1311,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',47.93,'2023-04 Transferencia de CA a CC por descubierto',NULL,1,'2023-04-13 21:48:28','2023-04-13 21:48:28',NULL),(1312,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',415014.00,'2023-04 Préstamo a Familia HP Pasajes',NULL,1,'2023-04-13 22:05:15','2023-05-10 18:16:03','2023-05-10 18:16:03'),(1313,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',0.29,'2023-04 Impuesto débitos y créditos bancarios descubierto',NULL,1,'2023-04-13 22:14:43','2023-04-13 22:14:43',NULL),(1314,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',0.91,'2023-04 Banco Santander CC ARS Descubierto Sellos',NULL,1,'2023-04-13 22:17:38','2023-04-13 22:17:38',NULL),(1315,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',38.86,'2023-03 Banco Santander CC ARS Descubierto Intereses',NULL,1,'2023-04-13 22:19:33','2023-04-13 22:19:33',NULL),(1316,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',38.86,'2023-04 Banco Santander CC ARS Descubierto IVA',NULL,1,'2023-04-13 22:20:29','2023-04-13 22:20:52','2023-04-13 22:20:52'),(1317,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8.16,'2023-04 Banco Santander CC ARS Descubierto IVA',NULL,1,'2023-04-13 22:20:52','2023-04-13 22:20:52',NULL),(1318,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10000.00,'2023-03 Extracción efectivo Familia HP',NULL,1,'2023-04-13 23:06:47','2023-04-13 23:06:47',NULL),(1319,7851,40719,20,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',40000.00,'Extracción efectivo Familia HP',NULL,1,'2023-04-13 23:09:18','2023-04-13 23:09:18',NULL);
INSERT INTO `balance_libro` VALUES (1320,7851,40719,20,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2.98,'2023-03 Banco Supervielle CA ARS Intereses',NULL,1,'2023-04-13 23:10:13','2023-04-13 23:10:13',NULL),(1321,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',10000.00,'2023-04 Personales EAHP',NULL,1,'2023-04-14 00:06:31','2023-04-14 00:06:31',NULL),(1322,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',10000.00,'2023-04 Personales EAHP',NULL,1,'2023-04-14 00:07:17','2023-04-14 00:07:17',NULL),(1323,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1449.99,'2023-03 Banco Supervielle Mantenimiento',NULL,1,'2023-04-14 00:10:02','2023-04-14 00:10:35','2023-04-14 00:10:35'),(1324,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1198.34,'2023-03 Banco Supervielle Mantenimiento',NULL,1,'2023-04-14 00:10:35','2023-04-14 00:11:55','2023-04-14 00:11:55'),(1325,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',251.65,'2023-03 Banco Supervielle Mantenimiento IVA',NULL,1,'2023-04-14 00:11:45','2023-04-14 00:12:04','2023-04-14 00:12:04'),(1326,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1198.34,'2023-04 Banco Supervielle Mantenimiento',NULL,1,'2023-04-14 00:11:55','2023-04-14 00:11:55',NULL),(1327,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',251.65,'2023-04 Banco Supervielle Mantenimiento IVA',NULL,1,'2023-04-14 00:12:04','2023-04-14 00:12:04',NULL),(1328,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',7888.50,'2023-03 LH175ELEC',NULL,1,'2023-04-14 00:15:05','2023-04-14 00:15:05',NULL),(1329,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',7888.50,'2023-03 LH175ELEC',NULL,1,'2023-04-14 00:15:58','2023-04-14 00:15:58',NULL),(1330,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1654.00,'2023-03 LH167ELEC',NULL,1,'2023-04-14 00:17:32','2023-04-14 00:17:32',NULL),(1331,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1654.00,'2023-03 LH167ELEC',NULL,1,'2023-04-14 00:18:20','2023-04-14 00:18:20',NULL),(1332,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',15000.00,'Extracción efectivo Familia HP',NULL,1,'2023-04-14 00:19:51','2023-04-14 00:19:51',NULL),(1333,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',585.38,'2023-03 Banco Supervielle Seguro',NULL,1,'2023-04-14 00:21:24','2023-04-14 00:22:33','2023-04-14 00:22:33'),(1334,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3310.37,'2023-04 Banco Supervielle Seguro',NULL,1,'2023-04-14 00:22:24','2023-04-14 00:22:24',NULL),(1335,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',585.38,'2023-04 Banco Supervielle Seguro',NULL,1,'2023-04-14 00:22:33','2023-04-14 00:22:33',NULL),(1336,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',850000.00,'2023-04 Movimiento compra pasajes',NULL,1,'2023-04-14 00:23:51','2023-04-14 00:23:51',NULL),(1337,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',850000.00,'2023-04 Movimiento compra pasajes',NULL,1,'2023-04-14 00:24:44','2023-04-14 00:24:44',NULL),(1338,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',700000.00,'2023-04 Compra Dólares',NULL,1,'2023-04-14 00:46:13','2023-04-14 00:52:36','2023-04-14 00:52:36'),(1339,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',150000.00,'2023-04 Compra Dolares',NULL,1,'2023-04-14 00:52:26','2023-04-14 00:52:26',NULL);
INSERT INTO `balance_libro` VALUES (1340,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',700000.00,'2023-04 Compra Dolares',NULL,1,'2023-04-14 00:52:36','2023-04-14 00:52:36',NULL),(1341,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',5567.97,'2023-04 Compra Dolares Devolucion por ajuste',NULL,1,'2023-04-14 00:58:45','2023-04-14 00:58:45',NULL),(1342,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',985.62,'2023-04 Compra Dolares Devolucion por ajuste',NULL,1,'2023-04-14 00:59:19','2023-04-14 00:59:19',NULL),(1343,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',2165.00,'2023-03 Banco Supervielle Tarjeta Visa',NULL,1,'2023-04-14 01:02:44','2023-04-14 01:04:14','2023-04-14 01:04:14'),(1344,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',8996.98,'2023-03 Banco Supervielle Tarjeta Mastercard',NULL,1,'2023-04-14 01:03:54','2023-04-14 01:04:06','2023-04-14 01:04:06'),(1345,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',8996.98,'2023-04 Banco Supervielle Tarjeta Mastercard',NULL,1,'2023-04-14 01:04:06','2023-04-14 01:04:06',NULL),(1346,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',2165.00,'2023-04 Banco Supervielle Tarjeta Visa',NULL,1,'2023-04-14 01:04:14','2023-04-14 01:04:14',NULL),(1347,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',40000.00,'Extracción efectivo Familia HP',NULL,1,'2023-04-14 01:05:10','2023-04-14 01:05:10',NULL),(1348,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',49.06,'2023-04 Compra Dolares',NULL,1,'2023-04-14 01:08:13','2023-04-14 19:43:05','2023-04-14 19:43:05'),(1349,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',0.57,'2023-04 Compra Dolares',NULL,1,'2023-04-14 01:09:05','2023-04-14 01:09:05',NULL),(1350,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',10000.00,'2023-04 Gastos personales MPHP EEUU 2023',NULL,1,'2023-04-14 01:14:01','2023-04-14 01:14:01',NULL),(1351,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',7370.04,'2023-04 Finca La Llave ATM Inmobiliario 2023',NULL,1,'2023-04-14 01:18:13','2023-04-14 01:18:13',NULL),(1352,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',5323.87,'2023-04 Personales JCH',NULL,1,'2023-04-14 01:18:59','2023-04-14 01:18:59',NULL),(1353,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',30000.00,'2023-04 1595 Combustible',NULL,1,'2023-04-14 01:28:07','2023-04-14 01:28:07',NULL),(1354,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2185.49,'2023-04 Compra Dolares',NULL,1,'2023-04-14 01:31:13','2023-04-14 01:43:13','2023-04-14 01:43:13'),(1355,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2185.43,'2023-04 Compra Dolares',NULL,1,'2023-04-14 01:31:51','2023-04-14 01:42:53','2023-04-14 01:42:53'),(1356,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',50000.00,'2023-04 Compra Dolares y cancelacion parcial prestamo familia HP',NULL,1,'2023-04-14 01:36:58','2023-04-14 01:37:39','2023-04-14 01:37:39'),(1357,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',50000.00,'2023-04 Compra Dolares y cancelacion parcial prestamo familia HP',NULL,1,'2023-04-14 01:37:39','2023-04-14 01:40:00','2023-04-14 01:40:00'),(1358,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',50000.00,'2023-04 Compra Dolares y cancelacion parcial prestamo familia HP',NULL,1,'2023-04-14 01:40:00','2023-04-14 19:33:02','2023-04-14 19:33:02');
INSERT INTO `balance_libro` VALUES (1359,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2100.00,'2023-04 Banco Santander CA USD Retiro Dólares',NULL,1,'2023-04-14 01:41:51','2023-04-14 01:41:51',NULL),(1360,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2185.49,'2023-04 Compra Dolares',NULL,1,'2023-04-14 01:42:53','2023-04-14 01:43:51','2023-04-14 01:43:51'),(1361,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2185.49,'2023-04 Compra Dolares',NULL,1,'2023-04-14 01:43:13','2023-04-14 01:43:13',NULL),(1362,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2185.49,'2023-04 Transferencia de dólares BASU a BASA',NULL,1,'2023-04-14 01:43:51','2023-04-14 01:43:51',NULL),(1363,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',43.99,'Redondeo',NULL,1,'2023-04-14 12:12:16','2023-04-14 19:44:48','2023-04-14 19:44:48'),(1364,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',22500.00,'2023-04 Personales EAHP',NULL,1,'2023-04-14 12:15:11','2023-04-14 12:15:11',NULL),(1365,7851,40719,21,21,NULL,NULL,NULL,645,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',-1698.84,NULL,NULL,1,'2023-04-14 12:20:19','2023-04-14 12:20:19',NULL),(1366,7851,40719,21,3,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2698.30,NULL,NULL,1,'2023-04-14 12:23:30','2023-04-14 12:23:30',NULL),(1367,7851,40719,21,21,NULL,NULL,NULL,647,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2698.30,NULL,NULL,1,'2023-04-14 12:24:12','2023-04-14 12:24:12',NULL),(1368,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71.37,'Redondeo',NULL,1,'2023-04-14 12:29:22','2023-05-02 19:18:33','2023-05-02 19:18:33'),(1369,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',3060.00,'Gasto Google (A determinar)',NULL,1,'2023-04-14 12:31:02','2023-04-14 12:31:02',NULL),(1370,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',30000.00,'2023-04',NULL,1,'2023-04-14 19:26:00','2023-04-14 19:26:16','2023-04-14 19:26:16'),(1371,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',30000.00,'2023-04 Movimiento interno',NULL,1,'2023-04-14 19:26:16','2023-04-14 19:26:16',NULL),(1372,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',50000.00,'2023-04 Movimiento interno',NULL,1,'2023-04-14 19:30:05','2023-04-14 19:30:44','2023-04-14 19:30:44'),(1373,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',50000.00,'2023-04 Compra Dolares y cancelacion parcial prestamo familia HP',NULL,1,'2023-04-14 19:33:02','2023-04-14 19:33:02',NULL),(1374,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',49.06,'2023-04 Compra Dolares',NULL,1,'2023-04-14 19:43:05','2023-04-14 19:43:05',NULL),(1375,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5.07,'Redondeo',NULL,1,'2023-04-14 19:44:48','2023-04-14 19:48:01','2023-04-14 19:48:01'),(1376,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5.07,'Redondeo',NULL,1,'2023-04-14 19:48:01','2023-04-14 19:48:39','2023-04-14 19:48:39'),(1377,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5.07,'Redondeo',NULL,1,'2023-04-14 19:48:39','2023-04-14 19:50:09','2023-04-14 19:50:09'),(1378,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',25.07,'Redondeo',NULL,1,'2023-04-14 19:50:09','2023-04-14 19:50:45','2023-04-14 19:50:45'),(1379,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',44.07,'Redondeo',NULL,1,'2023-04-14 19:50:45','2023-04-14 19:51:25','2023-04-14 19:51:25');
INSERT INTO `balance_libro` VALUES (1380,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',44.00,'Redondeo',NULL,1,'2023-04-14 19:51:25','2023-04-14 19:51:47','2023-04-14 19:51:47'),(1381,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',43.99,'Redondeo',NULL,1,'2023-04-14 19:51:47','2023-04-14 19:52:13','2023-04-14 19:52:13'),(1382,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',43.99,'Redondeo',NULL,1,'2023-04-14 19:52:13','2023-04-14 19:52:13',NULL),(1383,7851,40719,21,3,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1822.54,NULL,NULL,1,'2023-04-21 17:37:12','2023-04-21 17:37:12',NULL),(1384,7851,40719,21,3,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',19536.22,NULL,NULL,1,'2023-04-21 17:39:30','2023-04-21 17:39:30',NULL),(1385,7851,40719,21,3,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',7492.19,NULL,NULL,1,'2023-04-21 17:41:04','2023-04-21 17:50:55','2023-04-21 17:50:55'),(1386,7851,40719,21,3,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',20000.00,NULL,NULL,1,'2023-04-21 17:42:10','2023-04-21 17:42:10',NULL),(1387,7851,40719,21,3,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',19000.00,NULL,NULL,1,'2023-04-21 17:49:13','2023-04-21 17:49:13',NULL),(1388,7851,40719,21,3,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',24006.01,NULL,NULL,1,'2023-04-21 17:49:55','2023-04-21 17:49:55',NULL),(1389,7851,40719,21,3,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',12499.99,NULL,NULL,1,'2023-04-21 17:50:31','2023-04-21 17:50:31',NULL),(1390,7851,40719,21,3,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',7492.19,NULL,NULL,1,'2023-04-21 17:50:55','2023-04-21 17:50:55',NULL),(1391,7851,40719,21,3,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',7000.00,NULL,NULL,1,'2023-04-21 17:52:12','2023-04-21 17:52:12',NULL),(1392,7851,40719,21,3,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',4000.08,NULL,NULL,1,'2023-04-21 17:53:09','2023-04-21 17:53:09',NULL),(1393,7851,40719,21,21,NULL,NULL,NULL,658,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',4000.08,NULL,NULL,1,'2023-04-21 17:55:54','2023-04-21 17:55:54',NULL),(1394,7851,40719,21,21,NULL,NULL,NULL,659,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',7000.00,NULL,NULL,1,'2023-04-21 17:57:03','2023-04-21 17:57:03',NULL),(1395,7851,40719,21,21,NULL,NULL,NULL,660,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',12499.99,NULL,NULL,1,'2023-04-21 18:04:31','2023-04-21 18:04:31',NULL),(1396,7851,40719,21,21,NULL,NULL,NULL,661,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',24006.01,NULL,NULL,1,'2023-04-21 18:05:58','2023-04-21 18:05:58',NULL),(1397,7851,40719,21,21,NULL,NULL,NULL,662,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',19000.00,NULL,NULL,1,'2023-04-21 18:07:12','2023-04-21 18:07:12',NULL),(1398,7851,40719,21,21,NULL,NULL,NULL,663,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',20000.00,NULL,NULL,1,'2023-04-21 18:08:44','2023-04-21 18:08:44',NULL),(1399,7851,40719,21,21,NULL,NULL,NULL,664,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',7492.19,NULL,NULL,1,'2023-04-21 18:09:41','2023-04-21 18:09:41',NULL),(1400,7851,40719,21,21,NULL,NULL,NULL,665,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',19536.22,NULL,NULL,1,'2023-04-21 18:10:44','2023-04-21 18:10:44',NULL),(1401,7851,40719,21,21,NULL,NULL,NULL,666,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1822.54,NULL,NULL,1,'2023-04-21 18:11:26','2023-04-21 18:11:26',NULL),(1402,7851,40719,21,3,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2680.00,NULL,NULL,1,'2023-04-21 18:12:57','2023-04-21 18:12:57',NULL),(1403,7851,40719,21,21,NULL,NULL,NULL,668,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2680.00,NULL,NULL,1,'2023-04-21 18:14:55','2023-05-02 19:58:39','2023-05-02 19:58:39');
INSERT INTO `balance_libro` VALUES (1404,7851,40719,21,3,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2149.00,NULL,NULL,1,'2023-04-30 19:32:57','2023-04-30 19:32:57',NULL),(1405,7851,40719,21,3,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2000.00,NULL,NULL,1,'2023-04-30 19:35:02','2023-04-30 19:35:02',NULL),(1406,7851,40719,21,3,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',17101.90,NULL,NULL,1,'2023-04-30 19:38:13','2023-04-30 19:38:13',NULL),(1407,7851,40719,21,3,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',13664.91,NULL,NULL,1,'2023-04-30 19:38:47','2023-04-30 19:38:47',NULL),(1408,7851,40719,21,3,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',8004.91,NULL,NULL,1,'2023-04-30 19:39:44','2023-04-30 19:39:44',NULL),(1409,7851,40719,21,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.05,NULL,NULL,1,'2023-04-30 19:41:38','2023-04-30 20:58:30','2023-04-30 20:58:30'),(1410,7851,40719,21,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',23000.01,NULL,NULL,1,'2023-04-30 19:42:59','2023-04-30 20:58:26','2023-04-30 20:58:26'),(1411,7851,40719,21,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',15009.65,NULL,NULL,1,'2023-04-30 19:43:45','2023-04-30 20:57:19','2023-04-30 20:57:19'),(1412,7851,40719,21,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',8800.00,NULL,NULL,1,'2023-04-30 19:44:25','2023-04-30 20:58:17','2023-04-30 20:58:17'),(1413,7851,40719,21,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1399.00,NULL,NULL,1,'2023-04-30 19:45:38','2023-04-30 20:57:05','2023-04-30 20:57:05'),(1414,7851,40719,21,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2651.78,NULL,NULL,1,'2023-04-30 20:55:17','2023-04-30 20:56:55','2023-04-30 20:56:55'),(1415,7851,40719,21,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.00,NULL,NULL,1,'2023-04-30 20:56:31','2023-04-30 20:57:41','2023-04-30 20:57:41'),(1416,7851,40719,21,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',2651.78,NULL,NULL,1,'2023-04-30 20:56:55','2023-04-30 20:57:45','2023-04-30 20:57:45'),(1417,7851,40719,21,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1399.00,NULL,NULL,1,'2023-04-30 20:57:05','2023-04-30 20:58:01','2023-04-30 20:58:01'),(1418,7851,40719,21,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',15009.65,NULL,NULL,1,'2023-04-30 20:57:19','2023-04-30 20:58:22','2023-04-30 20:58:22'),(1419,7851,40719,21,3,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',15009.65,NULL,NULL,1,'2023-04-30 20:59:49','2023-04-30 20:59:49',NULL),(1420,7851,40719,21,3,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',8799.99,NULL,NULL,1,'2023-04-30 21:00:41','2023-04-30 21:00:41',NULL),(1421,7851,40719,21,3,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1399.00,NULL,NULL,1,'2023-04-30 21:06:03','2023-04-30 21:06:03',NULL),(1422,7851,40719,21,3,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',2651.78,NULL,NULL,1,'2023-04-30 21:07:10','2023-04-30 21:07:10',NULL),(1423,7851,40719,21,3,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.00,NULL,NULL,1,'2023-04-30 21:07:36','2023-04-30 21:07:36',NULL),(1424,7851,40719,21,3,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.05,NULL,NULL,1,'2023-04-30 21:11:26','2023-04-30 21:11:26',NULL),(1425,7851,40719,21,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',25000.00,'2023-04-23 CLUB MONTE COMAN',NULL,1,'2023-05-01 21:15:49','2023-05-01 21:15:49',NULL),(1426,7851,40719,21,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',25000.00,'2023-04-22 CLUB LA LLAVE',NULL,1,'2023-05-01 21:16:35','2023-05-01 21:16:35',NULL);
INSERT INTO `balance_libro` VALUES (1427,7851,40719,21,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',25000.00,'2023-04-15 CLUB LA LLAVE',NULL,1,'2023-05-01 21:17:39','2023-05-01 21:17:39',NULL),(1428,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',5000.00,'2023-04-15 CLUB LA LLAVE',NULL,1,'2023-05-01 21:32:54','2023-05-01 21:32:54',NULL),(1429,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',5000.00,'2023-04-22 CLUB LA LLAVE',NULL,1,'2023-05-01 21:33:34','2023-05-01 21:33:34',NULL),(1430,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',5000.00,'2023-04-23 CLUB MONTE COMAN',NULL,1,'2023-05-01 21:35:26','2023-05-01 21:35:26',NULL),(1431,7851,40719,21,21,NULL,NULL,NULL,690,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',8799.99,NULL,NULL,1,'2023-05-01 21:38:17','2023-05-01 21:38:17',NULL),(1432,7851,40719,21,21,NULL,NULL,NULL,691,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',13664.91,NULL,NULL,1,'2023-05-01 21:39:45','2023-05-01 21:39:45',NULL),(1433,7851,40719,21,21,NULL,NULL,NULL,692,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',17101.90,NULL,NULL,1,'2023-05-01 21:46:30','2023-05-01 21:46:30',NULL),(1434,7851,40719,21,21,NULL,NULL,NULL,693,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2149.00,NULL,NULL,1,'2023-05-01 21:47:07','2023-05-01 21:47:07',NULL),(1435,7851,40719,21,21,NULL,NULL,NULL,694,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2000.00,NULL,NULL,1,'2023-05-01 21:47:54','2023-05-01 21:47:54',NULL),(1436,7851,40719,21,21,NULL,NULL,NULL,695,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.05,NULL,NULL,1,'2023-05-01 21:49:50','2023-05-01 21:50:59','2023-05-01 21:50:59'),(1437,7851,40719,21,21,NULL,NULL,NULL,696,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.05,NULL,NULL,1,'2023-05-01 21:52:10','2023-05-01 21:52:10',NULL),(1438,7851,40719,21,21,NULL,NULL,NULL,697,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',8004.91,NULL,NULL,1,'2023-05-01 21:53:17','2023-05-01 21:53:17',NULL),(1439,7851,40719,21,3,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',23000.01,NULL,NULL,1,'2023-05-01 21:58:41','2023-05-01 21:58:41',NULL),(1440,7851,40719,21,21,NULL,NULL,NULL,699,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',23000.01,NULL,NULL,1,'2023-05-01 22:00:20','2023-05-01 22:00:20',NULL),(1441,7851,40719,21,21,NULL,NULL,NULL,700,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',15009.65,NULL,NULL,1,'2023-05-01 22:04:56','2023-05-01 22:04:56',NULL),(1442,7851,40719,21,21,NULL,NULL,NULL,701,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',2651.78,NULL,NULL,1,'2023-05-01 22:06:16','2023-05-01 22:06:16',NULL),(1443,7851,40719,21,21,NULL,NULL,NULL,702,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1399.00,NULL,NULL,1,'2023-05-01 22:07:14','2023-05-01 22:07:14',NULL),(1444,7851,40719,21,21,NULL,NULL,NULL,703,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.00,NULL,NULL,1,'2023-05-01 22:08:27','2023-05-02 19:25:54','2023-05-02 19:25:54'),(1445,7851,40719,21,3,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',820749.97,NULL,NULL,1,'2023-05-02 11:21:23','2023-05-18 20:04:59','2023-05-18 20:04:59'),(1446,7851,40719,21,3,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',498.90,NULL,NULL,1,'2023-05-02 11:21:23','2023-05-02 11:21:23',NULL),(1447,7851,40719,21,3,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',498.90,NULL,NULL,1,'2023-05-02 11:22:11','2023-05-02 11:22:11',NULL),(1448,7851,40719,20,15,NULL,774,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',149829.04,NULL,NULL,1,'2023-05-02 11:24:46','2023-05-02 11:24:46',NULL),(1449,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',101016.79,'2023-05 CIERRE DE CUENTA',NULL,1,'2023-05-02 11:54:34','2023-05-02 12:49:00','2023-05-02 12:49:00');
INSERT INTO `balance_libro` VALUES (1450,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',45258.88,'2023-05 BANCO SUPERVIELLE TARJETA MASTERCARD CIERRE DE CUENTA',NULL,1,'2023-05-02 12:48:13','2023-05-02 12:48:13',NULL),(1451,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',101016.79,'2023-05 BANCO SUPERVIELLE CA ARS CIERRE DE CUENTA',NULL,1,'2023-05-02 12:49:00','2023-05-02 20:38:02','2023-05-02 20:38:02'),(1452,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',32916.81,'2023-05 BANCO SUPERVIELLE COMISIONES CIERRA DE CUENTA',NULL,1,'2023-05-02 13:05:43','2023-05-02 13:05:43',NULL),(1453,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',0.39,'2023-05 BANCO SUPERVIELLE IMPUESTOS',NULL,1,'2023-05-02 13:06:38','2023-05-02 13:06:38',NULL),(1454,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',8194.02,'2023-05 BANCO SUPERVIELLE TARJETA VISA CIERRA CUENTA',NULL,1,'2023-05-02 13:07:29','2023-05-02 13:07:29',NULL),(1455,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',66557.07,'2023-05 BANCO SUPERVIELLE PRESTAMO CIERRE DE CUENTA',NULL,1,'2023-05-02 13:08:29','2023-05-02 13:08:29',NULL),(1456,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',10640.07,'2023-05 BANCO SUPERVIELLE CIERRE DE CUENTA',NULL,1,'2023-05-02 13:11:13','2023-05-02 13:11:58','2023-05-02 13:11:58'),(1457,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',10640.07,'2023-05 BANCO SUPERVIELLE CIERRE DE CUENTA',NULL,1,'2023-05-02 13:11:58','2023-05-02 13:11:58',NULL),(1458,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',600000.00,'2023-04 Movimiento interno',NULL,1,'2023-05-02 15:25:56','2023-05-02 15:25:56',NULL),(1459,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',150000.00,'2023-04 Cocos Capital Fondeo Dolar MEP',NULL,1,'2023-05-02 15:27:37','2023-05-02 15:27:37',NULL),(1460,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',100000.00,'2023-04 Cocos Capital Fondeo Dolar MEP',NULL,1,'2023-05-02 15:28:09','2023-05-02 15:28:09',NULL),(1461,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',50000.00,'2023-04 Movimiento interno',NULL,1,'2023-05-02 15:34:11','2023-05-02 15:34:11',NULL),(1462,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',1185992.09,'2023-04 Banco Santander FCI Rescate',NULL,1,'2023-05-02 18:28:24','2023-05-02 18:28:24',NULL),(1463,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',51000.00,'2023-05 Movimiento interno FCI Santander',NULL,1,'2023-05-02 18:33:29','2023-05-02 18:33:29',NULL),(1464,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',18710.67,'2023-04 Movimiento interno',NULL,1,'2023-05-02 18:47:41','2023-05-02 18:47:41',NULL),(1465,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',27790.78,'2023-04 Movimiento interno',NULL,1,'2023-05-02 18:48:33','2023-05-02 18:48:33',NULL),(1466,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',400000.00,'2023-04 Movimiento interno',NULL,1,'2023-05-02 18:51:13','2023-05-02 18:51:13',NULL),(1467,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',50000.00,'2023-04 Movimiento interno',NULL,1,'2023-05-02 18:52:21','2023-05-02 18:52:21',NULL),(1468,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',18000.00,'2023-05 Walter Rozas Elecciones 2023-04-30',NULL,1,'2023-05-02 18:54:12','2023-05-02 18:54:12',NULL),(1469,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',40000.00,'2023-04 Personales JCH',NULL,1,'2023-05-02 18:56:13','2023-05-02 18:56:13',NULL);
INSERT INTO `balance_libro` VALUES (1470,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',10000.00,'2023-04 Personales MPHP',NULL,1,'2023-05-02 18:57:35','2023-05-02 18:57:35',NULL),(1471,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',20000.00,'2023-04 Personales MPHP',NULL,1,'2023-05-02 18:58:27','2023-05-02 18:58:27',NULL),(1472,7851,40719,21,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',50176.26,'2023-01 IVA',NULL,1,'2023-05-02 19:03:23','2023-05-02 19:03:23',NULL),(1473,7851,40719,21,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',50400.00,'2023-04 Egreso Sueldos 1595',NULL,1,'2023-05-02 19:04:20','2023-05-02 19:04:20',NULL),(1474,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',89600.00,'2023-04 Pago Sueldos 1595',NULL,1,'2023-05-02 19:05:34','2023-05-02 19:06:08','2023-05-02 19:06:08'),(1475,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',50400.00,'2023-04 Pago Sueldos 1595',NULL,1,'2023-05-02 19:06:08','2023-05-02 19:06:08',NULL),(1476,7851,40719,21,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',89600.00,'2023-04 Egreso Servicios WR 1595',NULL,1,'2023-05-02 19:06:57','2023-05-02 19:06:57',NULL),(1477,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',89600.00,'2023-04 Pago Servicios WR 1595',NULL,1,'2023-05-02 19:07:29','2023-05-02 19:07:29',NULL),(1478,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',173.49,'2023-04 Personales JCH (intereses Inmobiliario)',NULL,1,'2023-05-02 19:12:20','2023-05-02 19:12:20',NULL),(1479,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',930.00,'2023-04 Tasa Contributiva ATM Exención Retenciones IIBB',NULL,1,'2023-05-02 19:13:51','2023-05-02 19:13:51',NULL),(1480,7851,40719,21,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',1280.00,'2023-04 Personales EAHP (Informe DNRPA)',NULL,1,'2023-05-02 19:14:33','2023-05-02 19:14:33',NULL),(1481,7851,40719,21,21,NULL,NULL,NULL,707,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.00,NULL,NULL,1,'2023-05-02 19:26:33','2023-05-02 19:26:33',NULL),(1482,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',71.39,'2023-04 Redondeo',NULL,1,'2023-05-02 19:33:21','2023-05-11 02:51:52','2023-05-11 02:51:52'),(1483,7851,40719,21,21,NULL,NULL,NULL,708,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2680.00,NULL,NULL,1,'2023-05-02 19:59:15','2023-05-02 19:59:15',NULL),(1484,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',101016.79,'2023-05 BANCO SUPERVIELLE CA ARS CIERRE DE CUENTA',NULL,1,'2023-05-02 20:38:02','2023-05-02 20:38:02',NULL),(1485,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',228590.00,'2023-05 Cocos Capital Compra USD MEP',NULL,1,'2023-05-02 20:39:45','2023-05-02 20:39:45',NULL),(1486,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',515.00,'2023-05 Cocos Capital Compra USD MEP',NULL,1,'2023-05-02 20:41:12','2023-05-02 20:41:12',NULL),(1487,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',515.00,'2023-05 Cocos Capital Retiro USD',NULL,1,'2023-05-02 20:41:50','2023-05-10 21:10:06','2023-05-10 21:10:06'),(1488,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',1050.00,'2023-04 Préstamo a Familia HP Pasajes USD',NULL,1,'2023-05-10 18:16:03','2023-05-11 00:47:05','2023-05-11 00:47:05'),(1489,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',850.00,'2023-05 Préstamo a Familia HP Pasajes USD',NULL,1,'2023-05-10 18:20:26','2023-05-10 18:20:26',NULL);
INSERT INTO `balance_libro` VALUES (1490,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',515.00,'2023-05 Cocos Capital Retiro USD',NULL,1,'2023-05-10 21:10:06','2023-05-11 00:45:21','2023-05-11 00:45:21'),(1491,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',205751.38,'2023-05 Gastos Familia HP',NULL,1,'2023-05-10 23:44:20','2023-05-10 23:44:20',NULL),(1492,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',50000.00,'2023-05 Movimiento interno',NULL,1,'2023-05-11 00:06:25','2023-05-11 00:06:25',NULL),(1493,7851,40719,22,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',2353158.36,NULL,NULL,1,'2023-05-11 00:23:52','2023-05-11 00:23:52',NULL),(1494,7851,40719,22,20,NULL,NULL,NULL,710,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',2353158.36,NULL,NULL,1,'2023-05-11 00:40:05','2023-05-11 00:40:05',NULL),(1495,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',515.00,'2023-05 Cocos Capital Retiro USD',NULL,1,'2023-05-11 00:45:21','2023-05-11 00:45:21',NULL),(1496,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',416064.00,'2023-04 Préstamo a Familia HP Pasajes USD',NULL,1,'2023-05-11 00:47:05','2023-05-11 00:47:05',NULL),(1497,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',16741.48,'2023-05 Cocos Capital Fondeo ARS',NULL,1,'2023-05-11 01:10:33','2023-05-11 01:11:24','2023-05-11 01:11:24'),(1498,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',16741.48,'2023-05 Cocos Capital Fondeo ARS',NULL,1,'2023-05-11 01:11:24','2023-05-11 01:11:24',NULL),(1499,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',37576.55,'2023-05 Cocos Capital ACCIONES',NULL,1,'2023-05-11 01:14:37','2023-05-11 01:14:37',NULL),(1500,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',400000.00,'2023-05 Cocos Capital Fondeo ARS',NULL,1,'2023-05-11 01:21:10','2023-05-11 01:21:10',NULL),(1501,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',209229.84,'2023-05 Banco Santander Tarjeta Visa',NULL,1,'2023-05-11 01:28:42','2023-05-11 02:50:41','2023-05-11 02:50:41'),(1502,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',296040.56,'2023-05 Banco Santander Tarjeta AMEX',NULL,1,'2023-05-11 01:29:23','2023-05-11 02:42:59','2023-05-11 02:42:59'),(1503,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',210000.00,'2023-05 Movimiento interno',NULL,1,'2023-05-11 01:34:47','2023-05-11 01:34:47',NULL),(1504,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',35000.00,'2023-05 Daniel Varaz 1595',NULL,1,'2023-05-11 02:09:24','2023-05-11 02:09:24',NULL),(1505,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',33583.15,'2023-05 Egreso SUSS 1595',NULL,1,'2023-05-11 02:10:28','2023-05-11 02:10:28',NULL),(1506,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',33583.15,'2023-05 Pago SUSS 1595',NULL,1,'2023-05-11 02:11:03','2023-05-11 02:11:03',NULL),(1507,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',600000.00,'2023-05 Movimiento interno',NULL,1,'2023-05-11 02:28:02','2023-05-11 02:28:02',NULL),(1508,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',500000.00,'2023-05 Gastos Familia HP',NULL,1,'2023-05-11 02:31:40','2023-05-11 02:31:40',NULL),(1509,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',500000.00,'2023-05 Gastos Familia HP',NULL,1,'2023-05-11 02:32:21','2023-05-11 02:32:21',NULL),(1510,7851,40719,22,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4.70,'2023-05 Banco Santander CA Intereses',NULL,1,'2023-05-11 02:33:21','2023-05-11 02:33:21',NULL);
INSERT INTO `balance_libro` VALUES (1511,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',15000.00,'2023-05 Banco Santander CC ARS Descubierto',NULL,1,'2023-05-11 02:36:39','2023-05-11 02:36:53','2023-05-11 02:36:53'),(1512,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',7500.00,'2023-05 Banco Santander CC ARS Descubierto',NULL,1,'2023-05-11 02:36:53','2023-05-11 02:37:49','2023-05-11 02:37:49'),(1513,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',7500.00,'2023-05 Banco Santander CC ARS Descubierto',NULL,1,'2023-05-11 02:37:34','2023-05-11 02:37:34',NULL),(1514,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',7500.00,'2023-05 Banco Santander CC ARS Descubierto Compensación',NULL,1,'2023-05-11 02:37:49','2023-05-11 02:37:49',NULL),(1515,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',296040.56,'2023-05 Banco Santander Tarjeta AMEX',NULL,1,'2023-05-11 02:42:59','2023-05-11 02:42:59',NULL),(1516,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',219204.84,'2023-05 Banco Santander Tarjeta Visa',NULL,1,'2023-05-11 02:50:41','2023-05-11 02:50:41',NULL),(1517,7851,40719,21,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.02,'2023-04 Redondeo',NULL,1,'2023-05-11 02:51:52','2023-05-11 02:51:52',NULL),(1518,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',210000.00,'2023-05 Elecciones 30/04 Extracción efectivo',NULL,1,'2023-05-11 12:59:20','2023-05-11 12:59:20',NULL),(1519,7851,40719,21,3,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3000.11,NULL,NULL,1,'2023-05-18 19:26:55','2023-05-18 19:26:55',NULL),(1520,7851,40719,21,3,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',16065.47,NULL,NULL,1,'2023-05-18 19:41:39','2023-05-18 19:41:39',NULL),(1521,7851,40719,21,3,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',820749.97,NULL,NULL,1,'2023-05-18 20:04:59','2023-05-18 20:04:59',NULL),(1522,7851,40719,22,3,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',5599.33,NULL,NULL,1,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(1523,7851,40719,22,3,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',21662.33,NULL,NULL,1,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(1524,7851,40719,22,3,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',2698.30,NULL,NULL,1,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(1525,7851,40719,22,3,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1461.99,NULL,NULL,1,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(1526,7851,40719,22,3,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',7209.00,NULL,NULL,1,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(1527,7851,40719,22,3,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',820749.97,NULL,NULL,1,'2023-05-18 20:42:31','2023-05-18 20:43:22','2023-05-18 20:43:22'),(1528,7851,40719,22,3,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',1970.99,NULL,NULL,1,'2023-05-18 20:42:31','2023-05-19 01:06:34','2023-05-19 01:06:34'),(1529,7851,40719,22,3,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',20220.29,NULL,NULL,1,'2023-05-18 20:42:31','2023-05-19 01:06:16','2023-05-19 01:06:16'),(1530,7851,40719,22,3,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',330512.00,NULL,NULL,1,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(1531,7851,40719,22,3,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',8401.57,NULL,NULL,1,'2023-05-18 20:49:17','2023-05-18 20:49:17',NULL),(1532,7851,40719,22,3,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',10401.23,NULL,NULL,1,'2023-05-18 20:52:26','2023-05-18 20:53:27','2023-05-18 20:53:27');
INSERT INTO `balance_libro` VALUES (1533,7851,40719,22,3,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',10401.23,NULL,NULL,1,'2023-05-18 20:53:27','2023-05-18 20:53:27',NULL),(1534,7851,40719,22,3,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',5300.72,NULL,NULL,1,'2023-05-18 20:55:22','2023-05-18 20:55:22',NULL),(1535,7851,40719,22,3,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',10302.19,NULL,NULL,1,'2023-05-18 20:58:03','2023-05-18 20:58:03',NULL),(1536,7851,40719,22,3,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',20500.00,NULL,NULL,1,'2023-05-18 21:20:57','2023-06-05 20:30:08','2023-06-05 20:30:08'),(1537,7851,40719,22,3,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',18902.00,NULL,NULL,1,'2023-05-18 22:11:59','2023-05-18 22:11:59',NULL),(1538,7851,40719,22,3,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',5400.00,NULL,NULL,1,'2023-05-18 22:15:23','2023-05-18 22:15:23',NULL),(1539,7851,40719,22,3,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',22400.00,NULL,NULL,1,'2023-05-18 22:16:45','2023-05-18 22:16:45',NULL),(1540,7851,40719,22,21,NULL,NULL,NULL,732,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',22400.00,NULL,NULL,1,'2023-05-19 00:33:05','2023-05-19 00:33:05',NULL),(1541,7851,40719,22,21,NULL,NULL,NULL,733,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',5400.00,NULL,NULL,1,'2023-05-19 00:33:56','2023-05-19 00:33:56',NULL),(1542,7851,40719,22,21,NULL,NULL,NULL,734,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',18902.00,NULL,NULL,1,'2023-05-19 00:34:40','2023-05-19 00:34:40',NULL),(1543,7851,40719,22,21,NULL,NULL,NULL,735,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',20500.00,NULL,NULL,1,'2023-05-19 00:35:25','2023-06-05 20:25:20','2023-06-05 20:25:20'),(1544,7851,40719,22,21,NULL,NULL,NULL,736,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',8401.57,NULL,NULL,1,'2023-05-19 00:36:06','2023-05-19 00:36:06',NULL),(1545,7851,40719,22,21,NULL,NULL,NULL,737,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',10302.19,NULL,NULL,1,'2023-05-19 00:36:46','2023-05-19 00:36:46',NULL),(1546,7851,40719,22,21,NULL,NULL,NULL,738,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',5300.72,NULL,NULL,1,'2023-05-19 00:38:32','2023-05-19 00:38:32',NULL),(1547,7851,40719,22,21,NULL,NULL,NULL,739,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',10401.23,NULL,NULL,1,'2023-05-19 00:39:08','2023-05-19 00:39:08',NULL),(1548,7851,40719,22,21,NULL,NULL,NULL,740,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',21662.33,NULL,NULL,1,'2023-05-19 00:40:25','2023-05-19 00:40:25',NULL),(1549,7851,40719,22,21,NULL,NULL,NULL,741,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',330512.00,NULL,NULL,1,'2023-05-19 00:43:38','2023-05-19 00:43:38',NULL),(1550,7851,40719,22,21,NULL,NULL,NULL,742,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1461.99,NULL,NULL,1,'2023-05-19 00:44:18','2023-05-19 00:44:18',NULL),(1551,7851,40719,22,21,NULL,NULL,NULL,743,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',5599.33,NULL,NULL,1,'2023-05-19 00:45:01','2023-05-19 00:45:01',NULL),(1552,7851,40719,22,21,NULL,NULL,NULL,744,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',7209.00,NULL,NULL,1,'2023-05-19 00:45:47','2023-05-19 00:45:47',NULL),(1553,7851,40719,22,21,NULL,NULL,NULL,745,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',2698.30,NULL,NULL,1,'2023-05-19 00:46:49','2023-05-19 00:46:49',NULL),(1554,7851,40719,22,21,NULL,NULL,NULL,746,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',-6795.36,NULL,NULL,1,'2023-05-19 00:55:40','2023-05-19 00:55:40',NULL),(1555,7851,40719,21,21,NULL,NULL,NULL,747,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',997.80,NULL,NULL,1,'2023-05-19 00:57:11','2023-05-19 00:57:11',NULL),(1556,7851,40719,21,21,NULL,NULL,NULL,748,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',820749.97,NULL,NULL,1,'2023-05-19 01:05:32','2023-05-19 01:05:32',NULL);
INSERT INTO `balance_libro` VALUES (1557,7851,40719,22,3,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',20264.27,NULL,NULL,1,'2023-05-19 01:06:16','2023-06-05 20:28:29','2023-06-05 20:28:29'),(1558,7851,40719,22,3,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',1970.99,NULL,NULL,1,'2023-05-19 01:06:34','2023-05-19 01:06:34',NULL),(1559,7851,40719,22,21,NULL,NULL,NULL,751,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',16065.47,NULL,NULL,1,'2023-05-19 01:08:30','2023-05-19 01:08:30',NULL),(1560,7851,40719,21,21,NULL,NULL,NULL,752,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3000.11,NULL,NULL,1,'2023-05-19 01:14:59','2023-05-19 01:14:59',NULL),(1561,7851,40719,22,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',25000.00,'2023-05-13 CLUB MONTE COMAN',NULL,1,'2023-05-24 00:00:21','2023-05-24 00:00:21',NULL),(1562,7851,40719,22,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',15000.00,'2023-05-14 CLUB MONTE COMAN',NULL,1,'2023-05-24 00:01:17','2023-05-24 00:01:17',NULL),(1563,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',17806.60,'2023-05 Cocos Capital Fondeo ARS',NULL,1,'2023-05-24 00:33:10','2023-05-24 00:33:10',NULL),(1564,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',10000.00,'2023-05 Gastos EAHP',NULL,1,'2023-05-24 00:35:44','2023-05-24 00:35:44',NULL),(1565,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',10000.00,'2023-05 Gastos EAHP',NULL,1,'2023-05-24 00:36:21','2023-05-24 00:36:21',NULL),(1566,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',9373.27,'2023-05 Pago seguros',NULL,1,'2023-05-24 00:39:47','2023-05-24 00:39:47',NULL),(1567,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',400538.16,'2023-05 Recupero Fondeo ARS Cocos Capital',NULL,1,'2023-05-24 00:41:42','2023-05-24 00:41:42',NULL),(1568,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',400000.00,'2023-04 Compra Dolares en Banco Supervielle',NULL,1,'2023-05-24 00:43:36','2023-05-24 00:45:29','2023-05-24 00:45:29'),(1569,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',17806.60,'2023-05 Compra Dolares en Banco Supervielle DEVOLUCIÓN RESTO',NULL,1,'2023-05-24 00:44:48','2023-05-24 00:44:48',NULL),(1570,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',400000.00,'2023-05 Compra Dolares en Banco Supervielle',NULL,1,'2023-05-24 00:45:29','2023-05-24 00:45:29',NULL),(1571,7851,40719,22,3,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',46404.00,NULL,NULL,1,'2023-05-24 00:50:46','2023-05-24 00:50:46',NULL),(1572,7851,40719,22,21,NULL,NULL,NULL,754,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',20220.29,NULL,NULL,1,'2023-05-24 00:53:35','2023-05-24 01:21:36','2023-05-24 01:21:36'),(1573,7851,40719,22,21,NULL,NULL,NULL,755,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',1970.99,NULL,NULL,1,'2023-05-24 00:54:17','2023-05-24 01:21:21','2023-05-24 01:21:21'),(1574,7851,40719,22,21,NULL,NULL,NULL,756,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',46404.00,NULL,NULL,1,'2023-05-24 00:55:10','2023-05-24 00:55:10',NULL),(1575,7851,40719,22,3,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',6609.28,NULL,NULL,1,'2023-05-24 01:12:54','2023-05-24 01:12:54',NULL),(1576,7851,40719,22,3,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',32454.00,NULL,NULL,1,'2023-05-24 01:14:50','2023-05-24 01:14:50',NULL),(1577,7851,40719,22,21,NULL,NULL,NULL,759,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',32454.00,NULL,NULL,1,'2023-05-24 01:16:34','2023-05-24 01:16:34',NULL),(1578,7851,40719,22,21,NULL,NULL,NULL,760,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',6609.28,NULL,NULL,1,'2023-05-24 01:17:11','2023-05-24 01:17:11',NULL);
INSERT INTO `balance_libro` VALUES (1579,7851,40719,22,21,NULL,NULL,NULL,761,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',20220.29,NULL,NULL,1,'2023-05-24 01:25:26','2023-06-05 20:27:01','2023-06-05 20:27:01'),(1580,7851,40719,22,21,NULL,NULL,NULL,762,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',1970.99,NULL,NULL,1,'2023-05-24 01:26:06','2023-05-24 01:26:06',NULL),(1581,7851,40719,22,3,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',820749.97,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 23:37:30','2023-06-01 23:37:30'),(1582,7851,40719,22,3,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',498.90,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1583,7851,40719,22,3,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',50217.98,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1584,7851,40719,22,3,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',6609.28,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1585,7851,40719,22,3,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3400.00,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1586,7851,40719,22,3,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',173573.08,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1587,7851,40719,22,3,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',10400.80,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1588,7851,40719,22,3,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',41710.23,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1589,7851,40719,22,3,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',107325.01,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1590,7851,40719,22,3,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',107325.01,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1591,7851,40719,22,3,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',39514.95,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1592,7851,40719,22,3,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',107325.01,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1593,7851,40719,22,3,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',39514.95,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1594,7851,40719,22,3,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',4400.00,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1595,7851,40719,22,3,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6000.00,NULL,NULL,1,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(1596,7851,40719,22,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',386750.00,NULL,NULL,1,'2023-06-01 17:27:35','2023-06-01 17:27:35',NULL),(1597,7851,40719,22,3,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',4640.00,NULL,NULL,1,'2023-06-01 17:50:42','2023-06-01 17:50:42',NULL),(1598,7851,40719,22,3,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',19999.99,NULL,NULL,1,'2023-06-01 17:52:14','2023-06-01 17:52:14',NULL),(1599,7851,40719,22,3,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',16300.00,NULL,NULL,1,'2023-06-01 17:53:55','2023-06-01 17:53:55',NULL),(1600,7851,40719,22,3,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',3000.04,NULL,NULL,1,'2023-06-01 17:59:02','2023-06-01 17:59:02',NULL),(1601,7851,40719,22,3,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',550.00,NULL,NULL,1,'2023-06-01 18:00:04','2023-06-01 18:00:04',NULL),(1602,7851,40719,22,3,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2999.94,NULL,NULL,1,'2023-06-01 18:01:51','2023-06-01 18:01:51',NULL),(1603,7851,40719,22,3,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',3999.99,NULL,NULL,1,'2023-06-01 18:05:41','2023-06-01 18:05:41',NULL);
INSERT INTO `balance_libro` VALUES (1604,7851,40719,22,3,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',1999.96,NULL,NULL,1,'2023-06-01 18:08:29','2023-06-01 18:08:29',NULL),(1605,7851,40719,22,3,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',30000.77,NULL,NULL,1,'2023-06-01 18:12:10','2023-06-01 18:14:58','2023-06-01 18:14:58'),(1606,7851,40719,22,3,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',30222.38,NULL,NULL,1,'2023-06-01 18:13:03','2023-06-01 18:14:49','2023-06-01 18:14:49'),(1607,7851,40719,22,3,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7958.25,NULL,NULL,1,'2023-06-01 18:13:57','2023-06-01 18:13:57',NULL),(1608,7851,40719,22,3,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',22340.85,NULL,NULL,1,'2023-06-01 18:14:41','2023-06-01 18:14:41',NULL),(1609,7851,40719,22,3,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30222.38,NULL,NULL,1,'2023-06-01 18:14:49','2023-06-01 18:14:49',NULL),(1610,7851,40719,22,3,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30000.77,NULL,NULL,1,'2023-06-01 18:14:58','2023-06-01 18:14:58',NULL),(1611,7851,40719,21,15,NULL,886,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',236025.69,NULL,NULL,1,'2023-06-01 18:15:39','2023-06-01 18:15:39',NULL),(1612,7851,40719,22,21,NULL,NULL,NULL,793,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',90522.25,NULL,NULL,1,'2023-06-01 23:05:16','2023-06-01 23:05:16',NULL),(1613,7851,40719,22,21,NULL,NULL,NULL,794,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',5999.95,NULL,NULL,1,'2023-06-01 23:07:04','2023-06-01 23:07:04',NULL),(1614,7851,40719,22,21,NULL,NULL,NULL,795,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7000.10,NULL,NULL,1,'2023-06-01 23:08:13','2023-06-01 23:08:13',NULL),(1615,7851,40719,22,21,NULL,NULL,NULL,796,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',6549.98,NULL,NULL,1,'2023-06-01 23:09:05','2023-06-01 23:09:05',NULL),(1616,7851,40719,22,21,NULL,NULL,NULL,797,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',16300.00,NULL,NULL,1,'2023-06-01 23:11:43','2023-06-01 23:11:43',NULL),(1617,7851,40719,22,21,NULL,NULL,NULL,798,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',19999.99,NULL,NULL,1,'2023-06-01 23:12:44','2023-06-01 23:12:44',NULL),(1618,7851,40719,22,21,NULL,NULL,NULL,799,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',4640.00,NULL,NULL,1,'2023-06-01 23:13:52','2023-06-01 23:13:52',NULL),(1619,7851,40719,22,21,NULL,NULL,NULL,800,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',10400.80,NULL,NULL,1,'2023-06-01 23:14:47','2023-06-01 23:14:47',NULL),(1620,7851,40719,22,21,NULL,NULL,NULL,801,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',173573.08,NULL,NULL,1,'2023-06-01 23:17:05','2023-06-01 23:17:05',NULL),(1621,7851,40719,22,21,NULL,NULL,NULL,802,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6000.00,NULL,NULL,1,'2023-06-01 23:18:13','2023-06-01 23:18:13',NULL),(1622,7851,40719,22,21,NULL,NULL,NULL,803,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3400.00,NULL,NULL,1,'2023-06-01 23:18:56','2023-06-05 23:54:28','2023-06-05 23:54:28'),(1623,7851,40719,22,21,NULL,NULL,NULL,804,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',37259.00,NULL,NULL,1,'2023-06-01 23:21:46','2023-06-01 23:21:46',NULL),(1624,7851,40719,22,21,NULL,NULL,NULL,805,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',6609.28,NULL,NULL,1,'2023-06-01 23:23:23','2023-06-01 23:23:23',NULL),(1625,7851,40719,22,21,NULL,NULL,NULL,806,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',4400.00,NULL,NULL,1,'2023-06-01 23:24:17','2023-06-01 23:24:17',NULL),(1626,7851,40719,22,21,NULL,NULL,NULL,807,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',50217.98,NULL,NULL,1,'2023-06-01 23:25:32','2023-06-01 23:25:32',NULL),(1627,7851,40719,22,21,NULL,NULL,NULL,808,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',498.90,NULL,NULL,1,'2023-06-01 23:26:39','2023-06-06 00:28:38','2023-06-06 00:28:38');
INSERT INTO `balance_libro` VALUES (1628,7851,40719,22,21,NULL,NULL,NULL,809,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3000.01,NULL,NULL,1,'2023-06-01 23:38:29','2023-06-01 23:38:29',NULL),(1629,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',30000.00,'2023-05-27 CLUB MONTE COMAN',NULL,1,'2023-06-02 00:06:58','2023-06-02 00:08:10','2023-06-02 00:08:10'),(1630,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',20000.00,'2023-05-27 CLUB COLONIA ELENA',NULL,1,'2023-06-02 00:07:50','2023-06-02 00:07:50',NULL),(1631,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',30000.00,'2023-05-25 CLUB MONTE COMAN',NULL,1,'2023-06-02 00:08:10','2023-06-02 00:08:10',NULL),(1632,7851,40719,22,3,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',20220.29,NULL,NULL,1,'2023-06-05 20:28:29','2023-06-05 20:28:29',NULL),(1633,7851,40719,22,21,NULL,NULL,NULL,811,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',20220.29,NULL,NULL,1,'2023-06-05 20:29:31','2023-06-05 20:29:31',NULL),(1634,7851,40719,22,3,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',20900.00,NULL,NULL,1,'2023-06-05 20:30:08','2023-06-05 20:33:54','2023-06-05 20:33:54'),(1635,7851,40719,22,3,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',20900.00,NULL,NULL,1,'2023-06-05 20:33:54','2023-06-05 23:06:41','2023-06-05 23:06:41'),(1636,7851,40719,22,3,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',20900.00,NULL,NULL,1,'2023-06-05 23:08:18','2023-06-05 23:08:18',NULL),(1637,7851,40719,22,21,NULL,NULL,NULL,815,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',20900.00,NULL,NULL,1,'2023-06-05 23:08:54','2023-06-06 01:02:19','2023-06-06 01:02:19'),(1638,7851,40719,23,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',25000.00,'2023-06-04 CLUB COLONIA ELENA',NULL,1,'2023-06-05 23:15:17','2023-06-05 23:15:17',NULL),(1639,7851,40719,23,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',25000.00,'2023-06-03 CLUB MONTE COMAN',NULL,1,'2023-06-05 23:16:21','2023-06-05 23:16:21',NULL),(1640,7851,40719,23,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',18000.00,'2023-05 Servicios WR Viajes',NULL,1,'2023-06-05 23:22:14','2023-06-05 23:22:14',NULL),(1641,7851,40719,23,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',10000.00,'2023-06 Servicios WR Viajes',NULL,1,'2023-06-05 23:23:29','2023-06-05 23:23:29',NULL),(1642,7851,40719,22,20,NULL,NULL,NULL,816,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',386750.00,NULL,NULL,1,'2023-06-05 23:41:26','2023-06-05 23:41:26',NULL),(1643,7851,40719,22,21,NULL,NULL,NULL,817,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3400.00,NULL,NULL,1,'2023-06-05 23:55:39','2023-06-06 00:11:09','2023-06-06 00:11:09'),(1644,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',20000.00,'2023-05 Movimiento interno',NULL,1,'2023-06-05 23:57:22','2023-06-05 23:57:22',NULL),(1645,7851,40719,22,21,NULL,NULL,NULL,818,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',7593.00,NULL,NULL,1,'2023-06-05 23:58:37','2023-06-05 23:58:37',NULL),(1646,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',290000.00,'2023-05 Movimiento interno',NULL,1,'2023-06-06 00:00:19','2023-06-06 00:00:19',NULL),(1647,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',50400.00,'2023-05 Egreso Servicios WR 1595',NULL,1,'2023-06-06 00:01:57','2023-06-06 00:01:57',NULL),(1648,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',50400.00,'2023-05 Pago Sueldos 1595',NULL,1,'2023-06-06 00:02:37','2023-06-06 00:02:37',NULL),(1649,7851,40719,22,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',89600.00,'2023-05 Egreso Servicios WR 1595',NULL,1,'2023-06-06 00:03:17','2023-06-06 00:03:17',NULL);
INSERT INTO `balance_libro` VALUES (1650,7851,40719,22,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',89600.00,'2023-05 Pago Servicios WR 1595',NULL,1,'2023-06-06 00:03:42','2023-06-06 00:03:42',NULL),(1651,7851,40719,23,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',75.70,'2023-06 Egreso SUSS 1595',NULL,1,'2023-06-06 00:05:16','2023-06-06 00:05:16',NULL),(1652,7851,40719,23,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',75.70,'2023-06 Pago SUSS 1595',NULL,1,'2023-06-06 00:05:56','2023-06-06 00:05:56',NULL),(1653,7851,40719,22,21,NULL,NULL,NULL,819,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3400.00,NULL,NULL,1,'2023-06-06 00:11:44','2023-06-06 00:11:44',NULL),(1654,7851,40719,22,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',196000.00,'2023-05 Cocos Capital Fondeo ARS',NULL,1,'2023-06-06 00:18:28','2023-06-06 00:18:28',NULL),(1655,7851,40719,22,21,NULL,NULL,NULL,820,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',498.90,NULL,NULL,1,'2023-06-06 00:29:36','2023-06-06 00:29:36',NULL),(1656,7851,40719,22,21,NULL,NULL,NULL,821,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',997.80,NULL,NULL,1,'2023-06-06 00:33:49','2023-06-06 00:33:49',NULL),(1657,7851,40719,22,21,NULL,NULL,NULL,822,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',20900.00,NULL,NULL,1,'2023-06-06 01:03:39','2023-06-06 01:03:39',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4276 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7851,1,40719,11,3,217,1,2272.36,NULL,'2022-09-29 15:36:49','2022-09-29 15:36:49',NULL),(2,7851,1,40719,11,3,68,1,477.20,NULL,'2022-09-29 15:36:49','2022-09-29 15:36:49',NULL),(3,7851,1,40719,11,3,217,1,220.45,NULL,'2022-09-29 15:36:49','2022-09-29 15:36:49',NULL),(4,7851,1,40719,11,3,57,2,2970.01,NULL,'2022-09-29 15:36:49','2022-09-29 15:36:49',NULL),(5,7851,2,40719,11,15,68,2,477.20,NULL,'2022-09-29 15:38:24','2022-09-29 15:38:37','2022-09-29 15:38:37'),(6,7851,2,40719,11,15,353,1,477.20,NULL,'2022-09-29 15:38:24','2022-09-29 15:38:37','2022-09-29 15:38:37'),(7,7851,3,40719,11,3,217,1,11258.00,NULL,'2022-09-29 15:41:04','2022-09-29 16:02:05','2022-09-29 16:02:05'),(8,7851,3,40719,11,3,68,1,2364.18,NULL,'2022-09-29 15:41:04','2022-09-29 16:02:05','2022-09-29 16:02:05'),(9,7851,3,40719,11,3,57,2,13622.18,NULL,'2022-09-29 15:41:04','2022-09-29 16:02:05','2022-09-29 16:02:05'),(10,7851,4,40719,11,3,217,1,3932.77,NULL,'2022-09-29 15:43:29','2022-09-29 15:43:29',NULL),(11,7851,4,40719,11,3,68,1,825.88,NULL,'2022-09-29 15:43:29','2022-09-29 15:43:29',NULL),(12,7851,4,40719,11,3,217,1,340.65,NULL,'2022-09-29 15:43:29','2022-09-29 15:43:29',NULL),(13,7851,4,40719,11,3,57,2,5099.30,NULL,'2022-09-29 15:43:29','2022-09-29 15:43:29',NULL),(14,7851,5,40719,11,3,217,1,4260.12,NULL,'2022-09-29 15:45:44','2022-09-29 15:45:44',NULL),(15,7851,5,40719,11,3,68,1,894.63,NULL,'2022-09-29 15:45:44','2022-09-29 15:45:44',NULL),(16,7851,5,40719,11,3,217,1,345.56,NULL,'2022-09-29 15:45:44','2022-09-29 15:45:44',NULL),(17,7851,5,40719,11,3,57,2,5500.31,NULL,'2022-09-29 15:45:44','2022-09-29 15:45:44',NULL),(18,7851,6,40719,11,3,217,1,2933.88,NULL,'2022-09-29 15:47:06','2022-09-29 15:47:06',NULL),(19,7851,6,40719,11,3,68,1,616.11,NULL,'2022-09-29 15:47:06','2022-09-29 15:47:06',NULL),(20,7851,6,40719,11,3,57,2,3549.99,NULL,'2022-09-29 15:47:06','2022-09-29 15:47:06',NULL),(21,7851,7,40719,11,3,217,1,12481.65,NULL,'2022-09-29 15:51:13','2022-09-29 15:51:13',NULL),(22,7851,7,40719,11,3,68,1,3370.05,NULL,'2022-09-29 15:51:13','2022-09-29 15:51:13',NULL),(23,7851,7,40719,11,3,217,1,400.00,NULL,'2022-09-29 15:51:13','2022-09-29 15:51:13',NULL),(24,7851,7,40719,11,3,68,1,84.00,NULL,'2022-09-29 15:51:13','2022-09-29 15:51:13',NULL),(25,7851,7,40719,11,3,217,1,656.92,NULL,'2022-09-29 15:51:13','2022-09-29 15:51:13',NULL),(26,7851,7,40719,11,3,237,1,386.45,NULL,'2022-09-29 15:51:13','2022-09-29 15:51:13',NULL),(27,7851,7,40719,11,3,57,2,17379.07,NULL,'2022-09-29 15:51:13','2022-09-29 15:51:13',NULL),(28,7851,8,40719,11,3,217,1,39212.05,NULL,'2022-09-29 15:53:05','2022-09-29 15:53:05',NULL),(29,7851,8,40719,11,3,68,1,8234.53,NULL,'2022-09-29 15:53:05','2022-09-29 15:53:05',NULL),(30,7851,8,40719,11,3,57,2,47446.58,NULL,'2022-09-29 15:53:05','2022-09-29 15:53:05',NULL),(31,7851,9,40719,11,3,217,1,1528.93,NULL,'2022-09-29 15:53:54','2022-09-29 15:53:54',NULL),(32,7851,9,40719,11,3,68,1,321.08,NULL,'2022-09-29 15:53:54','2022-09-29 15:53:54',NULL),(33,7851,9,40719,11,3,57,2,1850.01,NULL,'2022-09-29 15:53:54','2022-09-29 15:53:54',NULL),(34,7851,10,40719,11,3,217,1,5323.36,NULL,'2022-09-29 15:55:14','2022-09-29 15:55:14',NULL),(35,7851,10,40719,11,3,68,1,1117.91,NULL,'2022-09-29 15:55:14','2022-09-29 15:55:14',NULL),(36,7851,10,40719,11,3,217,1,1009.04,NULL,'2022-09-29 15:55:14','2022-09-29 15:55:14',NULL),(37,7851,10,40719,11,3,57,2,7450.31,NULL,'2022-09-29 15:55:14','2022-09-29 15:55:14',NULL),(38,7851,11,40719,11,3,217,1,15401.41,NULL,'2022-09-29 15:56:56','2022-09-29 15:57:34','2022-09-29 15:57:34'),(39,7851,11,40719,11,3,68,1,3234.30,NULL,'2022-09-29 15:56:56','2022-09-29 15:57:34','2022-09-29 15:57:34'),(40,7851,11,40719,11,3,217,1,1364.29,NULL,'2022-09-29 15:56:56','2022-09-29 15:57:34','2022-09-29 15:57:34'),(41,7851,11,40719,11,3,57,2,20000.00,NULL,'2022-09-29 15:56:56','2022-09-29 15:57:34','2022-09-29 15:57:34'),(42,7851,12,40719,11,3,217,1,15401.41,NULL,'2022-09-29 15:57:34','2022-09-29 15:57:34',NULL);
INSERT INTO `balance_libro_details` VALUES (43,7851,12,40719,11,3,68,1,3234.30,NULL,'2022-09-29 15:57:34','2022-09-29 15:57:34',NULL),(44,7851,12,40719,11,3,217,1,1364.29,NULL,'2022-09-29 15:57:34','2022-09-29 15:57:34',NULL),(45,7851,12,40719,11,3,57,2,20000.00,NULL,'2022-09-29 15:57:34','2022-09-29 15:57:34',NULL),(46,7851,13,40719,11,3,217,1,12239.38,NULL,'2022-09-29 15:59:57','2022-09-29 15:59:57',NULL),(47,7851,13,40719,11,3,68,1,2570.27,NULL,'2022-09-29 15:59:57','2022-09-29 15:59:57',NULL),(48,7851,13,40719,11,3,217,1,1490.35,NULL,'2022-09-29 15:59:57','2022-09-29 15:59:57',NULL),(49,7851,13,40719,11,3,57,2,16300.00,NULL,'2022-09-29 15:59:57','2022-09-29 15:59:57',NULL),(50,7851,14,40719,11,3,217,1,13515.88,NULL,'2022-09-29 16:01:03','2022-12-02 13:53:55','2022-12-02 13:53:55'),(51,7851,14,40719,11,3,68,1,2838.33,NULL,'2022-09-29 16:01:03','2022-12-02 13:53:55','2022-12-02 13:53:55'),(52,7851,14,40719,11,3,217,1,1645.79,NULL,'2022-09-29 16:01:03','2022-12-02 13:53:55','2022-12-02 13:53:55'),(53,7851,14,40719,11,3,57,2,18000.00,NULL,'2022-09-29 16:01:03','2022-12-02 13:53:55','2022-12-02 13:53:55'),(54,7851,15,40719,11,3,217,1,11258.00,NULL,'2022-09-29 16:02:05','2022-09-29 16:02:05',NULL),(55,7851,15,40719,11,3,68,1,2364.18,NULL,'2022-09-29 16:02:05','2022-09-29 16:02:05',NULL),(56,7851,15,40719,11,3,237,1,281.45,NULL,'2022-09-29 16:02:05','2022-09-29 16:02:05',NULL),(57,7851,15,40719,11,3,57,2,13903.63,NULL,'2022-09-29 16:02:05','2022-09-29 16:02:05',NULL),(58,7851,16,40719,11,3,217,1,1326.00,NULL,'2022-09-29 16:03:40','2022-09-29 16:05:19','2022-09-29 16:05:19'),(59,7851,16,40719,11,3,68,1,278.46,NULL,'2022-09-29 16:03:40','2022-09-29 16:05:19','2022-09-29 16:05:19'),(60,7851,16,40719,11,3,57,2,1604.46,NULL,'2022-09-29 16:03:40','2022-09-29 16:05:19','2022-09-29 16:05:19'),(61,7851,17,40719,11,3,217,1,2253.30,NULL,'2022-09-29 16:05:02','2022-09-29 16:05:02',NULL),(62,7851,17,40719,11,3,68,1,473.19,NULL,'2022-09-29 16:05:02','2022-09-29 16:05:02',NULL),(63,7851,17,40719,11,3,217,1,273.47,NULL,'2022-09-29 16:05:02','2022-09-29 16:05:02',NULL),(64,7851,17,40719,11,3,57,2,2999.96,NULL,'2022-09-29 16:05:02','2022-09-29 16:05:02',NULL),(65,7851,18,40719,11,3,217,1,1326.00,NULL,'2022-09-29 16:05:19','2022-09-29 16:05:19',NULL),(66,7851,18,40719,11,3,68,1,278.46,NULL,'2022-09-29 16:05:19','2022-09-29 16:05:19',NULL),(67,7851,18,40719,11,3,57,2,1604.46,NULL,'2022-09-29 16:05:19','2022-09-29 16:05:19',NULL),(68,7851,19,40719,11,2,218,2,722995.00,NULL,'2022-09-29 16:08:30','2022-09-29 16:12:01','2022-09-29 16:12:01'),(69,7851,19,40719,11,2,13,1,722995.00,NULL,'2022-09-29 16:08:30','2022-09-29 16:12:01','2022-09-29 16:12:01'),(70,7851,20,40719,11,2,218,2,722995.00,NULL,'2022-09-29 16:12:01','2022-09-29 16:19:13','2022-09-29 16:19:13'),(71,7851,20,40719,11,2,13,1,722995.00,NULL,'2022-09-29 16:12:01','2022-09-29 16:19:13','2022-09-29 16:19:13'),(72,7851,21,40719,11,2,218,2,722955.00,NULL,'2022-09-29 16:19:13','2022-09-29 16:26:35','2022-09-29 16:26:35'),(73,7851,21,40719,11,2,13,1,722955.00,NULL,'2022-09-29 16:19:13','2022-09-29 16:26:35','2022-09-29 16:26:35'),(74,7851,22,40719,11,2,96,2,654257.92,NULL,'2022-09-29 16:26:35','2022-11-07 18:22:53','2022-11-07 18:22:53'),(75,7851,22,40719,11,2,67,2,68697.08,NULL,'2022-09-29 16:26:35','2022-11-07 18:22:53','2022-11-07 18:22:53'),(76,7851,22,40719,11,2,13,1,722955.00,NULL,'2022-09-29 16:26:35','2022-11-07 18:22:53','2022-11-07 18:22:53'),(77,7851,23,40719,11,3,217,1,12766.00,NULL,'2022-09-29 19:36:22','2022-09-29 19:36:22',NULL),(78,7851,23,40719,11,3,68,1,2680.86,NULL,'2022-09-29 19:36:22','2022-09-29 19:36:22',NULL),(79,7851,23,40719,11,3,217,1,159.25,NULL,'2022-09-29 19:36:22','2022-09-29 19:36:22',NULL),(80,7851,23,40719,11,3,221,1,1395.08,NULL,'2022-09-29 19:36:22','2022-09-29 19:36:22',NULL),(81,7851,23,40719,11,3,57,2,17001.19,NULL,'2022-09-29 19:36:22','2022-09-29 19:36:22',NULL),(82,7851,24,40719,11,3,217,1,9103.55,NULL,'2022-09-29 19:38:18','2022-09-29 19:38:18',NULL);
INSERT INTO `balance_libro_details` VALUES (83,7851,24,40719,11,3,68,1,1911.75,NULL,'2022-09-29 19:38:18','2022-09-29 19:38:18',NULL),(84,7851,24,40719,11,3,221,1,1085.42,NULL,'2022-09-29 19:38:18','2022-09-29 19:38:18',NULL),(85,7851,24,40719,11,3,57,2,12100.72,NULL,'2022-09-29 19:38:18','2022-09-29 19:38:18',NULL),(86,7851,25,40719,11,3,217,1,1128.44,NULL,'2022-09-29 19:47:57','2022-09-29 19:47:57',NULL),(87,7851,25,40719,11,3,68,1,236.97,NULL,'2022-09-29 19:47:57','2022-09-29 19:47:57',NULL),(88,7851,25,40719,11,3,221,1,134.55,NULL,'2022-09-29 19:47:57','2022-09-29 19:47:57',NULL),(89,7851,25,40719,11,3,57,2,1499.96,NULL,'2022-09-29 19:47:57','2022-09-29 19:47:57',NULL),(90,7851,26,40719,11,3,217,1,1504.59,NULL,'2022-09-29 19:49:12','2022-09-29 19:49:12',NULL),(91,7851,26,40719,11,3,68,1,315.96,NULL,'2022-09-29 19:49:12','2022-09-29 19:49:12',NULL),(92,7851,26,40719,11,3,221,1,179.40,NULL,'2022-09-29 19:49:12','2022-09-29 19:49:12',NULL),(93,7851,26,40719,11,3,57,2,1999.95,NULL,'2022-09-29 19:49:12','2022-09-29 19:49:12',NULL),(94,7851,27,40719,11,3,217,1,1128.47,NULL,'2022-09-29 19:49:53','2022-09-29 19:49:53',NULL),(95,7851,27,40719,11,3,68,1,236.98,NULL,'2022-09-29 19:49:53','2022-09-29 19:49:53',NULL),(96,7851,27,40719,11,3,221,1,134.55,NULL,'2022-09-29 19:49:53','2022-09-29 19:49:53',NULL),(97,7851,27,40719,11,3,57,2,1500.00,NULL,'2022-09-29 19:49:53','2022-09-29 19:49:53',NULL),(98,7851,28,40719,11,3,217,1,4545.45,NULL,'2022-09-30 17:03:05','2022-09-30 17:03:18','2022-09-30 17:03:18'),(99,7851,28,40719,11,3,68,1,954.54,NULL,'2022-09-30 17:03:05','2022-09-30 17:03:18','2022-09-30 17:03:18'),(100,7851,28,40719,11,3,217,1,0.01,NULL,'2022-09-30 17:03:05','2022-09-30 17:03:18','2022-09-30 17:03:18'),(101,7851,28,40719,11,3,57,2,5500.00,NULL,'2022-09-30 17:03:05','2022-09-30 17:03:18','2022-09-30 17:03:18'),(102,7851,29,40719,11,3,217,1,4545.45,NULL,'2022-09-30 17:03:18','2022-09-30 17:03:18',NULL),(103,7851,29,40719,11,3,68,1,954.54,NULL,'2022-09-30 17:03:18','2022-09-30 17:03:18',NULL),(104,7851,29,40719,11,3,217,1,0.01,NULL,'2022-09-30 17:03:18','2022-09-30 17:03:18',NULL),(105,7851,29,40719,11,3,57,2,5500.00,NULL,'2022-09-30 17:03:18','2022-09-30 17:03:18',NULL),(106,7851,30,40719,11,3,217,1,2193.75,NULL,'2022-10-01 23:36:04','2022-10-01 23:36:04',NULL),(107,7851,30,40719,11,3,68,1,460.69,NULL,'2022-10-01 23:36:04','2022-10-01 23:36:04',NULL),(108,7851,30,40719,11,3,221,1,345.57,NULL,'2022-10-01 23:36:04','2022-10-01 23:36:04',NULL),(109,7851,30,40719,11,3,57,2,3000.01,NULL,'2022-10-01 23:36:04','2022-10-01 23:36:04',NULL),(110,7851,31,40719,11,3,217,1,997.14,NULL,'2022-10-01 23:38:12','2022-10-01 23:38:12',NULL),(111,7851,31,40719,11,3,68,1,209.40,NULL,'2022-10-01 23:38:12','2022-10-01 23:38:12',NULL),(112,7851,31,40719,11,3,221,1,293.45,NULL,'2022-10-01 23:38:12','2022-10-01 23:38:12',NULL),(113,7851,31,40719,11,3,57,2,1499.99,NULL,'2022-10-01 23:38:12','2022-10-01 23:38:12',NULL),(114,7851,32,40719,11,3,217,1,4033.08,NULL,'2022-10-01 23:42:08','2022-10-01 23:43:43','2022-10-01 23:43:43'),(115,7851,32,40719,11,3,68,1,846.95,NULL,'2022-10-01 23:42:08','2022-10-01 23:43:43','2022-10-01 23:43:43'),(116,7851,32,40719,11,3,217,1,1438.98,NULL,'2022-10-01 23:42:08','2022-10-01 23:43:43','2022-10-01 23:43:43'),(117,7851,32,40719,11,3,220,1,120.99,NULL,'2022-10-01 23:42:08','2022-10-01 23:43:43','2022-10-01 23:43:43'),(118,7851,32,40719,11,3,57,2,6440.00,NULL,'2022-10-01 23:42:08','2022-10-01 23:43:43','2022-10-01 23:43:43'),(119,7851,33,40719,11,3,217,1,862.14,NULL,'2022-10-01 23:43:20','2022-10-01 23:43:20',NULL),(120,7851,33,40719,11,3,68,1,181.05,NULL,'2022-10-01 23:43:20','2022-10-01 23:43:20',NULL),(121,7851,33,40719,11,3,217,1,36.81,NULL,'2022-10-01 23:43:20','2022-10-01 23:43:20',NULL),(122,7851,33,40719,11,3,57,2,1080.00,NULL,'2022-10-01 23:43:20','2022-10-01 23:43:20',NULL),(123,7851,34,40719,11,3,217,1,4033.08,NULL,'2022-10-01 23:43:43','2022-10-01 23:43:43',NULL),(124,7851,34,40719,11,3,68,1,846.95,NULL,'2022-10-01 23:43:43','2022-10-01 23:43:43',NULL);
INSERT INTO `balance_libro_details` VALUES (125,7851,34,40719,11,3,217,1,1438.98,NULL,'2022-10-01 23:43:43','2022-10-01 23:43:43',NULL),(126,7851,34,40719,11,3,220,1,120.99,NULL,'2022-10-01 23:43:43','2022-10-01 23:43:43',NULL),(127,7851,34,40719,11,3,57,2,6440.00,NULL,'2022-10-01 23:43:43','2022-10-01 23:43:43',NULL),(128,7851,35,40719,11,3,217,1,14229.22,NULL,'2022-10-01 23:45:34','2023-01-05 20:53:18','2023-01-05 20:53:18'),(129,7851,35,40719,11,3,68,1,2988.14,NULL,'2022-10-01 23:45:34','2023-01-05 20:53:18','2023-01-05 20:53:18'),(130,7851,35,40719,11,3,217,1,1791.76,NULL,'2022-10-01 23:45:34','2023-01-05 20:53:18','2023-01-05 20:53:18'),(131,7851,35,40719,11,3,220,1,426.88,NULL,'2022-10-01 23:45:34','2023-01-05 20:53:18','2023-01-05 20:53:18'),(132,7851,35,40719,11,3,57,2,19436.00,NULL,'2022-10-01 23:45:34','2023-01-05 20:53:18','2023-01-05 20:53:18'),(133,7851,36,40719,11,3,217,1,185.59,NULL,'2022-10-01 23:46:11','2023-01-05 20:49:26','2023-01-05 20:49:26'),(134,7851,36,40719,11,3,68,1,38.97,NULL,'2022-10-01 23:46:11','2023-01-05 20:49:26','2023-01-05 20:49:26'),(135,7851,36,40719,11,3,217,1,43.44,NULL,'2022-10-01 23:46:11','2023-01-05 20:49:26','2023-01-05 20:49:26'),(136,7851,36,40719,11,3,57,2,268.00,NULL,'2022-10-01 23:46:11','2023-01-05 20:49:26','2023-01-05 20:49:26'),(137,7851,37,40719,11,3,198,1,11439.94,NULL,'2022-10-01 23:50:32','2022-10-01 23:50:32',NULL),(138,7851,37,40719,11,3,68,1,2402.39,NULL,'2022-10-01 23:50:32','2022-10-01 23:50:32',NULL),(139,7851,37,40719,11,3,198,1,1494.47,NULL,'2022-10-01 23:50:32','2022-10-01 23:50:32',NULL),(140,7851,37,40719,11,3,220,1,343.20,NULL,'2022-10-01 23:50:32','2022-10-01 23:50:32',NULL),(141,7851,37,40719,11,3,57,2,15680.00,NULL,'2022-10-01 23:50:32','2022-10-01 23:50:32',NULL),(142,7851,38,40719,11,3,198,1,151.39,NULL,'2022-10-01 23:52:39','2022-10-01 23:52:39',NULL),(143,7851,38,40719,11,3,68,1,31.79,NULL,'2022-10-01 23:52:39','2022-10-01 23:52:39',NULL),(144,7851,38,40719,11,3,198,1,32.82,NULL,'2022-10-01 23:52:39','2022-10-01 23:52:39',NULL),(145,7851,38,40719,11,3,57,2,216.00,NULL,'2022-10-01 23:52:39','2022-10-01 23:52:39',NULL),(146,7851,39,40719,11,3,198,1,9468.30,NULL,'2022-10-01 23:54:02','2022-10-01 23:54:02',NULL),(147,7851,39,40719,11,3,68,1,1988.34,NULL,'2022-10-01 23:54:02','2022-10-01 23:54:02',NULL),(148,7851,39,40719,11,3,198,1,1283.31,NULL,'2022-10-01 23:54:03','2022-10-01 23:54:03',NULL),(149,7851,39,40719,11,3,220,1,284.05,NULL,'2022-10-01 23:54:03','2022-10-01 23:54:03',NULL),(150,7851,39,40719,11,3,57,2,13024.00,NULL,'2022-10-01 23:54:03','2022-10-01 23:54:03',NULL),(151,7851,40,40719,11,3,198,1,148.15,NULL,'2022-10-01 23:54:37','2023-01-05 20:47:01','2023-01-05 20:47:01'),(152,7851,40,40719,11,3,68,1,31.11,NULL,'2022-10-01 23:54:37','2023-01-05 20:47:01','2023-01-05 20:47:01'),(153,7851,40,40719,11,3,198,1,32.74,NULL,'2022-10-01 23:54:37','2023-01-05 20:47:01','2023-01-05 20:47:01'),(154,7851,40,40719,11,3,57,2,212.00,NULL,'2022-10-01 23:54:37','2023-01-05 20:47:01','2023-01-05 20:47:01'),(155,7851,41,40719,10,15,353,1,26924.00,NULL,'2022-11-04 21:50:02','2022-12-21 12:20:42','2022-12-21 12:20:42'),(156,7851,41,40719,10,15,136,2,26924.00,NULL,'2022-11-04 21:50:02','2022-12-21 12:20:42','2022-12-21 12:20:42'),(157,7851,42,40719,11,1,110,1,30000.00,NULL,'2022-11-04 22:11:09','2022-12-02 10:52:03','2022-12-02 10:52:03'),(158,7851,42,40719,11,1,62,2,30000.00,NULL,'2022-11-04 22:11:09','2022-12-02 10:52:03','2022-12-02 10:52:03'),(159,7851,43,40719,11,15,67,1,68697.08,NULL,'2022-11-07 18:14:55','2022-11-07 18:22:35','2022-11-07 18:22:35'),(160,7851,43,40719,11,15,68,2,43216.00,NULL,'2022-11-07 18:14:55','2022-11-07 18:22:35','2022-11-07 18:22:35'),(161,7851,43,40719,11,15,353,2,26924.00,NULL,'2022-11-07 18:14:55','2022-11-07 18:22:35','2022-11-07 18:22:35'),(162,7851,43,40719,11,15,220,2,1175.12,NULL,'2022-11-07 18:14:55','2022-11-07 18:22:35','2022-11-07 18:22:35'),(163,7851,43,40719,11,15,353,1,2957.92,NULL,'2022-11-07 18:14:55','2022-11-07 18:22:35','2022-11-07 18:22:35');
INSERT INTO `balance_libro_details` VALUES (164,7851,43,40719,11,15,354,1,1175.12,NULL,'2022-11-07 18:14:55','2022-11-07 18:22:35','2022-11-07 18:22:35'),(165,7851,43,40719,11,15,136,2,1515.00,NULL,'2022-11-07 18:14:55','2022-11-07 18:22:35','2022-11-07 18:22:35'),(166,7851,44,40719,11,16,237,2,667.90,NULL,'2022-11-07 18:15:25','2022-11-07 18:15:42','2022-11-07 18:15:42'),(167,7851,44,40719,11,16,313,1,667.90,NULL,'2022-11-07 18:15:25','2022-11-07 18:15:42','2022-11-07 18:15:42'),(168,7851,46,40719,11,2,96,2,654294.12,NULL,'2022-11-07 18:22:53','2022-11-07 18:22:53',NULL),(169,7851,46,40719,11,2,67,2,68700.88,NULL,'2022-11-07 18:22:53','2022-11-07 18:22:53',NULL),(170,7851,46,40719,11,2,13,1,722995.00,NULL,'2022-11-07 18:22:53','2022-11-07 18:22:53',NULL),(171,7851,47,40719,12,3,359,1,5716.20,NULL,'2022-11-07 18:28:22','2023-01-05 15:28:15','2023-01-05 15:28:15'),(172,7851,47,40719,12,3,68,1,1200.40,NULL,'2022-11-07 18:28:22','2023-01-05 15:28:15','2023-01-05 15:28:15'),(173,7851,47,40719,12,3,359,1,1084.40,NULL,'2022-11-07 18:28:22','2023-01-05 15:28:15','2023-01-05 15:28:15'),(174,7851,47,40719,12,3,57,2,8001.00,NULL,'2022-11-07 18:28:22','2023-01-05 15:28:15','2023-01-05 15:28:15'),(175,7851,48,40719,12,3,359,1,1132.20,NULL,'2022-11-07 18:31:01','2023-01-05 15:23:42','2023-01-05 15:23:42'),(176,7851,48,40719,12,3,68,1,237.76,NULL,'2022-11-07 18:31:01','2023-01-05 15:23:42','2023-01-05 15:23:42'),(177,7851,48,40719,12,3,57,2,1369.96,NULL,'2022-11-07 18:31:01','2023-01-05 15:23:42','2023-01-05 15:23:42'),(178,7851,49,40719,12,3,359,1,4502.13,NULL,'2022-11-07 18:33:24','2023-01-05 15:16:35','2023-01-05 15:16:35'),(179,7851,49,40719,12,3,68,1,945.45,NULL,'2022-11-07 18:33:24','2023-01-05 15:16:35','2023-01-05 15:16:35'),(180,7851,49,40719,12,3,359,1,852.43,NULL,'2022-11-07 18:33:24','2023-01-05 15:16:35','2023-01-05 15:16:35'),(181,7851,49,40719,12,3,57,2,6300.01,NULL,'2022-11-07 18:33:24','2023-01-05 15:16:35','2023-01-05 15:16:35'),(182,7851,50,40719,12,3,359,1,1263.59,NULL,'2022-11-07 18:37:04','2023-01-05 15:03:26','2023-01-05 15:03:26'),(183,7851,50,40719,12,3,68,1,265.35,NULL,'2022-11-07 18:37:04','2023-01-05 15:03:26','2023-01-05 15:03:26'),(184,7851,50,40719,12,3,359,1,271.07,NULL,'2022-11-07 18:37:04','2023-01-05 15:03:26','2023-01-05 15:03:26'),(185,7851,50,40719,12,3,57,2,1800.01,NULL,'2022-11-07 18:37:04','2023-01-05 15:03:26','2023-01-05 15:03:26'),(186,7851,51,40719,12,3,359,1,11452.19,NULL,'2022-11-07 18:38:04','2023-01-05 14:53:10','2023-01-05 14:53:10'),(187,7851,51,40719,12,3,68,1,2404.96,NULL,'2022-11-07 18:38:04','2023-01-05 14:53:10','2023-01-05 14:53:10'),(188,7851,51,40719,12,3,359,1,1642.85,NULL,'2022-11-07 18:38:04','2023-01-05 14:53:10','2023-01-05 14:53:10'),(189,7851,51,40719,12,3,57,2,15500.00,NULL,'2022-11-07 18:38:04','2023-01-05 14:53:10','2023-01-05 14:53:10'),(190,7851,52,40719,12,3,359,1,7254.15,NULL,'2022-11-07 18:40:24','2022-11-07 18:41:33','2022-11-07 18:41:33'),(191,7851,52,40719,12,3,68,1,1958.62,NULL,'2022-11-07 18:40:24','2022-11-07 18:41:33','2022-11-07 18:41:33'),(192,7851,52,40719,12,3,359,1,400.00,NULL,'2022-11-07 18:40:24','2022-11-07 18:41:33','2022-11-07 18:41:33'),(193,7851,52,40719,12,3,68,1,84.00,NULL,'2022-11-07 18:40:24','2022-11-07 18:41:33','2022-11-07 18:41:33'),(194,7851,52,40719,12,3,221,1,381.79,NULL,'2022-11-07 18:40:24','2022-11-07 18:41:33','2022-11-07 18:41:33'),(195,7851,52,40719,12,3,237,1,229.52,NULL,'2022-11-07 18:40:24','2022-11-07 18:41:33','2022-11-07 18:41:33'),(196,7851,52,40719,12,3,57,2,10308.08,NULL,'2022-11-07 18:40:24','2022-11-07 18:41:33','2022-11-07 18:41:33'),(197,7851,53,40719,12,3,359,1,7254.15,NULL,'2022-11-07 18:41:33','2023-01-05 14:57:13','2023-01-05 14:57:13'),(198,7851,53,40719,12,3,68,1,1958.62,NULL,'2022-11-07 18:41:33','2023-01-05 14:57:13','2023-01-05 14:57:13'),(199,7851,53,40719,12,3,359,1,400.00,NULL,'2022-11-07 18:41:33','2023-01-05 14:57:13','2023-01-05 14:57:13'),(200,7851,53,40719,12,3,68,1,84.00,NULL,'2022-11-07 18:41:33','2023-01-05 14:57:13','2023-01-05 14:57:13');
INSERT INTO `balance_libro_details` VALUES (201,7851,53,40719,12,3,221,1,381.79,NULL,'2022-11-07 18:41:33','2023-01-05 14:57:13','2023-01-05 14:57:13'),(202,7851,53,40719,12,3,237,1,229.52,NULL,'2022-11-07 18:41:33','2023-01-05 14:57:13','2023-01-05 14:57:13'),(203,7851,53,40719,12,3,57,2,10308.08,NULL,'2022-11-07 18:41:33','2023-01-05 14:57:13','2023-01-05 14:57:13'),(204,7851,54,40719,12,3,217,1,18.89,NULL,'2022-11-07 18:43:08','2022-11-07 18:43:36','2022-11-07 18:43:36'),(205,7851,54,40719,12,3,68,1,3.97,NULL,'2022-11-07 18:43:08','2022-11-07 18:43:36','2022-11-07 18:43:36'),(206,7851,54,40719,12,3,57,2,22.86,NULL,'2022-11-07 18:43:08','2022-11-07 18:43:36','2022-11-07 18:43:36'),(207,7851,55,40719,12,3,217,1,1889.73,NULL,'2022-11-07 18:43:36','2022-11-07 18:43:36',NULL),(208,7851,55,40719,12,3,68,1,396.84,NULL,'2022-11-07 18:43:36','2022-11-07 18:43:36',NULL),(209,7851,55,40719,12,3,221,1,213.50,NULL,'2022-11-07 18:43:36','2022-11-07 18:43:36',NULL),(210,7851,55,40719,12,3,57,2,2500.07,NULL,'2022-11-07 18:43:36','2022-11-07 18:43:36',NULL),(211,7851,56,40719,12,3,217,1,985.20,NULL,'2022-11-07 18:45:08','2022-11-07 18:45:08',NULL),(212,7851,56,40719,12,3,68,1,206.89,NULL,'2022-11-07 18:45:08','2022-11-07 18:45:08',NULL),(213,7851,56,40719,12,3,221,1,107.84,NULL,'2022-11-07 18:45:08','2022-11-07 18:45:08',NULL),(214,7851,56,40719,12,3,57,2,1299.93,NULL,'2022-11-07 18:45:08','2022-11-07 18:45:08',NULL),(215,7851,57,40719,12,3,217,1,1165.35,NULL,'2022-11-07 18:46:01','2022-11-07 18:46:01',NULL),(216,7851,57,40719,12,3,68,1,244.72,NULL,'2022-11-07 18:46:01','2022-11-07 18:46:01',NULL),(217,7851,57,40719,12,3,217,1,0.01,NULL,'2022-11-07 18:46:01','2022-11-07 18:46:01',NULL),(218,7851,57,40719,12,3,221,1,89.92,NULL,'2022-11-07 18:46:01','2022-11-07 18:46:01',NULL),(219,7851,57,40719,12,3,57,2,1500.00,NULL,'2022-11-07 18:46:01','2022-11-07 18:46:01',NULL),(220,7851,58,40719,12,3,217,1,2143.31,NULL,'2022-11-07 18:47:45','2022-11-07 18:47:45',NULL),(221,7851,58,40719,12,3,68,1,450.10,NULL,'2022-11-07 18:47:45','2022-11-07 18:47:45',NULL),(222,7851,58,40719,12,3,221,1,406.60,NULL,'2022-11-07 18:47:45','2022-11-07 18:47:45',NULL),(223,7851,58,40719,12,3,57,2,3000.01,NULL,'2022-11-07 18:47:45','2022-11-07 18:47:45',NULL),(224,7851,59,40719,12,3,217,1,33057.02,NULL,'2022-11-07 18:48:35','2022-11-07 18:48:35',NULL),(225,7851,59,40719,12,3,68,1,6941.97,NULL,'2022-11-07 18:48:35','2022-11-07 18:48:35',NULL),(226,7851,59,40719,12,3,57,2,39998.99,NULL,'2022-11-07 18:48:35','2022-11-07 18:48:35',NULL),(227,7851,60,40719,12,3,217,1,14777.02,NULL,'2022-11-07 18:49:34','2022-11-07 18:49:34',NULL),(228,7851,60,40719,12,3,68,1,3103.17,NULL,'2022-11-07 18:49:34','2022-11-07 18:49:34',NULL),(229,7851,60,40719,12,3,221,1,2119.80,NULL,'2022-11-07 18:49:34','2022-11-07 18:49:34',NULL),(230,7851,60,40719,12,3,57,2,19999.99,NULL,'2022-11-07 18:49:34','2022-11-07 18:49:34',NULL),(231,7851,61,40719,12,3,217,1,1136.80,NULL,'2022-11-07 18:50:22','2022-11-07 18:50:22',NULL),(232,7851,61,40719,12,3,68,1,238.73,NULL,'2022-11-07 18:50:22','2022-11-07 18:50:22',NULL),(233,7851,61,40719,12,3,221,1,124.43,NULL,'2022-11-07 18:50:22','2022-11-07 18:50:22',NULL),(234,7851,61,40719,12,3,57,2,1499.96,NULL,'2022-11-07 18:50:22','2022-11-07 18:50:22',NULL),(235,7851,62,40719,12,3,217,1,5034.03,NULL,'2022-11-07 18:52:14','2022-11-07 18:52:14',NULL),(236,7851,62,40719,12,3,68,1,1057.15,NULL,'2022-11-07 18:52:14','2022-11-07 18:52:14',NULL),(237,7851,62,40719,12,3,221,1,511.23,NULL,'2022-11-07 18:52:14','2022-11-07 18:52:14',NULL),(238,7851,62,40719,12,3,57,2,6602.41,NULL,'2022-11-07 18:52:14','2022-11-07 18:52:14',NULL),(239,7851,63,40719,12,3,217,1,5125.00,NULL,'2022-11-07 18:57:52','2022-11-07 18:57:52',NULL),(240,7851,63,40719,12,3,68,1,1076.25,NULL,'2022-11-07 18:57:52','2022-11-07 18:57:52',NULL),(241,7851,63,40719,12,3,221,1,549.85,NULL,'2022-11-07 18:57:52','2022-11-07 18:57:52',NULL),(242,7851,63,40719,12,3,57,2,6751.10,NULL,'2022-11-07 18:57:52','2022-11-07 18:57:52',NULL);
INSERT INTO `balance_libro_details` VALUES (243,7851,64,40719,12,3,217,1,1108.28,NULL,'2022-11-07 19:00:05','2022-11-07 19:00:05',NULL),(244,7851,64,40719,12,3,68,1,232.74,NULL,'2022-11-07 19:00:05','2022-11-07 19:00:05',NULL),(245,7851,64,40719,12,3,221,1,158.99,NULL,'2022-11-07 19:00:05','2022-11-07 19:00:05',NULL),(246,7851,64,40719,12,3,57,2,1500.01,NULL,'2022-11-07 19:00:05','2022-11-07 19:00:05',NULL),(247,7851,65,40719,12,3,217,1,196694.22,NULL,'2022-11-07 19:05:10','2022-11-07 19:05:10',NULL),(248,7851,65,40719,12,3,68,1,41305.79,NULL,'2022-11-07 19:05:10','2022-11-07 19:05:10',NULL),(249,7851,65,40719,12,3,57,2,238000.01,NULL,'2022-11-07 19:05:10','2022-11-07 19:05:10',NULL),(250,7851,66,40719,12,3,217,1,13670.97,NULL,'2022-11-07 19:06:11','2022-11-07 19:06:11',NULL),(251,7851,66,40719,12,3,68,1,2870.90,NULL,'2022-11-07 19:06:11','2022-11-07 19:06:11',NULL),(252,7851,66,40719,12,3,221,1,1961.14,NULL,'2022-11-07 19:06:11','2022-11-07 19:06:11',NULL),(253,7851,66,40719,12,3,57,2,18503.01,NULL,'2022-11-07 19:06:11','2022-11-07 19:06:11',NULL),(254,7851,67,40719,12,3,217,1,5910.81,NULL,'2022-11-07 19:07:00','2022-11-07 19:07:00',NULL),(255,7851,67,40719,12,3,68,1,1241.27,NULL,'2022-11-07 19:07:00','2022-11-07 19:07:00',NULL),(256,7851,67,40719,12,3,221,1,847.92,NULL,'2022-11-07 19:07:00','2022-11-07 19:07:00',NULL),(257,7851,67,40719,12,3,57,2,8000.00,NULL,'2022-11-07 19:07:00','2022-11-07 19:07:00',NULL),(258,7851,68,40719,12,3,217,1,1326.00,NULL,'2022-11-07 19:07:53','2022-11-07 19:25:06','2022-11-07 19:25:06'),(259,7851,68,40719,12,3,68,1,278.46,NULL,'2022-11-07 19:07:53','2022-11-07 19:25:06','2022-11-07 19:25:06'),(260,7851,68,40719,12,3,57,2,1604.46,NULL,'2022-11-07 19:07:53','2022-11-07 19:25:06','2022-11-07 19:25:06'),(261,7851,69,40719,12,3,217,1,185826.46,NULL,'2022-11-07 19:25:06','2022-11-07 19:25:06',NULL),(262,7851,69,40719,12,3,68,1,39023.56,NULL,'2022-11-07 19:25:07','2022-11-07 19:25:07',NULL),(263,7851,69,40719,12,3,57,2,224850.02,NULL,'2022-11-07 19:25:07','2022-11-07 19:25:07',NULL),(264,7851,70,40719,12,3,217,1,1326.00,NULL,'2022-11-07 19:27:06','2022-11-07 19:27:06',NULL),(265,7851,70,40719,12,3,68,1,278.46,NULL,'2022-11-07 19:27:06','2022-11-07 19:27:06',NULL),(266,7851,70,40719,12,3,57,2,1604.46,NULL,'2022-11-07 19:27:06','2022-11-07 19:27:06',NULL),(267,7851,71,40719,12,2,96,2,1628400.00,NULL,'2022-11-07 19:39:59','2022-11-25 18:27:20','2022-11-25 18:27:20'),(268,7851,71,40719,12,2,67,2,170982.00,NULL,'2022-11-07 19:39:59','2022-11-25 18:27:20','2022-11-25 18:27:20'),(269,7851,71,40719,12,2,13,1,1799382.00,NULL,'2022-11-07 19:39:59','2022-11-25 18:27:20','2022-11-25 18:27:20'),(270,7851,72,40719,3053,3,359,1,671.84,NULL,'2022-11-10 17:23:39','2023-01-07 17:51:18','2023-01-07 17:51:18'),(271,7851,72,40719,3053,3,68,1,141.09,NULL,'2022-11-10 17:23:39','2023-01-07 17:51:18','2023-01-07 17:51:18'),(272,7851,72,40719,3053,3,221,1,187.08,NULL,'2022-11-10 17:23:39','2023-01-07 17:51:18','2023-01-07 17:51:18'),(273,7851,72,40719,3053,3,57,2,1000.01,NULL,'2022-11-10 17:23:39','2023-01-07 17:51:18','2023-01-07 17:51:18'),(274,7851,73,40719,3053,3,217,1,1404.00,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(275,7851,73,40719,3053,3,68,1,294.84,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(276,7851,73,40719,3053,3,57,2,1698.84,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(277,7851,74,40719,3053,3,217,2,702.00,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(278,7851,74,40719,3053,3,67,2,147.42,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(279,7851,74,40719,3053,3,57,1,849.42,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(280,7851,75,40719,3053,3,217,2,2106.00,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(281,7851,75,40719,3053,3,67,2,442.26,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(282,7851,75,40719,3053,3,57,1,2548.26,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(283,7851,76,40719,3053,3,217,1,1198.40,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL);
INSERT INTO `balance_libro_details` VALUES (284,7851,76,40719,3053,3,68,1,251.66,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(285,7851,76,40719,3053,3,57,2,1450.06,NULL,'2022-11-10 18:04:38','2022-11-10 18:04:38',NULL),(286,7851,77,40719,3053,3,250,1,440.00,NULL,'2022-11-10 18:04:38','2022-11-25 18:13:16','2022-11-25 18:13:16'),(287,7851,77,40719,3053,3,57,2,440.00,NULL,'2022-11-10 18:04:38','2022-11-25 18:13:16','2022-11-25 18:13:16'),(288,7851,78,40719,3053,3,217,1,4269.57,NULL,'2022-11-10 18:04:38','2022-11-10 18:06:57','2022-11-10 18:06:57'),(289,7851,78,40719,3053,3,68,1,1142.82,NULL,'2022-11-10 18:04:38','2022-11-10 18:06:57','2022-11-10 18:06:57'),(290,7851,78,40719,3053,3,217,1,344.06,NULL,'2022-11-10 18:04:38','2022-11-10 18:06:57','2022-11-10 18:06:57'),(291,7851,78,40719,3053,3,57,2,5756.45,NULL,'2022-11-10 18:04:38','2022-11-10 18:06:57','2022-11-10 18:06:57'),(292,7851,79,40719,3053,3,250,1,900.00,NULL,'2022-11-10 18:04:38','2022-11-25 18:13:11','2022-11-25 18:13:11'),(293,7851,79,40719,3053,3,57,2,900.00,NULL,'2022-11-10 18:04:38','2022-11-25 18:13:11','2022-11-25 18:13:11'),(294,7851,80,40719,3053,3,217,1,4269.57,NULL,'2022-11-10 18:06:57','2023-02-23 11:07:56','2023-02-23 11:07:56'),(295,7851,80,40719,3053,3,68,1,1152.78,NULL,'2022-11-10 18:06:57','2023-02-23 11:07:56','2023-02-23 11:07:56'),(296,7851,80,40719,3053,3,217,1,344.06,NULL,'2022-11-10 18:06:57','2023-02-23 11:07:56','2023-02-23 11:07:56'),(297,7851,80,40719,3053,3,237,1,117.12,NULL,'2022-11-10 18:06:57','2023-02-23 11:07:56','2023-02-23 11:07:56'),(298,7851,80,40719,3053,3,57,2,5883.53,NULL,'2022-11-10 18:06:57','2023-02-23 11:07:56','2023-02-23 11:07:56'),(299,7851,81,40719,13,2,218,2,0.00,NULL,'2022-11-12 15:24:25','2022-11-25 18:24:40','2022-11-25 18:24:40'),(300,7851,81,40719,13,2,218,2,306918.00,NULL,'2022-11-12 15:24:25','2022-11-25 18:24:40','2022-11-25 18:24:40'),(301,7851,81,40719,13,2,13,1,306918.00,NULL,'2022-11-12 15:24:25','2022-11-25 18:24:40','2022-11-25 18:24:40'),(302,7851,82,40719,13,2,218,2,0.00,NULL,'2022-11-12 15:24:25','2022-11-25 18:24:28','2022-11-25 18:24:28'),(303,7851,82,40719,13,2,218,2,306918.00,NULL,'2022-11-12 15:24:25','2022-11-25 18:24:28','2022-11-25 18:24:28'),(304,7851,82,40719,13,2,13,1,306918.00,NULL,'2022-11-12 15:24:25','2022-11-25 18:24:28','2022-11-25 18:24:28'),(305,7851,83,40719,13,2,218,2,0.00,NULL,'2022-11-12 15:24:25','2022-11-25 17:47:37','2022-11-25 17:47:37'),(306,7851,83,40719,13,2,218,2,1175516.00,NULL,'2022-11-12 15:24:25','2022-11-25 17:47:37','2022-11-25 17:47:37'),(307,7851,83,40719,13,2,13,1,1175516.00,NULL,'2022-11-12 15:24:25','2022-11-25 17:47:37','2022-11-25 17:47:37'),(308,7851,84,40719,13,3,217,1,2388.43,NULL,'2022-11-12 15:24:43','2022-11-12 15:57:20','2022-11-12 15:57:20'),(309,7851,84,40719,13,3,68,1,501.57,NULL,'2022-11-12 15:24:43','2022-11-12 15:57:20','2022-11-12 15:57:20'),(310,7851,84,40719,13,3,57,2,2890.00,NULL,'2022-11-12 15:24:43','2022-11-12 15:57:20','2022-11-12 15:57:20'),(311,7851,85,40719,13,3,217,1,18842.98,NULL,'2022-11-12 15:24:43','2022-11-12 15:40:43','2022-11-12 15:40:43'),(312,7851,85,40719,13,3,68,1,3957.03,NULL,'2022-11-12 15:24:43','2022-11-12 15:40:43','2022-11-12 15:40:43'),(313,7851,85,40719,13,3,57,2,22800.01,NULL,'2022-11-12 15:24:43','2022-11-12 15:40:43','2022-11-12 15:40:43'),(314,7851,86,40719,13,3,217,1,1166.19,NULL,'2022-11-12 15:24:43','2022-11-12 15:52:32','2022-11-12 15:52:32'),(315,7851,86,40719,13,3,68,1,314.87,NULL,'2022-11-12 15:24:43','2022-11-12 15:52:32','2022-11-12 15:52:32'),(316,7851,86,40719,13,3,57,2,1481.06,NULL,'2022-11-12 15:24:43','2022-11-12 15:52:32','2022-11-12 15:52:32'),(317,7851,87,40719,13,3,217,1,1371.90,NULL,'2022-11-12 15:24:43','2022-11-12 15:51:54','2022-11-12 15:51:54'),(318,7851,87,40719,13,3,68,1,288.10,NULL,'2022-11-12 15:24:43','2022-11-12 15:51:54','2022-11-12 15:51:54'),(319,7851,87,40719,13,3,57,2,1660.00,NULL,'2022-11-12 15:24:43','2022-11-12 15:51:54','2022-11-12 15:51:54');
INSERT INTO `balance_libro_details` VALUES (320,7851,88,40719,13,3,217,1,4912.92,NULL,'2022-11-12 15:24:43','2022-11-12 15:52:18','2022-11-12 15:52:18'),(321,7851,88,40719,13,3,68,1,1031.71,NULL,'2022-11-12 15:24:43','2022-11-12 15:52:18','2022-11-12 15:52:18'),(322,7851,88,40719,13,3,57,2,5944.63,NULL,'2022-11-12 15:24:43','2022-11-12 15:52:18','2022-11-12 15:52:18'),(323,7851,89,40719,13,3,217,1,1760.33,NULL,'2022-11-12 15:24:43','2022-11-12 15:51:49','2022-11-12 15:51:49'),(324,7851,89,40719,13,3,68,1,369.67,NULL,'2022-11-12 15:24:43','2022-11-12 15:51:49','2022-11-12 15:51:49'),(325,7851,89,40719,13,3,57,2,2130.00,NULL,'2022-11-12 15:24:43','2022-11-12 15:51:49','2022-11-12 15:51:49'),(326,7851,90,40719,13,3,217,1,892.56,NULL,'2022-11-12 15:24:43','2022-11-12 15:51:44','2022-11-12 15:51:44'),(327,7851,90,40719,13,3,68,1,187.44,NULL,'2022-11-12 15:24:43','2022-11-12 15:51:44','2022-11-12 15:51:44'),(328,7851,90,40719,13,3,57,2,1080.00,NULL,'2022-11-12 15:24:43','2022-11-12 15:51:44','2022-11-12 15:51:44'),(329,7851,91,40719,13,3,217,1,18842.98,NULL,'2022-11-12 15:40:43','2022-11-12 15:52:43','2022-11-12 15:52:43'),(330,7851,91,40719,13,3,68,1,3957.03,NULL,'2022-11-12 15:40:43','2022-11-12 15:52:43','2022-11-12 15:52:43'),(331,7851,91,40719,13,3,57,2,22800.01,NULL,'2022-11-12 15:40:43','2022-11-12 15:52:43','2022-11-12 15:52:43'),(332,7851,92,40719,13,3,217,1,4912.92,NULL,'2022-11-12 15:52:18','2022-11-12 15:58:03','2022-11-12 15:58:03'),(333,7851,92,40719,13,3,68,1,1031.71,NULL,'2022-11-12 15:52:18','2022-11-12 15:58:03','2022-11-12 15:58:03'),(334,7851,92,40719,13,3,57,2,5944.63,NULL,'2022-11-12 15:52:18','2022-11-12 15:58:03','2022-11-12 15:58:03'),(335,7851,93,40719,13,3,217,1,1166.19,NULL,'2022-11-12 15:52:32','2022-11-12 15:57:50','2022-11-12 15:57:50'),(336,7851,93,40719,13,3,68,1,314.87,NULL,'2022-11-12 15:52:32','2022-11-12 15:57:50','2022-11-12 15:57:50'),(337,7851,93,40719,13,3,57,2,1481.06,NULL,'2022-11-12 15:52:32','2022-11-12 15:57:50','2022-11-12 15:57:50'),(338,7851,94,40719,13,3,217,1,18842.98,NULL,'2022-11-12 15:52:43','2022-11-12 15:57:30','2022-11-12 15:57:30'),(339,7851,94,40719,13,3,68,1,3957.03,NULL,'2022-11-12 15:52:43','2022-11-12 15:57:30','2022-11-12 15:57:30'),(340,7851,94,40719,13,3,57,2,22800.01,NULL,'2022-11-12 15:52:43','2022-11-12 15:57:30','2022-11-12 15:57:30'),(341,7851,95,40719,12,3,217,1,2388.43,NULL,'2022-11-12 15:57:20','2022-11-25 18:10:52','2022-11-25 18:10:52'),(342,7851,95,40719,12,3,68,1,501.57,NULL,'2022-11-12 15:57:20','2022-11-25 18:10:52','2022-11-25 18:10:52'),(343,7851,95,40719,12,3,57,2,2890.00,NULL,'2022-11-12 15:57:20','2022-11-25 18:10:52','2022-11-25 18:10:52'),(344,7851,96,40719,13,3,217,1,18842.98,NULL,'2022-11-12 15:57:30','2022-11-12 15:57:40','2022-11-12 15:57:40'),(345,7851,96,40719,13,3,68,1,3957.03,NULL,'2022-11-12 15:57:30','2022-11-12 15:57:40','2022-11-12 15:57:40'),(346,7851,96,40719,13,3,57,2,22800.01,NULL,'2022-11-12 15:57:30','2022-11-12 15:57:40','2022-11-12 15:57:40'),(347,7851,97,40719,12,3,217,1,18842.98,NULL,'2022-11-12 15:57:40','2022-11-12 15:57:40',NULL),(348,7851,97,40719,12,3,68,1,3957.03,NULL,'2022-11-12 15:57:40','2022-11-12 15:57:40',NULL),(349,7851,97,40719,12,3,57,2,22800.01,NULL,'2022-11-12 15:57:40','2022-11-12 15:57:40',NULL),(350,7851,98,40719,12,3,217,1,1166.19,NULL,'2022-11-12 15:57:50','2022-11-12 15:57:50',NULL),(351,7851,98,40719,12,3,68,1,314.87,NULL,'2022-11-12 15:57:50','2022-11-12 15:57:50',NULL),(352,7851,98,40719,12,3,57,2,1481.06,NULL,'2022-11-12 15:57:50','2022-11-12 15:57:50',NULL),(353,7851,99,40719,12,3,217,1,4912.92,NULL,'2022-11-12 15:58:03','2022-11-12 15:58:03',NULL),(354,7851,99,40719,12,3,68,1,1031.71,NULL,'2022-11-12 15:58:03','2022-11-12 15:58:03',NULL),(355,7851,99,40719,12,3,57,2,5944.63,NULL,'2022-11-12 15:58:03','2022-11-12 15:58:03',NULL),(356,7851,100,40719,12,3,217,1,1371.90,NULL,'2022-11-12 16:04:49','2022-11-25 18:13:05','2022-11-25 18:13:05'),(357,7851,100,40719,12,3,68,1,288.10,NULL,'2022-11-12 16:04:49','2022-11-25 18:13:05','2022-11-25 18:13:05');
INSERT INTO `balance_libro_details` VALUES (358,7851,100,40719,12,3,57,2,1660.00,NULL,'2022-11-12 16:04:49','2022-11-25 18:13:05','2022-11-25 18:13:05'),(359,7851,101,40719,12,3,217,1,1760.33,NULL,'2022-11-12 16:04:49','2022-11-25 18:12:59','2022-11-25 18:12:59'),(360,7851,101,40719,12,3,68,1,369.67,NULL,'2022-11-12 16:04:49','2022-11-25 18:12:59','2022-11-25 18:12:59'),(361,7851,101,40719,12,3,57,2,2130.00,NULL,'2022-11-12 16:04:49','2022-11-25 18:12:59','2022-11-25 18:12:59'),(362,7851,102,40719,12,3,217,1,892.56,NULL,'2022-11-12 16:04:49','2022-11-25 18:12:52','2022-11-25 18:12:52'),(363,7851,102,40719,12,3,68,1,187.44,NULL,'2022-11-12 16:04:49','2022-11-25 18:12:52','2022-11-25 18:12:52'),(364,7851,102,40719,12,3,57,2,1080.00,NULL,'2022-11-12 16:04:49','2022-11-25 18:12:52','2022-11-25 18:12:52'),(365,7851,103,40719,13,2,96,2,1175516.00,NULL,'2022-11-25 17:47:37','2022-11-25 18:24:55','2022-11-25 18:24:55'),(366,7851,103,40719,13,2,67,2,123429.18,NULL,'2022-11-25 17:47:38','2022-11-25 18:24:55','2022-11-25 18:24:55'),(367,7851,103,40719,13,2,13,1,1298945.18,NULL,'2022-11-25 17:47:38','2022-11-25 18:24:55','2022-11-25 18:24:55'),(368,7851,104,40719,13,2,218,1,0.00,NULL,'2022-11-25 17:50:19','2022-11-25 18:22:55','2022-11-25 18:22:55'),(369,7851,104,40719,13,2,218,1,306918.00,NULL,'2022-11-25 17:50:19','2022-11-25 18:22:55','2022-11-25 18:22:55'),(370,7851,104,40719,13,2,13,2,306918.00,NULL,'2022-11-25 17:50:19','2022-11-25 18:22:55','2022-11-25 18:22:55'),(371,7851,105,40719,13,3,217,1,1723.80,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(372,7851,105,40719,13,3,68,1,362.00,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(373,7851,105,40719,13,3,57,2,2085.80,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(374,7851,106,40719,13,3,217,1,4752.07,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(375,7851,106,40719,13,3,68,1,997.93,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(376,7851,106,40719,13,3,57,2,5750.00,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(377,7851,107,40719,13,3,217,1,1842.98,NULL,'2022-11-25 17:50:46','2022-11-25 18:12:41','2022-11-25 18:12:41'),(378,7851,107,40719,13,3,68,1,387.02,NULL,'2022-11-25 17:50:46','2022-11-25 18:12:41','2022-11-25 18:12:41'),(379,7851,107,40719,13,3,57,2,2230.00,NULL,'2022-11-25 17:50:46','2022-11-25 18:12:41','2022-11-25 18:12:41'),(380,7851,108,40719,13,3,250,1,0.00,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(381,7851,108,40719,13,3,250,1,4000.00,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(382,7851,108,40719,13,3,57,2,4000.00,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(383,7851,109,40719,13,3,217,1,1225.72,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(384,7851,109,40719,13,3,68,1,330.94,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(385,7851,109,40719,13,3,57,2,1556.66,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(386,7851,110,40719,13,3,217,1,9819.30,NULL,'2022-11-25 17:50:46','2022-12-03 19:58:40','2022-12-03 19:58:40'),(387,7851,110,40719,13,3,68,1,2576.87,NULL,'2022-11-25 17:50:46','2022-12-03 19:58:40','2022-12-03 19:58:40'),(388,7851,110,40719,13,3,217,1,746.17,NULL,'2022-11-25 17:50:46','2022-12-03 19:58:40','2022-12-03 19:58:40'),(389,7851,110,40719,13,3,57,2,13142.34,NULL,'2022-11-25 17:50:46','2022-12-03 19:58:40','2022-12-03 19:58:40'),(390,7851,111,40719,13,3,217,1,2885.15,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(391,7851,111,40719,13,3,68,1,605.88,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(392,7851,111,40719,13,3,217,1,508.98,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(393,7851,111,40719,13,3,57,2,4000.01,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(394,7851,112,40719,13,3,217,1,5487.60,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(395,7851,112,40719,13,3,68,1,1152.40,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(396,7851,112,40719,13,3,57,2,6640.00,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL);
INSERT INTO `balance_libro_details` VALUES (397,7851,113,40719,13,3,217,1,50123.96,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(398,7851,113,40719,13,3,68,1,10526.03,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(399,7851,113,40719,13,3,57,2,60649.99,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(400,7851,114,40719,13,3,217,1,14090.91,NULL,'2022-11-25 17:50:46','2022-12-19 17:57:01','2022-12-19 17:57:01'),(401,7851,114,40719,13,3,68,1,2959.09,NULL,'2022-11-25 17:50:46','2022-12-19 17:57:01','2022-12-19 17:57:01'),(402,7851,114,40719,13,3,57,2,17050.00,NULL,'2022-11-25 17:50:46','2022-12-19 17:57:01','2022-12-19 17:57:01'),(403,7851,115,40719,13,3,217,1,32882.92,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(404,7851,115,40719,13,3,68,1,6905.41,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(405,7851,115,40719,13,3,57,2,39788.33,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(406,7851,116,40719,13,3,217,1,11570.24,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(407,7851,116,40719,13,3,68,1,2429.75,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(408,7851,116,40719,13,3,57,2,13999.99,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(409,7851,117,40719,13,3,217,1,7214.67,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(410,7851,117,40719,13,3,68,1,1515.08,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(411,7851,117,40719,13,3,217,1,1272.75,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(412,7851,117,40719,13,3,57,2,10002.50,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(413,7851,118,40719,13,3,217,1,55785.12,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(414,7851,118,40719,13,3,68,1,11714.88,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(415,7851,118,40719,13,3,57,2,67500.00,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(416,7851,119,40719,13,3,217,1,1404.96,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(417,7851,119,40719,13,3,68,1,295.04,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(418,7851,119,40719,13,3,57,2,1700.00,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(419,7851,120,40719,13,3,217,1,2066.11,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(420,7851,120,40719,13,3,68,1,433.88,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(421,7851,120,40719,13,3,57,2,2499.99,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(422,7851,121,40719,13,3,217,1,88467.18,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(423,7851,121,40719,13,3,68,1,18578.11,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(424,7851,121,40719,13,3,217,1,-0.01,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(425,7851,121,40719,13,3,57,2,107045.28,NULL,'2022-11-25 17:50:46','2022-11-25 17:50:46',NULL),(426,7851,122,40719,13,3,359,1,13165.17,NULL,'2022-11-25 17:58:59','2023-01-05 14:27:06','2023-01-05 14:27:06'),(427,7851,122,40719,13,3,68,1,2764.69,NULL,'2022-11-25 17:58:59','2023-01-05 14:27:06','2023-01-05 14:27:06'),(428,7851,122,40719,13,3,221,1,1441.02,NULL,'2022-11-25 17:58:59','2023-01-05 14:27:06','2023-01-05 14:27:06'),(429,7851,122,40719,13,3,57,2,17370.88,NULL,'2022-11-25 17:58:59','2023-01-05 14:27:06','2023-01-05 14:27:06'),(430,7851,123,40719,13,3,359,1,7938.27,NULL,'2022-11-25 17:59:54','2023-01-05 14:32:36','2023-01-05 14:32:36'),(431,7851,123,40719,13,3,68,1,1667.04,NULL,'2022-11-25 17:59:54','2023-01-05 14:32:36','2023-01-05 14:32:36'),(432,7851,123,40719,13,3,221,1,794.95,NULL,'2022-11-25 17:59:54','2023-01-05 14:32:36','2023-01-05 14:32:36'),(433,7851,123,40719,13,3,57,2,10400.26,NULL,'2022-11-25 17:59:54','2023-01-05 14:32:36','2023-01-05 14:32:36'),(434,7851,124,40719,13,3,359,1,1526.48,NULL,'2022-11-25 18:00:32','2023-01-05 15:43:43','2023-01-05 15:43:43'),(435,7851,124,40719,13,3,68,1,320.56,NULL,'2022-11-25 18:00:32','2023-01-05 15:43:43','2023-01-05 15:43:43'),(436,7851,124,40719,13,3,221,1,152.95,NULL,'2022-11-25 18:00:32','2023-01-05 15:43:43','2023-01-05 15:43:43');
INSERT INTO `balance_libro_details` VALUES (437,7851,124,40719,13,3,57,2,1999.99,NULL,'2022-11-25 18:00:32','2023-01-05 15:43:43','2023-01-05 15:43:43'),(438,7851,125,40719,13,3,359,1,9694.01,NULL,'2022-11-25 18:01:08','2023-01-05 17:51:10','2023-01-05 17:51:10'),(439,7851,125,40719,13,3,68,1,2035.74,NULL,'2022-11-25 18:01:08','2023-01-05 17:51:10','2023-01-05 17:51:10'),(440,7851,125,40719,13,3,221,1,971.35,NULL,'2022-11-25 18:01:08','2023-01-05 17:51:10','2023-01-05 17:51:10'),(441,7851,125,40719,13,3,57,2,12701.10,NULL,'2022-11-25 18:01:08','2023-01-05 17:51:10','2023-01-05 17:51:10'),(442,7851,126,40719,13,3,359,1,1144.86,NULL,'2022-11-25 18:02:18','2023-01-05 17:52:38','2023-01-05 17:52:38'),(443,7851,126,40719,13,3,68,1,240.42,NULL,'2022-11-25 18:02:18','2023-01-05 17:52:38','2023-01-05 17:52:38'),(444,7851,126,40719,13,3,221,1,114.72,NULL,'2022-11-25 18:02:18','2023-01-05 17:52:38','2023-01-05 17:52:38'),(445,7851,126,40719,13,3,57,2,1500.00,NULL,'2022-11-25 18:02:18','2023-01-05 17:52:38','2023-01-05 17:52:38'),(446,7851,127,40719,13,3,359,1,10418.09,NULL,'2022-11-25 18:03:19','2023-01-05 17:55:29','2023-01-05 17:55:29'),(447,7851,127,40719,13,3,68,1,2187.80,NULL,'2022-11-25 18:03:19','2023-01-05 17:55:29','2023-01-05 17:55:29'),(448,7851,127,40719,13,3,221,1,1295.41,NULL,'2022-11-25 18:03:19','2023-01-05 17:55:29','2023-01-05 17:55:29'),(449,7851,127,40719,13,3,57,2,13901.30,NULL,'2022-11-25 18:03:19','2023-01-05 17:55:29','2023-01-05 17:55:29'),(450,7851,128,40719,13,3,359,1,3747.16,NULL,'2022-11-25 18:04:06','2023-01-05 17:58:01','2023-01-05 17:58:01'),(451,7851,128,40719,13,3,68,1,786.90,NULL,'2022-11-25 18:04:06','2023-01-05 17:58:01','2023-01-05 17:58:01'),(452,7851,128,40719,13,3,221,1,465.93,NULL,'2022-11-25 18:04:06','2023-01-05 17:58:01','2023-01-05 17:58:01'),(453,7851,128,40719,13,3,57,2,4999.99,NULL,'2022-11-25 18:04:06','2023-01-05 17:58:01','2023-01-05 17:58:01'),(454,7851,129,40719,13,3,359,1,14239.23,NULL,'2022-11-25 18:04:41','2023-01-05 17:59:57','2023-01-05 17:59:57'),(455,7851,129,40719,13,3,68,1,2990.24,NULL,'2022-11-25 18:04:41','2023-01-05 17:59:57','2023-01-05 17:59:57'),(456,7851,129,40719,13,3,221,1,1770.54,NULL,'2022-11-25 18:04:41','2023-01-05 17:59:57','2023-01-05 17:59:57'),(457,7851,129,40719,13,3,57,2,19000.01,NULL,'2022-11-25 18:04:41','2023-01-05 17:59:57','2023-01-05 17:59:57'),(458,7851,130,40719,13,3,359,1,4570.60,NULL,'2022-11-25 18:06:30','2023-01-05 18:04:22','2023-01-05 18:04:22'),(459,7851,130,40719,13,3,68,1,959.83,NULL,'2022-11-25 18:06:30','2023-01-05 18:04:22','2023-01-05 18:04:22'),(460,7851,130,40719,13,3,221,1,670.63,NULL,'2022-11-25 18:06:30','2023-01-05 18:04:22','2023-01-05 18:04:22'),(461,7851,130,40719,13,3,57,2,6201.06,NULL,'2022-11-25 18:06:30','2023-01-05 18:04:22','2023-01-05 18:04:22'),(462,7851,131,40719,13,3,359,1,20330.58,NULL,'2022-11-25 18:08:40','2023-01-05 18:08:08','2023-01-05 18:08:08'),(463,7851,131,40719,13,3,68,1,4269.42,NULL,'2022-11-25 18:08:40','2023-01-05 18:08:08','2023-01-05 18:08:08'),(464,7851,131,40719,13,3,57,2,24600.00,NULL,'2022-11-25 18:08:40','2023-01-05 18:08:08','2023-01-05 18:08:08'),(465,7851,132,40719,13,3,359,1,9619.83,NULL,'2022-11-25 18:09:12','2022-11-25 18:10:56','2022-11-25 18:10:56'),(466,7851,132,40719,13,3,68,1,2020.16,NULL,'2022-11-25 18:09:12','2022-11-25 18:10:56','2022-11-25 18:10:56'),(467,7851,132,40719,13,3,57,2,11639.99,NULL,'2022-11-25 18:09:12','2022-11-25 18:10:56','2022-11-25 18:10:56'),(468,7851,133,40719,13,3,359,1,9619.83,NULL,'2022-11-25 18:12:29','2023-01-05 18:08:33','2023-01-05 18:08:33'),(469,7851,133,40719,13,3,68,1,2020.16,NULL,'2022-11-25 18:12:29','2023-01-05 18:08:33','2023-01-05 18:08:33'),(470,7851,133,40719,13,3,57,2,11639.99,NULL,'2022-11-25 18:12:29','2023-01-05 18:08:33','2023-01-05 18:08:33'),(471,7851,134,40719,13,2,96,1,277753.85,NULL,'2022-11-25 18:22:55','2022-11-25 18:27:52','2022-11-25 18:27:52'),(472,7851,134,40719,13,2,68,1,29164.15,NULL,'2022-11-25 18:22:55','2022-11-25 18:27:52','2022-11-25 18:27:52');
INSERT INTO `balance_libro_details` VALUES (473,7851,134,40719,13,2,13,2,306918.00,NULL,'2022-11-25 18:22:55','2022-11-25 18:27:52','2022-11-25 18:27:52'),(474,7851,135,40719,13,2,96,2,277753.85,NULL,'2022-11-25 18:24:28','2022-11-25 18:43:46','2022-11-25 18:43:46'),(475,7851,135,40719,13,2,67,2,29164.15,NULL,'2022-11-25 18:24:28','2022-11-25 18:43:46','2022-11-25 18:43:46'),(476,7851,135,40719,13,2,13,1,306918.00,NULL,'2022-11-25 18:24:28','2022-11-25 18:43:46','2022-11-25 18:43:46'),(477,7851,136,40719,13,2,96,2,277753.85,NULL,'2022-11-25 18:24:40','2022-11-29 21:48:34','2022-11-29 21:48:34'),(478,7851,136,40719,13,2,67,2,29164.15,NULL,'2022-11-25 18:24:40','2022-11-29 21:48:34','2022-11-29 21:48:34'),(479,7851,136,40719,13,2,13,1,306918.00,NULL,'2022-11-25 18:24:40','2022-11-29 21:48:34','2022-11-29 21:48:34'),(480,7851,137,40719,13,2,96,2,1063815.38,NULL,'2022-11-25 18:24:55','2022-11-25 18:24:55',NULL),(481,7851,137,40719,13,2,67,2,111700.61,NULL,'2022-11-25 18:24:55','2022-11-25 18:24:55',NULL),(482,7851,137,40719,13,2,13,1,1175515.99,NULL,'2022-11-25 18:24:55','2022-11-25 18:24:55',NULL),(483,7851,138,40719,12,2,96,2,1628400.00,NULL,'2022-11-25 18:27:20','2022-11-25 18:27:20',NULL),(484,7851,138,40719,12,2,67,2,170982.00,NULL,'2022-11-25 18:27:20','2022-11-25 18:27:20',NULL),(485,7851,138,40719,12,2,13,1,1799382.00,NULL,'2022-11-25 18:27:20','2022-11-25 18:27:20',NULL),(486,7851,139,40719,13,2,96,1,277753.85,NULL,'2022-11-25 18:27:52','2022-11-29 21:48:15','2022-11-29 21:48:15'),(487,7851,139,40719,13,2,68,1,29164.15,NULL,'2022-11-25 18:27:52','2022-11-29 21:48:15','2022-11-29 21:48:15'),(488,7851,139,40719,13,2,13,2,306918.00,NULL,'2022-11-25 18:27:52','2022-11-29 21:48:15','2022-11-29 21:48:15'),(489,7851,140,40719,13,2,96,2,277753.85,NULL,'2022-11-25 18:43:46','2022-11-25 18:43:46',NULL),(490,7851,140,40719,13,2,67,2,29164.15,NULL,'2022-11-25 18:43:46','2022-11-25 18:43:46',NULL),(491,7851,140,40719,13,2,13,1,306918.00,NULL,'2022-11-25 18:43:46','2022-11-25 18:43:46',NULL),(492,7851,141,40719,13,22,163,1,200000.00,NULL,'2022-11-28 12:26:27','2022-11-28 12:26:54','2022-11-28 12:26:54'),(493,7851,141,40719,13,22,163,2,200000.00,NULL,'2022-11-28 12:26:27','2022-11-28 12:26:54','2022-11-28 12:26:54'),(494,7851,142,40719,13,19,482,1,200000.00,NULL,'2022-11-28 14:46:11','2022-11-28 22:37:20','2022-11-28 22:37:20'),(495,7851,142,40719,13,19,163,2,200000.00,NULL,'2022-11-28 14:46:11','2022-11-28 22:37:20','2022-11-28 22:37:20'),(496,7851,143,40719,13,19,487,2,80000.00,NULL,'2022-11-28 14:59:42','2022-11-29 19:30:18','2022-11-29 19:30:18'),(497,7851,143,40719,13,19,482,1,80000.00,NULL,'2022-11-28 14:59:42','2022-11-29 19:30:18','2022-11-29 19:30:18'),(498,7851,144,40719,13,20,13,2,1175515.99,NULL,'2022-11-28 15:06:49','2022-11-28 15:22:07','2022-11-28 15:22:07'),(499,7851,144,40719,13,20,482,1,1122325.24,NULL,'2022-11-28 15:06:49','2022-11-28 15:22:07','2022-11-28 15:22:07'),(500,7851,144,40719,13,20,263,1,53190.75,NULL,'2022-11-28 15:06:49','2022-11-28 15:22:07','2022-11-28 15:22:07'),(501,7851,145,40719,13,20,13,2,306918.00,NULL,'2022-11-28 15:13:58','2022-11-28 15:22:11','2022-11-28 15:22:11'),(502,7851,145,40719,13,20,482,1,297510.30,NULL,'2022-11-28 15:13:58','2022-11-28 15:22:11','2022-11-28 15:22:11'),(503,7851,145,40719,13,20,263,1,9407.70,NULL,'2022-11-28 15:13:58','2022-11-28 15:22:11','2022-11-28 15:22:11'),(504,7851,146,40719,12,20,13,2,1799382.00,NULL,'2022-11-28 15:21:29','2022-11-28 15:21:29',NULL),(505,7851,146,40719,12,20,482,1,1722442.00,NULL,'2022-11-28 15:21:29','2022-11-28 15:21:29',NULL),(506,7851,146,40719,12,20,23,1,28088.00,NULL,'2022-11-28 15:21:29','2022-11-28 15:21:29',NULL),(507,7851,146,40719,12,20,263,1,48852.00,NULL,'2022-11-28 15:21:29','2022-11-28 15:21:29',NULL),(508,7851,147,40719,13,21,57,1,107045.28,NULL,'2022-11-28 15:24:57','2022-11-28 15:24:57',NULL),(509,7851,147,40719,13,21,483,2,107045.28,NULL,'2022-11-28 15:24:57','2022-11-28 15:24:57',NULL);
INSERT INTO `balance_libro_details` VALUES (510,7851,148,40719,13,21,57,1,36239.99,NULL,'2022-11-28 15:37:50','2023-01-05 18:07:35','2023-01-05 18:07:35'),(511,7851,148,40719,13,21,482,2,24600.00,NULL,'2022-11-28 15:37:50','2023-01-05 18:07:35','2023-01-05 18:07:35'),(512,7851,148,40719,13,21,482,2,11639.99,NULL,'2022-11-28 15:37:50','2023-01-05 18:07:35','2023-01-05 18:07:35'),(513,7851,149,40719,13,3,359,1,5573.77,NULL,'2022-11-28 15:41:43','2023-01-05 18:11:40','2023-01-05 18:11:40'),(514,7851,149,40719,13,3,68,1,1170.49,NULL,'2022-11-28 15:41:43','2023-01-05 18:11:40','2023-01-05 18:11:40'),(515,7851,149,40719,13,3,221,1,558.50,NULL,'2022-11-28 15:41:43','2023-01-05 18:11:40','2023-01-05 18:11:40'),(516,7851,149,40719,13,3,57,2,7302.76,NULL,'2022-11-28 15:41:43','2023-01-05 18:11:40','2023-01-05 18:11:40'),(517,7851,150,40719,11,21,57,1,13903.63,NULL,'2022-11-28 15:46:05','2022-11-28 15:46:05',NULL),(518,7851,150,40719,11,21,482,2,13903.63,NULL,'2022-11-28 15:46:05','2022-11-28 15:46:05',NULL),(519,7851,151,40719,13,21,57,1,10002.50,NULL,'2022-11-28 15:49:11','2022-11-28 15:49:11',NULL),(520,7851,151,40719,13,21,482,2,10002.50,NULL,'2022-11-28 15:49:11','2022-11-28 15:49:11',NULL),(521,7851,152,40719,13,21,57,1,19000.01,NULL,'2022-11-28 15:51:17','2023-01-05 17:59:36','2023-01-05 17:59:36'),(522,7851,152,40719,13,21,484,2,19000.01,NULL,'2022-11-28 15:51:17','2023-01-05 17:59:36','2023-01-05 17:59:36'),(523,7851,153,40719,13,21,57,1,13901.30,NULL,'2022-11-28 15:52:09','2023-01-05 17:55:12','2023-01-05 17:55:12'),(524,7851,153,40719,13,21,484,2,13901.30,NULL,'2022-11-28 15:52:09','2023-01-05 17:55:12','2023-01-05 17:55:12'),(525,7851,154,40719,13,21,57,1,4999.99,NULL,'2022-11-28 15:52:51','2022-11-28 19:04:40','2022-11-28 19:04:40'),(526,7851,154,40719,13,21,484,2,4999.99,NULL,'2022-11-28 15:52:51','2022-11-28 19:04:40','2022-11-28 19:04:40'),(527,7851,155,40719,13,21,57,1,6201.06,NULL,'2022-11-28 15:57:35','2022-11-29 20:07:54','2022-11-29 20:07:54'),(528,7851,155,40719,13,21,488,2,6201.06,NULL,'2022-11-28 15:57:35','2022-11-29 20:07:54','2022-11-29 20:07:54'),(529,7851,156,40719,13,20,13,2,33904.11,NULL,'2022-11-28 16:00:27','2022-11-28 16:49:25','2022-11-28 16:49:25'),(530,7851,156,40719,13,20,488,1,33904.11,NULL,'2022-11-28 16:00:27','2022-11-28 16:49:25','2022-11-28 16:49:25'),(531,7851,157,40719,13,21,57,1,17370.88,NULL,'2022-11-28 16:01:43','2022-11-28 18:56:36','2022-11-28 18:56:36'),(532,7851,157,40719,13,21,488,2,17370.88,NULL,'2022-11-28 16:01:43','2022-11-28 18:56:36','2022-11-28 18:56:36'),(533,7851,158,40719,13,21,57,1,13999.99,NULL,'2022-11-28 16:03:59','2022-11-28 16:03:59',NULL),(534,7851,158,40719,13,21,482,2,13999.99,NULL,'2022-11-28 16:03:59','2022-11-28 16:03:59',NULL),(535,7851,159,40719,13,21,57,1,2499.99,NULL,'2022-11-28 16:04:47','2022-11-28 16:04:47',NULL),(536,7851,159,40719,13,21,482,2,2499.99,NULL,'2022-11-28 16:04:47','2022-11-28 16:04:47',NULL),(537,7851,160,40719,13,21,57,1,60649.99,NULL,'2022-11-28 16:08:08','2022-11-28 16:08:08',NULL),(538,7851,160,40719,13,21,482,2,60649.99,NULL,'2022-11-28 16:08:08','2022-11-28 16:08:08',NULL),(539,7851,161,40719,13,21,57,1,69200.00,NULL,'2022-11-28 16:09:22','2022-11-28 16:09:22',NULL),(540,7851,161,40719,13,21,482,2,69200.00,NULL,'2022-11-28 16:09:22','2022-11-28 16:09:22',NULL),(541,7851,162,40719,13,21,57,1,2085.80,NULL,'2022-11-28 16:10:20','2022-11-28 16:10:20',NULL),(542,7851,162,40719,13,21,482,2,2085.80,NULL,'2022-11-28 16:10:20','2022-11-28 16:10:20',NULL),(543,7851,163,40719,13,21,57,1,4000.01,NULL,'2022-11-28 16:11:24','2022-11-28 16:11:24',NULL),(544,7851,163,40719,13,21,488,2,4000.01,NULL,'2022-11-28 16:11:24','2022-11-28 16:11:24',NULL),(545,7851,164,40719,13,21,57,1,6640.00,NULL,'2022-11-28 16:12:10','2022-11-28 16:12:10',NULL),(546,7851,164,40719,13,21,482,2,6640.00,NULL,'2022-11-28 16:12:10','2022-11-28 16:12:10',NULL),(547,7851,165,40719,13,21,57,1,5750.00,NULL,'2022-11-28 16:13:01','2022-11-28 16:13:01',NULL);
INSERT INTO `balance_libro_details` VALUES (548,7851,165,40719,13,21,488,2,5750.00,NULL,'2022-11-28 16:13:01','2022-11-28 16:13:01',NULL),(549,7851,166,40719,13,2,96,2,1421.49,NULL,'2022-11-28 16:17:58','2022-11-28 16:18:47','2022-11-28 16:18:47'),(550,7851,166,40719,13,2,67,2,298.51,NULL,'2022-11-28 16:17:58','2022-11-28 16:18:47','2022-11-28 16:18:47'),(551,7851,166,40719,13,2,218,2,180.00,NULL,'2022-11-28 16:17:58','2022-11-28 16:18:47','2022-11-28 16:18:47'),(552,7851,166,40719,13,2,13,1,1900.00,NULL,'2022-11-28 16:17:58','2022-11-28 16:18:47','2022-11-28 16:18:47'),(553,7851,167,40719,13,3,359,1,1421.49,NULL,'2022-11-28 16:19:38','2023-01-05 18:44:52','2023-01-05 18:44:52'),(554,7851,167,40719,13,3,68,1,298.51,NULL,'2022-11-28 16:19:38','2023-01-05 18:44:52','2023-01-05 18:44:52'),(555,7851,167,40719,13,3,359,1,180.00,NULL,'2022-11-28 16:19:38','2023-01-05 18:44:52','2023-01-05 18:44:52'),(556,7851,167,40719,13,3,57,2,1900.00,NULL,'2022-11-28 16:19:38','2023-01-05 18:44:52','2023-01-05 18:44:52'),(557,7851,168,40719,13,3,359,1,1069.52,NULL,'2022-11-28 16:20:23','2023-01-05 18:50:30','2023-01-05 18:50:30'),(558,7851,168,40719,13,3,68,1,224.60,NULL,'2022-11-28 16:20:23','2023-01-05 18:50:30','2023-01-05 18:50:30'),(559,7851,168,40719,13,3,221,1,205.88,NULL,'2022-11-28 16:20:23','2023-01-05 18:50:30','2023-01-05 18:50:30'),(560,7851,168,40719,13,3,57,2,1500.00,NULL,'2022-11-28 16:20:23','2023-01-05 18:50:30','2023-01-05 18:50:30'),(561,7851,169,40719,13,3,359,1,14089.34,NULL,'2022-11-28 16:21:13','2023-01-05 18:52:41','2023-01-05 18:52:41'),(562,7851,169,40719,13,3,68,1,2958.76,NULL,'2022-11-28 16:21:13','2023-01-05 18:52:41','2023-01-05 18:52:41'),(563,7851,169,40719,13,3,221,1,1751.90,NULL,'2022-11-28 16:21:13','2023-01-05 18:52:41','2023-01-05 18:52:41'),(564,7851,169,40719,13,3,57,2,18800.00,NULL,'2022-11-28 16:21:13','2023-01-05 18:52:41','2023-01-05 18:52:41'),(565,7851,170,40719,13,3,359,1,1123.71,NULL,'2022-11-28 16:22:07','2023-01-05 18:53:52','2023-01-05 18:53:52'),(566,7851,170,40719,13,3,68,1,235.98,NULL,'2022-11-28 16:22:07','2023-01-05 18:53:52','2023-01-05 18:53:52'),(567,7851,170,40719,13,3,221,1,140.33,NULL,'2022-11-28 16:22:07','2023-01-05 18:53:52','2023-01-05 18:53:52'),(568,7851,170,40719,13,3,57,2,1500.02,NULL,'2022-11-28 16:22:07','2023-01-05 18:53:52','2023-01-05 18:53:52'),(569,7851,171,40719,13,3,359,1,3052.97,NULL,'2022-11-28 16:22:50','2023-01-05 18:55:59','2023-01-05 18:55:59'),(570,7851,171,40719,13,3,68,1,641.12,NULL,'2022-11-28 16:22:50','2023-01-05 18:55:59','2023-01-05 18:55:59'),(571,7851,171,40719,13,3,221,1,305.91,NULL,'2022-11-28 16:22:50','2023-01-05 18:55:59','2023-01-05 18:55:59'),(572,7851,171,40719,13,3,57,2,4000.00,NULL,'2022-11-28 16:22:50','2023-01-05 18:55:59','2023-01-05 18:55:59'),(573,7851,172,40719,13,3,359,1,1373.88,NULL,'2022-11-28 16:24:05','2023-01-05 15:42:20','2023-01-05 15:42:20'),(574,7851,172,40719,13,3,68,1,288.51,NULL,'2022-11-28 16:24:05','2023-01-05 15:42:20','2023-01-05 15:42:20'),(575,7851,172,40719,13,3,221,1,137.66,NULL,'2022-11-28 16:24:05','2023-01-05 15:42:20','2023-01-05 15:42:20'),(576,7851,172,40719,13,3,57,2,1800.05,NULL,'2022-11-28 16:24:05','2023-01-05 15:42:20','2023-01-05 15:42:20'),(577,7851,173,40719,13,20,13,2,39704.16,NULL,'2022-11-28 16:51:16','2022-11-28 16:51:24','2022-11-28 16:51:24'),(578,7851,173,40719,13,20,488,1,39704.16,NULL,'2022-11-28 16:51:16','2022-11-28 16:51:24','2022-11-28 16:51:24'),(579,7851,174,40719,13,21,57,1,39704.16,NULL,'2022-11-28 16:53:16','2022-11-28 18:56:42','2022-11-28 18:56:42'),(580,7851,174,40719,13,21,488,2,39704.16,NULL,'2022-11-28 16:53:16','2022-11-28 18:56:42','2022-11-28 18:56:42'),(581,7851,175,40719,13,21,57,1,1900.00,NULL,'2022-11-28 16:54:59','2022-12-03 16:11:33','2022-12-03 16:11:33'),(582,7851,175,40719,13,21,482,2,1900.00,NULL,'2022-11-28 16:54:59','2022-12-03 16:11:33','2022-12-03 16:11:33'),(583,7851,176,40719,13,21,57,1,1500.00,NULL,'2022-11-28 16:55:41','2023-01-05 18:50:06','2023-01-05 18:50:06');
INSERT INTO `balance_libro_details` VALUES (584,7851,176,40719,13,21,488,2,1500.00,NULL,'2022-11-28 16:55:41','2023-01-05 18:50:06','2023-01-05 18:50:06'),(585,7851,177,40719,13,21,57,1,39788.33,NULL,'2022-11-28 16:58:54','2022-11-28 16:58:54',NULL),(586,7851,177,40719,13,21,483,2,39788.33,NULL,'2022-11-28 16:58:54','2022-11-28 16:58:54',NULL),(587,7851,178,40719,13,19,483,1,50000.00,NULL,'2022-11-28 17:09:04','2022-11-28 17:59:23','2022-11-28 17:59:23'),(588,7851,178,40719,13,19,484,2,50000.00,NULL,'2022-11-28 17:09:04','2022-11-28 17:59:23','2022-11-28 17:59:23'),(593,7851,181,40719,13,19,482,1,100000.00,NULL,'2022-11-28 17:22:09','2022-11-28 17:59:23','2022-11-28 17:59:23'),(594,7851,181,40719,13,19,483,2,100000.00,NULL,'2022-11-28 17:22:09','2022-11-28 17:59:23','2022-11-28 17:59:23'),(595,7851,182,40719,13,19,483,1,50000.00,NULL,'2022-11-28 17:25:12','2022-11-28 17:59:23','2022-11-28 17:59:23'),(596,7851,182,40719,13,19,484,2,50000.00,NULL,'2022-11-28 17:25:12','2022-11-28 17:59:23','2022-11-28 17:59:23'),(597,7851,183,40719,13,19,482,1,200000.00,NULL,'2022-11-28 17:26:14','2022-11-28 17:59:23','2022-11-28 17:59:23'),(598,7851,183,40719,13,19,483,2,200000.00,NULL,'2022-11-28 17:26:14','2022-11-28 17:59:23','2022-11-28 17:59:23'),(599,7851,184,40719,12,19,163,1,90000.00,NULL,'2022-11-28 17:33:30','2022-11-28 17:59:23','2022-11-28 17:59:23'),(600,7851,184,40719,12,19,483,2,90000.00,NULL,'2022-11-28 17:33:30','2022-11-28 17:59:23','2022-11-28 17:59:23'),(601,7851,185,40719,13,19,483,2,50000.00,NULL,'2022-11-28 18:00:45','2022-11-28 18:00:45',NULL),(602,7851,185,40719,13,19,484,1,50000.00,NULL,'2022-11-28 18:00:45','2022-11-28 18:00:45',NULL),(603,7851,186,40719,13,19,484,1,50000.00,NULL,'2022-11-28 18:03:28','2022-12-21 19:59:29','2022-12-21 19:59:29'),(604,7851,186,40719,13,19,483,2,50000.00,NULL,'2022-11-28 18:03:28','2022-12-21 19:59:29','2022-12-21 19:59:29'),(605,7851,187,40719,13,19,483,2,13019.38,NULL,'2022-11-28 18:04:26','2022-11-28 18:04:26',NULL),(606,7851,187,40719,13,19,484,1,13019.38,NULL,'2022-11-28 18:04:26','2022-11-28 18:04:26',NULL),(607,7851,188,40719,13,19,489,1,15000.00,NULL,'2022-11-28 18:27:04','2022-12-21 20:17:59','2022-12-21 20:17:59'),(608,7851,188,40719,13,19,484,2,15000.00,NULL,'2022-11-28 18:27:04','2022-12-21 20:17:59','2022-12-21 20:17:59'),(609,7851,189,40719,13,21,483,2,6000.00,NULL,'2022-11-28 18:37:57','2022-11-28 18:48:35','2022-11-28 18:48:35'),(610,7851,189,40719,13,21,135,1,6000.00,NULL,'2022-11-28 18:37:57','2022-11-28 18:48:35','2022-11-28 18:48:35'),(611,7851,190,40719,13,21,484,2,71.97,NULL,'2022-11-28 18:39:22','2022-11-28 18:51:35','2022-11-28 18:51:35'),(612,7851,190,40719,13,21,396,1,71.97,NULL,'2022-11-28 18:39:22','2022-11-28 18:51:35','2022-11-28 18:51:35'),(613,7851,191,40719,12,19,484,1,60000.00,NULL,'2022-11-28 18:42:51','2022-11-29 00:47:58','2022-11-29 00:47:58'),(614,7851,191,40719,12,19,483,2,60000.00,NULL,'2022-11-28 18:42:51','2022-11-29 00:47:58','2022-11-29 00:47:58'),(615,7851,192,40719,13,21,135,1,6000.00,NULL,'2022-11-28 18:48:35','2022-11-28 18:48:35',NULL),(616,7851,192,40719,13,21,484,2,6000.00,NULL,'2022-11-28 18:48:35','2022-11-28 18:48:35',NULL),(617,7851,193,40719,13,21,484,2,719.70,NULL,'2022-11-28 18:51:35','2022-12-06 19:05:14','2022-12-06 19:05:14'),(618,7851,193,40719,13,21,396,1,719.70,NULL,'2022-11-28 18:51:35','2022-12-06 19:05:14','2022-12-06 19:05:14'),(619,7851,194,40719,13,21,57,1,18800.00,NULL,'2022-11-28 18:54:26','2023-01-05 18:52:27','2023-01-05 18:52:27'),(620,7851,194,40719,13,21,483,2,3800.00,NULL,'2022-11-28 18:54:26','2023-01-05 18:52:27','2023-01-05 18:52:27'),(621,7851,194,40719,13,21,484,2,15000.00,NULL,'2022-11-28 18:54:26','2023-01-05 18:52:27','2023-01-05 18:52:27'),(622,7851,195,40719,13,21,57,1,17370.88,NULL,'2022-11-28 19:00:50','2023-01-05 14:23:09','2023-01-05 14:23:09'),(623,7851,195,40719,13,21,484,2,17370.88,NULL,'2022-11-28 19:00:50','2023-01-05 14:23:09','2023-01-05 14:23:09');
INSERT INTO `balance_libro_details` VALUES (624,7851,196,40719,13,21,57,1,12701.10,NULL,'2022-11-28 19:01:45','2023-01-05 17:50:49','2023-01-05 17:50:49'),(625,7851,196,40719,13,21,484,2,12701.10,NULL,'2022-11-28 19:01:45','2023-01-05 17:50:49','2023-01-05 17:50:49'),(626,7851,197,40719,13,21,57,1,15500.00,NULL,'2022-11-28 19:02:58','2023-01-05 14:52:17','2023-01-05 14:52:17'),(627,7851,197,40719,13,21,484,2,15500.00,NULL,'2022-11-28 19:02:58','2023-01-05 14:52:17','2023-01-05 14:52:17'),(628,7851,198,40719,13,21,57,1,4999.99,NULL,'2022-11-28 19:06:19','2023-01-05 17:57:24','2023-01-05 17:57:24'),(629,7851,198,40719,13,21,488,2,4999.99,NULL,'2022-11-28 19:06:19','2023-01-05 17:57:24','2023-01-05 17:57:24'),(630,7851,199,40719,13,19,482,2,100000.00,NULL,'2022-11-28 19:16:12','2022-11-28 19:16:12',NULL),(631,7851,199,40719,13,19,483,1,100000.00,NULL,'2022-11-28 19:16:12','2022-11-28 19:16:12',NULL),(632,7851,200,40719,13,19,483,1,200000.00,NULL,'2022-11-28 19:20:14','2022-11-28 19:20:14',NULL),(633,7851,200,40719,13,19,482,2,200000.00,NULL,'2022-11-28 19:20:14','2022-11-28 19:20:14',NULL),(634,7851,201,40719,13,19,483,1,90000.00,NULL,'2022-11-28 19:21:15','2022-11-28 19:21:15',NULL),(635,7851,201,40719,13,19,163,2,90000.00,NULL,'2022-11-28 19:21:15','2022-11-28 19:21:15',NULL),(636,7851,202,40719,13,19,482,2,200000.00,NULL,'2022-11-28 22:37:20','2022-11-28 23:11:08','2022-11-28 23:11:08'),(637,7851,202,40719,13,19,163,1,200000.00,NULL,'2022-11-28 22:37:20','2022-11-28 23:11:08','2022-11-28 23:11:08'),(638,7851,203,40719,13,19,486,2,212328.77,NULL,'2022-11-28 22:39:23','2022-11-28 22:49:50','2022-11-28 22:49:50'),(639,7851,203,40719,13,19,163,1,212328.77,NULL,'2022-11-28 22:39:23','2022-11-28 22:49:50','2022-11-28 22:49:50'),(640,7851,204,40719,13,21,489,1,7077.99,NULL,'2022-11-28 22:41:04','2022-11-28 22:49:55','2022-11-28 22:49:55'),(641,7851,204,40719,13,21,163,2,7077.99,NULL,'2022-11-28 22:41:04','2022-11-28 22:49:55','2022-11-28 22:49:55'),(642,7851,205,40719,13,19,486,1,206124.67,NULL,'2022-11-28 22:41:46','2022-11-28 22:49:30','2022-11-28 22:49:30'),(643,7851,205,40719,13,19,163,2,206124.67,NULL,'2022-11-28 22:41:46','2022-11-28 22:49:30','2022-11-28 22:49:30'),(644,7851,206,40719,12,19,163,2,200000.00,NULL,'2022-11-28 22:51:50','2022-11-28 22:51:50',NULL),(645,7851,206,40719,12,19,486,1,200000.00,NULL,'2022-11-28 22:51:50','2022-11-28 22:51:50',NULL),(646,7851,207,40719,13,2,490,2,12328.77,NULL,'2022-11-28 23:00:39','2022-11-28 23:00:39',NULL),(647,7851,207,40719,13,2,486,2,200000.00,NULL,'2022-11-28 23:00:39','2022-11-28 23:00:39',NULL),(648,7851,207,40719,13,2,163,1,212328.77,NULL,'2022-11-28 23:00:39','2022-11-28 23:00:39',NULL),(649,7851,208,40719,13,21,489,1,7007.99,NULL,'2022-11-28 23:02:19','2022-12-06 22:13:36','2022-12-06 22:13:36'),(650,7851,208,40719,13,21,163,2,7007.99,NULL,'2022-11-28 23:02:19','2022-12-06 22:13:36','2022-12-06 22:13:36'),(651,7851,209,40719,13,19,486,1,206124.67,NULL,'2022-11-28 23:03:28','2022-11-28 23:03:28',NULL),(652,7851,209,40719,13,19,163,2,206124.67,NULL,'2022-11-28 23:03:28','2022-11-28 23:03:28',NULL),(653,7851,210,40719,13,19,482,2,200000.00,NULL,'2022-11-28 23:11:08','2022-11-28 23:11:15','2022-11-28 23:11:15'),(654,7851,210,40719,13,19,163,1,200000.00,NULL,'2022-11-28 23:11:08','2022-11-28 23:11:15','2022-11-28 23:11:15'),(655,7851,211,40719,13,19,482,2,200000.00,NULL,'2022-11-28 23:11:15','2022-11-28 23:11:15',NULL),(656,7851,211,40719,13,19,163,1,200000.00,NULL,'2022-11-28 23:11:15','2022-11-28 23:11:15',NULL),(657,7851,212,40719,12,19,163,1,150000.00,NULL,'2022-11-28 23:13:36','2022-11-28 23:13:36',NULL),(658,7851,212,40719,12,19,482,2,150000.00,NULL,'2022-11-28 23:13:36','2022-11-28 23:13:36',NULL),(659,7851,213,40719,12,19,163,1,68000.00,NULL,'2022-11-28 23:14:15','2022-11-28 23:14:15',NULL),(660,7851,213,40719,12,19,482,2,68000.00,NULL,'2022-11-28 23:14:15','2022-11-28 23:14:15',NULL),(661,7851,214,40719,12,19,163,1,69000.00,NULL,'2022-11-28 23:14:51','2022-11-28 23:14:51',NULL);
INSERT INTO `balance_libro_details` VALUES (662,7851,214,40719,12,19,482,2,69000.00,NULL,'2022-11-28 23:14:51','2022-11-28 23:14:51',NULL),(663,7851,215,40719,12,19,163,1,10000.00,NULL,'2022-11-28 23:22:42','2022-11-28 23:22:42',NULL),(664,7851,215,40719,12,19,482,2,10000.00,NULL,'2022-11-28 23:22:42','2022-11-28 23:22:42',NULL),(665,7851,216,40719,12,21,62,1,29880.00,NULL,'2022-11-28 23:26:40','2022-12-02 10:49:51','2022-12-02 10:49:51'),(666,7851,216,40719,12,21,163,2,29880.00,NULL,'2022-11-28 23:26:40','2022-12-02 10:49:51','2022-12-02 10:49:51'),(667,7851,217,40719,12,21,491,1,50120.00,NULL,'2022-11-28 23:29:43','2022-11-29 23:24:44','2022-11-29 23:24:44'),(668,7851,217,40719,12,21,163,2,50120.00,NULL,'2022-11-28 23:29:43','2022-11-29 23:24:44','2022-11-29 23:24:44'),(669,7851,218,40719,12,19,163,1,80000.00,NULL,'2022-11-28 23:32:50','2022-11-28 23:32:50',NULL),(670,7851,218,40719,12,19,483,2,80000.00,NULL,'2022-11-28 23:32:50','2022-11-28 23:32:50',NULL),(671,7851,219,40719,12,21,492,1,6818.00,NULL,'2022-11-28 23:36:16','2022-11-28 23:36:16',NULL),(672,7851,219,40719,12,21,163,2,6818.00,NULL,'2022-11-28 23:36:16','2022-11-28 23:36:16',NULL),(673,7851,220,40719,13,19,163,1,61000.00,NULL,'2022-11-28 23:38:17','2022-11-28 23:38:17',NULL),(674,7851,220,40719,13,19,482,2,61000.00,NULL,'2022-11-28 23:38:17','2022-11-28 23:38:17',NULL),(675,7851,221,40719,13,21,163,2,46783.24,NULL,'2022-11-28 23:42:56','2022-11-28 23:42:56',NULL),(676,7851,221,40719,13,21,493,1,46783.24,NULL,'2022-11-28 23:42:56','2022-11-28 23:42:56',NULL),(677,7851,222,40719,13,21,163,2,13343.41,NULL,'2022-11-28 23:43:32','2022-11-28 23:43:32',NULL),(678,7851,222,40719,13,21,494,1,13343.41,NULL,'2022-11-28 23:43:32','2022-11-28 23:43:32',NULL),(679,7851,223,40719,12,19,484,1,60000.00,NULL,'2022-11-29 00:47:58','2022-11-29 00:47:58',NULL),(680,7851,223,40719,12,19,482,2,60000.00,NULL,'2022-11-29 00:47:58','2022-11-29 00:47:58',NULL),(681,7851,224,40719,13,21,483,2,3082.17,NULL,'2022-11-29 10:17:04','2023-02-03 23:49:46','2023-02-03 23:49:46'),(682,7851,224,40719,13,21,135,1,3082.17,NULL,'2022-11-29 10:17:04','2023-02-03 23:49:46','2023-02-03 23:49:46'),(683,7851,225,40719,13,19,483,1,846.56,NULL,'2022-11-29 10:22:55','2023-02-03 23:54:03','2023-02-03 23:54:03'),(684,7851,225,40719,13,19,99,2,846.56,NULL,'2022-11-29 10:22:55','2023-02-03 23:54:03','2023-02-03 23:54:03'),(685,7851,226,40719,11,12,482,1,64476.54,NULL,'2022-11-29 10:45:46','2022-11-29 10:47:09','2022-11-29 10:47:09'),(686,7851,226,40719,11,12,96,2,64476.54,NULL,'2022-11-29 10:45:46','2022-11-29 10:47:09','2022-11-29 10:47:09'),(687,7851,227,40719,12,12,482,1,74069.77,NULL,'2022-11-29 10:47:09','2022-11-30 18:32:43','2022-11-30 18:32:43'),(688,7851,227,40719,12,12,96,2,74069.77,NULL,'2022-11-29 10:47:09','2022-11-30 18:32:43','2022-11-30 18:32:43'),(689,7851,228,40719,12,21,62,1,24000.00,NULL,'2022-11-29 10:58:56','2022-12-02 10:57:05','2022-12-02 10:57:05'),(690,7851,228,40719,12,21,482,2,24000.00,NULL,'2022-11-29 10:58:56','2022-12-02 10:57:05','2022-12-02 10:57:05'),(691,7851,229,40719,12,21,491,1,16000.00,NULL,'2022-11-29 11:05:37','2022-11-29 16:32:29','2022-11-29 16:32:29'),(692,7851,229,40719,12,21,482,2,16000.00,NULL,'2022-11-29 11:05:37','2022-11-29 16:32:29','2022-11-29 16:32:29'),(693,7851,230,40719,12,3,217,1,867.77,NULL,'2022-11-29 11:14:55','2022-12-21 14:55:11','2022-12-21 14:55:11'),(694,7851,230,40719,12,3,68,1,182.23,NULL,'2022-11-29 11:14:55','2022-12-21 14:55:11','2022-12-21 14:55:11'),(695,7851,230,40719,12,3,57,2,1050.00,NULL,'2022-11-29 11:14:55','2022-12-21 14:55:11','2022-12-21 14:55:11'),(696,7851,231,40719,12,21,491,1,16000.00,NULL,'2022-11-29 16:32:29','2022-11-29 23:32:41','2022-11-29 23:32:41'),(697,7851,231,40719,12,21,482,2,16000.00,NULL,'2022-11-29 16:32:29','2022-11-29 23:32:41','2022-11-29 23:32:41'),(698,7851,232,40719,13,3,497,1,130000.00,NULL,'2022-11-29 16:37:34','2022-11-29 16:37:34',NULL),(699,7851,232,40719,13,3,482,2,130000.00,NULL,'2022-11-29 16:37:34','2022-11-29 16:37:34',NULL);
INSERT INTO `balance_libro_details` VALUES (700,7851,233,40719,13,19,487,1,80000.00,NULL,'2022-11-29 19:30:18','2022-11-29 19:30:18',NULL),(701,7851,233,40719,13,19,482,2,80000.00,NULL,'2022-11-29 19:30:18','2022-11-29 19:30:18',NULL),(702,7851,234,40719,12,3,497,1,235000.00,NULL,'2022-11-29 19:53:54','2022-11-29 22:38:20','2022-11-29 22:38:20'),(703,7851,234,40719,12,3,482,2,235000.00,NULL,'2022-11-29 19:53:54','2022-11-29 22:38:20','2022-11-29 22:38:20'),(704,7851,235,40719,12,3,485,1,300000.00,NULL,'2022-11-29 19:55:27','2022-11-29 19:55:27',NULL),(705,7851,235,40719,12,3,482,2,300000.00,NULL,'2022-11-29 19:55:27','2022-11-29 19:55:27',NULL),(706,7851,236,40719,13,3,485,1,300000.00,NULL,'2022-11-29 19:56:54','2022-11-30 14:48:03','2022-11-30 14:48:03'),(707,7851,236,40719,13,3,482,2,300000.00,NULL,'2022-11-29 19:56:54','2022-11-30 14:48:03','2022-11-30 14:48:03'),(708,7851,237,40719,13,3,495,1,83697.10,NULL,'2022-11-29 19:58:54','2022-11-29 19:58:54',NULL),(709,7851,237,40719,13,3,482,2,83697.10,NULL,'2022-11-29 19:58:54','2022-11-29 19:58:54',NULL),(710,7851,238,40719,12,3,495,1,112966.76,NULL,'2022-11-29 20:00:18','2022-11-29 22:38:48','2022-11-29 22:38:48'),(711,7851,238,40719,12,3,482,2,112966.76,NULL,'2022-11-29 20:00:18','2022-11-29 22:38:48','2022-11-29 22:38:48'),(712,7851,239,40719,13,21,57,1,6201.06,NULL,'2022-11-29 20:08:53','2023-01-05 18:03:12','2023-01-05 18:03:12'),(713,7851,239,40719,13,21,482,2,6201.06,NULL,'2022-11-29 20:08:53','2023-01-05 18:03:12','2023-01-05 18:03:12'),(714,7851,240,40719,13,21,57,1,13142.34,NULL,'2022-11-29 20:10:26','2022-12-03 19:57:07','2022-12-03 19:57:07'),(715,7851,240,40719,13,21,482,2,13142.34,NULL,'2022-11-29 20:10:26','2022-12-03 19:57:07','2022-12-03 19:57:07'),(716,7851,241,40719,13,21,57,1,7302.76,NULL,'2022-11-29 20:12:34','2023-01-05 18:10:59','2023-01-05 18:10:59'),(717,7851,241,40719,13,21,482,2,7302.76,NULL,'2022-11-29 20:12:34','2023-01-05 18:10:59','2023-01-05 18:10:59'),(718,7851,242,40719,13,21,57,1,10400.26,NULL,'2022-11-29 20:13:14','2023-01-05 14:30:22','2023-01-05 14:30:22'),(719,7851,242,40719,13,21,482,2,10400.26,NULL,'2022-11-29 20:13:14','2023-01-05 14:30:22','2023-01-05 14:30:22'),(720,7851,243,40719,13,3,482,2,4000.00,NULL,'2022-11-29 20:22:35','2022-11-29 22:10:12','2022-11-29 22:10:12'),(721,7851,243,40719,13,3,503,1,4000.00,NULL,'2022-11-29 20:22:35','2022-11-29 22:10:12','2022-11-29 22:10:12'),(722,7851,244,40719,13,21,482,2,3000.00,NULL,'2022-11-29 20:25:08','2022-11-29 20:25:08',NULL),(723,7851,244,40719,13,21,489,1,3000.00,NULL,'2022-11-29 20:25:08','2022-11-29 20:25:08',NULL),(724,7851,245,40719,13,21,482,2,5000.00,NULL,'2022-11-29 20:26:10','2022-11-29 20:26:10',NULL),(725,7851,245,40719,13,21,501,1,5000.00,NULL,'2022-11-29 20:26:10','2022-11-29 20:26:10',NULL),(726,7851,246,40719,13,21,482,2,45190.00,NULL,'2022-11-29 20:27:58','2022-11-29 20:27:58',NULL),(727,7851,246,40719,13,21,492,1,45190.00,NULL,'2022-11-29 20:27:58','2022-11-29 20:27:58',NULL),(728,7851,247,40719,13,21,482,2,81267.58,NULL,'2022-11-29 20:30:10','2022-11-30 15:09:00','2022-11-30 15:09:00'),(729,7851,247,40719,13,21,495,1,81267.58,NULL,'2022-11-29 20:30:10','2022-11-30 15:09:00','2022-11-30 15:09:00'),(730,7851,248,40719,13,21,482,2,2429.52,NULL,'2022-11-29 20:32:17','2022-11-30 15:08:01','2022-11-30 15:08:01'),(731,7851,248,40719,13,21,495,1,2429.52,NULL,'2022-11-29 20:32:17','2022-11-30 15:08:01','2022-11-30 15:08:01'),(732,7851,249,40719,13,21,498,1,2921.10,NULL,'2022-11-29 20:33:00','2022-11-29 20:35:07','2022-11-29 20:35:07'),(733,7851,249,40719,13,21,482,2,2921.10,NULL,'2022-11-29 20:33:00','2022-11-29 20:35:07','2022-11-29 20:35:07'),(734,7851,250,40719,13,21,482,2,1359.15,NULL,'2022-11-29 20:34:11','2022-11-29 20:34:11',NULL),(735,7851,250,40719,13,21,135,1,1359.15,NULL,'2022-11-29 20:34:11','2022-11-29 20:34:11',NULL),(736,7851,251,40719,13,21,498,1,5857.60,NULL,'2022-11-29 20:35:07','2022-11-29 20:35:07',NULL),(737,7851,251,40719,13,21,482,2,5857.60,NULL,'2022-11-29 20:35:07','2022-11-29 20:35:07',NULL);
INSERT INTO `balance_libro_details` VALUES (738,7851,252,40719,13,2,99,2,500.48,NULL,'2022-11-29 20:39:23','2022-11-29 20:39:23',NULL),(739,7851,252,40719,13,2,482,1,500.48,NULL,'2022-11-29 20:39:23','2022-11-29 20:39:23',NULL),(740,7851,253,40719,13,2,487,2,104214.71,NULL,'2022-11-29 20:42:27','2022-11-29 23:10:29','2022-11-29 23:10:29'),(741,7851,253,40719,13,2,482,1,104214.71,NULL,'2022-11-29 20:42:27','2022-11-29 23:10:29','2022-11-29 23:10:29'),(742,7851,254,40719,13,21,505,1,10254.03,NULL,'2022-11-29 20:48:26','2022-11-29 20:48:26',NULL),(743,7851,254,40719,13,21,482,2,10254.03,NULL,'2022-11-29 20:48:26','2022-11-29 20:48:26',NULL),(744,7851,255,40719,13,2,504,2,15885.00,NULL,'2022-11-29 20:55:10','2022-11-29 20:55:10',NULL),(745,7851,255,40719,13,2,482,1,15885.00,NULL,'2022-11-29 20:55:10','2022-11-29 20:55:10',NULL),(746,7851,256,40719,13,21,396,1,1050.00,NULL,'2022-11-29 20:57:45','2022-11-29 20:57:45',NULL),(747,7851,256,40719,13,21,482,2,1050.00,NULL,'2022-11-29 20:57:45','2022-11-29 20:57:45',NULL),(748,7851,257,40719,13,3,495,1,1856.72,NULL,'2022-11-29 21:29:27','2022-11-29 21:29:57','2022-11-29 21:29:57'),(749,7851,257,40719,13,3,506,2,1856.72,NULL,'2022-11-29 21:29:27','2022-11-29 21:29:57','2022-11-29 21:29:57'),(750,7851,258,40719,13,3,495,1,1856.72,NULL,'2022-11-29 21:29:57','2023-01-04 23:47:55','2023-01-04 23:47:55'),(751,7851,258,40719,13,3,506,2,1856.72,NULL,'2022-11-29 21:29:57','2023-01-04 23:47:55','2023-01-04 23:47:55'),(752,7851,259,40719,13,21,482,2,1856.72,NULL,'2022-11-29 21:31:26','2023-01-04 23:48:26','2023-01-04 23:48:26'),(753,7851,259,40719,13,21,506,1,1856.72,NULL,'2022-11-29 21:31:26','2023-01-04 23:48:26','2023-01-04 23:48:26'),(754,7851,260,40719,13,3,495,1,899.96,NULL,'2022-11-29 21:35:18','2023-01-04 23:19:09','2023-01-04 23:19:09'),(755,7851,260,40719,13,3,507,2,899.96,NULL,'2022-11-29 21:35:18','2023-01-04 23:19:09','2023-01-04 23:19:09'),(756,7851,261,40719,13,21,482,2,899.96,NULL,'2022-11-29 21:36:10','2023-01-04 23:17:50','2023-01-04 23:17:50'),(757,7851,261,40719,13,21,507,1,899.96,NULL,'2022-11-29 21:36:10','2023-01-04 23:17:50','2023-01-04 23:17:50'),(758,7851,262,40719,13,21,63,1,18801.15,NULL,'2022-11-29 21:38:12','2023-02-01 01:26:16','2023-02-01 01:26:16'),(759,7851,262,40719,13,21,482,2,18801.15,NULL,'2022-11-29 21:38:12','2023-02-01 01:26:16','2023-02-01 01:26:16'),(760,7851,263,40719,13,10,68,1,53966.06,NULL,'2022-11-29 21:42:28','2023-02-01 00:33:43','2023-02-01 00:33:43'),(761,7851,263,40719,13,10,482,2,53966.06,NULL,'2022-11-29 21:42:28','2023-02-01 00:33:43','2023-02-01 00:33:43'),(762,7851,264,40719,13,2,96,1,277753.85,NULL,'2022-11-29 21:53:08','2022-11-29 21:53:08',NULL),(763,7851,264,40719,13,2,68,1,29164.15,NULL,'2022-11-29 21:53:08','2022-11-29 21:53:08',NULL),(764,7851,264,40719,13,2,13,2,306918.00,NULL,'2022-11-29 21:53:08','2022-11-29 21:53:08',NULL),(765,7851,265,40719,13,2,96,2,277753.85,NULL,'2022-11-29 21:53:20','2022-11-29 21:53:20',NULL),(766,7851,265,40719,13,2,67,2,29164.15,NULL,'2022-11-29 21:53:20','2022-11-29 21:53:20',NULL),(767,7851,265,40719,13,2,13,1,306918.00,NULL,'2022-11-29 21:53:20','2022-11-29 21:53:20',NULL),(768,7851,266,40719,13,3,482,2,4000.00,NULL,'2022-11-29 22:10:12','2022-11-29 22:10:12',NULL),(769,7851,266,40719,13,3,503,1,4000.00,NULL,'2022-11-29 22:10:12','2022-11-29 22:10:12',NULL),(770,7851,267,40719,13,1,500,2,90446.52,NULL,'2022-11-29 22:19:48','2023-01-31 02:57:38','2023-01-31 02:57:38'),(771,7851,267,40719,13,1,482,1,90446.52,NULL,'2022-11-29 22:19:48','2023-01-31 02:57:38','2023-01-31 02:57:38'),(772,7851,268,40719,13,21,135,1,1290.08,NULL,'2022-11-29 22:22:21','2022-11-29 22:22:21',NULL),(773,7851,268,40719,13,21,482,2,1290.08,NULL,'2022-11-29 22:22:21','2022-11-29 22:22:21',NULL),(774,7851,269,40719,12,3,497,1,235000.00,NULL,'2022-11-29 22:38:20','2022-11-29 22:38:20',NULL),(775,7851,269,40719,12,3,482,2,235000.00,NULL,'2022-11-29 22:38:20','2022-11-29 22:38:20',NULL),(776,7851,270,40719,12,3,495,1,112966.76,NULL,'2022-11-29 22:38:48','2022-11-29 22:38:48',NULL);
INSERT INTO `balance_libro_details` VALUES (777,7851,270,40719,12,3,482,2,112966.76,NULL,'2022-11-29 22:38:48','2022-11-29 22:38:48',NULL),(778,7851,271,40719,12,21,489,1,14330.00,NULL,'2022-11-29 22:45:23','2022-11-29 22:45:23',NULL),(779,7851,271,40719,12,21,482,2,14330.00,NULL,'2022-11-29 22:45:23','2022-11-29 22:45:23',NULL),(780,7851,272,40719,12,21,482,2,88000.00,NULL,'2022-11-29 22:56:55','2022-11-29 22:56:55',NULL),(781,7851,272,40719,12,21,495,1,88000.00,NULL,'2022-11-29 22:56:55','2022-11-29 22:56:55',NULL),(782,7851,273,40719,12,21,492,1,66095.25,NULL,'2022-11-29 22:58:15','2022-11-29 22:58:15',NULL),(783,7851,273,40719,12,21,482,2,66095.25,NULL,'2022-11-29 22:58:15','2022-11-29 22:58:15',NULL),(784,7851,274,40719,12,19,508,1,19000.00,NULL,'2022-11-29 23:03:36','2022-11-30 19:42:11','2022-11-30 19:42:11'),(785,7851,274,40719,12,19,475,2,19000.00,NULL,'2022-11-29 23:03:36','2022-11-30 19:42:11','2022-11-30 19:42:11'),(786,7851,275,40719,12,1,500,2,90442.66,NULL,'2022-11-29 23:05:56','2023-01-31 23:08:31','2023-01-31 23:08:31'),(787,7851,275,40719,12,1,482,1,90442.66,NULL,'2022-11-29 23:05:56','2023-01-31 23:08:31','2023-01-31 23:08:31'),(788,7851,276,40719,12,19,487,1,100000.00,NULL,'2022-11-29 23:07:26','2022-11-29 23:07:26',NULL),(789,7851,276,40719,12,19,482,2,100000.00,NULL,'2022-11-29 23:07:26','2022-11-29 23:07:26',NULL),(790,7851,277,40719,13,2,482,1,4214.71,NULL,'2022-11-29 23:10:29','2022-11-29 23:10:29',NULL),(791,7851,277,40719,13,2,509,2,4214.71,NULL,'2022-11-29 23:10:29','2022-11-29 23:10:29',NULL),(792,7851,278,40719,13,19,482,1,100000.00,NULL,'2022-11-29 23:11:13','2022-11-29 23:11:13',NULL),(793,7851,278,40719,13,19,487,2,100000.00,NULL,'2022-11-29 23:11:13','2022-11-29 23:11:13',NULL),(794,7851,279,40719,12,19,510,1,100000.00,NULL,'2022-11-29 23:13:01','2022-11-29 23:13:01',NULL),(795,7851,279,40719,12,19,482,2,100000.00,NULL,'2022-11-29 23:13:01','2022-11-29 23:13:01',NULL),(796,7851,280,40719,12,2,511,2,10.64,NULL,'2022-11-29 23:15:14','2022-11-29 23:15:14',NULL),(797,7851,280,40719,12,2,482,1,10.64,NULL,'2022-11-29 23:15:14','2022-11-29 23:15:14',NULL),(798,7851,281,40719,12,21,505,1,10254.03,NULL,'2022-11-29 23:17:07','2022-11-29 23:17:07',NULL),(799,7851,281,40719,12,21,482,2,10254.03,NULL,'2022-11-29 23:17:07','2022-11-29 23:17:07',NULL),(800,7851,282,40719,12,1,491,2,30000.00,NULL,'2022-11-29 23:23:38','2022-11-29 23:32:23','2022-11-29 23:32:23'),(801,7851,282,40719,12,1,135,1,30000.00,NULL,'2022-11-29 23:23:38','2022-11-29 23:32:23','2022-11-29 23:32:23'),(802,7851,283,40719,13,21,491,1,50120.00,NULL,'2022-11-29 23:24:44','2022-12-02 10:59:45','2022-12-02 10:59:45'),(803,7851,283,40719,13,21,163,2,50120.00,NULL,'2022-11-29 23:24:44','2022-12-02 10:59:45','2022-12-02 10:59:45'),(804,7851,284,40719,12,21,198,1,855.00,NULL,'2022-11-29 23:31:18','2022-11-29 23:31:18',NULL),(805,7851,284,40719,12,21,482,2,855.00,NULL,'2022-11-29 23:31:18','2022-11-29 23:31:18',NULL),(806,7851,285,40719,12,1,491,2,30000.00,NULL,'2022-11-29 23:32:23','2022-11-29 23:33:04','2022-11-29 23:33:04'),(807,7851,285,40719,12,1,135,1,30000.00,NULL,'2022-11-29 23:32:23','2022-11-29 23:33:04','2022-11-29 23:33:04'),(808,7851,286,40719,12,21,491,1,16000.00,NULL,'2022-11-29 23:32:41','2022-11-29 23:32:41',NULL),(809,7851,286,40719,12,21,482,2,16000.00,NULL,'2022-11-29 23:32:41','2022-11-29 23:32:41',NULL),(810,7851,287,40719,12,21,491,2,30000.00,NULL,'2022-11-29 23:33:04','2022-11-29 23:40:56','2022-11-29 23:40:56'),(811,7851,287,40719,12,21,135,1,30000.00,NULL,'2022-11-29 23:33:04','2022-11-29 23:40:56','2022-11-29 23:40:56'),(812,7851,288,40719,12,3,512,1,16000.00,NULL,'2022-11-29 23:34:58','2022-11-29 23:35:26','2022-11-29 23:35:26'),(813,7851,288,40719,12,3,62,2,16000.00,NULL,'2022-11-29 23:34:58','2022-11-29 23:35:26','2022-11-29 23:35:26'),(814,7851,289,40719,12,3,512,1,16000.00,NULL,'2022-11-29 23:35:26','2022-12-02 11:13:12','2022-12-02 11:13:12'),(815,7851,289,40719,12,3,491,2,16000.00,NULL,'2022-11-29 23:35:26','2022-12-02 11:13:12','2022-12-02 11:13:12');
INSERT INTO `balance_libro_details` VALUES (816,7851,290,40719,12,3,491,2,30000.00,NULL,'2022-11-29 23:36:51','2022-11-29 23:37:02','2022-11-29 23:37:02'),(817,7851,290,40719,12,3,512,1,30000.00,NULL,'2022-11-29 23:36:51','2022-11-29 23:37:02','2022-11-29 23:37:02'),(818,7851,291,40719,12,3,491,2,30000.00,NULL,'2022-11-29 23:37:02','2022-12-02 11:12:04','2022-12-02 11:12:04'),(819,7851,291,40719,12,3,512,1,30000.00,NULL,'2022-11-29 23:37:02','2022-12-02 11:12:04','2022-12-02 11:12:04'),(820,7851,292,40719,13,3,491,2,50120.00,NULL,'2022-11-29 23:38:19','2022-12-02 10:59:22','2022-12-02 10:59:22'),(821,7851,292,40719,13,3,512,1,50120.00,NULL,'2022-11-29 23:38:19','2022-12-02 10:59:22','2022-12-02 10:59:22'),(822,7851,293,40719,12,21,482,2,30000.00,NULL,'2022-11-29 23:40:56','2022-12-02 10:58:30','2022-12-02 10:58:30'),(823,7851,293,40719,12,21,491,1,30000.00,NULL,'2022-11-29 23:40:56','2022-12-02 10:58:30','2022-12-02 10:58:30'),(824,7851,294,40719,12,21,498,1,7279.47,NULL,'2022-11-29 23:42:34','2022-11-29 23:42:51','2022-11-29 23:42:51'),(825,7851,294,40719,12,21,482,2,7279.47,NULL,'2022-11-29 23:42:34','2022-11-29 23:42:51','2022-11-29 23:42:51'),(826,7851,295,40719,12,21,498,1,7279.47,NULL,'2022-11-29 23:42:51','2022-11-29 23:42:51',NULL),(827,7851,295,40719,12,21,482,2,7279.47,NULL,'2022-11-29 23:42:51','2022-11-29 23:42:51',NULL),(828,7851,296,40719,12,10,68,1,15226.95,NULL,'2022-11-29 23:43:59','2022-11-29 23:44:36','2022-11-29 23:44:36'),(829,7851,296,40719,12,10,482,2,15226.95,NULL,'2022-11-29 23:43:59','2022-11-29 23:44:36','2022-11-29 23:44:36'),(830,7851,297,40719,12,10,68,1,15226.95,NULL,'2022-11-29 23:44:36','2023-02-01 00:33:00','2023-02-01 00:33:00'),(831,7851,297,40719,12,10,482,2,15226.95,NULL,'2022-11-29 23:44:36','2023-02-01 00:33:00','2023-02-01 00:33:00'),(832,7851,298,40719,11,20,13,2,722995.00,NULL,'2022-11-30 09:49:55','2022-11-30 09:49:55',NULL),(833,7851,298,40719,11,20,482,1,694760.30,NULL,'2022-11-30 09:49:55','2022-11-30 09:49:55',NULL),(834,7851,298,40719,11,20,23,1,8605.88,NULL,'2022-11-30 09:49:55','2022-11-30 09:49:55',NULL),(835,7851,298,40719,11,20,263,1,19628.82,NULL,'2022-11-30 09:49:55','2022-11-30 09:49:55',NULL),(836,7851,299,40719,12,21,57,1,238000.01,NULL,'2022-11-30 10:01:59','2022-11-30 10:01:59',NULL),(837,7851,299,40719,12,21,482,2,238000.01,NULL,'2022-11-30 10:01:59','2022-11-30 10:01:59',NULL),(838,7851,300,40719,13,21,57,1,4976.00,NULL,'2022-11-30 12:30:37','2022-11-30 12:31:37','2022-11-30 12:31:37'),(839,7851,300,40719,13,21,482,2,4976.00,NULL,'2022-11-30 12:30:37','2022-11-30 12:31:37','2022-11-30 12:31:37'),(840,7851,301,40719,13,21,485,1,300000.00,NULL,'2022-11-30 14:48:03','2022-11-30 14:48:03',NULL),(841,7851,301,40719,13,21,482,2,300000.00,NULL,'2022-11-30 14:48:03','2022-11-30 14:48:03',NULL),(842,7851,302,40719,12,21,57,1,10308.08,NULL,'2022-11-30 15:29:07','2023-01-05 14:56:51','2023-01-05 14:56:51'),(843,7851,302,40719,12,21,482,2,10308.08,NULL,'2022-11-30 15:29:07','2023-01-05 14:56:51','2023-01-05 14:56:51'),(844,7851,303,40719,12,21,57,1,19999.99,NULL,'2022-11-30 16:52:43','2022-11-30 16:54:15','2022-11-30 16:54:15'),(845,7851,303,40719,12,21,163,2,19999.99,NULL,'2022-11-30 16:52:43','2022-11-30 16:54:15','2022-11-30 16:54:15'),(846,7851,304,40719,12,21,57,1,19999.99,NULL,'2022-11-30 16:55:10','2022-11-30 16:55:10',NULL),(847,7851,304,40719,12,21,482,2,19999.99,NULL,'2022-11-30 16:55:10','2022-11-30 16:55:10',NULL),(848,7851,305,40719,12,21,57,1,18503.01,NULL,'2022-11-30 16:56:54','2022-11-30 16:56:54',NULL),(849,7851,305,40719,12,21,482,2,18503.01,NULL,'2022-11-30 16:56:54','2022-11-30 16:56:54',NULL),(850,7851,306,40719,12,21,57,1,1604.46,NULL,'2022-11-30 17:03:08','2022-11-30 17:03:08',NULL),(851,7851,306,40719,12,21,482,2,1604.46,NULL,'2022-11-30 17:03:08','2022-11-30 17:03:08',NULL),(852,7851,307,40719,12,21,482,2,1859.94,NULL,'2022-11-30 18:04:14','2022-11-30 18:04:14',NULL),(853,7851,307,40719,12,21,212,1,1859.94,NULL,'2022-11-30 18:04:14','2022-11-30 18:04:14',NULL);
INSERT INTO `balance_libro_details` VALUES (854,7851,308,40719,12,21,214,1,900.15,NULL,'2022-11-30 18:06:17','2022-11-30 18:06:17',NULL),(855,7851,308,40719,12,21,482,2,900.15,NULL,'2022-11-30 18:06:17','2022-11-30 18:06:17',NULL),(856,7851,309,40719,12,21,482,2,1050.00,NULL,'2022-11-30 18:08:06','2022-11-30 18:08:06',NULL),(857,7851,309,40719,12,21,396,1,1050.00,NULL,'2022-11-30 18:08:06','2022-11-30 18:08:06',NULL),(858,7851,310,40719,12,2,99,2,501.28,NULL,'2022-11-30 18:09:46','2022-11-30 18:09:46',NULL),(859,7851,310,40719,12,2,482,1,501.28,NULL,'2022-11-30 18:09:46','2022-11-30 18:09:46',NULL),(860,7851,311,40719,12,2,504,2,16300.00,NULL,'2022-11-30 18:12:23','2022-11-30 18:12:23',NULL),(861,7851,311,40719,12,2,482,1,16300.00,NULL,'2022-11-30 18:12:23','2022-11-30 18:12:23',NULL),(862,7851,312,40719,13,3,217,1,1000.00,NULL,'2022-11-30 18:34:37','2022-11-30 18:35:44','2022-11-30 18:35:44'),(863,7851,312,40719,13,3,68,1,210.00,NULL,'2022-11-30 18:34:37','2022-11-30 18:35:44','2022-11-30 18:35:44'),(864,7851,312,40719,13,3,57,2,1210.00,NULL,'2022-11-30 18:34:37','2022-11-30 18:35:44','2022-11-30 18:35:44'),(865,7851,313,40719,13,3,5,1,1000.00,NULL,'2022-11-30 18:35:44','2022-11-30 18:36:13','2022-11-30 18:36:13'),(866,7851,313,40719,13,3,68,1,210.00,NULL,'2022-11-30 18:35:44','2022-11-30 18:36:13','2022-11-30 18:36:13'),(867,7851,313,40719,13,3,57,2,1210.00,NULL,'2022-11-30 18:35:44','2022-11-30 18:36:13','2022-11-30 18:36:13'),(868,7851,314,40719,12,21,57,1,1880.00,NULL,'2022-11-30 18:44:40','2022-11-30 18:44:40',NULL),(869,7851,314,40719,12,21,482,2,1880.00,NULL,'2022-11-30 18:44:40','2022-11-30 18:44:40',NULL),(870,7851,315,40719,12,21,482,2,4926.00,NULL,'2022-11-30 18:47:29','2022-11-30 18:47:42','2022-11-30 18:47:42'),(871,7851,315,40719,12,21,57,1,4926.00,NULL,'2022-11-30 18:47:29','2022-11-30 18:47:42','2022-11-30 18:47:42'),(872,7851,316,40719,12,21,482,2,4926.00,NULL,'2022-11-30 18:47:42','2022-11-30 18:47:42',NULL),(873,7851,316,40719,12,21,57,1,4926.00,NULL,'2022-11-30 18:47:42','2022-11-30 18:47:42',NULL),(874,7851,317,40719,12,21,57,1,100000.00,NULL,'2022-11-30 18:48:40','2022-11-30 18:49:45','2022-11-30 18:49:45'),(875,7851,317,40719,12,21,482,2,100000.00,NULL,'2022-11-30 18:48:40','2022-11-30 18:49:45','2022-11-30 18:49:45'),(876,7851,318,40719,12,21,508,1,19000.00,NULL,'2022-11-30 19:14:43','2022-11-30 19:14:43',NULL),(877,7851,318,40719,12,21,482,2,19000.00,NULL,'2022-11-30 19:14:43','2022-11-30 19:14:43',NULL),(878,7851,319,40719,13,21,489,1,88950.24,NULL,'2022-11-30 19:33:28','2022-12-03 17:10:37','2022-12-03 17:10:37'),(879,7851,319,40719,13,21,482,2,88950.24,NULL,'2022-11-30 19:33:28','2022-12-03 17:10:37','2022-12-03 17:10:37'),(880,7851,320,40719,13,21,57,1,1880.00,NULL,'2022-11-30 19:35:02','2022-11-30 19:35:02',NULL),(881,7851,320,40719,13,21,482,2,1880.00,NULL,'2022-11-30 19:35:02','2022-11-30 19:35:02',NULL),(882,7851,321,40719,13,21,482,2,4926.00,NULL,'2022-11-30 19:35:50','2022-11-30 19:35:50',NULL),(883,7851,321,40719,13,21,57,1,4926.00,NULL,'2022-11-30 19:35:50','2022-11-30 19:35:50',NULL),(884,7851,322,40719,14,3,217,1,6429.70,NULL,'2022-12-01 11:17:51','2022-12-06 16:14:00','2022-12-06 16:14:00'),(885,7851,322,40719,14,3,68,1,1350.24,NULL,'2022-12-01 11:17:51','2022-12-06 16:14:00','2022-12-06 16:14:00'),(886,7851,322,40719,14,3,217,1,0.06,NULL,'2022-12-01 11:17:51','2022-12-06 16:14:00','2022-12-06 16:14:00'),(887,7851,322,40719,14,3,57,2,7780.00,NULL,'2022-12-01 11:17:51','2022-12-06 16:14:00','2022-12-06 16:14:00'),(888,7851,323,40719,14,21,482,2,5000.00,NULL,'2022-12-01 15:40:29','2022-12-01 15:40:29',NULL),(889,7851,323,40719,14,21,489,1,5000.00,NULL,'2022-12-01 15:40:29','2022-12-01 15:40:29',NULL),(890,7851,324,40719,14,19,482,2,28500.00,NULL,'2022-12-01 15:55:49','2022-12-01 15:55:49',NULL),(891,7851,324,40719,14,19,516,1,28500.00,NULL,'2022-12-01 15:55:49','2022-12-01 15:55:49',NULL),(892,7851,325,40719,14,19,487,2,80000.00,NULL,'2022-12-01 15:56:59','2022-12-01 15:56:59',NULL);
INSERT INTO `balance_libro_details` VALUES (893,7851,325,40719,14,19,482,1,80000.00,NULL,'2022-12-01 15:56:59','2022-12-01 15:56:59',NULL),(894,7851,326,40719,14,2,509,2,2146.60,NULL,'2022-12-01 15:59:47','2023-01-05 04:15:39','2023-01-05 04:15:39'),(895,7851,326,40719,14,2,487,1,2146.60,NULL,'2022-12-01 15:59:47','2023-01-05 04:15:39','2023-01-05 04:15:39'),(896,7851,327,40719,14,19,163,1,80000.00,NULL,'2022-12-01 16:00:20','2022-12-01 16:00:20',NULL),(897,7851,327,40719,14,19,482,2,80000.00,NULL,'2022-12-01 16:00:20','2022-12-01 16:00:20',NULL),(898,7851,328,40719,14,3,217,1,5645.05,NULL,'2022-12-02 10:31:52','2022-12-06 16:13:46','2022-12-06 16:13:46'),(899,7851,328,40719,14,3,68,1,1185.46,NULL,'2022-12-02 10:31:52','2022-12-06 16:13:46','2022-12-06 16:13:46'),(900,7851,328,40719,14,3,221,1,619.49,NULL,'2022-12-02 10:31:52','2022-12-06 16:13:46','2022-12-06 16:13:46'),(901,7851,328,40719,14,3,57,2,7450.00,NULL,'2022-12-02 10:31:52','2022-12-06 16:13:46','2022-12-06 16:13:46'),(902,7851,329,40719,14,3,217,1,73513.17,NULL,'2022-12-02 10:33:29','2022-12-02 10:33:41','2022-12-02 10:33:41'),(903,7851,329,40719,14,3,68,1,15437.77,NULL,'2022-12-02 10:33:29','2022-12-02 10:33:41','2022-12-02 10:33:41'),(904,7851,329,40719,14,3,57,2,88950.94,NULL,'2022-12-02 10:33:29','2022-12-02 10:33:41','2022-12-02 10:33:41'),(905,7851,330,40719,13,3,217,1,73513.17,NULL,'2022-12-02 10:33:41','2022-12-02 10:33:41',NULL),(906,7851,330,40719,13,3,68,1,15437.77,NULL,'2022-12-02 10:33:41','2022-12-02 10:33:41',NULL),(907,7851,330,40719,13,3,57,2,88950.94,NULL,'2022-12-02 10:33:41','2022-12-02 10:33:41',NULL),(908,7851,331,40719,13,20,13,2,88950.94,NULL,'2022-12-02 10:34:42','2022-12-02 10:34:50','2022-12-02 10:34:50'),(909,7851,331,40719,13,20,482,1,88950.94,NULL,'2022-12-02 10:34:42','2022-12-02 10:34:50','2022-12-02 10:34:50'),(910,7851,332,40719,13,21,57,1,88950.94,NULL,'2022-12-02 10:35:16','2022-12-02 10:35:16',NULL),(911,7851,332,40719,13,21,482,2,88950.94,NULL,'2022-12-02 10:35:16','2022-12-02 10:35:16',NULL),(912,7851,333,40719,14,21,57,1,7450.00,NULL,'2022-12-02 10:35:45','2022-12-06 16:09:09','2022-12-06 16:09:09'),(913,7851,333,40719,14,21,482,2,7450.00,NULL,'2022-12-02 10:35:45','2022-12-06 16:09:09','2022-12-06 16:09:09'),(914,7851,334,40719,14,21,57,1,7780.00,NULL,'2022-12-02 10:37:27','2022-12-06 16:09:26','2022-12-06 16:09:26'),(915,7851,334,40719,14,21,482,2,7780.00,NULL,'2022-12-02 10:37:27','2022-12-06 16:09:26','2022-12-06 16:09:26'),(916,7851,335,40719,14,21,482,2,2220.00,NULL,'2022-12-02 10:38:21','2022-12-03 16:01:51','2022-12-03 16:01:51'),(917,7851,335,40719,14,21,489,1,2220.00,NULL,'2022-12-02 10:38:21','2022-12-03 16:01:51','2022-12-03 16:01:51'),(918,7851,336,40719,14,21,62,1,29880.00,NULL,'2022-12-02 10:41:42','2022-12-02 10:41:42',NULL),(919,7851,336,40719,14,21,163,2,29880.00,NULL,'2022-12-02 10:41:42','2022-12-02 10:41:42',NULL),(920,7851,337,40719,14,21,110,1,29880.00,NULL,'2022-12-02 10:42:51','2022-12-02 10:42:57','2022-12-02 10:42:57'),(921,7851,337,40719,14,21,62,2,29880.00,NULL,'2022-12-02 10:42:51','2022-12-02 10:42:57','2022-12-02 10:42:57'),(922,7851,338,40719,14,21,110,1,29880.00,NULL,'2022-12-02 10:42:57','2022-12-02 10:42:57',NULL),(923,7851,338,40719,14,21,62,2,29880.00,NULL,'2022-12-02 10:42:57','2022-12-02 10:42:57',NULL),(924,7851,339,40719,14,21,491,1,50120.00,NULL,'2022-12-02 10:43:55','2022-12-02 10:55:43','2022-12-02 10:55:43'),(925,7851,339,40719,14,21,163,2,50120.00,NULL,'2022-12-02 10:43:55','2022-12-02 10:55:43','2022-12-02 10:55:43'),(926,7851,340,40719,14,21,135,1,50120.00,NULL,'2022-12-02 10:44:43','2022-12-02 10:44:51','2022-12-02 10:44:51'),(927,7851,340,40719,14,21,491,2,50120.00,NULL,'2022-12-02 10:44:43','2022-12-02 10:44:51','2022-12-02 10:44:51'),(928,7851,341,40719,14,21,135,1,50120.00,NULL,'2022-12-02 10:44:51','2022-12-02 10:55:29','2022-12-02 10:55:29'),(929,7851,341,40719,14,21,491,2,50120.00,NULL,'2022-12-02 10:44:51','2022-12-02 10:55:29','2022-12-02 10:55:29');
INSERT INTO `balance_libro_details` VALUES (930,7851,342,40719,12,21,110,1,29880.00,NULL,'2022-12-02 10:47:57','2022-12-02 10:48:15','2022-12-02 10:48:15'),(931,7851,342,40719,12,21,62,2,29880.00,NULL,'2022-12-02 10:47:57','2022-12-02 10:48:15','2022-12-02 10:48:15'),(932,7851,343,40719,12,21,110,1,29880.00,NULL,'2022-12-02 10:48:15','2022-12-02 10:49:04','2022-12-02 10:49:04'),(933,7851,343,40719,12,21,62,2,29880.00,NULL,'2022-12-02 10:48:15','2022-12-02 10:49:04','2022-12-02 10:49:04'),(934,7851,344,40719,13,21,110,1,29880.00,NULL,'2022-12-02 10:49:04','2022-12-02 10:49:58','2022-12-02 10:49:58'),(935,7851,344,40719,13,21,62,2,29880.00,NULL,'2022-12-02 10:49:04','2022-12-02 10:49:58','2022-12-02 10:49:58'),(936,7851,345,40719,13,21,62,1,29880.00,NULL,'2022-12-02 10:49:51','2022-12-02 10:49:51',NULL),(937,7851,345,40719,13,21,163,2,29880.00,NULL,'2022-12-02 10:49:51','2022-12-02 10:49:51',NULL),(938,7851,346,40719,13,21,110,1,29880.00,NULL,'2022-12-02 10:49:58','2022-12-02 10:49:58',NULL),(939,7851,346,40719,13,21,62,2,29880.00,NULL,'2022-12-02 10:49:58','2022-12-02 10:49:58',NULL),(940,7851,347,40719,12,21,110,1,24000.00,NULL,'2022-12-02 10:50:40','2022-12-02 10:55:58','2022-12-02 10:55:58'),(941,7851,347,40719,12,21,62,2,24000.00,NULL,'2022-12-02 10:50:40','2022-12-02 10:55:58','2022-12-02 10:55:58'),(942,7851,348,40719,11,21,62,2,30000.00,NULL,'2022-12-02 10:51:25','2022-12-02 10:52:27','2022-12-02 10:52:27'),(943,7851,348,40719,11,21,110,1,30000.00,NULL,'2022-12-02 10:51:25','2022-12-02 10:52:27','2022-12-02 10:52:27'),(944,7851,349,40719,11,1,110,1,30000.00,NULL,'2022-12-02 10:52:03','2022-12-02 10:57:28','2022-12-02 10:57:28'),(945,7851,349,40719,11,1,62,2,30000.00,NULL,'2022-12-02 10:52:03','2022-12-02 10:57:28','2022-12-02 10:57:28'),(946,7851,350,40719,11,21,62,1,30000.00,NULL,'2022-12-02 10:52:27','2022-12-02 10:57:36','2022-12-02 10:57:36'),(947,7851,350,40719,11,21,482,2,30000.00,NULL,'2022-12-02 10:52:27','2022-12-02 10:57:36','2022-12-02 10:57:36'),(948,7851,351,40719,14,21,135,1,50120.00,NULL,'2022-12-02 10:55:29','2022-12-02 11:00:06','2022-12-02 11:00:06'),(949,7851,351,40719,14,21,491,2,50120.00,NULL,'2022-12-02 10:55:29','2022-12-02 11:00:06','2022-12-02 11:00:06'),(950,7851,352,40719,14,21,491,1,50120.00,NULL,'2022-12-02 10:55:43','2022-12-02 11:00:27','2022-12-02 11:00:27'),(951,7851,352,40719,14,21,163,2,50120.00,NULL,'2022-12-02 10:55:43','2022-12-02 11:00:27','2022-12-02 11:00:27'),(952,7851,353,40719,12,21,110,1,24000.00,NULL,'2022-12-02 10:55:58','2022-12-02 10:55:58',NULL),(953,7851,353,40719,12,21,62,2,24000.00,NULL,'2022-12-02 10:55:58','2022-12-02 10:55:58',NULL),(954,7851,354,40719,12,21,62,1,24000.00,NULL,'2022-12-02 10:57:05','2022-12-02 10:57:05',NULL),(955,7851,354,40719,12,21,482,2,24000.00,NULL,'2022-12-02 10:57:05','2022-12-02 10:57:05',NULL),(956,7851,355,40719,11,21,110,1,30000.00,NULL,'2022-12-02 10:57:28','2022-12-02 11:18:49','2022-12-02 11:18:49'),(957,7851,355,40719,11,21,62,2,30000.00,NULL,'2022-12-02 10:57:28','2022-12-02 11:18:49','2022-12-02 11:18:49'),(958,7851,356,40719,11,21,62,1,30000.00,NULL,'2022-12-02 10:57:36','2022-12-02 11:19:37','2022-12-02 11:19:37'),(959,7851,356,40719,11,21,482,2,30000.00,NULL,'2022-12-02 10:57:36','2022-12-02 11:19:37','2022-12-02 11:19:37'),(960,7851,357,40719,12,21,482,2,30000.00,NULL,'2022-12-02 10:58:30','2022-12-02 10:58:30',NULL),(961,7851,357,40719,12,21,491,1,30000.00,NULL,'2022-12-02 10:58:30','2022-12-02 10:58:30',NULL),(962,7851,358,40719,13,3,491,2,50120.00,NULL,'2022-12-02 10:59:22','2022-12-02 11:03:42','2022-12-02 11:03:42'),(963,7851,358,40719,13,3,512,1,50120.00,NULL,'2022-12-02 10:59:22','2022-12-02 11:03:42','2022-12-02 11:03:42'),(964,7851,359,40719,13,21,491,1,50120.00,NULL,'2022-12-02 10:59:45','2022-12-02 11:03:32','2022-12-02 11:03:32'),(965,7851,359,40719,13,21,163,2,50120.00,NULL,'2022-12-02 10:59:45','2022-12-02 11:03:32','2022-12-02 11:03:32'),(966,7851,360,40719,14,21,491,1,50120.00,NULL,'2022-12-02 11:00:27','2022-12-02 11:00:27',NULL);
INSERT INTO `balance_libro_details` VALUES (967,7851,360,40719,14,21,163,2,50120.00,NULL,'2022-12-02 11:00:27','2022-12-02 11:00:27',NULL),(968,7851,361,40719,14,21,518,1,50120.00,NULL,'2022-12-02 11:01:05','2022-12-02 11:03:13','2022-12-02 11:03:13'),(969,7851,361,40719,14,21,491,2,50120.00,NULL,'2022-12-02 11:01:05','2022-12-02 11:03:13','2022-12-02 11:03:13'),(970,7851,362,40719,14,21,518,1,50120.00,NULL,'2022-12-02 11:03:13','2022-12-02 11:03:13',NULL),(971,7851,362,40719,14,21,491,2,50120.00,NULL,'2022-12-02 11:03:13','2022-12-02 11:03:13',NULL),(972,7851,363,40719,13,21,491,1,50120.00,NULL,'2022-12-02 11:03:32','2022-12-02 11:03:32',NULL),(973,7851,363,40719,13,21,163,2,50120.00,NULL,'2022-12-02 11:03:32','2022-12-02 11:03:32',NULL),(974,7851,364,40719,13,3,491,2,50120.00,NULL,'2022-12-02 11:03:42','2022-12-02 11:17:48','2022-12-02 11:17:48'),(975,7851,364,40719,13,3,512,1,50120.00,NULL,'2022-12-02 11:03:42','2022-12-02 11:17:48','2022-12-02 11:17:48'),(976,7851,365,40719,11,21,518,1,30000.00,NULL,'2022-12-02 11:06:05','2022-12-02 11:08:00','2022-12-02 11:08:00'),(977,7851,365,40719,11,21,491,2,30000.00,NULL,'2022-12-02 11:06:05','2022-12-02 11:08:00','2022-12-02 11:08:00'),(978,7851,366,40719,11,21,482,2,30000.00,NULL,'2022-12-02 11:07:40','2022-12-02 11:07:40',NULL),(979,7851,366,40719,11,21,491,1,30000.00,NULL,'2022-12-02 11:07:40','2022-12-02 11:07:40',NULL),(980,7851,367,40719,11,3,518,1,30000.00,NULL,'2022-12-02 11:08:00','2022-12-02 11:08:00',NULL),(981,7851,367,40719,11,3,491,2,30000.00,NULL,'2022-12-02 11:08:00','2022-12-02 11:08:00',NULL),(982,7851,368,40719,12,3,491,2,30000.00,NULL,'2022-12-02 11:12:04','2022-12-02 11:12:04',NULL),(983,7851,368,40719,12,3,518,1,30000.00,NULL,'2022-12-02 11:12:04','2022-12-02 11:12:04',NULL),(984,7851,369,40719,12,3,491,2,16000.00,NULL,'2022-12-02 11:13:12','2022-12-02 11:13:21','2022-12-02 11:13:21'),(985,7851,369,40719,12,3,518,1,16000.00,NULL,'2022-12-02 11:13:12','2022-12-02 11:13:21','2022-12-02 11:13:21'),(986,7851,370,40719,12,3,491,2,16000.00,NULL,'2022-12-02 11:13:21','2022-12-02 11:13:21',NULL),(987,7851,370,40719,12,3,518,1,16000.00,NULL,'2022-12-02 11:13:21','2022-12-02 11:13:21',NULL),(988,7851,371,40719,11,3,491,2,16000.00,NULL,'2022-12-02 11:14:48','2022-12-02 11:15:00','2022-12-02 11:15:00'),(989,7851,371,40719,11,3,518,1,16000.00,NULL,'2022-12-02 11:14:48','2022-12-02 11:15:00','2022-12-02 11:15:00'),(990,7851,372,40719,11,3,491,2,16000.00,NULL,'2022-12-02 11:15:00','2022-12-02 11:15:20','2022-12-02 11:15:20'),(991,7851,372,40719,11,3,518,1,16000.00,NULL,'2022-12-02 11:15:00','2022-12-02 11:15:20','2022-12-02 11:15:20'),(992,7851,373,40719,11,3,491,2,16000.00,NULL,'2022-12-02 11:15:20','2022-12-02 11:15:20',NULL),(993,7851,373,40719,11,3,518,1,16000.00,NULL,'2022-12-02 11:15:20','2022-12-02 11:15:20',NULL),(994,7851,374,40719,11,21,482,2,16000.00,NULL,'2022-12-02 11:15:50','2022-12-02 11:15:56','2022-12-02 11:15:56'),(995,7851,374,40719,11,21,491,1,16000.00,NULL,'2022-12-02 11:15:50','2022-12-02 11:15:56','2022-12-02 11:15:56'),(996,7851,375,40719,11,21,482,2,16000.00,NULL,'2022-12-02 11:15:57','2022-12-02 11:15:57',NULL),(997,7851,375,40719,11,21,491,1,16000.00,NULL,'2022-12-02 11:15:57','2022-12-02 11:15:57',NULL),(998,7851,376,40719,13,3,491,2,50120.00,NULL,'2022-12-02 11:17:48','2022-12-02 11:17:48',NULL),(999,7851,376,40719,13,3,518,1,50120.00,NULL,'2022-12-02 11:17:48','2022-12-02 11:17:48',NULL),(1000,7851,377,40719,11,21,110,1,24000.00,NULL,'2022-12-02 11:18:49','2022-12-02 11:19:44','2022-12-02 11:19:44'),(1001,7851,377,40719,11,21,62,2,24000.00,NULL,'2022-12-02 11:18:49','2022-12-02 11:19:44','2022-12-02 11:19:44'),(1002,7851,378,40719,11,21,62,1,24000.00,NULL,'2022-12-02 11:19:37','2022-12-02 11:19:37',NULL),(1003,7851,378,40719,11,21,482,2,24000.00,NULL,'2022-12-02 11:19:37','2022-12-02 11:19:37',NULL),(1004,7851,379,40719,11,3,110,1,24000.00,NULL,'2022-12-02 11:19:44','2022-12-02 11:19:44',NULL),(1005,7851,379,40719,11,3,62,2,24000.00,NULL,'2022-12-02 11:19:44','2022-12-02 11:19:44',NULL);
INSERT INTO `balance_libro_details` VALUES (1006,7851,380,40719,11,21,498,1,17741.88,NULL,'2022-12-02 12:43:50','2022-12-02 12:44:07','2022-12-02 12:44:07'),(1007,7851,380,40719,11,21,482,2,17741.88,NULL,'2022-12-02 12:43:50','2022-12-02 12:44:07','2022-12-02 12:44:07'),(1008,7851,381,40719,11,21,498,1,17741.88,NULL,'2022-12-02 12:44:07','2022-12-02 12:44:07',NULL),(1009,7851,381,40719,11,21,482,2,17741.88,NULL,'2022-12-02 12:44:07','2022-12-02 12:44:07',NULL),(1010,7851,382,40719,11,21,482,2,75124.87,NULL,'2022-12-02 12:45:21','2022-12-02 12:45:21',NULL),(1011,7851,382,40719,11,21,492,1,75124.87,NULL,'2022-12-02 12:45:21','2022-12-02 12:45:21',NULL),(1012,7851,383,40719,11,1,482,1,90438.88,NULL,'2022-12-02 12:48:05','2022-12-02 12:48:05',NULL),(1013,7851,383,40719,11,1,500,2,90438.88,NULL,'2022-12-02 12:48:05','2022-12-02 12:48:05',NULL),(1014,7851,384,40719,11,2,504,2,260000.00,NULL,'2022-12-02 12:49:11','2022-12-02 12:49:11',NULL),(1015,7851,384,40719,11,2,482,1,260000.00,NULL,'2022-12-02 12:49:11','2022-12-02 12:49:11',NULL),(1016,7851,385,40719,11,2,511,2,4.36,NULL,'2022-12-02 12:51:33','2022-12-02 12:51:33',NULL),(1017,7851,385,40719,11,2,482,1,4.36,NULL,'2022-12-02 12:51:33','2022-12-02 12:51:33',NULL),(1018,7851,386,40719,11,2,99,2,503.37,NULL,'2022-12-02 12:52:14','2022-12-02 12:52:14',NULL),(1019,7851,386,40719,11,2,482,1,503.37,NULL,'2022-12-02 12:52:14','2022-12-02 12:52:14',NULL),(1020,7851,387,40719,11,21,505,1,8386.57,NULL,'2022-12-02 12:56:19','2022-12-02 12:56:45','2022-12-02 12:56:45'),(1021,7851,387,40719,11,21,482,2,8386.57,NULL,'2022-12-02 12:56:19','2022-12-02 12:56:45','2022-12-02 12:56:45'),(1022,7851,388,40719,11,21,505,1,9869.60,NULL,'2022-12-02 12:56:45','2023-03-03 11:42:27','2023-03-03 11:42:27'),(1023,7851,388,40719,11,21,482,2,9869.60,NULL,'2022-12-02 12:56:45','2023-03-03 11:42:27','2023-03-03 11:42:27'),(1024,7851,389,40719,11,21,508,1,106948.00,NULL,'2022-12-02 12:59:14','2022-12-02 12:59:14',NULL),(1025,7851,389,40719,11,21,482,2,106948.00,NULL,'2022-12-02 12:59:14','2022-12-02 12:59:14',NULL),(1026,7851,390,40719,11,21,495,1,40846.28,NULL,'2022-12-02 13:01:07','2022-12-02 13:01:07',NULL),(1027,7851,390,40719,11,21,482,2,40846.28,NULL,'2022-12-02 13:01:07','2022-12-02 13:01:07',NULL),(1028,7851,391,40719,11,21,482,2,5559.50,NULL,'2022-12-02 13:02:20','2022-12-02 13:02:20',NULL),(1029,7851,391,40719,11,21,495,1,5559.50,NULL,'2022-12-02 13:02:20','2022-12-02 13:02:20',NULL),(1030,7851,392,40719,11,21,497,1,160000.00,NULL,'2022-12-02 13:03:28','2022-12-02 13:05:50','2022-12-02 13:05:50'),(1031,7851,392,40719,11,21,482,2,160000.00,NULL,'2022-12-02 13:03:28','2022-12-02 13:05:50','2022-12-02 13:05:50'),(1032,7851,393,40719,11,21,482,2,350000.00,NULL,'2022-12-02 13:05:29','2022-12-02 13:06:03','2022-12-02 13:06:03'),(1033,7851,393,40719,11,21,485,1,350000.00,NULL,'2022-12-02 13:05:29','2022-12-02 13:06:03','2022-12-02 13:06:03'),(1034,7851,394,40719,11,21,497,1,160000.00,NULL,'2022-12-02 13:05:50','2022-12-02 13:05:50',NULL),(1035,7851,394,40719,11,21,482,2,160000.00,NULL,'2022-12-02 13:05:50','2022-12-02 13:05:50',NULL),(1036,7851,395,40719,11,21,482,2,350000.00,NULL,'2022-12-02 13:06:03','2022-12-02 13:06:03',NULL),(1037,7851,395,40719,11,21,485,1,350000.00,NULL,'2022-12-02 13:06:03','2022-12-02 13:06:03',NULL),(1038,7851,396,40719,11,21,396,1,1050.00,NULL,'2022-12-02 13:08:16','2022-12-02 13:08:16',NULL),(1039,7851,396,40719,11,21,482,2,1050.00,NULL,'2022-12-02 13:08:16','2022-12-02 13:08:16',NULL),(1040,7851,397,40719,11,12,482,1,64476.54,NULL,'2022-12-02 13:10:50','2022-12-02 13:10:50',NULL),(1041,7851,397,40719,11,12,96,2,64476.54,NULL,'2022-12-02 13:10:50','2022-12-02 13:10:50',NULL),(1042,7851,398,40719,11,21,482,2,15797.25,NULL,'2022-12-02 13:13:25','2022-12-02 13:13:25',NULL),(1043,7851,398,40719,11,21,512,1,15797.25,NULL,'2022-12-02 13:13:25','2022-12-02 13:13:25',NULL),(1044,7851,399,40719,11,3,135,1,942.09,NULL,'2022-12-02 13:14:55','2022-12-02 13:15:32','2022-12-02 13:15:32');
INSERT INTO `balance_libro_details` VALUES (1045,7851,399,40719,11,3,69,2,942.09,NULL,'2022-12-02 13:14:55','2022-12-02 13:15:32','2022-12-02 13:15:32'),(1046,7851,400,40719,11,21,135,1,942.09,NULL,'2022-12-02 13:15:32','2022-12-02 13:15:32',NULL),(1047,7851,400,40719,11,21,482,2,942.09,NULL,'2022-12-02 13:15:32','2022-12-02 13:15:32',NULL),(1048,7851,401,40719,11,21,482,2,2504.97,NULL,'2022-12-02 13:19:39','2022-12-02 13:19:39',NULL),(1049,7851,401,40719,11,21,212,1,2504.97,NULL,'2022-12-02 13:19:39','2022-12-02 13:19:39',NULL),(1050,7851,402,40719,11,21,214,1,899.96,NULL,'2022-12-02 13:20:18','2022-12-02 13:20:18',NULL),(1051,7851,402,40719,11,21,482,2,899.96,NULL,'2022-12-02 13:20:18','2022-12-02 13:20:18',NULL),(1052,7851,403,40719,11,21,492,1,12500.00,NULL,'2022-12-02 13:26:36','2022-12-02 13:26:36',NULL),(1053,7851,403,40719,11,21,482,2,12500.00,NULL,'2022-12-02 13:26:36','2022-12-02 13:26:36',NULL),(1054,7851,404,40719,11,21,482,1,45237.00,NULL,'2022-12-02 13:28:19','2022-12-02 13:29:20','2022-12-02 13:29:20'),(1055,7851,404,40719,11,21,483,2,45237.00,NULL,'2022-12-02 13:28:19','2022-12-02 13:29:20','2022-12-02 13:29:20'),(1056,7851,405,40719,11,2,483,1,45237.00,NULL,'2022-12-02 13:29:02','2022-12-02 13:29:26','2022-12-02 13:29:26'),(1057,7851,405,40719,11,2,163,2,45237.00,NULL,'2022-12-02 13:29:02','2022-12-02 13:29:26','2022-12-02 13:29:26'),(1058,7851,406,40719,11,19,482,1,45237.00,NULL,'2022-12-02 13:29:20','2022-12-02 23:28:30','2022-12-02 23:28:30'),(1059,7851,406,40719,11,19,483,2,45237.00,NULL,'2022-12-02 13:29:20','2022-12-02 23:28:30','2022-12-02 23:28:30'),(1060,7851,407,40719,11,19,483,1,45237.00,NULL,'2022-12-02 13:29:26','2022-12-02 13:29:26',NULL),(1061,7851,407,40719,11,19,163,2,45237.00,NULL,'2022-12-02 13:29:26','2022-12-02 13:29:26',NULL),(1062,7851,408,40719,11,19,482,1,48000.00,NULL,'2022-12-02 13:31:11','2022-12-02 13:36:53','2022-12-02 13:36:53'),(1063,7851,408,40719,11,19,163,2,48000.00,NULL,'2022-12-02 13:31:11','2022-12-02 13:36:53','2022-12-02 13:36:53'),(1064,7851,409,40719,11,21,482,2,578.95,NULL,'2022-12-02 13:33:10','2022-12-02 13:33:10',NULL),(1065,7851,409,40719,11,21,135,1,419.50,NULL,'2022-12-02 13:33:10','2022-12-02 13:33:10',NULL),(1066,7851,409,40719,11,21,135,1,159.45,NULL,'2022-12-02 13:33:10','2022-12-02 13:33:10',NULL),(1067,7851,410,40719,11,19,482,1,48000.00,NULL,'2022-12-02 13:36:53','2022-12-02 23:20:00','2022-12-02 23:20:00'),(1068,7851,410,40719,11,19,163,2,48000.00,NULL,'2022-12-02 13:36:53','2022-12-02 23:20:00','2022-12-02 23:20:00'),(1069,7851,411,40719,11,21,57,1,1604.46,NULL,'2022-12-02 13:38:15','2022-12-02 13:38:15',NULL),(1070,7851,411,40719,11,21,482,2,1604.46,NULL,'2022-12-02 13:38:15','2022-12-02 13:38:15',NULL),(1071,7851,412,40719,11,21,57,1,47446.58,NULL,'2022-12-02 13:40:04','2022-12-02 13:40:04',NULL),(1072,7851,412,40719,11,21,482,2,47446.58,NULL,'2022-12-02 13:40:04','2022-12-02 13:40:04',NULL),(1073,7851,413,40719,11,21,57,1,17379.07,NULL,'2022-12-02 13:40:52','2022-12-02 13:40:52',NULL),(1074,7851,413,40719,11,21,482,2,17379.07,NULL,'2022-12-02 13:40:52','2022-12-02 13:40:52',NULL),(1075,7851,414,40719,11,21,57,1,3549.99,NULL,'2022-12-02 13:41:46','2022-12-02 13:41:46',NULL),(1076,7851,414,40719,11,21,482,2,3549.99,NULL,'2022-12-02 13:41:46','2022-12-02 13:41:46',NULL),(1077,7851,415,40719,11,21,57,1,5099.30,NULL,'2022-12-02 13:42:59','2022-12-02 13:42:59',NULL),(1078,7851,415,40719,11,21,482,2,5099.30,NULL,'2022-12-02 13:42:59','2022-12-02 13:42:59',NULL),(1079,7851,416,40719,11,21,57,1,3974.00,NULL,'2022-12-02 13:44:39','2022-12-02 13:44:39',NULL),(1080,7851,416,40719,11,21,482,2,3974.00,NULL,'2022-12-02 13:44:39','2022-12-02 13:44:39',NULL),(1081,7851,417,40719,11,21,482,2,1880.00,NULL,'2022-12-02 13:45:15','2022-12-02 13:45:15',NULL),(1082,7851,417,40719,11,21,57,1,1880.00,NULL,'2022-12-02 13:45:15','2022-12-02 13:45:15',NULL),(1083,7851,418,40719,11,21,57,1,20000.00,NULL,'2022-12-02 13:47:35','2022-12-02 13:47:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1084,7851,418,40719,11,21,482,2,20000.00,NULL,'2022-12-02 13:47:35','2022-12-02 13:47:35',NULL),(1085,7851,419,40719,11,21,57,1,18000.00,NULL,'2022-12-02 13:48:33','2022-12-02 13:50:06','2022-12-02 13:50:06'),(1086,7851,419,40719,11,21,482,2,18000.00,NULL,'2022-12-02 13:48:33','2022-12-02 13:50:06','2022-12-02 13:50:06'),(1087,7851,420,40719,11,21,57,1,16300.00,NULL,'2022-12-02 13:49:31','2022-12-02 13:50:12','2022-12-02 13:50:12'),(1088,7851,420,40719,11,21,482,2,16300.00,NULL,'2022-12-02 13:49:31','2022-12-02 13:50:12','2022-12-02 13:50:12'),(1089,7851,421,40719,11,21,57,1,17001.19,NULL,'2022-12-02 13:50:57','2022-12-02 13:50:57',NULL),(1090,7851,421,40719,11,21,482,2,17001.19,NULL,'2022-12-02 13:50:57','2022-12-02 13:50:57',NULL),(1091,7851,422,40719,11,21,57,1,16300.00,NULL,'2022-12-02 13:53:07','2022-12-02 13:53:07',NULL),(1092,7851,422,40719,11,21,482,2,16300.00,NULL,'2022-12-02 13:53:07','2022-12-02 13:53:07',NULL),(1093,7851,423,40719,11,21,57,1,5500.31,NULL,'2022-12-02 14:23:17','2022-12-02 14:23:17',NULL),(1094,7851,423,40719,11,21,482,2,5500.31,NULL,'2022-12-02 14:23:17','2022-12-02 14:23:17',NULL),(1095,7851,424,40719,11,9,482,2,6698.71,NULL,'2022-12-02 14:26:09','2023-01-31 21:36:39','2023-01-31 21:36:39'),(1096,7851,424,40719,11,9,512,1,6698.71,NULL,'2022-12-02 14:26:09','2023-01-31 21:36:39','2023-01-31 21:36:39'),(1097,7851,425,40719,11,19,482,2,48000.00,NULL,'2022-12-02 23:20:00','2022-12-02 23:20:00',NULL),(1098,7851,425,40719,11,19,163,1,48000.00,NULL,'2022-12-02 23:20:00','2022-12-02 23:20:00',NULL),(1099,7851,426,40719,11,19,482,1,32737.00,NULL,'2022-12-02 23:28:30','2022-12-03 00:24:17','2022-12-03 00:24:17'),(1100,7851,426,40719,11,19,483,2,32737.00,NULL,'2022-12-02 23:28:30','2022-12-03 00:24:17','2022-12-03 00:24:17'),(1101,7851,427,40719,11,21,482,2,2650.00,NULL,'2022-12-02 23:53:34','2022-12-02 23:53:34',NULL),(1102,7851,427,40719,11,21,489,1,2650.00,NULL,'2022-12-02 23:53:34','2022-12-02 23:53:34',NULL),(1103,7851,428,40719,11,19,482,1,45237.00,NULL,'2022-12-03 00:24:17','2022-12-03 00:24:17',NULL),(1104,7851,428,40719,11,19,483,2,45237.00,NULL,'2022-12-03 00:24:17','2022-12-03 00:24:17',NULL),(1105,7851,429,40719,14,21,497,1,20000.00,NULL,'2022-12-03 15:33:31','2022-12-03 15:33:46','2022-12-03 15:33:46'),(1106,7851,429,40719,14,21,482,2,20000.00,NULL,'2022-12-03 15:33:31','2022-12-03 15:33:46','2022-12-03 15:33:46'),(1107,7851,430,40719,14,21,497,1,20000.00,NULL,'2022-12-03 15:33:46','2022-12-03 15:33:46',NULL),(1108,7851,430,40719,14,21,482,2,20000.00,NULL,'2022-12-03 15:33:46','2022-12-03 15:33:46',NULL),(1109,7851,431,40719,14,21,396,1,1050.00,NULL,'2022-12-03 15:41:48','2022-12-03 18:34:47','2022-12-03 18:34:47'),(1110,7851,431,40719,14,21,482,2,1050.00,NULL,'2022-12-03 15:41:48','2022-12-03 18:34:47','2022-12-03 18:34:47'),(1111,7851,432,40719,14,21,497,1,10000.00,NULL,'2022-12-03 15:42:44','2022-12-03 15:55:21','2022-12-03 15:55:21'),(1112,7851,432,40719,14,21,482,2,10000.00,NULL,'2022-12-03 15:42:44','2022-12-03 15:55:21','2022-12-03 15:55:21'),(1113,7851,433,40719,14,21,482,2,1000.00,NULL,'2022-12-03 15:43:40','2022-12-03 15:43:40',NULL),(1114,7851,433,40719,14,21,502,1,1000.00,NULL,'2022-12-03 15:43:40','2022-12-03 15:43:40',NULL),(1115,7851,434,40719,14,21,212,1,1452.30,NULL,'2022-12-03 15:48:36','2023-01-04 23:58:24','2023-01-04 23:58:24'),(1116,7851,434,40719,14,21,482,2,1452.30,NULL,'2022-12-03 15:48:36','2023-01-04 23:58:24','2023-01-04 23:58:24'),(1117,7851,435,40719,14,21,482,2,415.17,NULL,'2022-12-03 15:49:49','2023-01-04 23:40:08','2023-01-04 23:40:08'),(1118,7851,435,40719,14,21,214,1,415.17,NULL,'2022-12-03 15:49:49','2023-01-04 23:40:08','2023-01-04 23:40:08'),(1119,7851,436,40719,14,21,497,1,2200.00,NULL,'2022-12-03 15:55:21','2022-12-03 16:03:28','2022-12-03 16:03:28'),(1120,7851,436,40719,14,21,482,2,2200.00,NULL,'2022-12-03 15:55:21','2022-12-03 16:03:28','2022-12-03 16:03:28');
INSERT INTO `balance_libro_details` VALUES (1121,7851,437,40719,14,21,482,2,2220.00,NULL,'2022-12-03 16:03:28','2023-01-30 23:26:55','2023-01-30 23:26:55'),(1122,7851,437,40719,14,21,489,1,2220.00,NULL,'2022-12-03 16:03:28','2023-01-30 23:26:55','2023-01-30 23:26:55'),(1123,7851,438,40719,14,21,57,1,1900.00,NULL,'2022-12-03 16:11:59','2022-12-06 16:09:47','2022-12-06 16:09:47'),(1124,7851,438,40719,14,21,482,2,1900.00,NULL,'2022-12-03 16:11:59','2022-12-06 16:09:47','2022-12-06 16:09:47'),(1125,7851,439,40719,13,2,511,2,9.75,NULL,'2022-12-03 18:33:44','2022-12-03 18:33:44',NULL),(1126,7851,439,40719,13,2,511,1,9.75,NULL,'2022-12-03 18:33:44','2022-12-03 18:33:44',NULL),(1127,7851,440,40719,14,21,396,1,1050.00,NULL,'2022-12-03 18:34:47','2022-12-03 18:34:56','2022-12-03 18:34:56'),(1128,7851,440,40719,14,21,482,2,1050.00,NULL,'2022-12-03 18:34:47','2022-12-03 18:34:56','2022-12-03 18:34:56'),(1129,7851,441,40719,14,21,396,1,1050.00,NULL,'2022-12-03 18:34:56','2023-01-30 23:24:16','2023-01-30 23:24:16'),(1130,7851,441,40719,14,21,482,2,1050.00,NULL,'2022-12-03 18:34:56','2023-01-30 23:24:16','2023-01-30 23:24:16'),(1131,7851,442,40719,13,3,217,1,8580.30,NULL,'2022-12-03 19:58:40','2022-12-03 19:58:40',NULL),(1132,7851,442,40719,13,3,68,1,2316.68,NULL,'2022-12-03 19:58:40','2022-12-03 19:58:40',NULL),(1133,7851,442,40719,13,3,217,1,1239.00,NULL,'2022-12-03 19:58:40','2022-12-03 19:58:40',NULL),(1134,7851,442,40719,13,3,68,1,260.19,NULL,'2022-12-03 19:58:40','2022-12-03 19:58:40',NULL),(1135,7851,442,40719,13,3,217,1,451.59,NULL,'2022-12-03 19:58:40','2022-12-03 19:58:40',NULL),(1136,7851,442,40719,13,3,237,1,294.58,NULL,'2022-12-03 19:58:40','2022-12-03 19:58:40',NULL),(1137,7851,442,40719,13,3,57,2,13142.34,NULL,'2022-12-03 19:58:40','2022-12-03 19:58:40',NULL),(1138,7851,443,40719,14,19,483,2,20000.00,NULL,'2022-12-05 14:03:57','2022-12-05 14:03:57',NULL),(1139,7851,443,40719,14,19,484,1,20000.00,NULL,'2022-12-05 14:03:57','2022-12-05 14:03:57',NULL),(1140,7851,444,40719,13,20,13,2,306918.00,NULL,'2022-12-06 11:18:08','2022-12-06 11:18:08',NULL),(1141,7851,444,40719,13,20,263,1,8332.62,NULL,'2022-12-06 11:18:08','2022-12-06 11:18:08',NULL),(1142,7851,444,40719,13,20,23,1,1075.08,NULL,'2022-12-06 11:18:08','2022-12-06 11:18:08',NULL),(1143,7851,444,40719,13,20,482,1,297510.30,NULL,'2022-12-06 11:18:08','2022-12-06 11:18:08',NULL),(1144,7851,445,40719,13,20,13,2,1175515.99,NULL,'2022-12-06 11:34:29','2022-12-06 11:34:29',NULL),(1145,7851,445,40719,13,20,23,1,21276.30,NULL,'2022-12-06 11:34:29','2022-12-06 11:34:29',NULL),(1146,7851,445,40719,13,20,263,1,31914.46,NULL,'2022-12-06 11:34:29','2022-12-06 11:34:29',NULL),(1147,7851,445,40719,13,20,482,1,1122325.23,NULL,'2022-12-06 11:34:29','2022-12-06 11:34:29',NULL),(1148,7851,446,40719,14,19,482,2,240000.00,NULL,'2022-12-06 12:46:55','2022-12-06 12:46:55',NULL),(1149,7851,446,40719,14,19,163,1,240000.00,NULL,'2022-12-06 12:46:55','2022-12-06 12:46:55',NULL),(1150,7851,447,40719,14,19,482,2,63000.00,NULL,'2022-12-06 12:47:44','2022-12-06 12:47:44',NULL),(1151,7851,447,40719,14,19,163,1,63000.00,NULL,'2022-12-06 12:47:44','2022-12-06 12:47:44',NULL),(1152,7851,448,40719,14,19,482,2,120000.00,NULL,'2022-12-06 12:57:13','2022-12-06 12:57:13',NULL),(1153,7851,448,40719,14,19,487,1,120000.00,NULL,'2022-12-06 12:57:13','2022-12-06 12:57:13',NULL),(1154,7851,449,40719,14,19,482,2,300000.00,NULL,'2022-12-06 12:58:43','2022-12-06 12:58:43',NULL),(1155,7851,449,40719,14,19,483,1,300000.00,NULL,'2022-12-06 12:58:43','2022-12-06 12:58:43',NULL),(1156,7851,450,40719,14,19,482,2,100000.00,NULL,'2022-12-06 12:59:29','2022-12-06 12:59:29',NULL),(1157,7851,450,40719,14,19,163,1,100000.00,NULL,'2022-12-06 12:59:29','2022-12-06 12:59:29',NULL),(1158,7851,451,40719,14,19,510,1,100000.00,NULL,'2022-12-06 13:00:32','2022-12-06 13:00:32',NULL),(1159,7851,451,40719,14,19,482,2,100000.00,NULL,'2022-12-06 13:00:32','2022-12-06 13:00:32',NULL),(1160,7851,452,40719,14,19,485,1,300000.00,NULL,'2022-12-06 13:01:10','2022-12-06 13:01:10',NULL);
INSERT INTO `balance_libro_details` VALUES (1161,7851,452,40719,14,19,482,2,300000.00,NULL,'2022-12-06 13:01:10','2022-12-06 13:01:10',NULL),(1162,7851,453,40719,14,19,492,1,20000.00,NULL,'2022-12-06 13:07:29','2022-12-06 13:07:29',NULL),(1163,7851,453,40719,14,19,482,2,20000.00,NULL,'2022-12-06 13:07:29','2022-12-06 13:07:29',NULL),(1164,7851,454,40719,14,19,502,1,20000.00,NULL,'2022-12-06 13:08:12','2022-12-06 13:08:31','2022-12-06 13:08:31'),(1165,7851,454,40719,14,19,482,2,20000.00,NULL,'2022-12-06 13:08:12','2022-12-06 13:08:31','2022-12-06 13:08:31'),(1166,7851,455,40719,14,19,502,1,20000.00,NULL,'2022-12-06 13:08:31','2022-12-06 13:08:31',NULL),(1167,7851,455,40719,14,19,482,2,20000.00,NULL,'2022-12-06 13:08:31','2022-12-06 13:08:31',NULL),(1168,7851,456,40719,14,21,63,1,18801.15,NULL,'2022-12-06 14:08:39','2022-12-06 14:08:39',NULL),(1169,7851,456,40719,14,21,163,2,18801.15,NULL,'2022-12-06 14:08:39','2022-12-06 14:08:39',NULL),(1170,7851,457,40719,13,21,57,1,1900.00,NULL,'2022-12-06 16:10:48','2023-01-05 18:44:29','2023-01-05 18:44:29'),(1171,7851,457,40719,13,21,482,2,1900.00,NULL,'2022-12-06 16:10:48','2023-01-05 18:44:29','2023-01-05 18:44:29'),(1172,7851,458,40719,14,3,519,1,5645.05,NULL,'2022-12-06 16:13:46','2022-12-06 16:13:46',NULL),(1173,7851,458,40719,14,3,68,1,1185.46,NULL,'2022-12-06 16:13:46','2022-12-06 16:13:46',NULL),(1174,7851,458,40719,14,3,221,1,619.49,NULL,'2022-12-06 16:13:46','2022-12-06 16:13:46',NULL),(1175,7851,458,40719,14,3,57,2,7450.00,NULL,'2022-12-06 16:13:46','2022-12-06 16:13:46',NULL),(1176,7851,459,40719,14,3,512,1,6429.70,NULL,'2022-12-06 16:14:00','2022-12-06 16:14:00',NULL),(1177,7851,459,40719,14,3,68,1,1350.24,NULL,'2022-12-06 16:14:00','2022-12-06 16:14:00',NULL),(1178,7851,459,40719,14,3,512,1,0.06,NULL,'2022-12-06 16:14:00','2022-12-06 16:14:00',NULL),(1179,7851,459,40719,14,3,57,2,7780.00,NULL,'2022-12-06 16:14:00','2022-12-06 16:14:00',NULL),(1180,7851,460,40719,14,21,57,1,7780.00,NULL,'2022-12-06 16:14:58','2023-01-30 23:17:18','2023-01-30 23:17:18'),(1181,7851,460,40719,14,21,482,2,7780.00,NULL,'2022-12-06 16:14:58','2023-01-30 23:17:18','2023-01-30 23:17:18'),(1182,7851,461,40719,14,21,57,1,7450.00,NULL,'2022-12-06 16:15:31','2022-12-06 16:15:31',NULL),(1183,7851,461,40719,14,21,482,2,7450.00,NULL,'2022-12-06 16:15:31','2022-12-06 16:15:31',NULL),(1184,7851,462,40719,13,21,484,2,719.70,NULL,'2022-12-06 19:05:14','2022-12-06 19:05:14',NULL),(1185,7851,462,40719,13,21,396,1,719.70,NULL,'2022-12-06 19:05:14','2022-12-06 19:05:14',NULL),(1186,7851,463,40719,13,21,57,1,13142.34,NULL,'2022-12-06 21:32:59','2022-12-06 21:32:59',NULL),(1187,7851,463,40719,13,21,482,2,13142.34,NULL,'2022-12-06 21:32:59','2022-12-06 21:32:59',NULL),(1188,7851,464,40719,13,21,163,2,7007.99,NULL,'2022-12-06 22:13:36','2022-12-12 18:28:23','2022-12-12 18:28:23'),(1189,7851,464,40719,13,21,531,1,7007.99,NULL,'2022-12-06 22:13:36','2022-12-12 18:28:23','2022-12-12 18:28:23'),(1190,7851,465,40719,13,21,163,2,7007.99,NULL,'2022-12-12 18:28:23','2023-02-12 22:20:22','2023-02-12 22:20:22'),(1191,7851,465,40719,13,21,531,1,7007.99,NULL,'2022-12-12 18:28:23','2023-02-12 22:20:22','2023-02-12 22:20:22'),(1192,7851,466,40719,14,2,490,2,13129.86,NULL,'2022-12-12 18:35:44','2022-12-12 18:36:11','2022-12-12 18:36:11'),(1193,7851,466,40719,14,2,486,2,206124.67,NULL,'2022-12-12 18:35:44','2022-12-12 18:36:11','2022-12-12 18:36:11'),(1194,7851,466,40719,14,2,163,1,219254.53,NULL,'2022-12-12 18:35:44','2022-12-12 18:36:11','2022-12-12 18:36:11'),(1195,7851,467,40719,14,2,490,2,13129.86,NULL,'2022-12-12 18:36:11','2022-12-12 18:36:11',NULL),(1196,7851,467,40719,14,2,486,2,206124.67,NULL,'2022-12-12 18:36:11','2022-12-12 18:36:11',NULL),(1197,7851,467,40719,14,2,163,1,219254.53,NULL,'2022-12-12 18:36:11','2022-12-12 18:36:11',NULL),(1198,7851,468,40719,14,19,486,1,220000.00,NULL,'2022-12-12 18:37:18','2022-12-12 18:37:18',NULL),(1199,7851,468,40719,14,19,163,2,220000.00,NULL,'2022-12-12 18:37:18','2022-12-12 18:37:18',NULL);
INSERT INTO `balance_libro_details` VALUES (1200,7851,469,40719,14,19,163,2,440000.00,NULL,'2022-12-12 18:53:58','2022-12-12 18:55:00','2022-12-12 18:55:00'),(1201,7851,469,40719,14,19,486,1,440000.00,NULL,'2022-12-12 18:53:58','2022-12-12 18:55:00','2022-12-12 18:55:00'),(1202,7851,470,40719,14,19,163,2,440000.00,NULL,'2022-12-12 18:55:00','2022-12-12 18:55:00',NULL),(1203,7851,470,40719,14,19,486,1,440000.00,NULL,'2022-12-12 18:55:00','2022-12-12 18:55:00',NULL),(1204,7851,471,40719,14,19,482,2,31200.00,NULL,'2022-12-12 19:03:23','2022-12-12 19:03:41','2022-12-12 19:03:41'),(1205,7851,471,40719,14,19,510,1,31200.00,NULL,'2022-12-12 19:03:23','2022-12-12 19:03:41','2022-12-12 19:03:41'),(1206,7851,472,40719,14,19,482,2,31200.00,NULL,'2022-12-12 19:03:41','2022-12-12 19:03:41',NULL),(1207,7851,472,40719,14,19,510,1,31200.00,NULL,'2022-12-12 19:03:41','2022-12-12 19:03:41',NULL),(1208,7851,473,40719,14,3,217,1,991.74,NULL,'2022-12-15 12:03:43','2022-12-15 12:05:10','2022-12-15 12:05:10'),(1209,7851,473,40719,14,3,68,1,208.26,NULL,'2022-12-15 12:03:43','2022-12-15 12:05:10','2022-12-15 12:05:10'),(1210,7851,473,40719,14,3,57,2,1200.00,NULL,'2022-12-15 12:03:43','2022-12-15 12:05:10','2022-12-15 12:05:10'),(1211,7851,474,40719,14,3,217,1,1723.80,NULL,'2022-12-15 12:03:43','2022-12-15 12:03:43',NULL),(1212,7851,474,40719,14,3,68,1,362.00,NULL,'2022-12-15 12:03:43','2022-12-15 12:03:43',NULL),(1213,7851,474,40719,14,3,57,2,2085.80,NULL,'2022-12-15 12:03:43','2022-12-15 12:03:43',NULL),(1214,7851,475,40719,14,3,217,1,594.79,NULL,'2022-12-15 12:03:43','2022-12-15 12:03:43',NULL),(1215,7851,475,40719,14,3,68,1,124.91,NULL,'2022-12-15 12:03:43','2022-12-15 12:03:43',NULL),(1216,7851,475,40719,14,3,57,2,719.70,NULL,'2022-12-15 12:03:43','2022-12-15 12:03:43',NULL),(1217,7851,476,40719,14,3,217,1,971.07,NULL,'2022-12-15 12:03:43','2022-12-15 12:05:02','2022-12-15 12:05:02'),(1218,7851,476,40719,14,3,68,1,203.93,NULL,'2022-12-15 12:03:43','2022-12-15 12:05:02','2022-12-15 12:05:02'),(1219,7851,476,40719,14,3,57,2,1175.00,NULL,'2022-12-15 12:03:43','2022-12-15 12:05:02','2022-12-15 12:05:02'),(1220,7851,477,40719,14,3,217,1,6348.16,NULL,'2022-12-15 12:03:43','2022-12-15 12:04:47','2022-12-15 12:04:47'),(1221,7851,477,40719,14,3,68,1,1333.11,NULL,'2022-12-15 12:03:43','2022-12-15 12:04:47','2022-12-15 12:04:47'),(1222,7851,477,40719,14,3,217,1,1170.22,NULL,'2022-12-15 12:03:43','2022-12-15 12:04:47','2022-12-15 12:04:47'),(1223,7851,477,40719,14,3,57,2,8851.49,NULL,'2022-12-15 12:03:43','2022-12-15 12:04:47','2022-12-15 12:04:47'),(1224,7851,478,40719,14,3,217,1,5431.43,NULL,'2022-12-15 12:03:43','2022-12-15 12:04:26','2022-12-15 12:04:26'),(1225,7851,478,40719,14,3,68,1,1140.60,NULL,'2022-12-15 12:03:43','2022-12-15 12:04:26','2022-12-15 12:04:26'),(1226,7851,478,40719,14,3,217,1,108.63,NULL,'2022-12-15 12:03:43','2022-12-15 12:04:26','2022-12-15 12:04:26'),(1227,7851,478,40719,14,3,57,2,6680.66,NULL,'2022-12-15 12:03:43','2022-12-15 12:04:26','2022-12-15 12:04:26'),(1228,7851,479,40719,14,3,217,1,5431.43,NULL,'2022-12-15 12:04:26','2022-12-15 12:04:26',NULL),(1229,7851,479,40719,14,3,68,1,1140.60,NULL,'2022-12-15 12:04:26','2022-12-15 12:04:26',NULL),(1230,7851,479,40719,14,3,237,1,108.63,NULL,'2022-12-15 12:04:26','2022-12-15 12:04:26',NULL),(1231,7851,479,40719,14,3,57,2,6680.66,NULL,'2022-12-15 12:04:26','2022-12-15 12:04:26',NULL),(1232,7851,480,40719,14,3,217,1,6348.16,NULL,'2022-12-15 12:04:47','2022-12-15 12:04:47',NULL),(1233,7851,480,40719,14,3,68,1,1333.11,NULL,'2022-12-15 12:04:47','2022-12-15 12:04:47',NULL),(1234,7851,480,40719,14,3,221,1,1170.22,NULL,'2022-12-15 12:04:47','2022-12-15 12:04:47',NULL),(1235,7851,480,40719,14,3,57,2,8851.49,NULL,'2022-12-15 12:04:47','2022-12-15 12:04:47',NULL),(1236,7851,481,40719,14,21,493,1,30760.26,NULL,'2022-12-15 12:31:37','2022-12-15 12:31:37',NULL),(1237,7851,481,40719,14,21,163,2,30760.26,NULL,'2022-12-15 12:31:37','2022-12-15 12:31:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1238,7851,482,40719,14,21,163,2,31551.71,NULL,'2022-12-15 12:33:37','2022-12-15 12:33:37',NULL),(1239,7851,482,40719,14,21,494,1,31551.71,NULL,'2022-12-15 12:33:37','2022-12-15 12:33:37',NULL),(1240,7851,483,40719,14,21,533,1,506.92,NULL,'2022-12-15 20:20:00','2022-12-15 20:20:00',NULL),(1241,7851,483,40719,14,21,163,2,506.92,NULL,'2022-12-15 20:20:00','2022-12-15 20:20:00',NULL),(1242,7851,484,40719,14,19,482,2,160000.00,NULL,'2022-12-16 23:28:46','2022-12-16 23:28:46',NULL),(1243,7851,484,40719,14,19,163,1,160000.00,NULL,'2022-12-16 23:28:46','2022-12-16 23:28:46',NULL),(1244,7851,485,40719,14,21,62,1,29880.00,NULL,'2022-12-17 13:16:38','2022-12-17 13:16:38',NULL),(1245,7851,485,40719,14,21,163,2,29880.00,NULL,'2022-12-17 13:16:38','2022-12-17 13:16:38',NULL),(1246,7851,486,40719,14,21,62,1,14940.00,NULL,'2022-12-17 13:17:21','2022-12-17 13:17:21',NULL),(1247,7851,486,40719,14,21,163,2,14940.00,NULL,'2022-12-17 13:17:21','2022-12-17 13:17:21',NULL),(1248,7851,487,40719,14,21,482,2,10000.00,NULL,'2022-12-17 13:39:24','2022-12-17 13:39:34','2022-12-17 13:39:34'),(1249,7851,487,40719,14,21,497,1,10000.00,NULL,'2022-12-17 13:39:24','2022-12-17 13:39:34','2022-12-17 13:39:34'),(1250,7851,488,40719,14,21,482,2,10000.00,NULL,'2022-12-17 13:39:34','2022-12-17 13:39:34',NULL),(1251,7851,488,40719,14,21,497,1,10000.00,NULL,'2022-12-17 13:39:34','2022-12-17 13:39:34',NULL),(1252,7851,489,40719,14,21,482,2,40000.00,NULL,'2022-12-17 13:42:05','2022-12-17 13:42:05',NULL),(1253,7851,489,40719,14,21,497,1,40000.00,NULL,'2022-12-17 13:42:05','2022-12-17 13:42:05',NULL),(1254,7851,490,40719,14,21,498,1,4987.00,NULL,'2022-12-17 13:49:11','2022-12-22 18:27:53','2022-12-22 18:27:53'),(1255,7851,490,40719,14,21,482,2,4987.00,NULL,'2022-12-17 13:49:11','2022-12-22 18:27:53','2022-12-22 18:27:53'),(1256,7851,491,40719,14,21,482,2,8386.56,NULL,'2022-12-17 13:50:38','2022-12-17 13:51:11','2022-12-17 13:51:11'),(1257,7851,491,40719,14,21,505,1,8386.56,NULL,'2022-12-17 13:50:38','2022-12-17 13:51:11','2022-12-17 13:51:11'),(1258,7851,492,40719,14,21,482,2,8386.56,NULL,'2022-12-17 13:51:11','2023-01-30 21:00:44','2023-01-30 21:00:44'),(1259,7851,492,40719,14,21,505,1,8386.56,NULL,'2022-12-17 13:51:11','2023-01-30 21:00:44','2023-01-30 21:00:44'),(1260,7851,493,40719,13,15,67,1,170028.92,NULL,'2022-12-21 12:17:17','2023-01-05 10:40:35','2023-01-05 10:40:35'),(1261,7851,493,40719,13,15,68,2,129086.91,NULL,'2022-12-21 12:17:17','2023-01-05 10:40:35','2023-01-05 10:40:35'),(1262,7851,493,40719,13,15,74,2,39124.01,NULL,'2022-12-21 12:17:17','2023-01-05 10:40:35','2023-01-05 10:40:35'),(1263,7851,493,40719,13,15,136,2,1818.00,NULL,'2022-12-21 12:17:17','2023-01-05 10:40:35','2023-01-05 10:40:35'),(1264,7851,494,40719,11,15,67,1,68700.88,NULL,'2022-12-21 12:18:11','2022-12-21 12:21:00','2022-12-21 12:21:00'),(1265,7851,494,40719,11,15,68,2,40377.67,NULL,'2022-12-21 12:18:11','2022-12-21 12:21:00','2022-12-21 12:21:00'),(1266,7851,494,40719,11,15,353,2,26924.00,NULL,'2022-12-21 12:18:11','2022-12-21 12:21:00','2022-12-21 12:21:00'),(1267,7851,494,40719,11,15,220,2,1175.12,NULL,'2022-12-21 12:18:11','2022-12-21 12:21:00','2022-12-21 12:21:00'),(1268,7851,494,40719,11,15,74,2,224.10,NULL,'2022-12-21 12:18:11','2022-12-21 12:21:00','2022-12-21 12:21:00'),(1269,7851,494,40719,11,15,136,1,0.01,NULL,'2022-12-21 12:18:11','2022-12-21 12:21:00','2022-12-21 12:21:00'),(1270,7851,495,40719,10,15,353,1,26924.00,NULL,'2022-12-21 12:21:25','2023-01-05 10:40:25','2023-01-05 10:40:25'),(1271,7851,495,40719,10,15,136,2,26924.00,NULL,'2022-12-21 12:21:25','2023-01-05 10:40:25','2023-01-05 10:40:25'),(1272,7851,496,40719,11,3,520,1,12239.38,NULL,'2022-12-21 12:41:15','2023-01-05 11:13:25','2023-01-05 11:13:25'),(1273,7851,496,40719,11,3,68,1,2570.27,NULL,'2022-12-21 12:41:15','2023-01-05 11:13:25','2023-01-05 11:13:25'),(1274,7851,496,40719,11,3,221,1,1490.35,NULL,'2022-12-21 12:41:15','2023-01-05 11:13:25','2023-01-05 11:13:25');
INSERT INTO `balance_libro_details` VALUES (1275,7851,496,40719,11,3,57,2,16300.00,NULL,'2022-12-21 12:41:15','2023-01-05 11:13:25','2023-01-05 11:13:25'),(1276,7851,497,40719,11,15,67,1,68700.88,NULL,'2022-12-21 13:13:02','2022-12-21 13:15:12','2022-12-21 13:15:12'),(1277,7851,497,40719,11,15,68,2,42947.93,NULL,'2022-12-21 13:13:02','2022-12-21 13:15:12','2022-12-21 13:15:12'),(1278,7851,497,40719,11,15,353,2,26924.00,NULL,'2022-12-21 13:13:02','2022-12-21 13:15:12','2022-12-21 13:15:12'),(1279,7851,497,40719,11,15,220,2,1175.12,NULL,'2022-12-21 13:13:02','2022-12-21 13:15:12','2022-12-21 13:15:12'),(1280,7851,497,40719,11,15,353,1,4129.92,NULL,'2022-12-21 13:13:02','2022-12-21 13:15:12','2022-12-21 13:15:12'),(1281,7851,497,40719,11,15,354,1,1175.12,NULL,'2022-12-21 13:13:02','2022-12-21 13:15:12','2022-12-21 13:15:12'),(1282,7851,497,40719,11,15,136,2,2958.87,NULL,'2022-12-21 13:13:02','2022-12-21 13:15:12','2022-12-21 13:15:12'),(1283,7851,498,40719,11,15,67,1,68700.88,NULL,'2022-12-21 13:26:16','2023-01-05 10:40:30','2023-01-05 10:40:30'),(1284,7851,498,40719,11,15,68,2,42947.93,NULL,'2022-12-21 13:26:16','2023-01-05 10:40:30','2023-01-05 10:40:30'),(1285,7851,498,40719,11,15,353,2,26924.00,NULL,'2022-12-21 13:26:16','2023-01-05 10:40:30','2023-01-05 10:40:30'),(1286,7851,498,40719,11,15,220,2,1175.12,NULL,'2022-12-21 13:26:16','2023-01-05 10:40:30','2023-01-05 10:40:30'),(1287,7851,498,40719,11,15,353,1,2954.80,NULL,'2022-12-21 13:26:16','2023-01-05 10:40:30','2023-01-05 10:40:30'),(1288,7851,498,40719,11,15,354,1,1175.12,NULL,'2022-12-21 13:26:16','2023-01-05 10:40:30','2023-01-05 10:40:30'),(1289,7851,498,40719,11,15,136,2,1783.75,NULL,'2022-12-21 13:26:16','2023-01-05 10:40:30','2023-01-05 10:40:30'),(1290,7851,499,40719,12,15,67,1,170982.00,NULL,'2022-12-21 15:00:44','2023-01-05 10:40:04','2023-01-05 10:40:04'),(1291,7851,499,40719,12,15,68,2,111068.70,NULL,'2022-12-21 15:00:44','2023-01-05 10:40:04','2023-01-05 10:40:04'),(1292,7851,499,40719,12,15,353,2,2954.80,NULL,'2022-12-21 15:00:44','2023-01-05 10:40:04','2023-01-05 10:40:04'),(1293,7851,499,40719,12,15,354,2,1175.12,NULL,'2022-12-21 15:00:44','2023-01-05 10:40:04','2023-01-05 10:40:04'),(1294,7851,499,40719,12,15,74,2,53966.06,NULL,'2022-12-21 15:00:44','2023-01-05 10:40:04','2023-01-05 10:40:04'),(1295,7851,499,40719,12,15,136,2,1817.32,NULL,'2022-12-21 15:00:44','2023-01-05 10:40:04','2023-01-05 10:40:04'),(1296,7851,500,40719,14,21,73,1,39124.01,NULL,'2022-12-21 17:32:18','2023-02-01 00:32:01','2023-02-01 00:32:01'),(1297,7851,500,40719,14,21,163,2,39124.01,NULL,'2022-12-21 17:32:18','2023-02-01 00:32:01','2023-02-01 00:32:01'),(1298,7851,501,40719,14,19,516,2,28500.00,NULL,'2022-12-21 17:36:09','2022-12-21 17:36:25','2022-12-21 17:36:25'),(1299,7851,501,40719,14,19,482,1,28500.00,NULL,'2022-12-21 17:36:09','2022-12-21 17:36:25','2022-12-21 17:36:25'),(1300,7851,502,40719,14,19,516,2,28500.00,NULL,'2022-12-21 17:36:25','2022-12-21 17:36:25',NULL),(1301,7851,502,40719,14,19,482,1,28500.00,NULL,'2022-12-21 17:36:25','2022-12-21 17:36:25',NULL),(1302,7851,503,40719,14,19,487,2,120000.00,NULL,'2022-12-21 17:38:07','2022-12-21 17:38:18','2022-12-21 17:38:18'),(1303,7851,503,40719,14,19,482,1,120000.00,NULL,'2022-12-21 17:38:07','2022-12-21 17:38:18','2022-12-21 17:38:18'),(1304,7851,504,40719,14,19,487,2,120000.00,NULL,'2022-12-21 17:38:18','2022-12-21 17:38:18',NULL),(1305,7851,504,40719,14,19,482,1,120000.00,NULL,'2022-12-21 17:38:18','2022-12-21 17:38:18',NULL),(1306,7851,505,40719,14,19,482,1,5090.56,NULL,'2022-12-21 17:50:52','2022-12-21 17:53:17','2022-12-21 17:53:17'),(1307,7851,505,40719,14,19,517,2,5090.56,NULL,'2022-12-21 17:50:52','2022-12-21 17:53:17','2022-12-21 17:53:17'),(1308,7851,506,40719,14,6,509,2,5090.56,NULL,'2022-12-21 17:52:59','2022-12-21 17:52:59',NULL),(1309,7851,506,40719,14,6,482,1,5090.56,NULL,'2022-12-21 17:52:59','2022-12-21 17:52:59',NULL),(1310,7851,507,40719,14,19,482,1,1272.64,NULL,'2022-12-21 17:53:17','2022-12-21 17:54:17','2022-12-21 17:54:17');
INSERT INTO `balance_libro_details` VALUES (1311,7851,507,40719,14,19,517,2,1272.64,NULL,'2022-12-21 17:53:17','2022-12-21 17:54:17','2022-12-21 17:54:17'),(1312,7851,508,40719,14,6,482,1,1272.64,NULL,'2022-12-21 17:54:17','2022-12-21 17:54:17',NULL),(1313,7851,508,40719,14,6,517,2,1272.64,NULL,'2022-12-21 17:54:17','2022-12-21 17:54:17',NULL),(1314,7851,509,40719,14,1,482,1,157063.24,NULL,'2022-12-21 18:33:23','2022-12-21 18:33:23',NULL),(1315,7851,509,40719,14,1,500,2,157063.24,NULL,'2022-12-21 18:33:23','2022-12-21 18:33:23',NULL),(1316,7851,510,40719,14,2,218,2,0.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:04:03','2022-12-24 01:04:03'),(1317,7851,510,40719,14,2,218,2,2064174.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:04:03','2022-12-24 01:04:03'),(1318,7851,510,40719,14,2,13,1,2064174.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:04:03','2022-12-24 01:04:03'),(1319,7851,511,40719,14,2,218,2,0.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:03:46','2022-12-24 01:03:46'),(1320,7851,511,40719,14,2,218,2,2064174.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:03:46','2022-12-24 01:03:46'),(1321,7851,511,40719,14,2,13,1,2064174.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:03:46','2022-12-24 01:03:46'),(1322,7851,512,40719,14,2,218,1,0.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:03:04','2022-12-24 01:03:04'),(1323,7851,512,40719,14,2,218,1,2064174.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:03:04','2022-12-24 01:03:04'),(1324,7851,512,40719,14,2,13,2,2064174.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:03:04','2022-12-24 01:03:04'),(1325,7851,513,40719,14,2,218,2,0.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:02:31','2022-12-24 01:02:31'),(1326,7851,513,40719,14,2,218,2,982940.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:02:31','2022-12-24 01:02:31'),(1327,7851,513,40719,14,2,13,1,982940.00,NULL,'2022-12-21 18:59:06','2022-12-24 01:02:31','2022-12-24 01:02:31'),(1328,7851,514,40719,14,3,491,2,50120.00,NULL,'2022-12-21 19:07:31','2022-12-21 19:07:31',NULL),(1329,7851,514,40719,14,3,518,1,50120.00,NULL,'2022-12-21 19:07:31','2022-12-21 19:07:31',NULL),(1330,7851,515,40719,14,3,491,2,25060.00,NULL,'2022-12-21 19:09:02','2022-12-21 19:09:02',NULL),(1331,7851,515,40719,14,3,518,1,25060.00,NULL,'2022-12-21 19:09:02','2022-12-21 19:09:02',NULL),(1332,7851,516,40719,14,3,491,2,40000.00,NULL,'2022-12-21 19:09:59','2022-12-21 19:09:59',NULL),(1333,7851,516,40719,14,3,518,1,40000.00,NULL,'2022-12-21 19:09:59','2022-12-21 19:09:59',NULL),(1334,7851,517,40719,14,21,163,2,40000.00,NULL,'2022-12-21 19:11:02','2022-12-21 19:11:02',NULL),(1335,7851,517,40719,14,21,491,1,40000.00,NULL,'2022-12-21 19:11:02','2022-12-21 19:11:02',NULL),(1336,7851,518,40719,14,21,163,2,25060.00,NULL,'2022-12-21 19:11:41','2022-12-21 19:11:41',NULL),(1337,7851,518,40719,14,21,491,1,25060.00,NULL,'2022-12-21 19:11:41','2022-12-21 19:11:41',NULL),(1338,7851,519,40719,14,21,163,2,50120.00,NULL,'2022-12-21 19:12:16','2022-12-21 19:12:16',NULL),(1339,7851,519,40719,14,21,491,1,50120.00,NULL,'2022-12-21 19:12:16','2022-12-21 19:12:16',NULL),(1340,7851,520,40719,14,19,163,1,154863.21,NULL,'2022-12-21 19:36:59','2022-12-21 19:36:59',NULL),(1341,7851,520,40719,14,19,482,2,154863.21,NULL,'2022-12-21 19:36:59','2022-12-21 19:36:59',NULL),(1342,7851,521,40719,13,19,484,1,50000.00,NULL,'2022-12-21 20:01:07','2022-12-21 20:01:07',NULL),(1343,7851,521,40719,13,19,483,2,50000.00,NULL,'2022-12-21 20:01:07','2022-12-21 20:01:07',NULL),(1344,7851,522,40719,13,19,489,1,15000.00,NULL,'2022-12-21 20:17:59','2022-12-21 20:17:59',NULL),(1345,7851,522,40719,13,19,484,2,15000.00,NULL,'2022-12-21 20:17:59','2022-12-21 20:17:59',NULL),(1346,7851,523,40719,14,3,217,1,991.74,NULL,'2022-12-21 20:31:26','2022-12-21 20:31:54','2022-12-21 20:31:54'),(1347,7851,523,40719,14,3,68,1,208.26,NULL,'2022-12-21 20:31:26','2022-12-21 20:31:54','2022-12-21 20:31:54'),(1348,7851,523,40719,14,3,57,2,1200.00,NULL,'2022-12-21 20:31:26','2022-12-21 20:31:54','2022-12-21 20:31:54');
INSERT INTO `balance_libro_details` VALUES (1349,7851,524,40719,14,3,217,1,971.07,NULL,'2022-12-21 20:31:26','2022-12-21 20:32:11','2022-12-21 20:32:11'),(1350,7851,524,40719,14,3,68,1,203.93,NULL,'2022-12-21 20:31:26','2022-12-21 20:32:11','2022-12-21 20:32:11'),(1351,7851,524,40719,14,3,57,2,1175.00,NULL,'2022-12-21 20:31:26','2022-12-21 20:32:11','2022-12-21 20:32:11'),(1352,7851,525,40719,14,3,217,1,1284.71,NULL,'2022-12-21 20:31:26','2022-12-21 20:31:26',NULL),(1353,7851,525,40719,14,3,68,1,346.87,NULL,'2022-12-21 20:31:26','2022-12-21 20:31:26',NULL),(1354,7851,525,40719,14,3,57,2,1631.58,NULL,'2022-12-21 20:31:26','2022-12-21 20:31:26',NULL),(1355,7851,526,40719,14,3,217,1,9600.99,NULL,'2022-12-21 20:31:26','2023-01-05 10:05:33','2023-01-05 10:05:33'),(1356,7851,526,40719,14,3,68,1,2531.97,NULL,'2022-12-21 20:31:26','2023-01-05 10:05:33','2023-01-05 10:05:33'),(1357,7851,526,40719,14,3,217,1,740.45,NULL,'2022-12-21 20:31:26','2023-01-05 10:05:33','2023-01-05 10:05:33'),(1358,7851,526,40719,14,3,57,2,12873.41,NULL,'2022-12-21 20:31:26','2023-01-05 10:05:33','2023-01-05 10:05:33'),(1359,7851,527,40719,14,3,217,1,1330.58,NULL,'2022-12-21 20:31:26','2022-12-21 20:32:04','2022-12-21 20:32:04'),(1360,7851,527,40719,14,3,68,1,279.42,NULL,'2022-12-21 20:31:26','2022-12-21 20:32:04','2022-12-21 20:32:04'),(1361,7851,527,40719,14,3,57,2,1610.00,NULL,'2022-12-21 20:31:26','2022-12-21 20:32:04','2022-12-21 20:32:04'),(1362,7851,528,40719,14,21,57,1,2085.80,NULL,'2022-12-21 20:36:20','2022-12-21 20:36:20',NULL),(1363,7851,528,40719,14,21,163,2,2085.80,NULL,'2022-12-21 20:36:20','2022-12-21 20:36:20',NULL),(1364,7851,529,40719,14,21,163,2,7007.99,NULL,'2022-12-21 20:46:48','2023-02-12 22:19:52','2023-02-12 22:19:52'),(1365,7851,529,40719,14,21,531,1,7007.99,NULL,'2022-12-21 20:46:48','2023-02-12 22:19:52','2023-02-12 22:19:52'),(1366,7851,530,40719,14,3,217,1,268182.00,NULL,'2022-12-22 13:02:05','2022-12-22 13:02:05',NULL),(1367,7851,530,40719,14,3,68,1,56318.22,NULL,'2022-12-22 13:02:05','2022-12-22 13:02:05',NULL),(1368,7851,530,40719,14,3,57,2,324500.22,NULL,'2022-12-22 13:02:05','2022-12-22 13:02:05',NULL),(1369,7851,531,40719,14,21,57,1,324500.22,NULL,'2022-12-22 15:38:21','2023-01-04 23:08:19','2023-01-04 23:08:19'),(1370,7851,531,40719,14,21,515,2,186500.22,NULL,'2022-12-22 15:38:21','2023-01-04 23:08:19','2023-01-04 23:08:19'),(1371,7851,531,40719,14,21,482,2,138000.00,NULL,'2022-12-22 15:38:21','2023-01-04 23:08:19','2023-01-04 23:08:19'),(1372,7851,532,40719,14,21,57,1,8851.49,NULL,'2022-12-22 18:03:21','2022-12-22 18:03:21',NULL),(1373,7851,532,40719,14,21,488,2,8851.49,NULL,'2022-12-22 18:03:21','2022-12-22 18:03:21',NULL),(1374,7851,533,40719,14,21,57,1,6680.66,NULL,'2022-12-22 18:04:39','2023-04-01 18:50:32','2023-04-01 18:50:32'),(1375,7851,533,40719,14,21,488,2,6680.66,NULL,'2022-12-22 18:04:39','2023-04-01 18:50:32','2023-04-01 18:50:32'),(1376,7851,534,40719,14,3,519,1,5708.40,NULL,'2022-12-22 18:09:21','2022-12-22 18:09:21',NULL),(1377,7851,534,40719,14,3,68,1,1198.76,NULL,'2022-12-22 18:09:21','2022-12-22 18:09:21',NULL),(1378,7851,534,40719,14,3,221,1,492.85,NULL,'2022-12-22 18:09:21','2022-12-22 18:09:21',NULL),(1379,7851,534,40719,14,3,57,2,7400.01,NULL,'2022-12-22 18:09:21','2022-12-22 18:09:21',NULL),(1380,7851,535,40719,14,21,57,1,7400.01,NULL,'2022-12-22 18:10:47','2022-12-22 18:10:47',NULL),(1381,7851,535,40719,14,21,482,2,7400.01,NULL,'2022-12-22 18:10:47','2022-12-22 18:10:47',NULL),(1382,7851,536,40719,14,21,482,2,3820.00,NULL,'2022-12-22 18:14:08','2022-12-22 18:14:08',NULL),(1383,7851,536,40719,14,21,495,1,3820.00,NULL,'2022-12-22 18:14:08','2022-12-22 18:14:08',NULL),(1384,7851,537,40719,14,21,482,2,6900.00,NULL,'2022-12-22 18:16:37','2022-12-22 18:16:37',NULL),(1385,7851,537,40719,14,21,495,1,6900.00,NULL,'2022-12-22 18:16:37','2022-12-22 18:16:37',NULL),(1386,7851,538,40719,14,21,482,2,8386.56,NULL,'2022-12-22 18:18:33','2023-03-03 11:42:42','2023-03-03 11:42:42');
INSERT INTO `balance_libro_details` VALUES (1387,7851,538,40719,14,21,505,1,8386.56,NULL,'2022-12-22 18:18:33','2023-03-03 11:42:42','2023-03-03 11:42:42'),(1388,7851,539,40719,14,21,506,1,1856.72,NULL,'2022-12-22 18:24:47','2022-12-22 18:26:27','2022-12-22 18:26:27'),(1389,7851,539,40719,14,21,482,2,1856.72,NULL,'2022-12-22 18:24:47','2022-12-22 18:26:27','2022-12-22 18:26:27'),(1390,7851,540,40719,14,21,482,2,899.96,NULL,'2022-12-22 18:26:13','2022-12-22 18:26:36','2022-12-22 18:26:36'),(1391,7851,540,40719,14,21,507,1,899.96,NULL,'2022-12-22 18:26:13','2022-12-22 18:26:36','2022-12-22 18:26:36'),(1392,7851,541,40719,14,21,506,1,1856.72,NULL,'2022-12-22 18:26:27','2023-01-04 23:47:12','2023-01-04 23:47:12'),(1393,7851,541,40719,14,21,482,2,1856.72,NULL,'2022-12-22 18:26:27','2023-01-04 23:47:12','2023-01-04 23:47:12'),(1394,7851,542,40719,14,21,482,2,899.96,NULL,'2022-12-22 18:26:36','2023-01-04 23:19:44','2023-01-04 23:19:44'),(1395,7851,542,40719,14,21,507,1,899.96,NULL,'2022-12-22 18:26:36','2023-01-04 23:19:44','2023-01-04 23:19:44'),(1396,7851,543,40719,14,21,498,1,4987.00,NULL,'2022-12-22 18:27:53','2022-12-22 18:27:53',NULL),(1397,7851,543,40719,14,21,482,2,4987.00,NULL,'2022-12-22 18:27:53','2022-12-22 18:27:53',NULL),(1398,7851,544,40719,14,19,534,1,124000.00,NULL,'2022-12-22 19:06:30','2022-12-22 19:06:30',NULL),(1399,7851,544,40719,14,19,163,2,124000.00,NULL,'2022-12-22 19:06:30','2022-12-22 19:06:30',NULL),(1400,7851,545,40719,14,19,163,2,31000.00,NULL,'2022-12-22 19:07:32','2022-12-22 19:07:32',NULL),(1401,7851,545,40719,14,19,535,1,31000.00,NULL,'2022-12-22 19:07:32','2022-12-22 19:07:32',NULL),(1402,7851,546,40719,14,3,519,1,42446.28,NULL,'2022-12-24 00:49:01','2022-12-24 00:49:01',NULL),(1403,7851,546,40719,14,3,68,1,8913.72,NULL,'2022-12-24 00:49:01','2022-12-24 00:49:01',NULL),(1404,7851,546,40719,14,3,57,2,51360.00,NULL,'2022-12-24 00:49:01','2022-12-24 00:49:01',NULL),(1405,7851,547,40719,14,3,520,1,2239.91,NULL,'2022-12-24 00:50:33','2022-12-24 00:54:39','2022-12-24 00:54:39'),(1406,7851,547,40719,14,3,68,1,470.38,NULL,'2022-12-24 00:50:33','2022-12-24 00:54:39','2022-12-24 00:54:39'),(1407,7851,547,40719,14,3,221,1,289.71,NULL,'2022-12-24 00:50:33','2022-12-24 00:54:39','2022-12-24 00:54:39'),(1408,7851,547,40719,14,3,57,2,3000.00,NULL,'2022-12-24 00:50:33','2022-12-24 00:54:39','2022-12-24 00:54:39'),(1409,7851,548,40719,14,3,520,1,7722.60,NULL,'2022-12-24 00:51:31','2022-12-24 00:51:31',NULL),(1410,7851,548,40719,14,3,68,1,1621.75,NULL,'2022-12-24 00:51:31','2022-12-24 00:51:31',NULL),(1411,7851,548,40719,14,3,221,1,655.66,NULL,'2022-12-24 00:51:31','2022-12-24 00:51:31',NULL),(1412,7851,548,40719,14,3,57,2,10000.01,NULL,'2022-12-24 00:51:31','2022-12-24 00:51:31',NULL),(1413,7851,549,40719,14,3,520,1,14957.18,NULL,'2022-12-24 00:52:12','2022-12-24 00:52:12',NULL),(1414,7851,549,40719,14,3,68,1,3141.01,NULL,'2022-12-24 00:52:12','2022-12-24 00:52:12',NULL),(1415,7851,549,40719,14,3,221,1,1859.81,NULL,'2022-12-24 00:52:12','2022-12-24 00:52:12',NULL),(1416,7851,549,40719,14,3,57,2,19958.00,NULL,'2022-12-24 00:52:12','2022-12-24 00:52:12',NULL),(1417,7851,550,40719,14,3,519,1,6186.57,NULL,'2022-12-24 00:53:39','2022-12-24 00:53:39',NULL),(1418,7851,550,40719,14,3,68,1,1299.18,NULL,'2022-12-24 00:53:39','2022-12-24 00:53:39',NULL),(1419,7851,550,40719,14,3,221,1,594.25,NULL,'2022-12-24 00:53:39','2022-12-24 00:53:39',NULL),(1420,7851,550,40719,14,3,57,2,8080.00,NULL,'2022-12-24 00:53:39','2022-12-24 00:53:39',NULL),(1421,7851,551,40719,14,3,520,1,8777.28,NULL,'2022-12-24 00:54:25','2022-12-24 00:54:25',NULL),(1422,7851,551,40719,14,3,68,1,1843.23,NULL,'2022-12-24 00:54:25','2022-12-24 00:54:25',NULL),(1423,7851,551,40719,14,3,221,1,879.49,NULL,'2022-12-24 00:54:25','2022-12-24 00:54:25',NULL),(1424,7851,551,40719,14,3,57,2,11500.00,NULL,'2022-12-24 00:54:25','2022-12-24 00:54:25',NULL),(1425,7851,552,40719,14,3,519,1,2239.91,NULL,'2022-12-24 00:54:39','2022-12-24 00:54:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1426,7851,552,40719,14,3,68,1,470.38,NULL,'2022-12-24 00:54:39','2022-12-24 00:54:39',NULL),(1427,7851,552,40719,14,3,221,1,289.71,NULL,'2022-12-24 00:54:39','2022-12-24 00:54:39',NULL),(1428,7851,552,40719,14,3,57,2,3000.00,NULL,'2022-12-24 00:54:39','2022-12-24 00:54:39',NULL),(1429,7851,553,40719,14,2,96,2,889538.46,NULL,'2022-12-24 01:02:31','2022-12-24 01:04:35','2022-12-24 01:04:35'),(1430,7851,553,40719,14,2,67,2,93401.54,NULL,'2022-12-24 01:02:31','2022-12-24 01:04:35','2022-12-24 01:04:35'),(1431,7851,553,40719,14,2,13,1,982940.00,NULL,'2022-12-24 01:02:31','2022-12-24 01:04:35','2022-12-24 01:04:35'),(1432,7851,554,40719,14,2,96,1,1868030.77,NULL,'2022-12-24 01:03:04','2022-12-24 01:04:28','2022-12-24 01:04:28'),(1433,7851,554,40719,14,2,68,1,196143.23,NULL,'2022-12-24 01:03:04','2022-12-24 01:04:28','2022-12-24 01:04:28'),(1434,7851,554,40719,14,2,13,2,2064174.00,NULL,'2022-12-24 01:03:04','2022-12-24 01:04:28','2022-12-24 01:04:28'),(1435,7851,555,40719,14,2,96,2,2064174.00,NULL,'2022-12-24 01:03:46','2022-12-24 01:04:20','2022-12-24 01:04:20'),(1436,7851,555,40719,14,2,67,2,216738.27,NULL,'2022-12-24 01:03:46','2022-12-24 01:04:20','2022-12-24 01:04:20'),(1437,7851,555,40719,14,2,13,1,2280912.27,NULL,'2022-12-24 01:03:46','2022-12-24 01:04:20','2022-12-24 01:04:20'),(1438,7851,556,40719,14,2,96,2,1868030.77,NULL,'2022-12-24 01:04:03','2022-12-24 01:04:03',NULL),(1439,7851,556,40719,14,2,67,2,196143.23,NULL,'2022-12-24 01:04:03','2022-12-24 01:04:03',NULL),(1440,7851,556,40719,14,2,13,1,2064174.00,NULL,'2022-12-24 01:04:03','2022-12-24 01:04:03',NULL),(1441,7851,557,40719,14,2,96,2,1868030.77,NULL,'2022-12-24 01:04:20','2022-12-24 01:04:20',NULL),(1442,7851,557,40719,14,2,67,2,196143.23,NULL,'2022-12-24 01:04:20','2022-12-24 01:04:20',NULL),(1443,7851,557,40719,14,2,13,1,2064174.00,NULL,'2022-12-24 01:04:20','2022-12-24 01:04:20',NULL),(1444,7851,558,40719,14,2,96,1,1868030.77,NULL,'2022-12-24 01:04:28','2022-12-24 01:04:28',NULL),(1445,7851,558,40719,14,2,68,1,196143.23,NULL,'2022-12-24 01:04:28','2022-12-24 01:04:28',NULL),(1446,7851,558,40719,14,2,13,2,2064174.00,NULL,'2022-12-24 01:04:28','2022-12-24 01:04:28',NULL),(1447,7851,559,40719,14,2,96,2,889538.46,NULL,'2022-12-24 01:04:35','2022-12-30 19:06:11','2022-12-30 19:06:11'),(1448,7851,559,40719,14,2,67,2,93401.54,NULL,'2022-12-24 01:04:35','2022-12-30 19:06:11','2022-12-30 19:06:11'),(1449,7851,559,40719,14,2,13,1,982940.00,NULL,'2022-12-24 01:04:35','2022-12-30 19:06:11','2022-12-30 19:06:11'),(1450,7851,560,40719,14,21,497,1,40000.00,NULL,'2022-12-24 19:41:56','2022-12-24 19:41:56',NULL),(1451,7851,560,40719,14,21,482,2,40000.00,NULL,'2022-12-24 19:41:56','2022-12-24 19:41:56',NULL),(1452,7851,561,40719,14,21,497,1,10000.00,NULL,'2022-12-24 19:42:28','2022-12-24 19:42:28',NULL),(1453,7851,561,40719,14,21,482,2,10000.00,NULL,'2022-12-24 19:42:28','2022-12-24 19:42:28',NULL),(1454,7851,562,40719,14,20,13,2,10000.01,NULL,'2022-12-24 19:57:16','2022-12-24 19:57:23','2022-12-24 19:57:23'),(1455,7851,562,40719,14,20,484,1,10000.01,NULL,'2022-12-24 19:57:16','2022-12-24 19:57:23','2022-12-24 19:57:23'),(1456,7851,563,40719,14,21,57,1,10000.01,NULL,'2022-12-24 19:57:53','2022-12-24 19:57:53',NULL),(1457,7851,563,40719,14,21,484,2,10000.01,NULL,'2022-12-24 19:57:53','2022-12-24 19:57:53',NULL),(1458,7851,564,40719,14,21,57,1,19958.00,NULL,'2022-12-24 19:58:34','2022-12-24 19:58:34',NULL),(1459,7851,564,40719,14,21,484,2,19958.00,NULL,'2022-12-24 19:58:34','2022-12-24 19:58:34',NULL),(1460,7851,565,40719,14,21,57,1,11500.00,NULL,'2022-12-24 20:19:09','2022-12-24 20:19:09',NULL),(1461,7851,565,40719,14,21,488,2,11500.00,NULL,'2022-12-24 20:19:09','2022-12-24 20:19:09',NULL),(1462,7851,566,40719,14,21,57,1,8080.00,NULL,'2022-12-24 20:20:34','2022-12-24 20:20:34',NULL),(1463,7851,566,40719,14,21,488,2,8080.00,NULL,'2022-12-24 20:20:34','2022-12-24 20:20:34',NULL),(1464,7851,567,40719,14,21,57,1,7400.01,NULL,'2022-12-24 20:22:41','2022-12-24 20:23:48','2022-12-24 20:23:48');
INSERT INTO `balance_libro_details` VALUES (1465,7851,567,40719,14,21,488,2,7400.01,NULL,'2022-12-24 20:22:41','2022-12-24 20:23:48','2022-12-24 20:23:48'),(1466,7851,568,40719,14,21,57,1,7400.01,NULL,'2022-12-24 20:26:30','2022-12-24 20:26:46','2022-12-24 20:26:46'),(1467,7851,568,40719,14,21,488,2,7400.01,NULL,'2022-12-24 20:26:30','2022-12-24 20:26:46','2022-12-24 20:26:46'),(1468,7851,569,40719,14,21,57,1,3000.00,NULL,'2022-12-24 20:29:32','2022-12-24 20:29:32',NULL),(1469,7851,569,40719,14,21,488,2,3000.00,NULL,'2022-12-24 20:29:32','2022-12-24 20:29:32',NULL),(1470,7851,570,40719,14,21,57,1,51360.00,NULL,'2022-12-24 20:33:27','2023-01-04 23:06:35','2023-01-04 23:06:35'),(1471,7851,570,40719,14,21,515,2,51360.00,NULL,'2022-12-24 20:33:27','2023-01-04 23:06:35','2023-01-04 23:06:35'),(1472,7851,571,40719,14,21,57,1,224850.02,NULL,'2022-12-24 20:37:01','2022-12-24 20:37:18','2022-12-24 20:37:18'),(1473,7851,571,40719,14,21,514,2,224850.02,NULL,'2022-12-24 20:37:01','2022-12-24 20:37:18','2022-12-24 20:37:18'),(1474,7851,572,40719,12,21,57,1,224850.02,NULL,'2022-12-24 20:37:48','2023-01-04 23:00:50','2023-01-04 23:00:50'),(1475,7851,572,40719,12,21,514,2,224850.02,NULL,'2022-12-24 20:37:48','2023-01-04 23:00:50','2023-01-04 23:00:50'),(1476,7851,573,40719,14,21,57,1,719.70,NULL,'2022-12-24 20:38:43','2022-12-24 20:38:43',NULL),(1477,7851,573,40719,14,21,488,2,719.70,NULL,'2022-12-24 20:38:43','2022-12-24 20:38:43',NULL),(1478,7851,574,40719,11,21,57,1,7350.01,NULL,'2022-12-24 20:43:13','2022-12-24 20:43:13',NULL),(1479,7851,574,40719,11,21,488,2,7350.01,NULL,'2022-12-24 20:43:13','2022-12-24 20:43:13',NULL),(1480,7851,575,40719,14,3,519,1,4296.25,NULL,'2022-12-26 22:52:54','2022-12-26 22:52:54',NULL),(1481,7851,575,40719,14,3,68,1,902.21,NULL,'2022-12-26 22:52:54','2022-12-26 22:52:54',NULL),(1482,7851,575,40719,14,3,221,1,345.73,NULL,'2022-12-26 22:52:54','2022-12-26 22:52:54',NULL),(1483,7851,575,40719,14,3,57,2,5544.19,NULL,'2022-12-26 22:52:54','2022-12-26 22:52:54',NULL),(1484,7851,576,40719,14,21,57,1,5544.19,NULL,'2022-12-26 22:53:32','2022-12-26 22:53:32',NULL),(1485,7851,576,40719,14,21,488,2,5544.19,NULL,'2022-12-26 22:53:32','2022-12-26 22:53:32',NULL),(1486,7851,577,40719,14,21,57,1,12873.41,NULL,'2022-12-27 20:59:15','2023-01-05 10:04:17','2023-01-05 10:04:17'),(1487,7851,577,40719,14,21,163,2,12873.41,NULL,'2022-12-27 20:59:15','2023-01-05 10:04:17','2023-01-05 10:04:17'),(1488,7851,578,40719,14,21,57,1,3188.24,NULL,'2022-12-27 21:00:17','2022-12-27 21:00:17',NULL),(1489,7851,578,40719,14,21,163,2,3188.24,NULL,'2022-12-27 21:00:17','2022-12-27 21:00:17',NULL),(1490,7851,579,40719,14,21,163,2,506.92,NULL,'2022-12-27 21:01:52','2022-12-27 21:01:52',NULL),(1491,7851,579,40719,14,21,198,1,506.92,NULL,'2022-12-27 21:01:52','2022-12-27 21:01:52',NULL),(1492,7851,580,40719,14,2,538,2,90950.00,NULL,'2022-12-27 21:25:49','2022-12-27 21:26:52','2022-12-27 21:26:52'),(1493,7851,580,40719,14,2,482,1,90950.00,NULL,'2022-12-27 21:25:49','2022-12-27 21:26:52','2022-12-27 21:26:52'),(1494,7851,581,40719,14,2,482,1,90950.00,NULL,'2022-12-27 21:26:43','2022-12-27 21:26:43',NULL),(1495,7851,581,40719,14,2,539,2,90950.00,NULL,'2022-12-27 21:26:43','2022-12-27 21:26:43',NULL),(1496,7851,582,40719,14,2,538,2,90950.00,NULL,'2022-12-27 21:26:52','2022-12-27 21:26:52',NULL),(1497,7851,582,40719,14,2,482,1,90950.00,NULL,'2022-12-27 21:26:52','2022-12-27 21:26:52',NULL),(1498,7851,583,40719,14,3,198,1,4964.95,NULL,'2022-12-27 21:32:52','2022-12-27 21:32:52',NULL),(1499,7851,583,40719,14,3,68,1,1042.64,NULL,'2022-12-27 21:32:52','2022-12-27 21:32:52',NULL),(1500,7851,583,40719,14,3,198,1,1847.46,NULL,'2022-12-27 21:32:52','2022-12-27 21:32:52',NULL),(1501,7851,583,40719,14,3,220,1,148.95,NULL,'2022-12-27 21:32:52','2022-12-27 21:32:52',NULL),(1502,7851,583,40719,14,3,57,2,8004.00,NULL,'2022-12-27 21:32:52','2022-12-27 21:32:52',NULL),(1503,7851,584,40719,14,3,198,1,862.14,NULL,'2022-12-27 21:33:30','2022-12-27 21:33:30',NULL);
INSERT INTO `balance_libro_details` VALUES (1504,7851,584,40719,14,3,68,1,181.05,NULL,'2022-12-27 21:33:30','2022-12-27 21:33:30',NULL),(1505,7851,584,40719,14,3,198,1,36.81,NULL,'2022-12-27 21:33:30','2022-12-27 21:33:30',NULL),(1506,7851,584,40719,14,3,57,2,1080.00,NULL,'2022-12-27 21:33:30','2022-12-27 21:33:30',NULL),(1507,7851,585,40719,14,3,527,1,9468.30,NULL,'2022-12-27 21:35:51','2022-12-27 21:36:44','2022-12-27 21:36:44'),(1508,7851,585,40719,14,3,68,1,1988.34,NULL,'2022-12-27 21:35:51','2022-12-27 21:36:44','2022-12-27 21:36:44'),(1509,7851,585,40719,14,3,527,1,1283.31,NULL,'2022-12-27 21:35:51','2022-12-27 21:36:44','2022-12-27 21:36:44'),(1510,7851,585,40719,14,3,220,1,284.05,NULL,'2022-12-27 21:35:51','2022-12-27 21:36:44','2022-12-27 21:36:44'),(1511,7851,585,40719,14,3,57,2,13024.00,NULL,'2022-12-27 21:35:51','2022-12-27 21:36:44','2022-12-27 21:36:44'),(1512,7851,586,40719,14,3,527,1,148.15,NULL,'2022-12-27 21:36:34','2022-12-27 21:36:34',NULL),(1513,7851,586,40719,14,3,68,1,31.11,NULL,'2022-12-27 21:36:34','2022-12-27 21:36:34',NULL),(1514,7851,586,40719,14,3,527,1,32.74,NULL,'2022-12-27 21:36:34','2022-12-27 21:36:34',NULL),(1515,7851,586,40719,14,3,57,2,212.00,NULL,'2022-12-27 21:36:34','2022-12-27 21:36:34',NULL),(1516,7851,587,40719,14,3,527,1,9468.30,NULL,'2022-12-27 21:36:44','2023-01-13 21:09:13','2023-01-13 21:09:13'),(1517,7851,587,40719,14,3,68,1,1988.34,NULL,'2022-12-27 21:36:44','2023-01-13 21:09:13','2023-01-13 21:09:13'),(1518,7851,587,40719,14,3,527,1,1283.31,NULL,'2022-12-27 21:36:44','2023-01-13 21:09:13','2023-01-13 21:09:13'),(1519,7851,587,40719,14,3,220,1,284.05,NULL,'2022-12-27 21:36:44','2023-01-13 21:09:13','2023-01-13 21:09:13'),(1520,7851,587,40719,14,3,57,2,13024.00,NULL,'2022-12-27 21:36:44','2023-01-13 21:09:13','2023-01-13 21:09:13'),(1521,7851,588,40719,14,3,519,1,9500.83,NULL,'2022-12-29 16:34:02','2022-12-29 16:34:02',NULL),(1522,7851,588,40719,14,3,68,1,1995.17,NULL,'2022-12-29 16:34:02','2022-12-29 16:34:02',NULL),(1523,7851,588,40719,14,3,57,2,11496.00,NULL,'2022-12-29 16:34:02','2022-12-29 16:34:02',NULL),(1524,7851,589,40719,14,3,519,1,5702.76,NULL,'2022-12-29 16:34:51','2022-12-29 16:34:51',NULL),(1525,7851,589,40719,14,3,68,1,1197.58,NULL,'2022-12-29 16:34:51','2022-12-29 16:34:51',NULL),(1526,7851,589,40719,14,3,237,1,114.06,NULL,'2022-12-29 16:34:51','2022-12-29 16:34:51',NULL),(1527,7851,589,40719,14,3,57,2,7014.40,NULL,'2022-12-29 16:34:51','2022-12-29 16:34:51',NULL),(1528,7851,590,40719,14,3,519,1,16350.43,NULL,'2022-12-29 16:35:23','2022-12-29 16:35:23',NULL),(1529,7851,590,40719,14,3,68,1,3433.59,NULL,'2022-12-29 16:35:23','2022-12-29 16:35:23',NULL),(1530,7851,590,40719,14,3,237,1,327.01,NULL,'2022-12-29 16:35:23','2022-12-29 16:35:23',NULL),(1531,7851,590,40719,14,3,57,2,20111.03,NULL,'2022-12-29 16:35:23','2022-12-29 16:35:23',NULL),(1532,7851,591,40719,14,21,57,1,33806.09,NULL,'2022-12-29 16:36:23','2022-12-29 16:36:23',NULL),(1533,7851,591,40719,14,21,488,2,33806.09,NULL,'2022-12-29 16:36:23','2022-12-29 16:36:23',NULL),(1534,7851,592,40719,14,21,57,1,11496.00,NULL,'2022-12-29 16:37:37','2023-01-04 23:04:57','2023-01-04 23:04:57'),(1535,7851,592,40719,14,21,514,2,11496.00,NULL,'2022-12-29 16:37:37','2023-01-04 23:04:57','2023-01-04 23:04:57'),(1536,7851,593,40719,14,19,482,2,103070.02,NULL,'2022-12-29 16:55:16','2022-12-29 16:55:32','2022-12-29 16:55:32'),(1537,7851,593,40719,14,19,495,1,103070.02,NULL,'2022-12-29 16:55:16','2022-12-29 16:55:32','2022-12-29 16:55:32'),(1538,7851,594,40719,14,19,482,2,103070.02,NULL,'2022-12-29 16:55:32','2022-12-29 16:55:46','2022-12-29 16:55:46'),(1539,7851,594,40719,14,19,495,1,103070.02,NULL,'2022-12-29 16:55:32','2022-12-29 16:55:46','2022-12-29 16:55:46'),(1540,7851,595,40719,14,21,482,2,103070.02,NULL,'2022-12-29 16:55:46','2022-12-29 16:55:46',NULL),(1541,7851,595,40719,14,21,495,1,103070.02,NULL,'2022-12-29 16:55:46','2022-12-29 16:55:46',NULL),(1542,7851,596,40719,14,21,498,1,2981.40,NULL,'2022-12-29 16:56:44','2022-12-29 16:56:44',NULL);
INSERT INTO `balance_libro_details` VALUES (1543,7851,596,40719,14,21,482,2,2981.40,NULL,'2022-12-29 16:56:44','2022-12-29 16:56:44',NULL),(1544,7851,597,40719,14,21,497,1,30000.00,NULL,'2022-12-29 16:57:23','2022-12-29 16:57:23',NULL),(1545,7851,597,40719,14,21,482,2,30000.00,NULL,'2022-12-29 16:57:23','2022-12-29 16:57:23',NULL),(1546,7851,598,40719,14,19,482,2,120000.00,NULL,'2022-12-29 17:38:11','2022-12-29 17:38:11',NULL),(1547,7851,598,40719,14,19,163,1,120000.00,NULL,'2022-12-29 17:38:11','2022-12-29 17:38:11',NULL),(1548,7851,599,40719,14,19,482,2,250000.00,NULL,'2022-12-29 17:38:37','2022-12-29 17:38:37',NULL),(1549,7851,599,40719,14,19,163,1,250000.00,NULL,'2022-12-29 17:38:37','2022-12-29 17:38:37',NULL),(1550,7851,600,40719,14,19,482,2,250000.00,NULL,'2022-12-29 17:38:37','2023-01-30 14:32:00','2023-01-30 14:32:00'),(1551,7851,600,40719,14,19,163,1,250000.00,NULL,'2022-12-29 17:38:37','2023-01-30 14:32:00','2023-01-30 14:32:00'),(1552,7851,601,40719,14,3,519,1,1864.74,NULL,'2022-12-30 15:55:21','2022-12-30 15:55:21',NULL),(1553,7851,601,40719,14,3,68,1,391.60,NULL,'2022-12-30 15:55:21','2022-12-30 15:55:21',NULL),(1554,7851,601,40719,14,3,221,1,243.66,NULL,'2022-12-30 15:55:21','2022-12-30 15:55:21',NULL),(1555,7851,601,40719,14,3,57,2,2500.00,NULL,'2022-12-30 15:55:21','2022-12-30 15:55:21',NULL),(1556,7851,602,40719,14,3,519,1,1531.30,NULL,'2022-12-30 15:56:35','2022-12-30 15:56:35',NULL),(1557,7851,602,40719,14,3,68,1,321.57,NULL,'2022-12-30 15:56:35','2022-12-30 15:56:35',NULL),(1558,7851,602,40719,14,3,221,1,147.09,NULL,'2022-12-30 15:56:35','2022-12-30 15:56:35',NULL),(1559,7851,602,40719,14,3,57,2,1999.96,NULL,'2022-12-30 15:56:35','2022-12-30 15:56:35',NULL),(1560,7851,603,40719,14,3,519,1,126818.18,NULL,'2022-12-30 15:57:45','2022-12-30 15:57:45',NULL),(1561,7851,603,40719,14,3,68,1,26631.82,NULL,'2022-12-30 15:57:45','2022-12-30 15:57:45',NULL),(1562,7851,603,40719,14,3,57,2,153450.00,NULL,'2022-12-30 15:57:45','2022-12-30 15:57:45',NULL),(1563,7851,604,40719,14,21,57,1,2500.00,NULL,'2022-12-30 16:00:14','2022-12-30 16:00:14',NULL),(1564,7851,604,40719,14,21,488,2,2500.00,NULL,'2022-12-30 16:00:14','2022-12-30 16:00:14',NULL),(1565,7851,605,40719,14,21,57,1,1999.96,NULL,'2022-12-30 16:00:47','2022-12-30 16:00:47',NULL),(1566,7851,605,40719,14,21,488,2,1999.96,NULL,'2022-12-30 16:00:47','2022-12-30 16:00:47',NULL),(1567,7851,606,40719,14,21,57,1,153450.00,NULL,'2022-12-30 16:01:13','2022-12-30 16:01:13',NULL),(1568,7851,606,40719,14,21,482,2,153450.00,NULL,'2022-12-30 16:01:13','2022-12-30 16:01:13',NULL),(1569,7851,607,40719,14,2,96,2,889538.46,NULL,'2022-12-30 19:06:11','2022-12-30 19:06:48','2022-12-30 19:06:48'),(1570,7851,607,40719,14,2,67,2,93401.54,NULL,'2022-12-30 19:06:11','2022-12-30 19:06:48','2022-12-30 19:06:48'),(1571,7851,607,40719,14,2,13,1,982940.00,NULL,'2022-12-30 19:06:11','2022-12-30 19:06:48','2022-12-30 19:06:48'),(1572,7851,608,40719,14,3,523,1,66115.70,NULL,'2022-12-31 13:06:39','2022-12-31 13:06:39',NULL),(1573,7851,608,40719,14,3,68,1,13884.30,NULL,'2022-12-31 13:06:39','2022-12-31 13:06:39',NULL),(1574,7851,608,40719,14,3,57,2,80000.00,NULL,'2022-12-31 13:06:39','2022-12-31 13:06:39',NULL),(1575,7851,609,40719,14,21,57,1,80000.00,NULL,'2022-12-31 13:07:25','2022-12-31 13:07:25',NULL),(1576,7851,609,40719,14,21,482,2,80000.00,NULL,'2022-12-31 13:07:25','2022-12-31 13:07:25',NULL),(1577,7851,610,40719,18,3,217,1,1870.51,NULL,'2023-01-02 10:14:07','2023-01-02 10:14:07',NULL),(1578,7851,610,40719,18,3,68,1,392.81,NULL,'2023-01-02 10:14:07','2023-01-02 10:14:07',NULL),(1579,7851,610,40719,18,3,221,1,236.68,NULL,'2023-01-02 10:14:07','2023-01-02 10:14:07',NULL),(1580,7851,610,40719,18,3,57,2,2500.00,NULL,'2023-01-02 10:14:07','2023-01-02 10:14:07',NULL),(1581,7851,611,40719,14,3,519,1,3719.01,NULL,'2023-01-02 10:15:58','2023-01-02 10:15:58',NULL),(1582,7851,611,40719,14,3,68,1,780.99,NULL,'2023-01-02 10:15:58','2023-01-02 10:15:58',NULL),(1583,7851,611,40719,14,3,57,2,4500.00,NULL,'2023-01-02 10:15:58','2023-01-02 10:15:58',NULL);
INSERT INTO `balance_libro_details` VALUES (1584,7851,612,40719,14,21,57,1,4500.00,NULL,'2023-01-02 10:16:41','2023-01-05 01:20:29','2023-01-05 01:20:29'),(1585,7851,612,40719,14,21,163,2,4500.00,NULL,'2023-01-02 10:16:41','2023-01-05 01:20:29','2023-01-05 01:20:29'),(1586,7851,613,40719,18,21,57,1,2500.00,NULL,'2023-01-02 10:17:10','2023-01-02 10:17:10',NULL),(1587,7851,613,40719,18,21,488,2,2500.00,NULL,'2023-01-02 10:17:10','2023-01-02 10:17:10',NULL),(1588,7851,614,40719,18,21,482,2,1449.99,NULL,'2023-01-04 19:55:41','2023-01-04 20:00:41','2023-01-04 20:00:41'),(1589,7851,614,40719,18,21,396,1,1449.99,NULL,'2023-01-04 19:55:41','2023-01-04 20:00:41','2023-01-04 20:00:41'),(1590,7851,615,40719,18,19,482,2,20000.00,NULL,'2023-01-04 19:56:40','2023-01-04 19:57:17','2023-01-04 19:57:17'),(1591,7851,615,40719,18,19,497,1,20000.00,NULL,'2023-01-04 19:56:40','2023-01-04 19:57:17','2023-01-04 19:57:17'),(1592,7851,616,40719,18,21,482,2,40000.00,NULL,'2023-01-04 19:57:09','2023-01-04 19:57:09',NULL),(1593,7851,616,40719,18,21,497,1,40000.00,NULL,'2023-01-04 19:57:09','2023-01-04 19:57:09',NULL),(1594,7851,617,40719,18,21,482,2,20000.00,NULL,'2023-01-04 19:57:17','2023-01-04 19:57:17',NULL),(1595,7851,617,40719,18,21,497,1,20000.00,NULL,'2023-01-04 19:57:17','2023-01-04 19:57:17',NULL),(1596,7851,618,40719,14,3,396,1,867.77,NULL,'2023-01-04 20:02:47','2023-01-04 20:04:50','2023-01-04 20:04:50'),(1597,7851,618,40719,14,3,68,1,182.23,NULL,'2023-01-04 20:02:47','2023-01-04 20:04:50','2023-01-04 20:04:50'),(1598,7851,618,40719,14,3,57,2,1050.00,NULL,'2023-01-04 20:02:47','2023-01-04 20:04:50','2023-01-04 20:04:50'),(1599,7851,619,40719,18,3,396,1,1198.34,NULL,'2023-01-04 20:04:04','2023-01-04 20:04:04',NULL),(1600,7851,619,40719,18,3,68,1,251.65,NULL,'2023-01-04 20:04:04','2023-01-04 20:04:04',NULL),(1601,7851,619,40719,18,3,57,2,1449.99,NULL,'2023-01-04 20:04:04','2023-01-04 20:04:04',NULL),(1602,7851,620,40719,14,3,396,1,867.77,NULL,'2023-01-04 20:04:50','2023-01-04 20:04:50',NULL),(1603,7851,620,40719,14,3,68,1,182.23,NULL,'2023-01-04 20:04:50','2023-01-04 20:04:50',NULL),(1604,7851,620,40719,14,3,57,2,1050.00,NULL,'2023-01-04 20:04:50','2023-01-04 20:04:50',NULL),(1605,7851,621,40719,14,21,57,1,1050.00,NULL,'2023-01-04 20:06:06','2023-01-04 20:06:06',NULL),(1606,7851,621,40719,14,21,482,2,1050.00,NULL,'2023-01-04 20:06:06','2023-01-04 20:06:06',NULL),(1607,7851,622,40719,18,21,57,1,1449.99,NULL,'2023-01-04 20:06:47','2023-01-30 13:22:53','2023-01-30 13:22:53'),(1608,7851,622,40719,18,21,163,2,1449.99,NULL,'2023-01-04 20:06:47','2023-01-30 13:22:53','2023-01-30 13:22:53'),(1609,7851,623,40719,14,3,217,1,991.74,NULL,'2023-01-04 21:02:04','2023-01-04 21:02:41','2023-01-04 21:02:41'),(1610,7851,623,40719,14,3,68,1,208.26,NULL,'2023-01-04 21:02:04','2023-01-04 21:02:41','2023-01-04 21:02:41'),(1611,7851,623,40719,14,3,57,2,1200.00,NULL,'2023-01-04 21:02:04','2023-01-04 21:02:41','2023-01-04 21:02:41'),(1612,7851,624,40719,14,3,217,1,971.07,NULL,'2023-01-04 21:02:04','2023-01-04 21:02:49','2023-01-04 21:02:49'),(1613,7851,624,40719,14,3,68,1,203.93,NULL,'2023-01-04 21:02:04','2023-01-04 21:02:49','2023-01-04 21:02:49'),(1614,7851,624,40719,14,3,57,2,1175.00,NULL,'2023-01-04 21:02:04','2023-01-04 21:02:49','2023-01-04 21:02:49'),(1615,7851,625,40719,14,3,217,1,1330.58,NULL,'2023-01-04 21:02:04','2023-01-04 21:02:44','2023-01-04 21:02:44'),(1616,7851,625,40719,14,3,68,1,279.42,NULL,'2023-01-04 21:02:04','2023-01-04 21:02:44','2023-01-04 21:02:44'),(1617,7851,625,40719,14,3,57,2,1610.00,NULL,'2023-01-04 21:02:04','2023-01-04 21:02:44','2023-01-04 21:02:44'),(1618,7851,626,40719,14,21,57,1,224850.02,NULL,'2023-01-04 23:01:53','2023-01-04 23:03:28','2023-01-04 23:03:28'),(1619,7851,626,40719,14,21,514,2,224850.02,NULL,'2023-01-04 23:01:53','2023-01-04 23:03:28','2023-01-04 23:03:28'),(1620,7851,627,40719,12,21,57,1,224850.02,NULL,'2023-01-04 23:04:13','2023-01-04 23:04:13',NULL),(1621,7851,627,40719,12,21,493,2,224850.02,NULL,'2023-01-04 23:04:13','2023-01-04 23:04:13',NULL);
INSERT INTO `balance_libro_details` VALUES (1622,7851,628,40719,14,21,57,1,11496.00,NULL,'2023-01-04 23:05:40','2023-01-04 23:05:40',NULL),(1623,7851,628,40719,14,21,493,2,11496.00,NULL,'2023-01-04 23:05:40','2023-01-04 23:05:40',NULL),(1624,7851,629,40719,14,21,57,1,324500.22,NULL,'2023-01-04 23:10:53','2023-01-04 23:10:53',NULL),(1625,7851,629,40719,14,21,494,2,186500.22,NULL,'2023-01-04 23:10:53','2023-01-04 23:10:53',NULL),(1626,7851,629,40719,14,21,482,2,138000.00,NULL,'2023-01-04 23:10:53','2023-01-04 23:10:53',NULL),(1627,7851,630,40719,14,21,57,1,51360.00,NULL,'2023-01-04 23:12:07','2023-01-04 23:12:07',NULL),(1628,7851,630,40719,14,21,494,2,51360.00,NULL,'2023-01-04 23:12:07','2023-01-04 23:12:07',NULL),(1629,7851,631,40719,13,21,482,2,899.96,NULL,'2023-01-04 23:17:50','2023-01-04 23:17:50',NULL),(1630,7851,631,40719,13,21,214,1,899.96,NULL,'2023-01-04 23:17:50','2023-01-04 23:17:50',NULL),(1631,7851,632,40719,13,3,495,1,899.96,NULL,'2023-01-04 23:19:09','2023-01-04 23:19:09',NULL),(1632,7851,632,40719,13,3,214,2,899.96,NULL,'2023-01-04 23:19:09','2023-01-04 23:19:09',NULL),(1633,7851,633,40719,14,21,482,2,899.96,NULL,'2023-01-04 23:19:44','2023-01-04 23:19:44',NULL),(1634,7851,633,40719,14,21,214,1,899.96,NULL,'2023-01-04 23:19:44','2023-01-04 23:19:44',NULL),(1635,7851,634,40719,11,21,214,2,899.96,NULL,'2023-01-04 23:34:16','2023-01-04 23:34:16',NULL),(1636,7851,634,40719,11,21,495,1,899.96,NULL,'2023-01-04 23:34:16','2023-01-04 23:34:16',NULL),(1637,7851,635,40719,12,21,214,2,900.15,NULL,'2023-01-04 23:37:05','2023-01-04 23:37:05',NULL),(1638,7851,635,40719,12,21,495,1,900.15,NULL,'2023-01-04 23:37:05','2023-01-04 23:37:05',NULL),(1639,7851,636,40719,14,21,214,2,899.96,NULL,'2023-01-04 23:38:08','2023-01-04 23:38:08',NULL),(1640,7851,636,40719,14,21,495,1,899.96,NULL,'2023-01-04 23:38:08','2023-01-04 23:38:08',NULL),(1641,7851,637,40719,14,21,482,2,415.17,NULL,'2023-01-04 23:40:08','2023-01-04 23:40:08',NULL),(1642,7851,637,40719,14,21,396,1,415.17,NULL,'2023-01-04 23:40:08','2023-01-04 23:40:08',NULL),(1643,7851,638,40719,14,21,482,2,1856.72,NULL,'2023-01-04 23:47:12','2023-01-04 23:47:12',NULL),(1644,7851,638,40719,14,21,212,1,1856.72,NULL,'2023-01-04 23:47:12','2023-01-04 23:47:12',NULL),(1645,7851,639,40719,13,3,495,1,1856.72,NULL,'2023-01-04 23:47:55','2023-01-04 23:49:49','2023-01-04 23:49:49'),(1646,7851,639,40719,13,3,212,2,1856.72,NULL,'2023-01-04 23:47:55','2023-01-04 23:49:49','2023-01-04 23:49:49'),(1647,7851,640,40719,13,21,482,2,1856.72,NULL,'2023-01-04 23:48:26','2023-01-04 23:48:26',NULL),(1648,7851,640,40719,13,21,212,1,1856.72,NULL,'2023-01-04 23:48:26','2023-01-04 23:48:26',NULL),(1649,7851,641,40719,13,21,495,1,1856.72,NULL,'2023-01-04 23:49:49','2023-01-04 23:49:49',NULL),(1650,7851,641,40719,13,21,212,2,1856.72,NULL,'2023-01-04 23:49:49','2023-01-04 23:49:49',NULL),(1651,7851,642,40719,11,21,495,1,2504.97,NULL,'2023-01-04 23:52:36','2023-01-04 23:52:36',NULL),(1652,7851,642,40719,11,21,212,2,2504.97,NULL,'2023-01-04 23:52:36','2023-01-04 23:52:36',NULL),(1653,7851,643,40719,12,21,495,1,1859.94,NULL,'2023-01-04 23:57:21','2023-01-04 23:57:21',NULL),(1654,7851,643,40719,12,21,212,2,1859.94,NULL,'2023-01-04 23:57:21','2023-01-04 23:57:21',NULL),(1655,7851,644,40719,14,21,482,2,1452.30,NULL,'2023-01-04 23:58:24','2023-01-04 23:58:24',NULL),(1656,7851,644,40719,14,21,396,1,1452.30,NULL,'2023-01-04 23:58:24','2023-01-04 23:58:24',NULL),(1657,7851,645,40719,14,21,495,1,1856.72,NULL,'2023-01-04 23:59:18','2023-01-04 23:59:18',NULL),(1658,7851,645,40719,14,21,212,2,1856.72,NULL,'2023-01-04 23:59:18','2023-01-04 23:59:18',NULL),(1659,7851,646,40719,12,21,57,1,5944.63,NULL,'2023-01-05 00:28:13','2023-01-05 00:28:13',NULL),(1660,7851,646,40719,12,21,493,2,5944.63,NULL,'2023-01-05 00:28:13','2023-01-05 00:28:13',NULL),(1661,7851,647,40719,14,21,57,1,4500.00,NULL,'2023-01-05 01:21:01','2023-01-05 01:21:01',NULL),(1662,7851,647,40719,14,21,493,2,4500.00,NULL,'2023-01-05 01:21:01','2023-01-05 01:21:01',NULL);
INSERT INTO `balance_libro_details` VALUES (1663,7851,648,40719,12,21,57,1,39998.99,NULL,'2023-01-05 01:41:53','2023-01-05 01:41:53',NULL),(1664,7851,648,40719,12,21,494,2,39998.99,NULL,'2023-01-05 01:41:53','2023-01-05 01:41:53',NULL),(1665,7851,649,40719,14,3,120,1,700.52,NULL,'2023-01-05 01:49:08','2023-01-05 01:49:08',NULL),(1666,7851,649,40719,14,3,68,1,189.14,NULL,'2023-01-05 01:49:08','2023-01-05 01:49:08',NULL),(1667,7851,649,40719,14,3,57,2,889.66,NULL,'2023-01-05 01:49:08','2023-01-05 01:49:08',NULL),(1668,7851,650,40719,12,21,57,1,2370.72,NULL,'2023-01-05 01:54:19','2023-01-05 01:54:19',NULL),(1669,7851,650,40719,12,21,494,2,2370.72,NULL,'2023-01-05 01:54:19','2023-01-05 01:54:19',NULL),(1670,7851,651,40719,14,3,519,1,7739.37,NULL,'2023-01-05 01:58:11','2023-01-05 01:58:11',NULL),(1671,7851,651,40719,14,3,68,1,812.63,NULL,'2023-01-05 01:58:11','2023-01-05 01:58:11',NULL),(1672,7851,651,40719,14,3,57,2,8552.00,NULL,'2023-01-05 01:58:11','2023-01-05 01:58:11',NULL),(1673,7851,652,40719,14,3,519,1,6029.76,NULL,'2023-01-05 01:59:27','2023-01-05 01:59:27',NULL),(1674,7851,652,40719,14,3,68,1,1266.25,NULL,'2023-01-05 01:59:27','2023-01-05 01:59:27',NULL),(1675,7851,652,40719,14,3,57,2,7296.01,NULL,'2023-01-05 01:59:27','2023-01-05 01:59:27',NULL),(1676,7851,653,40719,14,21,57,1,15848.01,NULL,'2023-01-05 02:00:17','2023-01-05 02:00:17',NULL),(1677,7851,653,40719,14,21,494,2,15848.01,NULL,'2023-01-05 02:00:17','2023-01-05 02:00:17',NULL),(1678,7851,654,40719,12,21,57,1,19436.00,NULL,'2023-01-05 02:22:32','2023-01-05 20:53:00','2023-01-05 20:53:00'),(1679,7851,654,40719,12,21,527,2,19436.00,NULL,'2023-01-05 02:22:32','2023-01-05 20:53:00','2023-01-05 20:53:00'),(1680,7851,655,40719,14,21,527,2,4926.00,NULL,'2023-01-05 02:30:46','2023-01-05 02:31:55','2023-01-05 02:31:55'),(1681,7851,655,40719,14,21,494,1,4926.00,NULL,'2023-01-05 02:30:46','2023-01-05 02:31:55','2023-01-05 02:31:55'),(1682,7851,656,40719,14,21,527,2,4859.00,NULL,'2023-01-05 02:31:55','2023-01-05 02:38:40','2023-01-05 02:38:40'),(1683,7851,656,40719,14,21,494,1,4859.00,NULL,'2023-01-05 02:31:55','2023-01-05 02:38:40','2023-01-05 02:38:40'),(1684,7851,657,40719,14,21,527,1,67.00,NULL,'2023-01-05 02:33:45','2023-01-05 02:33:45',NULL),(1685,7851,657,40719,14,21,494,2,67.00,NULL,'2023-01-05 02:33:45','2023-01-05 02:33:45',NULL),(1686,7851,658,40719,14,21,527,1,4859.00,NULL,'2023-01-05 02:38:40','2023-01-05 02:38:40',NULL),(1687,7851,658,40719,14,21,494,2,4859.00,NULL,'2023-01-05 02:38:40','2023-01-05 02:38:40',NULL),(1688,7851,659,40719,14,2,509,2,2146.60,NULL,'2023-01-05 04:20:51','2023-01-05 04:21:16','2023-01-05 04:21:16'),(1689,7851,659,40719,14,2,482,1,2146.60,NULL,'2023-01-05 04:20:51','2023-01-05 04:21:16','2023-01-05 04:21:16'),(1690,7851,660,40719,14,2,509,2,2146.60,NULL,'2023-01-05 04:21:16','2023-01-30 23:28:39','2023-01-30 23:28:39'),(1691,7851,660,40719,14,2,482,1,2146.60,NULL,'2023-01-05 04:21:16','2023-01-30 23:28:39','2023-01-30 23:28:39'),(1692,7851,661,40719,14,3,217,1,8595.99,NULL,'2023-01-05 10:05:33','2023-01-30 15:02:54','2023-01-30 15:02:54'),(1693,7851,661,40719,14,3,68,1,2320.92,NULL,'2023-01-05 10:05:33','2023-01-30 15:02:54','2023-01-30 15:02:54'),(1694,7851,661,40719,14,3,217,1,1005.00,NULL,'2023-01-05 10:05:33','2023-01-30 15:02:54','2023-01-30 15:02:54'),(1695,7851,661,40719,14,3,68,1,211.05,NULL,'2023-01-05 10:05:33','2023-01-30 15:02:54','2023-01-30 15:02:54'),(1696,7851,661,40719,14,3,221,1,452.42,NULL,'2023-01-05 10:05:33','2023-01-30 15:02:54','2023-01-30 15:02:54'),(1697,7851,661,40719,14,3,237,1,288.03,NULL,'2023-01-05 10:05:33','2023-01-30 15:02:54','2023-01-30 15:02:54'),(1698,7851,661,40719,14,3,57,2,12873.41,NULL,'2023-01-05 10:05:33','2023-01-30 15:02:54','2023-01-30 15:02:54'),(1699,7851,662,40719,11,3,520,1,13515.88,NULL,'2023-01-05 11:13:25','2023-01-05 11:13:25',NULL),(1700,7851,662,40719,11,3,68,1,2838.33,NULL,'2023-01-05 11:13:25','2023-01-05 11:13:25',NULL),(1701,7851,662,40719,11,3,221,1,1645.79,NULL,'2023-01-05 11:13:25','2023-01-05 11:13:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1702,7851,662,40719,11,3,57,2,18000.00,NULL,'2023-01-05 11:13:26','2023-01-05 11:13:26',NULL),(1703,7851,663,40719,10,15,353,1,26924.00,NULL,'2023-01-05 11:20:07','2023-01-05 14:24:09','2023-01-05 14:24:09'),(1704,7851,663,40719,10,15,136,2,26924.00,NULL,'2023-01-05 11:20:07','2023-01-05 14:24:09','2023-01-05 14:24:09'),(1705,7851,664,40719,14,15,67,1,392286.46,NULL,'2023-01-05 12:15:47','2023-01-05 14:23:49','2023-01-05 14:23:49'),(1706,7851,664,40719,14,15,68,2,334556.86,NULL,'2023-01-05 12:15:47','2023-01-05 14:23:49','2023-01-05 14:23:49'),(1707,7851,664,40719,14,15,220,2,433.00,NULL,'2023-01-05 12:15:47','2023-01-05 14:23:49','2023-01-05 14:23:49'),(1708,7851,664,40719,14,15,74,2,55478.60,NULL,'2023-01-05 12:15:47','2023-01-05 14:23:49','2023-01-05 14:23:49'),(1709,7851,664,40719,14,15,136,2,1818.00,NULL,'2023-01-05 12:15:47','2023-01-05 14:23:49','2023-01-05 14:23:49'),(1710,7851,665,40719,13,15,67,1,170028.92,NULL,'2023-01-05 12:15:57','2023-01-05 14:23:56','2023-01-05 14:23:56'),(1711,7851,665,40719,13,15,68,2,129086.91,NULL,'2023-01-05 12:15:57','2023-01-05 14:23:56','2023-01-05 14:23:56'),(1712,7851,665,40719,13,15,74,2,39124.01,NULL,'2023-01-05 12:15:57','2023-01-05 14:23:56','2023-01-05 14:23:56'),(1713,7851,665,40719,13,15,136,2,1818.00,NULL,'2023-01-05 12:15:57','2023-01-05 14:23:56','2023-01-05 14:23:56'),(1714,7851,666,40719,12,15,67,1,170982.00,NULL,'2023-01-05 12:16:04','2023-01-05 14:24:25','2023-01-05 14:24:25'),(1715,7851,666,40719,12,15,68,2,111068.70,NULL,'2023-01-05 12:16:04','2023-01-05 14:24:25','2023-01-05 14:24:25'),(1716,7851,666,40719,12,15,353,2,2954.80,NULL,'2023-01-05 12:16:04','2023-01-05 14:24:25','2023-01-05 14:24:25'),(1717,7851,666,40719,12,15,354,2,1175.12,NULL,'2023-01-05 12:16:04','2023-01-05 14:24:25','2023-01-05 14:24:25'),(1718,7851,666,40719,12,15,74,2,53966.06,NULL,'2023-01-05 12:16:04','2023-01-05 14:24:25','2023-01-05 14:24:25'),(1719,7851,666,40719,12,15,136,2,1817.32,NULL,'2023-01-05 12:16:04','2023-01-05 14:24:25','2023-01-05 14:24:25'),(1720,7851,667,40719,11,15,67,1,68700.88,NULL,'2023-01-05 12:16:25','2023-01-05 14:24:30','2023-01-05 14:24:30'),(1721,7851,667,40719,11,15,68,2,43216.00,NULL,'2023-01-05 12:16:25','2023-01-05 14:24:30','2023-01-05 14:24:30'),(1722,7851,667,40719,11,15,353,2,26924.00,NULL,'2023-01-05 12:16:25','2023-01-05 14:24:30','2023-01-05 14:24:30'),(1723,7851,667,40719,11,15,220,2,1175.12,NULL,'2023-01-05 12:16:25','2023-01-05 14:24:30','2023-01-05 14:24:30'),(1724,7851,667,40719,11,15,353,1,2954.12,NULL,'2023-01-05 12:16:25','2023-01-05 14:24:30','2023-01-05 14:24:30'),(1725,7851,667,40719,11,15,354,1,1175.12,NULL,'2023-01-05 12:16:25','2023-01-05 14:24:30','2023-01-05 14:24:30'),(1726,7851,667,40719,11,15,136,2,1515.00,NULL,'2023-01-05 12:16:25','2023-01-05 14:24:30','2023-01-05 14:24:30'),(1727,7851,668,40719,13,3,520,1,13165.17,NULL,'2023-01-05 14:27:06','2023-01-05 14:27:06',NULL),(1728,7851,668,40719,13,3,68,1,2764.69,NULL,'2023-01-05 14:27:06','2023-01-05 14:27:06',NULL),(1729,7851,668,40719,13,3,221,1,1441.02,NULL,'2023-01-05 14:27:06','2023-01-05 14:27:06',NULL),(1730,7851,668,40719,13,3,57,2,17370.88,NULL,'2023-01-05 14:27:06','2023-01-05 14:27:06',NULL),(1731,7851,669,40719,13,21,57,1,17370.88,NULL,'2023-01-05 14:28:24','2023-01-05 14:28:24',NULL),(1732,7851,669,40719,13,21,484,2,17370.88,NULL,'2023-01-05 14:28:24','2023-01-05 14:28:24',NULL),(1733,7851,670,40719,13,21,57,1,10400.26,NULL,'2023-01-05 14:31:51','2023-01-05 14:32:10','2023-01-05 14:32:10'),(1734,7851,670,40719,13,21,482,2,10400.26,NULL,'2023-01-05 14:31:51','2023-01-05 14:32:10','2023-01-05 14:32:10'),(1735,7851,671,40719,13,3,520,1,7938.27,NULL,'2023-01-05 14:32:36','2023-01-05 14:44:48','2023-01-05 14:44:48'),(1736,7851,671,40719,13,3,68,1,1667.04,NULL,'2023-01-05 14:32:36','2023-01-05 14:44:48','2023-01-05 14:44:48'),(1737,7851,671,40719,13,3,221,1,794.95,NULL,'2023-01-05 14:32:36','2023-01-05 14:44:48','2023-01-05 14:44:48');
INSERT INTO `balance_libro_details` VALUES (1738,7851,671,40719,13,3,57,2,10400.26,NULL,'2023-01-05 14:32:36','2023-01-05 14:44:48','2023-01-05 14:44:48'),(1739,7851,672,40719,13,3,515,1,7938.27,NULL,'2023-01-05 14:44:48','2023-01-05 14:44:48',NULL),(1740,7851,672,40719,13,3,68,1,1667.04,NULL,'2023-01-05 14:44:48','2023-01-05 14:44:48',NULL),(1741,7851,672,40719,13,3,221,1,794.95,NULL,'2023-01-05 14:44:48','2023-01-05 14:44:48',NULL),(1742,7851,672,40719,13,3,57,2,10400.26,NULL,'2023-01-05 14:44:48','2023-01-05 14:44:48',NULL),(1743,7851,673,40719,13,21,57,1,10400.26,NULL,'2023-01-05 14:46:12','2023-01-05 14:46:12',NULL),(1744,7851,673,40719,13,21,482,2,10400.26,NULL,'2023-01-05 14:46:12','2023-01-05 14:46:12',NULL),(1745,7851,674,40719,12,3,520,1,11452.19,NULL,'2023-01-05 14:53:10','2023-01-05 14:53:10',NULL),(1746,7851,674,40719,12,3,68,1,2404.96,NULL,'2023-01-05 14:53:10','2023-01-05 14:53:10',NULL),(1747,7851,674,40719,12,3,520,1,1642.85,NULL,'2023-01-05 14:53:10','2023-01-05 14:53:10',NULL),(1748,7851,674,40719,12,3,57,2,15500.00,NULL,'2023-01-05 14:53:10','2023-01-05 14:53:10',NULL),(1749,7851,675,40719,12,21,57,1,15500.00,NULL,'2023-01-05 14:53:58','2023-01-05 14:53:58',NULL),(1750,7851,675,40719,12,21,484,2,15500.00,NULL,'2023-01-05 14:53:58','2023-01-05 14:53:58',NULL),(1751,7851,676,40719,12,3,120,1,7254.15,NULL,'2023-01-05 14:57:13','2023-01-05 14:57:13',NULL),(1752,7851,676,40719,12,3,68,1,1958.62,NULL,'2023-01-05 14:57:13','2023-01-05 14:57:13',NULL),(1753,7851,676,40719,12,3,120,1,400.00,NULL,'2023-01-05 14:57:13','2023-01-05 14:57:13',NULL),(1754,7851,676,40719,12,3,68,1,84.00,NULL,'2023-01-05 14:57:13','2023-01-05 14:57:13',NULL),(1755,7851,676,40719,12,3,221,1,381.79,NULL,'2023-01-05 14:57:13','2023-01-05 14:57:13',NULL),(1756,7851,676,40719,12,3,237,1,229.52,NULL,'2023-01-05 14:57:13','2023-01-05 14:57:13',NULL),(1757,7851,676,40719,12,3,57,2,10308.08,NULL,'2023-01-05 14:57:13','2023-01-05 14:57:13',NULL),(1758,7851,677,40719,12,21,57,1,10308.08,NULL,'2023-01-05 14:57:59','2023-01-05 14:57:59',NULL),(1759,7851,677,40719,12,21,482,2,10308.08,NULL,'2023-01-05 14:57:59','2023-01-05 14:57:59',NULL),(1760,7851,678,40719,12,3,515,1,1263.59,NULL,'2023-01-05 15:03:26','2023-01-05 15:03:26',NULL),(1761,7851,678,40719,12,3,68,1,265.35,NULL,'2023-01-05 15:03:26','2023-01-05 15:03:26',NULL),(1762,7851,678,40719,12,3,515,1,271.07,NULL,'2023-01-05 15:03:26','2023-01-05 15:03:26',NULL),(1763,7851,678,40719,12,3,57,2,1800.01,NULL,'2023-01-05 15:03:26','2023-01-05 15:03:26',NULL),(1764,7851,679,40719,12,21,57,1,1800.01,NULL,'2023-01-05 15:05:15','2023-01-05 15:05:15',NULL),(1765,7851,679,40719,12,21,488,2,1800.01,NULL,'2023-01-05 15:05:15','2023-01-05 15:05:15',NULL),(1766,7851,680,40719,12,21,57,1,6300.01,NULL,'2023-01-05 15:07:41','2023-01-05 15:07:54','2023-01-05 15:07:54'),(1767,7851,680,40719,12,21,488,2,6300.01,NULL,'2023-01-05 15:07:41','2023-01-05 15:07:54','2023-01-05 15:07:54'),(1768,7851,681,40719,12,3,507,1,4502.13,NULL,'2023-01-05 15:16:35','2023-01-05 15:16:35',NULL),(1769,7851,681,40719,12,3,68,1,945.45,NULL,'2023-01-05 15:16:35','2023-01-05 15:16:35',NULL),(1770,7851,681,40719,12,3,507,1,852.43,NULL,'2023-01-05 15:16:35','2023-01-05 15:16:35',NULL),(1771,7851,681,40719,12,3,57,2,6300.01,NULL,'2023-01-05 15:16:35','2023-01-05 15:16:35',NULL),(1772,7851,682,40719,12,21,57,1,6300.01,NULL,'2023-01-05 15:21:03','2023-01-05 15:21:03',NULL),(1773,7851,682,40719,12,21,488,2,6300.01,NULL,'2023-01-05 15:21:03','2023-01-05 15:21:03',NULL),(1774,7851,683,40719,12,3,524,1,1132.20,NULL,'2023-01-05 15:23:42','2023-01-05 15:23:42',NULL),(1775,7851,683,40719,12,3,68,1,237.76,NULL,'2023-01-05 15:23:42','2023-01-05 15:23:42',NULL),(1776,7851,683,40719,12,3,57,2,1369.96,NULL,'2023-01-05 15:23:42','2023-01-05 15:23:42',NULL),(1777,7851,684,40719,12,21,57,1,1369.96,NULL,'2023-01-05 15:25:09','2023-01-05 15:25:09',NULL),(1778,7851,684,40719,12,21,488,2,1369.96,NULL,'2023-01-05 15:25:09','2023-01-05 15:25:09',NULL);
INSERT INTO `balance_libro_details` VALUES (1779,7851,685,40719,12,3,515,1,5716.20,NULL,'2023-01-05 15:28:15','2023-01-05 15:28:15',NULL),(1780,7851,685,40719,12,3,68,1,1200.40,NULL,'2023-01-05 15:28:15','2023-01-05 15:28:15',NULL),(1781,7851,685,40719,12,3,515,1,1084.40,NULL,'2023-01-05 15:28:15','2023-01-05 15:28:15',NULL),(1782,7851,685,40719,12,3,57,2,8001.00,NULL,'2023-01-05 15:28:15','2023-01-05 15:28:15',NULL),(1783,7851,686,40719,12,21,57,1,8001.00,NULL,'2023-01-05 15:30:03','2023-01-05 15:30:03',NULL),(1784,7851,686,40719,12,21,488,2,8001.00,NULL,'2023-01-05 15:30:03','2023-01-05 15:30:03',NULL),(1785,7851,687,40719,13,3,515,1,1373.88,NULL,'2023-01-05 15:42:20','2023-01-05 15:42:20',NULL),(1786,7851,687,40719,13,3,68,1,288.51,NULL,'2023-01-05 15:42:20','2023-01-05 15:42:20',NULL),(1787,7851,687,40719,13,3,221,1,137.66,NULL,'2023-01-05 15:42:20','2023-01-05 15:42:20',NULL),(1788,7851,687,40719,13,3,57,2,1800.05,NULL,'2023-01-05 15:42:20','2023-01-05 15:42:20',NULL),(1789,7851,688,40719,13,3,515,1,1526.48,NULL,'2023-01-05 15:43:43','2023-01-05 15:43:43',NULL),(1790,7851,688,40719,13,3,68,1,320.56,NULL,'2023-01-05 15:43:43','2023-01-05 15:43:43',NULL),(1791,7851,688,40719,13,3,221,1,152.95,NULL,'2023-01-05 15:43:43','2023-01-05 15:43:43',NULL),(1792,7851,688,40719,13,3,57,2,1999.99,NULL,'2023-01-05 15:43:43','2023-01-05 15:43:43',NULL),(1793,7851,689,40719,13,3,520,1,9694.01,NULL,'2023-01-05 17:51:10','2023-01-05 17:51:10',NULL),(1794,7851,689,40719,13,3,68,1,2035.74,NULL,'2023-01-05 17:51:10','2023-01-05 17:51:10',NULL),(1795,7851,689,40719,13,3,221,1,971.35,NULL,'2023-01-05 17:51:10','2023-01-05 17:51:10',NULL),(1796,7851,689,40719,13,3,57,2,12701.10,NULL,'2023-01-05 17:51:10','2023-01-05 17:51:10',NULL),(1797,7851,690,40719,13,21,57,1,12701.10,NULL,'2023-01-05 17:51:41','2023-01-05 17:51:41',NULL),(1798,7851,690,40719,13,21,484,2,12701.10,NULL,'2023-01-05 17:51:41','2023-01-05 17:51:41',NULL),(1799,7851,691,40719,13,3,507,1,1144.86,NULL,'2023-01-05 17:52:38','2023-01-05 17:52:38',NULL),(1800,7851,691,40719,13,3,68,1,240.42,NULL,'2023-01-05 17:52:38','2023-01-05 17:52:38',NULL),(1801,7851,691,40719,13,3,221,1,114.72,NULL,'2023-01-05 17:52:38','2023-01-05 17:52:38',NULL),(1802,7851,691,40719,13,3,57,2,1500.00,NULL,'2023-01-05 17:52:38','2023-01-05 17:52:38',NULL),(1803,7851,692,40719,13,21,57,1,1500.00,NULL,'2023-01-05 17:53:28','2023-01-05 17:53:28',NULL),(1804,7851,692,40719,13,21,488,2,1500.00,NULL,'2023-01-05 17:53:28','2023-01-05 17:53:28',NULL),(1805,7851,693,40719,13,3,520,1,10418.09,NULL,'2023-01-05 17:55:29','2023-01-05 17:55:29',NULL),(1806,7851,693,40719,13,3,68,1,2187.80,NULL,'2023-01-05 17:55:29','2023-01-05 17:55:29',NULL),(1807,7851,693,40719,13,3,221,1,1295.41,NULL,'2023-01-05 17:55:29','2023-01-05 17:55:29',NULL),(1808,7851,693,40719,13,3,57,2,13901.30,NULL,'2023-01-05 17:55:29','2023-01-05 17:55:29',NULL),(1809,7851,694,40719,13,21,57,1,13901.30,NULL,'2023-01-05 17:56:02','2023-01-05 17:56:02',NULL),(1810,7851,694,40719,13,21,484,2,13901.30,NULL,'2023-01-05 17:56:02','2023-01-05 17:56:02',NULL),(1811,7851,695,40719,13,3,507,1,3747.16,NULL,'2023-01-05 17:58:01','2023-01-05 17:58:01',NULL),(1812,7851,695,40719,13,3,68,1,786.90,NULL,'2023-01-05 17:58:01','2023-01-05 17:58:01',NULL),(1813,7851,695,40719,13,3,221,1,465.93,NULL,'2023-01-05 17:58:01','2023-01-05 17:58:01',NULL),(1814,7851,695,40719,13,3,57,2,4999.99,NULL,'2023-01-05 17:58:01','2023-01-05 17:58:01',NULL),(1815,7851,696,40719,13,21,57,1,4999.99,NULL,'2023-01-05 17:58:30','2023-01-05 17:58:30',NULL),(1816,7851,696,40719,13,21,488,2,4999.99,NULL,'2023-01-05 17:58:30','2023-01-05 17:58:30',NULL),(1817,7851,697,40719,13,3,520,1,14239.23,NULL,'2023-01-05 17:59:57','2023-01-05 17:59:57',NULL),(1818,7851,697,40719,13,3,68,1,2990.24,NULL,'2023-01-05 17:59:57','2023-01-05 17:59:57',NULL),(1819,7851,697,40719,13,3,221,1,1770.54,NULL,'2023-01-05 17:59:57','2023-01-05 17:59:57',NULL),(1820,7851,697,40719,13,3,57,2,19000.01,NULL,'2023-01-05 17:59:57','2023-01-05 17:59:57',NULL);
INSERT INTO `balance_libro_details` VALUES (1821,7851,698,40719,13,21,57,1,19000.01,NULL,'2023-01-05 18:00:35','2023-01-05 18:00:35',NULL),(1822,7851,698,40719,13,21,484,2,19000.01,NULL,'2023-01-05 18:00:35','2023-01-05 18:00:35',NULL),(1823,7851,699,40719,13,3,507,1,4570.60,NULL,'2023-01-05 18:04:22','2023-01-05 18:04:22',NULL),(1824,7851,699,40719,13,3,68,1,959.83,NULL,'2023-01-05 18:04:22','2023-01-05 18:04:22',NULL),(1825,7851,699,40719,13,3,221,1,670.63,NULL,'2023-01-05 18:04:22','2023-01-05 18:04:22',NULL),(1826,7851,699,40719,13,3,57,2,6201.06,NULL,'2023-01-05 18:04:22','2023-01-05 18:04:22',NULL),(1827,7851,700,40719,13,3,489,1,20330.58,NULL,'2023-01-05 18:08:08','2023-01-05 18:08:08',NULL),(1828,7851,700,40719,13,3,68,1,4269.42,NULL,'2023-01-05 18:08:08','2023-01-05 18:08:08',NULL),(1829,7851,700,40719,13,3,57,2,24600.00,NULL,'2023-01-05 18:08:08','2023-01-05 18:08:08',NULL),(1830,7851,701,40719,13,3,489,1,9619.83,NULL,'2023-01-05 18:08:33','2023-01-05 18:08:33',NULL),(1831,7851,701,40719,13,3,68,1,2020.16,NULL,'2023-01-05 18:08:33','2023-01-05 18:08:33',NULL),(1832,7851,701,40719,13,3,57,2,11639.99,NULL,'2023-01-05 18:08:33','2023-01-05 18:08:33',NULL),(1833,7851,702,40719,13,21,57,1,36239.99,NULL,'2023-01-05 18:09:41','2023-01-05 18:09:41',NULL),(1834,7851,702,40719,13,21,482,2,36239.99,NULL,'2023-01-05 18:09:41','2023-01-05 18:09:41',NULL),(1835,7851,703,40719,13,3,515,1,5573.77,NULL,'2023-01-05 18:11:40','2023-01-05 18:11:40',NULL),(1836,7851,703,40719,13,3,68,1,1170.49,NULL,'2023-01-05 18:11:40','2023-01-05 18:11:40',NULL),(1837,7851,703,40719,13,3,221,1,558.50,NULL,'2023-01-05 18:11:40','2023-01-05 18:11:40',NULL),(1838,7851,703,40719,13,3,57,2,7302.76,NULL,'2023-01-05 18:11:40','2023-01-05 18:11:40',NULL),(1839,7851,704,40719,13,21,57,1,7302.76,NULL,'2023-01-05 18:12:07','2023-01-05 18:12:07',NULL),(1840,7851,704,40719,13,21,482,2,7302.76,NULL,'2023-01-05 18:12:07','2023-01-05 18:12:07',NULL),(1841,7851,705,40719,13,3,530,1,1421.49,NULL,'2023-01-05 18:44:52','2023-01-05 18:44:52',NULL),(1842,7851,705,40719,13,3,68,1,298.51,NULL,'2023-01-05 18:44:52','2023-01-05 18:44:52',NULL),(1843,7851,705,40719,13,3,530,1,180.00,NULL,'2023-01-05 18:44:52','2023-01-05 18:44:52',NULL),(1844,7851,705,40719,13,3,57,2,1900.00,NULL,'2023-01-05 18:44:52','2023-01-05 18:44:52',NULL),(1845,7851,706,40719,13,21,57,1,1900.00,NULL,'2023-01-05 18:45:27','2023-01-05 18:45:27',NULL),(1846,7851,706,40719,13,21,482,2,1900.00,NULL,'2023-01-05 18:45:27','2023-01-05 18:45:27',NULL),(1847,7851,707,40719,13,3,507,1,1069.52,NULL,'2023-01-05 18:50:30','2023-01-05 18:50:30',NULL),(1848,7851,707,40719,13,3,68,1,224.60,NULL,'2023-01-05 18:50:30','2023-01-05 18:50:30',NULL),(1849,7851,707,40719,13,3,221,1,205.88,NULL,'2023-01-05 18:50:30','2023-01-05 18:50:30',NULL),(1850,7851,707,40719,13,3,57,2,1500.00,NULL,'2023-01-05 18:50:30','2023-01-05 18:50:30',NULL),(1851,7851,708,40719,13,21,57,1,1500.00,NULL,'2023-01-05 18:51:07','2023-01-05 18:51:07',NULL),(1852,7851,708,40719,13,21,488,2,1500.00,NULL,'2023-01-05 18:51:07','2023-01-05 18:51:07',NULL),(1853,7851,709,40719,13,3,520,1,14089.34,NULL,'2023-01-05 18:52:41','2023-01-05 18:52:41',NULL),(1854,7851,709,40719,13,3,68,1,2958.76,NULL,'2023-01-05 18:52:41','2023-01-05 18:52:41',NULL),(1855,7851,709,40719,13,3,221,1,1751.90,NULL,'2023-01-05 18:52:41','2023-01-05 18:52:41',NULL),(1856,7851,709,40719,13,3,57,2,18800.00,NULL,'2023-01-05 18:52:41','2023-01-05 18:52:41',NULL),(1857,7851,710,40719,13,21,57,1,18800.00,NULL,'2023-01-05 18:53:12','2023-01-05 18:53:12',NULL),(1858,7851,710,40719,13,21,483,2,3800.00,NULL,'2023-01-05 18:53:12','2023-01-05 18:53:12',NULL),(1859,7851,710,40719,13,21,484,2,15000.00,NULL,'2023-01-05 18:53:12','2023-01-05 18:53:12',NULL),(1860,7851,711,40719,13,3,507,1,1123.71,NULL,'2023-01-05 18:53:52','2023-01-05 18:53:52',NULL),(1861,7851,711,40719,13,3,68,1,235.98,NULL,'2023-01-05 18:53:52','2023-01-05 18:53:52',NULL),(1862,7851,711,40719,13,3,221,1,140.33,NULL,'2023-01-05 18:53:52','2023-01-05 18:53:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1863,7851,711,40719,13,3,57,2,1500.02,NULL,'2023-01-05 18:53:52','2023-01-05 18:53:52',NULL),(1864,7851,712,40719,13,21,57,1,1500.00,NULL,'2023-01-05 18:55:25','2023-01-05 18:55:25',NULL),(1865,7851,712,40719,13,21,488,2,1500.00,NULL,'2023-01-05 18:55:25','2023-01-05 18:55:25',NULL),(1866,7851,713,40719,13,3,520,1,3052.97,NULL,'2023-01-05 18:55:59','2023-01-05 18:55:59',NULL),(1867,7851,713,40719,13,3,68,1,641.12,NULL,'2023-01-05 18:55:59','2023-01-05 18:55:59',NULL),(1868,7851,713,40719,13,3,221,1,305.91,NULL,'2023-01-05 18:55:59','2023-01-05 18:55:59',NULL),(1869,7851,713,40719,13,3,57,2,4000.00,NULL,'2023-01-05 18:55:59','2023-01-05 18:55:59',NULL),(1870,7851,714,40719,13,21,57,1,4000.00,NULL,'2023-01-05 18:56:41','2023-01-05 18:56:41',NULL),(1871,7851,714,40719,13,21,488,2,4000.00,NULL,'2023-01-05 18:56:41','2023-01-05 18:56:41',NULL),(1872,7851,715,40719,14,3,110,1,29880.00,NULL,'2023-01-05 19:01:06','2023-01-05 19:01:06',NULL),(1873,7851,715,40719,14,3,62,2,29880.00,NULL,'2023-01-05 19:01:06','2023-01-05 19:01:06',NULL),(1874,7851,716,40719,14,3,62,2,14940.00,NULL,'2023-01-05 19:02:48','2023-01-05 19:02:48',NULL),(1875,7851,716,40719,14,3,180,1,14940.00,NULL,'2023-01-05 19:02:48','2023-01-05 19:02:48',NULL),(1876,7851,717,40719,12,3,63,2,15226.95,NULL,'2023-01-05 19:13:55','2023-01-05 19:13:55',NULL),(1877,7851,717,40719,12,3,191,1,15226.95,NULL,'2023-01-05 19:13:55','2023-01-05 19:13:55',NULL),(1878,7851,718,40719,13,3,63,2,18801.15,NULL,'2023-01-05 19:14:35','2023-01-05 19:14:35',NULL),(1879,7851,718,40719,13,3,191,1,18801.15,NULL,'2023-01-05 19:14:35','2023-01-05 19:14:35',NULL),(1880,7851,719,40719,14,3,63,2,18801.15,NULL,'2023-01-05 19:15:28','2023-01-05 19:15:28',NULL),(1881,7851,719,40719,14,3,191,1,18801.15,NULL,'2023-01-05 19:15:28','2023-01-05 19:15:28',NULL),(1882,7851,720,40719,12,21,63,1,15226.95,NULL,'2023-01-05 19:18:52','2023-02-01 01:24:41','2023-02-01 01:24:41'),(1883,7851,720,40719,12,21,488,2,15226.95,NULL,'2023-01-05 19:18:52','2023-02-01 01:24:41','2023-02-01 01:24:41'),(1884,7851,721,40719,11,3,198,1,148.15,NULL,'2023-01-05 20:47:01','2023-01-05 20:47:01',NULL),(1885,7851,721,40719,11,3,68,1,31.11,NULL,'2023-01-05 20:47:01','2023-01-05 20:47:01',NULL),(1886,7851,721,40719,11,3,198,1,32.74,NULL,'2023-01-05 20:47:01','2023-01-05 20:47:01',NULL),(1887,7851,721,40719,11,3,57,2,212.00,NULL,'2023-01-05 20:47:01','2023-01-05 20:47:01',NULL),(1888,7851,722,40719,11,3,527,1,185.59,NULL,'2023-01-05 20:49:26','2023-01-05 20:49:46','2023-01-05 20:49:46'),(1889,7851,722,40719,11,3,68,1,38.97,NULL,'2023-01-05 20:49:26','2023-01-05 20:49:46','2023-01-05 20:49:46'),(1890,7851,722,40719,11,3,527,1,43.44,NULL,'2023-01-05 20:49:26','2023-01-05 20:49:46','2023-01-05 20:49:46'),(1891,7851,722,40719,11,3,57,2,268.00,NULL,'2023-01-05 20:49:26','2023-01-05 20:49:46','2023-01-05 20:49:46'),(1892,7851,723,40719,11,3,527,1,185.59,NULL,'2023-01-05 20:49:46','2023-01-05 20:49:46',NULL),(1893,7851,723,40719,11,3,68,1,38.97,NULL,'2023-01-05 20:49:46','2023-01-05 20:49:46',NULL),(1894,7851,723,40719,11,3,527,1,43.44,NULL,'2023-01-05 20:49:46','2023-01-05 20:49:46',NULL),(1895,7851,723,40719,11,3,57,2,268.00,NULL,'2023-01-05 20:49:46','2023-01-05 20:49:46',NULL),(1896,7851,724,40719,11,3,527,1,14229.22,NULL,'2023-01-05 20:53:18','2023-01-05 20:58:28','2023-01-05 20:58:28'),(1897,7851,724,40719,11,3,68,1,2988.14,NULL,'2023-01-05 20:53:18','2023-01-05 20:58:28','2023-01-05 20:58:28'),(1898,7851,724,40719,11,3,527,1,1791.76,NULL,'2023-01-05 20:53:18','2023-01-05 20:58:28','2023-01-05 20:58:28'),(1899,7851,724,40719,11,3,220,1,426.88,NULL,'2023-01-05 20:53:18','2023-01-05 20:58:28','2023-01-05 20:58:28'),(1900,7851,724,40719,11,3,57,2,19436.00,NULL,'2023-01-05 20:53:18','2023-01-05 20:58:28','2023-01-05 20:58:28'),(1901,7851,725,40719,11,3,527,1,14229.22,NULL,'2023-01-05 20:58:28','2023-01-05 20:58:28',NULL),(1902,7851,725,40719,11,3,68,1,2988.14,NULL,'2023-01-05 20:58:28','2023-01-05 20:58:28',NULL);
INSERT INTO `balance_libro_details` VALUES (1903,7851,725,40719,11,3,527,1,1791.76,NULL,'2023-01-05 20:58:28','2023-01-05 20:58:28',NULL),(1904,7851,725,40719,11,3,220,1,426.88,NULL,'2023-01-05 20:58:28','2023-01-05 20:58:28',NULL),(1905,7851,725,40719,11,3,57,2,19436.00,NULL,'2023-01-05 20:58:28','2023-01-05 20:58:28',NULL),(1906,7851,726,40719,14,21,57,1,10000.01,NULL,'2023-01-07 17:31:15','2023-01-07 17:31:15',NULL),(1907,7851,726,40719,14,21,484,2,10000.01,NULL,'2023-01-07 17:31:15','2023-01-07 17:31:15',NULL),(1908,7851,727,40719,3053,3,507,1,671.84,NULL,'2023-01-07 17:51:18','2023-01-07 17:51:18',NULL),(1909,7851,727,40719,3053,3,68,1,141.09,NULL,'2023-01-07 17:51:18','2023-01-07 17:51:18',NULL),(1910,7851,727,40719,3053,3,221,1,187.08,NULL,'2023-01-07 17:51:18','2023-01-07 17:51:18',NULL),(1911,7851,727,40719,3053,3,57,2,1000.01,NULL,'2023-01-07 17:51:18','2023-01-07 17:51:18',NULL),(1912,7851,728,40719,18,21,498,1,1094.00,NULL,'2023-01-09 16:23:50','2023-01-09 16:23:50',NULL),(1913,7851,728,40719,18,21,482,2,1094.00,NULL,'2023-01-09 16:23:50','2023-01-09 16:23:50',NULL),(1914,7851,729,40719,18,21,482,2,1842.50,NULL,'2023-01-09 16:28:33','2023-01-09 16:28:33',NULL),(1915,7851,729,40719,18,21,498,1,1842.50,NULL,'2023-01-09 16:28:33','2023-01-09 16:28:33',NULL),(1916,7851,730,40719,14,19,504,2,25000.00,NULL,'2023-01-09 16:29:48','2023-01-09 16:29:48',NULL),(1917,7851,730,40719,14,19,482,1,25000.00,NULL,'2023-01-09 16:29:48','2023-01-09 16:29:48',NULL),(1918,7851,731,40719,18,21,492,1,860.00,NULL,'2023-01-09 16:30:42','2023-01-09 16:30:42',NULL),(1919,7851,731,40719,18,21,482,2,860.00,NULL,'2023-01-09 16:30:42','2023-01-09 16:30:42',NULL),(1920,7851,732,40719,18,21,482,2,860.00,NULL,'2023-01-09 16:31:21','2023-01-09 16:31:21',NULL),(1921,7851,732,40719,18,21,492,1,860.00,NULL,'2023-01-09 16:31:21','2023-01-09 16:31:21',NULL),(1922,7851,733,40719,14,20,13,2,2064174.00,NULL,'2023-01-09 16:35:22','2023-01-09 16:35:22',NULL),(1923,7851,733,40719,14,20,482,1,1975252.46,NULL,'2023-01-09 16:35:22','2023-01-09 16:35:22',NULL),(1924,7851,733,40719,14,20,23,1,32880.62,NULL,'2023-01-09 16:35:22','2023-01-09 16:35:22',NULL),(1925,7851,733,40719,14,20,263,1,56040.92,NULL,'2023-01-09 16:35:22','2023-01-09 16:35:22',NULL),(1926,7851,734,40719,18,2,96,2,889538.46,NULL,'2023-01-09 16:38:21','2023-01-09 16:38:21',NULL),(1927,7851,734,40719,18,2,67,2,93401.54,NULL,'2023-01-09 16:38:21','2023-01-09 16:38:21',NULL),(1928,7851,734,40719,18,2,13,1,982940.00,NULL,'2023-01-09 16:38:21','2023-01-09 16:38:21',NULL),(1929,7851,735,40719,3,21,57,1,982940.00,NULL,'2023-01-09 17:20:27','2023-01-09 17:22:11','2023-01-09 17:22:11'),(1930,7851,735,40719,3,21,482,2,938463.09,NULL,'2023-01-09 17:20:27','2023-01-09 17:22:11','2023-01-09 17:22:11'),(1931,7851,735,40719,3,21,23,2,17790.76,NULL,'2023-01-09 17:20:27','2023-01-09 17:22:11','2023-01-09 17:22:11'),(1932,7851,735,40719,3,21,263,2,26686.15,NULL,'2023-01-09 17:20:27','2023-01-09 17:22:11','2023-01-09 17:22:11'),(1933,7851,736,40719,18,20,13,2,982940.00,NULL,'2023-01-09 17:24:34','2023-01-09 17:24:34',NULL),(1934,7851,736,40719,18,20,482,1,938463.09,NULL,'2023-01-09 17:24:34','2023-01-09 17:24:34',NULL),(1935,7851,736,40719,18,20,23,1,17790.76,NULL,'2023-01-09 17:24:34','2023-01-09 17:24:34',NULL),(1936,7851,736,40719,18,20,263,1,26686.15,NULL,'2023-01-09 17:24:34','2023-01-09 17:24:34',NULL),(1937,7851,737,40719,18,3,63,2,19145.67,NULL,'2023-01-09 17:39:03','2023-01-09 17:39:03',NULL),(1938,7851,737,40719,18,3,191,1,19145.67,NULL,'2023-01-09 17:39:03','2023-01-09 17:39:03',NULL),(1939,7851,738,40719,18,21,163,2,19145.67,NULL,'2023-01-09 17:39:37','2023-01-09 17:39:37',NULL),(1940,7851,738,40719,18,21,63,1,19145.67,NULL,'2023-01-09 17:39:37','2023-01-09 17:39:37',NULL),(1941,7851,739,40719,18,21,482,2,7625.00,NULL,'2023-01-09 19:35:34','2023-01-09 19:35:34',NULL),(1942,7851,739,40719,18,21,498,1,7625.00,NULL,'2023-01-09 19:35:34','2023-01-09 19:35:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1943,7851,740,40719,18,21,495,1,24000.00,NULL,'2023-01-12 19:14:42','2023-01-12 19:14:42',NULL),(1944,7851,740,40719,18,21,482,2,24000.00,NULL,'2023-01-12 19:14:42','2023-01-12 19:14:42',NULL),(1945,7851,741,40719,18,21,495,1,12990.52,NULL,'2023-01-12 19:16:05','2023-01-12 19:16:05',NULL),(1946,7851,741,40719,18,21,482,2,12990.52,NULL,'2023-01-12 19:16:05','2023-01-12 19:16:05',NULL),(1947,7851,742,40719,18,21,489,1,4250.00,NULL,'2023-01-12 19:16:44','2023-01-14 21:53:31','2023-01-14 21:53:31'),(1948,7851,742,40719,18,21,482,2,4250.00,NULL,'2023-01-12 19:16:44','2023-01-14 21:53:31','2023-01-14 21:53:31'),(1949,7851,743,40719,18,21,492,1,860.00,NULL,'2023-01-12 19:18:12','2023-01-12 19:18:12',NULL),(1950,7851,743,40719,18,21,482,2,860.00,NULL,'2023-01-12 19:18:12','2023-01-12 19:18:12',NULL),(1951,7851,744,40719,18,21,482,2,860.00,NULL,'2023-01-12 19:19:00','2023-01-12 19:19:00',NULL),(1952,7851,744,40719,18,21,492,1,860.00,NULL,'2023-01-12 19:19:00','2023-01-12 19:19:00',NULL),(1953,7851,745,40719,18,21,482,2,25000.00,NULL,'2023-01-12 19:19:46','2023-01-12 19:19:46',NULL),(1954,7851,745,40719,18,21,163,1,25000.00,NULL,'2023-01-12 19:19:46','2023-01-12 19:19:46',NULL),(1955,7851,746,40719,18,21,482,2,670.00,NULL,'2023-01-12 19:21:45','2023-01-12 19:21:45',NULL),(1956,7851,746,40719,18,21,214,1,670.00,NULL,'2023-01-12 19:21:45','2023-01-12 19:21:45',NULL),(1957,7851,747,40719,18,21,482,2,764.00,NULL,'2023-01-12 19:24:37','2023-01-12 19:24:37',NULL),(1958,7851,747,40719,18,21,212,1,764.00,NULL,'2023-01-12 19:24:37','2023-01-12 19:24:37',NULL),(1959,7851,748,40719,18,21,482,2,1092.72,NULL,'2023-01-12 19:35:48','2023-01-12 19:35:48',NULL),(1960,7851,748,40719,18,21,212,1,1092.72,NULL,'2023-01-12 19:35:48','2023-01-12 19:35:48',NULL),(1961,7851,749,40719,18,21,482,2,229.96,NULL,'2023-01-12 19:36:44','2023-01-12 19:36:44',NULL),(1962,7851,749,40719,18,21,214,1,229.96,NULL,'2023-01-12 19:36:44','2023-01-12 19:36:44',NULL),(1963,7851,750,40719,13,21,482,1,90446.52,NULL,'2023-01-12 19:41:56','2023-01-12 19:43:21','2023-01-12 19:43:21'),(1964,7851,750,40719,13,21,500,2,90446.52,NULL,'2023-01-12 19:41:56','2023-01-12 19:43:21','2023-01-12 19:43:21'),(1965,7851,751,40719,12,2,482,1,90442.66,NULL,'2023-01-12 19:43:13','2023-03-31 18:19:53','2023-03-31 18:19:53'),(1966,7851,751,40719,12,2,500,2,90442.66,NULL,'2023-01-12 19:43:13','2023-03-31 18:19:53','2023-03-31 18:19:53'),(1967,7851,752,40719,13,2,482,1,90446.52,NULL,'2023-01-12 19:43:21','2023-03-31 18:19:38','2023-03-31 18:19:38'),(1968,7851,752,40719,13,2,500,2,90446.52,NULL,'2023-01-12 19:43:21','2023-03-31 18:19:38','2023-03-31 18:19:38'),(1969,7851,753,40719,18,21,493,1,39092.47,NULL,'2023-01-13 20:51:31','2023-01-13 20:51:31',NULL),(1970,7851,753,40719,18,21,163,2,39092.47,NULL,'2023-01-13 20:51:31','2023-01-13 20:51:31',NULL),(1971,7851,754,40719,18,21,494,1,85160.73,NULL,'2023-01-13 20:52:41','2023-01-13 20:52:41',NULL),(1972,7851,754,40719,18,21,163,2,85160.73,NULL,'2023-01-13 20:52:41','2023-01-13 20:52:41',NULL),(1973,7851,755,40719,18,3,527,1,18492.32,NULL,'2023-01-13 21:09:13','2023-01-31 18:40:09','2023-01-31 18:40:09'),(1974,7851,755,40719,18,3,68,1,3883.39,NULL,'2023-01-13 21:09:13','2023-01-31 18:40:09','2023-01-31 18:40:09'),(1975,7851,755,40719,18,3,527,1,2489.51,NULL,'2023-01-13 21:09:13','2023-01-31 18:40:09','2023-01-31 18:40:09'),(1976,7851,755,40719,18,3,220,1,554.77,NULL,'2023-01-13 21:09:13','2023-01-31 18:40:09','2023-01-31 18:40:09'),(1977,7851,755,40719,18,3,57,2,25419.99,NULL,'2023-01-13 21:09:13','2023-01-31 18:40:09','2023-01-31 18:40:09'),(1978,7851,756,40719,28,19,486,2,440000.00,NULL,'2023-01-14 17:50:20','2023-01-14 17:51:07','2023-01-14 17:51:07'),(1979,7851,756,40719,28,19,163,1,440000.00,NULL,'2023-01-14 17:50:20','2023-01-14 17:51:07','2023-01-14 17:51:07'),(1980,7851,757,40719,28,19,486,2,440000.00,NULL,'2023-01-14 17:51:07','2023-01-14 17:51:27','2023-01-14 17:51:27');
INSERT INTO `balance_libro_details` VALUES (1981,7851,757,40719,28,19,163,1,440000.00,NULL,'2023-01-14 17:51:07','2023-01-14 17:51:27','2023-01-14 17:51:27'),(1982,7851,758,40719,18,19,486,2,440000.00,NULL,'2023-01-14 17:51:27','2023-01-14 17:54:36','2023-01-14 17:54:36'),(1983,7851,758,40719,18,19,163,1,440000.00,NULL,'2023-01-14 17:51:27','2023-01-14 17:54:36','2023-01-14 17:54:36'),(1984,7851,759,40719,18,19,163,1,467123.29,NULL,'2023-01-14 17:53:07','2023-01-14 17:53:07',NULL),(1985,7851,759,40719,18,19,486,2,440000.00,NULL,'2023-01-14 17:53:07','2023-01-14 17:53:07',NULL),(1986,7851,759,40719,18,19,490,2,27123.29,NULL,'2023-01-14 17:53:07','2023-01-14 17:53:07',NULL),(1987,7851,760,40719,18,19,486,2,13561.64,NULL,'2023-01-14 17:54:36','2023-01-30 15:10:50','2023-01-30 15:10:50'),(1988,7851,760,40719,18,19,163,1,233561.64,NULL,'2023-01-14 17:54:36','2023-01-30 15:10:50','2023-01-30 15:10:50'),(1989,7851,760,40719,18,19,490,2,220000.00,NULL,'2023-01-14 17:54:36','2023-01-30 15:10:50','2023-01-30 15:10:50'),(1990,7851,761,40719,18,19,486,1,950000.00,NULL,'2023-01-14 17:57:49','2023-01-14 17:57:49',NULL),(1991,7851,761,40719,18,19,163,2,950000.00,NULL,'2023-01-14 17:57:49','2023-01-14 17:57:49',NULL),(1992,7851,762,40719,18,21,191,1,173.40,NULL,'2023-01-14 18:27:43','2023-01-14 18:27:43',NULL),(1993,7851,762,40719,18,21,63,2,173.40,NULL,'2023-01-14 18:27:43','2023-01-14 18:27:43',NULL),(1994,7851,763,40719,18,21,163,2,173.40,NULL,'2023-01-14 18:28:25','2023-01-14 18:28:25',NULL),(1995,7851,763,40719,18,21,63,1,173.40,NULL,'2023-01-14 18:28:25','2023-01-14 18:28:25',NULL),(1996,7851,764,40719,14,2,218,2,0.01,NULL,'2023-01-14 20:12:35','2023-01-14 20:13:52','2023-01-14 20:13:52'),(1997,7851,764,40719,14,2,220,2,115.62,NULL,'2023-01-14 20:12:35','2023-01-14 20:13:52','2023-01-14 20:13:52'),(1998,7851,764,40719,14,2,13,1,115.63,NULL,'2023-01-14 20:12:35','2023-01-14 20:13:52','2023-01-14 20:13:52'),(1999,7851,765,40719,14,3,396,1,0.01,NULL,'2023-01-14 20:14:32','2023-01-14 20:14:32',NULL),(2000,7851,765,40719,14,3,220,1,115.62,NULL,'2023-01-14 20:14:32','2023-01-14 20:14:32',NULL),(2001,7851,765,40719,14,3,57,2,115.63,NULL,'2023-01-14 20:14:32','2023-01-14 20:14:32',NULL),(2002,7851,766,40719,14,15,67,1,392286.46,NULL,'2023-01-14 20:35:35','2023-01-30 15:02:53','2023-01-30 15:02:53'),(2003,7851,766,40719,14,15,68,2,332568.52,NULL,'2023-01-14 20:35:35','2023-01-30 15:02:53','2023-01-30 15:02:53'),(2004,7851,766,40719,14,15,220,2,264.57,NULL,'2023-01-14 20:35:35','2023-01-30 15:02:53','2023-01-30 15:02:53'),(2005,7851,766,40719,14,15,74,2,57635.38,NULL,'2023-01-14 20:35:35','2023-01-30 15:02:53','2023-01-30 15:02:53'),(2006,7851,766,40719,14,15,136,2,1817.99,NULL,'2023-01-14 20:35:35','2023-01-30 15:02:53','2023-01-30 15:02:53'),(2007,7851,767,40719,18,19,482,2,60000.00,NULL,'2023-01-14 21:17:32','2023-01-28 21:06:19','2023-01-28 21:06:19'),(2008,7851,767,40719,18,19,483,1,60000.00,NULL,'2023-01-14 21:17:32','2023-01-28 21:06:19','2023-01-28 21:06:19'),(2009,7851,768,40719,13,15,67,1,170028.92,NULL,'2023-01-14 21:21:07','2023-01-14 21:22:32','2023-01-14 21:22:32'),(2010,7851,768,40719,13,15,68,2,129086.91,NULL,'2023-01-14 21:21:07','2023-01-14 21:22:32','2023-01-14 21:22:32'),(2011,7851,768,40719,13,15,74,2,40942.01,NULL,'2023-01-14 21:21:07','2023-01-14 21:22:32','2023-01-14 21:22:32'),(2012,7851,769,40719,13,15,67,1,170028.92,NULL,'2023-01-14 21:23:00','2023-01-14 21:23:00',NULL),(2013,7851,769,40719,13,15,68,2,129086.91,NULL,'2023-01-14 21:23:00','2023-01-14 21:23:00',NULL),(2014,7851,769,40719,13,15,74,2,39124.01,NULL,'2023-01-14 21:23:00','2023-01-14 21:23:00',NULL),(2015,7851,769,40719,13,15,136,2,1818.00,NULL,'2023-01-14 21:23:00','2023-01-14 21:23:00',NULL),(2016,7851,770,40719,12,15,67,1,170982.00,NULL,'2023-01-14 21:24:55','2023-01-14 21:24:55',NULL),(2017,7851,770,40719,12,15,68,2,111068.70,NULL,'2023-01-14 21:24:55','2023-01-14 21:24:55',NULL),(2018,7851,770,40719,12,15,353,2,2954.12,NULL,'2023-01-14 21:24:55','2023-01-14 21:24:55',NULL);
INSERT INTO `balance_libro_details` VALUES (2019,7851,770,40719,12,15,354,2,1175.12,NULL,'2023-01-14 21:24:55','2023-01-14 21:24:55',NULL),(2020,7851,770,40719,12,15,74,2,53966.06,NULL,'2023-01-14 21:24:55','2023-01-14 21:24:55',NULL),(2021,7851,770,40719,12,15,136,2,1818.00,NULL,'2023-01-14 21:24:55','2023-01-14 21:24:55',NULL),(2022,7851,771,40719,11,15,67,1,68700.88,NULL,'2023-01-14 21:26:10','2023-01-14 21:26:10',NULL),(2023,7851,771,40719,11,15,68,2,43216.00,NULL,'2023-01-14 21:26:10','2023-01-14 21:26:10',NULL),(2024,7851,771,40719,11,15,353,2,26924.00,NULL,'2023-01-14 21:26:10','2023-01-14 21:26:10',NULL),(2025,7851,771,40719,11,15,220,2,1175.12,NULL,'2023-01-14 21:26:10','2023-01-14 21:26:10',NULL),(2026,7851,771,40719,11,15,353,1,2954.12,NULL,'2023-01-14 21:26:10','2023-01-14 21:26:10',NULL),(2027,7851,771,40719,11,15,354,1,1175.12,NULL,'2023-01-14 21:26:10','2023-01-14 21:26:10',NULL),(2028,7851,771,40719,11,15,136,2,1515.00,NULL,'2023-01-14 21:26:10','2023-01-14 21:26:10',NULL),(2029,7851,772,40719,10,15,353,1,26924.00,NULL,'2023-01-14 21:26:31','2023-01-14 21:26:31',NULL),(2030,7851,772,40719,10,15,136,2,26924.00,NULL,'2023-01-14 21:26:31','2023-01-14 21:26:31',NULL),(2031,7851,773,40719,18,3,217,1,1723.80,NULL,'2023-01-14 21:50:01','2023-01-14 21:50:01',NULL),(2032,7851,773,40719,18,3,68,1,362.00,NULL,'2023-01-14 21:50:01','2023-01-14 21:50:01',NULL),(2033,7851,773,40719,18,3,57,2,2085.80,NULL,'2023-01-14 21:50:01','2023-01-14 21:50:01',NULL),(2034,7851,774,40719,18,3,217,1,6395.97,NULL,'2023-01-14 21:50:01','2023-01-14 21:51:09','2023-01-14 21:51:09'),(2035,7851,774,40719,18,3,68,1,1343.16,NULL,'2023-01-14 21:50:01','2023-01-14 21:51:09','2023-01-14 21:51:09'),(2036,7851,774,40719,18,3,217,1,1061.57,NULL,'2023-01-14 21:50:01','2023-01-14 21:51:09','2023-01-14 21:51:09'),(2037,7851,774,40719,18,3,57,2,8800.70,NULL,'2023-01-14 21:50:01','2023-01-14 21:51:09','2023-01-14 21:51:09'),(2038,7851,775,40719,18,3,217,1,3512.40,NULL,'2023-01-14 21:50:01','2023-01-14 21:50:01',NULL),(2039,7851,775,40719,18,3,68,1,737.60,NULL,'2023-01-14 21:50:01','2023-01-14 21:50:01',NULL),(2040,7851,775,40719,18,3,57,2,4250.00,NULL,'2023-01-14 21:50:01','2023-01-14 21:50:01',NULL),(2041,7851,776,40719,18,3,217,1,6395.97,NULL,'2023-01-14 21:51:09','2023-01-14 21:51:09',NULL),(2042,7851,776,40719,18,3,68,1,1343.15,NULL,'2023-01-14 21:51:09','2023-01-14 21:51:09',NULL),(2043,7851,776,40719,18,3,221,1,1061.57,NULL,'2023-01-14 21:51:09','2023-01-14 21:51:09',NULL),(2044,7851,776,40719,18,3,57,2,8800.69,NULL,'2023-01-14 21:51:09','2023-01-14 21:51:09',NULL),(2045,7851,777,40719,18,21,57,1,4250.00,NULL,'2023-01-14 22:06:41','2023-01-14 22:06:41',NULL),(2046,7851,777,40719,18,21,482,2,4250.00,NULL,'2023-01-14 22:06:41','2023-01-14 22:06:41',NULL),(2047,7851,778,40719,18,21,57,1,2085.80,NULL,'2023-01-14 22:09:14','2023-01-14 22:09:14',NULL),(2048,7851,778,40719,18,21,163,2,2085.80,NULL,'2023-01-14 22:09:14','2023-01-14 22:09:14',NULL),(2049,7851,779,40719,18,21,57,1,8800.69,NULL,'2023-01-14 22:10:21','2023-01-14 22:10:21',NULL),(2050,7851,779,40719,18,21,488,2,8800.69,NULL,'2023-01-14 22:10:21','2023-01-14 22:10:21',NULL),(2051,7851,780,40719,18,21,505,1,8386.57,NULL,'2023-01-17 19:08:38','2023-01-30 20:39:02','2023-01-30 20:39:02'),(2052,7851,780,40719,18,21,482,2,8386.57,NULL,'2023-01-17 19:08:38','2023-01-30 20:39:02','2023-01-30 20:39:02'),(2053,7851,781,40719,18,21,482,2,2004.07,NULL,'2023-01-17 19:09:49','2023-01-28 18:13:05','2023-01-28 18:13:05'),(2054,7851,781,40719,18,21,498,1,2004.07,NULL,'2023-01-17 19:09:49','2023-01-28 18:13:05','2023-01-28 18:13:05'),(2055,7851,782,40719,18,21,482,2,1648.25,NULL,'2023-01-17 19:11:23','2023-01-17 19:11:23',NULL),(2056,7851,782,40719,18,21,498,1,1648.25,NULL,'2023-01-17 19:11:23','2023-01-17 19:11:23',NULL),(2057,7851,783,40719,18,3,217,1,1283.28,NULL,'2023-01-27 18:21:09','2023-01-30 13:32:21','2023-01-30 13:32:21'),(2058,7851,783,40719,18,3,68,1,346.49,NULL,'2023-01-27 18:21:09','2023-01-30 13:32:21','2023-01-30 13:32:21');
INSERT INTO `balance_libro_details` VALUES (2059,7851,783,40719,18,3,57,2,1629.77,NULL,'2023-01-27 18:21:09','2023-01-30 13:32:21','2023-01-30 13:32:21'),(2060,7851,784,40719,18,3,217,1,12547.79,NULL,'2023-01-27 18:21:09','2023-01-28 13:20:55','2023-01-28 13:20:55'),(2061,7851,784,40719,18,3,68,1,3270.54,NULL,'2023-01-27 18:21:09','2023-01-28 13:20:55','2023-01-28 13:20:55'),(2062,7851,784,40719,18,3,217,1,933.89,NULL,'2023-01-27 18:21:09','2023-01-28 13:20:55','2023-01-28 13:20:55'),(2063,7851,784,40719,18,3,57,2,16752.22,NULL,'2023-01-27 18:21:09','2023-01-28 13:20:55','2023-01-28 13:20:55'),(2064,7851,785,40719,18,3,217,1,412.31,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2065,7851,785,40719,18,3,68,1,86.59,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2066,7851,785,40719,18,3,57,2,498.90,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2067,7851,786,40719,18,3,217,1,18070.24,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2068,7851,786,40719,18,3,68,1,3794.75,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2069,7851,786,40719,18,3,57,2,21864.99,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2070,7851,787,40719,18,3,217,1,3545.45,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2071,7851,787,40719,18,3,68,1,744.54,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2072,7851,787,40719,18,3,57,2,4289.99,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2073,7851,788,40719,18,3,217,1,25247.96,NULL,'2023-01-27 18:21:10','2023-01-31 18:00:49','2023-01-31 18:00:49'),(2074,7851,788,40719,18,3,68,1,2651.04,NULL,'2023-01-27 18:21:10','2023-01-31 18:00:49','2023-01-31 18:00:49'),(2075,7851,788,40719,18,3,57,2,27899.00,NULL,'2023-01-27 18:21:10','2023-01-31 18:00:49','2023-01-31 18:00:49'),(2076,7851,789,40719,18,3,217,1,3498.28,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2077,7851,789,40719,18,3,68,1,734.64,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2078,7851,789,40719,18,3,57,2,4232.92,NULL,'2023-01-27 18:21:10','2023-01-27 18:21:10',NULL),(2079,7851,790,40719,18,3,217,1,5668.15,NULL,'2023-01-27 18:31:35','2023-01-27 18:33:34','2023-01-27 18:33:34'),(2080,7851,790,40719,18,3,68,1,1190.31,NULL,'2023-01-27 18:31:35','2023-01-27 18:33:34','2023-01-27 18:33:34'),(2081,7851,790,40719,18,3,221,1,542.60,NULL,'2023-01-27 18:31:35','2023-01-27 18:33:34','2023-01-27 18:33:34'),(2082,7851,790,40719,18,3,57,2,7401.06,NULL,'2023-01-27 18:31:35','2023-01-27 18:33:34','2023-01-27 18:33:34'),(2083,7851,791,40719,18,3,515,1,5668.15,NULL,'2023-01-27 18:33:34','2023-01-27 18:33:34',NULL),(2084,7851,791,40719,18,3,68,1,1190.31,NULL,'2023-01-27 18:33:34','2023-01-27 18:33:34',NULL),(2085,7851,791,40719,18,3,221,1,542.60,NULL,'2023-01-27 18:33:34','2023-01-27 18:33:34',NULL),(2086,7851,791,40719,18,3,57,2,7401.06,NULL,'2023-01-27 18:33:34','2023-01-27 18:33:34',NULL),(2087,7851,792,40719,18,3,217,1,1914.17,NULL,'2023-01-27 18:37:49','2023-01-27 18:41:51','2023-01-27 18:41:51'),(2088,7851,792,40719,18,3,68,1,401.98,NULL,'2023-01-27 18:37:49','2023-01-27 18:41:51','2023-01-27 18:41:51'),(2089,7851,792,40719,18,3,221,1,183.86,NULL,'2023-01-27 18:37:49','2023-01-27 18:41:51','2023-01-27 18:41:51'),(2090,7851,792,40719,18,3,57,2,2500.01,NULL,'2023-01-27 18:37:49','2023-01-27 18:41:51','2023-01-27 18:41:51'),(2091,7851,793,40719,18,3,217,1,2305.55,NULL,'2023-01-27 18:39:03','2023-01-27 18:41:31','2023-01-27 18:41:31'),(2092,7851,793,40719,18,3,68,1,484.17,NULL,'2023-01-27 18:39:03','2023-01-27 18:41:31','2023-01-27 18:41:31'),(2093,7851,793,40719,18,3,221,1,210.37,NULL,'2023-01-27 18:39:03','2023-01-27 18:41:31','2023-01-27 18:41:31'),(2094,7851,793,40719,18,3,57,2,3000.09,NULL,'2023-01-27 18:39:03','2023-01-27 18:41:31','2023-01-27 18:41:31'),(2095,7851,794,40719,18,3,217,1,2680.49,NULL,'2023-01-27 18:40:09','2023-01-27 18:41:20','2023-01-27 18:41:20'),(2096,7851,794,40719,18,3,68,1,562.90,NULL,'2023-01-27 18:40:09','2023-01-27 18:41:20','2023-01-27 18:41:20');
INSERT INTO `balance_libro_details` VALUES (2097,7851,794,40719,18,3,221,1,256.60,NULL,'2023-01-27 18:40:09','2023-01-27 18:41:20','2023-01-27 18:41:20'),(2098,7851,794,40719,18,3,57,2,3499.99,NULL,'2023-01-27 18:40:09','2023-01-27 18:41:20','2023-01-27 18:41:20'),(2099,7851,795,40719,18,3,507,1,7658.56,NULL,'2023-01-27 18:41:05','2023-01-27 18:41:05',NULL),(2100,7851,795,40719,18,3,68,1,1608.30,NULL,'2023-01-27 18:41:05','2023-01-27 18:41:05',NULL),(2101,7851,795,40719,18,3,221,1,733.14,NULL,'2023-01-27 18:41:05','2023-01-27 18:41:05',NULL),(2102,7851,795,40719,18,3,57,2,10000.00,NULL,'2023-01-27 18:41:05','2023-01-27 18:41:05',NULL),(2103,7851,796,40719,18,3,507,1,2680.49,NULL,'2023-01-27 18:41:20','2023-01-27 18:41:20',NULL),(2104,7851,796,40719,18,3,68,1,562.90,NULL,'2023-01-27 18:41:20','2023-01-27 18:41:20',NULL),(2105,7851,796,40719,18,3,221,1,256.60,NULL,'2023-01-27 18:41:20','2023-01-27 18:41:20',NULL),(2106,7851,796,40719,18,3,57,2,3499.99,NULL,'2023-01-27 18:41:20','2023-01-27 18:41:20',NULL),(2107,7851,797,40719,18,3,507,1,2305.55,NULL,'2023-01-27 18:41:31','2023-01-27 18:41:31',NULL),(2108,7851,797,40719,18,3,68,1,484.17,NULL,'2023-01-27 18:41:31','2023-01-27 18:41:31',NULL),(2109,7851,797,40719,18,3,221,1,210.37,NULL,'2023-01-27 18:41:31','2023-01-27 18:41:31',NULL),(2110,7851,797,40719,18,3,57,2,3000.09,NULL,'2023-01-27 18:41:31','2023-01-27 18:41:31',NULL),(2111,7851,798,40719,18,3,507,1,1914.17,NULL,'2023-01-27 18:41:51','2023-01-27 18:41:51',NULL),(2112,7851,798,40719,18,3,68,1,401.98,NULL,'2023-01-27 18:41:51','2023-01-27 18:41:51',NULL),(2113,7851,798,40719,18,3,221,1,183.86,NULL,'2023-01-27 18:41:51','2023-01-27 18:41:51',NULL),(2114,7851,798,40719,18,3,57,2,2500.01,NULL,'2023-01-27 18:41:51','2023-01-27 18:41:51',NULL),(2115,7851,799,40719,18,3,507,1,1914.64,NULL,'2023-01-27 18:43:20','2023-01-27 18:43:20',NULL),(2116,7851,799,40719,18,3,68,1,402.07,NULL,'2023-01-27 18:43:20','2023-01-27 18:43:20',NULL),(2117,7851,799,40719,18,3,221,1,183.29,NULL,'2023-01-27 18:43:20','2023-01-27 18:43:20',NULL),(2118,7851,799,40719,18,3,57,2,2500.00,NULL,'2023-01-27 18:43:20','2023-01-27 18:43:20',NULL),(2119,7851,800,40719,18,3,507,1,1453.51,NULL,'2023-01-27 18:45:44','2023-01-27 18:45:44',NULL),(2120,7851,800,40719,18,3,68,1,305.24,NULL,'2023-01-27 18:45:44','2023-01-27 18:45:44',NULL),(2121,7851,800,40719,18,3,221,1,241.25,NULL,'2023-01-27 18:45:44','2023-01-27 18:45:44',NULL),(2122,7851,800,40719,18,3,57,2,2000.00,NULL,'2023-01-27 18:45:44','2023-01-27 18:45:44',NULL),(2123,7851,801,40719,18,3,198,1,18492.32,NULL,'2023-01-27 18:46:48','2023-01-27 18:48:17','2023-01-27 18:48:17'),(2124,7851,801,40719,18,3,68,1,3883.39,NULL,'2023-01-27 18:46:48','2023-01-27 18:48:17','2023-01-27 18:48:17'),(2125,7851,801,40719,18,3,198,1,2489.51,NULL,'2023-01-27 18:46:48','2023-01-27 18:48:17','2023-01-27 18:48:17'),(2126,7851,801,40719,18,3,220,1,554.77,NULL,'2023-01-27 18:46:48','2023-01-27 18:48:17','2023-01-27 18:48:17'),(2127,7851,801,40719,18,3,57,2,25419.99,NULL,'2023-01-27 18:46:48','2023-01-27 18:48:17','2023-01-27 18:48:17'),(2128,7851,802,40719,18,3,527,1,182.34,NULL,'2023-01-27 18:48:07','2023-01-27 18:48:07',NULL),(2129,7851,802,40719,18,3,68,1,38.29,NULL,'2023-01-27 18:48:07','2023-01-27 18:48:07',NULL),(2130,7851,802,40719,18,3,527,1,43.37,NULL,'2023-01-27 18:48:07','2023-01-27 18:48:07',NULL),(2131,7851,802,40719,18,3,57,2,264.00,NULL,'2023-01-27 18:48:07','2023-01-27 18:48:07',NULL),(2132,7851,803,40719,18,3,527,1,18492.32,NULL,'2023-01-27 18:48:17','2023-01-27 18:48:17',NULL),(2133,7851,803,40719,18,3,68,1,3883.39,NULL,'2023-01-27 18:48:17','2023-01-27 18:48:17',NULL),(2134,7851,803,40719,18,3,527,1,2489.51,NULL,'2023-01-27 18:48:17','2023-01-27 18:48:17',NULL),(2135,7851,803,40719,18,3,220,1,554.77,NULL,'2023-01-27 18:48:17','2023-01-27 18:48:17',NULL),(2136,7851,803,40719,18,3,57,2,25419.99,NULL,'2023-01-27 18:48:17','2023-01-27 18:48:17',NULL),(2141,7851,806,40719,18,3,217,1,10591.79,NULL,'2023-01-28 13:20:55','2023-01-30 13:32:04','2023-01-30 13:32:04');
INSERT INTO `balance_libro_details` VALUES (2142,7851,806,40719,18,3,68,1,2859.78,NULL,'2023-01-28 13:20:55','2023-01-30 13:32:04','2023-01-30 13:32:04'),(2143,7851,806,40719,18,3,217,1,1956.00,NULL,'2023-01-28 13:20:55','2023-01-30 13:32:04','2023-01-30 13:32:04'),(2144,7851,806,40719,18,3,68,1,410.76,NULL,'2023-01-28 13:20:55','2023-01-30 13:32:04','2023-01-30 13:32:04'),(2145,7851,806,40719,18,3,221,1,557.46,NULL,'2023-01-28 13:20:55','2023-01-30 13:32:04','2023-01-30 13:32:04'),(2146,7851,806,40719,18,3,237,1,376.43,NULL,'2023-01-28 13:20:55','2023-01-30 13:32:04','2023-01-30 13:32:04'),(2147,7851,806,40719,18,3,57,2,16752.22,NULL,'2023-01-28 13:20:55','2023-01-30 13:32:04','2023-01-30 13:32:04'),(2148,7851,807,40719,18,3,396,1,4198.14,NULL,'2023-01-28 16:36:44','2023-01-28 16:38:07','2023-01-28 16:38:07'),(2149,7851,807,40719,18,3,68,1,881.61,NULL,'2023-01-28 16:36:44','2023-01-28 16:38:07','2023-01-28 16:38:07'),(2150,7851,807,40719,18,3,220,1,533.39,NULL,'2023-01-28 16:36:44','2023-01-28 16:38:07','2023-01-28 16:38:07'),(2151,7851,807,40719,18,3,57,2,5613.14,NULL,'2023-01-28 16:36:44','2023-01-28 16:38:07','2023-01-28 16:38:07'),(2152,7851,808,40719,18,3,396,1,3965.65,NULL,'2023-01-28 16:37:56','2023-01-28 16:37:56',NULL),(2153,7851,808,40719,18,3,68,1,832.79,NULL,'2023-01-28 16:37:56','2023-01-28 16:37:56',NULL),(2154,7851,808,40719,18,3,57,2,4798.44,NULL,'2023-01-28 16:37:56','2023-01-28 16:37:56',NULL),(2155,7851,809,40719,18,3,396,1,4198.14,NULL,'2023-01-28 16:38:07','2023-01-28 16:38:07',NULL),(2156,7851,809,40719,18,3,68,1,881.61,NULL,'2023-01-28 16:38:07','2023-01-28 16:38:07',NULL),(2157,7851,809,40719,18,3,220,1,533.39,NULL,'2023-01-28 16:38:07','2023-01-28 16:38:07',NULL),(2158,7851,809,40719,18,3,57,2,5613.14,NULL,'2023-01-28 16:38:07','2023-01-28 16:38:07',NULL),(2159,7851,810,40719,18,3,217,1,7182.96,NULL,'2023-01-28 16:52:26','2023-01-28 16:53:11','2023-01-28 16:53:11'),(2160,7851,810,40719,18,3,68,1,1508.42,NULL,'2023-01-28 16:52:26','2023-01-28 16:53:11','2023-01-28 16:53:11'),(2161,7851,810,40719,18,3,217,1,1110.23,NULL,'2023-01-28 16:52:26','2023-01-28 16:53:11','2023-01-28 16:53:11'),(2162,7851,810,40719,18,3,57,2,9801.61,NULL,'2023-01-28 16:52:26','2023-01-28 16:53:11','2023-01-28 16:53:11'),(2163,7851,811,40719,18,3,217,1,7963.79,NULL,'2023-01-28 16:52:26','2023-01-28 16:52:26',NULL),(2164,7851,811,40719,18,3,68,1,836.20,NULL,'2023-01-28 16:52:26','2023-01-28 16:52:26',NULL),(2165,7851,811,40719,18,3,57,2,8799.99,NULL,'2023-01-28 16:52:26','2023-01-28 16:52:26',NULL),(2166,7851,812,40719,18,3,217,1,7182.96,NULL,'2023-01-28 16:53:11','2023-01-28 16:53:11',NULL),(2167,7851,812,40719,18,3,68,1,1508.42,NULL,'2023-01-28 16:53:11','2023-01-28 16:53:11',NULL),(2168,7851,812,40719,18,3,221,1,1110.23,NULL,'2023-01-28 16:53:11','2023-01-28 16:53:11',NULL),(2169,7851,812,40719,18,3,57,2,9801.61,NULL,'2023-01-28 16:53:11','2023-01-28 16:53:11',NULL),(2170,7851,813,40719,18,3,396,1,0.01,NULL,'2023-01-28 17:13:22','2023-01-28 17:13:22',NULL),(2171,7851,813,40719,18,3,220,1,125.60,NULL,'2023-01-28 17:13:22','2023-01-28 17:13:22',NULL),(2172,7851,813,40719,18,3,57,2,125.61,NULL,'2023-01-28 17:13:22','2023-01-28 17:13:22',NULL),(2173,7851,814,40719,18,19,541,1,100000.00,NULL,'2023-01-28 18:08:18','2023-01-28 18:08:18',NULL),(2174,7851,814,40719,18,19,482,2,100000.00,NULL,'2023-01-28 18:08:18','2023-01-28 18:08:18',NULL),(2175,7851,815,40719,18,21,497,1,30000.00,NULL,'2023-01-28 18:09:12','2023-01-28 18:09:26','2023-01-28 18:09:26'),(2176,7851,815,40719,18,21,482,2,30000.00,NULL,'2023-01-28 18:09:12','2023-01-28 18:09:26','2023-01-28 18:09:26'),(2177,7851,816,40719,18,21,497,1,30000.00,NULL,'2023-01-28 18:09:26','2023-01-28 18:09:36','2023-01-28 18:09:36'),(2178,7851,816,40719,18,21,482,2,30000.00,NULL,'2023-01-28 18:09:26','2023-01-28 18:09:36','2023-01-28 18:09:36'),(2179,7851,817,40719,18,21,497,1,30000.00,NULL,'2023-01-28 18:09:36','2023-01-28 18:09:36',NULL),(2180,7851,817,40719,18,21,482,2,30000.00,NULL,'2023-01-28 18:09:36','2023-01-28 18:09:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2181,7851,818,40719,18,21,497,1,20000.00,NULL,'2023-01-28 18:10:03','2023-01-28 18:10:03',NULL),(2182,7851,818,40719,18,21,482,2,20000.00,NULL,'2023-01-28 18:10:03','2023-01-28 18:10:03',NULL),(2183,7851,819,40719,18,21,57,1,9801.61,NULL,'2023-01-28 18:11:19','2023-01-28 18:11:19',NULL),(2184,7851,819,40719,18,21,482,2,9801.61,NULL,'2023-01-28 18:11:19','2023-01-28 18:11:19',NULL),(2185,7851,820,40719,18,21,482,2,2004.07,NULL,'2023-01-28 18:13:05','2023-01-28 18:13:05',NULL),(2186,7851,820,40719,18,21,498,1,2004.07,NULL,'2023-01-28 18:13:05','2023-01-28 18:13:05',NULL),(2187,7851,821,40719,18,21,482,2,1861.03,NULL,'2023-01-28 20:39:58','2023-01-28 20:39:58',NULL),(2188,7851,821,40719,18,21,498,1,1861.03,NULL,'2023-01-28 20:39:58','2023-01-28 20:39:58',NULL),(2189,7851,822,40719,18,2,500,2,104624.37,NULL,'2023-01-28 20:42:19','2023-03-31 18:18:49','2023-03-31 18:18:49'),(2190,7851,822,40719,18,2,482,1,104624.37,NULL,'2023-01-28 20:42:19','2023-03-31 18:18:49','2023-03-31 18:18:49'),(2191,7851,823,40719,18,19,482,2,40000.00,NULL,'2023-01-28 20:45:25','2023-01-28 20:45:25',NULL),(2192,7851,823,40719,18,19,497,1,40000.00,NULL,'2023-01-28 20:45:25','2023-01-28 20:45:25',NULL),(2193,7851,824,40719,18,2,504,2,2000.00,NULL,'2023-01-28 20:48:32','2023-01-28 20:48:32',NULL),(2194,7851,824,40719,18,2,482,1,2000.00,NULL,'2023-01-28 20:48:32','2023-01-28 20:48:32',NULL),(2195,7851,825,40719,18,19,482,2,20000.00,NULL,'2023-01-28 20:51:25','2023-01-28 20:51:25',NULL),(2196,7851,825,40719,18,19,163,1,20000.00,NULL,'2023-01-28 20:51:25','2023-01-28 20:51:25',NULL),(2197,7851,826,40719,18,19,482,2,5000.00,NULL,'2023-01-28 21:01:22','2023-01-28 21:01:22',NULL),(2198,7851,826,40719,18,19,492,1,5000.00,NULL,'2023-01-28 21:01:22','2023-01-28 21:01:22',NULL),(2199,7851,827,40719,18,19,492,1,860.00,NULL,'2023-01-28 21:02:04','2023-01-28 21:02:04',NULL),(2200,7851,827,40719,18,19,482,2,860.00,NULL,'2023-01-28 21:02:04','2023-01-28 21:02:04',NULL),(2201,7851,828,40719,18,19,492,1,860.00,NULL,'2023-01-28 21:02:38','2023-01-28 21:02:38',NULL),(2202,7851,828,40719,18,19,482,2,860.00,NULL,'2023-01-28 21:02:38','2023-01-28 21:02:38',NULL),(2203,7851,829,40719,18,19,482,2,40000.00,NULL,'2023-01-28 21:03:44','2023-01-28 21:03:44',NULL),(2204,7851,829,40719,18,19,497,1,40000.00,NULL,'2023-01-28 21:03:44','2023-01-28 21:03:44',NULL),(2205,7851,830,40719,18,19,482,2,60000.00,NULL,'2023-01-28 21:06:19','2023-01-28 21:06:19',NULL),(2206,7851,830,40719,18,19,483,1,60000.00,NULL,'2023-01-28 21:06:19','2023-01-28 21:06:19',NULL),(2207,7851,831,40719,18,21,482,2,8386.57,NULL,'2023-01-28 21:08:37','2023-01-28 21:08:37',NULL),(2208,7851,831,40719,18,21,505,1,8386.57,NULL,'2023-01-28 21:08:37','2023-01-28 21:08:37',NULL),(2209,7851,832,40719,18,21,482,2,6000.00,NULL,'2023-01-28 21:10:13','2023-01-28 21:10:13',NULL),(2210,7851,832,40719,18,21,492,1,6000.00,NULL,'2023-01-28 21:10:13','2023-01-28 21:10:13',NULL),(2211,7851,833,40719,18,19,482,2,7000.00,NULL,'2023-01-28 21:10:43','2023-01-31 19:04:36','2023-01-31 19:04:36'),(2212,7851,833,40719,18,19,5,1,7000.00,NULL,'2023-01-28 21:10:43','2023-01-31 19:04:36','2023-01-31 19:04:36'),(2213,7851,834,40719,18,2,482,1,15000.00,NULL,'2023-01-28 21:14:40','2023-01-28 21:14:40',NULL),(2214,7851,834,40719,18,2,504,2,15000.00,NULL,'2023-01-28 21:14:40','2023-01-28 21:14:40',NULL),(2215,7851,835,40719,18,21,57,1,1449.99,NULL,'2023-01-30 13:23:38','2023-01-30 13:23:38',NULL),(2216,7851,835,40719,18,21,482,2,1449.99,NULL,'2023-01-30 13:23:38','2023-01-30 13:23:38',NULL),(2217,7851,836,40719,18,21,531,1,7077.99,NULL,'2023-01-30 13:27:41','2023-02-12 22:19:19','2023-02-12 22:19:19'),(2218,7851,836,40719,18,21,163,2,7077.99,NULL,'2023-01-30 13:27:41','2023-02-12 22:19:19','2023-02-12 22:19:19'),(2219,7851,837,40719,18,19,163,1,60000.00,NULL,'2023-01-30 13:30:57','2023-01-30 13:30:57',NULL),(2220,7851,837,40719,18,19,483,2,60000.00,NULL,'2023-01-30 13:30:57','2023-01-30 13:30:57',NULL);
INSERT INTO `balance_libro_details` VALUES (2221,7851,838,40719,18,3,120,1,10591.79,NULL,'2023-01-30 13:32:04','2023-01-30 13:32:04',NULL),(2222,7851,838,40719,18,3,68,1,2859.78,NULL,'2023-01-30 13:32:04','2023-01-30 13:32:04',NULL),(2223,7851,838,40719,18,3,120,1,1956.00,NULL,'2023-01-30 13:32:04','2023-01-30 13:32:04',NULL),(2224,7851,838,40719,18,3,68,1,410.76,NULL,'2023-01-30 13:32:04','2023-01-30 13:32:04',NULL),(2225,7851,838,40719,18,3,221,1,557.46,NULL,'2023-01-30 13:32:04','2023-01-30 13:32:04',NULL),(2226,7851,838,40719,18,3,237,1,376.43,NULL,'2023-01-30 13:32:04','2023-01-30 13:32:04',NULL),(2227,7851,838,40719,18,3,57,2,16752.22,NULL,'2023-01-30 13:32:04','2023-01-30 13:32:04',NULL),(2228,7851,839,40719,18,3,120,1,1283.28,NULL,'2023-01-30 13:32:21','2023-01-30 13:32:21',NULL),(2229,7851,839,40719,18,3,68,1,346.49,NULL,'2023-01-30 13:32:21','2023-01-30 13:32:21',NULL),(2230,7851,839,40719,18,3,57,2,1629.77,NULL,'2023-01-30 13:32:21','2023-01-30 13:32:21',NULL),(2231,7851,840,40719,18,21,57,1,16752.22,NULL,'2023-01-30 13:33:58','2023-01-30 13:33:58',NULL),(2232,7851,840,40719,18,21,163,2,16752.22,NULL,'2023-01-30 13:33:58','2023-01-30 13:33:58',NULL),(2233,7851,841,40719,18,21,57,1,1629.77,NULL,'2023-01-30 13:34:36','2023-01-30 13:34:36',NULL),(2234,7851,841,40719,18,21,163,2,1629.77,NULL,'2023-01-30 13:34:36','2023-01-30 13:34:36',NULL),(2235,7851,842,40719,18,19,542,1,60000.00,NULL,'2023-01-30 13:36:41','2023-01-30 13:36:41',NULL),(2236,7851,842,40719,18,19,163,2,60000.00,NULL,'2023-01-30 13:36:41','2023-01-30 13:36:41',NULL),(2237,7851,843,40719,14,21,57,1,12873.41,NULL,'2023-01-30 14:33:56','2023-01-30 14:36:58','2023-01-30 14:36:58'),(2238,7851,843,40719,14,21,163,2,12873.41,NULL,'2023-01-30 14:33:56','2023-01-30 14:36:58','2023-01-30 14:36:58'),(2239,7851,844,40719,14,3,120,1,8595.99,NULL,'2023-01-30 15:02:54','2023-01-30 15:02:54',NULL),(2240,7851,844,40719,14,3,68,1,2320.92,NULL,'2023-01-30 15:02:54','2023-01-30 15:02:54',NULL),(2241,7851,844,40719,14,3,120,1,1005.00,NULL,'2023-01-30 15:02:54','2023-01-30 15:02:54',NULL),(2242,7851,844,40719,14,3,68,1,211.05,NULL,'2023-01-30 15:02:54','2023-01-30 15:02:54',NULL),(2243,7851,844,40719,14,3,221,1,452.42,NULL,'2023-01-30 15:02:54','2023-01-30 15:02:54',NULL),(2244,7851,844,40719,14,3,237,1,288.03,NULL,'2023-01-30 15:02:54','2023-01-30 15:02:54',NULL),(2245,7851,844,40719,14,3,57,2,12873.41,NULL,'2023-01-30 15:02:54','2023-01-30 15:02:54',NULL),(2246,7851,845,40719,14,15,67,1,392286.46,NULL,'2023-01-30 15:04:11','2023-01-30 15:04:11',NULL),(2247,7851,845,40719,14,15,68,2,332568.52,NULL,'2023-01-30 15:04:11','2023-01-30 15:04:11',NULL),(2248,7851,845,40719,14,15,220,2,264.57,NULL,'2023-01-30 15:04:11','2023-01-30 15:04:11',NULL),(2249,7851,845,40719,14,15,74,2,57635.38,NULL,'2023-01-30 15:04:11','2023-01-30 15:04:11',NULL),(2250,7851,845,40719,14,15,136,2,1817.99,NULL,'2023-01-30 15:04:11','2023-01-30 15:04:11',NULL),(2251,7851,846,40719,18,19,163,1,233561.64,NULL,'2023-01-30 15:10:50','2023-01-30 15:10:50',NULL),(2252,7851,846,40719,18,19,490,2,13561.64,NULL,'2023-01-30 15:10:50','2023-01-30 15:10:50',NULL),(2253,7851,846,40719,18,19,486,2,220000.00,NULL,'2023-01-30 15:10:50','2023-01-30 15:10:50',NULL),(2254,7851,847,40719,14,21,57,1,12873.41,NULL,'2023-01-30 15:11:59','2023-01-30 15:11:59',NULL),(2255,7851,847,40719,14,21,163,2,12873.41,NULL,'2023-01-30 15:11:59','2023-01-30 15:11:59',NULL),(2256,7851,848,40719,12,21,163,2,2940.78,NULL,'2023-01-30 19:09:17','2023-01-30 19:09:17',NULL),(2257,7851,848,40719,12,21,396,1,2940.78,NULL,'2023-01-30 19:09:17','2023-01-30 19:09:17',NULL),(2258,7851,849,40719,14,20,13,2,7780.00,NULL,'2023-01-30 23:18:05','2023-02-01 01:05:15','2023-02-01 01:05:15'),(2259,7851,849,40719,14,20,488,1,7780.00,NULL,'2023-01-30 23:18:05','2023-02-01 01:05:15','2023-02-01 01:05:15'),(2260,7851,850,40719,14,21,482,2,10000.00,NULL,'2023-01-30 23:44:18','2023-01-30 23:44:18',NULL),(2261,7851,850,40719,14,21,492,1,10000.00,NULL,'2023-01-30 23:44:18','2023-01-30 23:44:18',NULL);
INSERT INTO `balance_libro_details` VALUES (2262,7851,851,40719,14,21,482,2,135000.00,NULL,'2023-01-30 23:46:39','2023-01-30 23:46:39',NULL),(2263,7851,851,40719,14,21,497,1,135000.00,NULL,'2023-01-30 23:46:39','2023-01-30 23:46:39',NULL),(2264,7851,852,40719,14,21,482,1,2271.00,NULL,'2023-01-30 23:55:36','2023-01-31 00:08:04','2023-01-31 00:08:04'),(2265,7851,852,40719,14,21,540,2,2271.00,NULL,'2023-01-30 23:55:36','2023-01-31 00:08:04','2023-01-31 00:08:04'),(2266,7851,853,40719,18,19,482,1,100000.00,NULL,'2023-01-30 23:57:38','2023-01-30 23:58:11','2023-01-30 23:58:11'),(2267,7851,853,40719,18,19,504,2,100000.00,NULL,'2023-01-30 23:57:38','2023-01-30 23:58:11','2023-01-30 23:58:11'),(2268,7851,854,40719,14,19,482,1,100000.00,NULL,'2023-01-30 23:58:11','2023-01-30 23:58:11',NULL),(2269,7851,854,40719,14,19,504,2,100000.00,NULL,'2023-01-30 23:58:11','2023-01-30 23:58:11',NULL),(2270,7851,855,40719,14,21,511,2,15.40,NULL,'2023-01-31 00:05:38','2023-01-31 00:05:38',NULL),(2271,7851,855,40719,14,21,482,1,15.40,NULL,'2023-01-31 00:05:38','2023-01-31 00:05:38',NULL),(2272,7851,856,40719,14,21,482,2,2271.00,NULL,'2023-01-31 00:08:04','2023-01-31 00:08:04',NULL),(2273,7851,856,40719,14,21,540,1,2271.00,NULL,'2023-01-31 00:08:04','2023-01-31 00:08:04',NULL),(2274,7851,857,40719,13,21,57,1,6201.06,NULL,'2023-01-31 02:55:46','2023-01-31 02:55:46',NULL),(2275,7851,857,40719,13,21,482,2,6201.06,NULL,'2023-01-31 02:55:46','2023-01-31 02:55:46',NULL),(2276,7851,858,40719,13,2,511,2,9.75,NULL,'2023-01-31 02:56:59','2023-01-31 02:56:59',NULL),(2277,7851,858,40719,13,2,482,1,9.75,NULL,'2023-01-31 02:56:59','2023-01-31 02:56:59',NULL),(2278,7851,859,40719,18,3,217,2,25247.96,NULL,'2023-01-31 17:58:40','2023-01-31 18:00:13','2023-01-31 18:00:13'),(2279,7851,859,40719,18,3,67,2,2651.04,NULL,'2023-01-31 17:58:40','2023-01-31 18:00:13','2023-01-31 18:00:13'),(2280,7851,859,40719,18,3,57,1,27899.00,NULL,'2023-01-31 17:58:40','2023-01-31 18:00:13','2023-01-31 18:00:13'),(2281,7851,860,40719,18,3,217,1,25247.96,NULL,'2023-01-31 17:58:40','2023-01-31 18:00:24','2023-01-31 18:00:24'),(2282,7851,860,40719,18,3,68,1,2651.04,NULL,'2023-01-31 17:58:40','2023-01-31 18:00:24','2023-01-31 18:00:24'),(2283,7851,860,40719,18,3,57,2,27899.00,NULL,'2023-01-31 17:58:40','2023-01-31 18:00:24','2023-01-31 18:00:24'),(2284,7851,861,40719,18,3,120,1,42974.38,NULL,'2023-01-31 17:58:40','2023-01-31 18:01:21','2023-01-31 18:01:21'),(2285,7851,861,40719,18,3,68,1,9024.62,NULL,'2023-01-31 17:58:40','2023-01-31 18:01:21','2023-01-31 18:01:21'),(2286,7851,861,40719,18,3,57,2,51999.00,NULL,'2023-01-31 17:58:40','2023-01-31 18:01:21','2023-01-31 18:01:21'),(2287,7851,862,40719,18,3,217,1,3719.01,NULL,'2023-01-31 17:58:40','2023-01-31 18:01:09','2023-01-31 18:01:09'),(2288,7851,862,40719,18,3,68,1,780.99,NULL,'2023-01-31 17:58:40','2023-01-31 18:01:09','2023-01-31 18:01:09'),(2289,7851,862,40719,18,3,57,2,4500.00,NULL,'2023-01-31 17:58:40','2023-01-31 18:01:09','2023-01-31 18:01:09'),(2290,7851,863,40719,18,3,217,1,5432.23,NULL,'2023-01-31 17:58:40','2023-01-31 18:01:33','2023-01-31 18:01:33'),(2291,7851,863,40719,18,3,68,1,1140.77,NULL,'2023-01-31 17:58:40','2023-01-31 18:01:33','2023-01-31 18:01:33'),(2292,7851,863,40719,18,3,57,2,6573.00,NULL,'2023-01-31 17:58:40','2023-01-31 18:01:33','2023-01-31 18:01:33'),(2293,7851,864,40719,18,3,507,2,25247.96,NULL,'2023-01-31 18:00:13','2023-01-31 18:28:11','2023-01-31 18:28:11'),(2294,7851,864,40719,18,3,67,2,2651.04,NULL,'2023-01-31 18:00:13','2023-01-31 18:28:11','2023-01-31 18:28:11'),(2295,7851,864,40719,18,3,57,1,27899.00,NULL,'2023-01-31 18:00:13','2023-01-31 18:28:11','2023-01-31 18:28:11'),(2296,7851,865,40719,18,3,507,1,25247.96,NULL,'2023-01-31 18:00:24','2023-01-31 18:27:57','2023-01-31 18:27:57'),(2297,7851,865,40719,18,3,68,1,2651.04,NULL,'2023-01-31 18:00:24','2023-01-31 18:27:57','2023-01-31 18:27:57'),(2298,7851,865,40719,18,3,57,2,27899.00,NULL,'2023-01-31 18:00:24','2023-01-31 18:27:57','2023-01-31 18:27:57');
INSERT INTO `balance_libro_details` VALUES (2299,7851,866,40719,18,3,507,1,25247.96,NULL,'2023-01-31 18:00:49','2023-01-31 18:31:40','2023-01-31 18:31:40'),(2300,7851,866,40719,18,3,68,1,2651.04,NULL,'2023-01-31 18:00:49','2023-01-31 18:31:40','2023-01-31 18:31:40'),(2301,7851,866,40719,18,3,57,2,27899.00,NULL,'2023-01-31 18:00:49','2023-01-31 18:31:40','2023-01-31 18:31:40'),(2302,7851,867,40719,18,3,519,1,3719.01,NULL,'2023-01-31 18:01:09','2023-01-31 18:01:09',NULL),(2303,7851,867,40719,18,3,68,1,780.99,NULL,'2023-01-31 18:01:09','2023-01-31 18:01:09',NULL),(2304,7851,867,40719,18,3,57,2,4500.00,NULL,'2023-01-31 18:01:09','2023-01-31 18:01:09',NULL),(2305,7851,868,40719,18,3,507,1,42974.38,NULL,'2023-01-31 18:01:21','2023-01-31 18:26:38','2023-01-31 18:26:38'),(2306,7851,868,40719,18,3,68,1,9024.62,NULL,'2023-01-31 18:01:21','2023-01-31 18:26:38','2023-01-31 18:26:38'),(2307,7851,868,40719,18,3,57,2,51999.00,NULL,'2023-01-31 18:01:21','2023-01-31 18:26:38','2023-01-31 18:26:38'),(2308,7851,869,40719,18,3,524,1,5432.23,NULL,'2023-01-31 18:01:33','2023-01-31 18:01:33',NULL),(2309,7851,869,40719,18,3,68,1,1140.77,NULL,'2023-01-31 18:01:33','2023-01-31 18:01:33',NULL),(2310,7851,869,40719,18,3,57,2,6573.00,NULL,'2023-01-31 18:01:33','2023-01-31 18:01:33',NULL),(2311,7851,870,40719,18,3,489,1,42974.38,NULL,'2023-01-31 18:26:38','2023-01-31 18:26:38',NULL),(2312,7851,870,40719,18,3,68,1,9024.62,NULL,'2023-01-31 18:26:38','2023-01-31 18:26:38',NULL),(2313,7851,870,40719,18,3,57,2,51999.00,NULL,'2023-01-31 18:26:38','2023-01-31 18:26:38',NULL),(2314,7851,871,40719,18,3,495,1,25247.96,NULL,'2023-01-31 18:27:57','2023-01-31 18:27:57',NULL),(2315,7851,871,40719,18,3,68,1,2651.04,NULL,'2023-01-31 18:27:57','2023-01-31 18:27:57',NULL),(2316,7851,871,40719,18,3,57,2,27899.00,NULL,'2023-01-31 18:27:57','2023-01-31 18:27:57',NULL),(2317,7851,872,40719,18,3,495,2,25247.96,NULL,'2023-01-31 18:28:11','2023-01-31 18:28:11',NULL),(2318,7851,872,40719,18,3,67,2,2651.04,NULL,'2023-01-31 18:28:11','2023-01-31 18:28:11',NULL),(2319,7851,872,40719,18,3,57,1,27899.00,NULL,'2023-01-31 18:28:11','2023-01-31 18:28:11',NULL),(2320,7851,873,40719,18,3,495,1,25247.96,NULL,'2023-01-31 18:31:40','2023-01-31 18:31:40',NULL),(2321,7851,873,40719,18,3,68,1,2651.04,NULL,'2023-01-31 18:31:40','2023-01-31 18:31:40',NULL),(2322,7851,873,40719,18,3,57,2,27899.00,NULL,'2023-01-31 18:31:40','2023-01-31 18:31:40',NULL),(2323,7851,874,40719,18,19,482,2,7000.00,NULL,'2023-01-31 19:04:36','2023-01-31 19:04:36',NULL),(2324,7851,874,40719,18,19,497,1,7000.00,NULL,'2023-01-31 19:04:36','2023-01-31 19:04:36',NULL),(2325,7851,875,40719,18,3,110,1,29880.00,NULL,'2023-01-31 20:31:29','2023-01-31 20:31:29',NULL),(2326,7851,875,40719,18,3,62,2,29880.00,NULL,'2023-01-31 20:31:29','2023-01-31 20:31:29',NULL),(2327,7851,876,40719,18,21,163,2,29880.00,NULL,'2023-01-31 20:31:59','2023-01-31 20:31:59',NULL),(2328,7851,876,40719,18,21,62,1,29880.00,NULL,'2023-01-31 20:31:59','2023-01-31 20:31:59',NULL),(2329,7851,877,40719,18,3,491,1,50120.00,NULL,'2023-01-31 20:32:32','2023-01-31 20:32:32',NULL),(2330,7851,877,40719,18,3,518,2,50120.00,NULL,'2023-01-31 20:32:32','2023-01-31 20:32:32',NULL),(2331,7851,878,40719,18,21,163,2,50120.00,NULL,'2023-01-31 20:32:53','2023-01-31 20:32:53',NULL),(2332,7851,878,40719,18,21,491,1,50120.00,NULL,'2023-01-31 20:32:53','2023-01-31 20:32:53',NULL),(2333,7851,879,40719,18,19,483,2,80000.00,NULL,'2023-01-31 20:33:54','2023-01-31 20:33:54',NULL),(2334,7851,879,40719,18,19,163,1,80000.00,NULL,'2023-01-31 20:33:54','2023-01-31 20:33:54',NULL),(2335,7851,880,40719,11,9,512,1,6698.71,NULL,'2023-01-31 21:36:39','2023-01-31 22:33:49','2023-01-31 22:33:49'),(2336,7851,880,40719,11,9,484,2,6698.71,NULL,'2023-01-31 21:36:39','2023-01-31 22:33:49','2023-01-31 22:33:49'),(2337,7851,881,40719,11,9,512,1,6698.71,NULL,'2023-01-31 22:33:49','2023-01-31 22:33:49',NULL),(2338,7851,881,40719,11,9,482,2,6698.71,NULL,'2023-01-31 22:33:49','2023-01-31 22:33:49',NULL);
INSERT INTO `balance_libro_details` VALUES (2339,7851,882,40719,12,21,482,2,1497.09,NULL,'2023-02-01 00:16:15','2023-02-01 00:16:15',NULL),(2340,7851,882,40719,12,21,520,1,1497.09,NULL,'2023-02-01 00:16:15','2023-02-01 00:16:15',NULL),(2341,7851,883,40719,14,21,163,2,39124.01,NULL,'2023-02-01 00:32:01','2023-02-01 00:33:53','2023-02-01 00:33:53'),(2342,7851,883,40719,14,21,74,1,39124.01,NULL,'2023-02-01 00:32:01','2023-02-01 00:33:53','2023-02-01 00:33:53'),(2343,7851,884,40719,12,10,482,2,15226.95,NULL,'2023-02-01 00:33:00','2023-02-01 01:22:57','2023-02-01 01:22:57'),(2344,7851,884,40719,12,10,74,1,15226.95,NULL,'2023-02-01 00:33:00','2023-02-01 01:22:57','2023-02-01 01:22:57'),(2345,7851,885,40719,13,10,482,2,53966.06,NULL,'2023-02-01 00:33:43','2023-02-01 00:33:43',NULL),(2346,7851,885,40719,13,10,74,1,53966.06,NULL,'2023-02-01 00:33:43','2023-02-01 00:33:43',NULL),(2347,7851,886,40719,14,10,163,2,39124.01,NULL,'2023-02-01 00:33:53','2023-02-01 00:33:53',NULL),(2348,7851,886,40719,14,10,74,1,39124.01,NULL,'2023-02-01 00:33:53','2023-02-01 00:33:53',NULL),(2349,7851,887,40719,14,21,57,1,7780.00,NULL,'2023-02-01 01:06:37','2023-02-01 01:06:37',NULL),(2350,7851,887,40719,14,21,488,2,7780.00,NULL,'2023-02-01 01:06:37','2023-02-01 01:06:37',NULL),(2351,7851,888,40719,12,10,482,2,15226.95,NULL,'2023-02-01 01:22:57','2023-02-01 01:23:36','2023-02-01 01:23:36'),(2352,7851,888,40719,12,10,63,1,15226.95,NULL,'2023-02-01 01:22:57','2023-02-01 01:23:36','2023-02-01 01:23:36'),(2353,7851,889,40719,12,10,482,2,15226.95,NULL,'2023-02-01 01:23:36','2023-02-01 01:23:36',NULL),(2354,7851,889,40719,12,10,63,1,15226.95,NULL,'2023-02-01 01:23:36','2023-02-01 01:23:36',NULL),(2355,7851,890,40719,13,21,63,1,18801.15,NULL,'2023-02-01 01:26:16','2023-02-01 01:26:16',NULL),(2356,7851,890,40719,13,21,482,2,18801.15,NULL,'2023-02-01 01:26:16','2023-02-01 01:26:16',NULL),(2357,7851,891,40719,18,21,214,2,899.96,NULL,'2023-02-01 01:37:48','2023-02-01 01:38:11','2023-02-01 01:38:11'),(2358,7851,891,40719,18,21,495,1,899.96,NULL,'2023-02-01 01:37:48','2023-02-01 01:38:11','2023-02-01 01:38:11'),(2359,7851,892,40719,18,3,214,2,899.96,NULL,'2023-02-01 01:38:11','2023-02-01 01:38:11',NULL),(2360,7851,892,40719,18,3,495,1,899.96,NULL,'2023-02-01 01:38:11','2023-02-01 01:38:11',NULL),(2361,7851,893,40719,18,3,212,2,1856.72,NULL,'2023-02-01 01:42:21','2023-02-01 01:42:21',NULL),(2362,7851,893,40719,18,3,495,1,1856.72,NULL,'2023-02-01 01:42:21','2023-02-01 01:42:21',NULL),(2363,7851,894,40719,18,2,511,2,15.62,NULL,'2023-02-03 19:29:00','2023-02-03 19:29:00',NULL),(2364,7851,894,40719,18,2,482,1,15.62,NULL,'2023-02-03 19:29:00','2023-02-03 19:29:00',NULL),(2365,7851,895,40719,18,21,482,2,97349.57,NULL,'2023-02-03 19:31:35','2023-02-03 19:31:35',NULL),(2366,7851,895,40719,18,21,495,1,97349.57,NULL,'2023-02-03 19:31:35','2023-02-03 19:31:35',NULL),(2367,7851,896,40719,18,19,497,1,25000.00,NULL,'2023-02-03 19:32:59','2023-02-03 19:32:59',NULL),(2368,7851,896,40719,18,19,482,2,25000.00,NULL,'2023-02-03 19:32:59','2023-02-03 19:32:59',NULL),(2369,7851,897,40719,19,21,482,2,251.65,NULL,'2023-02-03 19:38:38','2023-02-03 19:42:01','2023-02-03 19:42:01'),(2370,7851,897,40719,19,21,396,1,251.65,NULL,'2023-02-03 19:38:38','2023-02-03 19:42:01','2023-02-03 19:42:01'),(2371,7851,898,40719,19,19,482,2,1198.34,NULL,'2023-02-03 19:41:11','2023-02-03 19:41:23','2023-02-03 19:41:23'),(2372,7851,898,40719,19,19,396,1,1198.34,NULL,'2023-02-03 19:41:11','2023-02-03 19:41:23','2023-02-03 19:41:23'),(2373,7851,899,40719,19,21,482,2,1198.34,NULL,'2023-02-03 19:41:23','2023-02-03 19:41:23',NULL),(2374,7851,899,40719,19,21,396,1,1198.34,NULL,'2023-02-03 19:41:24','2023-02-03 19:41:24',NULL),(2375,7851,900,40719,19,21,482,2,251.65,NULL,'2023-02-03 19:42:01','2023-02-03 19:42:01',NULL),(2376,7851,900,40719,19,21,396,1,251.65,NULL,'2023-02-03 19:42:01','2023-02-03 19:42:01',NULL),(2377,7851,901,40719,19,21,505,1,2047.78,NULL,'2023-02-03 19:44:15','2023-02-03 19:44:15',NULL);
INSERT INTO `balance_libro_details` VALUES (2378,7851,901,40719,19,21,482,2,2047.78,NULL,'2023-02-03 19:44:15','2023-02-03 19:44:15',NULL),(2379,7851,902,40719,19,21,505,1,585.38,NULL,'2023-02-03 19:57:45','2023-02-03 19:57:53','2023-02-03 19:57:53'),(2380,7851,902,40719,19,21,482,2,585.38,NULL,'2023-02-03 19:57:45','2023-02-03 19:57:53','2023-02-03 19:57:53'),(2381,7851,903,40719,19,21,505,1,585.38,NULL,'2023-02-03 19:57:53','2023-02-03 19:57:53',NULL),(2382,7851,903,40719,19,21,482,2,585.38,NULL,'2023-02-03 19:57:53','2023-02-03 19:57:53',NULL),(2383,7851,904,40719,19,19,482,2,40000.00,NULL,'2023-02-03 20:08:58','2023-02-03 20:08:58',NULL),(2384,7851,904,40719,19,19,497,1,40000.00,NULL,'2023-02-03 20:08:58','2023-02-03 20:08:58',NULL),(2385,7851,905,40719,14,19,483,2,40000.00,NULL,'2023-02-03 21:05:14','2023-02-03 21:05:14',NULL),(2386,7851,905,40719,14,19,492,1,40000.00,NULL,'2023-02-03 21:05:14','2023-02-03 21:05:14',NULL),(2387,7851,906,40719,13,21,483,2,3297.83,NULL,'2023-02-03 23:49:46','2023-02-03 23:51:59','2023-02-03 23:51:59'),(2388,7851,906,40719,13,21,135,1,3297.83,NULL,'2023-02-03 23:49:46','2023-02-03 23:51:59','2023-02-03 23:51:59'),(2389,7851,907,40719,13,21,483,1,3297.83,NULL,'2023-02-03 23:51:59','2023-02-03 23:51:59',NULL),(2390,7851,907,40719,13,21,135,2,3297.83,NULL,'2023-02-03 23:51:59','2023-02-03 23:51:59',NULL),(2391,7851,908,40719,13,19,483,1,846.57,NULL,'2023-02-03 23:54:03','2023-02-03 23:54:03',NULL),(2392,7851,908,40719,13,19,99,2,846.57,NULL,'2023-02-03 23:54:03','2023-02-03 23:54:03',NULL),(2393,7851,909,40719,13,21,484,2,10900.00,NULL,'2023-02-04 00:51:14','2023-02-04 00:51:14',NULL),(2394,7851,909,40719,13,21,520,1,10900.00,NULL,'2023-02-04 00:51:14','2023-02-04 00:51:14',NULL),(2395,7851,910,40719,19,19,484,1,4.71,NULL,'2023-02-04 00:56:51','2023-02-04 00:56:51',NULL),(2396,7851,910,40719,19,19,102,2,4.71,NULL,'2023-02-04 00:56:51','2023-02-04 00:56:51',NULL),(2397,7851,911,40719,19,21,163,2,17713.05,NULL,'2023-02-04 18:47:06','2023-02-04 18:47:06',NULL),(2398,7851,911,40719,19,21,493,1,17713.05,NULL,'2023-02-04 18:47:06','2023-02-04 18:47:06',NULL),(2399,7851,912,40719,19,19,163,1,7500.00,NULL,'2023-02-04 18:55:58','2023-02-04 18:55:58',NULL),(2400,7851,912,40719,19,19,165,2,7500.00,NULL,'2023-02-04 18:55:58','2023-02-04 18:55:58',NULL),(2401,7851,913,40719,19,19,483,2,50000.00,NULL,'2023-02-04 19:49:11','2023-02-04 19:49:11',NULL),(2402,7851,913,40719,19,19,163,1,50000.00,NULL,'2023-02-04 19:49:11','2023-02-04 19:49:11',NULL),(2403,7851,914,40719,19,21,163,2,15109.41,NULL,'2023-02-04 19:50:55','2023-02-04 19:50:55',NULL),(2404,7851,914,40719,19,21,493,1,15109.41,NULL,'2023-02-04 19:50:55','2023-02-04 19:50:55',NULL),(2405,7851,915,40719,19,3,63,2,18815.95,NULL,'2023-02-04 20:00:22','2023-02-12 22:46:29','2023-02-12 22:46:29'),(2406,7851,915,40719,19,3,191,1,18815.95,NULL,'2023-02-04 20:00:22','2023-02-12 22:46:29','2023-02-12 22:46:29'),(2407,7851,916,40719,19,19,163,1,30000.00,NULL,'2023-02-05 15:23:03','2023-02-05 15:23:03',NULL),(2408,7851,916,40719,19,19,483,2,30000.00,NULL,'2023-02-05 15:23:03','2023-02-05 15:23:03',NULL),(2409,7851,917,40719,19,19,165,1,7500.00,NULL,'2023-02-06 09:46:39','2023-02-06 09:46:39',NULL),(2410,7851,917,40719,19,19,163,2,7500.00,NULL,'2023-02-06 09:46:39','2023-02-06 09:46:39',NULL),(2411,7851,918,40719,19,21,493,1,15109.41,NULL,'2023-02-06 09:49:35','2023-02-06 09:49:35',NULL),(2412,7851,918,40719,19,21,163,2,15109.41,NULL,'2023-02-06 09:49:35','2023-02-06 09:49:35',NULL),(2413,7851,919,40719,19,19,163,2,138.83,NULL,'2023-02-06 09:51:50','2023-02-06 09:51:50',NULL),(2414,7851,919,40719,19,19,507,1,138.83,NULL,'2023-02-06 09:51:50','2023-02-06 09:51:50',NULL),(2415,7851,920,40719,19,19,444,1,20000.00,NULL,'2023-02-06 09:55:21','2023-02-10 19:48:40','2023-02-10 19:48:40'),(2416,7851,920,40719,19,19,483,2,20000.00,NULL,'2023-02-06 09:55:21','2023-02-10 19:48:40','2023-02-10 19:48:40'),(2417,7851,921,40719,19,21,163,2,18115.95,NULL,'2023-02-06 09:58:06','2023-02-06 09:58:06',NULL);
INSERT INTO `balance_libro_details` VALUES (2418,7851,921,40719,19,21,63,1,18115.95,NULL,'2023-02-06 09:58:06','2023-02-06 09:58:06',NULL),(2419,7851,922,40719,19,21,482,2,1401.50,NULL,'2023-02-06 20:00:22','2023-02-06 20:00:22',NULL),(2420,7851,922,40719,19,21,498,1,1401.50,NULL,'2023-02-06 20:00:22','2023-02-06 20:00:22',NULL),(2421,7851,923,40719,19,21,482,2,1401.50,NULL,'2023-02-06 20:00:56','2023-02-06 20:00:56',NULL),(2422,7851,923,40719,19,21,498,1,1401.50,NULL,'2023-02-06 20:00:56','2023-02-06 20:00:56',NULL),(2423,7851,924,40719,19,21,482,2,7303.00,NULL,'2023-02-06 20:01:57','2023-02-06 20:01:57',NULL),(2424,7851,924,40719,19,21,498,1,7303.00,NULL,'2023-02-06 20:01:57','2023-02-06 20:01:57',NULL),(2425,7851,925,40719,19,21,482,2,7303.00,NULL,'2023-02-06 20:03:07','2023-02-06 20:03:07',NULL),(2426,7851,925,40719,19,21,498,1,7303.00,NULL,'2023-02-06 20:03:07','2023-02-06 20:03:07',NULL),(2427,7851,926,40719,19,21,482,2,231.89,NULL,'2023-02-07 19:01:33','2023-02-07 19:01:33',NULL),(2428,7851,926,40719,19,21,214,1,231.89,NULL,'2023-02-07 19:01:33','2023-02-07 19:01:33',NULL),(2429,7851,927,40719,19,21,482,2,890.00,NULL,'2023-02-07 19:28:17','2023-02-07 19:28:17',NULL),(2430,7851,927,40719,19,21,214,1,890.00,NULL,'2023-02-07 19:28:17','2023-02-07 19:28:17',NULL),(2431,7851,928,40719,19,21,212,1,991.00,NULL,'2023-02-07 19:29:45','2023-02-07 19:29:45',NULL),(2432,7851,928,40719,19,21,482,2,991.00,NULL,'2023-02-07 19:29:45','2023-02-07 19:29:45',NULL),(2433,7851,929,40719,19,21,482,2,1471.30,NULL,'2023-02-07 19:31:09','2023-02-07 19:31:09',NULL),(2434,7851,929,40719,19,21,212,1,1471.30,NULL,'2023-02-07 19:31:09','2023-02-07 19:31:09',NULL),(2435,7851,930,40719,19,2,163,1,1.93,NULL,'2023-02-07 19:56:12','2023-02-07 19:57:24','2023-02-07 19:57:24'),(2436,7851,930,40719,19,2,410,2,1.93,NULL,'2023-02-07 19:56:12','2023-02-07 19:57:24','2023-02-07 19:57:24'),(2437,7851,931,40719,19,2,163,1,1.93,NULL,'2023-02-07 19:57:24','2023-02-07 19:57:24',NULL),(2438,7851,931,40719,19,2,545,2,1.93,NULL,'2023-02-07 19:57:24','2023-02-07 19:57:24',NULL),(2439,7851,932,40719,19,21,163,2,37905.56,NULL,'2023-02-07 19:58:37','2023-02-07 19:58:37',NULL),(2440,7851,932,40719,19,21,494,1,37905.56,NULL,'2023-02-07 19:58:37','2023-02-07 19:58:37',NULL),(2441,7851,933,40719,18,3,507,1,1125.14,NULL,'2023-02-07 20:06:19','2023-02-07 20:06:19',NULL),(2442,7851,933,40719,18,3,68,1,236.28,NULL,'2023-02-07 20:06:19','2023-02-07 20:06:19',NULL),(2443,7851,933,40719,18,3,221,1,138.58,NULL,'2023-02-07 20:06:19','2023-02-07 20:06:19',NULL),(2444,7851,933,40719,18,3,57,2,1500.00,NULL,'2023-02-07 20:06:19','2023-02-07 20:06:19',NULL),(2445,7851,934,40719,18,3,507,1,2931.22,NULL,'2023-02-07 20:06:49','2023-02-07 20:06:49',NULL),(2446,7851,934,40719,18,3,68,1,615.56,NULL,'2023-02-07 20:06:49','2023-02-07 20:06:49',NULL),(2447,7851,934,40719,18,3,221,1,353.22,NULL,'2023-02-07 20:06:49','2023-02-07 20:06:49',NULL),(2448,7851,934,40719,18,3,57,2,3900.00,NULL,'2023-02-07 20:06:49','2023-02-07 20:06:49',NULL),(2449,7851,935,40719,19,3,507,1,2248.10,NULL,'2023-02-07 20:07:34','2023-02-07 20:12:17','2023-02-07 20:12:17'),(2450,7851,935,40719,19,3,68,1,472.10,NULL,'2023-02-07 20:07:34','2023-02-07 20:12:17','2023-02-07 20:12:17'),(2451,7851,935,40719,19,3,221,1,279.80,NULL,'2023-02-07 20:07:34','2023-02-07 20:12:17','2023-02-07 20:12:17'),(2452,7851,935,40719,19,3,57,2,3000.00,NULL,'2023-02-07 20:07:34','2023-02-07 20:12:17','2023-02-07 20:12:17'),(2453,7851,936,40719,18,3,507,1,1873.41,NULL,'2023-02-07 20:08:10','2023-02-07 20:08:10',NULL),(2454,7851,936,40719,18,3,68,1,393.42,NULL,'2023-02-07 20:08:10','2023-02-07 20:08:10',NULL),(2455,7851,936,40719,18,3,221,1,233.16,NULL,'2023-02-07 20:08:10','2023-02-07 20:08:10',NULL),(2456,7851,936,40719,18,3,57,2,2499.99,NULL,'2023-02-07 20:08:10','2023-02-07 20:08:10',NULL),(2457,7851,937,40719,18,3,507,1,1415.61,NULL,'2023-02-07 20:09:08','2023-02-07 20:09:08',NULL),(2458,7851,937,40719,18,3,68,1,297.28,NULL,'2023-02-07 20:09:08','2023-02-07 20:09:08',NULL);
INSERT INTO `balance_libro_details` VALUES (2459,7851,937,40719,18,3,221,1,287.04,NULL,'2023-02-07 20:09:08','2023-02-07 20:09:08',NULL),(2460,7851,937,40719,18,3,57,2,1999.93,NULL,'2023-02-07 20:09:08','2023-02-07 20:09:08',NULL),(2461,7851,938,40719,18,3,507,1,1536.99,NULL,'2023-02-07 20:10:15','2023-02-07 20:10:15',NULL),(2462,7851,938,40719,18,3,68,1,322.77,NULL,'2023-02-07 20:10:15','2023-02-07 20:10:15',NULL),(2463,7851,938,40719,18,3,221,1,140.24,NULL,'2023-02-07 20:10:15','2023-02-07 20:10:15',NULL),(2464,7851,938,40719,18,3,57,2,2000.00,NULL,'2023-02-07 20:10:15','2023-02-07 20:10:15',NULL),(2465,7851,939,40719,18,3,507,1,2305.56,NULL,'2023-02-07 20:11:40','2023-02-07 20:11:40',NULL),(2466,7851,939,40719,18,3,68,1,484.17,NULL,'2023-02-07 20:11:40','2023-02-07 20:11:40',NULL),(2467,7851,939,40719,18,3,221,1,210.36,NULL,'2023-02-07 20:11:40','2023-02-07 20:11:40',NULL),(2468,7851,939,40719,18,3,57,2,3000.09,NULL,'2023-02-07 20:11:40','2023-02-07 20:11:40',NULL),(2469,7851,940,40719,18,3,507,1,2248.10,NULL,'2023-02-07 20:12:17','2023-02-07 20:12:17',NULL),(2470,7851,940,40719,18,3,68,1,472.10,NULL,'2023-02-07 20:12:17','2023-02-07 20:12:17',NULL),(2471,7851,940,40719,18,3,221,1,279.80,NULL,'2023-02-07 20:12:17','2023-02-07 20:12:17',NULL),(2472,7851,940,40719,18,3,57,2,3000.00,NULL,'2023-02-07 20:12:17','2023-02-07 20:12:17',NULL),(2473,7851,941,40719,18,3,507,1,1872.02,NULL,'2023-02-07 20:14:40','2023-02-07 20:14:40',NULL),(2474,7851,941,40719,18,3,68,1,393.12,NULL,'2023-02-07 20:14:40','2023-02-07 20:14:40',NULL),(2475,7851,941,40719,18,3,221,1,236.83,NULL,'2023-02-07 20:14:40','2023-02-07 20:14:40',NULL),(2476,7851,941,40719,18,3,57,2,2501.97,NULL,'2023-02-07 20:14:40','2023-02-07 20:14:40',NULL),(2477,7851,942,40719,18,15,67,1,96052.57,NULL,'2023-02-07 21:09:39','2023-02-07 21:09:48','2023-02-07 21:09:48'),(2478,7851,942,40719,18,15,68,2,44463.56,NULL,'2023-02-07 21:09:39','2023-02-07 21:09:48','2023-02-07 21:09:48'),(2479,7851,942,40719,18,15,220,2,1213.76,NULL,'2023-02-07 21:09:39','2023-02-07 21:09:48','2023-02-07 21:09:48'),(2480,7851,942,40719,18,15,74,2,48557.25,NULL,'2023-02-07 21:09:39','2023-02-07 21:09:48','2023-02-07 21:09:48'),(2481,7851,942,40719,18,15,136,2,1818.00,NULL,'2023-02-07 21:09:39','2023-02-07 21:09:48','2023-02-07 21:09:48'),(2482,7851,943,40719,19,21,483,2,25000.00,NULL,'2023-02-10 18:31:05','2023-02-10 18:31:05',NULL),(2483,7851,943,40719,19,21,492,1,25000.00,NULL,'2023-02-10 18:31:05','2023-02-10 18:31:05',NULL),(2484,7851,944,40719,19,19,497,1,40000.00,NULL,'2023-02-10 18:33:11','2023-02-10 18:33:11',NULL),(2485,7851,944,40719,19,19,482,2,40000.00,NULL,'2023-02-10 18:33:11','2023-02-10 18:33:11',NULL),(2486,7851,945,40719,18,2,96,2,7239.82,NULL,'2023-02-10 18:45:24','2023-02-10 18:45:24',NULL),(2487,7851,945,40719,18,2,67,2,760.18,NULL,'2023-02-10 18:45:24','2023-02-10 18:45:24',NULL),(2488,7851,945,40719,18,2,13,1,8000.00,NULL,'2023-02-10 18:45:24','2023-02-10 18:45:24',NULL),(2489,7851,946,40719,18,2,96,2,7239.82,NULL,'2023-02-10 18:46:03','2023-02-10 18:46:03',NULL),(2490,7851,946,40719,18,2,67,2,760.18,NULL,'2023-02-10 18:46:03','2023-02-10 18:46:03',NULL),(2491,7851,946,40719,18,2,13,1,8000.00,NULL,'2023-02-10 18:46:03','2023-02-10 18:46:03',NULL),(2492,7851,947,40719,19,19,483,2,20000.00,NULL,'2023-02-10 19:48:40','2023-02-10 19:48:40',NULL),(2493,7851,947,40719,19,19,163,1,20000.00,NULL,'2023-02-10 19:48:40','2023-02-10 19:48:40',NULL),(2494,7851,948,40719,18,21,57,1,2501.97,NULL,'2023-02-10 20:31:40','2023-02-12 23:22:58','2023-02-12 23:22:58'),(2495,7851,948,40719,18,21,384,2,2501.97,NULL,'2023-02-10 20:31:40','2023-02-12 23:22:58','2023-02-12 23:22:58'),(2496,7851,949,40719,18,20,13,2,5000.09,NULL,'2023-02-10 20:34:08','2023-02-10 20:49:14','2023-02-10 20:49:14'),(2497,7851,949,40719,18,20,488,1,5000.09,NULL,'2023-02-10 20:34:08','2023-02-10 20:49:14','2023-02-10 20:49:14'),(2498,7851,950,40719,18,21,57,1,7499.92,NULL,'2023-02-10 20:35:18','2023-02-10 20:35:18',NULL);
INSERT INTO `balance_libro_details` VALUES (2499,7851,950,40719,18,21,488,2,7499.92,NULL,'2023-02-10 20:35:18','2023-02-10 20:35:18',NULL),(2500,7851,951,40719,18,21,57,1,5400.00,NULL,'2023-02-10 20:36:11','2023-02-10 20:36:11',NULL),(2501,7851,951,40719,18,21,488,2,5400.00,NULL,'2023-02-10 20:36:11','2023-02-10 20:36:11',NULL),(2502,7851,952,40719,18,21,57,1,6573.00,NULL,'2023-02-10 20:42:35','2023-02-10 20:42:35',NULL),(2503,7851,952,40719,18,21,494,2,6573.00,NULL,'2023-02-10 20:42:35','2023-02-10 20:42:35',NULL),(2504,7851,953,40719,18,21,57,1,4500.00,NULL,'2023-02-10 20:43:17','2023-02-10 20:43:17',NULL),(2505,7851,953,40719,18,21,493,2,4500.00,NULL,'2023-02-10 20:43:17','2023-02-10 20:43:17',NULL),(2506,7851,954,40719,18,21,57,1,51999.00,NULL,'2023-02-10 20:46:34','2023-02-10 20:46:34',NULL),(2507,7851,954,40719,18,21,493,2,51999.00,NULL,'2023-02-10 20:46:34','2023-02-10 20:46:34',NULL),(2508,7851,955,40719,18,21,57,1,55798.00,NULL,'2023-02-10 20:49:02','2023-02-10 20:49:02',NULL),(2509,7851,955,40719,18,21,494,2,27899.00,NULL,'2023-02-10 20:49:02','2023-02-10 20:49:02',NULL),(2510,7851,955,40719,18,21,494,2,27899.00,NULL,'2023-02-10 20:49:02','2023-02-10 20:49:02',NULL),(2511,7851,956,40719,18,21,57,1,5000.09,NULL,'2023-02-10 20:49:53','2023-02-10 20:49:53',NULL),(2512,7851,956,40719,18,21,488,2,5000.09,NULL,'2023-02-10 20:49:53','2023-02-10 20:49:53',NULL),(2513,7851,957,40719,18,20,13,2,27899.00,NULL,'2023-02-10 20:50:53','2023-02-10 20:50:53',NULL),(2514,7851,957,40719,18,20,494,1,27899.00,NULL,'2023-02-10 20:50:53','2023-02-10 20:50:53',NULL),(2515,7851,958,40719,18,21,57,1,8799.99,NULL,'2023-02-10 20:53:51','2023-02-10 20:53:51',NULL),(2516,7851,958,40719,18,21,494,2,8799.99,NULL,'2023-02-10 20:53:51','2023-02-10 20:53:51',NULL),(2517,7851,959,40719,18,21,57,1,25419.99,NULL,'2023-02-10 20:58:02','2023-02-10 20:58:13','2023-02-10 20:58:13'),(2518,7851,959,40719,18,21,494,2,25419.99,NULL,'2023-02-10 20:58:02','2023-02-10 20:58:13','2023-02-10 20:58:13'),(2519,7851,960,40719,18,21,57,1,2000.00,NULL,'2023-02-10 21:01:08','2023-02-10 21:01:08',NULL),(2520,7851,960,40719,18,21,488,2,2000.00,NULL,'2023-02-10 21:01:08','2023-02-10 21:01:08',NULL),(2521,7851,961,40719,18,21,57,1,28901.15,NULL,'2023-02-10 21:05:04','2023-03-03 11:43:07','2023-03-03 11:43:07'),(2522,7851,961,40719,18,21,488,2,28901.15,NULL,'2023-02-10 21:05:04','2023-03-03 11:43:07','2023-03-03 11:43:07'),(2523,7851,962,40719,18,21,57,1,4289.99,NULL,'2023-02-10 21:05:43','2023-02-10 21:05:43',NULL),(2524,7851,962,40719,18,21,494,2,4289.99,NULL,'2023-02-10 21:05:43','2023-02-10 21:05:43',NULL),(2525,7851,963,40719,18,21,57,1,21864.99,NULL,'2023-02-10 21:07:37','2023-02-10 21:07:37',NULL),(2526,7851,963,40719,18,21,494,2,21864.99,NULL,'2023-02-10 21:07:37','2023-02-10 21:07:37',NULL),(2527,7851,964,40719,19,19,483,2,40000.00,NULL,'2023-02-12 14:26:58','2023-02-12 14:26:58',NULL),(2528,7851,964,40719,19,19,484,1,40000.00,NULL,'2023-02-12 14:26:58','2023-02-12 14:26:58',NULL),(2529,7851,965,40719,18,15,67,1,97572.94,NULL,'2023-02-12 19:29:56','2023-02-12 19:29:56',NULL),(2530,7851,965,40719,18,15,68,2,44463.56,NULL,'2023-02-12 19:29:56','2023-02-12 19:29:56',NULL),(2531,7851,965,40719,18,15,220,2,1213.76,NULL,'2023-02-12 19:29:56','2023-02-12 19:29:56',NULL),(2532,7851,965,40719,18,15,74,2,50077.61,NULL,'2023-02-12 19:29:56','2023-02-12 19:29:56',NULL),(2533,7851,965,40719,18,15,136,2,1818.01,NULL,'2023-02-12 19:29:56','2023-02-12 19:29:56',NULL),(2534,7851,966,40719,18,21,531,1,7007.99,NULL,'2023-02-12 22:19:19','2023-02-12 22:19:19',NULL),(2535,7851,966,40719,18,21,163,2,7007.99,NULL,'2023-02-12 22:19:19','2023-02-12 22:19:19',NULL),(2536,7851,967,40719,14,21,163,2,7007.99,NULL,'2023-02-12 22:19:52','2023-02-12 22:19:52',NULL),(2537,7851,967,40719,14,21,531,1,7007.99,NULL,'2023-02-12 22:19:52','2023-02-12 22:19:52',NULL),(2538,7851,968,40719,13,21,163,2,7007.99,NULL,'2023-02-12 22:20:22','2023-02-12 22:20:22',NULL),(2539,7851,968,40719,13,21,531,1,7007.99,NULL,'2023-02-12 22:20:22','2023-02-12 22:20:22',NULL);
INSERT INTO `balance_libro_details` VALUES (2540,7851,969,40719,19,3,63,2,18115.95,NULL,'2023-02-12 22:46:29','2023-02-12 22:46:29',NULL),(2541,7851,969,40719,19,3,191,1,18115.95,NULL,'2023-02-12 22:46:29','2023-02-12 22:46:29',NULL),(2542,7851,970,40719,18,21,57,1,2501.97,NULL,'2023-02-12 23:23:23','2023-02-12 23:23:23',NULL),(2543,7851,970,40719,18,21,488,2,2501.97,NULL,'2023-02-12 23:23:23','2023-02-12 23:23:23',NULL),(2544,7851,971,40719,19,19,163,1,8000.00,NULL,'2023-02-13 11:50:22','2023-02-13 11:50:22',NULL),(2545,7851,971,40719,19,19,483,2,8000.00,NULL,'2023-02-13 11:50:22','2023-02-13 11:50:22',NULL),(2546,7851,972,40719,19,19,486,2,950000.00,NULL,'2023-02-13 11:52:23','2023-02-13 11:52:23',NULL),(2547,7851,972,40719,19,19,163,1,1012465.75,NULL,'2023-02-13 11:52:23','2023-02-13 11:52:23',NULL),(2548,7851,972,40719,19,19,490,2,62465.75,NULL,'2023-02-13 11:52:23','2023-02-13 11:52:23',NULL),(2549,7851,973,40719,19,19,163,2,1020000.00,NULL,'2023-02-13 11:53:13','2023-02-13 11:59:19','2023-02-13 11:59:19'),(2550,7851,973,40719,19,19,486,1,1020000.00,NULL,'2023-02-13 11:53:13','2023-02-13 11:59:19','2023-02-13 11:59:19'),(2551,7851,974,40719,19,19,163,2,1020000.00,NULL,'2023-02-13 11:59:19','2023-02-13 12:00:07','2023-02-13 12:00:07'),(2552,7851,974,40719,19,19,486,1,1020000.00,NULL,'2023-02-13 11:59:19','2023-02-13 12:00:07','2023-02-13 12:00:07'),(2553,7851,975,40719,19,19,163,2,1020000.00,NULL,'2023-02-13 12:00:07','2023-02-13 12:00:07',NULL),(2554,7851,975,40719,19,19,547,1,1020000.00,NULL,'2023-02-13 12:00:07','2023-02-13 12:00:07',NULL),(2555,7851,976,40719,19,2,163,1,1.93,NULL,'2023-02-13 12:56:20','2023-02-13 12:56:20',NULL),(2556,7851,976,40719,19,2,545,2,1.93,NULL,'2023-02-13 12:56:20','2023-02-13 12:56:20',NULL),(2557,7851,977,40719,19,3,217,1,1723.80,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2558,7851,977,40719,19,3,68,1,362.00,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2559,7851,977,40719,19,3,57,2,2085.80,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2560,7851,978,40719,19,3,217,1,904.97,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2561,7851,978,40719,19,3,68,1,95.02,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2562,7851,978,40719,19,3,57,2,999.99,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2563,7851,979,40719,19,3,217,1,6198.35,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2564,7851,979,40719,19,3,68,1,1301.65,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2565,7851,979,40719,19,3,57,2,7500.00,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2566,7851,980,40719,19,3,217,1,9400.83,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2567,7851,980,40719,19,3,68,1,1974.17,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2568,7851,980,40719,19,3,57,2,11375.00,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2569,7851,981,40719,19,3,217,1,6762.74,NULL,'2023-02-17 18:39:55','2023-03-03 12:54:25','2023-03-03 12:54:25'),(2570,7851,981,40719,19,3,68,1,1420.17,NULL,'2023-02-17 18:39:55','2023-03-03 12:54:25','2023-03-03 12:54:25'),(2571,7851,981,40719,19,3,217,1,1045.28,NULL,'2023-02-17 18:39:55','2023-03-03 12:54:25','2023-03-03 12:54:25'),(2572,7851,981,40719,19,3,57,2,9228.19,NULL,'2023-02-17 18:39:55','2023-03-03 12:54:25','2023-03-03 12:54:25'),(2573,7851,982,40719,19,3,120,1,1405.96,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2574,7851,982,40719,19,3,68,1,379.61,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2575,7851,982,40719,19,3,57,2,1785.57,NULL,'2023-02-17 18:39:55','2023-02-17 18:39:55',NULL),(2576,7851,983,40719,19,3,120,1,11195.80,NULL,'2023-02-17 18:39:55','2023-03-12 18:35:42','2023-03-12 18:35:42'),(2577,7851,983,40719,19,3,68,1,2987.71,NULL,'2023-02-17 18:39:55','2023-03-12 18:35:42','2023-03-12 18:35:42'),(2578,7851,983,40719,19,3,120,1,894.27,NULL,'2023-02-17 18:39:55','2023-03-12 18:35:42','2023-03-12 18:35:42');
INSERT INTO `balance_libro_details` VALUES (2579,7851,983,40719,19,3,57,2,15077.78,NULL,'2023-02-17 18:39:55','2023-03-12 18:35:42','2023-03-12 18:35:42'),(2580,7851,984,40719,19,3,217,1,1362.02,NULL,'2023-02-17 18:39:55','2023-03-03 12:53:46','2023-03-03 12:53:46'),(2581,7851,984,40719,19,3,68,1,286.03,NULL,'2023-02-17 18:39:55','2023-03-03 12:53:46','2023-03-03 12:53:46'),(2582,7851,984,40719,19,3,217,1,355.86,NULL,'2023-02-17 18:39:55','2023-03-03 12:53:46','2023-03-03 12:53:46'),(2583,7851,984,40719,19,3,57,2,2003.91,NULL,'2023-02-17 18:39:55','2023-03-03 12:53:46','2023-03-03 12:53:46'),(2584,7851,985,40719,18,21,57,1,999.99,NULL,'2023-02-17 18:47:16','2023-02-17 18:47:16',NULL),(2585,7851,985,40719,18,21,494,2,999.99,NULL,'2023-02-17 18:47:16','2023-02-17 18:47:16',NULL),(2586,7851,986,40719,19,21,57,1,2085.80,NULL,'2023-02-17 18:48:57','2023-02-17 18:48:57',NULL),(2587,7851,986,40719,19,21,163,2,2085.80,NULL,'2023-02-17 18:48:57','2023-02-17 18:48:57',NULL),(2588,7851,987,40719,19,19,163,1,51000.00,NULL,'2023-02-17 18:50:25','2023-02-17 18:50:25',NULL),(2589,7851,987,40719,19,19,483,2,51000.00,NULL,'2023-02-17 18:50:25','2023-02-17 18:50:25',NULL),(2590,7851,988,40719,19,19,163,2,51000.00,NULL,'2023-02-17 18:54:47','2023-02-17 18:54:47',NULL),(2591,7851,988,40719,19,19,548,1,51000.00,NULL,'2023-02-17 18:54:47','2023-02-17 18:54:47',NULL),(2592,7851,989,40719,19,21,57,1,7500.00,NULL,'2023-02-17 19:05:40','2023-03-18 20:49:21','2023-03-18 20:49:21'),(2593,7851,989,40719,19,21,483,2,7500.00,NULL,'2023-02-17 19:05:40','2023-03-18 20:49:21','2023-03-18 20:49:21'),(2594,7851,990,40719,19,21,57,1,11375.00,NULL,'2023-02-17 22:07:11','2023-02-17 22:07:11',NULL),(2595,7851,990,40719,19,21,482,2,11375.00,NULL,'2023-02-17 22:07:11','2023-02-17 22:07:11',NULL),(2596,7851,991,40719,19,21,482,2,1423.57,NULL,'2023-02-17 22:45:44','2023-02-17 22:45:44',NULL),(2597,7851,991,40719,19,21,495,1,1423.57,NULL,'2023-02-17 22:45:44','2023-02-17 22:45:44',NULL),(2598,7851,992,40719,19,21,482,2,8386.56,NULL,'2023-02-17 22:47:37','2023-02-17 22:47:37',NULL),(2599,7851,992,40719,19,21,505,1,8386.56,NULL,'2023-02-17 22:47:37','2023-02-17 22:47:37',NULL),(2600,7851,993,40719,19,21,482,2,40000.00,NULL,'2023-02-17 22:58:11','2023-02-17 22:58:11',NULL),(2601,7851,993,40719,19,21,497,1,40000.00,NULL,'2023-02-17 22:58:11','2023-02-17 22:58:11',NULL),(2602,7851,994,40719,19,21,482,2,8575.00,NULL,'2023-02-17 23:02:17','2023-02-17 23:02:17',NULL),(2603,7851,994,40719,19,21,498,1,8575.00,NULL,'2023-02-17 23:02:17','2023-02-17 23:02:17',NULL),(2604,7851,995,40719,19,21,482,2,1822.97,NULL,'2023-02-17 23:05:41','2023-02-17 23:05:41',NULL),(2605,7851,995,40719,19,21,498,1,1822.97,NULL,'2023-02-17 23:05:41','2023-02-17 23:05:41',NULL),(2606,7851,996,40719,19,21,482,2,3450.00,NULL,'2023-02-17 23:06:32','2023-02-17 23:06:32',NULL),(2607,7851,996,40719,19,21,498,1,3450.00,NULL,'2023-02-17 23:06:32','2023-02-17 23:06:32',NULL),(2608,7851,997,40719,19,3,520,1,16906.87,NULL,'2023-02-17 23:07:37','2023-02-17 23:07:37',NULL),(2609,7851,997,40719,19,3,68,1,3550.44,NULL,'2023-02-17 23:07:37','2023-02-17 23:07:37',NULL),(2610,7851,997,40719,19,3,221,1,1542.64,NULL,'2023-02-17 23:07:37','2023-02-17 23:07:37',NULL),(2611,7851,997,40719,19,3,57,2,21999.95,NULL,'2023-02-17 23:07:37','2023-02-17 23:07:37',NULL),(2612,7851,998,40719,19,3,515,1,4841.93,NULL,'2023-02-17 23:12:51','2023-02-17 23:12:51',NULL),(2613,7851,998,40719,19,3,68,1,1016.81,NULL,'2023-02-17 23:12:51','2023-02-17 23:12:51',NULL),(2614,7851,998,40719,19,3,221,1,441.79,NULL,'2023-02-17 23:12:51','2023-02-17 23:12:51',NULL),(2615,7851,998,40719,19,3,57,2,6300.53,NULL,'2023-02-17 23:12:51','2023-02-17 23:12:51',NULL),(2616,7851,999,40719,19,21,57,1,21999.95,NULL,'2023-02-17 23:13:40','2023-02-17 23:13:40',NULL),(2617,7851,999,40719,19,21,484,2,21999.95,NULL,'2023-02-17 23:13:40','2023-02-17 23:13:40',NULL),(2618,7851,1000,40719,19,20,13,2,6300.53,NULL,'2023-02-17 23:15:33','2023-02-17 23:26:46','2023-02-17 23:26:46');
INSERT INTO `balance_libro_details` VALUES (2619,7851,1000,40719,19,20,482,1,6300.53,NULL,'2023-02-17 23:15:33','2023-02-17 23:26:46','2023-02-17 23:26:46'),(2620,7851,1001,40719,19,21,57,1,6300.53,NULL,'2023-02-17 23:27:29','2023-02-17 23:27:29',NULL),(2621,7851,1001,40719,19,21,482,2,6300.53,NULL,'2023-02-17 23:27:29','2023-02-17 23:27:29',NULL),(2622,7851,1002,40719,19,19,483,2,22901.08,NULL,'2023-02-21 18:40:38','2023-02-21 18:40:38',NULL),(2623,7851,1002,40719,19,19,163,1,22901.08,NULL,'2023-02-21 18:40:38','2023-02-21 18:40:38',NULL),(2624,7851,1003,40719,19,3,519,1,412.31,NULL,'2023-02-21 18:44:32','2023-02-21 18:44:32',NULL),(2625,7851,1003,40719,19,3,68,1,86.59,NULL,'2023-02-21 18:44:32','2023-02-21 18:44:32',NULL),(2626,7851,1003,40719,19,3,57,2,498.90,NULL,'2023-02-21 18:44:32','2023-02-21 18:44:32',NULL),(2627,7851,1004,40719,19,21,57,1,498.90,NULL,'2023-02-21 18:46:45','2023-06-06 00:30:30','2023-06-06 00:30:30'),(2628,7851,1004,40719,19,21,483,2,498.90,NULL,'2023-02-21 18:46:45','2023-06-06 00:30:30','2023-06-06 00:30:30'),(2629,7851,1005,40719,18,21,57,1,498.90,NULL,'2023-02-21 18:54:19','2023-06-06 00:30:42','2023-06-06 00:30:42'),(2630,7851,1005,40719,18,21,483,2,498.90,NULL,'2023-02-21 18:54:19','2023-06-06 00:30:42','2023-06-06 00:30:42'),(2631,7851,1006,40719,19,19,534,2,124000.00,NULL,'2023-02-22 12:37:09','2023-02-22 12:37:09',NULL),(2632,7851,1006,40719,19,19,163,1,124000.00,NULL,'2023-02-22 12:37:09','2023-02-22 12:37:09',NULL),(2633,7851,1007,40719,19,19,535,2,31000.00,NULL,'2023-02-22 12:37:48','2023-02-22 12:41:01','2023-02-22 12:41:01'),(2634,7851,1007,40719,19,19,163,1,31000.00,NULL,'2023-02-22 12:37:48','2023-02-22 12:41:01','2023-02-22 12:41:01'),(2635,7851,1008,40719,19,2,163,1,3535.27,NULL,'2023-02-22 12:39:35','2023-02-23 11:02:33','2023-02-23 11:02:33'),(2636,7851,1008,40719,19,2,536,2,3535.27,NULL,'2023-02-22 12:39:35','2023-02-23 11:02:33','2023-02-23 11:02:33'),(2637,7851,1009,40719,19,2,163,1,883.82,NULL,'2023-02-22 12:40:50','2023-02-23 11:02:52','2023-02-23 11:02:52'),(2638,7851,1009,40719,19,2,537,2,883.82,NULL,'2023-02-22 12:40:50','2023-02-23 11:02:52','2023-02-23 11:02:52'),(2639,7851,1010,40719,19,19,535,2,31000.00,NULL,'2023-02-22 12:41:01','2023-02-22 12:41:01',NULL),(2640,7851,1010,40719,19,19,163,1,31000.00,NULL,'2023-02-22 12:41:01','2023-02-22 12:41:01',NULL),(2641,7851,1011,40719,19,19,501,1,1500.00,NULL,'2023-02-23 10:43:20','2023-02-23 10:43:20',NULL),(2642,7851,1011,40719,19,19,482,2,1500.00,NULL,'2023-02-23 10:43:20','2023-02-23 10:43:20',NULL),(2643,7851,1012,40719,19,19,482,2,80000.00,NULL,'2023-02-23 10:44:28','2023-02-23 10:44:28',NULL),(2644,7851,1012,40719,19,19,163,1,80000.00,NULL,'2023-02-23 10:44:28','2023-02-23 10:44:28',NULL),(2645,7851,1013,40719,19,19,482,2,10000.00,NULL,'2023-02-23 10:45:02','2023-02-23 10:45:02',NULL),(2646,7851,1013,40719,19,19,163,1,10000.00,NULL,'2023-02-23 10:45:02','2023-02-23 10:45:02',NULL),(2647,7851,1014,40719,19,21,531,1,115556.88,NULL,'2023-02-23 10:48:08','2023-02-23 10:48:08',NULL),(2648,7851,1014,40719,19,21,163,2,115556.88,NULL,'2023-02-23 10:48:08','2023-02-23 10:48:08',NULL),(2649,7851,1015,40719,19,21,531,1,7077.99,NULL,'2023-02-23 10:49:30','2023-02-23 10:49:30',NULL),(2650,7851,1015,40719,19,21,163,2,7077.99,NULL,'2023-02-23 10:49:30','2023-02-23 10:49:30',NULL),(2651,7851,1016,40719,19,21,163,2,7077.99,NULL,'2023-02-23 10:50:35','2023-02-23 10:50:35',NULL),(2652,7851,1016,40719,19,21,531,1,7077.99,NULL,'2023-02-23 10:50:35','2023-02-23 10:50:35',NULL),(2653,7851,1017,40719,19,21,163,2,7078.01,NULL,'2023-02-23 10:51:20','2023-02-23 10:51:20',NULL),(2654,7851,1017,40719,19,21,531,1,7078.01,NULL,'2023-02-23 10:51:20','2023-02-23 10:51:20',NULL),(2655,7851,1018,40719,19,2,163,1,3931.04,NULL,'2023-02-23 11:02:33','2023-02-23 11:02:33',NULL),(2656,7851,1018,40719,19,2,536,2,3931.04,NULL,'2023-02-23 11:02:33','2023-02-23 11:02:33',NULL),(2657,7851,1019,40719,19,2,163,1,982.76,NULL,'2023-02-23 11:02:52','2023-02-23 11:02:52',NULL);
INSERT INTO `balance_libro_details` VALUES (2658,7851,1019,40719,19,2,537,2,982.76,NULL,'2023-02-23 11:02:52','2023-02-23 11:02:52',NULL),(2659,7851,1020,40719,19,21,57,1,1785.57,NULL,'2023-02-23 11:06:31','2023-03-12 18:33:11','2023-03-12 18:33:11'),(2660,7851,1020,40719,19,21,163,2,1785.57,NULL,'2023-02-23 11:06:31','2023-03-12 18:33:11','2023-03-12 18:33:11'),(2661,7851,1021,40719,19,21,57,1,15077.78,NULL,'2023-02-23 11:07:16','2023-03-12 18:33:03','2023-03-12 18:33:03'),(2662,7851,1021,40719,19,21,163,2,15077.78,NULL,'2023-02-23 11:07:16','2023-03-12 18:33:03','2023-03-12 18:33:03'),(2663,7851,1022,40719,19,19,163,1,80000.00,NULL,'2023-03-02 18:49:11','2023-03-02 18:49:28','2023-03-02 18:49:28'),(2664,7851,1022,40719,19,19,482,2,80000.00,NULL,'2023-03-02 18:49:11','2023-03-02 18:49:28','2023-03-02 18:49:28'),(2665,7851,1023,40719,19,3,110,2,28800.00,NULL,'2023-03-02 18:50:59','2023-03-02 18:50:59',NULL),(2666,7851,1023,40719,19,3,62,1,28800.00,NULL,'2023-03-02 18:50:59','2023-03-02 18:50:59',NULL),(2667,7851,1024,40719,19,3,491,1,51200.00,NULL,'2023-03-02 18:52:02','2023-03-02 18:52:02',NULL),(2668,7851,1024,40719,19,3,518,2,51200.00,NULL,'2023-03-02 18:52:02','2023-03-02 18:52:02',NULL),(2669,7851,1025,40719,19,21,163,2,51200.00,NULL,'2023-03-02 18:53:24','2023-03-02 18:53:24',NULL),(2670,7851,1025,40719,19,21,491,1,51200.00,NULL,'2023-03-02 18:53:24','2023-03-02 18:53:24',NULL),(2671,7851,1026,40719,19,21,163,2,28800.00,NULL,'2023-03-02 18:54:04','2023-03-02 18:54:04',NULL),(2672,7851,1026,40719,19,21,62,1,28800.00,NULL,'2023-03-02 18:54:04','2023-03-02 18:54:04',NULL),(2673,7851,1027,40719,19,19,163,1,200588.02,NULL,'2023-03-02 21:42:56','2023-03-02 21:46:12','2023-03-02 21:46:12'),(2674,7851,1027,40719,19,19,547,2,200588.02,NULL,'2023-03-02 21:42:56','2023-03-02 21:46:12','2023-03-02 21:46:12'),(2675,7851,1028,40719,19,19,163,1,200588.02,NULL,'2023-03-02 21:46:12','2023-03-02 21:47:47','2023-03-02 21:47:47'),(2676,7851,1028,40719,19,19,547,2,192275.12,NULL,'2023-03-02 21:46:12','2023-03-02 21:47:47','2023-03-02 21:47:47'),(2677,7851,1028,40719,19,19,550,2,8312.90,NULL,'2023-03-02 21:46:12','2023-03-02 21:47:47','2023-03-02 21:47:47'),(2678,7851,1029,40719,20,19,163,2,30000.00,NULL,'2023-03-02 21:47:37','2023-03-02 21:47:37',NULL),(2679,7851,1029,40719,20,19,484,1,30000.00,NULL,'2023-03-02 21:47:37','2023-03-02 21:47:37',NULL),(2680,7851,1030,40719,20,19,163,1,200588.02,NULL,'2023-03-02 21:47:47','2023-03-02 21:47:47',NULL),(2681,7851,1030,40719,20,19,547,2,192275.12,NULL,'2023-03-02 21:47:47','2023-03-02 21:47:47',NULL),(2682,7851,1030,40719,20,19,550,2,8312.90,NULL,'2023-03-02 21:47:47','2023-03-02 21:47:47',NULL),(2683,7851,1031,40719,20,19,163,2,50000.00,NULL,'2023-03-02 21:48:59','2023-03-03 10:34:52','2023-03-03 10:34:52'),(2684,7851,1031,40719,20,19,484,1,50000.00,NULL,'2023-03-02 21:48:59','2023-03-03 10:34:52','2023-03-03 10:34:52'),(2685,7851,1032,40719,19,21,482,2,40000.00,NULL,'2023-03-03 10:25:14','2023-03-03 10:25:14',NULL),(2686,7851,1032,40719,19,21,497,1,40000.00,NULL,'2023-03-03 10:25:14','2023-03-03 10:25:14',NULL),(2687,7851,1033,40719,19,2,511,1,3.41,NULL,'2023-03-03 10:26:41','2023-03-03 12:08:15','2023-03-03 12:08:15'),(2688,7851,1033,40719,19,2,482,2,3.41,NULL,'2023-03-03 10:26:41','2023-03-03 12:08:15','2023-03-03 12:08:15'),(2689,7851,1034,40719,19,21,497,1,15000.00,NULL,'2023-03-03 10:27:59','2023-03-03 10:27:59',NULL),(2690,7851,1034,40719,19,21,482,2,15000.00,NULL,'2023-03-03 10:27:59','2023-03-03 10:27:59',NULL),(2691,7851,1035,40719,20,21,396,1,251.65,NULL,'2023-03-03 10:30:19','2023-03-03 10:30:51','2023-03-03 10:30:51'),(2692,7851,1035,40719,20,21,68,1,1198.34,NULL,'2023-03-03 10:30:19','2023-03-03 10:30:51','2023-03-03 10:30:51'),(2693,7851,1035,40719,20,21,482,2,251.65,NULL,'2023-03-03 10:30:19','2023-03-03 10:30:51','2023-03-03 10:30:51'),(2694,7851,1035,40719,20,21,482,2,1198.34,NULL,'2023-03-03 10:30:19','2023-03-03 10:30:51','2023-03-03 10:30:51');
INSERT INTO `balance_libro_details` VALUES (2695,7851,1036,40719,20,21,396,1,1198.34,NULL,'2023-03-03 10:30:51','2023-03-31 18:15:49','2023-03-31 18:15:49'),(2696,7851,1036,40719,20,21,482,2,1198.34,NULL,'2023-03-03 10:30:51','2023-03-31 18:15:49','2023-03-31 18:15:49'),(2697,7851,1037,40719,20,21,482,2,251.65,NULL,'2023-03-03 10:31:49','2023-03-31 18:15:17','2023-03-31 18:15:17'),(2698,7851,1037,40719,20,21,68,1,251.65,NULL,'2023-03-03 10:31:49','2023-03-31 18:15:17','2023-03-31 18:15:17'),(2699,7851,1038,40719,19,21,482,2,20010.00,NULL,'2023-03-03 10:33:50','2023-03-03 10:33:50',NULL),(2700,7851,1038,40719,19,21,495,1,20010.00,NULL,'2023-03-03 10:33:50','2023-03-03 10:33:50',NULL),(2701,7851,1039,40719,20,19,163,2,50000.00,NULL,'2023-03-03 10:34:52','2023-03-03 10:34:52',NULL),(2702,7851,1039,40719,20,19,482,1,50000.00,NULL,'2023-03-03 10:34:52','2023-03-03 10:34:52',NULL),(2703,7851,1040,40719,20,19,488,2,50000.00,NULL,'2023-03-03 10:36:28','2023-03-03 10:37:56','2023-03-03 10:37:56'),(2704,7851,1040,40719,20,19,482,1,50000.00,NULL,'2023-03-03 10:36:28','2023-03-03 10:37:56','2023-03-03 10:37:56'),(2705,7851,1041,40719,20,19,482,2,50000.00,NULL,'2023-03-03 10:37:39','2023-03-03 10:37:39',NULL),(2706,7851,1041,40719,20,19,508,1,50000.00,NULL,'2023-03-03 10:37:39','2023-03-03 10:37:39',NULL),(2707,7851,1042,40719,20,19,482,1,50000.00,NULL,'2023-03-03 10:37:56','2023-03-03 10:37:56',NULL),(2708,7851,1042,40719,20,19,508,2,50000.00,NULL,'2023-03-03 10:37:56','2023-03-03 10:37:56',NULL),(2709,7851,1043,40719,19,2,500,2,93789.21,NULL,'2023-03-03 10:40:45','2023-03-31 18:18:33','2023-03-31 18:18:33'),(2710,7851,1043,40719,19,2,482,1,93789.21,NULL,'2023-03-03 10:40:45','2023-03-31 18:18:33','2023-03-31 18:18:33'),(2711,7851,1044,40719,20,21,396,1,3310.37,NULL,'2023-03-03 10:41:50','2023-03-03 10:42:46','2023-03-03 10:42:46'),(2712,7851,1044,40719,20,21,482,2,3310.37,NULL,'2023-03-03 10:41:50','2023-03-03 10:42:46','2023-03-03 10:42:46'),(2713,7851,1045,40719,20,21,482,2,585.38,NULL,'2023-03-03 10:42:37','2023-03-03 10:42:37',NULL),(2714,7851,1045,40719,20,21,396,1,585.38,NULL,'2023-03-03 10:42:37','2023-03-03 10:42:37',NULL),(2715,7851,1046,40719,20,21,396,1,3310.37,NULL,'2023-03-03 10:42:46','2023-03-03 10:42:46',NULL),(2716,7851,1046,40719,20,21,482,2,3310.37,NULL,'2023-03-03 10:42:46','2023-03-03 10:42:46',NULL),(2717,7851,1047,40719,20,21,497,1,20000.00,NULL,'2023-03-03 10:43:31','2023-03-03 10:43:31',NULL),(2718,7851,1047,40719,20,21,482,2,20000.00,NULL,'2023-03-03 10:43:31','2023-03-03 10:43:31',NULL),(2719,7851,1048,40719,20,21,497,1,20000.00,NULL,'2023-03-03 10:44:06','2023-03-03 10:44:06',NULL),(2720,7851,1048,40719,20,21,482,2,20000.00,NULL,'2023-03-03 10:44:06','2023-03-03 10:44:06',NULL),(2721,7851,1049,40719,11,21,505,1,9869.60,NULL,'2023-03-03 11:42:27','2023-03-03 11:42:27',NULL),(2722,7851,1049,40719,11,21,482,2,9869.60,NULL,'2023-03-03 11:42:27','2023-03-03 11:42:27',NULL),(2723,7851,1050,40719,14,21,482,2,8386.56,NULL,'2023-03-03 11:42:42','2023-03-03 11:42:42',NULL),(2724,7851,1050,40719,14,21,505,1,8386.56,NULL,'2023-03-03 11:42:42','2023-03-03 11:42:42',NULL),(2725,7851,1051,40719,18,21,57,1,7401.06,NULL,'2023-03-03 11:43:49','2023-03-03 11:43:49',NULL),(2726,7851,1051,40719,18,21,482,2,7401.06,NULL,'2023-03-03 11:43:49','2023-03-03 11:43:49',NULL),(2727,7851,1052,40719,18,21,482,2,415.17,NULL,'2023-03-03 11:45:18','2023-03-03 11:45:18',NULL),(2728,7851,1052,40719,18,21,396,1,415.17,NULL,'2023-03-03 11:45:18','2023-03-03 11:45:18',NULL),(2729,7851,1053,40719,18,21,482,2,1452.30,NULL,'2023-03-03 11:46:11','2023-03-03 11:46:11',NULL),(2730,7851,1053,40719,18,21,396,1,1452.30,NULL,'2023-03-03 11:46:11','2023-03-03 11:46:11',NULL),(2731,7851,1054,40719,18,2,488,2,0.06,NULL,'2023-03-03 12:03:43','2023-03-03 12:09:57','2023-03-03 12:09:57'),(2732,7851,1054,40719,18,2,482,1,0.06,NULL,'2023-03-03 12:03:43','2023-03-03 12:09:57','2023-03-03 12:09:57'),(2733,7851,1055,40719,19,2,511,2,3.41,NULL,'2023-03-03 12:08:15','2023-03-03 12:08:15',NULL);
INSERT INTO `balance_libro_details` VALUES (2734,7851,1055,40719,19,2,482,1,3.41,NULL,'2023-03-03 12:08:15','2023-03-03 12:08:15',NULL),(2735,7851,1056,40719,19,2,482,1,0.53,NULL,'2023-03-03 12:09:41','2023-03-03 12:09:41',NULL),(2736,7851,1056,40719,19,2,136,2,0.53,NULL,'2023-03-03 12:09:41','2023-03-03 12:09:41',NULL),(2737,7851,1057,40719,18,2,482,1,0.06,NULL,'2023-03-03 12:09:57','2023-03-03 12:09:57',NULL),(2738,7851,1057,40719,18,2,136,2,0.06,NULL,'2023-03-03 12:09:57','2023-03-03 12:09:57',NULL),(2739,7851,1058,40719,19,3,163,1,2545.45,NULL,'2023-03-03 12:52:03','2023-03-07 22:55:25','2023-03-07 22:55:25'),(2740,7851,1058,40719,19,3,68,1,534.55,NULL,'2023-03-03 12:52:03','2023-03-07 22:55:25','2023-03-07 22:55:25'),(2741,7851,1058,40719,19,3,163,1,320.00,NULL,'2023-03-03 12:52:03','2023-03-07 22:55:25','2023-03-07 22:55:25'),(2742,7851,1058,40719,19,3,57,2,3400.00,NULL,'2023-03-03 12:52:03','2023-03-07 22:55:25','2023-03-07 22:55:25'),(2743,7851,1059,40719,19,3,217,1,16528.93,NULL,'2023-03-03 12:52:03','2023-03-03 12:52:03',NULL),(2744,7851,1059,40719,19,3,68,1,3471.08,NULL,'2023-03-03 12:52:03','2023-03-03 12:52:03',NULL),(2745,7851,1059,40719,19,3,57,2,20000.01,NULL,'2023-03-03 12:52:03','2023-03-03 12:52:03',NULL),(2746,7851,1060,40719,19,3,217,1,3719.01,NULL,'2023-03-03 12:52:03','2023-03-03 12:52:03',NULL),(2747,7851,1060,40719,19,3,68,1,780.99,NULL,'2023-03-03 12:52:03','2023-03-03 12:52:03',NULL),(2748,7851,1060,40719,19,3,57,2,4500.00,NULL,'2023-03-03 12:52:03','2023-03-03 12:52:03',NULL),(2749,7851,1061,40719,19,3,217,1,1362.02,NULL,'2023-03-03 12:53:46','2023-03-03 12:53:46',NULL),(2750,7851,1061,40719,19,3,68,1,286.02,NULL,'2023-03-03 12:53:46','2023-03-03 12:53:46',NULL),(2751,7851,1061,40719,19,3,221,1,355.86,NULL,'2023-03-03 12:53:46','2023-03-03 12:53:46',NULL),(2752,7851,1061,40719,19,3,57,2,2003.90,NULL,'2023-03-03 12:53:46','2023-03-03 12:53:46',NULL),(2753,7851,1062,40719,19,3,217,1,6762.74,NULL,'2023-03-03 12:54:25','2023-03-03 12:54:25',NULL),(2754,7851,1062,40719,19,3,68,1,1420.18,NULL,'2023-03-03 12:54:25','2023-03-03 12:54:25',NULL),(2755,7851,1062,40719,19,3,221,1,1045.28,NULL,'2023-03-03 12:54:25','2023-03-03 12:54:25',NULL),(2756,7851,1062,40719,19,3,57,2,9228.20,NULL,'2023-03-03 12:54:25','2023-03-03 12:54:25',NULL),(2757,7851,1063,40719,19,3,507,1,2248.10,NULL,'2023-03-03 18:22:39','2023-03-03 18:22:39',NULL),(2758,7851,1063,40719,19,3,68,1,472.10,NULL,'2023-03-03 18:22:39','2023-03-03 18:22:39',NULL),(2759,7851,1063,40719,19,3,221,1,279.80,NULL,'2023-03-03 18:22:39','2023-03-03 18:22:39',NULL),(2760,7851,1063,40719,19,3,57,2,3000.00,NULL,'2023-03-03 18:22:39','2023-03-03 18:22:39',NULL),(2761,7851,1064,40719,19,3,507,1,1511.58,NULL,'2023-03-03 18:24:33','2023-03-03 18:24:33',NULL),(2762,7851,1064,40719,19,3,68,1,317.43,NULL,'2023-03-03 18:24:33','2023-03-03 18:24:33',NULL),(2763,7851,1064,40719,19,3,221,1,170.99,NULL,'2023-03-03 18:24:33','2023-03-03 18:24:33',NULL),(2764,7851,1064,40719,19,3,57,2,2000.00,NULL,'2023-03-03 18:24:33','2023-03-03 18:24:33',NULL),(2765,7851,1065,40719,19,3,520,1,10552.79,NULL,'2023-03-03 18:31:07','2023-03-03 18:31:07',NULL),(2766,7851,1065,40719,19,3,68,1,2216.09,NULL,'2023-03-03 18:31:07','2023-03-03 18:31:07',NULL),(2767,7851,1065,40719,19,3,221,1,1231.12,NULL,'2023-03-03 18:31:07','2023-03-03 18:31:07',NULL),(2768,7851,1065,40719,19,3,57,2,14000.00,NULL,'2023-03-03 18:31:07','2023-03-03 18:31:07',NULL),(2769,7851,1066,40719,19,21,57,1,14000.00,NULL,'2023-03-03 18:39:31','2023-03-03 18:39:31',NULL),(2770,7851,1066,40719,19,21,484,2,14000.00,NULL,'2023-03-03 18:39:31','2023-03-03 18:39:31',NULL),(2771,7851,1067,40719,19,21,57,1,2000.00,NULL,'2023-03-03 18:40:59','2023-03-03 18:40:59',NULL),(2772,7851,1067,40719,19,21,488,2,2000.00,NULL,'2023-03-03 18:40:59','2023-03-03 18:40:59',NULL),(2773,7851,1068,40719,19,21,57,1,3000.00,NULL,'2023-03-03 18:46:28','2023-03-03 18:46:28',NULL),(2774,7851,1068,40719,19,21,488,2,3000.00,NULL,'2023-03-03 18:46:28','2023-03-03 18:46:28',NULL);
INSERT INTO `balance_libro_details` VALUES (2775,7851,1069,40719,19,21,57,1,9228.20,NULL,'2023-03-03 18:51:03','2023-03-03 18:51:03',NULL),(2776,7851,1069,40719,19,21,488,2,9228.20,NULL,'2023-03-03 18:51:03','2023-03-03 18:51:03',NULL),(2777,7851,1070,40719,19,21,57,1,3400.00,NULL,'2023-03-03 18:55:13','2023-03-07 22:54:43','2023-03-07 22:54:43'),(2778,7851,1070,40719,19,21,488,2,3400.00,NULL,'2023-03-03 18:55:13','2023-03-07 22:54:43','2023-03-07 22:54:43'),(2779,7851,1071,40719,19,21,57,1,20000.01,NULL,'2023-03-03 18:58:39','2023-03-03 18:58:39',NULL),(2780,7851,1071,40719,19,21,482,2,20000.01,NULL,'2023-03-03 18:58:39','2023-03-03 18:58:39',NULL),(2781,7851,1072,40719,19,21,57,1,2003.90,NULL,'2023-03-03 19:00:53','2023-03-03 19:00:53',NULL),(2782,7851,1072,40719,19,21,488,2,2003.90,NULL,'2023-03-03 19:00:53','2023-03-03 19:00:53',NULL),(2783,7851,1073,40719,20,19,504,2,20000.00,NULL,'2023-03-07 20:23:17','2023-03-07 20:23:17',NULL),(2784,7851,1073,40719,20,19,482,1,20000.00,NULL,'2023-03-07 20:23:17','2023-03-07 20:23:17',NULL),(2785,7851,1074,40719,20,21,492,1,17000.00,NULL,'2023-03-07 20:46:33','2023-03-07 20:47:48','2023-03-07 20:47:48'),(2786,7851,1074,40719,20,21,482,2,17000.00,NULL,'2023-03-07 20:46:33','2023-03-07 20:47:48','2023-03-07 20:47:48'),(2787,7851,1075,40719,20,19,497,1,30000.00,NULL,'2023-03-07 20:47:40','2023-03-07 20:47:40',NULL),(2788,7851,1075,40719,20,19,482,2,30000.00,NULL,'2023-03-07 20:47:40','2023-03-07 20:47:40',NULL),(2789,7851,1076,40719,20,21,492,1,17000.00,NULL,'2023-03-07 20:47:48','2023-03-07 20:47:48',NULL),(2790,7851,1076,40719,20,21,482,2,17000.00,NULL,'2023-03-07 20:47:48','2023-03-07 20:47:48',NULL),(2791,7851,1077,40719,20,21,495,1,10.00,NULL,'2023-03-07 20:50:59','2023-03-07 20:50:59',NULL),(2792,7851,1077,40719,20,21,482,2,10.00,NULL,'2023-03-07 20:50:59','2023-03-07 20:50:59',NULL),(2793,7851,1078,40719,20,2,96,2,1419703.38,NULL,'2023-03-07 21:04:26','2023-03-07 21:04:26',NULL),(2794,7851,1078,40719,20,2,67,2,149068.86,NULL,'2023-03-07 21:04:26','2023-03-07 21:04:26',NULL),(2795,7851,1078,40719,20,2,13,1,1568772.24,NULL,'2023-03-07 21:04:26','2023-03-07 21:04:26',NULL),(2796,7851,1079,40719,20,2,96,2,7239.82,NULL,'2023-03-07 21:04:26','2023-03-07 21:04:26',NULL),(2797,7851,1079,40719,20,2,67,2,760.18,NULL,'2023-03-07 21:04:26','2023-03-07 21:04:26',NULL),(2798,7851,1079,40719,20,2,13,1,8000.00,NULL,'2023-03-07 21:04:26','2023-03-07 21:04:26',NULL),(2799,7851,1080,40719,20,20,13,2,1568772.24,NULL,'2023-03-07 21:08:54','2023-04-10 16:22:21','2023-04-10 16:22:21'),(2800,7851,1080,40719,20,20,482,1,1502260.55,NULL,'2023-03-07 21:08:54','2023-04-10 16:22:21','2023-04-10 16:22:21'),(2801,7851,1080,40719,20,20,23,1,66511.69,NULL,'2023-03-07 21:08:54','2023-04-10 16:22:21','2023-04-10 16:22:21'),(2802,7851,1081,40719,19,3,530,1,2545.45,NULL,'2023-03-07 22:55:25','2023-03-07 22:55:25',NULL),(2803,7851,1081,40719,19,3,68,1,534.54,NULL,'2023-03-07 22:55:25','2023-03-07 22:55:25',NULL),(2804,7851,1081,40719,19,3,530,1,320.00,NULL,'2023-03-07 22:55:25','2023-03-07 22:55:25',NULL),(2805,7851,1081,40719,19,3,57,2,3399.99,NULL,'2023-03-07 22:55:25','2023-03-07 22:55:25',NULL),(2806,7851,1082,40719,19,21,57,1,3399.99,NULL,'2023-03-07 22:56:03','2023-03-07 22:56:03',NULL),(2807,7851,1082,40719,19,21,488,2,3399.99,NULL,'2023-03-07 22:56:03','2023-03-07 22:56:03',NULL),(2808,7851,1083,40719,20,19,547,2,190646.41,NULL,'2023-03-07 22:59:17','2023-03-07 22:59:17',NULL),(2809,7851,1083,40719,20,19,550,2,9728.39,NULL,'2023-03-07 22:59:17','2023-03-07 22:59:17',NULL),(2810,7851,1083,40719,20,19,163,1,200374.80,NULL,'2023-03-07 22:59:17','2023-03-07 22:59:17',NULL),(2811,7851,1084,40719,20,3,217,1,28429.75,NULL,'2023-03-07 23:00:17','2023-04-01 19:22:45','2023-04-01 19:22:45'),(2812,7851,1084,40719,20,3,68,1,5970.25,NULL,'2023-03-07 23:00:17','2023-04-01 19:22:45','2023-04-01 19:22:45'),(2813,7851,1084,40719,20,3,57,2,34400.00,NULL,'2023-03-07 23:00:17','2023-04-01 19:22:45','2023-04-01 19:22:45');
INSERT INTO `balance_libro_details` VALUES (2814,7851,1085,40719,20,3,217,1,1723.80,NULL,'2023-03-07 23:00:17','2023-04-01 19:23:08','2023-04-01 19:23:08'),(2815,7851,1085,40719,20,3,68,1,362.00,NULL,'2023-03-07 23:00:17','2023-04-01 19:23:08','2023-04-01 19:23:08'),(2816,7851,1085,40719,20,3,57,2,2085.80,NULL,'2023-03-07 23:00:17','2023-04-01 19:23:08','2023-04-01 19:23:08'),(2817,7851,1086,40719,20,3,217,1,8159.26,NULL,'2023-03-07 23:00:17','2023-03-07 23:00:50','2023-03-07 23:00:50'),(2818,7851,1086,40719,20,3,68,1,1713.45,NULL,'2023-03-07 23:00:17','2023-03-07 23:00:50','2023-03-07 23:00:50'),(2819,7851,1086,40719,20,3,217,1,631.90,NULL,'2023-03-07 23:00:17','2023-03-07 23:00:50','2023-03-07 23:00:50'),(2820,7851,1086,40719,20,3,57,2,10504.61,NULL,'2023-03-07 23:00:17','2023-03-07 23:00:50','2023-03-07 23:00:50'),(2821,7851,1087,40719,20,3,217,1,7890.83,NULL,'2023-03-07 23:00:17','2023-03-07 23:00:39','2023-03-07 23:00:39'),(2822,7851,1087,40719,20,3,68,1,1657.07,NULL,'2023-03-07 23:00:17','2023-03-07 23:00:39','2023-03-07 23:00:39'),(2823,7851,1087,40719,20,3,217,1,1152.50,NULL,'2023-03-07 23:00:17','2023-03-07 23:00:39','2023-03-07 23:00:39'),(2824,7851,1087,40719,20,3,57,2,10700.40,NULL,'2023-03-07 23:00:17','2023-03-07 23:00:39','2023-03-07 23:00:39'),(2825,7851,1088,40719,20,3,217,1,7890.83,NULL,'2023-03-07 23:00:39','2023-04-01 19:24:20','2023-04-01 19:24:20'),(2826,7851,1088,40719,20,3,68,1,1657.07,NULL,'2023-03-07 23:00:39','2023-04-01 19:24:20','2023-04-01 19:24:20'),(2827,7851,1088,40719,20,3,221,1,1152.50,NULL,'2023-03-07 23:00:39','2023-04-01 19:24:20','2023-04-01 19:24:20'),(2828,7851,1088,40719,20,3,57,2,10700.40,NULL,'2023-03-07 23:00:39','2023-04-01 19:24:20','2023-04-01 19:24:20'),(2829,7851,1089,40719,20,3,217,1,8159.26,NULL,'2023-03-07 23:00:50','2023-04-01 19:23:37','2023-04-01 19:23:37'),(2830,7851,1089,40719,20,3,68,1,1713.44,NULL,'2023-03-07 23:00:50','2023-04-01 19:23:37','2023-04-01 19:23:37'),(2831,7851,1089,40719,20,3,221,1,631.90,NULL,'2023-03-07 23:00:50','2023-04-01 19:23:37','2023-04-01 19:23:37'),(2832,7851,1089,40719,20,3,57,2,10504.60,NULL,'2023-03-07 23:00:50','2023-04-01 19:23:37','2023-04-01 19:23:37'),(2833,7851,1090,40719,20,21,57,1,34400.00,NULL,'2023-03-07 23:01:35','2023-04-01 19:11:39','2023-04-01 19:11:39'),(2834,7851,1090,40719,20,21,163,2,34400.00,NULL,'2023-03-07 23:01:35','2023-04-01 19:11:39','2023-04-01 19:11:39'),(2835,7851,1091,40719,20,2,545,2,0.34,NULL,'2023-03-07 23:03:46','2023-03-07 23:03:46',NULL),(2836,7851,1091,40719,20,2,163,1,0.34,NULL,'2023-03-07 23:03:46','2023-03-07 23:03:46',NULL),(2837,7851,1092,40719,20,21,163,2,52.40,NULL,'2023-03-07 23:06:13','2023-03-07 23:07:50','2023-03-07 23:07:50'),(2838,7851,1092,40719,20,21,140,1,52.40,NULL,'2023-03-07 23:06:13','2023-03-07 23:07:50','2023-03-07 23:07:50'),(2839,7851,1093,40719,20,21,165,2,11.00,NULL,'2023-03-07 23:07:29','2023-03-07 23:07:29',NULL),(2840,7851,1093,40719,20,21,140,1,11.00,NULL,'2023-03-07 23:07:29','2023-03-07 23:07:29',NULL),(2841,7851,1094,40719,20,21,163,2,52.40,NULL,'2023-03-07 23:07:50','2023-03-14 10:38:51','2023-03-14 10:38:51'),(2842,7851,1094,40719,20,21,140,1,52.40,NULL,'2023-03-07 23:07:50','2023-03-14 10:38:51','2023-03-14 10:38:51'),(2843,7851,1095,40719,20,10,165,2,1.23,NULL,'2023-03-07 23:08:45','2023-03-07 23:09:00','2023-03-07 23:09:00'),(2844,7851,1095,40719,20,10,140,1,1.23,NULL,'2023-03-07 23:08:45','2023-03-07 23:09:00','2023-03-07 23:09:00'),(2845,7851,1096,40719,20,21,165,2,1.23,NULL,'2023-03-07 23:09:00','2023-03-07 23:09:00',NULL),(2846,7851,1096,40719,20,21,140,1,1.23,NULL,'2023-03-07 23:09:00','2023-03-07 23:09:00',NULL),(2847,7851,1097,40719,20,19,495,1,200000.00,NULL,'2023-03-08 15:21:07','2023-03-08 15:22:34','2023-03-08 15:22:34'),(2848,7851,1097,40719,20,19,482,2,200000.00,NULL,'2023-03-08 15:21:07','2023-03-08 15:22:34','2023-03-08 15:22:34'),(2849,7851,1098,40719,20,19,541,1,200000.00,NULL,'2023-03-08 15:22:10','2023-03-08 15:22:10',NULL);
INSERT INTO `balance_libro_details` VALUES (2850,7851,1098,40719,20,19,482,2,200000.00,NULL,'2023-03-08 15:22:10','2023-03-08 15:22:10',NULL),(2851,7851,1099,40719,20,19,495,1,300000.00,NULL,'2023-03-08 15:22:34','2023-03-08 15:22:34',NULL),(2852,7851,1099,40719,20,19,482,2,300000.00,NULL,'2023-03-08 15:22:34','2023-03-08 15:22:34',NULL),(2853,7851,1100,40719,20,19,483,1,200000.00,NULL,'2023-03-08 15:23:10','2023-03-08 15:23:10',NULL),(2854,7851,1100,40719,20,19,482,2,200000.00,NULL,'2023-03-08 15:23:10','2023-03-08 15:23:10',NULL),(2855,7851,1101,40719,20,21,495,1,70802.19,NULL,'2023-03-08 15:24:48','2023-03-08 15:24:48',NULL),(2856,7851,1101,40719,20,21,482,2,70802.19,NULL,'2023-03-08 15:24:48','2023-03-08 15:24:48',NULL),(2857,7851,1102,40719,20,19,551,1,140000.00,NULL,'2023-03-08 15:26:45','2023-03-08 15:26:45',NULL),(2858,7851,1102,40719,20,19,482,2,140000.00,NULL,'2023-03-08 15:26:45','2023-03-08 15:26:45',NULL),(2859,7851,1103,40719,20,19,163,1,200000.00,NULL,'2023-03-09 13:11:46','2023-03-09 13:11:46',NULL),(2860,7851,1103,40719,20,19,482,2,200000.00,NULL,'2023-03-09 13:11:46','2023-03-09 13:11:46',NULL),(2861,7851,1104,40719,20,21,498,1,8325.00,NULL,'2023-03-09 13:12:40','2023-03-09 13:12:40',NULL),(2862,7851,1104,40719,20,21,482,2,8325.00,NULL,'2023-03-09 13:12:40','2023-03-09 13:12:40',NULL),(2863,7851,1105,40719,20,21,495,1,42364.00,NULL,'2023-03-09 13:13:48','2023-03-09 13:13:48',NULL),(2864,7851,1105,40719,20,21,482,2,42364.00,NULL,'2023-03-09 13:13:48','2023-03-09 13:13:48',NULL),(2865,7851,1106,40719,20,21,498,1,1405.29,NULL,'2023-03-09 13:14:48','2023-03-09 13:16:00','2023-03-09 13:16:00'),(2866,7851,1106,40719,20,21,482,2,1405.29,NULL,'2023-03-09 13:14:48','2023-03-09 13:16:00','2023-03-09 13:16:00'),(2867,7851,1107,40719,20,21,482,2,1405.29,NULL,'2023-03-09 13:15:39','2023-03-09 13:15:53','2023-03-09 13:15:53'),(2868,7851,1107,40719,20,21,498,1,1405.29,NULL,'2023-03-09 13:15:39','2023-03-09 13:15:53','2023-03-09 13:15:53'),(2869,7851,1108,40719,20,21,482,2,1405.29,NULL,'2023-03-09 13:15:53','2023-03-09 13:15:53',NULL),(2870,7851,1108,40719,20,21,498,1,1405.29,NULL,'2023-03-09 13:15:53','2023-03-09 13:15:53',NULL),(2871,7851,1109,40719,20,21,498,1,1405.29,NULL,'2023-03-09 13:16:00','2023-03-09 13:16:00',NULL),(2872,7851,1109,40719,20,21,482,2,1405.29,NULL,'2023-03-09 13:16:00','2023-03-09 13:16:00',NULL),(2873,7851,1110,40719,20,21,498,1,1155.78,NULL,'2023-03-09 13:16:50','2023-03-09 13:17:54','2023-03-09 13:17:54'),(2874,7851,1110,40719,20,21,482,2,1155.78,NULL,'2023-03-09 13:16:50','2023-03-09 13:17:54','2023-03-09 13:17:54'),(2875,7851,1111,40719,20,21,482,2,1155.78,NULL,'2023-03-09 13:17:33','2023-03-09 13:18:06','2023-03-09 13:18:06'),(2876,7851,1111,40719,20,21,498,1,1155.78,NULL,'2023-03-09 13:17:33','2023-03-09 13:18:06','2023-03-09 13:18:06'),(2877,7851,1112,40719,20,21,498,1,1155.78,NULL,'2023-03-09 13:17:54','2023-03-09 13:17:54',NULL),(2878,7851,1112,40719,20,21,482,2,1155.78,NULL,'2023-03-09 13:17:54','2023-03-09 13:17:54',NULL),(2879,7851,1113,40719,20,21,482,2,1155.78,NULL,'2023-03-09 13:18:06','2023-03-09 13:18:06',NULL),(2880,7851,1113,40719,20,21,498,1,1155.78,NULL,'2023-03-09 13:18:06','2023-03-09 13:18:06',NULL),(2881,7851,1114,40719,20,19,482,2,200000.00,NULL,'2023-03-09 13:19:05','2023-03-09 13:22:26','2023-03-09 13:22:26'),(2882,7851,1114,40719,20,19,163,1,200000.00,NULL,'2023-03-09 13:19:05','2023-03-09 13:22:26','2023-03-09 13:22:26'),(2883,7851,1115,40719,20,19,482,2,100000.00,NULL,'2023-03-09 13:22:26','2023-03-09 13:22:26',NULL),(2884,7851,1115,40719,20,19,163,1,100000.00,NULL,'2023-03-09 13:22:26','2023-03-09 13:22:26',NULL),(2885,7851,1116,40719,20,19,482,2,50000.00,NULL,'2023-03-09 13:22:59','2023-03-09 13:22:59',NULL),(2886,7851,1116,40719,20,19,483,1,50000.00,NULL,'2023-03-09 13:22:59','2023-03-09 13:22:59',NULL),(2887,7851,1117,40719,20,19,482,2,50000.00,NULL,'2023-03-09 13:23:29','2023-03-09 13:23:29',NULL),(2888,7851,1117,40719,20,19,483,1,50000.00,NULL,'2023-03-09 13:23:29','2023-03-09 13:23:29',NULL);
INSERT INTO `balance_libro_details` VALUES (2889,7851,1118,40719,19,3,520,1,19598.80,NULL,'2023-03-10 10:38:19','2023-03-10 10:38:19',NULL),(2890,7851,1118,40719,19,3,68,1,4115.75,NULL,'2023-03-10 10:38:19','2023-03-10 10:38:19',NULL),(2891,7851,1118,40719,19,3,221,1,2286.45,NULL,'2023-03-10 10:38:19','2023-03-10 10:38:19',NULL),(2892,7851,1118,40719,19,3,57,2,26001.00,NULL,'2023-03-10 10:38:19','2023-03-10 10:38:19',NULL),(2893,7851,1119,40719,19,3,507,1,1882.74,NULL,'2023-03-10 10:39:26','2023-03-10 10:39:26',NULL),(2894,7851,1119,40719,19,3,68,1,395.38,NULL,'2023-03-10 10:39:26','2023-03-10 10:39:26',NULL),(2895,7851,1119,40719,19,3,221,1,221.96,NULL,'2023-03-10 10:39:26','2023-03-10 10:39:26',NULL),(2896,7851,1119,40719,19,3,57,2,2500.08,NULL,'2023-03-10 10:39:26','2023-03-10 10:39:26',NULL),(2897,7851,1120,40719,19,3,507,1,2259.23,NULL,'2023-03-10 10:39:53','2023-03-10 10:39:53',NULL),(2898,7851,1120,40719,19,3,68,1,474.44,NULL,'2023-03-10 10:39:53','2023-03-10 10:39:53',NULL),(2899,7851,1120,40719,19,3,221,1,266.34,NULL,'2023-03-10 10:39:53','2023-03-10 10:39:53',NULL),(2900,7851,1120,40719,19,3,57,2,3000.01,NULL,'2023-03-10 10:39:53','2023-03-10 10:39:53',NULL),(2901,7851,1121,40719,19,3,507,1,1541.41,NULL,'2023-03-10 10:40:23','2023-03-10 11:59:59','2023-03-10 11:59:59'),(2902,7851,1121,40719,19,3,68,1,323.70,NULL,'2023-03-10 10:40:23','2023-03-10 11:59:59','2023-03-10 11:59:59'),(2903,7851,1121,40719,19,3,221,1,134.83,NULL,'2023-03-10 10:40:23','2023-03-10 11:59:59','2023-03-10 11:59:59'),(2904,7851,1121,40719,19,3,57,2,1999.94,NULL,'2023-03-10 10:40:23','2023-03-10 11:59:59','2023-03-10 11:59:59'),(2905,7851,1122,40719,19,3,507,1,770.79,NULL,'2023-03-10 10:40:56','2023-03-10 10:40:56',NULL),(2906,7851,1122,40719,19,3,68,1,161.87,NULL,'2023-03-10 10:40:56','2023-03-10 10:40:56',NULL),(2907,7851,1122,40719,19,3,221,1,67.42,NULL,'2023-03-10 10:40:56','2023-03-10 10:40:56',NULL),(2908,7851,1122,40719,19,3,57,2,1000.08,NULL,'2023-03-10 10:40:56','2023-03-10 10:40:56',NULL),(2909,7851,1123,40719,20,3,217,1,8264.46,NULL,'2023-03-10 10:46:31','2023-04-01 19:24:49','2023-04-01 19:24:49'),(2910,7851,1123,40719,20,3,68,1,1735.54,NULL,'2023-03-10 10:46:31','2023-04-01 19:24:49','2023-04-01 19:24:49'),(2911,7851,1123,40719,20,3,57,2,10000.00,NULL,'2023-03-10 10:46:31','2023-04-01 19:24:49','2023-04-01 19:24:49'),(2912,7851,1124,40719,20,3,217,1,12479.34,NULL,'2023-03-10 10:46:31','2023-04-01 19:25:08','2023-04-01 19:25:08'),(2913,7851,1124,40719,20,3,68,1,2620.66,NULL,'2023-03-10 10:46:31','2023-04-01 19:25:08','2023-04-01 19:25:08'),(2914,7851,1124,40719,20,3,57,2,15100.00,NULL,'2023-03-10 10:46:31','2023-04-01 19:25:08','2023-04-01 19:25:08'),(2915,7851,1125,40719,20,3,507,1,7950.21,NULL,'2023-03-10 10:52:55','2023-03-10 10:52:55',NULL),(2916,7851,1125,40719,20,3,68,1,1669.54,NULL,'2023-03-10 10:52:55','2023-03-10 10:52:55',NULL),(2917,7851,1125,40719,20,3,221,1,580.54,NULL,'2023-03-10 10:52:55','2023-03-10 10:52:55',NULL),(2918,7851,1125,40719,20,3,57,2,10200.29,NULL,'2023-03-10 10:52:55','2023-03-10 10:52:55',NULL),(2919,7851,1126,40719,20,3,507,1,3854.09,NULL,'2023-03-10 10:54:17','2023-03-10 12:48:21','2023-03-10 12:48:21'),(2920,7851,1126,40719,20,3,68,1,809.36,NULL,'2023-03-10 10:54:17','2023-03-10 12:48:21','2023-03-10 12:48:21'),(2921,7851,1126,40719,20,3,221,1,337.14,NULL,'2023-03-10 10:54:17','2023-03-10 12:48:21','2023-03-10 12:48:21'),(2922,7851,1126,40719,20,3,57,2,5000.59,NULL,'2023-03-10 10:54:17','2023-03-10 12:48:21','2023-03-10 12:48:21'),(2923,7851,1127,40719,20,3,507,1,3330.00,NULL,'2023-03-10 10:56:29','2023-03-10 10:56:29',NULL),(2924,7851,1127,40719,20,3,68,1,699.30,NULL,'2023-03-10 10:56:29','2023-03-10 10:56:29',NULL),(2925,7851,1127,40719,20,3,221,1,4471.67,NULL,'2023-03-10 10:56:29','2023-03-10 10:56:29',NULL),(2926,7851,1127,40719,20,3,57,2,8500.97,NULL,'2023-03-10 10:56:29','2023-03-10 10:56:29',NULL),(2927,7851,1128,40719,20,3,507,1,1506.19,NULL,'2023-03-10 10:57:07','2023-03-10 10:57:07',NULL);
INSERT INTO `balance_libro_details` VALUES (2928,7851,1128,40719,20,3,68,1,316.30,NULL,'2023-03-10 10:57:07','2023-03-10 10:57:07',NULL),(2929,7851,1128,40719,20,3,221,1,177.57,NULL,'2023-03-10 10:57:07','2023-03-10 10:57:07',NULL),(2930,7851,1128,40719,20,3,57,2,2000.06,NULL,'2023-03-10 10:57:07','2023-03-10 10:57:07',NULL),(2931,7851,1129,40719,20,3,507,1,2259.23,NULL,'2023-03-10 10:58:31','2023-03-10 10:58:31',NULL),(2932,7851,1129,40719,20,3,68,1,474.44,NULL,'2023-03-10 10:58:31','2023-03-10 10:58:31',NULL),(2933,7851,1129,40719,20,3,221,1,266.34,NULL,'2023-03-10 10:58:31','2023-03-10 10:58:31',NULL),(2934,7851,1129,40719,20,3,57,2,3000.01,NULL,'2023-03-10 10:58:31','2023-03-10 10:58:31',NULL),(2935,7851,1130,40719,20,3,520,1,12294.00,NULL,'2023-03-10 10:59:26','2023-03-10 10:59:26',NULL),(2936,7851,1130,40719,20,3,68,1,2581.74,NULL,'2023-03-10 10:59:26','2023-03-10 10:59:26',NULL),(2937,7851,1130,40719,20,3,221,1,1434.25,NULL,'2023-03-10 10:59:26','2023-03-10 10:59:26',NULL),(2938,7851,1130,40719,20,3,57,2,16309.99,NULL,'2023-03-10 10:59:26','2023-03-10 10:59:26',NULL),(2939,7851,1131,40719,19,21,57,1,26001.00,NULL,'2023-03-10 11:03:53','2023-03-10 11:03:53',NULL),(2940,7851,1131,40719,19,21,484,2,26001.00,NULL,'2023-03-10 11:03:53','2023-03-10 11:03:53',NULL),(2941,7851,1132,40719,20,21,57,1,2085.80,NULL,'2023-03-10 11:05:20','2023-04-01 19:22:02','2023-04-01 19:22:02'),(2942,7851,1132,40719,20,21,163,2,2085.80,NULL,'2023-03-10 11:05:20','2023-04-01 19:22:02','2023-04-01 19:22:02'),(2943,7851,1133,40719,20,21,57,1,16309.99,NULL,'2023-03-10 11:20:19','2023-03-10 11:20:19',NULL),(2944,7851,1133,40719,20,21,484,2,16309.99,NULL,'2023-03-10 11:20:19','2023-03-10 11:20:19',NULL),(2945,7851,1134,40719,19,21,57,1,5500.09,NULL,'2023-03-10 11:54:29','2023-03-10 11:54:29',NULL),(2946,7851,1134,40719,19,21,488,2,5500.09,NULL,'2023-03-10 11:54:29','2023-03-10 11:54:29',NULL),(2947,7851,1135,40719,19,3,507,1,1541.41,NULL,'2023-03-10 11:59:59','2023-03-10 11:59:59',NULL),(2948,7851,1135,40719,19,3,68,1,323.70,NULL,'2023-03-10 11:59:59','2023-03-10 11:59:59',NULL),(2949,7851,1135,40719,19,3,221,1,134.83,NULL,'2023-03-10 11:59:59','2023-03-10 11:59:59',NULL),(2950,7851,1135,40719,19,3,57,2,1999.94,NULL,'2023-03-10 11:59:59','2023-03-10 11:59:59',NULL),(2951,7851,1136,40719,19,21,57,1,3000.02,NULL,'2023-03-10 12:02:32','2023-03-10 12:02:32',NULL),(2952,7851,1136,40719,19,21,488,2,3000.02,NULL,'2023-03-10 12:02:32','2023-03-10 12:02:32',NULL),(2953,7851,1137,40719,19,21,57,1,4500.00,NULL,'2023-03-10 12:05:08','2023-03-10 13:13:35','2023-03-10 13:13:35'),(2954,7851,1137,40719,19,21,494,2,4500.00,NULL,'2023-03-10 12:05:08','2023-03-10 13:13:35','2023-03-10 13:13:35'),(2955,7851,1138,40719,19,21,57,1,7500.00,NULL,'2023-03-10 12:08:52','2023-03-10 12:08:52',NULL),(2956,7851,1138,40719,19,21,483,2,7500.00,NULL,'2023-03-10 12:08:52','2023-03-10 12:08:52',NULL),(2957,7851,1139,40719,20,3,507,1,3854.09,NULL,'2023-03-10 12:48:21','2023-03-10 12:48:21',NULL),(2958,7851,1139,40719,20,3,68,1,809.36,NULL,'2023-03-10 12:48:21','2023-03-10 12:48:21',NULL),(2959,7851,1139,40719,20,3,221,1,337.14,NULL,'2023-03-10 12:48:21','2023-03-10 12:48:21',NULL),(2960,7851,1139,40719,20,3,57,2,5000.59,NULL,'2023-03-10 12:48:21','2023-03-10 12:48:21',NULL),(2961,7851,1140,40719,20,21,57,1,15100.00,NULL,'2023-03-10 12:51:45','2023-04-01 19:21:11','2023-04-01 19:21:11'),(2962,7851,1140,40719,20,21,163,2,15100.00,NULL,'2023-03-10 12:51:45','2023-04-01 19:21:11','2023-04-01 19:21:11'),(2963,7851,1141,40719,20,21,57,1,13501.04,NULL,'2023-03-10 12:54:40','2023-03-10 12:54:40',NULL),(2964,7851,1141,40719,20,21,488,2,13501.04,NULL,'2023-03-10 12:54:40','2023-03-10 12:54:40',NULL),(2965,7851,1142,40719,20,21,57,1,5000.59,NULL,'2023-03-10 13:02:41','2023-03-10 13:02:41',NULL),(2966,7851,1142,40719,20,21,163,2,5000.59,NULL,'2023-03-10 13:02:41','2023-03-10 13:02:41',NULL),(2967,7851,1143,40719,20,21,57,1,10504.60,NULL,'2023-03-10 13:05:06','2023-04-01 19:21:37','2023-04-01 19:21:37');
INSERT INTO `balance_libro_details` VALUES (2968,7851,1143,40719,20,21,488,2,10504.60,NULL,'2023-03-10 13:05:06','2023-04-01 19:21:37','2023-04-01 19:21:37'),(2969,7851,1144,40719,20,21,57,1,10700.40,NULL,'2023-03-10 13:07:54','2023-04-01 19:21:49','2023-04-01 19:21:49'),(2970,7851,1144,40719,20,21,488,2,10700.40,NULL,'2023-03-10 13:07:54','2023-04-01 19:21:49','2023-04-01 19:21:49'),(2971,7851,1145,40719,20,21,57,1,10200.29,NULL,'2023-03-10 13:08:51','2023-03-10 13:08:51',NULL),(2972,7851,1145,40719,20,21,488,2,10200.29,NULL,'2023-03-10 13:08:51','2023-03-10 13:08:51',NULL),(2973,7851,1146,40719,19,21,57,1,4500.00,NULL,'2023-03-10 13:14:03','2023-03-10 13:14:03',NULL),(2974,7851,1146,40719,19,21,493,2,4500.00,NULL,'2023-03-10 13:14:03','2023-03-10 13:14:03',NULL),(2975,7851,1147,40719,19,3,120,1,10609.80,NULL,'2023-03-12 18:35:42','2023-03-12 18:35:42',NULL),(2976,7851,1147,40719,19,3,68,1,2864.65,NULL,'2023-03-12 18:35:42','2023-03-12 18:35:42',NULL),(2977,7851,1147,40719,19,3,120,1,586.00,NULL,'2023-03-12 18:35:42','2023-03-12 18:35:42',NULL),(2978,7851,1147,40719,19,3,68,1,123.06,NULL,'2023-03-12 18:35:42','2023-03-12 18:35:42',NULL),(2979,7851,1147,40719,19,3,221,1,558.40,NULL,'2023-03-12 18:35:42','2023-03-12 18:35:42',NULL),(2980,7851,1147,40719,19,3,237,1,335.87,NULL,'2023-03-12 18:35:42','2023-03-12 18:35:42',NULL),(2981,7851,1147,40719,19,3,57,2,15077.78,NULL,'2023-03-12 18:35:42','2023-03-12 18:35:42',NULL),(2982,7851,1148,40719,19,21,57,1,15077.78,NULL,'2023-03-12 18:36:44','2023-03-12 18:36:44',NULL),(2983,7851,1148,40719,19,21,163,2,15077.78,NULL,'2023-03-12 18:36:44','2023-03-12 18:36:44',NULL),(2984,7851,1149,40719,19,21,57,1,1785.57,NULL,'2023-03-12 18:37:14','2023-03-12 18:37:14',NULL),(2985,7851,1149,40719,19,21,163,2,1785.57,NULL,'2023-03-12 18:37:14','2023-03-12 18:37:14',NULL),(2986,7851,1150,40719,20,3,217,1,5471.29,NULL,'2023-03-12 18:50:30','2023-04-01 19:22:25','2023-04-01 19:22:25'),(2987,7851,1150,40719,20,3,68,1,1148.97,NULL,'2023-03-12 18:50:30','2023-04-01 19:22:25','2023-04-01 19:22:25'),(2988,7851,1150,40719,20,3,217,1,979.74,NULL,'2023-03-12 18:50:30','2023-04-01 19:22:25','2023-04-01 19:22:25'),(2989,7851,1150,40719,20,3,57,2,7600.00,NULL,'2023-03-12 18:50:30','2023-04-01 19:22:25','2023-04-01 19:22:25'),(2990,7851,1151,40719,20,3,217,1,28924.00,NULL,'2023-03-12 18:50:30','2023-04-01 19:20:21','2023-04-01 19:20:21'),(2991,7851,1151,40719,20,3,68,1,6074.04,NULL,'2023-03-12 18:50:30','2023-04-01 19:20:21','2023-04-01 19:20:21'),(2992,7851,1151,40719,20,3,57,2,34998.04,NULL,'2023-03-12 18:50:30','2023-04-01 19:20:21','2023-04-01 19:20:21'),(2993,7851,1152,40719,20,3,507,1,5048.14,NULL,'2023-03-12 18:57:34','2023-03-12 18:57:34',NULL),(2994,7851,1152,40719,20,3,68,1,1060.11,NULL,'2023-03-12 18:57:34','2023-03-12 18:57:34',NULL),(2995,7851,1152,40719,20,3,478,1,50.98,NULL,'2023-03-12 18:57:34','2023-03-12 18:57:34',NULL),(2996,7851,1152,40719,20,3,221,1,242.08,NULL,'2023-03-12 18:57:34','2023-03-12 18:57:34',NULL),(2997,7851,1152,40719,20,3,57,2,6401.31,NULL,'2023-03-12 18:57:34','2023-03-12 18:57:34',NULL),(2998,7851,1153,40719,20,3,507,1,2940.40,NULL,'2023-03-12 19:00:43','2023-03-12 19:00:43',NULL),(2999,7851,1153,40719,20,3,68,1,617.48,NULL,'2023-03-12 19:00:43','2023-03-12 19:00:43',NULL),(3000,7851,1153,40719,20,3,221,1,343.10,NULL,'2023-03-12 19:00:43','2023-03-12 19:00:43',NULL),(3001,7851,1153,40719,20,3,57,2,3900.98,NULL,'2023-03-12 19:00:43','2023-03-12 19:00:43',NULL),(3002,7851,1154,40719,20,3,507,1,2966.37,NULL,'2023-03-12 19:06:42','2023-03-12 19:06:42',NULL),(3003,7851,1154,40719,20,3,68,1,622.94,NULL,'2023-03-12 19:06:42','2023-03-12 19:06:42',NULL),(3004,7851,1154,40719,20,3,507,1,0.01,NULL,'2023-03-12 19:06:42','2023-03-12 19:06:42',NULL),(3005,7851,1154,40719,20,3,221,1,35.68,NULL,'2023-03-12 19:06:42','2023-03-12 19:06:42',NULL),(3006,7851,1154,40719,20,3,57,2,3625.00,NULL,'2023-03-12 19:06:42','2023-03-12 19:06:42',NULL),(3007,7851,1155,40719,20,21,212,1,3566.72,NULL,'2023-03-14 10:11:48','2023-03-14 10:11:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3008,7851,1155,40719,20,21,482,2,3566.72,NULL,'2023-03-14 10:11:48','2023-03-14 10:11:48',NULL),(3009,7851,1156,40719,20,21,489,1,4820.00,NULL,'2023-03-14 10:12:44','2023-03-14 10:12:44',NULL),(3010,7851,1156,40719,20,21,482,2,4820.00,NULL,'2023-03-14 10:12:44','2023-03-14 10:12:44',NULL),(3011,7851,1157,40719,20,19,482,1,100000.00,NULL,'2023-03-14 10:14:21','2023-03-14 10:14:21',NULL),(3012,7851,1157,40719,20,19,163,2,100000.00,NULL,'2023-03-14 10:14:21','2023-03-14 10:14:21',NULL),(3013,7851,1158,40719,20,19,497,1,40000.00,NULL,'2023-03-14 10:23:51','2023-03-14 10:23:51',NULL),(3014,7851,1158,40719,20,19,482,2,40000.00,NULL,'2023-03-14 10:23:51','2023-03-14 10:23:51',NULL),(3015,7851,1159,40719,20,19,497,1,40000.00,NULL,'2023-03-14 10:26:50','2023-03-14 10:31:00','2023-03-14 10:31:00'),(3016,7851,1159,40719,20,19,482,2,40000.00,NULL,'2023-03-14 10:26:50','2023-03-14 10:31:00','2023-03-14 10:31:00'),(3017,7851,1160,40719,20,19,497,1,40000.00,NULL,'2023-03-14 10:27:37','2023-03-14 10:31:08','2023-03-14 10:31:08'),(3018,7851,1160,40719,20,19,482,2,40000.00,NULL,'2023-03-14 10:27:37','2023-03-14 10:31:08','2023-03-14 10:31:08'),(3019,7851,1161,40719,20,19,497,1,40000.00,NULL,'2023-03-14 10:31:00','2023-03-14 10:31:00',NULL),(3020,7851,1161,40719,20,19,482,2,40000.00,NULL,'2023-03-14 10:31:00','2023-03-14 10:31:00',NULL),(3021,7851,1162,40719,20,19,497,1,40000.00,NULL,'2023-03-14 10:31:08','2023-03-14 10:31:08',NULL),(3022,7851,1162,40719,20,19,482,2,40000.00,NULL,'2023-03-14 10:31:08','2023-03-14 10:31:08',NULL),(3023,7851,1163,40719,20,21,214,1,35140.01,NULL,'2023-03-14 10:33:03','2023-03-14 10:33:03',NULL),(3024,7851,1163,40719,20,21,482,2,35140.01,NULL,'2023-03-14 10:33:03','2023-03-14 10:33:03',NULL),(3025,7851,1164,40719,20,21,140,1,52.40,NULL,'2023-03-14 10:38:51','2023-03-14 10:38:51',NULL),(3026,7851,1164,40719,20,21,165,2,52.40,NULL,'2023-03-14 10:38:51','2023-03-14 10:38:51',NULL),(3027,7851,1165,40719,20,21,157,1,0.39,NULL,'2023-03-14 10:40:24','2023-03-14 10:40:24',NULL),(3028,7851,1165,40719,20,21,165,2,0.39,NULL,'2023-03-14 10:40:24','2023-03-14 10:40:24',NULL),(3029,7851,1166,40719,20,19,163,2,65.02,NULL,'2023-03-14 10:41:10','2023-03-14 10:41:10',NULL),(3030,7851,1166,40719,20,19,165,1,65.02,NULL,'2023-03-14 10:41:10','2023-03-14 10:41:10',NULL),(3031,7851,1167,40719,20,21,512,1,12989.50,NULL,'2023-03-14 10:43:44','2023-03-14 10:49:29','2023-03-14 10:49:29'),(3032,7851,1167,40719,20,21,163,2,12989.50,NULL,'2023-03-14 10:43:44','2023-03-14 10:49:29','2023-03-14 10:49:29'),(3033,7851,1168,40719,20,3,204,1,12045.95,NULL,'2023-03-14 10:46:45','2023-03-14 10:46:45',NULL),(3034,7851,1168,40719,20,3,76,2,12045.95,NULL,'2023-03-14 10:46:45','2023-03-14 10:46:45',NULL),(3035,7851,1169,40719,20,10,76,1,10989.09,NULL,'2023-03-14 10:47:23','2023-03-14 10:47:23',NULL),(3036,7851,1169,40719,20,10,163,2,10989.09,NULL,'2023-03-14 10:47:23','2023-03-14 10:47:23',NULL),(3037,7851,1170,40719,20,10,76,1,1056.86,NULL,'2023-03-14 10:48:05','2023-03-14 10:48:05',NULL),(3038,7851,1170,40719,20,10,163,2,1056.86,NULL,'2023-03-14 10:48:05','2023-03-14 10:48:05',NULL),(3039,7851,1171,40719,20,21,492,1,21802.20,NULL,'2023-03-14 10:48:49','2023-03-14 10:49:18','2023-03-14 10:49:18'),(3040,7851,1171,40719,20,21,163,2,21802.20,NULL,'2023-03-14 10:48:49','2023-03-14 10:49:18','2023-03-14 10:49:18'),(3041,7851,1172,40719,20,21,492,1,21802.20,NULL,'2023-03-14 10:49:18','2023-03-14 10:49:18',NULL),(3042,7851,1172,40719,20,21,163,2,21802.20,NULL,'2023-03-14 10:49:18','2023-03-14 10:49:18',NULL),(3043,7851,1173,40719,20,21,512,1,12989.50,NULL,'2023-03-14 10:49:29','2023-03-14 10:49:29',NULL),(3044,7851,1173,40719,20,21,163,2,12989.50,NULL,'2023-03-14 10:49:29','2023-03-14 10:49:29',NULL),(3045,7851,1174,40719,20,3,63,2,18125.95,NULL,'2023-03-14 10:50:18','2023-03-14 10:50:18',NULL),(3046,7851,1174,40719,20,3,191,1,18125.95,NULL,'2023-03-14 10:50:18','2023-03-14 10:50:18',NULL);
INSERT INTO `balance_libro_details` VALUES (3047,7851,1175,40719,20,21,163,2,18125.95,NULL,'2023-03-14 10:50:40','2023-03-14 10:50:40',NULL),(3048,7851,1175,40719,20,21,63,1,18125.95,NULL,'2023-03-14 10:50:40','2023-03-14 10:50:40',NULL),(3049,7851,1176,40719,20,21,163,2,35164.09,NULL,'2023-03-14 10:53:33','2023-03-14 10:53:33',NULL),(3050,7851,1176,40719,20,21,493,1,35164.09,NULL,'2023-03-14 10:53:33','2023-03-14 10:53:33',NULL),(3051,7851,1177,40719,20,21,163,2,91638.09,NULL,'2023-03-14 10:53:58','2023-03-14 10:53:58',NULL),(3052,7851,1177,40719,20,21,494,1,91638.09,NULL,'2023-03-14 10:53:58','2023-03-14 10:53:58',NULL),(3053,7851,1178,40719,20,10,74,1,57635.38,NULL,'2023-03-14 10:56:53','2023-03-14 10:56:53',NULL),(3054,7851,1178,40719,20,10,163,2,57635.38,NULL,'2023-03-14 10:56:53','2023-03-14 10:56:53',NULL),(3055,7851,1179,40719,20,19,483,2,50000.00,NULL,'2023-03-14 11:08:03','2023-03-14 11:08:03',NULL),(3056,7851,1179,40719,20,19,484,1,50000.00,NULL,'2023-03-14 11:08:03','2023-03-14 11:08:03',NULL),(3057,7851,1180,40719,20,21,57,1,3900.98,NULL,'2023-03-14 11:34:31','2023-03-14 11:34:31',NULL),(3058,7851,1180,40719,20,21,483,2,3900.98,NULL,'2023-03-14 11:34:31','2023-03-14 11:34:31',NULL),(3059,7851,1181,40719,20,21,57,1,7600.00,NULL,'2023-03-14 11:35:04','2023-04-01 19:21:01','2023-04-01 19:21:01'),(3060,7851,1181,40719,20,21,483,2,7600.00,NULL,'2023-03-14 11:35:04','2023-04-01 19:21:01','2023-04-01 19:21:01'),(3061,7851,1182,40719,20,21,57,1,6401.31,NULL,'2023-03-14 11:35:34','2023-03-14 11:35:34',NULL),(3062,7851,1182,40719,20,21,483,2,6401.31,NULL,'2023-03-14 11:35:34','2023-03-14 11:35:34',NULL),(3063,7851,1183,40719,20,21,512,1,3060.00,NULL,'2023-03-14 11:46:58','2023-03-14 11:46:58',NULL),(3064,7851,1183,40719,20,21,483,2,3060.00,NULL,'2023-03-14 11:46:58','2023-03-14 11:46:58',NULL),(3065,7851,1184,40719,20,19,163,2,260798.60,NULL,'2023-03-14 11:54:16','2023-03-14 11:54:16',NULL),(3066,7851,1184,40719,20,19,547,1,260798.60,NULL,'2023-03-14 11:54:16','2023-03-14 11:54:16',NULL),(3067,7851,1185,40719,20,19,547,1,64904.54,NULL,'2023-03-14 11:59:34','2023-03-14 11:59:34',NULL),(3068,7851,1185,40719,20,19,163,2,64904.54,NULL,'2023-03-14 11:59:34','2023-03-14 11:59:34',NULL),(3069,7851,1186,40719,20,19,163,1,64904.54,NULL,'2023-03-14 12:00:27','2023-03-14 12:00:27',NULL),(3070,7851,1186,40719,20,19,542,2,60000.00,NULL,'2023-03-14 12:00:27','2023-03-14 12:00:27',NULL),(3071,7851,1186,40719,20,19,546,2,4904.54,NULL,'2023-03-14 12:00:27','2023-03-14 12:00:27',NULL),(3072,7851,1187,40719,19,15,68,2,26723.55,NULL,'2023-03-22 10:48:59','2023-03-22 10:48:59',NULL),(3073,7851,1187,40719,19,15,353,1,28541.55,NULL,'2023-03-22 10:48:59','2023-03-22 10:48:59',NULL),(3074,7851,1187,40719,19,15,136,2,1818.00,NULL,'2023-03-22 10:48:59','2023-03-22 10:48:59',NULL),(3075,7851,1188,40719,20,3,507,1,2225.29,NULL,'2023-03-23 17:44:42','2023-03-23 17:44:42',NULL),(3076,7851,1188,40719,20,3,68,1,467.31,NULL,'2023-03-23 17:44:42','2023-03-23 17:44:42',NULL),(3077,7851,1188,40719,20,3,221,1,307.34,NULL,'2023-03-23 17:44:42','2023-03-23 17:44:42',NULL),(3078,7851,1188,40719,20,3,57,2,2999.94,NULL,'2023-03-23 17:44:42','2023-03-23 17:44:42',NULL),(3079,7851,1189,40719,20,3,520,1,19196.29,NULL,'2023-03-23 17:46:30','2023-03-23 17:46:30',NULL),(3080,7851,1189,40719,20,3,68,1,4031.22,NULL,'2023-03-23 17:46:30','2023-03-23 17:46:30',NULL),(3081,7851,1189,40719,20,3,221,1,1972.50,NULL,'2023-03-23 17:46:30','2023-03-23 17:46:30',NULL),(3082,7851,1189,40719,20,3,57,2,25200.01,NULL,'2023-03-23 17:46:30','2023-03-23 17:46:30',NULL),(3083,7851,1190,40719,20,3,520,1,13567.88,NULL,'2023-03-23 17:48:24','2023-03-23 17:48:24',NULL),(3084,7851,1190,40719,20,3,68,1,2849.25,NULL,'2023-03-23 17:48:24','2023-03-23 17:48:24',NULL),(3085,7851,1190,40719,20,3,221,1,1582.87,NULL,'2023-03-23 17:48:24','2023-03-23 17:48:24',NULL),(3086,7851,1190,40719,20,3,57,2,18000.00,NULL,'2023-03-23 17:48:24','2023-03-23 17:48:24',NULL);
INSERT INTO `balance_libro_details` VALUES (3087,7851,1191,40719,20,21,57,1,18000.00,NULL,'2023-03-23 17:51:13','2023-03-23 17:51:13',NULL),(3088,7851,1191,40719,20,21,484,2,18000.00,NULL,'2023-03-23 17:51:13','2023-03-23 17:51:13',NULL),(3089,7851,1192,40719,20,21,57,1,25200.01,NULL,'2023-03-23 17:52:07','2023-03-23 17:52:07',NULL),(3090,7851,1192,40719,20,21,484,2,25200.01,NULL,'2023-03-23 17:52:07','2023-03-23 17:52:07',NULL),(3091,7851,1193,40719,20,21,57,1,2999.94,NULL,'2023-03-23 17:53:22','2023-03-23 17:53:22',NULL),(3092,7851,1193,40719,20,21,488,2,2999.94,NULL,'2023-03-23 17:53:22','2023-03-23 17:53:22',NULL),(3093,7851,1194,40719,20,20,13,2,27500.01,NULL,'2023-03-23 17:56:22','2023-03-28 11:33:44','2023-03-28 11:33:44'),(3094,7851,1194,40719,20,20,488,1,27500.01,NULL,'2023-03-23 17:56:22','2023-03-28 11:33:44','2023-03-28 11:33:44'),(3095,7851,1195,40719,20,3,515,1,4643.03,NULL,'2023-03-23 23:51:16','2023-03-23 23:51:16',NULL),(3096,7851,1195,40719,20,3,68,1,975.04,NULL,'2023-03-23 23:51:16','2023-03-23 23:51:16',NULL),(3097,7851,1195,40719,20,3,221,1,482.15,NULL,'2023-03-23 23:51:16','2023-03-23 23:51:16',NULL),(3098,7851,1195,40719,20,3,57,2,6100.22,NULL,'2023-03-23 23:51:16','2023-03-23 23:51:16',NULL),(3099,7851,1196,40719,20,3,507,1,4915.91,NULL,'2023-03-23 23:52:34','2023-03-23 23:52:34',NULL),(3100,7851,1196,40719,20,3,68,1,1032.34,NULL,'2023-03-23 23:52:34','2023-03-23 23:52:34',NULL),(3101,7851,1196,40719,20,3,221,1,652.04,NULL,'2023-03-23 23:52:34','2023-03-23 23:52:34',NULL),(3102,7851,1196,40719,20,3,57,2,6600.29,NULL,'2023-03-23 23:52:34','2023-03-23 23:52:34',NULL),(3103,7851,1197,40719,20,3,522,1,24132.23,NULL,'2023-03-23 23:53:43','2023-03-23 23:53:43',NULL),(3104,7851,1197,40719,20,3,68,1,5067.77,NULL,'2023-03-23 23:53:43','2023-03-23 23:53:43',NULL),(3105,7851,1197,40719,20,3,57,2,29200.00,NULL,'2023-03-23 23:53:43','2023-03-23 23:53:43',NULL),(3106,7851,1198,40719,20,3,507,1,6192.37,NULL,'2023-03-23 23:55:41','2023-03-23 23:55:41',NULL),(3107,7851,1198,40719,20,3,68,1,1300.40,NULL,'2023-03-23 23:55:41','2023-03-23 23:55:41',NULL),(3108,7851,1198,40719,20,3,221,1,808.91,NULL,'2023-03-23 23:55:41','2023-03-23 23:55:41',NULL),(3109,7851,1198,40719,20,3,57,2,8301.68,NULL,'2023-03-23 23:55:41','2023-03-23 23:55:41',NULL),(3110,7851,1199,40719,20,3,507,1,5593.35,NULL,'2023-03-23 23:57:33','2023-03-23 23:57:33',NULL),(3111,7851,1199,40719,20,3,68,1,1174.60,NULL,'2023-03-23 23:57:33','2023-03-23 23:57:33',NULL),(3112,7851,1199,40719,20,3,221,1,732.00,NULL,'2023-03-23 23:57:33','2023-03-23 23:57:33',NULL),(3113,7851,1199,40719,20,3,57,2,7499.95,NULL,'2023-03-23 23:57:33','2023-03-23 23:57:33',NULL),(3114,7851,1200,40719,20,3,507,1,4056.00,NULL,'2023-03-23 23:59:13','2023-03-23 23:59:13',NULL),(3115,7851,1200,40719,20,3,68,1,851.76,NULL,'2023-03-23 23:59:13','2023-03-23 23:59:13',NULL),(3116,7851,1200,40719,20,3,221,1,592.40,NULL,'2023-03-23 23:59:13','2023-03-23 23:59:13',NULL),(3117,7851,1200,40719,20,3,57,2,5500.16,NULL,'2023-03-23 23:59:13','2023-03-23 23:59:13',NULL),(3118,7851,1201,40719,20,3,507,1,4780.39,NULL,'2023-03-24 00:00:50','2023-03-24 00:00:50',NULL),(3119,7851,1201,40719,20,3,68,1,1003.88,NULL,'2023-03-24 00:00:50','2023-03-24 00:00:50',NULL),(3120,7851,1201,40719,20,3,221,1,617.11,NULL,'2023-03-24 00:00:50','2023-03-24 00:00:50',NULL),(3121,7851,1201,40719,20,3,57,2,6401.38,NULL,'2023-03-24 00:00:50','2023-03-24 00:00:50',NULL),(3122,7851,1202,40719,20,21,57,1,6100.22,NULL,'2023-03-24 00:01:56','2023-03-24 00:02:07','2023-03-24 00:02:07'),(3123,7851,1202,40719,20,21,488,2,6100.22,NULL,'2023-03-24 00:01:56','2023-03-24 00:02:07','2023-03-24 00:02:07'),(3124,7851,1203,40719,20,21,57,1,6100.22,NULL,'2023-03-24 00:02:38','2023-03-24 00:02:38',NULL),(3125,7851,1203,40719,20,21,482,2,6100.22,NULL,'2023-03-24 00:02:38','2023-03-24 00:02:38',NULL),(3126,7851,1204,40719,20,21,57,1,29200.00,NULL,'2023-03-24 00:03:36','2023-03-24 00:03:36',NULL),(3127,7851,1204,40719,20,21,483,2,29200.00,NULL,'2023-03-24 00:03:36','2023-03-24 00:03:36',NULL);
INSERT INTO `balance_libro_details` VALUES (3128,7851,1205,40719,20,21,57,1,6401.38,NULL,'2023-03-24 00:14:42','2023-03-24 00:14:42',NULL),(3129,7851,1205,40719,20,21,488,2,6401.38,NULL,'2023-03-24 00:14:42','2023-03-24 00:14:42',NULL),(3130,7851,1206,40719,20,21,57,1,5500.16,NULL,'2023-03-24 00:15:36','2023-03-24 00:15:36',NULL),(3131,7851,1206,40719,20,21,488,2,5500.16,NULL,'2023-03-24 00:15:36','2023-03-24 00:15:36',NULL),(3132,7851,1207,40719,20,21,57,1,7499.95,NULL,'2023-03-24 00:16:22','2023-03-24 00:16:22',NULL),(3133,7851,1207,40719,20,21,488,2,7499.95,NULL,'2023-03-24 00:16:22','2023-03-24 00:16:22',NULL),(3134,7851,1208,40719,20,21,57,1,8301.68,NULL,'2023-03-24 00:17:10','2023-03-24 00:17:10',NULL),(3135,7851,1208,40719,20,21,488,2,8301.68,NULL,'2023-03-24 00:17:10','2023-03-24 00:17:10',NULL),(3136,7851,1209,40719,20,20,13,2,6600.29,NULL,'2023-03-24 00:18:16','2023-03-28 11:31:55','2023-03-28 11:31:55'),(3137,7851,1209,40719,20,20,488,1,6600.29,NULL,'2023-03-24 00:18:16','2023-03-28 11:31:55','2023-03-28 11:31:55'),(3138,7851,1210,40719,20,3,522,1,18264.46,NULL,'2023-03-25 15:17:24','2023-03-25 15:17:24',NULL),(3139,7851,1210,40719,20,3,68,1,3835.54,NULL,'2023-03-25 15:17:24','2023-03-25 15:17:24',NULL),(3140,7851,1210,40719,20,3,57,2,22100.00,NULL,'2023-03-25 15:17:24','2023-03-25 15:17:24',NULL),(3141,7851,1211,40719,20,21,57,1,22100.00,NULL,'2023-03-25 15:18:20','2023-03-25 15:18:20',NULL),(3142,7851,1211,40719,20,21,483,2,22100.00,NULL,'2023-03-25 15:18:20','2023-03-25 15:18:20',NULL),(3143,7851,1212,40719,20,3,507,1,7121.22,NULL,'2023-03-28 00:11:15','2023-03-28 00:11:15',NULL),(3144,7851,1212,40719,20,3,68,1,1495.46,NULL,'2023-03-28 00:11:15','2023-03-28 00:11:15',NULL),(3145,7851,1212,40719,20,3,221,1,983.52,NULL,'2023-03-28 00:11:15','2023-03-28 00:11:15',NULL),(3146,7851,1212,40719,20,3,57,2,9600.20,NULL,'2023-03-28 00:11:15','2023-03-28 00:11:15',NULL),(3147,7851,1213,40719,20,21,57,1,9600.20,NULL,'2023-03-28 00:17:11','2023-03-28 00:17:11',NULL),(3148,7851,1213,40719,20,21,552,2,9600.20,NULL,'2023-03-28 00:17:11','2023-03-28 00:17:11',NULL),(3149,7851,1214,40719,20,3,507,1,6057.84,NULL,'2023-03-28 11:31:07','2023-03-28 11:31:07',NULL),(3150,7851,1214,40719,20,3,68,1,1272.15,NULL,'2023-03-28 11:31:07','2023-03-28 11:31:07',NULL),(3151,7851,1214,40719,20,3,57,2,7329.99,NULL,'2023-03-28 11:31:07','2023-03-28 11:31:07',NULL),(3152,7851,1215,40719,20,21,57,1,6600.29,NULL,'2023-03-28 11:32:41','2023-03-28 11:32:41',NULL),(3153,7851,1215,40719,20,21,552,2,6600.29,NULL,'2023-03-28 11:32:41','2023-03-28 11:32:41',NULL),(3154,7851,1216,40719,20,21,57,1,7329.99,NULL,'2023-03-28 11:33:25','2023-03-28 11:33:25',NULL),(3155,7851,1216,40719,20,21,552,2,7329.99,NULL,'2023-03-28 11:33:25','2023-03-28 11:33:25',NULL),(3156,7851,1217,40719,10,21,57,1,27500.01,NULL,'2023-03-28 11:34:45','2023-03-28 11:34:45',NULL),(3157,7851,1217,40719,10,21,488,2,27500.01,NULL,'2023-03-28 11:34:45','2023-03-28 11:34:45',NULL),(3158,7851,1218,40719,20,3,507,1,2066.11,NULL,'2023-03-30 12:33:18','2023-03-30 12:33:18',NULL),(3159,7851,1218,40719,20,3,68,1,433.88,NULL,'2023-03-30 12:33:18','2023-03-30 12:33:18',NULL),(3160,7851,1218,40719,20,3,507,1,0.02,NULL,'2023-03-30 12:33:18','2023-03-30 12:33:18',NULL),(3161,7851,1218,40719,20,3,57,2,2500.01,NULL,'2023-03-30 12:33:18','2023-03-30 12:33:18',NULL),(3162,7851,1219,40719,20,3,520,1,15844.55,NULL,'2023-03-30 12:34:33','2023-03-30 12:34:33',NULL),(3163,7851,1219,40719,20,3,68,1,3327.36,NULL,'2023-03-30 12:34:33','2023-03-30 12:34:33',NULL),(3164,7851,1219,40719,20,3,221,1,1628.09,NULL,'2023-03-30 12:34:33','2023-03-30 12:34:33',NULL),(3165,7851,1219,40719,20,3,57,2,20800.00,NULL,'2023-03-30 12:34:33','2023-03-30 12:34:33',NULL),(3166,7851,1220,40719,20,21,57,1,20800.00,NULL,'2023-03-31 16:58:46','2023-04-01 00:43:25','2023-04-01 00:43:25'),(3167,7851,1220,40719,20,21,488,2,20800.00,NULL,'2023-03-31 16:58:46','2023-04-01 00:43:25','2023-04-01 00:43:25');
INSERT INTO `balance_libro_details` VALUES (3168,7851,1221,40719,20,21,57,1,2500.01,NULL,'2023-03-31 16:59:27','2023-03-31 16:59:27',NULL),(3169,7851,1221,40719,20,21,488,2,2500.01,NULL,'2023-03-31 16:59:27','2023-03-31 16:59:27',NULL),(3170,7851,1222,40719,20,3,507,1,4914.52,NULL,'2023-03-31 17:00:59','2023-03-31 17:00:59',NULL),(3171,7851,1222,40719,20,3,68,1,1032.05,NULL,'2023-03-31 17:00:59','2023-03-31 17:00:59',NULL),(3172,7851,1222,40719,20,3,221,1,358.75,NULL,'2023-03-31 17:00:59','2023-03-31 17:00:59',NULL),(3173,7851,1222,40719,20,3,57,2,6305.32,NULL,'2023-03-31 17:00:59','2023-03-31 17:00:59',NULL),(3174,7851,1223,40719,20,3,519,1,4958.68,NULL,'2023-03-31 17:02:16','2023-03-31 17:02:16',NULL),(3175,7851,1223,40719,20,3,68,1,1041.32,NULL,'2023-03-31 17:02:16','2023-03-31 17:02:16',NULL),(3176,7851,1223,40719,20,3,57,2,6000.00,NULL,'2023-03-31 17:02:16','2023-03-31 17:02:16',NULL),(3177,7851,1224,40719,20,21,57,1,6305.32,NULL,'2023-03-31 17:03:06','2023-03-31 17:03:06',NULL),(3178,7851,1224,40719,20,21,552,2,6305.32,NULL,'2023-03-31 17:03:06','2023-03-31 17:03:06',NULL),(3179,7851,1225,40719,20,21,57,1,10000.00,NULL,'2023-03-31 17:09:45','2023-04-01 19:21:21','2023-04-01 19:21:21'),(3180,7851,1225,40719,20,21,483,2,10000.00,NULL,'2023-03-31 17:09:45','2023-04-01 19:21:21','2023-04-01 19:21:21'),(3181,7851,1226,40719,20,21,57,1,6000.00,NULL,'2023-03-31 17:10:12','2023-03-31 17:10:12',NULL),(3182,7851,1226,40719,20,21,493,2,6000.00,NULL,'2023-03-31 17:10:12','2023-03-31 17:10:12',NULL),(3183,7851,1227,40719,20,21,498,1,1352.52,NULL,'2023-03-31 18:14:16','2023-03-31 18:14:16',NULL),(3184,7851,1227,40719,20,21,482,2,1352.52,NULL,'2023-03-31 18:14:16','2023-03-31 18:14:16',NULL),(3185,7851,1228,40719,20,1,500,2,111689.83,NULL,'2023-03-31 18:18:03','2023-03-31 18:18:03',NULL),(3186,7851,1228,40719,20,1,482,1,111689.83,NULL,'2023-03-31 18:18:03','2023-03-31 18:18:03',NULL),(3187,7851,1229,40719,19,1,500,2,93789.21,NULL,'2023-03-31 18:18:33','2023-03-31 18:18:33',NULL),(3188,7851,1229,40719,19,1,482,1,93789.21,NULL,'2023-03-31 18:18:33','2023-03-31 18:18:33',NULL),(3189,7851,1230,40719,18,1,500,2,104624.37,NULL,'2023-03-31 18:18:49','2023-03-31 18:18:49',NULL),(3190,7851,1230,40719,18,1,482,1,104624.37,NULL,'2023-03-31 18:18:49','2023-03-31 18:18:49',NULL),(3191,7851,1231,40719,13,1,482,1,90446.52,NULL,'2023-03-31 18:19:38','2023-03-31 18:19:38',NULL),(3192,7851,1231,40719,13,1,500,2,90446.52,NULL,'2023-03-31 18:19:38','2023-03-31 18:19:38',NULL),(3193,7851,1232,40719,12,1,482,1,90442.66,NULL,'2023-03-31 18:19:53','2023-03-31 18:19:53',NULL),(3194,7851,1232,40719,12,1,500,2,90442.66,NULL,'2023-03-31 18:19:53','2023-03-31 18:19:53',NULL),(3195,7851,1233,40719,20,21,502,1,5000.00,NULL,'2023-03-31 18:21:57','2023-03-31 18:21:57',NULL),(3196,7851,1233,40719,20,21,482,2,5000.00,NULL,'2023-03-31 18:21:57','2023-03-31 18:21:57',NULL),(3197,7851,1234,40719,20,21,482,2,8386.56,NULL,'2023-03-31 18:28:00','2023-03-31 18:28:00',NULL),(3198,7851,1234,40719,20,21,505,1,8386.56,NULL,'2023-03-31 18:28:00','2023-03-31 18:28:00',NULL),(3199,7851,1235,40719,20,21,482,2,24000.00,NULL,'2023-03-31 18:34:13','2023-03-31 18:34:13',NULL),(3200,7851,1235,40719,20,21,495,1,24000.00,NULL,'2023-03-31 18:34:13','2023-03-31 18:34:13',NULL),(3201,7851,1236,40719,20,21,482,2,1198.34,NULL,'2023-03-31 18:39:29','2023-03-31 18:39:29',NULL),(3202,7851,1236,40719,20,21,396,1,1198.34,NULL,'2023-03-31 18:39:29','2023-03-31 18:39:29',NULL),(3203,7851,1237,40719,20,21,482,2,251.65,NULL,'2023-03-31 18:40:53','2023-03-31 18:40:53',NULL),(3204,7851,1237,40719,20,21,396,1,251.65,NULL,'2023-03-31 18:40:53','2023-03-31 18:40:53',NULL),(3205,7851,1238,40719,20,2,482,1,0.01,NULL,'2023-03-31 18:46:47','2023-03-31 18:46:47',NULL),(3206,7851,1238,40719,20,2,136,2,0.01,NULL,'2023-03-31 18:46:47','2023-03-31 18:46:47',NULL),(3207,7851,1239,40719,20,19,163,1,202525.35,NULL,'2023-03-31 19:09:16','2023-03-31 19:09:16',NULL),(3208,7851,1239,40719,20,19,547,2,187416.62,NULL,'2023-03-31 19:09:16','2023-03-31 19:09:16',NULL);
INSERT INTO `balance_libro_details` VALUES (3209,7851,1239,40719,20,19,550,2,15108.73,NULL,'2023-03-31 19:09:16','2023-03-31 19:09:16',NULL),(3210,7851,1240,40719,20,19,163,1,2085.80,NULL,'2023-03-31 19:18:44','2023-03-31 19:18:44',NULL),(3211,7851,1240,40719,20,19,165,2,2085.80,NULL,'2023-03-31 19:18:44','2023-03-31 19:18:44',NULL),(3212,7851,1241,40719,20,19,163,2,2085.80,NULL,'2023-03-31 19:19:40','2023-03-31 19:19:40',NULL),(3213,7851,1241,40719,20,19,165,1,2085.80,NULL,'2023-03-31 19:19:40','2023-03-31 19:19:40',NULL),(3214,7851,1242,40719,20,3,110,1,52290.00,NULL,'2023-03-31 19:20:53','2023-03-31 19:20:53',NULL),(3215,7851,1242,40719,20,3,62,2,52290.00,NULL,'2023-03-31 19:20:53','2023-03-31 19:20:53',NULL),(3216,7851,1243,40719,20,3,491,1,87710.00,NULL,'2023-03-31 19:21:25','2023-04-01 19:37:58','2023-04-01 19:37:58'),(3217,7851,1243,40719,20,3,518,2,87710.00,NULL,'2023-03-31 19:21:25','2023-04-01 19:37:58','2023-04-01 19:37:58'),(3218,7851,1244,40719,20,21,163,2,87710.00,NULL,'2023-03-31 19:22:14','2023-03-31 19:22:14',NULL),(3219,7851,1244,40719,20,21,491,1,87710.00,NULL,'2023-03-31 19:22:14','2023-03-31 19:22:14',NULL),(3220,7851,1245,40719,20,21,163,2,52290.00,NULL,'2023-03-31 19:22:40','2023-03-31 19:22:40',NULL),(3221,7851,1245,40719,20,21,62,1,52290.00,NULL,'2023-03-31 19:22:40','2023-03-31 19:22:40',NULL),(3222,7851,1246,40719,20,2,136,1,0.57,NULL,'2023-03-31 19:28:47','2023-03-31 19:28:47',NULL),(3223,7851,1246,40719,20,2,163,2,0.57,NULL,'2023-03-31 19:28:47','2023-03-31 19:28:47',NULL),(3224,7851,1247,40719,20,21,57,1,20800.00,NULL,'2023-04-01 00:43:59','2023-04-01 00:43:59',NULL),(3225,7851,1247,40719,20,21,484,2,20800.00,NULL,'2023-04-01 00:43:59','2023-04-01 00:43:59',NULL),(3226,7851,1248,40719,20,19,483,2,20000.00,NULL,'2023-04-01 00:52:38','2023-04-01 00:52:38',NULL),(3227,7851,1248,40719,20,19,484,1,20000.00,NULL,'2023-04-01 00:52:38','2023-04-01 00:52:38',NULL),(3228,7851,1249,40719,20,19,492,1,10000.00,NULL,'2023-04-01 01:01:45','2023-04-01 01:01:45',NULL),(3229,7851,1249,40719,20,19,483,2,10000.00,NULL,'2023-04-01 01:01:45','2023-04-01 01:01:45',NULL),(3230,7851,1250,40719,20,19,492,1,4000.00,NULL,'2023-04-01 01:06:41','2023-04-01 01:08:02','2023-04-01 01:08:02'),(3231,7851,1250,40719,20,19,483,2,4000.00,NULL,'2023-04-01 01:06:41','2023-04-01 01:08:02','2023-04-01 01:08:02'),(3232,7851,1251,40719,20,21,483,2,4100.00,NULL,'2023-04-01 01:07:29','2023-04-01 01:07:29',NULL),(3233,7851,1251,40719,20,21,519,1,4100.00,NULL,'2023-04-01 01:07:29','2023-04-01 01:07:29',NULL),(3234,7851,1252,40719,20,21,483,2,4000.00,NULL,'2023-04-01 01:08:02','2023-04-01 01:08:02',NULL),(3235,7851,1252,40719,20,21,519,1,4000.00,NULL,'2023-04-01 01:08:02','2023-04-01 01:08:02',NULL),(3236,7851,1253,40719,20,19,136,2,0.31,NULL,'2023-04-01 01:14:08','2023-04-01 01:14:08',NULL),(3237,7851,1253,40719,20,19,483,1,0.31,NULL,'2023-04-01 01:14:08','2023-04-01 01:14:08',NULL),(3238,7851,1254,40719,10,20,13,2,24000.00,NULL,'2023-04-01 18:47:08','2023-04-01 18:47:08',NULL),(3239,7851,1254,40719,10,20,488,1,24000.00,NULL,'2023-04-01 18:47:08','2023-04-01 18:47:08',NULL),(3240,7851,1255,40719,10,21,57,1,28273.83,NULL,'2023-04-01 18:51:27','2023-04-01 18:52:14','2023-04-01 18:52:14'),(3241,7851,1255,40719,10,21,552,2,28273.83,NULL,'2023-04-01 18:51:27','2023-04-01 18:52:14','2023-04-01 18:52:14'),(3242,7851,1256,40719,10,21,57,1,25273.82,NULL,'2023-04-01 18:54:26','2023-04-01 18:54:26',NULL),(3243,7851,1256,40719,10,21,552,2,25273.82,NULL,'2023-04-01 18:54:26','2023-04-01 18:54:26',NULL),(3244,7851,1257,40719,10,21,57,1,4232.92,NULL,'2023-04-01 18:57:25','2023-04-01 18:57:25',NULL),(3245,7851,1257,40719,10,21,552,2,4232.92,NULL,'2023-04-01 18:57:25','2023-04-01 18:57:25',NULL),(3246,7851,1258,40719,20,21,57,1,34998.04,NULL,'2023-04-01 19:19:50','2023-04-01 19:19:58','2023-04-01 19:19:58'),(3247,7851,1258,40719,20,21,552,2,34998.04,NULL,'2023-04-01 19:19:50','2023-04-01 19:19:58','2023-04-01 19:19:58');
INSERT INTO `balance_libro_details` VALUES (3248,7851,1259,40719,20,3,485,1,28924.00,NULL,'2023-04-01 19:20:21','2023-04-01 19:25:54','2023-04-01 19:25:54'),(3249,7851,1259,40719,20,3,68,1,6074.04,NULL,'2023-04-01 19:20:21','2023-04-01 19:25:54','2023-04-01 19:25:54'),(3250,7851,1259,40719,20,3,57,2,34998.04,NULL,'2023-04-01 19:20:21','2023-04-01 19:25:54','2023-04-01 19:25:54'),(3251,7851,1260,40719,20,3,495,1,5471.29,NULL,'2023-04-01 19:22:25','2023-04-01 19:25:39','2023-04-01 19:25:39'),(3252,7851,1260,40719,20,3,68,1,1148.97,NULL,'2023-04-01 19:22:25','2023-04-01 19:25:39','2023-04-01 19:25:39'),(3253,7851,1260,40719,20,3,495,1,979.74,NULL,'2023-04-01 19:22:25','2023-04-01 19:25:39','2023-04-01 19:25:39'),(3254,7851,1260,40719,20,3,57,2,7600.00,NULL,'2023-04-01 19:22:25','2023-04-01 19:25:39','2023-04-01 19:25:39'),(3255,7851,1261,40719,20,3,521,1,28429.75,NULL,'2023-04-01 19:22:45','2023-04-01 19:22:45',NULL),(3256,7851,1261,40719,20,3,68,1,5970.25,NULL,'2023-04-01 19:22:45','2023-04-01 19:22:45',NULL),(3257,7851,1261,40719,20,3,57,2,34400.00,NULL,'2023-04-01 19:22:45','2023-04-01 19:22:45',NULL),(3258,7851,1262,40719,20,3,526,1,1723.80,NULL,'2023-04-01 19:23:08','2023-04-01 19:23:08',NULL),(3259,7851,1262,40719,20,3,68,1,362.00,NULL,'2023-04-01 19:23:08','2023-04-01 19:23:08',NULL),(3260,7851,1262,40719,20,3,57,2,2085.80,NULL,'2023-04-01 19:23:08','2023-04-01 19:23:08',NULL),(3261,7851,1263,40719,20,3,507,1,8159.26,NULL,'2023-04-01 19:23:37','2023-04-01 19:23:37',NULL),(3262,7851,1263,40719,20,3,68,1,1713.44,NULL,'2023-04-01 19:23:37','2023-04-01 19:23:37',NULL),(3263,7851,1263,40719,20,3,221,1,631.90,NULL,'2023-04-01 19:23:37','2023-04-01 19:23:37',NULL),(3264,7851,1263,40719,20,3,57,2,10504.60,NULL,'2023-04-01 19:23:37','2023-04-01 19:23:37',NULL),(3265,7851,1264,40719,20,3,507,1,7890.83,NULL,'2023-04-01 19:24:20','2023-04-01 19:24:20',NULL),(3266,7851,1264,40719,20,3,68,1,1657.07,NULL,'2023-04-01 19:24:20','2023-04-01 19:24:20',NULL),(3267,7851,1264,40719,20,3,221,1,1152.50,NULL,'2023-04-01 19:24:20','2023-04-01 19:24:20',NULL),(3268,7851,1264,40719,20,3,57,2,10700.40,NULL,'2023-04-01 19:24:20','2023-04-01 19:24:20',NULL),(3269,7851,1265,40719,20,3,524,1,8264.46,NULL,'2023-04-01 19:24:49','2023-04-01 19:24:49',NULL),(3270,7851,1265,40719,20,3,68,1,1735.54,NULL,'2023-04-01 19:24:49','2023-04-01 19:24:49',NULL),(3271,7851,1265,40719,20,3,57,2,10000.00,NULL,'2023-04-01 19:24:49','2023-04-01 19:24:49',NULL),(3272,7851,1266,40719,20,3,522,1,12479.34,NULL,'2023-04-01 19:25:08','2023-04-01 19:25:08',NULL),(3273,7851,1266,40719,20,3,68,1,2620.66,NULL,'2023-04-01 19:25:08','2023-04-01 19:25:08',NULL),(3274,7851,1266,40719,20,3,57,2,15100.00,NULL,'2023-04-01 19:25:08','2023-04-01 19:25:08',NULL),(3275,7851,1267,40719,20,3,495,1,5471.29,NULL,'2023-04-01 19:25:39','2023-04-01 19:25:39',NULL),(3276,7851,1267,40719,20,3,68,1,1148.97,NULL,'2023-04-01 19:25:39','2023-04-01 19:25:39',NULL),(3277,7851,1267,40719,20,3,495,1,979.74,NULL,'2023-04-01 19:25:39','2023-04-01 19:25:39',NULL),(3278,7851,1267,40719,20,3,57,2,7600.00,NULL,'2023-04-01 19:25:39','2023-04-01 19:25:39',NULL),(3279,7851,1268,40719,20,3,485,1,28924.00,NULL,'2023-04-01 19:25:54','2023-04-01 19:25:54',NULL),(3280,7851,1268,40719,20,3,68,1,6074.04,NULL,'2023-04-01 19:25:54','2023-04-01 19:25:54',NULL),(3281,7851,1268,40719,20,3,57,2,34998.04,NULL,'2023-04-01 19:25:54','2023-04-01 19:25:54',NULL),(3282,7851,1269,40719,20,21,57,1,34998.04,NULL,'2023-04-01 19:27:58','2023-04-01 19:27:58',NULL),(3283,7851,1269,40719,20,21,552,2,34998.04,NULL,'2023-04-01 19:27:58','2023-04-01 19:27:58',NULL),(3284,7851,1270,40719,20,21,57,1,7600.00,NULL,'2023-04-01 19:30:52','2023-04-01 19:30:52',NULL),(3285,7851,1270,40719,20,21,483,2,7600.00,NULL,'2023-04-01 19:30:52','2023-04-01 19:30:52',NULL),(3286,7851,1271,40719,20,21,57,1,15100.00,NULL,'2023-04-01 19:31:25','2023-04-01 19:31:25',NULL),(3287,7851,1271,40719,20,21,163,2,15100.00,NULL,'2023-04-01 19:31:25','2023-04-01 19:31:25',NULL);
INSERT INTO `balance_libro_details` VALUES (3288,7851,1272,40719,20,21,57,1,10000.00,NULL,'2023-04-01 19:32:38','2023-04-01 19:32:38',NULL),(3289,7851,1272,40719,20,21,483,2,5000.00,NULL,'2023-04-01 19:32:38','2023-04-01 19:32:38',NULL),(3290,7851,1272,40719,20,21,552,2,5000.00,NULL,'2023-04-01 19:32:38','2023-04-01 19:32:38',NULL),(3291,7851,1273,40719,20,21,57,1,10504.60,NULL,'2023-04-01 19:33:48','2023-04-01 19:33:48',NULL),(3292,7851,1273,40719,20,21,552,2,10504.60,NULL,'2023-04-01 19:33:48','2023-04-01 19:33:48',NULL),(3293,7851,1274,40719,20,21,57,1,10700.40,NULL,'2023-04-01 19:34:39','2023-04-01 19:34:39',NULL),(3294,7851,1274,40719,20,21,552,2,10700.40,NULL,'2023-04-01 19:34:39','2023-04-01 19:34:39',NULL),(3295,7851,1275,40719,20,21,57,1,2085.80,NULL,'2023-04-01 19:35:21','2023-04-01 19:35:21',NULL),(3296,7851,1275,40719,20,21,163,2,2085.80,NULL,'2023-04-01 19:35:21','2023-04-01 19:35:21',NULL),(3297,7851,1276,40719,20,21,57,1,34400.00,NULL,'2023-04-01 19:36:13','2023-04-01 19:36:13',NULL),(3298,7851,1276,40719,20,21,163,2,34400.00,NULL,'2023-04-01 19:36:13','2023-04-01 19:36:13',NULL),(3299,7851,1277,40719,20,3,491,2,87710.00,NULL,'2023-04-01 19:37:58','2023-04-01 19:37:58',NULL),(3300,7851,1277,40719,20,3,518,1,87710.00,NULL,'2023-04-01 19:37:58','2023-04-01 19:37:58',NULL),(3301,7851,1278,40719,10,21,57,1,49200.62,NULL,'2023-04-01 19:43:03','2023-04-01 19:43:03',NULL),(3302,7851,1278,40719,10,21,488,2,49200.62,NULL,'2023-04-01 19:43:03','2023-04-01 19:43:03',NULL),(3303,7851,1279,40719,10,21,57,1,10652.82,NULL,'2023-04-01 19:43:44','2023-04-01 19:43:44',NULL),(3304,7851,1279,40719,10,21,552,2,10652.82,NULL,'2023-04-01 19:43:44','2023-04-01 19:43:44',NULL),(3305,7851,1280,40719,10,21,57,1,22800.01,NULL,'2023-04-01 19:44:17','2023-04-01 19:44:17',NULL),(3306,7851,1280,40719,10,21,552,2,22800.01,NULL,'2023-04-01 19:44:17','2023-04-01 19:44:17',NULL),(3307,7851,1281,40719,20,3,120,1,12531.72,NULL,'2023-04-05 12:09:58','2023-04-05 12:11:19','2023-04-05 12:11:19'),(3308,7851,1281,40719,20,3,68,1,3383.56,NULL,'2023-04-05 12:09:58','2023-04-05 12:11:19','2023-04-05 12:11:19'),(3309,7851,1281,40719,20,3,120,1,586.00,NULL,'2023-04-05 12:09:58','2023-04-05 12:11:19','2023-04-05 12:11:19'),(3310,7851,1281,40719,20,3,68,1,123.06,NULL,'2023-04-05 12:09:58','2023-04-05 12:11:19','2023-04-05 12:11:19'),(3311,7851,1281,40719,20,3,221,1,659.56,NULL,'2023-04-05 12:09:58','2023-04-05 12:11:19','2023-04-05 12:11:19'),(3312,7851,1281,40719,20,3,237,1,393.53,NULL,'2023-04-05 12:09:58','2023-04-05 12:11:19','2023-04-05 12:11:19'),(3313,7851,1281,40719,20,3,57,2,17677.43,NULL,'2023-04-05 12:09:58','2023-04-05 12:11:19','2023-04-05 12:11:19'),(3314,7851,1282,40719,20,21,57,1,17677.43,NULL,'2023-04-05 12:11:18','2023-04-13 19:01:28','2023-04-13 19:01:28'),(3315,7851,1282,40719,20,21,163,2,17677.43,NULL,'2023-04-05 12:11:18','2023-04-13 19:01:28','2023-04-13 19:01:28'),(3316,7851,1283,40719,20,3,120,1,12531.72,NULL,'2023-04-05 12:11:19','2023-04-05 12:11:19',NULL),(3317,7851,1283,40719,20,3,68,1,3383.56,NULL,'2023-04-05 12:11:19','2023-04-05 12:11:19',NULL),(3318,7851,1283,40719,20,3,120,1,586.00,NULL,'2023-04-05 12:11:19','2023-04-05 12:11:19',NULL),(3319,7851,1283,40719,20,3,68,1,123.06,NULL,'2023-04-05 12:11:19','2023-04-05 12:11:19',NULL),(3320,7851,1283,40719,20,3,221,1,659.56,NULL,'2023-04-05 12:11:19','2023-04-05 12:11:19',NULL),(3321,7851,1283,40719,20,3,237,1,393.53,NULL,'2023-04-05 12:11:19','2023-04-05 12:11:19',NULL),(3322,7851,1283,40719,20,3,57,2,17677.43,NULL,'2023-04-05 12:11:19','2023-04-05 12:11:19',NULL),(3327,7851,1286,40719,20,3,120,1,1405.96,NULL,'2023-04-05 12:13:41','2023-04-05 12:14:13','2023-04-05 12:14:13'),(3328,7851,1286,40719,20,3,68,1,379.61,NULL,'2023-04-05 12:13:41','2023-04-05 12:14:13','2023-04-05 12:14:13'),(3329,7851,1286,40719,20,3,57,2,1785.57,NULL,'2023-04-05 12:13:41','2023-04-05 12:14:13','2023-04-05 12:14:13'),(3330,7851,1287,40719,20,21,57,1,1785.57,NULL,'2023-04-05 12:14:13','2023-04-13 19:01:32','2023-04-13 19:01:32');
INSERT INTO `balance_libro_details` VALUES (3331,7851,1287,40719,20,21,163,2,1785.57,NULL,'2023-04-05 12:14:13','2023-04-13 19:01:32','2023-04-13 19:01:32'),(3332,7851,1288,40719,20,3,120,1,1405.96,NULL,'2023-04-05 12:14:13','2023-04-05 12:14:13',NULL),(3333,7851,1288,40719,20,3,68,1,379.61,NULL,'2023-04-05 12:14:13','2023-04-05 12:14:13',NULL),(3334,7851,1288,40719,20,3,57,2,1785.57,NULL,'2023-04-05 12:14:13','2023-04-05 12:14:13',NULL),(3335,7851,1289,40719,20,20,13,2,1568772.24,NULL,'2023-04-10 16:27:56','2023-04-10 16:27:56',NULL),(3336,7851,1289,40719,20,20,482,1,1502260.55,NULL,'2023-04-10 16:27:56','2023-04-10 16:27:56',NULL),(3337,7851,1289,40719,20,20,263,1,42590.92,NULL,'2023-04-10 16:27:56','2023-04-10 16:27:56',NULL),(3338,7851,1289,40719,20,20,23,1,23920.77,NULL,'2023-04-10 16:27:56','2023-04-10 16:27:56',NULL),(3339,7851,1290,40719,21,2,96,2,2247863.69,NULL,'2023-04-10 16:29:56','2023-04-10 16:29:56',NULL),(3340,7851,1290,40719,21,2,67,2,236025.69,NULL,'2023-04-10 16:29:56','2023-04-10 16:29:56',NULL),(3341,7851,1290,40719,21,2,13,1,2483889.38,NULL,'2023-04-10 16:29:56','2023-04-10 16:29:56',NULL),(3342,7851,1291,40719,21,20,13,2,2483889.38,NULL,'2023-04-10 16:33:50','2023-04-10 16:33:50',NULL),(3343,7851,1291,40719,21,20,163,1,2375976.20,NULL,'2023-04-10 16:33:50','2023-04-10 16:33:50',NULL),(3344,7851,1291,40719,21,20,263,1,67435.91,NULL,'2023-04-10 16:33:50','2023-04-10 16:33:50',NULL),(3345,7851,1291,40719,21,20,23,1,40477.27,NULL,'2023-04-10 16:33:50','2023-04-10 16:33:50',NULL),(3346,7851,1292,40719,21,19,485,1,400000.00,NULL,'2023-04-10 16:38:44','2023-04-10 16:38:44',NULL),(3347,7851,1292,40719,21,19,163,2,400000.00,NULL,'2023-04-10 16:38:44','2023-04-10 16:38:44',NULL),(3348,7851,1293,40719,21,19,482,1,400000.00,NULL,'2023-04-10 16:39:30','2023-04-10 16:39:30',NULL),(3349,7851,1293,40719,21,19,163,2,400000.00,NULL,'2023-04-10 16:39:30','2023-04-10 16:39:30',NULL),(3350,7851,1294,40719,21,21,495,1,87071.65,NULL,'2023-04-10 16:40:46','2023-04-10 16:40:46',NULL),(3351,7851,1294,40719,21,21,482,2,87071.65,NULL,'2023-04-10 16:40:46','2023-04-10 16:40:46',NULL),(3352,7851,1295,40719,21,19,541,1,150000.00,NULL,'2023-04-10 16:44:50','2023-04-10 16:44:50',NULL),(3353,7851,1295,40719,21,19,482,2,150000.00,NULL,'2023-04-10 16:44:50','2023-04-10 16:44:50',NULL),(3354,7851,1296,40719,21,21,498,1,9300.00,NULL,'2023-04-10 16:48:03','2023-04-10 16:48:03',NULL),(3355,7851,1296,40719,21,21,482,2,9300.00,NULL,'2023-04-10 16:48:03','2023-04-10 16:48:03',NULL),(3356,7851,1297,40719,21,3,63,2,33566.15,NULL,'2023-04-13 18:59:07','2023-04-13 18:59:07',NULL),(3357,7851,1297,40719,21,3,191,1,33566.15,NULL,'2023-04-13 18:59:07','2023-04-13 18:59:07',NULL),(3358,7851,1298,40719,21,21,163,2,33566.15,NULL,'2023-04-13 18:59:42','2023-04-13 18:59:42',NULL),(3359,7851,1298,40719,21,21,63,1,33566.15,NULL,'2023-04-13 18:59:42','2023-04-13 18:59:42',NULL),(3360,7851,1299,40719,21,21,57,1,17677.43,NULL,'2023-04-13 19:02:01','2023-04-13 19:02:01',NULL),(3361,7851,1299,40719,21,21,163,2,17677.43,NULL,'2023-04-13 19:02:01','2023-04-13 19:02:01',NULL),(3362,7851,1300,40719,21,21,57,1,1785.57,NULL,'2023-04-13 19:02:29','2023-04-13 19:02:29',NULL),(3363,7851,1300,40719,21,21,163,2,1785.57,NULL,'2023-04-13 19:02:29','2023-04-13 19:02:29',NULL),(3364,7851,1301,40719,21,19,483,1,10000.00,NULL,'2023-04-13 19:47:46','2023-04-13 19:47:46',NULL),(3365,7851,1301,40719,21,19,163,2,10000.00,NULL,'2023-04-13 19:47:46','2023-04-13 19:47:46',NULL),(3366,7851,1302,40719,21,21,494,1,24732.55,NULL,'2023-04-13 20:00:18','2023-04-13 20:00:18',NULL),(3367,7851,1302,40719,21,21,163,2,24732.55,NULL,'2023-04-13 20:00:18','2023-04-13 20:00:18',NULL),(3368,7851,1303,40719,21,21,163,2,46323.10,NULL,'2023-04-13 20:19:45','2023-04-13 20:19:45',NULL),(3369,7851,1303,40719,21,21,493,1,46323.10,NULL,'2023-04-13 20:19:45','2023-04-13 20:19:45',NULL),(3370,7851,1304,40719,21,19,547,2,453166.60,NULL,'2023-04-13 21:05:49','2023-04-13 21:05:49',NULL);
INSERT INTO `balance_libro_details` VALUES (3371,7851,1304,40719,21,19,550,2,48427.59,NULL,'2023-04-13 21:05:49','2023-04-13 21:05:49',NULL),(3372,7851,1304,40719,21,19,163,1,501594.19,NULL,'2023-04-13 21:05:49','2023-04-13 21:05:49',NULL),(3373,7851,1305,40719,21,19,163,2,750000.00,NULL,'2023-04-13 21:22:54','2023-04-13 21:22:54',NULL),(3374,7851,1305,40719,21,19,547,1,750000.00,NULL,'2023-04-13 21:22:54','2023-04-13 21:22:54',NULL),(3375,7851,1306,40719,21,19,163,2,400000.00,NULL,'2023-04-13 21:25:01','2023-04-13 21:25:01',NULL),(3376,7851,1306,40719,21,19,482,1,400000.00,NULL,'2023-04-13 21:25:01','2023-04-13 21:25:01',NULL),(3377,7851,1307,40719,21,19,163,2,400000.00,NULL,'2023-04-13 21:25:56','2023-04-13 21:26:09','2023-04-13 21:26:09'),(3378,7851,1307,40719,21,19,482,1,400000.00,NULL,'2023-04-13 21:25:56','2023-04-13 21:26:09','2023-04-13 21:26:09'),(3379,7851,1308,40719,21,19,163,2,400000.00,NULL,'2023-04-13 21:26:09','2023-04-13 21:26:09',NULL),(3380,7851,1308,40719,21,19,482,1,400000.00,NULL,'2023-04-13 21:26:09','2023-04-13 21:26:09',NULL),(3381,7851,1309,40719,21,2,545,2,1.85,NULL,'2023-04-13 21:27:53','2023-04-13 21:27:53',NULL),(3382,7851,1309,40719,21,2,163,1,1.85,NULL,'2023-04-13 21:27:53','2023-04-13 21:27:53',NULL),(3383,7851,1310,40719,21,19,163,2,0.29,NULL,'2023-04-13 21:29:10','2023-04-13 21:29:10',NULL),(3384,7851,1310,40719,21,19,165,1,0.29,NULL,'2023-04-13 21:29:10','2023-04-13 21:29:10',NULL),(3385,7851,1311,40719,21,19,163,2,47.93,NULL,'2023-04-13 21:48:28','2023-04-13 21:48:28',NULL),(3386,7851,1311,40719,21,19,165,1,47.93,NULL,'2023-04-13 21:48:28','2023-04-13 21:48:28',NULL),(3387,7851,1312,40719,21,19,163,2,415014.00,NULL,'2023-04-13 22:05:15','2023-05-10 18:16:03','2023-05-10 18:16:03'),(3388,7851,1312,40719,21,19,556,1,415014.00,NULL,'2023-04-13 22:05:15','2023-05-10 18:16:03','2023-05-10 18:16:03'),(3389,7851,1313,40719,21,21,165,2,0.29,NULL,'2023-04-13 22:14:43','2023-04-13 22:14:43',NULL),(3390,7851,1313,40719,21,21,555,1,0.29,NULL,'2023-04-13 22:14:43','2023-04-13 22:14:43',NULL),(3391,7851,1314,40719,21,21,140,1,0.91,NULL,'2023-04-13 22:17:38','2023-04-13 22:17:38',NULL),(3392,7851,1314,40719,21,21,165,2,0.91,NULL,'2023-04-13 22:17:38','2023-04-13 22:17:38',NULL),(3393,7851,1315,40719,21,21,165,2,38.86,NULL,'2023-04-13 22:19:33','2023-04-13 22:19:33',NULL),(3394,7851,1315,40719,21,21,140,1,38.86,NULL,'2023-04-13 22:19:33','2023-04-13 22:19:33',NULL),(3395,7851,1316,40719,21,21,165,2,38.86,NULL,'2023-04-13 22:20:29','2023-04-13 22:20:52','2023-04-13 22:20:52'),(3396,7851,1316,40719,21,21,140,1,38.86,NULL,'2023-04-13 22:20:29','2023-04-13 22:20:52','2023-04-13 22:20:52'),(3397,7851,1317,40719,21,21,165,2,8.16,NULL,'2023-04-13 22:20:52','2023-04-13 22:20:52',NULL),(3398,7851,1317,40719,21,21,140,1,8.16,NULL,'2023-04-13 22:20:52','2023-04-13 22:20:52',NULL),(3399,7851,1318,40719,20,19,497,1,10000.00,NULL,'2023-04-13 23:06:47','2023-04-13 23:06:47',NULL),(3400,7851,1318,40719,20,19,482,2,10000.00,NULL,'2023-04-13 23:06:47','2023-04-13 23:06:47',NULL),(3401,7851,1319,40719,20,19,497,1,40000.00,NULL,'2023-04-13 23:09:18','2023-04-13 23:09:18',NULL),(3402,7851,1319,40719,20,19,482,2,40000.00,NULL,'2023-04-13 23:09:18','2023-04-13 23:09:18',NULL),(3403,7851,1320,40719,20,2,511,2,2.98,NULL,'2023-04-13 23:10:13','2023-04-13 23:10:13',NULL),(3404,7851,1320,40719,20,2,482,1,2.98,NULL,'2023-04-13 23:10:13','2023-04-13 23:10:13',NULL),(3405,7851,1321,40719,21,19,492,1,10000.00,NULL,'2023-04-14 00:06:31','2023-04-14 00:06:31',NULL),(3406,7851,1321,40719,21,19,482,2,10000.00,NULL,'2023-04-14 00:06:31','2023-04-14 00:06:31',NULL),(3407,7851,1322,40719,21,19,482,2,10000.00,NULL,'2023-04-14 00:07:17','2023-04-14 00:07:17',NULL),(3408,7851,1322,40719,21,19,492,1,10000.00,NULL,'2023-04-14 00:07:17','2023-04-14 00:07:17',NULL),(3409,7851,1323,40719,21,21,482,2,251.65,NULL,'2023-04-14 00:10:02','2023-04-14 00:10:35','2023-04-14 00:10:35'),(3410,7851,1323,40719,21,21,482,2,1198.34,NULL,'2023-04-14 00:10:02','2023-04-14 00:10:35','2023-04-14 00:10:35');
INSERT INTO `balance_libro_details` VALUES (3411,7851,1323,40719,21,21,396,1,251.65,NULL,'2023-04-14 00:10:02','2023-04-14 00:10:35','2023-04-14 00:10:35'),(3412,7851,1323,40719,21,21,396,1,1198.34,NULL,'2023-04-14 00:10:02','2023-04-14 00:10:35','2023-04-14 00:10:35'),(3413,7851,1324,40719,21,21,482,2,1198.34,NULL,'2023-04-14 00:10:35','2023-04-14 00:11:55','2023-04-14 00:11:55'),(3414,7851,1324,40719,21,21,396,1,1198.34,NULL,'2023-04-14 00:10:35','2023-04-14 00:11:55','2023-04-14 00:11:55'),(3415,7851,1325,40719,21,21,482,2,251.65,NULL,'2023-04-14 00:11:45','2023-04-14 00:12:04','2023-04-14 00:12:04'),(3416,7851,1325,40719,21,21,396,1,251.65,NULL,'2023-04-14 00:11:45','2023-04-14 00:12:04','2023-04-14 00:12:04'),(3417,7851,1326,40719,21,21,482,2,1198.34,NULL,'2023-04-14 00:11:55','2023-04-14 00:11:55',NULL),(3418,7851,1326,40719,21,21,396,1,1198.34,NULL,'2023-04-14 00:11:55','2023-04-14 00:11:55',NULL),(3419,7851,1327,40719,21,21,482,2,251.65,NULL,'2023-04-14 00:12:04','2023-04-14 00:12:04',NULL),(3420,7851,1327,40719,21,21,396,1,251.65,NULL,'2023-04-14 00:12:04','2023-04-14 00:12:04',NULL),(3421,7851,1328,40719,21,21,498,1,7888.50,NULL,'2023-04-14 00:15:05','2023-04-14 00:15:05',NULL),(3422,7851,1328,40719,21,21,482,2,7888.50,NULL,'2023-04-14 00:15:05','2023-04-14 00:15:05',NULL),(3423,7851,1329,40719,21,21,498,1,7888.50,NULL,'2023-04-14 00:15:58','2023-04-14 00:15:58',NULL),(3424,7851,1329,40719,21,21,482,2,7888.50,NULL,'2023-04-14 00:15:58','2023-04-14 00:15:58',NULL),(3425,7851,1330,40719,21,21,482,2,1654.00,NULL,'2023-04-14 00:17:32','2023-04-14 00:17:32',NULL),(3426,7851,1330,40719,21,21,498,1,1654.00,NULL,'2023-04-14 00:17:32','2023-04-14 00:17:32',NULL),(3427,7851,1331,40719,21,21,482,2,1654.00,NULL,'2023-04-14 00:18:20','2023-04-14 00:18:20',NULL),(3428,7851,1331,40719,21,21,498,1,1654.00,NULL,'2023-04-14 00:18:20','2023-04-14 00:18:20',NULL),(3429,7851,1332,40719,21,19,497,1,15000.00,NULL,'2023-04-14 00:19:51','2023-04-14 00:19:51',NULL),(3430,7851,1332,40719,21,19,482,2,15000.00,NULL,'2023-04-14 00:19:51','2023-04-14 00:19:51',NULL),(3431,7851,1333,40719,21,21,396,1,585.38,NULL,'2023-04-14 00:21:24','2023-04-14 00:22:33','2023-04-14 00:22:33'),(3432,7851,1333,40719,21,21,482,2,585.38,NULL,'2023-04-14 00:21:24','2023-04-14 00:22:33','2023-04-14 00:22:33'),(3433,7851,1334,40719,21,21,482,2,3310.37,NULL,'2023-04-14 00:22:24','2023-04-14 00:22:24',NULL),(3434,7851,1334,40719,21,21,396,1,3310.37,NULL,'2023-04-14 00:22:24','2023-04-14 00:22:24',NULL),(3435,7851,1335,40719,21,21,396,1,585.38,NULL,'2023-04-14 00:22:33','2023-04-14 00:22:33',NULL),(3436,7851,1335,40719,21,21,482,2,585.38,NULL,'2023-04-14 00:22:33','2023-04-14 00:22:33',NULL),(3437,7851,1336,40719,21,19,482,2,850000.00,NULL,'2023-04-14 00:23:51','2023-04-14 00:23:51',NULL),(3438,7851,1336,40719,21,19,483,1,850000.00,NULL,'2023-04-14 00:23:51','2023-04-14 00:23:51',NULL),(3439,7851,1337,40719,21,19,482,1,850000.00,NULL,'2023-04-14 00:24:44','2023-04-14 00:24:44',NULL),(3440,7851,1337,40719,21,19,483,2,850000.00,NULL,'2023-04-14 00:24:44','2023-04-14 00:24:44',NULL),(3441,7851,1338,40719,21,19,557,1,700000.00,NULL,'2023-04-14 00:46:13','2023-04-14 00:52:36','2023-04-14 00:52:36'),(3442,7851,1338,40719,21,19,482,2,700000.00,NULL,'2023-04-14 00:46:13','2023-04-14 00:52:36','2023-04-14 00:52:36'),(3443,7851,1339,40719,21,19,557,1,150000.00,NULL,'2023-04-14 00:52:26','2023-04-14 00:52:26',NULL),(3444,7851,1339,40719,21,19,482,2,150000.00,NULL,'2023-04-14 00:52:26','2023-04-14 00:52:26',NULL),(3445,7851,1340,40719,21,19,557,1,700000.00,NULL,'2023-04-14 00:52:36','2023-04-14 00:52:36',NULL),(3446,7851,1340,40719,21,19,482,2,700000.00,NULL,'2023-04-14 00:52:36','2023-04-14 00:52:36',NULL),(3447,7851,1341,40719,21,19,557,2,5567.97,NULL,'2023-04-14 00:58:45','2023-04-14 00:58:45',NULL),(3448,7851,1341,40719,21,19,482,1,5567.97,NULL,'2023-04-14 00:58:45','2023-04-14 00:58:45',NULL),(3449,7851,1342,40719,21,19,482,1,985.62,NULL,'2023-04-14 00:59:19','2023-04-14 00:59:19',NULL);
INSERT INTO `balance_libro_details` VALUES (3450,7851,1342,40719,21,19,557,2,985.62,NULL,'2023-04-14 00:59:19','2023-04-14 00:59:19',NULL),(3451,7851,1343,40719,21,21,482,2,2165.00,NULL,'2023-04-14 01:02:44','2023-04-14 01:04:14','2023-04-14 01:04:14'),(3452,7851,1343,40719,21,21,212,1,2165.00,NULL,'2023-04-14 01:02:44','2023-04-14 01:04:14','2023-04-14 01:04:14'),(3453,7851,1344,40719,21,21,214,1,8996.98,NULL,'2023-04-14 01:03:54','2023-04-14 01:04:06','2023-04-14 01:04:06'),(3454,7851,1344,40719,21,21,482,2,8996.98,NULL,'2023-04-14 01:03:54','2023-04-14 01:04:06','2023-04-14 01:04:06'),(3455,7851,1345,40719,21,21,214,1,8996.98,NULL,'2023-04-14 01:04:06','2023-04-14 01:04:06',NULL),(3456,7851,1345,40719,21,21,482,2,8996.98,NULL,'2023-04-14 01:04:06','2023-04-14 01:04:06',NULL),(3457,7851,1346,40719,21,21,482,2,2165.00,NULL,'2023-04-14 01:04:14','2023-04-14 01:04:14',NULL),(3458,7851,1346,40719,21,21,212,1,2165.00,NULL,'2023-04-14 01:04:14','2023-04-14 01:04:14',NULL),(3459,7851,1347,40719,21,19,497,1,40000.00,NULL,'2023-04-14 01:05:10','2023-04-14 01:05:10',NULL),(3460,7851,1347,40719,21,19,482,2,40000.00,NULL,'2023-04-14 01:05:10','2023-04-14 01:05:10',NULL),(3461,7851,1348,40719,21,19,482,2,49.06,NULL,'2023-04-14 01:08:13','2023-04-14 19:43:05','2023-04-14 19:43:05'),(3462,7851,1348,40719,21,19,558,1,49.06,NULL,'2023-04-14 01:08:13','2023-04-14 19:43:05','2023-04-14 19:43:05'),(3463,7851,1349,40719,21,19,482,1,0.57,NULL,'2023-04-14 01:09:05','2023-04-14 01:09:05',NULL),(3464,7851,1349,40719,21,19,557,2,0.57,NULL,'2023-04-14 01:09:05','2023-04-14 01:09:05',NULL),(3465,7851,1350,40719,21,19,559,1,6000.00,NULL,'2023-04-14 01:14:01','2023-04-14 01:14:01',NULL),(3466,7851,1350,40719,21,19,502,1,4000.00,NULL,'2023-04-14 01:14:01','2023-04-14 01:14:01',NULL),(3467,7851,1350,40719,21,19,482,2,10000.00,NULL,'2023-04-14 01:14:01','2023-04-14 01:14:01',NULL),(3468,7851,1351,40719,21,21,560,1,7370.04,NULL,'2023-04-14 01:18:13','2023-04-14 01:18:13',NULL),(3469,7851,1351,40719,21,21,482,2,7370.04,NULL,'2023-04-14 01:18:13','2023-04-14 01:18:13',NULL),(3470,7851,1352,40719,21,19,489,1,5323.87,NULL,'2023-04-14 01:18:59','2023-04-14 01:18:59',NULL),(3471,7851,1352,40719,21,19,482,2,5323.87,NULL,'2023-04-14 01:18:59','2023-04-14 01:18:59',NULL),(3472,7851,1353,40719,21,19,484,1,30000.00,NULL,'2023-04-14 01:28:07','2023-04-14 01:28:07',NULL),(3473,7851,1353,40719,21,19,483,2,30000.00,NULL,'2023-04-14 01:28:07','2023-04-14 01:28:07',NULL),(3474,7851,1354,40719,21,19,561,1,2185.49,NULL,'2023-04-14 01:31:13','2023-04-14 01:43:13','2023-04-14 01:43:13'),(3475,7851,1354,40719,21,19,558,2,2185.49,NULL,'2023-04-14 01:31:13','2023-04-14 01:43:13','2023-04-14 01:43:13'),(3476,7851,1355,40719,21,19,444,1,2185.43,NULL,'2023-04-14 01:31:51','2023-04-14 01:42:53','2023-04-14 01:42:53'),(3477,7851,1355,40719,21,19,561,2,2185.43,NULL,'2023-04-14 01:31:51','2023-04-14 01:42:53','2023-04-14 01:42:53'),(3478,7851,1356,40719,21,19,557,2,50000.00,NULL,'2023-04-14 01:36:58','2023-04-14 01:37:39','2023-04-14 01:37:39'),(3479,7851,1356,40719,21,19,556,1,50000.00,NULL,'2023-04-14 01:36:58','2023-04-14 01:37:39','2023-04-14 01:37:39'),(3480,7851,1357,40719,21,19,557,1,50000.00,NULL,'2023-04-14 01:37:39','2023-04-14 01:40:00','2023-04-14 01:40:00'),(3481,7851,1357,40719,21,19,556,2,50000.00,NULL,'2023-04-14 01:37:39','2023-04-14 01:40:00','2023-04-14 01:40:00'),(3482,7851,1358,40719,21,19,557,2,50000.00,NULL,'2023-04-14 01:40:00','2023-04-14 19:33:02','2023-04-14 19:33:02'),(3483,7851,1358,40719,21,19,556,1,50000.00,NULL,'2023-04-14 01:40:00','2023-04-14 19:33:02','2023-04-14 19:33:02'),(3484,7851,1359,40719,21,19,444,2,2100.00,NULL,'2023-04-14 01:41:51','2023-04-14 01:41:51',NULL),(3485,7851,1359,40719,21,19,562,1,2100.00,NULL,'2023-04-14 01:41:51','2023-04-14 01:41:51',NULL),(3486,7851,1360,40719,21,19,444,1,2185.49,NULL,'2023-04-14 01:42:53','2023-04-14 01:43:51','2023-04-14 01:43:51'),(3487,7851,1360,40719,21,19,561,2,2185.49,NULL,'2023-04-14 01:42:53','2023-04-14 01:43:51','2023-04-14 01:43:51');
INSERT INTO `balance_libro_details` VALUES (3488,7851,1361,40719,21,19,561,1,2185.49,NULL,'2023-04-14 01:43:13','2023-04-14 01:43:13',NULL),(3489,7851,1361,40719,21,19,558,2,2185.49,NULL,'2023-04-14 01:43:13','2023-04-14 01:43:13',NULL),(3490,7851,1362,40719,21,19,444,1,2185.49,NULL,'2023-04-14 01:43:51','2023-04-14 01:43:51',NULL),(3491,7851,1362,40719,21,19,561,2,2185.49,NULL,'2023-04-14 01:43:51','2023-04-14 01:43:51',NULL),(3492,7851,1363,40719,21,19,136,2,43.99,NULL,'2023-04-14 12:12:16','2023-04-14 19:44:48','2023-04-14 19:44:48'),(3493,7851,1363,40719,21,19,482,1,43.99,NULL,'2023-04-14 12:12:16','2023-04-14 19:44:48','2023-04-14 19:44:48'),(3494,7851,1364,40719,21,19,492,1,22500.00,NULL,'2023-04-14 12:15:11','2023-04-14 12:15:11',NULL),(3495,7851,1364,40719,21,19,483,2,22500.00,NULL,'2023-04-14 12:15:11','2023-04-14 12:15:11',NULL),(3496,7851,1365,40719,21,21,57,1,-1698.84,NULL,'2023-04-14 12:20:19','2023-04-14 12:20:19',NULL),(3497,7851,1365,40719,21,21,552,2,-1698.84,NULL,'2023-04-14 12:20:19','2023-04-14 12:20:19',NULL),(3498,7851,1366,40719,21,3,526,1,2230.00,NULL,'2023-04-14 12:23:30','2023-04-14 12:23:30',NULL),(3499,7851,1366,40719,21,3,68,1,468.30,NULL,'2023-04-14 12:23:30','2023-04-14 12:23:30',NULL),(3500,7851,1366,40719,21,3,57,2,2698.30,NULL,'2023-04-14 12:23:30','2023-04-14 12:23:30',NULL),(3501,7851,1367,40719,21,21,57,1,2698.30,NULL,'2023-04-14 12:24:12','2023-04-14 12:24:12',NULL),(3502,7851,1367,40719,21,21,163,2,2698.30,NULL,'2023-04-14 12:24:12','2023-04-14 12:24:12',NULL),(3503,7851,1368,40719,21,19,136,1,71.37,NULL,'2023-04-14 12:29:22','2023-05-02 19:18:33','2023-05-02 19:18:33'),(3504,7851,1368,40719,21,19,163,2,71.37,NULL,'2023-04-14 12:29:22','2023-05-02 19:18:33','2023-05-02 19:18:33'),(3505,7851,1369,40719,21,21,483,2,3060.00,NULL,'2023-04-14 12:31:02','2023-04-14 12:31:02',NULL),(3506,7851,1369,40719,21,21,519,1,3060.00,NULL,'2023-04-14 12:31:02','2023-04-14 12:31:02',NULL),(3507,7851,1370,40719,21,19,483,2,30000.00,NULL,'2023-04-14 19:26:00','2023-04-14 19:26:16','2023-04-14 19:26:16'),(3508,7851,1370,40719,21,19,163,1,30000.00,NULL,'2023-04-14 19:26:00','2023-04-14 19:26:16','2023-04-14 19:26:16'),(3509,7851,1371,40719,21,19,483,2,30000.00,NULL,'2023-04-14 19:26:16','2023-04-14 19:26:16',NULL),(3510,7851,1371,40719,21,19,163,1,30000.00,NULL,'2023-04-14 19:26:16','2023-04-14 19:26:16',NULL),(3511,7851,1372,40719,21,19,163,1,50000.00,NULL,'2023-04-14 19:30:05','2023-04-14 19:30:44','2023-04-14 19:30:44'),(3512,7851,1372,40719,21,19,482,2,50000.00,NULL,'2023-04-14 19:30:05','2023-04-14 19:30:44','2023-04-14 19:30:44'),(3513,7851,1373,40719,21,19,163,2,50000.00,NULL,'2023-04-14 19:33:02','2023-04-14 19:33:02',NULL),(3514,7851,1373,40719,21,19,482,1,50000.00,NULL,'2023-04-14 19:33:02','2023-04-14 19:33:02',NULL),(3515,7851,1374,40719,21,19,482,2,49.06,NULL,'2023-04-14 19:43:05','2023-04-14 19:43:05',NULL),(3516,7851,1374,40719,21,19,557,1,49.06,NULL,'2023-04-14 19:43:05','2023-04-14 19:43:05',NULL),(3517,7851,1375,40719,21,19,136,1,5.07,NULL,'2023-04-14 19:44:48','2023-04-14 19:48:01','2023-04-14 19:48:01'),(3518,7851,1375,40719,21,19,482,2,5.07,NULL,'2023-04-14 19:44:48','2023-04-14 19:48:01','2023-04-14 19:48:01'),(3519,7851,1376,40719,21,19,136,2,5.07,NULL,'2023-04-14 19:48:01','2023-04-14 19:48:39','2023-04-14 19:48:39'),(3520,7851,1376,40719,21,19,482,1,5.07,NULL,'2023-04-14 19:48:01','2023-04-14 19:48:39','2023-04-14 19:48:39'),(3521,7851,1377,40719,21,19,136,1,5.07,NULL,'2023-04-14 19:48:39','2023-04-14 19:50:09','2023-04-14 19:50:09'),(3522,7851,1377,40719,21,19,482,2,5.07,NULL,'2023-04-14 19:48:39','2023-04-14 19:50:09','2023-04-14 19:50:09'),(3523,7851,1378,40719,21,19,136,2,25.07,NULL,'2023-04-14 19:50:09','2023-04-14 19:50:45','2023-04-14 19:50:45'),(3524,7851,1378,40719,21,19,482,1,25.07,NULL,'2023-04-14 19:50:09','2023-04-14 19:50:45','2023-04-14 19:50:45'),(3525,7851,1379,40719,21,19,136,2,44.07,NULL,'2023-04-14 19:50:45','2023-04-14 19:51:25','2023-04-14 19:51:25');
INSERT INTO `balance_libro_details` VALUES (3526,7851,1379,40719,21,19,482,1,44.07,NULL,'2023-04-14 19:50:45','2023-04-14 19:51:25','2023-04-14 19:51:25'),(3527,7851,1380,40719,21,19,136,2,44.00,NULL,'2023-04-14 19:51:25','2023-04-14 19:51:47','2023-04-14 19:51:47'),(3528,7851,1380,40719,21,19,482,1,44.00,NULL,'2023-04-14 19:51:25','2023-04-14 19:51:47','2023-04-14 19:51:47'),(3529,7851,1381,40719,21,19,136,2,43.99,NULL,'2023-04-14 19:51:47','2023-04-14 19:52:13','2023-04-14 19:52:13'),(3530,7851,1381,40719,21,19,482,1,43.99,NULL,'2023-04-14 19:51:47','2023-04-14 19:52:13','2023-04-14 19:52:13'),(3531,7851,1382,40719,21,19,136,2,43.99,NULL,'2023-04-14 19:52:13','2023-04-14 19:52:13',NULL),(3532,7851,1382,40719,21,19,482,1,43.99,NULL,'2023-04-14 19:52:13','2023-04-14 19:52:13',NULL),(3533,7851,1383,40719,21,3,120,1,1435.07,NULL,'2023-04-21 17:37:12','2023-04-21 17:37:12',NULL),(3534,7851,1383,40719,21,3,68,1,387.47,NULL,'2023-04-21 17:37:12','2023-04-21 17:37:12',NULL),(3535,7851,1383,40719,21,3,57,2,1822.54,NULL,'2023-04-21 17:37:12','2023-04-21 17:37:12',NULL),(3536,7851,1384,40719,21,3,120,1,13830.54,NULL,'2023-04-21 17:39:30','2023-04-21 17:39:30',NULL),(3537,7851,1384,40719,21,3,68,1,3734.25,NULL,'2023-04-21 17:39:30','2023-04-21 17:39:30',NULL),(3538,7851,1384,40719,21,3,120,1,689.00,NULL,'2023-04-21 17:39:30','2023-04-21 17:39:30',NULL),(3539,7851,1384,40719,21,3,68,1,144.69,NULL,'2023-04-21 17:39:30','2023-04-21 17:39:30',NULL),(3540,7851,1384,40719,21,3,221,1,702.15,NULL,'2023-04-21 17:39:30','2023-04-21 17:39:30',NULL),(3541,7851,1384,40719,21,3,237,1,435.59,NULL,'2023-04-21 17:39:30','2023-04-21 17:39:30',NULL),(3542,7851,1384,40719,21,3,57,2,19536.22,NULL,'2023-04-21 17:39:30','2023-04-21 17:39:30',NULL),(3543,7851,1385,40719,21,3,507,1,5515.21,NULL,'2023-04-21 17:41:04','2023-04-21 17:50:55','2023-04-21 17:50:55'),(3544,7851,1385,40719,21,3,68,1,1158.19,NULL,'2023-04-21 17:41:04','2023-04-21 17:50:55','2023-04-21 17:50:55'),(3545,7851,1385,40719,21,3,507,1,818.79,NULL,'2023-04-21 17:41:04','2023-04-21 17:50:55','2023-04-21 17:50:55'),(3546,7851,1385,40719,21,3,57,2,7492.19,NULL,'2023-04-21 17:41:04','2023-04-21 17:50:55','2023-04-21 17:50:55'),(3547,7851,1386,40719,21,3,520,1,15303.15,NULL,'2023-04-21 17:42:10','2023-04-21 17:42:10',NULL),(3548,7851,1386,40719,21,3,68,1,3213.66,NULL,'2023-04-21 17:42:10','2023-04-21 17:42:10',NULL),(3549,7851,1386,40719,21,3,221,1,1483.19,NULL,'2023-04-21 17:42:10','2023-04-21 17:42:10',NULL),(3550,7851,1386,40719,21,3,57,2,20000.00,NULL,'2023-04-21 17:42:10','2023-04-21 17:42:10',NULL),(3551,7851,1387,40719,21,3,520,1,14473.39,NULL,'2023-04-21 17:49:13','2023-04-21 17:49:13',NULL),(3552,7851,1387,40719,21,3,68,1,3039.41,NULL,'2023-04-21 17:49:13','2023-04-21 17:49:13',NULL),(3553,7851,1387,40719,21,3,221,1,1487.20,NULL,'2023-04-21 17:49:13','2023-04-21 17:49:13',NULL),(3554,7851,1387,40719,21,3,57,2,19000.00,NULL,'2023-04-21 17:49:13','2023-04-21 17:49:13',NULL),(3555,7851,1388,40719,21,3,520,1,18286.75,NULL,'2023-04-21 17:49:55','2023-04-21 17:49:55',NULL),(3556,7851,1388,40719,21,3,68,1,3840.22,NULL,'2023-04-21 17:49:55','2023-04-21 17:49:55',NULL),(3557,7851,1388,40719,21,3,221,1,1879.04,NULL,'2023-04-21 17:49:55','2023-04-21 17:49:55',NULL),(3558,7851,1388,40719,21,3,57,2,24006.01,NULL,'2023-04-21 17:49:55','2023-04-21 17:49:55',NULL),(3559,7851,1389,40719,21,3,520,1,9742.97,NULL,'2023-04-21 17:50:31','2023-04-21 17:50:31',NULL),(3560,7851,1389,40719,21,3,68,1,2046.02,NULL,'2023-04-21 17:50:31','2023-04-21 17:50:31',NULL),(3561,7851,1389,40719,21,3,221,1,711.00,NULL,'2023-04-21 17:50:31','2023-04-21 17:50:31',NULL),(3562,7851,1389,40719,21,3,57,2,12499.99,NULL,'2023-04-21 17:50:31','2023-04-21 17:50:31',NULL),(3563,7851,1390,40719,21,3,507,1,5515.21,NULL,'2023-04-21 17:50:55','2023-04-21 17:50:55',NULL),(3564,7851,1390,40719,21,3,68,1,1158.19,NULL,'2023-04-21 17:50:55','2023-04-21 17:50:55',NULL),(3565,7851,1390,40719,21,3,507,1,818.79,NULL,'2023-04-21 17:50:55','2023-04-21 17:50:55',NULL);
INSERT INTO `balance_libro_details` VALUES (3566,7851,1390,40719,21,3,57,2,7492.19,NULL,'2023-04-21 17:50:55','2023-04-21 17:50:55',NULL),(3567,7851,1391,40719,21,3,554,1,5318.04,NULL,'2023-04-21 17:52:12','2023-04-21 17:52:12',NULL),(3568,7851,1391,40719,21,3,68,1,1116.79,NULL,'2023-04-21 17:52:12','2023-04-21 17:52:12',NULL),(3569,7851,1391,40719,21,3,221,1,565.17,NULL,'2023-04-21 17:52:12','2023-04-21 17:52:12',NULL),(3570,7851,1391,40719,21,3,57,2,7000.00,NULL,'2023-04-21 17:52:12','2023-04-21 17:52:12',NULL),(3571,7851,1392,40719,21,3,554,1,3305.85,NULL,'2023-04-21 17:53:09','2023-04-21 17:53:09',NULL),(3572,7851,1392,40719,21,3,68,1,694.23,NULL,'2023-04-21 17:53:09','2023-04-21 17:53:09',NULL),(3573,7851,1392,40719,21,3,57,2,4000.08,NULL,'2023-04-21 17:53:09','2023-04-21 17:53:09',NULL),(3574,7851,1393,40719,21,21,57,1,4000.08,NULL,'2023-04-21 17:55:54','2023-04-21 17:55:54',NULL),(3575,7851,1393,40719,21,21,488,2,4000.08,NULL,'2023-04-21 17:55:54','2023-04-21 17:55:54',NULL),(3576,7851,1394,40719,21,21,57,1,7000.00,NULL,'2023-04-21 17:57:03','2023-04-21 17:57:03',NULL),(3577,7851,1394,40719,21,21,488,2,7000.00,NULL,'2023-04-21 17:57:03','2023-04-21 17:57:03',NULL),(3578,7851,1395,40719,21,21,57,1,12499.99,NULL,'2023-04-21 18:04:31','2023-04-21 18:04:31',NULL),(3579,7851,1395,40719,21,21,563,2,10000.00,NULL,'2023-04-21 18:04:31','2023-04-21 18:04:31',NULL),(3580,7851,1395,40719,21,21,488,2,2499.99,NULL,'2023-04-21 18:04:31','2023-04-21 18:04:31',NULL),(3581,7851,1396,40719,21,21,57,1,24006.01,NULL,'2023-04-21 18:05:58','2023-04-21 18:05:58',NULL),(3582,7851,1396,40719,21,21,484,2,24006.01,NULL,'2023-04-21 18:05:58','2023-04-21 18:05:58',NULL),(3583,7851,1397,40719,21,21,57,1,19000.00,NULL,'2023-04-21 18:07:12','2023-04-21 18:07:12',NULL),(3584,7851,1397,40719,21,21,563,2,10000.00,NULL,'2023-04-21 18:07:12','2023-04-21 18:07:12',NULL),(3585,7851,1397,40719,21,21,484,2,9000.00,NULL,'2023-04-21 18:07:12','2023-04-21 18:07:12',NULL),(3586,7851,1398,40719,21,21,57,1,20000.00,NULL,'2023-04-21 18:08:44','2023-04-21 18:08:44',NULL),(3587,7851,1398,40719,21,21,563,2,20000.00,NULL,'2023-04-21 18:08:44','2023-04-21 18:08:44',NULL),(3588,7851,1399,40719,21,21,57,1,7492.19,NULL,'2023-04-21 18:09:41','2023-04-21 18:09:41',NULL),(3589,7851,1399,40719,21,21,552,2,7492.19,NULL,'2023-04-21 18:09:41','2023-04-21 18:09:41',NULL),(3590,7851,1400,40719,21,21,57,1,19536.22,NULL,'2023-04-21 18:10:44','2023-04-21 18:10:44',NULL),(3591,7851,1400,40719,21,21,163,2,19536.22,NULL,'2023-04-21 18:10:44','2023-04-21 18:10:44',NULL),(3592,7851,1401,40719,21,21,57,1,1822.54,NULL,'2023-04-21 18:11:26','2023-04-21 18:11:26',NULL),(3593,7851,1401,40719,21,21,163,2,1822.54,NULL,'2023-04-21 18:11:26','2023-04-21 18:11:26',NULL),(3594,7851,1402,40719,21,3,217,1,2214.88,NULL,'2023-04-21 18:12:57','2023-04-21 18:12:57',NULL),(3595,7851,1402,40719,21,3,68,1,465.12,NULL,'2023-04-21 18:12:57','2023-04-21 18:12:57',NULL),(3596,7851,1402,40719,21,3,57,2,2680.00,NULL,'2023-04-21 18:12:57','2023-04-21 18:12:57',NULL),(3597,7851,1403,40719,21,21,57,1,2680.00,NULL,'2023-04-21 18:14:55','2023-05-02 19:58:39','2023-05-02 19:58:39'),(3598,7851,1403,40719,21,21,484,2,2680.00,NULL,'2023-04-21 18:14:55','2023-05-02 19:58:39','2023-05-02 19:58:39'),(3599,7851,1404,40719,21,3,554,1,1773.85,NULL,'2023-04-30 19:32:57','2023-04-30 19:32:57',NULL),(3600,7851,1404,40719,21,3,68,1,372.51,NULL,'2023-04-30 19:32:57','2023-04-30 19:32:57',NULL),(3601,7851,1404,40719,21,3,221,1,2.64,NULL,'2023-04-30 19:32:57','2023-04-30 19:32:57',NULL),(3602,7851,1404,40719,21,3,57,2,2149.00,NULL,'2023-04-30 19:32:57','2023-04-30 19:32:57',NULL),(3603,7851,1405,40719,21,3,554,1,1340.09,NULL,'2023-04-30 19:35:02','2023-04-30 19:35:02',NULL),(3604,7851,1405,40719,21,3,68,1,281.42,NULL,'2023-04-30 19:35:02','2023-04-30 19:35:02',NULL),(3605,7851,1405,40719,21,3,221,1,378.49,NULL,'2023-04-30 19:35:02','2023-04-30 19:35:02',NULL),(3606,7851,1405,40719,21,3,57,2,2000.00,NULL,'2023-04-30 19:35:02','2023-04-30 19:35:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3607,7851,1406,40719,21,3,507,1,14133.80,NULL,'2023-04-30 19:38:13','2023-04-30 19:38:13',NULL),(3608,7851,1406,40719,21,3,68,1,2968.10,NULL,'2023-04-30 19:38:13','2023-04-30 19:38:13',NULL),(3609,7851,1406,40719,21,3,57,2,17101.90,NULL,'2023-04-30 19:38:13','2023-04-30 19:38:13',NULL),(3610,7851,1407,40719,21,3,507,1,11293.31,NULL,'2023-04-30 19:38:47','2023-04-30 19:38:47',NULL),(3611,7851,1407,40719,21,3,68,1,2371.60,NULL,'2023-04-30 19:38:47','2023-04-30 19:38:47',NULL),(3612,7851,1407,40719,21,3,57,2,13664.91,NULL,'2023-04-30 19:38:47','2023-04-30 19:38:47',NULL),(3613,7851,1408,40719,21,3,507,1,6246.91,NULL,'2023-04-30 19:39:44','2023-04-30 19:39:44',NULL),(3614,7851,1408,40719,21,3,68,1,1311.85,NULL,'2023-04-30 19:39:44','2023-04-30 19:39:44',NULL),(3615,7851,1408,40719,21,3,507,1,446.15,NULL,'2023-04-30 19:39:44','2023-04-30 19:39:44',NULL),(3616,7851,1408,40719,21,3,57,2,8004.91,NULL,'2023-04-30 19:39:44','2023-04-30 19:39:44',NULL),(3617,7851,1409,40719,21,2,96,2,4575.46,NULL,'2023-04-30 19:41:38','2023-04-30 20:58:30','2023-04-30 20:58:30'),(3618,7851,1409,40719,21,2,67,2,960.85,NULL,'2023-04-30 19:41:38','2023-04-30 20:58:30','2023-04-30 20:58:30'),(3619,7851,1409,40719,21,2,221,2,463.74,NULL,'2023-04-30 19:41:38','2023-04-30 20:58:30','2023-04-30 20:58:30'),(3620,7851,1409,40719,21,2,13,1,6000.05,NULL,'2023-04-30 19:41:38','2023-04-30 20:58:30','2023-04-30 20:58:30'),(3621,7851,1410,40719,21,2,96,2,17598.63,NULL,'2023-04-30 19:42:59','2023-04-30 20:58:26','2023-04-30 20:58:26'),(3622,7851,1410,40719,21,2,67,2,3695.71,NULL,'2023-04-30 19:42:59','2023-04-30 20:58:26','2023-04-30 20:58:26'),(3623,7851,1410,40719,21,2,221,2,1705.67,NULL,'2023-04-30 19:42:59','2023-04-30 20:58:26','2023-04-30 20:58:26'),(3624,7851,1410,40719,21,2,13,1,23000.01,NULL,'2023-04-30 19:42:59','2023-04-30 20:58:26','2023-04-30 20:58:26'),(3625,7851,1411,40719,21,2,96,2,11652.38,NULL,'2023-04-30 19:43:45','2023-04-30 20:57:19','2023-04-30 20:57:19'),(3626,7851,1411,40719,21,2,67,2,2447.00,NULL,'2023-04-30 19:43:45','2023-04-30 20:57:19','2023-04-30 20:57:19'),(3627,7851,1411,40719,21,2,221,2,910.27,NULL,'2023-04-30 19:43:45','2023-04-30 20:57:19','2023-04-30 20:57:19'),(3628,7851,1411,40719,21,2,13,1,15009.65,NULL,'2023-04-30 19:43:45','2023-04-30 20:57:19','2023-04-30 20:57:19'),(3629,7851,1412,40719,21,2,96,2,6715.42,NULL,'2023-04-30 19:44:25','2023-04-30 20:58:17','2023-04-30 20:58:17'),(3630,7851,1412,40719,21,2,67,2,1410.24,NULL,'2023-04-30 19:44:25','2023-04-30 20:58:17','2023-04-30 20:58:17'),(3631,7851,1412,40719,21,2,221,2,674.34,NULL,'2023-04-30 19:44:25','2023-04-30 20:58:17','2023-04-30 20:58:17'),(3632,7851,1412,40719,21,2,13,1,8800.00,NULL,'2023-04-30 19:44:25','2023-04-30 20:58:17','2023-04-30 20:58:17'),(3633,7851,1413,40719,21,2,96,2,1156.20,NULL,'2023-04-30 19:45:38','2023-04-30 20:57:05','2023-04-30 20:57:05'),(3634,7851,1413,40719,21,2,67,2,242.80,NULL,'2023-04-30 19:45:38','2023-04-30 20:57:05','2023-04-30 20:57:05'),(3635,7851,1413,40719,21,2,13,1,1399.00,NULL,'2023-04-30 19:45:38','2023-04-30 20:57:05','2023-04-30 20:57:05'),(3636,7851,1414,40719,21,2,96,2,2191.55,NULL,'2023-04-30 20:55:17','2023-04-30 20:56:55','2023-04-30 20:56:55'),(3637,7851,1414,40719,21,2,67,2,460.23,NULL,'2023-04-30 20:55:17','2023-04-30 20:56:55','2023-04-30 20:56:55'),(3638,7851,1414,40719,21,2,13,1,2651.78,NULL,'2023-04-30 20:55:17','2023-04-30 20:56:55','2023-04-30 20:56:55'),(3639,7851,1415,40719,21,2,96,2,4958.68,NULL,'2023-04-30 20:56:31','2023-04-30 20:57:41','2023-04-30 20:57:41'),(3640,7851,1415,40719,21,2,67,2,1041.32,NULL,'2023-04-30 20:56:31','2023-04-30 20:57:41','2023-04-30 20:57:41'),(3641,7851,1415,40719,21,2,13,1,6000.00,NULL,'2023-04-30 20:56:31','2023-04-30 20:57:41','2023-04-30 20:57:41'),(3642,7851,1416,40719,21,2,96,2,2191.55,NULL,'2023-04-30 20:56:55','2023-04-30 20:57:45','2023-04-30 20:57:45'),(3643,7851,1416,40719,21,2,67,2,460.23,NULL,'2023-04-30 20:56:55','2023-04-30 20:57:45','2023-04-30 20:57:45');
INSERT INTO `balance_libro_details` VALUES (3644,7851,1416,40719,21,2,13,1,2651.78,NULL,'2023-04-30 20:56:55','2023-04-30 20:57:45','2023-04-30 20:57:45'),(3645,7851,1417,40719,21,2,96,2,1156.20,NULL,'2023-04-30 20:57:05','2023-04-30 20:58:01','2023-04-30 20:58:01'),(3646,7851,1417,40719,21,2,67,2,242.80,NULL,'2023-04-30 20:57:05','2023-04-30 20:58:01','2023-04-30 20:58:01'),(3647,7851,1417,40719,21,2,13,1,1399.00,NULL,'2023-04-30 20:57:05','2023-04-30 20:58:01','2023-04-30 20:58:01'),(3648,7851,1418,40719,21,2,96,2,11652.38,NULL,'2023-04-30 20:57:19','2023-04-30 20:58:22','2023-04-30 20:58:22'),(3649,7851,1418,40719,21,2,67,2,2447.00,NULL,'2023-04-30 20:57:19','2023-04-30 20:58:22','2023-04-30 20:58:22'),(3650,7851,1418,40719,21,2,221,2,910.27,NULL,'2023-04-30 20:57:19','2023-04-30 20:58:22','2023-04-30 20:58:22'),(3651,7851,1418,40719,21,2,13,1,15009.65,NULL,'2023-04-30 20:57:19','2023-04-30 20:58:22','2023-04-30 20:58:22'),(3652,7851,1419,40719,21,3,520,1,11652.38,NULL,'2023-04-30 20:59:49','2023-04-30 20:59:49',NULL),(3653,7851,1419,40719,21,3,68,1,2447.00,NULL,'2023-04-30 20:59:49','2023-04-30 20:59:49',NULL),(3654,7851,1419,40719,21,3,221,1,910.27,NULL,'2023-04-30 20:59:49','2023-04-30 20:59:49',NULL),(3655,7851,1419,40719,21,3,57,2,15009.65,NULL,'2023-04-30 20:59:49','2023-04-30 20:59:49',NULL),(3656,7851,1420,40719,21,3,515,1,6715.41,NULL,'2023-04-30 21:00:41','2023-04-30 21:00:41',NULL),(3657,7851,1420,40719,21,3,68,1,1410.24,NULL,'2023-04-30 21:00:41','2023-04-30 21:00:41',NULL),(3658,7851,1420,40719,21,3,221,1,674.34,NULL,'2023-04-30 21:00:41','2023-04-30 21:00:41',NULL),(3659,7851,1420,40719,21,3,57,2,8799.99,NULL,'2023-04-30 21:00:41','2023-04-30 21:00:41',NULL),(3660,7851,1421,40719,21,3,507,1,1156.20,NULL,'2023-04-30 21:06:03','2023-04-30 21:06:03',NULL),(3661,7851,1421,40719,21,3,68,1,242.80,NULL,'2023-04-30 21:06:03','2023-04-30 21:06:03',NULL),(3662,7851,1421,40719,21,3,57,2,1399.00,NULL,'2023-04-30 21:06:03','2023-04-30 21:06:03',NULL),(3663,7851,1422,40719,21,3,507,1,2191.55,NULL,'2023-04-30 21:07:10','2023-04-30 21:07:10',NULL),(3664,7851,1422,40719,21,3,68,1,460.23,NULL,'2023-04-30 21:07:10','2023-04-30 21:07:10',NULL),(3665,7851,1422,40719,21,3,57,2,2651.78,NULL,'2023-04-30 21:07:10','2023-04-30 21:07:10',NULL),(3666,7851,1423,40719,21,3,507,1,4958.68,NULL,'2023-04-30 21:07:36','2023-04-30 21:07:36',NULL),(3667,7851,1423,40719,21,3,68,1,1041.32,NULL,'2023-04-30 21:07:36','2023-04-30 21:07:36',NULL),(3668,7851,1423,40719,21,3,57,2,6000.00,NULL,'2023-04-30 21:07:36','2023-04-30 21:07:36',NULL),(3669,7851,1424,40719,21,3,554,1,4575.46,NULL,'2023-04-30 21:11:26','2023-04-30 21:11:26',NULL),(3670,7851,1424,40719,21,3,68,1,960.85,NULL,'2023-04-30 21:11:26','2023-04-30 21:11:26',NULL),(3671,7851,1424,40719,21,3,221,1,463.74,NULL,'2023-04-30 21:11:26','2023-04-30 21:11:26',NULL),(3672,7851,1424,40719,21,3,57,2,6000.05,NULL,'2023-04-30 21:11:26','2023-04-30 21:11:26',NULL),(3673,7851,1425,40719,21,20,564,2,25000.00,NULL,'2023-05-01 21:15:49','2023-05-01 21:15:49',NULL),(3674,7851,1425,40719,21,20,563,1,25000.00,NULL,'2023-05-01 21:15:49','2023-05-01 21:15:49',NULL),(3675,7851,1426,40719,21,20,563,1,25000.00,NULL,'2023-05-01 21:16:35','2023-05-01 21:16:35',NULL),(3676,7851,1426,40719,21,20,564,2,25000.00,NULL,'2023-05-01 21:16:35','2023-05-01 21:16:35',NULL),(3677,7851,1427,40719,21,20,563,1,25000.00,NULL,'2023-05-01 21:17:39','2023-05-01 21:17:39',NULL),(3678,7851,1427,40719,21,20,564,2,25000.00,NULL,'2023-05-01 21:17:39','2023-05-01 21:17:39',NULL),(3679,7851,1428,40719,21,21,565,1,5000.00,NULL,'2023-05-01 21:32:54','2023-05-01 21:32:54',NULL),(3680,7851,1428,40719,21,21,563,2,5000.00,NULL,'2023-05-01 21:32:54','2023-05-01 21:32:54',NULL),(3681,7851,1429,40719,21,21,565,1,5000.00,NULL,'2023-05-01 21:33:34','2023-05-01 21:33:34',NULL),(3682,7851,1429,40719,21,21,563,2,5000.00,NULL,'2023-05-01 21:33:34','2023-05-01 21:33:34',NULL),(3683,7851,1430,40719,21,21,565,1,5000.00,NULL,'2023-05-01 21:35:26','2023-05-01 21:35:26',NULL);
INSERT INTO `balance_libro_details` VALUES (3684,7851,1430,40719,21,21,563,2,5000.00,NULL,'2023-05-01 21:35:26','2023-05-01 21:35:26',NULL),(3685,7851,1431,40719,21,21,57,1,8799.99,NULL,'2023-05-01 21:38:17','2023-05-01 21:38:17',NULL),(3686,7851,1431,40719,21,21,563,2,8799.99,NULL,'2023-05-01 21:38:17','2023-05-01 21:38:17',NULL),(3687,7851,1432,40719,21,21,57,1,13664.91,NULL,'2023-05-01 21:39:45','2023-05-01 21:39:45',NULL),(3688,7851,1432,40719,21,21,493,2,13664.91,NULL,'2023-05-01 21:39:45','2023-05-01 21:39:45',NULL),(3689,7851,1433,40719,21,21,57,1,17101.90,NULL,'2023-05-01 21:46:30','2023-05-01 21:46:30',NULL),(3690,7851,1433,40719,21,21,493,2,17101.90,NULL,'2023-05-01 21:46:30','2023-05-01 21:46:30',NULL),(3691,7851,1434,40719,21,21,57,1,2149.00,NULL,'2023-05-01 21:47:07','2023-05-01 21:47:07',NULL),(3692,7851,1434,40719,21,21,488,2,2149.00,NULL,'2023-05-01 21:47:07','2023-05-01 21:47:07',NULL),(3693,7851,1435,40719,21,21,57,1,2000.00,NULL,'2023-05-01 21:47:54','2023-05-01 21:47:54',NULL),(3694,7851,1435,40719,21,21,488,2,2000.00,NULL,'2023-05-01 21:47:54','2023-05-01 21:47:54',NULL),(3695,7851,1436,40719,21,21,57,1,6000.05,NULL,'2023-05-01 21:49:50','2023-05-01 21:50:59','2023-05-01 21:50:59'),(3696,7851,1436,40719,21,21,563,2,6000.05,NULL,'2023-05-01 21:49:50','2023-05-01 21:50:59','2023-05-01 21:50:59'),(3697,7851,1437,40719,21,21,57,1,6000.05,NULL,'2023-05-01 21:52:10','2023-05-01 21:52:10',NULL),(3698,7851,1437,40719,21,21,488,2,6000.05,NULL,'2023-05-01 21:52:10','2023-05-01 21:52:10',NULL),(3699,7851,1438,40719,21,21,57,1,8004.91,NULL,'2023-05-01 21:53:17','2023-05-01 21:53:17',NULL),(3700,7851,1438,40719,21,21,552,2,8004.91,NULL,'2023-05-01 21:53:17','2023-05-01 21:53:17',NULL),(3701,7851,1439,40719,21,3,520,1,17598.63,NULL,'2023-05-01 21:58:41','2023-05-01 21:58:41',NULL),(3702,7851,1439,40719,21,3,68,1,3695.71,NULL,'2023-05-01 21:58:41','2023-05-01 21:58:41',NULL),(3703,7851,1439,40719,21,3,221,1,1705.67,NULL,'2023-05-01 21:58:41','2023-05-01 21:58:41',NULL),(3704,7851,1439,40719,21,3,57,2,23000.01,NULL,'2023-05-01 21:58:41','2023-05-01 21:58:41',NULL),(3705,7851,1440,40719,21,21,57,1,23000.01,NULL,'2023-05-01 22:00:20','2023-05-01 22:00:20',NULL),(3706,7851,1440,40719,21,21,563,2,23000.01,NULL,'2023-05-01 22:00:20','2023-05-01 22:00:20',NULL),(3707,7851,1441,40719,21,21,57,1,15009.65,NULL,'2023-05-01 22:04:56','2023-05-01 22:04:56',NULL),(3708,7851,1441,40719,21,21,484,2,7000.00,NULL,'2023-05-01 22:04:56','2023-05-01 22:04:56',NULL),(3709,7851,1441,40719,21,21,563,2,8009.65,NULL,'2023-05-01 22:04:56','2023-05-01 22:04:56',NULL),(3710,7851,1442,40719,21,21,57,1,2651.78,NULL,'2023-05-01 22:06:16','2023-05-01 22:06:16',NULL),(3711,7851,1442,40719,21,21,493,2,2651.78,NULL,'2023-05-01 22:06:16','2023-05-01 22:06:16',NULL),(3712,7851,1443,40719,21,21,57,1,1399.00,NULL,'2023-05-01 22:07:14','2023-05-01 22:07:14',NULL),(3713,7851,1443,40719,21,21,493,2,1399.00,NULL,'2023-05-01 22:07:14','2023-05-01 22:07:14',NULL),(3714,7851,1444,40719,21,21,57,1,6000.00,NULL,'2023-05-01 22:08:27','2023-05-02 19:25:54','2023-05-02 19:25:54'),(3715,7851,1444,40719,21,21,163,2,6000.00,NULL,'2023-05-01 22:08:27','2023-05-02 19:25:54','2023-05-02 19:25:54'),(3716,7851,1445,40719,21,3,217,1,816819.81,NULL,'2023-05-02 11:21:23','2023-05-18 20:04:59','2023-05-18 20:04:59'),(3717,7851,1445,40719,21,3,68,1,3930.16,NULL,'2023-05-02 11:21:23','2023-05-18 20:04:59','2023-05-18 20:04:59'),(3718,7851,1445,40719,21,3,57,2,820749.97,NULL,'2023-05-02 11:21:23','2023-05-18 20:04:59','2023-05-18 20:04:59'),(3719,7851,1446,40719,21,3,217,1,412.31,NULL,'2023-05-02 11:21:23','2023-05-02 11:21:23',NULL),(3720,7851,1446,40719,21,3,68,1,86.59,NULL,'2023-05-02 11:21:23','2023-05-02 11:21:23',NULL),(3721,7851,1446,40719,21,3,57,2,498.90,NULL,'2023-05-02 11:21:23','2023-05-02 11:21:23',NULL),(3722,7851,1447,40719,21,3,217,1,412.31,NULL,'2023-05-02 11:22:11','2023-05-02 11:22:11',NULL),(3723,7851,1447,40719,21,3,68,1,86.59,NULL,'2023-05-02 11:22:11','2023-05-02 11:22:11',NULL);
INSERT INTO `balance_libro_details` VALUES (3724,7851,1447,40719,21,3,57,2,498.90,NULL,'2023-05-02 11:22:11','2023-05-02 11:22:11',NULL),(3725,7851,1448,40719,20,15,67,1,149829.04,NULL,'2023-05-02 11:24:46','2023-05-02 11:24:46',NULL),(3726,7851,1448,40719,20,15,68,2,65210.74,NULL,'2023-05-02 11:24:46','2023-05-02 11:24:46',NULL),(3727,7851,1448,40719,20,15,353,2,28541.55,NULL,'2023-05-02 11:24:46','2023-05-02 11:24:46',NULL),(3728,7851,1448,40719,20,15,74,2,52895.25,NULL,'2023-05-02 11:24:46','2023-05-02 11:24:46',NULL),(3729,7851,1448,40719,20,15,136,2,3181.50,NULL,'2023-05-02 11:24:46','2023-05-02 11:24:46',NULL),(3730,7851,1449,40719,22,3,482,2,101016.79,NULL,'2023-05-02 11:54:34','2023-05-02 12:49:00','2023-05-02 12:49:00'),(3731,7851,1449,40719,22,3,489,1,101016.79,NULL,'2023-05-02 11:54:34','2023-05-02 12:49:00','2023-05-02 12:49:00'),(3732,7851,1450,40719,22,19,214,2,45258.88,NULL,'2023-05-02 12:48:13','2023-05-02 12:48:13',NULL),(3733,7851,1450,40719,22,19,489,1,45258.88,NULL,'2023-05-02 12:48:13','2023-05-02 12:48:13',NULL),(3734,7851,1451,40719,22,3,482,2,101016.79,NULL,'2023-05-02 12:49:00','2023-05-02 20:38:02','2023-05-02 20:38:02'),(3735,7851,1451,40719,22,3,489,1,101016.79,NULL,'2023-05-02 12:49:00','2023-05-02 20:38:02','2023-05-02 20:38:02'),(3736,7851,1452,40719,22,19,396,2,32916.81,NULL,'2023-05-02 13:05:43','2023-05-02 13:05:43',NULL),(3737,7851,1452,40719,22,19,489,1,32916.81,NULL,'2023-05-02 13:05:43','2023-05-02 13:05:43',NULL),(3738,7851,1453,40719,22,19,157,2,0.39,NULL,'2023-05-02 13:06:38','2023-05-02 13:06:38',NULL),(3739,7851,1453,40719,22,19,489,1,0.39,NULL,'2023-05-02 13:06:38','2023-05-02 13:06:38',NULL),(3740,7851,1454,40719,22,19,212,2,8194.02,NULL,'2023-05-02 13:07:29','2023-05-02 13:07:29',NULL),(3741,7851,1454,40719,22,19,489,1,8194.02,NULL,'2023-05-02 13:07:29','2023-05-02 13:07:29',NULL),(3742,7851,1455,40719,22,19,505,2,66557.07,NULL,'2023-05-02 13:08:29','2023-05-02 13:08:29',NULL),(3743,7851,1455,40719,22,19,489,1,66557.07,NULL,'2023-05-02 13:08:29','2023-05-02 13:08:29',NULL),(3744,7851,1456,40719,22,19,509,1,9305.27,NULL,'2023-05-02 13:11:13','2023-05-02 13:11:58','2023-05-02 13:11:58'),(3745,7851,1456,40719,22,19,517,1,1272.64,NULL,'2023-05-02 13:11:13','2023-05-02 13:11:58','2023-05-02 13:11:58'),(3746,7851,1456,40719,22,19,545,1,62.16,NULL,'2023-05-02 13:11:13','2023-05-02 13:11:58','2023-05-02 13:11:58'),(3747,7851,1456,40719,22,19,489,2,10640.07,NULL,'2023-05-02 13:11:13','2023-05-02 13:11:58','2023-05-02 13:11:58'),(3748,7851,1457,40719,22,19,509,1,9305.27,NULL,'2023-05-02 13:11:58','2023-05-02 13:11:58',NULL),(3749,7851,1457,40719,22,19,517,1,1272.64,NULL,'2023-05-02 13:11:58','2023-05-02 13:11:58',NULL),(3750,7851,1457,40719,22,19,489,2,10640.07,NULL,'2023-05-02 13:11:58','2023-05-02 13:11:58',NULL),(3751,7851,1457,40719,22,19,511,1,62.16,NULL,'2023-05-02 13:11:58','2023-05-02 13:11:58',NULL),(3752,7851,1458,40719,21,19,163,2,600000.00,NULL,'2023-05-02 15:25:56','2023-05-02 15:25:56',NULL),(3753,7851,1458,40719,21,19,483,1,600000.00,NULL,'2023-05-02 15:25:56','2023-05-02 15:25:56',NULL),(3754,7851,1459,40719,21,19,566,1,150000.00,NULL,'2023-05-02 15:27:37','2023-05-02 15:27:37',NULL),(3755,7851,1459,40719,21,19,163,2,150000.00,NULL,'2023-05-02 15:27:37','2023-05-02 15:27:37',NULL),(3756,7851,1460,40719,21,19,566,1,100000.00,NULL,'2023-05-02 15:28:09','2023-05-02 15:28:09',NULL),(3757,7851,1460,40719,21,19,163,2,100000.00,NULL,'2023-05-02 15:28:09','2023-05-02 15:28:09',NULL),(3758,7851,1461,40719,21,19,484,1,50000.00,NULL,'2023-05-02 15:34:11','2023-05-02 15:34:11',NULL),(3759,7851,1461,40719,21,19,163,2,50000.00,NULL,'2023-05-02 15:34:11','2023-05-02 15:34:11',NULL),(3760,7851,1462,40719,21,19,163,1,1185992.09,NULL,'2023-05-02 18:28:24','2023-05-02 18:28:24',NULL),(3761,7851,1462,40719,21,19,547,2,1121785.31,NULL,'2023-05-02 18:28:24','2023-05-02 18:28:24',NULL),(3762,7851,1462,40719,21,19,550,2,64206.78,NULL,'2023-05-02 18:28:24','2023-05-02 18:28:24',NULL);
INSERT INTO `balance_libro_details` VALUES (3763,7851,1463,40719,21,19,548,2,51000.00,NULL,'2023-05-02 18:33:29','2023-05-02 18:33:29',NULL),(3764,7851,1463,40719,21,19,547,1,51000.00,NULL,'2023-05-02 18:33:29','2023-05-02 18:33:29',NULL),(3765,7851,1464,40719,21,19,163,1,18710.67,NULL,'2023-05-02 18:47:41','2023-05-02 18:47:41',NULL),(3766,7851,1464,40719,21,19,483,2,18710.67,NULL,'2023-05-02 18:47:41','2023-05-02 18:47:41',NULL),(3767,7851,1465,40719,21,19,163,1,27790.78,NULL,'2023-05-02 18:48:33','2023-05-02 18:48:33',NULL),(3768,7851,1465,40719,21,19,484,2,27790.78,NULL,'2023-05-02 18:48:33','2023-05-02 18:48:33',NULL),(3769,7851,1466,40719,21,19,163,1,400000.00,NULL,'2023-05-02 18:51:13','2023-05-02 18:51:13',NULL),(3770,7851,1466,40719,21,19,483,2,400000.00,NULL,'2023-05-02 18:51:13','2023-05-02 18:51:13',NULL),(3771,7851,1467,40719,21,19,163,1,50000.00,NULL,'2023-05-02 18:52:21','2023-05-02 18:52:21',NULL),(3772,7851,1467,40719,21,19,483,2,50000.00,NULL,'2023-05-02 18:52:21','2023-05-02 18:52:21',NULL),(3773,7851,1468,40719,22,21,565,1,18000.00,NULL,'2023-05-02 18:54:12','2023-05-02 18:54:12',NULL),(3774,7851,1468,40719,22,21,163,2,18000.00,NULL,'2023-05-02 18:54:12','2023-05-02 18:54:12',NULL),(3775,7851,1469,40719,21,19,489,1,40000.00,NULL,'2023-05-02 18:56:13','2023-05-02 18:56:13',NULL),(3776,7851,1469,40719,21,19,163,2,40000.00,NULL,'2023-05-02 18:56:13','2023-05-02 18:56:13',NULL),(3777,7851,1470,40719,21,19,163,2,10000.00,NULL,'2023-05-02 18:57:35','2023-05-02 18:57:35',NULL),(3778,7851,1470,40719,21,19,502,1,10000.00,NULL,'2023-05-02 18:57:35','2023-05-02 18:57:35',NULL),(3779,7851,1471,40719,21,19,163,2,20000.00,NULL,'2023-05-02 18:58:27','2023-05-02 18:58:27',NULL),(3780,7851,1471,40719,21,19,502,1,20000.00,NULL,'2023-05-02 18:58:27','2023-05-02 18:58:27',NULL),(3781,7851,1472,40719,21,10,74,1,50176.26,NULL,'2023-05-02 19:03:23','2023-05-02 19:03:23',NULL),(3782,7851,1472,40719,21,10,163,2,50176.26,NULL,'2023-05-02 19:03:23','2023-05-02 19:03:23',NULL),(3783,7851,1473,40719,21,3,110,1,50400.00,NULL,'2023-05-02 19:04:20','2023-05-02 19:04:20',NULL),(3784,7851,1473,40719,21,3,62,2,50400.00,NULL,'2023-05-02 19:04:20','2023-05-02 19:04:20',NULL),(3785,7851,1474,40719,21,21,163,2,89600.00,NULL,'2023-05-02 19:05:34','2023-05-02 19:06:08','2023-05-02 19:06:08'),(3786,7851,1474,40719,21,21,62,1,89600.00,NULL,'2023-05-02 19:05:34','2023-05-02 19:06:08','2023-05-02 19:06:08'),(3787,7851,1475,40719,21,21,163,2,50400.00,NULL,'2023-05-02 19:06:08','2023-05-02 19:06:08',NULL),(3788,7851,1475,40719,21,21,62,1,50400.00,NULL,'2023-05-02 19:06:08','2023-05-02 19:06:08',NULL),(3789,7851,1476,40719,21,3,491,2,89600.00,NULL,'2023-05-02 19:06:57','2023-05-02 19:06:57',NULL),(3790,7851,1476,40719,21,3,518,1,89600.00,NULL,'2023-05-02 19:06:57','2023-05-02 19:06:57',NULL),(3791,7851,1477,40719,21,21,163,2,89600.00,NULL,'2023-05-02 19:07:29','2023-05-02 19:07:29',NULL),(3792,7851,1477,40719,21,21,491,1,89600.00,NULL,'2023-05-02 19:07:29','2023-05-02 19:07:29',NULL),(3793,7851,1478,40719,21,21,489,1,173.49,NULL,'2023-05-02 19:12:20','2023-05-02 19:12:20',NULL),(3794,7851,1478,40719,21,21,163,2,173.49,NULL,'2023-05-02 19:12:20','2023-05-02 19:12:20',NULL),(3795,7851,1479,40719,21,21,135,1,930.00,NULL,'2023-05-02 19:13:51','2023-05-02 19:13:51',NULL),(3796,7851,1479,40719,21,21,163,2,930.00,NULL,'2023-05-02 19:13:51','2023-05-02 19:13:51',NULL),(3797,7851,1480,40719,21,21,492,1,1280.00,NULL,'2023-05-02 19:14:33','2023-05-02 19:14:33',NULL),(3798,7851,1480,40719,21,21,163,2,1280.00,NULL,'2023-05-02 19:14:33','2023-05-02 19:14:33',NULL),(3799,7851,1481,40719,21,21,57,1,6000.00,NULL,'2023-05-02 19:26:33','2023-05-02 19:26:33',NULL),(3800,7851,1481,40719,21,21,493,2,6000.00,NULL,'2023-05-02 19:26:33','2023-05-02 19:26:33',NULL),(3801,7851,1482,40719,21,19,136,1,71.39,NULL,'2023-05-02 19:33:21','2023-05-11 02:51:52','2023-05-11 02:51:52'),(3802,7851,1482,40719,21,19,163,2,71.39,NULL,'2023-05-02 19:33:21','2023-05-11 02:51:52','2023-05-11 02:51:52');
INSERT INTO `balance_libro_details` VALUES (3803,7851,1483,40719,21,21,57,1,2680.00,NULL,'2023-05-02 19:59:15','2023-05-02 19:59:15',NULL),(3804,7851,1483,40719,21,21,483,2,2680.00,NULL,'2023-05-02 19:59:15','2023-05-02 19:59:15',NULL),(3805,7851,1484,40719,22,3,482,2,101016.79,NULL,'2023-05-02 20:38:02','2023-05-02 20:38:02',NULL),(3806,7851,1484,40719,22,3,567,1,101016.79,NULL,'2023-05-02 20:38:02','2023-05-02 20:38:02',NULL),(3807,7851,1485,40719,22,19,557,1,228590.00,NULL,'2023-05-02 20:39:45','2023-05-02 20:39:45',NULL),(3808,7851,1485,40719,22,19,566,2,228590.00,NULL,'2023-05-02 20:39:45','2023-05-02 20:39:45',NULL),(3809,7851,1486,40719,22,19,568,1,515.00,NULL,'2023-05-02 20:41:12','2023-05-02 20:41:12',NULL),(3810,7851,1486,40719,22,19,558,2,515.00,NULL,'2023-05-02 20:41:12','2023-05-02 20:41:12',NULL),(3811,7851,1487,40719,22,3,568,2,515.00,NULL,'2023-05-02 20:41:50','2023-05-10 21:10:06','2023-05-10 21:10:06'),(3812,7851,1487,40719,22,3,163,1,515.00,NULL,'2023-05-02 20:41:50','2023-05-10 21:10:06','2023-05-10 21:10:06'),(3813,7851,1488,40719,21,19,163,2,1050.00,NULL,'2023-05-10 18:16:03','2023-05-11 00:47:05','2023-05-11 00:47:05'),(3814,7851,1488,40719,21,19,556,1,1050.00,NULL,'2023-05-10 18:16:03','2023-05-11 00:47:05','2023-05-11 00:47:05'),(3815,7851,1489,40719,22,19,556,1,850.00,NULL,'2023-05-10 18:20:26','2023-05-10 18:20:26',NULL),(3816,7851,1489,40719,22,19,494,2,600.00,NULL,'2023-05-10 18:20:26','2023-05-10 18:20:26',NULL),(3817,7851,1489,40719,22,19,493,2,250.00,NULL,'2023-05-10 18:20:26','2023-05-10 18:20:26',NULL),(3818,7851,1490,40719,22,19,568,2,515.00,NULL,'2023-05-10 21:10:06','2023-05-11 00:45:21','2023-05-11 00:45:21'),(3819,7851,1490,40719,22,19,163,1,515.00,NULL,'2023-05-10 21:10:06','2023-05-11 00:45:21','2023-05-11 00:45:21'),(3820,7851,1491,40719,22,19,483,2,205751.38,NULL,'2023-05-10 23:44:20','2023-05-10 23:44:20',NULL),(3821,7851,1491,40719,22,19,495,1,205751.38,NULL,'2023-05-10 23:44:20','2023-05-10 23:44:20',NULL),(3822,7851,1492,40719,22,19,484,1,50000.00,NULL,'2023-05-11 00:06:25','2023-05-11 00:06:25',NULL),(3823,7851,1492,40719,22,19,163,2,50000.00,NULL,'2023-05-11 00:06:25','2023-05-11 00:06:25',NULL),(3824,7851,1493,40719,22,2,96,2,2129555.08,NULL,'2023-05-11 00:23:52','2023-05-11 00:23:52',NULL),(3825,7851,1493,40719,22,2,67,2,223603.28,NULL,'2023-05-11 00:23:52','2023-05-11 00:23:52',NULL),(3826,7851,1493,40719,22,2,13,1,2353158.36,NULL,'2023-05-11 00:23:52','2023-05-11 00:23:52',NULL),(3827,7851,1494,40719,22,20,13,2,2353158.36,NULL,'2023-05-11 00:40:05','2023-05-11 00:40:05',NULL),(3828,7851,1494,40719,22,20,163,1,2251160.61,NULL,'2023-05-11 00:40:05','2023-05-11 00:40:05',NULL),(3829,7851,1494,40719,22,20,263,1,63886.65,NULL,'2023-05-11 00:40:05','2023-05-11 00:40:05',NULL),(3830,7851,1494,40719,22,20,23,1,38111.10,NULL,'2023-05-11 00:40:05','2023-05-11 00:40:05',NULL),(3831,7851,1495,40719,22,19,568,2,515.00,NULL,'2023-05-11 00:45:21','2023-05-11 00:45:21',NULL),(3832,7851,1495,40719,22,19,444,1,515.00,NULL,'2023-05-11 00:45:21','2023-05-11 00:45:21',NULL),(3833,7851,1496,40719,21,19,163,2,415014.00,NULL,'2023-05-11 00:47:05','2023-05-11 00:47:05',NULL),(3834,7851,1496,40719,21,19,556,1,1050.00,NULL,'2023-05-11 00:47:05','2023-05-11 00:47:05',NULL),(3835,7851,1496,40719,21,19,557,1,415014.00,NULL,'2023-05-11 00:47:05','2023-05-11 00:47:05',NULL),(3836,7851,1496,40719,21,19,558,2,1050.00,NULL,'2023-05-11 00:47:05','2023-05-11 00:47:05',NULL),(3837,7851,1497,40719,22,19,566,1,16741.48,NULL,'2023-05-11 01:10:33','2023-05-11 01:11:24','2023-05-11 01:11:24'),(3838,7851,1497,40719,22,19,163,2,16741.48,NULL,'2023-05-11 01:10:33','2023-05-11 01:11:24','2023-05-11 01:11:24'),(3839,7851,1498,40719,22,19,566,1,16741.48,NULL,'2023-05-11 01:11:24','2023-05-11 01:11:24',NULL),(3840,7851,1498,40719,22,19,163,2,16741.48,NULL,'2023-05-11 01:11:24','2023-05-11 01:11:24',NULL),(3841,7851,1499,40719,22,3,569,1,37576.55,NULL,'2023-05-11 01:14:37','2023-05-11 01:14:37',NULL);
INSERT INTO `balance_libro_details` VALUES (3842,7851,1499,40719,22,3,566,2,37576.55,NULL,'2023-05-11 01:14:37','2023-05-11 01:14:37',NULL),(3843,7851,1500,40719,22,19,566,1,400000.00,NULL,'2023-05-11 01:21:10','2023-05-11 01:21:10',NULL),(3844,7851,1500,40719,22,19,163,2,400000.00,NULL,'2023-05-11 01:21:10','2023-05-11 01:21:10',NULL),(3845,7851,1501,40719,22,21,163,2,209229.84,NULL,'2023-05-11 01:28:42','2023-05-11 02:50:41','2023-05-11 02:50:41'),(3846,7851,1501,40719,22,21,493,1,209229.84,NULL,'2023-05-11 01:28:42','2023-05-11 02:50:41','2023-05-11 02:50:41'),(3847,7851,1502,40719,22,21,163,1,296040.56,NULL,'2023-05-11 01:29:23','2023-05-11 02:42:59','2023-05-11 02:42:59'),(3848,7851,1502,40719,22,21,494,2,296040.56,NULL,'2023-05-11 01:29:23','2023-05-11 02:42:59','2023-05-11 02:42:59'),(3849,7851,1503,40719,22,21,163,1,210000.00,NULL,'2023-05-11 01:34:47','2023-05-11 01:34:47',NULL),(3850,7851,1503,40719,22,21,483,2,210000.00,NULL,'2023-05-11 01:34:47','2023-05-11 01:34:47',NULL),(3851,7851,1504,40719,22,21,163,2,35000.00,NULL,'2023-05-11 02:09:24','2023-05-11 02:09:24',NULL),(3852,7851,1504,40719,22,21,518,1,35000.00,NULL,'2023-05-11 02:09:24','2023-05-11 02:09:24',NULL),(3853,7851,1505,40719,22,3,63,2,33583.15,NULL,'2023-05-11 02:10:28','2023-05-11 02:10:28',NULL),(3854,7851,1505,40719,22,3,191,1,33583.15,NULL,'2023-05-11 02:10:28','2023-05-11 02:10:28',NULL),(3855,7851,1506,40719,22,21,163,2,33583.15,NULL,'2023-05-11 02:11:03','2023-05-11 02:11:03',NULL),(3856,7851,1506,40719,22,21,63,1,33583.15,NULL,'2023-05-11 02:11:03','2023-05-11 02:11:03',NULL),(3857,7851,1507,40719,22,19,163,2,600000.00,NULL,'2023-05-11 02:28:02','2023-05-11 02:28:02',NULL),(3858,7851,1507,40719,22,19,483,1,600000.00,NULL,'2023-05-11 02:28:02','2023-05-11 02:28:02',NULL),(3859,7851,1508,40719,22,3,567,1,500000.00,NULL,'2023-05-11 02:31:40','2023-05-11 02:31:40',NULL),(3860,7851,1508,40719,22,3,163,2,500000.00,NULL,'2023-05-11 02:31:40','2023-05-11 02:31:40',NULL),(3861,7851,1509,40719,22,3,163,2,500000.00,NULL,'2023-05-11 02:32:21','2023-05-11 02:32:21',NULL),(3862,7851,1509,40719,22,3,485,1,500000.00,NULL,'2023-05-11 02:32:21','2023-05-11 02:32:21',NULL),(3863,7851,1510,40719,22,20,545,2,4.70,NULL,'2023-05-11 02:33:21','2023-05-11 02:33:21',NULL),(3864,7851,1510,40719,22,20,163,1,4.70,NULL,'2023-05-11 02:33:21','2023-05-11 02:33:21',NULL),(3865,7851,1511,40719,22,19,163,1,7500.00,NULL,'2023-05-11 02:36:39','2023-05-11 02:36:53','2023-05-11 02:36:53'),(3866,7851,1511,40719,22,19,165,2,7500.00,NULL,'2023-05-11 02:36:39','2023-05-11 02:36:53','2023-05-11 02:36:53'),(3867,7851,1511,40719,22,19,165,1,7500.00,NULL,'2023-05-11 02:36:39','2023-05-11 02:36:53','2023-05-11 02:36:53'),(3868,7851,1511,40719,22,19,163,2,7500.00,NULL,'2023-05-11 02:36:39','2023-05-11 02:36:53','2023-05-11 02:36:53'),(3869,7851,1512,40719,22,19,163,1,7500.00,NULL,'2023-05-11 02:36:53','2023-05-11 02:37:49','2023-05-11 02:37:49'),(3870,7851,1512,40719,22,19,165,2,7500.00,NULL,'2023-05-11 02:36:53','2023-05-11 02:37:49','2023-05-11 02:37:49'),(3871,7851,1513,40719,22,19,163,2,7500.00,NULL,'2023-05-11 02:37:34','2023-05-11 02:37:34',NULL),(3872,7851,1513,40719,22,19,165,1,7500.00,NULL,'2023-05-11 02:37:34','2023-05-11 02:37:34',NULL),(3873,7851,1514,40719,22,19,163,1,7500.00,NULL,'2023-05-11 02:37:49','2023-05-11 02:37:49',NULL),(3874,7851,1514,40719,22,19,165,2,7500.00,NULL,'2023-05-11 02:37:49','2023-05-11 02:37:49',NULL),(3875,7851,1515,40719,22,21,163,2,296040.56,NULL,'2023-05-11 02:42:59','2023-05-11 02:42:59',NULL),(3876,7851,1515,40719,22,21,494,1,296040.56,NULL,'2023-05-11 02:42:59','2023-05-11 02:42:59',NULL),(3877,7851,1516,40719,22,21,163,2,219204.84,NULL,'2023-05-11 02:50:41','2023-05-11 02:50:41',NULL),(3878,7851,1516,40719,22,21,493,1,219204.84,NULL,'2023-05-11 02:50:41','2023-05-11 02:50:41',NULL),(3879,7851,1517,40719,21,19,136,1,0.02,NULL,'2023-05-11 02:51:52','2023-05-11 02:51:52',NULL),(3880,7851,1517,40719,21,19,163,2,0.02,NULL,'2023-05-11 02:51:52','2023-05-11 02:51:52',NULL);
INSERT INTO `balance_libro_details` VALUES (3881,7851,1518,40719,22,19,163,2,210000.00,NULL,'2023-05-11 12:59:20','2023-05-11 12:59:20',NULL),(3882,7851,1518,40719,22,19,5,1,210000.00,NULL,'2023-05-11 12:59:20','2023-05-11 12:59:20',NULL),(3883,7851,1519,40719,21,3,554,1,2289.43,NULL,'2023-05-18 19:26:55','2023-05-18 19:26:55',NULL),(3884,7851,1519,40719,21,3,68,1,480.78,NULL,'2023-05-18 19:26:55','2023-05-18 19:26:55',NULL),(3885,7851,1519,40719,21,3,221,1,229.90,NULL,'2023-05-18 19:26:55','2023-05-18 19:26:55',NULL),(3886,7851,1519,40719,21,3,57,2,3000.11,NULL,'2023-05-18 19:26:55','2023-05-18 19:26:55',NULL),(3887,7851,1520,40719,21,3,554,1,12259.82,NULL,'2023-05-18 19:41:39','2023-05-18 19:41:39',NULL),(3888,7851,1520,40719,21,3,68,1,2574.56,NULL,'2023-05-18 19:41:39','2023-05-18 19:41:39',NULL),(3889,7851,1520,40719,21,3,221,1,1231.09,NULL,'2023-05-18 19:41:39','2023-05-18 19:41:39',NULL),(3890,7851,1520,40719,21,3,57,2,16065.47,NULL,'2023-05-18 19:41:39','2023-05-18 19:41:39',NULL),(3891,7851,1521,40719,21,3,217,1,678305.76,NULL,'2023-05-18 20:04:59','2023-05-18 20:04:59',NULL),(3892,7851,1521,40719,21,3,68,1,142444.21,NULL,'2023-05-18 20:04:59','2023-05-18 20:04:59',NULL),(3893,7851,1521,40719,21,3,57,2,820749.97,NULL,'2023-05-18 20:04:59','2023-05-18 20:04:59',NULL),(3894,7851,1522,40719,22,3,217,1,4627.55,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3895,7851,1522,40719,22,3,68,1,971.78,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3896,7851,1522,40719,22,3,57,2,5599.33,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3897,7851,1523,40719,22,3,217,1,17611.65,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3898,7851,1523,40719,22,3,68,1,3698.45,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3899,7851,1523,40719,22,3,217,1,352.23,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3900,7851,1523,40719,22,3,57,2,21662.33,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3901,7851,1524,40719,22,3,217,1,2230.00,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3902,7851,1524,40719,22,3,68,1,468.30,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3903,7851,1524,40719,22,3,57,2,2698.30,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3904,7851,1525,40719,22,3,217,1,1208.26,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3905,7851,1525,40719,22,3,68,1,253.73,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3906,7851,1525,40719,22,3,57,2,1461.99,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3907,7851,1526,40719,22,3,217,1,5957.85,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3908,7851,1526,40719,22,3,68,1,1251.14,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3909,7851,1526,40719,22,3,217,1,0.01,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3910,7851,1526,40719,22,3,57,2,7209.00,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3911,7851,1527,40719,22,3,217,2,816819.81,NULL,'2023-05-18 20:42:31','2023-05-18 20:43:22','2023-05-18 20:43:22'),(3912,7851,1527,40719,22,3,67,2,3930.16,NULL,'2023-05-18 20:42:31','2023-05-18 20:43:22','2023-05-18 20:43:22'),(3913,7851,1527,40719,22,3,57,1,820749.97,NULL,'2023-05-18 20:42:31','2023-05-18 20:43:22','2023-05-18 20:43:22'),(3914,7851,1528,40719,22,3,120,1,1551.96,NULL,'2023-05-18 20:42:31','2023-05-19 01:06:34','2023-05-19 01:06:34'),(3915,7851,1528,40719,22,3,68,1,419.03,NULL,'2023-05-18 20:42:31','2023-05-19 01:06:34','2023-05-19 01:06:34'),(3916,7851,1528,40719,22,3,57,2,1970.99,NULL,'2023-05-18 20:42:31','2023-05-19 01:06:34','2023-05-19 01:06:34'),(3917,7851,1529,40719,22,3,120,1,15009.89,NULL,'2023-05-18 20:42:31','2023-05-19 01:06:16','2023-05-19 01:06:16'),(3918,7851,1529,40719,22,3,68,1,4008.69,NULL,'2023-05-18 20:42:31','2023-05-19 01:06:16','2023-05-19 01:06:16'),(3919,7851,1529,40719,22,3,120,1,1201.71,NULL,'2023-05-18 20:42:31','2023-05-19 01:06:16','2023-05-19 01:06:16'),(3920,7851,1529,40719,22,3,57,2,20220.29,NULL,'2023-05-18 20:42:31','2023-05-19 01:06:16','2023-05-19 01:06:16');
INSERT INTO `balance_libro_details` VALUES (3921,7851,1530,40719,22,3,217,1,273150.41,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3922,7851,1530,40719,22,3,68,1,57361.59,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3923,7851,1530,40719,22,3,57,2,330512.00,NULL,'2023-05-18 20:42:31','2023-05-18 20:42:31',NULL),(3924,7851,1531,40719,22,3,507,1,6575.41,NULL,'2023-05-18 20:49:17','2023-05-18 20:49:17',NULL),(3925,7851,1531,40719,22,3,68,1,1380.84,NULL,'2023-05-18 20:49:17','2023-05-18 20:49:17',NULL),(3926,7851,1531,40719,22,3,221,1,445.32,NULL,'2023-05-18 20:49:17','2023-05-18 20:49:17',NULL),(3927,7851,1531,40719,22,3,57,2,8401.57,NULL,'2023-05-18 20:49:17','2023-05-18 20:49:17',NULL),(3928,7851,1532,40719,22,3,507,1,8117.08,NULL,'2023-05-18 20:52:26','2023-05-18 20:53:27','2023-05-18 20:53:27'),(3929,7851,1532,40719,22,3,68,1,1704.59,NULL,'2023-05-18 20:52:26','2023-05-18 20:53:27','2023-05-18 20:53:27'),(3930,7851,1532,40719,22,3,221,1,579.56,NULL,'2023-05-18 20:52:26','2023-05-18 20:53:27','2023-05-18 20:53:27'),(3931,7851,1532,40719,22,3,57,2,10401.23,NULL,'2023-05-18 20:52:26','2023-05-18 20:53:27','2023-05-18 20:53:27'),(3932,7851,1533,40719,22,3,507,1,8117.08,NULL,'2023-05-18 20:53:27','2023-05-18 20:53:27',NULL),(3933,7851,1533,40719,22,3,68,1,1704.59,NULL,'2023-05-18 20:53:27','2023-05-18 20:53:27',NULL),(3934,7851,1533,40719,22,3,221,1,579.56,NULL,'2023-05-18 20:53:27','2023-05-18 20:53:27',NULL),(3935,7851,1533,40719,22,3,57,2,10401.23,NULL,'2023-05-18 20:53:27','2023-05-18 20:53:27',NULL),(3936,7851,1534,40719,22,3,507,1,4136.66,NULL,'2023-05-18 20:55:22','2023-05-18 20:55:22',NULL),(3937,7851,1534,40719,22,3,68,1,868.70,NULL,'2023-05-18 20:55:22','2023-05-18 20:55:22',NULL),(3938,7851,1534,40719,22,3,221,1,295.36,NULL,'2023-05-18 20:55:22','2023-05-18 20:55:22',NULL),(3939,7851,1534,40719,22,3,57,2,5300.72,NULL,'2023-05-18 20:55:22','2023-05-18 20:55:22',NULL),(3940,7851,1535,40719,22,3,507,1,8142.58,NULL,'2023-05-18 20:58:03','2023-05-18 20:58:03',NULL),(3941,7851,1535,40719,22,3,68,1,1709.94,NULL,'2023-05-18 20:58:03','2023-05-18 20:58:03',NULL),(3942,7851,1535,40719,22,3,221,1,449.67,NULL,'2023-05-18 20:58:03','2023-05-18 20:58:03',NULL),(3943,7851,1535,40719,22,3,57,2,10302.19,NULL,'2023-05-18 20:58:03','2023-05-18 20:58:03',NULL),(3944,7851,1536,40719,22,3,520,1,15991.79,NULL,'2023-05-18 21:20:57','2023-06-05 20:30:08','2023-06-05 20:30:08'),(3945,7851,1536,40719,22,3,68,1,3358.28,NULL,'2023-05-18 21:20:57','2023-06-05 20:30:08','2023-06-05 20:30:08'),(3946,7851,1536,40719,22,3,221,1,1149.93,NULL,'2023-05-18 21:20:57','2023-06-05 20:30:08','2023-06-05 20:30:08'),(3947,7851,1536,40719,22,3,57,2,20500.00,NULL,'2023-05-18 21:20:57','2023-06-05 20:30:08','2023-06-05 20:30:08'),(3948,7851,1537,40719,22,3,520,1,14463.01,NULL,'2023-05-18 22:11:59','2023-05-18 22:11:59',NULL),(3949,7851,1537,40719,22,3,68,1,3037.23,NULL,'2023-05-18 22:11:59','2023-05-18 22:11:59',NULL),(3950,7851,1537,40719,22,3,221,1,1401.76,NULL,'2023-05-18 22:11:59','2023-05-18 22:11:59',NULL),(3951,7851,1537,40719,22,3,57,2,18902.00,NULL,'2023-05-18 22:11:59','2023-05-18 22:11:59',NULL),(3952,7851,1538,40719,22,3,554,1,4131.85,NULL,'2023-05-18 22:15:23','2023-05-18 22:15:23',NULL),(3953,7851,1538,40719,22,3,68,1,867.69,NULL,'2023-05-18 22:15:23','2023-05-18 22:15:23',NULL),(3954,7851,1538,40719,22,3,221,1,400.46,NULL,'2023-05-18 22:15:23','2023-05-18 22:15:23',NULL),(3955,7851,1538,40719,22,3,57,2,5400.00,NULL,'2023-05-18 22:15:23','2023-05-18 22:15:23',NULL),(3956,7851,1539,40719,22,3,520,1,17139.53,NULL,'2023-05-18 22:16:45','2023-05-18 22:16:45',NULL),(3957,7851,1539,40719,22,3,68,1,3599.30,NULL,'2023-05-18 22:16:45','2023-05-18 22:16:45',NULL),(3958,7851,1539,40719,22,3,221,1,1661.17,NULL,'2023-05-18 22:16:45','2023-05-18 22:16:45',NULL),(3959,7851,1539,40719,22,3,57,2,22400.00,NULL,'2023-05-18 22:16:45','2023-05-18 22:16:45',NULL),(3960,7851,1540,40719,22,21,57,1,22400.00,NULL,'2023-05-19 00:33:05','2023-05-19 00:33:05',NULL);
INSERT INTO `balance_libro_details` VALUES (3961,7851,1540,40719,22,21,563,2,22400.00,NULL,'2023-05-19 00:33:05','2023-05-19 00:33:05',NULL),(3962,7851,1541,40719,22,21,57,1,5400.00,NULL,'2023-05-19 00:33:56','2023-05-19 00:33:56',NULL),(3963,7851,1541,40719,22,21,488,2,5400.00,NULL,'2023-05-19 00:33:56','2023-05-19 00:33:56',NULL),(3964,7851,1542,40719,22,21,57,1,18902.00,NULL,'2023-05-19 00:34:40','2023-05-19 00:34:40',NULL),(3965,7851,1542,40719,22,21,484,2,18902.00,NULL,'2023-05-19 00:34:40','2023-05-19 00:34:40',NULL),(3966,7851,1543,40719,22,21,57,1,20500.00,NULL,'2023-05-19 00:35:25','2023-06-05 20:25:20','2023-06-05 20:25:20'),(3967,7851,1543,40719,22,21,484,2,20500.00,NULL,'2023-05-19 00:35:25','2023-06-05 20:25:20','2023-06-05 20:25:20'),(3968,7851,1544,40719,22,21,57,1,8401.57,NULL,'2023-05-19 00:36:06','2023-05-19 00:36:06',NULL),(3969,7851,1544,40719,22,21,552,2,8401.57,NULL,'2023-05-19 00:36:06','2023-05-19 00:36:06',NULL),(3970,7851,1545,40719,22,21,57,1,10302.19,NULL,'2023-05-19 00:36:46','2023-05-19 00:36:46',NULL),(3971,7851,1545,40719,22,21,552,2,10302.19,NULL,'2023-05-19 00:36:46','2023-05-19 00:36:46',NULL),(3972,7851,1546,40719,22,21,57,1,5300.72,NULL,'2023-05-19 00:38:32','2023-05-19 00:38:32',NULL),(3973,7851,1546,40719,22,21,552,2,5300.72,NULL,'2023-05-19 00:38:32','2023-05-19 00:38:32',NULL),(3974,7851,1547,40719,22,21,57,1,10401.23,NULL,'2023-05-19 00:39:08','2023-05-19 00:39:08',NULL),(3975,7851,1547,40719,22,21,552,2,10401.23,NULL,'2023-05-19 00:39:08','2023-05-19 00:39:08',NULL),(3976,7851,1548,40719,22,21,57,1,21662.33,NULL,'2023-05-19 00:40:25','2023-05-19 00:40:25',NULL),(3977,7851,1548,40719,22,21,552,2,21662.33,NULL,'2023-05-19 00:40:25','2023-05-19 00:40:25',NULL),(3978,7851,1549,40719,22,21,57,1,330512.00,NULL,'2023-05-19 00:43:38','2023-05-19 00:43:38',NULL),(3979,7851,1549,40719,22,21,494,2,330512.00,NULL,'2023-05-19 00:43:38','2023-05-19 00:43:38',NULL),(3980,7851,1550,40719,22,21,57,1,1461.99,NULL,'2023-05-19 00:44:18','2023-05-19 00:44:18',NULL),(3981,7851,1550,40719,22,21,552,2,1461.99,NULL,'2023-05-19 00:44:18','2023-05-19 00:44:18',NULL),(3982,7851,1551,40719,22,21,57,1,5599.33,NULL,'2023-05-19 00:45:01','2023-05-19 00:45:01',NULL),(3983,7851,1551,40719,22,21,552,2,5599.33,NULL,'2023-05-19 00:45:01','2023-05-19 00:45:01',NULL),(3984,7851,1552,40719,22,21,57,1,7209.00,NULL,'2023-05-19 00:45:47','2023-05-19 00:45:47',NULL),(3985,7851,1552,40719,22,21,552,2,7209.00,NULL,'2023-05-19 00:45:47','2023-05-19 00:45:47',NULL),(3986,7851,1553,40719,22,21,57,1,2698.30,NULL,'2023-05-19 00:46:49','2023-05-19 00:46:49',NULL),(3987,7851,1553,40719,22,21,163,2,2698.30,NULL,'2023-05-19 00:46:49','2023-05-19 00:46:49',NULL),(3988,7851,1554,40719,22,21,57,1,-6795.36,NULL,'2023-05-19 00:55:40','2023-05-19 00:55:40',NULL),(3989,7851,1554,40719,22,21,488,2,-6795.36,NULL,'2023-05-19 00:55:40','2023-05-19 00:55:40',NULL),(3990,7851,1555,40719,21,21,57,1,997.80,NULL,'2023-05-19 00:57:11','2023-05-19 00:57:11',NULL),(3991,7851,1555,40719,21,21,483,2,997.80,NULL,'2023-05-19 00:57:11','2023-05-19 00:57:11',NULL),(3992,7851,1556,40719,21,21,57,1,820749.97,NULL,'2023-05-19 01:05:32','2023-05-19 01:05:32',NULL),(3993,7851,1556,40719,21,21,494,2,280000.00,NULL,'2023-05-19 01:05:32','2023-05-19 01:05:32',NULL),(3994,7851,1556,40719,21,21,493,2,119000.00,NULL,'2023-05-19 01:05:32','2023-05-19 01:05:32',NULL),(3995,7851,1556,40719,21,21,552,2,421749.97,NULL,'2023-05-19 01:05:32','2023-05-19 01:05:32',NULL),(3996,7851,1557,40719,22,3,120,1,15009.89,NULL,'2023-05-19 01:06:16','2023-06-05 20:28:29','2023-06-05 20:28:29'),(3997,7851,1557,40719,22,3,68,1,4052.67,NULL,'2023-05-19 01:06:16','2023-06-05 20:28:29','2023-06-05 20:28:29'),(3998,7851,1557,40719,22,3,120,1,1201.71,NULL,'2023-05-19 01:06:16','2023-06-05 20:28:29','2023-06-05 20:28:29'),(3999,7851,1557,40719,22,3,57,2,20264.27,NULL,'2023-05-19 01:06:16','2023-06-05 20:28:29','2023-06-05 20:28:29'),(4000,7851,1558,40719,22,3,120,1,1551.96,NULL,'2023-05-19 01:06:34','2023-05-19 01:06:34',NULL);
INSERT INTO `balance_libro_details` VALUES (4001,7851,1558,40719,22,3,68,1,419.03,NULL,'2023-05-19 01:06:34','2023-05-19 01:06:34',NULL),(4002,7851,1558,40719,22,3,57,2,1970.99,NULL,'2023-05-19 01:06:34','2023-05-19 01:06:34',NULL),(4003,7851,1559,40719,22,21,57,1,16065.47,NULL,'2023-05-19 01:08:30','2023-05-19 01:08:30',NULL),(4004,7851,1559,40719,22,21,484,2,16065.47,NULL,'2023-05-19 01:08:30','2023-05-19 01:08:30',NULL),(4005,7851,1560,40719,21,21,57,1,3000.11,NULL,'2023-05-19 01:14:59','2023-05-19 01:14:59',NULL),(4006,7851,1560,40719,21,21,488,2,3000.11,NULL,'2023-05-19 01:14:59','2023-05-19 01:14:59',NULL),(4007,7851,1561,40719,22,20,564,2,25000.00,NULL,'2023-05-24 00:00:21','2023-05-24 00:00:21',NULL),(4008,7851,1561,40719,22,20,563,1,25000.00,NULL,'2023-05-24 00:00:21','2023-05-24 00:00:21',NULL),(4009,7851,1562,40719,22,20,563,1,15000.00,NULL,'2023-05-24 00:01:17','2023-05-24 00:01:17',NULL),(4010,7851,1562,40719,22,20,564,2,15000.00,NULL,'2023-05-24 00:01:17','2023-05-24 00:01:17',NULL),(4011,7851,1563,40719,22,19,566,1,17806.60,NULL,'2023-05-24 00:33:10','2023-05-24 00:33:10',NULL),(4012,7851,1563,40719,22,19,163,2,17806.60,NULL,'2023-05-24 00:33:10','2023-05-24 00:33:10',NULL),(4013,7851,1564,40719,22,19,492,1,10000.00,NULL,'2023-05-24 00:35:44','2023-05-24 00:35:44',NULL),(4014,7851,1564,40719,22,19,163,2,10000.00,NULL,'2023-05-24 00:35:44','2023-05-24 00:35:44',NULL),(4015,7851,1565,40719,22,19,492,1,10000.00,NULL,'2023-05-24 00:36:21','2023-05-24 00:36:21',NULL),(4016,7851,1565,40719,22,19,163,2,10000.00,NULL,'2023-05-24 00:36:21','2023-05-24 00:36:21',NULL),(4017,7851,1566,40719,22,21,527,1,6354.99,NULL,'2023-05-24 00:39:47','2023-05-24 00:39:47',NULL),(4018,7851,1566,40719,22,21,163,2,9373.27,NULL,'2023-05-24 00:39:47','2023-05-24 00:39:47',NULL),(4019,7851,1566,40719,22,21,540,1,3018.28,NULL,'2023-05-24 00:39:47','2023-05-24 00:39:47',NULL),(4020,7851,1567,40719,22,19,566,2,400538.16,NULL,'2023-05-24 00:41:42','2023-05-24 00:41:42',NULL),(4021,7851,1567,40719,22,19,163,1,400538.16,NULL,'2023-05-24 00:41:42','2023-05-24 00:41:42',NULL),(4022,7851,1568,40719,22,19,557,1,400000.00,NULL,'2023-05-24 00:43:36','2023-05-24 00:45:29','2023-05-24 00:45:29'),(4023,7851,1568,40719,22,19,163,2,400000.00,NULL,'2023-05-24 00:43:36','2023-05-24 00:45:29','2023-05-24 00:45:29'),(4024,7851,1569,40719,22,19,557,2,17806.60,NULL,'2023-05-24 00:44:48','2023-05-24 00:44:48',NULL),(4025,7851,1569,40719,22,19,163,1,17806.60,NULL,'2023-05-24 00:44:48','2023-05-24 00:44:48',NULL),(4026,7851,1570,40719,22,19,557,1,400000.00,NULL,'2023-05-24 00:45:29','2023-05-24 00:45:29',NULL),(4027,7851,1570,40719,22,19,163,2,400000.00,NULL,'2023-05-24 00:45:29','2023-05-24 00:45:29',NULL),(4028,7851,1571,40719,22,3,519,1,38350.41,NULL,'2023-05-24 00:50:46','2023-05-24 00:50:46',NULL),(4029,7851,1571,40719,22,3,68,1,8053.59,NULL,'2023-05-24 00:50:46','2023-05-24 00:50:46',NULL),(4030,7851,1571,40719,22,3,57,2,46404.00,NULL,'2023-05-24 00:50:46','2023-05-24 00:50:46',NULL),(4031,7851,1572,40719,22,21,57,1,20220.29,NULL,'2023-05-24 00:53:35','2023-05-24 01:21:36','2023-05-24 01:21:36'),(4032,7851,1572,40719,22,21,563,2,20220.29,NULL,'2023-05-24 00:53:35','2023-05-24 01:21:36','2023-05-24 01:21:36'),(4033,7851,1573,40719,22,21,57,1,1970.99,NULL,'2023-05-24 00:54:17','2023-05-24 01:21:21','2023-05-24 01:21:21'),(4034,7851,1573,40719,22,21,563,2,1970.99,NULL,'2023-05-24 00:54:17','2023-05-24 01:21:21','2023-05-24 01:21:21'),(4035,7851,1574,40719,22,21,57,1,46404.00,NULL,'2023-05-24 00:55:10','2023-05-24 00:55:10',NULL),(4036,7851,1574,40719,22,21,493,2,46404.00,NULL,'2023-05-24 00:55:10','2023-05-24 00:55:10',NULL),(4037,7851,1575,40719,22,3,507,1,5462.21,NULL,'2023-05-24 01:12:54','2023-05-24 01:12:54',NULL),(4038,7851,1575,40719,22,3,68,1,1147.06,NULL,'2023-05-24 01:12:54','2023-05-24 01:12:54',NULL),(4039,7851,1575,40719,22,3,507,1,0.01,NULL,'2023-05-24 01:12:54','2023-05-24 01:12:54',NULL),(4040,7851,1575,40719,22,3,57,2,6609.28,NULL,'2023-05-24 01:12:54','2023-05-24 01:12:54',NULL);
INSERT INTO `balance_libro_details` VALUES (4041,7851,1576,40719,22,3,507,1,26821.49,NULL,'2023-05-24 01:14:50','2023-05-24 01:14:50',NULL),(4042,7851,1576,40719,22,3,68,1,5632.51,NULL,'2023-05-24 01:14:50','2023-05-24 01:14:50',NULL),(4043,7851,1576,40719,22,3,57,2,32454.00,NULL,'2023-05-24 01:14:50','2023-05-24 01:14:50',NULL),(4044,7851,1577,40719,22,21,57,1,32454.00,NULL,'2023-05-24 01:16:34','2023-05-24 01:16:34',NULL),(4045,7851,1577,40719,22,21,493,2,32454.00,NULL,'2023-05-24 01:16:34','2023-05-24 01:16:34',NULL),(4046,7851,1578,40719,22,21,57,1,6609.28,NULL,'2023-05-24 01:17:11','2023-05-24 01:17:11',NULL),(4047,7851,1578,40719,22,21,493,2,6609.28,NULL,'2023-05-24 01:17:11','2023-05-24 01:17:11',NULL),(4048,7851,1579,40719,22,21,57,1,20220.29,NULL,'2023-05-24 01:25:26','2023-06-05 20:27:01','2023-06-05 20:27:01'),(4049,7851,1579,40719,22,21,163,2,20220.29,NULL,'2023-05-24 01:25:26','2023-06-05 20:27:01','2023-06-05 20:27:01'),(4050,7851,1580,40719,22,21,57,1,1970.99,NULL,'2023-05-24 01:26:06','2023-05-24 01:26:06',NULL),(4051,7851,1580,40719,22,21,163,2,1970.99,NULL,'2023-05-24 01:26:06','2023-05-24 01:26:06',NULL),(4052,7851,1581,40719,22,3,217,2,816819.81,NULL,'2023-06-01 17:24:17','2023-06-01 23:37:30','2023-06-01 23:37:30'),(4053,7851,1581,40719,22,3,67,2,3930.16,NULL,'2023-06-01 17:24:17','2023-06-01 23:37:30','2023-06-01 23:37:30'),(4054,7851,1581,40719,22,3,57,1,820749.97,NULL,'2023-06-01 17:24:17','2023-06-01 23:37:30','2023-06-01 23:37:30'),(4055,7851,1582,40719,22,3,217,1,412.31,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4056,7851,1582,40719,22,3,68,1,86.59,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4057,7851,1582,40719,22,3,57,2,498.90,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4058,7851,1583,40719,22,3,217,1,41502.46,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4059,7851,1583,40719,22,3,68,1,8715.52,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4060,7851,1583,40719,22,3,57,2,50217.98,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4061,7851,1584,40719,22,3,217,1,5462.21,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4062,7851,1584,40719,22,3,68,1,1147.07,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4063,7851,1584,40719,22,3,57,2,6609.28,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4064,7851,1585,40719,22,3,163,1,2545.45,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4065,7851,1585,40719,22,3,68,1,534.55,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4066,7851,1585,40719,22,3,163,1,320.00,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4067,7851,1585,40719,22,3,57,2,3400.00,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4068,7851,1586,40719,22,3,217,1,143448.83,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4069,7851,1586,40719,22,3,68,1,30124.25,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4070,7851,1586,40719,22,3,57,2,173573.08,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4071,7851,1587,40719,22,3,217,1,7799.83,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4072,7851,1587,40719,22,3,68,1,1637.97,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4073,7851,1587,40719,22,3,217,1,963.00,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4074,7851,1587,40719,22,3,57,2,10400.80,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4075,7851,1588,40719,22,3,217,1,33773.46,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4076,7851,1588,40719,22,3,68,1,7092.43,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4077,7851,1588,40719,22,3,217,1,844.34,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4078,7851,1588,40719,22,3,57,2,41710.23,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4079,7851,1589,40719,22,3,217,1,86902.84,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4080,7851,1589,40719,22,3,68,1,18249.60,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL);
INSERT INTO `balance_libro_details` VALUES (4081,7851,1589,40719,22,3,217,1,2172.57,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4082,7851,1589,40719,22,3,57,2,107325.01,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4083,7851,1590,40719,22,3,217,1,86902.84,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4084,7851,1590,40719,22,3,68,1,18249.60,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4085,7851,1590,40719,22,3,217,1,2172.57,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4086,7851,1590,40719,22,3,57,2,107325.01,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4087,7851,1591,40719,22,3,217,1,31995.91,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4088,7851,1591,40719,22,3,68,1,6719.14,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4089,7851,1591,40719,22,3,217,1,799.90,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4090,7851,1591,40719,22,3,57,2,39514.95,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4091,7851,1592,40719,22,3,217,2,86902.84,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4092,7851,1592,40719,22,3,67,2,18249.60,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4093,7851,1592,40719,22,3,217,2,2172.57,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4094,7851,1592,40719,22,3,57,1,107325.01,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4095,7851,1593,40719,22,3,217,2,31995.91,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4096,7851,1593,40719,22,3,67,2,6719.14,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4097,7851,1593,40719,22,3,217,2,799.90,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4098,7851,1593,40719,22,3,57,1,39514.95,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4099,7851,1594,40719,22,3,217,1,3636.36,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4100,7851,1594,40719,22,3,68,1,763.64,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4101,7851,1594,40719,22,3,57,2,4400.00,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4102,7851,1595,40719,22,3,217,1,4958.68,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4103,7851,1595,40719,22,3,68,1,1041.32,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4104,7851,1595,40719,22,3,57,2,6000.00,NULL,'2023-06-01 17:24:17','2023-06-01 17:24:17',NULL),(4105,7851,1596,40719,22,2,96,2,350000.00,NULL,'2023-06-01 17:27:35','2023-06-01 17:27:35',NULL),(4106,7851,1596,40719,22,2,67,2,36750.00,NULL,'2023-06-01 17:27:35','2023-06-01 17:27:35',NULL),(4107,7851,1596,40719,22,2,13,1,386750.00,NULL,'2023-06-01 17:27:35','2023-06-01 17:27:35',NULL),(4108,7851,1597,40719,22,3,507,1,3834.71,NULL,'2023-06-01 17:50:42','2023-06-01 17:50:42',NULL),(4109,7851,1597,40719,22,3,68,1,805.29,NULL,'2023-06-01 17:50:42','2023-06-01 17:50:42',NULL),(4110,7851,1597,40719,22,3,57,2,4640.00,NULL,'2023-06-01 17:50:42','2023-06-01 17:50:42',NULL),(4111,7851,1598,40719,22,3,520,1,15360.40,NULL,'2023-06-01 17:52:14','2023-06-01 17:52:14',NULL),(4112,7851,1598,40719,22,3,68,1,3225.68,NULL,'2023-06-01 17:52:14','2023-06-01 17:52:14',NULL),(4113,7851,1598,40719,22,3,221,1,1413.91,NULL,'2023-06-01 17:52:14','2023-06-01 17:52:14',NULL),(4114,7851,1598,40719,22,3,57,2,19999.99,NULL,'2023-06-01 17:52:14','2023-06-01 17:52:14',NULL),(4115,7851,1599,40719,22,3,520,1,12518.73,NULL,'2023-06-01 17:53:55','2023-06-01 17:53:55',NULL),(4116,7851,1599,40719,22,3,68,1,2628.93,NULL,'2023-06-01 17:53:55','2023-06-01 17:53:55',NULL),(4117,7851,1599,40719,22,3,221,1,1152.34,NULL,'2023-06-01 17:53:55','2023-06-01 17:53:55',NULL),(4118,7851,1599,40719,22,3,57,2,16300.00,NULL,'2023-06-01 17:53:55','2023-06-01 17:53:55',NULL),(4119,7851,1600,40719,22,3,554,1,2479.37,NULL,'2023-06-01 17:59:02','2023-06-01 17:59:02',NULL),(4120,7851,1600,40719,22,3,68,1,520.67,NULL,'2023-06-01 17:59:02','2023-06-01 17:59:02',NULL),(4121,7851,1600,40719,22,3,57,2,3000.04,NULL,'2023-06-01 17:59:02','2023-06-01 17:59:02',NULL);
INSERT INTO `balance_libro_details` VALUES (4122,7851,1601,40719,22,3,554,1,450.07,NULL,'2023-06-01 18:00:04','2023-06-01 18:00:04',NULL),(4123,7851,1601,40719,22,3,68,1,94.51,NULL,'2023-06-01 18:00:04','2023-06-01 18:00:04',NULL),(4124,7851,1601,40719,22,3,221,1,5.42,NULL,'2023-06-01 18:00:04','2023-06-01 18:00:04',NULL),(4125,7851,1601,40719,22,3,57,2,550.00,NULL,'2023-06-01 18:00:04','2023-06-01 18:00:04',NULL),(4126,7851,1602,40719,22,3,554,1,2479.29,NULL,'2023-06-01 18:01:51','2023-06-01 18:01:51',NULL),(4127,7851,1602,40719,22,3,68,1,520.65,NULL,'2023-06-01 18:01:51','2023-06-01 18:01:51',NULL),(4128,7851,1602,40719,22,3,57,2,2999.94,NULL,'2023-06-01 18:01:51','2023-06-01 18:01:51',NULL),(4129,7851,1603,40719,22,3,554,1,2923.87,NULL,'2023-06-01 18:05:41','2023-06-01 18:05:41',NULL),(4130,7851,1603,40719,22,3,68,1,614.01,NULL,'2023-06-01 18:05:41','2023-06-01 18:05:41',NULL),(4131,7851,1603,40719,22,3,221,1,462.11,NULL,'2023-06-01 18:05:41','2023-06-01 18:05:41',NULL),(4132,7851,1603,40719,22,3,57,2,3999.99,NULL,'2023-06-01 18:05:41','2023-06-01 18:05:41',NULL),(4133,7851,1604,40719,22,3,554,1,1461.91,NULL,'2023-06-01 18:08:29','2023-06-01 18:08:29',NULL),(4134,7851,1604,40719,22,3,68,1,307.00,NULL,'2023-06-01 18:08:29','2023-06-01 18:08:29',NULL),(4135,7851,1604,40719,22,3,221,1,231.05,NULL,'2023-06-01 18:08:29','2023-06-01 18:08:29',NULL),(4136,7851,1604,40719,22,3,57,2,1999.96,NULL,'2023-06-01 18:08:29','2023-06-01 18:08:29',NULL),(4137,7851,1605,40719,22,3,507,1,23434.75,NULL,'2023-06-01 18:12:10','2023-06-01 18:14:58','2023-06-01 18:14:58'),(4138,7851,1605,40719,22,3,68,1,4921.30,NULL,'2023-06-01 18:12:10','2023-06-01 18:14:58','2023-06-01 18:14:58'),(4139,7851,1605,40719,22,3,507,1,204.84,NULL,'2023-06-01 18:12:10','2023-06-01 18:14:58','2023-06-01 18:14:58'),(4140,7851,1605,40719,22,3,68,1,21.51,NULL,'2023-06-01 18:12:10','2023-06-01 18:14:58','2023-06-01 18:14:58'),(4141,7851,1605,40719,22,3,237,1,1418.37,NULL,'2023-06-01 18:12:10','2023-06-01 18:14:58','2023-06-01 18:14:58'),(4142,7851,1605,40719,22,3,57,2,30000.77,NULL,'2023-06-01 18:12:10','2023-06-01 18:14:58','2023-06-01 18:14:58'),(4143,7851,1606,40719,22,3,507,1,22919.96,NULL,'2023-06-01 18:13:03','2023-06-01 18:14:49','2023-06-01 18:14:49'),(4144,7851,1606,40719,22,3,68,1,4813.19,NULL,'2023-06-01 18:13:03','2023-06-01 18:14:49','2023-06-01 18:14:49'),(4145,7851,1606,40719,22,3,507,1,956.25,NULL,'2023-06-01 18:13:03','2023-06-01 18:14:49','2023-06-01 18:14:49'),(4146,7851,1606,40719,22,3,68,1,100.41,NULL,'2023-06-01 18:13:03','2023-06-01 18:14:49','2023-06-01 18:14:49'),(4147,7851,1606,40719,22,3,237,1,1432.57,NULL,'2023-06-01 18:13:03','2023-06-01 18:14:49','2023-06-01 18:14:49'),(4148,7851,1606,40719,22,3,57,2,30222.38,NULL,'2023-06-01 18:13:03','2023-06-01 18:14:49','2023-06-01 18:14:49'),(4149,7851,1607,40719,22,3,507,1,6266.34,NULL,'2023-06-01 18:13:57','2023-06-01 18:13:57',NULL),(4150,7851,1607,40719,22,3,68,1,1315.93,NULL,'2023-06-01 18:13:57','2023-06-01 18:13:57',NULL),(4151,7851,1607,40719,22,3,237,1,375.98,NULL,'2023-06-01 18:13:57','2023-06-01 18:13:57',NULL),(4152,7851,1607,40719,22,3,57,2,7958.25,NULL,'2023-06-01 18:13:57','2023-06-01 18:13:57',NULL),(4153,7851,1608,40719,22,3,507,1,17591.22,NULL,'2023-06-01 18:14:41','2023-06-01 18:14:41',NULL),(4154,7851,1608,40719,22,3,68,1,3694.16,NULL,'2023-06-01 18:14:41','2023-06-01 18:14:41',NULL),(4155,7851,1608,40719,22,3,237,1,1055.47,NULL,'2023-06-01 18:14:41','2023-06-01 18:14:41',NULL),(4156,7851,1608,40719,22,3,57,2,22340.85,NULL,'2023-06-01 18:14:41','2023-06-01 18:14:41',NULL),(4157,7851,1609,40719,22,3,507,1,22919.96,NULL,'2023-06-01 18:14:49','2023-06-01 18:14:49',NULL),(4158,7851,1609,40719,22,3,68,1,4813.19,NULL,'2023-06-01 18:14:49','2023-06-01 18:14:49',NULL),(4159,7851,1609,40719,22,3,507,1,956.25,NULL,'2023-06-01 18:14:49','2023-06-01 18:14:49',NULL),(4160,7851,1609,40719,22,3,68,1,100.41,NULL,'2023-06-01 18:14:49','2023-06-01 18:14:49',NULL);
INSERT INTO `balance_libro_details` VALUES (4161,7851,1609,40719,22,3,237,1,1432.57,NULL,'2023-06-01 18:14:49','2023-06-01 18:14:49',NULL),(4162,7851,1609,40719,22,3,57,2,30222.38,NULL,'2023-06-01 18:14:49','2023-06-01 18:14:49',NULL),(4163,7851,1610,40719,22,3,507,1,23434.75,NULL,'2023-06-01 18:14:58','2023-06-01 18:14:58',NULL),(4164,7851,1610,40719,22,3,68,1,4921.30,NULL,'2023-06-01 18:14:58','2023-06-01 18:14:58',NULL),(4165,7851,1610,40719,22,3,507,1,204.84,NULL,'2023-06-01 18:14:58','2023-06-01 18:14:58',NULL),(4166,7851,1610,40719,22,3,68,1,21.51,NULL,'2023-06-01 18:14:58','2023-06-01 18:14:58',NULL),(4167,7851,1610,40719,22,3,237,1,1418.37,NULL,'2023-06-01 18:14:58','2023-06-01 18:14:58',NULL),(4168,7851,1610,40719,22,3,57,2,30000.77,NULL,'2023-06-01 18:14:58','2023-06-01 18:14:58',NULL),(4169,7851,1611,40719,21,15,67,1,236025.69,NULL,'2023-06-01 18:15:39','2023-06-01 18:15:39',NULL),(4170,7851,1611,40719,21,15,68,2,183544.69,NULL,'2023-06-01 18:15:40','2023-06-01 18:15:40',NULL),(4171,7851,1611,40719,21,15,74,2,49299.50,NULL,'2023-06-01 18:15:40','2023-06-01 18:15:40',NULL),(4172,7851,1611,40719,21,15,136,2,3181.50,NULL,'2023-06-01 18:15:40','2023-06-01 18:15:40',NULL),(4173,7851,1612,40719,22,21,57,1,90522.25,NULL,'2023-06-01 23:05:16','2023-06-01 23:05:16',NULL),(4174,7851,1612,40719,22,21,552,2,90522.25,NULL,'2023-06-01 23:05:16','2023-06-01 23:05:16',NULL),(4175,7851,1613,40719,22,21,57,1,5999.95,NULL,'2023-06-01 23:07:04','2023-06-01 23:07:04',NULL),(4176,7851,1613,40719,22,21,488,2,5999.95,NULL,'2023-06-01 23:07:04','2023-06-01 23:07:04',NULL),(4177,7851,1614,40719,22,21,57,1,7000.10,NULL,'2023-06-01 23:08:13','2023-06-01 23:08:13',NULL),(4178,7851,1614,40719,22,21,488,2,7000.10,NULL,'2023-06-01 23:08:13','2023-06-01 23:08:13',NULL),(4179,7851,1615,40719,22,21,57,1,6549.98,NULL,'2023-06-01 23:09:05','2023-06-01 23:09:05',NULL),(4180,7851,1615,40719,22,21,488,2,6549.98,NULL,'2023-06-01 23:09:05','2023-06-01 23:09:05',NULL),(4181,7851,1616,40719,22,21,57,1,16300.00,NULL,'2023-06-01 23:11:43','2023-06-01 23:11:43',NULL),(4182,7851,1616,40719,22,21,484,2,16300.00,NULL,'2023-06-01 23:11:43','2023-06-01 23:11:43',NULL),(4183,7851,1617,40719,22,21,57,1,19999.99,NULL,'2023-06-01 23:12:44','2023-06-01 23:12:44',NULL),(4184,7851,1617,40719,22,21,563,2,19999.99,NULL,'2023-06-01 23:12:44','2023-06-01 23:12:44',NULL),(4185,7851,1618,40719,22,21,57,1,4640.00,NULL,'2023-06-01 23:13:52','2023-06-01 23:13:52',NULL),(4186,7851,1618,40719,22,21,552,2,4640.00,NULL,'2023-06-01 23:13:52','2023-06-01 23:13:52',NULL),(4187,7851,1619,40719,22,21,57,1,10400.80,NULL,'2023-06-01 23:14:47','2023-06-01 23:14:47',NULL),(4188,7851,1619,40719,22,21,552,2,10400.80,NULL,'2023-06-01 23:14:47','2023-06-01 23:14:47',NULL),(4189,7851,1620,40719,22,21,57,1,173573.08,NULL,'2023-06-01 23:17:05','2023-06-01 23:17:05',NULL),(4190,7851,1620,40719,22,21,483,2,173573.08,NULL,'2023-06-01 23:17:05','2023-06-01 23:17:05',NULL),(4191,7851,1621,40719,22,21,57,1,6000.00,NULL,'2023-06-01 23:18:13','2023-06-01 23:18:13',NULL),(4192,7851,1621,40719,22,21,493,2,6000.00,NULL,'2023-06-01 23:18:13','2023-06-01 23:18:13',NULL),(4193,7851,1622,40719,22,21,57,1,3400.00,NULL,'2023-06-01 23:18:56','2023-06-05 23:54:28','2023-06-05 23:54:28'),(4194,7851,1622,40719,22,21,552,2,3400.00,NULL,'2023-06-01 23:18:56','2023-06-05 23:54:28','2023-06-05 23:54:28'),(4195,7851,1623,40719,22,21,57,1,37259.00,NULL,'2023-06-01 23:21:46','2023-06-01 23:21:46',NULL),(4196,7851,1623,40719,22,21,483,2,37259.00,NULL,'2023-06-01 23:21:46','2023-06-01 23:21:46',NULL),(4197,7851,1624,40719,22,21,57,1,6609.28,NULL,'2023-06-01 23:23:23','2023-06-01 23:23:23',NULL),(4198,7851,1624,40719,22,21,493,2,6609.28,NULL,'2023-06-01 23:23:23','2023-06-01 23:23:23',NULL),(4199,7851,1625,40719,22,21,57,1,4400.00,NULL,'2023-06-01 23:24:17','2023-06-01 23:24:17',NULL),(4200,7851,1625,40719,22,21,493,2,4400.00,NULL,'2023-06-01 23:24:17','2023-06-01 23:24:17',NULL),(4201,7851,1626,40719,22,21,57,1,50217.98,NULL,'2023-06-01 23:25:32','2023-06-01 23:25:32',NULL);
INSERT INTO `balance_libro_details` VALUES (4202,7851,1626,40719,22,21,493,2,50217.98,NULL,'2023-06-01 23:25:32','2023-06-01 23:25:32',NULL),(4203,7851,1627,40719,22,21,57,1,498.90,NULL,'2023-06-01 23:26:39','2023-06-06 00:28:38','2023-06-06 00:28:38'),(4204,7851,1627,40719,22,21,484,2,498.90,NULL,'2023-06-01 23:26:39','2023-06-06 00:28:38','2023-06-06 00:28:38'),(4205,7851,1628,40719,22,21,57,1,3000.01,NULL,'2023-06-01 23:38:29','2023-06-01 23:38:29',NULL),(4206,7851,1628,40719,22,21,552,2,3000.01,NULL,'2023-06-01 23:38:29','2023-06-01 23:38:29',NULL),(4207,7851,1629,40719,22,19,564,2,30000.00,NULL,'2023-06-02 00:06:58','2023-06-02 00:08:10','2023-06-02 00:08:10'),(4208,7851,1629,40719,22,19,563,1,30000.00,NULL,'2023-06-02 00:06:58','2023-06-02 00:08:10','2023-06-02 00:08:10'),(4209,7851,1630,40719,22,19,564,2,20000.00,NULL,'2023-06-02 00:07:50','2023-06-02 00:07:50',NULL),(4210,7851,1630,40719,22,19,563,1,20000.00,NULL,'2023-06-02 00:07:50','2023-06-02 00:07:50',NULL),(4211,7851,1631,40719,22,19,564,2,30000.00,NULL,'2023-06-02 00:08:10','2023-06-02 00:08:10',NULL),(4212,7851,1631,40719,22,19,563,1,30000.00,NULL,'2023-06-02 00:08:10','2023-06-02 00:08:10',NULL),(4213,7851,1632,40719,22,3,120,1,14276.89,NULL,'2023-06-05 20:28:29','2023-06-05 20:28:29',NULL),(4214,7851,1632,40719,22,3,68,1,3854.76,NULL,'2023-06-05 20:28:29','2023-06-05 20:28:29',NULL),(4215,7851,1632,40719,22,3,120,1,733.00,NULL,'2023-06-05 20:28:29','2023-06-05 20:28:29',NULL),(4216,7851,1632,40719,22,3,68,1,153.93,NULL,'2023-06-05 20:28:29','2023-06-05 20:28:29',NULL),(4217,7851,1632,40719,22,3,221,1,751.41,NULL,'2023-06-05 20:28:29','2023-06-05 20:28:29',NULL),(4218,7851,1632,40719,22,3,237,1,450.30,NULL,'2023-06-05 20:28:29','2023-06-05 20:28:29',NULL),(4219,7851,1632,40719,22,3,57,2,20220.29,NULL,'2023-06-05 20:28:29','2023-06-05 20:28:29',NULL),(4220,7851,1633,40719,22,21,57,1,20220.29,NULL,'2023-06-05 20:29:31','2023-06-05 20:29:31',NULL),(4221,7851,1633,40719,22,21,163,2,20220.29,NULL,'2023-06-05 20:29:31','2023-06-05 20:29:31',NULL),(4222,7851,1634,40719,22,3,520,1,15991.79,NULL,'2023-06-05 20:30:08','2023-06-05 20:33:54','2023-06-05 20:33:54'),(4223,7851,1634,40719,22,3,68,1,3358.28,NULL,'2023-06-05 20:30:08','2023-06-05 20:33:54','2023-06-05 20:33:54'),(4224,7851,1634,40719,22,3,221,1,1549.93,NULL,'2023-06-05 20:30:08','2023-06-05 20:33:54','2023-06-05 20:33:54'),(4225,7851,1634,40719,22,3,57,2,20900.00,NULL,'2023-06-05 20:30:08','2023-06-05 20:33:54','2023-06-05 20:33:54'),(4226,7851,1635,40719,22,3,520,1,15991.79,NULL,'2023-06-05 20:33:54','2023-06-05 23:06:41','2023-06-05 23:06:41'),(4227,7851,1635,40719,22,3,68,1,3358.28,NULL,'2023-06-05 20:33:54','2023-06-05 23:06:41','2023-06-05 23:06:41'),(4228,7851,1635,40719,22,3,221,1,1549.93,NULL,'2023-06-05 20:33:54','2023-06-05 23:06:41','2023-06-05 23:06:41'),(4229,7851,1635,40719,22,3,57,2,20900.00,NULL,'2023-06-05 20:33:55','2023-06-05 23:06:41','2023-06-05 23:06:41'),(4230,7851,1636,40719,22,3,520,1,15991.79,NULL,'2023-06-05 23:08:18','2023-06-05 23:08:18',NULL),(4231,7851,1636,40719,22,3,68,1,3358.28,NULL,'2023-06-05 23:08:18','2023-06-05 23:08:18',NULL),(4232,7851,1636,40719,22,3,221,1,1549.93,NULL,'2023-06-05 23:08:18','2023-06-05 23:08:18',NULL),(4233,7851,1636,40719,22,3,57,2,20900.00,NULL,'2023-06-05 23:08:18','2023-06-05 23:08:18',NULL),(4234,7851,1637,40719,22,21,57,1,20900.00,NULL,'2023-06-05 23:08:54','2023-06-06 01:02:19','2023-06-06 01:02:19'),(4235,7851,1637,40719,22,21,488,2,20900.00,NULL,'2023-06-05 23:08:54','2023-06-06 01:02:19','2023-06-06 01:02:19'),(4236,7851,1638,40719,23,19,564,2,25000.00,NULL,'2023-06-05 23:15:17','2023-06-05 23:15:17',NULL),(4237,7851,1638,40719,23,19,563,1,25000.00,NULL,'2023-06-05 23:15:17','2023-06-05 23:15:17',NULL),(4238,7851,1639,40719,23,19,564,2,25000.00,NULL,'2023-06-05 23:16:21','2023-06-05 23:16:21',NULL),(4239,7851,1639,40719,23,19,563,1,25000.00,NULL,'2023-06-05 23:16:21','2023-06-05 23:16:21',NULL),(4240,7851,1640,40719,23,19,565,1,18000.00,NULL,'2023-06-05 23:22:14','2023-06-05 23:22:14',NULL);
INSERT INTO `balance_libro_details` VALUES (4241,7851,1640,40719,23,19,563,2,18000.00,NULL,'2023-06-05 23:22:14','2023-06-05 23:22:14',NULL),(4242,7851,1641,40719,23,19,565,1,10000.00,NULL,'2023-06-05 23:23:29','2023-06-05 23:23:29',NULL),(4243,7851,1641,40719,23,19,563,2,10000.00,NULL,'2023-06-05 23:23:29','2023-06-05 23:23:29',NULL),(4244,7851,1642,40719,22,20,13,2,386750.00,NULL,'2023-06-05 23:41:26','2023-06-05 23:41:26',NULL),(4245,7851,1642,40719,22,20,163,1,386750.00,NULL,'2023-06-05 23:41:26','2023-06-05 23:41:26',NULL),(4246,7851,1643,40719,22,21,57,1,3400.00,NULL,'2023-06-05 23:55:39','2023-06-06 00:11:09','2023-06-06 00:11:09'),(4247,7851,1643,40719,22,21,552,2,3400.00,NULL,'2023-06-05 23:55:39','2023-06-06 00:11:09','2023-06-06 00:11:09'),(4248,7851,1644,40719,22,19,163,1,20000.00,NULL,'2023-06-05 23:57:22','2023-06-05 23:57:22',NULL),(4249,7851,1644,40719,22,19,483,2,20000.00,NULL,'2023-06-05 23:57:22','2023-06-05 23:57:22',NULL),(4250,7851,1645,40719,22,21,57,1,7593.00,NULL,'2023-06-05 23:58:37','2023-06-05 23:58:37',NULL),(4251,7851,1645,40719,22,21,163,2,7593.00,NULL,'2023-06-05 23:58:37','2023-06-05 23:58:37',NULL),(4252,7851,1646,40719,22,19,483,1,290000.00,NULL,'2023-06-06 00:00:19','2023-06-06 00:00:19',NULL),(4253,7851,1646,40719,22,19,163,2,290000.00,NULL,'2023-06-06 00:00:19','2023-06-06 00:00:19',NULL),(4254,7851,1647,40719,22,3,491,1,50400.00,NULL,'2023-06-06 00:01:57','2023-06-06 00:01:57',NULL),(4255,7851,1647,40719,22,3,518,2,50400.00,NULL,'2023-06-06 00:01:57','2023-06-06 00:01:57',NULL),(4256,7851,1648,40719,22,21,163,2,50400.00,NULL,'2023-06-06 00:02:37','2023-06-06 00:02:37',NULL),(4257,7851,1648,40719,22,21,62,1,50400.00,NULL,'2023-06-06 00:02:37','2023-06-06 00:02:37',NULL),(4258,7851,1649,40719,22,3,491,2,89600.00,NULL,'2023-06-06 00:03:17','2023-06-06 00:03:17',NULL),(4259,7851,1649,40719,22,3,518,1,89600.00,NULL,'2023-06-06 00:03:17','2023-06-06 00:03:17',NULL),(4260,7851,1650,40719,22,21,163,2,89600.00,NULL,'2023-06-06 00:03:42','2023-06-06 00:03:42',NULL),(4261,7851,1650,40719,22,21,491,1,89600.00,NULL,'2023-06-06 00:03:42','2023-06-06 00:03:42',NULL),(4262,7851,1651,40719,23,3,63,2,75.70,NULL,'2023-06-06 00:05:16','2023-06-06 00:05:16',NULL),(4263,7851,1651,40719,23,3,191,1,75.70,NULL,'2023-06-06 00:05:16','2023-06-06 00:05:16',NULL),(4264,7851,1652,40719,23,10,163,2,75.70,NULL,'2023-06-06 00:05:56','2023-06-06 00:05:56',NULL),(4265,7851,1652,40719,23,10,63,1,75.70,NULL,'2023-06-06 00:05:56','2023-06-06 00:05:56',NULL),(4266,7851,1653,40719,22,21,57,1,3400.00,NULL,'2023-06-06 00:11:44','2023-06-06 00:11:44',NULL),(4267,7851,1653,40719,22,21,552,2,3400.00,NULL,'2023-06-06 00:11:44','2023-06-06 00:11:44',NULL),(4268,7851,1654,40719,22,19,566,1,196000.00,NULL,'2023-06-06 00:18:28','2023-06-06 00:18:28',NULL),(4269,7851,1654,40719,22,19,483,2,196000.00,NULL,'2023-06-06 00:18:28','2023-06-06 00:18:28',NULL),(4270,7851,1655,40719,22,21,57,1,498.90,NULL,'2023-06-06 00:29:36','2023-06-06 00:29:36',NULL),(4271,7851,1655,40719,22,21,494,2,498.90,NULL,'2023-06-06 00:29:36','2023-06-06 00:29:36',NULL),(4272,7851,1656,40719,22,21,57,1,997.80,NULL,'2023-06-06 00:33:49','2023-06-06 00:33:49',NULL),(4273,7851,1656,40719,22,21,494,2,997.80,NULL,'2023-06-06 00:33:49','2023-06-06 00:33:49',NULL),(4274,7851,1657,40719,22,21,57,1,20900.00,NULL,'2023-06-06 01:03:39','2023-06-06 01:03:39',NULL),(4275,7851,1657,40719,22,21,484,2,20900.00,NULL,'2023-06-06 01:03:39','2023-06-06 01:03:39',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-09-17 16:05:53',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-09-17 16:05:53',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-09-17 16:05:53',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-17 16:05:53','2022-09-17 16:05:53',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-17 16:06:03','2022-09-17 16:06:03',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-17 16:06:03','2022-09-17 16:06:03',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-17 16:06:03','2022-09-17 16:06:03',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-17 16:06:03','2022-09-17 16:06:03',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-17 16:06:15','2022-09-17 16:06:15',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-17 16:06:15','2022-09-17 16:06:15',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-17 16:06:15','2022-09-17 16:06:15',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-17 16:06:15','2022-09-17 16:06:15',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:04:42','2023-05-30 15:04:42',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:04:42','2023-05-30 15:04:42',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:04:42','2023-05-30 15:04:42',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:04:42','2023-05-30 15:04:42',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:04:42','2023-05-30 15:04:42',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:04:42','2023-05-30 15:04:42',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
INSERT INTO `calendar` VALUES (1,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-02-17 10:00:00',1,NULL,'2022-02-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(2,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-03-16 10:00:00',1,NULL,'2022-03-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(3,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-04-18 10:00:00',1,NULL,'2022-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(4,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-05-17 10:00:00',1,NULL,'2022-05-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(5,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-06-21 10:00:00',1,NULL,'2022-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(6,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-07-18 10:00:00',1,NULL,'2022-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(7,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-08-16 10:00:00',1,NULL,'2022-08-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(8,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-09-19 10:00:00',1,NULL,'2022-09-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(9,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-10-17 10:00:00',1,NULL,'2022-10-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(10,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-11-16 10:00:00',1,NULL,'2022-11-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(11,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-12-19 10:00:00',1,NULL,'2022-12-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(12,NULL,40719,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2023-01-17 10:00:00',1,NULL,'2023-01-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:35:46',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:35:46',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:35:46',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:35:46',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:35:46',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:35:46',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:46',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:46',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',2108288.01,175690.67,'No Excluida','0',30,3330,485448.92,1047.86,1047.86,4623.27,6457.26,12128.39,12128.39,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',3133941.63,261161.80,'No Excluida','0',45,5000,485448.92,2018.89,2018.89,5085.60,6457.26,13561.75,13561.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',4387518.23,365626.52,'No Excluida','0',60,6700,970897.79,3452.09,3190.00,5594.16,6457.26,15503.51,15241.42,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',5449094.55,454091.21,'No Excluida','0',85,10000,970897.79,5671.23,5239.75,6153.58,7673.13,19497.94,19066.46,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',6416528.72,534710.73,'No Excluida','0',110,13000,1209769.40,10787.67,8368.13,6768.94,9389.36,26945.97,24526.43,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',8020660.90,668388.41,'No Excluida','0',150,16500,1213622.14,14840.88,10926.38,7445.83,10850.90,33137.61,29223.11,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',9624793.05,802066.09,'No Excluida','0',200,20000,1456346.67,18878.58,13623.24,8190.41,11625.96,38694.95,33439.61,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',11916410.45,993034.20,'No Excluida','0',200,20000,1941795.53,43150.91,33442.08,9009.45,13951.15,66111.51,56402.68,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',13337213.22,1111434.44,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,53938.71,9910.39,17272.86,NULL,81121.96,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',15285088.04,1273757.34,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,63385.73,10901.43,19332.31,NULL,93619.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',16957968.71,1413164.06,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,72817.31,11991.57,22155.77,NULL,106964.65,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,7851,'Banco Citibank',NULL,'2022-11-25 19:37:49','2022-11-25 19:37:49'),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (12,7851,NULL,'Ringocho1947',NULL,1,40719,1,'2023-04-11 12:02:53','2023-04-11 12:02:53',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL),(2,NULL,'Articulo 6',6,0,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL),(3,NULL,'Articulo 7',7,0,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL),(4,NULL,'Articulo 8',8,0,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL),(5,NULL,'Articulo 9',9,0,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL),(6,NULL,'Articulo 10',10,0,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL),(7,NULL,'Articulo 11',11,0,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL),(8,NULL,'Articulo 12',12,0,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL),(9,NULL,'Articulo 13',13,0,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL),(10,NULL,'Articulo 14',14,1,'2022-09-17 16:06:04','2022-09-17 16:06:04',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:43:57','2023-03-12 23:43:57',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_centro_costo_plan_cuenta` VALUES (1,7851,1,359,NULL,NULL,NULL),(2,7851,2,163,NULL,NULL,NULL),(3,7851,2,5,NULL,NULL,NULL),(4,7851,2,483,NULL,NULL,NULL),(5,7851,2,484,NULL,NULL,NULL),(6,7851,2,482,NULL,NULL,NULL),(7,7851,3,163,NULL,NULL,NULL),(8,7851,3,5,NULL,NULL,NULL),(9,7851,3,483,NULL,NULL,NULL),(10,7851,3,482,NULL,NULL,NULL),(11,7851,3,484,NULL,NULL,NULL),(12,7851,4,483,NULL,NULL,NULL),(13,7851,4,484,NULL,NULL,NULL),(14,7851,4,482,NULL,NULL,NULL),(15,7851,4,5,NULL,NULL,NULL),(16,7851,4,163,NULL,NULL,NULL),(17,7851,5,519,NULL,NULL,NULL),(18,7851,6,512,NULL,NULL,NULL),(19,7851,7,135,NULL,NULL,NULL),(20,7851,7,485,NULL,NULL,NULL),(21,7851,7,495,NULL,NULL,NULL),(22,7851,7,489,NULL,NULL,NULL),(23,7851,7,497,NULL,NULL,NULL),(24,7851,7,492,NULL,NULL,NULL),(25,7851,7,498,NULL,NULL,NULL),(26,7851,7,501,NULL,NULL,NULL),(27,7851,7,502,NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
INSERT INTO `conta_centro_costos` VALUES (1,7851,40719,'Gastos',0,NULL,NULL,NULL),(2,7851,40719,'Administración',0,NULL,NULL,NULL),(3,7851,40719,'Operaciones',0,NULL,NULL,NULL),(4,7851,40719,'Finanzas',0,NULL,NULL,NULL),(5,7851,40719,'Administración',1,NULL,NULL,NULL),(6,7851,40719,'Operaciones',1,NULL,NULL,NULL),(7,7851,40719,'Personales',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1027 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,7851,1110139,5,1,1110100,'Caja Efectivo ARS Pesos NIMBUS','Activo',NULL,1,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL),(46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,7851,2110351,5,2,2110300,'AFIP Otros Pagos','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,7851,5110106,5,2,5110100,'1595 Sueldos','Result. Negativo',NULL,1,1,1,1,1,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,7851,5120108,5,2,5120100,'NIMBUS Actividad Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (135,7851,5120108,5,2,5120100,'NIMBUS Actividad Gastos Varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,7851,5140101,5,2,5140100,'Pers Banco Supervielle Impuesto al Debitos y Creditos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,7851,5210101,5,2,5210100,'Pers Banco Supervielle Inversiones','Result. Negativo',NULL,1,1,1,1,1,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,7851,1110215,5,1,1110200,'Banco Santander CA ARS','Activo',NULL,1,1,1,1,1,1,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,7851,1110129,5,1,1110100,'Banco Santander CC ARS','Activo',NULL,1,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,7851,5120108,5,2,5120100,'1595 SAC','Result. Negativo',NULL,1,1,1,1,1,1,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,7851,5120108,5,2,5120100,'1595 Cargas sociales','Result. Negativo',NULL,1,1,1,1,1,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,7851,5120108,5,2,5120100,'Pers Banco Supervielle Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (214,7851,5120108,5,2,5120100,'Pers Banco Supervielle Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL),(258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL),(347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,7851,5120108,5,2,5120100,'Pers Banco Supervielle Comisiones y Gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL),(438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,7851,1110214,5,1,1110200,'Banco Santander  CA USD','Activo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(482,7851,1110219,5,1,1110200,'Pers Banco Supervielle CA ARS','Activo',NULL,1,1,1,1,1,1,NULL),(483,7851,1110217,5,1,1110200,'Mercado Pago JCH CA ARS','Activo',NULL,1,1,1,1,1,1,NULL),(484,7851,1110218,5,1,1110200,'Mercado Pago WR CA ARS','Activo',NULL,1,1,1,1,1,1,NULL),(485,7851,5120108,5,2,5120100,'Personales Familia HP BBVA','Result. Negativo',NULL,1,1,1,1,1,1,NULL),(486,7851,1120117,5,1,1120100,'Banco Santander Plazo fijo','Activo',NULL,1,1,0,0,0,1,NULL),(487,7851,1120108,5,1,1120100,'Banco Supervielle FCI 1595','Activo',NULL,1,1,0,0,0,1,NULL),(488,7851,1110133,5,1,1110100,'Caja Externa WR','Activo',NULL,1,1,1,1,1,1,NULL),(489,7851,5120108,5,2,5120100,'Personales JCH','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(490,7851,4120101,5,1,4120100,'Banco Santander Plazo Fijo Intereses','Result. Positivo',NULL,1,1,1,1,1,1,NULL),(491,7851,2110125,5,2,2110100,'1595 Servicios WR','Pasivo',NULL,1,1,1,1,1,1,NULL),(492,7851,5120108,5,2,5120100,'Personales EAHP','Result. Negativo',NULL,1,1,1,1,1,1,NULL),(493,7851,5120108,5,2,5120100,'Banco Santander Tarjeta Visa','Result. Negativo',NULL,1,1,1,1,1,1,NULL),(494,7851,5120108,5,2,5120100,'Banco Santander Tarjeta AMEX','Result. Negativo',NULL,1,1,1,1,1,1,NULL),(495,7851,5120108,5,2,5120100,'Personales Familia HP','Result. Negativo',NULL,1,1,1,1,1,1,NULL),(496,7851,1120122,5,1,1120100,'Pers Banco Supervielle FCI','Activo',NULL,1,1,1,1,1,1,NULL),(497,7851,5120108,5,2,5120100,'Personales Familia HP Efectivo','Result. Negati