-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-17286574-8
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-01 20:55:39','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-01 20:55:39','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,'2023-11-23 22:22:31','2023-11-23 22:22:31',NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,'2023-11-23 22:23:23','2023-11-23 22:23:23',NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,'2023-11-23 22:23:56','2023-11-23 22:23:56',NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,'2023-11-23 22:24:13','2023-11-23 22:24:13',NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,'2023-11-23 22:24:31','2023-11-23 22:24:31',NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,'2023-11-23 22:24:45','2023-11-23 22:24:45',NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,'2023-11-23 22:24:54','2023-11-23 22:24:54',NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,'2023-11-24 01:25:37','2023-11-24 01:25:37',NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,'2023-11-23 22:26:00','2023-11-23 22:26:00',NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,'2023-11-23 22:26:32','2023-11-23 22:26:32',NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'AFIP','Marcelo2020',NULL,1,40721,'2023-01-13'),(2,NULL,'KJLFASDLFJLA{',NULL,3,40721,'2023-01-13'),(3,NULL,'CVHBSDFGB',NULL,2,40721,'2023-01-13'),(4,'AFIP','Marcelo2020',NULL,1,40721,'2023-01-13'),(5,NULL,'KJLFASDLFJLA{',NULL,3,40721,'2023-01-13'),(6,NULL,'CVHBSDFGB',NULL,2,40721,'2023-01-13'),(7,NULL,'Crhistian2020',NULL,1,40723,'2023-01-21'),(8,NULL,'Crhistian2020',NULL,1,40723,'2023-01-22'),(9,NULL,'Crhistian277',NULL,3,40723,'2023-01-22'),(10,NULL,'Crhistian2020',NULL,1,40723,'2023-01-22'),(11,NULL,'Crhistian277',NULL,3,40723,'2023-01-22'),(12,NULL,'Crhistian2020',NULL,1,40723,'2023-01-22'),(13,NULL,'Crhistian277',NULL,3,40723,'2023-01-22'),(14,NULL,'Crhistian2020',NULL,1,40723,'2023-01-22'),(15,NULL,'Crhistian277',NULL,3,40723,'2023-01-22'),(16,NULL,'Crhistian2020',NULL,1,40723,'2023-01-22'),(17,NULL,'Crhistian277',NULL,3,40723,'2023-01-22'),(18,NULL,'Crhistian2020',NULL,1,40723,'2023-01-22'),(19,NULL,'Crhistian277',NULL,3,40723,'2023-01-22'),(20,NULL,'Crhistian2020',NULL,1,40723,'2023-01-22'),(21,NULL,'Crhistian277',NULL,3,40723,'2023-01-22'),(22,NULL,'Marcelo2020',NULL,1,40720,'2023-01-22'),(23,NULL,'Marcelo2021',NULL,3,40720,'2023-01-22'),(24,NULL,'Crhistian2020',NULL,1,40723,'2023-01-22'),(25,NULL,'Crhistian277',NULL,3,40723,'2023-01-22'),(26,NULL,'Crhistian2020',NULL,1,40723,'2023-01-22'),(27,NULL,'Crhistian277',NULL,3,40723,'2023-01-22'),(28,NULL,'Avilakm2022',NULL,1,40828,'2023-02-03'),(29,NULL,'Alberto2022',NULL,3,40828,'2023-02-03'),(30,NULL,'Avilakm2022',NULL,1,40828,'2023-02-03'),(31,NULL,'Alberto2022',NULL,3,40828,'2023-02-03'),(32,NULL,'Avilakm2022',NULL,1,40828,'2023-02-04'),(33,NULL,'Alberto2022',NULL,3,40828,'2023-02-04'),(34,NULL,'Crhistian2020',NULL,1,40723,'2023-02-08'),(35,NULL,'Crhistian277',NULL,3,40723,'2023-02-08'),(36,NULL,'Marcelo2020',NULL,1,40720,'2023-05-19'),(37,NULL,'Marcelo2021',NULL,3,40720,'2023-05-19'),(38,NULL,'Marcelo2020',NULL,1,40720,'2023-05-19'),(39,NULL,'Marcelo2021',NULL,3,40720,'2023-05-19'),(40,NULL,'Marcelo2020',NULL,1,40720,'2023-05-19'),(41,NULL,'Marcelo2021',NULL,3,40720,'2023-05-19');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'atamaniuk1@hotmail.com','1130658389',NULL,1,40719,'2023-02-03'),(2,'atamaniuk1@hotmail.com',NULL,'',1,40828,'2023-02-03'),(3,'atamaniuk1@hotmail.com',NULL,'',1,40828,'2023-02-03'),(4,'atamaniuk1@hotmail.com',NULL,'',1,40828,'2023-02-04');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(5,3,2,5,1,1200000.00,'2023-10-17 20:19:35','2023-10-17 20:19:35',NULL),(6,3,2,364,2,1200000.00,'2023-10-17 20:19:35','2023-10-17 20:19:35',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,7485,2,2,'ANTICIPO DE CLIENTES',0.00,'2023-10-17 20:19:35','2023-10-17 20:19:35',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6162 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7485,40723,6064,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2632.39,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(2,7485,40723,6064,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',829.00,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(3,7485,40723,6064,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',95.00,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(4,7485,40723,6064,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2972224.92,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(5,7485,40723,6064,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',150620.97,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(6,7485,40723,6064,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',16200.00,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(7,7485,40723,6064,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',68.00,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(8,7485,40723,6064,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',258.00,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(9,7485,40723,6064,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',602.00,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(10,7485,40723,6064,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',9307.30,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(11,7485,40723,6064,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',206.61,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(12,7485,40723,6064,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',309.92,NULL,NULL,1,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(13,7485,40723,6064,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',648484.35,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(14,7485,40723,6064,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5453.09,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(15,7485,40723,6064,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',215795.98,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(16,7485,40723,6064,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4752.15,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(17,7485,40723,6064,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',20162.11,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(18,7485,40723,6064,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8355.05,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(19,7485,40723,6064,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',18069.59,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(20,7485,40723,6064,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',281107.85,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(21,7485,40723,6064,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',36027.53,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(22,7485,40723,6064,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',56250.03,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL);
INSERT INTO `balance_libro` VALUES (23,7485,40723,6064,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',124353.06,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(24,7485,40723,6064,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',46484.23,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(25,7485,40723,6064,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',56238.86,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(26,7485,40723,6064,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',916.90,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(27,7485,40723,6064,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2256.04,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(28,7485,40723,6064,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7220.44,NULL,NULL,1,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(29,7485,40723,6064,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',312744.58,NULL,NULL,1,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(30,7485,40723,6064,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',328507.20,NULL,NULL,1,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(31,7485,40723,6064,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',650267.55,NULL,NULL,1,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(32,7485,40723,6064,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',328507.20,NULL,NULL,1,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(33,7485,40723,6064,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',180137.56,NULL,NULL,1,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(34,7485,40723,6064,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4891.46,NULL,NULL,1,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(110,7485,40723,7767,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5066.50,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(111,7485,40723,7767,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',586432.92,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(112,7485,40723,7767,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',136.00,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(113,7485,40723,7767,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',513.39,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(114,7485,40723,7767,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',10633.13,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(115,7485,40723,7767,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',353.00,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(116,7485,40723,7767,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',584.00,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(117,7485,40723,7767,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',48542.49,NULL,NULL,1,'2023-01-22 19:03:12','2023-02-07 19:29:59','2023-02-07 19:29:59'),(118,7485,40723,7767,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1416.38,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL);
INSERT INTO `balance_libro` VALUES (119,7485,40723,7767,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2220.00,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(120,7485,40723,7767,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',720.00,NULL,NULL,1,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(121,7485,40723,7767,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',970780.18,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(122,7485,40723,7767,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',9067.84,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(123,7485,40723,7767,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',10329.55,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(124,7485,40723,7767,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',8524.00,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(125,7485,40723,7767,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',25760.28,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(126,7485,40723,7767,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',11272.72,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(127,7485,40723,7767,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4147.73,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(128,7485,40723,7767,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25823.35,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(129,7485,40723,7767,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2588575.19,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(130,7485,40723,7767,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',154188.73,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(131,7485,40723,7767,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',292308.54,NULL,NULL,1,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(132,7485,40723,7767,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',31196.89,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(133,7485,40723,7767,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',6051.00,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(134,7485,40723,7767,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',16865.55,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(135,7485,40723,7767,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',9068.01,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(136,7485,40723,7767,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',21682.60,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(137,7485,40723,7767,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',122417.65,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(138,7485,40723,7767,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',120897.84,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(139,7485,40723,7767,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',179640.42,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL);
INSERT INTO `balance_libro` VALUES (140,7485,40723,7767,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4233.60,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(141,7485,40723,7767,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',288230.48,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(142,7485,40723,7767,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',30604.41,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(143,7485,40723,7767,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',77301.24,NULL,NULL,1,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(144,7485,40723,7767,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',115292.19,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(145,7485,40723,7767,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',266655.82,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(146,7485,40723,7767,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',57548.74,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(147,7485,40723,7767,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',29358.00,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(148,7485,40723,7767,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1593.89,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(149,7485,40723,7767,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',25007.40,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(150,7485,40723,7767,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1006596.31,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(151,7485,40723,7767,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',119148.71,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(152,7485,40723,7767,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4185.00,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(153,7485,40723,7767,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4907.70,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(154,7485,40723,7767,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3051.00,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(155,7485,40723,7767,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',6183.00,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(156,7485,40723,7767,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',16679.70,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(157,7485,40723,7767,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2971162.08,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(158,7485,40723,7767,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',241415.40,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(159,7485,40723,7767,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',133435.23,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(160,7485,40723,7767,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',24159.79,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL);
INSERT INTO `balance_libro` VALUES (161,7485,40723,7767,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',24159.79,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(162,7485,40723,7767,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',4895.29,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(163,7485,40723,7767,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',10735.20,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(164,7485,40723,7767,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8646.20,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(165,7485,40723,7767,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',84484.72,NULL,NULL,1,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(166,7485,40828,7768,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2399.90,NULL,NULL,1,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(167,7485,40828,7768,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',18000.00,NULL,NULL,1,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(168,7485,40828,7768,3,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',8600.86,NULL,NULL,1,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(169,7485,40828,7768,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',14246.73,NULL,NULL,1,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(170,7485,40828,7768,3,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',3497.00,NULL,NULL,1,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(171,7485,40828,7768,3,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',44148.01,NULL,NULL,1,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(172,7485,40828,7768,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',28000.01,NULL,NULL,1,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(173,7485,40828,7768,3,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',18213.60,NULL,NULL,1,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(174,7485,40828,7768,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',58183.80,NULL,NULL,1,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(177,7485,40828,7768,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',75000.02,NULL,NULL,1,'2023-02-03 00:23:33','2023-02-04 18:58:21','2023-02-04 18:58:21'),(178,7485,40828,7768,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',20000.00,NULL,NULL,1,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(179,7485,40828,7768,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3772.00,NULL,NULL,1,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(180,7485,40828,7768,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',58435.10,NULL,NULL,1,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(181,7485,40828,7768,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',18685.00,NULL,NULL,1,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(182,7485,40828,7768,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',8615.06,NULL,NULL,1,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(183,7485,40828,7768,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',15890.02,NULL,NULL,1,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL);
INSERT INTO `balance_libro` VALUES (184,7485,40828,7768,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',15180.06,NULL,NULL,1,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(185,7485,40828,7768,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',18200.02,NULL,NULL,1,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(186,7485,40828,7768,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',8860.04,NULL,NULL,1,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(187,7485,40828,7768,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',14610.00,NULL,NULL,1,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(188,7485,40828,7768,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',8000.00,NULL,NULL,1,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(189,7485,40828,7768,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',14650.00,NULL,NULL,1,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(190,7485,40828,7768,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',20685.00,NULL,NULL,1,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(191,7485,40828,7768,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',9742.00,NULL,NULL,1,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(192,7485,40828,7768,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',5210.00,NULL,NULL,1,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(193,7485,40828,7768,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',15000.04,NULL,NULL,1,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(194,7485,40828,7768,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2400.02,NULL,NULL,1,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(195,7485,40828,7768,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',11443.00,NULL,NULL,1,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(196,7485,40828,7768,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',21000.02,NULL,NULL,1,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(197,7485,40828,7768,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',20000.00,NULL,NULL,1,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(198,7485,40828,7768,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',13300.00,NULL,NULL,1,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(199,7485,40828,7768,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',11500.00,NULL,NULL,1,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(200,7485,40828,7768,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',17240.04,NULL,NULL,1,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(201,7485,40828,7768,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',87200.00,NULL,NULL,1,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(202,7485,40828,7768,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',10340.06,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(203,7485,40828,7768,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3700.02,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(204,7485,40828,7768,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',16000.00,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL);
INSERT INTO `balance_libro` VALUES (205,7485,40828,7768,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',10750.00,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(206,7485,40828,7768,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20000.00,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(207,7485,40828,7768,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4900.00,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(208,7485,40828,7768,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',21190.00,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(209,7485,40828,7768,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',21500.00,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(210,7485,40828,7768,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',15090.06,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(211,7485,40828,7768,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20890.04,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(212,7485,40828,7768,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14500.02,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(213,7485,40828,7768,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',11992.04,NULL,NULL,1,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(214,7485,40828,7768,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14890.00,NULL,NULL,1,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(215,7485,40828,7768,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',10200.02,NULL,NULL,1,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(216,7485,40828,7768,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7650.04,NULL,NULL,1,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(217,7485,40828,7768,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20000.00,NULL,NULL,1,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(218,7485,40828,7768,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',17000.00,NULL,NULL,1,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(219,7485,40828,7769,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2399.90,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(220,7485,40828,7769,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12581.18,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(221,7485,40828,7769,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2909.19,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-05 18:13:13','2023-02-05 18:13:13'),(222,7485,40828,7769,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',40839.86,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(223,7485,40828,7769,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10437.90,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(224,7485,40828,7769,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3781.32,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(225,7485,40828,7769,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',87995.01,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL);
INSERT INTO `balance_libro` VALUES (226,7485,40828,7769,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',465000.00,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-04 18:40:57','2023-02-04 18:40:57'),(227,7485,40828,7769,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',19910.14,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(228,7485,40828,7769,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',428.37,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(229,7485,40828,7769,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',333556.98,NULL,NULL,1,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(230,7485,40828,7769,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',20620.00,NULL,NULL,1,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(231,7485,40828,7769,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',75000.00,NULL,NULL,1,'2023-02-03 12:41:28','2023-02-04 18:52:12','2023-02-04 18:52:12'),(232,7485,40828,7769,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',75000.02,NULL,NULL,1,'2023-02-03 12:41:28','2023-02-04 18:34:27','2023-02-04 18:34:27'),(233,7485,40828,7769,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9790.00,NULL,NULL,1,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(234,7485,40828,7769,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22000.00,NULL,NULL,1,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(235,7485,40828,7769,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',25000.00,NULL,NULL,1,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(236,7485,40828,7769,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',55420.04,NULL,NULL,1,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(237,7485,40828,7769,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21695.02,NULL,NULL,1,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(238,7485,40828,7769,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9500.00,NULL,NULL,1,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(239,7485,40828,7769,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',59900.02,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(240,7485,40828,7769,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',69736.00,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(241,7485,40828,7769,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9850.00,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(242,7485,40828,7769,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',11950.04,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(243,7485,40828,7769,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',55420.04,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(244,7485,40828,7769,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15132.00,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(245,7485,40828,7769,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23000.06,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(246,7485,40828,7769,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8830.00,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL);
INSERT INTO `balance_libro` VALUES (247,7485,40828,7769,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19000.00,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(248,7485,40828,7769,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13240.00,NULL,NULL,1,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(249,7485,40828,7769,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13800.00,NULL,NULL,1,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(250,7485,40828,7769,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',24800.00,NULL,NULL,1,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(251,7485,40828,7769,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21390.00,NULL,NULL,1,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(252,7485,40828,7769,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22300.02,NULL,NULL,1,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(253,7485,40828,7769,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20000.00,NULL,NULL,1,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(254,7485,40828,7769,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3720.00,NULL,NULL,1,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(255,7485,40828,7769,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',14000.00,NULL,NULL,1,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(256,7485,40828,7769,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17135.00,NULL,NULL,1,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(257,7485,40828,7769,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20000.00,NULL,NULL,1,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(258,7485,40828,7769,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22650.00,NULL,NULL,1,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(259,7485,40828,7769,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22500.02,NULL,NULL,1,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(260,7485,40828,7769,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20000.00,NULL,NULL,1,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(261,7485,40828,7769,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4700.00,NULL,NULL,1,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(262,7485,40828,7769,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22000.00,NULL,NULL,1,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(263,7485,40828,7769,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',27900.02,NULL,NULL,1,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(264,7485,40828,7769,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16260.08,NULL,NULL,1,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(265,7485,40828,7769,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22000.00,NULL,NULL,1,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(266,7485,40828,7769,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',28170.02,NULL,NULL,1,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(267,7485,40828,7769,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22500.02,NULL,NULL,1,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL);
INSERT INTO `balance_libro` VALUES (268,7485,40828,7769,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23750.10,NULL,NULL,1,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(269,7485,40828,7769,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',75000.00,NULL,NULL,1,'2023-02-04 18:34:27','2023-02-04 18:35:18','2023-02-04 18:35:18'),(270,7485,40828,7769,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',75000.00,NULL,NULL,1,'2023-02-04 18:35:18','2023-02-04 18:51:34','2023-02-04 18:51:34'),(271,7485,40828,7769,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',465000.00,NULL,NULL,1,'2023-02-04 18:40:57','2023-02-05 18:12:10','2023-02-05 18:12:10'),(272,7485,40828,7769,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',75000.00,NULL,NULL,1,'2023-02-04 18:51:34','2023-02-04 18:58:05','2023-02-04 18:58:05'),(273,7485,40828,7769,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',150000.00,NULL,NULL,1,'2023-02-04 18:52:12','2023-02-05 18:05:58','2023-02-05 18:05:58'),(274,7485,40828,7769,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',75000.00,NULL,NULL,1,'2023-02-04 18:58:05','2023-02-04 18:58:05',NULL),(275,7485,40828,7768,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',75000.00,NULL,NULL,1,'2023-02-04 18:58:21','2023-02-04 18:58:21',NULL),(276,7485,40828,7769,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7500.00,NULL,NULL,1,'2023-02-05 17:46:00','2023-02-05 17:47:12','2023-02-05 17:47:12'),(277,7485,40828,7769,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',75000.00,NULL,NULL,1,'2023-02-05 17:47:12','2023-02-05 17:47:12',NULL),(278,7485,40828,7769,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',465000.00,NULL,NULL,1,'2023-02-05 18:12:10','2023-02-06 15:32:04','2023-02-06 15:32:04'),(279,7485,40828,7769,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2909.19,NULL,NULL,1,'2023-02-05 18:13:13','2023-02-05 18:35:31','2023-02-05 18:35:31'),(280,7485,40828,7769,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2909.19,NULL,NULL,1,'2023-02-05 18:35:31','2023-02-06 15:39:45','2023-02-06 15:39:45'),(281,7485,40828,7769,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',465000.00,NULL,NULL,1,'2023-02-06 15:32:04','2023-02-06 15:32:04',NULL),(282,7485,40828,7769,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2909.19,NULL,NULL,1,'2023-02-06 15:39:45','2023-02-06 15:39:45',NULL),(283,7485,40723,7767,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3453.00,NULL,NULL,1,'2023-02-07 18:28:01','2023-02-07 18:28:01',NULL),(284,7485,40723,7767,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2000.00,NULL,NULL,1,'2023-02-07 18:33:33','2023-02-07 18:33:33',NULL),(285,7485,40723,7767,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',8583.01,NULL,NULL,1,'2023-02-07 18:42:05','2023-02-07 18:42:05',NULL),(286,7485,40723,7767,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',7700.84,NULL,NULL,1,'2023-02-07 18:46:00','2023-02-07 18:46:00',NULL),(287,7485,40723,7767,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',48542.49,NULL,NULL,1,'2023-02-07 19:29:59','2023-02-07 20:01:28','2023-02-07 20:01:28');
INSERT INTO `balance_libro` VALUES (288,7485,40723,7767,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',48542.49,NULL,NULL,1,'2023-02-07 20:01:28','2023-02-07 20:01:28',NULL),(289,7485,40723,6064,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3453.00,NULL,NULL,1,'2023-02-08 22:58:55','2023-02-08 23:01:52','2023-02-08 23:01:52'),(290,7485,40723,6064,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',410.00,NULL,NULL,1,'2023-02-08 23:01:12','2023-02-08 23:01:12',NULL),(291,7485,40723,6064,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3453.00,NULL,NULL,1,'2023-02-08 23:01:52','2023-02-08 23:01:52',NULL),(292,7485,40720,1555,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',121900.14,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(293,7485,40720,1555,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',205820.04,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(294,7485,40720,1555,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',151200.00,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(295,7485,40720,1555,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',264600.00,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(296,7485,40720,1555,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',569380.04,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(297,7485,40720,1555,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',320000.00,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(298,7485,40720,1555,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',81312.00,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(299,7485,40720,1555,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',64680.00,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(300,7485,40720,1555,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',23100.00,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(301,7485,40720,1555,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',150000.02,NULL,NULL,1,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(302,7485,40720,1555,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',213900.00,NULL,NULL,1,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(303,7485,40720,1555,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',38000.00,NULL,NULL,1,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(304,7485,40720,1555,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',57200.08,NULL,NULL,1,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(305,7485,40720,1555,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',300000.04,NULL,NULL,1,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(306,7485,40720,1555,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',38880.02,NULL,NULL,1,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20');
INSERT INTO `balance_libro` VALUES (307,7485,40720,1555,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',302500.00,NULL,NULL,1,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(308,7485,40720,1555,3,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',52070.00,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(309,7485,40720,1555,3,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',688109.64,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(310,7485,40720,1555,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7117.68,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(311,7485,40720,1555,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',12826.00,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(312,7485,40720,1555,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',82134.12,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(313,7485,40720,1555,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',16000.00,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(314,7485,40720,1555,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',208725.00,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(315,7485,40720,1555,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14811.60,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(316,7485,40720,1555,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',150000.00,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(317,7485,40720,1555,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',13673.00,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(318,7485,40720,1555,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',102000.27,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(319,7485,40720,1555,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',208725.00,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(320,7485,40720,1555,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',196276.18,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(321,7485,40720,1555,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',885527.89,NULL,NULL,1,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(322,7485,40720,1555,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',360653.04,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(323,7485,40720,1555,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',147364.18,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(324,7485,40720,1555,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',21960.00,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(325,7485,40720,1555,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',104798.11,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10');
INSERT INTO `balance_libro` VALUES (326,7485,40720,1555,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',99836.13,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(327,7485,40720,1555,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7009.00,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(328,7485,40720,1555,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',227325.89,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(329,7485,40720,1555,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3563.28,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(330,7485,40720,1555,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',307124.20,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(331,7485,40720,1555,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',91027.16,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(332,7485,40720,1555,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',216259.07,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(333,7485,40720,1555,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',121922.11,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(334,7485,40720,1555,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',131941.71,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(335,7485,40720,1555,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',300000.04,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(336,7485,40720,1555,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',44266.81,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(337,7485,40720,1555,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',30650.00,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(338,7485,40720,1555,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',50000.00,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(339,7485,40720,1555,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',831516.03,NULL,NULL,1,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(340,7485,40720,1555,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2016.00,NULL,NULL,1,'2023-02-19 17:24:59','2023-02-19 17:50:10','2023-02-19 17:50:10'),(341,7485,40720,1555,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',726.00,NULL,NULL,1,'2023-02-19 17:28:20','2023-10-30 20:50:10','2023-10-30 20:50:10'),(342,7485,40720,1555,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',363.00,NULL,NULL,1,'2023-02-19 17:29:43','2023-10-30 20:50:11','2023-10-30 20:50:11'),(343,7485,40720,1555,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',726.00,NULL,NULL,1,'2023-02-19 17:30:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(344,7485,40720,1555,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',363.00,NULL,NULL,1,'2023-02-19 17:30:44','2023-10-30 20:50:11','2023-10-30 20:50:11');
INSERT INTO `balance_libro` VALUES (345,7485,40720,1555,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',363.00,NULL,NULL,1,'2023-02-19 17:33:06','2023-10-30 20:50:11','2023-10-30 20:50:11'),(346,7485,40720,1555,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',108.90,NULL,NULL,1,'2023-02-19 17:33:37','2023-10-30 20:50:11','2023-10-30 20:50:11'),(347,7485,40720,1555,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',726.00,NULL,NULL,1,'2023-02-19 17:34:23','2023-10-30 20:50:11','2023-10-30 20:50:11'),(348,7485,40720,1555,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',726.00,NULL,NULL,1,'2023-02-19 17:34:50','2023-10-30 20:50:11','2023-10-30 20:50:11'),(349,7485,40720,1555,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',726.00,NULL,NULL,1,'2023-02-19 17:36:25','2023-10-30 20:50:11','2023-10-30 20:50:11'),(350,7485,40720,1555,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',11610.00,NULL,NULL,1,'2023-02-19 17:38:29','2023-10-30 20:50:11','2023-10-30 20:50:11'),(351,7485,40720,1555,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',11938.95,NULL,NULL,1,'2023-02-19 17:43:06','2023-02-19 17:47:28','2023-02-19 17:47:28'),(352,7485,40720,1555,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2976.00,NULL,NULL,1,'2023-02-19 17:45:48','2023-10-30 20:50:11','2023-10-30 20:50:11'),(353,7485,40720,1555,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',11938.95,NULL,NULL,1,'2023-02-19 17:47:28','2023-10-30 20:50:11','2023-10-30 20:50:11'),(354,7485,40720,1555,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2016.00,NULL,NULL,1,'2023-02-19 17:56:56','2023-10-30 20:50:11','2023-10-30 20:50:11'),(355,7485,40828,7770,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2499.91,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(356,7485,40828,7770,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',10536.80,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(357,7485,40828,7770,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',57963.92,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(358,7485,40828,7770,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',58183.80,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(359,7485,40828,7770,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',172346.80,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(360,7485,40828,7770,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',3781.32,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(361,7485,40828,7770,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',10209.17,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(362,7485,40828,7770,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',15295.58,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(363,7485,40828,7770,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',96567.60,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(364,7485,40828,7770,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',599.43,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL);
INSERT INTO `balance_libro` VALUES (365,7485,40828,7770,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7569.02,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(366,7485,40828,7770,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1384.55,NULL,NULL,1,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(391,7485,40828,7770,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',75000.02,NULL,NULL,1,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(392,7485,40828,7770,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',75000.02,NULL,NULL,1,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(393,7485,40828,7770,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',75000.02,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(394,7485,40828,7770,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',75000.02,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(395,7485,40828,7770,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30500.14,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(396,7485,40828,7770,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',83430.04,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(397,7485,40828,7770,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(398,7485,40828,7770,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(399,7485,40828,7770,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',29000.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(400,7485,40828,7770,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',17140.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(401,7485,40828,7770,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',29050.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(402,7485,40828,7770,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(403,7485,40828,7770,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',25000.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(404,7485,40828,7770,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(405,7485,40828,7770,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',2200.02,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(406,7485,40828,7770,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',61300.08,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(407,7485,40828,7770,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(408,7485,40828,7770,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',28400.06,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(409,7485,40828,7770,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',26250.06,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL);
INSERT INTO `balance_libro` VALUES (410,7485,40828,7770,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(411,7485,40828,7770,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30000.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(412,7485,40828,7770,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(413,7485,40828,7770,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',26250.06,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(414,7485,40828,7770,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(415,7485,40828,7770,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',28000.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(416,7485,40828,7770,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(417,7485,40828,7770,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(418,7485,40828,7770,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',26250.06,NULL,NULL,1,'2023-03-17 19:40:50','2023-04-18 16:29:25','2023-04-18 16:29:25'),(419,7485,40828,7770,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:23:02','2023-04-18 16:23:02'),(420,7485,40828,7770,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:22:43','2023-04-18 16:22:43'),(421,7485,40828,7770,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',29500.00,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:22:13','2023-04-18 16:22:13'),(422,7485,40828,7770,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30000.00,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:21:47','2023-04-18 16:21:47'),(423,7485,40828,7770,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30000.00,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:21:24','2023-04-18 16:21:24'),(424,7485,40828,7770,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:18:50','2023-04-18 16:18:50'),(425,7485,40828,7770,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',45900.04,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:19:20','2023-04-18 16:19:20'),(426,7485,40828,7770,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:18:09','2023-04-18 16:18:09'),(427,7485,40828,7770,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30000.00,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:17:44','2023-04-18 16:17:44'),(428,7485,40828,7770,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30700.00,NULL,NULL,1,'2023-03-17 19:40:51','2023-04-18 16:17:10','2023-04-18 16:17:10'),(462,7485,40723,6065,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11738.22,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL);
INSERT INTO `balance_libro` VALUES (463,7485,40723,6065,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1063380.77,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(464,7485,40723,6065,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',71960.09,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(465,7485,40723,6065,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6323.46,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(466,7485,40723,6065,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3542.54,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(467,7485,40723,6065,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',219037.80,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(468,7485,40723,6065,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1045372.62,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(469,7485,40723,6065,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',18110.44,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(470,7485,40723,6065,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3504.99,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(471,7485,40723,6065,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',20021.72,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(472,7485,40723,6065,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',3804.95,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(473,7485,40723,6065,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',203239.24,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(474,7485,40723,6065,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',10010.86,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(475,7485,40723,6065,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',449658.85,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(476,7485,40723,6065,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',20021.72,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(477,7485,40723,6065,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',143307.56,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(478,7485,40723,6065,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',12096.10,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(479,7485,40723,6065,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',24069.10,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(480,7485,40723,6065,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',40684.07,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(481,7485,40723,6065,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',922.16,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(482,7485,40723,6065,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',151905.86,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(483,7485,40723,6065,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',143307.60,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL);
INSERT INTO `balance_libro` VALUES (484,7485,40723,6065,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',2716.82,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(485,7485,40723,6065,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',692159.11,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(486,7485,40723,6065,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',140984.10,NULL,NULL,1,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(487,7485,40723,6065,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',152756.70,NULL,NULL,1,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(488,7485,40723,6065,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',17902.20,NULL,NULL,1,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(522,7485,40723,6065,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6439.08,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(523,7485,40723,6065,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',69325.30,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(524,7485,40723,6065,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',44007.67,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(525,7485,40723,6065,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1818.00,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(526,7485,40723,6065,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',204.00,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(527,7485,40723,6065,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',285.00,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(528,7485,40723,6065,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',84000.06,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(529,7485,40723,6065,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3277261.15,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(530,7485,40723,6065,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3850.00,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(531,7485,40723,6065,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',259890.96,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(532,7485,40723,6065,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',145170.34,NULL,NULL,1,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(533,7485,40723,6065,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',13867.04,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(534,7485,40723,6065,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3850.00,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(535,7485,40723,6065,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',3400.00,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(536,7485,40723,6065,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',10400.28,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(537,7485,40723,6065,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',63355.02,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL);
INSERT INTO `balance_libro` VALUES (538,7485,40723,6065,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',31217.58,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(539,7485,40723,6065,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',12536.74,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-23 10:12:06','2023-03-23 10:12:06'),(540,7485,40723,6065,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',204.00,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(541,7485,40723,6065,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',190.00,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(542,7485,40723,6065,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',742.00,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(543,7485,40723,6065,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',602.00,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(544,7485,40723,6065,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',8342.69,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(545,7485,40723,6065,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',600.00,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(546,7485,40723,6065,3,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',9013.57,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(547,7485,40723,6065,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',97328.40,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(548,7485,40723,6065,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',9971.95,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(549,7485,40723,6065,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',120.00,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(550,7485,40723,6065,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',376038.01,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(551,7485,40723,6065,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',192858.42,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(552,7485,40723,6065,3,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1642.55,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(553,7485,40723,6065,3,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2021.82,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(554,7485,40723,6065,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1800.00,NULL,NULL,1,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(555,7485,40723,6065,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3453.00,NULL,NULL,1,'2023-03-19 15:05:50','2023-03-19 15:05:50',NULL),(556,7485,40723,6065,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',12536.74,NULL,NULL,1,'2023-03-23 10:12:06','2023-03-23 10:12:06',NULL),(557,7485,40720,1556,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',44665.31,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(558,7485,40720,1556,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',16000.00,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11');
INSERT INTO `balance_libro` VALUES (559,7485,40720,1556,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',91709.97,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(560,7485,40720,1556,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',9103.98,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(561,7485,40720,1556,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',14811.60,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(562,7485,40720,1556,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',996723.09,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(563,7485,40720,1556,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',13617.53,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(564,7485,40720,1556,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',530232.89,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(565,7485,40720,1556,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',28756.13,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(566,7485,40720,1556,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',130152.32,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(567,7485,40720,1556,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',119697.13,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(568,7485,40720,1556,3,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',856291.44,NULL,NULL,1,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(569,7485,40720,1556,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',3563.28,NULL,NULL,1,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(570,7485,40720,1556,3,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',58001.35,NULL,NULL,1,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(571,7485,40720,1556,3,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',85885.00,NULL,NULL,1,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(572,7485,40720,1556,3,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',14011.80,NULL,NULL,1,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(573,7485,40720,1556,3,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',192066.20,NULL,NULL,1,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(574,7485,40720,1556,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',142912.89,NULL,NULL,1,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(575,7485,40720,1556,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',332871.00,NULL,NULL,1,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(576,7485,40720,1556,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',235600.04,NULL,NULL,1,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(577,7485,40720,1556,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',220000.02,NULL,NULL,1,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20');
INSERT INTO `balance_libro` VALUES (578,7485,40720,1556,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',27951.00,NULL,NULL,1,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(579,7485,40720,1556,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',300000.04,NULL,NULL,1,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(580,7485,40720,1556,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',96558.00,NULL,NULL,1,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(581,7485,40720,1556,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',40700.04,NULL,NULL,1,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(582,7485,40720,1556,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',99000.02,NULL,NULL,1,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(583,7485,40720,1556,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',100000.00,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(584,7485,40720,1556,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',261000.00,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(585,7485,40720,1556,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',725000.04,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(586,7485,40720,1556,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',85050.00,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(587,7485,40720,1556,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',110000.02,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(588,7485,40720,1556,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',25200.00,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(589,7485,40720,1556,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',169400.00,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(590,7485,40720,1556,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',57750.04,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(591,7485,40720,1556,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',84000.00,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(592,7485,40720,1556,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',136168.20,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(593,7485,40720,1556,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',123480.00,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(594,7485,40720,1556,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',302400.00,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(595,7485,40720,1556,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',302400.00,NULL,NULL,1,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(596,7485,40720,1556,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11549.70,NULL,NULL,1,'2023-03-26 15:07:45','2023-03-26 15:44:46','2023-03-26 15:44:46');
INSERT INTO `balance_libro` VALUES (597,7485,40720,1556,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9839.40,NULL,NULL,1,'2023-03-26 15:15:33','2023-03-26 16:19:47','2023-03-26 16:19:47'),(598,7485,40720,1556,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3540.53,NULL,NULL,1,'2023-03-26 15:17:58','2023-03-26 16:00:57','2023-03-26 16:00:57'),(599,7485,40720,1556,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3279.80,NULL,NULL,1,'2023-03-26 15:36:40','2023-03-26 15:43:08','2023-03-26 15:43:08'),(600,7485,40720,1556,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',363.00,NULL,NULL,1,'2023-03-26 15:38:07','2023-03-26 16:19:31','2023-03-26 16:19:31'),(601,7485,40720,1556,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',363.00,NULL,NULL,1,'2023-03-26 15:38:50','2023-03-26 16:19:22','2023-03-26 16:19:22'),(602,7485,40720,1556,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1089.00,NULL,NULL,1,'2023-03-26 15:40:03','2023-03-26 16:19:01','2023-03-26 16:19:01'),(603,7485,40720,1556,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3279.80,NULL,NULL,1,'2023-03-26 15:43:08','2023-03-26 16:19:36','2023-03-26 16:19:36'),(604,7485,40720,1556,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11549.70,NULL,NULL,1,'2023-03-26 15:44:46','2023-03-26 15:59:11','2023-03-26 15:59:11'),(605,7485,40720,1556,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11549.70,NULL,NULL,1,'2023-03-26 15:59:11','2023-03-26 16:19:52','2023-03-26 16:19:52'),(606,7485,40720,1556,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7074.00,NULL,NULL,1,'2023-03-26 16:00:57','2023-03-26 16:19:41','2023-03-26 16:19:41'),(607,7485,40720,1556,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11549.70,NULL,NULL,1,'2023-03-26 16:22:07','2023-10-30 20:50:12','2023-10-30 20:50:12'),(608,7485,40720,1556,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9839.40,NULL,NULL,1,'2023-03-26 16:23:10','2023-10-30 20:50:12','2023-10-30 20:50:12'),(609,7485,40720,1556,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7074.00,NULL,NULL,1,'2023-03-26 16:24:13','2023-10-30 20:50:12','2023-10-30 20:50:12'),(610,7485,40720,1556,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3279.80,NULL,NULL,1,'2023-03-26 16:25:52','2023-10-30 20:50:12','2023-10-30 20:50:12'),(611,7485,40720,1556,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',363.00,NULL,NULL,1,'2023-03-26 16:29:50','2023-10-30 20:50:12','2023-10-30 20:50:12'),(612,7485,40720,1556,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',363.00,NULL,NULL,1,'2023-03-26 16:30:13','2023-10-30 20:50:12','2023-10-30 20:50:12'),(613,7485,40720,1556,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1089.00,NULL,NULL,1,'2023-03-26 16:30:30','2023-10-30 20:50:12','2023-10-30 20:50:12'),(614,7485,40828,7771,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',12608.01,NULL,NULL,1,'2023-04-18 16:08:39','2023-04-18 16:08:39',NULL),(615,7485,40828,7771,3,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2399.90,NULL,NULL,1,'2023-04-18 16:08:39','2023-04-18 16:08:39',NULL),(616,7485,40828,7771,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2909.19,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL);
INSERT INTO `balance_libro` VALUES (617,7485,40828,7771,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',10439.34,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(618,7485,40828,7771,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',72683.75,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(619,7485,40828,7771,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',10680.00,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(620,7485,40828,7771,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',82670.31,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(621,7485,40828,7771,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',15129.65,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(622,7485,40828,7771,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',4330.01,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(623,7485,40828,7771,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',11857.10,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(624,7485,40828,7771,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',31192.56,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(625,7485,40828,7771,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',101283.06,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(626,7485,40828,7771,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6499.00,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(627,7485,40828,7771,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',16499.00,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(628,7485,40828,7771,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',7999.12,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(629,7485,40828,7771,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',25817.12,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(630,7485,40828,7771,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',10439.75,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(631,7485,40828,7771,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4385.34,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(632,7485,40828,7771,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',626.97,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(633,7485,40828,7771,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2023.56,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(634,7485,40828,7771,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',33901.37,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(635,7485,40828,7771,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2360.00,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(636,7485,40828,7771,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',58183.80,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(637,7485,40828,7771,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',26082.22,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL);
INSERT INTO `balance_libro` VALUES (638,7485,40828,7771,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',43960.00,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(639,7485,40828,7771,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',40899.00,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(640,7485,40828,7771,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',118890.38,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(641,7485,40828,7771,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',2315.39,NULL,NULL,1,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(642,7485,40828,7771,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',111408.81,NULL,NULL,1,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(643,7485,40828,7771,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',2909.19,NULL,NULL,1,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(644,7485,40828,7771,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',96715.77,NULL,NULL,1,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(645,7485,40828,7771,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',416687.49,NULL,NULL,1,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(658,7485,40828,7770,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',30700.00,NULL,NULL,1,'2023-04-18 16:17:10','2023-04-18 16:17:10',NULL),(659,7485,40828,7770,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',30000.00,NULL,NULL,1,'2023-04-18 16:17:44','2023-04-18 16:17:44',NULL),(660,7485,40828,7770,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',30700.00,NULL,NULL,1,'2023-04-18 16:18:09','2023-04-18 16:18:09',NULL),(661,7485,40828,7770,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',30700.00,NULL,NULL,1,'2023-04-18 16:18:50','2023-04-18 16:18:50',NULL),(662,7485,40828,7770,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',45900.04,NULL,NULL,1,'2023-04-18 16:19:20','2023-04-18 16:19:20',NULL),(663,7485,40828,7770,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',30000.00,NULL,NULL,1,'2023-04-18 16:21:24','2023-04-18 16:21:24',NULL),(664,7485,40828,7770,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',30000.00,NULL,NULL,1,'2023-04-18 16:21:47','2023-04-18 16:21:47',NULL),(665,7485,40828,7770,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',29500.00,NULL,NULL,1,'2023-04-18 16:22:13','2023-04-18 16:22:13',NULL),(666,7485,40828,7770,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',30700.00,NULL,NULL,1,'2023-04-18 16:22:43','2023-04-18 16:22:43',NULL),(667,7485,40828,7770,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',30700.00,NULL,NULL,1,'2023-04-18 16:23:02','2023-04-18 16:23:02',NULL),(668,7485,40828,7770,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',26250.06,NULL,NULL,1,'2023-04-18 16:29:25','2023-04-18 16:29:25',NULL),(681,7485,40828,7771,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3600.08,NULL,NULL,1,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(682,7485,40828,7771,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',80000.02,NULL,NULL,1,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL);
INSERT INTO `balance_libro` VALUES (683,7485,40828,7771,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',80000.02,NULL,NULL,1,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(684,7485,40828,7771,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',75840.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(685,7485,40828,7771,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30750.04,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(686,7485,40828,7771,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9300.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(687,7485,40828,7771,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',79900.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(688,7485,40828,7771,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',21500.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(689,7485,40828,7771,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',21550.08,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(690,7485,40828,7771,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30700.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(691,7485,40828,7771,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',50900.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(692,7485,40828,7771,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',19310.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(693,7485,40828,7771,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30700.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(694,7485,40828,7771,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',56670.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(695,7485,40828,7771,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',21190.08,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(696,7485,40828,7771,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30500.02,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(697,7485,40828,7771,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30700.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(698,7485,40828,7771,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30700.00,NULL,NULL,1,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(699,7485,40723,6066,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',692743.14,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(700,7485,40723,6066,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',307590.46,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(701,7485,40723,6066,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',204.00,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(702,7485,40723,6066,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',95.00,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(703,7485,40723,6066,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',729783.57,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL);
INSERT INTO `balance_libro` VALUES (704,7485,40723,6066,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',602.00,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(705,7485,40723,6066,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',855.00,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(706,7485,40723,6066,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',9407.52,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(707,7485,40723,6066,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',25019.35,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(708,7485,40723,6066,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',262957.13,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(709,7485,40723,6066,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',542179.69,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(710,7485,40723,6066,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',34728.00,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(711,7485,40723,6066,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',705474.12,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(712,7485,40723,6066,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',16100.00,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(713,7485,40723,6066,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',380.00,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(714,7485,40723,6066,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',68.00,NULL,NULL,1,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(715,7485,40723,6066,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',340.00,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(716,7485,40723,6066,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1474.90,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(717,7485,40723,6066,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',207107.98,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(718,7485,40723,6066,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1162.00,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(719,7485,40723,6066,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',184848.17,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(720,7485,40723,6066,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',81183.53,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(721,7485,40723,6066,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',10800.01,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(722,7485,40723,6066,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',37499.00,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(723,7485,40723,6066,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',40820.16,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(724,7485,40723,6066,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',10860.00,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL);
INSERT INTO `balance_libro` VALUES (725,7485,40723,6066,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',180.00,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(726,7485,40723,6066,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',74846.32,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(727,7485,40723,6066,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5590.01,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(728,7485,40723,6066,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',200.00,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(729,7485,40723,6066,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',19882.02,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(730,7485,40723,6066,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',41000.00,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(731,7485,40723,6066,3,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',32345.60,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(732,7485,40723,6066,3,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',441775.88,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(733,7485,40723,6066,3,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',223241.45,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(734,7485,40723,6066,3,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',6163.50,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(735,7485,40723,6066,3,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',142340.89,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(736,7485,40723,6066,3,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',36341.90,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(737,7485,40723,6066,3,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5707.00,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(738,7485,40723,6066,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8600.29,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(739,7485,40723,6066,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9000.00,NULL,NULL,1,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(740,7485,40723,6066,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1811868.42,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(741,7485,40723,6066,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2296.93,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(742,7485,40723,6066,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2296.93,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(743,7485,40723,6066,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',29036.37,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(744,7485,40723,6066,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',44801.52,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(745,7485,40723,6066,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',297974.28,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL);
INSERT INTO `balance_libro` VALUES (746,7485,40723,6066,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',16145.90,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(747,7485,40723,6066,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',190902.08,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(748,7485,40723,6066,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1779.34,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(749,7485,40723,6066,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',309069.97,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(750,7485,40723,6066,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',12576.70,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(751,7485,40723,6066,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4113.37,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(752,7485,40723,6066,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1083708.64,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(753,7485,40723,6066,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',165585.40,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(754,7485,40723,6066,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',114839.17,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(755,7485,40723,6066,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',4743.21,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(756,7485,40723,6066,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',17122.60,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(757,7485,40723,6066,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',10909.82,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(758,7485,40723,6066,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1001.14,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(759,7485,40723,6066,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',150803.47,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(760,7485,40723,6066,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',91662.85,NULL,NULL,1,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(761,7485,40723,6066,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',285608.12,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(762,7485,40723,6066,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',23130.26,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(763,7485,40723,6066,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2241.68,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(764,7485,40723,6066,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',19098.05,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(765,7485,40723,6066,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',2687.10,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(766,7485,40723,6066,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',488897.52,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL);
INSERT INTO `balance_libro` VALUES (767,7485,40723,6066,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',59721.06,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(768,7485,40723,6066,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',25012.56,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(769,7485,40723,6066,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1833.94,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(770,7485,40723,6066,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',55057.90,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(771,7485,40723,6066,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9900.00,NULL,NULL,1,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(800,7485,40720,1557,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',56700.04,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(801,7485,40720,1557,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',84000.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(802,7485,40720,1557,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',13500.06,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(803,7485,40720,1557,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',14000.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(804,7485,40720,1557,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',15390.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(805,7485,40720,1557,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',20790.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(806,7485,40720,1557,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',15840.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(807,7485,40720,1557,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',25920.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(808,7485,40720,1557,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',37800.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(809,7485,40720,1557,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',14223.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(810,7485,40720,1557,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',21200.02,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(811,7485,40720,1557,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',25200.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(812,7485,40720,1557,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',17600.06,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(813,7485,40720,1557,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',13200.02,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(814,7485,40720,1557,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',28350.02,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56');
INSERT INTO `balance_libro` VALUES (815,7485,40720,1557,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',12375.04,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(816,7485,40720,1557,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',14520.00,NULL,NULL,1,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(817,7485,40720,1557,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',24000.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(818,7485,40720,1557,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',14520.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(819,7485,40720,1557,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',13200.02,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(820,7485,40720,1557,2,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',15400.04,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(821,7485,40720,1557,2,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',22680.02,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(822,7485,40720,1557,2,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',7400.02,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(823,7485,40720,1557,2,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',14520.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(824,7485,40720,1557,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',21375.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(825,7485,40720,1557,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',16200.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(826,7485,40720,1557,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',17850.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(827,7485,40720,1557,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',15400.04,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(828,7485,40720,1557,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',17850.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(829,7485,40720,1557,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',20500.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(830,7485,40720,1557,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',19440.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(831,7485,40720,1557,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',17820.04,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(832,7485,40720,1557,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',18000.04,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(833,7485,40720,1557,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',16940.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57');
INSERT INTO `balance_libro` VALUES (834,7485,40720,1557,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',24000.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(835,7485,40720,1557,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',17850.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(836,7485,40720,1557,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',12375.04,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(837,7485,40720,1557,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',52000.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(838,7485,40720,1557,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',22400.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(839,7485,40720,1557,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',9450.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(840,7485,40720,1557,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',19600.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(841,7485,40720,1557,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',15000.04,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(842,7485,40720,1557,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',13500.06,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(843,7485,40720,1557,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',22000.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(844,7485,40720,1557,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',44800.04,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(845,7485,40720,1557,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',30800.00,NULL,NULL,1,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(846,7485,40720,1557,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',22650.00,NULL,NULL,1,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(847,7485,40720,1557,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',12600.04,NULL,NULL,1,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(848,7485,40720,1557,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',25600.06,NULL,NULL,1,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(849,7485,40720,1557,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',730800.02,NULL,NULL,1,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(850,7485,40720,1557,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',508200.00,NULL,NULL,1,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(851,7485,40720,1557,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1056500.00,NULL,NULL,1,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(852,7485,40720,1557,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',725000.04,NULL,NULL,1,'2023-04-23 18:45:16','2023-10-30 20:21:58','2023-10-30 20:21:58');
INSERT INTO `balance_libro` VALUES (853,7485,40720,1557,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',315577.64,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(854,7485,40720,1557,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',73460.65,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(855,7485,40720,1557,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',9306.45,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(856,7485,40720,1557,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',14811.60,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(857,7485,40720,1557,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',29427.20,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(858,7485,40720,1557,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',16000.00,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(859,7485,40720,1557,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',200000.00,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(860,7485,40720,1557,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',43932.80,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(861,7485,40720,1557,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',64243.48,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(862,7485,40720,1557,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',318593.00,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(863,7485,40720,1557,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',142141.31,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(864,7485,40720,1557,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',606673.52,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(865,7485,40720,1557,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',6020.28,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(866,7485,40720,1557,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',27467.18,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(867,7485,40720,1557,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',74080.08,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(868,7485,40720,1557,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',71570.17,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(869,7485,40720,1557,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',115325.06,NULL,NULL,1,'2023-04-23 18:52:57','2023-05-04 18:36:45','2023-05-04 18:36:45'),(870,7485,40720,1557,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1262910.43,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(871,7485,40720,1557,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',103695.00,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12');
INSERT INTO `balance_libro` VALUES (872,7485,40720,1557,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',21973.75,NULL,NULL,1,'2023-04-23 18:52:57','2023-05-04 18:36:34','2023-05-04 18:36:34'),(873,7485,40720,1557,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',228804.95,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(874,7485,40720,1557,3,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',427756.95,NULL,NULL,1,'2023-04-23 18:52:57','2023-10-30 20:50:12','2023-10-30 20:50:12'),(875,7485,40720,1557,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',299313.48,NULL,NULL,1,'2023-04-23 18:52:57','2023-05-04 18:36:22','2023-05-04 18:36:22'),(876,7485,40720,1557,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',385101.30,NULL,NULL,1,'2023-04-23 18:52:58','2023-05-04 18:36:10','2023-05-04 18:36:10'),(877,7485,40720,1557,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',60680.00,NULL,NULL,1,'2023-04-23 18:52:58','2023-05-04 18:35:55','2023-05-04 18:35:55'),(878,7485,40720,1557,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',261150.22,NULL,NULL,1,'2023-04-23 18:52:58','2023-10-30 20:50:13','2023-10-30 20:50:13'),(879,7485,40720,1557,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',60000.00,NULL,NULL,1,'2023-04-23 18:52:58','2023-10-30 20:50:13','2023-10-30 20:50:13'),(880,7485,40720,1557,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',9237.70,NULL,NULL,1,'2023-04-23 19:04:48','2023-04-23 19:06:29','2023-04-23 19:06:29'),(881,7485,40720,1557,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',2904.00,NULL,NULL,1,'2023-04-23 19:05:52','2023-04-23 19:06:47','2023-04-23 19:06:47'),(882,7485,40720,1557,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',9237.70,NULL,NULL,1,'2023-04-23 19:06:29','2023-10-30 20:50:13','2023-10-30 20:50:13'),(883,7485,40720,1557,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',2976.00,NULL,NULL,1,'2023-04-23 19:06:47','2023-10-30 20:50:13','2023-10-30 20:50:13'),(884,7485,40720,1557,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',363.00,NULL,NULL,1,'2023-04-23 19:10:59','2023-10-30 20:50:13','2023-10-30 20:50:13'),(885,7485,40720,1557,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',363.00,NULL,NULL,1,'2023-04-23 19:12:13','2023-10-30 20:50:13','2023-10-30 20:50:13'),(886,7485,40720,1557,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2178.00,NULL,NULL,1,'2023-04-23 19:13:06','2023-10-30 20:50:13','2023-10-30 20:50:13'),(887,7485,40720,1557,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2541.00,NULL,NULL,1,'2023-04-23 19:14:03','2023-05-04 18:34:18','2023-05-04 18:34:18'),(888,7485,40720,1557,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',726.00,NULL,NULL,1,'2023-04-23 19:14:35','2023-10-30 20:50:13','2023-10-30 20:50:13'),(889,7485,40720,1557,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1089.00,NULL,NULL,1,'2023-04-23 19:15:12','2023-10-30 20:50:13','2023-10-30 20:50:13'),(890,7485,40720,1557,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1089.00,NULL,NULL,1,'2023-04-23 19:15:34','2023-05-04 18:33:43','2023-05-04 18:33:43');
INSERT INTO `balance_libro` VALUES (951,7485,40720,1558,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',82.23,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:33:50','2023-05-04 18:33:50'),(952,7485,40720,1558,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1644.75,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:33:34','2023-05-04 18:33:34'),(953,7485,40720,1558,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',603.46,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:33:26','2023-05-04 18:33:26'),(954,7485,40720,1558,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',78.78,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:33:57','2023-05-04 18:33:57'),(955,7485,40720,1558,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',75.31,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:35:30','2023-05-04 18:35:30'),(956,7485,40720,1558,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3417.48,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:33:10','2023-05-04 18:33:10'),(957,7485,40720,1558,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',22.75,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:33:16','2023-05-04 18:33:16'),(958,7485,40720,1558,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',387.30,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:33:04','2023-05-04 18:33:04'),(959,7485,40720,1558,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',336.10,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:31:33','2023-05-04 18:31:33'),(960,7485,40720,1558,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',908.54,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:31:26','2023-05-04 18:31:26'),(961,7485,40720,1558,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',241.45,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:31:15','2023-05-04 18:31:15'),(962,7485,40720,1558,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',201.51,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:31:03','2023-05-04 18:31:03'),(963,7485,40720,1558,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',42.06,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:30:26','2023-05-04 18:30:26'),(964,7485,40720,1558,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',606.68,NULL,NULL,1,'2023-05-04 16:15:50','2023-05-04 18:30:19','2023-05-04 18:30:19'),(965,7485,40720,1558,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8.89,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:30:12','2023-05-04 18:30:12'),(966,7485,40720,1558,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8.89,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:30:05','2023-05-04 18:30:05'),(967,7485,40720,1558,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',4.77,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:29:57','2023-05-04 18:29:57'),(968,7485,40720,1558,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8.89,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:29:41','2023-05-04 18:29:41'),(969,7485,40720,1558,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',99.06,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:29:32','2023-05-04 18:29:32');
INSERT INTO `balance_libro` VALUES (970,7485,40720,1558,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8.89,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:28:54','2023-05-04 18:28:54'),(971,7485,40720,1558,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',89.00,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:28:47','2023-05-04 18:28:47'),(972,7485,40720,1558,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',244.00,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:28:38','2023-05-04 18:28:38'),(973,7485,40720,1558,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',978.94,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:28:28','2023-05-04 18:28:28'),(974,7485,40720,1558,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',196.81,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:27:38','2023-05-04 18:27:38'),(975,7485,40720,1558,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',80.05,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:27:26','2023-05-04 18:27:26'),(976,7485,40720,1558,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',381.72,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:27:15','2023-05-04 18:27:15'),(977,7485,40720,1558,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',221.04,NULL,NULL,1,'2023-05-04 16:15:51','2023-05-04 18:27:06','2023-05-04 18:27:06'),(978,7485,40720,1558,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',212.50,NULL,NULL,1,'2023-05-04 16:15:52','2023-05-04 18:26:57','2023-05-04 18:26:57'),(979,7485,40720,1558,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',50.15,NULL,NULL,1,'2023-05-04 16:15:52','2023-05-04 18:26:50','2023-05-04 18:26:50'),(980,7485,40720,1558,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',558.00,NULL,NULL,1,'2023-05-04 16:15:52','2023-05-04 18:26:41','2023-05-04 18:26:41'),(1309,7485,40720,1558,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',100.06,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:45','2023-05-04 18:24:45'),(1310,7485,40720,1558,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',22.68,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:45','2023-05-04 18:24:45'),(1311,7485,40720,1558,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',15.40,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:45','2023-05-04 18:24:45'),(1312,7485,40720,1558,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12.60,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:45','2023-05-04 18:24:45'),(1313,7485,40720,1558,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',26.70,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:45','2023-05-04 18:24:45'),(1314,7485,40720,1558,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',40.70,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:45','2023-05-04 18:24:45'),(1315,7485,40720,1558,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',19.25,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1316,7485,40720,1558,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',25.14,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46');
INSERT INTO `balance_libro` VALUES (1317,7485,40720,1558,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',40.70,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1318,7485,40720,1558,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12.00,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1319,7485,40720,1558,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',41.16,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1320,7485,40720,1558,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',38.00,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1321,7485,40720,1558,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',25.65,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1322,7485,40720,1558,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',19.50,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1323,7485,40720,1558,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',15.84,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1324,7485,40720,1558,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',16.00,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1325,7485,40720,1558,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',27.76,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1326,7485,40720,1558,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',33.00,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1327,7485,40720,1558,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',28.35,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1328,7485,40720,1558,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',28.60,NULL,NULL,1,'2023-05-04 16:18:52','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1329,7485,40720,1558,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',9.45,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1330,7485,40720,1558,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',49.00,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1331,7485,40720,1558,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',31.90,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1332,7485,40720,1558,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',39.70,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1333,7485,40720,1558,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',609.00,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1334,7485,40720,1558,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',38.00,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1335,7485,40720,1558,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',26.46,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46');
INSERT INTO `balance_libro` VALUES (1336,7485,40720,1558,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',38.00,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1337,7485,40720,1558,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',27.72,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1338,7485,40720,1558,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',25.20,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1339,7485,40720,1558,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',32.40,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1340,7485,40720,1558,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',20.53,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1341,7485,40720,1558,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',9.20,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1342,7485,40720,1558,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',42.52,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1343,7485,40720,1558,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',19.80,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1344,7485,40720,1558,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',32.34,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1345,7485,40720,1558,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',31.35,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1346,7485,40720,1558,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',39.72,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1347,7485,40720,1558,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',28.50,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1348,7485,40720,1558,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',33.88,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1349,7485,40720,1558,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',21.99,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1350,7485,40720,1558,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',25.08,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1351,7485,40720,1558,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',18.90,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1352,7485,40720,1558,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',26.70,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1353,7485,40720,1558,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',23.33,NULL,NULL,1,'2023-05-04 16:18:53','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1354,7485,40720,1558,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',16.00,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46');
INSERT INTO `balance_libro` VALUES (1355,7485,40720,1558,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',30.45,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1356,7485,40720,1558,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',24.28,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1357,7485,40720,1558,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',145.00,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1358,7485,40720,1558,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',28.56,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1359,7485,40720,1558,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',34.83,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1360,7485,40720,1558,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',34.20,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1361,7485,40720,1558,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',30.80,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1362,7485,40720,1558,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',21.40,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1363,7485,40720,1558,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',190.45,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1364,7485,40720,1558,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',26.40,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1365,7485,40720,1558,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',25.20,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1366,7485,40720,1558,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',42.29,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1367,7485,40720,1558,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',26.00,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1368,7485,40720,1558,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',32.34,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:46','2023-05-04 18:24:46'),(1369,7485,40720,1558,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',39.20,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1370,7485,40720,1558,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',32.34,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1371,7485,40720,1558,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',240.00,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1372,7485,40720,1558,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',39.20,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1373,7485,40720,1558,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',35.60,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:47','2023-05-04 18:24:47');
INSERT INTO `balance_libro` VALUES (1374,7485,40720,1558,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',13.33,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1375,7485,40720,1558,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',27.72,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1376,7485,40720,1558,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',32.02,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1377,7485,40720,1558,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',13.33,NULL,NULL,1,'2023-05-04 16:18:54','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1378,7485,40720,1558,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',2111.94,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1379,7485,40720,1558,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',16.00,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1380,7485,40720,1558,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',41.16,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1381,7485,40720,1558,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',88.94,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1382,7485,40720,1558,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',37.82,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1383,7485,40720,1558,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',37.82,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1384,7485,40720,1558,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',49.00,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1385,7485,40720,1558,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',870.00,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1386,7485,40720,1558,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',22.40,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1387,7485,40720,1558,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',21.00,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1388,7485,40720,1558,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',24.14,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1389,7485,40720,1558,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',17.50,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1390,7485,40720,1558,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',28.00,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1391,7485,40720,1558,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',30.00,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1392,7485,40720,1558,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',26.60,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47');
INSERT INTO `balance_libro` VALUES (1393,7485,40720,1558,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',19.20,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1394,7485,40720,1558,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',33.00,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1395,7485,40720,1558,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',16.80,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1396,7485,40720,1558,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',33.28,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1397,7485,40720,1558,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',39.93,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1398,7485,40720,1558,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',18.84,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1399,7485,40720,1558,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',18.48,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1400,7485,40720,1558,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71.60,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1401,7485,40720,1558,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',98.67,NULL,NULL,1,'2023-05-04 16:18:55','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1402,7485,40720,1558,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',153.00,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1403,7485,40720,1558,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',50.33,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1404,7485,40720,1558,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71.60,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1405,7485,40720,1558,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83.20,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1406,7485,40720,1558,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',100.00,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1407,7485,40720,1558,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83.20,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1408,7485,40720,1558,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',142.00,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1409,7485,40720,1558,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83.20,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1410,7485,40720,1558,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',86.00,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1411,7485,40720,1558,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',118.00,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47');
INSERT INTO `balance_libro` VALUES (1412,7485,40720,1558,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',48.00,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1413,7485,40720,1558,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',60.00,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1414,7485,40720,1558,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',94.80,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1415,7485,40720,1558,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',98.67,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1416,7485,40720,1558,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',50.33,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1417,7485,40720,1558,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71.60,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1418,7485,40720,1558,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71.60,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1419,7485,40720,1558,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',50.33,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1420,7485,40720,1558,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',160.00,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1421,7485,40720,1558,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',141.20,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1422,7485,40720,1558,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83.20,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1423,7485,40720,1558,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',96.40,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1424,7485,40720,1558,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83.20,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1425,7485,40720,1558,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83.20,NULL,NULL,1,'2023-05-04 16:18:56','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1426,7485,40720,1558,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83.90,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1427,7485,40720,1558,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83.90,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1428,7485,40720,1558,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71.60,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1429,7485,40720,1558,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',231.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1430,7485,40720,1558,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',504.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:47','2023-05-04 18:24:47');
INSERT INTO `balance_libro` VALUES (1431,7485,40720,1558,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',400.50,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:47','2023-05-04 18:24:47'),(1432,7485,40720,1558,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',54.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1433,7485,40720,1558,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',54.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1434,7485,40720,1558,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',352.80,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1435,7485,40720,1558,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',211.68,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1436,7485,40720,1558,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',267.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1437,7485,40720,1558,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',53.26,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1438,7485,40720,1558,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',62.94,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1439,7485,40720,1558,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',201.60,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1440,7485,40720,1558,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',261.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1441,7485,40720,1558,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',282.24,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1442,7485,40720,1558,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',330.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1443,7485,40720,1558,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',73.59,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1444,7485,40720,1558,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',73.59,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1445,7485,40720,1558,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',198.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1446,7485,40720,1558,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',224.11,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1447,7485,40720,1558,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',294.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1448,7485,40720,1558,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',190.00,NULL,NULL,1,'2023-05-04 16:18:57','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1449,7485,40720,1558,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',360.00,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48');
INSERT INTO `balance_libro` VALUES (1450,7485,40720,1558,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',297.00,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1451,7485,40720,1558,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',259.20,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1452,7485,40720,1558,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',74.00,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1453,7485,40720,1558,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',145.00,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1454,7485,40720,1558,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',246.50,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1455,7485,40720,1558,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',104.00,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1456,7485,40720,1558,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',193.20,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1457,7485,40720,1558,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',360.00,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1458,7485,40720,1558,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',104.00,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1459,7485,40720,1558,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',87.20,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1460,7485,40720,1558,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',109.37,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1461,7485,40720,1558,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',109.37,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1462,7485,40720,1558,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',109.37,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1463,7485,40720,1558,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',224.40,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1464,7485,40720,1558,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',500.60,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1465,7485,40720,1558,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',109.37,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1466,7485,40720,1558,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',274.20,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1467,7485,40720,1558,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',27.95,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1468,7485,40720,1558,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',121.97,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48');
INSERT INTO `balance_libro` VALUES (1469,7485,40720,1558,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',56.40,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1470,7485,40720,1558,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',500.00,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1471,7485,40720,1558,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',27.95,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1472,7485,40720,1558,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',735.00,NULL,NULL,1,'2023-05-04 16:18:58','2023-05-04 18:24:48','2023-05-04 18:24:48'),(1473,7485,40720,1558,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2016.25,NULL,NULL,1,'2023-05-04 16:44:52','2023-05-04 17:58:37','2023-05-04 17:58:37'),(1474,7485,40720,1558,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',726.00,NULL,NULL,1,'2023-05-04 16:45:55','2023-05-04 17:58:28','2023-05-04 17:58:28'),(1475,7485,40720,1558,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',726.00,NULL,NULL,1,'2023-05-04 16:46:47','2023-05-04 17:58:22','2023-05-04 17:58:22'),(1476,7485,40720,1558,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',363.00,NULL,NULL,1,'2023-05-04 16:47:16','2023-05-04 17:58:15','2023-05-04 17:58:15'),(1477,7485,40720,1558,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',7773.60,NULL,NULL,1,'2023-05-04 16:49:32','2023-05-04 17:58:07','2023-05-04 17:58:07'),(1478,7485,40720,1558,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',272421.80,NULL,NULL,1,'2023-05-04 16:58:15','2023-05-04 17:30:57','2023-05-04 17:30:57'),(1479,7485,40720,1558,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',272421.80,NULL,NULL,1,'2023-05-04 17:30:57','2023-05-04 17:58:01','2023-05-04 17:58:01'),(1480,7485,40720,1558,3,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',272421.80,NULL,NULL,1,'2023-05-04 17:42:04','2023-05-04 19:03:38','2023-05-04 19:03:38'),(1481,7485,40720,1558,3,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',7773.60,NULL,NULL,1,'2023-05-04 17:45:55','2023-05-04 19:03:38','2023-05-04 19:03:38'),(1482,7485,40720,1558,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2016.25,NULL,NULL,1,'2023-05-04 17:53:10','2023-05-04 17:56:16','2023-05-04 17:56:16'),(1483,7485,40720,1558,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',726.00,NULL,NULL,1,'2023-05-04 17:53:45','2023-05-04 17:55:37','2023-05-04 17:55:37'),(1484,7485,40720,1558,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',726.00,NULL,NULL,1,'2023-05-04 17:54:30','2023-05-04 17:56:57','2023-05-04 17:56:57'),(1485,7485,40720,1558,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',363.00,NULL,NULL,1,'2023-05-04 17:54:50','2023-05-04 17:55:21','2023-05-04 17:55:21'),(1486,7485,40720,1558,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',363.00,NULL,NULL,1,'2023-05-04 17:55:21','2023-05-04 17:57:36','2023-05-04 17:57:36'),(1487,7485,40720,1558,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',726.00,NULL,NULL,1,'2023-05-04 17:55:37','2023-05-04 17:56:36','2023-05-04 17:56:36');
INSERT INTO `balance_libro` VALUES (1488,7485,40720,1558,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2016.25,NULL,NULL,1,'2023-05-04 17:56:16','2023-05-04 19:03:38','2023-05-04 19:03:38'),(1489,7485,40720,1558,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',726.00,NULL,NULL,1,'2023-05-04 17:56:36','2023-05-04 19:03:38','2023-05-04 19:03:38'),(1490,7485,40720,1558,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',726.00,NULL,NULL,1,'2023-05-04 17:56:57','2023-05-04 17:57:14','2023-05-04 17:57:14'),(1491,7485,40720,1558,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',726.00,NULL,NULL,1,'2023-05-04 17:57:14','2023-05-04 19:03:38','2023-05-04 19:03:38'),(1492,7485,40720,1558,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',363.00,NULL,NULL,1,'2023-05-04 17:57:36','2023-05-04 19:03:38','2023-05-04 19:03:38'),(1493,7485,40720,1558,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',100.06,NULL,NULL,1,'2023-05-04 18:25:35','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1494,7485,40720,1558,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',22680.02,NULL,NULL,1,'2023-05-04 18:25:35','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1495,7485,40720,1558,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',15400.04,NULL,NULL,1,'2023-05-04 18:25:35','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1496,7485,40720,1558,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12600.04,NULL,NULL,1,'2023-05-04 18:25:35','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1497,7485,40720,1558,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',26700.00,NULL,NULL,1,'2023-05-04 18:25:35','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1498,7485,40720,1558,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',40700.04,NULL,NULL,1,'2023-05-04 18:25:35','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1499,7485,40720,1558,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',19250.02,NULL,NULL,1,'2023-05-04 18:25:35','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1500,7485,40720,1558,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',25140.00,NULL,NULL,1,'2023-05-04 18:25:35','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1501,7485,40720,1558,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',40700.04,NULL,NULL,1,'2023-05-04 18:25:35','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1502,7485,40720,1558,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12000.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1503,7485,40720,1558,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',41160.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:58','2023-10-30 20:15:58'),(1504,7485,40720,1558,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',38000.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1505,7485,40720,1558,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',25650.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1506,7485,40720,1558,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',19500.02,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59');
INSERT INTO `balance_libro` VALUES (1507,7485,40720,1558,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',15840.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1508,7485,40720,1558,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',16000.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1509,7485,40720,1558,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',27756.04,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1510,7485,40720,1558,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',33000.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1511,7485,40720,1558,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',28350.02,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1512,7485,40720,1558,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',28600.04,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1513,7485,40720,1558,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',9450.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1514,7485,40720,1558,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',49000.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1515,7485,40720,1558,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',31900.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1516,7485,40720,1558,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',39700.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1517,7485,40720,1558,2,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',609000.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1518,7485,40720,1558,2,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',38000.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1519,7485,40720,1558,2,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',26460.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1520,7485,40720,1558,2,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',38000.00,NULL,NULL,1,'2023-05-04 18:25:36','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1521,7485,40720,1558,2,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',27720.02,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1522,7485,40720,1558,2,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',25200.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1523,7485,40720,1558,2,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',32400.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1524,7485,40720,1558,2,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',20534.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1525,7485,40720,1558,2,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',9200.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59');
INSERT INTO `balance_libro` VALUES (1526,7485,40720,1558,2,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',42525.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1527,7485,40720,1558,2,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',19800.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1528,7485,40720,1558,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',32340.04,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1529,7485,40720,1558,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',31350.02,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1530,7485,40720,1558,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',39720.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1531,7485,40720,1558,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',28500.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1532,7485,40720,1558,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',33880.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1533,7485,40720,1558,2,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',21990.04,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1534,7485,40720,1558,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',25080.04,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1535,7485,40720,1558,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',18900.06,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1536,7485,40720,1558,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',26700.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1537,7485,40720,1558,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',23333.02,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1538,7485,40720,1558,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',16000.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1539,7485,40720,1558,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',30450.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1540,7485,40720,1558,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',24280.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:15:59','2023-10-30 20:15:59'),(1541,7485,40720,1558,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',145000.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1542,7485,40720,1558,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',28560.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1543,7485,40720,1558,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',34833.04,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1544,7485,40720,1558,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',34200.04,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:16:00','2023-10-30 20:16:00');
INSERT INTO `balance_libro` VALUES (1545,7485,40720,1558,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',30800.00,NULL,NULL,1,'2023-05-04 18:25:37','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1546,7485,40720,1558,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',21400.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1547,7485,40720,1558,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',190450.04,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1548,7485,40720,1558,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',26400.02,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1549,7485,40720,1558,2,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',25200.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1550,7485,40720,1558,2,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',42292.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1551,7485,40720,1558,2,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',26000.04,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1552,7485,40720,1558,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',32340.04,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1553,7485,40720,1558,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',39200.04,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1554,7485,40720,1558,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',32340.04,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1555,7485,40720,1558,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',240000.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1556,7485,40720,1558,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',39200.04,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1557,7485,40720,1558,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',35600.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1558,7485,40720,1558,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',13333.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1559,7485,40720,1558,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',27720.02,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1560,7485,40720,1558,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',32017.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1561,7485,40720,1558,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',13333.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1562,7485,40720,1558,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1056500.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1563,7485,40720,1558,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',16000.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00');
INSERT INTO `balance_libro` VALUES (1564,7485,40720,1558,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',41164.06,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1565,7485,40720,1558,2,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',88935.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1566,7485,40720,1558,2,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',37822.02,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1567,7485,40720,1558,2,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',37822.02,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1568,7485,40720,1558,2,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',49000.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1569,7485,40720,1558,2,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',870000.06,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1570,7485,40720,1558,2,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',22400.00,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1571,7485,40720,1558,2,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',21000.02,NULL,NULL,1,'2023-05-04 18:25:38','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1572,7485,40720,1558,2,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',24140.04,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1573,7485,40720,1558,2,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',17500.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1574,7485,40720,1558,2,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',28000.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1575,7485,40720,1558,2,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',30000.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:00','2023-10-30 20:16:00'),(1576,7485,40720,1558,2,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',26600.02,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1577,7485,40720,1558,2,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',19200.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1578,7485,40720,1558,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',33000.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1579,7485,40720,1558,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',16800.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1580,7485,40720,1558,2,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',33275.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1581,7485,40720,1558,2,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',39930.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1582,7485,40720,1558,2,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',18840.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01');
INSERT INTO `balance_libro` VALUES (1583,7485,40720,1558,2,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',18480.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1584,7485,40720,1558,2,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71600.04,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1585,7485,40720,1558,2,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',98667.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1586,7485,40720,1558,2,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',153000.02,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1587,7485,40720,1558,2,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',50333.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1588,7485,40720,1558,2,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71600.04,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1589,7485,40720,1558,2,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83200.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1590,7485,40720,1558,2,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',100000.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1591,7485,40720,1558,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83200.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1592,7485,40720,1558,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',142000.02,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1593,7485,40720,1558,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83200.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1594,7485,40720,1558,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',86000.00,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1595,7485,40720,1558,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',118000.02,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1596,7485,40720,1558,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',48000.02,NULL,NULL,1,'2023-05-04 18:25:39','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1597,7485,40720,1558,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',60000.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1598,7485,40720,1558,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',94800.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1599,7485,40720,1558,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',98667.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1600,7485,40720,1558,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',50333.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1601,7485,40720,1558,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71600.04,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01');
INSERT INTO `balance_libro` VALUES (1602,7485,40720,1558,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71600.04,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1603,7485,40720,1558,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',50333.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1604,7485,40720,1558,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',160000.06,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1605,7485,40720,1558,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',141200.06,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1606,7485,40720,1558,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83200.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1607,7485,40720,1558,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',96400.02,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1608,7485,40720,1558,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83200.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:01','2023-10-30 20:16:01'),(1609,7485,40720,1558,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83200.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1610,7485,40720,1558,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83900.04,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1611,7485,40720,1558,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',83900.04,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1612,7485,40720,1558,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',71600.04,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1613,7485,40720,1558,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',231000.02,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1614,7485,40720,1558,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',504000.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1615,7485,40720,1558,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',400500.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1616,7485,40720,1558,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',54000.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1617,7485,40720,1558,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',54000.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1618,7485,40720,1558,2,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',352800.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1619,7485,40720,1558,2,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',211680.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1620,7485,40720,1558,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',267000.00,NULL,NULL,1,'2023-05-04 18:25:40','2023-10-30 20:16:02','2023-10-30 20:16:02');
INSERT INTO `balance_libro` VALUES (1621,7485,40720,1558,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',53260.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1622,7485,40720,1558,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',62940.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1623,7485,40720,1558,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',201600.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1624,7485,40720,1558,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',261000.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1625,7485,40720,1558,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',282240.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1626,7485,40720,1558,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',330000.04,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1627,7485,40720,1558,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',73588.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1628,7485,40720,1558,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',73588.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1629,7485,40720,1558,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',198000.04,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1630,7485,40720,1558,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',224115.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1631,7485,40720,1558,2,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',294000.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1632,7485,40720,1558,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',190000.04,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1633,7485,40720,1558,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',360000.02,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1634,7485,40720,1558,2,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',297000.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1635,7485,40720,1558,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',259200.00,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1636,7485,40720,1558,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',74000.06,NULL,NULL,1,'2023-05-04 18:25:41','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1637,7485,40720,1558,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',144996.06,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1638,7485,40720,1558,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',246498.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1639,7485,40720,1558,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',104000.04,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:02','2023-10-30 20:16:02');
INSERT INTO `balance_libro` VALUES (1640,7485,40720,1558,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',193200.02,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1641,7485,40720,1558,2,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',360000.02,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1642,7485,40720,1558,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',104000.04,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1643,7485,40720,1558,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',87200.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:02','2023-10-30 20:16:02'),(1644,7485,40720,1558,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',109375.02,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1645,7485,40720,1558,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',109375.02,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1646,7485,40720,1558,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',109375.02,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1647,7485,40720,1558,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',224400.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1648,7485,40720,1558,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',500600.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1649,7485,40720,1558,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',109375.02,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1650,7485,40720,1558,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',274200.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1651,7485,40720,1558,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',27951.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1652,7485,40720,1558,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',121968.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1653,7485,40720,1558,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',56400.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1654,7485,40720,1558,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',500000.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1655,7485,40720,1558,2,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',27951.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1656,7485,40720,1558,2,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',735000.00,NULL,NULL,1,'2023-05-04 18:25:42','2023-10-30 20:16:03','2023-10-30 20:16:03'),(1657,7485,40720,1558,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',82.23,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:56:45','2023-05-04 18:56:45'),(1658,7485,40720,1558,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1644.75,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:56:39','2023-05-04 18:56:39');
INSERT INTO `balance_libro` VALUES (1659,7485,40720,1558,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',603.46,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:56:28','2023-05-04 18:56:28'),(1660,7485,40720,1558,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',78.78,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:56:23','2023-05-04 18:56:23'),(1661,7485,40720,1558,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',75.31,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:56:12','2023-05-04 18:56:12'),(1662,7485,40720,1558,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3417.48,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:55:27','2023-05-04 18:55:27'),(1663,7485,40720,1558,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',22.75,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:55:21','2023-05-04 18:55:21'),(1664,7485,40720,1558,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',387.30,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:55:15','2023-05-04 18:55:15'),(1665,7485,40720,1558,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',336.10,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:55:08','2023-05-04 18:55:08'),(1666,7485,40720,1558,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',908.54,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:55:01','2023-05-04 18:55:01'),(1667,7485,40720,1558,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',241.45,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:54:56','2023-05-04 18:54:56'),(1668,7485,40720,1558,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',201.51,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:54:50','2023-05-04 18:54:50'),(1669,7485,40720,1558,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',42.06,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:54:42','2023-05-04 18:54:42'),(1670,7485,40720,1558,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',606.68,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:54:37','2023-05-04 18:54:37'),(1671,7485,40720,1558,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8.89,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:54:31','2023-05-04 18:54:31'),(1672,7485,40720,1558,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8.89,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:54:24','2023-05-04 18:54:24'),(1673,7485,40720,1558,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',4.77,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:54:14','2023-05-04 18:54:14'),(1674,7485,40720,1558,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8.89,NULL,NULL,1,'2023-05-04 18:48:25','2023-05-04 18:54:19','2023-05-04 18:54:19'),(1675,7485,40720,1558,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',99.06,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:54:09','2023-05-04 18:54:09'),(1676,7485,40720,1558,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8.89,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:54:01','2023-05-04 18:54:01'),(1677,7485,40720,1558,3,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',89.00,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:53:55','2023-05-04 18:53:55');
INSERT INTO `balance_libro` VALUES (1678,7485,40720,1558,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',244.00,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:53:50','2023-05-04 18:53:50'),(1679,7485,40720,1558,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',978.94,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:53:45','2023-05-04 18:53:45'),(1680,7485,40720,1558,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',196.81,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:53:37','2023-05-04 18:53:37'),(1681,7485,40720,1558,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',80.05,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:53:32','2023-05-04 18:53:32'),(1682,7485,40720,1558,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',381.72,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:53:25','2023-05-04 18:53:25'),(1683,7485,40720,1558,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',221.04,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:53:15','2023-05-04 18:53:15'),(1684,7485,40720,1558,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',212.50,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:53:07','2023-05-04 18:53:07'),(1685,7485,40720,1558,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',50.15,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:52:49','2023-05-04 18:52:49'),(1686,7485,40720,1558,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',558.00,NULL,NULL,1,'2023-05-04 18:48:26','2023-05-04 18:52:40','2023-05-04 18:52:40'),(1687,7485,40720,1558,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',75.31,NULL,NULL,1,'2023-05-04 18:56:12','2023-05-04 18:56:17','2023-05-04 18:56:17'),(1868,7485,40720,1558,3,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',82230.06,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1869,7485,40720,1558,3,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',8674.16,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1870,7485,40720,1558,3,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',603465.98,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1871,7485,40720,1558,3,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',78776.02,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1872,7485,40720,1558,3,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',75312.24,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1873,7485,40720,1558,3,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',17584.95,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1874,7485,40720,1558,3,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',22750.00,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1875,7485,40720,1558,3,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',387302.10,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1876,7485,40720,1558,3,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',336102.55,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13');
INSERT INTO `balance_libro` VALUES (1877,7485,40720,1558,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',908536.28,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1878,7485,40720,1558,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',241447.10,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1879,7485,40720,1558,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',201509.50,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1880,7485,40720,1558,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',42036.62,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1881,7485,40720,1558,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',606677.69,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1882,7485,40720,1558,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8890.00,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1883,7485,40720,1558,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8890.00,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1884,7485,40720,1558,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',4770.00,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1885,7485,40720,1558,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8890.00,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1886,7485,40720,1558,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',99060.00,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1887,7485,40720,1558,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8890.00,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1888,7485,40720,1558,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',89000.34,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1889,7485,40720,1558,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',244000.00,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1890,7485,40720,1558,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',978943.47,NULL,NULL,1,'2023-05-04 19:16:07','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1891,7485,40720,1558,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5876.94,NULL,NULL,1,'2023-05-04 19:16:08','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1892,7485,40720,1558,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',80051.66,NULL,NULL,1,'2023-05-04 19:16:08','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1893,7485,40720,1558,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',2000.00,NULL,NULL,1,'2023-05-04 19:16:08','2023-10-30 20:50:13','2023-10-30 20:50:13'),(1894,7485,40720,1558,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',221040.21,NULL,NULL,1,'2023-05-04 19:16:08','2023-10-30 20:50:14','2023-10-30 20:50:14'),(1895,7485,40720,1558,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',212500.20,NULL,NULL,1,'2023-05-04 19:16:08','2023-10-30 20:50:14','2023-10-30 20:50:14');
INSERT INTO `balance_libro` VALUES (1896,7485,40720,1558,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',50150.02,NULL,NULL,1,'2023-05-04 19:16:08','2023-10-30 20:50:14','2023-10-30 20:50:14'),(1897,7485,40720,1558,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',557999.72,NULL,NULL,1,'2023-05-04 19:16:08','2023-10-30 20:50:14','2023-10-30 20:50:14'),(1898,7485,40720,1558,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',272421.80,NULL,NULL,1,'2023-05-04 19:56:18','2023-10-30 20:50:14','2023-10-30 20:50:14'),(1899,7485,40720,1558,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',7773.60,NULL,NULL,1,'2023-05-04 19:57:52','2023-10-30 20:50:14','2023-10-30 20:50:14'),(1900,7485,40720,1558,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2016.25,NULL,NULL,1,'2023-05-04 19:58:44','2023-10-30 20:50:14','2023-10-30 20:50:14'),(1901,7485,40720,1558,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',726.00,NULL,NULL,1,'2023-05-04 19:59:24','2023-10-30 20:50:14','2023-10-30 20:50:14'),(1902,7485,40720,1558,3,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',726.00,NULL,NULL,1,'2023-05-04 19:59:43','2023-10-30 20:50:14','2023-10-30 20:50:14'),(1903,7485,40720,1558,3,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',363.00,NULL,NULL,1,'2023-05-04 20:00:00','2023-10-30 20:50:14','2023-10-30 20:50:14'),(1904,7485,40828,7772,3,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',552.00,NULL,NULL,1,'2023-05-06 17:07:04','2023-05-06 17:07:04',NULL),(1905,7485,40828,7772,3,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',2699.91,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1906,7485,40828,7772,3,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',10209.31,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1907,7485,40828,7772,3,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',294159.05,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1908,7485,40828,7772,3,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',743000.00,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1909,7485,40828,7772,3,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',78643.00,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1910,7485,40828,7772,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',176418.00,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1911,7485,40828,7772,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',12709.90,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1912,7485,40828,7772,3,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',278000.00,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1913,7485,40828,7772,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',92757.25,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1914,7485,40828,7772,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',410000.00,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1915,7485,40828,7772,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',4385.50,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL);
INSERT INTO `balance_libro` VALUES (1916,7485,40828,7772,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',20000.01,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1917,7485,40828,7772,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',340000.00,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1918,7485,40828,7772,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',250000.00,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1919,7485,40828,7772,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',96795.29,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1920,7485,40828,7772,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',8891.68,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1921,7485,40828,7772,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',2290.00,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1922,7485,40828,7772,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',10206.51,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1923,7485,40828,7772,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',97641.12,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1924,7485,40828,7772,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',206.61,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1925,7485,40828,7772,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',9999.44,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1926,7485,40828,7772,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',83842.50,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1927,7485,40828,7772,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1343.67,NULL,NULL,1,'2023-05-06 17:07:05','2023-05-06 17:07:05',NULL),(1974,7485,40828,7772,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',118035.08,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1975,7485,40828,7772,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',90000.00,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1976,7485,40828,7772,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',105500.04,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1977,7485,40828,7772,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',4800.02,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1978,7485,40828,7772,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',90000.00,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1979,7485,40828,7772,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',106495.00,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1980,7485,40828,7772,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',30000.00,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1981,7485,40828,7772,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',8541.00,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1982,7485,40828,7772,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',81386.00,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL);
INSERT INTO `balance_libro` VALUES (1983,7485,40828,7772,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',30700.00,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1984,7485,40828,7772,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',35100.06,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1985,7485,40828,7772,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',55000.00,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1986,7485,40828,7772,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',53000.00,NULL,NULL,1,'2023-05-06 17:19:21','2023-05-06 17:19:21',NULL),(1987,7485,40828,7772,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',90000.00,NULL,NULL,1,'2023-05-06 17:19:22','2023-05-06 17:19:22',NULL),(1988,7485,40828,7772,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',30190.04,NULL,NULL,1,'2023-05-06 17:19:22','2023-05-06 17:19:22',NULL),(1989,7485,40723,6067,3,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',4800.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1990,7485,40723,6067,3,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1309.36,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1991,7485,40723,6067,3,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',435.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1992,7485,40723,6067,3,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',18380.02,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1993,7485,40723,6067,3,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',275692.53,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1994,7485,40723,6067,3,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',420.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1995,7485,40723,6067,3,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',435.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1996,7485,40723,6067,3,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',591141.58,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1997,7485,40723,6067,3,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',6849.73,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1998,7485,40723,6067,3,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',23129.96,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(1999,7485,40723,6067,3,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',6849.73,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2000,7485,40723,6067,3,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',775.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2001,7485,40723,6067,3,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',163.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2002,7485,40723,6067,3,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1757.46,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2003,7485,40723,6067,3,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',16375.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL);
INSERT INTO `balance_libro` VALUES (2004,7485,40723,6067,3,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',1762.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2005,7485,40723,6067,3,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',855.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2006,7485,40723,6067,3,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3361.68,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2007,7485,40723,6067,3,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',789007.07,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2008,7485,40723,6067,3,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',205905.40,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2009,7485,40723,6067,3,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',250.00,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2010,7485,40723,6067,3,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',572482.79,NULL,NULL,1,'2023-05-09 17:36:36','2023-05-09 17:36:36',NULL),(2011,7485,40723,6067,3,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',4565.62,NULL,NULL,1,'2023-05-09 17:36:37','2023-05-09 17:36:37',NULL),(2012,7485,40723,6067,3,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6275.85,NULL,NULL,1,'2023-05-09 17:36:37','2023-05-09 17:36:37',NULL),(2013,7485,40723,6067,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1034.86,NULL,NULL,1,'2023-05-09 17:36:50','2023-05-09 17:36:50',NULL),(2014,7485,40723,6067,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',29720.17,NULL,NULL,1,'2023-05-09 17:36:50','2023-05-09 17:36:50',NULL),(2015,7485,40723,6067,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',239196.29,NULL,NULL,1,'2023-05-09 17:36:50','2023-05-09 17:36:50',NULL),(2016,7485,40723,6067,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',267308.98,NULL,NULL,1,'2023-05-09 17:36:50','2023-05-09 17:36:50',NULL),(2017,7485,40723,6067,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',10086.92,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2018,7485,40723,6067,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',119174.66,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2019,7485,40723,6067,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',9900.01,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2020,7485,40723,6067,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',929.93,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2021,7485,40723,6067,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',564.62,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2022,7485,40723,6067,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',800783.82,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2023,7485,40723,6067,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',9900.01,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2024,7485,40723,6067,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',149383.34,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL);
INSERT INTO `balance_libro` VALUES (2025,7485,40723,6067,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',6220.98,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2026,7485,40723,6067,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',4375.01,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2027,7485,40723,6067,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',279203.47,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2028,7485,40723,6067,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',79093.00,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2029,7485,40723,6067,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',16570.04,NULL,NULL,1,'2023-05-09 17:36:51','2023-05-09 17:36:51',NULL),(2030,7485,40723,6067,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',5180.00,NULL,NULL,1,'2023-05-09 17:44:49','2023-05-09 17:44:49',NULL),(2031,7485,40720,1558,3,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',100000.00,NULL,NULL,1,'2023-05-13 13:37:11','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2032,7485,40723,6068,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',78297.62,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2033,7485,40723,6068,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',13290.94,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2034,7485,40723,6068,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',2766.19,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2035,7485,40723,6068,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',120908.22,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2036,7485,40723,6068,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',5844.03,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2037,7485,40723,6068,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',195870.67,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2038,7485,40723,6068,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',20385.64,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2039,7485,40723,6068,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',14404.20,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2040,7485,40723,6068,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',7918.59,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2041,7485,40723,6068,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',14189.67,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2042,7485,40723,6068,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',674470.60,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2043,7485,40723,6068,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',3123.65,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2044,7485,40723,6068,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',226001.76,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2045,7485,40723,6068,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',2993.54,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL);
INSERT INTO `balance_libro` VALUES (2046,7485,40723,6068,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',5972.06,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2047,7485,40723,6068,2,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',9900.01,NULL,NULL,1,'2023-06-13 22:30:26','2023-06-13 22:30:26',NULL),(2048,7485,40723,6068,2,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',9900.10,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2049,7485,40723,6068,2,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',42267.10,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2050,7485,40723,6068,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',4496.36,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2051,7485,40723,6068,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',4534.74,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2052,7485,40723,6068,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',12296.10,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2053,7485,40723,6068,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',19981.26,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2054,7485,40723,6068,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',9523.00,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2055,7485,40723,6068,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',333067.56,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2056,7485,40723,6068,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',238016.74,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2057,7485,40723,6068,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',7928.63,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2058,7485,40723,6068,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',2895.38,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2059,7485,40723,6068,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',212500.36,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2060,7485,40723,6068,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',96117.64,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2061,7485,40723,6068,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',129913.51,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2062,7485,40723,6068,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',6967.42,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2063,7485,40723,6068,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',13934.84,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2064,7485,40723,6068,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',6493.34,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2065,7485,40723,6068,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',6967.42,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2066,7485,40723,6068,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',2531038.02,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL);
INSERT INTO `balance_libro` VALUES (2067,7485,40723,6068,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',473953.85,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2068,7485,40723,6068,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',17737.64,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2069,7485,40723,6068,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',14536.94,NULL,NULL,1,'2023-06-13 22:30:27','2023-06-13 22:30:27',NULL),(2070,7485,40723,6068,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3129.94,NULL,NULL,1,'2023-06-13 22:30:28','2023-06-13 22:30:28',NULL),(2071,7485,40723,6068,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',1617.33,NULL,NULL,1,'2023-06-13 22:42:53','2023-06-13 22:42:53',NULL),(2072,7485,40723,6068,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',163.00,NULL,NULL,1,'2023-06-13 22:42:53','2023-06-13 22:42:53',NULL),(2073,7485,40723,6068,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',394.00,NULL,NULL,1,'2023-06-13 22:42:53','2023-06-13 22:42:53',NULL),(2074,7485,40723,6068,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',11269.03,NULL,NULL,1,'2023-06-13 22:42:53','2023-06-13 22:42:53',NULL),(2075,7485,40723,6068,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',12722.23,NULL,NULL,1,'2023-06-13 22:42:53','2023-06-13 22:42:53',NULL),(2076,7485,40723,6068,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',0.01,NULL,NULL,1,'2023-06-13 22:42:53','2023-06-13 22:42:53',NULL),(2077,7485,40723,6068,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',102210.00,NULL,NULL,1,'2023-06-13 22:42:53','2023-06-13 22:42:53',NULL),(2078,7485,40723,6068,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',6782.11,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2079,7485,40723,6068,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',4637.79,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2080,7485,40723,6068,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',3275.44,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2081,7485,40723,6068,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',239100.00,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2082,7485,40723,6068,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',147610.44,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2083,7485,40723,6068,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',34671.53,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2084,7485,40723,6068,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',16171.12,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2085,7485,40723,6068,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',13597.93,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2086,7485,40723,6068,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',175766.12,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2087,7485,40723,6068,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',231.00,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL);
INSERT INTO `balance_libro` VALUES (2088,7485,40723,6068,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',258.00,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2089,7485,40723,6068,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',2264.26,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2090,7485,40723,6068,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',30.27,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2091,7485,40723,6068,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',4.46,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2092,7485,40723,6068,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',42.02,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2093,7485,40723,6068,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',1000.00,NULL,NULL,1,'2023-06-13 22:42:54','2023-06-13 22:42:54',NULL),(2094,7485,40723,6068,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',10350.00,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2095,7485,40723,6068,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',11424.51,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2096,7485,40723,6068,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1355430.60,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2097,7485,40723,6068,3,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',831300.61,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2098,7485,40723,6068,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',4715129.37,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2099,7485,40723,6068,3,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1227782.02,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2100,7485,40723,6068,3,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2041088.53,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2101,7485,40723,6068,3,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',11718.50,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2102,7485,40723,6068,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',248608.94,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2103,7485,40723,6068,3,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',529893.67,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2104,7485,40723,6068,3,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',3382998.33,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2105,7485,40723,6068,3,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2989.99,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2106,7485,40723,6068,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',13887.95,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2107,7485,40723,6068,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',258000.00,NULL,NULL,1,'2023-06-13 22:42:55','2023-06-13 22:42:55',NULL),(2108,7485,40720,1559,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',22750.00,NULL,NULL,1,'2023-06-16 15:53:20','2023-10-30 20:50:14','2023-10-30 20:50:14');
INSERT INTO `balance_libro` VALUES (2109,7485,40720,1559,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',12349.03,NULL,NULL,1,'2023-06-16 15:53:20','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2110,7485,40720,1559,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',5493.44,NULL,NULL,1,'2023-06-16 15:53:20','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2111,7485,40720,1559,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',240149.33,NULL,NULL,1,'2023-06-16 15:53:20','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2112,7485,40720,1559,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1195345.12,NULL,NULL,1,'2023-06-16 15:53:20','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2113,7485,40720,1559,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',17605.35,NULL,NULL,1,'2023-06-16 15:53:20','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2114,7485,40720,1559,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',72356.98,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2115,7485,40720,1559,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1272505.62,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2116,7485,40720,1559,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',112750.00,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2117,7485,40720,1559,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',29100.00,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2118,7485,40720,1559,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',209051.29,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2119,7485,40720,1559,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',800.00,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2120,7485,40720,1559,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',361360.21,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2121,7485,40720,1559,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',344534.96,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2122,7485,40720,1559,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',393602.12,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2123,7485,40720,1559,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',240000.06,NULL,NULL,1,'2023-06-16 15:53:21','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2124,7485,40720,1559,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',215097.10,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2125,7485,40720,1559,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',7639.53,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2126,7485,40720,1559,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',393275.05,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2127,7485,40720,1559,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',1352025.41,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:14','2023-10-30 20:50:14');
INSERT INTO `balance_libro` VALUES (2128,7485,40720,1559,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',109263.00,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2129,7485,40720,1559,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',110251.09,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2130,7485,40720,1559,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',20606.49,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:14','2023-10-30 20:50:14'),(2131,7485,40720,1559,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',8890.00,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2132,7485,40720,1559,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',8890.00,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2133,7485,40720,1559,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',23000.00,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2134,7485,40720,1559,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',340772.73,NULL,NULL,1,'2023-06-16 15:53:22','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2135,7485,40720,1559,2,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',638000.00,NULL,NULL,1,'2023-06-16 15:53:34','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2136,7485,40720,1559,2,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',350000.00,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2137,7485,40720,1559,2,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',42292.00,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2138,7485,40720,1559,2,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',250000.00,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2139,7485,40720,1559,2,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',280000.00,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2140,7485,40720,1559,2,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',299600.06,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2141,7485,40720,1559,2,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',41000.00,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2142,7485,40720,1559,2,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',231000.48,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2143,7485,40720,1559,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',26000.04,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2144,7485,40720,1559,2,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',74400.04,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2145,7485,40720,1559,2,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',117600.14,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2146,7485,40720,1559,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',430350.00,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33');
INSERT INTO `balance_libro` VALUES (2147,7485,40720,1559,2,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',32340.04,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2148,7485,40720,1559,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',150000.02,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2149,7485,40720,1559,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',27600.00,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2150,7485,40720,1559,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',198000.16,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2151,7485,40720,1559,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',73600.00,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2152,7485,40720,1559,2,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',32340.04,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2153,7485,40720,1559,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',725000.04,NULL,NULL,1,'2023-06-16 15:53:35','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2154,7485,40720,1559,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',356345.00,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2155,7485,40720,1559,2,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',340200.28,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2156,7485,40720,1559,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',288000.10,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2157,7485,40720,1559,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',280000.00,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2158,7485,40720,1559,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',28350.02,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2159,7485,40720,1559,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',522000.00,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2160,7485,40720,1559,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',350000.00,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2161,7485,40720,1559,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',239400.12,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:33','2023-10-30 20:15:33'),(2162,7485,40720,1559,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',246400.50,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:34','2023-10-30 20:15:34'),(2163,7485,40720,1559,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',52800.04,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:34','2023-10-30 20:15:34'),(2164,7485,40720,1559,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',156000.00,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:34','2023-10-30 20:15:34'),(2165,7485,40720,1559,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',26400.02,NULL,NULL,1,'2023-06-16 15:53:36','2023-10-30 20:15:34','2023-10-30 20:15:34');
INSERT INTO `balance_libro` VALUES (2166,7485,40720,1559,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',144000.06,NULL,NULL,1,'2023-06-16 15:53:37','2023-10-30 20:15:34','2023-10-30 20:15:34'),(2167,7485,40720,1559,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',37822.02,NULL,NULL,1,'2023-06-16 15:53:37','2023-10-30 20:15:34','2023-10-30 20:15:34'),(2168,7485,40720,1560,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',81400.08,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:40','2023-10-30 20:11:40'),(2169,7485,40720,1560,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',64680.06,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:40','2023-10-30 20:11:40'),(2170,7485,40720,1560,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',37822.02,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:40','2023-10-30 20:11:40'),(2171,7485,40720,1560,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',28500.00,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:40','2023-10-30 20:11:40'),(2172,7485,40720,1560,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',390000.00,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:40','2023-10-30 20:11:40'),(2173,7485,40720,1560,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',45900.00,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:40','2023-10-30 20:11:40'),(2174,7485,40720,1560,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',76950.00,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:40','2023-10-30 20:11:40'),(2175,7485,40720,1560,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',284625.72,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2176,7485,40720,1560,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',96600.00,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2177,7485,40720,1560,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',132000.00,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2178,7485,40720,1560,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1201592.00,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2179,7485,40720,1560,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',50400.00,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2180,7485,40720,1560,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',464100.00,NULL,NULL,1,'2023-07-08 17:03:24','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2181,7485,40720,1560,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',90000.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2182,7485,40720,1560,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',210000.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2183,7485,40720,1560,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',389000.04,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2184,7485,40720,1560,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',128000.04,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41');
INSERT INTO `balance_libro` VALUES (2185,7485,40720,1560,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',370500.54,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2186,7485,40720,1560,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',466560.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2187,7485,40720,1560,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',287980.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2188,7485,40720,1560,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',395010.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2189,7485,40720,1560,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',590000.06,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2190,7485,40720,1560,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',93331.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2191,7485,40720,1560,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',319000.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2192,7485,40720,1560,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1155000.06,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2193,7485,40720,1560,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',435000.02,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2194,7485,40720,1560,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1006600.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2195,7485,40720,1560,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',134400.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2196,7485,40720,1560,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',24750.00,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2197,7485,40720,1560,2,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',222000.06,NULL,NULL,1,'2023-07-08 17:03:25','2023-10-30 20:11:41','2023-10-30 20:11:41'),(2198,7485,40720,1560,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',22750.00,NULL,NULL,1,'2023-07-08 17:03:35','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2199,7485,40720,1560,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',10755.09,NULL,NULL,1,'2023-07-08 17:03:35','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2200,7485,40720,1560,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',20919.90,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2201,7485,40720,1560,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',156802.13,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2202,7485,40720,1560,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',50457.00,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2203,7485,40720,1560,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',80701.39,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15');
INSERT INTO `balance_libro` VALUES (2204,7485,40720,1560,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',7850.00,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2205,7485,40720,1560,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',199820.69,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2206,7485,40720,1560,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',1874157.62,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2207,7485,40720,1560,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',124306.93,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2208,7485,40720,1560,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',50457.00,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2209,7485,40720,1560,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',46500.00,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2210,7485,40720,1560,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',192390.06,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2211,7485,40720,1560,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',297301.32,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2212,7485,40720,1560,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',137895.17,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2213,7485,40720,1560,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',7639.53,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2214,7485,40720,1560,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',1251093.29,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2215,7485,40720,1560,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',270535.67,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2216,7485,40720,1560,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',105488.18,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2217,7485,40720,1560,3,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',255000.19,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2218,7485,40720,1560,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',156802.13,NULL,NULL,1,'2023-07-08 17:03:36','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2219,7485,40720,1560,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',471.90,NULL,NULL,1,'2023-07-09 18:57:26','2023-07-09 18:58:23','2023-07-09 18:58:23'),(2220,7485,40720,1560,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',471.90,NULL,NULL,1,'2023-07-09 18:58:23','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2221,7485,40720,1560,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3348.00,NULL,NULL,1,'2023-07-09 18:59:32','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2222,7485,40720,1560,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',726.00,NULL,NULL,1,'2023-07-09 19:01:11','2023-10-30 20:50:15','2023-10-30 20:50:15');
INSERT INTO `balance_libro` VALUES (2223,7485,40720,1560,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',726.00,NULL,NULL,1,'2023-07-09 19:01:44','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2224,7485,40720,1560,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',2178.00,NULL,NULL,1,'2023-07-09 19:03:21','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2225,7485,40720,1560,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',1089.00,NULL,NULL,1,'2023-07-09 19:03:58','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2226,7485,40720,1560,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',726.00,NULL,NULL,1,'2023-07-09 19:05:17','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2227,7485,40720,1560,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',15537.20,NULL,NULL,1,'2023-07-09 19:06:22','2023-10-30 20:50:15','2023-10-30 20:50:15'),(2228,7485,40723,6069,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',10064.00,NULL,NULL,1,'2023-07-11 16:05:42','2023-07-11 16:05:42',NULL),(2229,7485,40723,6069,3,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',15598.00,NULL,NULL,1,'2023-07-11 16:05:42','2023-07-11 16:05:42',NULL),(2230,7485,40723,6069,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',3219.99,NULL,NULL,1,'2023-07-11 16:05:42','2023-07-11 16:05:42',NULL),(2231,7485,40723,6069,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',120458.23,NULL,NULL,1,'2023-07-11 16:05:42','2023-07-11 16:05:42',NULL),(2232,7485,40723,6069,3,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',11113.86,NULL,NULL,1,'2023-07-11 16:05:42','2023-07-11 16:05:42',NULL),(2233,7485,40723,6069,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',343.91,NULL,NULL,1,'2023-07-11 16:05:42','2023-07-11 16:05:42',NULL),(2234,7485,40723,6069,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',500.00,NULL,NULL,1,'2023-07-11 16:05:42','2023-07-11 16:05:42',NULL),(2235,7485,40723,6069,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',200.00,NULL,NULL,1,'2023-07-11 16:05:42','2023-07-11 16:05:42',NULL),(2236,7485,40723,6069,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',3737.60,NULL,NULL,1,'2023-07-11 16:05:42','2023-07-11 16:05:42',NULL),(2237,7485,40723,6069,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',9542.73,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2238,7485,40723,6069,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',3510.98,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2239,7485,40723,6069,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',6790.21,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2240,7485,40723,6069,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',9820.11,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2241,7485,40723,6069,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',16032.42,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2242,7485,40723,6069,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',125506.02,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL);
INSERT INTO `balance_libro` VALUES (2243,7485,40723,6069,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',7828099.72,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2244,7485,40723,6069,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',51740.41,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2245,7485,40723,6069,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',650.00,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2246,7485,40723,6069,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',14899.96,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2247,7485,40723,6069,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',3055.15,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2248,7485,40723,6069,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',54750.00,NULL,NULL,1,'2023-07-11 16:05:43','2023-07-11 16:05:43',NULL),(2249,7485,40723,6069,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',10600.00,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2250,7485,40723,6069,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',1512.00,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2251,7485,40723,6069,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',10226.94,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2252,7485,40723,6069,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',5222.00,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2253,7485,40723,6069,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',2899.00,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2254,7485,40723,6069,3,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',3914049.86,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2255,7485,40723,6069,3,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',7828099.72,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2256,7485,40723,6069,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',11460.01,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2257,7485,40723,6069,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',9637.00,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2258,7485,40723,6069,3,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',1000.00,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2259,7485,40723,6069,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',240762.18,NULL,NULL,1,'2023-07-11 16:05:44','2023-07-11 16:05:44',NULL),(2260,7485,40723,6069,3,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',436949.32,NULL,NULL,1,'2023-07-11 16:05:45','2023-07-11 16:05:45',NULL),(2261,7485,40723,6069,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',4878.84,NULL,NULL,1,'2023-07-11 16:05:45','2023-07-11 16:05:45',NULL),(2262,7485,40723,6069,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',9360.00,NULL,NULL,1,'2023-07-11 16:05:58','2023-07-11 16:05:58',NULL),(2263,7485,40723,6069,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',1254569.66,NULL,NULL,1,'2023-07-11 16:05:58','2023-07-11 16:05:58',NULL);
INSERT INTO `balance_libro` VALUES (2264,7485,40723,6069,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',1704.27,NULL,NULL,1,'2023-07-11 16:05:58','2023-07-11 16:05:58',NULL),(2265,7485,40723,6069,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4656.95,NULL,NULL,1,'2023-07-11 16:05:58','2023-07-11 16:05:58',NULL),(2266,7485,40723,6069,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',137737.16,NULL,NULL,1,'2023-07-11 16:05:58','2023-07-11 16:05:58',NULL),(2267,7485,40723,6069,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',6298.70,NULL,NULL,1,'2023-07-11 16:05:58','2023-07-11 16:05:58',NULL),(2268,7485,40723,6069,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',137737.16,NULL,NULL,1,'2023-07-11 16:05:58','2023-07-11 16:05:58',NULL),(2269,7485,40723,6069,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',137737.16,NULL,NULL,1,'2023-07-11 16:05:58','2023-07-11 16:05:58',NULL),(2270,7485,40723,6069,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',214792.06,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2271,7485,40723,6069,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',9787.24,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2272,7485,40723,6069,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',30438.03,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2273,7485,40723,6069,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',15119.53,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2274,7485,40723,6069,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2993.50,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2275,7485,40723,6069,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',15956.68,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2276,7485,40723,6069,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',251961.14,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2277,7485,40723,6069,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',5144.35,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2278,7485,40723,6069,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',4124.89,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2279,7485,40723,6069,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',868.78,NULL,NULL,1,'2023-07-11 16:05:59','2023-07-11 16:05:59',NULL),(2280,7485,40723,6069,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',149646.52,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2281,7485,40723,6069,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',51366.24,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2282,7485,40723,6069,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',211458.68,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2283,7485,40723,6069,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',73360.05,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2284,7485,40723,6069,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',168872.46,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL);
INSERT INTO `balance_libro` VALUES (2285,7485,40723,6069,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',7524.83,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2286,7485,40723,6069,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',8723.02,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2287,7485,40723,6069,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',3378.50,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2288,7485,40723,6069,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',3048.86,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2289,7485,40723,6069,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',2356.58,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2290,7485,40723,6069,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',8134.92,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2291,7485,40723,6069,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',24399.21,NULL,NULL,1,'2023-07-11 16:06:00','2023-07-11 16:06:00',NULL),(2292,7485,40828,7774,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',23002.10,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:34:07','2023-07-11 20:34:07'),(2293,7485,40828,7774,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',30760.00,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:34:00','2023-07-11 20:34:00'),(2294,7485,40828,7774,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',85000.04,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:33:49','2023-07-11 20:33:49'),(2295,7485,40828,7774,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',102000.00,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:33:43','2023-07-11 20:33:43'),(2296,7485,40828,7774,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',100500.00,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:33:37','2023-07-11 20:33:37'),(2297,7485,40828,7774,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',30750.04,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:33:29','2023-07-11 20:33:29'),(2298,7485,40828,7774,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',30700.00,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:33:23','2023-07-11 20:33:23'),(2299,7485,40828,7774,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',100000.00,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:33:17','2023-07-11 20:33:17'),(2300,7485,40828,7774,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',29699.00,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:33:11','2023-07-11 20:33:11'),(2301,7485,40828,7774,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',30760.08,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:33:07','2023-07-11 20:33:07'),(2302,7485,40828,7774,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',30000.00,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:33:00','2023-07-11 20:33:00'),(2303,7485,40828,7774,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',28400.00,NULL,NULL,1,'2023-07-11 20:25:26','2023-07-11 20:32:44','2023-07-11 20:32:44');
INSERT INTO `balance_libro` VALUES (2304,7485,40828,7774,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',19500.00,NULL,NULL,1,'2023-07-11 20:25:27','2023-07-11 20:32:31','2023-07-11 20:32:31'),(2305,7485,40828,7774,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',25900.00,NULL,NULL,1,'2023-07-11 20:25:27','2023-07-11 20:32:25','2023-07-11 20:32:25'),(2306,7485,40828,7774,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',30760.00,NULL,NULL,1,'2023-07-11 20:25:27','2023-07-11 20:32:19','2023-07-11 20:32:19'),(2307,7485,40828,7774,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',100000.10,NULL,NULL,1,'2023-07-11 20:25:27','2023-07-11 20:32:13','2023-07-11 20:32:13'),(2308,7485,40828,7774,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',29500.00,NULL,NULL,1,'2023-07-11 20:25:27','2023-07-11 20:31:58','2023-07-11 20:31:58'),(2309,7485,40828,7774,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30745.02,NULL,NULL,1,'2023-07-11 20:25:27','2023-07-11 20:31:52','2023-07-11 20:31:52'),(2310,7485,40828,7774,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',85000.04,NULL,NULL,1,'2023-07-11 20:25:27','2023-07-11 20:31:16','2023-07-11 20:31:16'),(2311,7485,40828,7774,3,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',2599.90,NULL,NULL,1,'2023-07-11 20:26:07','2023-07-11 20:36:20','2023-07-11 20:36:20'),(2312,7485,40828,7774,3,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',14847.99,NULL,NULL,1,'2023-07-11 20:26:07','2023-07-11 20:36:13','2023-07-11 20:36:13'),(2313,7485,40828,7774,3,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',10209.21,NULL,NULL,1,'2023-07-11 20:26:07','2023-07-11 20:36:07','2023-07-11 20:36:07'),(2314,7485,40828,7774,3,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',93655.00,NULL,NULL,1,'2023-07-11 20:26:07','2023-07-11 20:36:01','2023-07-11 20:36:01'),(2315,7485,40828,7774,3,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',15816.58,NULL,NULL,1,'2023-07-11 20:26:07','2023-07-11 20:35:52','2023-07-11 20:35:52'),(2316,7485,40828,7774,3,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',278000.00,NULL,NULL,1,'2023-07-11 20:26:07','2023-07-11 20:35:48','2023-07-11 20:35:48'),(2317,7485,40828,7774,3,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',19989.99,NULL,NULL,1,'2023-07-11 20:26:07','2023-07-11 20:35:41','2023-07-11 20:35:41'),(2318,7485,40828,7774,3,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2670.00,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:35:36','2023-07-11 20:35:36'),(2319,7485,40828,7774,3,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',402859.49,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:35:30','2023-07-11 20:35:30'),(2320,7485,40828,7774,3,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1000000.00,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:35:24','2023-07-11 20:35:24'),(2321,7485,40828,7774,3,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',4839.76,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:35:16','2023-07-11 20:35:16'),(2322,7485,40828,7774,3,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',5086.67,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:35:11','2023-07-11 20:35:11');
INSERT INTO `balance_libro` VALUES (2323,7485,40828,7774,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',467600.00,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:35:05','2023-07-11 20:35:05'),(2324,7485,40828,7774,3,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',82058.49,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:34:58','2023-07-11 20:34:58'),(2325,7485,40828,7774,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',153098.15,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:34:50','2023-07-11 20:34:50'),(2326,7485,40828,7774,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',122085.08,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:34:45','2023-07-11 20:34:45'),(2327,7485,40828,7774,3,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',52788.09,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:34:39','2023-07-11 20:34:39'),(2328,7485,40828,7774,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',12596.69,NULL,NULL,1,'2023-07-11 20:26:08','2023-07-11 20:34:33','2023-07-11 20:34:33'),(2329,7485,40828,7774,3,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',180.90,NULL,NULL,1,'2023-07-11 20:26:09','2023-07-11 20:34:27','2023-07-11 20:34:27'),(2330,7485,40828,7773,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',2599.90,NULL,NULL,1,'2023-07-11 20:37:08','2023-07-11 20:37:08',NULL),(2331,7485,40828,7773,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',14847.99,NULL,NULL,1,'2023-07-11 20:37:08','2023-07-11 20:37:08',NULL),(2332,7485,40828,7773,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',10209.21,NULL,NULL,1,'2023-07-11 20:37:08','2023-07-11 20:37:08',NULL),(2333,7485,40828,7773,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',93655.00,NULL,NULL,1,'2023-07-11 20:37:08','2023-07-11 20:37:08',NULL),(2334,7485,40828,7773,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',15816.58,NULL,NULL,1,'2023-07-11 20:37:08','2023-07-11 20:37:08',NULL),(2335,7485,40828,7773,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',278000.00,NULL,NULL,1,'2023-07-11 20:37:08','2023-07-11 20:37:08',NULL),(2336,7485,40828,7773,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',19989.99,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2337,7485,40828,7773,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2670.00,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2338,7485,40828,7773,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',402859.49,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2339,7485,40828,7773,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1000000.00,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2340,7485,40828,7773,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',4839.76,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2341,7485,40828,7773,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',5086.67,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2342,7485,40828,7773,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',467600.00,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL);
INSERT INTO `balance_libro` VALUES (2343,7485,40828,7773,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',82058.49,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2344,7485,40828,7773,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',153098.15,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2345,7485,40828,7773,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',122085.08,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2346,7485,40828,7773,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',52788.09,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2347,7485,40828,7773,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',12596.69,NULL,NULL,1,'2023-07-11 20:37:09','2023-07-11 20:37:09',NULL),(2348,7485,40828,7773,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',180.90,NULL,NULL,1,'2023-07-11 20:37:10','2023-07-11 20:37:10',NULL),(2349,7485,40828,7773,2,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',23002.10,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2350,7485,40828,7773,2,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',30760.00,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2351,7485,40828,7773,2,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',85000.04,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2352,7485,40828,7773,2,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',102000.00,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2353,7485,40828,7773,2,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',100500.00,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2354,7485,40828,7773,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',30750.04,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2355,7485,40828,7773,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',30700.00,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2356,7485,40828,7773,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',100000.00,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2357,7485,40828,7773,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',29699.00,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2358,7485,40828,7773,2,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',30760.08,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2359,7485,40828,7773,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',30000.00,NULL,NULL,1,'2023-07-11 20:37:20','2023-07-11 20:37:20',NULL),(2360,7485,40828,7773,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',28400.00,NULL,NULL,1,'2023-07-11 20:37:21','2023-07-11 20:37:21',NULL),(2361,7485,40828,7773,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',19500.00,NULL,NULL,1,'2023-07-11 20:37:21','2023-07-11 20:37:21',NULL),(2362,7485,40828,7773,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',25900.00,NULL,NULL,1,'2023-07-11 20:37:21','2023-07-11 20:37:21',NULL),(2363,7485,40828,7773,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',30760.00,NULL,NULL,1,'2023-07-11 20:37:21','2023-07-11 20:37:21',NULL);
INSERT INTO `balance_libro` VALUES (2364,7485,40828,7773,2,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',100000.10,NULL,NULL,1,'2023-07-11 20:37:21','2023-07-11 20:37:21',NULL),(2365,7485,40828,7773,2,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',29500.00,NULL,NULL,1,'2023-07-11 20:37:21','2023-07-11 20:37:21',NULL),(2366,7485,40828,7773,2,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30745.02,NULL,NULL,1,'2023-07-11 20:37:21','2023-07-11 20:37:21',NULL),(2367,7485,40828,7773,2,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',85000.04,NULL,NULL,1,'2023-07-11 20:37:21','2023-07-11 20:37:21',NULL),(2368,7485,40828,7774,2,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9890.00,NULL,NULL,1,'2023-07-11 21:11:48','2023-07-11 21:11:48',NULL),(2369,7485,40828,7774,2,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',155000.04,NULL,NULL,1,'2023-07-11 21:11:48','2023-07-11 21:11:48',NULL),(2370,7485,40828,7774,2,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',286750.02,NULL,NULL,1,'2023-07-11 21:11:48','2023-07-11 21:11:48',NULL),(2371,7485,40828,7774,2,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6150.00,NULL,NULL,1,'2023-07-11 21:11:49','2023-07-11 21:11:49',NULL),(2372,7485,40828,7774,2,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',223650.00,NULL,NULL,1,'2023-07-11 21:11:49','2023-07-11 21:11:49',NULL),(2373,7485,40828,7774,2,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',248000.00,NULL,NULL,1,'2023-07-11 21:11:49','2023-07-11 21:11:49',NULL),(2374,7485,40828,7774,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',2699.91,NULL,NULL,1,'2023-07-11 21:12:01','2023-07-11 21:12:01',NULL),(2375,7485,40828,7774,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',17442.60,NULL,NULL,1,'2023-07-11 21:12:01','2023-07-11 21:12:01',NULL),(2376,7485,40828,7774,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',37907.73,NULL,NULL,1,'2023-07-11 21:12:01','2023-07-11 21:12:01',NULL),(2377,7485,40828,7774,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',44746.92,NULL,NULL,1,'2023-07-11 21:12:01','2023-07-11 21:12:01',NULL),(2378,7485,40828,7774,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',46231.20,NULL,NULL,1,'2023-07-11 21:12:01','2023-07-11 21:12:01',NULL),(2379,7485,40828,7774,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',16758.95,NULL,NULL,1,'2023-07-11 21:12:02','2023-07-11 21:12:02',NULL),(2380,7485,40828,7774,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',14653.44,NULL,NULL,1,'2023-07-11 21:12:02','2023-07-11 21:12:02',NULL),(2381,7485,40828,7774,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',5359.11,NULL,NULL,1,'2023-07-11 21:12:02','2023-07-11 21:12:02',NULL),(2382,7485,40828,7774,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',40000.00,NULL,NULL,1,'2023-07-11 21:12:02','2023-07-11 21:12:02',NULL),(2383,7485,40828,7774,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',15313.40,NULL,NULL,1,'2023-07-11 21:12:02','2023-07-11 21:12:02',NULL),(2384,7485,40828,7774,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',34897.45,NULL,NULL,1,'2023-07-11 21:12:02','2023-07-11 21:12:02',NULL);
INSERT INTO `balance_libro` VALUES (2385,7485,40828,7774,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',128495.57,NULL,NULL,1,'2023-07-11 21:12:02','2023-07-11 21:12:02',NULL),(2386,7485,40828,7774,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',4148.46,NULL,NULL,1,'2023-07-11 21:12:02','2023-07-11 21:12:02',NULL),(2387,7485,40828,7774,3,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',81076.75,NULL,NULL,1,'2023-07-11 21:12:03','2023-07-11 21:12:03',NULL),(2388,7485,40723,6070,3,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',865.06,NULL,NULL,1,'2023-08-13 13:31:32','2023-08-13 13:31:32',NULL),(2389,7485,40723,6070,3,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',10933.40,NULL,NULL,1,'2023-08-13 13:31:32','2023-08-13 13:31:32',NULL),(2390,7485,40723,6070,3,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',500.00,NULL,NULL,1,'2023-08-13 13:31:32','2023-08-13 13:31:32',NULL),(2391,7485,40723,6070,3,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',11295.00,NULL,NULL,1,'2023-08-13 13:31:32','2023-08-13 13:31:32',NULL),(2392,7485,40723,6070,3,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',9100.15,NULL,NULL,1,'2023-08-13 13:31:32','2023-08-13 13:31:32',NULL),(2393,7485,40723,6070,3,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',7548.06,NULL,NULL,1,'2023-08-13 13:31:32','2023-08-13 13:31:32',NULL),(2394,7485,40723,6070,3,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',11700.00,NULL,NULL,1,'2023-08-13 13:31:32','2023-08-13 13:31:32',NULL),(2395,7485,40723,6070,3,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',3569.00,NULL,NULL,1,'2023-08-13 13:31:32','2023-08-13 13:31:32',NULL),(2396,7485,40723,6070,3,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',17053.62,NULL,NULL,1,'2023-08-13 13:31:32','2023-08-13 13:31:32',NULL),(2397,7485,40723,6070,3,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',25570.93,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL),(2398,7485,40723,6070,3,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',67104.16,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL),(2399,7485,40723,6070,3,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',5123.01,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL),(2400,7485,40723,6070,3,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',102166.77,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL),(2401,7485,40723,6070,3,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',16922.27,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL),(2402,7485,40723,6070,3,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',27260.01,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL),(2403,7485,40723,6070,3,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',8500.03,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL),(2404,7485,40723,6070,3,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',56949.00,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL),(2405,7485,40723,6070,3,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',477696.00,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL);
INSERT INTO `balance_libro` VALUES (2406,7485,40723,6070,3,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',280000.00,NULL,NULL,1,'2023-08-13 13:31:33','2023-08-13 13:31:33',NULL),(2407,7485,40723,6070,3,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',13949.46,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2408,7485,40723,6070,3,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',350.00,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2409,7485,40723,6070,3,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',300.00,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2410,7485,40723,6070,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',250.00,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2411,7485,40723,6070,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',325041.07,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2412,7485,40723,6070,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',26999.00,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2413,7485,40723,6070,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',8204.00,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2414,7485,40723,6070,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',8198.00,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2415,7485,40723,6070,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',500.00,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2416,7485,40723,6070,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',708687.07,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2417,7485,40723,6070,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',341738.03,NULL,NULL,1,'2023-08-13 13:31:34','2023-08-13 13:31:34',NULL),(2418,7485,40723,6070,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',2171.93,NULL,NULL,1,'2023-08-13 13:31:35','2023-08-13 13:31:35',NULL),(2419,7485,40723,6070,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',1512.49,NULL,NULL,1,'2023-08-13 13:31:35','2023-08-13 13:31:35',NULL),(2420,7485,40723,6070,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-30','2023-07-30',43800.00,NULL,NULL,1,'2023-08-13 13:31:35','2023-08-13 13:31:35',NULL),(2421,7485,40723,6070,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',8685.87,NULL,NULL,1,'2023-08-13 13:31:35','2023-08-13 13:31:35',NULL),(2422,7485,40723,6070,2,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',2698.94,NULL,NULL,1,'2023-08-13 13:31:46','2023-08-13 13:31:46',NULL),(2423,7485,40723,6070,2,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',2664523.25,NULL,NULL,1,'2023-08-13 13:31:46','2023-08-13 13:31:46',NULL),(2424,7485,40723,6070,2,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',4786.19,NULL,NULL,1,'2023-08-13 13:31:46','2023-08-13 13:31:46',NULL),(2425,7485,40723,6070,2,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2991.87,NULL,NULL,1,'2023-08-13 13:31:46','2023-08-13 13:31:46',NULL),(2426,7485,40723,6070,2,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',7630.46,NULL,NULL,1,'2023-08-13 13:31:46','2023-08-13 13:31:46',NULL);
INSERT INTO `balance_libro` VALUES (2427,7485,40723,6070,2,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',1612.37,NULL,NULL,1,'2023-08-13 13:31:46','2023-08-13 13:31:46',NULL),(2428,7485,40723,6070,2,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',10639.88,NULL,NULL,1,'2023-08-13 13:31:46','2023-08-13 13:31:46',NULL),(2429,7485,40723,6070,2,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',7416.91,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2430,7485,40723,6070,2,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',4385.40,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2431,7485,40723,6070,2,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',260425.50,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2432,7485,40723,6070,2,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',343998.64,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2433,7485,40723,6070,2,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',4018.72,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2434,7485,40723,6070,2,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',3182.55,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2435,7485,40723,6070,2,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',10271.42,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2436,7485,40723,6070,2,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',397980.49,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2437,7485,40723,6070,2,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',14436.97,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2438,7485,40723,6070,2,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',81327.58,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2439,7485,40723,6070,2,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',4085.55,NULL,NULL,1,'2023-08-13 13:31:47','2023-08-13 13:31:47',NULL),(2440,7485,40723,6070,2,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',20521.90,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL),(2441,7485,40723,6070,2,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',4377.28,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL),(2442,7485,40723,6070,2,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',935340.12,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL),(2443,7485,40723,6070,2,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',44857.88,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL),(2444,7485,40723,6070,2,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',251677.25,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL),(2445,7485,40723,6070,2,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',5941.24,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL),(2446,7485,40723,6070,2,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',1028.81,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL),(2447,7485,40723,6070,2,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',3061.43,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL);
INSERT INTO `balance_libro` VALUES (2448,7485,40723,6070,2,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',470.08,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL),(2449,7485,40723,6070,2,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',2387.04,NULL,NULL,1,'2023-08-13 13:31:48','2023-08-13 13:31:48',NULL),(2450,7485,40723,6070,2,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',33319.43,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2451,7485,40723,6070,2,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',55339.12,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2452,7485,40723,6070,2,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',3344.44,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2453,7485,40723,6070,2,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',9639.91,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2454,7485,40723,6070,2,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',28985.68,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2455,7485,40723,6070,2,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',2349.47,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2456,7485,40723,6070,2,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',2459.99,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2457,7485,40723,6070,2,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',218472.36,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2458,7485,40723,6070,2,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',216710.09,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2459,7485,40723,6070,2,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',8137.20,NULL,NULL,1,'2023-08-13 13:31:49','2023-08-13 13:31:49',NULL),(2460,7485,40828,7775,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',10000.00,NULL,NULL,1,'2023-08-15 19:00:26','2023-08-15 19:00:26',NULL),(2461,7485,40828,7775,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',2599.90,NULL,NULL,1,'2023-08-15 19:00:26','2023-08-15 19:00:26',NULL),(2462,7485,40828,7775,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',17799.60,NULL,NULL,1,'2023-08-15 19:00:26','2023-08-15 19:00:26',NULL),(2463,7485,40828,7775,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',110511.25,NULL,NULL,1,'2023-08-15 19:00:26','2023-08-15 19:00:26',NULL),(2464,7485,40828,7775,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',11115.23,NULL,NULL,1,'2023-08-15 19:00:26','2023-08-15 19:00:26',NULL),(2465,7485,40828,7775,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',106067.21,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2466,7485,40828,7775,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',31380.00,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2467,7485,40828,7775,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',5932.73,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2468,7485,40828,7775,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',38298.82,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL);
INSERT INTO `balance_libro` VALUES (2469,7485,40828,7775,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',18000.32,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2470,7485,40828,7775,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',14999.98,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2471,7485,40828,7775,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',37100.00,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2472,7485,40828,7775,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',17199.68,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2473,7485,40828,7775,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',52522.14,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2474,7485,40828,7775,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',85168.80,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2475,7485,40828,7775,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',4749.79,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2476,7485,40828,7775,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',10887.37,NULL,NULL,1,'2023-08-15 19:00:27','2023-08-15 19:00:27',NULL),(2478,7485,40828,7775,2,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',16500.04,NULL,NULL,1,'2023-08-15 19:02:44','2023-08-15 19:02:44',NULL),(2479,7485,40828,7775,2,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',3900.00,NULL,NULL,1,'2023-08-15 19:02:44','2023-08-15 19:02:44',NULL),(2480,7485,40828,7775,2,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',400000.02,NULL,NULL,1,'2023-08-15 19:02:44','2023-08-15 19:02:44',NULL),(2481,7485,40828,7775,2,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',36400.00,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2482,7485,40828,7775,2,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',41000.00,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2483,7485,40828,7775,2,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',30780.00,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2484,7485,40828,7775,2,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',38770.00,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2485,7485,40828,7775,2,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',45000.04,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2486,7485,40828,7775,2,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',40000.02,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2487,7485,40828,7775,2,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',41000.00,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2488,7485,40828,7775,2,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',45000.04,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2489,7485,40828,7775,2,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',30900.00,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2490,7485,40828,7775,2,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',250000.00,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL);
INSERT INTO `balance_libro` VALUES (2491,7485,40828,7775,2,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',41690.06,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2492,7485,40828,7775,2,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',42000.04,NULL,NULL,1,'2023-08-15 19:02:45','2023-08-15 19:02:45',NULL),(2493,7485,40720,1561,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',270891.89,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2494,7485,40720,1561,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',14062.44,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2495,7485,40720,1561,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',338428.93,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2496,7485,40720,1561,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',27893.65,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2497,7485,40720,1561,3,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',22750.00,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2498,7485,40720,1561,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',1536567.24,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2499,7485,40720,1561,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',20839.45,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2500,7485,40720,1561,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',74620.51,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2501,7485,40720,1561,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',1110706.15,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2502,7485,40720,1561,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',338395.14,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2503,7485,40720,1561,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',358832.10,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2504,7485,40720,1561,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',199820.69,NULL,NULL,1,'2023-08-19 19:38:48','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2505,7485,40720,1561,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',21220.98,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2506,7485,40720,1561,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',233476.80,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2507,7485,40720,1561,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',167011.92,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2508,7485,40720,1561,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',301169.38,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2509,7485,40720,1561,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',39980.00,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16');
INSERT INTO `balance_libro` VALUES (2510,7485,40720,1561,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',7639.53,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2511,7485,40720,1561,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',501156.26,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2512,7485,40720,1561,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',286340.21,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2513,7485,40720,1561,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',197710.06,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2514,7485,40720,1561,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',167900.20,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2515,7485,40720,1561,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',207500.36,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2516,7485,40720,1561,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',55415.69,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2517,7485,40720,1561,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',486702.98,NULL,NULL,1,'2023-08-19 19:38:49','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2518,7485,40720,1561,2,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',56700.04,NULL,NULL,1,'2023-08-19 19:38:58','2023-10-30 20:11:29','2023-10-30 20:11:29'),(2519,7485,40720,1561,2,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',232000.00,NULL,NULL,1,'2023-08-19 19:38:58','2023-10-30 20:11:29','2023-10-30 20:11:29'),(2520,7485,40720,1561,2,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',45900.00,NULL,NULL,1,'2023-08-19 19:38:58','2023-10-30 20:11:29','2023-10-30 20:11:29'),(2521,7485,40720,1561,2,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',891200.06,NULL,NULL,1,'2023-08-19 19:38:58','2023-10-30 20:11:29','2023-10-30 20:11:29'),(2522,7485,40720,1561,2,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',725000.04,NULL,NULL,1,'2023-08-19 19:38:59','2023-10-30 20:11:30','2023-10-30 20:11:30'),(2523,7485,40720,1561,2,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',40700.04,NULL,NULL,1,'2023-08-19 19:38:59','2023-10-30 20:11:30','2023-10-30 20:11:30'),(2524,7485,40720,1561,2,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',400000.02,NULL,NULL,1,'2023-08-19 19:38:59','2023-10-30 20:11:30','2023-10-30 20:11:30'),(2525,7485,40720,1561,2,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',925000.00,NULL,NULL,1,'2023-08-19 19:38:59','2023-10-30 20:11:30','2023-10-30 20:11:30'),(2526,7485,40720,1561,2,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',867500.00,NULL,NULL,1,'2023-08-19 19:38:59','2023-10-30 20:11:30','2023-10-30 20:11:30'),(2527,7485,40720,1561,2,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',100000.00,NULL,NULL,1,'2023-08-19 19:38:59','2023-10-30 20:11:30','2023-10-30 20:11:30'),(2528,7485,40720,1561,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',5834.68,NULL,NULL,1,'2023-08-20 19:50:40','2023-10-30 20:50:16','2023-10-30 20:50:16');
INSERT INTO `balance_libro` VALUES (2529,7485,40720,1561,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',363.00,NULL,NULL,1,'2023-08-20 19:51:39','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2530,7485,40720,1561,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',363.00,NULL,NULL,1,'2023-08-20 19:52:02','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2531,7485,40720,1561,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',1089.00,NULL,NULL,1,'2023-08-20 19:56:52','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2532,7485,40720,1561,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',2904.00,NULL,NULL,1,'2023-08-20 19:57:25','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2533,7485,40720,1561,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',1452.00,NULL,NULL,1,'2023-08-20 19:58:39','2023-10-30 20:50:16','2023-10-30 20:50:16'),(2534,7485,40720,1561,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',1089.00,NULL,NULL,1,'2023-08-20 19:59:07','2023-08-20 20:09:21','2023-08-20 20:09:21'),(2535,7485,40720,1561,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',363.00,NULL,NULL,1,'2023-08-20 20:00:12','2023-10-30 20:50:17','2023-10-30 20:50:17'),(2536,7485,40720,1561,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',726.00,NULL,NULL,1,'2023-08-20 20:00:48','2023-10-30 20:50:17','2023-10-30 20:50:17'),(2537,7485,40720,1561,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',726.00,NULL,NULL,1,'2023-08-20 20:01:24','2023-10-30 20:50:17','2023-10-30 20:50:17'),(2538,7485,40720,1561,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',15983.60,NULL,NULL,1,'2023-08-20 20:02:37','2023-08-20 20:07:29','2023-08-20 20:07:29'),(2539,7485,40720,1561,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',1694.00,NULL,NULL,1,'2023-08-20 20:04:24','2023-08-20 20:08:15','2023-08-20 20:08:15'),(2540,7485,40720,1561,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',4719.00,NULL,NULL,1,'2023-08-20 20:06:26','2023-08-20 20:07:02','2023-08-20 20:07:02'),(2541,7485,40720,1561,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',4836.00,NULL,NULL,1,'2023-08-20 20:07:02','2023-08-20 20:16:43','2023-08-20 20:16:43'),(2542,7485,40720,1561,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',15983.60,NULL,NULL,1,'2023-08-20 20:07:29','2023-08-20 20:07:45','2023-08-20 20:07:45'),(2543,7485,40720,1561,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',15983.60,NULL,NULL,1,'2023-08-20 20:07:45','2023-08-20 20:08:02','2023-08-20 20:08:02'),(2544,7485,40720,1561,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',15983.60,NULL,NULL,1,'2023-08-20 20:08:02','2023-10-30 20:50:17','2023-10-30 20:50:17'),(2545,7485,40720,1561,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',1694.00,NULL,NULL,1,'2023-08-20 20:08:15','2023-10-30 20:50:17','2023-10-30 20:50:17'),(2546,7485,40720,1561,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',1089.00,NULL,NULL,1,'2023-08-20 20:09:21','2023-10-30 20:50:17','2023-10-30 20:50:17'),(2547,7485,40720,1561,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',4836.00,NULL,NULL,1,'2023-08-20 20:16:43','2023-10-30 20:50:17','2023-10-30 20:50:17');
INSERT INTO `balance_libro` VALUES (2548,7485,40828,7776,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',23728.46,NULL,NULL,1,'2023-09-01 16:21:17','2023-09-01 16:21:17',NULL),(2549,7485,40828,7776,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',10945.37,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2550,7485,40828,7776,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',141549.31,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2551,7485,40828,7776,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',121075.00,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2552,7485,40828,7776,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',13049.63,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2553,7485,40828,7776,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',4258.44,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2554,7485,40828,7776,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',39936.37,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2555,7485,40828,7776,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',17405.97,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2556,7485,40828,7776,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',96011.79,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2557,7485,40828,7776,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',181172.62,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2558,7485,40828,7776,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1090.28,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2559,7485,40828,7776,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',6278.46,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2560,7485,40828,7776,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',214154.10,NULL,NULL,1,'2023-09-01 16:21:18','2023-09-01 16:21:18',NULL),(2561,7485,40828,7776,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',428308.21,NULL,NULL,1,'2023-09-01 16:21:19','2023-09-01 16:21:19',NULL),(2562,7485,40828,7776,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',150964.27,NULL,NULL,1,'2023-09-01 16:21:19','2023-09-01 16:21:19',NULL),(2563,7485,40828,7776,3,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',72000.00,NULL,NULL,1,'2023-09-01 16:21:19','2023-09-01 16:21:19',NULL),(2564,7485,40828,7776,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',20417.06,NULL,NULL,1,'2023-09-01 16:21:19','2023-09-01 16:21:19',NULL),(2565,7485,40828,7776,2,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',27000.00,NULL,NULL,1,'2023-09-01 16:21:31','2023-09-01 16:21:31',NULL),(2566,7485,40828,7776,2,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',3900.00,NULL,NULL,1,'2023-09-01 16:21:31','2023-09-01 16:21:31',NULL),(2567,7485,40828,7776,2,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',19880.02,NULL,NULL,1,'2023-09-01 16:21:31','2023-09-01 16:21:31',NULL),(2568,7485,40828,7776,2,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3900.00,NULL,NULL,1,'2023-09-01 16:21:31','2023-09-01 16:21:31',NULL);
INSERT INTO `balance_libro` VALUES (2569,7485,40828,7776,2,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',283240.06,NULL,NULL,1,'2023-09-01 16:21:31','2023-09-01 16:21:31',NULL),(2570,7485,40828,7776,2,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',46300.04,NULL,NULL,1,'2023-09-01 16:21:31','2023-09-01 16:21:31',NULL),(2571,7485,40828,7776,2,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',262000.00,NULL,NULL,1,'2023-09-01 16:21:31','2023-09-01 16:21:31',NULL),(2572,7485,40828,7776,2,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',370230.00,NULL,NULL,1,'2023-09-01 16:21:32','2023-09-01 16:21:32',NULL),(2573,7485,40828,7776,2,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',46000.00,NULL,NULL,1,'2023-09-01 16:21:32','2023-09-01 16:21:32',NULL),(2574,7485,40828,7776,2,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',200000.00,NULL,NULL,1,'2023-09-01 16:21:32','2023-09-01 16:21:32',NULL),(2575,7485,40828,7776,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',3900.00,NULL,NULL,1,'2023-09-01 16:21:32','2023-09-01 16:21:32',NULL),(2576,7485,40828,7776,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',42000.04,NULL,NULL,1,'2023-09-01 16:21:32','2023-09-01 16:21:32',NULL),(2577,7485,40828,7776,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',8800.00,NULL,NULL,1,'2023-09-01 16:21:32','2023-09-01 16:21:32',NULL),(2578,7485,40828,7776,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3900.00,NULL,NULL,1,'2023-09-01 16:21:32','2023-09-01 16:21:32',NULL),(2579,7485,40828,7776,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3900.00,NULL,NULL,1,'2023-09-01 16:21:32','2023-09-01 16:21:32',NULL),(2580,7485,40828,7776,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3900.00,NULL,NULL,1,'2023-09-01 16:21:32','2023-09-01 16:21:32',NULL),(2581,7485,40723,6071,3,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',1500.00,NULL,NULL,1,'2023-09-01 17:38:33','2023-09-18 21:14:58','2023-09-18 21:14:58'),(2582,7485,40723,6071,3,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',550864.59,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:14:51','2023-09-18 21:14:51'),(2583,7485,40723,6071,3,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',8314.01,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:14:39','2023-09-18 21:14:39'),(2584,7485,40723,6071,3,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1412481.18,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:14:33','2023-09-18 21:14:33'),(2585,7485,40723,6071,3,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',23313.20,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:14:27','2023-09-18 21:14:27'),(2586,7485,40723,6071,3,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',12801.84,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:14:01','2023-09-18 21:14:01'),(2587,7485,40723,6071,3,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',5168.00,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:13:44','2023-09-18 21:13:44'),(2588,7485,40723,6071,3,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',14615.40,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:13:28','2023-09-18 21:13:28');
INSERT INTO `balance_libro` VALUES (2589,7485,40723,6071,3,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-13','2023-08-13',14271.37,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:13:13','2023-09-18 21:13:13'),(2590,7485,40723,6071,3,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',5433.61,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:13:04','2023-09-18 21:13:04'),(2591,7485,40723,6071,3,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',510.00,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:12:57','2023-09-18 21:12:57'),(2592,7485,40723,6071,3,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',119999.00,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:12:51','2023-09-18 21:12:51'),(2593,7485,40723,6071,3,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',1500.00,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:12:44','2023-09-18 21:12:44'),(2594,7485,40723,6071,3,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',650.00,NULL,NULL,1,'2023-09-01 17:38:34','2023-09-18 21:12:36','2023-09-18 21:12:36'),(2595,7485,40723,6071,3,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',17047.43,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:12:30','2023-09-18 21:12:30'),(2596,7485,40723,6071,3,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',359.26,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:12:22','2023-09-18 21:12:22'),(2597,7485,40723,6071,3,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',10852.61,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:12:16','2023-09-18 21:12:16'),(2598,7485,40723,6071,3,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',195153.27,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:12:11','2023-09-18 21:12:11'),(2599,7485,40723,6071,3,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',15996.00,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:12:05','2023-09-18 21:12:05'),(2600,7485,40723,6071,3,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',15996.00,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:11:58','2023-09-18 21:11:58'),(2601,7485,40723,6071,3,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',6402.07,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:11:52','2023-09-18 21:11:52'),(2602,7485,40723,6071,3,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',5073856.51,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:11:44','2023-09-18 21:11:44'),(2603,7485,40723,6071,3,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',9762.40,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:11:38','2023-09-18 21:11:38'),(2604,7485,40723,6071,3,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',24950.04,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:11:32','2023-09-18 21:11:32'),(2605,7485,40723,6071,3,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',36992.31,NULL,NULL,1,'2023-09-01 17:38:35','2023-09-18 21:11:20','2023-09-18 21:11:20'),(4532,7485,40723,6071,2,4480,'App\\Models\\Receipt',4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',2023.75,NULL,NULL,1,'2023-09-01 17:58:50','2023-09-01 17:58:50',NULL),(4533,7485,40723,6071,2,4481,'App\\Models\\Receipt',4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',11346.01,NULL,NULL,1,'2023-09-01 17:58:50','2023-09-01 17:58:50',NULL);
INSERT INTO `balance_libro` VALUES (4534,7485,40723,6071,2,4482,'App\\Models\\Receipt',4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',7303.50,NULL,NULL,1,'2023-09-01 17:58:50','2023-09-01 17:58:50',NULL),(4535,7485,40723,6071,2,4483,'App\\Models\\Receipt',4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',8511.10,NULL,NULL,1,'2023-09-01 17:58:50','2023-09-01 17:58:50',NULL),(4536,7485,40723,6071,2,4484,'App\\Models\\Receipt',4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',845.41,NULL,NULL,1,'2023-09-01 17:58:50','2023-09-01 17:58:50',NULL),(4537,7485,40723,6071,2,4485,'App\\Models\\Receipt',4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',2935.82,NULL,NULL,1,'2023-09-01 17:58:50','2023-09-01 17:58:50',NULL),(4538,7485,40723,6071,2,4486,'App\\Models\\Receipt',4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',1687.06,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4539,7485,40723,6071,2,4487,'App\\Models\\Receipt',4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',620.88,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4540,7485,40723,6071,2,4488,'App\\Models\\Receipt',4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',2197.24,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4541,7485,40723,6071,2,4489,'App\\Models\\Receipt',4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',2548.56,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4542,7485,40723,6071,2,4490,'App\\Models\\Receipt',4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',5557.48,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4543,7485,40723,6071,2,4491,'App\\Models\\Receipt',4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',4643.70,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4544,7485,40723,6071,2,4492,'App\\Models\\Receipt',4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',758.80,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4545,7485,40723,6071,2,4493,'App\\Models\\Receipt',4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',888.74,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4546,7485,40723,6071,2,4494,'App\\Models\\Receipt',4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',1072.19,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4547,7485,40723,6071,2,4495,'App\\Models\\Receipt',4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',5086.68,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4548,7485,40723,6071,2,4496,'App\\Models\\Receipt',4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',4032.42,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4549,7485,40723,6071,2,4497,'App\\Models\\Receipt',4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',866.10,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4550,7485,40723,6071,2,4498,'App\\Models\\Receipt',4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',4377.44,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4551,7485,40723,6071,2,4499,'App\\Models\\Receipt',4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',719.39,NULL,NULL,1,'2023-09-01 17:58:51','2023-09-01 17:58:51',NULL),(4552,7485,40723,6071,2,4500,'App\\Models\\Receipt',4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',5774.20,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4553,7485,40723,6071,2,4501,'App\\Models\\Receipt',4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',1574.06,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4554,7485,40723,6071,2,4502,'App\\Models\\Receipt',4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',1177.10,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL);
INSERT INTO `balance_libro` VALUES (4555,7485,40723,6071,2,4503,'App\\Models\\Receipt',4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',756.37,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4556,7485,40723,6071,2,4504,'App\\Models\\Receipt',4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',1591.40,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4557,7485,40723,6071,2,4505,'App\\Models\\Receipt',4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',3942.04,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4558,7485,40723,6071,2,4506,'App\\Models\\Receipt',4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',4809.19,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4559,7485,40723,6071,2,4507,'App\\Models\\Receipt',4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',38945.76,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4560,7485,40723,6071,2,4508,'App\\Models\\Receipt',4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',2987.23,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4561,7485,40723,6071,2,4509,'App\\Models\\Receipt',4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',3910.56,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4562,7485,40723,6071,2,4510,'App\\Models\\Receipt',4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',655.26,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4563,7485,40723,6071,2,4511,'App\\Models\\Receipt',4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',1863.98,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4564,7485,40723,6071,2,4512,'App\\Models\\Receipt',4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',1241.64,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4565,7485,40723,6071,2,4513,'App\\Models\\Receipt',4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',48902.54,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4566,7485,40723,6071,2,4514,'App\\Models\\Receipt',4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',1534.98,NULL,NULL,1,'2023-09-01 17:58:52','2023-09-01 17:58:52',NULL),(4567,7485,40723,6071,2,4515,'App\\Models\\Receipt',4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',2934.20,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4568,7485,40723,6071,2,4516,'App\\Models\\Receipt',4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',1271.50,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4569,7485,40723,6071,2,4517,'App\\Models\\Receipt',4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',18610.50,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4570,7485,40723,6071,2,4518,'App\\Models\\Receipt',4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',1104.64,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4571,7485,40723,6071,2,4519,'App\\Models\\Receipt',4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',41428.64,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4572,7485,40723,6071,2,4520,'App\\Models\\Receipt',4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',4969.59,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4573,7485,40723,6071,2,4521,'App\\Models\\Receipt',4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',859.65,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4574,7485,40723,6071,2,4522,'App\\Models\\Receipt',4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',13976.61,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4575,7485,40723,6071,2,4523,'App\\Models\\Receipt',4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',27056.21,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL);
INSERT INTO `balance_libro` VALUES (4576,7485,40723,6071,2,4524,'App\\Models\\Receipt',4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',643.91,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4577,7485,40723,6071,2,4525,'App\\Models\\Receipt',4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',2031.74,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4578,7485,40723,6071,2,4526,'App\\Models\\Receipt',4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',2344.38,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4579,7485,40723,6071,2,4527,'App\\Models\\Receipt',4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',14493.68,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4580,7485,40723,6071,2,4528,'App\\Models\\Receipt',4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1275.14,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4581,7485,40723,6071,2,4529,'App\\Models\\Receipt',4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1275.14,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4582,7485,40723,6071,2,4530,'App\\Models\\Receipt',4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',6922.78,NULL,NULL,1,'2023-09-01 17:58:53','2023-09-01 17:58:53',NULL),(4583,7485,40723,6071,2,4531,'App\\Models\\Receipt',4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',19499.50,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4584,7485,40723,6071,2,4532,'App\\Models\\Receipt',4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',2846.34,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4585,7485,40723,6071,2,4533,'App\\Models\\Receipt',4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',25453.35,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4586,7485,40723,6071,2,4534,'App\\Models\\Receipt',4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1315.64,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4587,7485,40723,6071,2,4535,'App\\Models\\Receipt',4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',836.47,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4588,7485,40723,6071,2,4536,'App\\Models\\Receipt',4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',635.79,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4589,7485,40723,6071,2,4537,'App\\Models\\Receipt',4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1294.01,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4590,7485,40723,6071,2,4538,'App\\Models\\Receipt',4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1848.96,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4591,7485,40723,6071,2,4539,'App\\Models\\Receipt',4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1109.28,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4592,7485,40723,6071,2,4540,'App\\Models\\Receipt',4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',3946.79,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4593,7485,40723,6071,2,4541,'App\\Models\\Receipt',4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1044.78,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4594,7485,40723,6071,2,4542,'App\\Models\\Receipt',4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',10498.54,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4595,7485,40723,6071,2,4543,'App\\Models\\Receipt',4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1809.43,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4596,7485,40723,6071,2,4544,'App\\Models\\Receipt',4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',2276.38,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL);
INSERT INTO `balance_libro` VALUES (4597,7485,40723,6071,2,4545,'App\\Models\\Receipt',4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',952.06,NULL,NULL,1,'2023-09-01 17:58:54','2023-09-01 17:58:54',NULL),(4598,7485,40723,6071,2,4546,'App\\Models\\Receipt',4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1909.97,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4599,7485,40723,6071,2,4547,'App\\Models\\Receipt',4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',3005.48,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4600,7485,40723,6071,2,4548,'App\\Models\\Receipt',4548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',2140.80,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4601,7485,40723,6071,2,4549,'App\\Models\\Receipt',4549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',5774.19,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4602,7485,40723,6071,2,4550,'App\\Models\\Receipt',4550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',363.54,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4603,7485,40723,6071,2,4551,'App\\Models\\Receipt',4551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',249002.04,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4604,7485,40723,6071,2,4552,'App\\Models\\Receipt',4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',5726.82,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4605,7485,40723,6071,2,4553,'App\\Models\\Receipt',4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',4622.35,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4606,7485,40723,6071,2,4554,'App\\Models\\Receipt',4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',2148.29,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4607,7485,40723,6071,2,4555,'App\\Models\\Receipt',4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',2168.09,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4608,7485,40723,6071,2,4556,'App\\Models\\Receipt',4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',4311.64,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4609,7485,40723,6071,2,4557,'App\\Models\\Receipt',4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',2155.83,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4610,7485,40723,6071,2,4558,'App\\Models\\Receipt',4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',1050.65,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4611,7485,40723,6071,2,4559,'App\\Models\\Receipt',4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',5507.59,NULL,NULL,1,'2023-09-01 17:58:55','2023-09-01 17:58:55',NULL),(4612,7485,40723,6071,2,4560,'App\\Models\\Receipt',4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',1687.06,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4613,7485,40723,6071,2,4561,'App\\Models\\Receipt',4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',25453.34,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4614,7485,40723,6071,2,4562,'App\\Models\\Receipt',4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',25453.35,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4615,7485,40723,6071,2,4563,'App\\Models\\Receipt',4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',3940.75,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4616,7485,40723,6071,2,4564,'App\\Models\\Receipt',4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',8979.12,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4617,7485,40723,6071,2,4565,'App\\Models\\Receipt',4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',728.02,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL);
INSERT INTO `balance_libro` VALUES (4618,7485,40723,6071,2,4566,'App\\Models\\Receipt',4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',20525.11,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4619,7485,40723,6071,2,4567,'App\\Models\\Receipt',4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',777.07,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4620,7485,40723,6071,2,4568,'App\\Models\\Receipt',4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',20799.98,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4621,7485,40723,6071,2,4569,'App\\Models\\Receipt',4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',17322.60,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4622,7485,40723,6071,2,4570,'App\\Models\\Receipt',4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',3727.96,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4623,7485,40723,6071,2,4571,'App\\Models\\Receipt',4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',3497.56,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4624,7485,40723,6071,2,4572,'App\\Models\\Receipt',4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',14000.13,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4625,7485,40723,6071,2,4573,'App\\Models\\Receipt',4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',5290.59,NULL,NULL,1,'2023-09-01 17:58:56','2023-09-01 17:58:56',NULL),(4626,7485,40723,6071,2,4574,'App\\Models\\Receipt',4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1438.24,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4627,7485,40723,6071,2,4575,'App\\Models\\Receipt',4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1601.66,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4628,7485,40723,6071,2,4576,'App\\Models\\Receipt',4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',3534.20,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4629,7485,40723,6071,2,4577,'App\\Models\\Receipt',4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',2222.98,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4630,7485,40723,6071,2,4578,'App\\Models\\Receipt',4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',6025.10,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4631,7485,40723,6071,2,4579,'App\\Models\\Receipt',4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',4868.55,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4632,7485,40723,6071,2,4580,'App\\Models\\Receipt',4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1177.10,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4633,7485,40723,6071,2,4581,'App\\Models\\Receipt',4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1707.72,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4634,7485,40723,6071,2,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',2148.29,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4635,7485,40723,6071,2,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',898.12,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4636,7485,40723,6071,2,4584,'App\\Models\\Receipt',4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',15260.02,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4637,7485,40723,6071,2,4585,'App\\Models\\Receipt',4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1796.24,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4638,7485,40723,6071,2,4586,'App\\Models\\Receipt',4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',3788.65,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL);
INSERT INTO `balance_libro` VALUES (4639,7485,40723,6071,2,4587,'App\\Models\\Receipt',4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',5131.28,NULL,NULL,1,'2023-09-01 17:58:57','2023-09-01 17:58:57',NULL),(4640,7485,40723,6071,2,4588,'App\\Models\\Receipt',4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',4639.96,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4641,7485,40723,6071,2,4589,'App\\Models\\Receipt',4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',2218.02,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4642,7485,40723,6071,2,4590,'App\\Models\\Receipt',4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1707.72,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4643,7485,40723,6071,2,4591,'App\\Models\\Receipt',4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',3805.18,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4644,7485,40723,6071,2,4592,'App\\Models\\Receipt',4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',25179.52,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4645,7485,40723,6071,2,4593,'App\\Models\\Receipt',4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',3073.76,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4646,7485,40723,6071,2,4594,'App\\Models\\Receipt',4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',8190.56,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4647,7485,40723,6071,2,4595,'App\\Models\\Receipt',4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',758.80,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4648,7485,40723,6071,2,4596,'App\\Models\\Receipt',4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',10421.47,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4649,7485,40723,6071,2,4597,'App\\Models\\Receipt',4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',2428.90,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4650,7485,40723,6071,2,4598,'App\\Models\\Receipt',4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',2515.42,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4651,7485,40723,6071,2,4599,'App\\Models\\Receipt',4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',2100.18,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4652,7485,40723,6071,2,4600,'App\\Models\\Receipt',4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1781.12,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4653,7485,40723,6071,2,4601,'App\\Models\\Receipt',4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',2361.09,NULL,NULL,1,'2023-09-01 17:58:58','2023-09-01 17:58:58',NULL),(4654,7485,40723,6071,2,4602,'App\\Models\\Receipt',4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',6281.03,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4655,7485,40723,6071,2,4603,'App\\Models\\Receipt',4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',300667.39,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4656,7485,40723,6071,2,4604,'App\\Models\\Receipt',4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',2283.70,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4657,7485,40723,6071,2,4605,'App\\Models\\Receipt',4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1355.78,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4658,7485,40723,6071,2,4606,'App\\Models\\Receipt',4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1242.69,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4659,7485,40723,6071,2,4607,'App\\Models\\Receipt',4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',444.37,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL);
INSERT INTO `balance_libro` VALUES (4660,7485,40723,6071,2,4608,'App\\Models\\Receipt',4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',15261.52,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4661,7485,40723,6071,2,4609,'App\\Models\\Receipt',4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',994.11,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4662,7485,40723,6071,2,4610,'App\\Models\\Receipt',4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',3677.21,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4663,7485,40723,6071,2,4611,'App\\Models\\Receipt',4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',757.65,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4664,7485,40723,6071,2,4612,'App\\Models\\Receipt',4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',4428.38,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4665,7485,40723,6071,2,4613,'App\\Models\\Receipt',4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1177.10,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4666,7485,40723,6071,2,4614,'App\\Models\\Receipt',4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1022.36,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4667,7485,40723,6071,2,4615,'App\\Models\\Receipt',4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',3023.82,NULL,NULL,1,'2023-09-01 17:58:59','2023-09-01 17:58:59',NULL),(4668,7485,40723,6071,2,4616,'App\\Models\\Receipt',4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',19119.85,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4669,7485,40723,6071,2,4617,'App\\Models\\Receipt',4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',21449.45,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4670,7485,40723,6071,2,4618,'App\\Models\\Receipt',4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1177.10,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4671,7485,40723,6071,2,4619,'App\\Models\\Receipt',4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1214.45,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4672,7485,40723,6071,2,4620,'App\\Models\\Receipt',4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',13912.15,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4673,7485,40723,6071,2,4621,'App\\Models\\Receipt',4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',924.46,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4674,7485,40723,6071,2,4622,'App\\Models\\Receipt',4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',4108.30,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4675,7485,40723,6071,2,4623,'App\\Models\\Receipt',4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',3248.51,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4676,7485,40723,6071,2,4624,'App\\Models\\Receipt',4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',5346.48,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4677,7485,40723,6071,2,4625,'App\\Models\\Receipt',4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',4803.57,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4678,7485,40723,6071,2,4626,'App\\Models\\Receipt',4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',3899.12,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4679,7485,40723,6071,2,4627,'App\\Models\\Receipt',4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',879.28,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL),(4680,7485,40723,6071,2,4628,'App\\Models\\Receipt',4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1482.21,NULL,NULL,1,'2023-09-01 17:59:00','2023-09-01 17:59:00',NULL);
INSERT INTO `balance_libro` VALUES (4681,7485,40723,6071,2,4629,'App\\Models\\Receipt',4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',3221.62,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4682,7485,40723,6071,2,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1988.22,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4683,7485,40723,6071,2,4631,'App\\Models\\Receipt',4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',886.81,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4684,7485,40723,6071,2,4632,'App\\Models\\Receipt',4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',2392.35,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4685,7485,40723,6071,2,4633,'App\\Models\\Receipt',4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',4878.35,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4686,7485,40723,6071,2,4634,'App\\Models\\Receipt',4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1822.56,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4687,7485,40723,6071,2,4635,'App\\Models\\Receipt',4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',2887.31,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4688,7485,40723,6071,2,4636,'App\\Models\\Receipt',4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',898.12,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4689,7485,40723,6071,2,4637,'App\\Models\\Receipt',4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',3788.59,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4690,7485,40723,6071,2,4638,'App\\Models\\Receipt',4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',3460.61,NULL,NULL,1,'2023-09-01 17:59:01','2023-09-01 17:59:01',NULL),(4691,7485,40723,6071,2,4639,'App\\Models\\Receipt',4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',2160.96,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4692,7485,40723,6071,2,4640,'App\\Models\\Receipt',4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',166192.38,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4693,7485,40723,6071,2,4641,'App\\Models\\Receipt',4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',10251.93,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4694,7485,40723,6071,2,4642,'App\\Models\\Receipt',4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',17730.21,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4695,7485,40723,6071,2,4643,'App\\Models\\Receipt',4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',3453.07,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4696,7485,40723,6071,2,4644,'App\\Models\\Receipt',4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',166192.38,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4697,7485,40723,6071,2,4645,'App\\Models\\Receipt',4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',166192.38,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4698,7485,40723,6071,2,4646,'App\\Models\\Receipt',4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',1705.83,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4699,7485,40723,6071,2,4647,'App\\Models\\Receipt',4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',2148.29,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4700,7485,40723,6071,2,4648,'App\\Models\\Receipt',4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',10413.73,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4701,7485,40723,6071,2,4649,'App\\Models\\Receipt',4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',6992.32,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL);
INSERT INTO `balance_libro` VALUES (4702,7485,40723,6071,2,4650,'App\\Models\\Receipt',4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',3867.28,NULL,NULL,1,'2023-09-01 17:59:02','2023-09-01 17:59:02',NULL),(4703,7485,40723,6071,2,4651,'App\\Models\\Receipt',4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',2283.70,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4704,7485,40723,6071,2,4652,'App\\Models\\Receipt',4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',1023.11,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4705,7485,40723,6071,2,4653,'App\\Models\\Receipt',4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',6376.12,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4706,7485,40723,6071,2,4654,'App\\Models\\Receipt',4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',3086.32,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4707,7485,40723,6071,2,4655,'App\\Models\\Receipt',4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',14000.12,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4708,7485,40723,6071,2,4656,'App\\Models\\Receipt',4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',583.69,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4709,7485,40723,6071,2,4657,'App\\Models\\Receipt',4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',470893.23,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4710,7485,40723,6071,2,4658,'App\\Models\\Receipt',4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',1103239.75,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4711,7485,40723,6071,2,4659,'App\\Models\\Receipt',4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',27976.65,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4712,7485,40723,6071,2,4660,'App\\Models\\Receipt',4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',11959.51,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4713,7485,40723,6071,2,4661,'App\\Models\\Receipt',4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',681.36,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4714,7485,40723,6071,2,4662,'App\\Models\\Receipt',4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',2678.36,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4715,7485,40723,6071,2,4663,'App\\Models\\Receipt',4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',6780.32,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4716,7485,40723,6071,2,4664,'App\\Models\\Receipt',4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',10753.02,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4717,7485,40723,6071,2,4665,'App\\Models\\Receipt',4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',3588.53,NULL,NULL,1,'2023-09-01 17:59:03','2023-09-01 17:59:03',NULL),(4718,7485,40723,6071,2,4666,'App\\Models\\Receipt',4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',758.80,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4719,7485,40723,6071,2,4667,'App\\Models\\Receipt',4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',787.03,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4720,7485,40723,6071,2,4668,'App\\Models\\Receipt',4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',1238.71,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4721,7485,40723,6071,2,4669,'App\\Models\\Receipt',4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',11410.55,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4722,7485,40723,6071,2,4670,'App\\Models\\Receipt',4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',18489.15,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL);
INSERT INTO `balance_libro` VALUES (4723,7485,40723,6071,2,4671,'App\\Models\\Receipt',4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',758.80,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4724,7485,40723,6071,2,4672,'App\\Models\\Receipt',4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',16839.88,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4725,7485,40723,6071,2,4673,'App\\Models\\Receipt',4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10839.99,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4726,7485,40723,6071,2,4674,'App\\Models\\Receipt',4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',22733.81,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4727,7485,40723,6071,2,4675,'App\\Models\\Receipt',4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',14000.12,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4728,7485,40723,6071,2,4676,'App\\Models\\Receipt',4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',17730.21,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4729,7485,40723,6071,2,4677,'App\\Models\\Receipt',4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1707.72,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4730,7485,40723,6071,2,4678,'App\\Models\\Receipt',4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7139.63,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4731,7485,40723,6071,2,4679,'App\\Models\\Receipt',4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',6467.47,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4732,7485,40723,6071,2,4680,'App\\Models\\Receipt',4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',8781.43,NULL,NULL,1,'2023-09-01 17:59:04','2023-09-01 17:59:04',NULL),(4733,7485,40723,6071,2,4681,'App\\Models\\Receipt',4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',682.06,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4734,7485,40723,6071,2,4682,'App\\Models\\Receipt',4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',5842.35,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4735,7485,40723,6071,2,4683,'App\\Models\\Receipt',4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',17990.99,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4736,7485,40723,6071,2,4684,'App\\Models\\Receipt',4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',3496.15,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4737,7485,40723,6071,2,4685,'App\\Models\\Receipt',4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',17730.21,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4738,7485,40723,6071,2,4686,'App\\Models\\Receipt',4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7388.39,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4739,7485,40723,6071,2,4687,'App\\Models\\Receipt',4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',5326.44,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4740,7485,40723,6071,2,4688,'App\\Models\\Receipt',4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',50362.17,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4741,7485,40723,6071,2,4689,'App\\Models\\Receipt',4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',8443.90,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4742,7485,40723,6071,2,4690,'App\\Models\\Receipt',4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',23264.51,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4743,7485,40723,6071,2,4691,'App\\Models\\Receipt',4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',5049.93,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL);
INSERT INTO `balance_libro` VALUES (4744,7485,40723,6071,2,4692,'App\\Models\\Receipt',4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2076.77,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4745,7485,40723,6071,2,4693,'App\\Models\\Receipt',4693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1137.25,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4746,7485,40723,6071,2,4694,'App\\Models\\Receipt',4694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',20388.34,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4747,7485,40723,6071,2,4695,'App\\Models\\Receipt',4695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',4684.51,NULL,NULL,1,'2023-09-01 17:59:05','2023-09-01 17:59:05',NULL),(4748,7485,40723,6071,2,4696,'App\\Models\\Receipt',4696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2253.32,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4749,7485,40723,6071,2,4697,'App\\Models\\Receipt',4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',8856.74,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4750,7485,40723,6071,2,4698,'App\\Models\\Receipt',4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',4622.35,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4751,7485,40723,6071,2,4699,'App\\Models\\Receipt',4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2155.83,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4752,7485,40723,6071,2,4700,'App\\Models\\Receipt',4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',4825.38,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4753,7485,40723,6071,2,4701,'App\\Models\\Receipt',4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7645.66,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4754,7485,40723,6071,2,4702,'App\\Models\\Receipt',4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1346.69,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4755,7485,40723,6071,2,4703,'App\\Models\\Receipt',4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1276.91,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4756,7485,40723,6071,2,4704,'App\\Models\\Receipt',4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1304.80,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4757,7485,40723,6071,2,4705,'App\\Models\\Receipt',4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',4530.84,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4758,7485,40723,6071,2,4706,'App\\Models\\Receipt',4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1447.80,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4759,7485,40723,6071,2,4707,'App\\Models\\Receipt',4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',11089.60,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4760,7485,40723,6071,2,4708,'App\\Models\\Receipt',4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',5997.76,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4761,7485,40723,6071,2,4709,'App\\Models\\Receipt',4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',15879.84,NULL,NULL,1,'2023-09-01 17:59:06','2023-09-01 17:59:06',NULL),(4762,7485,40723,6071,2,4710,'App\\Models\\Receipt',4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',540.24,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4763,7485,40723,6071,2,4711,'App\\Models\\Receipt',4711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',3040.27,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4764,7485,40723,6071,2,4712,'App\\Models\\Receipt',4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',17730.21,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL);
INSERT INTO `balance_libro` VALUES (4765,7485,40723,6071,2,4713,'App\\Models\\Receipt',4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1132.70,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4766,7485,40723,6071,2,4714,'App\\Models\\Receipt',4714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2321.84,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4767,7485,40723,6071,2,4715,'App\\Models\\Receipt',4715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2361.09,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4768,7485,40723,6071,2,4716,'App\\Models\\Receipt',4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',50362.17,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4769,7485,40723,6071,2,4717,'App\\Models\\Receipt',4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10791.93,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4770,7485,40723,6071,2,4718,'App\\Models\\Receipt',4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',795.38,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4771,7485,40723,6071,2,4719,'App\\Models\\Receipt',4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',758.80,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4772,7485,40723,6071,2,4720,'App\\Models\\Receipt',4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7582.06,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4773,7485,40723,6071,2,4721,'App\\Models\\Receipt',4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2253.32,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4774,7485,40723,6071,2,4722,'App\\Models\\Receipt',4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',11392.22,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4775,7485,40723,6071,2,4723,'App\\Models\\Receipt',4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1304.80,NULL,NULL,1,'2023-09-01 17:59:07','2023-09-01 17:59:07',NULL),(4776,7485,40723,6071,2,4724,'App\\Models\\Receipt',4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1848.96,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4777,7485,40723,6071,2,4725,'App\\Models\\Receipt',4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',4622.35,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4778,7485,40723,6071,2,4726,'App\\Models\\Receipt',4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7124.78,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4779,7485,40723,6071,2,4727,'App\\Models\\Receipt',4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',26570.22,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4780,7485,40723,6071,2,4728,'App\\Models\\Receipt',4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',15393.86,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4781,7485,40723,6071,2,4729,'App\\Models\\Receipt',4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',11410.55,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4782,7485,40723,6071,2,4730,'App\\Models\\Receipt',4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10319.65,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4783,7485,40723,6071,2,4731,'App\\Models\\Receipt',4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',8204.20,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4784,7485,40723,6071,2,4732,'App\\Models\\Receipt',4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',26934.95,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4785,7485,40723,6071,2,4733,'App\\Models\\Receipt',4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',800.87,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL);
INSERT INTO `balance_libro` VALUES (4786,7485,40723,6071,2,4734,'App\\Models\\Receipt',4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2168.09,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4787,7485,40723,6071,2,4735,'App\\Models\\Receipt',4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',42898.96,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4788,7485,40723,6071,2,4736,'App\\Models\\Receipt',4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',14000.13,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4789,7485,40723,6071,2,4737,'App\\Models\\Receipt',4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10498.55,NULL,NULL,1,'2023-09-01 17:59:08','2023-09-01 17:59:08',NULL),(4790,7485,40723,6071,2,4738,'App\\Models\\Receipt',4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1022.36,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4791,7485,40723,6071,2,4739,'App\\Models\\Receipt',4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',5810.37,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4792,7485,40723,6071,2,4740,'App\\Models\\Receipt',4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1707.72,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4793,7485,40723,6071,2,4741,'App\\Models\\Receipt',4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',681.36,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4794,7485,40723,6071,2,4742,'App\\Models\\Receipt',4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1362.70,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4795,7485,40723,6071,2,4743,'App\\Models\\Receipt',4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',8024.34,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4796,7485,40723,6071,2,4744,'App\\Models\\Receipt',4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',4428.38,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4797,7485,40723,6071,2,4745,'App\\Models\\Receipt',4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',4067.92,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4798,7485,40723,6071,2,4746,'App\\Models\\Receipt',4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',6699.80,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4799,7485,40723,6071,2,4747,'App\\Models\\Receipt',4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',11392.90,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4800,7485,40723,6071,2,4748,'App\\Models\\Receipt',4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',3080.27,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4801,7485,40723,6071,2,4749,'App\\Models\\Receipt',4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',896.22,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4802,7485,40723,6071,2,4750,'App\\Models\\Receipt',4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',11410.55,NULL,NULL,1,'2023-09-01 17:59:09','2023-09-01 17:59:09',NULL),(4803,7485,40723,6071,2,4751,'App\\Models\\Receipt',4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7106.90,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4804,7485,40723,6071,2,4752,'App\\Models\\Receipt',4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',16388.93,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4805,7485,40723,6071,2,4753,'App\\Models\\Receipt',4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',3501.05,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4806,7485,40723,6071,2,4754,'App\\Models\\Receipt',4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',6004.34,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL);
INSERT INTO `balance_libro` VALUES (4807,7485,40723,6071,2,4755,'App\\Models\\Receipt',4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',5810.37,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4808,7485,40723,6071,2,4756,'App\\Models\\Receipt',4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',11548.42,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4809,7485,40723,6071,2,4757,'App\\Models\\Receipt',4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',9063.10,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4810,7485,40723,6071,2,4758,'App\\Models\\Receipt',4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',30044.94,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4811,7485,40723,6071,2,4759,'App\\Models\\Receipt',4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',7465.49,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4812,7485,40723,6071,2,4760,'App\\Models\\Receipt',4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',1642.37,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4813,7485,40723,6071,2,4761,'App\\Models\\Receipt',4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',10404.34,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4814,7485,40723,6071,2,4762,'App\\Models\\Receipt',4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',1642.37,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4815,7485,40723,6071,2,4763,'App\\Models\\Receipt',4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',18048.99,NULL,NULL,1,'2023-09-01 17:59:10','2023-09-01 17:59:10',NULL),(4816,7485,40723,6071,2,4764,'App\\Models\\Receipt',4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',798.10,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4817,7485,40723,6071,2,4765,'App\\Models\\Receipt',4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',1429.03,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4818,7485,40723,6071,2,4766,'App\\Models\\Receipt',4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',5184.98,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4819,7485,40723,6071,2,4767,'App\\Models\\Receipt',4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',3284.76,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4820,7485,40723,6071,2,4768,'App\\Models\\Receipt',4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',2692.42,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4821,7485,40723,6071,2,4769,'App\\Models\\Receipt',4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',34541.30,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4822,7485,40723,6071,2,4770,'App\\Models\\Receipt',4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',3894.28,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4823,7485,40723,6071,2,4771,'App\\Models\\Receipt',4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',2164.63,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4824,7485,40723,6071,2,4772,'App\\Models\\Receipt',4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',12096.38,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4825,7485,40723,6071,2,4773,'App\\Models\\Receipt',4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',2792.82,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4826,7485,40723,6071,2,4774,'App\\Models\\Receipt',4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',1696.26,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4827,7485,40723,6071,2,4775,'App\\Models\\Receipt',4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',3430.00,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL);
INSERT INTO `balance_libro` VALUES (4828,7485,40723,6071,2,4776,'App\\Models\\Receipt',4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',6590.72,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4829,7485,40723,6071,2,4777,'App\\Models\\Receipt',4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',3298.47,NULL,NULL,1,'2023-09-01 17:59:11','2023-09-01 17:59:11',NULL),(4830,7485,40723,6071,2,4778,'App\\Models\\Receipt',4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',4807.22,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4831,7485,40723,6071,2,4779,'App\\Models\\Receipt',4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',21961.86,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4832,7485,40723,6071,2,4780,'App\\Models\\Receipt',4780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1661.34,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4833,7485,40723,6071,2,4781,'App\\Models\\Receipt',4781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',22440.08,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4834,7485,40723,6071,2,4782,'App\\Models\\Receipt',4782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',6009.05,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4835,7485,40723,6071,2,4783,'App\\Models\\Receipt',4783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',2188.32,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4836,7485,40723,6071,2,4784,'App\\Models\\Receipt',4784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',10092.05,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4837,7485,40723,6071,2,4785,'App\\Models\\Receipt',4785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',13217.37,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4838,7485,40723,6071,2,4786,'App\\Models\\Receipt',4786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',3069.33,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4839,7485,40723,6071,2,4787,'App\\Models\\Receipt',4787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1138.75,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4840,7485,40723,6071,2,4788,'App\\Models\\Receipt',4788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1429.03,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4841,7485,40723,6071,2,4789,'App\\Models\\Receipt',4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',11722.04,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4842,7485,40723,6071,2,4790,'App\\Models\\Receipt',4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',2335.08,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4843,7485,40723,6071,2,4791,'App\\Models\\Receipt',4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',8370.39,NULL,NULL,1,'2023-09-01 17:59:12','2023-09-01 17:59:12',NULL),(4844,7485,40723,6071,2,4792,'App\\Models\\Receipt',4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',8505.22,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4845,7485,40723,6071,2,4793,'App\\Models\\Receipt',4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',27158.82,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4846,7485,40723,6071,2,4794,'App\\Models\\Receipt',4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1861.57,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4847,7485,40723,6071,2,4795,'App\\Models\\Receipt',4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1338.68,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4848,7485,40723,6071,2,4796,'App\\Models\\Receipt',4796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',4792.55,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL);
INSERT INTO `balance_libro` VALUES (4849,7485,40723,6071,2,4797,'App\\Models\\Receipt',4797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',2601.94,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4850,7485,40723,6071,2,4798,'App\\Models\\Receipt',4798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1478.41,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4851,7485,40723,6071,2,4799,'App\\Models\\Receipt',4799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1429.03,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4852,7485,40723,6071,2,4800,'App\\Models\\Receipt',4800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1010.14,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4853,7485,40723,6071,2,4801,'App\\Models\\Receipt',4801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1201.84,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4854,7485,40723,6071,2,4802,'App\\Models\\Receipt',4802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',2692.42,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4855,7485,40723,6071,2,4803,'App\\Models\\Receipt',4803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',10884.13,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4856,7485,40723,6071,2,4804,'App\\Models\\Receipt',4804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',2420.13,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4857,7485,40723,6071,2,4805,'App\\Models\\Receipt',4805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',34005.23,NULL,NULL,1,'2023-09-01 17:59:13','2023-09-01 17:59:13',NULL),(4858,7485,40723,6071,2,4806,'App\\Models\\Receipt',4806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',3284.76,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4859,7485,40723,6071,2,4807,'App\\Models\\Receipt',4807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',3120.36,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4860,7485,40723,6071,2,4808,'App\\Models\\Receipt',4808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',8138.55,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4861,7485,40723,6071,2,4809,'App\\Models\\Receipt',4809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',10087.42,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4862,7485,40723,6071,2,4810,'App\\Models\\Receipt',4810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1972.82,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4863,7485,40723,6071,2,4811,'App\\Models\\Receipt',4811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',6645.28,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4864,7485,40723,6071,2,4812,'App\\Models\\Receipt',4812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',6356.54,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4865,7485,40723,6071,2,4813,'App\\Models\\Receipt',4813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',6693.34,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4866,7485,40723,6071,2,4814,'App\\Models\\Receipt',4814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',1010.14,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4867,7485,40723,6071,2,4815,'App\\Models\\Receipt',4815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',1292.34,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4868,7485,40723,6071,2,4816,'App\\Models\\Receipt',4816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',9870.17,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4869,7485,40723,6071,2,4817,'App\\Models\\Receipt',4817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',13520.71,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL);
INSERT INTO `balance_libro` VALUES (4870,7485,40723,6071,2,4818,'App\\Models\\Receipt',4818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',3302.33,NULL,NULL,1,'2023-09-01 17:59:14','2023-09-01 17:59:14',NULL),(4871,7485,40723,6071,2,4819,'App\\Models\\Receipt',4819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',72800.00,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4872,7485,40723,6071,2,4820,'App\\Models\\Receipt',4820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',187176.88,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4873,7485,40723,6071,2,4821,'App\\Models\\Receipt',4821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',585415.24,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4874,7485,40723,6071,2,4822,'App\\Models\\Receipt',4822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',22440.08,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4875,7485,40723,6071,2,4823,'App\\Models\\Receipt',4823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',22031.56,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4876,7485,40723,6071,2,4824,'App\\Models\\Receipt',4824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',6993505.94,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4877,7485,40723,6071,2,4825,'App\\Models\\Receipt',4825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',3540.88,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4878,7485,40723,6071,2,4826,'App\\Models\\Receipt',4826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',3242.22,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4879,7485,40723,6071,2,4827,'App\\Models\\Receipt',4827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',3883.42,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4880,7485,40723,6071,2,4828,'App\\Models\\Receipt',4828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',5922.27,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4881,7485,40723,6071,2,4829,'App\\Models\\Receipt',4829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',2728.68,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4882,7485,40723,6071,2,4830,'App\\Models\\Receipt',4830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',170539.19,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4883,7485,40723,6071,2,4831,'App\\Models\\Receipt',4831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',143842.78,NULL,NULL,1,'2023-09-01 17:59:15','2023-09-01 17:59:15',NULL),(4884,7485,40720,1562,3,4832,'App\\Models\\Receipt',4832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',493267.21,NULL,NULL,1,'2023-09-06 16:13:35','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4885,7485,40720,1562,3,4833,'App\\Models\\Receipt',4833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',90515.74,NULL,NULL,1,'2023-09-06 16:13:35','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4886,7485,40720,1562,3,4834,'App\\Models\\Receipt',4834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',11984.66,NULL,NULL,1,'2023-09-06 16:13:35','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4887,7485,40720,1562,3,4835,'App\\Models\\Receipt',4835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',362904.28,NULL,NULL,1,'2023-09-06 16:13:35','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4888,7485,40720,1562,3,4836,'App\\Models\\Receipt',4836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',22750.00,NULL,NULL,1,'2023-09-06 16:13:35','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4889,7485,40720,1562,3,4837,'App\\Models\\Receipt',4837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',24064.30,NULL,NULL,1,'2023-09-06 16:13:35','2023-10-30 20:50:17','2023-10-30 20:50:17');
INSERT INTO `balance_libro` VALUES (4890,7485,40720,1562,3,4838,'App\\Models\\Receipt',4838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',1693164.64,NULL,NULL,1,'2023-09-06 16:13:35','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4891,7485,40720,1562,3,4839,'App\\Models\\Receipt',4839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',23058.37,NULL,NULL,1,'2023-09-06 16:13:36','2023-09-06 17:08:40','2023-09-06 17:08:40'),(4892,7485,40720,1562,3,4840,'App\\Models\\Receipt',4840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',39000.05,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4893,7485,40720,1562,3,4841,'App\\Models\\Receipt',4841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',39000.05,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4894,7485,40720,1562,3,4842,'App\\Models\\Receipt',4842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-13','2023-08-13',29650.02,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4895,7485,40720,1562,3,4843,'App\\Models\\Receipt',4843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',93193.00,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4896,7485,40720,1562,3,4844,'App\\Models\\Receipt',4844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-20','2023-08-20',10312.32,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4897,7485,40720,1562,3,4845,'App\\Models\\Receipt',4845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',185200.02,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4898,7485,40720,1562,3,4846,'App\\Models\\Receipt',4846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',205120.07,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4899,7485,40720,1562,3,4847,'App\\Models\\Receipt',4847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',342000.45,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4900,7485,40720,1562,3,4848,'App\\Models\\Receipt',4848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',424000.03,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4901,7485,40720,1562,3,4849,'App\\Models\\Receipt',4849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',218000.64,NULL,NULL,1,'2023-09-06 16:13:36','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4902,7485,40720,1562,2,4850,'App\\Models\\Receipt',4850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',210000.00,NULL,NULL,1,'2023-09-06 16:13:47','2023-10-30 20:07:06','2023-10-30 20:07:06'),(4903,7485,40720,1562,2,4851,'App\\Models\\Receipt',4851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',83854.08,NULL,NULL,1,'2023-09-06 16:13:47','2023-10-30 20:07:06','2023-10-30 20:07:06'),(4904,7485,40720,1562,2,4852,'App\\Models\\Receipt',4852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',496750.00,NULL,NULL,1,'2023-09-06 16:13:47','2023-10-30 20:07:06','2023-10-30 20:07:06'),(4905,7485,40720,1562,2,4853,'App\\Models\\Receipt',4853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',62000.00,NULL,NULL,1,'2023-09-06 16:13:47','2023-10-30 20:07:06','2023-10-30 20:07:06'),(4906,7485,40720,1562,2,4854,'App\\Models\\Receipt',4854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',792000.06,NULL,NULL,1,'2023-09-06 16:13:47','2023-10-30 20:07:06','2023-10-30 20:07:06'),(4907,7485,40720,1562,2,4855,'App\\Models\\Receipt',4855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',28350.02,NULL,NULL,1,'2023-09-06 16:13:47','2023-10-30 20:07:06','2023-10-30 20:07:06'),(4908,7485,40720,1562,2,4856,'App\\Models\\Receipt',4856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',142800.00,NULL,NULL,1,'2023-09-06 16:13:48','2023-10-30 20:07:06','2023-10-30 20:07:06');
INSERT INTO `balance_libro` VALUES (4909,7485,40720,1562,2,4857,'App\\Models\\Receipt',4857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',40700.04,NULL,NULL,1,'2023-09-06 16:13:48','2023-10-30 20:07:06','2023-10-30 20:07:06'),(4910,7485,40720,1562,2,4858,'App\\Models\\Receipt',4858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',396000.00,NULL,NULL,1,'2023-09-06 16:13:48','2023-10-30 20:07:06','2023-10-30 20:07:06'),(4911,7485,40720,1562,2,4859,'App\\Models\\Receipt',4859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',360000.00,NULL,NULL,1,'2023-09-06 16:13:48','2023-10-30 20:07:06','2023-10-30 20:07:06'),(4912,7485,40720,1562,3,4860,'App\\Models\\Receipt',4860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',5455.80,NULL,NULL,1,'2023-09-06 16:34:32','2023-09-06 16:52:35','2023-09-06 16:52:35'),(4913,7485,40720,1562,3,4861,'App\\Models\\Receipt',4861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',16653.20,NULL,NULL,1,'2023-09-06 16:38:55','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4914,7485,40720,1562,3,4862,'App\\Models\\Receipt',4862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',363.00,NULL,NULL,1,'2023-09-06 16:39:53','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4915,7485,40720,1562,3,4863,'App\\Models\\Receipt',4863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',726.00,NULL,NULL,1,'2023-09-06 16:41:16','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4916,7485,40720,1562,3,4864,'App\\Models\\Receipt',4864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',726.00,NULL,NULL,1,'2023-09-06 16:41:52','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4917,7485,40720,1562,3,4865,'App\\Models\\Receipt',4865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',471.90,NULL,NULL,1,'2023-09-06 16:43:33','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4918,7485,40720,1562,3,4866,'App\\Models\\Receipt',4866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',363.00,NULL,NULL,1,'2023-09-06 16:44:11','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4919,7485,40720,1562,3,4867,'App\\Models\\Receipt',4867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1089.00,NULL,NULL,1,'2023-09-06 16:46:17','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4920,7485,40720,1562,3,4868,'App\\Models\\Receipt',4868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1020.01,NULL,NULL,1,'2023-09-06 16:48:29','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4921,7485,40720,1562,3,4869,'App\\Models\\Receipt',4869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',363.00,NULL,NULL,1,'2023-09-06 16:48:59','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4922,7485,40720,1562,3,4870,'App\\Models\\Receipt',4870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',726.00,NULL,NULL,1,'2023-09-06 16:49:46','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4923,7485,40720,1562,3,4871,'App\\Models\\Receipt',4871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',726.00,NULL,NULL,1,'2023-09-06 16:50:39','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4924,7485,40720,1562,3,4860,'App\\Models\\Receipt',4860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',5455.80,NULL,NULL,1,'2023-09-06 16:52:35','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4925,7485,40720,1562,3,4839,'App\\Models\\Receipt',4839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',23058.37,NULL,NULL,1,'2023-09-06 17:08:40','2023-10-30 20:50:17','2023-10-30 20:50:17'),(4926,7485,40723,6071,3,4872,'App\\Models\\Receipt',4872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',1500.00,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL),(4927,7485,40723,6071,3,4873,'App\\Models\\Receipt',4873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',550864.59,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL);
INSERT INTO `balance_libro` VALUES (4928,7485,40723,6071,3,4874,'App\\Models\\Receipt',4874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',8314.01,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL),(4929,7485,40723,6071,3,4875,'App\\Models\\Receipt',4875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1412481.18,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL),(4930,7485,40723,6071,3,4876,'App\\Models\\Receipt',4876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',23313.20,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL),(4931,7485,40723,6071,3,4877,'App\\Models\\Receipt',4877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',12801.84,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL),(4932,7485,40723,6071,3,4878,'App\\Models\\Receipt',4878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',5168.00,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL),(4933,7485,40723,6071,3,4879,'App\\Models\\Receipt',4879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',14615.40,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL),(4934,7485,40723,6071,3,4880,'App\\Models\\Receipt',4880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-13','2023-08-13',14271.37,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL),(4935,7485,40723,6071,3,4881,'App\\Models\\Receipt',4881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',5433.61,NULL,NULL,1,'2023-09-18 21:17:21','2023-09-18 21:17:21',NULL),(4936,7485,40723,6071,3,4882,'App\\Models\\Receipt',4882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',510.00,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4937,7485,40723,6071,3,4883,'App\\Models\\Receipt',4883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',119999.00,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4938,7485,40723,6071,3,4884,'App\\Models\\Receipt',4884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',1500.00,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4939,7485,40723,6071,3,4885,'App\\Models\\Receipt',4885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',650.00,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4940,7485,40723,6071,3,4886,'App\\Models\\Receipt',4886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',17047.43,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4941,7485,40723,6071,3,4887,'App\\Models\\Receipt',4887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',359.26,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4942,7485,40723,6071,3,4888,'App\\Models\\Receipt',4888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',10852.61,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4943,7485,40723,6071,3,4889,'App\\Models\\Receipt',4889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',195153.27,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:34:04','2023-09-18 21:34:04'),(4944,7485,40723,6071,3,4890,'App\\Models\\Receipt',4890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',15996.00,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4945,7485,40723,6071,3,4891,'App\\Models\\Receipt',4891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',15996.00,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4946,7485,40723,6071,3,4892,'App\\Models\\Receipt',4892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',6402.07,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4947,7485,40723,6071,3,4893,'App\\Models\\Receipt',4893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',5073856.51,NULL,NULL,1,'2023-09-18 21:17:22','2023-09-18 21:17:22',NULL),(4948,7485,40723,6071,3,4894,'App\\Models\\Receipt',4894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',9762.40,NULL,NULL,1,'2023-09-18 21:17:23','2023-09-18 21:17:23',NULL);
INSERT INTO `balance_libro` VALUES (4949,7485,40723,6071,3,4895,'App\\Models\\Receipt',4895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',24950.04,NULL,NULL,1,'2023-09-18 21:17:23','2023-09-18 21:17:23',NULL),(4950,7485,40723,6071,3,4896,'App\\Models\\Receipt',4896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',36992.31,NULL,NULL,1,'2023-09-18 21:17:23','2023-09-18 21:17:23',NULL),(4951,7485,40723,6071,3,4897,'App\\Models\\Receipt',4897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',671425.98,NULL,NULL,1,'2023-09-18 21:17:23','2023-09-18 21:17:23',NULL),(4952,7485,40723,6071,3,4898,'App\\Models\\Receipt',4898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',400929.22,NULL,NULL,1,'2023-09-18 21:17:23','2023-09-18 21:17:23',NULL),(4953,7485,40723,6071,3,4899,'App\\Models\\Receipt',4899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',25181.81,NULL,NULL,1,'2023-09-18 21:17:23','2023-09-18 21:17:23',NULL),(4954,7485,40723,6071,3,4900,'App\\Models\\Receipt',4900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',17005.16,NULL,NULL,1,'2023-09-18 21:17:23','2023-09-18 21:17:23',NULL),(4955,7485,40723,6071,3,4889,'App\\Models\\Receipt',4889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',195153.26,NULL,NULL,1,'2023-09-18 21:34:04','2023-09-18 21:34:04',NULL),(4956,7485,40720,1546,2,4956,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6568491.30,'COMPRAS MAYO 2023',NULL,1,'2023-09-21 14:45:56','2023-09-21 15:10:04','2023-09-21 15:10:04'),(4957,7485,40720,1546,3,4957,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1565876.78,'COMPRAS MAYO 2023',NULL,1,'2023-09-21 14:56:09','2023-09-21 15:16:09','2023-09-21 15:16:09'),(4958,7485,40720,1546,2,4958,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6568491.30,'VENTAS MAYO 2023',NULL,1,'2023-09-21 15:10:04','2023-09-21 15:53:12','2023-09-21 15:53:12'),(4959,7485,40720,1546,3,4959,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5911204.93,'COMPRAS MAYO 2023',NULL,1,'2023-09-21 15:16:09','2023-09-21 15:25:20','2023-09-21 15:25:20'),(4960,7485,40720,1546,3,4960,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5972185.35,'COMPRAS MAYO 2023',NULL,1,'2023-09-21 15:25:20','2023-09-21 15:28:24','2023-09-21 15:28:24'),(4961,7485,40720,1546,3,4961,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5497234.35,'COMPRAS MAYO 2023',NULL,1,'2023-09-21 15:28:24','2023-09-21 16:53:49','2023-09-21 16:53:49'),(4962,7485,40720,1546,2,4962,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6568491.30,'VENTAS MAYO 2023',NULL,1,'2023-09-21 15:53:12','2023-09-21 15:55:32','2023-09-21 15:55:32'),(4963,7485,40720,1546,2,4963,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6568491.30,'VENTAS MAYO 2023',NULL,1,'2023-09-21 15:55:32','2023-09-21 16:56:31','2023-09-21 16:56:31'),(4964,7485,40720,1547,3,4964,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5497234.35,'COMPRAS AGOSTO 2023',NULL,1,'2023-09-21 16:53:49','2023-09-21 16:54:16','2023-09-21 16:54:16'),(4965,7485,40720,1547,3,4965,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5497234.35,'COMPRAS JULIO 2022',NULL,1,'2023-09-21 16:54:16','2023-09-21 16:55:34','2023-09-21 16:55:34'),(4966,9756,40720,1547,3,4966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5497234.35,'COMPRAS JULIO 2022',NULL,1,'2023-09-21 16:55:34','2024-01-06 15:12:13','2024-01-06 15:12:13');
INSERT INTO `balance_libro` VALUES (4967,7485,40720,1546,2,4967,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6568491.30,'VENTAS JULIO 2023',NULL,1,'2023-09-21 16:56:31','2023-09-22 22:48:36','2023-09-22 22:48:36'),(4968,9756,40720,1547,2,4968,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',7425003.08,'VENTAS AGOSTO 2022',NULL,1,'2023-09-21 17:08:21','2024-01-06 18:36:23','2024-01-06 18:36:23'),(4969,7485,40720,1547,3,4969,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6593554.61,'COMPRAS AGOSTO 2022',NULL,1,'2023-09-21 17:46:18','2023-09-21 18:45:56','2023-09-21 18:45:56'),(4970,7485,40720,1548,3,4970,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',9055141.57,'COMPRAS SEPTIBRE 2022',NULL,1,'2023-09-21 17:58:12','2023-09-21 18:00:52','2023-09-21 18:00:52'),(4971,9756,40720,1549,2,4971,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2483978.00,'VENTAS OCTUBRE 2022',NULL,1,'2023-09-21 18:00:28','2024-01-06 19:01:37','2024-01-06 19:01:37'),(4972,7485,40720,1548,3,4972,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',9055141.57,'VENTAS SEPTIEMBRE 2022',NULL,1,'2023-09-21 18:00:52','2023-09-21 18:00:52',NULL),(4973,9756,40720,1550,2,4973,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',931321.03,'VENTAS NOVIEMBRE 2022',NULL,1,'2023-09-21 18:05:29','2024-01-06 22:17:24','2024-01-06 22:17:24'),(4974,7485,40720,1551,2,4974,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4662029.00,'VENTAS DICIEMBRE 2022',NULL,1,'2023-09-21 18:09:28','2023-09-21 18:09:28',NULL),(4975,7485,40720,1548,3,4975,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7552754.77,NULL,NULL,1,'2023-09-21 18:20:48','2023-09-21 18:28:27','2023-09-21 18:28:27'),(4976,7485,40720,1548,3,4976,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7673283.81,NULL,NULL,1,'2023-09-21 18:28:27','2023-09-21 18:29:05','2023-09-21 18:29:05'),(4977,9756,40720,1548,3,4977,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7673283.81,'COMPRAS SEPTIEMBRE 2022',NULL,1,'2023-09-21 18:29:05','2024-01-06 15:20:11','2024-01-06 15:20:11'),(4978,7485,40720,1549,2,4978,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6297778.83,'VENTAS OCTUBRE 2022',NULL,1,'2023-09-21 18:37:23','2023-09-21 18:37:56','2023-09-21 18:37:56'),(4979,7485,40720,1549,2,4979,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6297778.83,'COMRAS OCTUBRE 2022',NULL,1,'2023-09-21 18:37:56','2023-09-21 18:45:46','2023-09-21 18:45:46'),(4980,7485,40720,1550,3,4980,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5922639.49,'VENTAS NOVIEMBRE 2022',NULL,1,'2023-09-21 18:45:33','2023-09-22 22:52:00','2023-09-22 22:52:00'),(4981,7485,40720,1549,3,4981,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6297778.83,'COMRAS OCTUBRE 2022',NULL,1,'2023-09-21 18:45:46','2023-10-17 22:10:39','2023-10-17 22:10:39'),(4982,7485,40720,1547,3,4982,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6593554.61,'COMPRAS AGOSTO 2022',NULL,1,'2023-09-21 18:45:56','2023-09-21 18:46:06','2023-09-21 18:46:06'),(4983,9756,40720,1547,3,4983,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6593554.61,'COMPRAS AGOSTO 2022',NULL,1,'2023-09-21 18:46:06','2024-01-06 15:02:04','2024-01-06 15:02:04');
INSERT INTO `balance_libro` VALUES (4984,9756,40720,1551,3,4984,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7081288.60,'COMPRAS DICIEMBRE 2022',NULL,1,'2023-09-21 19:35:34','2024-01-06 15:31:09','2024-01-06 15:31:09'),(4985,7485,40720,1555,2,4985,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2902472.11,'VENTAS ENERO 2023',NULL,1,'2023-09-22 21:13:42','2023-09-22 21:13:42',NULL),(4986,7485,40720,1556,2,4986,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3834528.09,'VENTAS  FEBRERO 2023',NULL,1,'2023-09-22 21:16:27','2023-09-22 21:16:27',NULL),(4987,7485,40720,1557,2,4987,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4088828.06,'VENTAS MARZO 2023',NULL,1,'2023-09-22 21:18:23','2023-10-21 20:15:34','2023-10-21 20:15:34'),(4988,9756,40720,1558,2,4988,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',17545272.88,'VENTAS ABRIL 2023',NULL,1,'2023-09-22 21:22:11','2024-01-06 19:03:18','2024-01-06 19:03:18'),(4989,7485,40720,1559,2,4989,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7086838.81,'VENTAS ABRIL 2023',NULL,1,'2023-09-22 21:30:29','2023-09-22 21:33:10','2023-09-22 21:33:10'),(4990,7485,40720,1560,2,4990,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9271699.10,'VENTAS MAYO 2023',NULL,1,'2023-09-22 21:32:38','2023-09-22 21:33:51','2023-09-22 21:33:51'),(4991,7485,40720,1559,2,4991,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7086838.81,'VENTAS MAYO 2023',NULL,1,'2023-09-22 21:33:10','2023-09-22 21:33:24','2023-09-22 21:33:24'),(4992,7485,40720,1559,2,4992,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7086838.81,'VENTAS MAYO 2023',NULL,1,'2023-09-22 21:33:24','2023-09-22 21:33:24',NULL),(4993,7485,40720,1560,2,4993,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9271699.10,'VENTAS JUNIO 2023',NULL,1,'2023-09-22 21:33:51','2023-09-22 21:33:51',NULL),(4994,9756,40720,1555,3,4994,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5900482.69,'COMPRAS ENERO 2023',NULL,1,'2023-09-22 21:48:15','2024-01-06 15:35:21','2024-01-06 15:35:21'),(4995,9756,40720,1556,3,4995,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3479373.13,'COMPRAS FEBRERO 2023',NULL,1,'2023-09-22 21:55:13','2024-01-06 15:36:59','2024-01-06 15:36:59'),(4996,7485,40720,1557,3,4996,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5403410.85,'COMPRAS SEPTIEMBRE 2023',NULL,1,'2023-09-22 22:13:32','2023-09-22 22:14:59','2023-09-22 22:14:59'),(4997,9756,40720,1557,3,4997,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5403410.85,'COMPRAS MARZO 2023',NULL,1,'2023-09-22 22:14:59','2024-01-06 15:39:31','2024-01-06 15:39:31'),(4998,9756,40720,1558,3,4998,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6635341.90,'COMPRAS ABRIL 2023',NULL,1,'2023-09-22 22:24:28','2024-01-06 15:49:37','2024-01-06 15:49:37'),(4999,9756,40720,1559,3,4999,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7098949.94,'COMPRAS MAYO 2023',NULL,1,'2023-09-22 22:30:22','2024-01-06 15:52:11','2024-01-06 15:52:11'),(5000,9756,40720,1560,3,5000,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5396844.54,'COMPRAS JUNIO 2023',NULL,1,'2023-09-22 22:41:51','2024-01-06 15:54:26','2024-01-06 15:54:26');
INSERT INTO `balance_libro` VALUES (5001,7485,40720,1546,2,5001,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6568491.30,'VENTAS JULIO 2022',NULL,1,'2023-09-22 22:48:36','2023-10-27 14:55:41','2023-10-27 14:55:41'),(5002,9756,40720,1550,3,5002,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5922639.49,'COMPRAS NOVIEMBRE 2022',NULL,1,'2023-09-22 22:52:00','2024-01-06 15:27:05','2024-01-06 15:27:05'),(5003,7485,40720,1547,15,5003,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',15073.78,'AJUSTES DE IVA',NULL,1,'2023-09-24 13:29:38','2023-09-24 13:30:10','2023-09-24 13:30:10'),(5004,7485,40720,1546,15,5004,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',13821.07,'AJUSTES DE IVA',NULL,1,'2023-09-24 13:30:10','2023-09-24 14:28:34','2023-09-24 14:28:34'),(5005,7485,40720,1547,15,5005,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1153807.55,'POSICION DE IVA',NULL,1,'2023-09-24 14:01:14','2023-09-24 14:45:57','2023-09-24 14:45:57'),(5006,7485,40720,1547,15,5006,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',14026.26,'AJUSTES IVA AGOSTO 2022',NULL,1,'2023-09-24 14:28:20','2023-09-24 14:28:20',NULL),(5007,7485,40720,1546,15,5007,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',13821.07,'AJUSTES DE IVA JULIO 2022',NULL,1,'2023-09-24 14:28:34','2023-09-24 14:28:51','2023-09-24 14:28:51'),(5008,9756,40720,1546,15,5008,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',13821.07,'AJUSTES IVA JULIO 2022',NULL,1,'2023-09-24 14:28:51','2024-01-06 18:55:51','2024-01-06 18:55:51'),(5009,7485,40720,1550,15,5009,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',145131.21,'AJUSTES DE IVA NOVIEMBRE 2022',NULL,1,'2023-09-24 14:33:21','2023-09-24 14:36:40','2023-09-24 14:36:40'),(5010,7485,40720,1559,15,5010,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',19134.49,'AJUSTES IVA MAYO 2023',NULL,1,'2023-09-24 14:36:26','2023-09-24 14:36:26',NULL),(5011,7485,40720,1550,15,5011,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',145131.21,'AJUSTES  IVA NOVIEMBRE 2022',NULL,1,'2023-09-24 14:36:40','2023-09-24 14:36:40',NULL),(5012,7485,40720,1560,15,5012,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',8757.00,'AJUSTES IVA JUNIO 2023',NULL,1,'2023-09-24 14:38:06','2023-09-24 14:38:06',NULL),(5013,7485,40720,1547,15,5013,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1153807.55,'POSICION IVA JULIO 2022',NULL,1,'2023-09-24 14:45:57','2023-09-24 14:46:12','2023-09-24 14:46:12'),(5014,7485,40720,1547,15,5014,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1153807.55,'POSICION IVA JULIO 2022',NULL,1,'2023-09-24 14:46:12','2023-09-24 14:46:24','2023-09-24 14:46:24'),(5015,9756,40720,1547,15,5015,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1153807.55,'POSICION IVA JULIO 2022',NULL,1,'2023-09-24 14:46:24','2024-01-06 19:17:26','2024-01-06 19:17:26'),(5016,7485,40720,1547,15,5016,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1302663.16,'POSICION IVA AGOSTO 2022',NULL,1,'2023-09-24 14:56:11','2023-09-24 14:56:11',NULL),(5017,7485,40720,1548,15,5017,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1571553.70,'POSICION IVA SEPTIEMBRE 2022',NULL,1,'2023-09-24 15:00:29','2023-09-24 15:00:29',NULL);
INSERT INTO `balance_libro` VALUES (5018,7485,40720,1549,15,5018,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',431103.62,'POSICION IVA OCTUBRE 2022',NULL,1,'2023-09-24 16:33:11','2023-09-24 18:21:30','2023-09-24 18:21:30'),(5019,7485,40720,1550,15,5019,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',306765.44,'POSICION IVA NOVIEMBRE 2022',NULL,1,'2023-09-24 18:17:56','2023-09-24 18:17:56',NULL),(5020,7485,40720,1551,15,5020,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',809112.46,'POSICION IVA DICIEMBRE 2022',NULL,1,'2023-09-24 18:21:03','2023-09-24 18:21:03',NULL),(5021,7485,40720,1549,15,5021,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',431103.62,'POSICION IVA OCTUBRE 2022',NULL,1,'2023-09-24 18:21:30','2023-09-24 18:21:30',NULL),(5022,7485,40720,1555,15,5022,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',503734.83,'POSICION IVA ENERO 2023',NULL,1,'2023-09-24 18:26:13','2023-09-24 18:26:13',NULL),(5023,9756,40720,1556,15,5023,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',665496.61,'POSICION IVA FEBRERO 2023',NULL,1,'2023-09-24 18:28:50','2024-01-06 19:22:12','2024-01-06 19:22:12'),(5024,7485,40720,1557,15,5024,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',709631.32,'POSICION IVA MARZO 2023',NULL,1,'2023-09-24 18:30:19','2023-09-24 18:36:10','2023-09-24 18:36:10'),(5025,7485,40720,1557,15,5025,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',709631.32,'POSICION IVA MARZO 2023',NULL,1,'2023-09-24 18:30:19','2023-09-24 18:34:25','2023-09-24 18:34:25'),(5026,9756,40720,1559,15,5026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3045047.20,'POSICION IVA ABRIL 2023',NULL,1,'2023-09-24 18:33:55','2024-01-06 19:25:01','2024-01-06 19:25:01'),(5027,7485,40720,1557,15,5027,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',709631.32,'POSICION IVA MARZO 2023',NULL,1,'2023-09-24 18:34:25','2023-09-24 18:34:25',NULL),(5028,9756,40720,1559,15,5028,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1249081.72,'POSICION IVA MAYO 2023',NULL,1,'2023-09-24 18:36:10','2024-01-06 19:24:07','2024-01-06 19:24:07'),(5029,9756,40720,1560,15,5029,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1617894.86,'POSICION IVA JUNIO 2023',NULL,1,'2023-09-24 19:04:45','2024-01-06 19:26:37','2024-01-06 19:26:37'),(5030,7485,40720,1546,16,5030,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',87413.13,'PAGO IIBB JULIO 2022',NULL,1,'2023-09-24 19:40:52','2023-09-24 19:47:39','2023-09-24 19:47:39'),(5031,7485,40720,1546,16,5031,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',87413.13,'PAGO IIBB JULIO 2022',NULL,1,'2023-09-24 19:47:39','2023-09-24 19:50:39','2023-09-24 19:50:39'),(5032,9756,40720,1546,16,5032,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',87413.13,'PAGO IIBB JULIO 2022',NULL,1,'2023-09-24 19:50:39','2024-01-06 21:50:51','2024-01-06 21:50:51'),(5033,7485,40720,1546,16,5033,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',189997.67,'IIBB A PAGAR',NULL,1,'2023-09-24 19:53:53','2023-09-24 19:54:12','2023-09-24 19:54:12'),(5034,7485,40720,1546,16,5034,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',189997.67,'IIBB A PAGAR JULIO 2022',NULL,1,'2023-09-24 19:54:12','2023-09-24 19:54:12',NULL);
INSERT INTO `balance_libro` VALUES (5035,7485,40720,1547,16,5035,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',404770.48,'PAGO IIBB AGOSTO 2022',NULL,1,'2023-09-24 20:05:06','2023-09-25 16:00:44','2023-09-25 16:00:44'),(5036,7485,40720,1548,16,5036,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',214772.81,'IIBB A PAGAR SEPTIEMBRE 2022',NULL,1,'2023-09-25 15:55:09','2023-09-25 16:14:58','2023-09-25 16:14:58'),(5037,9756,40720,1548,16,5037,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',214772.81,'PAGO IIBB SEPTIEMBRE 2022',NULL,1,'2023-09-25 15:58:30','2024-01-06 21:59:17','2024-01-06 21:59:17'),(5038,9756,40720,1547,16,5038,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',189997.67,'PAGO IIBB AGOSTO 2022',NULL,1,'2023-09-25 16:00:44','2024-01-06 21:58:36','2024-01-06 21:58:36'),(5039,7485,40720,1547,15,5039,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',214772.81,'IIBB A PAGAR AGOSTO 2022',NULL,1,'2023-09-25 16:13:19','2023-09-25 16:13:19',NULL),(5040,7485,40720,1548,16,5040,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',261925.56,'IIBB A PAGAR SEPTIEMBRE 2022',NULL,1,'2023-09-25 16:14:58','2023-09-25 16:14:58',NULL),(5041,7485,40720,1549,16,5041,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',71850.60,'IIBB A PAGAR OCTUBRE 2022',NULL,1,'2023-09-25 16:24:27','2023-09-25 16:24:27',NULL),(5042,9756,40720,1549,16,5042,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',261925.56,'PAGO IIBB OCTUBRE 2022',NULL,1,'2023-09-25 16:30:30','2024-01-06 22:00:32','2024-01-06 22:00:32'),(5043,7485,40720,1550,16,5043,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',20011.85,'IIBB A PAGAR NOVIEMBRE 2022',NULL,1,'2023-09-25 16:43:06','2023-09-25 16:43:06',NULL),(5044,7485,40720,1550,16,5044,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',71850.60,'IIBB A PAGAR NOVIEMBRE 2022',NULL,1,'2023-09-25 16:54:23','2023-09-25 16:54:52','2023-09-25 16:54:52'),(5045,9756,40720,1550,16,5045,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',71850.60,'PAGO IIBB NOVIEMBRE 2022',NULL,1,'2023-09-25 16:54:52','2024-01-06 22:01:20','2024-01-06 22:01:20'),(5046,7485,40720,1551,16,5046,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',76709.45,'IIBB A PAGAR DICIEMBRE 2022',NULL,1,'2023-09-25 16:56:51','2023-09-25 16:56:51',NULL),(5047,9756,40720,1551,16,5047,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20011.85,'PAGO IIBB DICIEMBRE 2022',NULL,1,'2023-09-25 16:58:42','2024-01-06 22:04:10','2024-01-06 22:04:10'),(5048,7485,40720,1555,16,5048,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',81557.06,'IIBB A PAGAR ENERO 2023',NULL,1,'2023-09-25 17:05:07','2023-09-25 17:05:07',NULL),(5049,9756,40720,1556,16,5049,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',76709.45,'PAGO IIBB ENERO 2023',NULL,1,'2023-09-25 17:08:05','2024-01-06 22:04:44','2024-01-06 22:04:44'),(5050,7485,40720,1556,16,5050,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',107747.07,'IIBB A PAGAR ENERO 2023',NULL,1,'2023-09-25 17:10:05','2023-09-25 17:11:15','2023-09-25 17:11:15'),(5051,7485,40720,1556,16,5051,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',107747.07,'IIBB A PAGAR FEBRERO 2023',NULL,1,'2023-09-25 17:11:15','2023-09-25 17:11:15',NULL);
INSERT INTO `balance_libro` VALUES (5052,9756,40720,1556,16,5052,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',81557.06,'PAGO IIBB FEBRERO 2023',NULL,1,'2023-09-25 17:12:45','2024-01-06 22:05:14','2024-01-06 22:05:14'),(5053,7485,40720,1557,16,5053,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',114892.69,'IIBB A PAGAR MARZO 2023',NULL,1,'2023-09-25 17:13:57','2023-09-25 17:13:57',NULL),(5054,9756,40720,1557,16,5054,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',107747.07,'PAGO IIBB MARZO 2023',NULL,1,'2023-09-25 17:15:42','2024-01-06 22:06:07','2024-01-06 22:06:07'),(5055,7485,40720,1558,16,5055,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',493007.64,'IIBB A PAGAR ABRIL 2023',NULL,1,'2023-09-25 17:18:59','2023-09-25 17:18:59',NULL),(5056,9756,40720,1558,16,5056,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',114892.69,'PAGO IIBB ABRIL 2023',NULL,1,'2023-09-25 17:20:24','2024-01-06 22:06:53','2024-01-06 22:06:53'),(5057,7485,40720,1559,16,5057,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',199116.31,'IIBB A PAGAR MAYO 2023',NULL,1,'2023-09-25 17:21:19','2023-09-25 17:21:19',NULL),(5058,9756,40720,1559,16,5058,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',493007.64,'PAGO IIBB MAYO 2023',NULL,1,'2023-09-25 17:22:32','2024-01-06 22:07:42','2024-01-06 22:07:42'),(5059,7485,40720,1560,16,5059,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',260527.08,'PAGO IIBB JUNIO 2023',NULL,1,'2023-09-25 17:25:29','2023-09-25 17:27:32','2023-09-25 17:27:32'),(5060,9756,40720,1560,16,5060,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',199116.31,'PAGO IIBB JUNIO 2023',NULL,1,'2023-09-25 17:26:45','2024-01-06 22:08:19','2024-01-06 22:08:19'),(5061,7485,40720,1560,16,5061,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',260527.08,'IIBB A PAGAR JUNIO 2023',NULL,1,'2023-09-25 17:27:32','2023-09-25 17:27:32',NULL),(5062,7485,40719,9,5,5062,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',480772.51,'CONCILIACION BBVA JULIO 2023',NULL,1,'2023-09-26 18:34:57','2023-09-26 18:39:23','2023-09-26 18:39:23'),(5063,7485,40719,10,5,5063,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2651531.04,'CONCILIACIONES BANCOS AGOSTO 2023',NULL,1,'2023-09-26 18:38:11','2023-09-26 18:39:39','2023-09-26 18:39:39'),(5064,7485,40719,9,5,5064,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1863452.83,'CONCILIACIONES BANCOS JULIO 2022',NULL,1,'2023-09-26 18:39:23','2023-09-26 18:39:23',NULL),(5065,7485,40719,10,5,5065,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2651531.04,'CONCILIACIONES BANCOS AGOSTO 2022',NULL,1,'2023-09-26 18:39:39','2023-09-26 18:39:39',NULL),(5066,7485,40719,11,5,5066,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',10698022.25,'CONCILIACIONES BANCOS SEPTIEMBRE 2022',NULL,1,'2023-09-26 19:11:40','2023-09-26 19:11:40',NULL),(5067,7485,40719,13,5,5067,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7880630.68,'CONCILIACIONES BANCOS OCTUBRE 2022',NULL,1,'2023-09-26 19:18:37','2023-09-26 19:19:12','2023-09-26 19:19:12'),(5068,7485,40719,12,5,5068,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7880630.68,'CONCILIACIONES BANCOS OCTUBRE 2022',NULL,1,'2023-09-26 19:19:12','2023-09-26 19:19:12',NULL);
INSERT INTO `balance_libro` VALUES (5069,7485,40720,1546,5,5069,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1863452.83,'CONC. BCOS JULIO 2022',NULL,1,'2023-09-26 19:44:39','2023-09-26 19:44:52','2023-09-26 19:44:52'),(5070,7485,40720,1546,5,5070,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1863452.83,'CONCIL BCOS JULIO 2022',NULL,1,'2023-09-26 19:44:52','2023-09-26 20:57:01','2023-09-26 20:57:01'),(5071,7485,40720,1546,5,5071,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1863452.83,'CONCILIACION BANCOS JULIO 2022',NULL,1,'2023-09-26 20:57:01','2023-09-26 20:57:01',NULL),(5072,7485,40720,1547,5,5072,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2651531.04,'CONCILIACIONES BANCOS AGOSTO 2022',NULL,1,'2023-09-26 21:03:39','2023-11-08 20:12:52','2023-11-08 20:12:52'),(5073,7485,40720,1548,5,5073,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',10698022.25,'CONCILIACIONES BANCOS SEPTIEMBRE 2022',NULL,1,'2023-09-26 21:05:31','2023-09-26 21:05:31',NULL),(5074,7485,40720,1549,5,5074,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7880630.68,'CONCILIACIONES BANCOS OCTUBRE 2022',NULL,1,'2023-09-26 21:08:02','2023-09-26 21:08:02',NULL),(5075,7485,40720,1550,5,5075,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1553006.90,'CONCILIACIONES BANCOS NOVIEMBRE 2022',NULL,1,'2023-09-26 21:10:34','2023-09-26 21:10:34',NULL),(5076,7485,40720,1551,5,5076,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1301165.21,'CONCILIACIONES BANCOS DICIEMBRE 2022',NULL,1,'2023-09-26 21:11:33','2023-09-26 21:18:37','2023-09-26 21:18:37'),(5077,7485,40720,1555,5,5077,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5867890.70,'CONCILIACIONES BANCOS ENERO 2023',NULL,1,'2023-09-26 21:17:29','2023-09-26 21:17:29',NULL),(5078,7485,40720,1551,5,5078,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3805646.21,'CONCILIACIONES BANCOS DICIEMBRE 2022',NULL,1,'2023-09-26 21:18:37','2023-09-26 21:18:37',NULL),(5079,7485,40720,1556,5,5079,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3076521.51,'CONCILIACIONES BANCOS FEBRERO 2023',NULL,1,'2023-09-26 21:22:19','2023-09-26 21:22:19',NULL),(5080,7485,40720,1557,5,5080,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3538674.54,'CONCILIACIONES BANCOS MARZO 2023',NULL,1,'2023-09-26 21:29:14','2023-11-08 21:05:00','2023-11-08 21:05:00'),(5081,7485,40720,1558,5,5081,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1072071.64,'CONCILIACIONES BANCOS ABRIL 2023',NULL,1,'2023-09-26 21:32:27','2023-11-08 20:00:43','2023-11-08 20:00:43'),(5082,7485,40720,1559,5,5082,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3826474.35,'CONCILIACIONES BANCOS MAYO 2023',NULL,1,'2023-09-26 21:34:51','2023-09-26 21:34:51',NULL),(5083,7485,40720,1560,5,5083,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3261799.55,'CONCILIACIONES BANCOS JUNIO 2023',NULL,1,'2023-09-26 21:36:46','2023-09-26 21:36:46',NULL),(5084,7485,40720,1546,15,5084,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1686835.79,'PAGO IVA JUNIO 2022',NULL,1,'2023-09-29 16:56:21','2023-09-29 16:56:21',NULL),(5085,7485,40720,1547,15,5085,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',210697.50,'PAGO IVA JULIO 2022',NULL,1,'2023-09-29 16:58:08','2023-09-29 16:58:08',NULL);
INSERT INTO `balance_libro` VALUES (5086,7485,40720,1548,15,5086,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',255391.59,'PAGO IVA AGOSTO 2022',NULL,1,'2023-09-29 17:00:04','2023-09-29 17:00:04',NULL),(5087,7485,40720,1549,15,5087,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',291067.35,'PAGO IVA SEPTIEMBRE 2022',NULL,1,'2023-09-29 17:03:53','2023-09-29 17:03:53',NULL),(5248,7485,40828,7777,2,5061,'App\\Models\\Receipt',5061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',952000.00,NULL,NULL,1,'2023-10-11 16:08:26','2023-10-11 18:07:03','2023-10-11 18:07:03'),(5249,7485,40828,7777,2,5062,'App\\Models\\Receipt',5062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',27800.00,NULL,NULL,1,'2023-10-11 16:08:26','2023-10-11 18:06:06','2023-10-11 18:06:06'),(5250,7485,40828,7777,2,5063,'App\\Models\\Receipt',5063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',28950.00,NULL,NULL,1,'2023-10-11 16:08:26','2023-10-11 18:03:13','2023-10-11 18:03:13'),(5251,7485,40828,7777,2,5064,'App\\Models\\Receipt',5064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',46300.00,NULL,NULL,1,'2023-10-11 16:08:26','2023-10-11 17:48:34','2023-10-11 17:48:34'),(5252,7485,40828,7777,2,5065,'App\\Models\\Receipt',5065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',348900.00,NULL,NULL,1,'2023-10-11 16:08:27','2023-10-11 17:46:08','2023-10-11 17:46:08'),(5328,7485,40828,7777,2,5065,'App\\Models\\Receipt',5065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',697451.09,NULL,NULL,1,'2023-10-11 17:46:08','2023-10-11 17:52:21','2023-10-11 17:52:21'),(5329,7485,40828,7777,2,5064,'App\\Models\\Receipt',5064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',92553.72,NULL,NULL,1,'2023-10-11 17:48:34','2023-10-11 17:51:23','2023-10-11 17:51:23'),(5330,7485,40828,7777,2,5064,'App\\Models\\Receipt',5064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',46300.00,NULL,NULL,1,'2023-10-11 17:51:23','2023-10-11 17:51:23',NULL),(5331,7485,40828,7777,2,5065,'App\\Models\\Receipt',5065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',697451.09,NULL,NULL,1,'2023-10-11 17:52:21','2023-10-11 17:52:21',NULL),(5332,7485,40828,7777,2,5063,'App\\Models\\Receipt',5063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',57871.05,NULL,NULL,1,'2023-10-11 18:03:13','2023-10-11 18:03:13',NULL),(5333,7485,40828,7777,2,5062,'App\\Models\\Receipt',5062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',27800.00,NULL,NULL,1,'2023-10-11 18:06:06','2023-10-11 18:06:06',NULL),(5334,7485,40828,7777,2,5061,'App\\Models\\Receipt',5061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1903048.00,NULL,NULL,1,'2023-10-11 18:07:03','2023-10-11 18:07:03',NULL),(5335,7485,40828,7777,3,5141,'App\\Models\\Receipt',5141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',5453.16,NULL,NULL,1,'2023-10-12 15:08:32','2023-10-12 15:08:32',NULL),(5336,7485,40828,7777,3,5142,'App\\Models\\Receipt',5142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',20885.70,NULL,NULL,1,'2023-10-12 15:17:12','2023-10-12 15:17:12',NULL),(5337,7485,40828,7777,3,5143,'App\\Models\\Receipt',5143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',126647.41,NULL,NULL,1,'2023-10-12 15:17:12','2023-10-12 15:17:12',NULL),(5338,7485,40828,7777,3,5144,'App\\Models\\Receipt',5144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',130982.50,NULL,NULL,1,'2023-10-12 15:17:12','2023-10-12 15:17:12',NULL),(5339,7485,40828,7777,3,5145,'App\\Models\\Receipt',5145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',2544.46,NULL,NULL,1,'2023-10-12 15:17:12','2023-10-12 15:17:12',NULL),(5340,7485,40828,7777,3,5146,'App\\Models\\Receipt',5146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',20560.33,NULL,NULL,1,'2023-10-12 15:17:13','2023-10-12 15:17:13',NULL);
INSERT INTO `balance_libro` VALUES (5341,7485,40828,7777,3,5147,'App\\Models\\Receipt',5147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',106327.55,NULL,NULL,1,'2023-10-12 15:17:13','2023-10-12 15:17:13',NULL),(5342,7485,40828,7777,3,5148,'App\\Models\\Receipt',5148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',425625.96,NULL,NULL,1,'2023-10-12 15:17:13','2023-10-12 15:17:13',NULL),(5343,7485,40828,7777,3,5149,'App\\Models\\Receipt',5149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',23781.16,NULL,NULL,1,'2023-10-12 15:17:13','2023-10-12 15:17:13',NULL),(5344,7485,40828,7777,3,5150,'App\\Models\\Receipt',5150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',10208.54,NULL,NULL,1,'2023-10-12 15:17:13','2023-10-12 15:17:13',NULL),(5345,7485,40828,7777,3,5151,'App\\Models\\Receipt',5151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',7182.95,NULL,NULL,1,'2023-10-12 15:17:13','2023-10-12 15:17:13',NULL),(5346,7485,40828,7777,3,5152,'App\\Models\\Receipt',5152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',10817.70,NULL,NULL,1,'2023-10-12 15:17:13','2023-10-12 15:17:13',NULL),(5347,7485,40828,7777,3,5153,'App\\Models\\Receipt',5153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',22988.84,NULL,NULL,1,'2023-10-12 15:17:13','2023-10-12 15:17:13',NULL),(5348,7485,40828,7777,3,5154,'App\\Models\\Receipt',5154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',129137.44,NULL,NULL,1,'2023-10-12 15:17:13','2023-10-12 15:17:13',NULL),(5349,7485,40828,7777,3,5155,'App\\Models\\Receipt',5155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',29138.64,NULL,NULL,1,'2023-10-12 15:17:14','2023-10-12 15:17:14',NULL),(5350,7485,40828,7777,3,5156,'App\\Models\\Receipt',5156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',15731.96,NULL,NULL,1,'2023-10-12 15:17:14','2023-10-12 15:17:14',NULL),(5351,7485,40828,7777,3,5157,'App\\Models\\Receipt',5157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',13914.77,NULL,NULL,1,'2023-10-12 15:17:14','2023-10-12 15:17:14',NULL),(5352,7485,40828,7777,3,5158,'App\\Models\\Receipt',5158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',1826.99,NULL,NULL,1,'2023-10-12 15:17:14','2023-10-12 15:17:14',NULL),(5353,7485,40723,6072,3,5159,'App\\Models\\Receipt',5159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',300.00,NULL,NULL,1,'2023-10-15 17:58:21','2023-10-15 17:58:21',NULL),(5354,7485,40723,6072,3,5160,'App\\Models\\Receipt',5160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',10967.69,NULL,NULL,1,'2023-10-15 17:58:21','2023-10-15 17:58:21',NULL),(5355,7485,40723,6072,3,5161,'App\\Models\\Receipt',5161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',72452.51,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5356,7485,40723,6072,3,5162,'App\\Models\\Receipt',5162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',3600.00,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5357,7485,40723,6072,3,5163,'App\\Models\\Receipt',5163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',13000.61,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5358,7485,40723,6072,3,5164,'App\\Models\\Receipt',5164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',13677.81,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5359,7485,40723,6072,3,5165,'App\\Models\\Receipt',5165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',13501.61,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5360,7485,40723,6072,3,5166,'App\\Models\\Receipt',5166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',346785.42,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5361,7485,40723,6072,3,5167,'App\\Models\\Receipt',5167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',14075.28,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL);
INSERT INTO `balance_libro` VALUES (5362,7485,40723,6072,3,5168,'App\\Models\\Receipt',5168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',6586.80,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5363,7485,40723,6072,3,5169,'App\\Models\\Receipt',5169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',8000.00,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5364,7485,40723,6072,3,5170,'App\\Models\\Receipt',5170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',45999.99,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5365,7485,40723,6072,3,5171,'App\\Models\\Receipt',5171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',12421.53,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5366,7485,40723,6072,3,5172,'App\\Models\\Receipt',5172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',117500.00,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5367,7485,40723,6072,3,5173,'App\\Models\\Receipt',5173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',6656.01,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5368,7485,40723,6072,3,5174,'App\\Models\\Receipt',5174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',95709.73,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5369,7485,40723,6072,3,5175,'App\\Models\\Receipt',5175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',2500.00,NULL,NULL,1,'2023-10-15 17:58:22','2023-10-15 17:58:22',NULL),(5370,7485,40723,6072,3,5176,'App\\Models\\Receipt',5176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',850.00,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5371,7485,40723,6072,3,5177,'App\\Models\\Receipt',5177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',38000.00,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5372,7485,40723,6072,3,5178,'App\\Models\\Receipt',5178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',13602.39,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5373,7485,40723,6072,3,5179,'App\\Models\\Receipt',5179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',43190.00,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5374,7485,40723,6072,3,5180,'App\\Models\\Receipt',5180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',34099.00,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5375,7485,40723,6072,3,5181,'App\\Models\\Receipt',5181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',50000.00,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5376,7485,40723,6072,3,5182,'App\\Models\\Receipt',5182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',25379.00,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5377,7485,40723,6072,3,5183,'App\\Models\\Receipt',5183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',35826.48,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5378,7485,40723,6072,3,5184,'App\\Models\\Receipt',5184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',56854.00,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5379,7485,40723,6072,3,5185,'App\\Models\\Receipt',5185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',30307.10,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5380,7485,40723,6072,3,5186,'App\\Models\\Receipt',5186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',456811.83,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5381,7485,40723,6072,3,5187,'App\\Models\\Receipt',5187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',250.00,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5382,7485,40723,6072,3,5188,'App\\Models\\Receipt',5188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',2224114.98,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL);
INSERT INTO `balance_libro` VALUES (5383,7485,40723,6072,3,5189,'App\\Models\\Receipt',5189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',1268127.26,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5384,7485,40723,6072,3,5190,'App\\Models\\Receipt',5190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',11806.74,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5385,7485,40723,6072,3,5191,'App\\Models\\Receipt',5191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',600.00,NULL,NULL,1,'2023-10-15 17:58:23','2023-10-15 17:58:23',NULL),(5386,7485,40723,6072,3,5192,'App\\Models\\Receipt',5192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',1900.00,NULL,NULL,1,'2023-10-15 17:58:24','2023-10-15 17:58:24',NULL),(5387,7485,40723,6072,3,5193,'App\\Models\\Receipt',5193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',709683.77,NULL,NULL,1,'2023-10-15 17:58:24','2023-10-15 17:58:24',NULL),(5388,7485,40723,6072,3,5194,'App\\Models\\Receipt',5194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5020.63,NULL,NULL,1,'2023-10-15 17:58:24','2023-10-15 17:58:24',NULL),(5389,7485,40723,6072,2,5195,'App\\Models\\Receipt',5195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',2959.22,NULL,NULL,1,'2023-10-15 17:58:34','2023-10-15 17:58:34',NULL),(5390,7485,40723,6072,2,5196,'App\\Models\\Receipt',5196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',55339.13,NULL,NULL,1,'2023-10-15 17:58:34','2023-10-15 17:58:34',NULL),(5391,7485,40723,6072,2,5197,'App\\Models\\Receipt',5197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',2974.53,NULL,NULL,1,'2023-10-15 17:58:34','2023-10-15 17:58:34',NULL),(5392,7485,40723,6072,2,5198,'App\\Models\\Receipt',5198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',15095.42,NULL,NULL,1,'2023-10-15 17:58:34','2023-10-15 17:58:34',NULL),(5393,7485,40723,6072,2,5199,'App\\Models\\Receipt',5199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',13484.83,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5394,7485,40723,6072,2,5200,'App\\Models\\Receipt',5200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',26659.32,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5395,7485,40723,6072,2,5201,'App\\Models\\Receipt',5201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',4929.61,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5396,7485,40723,6072,2,5202,'App\\Models\\Receipt',5202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',21588.37,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5397,7485,40723,6072,2,5203,'App\\Models\\Receipt',5203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',4413.10,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5398,7485,40723,6072,2,5204,'App\\Models\\Receipt',5204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',22440.08,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5399,7485,40723,6072,2,5205,'App\\Models\\Receipt',5205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',8190.79,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5400,7485,40723,6072,2,5206,'App\\Models\\Receipt',5206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',14410.59,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5401,7485,40723,6072,2,5207,'App\\Models\\Receipt',5207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',24678.66,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5402,7485,40723,6072,2,5208,'App\\Models\\Receipt',5208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',7294.87,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5403,7485,40723,6072,2,5209,'App\\Models\\Receipt',5209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',3069.32,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL);
INSERT INTO `balance_libro` VALUES (5404,7485,40723,6072,2,5210,'App\\Models\\Receipt',5210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',3069.32,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5405,7485,40723,6072,2,5211,'App\\Models\\Receipt',5211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',18513.42,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5406,7485,40723,6072,2,5212,'App\\Models\\Receipt',5212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',15022.45,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5407,7485,40723,6072,2,5213,'App\\Models\\Receipt',5213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',2956.27,NULL,NULL,1,'2023-10-15 17:58:35','2023-10-15 17:58:35',NULL),(5408,7485,40723,6072,2,5214,'App\\Models\\Receipt',5214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',1972.83,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5409,7485,40723,6072,2,5215,'App\\Models\\Receipt',5215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',2956.27,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5410,7485,40723,6072,2,5216,'App\\Models\\Receipt',5216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',5085.53,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5411,7485,40723,6072,2,5217,'App\\Models\\Receipt',5217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',21881.99,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5412,7485,40723,6072,2,5218,'App\\Models\\Receipt',5218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',14816.88,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5413,7485,40723,6072,2,5219,'App\\Models\\Receipt',5219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',13236.32,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5414,7485,40723,6072,2,5220,'App\\Models\\Receipt',5220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',4461.80,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5415,7485,40723,6072,2,5221,'App\\Models\\Receipt',5221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',1657.08,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5416,7485,40723,6072,2,5222,'App\\Models\\Receipt',5222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',986.40,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5417,7485,40723,6072,2,5223,'App\\Models\\Receipt',5223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',8051.35,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5418,7485,40723,6072,2,5224,'App\\Models\\Receipt',5224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',4461.80,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5419,7485,40723,6072,2,5225,'App\\Models\\Receipt',5225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',41428.63,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5420,7485,40723,6072,2,5226,'App\\Models\\Receipt',5226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',3609.16,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5421,7485,40723,6072,2,5227,'App\\Models\\Receipt',5227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',2090.43,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5422,7485,40723,6072,2,5228,'App\\Models\\Receipt',5228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',41428.64,NULL,NULL,1,'2023-10-15 17:58:36','2023-10-15 17:58:36',NULL),(5423,7485,40723,6072,2,5229,'App\\Models\\Receipt',5229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',5715.19,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5424,7485,40723,6072,2,5230,'App\\Models\\Receipt',5230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',134660.34,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL);
INSERT INTO `balance_libro` VALUES (5425,7485,40723,6072,2,5231,'App\\Models\\Receipt',5231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',20189.31,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5426,7485,40723,6072,2,5232,'App\\Models\\Receipt',5232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',319429.80,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5427,7485,40723,6072,2,5233,'App\\Models\\Receipt',5233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',30245.00,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5428,7485,40723,6072,2,5234,'App\\Models\\Receipt',5234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',1037.55,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5429,7485,40723,6072,2,5235,'App\\Models\\Receipt',5235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',8602.02,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5430,7485,40723,6072,2,5236,'App\\Models\\Receipt',5236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',9347.16,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5431,7485,40723,6072,2,5237,'App\\Models\\Receipt',5237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',2487.02,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5432,7485,40723,6072,2,5238,'App\\Models\\Receipt',5238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',1143.06,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5433,7485,40723,6072,2,5239,'App\\Models\\Receipt',5239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',1972.83,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5434,7485,40723,6072,2,5240,'App\\Models\\Receipt',5240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',4946.72,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5435,7485,40723,6072,2,5241,'App\\Models\\Receipt',5241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',14843.83,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5436,7485,40723,6072,2,5242,'App\\Models\\Receipt',5242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',25021.02,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5437,7485,40723,6072,2,5243,'App\\Models\\Receipt',5243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',2540.04,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5438,7485,40723,6072,2,5244,'App\\Models\\Receipt',5244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',1579.81,NULL,NULL,1,'2023-10-15 17:58:37','2023-10-15 17:58:37',NULL),(5439,7485,40723,6072,2,5245,'App\\Models\\Receipt',5245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',3938.96,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5440,7485,40723,6072,2,5246,'App\\Models\\Receipt',5246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',1635.59,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5441,7485,40723,6072,2,5247,'App\\Models\\Receipt',5247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',156346.93,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5442,7485,40723,6072,2,5248,'App\\Models\\Receipt',5248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',15201.71,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5443,7485,40723,6072,2,5249,'App\\Models\\Receipt',5249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',636004.01,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5444,7485,40723,6072,2,5250,'App\\Models\\Receipt',5250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',6189.96,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5445,7485,40723,6072,2,5251,'App\\Models\\Receipt',5251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',4203.09,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL);
INSERT INTO `balance_libro` VALUES (5446,7485,40723,6072,2,5252,'App\\Models\\Receipt',5252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',3877.03,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5447,7485,40723,6072,2,5253,'App\\Models\\Receipt',5253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',5001.01,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5448,7485,40723,6072,2,5254,'App\\Models\\Receipt',5254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',1201.84,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5449,7485,40723,6072,2,5255,'App\\Models\\Receipt',5255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',583641.50,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5450,7485,40723,6072,2,5256,'App\\Models\\Receipt',5256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',305904.66,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5451,7485,40723,6072,2,5257,'App\\Models\\Receipt',5257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',1330.55,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5452,7485,40723,6072,2,5258,'App\\Models\\Receipt',5258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',29891.00,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5453,7485,40723,6072,2,5259,'App\\Models\\Receipt',5259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',7892.67,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5454,7485,40723,6072,2,5260,'App\\Models\\Receipt',5260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',4436.62,NULL,NULL,1,'2023-10-15 17:58:38','2023-10-15 17:58:38',NULL),(5455,7485,40723,6072,2,5261,'App\\Models\\Receipt',5261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',34611.37,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5456,7485,40723,6072,2,5262,'App\\Models\\Receipt',5262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',7877.87,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5457,7485,40723,6072,2,5263,'App\\Models\\Receipt',5263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',3945.60,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5458,7485,40723,6072,2,5264,'App\\Models\\Receipt',5264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',1201.84,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5459,7485,40723,6072,2,5265,'App\\Models\\Receipt',5265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',6836.35,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5460,7485,40723,6072,2,5266,'App\\Models\\Receipt',5266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',7910.00,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5461,7485,40723,6072,2,5267,'App\\Models\\Receipt',5267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3759.55,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5462,7485,40723,6072,2,5268,'App\\Models\\Receipt',5268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',1330.55,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5463,7485,40723,6072,2,5269,'App\\Models\\Receipt',5269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',2675.68,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5464,7485,40723,6072,2,5270,'App\\Models\\Receipt',5270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',1050.76,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5465,7485,40723,6072,2,5271,'App\\Models\\Receipt',5271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',1576.01,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5466,7485,40723,6072,2,5272,'App\\Models\\Receipt',5272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',5704.54,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL);
INSERT INTO `balance_libro` VALUES (5467,7485,40723,6072,2,5273,'App\\Models\\Receipt',5273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',8157.74,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5468,7485,40723,6072,2,5274,'App\\Models\\Receipt',5274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',10938.06,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5469,7485,40723,6072,2,5275,'App\\Models\\Receipt',5275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',10466.40,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5470,7485,40723,6072,2,5276,'App\\Models\\Receipt',5276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',32023.07,NULL,NULL,1,'2023-10-15 17:58:39','2023-10-15 17:58:39',NULL),(5471,7485,40723,6072,2,5277,'App\\Models\\Receipt',5277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',967609.46,NULL,NULL,1,'2023-10-15 17:58:40','2023-10-15 17:58:40',NULL),(5472,7485,40723,6072,2,5278,'App\\Models\\Receipt',5278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',1555126.18,NULL,NULL,1,'2023-10-15 17:58:40','2023-10-15 17:58:40',NULL),(5473,7485,40723,6072,2,5279,'App\\Models\\Receipt',5279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',3955.05,NULL,NULL,1,'2023-10-15 17:58:40','2023-10-15 17:58:40',NULL),(5474,7485,40720,1546,2,5474,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1000000.00,'ADELANTO DE CLIENTES',NULL,1,'2023-10-17 19:57:29','2023-10-17 20:05:34','2023-10-17 20:05:34'),(5475,7485,40720,1546,2,5475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1200000.00,'ANTICIPO CLIENTES JULIO 2022',NULL,1,'2023-10-17 20:17:02','2023-10-17 20:17:11','2023-10-17 20:17:11'),(5476,7485,40720,1546,2,5476,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1200000.00,'ANTICIPO CLIENTES JULIO 2022',NULL,1,'2023-10-17 20:17:11','2023-11-02 18:14:13','2023-11-02 18:14:13'),(5477,7485,40720,1547,2,5477,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',800000.00,'ANTICIPO DE CLIENTES',NULL,1,'2023-10-17 20:21:22','2023-10-17 22:11:34','2023-10-17 22:11:34'),(5478,7485,40720,1548,2,5478,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1500000.00,'ANTICIPO DE CLIENTES',NULL,1,'2023-10-17 20:22:29','2023-10-17 22:11:49','2023-10-17 22:11:49'),(5479,7485,40720,1549,2,5479,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',900000.00,'ANTICIPO DE CLIENTES OCTUBRE 2022',NULL,1,'2023-10-17 20:25:16','2023-11-02 18:14:02','2023-11-02 18:14:02'),(5480,7485,40720,1550,2,5480,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1100000.00,'ANTICIPO DE CLIENTES NOVIEMBRE 2022',NULL,1,'2023-10-17 20:27:35','2023-11-02 18:13:58','2023-11-02 18:13:58'),(5481,7485,40720,1551,2,5481,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900000.00,'ANTICIPO DE CLIENTES',NULL,1,'2023-10-17 20:28:26','2023-10-17 22:09:17','2023-10-17 22:09:17'),(5482,7485,40720,1555,2,5482,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1300000.00,'ANTICIPO DE CLIENTES ENERO 2023',NULL,1,'2023-10-17 22:04:13','2023-11-02 18:13:53','2023-11-02 18:13:53'),(5483,7485,40720,1556,2,5483,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700000.00,'ANTICIPO DE CLIENTES',NULL,1,'2023-10-17 22:05:12','2023-10-17 22:09:01','2023-10-17 22:09:01'),(5484,7485,40720,1557,2,5484,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',900000.00,'ANTICIPO DE CLIENTES',NULL,1,'2023-10-17 22:05:57','2023-10-17 22:08:47','2023-10-17 22:08:47');
INSERT INTO `balance_libro` VALUES (5485,7485,40720,1558,2,5485,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',500000.00,'ANTICIPO DE CLIENTES ABRIL 2023',NULL,1,'2023-10-17 22:06:43','2023-11-02 18:13:46','2023-11-02 18:13:46'),(5486,7485,40720,1559,2,5486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1100000.00,'ANTICIPO DE CLIENTES MAYO 2023',NULL,1,'2023-10-17 22:07:19','2023-11-02 18:13:37','2023-11-02 18:13:37'),(5487,7485,40720,1560,2,5487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',400000.00,'ANTICIPO DE CLIENTES JUNIO 2023',NULL,1,'2023-10-17 22:08:18','2023-11-02 18:12:23','2023-11-02 18:12:23'),(5488,7485,40720,1557,2,5488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',900000.00,'ANTICIPO DE CLIENTES MARZO 2023',NULL,1,'2023-10-17 22:08:47','2023-11-02 18:13:27','2023-11-02 18:13:27'),(5489,7485,40720,1556,2,5489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700000.00,'ANTICIPO DE CLIENTES FEBRERO 2023',NULL,1,'2023-10-17 22:09:01','2023-11-02 18:13:22','2023-11-02 18:13:22'),(5490,7485,40720,1551,2,5490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900000.00,'ANTICIPO DE CLIENTES DICIEMBRE 2022',NULL,1,'2023-10-17 22:09:17','2023-11-02 18:13:17','2023-11-02 18:13:17'),(5491,9756,40720,1549,3,5491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6297778.83,'COMPRAS OCTUBRE 2022',NULL,1,'2023-10-17 22:10:39','2024-01-06 15:23:04','2024-01-06 15:23:04'),(5492,7485,40720,1547,2,5492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',800000.00,'ANTICIPO DE CLIENTES AGOSTO 2022',NULL,1,'2023-10-17 22:11:34','2023-11-02 18:12:52','2023-11-02 18:12:52'),(5493,7485,40720,1548,2,5493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1500000.00,'ANTICIPO DE CLIENTES SEPTIEMBRE 2022',NULL,1,'2023-10-17 22:11:49','2023-11-02 18:12:37','2023-11-02 18:12:37'),(5494,9756,40720,1557,2,5494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4088828.06,'VENTAS MARZO 2023',NULL,1,'2023-10-21 20:15:34','2024-01-06 19:02:13','2024-01-06 19:02:13'),(5495,7485,40720,1563,2,5280,'App\\Models\\Receipt',5280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',255150.00,NULL,NULL,1,'2023-10-22 13:16:14','2023-10-30 20:03:28','2023-10-30 20:03:28'),(5496,7485,40720,1563,2,5281,'App\\Models\\Receipt',5281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',70000.00,NULL,NULL,1,'2023-10-22 13:16:15','2023-10-30 20:03:29','2023-10-30 20:03:29'),(5497,7485,40720,1563,2,5282,'App\\Models\\Receipt',5282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',1198000.06,NULL,NULL,1,'2023-10-22 13:16:15','2023-10-30 20:03:29','2023-10-30 20:03:29'),(5498,7485,40720,1563,2,5283,'App\\Models\\Receipt',5283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',40700.04,NULL,NULL,1,'2023-10-22 13:16:15','2023-10-30 20:03:29','2023-10-30 20:03:29'),(5499,7485,40720,1563,2,5284,'App\\Models\\Receipt',5284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',70000.00,NULL,NULL,1,'2023-10-22 13:16:15','2023-10-30 20:03:29','2023-10-30 20:03:29'),(5500,7485,40720,1563,2,5285,'App\\Models\\Receipt',5285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',40000.02,NULL,NULL,1,'2023-10-22 13:16:15','2023-10-30 20:03:29','2023-10-30 20:03:29'),(5501,7485,40720,1563,3,5286,'App\\Models\\Receipt',5286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',130000.00,NULL,NULL,1,'2023-10-22 13:16:35','2023-10-30 20:05:18','2023-10-30 20:05:18');
INSERT INTO `balance_libro` VALUES (5502,7485,40720,1563,3,5287,'App\\Models\\Receipt',5287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',19232.21,NULL,NULL,1,'2023-10-22 13:16:35','2023-10-30 20:05:18','2023-10-30 20:05:18'),(5503,7485,40720,1563,3,5288,'App\\Models\\Receipt',5288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',1406736.63,NULL,NULL,1,'2023-10-22 13:16:35','2023-10-30 20:05:18','2023-10-30 20:05:18'),(5504,7485,40720,1563,3,5289,'App\\Models\\Receipt',5289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',90337.73,NULL,NULL,1,'2023-10-22 13:16:35','2023-10-30 20:05:18','2023-10-30 20:05:18'),(5505,7485,40720,1563,3,5290,'App\\Models\\Receipt',5290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',24230.69,NULL,NULL,1,'2023-10-22 13:16:35','2023-10-30 20:05:18','2023-10-30 20:05:18'),(5506,7485,40720,1563,3,5291,'App\\Models\\Receipt',5291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',22750.00,NULL,NULL,1,'2023-10-22 13:16:35','2023-10-30 20:05:18','2023-10-30 20:05:18'),(5507,7485,40720,1563,3,5292,'App\\Models\\Receipt',5292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',63369.96,NULL,NULL,1,'2023-10-22 13:16:35','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5508,7485,40720,1563,3,5293,'App\\Models\\Receipt',5293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',198465.00,NULL,NULL,1,'2023-10-22 13:16:35','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5509,7485,40720,1563,3,5294,'App\\Models\\Receipt',5294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',1406736.63,NULL,NULL,1,'2023-10-22 13:16:35','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5510,7485,40720,1563,3,5295,'App\\Models\\Receipt',5295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',44120.00,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5511,7485,40720,1563,3,5296,'App\\Models\\Receipt',5296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',11601.36,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5512,7485,40720,1563,3,5297,'App\\Models\\Receipt',5297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',1061284.49,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5513,7485,40720,1563,3,5298,'App\\Models\\Receipt',5298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',230403.36,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5514,7485,40720,1563,3,5299,'App\\Models\\Receipt',5299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',635900.27,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5515,7485,40720,1563,3,5300,'App\\Models\\Receipt',5300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',373901.75,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5516,7485,40720,1563,3,5301,'App\\Models\\Receipt',5301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',207800.01,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5517,7485,40720,1563,3,5302,'App\\Models\\Receipt',5302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',200000.05,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5518,7485,40720,1563,3,5303,'App\\Models\\Receipt',5303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',157984.34,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5519,7485,40720,1563,3,5304,'App\\Models\\Receipt',5304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',627435.09,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5520,7485,40720,1563,3,5305,'App\\Models\\Receipt',5305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',225000.10,NULL,NULL,1,'2023-10-22 13:16:36','2023-10-30 20:05:19','2023-10-30 20:05:19');
INSERT INTO `balance_libro` VALUES (5521,7485,40720,1563,3,5306,'App\\Models\\Receipt',5306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',5466.00,NULL,NULL,1,'2023-10-22 13:36:29','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5522,7485,40720,1563,3,5307,'App\\Models\\Receipt',5307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',363.00,NULL,NULL,1,'2023-10-22 13:37:15','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5523,7485,40720,1563,3,5308,'App\\Models\\Receipt',5308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',363.00,NULL,NULL,1,'2023-10-22 13:37:47','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5524,7485,40720,1563,3,5309,'App\\Models\\Receipt',5309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',363.00,NULL,NULL,1,'2023-10-22 13:38:45','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5525,7485,40720,1563,3,5310,'App\\Models\\Receipt',5310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',726.00,NULL,NULL,1,'2023-10-22 13:39:40','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5526,7485,40720,1563,3,5311,'App\\Models\\Receipt',5311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',1815.00,NULL,NULL,1,'2023-10-22 13:40:25','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5527,7485,40720,1563,3,5312,'App\\Models\\Receipt',5312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',363.00,NULL,NULL,1,'2023-10-22 13:43:31','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5528,7485,40720,1563,3,5313,'App\\Models\\Receipt',5313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',363.00,NULL,NULL,1,'2023-10-22 13:43:59','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5529,7485,40720,1563,3,5314,'App\\Models\\Receipt',5314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',363.00,NULL,NULL,1,'2023-10-22 13:48:02','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5530,7485,40720,1563,3,5315,'App\\Models\\Receipt',5315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',24087.00,NULL,NULL,1,'2023-10-22 13:51:58','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5531,7485,40720,1563,3,5316,'App\\Models\\Receipt',5316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',3388.00,NULL,NULL,1,'2023-10-22 13:52:45','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5532,7485,40720,1563,3,5317,'App\\Models\\Receipt',5317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',847.00,NULL,NULL,1,'2023-10-22 13:53:11','2023-10-30 20:05:19','2023-10-30 20:05:19'),(5533,7485,40721,3063,3,5318,'App\\Models\\Receipt',5318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',459300.23,NULL,NULL,1,'2023-10-22 21:18:06','2023-10-22 21:18:06',NULL),(5534,7485,40721,3063,2,5319,'App\\Models\\Receipt',5319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',115000.02,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5535,7485,40721,3063,2,5320,'App\\Models\\Receipt',5320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',250000.00,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5536,7485,40721,3063,2,5321,'App\\Models\\Receipt',5321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',150000.02,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5537,7485,40721,3063,2,5322,'App\\Models\\Receipt',5322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',832000.00,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5538,7485,40721,3063,2,5323,'App\\Models\\Receipt',5323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',230000.06,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5539,7485,40721,3063,2,5324,'App\\Models\\Receipt',5324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',160000.06,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5540,7485,40721,3063,2,5325,'App\\Models\\Receipt',5325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',200000.00,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL);
INSERT INTO `balance_libro` VALUES (5541,7485,40721,3063,2,5326,'App\\Models\\Receipt',5326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',100000.00,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5542,7485,40721,3063,2,5327,'App\\Models\\Receipt',5327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',150000.02,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5543,7485,40721,3063,2,5328,'App\\Models\\Receipt',5328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',273000.06,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5544,7485,40721,3063,2,5329,'App\\Models\\Receipt',5329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',158268.00,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5545,7485,40721,3063,2,5330,'App\\Models\\Receipt',5330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',170000.00,NULL,NULL,1,'2023-10-22 21:18:19','2023-10-22 21:18:19',NULL),(5546,7485,40721,3063,2,5331,'App\\Models\\Receipt',5331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',181302.16,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5547,7485,40721,3063,2,5332,'App\\Models\\Receipt',5332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',1036000.00,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5548,7485,40721,3063,2,5333,'App\\Models\\Receipt',5333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',532800.00,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5549,7485,40721,3063,2,5334,'App\\Models\\Receipt',5334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',370000.04,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5550,7485,40721,3063,2,5335,'App\\Models\\Receipt',5335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',925000.00,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5551,7485,40721,3063,2,5336,'App\\Models\\Receipt',5336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',621000.00,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5552,7485,40721,3063,2,5337,'App\\Models\\Receipt',5337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',380000.00,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5553,7485,40721,3063,2,5338,'App\\Models\\Receipt',5338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',181029.00,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5554,7485,40721,3063,2,5339,'App\\Models\\Receipt',5339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',832500.00,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5555,7485,40721,3063,2,5340,'App\\Models\\Receipt',5340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',150000.02,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5556,7485,40721,3063,2,5341,'App\\Models\\Receipt',5341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',182800.00,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5557,7485,40721,3063,2,5342,'App\\Models\\Receipt',5342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',250000.00,NULL,NULL,1,'2023-10-22 21:18:20','2023-10-22 21:18:20',NULL),(5558,7485,40721,3063,2,5343,'App\\Models\\Receipt',5343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',220000.02,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL),(5559,7485,40721,3063,2,5344,'App\\Models\\Receipt',5344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',210000.00,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL),(5560,7485,40721,3063,2,5345,'App\\Models\\Receipt',5345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',300000.04,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL),(5561,7485,40721,3063,2,5346,'App\\Models\\Receipt',5346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',222000.06,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL);
INSERT INTO `balance_libro` VALUES (5562,7485,40721,3063,2,5347,'App\\Models\\Receipt',5347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',200000.00,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL),(5563,7485,40721,3063,2,5348,'App\\Models\\Receipt',5348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',310000.00,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL),(5564,7485,40721,3063,2,5349,'App\\Models\\Receipt',5349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',200000.00,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL),(5565,7485,40721,3063,2,5350,'App\\Models\\Receipt',5350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',200000.00,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL),(5566,7485,40721,3063,2,5351,'App\\Models\\Receipt',5351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',310000.00,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL),(5567,7485,40721,3063,2,5352,'App\\Models\\Receipt',5352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',192800.04,NULL,NULL,1,'2023-10-22 21:18:21','2023-10-22 21:18:21',NULL),(5568,7485,40720,1546,2,5568,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6568491.30,'VENTAS JULIO 2022',NULL,1,'2023-10-27 14:55:41','2023-10-30 19:46:32','2023-10-30 19:46:32'),(5569,9756,40720,1546,2,5569,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6568491.30,'VENTAS JULIO 2022',NULL,1,'2023-10-30 19:46:32','2024-01-06 19:50:07','2024-01-06 19:50:07'),(5570,7485,40720,1546,19,5570,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',60327561.94,'ASIENTO DE APERTURA',NULL,1,'2023-10-31 22:37:28','2023-11-07 21:38:36','2023-11-07 21:38:36'),(5571,7485,40720,1560,2,5571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7200000.00,'ANTICIPO DE CLIENTES JUNIO 2023',NULL,1,'2023-11-02 18:12:23','2023-11-02 18:16:55','2023-11-02 18:16:55'),(5572,7485,40720,1560,2,5572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7230000.00,'ANTICIPO DE CLIENTES JUNIO 2023',NULL,1,'2023-11-02 18:16:55','2023-11-02 18:20:07','2023-11-02 18:20:07'),(5573,7485,40720,1560,2,5573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7230000.00,'ANTICIPO DE CLIENTES JUNIO 2023',NULL,1,'2023-11-02 18:20:07','2023-11-02 18:20:07',NULL),(5574,7485,40719,24,13,5574,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',19152516.63,'preparacion',NULL,1,'2023-11-02 21:45:03','2023-11-02 21:45:27','2023-11-02 21:45:27'),(5575,7485,40719,24,13,5575,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',19152516.63,'preparacion',NULL,1,'2023-11-02 21:45:27','2023-11-02 21:45:27',NULL),(5576,7485,40720,1546,12,5576,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',60327561.94,'APERTURA',NULL,1,'2023-11-02 23:01:13','2023-11-07 20:47:49','2023-11-07 20:47:49'),(5577,7485,40720,1546,12,5577,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',60327561.94,'ASIENTO DE APERTURA',NULL,1,'2023-11-07 20:47:49','2023-11-07 20:48:08','2023-11-07 20:48:08'),(5578,9756,40720,1546,12,5578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',60327561.94,'ASIENTO  APERTURA',NULL,1,'2023-11-07 20:48:08','2024-01-06 09:34:16','2024-01-06 09:34:16'),(5579,7485,40720,1558,5,5579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1072071.64,'CONCILIACIONES BANCOS ABRIL 2023',NULL,1,'2023-11-08 20:00:43','2023-11-08 20:00:43',NULL);
INSERT INTO `balance_libro` VALUES (5580,7485,40720,1547,5,5580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2651531.27,'CONCILIACIONES BANCOS AGOSTO 2022',NULL,1,'2023-11-08 20:12:52','2023-11-08 20:12:52',NULL),(5581,7485,40720,1557,5,5581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1984250.92,'CONCILIACIONES BANCOS MARZO 2023',NULL,1,'2023-11-08 21:05:00','2023-11-08 21:05:00',NULL),(5582,7485,40720,1547,11,5582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',12300000.00,'CAJA AGOSTO 2022',NULL,1,'2023-11-10 19:15:05','2023-11-10 19:17:32','2023-11-10 19:17:32'),(5583,7485,40720,1548,2,5583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',600000.00,'AJUSTE CAJA 092022',NULL,1,'2023-11-10 19:17:11','2023-11-10 19:25:55','2023-11-10 19:25:55'),(5584,7485,40720,1547,11,5584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',12300000.00,'AJUSTE CAJA 082022',NULL,1,'2023-11-10 19:17:32','2023-11-10 19:17:32',NULL),(5585,7485,40720,1550,2,5585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5000000.00,'AJUSTE CAJA 112022',NULL,1,'2023-11-10 19:25:55','2023-11-10 19:25:55',NULL),(5586,7485,40720,1551,2,5586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',240000.00,'AJUSTE CAJA 122022',NULL,1,'2023-11-10 19:29:39','2023-11-10 19:50:26','2023-11-10 19:50:26'),(5587,7485,40720,1551,2,5587,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',240000.00,'AJUSTE CAJA 122022',NULL,1,'2023-11-10 19:29:39','2023-11-10 19:38:28','2023-11-10 19:38:28'),(5588,7485,40720,1555,2,5588,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1600000.00,'AJUSTE CAJA 012023',NULL,1,'2023-11-10 19:34:57','2023-11-10 19:50:32','2023-11-10 19:50:32'),(5589,7485,40720,1549,2,5589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',500000.00,'AJUSTE CAJA 102022',NULL,1,'2023-11-10 19:40:17','2023-11-10 19:40:17',NULL),(5590,7485,40720,1560,3,5590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',17800000.00,'AJUSTE CAJA 062023',NULL,1,'2023-11-10 23:02:30','2023-11-10 23:06:10','2023-11-10 23:06:10'),(5591,7485,40720,1560,3,5591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',17800000.00,'AJUSTE CAJA 062023',NULL,1,'2023-11-10 23:06:10','2023-11-10 23:06:10',NULL),(5592,7485,40828,7778,3,5353,'App\\Models\\Receipt',5353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',3099.90,NULL,NULL,1,'2023-11-14 13:12:36','2023-11-14 13:12:36',NULL),(5593,7485,40828,7778,3,5354,'App\\Models\\Receipt',5354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',28412.16,NULL,NULL,1,'2023-11-14 13:12:36','2023-11-14 13:12:36',NULL),(5594,7485,40828,7778,3,5355,'App\\Models\\Receipt',5355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',118859.40,NULL,NULL,1,'2023-11-14 13:12:37','2023-11-14 13:12:37',NULL),(5595,7485,40828,7778,3,5356,'App\\Models\\Receipt',5356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',141055.00,NULL,NULL,1,'2023-11-14 13:12:37','2023-11-14 13:12:37',NULL),(5596,7485,40828,7778,3,5357,'App\\Models\\Receipt',5357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',467600.00,NULL,NULL,1,'2023-11-14 13:12:37','2023-11-14 13:12:37',NULL),(5597,7485,40828,7778,3,5358,'App\\Models\\Receipt',5358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',8177.39,NULL,NULL,1,'2023-11-14 13:12:37','2023-11-14 13:12:37',NULL),(5598,7485,40828,7778,3,5359,'App\\Models\\Receipt',5359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',11478.00,NULL,NULL,1,'2023-11-14 13:12:37','2023-11-14 13:12:37',NULL);
INSERT INTO `balance_libro` VALUES (5599,7485,40828,7778,3,5360,'App\\Models\\Receipt',5360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',212353.74,NULL,NULL,1,'2023-11-14 13:12:37','2023-11-14 13:12:37',NULL),(5600,7485,40828,7778,3,5361,'App\\Models\\Receipt',5361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',5942.97,NULL,NULL,1,'2023-11-14 13:12:37','2023-11-14 13:12:37',NULL),(5601,7485,40828,7778,3,5362,'App\\Models\\Receipt',5362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',11470.99,NULL,NULL,1,'2023-11-14 13:12:38','2023-11-14 13:12:38',NULL),(5602,7485,40828,7778,3,5363,'App\\Models\\Receipt',5363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',36822.55,NULL,NULL,1,'2023-11-14 13:12:38','2023-11-14 13:12:38',NULL),(5603,7485,40828,7778,2,5364,'App\\Models\\Receipt',5364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',45950.00,NULL,NULL,1,'2023-11-14 13:18:24','2023-11-14 13:18:24',NULL),(5604,7485,40828,7778,2,5365,'App\\Models\\Receipt',5365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',46080.16,NULL,NULL,1,'2023-11-14 13:18:25','2023-11-14 13:18:25',NULL),(5605,7485,40828,7778,2,5366,'App\\Models\\Receipt',5366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',46290.00,NULL,NULL,1,'2023-11-14 13:18:25','2023-11-14 13:18:25',NULL),(5606,7485,40828,7778,2,5367,'App\\Models\\Receipt',5367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',46000.00,NULL,NULL,1,'2023-11-14 13:18:25','2023-11-14 13:18:25',NULL),(5607,7485,40828,7778,2,5368,'App\\Models\\Receipt',5368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',46300.04,NULL,NULL,1,'2023-11-14 13:18:25','2023-11-14 13:18:25',NULL),(5608,7485,40828,7778,2,5369,'App\\Models\\Receipt',5369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',36400.00,NULL,NULL,1,'2023-11-14 13:18:25','2023-11-14 13:18:25',NULL),(5609,7485,40828,7778,2,5370,'App\\Models\\Receipt',5370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',392400.00,NULL,NULL,1,'2023-11-14 13:18:25','2023-11-14 13:18:25',NULL),(5610,7485,40828,7778,2,5371,'App\\Models\\Receipt',5371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',15600.02,NULL,NULL,1,'2023-11-14 13:18:25','2023-11-14 13:18:25',NULL),(5611,7485,40828,7778,2,5372,'App\\Models\\Receipt',5372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',934300.00,NULL,NULL,1,'2023-11-14 13:18:25','2023-11-14 13:18:25',NULL),(5612,7485,40723,6073,3,5373,'App\\Models\\Receipt',5373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',16850.70,NULL,NULL,1,'2023-11-14 21:07:36','2023-11-14 21:07:36',NULL),(5613,7485,40723,6073,3,5374,'App\\Models\\Receipt',5374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',54692.00,NULL,NULL,1,'2023-11-14 21:07:37','2023-11-14 21:07:37',NULL),(5614,7485,40723,6073,3,5375,'App\\Models\\Receipt',5375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',16225.34,NULL,NULL,1,'2023-11-14 21:07:37','2023-11-14 21:07:37',NULL),(5615,7485,40723,6073,3,5376,'App\\Models\\Receipt',5376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',25730.00,NULL,NULL,1,'2023-11-14 21:07:37','2023-11-14 21:07:37',NULL),(5616,7485,40723,6073,3,5377,'App\\Models\\Receipt',5377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',4430.00,NULL,NULL,1,'2023-11-14 21:07:37','2023-11-14 21:07:37',NULL),(5617,7485,40723,6073,3,5378,'App\\Models\\Receipt',5378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',54692.00,NULL,NULL,1,'2023-11-14 21:07:37','2023-11-14 21:07:37',NULL),(5618,7485,40723,6073,3,5379,'App\\Models\\Receipt',5379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',9617.21,NULL,NULL,1,'2023-11-14 21:07:37','2023-11-14 21:07:37',NULL),(5619,7485,40723,6073,3,5380,'App\\Models\\Receipt',5380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',11003.29,NULL,NULL,1,'2023-11-14 21:07:37','2023-11-14 21:07:37',NULL);
INSERT INTO `balance_libro` VALUES (5620,7485,40723,6073,3,5381,'App\\Models\\Receipt',5381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',23592.23,NULL,NULL,1,'2023-11-14 21:07:37','2023-11-14 21:07:37',NULL),(5621,7485,40723,6073,3,5382,'App\\Models\\Receipt',5382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',18999.00,NULL,NULL,1,'2023-11-14 21:07:37','2023-11-14 21:07:37',NULL),(5622,7485,40723,6073,3,5383,'App\\Models\\Receipt',5383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',13604.14,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5623,7485,40723,6073,3,5384,'App\\Models\\Receipt',5384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',7572.10,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5624,7485,40723,6073,3,5385,'App\\Models\\Receipt',5385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',5348.97,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5625,7485,40723,6073,3,5386,'App\\Models\\Receipt',5386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1500.00,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5626,7485,40723,6073,3,5387,'App\\Models\\Receipt',5387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1600.00,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5627,7485,40723,6073,3,5388,'App\\Models\\Receipt',5388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',2450.00,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5628,7485,40723,6073,3,5389,'App\\Models\\Receipt',5389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',19978.00,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5629,7485,40723,6073,3,5390,'App\\Models\\Receipt',5390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',19978.00,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5630,7485,40723,6073,3,5391,'App\\Models\\Receipt',5391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',4430.00,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5631,7485,40723,6073,3,5392,'App\\Models\\Receipt',5392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',2479189.47,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5632,7485,40723,6073,3,5393,'App\\Models\\Receipt',5393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',11498.00,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5633,7485,40723,6073,3,5394,'App\\Models\\Receipt',5394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',88768.94,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5634,7485,40723,6073,3,5395,'App\\Models\\Receipt',5395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',11403.19,NULL,NULL,1,'2023-11-14 21:07:38','2023-11-14 21:07:38',NULL),(5635,7485,40723,6073,3,5396,'App\\Models\\Receipt',5396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',552667.50,NULL,NULL,1,'2023-11-14 21:07:39','2023-11-14 21:07:39',NULL),(5636,7485,40723,6073,3,5397,'App\\Models\\Receipt',5397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',10107.65,NULL,NULL,1,'2023-11-14 21:07:39','2023-11-14 21:07:39',NULL),(5637,7485,40723,6073,3,5398,'App\\Models\\Receipt',5398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-29','2023-10-29',316740.48,NULL,NULL,1,'2023-11-14 21:07:39','2023-11-14 21:07:39',NULL),(5638,7485,40723,6073,3,5399,'App\\Models\\Receipt',5399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-29','2023-10-29',620225.41,NULL,NULL,1,'2023-11-14 21:07:39','2023-11-14 21:07:39',NULL),(5639,7485,40723,6073,3,5400,'App\\Models\\Receipt',5400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-29','2023-10-29',5635.69,NULL,NULL,1,'2023-11-14 21:07:39','2023-11-14 21:07:39',NULL),(5640,7485,40723,6073,3,5401,'App\\Models\\Receipt',5401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-29','2023-10-29',19296.71,NULL,NULL,1,'2023-11-14 21:07:39','2023-11-14 21:07:39',NULL);
INSERT INTO `balance_libro` VALUES (5641,7485,40723,6073,3,5402,'App\\Models\\Receipt',5402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',400.00,NULL,NULL,1,'2023-11-14 21:07:39','2023-11-14 21:07:39',NULL),(5642,7485,40723,6073,2,5403,'App\\Models\\Receipt',5403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',101292.44,NULL,NULL,1,'2023-11-14 21:07:50','2023-11-14 21:07:50',NULL),(5643,7485,40723,6073,2,5404,'App\\Models\\Receipt',5404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',152952.31,NULL,NULL,1,'2023-11-14 21:07:50','2023-11-14 21:07:50',NULL),(5644,7485,40723,6073,2,5405,'App\\Models\\Receipt',5405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',7511.23,NULL,NULL,1,'2023-11-14 21:07:50','2023-11-14 21:07:50',NULL),(5645,7485,40723,6073,2,5406,'App\\Models\\Receipt',5406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',1972.82,NULL,NULL,1,'2023-11-14 21:07:50','2023-11-14 21:07:50',NULL),(5646,7485,40723,6073,2,5407,'App\\Models\\Receipt',5407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',28987.23,NULL,NULL,1,'2023-11-14 21:07:50','2023-11-14 21:07:50',NULL),(5647,7485,40723,6073,2,5408,'App\\Models\\Receipt',5408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',5449.16,NULL,NULL,1,'2023-11-14 21:07:50','2023-11-14 21:07:50',NULL),(5648,7485,40723,6073,2,5409,'App\\Models\\Receipt',5409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',1530.27,NULL,NULL,1,'2023-11-14 21:07:50','2023-11-14 21:07:50',NULL),(5649,7485,40723,6073,2,5410,'App\\Models\\Receipt',5410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',12018.02,NULL,NULL,1,'2023-11-14 21:07:50','2023-11-14 21:07:50',NULL),(5650,7485,40723,6073,2,5411,'App\\Models\\Receipt',5411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',2156.37,NULL,NULL,1,'2023-11-14 21:07:50','2023-11-14 21:07:50',NULL),(5651,7485,40723,6073,2,5412,'App\\Models\\Receipt',5412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',315298.76,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5652,7485,40723,6073,2,5413,'App\\Models\\Receipt',5413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',58770.57,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5653,7485,40723,6073,2,5414,'App\\Models\\Receipt',5414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',5001.07,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5654,7485,40723,6073,2,5415,'App\\Models\\Receipt',5415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',28108.83,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5655,7485,40723,6073,2,5416,'App\\Models\\Receipt',5416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',13667.72,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5656,7485,40723,6073,2,5417,'App\\Models\\Receipt',5417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',1846980.82,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5657,7485,40723,6073,2,5418,'App\\Models\\Receipt',5418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',2945.08,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5658,7485,40723,6073,2,5419,'App\\Models\\Receipt',5419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',6710.05,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5659,7485,40723,6073,2,5420,'App\\Models\\Receipt',5420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',10575.88,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5660,7485,40723,6073,2,5421,'App\\Models\\Receipt',5421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',6459.22,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL),(5661,7485,40723,6073,2,5422,'App\\Models\\Receipt',5422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',3993.00,NULL,NULL,1,'2023-11-14 21:07:51','2023-11-14 21:07:51',NULL);
INSERT INTO `balance_libro` VALUES (5662,7485,40723,6073,2,5423,'App\\Models\\Receipt',5423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',398247.68,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5663,7485,40723,6073,2,5424,'App\\Models\\Receipt',5424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',781543.88,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5664,7485,40723,6073,2,5425,'App\\Models\\Receipt',5425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',301993.24,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5665,7485,40723,6073,2,5426,'App\\Models\\Receipt',5426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',287575.65,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5666,7485,40723,6073,2,5427,'App\\Models\\Receipt',5427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',17931.29,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5667,7485,40723,6073,2,5428,'App\\Models\\Receipt',5428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',730.73,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5668,7485,40723,6073,2,5429,'App\\Models\\Receipt',5429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',2520.05,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5669,7485,40723,6073,2,5430,'App\\Models\\Receipt',5430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',43953.49,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5670,7485,40723,6073,2,5431,'App\\Models\\Receipt',5431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',2472.97,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5671,7485,40723,6073,2,5432,'App\\Models\\Receipt',5432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',29825.48,NULL,NULL,1,'2023-11-14 21:07:52','2023-11-14 21:07:52',NULL),(5672,7485,40723,6073,2,5433,'App\\Models\\Receipt',5433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',14679.16,NULL,NULL,1,'2023-11-14 21:07:53','2023-11-14 21:07:53',NULL),(5673,7485,40723,6073,2,5434,'App\\Models\\Receipt',5434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',2472.97,NULL,NULL,1,'2023-11-14 21:07:53','2023-11-14 21:07:53',NULL),(5674,7485,40723,6073,2,5435,'App\\Models\\Receipt',5435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',29529.95,NULL,NULL,1,'2023-11-14 21:07:53','2023-11-14 21:07:53',NULL),(5675,7485,40723,6073,2,5436,'App\\Models\\Receipt',5436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',9088.56,NULL,NULL,1,'2023-11-14 21:07:53','2023-11-14 21:07:53',NULL),(5676,7485,40723,6073,2,5437,'App\\Models\\Receipt',5437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',35465.92,NULL,NULL,1,'2023-11-14 21:07:53','2023-11-14 21:07:53',NULL),(5677,7485,40723,6073,2,5438,'App\\Models\\Receipt',5438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',3870.00,NULL,NULL,1,'2023-11-14 21:07:53','2023-11-14 21:07:53',NULL),(5678,7485,40723,6073,2,5439,'App\\Models\\Receipt',5439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',4362.53,NULL,NULL,1,'2023-11-14 21:07:53','2023-11-14 21:07:53',NULL),(5679,7485,40723,6073,2,5440,'App\\Models\\Receipt',5440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',6015.14,NULL,NULL,1,'2023-11-14 21:07:53','2023-11-14 21:07:53',NULL),(5680,7485,40723,6073,2,5441,'App\\Models\\Receipt',5441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',11506.54,NULL,NULL,1,'2023-11-14 21:07:53','2023-11-14 21:07:53',NULL),(5681,7485,40723,6073,2,5442,'App\\Models\\Receipt',5442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',1454.20,NULL,NULL,1,'2023-11-14 21:07:54','2023-11-14 21:07:54',NULL),(5682,7485,40723,6073,2,5443,'App\\Models\\Receipt',5443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',14230.00,NULL,NULL,1,'2023-11-14 21:07:54','2023-11-14 21:07:54',NULL);
INSERT INTO `balance_libro` VALUES (5683,7485,40723,6073,2,5444,'App\\Models\\Receipt',5444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',20480.24,NULL,NULL,1,'2023-11-14 21:07:54','2023-11-14 21:07:54',NULL),(5684,7485,40723,6073,2,5445,'App\\Models\\Receipt',5445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',227595.78,NULL,NULL,1,'2023-11-14 21:07:54','2023-11-14 21:07:54',NULL),(5685,7485,40723,6073,2,5446,'App\\Models\\Receipt',5446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',6189.74,NULL,NULL,1,'2023-11-14 21:07:54','2023-11-14 21:07:54',NULL),(5686,7485,40723,6073,2,5447,'App\\Models\\Receipt',5447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',3666.30,NULL,NULL,1,'2023-11-14 21:07:54','2023-11-14 21:07:54',NULL),(5687,7485,40723,6073,2,5448,'App\\Models\\Receipt',5448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',1268988.45,NULL,NULL,1,'2023-11-14 21:07:54','2023-11-14 21:07:54',NULL),(5688,7485,40723,6073,2,5449,'App\\Models\\Receipt',5449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',5449.16,NULL,NULL,1,'2023-11-14 21:07:54','2023-11-14 21:07:54',NULL),(5689,7485,40723,6073,2,5450,'App\\Models\\Receipt',5450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',12677.80,NULL,NULL,1,'2023-11-14 21:07:55','2023-11-14 21:07:55',NULL),(5690,7485,40723,6073,2,5451,'App\\Models\\Receipt',5451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',67137.10,NULL,NULL,1,'2023-11-14 21:07:55','2023-11-14 21:07:55',NULL),(5691,7485,40723,6073,2,5452,'App\\Models\\Receipt',5452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',8049.80,NULL,NULL,1,'2023-11-14 21:07:55','2023-11-14 21:07:55',NULL),(5692,7485,40723,6073,2,5453,'App\\Models\\Receipt',5453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',6526.74,NULL,NULL,1,'2023-11-14 21:07:55','2023-11-14 21:07:55',NULL),(5693,7485,40721,3064,3,5454,'App\\Models\\Receipt',5454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',107696.58,NULL,NULL,1,'2023-11-16 20:22:41','2023-11-16 20:22:41',NULL),(5694,7485,40721,3064,3,5455,'App\\Models\\Receipt',5455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',213000.17,NULL,NULL,1,'2023-11-16 20:22:41','2023-11-16 20:22:41',NULL),(5695,7485,40721,3064,3,5456,'App\\Models\\Receipt',5456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',328300.24,NULL,NULL,1,'2023-11-16 20:22:41','2023-11-16 20:22:41',NULL),(5696,7485,40721,3064,3,5457,'App\\Models\\Receipt',5457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',72555.24,NULL,NULL,1,'2023-11-16 20:22:41','2023-11-16 20:22:41',NULL),(5697,7485,40721,3064,3,5458,'App\\Models\\Receipt',5458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',205100.09,NULL,NULL,1,'2023-11-16 20:22:41','2023-11-16 20:22:41',NULL),(5698,7485,40721,3064,3,5459,'App\\Models\\Receipt',5459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',321200.33,NULL,NULL,1,'2023-11-16 20:22:41','2023-11-16 20:22:41',NULL),(5699,7485,40721,3064,3,5460,'App\\Models\\Receipt',5460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',228000.00,NULL,NULL,1,'2023-11-16 20:22:41','2023-11-16 20:22:41',NULL),(5700,7485,40721,3064,3,5461,'App\\Models\\Receipt',5461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',67500.00,NULL,NULL,1,'2023-11-16 20:22:42','2023-11-16 20:22:42',NULL),(5701,7485,40721,3064,3,5462,'App\\Models\\Receipt',5462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',2180062.04,NULL,NULL,1,'2023-11-16 20:22:42','2023-11-16 20:22:42',NULL),(5702,7485,40721,3064,2,5463,'App\\Models\\Receipt',5463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',145000.00,NULL,NULL,1,'2023-11-16 22:16:42','2023-11-16 22:16:42',NULL),(5703,7485,40721,3064,2,5464,'App\\Models\\Receipt',5464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',181302.16,NULL,NULL,1,'2023-11-16 22:16:42','2023-11-16 22:16:42',NULL);
INSERT INTO `balance_libro` VALUES (5704,7485,40721,3064,2,5465,'App\\Models\\Receipt',5465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',181302.16,NULL,NULL,1,'2023-11-16 22:16:42','2023-11-16 22:16:42',NULL),(5705,7485,40721,3064,2,5466,'App\\Models\\Receipt',5466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',900000.04,NULL,NULL,1,'2023-11-16 22:16:42','2023-11-16 22:16:42',NULL),(5706,7485,40721,3064,2,5467,'App\\Models\\Receipt',5467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',705000.00,NULL,NULL,1,'2023-11-16 22:16:43','2023-11-16 22:16:43',NULL),(5707,7485,40721,3064,2,5468,'App\\Models\\Receipt',5468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',423000.20,NULL,NULL,1,'2023-11-16 22:16:43','2023-11-16 22:16:43',NULL),(5708,7485,40721,3064,2,5469,'App\\Models\\Receipt',5469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',925000.00,NULL,NULL,1,'2023-11-16 22:16:43','2023-11-16 22:16:43',NULL),(5709,7485,40721,3064,2,5470,'App\\Models\\Receipt',5470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',621600.00,NULL,NULL,1,'2023-11-16 22:16:43','2023-11-16 22:16:43',NULL),(5710,7485,40721,3064,2,5471,'App\\Models\\Receipt',5471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',740000.00,NULL,NULL,1,'2023-11-16 22:16:43','2023-11-16 22:16:43',NULL),(5711,7485,40721,3064,3,5472,'App\\Models\\Receipt',5472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',363.00,NULL,NULL,1,'2023-11-16 22:27:11','2023-11-16 22:27:11',NULL),(5712,7485,40721,3064,3,5473,'App\\Models\\Receipt',5473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',363.00,NULL,NULL,1,'2023-11-16 22:28:16','2023-11-16 22:28:16',NULL),(5713,7485,40721,3064,3,5474,'App\\Models\\Receipt',5474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',363.00,NULL,NULL,1,'2023-11-16 22:28:39','2023-11-16 22:28:39',NULL),(5714,7485,40721,3064,3,5475,'App\\Models\\Receipt',5475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',1089.00,NULL,NULL,1,'2023-11-16 22:29:17','2023-11-16 22:29:17',NULL),(5715,7485,40721,3064,3,5476,'App\\Models\\Receipt',5476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',16635.00,NULL,NULL,1,'2023-11-16 22:30:15','2023-11-16 22:36:53','2023-11-16 22:36:53'),(5716,7485,40721,3064,3,5477,'App\\Models\\Receipt',5477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',363.00,NULL,NULL,1,'2023-11-16 22:30:50','2023-11-16 22:30:50',NULL),(5717,7485,40721,3064,3,5478,'App\\Models\\Receipt',5478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',1452.00,NULL,NULL,1,'2023-11-16 22:32:14','2023-11-16 22:32:14',NULL),(5718,7485,40721,3064,3,5479,'App\\Models\\Receipt',5479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',363.00,NULL,NULL,1,'2023-11-16 22:33:05','2023-11-16 22:33:05',NULL),(5719,7485,40721,3064,3,5480,'App\\Models\\Receipt',5480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1815.00,NULL,NULL,1,'2023-11-16 22:33:31','2023-11-16 22:33:31',NULL),(5720,7485,40721,3064,3,5476,'App\\Models\\Receipt',5476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',15861.00,NULL,NULL,1,'2023-11-16 22:36:53','2023-11-16 22:36:53',NULL),(5721,7485,40720,1564,3,5481,'App\\Models\\Receipt',5481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',35120.00,NULL,NULL,1,'2023-11-17 21:45:03','2023-11-17 21:52:12','2023-11-17 21:52:12'),(5722,7485,40720,1564,3,5482,'App\\Models\\Receipt',5482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',35911.55,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:52:06','2023-11-17 21:52:06'),(5723,7485,40720,1564,3,5483,'App\\Models\\Receipt',5483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',98500.00,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:52:01','2023-11-17 21:52:01');
INSERT INTO `balance_libro` VALUES (5724,7485,40720,1564,3,5484,'App\\Models\\Receipt',5484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',55415.69,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:51:57','2023-11-17 21:51:57'),(5725,7485,40720,1564,3,5485,'App\\Models\\Receipt',5485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',29538.15,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:51:52','2023-11-17 21:51:52'),(5726,7485,40720,1564,3,5486,'App\\Models\\Receipt',5486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',213000.00,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:51:47','2023-11-17 21:51:47'),(5727,7485,40720,1564,3,5487,'App\\Models\\Receipt',5487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',213000.00,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:51:43','2023-11-17 21:51:43'),(5728,7485,40720,1564,3,5488,'App\\Models\\Receipt',5488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',13400.10,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:51:39','2023-11-17 21:51:39'),(5729,7485,40720,1564,3,5489,'App\\Models\\Receipt',5489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',34360.00,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:51:35','2023-11-17 21:51:35'),(5730,7485,40720,1564,3,5490,'App\\Models\\Receipt',5490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',69600.02,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:51:23','2023-11-17 21:51:23'),(5731,7485,40720,1564,3,5491,'App\\Models\\Receipt',5491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',306500.15,NULL,NULL,1,'2023-11-17 21:45:04','2023-11-17 21:51:18','2023-11-17 21:51:18'),(5732,7485,40720,1564,3,5492,'App\\Models\\Receipt',5492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',359300.22,NULL,NULL,1,'2023-11-17 21:45:05','2023-11-17 21:51:13','2023-11-17 21:51:13'),(5733,7485,40720,1564,3,5493,'App\\Models\\Receipt',5493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',228000.00,NULL,NULL,1,'2023-11-17 21:45:05','2023-11-17 21:51:09','2023-11-17 21:51:09'),(5734,7485,40720,1564,3,5494,'App\\Models\\Receipt',5494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',228000.00,NULL,NULL,1,'2023-11-17 21:45:05','2023-11-17 21:51:04','2023-11-17 21:51:04'),(5735,7485,40720,1564,3,5495,'App\\Models\\Receipt',5495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',55415.69,NULL,NULL,1,'2023-11-17 21:45:05','2023-11-17 21:50:58','2023-11-17 21:50:58'),(5736,7485,40720,1564,2,5496,'App\\Models\\Receipt',5496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',870000.06,NULL,NULL,1,'2023-11-17 21:45:19','2023-11-23 18:52:59','2023-11-23 18:52:59'),(5737,7485,40720,1564,2,5497,'App\\Models\\Receipt',5497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',40700.04,NULL,NULL,1,'2023-11-17 21:45:19','2023-11-23 18:52:59','2023-11-23 18:52:59'),(5738,7485,40720,1564,2,5498,'App\\Models\\Receipt',5498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',40000.02,NULL,NULL,1,'2023-11-17 21:45:19','2023-11-23 18:52:59','2023-11-23 18:52:59'),(5739,7485,40720,1564,3,5499,'App\\Models\\Receipt',5499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',35120.00,NULL,NULL,1,'2023-11-17 21:52:46','2023-11-23 18:53:11','2023-11-23 18:53:11'),(5740,7485,40720,1564,3,5500,'App\\Models\\Receipt',5500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',35911.55,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:11','2023-11-23 18:53:11'),(5741,7485,40720,1564,3,5501,'App\\Models\\Receipt',5501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',98500.00,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:11','2023-11-23 18:53:11'),(5742,7485,40720,1564,3,5502,'App\\Models\\Receipt',5502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',55415.69,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:11','2023-11-23 18:53:11');
INSERT INTO `balance_libro` VALUES (5743,7485,40720,1564,3,5503,'App\\Models\\Receipt',5503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',29538.15,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:11','2023-11-23 18:53:11'),(5744,7485,40720,1564,3,5504,'App\\Models\\Receipt',5504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',213000.00,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:11','2023-11-23 18:53:11'),(5745,7485,40720,1564,3,5505,'App\\Models\\Receipt',5505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',213000.00,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:11','2023-11-23 18:53:11'),(5746,7485,40720,1564,3,5506,'App\\Models\\Receipt',5506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',13400.10,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:12','2023-11-23 18:53:12'),(5747,7485,40720,1564,3,5507,'App\\Models\\Receipt',5507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',34360.00,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:12','2023-11-23 18:53:12'),(5748,7485,40720,1564,3,5508,'App\\Models\\Receipt',5508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',69600.02,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:12','2023-11-23 18:53:12'),(5749,7485,40720,1564,3,5509,'App\\Models\\Receipt',5509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',306500.15,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:12','2023-11-23 18:53:12'),(5750,7485,40720,1564,3,5510,'App\\Models\\Receipt',5510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',359300.22,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:12','2023-11-23 18:53:12'),(5751,7485,40720,1564,3,5511,'App\\Models\\Receipt',5511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',228000.00,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:12','2023-11-23 18:53:12'),(5752,7485,40720,1564,3,5512,'App\\Models\\Receipt',5512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',228000.00,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:12','2023-11-23 18:53:12'),(5753,7485,40720,1564,3,5513,'App\\Models\\Receipt',5513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',55415.69,NULL,NULL,1,'2023-11-17 21:52:47','2023-11-23 18:53:12','2023-11-23 18:53:12'),(5754,7485,40720,1564,3,5514,'App\\Models\\Receipt',5514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',6748.50,NULL,NULL,1,'2023-11-19 18:00:44','2023-11-23 18:53:12','2023-11-23 18:53:12'),(5755,9756,40720,1560,23,5755,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',70585023.78,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-11-23 19:38:20','2024-01-06 06:49:02','2024-01-06 06:49:02'),(5756,7485,40828,7779,3,5515,'App\\Models\\Receipt',5515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',4399.91,NULL,NULL,1,'2023-12-08 15:46:33','2023-12-08 15:46:33',NULL),(5757,7485,40828,7779,3,5516,'App\\Models\\Receipt',5516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',30364.55,NULL,NULL,1,'2023-12-08 15:46:33','2023-12-08 15:46:33',NULL),(5758,7485,40828,7779,3,5517,'App\\Models\\Receipt',5517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',179503.73,NULL,NULL,1,'2023-12-08 15:46:33','2023-12-08 15:46:33',NULL),(5759,7485,40828,7779,3,5518,'App\\Models\\Receipt',5518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',9620.24,NULL,NULL,1,'2023-12-08 15:46:34','2023-12-08 15:46:34',NULL),(5760,7485,40828,7779,3,5519,'App\\Models\\Receipt',5519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',340000.00,NULL,NULL,1,'2023-12-08 15:46:34','2023-12-08 15:46:34',NULL),(5761,7485,40828,7779,3,5520,'App\\Models\\Receipt',5520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',255515.99,NULL,NULL,1,'2023-12-08 15:46:34','2023-12-08 15:46:34',NULL);
INSERT INTO `balance_libro` VALUES (5763,7485,40828,7779,2,5522,'App\\Models\\Receipt',5522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',210000.00,NULL,NULL,1,'2023-12-08 15:49:03','2023-12-08 15:49:03',NULL),(5764,7485,40828,7779,2,5523,'App\\Models\\Receipt',5523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',46000.00,NULL,NULL,1,'2023-12-08 15:49:03','2023-12-08 15:49:03',NULL),(5765,7485,40828,7779,2,5524,'App\\Models\\Receipt',5524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',246540.00,NULL,NULL,1,'2023-12-08 15:49:03','2023-12-08 15:49:03',NULL),(5766,7485,40828,7779,2,5525,'App\\Models\\Receipt',5525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',325700.04,NULL,NULL,1,'2023-12-08 15:49:03','2023-12-08 15:49:03',NULL),(5767,7485,40828,7779,2,5526,'App\\Models\\Receipt',5526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',35990.02,NULL,NULL,1,'2023-12-08 15:49:03','2023-12-08 15:49:03',NULL),(5768,7485,40828,7779,2,5527,'App\\Models\\Receipt',5527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',320500.04,NULL,NULL,1,'2023-12-08 15:49:03','2023-12-08 15:49:03',NULL),(5769,7485,40723,6074,3,5528,'App\\Models\\Receipt',5528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',1923.21,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5770,7485,40723,6074,3,5529,'App\\Models\\Receipt',5529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',15.63,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5771,7485,40723,6074,3,5530,'App\\Models\\Receipt',5530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',209.00,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5772,7485,40723,6074,3,5531,'App\\Models\\Receipt',5531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',60.00,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5773,7485,40723,6074,3,5532,'App\\Models\\Receipt',5532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',108.00,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5774,7485,40723,6074,3,5533,'App\\Models\\Receipt',5533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',51.43,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5775,7485,40723,6074,3,5534,'App\\Models\\Receipt',5534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',33.90,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5776,7485,40723,6074,3,5535,'App\\Models\\Receipt',5535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',137.37,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5777,7485,40723,6074,3,5536,'App\\Models\\Receipt',5536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11.00,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5778,7485,40723,6074,3,5537,'App\\Models\\Receipt',5537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11.00,NULL,NULL,1,'2023-12-21 20:27:08','2023-12-21 20:27:08',NULL),(5779,7485,40723,6074,3,5538,'App\\Models\\Receipt',5538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',8.20,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5780,7485,40723,6074,3,5539,'App\\Models\\Receipt',5539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',699.00,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5781,7485,40723,6074,3,5540,'App\\Models\\Receipt',5540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',1764.46,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5782,7485,40723,6074,3,5541,'App\\Models\\Receipt',5541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',11.00,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5783,7485,40723,6074,3,5542,'App\\Models\\Receipt',5542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',11.00,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL);
INSERT INTO `balance_libro` VALUES (5784,7485,40723,6074,3,5543,'App\\Models\\Receipt',5543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',915.06,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5785,7485,40723,6074,3,5544,'App\\Models\\Receipt',5544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',27.30,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5786,7485,40723,6074,3,5545,'App\\Models\\Receipt',5545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',1.55,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5787,7485,40723,6074,3,5546,'App\\Models\\Receipt',5546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',350.00,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5788,7485,40723,6074,3,5547,'App\\Models\\Receipt',5547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',23.10,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5789,7485,40723,6074,3,5548,'App\\Models\\Receipt',5548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',1891.39,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5790,7485,40723,6074,3,5549,'App\\Models\\Receipt',5549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',859.13,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5791,7485,40723,6074,3,5550,'App\\Models\\Receipt',5550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',19.95,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5792,7485,40723,6074,3,5551,'App\\Models\\Receipt',5551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',38.50,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5793,7485,40723,6074,3,5552,'App\\Models\\Receipt',5552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1840.76,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5794,7485,40723,6074,3,5553,'App\\Models\\Receipt',5553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',810.92,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5795,7485,40723,6074,3,5554,'App\\Models\\Receipt',5554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',364.59,NULL,NULL,1,'2023-12-21 20:27:09','2023-12-21 20:27:09',NULL),(5796,7485,40723,6074,3,5555,'App\\Models\\Receipt',5555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',2525.01,NULL,NULL,1,'2023-12-21 20:27:10','2023-12-21 20:27:10',NULL),(5797,7485,40723,6074,3,5556,'App\\Models\\Receipt',5556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1223.06,NULL,NULL,1,'2023-12-21 20:27:10','2023-12-21 20:27:10',NULL),(5798,7485,40723,6074,3,5557,'App\\Models\\Receipt',5557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2177.59,NULL,NULL,1,'2023-12-21 20:27:10','2023-12-21 20:27:10',NULL),(5799,7485,40723,6074,3,5558,'App\\Models\\Receipt',5558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1223.06,NULL,NULL,1,'2023-12-21 20:27:10','2023-12-21 20:27:10',NULL),(5800,7485,40723,6074,3,5559,'App\\Models\\Receipt',5559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',200.00,NULL,NULL,1,'2023-12-21 20:27:10','2023-12-21 20:27:10',NULL),(5801,7485,40723,6074,3,5560,'App\\Models\\Receipt',5560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3.20,NULL,NULL,1,'2023-12-21 20:27:10','2023-12-21 20:27:10',NULL),(5802,7485,40723,6074,2,5561,'App\\Models\\Receipt',5561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',653.01,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5803,7485,40723,6074,2,5562,'App\\Models\\Receipt',5562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',115.81,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5804,7485,40723,6074,2,5563,'App\\Models\\Receipt',5563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',255.69,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL);
INSERT INTO `balance_libro` VALUES (5805,7485,40723,6074,2,5564,'App\\Models\\Receipt',5564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',14.81,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5806,7485,40723,6074,2,5565,'App\\Models\\Receipt',5565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',353.32,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5807,7485,40723,6074,2,5566,'App\\Models\\Receipt',5566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',395.21,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5808,7485,40723,6074,2,5567,'App\\Models\\Receipt',5567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',454.03,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5809,7485,40723,6074,2,5568,'App\\Models\\Receipt',5568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',1075.12,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5810,7485,40723,6074,2,5569,'App\\Models\\Receipt',5569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',653.01,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5811,7485,40723,6074,2,5570,'App\\Models\\Receipt',5570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',7.78,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5812,7485,40723,6074,2,5571,'App\\Models\\Receipt',5571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',1075.12,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5813,7485,40723,6074,2,5572,'App\\Models\\Receipt',5572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',13.27,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5814,7485,40723,6074,2,5573,'App\\Models\\Receipt',5573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',27.00,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5815,7485,40723,6074,2,5574,'App\\Models\\Receipt',5574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',30.29,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5816,7485,40723,6074,2,5575,'App\\Models\\Receipt',5575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',1690.98,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5817,7485,40723,6074,2,5576,'App\\Models\\Receipt',5576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',1165.25,NULL,NULL,1,'2023-12-21 20:27:23','2023-12-21 20:27:23',NULL),(5818,7485,40723,6074,2,5577,'App\\Models\\Receipt',5577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',19.43,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5819,7485,40723,6074,2,5578,'App\\Models\\Receipt',5578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',1937.25,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5820,7485,40723,6074,2,5579,'App\\Models\\Receipt',5579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',12.74,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5821,7485,40723,6074,2,5580,'App\\Models\\Receipt',5580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',16.67,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5822,7485,40723,6074,2,5581,'App\\Models\\Receipt',5581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',22.32,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5823,7485,40723,6074,2,5582,'App\\Models\\Receipt',5582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',25.76,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5824,7485,40723,6074,2,5583,'App\\Models\\Receipt',5583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',39.98,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5825,7485,40723,6074,2,5584,'App\\Models\\Receipt',5584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',101.58,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL);
INSERT INTO `balance_libro` VALUES (5826,7485,40723,6074,2,5585,'App\\Models\\Receipt',5585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2219.71,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5827,7485,40723,6074,2,5586,'App\\Models\\Receipt',5586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',1780.01,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5828,7485,40723,6074,2,5587,'App\\Models\\Receipt',5587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',493.22,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5829,7485,40723,6074,2,5588,'App\\Models\\Receipt',5588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',2219.71,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5830,7485,40723,6074,2,5589,'App\\Models\\Receipt',5589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',25.76,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5831,7485,40723,6074,2,5590,'App\\Models\\Receipt',5590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',17.63,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5832,7485,40723,6074,2,5591,'App\\Models\\Receipt',5591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',20.03,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5833,7485,40723,6074,2,5592,'App\\Models\\Receipt',5592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',8.44,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5834,7485,40723,6074,2,5593,'App\\Models\\Receipt',5593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',1603.73,NULL,NULL,1,'2023-12-21 20:27:24','2023-12-21 20:27:24',NULL),(5835,7485,40723,6074,2,5594,'App\\Models\\Receipt',5594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',61.77,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5836,7485,40723,6074,2,5595,'App\\Models\\Receipt',5595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',12.20,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5837,7485,40723,6074,2,5596,'App\\Models\\Receipt',5596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',8.08,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5838,7485,40723,6074,2,5597,'App\\Models\\Receipt',5597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',22.09,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5839,7485,40723,6074,2,5598,'App\\Models\\Receipt',5598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',436.48,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5840,7485,40723,6074,2,5599,'App\\Models\\Receipt',5599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',10.18,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5841,7485,40723,6074,2,5600,'App\\Models\\Receipt',5600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',55.67,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5842,7485,40723,6074,2,5601,'App\\Models\\Receipt',5601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',1523.76,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5843,7485,40723,6074,2,5602,'App\\Models\\Receipt',5602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',605.07,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5844,7485,40723,6074,2,5603,'App\\Models\\Receipt',5603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',474.47,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5845,7485,40723,6074,2,5604,'App\\Models\\Receipt',5604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',432.13,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5846,7485,40723,6074,2,5605,'App\\Models\\Receipt',5605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',734.70,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL);
INSERT INTO `balance_libro` VALUES (5847,7485,40723,6074,2,5606,'App\\Models\\Receipt',5606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',1696.58,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5848,7485,40723,6074,2,5607,'App\\Models\\Receipt',5607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',14.17,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5849,7485,40723,6074,2,5608,'App\\Models\\Receipt',5608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',1837.07,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5850,7485,40723,6074,2,5609,'App\\Models\\Receipt',5609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',30.59,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5851,7485,40723,6074,2,5610,'App\\Models\\Receipt',5610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',10.47,NULL,NULL,1,'2023-12-21 20:27:25','2023-12-21 20:27:25',NULL),(5852,7485,40723,6074,2,5611,'App\\Models\\Receipt',5611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',22.03,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5853,7485,40723,6074,2,5612,'App\\Models\\Receipt',5612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1011.56,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5854,7485,40723,6074,2,5613,'App\\Models\\Receipt',5613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',6.50,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5855,7485,40723,6074,2,5614,'App\\Models\\Receipt',5614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1985.13,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5856,7485,40723,6074,2,5615,'App\\Models\\Receipt',5615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',40.05,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5857,7485,40723,6074,2,5616,'App\\Models\\Receipt',5616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',10.05,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5858,7485,40723,6074,2,5617,'App\\Models\\Receipt',5617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',2308.69,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5859,7485,40723,6074,2,5618,'App\\Models\\Receipt',5618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1709.47,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5860,7485,40723,6074,2,5619,'App\\Models\\Receipt',5619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',803.93,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5861,7485,40723,6074,2,5620,'App\\Models\\Receipt',5620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',5.77,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5862,7485,40723,6074,2,5621,'App\\Models\\Receipt',5621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',37.25,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5863,7485,40723,6074,2,5622,'App\\Models\\Receipt',5622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',23.57,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5864,7485,40723,6074,2,5623,'App\\Models\\Receipt',5623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',496.95,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5865,7485,40723,6074,2,5624,'App\\Models\\Receipt',5624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',34.08,NULL,NULL,1,'2023-12-21 20:27:26','2023-12-21 20:27:26',NULL),(5866,7485,40720,1565,3,5625,'App\\Models\\Receipt',5625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',35120.00,NULL,NULL,1,'2023-12-25 15:20:34','2023-12-25 15:20:34',NULL),(5867,7485,40720,1565,3,5626,'App\\Models\\Receipt',5626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',37567.62,NULL,NULL,1,'2023-12-25 15:20:34','2023-12-25 15:20:34',NULL);
INSERT INTO `balance_libro` VALUES (5868,7485,40720,1565,3,5627,'App\\Models\\Receipt',5627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',34255.55,NULL,NULL,1,'2023-12-25 15:20:34','2023-12-25 15:20:34',NULL),(5869,7485,40720,1565,3,5628,'App\\Models\\Receipt',5628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',14511.42,NULL,NULL,1,'2023-12-25 15:20:34','2023-12-25 15:20:34',NULL),(5870,7485,40720,1565,3,5629,'App\\Models\\Receipt',5629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',101300.00,NULL,NULL,1,'2023-12-25 15:20:34','2023-12-25 15:20:34',NULL),(5871,7485,40720,1565,2,5630,'App\\Models\\Receipt',5630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',23334.00,NULL,NULL,1,'2023-12-25 15:20:43','2023-12-25 15:20:43',NULL),(5872,7485,40720,1565,2,5631,'App\\Models\\Receipt',5631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',222000.00,NULL,NULL,1,'2023-12-25 15:20:43','2023-12-25 15:20:43',NULL),(5873,7485,40720,1565,2,5632,'App\\Models\\Receipt',5632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',145000.00,NULL,NULL,1,'2023-12-25 15:20:43','2023-12-25 15:20:43',NULL),(5874,7485,40720,1565,2,5633,'App\\Models\\Receipt',5633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',1160000.00,NULL,NULL,1,'2023-12-25 15:20:43','2023-12-25 15:20:43',NULL),(5875,7485,40720,1565,3,5634,'App\\Models\\Receipt',5634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',15285.94,NULL,NULL,1,'2023-12-25 15:25:01','2023-12-25 15:25:01',NULL),(5876,7485,40720,1565,3,5635,'App\\Models\\Receipt',5635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',726.00,NULL,NULL,1,'2023-12-25 15:27:04','2023-12-25 15:27:04',NULL),(5877,7485,40720,1565,3,5636,'App\\Models\\Receipt',5636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',21188.25,NULL,NULL,1,'2023-12-25 15:29:15','2023-12-25 15:29:15',NULL),(5878,7485,40720,1565,3,5637,'App\\Models\\Receipt',5637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',363.00,NULL,NULL,1,'2023-12-25 15:30:07','2023-12-25 15:30:07',NULL),(5879,7485,40721,3065,3,5638,'App\\Models\\Receipt',5638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',123274.07,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5880,7485,40721,3065,3,5639,'App\\Models\\Receipt',5639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',480625.17,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5881,7485,40721,3065,3,5640,'App\\Models\\Receipt',5640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2082140.77,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5882,7485,40721,3065,3,5641,'App\\Models\\Receipt',5641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',7500.00,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5883,7485,40721,3065,3,5642,'App\\Models\\Receipt',5642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',806500.78,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5884,7485,40721,3065,3,5643,'App\\Models\\Receipt',5643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',254000.05,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5885,7485,40721,3065,3,5644,'App\\Models\\Receipt',5644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',178000.00,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5886,7485,40721,3065,3,5645,'App\\Models\\Receipt',5645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',65000.00,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5887,7485,40721,3065,3,5646,'App\\Models\\Receipt',5646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',43300.00,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5888,7485,40721,3065,3,5647,'App\\Models\\Receipt',5647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',816.75,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL);
INSERT INTO `balance_libro` VALUES (5889,7485,40721,3065,3,5648,'App\\Models\\Receipt',5648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',363.00,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5890,7485,40721,3065,3,5649,'App\\Models\\Receipt',5649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',363.00,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5891,7485,40721,3065,3,5650,'App\\Models\\Receipt',5650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',726.00,NULL,NULL,1,'2023-12-27 13:03:35','2023-12-27 13:03:35',NULL),(5892,7485,40721,3065,3,5651,'App\\Models\\Receipt',5651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',363.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5893,7485,40721,3065,3,5652,'App\\Models\\Receipt',5652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',363.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5894,7485,40721,3065,3,5653,'App\\Models\\Receipt',5653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',363.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5895,7485,40721,3065,3,5654,'App\\Models\\Receipt',5654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',363.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5896,7485,40721,3065,3,5655,'App\\Models\\Receipt',5655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',363.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5897,7485,40721,3065,3,5656,'App\\Models\\Receipt',5656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',363.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5898,7485,40721,3065,3,5657,'App\\Models\\Receipt',5657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',363.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5899,7485,40721,3065,3,5658,'App\\Models\\Receipt',5658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',1815.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5900,7485,40721,3065,3,5659,'App\\Models\\Receipt',5659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',1815.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5901,7485,40721,3065,3,5660,'App\\Models\\Receipt',5660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',363.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5902,7485,40721,3065,3,5661,'App\\Models\\Receipt',5661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',363.00,NULL,NULL,1,'2023-12-27 13:03:36','2023-12-27 13:03:36',NULL),(5914,7485,40721,3065,2,5673,'App\\Models\\Receipt',5673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',40700.04,NULL,NULL,1,'2023-12-27 13:04:57','2023-12-27 13:04:57',NULL),(5915,7485,40721,3065,2,5674,'App\\Models\\Receipt',5674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',250000.00,NULL,NULL,1,'2023-12-27 13:04:57','2023-12-27 13:04:57',NULL),(5916,7485,40721,3065,2,5675,'App\\Models\\Receipt',5675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',210000.00,NULL,NULL,1,'2023-12-27 13:04:57','2023-12-27 13:04:57',NULL),(5917,7485,40721,3065,2,5676,'App\\Models\\Receipt',5676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',600000.00,NULL,NULL,1,'2023-12-27 13:04:57','2023-12-27 13:04:57',NULL),(5918,7485,40721,3065,2,5677,'App\\Models\\Receipt',5677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',555000.00,NULL,NULL,1,'2023-12-27 13:04:57','2023-12-27 13:04:57',NULL),(5919,7485,40721,3065,2,5678,'App\\Models\\Receipt',5678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',66477.00,NULL,NULL,1,'2023-12-27 13:04:57','2023-12-27 13:04:57',NULL),(5920,7485,40721,3065,2,5679,'App\\Models\\Receipt',5679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',41625.00,NULL,NULL,1,'2023-12-27 13:04:57','2023-12-27 13:04:57',NULL);
INSERT INTO `balance_libro` VALUES (5921,7485,40721,3065,2,5680,'App\\Models\\Receipt',5680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',900000.04,NULL,NULL,1,'2023-12-27 13:04:58','2023-12-27 13:04:58',NULL),(5922,7485,40721,3065,2,5681,'App\\Models\\Receipt',5681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',40000.02,NULL,NULL,1,'2023-12-27 13:04:58','2023-12-27 13:04:58',NULL),(5923,7485,40721,3065,2,5682,'App\\Models\\Receipt',5682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',48900.04,NULL,NULL,1,'2023-12-27 13:04:58','2023-12-27 13:04:58',NULL),(5924,7485,40721,3065,2,5683,'App\\Models\\Receipt',5683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',94950.06,NULL,NULL,1,'2023-12-27 13:04:58','2023-12-27 13:04:58',NULL),(5925,7485,40721,3065,2,5684,'App\\Models\\Receipt',5684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',2000000.02,NULL,NULL,1,'2023-12-27 13:04:58','2023-12-27 13:04:58',NULL),(5926,7485,40721,3065,2,5685,'App\\Models\\Receipt',5685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',900000.04,NULL,NULL,1,'2023-12-27 13:04:58','2023-12-27 13:04:58',NULL),(5927,7485,40721,3065,2,5686,'App\\Models\\Receipt',5686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',500000.00,NULL,NULL,1,'2023-12-27 13:04:58','2023-12-27 13:04:58',NULL),(5928,7485,40721,3065,2,5687,'App\\Models\\Receipt',5687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1080000.04,NULL,NULL,1,'2023-12-27 13:04:58','2023-12-27 13:04:58',NULL),(5929,7485,40828,7780,3,5688,'App\\Models\\Receipt',5688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',162811.20,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5930,7485,40828,7780,3,5689,'App\\Models\\Receipt',5689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',4699.89,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5931,7485,40828,7780,3,5690,'App\\Models\\Receipt',5690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',145289.00,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5932,7485,40828,7780,3,5691,'App\\Models\\Receipt',5691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',242304.60,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5933,7485,40828,7780,3,5692,'App\\Models\\Receipt',5692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',31655.68,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5934,7485,40828,7780,3,5693,'App\\Models\\Receipt',5693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',432224.10,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5935,7485,40828,7780,3,5694,'App\\Models\\Receipt',5694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',15695.00,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5936,7485,40828,7780,3,5695,'App\\Models\\Receipt',5695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',206568.78,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5937,7485,40828,7780,3,5696,'App\\Models\\Receipt',5696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',8140.56,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5938,7485,40828,7780,3,5697,'App\\Models\\Receipt',5697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',11350.13,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5939,7485,40828,7780,3,5698,'App\\Models\\Receipt',5698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',218410.52,NULL,NULL,1,'2024-01-01 19:47:23','2024-01-01 19:47:23',NULL),(5944,7485,40828,7780,2,5703,'App\\Models\\Receipt',5703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',350000.00,NULL,NULL,1,'2024-01-01 19:50:37','2024-01-01 19:50:37',NULL),(5945,7485,40828,7780,2,5704,'App\\Models\\Receipt',5704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',570390.04,NULL,NULL,1,'2024-01-01 19:50:37','2024-01-01 19:50:37',NULL);
INSERT INTO `balance_libro` VALUES (5946,7485,40828,7780,2,5705,'App\\Models\\Receipt',5705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',46300.04,NULL,NULL,1,'2024-01-01 19:50:37','2024-01-01 19:50:37',NULL),(5947,7485,40828,7780,2,5706,'App\\Models\\Receipt',5706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',300180.06,NULL,NULL,1,'2024-01-01 19:50:37','2024-01-01 19:50:37',NULL),(5948,7485,40723,6075,3,5707,'App\\Models\\Receipt',5707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',616885.30,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5949,7485,40723,6075,3,5708,'App\\Models\\Receipt',5708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',12701.00,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5950,7485,40723,6075,3,5709,'App\\Models\\Receipt',5709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',73277.65,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5951,7485,40723,6075,3,5710,'App\\Models\\Receipt',5710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',9460239.22,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5952,7485,40723,6075,3,5711,'App\\Models\\Receipt',5711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',251350.00,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5953,7485,40723,6075,3,5712,'App\\Models\\Receipt',5712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',12742.57,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5954,7485,40723,6075,3,5713,'App\\Models\\Receipt',5713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',99999.00,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5955,7485,40723,6075,3,5714,'App\\Models\\Receipt',5714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',63895.54,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5956,7485,40723,6075,3,5715,'App\\Models\\Receipt',5715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',5742.56,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5957,7485,40723,6075,3,5716,'App\\Models\\Receipt',5716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',67100.00,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5958,7485,40723,6075,3,5717,'App\\Models\\Receipt',5717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',15990.00,NULL,NULL,1,'2024-01-03 18:30:48','2024-01-03 18:30:48',NULL),(5959,7485,40723,6075,3,5718,'App\\Models\\Receipt',5718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',14470.10,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5960,7485,40723,6075,3,5719,'App\\Models\\Receipt',5719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',64462.81,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5961,7485,40723,6075,3,5720,'App\\Models\\Receipt',5720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',1110481.33,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5962,7485,40723,6075,3,5721,'App\\Models\\Receipt',5721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',23998.03,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5963,7485,40723,6075,3,5722,'App\\Models\\Receipt',5722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',2950.00,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5964,7485,40723,6075,3,5723,'App\\Models\\Receipt',5723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',4000.00,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5965,7485,40723,6075,3,5724,'App\\Models\\Receipt',5724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',17980.12,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5966,7485,40723,6075,3,5725,'App\\Models\\Receipt',5725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',10132.40,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL);
INSERT INTO `balance_libro` VALUES (5967,7485,40723,6075,3,5726,'App\\Models\\Receipt',5726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',107400.00,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5968,7485,40723,6075,3,5727,'App\\Models\\Receipt',5727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',38116.98,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5969,7485,40723,6075,3,5728,'App\\Models\\Receipt',5728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',25269.00,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5970,7485,40723,6075,3,5729,'App\\Models\\Receipt',5729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',11645.00,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5971,7485,40723,6075,3,5730,'App\\Models\\Receipt',5730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',11645.00,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5972,7485,40723,6075,3,5731,'App\\Models\\Receipt',5731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',11645.00,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5973,7485,40723,6075,3,5732,'App\\Models\\Receipt',5732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',782049.07,NULL,NULL,1,'2024-01-03 18:30:49','2024-01-03 18:30:49',NULL),(5974,7485,40723,6075,3,5733,'App\\Models\\Receipt',5733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',32046.20,NULL,NULL,1,'2024-01-03 18:30:50','2024-01-03 18:30:50',NULL),(5975,7485,40723,6075,3,5734,'App\\Models\\Receipt',5734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',414615.82,NULL,NULL,1,'2024-01-03 18:30:50','2024-01-03 18:30:50',NULL),(5976,7485,40723,6075,3,5735,'App\\Models\\Receipt',5735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',7706.59,NULL,NULL,1,'2024-01-03 18:30:50','2024-01-03 18:30:50',NULL),(5977,7485,40723,6075,3,5736,'App\\Models\\Receipt',5736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',2300.00,NULL,NULL,1,'2024-01-03 18:30:50','2024-01-03 18:30:50',NULL),(6034,7485,40723,6075,2,5793,'App\\Models\\Receipt',5793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',11518260.58,NULL,NULL,1,'2024-01-03 18:33:13','2024-01-03 18:33:13',NULL),(6035,7485,40723,6075,2,5794,'App\\Models\\Receipt',5794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',85652.23,NULL,NULL,1,'2024-01-03 18:33:13','2024-01-03 18:33:13',NULL),(6036,7485,40723,6075,2,5795,'App\\Models\\Receipt',5795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',5161.82,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6037,7485,40723,6075,2,5796,'App\\Models\\Receipt',5796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',47852.56,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6038,7485,40723,6075,2,5797,'App\\Models\\Receipt',5797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',96024.05,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6039,7485,40723,6075,2,5798,'App\\Models\\Receipt',5798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',16391.77,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6040,7485,40723,6075,2,5799,'App\\Models\\Receipt',5799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',7902.41,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6041,7485,40723,6075,2,5800,'App\\Models\\Receipt',5800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',2628.19,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6042,7485,40723,6075,2,5801,'App\\Models\\Receipt',5801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',1407.07,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6043,7485,40723,6075,2,5802,'App\\Models\\Receipt',5802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',467265.47,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL);
INSERT INTO `balance_libro` VALUES (6044,7485,40723,6075,2,5803,'App\\Models\\Receipt',5803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',54665.98,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6045,7485,40723,6075,2,5804,'App\\Models\\Receipt',5804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',8472.60,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6046,7485,40723,6075,2,5805,'App\\Models\\Receipt',5805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',7881.38,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6047,7485,40723,6075,2,5806,'App\\Models\\Receipt',5806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',2510.06,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6048,7485,40723,6075,2,5807,'App\\Models\\Receipt',5807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',74971.73,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6049,7485,40723,6075,2,5808,'App\\Models\\Receipt',5808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',108832.07,NULL,NULL,1,'2024-01-03 18:33:14','2024-01-03 18:33:14',NULL),(6050,7485,40723,6075,2,5809,'App\\Models\\Receipt',5809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',2510.06,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6051,7485,40723,6075,2,5810,'App\\Models\\Receipt',5810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',9480.14,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6052,7485,40723,6075,2,5811,'App\\Models\\Receipt',5811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',138212.65,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6053,7485,40723,6075,2,5812,'App\\Models\\Receipt',5812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',4792.98,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6054,7485,40723,6075,2,5813,'App\\Models\\Receipt',5813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',16179.45,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6055,7485,40723,6075,2,5814,'App\\Models\\Receipt',5814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',9697.42,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6056,7485,40723,6075,2,5815,'App\\Models\\Receipt',5815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',158710.86,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6057,7485,40723,6075,2,5816,'App\\Models\\Receipt',5816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',7026.13,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6058,7485,40723,6075,2,5817,'App\\Models\\Receipt',5817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',1923.15,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6059,7485,40723,6075,2,5818,'App\\Models\\Receipt',5818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',318592.03,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6060,7485,40723,6075,2,5819,'App\\Models\\Receipt',5819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',8961.84,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6061,7485,40723,6075,2,5820,'App\\Models\\Receipt',5820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',2688.40,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6062,7485,40723,6075,2,5821,'App\\Models\\Receipt',5821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',1894.17,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6063,7485,40723,6075,2,5822,'App\\Models\\Receipt',5822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',9662.37,NULL,NULL,1,'2024-01-03 18:33:15','2024-01-03 18:33:15',NULL),(6064,7485,40723,6075,2,5823,'App\\Models\\Receipt',5823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',643293.28,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL);
INSERT INTO `balance_libro` VALUES (6065,7485,40723,6075,2,5824,'App\\Models\\Receipt',5824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',4171.27,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6066,7485,40723,6075,2,5825,'App\\Models\\Receipt',5825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',3337.02,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6067,7485,40723,6075,2,5826,'App\\Models\\Receipt',5826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',5919.86,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6068,7485,40723,6075,2,5827,'App\\Models\\Receipt',5827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',10223.60,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6069,7485,40723,6075,2,5828,'App\\Models\\Receipt',5828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',3509.23,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6070,7485,40723,6075,2,5829,'App\\Models\\Receipt',5829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',127405.91,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6071,7485,40723,6075,2,5830,'App\\Models\\Receipt',5830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',29599.09,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6072,7485,40723,6075,2,5831,'App\\Models\\Receipt',5831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',3128233.03,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6073,7485,40723,6075,2,5832,'App\\Models\\Receipt',5832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',16043.01,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6074,7485,40723,6075,2,5833,'App\\Models\\Receipt',5833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',580572.94,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6075,7485,40723,6075,2,5834,'App\\Models\\Receipt',5834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',385303.59,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6076,7485,40723,6075,2,5835,'App\\Models\\Receipt',5835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',5899.23,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6077,7485,40723,6075,2,5836,'App\\Models\\Receipt',5836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',6496.85,NULL,NULL,1,'2024-01-03 18:33:16','2024-01-03 18:33:16',NULL),(6078,7485,40723,6075,2,5837,'App\\Models\\Receipt',5837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',26312.05,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6079,7485,40723,6075,2,5838,'App\\Models\\Receipt',5838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',9864.67,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6080,7485,40723,6075,2,5839,'App\\Models\\Receipt',5839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',54514.26,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6081,7485,40723,6075,2,5840,'App\\Models\\Receipt',5840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',10323.66,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6082,7485,40723,6075,2,5841,'App\\Models\\Receipt',5841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',5899.23,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6083,7485,40723,6075,2,5842,'App\\Models\\Receipt',5842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',17544.73,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6084,7485,40723,6075,2,5843,'App\\Models\\Receipt',5843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',1406082.37,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6085,7485,40723,6075,2,5844,'App\\Models\\Receipt',5844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',22714.31,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL);
INSERT INTO `balance_libro` VALUES (6086,7485,40723,6075,2,5845,'App\\Models\\Receipt',5845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',18747.47,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6087,7485,40723,6075,2,5846,'App\\Models\\Receipt',5846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',2161.14,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6088,7485,40723,6075,2,5847,'App\\Models\\Receipt',5847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',2727.00,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6089,7485,40723,6075,2,5848,'App\\Models\\Receipt',5848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',7006.62,NULL,NULL,1,'2024-01-03 18:33:17','2024-01-03 18:33:17',NULL),(6090,9756,40720,1546,12,6090,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',19152516.63,'ASIENTO  APERTURA',NULL,1,'2024-01-06 09:34:16','2024-01-06 09:46:23','2024-01-06 09:46:23'),(6091,9756,40720,1546,12,6091,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',19152516.63,'ASIENTO  APERTURA',NULL,1,'2024-01-06 09:46:23','2024-01-07 13:25:39','2024-01-07 13:25:39'),(6092,9756,40720,1547,3,6092,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6583554.61,'COMPRAS AGOSTO 2022',NULL,1,'2024-01-06 15:02:04','2024-01-06 15:14:19','2024-01-06 15:14:19'),(6093,9756,40720,1547,3,6093,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5497234.35,'COMPRAS JULIO 2022',NULL,1,'2024-01-06 15:12:13','2024-01-06 20:14:30','2024-01-06 20:14:30'),(6094,9756,40720,1547,3,6094,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6583554.61,'COMPRAS AGOSTO 2022',NULL,1,'2024-01-06 15:14:19','2024-01-06 15:15:47','2024-01-06 15:15:47'),(6095,9756,40720,1547,3,6095,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6583554.61,'COMPRAS AGOSTO 2022',NULL,1,'2024-01-06 15:15:47','2024-01-06 15:15:47',NULL),(6096,9756,40720,1548,3,6096,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7673283.81,'COMPRAS SEPTIEMBRE 2022',NULL,1,'2024-01-06 15:20:11','2024-01-06 15:20:11',NULL),(6097,9756,40720,1549,3,6097,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6297778.83,'COMPRAS OCTUBRE 2022',NULL,1,'2024-01-06 15:23:04','2024-01-06 15:58:32','2024-01-06 15:58:32'),(6098,9756,40720,1550,3,6098,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5922639.49,'COMPRAS NOVIEMBRE 2022',NULL,1,'2024-01-06 15:27:05','2024-01-06 15:27:05',NULL),(6099,9756,40720,1551,3,6099,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7081288.60,'COMPRAS DICIEMBRE 2022',NULL,1,'2024-01-06 15:31:09','2024-01-06 15:31:09',NULL),(6100,9756,40720,1555,3,6100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5900482.69,'COMPRAS ENERO 2023',NULL,1,'2024-01-06 15:35:21','2024-01-06 15:35:21',NULL),(6101,9756,40720,1556,3,6101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3479373.13,'COMPRAS FEBRERO 2023',NULL,1,'2024-01-06 15:36:59','2024-01-06 15:36:59',NULL),(6102,9756,40720,1557,3,6102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5403410.85,'COMPRAS MARZO 2023',NULL,1,'2024-01-06 15:39:31','2024-01-06 15:39:31',NULL),(6103,9756,40720,1558,3,6103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6635341.90,'COMPRAS ABRIL 2023',NULL,1,'2024-01-06 15:49:37','2024-01-06 15:49:37',NULL);
INSERT INTO `balance_libro` VALUES (6104,9756,40720,1559,3,6104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7098949.94,'COMPRAS MAYO 2023',NULL,1,'2024-01-06 15:52:11','2024-01-06 15:52:11',NULL),(6105,9756,40720,1560,3,6105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5396844.54,'COMPRAS JUNIO 2023',NULL,1,'2024-01-06 15:54:26','2024-01-06 19:39:33','2024-01-06 19:39:33'),(6106,9756,40720,1549,3,6106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6297778.83,'COMPRAS OCTUBRE 2022',NULL,1,'2024-01-06 15:58:32','2024-01-06 15:58:32',NULL),(6107,9756,40720,1547,2,6107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',7425003.08,'VENTAS AGOSTO 2022',NULL,1,'2024-01-06 18:36:23','2024-01-06 20:06:05','2024-01-06 20:06:05'),(6108,9756,40720,1546,15,6108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',13821.07,'AJUSTES IVA JULIO 2022',NULL,1,'2024-01-06 18:55:51','2024-01-06 18:55:51',NULL),(6109,9756,40720,1549,2,6109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2483978.04,'VENTAS OCTUBRE 2022',NULL,1,'2024-01-06 19:01:37','2024-01-06 19:01:37',NULL),(6110,9756,40720,1557,2,6110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4088828.07,'VENTAS MARZO 2023',NULL,1,'2024-01-06 19:02:13','2024-01-06 19:02:13',NULL),(6111,9756,40720,1558,2,6111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',17545271.98,'VENTAS ABRIL 2023',NULL,1,'2024-01-06 19:03:18','2024-01-06 19:03:18',NULL),(6112,9756,40720,1547,15,6112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1153807.55,'POSICION IVA JULIO 2022',NULL,1,'2024-01-06 19:17:26','2024-01-06 19:17:26',NULL),(6113,9756,40720,1556,15,6113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',665496.61,'POSICION IVA FEBRERO 2023',NULL,1,'2024-01-06 19:22:12','2024-01-06 19:22:12',NULL),(6114,9756,40720,1559,15,6114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1249081.72,'POSICION IVA MAYO 2023',NULL,1,'2024-01-06 19:24:07','2024-01-06 19:24:07',NULL),(6115,9756,40720,1559,15,6115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3045047.20,'POSICION IVA ABRIL 2023',NULL,1,'2024-01-06 19:25:01','2024-01-06 19:25:01',NULL),(6116,9756,40720,1560,15,6116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1617894.86,'POSICION IVA JUNIO 2023',NULL,1,'2024-01-06 19:26:37','2024-01-06 20:10:27','2024-01-06 20:10:27'),(6117,9756,40720,1560,3,6117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5396844.53,'COMPRAS JUNIO 2023',NULL,1,'2024-01-06 19:39:33','2024-01-06 20:18:19','2024-01-06 20:18:19'),(6118,9756,40720,1546,2,6118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6568491.30,'VENTAS JULIO 2022',NULL,1,'2024-01-06 19:50:07','2024-01-06 19:50:07',NULL),(6119,9756,40720,1547,2,6119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',7425003.08,'VENTAS AGOSTO 2022',NULL,1,'2024-01-06 20:06:05','2024-01-06 20:06:05',NULL),(6120,9756,40720,1560,15,6120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1617894.86,'POSICION IVA JUNIO 2023',NULL,1,'2024-01-06 20:10:27','2024-01-06 20:13:43','2024-01-06 20:13:43'),(6121,9756,40720,1560,15,6121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1617894.86,'POSICION IVA JUNIO 2023',NULL,1,'2024-01-06 20:13:43','2024-01-06 20:48:30','2024-01-06 20:48:30');
INSERT INTO `balance_libro` VALUES (6122,9756,40720,1547,3,6122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5497234.35,'COMPRAS JULIO 2022',NULL,1,'2024-01-06 20:14:30','2024-01-06 20:14:30',NULL),(6123,9756,40720,1560,3,6123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5396844.55,'COMPRAS JUNIO 2023',NULL,1,'2024-01-06 20:18:19','2024-01-06 20:44:40','2024-01-06 20:44:40'),(6124,9756,40720,1560,3,6124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5396844.55,'COMPRAS JUNIO 2023',NULL,1,'2024-01-06 20:44:40','2024-01-06 20:44:40',NULL),(6125,9756,40720,1560,15,6125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1617894.86,'POSICION IVA JUNIO 2023',NULL,1,'2024-01-06 20:48:30','2024-01-06 20:48:30',NULL),(6126,9756,40720,1560,19,6126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',32930.13,'Pago de impuesto a la ganancia',NULL,1,'2024-01-06 21:13:54','2024-01-06 21:13:54',NULL),(6127,9756,40720,1560,19,6127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1503.03,'Reclasificacion',NULL,1,'2024-01-06 21:16:16','2024-01-06 22:20:32','2024-01-06 22:20:32'),(6128,9756,40720,1546,16,6128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',436258.20,'PAGO IIBB JULIO 2022',NULL,1,'2024-01-06 21:50:51','2024-01-06 21:57:49','2024-01-06 21:57:49'),(6129,9756,40720,1546,16,6129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',436258.20,'PAGO IIBB JULIO 2022',NULL,1,'2024-01-06 21:57:49','2024-01-06 21:57:49',NULL),(6130,9756,40720,1547,16,6130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',189997.67,'PAGO IIBB AGOSTO 2022',NULL,1,'2024-01-06 21:58:36','2024-01-06 21:58:36',NULL),(6131,9756,40720,1548,16,6131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',214772.81,'PAGO IIBB SEPTIEMBRE 2022',NULL,1,'2024-01-06 21:59:17','2024-01-06 21:59:17',NULL),(6132,9756,40720,1549,16,6132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',261925.56,'PAGO IIBB OCTUBRE 2022',NULL,1,'2024-01-06 22:00:32','2024-01-06 22:00:32',NULL),(6133,9756,40720,1550,16,6133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',71850.60,'PAGO IIBB NOVIEMBRE 2022',NULL,1,'2024-01-06 22:01:20','2024-01-06 22:01:20',NULL),(6134,9756,40720,1551,16,6134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20011.85,'PAGO IIBB DICIEMBRE 2022',NULL,1,'2024-01-06 22:04:10','2024-01-06 22:04:10',NULL),(6135,9756,40720,1556,16,6135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',76709.45,'PAGO IIBB ENERO 2023',NULL,1,'2024-01-06 22:04:44','2024-01-06 22:04:44',NULL),(6136,9756,40720,1556,16,6136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',81557.06,'PAGO IIBB FEBRERO 2023',NULL,1,'2024-01-06 22:05:14','2024-01-06 22:05:14',NULL),(6137,9756,40720,1557,16,6137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',107747.07,'PAGO IIBB MARZO 2023',NULL,1,'2024-01-06 22:06:07','2024-01-06 22:06:07',NULL),(6138,9756,40720,1558,16,6138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',114892.69,'PAGO IIBB ABRIL 2023',NULL,1,'2024-01-06 22:06:53','2024-01-06 22:06:53',NULL),(6139,9756,40720,1559,16,6139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',493007.64,'PAGO IIBB MAYO 2023',NULL,1,'2024-01-06 22:07:42','2024-01-06 22:07:42',NULL);
INSERT INTO `balance_libro` VALUES (6140,9756,40720,1560,16,6140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',199116.31,'PAGO IIBB JUNIO 2023',NULL,1,'2024-01-06 22:08:19','2024-01-06 22:08:19',NULL),(6141,9756,40720,1550,2,6141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',931321.03,'VENTAS NOVIEMBRE 2022',NULL,1,'2024-01-06 22:17:24','2024-01-06 22:17:24',NULL),(6142,9756,40720,1560,19,6142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1503.03,'Reclasificacion',NULL,1,'2024-01-06 22:20:32','2024-01-06 22:21:53','2024-01-06 22:21:53'),(6143,9756,40720,1560,19,6143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10908.36,'Reclasificacion',NULL,1,'2024-01-06 22:21:53','2024-01-06 22:21:53',NULL),(6144,9756,40720,1560,4,6144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',16244.46,'Amortizacion del ejercicio',NULL,1,'2024-01-07 13:13:44','2024-01-07 13:13:44',NULL),(6145,9756,40720,1546,12,6145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',19152516.63,'ASIENTO  APERTURA',NULL,1,'2024-01-07 13:25:39','2024-01-07 13:25:39',NULL),(6146,9756,40720,1560,19,6146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',14815179.22,'CMV 2023',NULL,1,'2024-01-07 13:31:36','2024-01-07 13:31:36',NULL),(6147,9756,40720,1547,19,6147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6000000.00,'Retiro al 31/08',NULL,1,'2024-01-07 13:39:04','2024-01-07 13:39:04',NULL),(6148,9756,40720,1559,19,6148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',9600000.00,'Retiro al 31/05',NULL,1,'2024-01-07 13:50:34','2024-01-07 13:50:34',NULL),(6149,9756,40720,1560,23,6149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9023.39,'AXI Amortización acumulada',NULL,1,'2024-01-08 11:45:00','2024-01-08 11:59:05','2024-01-08 11:59:05'),(6150,9756,40720,1560,23,6150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',92506.73,'AXI Valor de origen',NULL,1,'2024-01-08 11:47:15','2024-01-08 11:54:46','2024-01-08 11:54:46'),(6151,9756,40720,1560,23,6151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9250.67,'AXI amortizacion del ejercicio',NULL,1,'2024-01-08 11:51:46','2024-01-08 11:53:21','2024-01-08 11:53:21'),(6152,9756,40720,1560,23,6152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9250.67,'AXI amortizacion del ejercicio',NULL,1,'2024-01-08 11:53:21','2024-01-08 11:56:01','2024-01-08 11:56:01'),(6153,9756,40720,1560,23,6153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',187753.87,'AXI Valor de origen',NULL,1,'2024-01-08 11:54:46','2024-01-08 11:54:46',NULL),(6154,9756,40720,1560,23,6154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',32600.32,'AXI amortizacion del ejercicio',NULL,1,'2024-01-08 11:56:01','2024-01-08 11:58:13','2024-01-08 11:58:13'),(6155,9756,40720,1560,23,6155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',16300.14,'AXI amortizacion del ejercicio',NULL,1,'2024-01-08 11:58:13','2024-01-08 12:10:46','2024-01-08 12:10:46'),(6156,9756,40720,1560,23,6156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',32600.31,'AXI Amortización acumulada',NULL,1,'2024-01-08 11:59:05','2024-01-08 12:08:36','2024-01-08 12:08:36');
INSERT INTO `balance_libro` VALUES (6157,9756,40720,1560,23,6157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',35075.54,'AXI Amortización acumulada',NULL,1,'2024-01-08 12:08:36','2024-01-08 12:08:36',NULL),(6158,9756,40720,1560,23,6158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',18775.38,'AXI amortizacion del ejercicio',NULL,1,'2024-01-08 12:10:46','2024-01-08 12:10:46',NULL),(6159,9756,40720,1560,23,6159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',18110121.78,'AXI CMV',NULL,1,'2024-01-08 12:20:30','2024-01-08 12:20:30',NULL),(6160,9756,40720,1560,23,6160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',25622941.49,'AXI cuentas de resultados',NULL,1,'2024-01-08 12:25:11','2024-01-08 12:25:11',NULL),(6161,9756,40720,1560,23,6161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',236937.32,'AXI Ajuste de capital',NULL,1,'2024-01-08 12:26:24','2024-01-08 12:26:24',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23680 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7485,1,40723,6064,3,221,1,200.02,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(2,7485,1,40723,6064,3,217,1,2432.37,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(3,7485,1,40723,6064,3,57,2,2632.39,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(4,7485,2,40723,6064,3,217,1,829.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(5,7485,2,40723,6064,3,57,2,829.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(6,7485,3,40723,6064,3,217,1,95.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(7,7485,3,40723,6064,3,57,2,95.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(8,7485,4,40723,6064,3,225,1,95111.20,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(9,7485,4,40723,6064,3,250,1,2377779.93,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(10,7485,4,40723,6064,3,68,1,499333.79,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(11,7485,4,40723,6064,3,57,2,2972224.92,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(12,7485,5,40723,6064,3,225,1,4819.87,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(13,7485,5,40723,6064,3,250,1,120496.78,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(14,7485,5,40723,6064,3,68,1,25304.32,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(15,7485,5,40723,6064,3,57,2,150620.97,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(16,7485,6,40723,6064,3,250,1,13388.43,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(17,7485,6,40723,6064,3,68,1,2811.57,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(18,7485,6,40723,6064,3,57,2,16200.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(19,7485,7,40723,6064,3,217,1,68.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(20,7485,7,40723,6064,3,57,2,68.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(21,7485,8,40723,6064,3,217,1,258.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(22,7485,8,40723,6064,3,57,2,258.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(23,7485,9,40723,6064,3,221,1,45.95,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(24,7485,9,40723,6064,3,217,1,556.05,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(25,7485,9,40723,6064,3,57,2,602.00,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(26,7485,10,40723,6064,3,221,1,1296.55,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(27,7485,10,40723,6064,3,250,1,6620.45,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(28,7485,10,40723,6064,3,68,1,1390.30,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(29,7485,10,40723,6064,3,57,2,9307.30,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(30,7485,11,40723,6064,3,225,1,6.61,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(31,7485,11,40723,6064,3,250,1,165.29,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(32,7485,11,40723,6064,3,68,1,34.71,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(33,7485,11,40723,6064,3,57,2,206.61,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(34,7485,12,40723,6064,3,225,1,9.92,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(35,7485,12,40723,6064,3,250,1,247.93,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(36,7485,12,40723,6064,3,68,1,52.07,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(37,7485,12,40723,6064,3,57,2,309.92,NULL,'2023-01-21 20:03:21','2023-01-21 20:03:21',NULL),(38,7485,13,40723,6064,2,96,2,535937.48,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(39,7485,13,40723,6064,2,67,2,112546.87,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(40,7485,13,40723,6064,2,13,1,648484.35,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(41,7485,14,40723,6064,2,96,2,4506.67,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(42,7485,14,40723,6064,2,67,2,946.40,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(43,7485,14,40723,6064,2,218,2,0.02,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL);
INSERT INTO `balance_libro_details` VALUES (44,7485,14,40723,6064,2,13,1,5453.09,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(45,7485,15,40723,6064,2,96,2,178343.76,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(46,7485,15,40723,6064,2,67,2,37452.19,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(47,7485,15,40723,6064,2,218,2,0.03,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(48,7485,15,40723,6064,2,13,1,215795.98,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(49,7485,16,40723,6064,2,96,2,3927.38,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(50,7485,16,40723,6064,2,67,2,824.75,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(51,7485,16,40723,6064,2,218,2,0.02,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(52,7485,16,40723,6064,2,13,1,4752.15,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(53,7485,17,40723,6064,2,96,2,16662.90,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(54,7485,17,40723,6064,2,67,2,3499.21,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(55,7485,17,40723,6064,2,13,1,20162.11,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(56,7485,18,40723,6064,2,96,2,6905.00,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(57,7485,18,40723,6064,2,67,2,1450.05,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(58,7485,18,40723,6064,2,13,1,8355.05,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(59,7485,19,40723,6064,2,96,2,14933.52,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(60,7485,19,40723,6064,2,67,2,3136.04,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(61,7485,19,40723,6064,2,218,2,0.03,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(62,7485,19,40723,6064,2,13,1,18069.59,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(63,7485,20,40723,6064,2,96,2,232320.52,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(64,7485,20,40723,6064,2,67,2,48787.31,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(65,7485,20,40723,6064,2,218,2,0.02,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(66,7485,20,40723,6064,2,13,1,281107.85,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(67,7485,21,40723,6064,2,96,2,29774.81,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(68,7485,21,40723,6064,2,67,2,6252.71,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(69,7485,21,40723,6064,2,218,2,0.01,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(70,7485,21,40723,6064,2,13,1,36027.53,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(71,7485,22,40723,6064,2,96,2,46487.62,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(72,7485,22,40723,6064,2,67,2,9762.40,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(73,7485,22,40723,6064,2,218,2,0.01,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(74,7485,22,40723,6064,2,13,1,56250.03,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(75,7485,23,40723,6064,2,96,2,102771.10,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(76,7485,23,40723,6064,2,67,2,21581.93,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(77,7485,23,40723,6064,2,218,2,0.03,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(78,7485,23,40723,6064,2,13,1,124353.06,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(79,7485,24,40723,6064,2,96,2,38416.71,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(80,7485,24,40723,6064,2,67,2,8067.51,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(81,7485,24,40723,6064,2,218,2,0.01,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(82,7485,24,40723,6064,2,13,1,46484.23,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(83,7485,25,40723,6064,2,96,2,46478.38,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(84,7485,25,40723,6064,2,67,2,9760.46,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(85,7485,25,40723,6064,2,218,2,0.02,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL);
INSERT INTO `balance_libro_details` VALUES (86,7485,25,40723,6064,2,13,1,56238.86,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(87,7485,26,40723,6064,2,96,2,757.76,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(88,7485,26,40723,6064,2,67,2,159.13,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(89,7485,26,40723,6064,2,218,2,0.01,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(90,7485,26,40723,6064,2,13,1,916.90,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(91,7485,27,40723,6064,2,96,2,1864.48,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(92,7485,27,40723,6064,2,67,2,391.54,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(93,7485,27,40723,6064,2,218,2,0.02,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(94,7485,27,40723,6064,2,13,1,2256.04,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(95,7485,28,40723,6064,2,96,2,5967.29,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(96,7485,28,40723,6064,2,67,2,1253.13,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(97,7485,28,40723,6064,2,218,2,0.02,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(98,7485,28,40723,6064,2,13,1,7220.44,NULL,'2023-01-21 20:03:40','2023-01-21 20:03:40',NULL),(99,7485,29,40723,6064,2,96,2,258466.57,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(100,7485,29,40723,6064,2,67,2,54277.98,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(101,7485,29,40723,6064,2,218,2,0.03,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(102,7485,29,40723,6064,2,13,1,312744.58,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(103,7485,30,40723,6064,2,96,2,271493.52,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(104,7485,30,40723,6064,2,67,2,57013.64,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(105,7485,30,40723,6064,2,218,2,0.04,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(106,7485,30,40723,6064,2,13,1,328507.20,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(107,7485,31,40723,6064,2,96,2,537411.19,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(108,7485,31,40723,6064,2,67,2,112856.35,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(109,7485,31,40723,6064,2,218,2,0.01,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(110,7485,31,40723,6064,2,13,1,650267.55,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(111,7485,32,40723,6064,2,96,1,271493.52,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(112,7485,32,40723,6064,2,68,1,57013.64,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(113,7485,32,40723,6064,2,218,1,0.04,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(114,7485,32,40723,6064,2,13,2,328507.20,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(115,7485,33,40723,6064,2,96,2,148874.00,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(116,7485,33,40723,6064,2,67,2,31263.54,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(117,7485,33,40723,6064,2,218,2,0.02,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(118,7485,33,40723,6064,2,13,1,180137.56,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(119,7485,34,40723,6064,2,96,2,4042.52,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(120,7485,34,40723,6064,2,67,2,848.93,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(121,7485,34,40723,6064,2,218,2,0.01,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(122,7485,34,40723,6064,2,13,1,4891.46,NULL,'2023-01-21 20:03:41','2023-01-21 20:03:41',NULL),(402,7485,110,40723,7767,3,217,1,3548.41,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(403,7485,110,40723,7767,3,68,1,745.16,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(404,7485,110,40723,7767,3,217,1,772.93,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(405,7485,110,40723,7767,3,57,2,5066.50,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(406,7485,111,40723,7767,3,217,1,469146.34,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL);
INSERT INTO `balance_libro_details` VALUES (407,7485,111,40723,7767,3,68,1,98520.73,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(408,7485,111,40723,7767,3,217,1,18765.85,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(409,7485,111,40723,7767,3,57,2,586432.92,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(410,7485,112,40723,7767,3,217,1,112.40,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(411,7485,112,40723,7767,3,68,1,23.60,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(412,7485,112,40723,7767,3,57,2,136.00,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(413,7485,113,40723,7767,3,217,1,391.91,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(414,7485,113,40723,7767,3,68,1,82.30,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(415,7485,113,40723,7767,3,217,1,39.18,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(416,7485,113,40723,7767,3,57,2,513.39,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(417,7485,114,40723,7767,3,217,1,8506.50,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(418,7485,114,40723,7767,3,68,1,1786.37,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(419,7485,114,40723,7767,3,217,1,340.26,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(420,7485,114,40723,7767,3,57,2,10633.13,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(421,7485,115,40723,7767,3,217,1,291.73,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(422,7485,115,40723,7767,3,68,1,61.27,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(423,7485,115,40723,7767,3,57,2,353.00,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(424,7485,116,40723,7767,3,217,1,482.64,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(425,7485,116,40723,7767,3,68,1,101.36,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(426,7485,116,40723,7767,3,57,2,584.00,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(427,7485,117,40723,7767,3,217,1,39346.18,NULL,'2023-01-22 19:03:12','2023-02-07 19:29:59','2023-02-07 19:29:59'),(428,7485,117,40723,7767,3,68,1,6567.93,NULL,'2023-01-22 19:03:12','2023-02-07 19:29:59','2023-02-07 19:29:59'),(429,7485,117,40723,7767,3,217,1,2628.38,NULL,'2023-01-22 19:03:12','2023-02-07 19:29:59','2023-02-07 19:29:59'),(430,7485,117,40723,7767,3,57,2,48542.49,NULL,'2023-01-22 19:03:12','2023-02-07 19:29:59','2023-02-07 19:29:59'),(431,7485,118,40723,7767,3,217,1,1081.22,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(432,7485,118,40723,7767,3,68,1,227.05,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(433,7485,118,40723,7767,3,217,1,108.11,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(434,7485,118,40723,7767,3,57,2,1416.38,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(435,7485,119,40723,7767,3,217,1,1776.00,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(436,7485,119,40723,7767,3,68,1,372.96,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(437,7485,119,40723,7767,3,217,1,71.04,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(438,7485,119,40723,7767,3,57,2,2220.00,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(439,7485,120,40723,7767,3,217,1,595.04,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(440,7485,120,40723,7767,3,68,1,124.96,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(441,7485,120,40723,7767,3,57,2,720.00,NULL,'2023-01-22 19:03:12','2023-01-22 19:03:12',NULL),(442,7485,121,40723,7767,3,217,1,776624.14,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(443,7485,121,40723,7767,3,68,1,163091.07,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(444,7485,121,40723,7767,3,217,1,31064.97,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(445,7485,121,40723,7767,3,57,2,970780.18,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(446,7485,122,40723,7767,3,217,1,7494.08,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(447,7485,122,40723,7767,3,68,1,1573.76,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL);
INSERT INTO `balance_libro_details` VALUES (448,7485,122,40723,7767,3,57,2,9067.84,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(449,7485,123,40723,7767,3,217,1,8263.64,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(450,7485,123,40723,7767,3,68,1,1735.36,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(451,7485,123,40723,7767,3,217,1,330.55,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(452,7485,123,40723,7767,3,57,2,10329.55,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(453,7485,124,40723,7767,3,250,1,8524.00,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(454,7485,124,40723,7767,3,57,2,8524.00,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(455,7485,125,40723,7767,3,217,2,21289.49,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(456,7485,125,40723,7767,3,67,2,4470.79,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(457,7485,125,40723,7767,3,57,1,25760.28,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(458,7485,126,40723,7767,3,217,2,7438.25,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(459,7485,126,40723,7767,3,67,2,1562.03,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(460,7485,126,40723,7767,3,217,2,2272.44,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(461,7485,126,40723,7767,3,57,1,11272.72,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(462,7485,127,40723,7767,3,217,2,3427.88,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(463,7485,127,40723,7767,3,67,2,719.85,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(464,7485,127,40723,7767,3,57,1,4147.73,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(465,7485,128,40723,7767,3,217,1,20658.68,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(466,7485,128,40723,7767,3,68,1,4338.32,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(467,7485,128,40723,7767,3,217,1,826.35,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(468,7485,128,40723,7767,3,57,2,25823.35,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(469,7485,129,40723,7767,3,217,1,2070860.15,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(470,7485,129,40723,7767,3,68,1,434880.63,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(471,7485,129,40723,7767,3,217,1,82834.41,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(472,7485,129,40723,7767,3,57,2,2588575.19,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(473,7485,130,40723,7767,3,217,1,123350.98,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(474,7485,130,40723,7767,3,68,1,25903.71,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(475,7485,130,40723,7767,3,217,1,4934.04,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(476,7485,130,40723,7767,3,57,2,154188.73,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(477,7485,131,40723,7767,3,217,1,193350.57,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(478,7485,131,40723,7767,3,68,1,40603.62,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(479,7485,131,40723,7767,3,217,1,58354.35,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(480,7485,131,40723,7767,3,57,2,292308.54,NULL,'2023-01-22 19:03:13','2023-01-22 19:03:13',NULL),(481,7485,132,40723,7767,2,96,2,25782.55,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(482,7485,132,40723,7767,2,67,2,5414.34,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(483,7485,132,40723,7767,2,13,1,31196.89,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(484,7485,133,40723,7767,2,96,2,5000.83,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(485,7485,133,40723,7767,2,67,2,1050.17,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(486,7485,133,40723,7767,2,13,1,6051.00,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(487,7485,134,40723,7767,2,96,2,13938.47,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(488,7485,134,40723,7767,2,67,2,2927.08,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL);
INSERT INTO `balance_libro_details` VALUES (489,7485,134,40723,7767,2,13,1,16865.55,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(490,7485,135,40723,7767,2,96,2,7494.22,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(491,7485,135,40723,7767,2,67,2,1573.79,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(492,7485,135,40723,7767,2,13,1,9068.01,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(493,7485,136,40723,7767,2,96,2,17919.50,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(494,7485,136,40723,7767,2,67,2,3763.10,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(495,7485,136,40723,7767,2,13,1,21682.60,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(496,7485,137,40723,7767,2,96,2,101171.61,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(497,7485,137,40723,7767,2,67,2,21246.04,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(498,7485,137,40723,7767,2,13,1,122417.65,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(499,7485,138,40723,7767,2,96,2,99915.57,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(500,7485,138,40723,7767,2,67,2,20982.27,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(501,7485,138,40723,7767,2,13,1,120897.84,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(502,7485,139,40723,7767,2,96,2,148463.16,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(503,7485,139,40723,7767,2,67,2,31177.26,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(504,7485,139,40723,7767,2,13,1,179640.42,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(505,7485,140,40723,7767,2,96,2,3498.84,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(506,7485,140,40723,7767,2,67,2,734.76,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(507,7485,140,40723,7767,2,13,1,4233.60,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(508,7485,141,40723,7767,2,96,2,238207.01,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(509,7485,141,40723,7767,2,67,2,50023.47,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(510,7485,141,40723,7767,2,13,1,288230.48,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(511,7485,142,40723,7767,2,96,2,25292.90,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(512,7485,142,40723,7767,2,67,2,5311.51,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(513,7485,142,40723,7767,2,13,1,30604.41,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(514,7485,143,40723,7767,2,96,2,63885.32,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(515,7485,143,40723,7767,2,67,2,13415.92,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(516,7485,143,40723,7767,2,13,1,77301.24,NULL,'2023-01-22 19:04:04','2023-01-22 19:04:04',NULL),(517,7485,144,40723,7767,2,96,2,95282.80,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(518,7485,144,40723,7767,2,67,2,20009.39,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(519,7485,144,40723,7767,2,13,1,115292.19,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(520,7485,145,40723,7767,2,96,2,220376.71,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(521,7485,145,40723,7767,2,67,2,46279.11,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(522,7485,145,40723,7767,2,13,1,266655.82,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(523,7485,146,40723,7767,2,218,2,0.00,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(524,7485,146,40723,7767,2,218,2,57548.74,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(525,7485,146,40723,7767,2,13,1,57548.74,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(526,7485,147,40723,7767,2,96,2,24262.81,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(527,7485,147,40723,7767,2,67,2,5095.19,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(528,7485,147,40723,7767,2,13,1,29358.00,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(529,7485,148,40723,7767,2,96,2,1317.27,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL);
INSERT INTO `balance_libro_details` VALUES (530,7485,148,40723,7767,2,67,2,276.62,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(531,7485,148,40723,7767,2,13,1,1593.89,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(532,7485,149,40723,7767,2,96,2,20667.27,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(533,7485,149,40723,7767,2,67,2,4340.13,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(534,7485,149,40723,7767,2,13,1,25007.40,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(535,7485,150,40723,7767,2,96,2,831897.78,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(536,7485,150,40723,7767,2,67,2,174698.53,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(537,7485,150,40723,7767,2,13,1,1006596.31,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(538,7485,151,40723,7767,2,96,2,98470.02,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(539,7485,151,40723,7767,2,67,2,20678.69,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(540,7485,151,40723,7767,2,13,1,119148.71,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(541,7485,152,40723,7767,2,96,2,3458.68,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(542,7485,152,40723,7767,2,67,2,726.32,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(543,7485,152,40723,7767,2,13,1,4185.00,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(544,7485,153,40723,7767,2,96,2,4055.95,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(545,7485,153,40723,7767,2,67,2,851.75,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(546,7485,153,40723,7767,2,13,1,4907.70,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(547,7485,154,40723,7767,2,96,2,2521.49,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(548,7485,154,40723,7767,2,67,2,529.51,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(549,7485,154,40723,7767,2,13,1,3051.00,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(550,7485,155,40723,7767,2,96,2,5109.92,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(551,7485,155,40723,7767,2,67,2,1073.08,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(552,7485,155,40723,7767,2,13,1,6183.00,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(553,7485,156,40723,7767,2,96,2,13784.88,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(554,7485,156,40723,7767,2,67,2,2894.82,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(555,7485,156,40723,7767,2,13,1,16679.70,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(556,7485,157,40723,7767,2,96,2,2455505.85,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(557,7485,157,40723,7767,2,67,2,515656.23,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(558,7485,157,40723,7767,2,13,1,2971162.08,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(559,7485,158,40723,7767,2,96,2,199516.86,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(560,7485,158,40723,7767,2,67,2,41898.54,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(561,7485,158,40723,7767,2,13,1,241415.40,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(562,7485,159,40723,7767,2,96,2,110277.05,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(563,7485,159,40723,7767,2,67,2,23158.18,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(564,7485,159,40723,7767,2,13,1,133435.23,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(565,7485,160,40723,7767,2,96,2,19966.77,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(566,7485,160,40723,7767,2,67,2,4193.02,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(567,7485,160,40723,7767,2,13,1,24159.79,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(568,7485,161,40723,7767,2,96,2,19966.77,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(569,7485,161,40723,7767,2,67,2,4193.02,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(570,7485,161,40723,7767,2,13,1,24159.79,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL);
INSERT INTO `balance_libro_details` VALUES (571,7485,162,40723,7767,2,96,2,4045.70,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(572,7485,162,40723,7767,2,67,2,849.59,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(573,7485,162,40723,7767,2,13,1,4895.29,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(574,7485,163,40723,7767,2,96,2,8872.07,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(575,7485,163,40723,7767,2,67,2,1863.13,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(576,7485,163,40723,7767,2,13,1,10735.20,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(577,7485,164,40723,7767,2,96,2,7145.62,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(578,7485,164,40723,7767,2,67,2,1500.58,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(579,7485,164,40723,7767,2,13,1,8646.20,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(580,7485,165,40723,7767,2,96,2,69822.08,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(581,7485,165,40723,7767,2,67,2,14662.64,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(582,7485,165,40723,7767,2,13,1,84484.72,NULL,'2023-01-22 19:04:05','2023-01-22 19:04:05',NULL),(583,7485,166,40828,7768,3,217,1,2399.90,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(584,7485,166,40828,7768,3,57,2,2399.90,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(585,7485,167,40828,7768,3,217,1,18000.00,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(586,7485,167,40828,7768,3,57,2,18000.00,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(587,7485,168,40828,7768,3,250,1,5454.00,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(588,7485,168,40828,7768,3,68,1,1145.34,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(589,7485,168,40828,7768,3,250,1,1576.00,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(590,7485,168,40828,7768,3,68,1,425.52,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(591,7485,168,40828,7768,3,57,2,8600.86,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(592,7485,169,40828,7768,3,217,1,14246.73,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(593,7485,169,40828,7768,3,57,2,14246.73,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(594,7485,170,40828,7768,3,250,1,1887.60,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(595,7485,170,40828,7768,3,68,1,396.40,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(596,7485,170,40828,7768,3,250,1,955.12,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(597,7485,170,40828,7768,3,68,1,257.88,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(598,7485,170,40828,7768,3,57,2,3497.00,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(599,7485,171,40828,7768,3,250,1,36485.96,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(600,7485,171,40828,7768,3,68,1,7662.05,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(601,7485,171,40828,7768,3,57,2,44148.01,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(602,7485,172,40828,7768,3,250,1,23140.50,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(603,7485,172,40828,7768,3,68,1,4859.51,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(604,7485,172,40828,7768,3,57,2,28000.01,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(605,7485,173,40828,7768,3,250,1,15052.56,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(606,7485,173,40828,7768,3,68,1,3161.04,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(607,7485,173,40828,7768,3,57,2,18213.60,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(608,7485,174,40828,7768,3,217,1,58183.80,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(609,7485,174,40828,7768,3,57,2,58183.80,NULL,'2023-02-03 00:04:48','2023-02-03 00:04:48',NULL),(618,7485,177,40828,7768,2,96,2,61983.48,NULL,'2023-02-03 00:23:33','2023-02-04 18:58:21','2023-02-04 18:58:21'),(619,7485,177,40828,7768,2,67,2,13016.53,NULL,'2023-02-03 00:23:33','2023-02-04 18:58:21','2023-02-04 18:58:21');
INSERT INTO `balance_libro_details` VALUES (620,7485,177,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:33','2023-02-04 18:58:21','2023-02-04 18:58:21'),(621,7485,177,40828,7768,2,13,1,75000.02,NULL,'2023-02-03 00:23:33','2023-02-04 18:58:21','2023-02-04 18:58:21'),(622,7485,178,40828,7768,2,96,2,16528.90,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(623,7485,178,40828,7768,2,67,2,3471.07,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(624,7485,178,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(625,7485,178,40828,7768,2,13,1,20000.00,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(626,7485,179,40828,7768,2,96,2,3117.33,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(627,7485,179,40828,7768,2,67,2,654.64,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(628,7485,179,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(629,7485,179,40828,7768,2,13,1,3772.00,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(630,7485,180,40828,7768,2,96,2,48293.43,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(631,7485,180,40828,7768,2,67,2,10141.62,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(632,7485,180,40828,7768,2,218,2,0.05,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(633,7485,180,40828,7768,2,13,1,58435.10,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(634,7485,181,40828,7768,2,96,2,15442.14,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(635,7485,181,40828,7768,2,67,2,3242.85,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(636,7485,181,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(637,7485,181,40828,7768,2,13,1,18685.00,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(638,7485,182,40828,7768,2,96,2,7119.86,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(639,7485,182,40828,7768,2,67,2,1495.17,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(640,7485,182,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(641,7485,182,40828,7768,2,13,1,8615.06,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(642,7485,183,40828,7768,2,96,2,13132.24,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(643,7485,183,40828,7768,2,67,2,2757.77,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(644,7485,183,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(645,7485,183,40828,7768,2,13,1,15890.02,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(646,7485,184,40828,7768,2,96,2,12545.48,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(647,7485,184,40828,7768,2,67,2,2634.55,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(648,7485,184,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(649,7485,184,40828,7768,2,13,1,15180.06,NULL,'2023-02-03 00:23:33','2023-02-03 00:23:33',NULL),(650,7485,185,40828,7768,2,96,2,15041.33,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(651,7485,185,40828,7768,2,67,2,3158.68,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(652,7485,185,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(653,7485,185,40828,7768,2,13,1,18200.02,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(654,7485,186,40828,7768,2,96,2,7322.33,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(655,7485,186,40828,7768,2,67,2,1537.69,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(656,7485,186,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(657,7485,186,40828,7768,2,13,1,8860.04,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(658,7485,187,40828,7768,2,96,2,12074.38,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(659,7485,187,40828,7768,2,67,2,2535.62,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(660,7485,187,40828,7768,2,13,1,14610.00,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL);
INSERT INTO `balance_libro_details` VALUES (661,7485,188,40828,7768,2,96,2,6611.57,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(662,7485,188,40828,7768,2,67,2,1388.43,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(663,7485,188,40828,7768,2,13,1,8000.00,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(664,7485,189,40828,7768,2,96,2,12107.43,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(665,7485,189,40828,7768,2,67,2,2542.56,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(666,7485,189,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(667,7485,189,40828,7768,2,13,1,14650.00,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(668,7485,190,40828,7768,2,96,2,17095.00,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(669,7485,190,40828,7768,2,67,2,3589.95,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(670,7485,190,40828,7768,2,218,2,0.05,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(671,7485,190,40828,7768,2,13,1,20685.00,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(672,7485,191,40828,7768,2,96,2,8051.24,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(673,7485,191,40828,7768,2,67,2,1690.76,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(674,7485,191,40828,7768,2,13,1,9742.00,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(675,7485,192,40828,7768,2,96,2,4305.76,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(676,7485,192,40828,7768,2,67,2,904.21,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(677,7485,192,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(678,7485,192,40828,7768,2,13,1,5210.00,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(679,7485,193,40828,7768,2,96,2,12396.71,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(680,7485,193,40828,7768,2,67,2,2603.31,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(681,7485,193,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(682,7485,193,40828,7768,2,13,1,15000.04,NULL,'2023-02-03 00:23:34','2023-02-03 00:23:34',NULL),(683,7485,194,40828,7768,2,96,2,1983.48,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(684,7485,194,40828,7768,2,67,2,416.53,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(685,7485,194,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(686,7485,194,40828,7768,2,13,1,2400.02,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(687,7485,195,40828,7768,2,96,2,9457.00,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(688,7485,195,40828,7768,2,67,2,1985.97,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(689,7485,195,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(690,7485,195,40828,7768,2,13,1,11443.00,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(691,7485,196,40828,7768,2,96,2,17355.38,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(692,7485,196,40828,7768,2,67,2,3644.63,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(693,7485,196,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(694,7485,196,40828,7768,2,13,1,21000.02,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(695,7485,197,40828,7768,2,96,2,16528.90,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(696,7485,197,40828,7768,2,67,2,3471.07,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(697,7485,197,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(698,7485,197,40828,7768,2,13,1,20000.00,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(699,7485,198,40828,7768,2,96,2,10991.71,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(700,7485,198,40828,7768,2,67,2,2308.26,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(701,7485,198,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(702,7485,198,40828,7768,2,13,1,13300.00,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL);
INSERT INTO `balance_libro_details` VALUES (703,7485,199,40828,7768,2,96,2,9504.10,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(704,7485,199,40828,7768,2,67,2,1995.86,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(705,7485,199,40828,7768,2,218,2,0.04,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(706,7485,199,40828,7768,2,13,1,11500.00,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(707,7485,200,40828,7768,2,96,2,14247.95,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(708,7485,200,40828,7768,2,67,2,2992.07,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(709,7485,200,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(710,7485,200,40828,7768,2,13,1,17240.04,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(711,7485,201,40828,7768,2,96,2,72066.10,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(712,7485,201,40828,7768,2,67,2,15133.88,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(713,7485,201,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(714,7485,201,40828,7768,2,13,1,87200.00,NULL,'2023-02-03 00:23:35','2023-02-03 00:23:35',NULL),(715,7485,202,40828,7768,2,96,2,8545.48,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(716,7485,202,40828,7768,2,67,2,1794.55,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(717,7485,202,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(718,7485,202,40828,7768,2,13,1,10340.06,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(719,7485,203,40828,7768,2,96,2,3057.86,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(720,7485,203,40828,7768,2,67,2,642.15,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(721,7485,203,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(722,7485,203,40828,7768,2,13,1,3700.02,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(723,7485,204,40828,7768,2,96,2,13223.14,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(724,7485,204,40828,7768,2,67,2,2776.86,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(725,7485,204,40828,7768,2,13,1,16000.00,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(726,7485,205,40828,7768,2,96,2,8884.29,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(727,7485,205,40828,7768,2,67,2,1865.70,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(728,7485,205,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(729,7485,205,40828,7768,2,13,1,10750.00,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(730,7485,206,40828,7768,2,96,2,16528.90,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(731,7485,206,40828,7768,2,67,2,3471.07,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(732,7485,206,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(733,7485,206,40828,7768,2,13,1,20000.00,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(734,7485,207,40828,7768,2,96,2,4049.57,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(735,7485,207,40828,7768,2,67,2,850.41,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(736,7485,207,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(737,7485,207,40828,7768,2,13,1,4900.00,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(738,7485,208,40828,7768,2,96,2,17512.38,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(739,7485,208,40828,7768,2,67,2,3677.60,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(740,7485,208,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(741,7485,208,40828,7768,2,13,1,21190.00,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(742,7485,209,40828,7768,2,96,2,17768.57,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(743,7485,209,40828,7768,2,67,2,3731.40,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(744,7485,209,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL);
INSERT INTO `balance_libro_details` VALUES (745,7485,209,40828,7768,2,13,1,21500.00,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(746,7485,210,40828,7768,2,96,2,12471.10,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(747,7485,210,40828,7768,2,67,2,2618.93,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(748,7485,210,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(749,7485,210,40828,7768,2,13,1,15090.06,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(750,7485,211,40828,7768,2,96,2,17264.48,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(751,7485,211,40828,7768,2,67,2,3625.54,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(752,7485,211,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(753,7485,211,40828,7768,2,13,1,20890.04,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(754,7485,212,40828,7768,2,96,2,11983.48,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(755,7485,212,40828,7768,2,67,2,2516.53,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(756,7485,212,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(757,7485,212,40828,7768,2,13,1,14500.02,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(758,7485,213,40828,7768,2,96,2,9910.76,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(759,7485,213,40828,7768,2,67,2,2081.26,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(760,7485,213,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(761,7485,213,40828,7768,2,13,1,11992.04,NULL,'2023-02-03 00:23:36','2023-02-03 00:23:36',NULL),(762,7485,214,40828,7768,2,96,2,12305.76,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(763,7485,214,40828,7768,2,67,2,2584.21,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(764,7485,214,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(765,7485,214,40828,7768,2,13,1,14890.00,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(766,7485,215,40828,7768,2,96,2,8429.76,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(767,7485,215,40828,7768,2,67,2,1770.25,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(768,7485,215,40828,7768,2,218,2,0.01,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(769,7485,215,40828,7768,2,13,1,10200.02,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(770,7485,216,40828,7768,2,96,2,6322.33,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(771,7485,216,40828,7768,2,67,2,1327.69,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(772,7485,216,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(773,7485,216,40828,7768,2,13,1,7650.04,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(774,7485,217,40828,7768,2,96,2,16528.90,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(775,7485,217,40828,7768,2,67,2,3471.07,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(776,7485,217,40828,7768,2,218,2,0.03,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(777,7485,217,40828,7768,2,13,1,20000.00,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(778,7485,218,40828,7768,2,96,2,14049.57,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(779,7485,218,40828,7768,2,67,2,2950.41,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(780,7485,218,40828,7768,2,218,2,0.02,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(781,7485,218,40828,7768,2,13,1,17000.00,NULL,'2023-02-03 00:23:37','2023-02-03 00:23:37',NULL),(782,7485,219,40828,7769,3,217,1,2399.90,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(783,7485,219,40828,7769,3,57,2,2399.90,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(784,7485,220,40828,7769,3,225,1,252.38,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(785,7485,220,40828,7769,3,250,1,8205.37,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(786,7485,220,40828,7769,3,68,1,1723.13,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL);
INSERT INTO `balance_libro_details` VALUES (787,7485,220,40828,7769,3,250,1,1890.00,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(788,7485,220,40828,7769,3,68,1,510.30,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(789,7485,220,40828,7769,3,57,2,12581.18,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(790,7485,221,40828,7769,3,250,2,2909.19,NULL,'2023-02-03 12:15:56','2023-02-05 18:13:13','2023-02-05 18:13:13'),(791,7485,221,40828,7769,3,57,1,2909.19,NULL,'2023-02-03 12:15:56','2023-02-05 18:13:13','2023-02-05 18:13:13'),(792,7485,222,40828,7769,3,221,1,826.72,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(793,7485,222,40828,7769,3,250,1,33068.71,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(794,7485,222,40828,7769,3,68,1,6944.43,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(795,7485,222,40828,7769,3,57,2,40839.86,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(796,7485,223,40828,7769,3,221,1,813.35,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(797,7485,223,40828,7769,3,225,1,210.14,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(798,7485,223,40828,7769,3,220,1,227.77,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(799,7485,223,40828,7769,3,250,1,7592.26,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(800,7485,223,40828,7769,3,68,1,1594.37,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(801,7485,223,40828,7769,3,250,1,0.01,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(802,7485,223,40828,7769,3,57,2,10437.90,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(803,7485,224,40828,7769,3,225,1,75.32,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(804,7485,224,40828,7769,3,250,1,2000.00,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(805,7485,224,40828,7769,3,68,1,420.00,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(806,7485,224,40828,7769,3,250,1,1012.60,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(807,7485,224,40828,7769,3,68,1,273.40,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(808,7485,224,40828,7769,3,57,2,3781.32,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(809,7485,225,40828,7769,3,225,1,1781.28,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(810,7485,225,40828,7769,3,250,1,71251.02,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(811,7485,225,40828,7769,3,68,1,14962.71,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(812,7485,225,40828,7769,3,57,2,87995.01,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(813,7485,226,40828,7769,3,250,2,465000.00,NULL,'2023-02-03 12:15:56','2023-02-04 18:40:57','2023-02-04 18:40:57'),(814,7485,226,40828,7769,3,57,1,465000.00,NULL,'2023-02-03 12:15:56','2023-02-04 18:40:57','2023-02-04 18:40:57'),(815,7485,227,40828,7769,3,221,1,1676.39,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(816,7485,227,40828,7769,3,250,1,15069.22,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(817,7485,227,40828,7769,3,68,1,3164.53,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(818,7485,227,40828,7769,3,57,2,19910.14,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(819,7485,228,40828,7769,3,221,1,8.67,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(820,7485,228,40828,7769,3,250,1,346.86,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(821,7485,228,40828,7769,3,68,1,72.84,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(822,7485,228,40828,7769,3,57,2,428.37,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(823,7485,229,40828,7769,3,221,1,6752.17,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(824,7485,229,40828,7769,3,250,1,270086.61,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(825,7485,229,40828,7769,3,68,1,56718.19,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(826,7485,229,40828,7769,3,250,1,0.01,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL),(827,7485,229,40828,7769,3,57,2,333556.98,NULL,'2023-02-03 12:15:56','2023-02-03 12:15:56',NULL);
INSERT INTO `balance_libro_details` VALUES (828,7485,230,40828,7769,2,96,2,17041.29,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(829,7485,230,40828,7769,2,67,2,3578.67,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(830,7485,230,40828,7769,2,218,2,0.04,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(831,7485,230,40828,7769,2,13,1,20620.00,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(832,7485,231,40828,7769,2,218,2,75000.00,NULL,'2023-02-03 12:41:28','2023-02-04 18:52:12','2023-02-04 18:52:12'),(833,7485,231,40828,7769,2,13,1,75000.00,NULL,'2023-02-03 12:41:28','2023-02-04 18:52:12','2023-02-04 18:52:12'),(834,7485,232,40828,7769,2,96,2,61983.48,NULL,'2023-02-03 12:41:28','2023-02-04 18:34:27','2023-02-04 18:34:27'),(835,7485,232,40828,7769,2,67,2,13016.53,NULL,'2023-02-03 12:41:28','2023-02-04 18:34:27','2023-02-04 18:34:27'),(836,7485,232,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:28','2023-02-04 18:34:27','2023-02-04 18:34:27'),(837,7485,232,40828,7769,2,13,1,75000.02,NULL,'2023-02-03 12:41:28','2023-02-04 18:34:27','2023-02-04 18:34:27'),(838,7485,233,40828,7769,2,96,2,8090.90,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(839,7485,233,40828,7769,2,67,2,1699.09,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(840,7485,233,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(841,7485,233,40828,7769,2,13,1,9790.00,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(842,7485,234,40828,7769,2,96,2,18181.81,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(843,7485,234,40828,7769,2,67,2,3818.18,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(844,7485,234,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(845,7485,234,40828,7769,2,13,1,22000.00,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(846,7485,235,40828,7769,2,96,2,20661.14,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(847,7485,235,40828,7769,2,67,2,4338.84,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(848,7485,235,40828,7769,2,218,2,0.02,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(849,7485,235,40828,7769,2,13,1,25000.00,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(850,7485,236,40828,7769,2,96,2,45801.67,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(851,7485,236,40828,7769,2,67,2,9618.35,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(852,7485,236,40828,7769,2,218,2,0.02,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(853,7485,236,40828,7769,2,13,1,55420.04,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(854,7485,237,40828,7769,2,96,2,17929.76,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(855,7485,237,40828,7769,2,67,2,3765.25,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(856,7485,237,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(857,7485,237,40828,7769,2,13,1,21695.02,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(858,7485,238,40828,7769,2,96,2,7851.24,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(859,7485,238,40828,7769,2,67,2,1648.76,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(860,7485,238,40828,7769,2,13,1,9500.00,NULL,'2023-02-03 12:41:28','2023-02-03 12:41:28',NULL),(861,7485,239,40828,7769,2,96,2,49504.14,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(862,7485,239,40828,7769,2,67,2,10395.87,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(863,7485,239,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(864,7485,239,40828,7769,2,13,1,59900.02,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(865,7485,240,40828,7769,2,96,2,57633.05,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(866,7485,240,40828,7769,2,67,2,12102.94,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(867,7485,240,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(868,7485,240,40828,7769,2,13,1,69736.00,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL);
INSERT INTO `balance_libro_details` VALUES (869,7485,241,40828,7769,2,96,2,8140.48,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(870,7485,241,40828,7769,2,67,2,1709.50,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(871,7485,241,40828,7769,2,218,2,0.02,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(872,7485,241,40828,7769,2,13,1,9850.00,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(873,7485,242,40828,7769,2,96,2,9876.05,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(874,7485,242,40828,7769,2,67,2,2073.97,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(875,7485,242,40828,7769,2,218,2,0.02,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(876,7485,242,40828,7769,2,13,1,11950.04,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(877,7485,243,40828,7769,2,96,2,45801.67,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(878,7485,243,40828,7769,2,67,2,9618.35,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(879,7485,243,40828,7769,2,218,2,0.02,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(880,7485,243,40828,7769,2,13,1,55420.04,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(881,7485,244,40828,7769,2,96,2,12505.76,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(882,7485,244,40828,7769,2,67,2,2626.21,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(883,7485,244,40828,7769,2,218,2,0.03,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(884,7485,244,40828,7769,2,13,1,15132.00,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(885,7485,245,40828,7769,2,96,2,19008.29,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(886,7485,245,40828,7769,2,67,2,3991.74,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(887,7485,245,40828,7769,2,218,2,0.03,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(888,7485,245,40828,7769,2,13,1,23000.06,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(889,7485,246,40828,7769,2,96,2,7297.52,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(890,7485,246,40828,7769,2,67,2,1532.48,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(891,7485,246,40828,7769,2,13,1,8830.00,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(892,7485,247,40828,7769,2,96,2,15702.48,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(893,7485,247,40828,7769,2,67,2,3297.52,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(894,7485,247,40828,7769,2,13,1,19000.00,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(895,7485,248,40828,7769,2,96,2,10942.14,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(896,7485,248,40828,7769,2,67,2,2297.85,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(897,7485,248,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:29','2023-02-03 12:41:29',NULL),(898,7485,248,40828,7769,2,13,1,13240.00,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(899,7485,249,40828,7769,2,96,2,11404.95,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(900,7485,249,40828,7769,2,67,2,2395.04,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(901,7485,249,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(902,7485,249,40828,7769,2,13,1,13800.00,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(903,7485,250,40828,7769,2,96,2,20495.86,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(904,7485,250,40828,7769,2,67,2,4304.13,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(905,7485,250,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(906,7485,250,40828,7769,2,13,1,24800.00,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(907,7485,251,40828,7769,2,96,2,17677.67,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(908,7485,251,40828,7769,2,67,2,3712.31,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(909,7485,251,40828,7769,2,218,2,0.02,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(910,7485,251,40828,7769,2,13,1,21390.00,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL);
INSERT INTO `balance_libro_details` VALUES (911,7485,252,40828,7769,2,96,2,18429.76,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(912,7485,252,40828,7769,2,67,2,3870.25,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(913,7485,252,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(914,7485,252,40828,7769,2,13,1,22300.02,NULL,'2023-02-03 12:41:30','2023-02-03 12:41:30',NULL),(915,7485,253,40828,7769,2,96,2,16528.90,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(916,7485,253,40828,7769,2,67,2,3471.07,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(917,7485,253,40828,7769,2,218,2,0.03,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(918,7485,253,40828,7769,2,13,1,20000.00,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(919,7485,254,40828,7769,2,96,2,3074.38,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(920,7485,254,40828,7769,2,67,2,645.62,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(921,7485,254,40828,7769,2,13,1,3720.00,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(922,7485,255,40828,7769,2,96,2,11570.24,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(923,7485,255,40828,7769,2,67,2,2429.75,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(924,7485,255,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(925,7485,255,40828,7769,2,13,1,14000.00,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(926,7485,256,40828,7769,2,96,2,14161.14,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(927,7485,256,40828,7769,2,67,2,2973.84,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(928,7485,256,40828,7769,2,218,2,0.02,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(929,7485,256,40828,7769,2,13,1,17135.00,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(930,7485,257,40828,7769,2,96,2,16528.90,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(931,7485,257,40828,7769,2,67,2,3471.07,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(932,7485,257,40828,7769,2,218,2,0.03,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(933,7485,257,40828,7769,2,13,1,20000.00,NULL,'2023-02-03 12:41:31','2023-02-03 12:41:31',NULL),(934,7485,258,40828,7769,2,96,2,18719.00,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(935,7485,258,40828,7769,2,67,2,3930.99,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(936,7485,258,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(937,7485,258,40828,7769,2,13,1,22650.00,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(938,7485,259,40828,7769,2,96,2,18595.05,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(939,7485,259,40828,7769,2,67,2,3904.96,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(940,7485,259,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(941,7485,259,40828,7769,2,13,1,22500.02,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(942,7485,260,40828,7769,2,96,2,16528.90,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(943,7485,260,40828,7769,2,67,2,3471.07,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(944,7485,260,40828,7769,2,218,2,0.03,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(945,7485,260,40828,7769,2,13,1,20000.00,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(946,7485,261,40828,7769,2,96,2,3884.29,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(947,7485,261,40828,7769,2,67,2,815.70,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(948,7485,261,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(949,7485,261,40828,7769,2,13,1,4700.00,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(950,7485,262,40828,7769,2,96,2,18181.81,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(951,7485,262,40828,7769,2,67,2,3818.18,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(952,7485,262,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL);
INSERT INTO `balance_libro_details` VALUES (953,7485,262,40828,7769,2,13,1,22000.00,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(954,7485,263,40828,7769,2,96,2,23057.86,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(955,7485,263,40828,7769,2,67,2,4842.15,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(956,7485,263,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(957,7485,263,40828,7769,2,13,1,27900.02,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(958,7485,264,40828,7769,2,96,2,13438.05,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(959,7485,264,40828,7769,2,67,2,2821.99,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(960,7485,264,40828,7769,2,218,2,0.04,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(961,7485,264,40828,7769,2,13,1,16260.08,NULL,'2023-02-03 12:41:32','2023-02-03 12:41:32',NULL),(962,7485,265,40828,7769,2,96,2,18181.81,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(963,7485,265,40828,7769,2,67,2,3818.18,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(964,7485,265,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(965,7485,265,40828,7769,2,13,1,22000.00,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(966,7485,266,40828,7769,2,96,2,23281.00,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(967,7485,266,40828,7769,2,67,2,4889.01,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(968,7485,266,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(969,7485,266,40828,7769,2,13,1,28170.02,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(970,7485,267,40828,7769,2,96,2,18595.05,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(971,7485,267,40828,7769,2,67,2,3904.96,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(972,7485,267,40828,7769,2,218,2,0.01,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(973,7485,267,40828,7769,2,13,1,22500.02,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(974,7485,268,40828,7769,2,96,2,19628.14,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(975,7485,268,40828,7769,2,67,2,4121.91,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(976,7485,268,40828,7769,2,218,2,0.05,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(977,7485,268,40828,7769,2,13,1,23750.10,NULL,'2023-02-03 12:41:33','2023-02-03 12:41:33',NULL),(978,7485,269,40828,7769,2,96,2,61983.46,NULL,'2023-02-04 18:34:27','2023-02-04 18:35:18','2023-02-04 18:35:18'),(979,7485,269,40828,7769,2,67,2,13016.53,NULL,'2023-02-04 18:34:27','2023-02-04 18:35:18','2023-02-04 18:35:18'),(980,7485,269,40828,7769,2,218,2,0.01,NULL,'2023-02-04 18:34:27','2023-02-04 18:35:18','2023-02-04 18:35:18'),(981,7485,269,40828,7769,2,13,1,75000.00,NULL,'2023-02-04 18:34:27','2023-02-04 18:35:18','2023-02-04 18:35:18'),(982,7485,270,40828,7769,2,96,2,61983.46,NULL,'2023-02-04 18:35:18','2023-02-04 18:51:34','2023-02-04 18:51:34'),(983,7485,270,40828,7769,2,67,2,13016.53,NULL,'2023-02-04 18:35:18','2023-02-04 18:51:34','2023-02-04 18:51:34'),(984,7485,270,40828,7769,2,218,2,0.01,NULL,'2023-02-04 18:35:18','2023-02-04 18:51:34','2023-02-04 18:51:34'),(985,7485,270,40828,7769,2,13,1,75000.00,NULL,'2023-02-04 18:35:18','2023-02-04 18:51:34','2023-02-04 18:51:34'),(986,7485,271,40828,7769,3,250,2,465000.00,NULL,'2023-02-04 18:40:57','2023-02-05 18:12:10','2023-02-05 18:12:10'),(987,7485,271,40828,7769,3,57,1,465000.00,NULL,'2023-02-04 18:40:57','2023-02-05 18:12:10','2023-02-05 18:12:10'),(988,7485,272,40828,7769,2,96,2,61983.46,NULL,'2023-02-04 18:51:34','2023-02-04 18:58:05','2023-02-04 18:58:05'),(989,7485,272,40828,7769,2,67,2,13016.53,NULL,'2023-02-04 18:51:34','2023-02-04 18:58:05','2023-02-04 18:58:05'),(990,7485,272,40828,7769,2,218,2,0.01,NULL,'2023-02-04 18:51:34','2023-02-04 18:58:05','2023-02-04 18:58:05'),(991,7485,272,40828,7769,2,13,1,75000.00,NULL,'2023-02-04 18:51:34','2023-02-04 18:58:05','2023-02-04 18:58:05');
INSERT INTO `balance_libro_details` VALUES (992,7485,273,40828,7769,2,96,2,61983.47,NULL,'2023-02-04 18:52:12','2023-02-05 18:05:58','2023-02-05 18:05:58'),(993,7485,273,40828,7769,2,67,2,13016.53,NULL,'2023-02-04 18:52:12','2023-02-05 18:05:58','2023-02-05 18:05:58'),(994,7485,273,40828,7769,2,218,2,75000.00,NULL,'2023-02-04 18:52:12','2023-02-05 18:05:58','2023-02-05 18:05:58'),(995,7485,273,40828,7769,2,13,1,150000.00,NULL,'2023-02-04 18:52:12','2023-02-05 18:05:58','2023-02-05 18:05:58'),(996,7485,274,40828,7769,2,96,2,61983.46,NULL,'2023-02-04 18:58:05','2023-02-04 18:58:05',NULL),(997,7485,274,40828,7769,2,67,2,13016.53,NULL,'2023-02-04 18:58:05','2023-02-04 18:58:05',NULL),(998,7485,274,40828,7769,2,218,2,0.01,NULL,'2023-02-04 18:58:05','2023-02-04 18:58:05',NULL),(999,7485,274,40828,7769,2,13,1,75000.00,NULL,'2023-02-04 18:58:05','2023-02-04 18:58:05',NULL),(1000,7485,275,40828,7768,2,96,2,61983.46,NULL,'2023-02-04 18:58:21','2023-02-04 18:58:21',NULL),(1001,7485,275,40828,7768,2,67,2,13016.53,NULL,'2023-02-04 18:58:21','2023-02-04 18:58:21',NULL),(1002,7485,275,40828,7768,2,218,2,0.01,NULL,'2023-02-04 18:58:21','2023-02-04 18:58:21',NULL),(1003,7485,275,40828,7768,2,13,1,75000.00,NULL,'2023-02-04 18:58:21','2023-02-04 18:58:21',NULL),(1004,7485,276,40828,7769,2,96,2,6198.35,NULL,'2023-02-05 17:46:00','2023-02-05 17:47:12','2023-02-05 17:47:12'),(1005,7485,276,40828,7769,2,67,2,1301.65,NULL,'2023-02-05 17:46:00','2023-02-05 17:47:12','2023-02-05 17:47:12'),(1006,7485,276,40828,7769,2,13,1,7500.00,NULL,'2023-02-05 17:46:00','2023-02-05 17:47:12','2023-02-05 17:47:12'),(1007,7485,277,40828,7769,2,96,2,61983.47,NULL,'2023-02-05 17:47:12','2023-02-05 17:47:12',NULL),(1008,7485,277,40828,7769,2,67,2,13016.53,NULL,'2023-02-05 17:47:12','2023-02-05 17:47:12',NULL),(1009,7485,277,40828,7769,2,13,1,75000.00,NULL,'2023-02-05 17:47:12','2023-02-05 17:47:12',NULL),(1010,7485,278,40828,7769,3,250,2,465000.00,NULL,'2023-02-05 18:12:10','2023-02-06 15:32:04','2023-02-06 15:32:04'),(1011,7485,278,40828,7769,3,57,1,465000.00,NULL,'2023-02-05 18:12:10','2023-02-06 15:32:04','2023-02-06 15:32:04'),(1012,7485,279,40828,7769,3,250,2,2909.19,NULL,'2023-02-05 18:13:13','2023-02-05 18:35:31','2023-02-05 18:35:31'),(1013,7485,279,40828,7769,3,57,1,2909.19,NULL,'2023-02-05 18:13:13','2023-02-05 18:35:31','2023-02-05 18:35:31'),(1014,7485,280,40828,7769,3,250,2,2909.19,NULL,'2023-02-05 18:35:31','2023-02-06 15:39:45','2023-02-06 15:39:45'),(1015,7485,280,40828,7769,3,57,1,2909.19,NULL,'2023-02-05 18:35:31','2023-02-06 15:39:45','2023-02-06 15:39:45'),(1016,7485,281,40828,7769,3,250,2,465000.00,NULL,'2023-02-06 15:32:04','2023-02-06 15:32:04',NULL),(1017,7485,281,40828,7769,3,57,1,465000.00,NULL,'2023-02-06 15:32:04','2023-02-06 15:32:04',NULL),(1018,7485,282,40828,7769,3,250,2,2909.19,NULL,'2023-02-06 15:39:45','2023-02-06 15:39:45',NULL),(1019,7485,282,40828,7769,3,57,1,2909.19,NULL,'2023-02-06 15:39:45','2023-02-06 15:39:45',NULL),(1020,7485,283,40723,7767,3,217,1,2853.72,NULL,'2023-02-07 18:28:01','2023-02-07 18:28:01',NULL),(1021,7485,283,40723,7767,3,68,1,599.28,NULL,'2023-02-07 18:28:01','2023-02-07 18:28:01',NULL),(1022,7485,283,40723,7767,3,57,2,3453.00,NULL,'2023-02-07 18:28:01','2023-02-07 18:28:01',NULL),(1023,7485,284,40723,7767,3,217,1,1652.89,NULL,'2023-02-07 18:33:33','2023-02-07 18:33:33',NULL),(1024,7485,284,40723,7767,3,68,1,347.11,NULL,'2023-02-07 18:33:33','2023-02-07 18:33:33',NULL),(1025,7485,284,40723,7767,3,57,2,2000.00,NULL,'2023-02-07 18:33:33','2023-02-07 18:33:33',NULL),(1026,7485,285,40723,7767,3,217,1,6038.86,NULL,'2023-02-07 18:42:05','2023-02-07 18:42:05',NULL),(1027,7485,285,40723,7767,3,68,1,1268.16,NULL,'2023-02-07 18:42:05','2023-02-07 18:42:05',NULL),(1028,7485,285,40723,7767,3,217,1,896.00,NULL,'2023-02-07 18:42:05','2023-02-07 18:42:05',NULL),(1029,7485,285,40723,7767,3,225,1,379.99,NULL,'2023-02-07 18:42:05','2023-02-07 18:42:05',NULL),(1030,7485,285,40723,7767,3,57,2,8583.01,NULL,'2023-02-07 18:42:05','2023-02-07 18:42:05',NULL);
INSERT INTO `balance_libro_details` VALUES (1031,7485,286,40723,7767,3,217,1,5625.14,NULL,'2023-02-07 18:46:00','2023-02-07 18:46:00',NULL),(1032,7485,286,40723,7767,3,68,1,1181.28,NULL,'2023-02-07 18:46:00','2023-02-07 18:46:00',NULL),(1033,7485,286,40723,7767,3,217,1,894.42,NULL,'2023-02-07 18:46:00','2023-02-07 18:46:00',NULL),(1034,7485,286,40723,7767,3,57,2,7700.84,NULL,'2023-02-07 18:46:00','2023-02-07 18:46:00',NULL),(1035,7485,287,40723,7767,3,217,1,23205.52,NULL,'2023-02-07 19:29:59','2023-02-07 20:01:28','2023-02-07 20:01:28'),(1036,7485,287,40723,7767,3,68,1,4873.16,NULL,'2023-02-07 19:29:59','2023-02-07 20:01:28','2023-02-07 20:01:28'),(1037,7485,287,40723,7767,3,217,1,16140.66,NULL,'2023-02-07 19:29:59','2023-02-07 20:01:28','2023-02-07 20:01:28'),(1038,7485,287,40723,7767,3,68,1,1694.77,NULL,'2023-02-07 19:29:59','2023-02-07 20:01:28','2023-02-07 20:01:28'),(1039,7485,287,40723,7767,3,217,1,2628.38,NULL,'2023-02-07 19:29:59','2023-02-07 20:01:28','2023-02-07 20:01:28'),(1040,7485,287,40723,7767,3,57,2,48542.49,NULL,'2023-02-07 19:29:59','2023-02-07 20:01:28','2023-02-07 20:01:28'),(1041,7485,288,40723,7767,3,217,1,23205.52,NULL,'2023-02-07 20:01:28','2023-02-07 20:01:28',NULL),(1042,7485,288,40723,7767,3,68,1,4873.16,NULL,'2023-02-07 20:01:28','2023-02-07 20:01:28',NULL),(1043,7485,288,40723,7767,3,217,1,16140.66,NULL,'2023-02-07 20:01:28','2023-02-07 20:01:28',NULL),(1044,7485,288,40723,7767,3,68,1,1694.77,NULL,'2023-02-07 20:01:28','2023-02-07 20:01:28',NULL),(1045,7485,288,40723,7767,3,217,1,2628.38,NULL,'2023-02-07 20:01:28','2023-02-07 20:01:28',NULL),(1046,7485,288,40723,7767,3,57,2,48542.49,NULL,'2023-02-07 20:01:28','2023-02-07 20:01:28',NULL),(1047,7485,289,40723,6064,2,96,2,2853.72,NULL,'2023-02-08 22:58:55','2023-02-08 23:01:52','2023-02-08 23:01:52'),(1048,7485,289,40723,6064,2,67,2,599.28,NULL,'2023-02-08 22:58:55','2023-02-08 23:01:52','2023-02-08 23:01:52'),(1049,7485,289,40723,6064,2,13,1,3453.00,NULL,'2023-02-08 22:58:55','2023-02-08 23:01:52','2023-02-08 23:01:52'),(1050,7485,290,40723,6064,2,96,2,338.84,NULL,'2023-02-08 23:01:12','2023-02-08 23:01:12',NULL),(1051,7485,290,40723,6064,2,67,2,71.16,NULL,'2023-02-08 23:01:12','2023-02-08 23:01:12',NULL),(1052,7485,290,40723,6064,2,13,1,410.00,NULL,'2023-02-08 23:01:12','2023-02-08 23:01:12',NULL),(1053,7485,291,40723,6064,2,96,2,2853.72,NULL,'2023-02-08 23:01:52','2023-02-08 23:01:52',NULL),(1054,7485,291,40723,6064,2,67,2,599.28,NULL,'2023-02-08 23:01:52','2023-02-08 23:01:52',NULL),(1055,7485,291,40723,6064,2,13,1,3453.00,NULL,'2023-02-08 23:01:52','2023-02-08 23:01:52',NULL),(1056,7485,292,40720,1555,2,96,2,100743.86,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1057,7485,292,40720,1555,2,67,2,21156.21,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1058,7485,292,40720,1555,2,218,2,0.07,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1059,7485,292,40720,1555,2,13,1,121900.14,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1060,7485,293,40720,1555,2,96,2,170099.19,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1061,7485,293,40720,1555,2,67,2,35720.83,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1062,7485,293,40720,1555,2,218,2,0.02,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1063,7485,293,40720,1555,2,13,1,205820.04,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1064,7485,294,40720,1555,2,96,2,124958.67,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1065,7485,294,40720,1555,2,67,2,26241.32,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1066,7485,294,40720,1555,2,218,2,0.01,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1067,7485,294,40720,1555,2,13,1,151200.00,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20');
INSERT INTO `balance_libro_details` VALUES (1068,7485,295,40720,1555,2,96,2,218677.67,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1069,7485,295,40720,1555,2,67,2,45922.31,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1070,7485,295,40720,1555,2,218,2,0.02,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1071,7485,295,40720,1555,2,13,1,264600.00,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1072,7485,296,40720,1555,2,96,2,470562.00,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1073,7485,296,40720,1555,2,67,2,98818.02,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1074,7485,296,40720,1555,2,218,2,0.02,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1075,7485,296,40720,1555,2,13,1,569380.04,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1076,7485,297,40720,1555,2,96,2,264462.81,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1077,7485,297,40720,1555,2,67,2,55537.19,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1078,7485,297,40720,1555,2,13,1,320000.00,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1079,7485,298,40720,1555,2,96,2,67200.00,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1080,7485,298,40720,1555,2,67,2,14112.00,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1081,7485,298,40720,1555,2,13,1,81312.00,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1082,7485,299,40720,1555,2,96,2,53454.52,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1083,7485,299,40720,1555,2,67,2,11225.45,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1084,7485,299,40720,1555,2,218,2,0.03,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1085,7485,299,40720,1555,2,13,1,64680.00,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1086,7485,300,40720,1555,2,96,2,19090.90,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1087,7485,300,40720,1555,2,67,2,4009.09,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1088,7485,300,40720,1555,2,218,2,0.01,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1089,7485,300,40720,1555,2,13,1,23100.00,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1090,7485,301,40720,1555,2,96,2,123966.95,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1091,7485,301,40720,1555,2,67,2,26033.06,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1092,7485,301,40720,1555,2,218,2,0.01,NULL,'2023-02-19 16:54:24','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1093,7485,301,40720,1555,2,13,1,150000.02,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1094,7485,302,40720,1555,2,96,2,176776.86,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1095,7485,302,40720,1555,2,67,2,37123.14,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1096,7485,302,40720,1555,2,13,1,213900.00,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1097,7485,303,40720,1555,2,96,2,31404.95,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1098,7485,303,40720,1555,2,67,2,6595.04,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1099,7485,303,40720,1555,2,218,2,0.01,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1100,7485,303,40720,1555,2,13,1,38000.00,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1101,7485,304,40720,1555,2,96,2,47272.76,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1102,7485,304,40720,1555,2,67,2,9927.28,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20');
INSERT INTO `balance_libro_details` VALUES (1103,7485,304,40720,1555,2,218,2,0.04,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1104,7485,304,40720,1555,2,13,1,57200.08,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1105,7485,305,40720,1555,2,96,2,247933.90,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1106,7485,305,40720,1555,2,67,2,52066.12,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1107,7485,305,40720,1555,2,218,2,0.02,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1108,7485,305,40720,1555,2,13,1,300000.04,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1109,7485,306,40720,1555,2,96,2,32132.24,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1110,7485,306,40720,1555,2,67,2,6747.77,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1111,7485,306,40720,1555,2,218,2,0.01,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1112,7485,306,40720,1555,2,13,1,38880.02,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1113,7485,307,40720,1555,2,96,2,250000.00,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1114,7485,307,40720,1555,2,67,2,52500.00,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1115,7485,307,40720,1555,2,13,1,302500.00,NULL,'2023-02-19 16:54:25','2023-10-30 20:51:20','2023-10-30 20:51:20'),(1116,7485,308,40720,1555,3,217,1,43033.05,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1117,7485,308,40720,1555,3,68,1,9036.94,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1118,7485,308,40720,1555,3,217,1,0.01,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1119,7485,308,40720,1555,3,57,2,52070.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1120,7485,309,40720,1555,3,226,1,11441.94,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1121,7485,309,40720,1555,3,250,1,559229.50,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1122,7485,309,40720,1555,3,68,1,117438.20,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1123,7485,309,40720,1555,3,57,2,688109.64,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1124,7485,310,40720,1555,3,226,1,272.67,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1125,7485,310,40720,1555,3,220,1,163.60,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1126,7485,310,40720,1555,3,250,1,4073.40,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1127,7485,310,40720,1555,3,68,1,855.41,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1128,7485,310,40720,1555,3,250,1,1380.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1129,7485,310,40720,1555,3,68,1,372.60,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1130,7485,310,40720,1555,3,57,2,7117.68,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1131,7485,311,40720,1555,3,250,1,10600.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1132,7485,311,40720,1555,3,68,1,2226.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1133,7485,311,40720,1555,3,57,2,12826.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:09','2023-10-30 20:50:09'),(1134,7485,312,40720,1555,3,250,1,67879.44,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1135,7485,312,40720,1555,3,68,1,14254.68,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1136,7485,312,40720,1555,3,57,2,82134.12,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1137,7485,313,40720,1555,3,217,1,16000.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10');
INSERT INTO `balance_libro_details` VALUES (1138,7485,313,40720,1555,3,57,2,16000.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1139,7485,314,40720,1555,3,250,1,172500.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1140,7485,314,40720,1555,3,68,1,36225.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1141,7485,314,40720,1555,3,57,2,208725.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1142,7485,315,40720,1555,3,226,1,890.80,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1143,7485,315,40720,1555,3,220,1,334.05,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1144,7485,315,40720,1555,3,250,1,9245.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1145,7485,315,40720,1555,3,68,1,1941.45,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1146,7485,315,40720,1555,3,250,1,1890.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1147,7485,315,40720,1555,3,68,1,510.30,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1148,7485,315,40720,1555,3,57,2,14811.60,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1149,7485,316,40720,1555,3,217,1,150000.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1150,7485,316,40720,1555,3,57,2,150000.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1151,7485,317,40720,1555,3,250,1,11300.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1152,7485,317,40720,1555,3,68,1,2373.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1153,7485,317,40720,1555,3,57,2,13673.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1154,7485,318,40720,1555,3,217,1,84297.71,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1155,7485,318,40720,1555,3,68,1,17702.52,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1156,7485,318,40720,1555,3,217,1,0.04,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1157,7485,318,40720,1555,3,57,2,102000.27,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1158,7485,319,40720,1555,3,250,1,172500.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1159,7485,319,40720,1555,3,68,1,36225.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1160,7485,319,40720,1555,3,57,2,208725.00,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1161,7485,320,40720,1555,3,250,1,162211.71,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1162,7485,320,40720,1555,3,68,1,34064.46,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1163,7485,320,40720,1555,3,250,1,0.01,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1164,7485,320,40720,1555,3,57,2,196276.18,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1165,7485,321,40720,1555,3,226,1,18821.13,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1166,7485,321,40720,1555,3,250,1,716286.58,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1167,7485,321,40720,1555,3,68,1,150420.18,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1168,7485,321,40720,1555,3,57,2,885527.89,NULL,'2023-02-19 17:12:15','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1169,7485,322,40720,1555,3,226,1,8725.48,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1170,7485,322,40720,1555,3,250,1,290849.22,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1171,7485,322,40720,1555,3,68,1,61078.34,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1172,7485,322,40720,1555,3,57,2,360653.04,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10');
INSERT INTO `balance_libro_details` VALUES (1173,7485,323,40720,1555,3,217,1,121788.57,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1174,7485,323,40720,1555,3,68,1,25575.60,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1175,7485,323,40720,1555,3,217,1,0.01,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1176,7485,323,40720,1555,3,57,2,147364.18,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1177,7485,324,40720,1555,3,250,1,18148.76,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1178,7485,324,40720,1555,3,68,1,3811.24,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1179,7485,324,40720,1555,3,57,2,21960.00,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1180,7485,325,40720,1555,3,217,1,86610.00,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1181,7485,325,40720,1555,3,68,1,18188.10,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1182,7485,325,40720,1555,3,217,1,0.01,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1183,7485,325,40720,1555,3,57,2,104798.11,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1184,7485,326,40720,1555,3,250,1,82509.20,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1185,7485,326,40720,1555,3,68,1,17326.93,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1186,7485,326,40720,1555,3,57,2,99836.13,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1187,7485,327,40720,1555,3,250,1,5792.56,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1188,7485,327,40720,1555,3,68,1,1216.44,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1189,7485,327,40720,1555,3,57,2,7009.00,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1190,7485,328,40720,1555,3,250,1,187872.62,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1191,7485,328,40720,1555,3,68,1,39453.25,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1192,7485,328,40720,1555,3,250,1,0.02,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1193,7485,328,40720,1555,3,57,2,227325.89,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1194,7485,329,40720,1555,3,226,1,141.40,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1195,7485,329,40720,1555,3,250,1,2828.00,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1196,7485,329,40720,1555,3,68,1,593.88,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1197,7485,329,40720,1555,3,57,2,3563.28,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1198,7485,330,40720,1555,3,250,1,253821.62,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1199,7485,330,40720,1555,3,68,1,53302.54,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1200,7485,330,40720,1555,3,250,1,0.04,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1201,7485,330,40720,1555,3,57,2,307124.20,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1202,7485,331,40720,1555,3,217,1,75229.05,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1203,7485,331,40720,1555,3,68,1,15798.10,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1204,7485,331,40720,1555,3,217,1,0.01,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1205,7485,331,40720,1555,3,57,2,91027.16,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1206,7485,332,40720,1555,3,217,1,178726.48,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1207,7485,332,40720,1555,3,68,1,37532.56,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10');
INSERT INTO `balance_libro_details` VALUES (1208,7485,332,40720,1555,3,217,1,0.03,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1209,7485,332,40720,1555,3,57,2,216259.07,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1210,7485,333,40720,1555,3,250,1,100762.05,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1211,7485,333,40720,1555,3,68,1,21160.03,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1212,7485,333,40720,1555,3,250,1,0.03,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1213,7485,333,40720,1555,3,57,2,121922.11,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1214,7485,334,40720,1555,3,250,1,109042.74,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1215,7485,334,40720,1555,3,68,1,22898.97,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1216,7485,334,40720,1555,3,57,2,131941.71,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1217,7485,335,40720,1555,3,217,1,247933.90,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1218,7485,335,40720,1555,3,68,1,52066.12,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1219,7485,335,40720,1555,3,217,1,0.02,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1220,7485,335,40720,1555,3,57,2,300000.04,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1221,7485,336,40720,1555,3,250,1,36584.14,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1222,7485,336,40720,1555,3,68,1,7682.67,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1223,7485,336,40720,1555,3,57,2,44266.81,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1224,7485,337,40720,1555,3,217,1,30650.00,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1225,7485,337,40720,1555,3,57,2,30650.00,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1226,7485,338,40720,1555,3,217,1,50000.00,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1227,7485,338,40720,1555,3,57,2,50000.00,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1228,7485,339,40720,1555,3,226,1,20117.32,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1229,7485,339,40720,1555,3,250,1,670577.45,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1230,7485,339,40720,1555,3,68,1,140821.26,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1231,7485,339,40720,1555,3,57,2,831516.03,NULL,'2023-02-19 17:12:16','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1232,7485,340,40720,1555,3,217,1,1600.00,NULL,'2023-02-19 17:24:59','2023-02-19 17:50:10','2023-02-19 17:50:10'),(1233,7485,340,40720,1555,3,68,1,336.00,NULL,'2023-02-19 17:24:59','2023-02-19 17:50:10','2023-02-19 17:50:10'),(1234,7485,340,40720,1555,3,220,1,80.00,NULL,'2023-02-19 17:24:59','2023-02-19 17:50:10','2023-02-19 17:50:10'),(1235,7485,340,40720,1555,3,57,2,2016.00,NULL,'2023-02-19 17:24:59','2023-02-19 17:50:10','2023-02-19 17:50:10'),(1236,7485,341,40720,1555,3,217,1,600.00,NULL,'2023-02-19 17:28:20','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1237,7485,341,40720,1555,3,68,1,126.00,NULL,'2023-02-19 17:28:20','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1238,7485,341,40720,1555,3,57,2,726.00,NULL,'2023-02-19 17:28:20','2023-10-30 20:50:10','2023-10-30 20:50:10'),(1239,7485,342,40720,1555,3,217,1,300.00,NULL,'2023-02-19 17:29:43','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1240,7485,342,40720,1555,3,68,1,63.00,NULL,'2023-02-19 17:29:43','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1241,7485,342,40720,1555,3,57,2,363.00,NULL,'2023-02-19 17:29:43','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1242,7485,343,40720,1555,3,217,1,600.00,NULL,'2023-02-19 17:30:11','2023-10-30 20:50:11','2023-10-30 20:50:11');
INSERT INTO `balance_libro_details` VALUES (1243,7485,343,40720,1555,3,68,1,126.00,NULL,'2023-02-19 17:30:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1244,7485,343,40720,1555,3,57,2,726.00,NULL,'2023-02-19 17:30:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1245,7485,344,40720,1555,3,217,1,300.00,NULL,'2023-02-19 17:30:44','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1246,7485,344,40720,1555,3,68,1,63.00,NULL,'2023-02-19 17:30:44','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1247,7485,344,40720,1555,3,57,2,363.00,NULL,'2023-02-19 17:30:44','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1248,7485,345,40720,1555,3,217,1,300.00,NULL,'2023-02-19 17:33:06','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1249,7485,345,40720,1555,3,68,1,63.00,NULL,'2023-02-19 17:33:06','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1250,7485,345,40720,1555,3,57,2,363.00,NULL,'2023-02-19 17:33:06','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1251,7485,346,40720,1555,3,217,1,90.00,NULL,'2023-02-19 17:33:37','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1252,7485,346,40720,1555,3,68,1,18.90,NULL,'2023-02-19 17:33:37','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1253,7485,346,40720,1555,3,57,2,108.90,NULL,'2023-02-19 17:33:37','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1254,7485,347,40720,1555,3,217,1,600.00,NULL,'2023-02-19 17:34:23','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1255,7485,347,40720,1555,3,68,1,126.00,NULL,'2023-02-19 17:34:23','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1256,7485,347,40720,1555,3,57,2,726.00,NULL,'2023-02-19 17:34:23','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1257,7485,348,40720,1555,3,217,1,600.00,NULL,'2023-02-19 17:34:50','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1258,7485,348,40720,1555,3,68,1,126.00,NULL,'2023-02-19 17:34:50','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1259,7485,348,40720,1555,3,57,2,726.00,NULL,'2023-02-19 17:34:50','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1260,7485,349,40720,1555,3,217,1,600.00,NULL,'2023-02-19 17:36:25','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1261,7485,349,40720,1555,3,68,1,126.00,NULL,'2023-02-19 17:36:25','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1262,7485,349,40720,1555,3,57,2,726.00,NULL,'2023-02-19 17:36:25','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1263,7485,350,40720,1555,3,217,1,9000.00,NULL,'2023-02-19 17:38:29','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1264,7485,350,40720,1555,3,68,1,1890.00,NULL,'2023-02-19 17:38:29','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1265,7485,350,40720,1555,3,220,1,270.00,NULL,'2023-02-19 17:38:29','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1266,7485,350,40720,1555,3,225,1,450.00,NULL,'2023-02-19 17:38:29','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1267,7485,350,40720,1555,3,57,2,11610.00,NULL,'2023-02-19 17:38:29','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1268,7485,351,40720,1555,3,217,1,9255.00,NULL,'2023-02-19 17:43:06','2023-02-19 17:47:28','2023-02-19 17:47:28'),(1269,7485,351,40720,1555,3,68,1,1943.55,NULL,'2023-02-19 17:43:06','2023-02-19 17:47:28','2023-02-19 17:47:28'),(1270,7485,351,40720,1555,3,220,1,277.65,NULL,'2023-02-19 17:43:06','2023-02-19 17:47:28','2023-02-19 17:47:28'),(1271,7485,351,40720,1555,3,226,1,462.75,NULL,'2023-02-19 17:43:06','2023-02-19 17:47:28','2023-02-19 17:47:28'),(1272,7485,351,40720,1555,3,57,2,11938.95,NULL,'2023-02-19 17:43:06','2023-02-19 17:47:28','2023-02-19 17:47:28'),(1273,7485,352,40720,1555,3,217,1,2400.00,NULL,'2023-02-19 17:45:48','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1274,7485,352,40720,1555,3,68,1,504.00,NULL,'2023-02-19 17:45:48','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1275,7485,352,40720,1555,3,220,1,72.00,NULL,'2023-02-19 17:45:48','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1276,7485,352,40720,1555,3,57,2,2976.00,NULL,'2023-02-19 17:45:48','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1277,7485,353,40720,1555,3,217,1,9255.00,NULL,'2023-02-19 17:47:28','2023-10-30 20:50:11','2023-10-30 20:50:11');
INSERT INTO `balance_libro_details` VALUES (1278,7485,353,40720,1555,3,68,1,1943.55,NULL,'2023-02-19 17:47:28','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1279,7485,353,40720,1555,3,220,1,277.65,NULL,'2023-02-19 17:47:28','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1280,7485,353,40720,1555,3,226,1,462.75,NULL,'2023-02-19 17:47:28','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1281,7485,353,40720,1555,3,57,2,11938.95,NULL,'2023-02-19 17:47:28','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1282,7485,354,40720,1555,3,217,1,1600.00,NULL,'2023-02-19 17:56:56','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1283,7485,354,40720,1555,3,68,1,336.00,NULL,'2023-02-19 17:56:56','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1284,7485,354,40720,1555,3,226,1,80.00,NULL,'2023-02-19 17:56:56','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1285,7485,354,40720,1555,3,57,2,2016.00,NULL,'2023-02-19 17:56:56','2023-10-30 20:50:11','2023-10-30 20:50:11'),(1286,7485,355,40828,7770,3,217,1,2499.91,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1287,7485,355,40828,7770,3,57,2,2499.91,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1288,7485,356,40828,7770,3,225,1,211.00,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1289,7485,356,40828,7770,3,250,1,6550.00,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1290,7485,356,40828,7770,3,68,1,1375.50,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1291,7485,356,40828,7770,3,250,1,1890.00,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1292,7485,356,40828,7770,3,68,1,510.30,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1293,7485,356,40828,7770,3,57,2,10536.80,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1294,7485,357,40828,7770,3,225,1,1173.36,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1295,7485,357,40828,7770,3,250,1,46934.35,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1296,7485,357,40828,7770,3,68,1,9856.21,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1297,7485,357,40828,7770,3,57,2,57963.92,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1298,7485,358,40828,7770,3,217,1,58183.80,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1299,7485,358,40828,7770,3,57,2,58183.80,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1300,7485,359,40828,7770,3,225,1,3488.80,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1301,7485,359,40828,7770,3,250,1,139552.07,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1302,7485,359,40828,7770,3,68,1,29305.93,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1303,7485,359,40828,7770,3,57,2,172346.80,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1304,7485,360,40828,7770,3,225,1,75.32,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1305,7485,360,40828,7770,3,250,1,2000.00,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1306,7485,360,40828,7770,3,68,1,420.00,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1307,7485,360,40828,7770,3,250,1,1012.60,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1308,7485,360,40828,7770,3,68,1,273.40,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1309,7485,360,40828,7770,3,57,2,3781.32,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1310,7485,361,40828,7770,3,221,1,799.27,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1311,7485,361,40828,7770,3,250,1,7776.78,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1312,7485,361,40828,7770,3,68,1,1633.12,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1313,7485,361,40828,7770,3,57,2,10209.17,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1314,7485,362,40828,7770,3,225,1,309.63,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1315,7485,362,40828,7770,3,250,1,12385.09,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1316,7485,362,40828,7770,3,68,1,2600.86,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1317,7485,362,40828,7770,3,57,2,15295.58,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1318,7485,363,40828,7770,3,225,1,1954.81,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1319,7485,363,40828,7770,3,250,1,78192.39,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1320,7485,363,40828,7770,3,68,1,16420.40,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1321,7485,363,40828,7770,3,57,2,96567.60,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1322,7485,364,40828,7770,3,250,2,495.40,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1323,7485,364,40828,7770,3,67,2,104.03,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1324,7485,364,40828,7770,3,57,1,599.43,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1325,7485,365,40828,7770,3,250,2,6255.39,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1326,7485,365,40828,7770,3,67,2,1313.63,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1327,7485,365,40828,7770,3,57,1,7569.02,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1328,7485,366,40828,7770,3,221,1,28.03,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1329,7485,366,40828,7770,3,250,1,1121.09,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1330,7485,366,40828,7770,3,68,1,235.43,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1331,7485,366,40828,7770,3,57,2,1384.55,NULL,'2023-03-17 17:34:51','2023-03-17 17:34:51',NULL),(1428,7485,391,40828,7770,2,96,2,61983.48,NULL,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(1429,7485,391,40828,7770,2,67,2,13016.53,NULL,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(1430,7485,391,40828,7770,2,218,2,0.01,NULL,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(1431,7485,391,40828,7770,2,13,1,75000.02,NULL,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(1432,7485,392,40828,7770,2,96,2,61983.48,NULL,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(1433,7485,392,40828,7770,2,67,2,13016.53,NULL,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(1434,7485,392,40828,7770,2,218,2,0.01,NULL,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(1435,7485,392,40828,7770,2,13,1,75000.02,NULL,'2023-03-17 19:40:49','2023-03-17 19:40:49',NULL),(1436,7485,393,40828,7770,2,96,2,61983.48,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1437,7485,393,40828,7770,2,67,2,13016.53,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1438,7485,393,40828,7770,2,218,2,0.01,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1439,7485,393,40828,7770,2,13,1,75000.02,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1440,7485,394,40828,7770,2,96,2,61983.48,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1441,7485,394,40828,7770,2,67,2,13016.53,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1442,7485,394,40828,7770,2,218,2,0.01,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1443,7485,394,40828,7770,2,13,1,75000.02,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1444,7485,395,40828,7770,2,96,2,25206.67,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1445,7485,395,40828,7770,2,67,2,5293.40,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1446,7485,395,40828,7770,2,218,2,0.07,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1447,7485,395,40828,7770,2,13,1,30500.14,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1448,7485,396,40828,7770,2,96,2,68950.43,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1449,7485,396,40828,7770,2,67,2,14479.59,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1450,7485,396,40828,7770,2,218,2,0.02,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1451,7485,396,40828,7770,2,13,1,83430.04,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1452,7485,397,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1453,7485,397,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1454,7485,397,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1455,7485,398,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1456,7485,398,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1457,7485,398,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1458,7485,399,40828,7770,2,96,2,23966.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1459,7485,399,40828,7770,2,67,2,5033.05,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1460,7485,399,40828,7770,2,218,2,0.05,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1461,7485,399,40828,7770,2,13,1,29000.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1462,7485,400,40828,7770,2,96,2,14165.29,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1463,7485,400,40828,7770,2,67,2,2974.71,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1464,7485,400,40828,7770,2,13,1,17140.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1465,7485,401,40828,7770,2,96,2,24008.24,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1466,7485,401,40828,7770,2,67,2,5041.73,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1467,7485,401,40828,7770,2,218,2,0.03,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1468,7485,401,40828,7770,2,13,1,29050.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1469,7485,402,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1470,7485,402,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1471,7485,402,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1472,7485,403,40828,7770,2,96,2,20661.14,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1473,7485,403,40828,7770,2,67,2,4338.84,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1474,7485,403,40828,7770,2,218,2,0.02,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1475,7485,403,40828,7770,2,13,1,25000.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1476,7485,404,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1477,7485,404,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1478,7485,404,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1479,7485,405,40828,7770,2,96,2,1818.19,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1480,7485,405,40828,7770,2,67,2,381.82,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1481,7485,405,40828,7770,2,218,2,0.01,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1482,7485,405,40828,7770,2,13,1,2200.02,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1483,7485,406,40828,7770,2,96,2,50661.19,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1484,7485,406,40828,7770,2,67,2,10638.85,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1485,7485,406,40828,7770,2,218,2,0.04,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1486,7485,406,40828,7770,2,13,1,61300.08,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1487,7485,407,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1488,7485,407,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1489,7485,407,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1490,7485,408,40828,7770,2,96,2,23471.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1491,7485,408,40828,7770,2,67,2,4928.93,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1492,7485,408,40828,7770,2,218,2,0.03,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1493,7485,408,40828,7770,2,13,1,28400.06,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1494,7485,409,40828,7770,2,96,2,21694.24,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1495,7485,409,40828,7770,2,67,2,4555.79,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1496,7485,409,40828,7770,2,218,2,0.03,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1497,7485,409,40828,7770,2,13,1,26250.06,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1498,7485,410,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1499,7485,410,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1500,7485,410,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1501,7485,411,40828,7770,2,96,2,24793.38,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1502,7485,411,40828,7770,2,67,2,5206.61,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1503,7485,411,40828,7770,2,218,2,0.01,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1504,7485,411,40828,7770,2,13,1,30000.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1505,7485,412,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1506,7485,412,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1507,7485,412,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1508,7485,413,40828,7770,2,96,2,21694.24,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1509,7485,413,40828,7770,2,67,2,4555.79,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1510,7485,413,40828,7770,2,218,2,0.03,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1511,7485,413,40828,7770,2,13,1,26250.06,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1512,7485,414,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1513,7485,414,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1514,7485,414,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1515,7485,415,40828,7770,2,96,2,23140.48,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1516,7485,415,40828,7770,2,67,2,4859.50,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1517,7485,415,40828,7770,2,218,2,0.02,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1518,7485,415,40828,7770,2,13,1,28000.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1519,7485,416,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1520,7485,416,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1521,7485,416,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1522,7485,417,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1523,7485,417,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1524,7485,417,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:50','2023-03-17 19:40:50',NULL),(1525,7485,418,40828,7770,2,96,2,21694.24,NULL,'2023-03-17 19:40:50','2023-04-18 16:29:25','2023-04-18 16:29:25'),(1526,7485,418,40828,7770,2,67,2,4555.79,NULL,'2023-03-17 19:40:50','2023-04-18 16:29:25','2023-04-18 16:29:25'),(1527,7485,418,40828,7770,2,218,2,0.03,NULL,'2023-03-17 19:40:50','2023-04-18 16:29:25','2023-04-18 16:29:25'),(1528,7485,418,40828,7770,2,13,1,26250.06,NULL,'2023-03-17 19:40:50','2023-04-18 16:29:25','2023-04-18 16:29:25'),(1529,7485,419,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:51','2023-04-18 16:23:02','2023-04-18 16:23:02'),(1530,7485,419,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:51','2023-04-18 16:23:02','2023-04-18 16:23:02'),(1531,7485,419,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:51','2023-04-18 16:23:02','2023-04-18 16:23:02'),(1532,7485,420,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:51','2023-04-18 16:22:43','2023-04-18 16:22:43'),(1533,7485,420,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:51','2023-04-18 16:22:43','2023-04-18 16:22:43'),(1534,7485,420,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:51','2023-04-18 16:22:43','2023-04-18 16:22:43');
INSERT INTO `balance_libro_details` VALUES (1535,7485,421,40828,7770,2,96,2,24380.14,NULL,'2023-03-17 19:40:51','2023-04-18 16:22:13','2023-04-18 16:22:13'),(1536,7485,421,40828,7770,2,67,2,5119.83,NULL,'2023-03-17 19:40:51','2023-04-18 16:22:13','2023-04-18 16:22:13'),(1537,7485,421,40828,7770,2,218,2,0.03,NULL,'2023-03-17 19:40:51','2023-04-18 16:22:13','2023-04-18 16:22:13'),(1538,7485,421,40828,7770,2,13,1,29500.00,NULL,'2023-03-17 19:40:51','2023-04-18 16:22:13','2023-04-18 16:22:13'),(1539,7485,422,40828,7770,2,96,2,24793.38,NULL,'2023-03-17 19:40:51','2023-04-18 16:21:47','2023-04-18 16:21:47'),(1540,7485,422,40828,7770,2,67,2,5206.61,NULL,'2023-03-17 19:40:51','2023-04-18 16:21:47','2023-04-18 16:21:47'),(1541,7485,422,40828,7770,2,218,2,0.01,NULL,'2023-03-17 19:40:51','2023-04-18 16:21:47','2023-04-18 16:21:47'),(1542,7485,422,40828,7770,2,13,1,30000.00,NULL,'2023-03-17 19:40:51','2023-04-18 16:21:47','2023-04-18 16:21:47'),(1543,7485,423,40828,7770,2,96,2,24793.38,NULL,'2023-03-17 19:40:51','2023-04-18 16:21:24','2023-04-18 16:21:24'),(1544,7485,423,40828,7770,2,67,2,5206.61,NULL,'2023-03-17 19:40:51','2023-04-18 16:21:24','2023-04-18 16:21:24'),(1545,7485,423,40828,7770,2,218,2,0.01,NULL,'2023-03-17 19:40:51','2023-04-18 16:21:24','2023-04-18 16:21:24'),(1546,7485,423,40828,7770,2,13,1,30000.00,NULL,'2023-03-17 19:40:51','2023-04-18 16:21:24','2023-04-18 16:21:24'),(1547,7485,424,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:51','2023-04-18 16:18:50','2023-04-18 16:18:50'),(1548,7485,424,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:51','2023-04-18 16:18:50','2023-04-18 16:18:50'),(1549,7485,424,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:51','2023-04-18 16:18:50','2023-04-18 16:18:50'),(1550,7485,425,40828,7770,2,96,2,37933.90,NULL,'2023-03-17 19:40:51','2023-04-18 16:19:20','2023-04-18 16:19:20'),(1551,7485,425,40828,7770,2,67,2,7966.12,NULL,'2023-03-17 19:40:51','2023-04-18 16:19:20','2023-04-18 16:19:20'),(1552,7485,425,40828,7770,2,218,2,0.02,NULL,'2023-03-17 19:40:51','2023-04-18 16:19:20','2023-04-18 16:19:20'),(1553,7485,425,40828,7770,2,13,1,45900.04,NULL,'2023-03-17 19:40:51','2023-04-18 16:19:20','2023-04-18 16:19:20'),(1554,7485,426,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:51','2023-04-18 16:18:09','2023-04-18 16:18:09'),(1555,7485,426,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:51','2023-04-18 16:18:09','2023-04-18 16:18:09'),(1556,7485,426,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:51','2023-04-18 16:18:09','2023-04-18 16:18:09'),(1557,7485,427,40828,7770,2,96,2,24793.38,NULL,'2023-03-17 19:40:51','2023-04-18 16:17:44','2023-04-18 16:17:44'),(1558,7485,427,40828,7770,2,67,2,5206.61,NULL,'2023-03-17 19:40:51','2023-04-18 16:17:44','2023-04-18 16:17:44'),(1559,7485,427,40828,7770,2,218,2,0.01,NULL,'2023-03-17 19:40:51','2023-04-18 16:17:44','2023-04-18 16:17:44'),(1560,7485,427,40828,7770,2,13,1,30000.00,NULL,'2023-03-17 19:40:51','2023-04-18 16:17:44','2023-04-18 16:17:44'),(1561,7485,428,40828,7770,2,96,2,25371.90,NULL,'2023-03-17 19:40:51','2023-04-18 16:17:10','2023-04-18 16:17:10'),(1562,7485,428,40828,7770,2,67,2,5328.10,NULL,'2023-03-17 19:40:51','2023-04-18 16:17:10','2023-04-18 16:17:10'),(1563,7485,428,40828,7770,2,13,1,30700.00,NULL,'2023-03-17 19:40:51','2023-04-18 16:17:10','2023-04-18 16:17:10'),(1680,7485,462,40723,6065,2,96,2,9701.00,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1681,7485,462,40723,6065,2,67,2,2037.21,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1682,7485,462,40723,6065,2,218,2,0.01,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1683,7485,462,40723,6065,2,13,1,11738.22,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1684,7485,463,40723,6065,2,96,2,878827.05,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1685,7485,463,40723,6065,2,67,2,184553.68,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1686,7485,463,40723,6065,2,218,2,0.04,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1687,7485,463,40723,6065,2,13,1,1063380.77,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1688,7485,464,40723,6065,2,96,2,59471.14,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1689,7485,464,40723,6065,2,67,2,12488.94,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1690,7485,464,40723,6065,2,218,2,0.01,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1691,7485,464,40723,6065,2,13,1,71960.09,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1692,7485,465,40723,6065,2,96,2,5226.00,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1693,7485,465,40723,6065,2,67,2,1097.46,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1694,7485,465,40723,6065,2,13,1,6323.46,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1695,7485,466,40723,6065,2,96,2,2927.71,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1696,7485,466,40723,6065,2,67,2,614.82,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1697,7485,466,40723,6065,2,218,2,0.01,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1698,7485,466,40723,6065,2,13,1,3542.54,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1699,7485,467,40723,6065,2,96,2,181022.95,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1700,7485,467,40723,6065,2,67,2,38014.82,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1701,7485,467,40723,6065,2,218,2,0.03,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1702,7485,467,40723,6065,2,13,1,219037.80,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1703,7485,468,40723,6065,2,96,2,863944.29,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1704,7485,468,40723,6065,2,67,2,181428.30,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1705,7485,468,40723,6065,2,218,2,0.03,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1706,7485,468,40723,6065,2,13,1,1045372.62,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1707,7485,469,40723,6065,2,96,2,14967.29,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1708,7485,469,40723,6065,2,67,2,3143.13,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1709,7485,469,40723,6065,2,218,2,0.02,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1710,7485,469,40723,6065,2,13,1,18110.44,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1711,7485,470,40723,6065,2,96,2,2896.67,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1712,7485,470,40723,6065,2,67,2,608.30,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1713,7485,470,40723,6065,2,218,2,0.02,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1714,7485,470,40723,6065,2,13,1,3504.99,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1715,7485,471,40723,6065,2,96,2,16546.86,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1716,7485,471,40723,6065,2,67,2,3474.84,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1717,7485,471,40723,6065,2,218,2,0.02,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1718,7485,471,40723,6065,2,13,1,20021.72,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1719,7485,472,40723,6065,2,96,2,3144.57,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1720,7485,472,40723,6065,2,67,2,660.36,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1721,7485,472,40723,6065,2,218,2,0.02,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1722,7485,472,40723,6065,2,13,1,3804.95,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1723,7485,473,40723,6065,2,96,2,167966.29,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1724,7485,473,40723,6065,2,67,2,35272.92,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1725,7485,473,40723,6065,2,218,2,0.03,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1726,7485,473,40723,6065,2,13,1,203239.24,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1727,7485,474,40723,6065,2,96,2,8273.43,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1728,7485,474,40723,6065,2,67,2,1737.42,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1729,7485,474,40723,6065,2,218,2,0.01,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1730,7485,474,40723,6065,2,13,1,10010.86,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1731,7485,475,40723,6065,2,96,2,371618.81,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1732,7485,475,40723,6065,2,67,2,78039.95,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1733,7485,475,40723,6065,2,218,2,0.09,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1734,7485,475,40723,6065,2,13,1,449658.85,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1735,7485,476,40723,6065,2,96,1,16546.86,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1736,7485,476,40723,6065,2,68,1,3474.84,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1737,7485,476,40723,6065,2,218,1,0.02,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1738,7485,476,40723,6065,2,13,2,20021.72,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1739,7485,477,40723,6065,2,96,2,118436.00,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1740,7485,477,40723,6065,2,67,2,24871.56,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1741,7485,477,40723,6065,2,13,1,143307.56,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1742,7485,478,40723,6065,2,96,2,9996.76,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1743,7485,478,40723,6065,2,67,2,2099.32,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1744,7485,478,40723,6065,2,218,2,0.02,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1745,7485,478,40723,6065,2,13,1,12096.10,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1746,7485,479,40723,6065,2,96,2,19891.81,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1747,7485,479,40723,6065,2,67,2,4177.28,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1748,7485,479,40723,6065,2,218,2,0.01,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1749,7485,479,40723,6065,2,13,1,24069.10,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1750,7485,480,40723,6065,2,96,2,33623.19,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1751,7485,480,40723,6065,2,67,2,7060.87,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1752,7485,480,40723,6065,2,218,2,0.01,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1753,7485,480,40723,6065,2,13,1,40684.07,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1754,7485,481,40723,6065,2,96,2,762.10,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1755,7485,481,40723,6065,2,67,2,160.04,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1756,7485,481,40723,6065,2,218,2,0.02,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1757,7485,481,40723,6065,2,13,1,922.16,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1758,7485,482,40723,6065,2,96,2,125542.00,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1759,7485,482,40723,6065,2,67,2,26363.82,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1760,7485,482,40723,6065,2,218,2,0.04,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1761,7485,482,40723,6065,2,13,1,151905.86,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1762,7485,483,40723,6065,2,96,1,118436.00,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1763,7485,483,40723,6065,2,68,1,24871.56,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1764,7485,483,40723,6065,2,218,1,0.04,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1765,7485,483,40723,6065,2,13,2,143307.60,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1766,7485,484,40723,6065,2,96,2,2245.29,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1767,7485,484,40723,6065,2,67,2,471.51,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1768,7485,484,40723,6065,2,218,2,0.02,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1769,7485,484,40723,6065,2,13,1,2716.82,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1770,7485,485,40723,6065,2,96,2,572032.29,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1771,7485,485,40723,6065,2,67,2,120126.78,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1772,7485,485,40723,6065,2,218,2,0.04,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1773,7485,485,40723,6065,2,13,1,692159.11,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1774,7485,486,40723,6065,2,96,2,116515.76,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1775,7485,486,40723,6065,2,67,2,24468.31,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1776,7485,486,40723,6065,2,218,2,0.03,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1777,7485,486,40723,6065,2,13,1,140984.10,NULL,'2023-03-19 14:49:04','2023-03-19 14:49:04',NULL),(1778,7485,487,40723,6065,2,96,2,126245.19,NULL,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(1779,7485,487,40723,6065,2,67,2,26511.49,NULL,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(1780,7485,487,40723,6065,2,218,2,0.02,NULL,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(1781,7485,487,40723,6065,2,13,1,152756.70,NULL,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(1782,7485,488,40723,6065,2,96,2,14795.19,NULL,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(1783,7485,488,40723,6065,2,67,2,3106.99,NULL,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(1784,7485,488,40723,6065,2,218,2,0.02,NULL,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(1785,7485,488,40723,6065,2,13,1,17902.20,NULL,'2023-03-19 14:49:05','2023-03-19 14:49:05',NULL),(1902,7485,522,40723,6065,3,250,1,5321.55,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1903,7485,522,40723,6065,3,68,1,1117.53,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1904,7485,522,40723,6065,3,57,2,6439.08,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1905,7485,523,40723,6065,3,217,1,57293.62,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1906,7485,523,40723,6065,3,68,1,12031.66,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1907,7485,523,40723,6065,3,217,1,0.02,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1908,7485,523,40723,6065,3,57,2,69325.30,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1909,7485,524,40723,6065,3,221,1,1408.25,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1910,7485,524,40723,6065,3,250,1,35206.13,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1911,7485,524,40723,6065,3,68,1,7393.29,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1912,7485,524,40723,6065,3,57,2,44007.67,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1913,7485,525,40723,6065,3,221,1,137.86,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1914,7485,525,40723,6065,3,217,1,1680.14,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1915,7485,525,40723,6065,3,57,2,1818.00,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1916,7485,526,40723,6065,3,217,1,204.00,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1917,7485,526,40723,6065,3,57,2,204.00,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1918,7485,527,40723,6065,3,217,1,285.00,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1919,7485,527,40723,6065,3,57,2,285.00,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1920,7485,528,40723,6065,3,250,1,69421.52,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1921,7485,528,40723,6065,3,68,1,14578.52,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1922,7485,528,40723,6065,3,250,1,0.02,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1923,7485,528,40723,6065,3,57,2,84000.06,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1924,7485,529,40723,6065,3,225,1,104872.36,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1925,7485,529,40723,6065,3,250,1,2621808.92,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1926,7485,529,40723,6065,3,68,1,550579.87,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1927,7485,529,40723,6065,3,57,2,3277261.15,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1928,7485,530,40723,6065,3,250,1,3181.82,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1929,7485,530,40723,6065,3,68,1,668.18,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1930,7485,530,40723,6065,3,57,2,3850.00,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1931,7485,531,40723,6065,3,225,1,8316.51,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1932,7485,531,40723,6065,3,250,1,207912.77,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1933,7485,531,40723,6065,3,68,1,43661.68,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1934,7485,531,40723,6065,3,57,2,259890.96,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1935,7485,532,40723,6065,3,225,1,4645.45,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1936,7485,532,40723,6065,3,250,1,116136.27,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1937,7485,532,40723,6065,3,68,1,24388.62,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1938,7485,532,40723,6065,3,57,2,145170.34,NULL,'2023-03-19 14:56:07','2023-03-19 14:56:07',NULL),(1939,7485,533,40723,6065,3,225,1,443.75,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1940,7485,533,40723,6065,3,250,1,11093.63,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1941,7485,533,40723,6065,3,68,1,2329.66,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1942,7485,533,40723,6065,3,57,2,13867.04,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1943,7485,534,40723,6065,3,250,2,3181.82,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1944,7485,534,40723,6065,3,67,2,668.18,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1945,7485,534,40723,6065,3,57,1,3850.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1946,7485,535,40723,6065,3,217,1,2809.90,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1947,7485,535,40723,6065,3,68,1,590.08,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1948,7485,535,40723,6065,3,217,1,0.02,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1949,7485,535,40723,6065,3,57,2,3400.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1950,7485,536,40723,6065,3,225,1,332.81,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1951,7485,536,40723,6065,3,250,1,8320.22,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1952,7485,536,40723,6065,3,68,1,1747.25,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1953,7485,536,40723,6065,3,57,2,10400.28,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1954,7485,537,40723,6065,3,250,1,52359.52,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1955,7485,537,40723,6065,3,68,1,10995.50,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1956,7485,537,40723,6065,3,57,2,63355.02,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1957,7485,538,40723,6065,3,221,1,1698.47,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1958,7485,538,40723,6065,3,250,1,6881.46,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1959,7485,538,40723,6065,3,68,1,722.55,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1960,7485,538,40723,6065,3,250,1,18111.65,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1961,7485,538,40723,6065,3,68,1,3803.45,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1962,7485,538,40723,6065,3,57,2,31217.58,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1963,7485,539,40723,6065,3,221,1,2333.69,NULL,'2023-03-19 14:56:08','2023-03-23 10:12:06','2023-03-23 10:12:06'),(1964,7485,539,40723,6065,3,225,1,381.09,NULL,'2023-03-19 14:56:08','2023-03-23 10:12:06','2023-03-23 10:12:06'),(1965,7485,539,40723,6065,3,250,1,6995.52,NULL,'2023-03-19 14:56:08','2023-03-23 10:12:06','2023-03-23 10:12:06');
INSERT INTO `balance_libro_details` VALUES (1966,7485,539,40723,6065,3,68,1,1469.06,NULL,'2023-03-19 14:56:08','2023-03-23 10:12:06','2023-03-23 10:12:06'),(1967,7485,539,40723,6065,3,250,1,1357.38,NULL,'2023-03-19 14:56:08','2023-03-23 10:12:06','2023-03-23 10:12:06'),(1968,7485,539,40723,6065,3,57,2,12536.74,NULL,'2023-03-19 14:56:08','2023-03-23 10:12:06','2023-03-23 10:12:06'),(1969,7485,540,40723,6065,3,217,1,204.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1970,7485,540,40723,6065,3,57,2,204.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1971,7485,541,40723,6065,3,217,1,190.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1972,7485,541,40723,6065,3,57,2,190.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1973,7485,542,40723,6065,3,217,1,742.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1974,7485,542,40723,6065,3,57,2,742.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1975,7485,543,40723,6065,3,221,1,45.95,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1976,7485,543,40723,6065,3,217,1,556.05,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1977,7485,543,40723,6065,3,57,2,602.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1978,7485,544,40723,6065,3,221,1,897.81,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1979,7485,544,40723,6065,3,225,1,267.44,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1980,7485,544,40723,6065,3,220,1,173.65,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1981,7485,544,40723,6065,3,217,1,5788.25,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1982,7485,544,40723,6065,3,68,1,1215.53,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1983,7485,544,40723,6065,3,217,1,0.01,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1984,7485,544,40723,6065,3,57,2,8342.69,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1985,7485,545,40723,6065,3,217,1,600.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1986,7485,545,40723,6065,3,57,2,600.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1987,7485,546,40723,6065,3,225,1,288.43,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1988,7485,546,40723,6065,3,250,1,7210.86,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1989,7485,546,40723,6065,3,68,1,1514.28,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1990,7485,546,40723,6065,3,57,2,9013.57,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1991,7485,547,40723,6065,3,225,1,3114.51,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1992,7485,547,40723,6065,3,250,1,77862.72,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1993,7485,547,40723,6065,3,68,1,16351.17,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1994,7485,547,40723,6065,3,57,2,97328.40,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1995,7485,548,40723,6065,3,250,1,8241.28,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1996,7485,548,40723,6065,3,68,1,1730.67,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1997,7485,548,40723,6065,3,57,2,9971.95,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1998,7485,549,40723,6065,3,217,1,120.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(1999,7485,549,40723,6065,3,57,2,120.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2000,7485,550,40723,6065,3,221,1,64654.23,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2001,7485,550,40723,6065,3,250,1,257341.97,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2002,7485,550,40723,6065,3,68,1,54041.81,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2003,7485,550,40723,6065,3,57,2,376038.01,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2004,7485,551,40723,6065,3,221,1,6171.47,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2005,7485,551,40723,6065,3,250,1,154286.73,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2006,7485,551,40723,6065,3,68,1,32400.22,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL);
INSERT INTO `balance_libro_details` VALUES (2007,7485,551,40723,6065,3,57,2,192858.42,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2008,7485,552,40723,6065,3,221,2,52.56,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2009,7485,552,40723,6065,3,250,2,1314.04,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2010,7485,552,40723,6065,3,67,2,275.95,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2011,7485,552,40723,6065,3,57,1,1642.55,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2012,7485,553,40723,6065,3,221,2,452.84,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2013,7485,553,40723,6065,3,250,2,1296.68,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2014,7485,553,40723,6065,3,67,2,272.30,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2015,7485,553,40723,6065,3,57,1,2021.82,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2016,7485,554,40723,6065,3,217,1,1800.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2017,7485,554,40723,6065,3,57,2,1800.00,NULL,'2023-03-19 14:56:08','2023-03-19 14:56:08',NULL),(2018,7485,555,40723,6065,3,217,1,2853.72,NULL,'2023-03-19 15:05:50','2023-03-19 15:05:50',NULL),(2019,7485,555,40723,6065,3,68,1,599.28,NULL,'2023-03-19 15:05:50','2023-03-19 15:05:50',NULL),(2020,7485,555,40723,6065,3,57,2,3453.00,NULL,'2023-03-19 15:05:50','2023-03-19 15:05:50',NULL),(2021,7485,556,40723,6065,3,250,1,6995.52,NULL,'2023-03-23 10:12:06','2023-03-23 10:12:06',NULL),(2022,7485,556,40723,6065,3,68,1,1469.06,NULL,'2023-03-23 10:12:06','2023-03-23 10:12:06',NULL),(2023,7485,556,40723,6065,3,250,1,1357.38,NULL,'2023-03-23 10:12:06','2023-03-23 10:12:06',NULL),(2024,7485,556,40723,6065,3,221,1,2333.69,NULL,'2023-03-23 10:12:06','2023-03-23 10:12:06',NULL),(2025,7485,556,40723,6065,3,225,1,381.09,NULL,'2023-03-23 10:12:06','2023-03-23 10:12:06',NULL),(2026,7485,556,40723,6065,3,57,2,12536.74,NULL,'2023-03-23 10:12:06','2023-03-23 10:12:06',NULL),(2027,7485,557,40720,1556,3,221,1,951.73,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2028,7485,557,40720,1556,3,226,1,1764.35,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2029,7485,557,40720,1556,3,250,1,7125.15,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2030,7485,557,40720,1556,3,68,1,748.14,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2031,7485,557,40720,1556,3,250,1,28161.93,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2032,7485,557,40720,1556,3,68,1,5914.01,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2033,7485,557,40720,1556,3,57,2,44665.31,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2034,7485,558,40720,1556,3,217,1,16000.00,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2035,7485,558,40720,1556,3,57,2,16000.00,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2036,7485,559,40720,1556,3,250,1,75793.36,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2037,7485,559,40720,1556,3,68,1,15916.61,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2038,7485,559,40720,1556,3,57,2,91709.97,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2039,7485,560,40720,1556,3,226,1,348.35,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2040,7485,560,40720,1556,3,220,1,209.01,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2041,7485,560,40720,1556,3,250,1,5026.20,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2042,7485,560,40720,1556,3,68,1,1055.50,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2043,7485,560,40720,1556,3,250,1,1940.88,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2044,7485,560,40720,1556,3,68,1,524.04,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11');
INSERT INTO `balance_libro_details` VALUES (2045,7485,560,40720,1556,3,57,2,9103.98,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2046,7485,561,40720,1556,3,226,1,890.80,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2047,7485,561,40720,1556,3,220,1,334.05,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2048,7485,561,40720,1556,3,250,1,9245.00,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2049,7485,561,40720,1556,3,68,1,1941.45,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2050,7485,561,40720,1556,3,250,1,1890.00,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2051,7485,561,40720,1556,3,68,1,510.30,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2052,7485,561,40720,1556,3,57,2,14811.60,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2053,7485,562,40720,1556,3,226,1,24114.27,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2054,7485,562,40720,1556,3,250,1,803808.94,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2055,7485,562,40720,1556,3,68,1,168799.88,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2056,7485,562,40720,1556,3,57,2,996723.09,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2057,7485,563,40720,1556,3,226,1,329.46,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2058,7485,563,40720,1556,3,250,1,10981.88,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2059,7485,563,40720,1556,3,68,1,2306.19,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2060,7485,563,40720,1556,3,57,2,13617.53,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2061,7485,564,40720,1556,3,250,1,438209.00,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2062,7485,564,40720,1556,3,68,1,92023.89,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2063,7485,564,40720,1556,3,57,2,530232.89,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2064,7485,565,40720,1556,3,217,1,23765.38,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2065,7485,565,40720,1556,3,68,1,4990.73,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2066,7485,565,40720,1556,3,217,1,0.02,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2067,7485,565,40720,1556,3,57,2,28756.13,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2068,7485,566,40720,1556,3,250,1,107563.90,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2069,7485,566,40720,1556,3,68,1,22588.42,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2070,7485,566,40720,1556,3,57,2,130152.32,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2071,7485,567,40720,1556,3,250,1,98923.25,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2072,7485,567,40720,1556,3,68,1,20773.88,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2073,7485,567,40720,1556,3,57,2,119697.13,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2074,7485,568,40720,1556,3,226,1,18691.92,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2075,7485,568,40720,1556,3,250,1,692231.01,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2076,7485,568,40720,1556,3,68,1,145368.51,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2077,7485,568,40720,1556,3,57,2,856291.44,NULL,'2023-03-26 14:37:11','2023-10-30 20:50:11','2023-10-30 20:50:11'),(2078,7485,569,40720,1556,3,226,1,141.40,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2079,7485,569,40720,1556,3,250,1,2828.00,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12');
INSERT INTO `balance_libro_details` VALUES (2080,7485,569,40720,1556,3,68,1,593.88,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2081,7485,569,40720,1556,3,57,2,3563.28,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2082,7485,570,40720,1556,3,250,1,47935.00,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2083,7485,570,40720,1556,3,68,1,10066.35,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2084,7485,570,40720,1556,3,57,2,58001.35,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2085,7485,571,40720,1556,3,250,1,70979.34,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2086,7485,571,40720,1556,3,68,1,14905.66,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2087,7485,571,40720,1556,3,57,2,85885.00,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2088,7485,572,40720,1556,3,250,1,11580.00,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2089,7485,572,40720,1556,3,68,1,2431.80,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2090,7485,572,40720,1556,3,57,2,14011.80,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2091,7485,573,40720,1556,3,250,1,158732.40,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2092,7485,573,40720,1556,3,68,1,33333.80,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2093,7485,573,40720,1556,3,57,2,192066.20,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2094,7485,574,40720,1556,3,217,1,118109.81,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2095,7485,574,40720,1556,3,68,1,24803.06,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2096,7485,574,40720,1556,3,217,1,0.02,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2097,7485,574,40720,1556,3,57,2,142912.89,NULL,'2023-03-26 14:37:12','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2098,7485,575,40720,1556,2,96,2,275100.00,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2099,7485,575,40720,1556,2,67,2,57771.00,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2100,7485,575,40720,1556,2,13,1,332871.00,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2101,7485,576,40720,1556,2,96,2,194710.76,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2102,7485,576,40720,1556,2,67,2,40889.26,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2103,7485,576,40720,1556,2,218,2,0.02,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2104,7485,576,40720,1556,2,13,1,235600.04,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2105,7485,577,40720,1556,2,96,2,181818.19,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2106,7485,577,40720,1556,2,67,2,38181.82,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2107,7485,577,40720,1556,2,218,2,0.01,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2108,7485,577,40720,1556,2,13,1,220000.02,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:20','2023-10-30 20:51:20'),(2109,7485,578,40720,1556,2,96,2,23100.00,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2110,7485,578,40720,1556,2,67,2,4851.00,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2111,7485,578,40720,1556,2,13,1,27951.00,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2112,7485,579,40720,1556,2,96,2,247933.90,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2113,7485,579,40720,1556,2,67,2,52066.12,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2114,7485,579,40720,1556,2,218,2,0.02,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21');
INSERT INTO `balance_libro_details` VALUES (2115,7485,579,40720,1556,2,13,1,300000.04,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2116,7485,580,40720,1556,2,96,2,79800.00,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2117,7485,580,40720,1556,2,67,2,16758.00,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2118,7485,580,40720,1556,2,13,1,96558.00,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2119,7485,581,40720,1556,2,96,2,33636.38,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2120,7485,581,40720,1556,2,67,2,7063.64,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2121,7485,581,40720,1556,2,218,2,0.02,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2122,7485,581,40720,1556,2,13,1,40700.04,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2123,7485,582,40720,1556,2,96,2,81818.19,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2124,7485,582,40720,1556,2,67,2,17181.82,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2125,7485,582,40720,1556,2,218,2,0.01,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2126,7485,582,40720,1556,2,13,1,99000.02,NULL,'2023-03-26 14:37:39','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2127,7485,583,40720,1556,2,96,2,82644.62,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2128,7485,583,40720,1556,2,67,2,17355.37,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2129,7485,583,40720,1556,2,218,2,0.01,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2130,7485,583,40720,1556,2,13,1,100000.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2131,7485,584,40720,1556,2,96,2,215702.48,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2132,7485,584,40720,1556,2,67,2,45297.52,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2133,7485,584,40720,1556,2,13,1,261000.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2134,7485,585,40720,1556,2,96,2,599173.57,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2135,7485,585,40720,1556,2,67,2,125826.45,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2136,7485,585,40720,1556,2,218,2,0.02,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2137,7485,585,40720,1556,2,13,1,725000.04,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2138,7485,586,40720,1556,2,96,2,70289.24,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2139,7485,586,40720,1556,2,67,2,14760.74,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2140,7485,586,40720,1556,2,218,2,0.02,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2141,7485,586,40720,1556,2,13,1,85050.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2142,7485,587,40720,1556,2,96,2,90909.10,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2143,7485,587,40720,1556,2,67,2,19090.91,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2144,7485,587,40720,1556,2,218,2,0.01,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2145,7485,587,40720,1556,2,13,1,110000.02,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2146,7485,588,40720,1556,2,96,2,20826.43,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2147,7485,588,40720,1556,2,67,2,4373.55,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2148,7485,588,40720,1556,2,218,2,0.02,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2149,7485,588,40720,1556,2,13,1,25200.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21');
INSERT INTO `balance_libro_details` VALUES (2150,7485,589,40720,1556,2,96,2,140000.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2151,7485,589,40720,1556,2,67,2,29400.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2152,7485,589,40720,1556,2,13,1,169400.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2153,7485,590,40720,1556,2,96,2,47727.29,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2154,7485,590,40720,1556,2,67,2,10022.73,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2155,7485,590,40720,1556,2,218,2,0.02,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2156,7485,590,40720,1556,2,13,1,57750.04,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2157,7485,591,40720,1556,2,96,2,69421.48,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2158,7485,591,40720,1556,2,67,2,14578.51,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2159,7485,591,40720,1556,2,218,2,0.01,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2160,7485,591,40720,1556,2,13,1,84000.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2161,7485,592,40720,1556,2,96,2,112535.62,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2162,7485,592,40720,1556,2,67,2,23632.48,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2163,7485,592,40720,1556,2,218,2,0.10,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2164,7485,592,40720,1556,2,13,1,136168.20,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2165,7485,593,40720,1556,2,96,2,102049.57,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2166,7485,593,40720,1556,2,67,2,21430.41,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2167,7485,593,40720,1556,2,218,2,0.02,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2168,7485,593,40720,1556,2,13,1,123480.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2169,7485,594,40720,1556,2,96,2,249917.33,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2170,7485,594,40720,1556,2,67,2,52482.64,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2171,7485,594,40720,1556,2,218,2,0.03,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2172,7485,594,40720,1556,2,13,1,302400.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2173,7485,595,40720,1556,2,96,2,249917.33,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2174,7485,595,40720,1556,2,67,2,52482.64,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2175,7485,595,40720,1556,2,218,2,0.03,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2176,7485,595,40720,1556,2,13,1,302400.00,NULL,'2023-03-26 14:37:40','2023-10-30 20:51:21','2023-10-30 20:51:21'),(2177,7485,596,40720,1556,2,218,2,5774.85,NULL,'2023-03-26 15:07:45','2023-03-26 15:44:46','2023-03-26 15:44:46'),(2178,7485,596,40720,1556,2,220,2,5774.85,NULL,'2023-03-26 15:07:45','2023-03-26 15:44:46','2023-03-26 15:44:46'),(2179,7485,596,40720,1556,2,13,1,11549.70,NULL,'2023-03-26 15:07:45','2023-03-26 15:44:46','2023-03-26 15:44:46'),(2180,7485,597,40720,1556,2,96,2,7935.00,NULL,'2023-03-26 15:15:33','2023-03-26 16:19:47','2023-03-26 16:19:47'),(2181,7485,597,40720,1556,2,67,2,1666.35,NULL,'2023-03-26 15:15:33','2023-03-26 16:19:47','2023-03-26 16:19:47'),(2182,7485,597,40720,1556,2,220,2,238.05,NULL,'2023-03-26 15:15:33','2023-03-26 16:19:47','2023-03-26 16:19:47'),(2183,7485,597,40720,1556,2,13,1,9839.40,NULL,'2023-03-26 15:15:33','2023-03-26 16:19:47','2023-03-26 16:19:47'),(2184,7485,598,40720,1556,2,218,2,3.53,NULL,'2023-03-26 15:17:58','2023-03-26 16:00:57','2023-03-26 16:00:57');
INSERT INTO `balance_libro_details` VALUES (2185,7485,598,40720,1556,2,220,2,3537.00,NULL,'2023-03-26 15:17:58','2023-03-26 16:00:57','2023-03-26 16:00:57'),(2186,7485,598,40720,1556,2,13,1,3540.53,NULL,'2023-03-26 15:17:58','2023-03-26 16:00:57','2023-03-26 16:00:57'),(2187,7485,599,40720,1556,2,96,2,2645.00,NULL,'2023-03-26 15:36:40','2023-03-26 15:43:08','2023-03-26 15:43:08'),(2188,7485,599,40720,1556,2,67,2,555.45,NULL,'2023-03-26 15:36:40','2023-03-26 15:43:08','2023-03-26 15:43:08'),(2189,7485,599,40720,1556,2,220,2,79.35,NULL,'2023-03-26 15:36:40','2023-03-26 15:43:08','2023-03-26 15:43:08'),(2190,7485,599,40720,1556,2,13,1,3279.80,NULL,'2023-03-26 15:36:40','2023-03-26 15:43:08','2023-03-26 15:43:08'),(2191,7485,600,40720,1556,2,96,2,300.00,NULL,'2023-03-26 15:38:07','2023-03-26 16:19:31','2023-03-26 16:19:31'),(2192,7485,600,40720,1556,2,67,2,63.00,NULL,'2023-03-26 15:38:07','2023-03-26 16:19:31','2023-03-26 16:19:31'),(2193,7485,600,40720,1556,2,13,1,363.00,NULL,'2023-03-26 15:38:07','2023-03-26 16:19:31','2023-03-26 16:19:31'),(2194,7485,601,40720,1556,2,96,2,300.00,NULL,'2023-03-26 15:38:50','2023-03-26 16:19:22','2023-03-26 16:19:22'),(2195,7485,601,40720,1556,2,67,2,63.00,NULL,'2023-03-26 15:38:50','2023-03-26 16:19:22','2023-03-26 16:19:22'),(2196,7485,601,40720,1556,2,13,1,363.00,NULL,'2023-03-26 15:38:50','2023-03-26 16:19:22','2023-03-26 16:19:22'),(2197,7485,602,40720,1556,2,96,2,900.00,NULL,'2023-03-26 15:40:03','2023-03-26 16:19:01','2023-03-26 16:19:01'),(2198,7485,602,40720,1556,2,67,2,189.00,NULL,'2023-03-26 15:40:03','2023-03-26 16:19:01','2023-03-26 16:19:01'),(2199,7485,602,40720,1556,2,13,1,1089.00,NULL,'2023-03-26 15:40:03','2023-03-26 16:19:01','2023-03-26 16:19:01'),(2200,7485,603,40720,1556,2,96,2,2645.00,NULL,'2023-03-26 15:43:08','2023-03-26 16:19:36','2023-03-26 16:19:36'),(2201,7485,603,40720,1556,2,67,2,555.45,NULL,'2023-03-26 15:43:08','2023-03-26 16:19:36','2023-03-26 16:19:36'),(2202,7485,603,40720,1556,2,220,2,79.35,NULL,'2023-03-26 15:43:08','2023-03-26 16:19:36','2023-03-26 16:19:36'),(2203,7485,603,40720,1556,2,13,1,3279.80,NULL,'2023-03-26 15:43:08','2023-03-26 16:19:36','2023-03-26 16:19:36'),(2204,7485,604,40720,1556,2,218,2,5774.85,NULL,'2023-03-26 15:44:46','2023-03-26 15:59:11','2023-03-26 15:59:11'),(2205,7485,604,40720,1556,2,220,2,5774.85,NULL,'2023-03-26 15:44:46','2023-03-26 15:59:11','2023-03-26 15:59:11'),(2206,7485,604,40720,1556,2,13,1,11549.70,NULL,'2023-03-26 15:44:46','2023-03-26 15:59:11','2023-03-26 15:59:11'),(2207,7485,605,40720,1556,2,218,2,5774.85,NULL,'2023-03-26 15:59:11','2023-03-26 16:19:52','2023-03-26 16:19:52'),(2208,7485,605,40720,1556,2,220,2,5774.85,NULL,'2023-03-26 15:59:11','2023-03-26 16:19:52','2023-03-26 16:19:52'),(2209,7485,605,40720,1556,2,13,1,11549.70,NULL,'2023-03-26 15:59:11','2023-03-26 16:19:52','2023-03-26 16:19:52'),(2210,7485,606,40720,1556,2,218,2,3537.00,NULL,'2023-03-26 16:00:57','2023-03-26 16:19:41','2023-03-26 16:19:41'),(2211,7485,606,40720,1556,2,220,2,3537.00,NULL,'2023-03-26 16:00:57','2023-03-26 16:19:41','2023-03-26 16:19:41'),(2212,7485,606,40720,1556,2,13,1,7074.00,NULL,'2023-03-26 16:00:57','2023-03-26 16:19:41','2023-03-26 16:19:41'),(2213,7485,607,40720,1556,3,217,1,5774.85,NULL,'2023-03-26 16:22:07','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2214,7485,607,40720,1556,3,220,1,5774.85,NULL,'2023-03-26 16:22:07','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2215,7485,607,40720,1556,3,57,2,11549.70,NULL,'2023-03-26 16:22:07','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2216,7485,608,40720,1556,3,217,1,7935.00,NULL,'2023-03-26 16:23:10','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2217,7485,608,40720,1556,3,68,1,1666.35,NULL,'2023-03-26 16:23:10','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2218,7485,608,40720,1556,3,220,1,238.05,NULL,'2023-03-26 16:23:10','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2219,7485,608,40720,1556,3,57,2,9839.40,NULL,'2023-03-26 16:23:10','2023-10-30 20:50:12','2023-10-30 20:50:12');
INSERT INTO `balance_libro_details` VALUES (2220,7485,609,40720,1556,3,217,1,3537.00,NULL,'2023-03-26 16:24:13','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2221,7485,609,40720,1556,3,220,1,3537.00,NULL,'2023-03-26 16:24:13','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2222,7485,609,40720,1556,3,57,2,7074.00,NULL,'2023-03-26 16:24:13','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2223,7485,610,40720,1556,3,217,1,2645.00,NULL,'2023-03-26 16:25:52','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2224,7485,610,40720,1556,3,68,1,555.45,NULL,'2023-03-26 16:25:52','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2225,7485,610,40720,1556,3,220,1,79.35,NULL,'2023-03-26 16:25:52','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2226,7485,610,40720,1556,3,57,2,3279.80,NULL,'2023-03-26 16:25:52','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2227,7485,611,40720,1556,3,217,1,300.00,NULL,'2023-03-26 16:29:50','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2228,7485,611,40720,1556,3,68,1,63.00,NULL,'2023-03-26 16:29:50','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2229,7485,611,40720,1556,3,57,2,363.00,NULL,'2023-03-26 16:29:50','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2230,7485,612,40720,1556,3,217,1,300.00,NULL,'2023-03-26 16:30:13','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2231,7485,612,40720,1556,3,68,1,63.00,NULL,'2023-03-26 16:30:13','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2232,7485,612,40720,1556,3,57,2,363.00,NULL,'2023-03-26 16:30:13','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2233,7485,613,40720,1556,3,217,1,900.00,NULL,'2023-03-26 16:30:30','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2234,7485,613,40720,1556,3,68,1,189.00,NULL,'2023-03-26 16:30:30','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2235,7485,613,40720,1556,3,57,2,1089.00,NULL,'2023-03-26 16:30:30','2023-10-30 20:50:12','2023-10-30 20:50:12'),(2236,7485,614,40828,7771,3,217,1,12608.01,NULL,'2023-04-18 16:08:39','2023-04-18 16:08:39',NULL),(2237,7485,614,40828,7771,3,57,2,12608.01,NULL,'2023-04-18 16:08:39','2023-04-18 16:08:39',NULL),(2238,7485,615,40828,7771,3,217,1,2399.90,NULL,'2023-04-18 16:08:39','2023-04-18 16:08:39',NULL),(2239,7485,615,40828,7771,3,57,2,2399.90,NULL,'2023-04-18 16:08:39','2023-04-18 16:08:39',NULL),(2240,7485,616,40828,7771,3,250,2,2909.19,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2241,7485,616,40828,7771,3,57,1,2909.19,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2242,7485,617,40828,7771,3,221,1,743.10,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2243,7485,617,40828,7771,3,225,1,209.84,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2244,7485,617,40828,7771,3,220,1,229.51,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2245,7485,617,40828,7771,3,250,1,7650.32,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2246,7485,617,40828,7771,3,68,1,1606.57,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2247,7485,617,40828,7771,3,57,2,10439.34,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2248,7485,618,40828,7771,3,217,1,72683.75,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2249,7485,618,40828,7771,3,57,2,72683.75,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2250,7485,619,40828,7771,3,250,1,8826.45,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2251,7485,619,40828,7771,3,68,1,1853.55,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2252,7485,619,40828,7771,3,57,2,10680.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2253,7485,620,40828,7771,3,225,1,1673.49,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2254,7485,620,40828,7771,3,250,1,66939.52,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2255,7485,620,40828,7771,3,68,1,14057.30,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2256,7485,620,40828,7771,3,57,2,82670.31,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2257,7485,621,40828,7771,3,225,1,303.97,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2258,7485,621,40828,7771,3,250,1,10268.92,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2259,7485,621,40828,7771,3,68,1,2156.46,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2260,7485,621,40828,7771,3,250,1,1890.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2261,7485,621,40828,7771,3,68,1,510.30,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2262,7485,621,40828,7771,3,57,2,15129.65,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2263,7485,622,40828,7771,3,217,1,4330.01,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2264,7485,622,40828,7771,3,57,2,4330.01,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2265,7485,623,40828,7771,3,221,1,1438.44,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2266,7485,623,40828,7771,3,225,1,209.28,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2267,7485,623,40828,7771,3,250,1,7756.62,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2268,7485,623,40828,7771,3,68,1,1628.89,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2269,7485,623,40828,7771,3,250,1,823.87,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2270,7485,623,40828,7771,3,57,2,11857.10,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2271,7485,624,40828,7771,3,250,1,25778.98,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2272,7485,624,40828,7771,3,68,1,5413.58,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2273,7485,624,40828,7771,3,57,2,31192.56,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2274,7485,625,40828,7771,3,225,1,2050.26,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2275,7485,625,40828,7771,3,250,1,82010.58,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2276,7485,625,40828,7771,3,68,1,17222.22,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2277,7485,625,40828,7771,3,57,2,101283.06,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2278,7485,626,40828,7771,3,217,1,6499.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2279,7485,626,40828,7771,3,57,2,6499.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2280,7485,627,40828,7771,3,217,1,16499.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2281,7485,627,40828,7771,3,57,2,16499.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2282,7485,628,40828,7771,3,225,1,161.93,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2283,7485,628,40828,7771,3,250,1,6477.02,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2284,7485,628,40828,7771,3,68,1,1360.17,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2285,7485,628,40828,7771,3,57,2,7999.12,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2286,7485,629,40828,7771,3,225,1,522.61,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2287,7485,629,40828,7771,3,250,1,20904.55,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2288,7485,629,40828,7771,3,68,1,4389.96,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2289,7485,629,40828,7771,3,57,2,25817.12,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2290,7485,630,40828,7771,3,221,1,721.78,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2291,7485,630,40828,7771,3,225,1,209.74,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2292,7485,630,40828,7771,3,220,1,230.04,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2293,7485,630,40828,7771,3,217,1,7667.92,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2294,7485,630,40828,7771,3,68,1,1610.26,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2295,7485,630,40828,7771,3,217,1,0.01,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2296,7485,630,40828,7771,3,57,2,10439.75,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2297,7485,631,40828,7771,3,225,1,87.34,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2298,7485,631,40828,7771,3,250,1,2319.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2299,7485,631,40828,7771,3,68,1,487.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2300,7485,631,40828,7771,3,250,1,1174.80,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2301,7485,631,40828,7771,3,68,1,317.20,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2302,7485,631,40828,7771,3,57,2,4385.34,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2303,7485,632,40828,7771,3,250,2,518.16,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2304,7485,632,40828,7771,3,67,2,108.81,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2305,7485,632,40828,7771,3,57,1,626.97,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2306,7485,633,40828,7771,3,250,2,1672.36,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2307,7485,633,40828,7771,3,67,2,351.20,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2308,7485,633,40828,7771,3,57,1,2023.56,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2309,7485,634,40828,7771,3,217,1,33901.37,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2310,7485,634,40828,7771,3,57,2,33901.37,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2311,7485,635,40828,7771,3,217,1,2360.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2312,7485,635,40828,7771,3,57,2,2360.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2313,7485,636,40828,7771,3,217,1,58183.80,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2314,7485,636,40828,7771,3,57,2,58183.80,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2315,7485,637,40828,7771,3,225,1,1232.23,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2316,7485,637,40828,7771,3,250,1,20537.18,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2317,7485,637,40828,7771,3,68,1,4312.81,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2318,7485,637,40828,7771,3,57,2,26082.22,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2319,7485,638,40828,7771,3,250,1,36330.58,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2320,7485,638,40828,7771,3,68,1,7629.42,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2321,7485,638,40828,7771,3,57,2,43960.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2322,7485,639,40828,7771,3,250,1,33800.83,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2323,7485,639,40828,7771,3,68,1,7098.17,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2324,7485,639,40828,7771,3,57,2,40899.00,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2325,7485,640,40828,7771,3,225,1,2406.69,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2326,7485,640,40828,7771,3,250,1,96267.51,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2327,7485,640,40828,7771,3,68,1,20216.18,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2328,7485,640,40828,7771,3,57,2,118890.38,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2329,7485,641,40828,7771,3,221,1,46.87,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2330,7485,641,40828,7771,3,250,1,1874.81,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2331,7485,641,40828,7771,3,68,1,393.71,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2332,7485,641,40828,7771,3,57,2,2315.39,NULL,'2023-04-18 16:08:40','2023-04-18 16:08:40',NULL),(2333,7485,642,40828,7771,3,250,1,92073.40,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2334,7485,642,40828,7771,3,68,1,19335.41,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2335,7485,642,40828,7771,3,57,2,111408.81,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2336,7485,643,40828,7771,3,250,2,2909.19,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2337,7485,643,40828,7771,3,57,1,2909.19,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2338,7485,644,40828,7771,3,250,1,79930.39,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2339,7485,644,40828,7771,3,68,1,16785.38,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2340,7485,644,40828,7771,3,57,2,96715.77,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2341,7485,645,40828,7771,3,250,1,344369.83,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2342,7485,645,40828,7771,3,68,1,72317.66,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2343,7485,645,40828,7771,3,57,2,416687.49,NULL,'2023-04-18 16:08:41','2023-04-18 16:08:41',NULL),(2392,7485,658,40828,7770,2,96,2,25371.90,NULL,'2023-04-18 16:17:10','2023-04-18 16:17:10',NULL),(2393,7485,658,40828,7770,2,67,2,5328.10,NULL,'2023-04-18 16:17:10','2023-04-18 16:17:10',NULL),(2394,7485,658,40828,7770,2,13,1,30700.00,NULL,'2023-04-18 16:17:10','2023-04-18 16:17:10',NULL),(2395,7485,659,40828,7770,2,96,2,24793.38,NULL,'2023-04-18 16:17:44','2023-04-18 16:17:44',NULL),(2396,7485,659,40828,7770,2,67,2,5206.61,NULL,'2023-04-18 16:17:44','2023-04-18 16:17:44',NULL),(2397,7485,659,40828,7770,2,218,2,0.01,NULL,'2023-04-18 16:17:44','2023-04-18 16:17:44',NULL),(2398,7485,659,40828,7770,2,13,1,30000.00,NULL,'2023-04-18 16:17:44','2023-04-18 16:17:44',NULL),(2399,7485,660,40828,7770,2,96,2,25371.90,NULL,'2023-04-18 16:18:09','2023-04-18 16:18:09',NULL),(2400,7485,660,40828,7770,2,67,2,5328.10,NULL,'2023-04-18 16:18:09','2023-04-18 16:18:09',NULL),(2401,7485,660,40828,7770,2,13,1,30700.00,NULL,'2023-04-18 16:18:09','2023-04-18 16:18:09',NULL),(2402,7485,661,40828,7770,2,96,2,25371.90,NULL,'2023-04-18 16:18:50','2023-04-18 16:18:50',NULL),(2403,7485,661,40828,7770,2,67,2,5328.10,NULL,'2023-04-18 16:18:50','2023-04-18 16:18:50',NULL),(2404,7485,661,40828,7770,2,13,1,30700.00,NULL,'2023-04-18 16:18:50','2023-04-18 16:18:50',NULL),(2405,7485,662,40828,7770,2,96,2,37933.90,NULL,'2023-04-18 16:19:20','2023-04-18 16:19:20',NULL),(2406,7485,662,40828,7770,2,67,2,7966.12,NULL,'2023-04-18 16:19:20','2023-04-18 16:19:20',NULL),(2407,7485,662,40828,7770,2,218,2,0.02,NULL,'2023-04-18 16:19:20','2023-04-18 16:19:20',NULL),(2408,7485,662,40828,7770,2,13,1,45900.04,NULL,'2023-04-18 16:19:20','2023-04-18 16:19:20',NULL),(2409,7485,663,40828,7770,2,96,2,24793.38,NULL,'2023-04-18 16:21:24','2023-04-18 16:21:24',NULL),(2410,7485,663,40828,7770,2,67,2,5206.61,NULL,'2023-04-18 16:21:24','2023-04-18 16:21:24',NULL),(2411,7485,663,40828,7770,2,218,2,0.01,NULL,'2023-04-18 16:21:24','2023-04-18 16:21:24',NULL),(2412,7485,663,40828,7770,2,13,1,30000.00,NULL,'2023-04-18 16:21:24','2023-04-18 16:21:24',NULL),(2413,7485,664,40828,7770,2,96,2,24793.38,NULL,'2023-04-18 16:21:47','2023-04-18 16:21:47',NULL),(2414,7485,664,40828,7770,2,67,2,5206.61,NULL,'2023-04-18 16:21:47','2023-04-18 16:21:47',NULL),(2415,7485,664,40828,7770,2,218,2,0.01,NULL,'2023-04-18 16:21:47','2023-04-18 16:21:47',NULL),(2416,7485,664,40828,7770,2,13,1,30000.00,NULL,'2023-04-18 16:21:47','2023-04-18 16:21:47',NULL),(2417,7485,665,40828,7770,2,96,2,24380.14,NULL,'2023-04-18 16:22:13','2023-04-18 16:22:13',NULL),(2418,7485,665,40828,7770,2,67,2,5119.83,NULL,'2023-04-18 16:22:13','2023-04-18 16:22:13',NULL),(2419,7485,665,40828,7770,2,218,2,0.03,NULL,'2023-04-18 16:22:13','2023-04-18 16:22:13',NULL),(2420,7485,665,40828,7770,2,13,1,29500.00,NULL,'2023-04-18 16:22:13','2023-04-18 16:22:13',NULL),(2421,7485,666,40828,7770,2,96,2,25371.90,NULL,'2023-04-18 16:22:43','2023-04-18 16:22:43',NULL),(2422,7485,666,40828,7770,2,67,2,5328.10,NULL,'2023-04-18 16:22:43','2023-04-18 16:22:43',NULL),(2423,7485,666,40828,7770,2,13,1,30700.00,NULL,'2023-04-18 16:22:43','2023-04-18 16:22:43',NULL),(2424,7485,667,40828,7770,2,96,2,25371.90,NULL,'2023-04-18 16:23:02','2023-04-18 16:23:02',NULL),(2425,7485,667,40828,7770,2,67,2,5328.10,NULL,'2023-04-18 16:23:02','2023-04-18 16:23:02',NULL),(2426,7485,667,40828,7770,2,13,1,30700.00,NULL,'2023-04-18 16:23:02','2023-04-18 16:23:02',NULL),(2427,7485,668,40828,7770,2,96,2,21694.24,NULL,'2023-04-18 16:29:25','2023-04-18 16:29:25',NULL),(2428,7485,668,40828,7770,2,67,2,4555.79,NULL,'2023-04-18 16:29:25','2023-04-18 16:29:25',NULL);
INSERT INTO `balance_libro_details` VALUES (2429,7485,668,40828,7770,2,218,2,0.03,NULL,'2023-04-18 16:29:25','2023-04-18 16:29:25',NULL),(2430,7485,668,40828,7770,2,13,1,26250.06,NULL,'2023-04-18 16:29:25','2023-04-18 16:29:25',NULL),(2479,7485,681,40828,7771,2,96,2,2975.24,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2480,7485,681,40828,7771,2,67,2,624.80,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2481,7485,681,40828,7771,2,218,2,0.04,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2482,7485,681,40828,7771,2,13,1,3600.08,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2483,7485,682,40828,7771,2,96,2,66115.71,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2484,7485,682,40828,7771,2,67,2,13884.30,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2485,7485,682,40828,7771,2,218,2,0.01,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2486,7485,682,40828,7771,2,13,1,80000.02,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2487,7485,683,40828,7771,2,96,2,66115.71,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2488,7485,683,40828,7771,2,67,2,13884.30,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2489,7485,683,40828,7771,2,218,2,0.01,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2490,7485,683,40828,7771,2,13,1,80000.02,NULL,'2023-04-18 16:57:15','2023-04-18 16:57:15',NULL),(2491,7485,684,40828,7771,2,96,2,62677.67,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2492,7485,684,40828,7771,2,67,2,13162.31,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2493,7485,684,40828,7771,2,218,2,0.02,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2494,7485,684,40828,7771,2,13,1,75840.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2495,7485,685,40828,7771,2,96,2,25413.24,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2496,7485,685,40828,7771,2,67,2,5336.78,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2497,7485,685,40828,7771,2,218,2,0.02,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2498,7485,685,40828,7771,2,13,1,30750.04,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2499,7485,686,40828,7771,2,96,2,7685.95,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2500,7485,686,40828,7771,2,67,2,1614.05,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2501,7485,686,40828,7771,2,13,1,9300.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2502,7485,687,40828,7771,2,96,2,66033.05,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2503,7485,687,40828,7771,2,67,2,13866.94,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2504,7485,687,40828,7771,2,218,2,0.01,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2505,7485,687,40828,7771,2,13,1,79900.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2506,7485,688,40828,7771,2,96,2,17768.57,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2507,7485,688,40828,7771,2,67,2,3731.40,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2508,7485,688,40828,7771,2,218,2,0.03,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2509,7485,688,40828,7771,2,13,1,21500.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2510,7485,689,40828,7771,2,96,2,17809.95,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2511,7485,689,40828,7771,2,67,2,3740.09,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2512,7485,689,40828,7771,2,218,2,0.04,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2513,7485,689,40828,7771,2,13,1,21550.08,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2514,7485,690,40828,7771,2,96,2,25371.90,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2515,7485,690,40828,7771,2,67,2,5328.10,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2516,7485,690,40828,7771,2,13,1,30700.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2517,7485,691,40828,7771,2,96,2,42066.10,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL);
INSERT INTO `balance_libro_details` VALUES (2518,7485,691,40828,7771,2,67,2,8833.88,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2519,7485,691,40828,7771,2,218,2,0.02,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2520,7485,691,40828,7771,2,13,1,50900.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2521,7485,692,40828,7771,2,96,2,15958.67,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2522,7485,692,40828,7771,2,67,2,3351.32,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2523,7485,692,40828,7771,2,218,2,0.01,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2524,7485,692,40828,7771,2,13,1,19310.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2525,7485,693,40828,7771,2,96,2,25371.90,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2526,7485,693,40828,7771,2,67,2,5328.10,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2527,7485,693,40828,7771,2,13,1,30700.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2528,7485,694,40828,7771,2,96,2,46834.71,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2529,7485,694,40828,7771,2,67,2,9835.29,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2530,7485,694,40828,7771,2,13,1,56670.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2531,7485,695,40828,7771,2,96,2,17512.43,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2532,7485,695,40828,7771,2,67,2,3677.61,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2533,7485,695,40828,7771,2,218,2,0.04,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2534,7485,695,40828,7771,2,13,1,21190.08,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2535,7485,696,40828,7771,2,96,2,25206.62,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2536,7485,696,40828,7771,2,67,2,5293.39,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2537,7485,696,40828,7771,2,218,2,0.01,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2538,7485,696,40828,7771,2,13,1,30500.02,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2539,7485,697,40828,7771,2,96,2,25371.90,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2540,7485,697,40828,7771,2,67,2,5328.10,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2541,7485,697,40828,7771,2,13,1,30700.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2542,7485,698,40828,7771,2,96,2,25371.90,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2543,7485,698,40828,7771,2,67,2,5328.10,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2544,7485,698,40828,7771,2,13,1,30700.00,NULL,'2023-04-18 16:57:16','2023-04-18 16:57:16',NULL),(2545,7485,699,40723,6066,3,250,1,572514.99,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2546,7485,699,40723,6066,3,68,1,120228.15,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2547,7485,699,40723,6066,3,57,2,692743.14,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2548,7485,700,40723,6066,3,250,1,254206.99,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2549,7485,700,40723,6066,3,68,1,53383.47,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2550,7485,700,40723,6066,3,57,2,307590.46,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2551,7485,701,40723,6066,3,217,1,204.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2552,7485,701,40723,6066,3,57,2,204.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2553,7485,702,40723,6066,3,217,1,95.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2554,7485,702,40723,6066,3,57,2,95.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2555,7485,703,40723,6066,3,250,1,603126.92,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2556,7485,703,40723,6066,3,68,1,126656.65,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2557,7485,703,40723,6066,3,57,2,729783.57,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2558,7485,704,40723,6066,3,221,1,45.95,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL);
INSERT INTO `balance_libro_details` VALUES (2559,7485,704,40723,6066,3,217,1,556.05,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2560,7485,704,40723,6066,3,57,2,602.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2561,7485,705,40723,6066,3,217,1,855.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2562,7485,705,40723,6066,3,57,2,855.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2563,7485,706,40723,6066,3,221,1,1271.86,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2564,7485,706,40723,6066,3,250,1,6723.69,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2565,7485,706,40723,6066,3,68,1,1411.97,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2566,7485,706,40723,6066,3,57,2,9407.52,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2567,7485,707,40723,6066,3,250,1,20677.15,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2568,7485,707,40723,6066,3,68,1,4342.20,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2569,7485,707,40723,6066,3,57,2,25019.35,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2570,7485,708,40723,6066,3,250,1,217319.94,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2571,7485,708,40723,6066,3,68,1,45637.19,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2572,7485,708,40723,6066,3,57,2,262957.13,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2573,7485,709,40723,6066,3,250,1,448082.39,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2574,7485,709,40723,6066,3,68,1,94097.30,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2575,7485,709,40723,6066,3,57,2,542179.69,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2576,7485,710,40723,6066,3,217,1,34728.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2577,7485,710,40723,6066,3,57,2,34728.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2578,7485,711,40723,6066,3,250,1,583036.46,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2579,7485,711,40723,6066,3,68,1,122437.66,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2580,7485,711,40723,6066,3,57,2,705474.12,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2581,7485,712,40723,6066,3,217,1,13305.76,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2582,7485,712,40723,6066,3,68,1,2794.21,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2583,7485,712,40723,6066,3,217,1,0.03,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2584,7485,712,40723,6066,3,57,2,16100.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2585,7485,713,40723,6066,3,217,1,380.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2586,7485,713,40723,6066,3,57,2,380.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2587,7485,714,40723,6066,3,217,1,68.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2588,7485,714,40723,6066,3,57,2,68.00,NULL,'2023-04-21 17:38:34','2023-04-21 17:38:34',NULL),(2589,7485,715,40723,6066,3,217,1,340.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2590,7485,715,40723,6066,3,57,2,340.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2591,7485,716,40723,6066,3,221,1,112.58,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2592,7485,716,40723,6066,3,217,1,1362.32,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2593,7485,716,40723,6066,3,57,2,1474.90,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2594,7485,717,40723,6066,3,250,1,171163.62,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2595,7485,717,40723,6066,3,68,1,35944.36,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2596,7485,717,40723,6066,3,57,2,207107.98,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2597,7485,718,40723,6066,3,217,1,1162.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2598,7485,718,40723,6066,3,57,2,1162.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2599,7485,719,40723,6066,3,250,1,152767.08,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL);
INSERT INTO `balance_libro_details` VALUES (2600,7485,719,40723,6066,3,68,1,32081.09,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2601,7485,719,40723,6066,3,57,2,184848.17,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2602,7485,720,40723,6066,3,250,1,67093.83,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2603,7485,720,40723,6066,3,68,1,14089.70,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2604,7485,720,40723,6066,3,57,2,81183.53,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2605,7485,721,40723,6066,3,250,1,8925.62,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2606,7485,721,40723,6066,3,68,1,1874.38,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2607,7485,721,40723,6066,3,250,1,0.01,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2608,7485,721,40723,6066,3,57,2,10800.01,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2609,7485,722,40723,6066,3,250,1,30990.91,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2610,7485,722,40723,6066,3,68,1,6508.09,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2611,7485,722,40723,6066,3,57,2,37499.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2612,7485,723,40723,6066,3,250,1,33735.67,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2613,7485,723,40723,6066,3,68,1,7084.49,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2614,7485,723,40723,6066,3,57,2,40820.16,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2615,7485,724,40723,6066,3,250,1,8975.21,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2616,7485,724,40723,6066,3,68,1,1884.79,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2617,7485,724,40723,6066,3,57,2,10860.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2618,7485,725,40723,6066,3,217,1,180.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2619,7485,725,40723,6066,3,57,2,180.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2620,7485,726,40723,6066,3,250,1,61856.46,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2621,7485,726,40723,6066,3,68,1,12989.86,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2622,7485,726,40723,6066,3,57,2,74846.32,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2623,7485,727,40723,6066,3,250,1,4619.84,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2624,7485,727,40723,6066,3,68,1,970.17,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2625,7485,727,40723,6066,3,57,2,5590.01,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2626,7485,728,40723,6066,3,217,1,200.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2627,7485,728,40723,6066,3,57,2,200.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2628,7485,729,40723,6066,3,250,1,16431.41,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2629,7485,729,40723,6066,3,68,1,3450.60,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2630,7485,729,40723,6066,3,250,1,0.01,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2631,7485,729,40723,6066,3,57,2,19882.02,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2632,7485,730,40723,6066,3,250,1,33884.30,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2633,7485,730,40723,6066,3,68,1,7115.70,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2634,7485,730,40723,6066,3,57,2,41000.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2635,7485,731,40723,6066,3,225,1,1528.14,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2636,7485,731,40723,6066,3,250,1,25468.98,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2637,7485,731,40723,6066,3,68,1,5348.48,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2638,7485,731,40723,6066,3,57,2,32345.60,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2639,7485,732,40723,6066,3,221,1,63293.20,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2640,7485,732,40723,6066,3,250,1,312795.60,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL);
INSERT INTO `balance_libro_details` VALUES (2641,7485,732,40723,6066,3,68,1,65687.08,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2642,7485,732,40723,6066,3,57,2,441775.88,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2643,7485,733,40723,6066,3,250,1,184497.07,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2644,7485,733,40723,6066,3,68,1,38744.38,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2645,7485,733,40723,6066,3,57,2,223241.45,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2646,7485,734,40723,6066,3,250,2,5093.80,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2647,7485,734,40723,6066,3,67,2,1069.70,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2648,7485,734,40723,6066,3,57,1,6163.50,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2649,7485,735,40723,6066,3,250,1,117637.10,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2650,7485,735,40723,6066,3,68,1,24703.79,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2651,7485,735,40723,6066,3,57,2,142340.89,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2652,7485,736,40723,6066,3,250,1,30034.63,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2653,7485,736,40723,6066,3,68,1,6307.27,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2654,7485,736,40723,6066,3,57,2,36341.90,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2655,7485,737,40723,6066,3,217,1,4716.52,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2656,7485,737,40723,6066,3,68,1,990.47,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2657,7485,737,40723,6066,3,217,1,0.01,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2658,7485,737,40723,6066,3,57,2,5707.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2659,7485,738,40723,6066,3,221,1,990.37,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2660,7485,738,40723,6066,3,250,1,6289.19,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2661,7485,738,40723,6066,3,68,1,1320.73,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2662,7485,738,40723,6066,3,57,2,8600.29,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2663,7485,739,40723,6066,3,250,1,7438.02,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2664,7485,739,40723,6066,3,68,1,1561.98,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2665,7485,739,40723,6066,3,57,2,9000.00,NULL,'2023-04-21 17:38:35','2023-04-21 17:38:35',NULL),(2666,7485,740,40723,6066,2,96,2,1497411.90,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2667,7485,740,40723,6066,2,67,2,314456.50,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2668,7485,740,40723,6066,2,218,2,0.02,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2669,7485,740,40723,6066,2,13,1,1811868.42,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2670,7485,741,40723,6066,2,96,2,1898.29,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2671,7485,741,40723,6066,2,67,2,398.64,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2672,7485,741,40723,6066,2,13,1,2296.93,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2673,7485,742,40723,6066,2,96,2,1898.29,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2674,7485,742,40723,6066,2,67,2,398.64,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2675,7485,742,40723,6066,2,13,1,2296.93,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2676,7485,743,40723,6066,2,96,2,23997.00,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2677,7485,743,40723,6066,2,67,2,5039.37,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2678,7485,743,40723,6066,2,13,1,29036.37,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2679,7485,744,40723,6066,2,96,2,37026.05,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2680,7485,744,40723,6066,2,67,2,7775.47,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2681,7485,744,40723,6066,2,13,1,44801.52,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL);
INSERT INTO `balance_libro_details` VALUES (2682,7485,745,40723,6066,2,96,2,246259.71,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2683,7485,745,40723,6066,2,67,2,51714.54,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2684,7485,745,40723,6066,2,218,2,0.03,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2685,7485,745,40723,6066,2,13,1,297974.28,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2686,7485,746,40723,6066,2,96,2,13343.71,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2687,7485,746,40723,6066,2,67,2,2802.18,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2688,7485,746,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2689,7485,746,40723,6066,2,13,1,16145.90,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2690,7485,747,40723,6066,2,96,2,157770.29,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2691,7485,747,40723,6066,2,67,2,33131.76,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2692,7485,747,40723,6066,2,218,2,0.03,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2693,7485,747,40723,6066,2,13,1,190902.08,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2694,7485,748,40723,6066,2,96,2,1470.52,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2695,7485,748,40723,6066,2,67,2,308.81,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2696,7485,748,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2697,7485,748,40723,6066,2,13,1,1779.34,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2698,7485,749,40723,6066,2,96,2,255429.71,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2699,7485,749,40723,6066,2,67,2,53640.24,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2700,7485,749,40723,6066,2,218,2,0.02,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2701,7485,749,40723,6066,2,13,1,309069.97,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2702,7485,750,40723,6066,2,96,2,10393.95,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2703,7485,750,40723,6066,2,67,2,2182.73,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2704,7485,750,40723,6066,2,218,2,0.02,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2705,7485,750,40723,6066,2,13,1,12576.70,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2706,7485,751,40723,6066,2,96,2,3399.48,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2707,7485,751,40723,6066,2,67,2,713.89,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2708,7485,751,40723,6066,2,13,1,4113.37,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2709,7485,752,40723,6066,2,96,2,895626.95,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2710,7485,752,40723,6066,2,67,2,188081.66,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2711,7485,752,40723,6066,2,218,2,0.03,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2712,7485,752,40723,6066,2,13,1,1083708.64,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2713,7485,753,40723,6066,2,96,2,136847.43,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2714,7485,753,40723,6066,2,67,2,28737.96,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2715,7485,753,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2716,7485,753,40723,6066,2,13,1,165585.40,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2717,7485,754,40723,6066,2,96,2,94908.38,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2718,7485,754,40723,6066,2,67,2,19930.76,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2719,7485,754,40723,6066,2,218,2,0.03,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2720,7485,754,40723,6066,2,13,1,114839.17,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2721,7485,755,40723,6066,2,96,2,3920.00,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2722,7485,755,40723,6066,2,67,2,823.20,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL);
INSERT INTO `balance_libro_details` VALUES (2723,7485,755,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2724,7485,755,40723,6066,2,13,1,4743.21,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2725,7485,756,40723,6066,2,96,2,14150.90,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2726,7485,756,40723,6066,2,67,2,2971.69,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2727,7485,756,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2728,7485,756,40723,6066,2,13,1,17122.60,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2729,7485,757,40723,6066,2,96,2,9016.38,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2730,7485,757,40723,6066,2,67,2,1893.44,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2731,7485,757,40723,6066,2,13,1,10909.82,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2732,7485,758,40723,6066,2,96,2,827.38,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2733,7485,758,40723,6066,2,67,2,173.75,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2734,7485,758,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2735,7485,758,40723,6066,2,13,1,1001.14,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2736,7485,759,40723,6066,2,96,2,124630.95,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2737,7485,759,40723,6066,2,67,2,26172.50,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2738,7485,759,40723,6066,2,218,2,0.02,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2739,7485,759,40723,6066,2,13,1,150803.47,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2740,7485,760,40723,6066,2,96,2,75754.38,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2741,7485,760,40723,6066,2,67,2,15908.42,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2742,7485,760,40723,6066,2,218,2,0.05,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2743,7485,760,40723,6066,2,13,1,91662.85,NULL,'2023-04-21 17:38:46','2023-04-21 17:38:46',NULL),(2744,7485,761,40723,6066,2,96,2,236039.76,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2745,7485,761,40723,6066,2,67,2,49568.35,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2746,7485,761,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2747,7485,761,40723,6066,2,13,1,285608.12,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2748,7485,762,40723,6066,2,96,2,19115.90,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2749,7485,762,40723,6066,2,67,2,4014.34,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2750,7485,762,40723,6066,2,218,2,0.02,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2751,7485,762,40723,6066,2,13,1,23130.26,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2752,7485,763,40723,6066,2,96,2,1852.62,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2753,7485,763,40723,6066,2,67,2,389.05,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2754,7485,763,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2755,7485,763,40723,6066,2,13,1,2241.68,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2756,7485,764,40723,6066,2,96,2,15783.48,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2757,7485,764,40723,6066,2,67,2,3314.53,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2758,7485,764,40723,6066,2,218,2,0.04,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2759,7485,764,40723,6066,2,13,1,19098.05,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2760,7485,765,40723,6066,2,96,2,2220.71,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2761,7485,765,40723,6066,2,67,2,466.35,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2762,7485,765,40723,6066,2,218,2,0.04,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2763,7485,765,40723,6066,2,13,1,2687.10,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL);
INSERT INTO `balance_libro_details` VALUES (2764,7485,766,40723,6066,2,96,2,404047.52,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2765,7485,766,40723,6066,2,67,2,84849.98,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2766,7485,766,40723,6066,2,218,2,0.02,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2767,7485,766,40723,6066,2,13,1,488897.52,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2768,7485,767,40723,6066,2,96,2,49356.24,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2769,7485,767,40723,6066,2,67,2,10364.81,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2770,7485,767,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2771,7485,767,40723,6066,2,13,1,59721.06,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2772,7485,768,40723,6066,2,96,2,20671.52,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2773,7485,768,40723,6066,2,67,2,4341.02,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2774,7485,768,40723,6066,2,218,2,0.02,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2775,7485,768,40723,6066,2,13,1,25012.56,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2776,7485,769,40723,6066,2,96,2,1515.62,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2777,7485,769,40723,6066,2,67,2,318.28,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2778,7485,769,40723,6066,2,218,2,0.04,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2779,7485,769,40723,6066,2,13,1,1833.94,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2780,7485,770,40723,6066,2,96,2,45502.38,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2781,7485,770,40723,6066,2,67,2,9555.50,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2782,7485,770,40723,6066,2,218,2,0.02,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2783,7485,770,40723,6066,2,13,1,55057.90,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2784,7485,771,40723,6066,2,96,2,8181.81,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2785,7485,771,40723,6066,2,67,2,1718.18,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2786,7485,771,40723,6066,2,218,2,0.01,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2787,7485,771,40723,6066,2,13,1,9900.00,NULL,'2023-04-21 17:38:47','2023-04-21 17:38:47',NULL),(2893,7485,800,40720,1557,2,96,2,46859.52,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2894,7485,800,40720,1557,2,67,2,9840.50,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2895,7485,800,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2896,7485,800,40720,1557,2,13,1,56700.04,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2897,7485,801,40720,1557,2,96,2,69421.48,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2898,7485,801,40720,1557,2,67,2,14578.51,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2899,7485,801,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2900,7485,801,40720,1557,2,13,1,84000.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2901,7485,802,40720,1557,2,96,2,11157.05,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2902,7485,802,40720,1557,2,67,2,2342.98,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2903,7485,802,40720,1557,2,218,2,0.03,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2904,7485,802,40720,1557,2,13,1,13500.06,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2905,7485,803,40720,1557,2,96,2,11570.24,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2906,7485,803,40720,1557,2,67,2,2429.75,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2907,7485,803,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55');
INSERT INTO `balance_libro_details` VALUES (2908,7485,803,40720,1557,2,13,1,14000.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2909,7485,804,40720,1557,2,96,2,12719.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2910,7485,804,40720,1557,2,67,2,2670.99,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2911,7485,804,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2912,7485,804,40720,1557,2,13,1,15390.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2913,7485,805,40720,1557,2,96,2,17181.81,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2914,7485,805,40720,1557,2,67,2,3608.18,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2915,7485,805,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2916,7485,805,40720,1557,2,13,1,20790.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2917,7485,806,40720,1557,2,96,2,13090.90,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2918,7485,806,40720,1557,2,67,2,2749.09,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2919,7485,806,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2920,7485,806,40720,1557,2,13,1,15840.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2921,7485,807,40720,1557,2,96,2,21421.48,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2922,7485,807,40720,1557,2,67,2,4498.51,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2923,7485,807,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2924,7485,807,40720,1557,2,13,1,25920.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2925,7485,808,40720,1557,2,96,2,31239.67,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2926,7485,808,40720,1557,2,67,2,6560.33,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2927,7485,808,40720,1557,2,13,1,37800.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2928,7485,809,40720,1557,2,96,2,11754.52,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2929,7485,809,40720,1557,2,67,2,2468.45,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2930,7485,809,40720,1557,2,218,2,0.03,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2931,7485,809,40720,1557,2,13,1,14223.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:55','2023-10-30 20:21:55'),(2932,7485,810,40720,1557,2,96,2,17520.67,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2933,7485,810,40720,1557,2,67,2,3679.34,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2934,7485,810,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2935,7485,810,40720,1557,2,13,1,21200.02,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2936,7485,811,40720,1557,2,96,2,20826.43,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2937,7485,811,40720,1557,2,67,2,4373.55,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2938,7485,811,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2939,7485,811,40720,1557,2,13,1,25200.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2940,7485,812,40720,1557,2,96,2,14545.48,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2941,7485,812,40720,1557,2,67,2,3054.55,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2942,7485,812,40720,1557,2,218,2,0.03,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56');
INSERT INTO `balance_libro_details` VALUES (2943,7485,812,40720,1557,2,13,1,17600.06,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2944,7485,813,40720,1557,2,96,2,10909.10,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2945,7485,813,40720,1557,2,67,2,2290.91,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2946,7485,813,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2947,7485,813,40720,1557,2,13,1,13200.02,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2948,7485,814,40720,1557,2,96,2,23429.76,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2949,7485,814,40720,1557,2,67,2,4920.25,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2950,7485,814,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2951,7485,814,40720,1557,2,13,1,28350.02,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2952,7485,815,40720,1557,2,96,2,10227.29,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2953,7485,815,40720,1557,2,67,2,2147.73,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2954,7485,815,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2955,7485,815,40720,1557,2,13,1,12375.04,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2956,7485,816,40720,1557,2,96,2,12000.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2957,7485,816,40720,1557,2,67,2,2520.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2958,7485,816,40720,1557,2,13,1,14520.00,NULL,'2023-04-23 18:45:14','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2959,7485,817,40720,1557,2,96,2,19834.71,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2960,7485,817,40720,1557,2,67,2,4165.29,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2961,7485,817,40720,1557,2,13,1,24000.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2962,7485,818,40720,1557,2,96,2,12000.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2963,7485,818,40720,1557,2,67,2,2520.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2964,7485,818,40720,1557,2,13,1,14520.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2965,7485,819,40720,1557,2,96,2,10909.10,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2966,7485,819,40720,1557,2,67,2,2290.91,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2967,7485,819,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2968,7485,819,40720,1557,2,13,1,13200.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2969,7485,820,40720,1557,2,96,2,12727.29,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2970,7485,820,40720,1557,2,67,2,2672.73,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2971,7485,820,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2972,7485,820,40720,1557,2,13,1,15400.04,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2973,7485,821,40720,1557,2,96,2,18743.81,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2974,7485,821,40720,1557,2,67,2,3936.20,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2975,7485,821,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2976,7485,821,40720,1557,2,13,1,22680.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2977,7485,822,40720,1557,2,96,2,6115.71,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56');
INSERT INTO `balance_libro_details` VALUES (2978,7485,822,40720,1557,2,67,2,1284.30,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2979,7485,822,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2980,7485,822,40720,1557,2,13,1,7400.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:56','2023-10-30 20:21:56'),(2981,7485,823,40720,1557,2,96,2,12000.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2982,7485,823,40720,1557,2,67,2,2520.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2983,7485,823,40720,1557,2,13,1,14520.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2984,7485,824,40720,1557,2,96,2,17665.29,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2985,7485,824,40720,1557,2,67,2,3709.71,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2986,7485,824,40720,1557,2,13,1,21375.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2987,7485,825,40720,1557,2,96,2,13388.43,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2988,7485,825,40720,1557,2,67,2,2811.57,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2989,7485,825,40720,1557,2,13,1,16200.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2990,7485,826,40720,1557,2,96,2,14752.05,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2991,7485,826,40720,1557,2,67,2,3097.93,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2992,7485,826,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2993,7485,826,40720,1557,2,13,1,17850.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2994,7485,827,40720,1557,2,96,2,12727.29,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2995,7485,827,40720,1557,2,67,2,2672.73,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2996,7485,827,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2997,7485,827,40720,1557,2,13,1,15400.04,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2998,7485,828,40720,1557,2,96,2,14752.05,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(2999,7485,828,40720,1557,2,67,2,3097.93,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3000,7485,828,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3001,7485,828,40720,1557,2,13,1,17850.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3002,7485,829,40720,1557,2,96,2,16942.14,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3003,7485,829,40720,1557,2,67,2,3557.85,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3004,7485,829,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3005,7485,829,40720,1557,2,13,1,20500.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3006,7485,830,40720,1557,2,96,2,16066.10,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3007,7485,830,40720,1557,2,67,2,3373.88,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3008,7485,830,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3009,7485,830,40720,1557,2,13,1,19440.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3010,7485,831,40720,1557,2,96,2,14727.29,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3011,7485,831,40720,1557,2,67,2,3092.73,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3012,7485,831,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57');
INSERT INTO `balance_libro_details` VALUES (3013,7485,831,40720,1557,2,13,1,17820.04,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3014,7485,832,40720,1557,2,96,2,14876.05,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3015,7485,832,40720,1557,2,67,2,3123.97,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3016,7485,832,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3017,7485,832,40720,1557,2,13,1,18000.04,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3018,7485,833,40720,1557,2,96,2,14000.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3019,7485,833,40720,1557,2,67,2,2940.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3020,7485,833,40720,1557,2,13,1,16940.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3021,7485,834,40720,1557,2,96,2,19834.71,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3022,7485,834,40720,1557,2,67,2,4165.29,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3023,7485,834,40720,1557,2,13,1,24000.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3024,7485,835,40720,1557,2,96,2,14752.05,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3025,7485,835,40720,1557,2,67,2,3097.93,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3026,7485,835,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3027,7485,835,40720,1557,2,13,1,17850.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3028,7485,836,40720,1557,2,96,2,10227.29,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3029,7485,836,40720,1557,2,67,2,2147.73,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3030,7485,836,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3031,7485,836,40720,1557,2,13,1,12375.04,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3032,7485,837,40720,1557,2,96,2,42975.19,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3033,7485,837,40720,1557,2,67,2,9024.79,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3034,7485,837,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3035,7485,837,40720,1557,2,13,1,52000.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3036,7485,838,40720,1557,2,96,2,18512.38,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3037,7485,838,40720,1557,2,67,2,3887.60,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3038,7485,838,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3039,7485,838,40720,1557,2,13,1,22400.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3040,7485,839,40720,1557,2,96,2,7809.90,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3041,7485,839,40720,1557,2,67,2,1640.08,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3042,7485,839,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3043,7485,839,40720,1557,2,13,1,9450.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3044,7485,840,40720,1557,2,96,2,16198.33,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3045,7485,840,40720,1557,2,67,2,3401.65,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3046,7485,840,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3047,7485,840,40720,1557,2,13,1,19600.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57');
INSERT INTO `balance_libro_details` VALUES (3048,7485,841,40720,1557,2,96,2,12396.71,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3049,7485,841,40720,1557,2,67,2,2603.31,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3050,7485,841,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3051,7485,841,40720,1557,2,13,1,15000.04,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3052,7485,842,40720,1557,2,96,2,11157.05,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3053,7485,842,40720,1557,2,67,2,2342.98,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3054,7485,842,40720,1557,2,218,2,0.03,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3055,7485,842,40720,1557,2,13,1,13500.06,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3056,7485,843,40720,1557,2,96,2,18181.81,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3057,7485,843,40720,1557,2,67,2,3818.18,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3058,7485,843,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3059,7485,843,40720,1557,2,13,1,22000.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3060,7485,844,40720,1557,2,96,2,37024.81,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3061,7485,844,40720,1557,2,67,2,7775.21,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3062,7485,844,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3063,7485,844,40720,1557,2,13,1,44800.04,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3064,7485,845,40720,1557,2,96,2,25454.52,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3065,7485,845,40720,1557,2,67,2,5345.45,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3066,7485,845,40720,1557,2,218,2,0.03,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3067,7485,845,40720,1557,2,13,1,30800.00,NULL,'2023-04-23 18:45:15','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3068,7485,846,40720,1557,2,96,2,18719.00,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3069,7485,846,40720,1557,2,67,2,3930.99,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3070,7485,846,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3071,7485,846,40720,1557,2,13,1,22650.00,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3072,7485,847,40720,1557,2,96,2,10413.24,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3073,7485,847,40720,1557,2,67,2,2186.78,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3074,7485,847,40720,1557,2,218,2,0.02,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3075,7485,847,40720,1557,2,13,1,12600.04,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3076,7485,848,40720,1557,2,96,2,21157.05,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3077,7485,848,40720,1557,2,67,2,4442.98,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3078,7485,848,40720,1557,2,218,2,0.03,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3079,7485,848,40720,1557,2,13,1,25600.06,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3080,7485,849,40720,1557,2,96,2,603966.95,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3081,7485,849,40720,1557,2,67,2,126833.06,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3082,7485,849,40720,1557,2,218,2,0.01,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57');
INSERT INTO `balance_libro_details` VALUES (3083,7485,849,40720,1557,2,13,1,730800.02,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3084,7485,850,40720,1557,2,96,2,420000.00,NULL,'2023-04-23 18:45:16','2023-10-30 20:21:57','2023-10-30 20:21:57'),(3085,7485,850,40720,1557,2,67,2,88200.00,NULL,'2023-04-23 1