-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-17946611-3
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-01-05 12:16:51','Actividad Generica 1','000001',NULL),(2,NULL,'2021-01-05 12:16:51','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'boxesypfeltriangulo@gmail.com','2994051102',NULL,1,40719,'2021-01-08'),(2,'boxesypfeltriangulo@gmail.com','2994051102','',1,40719,'2021-01-08'),(3,'boxesypfeltriangulo@gmail.com','2994051102','',1,40719,'2021-01-08'),(4,'boxesypfeltriangulo@gmail.com','2994051102','',1,40719,'2021-01-10');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17530 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,1603,40719,1526,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',3685.92,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(2,1603,40719,1526,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',3685.92,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(3,1603,40719,1526,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',22301.50,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(4,1603,40719,1526,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',3138.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(5,1603,40719,1526,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',48603.75,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(6,1603,40719,1526,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',554.93,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(7,1603,40719,1526,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',770.01,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(8,1603,40719,1526,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',2037.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(9,1603,40719,1526,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',34539.62,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(10,1603,40719,1526,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',128.31,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(11,1603,40719,1526,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',1960.20,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(12,1603,40719,1526,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',4682.13,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(13,1603,40719,1526,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',1680.02,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(14,1603,40719,1526,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',46722.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(15,1603,40719,1526,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',2270.01,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(16,1603,40719,1526,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',1435.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(17,1603,40719,1526,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',25277.80,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(18,1603,40719,1526,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',500.46,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(19,1603,40719,1526,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',194.06,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(20,1603,40719,1526,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',22115.57,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(21,1603,40719,1526,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',2760.84,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(22,1603,40719,1526,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',2465.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL);
INSERT INTO `balance_libro` VALUES (23,1603,40719,1526,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',104999.01,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(24,1603,40719,1526,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',686.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(25,1603,40719,1526,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',1771.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(26,1603,40719,1526,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',11392.90,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(27,1603,40719,1526,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',11645.49,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(28,1603,40719,1526,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',23487.72,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(29,1603,40719,1526,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',2070.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(30,1603,40719,1526,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',3685.92,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(31,1603,40719,1526,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',7727.64,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(32,1603,40719,1526,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',1029.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(33,1603,40719,1526,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',5599.40,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(34,1603,40719,1526,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',3927.87,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(35,1603,40719,1526,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',1604.16,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(36,1603,40719,1526,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',259.99,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(37,1603,40719,1526,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',17400.24,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(38,1603,40719,1526,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',6177.68,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(39,1603,40719,1526,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',2464.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(40,1603,40719,1526,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',34308.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(41,1603,40719,1526,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',2435.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(42,1603,40719,1526,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',8797.72,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(43,1603,40719,1526,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',24296.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL);
INSERT INTO `balance_libro` VALUES (44,1603,40719,1526,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',9411.16,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(45,1603,40719,1526,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',999.99,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(46,1603,40719,1526,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',44000.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(47,1603,40719,1526,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',11834.01,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(48,1603,40719,1526,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',37609.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(49,1603,40719,1526,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',3739.35,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(50,1603,40719,1526,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',14273.79,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(51,1603,40719,1526,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',3622.06,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(52,1603,40719,1526,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',4988.11,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(53,1603,40719,1526,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',4154.54,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(54,1603,40719,1526,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',5354.31,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(55,1603,40719,1526,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',5416.89,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(56,1603,40719,1526,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',449.99,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(57,1603,40719,1526,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',19210.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(58,1603,40719,1526,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',68288.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(59,1603,40719,1526,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',16493.00,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(60,1603,40719,1526,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-19','2020-12-19',3799.79,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(61,1603,40719,1526,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-19','2020-12-19',82493.79,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(62,1603,40719,1526,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',7855.74,NULL,NULL,1,'2021-01-10 22:53:47','2021-01-10 22:53:47',NULL),(63,1603,40719,1526,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',3557.85,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(64,1603,40719,1526,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',421.08,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL);
INSERT INTO `balance_libro` VALUES (65,1603,40719,1526,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',800.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(66,1603,40719,1526,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',337.58,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(67,1603,40719,1526,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',1717.99,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(68,1603,40719,1526,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',5799.99,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(69,1603,40719,1526,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',499.99,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(70,1603,40719,1526,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',120.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(71,1603,40719,1526,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-24','2020-12-24',479.98,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(72,1603,40719,1526,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-24','2020-12-24',2300.55,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(73,1603,40719,1526,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-26','2020-12-26',3400.64,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(74,1603,40719,1526,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',8915.98,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(75,1603,40719,1526,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',1043.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(76,1603,40719,1526,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',1756.10,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(77,1603,40719,1526,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',39999.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(78,1603,40719,1526,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',8999.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(79,1603,40719,1526,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',62000.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(80,1603,40719,1526,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',54400.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(81,1603,40719,1526,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',47199.99,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(82,1603,40719,1526,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',47199.99,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(83,1603,40719,1526,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',718.59,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(84,1603,40719,1526,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',1050.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(85,1603,40719,1526,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',581.01,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL);
INSERT INTO `balance_libro` VALUES (86,1603,40719,1526,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',450.01,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(87,1603,40719,1526,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1379.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(88,1603,40719,1526,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',16510.46,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(89,1603,40719,1526,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',31055.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(90,1603,40719,1526,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',137.60,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(91,1603,40719,1526,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',12199.99,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(92,1603,40719,1526,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2607.42,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(93,1603,40719,1526,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2717.55,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(94,1603,40719,1526,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',3660.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(95,1603,40719,1526,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',2148.84,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(96,1603,40719,1526,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',1799.00,NULL,NULL,1,'2021-01-10 22:53:48','2021-01-10 22:53:48',NULL),(97,1603,40719,1526,15,1,'App\\Models\\PeriodLiquidation',NULL,1,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',200268.69,NULL,NULL,1,'2021-01-10 22:57:35','2021-01-10 23:45:07','2021-01-10 23:45:07'),(101,1603,40719,1526,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',15136.87,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(102,1603,40719,1526,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',3600.00,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(103,1603,40719,1526,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',1200.01,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(104,1603,40719,1526,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',1200.01,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(105,1603,40719,1526,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',19300.00,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(106,1603,40719,1526,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',19300.00,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(107,1603,40719,1526,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',32200.00,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(108,1603,40719,1526,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',19300.00,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(109,1603,40719,1526,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',3700.00,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL);
INSERT INTO `balance_libro` VALUES (110,1603,40719,1526,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',11937.00,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(111,1603,40719,1526,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',1200.01,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(112,1603,40719,1526,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',19300.00,NULL,NULL,1,'2021-01-11 00:02:58','2021-01-11 00:02:58',NULL),(113,1603,40719,1526,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',19300.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(114,1603,40719,1526,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',32200.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(115,1603,40719,1526,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',34385.01,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(116,1603,40719,1526,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',3500.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(117,1603,40719,1526,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',1399.99,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(118,1603,40719,1526,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',9779.99,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(119,1603,40719,1526,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',53899.99,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(120,1603,40719,1526,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',1200.01,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(121,1603,40719,1526,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',15908.31,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(122,1603,40719,1526,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',1200.01,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(123,1603,40719,1526,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',3800.01,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(124,1603,40719,1526,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',17124.39,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(125,1603,40719,1526,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',31300.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(126,1603,40719,1526,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',4800.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(127,1603,40719,1526,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',30256.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(128,1603,40719,1526,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',10927.98,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(129,1603,40719,1526,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',1500.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(130,1603,40719,1526,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',3000.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL);
INSERT INTO `balance_libro` VALUES (131,1603,40719,1526,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',30256.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(132,1603,40719,1526,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',29900.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(133,1603,40719,1526,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',1700.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(134,1603,40719,1526,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',1170.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(135,1603,40719,1526,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',30256.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(136,1603,40719,1526,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',7587.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(137,1603,40719,1526,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',29900.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(138,1603,40719,1526,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',12500.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(139,1603,40719,1526,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',27466.81,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(140,1603,40719,1526,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',27466.81,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(141,1603,40719,1526,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',27466.81,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(142,1603,40719,1526,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',9148.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(143,1603,40719,1526,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',7230.80,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(144,1603,40719,1526,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',6600.01,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(145,1603,40719,1526,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',10617.60,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(146,1603,40719,1526,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-12','2020-12-12',81200.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(147,1603,40719,1526,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-12','2020-12-12',80800.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(148,1603,40719,1526,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-12','2020-12-12',65600.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(149,1603,40719,1526,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',3500.01,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(150,1603,40719,1526,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',3700.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(151,1603,40719,1526,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',3200.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL);
INSERT INTO `balance_libro` VALUES (152,1603,40719,1526,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',3822.47,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(153,1603,40719,1526,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',400.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(154,1603,40719,1526,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',20214.80,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(155,1603,40719,1526,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',16500.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(156,1603,40719,1526,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',21505.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(157,1603,40719,1526,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',2400.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(158,1603,40719,1526,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',12479.01,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(159,1603,40719,1526,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',8364.78,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(160,1603,40719,1526,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',12479.01,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(161,1603,40719,1526,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',82800.01,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(162,1603,40719,1526,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',12300.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(163,1603,40719,1526,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',2825.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(164,1603,40719,1526,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',8312.89,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(165,1603,40719,1526,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',5100.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(166,1603,40719,1526,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',42975.50,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(167,1603,40719,1526,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',3884.12,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(168,1603,40719,1526,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',878.91,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(169,1603,40719,1526,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',5400.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(170,1603,40719,1526,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-19','2020-12-19',1500.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(171,1603,40719,1526,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',48294.98,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(172,1603,40719,1526,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',3850.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL);
INSERT INTO `balance_libro` VALUES (173,1603,40719,1526,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',7497.70,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(174,1603,40719,1526,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',22205.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(175,1603,40719,1526,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',20130.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(176,1603,40719,1526,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',22205.00,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(177,1603,40719,1526,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',4053.75,NULL,NULL,1,'2021-01-11 00:02:59','2021-01-11 00:02:59',NULL),(178,1603,40719,1526,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',2600.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(179,1603,40719,1526,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',9264.39,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(180,1603,40719,1526,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',4020.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(181,1603,40719,1526,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',2600.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(182,1603,40719,1526,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',1570.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(183,1603,40719,1526,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',10163.40,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(184,1603,40719,1526,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',2600.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(185,1603,40719,1526,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',2600.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 04:19:49','2021-01-11 04:19:49'),(186,1603,40719,1526,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-24','2020-12-24',3500.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(187,1603,40719,1526,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',67620.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(188,1603,40719,1526,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',9044.75,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(189,1603,40719,1526,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',1900.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(190,1603,40719,1526,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',20500.39,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(191,1603,40719,1526,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',12218.59,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(192,1603,40719,1526,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',16524.16,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(193,1603,40719,1526,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',4495.49,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL);
INSERT INTO `balance_libro` VALUES (194,1603,40719,1526,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',839.99,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(195,1603,40719,1526,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',1300.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(196,1603,40719,1526,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',980.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(197,1603,40719,1526,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',21537.70,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(198,1603,40719,1526,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',3000.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(199,1603,40719,1526,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',10748.81,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(200,1603,40719,1526,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',16400.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(201,1603,40719,1526,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',10741.19,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(202,1603,40719,1526,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',9334.63,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(203,1603,40719,1526,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1921.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(204,1603,40719,1526,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2500.01,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(205,1603,40719,1526,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',12635.17,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(206,1603,40719,1526,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',17200.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(207,1603,40719,1526,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',17560.00,NULL,NULL,1,'2021-01-11 00:03:00','2021-01-11 00:03:00',NULL),(208,1603,40719,1526,16,5,'App\\Models\\PeriodLiquidation',NULL,5,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',12351.75,NULL,NULL,1,'2021-01-11 00:22:31','2021-01-11 00:45:26','2021-01-11 00:45:26'),(209,1603,40719,1526,7,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',16812.11,NULL,NULL,1,'2021-01-11 00:46:38','2021-01-11 00:46:38',NULL),(210,1603,40719,1526,16,8,'App\\Models\\PeriodLiquidation',NULL,8,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',29163.86,NULL,NULL,1,'2021-01-11 00:50:00','2021-01-11 04:19:15','2021-01-11 04:19:15'),(211,1603,40719,1525,15,10,'App\\Models\\PeriodLiquidation',NULL,10,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',43150.94,NULL,NULL,1,'2021-01-11 01:04:36','2021-01-11 01:04:36',NULL),(212,1603,40719,1526,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',2600.00,NULL,NULL,1,'2021-01-11 04:19:49','2021-01-11 04:19:49',NULL),(213,1603,40719,1526,16,16,'App\\Models\\PeriodLiquidation',NULL,16,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',29163.86,NULL,NULL,1,'2021-01-11 04:24:17','2021-01-11 04:24:17',NULL),(214,1603,40719,1526,15,13,'App\\Models\\PeriodLiquidation',NULL,13,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',278962.04,NULL,NULL,1,'2021-01-11 04:25:16','2021-02-11 03:41:39','2021-02-11 03:41:39');
INSERT INTO `balance_libro` VALUES (215,1603,40719,3,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',37642.37,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(216,1603,40719,3,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',2490.00,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(217,1603,40719,3,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',10966.00,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(218,1603,40719,3,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',10128.00,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(219,1603,40719,3,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',10021.30,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(220,1603,40719,3,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',44415.32,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(221,1603,40719,3,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',10185.01,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(222,1603,40719,3,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',14289.89,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(223,1603,40719,3,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',16400.00,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(224,1603,40719,3,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',8842.00,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(225,1603,40719,3,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1090.00,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(226,1603,40719,3,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1700.00,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(227,1603,40719,3,2,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',12457.00,NULL,NULL,1,'2021-02-11 03:01:58','2021-02-11 03:01:58',NULL),(228,1603,40719,3,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',9231.01,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(229,1603,40719,3,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',9086.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(230,1603,40719,3,2,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',21980.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(231,1603,40719,3,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',15587.99,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(232,1603,40719,3,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',19535.99,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(233,1603,40719,3,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',10550.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(234,1603,40719,3,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',11424.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(235,1603,40719,3,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',32125.67,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL);
INSERT INTO `balance_libro` VALUES (236,1603,40719,3,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',13839.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(237,1603,40719,3,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',8006.73,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(238,1603,40719,3,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',8170.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(239,1603,40719,3,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',8847.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(240,1603,40719,3,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',13698.45,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(241,1603,40719,3,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',1900.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(242,1603,40719,3,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',1900.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(243,1603,40719,3,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',23750.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(244,1603,40719,3,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',8420.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(245,1603,40719,3,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',24852.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(246,1603,40719,3,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',3000.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(247,1603,40719,3,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',2000.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(248,1603,40719,3,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',13790.95,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(249,1603,40719,3,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',23209.88,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(250,1603,40719,3,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',16267.29,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(251,1603,40719,3,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',11651.01,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(252,1603,40719,3,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',3000.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(253,1603,40719,3,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',13447.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(254,1603,40719,3,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',18294.99,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(255,1603,40719,3,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',9996.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(256,1603,40719,3,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',1430.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL);
INSERT INTO `balance_libro` VALUES (257,1603,40719,3,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',42370.49,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(258,1603,40719,3,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',6000.00,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(259,1603,40719,3,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',26173.99,NULL,NULL,1,'2021-02-11 03:01:59','2021-02-11 03:01:59',NULL),(260,1603,40719,3,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',3400.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(261,1603,40719,3,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',10470.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(262,1603,40719,3,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',11285.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(263,1603,40719,3,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',4000.01,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(264,1603,40719,3,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',13837.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(265,1603,40719,3,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6405.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(266,1603,40719,3,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',3000.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(267,1603,40719,3,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',8990.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(268,1603,40719,3,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',21010.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(269,1603,40719,3,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',12109.50,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(270,1603,40719,3,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',11194.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(271,1603,40719,3,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',15400.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(272,1603,40719,3,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',4700.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(273,1603,40719,3,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',10194.40,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(274,1603,40719,3,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',99186.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(275,1603,40719,3,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1900.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(276,1603,40719,3,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',128200.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(277,1603,40719,3,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',7600.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL);
INSERT INTO `balance_libro` VALUES (278,1603,40719,3,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',15112.86,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(279,1603,40719,3,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',14498.81,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(280,1603,40719,3,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',3000.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(281,1603,40719,3,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',6155.58,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(282,1603,40719,3,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',35600.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(283,1603,40719,3,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',10716.99,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(284,1603,40719,3,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',10064.01,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(285,1603,40719,3,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2200.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(286,1603,40719,3,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',7500.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(287,1603,40719,3,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',4834.00,NULL,NULL,1,'2021-02-11 03:02:00','2021-02-11 03:02:00',NULL),(288,1603,40719,3,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',3800.01,NULL,NULL,1,'2021-02-11 03:02:01','2021-02-11 03:02:01',NULL),(289,1603,40719,3,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',10395.00,NULL,NULL,1,'2021-02-11 03:02:01','2021-02-11 03:02:01',NULL),(290,1603,40719,3,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',14069.90,NULL,NULL,1,'2021-02-11 03:02:01','2021-02-11 03:02:01',NULL),(304,1603,40719,3,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',22000.00,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(305,1603,40719,3,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',79035.26,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(306,1603,40719,3,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-03','2021-01-03',1000.74,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(307,1603,40719,3,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',5699.67,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(308,1603,40719,3,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',18141.72,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(309,1603,40719,3,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',6919.52,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(310,1603,40719,3,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',3927.87,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(311,1603,40719,3,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1960.20,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL);
INSERT INTO `balance_libro` VALUES (312,1603,40719,3,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4199.99,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(313,1603,40719,3,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4558.35,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(314,1603,40719,3,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1000.00,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(315,1603,40719,3,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',56400.00,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(316,1603,40719,3,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',15600.00,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(317,1603,40719,3,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',6919.52,NULL,NULL,1,'2021-02-11 03:19:23','2021-02-11 03:19:23',NULL),(318,1603,40719,3,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',4116.25,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(319,1603,40719,3,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',524.99,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(320,1603,40719,3,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1344.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(321,1603,40719,3,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3706.42,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(322,1603,40719,3,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',17140.34,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(323,1603,40719,3,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',8218.64,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(324,1603,40719,3,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',2225.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(325,1603,40719,3,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',5004.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(326,1603,40719,3,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',19639.34,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(327,1603,40719,3,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',990.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(328,1603,40719,3,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',4290.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(329,1603,40719,3,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',15007.02,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(330,1603,40719,3,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',37642.36,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(331,1603,40719,3,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',9000.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(332,1603,40719,3,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',22824.24,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL);
INSERT INTO `balance_libro` VALUES (333,1603,40719,3,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',23163.44,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(334,1603,40719,3,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',300.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(335,1603,40719,3,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',3927.87,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(336,1603,40719,3,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',3051.26,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 05:02:57','2021-02-11 05:02:57'),(337,1603,40719,3,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',13379.01,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(338,1603,40719,3,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',2128.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(339,1603,40719,3,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',350.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(340,1603,40719,3,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',988.83,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(341,1603,40719,3,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',662.78,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(342,1603,40719,3,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',500.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(343,1603,40719,3,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',23258.18,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(344,1603,40719,3,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',34092.96,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(345,1603,40719,3,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',1128.99,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(346,1603,40719,3,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',610.01,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(347,1603,40719,3,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',540.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(348,1603,40719,3,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',3927.87,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(349,1603,40719,3,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',1800.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(350,1603,40719,3,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',4162.69,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(351,1603,40719,3,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',8154.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(352,1603,40719,3,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',4917.98,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(353,1603,40719,3,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',6028.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL);
INSERT INTO `balance_libro` VALUES (354,1603,40719,3,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',23737.98,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(355,1603,40719,3,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',200.03,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(356,1603,40719,3,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1106.00,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(357,1603,40719,3,3,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6983.73,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(358,1603,40719,3,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',3956.33,NULL,NULL,1,'2021-02-11 03:19:24','2021-02-11 03:19:24',NULL),(359,1603,40719,3,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6411.25,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(360,1603,40719,3,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',2964.91,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(361,1603,40719,3,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',2858.17,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(362,1603,40719,3,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',67989.22,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(363,1603,40719,3,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8325.38,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(364,1603,40719,3,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',500.00,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(365,1603,40719,3,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8325.38,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(366,1603,40719,3,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',8325.38,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(367,1603,40719,3,3,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',1036.00,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(368,1603,40719,3,3,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',4988.11,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(369,1603,40719,3,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',250.01,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(370,1603,40719,3,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-24','2021-01-24',79035.26,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(371,1603,40719,3,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-24','2021-01-24',79751.28,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(372,1603,40719,3,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',4162.69,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(373,1603,40719,3,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',62534.35,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(374,1603,40719,3,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1298.58,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL);
INSERT INTO `balance_libro` VALUES (375,1603,40719,3,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',5984.28,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 05:03:30','2021-02-11 05:03:30'),(376,1603,40719,3,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',105866.68,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(377,1603,40719,3,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',2261.01,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(378,1603,40719,3,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',4162.69,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(379,1603,40719,3,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',4162.69,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(380,1603,40719,3,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1606.63,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(381,1603,40719,3,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',280.53,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(382,1603,40719,3,3,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',87480.45,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(383,1603,40719,3,3,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',24976.13,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(384,1603,40719,3,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',500.00,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(385,1603,40719,3,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',29600.00,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(386,1603,40719,3,3,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',199.99,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(387,1603,40719,3,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',400.00,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(388,1603,40719,3,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',1699.38,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(389,1603,40719,3,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',4428.60,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 04:58:18','2021-02-11 04:58:18'),(390,1603,40719,3,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',2044.90,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 04:54:49','2021-02-11 04:54:49'),(391,1603,40719,3,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',4162.69,NULL,NULL,1,'2021-02-11 03:19:25','2021-02-11 03:19:25',NULL),(392,1603,40719,3,7,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',3906.31,NULL,NULL,1,'2021-02-11 03:36:22','2021-02-11 03:36:22',NULL),(393,1603,40719,3,7,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',3211.07,NULL,NULL,1,'2021-02-11 03:38:08','2021-02-11 03:38:08',NULL),(394,1603,40719,3,16,26,'App\\Models\\PeriodLiquidation',NULL,26,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',22704.96,NULL,NULL,1,'2021-02-11 03:41:39','2021-02-11 04:53:48','2021-02-11 04:53:48'),(395,1603,40719,3,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',2044.90,NULL,NULL,1,'2021-02-11 04:54:49','2021-02-11 04:55:48','2021-02-11 04:55:48');
INSERT INTO `balance_libro` VALUES (396,1603,40719,3,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',1690.00,NULL,NULL,1,'2021-02-11 04:55:48','2021-02-11 04:56:16','2021-02-11 04:56:16'),(397,1603,40719,3,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',1690.00,NULL,NULL,1,'2021-02-11 04:56:16','2021-02-11 04:58:40','2021-02-11 04:58:40'),(398,1603,40719,3,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',3660.00,NULL,NULL,1,'2021-02-11 04:58:18','2021-02-11 04:58:18',NULL),(399,1603,40719,3,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',1690.00,NULL,NULL,1,'2021-02-11 04:58:40','2021-02-11 04:58:40',NULL),(400,1603,40719,3,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',3051.26,NULL,NULL,1,'2021-02-11 05:02:57','2021-02-11 05:02:57',NULL),(401,1603,40719,3,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',5984.28,NULL,NULL,1,'2021-02-11 05:03:30','2021-02-11 05:03:30',NULL),(402,1603,40719,3,16,40,'App\\Models\\PeriodLiquidation',NULL,40,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',22704.96,NULL,NULL,1,'2021-02-11 05:07:16','2021-02-11 05:07:16',NULL),(403,1603,40719,3,1,403,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-01-31',NULL,60820.32,NULL,NULL,1,'2021-02-12 02:45:43','2021-03-30 00:23:39','2021-03-30 00:23:39'),(404,1603,40719,3,15,41,'App\\Models\\PeriodLiquidation',NULL,41,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',215900.84,NULL,NULL,1,'2021-02-12 03:02:26','2021-02-12 03:02:26',NULL),(503,1603,40719,4,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',3599.99,NULL,NULL,1,'2021-03-07 19:32:51','2021-03-07 19:32:51',NULL),(504,1603,40719,4,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1000.00,NULL,NULL,1,'2021-03-07 19:32:51','2021-03-07 19:32:51',NULL),(505,1603,40719,4,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',11664.00,NULL,NULL,1,'2021-03-07 19:32:51','2021-03-07 21:48:20','2021-03-07 21:48:20'),(506,1603,40719,4,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',8850.00,NULL,NULL,1,'2021-03-07 19:32:51','2021-03-07 21:47:57','2021-03-07 21:47:57'),(507,1603,40719,4,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',8600.00,NULL,NULL,1,'2021-03-07 19:32:51','2021-03-07 21:47:38','2021-03-07 21:47:38'),(508,1603,40719,4,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',10050.01,NULL,NULL,1,'2021-03-07 19:32:51','2021-03-07 21:47:16','2021-03-07 21:47:16'),(509,1603,40719,4,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',1925.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:44:28','2021-03-07 21:44:28'),(510,1603,40719,4,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7067.01,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:44:45','2021-03-07 21:44:45'),(511,1603,40719,4,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',18588.66,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:45:00','2021-03-07 21:45:00'),(512,1603,40719,4,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',2699.99,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:45:17','2021-03-07 21:45:17'),(513,1603,40719,4,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',11189.35,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:44:07','2021-03-07 21:44:07');
INSERT INTO `balance_libro` VALUES (514,1603,40719,4,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',4839.87,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:45:35','2021-03-07 21:45:35'),(515,1603,40719,4,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',2700.01,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 19:32:52',NULL),(516,1603,40719,4,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3200.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:45:57','2021-03-07 21:45:57'),(517,1603,40719,4,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',7080.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:46:16','2021-03-07 21:46:16'),(518,1603,40719,4,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3800.01,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:46:33','2021-03-07 21:46:33'),(519,1603,40719,4,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3800.01,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:42:30','2021-03-07 21:42:30'),(520,1603,40719,4,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3000.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:42:51','2021-03-07 21:42:51'),(521,1603,40719,4,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',5900.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:43:09','2021-03-07 21:43:09'),(522,1603,40719,4,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3800.01,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:43:30','2021-03-07 21:43:30'),(523,1603,40719,4,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',49458.62,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:42:14','2021-03-07 21:42:14'),(524,1603,40719,4,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',10994.23,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:41:58','2021-03-07 21:41:58'),(525,1603,40719,4,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',10640.24,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:41:41','2021-03-07 21:41:41'),(526,1603,40719,4,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',18400.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:41:24','2021-03-07 21:41:24'),(527,1603,40719,4,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',7000.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:41:04','2021-03-07 21:41:04'),(528,1603,40719,4,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',9158.15,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:40:47','2021-03-07 21:40:47'),(529,1603,40719,4,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1050.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:39:25','2021-03-07 21:39:25'),(530,1603,40719,4,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',9145.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:39:43','2021-03-07 21:39:43'),(531,1603,40719,4,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',17884.80,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:39:58','2021-03-07 21:39:58'),(532,1603,40719,4,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2400.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:40:16','2021-03-07 21:40:16'),(533,1603,40719,4,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',92000.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:39:07','2021-03-07 21:39:07');
INSERT INTO `balance_libro` VALUES (534,1603,40719,4,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4400.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:38:50','2021-03-07 21:38:50'),(535,1603,40719,4,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',950.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:38:32','2021-03-07 21:38:32'),(536,1603,40719,4,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',38728.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:38:15','2021-03-07 21:38:15'),(537,1603,40719,4,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',42444.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:37:55','2021-03-07 21:37:55'),(538,1603,40719,4,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',7500.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:37:37','2021-03-07 21:37:37'),(539,1603,40719,4,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',12043.34,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:37:16','2021-03-07 21:37:16'),(540,1603,40719,4,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',11118.84,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:37:02','2021-03-07 21:37:02'),(541,1603,40719,4,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1900.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:36:46','2021-03-07 21:36:46'),(542,1603,40719,4,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7258.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:36:30','2021-03-07 21:36:30'),(543,1603,40719,4,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',8827.10,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:36:14','2021-03-07 21:36:14'),(544,1603,40719,4,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',8779.37,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:35:56','2021-03-07 21:35:56'),(545,1603,40719,4,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',5972.28,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:35:38','2021-03-07 21:35:38'),(546,1603,40719,4,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',11016.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:35:19','2021-03-07 21:35:19'),(547,1603,40719,4,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3000.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:35:04','2021-03-07 21:35:04'),(548,1603,40719,4,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3000.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:34:44','2021-03-07 21:34:44'),(549,1603,40719,4,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',47573.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:34:13','2021-03-07 21:34:13'),(550,1603,40719,4,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2200.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:33:59','2021-03-07 21:33:59'),(551,1603,40719,4,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',15557.90,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:33:45','2021-03-07 21:33:45'),(552,1603,40719,4,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',900.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:33:30','2021-03-07 21:33:30'),(553,1603,40719,4,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6000.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:33:13','2021-03-07 21:33:13');
INSERT INTO `balance_libro` VALUES (554,1603,40719,4,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9793.99,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:32:55','2021-03-07 21:32:55'),(555,1603,40719,4,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',3000.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:32:36','2021-03-07 21:32:36'),(556,1603,40719,4,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',2200.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:32:16','2021-03-07 21:32:16'),(557,1603,40719,4,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',7551.31,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:32:00','2021-03-07 21:32:00'),(558,1603,40719,4,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',3000.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:31:44','2021-03-07 21:31:44'),(559,1603,40719,4,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',1900.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:31:21','2021-03-07 21:31:21'),(560,1603,40719,4,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',3000.00,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:31:06','2021-03-07 21:31:06'),(561,1603,40719,4,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',1360.69,NULL,NULL,1,'2021-03-07 19:32:52','2021-03-07 21:30:45','2021-03-07 21:30:45'),(562,1603,40719,4,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',19000.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(563,1603,40719,4,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',19180.05,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(564,1603,40719,4,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',10294.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:30:29','2021-03-07 21:30:29'),(565,1603,40719,4,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',10361.40,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:30:14','2021-03-07 21:30:14'),(566,1603,40719,4,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3500.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:29:59','2021-03-07 21:29:59'),(567,1603,40719,4,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3800.01,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:49:43','2021-03-07 21:49:43'),(568,1603,40719,4,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2370.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:29:40','2021-03-07 21:29:40'),(569,1603,40719,4,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',11473.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:29:28','2021-03-07 21:29:28'),(570,1603,40719,4,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',9076.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:29:10','2021-03-07 21:29:10'),(571,1603,40719,4,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',12474.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:28:45','2021-03-07 21:28:45'),(572,1603,40719,4,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',3000.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(573,1603,40719,4,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',20130.06,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL);
INSERT INTO `balance_libro` VALUES (574,1603,40719,4,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',5857.01,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:28:29','2021-03-07 21:28:29'),(575,1603,40719,4,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1750.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:28:14','2021-03-07 21:28:14'),(576,1603,40719,4,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',9030.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:28:02','2021-03-07 21:28:02'),(577,1603,40719,4,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',5546.24,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:27:48','2021-03-07 21:27:48'),(578,1603,40719,4,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',652.66,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(579,1603,40719,4,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',9648.98,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:27:24','2021-03-07 21:27:24'),(580,1603,40719,4,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',2200.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:27:05','2021-03-07 21:27:05'),(581,1603,40719,4,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',22425.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:26:48','2021-03-07 21:26:48'),(582,1603,40719,4,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',2650.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:26:34','2021-03-07 21:26:34'),(583,1603,40719,4,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',42801.15,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(584,1603,40719,4,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',7900.01,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:26:17','2021-03-07 21:26:17'),(585,1603,40719,4,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',11130.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:26:00','2021-03-07 21:26:00'),(586,1603,40719,4,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',17926.60,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:25:47','2021-03-07 21:25:47'),(587,1603,40719,4,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',13042.40,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:25:29','2021-03-07 21:25:29'),(588,1603,40719,4,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',28180.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:25:06','2021-03-07 21:25:06'),(589,1603,40719,4,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',8304.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:24:31','2021-03-07 21:24:31'),(590,1603,40719,4,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',18977.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:24:11','2021-03-07 21:24:11'),(591,1603,40719,4,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',11511.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(592,1603,40719,4,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',13834.99,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:23:56','2021-03-07 21:23:56'),(593,1603,40719,4,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',10719.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:23:40','2021-03-07 21:23:40');
INSERT INTO `balance_libro` VALUES (594,1603,40719,4,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3600.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:23:26','2021-03-07 21:23:26'),(595,1603,40719,4,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10902.98,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(596,1603,40719,4,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',21314.60,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(597,1603,40719,4,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1180.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:23:02','2021-03-07 21:23:02'),(598,1603,40719,4,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',9599.99,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 21:22:45','2021-03-07 21:22:45'),(599,1603,40719,4,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',500.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(600,1603,40719,4,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1999.99,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(601,1603,40719,4,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',60656.70,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(602,1603,40719,4,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',616.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(603,1603,40719,4,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',5799.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 20:49:13','2021-03-07 20:49:13'),(604,1603,40719,4,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1960.20,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(605,1603,40719,4,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1300.02,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(606,1603,40719,4,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',17117.17,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(607,1603,40719,4,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',1106.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(608,1603,40719,4,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',504.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(609,1603,40719,4,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',12567.06,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 20:50:02','2021-03-07 20:50:02'),(610,1603,40719,4,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',14369.00,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(611,1603,40719,4,3,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',6426.14,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(612,1603,40719,4,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1250.09,NULL,NULL,1,'2021-03-07 19:32:53','2021-03-07 19:32:53',NULL),(613,1603,40719,4,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1000.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(614,1603,40719,4,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',45000.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL);
INSERT INTO `balance_libro` VALUES (615,1603,40719,4,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',61600.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(616,1603,40719,4,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1559.99,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(617,1603,40719,4,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1176.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(618,1603,40719,4,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',22826.47,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(619,1603,40719,4,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',21798.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(620,1603,40719,4,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',3456.07,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(621,1603,40719,4,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1239.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(622,1603,40719,4,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',10731.57,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(623,1603,40719,4,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',12466.73,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(624,1603,40719,4,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',2345.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(625,1603,40719,4,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',13695.45,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(626,1603,40719,4,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',59200.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(627,1603,40719,4,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',23400.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(628,1603,40719,4,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2500.01,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(629,1603,40719,4,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',4411.74,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(630,1603,40719,4,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2830.69,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(631,1603,40719,4,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',899.99,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(632,1603,40719,4,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',4411.74,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(633,1603,40719,4,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',2345.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(634,1603,40719,4,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',1334.99,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(635,1603,40719,4,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',9874.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL);
INSERT INTO `balance_libro` VALUES (636,1603,40719,4,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',5009.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(637,1603,40719,4,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1379.98,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(638,1603,40719,4,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',799.99,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(639,1603,40719,4,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',8823.47,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(640,1603,40719,4,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',45899.99,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(641,1603,40719,4,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2345.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(642,1603,40719,4,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',4411.74,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(643,1603,40719,4,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',6795.51,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(644,1603,40719,4,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',58399.44,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(645,1603,40719,4,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',6000.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(646,1603,40719,4,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1644.97,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(647,1603,40719,4,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',9848.14,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(648,1603,40719,4,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',8823.48,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(649,1603,40719,4,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',102.78,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(650,1603,40719,4,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2345.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(651,1603,40719,4,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1176.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(652,1603,40719,4,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',3038.40,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(653,1603,40719,4,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',15065.89,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(654,1603,40719,4,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',45367.09,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(655,1603,40719,4,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',500.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(656,1603,40719,4,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',35900.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL);
INSERT INTO `balance_libro` VALUES (657,1603,40719,4,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',26854.67,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(658,1603,40719,4,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',363.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(659,1603,40719,4,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',59900.01,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 20:50:45','2021-03-07 20:50:45'),(660,1603,40719,4,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',4100.40,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(661,1603,40719,4,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',3790.02,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 19:32:54',NULL),(662,1603,40719,4,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',2958.00,NULL,NULL,1,'2021-03-07 19:32:54','2021-03-07 20:51:06','2021-03-07 20:51:06'),(663,1603,40719,4,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',10097.18,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(664,1603,40719,4,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',34487.00,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(665,1603,40719,4,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',3411.32,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(666,1603,40719,4,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1298.33,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(667,1603,40719,4,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',65919.93,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(668,1603,40719,4,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',4356.83,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(669,1603,40719,4,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',8713.66,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(670,1603,40719,4,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',999.99,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(671,1603,40719,4,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',5398.00,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 20:51:29','2021-03-07 20:51:29'),(672,1603,40719,4,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',79600.00,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(673,1603,40719,4,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3599.99,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(674,1603,40719,4,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',26470.41,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(675,1603,40719,4,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',378.00,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(676,1603,40719,4,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',6802.61,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(677,1603,40719,4,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',100.00,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL);
INSERT INTO `balance_libro` VALUES (678,1603,40719,4,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1550.00,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(679,1603,40719,4,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',4755.00,NULL,NULL,1,'2021-03-07 19:32:55','2021-03-07 19:32:55',NULL),(680,1603,40719,4,7,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',5293.38,NULL,NULL,1,'2021-03-07 19:53:28','2021-03-07 19:53:28',NULL),(681,1603,40719,4,7,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',3519.75,NULL,NULL,1,'2021-03-07 19:54:29','2021-03-07 19:54:29',NULL),(682,1603,40719,4,16,47,'App\\Models\\PeriodLiquidation',NULL,47,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',18500.90,NULL,NULL,1,'2021-03-07 19:56:36','2021-03-07 20:48:46','2021-03-07 20:48:46'),(683,1603,40719,4,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',5799.00,NULL,NULL,1,'2021-03-07 20:49:13','2021-03-07 20:49:13',NULL),(684,1603,40719,4,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',12567.06,NULL,NULL,1,'2021-03-07 20:50:02','2021-03-07 20:50:02',NULL),(685,1603,40719,4,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',59900.01,NULL,NULL,1,'2021-03-07 20:50:45','2021-03-07 20:50:45',NULL),(686,1603,40719,4,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',2958.00,NULL,NULL,1,'2021-03-07 20:51:06','2021-03-07 20:51:06',NULL),(687,1603,40719,4,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',5398.00,NULL,NULL,1,'2021-03-07 20:51:29','2021-03-07 20:51:29',NULL),(688,1603,40719,4,16,58,'App\\Models\\PeriodLiquidation',NULL,58,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',18500.90,NULL,NULL,1,'2021-03-07 20:54:23','2021-03-07 21:18:43','2021-03-07 21:18:43'),(689,1603,40719,4,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',9599.99,NULL,NULL,1,'2021-03-07 21:22:45','2021-03-07 21:22:45',NULL),(690,1603,40719,4,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1180.00,NULL,NULL,1,'2021-03-07 21:23:02','2021-03-07 21:23:02',NULL),(691,1603,40719,4,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3600.00,NULL,NULL,1,'2021-03-07 21:23:26','2021-03-07 21:23:26',NULL),(692,1603,40719,4,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',10719.00,NULL,NULL,1,'2021-03-07 21:23:40','2021-03-07 21:23:40',NULL),(693,1603,40719,4,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',13834.99,NULL,NULL,1,'2021-03-07 21:23:56','2021-03-07 21:23:56',NULL),(694,1603,40719,4,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',18977.00,NULL,NULL,1,'2021-03-07 21:24:11','2021-03-07 21:24:11',NULL),(695,1603,40719,4,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',8304.00,NULL,NULL,1,'2021-03-07 21:24:31','2021-03-07 21:24:31',NULL),(696,1603,40719,4,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',28180.00,NULL,NULL,1,'2021-03-07 21:25:06','2021-03-07 21:25:06',NULL),(697,1603,40719,4,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',13042.40,NULL,NULL,1,'2021-03-07 21:25:29','2021-03-07 21:25:29',NULL),(698,1603,40719,4,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',17926.60,NULL,NULL,1,'2021-03-07 21:25:47','2021-03-07 21:25:47',NULL);
INSERT INTO `balance_libro` VALUES (699,1603,40719,4,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',11130.00,NULL,NULL,1,'2021-03-07 21:26:00','2021-03-07 21:26:00',NULL),(700,1603,40719,4,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',7900.01,NULL,NULL,1,'2021-03-07 21:26:17','2021-03-07 21:26:17',NULL),(701,1603,40719,4,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',2650.00,NULL,NULL,1,'2021-03-07 21:26:34','2021-03-07 21:26:34',NULL),(702,1603,40719,4,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',22425.00,NULL,NULL,1,'2021-03-07 21:26:48','2021-03-07 21:26:48',NULL),(703,1603,40719,4,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',2200.00,NULL,NULL,1,'2021-03-07 21:27:05','2021-03-07 21:27:05',NULL),(704,1603,40719,4,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',9648.98,NULL,NULL,1,'2021-03-07 21:27:24','2021-03-07 21:27:24',NULL),(705,1603,40719,4,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',5546.24,NULL,NULL,1,'2021-03-07 21:27:48','2021-03-07 21:27:48',NULL),(706,1603,40719,4,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',9030.00,NULL,NULL,1,'2021-03-07 21:28:02','2021-03-07 21:28:02',NULL),(707,1603,40719,4,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1750.00,NULL,NULL,1,'2021-03-07 21:28:14','2021-03-07 21:28:14',NULL),(708,1603,40719,4,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',5857.01,NULL,NULL,1,'2021-03-07 21:28:29','2021-03-07 21:28:29',NULL),(709,1603,40719,4,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',12474.00,NULL,NULL,1,'2021-03-07 21:28:45','2021-03-07 21:28:45',NULL),(710,1603,40719,4,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',9076.00,NULL,NULL,1,'2021-03-07 21:29:10','2021-03-07 21:29:10',NULL),(711,1603,40719,4,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',11473.00,NULL,NULL,1,'2021-03-07 21:29:28','2021-03-07 21:29:28',NULL),(712,1603,40719,4,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2370.00,NULL,NULL,1,'2021-03-07 21:29:40','2021-03-07 21:29:40',NULL),(713,1603,40719,4,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3500.00,NULL,NULL,1,'2021-03-07 21:29:59','2021-03-07 21:29:59',NULL),(714,1603,40719,4,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',10361.40,NULL,NULL,1,'2021-03-07 21:30:14','2021-03-07 21:30:14',NULL),(715,1603,40719,4,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',10294.00,NULL,NULL,1,'2021-03-07 21:30:29','2021-03-07 21:30:29',NULL),(716,1603,40719,4,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',1360.69,NULL,NULL,1,'2021-03-07 21:30:45','2021-03-07 21:30:45',NULL),(717,1603,40719,4,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',3000.00,NULL,NULL,1,'2021-03-07 21:31:06','2021-03-07 21:31:06',NULL),(718,1603,40719,4,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',1900.00,NULL,NULL,1,'2021-03-07 21:31:21','2021-03-07 21:31:21',NULL),(719,1603,40719,4,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',3000.00,NULL,NULL,1,'2021-03-07 21:31:44','2021-03-07 21:31:44',NULL);
INSERT INTO `balance_libro` VALUES (720,1603,40719,4,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',7551.31,NULL,NULL,1,'2021-03-07 21:32:00','2021-03-07 21:32:00',NULL),(721,1603,40719,4,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',2200.00,NULL,NULL,1,'2021-03-07 21:32:16','2021-03-07 21:32:16',NULL),(722,1603,40719,4,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',3000.00,NULL,NULL,1,'2021-03-07 21:32:36','2021-03-07 21:32:36',NULL),(723,1603,40719,4,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9793.99,NULL,NULL,1,'2021-03-07 21:32:55','2021-03-07 21:32:55',NULL),(724,1603,40719,4,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6000.00,NULL,NULL,1,'2021-03-07 21:33:13','2021-03-07 21:33:13',NULL),(725,1603,40719,4,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',900.00,NULL,NULL,1,'2021-03-07 21:33:30','2021-03-07 21:33:30',NULL),(726,1603,40719,4,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',15557.90,NULL,NULL,1,'2021-03-07 21:33:45','2021-03-07 21:33:45',NULL),(727,1603,40719,4,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2200.00,NULL,NULL,1,'2021-03-07 21:33:59','2021-03-07 21:33:59',NULL),(728,1603,40719,4,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',47573.00,NULL,NULL,1,'2021-03-07 21:34:13','2021-03-07 21:34:13',NULL),(729,1603,40719,4,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3000.00,NULL,NULL,1,'2021-03-07 21:34:44','2021-03-07 21:34:44',NULL),(730,1603,40719,4,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3000.00,NULL,NULL,1,'2021-03-07 21:35:04','2021-03-07 21:35:04',NULL),(731,1603,40719,4,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',11016.00,NULL,NULL,1,'2021-03-07 21:35:19','2021-03-07 21:35:19',NULL),(732,1603,40719,4,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',5972.28,NULL,NULL,1,'2021-03-07 21:35:38','2021-03-07 21:35:38',NULL),(733,1603,40719,4,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',8779.37,NULL,NULL,1,'2021-03-07 21:35:56','2021-03-07 21:35:56',NULL),(734,1603,40719,4,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',8827.10,NULL,NULL,1,'2021-03-07 21:36:14','2021-03-07 21:36:14',NULL),(735,1603,40719,4,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7258.00,NULL,NULL,1,'2021-03-07 21:36:30','2021-03-07 21:36:30',NULL),(736,1603,40719,4,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1900.00,NULL,NULL,1,'2021-03-07 21:36:46','2021-03-07 21:36:46',NULL),(737,1603,40719,4,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',11118.84,NULL,NULL,1,'2021-03-07 21:37:02','2021-03-07 21:37:02',NULL),(738,1603,40719,4,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',12043.34,NULL,NULL,1,'2021-03-07 21:37:16','2021-03-07 21:37:16',NULL),(739,1603,40719,4,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',7500.00,NULL,NULL,1,'2021-03-07 21:37:37','2021-03-07 21:37:37',NULL),(740,1603,40719,4,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',42444.00,NULL,NULL,1,'2021-03-07 21:37:55','2021-03-07 21:37:55',NULL);
INSERT INTO `balance_libro` VALUES (741,1603,40719,4,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',38728.00,NULL,NULL,1,'2021-03-07 21:38:15','2021-03-07 21:38:15',NULL),(742,1603,40719,4,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',950.00,NULL,NULL,1,'2021-03-07 21:38:32','2021-03-07 21:38:32',NULL),(743,1603,40719,4,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4400.00,NULL,NULL,1,'2021-03-07 21:38:50','2021-03-07 21:38:50',NULL),(744,1603,40719,4,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',92000.00,NULL,NULL,1,'2021-03-07 21:39:07','2021-03-07 21:39:07',NULL),(745,1603,40719,4,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1050.00,NULL,NULL,1,'2021-03-07 21:39:25','2021-03-07 21:39:25',NULL),(746,1603,40719,4,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',9145.00,NULL,NULL,1,'2021-03-07 21:39:43','2021-03-07 21:39:43',NULL),(747,1603,40719,4,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',17884.80,NULL,NULL,1,'2021-03-07 21:39:58','2021-03-07 21:39:58',NULL),(748,1603,40719,4,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2400.00,NULL,NULL,1,'2021-03-07 21:40:16','2021-03-07 21:40:16',NULL),(749,1603,40719,4,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',9158.15,NULL,NULL,1,'2021-03-07 21:40:47','2021-03-07 21:40:47',NULL),(750,1603,40719,4,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',7000.00,NULL,NULL,1,'2021-03-07 21:41:04','2021-03-07 21:41:04',NULL),(751,1603,40719,4,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',18400.00,NULL,NULL,1,'2021-03-07 21:41:24','2021-03-07 21:41:24',NULL),(752,1603,40719,4,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',10640.24,NULL,NULL,1,'2021-03-07 21:41:41','2021-03-07 21:41:41',NULL),(753,1603,40719,4,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',10994.23,NULL,NULL,1,'2021-03-07 21:41:58','2021-03-07 21:41:58',NULL),(754,1603,40719,4,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',49458.62,NULL,NULL,1,'2021-03-07 21:42:14','2021-03-07 21:42:14',NULL),(755,1603,40719,4,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3800.01,NULL,NULL,1,'2021-03-07 21:42:30','2021-03-07 21:42:30',NULL),(756,1603,40719,4,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3000.00,NULL,NULL,1,'2021-03-07 21:42:51','2021-03-07 21:42:51',NULL),(757,1603,40719,4,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',5900.00,NULL,NULL,1,'2021-03-07 21:43:09','2021-03-07 21:43:09',NULL),(758,1603,40719,4,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3800.01,NULL,NULL,1,'2021-03-07 21:43:30','2021-03-07 21:43:30',NULL),(759,1603,40719,4,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',11189.35,NULL,NULL,1,'2021-03-07 21:44:07','2021-03-07 21:44:07',NULL),(760,1603,40719,4,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',1925.00,NULL,NULL,1,'2021-03-07 21:44:28','2021-03-07 21:44:28',NULL),(761,1603,40719,4,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7067.01,NULL,NULL,1,'2021-03-07 21:44:45','2021-03-07 21:44:45',NULL);
INSERT INTO `balance_libro` VALUES (762,1603,40719,4,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',18588.66,NULL,NULL,1,'2021-03-07 21:45:00','2021-03-07 21:45:00',NULL),(763,1603,40719,4,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',2699.99,NULL,NULL,1,'2021-03-07 21:45:17','2021-03-07 21:45:17',NULL),(764,1603,40719,4,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',4839.87,NULL,NULL,1,'2021-03-07 21:45:35','2021-03-07 21:45:35',NULL),(765,1603,40719,4,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3200.00,NULL,NULL,1,'2021-03-07 21:45:57','2021-03-07 21:45:57',NULL),(766,1603,40719,4,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',7080.00,NULL,NULL,1,'2021-03-07 21:46:16','2021-03-07 21:46:16',NULL),(767,1603,40719,4,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3800.01,NULL,NULL,1,'2021-03-07 21:46:33','2021-03-07 21:46:33',NULL),(768,1603,40719,4,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',10050.01,NULL,NULL,1,'2021-03-07 21:47:16','2021-03-07 21:47:16',NULL),(769,1603,40719,4,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',8600.00,NULL,NULL,1,'2021-03-07 21:47:38','2021-03-07 21:47:38',NULL),(770,1603,40719,4,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',8850.00,NULL,NULL,1,'2021-03-07 21:47:57','2021-03-07 21:47:57',NULL),(771,1603,40719,4,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',11664.00,NULL,NULL,1,'2021-03-07 21:48:20','2021-03-07 21:48:20',NULL),(772,1603,40719,4,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3800.01,NULL,NULL,1,'2021-03-07 21:49:43','2021-03-07 21:49:43',NULL),(773,1603,40719,4,16,226,'App\\Models\\PeriodLiquidation',NULL,226,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',18500.90,NULL,NULL,1,'2021-03-07 21:51:21','2021-03-07 21:51:21',NULL),(774,1603,40719,4,15,227,'App\\Models\\PeriodLiquidation',NULL,227,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',181976.71,NULL,NULL,1,'2021-03-07 22:09:37','2021-03-07 22:09:37',NULL),(775,1603,40719,3,1,775,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-01-31',NULL,62185.80,NULL,NULL,1,'2021-03-30 00:28:20','2021-03-30 00:28:20',NULL),(776,1603,40719,4,1,776,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-02-28',NULL,59911.10,NULL,NULL,1,'2021-03-30 00:28:56','2021-03-30 00:28:56',NULL),(777,1603,40719,5,1,777,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-03-31',NULL,62751.66,NULL,NULL,1,'2021-04-12 00:02:23','2021-04-12 00:02:23',NULL),(778,1603,40719,5,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',16650.57,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(779,1603,40719,5,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',47578.00,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(780,1603,40719,5,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',12465.01,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(781,1603,40719,5,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',8799.00,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(782,1603,40719,5,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',3641.01,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL);
INSERT INTO `balance_libro` VALUES (783,1603,40719,5,2,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',4300.00,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(784,1603,40719,5,2,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',3974.86,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(785,1603,40719,5,2,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',6384.92,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(786,1603,40719,5,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',5416.50,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(787,1603,40719,5,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',620.00,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(788,1603,40719,5,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2200.00,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(789,1603,40719,5,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',19480.04,NULL,NULL,1,'2021-04-12 23:28:56','2021-04-12 23:28:56',NULL),(790,1603,40719,5,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2930.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(791,1603,40719,5,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',11576.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(792,1603,40719,5,2,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',13541.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(793,1603,40719,5,2,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',20754.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(794,1603,40719,5,2,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',13838.39,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(795,1603,40719,5,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',13860.90,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(796,1603,40719,5,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',11416.98,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(797,1603,40719,5,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',34967.60,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(798,1603,40719,5,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3800.01,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(799,1603,40719,5,2,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1030.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(800,1603,40719,5,2,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',7511.66,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(801,1603,40719,5,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',34967.60,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(802,1603,40719,5,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',34967.60,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(803,1603,40719,5,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',5805.88,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL);
INSERT INTO `balance_libro` VALUES (804,1603,40719,5,2,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3000.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(805,1603,40719,5,2,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',13707.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(806,1603,40719,5,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',30113.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(807,1603,40719,5,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',7900.01,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(808,1603,40719,5,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',56039.27,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(809,1603,40719,5,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',16600.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(810,1603,40719,5,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',25102.18,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(811,1603,40719,5,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',3000.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(812,1603,40719,5,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',3760.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(813,1603,40719,5,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',10170.05,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(814,1603,40719,5,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',700.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(815,1603,40719,5,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',9914.70,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(816,1603,40719,5,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',12854.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(817,1603,40719,5,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',5890.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(818,1603,40719,5,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1710.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(819,1603,40719,5,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',12100.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(820,1603,40719,5,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3000.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(821,1603,40719,5,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',18351.01,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(822,1603,40719,5,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',5448.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(823,1603,40719,5,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',15073.70,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(824,1603,40719,5,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',3000.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL);
INSERT INTO `balance_libro` VALUES (825,1603,40719,5,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',21328.82,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(826,1603,40719,5,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',500.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(827,1603,40719,5,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',4100.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(828,1603,40719,5,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',12110.66,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(829,1603,40719,5,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',17013.14,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(830,1603,40719,5,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1800.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(831,1603,40719,5,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',11300.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(832,1603,40719,5,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',3800.01,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(833,1603,40719,5,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',91550.35,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(834,1603,40719,5,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',8804.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(835,1603,40719,5,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',9767.50,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(836,1603,40719,5,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',12309.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(837,1603,40719,5,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1800.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(838,1603,40719,5,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',7420.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(839,1603,40719,5,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',2662.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(840,1603,40719,5,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',16225.68,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(841,1603,40719,5,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',2662.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(842,1603,40719,5,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',2200.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(843,1603,40719,5,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1911.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(844,1603,40719,5,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',40260.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(845,1603,40719,5,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1800.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL);
INSERT INTO `balance_libro` VALUES (846,1603,40719,5,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',6292.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(847,1603,40719,5,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1700.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(848,1603,40719,5,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',510.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(849,1603,40719,5,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',13576.70,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(850,1603,40719,5,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',19004.55,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(851,1603,40719,5,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',8700.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(852,1603,40719,5,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',53003.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(853,1603,40719,5,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',620.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(854,1603,40719,5,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',11901.11,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(855,1603,40719,5,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',25721.50,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(856,1603,40719,5,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',16111.83,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(857,1603,40719,5,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',4150.00,NULL,NULL,1,'2021-04-12 23:28:57','2021-04-12 23:28:57',NULL),(858,1603,40719,5,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1000.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(859,1603,40719,5,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',5100.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(860,1603,40719,5,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',112000.02,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(861,1603,40719,5,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',24479.13,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(862,1603,40719,5,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',6500.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(863,1603,40719,5,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',13671.58,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(864,1603,40719,5,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',10858.83,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(865,1603,40719,5,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',16991.70,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(866,1603,40719,5,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',11962.54,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL);
INSERT INTO `balance_libro` VALUES (867,1603,40719,5,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4300.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(868,1603,40719,5,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',2835.01,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(869,1603,40719,5,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',11208.84,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(870,1603,40719,5,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4320.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(871,1603,40719,5,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',92300.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(872,1603,40719,5,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',11701.11,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(873,1603,40719,5,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',11100.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(874,1603,40719,5,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3500.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(875,1603,40719,5,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',1960.20,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(876,1603,40719,5,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1217.10,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(877,1603,40719,5,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',23020.37,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(878,1603,40719,5,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',72.21,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(879,1603,40719,5,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3411.32,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(880,1603,40719,5,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',16610.12,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(881,1603,40719,5,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',329.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(882,1603,40719,5,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',35920.50,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(883,1603,40719,5,3,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',66815.51,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(884,1603,40719,5,3,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',4411.74,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(885,1603,40719,5,3,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',240.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(886,1603,40719,5,3,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1120.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(887,1603,40719,5,3,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',4973.64,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-13 03:15:03','2021-04-13 03:15:03');
INSERT INTO `balance_libro` VALUES (888,1603,40719,5,3,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1199.99,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(889,1603,40719,5,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1000.60,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(890,1603,40719,5,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',67243.46,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(891,1603,40719,5,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1446.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(892,1603,40719,5,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',500.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(893,1603,40719,5,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3329.45,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(894,1603,40719,5,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',4105.78,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(895,1603,40719,5,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2282.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(896,1603,40719,5,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',522.72,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(897,1603,40719,5,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1630.37,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(898,1603,40719,5,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',8994.25,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(899,1603,40719,5,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',980.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(900,1603,40719,5,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',130.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(901,1603,40719,5,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',8467.75,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(902,1603,40719,5,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',8514.23,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(903,1603,40719,5,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',3102.45,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(904,1603,40719,5,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',22476.29,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(905,1603,40719,5,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1999.20,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(906,1603,40719,5,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1800.01,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(907,1603,40719,5,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',3891.55,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(908,1603,40719,5,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',2449.97,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL);
INSERT INTO `balance_libro` VALUES (909,1603,40719,5,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',15860.26,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(910,1603,40719,5,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',2282.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(911,1603,40719,5,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',12203.06,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(912,1603,40719,5,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1300.08,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(913,1603,40719,5,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',17014.31,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(914,1603,40719,5,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1316.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(915,1603,40719,5,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',500.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(916,1603,40719,5,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',45640.14,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(917,1603,40719,5,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',29689.14,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(918,1603,40719,5,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',334795.96,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(919,1603,40719,5,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2364.49,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(920,1603,40719,5,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',679.37,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(921,1603,40719,5,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',363.00,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(922,1603,40719,5,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',2182.86,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(923,1603,40719,5,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',64739.84,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(924,1603,40719,5,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',4938.30,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(925,1603,40719,5,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1686.41,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-14 03:10:45','2021-04-14 03:10:45'),(926,1603,40719,5,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',6893.74,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-12 23:28:58',NULL),(927,1603,40719,5,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',3973.73,NULL,NULL,1,'2021-04-12 23:28:58','2021-04-13 04:02:42','2021-04-13 04:02:42'),(928,1603,40719,5,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',14189.63,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(929,1603,40719,5,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1274.01,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL);
INSERT INTO `balance_libro` VALUES (930,1603,40719,5,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',10110.00,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(931,1603,40719,5,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',2100.00,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(932,1603,40719,5,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1205.78,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-13 03:17:07','2021-04-13 03:17:07'),(933,1603,40719,5,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',2675.49,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(934,1603,40719,5,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',631.19,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(935,1603,40719,5,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',5464.52,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(936,1603,40719,5,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',12659.10,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(937,1603,40719,5,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',23313.07,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(938,1603,40719,5,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',398.14,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(939,1603,40719,5,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',900.00,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(940,1603,40719,5,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',14343.00,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(941,1603,40719,5,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',1410.65,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(942,1603,40719,5,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',832.75,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(943,1603,40719,5,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1316.00,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(944,1603,40719,5,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',88889.45,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(945,1603,40719,5,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',29629.82,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(946,1603,40719,5,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',8951.05,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(947,1603,40719,5,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',96800.00,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(948,1603,40719,5,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',9966.05,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(949,1603,40719,5,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',71199.98,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(950,1603,40719,5,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',4755.00,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL);
INSERT INTO `balance_libro` VALUES (951,1603,40719,5,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4000.00,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(952,1603,40719,5,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',363.00,NULL,NULL,1,'2021-04-12 23:28:59','2021-04-12 23:28:59',NULL),(953,1603,40719,5,3,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',4973.64,NULL,NULL,1,'2021-04-13 03:15:03','2021-04-13 03:15:03',NULL),(954,1603,40719,5,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1205.78,NULL,NULL,1,'2021-04-13 03:17:07','2021-04-13 03:17:07',NULL),(955,1603,40719,5,7,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3639.32,NULL,NULL,1,'2021-04-13 03:34:59','2021-04-13 03:38:12','2021-04-13 03:38:12'),(956,1603,40719,5,7,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3639.32,NULL,NULL,1,'2021-04-13 03:36:37','2021-04-13 03:36:37',NULL),(957,1603,40719,5,7,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3988.89,NULL,NULL,1,'2021-04-13 03:37:19','2021-04-13 03:37:19',NULL),(958,1603,40719,5,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',3973.73,NULL,NULL,1,'2021-04-13 04:02:42','2021-04-13 04:03:09','2021-04-13 04:03:09'),(959,1603,40719,5,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',3879.86,NULL,NULL,1,'2021-04-13 04:03:09','2021-04-13 04:03:09',NULL),(960,1603,40719,5,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1800.00,NULL,NULL,1,'2021-04-14 03:10:45','2021-04-14 03:10:45',NULL),(961,1603,40719,6,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1000.02,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(962,1603,40719,6,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',500.80,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(963,1603,40719,6,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',2801.15,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(964,1603,40719,6,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',905.21,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(965,1603,40719,6,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',56065.94,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(966,1603,40719,6,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1100.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(967,1603,40719,6,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',11400.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(968,1603,40719,6,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1435.94,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(969,1603,40719,6,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',4062.87,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(970,1603,40719,6,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1178.02,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(971,1603,40719,6,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-02','2021-04-02',3050.03,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:57:38','2021-05-10 02:57:38');
INSERT INTO `balance_libro` VALUES (972,1603,40719,6,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',8993.02,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(973,1603,40719,6,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',471.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(974,1603,40719,6,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',26878.94,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(975,1603,40719,6,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',990.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(976,1603,40719,6,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',6889.72,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(977,1603,40719,6,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1000.01,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(978,1603,40719,6,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4062.87,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(979,1603,40719,6,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1365.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(980,1603,40719,6,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',980.10,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(981,1603,40719,6,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',6518.11,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(982,1603,40719,6,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1679.98,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(983,1603,40719,6,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',686.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(984,1603,40719,6,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',22112.41,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(985,1603,40719,6,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',3878.99,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(986,1603,40719,6,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',5137.54,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(987,1603,40719,6,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',11851.56,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(988,1603,40719,6,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',13268.57,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(989,1603,40719,6,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',328.50,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(990,1603,40719,6,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1100.01,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(991,1603,40719,6,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2484.54,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(992,1603,40719,6,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1999.99,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL);
INSERT INTO `balance_libro` VALUES (993,1603,40719,6,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1365.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(994,1603,40719,6,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1999.20,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(995,1603,40719,6,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',7089.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(996,1603,40719,6,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',93457.67,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(997,1603,40719,6,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',27918.33,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(998,1603,40719,6,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1688.77,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(999,1603,40719,6,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',3508.86,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:59:07','2021-05-10 02:59:07'),(1000,1603,40719,6,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',32992.01,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1001,1603,40719,6,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1829.99,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1002,1603,40719,6,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',4700.44,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1003,1603,40719,6,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',40799.99,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1004,1603,40719,6,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1501.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1005,1603,40719,6,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',3363.47,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1006,1603,40719,6,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1950.01,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1007,1603,40719,6,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',3381.82,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:52:43','2021-05-10 02:52:43'),(1008,1603,40719,6,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',39057.59,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1009,1603,40719,6,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',320.81,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1010,1603,40719,6,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',32399.98,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1011,1603,40719,6,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',3204.90,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1012,1603,40719,6,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',580.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1013,1603,40719,6,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',3747.72,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:53:34','2021-05-10 02:53:34');
INSERT INTO `balance_libro` VALUES (1014,1603,40719,6,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',3261.88,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1015,1603,40719,6,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1582.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1016,1603,40719,6,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1505.00,NULL,NULL,1,'2021-05-10 02:27:08','2021-05-10 02:27:08',NULL),(1017,1603,40719,6,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',620.24,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1018,1603,40719,6,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1376.01,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1019,1603,40719,6,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',279.99,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1020,1603,40719,6,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',9026.78,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1021,1603,40719,6,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',179311.84,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1022,1603,40719,6,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',35431.99,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1023,1603,40719,6,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',42949.85,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-16 04:46:39','2021-05-16 04:46:39'),(1024,1603,40719,6,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',8187.03,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1025,1603,40719,6,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',200.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1026,1603,40719,6,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2520.16,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1027,1603,40719,6,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1360.86,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1028,1603,40719,6,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',600.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1029,1603,40719,6,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',4755.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1030,1603,40719,6,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',363.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1031,1603,40719,6,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',363.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1032,1603,40719,6,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',10621.31,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1033,1603,40719,6,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',12777.60,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1034,1603,40719,6,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',12627.60,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL);
INSERT INTO `balance_libro` VALUES (1035,1603,40719,6,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2000.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1036,1603,40719,6,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',12300.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1037,1603,40719,6,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',9199.42,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1038,1603,40719,6,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3000.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1039,1603,40719,6,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3675.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1040,1603,40719,6,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',8970.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1041,1603,40719,6,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1700.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1042,1603,40719,6,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',16797.95,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1043,1603,40719,6,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3000.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1044,1603,40719,6,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2699.99,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1045,1603,40719,6,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1900.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1046,1603,40719,6,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',960.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1047,1603,40719,6,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',980.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1048,1603,40719,6,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',21090.05,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1049,1603,40719,6,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',13931.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1050,1603,40719,6,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',12495.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1051,1603,40719,6,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',11189.32,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1052,1603,40719,6,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',9741.38,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1053,1603,40719,6,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7500.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1054,1603,40719,6,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1950.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1055,1603,40719,6,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',3000.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL);
INSERT INTO `balance_libro` VALUES (1056,1603,40719,6,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',13080.64,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1057,1603,40719,6,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',16549.13,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1058,1603,40719,6,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',52963.06,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1059,1603,40719,6,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',3800.01,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1060,1603,40719,6,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',7000.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1061,1603,40719,6,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',28091.71,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1062,1603,40719,6,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',63828.59,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1063,1603,40719,6,2,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',19624.74,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1064,1603,40719,6,2,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',8000.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1065,1603,40719,6,2,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',20400.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1066,1603,40719,6,2,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',13567.71,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1067,1603,40719,6,2,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2750.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1068,1603,40719,6,2,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',23355.96,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1069,1603,40719,6,2,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1520.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1070,1603,40719,6,2,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1900.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1071,1603,40719,6,2,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2429.50,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1072,1603,40719,6,2,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3500.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1073,1603,40719,6,2,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',6783.04,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1074,1603,40719,6,2,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',14452.93,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1075,1603,40719,6,2,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',12961.44,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1076,1603,40719,6,2,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',14259.04,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL);
INSERT INTO `balance_libro` VALUES (1077,1603,40719,6,2,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',18716.38,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1078,1603,40719,6,2,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6200.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1079,1603,40719,6,2,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1700.00,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1080,1603,40719,6,2,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',7156.87,NULL,NULL,1,'2021-05-10 02:27:09','2021-05-10 02:27:09',NULL),(1081,1603,40719,6,2,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',21098.89,NULL,NULL,1,'2021-05-10 02:27:10','2021-05-10 02:27:10',NULL),(1082,1603,40719,6,2,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',27321.27,NULL,NULL,1,'2021-05-10 02:27:10','2021-05-10 02:27:10',NULL),(1083,1603,40719,6,2,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',10300.00,NULL,NULL,1,'2021-05-10 02:27:10','2021-05-10 02:27:10',NULL),(1084,1603,40719,6,2,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',7311.44,NULL,NULL,1,'2021-05-10 02:27:10','2021-05-10 02:27:10',NULL),(1085,1603,40719,6,2,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4300.00,NULL,NULL,1,'2021-05-10 02:27:10','2021-05-10 02:27:10',NULL),(1086,1603,40719,6,2,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',14801.85,NULL,NULL,1,'2021-05-10 02:27:10','2021-05-10 02:27:10',NULL),(1087,1603,40719,6,2,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',28083.98,NULL,NULL,1,'2021-05-10 02:27:10','2021-05-10 02:27:10',NULL),(1088,1603,40719,5,16,247,'App\\Models\\PeriodLiquidation',NULL,247,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',15519.96,NULL,NULL,1,'2021-05-10 02:28:57','2021-10-17 11:22:15','2021-10-17 11:22:15'),(1089,1603,40719,5,15,246,'App\\Models\\PeriodLiquidation',NULL,246,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',240228.22,NULL,NULL,1,'2021-05-10 02:34:22','2021-05-10 02:34:22',NULL),(1090,1603,40719,6,7,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2243.41,NULL,NULL,1,'2021-05-10 02:40:30','2021-05-10 02:40:30',NULL),(1091,1603,40719,6,7,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2182.46,NULL,NULL,1,'2021-05-10 02:41:17','2021-05-10 02:41:17',NULL),(1092,1603,40719,6,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',3381.82,NULL,NULL,1,'2021-05-10 02:52:43','2021-05-10 02:52:43',NULL),(1093,1603,40719,6,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',3747.72,NULL,NULL,1,'2021-05-10 02:53:34','2021-05-10 02:53:34',NULL),(1094,1603,40719,6,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-02','2021-04-02',3050.03,NULL,NULL,1,'2021-05-10 02:57:38','2021-05-10 02:57:38',NULL),(1095,1603,40719,6,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',3508.86,NULL,NULL,1,'2021-05-10 02:59:07','2021-05-10 02:59:07',NULL),(1096,1603,40719,6,7,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',217.21,NULL,NULL,1,'2021-05-16 04:04:10','2021-05-16 04:04:10',NULL),(1097,1603,40719,6,16,264,'App\\Models\\PeriodLiquidation',NULL,264,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',9372.60,NULL,NULL,1,'2021-05-16 04:05:21','2021-05-16 04:46:10','2021-05-16 04:46:10');
INSERT INTO `balance_libro` VALUES (1098,1603,40719,6,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',42949.85,NULL,NULL,1,'2021-05-16 04:46:39','2021-05-16 04:46:39',NULL),(1099,1603,40719,6,16,266,'App\\Models\\PeriodLiquidation',NULL,266,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',9372.60,NULL,NULL,1,'2021-05-16 04:47:19','2021-05-16 04:47:19',NULL),(1100,1603,40719,6,15,265,'App\\Models\\PeriodLiquidation',NULL,265,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',138428.30,NULL,NULL,1,'2021-05-16 04:49:21','2021-05-16 04:49:21',NULL),(1101,1603,40719,6,1,1101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-04-30',NULL,68423.85,NULL,NULL,1,'2021-05-23 22:41:04','2021-05-23 22:41:04',NULL),(1124,1603,40719,7,2,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',49000.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1125,1603,40719,7,2,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',7620.22,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1126,1603,40719,7,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',7948.80,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1127,1603,40719,7,2,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',44759.52,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1128,1603,40719,7,2,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',3450.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1129,1603,40719,7,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',17624.78,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1130,1603,40719,7,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3500.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1131,1603,40719,7,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',8000.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1132,1603,40719,7,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3450.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1133,1603,40719,7,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',13795.94,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1134,1603,40719,7,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',4500.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1135,1603,40719,7,2,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',44420.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1136,1603,40719,7,2,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',8921.46,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1137,1603,40719,7,2,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',4300.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1138,1603,40719,7,2,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',8360.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1139,1603,40719,7,2,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',14186.03,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1140,1603,40719,7,2,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',11939.65,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL);
INSERT INTO `balance_libro` VALUES (1141,1603,40719,7,2,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',10702.70,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1142,1603,40719,7,2,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',2800.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1143,1603,40719,7,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',1444.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1144,1603,40719,7,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',15280.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1145,1603,40719,7,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',17400.01,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1146,1603,40719,7,2,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',14635.95,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1147,1603,40719,7,2,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',51322.20,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1148,1603,40719,7,2,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',19054.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1149,1603,40719,7,2,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',10960.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1150,1603,40719,7,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',10960.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1151,1603,40719,7,2,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',970.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1152,1603,40719,7,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',11194.71,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1153,1603,40719,7,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',10960.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1154,1603,40719,7,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',23957.07,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1155,1603,40719,7,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',4199.99,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1156,1603,40719,7,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',5000.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1157,1603,40719,7,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2400.00,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1158,1603,40719,7,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',13964.17,NULL,NULL,1,'2021-06-07 03:47:12','2021-06-07 03:47:12',NULL),(1159,1603,40719,7,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1500.00,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1160,1603,40719,7,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8021.44,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1161,1603,40719,7,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',9644.37,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL);
INSERT INTO `balance_libro` VALUES (1162,1603,40719,7,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',14594.84,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1163,1603,40719,7,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',3300.00,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1164,1603,40719,7,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',25111.64,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1165,1603,40719,7,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',24407.06,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1166,1603,40719,7,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',11780.00,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1167,1603,40719,7,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',46198.01,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1168,1603,40719,7,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',17565.95,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1169,1603,40719,7,2,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',24834.79,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1170,1603,40719,7,2,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4900.00,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1171,1603,40719,7,2,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',15328.58,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1172,1603,40719,7,2,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2000.00,NULL,NULL,1,'2021-06-07 03:47:13','2021-06-07 03:47:13',NULL),(1188,1603,40719,7,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2801.15,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1189,1603,40719,7,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',11068.48,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1190,1603,40719,7,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',1866.15,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1191,1603,40719,7,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',924.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1192,1603,40719,7,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1608.79,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1193,1603,40719,7,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',8051.02,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1194,1603,40719,7,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1365.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1195,1603,40719,7,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',2775.12,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1196,1603,40719,7,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',923.25,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1197,1603,40719,7,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',1000.01,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL);
INSERT INTO `balance_libro` VALUES (1198,1603,40719,7,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-09','2021-05-09',4991.77,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1199,1603,40719,7,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',5137.54,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1200,1603,40719,7,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',12645.81,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1201,1603,40719,7,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',21734.27,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1202,1603,40719,7,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1000.10,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1203,1603,40719,7,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',4390.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1204,1603,40719,7,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',34424.50,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1205,1603,40719,7,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',70199.97,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1206,1603,40719,7,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',1000.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1207,1603,40719,7,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',2860.51,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1208,1603,40719,7,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',2140.10,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1209,1603,40719,7,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',8153.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1210,1603,40719,7,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',860.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1211,1603,40719,7,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',5019.20,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1212,1603,40719,7,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',1608.79,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1213,1603,40719,7,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',1000.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1214,1603,40719,7,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',6105.27,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1215,1603,40719,7,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',1624.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1216,1603,40719,7,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',7756.13,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1217,1603,40719,7,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',40293.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL),(1218,1603,40719,7,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1000.00,NULL,NULL,1,'2021-06-07 03:49:50','2021-06-07 03:49:50',NULL);
INSERT INTO `balance_libro` VALUES (1219,1603,40719,7,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',7756.13,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1220,1603,40719,7,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1536.11,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1221,1603,40719,7,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1700.00,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1222,1603,40719,7,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',5215.82,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1223,1603,40719,7,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',9406.97,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1224,1603,40719,7,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',7406.39,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1225,1603,40719,7,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',5902.17,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1226,1603,40719,7,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',1000.00,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1227,1603,40719,7,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',9579.77,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1228,1603,40719,7,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2498.57,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1229,1603,40719,7,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',6105.27,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1230,1603,40719,7,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',3421.40,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1231,1603,40719,7,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',30200.00,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1232,1603,40719,7,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',3365.73,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1233,1603,40719,7,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',6105.27,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1234,1603,40719,7,3,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',500.01,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1235,1603,40719,7,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',9406.97,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1236,1603,40719,7,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',1749.91,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1237,1603,40719,7,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',1000.00,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1238,1603,40719,7,3,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',3365.73,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1239,1603,40719,7,3,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',77020.33,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL);
INSERT INTO `balance_libro` VALUES (1240,1603,40719,7,3,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',73263.32,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1241,1603,40719,7,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',71427.48,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1242,1603,40719,7,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',34795.82,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1243,1603,40719,7,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',303.15,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1244,1603,40719,7,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',34350.69,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1245,1603,40719,7,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',9579.77,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1246,1603,40719,7,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',808.85,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-11 02:45:39','2021-06-11 02:45:39'),(1247,1603,40719,7,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2200.00,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1248,1603,40719,7,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',34343.59,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1249,1603,40719,7,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',4187.15,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1250,1603,40719,7,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',13650.00,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1251,1603,40719,7,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1276.51,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1252,1603,40719,7,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',4755.00,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1253,1603,40719,7,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',6000.00,NULL,NULL,1,'2021-06-07 03:49:51','2021-06-07 03:49:51',NULL),(1254,1603,40719,7,7,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',2968.46,NULL,NULL,1,'2021-06-11 00:10:22','2021-06-11 00:10:22',NULL),(1255,1603,40719,7,7,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2126.96,NULL,NULL,1,'2021-06-11 00:11:31','2021-06-11 00:11:31',NULL),(1256,1603,40719,7,7,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',24.30,NULL,NULL,1,'2021-06-11 02:33:55','2021-06-11 02:33:55',NULL),(1257,1603,40719,7,7,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',248.76,NULL,NULL,1,'2021-06-11 02:34:53','2021-06-11 02:34:53',NULL),(1258,1603,40719,7,7,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',140.54,NULL,NULL,1,'2021-06-11 02:35:55','2021-06-11 02:35:55',NULL),(1259,1603,40719,7,7,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',145.94,NULL,NULL,1,'2021-06-11 02:38:38','2021-06-11 02:38:38',NULL),(1260,1603,40719,7,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',7531.06,NULL,NULL,1,'2021-06-11 02:41:58','2021-06-11 02:55:08','2021-06-11 02:55:08');
INSERT INTO `balance_libro` VALUES (1261,1603,40719,7,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',662.91,NULL,NULL,1,'2021-06-11 02:45:39','2021-06-11 02:45:39',NULL),(1262,1603,40719,7,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',7531.06,NULL,NULL,1,'2021-06-11 02:55:08','2021-06-11 02:55:08',NULL),(1263,1603,40719,7,16,288,'App\\Models\\PeriodLiquidation',NULL,288,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',11731.64,NULL,NULL,1,'2021-06-14 00:05:57','2021-06-14 00:05:57',NULL),(1264,1603,40719,7,15,287,'App\\Models\\PeriodLiquidation',NULL,287,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',149587.72,NULL,NULL,1,'2021-06-14 01:04:49','2021-06-14 01:04:49',NULL),(1265,1603,40719,7,1,1265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-05-31',NULL,75308.18,NULL,NULL,1,'2021-06-28 03:39:24','2021-06-28 03:39:24',NULL),(1266,1603,40719,8,2,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',15428.36,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1267,1603,40719,8,2,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',749.99,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1268,1603,40719,8,2,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',14716.01,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1269,1603,40719,8,2,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',10500.00,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1270,1603,40719,8,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',19451.39,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1271,1603,40719,8,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',693.00,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1272,1603,40719,8,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1000.00,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1273,1603,40719,8,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',61827.20,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1274,1603,40719,8,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',14995.66,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1275,1603,40719,8,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',12241.00,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1276,1603,40719,8,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',14499.32,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1277,1603,40719,8,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',11545.08,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1278,1603,40719,8,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',9110.01,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1279,1603,40719,8,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',22270.78,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1280,1603,40719,8,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',17173.00,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL),(1281,1603,40719,8,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',51064.15,NULL,NULL,1,'2021-07-04 22:11:53','2021-07-04 22:11:53',NULL);
INSERT INTO `balance_libro` VALUES (1282,1603,40719,8,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',20426.74,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1283,1603,40719,8,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',13010.71,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1284,1603,40719,8,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',13010.71,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1285,1603,40719,8,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',2000.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1286,1603,40719,8,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10863.15,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1287,1603,40719,8,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',22194.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1288,1603,40719,8,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',72450.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1289,1603,40719,8,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',35760.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1290,1603,40719,8,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',26920.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1291,1603,40719,8,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',12112.72,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1292,1603,40719,8,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',2250.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1293,1603,40719,8,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',57352.62,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1294,1603,40719,8,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',15420.46,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1295,1603,40719,8,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',104980.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1296,1603,40719,8,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',16606.35,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1297,1603,40719,8,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',30370.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1298,1603,40719,8,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2500.01,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1299,1603,40719,8,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',11780.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1300,1603,40719,8,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3500.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1301,1603,40719,8,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1295.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1302,1603,40719,8,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',2590.01,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL);
INSERT INTO `balance_libro` VALUES (1303,1603,40719,8,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',5200.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1304,1603,40719,8,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2000.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1305,1603,40719,8,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',12131.64,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1306,1603,40719,8,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',35267.11,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1307,1603,40719,8,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',20257.97,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1308,1603,40719,8,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',55763.50,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1309,1603,40719,8,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',22082.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1310,1603,40719,8,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',36731.37,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1311,1603,40719,8,2,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5340.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1312,1603,40719,8,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',103200.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1313,1603,40719,8,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',50000.01,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1314,1603,40719,8,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',6440.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1315,1603,40719,8,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',19.36,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1316,1603,40719,8,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',2490.51,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1317,1603,40719,8,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1670.10,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1318,1603,40719,8,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',500.51,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1319,1603,40719,8,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1749.91,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1320,1603,40719,8,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',580.03,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1321,1603,40719,8,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',4001.68,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1322,1603,40719,8,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1000.00,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1323,1603,40719,8,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',1820.01,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL);
INSERT INTO `balance_libro` VALUES (1324,1603,40719,8,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',1155.50,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1325,1603,40719,8,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2221.91,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1326,1603,40719,8,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',7961.80,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1327,1603,40719,8,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',1506.81,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1328,1603,40719,8,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',21734.27,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1329,1603,40719,8,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1999.99,NULL,NULL,1,'2021-07-04 22:11:54','2021-07-04 22:11:54',NULL),(1330,1603,40719,8,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1800.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1331,1603,40719,8,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',5699.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1332,1603,40719,8,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',31.46,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1333,1603,40719,8,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1741.72,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1334,1603,40719,8,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',600.01,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1335,1603,40719,8,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',836.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1336,1603,40719,8,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1834.12,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1337,1603,40719,8,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1655.58,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1338,1603,40719,8,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',448.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1339,1603,40719,8,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',520.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1340,1603,40719,8,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',150.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1341,1603,40719,8,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',2699.45,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1342,1603,40719,8,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1603.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1343,1603,40719,8,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',720.52,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1344,1603,40719,8,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',500.01,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL);
INSERT INTO `balance_libro` VALUES (1345,1603,40719,8,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',512.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1346,1603,40719,8,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',166.23,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1347,1603,40719,8,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',11267.21,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1348,1603,40719,8,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',16984.96,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1349,1603,40719,8,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',2523.04,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1350,1603,40719,8,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3861.82,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1351,1603,40719,8,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',574.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1352,1603,40719,8,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',24665.85,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1353,1603,40719,8,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',14186.73,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1354,1603,40719,8,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2609.70,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1355,1603,40719,8,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4945.38,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1356,1603,40719,8,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1423.50,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1357,1603,40719,8,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1022.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1358,1603,40719,8,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2847.02,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1359,1603,40719,8,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',30954.47,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1360,1603,40719,8,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1000.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1361,1603,40719,8,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1413.53,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1362,1603,40719,8,3,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',2836.13,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1363,1603,40719,8,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',6347.21,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-19 04:47:05','2021-07-19 04:47:05'),(1364,1603,40719,8,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',3507.33,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1365,1603,40719,8,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',3390.54,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL);
INSERT INTO `balance_libro` VALUES (1366,1603,40719,8,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1680.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1367,1603,40719,8,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',200.01,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1368,1603,40719,8,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',6034.13,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1369,1603,40719,8,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',42551.93,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1370,1603,40719,8,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',38797.44,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1371,1603,40719,8,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',4849.12,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1372,1603,40719,8,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',1000.02,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1373,1603,40719,8,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',213.76,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1374,1603,40719,8,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3507.33,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1375,1603,40719,8,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',8700.00,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1376,1603,40719,8,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2275.47,NULL,NULL,1,'2021-07-04 22:11:55','2021-07-04 22:11:55',NULL),(1377,1603,40719,8,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',39600.01,NULL,NULL,1,'2021-07-04 22:11:56','2021-07-04 22:11:56',NULL),(1378,1603,40719,8,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',66400.01,NULL,NULL,1,'2021-07-04 22:11:56','2021-07-04 22:11:56',NULL),(1379,1603,40719,8,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',9776.98,NULL,NULL,1,'2021-07-04 22:11:56','2021-07-04 22:11:56',NULL),(1380,1603,40719,8,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',9579.77,NULL,NULL,1,'2021-07-04 22:11:56','2021-07-04 22:11:56',NULL),(1381,1603,40719,8,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1000.29,NULL,NULL,1,'2021-07-04 22:11:56','2021-07-19 04:57:26','2021-07-19 04:57:26'),(1382,1603,40719,8,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',38968.93,NULL,NULL,1,'2021-07-04 22:11:56','2021-07-04 22:11:56',NULL),(1383,1603,40719,8,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1091.31,NULL,NULL,1,'2021-07-04 22:11:56','2021-07-04 22:11:56',NULL),(1384,1603,40719,8,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',4755.00,NULL,NULL,1,'2021-07-04 22:11:56','2021-07-04 22:11:56',NULL),(1385,1603,40719,8,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6347.21,NULL,NULL,1,'2021-07-12 23:42:54','2021-07-19 03:18:48','2021-07-19 03:18:48'),(1386,1603,40719,8,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6347.21,NULL,NULL,1,'2021-07-12 23:43:54','2021-07-19 03:18:16','2021-07-19 03:18:16');
INSERT INTO `balance_libro` VALUES (1387,1603,40719,8,7,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',672.26,NULL,NULL,1,'2021-07-19 00:06:49','2021-07-19 00:06:49',NULL),(1388,1603,40719,8,7,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3325.62,NULL,NULL,1,'2021-07-19 00:07:54','2021-07-19 00:07:54',NULL),(1389,1603,40719,8,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',6347.21,NULL,NULL,1,'2021-07-19 03:18:16','2021-07-19 03:18:16',NULL),(1390,1603,40719,8,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',6347.21,NULL,NULL,1,'2021-07-19 03:18:48','2021-07-19 03:18:48',NULL),(1391,1603,40719,8,7,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',20.00,NULL,NULL,1,'2021-07-19 04:42:37','2021-07-19 04:42:37',NULL),(1392,1603,40719,8,7,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',6.93,NULL,NULL,1,'2021-07-19 04:43:27','2021-07-19 04:43:27',NULL),(1393,1603,40719,8,7,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',33.00,NULL,NULL,1,'2021-07-19 04:44:20','2021-07-19 04:44:20',NULL),(1394,1603,40719,8,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',6244.00,NULL,NULL,1,'2021-07-19 04:47:05','2021-07-19 04:51:47','2021-07-19 04:51:47'),(1395,1603,40719,8,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',6347.21,NULL,NULL,1,'2021-07-19 04:51:47','2021-07-19 04:51:47',NULL),(1396,1603,40719,8,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1000.29,NULL,NULL,1,'2021-07-19 04:57:26','2021-07-19 04:57:26',NULL),(1397,1603,40719,8,16,315,'App\\Models\\PeriodLiquidation',NULL,315,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',13354.43,NULL,NULL,1,'2021-07-19 04:59:13','2021-07-19 04:59:13',NULL),(1398,1603,40719,8,15,314,'App\\Models\\PeriodLiquidation',NULL,314,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',166286.72,NULL,NULL,1,'2021-07-19 05:01:02','2021-07-19 05:01:02',NULL),(1399,1603,40719,9,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',5749.00,NULL,NULL,1,'2021-08-07 00:56:27','2021-08-07 00:56:27',NULL),(1400,1603,40719,9,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1095.00,NULL,NULL,1,'2021-08-07 00:56:27','2021-08-11 21:15:48','2021-08-11 21:15:48'),(1401,1603,40719,9,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',13230.69,NULL,NULL,1,'2021-08-07 00:56:27','2021-08-11 21:16:23','2021-08-11 21:16:23'),(1402,1603,40719,9,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1500.01,NULL,NULL,1,'2021-08-07 00:56:27','2021-08-07 00:56:27',NULL),(1403,1603,40719,9,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',17504.62,NULL,NULL,1,'2021-08-07 00:56:27','2021-08-07 00:56:27',NULL),(1404,1603,40719,9,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',8999.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 01:49:49','2021-08-07 01:49:49'),(1405,1603,40719,9,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1260.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1406,1603,40719,9,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1603.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1407,1603,40719,9,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',217.30,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL);
INSERT INTO `balance_libro` VALUES (1408,1603,40719,9,3,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2577.52,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1409,1603,40719,9,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1000.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1410,1603,40719,9,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',8999.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 01:49:09','2021-08-07 01:49:09'),(1411,1603,40719,9,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',8999.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 01:48:30','2021-08-07 01:48:30'),(1412,1603,40719,9,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',959.91,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1413,1603,40719,9,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1603.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1414,1603,40719,9,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',7260.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1415,1603,40719,9,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',360.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1416,1603,40719,9,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',10615.02,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1417,1603,40719,9,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',21400.01,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1418,1603,40719,9,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',61576.00,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1419,1603,40719,9,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',34400.01,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-07 00:56:28',NULL),(1420,1603,40719,9,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1337.36,NULL,NULL,1,'2021-08-07 00:56:28','2021-08-13 20:33:29','2021-08-13 20:33:29'),(1421,1603,40719,9,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',20932.98,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1422,1603,40719,9,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3311.85,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1423,1603,40719,9,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1800.04,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1424,1603,40719,9,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',24200.00,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1425,1603,40719,9,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',980.00,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1426,1603,40719,9,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',5753.55,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-13 20:24:32','2021-08-13 20:24:32'),(1427,1603,40719,9,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1686.99,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1428,1603,40719,9,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1299.00,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL);
INSERT INTO `balance_libro` VALUES (1429,1603,40719,9,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',650.00,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1430,1603,40719,9,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',7976.70,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1431,1603,40719,9,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',17503.56,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1432,1603,40719,9,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',24200.00,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1433,1603,40719,9,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',16800.28,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1434,1603,40719,9,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3023.27,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1435,1603,40719,9,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1792.46,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1436,1603,40719,9,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1800.01,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1437,1603,40719,9,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',122599.98,NULL,NULL,1,'2021-08-07 00:56:29','2021-08-07 00:56:29',NULL),(1438,1603,40719,9,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1999.99,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1439,1603,40719,9,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',16748.31,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1440,1603,40719,9,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',45085.08,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1441,1603,40719,9,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',7387.11,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1442,1603,40719,9,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',6347.21,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1443,1603,40719,9,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',17683.00,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1444,1603,40719,9,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1890.00,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1445,1603,40719,9,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',3124.97,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1446,1603,40719,9,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',945.00,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1447,1603,40719,9,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2984.74,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1448,1603,40719,9,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',29583.29,NULL,NULL,1,'2021-08-07 00:56:30','2021-08-07 00:56:30',NULL),(1449,1603,40719,9,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1089.00,NULL,NULL,1,'2021-08-07 00:56:31','2021-08-07 00:56:31',NULL);
INSERT INTO `balance_libro` VALUES (1450,1603,40719,9,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1750.00,NULL,NULL,1,'2021-08-07 00:56:31','2021-08-07 00:56:31',NULL),(1451,1603,40719,9,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',88800.01,NULL,NULL,1,'2021-08-07 00:56:31','2021-08-07 00:56:31',NULL),(1452,1603,40719,9,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',65099.98,NULL,NULL,1,'2021-08-07 00:56:31','2021-08-07 00:56:31',NULL),(1453,1603,40719,9,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',35265.41,NULL,NULL,1,'2021-08-07 00:56:31','2021-08-07 00:56:31',NULL),(1454,1603,40719,9,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2280.00,NULL,NULL,1,'2021-08-07 00:56:31','2021-08-07 00:56:31',NULL),(1455,1603,40719,9,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1140.00,NULL,NULL,1,'2021-08-07 00:56:31','2021-08-07 00:56:31',NULL),(1456,1603,40719,9,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',32400.64,NULL,NULL,1,'2021-08-07 00:56:31','2021-08-07 01:45:24','2021-08-07 01:45:24'),(1457,1603,40719,9,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',12256.54,NULL,NULL,1,'2021-08-07 00:56:32','2021-08-07 00:56:32',NULL),(1458,1603,40719,9,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',129.99,NULL,NULL,1,'2021-08-07 00:56:32','2021-08-07 00:56:32',NULL),(1459,1603,40719,9,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1348.90,NULL,NULL,1,'2021-08-07 00:56:32','2021-08-07 00:56:32',NULL),(1460,1603,40719,9,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',10059.57,NULL,NULL,1,'2021-08-07 00:56:32','2021-08-07 00:56:32',NULL),(1461,1603,40719,9,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',90042.09,NULL,NULL,1,'2021-08-07 00:56:32','2021-08-07 00:56:32',NULL),(1462,1603,40719,9,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',33376.64,NULL,NULL,1,'2021-08-07 00:56:32','2021-08-07 00:56:32',NULL),(1463,1603,40719,9,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2000.00,NULL,NULL,1,'2021-08-07 00:56:32','2021-08-15 21:02:03','2021-08-15 21:02:03'),(1464,1603,40719,9,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1073.12,NULL,NULL,1,'2021-08-07 00:56:33','2021-08-07 00:56:33',NULL),(1465,1603,40719,9,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2946.98,NULL,NULL,1,'2021-08-07 00:56:33','2021-08-07 00:56:33',NULL),(1466,1603,40719,9,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1999.99,NULL,NULL,1,'2021-08-07 00:56:33','2021-08-07 00:56:33',NULL),(1467,1603,40719,9,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',581.01,NULL,NULL,1,'2021-08-07 00:56:33','2021-08-07 00:56:33',NULL),(1468,1603,40719,9,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',987.00,NULL,NULL,1,'2021-08-07 00:56:33','2021-08-07 00:56:33',NULL),(1469,1603,40719,9,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',11062.87,NULL,NULL,1,'2021-08-07 00:56:33','2021-08-07 00:56:33',NULL),(1470,1603,40719,9,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',16999.99,NULL,NULL,1,'2021-08-07 00:56:33','2021-08-07 00:56:33',NULL);
INSERT INTO `balance_libro` VALUES (1471,1603,40719,9,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',39999.99,NULL,NULL,1,'2021-08-07 00:56:33','2021-08-07 00:56:33',NULL),(1472,1603,40719,9,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',146.08,NULL,NULL,1,'2021-08-07 00:56:34','2021-08-07 00:56:34',NULL),(1473,1603,40719,9,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',28050.10,NULL,NULL,1,'2021-08-07 00:56:34','2021-08-07 00:56:34',NULL),(1474,1603,40719,9,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',26426.40,NULL,NULL,1,'2021-08-07 00:56:34','2021-08-07 00:56:34',NULL),(1475,1603,40719,9,3,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',6900.00,NULL,NULL,1,'2021-08-07 00:56:34','2021-08-07 00:56:34',NULL),(1476,1603,40719,9,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2438.28,NULL,NULL,1,'2021-08-07 00:56:34','2021-08-07 00:56:34',NULL),(1477,1603,40719,9,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',500.01,NULL,NULL,1,'2021-08-07 00:56:34','2021-08-15 21:05:16','2021-08-15 21:05:16'),(1478,1603,40719,9,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',91819.04,NULL,NULL,1,'2021-08-07 00:56:34','2021-08-07 00:56:34',NULL),(1479,1603,40719,9,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',724.79,NULL,NULL,1,'2021-08-07 00:56:34','2021-08-07 00:56:34',NULL),(1480,1603,40719,9,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4000.49,NULL,NULL,1,'2021-08-07 00:56:34','2021-08-07 00:56:34',NULL),(1481,1603,40719,9,3,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',118799.98,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 00:56:35',NULL),(1482,1603,40719,9,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',11940.15,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 00:56:35',NULL),(1483,1603,40719,9,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',22072.90,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 00:56:35',NULL),(1484,1603,40719,9,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',26669.64,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 00:56:35',NULL),(1485,1603,40719,9,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',634.27,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 00:56:35',NULL),(1486,1603,40719,9,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',9955.08,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 01:15:18','2021-08-07 01:15:18'),(1487,1603,40719,9,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',17741.76,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 01:15:29','2021-08-07 01:15:29'),(1488,1603,40719,9,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',5499.99,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 01:18:32','2021-08-07 01:18:32'),(1489,1603,40719,9,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',20335.71,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 01:18:36','2021-08-07 01:18:36'),(1490,1603,40719,9,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',15415.00,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 01:15:40','2021-08-07 01:15:40');
INSERT INTO `balance_libro` VALUES (1491,1603,40719,9,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',12369.00,NULL,NULL,1,'2021-08-07 00:56:35','2021-08-07 01:15:45','2021-08-07 01:15:45'),(1492,1603,40719,9,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4700.00,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:15:50','2021-08-07 01:15:50'),(1493,1603,40719,9,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4800.01,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:15:55','2021-08-07 01:15:55'),(1494,1603,40719,9,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',16844.31,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:15:59','2021-08-07 01:15:59'),(1495,1603,40719,9,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',53520.32,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:16:05','2021-08-07 01:16:05'),(1496,1603,40719,9,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1350.00,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:16:09','2021-08-07 01:16:09'),(1497,1603,40719,9,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',14103.23,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:16:14','2021-08-07 01:16:14'),(1498,1603,40719,9,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',16631.80,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:18:42','2021-08-07 01:18:42'),(1499,1603,40719,9,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',4800.01,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:18:46','2021-08-07 01:18:46'),(1500,1603,40719,9,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2049.99,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:16:59','2021-08-07 01:16:59'),(1501,1603,40719,9,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',15991.59,NULL,NULL,1,'2021-08-07 00:56:36','2021-08-07 01:16:53','2021-08-07 01:16:53'),(1502,1603,40719,9,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',17253.26,NULL,NULL,1,'2021-08-07 00:56:37','2021-08-07 01:16:49','2021-08-07 01:16:49'),(1503,1603,40719,9,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',22179.80,NULL,NULL,1,'2021-08-07 00:56:37','2021-08-07 01:16:42','2021-08-07 01:16:42'),(1504,1603,40719,9,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',4410.00,NULL,NULL,1,'2021-08-07 00:56:37','2021-08-07 01:16:36','2021-08-07 01:16:36'),(1505,1603,40719,9,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',18212.64,NULL,NULL,1,'2021-08-07 00:56:37','2021-08-07 01:16:32','2021-08-07 01:16:32'),(1506,1603,40719,9,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',23836.79,NULL,NULL,1,'2021-08-07 00:56:37','2021-08-07 01:16:27','2021-08-07 01:16:27'),(1507,1603,40719,9,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2410.01,NULL,NULL,1,'2021-08-07 00:56:37','2021-08-07 01:16:22','2021-08-07 01:16:22'),(1508,1603,40719,9,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5600.00,NULL,NULL,1,'2021-08-07 00:56:37','2021-08-07 01:18:50','2021-08-07 01:18:50'),(1509,1603,40719,9,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',47627.87,NULL,NULL,1,'2021-08-07 00:56:37','2021-08-07 01:18:55','2021-08-07 01:18:55');
INSERT INTO `balance_libro` VALUES (1510,1603,40719,9,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5506.27,NULL,NULL,1,'2021-08-07 00:56:38','2021-08-07 01:17:05','2021-08-07 01:17:05'),(1511,1603,40719,9,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',10803.78,NULL,NULL,1,'2021-08-07 00:56:38','2021-08-07 01:17:10','2021-08-07 01:17:10'),(1512,1603,40719,9,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2500.01,NULL,NULL,1,'2021-08-07 00:56:38','2021-08-07 01:17:14','2021-08-07 01:17:14'),(1513,1603,40719,9,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',50919.99,NULL,NULL,1,'2021-08-07 00:56:38','2021-08-07 01:17:18','2021-08-07 01:17:18'),(1514,1603,40719,9,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',8334.21,NULL,NULL,1,'2021-08-07 00:56:38','2021-08-07 01:17:36','2021-08-07 01:17:36'),(1515,1603,40719,9,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',13462.77,NULL,NULL,1,'2021-08-07 00:56:38','2021-08-07 01:17:32','2021-08-07 01:17:32'),(1516,1603,40719,9,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',83950.01,NULL,NULL,1,'2021-08-07 00:56:38','2021-08-07 01:17:26','2021-08-07 01:17:26'),(1517,1603,40719,9,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',5340.00,NULL,NULL,1,'2021-08-07 00:56:38','2021-08-07 01:17:22','2021-08-07 01:17:22'),(1518,1603,40719,9,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',9955.08,NULL,NULL,1,'2021-08-07 01:20:15','2021-08-07 01:20:15',NULL),(1519,1603,40719,9,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',17741.76,NULL,NULL,1,'2021-08-07 01:20:15','2021-08-07 01:20:15',NULL),(1520,1603,40719,9,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',5499.99,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1521,1603,40719,9,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',20335.71,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1522,1603,40719,9,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',15415.00,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1523,1603,40719,9,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',12369.00,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1524,1603,40719,9,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4700.00,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1525,1603,40719,9,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4800.01,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1526,1603,40719,9,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',16844.31,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1527,1603,40719,9,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',53520.32,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1528,1603,40719,9,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1350.00,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1529,1603,40719,9,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',14103.23,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL);
INSERT INTO `balance_libro` VALUES (1530,1603,40719,9,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',16631.80,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1531,1603,40719,9,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',4800.01,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1532,1603,40719,9,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2049.99,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1533,1603,40719,9,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',15991.59,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1534,1603,40719,9,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',17253.26,NULL,NULL,1,'2021-08-07 01:20:16','2021-08-07 01:20:16',NULL),(1535,1603,40719,9,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',22179.80,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1536,1603,40719,9,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',4410.00,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1537,1603,40719,9,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',18212.64,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1538,1603,40719,9,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',23836.79,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1539,1603,40719,9,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2410.01,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1540,1603,40719,9,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5600.00,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1541,1603,40719,9,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',47627.87,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1542,1603,40719,9,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5506.27,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1543,1603,40719,9,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',10803.78,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1544,1603,40719,9,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2500.01,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1545,1603,40719,9,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',50919.99,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1546,1603,40719,9,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',8334.21,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1547,1603,40719,9,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',13462.77,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1548,1603,40719,9,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',83950.01,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1549,1603,40719,9,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',5340.00,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1550,1603,40719,9,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3500.00,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL);
INSERT INTO `balance_libro` VALUES (1551,1603,40719,9,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',25460.00,NULL,NULL,1,'2021-08-07 01:20:17','2021-08-07 01:20:17',NULL),(1552,1603,40719,9,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',29279.00,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1553,1603,40719,9,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',10171.78,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1554,1603,40719,9,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',2710.00,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1555,1603,40719,9,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',14375.63,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1556,1603,40719,9,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',24500.00,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1557,1603,40719,9,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3500.00,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1558,1603,40719,9,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',2500.01,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1559,1603,40719,9,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',24500.00,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1560,1603,40719,9,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',24724.99,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1561,1603,40719,9,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',2400.00,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1562,1603,40719,9,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',4500.00,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1563,1603,40719,9,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',22231.17,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1564,1603,40719,9,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',15286.80,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1565,1603,40719,9,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',3800.01,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1566,1603,40719,9,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',73370.00,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1567,1603,40719,9,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',2699.99,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1568,1603,40719,9,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',14843.78,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1569,1603,40719,9,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',12016.49,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1570,1603,40719,9,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',12570.00,NULL,NULL,1,'2021-08-07 01:20:18','2021-08-07 01:20:18',NULL),(1571,1603,40719,9,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',15140.00,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL);
INSERT INTO `balance_libro` VALUES (1572,1603,40719,9,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',14992.80,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1573,1603,40719,9,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',5340.00,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1574,1603,40719,9,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2000.00,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1575,1603,40719,9,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1600.01,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1576,1603,40719,9,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',7969.56,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1577,1603,40719,9,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',4250.00,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1578,1603,40719,9,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',3000.00,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1579,1603,40719,9,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',34615.00,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1580,1603,40719,9,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',11843.31,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1581,1603,40719,9,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',16841.28,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1582,1603,40719,9,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',15669.19,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1583,1603,40719,9,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',19945.69,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1584,1603,40719,9,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',23570.82,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1585,1603,40719,9,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',8615.90,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1586,1603,40719,9,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',8592.82,NULL,NULL,1,'2021-08-07 01:20:19','2021-08-07 01:20:19',NULL),(1587,1603,40719,9,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',12370.00,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1588,1603,40719,9,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',13863.22,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1589,1603,40719,9,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',20204.27,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1590,1603,40719,9,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',4300.00,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1591,1603,40719,9,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',800.00,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1592,1603,40719,9,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',8879.59,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL);
INSERT INTO `balance_libro` VALUES (1593,1603,40719,9,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',13863.22,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1594,1603,40719,9,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',4700.00,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1595,1603,40719,9,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',55019.99,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1596,1603,40719,9,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',15091.81,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1597,1603,40719,9,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',2500.01,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1598,1603,40719,9,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',20859.53,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1599,1603,40719,9,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',116654.21,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1600,1603,40719,9,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',16606.33,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1601,1603,40719,9,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',14395.53,NULL,NULL,1,'2021-08-07 01:20:20','2021-08-07 01:20:20',NULL),(1602,1603,40719,9,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',12536.48,NULL,NULL,1,'2021-08-07 01:20:21','2021-08-07 01:20:21',NULL),(1603,1603,40719,9,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',22200.00,NULL,NULL,1,'2021-08-07 01:20:21','2021-08-07 01:20:21',NULL),(1604,1603,40719,9,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',9787.25,NULL,NULL,1,'2021-08-07 01:20:21','2021-08-07 01:20:21',NULL),(1605,1603,40719,9,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',3100.01,NULL,NULL,1,'2021-08-07 01:20:21','2021-08-07 01:20:21',NULL),(1606,1603,40719,9,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',18692.27,NULL,NULL,1,'2021-08-07 01:20:21','2021-08-07 01:20:21',NULL),(1607,1603,40719,9,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',28588.86,NULL,NULL,1,'2021-08-07 01:20:21','2021-08-07 01:20:21',NULL),(1608,1603,40719,9,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',162016.00,NULL,NULL,1,'2021-08-07 01:20:21','2021-08-07 01:20:21',NULL),(1609,1603,40719,9,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',32400.64,NULL,NULL,1,'2021-08-07 01:45:24','2021-08-07 01:45:24',NULL),(1610,1603,40719,9,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',8999.00,NULL,NULL,1,'2021-08-07 01:48:30','2021-08-07 01:48:30',NULL),(1611,1603,40719,9,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',8999.00,NULL,NULL,1,'2021-08-07 01:49:09','2021-08-07 01:49:09',NULL),(1612,1603,40719,9,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',8999.00,NULL,NULL,1,'2021-08-07 01:49:49','2021-08-07 01:49:49',NULL),(1613,1603,40719,9,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',945.00,NULL,NULL,1,'2021-08-11 21:15:48','2021-08-11 21:15:48',NULL);
INSERT INTO `balance_libro` VALUES (1614,1603,40719,9,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',13080.69,NULL,NULL,1,'2021-08-11 21:16:23','2021-08-11 21:16:23',NULL),(1615,1603,40719,9,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',2200.10,NULL,NULL,1,'2021-08-11 21:18:33','2021-08-11 21:26:50','2021-08-11 21:26:50'),(1616,1603,40719,9,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',3048.97,NULL,NULL,1,'2021-08-11 21:20:58','2021-08-11 21:26:31','2021-08-11 21:26:31'),(1617,1603,40719,9,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',2200.00,NULL,NULL,1,'2021-08-11 21:22:21','2021-08-11 21:26:14','2021-08-11 21:26:14'),(1618,1603,40719,9,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',500.01,NULL,NULL,1,'2021-08-11 21:23:28','2021-08-11 21:25:55','2021-08-11 21:25:55'),(1619,1603,40719,9,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',500.01,NULL,NULL,1,'2021-08-11 21:25:55','2021-08-11 21:25:55',NULL),(1620,1603,40719,9,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',2200.00,NULL,NULL,1,'2021-08-11 21:26:14','2021-08-11 21:26:14',NULL),(1621,1603,40719,9,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',3048.97,NULL,NULL,1,'2021-08-11 21:26:31','2021-08-11 21:26:31',NULL),(1622,1603,40719,9,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',2200.10,NULL,NULL,1,'2021-08-11 21:26:50','2021-08-11 21:26:50',NULL),(1623,1603,40719,9,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4755.00,NULL,NULL,1,'2021-08-13 20:24:32','2021-08-13 20:24:32',NULL),(1624,1603,40719,9,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1105.26,NULL,NULL,1,'2021-08-13 20:33:29','2021-08-13 20:33:29',NULL),(1625,1603,40719,9,15,416,'App\\Models\\PeriodLiquidation',NULL,416,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',284991.77,NULL,NULL,1,'2021-08-15 20:28:50','2021-08-15 20:35:05','2021-08-15 20:35:05'),(1626,1603,40719,9,7,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',7280.91,NULL,NULL,1,'2021-08-15 20:36:20','2021-08-15 20:43:53','2021-08-15 20:43:53'),(1627,1603,40719,9,7,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',75.00,NULL,NULL,1,'2021-08-15 20:37:11','2021-08-15 20:44:14','2021-08-15 20:44:14'),(1628,1603,40719,9,7,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3530.94,NULL,NULL,1,'2021-08-15 20:37:45','2021-08-15 20:44:24','2021-08-15 20:44:24'),(1629,1603,40719,9,7,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',307.35,NULL,NULL,1,'2021-08-15 20:39:11','2021-08-15 20:44:57','2021-08-15 20:44:57'),(1630,1603,40719,9,7,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',167.65,NULL,NULL,1,'2021-08-15 20:39:47','2021-08-15 20:44:45','2021-08-15 20:44:45'),(1631,1603,40719,9,7,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',55.00,NULL,NULL,1,'2021-08-15 20:40:21','2021-08-15 20:45:17','2021-08-15 20:45:17'),(1632,1603,40719,9,7,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',626.80,NULL,NULL,1,'2021-08-15 20:41:46','2021-08-15 20:45:26','2021-08-15 20:45:26'),(1633,1603,40719,9,7,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',7280.91,NULL,NULL,1,'2021-08-15 20:43:53','2021-08-15 20:44:02','2021-08-15 20:44:02');
INSERT INTO `balance_libro` VALUES (1634,1603,40719,9,7,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',7280.91,NULL,NULL,1,'2021-08-15 20:44:02','2021-08-15 20:44:02',NULL),(1635,1603,40719,9,7,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',75.00,NULL,NULL,1,'2021-08-15 20:44:14','2021-08-15 20:44:14',NULL),(1636,1603,40719,9,7,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3530.94,NULL,NULL,1,'2021-08-15 20:44:24','2021-08-15 20:44:32','2021-08-15 20:44:32'),(1637,1603,40719,9,7,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3530.94,NULL,NULL,1,'2021-08-15 20:44:32','2021-08-15 20:44:32',NULL),(1638,1603,40719,9,7,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',167.65,NULL,NULL,1,'2021-08-15 20:44:45','2021-08-15 20:44:45',NULL),(1639,1603,40719,9,7,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',307.35,NULL,NULL,1,'2021-08-15 20:44:57','2021-08-15 20:44:57',NULL),(1640,1603,40719,9,7,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',55.00,NULL,NULL,1,'2021-08-15 20:45:17','2021-08-15 20:45:17',NULL),(1641,1603,40719,9,7,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',626.80,NULL,NULL,1,'2021-08-15 20:45:26','2021-08-15 20:45:26',NULL),(1642,1603,40719,9,7,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',25.00,NULL,NULL,1,'2021-08-15 20:46:39','2021-08-15 20:46:39',NULL),(1643,1603,40719,9,7,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',150.91,NULL,NULL,1,'2021-08-15 20:47:29','2021-08-15 20:47:29',NULL),(1644,1603,40719,9,7,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',970.00,NULL,NULL,1,'2021-08-15 20:50:27','2021-08-15 20:50:27',NULL),(1645,1603,40719,9,7,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',996.12,NULL,NULL,1,'2021-08-15 20:51:24','2021-08-15 20:51:24',NULL),(1646,1603,40719,9,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2000.00,NULL,NULL,1,'2021-08-15 21:02:03','2021-08-15 21:03:37','2021-08-15 21:03:37'),(1647,1603,40719,9,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2000.00,NULL,NULL,1,'2021-08-15 21:03:37','2021-08-15 21:03:37',NULL),(1648,1603,40719,9,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',500.01,NULL,NULL,1,'2021-08-15 21:05:16','2021-08-15 21:05:16',NULL),(1649,1603,40719,9,16,463,'App\\Models\\PeriodLiquidation',NULL,463,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',23036.65,NULL,NULL,1,'2021-08-15 21:06:00','2021-08-15 21:06:00',NULL),(1650,1603,40719,9,15,462,'App\\Models\\PeriodLiquidation',NULL,462,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',284991.77,NULL,NULL,1,'2021-08-15 21:06:51','2021-08-15 21:06:51',NULL),(1651,1603,40719,10,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1800.00,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1652,1603,40719,10,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3339.30,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1653,1603,40719,10,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',4402.96,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1654,1603,40719,10,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',10059.57,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL);
INSERT INTO `balance_libro` VALUES (1655,1603,40719,10,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',1771.00,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1656,1603,40719,10,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',10059.57,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1657,1603,40719,10,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',833.00,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1658,1603,40719,10,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',3680.00,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1659,1603,40719,10,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',2588.15,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1660,1603,40719,10,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5347.04,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1661,1603,40719,10,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',14351.08,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1662,1603,40719,10,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',4500.00,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1663,1603,40719,10,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',57199.99,NULL,NULL,1,'2021-09-09 23:21:25','2021-09-09 23:21:25',NULL),(1664,1603,40719,10,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1137.00,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1665,1603,40719,10,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2200.00,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1666,1603,40719,10,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',20508.64,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1667,1603,40719,10,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',24592.04,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1668,1603,40719,10,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',1429.84,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1669,1603,40719,10,3,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',581.01,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1670,1603,40719,10,3,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',987.00,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1671,1603,40719,10,3,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',12143.97,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1672,1603,40719,10,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',2000.01,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1673,1603,40719,10,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',987.00,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1674,1603,40719,10,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',15583.78,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1675,1603,40719,10,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',67199.99,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL);
INSERT INTO `balance_libro` VALUES (1676,1603,40719,10,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',33593.03,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1677,1603,40719,10,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',679.00,NULL,NULL,1,'2021-09-09 23:21:26','2021-09-09 23:21:26',NULL),(1678,1603,40719,10,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',4682.13,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1679,1603,40719,10,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',574.00,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1680,1603,40719,10,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2543.82,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1681,1603,40719,10,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',41599.99,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1682,1603,40719,10,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',45200.01,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1683,1603,40719,10,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',1680.00,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1684,1603,40719,10,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',1500.00,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1685,1603,40719,10,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',29014.15,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1686,1603,40719,10,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',1771.00,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1687,1603,40719,10,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',2055.79,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1688,1603,40719,10,3,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',33359.70,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1689,1603,40719,10,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',32459.50,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1690,1603,40719,10,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',29014.15,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1691,1603,40719,10,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',2573.29,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1692,1603,40719,10,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',2000.00,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1693,1603,40719,10,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',2000.01,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1694,1603,40719,10,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2785.23,NULL,NULL,1,'2021-09-09 23:21:27','2021-09-09 23:21:27',NULL),(1695,1603,40719,10,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2034.64,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1696,1603,40719,10,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',62077.39,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL);
INSERT INTO `balance_libro` VALUES (1697,1603,40719,10,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',786.50,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1698,1603,40719,10,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',786.50,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1699,1603,40719,10,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',17905.60,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1700,1603,40719,10,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',12.10,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1701,1603,40719,10,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',12143.97,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1702,1603,40719,10,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',41599.99,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1703,1603,40719,10,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',42075.15,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1704,1603,40719,10,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',500.00,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1705,1603,40719,10,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',6831.07,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1706,1603,40719,10,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',91200.02,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1707,1603,40719,10,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',1973.99,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1708,1603,40719,10,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',12617.92,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1709,1603,40719,10,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',1000.01,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1710,1603,40719,10,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',2000.01,NULL,NULL,1,'2021-09-09 23:21:28','2021-09-09 23:21:28',NULL),(1711,1603,40719,10,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',244671.99,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1712,1603,40719,10,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',833.00,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1713,1603,40719,10,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',215.65,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1714,1603,40719,10,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',15473.37,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1715,1603,40719,10,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',1340.99,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1716,1603,40719,10,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',13267.87,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1717,1603,40719,10,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',9695.00,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL);
INSERT INTO `balance_libro` VALUES (1718,1603,40719,10,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1748.99,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1719,1603,40719,10,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',2849.99,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1720,1603,40719,10,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4042.23,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1721,1603,40719,10,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1199.99,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1722,1603,40719,10,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',13270.07,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1723,1603,40719,10,3,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',2999.00,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1724,1603,40719,10,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',999.99,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1725,1603,40719,10,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',1800.03,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1726,1603,40719,10,3,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',50470.44,NULL,NULL,1,'2021-09-09 23:21:29','2021-09-09 23:21:29',NULL),(1727,1603,40719,10,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',14196.02,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-09 23:21:30',NULL),(1728,1603,40719,10,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2100.00,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-09 23:21:30',NULL),(1729,1603,40719,10,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',7113.86,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-09 23:21:30',NULL),(1730,1603,40719,10,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1973.99,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-09 23:21:30',NULL),(1731,1603,40719,10,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',987.00,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-09 23:21:30',NULL),(1732,1603,40719,10,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',6181.41,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-09 23:21:30',NULL),(1733,1603,40719,10,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',86799.98,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-09 23:21:30',NULL),(1734,1603,40719,10,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',26962.39,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-09 23:21:30',NULL),(1735,1603,40719,10,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',1232.20,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-12 23:52:27','2021-09-12 23:52:27'),(1736,1603,40719,10,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',5753.55,NULL,NULL,1,'2021-09-09 23:21:30','2021-09-12 23:51:52','2021-09-12 23:51:52'),(1737,1603,40719,10,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',11270.48,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL),(1738,1603,40719,10,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',2000.00,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL);
INSERT INTO `balance_libro` VALUES (1739,1603,40719,10,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',12370.00,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL),(1740,1603,40719,10,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',17115.38,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL),(1741,1603,40719,10,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',1600.00,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL),(1742,1603,40719,10,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',4400.00,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL),(1743,1603,40719,10,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',12370.00,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL),(1744,1603,40719,10,2,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',38489.00,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL),(1745,1603,40719,10,2,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',11617.46,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL),(1746,1603,40719,10,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',21059.57,NULL,NULL,1,'2021-09-09 23:21:31','2021-09-09 23:21:31',NULL),(1747,1603,40719,10,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',3500.00,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1748,1603,40719,10,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',3200.00,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1749,1603,40719,10,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',38500.00,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1750,1603,40719,10,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',34117.00,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1751,1603,40719,10,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',13649.10,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1752,1603,40719,10,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',56480.00,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1753,1603,40719,10,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',6750.00,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1754,1603,40719,10,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',38556.00,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1755,1603,40719,10,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',38259.00,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1756,1603,40719,10,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',2100.00,NULL,NULL,1,'2021-09-09 23:21:32','2021-09-09 23:21:32',NULL),(1757,1603,40719,10,2,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',23300.00,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL),(1758,1603,40719,10,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',4500.00,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL),(1759,1603,40719,10,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',17863.25,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL);
INSERT INTO `balance_libro` VALUES (1760,1603,40719,10,2,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',9753.79,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL),(1761,1603,40719,10,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',3500.00,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL),(1762,1603,40719,10,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',9660.00,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL),(1763,1603,40719,10,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2000.00,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL),(1764,1603,40719,10,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2800.00,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL),(1765,1603,40719,10,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',970.00,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL),(1766,1603,40719,10,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',4500.00,NULL,NULL,1,'2021-09-09 23:21:33','2021-09-09 23:21:33',NULL),(1767,1603,40719,10,2,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',4399.98,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1768,1603,40719,10,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',60599.99,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1769,1603,40719,10,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2800.00,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1770,1603,40719,10,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2400.00,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1771,1603,40719,10,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',12390.24,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1772,1603,40719,10,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',68644.80,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1773,1603,40719,10,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2000.00,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1774,1603,40719,10,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',36524.93,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1775,1603,40719,10,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',1600.00,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1776,1603,40719,10,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',45441.63,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1777,1603,40719,10,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',14495.59,NULL,NULL,1,'2021-09-09 23:21:34','2021-09-09 23:21:34',NULL),(1778,1603,40719,10,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',17365.81,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1779,1603,40719,10,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',20083.79,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1780,1603,40719,10,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',15305.86,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL);
INSERT INTO `balance_libro` VALUES (1781,1603,40719,10,2,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',7000.00,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1782,1603,40719,10,2,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',14503.79,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1783,1603,40719,10,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1000.00,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1784,1603,40719,10,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1280.00,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1785,1603,40719,10,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',3500.00,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1786,1603,40719,10,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',29132.88,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1787,1603,40719,10,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',15221.96,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1788,1603,40719,10,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',14296.72,NULL,NULL,1,'2021-09-09 23:21:35','2021-09-09 23:21:35',NULL),(1789,1603,40719,10,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',10613.08,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1790,1603,40719,10,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',105800.00,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1791,1603,40719,10,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',11387.23,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1792,1603,40719,10,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',3500.00,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1793,1603,40719,10,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',189508.00,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1794,1603,40719,10,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',2946.25,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1795,1603,40719,10,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',4900.00,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1796,1603,40719,10,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',2000.00,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1797,1603,40719,10,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',9599.99,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1798,1603,40719,10,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',19965.00,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1799,1603,40719,10,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',11312.60,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1800,1603,40719,10,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',25480.00,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL),(1801,1603,40719,10,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1190.00,NULL,NULL,1,'2021-09-09 23:21:36','2021-09-09 23:21:36',NULL);
INSERT INTO `balance_libro` VALUES (1802,1603,40719,10,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',43337.23,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1803,1603,40719,10,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',14191.36,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1804,1603,40719,10,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',12426.00,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1805,1603,40719,10,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',4431.29,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1806,1603,40719,10,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4199.99,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1807,1603,40719,10,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',3500.00,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1808,1603,40719,10,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',15761.54,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1809,1603,40719,10,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3500.00,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1810,1603,40719,10,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',22405.61,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1811,1603,40719,10,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',58639.99,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1812,1603,40719,10,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',10129.58,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1813,1603,40719,10,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',15328.95,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1814,1603,40719,10,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2500.01,NULL,NULL,1,'2021-09-09 23:21:37','2021-09-09 23:21:37',NULL),(1815,1603,40719,10,2,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1410.00,NULL,NULL,1,'2021-09-09 23:21:38','2021-09-09 23:21:38',NULL),(1816,1603,40719,10,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',14575.59,NULL,NULL,1,'2021-09-09 23:21:38','2021-09-09 23:21:38',NULL),(1817,1603,40719,10,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',4755.00,NULL,NULL,1,'2021-09-12 23:51:52','2021-09-12 23:51:52',NULL),(1818,1603,40719,10,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',1018.35,NULL,NULL,1,'2021-09-12 23:52:27','2021-09-12 23:52:27',NULL),(1819,1603,40719,10,15,470,'App\\Models\\PeriodLiquidation',NULL,470,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',261845.92,NULL,NULL,1,'2021-09-13 00:06:54','2021-09-13 00:15:27','2021-09-13 00:15:27'),(1820,1603,40719,10,16,469,'App\\Models\\PeriodLiquidation',NULL,469,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2470.98,NULL,NULL,1,'2021-09-13 00:07:50','2021-09-13 00:17:29','2021-09-13 00:17:29'),(1821,1603,40719,10,7,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',7073.86,NULL,NULL,1,'2021-09-13 00:18:47','2021-09-13 00:18:47',NULL),(1822,1603,40719,10,7,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1903.46,NULL,NULL,1,'2021-09-13 00:20:08','2021-09-13 00:20:08',NULL);
INSERT INTO `balance_libro` VALUES (1823,1603,40719,10,7,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2443.49,NULL,NULL,1,'2021-09-13 00:21:02','2021-09-13 00:21:02',NULL),(1824,1603,40719,10,16,476,'App\\Models\\PeriodLiquidation',NULL,476,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',22296.29,NULL,NULL,1,'2021-09-13 00:22:31','2021-09-13 00:22:31',NULL),(1825,1603,40719,10,15,475,'App\\Models\\PeriodLiquidation',NULL,475,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',261845.92,NULL,NULL,1,'2021-09-13 00:23:43','2021-09-13 00:23:43',NULL),(2068,1603,40719,11,2,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',22503.20,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2069,1603,40719,11,2,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',75920.00,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2070,1603,40719,11,2,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',23933.59,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2071,1603,40719,11,2,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',2400.00,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2072,1603,40719,11,2,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',14153.78,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2073,1603,40719,11,2,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',20040.00,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2074,1603,40719,11,2,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',500.00,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2075,1603,40719,11,2,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',14153.78,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2076,1603,40719,11,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',25229.69,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2077,1603,40719,11,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',3000.00,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2078,1603,40719,11,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',12453.78,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2079,1603,40719,11,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',2100.00,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2080,1603,40719,11,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',2000.00,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2081,1603,40719,11,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',4600.00,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2082,1603,40719,11,2,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1250.00,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2083,1603,40719,11,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',45866.04,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2084,1603,40719,11,2,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',16387.47,NULL,NULL,1,'2021-10-08 23:53:13','2021-10-08 23:53:13',NULL),(2085,1603,40719,11,2,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',7553.26,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL);
INSERT INTO `balance_libro` VALUES (2086,1603,40719,11,2,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3500.00,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2087,1603,40719,11,2,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',91503.36,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2088,1603,40719,11,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1650.00,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2089,1603,40719,11,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',29734.75,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2090,1603,40719,11,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',700.00,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2091,1603,40719,11,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',45215.82,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2092,1603,40719,11,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',3869.50,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2093,1603,40719,11,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',22127.46,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2094,1603,40719,11,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',610.00,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2095,1603,40719,11,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',13147.91,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2096,1603,40719,11,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',14920.89,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2097,1603,40719,11,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',15808.54,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2098,1603,40719,11,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',16548.11,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2099,1603,40719,11,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',69579.28,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2100,1603,40719,11,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',11685.87,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2101,1603,40719,11,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',13691.28,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2102,1603,40719,11,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',4500.00,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2103,1603,40719,11,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',10346.26,NULL,NULL,1,'2021-10-08 23:53:14','2021-10-08 23:53:14',NULL),(2104,1603,40719,11,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',10053.78,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2105,1603,40719,11,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',40000.00,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2106,1603,40719,11,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',20589.64,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL);
INSERT INTO `balance_libro` VALUES (2107,1603,40719,11,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',13739.21,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2108,1603,40719,11,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',27013.26,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2109,1603,40719,11,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',4405.62,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2110,1603,40719,11,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',17508.89,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2111,1603,40719,11,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',4405.62,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2112,1603,40719,11,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',4405.62,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2113,1603,40719,11,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',13219.87,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2114,1603,40719,11,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1460.00,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2115,1603,40719,11,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',9428.50,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2116,1603,40719,11,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',39648.34,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2117,1603,40719,11,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',8416.13,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2118,1603,40719,11,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',39260.71,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2119,1603,40719,11,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',1230.00,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2120,1603,40719,11,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',2530.00,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2121,1603,40719,11,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',5380.00,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2122,1603,40719,11,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',3500.00,NULL,NULL,1,'2021-10-08 23:53:15','2021-10-08 23:53:15',NULL),(2123,1603,40719,11,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',10453.78,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2124,1603,40719,11,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1800.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2125,1603,40719,11,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',13686.39,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2126,1603,40719,11,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1231.70,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2127,1603,40719,11,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',2530.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL);
INSERT INTO `balance_libro` VALUES (2128,1603,40719,11,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',14693.20,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2129,1603,40719,11,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',61804.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2130,1603,40719,11,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',5000.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2131,1603,40719,11,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',59469.48,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2132,1603,40719,11,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4750.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2133,1603,40719,11,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',16548.11,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2134,1603,40719,11,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',20482.60,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2135,1603,40719,11,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',36019.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2136,1603,40719,11,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',13977.38,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2137,1603,40719,11,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',138000.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2138,1603,40719,11,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',18692.10,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2139,1603,40719,11,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',110.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2140,1603,40719,11,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',3500.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2141,1603,40719,11,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',46505.60,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2142,1603,40719,11,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',5000.00,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2143,1603,40719,11,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',27499.98,NULL,NULL,1,'2021-10-08 23:53:16','2021-10-08 23:53:16',NULL),(2144,1603,40719,11,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',16218.53,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2145,1603,40719,11,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',5200.00,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2146,1603,40719,11,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',51812.87,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2147,1603,40719,11,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',74746.93,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2148,1603,40719,11,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',3593.70,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL);
INSERT INTO `balance_libro` VALUES (2149,1603,40719,11,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',155750.38,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2150,1603,40719,11,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',22649.99,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2151,1603,40719,11,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',22649.99,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2152,1603,40719,11,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',9799.98,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2153,1603,40719,11,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',5949.99,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2154,1603,40719,11,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',16699.98,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2155,1603,40719,11,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',16699.98,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2156,1603,40719,11,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',10499.99,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2157,1603,40719,11,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',6199.99,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2158,1603,40719,11,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',18082.70,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2159,1603,40719,11,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',4809.58,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2160,1603,40719,11,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',2530.00,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2161,1603,40719,11,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',16799.99,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2162,1603,40719,11,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',6196.30,NULL,NULL,1,'2021-10-08 23:53:17','2021-10-08 23:53:17',NULL),(2163,1603,40719,11,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',25000.00,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2164,1603,40719,11,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',3800.01,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2165,1603,40719,11,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',2250.01,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2166,1603,40719,11,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',26624.51,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2167,1603,40719,11,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',30780.00,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2168,1603,40719,11,3,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1771.00,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2169,1603,40719,11,3,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',9077.03,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL);
INSERT INTO `balance_libro` VALUES (2170,1603,40719,11,3,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',18054.00,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2171,1603,40719,11,3,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',2000.01,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2172,1603,40719,11,3,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',22007.00,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2173,1603,40719,11,3,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',3600.56,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2174,1603,40719,11,3,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',2000.01,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2175,1603,40719,11,3,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',15255.04,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2176,1603,40719,11,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',47.36,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2177,1603,40719,11,3,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',20002.24,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2178,1603,40719,11,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',4699.94,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2179,1603,40719,11,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',2541.42,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2180,1603,40719,11,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',105080.03,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2181,1603,40719,11,3,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1800.04,NULL,NULL,1,'2021-10-08 23:53:18','2021-10-08 23:53:18',NULL),(2182,1603,40719,11,3,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5245.59,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2183,1603,40719,11,3,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',20067.69,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2184,1603,40719,11,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',11963.00,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2185,1603,40719,11,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',152859.99,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2186,1603,40719,11,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',4450.98,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2187,1603,40719,11,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',999.99,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2188,1603,40719,11,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',19997.82,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2189,1603,40719,11,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',18287.44,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2190,1603,40719,11,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',27112.96,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL);
INSERT INTO `balance_libro` VALUES (2191,1603,40719,11,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',19528.21,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2192,1603,40719,11,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',1071.00,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2193,1603,40719,11,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',6247.30,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2194,1603,40719,11,3,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',552.99,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2195,1603,40719,11,3,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',9479.99,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2196,1603,40719,11,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',3900.86,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2197,1603,40719,11,3,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',14044.71,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2198,1603,40719,11,3,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1800.00,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2199,1603,40719,11,3,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',1973.99,NULL,NULL,1,'2021-10-08 23:53:19','2021-10-08 23:53:19',NULL),(2200,1603,40719,11,3,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',11036.45,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2201,1603,40719,11,3,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',6332.98,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2202,1603,40719,11,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',43337.21,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2203,1603,40719,11,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',107820.00,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2204,1603,40719,11,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',14088.04,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2205,1603,40719,11,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',1000.02,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2206,1603,40719,11,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',14088.04,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2207,1603,40719,11,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',16740.00,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2208,1603,40719,11,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',32301.91,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:58:40','2021-10-08 23:58:40'),(2209,1603,40719,11,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1000.02,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2210,1603,40719,11,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',222199.98,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2211,1603,40719,11,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',7357.64,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL);
INSERT INTO `balance_libro` VALUES (2212,1603,40719,11,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',45063.74,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2213,1603,40719,11,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',2275.01,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2214,1603,40719,11,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',5049.14,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2215,1603,40719,11,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',44039.08,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2216,1603,40719,11,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',12148.28,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2217,1603,40719,11,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',33256.85,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2218,1603,40719,11,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',1719.17,NULL,NULL,1,'2021-10-08 23:53:20','2021-10-08 23:53:20',NULL),(2219,1603,40719,11,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',999.99,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2220,1603,40719,11,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',6908.33,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2221,1603,40719,11,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',1771.00,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2222,1603,40719,11,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',11202.89,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2223,1603,40719,11,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',1919.53,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2224,1603,40719,11,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',2880.82,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2225,1603,40719,11,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',602.00,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2226,1603,40719,11,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1800.00,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2227,1603,40719,11,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1759.99,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2228,1603,40719,11,3,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',127.97,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2229,1603,40719,11,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',1.13,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2230,1603,40719,11,3,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',12.26,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2231,1603,40719,11,3,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',6052.21,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2232,1603,40719,11,3,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',24102.84,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL);
INSERT INTO `balance_libro` VALUES (2233,1603,40719,11,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',13758.06,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2234,1603,40719,11,3,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',6798.46,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2235,1603,40719,11,3,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',23502.10,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2236,1603,40719,11,3,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',52335.99,NULL,NULL,1,'2021-10-08 23:53:21','2021-10-08 23:53:21',NULL),(2237,1603,40719,11,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',42075.15,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2238,1603,40719,11,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',861.00,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2239,1603,40719,11,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',4828.51,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2240,1603,40719,11,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1800.00,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2241,1603,40719,11,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1500.01,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2242,1603,40719,11,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',122.36,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2243,1603,40719,11,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',264060.02,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2244,1603,40719,11,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',5151.77,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2245,1603,40719,11,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',10925.64,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2246,1603,40719,11,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',43080.84,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2247,1603,40719,11,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',72880.00,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:56:49','2021-10-08 23:56:49'),(2248,1603,40719,11,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',2895.68,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2249,1603,40719,11,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',2997.62,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2250,1603,40719,11,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',51764.10,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-11 13:07:18','2021-10-11 13:07:18'),(2251,1603,40719,11,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10461.66,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2252,1603,40719,11,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2459.61,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL),(2253,1603,40719,11,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2895.68,NULL,NULL,1,'2021-10-08 23:53:22','2021-10-08 23:53:22',NULL);
INSERT INTO `balance_libro` VALUES (2254,1603,40719,11,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',6888.87,NULL,NULL,1,'2021-10-08 23:53:23','2021-10-08 23:53:23',NULL),(2255,1603,40719,11,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1690.58,NULL,NULL,1,'2021-10-08 23:53:23','2021-10-08 23:53:23',NULL),(2256,1603,40719,11,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',50202.00,NULL,NULL,1,'2021-10-08 23:53:23','2021-10-08 23:53:23',NULL),(2257,1603,40719,11,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',0.00,NULL,NULL,1,'2021-10-08 23:53:23','2021-10-08 23:55:08','2021-10-08 23:55:08'),(2258,1603,40719,11,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',4755.00,NULL,NULL,1,'2021-10-08 23:53:23','2021-10-08 23:53:23',NULL),(2259,1603,40719,11,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',847.00,NULL,NULL,1,'2021-10-08 23:53:23','2021-10-08 23:53:23',NULL),(2260,1603,40719,11,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',930.57,NULL,NULL,1,'2021-10-08 23:55:08','2021-10-08 23:55:08',NULL),(2261,1603,40719,11,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',72880.00,NULL,NULL,1,'2021-10-08 23:56:49','2021-10-08 23:56:49',NULL),(2262,1603,40719,11,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',32301.91,NULL,NULL,1,'2021-10-08 23:58:40','2021-10-08 23:58:40',NULL),(2263,1603,40719,11,7,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2014.79,NULL,NULL,1,'2021-10-11 12:34:20','2021-10-11 12:34:20',NULL),(2264,1603,40719,11,7,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',4524.94,NULL,NULL,1,'2021-10-11 12:37:10','2021-10-11 12:37:10',NULL),(2265,1603,40719,11,7,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',6890.53,NULL,NULL,1,'2021-10-11 12:38:29','2021-10-11 12:58:42','2021-10-11 12:58:42'),(2266,1603,40719,11,7,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3505.61,NULL,NULL,1,'2021-10-11 12:58:42','2021-10-11 12:58:42',NULL),(2267,1603,40719,11,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',51804.10,NULL,NULL,1,'2021-10-11 13:07:18','2021-10-11 13:08:14','2021-10-11 13:08:14'),(2268,1603,40719,11,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',51764.10,NULL,NULL,1,'2021-10-11 13:08:14','2021-10-11 13:08:14',NULL),(2269,1603,40719,11,16,496,'App\\Models\\PeriodLiquidation',NULL,496,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',28370.21,NULL,NULL,1,'2021-10-17 11:22:15','2021-10-17 11:22:15',NULL),(2270,1603,40719,11,15,495,'App\\Models\\PeriodLiquidation',NULL,495,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',341632.22,NULL,NULL,1,'2021-10-17 11:22:41','2021-10-17 11:22:41',NULL),(2271,1603,40719,12,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',679.00,NULL,NULL,1,'2021-11-07 13:09:55','2021-11-07 13:09:55',NULL),(2272,1603,40719,12,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',5917.16,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2273,1603,40719,12,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',2000.01,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2274,1603,40719,12,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',212.23,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL);
INSERT INTO `balance_libro` VALUES (2275,1603,40719,12,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',2373.00,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2276,1603,40719,12,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',4094.26,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2277,1603,40719,12,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',2320.93,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2278,1603,40719,12,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',6559.00,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2279,1603,40719,12,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',15703.82,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2280,1603,40719,12,3,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',3542.01,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2281,1603,40719,12,3,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',48550.04,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2282,1603,40719,12,3,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',6559.00,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2283,1603,40719,12,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',6559.00,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2284,1603,40719,12,3,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1000.01,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2285,1603,40719,12,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',987.00,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2286,1603,40719,12,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',31038.69,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2287,1603,40719,12,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',1314.02,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2288,1603,40719,12,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',3644.04,NULL,NULL,1,'2021-11-07 13:09:56','2021-11-07 13:09:56',NULL),(2289,1603,40719,12,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',8834.00,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2290,1603,40719,12,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1973.99,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2291,1603,40719,12,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',2480.00,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2292,1603,40719,12,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1760.01,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2293,1603,40719,12,3,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',50004.46,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2294,1603,40719,12,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1900.20,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2295,1603,40719,12,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',1000.02,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL);
INSERT INTO `balance_libro` VALUES (2296,1603,40719,12,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',20999.01,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2297,1603,40719,12,3,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',5961.35,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2298,1603,40719,12,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',11396.02,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2299,1603,40719,12,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',19609.47,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2300,1603,40719,12,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',2041.16,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2301,1603,40719,12,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',176.48,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2302,1603,40719,12,3,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',43704.64,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2303,1603,40719,12,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',5277.49,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2304,1603,40719,12,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',320.53,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2305,1603,40719,12,3,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',1800.00,NULL,NULL,1,'2021-11-07 13:09:57','2021-11-07 13:09:57',NULL),(2306,1603,40719,12,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2459.61,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2307,1603,40719,12,3,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2000.01,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2308,1603,40719,12,3,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',3486.00,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2309,1603,40719,12,3,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',46671.89,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2310,1603,40719,12,3,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',17369.43,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2311,1603,40719,12,3,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',6832.33,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2312,1603,40719,12,3,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',8962.79,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2313,1603,40719,12,3,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',38267.46,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2314,1603,40719,12,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',20271.08,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2315,1603,40719,12,3,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',5296.47,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2316,1603,40719,12,3,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',13250.47,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL);
INSERT INTO `balance_libro` VALUES (2317,1603,40719,12,3,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',137899.99,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2318,1603,40719,12,3,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',5860.01,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2319,1603,40719,12,3,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',816.41,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2320,1603,40719,12,3,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',11520.23,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2321,1603,40719,12,3,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',7000.00,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2322,1603,40719,12,3,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1800.00,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2323,1603,40719,12,3,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',7177.70,NULL,NULL,1,'2021-11-07 13:09:58','2021-11-07 13:09:58',NULL),(2324,1603,40719,12,3,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',12784.07,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2325,1603,40719,12,3,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',1771.00,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2326,1603,40719,12,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4868.79,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2327,1603,40719,12,3,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',1000.69,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2328,1603,40719,12,3,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',86384.62,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2329,1603,40719,12,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',9055.65,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2330,1603,40719,12,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',12665.95,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2331,1603,40719,12,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',999.99,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2332,1603,40719,12,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',1800.00,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2333,1603,40719,12,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',7704.01,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2334,1603,40719,12,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',1771.00,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2335,1603,40719,12,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',64600.00,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2336,1603,40719,12,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',46462.79,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2337,1603,40719,12,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',600.00,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL);
INSERT INTO `balance_libro` VALUES (2338,1603,40719,12,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',32187.16,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2339,1603,40719,12,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1920.98,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2340,1603,40719,12,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',999.99,NULL,NULL,1,'2021-11-07 13:09:59','2021-11-07 13:09:59',NULL),(2341,1603,40719,12,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',841.92,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2342,1603,40719,12,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',4755.00,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2343,1603,40719,12,2,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',1250.00,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2344,1603,40719,12,2,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',12012.00,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2345,1603,40719,12,2,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',22064.35,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2346,1603,40719,12,2,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',6700.00,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2347,1603,40719,12,2,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',10303.78,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2348,1603,40719,12,2,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',57813.04,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2349,1603,40719,12,2,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',3500.00,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2350,1603,40719,12,2,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',5142.88,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2351,1603,40719,12,2,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',13179.26,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2352,1603,40719,12,2,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',1610.00,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2353,1603,40719,12,2,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',350.00,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2354,1603,40719,12,2,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',33884.43,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2355,1603,40719,12,2,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',16207.47,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2356,1603,40719,12,2,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',17639.20,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2357,1603,40719,12,2,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',13552.80,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2358,1603,40719,12,2,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',9512.81,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL);
INSERT INTO `balance_libro` VALUES (2359,1603,40719,12,2,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',7956.81,NULL,NULL,1,'2021-11-07 13:10:00','2021-11-07 13:10:00',NULL),(2360,1603,40719,12,2,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',3500.00,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2361,1603,40719,12,2,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',11862.40,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2362,1603,40719,12,2,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',12408.97,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2363,1603,40719,12,2,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',7722.81,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2364,1603,40719,12,2,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',6565.34,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2365,1603,40719,12,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',1410.00,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2366,1603,40719,12,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',1410.00,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2367,1603,40719,12,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',13249.75,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2368,1603,40719,12,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',36929.13,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2369,1603,40719,12,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',3500.00,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2370,1603,40719,12,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1350.00,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2371,1603,40719,12,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',2820.00,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2372,1603,40719,12,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',9712.37,NULL,NULL,1,'2021-11-07 13:10:01','2021-11-07 13:10:01',NULL),(2373,1603,40719,12,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',18230.74,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2374,1603,40719,12,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',17456.54,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2375,1603,40719,12,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',21344.73,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2376,1603,40719,12,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',14043.16,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2377,1603,40719,12,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',16231.63,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2378,1603,40719,12,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',2000.00,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2379,1603,40719,12,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',5000.00,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL);
INSERT INTO `balance_libro` VALUES (2380,1603,40719,12,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',14230.11,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2381,1603,40719,12,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',18286.74,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2382,1603,40719,12,2,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4199.99,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2383,1603,40719,12,2,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',5273.81,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2384,1603,40719,12,2,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',13278.16,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2385,1603,40719,12,2,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4491.50,NULL,NULL,1,'2021-11-07 13:10:02','2021-11-07 13:10:02',NULL),(2386,1603,40719,12,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',24695.66,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2387,1603,40719,12,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',12323.14,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2388,1603,40719,12,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',1286.81,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2389,1603,40719,12,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',3735.00,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2390,1603,40719,12,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',16992.30,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2391,1603,40719,12,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',31518.84,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2392,1603,40719,12,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',3050.00,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2393,1603,40719,12,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',1800.00,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2394,1603,40719,12,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',10500.00,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2395,1603,40719,12,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',14946.13,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2396,1603,40719,12,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',4500.00,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2397,1603,40719,12,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',11159.10,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2398,1603,40719,12,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',2500.01,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2399,1603,40719,12,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',18136.28,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL),(2400,1603,40719,12,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',2670.00,NULL,NULL,1,'2021-11-07 13:10:03','2021-11-07 13:10:03',NULL);
INSERT INTO `balance_libro` VALUES (2401,1603,40719,12,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',17202.93,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2402,1603,40719,12,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',3500.00,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2403,1603,40719,12,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',2500.01,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2404,1603,40719,12,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',6148.00,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2405,1603,40719,12,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',14479.47,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2406,1603,40719,12,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',5200.00,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2407,1603,40719,12,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',15283.50,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2408,1603,40719,12,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',2800.00,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2409,1603,40719,12,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',4000.01,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2410,1603,40719,12,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',5200.00,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2411,1603,40719,12,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',15434.66,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2412,1603,40719,12,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',10004.96,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2413,1603,40719,12,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',18848.71,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2414,1603,40719,12,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',2530.00,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2415,1603,40719,12,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',5000.00,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2416,1603,40719,12,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',14420.73,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2417,1603,40719,12,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',3000.00,NULL,NULL,1,'2021-11-07 13:10:04','2021-11-07 13:10:04',NULL),(2418,1603,40719,12,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',5000.00,NULL,NULL,1,'2021-11-07 13:10:05','2021-11-07 13:10:05',NULL),(2419,1603,40719,12,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',60079.19,NULL,NULL,1,'2021-11-07 13:10:05','2021-11-07 13:10:05',NULL),(2420,1603,40719,12,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',10652.16,NULL,NULL,1,'2021-11-07 13:10:05','2021-11-07 13:10:05',NULL),(2421,1603,40719,12,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',24420.00,NULL,NULL,1,'2021-11-07 13:10:05','2021-11-07 13:10:05',NULL);
INSERT INTO `balance_libro` VALUES (2422,1603,40719,12,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',10652.16,NULL,NULL,1,'2021-11-07 13:10:05','2021-11-07 13:10:05',NULL),(2423,1603,40719,12,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',10958.37,NULL,NULL,1,'2021-11-07 13:10:05','2021-11-07 13:10:05',NULL),(2424,1603,40719,12,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',17226.48,NULL,NULL,1,'2021-11-07 13:10:05','2021-11-07 13:10:05',NULL),(2425,1603,40719,12,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',2300.00,NULL,NULL,1,'2021-11-07 13:10:05','2021-11-07 13:10:05',NULL),(2426,1603,40719,12,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',25370.00,NULL,NULL,1,'2021-11-07 13:10:05','2021-11-07 13:10:05',NULL),(2427,1603,40719,12,16,498,'App\\Models\\PeriodLiquidation',NULL,498,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',13392.45,NULL,NULL,1,'2021-11-07 18:00:03','2021-11-07 18:00:47','2021-11-07 18:00:47'),(2428,1603,40719,12,7,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',9269.56,NULL,NULL,1,'2021-11-07 18:03:25','2021-11-07 18:03:25',NULL),(2429,1603,40719,12,7,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1188.72,NULL,NULL,1,'2021-11-07 18:04:39','2021-11-07 18:04:39',NULL),(2430,1603,40719,12,7,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2330.93,NULL,NULL,1,'2021-11-07 18:06:01','2021-11-07 18:06:01',NULL),(2431,1603,40719,12,16,504,'App\\Models\\PeriodLiquidation',NULL,504,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',17167.34,NULL,NULL,1,'2021-11-07 18:07:11','2021-11-07 18:07:11',NULL),(2432,1603,40719,12,15,503,'App\\Models\\PeriodLiquidation',NULL,503,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',174625.21,NULL,NULL,1,'2021-11-07 18:08:51','2021-11-07 18:08:51',NULL),(2785,1603,40719,13,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',11428.50,NULL,NULL,1,'2021-12-12 19:46:21','2021-12-12 19:46:21',NULL),(2786,1603,40719,13,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',19880.28,NULL,NULL,1,'2021-12-12 19:46:21','2021-12-12 19:46:21',NULL),(2787,1603,40719,13,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',13420.58,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2788,1603,40719,13,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',15447.05,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2789,1603,40719,13,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',8021.88,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2790,1603,40719,13,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',12798.16,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2791,1603,40719,13,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',13516.53,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2792,1603,40719,13,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',13287.19,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2793,1603,40719,13,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4907.00,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2794,1603,40719,13,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',13480.01,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL);
INSERT INTO `balance_libro` VALUES (2795,1603,40719,13,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',7695.98,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2796,1603,40719,13,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',34996.06,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2797,1603,40719,13,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',2200.00,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2798,1603,40719,13,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',2200.00,NULL,NULL,1,'2021-12-12 19:46:22','2021-12-12 19:46:22',NULL),(2799,1603,40719,13,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',5878.76,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2800,1603,40719,13,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',11323.42,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2801,1603,40719,13,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',1800.00,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2802,1603,40719,13,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',14792.54,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2803,1603,40719,13,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',34996.06,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2804,1603,40719,13,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',2200.00,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2805,1603,40719,13,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',8172.58,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2806,1603,40719,13,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',12329.50,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2807,1603,40719,13,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',15917.16,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2808,1603,40719,13,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',15760.10,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2809,1603,40719,13,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',9339.06,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2810,1603,40719,13,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',8496.02,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2811,1603,40719,13,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',32383.38,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2812,1603,40719,13,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',5731.00,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2813,1603,40719,13,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',9500.00,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2814,1603,40719,13,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',20518.42,NULL,NULL,1,'2021-12-12 19:46:23','2021-12-12 19:46:23',NULL),(2815,1603,40719,13,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',3800.01,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL);
INSERT INTO `balance_libro` VALUES (2816,1603,40719,13,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',4800.00,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2817,1603,40719,13,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',32308.78,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2818,1603,40719,13,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',2200.00,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2819,1603,40719,13,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4500.00,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2820,1603,40719,13,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',19681.61,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2821,1603,40719,13,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',13480.01,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2822,1603,40719,13,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',109.99,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2823,1603,40719,13,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',15088.40,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2824,1603,40719,13,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',2200.00,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2825,1603,40719,13,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',12883.77,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2826,1603,40719,13,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',2300.00,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2827,1603,40719,13,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',11014.36,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2828,1603,40719,13,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',14956.00,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2829,1603,40719,13,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',8034.02,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2830,1603,40719,13,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',14990.53,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2831,1603,40719,13,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',14566.59,NULL,NULL,1,'2021-12-12 19:46:24','2021-12-12 19:46:24',NULL),(2832,1603,40719,13,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',14693.20,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2833,1603,40719,13,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',14956.00,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2834,1603,40719,13,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',14956.00,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2835,1603,40719,13,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',3987.00,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2836,1603,40719,13,2,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',14759.86,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL);
INSERT INTO `balance_libro` VALUES (2837,1603,40719,13,2,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',12038.10,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2838,1603,40719,13,2,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',3800.01,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2839,1603,40719,13,2,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',159392.80,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2840,1603,40719,13,2,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',4750.00,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2841,1603,40719,13,2,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',5499.99,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2842,1603,40719,13,2,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',18545.14,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2843,1603,40719,13,2,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',10802.15,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2844,1603,40719,13,2,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',7870.00,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2845,1603,40719,13,2,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',10000.00,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2846,1603,40719,13,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',1800.00,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2847,1603,40719,13,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',1800.00,NULL,NULL,1,'2021-12-12 19:46:25','2021-12-12 19:46:25',NULL),(2848,1603,40719,13,2,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4750.00,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2849,1603,40719,13,2,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',500.00,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2850,1603,40719,13,2,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',40212.62,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2851,1603,40719,13,2,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',37953.53,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2852,1603,40719,13,2,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',52507.48,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2853,1603,40719,13,2,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',22642.28,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2854,1603,40719,13,2,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',3800.01,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2855,1603,40719,13,2,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',5000.00,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2856,1603,40719,13,2,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',4600.00,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2857,1603,40719,13,2,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',3600.00,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL);
INSERT INTO `balance_libro` VALUES (2858,1603,40719,13,2,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',31510.00,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2859,1603,40719,13,2,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',4100.00,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2860,1603,40719,13,2,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',15667.16,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2861,1603,40719,13,2,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',4800.00,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2862,1603,40719,13,2,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1800.00,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2863,1603,40719,13,2,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',13326.50,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2864,1603,40719,13,2,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',16398.79,NULL,NULL,1,'2021-12-12 19:46:26','2021-12-12 19:46:26',NULL),(2865,1603,40719,13,2,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',22150.01,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2866,1603,40719,13,2,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',3800.01,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2867,1603,40719,13,2,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',25950.00,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2868,1603,40719,13,2,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',22150.01,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2869,1603,40719,13,2,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',3800.01,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2870,1603,40719,13,2,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',25950.00,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2871,1603,40719,13,2,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',25950.00,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2872,1603,40719,13,2,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',7000.00,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2873,1603,40719,13,2,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',3800.01,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2874,1603,40719,13,2,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',20272.15,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2875,1603,40719,13,2,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',26992.34,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2876,1603,40719,13,2,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',3600.00,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2877,1603,40719,13,2,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',27837.49,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2878,1603,40719,13,2,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',9594.36,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL);
INSERT INTO `balance_libro` VALUES (2879,1603,40719,13,2,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',15088.40,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2880,1603,40719,13,2,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',38165.94,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2881,1603,40719,13,2,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',16285.01,NULL,NULL,1,'2021-12-12 19:46:27','2021-12-12 19:46:27',NULL),(2882,1603,40719,13,2,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',1900.00,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2883,1603,40719,13,2,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',33981.60,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2884,1603,40719,13,2,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',5000.00,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2885,1603,40719,13,2,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',4500.00,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2886,1603,40719,13,2,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',24458.67,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2887,1603,40719,13,2,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',11708.01,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2888,1603,40719,13,2,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',27086.49,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2889,1603,40719,13,2,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',5000.00,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2890,1603,40719,13,2,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',8197.50,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2891,1603,40719,13,2,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',156400.00,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2892,1603,40719,13,2,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',78200.00,NULL,NULL,1,'2021-12-12 19:46:28','2021-12-12 19:46:28',NULL),(2895,1603,40719,13,3,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',999.99,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2896,1603,40719,13,3,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',4173.27,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2897,1603,40719,13,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',2961.00,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2898,1603,40719,13,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',2168.15,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2899,1603,40719,13,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',999.99,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2900,1603,40719,13,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',999.99,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2901,1603,40719,13,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',987.00,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL);
INSERT INTO `balance_libro` VALUES (2902,1603,40719,13,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',2640.03,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2903,1603,40719,13,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',1973.99,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2904,1603,40719,13,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',7568.78,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2905,1603,40719,13,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',19133.29,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2906,1603,40719,13,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',7231.00,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2907,1603,40719,13,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',750.20,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2908,1603,40719,13,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',861.00,NULL,NULL,1,'2021-12-14 22:04:47','2021-12-14 22:04:47',NULL),(2909,1603,40719,13,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',10962.25,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2910,1603,40719,13,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',42291.92,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2911,1603,40719,13,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',40004.48,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2912,1603,40719,13,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',62077.39,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2913,1603,40719,13,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',2000.01,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2914,1603,40719,13,3,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',999.99,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2915,1603,40719,13,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',11569.10,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2916,1603,40719,13,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',90400.00,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2917,1603,40719,13,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',1771.00,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2918,1603,40719,13,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',1251.97,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2919,1603,40719,13,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',11569.52,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2920,1603,40719,13,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',5900.40,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2921,1603,40719,13,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',3134.89,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2922,1603,40719,13,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',22072.90,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL);
INSERT INTO `balance_libro` VALUES (2923,1603,40719,13,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',24829.74,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2924,1603,40719,13,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',2000.01,NULL,NULL,1,'2021-12-14 22:04:48','2021-12-14 22:04:48',NULL),(2925,1603,40719,13,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4500.00,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2926,1603,40719,13,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',2309.91,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2927,1603,40719,13,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',1771.00,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2928,1603,40719,13,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',2324.00,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2929,1603,40719,13,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',11890.65,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2930,1603,40719,13,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',8330.00,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2931,1603,40719,13,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',10249.61,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2932,1603,40719,13,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',5913.12,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2933,1603,40719,13,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',2797.50,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2934,1603,40719,13,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',10962.25,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2935,1603,40719,13,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',4791.19,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2936,1603,40719,13,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',2947.75,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2937,1603,40719,13,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',42131.18,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2938,1603,40719,13,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',10148.02,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2939,1603,40719,13,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',3025.00,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2940,1603,40719,13,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',51898.11,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2941,1603,40719,13,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',1760.01,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2942,1603,40719,13,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',1771.00,NULL,NULL,1,'2021-12-14 22:04:49','2021-12-14 22:04:49',NULL),(2943,1603,40719,13,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',987.00,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL);
INSERT INTO `balance_libro` VALUES (2944,1603,40719,13,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',21619.60,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2945,1603,40719,13,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',2839.79,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2946,1603,40719,13,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',5390.01,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2947,1603,40719,13,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',2324.00,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2948,1603,40719,13,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',2472.70,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2949,1603,40719,13,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',10958.18,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2950,1603,40719,13,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',6559.00,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2951,1603,40719,13,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',430.00,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2952,1603,40719,13,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',12.10,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2953,1603,40719,13,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',60150.06,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2954,1603,40719,13,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',3542.00,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2955,1603,40719,13,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',3742.71,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2956,1603,40719,13,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',999.99,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2957,1603,40719,13,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',13334.83,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2958,1603,40719,13,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',929.99,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2959,1603,40719,13,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',11636.17,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2960,1603,40719,13,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',1750.00,NULL,NULL,1,'2021-12-14 22:04:50','2021-12-14 22:04:50',NULL),(2961,1603,40719,13,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',5006.24,NULL,NULL,1,'2021-12-14 22:04:51','2021-12-14 22:04:51',NULL),(2962,1603,40719,13,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',3253.13,NULL,NULL,1,'2021-12-14 22:04:51','2021-12-14 22:04:51',NULL),(2963,1603,40719,13,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',500.02,NULL,NULL,1,'2021-12-14 22:04:51','2021-12-14 22:04:51',NULL),(2964,1603,40719,13,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',430.00,NULL,NULL,1,'2021-12-14 22:04:51','2021-12-14 22:04:51',NULL);
INSERT INTO `balance_libro` VALUES (2965,1603,40719,13,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',500.01,NULL,NULL,1,'2021-12-14 22:04:51','2021-12-14 22:04:51',NULL),(2966,1603,40719,13,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',14311.88,NULL,NULL,1,'2021-12-14 22:04:51','2021-12-14 22:04:51',NULL),(2967,1603,40719,13,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',10632.50,NULL,NULL,1,'2021-12-14 22:04:52','2021-12-14 22:04:52',NULL),(2968,1603,40719,13,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',989.99,NULL,NULL,1,'2021-12-14 22:04:52','2021-12-14 22:04:52',NULL),(2969,1603,40719,13,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',10100.00,NULL,NULL,1,'2021-12-14 22:04:52','2021-12-14 22:04:52',NULL),(2970,1603,40719,13,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',2250.02,NULL,NULL,1,'2021-12-14 22:04:52','2021-12-14 22:04:52',NULL),(2971,1603,40719,13,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',4752.64,NULL,NULL,1,'2021-12-14 22:04:52','2021-12-14 22:04:52',NULL),(2972,1603,40719,13,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',18930.90,NULL,NULL,1,'2021-12-14 22:04:52','2021-12-14 22:04:52',NULL),(2973,1603,40719,13,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',3818.26,NULL,NULL,1,'2021-12-14 22:04:52','2021-12-14 22:04:52',NULL),(2974,1603,40719,13,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',2289.50,NULL,NULL,1,'2021-12-14 22:04:52','2021-12-14 22:04:52',NULL),(2975,1603,40719,13,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',2619.49,NULL,NULL,1,'2021-12-14 22:04:52','2021-12-14 22:04:52',NULL),(2976,1603,40719,13,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',42605.31,NULL,NULL,1,'2021-12-14 22:04:53','2021-12-14 22:04:53',NULL),(2977,1603,40719,13,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',81076.31,NULL,NULL,1,'2021-12-14 22:04:53','2021-12-14 22:04:53',NULL),(2978,1603,40719,13,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1992.92,NULL,NULL,1,'2021-12-14 22:04:53','2021-12-14 22:04:53',NULL),(2979,1603,40719,13,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',42780.32,NULL,NULL,1,'2021-12-14 22:04:53','2021-12-14 22:04:53',NULL),(2980,1603,40719,13,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',14794.67,NULL,NULL,1,'2021-12-14 22:04:53','2021-12-14 22:04:53',NULL),(2981,1603,40719,13,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',12.04,NULL,NULL,1,'2021-12-14 22:04:53','2021-12-14 22:04:53',NULL),(2982,1603,40719,13,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2466.17,NULL,NULL,1,'2021-12-14 22:04:53','2021-12-14 22:04:53',NULL),(2983,1603,40719,13,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',4459.09,NULL,NULL,1,'2021-12-14 22:04:53','2021-12-14 22:04:53',NULL),(2984,1603,40719,13,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2466.29,NULL,NULL,1,'2021-12-14 22:04:53','2021-12-14 22:04:53',NULL),(2985,1603,40719,13,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',10633.32,NULL,NULL,1,'2021-12-14 22:04:54','2021-12-14 22:04:54',NULL);
INSERT INTO `balance_libro` VALUES (2986,1603,40719,13,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1700.00,NULL,NULL,1,'2021-12-14 22:04:54','2021-12-14 22:04:54',NULL),(2987,1603,40719,13,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',12973.62,NULL,NULL,1,'2021-12-14 22:04:54','2021-12-14 22:04:54',NULL),(2988,1603,40719,13,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',122084.11,NULL,NULL,1,'2021-12-14 22:04:54','2021-12-14 22:04:54',NULL),(2989,1603,40719,13,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',35756.39,NULL,NULL,1,'2021-12-14 22:04:54','2021-12-14 22:04:54',NULL),(2990,1603,40719,13,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',147152.36,NULL,NULL,1,'2021-12-14 22:04:54','2021-12-14 22:04:54',NULL),(2991,1603,40719,13,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',6230.00,NULL,NULL,1,'2021-12-14 22:04:54','2021-12-14 22:04:54',NULL),(2992,1603,40719,13,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',0.00,NULL,NULL,1,'2021-12-14 22:04:54','2021-12-14 22:04:54',NULL),(2993,NULL,40719,14,2,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',78200.00,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(2994,NULL,40719,14,2,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',6160.82,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(2995,NULL,40719,14,2,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',179999.99,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(2996,NULL,40719,14,2,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',32157.34,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(2997,NULL,40719,14,2,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',19532.70,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(2998,NULL,40719,14,2,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',19426.20,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(2999,NULL,40719,14,2,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',13995.73,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(3000,NULL,40719,14,2,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',5700.01,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(3001,NULL,40719,14,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',5300.07,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(3002,NULL,40719,14,2,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',3771.00,NULL,NULL,1,'2022-01-08 19:48:04','2022-01-08 19:48:04',NULL),(3003,NULL,40719,14,2,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',4600.01,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3004,NULL,40719,14,2,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',29570.00,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3005,NULL,40719,14,2,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',12551.00,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3006,NULL,40719,14,2,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',5177.00,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL);
INSERT INTO `balance_libro` VALUES (3007,NULL,40719,14,2,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',40177.41,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3008,NULL,40719,14,2,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',9300.01,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3009,NULL,40719,14,2,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',44300.46,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3010,NULL,40719,14,2,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',2200.00,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3011,NULL,40719,14,2,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',3210.00,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3012,NULL,40719,14,2,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',5500.01,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3013,NULL,40719,14,2,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',873.00,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3014,NULL,40719,14,2,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',27086.49,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3015,NULL,40719,14,2,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',28909.95,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3016,NULL,40719,14,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',500.00,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3017,NULL,40719,14,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10019.50,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3018,NULL,40719,14,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',2200.00,NULL,NULL,1,'2022-01-08 19:48:05','2022-01-08 19:48:05',NULL),(3019,NULL,40719,14,2,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',4800.00,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3020,NULL,40719,14,2,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',3600.00,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3021,NULL,40719,14,2,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',85195.40,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3022,NULL,40719,14,2,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',16974.19,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3023,NULL,40719,14,2,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',10394.88,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3024,NULL,40719,14,2,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',12172.21,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3025,NULL,40719,14,2,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',3800.01,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3026,NULL,40719,14,2,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',17108.95,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3027,NULL,40719,14,2,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',32057.53,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL);
INSERT INTO `balance_libro` VALUES (3028,NULL,40719,14,2,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',11657.09,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3029,NULL,40719,14,2,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',2200.00,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3030,NULL,40719,14,2,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',17841.63,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3031,NULL,40719,14,2,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',37277.17,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3032,NULL,40719,14,2,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',26476.17,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3033,NULL,40719,14,2,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',15432.61,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3034,NULL,40719,14,2,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',17642.41,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3035,NULL,40719,14,2,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',1800.00,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3036,NULL,40719,14,2,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',11179.44,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3037,NULL,40719,14,2,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',670.99,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3038,NULL,40719,14,2,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',3800.01,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3039,NULL,40719,14,2,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',8200.00,NULL,NULL,1,'2022-01-08 19:48:06','2022-01-08 19:48:06',NULL),(3040,NULL,40719,14,2,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',1800.00,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3041,NULL,40719,14,2,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',4600.00,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3042,NULL,40719,14,2,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',14198.12,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3043,NULL,40719,14,2,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',2800.00,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3044,NULL,40719,14,2,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',753.49,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3045,NULL,40719,14,2,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',4074.99,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3046,NULL,40719,14,2,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',7500.00,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3047,NULL,40719,14,2,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',180000.00,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3048,NULL,40719,14,2,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',15752.16,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL);
INSERT INTO `balance_libro` VALUES (3049,NULL,40719,14,2,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2200.00,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3050,NULL,40719,14,2,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',5200.00,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3051,NULL,40719,14,2,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',12896.49,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3052,NULL,40719,14,2,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',16968.40,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3053,NULL,40719,14,2,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',16689.71,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3054,NULL,40719,14,2,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',11750.00,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3055,NULL,40719,14,2,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',14469.95,NULL,NULL,1,'2022-01-08 19:48:07','2022-01-08 19:48:07',NULL),(3056,NULL,40719,14,2,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',61062.90,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3057,NULL,40719,14,2,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',3800.01,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3058,NULL,40719,14,2,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',3100.00,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3059,NULL,40719,14,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',14459.21,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3060,NULL,40719,14,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',3800.01,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3061,NULL,40719,14,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',16416.48,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3062,NULL,40719,14,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',2600.00,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3063,NULL,40719,14,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',17467.52,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3064,NULL,40719,14,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',16074.16,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3065,NULL,40719,14,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',88600.92,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3066,NULL,40719,14,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',4934.04,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3067,NULL,40719,14,2,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',20286.19,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3068,NULL,40719,14,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',4600.00,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3069,NULL,40719,14,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',20992.57,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL);
INSERT INTO `balance_libro` VALUES (3070,NULL,40719,14,2,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',3800.01,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3071,NULL,40719,14,2,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',46668.78,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3072,NULL,40719,14,2,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',75727.28,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3073,NULL,40719,14,2,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',28306.49,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3074,NULL,40719,14,2,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',3800.01,NULL,NULL,1,'2022-01-08 19:48:08','2022-01-08 19:48:08',NULL),(3075,NULL,40719,14,2,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',12915.00,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3076,NULL,40719,14,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',3800.01,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3077,NULL,40719,14,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',11278.00,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3078,NULL,40719,14,2,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',5775.00,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3079,NULL,40719,14,2,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',13176.50,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3080,NULL,40719,14,2,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',4060.00,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3081,NULL,40719,14,2,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',4060.00,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3082,NULL,40719,14,2,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',44468.00,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3083,NULL,40719,14,2,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',52027.56,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3084,NULL,40719,14,2,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',37111.17,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3085,NULL,40719,14,2,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',46874.46,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3086,NULL,40719,14,2,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',17486.65,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3087,NULL,40719,14,2,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',12906.69,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3088,NULL,40719,14,2,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',7100.00,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3089,NULL,40719,14,2,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',25654.18,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3090,NULL,40719,14,2,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',2600.00,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL);
INSERT INTO `balance_libro` VALUES (3091,NULL,40719,14,2,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',30696.16,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3092,NULL,40719,14,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',5600.00,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3093,NULL,40719,14,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',2140.01,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3094,NULL,40719,14,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',16471.63,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3095,NULL,40719,14,2,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',17902.77,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3096,NULL,40719,14,2,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',67060.56,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3097,NULL,40719,14,2,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',6989.58,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3098,NULL,40719,14,2,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',23412.28,NULL,NULL,1,'2022-01-08 19:48:09','2022-01-08 19:48:09',NULL),(3099,NULL,40719,14,2,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',21622.53,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3100,NULL,40719,14,2,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',4000.01,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3101,NULL,40719,14,2,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',3800.01,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3102,NULL,40719,14,2,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',3800.01,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3103,NULL,40719,14,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',17826.74,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3104,NULL,40719,14,2,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',23238.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3105,NULL,40719,14,2,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',2000.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3106,NULL,40719,14,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',14896.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3107,NULL,40719,14,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',5499.99,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3108,NULL,40719,14,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1800.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3109,NULL,40719,14,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',38568.77,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3110,NULL,40719,14,2,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1351.39,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3111,NULL,40719,14,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',11151.17,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL);
INSERT INTO `balance_libro` VALUES (3112,NULL,40719,14,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',2899.99,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3113,NULL,40719,14,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',14574.83,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3114,NULL,40719,14,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',5600.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3115,NULL,40719,14,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',2000.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3116,NULL,40719,14,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',12428.16,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3117,NULL,40719,14,2,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',3600.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3118,NULL,40719,14,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',7886.61,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3119,NULL,40719,14,2,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',2460.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3120,NULL,40719,14,2,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',3800.01,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3121,NULL,40719,14,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',5246.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3122,NULL,40719,14,2,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',17504.01,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3123,NULL,40719,14,2,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',1045.00,NULL,NULL,1,'2022-01-08 19:48:10','2022-01-08 19:48:10',NULL),(3124,NULL,40719,14,2,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',5300.01,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3125,NULL,40719,14,2,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',2400.00,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3126,NULL,40719,14,2,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',7748.88,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3127,NULL,40719,14,2,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',31234.18,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3128,NULL,40719,14,2,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',3800.01,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3129,NULL,40719,14,2,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',1800.00,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3130,NULL,40719,14,2,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',48267.07,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3131,NULL,40719,14,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',16407.58,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3132,NULL,40719,14,2,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',3800.01,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL);
INSERT INTO `balance_libro` VALUES (3133,NULL,40719,14,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',22594.32,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3134,NULL,40719,14,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',17609.61,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3135,NULL,40719,14,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',3600.00,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3136,NULL,40719,14,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',20170.58,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3137,NULL,40719,14,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',15280.69,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3138,NULL,40719,14,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',25794.18,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3139,NULL,40719,14,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',2679.61,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3140,NULL,40719,14,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',14435.91,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3141,NULL,40719,14,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',3800.01,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3142,NULL,40719,14,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',16474.88,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3143,NULL,40719,14,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',156400.00,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3144,NULL,40719,14,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',19532.70,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3145,NULL,40719,14,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',17609.61,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3146,NULL,40719,14,3,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',999.99,NULL,NULL,1,'2022-01-08 19:48:11','2022-01-08 19:48:11',NULL),(3147,NULL,40719,14,3,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',2000.01,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3148,NULL,40719,14,3,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',1771.00,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3149,NULL,40719,14,3,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',999.99,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3150,NULL,40719,14,3,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',59156.90,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3151,NULL,40719,14,3,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',289.99,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3152,NULL,40719,14,3,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',590.00,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3153,NULL,40719,14,3,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',3818.26,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL);
INSERT INTO `balance_libro` VALUES (3154,NULL,40719,14,3,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',9181.78,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3155,NULL,40719,14,3,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',750.20,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3156,NULL,40719,14,3,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',4270.59,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3157,NULL,40719,14,3,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',142999.98,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3158,NULL,40719,14,3,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',6559.00,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3159,NULL,40719,14,3,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',504.00,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3160,NULL,40719,14,3,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',5912.16,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3161,NULL,40719,14,3,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',18638.48,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3162,NULL,40719,14,3,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1650.02,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3163,NULL,40719,14,3,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1827.84,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3164,NULL,40719,14,3,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2250.01,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3165,NULL,40719,14,3,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2000.00,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3166,NULL,40719,14,3,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1967.00,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3167,NULL,40719,14,3,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',11002.30,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3168,NULL,40719,14,3,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',5158.98,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3169,NULL,40719,14,3,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',999.99,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3170,NULL,40719,14,3,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',210000.03,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3171,NULL,40719,14,3,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',300.00,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3172,NULL,40719,14,3,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',28600.00,NULL,NULL,1,'2022-01-08 19:48:12','2022-01-08 19:48:12',NULL),(3173,NULL,40719,14,3,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',104600.00,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3174,NULL,40719,14,3,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',1162.00,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL);
INSERT INTO `balance_libro` VALUES (3175,NULL,40719,14,3,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',7894.79,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3176,NULL,40719,14,3,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',11752.73,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3177,NULL,40719,14,3,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',55132.44,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3178,NULL,40719,14,3,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',20166.31,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3179,NULL,40719,14,3,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',4683.45,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3180,NULL,40719,14,3,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',20692.46,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3181,NULL,40719,14,3,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',6559.00,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3182,NULL,40719,14,3,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',2443.43,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3183,NULL,40719,14,3,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',1096.80,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3184,NULL,40719,14,3,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',2000.01,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3185,NULL,40719,14,3,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',57999.99,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3186,NULL,40719,14,3,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',999.99,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3187,NULL,40719,14,3,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',8083.18,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3188,NULL,40719,14,3,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',2840.67,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3189,NULL,40719,14,3,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',1987.04,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3190,NULL,40719,14,3,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',2142.00,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3191,NULL,40719,14,3,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',13334.83,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3192,NULL,40719,14,3,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-19','2021-12-19',8143.01,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3193,NULL,40719,14,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',309.24,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3194,NULL,40719,14,3,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',11005.69,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3195,NULL,40719,14,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',2909.40,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL);
INSERT INTO `balance_libro` VALUES (3196,NULL,40719,14,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',3720.80,NULL,NULL,1,'2022-01-08 19:48:13','2022-01-08 19:48:13',NULL),(3197,NULL,40719,14,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',185999.99,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3198,NULL,40719,14,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',26669.64,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3199,NULL,40719,14,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',15825.33,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3200,NULL,40719,14,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',3323.24,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3201,NULL,40719,14,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',12.10,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3202,NULL,40719,14,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',1000.41,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3203,NULL,40719,14,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',187.43,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3204,NULL,40719,14,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',3101.00,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3205,NULL,40719,14,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',226.63,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3206,NULL,40719,14,3,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',2200.61,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3207,NULL,40719,14,3,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',4499.45,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3208,NULL,40719,14,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',118139.56,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3209,NULL,40719,14,3,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',4356.30,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3210,NULL,40719,14,3,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',40004.48,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3211,NULL,40719,14,3,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',165199.99,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3212,NULL,40719,14,3,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',987.00,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3213,NULL,40719,14,3,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',3542.00,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3214,NULL,40719,14,3,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',13.08,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3215,NULL,40719,14,3,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',3201.70,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3216,NULL,40719,14,3,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',2549.44,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL);
INSERT INTO `balance_libro` VALUES (3217,NULL,40719,14,3,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',1001.12,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3218,NULL,40719,14,3,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',6559.00,NULL,NULL,1,'2022-01-08 19:48:14','2022-01-08 19:48:14',NULL),(3219,NULL,40719,14,3,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',154083.41,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3220,NULL,40719,14,3,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',1084.08,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3221,NULL,40719,14,3,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',19333.36,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3222,NULL,40719,14,3,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',1722.00,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3223,NULL,40719,14,3,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',679.00,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3224,NULL,40719,14,3,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',20403.99,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3225,NULL,40719,14,3,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',2359.00,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3226,NULL,40719,14,3,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',46209.23,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3227,NULL,40719,14,3,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',87756.22,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3228,NULL,40719,14,3,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',2000.00,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3229,NULL,40719,14,3,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',61371.20,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3230,NULL,40719,14,3,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',81052.36,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3231,NULL,40719,14,3,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',175900.00,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3232,NULL,40719,14,3,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',84150.30,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3233,NULL,40719,14,3,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',21859.44,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3234,NULL,40719,14,3,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',3360.00,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3235,NULL,40719,14,3,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',20847.09,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3236,NULL,40719,14,3,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',928.09,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3237,NULL,40719,14,3,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',21032.58,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL);
INSERT INTO `balance_libro` VALUES (3238,NULL,40719,14,3,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',661.94,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3239,NULL,40719,14,3,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',6230.00,NULL,NULL,1,'2022-01-08 19:48:15','2022-01-08 19:48:15',NULL),(3240,1603,40719,13,7,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',10918.34,NULL,NULL,1,'2022-01-08 20:04:33','2022-01-08 20:04:33',NULL),(3241,1603,40719,13,16,513,'App\\Models\\PeriodLiquidation',NULL,513,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',24077.59,NULL,NULL,1,'2022-01-08 20:05:44','2022-01-08 20:05:44',NULL),(3242,1603,40719,13,15,512,'App\\Models\\PeriodLiquidation',NULL,512,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',301553.06,NULL,NULL,1,'2022-01-08 20:06:02','2022-01-08 20:10:14','2022-01-08 20:10:14'),(3243,1603,40719,13,15,512,'App\\Models\\PeriodLiquidation',NULL,512,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',301553.06,NULL,NULL,1,'2022-01-08 20:10:36','2022-01-08 20:10:36',NULL),(3244,1603,40719,14,15,509,'App\\Models\\PeriodLiquidation',NULL,509,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',460754.64,NULL,NULL,1,'2022-01-08 23:32:25','2022-01-09 00:35:06','2022-01-09 00:35:06'),(3245,1603,40719,14,2,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',3800.00,NULL,NULL,1,'2022-01-09 00:41:31','2022-01-09 00:41:31',NULL),(3246,1603,40719,14,15,515,'App\\Models\\PeriodLiquidation',NULL,515,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',461414.14,NULL,NULL,1,'2022-01-09 20:44:36','2023-01-15 23:06:35','2023-01-15 23:06:35'),(3247,1603,40719,18,2,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4600.00,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3248,1603,40719,18,2,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',14469.95,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3249,1603,40719,18,2,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4000.01,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3250,1603,40719,18,2,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',8097.86,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3251,1603,40719,18,2,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4500.00,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3252,1603,40719,18,2,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',38364.26,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3253,1603,40719,18,2,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',17986.01,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3254,1603,40719,18,2,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',21017.19,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3255,1603,40719,18,2,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',15250.01,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3256,1603,40719,18,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',17326.66,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35');
INSERT INTO `balance_libro` VALUES (3257,1603,40719,18,2,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',2000.00,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3258,1603,40719,18,2,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',14598.17,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3259,1603,40719,18,2,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',1661.02,NULL,NULL,1,'2022-02-12 18:23:42','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3260,1603,40719,18,2,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',44300.46,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3261,1603,40719,18,2,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',3500.00,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3262,1603,40719,18,2,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',4310.88,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3263,1603,40719,18,2,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',17068.43,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3264,1603,40719,18,2,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',3800.01,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3265,1603,40719,18,2,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',3800.01,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3266,1603,40719,18,2,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',11696.50,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3267,1603,40719,18,2,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',7700.00,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3268,1603,40719,18,2,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',2000.00,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3269,1603,40719,18,2,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',16494.19,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3270,1603,40719,18,2,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',43697.99,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3271,1603,40719,18,2,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',37348.71,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3272,1603,40719,18,2,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',5300.01,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3273,1603,40719,18,2,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',31509.78,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3274,1603,40719,18,2,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',17824.91,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3275,1603,40719,18,2,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',9568.14,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35');
INSERT INTO `balance_libro` VALUES (3276,1603,40719,18,2,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2000.00,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3277,1603,40719,18,2,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',9236.99,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3278,1603,40719,18,2,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',15117.99,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3279,1603,40719,18,2,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',14800.57,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:35','2022-02-12 18:49:35'),(3280,1603,40719,18,2,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',2600.00,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3281,1603,40719,18,2,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',26774.17,NULL,NULL,1,'2022-02-12 18:23:43','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3282,1603,40719,18,2,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',16036.74,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3283,1603,40719,18,2,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',3800.01,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3284,1603,40719,18,2,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',10344.96,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3285,1603,40719,18,2,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',2530.00,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3286,1603,40719,18,2,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',13526.54,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3287,1603,40719,18,2,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',3800.01,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3288,1603,40719,18,2,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',12923.14,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3289,1603,40719,18,2,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',5360.00,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3290,1603,40719,18,2,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',4991.50,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3291,1603,40719,18,2,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',14447.15,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3292,1603,40719,18,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',21060.17,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3293,1603,40719,18,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',4800.00,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3294,1603,40719,18,2,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',24866.33,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36');
INSERT INTO `balance_libro` VALUES (3295,1603,40719,18,2,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',3800.01,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3296,1603,40719,18,2,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',11632.11,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3297,1603,40719,18,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',14690.01,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3298,1603,40719,18,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',8320.00,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3299,1603,40719,18,2,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',2600.00,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3300,1603,40719,18,2,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',9243.14,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3301,1603,40719,18,2,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',753.49,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3302,1603,40719,18,2,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',1341.97,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3303,1603,40719,18,2,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',25211.02,NULL,NULL,1,'2022-02-12 18:23:44','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3304,1603,40719,18,2,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',44727.27,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3305,1603,40719,18,2,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',2000.00,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3306,1603,40719,18,2,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',12835.99,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3307,1603,40719,18,2,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3880.00,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3308,1603,40719,18,2,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',23796.16,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3309,1603,40719,18,2,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',4800.00,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3310,1603,40719,18,2,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',21974.04,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3311,1603,40719,18,2,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',5300.01,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3312,1603,40719,18,2,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',6789.58,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3313,1603,40719,18,2,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',4600.00,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36');
INSERT INTO `balance_libro` VALUES (3314,1603,40719,18,2,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',1300.00,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3315,1603,40719,18,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',15990.53,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3316,1603,40719,18,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',4800.00,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3317,1603,40719,18,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',3800.01,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3318,1603,40719,18,2,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30789.08,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3319,1603,40719,18,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',37574.44,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3320,1603,40719,18,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',39957.85,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3321,1603,40719,18,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',4113.49,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3322,1603,40719,18,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',12689.04,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3323,1603,40719,18,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',15807.14,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3324,1603,40719,18,2,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',13796.53,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3325,1603,40719,18,2,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',75430.92,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3326,1603,40719,18,2,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',12150.69,NULL,NULL,1,'2022-02-12 18:23:45','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3327,1603,40719,18,2,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',930.01,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3328,1603,40719,18,2,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',5649.67,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3329,1603,40719,18,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',14276.69,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3330,1603,40719,18,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',2300.00,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3331,1603,40719,18,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',20270.00,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3332,1603,40719,18,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',2500.01,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36');
INSERT INTO `balance_libro` VALUES (3333,1603,40719,18,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',4300.00,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3334,1603,40719,18,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',38176.69,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3335,1603,40719,18,2,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',14585.33,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3336,1603,40719,18,2,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',96000.00,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3337,1603,40719,18,2,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',12240.15,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3338,1603,40719,18,2,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',14402.16,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3339,1603,40719,18,2,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',2650.03,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3340,1603,40719,18,2,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',3800.01,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3341,1603,40719,18,2,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',14676.65,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:36','2022-02-12 18:49:36'),(3342,1603,40719,18,2,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',34069.32,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3343,1603,40719,18,2,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',2200.00,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3344,1603,40719,18,2,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',9036.00,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3345,1603,40719,18,2,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',12323.14,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3346,1603,40719,18,2,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',6986.00,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3347,1603,40719,18,2,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',10166.54,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3348,1603,40719,18,2,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',8736.99,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3349,1603,40719,18,2,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',6160.00,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3350,1603,40719,18,2,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',21935.50,NULL,NULL,1,'2022-02-12 18:23:46','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3351,1603,40719,18,2,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',14722.22,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37');
INSERT INTO `balance_libro` VALUES (3352,1603,40719,18,2,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',9240.00,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3353,1603,40719,18,2,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2000.00,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3354,1603,40719,18,2,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',4199.99,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3355,1603,40719,18,2,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',15092.58,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3356,1603,40719,18,2,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2200.00,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3357,1603,40719,18,2,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',15569.00,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3358,1603,40719,18,2,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',9336.20,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3359,1603,40719,18,2,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',19155.63,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3360,1603,40719,18,2,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',14200.64,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3361,1603,40719,18,2,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',4500.00,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3362,1603,40719,18,2,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',19066.61,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3363,1603,40719,18,2,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',26487.51,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3364,1603,40719,18,2,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6520.00,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3365,1603,40719,18,2,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2109.99,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3366,1603,40719,18,2,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7236.99,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3367,1603,40719,18,2,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',5100.00,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3368,1603,40719,18,2,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',27837.49,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3369,1603,40719,18,2,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',7916.52,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3370,1603,40719,18,2,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',15568.40,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37');
INSERT INTO `balance_libro` VALUES (3371,1603,40719,18,2,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',17297.94,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3372,1603,40719,18,2,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',22710.97,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3373,1603,40719,18,2,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',17270.00,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3374,1603,40719,18,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',137679.22,NULL,NULL,1,'2022-02-12 18:23:47','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3375,1603,40719,18,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',5000.00,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3376,1603,40719,18,2,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3800.01,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3377,1603,40719,18,2,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',19072.89,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3378,1603,40719,18,2,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',11944.88,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3379,1603,40719,18,2,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',3800.01,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3380,1603,40719,18,2,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',3800.01,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3381,1603,40719,18,2,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',3800.01,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3382,1603,40719,18,2,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',3097.90,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3383,1603,40719,18,2,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',670.99,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:37','2022-02-12 18:49:37'),(3384,1603,40719,18,2,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',21773.10,NULL,NULL,1,'2022-02-12 18:23:48','2022-02-12 18:49:21','2022-02-12 18:49:21'),(3385,1603,40719,18,2,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4600.00,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL),(3386,1603,40719,18,2,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',14469.95,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL),(3387,1603,40719,18,2,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4000.01,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL),(3388,1603,40719,18,2,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',8097.86,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL),(3389,1603,40719,18,2,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4500.00,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL),(3390,1603,40719,18,2,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',38364.26,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL);
INSERT INTO `balance_libro` VALUES (3391,1603,40719,18,2,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',17986.01,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL),(3392,1603,40719,18,2,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',21017.19,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL),(3393,1603,40719,18,2,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',15250.01,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL),(3394,1603,40719,18,2,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',17326.66,NULL,NULL,1,'2022-02-12 18:50:08','2022-02-12 18:50:08',NULL),(3395,1603,40719,18,2,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',2000.00,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3396,1603,40719,18,2,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',14598.17,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3397,1603,40719,18,2,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',1661.02,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3398,1603,40719,18,2,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',44300.46,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3399,1603,40719,18,2,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',3500.00,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3400,1603,40719,18,2,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',4310.88,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3401,1603,40719,18,2,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',17068.43,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3402,1603,40719,18,2,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',3800.01,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3403,1603,40719,18,2,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',3800.01,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3404,1603,40719,18,2,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',11696.50,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3405,1603,40719,18,2,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',7700.00,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3406,1603,40719,18,2,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',2000.00,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3407,1603,40719,18,2,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',16494.19,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3408,1603,40719,18,2,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',43697.99,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3409,1603,40719,18,2,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',37348.71,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3410,1603,40719,18,2,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',5300.01,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3411,1603,40719,18,2,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',31509.78,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL);
INSERT INTO `balance_libro` VALUES (3412,1603,40719,18,2,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',17824.91,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3413,1603,40719,18,2,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',9568.14,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3414,1603,40719,18,2,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2000.00,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3415,1603,40719,18,2,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',9236.99,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3416,1603,40719,18,2,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',15117.99,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3417,1603,40719,18,2,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',14800.57,NULL,NULL,1,'2022-02-12 18:50:09','2022-02-12 18:50:09',NULL),(3418,1603,40719,18,2,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',2600.00,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3419,1603,40719,18,2,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',26774.17,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3420,1603,40719,18,2,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',16036.74,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3421,1603,40719,18,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',3800.01,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3422,1603,40719,18,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',10344.96,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3423,1603,40719,18,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',2530.00,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3424,1603,40719,18,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',13526.54,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3425,1603,40719,18,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',3800.01,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3426,1603,40719,18,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',12923.14,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3427,1603,40719,18,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',5360.00,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3428,1603,40719,18,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',4991.50,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3429,1603,40719,18,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',14447.15,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3430,1603,40719,18,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',21060.17,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3431,1603,40719,18,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',4800.00,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3432,1603,40719,18,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',24866.33,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL);
INSERT INTO `balance_libro` VALUES (3433,1603,40719,18,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',3800.01,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3434,1603,40719,18,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',11632.11,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3435,1603,40719,18,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',14690.01,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3436,1603,40719,18,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',8320.00,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3437,1603,40719,18,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',2600.00,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3438,1603,40719,18,2,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',9243.14,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3439,1603,40719,18,2,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',753.49,NULL,NULL,1,'2022-02-12 18:50:10','2022-02-12 18:50:10',NULL),(3440,1603,40719,18,2,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',1341.97,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3441,1603,40719,18,2,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',25211.02,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3442,1603,40719,18,2,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',44727.27,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3443,1603,40719,18,2,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',2000.00,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3444,1603,40719,18,2,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',12835.99,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3445,1603,40719,18,2,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3880.00,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3446,1603,40719,18,2,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',23796.16,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3447,1603,40719,18,2,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',4800.00,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3448,1603,40719,18,2,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',21974.04,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3449,1603,40719,18,2,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',5300.01,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3450,1603,40719,18,2,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',6789.58,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3451,1603,40719,18,2,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',4600.00,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3452,1603,40719,18,2,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',1300.00,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3453,1603,40719,18,2,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',15990.53,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL);
INSERT INTO `balance_libro` VALUES (3454,1603,40719,18,2,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',4800.00,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3455,1603,40719,18,2,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',3800.01,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3456,1603,40719,18,2,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30789.08,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3457,1603,40719,18,2,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',37574.44,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3458,1603,40719,18,2,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',39957.85,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3459,1603,40719,18,2,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',4113.49,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3460,1603,40719,18,2,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',12689.04,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3461,1603,40719,18,2,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',15807.14,NULL,NULL,1,'2022-02-12 18:50:11','2022-02-12 18:50:11',NULL),(3462,1603,40719,18,2,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',13796.53,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3463,1603,40719,18,2,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',75430.92,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3464,1603,40719,18,2,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',12150.69,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3465,1603,40719,18,2,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',930.01,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3466,1603,40719,18,2,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',5649.67,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3467,1603,40719,18,2,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',14276.69,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3468,1603,40719,18,2,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',2300.00,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3469,1603,40719,18,2,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',20270.00,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3470,1603,40719,18,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',2500.01,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3471,1603,40719,18,2,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',4300.00,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3472,1603,40719,18,2,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',38176.69,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3473,1603,40719,18,2,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',14585.33,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3474,1603,40719,18,2,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',96000.00,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL);
INSERT INTO `balance_libro` VALUES (3475,1603,40719,18,2,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',12240.15,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3476,1603,40719,18,2,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',14402.16,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3477,1603,40719,18,2,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',2650.03,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3478,1603,40719,18,2,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',3800.01,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3479,1603,40719,18,2,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',14676.65,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3480,1603,40719,18,2,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',34069.32,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3481,1603,40719,18,2,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',2200.00,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3482,1603,40719,18,2,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',9036.00,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3483,1603,40719,18,2,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',12323.14,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3484,1603,40719,18,2,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',6986.00,NULL,NULL,1,'2022-02-12 18:50:12','2022-02-12 18:50:12',NULL),(3485,1603,40719,18,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',10166.54,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3486,1603,40719,18,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',8736.99,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3487,1603,40719,18,2,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',6160.00,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3488,1603,40719,18,2,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',21935.50,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3489,1603,40719,18,2,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',14722.22,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3490,1603,40719,18,2,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',9240.00,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3491,1603,40719,18,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2000.00,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3492,1603,40719,18,2,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',4199.99,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3493,1603,40719,18,2,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',15092.58,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3494,1603,40719,18,2,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2200.00,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3495,1603,40719,18,2,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',15569.00,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL);
INSERT INTO `balance_libro` VALUES (3496,1603,40719,18,2,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',9336.20,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3497,1603,40719,18,2,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',19155.63,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3498,1603,40719,18,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',14200.64,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3499,1603,40719,18,2,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',4500.00,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3500,1603,40719,18,2,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',19066.61,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3501,1603,40719,18,2,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',26487.51,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3502,1603,40719,18,2,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6520.00,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3503,1603,40719,18,2,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2109.99,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3504,1603,40719,18,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7236.99,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3505,1603,40719,18,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',5100.00,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3506,1603,40719,18,2,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',27837.49,NULL,NULL,1,'2022-02-12 18:50:13','2022-02-12 18:50:13',NULL),(3507,1603,40719,18,2,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',7916.52,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3508,1603,40719,18,2,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',15568.40,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3509,1603,40719,18,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',17297.94,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3510,1603,40719,18,2,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',22710.97,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3511,1603,40719,18,2,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',17270.00,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3512,1603,40719,18,2,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',137679.22,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3513,1603,40719,18,2,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',5000.00,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3514,1603,40719,18,2,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3800.01,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3515,1603,40719,18,2,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',19072.89,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3516,1603,40719,18,2,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',11944.88,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL);
INSERT INTO `balance_libro` VALUES (3517,1603,40719,18,2,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',3800.01,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3518,1603,40719,18,2,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',3800.01,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3519,1603,40719,18,2,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',3800.01,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3520,1603,40719,18,2,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',3097.90,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3521,1603,40719,18,2,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',670.99,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3522,1603,40719,18,2,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',21773.10,NULL,NULL,1,'2022-02-12 18:50:14','2022-02-12 18:50:14',NULL),(3523,1603,40719,18,3,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',5000.01,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3524,1603,40719,18,3,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1700.00,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3525,1603,40719,18,3,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',999.99,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3526,1603,40719,18,3,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',1771.00,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3527,1603,40719,18,3,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',3360.00,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3528,1603,40719,18,3,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',31664.88,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3529,1603,40719,18,3,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',679.00,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3530,1603,40719,18,3,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',14870.49,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3531,1603,40719,18,3,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',33.88,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3532,1603,40719,18,3,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',5119.99,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3533,1603,40719,18,3,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',2025.89,NULL,NULL,1,'2022-02-12 19:22:14','2022-02-12 19:22:14',NULL),(3534,1603,40719,18,3,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1575.36,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3535,1603,40719,18,3,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',5831.38,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3536,1603,40719,18,3,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',7194.83,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3537,1603,40719,18,3,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',969.78,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL);
INSERT INTO `balance_libro` VALUES (3538,1603,40719,18,3,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',750.20,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3539,1603,40719,18,3,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2000.01,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3540,1603,40719,18,3,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',383799.96,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3541,1603,40719,18,3,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',3931.76,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3542,1603,40719,18,3,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',18124.28,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3543,1603,40719,18,3,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',11149.30,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3544,1603,40719,18,3,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',2000.01,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3545,1603,40719,18,3,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1071.00,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3546,1603,40719,18,3,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',7721.00,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3547,1603,40719,18,3,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',75821.02,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3548,1603,40719,18,3,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',8183.50,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3549,1603,40719,18,3,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',13000.39,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3550,1603,40719,18,3,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',24940.54,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3551,1603,40719,18,3,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',2250.00,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3552,1603,40719,18,3,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',7257.23,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3553,1603,40719,18,3,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',6559.00,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3554,1603,40719,18,3,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',20002.24,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3555,1603,40719,18,3,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',180.00,NULL,NULL,1,'2022-02-12 19:22:15','2022-02-12 19:22:15',NULL),(3556,1603,40719,18,3,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',26502.94,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3557,1603,40719,18,3,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',6559.00,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3558,1603,40719,18,3,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',28600.38,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-14 00:06:43','2022-02-14 00:06:43');
INSERT INTO `balance_libro` VALUES (3559,1603,40719,18,3,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',26000.78,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3560,1603,40719,18,3,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',5489.99,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3561,1603,40719,18,3,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',999.99,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3562,1603,40719,18,3,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',614.00,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3563,1603,40719,18,3,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',6230.73,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3564,1603,40719,18,3,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',1080.38,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3565,1603,40719,18,3,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',3876.26,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3566,1603,40719,18,3,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',3101.00,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3567,1603,40719,18,3,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',7980.00,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3568,1603,40719,18,3,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2509.29,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3569,1603,40719,18,3,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',6230.00,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3570,1603,40719,18,3,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',520.00,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3571,1603,40719,18,3,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',29026.48,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3572,1603,40719,18,3,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',6582.33,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3573,1603,40719,18,3,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',11084.82,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3574,1603,40719,18,3,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',81745.18,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3575,1603,40719,18,3,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',999.99,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3576,1603,40719,18,3,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',10011.79,NULL,NULL,1,'2022-02-12 19:22:16','2022-02-12 19:22:16',NULL),(3577,1603,40719,18,3,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3619.00,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3578,1603,40719,18,3,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',679.00,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3579,1603,40719,18,3,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',21823.87,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL);
INSERT INTO `balance_libro` VALUES (3580,1603,40719,18,3,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',9234.72,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3581,1603,40719,18,3,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',16600.94,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3582,1603,40719,18,3,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-23','2022-01-23',2631.06,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3583,1603,40719,18,3,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1800.00,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3584,1603,40719,18,3,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',12665.95,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3585,1603,40719,18,3,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',6987.75,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3586,1603,40719,18,3,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',44174.92,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3587,1603,40719,18,3,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',10858.56,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3588,1603,40719,18,3,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',2200.00,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3589,1603,40719,18,3,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',2040.02,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3590,1603,40719,18,3,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',10346.23,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3591,1603,40719,18,3,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',3619.00,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3592,1603,40719,18,3,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',200.00,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3593,1603,40719,18,3,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',700.00,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3594,1603,40719,18,3,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',181099.99,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3595,1603,40719,18,3,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',60800.00,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3596,1603,40719,18,3,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',13334.83,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3597,1603,40719,18,3,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',55530.53,NULL,NULL,1,'2022-02-12 19:22:17','2022-02-12 19:22:17',NULL),(3598,1603,40719,18,3,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1680.00,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3599,1603,40719,18,3,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2214.49,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3600,1603,40719,18,3,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',999.99,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL);
INSERT INTO `balance_libro` VALUES (3601,1603,40719,18,3,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',59176.60,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3602,1603,40719,18,3,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',1680.00,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3603,1603,40719,18,3,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',45035.87,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3604,1603,40719,18,3,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6725.01,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3605,1603,40719,18,3,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10177.36,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3606,1603,40719,18,3,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4431.00,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3607,1603,40719,18,3,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',80008.96,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3608,1603,40719,18,3,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',136066.46,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3609,1603,40719,18,3,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10381.80,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:22:18',NULL),(3610,1603,40719,18,3,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',690.43,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:37:34','2022-02-12 19:37:34'),(3611,1603,40719,18,3,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',7538.30,NULL,NULL,1,'2022-02-12 19:22:18','2022-02-12 19:38:13','2022-02-12 19:38:13'),(3612,1603,40719,14,16,516,'App\\Models\\PeriodLiquidation',NULL,516,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',35656.48,NULL,NULL,1,'2022-02-12 19:27:56','2023-01-15 23:05:24','2023-01-15 23:05:24'),(3613,1603,40719,18,7,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',21036.48,NULL,NULL,1,'2022-02-12 19:31:05','2022-02-12 19:32:41','2022-02-12 19:32:41'),(3614,1603,40719,18,3,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',570.60,NULL,NULL,1,'2022-02-12 19:37:34','2022-02-12 19:38:49','2022-02-12 19:38:49'),(3615,1603,40719,18,3,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',6230.00,NULL,NULL,1,'2022-02-12 19:38:13','2022-02-12 19:38:13',NULL),(3616,1603,40719,18,3,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',570.60,NULL,NULL,1,'2022-02-12 19:38:49','2022-02-12 19:38:49',NULL),(3617,1603,40719,18,3,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',28600.38,NULL,NULL,1,'2022-02-14 00:06:43','2022-02-14 00:06:43',NULL),(3618,1603,40719,18,15,538,'App\\Models\\PeriodLiquidation',NULL,538,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',340986.34,NULL,NULL,1,'2022-02-14 00:41:29','2022-03-15 00:43:14','2022-03-15 00:43:14'),(3619,1603,40719,19,2,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',3000.00,NULL,NULL,1,'2022-03-14 22:29:57','2022-03-14 22:29:57',NULL),(3620,1603,40719,19,2,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',12920.00,NULL,NULL,1,'2022-03-14 22:29:57','2022-03-14 23:57:18','2022-03-14 23:57:18');
INSERT INTO `balance_libro` VALUES (3621,1603,40719,19,2,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',3150.00,NULL,NULL,1,'2022-03-14 22:29:57','2022-03-14 23:58:03','2022-03-14 23:58:03'),(3622,1603,40719,19,2,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',40326.88,NULL,NULL,1,'2022-03-14 22:29:57','2022-03-14 22:29:57',NULL),(3623,1603,40719,19,2,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',4199.99,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3624,1603,40719,19,2,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',4000.01,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3625,1603,40719,19,2,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',17549.78,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3626,1603,40719,19,2,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',4876.99,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3627,1603,40719,19,2,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',2500.01,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3628,1603,40719,19,2,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',13135.84,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3629,1603,40719,19,2,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',40782.18,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3630,1603,40719,19,2,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',21511.63,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3631,1603,40719,19,2,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1500.00,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3632,1603,40719,19,2,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',2000.00,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3633,1603,40719,19,2,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',23350.58,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3634,1603,40719,19,2,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1000.00,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3635,1603,40719,19,2,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',9660.00,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3636,1603,40719,19,2,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',49253.28,NULL,NULL,1,'2022-03-14 22:29:58','2022-03-14 22:29:58',NULL),(3637,1603,40719,19,2,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',6133.87,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3638,1603,40719,19,2,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',4100.00,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3639,1603,40719,19,2,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',4742.99,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3640,1603,40719,19,2,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',11575.94,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3641,1603,40719,19,2,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',1500.00,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL);
INSERT INTO `balance_libro` VALUES (3642,1603,40719,19,2,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',16005.54,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3643,1603,40719,19,2,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',19357.64,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3644,1603,40719,19,2,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',1000.00,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3645,1603,40719,19,2,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',12398.35,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3646,1603,40719,19,2,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',16000.00,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3647,1603,40719,19,2,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',2000.00,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3648,1603,40719,19,2,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',39267.67,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3649,1603,40719,19,2,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',15966.06,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3650,1603,40719,19,2,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',47324.87,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3651,1603,40719,19,2,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',21462.58,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3652,1603,40719,19,2,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',40621.81,NULL,NULL,1,'2022-03-14 22:29:59','2022-03-14 22:29:59',NULL),(3653,1603,40719,19,2,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',105361.38,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3654,1603,40719,19,2,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',18312.22,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3655,1603,40719,19,2,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',5499.99,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3656,1603,40719,19,2,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',13879.85,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3657,1603,40719,19,2,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',1000.00,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3658,1603,40719,19,2,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',25693.35,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3659,1603,40719,19,2,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',23193.34,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3660,1603,40719,19,2,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',4000.01,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3661,1603,40719,19,2,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',3500.00,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3662,1603,40719,19,2,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',5740.00,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL);
INSERT INTO `balance_libro` VALUES (3663,1603,40719,19,2,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',14027.76,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3664,1603,40719,19,2,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',60270.71,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3665,1603,40719,19,2,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',4199.99,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3666,1603,40719,19,2,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',17341.31,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3667,1603,40719,19,2,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',4500.00,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3668,1603,40719,19,2,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',46386.68,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3669,1603,40719,19,2,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',2012.97,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3670,1603,40719,19,2,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',1205.79,NULL,NULL,1,'2022-03-14 22:30:00','2022-03-14 22:30:00',NULL),(3671,1603,40719,19,2,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',4000.01,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3672,1603,40719,19,2,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',5630.61,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3673,1603,40719,19,2,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',9924.73,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3674,1603,40719,19,2,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',26302.34,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3675,1603,40719,19,2,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',13611.35,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3676,1603,40719,19,2,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',6239.44,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3677,1603,40719,19,2,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',14779.85,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3678,1603,40719,19,2,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',1310.65,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3679,1603,40719,19,2,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',17270.37,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3680,1603,40719,19,2,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',17775.80,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3681,1603,40719,19,2,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',1500.00,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3682,1603,40719,19,2,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',4500.00,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL),(3683,1603,40719,19,2,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',7500.00,NULL,NULL,1,'2022-03-14 22:30:01','2022-03-14 22:30:01',NULL);
INSERT INTO `balance_libro` VALUES (3684,1603,40719,19,2,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',46538.60,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3685,1603,40719,19,2,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',8875.60,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3686,1603,40719,19,2,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',105361.38,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3687,1603,40719,19,2,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',12720.13,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3688,1603,40719,19,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',22190.21,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3689,1603,40719,19,2,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',21790.21,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3690,1603,40719,19,2,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',3500.00,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3691,1603,40719,19,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',6500.00,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3692,1603,40719,19,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',18641.67,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3693,1603,40719,19,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',12031.01,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3694,1603,40719,19,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',3000.00,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3695,1603,40719,19,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',1500.00,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3696,1603,40719,19,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',2500.01,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3697,1603,40719,19,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',18641.67,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3698,1603,40719,19,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',17067.67,NULL,NULL,1,'2022-03-14 22:30:02','2022-03-14 22:30:02',NULL),(3699,1603,40719,19,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',33970.29,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3700,1603,40719,19,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',5275.00,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3701,1603,40719,19,2,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',4000.01,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3702,1603,40719,19,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',8900.00,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3703,1603,40719,19,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',3000.00,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3704,1603,40719,19,2,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',1600.00,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL);
INSERT INTO `balance_libro` VALUES (3705,1603,40719,19,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',13006.54,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3706,1603,40719,19,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',6810.30,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3707,1603,40719,19,2,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',4500.00,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3708,1603,40719,19,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',4000.01,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3709,1603,40719,19,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',14950.37,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3710,1603,40719,19,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',42390.31,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3711,1603,40719,19,2,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',5440.00,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3712,1603,40719,19,2,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',17213.91,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3713,1603,40719,19,2,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',17424.10,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3714,1603,40719,19,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',51178.12,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3715,1603,40719,19,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',25117.36,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3716,1603,40719,19,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',8608.00,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3717,1603,40719,19,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',4000.01,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3718,1603,40719,19,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',4000.01,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3719,1603,40719,19,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',5499.99,NULL,NULL,1,'2022-03-14 22:30:03','2022-03-14 22:30:03',NULL),(3720,1603,40719,19,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',8608.00,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3721,1603,40719,19,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',2500.01,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3722,1603,40719,19,2,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',20392.64,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3723,1603,40719,19,2,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',9257.06,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3724,1603,40719,19,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',5000.00,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3725,1603,40719,19,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',16300.37,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL);
INSERT INTO `balance_libro` VALUES (3726,1603,40719,19,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',4000.01,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3727,1603,40719,19,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',5500.01,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3728,1603,40719,19,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',7000.00,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3729,1603,40719,19,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',44195.15,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3730,1603,40719,19,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',205199.98,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3731,1603,40719,19,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',26227.50,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3732,1603,40719,19,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',7000.00,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3733,1603,40719,19,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',106099.99,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3734,1603,40719,19,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',98040.01,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3735,1603,40719,19,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',20257.25,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3736,1603,40719,19,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',15564.08,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3737,1603,40719,19,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',20446.25,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3738,1603,40719,19,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',5499.99,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3739,1603,40719,19,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',8388.18,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3740,1603,40719,19,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',225475.37,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3741,1603,40719,19,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',26817.24,NULL,NULL,1,'2022-03-14 22:30:04','2022-03-14 22:30:04',NULL),(3742,1603,40719,19,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',1323.22,NULL,NULL,1,'2022-03-14 22:30:05','2022-03-14 22:30:05',NULL),(3743,1603,40719,19,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',23447.80,NULL,NULL,1,'2022-03-14 22:30:05','2022-03-14 22:30:05',NULL),(3744,1603,40719,19,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',20257.25,NULL,NULL,1,'2022-03-14 22:30:05','2022-03-14 22:30:05',NULL),(3745,1603,40719,19,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',2338.93,NULL,NULL,1,'2022-03-14 22:30:05','2022-03-14 22:30:05',NULL),(3751,1603,40719,19,3,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1700.01,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL);
INSERT INTO `balance_libro` VALUES (3752,1603,40719,19,3,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1000.00,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3753,1603,40719,19,3,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2404.50,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3754,1603,40719,19,3,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',4709.01,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3755,1603,40719,19,3,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',6111.00,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3756,1603,40719,19,3,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1915.67,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3757,1603,40719,19,3,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',17589.93,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3758,1603,40719,19,3,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',67562.77,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3759,1603,40719,19,3,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',4000.00,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3760,1603,40719,19,3,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',1680.00,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3761,1603,40719,19,3,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',2250.01,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3762,1603,40719,19,3,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',17063.45,NULL,NULL,1,'2022-03-14 23:45:16','2022-03-14 23:45:16',NULL),(3763,1603,40719,19,3,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',7358.92,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3764,1603,40719,19,3,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',9029.00,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3765,1603,40719,19,3,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',8918.00,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3766,1603,40719,19,3,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',56705.44,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3767,1603,40719,19,3,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',13491.38,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3768,1603,40719,19,3,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',10976.91,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3769,1603,40719,19,3,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',19070.00,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3770,1603,40719,19,3,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',537599.95,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3771,1603,40719,19,3,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',19897.54,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3772,1603,40719,19,3,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',102081.86,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL);
INSERT INTO `balance_libro` VALUES (3773,1603,40719,19,3,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',2754.08,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3774,1603,40719,19,3,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',2000.00,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3775,1603,40719,19,3,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',1973.99,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3776,1603,40719,19,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-13','2022-02-13',5455.58,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3777,1603,40719,19,3,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-13','2022-02-13',5535.62,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3778,1603,40719,19,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',4167.74,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3779,1603,40719,19,3,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',1028.50,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3780,1603,40719,19,3,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',2499.99,NULL,NULL,1,'2022-03-14 23:45:17','2022-03-14 23:45:17',NULL),(3781,1603,40719,19,3,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',679.00,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3782,1603,40719,19,3,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',750.20,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3783,1603,40719,19,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',679.00,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3784,1603,40719,19,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',13000.39,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3785,1603,40719,19,3,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',2324.00,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3786,1603,40719,19,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',119999.00,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-15 00:06:09','2022-03-15 00:06:09'),(3787,1603,40719,19,3,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',10799.00,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3788,1603,40719,19,3,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',1000.01,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3789,1603,40719,19,3,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',37706.11,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3790,1603,40719,19,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',13334.83,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3791,1603,40719,19,3,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',6559.00,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3792,1603,40719,19,3,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',207991.74,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3793,1603,40719,19,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2800.00,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL);
INSERT INTO `balance_libro` VALUES (3794,1603,40719,19,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',10800.12,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3795,1603,40719,19,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',6199.99,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3796,1603,40719,19,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',1752.62,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3797,1603,40719,19,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2999.99,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3798,1603,40719,19,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',6165.03,NULL,NULL,1,'2022-03-14 23:45:18','2022-03-14 23:45:18',NULL),(3799,1603,40719,19,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',9454.00,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3800,1603,40719,19,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',12.10,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3801,1603,40719,19,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',6402.18,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3802,1603,40719,19,3,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',28089.00,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3803,1603,40719,19,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',2001.40,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3804,1603,40719,19,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1771.00,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3805,1603,40719,19,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1699.99,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-15 01:14:53','2022-03-15 01:14:53'),(3806,1603,40719,19,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',5390.01,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3807,1603,40719,19,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',16035.89,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3808,1603,40719,19,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',3983.79,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3809,1603,40719,19,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',44085.96,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3810,1603,40719,19,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',6150.87,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3811,1603,40719,19,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',2398.67,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3812,1603,40719,19,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',8330.00,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3813,1603,40719,19,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',3432.97,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3814,1603,40719,19,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1314.02,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL);
INSERT INTO `balance_libro` VALUES (3815,1603,40719,19,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',4062.51,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3816,1603,40719,19,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',4859.20,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3817,1603,40719,19,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',269400.00,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3818,1603,40719,19,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',164101.29,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3819,1603,40719,19,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',102081.86,NULL,NULL,1,'2022-03-14 23:45:19','2022-03-14 23:45:19',NULL),(3820,1603,40719,19,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',3900.50,NULL,NULL,1,'2022-03-14 23:45:20','2022-03-14 23:45:20',NULL),(3821,1603,40719,19,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',4977.48,NULL,NULL,1,'2022-03-14 23:45:20','2022-03-14 23:45:20',NULL),(3822,1603,40719,19,3,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',15847.88,NULL,NULL,1,'2022-03-14 23:45:20','2022-03-14 23:45:20',NULL),(3823,1603,40719,19,3,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',42238.99,NULL,NULL,1,'2022-03-14 23:45:20','2022-03-14 23:45:20',NULL),(3824,1603,40719,19,3,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',97506.99,NULL,NULL,1,'2022-03-14 23:45:20','2022-03-14 23:45:20',NULL),(3825,1603,40719,19,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1057.13,NULL,NULL,1,'2022-03-14 23:45:20','2022-03-15 01:28:47','2022-03-15 01:28:47'),(3826,1603,40719,19,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',6230.00,NULL,NULL,1,'2022-03-14 23:45:20','2022-03-14 23:45:20',NULL),(3827,1603,40719,19,2,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',12770.00,NULL,NULL,1,'2022-03-14 23:57:18','2022-03-14 23:57:18',NULL),(3828,1603,40719,19,2,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',3000.00,NULL,NULL,1,'2022-03-14 23:58:03','2022-03-14 23:58:03',NULL),(3829,1603,40719,19,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',119999.00,NULL,NULL,1,'2022-03-15 00:06:09','2022-03-15 00:06:09',NULL),(3830,1603,40719,18,7,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',17466.30,NULL,NULL,1,'2022-03-15 00:44:27','2022-03-15 00:44:27',NULL),(3831,1603,40719,18,15,550,'App\\Models\\PeriodLiquidation',NULL,550,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',340986.34,NULL,NULL,1,'2022-03-15 00:47:49','2022-03-15 00:47:49',NULL),(3832,1603,40719,18,16,551,'App\\Models\\PeriodLiquidation',NULL,551,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',27303.56,NULL,NULL,1,'2022-03-15 00:48:39','2022-03-15 00:48:39',NULL),(3833,1603,40719,19,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1699.99,NULL,NULL,1,'2022-03-15 01:14:53','2022-03-15 01:14:53',NULL),(3834,1603,40719,19,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',478.34,NULL,NULL,1,'2022-03-15 01:28:47','2022-03-15 01:28:47',NULL),(3835,1603,40719,19,7,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',557.47,NULL,NULL,1,'2022-03-16 01:32:34','2022-03-16 01:32:34',NULL);
INSERT INTO `balance_libro` VALUES (3836,1603,40719,19,7,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',403.27,NULL,NULL,1,'2022-03-16 01:33:14','2022-03-16 01:33:14',NULL),(3837,1603,40719,19,7,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',415.05,NULL,NULL,1,'2022-03-16 01:33:43','2022-03-16 01:33:43',NULL),(3838,1603,40719,19,7,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',9209.38,NULL,NULL,1,'2022-03-16 01:35:18','2022-03-16 01:35:18',NULL),(3839,1603,40719,19,7,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3211.48,NULL,NULL,1,'2022-03-16 01:35:57','2022-03-16 01:35:57',NULL),(3840,1603,40719,19,7,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',506.93,NULL,NULL,1,'2022-03-16 01:37:09','2022-03-16 01:37:09',NULL),(3841,1603,40719,19,7,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',123.98,NULL,NULL,1,'2022-03-16 01:38:13','2022-03-16 01:38:13',NULL),(3842,1603,40719,19,7,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',2654.86,NULL,NULL,1,'2022-03-16 01:38:42','2022-03-16 01:38:42',NULL),(3843,1603,40719,19,7,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',55.00,NULL,NULL,1,'2022-03-16 01:39:20','2022-03-16 01:39:20',NULL),(3844,1603,40719,19,7,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',465.39,NULL,NULL,1,'2022-03-16 01:39:52','2022-03-16 01:39:52',NULL),(3845,1603,40719,19,7,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',35.00,NULL,NULL,1,'2022-03-16 01:40:16','2022-03-16 01:40:16',NULL),(3846,1603,40719,19,7,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',81.60,NULL,NULL,1,'2022-03-16 01:40:42','2022-03-16 01:40:42',NULL),(3847,1603,40719,19,16,579,'App\\Models\\PeriodLiquidation',NULL,579,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',37076.02,NULL,NULL,1,'2022-03-16 01:42:02','2022-03-16 01:42:02',NULL),(3848,1603,40719,19,15,578,'App\\Models\\PeriodLiquidation',NULL,578,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',433168.13,NULL,NULL,1,'2022-03-16 01:43:58','2022-03-16 01:43:58',NULL),(3941,1603,40719,20,2,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',3000.00,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3942,1603,40719,20,2,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',89020.00,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3943,1603,40719,20,2,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',6500.00,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3944,1603,40719,20,2,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',11651.76,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3945,1603,40719,20,2,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',17191.49,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3946,1603,40719,20,2,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',19725.82,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3947,1603,40719,20,2,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',144222.16,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3948,1603,40719,20,2,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',22634.65,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL);
INSERT INTO `balance_libro` VALUES (3949,1603,40719,20,2,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',4199.99,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3950,1603,40719,20,2,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',11500.00,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3951,1603,40719,20,2,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',18482.40,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3952,1603,40719,20,2,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',6500.00,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3953,1603,40719,20,2,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2000.00,NULL,NULL,1,'2022-04-10 19:50:59','2022-04-10 19:50:59',NULL),(3954,1603,40719,20,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1300.00,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3955,1603,40719,20,2,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',3000.00,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3956,1603,40719,20,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',22876.76,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3957,1603,40719,20,2,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',10930.55,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3958,1603,40719,20,2,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',11314.61,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3959,1603,40719,20,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',9628.50,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3960,1603,40719,20,2,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',7814.18,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3961,1603,40719,20,2,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',11359.89,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3962,1603,40719,20,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',4934.04,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3963,1603,40719,20,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',17632.54,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3964,1603,40719,20,2,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2000.00,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3965,1603,40719,20,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',23327.01,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3966,1603,40719,20,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',4000.01,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3967,1603,40719,20,2,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',4000.01,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3968,1603,40719,20,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2000.00,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3969,1603,40719,20,2,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',23177.34,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL);
INSERT INTO `balance_libro` VALUES (3970,1603,40719,20,2,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',16044.68,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3971,1603,40719,20,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',9421.45,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3972,1603,40719,20,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',17373.41,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3973,1603,40719,20,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',88915.48,NULL,NULL,1,'2022-04-10 19:51:00','2022-04-10 19:51:00',NULL),(3974,1603,40719,20,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',30801.78,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3975,1603,40719,20,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',29861.51,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3976,1603,40719,20,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',16322.96,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3977,1603,40719,20,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',3990.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3978,1603,40719,20,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',14700.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3979,1603,40719,20,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',6610.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3980,1603,40719,20,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',16664.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3981,1603,40719,20,2,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',3000.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3982,1603,40719,20,2,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2000.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3983,1603,40719,20,2,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',18242.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3984,1603,40719,20,2,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',3500.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3985,1603,40719,20,2,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',6750.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3986,1603,40719,20,2,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',6500.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3987,1603,40719,20,2,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',17907.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3988,1603,40719,20,2,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',54600.00,NULL,NULL,1,'2022-04-10 19:51:01','2022-04-10 19:51:01',NULL),(3989,1603,40719,20,2,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',11922.00,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(3990,1603,40719,20,2,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1480.00,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL);
INSERT INTO `balance_libro` VALUES (3991,1603,40719,20,2,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',38544.01,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(3992,1603,40719,20,2,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1500.00,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(3993,1603,40719,20,2,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',4000.01,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(3994,1603,40719,20,2,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',216839.99,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(3995,1603,40719,20,2,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',9900.00,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(3996,1603,40719,20,2,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',18579.73,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(3997,1603,40719,20,2,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',12621.99,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(3998,1603,40719,20,2,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',73624.00,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(3999,1603,40719,20,2,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',15226.16,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(4000,1603,40719,20,2,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',12621.99,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(4001,1603,40719,20,2,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',13821.09,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(4002,1603,40719,20,2,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1840.00,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(4003,1603,40719,20,2,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1000.00,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(4004,1603,40719,20,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',22635.00,NULL,NULL,1,'2022-04-10 19:51:02','2022-04-10 19:51:02',NULL),(4005,1603,40719,20,2,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',3000.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4006,1603,40719,20,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',7590.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4007,1603,40719,20,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',27749.99,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4008,1603,40719,20,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',26570.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4009,1603,40719,20,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',19971.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4010,1603,40719,20,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',3500.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4011,1603,40719,20,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',2660.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL);
INSERT INTO `balance_libro` VALUES (4012,1603,40719,20,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',14630.03,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4013,1603,40719,20,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',15710.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4014,1603,40719,20,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',5300.01,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4015,1603,40719,20,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',220.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4016,1603,40719,20,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',28778.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4017,1603,40719,20,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',42293.67,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4018,1603,40719,20,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',2000.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4019,1603,40719,20,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',11634.53,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4020,1603,40719,20,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',24070.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4021,1603,40719,20,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1000.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4022,1603,40719,20,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',14322.00,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4023,1603,40719,20,2,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',16082.49,NULL,NULL,1,'2022-04-10 19:51:03','2022-04-10 19:51:03',NULL),(4024,1603,40719,20,2,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',11799.90,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4025,1603,40719,20,2,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',3000.00,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4026,1603,40719,20,2,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',17142.00,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4027,1603,40719,20,2,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',5000.00,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4028,1603,40719,20,2,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',16460.01,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4029,1603,40719,20,2,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',16640.00,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4030,1603,40719,20,2,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',9182.84,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4031,1603,40719,20,2,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',5499.99,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4032,1603,40719,20,2,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',5000.00,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL);
INSERT INTO `balance_libro` VALUES (4033,1603,40719,20,2,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',25809.36,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4034,1603,40719,20,2,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',15706.47,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4035,1603,40719,20,2,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1340.00,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4036,1603,40719,20,2,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',28686.99,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4037,1603,40719,20,2,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',44733.17,NULL,NULL,1,'2022-04-10 19:51:04','2022-04-10 19:51:04',NULL),(4038,1603,40719,20,2,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',21760.00,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4039,1603,40719,20,2,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',5775.00,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4040,1603,40719,20,2,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',21760.00,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4041,1603,40719,20,2,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',22360.00,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4042,1603,40719,20,2,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',17447.99,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4043,1603,40719,20,2,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',5700.00,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4044,1603,40719,20,2,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',12258.26,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4045,1603,40719,20,2,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',41293.00,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4046,1603,40719,20,2,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',14937.30,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4047,1603,40719,20,2,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',26965.37,NULL,NULL,1,'2022-04-10 19:51:05','2022-04-10 19:51:05',NULL),(4048,1603,40719,20,2,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',28664.00,NULL,NULL,1,'2022-04-10 19:51:06','2022-04-10 19:51:06',NULL),(4049,1603,40719,20,2,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1882.00,NULL,NULL,1,'2022-04-10 19:51:06','2022-04-10 19:51:06',NULL),(4050,1603,40719,20,2,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4000.01,NULL,NULL,1,'2022-04-10 19:51:06','2022-04-10 19:51:06',NULL),(4051,1603,40719,20,2,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',13152.57,NULL,NULL,1,'2022-04-10 19:51:06','2022-04-10 19:51:06',NULL),(4136,1603,40719,20,3,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',2404.50,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4137,1603,40719,20,3,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',4709.01,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL);
INSERT INTO `balance_libro` VALUES (4138,1603,40719,20,3,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1150.00,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4139,1603,40719,20,3,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',42436.91,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4140,1603,40719,20,3,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',12539.90,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4141,1603,40719,20,3,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',494.43,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4142,1603,40719,20,3,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',279.41,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4143,1603,40719,20,3,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',186.29,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4144,1603,40719,20,3,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',2222.15,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4145,1603,40719,20,3,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',383200.01,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4146,1603,40719,20,3,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',29630.00,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4147,1603,40719,20,3,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',504.00,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4148,1603,40719,20,3,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',8867.71,NULL,NULL,1,'2022-04-10 19:54:31','2022-04-10 19:54:31',NULL),(4149,1603,40719,20,3,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2667.00,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4150,1603,40719,20,3,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',6202.00,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4151,1603,40719,20,3,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2716.56,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4152,1603,40719,20,3,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',133.10,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4153,1603,40719,20,3,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',19900.14,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4154,1603,40719,20,3,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',3349.28,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4155,1603,40719,20,3,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',707.00,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4156,1603,40719,20,3,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',12530.75,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4157,1603,40719,20,3,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',17034.66,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4158,1603,40719,20,3,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',32435.78,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL);
INSERT INTO `balance_libro` VALUES (4159,1603,40719,20,3,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',9675.80,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4160,1603,40719,20,3,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1050.01,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4161,1603,40719,20,3,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',9844.68,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4162,1603,40719,20,3,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',422.22,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4163,1603,40719,20,3,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',6559.00,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4164,1603,40719,20,3,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',6559.00,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4165,1603,40719,20,3,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',900.00,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4166,1603,40719,20,3,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2326.82,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4167,1603,40719,20,3,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2200.00,NULL,NULL,1,'2022-04-10 19:54:32','2022-04-10 19:54:32',NULL),(4168,1603,40719,20,3,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1126.99,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4169,1603,40719,20,3,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',28469.93,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4170,1603,40719,20,3,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',988.78,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4171,1603,40719,20,3,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',14706.07,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4172,1603,40719,20,3,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',27205.04,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4173,1603,40719,20,3,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1780.26,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4174,1603,40719,20,3,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',2968.70,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4175,1603,40719,20,3,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',20692.46,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4176,1603,40719,20,3,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1533.03,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4177,1603,40719,20,3,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1979.12,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4178,1603,40719,20,3,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',56619.64,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL),(4179,1603,40719,20,3,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',2191.00,NULL,NULL,1,'2022-04-10 19:54:33','2022-04-10 19:54:33',NULL);
INSERT INTO `balance_libro` VALUES (4180,1603,40719,20,3,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',707.00,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4181,1603,40719,20,3,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',2401.00,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4182,1603,40719,20,3,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',861.00,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4183,1603,40719,20,3,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',23281.16,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4184,1603,40719,20,3,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',203799.99,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4185,1603,40719,20,3,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',180.00,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4186,1603,40719,20,3,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',4088.00,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4187,1603,40719,20,3,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1771.00,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4188,1603,40719,20,3,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',67286.89,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4189,1603,40719,20,3,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',14715.27,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4190,1603,40719,20,3,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',11549.99,NULL,NULL,1,'2022-04-10 19:54:34','2022-04-10 19:54:34',NULL),(4191,1603,40719,20,3,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',3483.17,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4192,1603,40719,20,3,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',5769.59,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4193,1603,40719,20,3,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',9487.97,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4194,1603,40719,20,3,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',2306.87,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4195,1603,40719,20,3,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',15053.65,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4196,1603,40719,20,3,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',4846.93,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4197,1603,40719,20,3,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',989.56,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4198,1603,40719,20,3,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',3560.56,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4199,1603,40719,20,3,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',2454.63,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4200,1603,40719,20,3,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',989.56,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL);
INSERT INTO `balance_libro` VALUES (4201,1603,40719,20,3,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',3326.57,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4202,1603,40719,20,3,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',2560.00,NULL,NULL,1,'2022-04-10 19:54:35','2022-04-10 19:54:35',NULL),(4203,1603,40719,20,3,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',10847.00,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4204,1603,40719,20,3,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',2168.96,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4205,1603,40719,20,3,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',3542.00,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4206,1603,40719,20,3,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',2963.53,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4207,1603,40719,20,3,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',989.56,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4208,1603,40719,20,3,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',11509.96,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4209,1603,40719,20,3,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',7950.00,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4210,1603,40719,20,3,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',989.56,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4211,1603,40719,20,3,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',7238.00,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4212,1603,40719,20,3,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',5000.00,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4213,1603,40719,20,3,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',5272.74,NULL,NULL,1,'2022-04-10 19:54:36','2022-04-10 19:54:36',NULL),(4214,1603,40719,20,3,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',814.34,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4215,1603,40719,20,3,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',35446.01,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4216,1603,40719,20,3,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',94214.45,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4217,1603,40719,20,3,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',15536.98,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4218,1603,40719,20,3,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',745599.99,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4219,1603,40719,20,3,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',10346.23,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4220,1603,40719,20,3,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',20948.64,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4221,1603,40719,20,3,4015,'App\\Models\\Receipt',4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',10346.23,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL);
INSERT INTO `balance_libro` VALUES (4222,1603,40719,20,3,4016,'App\\Models\\Receipt',4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',2225.36,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4223,1603,40719,20,3,4017,'App\\Models\\Receipt',4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',11875.77,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4224,1603,40719,20,3,4018,'App\\Models\\Receipt',4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1979.14,NULL,NULL,1,'2022-04-10 19:54:37','2022-04-10 19:54:37',NULL),(4225,1603,40719,20,3,4019,'App\\Models\\Receipt',4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',26669.64,NULL,NULL,1,'2022-04-10 19:54:38','2022-04-10 19:54:38',NULL),(4226,1603,40719,20,3,4020,'App\\Models\\Receipt',4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3619.00,NULL,NULL,1,'2022-04-10 19:54:38','2022-04-10 19:54:38',NULL),(4227,1603,40719,20,3,4021,'App\\Models\\Receipt',4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4754.83,NULL,NULL,1,'2022-04-10 19:54:38','2022-04-10 19:54:38',NULL),(4228,1603,40719,20,3,4022,'App\\Models\\Receipt',4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',385.16,NULL,NULL,1,'2022-04-10 19:54:38','2022-04-10 19:54:38',NULL),(4229,1603,40719,20,3,4023,'App\\Models\\Receipt',4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',6230.00,NULL,NULL,1,'2022-04-10 19:54:38','2022-04-10 19:54:38',NULL),(4230,1603,40719,21,2,4024,'App\\Models\\Receipt',4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1574.38,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:09:26','2022-05-08 21:09:26'),(4231,1603,40719,21,2,4025,'App\\Models\\Receipt',4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',4371.53,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:09:14','2022-05-08 21:09:14'),(4232,1603,40719,21,2,4026,'App\\Models\\Receipt',4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1826.29,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:09:05','2022-05-08 21:09:05'),(4233,1603,40719,21,2,4027,'App\\Models\\Receipt',4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',29614.15,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:08:50','2022-05-08 21:08:50'),(4234,1603,40719,21,2,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',14937.71,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:08:39','2022-05-08 21:08:39'),(4235,1603,40719,21,2,4029,'App\\Models\\Receipt',4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',6822.31,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:08:23','2022-05-08 21:08:23'),(4236,1603,40719,21,2,4030,'App\\Models\\Receipt',4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',4723.14,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:08:13','2022-05-08 21:08:13'),(4237,1603,40719,21,2,4031,'App\\Models\\Receipt',4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25014.26,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:08:03','2022-05-08 21:08:03'),(4238,1603,40719,21,2,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',44422.64,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:07:54','2022-05-08 21:07:54'),(4239,1603,40719,21,2,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',23153.88,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:07:46','2022-05-08 21:07:46'),(4240,1603,40719,21,2,4034,'App\\Models\\Receipt',4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',8265.50,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:07:33','2022-05-08 21:07:33'),(4241,1603,40719,21,2,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',31063.57,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:07:24','2022-05-08 21:07:24');
INSERT INTO `balance_libro` VALUES (4242,1603,40719,21,2,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',4723.14,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:07:15','2022-05-08 21:07:15'),(4243,1603,40719,21,2,4037,'App\\Models\\Receipt',4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',18120.07,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:07:03','2022-05-08 21:07:03'),(4244,1603,40719,21,2,4038,'App\\Models\\Receipt',4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',20437.55,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:06:43','2022-05-08 21:06:43'),(4245,1603,40719,21,2,4039,'App\\Models\\Receipt',4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',121645.26,NULL,NULL,1,'2022-05-08 19:12:35','2022-05-08 21:06:33','2022-05-08 21:06:33'),(4246,1603,40719,21,2,4040,'App\\Models\\Receipt',4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1049.59,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:06:23','2022-05-08 21:06:23'),(4247,1603,40719,21,2,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',17014.94,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:06:14','2022-05-08 21:06:14'),(4248,1603,40719,21,2,4042,'App\\Models\\Receipt',4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',4198.35,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:06:04','2022-05-08 21:06:04'),(4249,1603,40719,21,2,4043,'App\\Models\\Receipt',4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',5247.93,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:05:53','2022-05-08 21:05:53'),(4250,1603,40719,21,2,4044,'App\\Models\\Receipt',4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',28645.24,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:05:44','2022-05-08 21:05:44'),(4251,1603,40719,21,2,4045,'App\\Models\\Receipt',4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',12901.52,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:05:32','2022-05-08 21:05:32'),(4252,1603,40719,21,2,4046,'App\\Models\\Receipt',4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',28664.22,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:05:23','2022-05-08 21:05:23'),(4253,1603,40719,21,2,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',22975.60,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:05:14','2022-05-08 21:05:14'),(4254,1603,40719,21,2,4048,'App\\Models\\Receipt',4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',17687.63,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:05:04','2022-05-08 21:05:04'),(4255,1603,40719,21,2,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',12804.97,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:04:56','2022-05-08 21:04:56'),(4256,1603,40719,21,2,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',8753.22,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:04:46','2022-05-08 21:04:46'),(4257,1603,40719,21,2,4051,'App\\Models\\Receipt',4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',5615.28,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:04:36','2022-05-08 21:04:36'),(4258,1603,40719,21,2,4052,'App\\Models\\Receipt',4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',18719.38,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:04:23','2022-05-08 21:04:23'),(4259,1603,40719,21,2,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',6402.48,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:04:12','2022-05-08 21:04:12'),(4260,1603,40719,21,2,4054,'App\\Models\\Receipt',4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',18731.98,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:04:02','2022-05-08 21:04:02');
INSERT INTO `balance_libro` VALUES (4261,1603,40719,21,2,4055,'App\\Models\\Receipt',4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',17371.71,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:03:52','2022-05-08 21:03:52'),(4262,1603,40719,21,2,4056,'App\\Models\\Receipt',4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',48479.51,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:03:43','2022-05-08 21:03:43'),(4263,1603,40719,21,2,4057,'App\\Models\\Receipt',4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4198.35,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:03:34','2022-05-08 21:03:34'),(4264,1603,40719,21,2,4058,'App\\Models\\Receipt',4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',18739.32,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:03:24','2022-05-08 21:03:24'),(4265,1603,40719,21,2,4059,'App\\Models\\Receipt',4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',19185.39,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:03:15','2022-05-08 21:03:15'),(4266,1603,40719,21,2,4060,'App\\Models\\Receipt',4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',18892.56,NULL,NULL,1,'2022-05-08 19:12:36','2022-05-08 21:03:04','2022-05-08 21:03:04'),(4267,1603,40719,21,2,4061,'App\\Models\\Receipt',4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',17238.90,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:02:51','2022-05-08 21:02:51'),(4268,1603,40719,21,2,4062,'App\\Models\\Receipt',4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',21076.75,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:02:42','2022-05-08 21:02:42'),(4269,1603,40719,21,2,4063,'App\\Models\\Receipt',4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',97296.82,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:02:33','2022-05-08 21:02:33'),(4270,1603,40719,21,2,4064,'App\\Models\\Receipt',4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',19440.98,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:02:25','2022-05-08 21:02:25'),(4271,1603,40719,21,2,4065,'App\\Models\\Receipt',4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',90085.72,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:02:11','2022-05-08 21:02:11'),(4272,1603,40719,21,2,4066,'App\\Models\\Receipt',4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',16793.39,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:02:01','2022-05-08 21:02:01'),(4273,1603,40719,21,2,4067,'App\\Models\\Receipt',4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',4723.14,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:01:50','2022-05-08 21:01:50'),(4274,1603,40719,21,2,4068,'App\\Models\\Receipt',4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',19891.77,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:01:40','2022-05-08 21:01:40'),(4275,1603,40719,21,2,4069,'App\\Models\\Receipt',4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',4198.35,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:01:31','2022-05-08 21:01:31'),(4276,1603,40719,21,2,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',2099.17,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:01:22','2022-05-08 21:01:22'),(4277,1603,40719,21,2,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1574.38,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:01:13','2022-05-08 21:01:13'),(4278,1603,40719,21,2,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',3148.76,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:01:01','2022-05-08 21:01:01'),(4279,1603,40719,21,2,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',2398.31,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:00:53','2022-05-08 21:00:53');
INSERT INTO `balance_libro` VALUES (4280,1603,40719,21,2,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',5667.77,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:00:43','2022-05-08 21:00:43'),(4281,1603,40719,21,2,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',12856.30,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:00:34','2022-05-08 21:00:34'),(4282,1603,40719,21,2,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',11212.26,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:00:26','2022-05-08 21:00:26'),(4283,1603,40719,21,2,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',4198.35,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:00:15','2022-05-08 21:00:15'),(4284,1603,40719,21,2,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',14413.80,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 21:00:06','2022-05-08 21:00:06'),(4285,1603,40719,21,2,4079,'App\\Models\\Receipt',4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',24293.74,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 20:59:57','2022-05-08 20:59:57'),(4286,1603,40719,21,2,4080,'App\\Models\\Receipt',4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',5667.77,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 20:59:48','2022-05-08 20:59:48'),(4287,1603,40719,21,2,4081,'App\\Models\\Receipt',4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',30513.74,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 20:59:39','2022-05-08 20:59:39'),(4288,1603,40719,21,2,4082,'App\\Models\\Receipt',4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',3148.76,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 20:59:30','2022-05-08 20:59:30'),(4289,1603,40719,21,2,4083,'App\\Models\\Receipt',4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',52647.28,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 20:59:21','2022-05-08 20:59:21'),(4290,1603,40719,21,2,4084,'App\\Models\\Receipt',4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',19115.07,NULL,NULL,1,'2022-05-08 19:12:37','2022-05-08 20:59:13','2022-05-08 20:59:13'),(4291,1603,40719,21,2,4085,'App\\Models\\Receipt',4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',4198.35,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:59:04','2022-05-08 20:59:04'),(4292,1603,40719,21,2,4086,'App\\Models\\Receipt',4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',22585.64,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:58:55','2022-05-08 20:58:55'),(4293,1603,40719,21,2,4087,'App\\Models\\Receipt',4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',4198.35,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:58:45','2022-05-08 20:58:45'),(4294,1603,40719,21,2,4088,'App\\Models\\Receipt',4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',20043.75,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:58:35','2022-05-08 20:58:35'),(4295,1603,40719,21,2,4089,'App\\Models\\Receipt',4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',4198.35,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:58:26','2022-05-08 20:58:26'),(4296,1603,40719,21,2,4090,'App\\Models\\Receipt',4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',29720.10,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:58:17','2022-05-08 20:58:17'),(4297,1603,40719,21,2,4091,'App\\Models\\Receipt',4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',4198.35,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:58:07','2022-05-08 20:58:07'),(4298,1603,40719,21,2,4092,'App\\Models\\Receipt',4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',3883.47,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:57:56','2022-05-08 20:57:56');
INSERT INTO `balance_libro` VALUES (4299,1603,40719,21,2,4093,'App\\Models\\Receipt',4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',20497.27,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:57:48','2022-05-08 20:57:48'),(4300,1603,40719,21,2,4094,'App\\Models\\Receipt',4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',4723.14,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:57:41','2022-05-08 20:57:41'),(4301,1603,40719,21,2,4095,'App\\Models\\Receipt',4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',13754.20,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:57:32','2022-05-08 20:57:32'),(4302,1603,40719,21,2,4096,'App\\Models\\Receipt',4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',5772.72,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:57:21','2022-05-08 20:57:21'),(4303,1603,40719,21,2,4097,'App\\Models\\Receipt',4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',3075.29,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:57:13','2022-05-08 20:57:13'),(4304,1603,40719,21,2,4098,'App\\Models\\Receipt',4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',17303.71,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:57:05','2022-05-08 20:57:05'),(4305,1603,40719,21,2,4099,'App\\Models\\Receipt',4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',2623.97,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:56:56','2022-05-08 20:56:56'),(4306,1603,40719,21,2,4100,'App\\Models\\Receipt',4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',3673.55,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:56:47','2022-05-08 20:56:47'),(4307,1603,40719,21,2,4101,'App\\Models\\Receipt',4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',18982.94,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:56:39','2022-05-08 20:56:39'),(4308,1603,40719,21,2,4102,'App\\Models\\Receipt',4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',114709.64,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:56:30','2022-05-08 20:56:30'),(4309,1603,40719,21,2,4103,'App\\Models\\Receipt',4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',4723.14,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:56:22','2022-05-08 20:56:22'),(4310,1603,40719,21,2,4104,'App\\Models\\Receipt',4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',3148.76,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:56:11','2022-05-08 20:56:11'),(4311,1603,40719,21,2,4105,'App\\Models\\Receipt',4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',18800.45,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:56:02','2022-05-08 20:56:02'),(4312,1603,40719,21,2,4106,'App\\Models\\Receipt',4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',39612.56,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:55:50','2022-05-08 20:55:50'),(4313,1603,40719,21,2,4107,'App\\Models\\Receipt',4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',4723.14,NULL,NULL,1,'2022-05-08 19:12:38','2022-05-08 20:55:40','2022-05-08 20:55:40'),(4314,1603,40719,21,2,4108,'App\\Models\\Receipt',4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',17515.27,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:55:30','2022-05-08 20:55:30'),(4315,1603,40719,21,2,4109,'App\\Models\\Receipt',4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',137078.01,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:55:21','2022-05-08 20:55:21'),(4316,1603,40719,21,2,4110,'App\\Models\\Receipt',4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',16268.60,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:55:11','2022-05-08 20:55:11'),(4317,1603,40719,21,2,4111,'App\\Models\\Receipt',4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',19552.64,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:55:02','2022-05-08 20:55:02');
INSERT INTO `balance_libro` VALUES (4318,1603,40719,21,2,4112,'App\\Models\\Receipt',4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',28848.62,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:54:54','2022-05-08 20:54:54'),(4319,1603,40719,21,2,4113,'App\\Models\\Receipt',4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',4198.35,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:54:43','2022-05-08 20:54:43'),(4320,1603,40719,21,2,4114,'App\\Models\\Receipt',4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',17672.02,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:54:34','2022-05-08 20:54:34'),(4321,1603,40719,21,2,4115,'App\\Models\\Receipt',4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',33122.65,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:54:24','2022-05-08 20:54:24'),(4322,1603,40719,21,2,4116,'App\\Models\\Receipt',4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',21699.80,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:54:14','2022-05-08 20:54:14'),(4323,1603,40719,21,2,4117,'App\\Models\\Receipt',4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',55699.49,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:54:05','2022-05-08 20:54:05'),(4324,1603,40719,21,2,4118,'App\\Models\\Receipt',4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',12605.54,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:53:46','2022-05-08 20:53:46'),(4325,1603,40719,21,2,4119,'App\\Models\\Receipt',4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',5562.82,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:53:38','2022-05-08 20:53:38'),(4326,1603,40719,21,2,4120,'App\\Models\\Receipt',4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',4723.14,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:53:29','2022-05-08 20:53:29'),(4327,1603,40719,21,2,4121,'App\\Models\\Receipt',4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',19637.98,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:53:21','2022-05-08 20:53:21'),(4328,1603,40719,21,2,4122,'App\\Models\\Receipt',4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',7163.44,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:53:12','2022-05-08 20:53:12'),(4329,1603,40719,21,2,4123,'App\\Models\\Receipt',4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',15984.13,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:53:03','2022-05-08 20:53:03'),(4330,1603,40719,21,2,4124,'App\\Models\\Receipt',4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4198.35,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:52:54','2022-05-08 20:52:54'),(4331,1603,40719,21,2,4125,'App\\Models\\Receipt',4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4534.22,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:52:45','2022-05-08 20:52:45'),(4332,1603,40719,21,2,4126,'App\\Models\\Receipt',4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',4198.35,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:52:37','2022-05-08 20:52:37'),(4333,1603,40719,21,2,4127,'App\\Models\\Receipt',4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',111398.99,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:52:26','2022-05-08 20:52:26'),(4334,1603,40719,21,2,4128,'App\\Models\\Receipt',4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',6523.18,NULL,NULL,1,'2022-05-08 19:12:39','2022-05-08 20:52:16','2022-05-08 20:52:16'),(4335,1603,40719,21,2,4129,'App\\Models\\Receipt',4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',4198.35,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:52:08','2022-05-08 20:52:08'),(4336,1603,40719,21,2,4130,'App\\Models\\Receipt',4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',15919.07,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:52:00','2022-05-08 20:52:00');
INSERT INTO `balance_libro` VALUES (4337,1603,40719,21,2,4131,'App\\Models\\Receipt',4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',839.67,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:51:52','2022-05-08 20:51:52'),(4338,1603,40719,21,2,4132,'App\\Models\\Receipt',4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1133.55,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:51:42','2022-05-08 20:51:42'),(4339,1603,40719,21,2,4133,'App\\Models\\Receipt',4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1994.22,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:51:33','2022-05-08 20:51:33'),(4340,1603,40719,21,2,4134,'App\\Models\\Receipt',4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',4198.35,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:51:22','2022-05-08 20:51:22'),(4341,1603,40719,21,2,4135,'App\\Models\\Receipt',4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',13572.21,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:51:13','2022-05-08 20:51:13'),(4342,1603,40719,21,2,4136,'App\\Models\\Receipt',4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',5247.93,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:51:04','2022-05-08 20:51:04'),(4343,1603,40719,21,2,4137,'App\\Models\\Receipt',4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',4198.35,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:50:56','2022-05-08 20:50:56'),(4344,1603,40719,21,2,4138,'App\\Models\\Receipt',4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',14778.71,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:50:47','2022-05-08 20:50:47'),(4345,1603,40719,21,2,4139,'App\\Models\\Receipt',4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',20915.54,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:50:39','2022-05-08 20:50:39'),(4346,1603,40719,21,2,4140,'App\\Models\\Receipt',4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2099.17,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:50:30','2022-05-08 20:50:30'),(4347,1603,40719,21,2,4141,'App\\Models\\Receipt',4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',18645.51,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:50:22','2022-05-08 20:50:22'),(4348,1603,40719,21,2,4142,'App\\Models\\Receipt',4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',38595.29,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:50:13','2022-05-08 20:50:13'),(4349,1603,40719,21,2,4143,'App\\Models\\Receipt',4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',32297.32,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:50:04','2022-05-08 20:50:04'),(4350,1603,40719,21,2,4144,'App\\Models\\Receipt',4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',16251.14,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:49:56','2022-05-08 20:49:56'),(4351,1603,40719,21,2,4145,'App\\Models\\Receipt',4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1049.59,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:49:42','2022-05-08 20:49:42'),(4352,1603,40719,21,2,4146,'App\\Models\\Receipt',4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',8385.23,NULL,NULL,1,'2022-05-08 19:12:40','2022-05-08 20:49:31','2022-05-08 20:49:31'),(4353,1603,40719,21,3,4147,'App\\Models\\Receipt',4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3151.57,NULL,NULL,1,'2022-05-08 20:39:03','2022-05-08 20:39:03',NULL),(4354,1603,40719,21,3,4148,'App\\Models\\Receipt',4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',119051.90,NULL,NULL,1,'2022-05-08 20:39:03','2022-05-08 20:39:03',NULL),(4355,1603,40719,21,3,4149,'App\\Models\\Receipt',4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',2250.00,NULL,NULL,1,'2022-05-08 20:39:03','2022-05-08 20:39:03',NULL);
INSERT INTO `balance_libro` VALUES (4356,1603,40719,21,3,4150,'App\\Models\\Receipt',4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',7392.00,NULL,NULL,1,'2022-05-08 20:39:03','2022-05-08 20:39:03',NULL),(4357,1603,40719,21,3,4151,'App\\Models\\Receipt',4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',2354.50,NULL,NULL,1,'2022-05-08 20:39:03','2022-05-08 20:39:03',NULL),(4358,1603,40719,21,3,4152,'App\\Models\\Receipt',4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',4709.01,NULL,NULL,1,'2022-05-08 20:39:04','2022-05-08 20:39:04',NULL),(4359,1603,40719,21,3,4153,'App\\Models\\Receipt',4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',581.01,NULL,NULL,1,'2022-05-08 20:39:04','2022-05-08 20:39:04',NULL),(4360,1603,40719,21,3,4154,'App\\Models\\Receipt',4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',1499.99,NULL,NULL,1,'2022-05-08 20:39:04','2022-05-08 20:39:04',NULL),(4361,1603,40719,21,3,4155,'App\\Models\\Receipt',4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',291.05,NULL,NULL,1,'2022-05-08 20:39:04','2022-05-08 20:39:04',NULL),(4362,1603,40719,21,3,4156,'App\\Models\\Receipt',4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',6559.00,NULL,NULL,1,'2022-05-08 20:39:04','2022-05-08 20:39:04',NULL),(4363,1603,40719,21,3,4157,'App\\Models\\Receipt',4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',21885.87,NULL,NULL,1,'2022-05-08 20:39:04','2022-05-08 20:39:04',NULL),(4364,1603,40719,21,3,4158,'App\\Models\\Receipt',4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2614.13,NULL,NULL,1,'2022-05-08 20:39:04','2022-05-08 20:39:04',NULL),(4365,1603,40719,21,3,4159,'App\\Models\\Receipt',4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',25843.79,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4366,1603,40719,21,3,4160,'App\\Models\\Receipt',4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',15853.79,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4367,1603,40719,21,3,4161,'App\\Models\\Receipt',4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',27359.88,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4368,1603,40719,21,3,4162,'App\\Models\\Receipt',4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',100324.30,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4369,1603,40719,21,3,4163,'App\\Models\\Receipt',4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1771.00,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4370,1603,40719,21,3,4164,'App\\Models\\Receipt',4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',133.10,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4371,1603,40719,21,3,4165,'App\\Models\\Receipt',4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',75995.70,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4372,1603,40719,21,3,4166,'App\\Models\\Receipt',4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',6230.00,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4373,1603,40719,21,3,4167,'App\\Models\\Receipt',4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4307.01,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4374,1603,40719,21,3,4168,'App\\Models\\Receipt',4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4502.99,NULL,NULL,1,'2022-05-08 20:39:05','2022-05-08 20:39:05',NULL),(4375,1603,40719,21,3,4169,'App\\Models\\Receipt',4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4050.00,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4376,1603,40719,21,3,4170,'App\\Models\\Receipt',4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',3000.00,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL);
INSERT INTO `balance_libro` VALUES (4377,1603,40719,21,3,4171,'App\\Models\\Receipt',4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',86540.41,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4378,1603,40719,21,3,4172,'App\\Models\\Receipt',4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',3650.03,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4379,1603,40719,21,3,4173,'App\\Models\\Receipt',4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',17056.34,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4380,1603,40719,21,3,4174,'App\\Models\\Receipt',4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',460.01,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4381,1603,40719,21,3,4175,'App\\Models\\Receipt',4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1996.56,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4382,1603,40719,21,3,4176,'App\\Models\\Receipt',4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',10447.68,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4383,1603,40719,21,3,4177,'App\\Models\\Receipt',4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',16457.65,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4384,1603,40719,21,3,4178,'App\\Models\\Receipt',4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',4307.01,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4385,1603,40719,21,3,4179,'App\\Models\\Receipt',4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',33890.14,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4386,1603,40719,21,3,4180,'App\\Models\\Receipt',4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',9045.00,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4387,1603,40719,21,3,4181,'App\\Models\\Receipt',4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',3561.40,NULL,NULL,1,'2022-05-08 20:39:06','2022-05-08 20:39:06',NULL),(4388,1603,40719,21,3,4182,'App\\Models\\Receipt',4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',13178.28,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4389,1603,40719,21,3,4183,'App\\Models\\Receipt',4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',3619.00,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4390,1603,40719,21,3,4184,'App\\Models\\Receipt',4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',25751.73,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4391,1603,40719,21,3,4185,'App\\Models\\Receipt',4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',237300.00,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4392,1603,40719,21,3,4186,'App\\Models\\Receipt',4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',10332.00,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4393,1603,40719,21,3,4187,'App\\Models\\Receipt',4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',3608.91,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4394,1603,40719,21,3,4188,'App\\Models\\Receipt',4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',999.99,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4395,1603,40719,21,3,4189,'App\\Models\\Receipt',4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',6559.00,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4396,1603,40719,21,3,4190,'App\\Models\\Receipt',4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',17013.64,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4397,1603,40719,21,3,4191,'App\\Models\\Receipt',4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',24752.53,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL);
INSERT INTO `balance_libro` VALUES (4398,1603,40719,21,3,4192,'App\\Models\\Receipt',4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',999.99,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4399,1603,40719,21,3,4193,'App\\Models\\Receipt',4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',10158.82,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4400,1603,40719,21,3,4194,'App\\Models\\Receipt',4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',6244.00,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4401,1603,40719,21,3,4195,'App\\Models\\Receipt',4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',208.02,NULL,NULL,1,'2022-05-08 20:39:07','2022-05-08 20:39:07',NULL),(4402,1603,40719,21,3,4196,'App\\Models\\Receipt',4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',8647.72,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4403,1603,40719,21,3,4197,'App\\Models\\Receipt',4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',3356.20,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4404,1603,40719,21,3,4198,'App\\Models\\Receipt',4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',999.99,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4405,1603,40719,21,3,4199,'App\\Models\\Receipt',4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',108327.67,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4406,1603,40719,21,3,4200,'App\\Models\\Receipt',4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',11007.99,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4407,1603,40719,21,3,4201,'App\\Models\\Receipt',4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',3432.97,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-15 21:06:09','2022-05-15 21:06:09'),(4408,1603,40719,21,3,4202,'App\\Models\\Receipt',4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',8644.00,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4409,1603,40719,21,3,4203,'App\\Models\\Receipt',4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',38450.00,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 21:40:54','2022-05-08 21:40:54'),(4410,1603,40719,21,3,4204,'App\\Models\\Receipt',4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',2000.00,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4411,1603,40719,21,3,4205,'App\\Models\\Receipt',4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',6559.00,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4412,1603,40719,21,3,4206,'App\\Models\\Receipt',4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',7650.00,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4413,1603,40719,21,3,4207,'App\\Models\\Receipt',4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',5550.71,NULL,NULL,1,'2022-05-08 20:39:08','2022-05-08 20:39:08',NULL),(4414,1603,40719,21,3,4208,'App\\Models\\Receipt',4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',2644.29,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4415,1603,40719,21,3,4209,'App\\Models\\Receipt',4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',37512.01,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4416,1603,40719,21,3,4210,'App\\Models\\Receipt',4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',602.00,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4417,1603,40719,21,3,4211,'App\\Models\\Receipt',4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',27835.86,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4418,1603,40719,21,3,4212,'App\\Models\\Receipt',4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',34151.44,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL);
INSERT INTO `balance_libro` VALUES (4419,1603,40719,21,3,4213,'App\\Models\\Receipt',4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',459.78,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4420,1603,40719,21,3,4214,'App\\Models\\Receipt',4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',9134.46,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4421,1603,40719,21,3,4215,'App\\Models\\Receipt',4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1260.00,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4422,1603,40719,21,3,4216,'App\\Models\\Receipt',4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',5019.01,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4423,1603,40719,21,3,4217,'App\\Models\\Receipt',4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',27971.83,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4424,1603,40719,21,3,4218,'App\\Models\\Receipt',4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',6559.00,NULL,NULL,1,'2022-05-08 20:39:09','2022-05-08 20:39:09',NULL),(4425,1603,40719,21,3,4219,'App\\Models\\Receipt',4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',773.19,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4426,1603,40719,21,3,4220,'App\\Models\\Receipt',4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',16007.72,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4427,1603,40719,21,3,4221,'App\\Models\\Receipt',4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',2847.06,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4428,1603,40719,21,3,4222,'App\\Models\\Receipt',4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',4600.03,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4429,1603,40719,21,3,4223,'App\\Models\\Receipt',4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',60908.85,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4430,1603,40719,21,3,4224,'App\\Models\\Receipt',4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1500.00,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4431,1603,40719,21,3,4225,'App\\Models\\Receipt',4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',13334.83,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4432,1603,40719,21,3,4226,'App\\Models\\Receipt',4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',32563.49,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4433,1603,40719,21,3,4227,'App\\Models\\Receipt',4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',17976.66,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4434,1603,40719,21,3,4228,'App\\Models\\Receipt',4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',430099.98,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4435,1603,40719,21,3,4229,'App\\Models\\Receipt',4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',34915.32,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 22:05:02','2022-05-08 22:05:02'),(4436,1603,40719,21,3,4230,'App\\Models\\Receipt',4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',999.99,NULL,NULL,1,'2022-05-08 20:39:10','2022-05-08 20:39:10',NULL),(4437,1603,40719,21,3,4231,'App\\Models\\Receipt',4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',153728.64,NULL,NULL,1,'2022-05-08 20:39:11','2022-05-08 22:06:48','2022-05-08 22:06:48'),(4438,1603,40719,21,3,4232,'App\\Models\\Receipt',4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',756.00,NULL,NULL,1,'2022-05-08 20:39:11','2022-05-08 20:39:11',NULL),(4439,1603,40719,21,3,4233,'App\\Models\\Receipt',4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1999.98,NULL,NULL,1,'2022-05-08 20:39:11','2022-05-08 20:39:11',NULL);
INSERT INTO `balance_libro` VALUES (4440,1603,40719,21,3,4234,'App\\Models\\Receipt',4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3307.70,NULL,NULL,1,'2022-05-08 20:39:11','2022-05-08 20:39:11',NULL),(4441,1603,40719,21,3,4235,'App\\Models\\Receipt',4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',22110.73,NULL,NULL,1,'2022-05-08 20:39:11','2022-05-08 20:39:11',NULL),(4442,1603,40719,21,3,4236,'App\\Models\\Receipt',4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1759.98,NULL,NULL,1,'2022-05-08 20:39:11','2022-05-08 20:39:11',NULL),(4443,1603,40719,21,2,4237,'App\\Models\\Receipt',4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1500.00,NULL,NULL,1,'2022-05-08 21:10:03','2022-05-08 21:10:03',NULL),(4444,1603,40719,21,2,4238,'App\\Models\\Receipt',4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',4165.00,NULL,NULL,1,'2022-05-08 21:10:03','2022-05-08 21:10:03',NULL),(4445,1603,40719,21,2,4239,'App\\Models\\Receipt',4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1740.00,NULL,NULL,1,'2022-05-08 21:10:03','2022-05-08 21:10:03',NULL),(4446,1603,40719,21,2,4240,'App\\Models\\Receipt',4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',28215.06,NULL,NULL,1,'2022-05-08 21:10:03','2022-05-08 21:10:03',NULL),(4447,1603,40719,21,2,4241,'App\\Models\\Receipt',4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',14232.00,NULL,NULL,1,'2022-05-08 21:10:03','2022-05-08 21:10:03',NULL),(4448,1603,40719,21,2,4242,'App\\Models\\Receipt',4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',6500.00,NULL,NULL,1,'2022-05-08 21:10:03','2022-05-08 21:10:03',NULL),(4449,1603,40719,21,2,4243,'App\\Models\\Receipt',4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',4500.00,NULL,NULL,1,'2022-05-08 21:10:03','2022-05-08 21:10:03',NULL),(4450,1603,40719,21,2,4244,'App\\Models\\Receipt',4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',23832.49,NULL,NULL,1,'2022-05-08 21:10:03','2022-05-08 21:10:03',NULL),(4451,1603,40719,21,2,4245,'App\\Models\\Receipt',4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',42323.94,NULL,NULL,1,'2022-05-08 21:10:04','2022-05-08 21:10:04',NULL),(4452,1603,40719,21,2,4246,'App\\Models\\Receipt',4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',22059.99,NULL,NULL,1,'2022-05-08 21:10:04','2022-05-08 21:10:04',NULL),(4453,1603,40719,21,2,4247,'App\\Models\\Receipt',4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',7875.01,NULL,NULL,1,'2022-05-08 21:10:04','2022-05-08 21:10:04',NULL),(4454,1603,40719,21,2,4248,'App\\Models\\Receipt',4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',29596.00,NULL,NULL,1,'2022-05-08 21:10:04','2022-05-08 21:10:04',NULL),(4455,1603,40719,21,2,4249,'App\\Models\\Receipt',4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',4500.00,NULL,NULL,1,'2022-05-08 21:10:04','2022-05-08 21:10:04',NULL),(4456,1603,40719,21,2,4250,'App\\Models\\Receipt',4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',17264.00,NULL,NULL,1,'2022-05-08 21:10:04','2022-05-08 21:10:04',NULL),(4457,1603,40719,21,2,4251,'App\\Models\\Receipt',4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',19472.00,NULL,NULL,1,'2022-05-08 21:10:04','2022-05-08 21:10:04',NULL),(4458,1603,40719,21,2,4252,'App\\Models\\Receipt',4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',115898.24,NULL,NULL,1,'2022-05-08 21:10:04','2022-05-08 21:10:04',NULL),(4459,1603,40719,21,2,4253,'App\\Models\\Receipt',4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1000.00,NULL,NULL,1,'2022-05-08 21:10:04','2022-05-08 21:10:04',NULL),(4460,1603,40719,21,2,4254,'App\\Models\\Receipt',4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',16211.08,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL);
INSERT INTO `balance_libro` VALUES (4461,1603,40719,21,2,4255,'App\\Models\\Receipt',4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',4000.01,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4462,1603,40719,21,2,4256,'App\\Models\\Receipt',4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',5000.00,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4463,1603,40719,21,2,4257,'App\\Models\\Receipt',4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',27291.93,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4464,1603,40719,21,2,4258,'App\\Models\\Receipt',4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',12292.00,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4465,1603,40719,21,2,4259,'App\\Models\\Receipt',4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',27310.00,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4466,1603,40719,21,2,4260,'App\\Models\\Receipt',4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',21890.13,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4467,1603,40719,21,2,4261,'App\\Models\\Receipt',4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',16852.00,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4468,1603,40719,21,2,4262,'App\\Models\\Receipt',4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',12200.01,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4469,1603,40719,21,2,4263,'App\\Models\\Receipt',4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',8339.68,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4470,1603,40719,21,2,4264,'App\\Models\\Receipt',4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',5349.99,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4471,1603,40719,21,2,4265,'App\\Models\\Receipt',4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',17835.00,NULL,NULL,1,'2022-05-08 21:10:05','2022-05-08 21:10:05',NULL),(4472,1603,40719,21,2,4266,'App\\Models\\Receipt',4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',6100.00,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4473,1603,40719,21,2,4267,'App\\Models\\Receipt',4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',17847.00,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4474,1603,40719,21,2,4268,'App\\Models\\Receipt',4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',16551.00,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4475,1603,40719,21,2,4269,'App\\Models\\Receipt',4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',46189.14,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4476,1603,40719,21,2,4270,'App\\Models\\Receipt',4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4000.01,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4477,1603,40719,21,2,4271,'App\\Models\\Receipt',4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',17854.00,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4478,1603,40719,21,2,4272,'App\\Models\\Receipt',4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',18279.00,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4479,1603,40719,21,2,4273,'App\\Models\\Receipt',4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',18000.00,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4480,1603,40719,21,2,4274,'App\\Models\\Receipt',4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',16424.47,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4481,1603,40719,21,2,4275,'App\\Models\\Receipt',4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',20081.00,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL);
INSERT INTO `balance_libro` VALUES (4482,1603,40719,21,2,4276,'App\\Models\\Receipt',4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',92700.12,NULL,NULL,1,'2022-05-08 21:10:06','2022-05-08 21:10:06',NULL),(4483,1603,40719,21,2,4277,'App\\Models\\Receipt',4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',18522.51,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4484,1603,40719,21,2,4278,'App\\Models\\Receipt',4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',85829.70,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4485,1603,40719,21,2,4279,'App\\Models\\Receipt',4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',16000.00,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4486,1603,40719,21,2,4280,'App\\Models\\Receipt',4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',4500.00,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4487,1603,40719,21,2,4281,'App\\Models\\Receipt',4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',18952.00,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4488,1603,40719,21,2,4282,'App\\Models\\Receipt',4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',4000.01,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4489,1603,40719,21,2,4283,'App\\Models\\Receipt',4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',2000.00,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4490,1603,40719,21,2,4284,'App\\Models\\Receipt',4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1500.00,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4491,1603,40719,21,2,4285,'App\\Models\\Receipt',4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',3000.00,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4492,1603,40719,21,2,4286,'App\\Models\\Receipt',4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',2285.00,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4493,1603,40719,21,2,4287,'App\\Models\\Receipt',4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',5400.00,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4494,1603,40719,21,2,4288,'App\\Models\\Receipt',4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',12248.91,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4495,1603,40719,21,2,4289,'App\\Models\\Receipt',4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',10682.55,NULL,NULL,1,'2022-05-08 21:10:07','2022-05-08 21:10:07',NULL),(4496,1603,40719,21,2,4290,'App\\Models\\Receipt',4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',4000.01,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4497,1603,40719,21,2,4291,'App\\Models\\Receipt',4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',13732.83,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4498,1603,40719,21,2,4292,'App\\Models\\Receipt',4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',23146.01,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4499,1603,40719,21,2,4293,'App\\Models\\Receipt',4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',5400.00,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4500,1603,40719,21,2,4294,'App\\Models\\Receipt',4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',29072.15,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4501,1603,40719,21,2,4295,'App\\Models\\Receipt',4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',3000.00,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4502,1603,40719,21,2,4296,'App\\Models\\Receipt',4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',50160.01,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL);
INSERT INTO `balance_libro` VALUES (4503,1603,40719,21,2,4297,'App\\Models\\Receipt',4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',18212.00,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4504,1603,40719,21,2,4298,'App\\Models\\Receipt',4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',4000.01,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4505,1603,40719,21,2,4299,'App\\Models\\Receipt',4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',21518.60,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4506,1603,40719,21,2,4300,'App\\Models\\Receipt',4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',4000.01,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4507,1603,40719,21,2,4301,'App\\Models\\Receipt',4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',19096.80,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4508,1603,40719,21,2,4302,'App\\Models\\Receipt',4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',4000.01,NULL,NULL,1,'2022-05-08 21:10:08','2022-05-08 21:10:08',NULL),(4509,1603,40719,21,2,4303,'App\\Models\\Receipt',4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',28316.00,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4510,1603,40719,21,2,4304,'App\\Models\\Receipt',4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',4000.01,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4511,1603,40719,21,2,4305,'App\\Models\\Receipt',4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',3700.00,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4512,1603,40719,21,2,4306,'App\\Models\\Receipt',4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',19528.89,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4513,1603,40719,21,2,4307,'App\\Models\\Receipt',4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',4500.00,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4514,1603,40719,21,2,4308,'App\\Models\\Receipt',4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',13104.40,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4515,1603,40719,21,2,4309,'App\\Models\\Receipt',4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',5499.99,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4516,1603,40719,21,2,4310,'App\\Models\\Receipt',4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',2930.00,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4517,1603,40719,21,2,4311,'App\\Models\\Receipt',4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',16486.21,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4518,1603,40719,21,2,4312,'App\\Models\\Receipt',4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',2500.01,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4519,1603,40719,21,2,4313,'App\\Models\\Receipt',4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',3500.00,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4520,1603,40719,21,2,4314,'App\\Models\\Receipt',4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',18086.11,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4521,1603,40719,21,2,4315,'App\\Models\\Receipt',4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',109290.29,NULL,NULL,1,'2022-05-08 21:10:09','2022-05-08 21:10:09',NULL),(4522,1603,40719,21,2,4316,'App\\Models\\Receipt',4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',4500.00,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4523,1603,40719,21,2,4317,'App\\Models\\Receipt',4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',3000.00,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL);
INSERT INTO `balance_libro` VALUES (4524,1603,40719,21,2,4318,'App\\Models\\Receipt',4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',17912.24,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4525,1603,40719,21,2,4319,'App\\Models\\Receipt',4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',37741.10,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4526,1603,40719,21,2,4320,'App\\Models\\Receipt',4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',4500.00,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4527,1603,40719,21,2,4321,'App\\Models\\Receipt',4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',16687.78,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4528,1603,40719,21,2,4322,'App\\Models\\Receipt',4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',130601.88,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4529,1603,40719,21,2,4323,'App\\Models\\Receipt',4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',15500.00,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4530,1603,40719,21,2,4324,'App\\Models\\Receipt',4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',18628.89,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4531,1603,40719,21,2,4325,'App\\Models\\Receipt',4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',27485.69,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4532,1603,40719,21,2,4326,'App\\Models\\Receipt',4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',4000.01,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4533,1603,40719,21,2,4327,'App\\Models\\Receipt',4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',16837.13,NULL,NULL,1,'2022-05-08 21:10:10','2022-05-08 21:10:10',NULL),(4534,1603,40719,21,2,4328,'App\\Models\\Receipt',4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',31557.80,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4535,1603,40719,21,2,4329,'App\\Models\\Receipt',4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',20674.62,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4536,1603,40719,21,2,4330,'App\\Models\\Receipt',4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',53068.02,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4537,1603,40719,21,2,4331,'App\\Models\\Receipt',4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',12010.00,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4538,1603,40719,21,2,4332,'App\\Models\\Receipt',4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',5300.01,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4539,1603,40719,21,2,4333,'App\\Models\\Receipt',4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',4500.00,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4540,1603,40719,21,2,4334,'App\\Models\\Receipt',4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',18710.21,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4541,1603,40719,21,2,4335,'App\\Models\\Receipt',4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',6825.01,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4542,1603,40719,21,2,4336,'App\\Models\\Receipt',4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',15228.98,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4543,1603,40719,21,2,4337,'App\\Models\\Receipt',4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4000.01,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4544,1603,40719,21,2,4338,'App\\Models\\Receipt',4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4320.00,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL);
INSERT INTO `balance_libro` VALUES (4545,1603,40719,21,2,4339,'App\\Models\\Receipt',4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',4000.01,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4546,1603,40719,21,2,4340,'App\\Models\\Receipt',4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',106136.05,NULL,NULL,1,'2022-05-08 21:10:11','2022-05-08 21:10:11',NULL),(4547,1603,40719,21,2,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',6215.00,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4548,1603,40719,21,2,4342,'App\\Models\\Receipt',4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',4000.01,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4549,1603,40719,21,2,4343,'App\\Models\\Receipt',4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',15166.99,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4550,1603,40719,21,2,4344,'App\\Models\\Receipt',4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',800.00,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4551,1603,40719,21,2,4345,'App\\Models\\Receipt',4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1080.00,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4552,1603,40719,21,2,4346,'App\\Models\\Receipt',4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1900.00,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4553,1603,40719,21,2,4347,'App\\Models\\Receipt',4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',4000.01,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4554,1603,40719,21,2,4348,'App\\Models\\Receipt',4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',12931.00,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4555,1603,40719,21,2,4349,'App\\Models\\Receipt',4349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',5000.00,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4556,1603,40719,21,2,4350,'App\\Models\\Receipt',4350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',4000.01,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4557,1603,40719,21,2,4351,'App\\Models\\Receipt',4351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',14080.50,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4558,1603,40719,21,2,4352,'App\\Models\\Receipt',4352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',19927.41,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4559,1603,40719,21,2,4353,'App\\Models\\Receipt',4353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2000.00,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4560,1603,40719,21,2,4354,'App\\Models\\Receipt',4354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',17764.62,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4561,1603,40719,21,2,4355,'App\\Models\\Receipt',4355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',36771.89,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4562,1603,40719,21,2,4356,'App\\Models\\Receipt',4356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',30771.46,NULL,NULL,1,'2022-05-08 21:10:12','2022-05-08 21:10:12',NULL),(4563,1603,40719,21,2,4357,'App\\Models\\Receipt',4357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',15483.37,NULL,NULL,1,'2022-05-08 21:10:13','2022-05-08 21:10:13',NULL),(4564,1603,40719,21,2,4358,'App\\Models\\Receipt',4358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1000.00,NULL,NULL,1,'2022-05-08 21:10:13','2022-05-08 21:10:13',NULL),(4565,1603,40719,21,2,4359,'App\\Models\\Receipt',4359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',7989.07,NULL,NULL,1,'2022-05-08 21:10:13','2022-05-08 21:10:13',NULL);
INSERT INTO `balance_libro` VALUES (4566,1603,40719,20,15,582,'App\\Models\\PeriodLiquidation',NULL,582,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',386393.72,NULL,NULL,1,'2022-05-08 21:12:49','2022-05-08 21:18:57','2022-05-08 21:18:57'),(4567,1603,40719,20,7,4360,'App\\Models\\Receipt',4360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5067.97,NULL,NULL,1,'2022-05-08 21:20:15','2022-05-08 21:20:15',NULL),(4568,1603,40719,20,7,4361,'App\\Models\\Receipt',4361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',6839.85,NULL,NULL,1,'2022-05-08 21:21:13','2022-05-08 21:21:13',NULL),(4569,1603,40719,20,7,4362,'App\\Models\\Receipt',4362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3282.50,NULL,NULL,1,'2022-05-08 21:23:05','2022-05-08 21:23:05',NULL),(4570,1603,40719,20,7,4363,'App\\Models\\Receipt',4363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1159.18,NULL,NULL,1,'2022-05-08 21:28:17','2022-05-08 21:28:17',NULL),(4571,1603,40719,20,16,843,'App\\Models\\PeriodLiquidation',NULL,843,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',28535.92,NULL,NULL,1,'2022-05-08 21:29:37','2022-05-08 21:29:37',NULL),(4572,1603,40719,20,15,842,'App\\Models\\PeriodLiquidation',NULL,842,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',386393.72,NULL,NULL,1,'2022-05-08 21:31:32','2022-05-08 21:31:32',NULL),(4573,1603,40719,21,3,4203,'App\\Models\\Receipt',4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',38450.00,NULL,NULL,1,'2022-05-08 21:40:54','2022-05-08 21:40:54',NULL),(4574,1603,40719,21,3,4229,'App\\Models\\Receipt',4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',35766.91,NULL,NULL,1,'2022-05-08 22:05:02','2022-05-08 22:05:02',NULL),(4575,1603,40719,21,3,4231,'App\\Models\\Receipt',4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',157478.12,NULL,NULL,1,'2022-05-08 22:06:48','2022-05-08 22:06:48',NULL),(4576,1603,40719,21,7,4364,'App\\Models\\Receipt',4364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',259.21,NULL,NULL,1,'2022-05-08 22:18:28','2022-05-08 22:18:28',NULL),(4577,1603,40719,21,7,4365,'App\\Models\\Receipt',4365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',3749.48,NULL,NULL,1,'2022-05-09 20:05:33','2022-05-09 20:14:46','2022-05-09 20:14:46'),(4578,1603,40719,21,7,4366,'App\\Models\\Receipt',4366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',851.59,NULL,NULL,1,'2022-05-09 20:06:09','2022-05-09 20:13:07','2022-05-09 20:13:07'),(4579,1603,40719,21,15,858,'App\\Models\\PeriodLiquidation',NULL,858,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',398998.29,NULL,NULL,1,'2022-05-11 21:05:51','2022-05-15 20:45:34','2022-05-15 20:45:34'),(4580,1603,40719,21,7,4367,'App\\Models\\Receipt',4367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',7486.08,NULL,NULL,1,'2022-05-15 20:46:58','2022-05-15 20:46:58',NULL),(4581,1603,40719,21,7,4368,'App\\Models\\Receipt',4368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',8873.07,NULL,NULL,1,'2022-05-15 20:48:27','2022-05-15 20:48:27',NULL),(4582,1603,40719,21,7,4369,'App\\Models\\Receipt',4369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',860.26,NULL,NULL,1,'2022-05-15 20:51:35','2022-05-15 20:51:35',NULL),(4583,1603,40719,21,7,4370,'App\\Models\\Receipt',4370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',54.00,NULL,NULL,1,'2022-05-15 20:52:08','2022-05-15 20:52:08',NULL),(4584,1603,40719,21,7,4371,'App\\Models\\Receipt',4371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1021.63,NULL,NULL,1,'2022-05-15 20:53:20','2022-05-15 20:53:20',NULL),(4585,1603,40719,21,7,4372,'App\\Models\\Receipt',4372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',55.08,NULL,NULL,1,'2022-05-15 20:53:53','2022-05-15 20:53:53',NULL);
INSERT INTO `balance_libro` VALUES (4586,1603,40719,21,7,4373,'App\\Models\\Receipt',4373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',129.31,NULL,NULL,1,'2022-05-15 20:54:39','2022-05-15 20:54:39',NULL),(4587,1603,40719,21,7,4374,'App\\Models\\Receipt',4374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',152.29,NULL,NULL,1,'2022-05-15 20:55:07','2022-05-15 20:55:07',NULL),(4588,1603,40719,21,7,4375,'App\\Models\\Receipt',4375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',307.71,NULL,NULL,1,'2022-05-15 20:55:35','2022-05-15 20:55:35',NULL),(4589,1603,40719,21,7,4376,'App\\Models\\Receipt',4376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',195.29,NULL,NULL,1,'2022-05-15 20:56:12','2022-05-15 20:56:12',NULL),(4590,1603,40719,21,3,4201,'App\\Models\\Receipt',4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',3352.47,NULL,NULL,1,'2022-05-15 21:06:09','2022-05-15 21:06:09',NULL),(4591,1603,40719,21,16,881,'App\\Models\\PeriodLiquidation',NULL,881,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',31526.36,NULL,NULL,1,'2022-05-15 21:07:16','2024-03-11 00:23:01','2024-03-11 00:23:01'),(4592,1603,40719,21,15,880,'App\\Models\\PeriodLiquidation',NULL,880,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',396735.38,NULL,NULL,1,'2022-05-15 21:08:01','2022-06-17 14:44:00','2022-06-17 14:44:00'),(4593,1603,40719,22,2,4377,'App\\Models\\Receipt',4377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1600.01,NULL,NULL,1,'2022-06-13 00:16:24','2022-06-13 00:16:24',NULL),(4594,1603,40719,22,2,4378,'App\\Models\\Receipt',4378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',8797.55,NULL,NULL,1,'2022-06-13 00:16:24','2022-06-13 00:16:24',NULL),(4595,1603,40719,22,2,4379,'App\\Models\\Receipt',4379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',6750.00,NULL,NULL,1,'2022-06-13 00:16:24','2022-06-13 00:16:24',NULL),(4596,1603,40719,22,2,4380,'App\\Models\\Receipt',4380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',19579.20,NULL,NULL,1,'2022-06-13 00:16:24','2022-06-13 00:16:24',NULL),(4597,1603,40719,22,2,4381,'App\\Models\\Receipt',4381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',19708.07,NULL,NULL,1,'2022-06-13 00:16:24','2022-06-13 00:16:24',NULL),(4598,1603,40719,22,2,4382,'App\\Models\\Receipt',4382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',21463.44,NULL,NULL,1,'2022-06-13 00:16:24','2022-06-13 00:16:24',NULL),(4599,1603,40719,22,2,4383,'App\\Models\\Receipt',4383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',4090.02,NULL,NULL,1,'2022-06-13 00:16:24','2022-06-13 00:16:24',NULL),(4600,1603,40719,22,2,4384,'App\\Models\\Receipt',4384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',18171.40,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4601,1603,40719,22,2,4385,'App\\Models\\Receipt',4385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',14500.00,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4602,1603,40719,22,2,4386,'App\\Models\\Receipt',4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',500.00,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4603,1603,40719,22,2,4387,'App\\Models\\Receipt',4387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',35229.98,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4604,1603,40719,22,2,4388,'App\\Models\\Receipt',4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',13458.62,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4605,1603,40719,22,2,4389,'App\\Models\\Receipt',4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',22494.07,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4606,1603,40719,22,2,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',20680.19,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL);
INSERT INTO `balance_libro` VALUES (4607,1603,40719,22,2,4391,'App\\Models\\Receipt',4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',6180.00,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4608,1603,40719,22,2,4392,'App\\Models\\Receipt',4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',14946.33,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4609,1603,40719,22,2,4393,'App\\Models\\Receipt',4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',25771.63,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4610,1603,40719,22,2,4394,'App\\Models\\Receipt',4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1784.86,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4611,1603,40719,22,2,4395,'App\\Models\\Receipt',4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',21667.62,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4612,1603,40719,22,2,4396,'App\\Models\\Receipt',4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',20536.99,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4613,1603,40719,22,2,4397,'App\\Models\\Receipt',4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',11500.00,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4614,1603,40719,22,2,4398,'App\\Models\\Receipt',4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',19527.10,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4615,1603,40719,22,2,4399,'App\\Models\\Receipt',4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1206.19,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4616,1603,40719,22,2,4400,'App\\Models\\Receipt',4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',14511.09,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4617,1603,40719,22,2,4401,'App\\Models\\Receipt',4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',4840.00,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4618,1603,40719,22,2,4402,'App\\Models\\Receipt',4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',12450.00,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4619,1603,40719,22,2,4403,'App\\Models\\Receipt',4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',870.00,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4620,1603,40719,22,2,4404,'App\\Models\\Receipt',4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',44460.69,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4621,1603,40719,22,2,4405,'App\\Models\\Receipt',4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',44460.69,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4622,1603,40719,22,2,4406,'App\\Models\\Receipt',4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',18311.99,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4623,1603,40719,22,2,4407,'App\\Models\\Receipt',4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',44460.69,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4624,1603,40719,22,2,4408,'App\\Models\\Receipt',4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',19467.54,NULL,NULL,1,'2022-06-13 00:16:25','2022-06-13 00:16:25',NULL),(4625,1603,40719,22,2,4409,'App\\Models\\Receipt',4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',2400.00,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4626,1603,40719,22,2,4410,'App\\Models\\Receipt',4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',12651.91,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4627,1603,40719,22,2,4411,'App\\Models\\Receipt',4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',2930.00,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL);
INSERT INTO `balance_libro` VALUES (4628,1603,40719,22,2,4412,'App\\Models\\Receipt',4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',6806.66,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4629,1603,40719,22,2,4413,'App\\Models\\Receipt',4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',44754.00,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4630,1603,40719,22,2,4414,'App\\Models\\Receipt',4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',16160.20,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4631,1603,40719,22,2,4415,'App\\Models\\Receipt',4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1830.00,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4632,1603,40719,22,2,4416,'App\\Models\\Receipt',4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',10100.00,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4633,1603,40719,22,2,4417,'App\\Models\\Receipt',4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',24550.43,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4634,1603,40719,22,2,4418,'App\\Models\\Receipt',4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',29337.76,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4635,1603,40719,22,2,4419,'App\\Models\\Receipt',4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',61677.80,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4636,1603,40719,22,2,4420,'App\\Models\\Receipt',4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',23532.69,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4637,1603,40719,22,2,4421,'App\\Models\\Receipt',4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',134985.08,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4638,1603,40719,22,2,4422,'App\\Models\\Receipt',4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',42736.22,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4639,1603,40719,22,2,4423,'App\\Models\\Receipt',4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',2600.00,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4640,1603,40719,22,2,4424,'App\\Models\\Receipt',4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',13300.20,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4641,1603,40719,22,2,4425,'App\\Models\\Receipt',4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',22320.37,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4642,1603,40719,22,2,4426,'App\\Models\\Receipt',4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',48322.98,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4643,1603,40719,22,2,4427,'App\\Models\\Receipt',4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',63409.45,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4644,1603,40719,22,2,4428,'App\\Models\\Receipt',4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',2600.00,NULL,NULL,1,'2022-06-13 00:16:26','2022-06-13 00:16:26',NULL),(4645,1603,40719,22,2,4429,'App\\Models\\Receipt',4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',2800.00,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4646,1603,40719,22,2,4430,'App\\Models\\Receipt',4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',5000.00,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4647,1603,40719,22,2,4431,'App\\Models\\Receipt',4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',17932.60,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4648,1603,40719,22,2,4432,'App\\Models\\Receipt',4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',34650.55,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL);
INSERT INTO `balance_libro` VALUES (4649,1603,40719,22,2,4433,'App\\Models\\Receipt',4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',32869.61,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4650,1603,40719,22,2,4434,'App\\Models\\Receipt',4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',13231.36,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4651,1603,40719,22,2,4435,'App\\Models\\Receipt',4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',4000.01,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4652,1603,40719,22,2,4436,'App\\Models\\Receipt',4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',866.98,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4653,1603,40719,22,2,4437,'App\\Models\\Receipt',4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',16150.20,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4654,1603,40719,22,2,4438,'App\\Models\\Receipt',4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',5250.00,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4655,1603,40719,22,2,4439,'App\\Models\\Receipt',4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',22625.19,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4656,1603,40719,22,2,4440,'App\\Models\\Receipt',4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',17790.65,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4657,1603,40719,22,2,4441,'App\\Models\\Receipt',4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',87365.84,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4658,1603,40719,22,2,4442,'App\\Models\\Receipt',4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',22721.49,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4659,1603,40719,22,2,4443,'App\\Models\\Receipt',4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',12220.40,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4660,1603,40719,22,2,4444,'App\\Models\\Receipt',4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',5499.99,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4661,1603,40719,22,2,4445,'App\\Models\\Receipt',4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',866.98,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4662,1603,40719,22,2,4446,'App\\Models\\Receipt',4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',118065.34,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4663,1603,40719,22,2,4447,'App\\Models\\Receipt',4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',19490.81,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4664,1603,40719,22,2,4448,'App\\Models\\Receipt',4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',20959.81,NULL,NULL,1,'2022-06-13 00:16:27','2022-06-13 00:16:27',NULL),(4665,1603,40719,22,2,4449,'App\\Models\\Receipt',4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',14872.52,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4666,1603,40719,22,2,4450,'App\\Models\\Receipt',4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',5000.00,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4667,1603,40719,22,2,4451,'App\\Models\\Receipt',4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',8500.00,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4668,1603,40719,22,2,4452,'App\\Models\\Receipt',4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',2743.00,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4669,1603,40719,22,2,4453,'App\\Models\\Receipt',4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',18949.21,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL);
INSERT INTO `balance_libro` VALUES (4670,1603,40719,22,2,4454,'App\\Models\\Receipt',4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',5600.00,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4671,1603,40719,22,2,4455,'App\\Models\\Receipt',4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',3600.00,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4672,1603,40719,22,2,4456,'App\\Models\\Receipt',4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',2220.01,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4673,1603,40719,22,2,4457,'App\\Models\\Receipt',4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',7799.99,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4674,1603,40719,22,2,4458,'App\\Models\\Receipt',4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',27242.10,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4675,1603,40719,22,2,4459,'App\\Models\\Receipt',4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',44738.70,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4676,1603,40719,22,2,4460,'App\\Models\\Receipt',4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',34722.08,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4677,1603,40719,22,2,4461,'App\\Models\\Receipt',4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',113032.96,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4678,1603,40719,22,2,4462,'App\\Models\\Receipt',4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',12301.90,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4679,1603,40719,22,2,4463,'App\\Models\\Receipt',4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',22857.81,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4680,1603,40719,22,2,4464,'App\\Models\\Receipt',4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',24800.18,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4681,1603,40719,22,2,4465,'App\\Models\\Receipt',4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',51613.22,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4682,1603,40719,22,2,4466,'App\\Models\\Receipt',4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',19552.00,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4683,1603,40719,22,2,4467,'App\\Models\\Receipt',4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',26891.00,NULL,NULL,1,'2022-06-13 00:16:28','2022-06-13 00:16:28',NULL),(4684,1603,40719,22,2,4468,'App\\Models\\Receipt',4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',21556.71,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4685,1603,40719,22,2,4469,'App\\Models\\Receipt',4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',20772.97,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4686,1603,40719,22,2,4470,'App\\Models\\Receipt',4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',5000.00,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4687,1603,40719,22,2,4471,'App\\Models\\Receipt',4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',900.00,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4688,1603,40719,22,2,4472,'App\\Models\\Receipt',4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',11857.60,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4689,1603,40719,22,2,4473,'App\\Models\\Receipt',4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',19500.00,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4690,1603,40719,22,2,4474,'App\\Models\\Receipt',4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',9414.86,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL);
INSERT INTO `balance_libro` VALUES (4691,1603,40719,22,2,4475,'App\\Models\\Receipt',4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',6430.00,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4692,1603,40719,22,2,4476,'App\\Models\\Receipt',4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',5000.00,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4693,1603,40719,22,2,4477,'App\\Models\\Receipt',4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',3500.00,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4694,1603,40719,22,2,4478,'App\\Models\\Receipt',4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',22609.81,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4695,1603,40719,22,2,4479,'App\\Models\\Receipt',4479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',16762.09,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4696,1603,40719,22,2,4480,'App\\Models\\Receipt',4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',6897.30,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4697,1603,40719,22,2,4481,'App\\Models\\Receipt',4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',19202.00,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4698,1603,40719,22,2,4482,'App\\Models\\Receipt',4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',5830.00,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4699,1603,40719,22,2,4483,'App\\Models\\Receipt',4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',18451.40,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4700,1603,40719,22,2,4484,'App\\Models\\Receipt',4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',23843.11,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4701,1603,40719,22,2,4485,'App\\Models\\Receipt',4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',21531.31,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4702,1603,40719,22,2,4486,'App\\Models\\Receipt',4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',122952.12,NULL,NULL,1,'2022-06-13 00:16:29','2022-06-13 00:16:29',NULL),(4703,1603,40719,22,2,4487,'App\\Models\\Receipt',4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',8000.00,NULL,NULL,1,'2022-06-13 00:16:30','2022-06-13 00:16:30',NULL),(4704,1603,40719,22,2,4488,'App\\Models\\Receipt',4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',4600.00,NULL,NULL,1,'2022-06-13 00:16:30','2022-06-13 00:16:30',NULL),(4705,1603,40719,22,2,4489,'App\\Models\\Receipt',4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',17974.61,NULL,NULL,1,'2022-06-13 00:16:30','2022-06-13 00:16:30',NULL),(4706,1603,40719,22,2,4490,'App\\Models\\Receipt',4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',17793.72,NULL,NULL,1,'2022-06-13 00:16:30','2022-06-13 00:16:30',NULL),(4707,1603,40719,22,2,4491,'App\\Models\\Receipt',4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',49459.96,NULL,NULL,1,'2022-06-13 00:16:30','2022-06-13 00:16:30',NULL),(4708,1603,40719,22,2,4492,'App\\Models\\Receipt',4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',59104.66,NULL,NULL,1,'2022-06-13 00:16:30','2022-06-13 00:16:30',NULL),(4709,1603,40719,22,2,4493,'App\\Models\\Receipt',4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',5499.99,NULL,NULL,1,'2022-06-13 00:16:30','2022-06-13 00:16:30',NULL),(4801,1603,40719,22,3,4585,'App\\Models\\Receipt',4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',2000.00,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4802,1603,40719,22,3,4586,'App\\Models\\Receipt',4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',2699.50,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL);
INSERT INTO `balance_libro` VALUES (4803,1603,40719,22,3,4587,'App\\Models\\Receipt',4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',5299.00,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4804,1603,40719,22,3,4588,'App\\Models\\Receipt',4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',420.03,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4805,1603,40719,22,3,4589,'App\\Models\\Receipt',4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',9387.00,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4806,1603,40719,22,3,4590,'App\\Models\\Receipt',4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',861.00,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4807,1603,40719,22,3,4591,'App\\Models\\Receipt',4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',3400.30,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4808,1603,40719,22,3,4592,'App\\Models\\Receipt',4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',4899.39,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4809,1603,40719,22,3,4593,'App\\Models\\Receipt',4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',2124.98,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4810,1603,40719,22,3,4594,'App\\Models\\Receipt',4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',2268.00,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4811,1603,40719,22,3,4595,'App\\Models\\Receipt',4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',13334.83,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4812,1603,40719,22,3,4596,'App\\Models\\Receipt',4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',21727.67,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4813,1603,40719,22,3,4597,'App\\Models\\Receipt',4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',2590.04,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4814,1603,40719,22,3,4598,'App\\Models\\Receipt',4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',4375.00,NULL,NULL,1,'2022-06-13 00:17:49','2022-06-13 00:17:49',NULL),(4815,1603,40719,22,3,4599,'App\\Models\\Receipt',4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',2632.00,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4816,1603,40719,22,3,4600,'App\\Models\\Receipt',4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',8330.00,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4817,1603,40719,22,3,4601,'App\\Models\\Receipt',4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',30379.36,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4818,1603,40719,22,3,4602,'App\\Models\\Receipt',4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',196.00,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4819,1603,40719,22,3,4603,'App\\Models\\Receipt',4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',7238.00,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4820,1603,40719,22,3,4604,'App\\Models\\Receipt',4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',19916.85,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4821,1603,40719,22,3,4605,'App\\Models\\Receipt',4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',86551.30,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4822,1603,40719,22,3,4606,'App\\Models\\Receipt',4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',19397.99,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4823,1603,40719,22,3,4607,'App\\Models\\Receipt',4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',2199.89,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL);
INSERT INTO `balance_libro` VALUES (4824,1603,40719,22,3,4608,'App\\Models\\Receipt',4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',2000.00,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4825,1603,40719,22,3,4609,'App\\Models\\Receipt',4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',21274.92,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4826,1603,40719,22,3,4610,'App\\Models\\Receipt',4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',24321.47,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4827,1603,40719,22,3,4611,'App\\Models\\Receipt',4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',4917.99,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4828,1603,40719,22,3,4612,'App\\Models\\Receipt',4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',9399.99,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4829,1603,40719,22,3,4613,'App\\Models\\Receipt',4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',999.99,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4830,1603,40719,22,3,4614,'App\\Models\\Receipt',4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',15858.03,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4831,1603,40719,22,3,4615,'App\\Models\\Receipt',4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',7870.00,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4832,1603,40719,22,3,4616,'App\\Models\\Receipt',4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',4318.25,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4833,1603,40719,22,3,4617,'App\\Models\\Receipt',4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',6350.20,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4834,1603,40719,22,3,4618,'App\\Models\\Receipt',4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',2422.00,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4835,1603,40719,22,3,4619,'App\\Models\\Receipt',4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',9009.01,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4836,1603,40719,22,3,4620,'App\\Models\\Receipt',4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',9879.77,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4837,1603,40719,22,3,4621,'App\\Models\\Receipt',4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',34462.47,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4838,1603,40719,22,3,4622,'App\\Models\\Receipt',4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2000.50,NULL,NULL,1,'2022-06-13 00:17:50','2022-06-13 00:17:50',NULL),(4839,1603,40719,22,3,4623,'App\\Models\\Receipt',4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2000.01,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4840,1603,40719,22,3,4624,'App\\Models\\Receipt',4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',14715.27,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4841,1603,40719,22,3,4625,'App\\Models\\Receipt',4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',756.00,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4842,1603,40719,22,3,4626,'App\\Models\\Receipt',4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',6401.75,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4843,1603,40719,22,3,4627,'App\\Models\\Receipt',4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',78215.73,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4844,1603,40719,22,3,4628,'App\\Models\\Receipt',4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',4022.69,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL);
INSERT INTO `balance_libro` VALUES (4845,1603,40719,22,3,4629,'App\\Models\\Receipt',4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1000.00,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4846,1603,40719,22,3,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',24036.84,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4847,1603,40719,22,3,4631,'App\\Models\\Receipt',4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',6867.00,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4848,1603,40719,22,3,4632,'App\\Models\\Receipt',4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',13334.83,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4849,1603,40719,22,3,4633,'App\\Models\\Receipt',4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',10346.23,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4850,1603,40719,22,3,4634,'App\\Models\\Receipt',4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',23602.78,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4851,1603,40719,22,3,4635,'App\\Models\\Receipt',4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',7238.00,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4852,1603,40719,22,3,4636,'App\\Models\\Receipt',4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',72655.39,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4853,1603,40719,22,3,4637,'App\\Models\\Receipt',4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',14195.83,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4854,1603,40719,22,3,4638,'App\\Models\\Receipt',4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1500.00,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4855,1603,40719,22,3,4639,'App\\Models\\Receipt',4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',148400.00,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4856,1603,40719,22,3,4640,'App\\Models\\Receipt',4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',160800.00,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4857,1603,40719,22,3,4641,'App\\Models\\Receipt',4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',22492.74,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4858,1603,40719,22,3,4642,'App\\Models\\Receipt',4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',2000.30,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4859,1603,40719,22,3,4643,'App\\Models\\Receipt',4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',2000.01,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4860,1603,40719,22,3,4644,'App\\Models\\Receipt',4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',3046.89,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4861,1603,40719,22,3,4645,'App\\Models\\Receipt',4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1700.00,NULL,NULL,1,'2022-06-13 00:17:51','2022-06-13 00:17:51',NULL),(4862,1603,40719,22,3,4646,'App\\Models\\Receipt',4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',100650.22,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4863,1603,40719,22,3,4647,'App\\Models\\Receipt',4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',21355.34,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4864,1603,40719,22,3,4648,'App\\Models\\Receipt',4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',31038.69,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4865,1603,40719,22,3,4649,'App\\Models\\Receipt',4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',3900.00,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL);
INSERT INTO `balance_libro` VALUES (4866,1603,40719,22,3,4650,'App\\Models\\Receipt',4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',39677.39,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4867,1603,40719,22,3,4651,'App\\Models\\Receipt',4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',15327.26,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4868,1603,40719,22,3,4652,'App\\Models\\Receipt',4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',2182.60,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4869,1603,40719,22,3,4653,'App\\Models\\Receipt',4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',8267.00,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4870,1603,40719,22,3,4654,'App\\Models\\Receipt',4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',6084.78,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4871,1603,40719,22,3,4655,'App\\Models\\Receipt',4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',1000.00,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4872,1603,40719,22,3,4656,'App\\Models\\Receipt',4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',8267.00,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4873,1603,40719,22,3,4657,'App\\Models\\Receipt',4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',9521.36,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4874,1603,40719,22,3,4658,'App\\Models\\Receipt',4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',6110.89,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4875,1603,40719,22,3,4659,'App\\Models\\Receipt',4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',2519.99,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4876,1603,40719,22,3,4660,'App\\Models\\Receipt',4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',2000.01,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4877,1603,40719,22,3,4661,'App\\Models\\Receipt',4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',2177.00,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4878,1603,40719,22,3,4662,'App\\Models\\Receipt',4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',15860.90,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4879,1603,40719,22,3,4663,'App\\Models\\Receipt',4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',26769.27,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4880,1603,40719,22,3,4664,'App\\Models\\Receipt',4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',23729.77,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4881,1603,40719,22,3,4665,'App\\Models\\Receipt',4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-22','2022-05-22',2999.98,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4882,1603,40719,22,3,4666,'App\\Models\\Receipt',4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',93.17,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4883,1603,40719,22,3,4667,'App\\Models\\Receipt',4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',19.97,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4884,1603,40719,22,3,4668,'App\\Models\\Receipt',4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',985.00,NULL,NULL,1,'2022-06-13 00:17:52','2022-06-13 00:17:52',NULL),(4885,1603,40719,22,3,4669,'App\\Models\\Receipt',4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',13128.74,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4886,1603,40719,22,3,4670,'App\\Models\\Receipt',4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',2000.01,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL);
INSERT INTO `balance_libro` VALUES (4887,1603,40719,22,3,4671,'App\\Models\\Receipt',4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',8190.01,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4888,1603,40719,22,3,4672,'App\\Models\\Receipt',4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',13377.52,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4889,1603,40719,22,3,4673,'App\\Models\\Receipt',4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',4346.93,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4890,1603,40719,22,3,4674,'App\\Models\\Receipt',4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',9483.00,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4891,1603,40719,22,3,4675,'App\\Models\\Receipt',4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',2000.01,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4892,1603,40719,22,3,4676,'App\\Models\\Receipt',4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',10058.03,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4893,1603,40719,22,3,4677,'App\\Models\\Receipt',4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',90133.49,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4894,1603,40719,22,3,4678,'App\\Models\\Receipt',4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',11578.97,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4895,1603,40719,22,3,4679,'App\\Models\\Receipt',4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',8267.00,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4896,1603,40719,22,3,4680,'App\\Models\\Receipt',4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',380999.98,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4897,1603,40719,22,3,4681,'App\\Models\\Receipt',4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',33507.84,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4898,1603,40719,22,3,4682,'App\\Models\\Receipt',4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',12312.00,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4899,1603,40719,22,3,4683,'App\\Models\\Receipt',4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',4702.32,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4900,1603,40719,22,3,4684,'App\\Models\\Receipt',4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-29','2022-05-29',31270.44,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4901,1603,40719,22,3,4685,'App\\Models\\Receipt',4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-29','2022-05-29',194541.52,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4902,1603,40719,22,3,4686,'App\\Models\\Receipt',4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',22393.34,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4903,1603,40719,22,3,4687,'App\\Models\\Receipt',4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',4555.77,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4904,1603,40719,22,3,4688,'App\\Models\\Receipt',4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',2499.99,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4905,1603,40719,22,3,4689,'App\\Models\\Receipt',4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',7413.00,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4906,1603,40719,22,3,4690,'App\\Models\\Receipt',4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',16926.00,NULL,NULL,1,'2022-06-13 00:17:53','2022-06-13 00:17:53',NULL),(4907,1603,40719,22,3,4691,'App\\Models\\Receipt',4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',7600.00,NULL,NULL,1,'2022-06-13 00:17:54','2022-06-13 00:17:54',NULL);
INSERT INTO `balance_libro` VALUES (4908,1603,40719,22,3,4692,'App\\Models\\Receipt',4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',15200.00,NULL,NULL,1,'2022-06-13 00:17:54','2022-06-13 00:17:54',NULL),(4909,1603,40719,22,3,4693,'App\\Models\\Receipt',4693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',4850.03,NULL,NULL,1,'2022-06-13 00:17:54','2022-06-13 00:17:54',NULL),(4910,1603,40719,22,3,4694,'App\\Models\\Receipt',4694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',25972.88,NULL,NULL,1,'2022-06-13 00:17:54','2022-06-13 00:17:54',NULL),(4911,1603,40719,21,15,880,'App\\Models\\PeriodLiquidation',NULL,880,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',398998.29,NULL,NULL,1,'2022-06-17 14:44:49','2022-06-17 14:44:49',NULL),(4912,1603,40719,23,2,4695,'App\\Models\\Receipt',4695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',23225.20,NULL,NULL,1,'2022-07-17 21:44:18','2022-07-17 21:44:18',NULL),(4913,1603,40719,23,2,4696,'App\\Models\\Receipt',4696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',63800.34,NULL,NULL,1,'2022-07-17 21:44:18','2022-07-17 21:44:18',NULL),(4914,1603,40719,23,2,4697,'App\\Models\\Receipt',4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5000.00,NULL,NULL,1,'2022-07-17 21:44:18','2022-07-17 21:44:18',NULL),(4915,1603,40719,23,2,4698,'App\\Models\\Receipt',4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2600.00,NULL,NULL,1,'2022-07-17 21:44:18','2022-07-17 21:44:18',NULL),(4916,1603,40719,23,2,4699,'App\\Models\\Receipt',4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',74041.58,NULL,NULL,1,'2022-07-17 21:44:18','2022-07-17 21:44:18',NULL),(4917,1603,40719,23,2,4700,'App\\Models\\Receipt',4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2600.00,NULL,NULL,1,'2022-07-17 21:44:18','2022-07-17 21:44:18',NULL),(4918,1603,40719,23,2,4701,'App\\Models\\Receipt',4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',16040.20,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4919,1603,40719,23,2,4702,'App\\Models\\Receipt',4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',5000.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4920,1603,40719,23,2,4703,'App\\Models\\Receipt',4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',11100.20,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4921,1603,40719,23,2,4704,'App\\Models\\Receipt',4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',3440.01,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4922,1603,40719,23,2,4705,'App\\Models\\Receipt',4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',6430.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4923,1603,40719,23,2,4706,'App\\Models\\Receipt',4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',30035.68,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4924,1603,40719,23,2,4707,'App\\Models\\Receipt',4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',14232.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4925,1603,40719,23,2,4708,'App\\Models\\Receipt',4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1800.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4926,1603,40719,23,2,4709,'App\\Models\\Receipt',4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2600.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4927,1603,40719,23,2,4710,'App\\Models\\Receipt',4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',13882.21,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4928,1603,40719,23,2,4711,'App\\Models\\Receipt',4711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',15383.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL);
INSERT INTO `balance_libro` VALUES (4929,1603,40719,23,2,4712,'App\\Models\\Receipt',4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2710.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4930,1603,40719,23,2,4713,'App\\Models\\Receipt',4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',3600.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4931,1603,40719,23,2,4714,'App\\Models\\Receipt',4714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',20880.33,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4932,1603,40719,23,2,4715,'App\\Models\\Receipt',4715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',6281.23,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4933,1603,40719,23,2,4716,'App\\Models\\Receipt',4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',2600.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4934,1603,40719,23,2,4717,'App\\Models\\Receipt',4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',1300.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4935,1603,40719,23,2,4718,'App\\Models\\Receipt',4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',3700.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4936,1603,40719,23,2,4719,'App\\Models\\Receipt',4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',6640.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4937,1603,40719,23,2,4720,'App\\Models\\Receipt',4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',40014.12,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4938,1603,40719,23,2,4721,'App\\Models\\Receipt',4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',6430.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4939,1603,40719,23,2,4722,'App\\Models\\Receipt',4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',57572.60,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4940,1603,40719,23,2,4723,'App\\Models\\Receipt',4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',5230.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 22:25:45','2022-07-17 22:25:45'),(4941,1603,40719,23,2,4724,'App\\Models\\Receipt',4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',3000.00,NULL,NULL,1,'2022-07-17 21:44:19','2022-07-17 21:44:19',NULL),(4942,1603,40719,23,2,4725,'App\\Models\\Receipt',4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',6000.00,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4943,1603,40719,23,2,4726,'App\\Models\\Receipt',4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',4000.01,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4944,1603,40719,23,2,4727,'App\\Models\\Receipt',4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',3909.99,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4945,1603,40719,23,2,4728,'App\\Models\\Receipt',4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',19302.90,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4946,1603,40719,23,2,4729,'App\\Models\\Receipt',4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',10803.21,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4947,1603,40719,23,2,4730,'App\\Models\\Receipt',4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',35116.52,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4948,1603,40719,23,2,4731,'App\\Models\\Receipt',4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',16593.76,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4949,1603,40719,23,2,4732,'App\\Models\\Receipt',4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',8500.00,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL);
INSERT INTO `balance_libro` VALUES (4950,1603,40719,23,2,4733,'App\\Models\\Receipt',4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',36561.05,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4951,1603,40719,23,2,4734,'App\\Models\\Receipt',4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',3050.00,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4952,1603,40719,23,2,4735,'App\\Models\\Receipt',4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',5600.00,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4953,1603,40719,23,2,4736,'App\\Models\\Receipt',4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',12568.32,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4954,1603,40719,23,2,4737,'App\\Models\\Receipt',4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',22491.00,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4955,1603,40719,23,2,4738,'App\\Models\\Receipt',4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1834.00,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4956,1603,40719,23,2,4739,'App\\Models\\Receipt',4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',19286.57,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4957,1603,40719,23,2,4740,'App\\Models\\Receipt',4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',42980.34,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4958,1603,40719,23,2,4741,'App\\Models\\Receipt',4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',2600.00,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4959,1603,40719,23,2,4742,'App\\Models\\Receipt',4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',2400.00,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4960,1603,40719,23,2,4743,'App\\Models\\Receipt',4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',22980.01,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4961,1603,40719,23,2,4744,'App\\Models\\Receipt',4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',13499.99,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4962,1603,40719,23,2,4745,'App\\Models\\Receipt',4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',242.00,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4963,1603,40719,23,2,4746,'App\\Models\\Receipt',4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',12153.66,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4964,1603,40719,23,2,4747,'App\\Models\\Receipt',4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1399.99,NULL,NULL,1,'2022-07-17 21:44:20','2022-07-17 21:44:20',NULL),(4965,1603,40719,23,2,4748,'App\\Models\\Receipt',4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1500.00,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4966,1603,40719,23,2,4749,'App\\Models\\Receipt',4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',18525.25,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4967,1603,40719,23,2,4750,'App\\Models\\Receipt',4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',131092.16,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4968,1603,40719,23,2,4751,'App\\Models\\Receipt',4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',24991.51,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4969,1603,40719,23,2,4752,'App\\Models\\Receipt',4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',14194.49,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4970,1603,40719,23,2,4753,'App\\Models\\Receipt',4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',15034.26,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL);
INSERT INTO `balance_libro` VALUES (4971,1603,40719,23,2,4754,'App\\Models\\Receipt',4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',20109.32,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4972,1603,40719,23,2,4755,'App\\Models\\Receipt',4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',10638.01,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4973,1603,40719,23,2,4756,'App\\Models\\Receipt',4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',14563.92,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4974,1603,40719,23,2,4757,'App\\Models\\Receipt',4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',12030.00,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4975,1603,40719,23,2,4758,'App\\Models\\Receipt',4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',7000.00,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4976,1603,40719,23,2,4759,'App\\Models\\Receipt',4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',5000.00,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4977,1603,40719,23,2,4760,'App\\Models\\Receipt',4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',6430.00,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4978,1603,40719,23,2,4761,'App\\Models\\Receipt',4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',12954.43,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4979,1603,40719,23,2,4762,'App\\Models\\Receipt',4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',3700.00,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4980,1603,40719,23,2,4763,'App\\Models\\Receipt',4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',14083.70,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4981,1603,40719,23,2,4764,'App\\Models\\Receipt',4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',171345.12,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4982,1603,40719,23,2,4765,'App\\Models\\Receipt',4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',14299.04,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4983,1603,40719,23,2,4766,'App\\Models\\Receipt',4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',1500.00,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4984,1603,40719,23,2,4767,'App\\Models\\Receipt',4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',2714.51,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4985,1603,40719,23,2,4768,'App\\Models\\Receipt',4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',21664.70,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 22:24:56','2022-07-17 22:24:56'),(4986,1603,40719,23,2,4769,'App\\Models\\Receipt',4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',7000.00,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4987,1603,40719,23,2,4770,'App\\Models\\Receipt',4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',19831.22,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4988,1603,40719,23,2,4771,'App\\Models\\Receipt',4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',20700.00,NULL,NULL,1,'2022-07-17 21:44:21','2022-07-17 21:44:21',NULL),(4989,1603,40719,23,2,4772,'App\\Models\\Receipt',4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',52400.48,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(4990,1603,40719,23,2,4773,'App\\Models\\Receipt',4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',24742.39,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(4991,1603,40719,23,2,4774,'App\\Models\\Receipt',4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',2600.00,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL);
INSERT INTO `balance_libro` VALUES (4992,1603,40719,23,2,4775,'App\\Models\\Receipt',4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',3000.00,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(4993,1603,40719,23,2,4776,'App\\Models\\Receipt',4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',4000.01,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(4994,1603,40719,23,2,4777,'App\\Models\\Receipt',4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',4600.00,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(4995,1603,40719,23,2,4778,'App\\Models\\Receipt',4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',87641.73,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(4996,1603,40719,23,2,4779,'App\\Models\\Receipt',4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',15428.32,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(4997,1603,40719,23,2,4780,'App\\Models\\Receipt',4780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1450.00,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(4998,1603,40719,23,2,4781,'App\\Models\\Receipt',4781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',8737.49,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(4999,1603,40719,23,2,4782,'App\\Models\\Receipt',4782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',28611.83,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5000,1603,40719,23,2,4783,'App\\Models\\Receipt',4783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',21219.82,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5001,1603,40719,23,2,4784,'App\\Models\\Receipt',4784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',27000.00,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5002,1603,40719,23,2,4785,'App\\Models\\Receipt',4785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',22402.41,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5003,1603,40719,23,2,4786,'App\\Models\\Receipt',4786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',7000.00,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5004,1603,40719,23,2,4787,'App\\Models\\Receipt',4787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',21531.14,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5005,1603,40719,23,2,4788,'App\\Models\\Receipt',4788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',5000.00,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5006,1603,40719,23,2,4789,'App\\Models\\Receipt',4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',60159.48,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5007,1603,40719,23,2,4790,'App\\Models\\Receipt',4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',46368.82,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5008,1603,40719,23,2,4791,'App\\Models\\Receipt',4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',1800.00,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5009,1603,40719,23,2,4792,'App\\Models\\Receipt',4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',953.67,NULL,NULL,1,'2022-07-17 21:44:22','2022-07-17 21:44:22',NULL),(5010,1603,40719,23,2,4793,'App\\Models\\Receipt',4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6500.00,NULL,NULL,1,'2022-07-17 21:44:23','2022-07-17 21:44:23',NULL),(5011,1603,40719,23,2,4794,'App\\Models\\Receipt',4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',19827.16,NULL,NULL,1,'2022-07-17 21:44:23','2022-07-17 21:44:23',NULL),(5012,1603,40719,23,2,4795,'App\\Models\\Receipt',4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',21391.28,NULL,NULL,1,'2022-07-17 21:44:23','2022-07-17 21:44:23',NULL);
INSERT INTO `balance_libro` VALUES (5100,1603,40719,23,3,4883,'App\\Models\\Receipt',4883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',22393.34,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5101,1603,40719,23,3,4884,'App\\Models\\Receipt',4884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',27553.02,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5102,1603,40719,23,3,4885,'App\\Models\\Receipt',4885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',3000.91,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5103,1603,40719,23,3,4886,'App\\Models\\Receipt',4886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',8842.81,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5104,1603,40719,23,3,4887,'App\\Models\\Receipt',4887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5299.00,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5105,1603,40719,23,3,4888,'App\\Models\\Receipt',4888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5299.00,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5106,1603,40719,23,3,4889,'App\\Models\\Receipt',4889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',11696.47,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5107,1603,40719,23,3,4890,'App\\Models\\Receipt',4890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',12400.00,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5108,1603,40719,23,3,4891,'App\\Models\\Receipt',4891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2744.72,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5109,1603,40719,23,3,4892,'App\\Models\\Receipt',4892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',6699.00,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5110,1603,40719,23,3,4893,'App\\Models\\Receipt',4893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',707.00,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5111,1603,40719,23,3,4894,'App\\Models\\Receipt',4894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',13245.86,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5112,1603,40719,23,3,4895,'App\\Models\\Receipt',4895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',6251.51,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5113,1603,40719,23,3,4896,'App\\Models\\Receipt',4896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',3829.00,NULL,NULL,1,'2022-07-17 21:48:27','2022-07-17 21:48:27',NULL),(5114,1603,40719,23,3,4897,'App\\Models\\Receipt',4897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',2408.00,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5115,1603,40719,23,3,4898,'App\\Models\\Receipt',4898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',5131.01,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5116,1603,40719,23,3,4899,'App\\Models\\Receipt',4899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',2000.01,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5117,1603,40719,23,3,4900,'App\\Models\\Receipt',4900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',2999.98,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5118,1603,40719,23,3,4901,'App\\Models\\Receipt',4901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',4816.53,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5119,1603,40719,23,3,4902,'App\\Models\\Receipt',4902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',87765.07,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5120,1603,40719,23,3,4903,'App\\Models\\Receipt',4903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',108799.10,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL);
INSERT INTO `balance_libro` VALUES (5121,1603,40719,23,3,4904,'App\\Models\\Receipt',4904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',8232.01,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5122,1603,40719,23,3,4905,'App\\Models\\Receipt',4905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',10013.39,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 22:12:27','2022-07-17 22:12:27'),(5123,1603,40719,23,3,4906,'App\\Models\\Receipt',4906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',133.10,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5124,1603,40719,23,3,4907,'App\\Models\\Receipt',4907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',4679.51,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5125,1603,40719,23,3,4908,'App\\Models\\Receipt',4908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2891.00,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5126,1603,40719,23,3,4909,'App\\Models\\Receipt',4909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',3189.04,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5127,1603,40719,23,3,4910,'App\\Models\\Receipt',4910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',370.01,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5128,1603,40719,23,3,4911,'App\\Models\\Receipt',4911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',1230.00,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5129,1603,40719,23,3,4912,'App\\Models\\Receipt',4912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',7413.00,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5130,1603,40719,23,3,4913,'App\\Models\\Receipt',4913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',3240.78,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5131,1603,40719,23,3,4914,'App\\Models\\Receipt',4914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',15234.92,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5132,1603,40719,23,3,4915,'App\\Models\\Receipt',4915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',7870.00,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5133,1603,40719,23,3,4916,'App\\Models\\Receipt',4916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',52660.41,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5134,1603,40719,23,3,4917,'App\\Models\\Receipt',4917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',1677.54,NULL,NULL,1,'2022-07-17 21:48:28','2022-07-17 21:48:28',NULL),(5135,1603,40719,23,3,4918,'App\\Models\\Receipt',4918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',4831.34,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5136,1603,40719,23,3,4919,'App\\Models\\Receipt',4919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',15837.52,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5137,1603,40719,23,3,4920,'App\\Models\\Receipt',4920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',4995.06,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5138,1603,40719,23,3,4921,'App\\Models\\Receipt',4921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',1624.00,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5139,1603,40719,23,3,4922,'App\\Models\\Receipt',4922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',1624.00,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5140,1603,40719,23,3,4923,'App\\Models\\Receipt',4923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',16807.29,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5141,1603,40719,23,3,4924,'App\\Models\\Receipt',4924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',9951.21,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL);
INSERT INTO `balance_libro` VALUES (5142,1603,40719,23,3,4925,'App\\Models\\Receipt',4925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',3366.99,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5143,1603,40719,23,3,4926,'App\\Models\\Receipt',4926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',1000.00,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5144,1603,40719,23,3,4927,'App\\Models\\Receipt',4927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',3890.44,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5145,1603,40719,23,3,4928,'App\\Models\\Receipt',4928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',15396.87,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5146,1603,40719,23,3,4929,'App\\Models\\Receipt',4929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',10083.55,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5147,1603,40719,23,3,4930,'App\\Models\\Receipt',4930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',9630.00,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5148,1603,40719,23,3,4931,'App\\Models\\Receipt',4931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',2043.99,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5149,1603,40719,23,3,4932,'App\\Models\\Receipt',4932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',839.99,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5150,1603,40719,23,3,4933,'App\\Models\\Receipt',4933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',6236.40,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5151,1603,40719,23,3,4934,'App\\Models\\Receipt',4934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',5100.50,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5152,1603,40719,23,3,4935,'App\\Models\\Receipt',4935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',2226.00,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5153,1603,40719,23,3,4936,'App\\Models\\Receipt',4936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',14060.62,NULL,NULL,1,'2022-07-17 21:48:29','2022-07-17 21:48:29',NULL),(5154,1603,40719,23,3,4937,'App\\Models\\Receipt',4937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',14694.22,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5155,1603,40719,23,3,4938,'App\\Models\\Receipt',4938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',37677.84,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5156,1603,40719,23,3,4939,'App\\Models\\Receipt',4939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',5000.02,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5157,1603,40719,23,3,4940,'App\\Models\\Receipt',4940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',10228.72,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5158,1603,40719,23,3,4941,'App\\Models\\Receipt',4941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',47500.00,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5159,1603,40719,23,3,4942,'App\\Models\\Receipt',4942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',30000.00,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5160,1603,40719,23,3,4943,'App\\Models\\Receipt',4943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',45000.00,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5161,1603,40719,23,3,4944,'App\\Models\\Receipt',4944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',360.00,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5162,1603,40719,23,3,4945,'App\\Models\\Receipt',4945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',25061.50,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL);
INSERT INTO `balance_libro` VALUES (5163,1603,40719,23,3,4946,'App\\Models\\Receipt',4946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',2000.01,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5164,1603,40719,23,3,4947,'App\\Models\\Receipt',4947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',2000.01,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5165,1603,40719,23,3,4948,'App\\Models\\Receipt',4948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',12829.61,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5166,1603,40719,23,3,4949,'App\\Models\\Receipt',4949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',9494.28,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5167,1603,40719,23,3,4950,'App\\Models\\Receipt',4950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',81397.91,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5168,1603,40719,23,3,4951,'App\\Models\\Receipt',4951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',2300.80,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5169,1603,40719,23,3,4952,'App\\Models\\Receipt',4952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',54703.45,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5170,1603,40719,23,3,4953,'App\\Models\\Receipt',4953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',9789.05,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5171,1603,40719,23,3,4954,'App\\Models\\Receipt',4954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',13415.83,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5172,1603,40719,23,3,4955,'App\\Models\\Receipt',4955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',4389.00,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5173,1603,40719,23,3,4956,'App\\Models\\Receipt',4956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',1230.00,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5174,1603,40719,23,3,4957,'App\\Models\\Receipt',4957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',8778.01,NULL,NULL,1,'2022-07-17 21:48:30','2022-07-17 21:48:30',NULL),(5175,1603,40719,23,3,4958,'App\\Models\\Receipt',4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',4380.77,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 23:09:49','2022-07-17 23:09:49'),(5176,1603,40719,23,3,4959,'App\\Models\\Receipt',4959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',27599.47,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5177,1603,40719,23,3,4960,'App\\Models\\Receipt',4960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',4643.58,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5178,1603,40719,23,3,4961,'App\\Models\\Receipt',4961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',8862.80,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5179,1603,40719,23,3,4962,'App\\Models\\Receipt',4962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',4083.15,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5180,1603,40719,23,3,4963,'App\\Models\\Receipt',4963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',2000.90,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5181,1603,40719,23,3,4964,'App\\Models\\Receipt',4964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',16833.72,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5182,1603,40719,23,3,4965,'App\\Models\\Receipt',4965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',8778.01,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5183,1603,40719,23,3,4966,'App\\Models\\Receipt',4966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',89771.71,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL);
INSERT INTO `balance_libro` VALUES (5184,1603,40719,23,3,4967,'App\\Models\\Receipt',4967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',6125.19,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5185,1603,40719,23,3,4968,'App\\Models\\Receipt',4968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',3914.27,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5186,1603,40719,23,3,4969,'App\\Models\\Receipt',4969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',4101.61,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5187,1603,40719,23,3,4970,'App\\Models\\Receipt',4970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1904.00,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5188,1603,40719,23,3,4971,'App\\Models\\Receipt',4971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',28539.82,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5189,1603,40719,23,3,4972,'App\\Models\\Receipt',4972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',2002.01,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5190,1603,40719,23,3,4973,'App\\Models\\Receipt',4973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',83272.56,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5191,1603,40719,23,3,4974,'App\\Models\\Receipt',4974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',6568.62,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5192,1603,40719,23,3,4975,'App\\Models\\Receipt',4975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',77839.30,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5193,1603,40719,23,3,4976,'App\\Models\\Receipt',4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',37267.40,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 22:12:51','2022-07-17 22:12:51'),(5194,1603,40719,23,3,4977,'App\\Models\\Receipt',4977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',653000.00,NULL,NULL,1,'2022-07-17 21:48:31','2022-07-17 21:48:31',NULL),(5195,1603,40719,23,3,4978,'App\\Models\\Receipt',4978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',8358.00,NULL,NULL,1,'2022-07-17 21:48:32','2022-07-17 21:48:32',NULL),(5196,1603,40719,22,15,886,'App\\Models\\PeriodLiquidation',NULL,886,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',447935.38,NULL,NULL,1,'2022-07-17 21:52:15','2022-07-17 21:55:09','2022-07-17 21:55:09'),(5197,1603,40719,22,7,4979,'App\\Models\\Receipt',4979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1546.72,NULL,NULL,1,'2022-07-17 22:01:04','2022-07-17 22:01:04',NULL),(5198,1603,40719,22,7,4980,'App\\Models\\Receipt',4980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1133.76,NULL,NULL,1,'2022-07-17 22:02:17','2022-07-17 22:02:17',NULL),(5199,1603,40719,22,7,4981,'App\\Models\\Receipt',4981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',206.80,NULL,NULL,1,'2022-07-17 22:02:48','2022-07-17 22:02:48',NULL),(5200,1603,40719,22,7,4982,'App\\Models\\Receipt',4982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',10036.06,NULL,NULL,1,'2022-07-17 22:03:40','2022-07-17 22:03:40',NULL),(5201,1603,40719,22,7,4983,'App\\Models\\Receipt',4983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',9156.94,NULL,NULL,1,'2022-07-17 22:04:19','2022-07-17 22:04:19',NULL),(5202,1603,40719,22,15,899,'App\\Models\\PeriodLiquidation',NULL,899,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',447935.38,NULL,NULL,1,'2022-07-17 22:07:58','2024-05-23 22:11:13','2024-05-23 22:11:13'),(5203,1603,40719,22,16,900,'App\\Models\\PeriodLiquidation',NULL,900,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',35104.07,NULL,NULL,1,'2022-07-17 22:08:30','2022-07-17 22:08:30',NULL);
INSERT INTO `balance_libro` VALUES (5204,1603,40719,23,3,4905,'App\\Models\\Receipt',4905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',10013.39,NULL,NULL,1,'2022-07-17 22:12:27','2022-07-17 22:12:27',NULL),(5205,1603,40719,23,3,4976,'App\\Models\\Receipt',4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',37267.40,NULL,NULL,1,'2022-07-17 22:12:51','2022-07-17 22:12:51',NULL),(5206,1603,40719,23,2,4768,'App\\Models\\Receipt',4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',20434.70,NULL,NULL,1,'2022-07-17 22:24:56','2022-07-17 22:24:56',NULL),(5207,1603,40719,23,2,4723,'App\\Models\\Receipt',4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',4000.01,NULL,NULL,1,'2022-07-17 22:25:45','2022-07-17 22:25:45',NULL),(5208,1603,40719,23,3,4958,'App\\Models\\Receipt',4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',4585.97,NULL,NULL,1,'2022-07-17 23:09:49','2022-07-17 23:11:09','2022-07-17 23:11:09'),(5209,1603,40719,23,3,4958,'App\\Models\\Receipt',4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',4485.97,NULL,NULL,1,'2022-07-17 23:11:09','2022-07-17 23:11:09',NULL),(5210,1603,40719,23,7,4984,'App\\Models\\Receipt',4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2276.11,NULL,NULL,1,'2022-07-18 00:15:06','2022-07-20 00:06:17','2022-07-20 00:06:17'),(5211,1603,40719,23,7,4985,'App\\Models\\Receipt',4985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',7083.25,NULL,NULL,1,'2022-07-18 00:16:11','2022-07-18 00:16:11',NULL),(5212,1603,40719,23,7,4986,'App\\Models\\Receipt',4986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3673.73,NULL,NULL,1,'2022-07-18 00:17:01','2022-07-18 00:17:01',NULL),(5213,1603,40719,23,15,917,'App\\Models\\PeriodLiquidation',NULL,917,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',348124.81,NULL,NULL,1,'2022-07-19 19:45:25','2022-07-20 00:05:51','2022-07-20 00:05:51'),(5214,1603,40719,23,7,4984,'App\\Models\\Receipt',4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6154.22,NULL,NULL,1,'2022-07-20 00:06:17','2022-07-20 00:06:17',NULL),(5215,1603,40719,23,16,920,'App\\Models\\PeriodLiquidation',NULL,920,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',26330.49,NULL,NULL,1,'2022-07-20 00:07:57','2024-08-18 20:37:30','2024-08-18 20:37:30'),(5216,1603,40719,23,15,919,'App\\Models\\PeriodLiquidation',NULL,919,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',348124.81,NULL,NULL,1,'2022-07-20 00:08:59','2022-07-20 00:08:59',NULL),(5489,7538,40719,24,3,5259,'App\\Models\\Receipt',5259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2723.17,NULL,NULL,1,'2022-08-16 21:56:52','2022-08-16 21:56:52',NULL),(5490,7538,40719,24,3,5260,'App\\Models\\Receipt',5260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',37.58,NULL,NULL,1,'2022-08-16 21:56:52','2022-08-16 21:56:52',NULL),(5491,7538,40719,24,3,5261,'App\\Models\\Receipt',5261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1540.00,NULL,NULL,1,'2022-08-16 21:56:52','2022-08-16 21:56:52',NULL),(5492,7538,40719,24,3,5262,'App\\Models\\Receipt',5262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',615.00,NULL,NULL,1,'2022-08-16 21:56:52','2022-08-16 21:56:52',NULL),(5493,7538,40719,24,3,5263,'App\\Models\\Receipt',5263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5299.00,NULL,NULL,1,'2022-08-16 21:56:52','2022-08-16 21:56:52',NULL),(5494,7538,40719,24,3,5264,'App\\Models\\Receipt',5264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5299.00,NULL,NULL,1,'2022-08-16 21:56:52','2022-08-16 21:56:52',NULL),(5495,7538,40719,24,3,5265,'App\\Models\\Receipt',5265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',16736.13,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL);
INSERT INTO `balance_libro` VALUES (5496,7538,40719,24,3,5266,'App\\Models\\Receipt',5266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',1680.00,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5497,7538,40719,24,3,5267,'App\\Models\\Receipt',5267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1733.43,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5498,7538,40719,24,3,5268,'App\\Models\\Receipt',5268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',14826.00,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-18 00:22:40','2022-08-18 00:22:40'),(5499,7538,40719,24,3,5269,'App\\Models\\Receipt',5269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1680.00,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5500,7538,40719,24,3,5270,'App\\Models\\Receipt',5270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1600.01,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5501,7538,40719,24,3,5271,'App\\Models\\Receipt',5271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8583.52,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5502,7538,40719,24,3,5272,'App\\Models\\Receipt',5272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6249.78,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5503,7538,40719,24,3,5273,'App\\Models\\Receipt',5273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5300.10,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5504,7538,40719,24,3,5274,'App\\Models\\Receipt',5274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',9618.00,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5505,7538,40719,24,3,5275,'App\\Models\\Receipt',5275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4389.00,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5506,7538,40719,24,3,5276,'App\\Models\\Receipt',5276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',8939.00,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5507,7538,40719,24,3,5277,'App\\Models\\Receipt',5277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7870.00,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5508,7538,40719,24,3,5278,'App\\Models\\Receipt',5278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3019.38,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5509,7538,40719,24,3,5279,'App\\Models\\Receipt',5279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',801.61,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5510,7538,40719,24,3,5280,'App\\Models\\Receipt',5280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',15071.06,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5511,7538,40719,24,3,5281,'App\\Models\\Receipt',5281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',23474.70,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5512,7538,40719,24,3,5282,'App\\Models\\Receipt',5282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8190.01,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5513,7538,40719,24,3,5283,'App\\Models\\Receipt',5283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',8400.00,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5514,7538,40719,24,3,5284,'App\\Models\\Receipt',5284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7294.03,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5515,7538,40719,24,3,5285,'App\\Models\\Receipt',5285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4389.00,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL),(5516,7538,40719,24,3,5286,'App\\Models\\Receipt',5286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',96517.39,NULL,NULL,1,'2022-08-16 21:56:53','2022-08-16 21:56:53',NULL);
INSERT INTO `balance_libro` VALUES (5517,7538,40719,24,3,5287,'App\\Models\\Receipt',5287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',9382.98,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5518,7538,40719,24,3,5288,'App\\Models\\Receipt',5288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',14587.41,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5519,7538,40719,24,3,5289,'App\\Models\\Receipt',5289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',109791.77,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5520,7538,40719,24,3,5290,'App\\Models\\Receipt',5290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3884.39,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5521,7538,40719,24,3,5291,'App\\Models\\Receipt',5291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',8531.84,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5522,7538,40719,24,3,5292,'App\\Models\\Receipt',5292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',33880.00,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5523,7538,40719,24,3,5293,'App\\Models\\Receipt',5293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',37969.00,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5524,7538,40719,24,3,5294,'App\\Models\\Receipt',5294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',10765.45,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5525,7538,40719,24,3,5295,'App\\Models\\Receipt',5295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',16804.40,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5526,7538,40719,24,3,5296,'App\\Models\\Receipt',5296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7560.00,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5527,7538,40719,24,3,5297,'App\\Models\\Receipt',5297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2499.99,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5528,7538,40719,24,3,5298,'App\\Models\\Receipt',5298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1848.00,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5529,7538,40719,24,3,5299,'App\\Models\\Receipt',5299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',188469.60,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5530,7538,40719,24,3,5300,'App\\Models\\Receipt',5300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',15070.99,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5531,7538,40719,24,3,5301,'App\\Models\\Receipt',5301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',8900.00,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5532,7538,40719,24,3,5302,'App\\Models\\Receipt',5302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',4125.57,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5533,7538,40719,24,3,5303,'App\\Models\\Receipt',5303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',924.00,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5534,7538,40719,24,3,5304,'App\\Models\\Receipt',5304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',40502.59,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5535,7538,40719,24,3,5305,'App\\Models\\Receipt',5305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',10168.34,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5536,7538,40719,24,3,5306,'App\\Models\\Receipt',5306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',9200.00,NULL,NULL,1,'2022-08-16 21:56:54','2022-08-16 21:56:54',NULL),(5537,7538,40719,24,3,5307,'App\\Models\\Receipt',5307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',33775.83,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL);
INSERT INTO `balance_libro` VALUES (5538,7538,40719,24,3,5308,'App\\Models\\Receipt',5308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2000.90,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5539,7538,40719,24,3,5309,'App\\Models\\Receipt',5309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',13797.36,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5540,7538,40719,24,3,5310,'App\\Models\\Receipt',5310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',83096.75,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5541,7538,40719,24,3,5311,'App\\Models\\Receipt',5311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',23538.73,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5542,7538,40719,24,3,5312,'App\\Models\\Receipt',5312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7406.00,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5543,7538,40719,24,3,5313,'App\\Models\\Receipt',5313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',96441.84,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5544,7538,40719,24,3,5314,'App\\Models\\Receipt',5314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4000.01,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5545,7538,40719,24,3,5315,'App\\Models\\Receipt',5315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',615.00,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5546,7538,40719,24,3,5316,'App\\Models\\Receipt',5316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',7014.05,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5547,7538,40719,24,3,5317,'App\\Models\\Receipt',5317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',3671.83,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5548,7538,40719,24,3,5318,'App\\Models\\Receipt',5318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',2600.05,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5549,7538,40719,24,3,5319,'App\\Models\\Receipt',5319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',13484.45,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5550,7538,40719,24,3,5320,'App\\Models\\Receipt',5320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',24380.43,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5551,7538,40719,24,3,5321,'App\\Models\\Receipt',5321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',22366.40,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5552,7538,40719,24,3,5322,'App\\Models\\Receipt',5322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',19272.00,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5553,7538,40719,24,3,5323,'App\\Models\\Receipt',5323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2999.98,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5554,7538,40719,24,3,5324,'App\\Models\\Receipt',5324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',8853.67,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5555,7538,40719,24,3,5325,'App\\Models\\Receipt',5325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7740.62,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5556,7538,40719,24,3,5326,'App\\Models\\Receipt',5326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',391600.00,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5557,7538,40719,24,3,5327,'App\\Models\\Receipt',5327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3380.99,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5558,7538,40719,24,3,5328,'App\\Models\\Receipt',5328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',23026.41,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL);
INSERT INTO `balance_libro` VALUES (5559,7538,40719,24,3,5329,'App\\Models\\Receipt',5329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7586.70,NULL,NULL,1,'2022-08-16 21:56:55','2022-08-16 21:56:55',NULL),(5560,7538,40719,24,3,5330,'App\\Models\\Receipt',5330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5238.76,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5561,7538,40719,24,3,5331,'App\\Models\\Receipt',5331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',25758.84,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5562,7538,40719,24,3,5332,'App\\Models\\Receipt',5332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6643.01,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5563,7538,40719,24,3,5333,'App\\Models\\Receipt',5333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',10075.84,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5564,7538,40719,24,3,5334,'App\\Models\\Receipt',5334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',103861.56,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5565,7538,40719,24,3,5335,'App\\Models\\Receipt',5335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',9100.00,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5566,7538,40719,24,3,5336,'App\\Models\\Receipt',5336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',4485.97,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5567,7538,40719,24,3,5337,'App\\Models\\Receipt',5337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',2781.30,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5568,7538,40719,24,3,5338,'App\\Models\\Receipt',5338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',3061.65,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5569,7538,40719,24,3,5339,'App\\Models\\Receipt',5339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',14647.58,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5570,7538,40719,24,3,5340,'App\\Models\\Receipt',5340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',121678.51,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5571,7538,40719,24,3,5341,'App\\Models\\Receipt',5341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',130345.43,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5572,7538,40719,24,3,5342,'App\\Models\\Receipt',5342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',20251.29,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5573,7538,40719,24,3,5343,'App\\Models\\Receipt',5343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',46677.20,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5574,7538,40719,24,3,5344,'App\\Models\\Receipt',5344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',2000.99,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5575,7538,40719,24,3,5345,'App\\Models\\Receipt',5345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',26146.12,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5576,7538,40719,24,3,5346,'App\\Models\\Receipt',5346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',354000.00,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5577,7538,40719,24,3,5347,'App\\Models\\Receipt',5347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',924.00,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5578,7538,40719,24,3,5348,'App\\Models\\Receipt',5348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',2533.99,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5579,7538,40719,24,3,5349,'App\\Models\\Receipt',5349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',11122.87,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL);
INSERT INTO `balance_libro` VALUES (5580,7538,40719,24,3,5350,'App\\Models\\Receipt',5350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',75711.54,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5581,7538,40719,24,3,5351,'App\\Models\\Receipt',5351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4550.00,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5582,7538,40719,24,3,5352,'App\\Models\\Receipt',5352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',15268.02,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5583,7538,40719,24,3,5353,'App\\Models\\Receipt',5353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3612.01,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5584,7538,40719,24,3,5354,'App\\Models\\Receipt',5354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4550.00,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5585,7538,40719,24,3,5355,'App\\Models\\Receipt',5355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',23780.53,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5586,7538,40719,24,3,5356,'App\\Models\\Receipt',5356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2049.23,NULL,NULL,1,'2022-08-16 21:56:56','2022-08-16 21:56:56',NULL),(5587,7538,40719,24,3,5357,'App\\Models\\Receipt',5357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',32123.77,NULL,NULL,1,'2022-08-16 21:56:57','2022-08-16 21:56:57',NULL),(5625,7538,40719,24,2,5395,'App\\Models\\Receipt',5395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',12499.99,NULL,NULL,1,'2022-08-16 21:58:34','2022-08-16 21:58:34',NULL),(5626,7538,40719,24,2,5396,'App\\Models\\Receipt',5396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',16379.17,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5627,7538,40719,24,2,5397,'App\\Models\\Receipt',5397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',16643.86,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5628,7538,40719,24,2,5398,'App\\Models\\Receipt',5398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',5000.00,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5629,7538,40719,24,2,5399,'App\\Models\\Receipt',5399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',5499.99,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5630,7538,40719,24,2,5400,'App\\Models\\Receipt',5400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',38151.00,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5631,7538,40719,24,2,5401,'App\\Models\\Receipt',5401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',700.00,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5632,7538,40719,24,2,5402,'App\\Models\\Receipt',5402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',12721.14,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5633,7538,40719,24,2,5403,'App\\Models\\Receipt',5403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',16049.98,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5634,7538,40719,24,2,5404,'App\\Models\\Receipt',5404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',36177.80,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5635,7538,40719,24,2,5405,'App\\Models\\Receipt',5405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5000.00,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5636,7538,40719,24,2,5406,'App\\Models\\Receipt',5406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',17335.91,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5637,7538,40719,24,2,5407,'App\\Models\\Receipt',5407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6500.00,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL);
INSERT INTO `balance_libro` VALUES (5638,7538,40719,24,2,5408,'App\\Models\\Receipt',5408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13650.00,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5639,7538,40719,24,2,5409,'App\\Models\\Receipt',5409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1181.09,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5640,7538,40719,24,2,5410,'App\\Models\\Receipt',5410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4800.00,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5641,7538,40719,24,2,5411,'App\\Models\\Receipt',5411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',32943.87,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5642,7538,40719,24,2,5412,'App\\Models\\Receipt',5412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5000.00,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5643,7538,40719,24,2,5413,'App\\Models\\Receipt',5413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',15571.01,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5644,7538,40719,24,2,5414,'App\\Models\\Receipt',5414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',19500.00,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5645,7538,40719,24,2,5415,'App\\Models\\Receipt',5415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',14382.96,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5646,7538,40719,24,2,5416,'App\\Models\\Receipt',5416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20612.48,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5647,7538,40719,24,2,5417,'App\\Models\\Receipt',5417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',9348.10,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5648,7538,40719,24,2,5418,'App\\Models\\Receipt',5418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',30625.93,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5649,7538,40719,24,2,5419,'App\\Models\\Receipt',5419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',17379.44,NULL,NULL,1,'2022-08-16 21:58:35','2022-08-16 21:58:35',NULL),(5650,7538,40719,24,2,5420,'App\\Models\\Receipt',5420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',25569.70,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5651,7538,40719,24,2,5421,'App\\Models\\Receipt',5421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',46401.20,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5652,7538,40719,24,2,5422,'App\\Models\\Receipt',5422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',21693.04,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5653,7538,40719,24,2,5423,'App\\Models\\Receipt',5423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7200.00,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5654,7538,40719,24,2,5424,'App\\Models\\Receipt',5424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',227572.86,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5655,7538,40719,24,2,5425,'App\\Models\\Receipt',5425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',4800.00,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5656,7538,40719,24,2,5426,'App\\Models\\Receipt',5426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',35680.59,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5657,7538,40719,24,2,5427,'App\\Models\\Receipt',5427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',29246.91,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5658,7538,40719,24,2,5428,'App\\Models\\Receipt',5428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',10000.00,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL);
INSERT INTO `balance_libro` VALUES (5659,7538,40719,24,2,5429,'App\\Models\\Receipt',5429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',11900.00,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5660,7538,40719,24,2,5430,'App\\Models\\Receipt',5430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',7600.00,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5661,7538,40719,24,2,5431,'App\\Models\\Receipt',5431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',15945.90,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5662,7538,40719,24,2,5432,'App\\Models\\Receipt',5432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',46368.82,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5663,7538,40719,24,2,5433,'App\\Models\\Receipt',5433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3500.00,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5664,7538,40719,24,2,5434,'App\\Models\\Receipt',5434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',8444.76,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5665,7538,40719,24,2,5435,'App\\Models\\Receipt',5435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',24247.58,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5666,7538,40719,24,2,5436,'App\\Models\\Receipt',5436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',17422.78,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5667,7538,40719,24,2,5437,'App\\Models\\Receipt',5437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6500.00,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5668,7538,40719,24,2,5438,'App\\Models\\Receipt',5438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5000.00,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5669,7538,40719,24,2,5439,'App\\Models\\Receipt',5439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',10500.00,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5670,7538,40719,24,2,5440,'App\\Models\\Receipt',5440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',30520.19,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5671,7538,40719,24,2,5441,'App\\Models\\Receipt',5441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',30520.19,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5672,7538,40719,24,2,5442,'App\\Models\\Receipt',5442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',30631.88,NULL,NULL,1,'2022-08-16 21:58:36','2022-08-16 21:58:36',NULL),(5673,7538,40719,24,2,5443,'App\\Models\\Receipt',5443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7500.00,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5674,7538,40719,24,2,5444,'App\\Models\\Receipt',5444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',43343.59,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5675,7538,40719,24,2,5445,'App\\Models\\Receipt',5445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',20082.07,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5676,7538,40719,24,2,5446,'App\\Models\\Receipt',5446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5000.00,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5677,7538,40719,24,2,5447,'App\\Models\\Receipt',5447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3600.00,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5678,7538,40719,24,2,5448,'App\\Models\\Receipt',5448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',26029.14,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5679,7538,40719,24,2,5449,'App\\Models\\Receipt',5449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',14000.00,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL);
INSERT INTO `balance_libro` VALUES (5680,7538,40719,24,2,5450,'App\\Models\\Receipt',5450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',21998.10,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5681,7538,40719,24,2,5451,'App\\Models\\Receipt',5451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20703.32,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5682,7538,40719,24,2,5452,'App\\Models\\Receipt',5452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',23876.36,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5683,7538,40719,24,2,5453,'App\\Models\\Receipt',5453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5309.17,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5684,7538,40719,24,2,5454,'App\\Models\\Receipt',5454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',19029.00,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5685,7538,40719,24,2,5455,'App\\Models\\Receipt',5455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',38985.39,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5686,7538,40719,24,2,5456,'App\\Models\\Receipt',5456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5000.00,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5687,7538,40719,24,2,5457,'App\\Models\\Receipt',5457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2500.01,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5688,7538,40719,24,2,5458,'App\\Models\\Receipt',5458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',19869.00,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5689,7538,40719,24,2,5459,'App\\Models\\Receipt',5459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',48691.99,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5690,7538,40719,24,2,5460,'App\\Models\\Receipt',5460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',21929.89,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5691,7538,40719,24,2,5461,'App\\Models\\Receipt',5461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',25909.56,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5692,7538,40719,24,2,5462,'App\\Models\\Receipt',5462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',58069.13,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5693,7538,40719,24,2,5463,'App\\Models\\Receipt',5463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',5000.00,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5694,7538,40719,24,2,5464,'App\\Models\\Receipt',5464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',20700.00,NULL,NULL,1,'2022-08-16 21:58:37','2022-08-16 21:58:37',NULL),(5695,7538,40719,24,2,5465,'App\\Models\\Receipt',5465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',25063.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5696,7538,40719,24,2,5466,'App\\Models\\Receipt',5466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',19685.34,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5697,7538,40719,24,2,5467,'App\\Models\\Receipt',5467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',25753.33,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5698,7538,40719,24,2,5468,'App\\Models\\Receipt',5468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5600.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5699,7538,40719,24,2,5469,'App\\Models\\Receipt',5469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',16600.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5700,7538,40719,24,2,5470,'App\\Models\\Receipt',5470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',16325.93,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL);
INSERT INTO `balance_libro` VALUES (5701,7538,40719,24,2,5471,'App\\Models\\Receipt',5471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',46768.52,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5702,7538,40719,24,2,5472,'App\\Models\\Receipt',5472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1200.01,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5703,7538,40719,24,2,5473,'App\\Models\\Receipt',5473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3650.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5704,7538,40719,24,2,5474,'App\\Models\\Receipt',5474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6430.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5705,7538,40719,24,2,5475,'App\\Models\\Receipt',5475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',18156.69,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5706,7538,40719,24,2,5476,'App\\Models\\Receipt',5476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3050.52,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5707,7538,40719,24,2,5477,'App\\Models\\Receipt',5477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1144.41,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5708,7538,40719,24,2,5478,'App\\Models\\Receipt',5478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',21620.10,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5709,7538,40719,24,2,5479,'App\\Models\\Receipt',5479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',7000.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5710,7538,40719,24,2,5480,'App\\Models\\Receipt',5480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1280.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5711,7538,40719,24,2,5481,'App\\Models\\Receipt',5481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3600.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5712,7538,40719,24,2,5482,'App\\Models\\Receipt',5482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',700.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5713,7538,40719,24,2,5483,'App\\Models\\Receipt',5483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',20546.62,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5714,7538,40719,24,2,5484,'App\\Models\\Receipt',5484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2600.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5715,7538,40719,24,2,5485,'App\\Models\\Receipt',5485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',23063.11,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5716,7538,40719,24,2,5486,'App\\Models\\Receipt',5486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',34625.98,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5717,7538,40719,24,2,5487,'App\\Models\\Receipt',5487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3000.00,NULL,NULL,1,'2022-08-16 21:58:38','2022-08-16 21:58:38',NULL),(5718,7538,40719,24,2,5488,'App\\Models\\Receipt',5488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',101436.22,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5719,7538,40719,24,2,5489,'App\\Models\\Receipt',5489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5000.00,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5720,7538,40719,24,2,5490,'App\\Models\\Receipt',5490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',68145.30,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5721,7538,40719,24,2,5491,'App\\Models\\Receipt',5491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',68145.30,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL);
INSERT INTO `balance_libro` VALUES (5722,7538,40719,24,2,5492,'App\\Models\\Receipt',5492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',21461.50,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5723,7538,40719,24,2,5493,'App\\Models\\Receipt',5493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',29877.77,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5724,7538,40719,24,2,5494,'App\\Models\\Receipt',5494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',17980.62,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5725,7538,40719,24,2,5495,'App\\Models\\Receipt',5495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',20828.65,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5726,7538,40719,24,2,5496,'App\\Models\\Receipt',5496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',6700.00,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5727,7538,40719,24,2,5497,'App\\Models\\Receipt',5497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',34842.00,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5728,7538,40719,24,2,5498,'App\\Models\\Receipt',5498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',6400.00,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5729,7538,40719,24,2,5499,'App\\Models\\Receipt',5499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1200.01,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5730,7538,40719,24,2,5500,'App\\Models\\Receipt',5500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5499.99,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5731,7538,40719,24,2,5501,'App\\Models\\Receipt',5501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',36514.64,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5732,7538,40719,24,2,5502,'App\\Models\\Receipt',5502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',6500.00,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5733,7538,40719,24,2,5503,'App\\Models\\Receipt',5503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',19703.56,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5734,7538,40719,24,2,5504,'App\\Models\\Receipt',5504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4800.00,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5735,7538,40719,24,2,5505,'App\\Models\\Receipt',5505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',58100.00,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5736,7538,40719,24,2,5506,'App\\Models\\Receipt',5506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',4000.01,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5737,7538,40719,24,2,5507,'App\\Models\\Receipt',5507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',19843.49,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5738,7538,40719,24,2,5508,'App\\Models\\Receipt',5508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',3620.01,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5739,7538,40719,24,2,5509,'App\\Models\\Receipt',5509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',17977.49,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5740,7538,40719,24,2,5510,'App\\Models\\Receipt',5510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2300.00,NULL,NULL,1,'2022-08-16 21:58:39','2022-08-16 21:58:39',NULL),(5741,7538,40719,24,2,5511,'App\\Models\\Receipt',5511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',11400.00,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5742,7538,40719,24,2,5512,'App\\Models\\Receipt',5512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1150.00,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL);
INSERT INTO `balance_libro` VALUES (5743,7538,40719,24,2,5513,'App\\Models\\Receipt',5513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8500.00,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5744,7538,40719,24,2,5514,'App\\Models\\Receipt',5514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',24472.36,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5745,7538,40719,24,2,5515,'App\\Models\\Receipt',5515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6500.00,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5746,7538,40719,24,2,5516,'App\\Models\\Receipt',5516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2600.00,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5747,7538,40719,24,2,5517,'App\\Models\\Receipt',5517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',500.00,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5748,7538,40719,24,2,5518,'App\\Models\\Receipt',5518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6899.99,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5749,7538,40719,24,2,5519,'App\\Models\\Receipt',5519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18904.33,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5750,7538,40719,24,2,5520,'App\\Models\\Receipt',5520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',31411.95,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5751,7538,40719,24,2,5521,'App\\Models\\Receipt',5521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',26503.71,NULL,NULL,1,'2022-08-16 21:58:40','2022-08-16 21:58:40',NULL),(5752,7538,40719,24,3,5268,'App\\Models\\Receipt',5268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',15071.06,NULL,NULL,1,'2022-08-18 00:22:40','2022-08-18 00:22:40',NULL),(5753,7538,40719,24,7,5522,'App\\Models\\Receipt',5522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',566.41,NULL,NULL,1,'2022-08-18 00:27:27','2022-08-18 00:27:27',NULL),(5754,7538,40719,24,7,5523,'App\\Models\\Receipt',5523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',16738.97,NULL,NULL,1,'2022-08-18 00:28:44','2022-08-18 00:28:44',NULL),(5755,7538,40719,24,7,5524,'App\\Models\\Receipt',5524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2242.71,NULL,NULL,1,'2022-08-18 00:29:26','2022-08-18 00:29:26',NULL),(5756,7538,40719,24,16,932,'App\\Models\\PeriodLiquidation',NULL,932,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',32962.98,NULL,NULL,1,'2022-08-18 00:30:37','2022-08-18 00:30:37',NULL),(5757,7538,40719,24,15,931,'App\\Models\\PeriodLiquidation',NULL,931,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',471807.94,NULL,NULL,1,'2022-08-18 00:31:56','2022-08-18 00:31:56',NULL),(5758,7538,40719,25,3,5525,'App\\Models\\Receipt',5525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',98616.21,NULL,NULL,1,'2022-09-17 19:25:31','2022-09-17 19:25:31',NULL),(5759,7538,40719,25,3,5526,'App\\Models\\Receipt',5526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6180.23,NULL,NULL,1,'2022-09-17 19:25:31','2022-09-17 19:25:31',NULL),(5760,7538,40719,25,3,5527,'App\\Models\\Receipt',5527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',10075.84,NULL,NULL,1,'2022-09-17 19:25:31','2022-09-17 19:25:31',NULL),(5761,7538,40719,25,3,5528,'App\\Models\\Receipt',5528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',4284.01,NULL,NULL,1,'2022-09-17 19:25:31','2022-09-17 19:25:31',NULL),(5762,7538,40719,25,3,5529,'App\\Models\\Receipt',5529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6199.00,NULL,NULL,1,'2022-09-17 19:25:31','2022-09-17 19:25:31',NULL),(5763,7538,40719,25,3,5530,'App\\Models\\Receipt',5530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6199.00,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL);
INSERT INTO `balance_libro` VALUES (5764,7538,40719,25,3,5531,'App\\Models\\Receipt',5531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1000.00,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5765,7538,40719,25,3,5532,'App\\Models\\Receipt',5532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',31615.08,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5766,7538,40719,25,3,5533,'App\\Models\\Receipt',5533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',55663.19,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5767,7538,40719,25,3,5534,'App\\Models\\Receipt',5534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',10494.00,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5768,7538,40719,25,3,5535,'App\\Models\\Receipt',5535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',3276.00,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5769,7538,40719,25,3,5536,'App\\Models\\Receipt',5536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1267.00,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5770,7538,40719,25,3,5537,'App\\Models\\Receipt',5537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',36666.47,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5771,7538,40719,25,3,5538,'App\\Models\\Receipt',5538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',175.45,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5772,7538,40719,25,3,5539,'App\\Models\\Receipt',5539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',12400.00,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5773,7538,40719,25,3,5540,'App\\Models\\Receipt',5540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',3542.00,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5774,7538,40719,25,3,5541,'App\\Models\\Receipt',5541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',79961.64,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5775,7538,40719,25,3,5542,'App\\Models\\Receipt',5542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',10075.84,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5776,7538,40719,25,3,5543,'App\\Models\\Receipt',5543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',2000.01,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5777,7538,40719,25,3,5544,'App\\Models\\Receipt',5544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',2153.09,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5778,7538,40719,25,3,5545,'App\\Models\\Receipt',5545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',876.02,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5779,7538,40719,25,3,5546,'App\\Models\\Receipt',5546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',8327.37,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5780,7538,40719,25,3,5547,'App\\Models\\Receipt',5547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',20201.48,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5781,7538,40719,25,3,5548,'App\\Models\\Receipt',5548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',20988.91,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5782,7538,40719,25,3,5549,'App\\Models\\Receipt',5549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',13914.54,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5783,7538,40719,25,3,5550,'App\\Models\\Receipt',5550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',7870.00,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL),(5784,7538,40719,25,3,5551,'App\\Models\\Receipt',5551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',8913.50,NULL,NULL,1,'2022-09-17 19:25:32','2022-09-17 19:25:32',NULL);
INSERT INTO `balance_libro` VALUES (5785,7538,40719,25,3,5552,'App\\Models\\Receipt',5552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',48846.32,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5786,7538,40719,25,3,5553,'App\\Models\\Receipt',5553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',12291.79,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5787,7538,40719,25,3,5554,'App\\Models\\Receipt',5554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',8733.10,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5788,7538,40719,25,3,5555,'App\\Models\\Receipt',5555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2643.05,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5789,7538,40719,25,3,5556,'App\\Models\\Receipt',5556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',3870.00,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5790,7538,40719,25,3,5557,'App\\Models\\Receipt',5557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',20241.12,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5791,7538,40719,25,3,5558,'App\\Models\\Receipt',5558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',79721.78,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5792,7538,40719,25,3,5559,'App\\Models\\Receipt',5559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',10595.80,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5793,7538,40719,25,3,5560,'App\\Models\\Receipt',5560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',9420.99,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5794,7538,40719,25,3,5561,'App\\Models\\Receipt',5561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',7000.00,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5795,7538,40719,25,3,5562,'App\\Models\\Receipt',5562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',81958.66,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5796,7538,40719,25,3,5563,'App\\Models\\Receipt',5563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',1760.04,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5797,7538,40719,25,3,5564,'App\\Models\\Receipt',5564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',21672.39,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5798,7538,40719,25,3,5565,'App\\Models\\Receipt',5565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1514.00,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5799,7538,40719,25,3,5566,'App\\Models\\Receipt',5566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',3108.01,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5800,7538,40719,25,3,5567,'App\\Models\\Receipt',5567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',4438.00,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5801,7538,40719,25,3,5568,'App\\Models\\Receipt',5568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',22645.76,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5802,7538,40719,25,3,5569,'App\\Models\\Receipt',5569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',2100.00,NULL,NULL,1,'2022-09-17 19:25:33','2022-09-17 19:25:33',NULL),(5803,7538,40719,25,3,5570,'App\\Models\\Receipt',5570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',1760.02,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5804,7538,40719,25,3,5571,'App\\Models\\Receipt',5571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',22365.95,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5805,7538,40719,25,3,5572,'App\\Models\\Receipt',5572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',13751.17,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL);
INSERT INTO `balance_libro` VALUES (5806,7538,40719,25,3,5573,'App\\Models\\Receipt',5573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',5113.97,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5807,7538,40719,25,3,5574,'App\\Models\\Receipt',5574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',13418.19,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5808,7538,40719,25,3,5575,'App\\Models\\Receipt',5575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',777.46,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5809,7538,40719,25,3,5576,'App\\Models\\Receipt',5576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',10113.75,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5810,7538,40719,25,3,5577,'App\\Models\\Receipt',5577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',23211.18,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5811,7538,40719,25,3,5578,'App\\Models\\Receipt',5578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',5978.72,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5812,7538,40719,25,3,5579,'App\\Models\\Receipt',5579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',91611.52,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5813,7538,40719,25,3,5580,'App\\Models\\Receipt',5580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',361600.01,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5814,7538,40719,25,3,5581,'App\\Models\\Receipt',5581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',48045.21,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5815,7538,40719,25,3,5582,'App\\Models\\Receipt',5582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',5300.81,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5816,7538,40719,25,3,5583,'App\\Models\\Receipt',5583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2000.01,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5817,7538,40719,25,3,5584,'App\\Models\\Receipt',5584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',3624.00,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5818,7538,40719,25,3,5585,'App\\Models\\Receipt',5585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1907.04,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5819,7538,40719,25,3,5586,'App\\Models\\Receipt',5586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',11555.90,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5820,7538,40719,25,3,5587,'App\\Models\\Receipt',5587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',1000.00,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5821,7538,40719,25,3,5588,'App\\Models\\Receipt',5588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',8853.67,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5822,7538,40719,25,3,5589,'App\\Models\\Receipt',5589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',348000.01,NULL,NULL,1,'2022-09-17 19:25:34','2022-09-17 19:25:34',NULL),(5823,7538,40719,25,3,5590,'App\\Models\\Receipt',5590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',77198.00,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5824,7538,40719,25,3,5591,'App\\Models\\Receipt',5591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',42808.52,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5825,7538,40719,25,3,5592,'App\\Models\\Receipt',5592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',41750.88,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5826,7538,40719,25,3,5593,'App\\Models\\Receipt',5593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',5681.95,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL);
INSERT INTO `balance_libro` VALUES (5827,7538,40719,25,3,5594,'App\\Models\\Receipt',5594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',15157.31,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5828,7538,40719,25,3,5595,'App\\Models\\Receipt',5595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',90920.61,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5829,7538,40719,25,3,5596,'App\\Models\\Receipt',5596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',26181.22,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5830,7538,40719,25,3,5597,'App\\Models\\Receipt',5597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',2643.05,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5831,7538,40719,25,3,5598,'App\\Models\\Receipt',5598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',10890.00,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5832,7538,40719,25,3,5599,'App\\Models\\Receipt',5599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',10890.00,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5833,7538,40719,25,3,5600,'App\\Models\\Receipt',5600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',8099.99,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5834,7538,40719,25,3,5601,'App\\Models\\Receipt',5601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',1320.00,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5835,7538,40719,25,3,5602,'App\\Models\\Receipt',5602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',7516.00,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5836,7538,40719,25,3,5603,'App\\Models\\Receipt',5603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',924.00,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5837,7538,40719,25,3,5604,'App\\Models\\Receipt',5604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',4801.61,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5838,7538,40719,25,3,5605,'App\\Models\\Receipt',5605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',264000.00,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5839,7538,40719,25,3,5606,'App\\Models\\Receipt',5606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1320.00,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5840,7538,40719,25,3,5607,'App\\Models\\Receipt',5607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',21570.74,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5841,7538,40719,25,3,5608,'App\\Models\\Receipt',5608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',13361.26,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5842,7538,40719,25,3,5609,'App\\Models\\Receipt',5609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',3000.00,NULL,NULL,1,'2022-09-17 19:25:35','2022-09-17 19:25:35',NULL),(5843,7538,40719,25,3,5610,'App\\Models\\Receipt',5610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',68751.92,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5844,7538,40719,25,3,5611,'App\\Models\\Receipt',5611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',7389.00,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5845,7538,40719,25,3,5612,'App\\Models\\Receipt',5612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',20269.14,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5846,7538,40719,25,3,5613,'App\\Models\\Receipt',5613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',91090.42,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5847,7538,40719,25,3,5614,'App\\Models\\Receipt',5614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',33228.29,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL);
INSERT INTO `balance_libro` VALUES (5848,7538,40719,25,3,5615,'App\\Models\\Receipt',5615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',21753.72,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5849,7538,40719,25,3,5616,'App\\Models\\Receipt',5616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',31844.55,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5850,7538,40719,25,3,5617,'App\\Models\\Receipt',5617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',66104.20,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5851,7538,40719,25,3,5618,'App\\Models\\Receipt',5618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2643.05,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5852,7538,40719,25,3,5619,'App\\Models\\Receipt',5619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',43310.24,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5853,7538,40719,25,3,5620,'App\\Models\\Receipt',5620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1910.00,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5854,7538,40719,25,3,5621,'App\\Models\\Receipt',5621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',52288.94,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5855,7538,40719,25,3,5622,'App\\Models\\Receipt',5622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',600.00,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5856,7538,40719,25,3,5623,'App\\Models\\Receipt',5623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',34131.68,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5857,7538,40719,25,3,5624,'App\\Models\\Receipt',5624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5258.32,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5858,7538,40719,25,3,5625,'App\\Models\\Receipt',5625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',65047.69,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5859,7538,40719,25,3,5626,'App\\Models\\Receipt',5626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',10876.87,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5860,7538,40719,25,3,5627,'App\\Models\\Receipt',5627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',42137.38,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5861,7538,40719,25,3,5628,'App\\Models\\Receipt',5628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1187.40,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5862,7538,40719,25,3,5629,'App\\Models\\Receipt',5629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',11555.90,NULL,NULL,1,'2022-09-17 19:25:36','2022-09-17 19:25:36',NULL),(5863,7538,40719,25,2,5630,'App\\Models\\Receipt',5630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',20667.11,NULL,NULL,1,'2022-09-17 20:26:40','2022-09-17 20:26:40',NULL),(5864,7538,40719,25,2,5631,'App\\Models\\Receipt',5631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2600.00,NULL,NULL,1,'2022-09-17 20:26:40','2022-09-17 20:26:40',NULL),(5865,7538,40719,25,2,5632,'App\\Models\\Receipt',5632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',21136.85,NULL,NULL,1,'2022-09-17 20:26:40','2022-09-17 20:26:40',NULL),(5866,7538,40719,25,2,5633,'App\\Models\\Receipt',5633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',37578.49,NULL,NULL,1,'2022-09-17 20:26:40','2022-09-17 20:26:40',NULL),(5867,7538,40719,25,2,5634,'App\\Models\\Receipt',5634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',500.00,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5868,7538,40719,25,2,5635,'App\\Models\\Receipt',5635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',15927.75,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL);
INSERT INTO `balance_libro` VALUES (5869,7538,40719,25,2,5636,'App\\Models\\Receipt',5636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',38196.11,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5870,7538,40719,25,2,5637,'App\\Models\\Receipt',5637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',20602.02,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5871,7538,40719,25,2,5638,'App\\Models\\Receipt',5638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',6500.00,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5872,7538,40719,25,2,5639,'App\\Models\\Receipt',5639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',24920.22,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5873,7538,40719,25,2,5640,'App\\Models\\Receipt',5640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',92400.00,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5874,7538,40719,25,2,5641,'App\\Models\\Receipt',5641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',12842.86,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5875,7538,40719,25,2,5642,'App\\Models\\Receipt',5642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',28237.10,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5876,7538,40719,25,2,5643,'App\\Models\\Receipt',5643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',23516.41,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5877,7538,40719,25,2,5644,'App\\Models\\Receipt',5644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',7899.99,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5878,7538,40719,25,2,5645,'App\\Models\\Receipt',5645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',25829.00,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5879,7538,40719,25,2,5646,'App\\Models\\Receipt',5646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',11662.63,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5880,7538,40719,25,2,5647,'App\\Models\\Receipt',5647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',2600.00,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5881,7538,40719,25,2,5648,'App\\Models\\Receipt',5648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',6500.00,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5882,7538,40719,25,2,5649,'App\\Models\\Receipt',5649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',4908.99,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5883,7538,40719,25,2,5650,'App\\Models\\Receipt',5650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',4600.00,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5884,7538,40719,25,2,5651,'App\\Models\\Receipt',5651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',26911.92,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5885,7538,40719,25,2,5652,'App\\Models\\Receipt',5652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',9534.91,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5886,7538,40719,25,2,5653,'App\\Models\\Receipt',5653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',12374.36,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5887,7538,40719,25,2,5654,'App\\Models\\Receipt',5654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',6500.00,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5888,7538,40719,25,2,5655,'App\\Models\\Receipt',5655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',24277.06,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5889,7538,40719,25,2,5656,'App\\Models\\Receipt',5656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',18180.95,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL);
INSERT INTO `balance_libro` VALUES (5890,7538,40719,25,2,5657,'App\\Models\\Receipt',5657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',9711.47,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5891,7538,40719,25,2,5658,'App\\Models\\Receipt',5658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',8700.00,NULL,NULL,1,'2022-09-17 20:26:41','2022-09-17 20:26:41',NULL),(5892,7538,40719,25,2,5659,'App\\Models\\Receipt',5659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',6500.00,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5893,7538,40719,25,2,5660,'App\\Models\\Receipt',5660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',26522.93,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5894,7538,40719,25,2,5661,'App\\Models\\Receipt',5661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',41470.51,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5895,7538,40719,25,2,5662,'App\\Models\\Receipt',5662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',23970.12,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5896,7538,40719,25,2,5663,'App\\Models\\Receipt',5663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',7300.00,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5897,7538,40719,25,2,5664,'App\\Models\\Receipt',5664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',4500.00,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5898,7538,40719,25,2,5665,'App\\Models\\Receipt',5665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',30891.61,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5899,7538,40719,25,2,5666,'App\\Models\\Receipt',5666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',6500.00,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5900,7538,40719,25,2,5667,'App\\Models\\Receipt',5667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',27473.27,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5901,7538,40719,25,2,5668,'App\\Models\\Receipt',5668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',500.00,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5902,7538,40719,25,2,5669,'App\\Models\\Receipt',5669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',25380.58,NULL,NULL,1,'2022-09-17 20:26:42','2022-09-17 20:26:42',NULL),(5903,7538,40719,25,2,567