-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-18757950-4
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-03-04 13:31:49','Actividad Generica 1','000001',NULL),(2,NULL,'2021-03-04 13:31:49','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Ect391474ec',NULL,1,40818,'2021-05-26'),(2,NULL,'Ec391474',NULL,3,40818,'2021-05-26'),(3,NULL,'Etmiguel424',NULL,1,40821,'2021-05-26'),(4,NULL,'Miguel424',NULL,3,40821,'2021-05-26'),(5,NULL,'Mariela2021',NULL,1,40822,'2021-05-27'),(6,NULL,'Ec208410',NULL,3,40822,'2021-05-27'),(7,NULL,'Ameghino2020',NULL,1,40817,'2021-06-09'),(8,NULL,'123456',NULL,3,40817,'2021-06-09'),(9,NULL,'Holanda2021',NULL,1,40817,'2021-06-09'),(10,NULL,'123456',NULL,3,40817,'2021-06-09'),(11,NULL,'Holanda2021',NULL,1,40817,'2021-06-09'),(12,NULL,'123456',NULL,3,40817,'2021-06-09'),(13,NULL,'Holanda2021',NULL,1,40817,'2021-06-09'),(14,NULL,'123456',NULL,3,40817,'2021-06-09'),(15,NULL,'Holanda2021',NULL,1,40817,'2021-06-09'),(16,NULL,'123456',NULL,3,40817,'2021-06-09'),(17,NULL,'Holanda2021',NULL,1,40817,'2021-06-09'),(18,NULL,'123456',NULL,3,40817,'2021-06-09'),(19,NULL,'Holanda2021',NULL,1,40817,'2021-06-09'),(20,NULL,'123456',NULL,3,40817,'2021-06-09'),(21,NULL,'Virgi33448',NULL,1,40720,'2021-07-23'),(22,NULL,'Julio18757',NULL,1,40819,'2021-08-18'),(23,NULL,'Julio18757',NULL,1,40819,'2021-08-26'),(24,NULL,'Julio18757',NULL,1,40819,'2021-08-26'),(25,NULL,'Julio18757',NULL,1,40819,'2021-08-26'),(26,NULL,'Julio18757',NULL,1,40819,'2021-08-26'),(27,NULL,'Julio18757',NULL,1,40819,'2021-08-26'),(28,NULL,'Julio18757',NULL,1,40819,'2021-08-26'),(29,NULL,'Julio18757',NULL,1,40819,'2021-08-26'),(30,NULL,'Holanda2021',NULL,1,40817,'2021-09-03'),(31,NULL,'123456',NULL,3,40817,'2021-09-03'),(32,NULL,'Holanda2021',NULL,1,40817,'2021-09-03'),(33,NULL,'123456',NULL,3,40817,'2021-09-03'),(34,NULL,'Holanda2021',NULL,1,40817,'2021-09-03'),(35,NULL,'123456',NULL,3,40817,'2021-09-03'),(36,NULL,'Holanda2021',NULL,1,40817,'2021-09-03'),(37,NULL,'123456',NULL,3,40817,'2021-09-03'),(38,NULL,'Julio18757',NULL,1,40819,'2021-10-14'),(39,NULL,'Cesar18757',NULL,1,40819,'2021-10-14'),(40,NULL,'Cesar18757',NULL,1,40819,'2021-10-14'),(41,NULL,'Caliuru17',NULL,3,40819,'2021-10-14'),(42,NULL,'Virgi33448',NULL,1,40720,'2021-11-24'),(43,NULL,'Ect337306ec',NULL,3,40720,'2021-11-24'),(44,NULL,'Ect337306ec',NULL,1,40720,'2021-11-24'),(45,NULL,'Ect337306ec',NULL,3,40720,'2021-11-24'),(46,NULL,'Ect337306ec',NULL,1,40720,'2021-11-24'),(47,NULL,'Ect337306ec',NULL,3,40720,'2021-11-24'),(48,NULL,'Ect337306ec',NULL,1,40720,'2021-11-24'),(49,NULL,'Ect337306ec',NULL,3,40720,'2021-11-24'),(50,NULL,'Ect343007ec',NULL,1,40850,'2022-03-23'),(51,NULL,'Ect343007ec',NULL,3,40850,'2022-03-23'),(52,NULL,'Ec624165',NULL,3,40854,'2022-08-16'),(53,NULL,'Ect851002ec',NULL,1,40845,'2022-08-16'),(54,NULL,'Ect851002ec',NULL,3,40845,'2022-08-16'),(55,NULL,'Ect343007ec',NULL,1,40850,'2022-08-16'),(56,NULL,'Ect343007ec',NULL,3,40850,'2022-08-16'),(57,NULL,'Ect832271ec',NULL,1,40820,'2022-08-16'),(58,NULL,'Mati2806',NULL,3,40820,'2022-08-16'),(59,NULL,'Ec624165',NULL,3,40854,'2022-08-16'),(60,NULL,'Fucmil7523',NULL,1,40847,'2023-03-01'),(61,NULL,'Ect850996ec',NULL,1,40848,'2023-03-01'),(62,NULL,'Ect318509',NULL,3,40848,'2023-03-01'),(63,NULL,'Ect343007ec',NULL,1,40850,'2023-03-01'),(64,NULL,'Ect343007ec',NULL,3,40850,'2023-03-01'),(65,NULL,'Eclaura2021',NULL,1,40851,'2023-03-01'),(66,NULL,'Ec144910',NULL,3,40851,'2023-03-01'),(67,NULL,'Ect360944ec',NULL,1,40852,'2023-03-01'),(68,NULL,'Ect360944ec',NULL,3,40852,'2023-03-01'),(69,NULL,'Vismargarita2021',NULL,1,40853,'2023-03-01'),(70,NULL,'Ect148490',NULL,3,40853,'2023-03-01'),(71,NULL,'Ec624165',NULL,3,40854,'2023-03-01'),(72,NULL,'Ect141568ec',NULL,1,40846,'2023-03-01'),(73,NULL,'Maria080960',NULL,3,40846,'2023-03-01'),(74,NULL,'Ect851002ec',NULL,1,40845,'2023-03-01'),(75,NULL,'Ect851002ec',NULL,3,40845,'2023-03-01'),(76,NULL,'Ect832271ec',NULL,1,40820,'2023-03-01'),(77,NULL,'Mati2806',NULL,3,40820,'2023-03-01'),(78,NULL,'Ect851002ec',NULL,1,40845,'2023-03-01'),(79,NULL,'Ect851002ec',NULL,3,40845,'2023-03-01'),(80,NULL,'Etmiguel424',NULL,1,40821,'2023-03-01'),(81,NULL,'Miguel424',NULL,3,40821,'2023-03-01');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'estudio.tejeramartinez@gmail.com','03329-15542574',NULL,1,40719,'2021-05-25'),(2,'estudio.tejeramartinez@gmail.com','03329-15542574','',1,40719,'2021-05-25'),(3,'estudio.tejeramartinez@gmail.com','03329-15542574','',1,40719,'2021-05-25'),(8,'estudio.tejeramartinez@gmail.com','03329-15542574','',1,40719,'2021-05-25'),(9,'ginovirgullito1331@gmail.com',NULL,'',1,40719,'2021-05-25'),(10,'ginovirgillito1331@gmail.com','0332915697421','',1,40720,'2021-05-28'),(11,'ginovirgillito1331@gmail.com','0332915697421','',1,40720,'2021-05-28'),(12,'ginovirgillito1331@gmail.com','0332915697421','',1,40720,'2021-05-28'),(13,'ginovirgillito1331@gmail.com','0332915697421','',1,40720,'2021-05-28'),(14,'ginovirgillito1331@gmail.com','0332915697421','',1,40720,'2021-06-01'),(15,'ginovirgillito1331@gmail.com','0332915697421','',1,40720,'2021-07-23'),(16,'ginovirgillito1331@gmail.com','0332915697421',NULL,1,40720,'2021-07-23'),(17,'adm.soluciones@gmail.com','03329-15542574',NULL,1,40819,'2021-08-26'),(18,'adm.soluciones@gmail.com','03329-15542574','',1,40819,'2021-08-26'),(19,'adm.soluciones@gmail.com','03329-15542574','',1,40819,'2021-08-26'),(20,'adm.soluciones@gmail.com','03329-15542574','',1,40819,'2021-08-26'),(21,'adm.soluciones@gmail.com','03329-15542574','',1,40819,'2021-08-26'),(22,'adm.soluciones@gmail.com','03329-15542574','',1,40819,'2021-08-26'),(23,'adm.soluciones@gmail.com','03329-15542574','',1,40819,'2021-08-26'),(24,'adm.soluciones@gmail.com','03329-15542574','',1,40819,'2021-10-14'),(25,'adm.soluciones@gmail.com','03329-15542574','',1,40819,'2021-10-14'),(26,'adm.soluciones@gmail.com','03329-15542574','',1,40819,'2021-10-14'),(27,'ginovirgillito1331@gmail.com','0332915697421',NULL,1,40720,'2021-11-24'),(28,'ginovirgillito1331@gmail.com','0332915697421',NULL,1,40720,'2021-11-24'),(29,'ginovirgillito1331@gmail.com','0332915697421','',1,40720,'2021-11-24'),(30,'ginovirgillito1331@gmail.com','0332915697421','',1,40720,'2021-11-24'),(31,'estudio.tejeramamartinez@gmail.com',NULL,'',1,40719,'2023-03-02');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5791 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,3022,40720,1530,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',6629.76,NULL,NULL,1,'2021-05-28 13:27:19','2021-05-28 13:27:19',NULL),(2,3022,40720,1530,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2002.00,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(3,3022,40720,1530,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2994.83,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(4,3022,40720,1530,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',225.06,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(5,3022,40720,1530,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1649.85,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(6,3022,40720,1530,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',32276.09,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(7,3022,40720,1530,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1377.65,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(8,3022,40720,1530,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2279.99,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(9,3022,40720,1530,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',23481.25,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(10,3022,40720,1530,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',822.19,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(11,3022,40720,1530,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1847.39,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(12,3022,40720,1530,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',265.50,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(13,3022,40720,1530,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',15631.68,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(14,3022,40720,1530,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',562.83,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(15,3022,40720,1530,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',2013.99,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(16,3022,40720,1530,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',2246.29,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(17,3022,40720,1530,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',4808.16,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(18,3022,40720,1530,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',20779.07,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(19,3022,40720,1530,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2568.55,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(20,3022,40720,1530,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',27072.50,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(21,3022,40720,1530,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1308.81,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(22,3022,40720,1530,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',885.55,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL);
INSERT INTO `balance_libro` VALUES (23,3022,40720,1530,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2570.00,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(24,3022,40720,1530,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1084.31,NULL,NULL,1,'2021-05-28 14:46:15','2021-05-28 14:46:15',NULL),(25,3022,40720,1530,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1700.65,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(26,3022,40720,1530,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1240.48,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(27,3022,40720,1530,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4533.74,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(28,3022,40720,1530,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2799.97,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(29,3022,40720,1530,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',6842.76,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(30,3022,40720,1530,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',6842.76,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(31,3022,40720,1530,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2179.74,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(32,3022,40720,1530,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2379.39,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(33,3022,40720,1530,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',1181.70,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(34,3022,40720,1530,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',7094.91,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(35,3022,40720,1530,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1692.00,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(36,3022,40720,1530,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',46471.53,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(37,3022,40720,1530,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',3917.00,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(38,3022,40720,1530,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1861.85,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(39,3022,40720,1530,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',913.25,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(40,3022,40720,1530,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',4496.92,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(41,3022,40720,1530,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2761.51,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(42,3022,40720,1530,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',0.01,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(43,3022,40720,1530,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2132.02,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL);
INSERT INTO `balance_libro` VALUES (44,3022,40720,1530,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2789.73,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(45,3022,40720,1530,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2743.95,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:56:07','2021-05-28 14:56:07'),(46,3022,40720,1530,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',913.25,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(47,3022,40720,1530,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',9312.49,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(48,3022,40720,1530,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',228.61,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(49,3022,40720,1530,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2231.02,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(50,3022,40720,1530,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1407.71,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(51,3022,40720,1530,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',4659.65,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(52,3022,40720,1530,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1679.90,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(53,3022,40720,1530,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',3317.72,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(54,3022,40720,1530,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',48694.28,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(55,3022,40720,1530,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',859.51,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(56,3022,40720,1530,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',775.00,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(57,3022,40720,1530,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5441.55,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(58,3022,40720,1530,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3392.22,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(59,3022,40720,1530,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',5214.96,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(60,3022,40720,1530,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3175.42,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(61,3022,40720,1530,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',8192.97,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(62,3022,40720,1530,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',6898.34,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(63,3022,40720,1530,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',411.40,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL),(64,3022,40720,1530,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',2460.37,NULL,NULL,1,'2021-05-28 14:46:16','2021-05-28 14:46:16',NULL);
INSERT INTO `balance_libro` VALUES (65,3022,40720,1530,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',214.71,NULL,NULL,1,'2021-05-28 14:46:17','2021-05-28 14:46:17',NULL),(66,3022,40720,1530,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1108.26,NULL,NULL,1,'2021-05-28 14:46:17','2021-05-28 14:46:17',NULL),(67,3022,40720,1530,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',3500.00,NULL,NULL,1,'2021-05-28 14:46:17','2021-05-28 14:46:17',NULL),(68,3022,40720,1530,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1066.28,NULL,NULL,1,'2021-05-28 14:46:17','2021-05-28 14:46:17',NULL),(69,3022,40720,1530,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',40028.62,NULL,NULL,1,'2021-05-28 14:46:17','2021-05-28 14:46:17',NULL),(70,3022,40720,1530,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',853.05,NULL,NULL,1,'2021-05-28 14:46:17','2021-05-28 14:46:17',NULL),(71,3022,40720,1530,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5046.73,NULL,NULL,1,'2021-05-28 14:46:17','2021-05-28 14:46:17',NULL),(72,3022,40720,1530,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1149.00,NULL,NULL,1,'2021-05-28 14:46:17','2021-05-28 14:46:17',NULL),(73,3022,40720,1530,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2743.96,NULL,NULL,1,'2021-05-28 14:56:07','2021-05-28 14:56:07',NULL),(74,3022,40720,1530,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',17146.34,NULL,NULL,1,'2021-05-28 15:10:20','2021-05-28 20:37:45','2021-05-28 20:37:45'),(75,3022,40720,1530,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',8460.66,NULL,NULL,1,'2021-05-28 15:12:37','2021-05-28 20:38:06','2021-05-28 20:38:06'),(76,3022,40720,1530,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',17096.67,NULL,NULL,1,'2021-05-28 15:16:05','2021-05-28 20:38:12','2021-05-28 20:38:12'),(77,3022,40720,1530,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',16148.80,NULL,NULL,1,'2021-05-28 15:17:23','2021-05-28 20:41:16','2021-05-28 20:41:16'),(78,3022,40720,1530,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',18196.43,NULL,NULL,1,'2021-05-28 15:18:24','2021-05-28 20:41:22','2021-05-28 20:41:22'),(79,3022,40720,1530,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',17611.00,NULL,NULL,1,'2021-05-28 15:19:42','2021-05-28 20:42:06','2021-05-28 20:42:06'),(80,3022,40720,1530,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',12233.59,NULL,NULL,1,'2021-05-28 15:21:51','2021-05-28 20:42:00','2021-05-28 20:42:00'),(81,3022,40720,1530,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',8875.46,NULL,NULL,1,'2021-05-28 15:22:49','2021-05-28 20:42:19','2021-05-28 20:42:19'),(82,3022,40720,1530,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',19574.38,NULL,NULL,1,'2021-05-28 15:24:11','2021-05-28 15:52:21','2021-05-28 15:52:21'),(83,3022,40720,1530,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',11616.71,NULL,NULL,1,'2021-05-28 15:25:02','2021-05-28 15:53:16','2021-05-28 15:53:16'),(84,3022,40720,1530,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',17165.99,NULL,NULL,1,'2021-05-28 15:26:43','2021-05-28 15:54:32','2021-05-28 15:54:32');
INSERT INTO `balance_libro` VALUES (85,3022,40720,1530,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',11005.73,NULL,NULL,1,'2021-05-28 15:27:35','2021-05-28 20:39:47','2021-05-28 20:39:47'),(86,3022,40720,1530,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',16514.76,NULL,NULL,1,'2021-05-28 15:28:42','2021-05-28 20:40:53','2021-05-28 20:40:53'),(87,3022,40720,1530,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',17239.62,NULL,NULL,1,'2021-05-28 15:29:53','2021-05-28 20:40:48','2021-05-28 20:40:48'),(88,3022,40720,1530,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',15214.39,NULL,NULL,1,'2021-05-28 15:31:10','2021-05-28 20:40:43','2021-05-28 20:40:43'),(89,3022,40720,1530,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',17593.25,NULL,NULL,1,'2021-05-28 15:32:15','2021-05-28 20:39:39','2021-05-28 20:39:39'),(90,3022,40720,1530,2,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',18228.03,NULL,NULL,1,'2021-05-28 15:33:12','2021-05-28 20:40:38','2021-05-28 20:40:38'),(91,3022,40720,1530,2,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',19688.20,NULL,NULL,1,'2021-05-28 15:34:11','2021-05-28 20:39:29','2021-05-28 20:39:29'),(92,3022,40720,1530,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',16893.24,NULL,NULL,1,'2021-05-28 15:35:11','2021-05-28 20:39:23','2021-05-28 20:39:23'),(93,3022,40720,1530,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',17573.05,NULL,NULL,1,'2021-05-28 15:36:09','2021-05-28 20:39:17','2021-05-28 20:39:17'),(94,3022,40720,1530,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',12012.24,NULL,NULL,1,'2021-05-28 15:53:16','2021-05-28 15:53:39','2021-05-28 15:53:39'),(95,3022,40720,1530,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',19574.38,NULL,NULL,1,'2021-05-28 15:53:39','2021-05-28 20:40:58','2021-05-28 20:40:58'),(96,3022,40720,1530,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',11616.71,NULL,NULL,1,'2021-05-28 15:54:32','2021-05-28 20:39:55','2021-05-28 20:39:55'),(97,3022,40720,1530,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3405.74,NULL,NULL,1,'2021-05-28 20:44:51','2021-05-28 21:12:45','2021-05-28 21:12:45'),(98,3022,40720,1530,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',1662.42,NULL,NULL,1,'2021-05-28 20:45:45','2021-05-28 21:13:53','2021-05-28 21:13:53'),(99,3022,40720,1530,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3526.35,NULL,NULL,1,'2021-05-28 20:46:23','2021-05-28 21:14:51','2021-05-28 21:14:51'),(100,3022,40720,1530,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',3086.32,NULL,NULL,1,'2021-05-28 20:48:14','2021-05-28 21:15:41','2021-05-28 21:15:41'),(101,3022,40720,1530,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3728.60,NULL,NULL,1,'2021-05-28 20:48:53','2021-05-28 21:16:27','2021-05-28 21:16:27'),(102,3022,40720,1530,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',3559.12,NULL,NULL,1,'2021-05-28 20:49:12','2021-05-28 21:17:06','2021-05-28 21:17:06'),(103,3022,40720,1530,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',2390.50,NULL,NULL,1,'2021-05-28 20:49:52','2021-05-28 21:17:50','2021-05-28 21:17:50');
INSERT INTO `balance_libro` VALUES (104,3022,40720,1530,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1765.60,NULL,NULL,1,'2021-05-28 20:50:28','2021-05-28 21:18:24','2021-05-28 21:18:24'),(105,3022,40720,1530,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',0.01,NULL,NULL,1,'2021-05-28 20:50:48','2021-05-28 20:52:13','2021-05-28 20:52:13'),(106,3022,40720,1530,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',3961.72,NULL,NULL,1,'2021-05-28 20:53:53','2021-05-28 21:20:32','2021-05-28 21:20:32'),(107,3022,40720,1530,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2332.14,NULL,NULL,1,'2021-05-28 20:55:57','2021-05-28 21:21:10','2021-05-28 21:21:10'),(108,3022,40720,1530,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3389.15,NULL,NULL,1,'2021-05-28 20:56:36','2021-05-28 21:21:48','2021-05-28 21:21:48'),(109,3022,40720,1530,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',2259.41,NULL,NULL,1,'2021-05-28 20:57:08','2021-05-28 21:23:17','2021-05-28 21:23:17'),(110,3022,40720,1530,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',3351.41,NULL,NULL,1,'2021-05-28 20:58:31','2021-05-28 21:24:25','2021-05-28 21:24:25'),(111,3022,40720,1530,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',3507.34,NULL,NULL,1,'2021-05-28 20:58:57','2021-05-28 21:25:12','2021-05-28 21:25:12'),(112,3022,40720,1530,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',3170.70,NULL,NULL,1,'2021-05-28 20:59:14','2021-05-28 21:25:45','2021-05-28 21:25:45'),(113,3022,40720,1530,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',3632.82,NULL,NULL,1,'2021-05-28 20:59:50','2021-05-28 21:26:32','2021-05-28 21:26:32'),(114,3022,40720,1530,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',3584.15,NULL,NULL,1,'2021-05-28 21:00:18','2021-05-28 21:27:00','2021-05-28 21:27:00'),(115,3022,40720,1530,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3743.03,NULL,NULL,1,'2021-05-28 21:00:50','2021-05-28 21:27:49','2021-05-28 21:27:49'),(116,3022,40720,1530,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',36.07,NULL,NULL,1,'2021-05-28 21:01:00','2021-05-28 21:01:26','2021-05-28 21:01:26'),(117,3022,40720,1530,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3828.42,NULL,NULL,1,'2021-05-28 21:01:26','2021-05-28 21:29:27','2021-05-28 21:29:27'),(118,3022,40720,1530,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',3431.75,NULL,NULL,1,'2021-05-28 21:03:18','2021-05-28 21:29:59','2021-05-28 21:29:59'),(119,3022,40720,1530,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3425.03,NULL,NULL,1,'2021-05-28 21:03:45','2021-05-28 21:09:26','2021-05-28 21:09:26'),(120,3022,40720,1530,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',15311.60,NULL,NULL,1,'2021-05-28 21:09:26','2021-05-28 21:09:46','2021-05-28 21:09:46'),(121,3022,40720,1530,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',17573.05,NULL,NULL,1,'2021-05-28 21:09:46','2021-05-28 22:09:06','2021-05-28 22:09:06'),(122,3022,40720,1530,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',17086.95,NULL,NULL,1,'2021-05-28 21:12:45','2021-05-31 12:49:53','2021-05-31 12:49:53');
INSERT INTO `balance_libro` VALUES (123,3022,40720,1530,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',8460.66,NULL,NULL,1,'2021-05-28 21:13:53','2021-05-31 12:55:33','2021-05-31 12:55:33'),(124,3022,40720,1530,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',17096.67,NULL,NULL,1,'2021-05-28 21:14:51','2021-05-31 12:56:42','2021-05-31 12:56:42'),(125,3022,40720,1530,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',16148.80,NULL,NULL,1,'2021-05-28 21:15:41','2021-05-31 12:57:44','2021-05-31 12:57:44'),(126,3022,40720,1530,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',18196.42,NULL,NULL,1,'2021-05-28 21:16:27','2021-05-31 12:58:25','2021-05-31 12:58:25'),(127,3022,40720,1530,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',17611.00,NULL,NULL,1,'2021-05-28 21:17:06','2021-05-31 13:02:00','2021-05-31 13:02:00'),(128,3022,40720,1530,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',12233.58,NULL,NULL,1,'2021-05-28 21:17:50','2021-05-31 13:03:10','2021-05-31 13:03:10'),(129,3022,40720,1530,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',8875.48,NULL,NULL,1,'2021-05-28 21:18:24','2021-05-31 13:03:49','2021-05-31 13:03:49'),(130,3022,40720,1530,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',19574.39,NULL,NULL,1,'2021-05-28 21:20:32','2021-05-31 13:07:53','2021-05-31 13:07:53'),(131,3022,40720,1530,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',11616.71,NULL,NULL,1,'2021-05-28 21:21:10','2021-05-28 21:57:33','2021-05-28 21:57:33'),(132,3022,40720,1530,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',17166.00,NULL,NULL,1,'2021-05-28 21:21:48','2021-05-28 21:50:46','2021-05-28 21:50:46'),(133,3022,40720,1530,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',11005.72,NULL,NULL,1,'2021-05-28 21:23:17','2021-05-31 13:09:49','2021-05-31 13:09:49'),(134,3022,40720,1530,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',16514.76,NULL,NULL,1,'2021-05-28 21:24:25','2021-05-31 13:10:40','2021-05-31 13:10:40'),(135,3022,40720,1530,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',17239.62,NULL,NULL,1,'2021-05-28 21:25:12','2021-05-31 13:11:21','2021-05-31 13:11:21'),(136,3022,40720,1530,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',15214.38,NULL,NULL,1,'2021-05-28 21:25:45','2021-05-28 22:18:09','2021-05-28 22:18:09'),(137,3022,40720,1530,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',17593.24,NULL,NULL,1,'2021-05-28 21:26:32','2021-05-28 22:16:50','2021-05-28 22:16:50'),(138,3022,40720,1530,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',18228.04,NULL,NULL,1,'2021-05-28 21:27:00','2021-05-28 22:16:14','2021-05-28 22:16:14'),(139,3022,40720,1530,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',18118.05,NULL,NULL,1,'2021-05-28 21:27:49','2021-05-28 22:15:30','2021-05-28 22:15:30'),(140,3022,40720,1530,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',19100.00,NULL,NULL,1,'2021-05-28 21:29:27','2021-05-31 13:13:18','2021-05-31 13:13:18'),(141,3022,40720,1530,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',16893.24,NULL,NULL,1,'2021-05-28 21:29:59','2021-05-28 22:10:01','2021-05-28 22:10:01');
INSERT INTO `balance_libro` VALUES (142,3022,40720,1530,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',20554.75,NULL,NULL,1,'2021-05-28 21:50:46','2021-05-28 21:52:36','2021-05-28 21:52:36'),(143,3022,40720,1530,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',20554.75,NULL,NULL,1,'2021-05-28 21:52:36','2021-05-28 21:52:36',NULL),(144,3022,40720,1530,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',13948.85,NULL,NULL,1,'2021-05-28 21:57:33','2021-05-28 21:57:33',NULL),(145,3022,40720,1530,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',20998.08,NULL,NULL,1,'2021-05-28 22:09:06','2021-05-31 18:17:10','2021-05-31 18:17:10'),(146,3022,40720,1530,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',20324.99,NULL,NULL,1,'2021-05-28 22:10:01','2021-05-31 18:20:02','2021-05-31 18:20:02'),(147,3022,40720,1530,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',21861.08,NULL,NULL,1,'2021-05-28 22:15:30','2021-05-31 19:08:39','2021-05-31 19:08:39'),(148,3022,40720,1530,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',21812.19,NULL,NULL,1,'2021-05-28 22:16:14','2021-05-31 19:10:26','2021-05-31 19:10:26'),(149,3022,40720,1530,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',21226.06,NULL,NULL,1,'2021-05-28 22:16:50','2021-05-31 19:31:36','2021-05-31 19:31:36'),(150,3022,40720,1530,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',18385.07,NULL,NULL,1,'2021-05-28 22:18:09','2021-05-31 19:35:53','2021-05-31 19:35:53'),(151,3022,40720,1530,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',20480.21,NULL,NULL,1,'2021-05-31 12:49:53','2021-05-31 12:50:47','2021-05-31 12:50:47'),(152,3022,40720,1530,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',20479.48,NULL,NULL,1,'2021-05-31 12:50:47','2021-05-31 12:52:17','2021-05-31 12:52:17'),(153,3022,40720,1530,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',20552.08,NULL,NULL,1,'2021-05-31 12:52:17','2021-05-31 12:52:17',NULL),(154,3022,40720,1530,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',10123.08,NULL,NULL,1,'2021-05-31 12:55:33','2021-05-31 12:55:33',NULL),(155,3022,40720,1530,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',20623.02,NULL,NULL,1,'2021-05-31 12:56:42','2021-05-31 12:56:42',NULL),(156,3022,40720,1530,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',19235.12,NULL,NULL,1,'2021-05-31 12:57:44','2021-05-31 12:57:44',NULL),(157,3022,40720,1530,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',21925.03,NULL,NULL,1,'2021-05-31 12:58:25','2021-05-31 12:59:07','2021-05-31 12:59:07'),(158,3022,40720,1530,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',26426.91,NULL,NULL,1,'2021-05-31 12:59:07','2021-05-31 13:00:52','2021-05-31 13:00:52'),(159,3022,40720,1530,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',21925.03,NULL,NULL,1,'2021-05-31 13:00:52','2021-05-31 13:00:52',NULL),(160,3022,40720,1530,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',21170.09,NULL,NULL,1,'2021-05-31 13:02:00','2021-05-31 13:02:00',NULL),(161,3022,40720,1530,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',14624.08,NULL,NULL,1,'2021-05-31 13:03:10','2021-05-31 13:03:10',NULL);
INSERT INTO `balance_libro` VALUES (162,3022,40720,1530,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',10641.08,NULL,NULL,1,'2021-05-31 13:03:49','2021-05-31 13:03:49',NULL),(163,3022,40720,1530,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',23536.11,NULL,NULL,1,'2021-05-31 13:07:53','2021-05-31 13:07:53',NULL),(164,3022,40720,1530,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',13265.13,NULL,NULL,1,'2021-05-31 13:09:49','2021-05-31 13:09:49',NULL),(165,3022,40720,1530,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',19866.17,NULL,NULL,1,'2021-05-31 13:10:40','2021-05-31 13:10:40',NULL),(166,3022,40720,1530,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',20746.96,NULL,NULL,1,'2021-05-31 13:11:21','2021-06-01 17:58:46','2021-06-01 17:58:46'),(167,3022,40720,1530,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',23111.00,NULL,NULL,1,'2021-05-31 13:13:18','2021-05-31 19:21:58','2021-05-31 19:21:58'),(168,3022,40720,1530,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',34832.16,NULL,NULL,1,'2021-05-31 18:17:10','2021-05-31 18:17:36','2021-05-31 18:17:36'),(169,3022,40720,1530,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',19683.53,NULL,NULL,1,'2021-05-31 18:17:36','2021-05-31 18:19:34','2021-05-31 18:19:34'),(170,3022,40720,1530,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',19683.53,NULL,NULL,1,'2021-05-31 18:19:34','2021-06-01 17:45:51','2021-06-01 17:45:51'),(171,3022,40720,1530,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',18782.86,NULL,NULL,1,'2021-05-31 18:20:02','2021-06-01 17:46:48','2021-06-01 17:46:48'),(172,3022,40720,1530,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',40581.63,NULL,NULL,1,'2021-05-31 19:08:39','2021-05-31 19:09:27','2021-05-31 19:09:27'),(173,3022,40720,1530,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',21861.08,NULL,NULL,1,'2021-05-31 19:09:27','2021-06-01 17:52:07','2021-06-01 17:52:07'),(174,3022,40720,1530,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',20385.72,NULL,NULL,1,'2021-05-31 19:10:26','2021-05-31 19:31:02','2021-05-31 19:31:02'),(175,3022,40720,1530,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',666.03,NULL,NULL,1,'2021-05-31 19:21:58','2021-05-31 19:22:22','2021-05-31 19:22:22'),(176,3022,40720,1530,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',4253.69,NULL,NULL,1,'2021-05-31 19:22:22','2021-06-01 17:48:30','2021-06-01 17:48:30'),(177,3022,40720,1530,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',20385.72,NULL,NULL,1,'2021-05-31 19:31:02','2021-06-01 17:53:09','2021-06-01 17:53:09'),(178,3022,40720,1530,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',19502.29,NULL,NULL,1,'2021-05-31 19:31:36','2021-05-31 19:35:07','2021-05-31 19:35:07'),(179,3022,40720,1530,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',19502.29,NULL,NULL,1,'2021-05-31 19:35:07','2021-06-01 17:57:57','2021-06-01 17:57:57'),(180,3022,40720,1530,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',16836.22,NULL,NULL,1,'2021-05-31 19:35:53','2021-06-01 17:57:33','2021-06-01 17:57:33'),(181,3022,40720,1530,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',19683.53,NULL,NULL,1,'2021-06-01 17:45:51','2021-06-01 17:45:51',NULL);
INSERT INTO `balance_libro` VALUES (182,3022,40720,1530,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',18782.86,NULL,NULL,1,'2021-06-01 17:46:48','2021-06-01 17:46:48',NULL),(183,3022,40720,1530,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',21436.92,NULL,NULL,1,'2021-06-01 17:48:30','2021-06-01 17:50:46','2021-06-01 17:50:46'),(184,3022,40720,1530,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',21436.92,NULL,NULL,1,'2021-06-01 17:50:46','2021-06-01 17:50:46',NULL),(185,3022,40720,1530,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',40581.63,NULL,NULL,1,'2021-06-01 17:52:07','2021-06-01 17:52:31','2021-06-01 17:52:31'),(186,3022,40720,1530,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',20082.21,NULL,NULL,1,'2021-06-01 17:52:31','2021-06-01 17:52:31',NULL),(187,3022,40720,1530,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',20385.72,NULL,NULL,1,'2021-06-01 17:53:09','2021-06-01 17:53:09',NULL),(188,3022,40720,1530,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',16836.22,NULL,NULL,1,'2021-06-01 17:57:33','2021-06-01 17:57:33',NULL),(189,3022,40720,1530,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',19502.29,NULL,NULL,1,'2021-06-01 17:57:57','2021-06-01 17:57:57',NULL),(190,3022,40720,1530,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',20746.96,NULL,NULL,1,'2021-06-01 17:58:46','2021-06-01 17:58:46',NULL),(191,3022,40817,148486,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',4635.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(192,3022,40817,148486,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',3740.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(193,3022,40817,148486,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',2000.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(194,3022,40817,148486,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',6634.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(195,3022,40817,148486,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',7830.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(196,3022,40817,148486,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',5615.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(197,3022,40817,148486,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1078.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(198,3022,40817,148486,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',5530.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(199,3022,40817,148486,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3680.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(200,3022,40817,148486,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',1900.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(201,3022,40817,148486,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',6000.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(202,3022,40817,148486,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',2290.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL);
INSERT INTO `balance_libro` VALUES (203,3022,40817,148486,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5615.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(204,3022,40817,148486,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',2470.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(205,3022,40817,148486,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',913.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(206,3022,40817,148486,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',6150.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(207,3022,40817,148486,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',3000.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(208,3022,40817,148486,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',2377.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(209,3022,40817,148486,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5000.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(210,3022,40817,148486,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5000.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(211,3022,40817,148486,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',7000.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(212,3022,40817,148486,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',3000.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(213,3022,40817,148486,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',440.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(214,3022,40817,148486,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',1630.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(215,3022,40817,148486,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',6700.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(216,3022,40817,148486,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',1078.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(217,3022,40817,148486,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',4365.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(218,3022,40817,148486,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',820.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(219,3022,40817,148486,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',7600.00,NULL,NULL,1,'2021-06-09 15:40:03','2021-06-09 15:40:03',NULL),(220,3022,40817,148486,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',4740.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(221,3022,40817,148486,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',3890.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(222,3022,40817,148486,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',7404.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(223,3022,40817,148486,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',2810.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL);
INSERT INTO `balance_libro` VALUES (224,3022,40817,148486,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',6000.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(225,3022,40817,148486,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',2818.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(226,3022,40817,148486,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',840.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(227,3022,40817,148486,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3740.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(228,3022,40817,148486,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',4890.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(229,3022,40817,148486,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3470.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(230,3022,40817,148486,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',7820.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(231,3022,40817,148486,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2220.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(232,3022,40817,148486,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',2570.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(233,3022,40817,148486,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',3980.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(234,3022,40817,148486,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',3840.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(235,3022,40817,148486,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1130.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(236,3022,40817,148486,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1730.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(237,3022,40817,148486,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',6465.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(238,3022,40817,148486,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',3265.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(239,3022,40817,148486,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',5641.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(240,3022,40817,148486,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1625.00,NULL,NULL,1,'2021-06-09 15:40:04','2021-06-09 15:40:04',NULL),(241,3022,40817,148486,16,295,'App\\Models\\PeriodLiquidation',NULL,295,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',4874.45,NULL,NULL,1,'2021-06-09 16:04:50','2021-06-09 16:06:04','2021-06-09 16:06:04'),(242,3022,40817,148486,16,299,'App\\Models\\PeriodLiquidation',NULL,299,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',4874.45,NULL,NULL,1,'2021-06-09 16:08:27','2021-06-09 16:08:27',NULL),(243,3022,40720,1531,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',20322.99,NULL,NULL,1,'2021-06-11 15:30:31','2021-06-11 15:31:26','2021-06-11 15:31:26'),(244,3022,40720,1531,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',20322.99,NULL,NULL,1,'2021-06-11 15:31:26','2021-06-11 15:31:26',NULL);
INSERT INTO `balance_libro` VALUES (245,3022,40720,1531,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-02','2021-05-02',12611.08,NULL,NULL,1,'2021-06-11 15:54:28','2021-06-11 15:54:28',NULL),(246,3022,40720,1531,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',22241.55,NULL,NULL,1,'2021-06-11 15:56:20','2021-06-11 15:56:20',NULL),(247,3022,40720,1531,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',22885.71,NULL,NULL,1,'2021-06-11 15:58:05','2021-06-11 15:58:05',NULL),(248,3022,40720,1531,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',21734.14,NULL,NULL,1,'2021-06-11 15:59:23','2021-06-11 15:59:23',NULL),(249,3022,40720,1531,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',20064.91,NULL,NULL,1,'2021-06-11 16:01:29','2021-06-11 16:01:29',NULL),(250,3022,40720,1531,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',21427.39,NULL,NULL,1,'2021-06-11 16:03:39','2021-06-11 16:03:39',NULL),(251,3022,40720,1531,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',22568.83,NULL,NULL,1,'2021-06-11 16:36:20','2021-06-11 16:36:20',NULL),(252,3022,40720,1531,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-09','2021-05-09',20356.85,NULL,NULL,1,'2021-06-11 16:38:31','2021-06-11 16:38:31',NULL),(253,3022,40720,1531,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',20307.97,NULL,NULL,1,'2021-06-11 16:39:53','2021-06-11 16:39:53',NULL),(254,3022,40720,1531,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',20954.97,NULL,NULL,1,'2021-06-11 16:41:22','2021-06-11 16:41:22',NULL),(255,3022,40720,1531,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',24219.99,NULL,NULL,1,'2021-06-11 16:42:51','2021-06-11 16:42:51',NULL),(256,3022,40720,1531,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',20734.22,NULL,NULL,1,'2021-06-11 16:44:12','2021-06-11 16:44:12',NULL),(257,3022,40720,1531,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',15693.08,NULL,NULL,1,'2021-06-11 16:45:33','2021-06-11 16:45:33',NULL),(258,3022,40720,1531,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',23879.16,NULL,NULL,1,'2021-06-11 16:46:36','2021-06-11 16:46:36',NULL),(259,3022,40720,1531,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',7504.02,NULL,NULL,1,'2021-06-11 16:48:18','2021-06-11 16:48:18',NULL),(260,3022,40720,1531,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',24169.81,NULL,NULL,1,'2021-06-11 16:49:35','2021-06-11 16:49:35',NULL),(261,3022,40720,1531,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',18800.92,NULL,NULL,1,'2021-06-11 16:50:45','2021-06-11 16:50:45',NULL),(262,3022,40720,1531,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-23','2021-05-23',22511.79,NULL,NULL,1,'2021-06-11 16:52:58','2021-06-11 16:52:58',NULL),(263,3022,40720,1531,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',0.01,NULL,NULL,1,'2021-06-11 16:53:20','2021-06-11 16:53:20',NULL),(264,3022,40720,1531,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',20233.10,NULL,NULL,1,'2021-06-11 16:54:40','2021-06-11 16:54:40',NULL),(265,3022,40720,1531,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-25','2021-05-25',21313.05,NULL,NULL,1,'2021-06-11 16:55:47','2021-06-11 16:55:47',NULL);
INSERT INTO `balance_libro` VALUES (266,3022,40720,1531,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',20063.15,NULL,NULL,1,'2021-06-11 16:57:04','2021-06-11 16:57:04',NULL),(267,3022,40720,1531,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',11999.94,NULL,NULL,1,'2021-06-11 16:58:34','2021-06-11 16:58:34',NULL),(268,3022,40720,1531,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',19678.87,NULL,NULL,1,'2021-06-11 16:59:30','2021-06-11 16:59:30',NULL),(269,3022,40720,1531,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',22013.96,NULL,NULL,1,'2021-06-11 17:00:44','2021-06-11 17:00:44',NULL),(270,3022,40720,1531,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8416.06,NULL,NULL,1,'2021-06-11 17:01:32','2021-06-11 17:01:32',NULL),(271,3022,40720,1532,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',20244.89,NULL,NULL,1,'2021-06-11 18:03:57','2021-07-23 14:21:05','2021-07-23 14:21:05'),(272,3022,40720,1531,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',3232.44,NULL,NULL,1,'2021-06-22 14:01:33','2021-06-22 14:01:33',NULL),(273,3022,40720,1531,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3290.90,NULL,NULL,1,'2021-06-22 14:01:33','2021-06-22 14:01:33',NULL),(274,3022,40720,1531,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',89.00,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(275,3022,40720,1531,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',2525.00,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(276,3022,40720,1531,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',3576.88,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(277,3022,40720,1531,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',414.69,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(278,3022,40720,1531,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',425.70,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(279,3022,40720,1531,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',9236.95,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(280,3022,40720,1531,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',3756.70,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(281,3022,40720,1531,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',12704.40,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(282,3022,40720,1531,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',23745.38,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(283,3022,40720,1531,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',2679.08,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(284,3022,40720,1531,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',4781.94,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(285,3022,40720,1531,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3756.70,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(286,3022,40720,1531,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2004.20,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL);
INSERT INTO `balance_libro` VALUES (287,3022,40720,1531,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',6043.10,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(288,3022,40720,1531,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',6261.69,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(289,3022,40720,1531,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',6957.90,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(290,3022,40720,1531,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',2149.64,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(291,3022,40720,1531,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',2015.98,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(292,3022,40720,1531,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',205.23,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(293,3022,40720,1531,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',2004.20,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(294,3022,40720,1531,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',10922.70,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(295,3022,40720,1531,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',13016.66,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(296,3022,40720,1531,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',803.92,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(297,3022,40720,1531,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',8872.85,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(298,3022,40720,1531,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',6419.66,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(299,3022,40720,1531,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',5493.82,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(300,3022,40720,1531,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',5495.43,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(301,3022,40720,1531,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',2991.80,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(302,3022,40720,1531,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',10096.51,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(303,3022,40720,1531,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',4999.00,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(304,3022,40720,1531,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',1112.35,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(305,3022,40720,1531,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',3310.16,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(306,3022,40720,1531,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',992.91,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(307,3022,40720,1531,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1116.43,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL);
INSERT INTO `balance_libro` VALUES (308,3022,40720,1531,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',3497.75,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(309,3022,40720,1531,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',920.00,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(310,3022,40720,1531,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',5728.11,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(311,3022,40720,1531,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',663.81,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(312,3022,40720,1531,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',4177.06,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(313,3022,40720,1531,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',336.13,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(314,3022,40720,1531,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',4382.54,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(315,3022,40720,1531,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',873.49,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(316,3022,40720,1531,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',213.03,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(317,3022,40720,1531,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',802.50,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(318,3022,40720,1531,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',235.01,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(319,3022,40720,1531,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',4461.07,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(320,3022,40720,1531,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',410.00,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(321,3022,40720,1531,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',1306.28,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(322,3022,40720,1531,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',528.98,NULL,NULL,1,'2021-06-22 14:01:34','2021-06-22 14:01:34',NULL),(323,3022,40720,1531,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',48200.74,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(324,3022,40720,1531,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-25','2021-05-25',2479.00,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(325,3022,40720,1531,3,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',1379.29,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(326,3022,40720,1531,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',967.85,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(327,3022,40720,1531,3,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1379.29,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(328,3022,40720,1531,3,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1381.50,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL);
INSERT INTO `balance_libro` VALUES (329,3022,40720,1531,3,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1037.96,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(330,3022,40720,1531,3,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',4057.04,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(331,3022,40720,1531,3,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1094.00,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(332,3022,40720,1531,3,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',5703.25,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(333,3022,40720,1531,3,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2475.00,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(334,3022,40720,1531,3,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',13829.20,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(335,3022,40720,1531,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1469.52,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(336,3022,40720,1531,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2917.30,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(337,3022,40720,1531,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1149.00,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(338,3022,40720,1531,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2299.99,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(339,3022,40720,1531,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',12105.18,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(340,3022,40720,1531,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',677.17,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(341,3022,40720,1531,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2573.40,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(342,3022,40720,1531,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',24167.06,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(343,3022,40720,1531,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1647.91,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(344,3022,40720,1531,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',65920.43,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(345,3022,40720,1531,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2230.76,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(346,3022,40720,1531,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1322.48,NULL,NULL,1,'2021-06-22 14:01:35','2021-06-22 14:01:35',NULL),(347,3022,40819,151516,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',28263.71,NULL,NULL,1,'2021-06-22 19:12:18','2021-06-22 19:15:57','2021-06-22 19:15:57'),(348,3022,40819,151516,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',12729.38,NULL,NULL,1,'2021-06-22 19:13:27','2021-06-22 19:15:40','2021-06-22 19:15:40'),(349,3022,40819,151516,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',10819.99,NULL,NULL,1,'2021-06-22 19:15:40','2021-06-22 19:15:40',NULL);
INSERT INTO `balance_libro` VALUES (350,3022,40819,151516,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',28263.71,NULL,NULL,1,'2021-06-22 19:15:57','2021-06-22 19:15:57',NULL),(351,3022,40819,151516,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',599.98,NULL,NULL,1,'2021-06-22 19:20:25','2021-06-22 19:20:25',NULL),(352,3022,40819,151516,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',176939.99,NULL,NULL,1,'2021-06-22 19:24:45','2021-10-14 12:53:29','2021-10-14 12:53:29'),(353,3022,40817,148482,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',2048.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(354,3022,40817,148482,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',6045.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(355,3022,40817,148482,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',470.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(356,3022,40817,148482,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',970.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(357,3022,40817,148482,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',7530.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(358,3022,40817,148482,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1220.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(359,3022,40817,148482,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',429.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(360,3022,40817,148482,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4000.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(361,3022,40817,148482,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4354.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(362,3022,40817,148482,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',920.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(363,3022,40817,148482,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',5143.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(364,3022,40817,148482,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',7000.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(365,3022,40817,148482,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',7374.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(366,3022,40817,148482,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1745.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(367,3022,40817,148482,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',6805.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(368,3022,40817,148482,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',340.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(369,3022,40817,148482,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',1199.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(370,3022,40817,148482,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',4500.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL);
INSERT INTO `balance_libro` VALUES (371,3022,40817,148482,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',5210.00,NULL,NULL,1,'2021-06-24 13:22:56','2021-06-24 13:22:56',NULL),(372,3022,40817,148482,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',620.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(373,3022,40817,148482,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',803.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(374,3022,40817,148482,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',5000.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(375,3022,40817,148482,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',5075.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(376,3022,40817,148482,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',2300.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(377,3022,40817,148482,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',1122.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(378,3022,40817,148482,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',2420.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(379,3022,40817,148482,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',1749.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(380,3022,40817,148482,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',528.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(381,3022,40817,148482,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',4745.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(382,3022,40817,148482,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',600.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(383,3022,40817,148482,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7000.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(384,3022,40817,148482,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',1598.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(385,3022,40817,148482,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',160.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(386,3022,40817,148482,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',5000.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(387,3022,40817,148482,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',6285.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(388,3022,40817,148482,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',836.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(389,3022,40817,148482,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',980.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(390,3022,40817,148482,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',1480.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(391,3022,40817,148482,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',5690.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL);
INSERT INTO `balance_libro` VALUES (392,3022,40817,148482,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',5733.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(393,3022,40817,148482,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',230.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(394,3022,40817,148482,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',7000.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(395,3022,40817,148482,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',2115.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(396,3022,40817,148482,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',836.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(397,3022,40817,148482,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',1775.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(398,3022,40817,148482,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6430.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(399,3022,40817,148482,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',1934.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(400,3022,40817,148482,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',4340.00,NULL,NULL,1,'2021-06-24 13:22:57','2021-06-24 13:22:57',NULL),(401,3022,40817,148483,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',910.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(402,3022,40817,148483,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',6825.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(403,3022,40817,148483,2,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7570.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(404,3022,40817,148483,2,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',780.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(405,3022,40817,148483,2,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',745.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(406,3022,40817,148483,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',7719.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(407,3022,40817,148483,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1199.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(408,3022,40817,148483,2,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',7373.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(409,3022,40817,148483,2,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',3079.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(410,3022,40817,148483,2,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',880.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(411,3022,40817,148483,2,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5000.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(412,3022,40817,148483,2,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5000.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL);
INSERT INTO `balance_libro` VALUES (413,3022,40817,148483,2,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',7532.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(414,3022,40817,148483,2,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',710.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(415,3022,40817,148483,2,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5000.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(416,3022,40817,148483,2,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',7885.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(417,3022,40817,148483,2,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2265.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(418,3022,40817,148483,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2736.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(419,3022,40817,148483,2,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',5000.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(420,3022,40817,148483,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',6034.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(421,3022,40817,148483,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',580.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(422,3022,40817,148483,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',5000.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(423,3022,40817,148483,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',6614.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(424,3022,40817,148483,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1311.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(425,3022,40817,148483,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',3600.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(426,3022,40817,148483,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',7730.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(427,3022,40817,148483,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1350.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(428,3022,40817,148483,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',975.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(429,3022,40817,148483,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',730.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(430,3022,40817,148483,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',2244.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(431,3022,40817,148483,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',6680.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(432,3022,40817,148483,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7000.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(433,3022,40817,148483,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1865.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL);
INSERT INTO `balance_libro` VALUES (434,3022,40817,148483,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',6195.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(435,3022,40817,148483,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',4215.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(436,3022,40817,148483,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',5000.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(437,3022,40817,148483,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',6085.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(438,3022,40817,148483,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2479.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(439,3022,40817,148483,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',5905.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(440,3022,40817,148483,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',370.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(441,3022,40817,148483,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',3410.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(442,3022,40817,148483,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',4705.00,NULL,NULL,1,'2021-06-24 13:28:40','2021-06-24 13:28:40',NULL),(443,3022,40817,148483,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1620.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(444,3022,40817,148483,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1012.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(445,3022,40817,148483,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',7080.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(446,3022,40817,148483,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',5000.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(447,3022,40817,148483,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3000.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(448,3022,40817,148483,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2638.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(449,3022,40817,148483,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1551.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(450,3022,40817,148483,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',5240.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(451,3022,40817,148483,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',410.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(452,3022,40817,148483,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1665.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(453,3022,40817,148483,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',5000.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(454,3022,40817,148483,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',3670.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL);
INSERT INTO `balance_libro` VALUES (455,3022,40817,148483,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',4315.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(456,3022,40817,148483,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',3589.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(457,3022,40817,148483,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',3750.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(458,3022,40817,148483,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1400.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(459,3022,40817,148483,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',940.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(460,3022,40817,148483,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',4700.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(461,3022,40817,148483,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',3700.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(462,3022,40817,148483,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2324.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(463,3022,40817,148483,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',5300.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(464,3022,40817,148483,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2094.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(465,3022,40817,148483,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',450.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(466,3022,40817,148483,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2329.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(467,3022,40817,148483,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',990.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(468,3022,40817,148483,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4190.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(469,3022,40817,148483,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1880.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(470,3022,40817,148483,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4930.00,NULL,NULL,1,'2021-06-24 13:28:41','2021-06-24 13:28:41',NULL),(471,3022,40817,148484,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',5029.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(472,3022,40817,148484,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1739.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(473,3022,40817,148484,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1936.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(474,3022,40817,148484,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3155.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(475,3022,40817,148484,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',420.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL);
INSERT INTO `balance_libro` VALUES (476,3022,40817,148484,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',340.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(477,3022,40817,148484,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',6095.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(478,3022,40817,148484,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',5452.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(479,3022,40817,148484,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2220.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(480,3022,40817,148484,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',8599.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(481,3022,40817,148484,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',5000.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(482,3022,40817,148484,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',5320.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(483,3022,40817,148484,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',7717.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(484,3022,40817,148484,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1700.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(485,3022,40817,148484,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',5000.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(486,3022,40817,148484,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',5140.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(487,3022,40817,148484,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2090.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(488,3022,40817,148484,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3138.00,NULL,NULL,1,'2021-06-24 13:32:19','2021-06-24 13:32:19',NULL),(489,3022,40817,148484,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2662.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(490,3022,40817,148484,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',7745.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(491,3022,40817,148484,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',6500.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(492,3022,40817,148484,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',3620.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(493,3022,40817,148484,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',858.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(494,3022,40817,148484,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',3495.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(495,3022,40817,148484,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',5185.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(496,3022,40817,148484,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1610.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL);
INSERT INTO `balance_libro` VALUES (497,3022,40817,148484,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',5925.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(498,3022,40817,148484,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4515.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(499,3022,40817,148484,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',6659.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(500,3022,40817,148484,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4933.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(501,3022,40817,148484,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',6140.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(502,3022,40817,148484,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1190.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(503,3022,40817,148484,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',5000.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(504,3022,40817,148484,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',5575.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(505,3022,40817,148484,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1408.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(506,3022,40817,148484,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',10040.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(507,3022,40817,148484,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',3630.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(508,3022,40817,148484,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1560.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(509,3022,40817,148484,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',1560.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(510,3022,40817,148484,2,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',3630.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(511,3022,40817,148484,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',5485.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(512,3022,40817,148484,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',4515.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(513,3022,40817,148484,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',5968.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(514,3022,40817,148484,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3430.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(515,3022,40817,148484,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1507.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(516,3022,40817,148484,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',4150.00,NULL,NULL,1,'2021-06-24 13:32:20','2021-06-24 13:32:20',NULL),(517,3022,40817,148485,2,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',4253.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL);
INSERT INTO `balance_libro` VALUES (518,3022,40817,148485,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',4404.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(519,3022,40817,148485,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6200.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(520,3022,40817,148485,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1342.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(521,3022,40817,148485,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',7720.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(522,3022,40817,148485,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',2020.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(523,3022,40817,148485,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4318.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(524,3022,40817,148485,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',2460.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(525,3022,40817,148485,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6970.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(526,3022,40817,148485,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1507.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(527,3022,40817,148485,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4150.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(528,3022,40817,148485,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4100.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(529,3022,40817,148485,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2110.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(530,3022,40817,148485,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',6000.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(531,3022,40817,148485,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',5450.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(532,3022,40817,148485,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',7060.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(533,3022,40817,148485,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',5055.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(534,3022,40817,148485,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',6535.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(535,3022,40817,148485,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1438.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(536,3022,40817,148485,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',6667.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(537,3022,40817,148485,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',300.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(538,3022,40817,148485,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2288.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL);
INSERT INTO `balance_libro` VALUES (539,3022,40817,148485,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7190.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(540,3022,40817,148485,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1330.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(541,3022,40817,148485,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',5000.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(542,3022,40817,148485,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',5530.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(543,3022,40817,148485,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2799.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(544,3022,40817,148485,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',530.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(545,3022,40817,148485,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',7000.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(546,3022,40817,148485,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',7005.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(547,3022,40817,148485,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',4380.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(548,3022,40817,148485,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1199.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(549,3022,40817,148485,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',6310.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(550,3022,40817,148485,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1200.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(551,3022,40817,148485,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6000.00,NULL,NULL,1,'2021-06-24 13:33:19','2021-06-24 13:33:19',NULL),(552,3022,40817,148485,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',2870.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(553,3022,40817,148485,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1440.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(554,3022,40817,148485,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',2255.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(555,3022,40817,148485,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6309.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(556,3022,40817,148485,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6309.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(557,3022,40817,148485,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',5250.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(558,3022,40817,148485,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',2520.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(559,3022,40817,148485,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1287.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL);
INSERT INTO `balance_libro` VALUES (560,3022,40817,148485,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',6050.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(561,3022,40817,148485,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',4109.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(562,3022,40817,148485,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3170.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(563,3022,40817,148485,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3790.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(564,3022,40817,148485,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3409.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(565,3022,40817,148485,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',8080.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(566,3022,40817,148485,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1660.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(567,3022,40817,148485,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5010.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(568,3022,40817,148485,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',6619.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(569,3022,40817,148485,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',4890.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(570,3022,40817,148485,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1880.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(571,3022,40817,148485,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2684.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(572,3022,40817,148485,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',280.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(573,3022,40817,148485,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5351.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(574,3022,40817,148485,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4328.00,NULL,NULL,1,'2021-06-24 13:33:20','2021-06-24 13:33:20',NULL),(575,3022,40720,1531,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',24098.79,NULL,NULL,1,'2021-06-25 19:23:05','2021-06-25 19:23:05',NULL),(576,3022,40720,1531,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',19835.53,NULL,NULL,1,'2021-06-25 19:23:42','2021-06-25 19:35:01','2021-06-25 19:35:01'),(577,3022,40720,1531,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',26175.71,NULL,NULL,1,'2021-06-25 19:29:16','2021-06-25 19:33:58','2021-06-25 19:33:58'),(578,3022,40720,1531,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',26165.62,NULL,NULL,1,'2021-06-25 19:33:58','2021-06-25 19:33:58',NULL),(579,3022,40720,1527,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2636.59,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(580,3022,40720,1527,3,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',107.98,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49');
INSERT INTO `balance_libro` VALUES (581,3022,40720,1527,3,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',2980.20,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(582,3022,40720,1527,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',892.21,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(583,3022,40720,1527,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',101173.80,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(584,3022,40720,1527,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',2809.68,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(585,3022,40720,1527,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3014.33,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(586,3022,40720,1527,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',2261.14,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(587,3022,40720,1527,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',858.71,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(588,3022,40720,1527,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3966.74,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(589,3022,40720,1527,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',2624.73,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(590,3022,40720,1527,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',5724.77,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(591,3022,40720,1527,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1741.02,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(592,3022,40720,1527,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',44253.33,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(593,3022,40720,1527,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',6593.30,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(594,3022,40720,1527,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',3100.02,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(595,3022,40720,1527,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',807.12,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(596,3022,40720,1527,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',113591.79,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(597,3022,40720,1527,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',504.45,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(598,3022,40720,1527,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',875.62,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(599,3022,40720,1527,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',915.21,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49');
INSERT INTO `balance_libro` VALUES (600,3022,40720,1527,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',3686.74,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(601,3022,40720,1527,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',615.95,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(602,3022,40720,1527,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',13041.26,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(603,3022,40720,1527,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',2347.42,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(604,3022,40720,1527,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',7821.32,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(605,3022,40720,1527,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',3888.27,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(606,3022,40720,1527,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',180.24,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(607,3022,40720,1527,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',3983.54,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(608,3022,40720,1527,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',5623.88,NULL,NULL,1,'2021-06-28 15:35:54','2021-07-28 14:55:49','2021-07-28 14:55:49'),(609,3022,40720,1527,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',6474.65,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(610,3022,40720,1527,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',6699.66,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(611,3022,40720,1527,3,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',4103.46,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(612,3022,40720,1527,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',424.25,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(613,3022,40720,1527,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',180.24,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(614,3022,40720,1527,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',3983.54,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(615,3022,40720,1527,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',219.94,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(616,3022,40720,1527,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',682.82,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(617,3022,40720,1527,3,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',26639.17,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(618,3022,40720,1527,3,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',2270.45,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49');
INSERT INTO `balance_libro` VALUES (619,3022,40720,1527,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',82377.88,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(620,3022,40720,1527,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1192.90,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(621,3022,40720,1527,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1388.65,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(622,3022,40720,1527,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',783.22,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(623,3022,40720,1527,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',2759.00,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(624,3022,40720,1527,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1661.28,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(625,3022,40720,1527,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',4205.60,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(626,3022,40720,1527,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1141.11,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(627,3022,40720,1527,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1661.28,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(628,3022,40720,1527,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2232.99,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(629,3022,40720,1527,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',1447.91,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(630,3022,40720,1527,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',788.72,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(631,3022,40720,1527,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',1413.35,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(632,3022,40720,1527,3,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2572.25,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(633,3022,40720,1527,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2037.88,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(634,3022,40720,1527,3,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',4835.83,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(635,3022,40720,1527,3,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',2423.90,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(636,3022,40720,1527,3,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',4199.99,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(637,3022,40720,1527,3,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',53504.10,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49');
INSERT INTO `balance_libro` VALUES (638,3022,40720,1527,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',425.58,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(639,3022,40720,1527,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',2423.90,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(640,3022,40720,1527,3,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',4022.78,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(641,3022,40720,1527,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',44111.75,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(642,3022,40720,1527,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1184.90,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(643,3022,40720,1527,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1630.00,NULL,NULL,1,'2021-06-28 15:35:55','2021-07-28 14:55:49','2021-07-28 14:55:49'),(644,3022,40720,1527,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1099.24,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(645,3022,40720,1527,3,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',11494.75,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(646,3022,40720,1527,3,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1650.97,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(647,3022,40720,1527,3,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',4390.58,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(648,3022,40720,1527,3,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',2199.42,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(649,3022,40720,1527,3,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',418.40,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(650,3022,40720,1527,3,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1585.50,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(651,3022,40720,1527,3,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',2183.61,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(652,3022,40720,1527,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',7283.21,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(653,3022,40720,1527,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',3555.64,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(654,3022,40720,1527,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',3818.26,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(655,3022,40720,1527,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2199.42,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49'),(656,3022,40720,1527,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',323792.62,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:49','2021-07-28 14:55:49');
INSERT INTO `balance_libro` VALUES (657,3022,40720,1527,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',323792.62,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(658,3022,40720,1527,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',64758.52,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(659,3022,40720,1527,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2039.18,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(660,3022,40720,1527,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',64.40,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(661,3022,40720,1527,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',1232.10,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(662,3022,40720,1527,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',354.51,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(663,3022,40720,1527,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',269.27,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(664,3022,40720,1527,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',415.31,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(665,3022,40720,1527,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',577.09,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(666,3022,40720,1527,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',879.46,NULL,NULL,1,'2021-06-28 15:35:56','2021-07-28 14:55:50','2021-07-28 14:55:50'),(667,3022,40720,1531,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',8369.99,NULL,NULL,1,'2021-06-30 18:02:15','2021-06-30 18:02:15',NULL),(668,3022,40720,1532,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',22368.18,NULL,NULL,1,'2021-07-08 15:51:58','2021-07-08 15:51:58',NULL),(669,3022,40720,1532,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',20566.88,NULL,NULL,1,'2021-07-08 15:53:31','2021-07-08 15:53:31',NULL),(670,3022,40720,1532,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',0.01,NULL,NULL,1,'2021-07-08 15:53:52','2021-07-08 15:53:52',NULL),(671,3022,40720,1532,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',21684.89,NULL,NULL,1,'2021-07-08 15:55:06','2021-07-08 15:55:06',NULL),(672,3022,40720,1532,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',19423.00,NULL,NULL,1,'2021-07-08 15:56:54','2021-07-08 15:56:54',NULL),(673,3022,40720,1532,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',21003.99,NULL,NULL,1,'2021-07-08 15:58:07','2021-07-08 15:58:07',NULL),(674,3022,40720,1532,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',22274.63,NULL,NULL,1,'2021-07-08 16:00:19','2021-07-08 16:00:19',NULL),(675,3022,40720,1532,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',21871.00,NULL,NULL,1,'2021-07-08 16:01:48','2021-07-08 16:01:48',NULL),(676,3022,40720,1532,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',18406.10,NULL,NULL,1,'2021-07-08 16:04:24','2021-07-08 16:04:24',NULL);
INSERT INTO `balance_libro` VALUES (677,3022,40720,1532,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',18234.01,NULL,NULL,1,'2021-07-08 16:05:34','2021-07-08 16:05:34',NULL),(678,3022,40720,1532,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',23243.05,NULL,NULL,1,'2021-07-08 16:07:51','2021-07-08 16:07:51',NULL),(679,3022,40720,1532,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',529.97,NULL,NULL,1,'2021-07-08 16:08:46','2021-07-08 16:08:46',NULL),(680,3022,40720,1532,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',16956.18,NULL,NULL,1,'2021-07-08 16:10:52','2021-07-08 16:10:52',NULL),(681,3022,40720,1532,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',31896.07,NULL,NULL,1,'2021-07-08 16:13:15','2021-07-08 16:13:15',NULL),(682,3022,40720,1532,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',31269.93,NULL,NULL,1,'2021-07-08 16:15:37','2021-07-08 16:15:37',NULL),(683,3022,40720,1532,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',12064.03,NULL,NULL,1,'2021-07-08 16:16:59','2021-07-08 16:16:59',NULL),(684,3022,40720,1532,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',0.01,NULL,NULL,1,'2021-07-08 16:17:18','2021-07-08 16:17:18',NULL),(685,3022,40720,1532,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',20272.02,NULL,NULL,1,'2021-07-08 16:18:59','2021-07-08 16:18:59',NULL),(686,3022,40720,1532,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',21412.05,NULL,NULL,1,'2021-07-08 16:20:27','2021-07-08 16:20:27',NULL),(687,3022,40720,1532,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',20519.11,NULL,NULL,1,'2021-07-08 16:21:51','2021-07-08 16:21:51',NULL),(688,3022,40819,151517,1,688,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-06-30',NULL,96965.96,NULL,NULL,1,'2021-07-08 16:23:03','2021-07-08 16:23:03',NULL),(689,3022,40720,1532,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',24367.99,NULL,NULL,1,'2021-07-08 16:23:38','2021-07-08 16:23:38',NULL),(690,3022,40720,1532,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',20054.95,NULL,NULL,1,'2021-07-08 16:24:36','2021-07-08 16:24:36',NULL),(691,3022,40720,1532,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',16016.97,NULL,NULL,1,'2021-07-08 16:26:02','2021-07-08 16:26:02',NULL),(692,3022,40720,1532,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',21252.99,NULL,NULL,1,'2021-07-08 16:27:06','2021-07-08 16:27:06',NULL),(693,3022,40720,1532,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',20549.09,NULL,NULL,1,'2021-07-08 16:28:07','2021-07-08 16:28:07',NULL),(694,3022,40720,1532,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',14405.09,NULL,NULL,1,'2021-07-08 16:28:54','2021-07-08 16:28:54',NULL),(695,3022,40720,1533,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',20748.04,NULL,NULL,1,'2021-07-08 16:36:27','2021-07-08 16:36:27',NULL),(696,3022,40720,1533,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',20316.09,NULL,NULL,1,'2021-07-08 16:37:44','2021-07-08 16:37:44',NULL),(697,3022,40720,1533,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',21557.91,NULL,NULL,1,'2021-07-08 16:39:02','2021-07-08 16:39:02',NULL);
INSERT INTO `balance_libro` VALUES (698,3022,40720,1533,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',16244.86,NULL,NULL,1,'2021-07-08 16:39:57','2021-07-08 16:39:57',NULL),(699,3022,40720,1532,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',7096.43,NULL,NULL,1,'2021-07-22 16:29:39','2021-07-22 16:29:39',NULL),(700,3022,40720,1532,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3232.44,NULL,NULL,1,'2021-07-22 16:29:39','2021-07-22 16:29:39',NULL),(701,3022,40720,1532,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',383.57,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(702,3022,40720,1532,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',4081.62,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(703,3022,40720,1532,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1487.01,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(704,3022,40720,1532,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1318.52,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(705,3022,40720,1532,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1916.85,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(706,3022,40720,1532,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',11307.98,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(707,3022,40720,1532,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',221.55,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(708,3022,40720,1532,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1872.66,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(709,3022,40720,1532,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',4766.21,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(710,3022,40720,1532,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',4235.95,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(711,3022,40720,1532,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',310.03,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(712,3022,40720,1532,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1146.79,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(713,3022,40720,1532,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',3779.60,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(714,3022,40720,1532,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2242.72,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(715,3022,40720,1532,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',520.07,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(716,3022,40720,1532,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',77512.94,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(717,3022,40720,1532,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2077.51,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(718,3022,40720,1532,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',8421.93,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL);
INSERT INTO `balance_libro` VALUES (719,3022,40720,1532,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2923.55,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(720,3022,40720,1532,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2048.46,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(721,3022,40720,1532,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1207.69,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(722,3022,40720,1532,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1717.94,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(723,3022,40720,1532,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',8275.65,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(724,3022,40720,1532,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3911.25,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(725,3022,40720,1532,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',4794.80,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(726,3022,40720,1532,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',7029.97,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(727,3022,40720,1532,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1030.60,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(728,3022,40720,1532,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1985.11,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(729,3022,40720,1532,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',970.15,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(730,3022,40720,1532,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',8939.96,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(731,3022,40720,1532,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3963.60,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(732,3022,40720,1532,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1628.35,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(733,3022,40720,1532,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3798.26,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(734,3022,40720,1532,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1245.06,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(735,3022,40720,1532,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',10146.12,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(736,3022,40720,1532,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1052.52,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(737,3022,40720,1532,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',314.27,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(738,3022,40720,1532,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1455.76,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(739,3022,40720,1532,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1040.00,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL);
INSERT INTO `balance_libro` VALUES (740,3022,40720,1532,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',2483.23,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(741,3022,40720,1532,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',5458.78,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(742,3022,40720,1532,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',2222.85,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(743,3022,40720,1532,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',3432.16,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(744,3022,40720,1532,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2706.88,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(745,3022,40720,1532,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1953.66,NULL,NULL,1,'2021-07-22 16:29:40','2021-07-22 16:29:40',NULL),(746,3022,40720,1532,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3959.66,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(747,3022,40720,1532,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',6718.69,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(748,3022,40720,1532,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',51312.48,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(749,3022,40720,1532,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',7482.43,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(750,3022,40720,1532,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4287.97,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(751,3022,40720,1532,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3671.17,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(752,3022,40720,1532,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2105.67,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(753,3022,40720,1532,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3257.45,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(754,3022,40720,1532,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2462.60,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(755,3022,40720,1532,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1468.00,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(756,3022,40720,1532,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1370.00,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(757,3022,40720,1532,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',3479.76,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(758,3022,40720,1532,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',21055.29,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(759,3022,40720,1532,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',11014.03,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(760,3022,40720,1532,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1195.20,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL);
INSERT INTO `balance_libro` VALUES (761,3022,40720,1532,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',2522.60,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(762,3022,40720,1532,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',1581.99,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(763,3022,40720,1532,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',4109.95,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(764,3022,40720,1532,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1798.71,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(765,3022,40720,1532,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1101.14,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(766,3022,40720,1532,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',270.59,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(767,3022,40720,1532,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',6735.31,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(768,3022,40720,1532,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',68405.02,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(769,3022,40720,1532,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3560.00,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(770,3022,40720,1532,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1658.05,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(771,3022,40720,1532,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2982.26,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(772,3022,40720,1532,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',328.26,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(773,3022,40720,1532,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3591.72,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(774,3022,40720,1532,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3898.30,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(775,3022,40720,1532,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',7280.20,NULL,NULL,1,'2021-07-22 16:29:41','2021-07-22 16:29:41',NULL),(776,3022,40720,1532,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',14681.35,NULL,NULL,1,'2021-07-23 14:59:27','2021-07-23 15:12:16','2021-07-23 15:12:16'),(777,3022,40720,1532,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',14820.45,NULL,NULL,1,'2021-07-23 15:11:40','2021-07-23 15:11:40',NULL),(778,3022,40720,1532,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',14681.35,NULL,NULL,1,'2021-07-23 15:12:16','2021-07-23 15:12:16',NULL),(779,3022,40720,1532,7,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3904.42,NULL,NULL,1,'2021-07-23 16:43:44','2021-07-23 18:16:00','2021-07-23 18:16:00'),(780,3022,40720,1532,8,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',0.00,NULL,NULL,1,'2021-07-23 18:12:49','2021-07-23 18:12:49',NULL),(781,3022,40720,1532,8,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',0.00,NULL,NULL,1,'2021-07-23 18:12:59','2021-07-23 18:12:59',NULL);
INSERT INTO `balance_libro` VALUES (782,3022,40720,1532,8,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',5128.78,NULL,NULL,1,'2021-07-23 18:13:25','2021-07-23 18:13:25',NULL),(783,3022,40720,1532,7,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',9647.78,NULL,NULL,1,'2021-07-23 18:16:00','2021-07-23 18:17:22','2021-07-23 18:17:22'),(784,3022,40720,1532,7,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',8836.20,NULL,NULL,1,'2021-07-23 18:17:22','2021-07-23 18:17:31','2021-07-23 18:17:31'),(785,3022,40720,1532,7,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',8836.20,NULL,NULL,1,'2021-07-23 18:17:31','2021-07-23 18:17:31',NULL),(786,3022,40720,1532,16,484,'App\\Models\\PeriodLiquidation',NULL,484,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',14775.98,NULL,NULL,1,'2021-07-23 18:18:08','2021-07-23 18:18:08',NULL),(787,3022,40720,1527,3,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-01','2019-01-01',1069.00,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(788,3022,40720,1527,3,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-01','2019-01-01',1565.00,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(789,3022,40720,1527,3,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',250.54,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(790,3022,40720,1527,3,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',1905.92,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(791,3022,40720,1527,3,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-10','2019-01-10',16060.25,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(792,3022,40720,1527,3,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-15','2019-01-15',1010.01,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(793,3022,40720,1527,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-25','2019-01-25',7861.52,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(794,3022,40720,1527,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-25','2019-01-25',721.12,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(795,3022,40720,1527,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-28','2019-01-28',8446.18,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(796,3022,40720,1527,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-29','2019-01-29',569.20,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(797,3022,40720,1527,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',7682.96,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(798,3022,40720,1527,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',4187.99,NULL,NULL,1,'2021-07-28 14:10:33','2021-07-28 14:55:50','2021-07-28 14:55:50'),(799,3022,40720,1527,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-01','2019-02-01',1069.00,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(800,3022,40720,1527,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-01','2019-02-01',1565.00,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50');
INSERT INTO `balance_libro` VALUES (801,3022,40720,1527,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-01','2019-02-01',1369.85,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(802,3022,40720,1527,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-05','2019-02-05',105.60,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(803,3022,40720,1527,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-05','2019-02-05',134.60,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(804,3022,40720,1527,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-06','2019-02-06',1732.98,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(805,3022,40720,1527,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-06','2019-02-06',0.17,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(806,3022,40720,1527,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-11','2019-02-11',318.64,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(807,3022,40720,1527,3,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-14','2019-02-14',17659.84,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(808,3022,40720,1527,3,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-15','2019-02-15',1650.02,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(809,3022,40720,1527,3,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-15','2019-02-15',952.17,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(810,3022,40720,1527,3,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-20','2019-02-20',0.00,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(811,3022,40720,1527,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-20','2019-02-20',0.00,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(812,3022,40720,1527,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',940.83,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(813,3022,40720,1527,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-22','2019-02-22',1872.64,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(814,3022,40720,1527,3,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-26','2019-02-26',269.20,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(815,3022,40720,1527,3,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-26','2019-02-26',1859.32,NULL,NULL,1,'2021-07-28 14:11:49','2021-07-28 14:55:50','2021-07-28 14:55:50'),(816,3022,40720,1527,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-01','2019-03-01',801.75,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(817,3022,40720,1527,3,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-01','2019-03-01',1173.75,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(818,3022,40720,1527,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-01','2019-03-01',155.75,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(819,3022,40720,1527,3,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-04','2019-03-04',12173.36,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50');
INSERT INTO `balance_libro` VALUES (820,3022,40720,1527,3,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-06','2019-03-06',25706.82,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(821,3022,40720,1527,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',362.75,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(822,3022,40720,1527,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-13','2019-03-13',253.83,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(823,3022,40720,1527,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-13','2019-03-13',1843.01,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(824,3022,40720,1527,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',7408.88,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(825,3022,40720,1527,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',1650.02,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(826,3022,40720,1527,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',8580.16,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(827,3022,40720,1527,3,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',332.31,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(828,3022,40720,1527,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-25','2019-03-25',16441.62,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(829,3022,40720,1527,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-29','2019-03-29',1453.13,NULL,NULL,1,'2021-07-28 14:12:09','2021-07-28 14:55:50','2021-07-28 14:55:50'),(830,3022,40720,1527,3,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-01','2019-04-01',801.75,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(831,3022,40720,1527,3,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-01','2019-04-01',1173.75,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(832,3022,40720,1527,3,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-04','2019-04-04',8106.89,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(833,3022,40720,1527,3,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-05','2019-04-05',361.96,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(834,3022,40720,1527,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-08','2019-04-08',23029.86,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(835,3022,40720,1527,3,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-09','2019-04-09',1707.76,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(836,3022,40720,1527,3,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-12','2019-04-12',1797.52,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(837,3022,40720,1527,3,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-14','2019-04-14',1664.42,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(838,3022,40720,1527,3,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-16','2019-04-16',179.03,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50');
INSERT INTO `balance_libro` VALUES (839,3022,40720,1527,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-16','2019-04-16',860.59,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(840,3022,40720,1527,3,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-17','2019-04-17',8133.04,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(841,3022,40720,1527,3,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-17','2019-04-17',700.00,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(842,3022,40720,1527,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-23','2019-04-23',235.89,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(843,3022,40720,1527,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-25','2019-04-25',20161.32,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(844,3022,40720,1527,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-26','2019-04-26',897.20,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(845,3022,40720,1527,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-29','2019-04-29',9865.44,NULL,NULL,1,'2021-07-28 14:12:29','2021-07-28 14:55:50','2021-07-28 14:55:50'),(846,3022,40720,1527,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-01','2019-05-01',801.75,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(847,3022,40720,1527,3,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-01','2019-05-01',1173.75,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(848,3022,40720,1527,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-02','2019-05-02',9362.23,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(849,3022,40720,1527,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',493.91,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(850,3022,40720,1527,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-06','2019-05-06',11762.15,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(851,3022,40720,1527,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',119.35,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(852,3022,40720,1527,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',53.84,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(853,3022,40720,1527,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',26.92,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(854,3022,40720,1527,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',417.40,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(855,3022,40720,1527,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',2736.82,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(856,3022,40720,1527,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-10','2019-05-10',1390.00,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(857,3022,40720,1527,3,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-10','2019-05-10',2264.63,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50');
INSERT INTO `balance_libro` VALUES (858,3022,40720,1527,3,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-13','2019-05-13',9059.95,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(859,3022,40720,1527,3,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',607.68,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(860,3022,40720,1527,3,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-15','2019-05-15',1860.80,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(861,3022,40720,1527,3,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',445.47,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(862,3022,40720,1527,3,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',310.24,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(863,3022,40720,1527,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-24','2019-05-24',1922.72,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(864,3022,40720,1527,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',360.14,NULL,NULL,1,'2021-07-28 14:12:55','2021-07-28 14:55:50','2021-07-28 14:55:50'),(865,3022,40720,1527,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-01','2019-06-01',801.75,NULL,NULL,1,'2021-07-28 14:13:06','2021-07-28 14:55:50','2021-07-28 14:55:50'),(866,3022,40720,1527,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-01','2019-06-01',1173.75,NULL,NULL,1,'2021-07-28 14:13:06','2021-07-28 14:55:50','2021-07-28 14:55:50'),(867,3022,40720,1527,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-03','2019-06-03',13145.06,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(868,3022,40720,1527,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',1076.53,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(869,3022,40720,1527,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-06','2019-06-06',12836.98,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(870,3022,40720,1527,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',0.05,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(871,3022,40720,1527,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',782.19,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(872,3022,40720,1527,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-12','2019-06-12',0.00,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(873,3022,40720,1527,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-12','2019-06-12',310000.00,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(874,3022,40720,1527,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-13','2019-06-13',182.95,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(875,3022,40720,1527,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-13','2019-06-13',522.28,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(876,3022,40720,1527,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-14','2019-06-14',778.19,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50');
INSERT INTO `balance_libro` VALUES (877,3022,40720,1527,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-15','2019-06-15',2215.73,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(878,3022,40720,1527,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-18','2019-06-18',10508.30,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(879,3022,40720,1527,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-18','2019-06-18',418.64,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(880,3022,40720,1527,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-18','2019-06-18',1272.78,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(881,3022,40720,1527,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-19','2019-06-19',16523.20,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(882,3022,40720,1527,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',609.43,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(883,3022,40720,1527,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',1345.00,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(884,3022,40720,1527,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',1345.00,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(885,3022,40720,1527,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',2122.45,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(886,3022,40720,1527,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-28','2019-06-28',1421.34,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(887,3022,40720,1527,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-28','2019-06-28',18.84,NULL,NULL,1,'2021-07-28 14:13:07','2021-07-28 14:55:50','2021-07-28 14:55:50'),(888,3022,40720,1527,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-01','2019-07-01',1069.00,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(889,3022,40720,1527,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-01','2019-07-01',1565.00,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(890,3022,40720,1527,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-01','2019-07-01',9484.27,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(891,3022,40720,1527,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-02','2019-07-02',13049.06,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(892,3022,40720,1527,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-04','2019-07-04',9684.82,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(893,3022,40720,1527,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-05','2019-07-05',854.01,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(894,3022,40720,1527,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-05','2019-07-05',773.20,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(895,3022,40720,1527,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',14769.85,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50');
INSERT INTO `balance_libro` VALUES (896,3022,40720,1527,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-11','2019-07-11',11864.48,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(897,3022,40720,1527,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-11','2019-07-11',1232.57,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(898,3022,40720,1527,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-12','2019-07-12',1311.46,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(899,3022,40720,1527,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-12','2019-07-12',23926.09,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(900,3022,40720,1527,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-13','2019-07-13',1345.00,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(901,3022,40720,1527,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-14','2019-07-14',2071.31,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(902,3022,40720,1527,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',8635.66,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(903,3022,40720,1527,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',310.26,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(904,3022,40720,1527,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',138.46,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(905,3022,40720,1527,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',2537.42,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(906,3022,40720,1527,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',10655.74,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(907,3022,40720,1527,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',4786.34,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(908,3022,40720,1527,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',2439.31,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(909,3022,40720,1527,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',192.80,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(910,3022,40720,1527,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-23','2019-07-23',26479.23,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:50','2021-07-28 14:55:50'),(911,3022,40720,1527,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-23','2019-07-23',92.31,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:51','2021-07-28 14:55:51'),(912,3022,40720,1527,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-23','2019-07-23',399.24,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:51','2021-07-28 14:55:51'),(913,3022,40720,1527,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-25','2019-07-25',577.34,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:51','2021-07-28 14:55:51'),(914,3022,40720,1527,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',10650.29,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:51','2021-07-28 14:55:51');
INSERT INTO `balance_libro` VALUES (915,3022,40720,1527,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',12853.91,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:51','2021-07-28 14:55:51'),(916,3022,40720,1527,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-30','2019-07-30',25448.15,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:51','2021-07-28 14:55:51'),(917,3022,40720,1527,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',603.28,NULL,NULL,1,'2021-07-28 14:13:19','2021-07-28 14:55:51','2021-07-28 14:55:51'),(918,3022,40720,1527,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',1069.00,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(919,3022,40720,1527,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',1565.00,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(920,3022,40720,1527,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-02','2019-08-02',335.10,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(921,3022,40720,1527,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-06','2019-08-06',39561.32,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(922,3022,40720,1527,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-06','2019-08-06',636.71,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(923,3022,40720,1527,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-09','2019-08-09',12572.80,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(924,3022,40720,1527,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-09','2019-08-09',1592.83,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(925,3022,40720,1527,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',50045.17,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(926,3022,40720,1527,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-14','2019-08-14',4903.08,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(927,3022,40720,1527,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',1964.00,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(928,3022,40720,1527,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',425.04,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(929,3022,40720,1527,3,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-16','2019-08-16',355.91,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(930,3022,40720,1527,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-20','2019-08-20',362.26,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(931,3022,40720,1527,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-20','2019-08-20',2717.25,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(932,3022,40720,1527,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-22','2019-08-22',10389.86,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(933,3022,40720,1527,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-23','2019-08-23',597.07,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51');
INSERT INTO `balance_libro` VALUES (934,3022,40720,1527,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-27','2019-08-27',53482.55,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(935,3022,40720,1527,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-27','2019-08-27',50548.45,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(936,3022,40720,1527,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-28','2019-08-28',431.03,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(937,3022,40720,1527,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-30','2019-08-30',26466.93,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(938,3022,40720,1527,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-30','2019-08-30',494.85,NULL,NULL,1,'2021-07-28 14:13:30','2021-07-28 14:55:51','2021-07-28 14:55:51'),(939,3022,40720,1527,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-01','2019-09-01',855.20,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(940,3022,40720,1527,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-01','2019-09-01',1252.00,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(941,3022,40720,1527,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-03','2019-09-03',50679.72,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(942,3022,40720,1527,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-03','2019-09-03',543.84,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(943,3022,40720,1527,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-05','2019-09-05',223.68,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(944,3022,40720,1527,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-06','2019-09-06',1111.14,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(945,3022,40720,1527,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-06','2019-09-06',10666.29,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(946,3022,40720,1527,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-10','2019-09-10',31810.19,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(947,3022,40720,1527,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-10','2019-09-10',3360.51,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(948,3022,40720,1527,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-10','2019-09-10',3690.65,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(949,3022,40720,1527,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-10','2019-09-10',79.96,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(950,3022,40720,1527,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-13','2019-09-13',92.32,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(951,3022,40720,1527,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-13','2019-09-13',0.34,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(952,3022,40720,1527,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-17','2019-09-17',40722.34,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51');
INSERT INTO `balance_libro` VALUES (953,3022,40720,1527,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-19','2019-09-19',622.00,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(954,3022,40720,1527,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-20','2019-09-20',39294.35,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(955,3022,40720,1527,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-20','2019-09-20',659.18,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(956,3022,40720,1527,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-20','2019-09-20',10346.30,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(957,3022,40720,1527,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',36354.50,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(958,3022,40720,1527,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',906.09,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(959,3022,40720,1527,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-26','2019-09-26',1581.57,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(960,3022,40720,1527,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-27','2019-09-27',24487.08,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(961,3022,40720,1527,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-27','2019-09-27',196.83,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(962,3022,40720,1527,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-27','2019-09-27',1040.39,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(963,3022,40720,1527,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',327.59,NULL,NULL,1,'2021-07-28 14:13:44','2021-07-28 14:55:51','2021-07-28 14:55:51'),(964,3022,40720,1527,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-01','2019-01-01',1069.00,NULL,NULL,1,'2021-07-28 14:58:54','2021-07-28 15:09:55','2021-07-28 15:09:55'),(965,3022,40720,1527,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-01','2019-01-01',1565.00,NULL,NULL,1,'2021-07-28 14:58:54','2021-07-28 15:09:45','2021-07-28 15:09:45'),(966,3022,40720,1527,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',250.54,NULL,NULL,1,'2021-07-28 14:58:54','2021-07-28 15:05:29','2021-07-28 15:05:29'),(967,3022,40720,1527,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',1905.92,NULL,NULL,1,'2021-07-28 14:58:54','2021-07-28 15:05:39','2021-07-28 15:05:39'),(968,3022,40720,1527,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-10','2019-01-10',16060.25,NULL,NULL,1,'2021-07-28 14:58:54','2021-07-28 15:05:50','2021-07-28 15:05:50'),(969,3022,40720,1527,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-15','2019-01-15',1010.01,NULL,NULL,1,'2021-07-28 14:58:54','2021-07-28 14:58:54',NULL),(970,3022,40720,1527,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-25','2019-01-25',7861.52,NULL,NULL,1,'2021-07-28 14:58:55','2021-07-28 14:58:55',NULL),(971,3022,40720,1527,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-25','2019-01-25',721.12,NULL,NULL,1,'2021-07-28 14:58:55','2021-07-28 14:58:55',NULL),(972,3022,40720,1527,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-28','2019-01-28',8446.18,NULL,NULL,1,'2021-07-28 14:58:55','2021-07-28 14:58:55',NULL);
INSERT INTO `balance_libro` VALUES (973,3022,40720,1527,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-29','2019-01-29',569.20,NULL,NULL,1,'2021-07-28 14:58:55','2021-07-28 14:58:55',NULL),(974,3022,40720,1527,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',7682.96,NULL,NULL,1,'2021-07-28 14:58:55','2021-07-28 14:58:55',NULL),(975,3022,40720,1527,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',4187.99,NULL,NULL,1,'2021-07-28 14:58:55','2021-07-28 14:59:58','2021-07-28 14:59:58'),(976,3022,40720,1527,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',4150.55,NULL,NULL,1,'2021-07-28 14:59:58','2021-07-28 15:02:41','2021-07-28 15:02:41'),(977,3022,40720,1527,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',4150.55,NULL,NULL,1,'2021-07-28 15:02:41','2021-07-28 15:02:41',NULL),(978,3022,40720,1527,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2636.59,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(979,3022,40720,1527,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',107.98,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(980,3022,40720,1527,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',2980.20,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(981,3022,40720,1527,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',892.21,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(982,3022,40720,1527,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',101173.80,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(983,3022,40720,1527,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',2809.68,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(984,3022,40720,1527,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3014.33,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(985,3022,40720,1527,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',2261.14,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(986,3022,40720,1527,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',858.71,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(987,3022,40720,1527,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3966.74,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(988,3022,40720,1527,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',2624.73,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(989,3022,40720,1527,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',5724.77,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(990,3022,40720,1527,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1741.02,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(991,3022,40720,1527,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',44253.33,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(992,3022,40720,1527,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',6593.30,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(993,3022,40720,1527,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',3100.02,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL);
INSERT INTO `balance_libro` VALUES (994,3022,40720,1527,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',807.12,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(995,3022,40720,1527,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',113591.79,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(996,3022,40720,1527,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',504.45,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(997,3022,40720,1527,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',875.62,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(998,3022,40720,1527,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',915.21,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(999,3022,40720,1527,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',3686.74,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1000,3022,40720,1527,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',615.95,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1001,3022,40720,1527,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',13041.26,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1002,3022,40720,1527,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',2347.42,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1003,3022,40720,1527,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',7821.32,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1004,3022,40720,1527,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',3888.27,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1005,3022,40720,1527,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',180.24,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1006,3022,40720,1527,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',3983.54,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1007,3022,40720,1527,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',5623.88,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1008,3022,40720,1527,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',6474.65,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1009,3022,40720,1527,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',6699.66,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1010,3022,40720,1527,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',4103.46,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1011,3022,40720,1527,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',424.25,NULL,NULL,1,'2021-07-28 15:38:15','2021-07-28 15:38:15',NULL),(1012,3022,40720,1527,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',180.24,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1013,3022,40720,1527,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',3983.54,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1014,3022,40720,1527,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',682.82,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL);
INSERT INTO `balance_libro` VALUES (1015,3022,40720,1527,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',219.94,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1016,3022,40720,1527,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',26639.17,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1017,3022,40720,1527,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',2270.45,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1018,3022,40720,1527,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',82377.88,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1019,3022,40720,1527,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1192.90,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1020,3022,40720,1527,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1388.65,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1021,3022,40720,1527,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',783.22,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1022,3022,40720,1527,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',2759.00,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1023,3022,40720,1527,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1661.28,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1024,3022,40720,1527,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',4205.60,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1025,3022,40720,1527,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1141.11,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1026,3022,40720,1527,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1661.28,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1027,3022,40720,1527,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2232.99,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1028,3022,40720,1527,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',1447.91,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1029,3022,40720,1527,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',788.72,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1030,3022,40720,1527,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',1413.35,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1031,3022,40720,1527,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2572.25,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1032,3022,40720,1527,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2037.88,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1033,3022,40720,1527,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',4835.83,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1034,3022,40720,1527,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',2423.90,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1035,3022,40720,1527,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',4199.99,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL);
INSERT INTO `balance_libro` VALUES (1036,3022,40720,1527,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',53504.10,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1037,3022,40720,1527,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',425.58,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1038,3022,40720,1527,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',2423.90,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1039,3022,40720,1527,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',4022.78,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1040,3022,40720,1527,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',44111.75,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1041,3022,40720,1527,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1184.90,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1042,3022,40720,1527,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1630.00,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1043,3022,40720,1527,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1099.24,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1044,3022,40720,1527,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',11494.75,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1045,3022,40720,1527,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1650.97,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1046,3022,40720,1527,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',4390.58,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1047,3022,40720,1527,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',2199.42,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1048,3022,40720,1527,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',418.40,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1049,3022,40720,1527,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1585.50,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1050,3022,40720,1527,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',2183.61,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1051,3022,40720,1527,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',7283.21,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1052,3022,40720,1527,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',3555.64,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1053,3022,40720,1527,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',3818.26,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1054,3022,40720,1527,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2199.42,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1055,3022,40720,1527,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',323792.62,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1056,3022,40720,1527,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',323792.62,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL);
INSERT INTO `balance_libro` VALUES (1057,3022,40720,1527,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',64758.52,NULL,NULL,1,'2021-07-28 15:38:16','2021-07-28 15:38:16',NULL),(1058,3022,40720,1527,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2039.18,NULL,NULL,1,'2021-07-28 15:38:17','2021-07-28 15:38:17',NULL),(1059,3022,40720,1527,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',64.40,NULL,NULL,1,'2021-07-28 15:38:17','2021-07-28 15:38:17',NULL),(1060,3022,40720,1527,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',1232.10,NULL,NULL,1,'2021-07-28 15:38:17','2021-07-28 15:38:17',NULL),(1061,3022,40720,1527,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',354.51,NULL,NULL,1,'2021-07-28 15:38:17','2021-07-28 15:38:17',NULL),(1062,3022,40720,1527,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',269.27,NULL,NULL,1,'2021-07-28 15:38:17','2021-07-28 15:38:17',NULL),(1063,3022,40720,1527,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',415.31,NULL,NULL,1,'2021-07-28 15:38:17','2021-07-28 15:38:17',NULL),(1064,3022,40720,1527,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',577.09,NULL,NULL,1,'2021-07-28 15:38:17','2021-07-28 15:38:17',NULL),(1065,3022,40720,1527,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',879.46,NULL,NULL,1,'2021-07-28 15:38:17','2021-07-28 15:38:17',NULL),(1066,3022,40720,1528,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',2934.94,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1067,3022,40720,1528,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',304.90,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1068,3022,40720,1528,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',8206.17,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1069,3022,40720,1528,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',15235.56,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1070,3022,40720,1528,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',71302.56,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1071,3022,40720,1528,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',2820.10,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1072,3022,40720,1528,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3932.80,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1073,3022,40720,1528,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',566.15,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1074,3022,40720,1528,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',1061.46,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1075,3022,40720,1528,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',788.94,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1076,3022,40720,1528,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3093.00,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1077,3022,40720,1528,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',2482.07,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL);
INSERT INTO `balance_libro` VALUES (1078,3022,40720,1528,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',6685.57,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1079,3022,40720,1528,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3751.56,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1080,3022,40720,1528,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',1554.99,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1081,3022,40720,1528,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3600.76,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1082,3022,40720,1528,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',6160.18,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1083,3022,40720,1528,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',437.20,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1084,3022,40720,1528,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1186.88,NULL,NULL,1,'2021-07-28 15:38:31','2021-07-28 15:38:31',NULL),(1085,3022,40720,1528,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',2491.10,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1086,3022,40720,1528,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',6578.14,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1087,3022,40720,1528,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',298.28,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1088,3022,40720,1528,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',20676.75,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1089,3022,40720,1528,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',3210.00,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1090,3022,40720,1528,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',4440.31,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1091,3022,40720,1528,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1588.85,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1092,3022,40720,1528,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2605.67,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1093,3022,40720,1528,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1590.00,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1094,3022,40720,1528,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',58995.95,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1095,3022,40720,1528,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',2703.00,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1096,3022,40720,1528,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',2589.00,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1097,3022,40720,1528,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',392.97,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1098,3022,40720,1528,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',2605.67,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL);
INSERT INTO `balance_libro` VALUES (1099,3022,40720,1528,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',692.02,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1100,3022,40720,1528,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1022.12,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1101,3022,40720,1528,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',3710.13,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1102,3022,40720,1528,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',8799.86,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1103,3022,40720,1528,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',14961.68,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1104,3022,40720,1528,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',8630.01,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1105,3022,40720,1528,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',1438.50,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1106,3022,40720,1528,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',1150.83,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1107,3022,40720,1528,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3794.04,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1108,3022,40720,1528,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',5657.82,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1109,3022,40720,1528,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',521.85,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1110,3022,40720,1528,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',8630.01,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1111,3022,40720,1528,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',4253.45,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1112,3022,40720,1528,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',569.47,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1113,3022,40720,1528,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',5657.82,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1114,3022,40720,1528,3,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',8718.51,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1115,3022,40720,1528,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',6594.22,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1116,3022,40720,1528,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',842.95,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1117,3022,40720,1528,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',842.95,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1118,3022,40720,1528,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',2860.20,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1119,3022,40720,1528,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',6982.83,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL);
INSERT INTO `balance_libro` VALUES (1120,3022,40720,1528,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',6594.22,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1121,3022,40720,1528,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',43980.44,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1122,3022,40720,1528,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1504.76,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1123,3022,40720,1528,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3212.56,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1124,3022,40720,1528,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',9867.01,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1125,3022,40720,1528,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',165.26,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1126,3022,40720,1528,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1112.93,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1127,3022,40720,1528,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',2095.74,NULL,NULL,1,'2021-07-28 15:38:32','2021-07-28 15:38:32',NULL),(1128,3022,40720,1528,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',3238.98,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1129,3022,40720,1528,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',3238.98,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1130,3022,40720,1528,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',50.34,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1131,3022,40720,1528,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',120.64,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1132,3022,40720,1528,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',40136.76,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1133,3022,40720,1528,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',3334.31,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1134,3022,40720,1528,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2064.19,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1135,3022,40720,1528,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2360.00,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1136,3022,40720,1528,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1269.53,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1137,3022,40720,1528,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2043.72,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1138,3022,40720,1528,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',663.87,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1139,3022,40720,1528,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1428.23,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1140,3022,40720,1528,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2699.72,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL);
INSERT INTO `balance_libro` VALUES (1141,3022,40720,1528,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1134.91,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1142,3022,40720,1528,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',4655.12,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1143,3022,40720,1528,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',2185.48,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1144,3022,40720,1528,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',4463.22,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1145,3022,40720,1528,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',2817.93,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1146,3022,40720,1528,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',140.11,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1147,3022,40720,1528,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',42977.02,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1148,3022,40720,1528,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',28820.61,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1149,3022,40720,1528,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',47473.45,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1150,3022,40720,1528,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',4503.51,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1151,3022,40720,1528,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1076.53,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1152,3022,40720,1528,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',3732.35,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1153,3022,40720,1528,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1928.61,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1154,3022,40720,1528,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1653.80,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1155,3022,40720,1528,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',5855.89,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1156,3022,40720,1528,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',2389.00,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1157,3022,40720,1528,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3819.00,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1158,3022,40720,1528,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1227.81,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1159,3022,40720,1528,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',29398.28,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1160,3022,40720,1528,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1381.03,NULL,NULL,1,'2021-07-28 15:38:33','2021-07-28 15:38:33',NULL),(1161,3022,40720,1529,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',7300.20,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL);
INSERT INTO `balance_libro` VALUES (1162,3022,40720,1529,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2937.33,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1163,3022,40720,1529,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8116.66,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1164,3022,40720,1529,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',10693.62,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1165,3022,40720,1529,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',969.94,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1166,3022,40720,1529,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',969.94,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1167,3022,40720,1529,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',489.97,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1168,3022,40720,1529,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',37803.13,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1169,3022,40720,1529,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',3000.90,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1170,3022,40720,1529,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',3367.54,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1171,3022,40720,1529,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2966.40,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1172,3022,40720,1529,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',337.56,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1173,3022,40720,1529,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2832.33,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1174,3022,40720,1529,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',6020.67,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1175,3022,40720,1529,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',10349.76,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1176,3022,40720,1529,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',7530.52,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1177,3022,40720,1529,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',30004.43,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1178,3022,40720,1529,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2404.76,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1179,3022,40720,1529,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2647.35,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1180,3022,40720,1529,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3484.02,NULL,NULL,1,'2021-07-28 15:38:47','2021-07-28 15:38:47',NULL),(1181,3022,40720,1529,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1086.57,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1182,3022,40720,1529,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',3586.58,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL);
INSERT INTO `balance_libro` VALUES (1183,3022,40720,1529,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',5932.10,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1184,3022,40720,1529,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',3061.42,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1185,3022,40720,1529,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',4326.77,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1186,3022,40720,1529,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1780.30,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1187,3022,40720,1529,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1283.10,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1188,3022,40720,1529,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3161.19,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1189,3022,40720,1529,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',2448.45,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1190,3022,40720,1529,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',52029.32,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1191,3022,40720,1529,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',219.49,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1192,3022,40720,1529,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3349.48,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1193,3022,40720,1529,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',4955.83,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1194,3022,40720,1529,3,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1733.81,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1195,3022,40720,1529,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1481.82,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1196,3022,40720,1529,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',3719.19,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1197,3022,40720,1529,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',5251.80,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1198,3022,40720,1529,3,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',624.17,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1199,3022,40720,1529,3,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',6050.42,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1200,3022,40720,1529,3,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3119.28,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1201,3022,40720,1529,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',859.54,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1202,3022,40720,1529,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',4668.09,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1203,3022,40720,1529,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1186.78,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL);
INSERT INTO `balance_libro` VALUES (1204,3022,40720,1529,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',324.63,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1205,3022,40720,1529,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',96.01,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1206,3022,40720,1529,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',3535.63,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1207,3022,40720,1529,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1582.49,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1208,3022,40720,1529,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',6275.01,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1209,3022,40720,1529,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1062.02,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1210,3022,40720,1529,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1329.23,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1211,3022,40720,1529,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',864.15,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1212,3022,40720,1529,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',7035.14,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1213,3022,40720,1529,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1421.65,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1214,3022,40720,1529,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',37491.91,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1215,3022,40720,1529,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',3620.36,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1216,3022,40720,1529,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',2545.02,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1217,3022,40720,1529,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1260.32,NULL,NULL,1,'2021-07-28 15:38:48','2021-07-28 15:38:48',NULL),(1218,3022,40720,1529,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',944.31,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1219,3022,40720,1529,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',2432.51,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1220,3022,40720,1529,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',5107.15,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1221,3022,40720,1529,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',3703.47,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1222,3022,40720,1529,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1322.87,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1223,3022,40720,1529,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',2432.51,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1224,3022,40720,1529,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',5577.51,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL);
INSERT INTO `balance_libro` VALUES (1225,3022,40720,1529,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',3753.79,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1226,3022,40720,1529,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',1322.87,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1227,3022,40720,1529,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1250.96,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1228,3022,40720,1529,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',7146.29,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1229,3022,40720,1529,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',410.90,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1230,3022,40720,1529,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',10114.75,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1231,3022,40720,1529,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',729.21,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1232,3022,40720,1529,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',3889.00,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1233,3022,40720,1529,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',950.00,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1234,3022,40720,1529,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',2580.79,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1235,3022,40720,1529,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',4899.41,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1236,3022,40720,1529,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',992.73,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1237,3022,40720,1529,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',52431.98,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1238,3022,40720,1529,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',834.54,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1239,3022,40720,1529,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',35578.24,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1240,3022,40720,1529,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3955.05,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1241,3022,40720,1529,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',890.52,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1242,3022,40720,1529,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1719.60,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1243,3022,40720,1529,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1007.73,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1244,3022,40720,1529,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',8997.57,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1245,3022,40720,1529,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',538.65,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL);
INSERT INTO `balance_libro` VALUES (1246,3022,40720,1529,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',9219.31,NULL,NULL,1,'2021-07-28 15:38:49','2021-07-28 15:38:49',NULL),(1247,3022,40720,1533,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',24902.99,NULL,NULL,1,'2021-08-09 11:11:40','2021-08-09 11:11:40',NULL),(1248,3022,40720,1533,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',20332.89,NULL,NULL,1,'2021-08-09 11:13:41','2021-08-09 11:13:41',NULL),(1249,3022,40720,1533,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',14789.95,NULL,NULL,1,'2021-08-09 11:15:00','2021-08-09 11:15:00',NULL),(1250,3022,40720,1533,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',14789.95,NULL,NULL,1,'2021-08-09 11:15:00','2021-08-09 11:32:12','2021-08-09 11:32:12'),(1251,3022,40720,1533,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',0.01,NULL,NULL,1,'2021-08-09 11:15:37','2021-08-09 11:17:14','2021-08-09 11:17:14'),(1252,3022,40720,1533,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',13716.95,NULL,NULL,1,'2021-08-09 11:37:49','2021-08-09 11:37:49',NULL),(1253,3022,40720,1533,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',0.01,NULL,NULL,1,'2021-08-09 11:40:33','2021-08-09 11:40:33',NULL),(1254,3022,40720,1533,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1197.00,NULL,NULL,1,'2021-08-09 11:41:49','2021-08-09 11:41:49',NULL),(1255,3022,40720,1533,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',21339.04,NULL,NULL,1,'2021-08-09 11:46:40','2021-08-09 11:46:40',NULL),(1256,3022,40720,1533,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',5111.04,NULL,NULL,1,'2021-08-09 11:49:36','2021-08-09 11:49:36',NULL),(1257,3022,40720,1533,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1488.99,NULL,NULL,1,'2021-08-09 11:50:18','2021-08-09 11:50:18',NULL),(1258,3022,40720,1533,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',3.19,NULL,NULL,1,'2021-08-09 12:09:15','2021-08-09 12:09:15',NULL),(1259,3022,40720,1533,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',18274.03,NULL,NULL,1,'2021-08-09 12:11:44','2021-08-09 12:11:44',NULL),(1260,3022,40720,1533,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',18432.04,NULL,NULL,1,'2021-08-09 12:12:23','2021-08-09 12:12:23',NULL),(1261,3022,40720,1533,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',19454.00,NULL,NULL,1,'2021-08-09 12:13:37','2021-08-09 12:13:37',NULL),(1262,3022,40720,1533,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',8520.00,NULL,NULL,1,'2021-08-09 12:14:28','2021-08-09 12:14:28',NULL),(1263,3022,40720,1533,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',8174.00,NULL,NULL,1,'2021-08-09 12:15:36','2021-08-09 12:15:36',NULL),(1264,3022,40720,1533,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',4372.00,NULL,NULL,1,'2021-08-09 12:16:04','2021-08-09 12:16:04',NULL),(1265,3022,40720,1533,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',0.01,NULL,NULL,1,'2021-08-09 12:16:36','2021-08-09 12:16:36',NULL),(1266,3022,40720,1533,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',66521.00,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL);
INSERT INTO `balance_libro` VALUES (1267,3022,40720,1533,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',3232.44,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1268,3022,40720,1533,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',416.80,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1269,3022,40720,1533,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1319.29,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1270,3022,40720,1533,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2800.00,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1271,3022,40720,1533,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2800.00,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1272,3022,40720,1533,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1800.00,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1273,3022,40720,1533,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',663.00,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1274,3022,40720,1533,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2800.00,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1275,3022,40720,1533,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',8167.26,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1276,3022,40720,1533,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2345.16,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1277,3022,40720,1533,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2299.99,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1278,3022,40720,1533,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',825.75,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1279,3022,40720,1533,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2327.62,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1280,3022,40720,1533,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2017.80,NULL,NULL,1,'2021-08-11 10:51:59','2021-08-11 10:51:59',NULL),(1281,3022,40720,1533,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',9603.93,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1282,3022,40720,1533,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',986.29,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1283,3022,40720,1533,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',920.00,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1284,3022,40720,1533,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',9603.93,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1285,3022,40720,1533,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3036.76,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1286,3022,40720,1533,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3539.40,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1287,3022,40720,1533,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',2550.00,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL);
INSERT INTO `balance_libro` VALUES (1288,3022,40720,1533,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',8251.28,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1289,3022,40720,1533,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1390.00,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1290,3022,40720,1533,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2841.44,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1291,3022,40720,1533,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4045.14,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1292,3022,40720,1533,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2503.60,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1293,3022,40720,1533,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',433.88,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1294,3022,40720,1533,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',396.44,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1295,3022,40720,1533,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',28086.98,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1296,3022,40720,1533,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',752.70,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1297,3022,40720,1533,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1658.29,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1298,3022,40720,1533,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',752.70,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1299,3022,40720,1533,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',465.50,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1300,3022,40720,1533,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',84118.12,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1301,3022,40720,1533,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',474.23,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1302,3022,40720,1533,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2869.38,NULL,NULL,1,'2021-08-11 10:52:00','2021-08-11 10:52:00',NULL),(1303,3022,40720,1533,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',6755.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(1304,3022,40720,1533,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',2235.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(1305,3022,40720,1533,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',2055.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(1306,3022,40720,1533,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',7023.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(1307,3022,40720,1533,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',805.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(1308,3022,40720,1533,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',695.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL);
INSERT INTO `balance_libro` VALUES (1309,3022,40720,1533,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1140.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(1310,3022,40720,1533,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',2860.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(1311,3022,40720,1533,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1910.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(1312,3022,40720,1533,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',3040.00,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(1313,3022,40720,1533,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1330.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1314,3022,40720,1533,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',2253.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1315,3022,40720,1533,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1000.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1316,3022,40720,1533,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',90.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1317,3022,40720,1533,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',900.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1318,3022,40720,1533,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',370.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1319,3022,40720,1533,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',490.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1320,3022,40720,1533,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',5120.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1321,3022,40720,1533,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1088.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1322,3022,40720,1533,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1610.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1323,3022,40720,1533,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1960.00,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(1324,3022,40817,148482,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',2048.00,NULL,NULL,1,'2021-08-12 13:02:44','2021-08-12 13:02:44',NULL),(1325,3022,40817,148482,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',6045.00,NULL,NULL,1,'2021-08-12 13:02:44','2021-08-12 13:02:44',NULL),(1326,3022,40817,148482,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',470.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1327,3022,40817,148482,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',970.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1328,3022,40817,148482,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',7530.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1329,3022,40817,148482,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1220.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL);
INSERT INTO `balance_libro` VALUES (1330,3022,40817,148482,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',429.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1331,3022,40817,148482,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4000.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1332,3022,40817,148482,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4354.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1333,3022,40817,148482,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',920.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1334,3022,40817,148482,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',5143.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1335,3022,40817,148482,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',7000.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1336,3022,40817,148482,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',7374.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1337,3022,40817,148482,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1745.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1338,3022,40817,148482,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',6805.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1339,3022,40817,148482,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',340.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1340,3022,40817,148482,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',1199.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1341,3022,40817,148482,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',4500.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1342,3022,40817,148482,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',5210.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1343,3022,40817,148482,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',620.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1344,3022,40817,148482,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',803.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1345,3022,40817,148482,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',5000.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1346,3022,40817,148482,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',5075.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1347,3022,40817,148482,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',2300.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1348,3022,40817,148482,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',1122.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1349,3022,40817,148482,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',2420.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL),(1350,3022,40817,148482,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',1749.00,NULL,NULL,1,'2021-08-12 13:02:45','2021-08-12 13:02:45',NULL);
INSERT INTO `balance_libro` VALUES (1351,3022,40817,148482,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',528.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1352,3022,40817,148482,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',4745.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1353,3022,40817,148482,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',600.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1354,3022,40817,148482,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7000.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1355,3022,40817,148482,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',1598.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1356,3022,40817,148482,3,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',160.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1357,3022,40817,148482,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',5000.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1358,3022,40817,148482,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',6285.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1359,3022,40817,148482,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',836.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1360,3022,40817,148482,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',980.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1361,3022,40817,148482,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',1480.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1362,3022,40817,148482,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',5690.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1363,3022,40817,148482,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',5733.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1364,3022,40817,148482,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',230.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1365,3022,40817,148482,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',7000.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1366,3022,40817,148482,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',2115.00,NULL,NULL,1,'2021-08-12 13:02:46','2021-08-12 13:02:46',NULL),(1367,3022,40817,148482,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',836.00,NULL,NULL,1,'2021-08-12 13:02:47','2021-08-12 13:02:47',NULL),(1368,3022,40817,148482,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',1775.00,NULL,NULL,1,'2021-08-12 13:02:47','2021-08-12 13:02:47',NULL),(1369,3022,40817,148482,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6430.00,NULL,NULL,1,'2021-08-12 13:02:47','2021-08-12 13:02:47',NULL),(1370,3022,40817,148482,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',1934.00,NULL,NULL,1,'2021-08-12 13:02:47','2021-08-12 13:02:47',NULL),(1371,3022,40817,148482,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',4340.00,NULL,NULL,1,'2021-08-12 13:02:47','2021-08-12 13:02:47',NULL);
INSERT INTO `balance_libro` VALUES (1372,3022,40817,148483,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',910.00,NULL,NULL,1,'2021-08-12 13:03:05','2021-08-12 13:03:05',NULL),(1373,3022,40817,148483,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',6825.00,NULL,NULL,1,'2021-08-12 13:03:05','2021-08-12 13:03:05',NULL),(1374,3022,40817,148483,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7570.00,NULL,NULL,1,'2021-08-12 13:03:05','2021-08-12 13:03:05',NULL),(1375,3022,40817,148483,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',780.00,NULL,NULL,1,'2021-08-12 13:03:05','2021-08-12 13:03:05',NULL),(1376,3022,40817,148483,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',745.00,NULL,NULL,1,'2021-08-12 13:03:05','2021-08-12 13:03:05',NULL),(1377,3022,40817,148483,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',7719.00,NULL,NULL,1,'2021-08-12 13:03:05','2021-08-12 13:03:05',NULL),(1378,3022,40817,148483,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1199.00,NULL,NULL,1,'2021-08-12 13:03:05','2021-08-12 13:03:05',NULL),(1379,3022,40817,148483,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',7373.00,NULL,NULL,1,'2021-08-12 13:03:05','2021-08-12 13:03:05',NULL),(1380,3022,40817,148483,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',3079.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1381,3022,40817,148483,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',880.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1382,3022,40817,148483,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5000.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1383,3022,40817,148483,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5000.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1384,3022,40817,148483,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',7532.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1385,3022,40817,148483,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',710.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1386,3022,40817,148483,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5000.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1387,3022,40817,148483,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',7885.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1388,3022,40817,148483,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2265.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1389,3022,40817,148483,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2736.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1390,3022,40817,148483,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',5000.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1391,3022,40817,148483,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',6034.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1392,3022,40817,148483,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',580.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL);
INSERT INTO `balance_libro` VALUES (1393,3022,40817,148483,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',5000.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1394,3022,40817,148483,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',6614.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1395,3022,40817,148483,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1311.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1396,3022,40817,148483,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',3600.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1397,3022,40817,148483,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',7730.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1398,3022,40817,148483,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1350.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1399,3022,40817,148483,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',975.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1400,3022,40817,148483,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',730.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1401,3022,40817,148483,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',2244.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1402,3022,40817,148483,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',6680.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1403,3022,40817,148483,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7000.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1404,3022,40817,148483,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1865.00,NULL,NULL,1,'2021-08-12 13:03:06','2021-08-12 13:03:06',NULL),(1405,3022,40817,148483,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',6195.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1406,3022,40817,148483,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',4215.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1407,3022,40817,148483,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',5000.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1408,3022,40817,148483,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',6085.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1409,3022,40817,148483,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2479.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1410,3022,40817,148483,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',5905.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1411,3022,40817,148483,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',370.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1412,3022,40817,148483,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',3410.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1413,3022,40817,148483,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',4705.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL);
INSERT INTO `balance_libro` VALUES (1414,3022,40817,148483,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1620.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1415,3022,40817,148483,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1012.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1416,3022,40817,148483,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',7080.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1417,3022,40817,148483,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',5000.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1418,3022,40817,148483,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3000.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1419,3022,40817,148483,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2638.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1420,3022,40817,148483,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1551.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1421,3022,40817,148483,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',5240.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1422,3022,40817,148483,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',410.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1423,3022,40817,148483,3,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1665.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1424,3022,40817,148483,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',5000.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1425,3022,40817,148483,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',3670.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1426,3022,40817,148483,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',4315.00,NULL,NULL,1,'2021-08-12 13:03:07','2021-08-12 13:03:07',NULL),(1427,3022,40817,148483,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',3589.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1428,3022,40817,148483,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',3750.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1429,3022,40817,148483,3,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1400.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1430,3022,40817,148483,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',940.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1431,3022,40817,148483,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',4700.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1432,3022,40817,148483,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',3700.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1433,3022,40817,148483,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2324.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1434,3022,40817,148483,3,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',5300.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL);
INSERT INTO `balance_libro` VALUES (1435,3022,40817,148483,3,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2094.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1436,3022,40817,148483,3,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',450.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1437,3022,40817,148483,3,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2329.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1438,3022,40817,148483,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',990.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1439,3022,40817,148483,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4190.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1440,3022,40817,148483,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1880.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1441,3022,40817,148483,3,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4930.00,NULL,NULL,1,'2021-08-12 13:03:08','2021-08-12 13:03:08',NULL),(1442,3022,40817,148484,3,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',5029.00,NULL,NULL,1,'2021-08-12 13:03:23','2021-08-12 13:03:23',NULL),(1443,3022,40817,148484,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1739.00,NULL,NULL,1,'2021-08-12 13:03:23','2021-08-12 13:03:23',NULL),(1444,3022,40817,148484,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1936.00,NULL,NULL,1,'2021-08-12 13:03:23','2021-08-12 13:03:23',NULL),(1445,3022,40817,148484,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3155.00,NULL,NULL,1,'2021-08-12 13:03:23','2021-08-12 13:03:23',NULL),(1446,3022,40817,148484,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',420.00,NULL,NULL,1,'2021-08-12 13:03:23','2021-08-12 13:03:23',NULL),(1447,3022,40817,148484,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',340.00,NULL,NULL,1,'2021-08-12 13:03:23','2021-08-12 13:03:23',NULL),(1448,3022,40817,148484,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',6095.00,NULL,NULL,1,'2021-08-12 13:03:23','2021-08-12 13:03:23',NULL),(1449,3022,40817,148484,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',5452.00,NULL,NULL,1,'2021-08-12 13:03:23','2021-08-12 13:03:23',NULL),(1450,3022,40817,148484,3,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2220.00,NULL,NULL,1,'2021-08-12 13:03:23','2021-08-12 13:03:23',NULL),(1451,3022,40817,148484,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',8599.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1452,3022,40817,148484,3,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',5000.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1453,3022,40817,148484,3,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',5320.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1454,3022,40817,148484,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',7717.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1455,3022,40817,148484,3,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1700.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL);
INSERT INTO `balance_libro` VALUES (1456,3022,40817,148484,3,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',5000.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1457,3022,40817,148484,3,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',5140.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1458,3022,40817,148484,3,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2090.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1459,3022,40817,148484,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3138.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1460,3022,40817,148484,3,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2662.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1461,3022,40817,148484,3,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',7745.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1462,3022,40817,148484,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',6500.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1463,3022,40817,148484,3,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',3620.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1464,3022,40817,148484,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',858.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1465,3022,40817,148484,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',3495.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1466,3022,40817,148484,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',5185.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1467,3022,40817,148484,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1610.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1468,3022,40817,148484,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',5925.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1469,3022,40817,148484,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4515.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1470,3022,40817,148484,3,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',6659.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1471,3022,40817,148484,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4933.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1472,3022,40817,148484,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',6140.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1473,3022,40817,148484,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1190.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1474,3022,40817,148484,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',5000.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1475,3022,40817,148484,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',5575.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL),(1476,3022,40817,148484,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1408.00,NULL,NULL,1,'2021-08-12 13:03:24','2021-08-12 13:03:24',NULL);
INSERT INTO `balance_libro` VALUES (1477,3022,40817,148484,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',10040.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1478,3022,40817,148484,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',3630.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1479,3022,40817,148484,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1560.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1480,3022,40817,148484,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',1560.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1481,3022,40817,148484,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',3630.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1482,3022,40817,148484,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',5485.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1483,3022,40817,148484,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',4515.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1484,3022,40817,148484,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',5968.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1485,3022,40817,148484,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3430.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1486,3022,40817,148484,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1507.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1487,3022,40817,148484,3,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',4150.00,NULL,NULL,1,'2021-08-12 13:03:25','2021-08-12 13:03:25',NULL),(1488,3022,40817,148485,3,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',4253.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1489,3022,40817,148485,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',4404.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1490,3022,40817,148485,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6200.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1491,3022,40817,148485,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1342.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1492,3022,40817,148485,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',7720.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1493,3022,40817,148485,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',2020.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1494,3022,40817,148485,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4318.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1495,3022,40817,148485,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',2460.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1496,3022,40817,148485,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6970.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1497,3022,40817,148485,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1507.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL);
INSERT INTO `balance_libro` VALUES (1498,3022,40817,148485,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4150.00,NULL,NULL,1,'2021-08-12 13:03:36','2021-08-12 13:03:36',NULL),(1499,3022,40817,148485,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4100.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1500,3022,40817,148485,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2110.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1501,3022,40817,148485,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',6000.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1502,3022,40817,148485,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',5450.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1503,3022,40817,148485,3,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',7060.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1504,3022,40817,148485,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',5055.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1505,3022,40817,148485,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',6535.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1506,3022,40817,148485,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1438.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1507,3022,40817,148485,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',6667.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1508,3022,40817,148485,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',300.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1509,3022,40817,148485,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2288.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1510,3022,40817,148485,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7190.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1511,3022,40817,148485,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1330.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1512,3022,40817,148485,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',5000.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1513,3022,40817,148485,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',5530.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1514,3022,40817,148485,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2799.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1515,3022,40817,148485,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',530.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1516,3022,40817,148485,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',7000.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1517,3022,40817,148485,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',7005.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1518,3022,40817,148485,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',4380.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL);
INSERT INTO `balance_libro` VALUES (1519,3022,40817,148485,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1199.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1520,3022,40817,148485,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',6310.00,NULL,NULL,1,'2021-08-12 13:03:37','2021-08-12 13:03:37',NULL),(1521,3022,40817,148485,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1200.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1522,3022,40817,148485,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6000.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1523,3022,40817,148485,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',2870.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1524,3022,40817,148485,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1440.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1525,3022,40817,148485,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',2255.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1526,3022,40817,148485,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6309.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1527,3022,40817,148485,3,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6309.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1528,3022,40817,148485,3,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',5250.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1529,3022,40817,148485,3,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',2520.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1530,3022,40817,148485,3,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1287.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1531,3022,40817,148485,3,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',6050.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1532,3022,40817,148485,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',4109.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1533,3022,40817,148485,3,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3170.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1534,3022,40817,148485,3,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3790.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1535,3022,40817,148485,3,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3409.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1536,3022,40817,148485,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',8080.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1537,3022,40817,148485,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1660.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1538,3022,40817,148485,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5010.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1539,3022,40817,148485,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',6619.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL);
INSERT INTO `balance_libro` VALUES (1540,3022,40817,148485,3,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',4890.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1541,3022,40817,148485,3,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1880.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1542,3022,40817,148485,3,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2684.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1543,3022,40817,148485,3,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',280.00,NULL,NULL,1,'2021-08-12 13:03:38','2021-08-12 13:03:38',NULL),(1544,3022,40817,148485,3,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5351.00,NULL,NULL,1,'2021-08-12 13:03:39','2021-08-12 13:03:39',NULL),(1545,3022,40817,148485,3,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4328.00,NULL,NULL,1,'2021-08-12 13:03:39','2021-08-12 13:03:39',NULL),(1546,3022,40817,148487,3,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',737.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1547,3022,40817,148487,3,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3940.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1548,3022,40817,148487,3,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2820.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1549,3022,40817,148487,3,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1550.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1550,3022,40817,148487,3,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1630.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1551,3022,40817,148487,3,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1320.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1552,3022,40817,148487,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',6295.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1553,3022,40817,148487,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',7000.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1554,3022,40817,148487,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',2960.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1555,3022,40817,148487,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',5764.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1556,3022,40817,148487,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1445.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1557,3022,40817,148487,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',2370.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1558,3022,40817,148487,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',5870.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1559,3022,40817,148487,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',6925.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1560,3022,40817,148487,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',3970.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL);
INSERT INTO `balance_libro` VALUES (1561,3022,40817,148487,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1749.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1562,3022,40817,148487,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',2360.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1563,3022,40817,148487,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',5465.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1564,3022,40817,148487,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',6000.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1565,3022,40817,148487,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',5745.00,NULL,NULL,1,'2021-08-12 13:04:05','2021-08-12 13:04:05',NULL),(1566,3022,40817,148487,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',4895.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1567,3022,40817,148487,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',407.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1568,3022,40817,148487,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',407.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1569,3022,40817,148487,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',5710.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1570,3022,40817,148487,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',4620.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1571,3022,40817,148487,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',385.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1572,3022,40817,148487,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2189.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1573,3022,40817,148487,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',8030.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1574,3022,40817,148487,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',990.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1575,3022,40817,148487,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3370.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1576,3022,40817,148487,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',6450.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1577,3022,40817,148487,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',3610.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1578,3022,40817,148487,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',3230.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1579,3022,40817,148487,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4037.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1580,3022,40817,148487,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4000.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1581,3022,40817,148487,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4829.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL);
INSERT INTO `balance_libro` VALUES (1582,3022,40817,148487,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',680.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1583,3022,40817,148487,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1090.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1584,3022,40817,148487,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1166.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1585,3022,40817,148487,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',6780.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1586,3022,40817,148487,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2760.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1587,3022,40817,148487,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1452.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1588,3022,40817,148487,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2728.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1589,3022,40817,148487,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',6050.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1590,3022,40817,148487,3,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',5585.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1591,3022,40817,148487,3,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',3830.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1592,3022,40817,148487,3,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',6969.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1593,3022,40817,148487,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',750.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1594,3022,40817,148487,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',2620.00,NULL,NULL,1,'2021-08-12 13:04:06','2021-08-12 13:04:06',NULL),(1595,3022,40817,148487,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',6000.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1596,3022,40817,148487,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',6020.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1597,3022,40817,148487,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',880.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1598,3022,40817,148487,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',520.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1599,3022,40817,148487,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',270.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1600,3022,40817,148487,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',7900.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1601,3022,40817,148487,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',7000.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1602,3022,40817,148487,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',4900.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL);
INSERT INTO `balance_libro` VALUES (1603,3022,40817,148487,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',5155.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1604,3022,40817,148487,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1535.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1605,3022,40817,148487,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',6000.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1606,3022,40817,148487,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5250.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1607,3022,40817,148487,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4250.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1608,3022,40817,148487,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4755.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1609,3022,40817,148487,3,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',4367.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1610,3022,40817,148487,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',4870.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1611,3022,40817,148487,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',4740.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1612,3022,40817,148487,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',900.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1613,3022,40817,148487,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1650.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1614,3022,40817,148487,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5605.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1615,3022,40817,148487,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',570.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1616,3022,40817,148487,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',2890.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1617,3022,40817,148487,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',5000.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1618,3022,40817,148487,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',5348.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1619,3022,40817,148487,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',530.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1620,3022,40817,148487,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',4660.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1621,3022,40817,148487,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5973.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1622,3022,40817,148487,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',8030.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL),(1623,3022,40817,148487,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',6050.00,NULL,NULL,1,'2021-08-12 13:04:07','2021-08-12 13:04:07',NULL);
INSERT INTO `balance_libro` VALUES (1624,3022,40817,148488,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',6425.00,NULL,NULL,1,'2021-08-12 13:04:19','2021-08-12 13:04:19',NULL),(1625,3022,40817,148488,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',3210.00,NULL,NULL,1,'2021-08-12 13:04:19','2021-08-12 13:04:19',NULL),(1626,3022,40817,148488,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4740.00,NULL,NULL,1,'2021-08-12 13:04:19','2021-08-12 13:04:19',NULL),(1627,3022,40817,148488,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2225.00,NULL,NULL,1,'2021-08-12 13:04:19','2021-08-12 13:04:19',NULL),(1628,3022,40817,148488,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',7000.00,NULL,NULL,1,'2021-08-12 13:04:19','2021-08-12 13:04:19',NULL),(1629,3022,40817,148488,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2955.00,NULL,NULL,1,'2021-08-12 13:04:19','2021-08-12 13:04:19',NULL),(1630,3022,40817,148488,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1670.00,NULL,NULL,1,'2021-08-12 13:04:19','2021-08-12 13:04:19',NULL),(1631,3022,40817,148488,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2330.00,NULL,NULL,1,'2021-08-12 13:04:19','2021-08-12 13:04:19',NULL),(1632,3022,40817,148488,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2904.00,NULL,NULL,1,'2021-08-12 13:04:19','2021-08-12 13:04:19',NULL),(1633,3022,40817,148488,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',5000.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1634,3022,40817,148488,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',3765.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1635,3022,40817,148488,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2250.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1636,3022,40817,148488,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3113.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1637,3022,40817,148488,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',7200.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1638,3022,40817,148488,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3000.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1639,3022,40817,148488,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',5000.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1640,3022,40817,148488,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3675.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1641,3022,40817,148488,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',560.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1642,3022,40817,148488,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',7000.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1643,3022,40817,148488,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2680.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1644,3022,40817,148488,3,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',7345.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL);
INSERT INTO `balance_libro` VALUES (1645,3022,40817,148488,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1150.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1646,3022,40817,148488,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',2380.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1647,3022,40817,148488,3,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',913.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1648,3022,40817,148488,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',7000.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1649,3022,40817,148488,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',6665.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1650,3022,40817,148488,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1910.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1651,3022,40817,148488,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',6000.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1652,3022,40817,148488,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3480.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1653,3022,40817,148488,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',3460.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1654,3022,40817,148488,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1960.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1655,3022,40817,148488,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',3305.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1656,3022,40817,148488,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1030.00,NULL,NULL,1,'2021-08-12 13:04:20','2021-08-12 13:04:20',NULL),(1657,3022,40817,148488,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1920.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1658,3022,40817,148488,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1920.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1659,3022,40817,148488,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',7000.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1660,3022,40817,148488,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',7150.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1661,3022,40817,148488,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',2070.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1662,3022,40817,148488,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',2975.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1663,3022,40817,148488,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',4150.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1664,3022,40817,148488,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1900.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1665,3022,40817,148488,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',510.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL);
INSERT INTO `balance_libro` VALUES (1666,3022,40817,148488,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',7000.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1667,3022,40817,148488,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',6700.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1668,3022,40817,148488,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',5015.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1669,3022,40817,148488,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',7105.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1670,3022,40817,148488,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',4700.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1671,3022,40817,148488,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',3000.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1672,3022,40817,148488,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',6230.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1673,3022,40817,148488,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',500.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1674,3022,40817,148488,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',3480.00,NULL,NULL,1,'2021-08-12 13:04:21','2021-08-12 13:04:21',NULL),(1675,3022,40817,148488,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',3848.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1676,3022,40817,148488,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',6530.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1677,3022,40817,148488,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',560.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1678,3022,40817,148488,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',510.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1679,3022,40817,148488,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1210.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1680,3022,40817,148488,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',5010.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1681,3022,40817,148488,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',5000.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1682,3022,40817,148488,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',2700.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1683,3022,40817,148488,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1060.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1684,3022,40817,148488,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',4030.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1685,3022,40817,148488,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',4000.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1686,3022,40817,148488,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',4310.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL);
INSERT INTO `balance_libro` VALUES (1687,3022,40817,148488,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',5490.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1688,3022,40817,148488,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4279.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1689,3022,40817,148488,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',630.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1690,3022,40817,148488,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3670.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1691,3022,40817,148488,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1670.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1692,3022,40817,148488,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3861.00,NULL,NULL,1,'2021-08-12 13:04:22','2021-08-12 13:04:22',NULL),(1693,3022,40819,151518,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',5604.72,NULL,NULL,1,'2021-08-18 12:44:17','2021-08-18 12:44:17',NULL),(1694,3022,40819,151518,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',5604.72,NULL,NULL,1,'2021-08-18 12:44:22','2021-08-18 12:44:54','2021-08-18 12:44:54'),(1695,3022,40819,151518,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',217000.00,NULL,NULL,1,'2021-08-18 12:44:31','2021-10-14 12:53:16','2021-10-14 12:53:16'),(1696,3022,40819,151518,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',45322.81,NULL,NULL,1,'2021-08-18 13:37:44','2021-08-18 13:37:44',NULL),(1697,3022,40819,151517,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',176940.00,NULL,NULL,1,'2021-08-19 13:00:27','2021-10-14 12:52:57','2021-10-14 12:52:57'),(1698,3022,40720,1533,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3195.55,NULL,NULL,1,'2021-08-24 16:35:55','2021-08-24 16:35:55',NULL),(1699,3022,40720,1533,8,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',7101.44,NULL,NULL,1,'2021-08-25 17:34:13','2021-08-25 17:34:13',NULL),(1700,3022,40720,1533,8,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',0.00,NULL,NULL,1,'2021-08-25 17:34:18','2021-08-25 17:34:18',NULL),(1701,3022,40720,1533,16,599,'App\\Models\\PeriodLiquidation',NULL,599,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',8986.15,NULL,NULL,1,'2021-08-25 17:36:39','2021-08-25 17:36:39',NULL),(1702,3022,40720,1534,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1660.00,NULL,NULL,1,'2021-09-01 15:02:08','2021-09-01 15:02:08',NULL),(1703,3022,40720,1534,2,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',17090.00,NULL,NULL,1,'2021-09-09 13:44:11','2021-09-09 13:44:11',NULL),(1704,3022,40720,1534,2,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',10438.00,NULL,NULL,1,'2021-09-09 13:44:49','2021-09-09 13:44:49',NULL),(1705,3022,40720,1534,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',12465.42,NULL,NULL,1,'2021-09-09 13:45:22','2021-09-09 13:45:22',NULL),(1706,3022,40720,1534,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',17899.02,NULL,NULL,1,'2021-09-09 13:45:54','2021-09-09 13:45:54',NULL);
INSERT INTO `balance_libro` VALUES (1707,3022,40720,1534,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',16490.00,NULL,NULL,1,'2021-09-09 13:46:26','2021-09-09 13:46:26',NULL),(1708,3022,40720,1534,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',5990.00,NULL,NULL,1,'2021-09-09 13:46:52','2021-09-09 13:46:52',NULL),(1709,3022,40720,1534,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',11814.98,NULL,NULL,1,'2021-09-09 13:47:22','2021-09-09 13:47:22',NULL),(1710,3022,40720,1534,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',875.00,NULL,NULL,1,'2021-09-09 13:48:00','2021-09-09 13:48:00',NULL),(1711,3022,40720,1534,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',11272.00,NULL,NULL,1,'2021-09-09 13:55:41','2021-09-09 13:55:41',NULL),(1712,3022,40720,1534,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2135.95,NULL,NULL,1,'2021-09-09 13:56:25','2021-09-09 13:56:25',NULL),(1713,3022,40720,1534,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',15342.35,NULL,NULL,1,'2021-09-09 13:58:33','2021-09-09 13:58:33',NULL),(1714,3022,40720,1534,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-15','2021-08-15',19248.67,NULL,NULL,1,'2021-09-09 14:00:35','2021-09-09 14:00:35',NULL),(1715,3022,40720,1534,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-15','2021-08-15',10770.92,NULL,NULL,1,'2021-09-09 14:01:30','2021-09-09 14:03:13','2021-09-09 14:03:13'),(1716,3022,40720,1534,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',12552.02,NULL,NULL,1,'2021-09-09 14:02:34','2021-09-09 14:02:34',NULL),(1717,3022,40720,1534,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',10770.92,NULL,NULL,1,'2021-09-09 14:03:13','2021-09-09 14:03:13',NULL),(1718,3022,40720,1534,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',19852.20,NULL,NULL,1,'2021-09-10 10:50:07','2021-09-10 10:50:07',NULL),(1719,3022,40720,1534,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',21937.17,NULL,NULL,1,'2021-09-10 10:51:19','2021-09-10 10:51:19',NULL),(1720,3022,40720,1534,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',19931.75,NULL,NULL,1,'2021-09-10 10:52:11','2021-09-10 10:52:11',NULL),(1721,3022,40720,1534,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',11683.98,NULL,NULL,1,'2021-09-10 10:53:11','2021-09-10 10:53:11',NULL),(1722,3022,40720,1534,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',5927.06,NULL,NULL,1,'2021-09-10 10:54:32','2021-09-10 10:54:32',NULL),(1723,3022,40720,1534,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',5253.98,NULL,NULL,1,'2021-09-10 10:56:01','2021-09-10 10:56:01',NULL),(1724,3022,40720,1534,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',5352.03,NULL,NULL,1,'2021-09-10 10:56:51','2021-09-10 10:56:51',NULL),(1725,3022,40720,1534,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',18962.97,NULL,NULL,1,'2021-09-10 10:57:56','2021-09-10 10:57:56',NULL),(1726,3022,40720,1534,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',10692.01,NULL,NULL,1,'2021-09-10 10:58:45','2021-09-10 10:58:45',NULL),(1727,3022,40720,1534,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',8110.01,NULL,NULL,1,'2021-09-10 10:59:42','2021-09-10 10:59:42',NULL);
INSERT INTO `balance_libro` VALUES (1728,3022,40720,1534,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',8459.06,NULL,NULL,1,'2021-09-10 11:00:25','2021-09-10 11:00:25',NULL),(1729,3022,40720,1534,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',5071.00,NULL,NULL,1,'2021-09-10 11:01:15','2021-09-10 11:01:15',NULL),(1730,3022,40720,1534,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',17476.02,NULL,NULL,1,'2021-09-10 12:57:06','2021-09-10 12:57:06',NULL),(1731,3022,40819,151519,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',17000.00,NULL,NULL,1,'2021-09-20 12:43:53','2021-09-20 12:43:53',NULL),(1732,3022,40819,151519,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',470.00,NULL,NULL,1,'2021-09-20 12:43:53','2021-09-20 12:43:53',NULL),(1733,3022,40819,151519,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',920.81,NULL,NULL,1,'2021-09-20 12:43:53','2021-09-20 12:43:53',NULL),(1734,3022,40819,151519,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',6000.00,NULL,NULL,1,'2021-09-20 12:43:53','2021-09-20 12:43:53',NULL),(1735,3022,40819,151519,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',25000.00,NULL,NULL,1,'2021-09-20 12:43:53','2021-09-20 12:43:53',NULL),(1736,3022,40819,151519,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',217000.00,NULL,NULL,1,'2021-09-20 13:01:12','2021-10-14 12:52:14','2021-10-14 12:52:14'),(1737,3022,40819,151519,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',264500.00,NULL,NULL,1,'2021-09-20 13:01:12','2021-10-14 12:51:51','2021-10-14 12:51:51'),(1738,3022,40819,151520,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',22558.02,NULL,NULL,1,'2021-09-20 13:10:26','2021-09-20 13:11:07','2021-09-20 13:11:07'),(1739,3022,40819,151520,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',22558.02,NULL,NULL,1,'2021-09-20 13:11:07','2021-09-20 13:11:07',NULL),(1740,3022,40819,151519,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',8469.99,NULL,NULL,1,'2021-09-20 15:56:23','2021-09-20 16:02:15','2021-09-20 16:02:15'),(1741,3022,40819,151519,3,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',8469.99,NULL,NULL,1,'2021-09-20 16:04:35','2021-09-20 16:04:35',NULL),(1742,3022,40720,1534,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2602.58,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1743,3022,40720,1534,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',3010.80,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1744,3022,40720,1534,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',10263.29,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1745,3022,40720,1534,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',20989.73,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1746,3022,40720,1534,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',7462.03,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1747,3022,40720,1534,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',19667.04,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL);
INSERT INTO `balance_libro` VALUES (1748,3022,40720,1534,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',7834.80,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1749,3022,40720,1534,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',15499.00,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1750,3022,40720,1534,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',2080.54,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1751,3022,40720,1534,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2979.99,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1752,3022,40720,1534,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',6340.84,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1753,3022,40720,1534,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',22662.37,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1754,3022,40720,1534,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',2301.00,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1755,3022,40720,1534,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',27293.50,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1756,3022,40720,1534,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',200.00,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1757,3022,40720,1534,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',4453.86,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1758,3022,40720,1534,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',11799.00,NULL,NULL,1,'2021-09-21 12:37:03','2021-09-21 12:37:03',NULL),(1759,3022,40720,1534,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',19788.40,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1760,3022,40720,1534,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',2287.93,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1761,3022,40720,1534,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',23567.26,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1762,3022,40720,1534,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',1097.41,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1763,3022,40720,1534,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',6545.34,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1764,3022,40720,1534,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',8939.96,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1765,3022,40720,1534,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',1176.64,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1766,3022,40720,1534,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',773.44,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1767,3022,40720,1534,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1309.06,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1768,3022,40720,1534,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2810.51,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL);
INSERT INTO `balance_libro` VALUES (1769,3022,40720,1534,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',961.01,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1770,3022,40720,1534,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',28155.40,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1771,3022,40720,1534,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',7283.60,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1772,3022,40720,1534,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',21033.33,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1773,3022,40720,1534,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',1944.00,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1774,3022,40720,1534,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',2435.93,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1775,3022,40720,1534,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2024.54,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1776,3022,40720,1534,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',7659.94,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1777,3022,40720,1534,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',5509.73,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1778,3022,40720,1534,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',7326.32,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1779,3022,40720,1534,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2043.07,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1780,3022,40720,1534,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',427.46,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1781,3022,40720,1534,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',4725.58,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1782,3022,40720,1534,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3285.05,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1783,3022,40720,1534,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',29799.88,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1784,3022,40720,1534,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2635.00,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1785,3022,40720,1534,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2628.08,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1786,3022,40720,1534,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',3102.02,NULL,NULL,1,'2021-09-21 12:37:04','2021-09-21 12:37:04',NULL),(1787,3022,40720,1534,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',2709.98,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1788,3022,40720,1534,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',2656.00,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1789,3022,40720,1534,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',27366.12,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL);
INSERT INTO `balance_libro` VALUES (1790,3022,40720,1534,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',2226.98,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1791,3022,40720,1534,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',11687.31,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1792,3022,40720,1534,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2151.37,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1793,3022,40720,1534,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2208.06,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1794,3022,40720,1534,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',4398.92,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1795,3022,40720,1534,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',2383.44,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1796,3022,40720,1534,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',2408.76,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1797,3022,40720,1534,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4796.26,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1798,3022,40720,1534,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',74477.00,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1799,3022,40720,1534,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',857.74,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1800,3022,40720,1534,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',6129.98,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1801,3022,40720,1534,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1168.03,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1802,3022,40720,1534,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',3341.55,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1803,3022,40720,1534,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',31603.00,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1804,3022,40720,1534,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1989.70,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1805,3022,40720,1534,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',320.40,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1806,3022,40720,1534,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',453.48,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1807,3022,40720,1534,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1587.96,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1808,3022,40720,1534,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',884.77,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1809,3022,40720,1534,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',302.58,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1810,3022,40720,1534,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',7332.40,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL);
INSERT INTO `balance_libro` VALUES (1811,3022,40720,1534,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',984.23,NULL,NULL,1,'2021-09-21 12:37:05','2021-09-21 12:37:05',NULL),(1812,3022,40720,1534,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',10808.67,NULL,NULL,1,'2021-09-22 17:32:45','2021-09-22 17:39:59','2021-09-22 17:39:59'),(1813,3022,40720,1534,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',13127.01,NULL,NULL,1,'2021-09-22 17:37:52','2021-09-22 17:37:52',NULL),(1814,3022,40720,1534,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',11319.32,NULL,NULL,1,'2021-09-22 17:39:59','2021-09-22 17:43:32','2021-09-22 17:43:32'),(1815,3022,40720,1534,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',13127.10,NULL,NULL,1,'2021-09-22 17:43:32','2021-09-22 17:43:32',NULL),(1816,3022,40720,1527,2,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',542956.83,NULL,NULL,1,'2021-09-23 11:13:42','2021-09-23 11:13:42',NULL),(1817,3022,40720,1528,2,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',417277.99,NULL,NULL,1,'2021-09-23 11:15:34','2021-09-23 11:15:34',NULL),(1818,3022,40720,1529,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',516669.90,NULL,NULL,1,'2021-09-23 11:16:37','2021-09-23 11:16:37',NULL),(1819,3022,40819,151520,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',4229.98,NULL,NULL,1,'2021-09-24 10:39:57','2021-09-24 10:40:37','2021-09-24 10:40:37'),(1820,3022,40819,151520,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',4229.98,NULL,NULL,1,'2021-09-24 10:40:37','2021-10-14 12:43:23','2021-10-14 12:43:23'),(1821,3022,40819,151520,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',2650.00,NULL,NULL,1,'2021-09-24 10:43:06','2021-09-24 10:43:06',NULL),(1822,3022,40720,1535,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',13414.97,NULL,NULL,1,'2021-10-07 10:46:45','2021-10-07 10:46:45',NULL),(1823,3022,40720,1535,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',9558.94,NULL,NULL,1,'2021-10-07 10:57:28','2021-10-07 10:57:28',NULL),(1824,3022,40720,1535,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',9730.96,NULL,NULL,1,'2021-10-07 10:58:25','2021-10-07 10:58:25',NULL),(1825,3022,40720,1535,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',10498.00,NULL,NULL,1,'2021-10-07 10:59:41','2021-10-07 10:59:41',NULL),(1826,3022,40720,1535,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',6978.07,NULL,NULL,1,'2021-10-07 11:02:31','2021-10-07 11:02:31',NULL),(1827,3022,40720,1535,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',4734.08,NULL,NULL,1,'2021-10-07 11:03:54','2021-10-07 11:03:54',NULL),(1828,3022,40720,1535,2,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',5095.99,NULL,NULL,1,'2021-10-07 11:04:28','2021-10-07 11:04:28',NULL),(1829,3022,40720,1535,2,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',4651.00,NULL,NULL,1,'2021-10-07 11:04:48','2021-10-07 11:04:48',NULL),(1830,3022,40720,1535,2,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',4660.00,NULL,NULL,1,'2021-10-07 11:05:33','2021-10-07 11:05:33',NULL);
INSERT INTO `balance_libro` VALUES (1831,3022,40720,1535,2,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',6881.00,NULL,NULL,1,'2021-10-07 11:07:52','2021-10-07 11:07:52',NULL),(1832,3022,40720,1535,2,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',6927.99,NULL,NULL,1,'2021-10-07 11:08:12','2021-10-07 11:08:12',NULL),(1833,3022,40720,1535,2,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',7250.01,NULL,NULL,1,'2021-10-07 11:08:39','2021-10-07 11:08:39',NULL),(1834,3022,40720,1535,2,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',2912.00,NULL,NULL,1,'2021-10-07 11:09:09','2021-10-07 11:09:09',NULL),(1835,3022,40720,1535,2,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',5926.00,NULL,NULL,1,'2021-10-07 11:09:36','2021-10-07 11:09:36',NULL),(1836,3022,40720,1535,2,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',5382.01,NULL,NULL,1,'2021-10-07 11:10:01','2021-10-07 11:10:01',NULL),(1837,3022,40720,1535,2,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',4442.01,NULL,NULL,1,'2021-10-07 11:10:30','2021-10-07 11:10:30',NULL),(1838,3022,40720,1535,2,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',13510.01,NULL,NULL,1,'2021-10-07 11:10:58','2021-10-07 11:10:58',NULL),(1839,3022,40720,1535,2,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',22270.98,NULL,NULL,1,'2021-10-07 11:11:31','2021-10-07 11:11:31',NULL),(1840,3022,40720,1535,2,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',8585.99,NULL,NULL,1,'2021-10-07 11:11:52','2021-10-07 11:11:52',NULL),(1841,3022,40720,1535,2,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',9131.01,NULL,NULL,1,'2021-10-07 11:12:14','2021-10-07 11:12:14',NULL),(1842,3022,40720,1535,2,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',4590.00,NULL,NULL,1,'2021-10-07 11:12:30','2021-10-07 11:12:30',NULL),(1843,3022,40720,1535,2,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',6771.99,NULL,NULL,1,'2021-10-07 11:12:56','2021-10-07 11:12:56',NULL),(1844,3022,40720,1535,2,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',6067.42,NULL,NULL,1,'2021-10-07 11:13:38','2021-10-07 11:13:38',NULL),(1845,3022,40720,1535,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',6160.00,NULL,NULL,1,'2021-10-07 11:14:13','2021-10-07 11:14:13',NULL),(1846,3022,40720,1535,2,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',14817.99,NULL,NULL,1,'2021-10-07 11:14:33','2021-10-07 11:14:33',NULL),(1847,3022,40720,1535,2,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',6913.99,NULL,NULL,1,'2021-10-07 11:14:57','2021-10-07 11:14:57',NULL),(1848,3022,40720,1535,2,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',3050.01,NULL,NULL,1,'2021-10-07 11:15:21','2021-10-07 11:15:21',NULL),(1849,3022,40720,1535,2,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',5853.00,NULL,NULL,1,'2021-10-07 11:15:38','2021-10-07 11:15:38',NULL),(1850,3022,40720,1535,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',9991.01,NULL,NULL,1,'2021-10-07 11:15:57','2021-10-07 11:15:57',NULL),(1851,3022,40720,1535,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',9100.07,NULL,NULL,1,'2021-10-07 13:12:59','2021-10-07 13:12:59',NULL);
INSERT INTO `balance_libro` VALUES (1852,3022,40720,1535,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',19269.90,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1853,3022,40720,1535,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',8798.24,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1854,3022,40720,1535,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',2602.58,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1855,3022,40720,1535,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',7320.05,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1856,3022,40720,1535,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1459.26,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1857,3022,40720,1535,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1756.00,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1858,3022,40720,1535,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1899.00,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1859,3022,40720,1535,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1899.00,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1860,3022,40720,1535,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',2432.50,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1861,3022,40720,1535,3,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1899.00,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1862,3022,40720,1535,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',4986.10,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1863,3022,40720,1535,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1688.40,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1864,3022,40720,1535,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',410.00,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1865,3022,40720,1535,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1357.33,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1866,3022,40720,1535,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',5858.54,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1867,3022,40720,1535,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',937.09,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1868,3022,40720,1535,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',3607.90,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1869,3022,40720,1535,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',2289.99,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1870,3022,40720,1535,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2800.00,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1871,3022,40720,1535,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2800.00,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1872,3022,40720,1535,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',7145.02,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL);
INSERT INTO `balance_libro` VALUES (1873,3022,40720,1535,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2510.48,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1874,3022,40720,1535,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',0.93,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1875,3022,40720,1535,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',10689.25,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1876,3022,40720,1535,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',1482.71,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1877,3022,40720,1535,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',13657.19,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1878,3022,40720,1535,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',2800.00,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1879,3022,40720,1535,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',3314.17,NULL,NULL,1,'2021-10-07 13:13:00','2021-10-07 13:13:00',NULL),(1880,3022,40720,1535,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',2530.68,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1881,3022,40720,1535,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1997.44,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1882,3022,40720,1535,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2018.57,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1883,3022,40720,1535,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2369.99,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1884,3022,40720,1535,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',8036.67,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1885,3022,40720,1535,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',882.26,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1886,3022,40720,1535,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',3115.20,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1887,3022,40720,1535,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',1647.32,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1888,3022,40720,1535,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',5220.00,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1889,3022,40720,1535,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',2839.68,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1890,3022,40720,1535,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',2812.70,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1891,3022,40720,1535,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',448.17,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1892,3022,40720,1535,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1299.00,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1893,3022,40720,1535,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',2146.27,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL);
INSERT INTO `balance_libro` VALUES (1894,3022,40720,1535,3,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',2146.27,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1895,3022,40720,1535,3,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',4005.54,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1896,3022,40720,1535,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',193.56,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1897,3022,40720,1535,3,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',2243.61,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1898,3022,40720,1535,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',316.06,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1899,3022,40720,1535,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',5673.75,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1900,3022,40720,1535,3,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',11000.03,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1901,3022,40720,1535,3,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',506.80,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1902,3022,40720,1535,3,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',0.01,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1903,3022,40720,1535,3,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',3621.06,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1904,3022,40720,1535,3,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',3999.00,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1905,3022,40720,1535,3,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',2369.99,NULL,NULL,1,'2021-10-07 13:13:01','2021-10-07 13:13:01',NULL),(1906,3022,40720,1535,3,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1860.00,NULL,NULL,1,'2021-10-07 13:13:02','2021-10-07 13:13:02',NULL),(1907,3022,40720,1535,3,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1217.09,NULL,NULL,1,'2021-10-07 13:13:02','2021-10-07 13:13:02',NULL),(1908,3022,40720,1535,3,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',2492.58,NULL,NULL,1,'2021-10-07 13:13:02','2021-10-07 13:13:02',NULL),(1909,3022,40720,1535,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',261.90,NULL,NULL,1,'2021-10-07 13:13:02','2021-10-07 13:13:02',NULL),(1910,3022,40720,1535,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',37028.95,NULL,NULL,1,'2021-10-07 13:13:02','2021-10-07 13:13:02',NULL),(1911,3022,40720,1535,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1432.74,NULL,NULL,1,'2021-10-07 13:13:02','2021-10-07 13:13:02',NULL),(1912,3022,40720,1535,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5552.86,NULL,NULL,1,'2021-10-07 13:13:02','2021-10-07 13:13:02',NULL),(1913,3022,40819,151520,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',262570.00,NULL,NULL,1,'2021-10-14 12:05:19','2021-10-14 12:51:15','2021-10-14 12:51:15'),(1914,3022,40819,151520,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',1027895.00,NULL,NULL,1,'2021-10-14 12:10:28','2021-10-14 12:51:30','2021-10-14 12:51:30');
INSERT INTO `balance_libro` VALUES (1935,3022,40819,151520,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',2100.56,NULL,NULL,1,'2021-10-14 12:44:07','2021-10-14 12:44:07',NULL),(1936,3022,40819,151520,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',1800.00,NULL,NULL,1,'2021-10-14 12:44:07','2021-10-14 12:44:07',NULL),(1937,3022,40819,151520,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',230000.01,NULL,NULL,1,'2021-10-14 12:44:07','2021-10-14 12:44:07',NULL),(1938,3022,40819,151520,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',300000.01,NULL,NULL,1,'2021-10-14 12:44:07','2021-10-14 12:44:07',NULL),(1939,3022,40819,151520,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',300000.01,NULL,NULL,1,'2021-10-14 12:44:08','2021-10-14 12:44:08',NULL),(1940,3022,40819,151520,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',4230.00,NULL,NULL,1,'2021-10-14 12:44:08','2021-10-14 12:44:08',NULL),(1941,3022,40819,151520,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',11624.11,NULL,NULL,1,'2021-10-14 12:44:08','2021-10-14 12:44:08',NULL),(1942,3022,40819,151520,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',46879.65,NULL,NULL,1,'2021-10-14 12:44:08','2021-10-14 12:44:08',NULL),(1943,3022,40819,151520,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',217000.00,NULL,NULL,1,'2021-10-14 12:51:15','2021-10-14 12:51:15',NULL),(1944,3022,40819,151520,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',849500.01,NULL,NULL,1,'2021-10-14 12:51:30','2021-10-14 12:51:30',NULL),(1945,3022,40819,151519,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',218595.04,NULL,NULL,1,'2021-10-14 12:51:51','2021-10-14 12:51:51',NULL),(1946,3022,40819,151519,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',217000.00,NULL,NULL,1,'2021-10-14 12:52:14','2021-10-14 12:52:14',NULL),(1947,3022,40819,151517,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',176393.00,NULL,NULL,1,'2021-10-14 12:52:57','2021-10-14 12:52:57',NULL),(1948,3022,40819,151518,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',179338.84,NULL,NULL,1,'2021-10-14 12:53:16','2021-10-14 12:53:16',NULL),(1949,3022,40819,151516,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',146231.40,NULL,NULL,1,'2021-10-14 12:53:29','2021-10-14 12:53:29',NULL),(1950,3022,40819,151521,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',217000.00,NULL,NULL,1,'2021-11-03 11:01:27','2021-11-03 11:01:27',NULL),(1951,3022,40819,151521,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',6400.01,NULL,NULL,1,'2021-11-03 11:02:05','2021-11-03 11:02:05',NULL),(1952,3022,40819,151521,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',100000.00,NULL,NULL,1,'2021-11-03 11:02:05','2021-11-03 11:02:05',NULL),(1953,3022,40819,151521,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',13400.04,NULL,NULL,1,'2021-11-03 11:02:05','2021-11-03 11:02:05',NULL),(1954,3022,40819,151521,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',100000.00,NULL,NULL,1,'2021-11-03 11:02:05','2021-11-03 11:02:05',NULL);
INSERT INTO `balance_libro` VALUES (1955,3022,40819,151521,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',10000.00,NULL,NULL,1,'2021-11-03 11:02:05','2021-11-03 11:02:05',NULL),(1956,3022,40819,151521,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',25620.00,NULL,NULL,1,'2021-11-03 11:08:54','2021-11-03 11:08:54',NULL),(1957,3022,40720,1536,2,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',11319.02,NULL,NULL,1,'2021-11-08 10:15:21','2021-11-08 10:15:21',NULL),(1958,3022,40720,1536,2,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',13447.92,NULL,NULL,1,'2021-11-08 10:17:08','2021-11-08 10:17:08',NULL),(1959,3022,40720,1536,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',12090.96,NULL,NULL,1,'2021-11-08 10:18:51','2021-11-08 10:18:51',NULL),(1960,3022,40720,1536,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',4568.18,NULL,NULL,1,'2021-11-08 10:19:59','2021-11-08 10:19:59',NULL),(1961,3022,40720,1536,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',11478.02,NULL,NULL,1,'2021-11-08 10:21:02','2021-11-08 10:21:02',NULL),(1962,3022,40720,1536,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',8939.97,NULL,NULL,1,'2021-11-08 10:24:46','2021-11-08 10:24:46',NULL),(1963,3022,40720,1536,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',6846.09,NULL,NULL,1,'2021-11-08 10:25:50','2021-11-08 10:25:50',NULL),(1964,3022,40720,1536,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',16740.06,NULL,NULL,1,'2021-11-08 10:26:54','2021-11-08 10:26:54',NULL),(1965,3022,40720,1536,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',10145.04,NULL,NULL,1,'2021-11-08 10:27:59','2021-11-08 10:27:59',NULL),(1966,3022,40720,1536,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',4195.94,NULL,NULL,1,'2021-11-08 10:29:02','2021-11-08 10:29:02',NULL),(1967,3022,40720,1536,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',8355.97,NULL,NULL,1,'2021-11-08 10:31:59','2021-11-08 10:31:59',NULL),(1968,3022,40720,1536,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',11601.52,NULL,NULL,1,'2021-11-08 10:33:44','2021-11-08 10:33:44',NULL),(1969,3022,40720,1536,2,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',0.01,NULL,NULL,1,'2021-11-08 10:34:18','2021-11-08 10:34:18',NULL),(1970,3022,40720,1536,2,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',5989.00,NULL,NULL,1,'2021-11-08 10:35:02','2021-11-08 10:35:02',NULL),(1971,3022,40720,1536,2,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',19275.00,NULL,NULL,1,'2021-11-08 10:35:22','2021-11-08 10:35:22',NULL),(1972,3022,40720,1536,2,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',7706.01,NULL,NULL,1,'2021-11-08 10:35:47','2021-11-08 10:35:47',NULL),(1973,3022,40720,1536,2,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',6571.97,NULL,NULL,1,'2021-11-08 10:36:07','2021-11-08 10:36:07',NULL),(1974,3022,40720,1536,2,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',5689.99,NULL,NULL,1,'2021-11-08 10:38:10','2021-11-08 10:38:10',NULL),(1975,3022,40720,1536,2,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',6607.00,NULL,NULL,1,'2021-11-08 10:38:32','2021-11-08 10:38:32',NULL);
INSERT INTO `balance_libro` VALUES (1976,3022,40720,1536,2,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',4099.00,NULL,NULL,1,'2021-11-08 10:38:56','2021-11-08 10:38:56',NULL),(1977,3022,40720,1536,2,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',7539.10,NULL,NULL,1,'2021-11-08 10:39:25','2021-11-08 10:39:25',NULL),(1978,3022,40720,1536,2,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',25423.01,NULL,NULL,1,'2021-11-08 10:40:02','2021-11-08 10:40:02',NULL),(1979,3022,40720,1536,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',9733.00,NULL,NULL,1,'2021-11-08 10:40:31','2021-11-08 10:40:31',NULL),(1980,3022,40720,1536,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',9903.00,NULL,NULL,1,'2021-11-08 10:41:02','2021-11-08 10:41:02',NULL),(1981,3022,40720,1536,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',1025.00,NULL,NULL,1,'2021-11-08 10:41:34','2021-11-08 10:41:34',NULL),(1982,3022,40720,1536,2,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',10256.98,NULL,NULL,1,'2021-11-08 10:42:08','2021-11-08 10:42:08',NULL),(1983,3022,40720,1536,2,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',10289.09,NULL,NULL,1,'2021-11-08 10:42:39','2021-11-08 10:42:39',NULL),(1984,3022,40720,1536,2,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',2488.99,NULL,NULL,1,'2021-11-08 10:42:59','2021-11-08 10:42:59',NULL),(1985,3022,40720,1536,2,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',0.01,NULL,NULL,1,'2021-11-08 10:43:12','2021-11-08 10:43:12',NULL),(1986,3022,40720,1536,2,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',13931.00,NULL,NULL,1,'2021-11-08 10:44:15','2021-11-08 10:44:15',NULL),(1987,3022,40720,1536,2,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',13972.00,NULL,NULL,1,'2021-11-08 10:44:33','2021-11-24 19:24:37','2021-11-24 19:24:37'),(1988,3022,40819,151522,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',95921.36,NULL,NULL,1,'2021-11-15 11:22:17','2021-11-15 11:22:17',NULL),(1989,3022,40720,1536,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',27083.55,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(1990,3022,40720,1536,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',2602.58,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(1991,3022,40720,1536,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',29102.00,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(1992,3022,40720,1536,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',4726.04,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(1993,3022,40720,1536,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',2888.58,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(1994,3022,40720,1536,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',777.69,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(1995,3022,40720,1536,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1214.99,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(1996,3022,40720,1536,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',3622.95,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL);
INSERT INTO `balance_libro` VALUES (1997,3022,40720,1536,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',2809.61,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(1998,3022,40720,1536,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',2147.22,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(1999,3022,40720,1536,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',2720.10,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2000,3022,40720,1536,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',3058.14,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2001,3022,40720,1536,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',10098.41,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2002,3022,40720,1536,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',4582.99,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2003,3022,40720,1536,3,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',2521.51,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2004,3022,40720,1536,3,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1160.00,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2005,3022,40720,1536,3,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',710.95,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2006,3022,40720,1536,3,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',3545.00,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2007,3022,40720,1536,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1725.35,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2008,3022,40720,1536,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',4813.29,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2009,3022,40720,1536,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',6778.82,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2010,3022,40720,1536,3,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',4263.05,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2011,3022,40720,1536,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',1158.39,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2012,3022,40720,1536,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',937.09,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2013,3022,40720,1536,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2523.19,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2014,3022,40720,1536,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',2986.49,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2015,3022,40720,1536,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',30368.70,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2016,3022,40720,1536,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',13105.64,NULL,NULL,1,'2021-11-24 17:56:14','2021-11-24 17:56:14',NULL),(2017,3022,40720,1536,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',562.87,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL);
INSERT INTO `balance_libro` VALUES (2018,3022,40720,1536,3,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',2740.05,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2019,3022,40720,1536,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',0.01,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2020,3022,40720,1536,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',278.70,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2021,3022,40720,1536,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',2225.72,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2022,3022,40720,1536,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',3588.57,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2023,3022,40720,1536,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',267.71,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2024,3022,40720,1536,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',898.21,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2025,3022,40720,1536,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',6573.60,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2026,3022,40720,1536,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',2241.25,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2027,3022,40720,1536,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',0.01,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2028,3022,40720,1536,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',2871.05,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2029,3022,40720,1536,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',2740.05,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2030,3022,40720,1536,3,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',433.88,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2031,3022,40720,1536,3,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1738.81,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2032,3022,40720,1536,3,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',8158.22,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2033,3022,40720,1536,3,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',870.00,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2034,3022,40720,1536,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',2871.05,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2035,3022,40720,1536,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',4449.10,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2036,3022,40720,1536,3,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',1936.00,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2037,3022,40720,1536,3,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',870.00,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2038,3022,40720,1536,3,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',3401.80,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL);
INSERT INTO `balance_libro` VALUES (2039,3022,40720,1536,3,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',2615.63,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2040,3022,40720,1536,3,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',2188.79,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2041,3022,40720,1536,3,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',9415.68,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2042,3022,40720,1536,3,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',2315.16,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2043,3022,40720,1536,3,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',4025.36,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2044,3022,40720,1536,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',5450.65,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2045,3022,40720,1536,3,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',203.74,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2046,3022,40720,1536,3,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',1929.50,NULL,NULL,1,'2021-11-24 17:56:15','2021-11-24 17:56:15',NULL),(2047,3022,40720,1536,3,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',3173.51,NULL,NULL,1,'2021-11-24 17:56:16','2021-11-24 17:56:16',NULL),(2048,3022,40720,1536,3,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',2303.41,NULL,NULL,1,'2021-11-24 17:56:16','2021-11-24 17:56:16',NULL),(2049,3022,40720,1536,3,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',370.70,NULL,NULL,1,'2021-11-24 17:56:16','2021-11-24 17:56:16',NULL),(2050,3022,40720,1536,3,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',4415.59,NULL,NULL,1,'2021-11-24 17:56:16','2021-11-24 17:56:16',NULL),(2051,3022,40720,1536,3,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',12879.90,NULL,NULL,1,'2021-11-24 18:17:16','2021-11-24 18:20:18','2021-11-24 18:20:18'),(2052,3022,40720,1536,3,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',12937.47,NULL,NULL,1,'2021-11-24 18:20:18','2021-11-24 18:21:21','2021-11-24 18:21:21'),(2053,3022,40720,1536,3,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',14798.50,NULL,NULL,1,'2021-11-24 18:21:21','2021-11-24 18:21:21',NULL),(2054,3022,40720,1536,3,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',14401.45,NULL,NULL,1,'2021-11-24 18:24:29','2021-11-24 18:24:29',NULL),(2055,3022,40720,1536,2,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',13972.00,NULL,NULL,1,'2021-11-24 19:24:37','2021-11-24 19:24:37',NULL),(2056,3022,40819,151521,3,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',5851.94,NULL,NULL,1,'2021-11-29 18:03:36','2021-11-29 18:05:19','2021-11-29 18:05:19'),(2057,3022,40819,151521,3,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',5852.26,NULL,NULL,1,'2021-11-29 18:05:19','2021-11-29 18:05:19',NULL),(2058,3022,40720,1537,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',6932.01,NULL,NULL,1,'2021-12-09 10:06:46','2021-12-09 10:06:46',NULL);
INSERT INTO `balance_libro` VALUES (2059,3022,40720,1537,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',12224.99,NULL,NULL,1,'2021-12-09 10:07:51','2021-12-09 10:07:51',NULL),(2060,3022,40720,1537,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',10031.09,NULL,NULL,1,'2021-12-09 10:08:18','2021-12-09 10:08:18',NULL),(2061,3022,40720,1537,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',10411.01,NULL,NULL,1,'2021-12-09 10:08:48','2021-12-09 10:08:48',NULL),(2062,3022,40720,1537,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',13936.01,NULL,NULL,1,'2021-12-09 10:09:18','2021-12-09 10:09:18',NULL),(2063,3022,40720,1537,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',7739.98,NULL,NULL,1,'2021-12-09 10:11:24','2021-12-09 10:11:24',NULL),(2064,3022,40720,1537,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-07','2021-11-07',8603.00,NULL,NULL,1,'2021-12-09 10:12:09','2021-12-09 10:12:09',NULL),(2065,3022,40720,1537,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',12941.00,NULL,NULL,1,'2021-12-09 10:13:21','2021-12-09 10:13:21',NULL),(2066,3022,40720,1537,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',12220.00,NULL,NULL,1,'2021-12-09 10:14:08','2021-12-09 10:14:08',NULL),(2067,3022,40720,1537,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',10485.00,NULL,NULL,1,'2021-12-09 10:14:29','2021-12-09 10:14:29',NULL),(2068,3022,40720,1537,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',11814.02,NULL,NULL,1,'2021-12-09 10:14:55','2021-12-09 10:14:55',NULL),(2069,3022,40720,1537,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',10721.00,NULL,NULL,1,'2021-12-09 10:15:18','2021-12-09 10:15:18',NULL),(2070,3022,40720,1537,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',12094.00,NULL,NULL,1,'2021-12-09 10:15:39','2021-12-09 10:15:39',NULL),(2071,3022,40720,1537,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',6474.00,NULL,NULL,1,'2021-12-09 10:16:52','2021-12-09 10:16:52',NULL),(2072,3022,40720,1537,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',16790.63,NULL,NULL,1,'2021-12-09 10:39:59','2021-12-09 10:39:59',NULL),(2073,3022,40720,1537,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',8778.13,NULL,NULL,1,'2021-12-09 10:43:23','2021-12-09 10:43:23',NULL),(2074,3022,40720,1537,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',0.01,NULL,NULL,1,'2021-12-09 10:44:11','2021-12-09 10:44:11',NULL),(2075,3022,40720,1537,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',0.01,NULL,NULL,1,'2021-12-09 10:46:41','2021-12-09 10:46:41',NULL),(2076,3022,40720,1537,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',0.01,NULL,NULL,1,'2021-12-09 10:46:52','2021-12-09 10:46:52',NULL),(2077,3022,40720,1537,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',7860.01,NULL,NULL,1,'2021-12-09 10:48:23','2021-12-09 10:48:23',NULL),(2078,3022,40720,1537,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',22304.86,NULL,NULL,1,'2021-12-09 10:49:54','2021-12-09 10:49:54',NULL),(2079,3022,40720,1537,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',10179.08,NULL,NULL,1,'2021-12-09 10:50:51','2021-12-09 10:50:51',NULL);
INSERT INTO `balance_libro` VALUES (2080,3022,40720,1537,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',0.01,NULL,NULL,1,'2021-12-09 10:51:41','2021-12-09 10:51:41',NULL),(2081,3022,40720,1537,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',0.01,NULL,NULL,1,'2021-12-09 10:52:02','2021-12-09 10:52:02',NULL),(2082,3022,40720,1537,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',12486.20,NULL,NULL,1,'2021-12-09 10:53:11','2021-12-09 10:53:11',NULL),(2083,3022,40720,1537,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',16887.99,NULL,NULL,1,'2021-12-09 11:39:43','2021-12-09 11:39:43',NULL),(2084,3022,40720,1537,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',16421.63,NULL,NULL,1,'2021-12-09 11:42:46','2021-12-09 11:42:46',NULL),(2085,3022,40720,1537,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',21410.96,NULL,NULL,1,'2021-12-09 11:44:10','2021-12-09 11:44:10',NULL),(2086,3022,40720,1537,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',10808.96,NULL,NULL,1,'2021-12-09 11:45:17','2021-12-09 11:45:17',NULL),(2087,3022,40720,1537,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',14741.91,NULL,NULL,1,'2021-12-09 11:46:20','2021-12-09 11:46:20',NULL),(2088,3022,40939,173428,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',6022.17,NULL,NULL,1,'2021-12-10 10:39:11','2021-12-10 10:59:04','2021-12-10 10:59:04'),(2089,3022,40939,173428,3,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',4999.72,NULL,NULL,1,'2021-12-10 10:41:53','2021-12-10 10:58:52','2021-12-10 10:58:52'),(2090,3022,40939,173428,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',6021.37,NULL,NULL,1,'2021-12-10 10:59:04','2021-12-22 13:05:36','2021-12-22 13:05:36'),(2091,3022,40939,173428,3,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3999.43,NULL,NULL,1,'2021-12-10 11:03:00','2021-12-22 13:05:26','2021-12-22 13:05:26'),(2092,3022,40939,173428,3,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',4009.73,NULL,NULL,1,'2021-12-10 11:04:06','2021-12-22 13:02:44','2021-12-22 13:02:44'),(2093,3022,40939,173428,3,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',5001.43,NULL,NULL,1,'2021-12-10 11:05:02','2021-12-22 13:05:03','2021-12-22 13:05:03'),(2094,3022,40939,173428,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',3001.66,NULL,NULL,1,'2021-12-10 11:05:56','2021-12-22 13:04:42','2021-12-22 13:04:42'),(2095,3022,40939,173428,3,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',4001.64,NULL,NULL,1,'2021-12-10 11:10:17','2021-12-22 12:56:11','2021-12-22 12:56:11'),(2096,3022,40939,173428,3,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',5000.00,NULL,NULL,1,'2021-12-10 11:11:23','2021-12-22 13:04:31','2021-12-22 13:04:31'),(2097,3022,40939,173428,3,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',5000.00,NULL,NULL,1,'2021-12-10 11:11:58','2021-12-22 13:04:20','2021-12-22 13:04:20'),(2098,3022,40939,173428,3,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',4800.25,NULL,NULL,1,'2021-12-10 11:13:20','2021-12-22 13:04:08','2021-12-22 13:04:08'),(2099,3022,40939,173428,3,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',1000.00,NULL,NULL,1,'2021-12-10 11:13:58','2021-12-28 11:54:39','2021-12-28 11:54:39');
INSERT INTO `balance_libro` VALUES (2100,3022,40939,173428,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',5000.60,NULL,NULL,1,'2021-12-10 11:17:26','2021-12-22 13:03:55','2021-12-22 13:03:55'),(2101,3022,40819,151523,3,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',6679.68,NULL,NULL,1,'2021-12-14 13:43:12','2021-12-14 13:43:12',NULL),(2102,3022,40819,151522,3,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',1100.01,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2103,3022,40819,151522,3,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',2904.00,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2104,3022,40819,151522,3,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',13400.04,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2105,3022,40819,151522,3,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',12005.02,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2106,3022,40819,151522,3,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',13215.03,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2107,3022,40819,151522,3,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',13215.02,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2108,3022,40819,151522,3,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',6305.04,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2109,3022,40819,151522,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',12005.03,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2110,3022,40819,151522,3,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',12005.02,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2111,3022,40819,151522,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',2959.01,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2112,3022,40819,151522,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',11400.02,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2113,3022,40819,151522,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3699.04,NULL,NULL,1,'2021-12-21 11:52:14','2021-12-21 11:52:14',NULL),(2114,3022,40819,151522,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',217000.00,NULL,NULL,1,'2021-12-21 11:53:16','2021-12-21 11:53:16',NULL),(2115,3022,40819,151523,3,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',1332.22,NULL,NULL,1,'2021-12-22 10:29:55','2021-12-22 10:29:55',NULL),(2116,3022,40819,151523,3,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',4508.00,NULL,NULL,1,'2021-12-22 10:32:51','2022-01-19 10:29:27','2022-01-19 10:29:27'),(2117,3022,40939,173428,3,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',4009.73,NULL,NULL,1,'2021-12-22 13:02:44','2021-12-28 12:03:43','2021-12-28 12:03:43'),(2118,3022,40939,173428,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',5000.60,NULL,NULL,1,'2021-12-22 13:03:55','2021-12-28 11:56:22','2021-12-28 11:56:22'),(2119,3022,40939,173428,3,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',4800.25,NULL,NULL,1,'2021-12-22 13:04:08','2021-12-28 11:58:46','2021-12-28 11:58:46');
INSERT INTO `balance_libro` VALUES (2120,3022,40939,173428,3,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',5000.00,NULL,NULL,1,'2021-12-22 13:04:20','2021-12-28 11:59:25','2021-12-28 11:59:25'),(2121,3022,40939,173428,3,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',5000.00,NULL,NULL,1,'2021-12-22 13:04:31','2021-12-28 12:00:39','2021-12-28 12:00:39'),(2122,3022,40939,173428,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',3001.66,NULL,NULL,1,'2021-12-22 13:04:42','2021-12-28 12:02:41','2021-12-28 12:02:41'),(2123,3022,40939,173428,3,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',5001.43,NULL,NULL,1,'2021-12-22 13:05:03','2021-12-28 12:03:18','2021-12-28 12:03:18'),(2124,3022,40939,173428,3,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3999.43,NULL,NULL,1,'2021-12-22 13:05:26','2021-12-28 12:04:14','2021-12-28 12:04:14'),(2125,3022,40939,173428,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',6021.37,NULL,NULL,1,'2021-12-22 13:05:36','2021-12-28 11:57:26','2021-12-28 11:57:26'),(2126,3022,40939,173428,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',4001.64,NULL,NULL,1,'2021-12-22 13:08:48','2021-12-28 12:01:14','2021-12-28 12:01:14'),(2127,3022,40939,173428,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',23470.00,NULL,NULL,1,'2021-12-22 13:32:57','2021-12-22 13:32:57',NULL),(2128,3022,40939,173428,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',2699.00,NULL,NULL,1,'2021-12-22 13:32:57','2021-12-22 13:32:57',NULL),(2129,3022,40939,173428,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',2699.00,NULL,NULL,1,'2021-12-22 13:32:57','2021-12-22 13:32:57',NULL),(2130,3022,40939,173428,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',2608.99,NULL,NULL,1,'2021-12-22 13:32:57','2021-12-22 13:32:57',NULL),(2131,3022,40939,173428,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3916.94,NULL,NULL,1,'2021-12-22 13:32:57','2021-12-22 13:32:57',NULL),(2132,3022,40939,173428,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',6500.00,NULL,NULL,1,'2021-12-22 13:32:57','2021-12-22 13:32:57',NULL),(2133,3022,40939,173428,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',4740.75,NULL,NULL,1,'2021-12-22 13:32:58','2021-12-22 13:32:58',NULL),(2134,3022,40939,173428,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',19300.00,NULL,NULL,1,'2021-12-22 13:32:58','2021-12-22 13:32:58',NULL),(2135,3022,40939,173428,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',5550.00,NULL,NULL,1,'2021-12-22 13:32:58','2021-12-22 13:32:58',NULL),(2136,3022,40939,173428,3,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',2500.00,NULL,NULL,1,'2021-12-22 13:32:58','2021-12-22 13:32:58',NULL),(2137,3022,40939,173428,3,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',3000.00,NULL,NULL,1,'2021-12-22 13:32:58','2021-12-22 13:32:58',NULL),(2138,3022,40939,173428,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',82753.45,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2139,3022,40939,173428,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',82753.45,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL);
INSERT INTO `balance_libro` VALUES (2140,3022,40939,173428,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',148956.21,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2141,3022,40939,173428,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',82753.45,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2142,3022,40939,173428,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',82753.45,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2143,3022,40939,173428,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',82753.45,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2144,3022,40939,173428,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',49652.07,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2145,3022,40939,173428,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',49652.07,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2146,3022,40939,173428,2,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',354506.10,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2147,3022,40939,173428,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',36040.68,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2148,3022,40939,173428,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',94499.60,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2149,3022,40939,173428,2,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',94499.60,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2150,3022,40939,173428,2,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',94499.60,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2151,3022,40939,173428,2,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',94499.60,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2152,3022,40939,173428,2,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',94499.60,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2153,3022,40939,173428,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',94499.60,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2154,3022,40939,173428,2,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',36023.00,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2155,3022,40939,173428,2,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',36023.00,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2156,3022,40939,173428,2,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',36040.68,NULL,NULL,1,'2021-12-22 13:35:51','2021-12-22 13:35:51',NULL),(2157,3022,40939,173428,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1532973.13,NULL,NULL,1,'2021-12-27 13:05:20','2021-12-27 13:05:20',NULL),(2158,3022,40720,1537,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',3656.65,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2159,3022,40720,1537,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',3434.18,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL);
INSERT INTO `balance_libro` VALUES (2160,3022,40720,1537,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',2867.25,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2161,3022,40720,1537,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',1514.19,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2162,3022,40720,1537,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',2455.05,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2163,3022,40720,1537,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',4449.83,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2164,3022,40720,1537,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',5576.35,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2165,3022,40720,1537,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',7812.74,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2166,3022,40720,1537,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',1074.63,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2167,3022,40720,1537,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',3487.76,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2168,3022,40720,1537,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',1726.37,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2169,3022,40720,1537,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',4373.76,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2170,3022,40720,1537,3,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',3038.10,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2171,3022,40720,1537,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',1294.00,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2172,3022,40720,1537,3,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',3103.23,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2173,3022,40720,1537,3,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',1810.01,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2174,3022,40720,1537,3,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',1640.83,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2175,3022,40720,1537,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',33196.62,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2176,3022,40720,1537,3,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',372.19,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2177,3022,40720,1537,3,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',1070.02,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2178,3022,40720,1537,3,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',1614.57,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2179,3022,40720,1537,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',5649.24,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2180,3022,40720,1537,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',6319.52,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL);
INSERT INTO `balance_libro` VALUES (2181,3022,40720,1537,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',628.16,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2182,3022,40720,1537,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3003.15,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2183,3022,40720,1537,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',22078.28,NULL,NULL,1,'2021-12-27 17:44:10','2021-12-27 17:44:10',NULL),(2184,3022,40720,1537,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',2385.00,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2185,3022,40720,1537,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',11511.64,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2186,3022,40720,1537,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',9174.03,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2187,3022,40720,1537,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',962.20,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2188,3022,40720,1537,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',8288.79,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2189,3022,40720,1537,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',2077.11,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2190,3022,40720,1537,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',2519.99,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2191,3022,40720,1537,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',3552.81,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2192,3022,40720,1537,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',686.50,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2193,3022,40720,1537,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',48266.40,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2194,3022,40720,1537,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',1017.16,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2195,3022,40720,1537,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',829.10,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2196,3022,40720,1537,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',3278.65,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2197,3022,40720,1537,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',3308.13,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2198,3022,40720,1537,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',4364.81,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2199,3022,40720,1537,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',6708.04,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2200,3022,40720,1537,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',4254.23,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2201,3022,40720,1537,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',4672.69,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL);
INSERT INTO `balance_libro` VALUES (2202,3022,40720,1537,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',1421.90,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2203,3022,40720,1537,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',2298.89,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2204,3022,40720,1537,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',2035.80,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2205,3022,40720,1537,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',56752.30,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2206,3022,40720,1537,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1240.01,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2207,3022,40720,1537,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3936.93,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2208,3022,40720,1537,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',5825.11,NULL,NULL,1,'2021-12-27 17:44:11','2021-12-27 17:44:11',NULL),(2209,3022,40939,173428,3,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',1000.00,NULL,NULL,1,'2021-12-28 11:54:39','2021-12-28 11:54:39',NULL),(2210,3022,40939,173428,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',5000.60,NULL,NULL,1,'2021-12-28 11:56:22','2021-12-28 11:56:22',NULL),(2211,3022,40939,173428,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',6021.37,NULL,NULL,1,'2021-12-28 11:57:26','2021-12-28 11:57:26',NULL),(2212,3022,40939,173428,3,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',4800.25,NULL,NULL,1,'2021-12-28 11:58:46','2021-12-28 11:58:46',NULL),(2213,3022,40939,173428,3,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',5000.00,NULL,NULL,1,'2021-12-28 11:59:25','2021-12-28 11:59:25',NULL),(2214,3022,40939,173428,3,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',5000.00,NULL,NULL,1,'2021-12-28 12:00:39','2021-12-28 12:00:39',NULL),(2215,3022,40939,173428,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',4001.64,NULL,NULL,1,'2021-12-28 12:01:14','2021-12-28 12:01:39','2021-12-28 12:01:39'),(2216,3022,40939,173428,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',4001.64,NULL,NULL,1,'2021-12-28 12:01:39','2021-12-28 12:01:39',NULL),(2217,3022,40939,173428,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',3001.66,NULL,NULL,1,'2021-12-28 12:02:41','2021-12-28 12:02:41',NULL),(2218,3022,40939,173428,3,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',5001.43,NULL,NULL,1,'2021-12-28 12:03:18','2021-12-28 12:03:18',NULL),(2219,3022,40939,173428,3,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',4009.73,NULL,NULL,1,'2021-12-28 12:03:43','2021-12-28 12:03:43',NULL),(2220,3022,40939,173428,3,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3999.43,NULL,NULL,1,'2021-12-28 12:04:14','2021-12-28 12:04:14',NULL),(2221,3022,40939,173429,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4000.11,NULL,NULL,1,'2022-01-10 10:55:04','2022-01-10 10:57:52','2022-01-10 10:57:52');
INSERT INTO `balance_libro` VALUES (2222,3022,40939,173429,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',5000.00,NULL,NULL,1,'2022-01-10 10:57:31','2022-01-10 10:57:31',NULL),(2223,3022,40939,173429,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4000.11,NULL,NULL,1,'2022-01-10 10:57:52','2022-01-10 10:57:52',NULL),(2224,3022,40939,173429,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',2830.33,NULL,NULL,1,'2022-01-10 11:00:39','2022-01-10 11:00:39',NULL),(2225,3022,40939,173429,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',4002.12,NULL,NULL,1,'2022-01-10 11:01:42','2022-01-10 11:01:59','2022-01-10 11:01:59'),(2226,3022,40939,173429,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',4002.12,NULL,NULL,1,'2022-01-10 11:01:59','2022-01-10 11:01:59',NULL),(2227,3022,40939,173429,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',4000.88,NULL,NULL,1,'2022-01-10 11:04:24','2022-01-10 11:04:24',NULL),(2228,3022,40939,173429,3,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',3500.00,NULL,NULL,1,'2022-01-10 11:05:43','2022-01-10 11:05:43',NULL),(2229,3022,40939,173429,3,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',4000.00,NULL,NULL,1,'2022-01-10 11:07:20','2022-01-10 11:07:20',NULL),(2230,3022,40939,173429,3,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',4997.83,NULL,NULL,1,'2022-01-10 11:08:53','2022-01-10 11:08:53',NULL),(2231,3022,40939,173429,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',4999.93,NULL,NULL,1,'2022-01-10 11:11:55','2022-01-10 11:11:55',NULL),(2232,3022,40939,173429,3,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',4002.30,NULL,NULL,1,'2022-01-10 11:12:49','2022-01-10 11:12:49',NULL),(2233,3022,40939,173429,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',5000.11,NULL,NULL,1,'2022-01-10 11:14:23','2022-01-10 11:14:23',NULL),(2234,3022,40939,173429,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',610.00,NULL,NULL,1,'2022-01-10 11:15:20','2022-01-10 11:15:20',NULL),(2235,3022,40939,173429,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',550.00,NULL,NULL,1,'2022-01-10 11:22:26','2022-01-24 18:37:19','2022-01-24 18:37:19'),(2236,3022,40939,173429,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',5000.41,NULL,NULL,1,'2022-01-10 11:23:42','2022-01-10 11:23:42',NULL),(2237,3022,40939,173429,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',5000.11,NULL,NULL,1,'2022-01-10 11:25:00','2022-01-10 11:25:00',NULL),(2238,3022,40939,173429,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',5001.36,NULL,NULL,1,'2022-01-10 11:26:11','2022-01-10 11:26:11',NULL),(2239,3022,40939,173429,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',5000.11,NULL,NULL,1,'2022-01-10 11:27:13','2022-01-10 11:27:13',NULL),(2240,3022,40939,173429,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',4999.83,NULL,NULL,1,'2022-01-10 11:28:41','2022-01-10 11:28:41',NULL),(2241,3022,40939,173429,3,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4501.35,NULL,NULL,1,'2022-01-10 11:33:06','2022-01-10 11:33:06',NULL);
INSERT INTO `balance_libro` VALUES (2242,3022,40939,173429,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',5000.09,NULL,NULL,1,'2022-01-10 11:34:25','2022-01-10 11:34:25',NULL),(2243,3022,40939,173429,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',6000.32,NULL,NULL,1,'2022-01-10 11:35:27','2022-01-10 11:35:27',NULL),(2244,3022,40939,173429,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',6000.00,NULL,NULL,1,'2022-01-10 11:36:01','2022-01-10 11:36:01',NULL),(2245,3022,40939,173429,3,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2200.00,NULL,NULL,1,'2022-01-10 12:23:51','2022-01-24 18:36:49','2022-01-24 18:36:49'),(2246,3022,40939,173429,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2000.00,NULL,NULL,1,'2022-01-10 12:24:46','2022-01-24 18:36:45','2022-01-24 18:36:45'),(2247,3022,40819,151523,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',3108.93,NULL,NULL,1,'2022-01-10 13:08:45','2022-01-10 13:08:45',NULL),(2248,3022,40819,151523,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',3108.93,NULL,NULL,1,'2022-01-10 13:09:21','2022-01-10 13:09:21',NULL),(2249,3022,40819,151527,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1332.22,NULL,NULL,1,'2022-01-10 13:11:42','2022-02-28 18:13:18','2022-02-28 18:13:18'),(2250,3022,40720,1538,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',13285.38,NULL,NULL,1,'2022-01-12 12:25:09','2022-01-12 12:25:09',NULL),(2251,3022,40720,1538,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',16574.05,NULL,NULL,1,'2022-01-12 12:30:59','2022-01-12 12:30:59',NULL),(2252,3022,40720,1538,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',18154.91,NULL,NULL,1,'2022-01-12 12:32:43','2022-01-12 12:32:43',NULL),(2253,3022,40720,1538,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',21144.94,NULL,NULL,1,'2022-01-12 12:33:44','2022-01-12 12:33:44',NULL),(2254,3022,40720,1538,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',14794.95,NULL,NULL,1,'2022-01-12 12:34:39','2022-01-12 12:34:39',NULL),(2255,3022,40720,1538,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',9180.14,NULL,NULL,1,'2022-01-12 12:35:44','2022-01-12 12:35:44',NULL),(2256,3022,40720,1538,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',11636.01,NULL,NULL,1,'2022-01-12 12:36:33','2022-01-12 12:36:33',NULL),(2257,3022,40720,1538,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',11501.96,NULL,NULL,1,'2022-01-12 12:37:49','2022-01-12 12:37:49',NULL),(2258,3022,40720,1538,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',14247.92,NULL,NULL,1,'2022-01-12 12:38:56','2022-01-12 12:38:56',NULL),(2259,3022,40720,1538,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',10373.02,NULL,NULL,1,'2022-01-12 12:39:48','2022-01-12 12:39:48',NULL),(2260,3022,40720,1538,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',9993.96,NULL,NULL,1,'2022-01-12 12:40:49','2022-01-12 12:40:49',NULL),(2261,3022,40720,1538,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',9597.94,NULL,NULL,1,'2022-01-12 12:41:52','2022-01-12 12:41:52',NULL);
INSERT INTO `balance_libro` VALUES (2262,3022,40720,1538,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',9864.98,NULL,NULL,1,'2022-01-12 12:43:07','2022-01-12 12:43:07',NULL),(2263,3022,40720,1538,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',9000.00,NULL,NULL,1,'2022-01-12 12:44:01','2022-01-20 12:10:05','2022-01-20 12:10:05'),(2264,3022,40720,1538,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',900.00,NULL,NULL,1,'2022-01-12 12:44:31','2022-01-20 12:20:59','2022-01-20 12:20:59'),(2265,3022,40720,1538,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',11751.01,NULL,NULL,1,'2022-01-12 12:52:33','2022-01-12 12:52:33',NULL),(2266,3022,40720,1538,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',11475.94,NULL,NULL,1,'2022-01-12 12:53:34','2022-01-12 12:53:34',NULL),(2267,3022,40720,1538,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',18896.01,NULL,NULL,1,'2022-01-12 12:54:17','2022-01-12 12:54:17',NULL),(2268,3022,40720,1538,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-19','2021-12-19',9530.00,NULL,NULL,1,'2022-01-12 12:54:40','2022-01-12 12:54:40',NULL),(2269,3022,40720,1538,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',20521.06,NULL,NULL,1,'2022-01-12 12:55:32','2022-01-12 12:55:32',NULL),(2270,3022,40720,1538,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',20897.93,NULL,NULL,1,'2022-01-12 12:56:47','2022-01-12 12:56:47',NULL),(2271,3022,40720,1538,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',12769.92,NULL,NULL,1,'2022-01-12 12:58:16','2022-01-12 12:58:16',NULL),(2272,3022,40720,1538,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',12769.04,NULL,NULL,1,'2022-01-12 12:59:07','2022-01-12 12:59:07',NULL),(2273,3022,40720,1538,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-26','2021-12-26',0.01,NULL,NULL,1,'2022-01-12 12:59:21','2022-01-12 12:59:21',NULL),(2274,3022,40720,1538,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-26','2021-12-26',4705.00,NULL,NULL,1,'2022-01-12 13:00:07','2022-01-12 13:00:07',NULL),(2275,3022,40720,1538,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',10508.09,NULL,NULL,1,'2022-01-12 13:01:12','2022-01-12 13:01:12',NULL),(2276,3022,40720,1538,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',10606.04,NULL,NULL,1,'2022-01-12 13:01:55','2022-01-12 13:01:55',NULL),(2277,3022,40720,1538,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',11844.93,NULL,NULL,1,'2022-01-12 13:02:46','2022-01-12 13:02:46',NULL),(2278,3022,40720,1538,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',22268.33,NULL,NULL,1,'2022-01-12 13:03:32','2022-01-12 13:03:32',NULL),(2279,3022,40720,1538,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',0.01,NULL,NULL,1,'2022-01-12 13:03:43','2022-01-12 13:03:43',NULL),(2280,3022,40720,1538,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',26807.92,NULL,NULL,1,'2022-01-12 13:04:21','2022-01-12 13:04:21',NULL),(2281,3022,40819,151523,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',56333.95,NULL,NULL,1,'2022-01-14 16:41:06','2022-01-14 16:41:06',NULL);
INSERT INTO `balance_libro` VALUES (2282,3022,40819,151527,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',23882.13,NULL,NULL,1,'2022-01-17 11:18:49','2022-01-17 12:19:53','2022-01-17 12:19:53'),(2283,3022,40819,151527,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',3571.14,NULL,NULL,1,'2022-01-17 11:23:01','2022-01-17 12:19:57','2022-01-17 12:19:57'),(2284,3022,40819,151527,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',23882.13,NULL,NULL,1,'2022-01-17 12:21:35','2022-01-17 12:22:07','2022-01-17 12:22:07'),(2285,3022,40819,151527,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',23882.13,NULL,NULL,1,'2022-01-17 12:22:07','2022-01-17 12:22:07',NULL),(2286,3022,40819,151527,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',3571.16,NULL,NULL,1,'2022-01-17 12:23:27','2022-02-28 17:54:43','2022-02-28 17:54:43'),(2291,3022,40819,151523,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',4840.00,NULL,NULL,1,'2022-01-19 10:29:52','2022-01-19 10:29:52',NULL),(2292,3022,40819,151523,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',6177.60,NULL,NULL,1,'2022-01-19 10:29:52','2022-01-19 10:29:52',NULL),(2293,3022,40819,151523,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',620.00,NULL,NULL,1,'2022-01-19 10:29:52','2022-01-19 10:29:52',NULL),(2294,3022,40819,151523,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',9070.00,NULL,NULL,1,'2022-01-19 10:29:52','2022-01-19 10:29:52',NULL),(2295,3022,40819,151523,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',4508.00,NULL,NULL,1,'2022-01-19 10:29:52','2022-01-19 10:29:52',NULL),(2296,3022,40819,151523,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',3899.78,NULL,NULL,1,'2022-01-19 10:29:53','2022-01-19 10:29:53',NULL),(2297,3022,40819,151523,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',259221.17,NULL,NULL,1,'2022-01-19 10:29:53','2022-01-19 10:29:53',NULL),(2298,3022,40819,151523,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',870.00,NULL,NULL,1,'2022-01-19 10:29:53','2022-01-19 10:29:53',NULL),(2299,3022,40819,151523,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',41649.14,NULL,NULL,1,'2022-01-19 10:29:53','2022-01-19 10:29:53',NULL),(2300,3022,40819,151523,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',100000.00,NULL,NULL,1,'2022-01-19 10:29:53','2022-01-19 10:29:53',NULL),(2301,3022,40819,151523,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',2500.01,NULL,NULL,1,'2022-01-19 10:29:53','2022-01-19 10:29:53',NULL),(2302,3022,40819,151523,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',40624.69,NULL,NULL,1,'2022-01-19 10:29:53','2022-01-19 10:29:53',NULL),(2303,3022,40819,151523,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',217316.00,NULL,NULL,1,'2022-01-19 10:29:53','2022-01-19 10:29:53',NULL),(2304,3022,40819,151523,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2994.21,NULL,NULL,1,'2022-01-19 10:29:53','2022-01-19 10:29:53',NULL),(2305,3022,40720,1538,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',11353.90,NULL,NULL,1,'2022-01-20 12:10:05','2022-01-20 12:10:05',NULL);
INSERT INTO `balance_libro` VALUES (2306,3022,40720,1538,2,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',0.01,NULL,NULL,1,'2022-01-20 12:18:13','2022-01-20 12:18:13',NULL),(2307,3022,40720,1538,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3434.18,NULL,NULL,1,'2022-01-20 12:30:06','2022-01-20 12:30:06',NULL),(2308,3022,40720,1538,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2676.78,NULL,NULL,1,'2022-01-20 12:30:06','2022-01-20 12:30:06',NULL),(2309,3022,40720,1538,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2717.69,NULL,NULL,1,'2022-01-20 12:30:06','2022-01-20 12:30:06',NULL),(2310,3022,40720,1538,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',7440.63,NULL,NULL,1,'2022-01-20 12:30:06','2022-01-20 12:30:06',NULL),(2311,3022,40720,1538,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',287.25,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2312,3022,40720,1538,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1349.85,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2313,3022,40720,1538,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',2717.69,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2314,3022,40720,1538,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',1607.99,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2315,3022,40720,1538,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',5149.48,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2316,3022,40720,1538,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',3722.95,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2317,3022,40720,1538,3,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',5077.22,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2318,3022,40720,1538,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',1557.62,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2319,3022,40720,1538,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1596.50,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2320,3022,40720,1538,3,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1230.00,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2321,3022,40720,1538,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',3394.64,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2322,3022,40720,1538,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2635.60,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2323,3022,40720,1538,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1536.04,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2324,3022,40720,1538,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',2592.13,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2325,3022,40720,1538,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',1141.00,NULL,NULL,1,'2022-01-20 12:30:07','2022-01-20 12:30:07',NULL),(2326,3022,40720,1538,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',28840.50,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL);
INSERT INTO `balance_libro` VALUES (2327,3022,40720,1538,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',2686.55,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2328,3022,40720,1538,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',1374.42,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2329,3022,40720,1538,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',4829.93,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2330,3022,40720,1538,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',4726.93,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2331,3022,40720,1538,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',3495.02,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2332,3022,40720,1538,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-19','2021-12-19',1299.00,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2333,3022,40720,1538,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',3697.50,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2334,3022,40720,1538,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',499.28,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2335,3022,40720,1538,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',996.41,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2336,3022,40720,1538,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',3249.94,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2337,3022,40720,1538,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',5719.61,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2338,3022,40720,1538,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',887.46,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2339,3022,40720,1538,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',6511.97,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2340,3022,40720,1538,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',552.46,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2341,3022,40720,1538,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',955.00,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2342,3022,40720,1538,3,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1265.38,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2343,3022,40720,1538,3,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',163430.39,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-21 09:52:58','2022-01-21 09:52:58'),(2344,3022,40720,1538,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',486345.58,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-21 09:52:47','2022-01-21 09:52:47'),(2345,3022,40720,1538,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',2347.50,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2346,3022,40720,1538,3,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',1495.48,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2347,3022,40720,1538,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',2707.38,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL);
INSERT INTO `balance_libro` VALUES (2348,3022,40720,1538,3,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',934.68,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2349,3022,40720,1538,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',544.65,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2350,3022,40720,1538,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',1453.91,NULL,NULL,1,'2022-01-20 12:30:08','2022-01-20 12:30:08',NULL),(2351,3022,40720,1538,3,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',6887.68,NULL,NULL,1,'2022-01-20 12:30:09','2022-01-20 12:30:09',NULL),(2352,3022,40720,1538,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',1758.00,NULL,NULL,1,'2022-01-20 12:30:09','2022-01-20 12:30:09',NULL),(2353,3022,40720,1538,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',3425.72,NULL,NULL,1,'2022-01-20 12:30:09','2022-01-20 12:30:09',NULL),(2354,3022,40720,1538,3,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3512.13,NULL,NULL,1,'2022-01-20 12:30:09','2022-01-20 12:30:09',NULL),(2355,3022,40720,1538,3,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-20 12:30:09','2022-01-20 12:30:09',NULL),(2356,3022,40720,1538,3,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-20 12:30:09','2022-01-20 12:30:09',NULL),(2357,3022,40720,1538,3,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-20 12:30:09','2022-01-20 12:30:09',NULL),(2358,3022,40720,1538,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',20768.17,NULL,NULL,1,'2022-01-20 13:15:28','2022-01-20 16:56:41','2022-01-20 16:56:41'),(2359,3022,40819,151523,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',217000.00,NULL,NULL,1,'2022-01-20 13:41:25','2022-01-20 13:41:25',NULL),(2360,3022,40819,151523,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',3025.00,NULL,NULL,1,'2022-01-20 13:41:25','2022-01-20 13:41:25',NULL),(2361,3022,40819,151523,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',2400000.00,NULL,NULL,1,'2022-01-20 13:41:26','2022-01-20 13:41:26',NULL),(2362,3022,40720,1538,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',17125.67,NULL,NULL,1,'2022-01-20 16:56:41','2022-01-20 17:08:53','2022-01-20 17:08:53'),(2363,3022,40720,1538,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',17504.21,NULL,NULL,1,'2022-01-20 17:08:53','2022-01-20 17:10:10','2022-01-20 17:10:10'),(2364,3022,40720,1538,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',20094.64,NULL,NULL,1,'2022-01-20 17:10:10','2022-01-20 17:10:32','2022-01-20 17:10:32'),(2365,3022,40720,1538,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',20767.88,NULL,NULL,1,'2022-01-20 17:10:32','2022-01-20 17:21:42','2022-01-20 17:21:42'),(2366,3022,40720,1538,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',20767.88,NULL,NULL,1,'2022-01-20 17:21:42','2022-01-20 17:21:42',NULL),(2367,3022,40720,1538,3,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',21285.74,NULL,NULL,1,'2022-01-20 17:35:29','2022-01-20 17:35:29',NULL);
INSERT INTO `balance_libro` VALUES (2368,3022,40939,173429,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',361799.10,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2369,3022,40939,173429,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',361799.10,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2370,3022,40939,173429,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2371,3022,40939,173429,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2372,3022,40939,173429,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2373,3022,40939,173429,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2374,3022,40939,173429,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2375,3022,40939,173429,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2376,3022,40939,173429,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2377,3022,40939,173429,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2378,3022,40939,173429,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2379,3022,40939,173429,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2380,3022,40939,173429,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',557008.40,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2381,3022,40939,173429,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2382,3022,40939,173429,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2383,3022,40939,173429,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2384,3022,40939,173429,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2385,3022,40939,173429,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2386,3022,40939,173429,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2387,3022,40939,173429,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',79920.23,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL);
INSERT INTO `balance_libro` VALUES (2388,3022,40939,173429,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',119880.34,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2389,3022,40939,173429,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2390,3022,40939,173429,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2391,3022,40939,173429,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2392,3022,40939,173429,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2393,3022,40939,173429,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2394,3022,40939,173429,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',172799.90,NULL,NULL,1,'2022-01-24 18:13:56','2022-01-24 18:13:56',NULL),(2395,3022,40939,173429,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',172799.90,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2396,3022,40939,173429,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',345599.80,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2397,3022,40939,173429,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2398,3022,40939,173429,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2399,3022,40939,173429,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',90449.78,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2400,3022,40939,173429,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',90449.78,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2401,3022,40939,173429,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',90449.78,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2402,3022,40939,173429,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',90449.78,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2403,3022,40939,173429,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',92206.72,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2404,3022,40939,173429,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',92206.72,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2405,3022,40939,173429,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',92206.72,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2406,3022,40939,173429,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',92206.72,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2407,3022,40939,173429,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',92206.72,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL);
INSERT INTO `balance_libro` VALUES (2408,3022,40939,173429,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',278283.19,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2409,3022,40939,173429,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2410,3022,40939,173429,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2411,3022,40939,173429,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2412,3022,40939,173429,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2413,3022,40939,173429,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2414,3022,40939,173429,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2415,3022,40939,173429,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',39870.61,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2416,3022,40939,173429,2,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',59805.92,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2417,3022,40939,173429,2,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2418,3022,40939,173429,2,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2419,3022,40939,173429,2,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2420,3022,40939,173429,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',99676.52,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2421,3022,40939,173429,2,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',86399.95,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2422,3022,40939,173429,2,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',86399.95,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2423,3022,40939,173429,2,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',86399.95,NULL,NULL,1,'2022-01-24 18:13:57','2022-01-24 18:13:57',NULL),(2424,3022,40939,173429,2,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',172799.90,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2425,3022,40939,173429,2,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2426,3022,40939,173429,2,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',361799.10,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2427,3022,40939,173429,2,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',361799.10,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL);
INSERT INTO `balance_libro` VALUES (2428,3022,40939,173429,2,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2429,3022,40939,173429,2,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2430,3022,40939,173429,2,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2431,3022,40939,173429,2,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',180899.55,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2432,3022,40939,173429,2,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2433,3022,40939,173429,2,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2434,3022,40939,173429,2,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2435,3022,40939,173429,2,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2436,3022,40939,173429,2,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2437,3022,40939,173429,2,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',184407.92,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2438,3022,40939,173429,2,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',557008.40,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2439,3022,40939,173429,2,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2440,3022,40939,173429,2,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2441,3022,40939,173429,2,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2442,3022,40939,173429,2,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2443,3022,40939,173429,2,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2444,3022,40939,173429,2,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2445,3022,40939,173429,2,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',79920.23,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2446,3022,40939,173429,2,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',119880.34,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2447,3022,40939,173429,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL);
INSERT INTO `balance_libro` VALUES (2448,3022,40939,173429,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2449,3022,40939,173429,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2450,3022,40939,173429,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2451,3022,40939,173429,2,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',199800.58,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2452,3022,40939,173429,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',172799.90,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2453,3022,40939,173429,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',172799.90,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2454,3022,40939,173429,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',345599.80,NULL,NULL,1,'2022-01-24 18:13:58','2022-01-24 18:13:58',NULL),(2455,3022,40939,173429,3,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21823.69,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:41','2022-01-24 18:36:41'),(2456,3022,40939,173429,3,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',37200.00,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:30:24','2022-01-24 18:30:24'),(2457,3022,40939,173429,3,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',950.00,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:36','2022-01-24 18:36:36'),(2458,3022,40939,173429,3,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',27227.00,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:33','2022-01-24 18:36:33'),(2459,3022,40939,173429,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',2999.00,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:29','2022-01-24 18:36:29'),(2460,3022,40939,173429,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',27360.00,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:26','2022-01-24 18:36:26'),(2461,3022,40939,173429,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',4123.99,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:18','2022-01-24 18:36:18'),(2462,3022,40939,173429,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',1599.20,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:09','2022-01-24 18:36:09'),(2463,3022,40939,173429,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',28578.00,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:13','2022-01-24 18:36:13'),(2464,3022,40939,173429,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',11080.00,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:05','2022-01-24 18:36:05'),(2465,3022,40939,173429,3,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',1289.99,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:32:31','2022-01-24 18:32:31'),(2466,3022,40939,173429,3,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',6545.50,NULL,NULL,1,'2022-01-24 18:16:09','2022-01-24 18:36:01','2022-01-24 18:36:01');
INSERT INTO `balance_libro` VALUES (2467,3022,40939,173429,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',21823.69,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2468,3022,40939,173429,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',37200.00,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2469,3022,40939,173429,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',950.00,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2470,3022,40939,173429,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',27227.00,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2471,3022,40939,173429,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',2999.00,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2472,3022,40939,173429,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',27360.00,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2473,3022,40939,173429,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',4123.99,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2474,3022,40939,173429,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',1599.20,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2475,3022,40939,173429,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',28578.00,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2476,3022,40939,173429,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',11080.00,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2477,3022,40939,173429,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',1289.99,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2478,3022,40939,173429,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',6545.50,NULL,NULL,1,'2022-01-24 18:40:57','2022-01-24 18:40:57',NULL),(2479,3022,40939,173429,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2991356.55,NULL,NULL,1,'2022-01-24 19:01:40','2022-01-24 19:23:51','2022-01-24 19:23:51'),(2480,3022,40939,173429,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2914650.08,NULL,NULL,1,'2022-01-24 19:23:51','2022-01-24 19:25:38','2022-01-24 19:25:38'),(2481,3022,40939,173429,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2769577.01,NULL,NULL,1,'2022-01-24 19:25:38','2022-01-24 19:25:38',NULL),(2482,3022,40720,1542,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',12803.00,NULL,NULL,1,'2022-02-14 11:14:29','2022-02-14 11:14:29',NULL),(2483,3022,40720,1542,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',2820.00,NULL,NULL,1,'2022-02-14 11:15:00','2022-02-14 11:15:00',NULL),(2484,3022,40720,1542,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',16915.05,NULL,NULL,1,'2022-02-14 11:17:10','2022-02-14 11:17:10',NULL),(2485,3022,40720,1542,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',19226.08,NULL,NULL,1,'2022-02-14 11:17:53','2022-02-14 11:17:53',NULL),(2486,3022,40720,1542,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',16347.14,NULL,NULL,1,'2022-02-14 11:19:41','2022-02-14 11:19:41',NULL);
INSERT INTO `balance_libro` VALUES (2487,3022,40720,1542,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',13729.93,NULL,NULL,1,'2022-02-14 11:21:11','2022-02-14 11:21:11',NULL),(2488,3022,40720,1542,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',22902.02,NULL,NULL,1,'2022-02-14 11:22:10','2022-02-14 11:22:10',NULL),(2489,3022,40720,1542,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',0.01,NULL,NULL,1,'2022-02-14 11:22:25','2022-02-14 11:22:25',NULL),(2490,3022,40720,1542,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',12803.02,NULL,NULL,1,'2022-02-14 11:23:39','2022-02-14 11:23:39',NULL),(2491,3022,40720,1542,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',6497.96,NULL,NULL,1,'2022-02-14 11:25:43','2022-02-14 11:25:43',NULL),(2492,3022,40720,1542,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',20669.04,NULL,NULL,1,'2022-02-14 11:26:55','2022-02-14 11:26:55',NULL),(2493,3022,40720,1542,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',17003.14,NULL,NULL,1,'2022-02-14 11:28:40','2022-02-14 11:28:40',NULL),(2494,3022,40720,1542,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',18124.02,NULL,NULL,1,'2022-02-14 11:30:17','2022-02-14 11:30:17',NULL),(2495,3022,40720,1542,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',23395.07,NULL,NULL,1,'2022-02-14 11:31:46','2022-02-14 11:31:46',NULL),(2496,3022,40720,1542,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',17027.97,NULL,NULL,1,'2022-02-14 11:32:43','2022-02-14 11:32:43',NULL),(2497,3022,40720,1542,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',10000.95,NULL,NULL,1,'2022-02-14 11:37:47','2022-02-14 11:37:47',NULL),(2498,3022,40720,1542,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',14100.02,NULL,NULL,1,'2022-02-14 11:42:36','2022-02-14 11:42:36',NULL),(2499,3022,40720,1542,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',0.01,NULL,NULL,1,'2022-02-14 11:42:52','2022-02-14 11:42:52',NULL),(2500,3022,40720,1542,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',8709.00,NULL,NULL,1,'2022-02-14 11:43:54','2022-02-14 11:43:54',NULL),(2501,3022,40720,1542,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',7417.01,NULL,NULL,1,'2022-02-14 11:45:21','2022-02-14 11:45:21',NULL),(2502,3022,40720,1542,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',17827.99,NULL,NULL,1,'2022-02-14 11:46:34','2022-02-14 11:46:34',NULL),(2503,3022,40720,1542,2,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',0.01,NULL,NULL,1,'2022-02-14 11:46:52','2022-02-14 11:46:52',NULL),(2504,3022,40720,1542,2,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',12997.25,NULL,NULL,1,'2022-02-14 11:47:34','2022-02-14 11:47:34',NULL),(2505,3022,40720,1542,2,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',13919.84,NULL,NULL,1,'2022-02-14 11:48:29','2022-02-14 11:48:29',NULL),(2506,3022,40720,1542,2,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-23','2022-01-23',17861.94,NULL,NULL,1,'2022-02-14 11:49:50','2022-02-14 11:49:50',NULL),(2507,3022,40720,1542,2,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',16744.95,NULL,NULL,1,'2022-02-14 11:50:28','2022-02-14 11:50:28',NULL);
INSERT INTO `balance_libro` VALUES (2508,3022,40720,1542,2,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',11910.88,NULL,NULL,1,'2022-02-14 11:51:05','2022-02-14 11:51:05',NULL),(2509,3022,40720,1542,2,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',14088.94,NULL,NULL,1,'2022-02-14 11:52:11','2022-02-14 11:52:11',NULL),(2510,3022,40720,1542,2,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',10983.05,NULL,NULL,1,'2022-02-14 11:52:55','2022-02-14 11:52:55',NULL),(2511,3022,40720,1542,2,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',7535.01,NULL,NULL,1,'2022-02-14 11:53:29','2022-02-14 11:53:29',NULL),(2512,3022,40720,1542,2,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',7826.99,NULL,NULL,1,'2022-02-14 11:53:46','2022-02-14 11:53:46',NULL),(2513,3022,40720,1542,2,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',12347.99,NULL,NULL,1,'2022-02-14 11:53:56','2022-02-14 11:54:12','2022-02-14 11:54:12'),(2514,3022,40720,1542,2,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',12347.99,NULL,NULL,1,'2022-02-14 11:54:12','2022-02-14 11:54:12',NULL),(2515,3022,40720,1542,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',12790.00,NULL,NULL,1,'2022-02-15 11:57:25','2022-02-15 11:57:25',NULL),(2516,3022,40720,1542,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',3434.18,NULL,NULL,1,'2022-02-15 11:57:25','2022-02-15 11:57:25',NULL),(2517,3022,40720,1542,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',13586.70,NULL,NULL,1,'2022-02-15 11:57:25','2022-02-15 11:57:25',NULL),(2518,3022,40720,1542,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4650.10,NULL,NULL,1,'2022-02-15 11:57:25','2022-02-15 11:57:25',NULL),(2519,3022,40720,1542,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',69654.96,NULL,NULL,1,'2022-02-15 11:57:25','2022-02-15 11:57:25',NULL),(2520,3022,40720,1542,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',6555.01,NULL,NULL,1,'2022-02-15 11:57:25','2022-02-15 11:57:25',NULL),(2521,3022,40720,1542,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1926.92,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2522,3022,40720,1542,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',3415.96,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2523,3022,40720,1542,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',3148.65,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2524,3022,40720,1542,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',643.15,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2525,3022,40720,1542,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',955.00,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2526,3022,40720,1542,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',6908.42,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2527,3022,40720,1542,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',4832.00,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2528,3022,40720,1542,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',9012.31,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL);
INSERT INTO `balance_libro` VALUES (2529,3022,40720,1542,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',852.55,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2530,3022,40720,1542,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',73482.50,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2531,3022,40720,1542,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',3242.99,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2532,3022,40720,1542,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',6582.44,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2533,3022,40720,1542,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',3728.56,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2534,3022,40720,1542,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3829.50,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2535,3022,40720,1542,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',47294.00,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2536,3022,40720,1542,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',3125.77,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2537,3022,40720,1542,3,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',0.54,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2538,3022,40720,1542,3,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',7604.85,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2539,3022,40720,1542,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',8644.47,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2540,3022,40720,1542,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',357.34,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2541,3022,40720,1542,3,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',15242.77,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2542,3022,40720,1542,3,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3737.34,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2543,3022,40720,1542,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',775.07,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2544,3022,40720,1542,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3966.50,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2545,3022,40720,1542,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',5847.98,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2546,3022,40720,1542,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',2210.00,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2547,3022,40720,1542,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',2349.00,NULL,NULL,1,'2022-02-15 11:57:26','2022-02-15 11:57:26',NULL),(2548,3022,40720,1542,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',2412.50,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2549,3022,40720,1542,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',199.71,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL);
INSERT INTO `balance_libro` VALUES (2550,3022,40720,1542,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',2543.01,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2551,3022,40720,1542,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',4317.36,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2552,3022,40720,1542,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',12790.00,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2553,3022,40720,1542,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',9064.08,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2554,3022,40720,1542,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',29521.55,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2555,3022,40720,1542,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',20591.96,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2556,3022,40720,1542,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',4066.38,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2557,3022,40720,1542,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',6211.25,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2558,3022,40720,1542,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',4448.29,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2559,3022,40720,1542,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',5813.81,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2560,3022,40720,1542,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',83836.35,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2561,3022,40720,1542,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',5830.50,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2562,3022,40720,1542,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',5598.64,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2563,3022,40720,1542,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',16083.70,NULL,NULL,1,'2022-02-15 11:57:27','2022-02-15 11:57:27',NULL),(2564,3022,40720,1542,2,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',6211.25,NULL,NULL,1,'2022-02-15 12:01:05','2022-03-04 09:49:20','2022-03-04 09:49:20'),(2565,3022,40720,1542,2,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',16900.00,NULL,NULL,1,'2022-02-15 12:02:08','2022-03-04 09:49:28','2022-03-04 09:49:28'),(2566,3022,40819,151528,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',6181.30,NULL,NULL,1,'2022-02-18 10:57:51','2022-03-31 11:45:03','2022-03-31 11:45:03'),(2567,3022,40819,151528,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',1835.40,NULL,NULL,1,'2022-02-18 10:59:08','2022-03-31 11:46:18','2022-03-31 11:46:18'),(2568,3022,40939,173433,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',3000.23,NULL,NULL,1,'2022-02-22 10:47:34','2022-02-22 10:47:34',NULL),(2569,3022,40939,173433,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',4999.93,NULL,NULL,1,'2022-02-22 10:49:39','2022-02-22 10:49:39',NULL);
INSERT INTO `balance_libro` VALUES (2570,3022,40939,173433,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',3999.83,NULL,NULL,1,'2022-02-22 10:54:07','2022-02-22 10:54:07',NULL),(2571,3022,40939,173433,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2001.49,NULL,NULL,1,'2022-02-22 10:54:59','2022-02-22 10:54:59',NULL),(2572,3022,40939,173433,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1000.00,NULL,NULL,1,'2022-02-22 10:55:46','2022-02-22 10:55:46',NULL),(2573,3022,40939,173433,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3000.32,NULL,NULL,1,'2022-02-22 10:59:48','2022-02-22 10:59:48',NULL),(2574,3022,40939,173433,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',4012.69,NULL,NULL,1,'2022-02-22 11:00:42','2022-02-22 11:00:42',NULL),(2575,3022,40939,173433,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',5001.84,NULL,NULL,1,'2022-02-22 11:02:04','2022-02-22 11:02:04',NULL),(2576,3022,40939,173433,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',3000.04,NULL,NULL,1,'2022-02-22 11:02:55','2022-02-22 11:02:55',NULL),(2577,3022,40939,173433,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',5000.41,NULL,NULL,1,'2022-02-22 11:04:04','2022-02-22 11:04:04',NULL),(2578,3022,40939,173433,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',5000.41,NULL,NULL,1,'2022-02-22 11:04:58','2022-02-22 11:04:58',NULL),(2579,3022,40939,173433,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',3999.73,NULL,NULL,1,'2022-02-22 11:05:53','2022-02-22 11:05:53',NULL),(2580,3022,40939,173433,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',4000.11,NULL,NULL,1,'2022-02-22 11:06:59','2022-02-22 11:06:59',NULL),(2581,3022,40939,173433,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',4999.71,NULL,NULL,1,'2022-02-22 11:07:50','2022-02-22 11:07:50',NULL),(2582,3022,40939,173433,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4000.41,NULL,NULL,1,'2022-02-22 11:08:26','2022-02-22 11:08:26',NULL),(2583,3022,40939,173433,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4006.11,NULL,NULL,1,'2022-02-22 11:09:07','2022-02-22 11:09:07',NULL),(2584,3022,40939,173433,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',5000.88,NULL,NULL,1,'2022-02-22 11:09:58','2022-02-22 11:09:58',NULL),(2585,3022,40939,173433,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',4940.91,NULL,NULL,1,'2022-02-22 11:15:02','2022-02-22 11:15:02',NULL),(2586,3022,40939,173433,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',5002.30,NULL,NULL,1,'2022-02-22 11:15:48','2022-02-22 11:15:48',NULL),(2587,3022,40939,173433,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',6000.00,NULL,NULL,1,'2022-02-22 12:53:30','2022-02-22 12:53:30',NULL),(2588,3022,40939,173433,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',1000.00,NULL,NULL,1,'2022-02-22 12:54:12','2022-02-22 12:54:12',NULL),(2589,3022,40939,173433,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',4000.03,NULL,NULL,1,'2022-02-22 12:55:07','2022-02-22 12:55:07',NULL),(2590,3022,40939,173433,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',37200.00,NULL,NULL,1,'2022-02-22 13:32:03','2022-02-22 13:32:03',NULL);
INSERT INTO `balance_libro` VALUES (2591,3022,40939,173433,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',270.00,NULL,NULL,1,'2022-02-22 13:33:44','2022-02-22 13:33:44',NULL),(2592,3022,40939,173433,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',2200.00,NULL,NULL,1,'2022-02-22 13:34:52','2022-02-22 13:34:52',NULL),(2593,3022,40939,173433,3,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',17800.00,NULL,NULL,1,'2022-02-22 13:36:31','2022-02-22 13:36:31',NULL),(2594,3022,41024,175561,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',11293.99,NULL,NULL,1,'2022-02-24 12:24:28','2022-02-24 12:24:28',NULL),(2595,3022,41024,175561,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1400.00,NULL,NULL,1,'2022-02-25 10:57:31','2022-04-04 12:17:28','2022-04-04 12:17:28'),(2596,3022,41024,175561,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',3549.84,NULL,NULL,1,'2022-02-25 11:02:39','2022-02-25 11:02:39',NULL),(2597,3022,41024,175561,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',500.00,NULL,NULL,1,'2022-02-25 11:04:05','2022-04-01 10:43:51','2022-04-01 10:43:51'),(2598,3022,41024,175561,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',4411.12,NULL,NULL,1,'2022-02-25 11:07:12','2022-02-25 11:07:12',NULL),(2599,3022,41024,175561,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',973.00,NULL,NULL,1,'2022-02-25 11:09:24','2022-02-25 11:09:24',NULL),(2600,3022,41024,175561,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2186.99,NULL,NULL,1,'2022-02-25 11:10:25','2022-02-25 11:10:25',NULL),(2601,3022,41024,175561,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1595.92,NULL,NULL,1,'2022-02-25 11:14:36','2022-02-25 11:14:36',NULL),(2602,3022,41024,175561,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',4386.89,NULL,NULL,1,'2022-02-25 11:15:14','2022-02-25 11:15:14',NULL),(2603,3022,41024,175561,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',1000.00,NULL,NULL,1,'2022-02-25 11:18:00','2022-02-25 11:18:00',NULL),(2604,3022,41024,175561,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',3050.09,NULL,NULL,1,'2022-02-25 11:21:49','2022-04-04 23:22:01','2022-04-04 23:22:01'),(2605,3022,41024,175561,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',2680.90,NULL,NULL,1,'2022-02-25 11:33:50','2022-02-25 11:33:50',NULL),(2606,3022,41024,175561,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-23','2022-01-23',15544.85,NULL,NULL,1,'2022-02-25 11:35:12','2022-02-25 11:35:12',NULL),(2607,3022,41024,175561,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1460.00,NULL,NULL,1,'2022-02-25 11:37:02','2022-02-25 11:37:02',NULL),(2608,3022,41024,175561,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1639.98,NULL,NULL,1,'2022-02-25 11:39:58','2022-02-25 11:39:58',NULL),(2609,3022,41024,175561,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2199.99,NULL,NULL,1,'2022-02-25 11:40:32','2022-02-25 11:40:32',NULL),(2610,3022,41024,175561,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',7065.88,NULL,NULL,1,'2022-02-25 11:42:33','2022-02-25 11:42:33',NULL);
INSERT INTO `balance_libro` VALUES (2611,3022,41024,175561,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',2033.25,NULL,NULL,1,'2022-02-25 11:48:40','2022-04-04 12:10:06','2022-04-04 12:10:06'),(2612,3022,41024,175561,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',1884.96,NULL,NULL,1,'2022-02-25 11:49:32','2022-02-25 11:49:32',NULL),(2613,3022,41024,175561,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',849.89,NULL,NULL,1,'2022-02-25 11:49:59','2022-02-25 11:49:59',NULL),(2614,3022,41024,175561,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',619.97,NULL,NULL,1,'2022-02-25 11:50:21','2022-02-25 11:50:21',NULL),(2615,3022,41024,175561,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1597.87,NULL,NULL,1,'2022-02-25 11:50:59','2022-02-25 11:50:59',NULL),(2616,3022,41024,175561,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',289.99,NULL,NULL,1,'2022-02-25 11:51:37','2022-02-25 11:51:37',NULL),(2617,3022,41024,175561,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',300.00,NULL,NULL,1,'2022-02-25 11:52:11','2022-04-01 10:45:48','2022-04-01 10:45:48'),(2618,3022,41024,175561,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2033.25,NULL,NULL,1,'2022-02-25 11:53:27','2022-04-04 12:30:39','2022-04-04 12:30:39'),(2619,3022,41024,175561,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',800.00,NULL,NULL,1,'2022-02-25 11:56:45','2022-02-25 11:56:45',NULL),(2620,3022,41024,175561,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',70000.00,NULL,NULL,1,'2022-02-25 11:58:16','2022-02-25 11:59:43','2022-02-25 11:59:43'),(2621,3022,41024,175561,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',70000.00,NULL,NULL,1,'2022-02-25 11:59:43','2022-02-25 11:59:43',NULL),(2622,3022,41024,175561,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',27248.76,NULL,NULL,1,'2022-02-25 12:01:10','2022-02-25 12:01:10',NULL),(2623,3022,41024,175561,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',70000.00,NULL,NULL,1,'2022-02-25 12:01:51','2022-02-25 12:01:51',NULL),(2624,3022,41024,175561,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',659.98,NULL,NULL,1,'2022-02-25 12:02:58','2022-02-25 12:02:58',NULL),(2625,3022,41024,175561,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',19897.68,NULL,NULL,1,'2022-02-25 12:04:02','2022-02-25 12:04:02',NULL),(2626,3022,41024,175561,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',11313.50,NULL,NULL,1,'2022-02-25 13:22:48','2022-02-25 13:24:59','2022-02-25 13:24:59'),(2627,3022,41024,175561,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',6534.00,NULL,NULL,1,'2022-02-25 13:22:48','2022-02-25 13:27:16','2022-02-25 13:27:16'),(2628,3022,41024,175561,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',6534.00,NULL,NULL,1,'2022-02-25 13:22:48','2022-02-25 13:27:11','2022-02-25 13:27:11'),(2629,3022,41024,175561,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',1499.19,NULL,NULL,1,'2022-02-25 13:22:48','2022-02-25 13:27:08','2022-02-25 13:27:08'),(2630,3022,41024,175561,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',29753.90,NULL,NULL,1,'2022-02-25 13:22:48','2022-02-25 13:27:03','2022-02-25 13:27:03');
INSERT INTO `balance_libro` VALUES (2631,3022,41024,175561,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',847.00,NULL,NULL,1,'2022-02-25 13:22:48','2022-02-25 13:26:57','2022-02-25 13:26:57'),(2632,3022,41024,175561,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1694.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:53','2022-02-25 13:26:53'),(2633,3022,41024,175561,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',847.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:50','2022-02-25 13:26:50'),(2634,3022,41024,175561,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',2541.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:45','2022-02-25 13:26:45'),(2635,3022,41024,175561,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',907.50,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:42','2022-02-25 13:26:42'),(2636,3022,41024,175561,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',847.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:37','2022-02-25 13:26:37'),(2637,3022,41024,175561,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',2541.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:34','2022-02-25 13:26:34'),(2638,3022,41024,175561,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',3569.50,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:27','2022-02-25 13:26:27'),(2639,3022,41024,175561,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',24998.60,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:23','2022-02-25 13:26:23'),(2640,3022,41024,175561,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',5929.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:20','2022-02-25 13:26:20'),(2641,3022,41024,175561,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',8470.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:16','2022-02-25 13:26:16'),(2642,3022,41024,175561,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',5929.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:13','2022-02-25 13:26:13'),(2643,3022,41024,175561,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',7623.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:09','2022-02-25 13:26:09'),(2644,3022,41024,175561,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',7139.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:26:06','2022-02-25 13:26:06'),(2645,3022,41024,175561,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',600.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:59','2022-02-25 13:25:59'),(2646,3022,41024,175561,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',133487.20,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:56','2022-02-25 13:25:56'),(2647,3022,41024,175561,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',170973.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:53','2022-02-25 13:25:53'),(2648,3022,41024,175561,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',6231.50,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:49','2022-02-25 13:25:49'),(2649,3022,41024,175561,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',7139.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:44','2022-02-25 13:25:44');
INSERT INTO `balance_libro` VALUES (2650,3022,41024,175561,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1694.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:41','2022-02-25 13:25:41'),(2651,3022,41024,175561,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',2541.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:38','2022-02-25 13:25:38'),(2652,3022,41024,175561,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',12705.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:34','2022-02-25 13:25:34'),(2653,3022,41024,175561,3,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',3569.50,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:31','2022-02-25 13:25:31'),(2654,3022,41024,175561,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',907.50,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:28','2022-02-25 13:25:28'),(2655,3022,41024,175561,3,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1754.50,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:24','2022-02-25 13:25:24'),(2656,3022,41024,175561,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',847.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:21','2022-02-25 13:25:21'),(2657,3022,41024,175561,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1573.00,NULL,NULL,1,'2022-02-25 13:22:49','2022-02-25 13:25:09','2022-02-25 13:25:09'),(2658,3022,41024,175561,2,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',11313.50,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2659,3022,41024,175561,2,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',6534.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2660,3022,41024,175561,2,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',6534.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2661,3022,41024,175561,2,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',1499.19,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2662,3022,41024,175561,2,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',29753.90,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2663,3022,41024,175561,2,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',847.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2664,3022,41024,175561,2,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1694.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2665,3022,41024,175561,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',847.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2666,3022,41024,175561,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',2541.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2667,3022,41024,175561,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',907.50,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2668,3022,41024,175561,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',847.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2669,3022,41024,175561,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',2541.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL);
INSERT INTO `balance_libro` VALUES (2670,3022,41024,175561,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',3569.50,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2671,3022,41024,175561,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',24998.60,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2672,3022,41024,175561,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',5929.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2673,3022,41024,175561,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',8470.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2674,3022,41024,175561,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',5929.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2675,3022,41024,175561,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',7623.00,NULL,NULL,1,'2022-02-25 13:27:44','2022-02-25 13:27:44',NULL),(2676,3022,41024,175561,2,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',7139.00,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2677,3022,41024,175561,2,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',600.00,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2678,3022,41024,175561,2,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',133487.20,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2679,3022,41024,175561,2,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',170973.00,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2680,3022,41024,175561,2,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',6231.50,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2681,3022,41024,175561,2,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',7139.00,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2682,3022,41024,175561,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1694.00,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2683,3022,41024,175561,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',2541.00,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2684,3022,41024,175561,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',12705.00,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2685,3022,41024,175561,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',3569.50,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2686,3022,41024,175561,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',907.50,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2687,3022,41024,175561,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1754.50,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2688,3022,41024,175561,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',847.00,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL),(2689,3022,41024,175561,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1573.00,NULL,NULL,1,'2022-02-25 13:27:45','2022-02-25 13:27:45',NULL);
INSERT INTO `balance_libro` VALUES (2690,3022,40939,173433,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',99922.96,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2691,3022,40939,173433,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',99922.96,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2692,3022,40939,173433,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',99922.96,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2693,3022,40939,173433,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',21578.69,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2694,3022,40939,173433,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',77761.06,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2695,3022,40939,173433,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',97201.32,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2696,3022,40939,173433,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',4379.78,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2697,3022,40939,173433,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',434977.72,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2698,3022,40939,173433,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',174954.65,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2699,3022,40939,173433,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',174954.65,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2700,3022,40939,173433,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',174954.65,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2701,3022,40939,173433,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',174954.65,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2702,3022,40939,173433,2,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',93151.50,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2703,3022,40939,173433,2,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',93151.50,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2704,3022,40939,173433,2,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',93151.50,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2705,3022,40939,173433,2,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',186303.00,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2706,3022,40939,173433,2,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',4678.13,NULL,NULL,1,'2022-02-25 13:28:39','2022-02-25 13:28:39',NULL),(2707,3022,40939,173433,2,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',93151.50,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2708,3022,40939,173433,2,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',83836.35,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2709,3022,40939,173433,2,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',168888.20,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL);
INSERT INTO `balance_libro` VALUES (2710,3022,40939,173433,2,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',34020.74,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2711,3022,40939,173433,2,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',170103.70,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2712,3022,40939,173433,2,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',51031.11,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2713,3022,40939,173433,2,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',170103.70,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2714,3022,40939,173433,2,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',170103.70,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2715,3022,40939,173433,2,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2716,3022,40939,173433,2,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2717,3022,40939,173433,2,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2718,3022,40939,173433,2,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',94499.60,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2719,3022,40939,173433,2,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',188999.20,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2720,3022,40939,173433,2,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',94499.60,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2721,3022,40939,173433,2,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',94499.60,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2722,3022,40939,173433,2,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',94499.60,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2723,3022,40939,173433,2,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',94499.60,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2724,3022,40939,173433,2,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',94499.60,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2725,3022,40939,173433,2,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',94499.60,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2726,3022,40939,173433,2,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2727,3022,40939,173433,2,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2728,3022,40939,173433,2,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2729,3022,40939,173433,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL);
INSERT INTO `balance_libro` VALUES (2730,3022,40939,173433,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2731,3022,40939,173433,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2732,3022,40939,173433,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',85051.85,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2733,3022,40939,173433,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',95919.12,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2734,3022,40939,173433,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',116953.20,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2735,3022,40939,173433,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',4379.78,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2736,3022,40939,173433,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',4678.13,NULL,NULL,1,'2022-02-25 13:28:40','2022-02-25 13:28:40',NULL),(2737,3022,40819,151527,3,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',1492.34,NULL,NULL,1,'2022-02-28 17:38:31','2022-02-28 17:38:31',NULL),(2738,3022,40819,151527,3,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',667.00,NULL,NULL,1,'2022-02-28 17:38:31','2022-02-28 17:38:31',NULL),(2739,3022,40819,151527,3,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',37440.27,NULL,NULL,1,'2022-02-28 17:38:31','2022-02-28 17:38:31',NULL),(2740,3022,40819,151527,3,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',36000.00,NULL,NULL,1,'2022-02-28 17:38:31','2022-02-28 17:38:31',NULL),(2741,3022,40819,151527,3,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',13900.00,NULL,NULL,1,'2022-02-28 17:38:31','2022-02-28 17:38:31',NULL),(2742,3022,40819,151527,3,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4090.02,NULL,NULL,1,'2022-02-28 17:38:31','2022-02-28 17:38:31',NULL),(2743,3022,40819,151527,3,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',20098.09,NULL,NULL,1,'2022-02-28 17:38:31','2022-02-28 17:38:31',NULL),(2744,3022,40819,151527,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',3571.16,NULL,NULL,1,'2022-02-28 17:54:43','2022-02-28 17:54:43',NULL),(2745,3022,40819,151527,3,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',1892.78,NULL,NULL,1,'2022-03-03 16:26:54','2022-03-03 16:26:54',NULL),(2746,3022,40819,151527,3,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',4600.22,NULL,NULL,1,'2022-03-03 16:30:37','2022-03-03 16:32:37','2022-03-03 16:32:37'),(2747,3022,40819,151527,3,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',4722.49,NULL,NULL,1,'2022-03-03 16:32:37','2022-03-03 16:32:37',NULL),(2748,3022,40819,151527,3,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4643.50,NULL,NULL,1,'2022-03-03 16:48:12','2022-03-03 16:48:12',NULL),(2749,3022,40939,173434,3,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',1000.00,NULL,NULL,1,'2022-03-08 11:11:00','2022-03-08 11:11:00',NULL);
INSERT INTO `balance_libro` VALUES (2750,3022,40939,173434,3,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',1000.00,NULL,NULL,1,'2022-03-08 11:11:30','2022-03-08 11:11:30',NULL),(2751,3022,40939,173434,3,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',3000.10,NULL,NULL,1,'2022-03-08 11:14:15','2022-03-08 11:50:33','2022-03-08 11:50:33'),(2752,3022,40939,173434,3,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',5000.68,NULL,NULL,1,'2022-03-08 11:16:51','2022-03-08 11:16:51',NULL),(2753,3022,40939,173434,3,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1000.00,NULL,NULL,1,'2022-03-08 11:17:33','2022-03-08 11:17:33',NULL),(2754,3022,40939,173434,3,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',4020.89,NULL,NULL,1,'2022-03-08 11:18:32','2022-03-08 11:18:32',NULL),(2755,3022,40939,173434,3,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',4015.56,NULL,NULL,1,'2022-03-08 11:25:00','2022-03-08 11:25:00',NULL),(2756,3022,40939,173434,3,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',3999.82,NULL,NULL,1,'2022-03-08 11:25:40','2022-03-08 11:25:40',NULL),(2757,3022,40939,173434,3,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',9.99,NULL,NULL,1,'2022-03-08 11:29:13','2022-03-08 11:29:39','2022-03-08 11:29:39'),(2758,3022,40939,173434,3,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',1000.00,NULL,NULL,1,'2022-03-08 11:29:39','2022-03-08 11:29:39',NULL),(2759,3022,40939,173434,3,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',5001.17,NULL,NULL,1,'2022-03-08 11:31:38','2022-03-08 11:31:38',NULL),(2760,3022,40939,173434,3,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',5999.99,NULL,NULL,1,'2022-03-08 11:39:56','2022-03-08 11:39:56',NULL),(2761,3022,40939,173434,3,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',4000.65,NULL,NULL,1,'2022-03-08 11:41:34','2022-03-08 11:41:34',NULL),(2762,3022,40939,173434,3,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',4884.90,NULL,NULL,1,'2022-03-08 11:43:40','2022-03-08 11:43:40',NULL),(2763,3022,40939,173434,3,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',5006.71,NULL,NULL,1,'2022-03-08 11:45:09','2022-03-08 11:45:09',NULL),(2764,3022,40939,173434,3,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',5655.46,NULL,NULL,1,'2022-03-08 11:46:44','2022-03-08 11:46:44',NULL),(2765,3022,40939,173434,3,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',3008.55,NULL,NULL,1,'2022-03-08 11:48:03','2022-03-08 11:48:03',NULL),(2766,3022,40939,173434,3,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',4005.13,NULL,NULL,1,'2022-03-08 11:48:38','2022-03-08 11:48:38',NULL),(2767,3022,40939,173434,3,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',7005.97,NULL,NULL,1,'2022-03-08 12:46:02','2022-03-08 12:46:02',NULL),(2768,3022,40939,173434,3,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',5000.13,NULL,NULL,1,'2022-03-08 12:46:55','2022-03-08 12:46:55',NULL),(2769,3022,40939,173434,3,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',4504.30,NULL,NULL,1,'2022-03-08 12:47:28','2022-03-08 12:47:28',NULL);
INSERT INTO `balance_libro` VALUES (2770,3022,40939,173434,3,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',6000.19,NULL,NULL,1,'2022-03-08 12:48:00','2022-03-08 12:48:00',NULL),(2771,3022,40720,1543,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',14285.10,NULL,NULL,1,'2022-03-09 12:30:23','2022-03-09 12:30:23',NULL),(2772,3022,40720,1543,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',15774.01,NULL,NULL,1,'2022-03-09 12:31:31','2022-03-09 12:31:31',NULL),(2773,3022,40720,1543,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',9593.00,NULL,NULL,1,'2022-03-09 12:32:43','2022-03-09 12:32:43',NULL),(2774,3022,40720,1543,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',12953.98,NULL,NULL,1,'2022-03-09 12:33:13','2022-03-09 12:33:13',NULL),(2775,3022,40720,1543,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',13935.91,NULL,NULL,1,'2022-03-09 12:46:50','2022-03-09 12:46:50',NULL),(2776,3022,40720,1543,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',12491.00,NULL,NULL,1,'2022-03-09 12:47:27','2022-03-09 12:47:27',NULL),(2777,3022,40720,1543,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',9516.99,NULL,NULL,1,'2022-03-09 12:48:06','2022-03-09 12:48:06',NULL),(2778,3022,40720,1543,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',0.01,NULL,NULL,1,'2022-03-09 12:48:21','2022-03-09 12:48:21',NULL),(2779,3022,40720,1543,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',17632.99,NULL,NULL,1,'2022-03-09 12:49:27','2022-03-09 12:49:27',NULL),(2780,3022,40720,1543,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',17979.54,NULL,NULL,1,'2022-03-09 12:50:33','2022-03-09 12:50:33',NULL),(2781,3022,40720,1543,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',11554.05,NULL,NULL,1,'2022-03-09 12:51:25','2022-03-09 12:51:25',NULL),(2782,3022,40720,1543,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',17784.09,NULL,NULL,1,'2022-03-09 12:56:35','2022-03-09 12:56:35',NULL),(2783,3022,40720,1543,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',13175.94,NULL,NULL,1,'2022-03-09 12:57:30','2022-03-09 12:57:30',NULL),(2784,3022,40720,1543,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-13','2022-02-13',15030.00,NULL,NULL,1,'2022-03-09 12:58:17','2022-03-09 12:58:17',NULL),(2785,3022,40720,1543,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',12607.01,NULL,NULL,1,'2022-03-09 12:59:14','2022-03-09 12:59:14',NULL),(2786,3022,40720,1543,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',8961.95,NULL,NULL,1,'2022-03-09 13:00:28','2022-03-09 13:00:28',NULL),(2787,3022,40720,1543,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',0.01,NULL,NULL,1,'2022-03-09 13:00:42','2022-03-09 13:00:42',NULL),(2788,3022,40720,1543,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',8132.01,NULL,NULL,1,'2022-03-09 13:01:12','2022-03-09 13:01:12',NULL),(2789,3022,40720,1543,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',27850.00,NULL,NULL,1,'2022-03-09 13:02:13','2022-03-09 13:02:13',NULL),(2790,3022,40720,1543,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',12728.01,NULL,NULL,1,'2022-03-09 13:02:40','2022-03-09 13:02:40',NULL);
INSERT INTO `balance_libro` VALUES (2791,3022,40939,173434,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',179816.65,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2792,3022,40939,173434,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',179816.65,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2793,3022,40939,173434,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',179816.65,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2794,3022,40939,173434,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',199795.05,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2795,3022,40939,173434,2,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',99897.52,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2796,3022,40939,173434,2,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',179815.54,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2797,3022,40939,173434,2,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',99897.52,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2798,3022,40939,173434,2,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',105300.98,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2799,3022,40939,173434,2,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',105300.98,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2800,3022,40939,173434,2,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',105300.98,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2801,3022,40939,173434,2,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',105300.98,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2802,3022,40939,173434,2,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',105300.98,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2803,3022,40939,173434,2,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',105300.98,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2804,3022,40939,173434,2,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',113724.39,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2805,3022,40939,173434,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',75816.26,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2806,3022,40939,173434,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',189540.65,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2807,3022,40939,173434,2,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',106649.08,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2808,3022,40939,173434,2,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',106649.08,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2809,3022,40939,173434,2,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',106649.08,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2810,3022,40939,173434,2,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',434065.55,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL);
INSERT INTO `balance_libro` VALUES (2811,3022,40939,173434,2,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',106649.08,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2812,3022,40939,173434,2,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',49059.24,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2813,3022,40939,173434,2,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:11','2022-03-10 11:16:11',NULL),(2814,3022,40939,173434,2,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2815,3022,40939,173434,2,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2816,3022,40939,173434,2,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',57591.50,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2817,3022,40939,173434,2,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2818,3022,40939,173434,2,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2819,3022,40939,173434,2,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',57591.50,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2820,3022,40939,173434,2,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2821,3022,40939,173434,2,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2822,3022,40939,173434,2,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2823,3022,40939,173434,2,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2824,3022,40939,173434,2,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',95985.82,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2825,3022,40939,173434,2,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',19059.00,NULL,NULL,1,'2022-03-10 11:16:12','2022-03-10 11:16:12',NULL),(2826,3022,40939,173433,3,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',9449.98,NULL,NULL,1,'2022-03-10 16:20:52','2022-03-10 16:20:52',NULL),(2827,3022,41024,175562,3,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',1355.00,NULL,NULL,1,'2022-03-11 10:38:03','2022-03-11 10:38:03',NULL),(2828,3022,41024,175562,3,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',799.97,NULL,NULL,1,'2022-03-11 10:40:49','2022-03-11 10:40:49',NULL),(2829,3022,41024,175562,3,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',522.97,NULL,NULL,1,'2022-03-11 10:41:31','2022-03-11 10:41:31',NULL),(2830,3022,41024,175562,3,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',1000.00,NULL,NULL,1,'2022-03-11 10:47:35','2022-03-11 10:47:35',NULL);
INSERT INTO `balance_libro` VALUES (2831,3022,41024,175562,3,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',500.00,NULL,NULL,1,'2022-03-11 10:48:13','2022-03-11 10:48:13',NULL),(2832,3022,41024,175562,3,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',999.98,NULL,NULL,1,'2022-03-11 10:57:30','2022-03-11 10:57:30',NULL),(2833,3022,41024,175562,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',1800.00,NULL,NULL,1,'2022-03-11 10:58:25','2022-03-25 11:56:26','2022-03-25 11:56:26'),(2834,3022,41024,175562,3,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',659.97,NULL,NULL,1,'2022-03-11 11:01:40','2022-03-11 11:01:40',NULL),(2835,3022,41024,175562,3,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',1350.00,NULL,NULL,1,'2022-03-11 11:02:38','2022-03-11 11:02:38',NULL),(2836,3022,41024,175562,3,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',399.99,NULL,NULL,1,'2022-03-11 11:06:08','2022-03-11 11:06:08',NULL),(2837,3022,41024,175562,3,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',1166.63,NULL,NULL,1,'2022-03-11 11:08:06','2022-03-11 11:08:06',NULL),(2838,3022,41024,175562,3,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',300.00,NULL,NULL,1,'2022-03-11 11:21:48','2022-03-11 11:21:48',NULL),(2839,3022,41024,175562,3,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',975.98,NULL,NULL,1,'2022-03-11 11:25:13','2022-03-11 11:25:13',NULL),(2840,3022,41024,175562,3,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',959.98,NULL,NULL,1,'2022-03-11 11:27:10','2022-03-11 11:27:10',NULL),(2841,3022,41024,175562,3,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',1189.97,NULL,NULL,1,'2022-03-11 11:27:49','2022-03-11 11:27:49',NULL),(2842,3022,41024,175562,3,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',1646.84,NULL,NULL,1,'2022-03-11 11:29:02','2022-03-11 11:29:02',NULL),(2843,3022,41024,175562,2,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',6349.80,NULL,NULL,1,'2022-03-11 11:52:53','2022-03-14 11:18:30','2022-03-14 11:18:30'),(2844,3022,41024,175562,2,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',5495.96,NULL,NULL,1,'2022-03-11 11:54:15','2022-03-14 11:30:02','2022-03-14 11:30:02'),(2845,3022,41024,175562,2,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1015.00,NULL,NULL,1,'2022-03-11 11:54:55','2022-03-14 11:45:36','2022-03-14 11:45:36'),(2846,3022,41024,175562,2,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',20635.21,NULL,NULL,1,'2022-03-11 11:59:03','2022-03-14 11:50:10','2022-03-14 11:50:10'),(2847,3022,41024,175562,2,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',3055.35,NULL,NULL,1,'2022-03-11 12:01:13','2022-03-14 11:52:10','2022-03-14 11:52:10'),(2848,3022,41024,175562,2,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',1339.96,NULL,NULL,1,'2022-03-11 12:02:43','2022-03-14 11:54:41','2022-03-14 11:54:41'),(2849,3022,41024,175562,2,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',2823.76,NULL,NULL,1,'2022-03-11 12:04:12','2022-03-14 11:56:31','2022-03-14 11:56:31'),(2850,3022,41024,175562,2,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',800.00,NULL,NULL,1,'2022-03-11 12:05:08','2022-03-14 12:00:08','2022-03-14 12:00:08');
INSERT INTO `balance_libro` VALUES (2851,3022,41024,175562,2,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1224.97,NULL,NULL,1,'2022-03-11 12:06:05','2022-03-14 11:42:41','2022-03-14 11:42:41'),(2852,3022,41024,175562,2,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',13299.81,NULL,NULL,1,'2022-03-11 12:06:43','2022-03-14 12:02:28','2022-03-14 12:02:28'),(2853,3022,41024,175562,2,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',38487.80,NULL,NULL,1,'2022-03-11 12:23:36','2022-03-14 12:03:33','2022-03-14 12:03:33'),(2854,3022,41024,175562,2,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',15999.00,NULL,NULL,1,'2022-03-11 12:33:01','2022-03-14 12:04:25','2022-03-14 12:04:25'),(2855,3022,41024,175562,2,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',24180.00,NULL,NULL,1,'2022-03-11 12:33:43','2022-03-14 12:05:21','2022-03-14 12:05:21'),(2856,3022,41024,175562,2,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',11800.00,NULL,NULL,1,'2022-03-11 12:40:39','2022-03-14 12:06:10','2022-03-14 12:06:10'),(2857,3022,41024,175562,2,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',1139.05,NULL,NULL,1,'2022-03-11 12:52:06','2022-03-14 12:06:55','2022-03-14 12:06:55'),(2858,3022,41024,175562,2,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',11799.00,NULL,NULL,1,'2022-03-11 12:55:09','2022-03-14 12:07:33','2022-03-14 12:07:33'),(2859,3022,41024,175562,2,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',1499.99,NULL,NULL,1,'2022-03-11 12:57:53','2022-03-14 12:08:11','2022-03-14 12:08:11'),(2860,3022,41024,175562,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',16800.00,NULL,NULL,1,'2022-03-11 13:04:04','2022-03-11 13:04:04',NULL),(2861,3022,41024,175562,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',17900.01,NULL,NULL,1,'2022-03-11 13:07:18','2022-03-11 13:07:18',NULL),(2862,3022,41024,175562,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',8564.32,NULL,NULL,1,'2022-03-11 13:08:23','2022-03-11 13:08:23',NULL),(2863,3022,41024,175562,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',25649.05,NULL,NULL,1,'2022-03-11 13:09:31','2022-03-11 13:09:31',NULL),(2864,3022,41024,175562,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',6349.80,NULL,NULL,1,'2022-03-14 11:18:14','2022-03-14 11:18:14',NULL),(2865,3022,41024,175562,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',5495.96,NULL,NULL,1,'2022-03-14 11:29:54','2022-03-14 11:29:54',NULL),(2866,3022,41024,175562,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1224.96,NULL,NULL,1,'2022-03-14 11:42:32','2022-03-14 11:42:32',NULL),(2867,3022,41024,175562,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1015.00,NULL,NULL,1,'2022-03-14 11:44:06','2022-03-14 11:44:06',NULL),(2868,3022,41024,175562,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',20635.21,NULL,NULL,1,'2022-03-14 11:49:00','2022-03-14 11:49:00',NULL),(2869,3022,41024,175562,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',3055.35,NULL,NULL,1,'2022-03-14 11:52:06','2022-03-14 11:52:06',NULL),(2870,3022,41024,175562,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',1339.97,NULL,NULL,1,'2022-03-14 11:54:32','2022-03-14 11:54:32',NULL);
INSERT INTO `balance_libro` VALUES (2871,3022,41024,175562,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',2823.76,NULL,NULL,1,'2022-03-14 11:56:25','2022-03-14 11:56:25',NULL),(2872,3022,41024,175562,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',800.00,NULL,NULL,1,'2022-03-14 12:00:02','2022-03-14 12:00:02',NULL),(2873,3022,41024,175562,3,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',13299.81,NULL,NULL,1,'2022-03-14 12:02:24','2022-03-25 11:12:44','2022-03-25 11:12:44'),(2874,3022,41024,175562,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',38487.80,NULL,NULL,1,'2022-03-14 12:03:28','2022-03-14 12:03:28',NULL),(2875,3022,41024,175562,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',15999.00,NULL,NULL,1,'2022-03-14 12:04:18','2022-03-14 12:04:18',NULL),(2876,3022,41024,175562,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',24180.00,NULL,NULL,1,'2022-03-14 12:05:17','2022-03-14 12:05:17',NULL),(2877,3022,41024,175562,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',11800.00,NULL,NULL,1,'2022-03-14 12:06:06','2022-03-14 12:06:06',NULL),(2878,3022,41024,175562,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',1139.05,NULL,NULL,1,'2022-03-14 12:06:48','2022-03-14 12:06:48',NULL),(2879,3022,41024,175562,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',11799.00,NULL,NULL,1,'2022-03-14 12:07:29','2022-03-14 12:07:29',NULL),(2880,3022,41024,175562,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',1499.99,NULL,NULL,1,'2022-03-14 12:08:07','2022-03-14 12:08:07',NULL),(2881,3022,41024,175562,2,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',15657.40,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2882,3022,41024,175562,2,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',1250.98,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2883,3022,41024,175562,2,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',12100.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2884,3022,41024,175562,2,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',4356.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2885,3022,41024,175562,2,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',5983.45,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2886,3022,41024,175562,2,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',19481.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2887,3022,41024,175562,2,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',12705.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2888,3022,41024,175562,2,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',16456.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2889,3022,41024,175562,2,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',9546.90,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2890,3022,41024,175562,2,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',6897.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL);
INSERT INTO `balance_libro` VALUES (2891,3022,41024,175562,2,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',6951.45,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2892,3022,41024,175562,2,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',4174.50,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2893,3022,41024,175562,2,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',11374.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2894,3022,41024,175562,2,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2662.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2895,3022,41024,175562,2,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1452.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2896,3022,41024,175562,2,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',726.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2897,3022,41024,175562,2,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',17278.80,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2898,3022,41024,175562,2,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',5082.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2899,3022,41024,175562,2,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',59834.50,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2900,3022,41024,175562,2,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',4477.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2901,3022,41024,175562,2,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',3448.50,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2902,3022,41024,175562,2,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',4235.00,NULL,NULL,1,'2022-03-14 12:36:14','2022-03-14 12:36:14',NULL),(2903,3022,40720,1543,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',3831.92,NULL,NULL,1,'2022-03-14 13:03:17','2022-03-14 13:03:17',NULL),(2904,3022,40720,1543,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1951.84,NULL,NULL,1,'2022-03-14 13:03:17','2022-03-14 13:03:17',NULL),(2905,3022,40720,1543,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2862.59,NULL,NULL,1,'2022-03-14 13:03:17','2022-03-14 13:03:17',NULL),(2906,3022,40720,1543,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1304.07,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2907,3022,40720,1543,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',182.20,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2908,3022,40720,1543,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',2741.06,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2909,3022,40720,1543,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',1308.88,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2910,3022,40720,1543,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',4100.10,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2911,3022,40720,1543,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1057.67,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL);
INSERT INTO `balance_libro` VALUES (2912,3022,40720,1543,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',15990.01,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2913,3022,40720,1543,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',10106.61,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2914,3022,40720,1543,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',3271.42,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2915,3022,40720,1543,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',11972.12,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2916,3022,40720,1543,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',4367.36,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2917,3022,40720,1543,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1608.00,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2918,3022,40720,1543,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',3900.00,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2919,3022,40720,1543,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',72447.60,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2920,3022,40720,1543,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',589.98,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2921,3022,40720,1543,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',3058.50,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2922,3022,40720,1543,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',0.00,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2923,3022,40720,1543,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',0.00,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2924,3022,40720,1543,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',5998.45,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2925,3022,40720,1543,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',1500.12,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2926,3022,40720,1543,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',251.30,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2927,3022,40720,1543,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',429.78,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2928,3022,40720,1543,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',1175.35,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2929,3022,40720,1543,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',10650.75,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2930,3022,40720,1543,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',7342.18,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2931,3022,40720,1543,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',6965.30,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2932,3022,40720,1543,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',1661.79,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL);
INSERT INTO `balance_libro` VALUES (2933,3022,40720,1543,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',3207.56,NULL,NULL,1,'2022-03-14 13:03:18','2022-03-14 13:03:18',NULL),(2934,3022,40720,1543,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',1308.88,NULL,NULL,1,'2022-03-14 13:03:19','2022-03-14 13:03:19',NULL),(2935,3022,40720,1543,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',3168.50,NULL,NULL,1,'2022-03-14 13:03:19','2022-03-14 13:03:19',NULL),(2936,3022,40720,1543,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',3307.86,NULL,NULL,1,'2022-03-14 13:03:19','2022-03-14 13:03:19',NULL),(2937,3022,40720,1543,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',3195.55,NULL,NULL,1,'2022-03-14 13:03:19','2022-03-14 13:03:19',NULL),(2938,3022,40720,1543,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',828.53,NULL,NULL,1,'2022-03-14 13:03:19','2022-03-14 13:03:19',NULL),(2939,3022,40720,1543,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',1050.00,NULL,NULL,1,'2022-03-14 13:03:19','2022-03-14 13:03:19',NULL),(2940,3022,40720,1543,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',69453.17,NULL,NULL,1,'2022-03-14 13:03:19','2022-03-14 13:03:19',NULL),(2941,3022,40720,1543,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',4410.57,NULL,NULL,1,'2022-03-14 13:03:19','2022-03-14 13:03:19',NULL),(2942,3022,40720,1543,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',106649.08,NULL,NULL,1,'2022-03-14 13:03:19','2022-03-14 13:03:19',NULL),(2943,3022,40819,151529,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',43723.17,NULL,NULL,1,'2022-03-23 13:27:16','2022-03-23 13:27:16',NULL),(2944,3022,40819,151529,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',86499.65,NULL,NULL,1,'2022-03-23 13:29:23','2022-04-27 11:48:29','2022-04-27 11:48:29'),(2945,3022,41024,175562,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',1800.00,NULL,NULL,1,'2022-03-25 11:56:26','2022-03-25 12:01:58','2022-03-25 12:01:58'),(2946,3022,41024,175562,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',1800.00,NULL,NULL,1,'2022-03-25 12:01:58','2022-03-25 12:02:20','2022-03-25 12:02:20'),(2947,3022,41024,175562,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',1800.00,NULL,NULL,1,'2022-03-25 12:02:20','2022-03-25 12:10:42','2022-03-25 12:10:42'),(2948,3022,41024,175562,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',1800.00,NULL,NULL,1,'2022-03-25 12:10:42','2022-03-25 12:16:10','2022-03-25 12:16:10'),(2949,3022,40819,151529,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',20479.94,NULL,NULL,1,'2022-03-25 12:11:16','2022-03-25 12:11:16',NULL),(2950,3022,40819,151529,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',9401.36,NULL,NULL,1,'2022-03-25 12:11:46','2022-03-25 12:11:46',NULL),(2951,3022,40819,151529,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',6076.46,NULL,NULL,1,'2022-03-25 12:12:34','2022-03-25 12:12:34',NULL),(2952,3022,40939,173434,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',26450.00,NULL,NULL,1,'2022-03-29 11:20:56','2022-03-29 11:20:56',NULL);
INSERT INTO `balance_libro` VALUES (2953,3022,40939,173434,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2200.00,NULL,NULL,1,'2022-03-29 11:20:57','2022-03-29 11:20:57',NULL),(2954,3022,40939,173434,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2000.00,NULL,NULL,1,'2022-03-29 11:20:57','2022-03-29 11:20:57',NULL),(2955,3022,40939,173434,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',55800.00,NULL,NULL,1,'2022-03-29 11:20:57','2022-03-29 11:20:57',NULL),(2956,3022,40939,173434,3,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',4999.00,NULL,NULL,1,'2022-03-29 11:20:57','2022-03-29 11:20:57',NULL),(2957,3022,40939,173434,3,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',7291.50,NULL,NULL,1,'2022-03-29 11:20:57','2022-03-29 11:20:57',NULL),(2958,3022,40939,173434,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',42790.00,NULL,NULL,1,'2022-03-29 11:20:57','2022-03-29 11:20:57',NULL),(2959,3022,40939,173434,3,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',38079.99,NULL,NULL,1,'2022-03-29 11:20:57','2022-03-29 11:20:57',NULL),(2960,3022,40939,173434,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',10850.00,NULL,NULL,1,'2022-03-29 11:20:57','2022-03-29 11:20:57',NULL),(2961,3022,40819,151528,2,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',217000.00,NULL,NULL,1,'2022-03-31 11:37:38','2022-03-31 11:37:38',NULL),(2966,3022,40819,151528,3,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',7110.00,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2967,3022,40819,151528,3,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2500.01,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2968,3022,40819,151528,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',22589.19,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2969,3022,40819,151528,3,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',15059.49,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2970,3022,40819,151528,3,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',1835.40,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2971,3022,40819,151528,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',8190.01,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2972,3022,40819,151528,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',45199.55,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2973,3022,40819,151528,3,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',4347.29,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2974,3022,40819,151528,3,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',17999.10,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2975,3022,40819,151528,3,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',1200.01,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2976,3022,40819,151528,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',36000.00,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL);
INSERT INTO `balance_libro` VALUES (2977,3022,40819,151528,3,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1140.96,NULL,NULL,1,'2022-03-31 11:59:29','2022-03-31 11:59:29',NULL),(2978,3022,40819,151528,3,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2500.01,NULL,NULL,1,'2022-03-31 11:59:30','2022-03-31 11:59:30',NULL),(2979,3022,40819,151528,3,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',6181.30,NULL,NULL,1,'2022-03-31 11:59:30','2022-03-31 11:59:30',NULL),(2980,3022,40819,151528,3,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',16600.00,NULL,NULL,1,'2022-03-31 11:59:30','2022-03-31 11:59:30',NULL),(2981,3022,41024,175562,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',1800.00,NULL,NULL,1,'2022-04-01 09:15:10','2022-04-01 10:16:20','2022-04-01 10:16:20'),(2982,3022,41024,175562,2,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',520.00,NULL,NULL,1,'2022-04-01 09:19:13','2022-04-01 10:16:47','2022-04-01 10:16:47'),(2983,3022,41024,175562,2,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',3418.52,NULL,NULL,1,'2022-04-01 09:26:26','2022-04-01 09:28:05','2022-04-01 09:28:05'),(2984,3022,41024,175562,2,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',500.00,NULL,NULL,1,'2022-04-01 09:32:16','2022-04-01 10:17:15','2022-04-01 10:17:15'),(2985,3022,41024,175562,2,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',300.00,NULL,NULL,1,'2022-04-01 09:33:35','2022-04-01 10:17:44','2022-04-01 10:17:44'),(2986,3022,41024,175562,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',520.00,NULL,NULL,1,'2022-04-01 10:21:28','2022-04-01 10:21:28',NULL),(2987,3022,41024,175562,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',1800.00,NULL,NULL,1,'2022-04-01 10:23:04','2022-04-01 10:23:04',NULL),(2988,3022,41024,175562,3,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',500.00,NULL,NULL,1,'2022-04-01 10:45:29','2022-04-01 10:45:29',NULL),(2989,3022,41024,175562,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',300.00,NULL,NULL,1,'2022-04-01 10:47:12','2022-04-01 10:47:12',NULL),(2990,3022,41024,175562,2,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',8643.91,NULL,NULL,1,'2022-04-04 09:34:54','2022-04-04 09:40:20','2022-04-04 09:40:20'),(2991,3022,41024,175562,2,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',2033.25,NULL,NULL,1,'2022-04-04 09:39:09','2022-04-04 09:40:54','2022-04-04 09:40:54'),(2992,3022,41024,175562,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',8643.91,NULL,NULL,1,'2022-04-04 09:43:57','2022-04-04 09:43:57',NULL),(2993,3022,41024,175562,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',6250.78,NULL,NULL,1,'2022-04-04 09:56:31','2022-04-04 09:56:31',NULL),(2994,3022,41024,175562,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',13299.81,NULL,NULL,1,'2022-04-04 09:58:29','2022-04-04 10:12:05','2022-04-04 10:12:05'),(2995,3022,41024,175562,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2033.25,NULL,NULL,1,'2022-04-04 10:01:03','2022-04-04 10:20:44','2022-04-04 10:20:44'),(2996,3022,41024,175562,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',3050.09,NULL,NULL,1,'2022-04-04 10:03:03','2022-04-04 10:20:12','2022-04-04 10:20:12');
INSERT INTO `balance_libro` VALUES (2997,3022,41024,175562,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',13299.81,NULL,NULL,1,'2022-04-04 10:15:12','2022-04-04 10:15:12',NULL),(2998,3022,41024,175562,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1400.00,NULL,NULL,1,'2022-04-04 12:19:13','2022-04-04 12:19:13',NULL),(2999,3022,41024,175562,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',2033.25,NULL,NULL,1,'2022-04-04 12:29:45','2022-04-04 12:29:45',NULL),(3000,3022,41024,175562,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2033.25,NULL,NULL,1,'2022-04-04 12:34:38','2022-04-04 12:34:38',NULL),(3001,3022,41024,175562,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',3050.09,NULL,NULL,1,'2022-04-04 23:27:08','2022-04-04 23:27:08',NULL),(3002,3022,41024,175561,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',1500.00,NULL,NULL,1,'2022-04-04 23:54:48','2022-04-04 23:54:48',NULL),(3003,3022,41024,175561,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',17610.00,NULL,NULL,1,'2022-04-04 23:56:20','2022-04-04 23:56:20',NULL),(3004,3022,41024,175561,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',5694.01,NULL,NULL,1,'2022-04-04 23:57:13','2022-04-04 23:57:13',NULL),(3005,3022,41024,175561,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',112.94,NULL,NULL,1,'2022-04-04 23:58:33','2022-04-04 23:59:24','2022-04-04 23:59:24'),(3006,3022,41024,175561,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',11294.00,NULL,NULL,1,'2022-04-04 23:59:24','2022-04-04 23:59:24',NULL),(3007,3022,41024,175561,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',9263.75,NULL,NULL,1,'2022-04-05 00:03:05','2022-04-05 00:03:05',NULL),(3008,3022,41024,175561,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',10164.00,NULL,NULL,1,'2022-04-05 00:04:09','2022-04-05 00:04:40','2022-04-05 00:04:40'),(3009,3022,41024,175561,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',10164.00,NULL,NULL,1,'2022-04-05 00:06:48','2022-04-05 00:06:48',NULL),(3010,3022,41024,175561,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',752.00,NULL,NULL,1,'2022-04-05 00:10:05','2022-04-05 00:10:05',NULL),(3011,3022,41024,175561,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2200.00,NULL,NULL,1,'2022-04-05 00:11:56','2022-04-05 00:11:56',NULL),(3012,3022,41024,175561,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',8557.85,NULL,NULL,1,'2022-04-05 00:15:47','2022-04-05 00:15:47',NULL),(3013,3022,41024,175561,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',15000.00,NULL,NULL,1,'2022-04-05 00:17:51','2022-04-05 00:17:51',NULL),(3014,3022,40939,173434,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',3000.10,NULL,NULL,1,'2022-04-05 11:28:44','2022-04-05 11:28:44',NULL),(3015,3022,40939,173434,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',5001.17,NULL,NULL,1,'2022-04-05 11:34:26','2022-04-05 11:34:26',NULL),(3016,3022,40939,173434,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',4901.60,NULL,NULL,1,'2022-04-05 11:37:35','2022-04-05 11:37:35',NULL);
INSERT INTO `balance_libro` VALUES (3017,3022,40939,173434,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',1000.04,NULL,NULL,1,'2022-04-05 11:42:03','2022-04-05 11:42:03',NULL),(3018,3022,40939,173434,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',499.97,NULL,NULL,1,'2022-04-05 11:43:05','2022-04-05 11:43:05',NULL),(3019,3022,40939,173434,3,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',4005.13,NULL,NULL,1,'2022-04-05 11:48:21','2022-04-05 11:48:21',NULL),(3020,3022,40939,173434,3,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',4480.06,NULL,NULL,1,'2022-04-05 11:51:45','2022-04-05 11:51:45',NULL),(3021,3022,40939,173434,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',6000.02,NULL,NULL,1,'2022-04-05 11:53:35','2022-04-05 11:53:35',NULL),(3022,3022,41024,175562,3,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',11294.00,NULL,NULL,1,'2022-04-06 07:58:24','2022-04-06 08:03:25','2022-04-06 08:03:25'),(3023,3022,41024,175561,3,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',11294.00,NULL,NULL,1,'2022-04-06 08:05:13','2022-04-06 08:05:13',NULL),(3024,3022,41024,175561,3,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',4473.50,NULL,NULL,1,'2022-04-06 08:08:50','2022-04-06 08:08:50',NULL),(3025,3022,40720,1544,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',10403.00,NULL,NULL,1,'2022-04-06 10:45:06','2022-04-06 10:45:06',NULL),(3026,3022,40720,1544,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',57571.00,NULL,NULL,1,'2022-04-06 10:46:58','2022-04-06 10:46:58',NULL),(3027,3022,40720,1544,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',0.01,NULL,NULL,1,'2022-04-06 10:47:14','2022-04-06 10:47:14',NULL),(3028,3022,40720,1544,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',9162.95,NULL,NULL,1,'2022-04-06 10:48:09','2022-04-06 10:48:09',NULL),(3029,3022,40720,1544,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',19800.86,NULL,NULL,1,'2022-04-06 10:49:01','2022-04-06 10:49:01',NULL),(3030,3022,40720,1544,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',17499.93,NULL,NULL,1,'2022-04-06 10:49:52','2022-04-06 10:49:52',NULL),(3031,3022,40720,1544,2,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',18712.06,NULL,NULL,1,'2022-04-06 10:51:46','2022-04-06 10:51:46',NULL),(3032,3022,40720,1544,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',16847.76,NULL,NULL,1,'2022-04-06 10:53:00','2022-04-06 10:53:00',NULL),(3033,3022,40720,1544,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',11551.04,NULL,NULL,1,'2022-04-06 10:53:46','2022-04-06 10:53:46',NULL),(3034,3022,40720,1544,2,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',10000.00,NULL,NULL,1,'2022-04-06 10:54:34','2022-04-06 10:54:34',NULL),(3035,3022,40720,1544,2,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',0.01,NULL,NULL,1,'2022-04-06 10:54:55','2022-04-06 10:54:55',NULL),(3036,3022,40720,1544,2,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',11720.01,NULL,NULL,1,'2022-04-06 10:58:45','2022-04-06 10:58:45',NULL),(3037,3022,40720,1544,2,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',18603.69,NULL,NULL,1,'2022-04-06 10:59:09','2022-04-06 10:59:09',NULL);
INSERT INTO `balance_libro` VALUES (3038,3022,40720,1544,2,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',10156.00,NULL,NULL,1,'2022-04-06 11:01:35','2022-04-06 11:01:35',NULL),(3039,3022,40720,1544,2,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',2187.99,NULL,NULL,1,'2022-04-06 11:02:00','2022-04-06 11:02:00',NULL),(3040,3022,40720,1544,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',9232.11,NULL,NULL,1,'2022-04-06 11:02:14','2022-04-06 11:02:23','2022-04-06 11:02:23'),(3041,3022,40720,1544,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',9232.11,NULL,NULL,1,'2022-04-06 11:02:23','2022-04-06 11:50:59','2022-04-06 11:50:59'),(3042,3022,40720,1544,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',17115.35,NULL,NULL,1,'2022-04-06 11:04:33','2022-04-06 11:51:32','2022-04-06 11:51:32'),(3043,3022,40939,173434,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',34650.00,NULL,NULL,1,'2022-04-06 11:07:44','2022-04-06 11:07:44',NULL),(3044,3022,40720,1544,2,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',19110.99,NULL,NULL,1,'2022-04-06 11:09:24','2022-04-06 11:09:24',NULL),(3045,3022,40939,173434,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',3008.55,NULL,NULL,1,'2022-04-06 11:11:22','2022-04-06 11:11:22',NULL),(3046,3022,40720,1544,2,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',15776.07,NULL,NULL,1,'2022-04-06 11:11:33','2022-04-06 11:11:33',NULL),(3047,3022,40720,1544,2,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',12362.00,NULL,NULL,1,'2022-04-06 11:13:46','2022-04-06 11:13:46',NULL),(3048,3022,40720,1544,2,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',16391.07,NULL,NULL,1,'2022-04-06 11:14:27','2022-04-06 11:14:27',NULL),(3049,3022,40720,1544,2,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',15517.92,NULL,NULL,1,'2022-04-06 11:15:06','2022-04-06 11:15:06',NULL),(3050,3022,40720,1544,2,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',0.01,NULL,NULL,1,'2022-04-06 11:15:21','2022-04-06 11:15:21',NULL),(3051,3022,40939,173434,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2094752.91,NULL,NULL,1,'2022-04-06 11:39:01','2022-04-06 11:39:01',NULL),(3052,3022,40939,173434,3,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1732525.17,NULL,NULL,1,'2022-04-06 11:42:19','2022-04-06 11:42:19',NULL),(3053,3022,40720,1544,2,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',9232.11,NULL,NULL,1,'2022-04-06 11:50:13','2022-04-06 11:50:13',NULL),(3054,3022,40720,1544,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',17115.35,NULL,NULL,1,'2022-04-06 11:51:32','2022-04-06 11:51:32',NULL),(3055,3022,40939,173435,3,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',27290.00,NULL,NULL,1,'2022-04-07 10:14:58','2022-04-07 10:14:58',NULL),(3056,3022,40939,173435,3,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',2700.01,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3057,3022,40939,173435,3,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',2450.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL);
INSERT INTO `balance_libro` VALUES (3058,3022,40939,173435,3,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',55800.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3059,3022,40939,173435,3,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',71250.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3060,3022,40939,173435,3,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1847.81,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3061,3022,40939,173435,3,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',2370.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3062,3022,40939,173435,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',10880.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3063,3022,40939,173435,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',5440.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3064,3022,40939,173435,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',12874.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3065,3022,40939,173435,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1960.49,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3066,3022,40939,173435,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',11500.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3067,3022,40939,173435,3,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',3799.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3068,3022,40939,173435,3,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',25999.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3069,3022,40939,173435,3,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',25999.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-11 11:29:49','2022-04-11 11:29:49'),(3070,3022,40939,173435,3,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',6999.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3071,3022,40939,173435,3,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',9500.00,NULL,NULL,1,'2022-04-07 10:14:59','2022-04-07 10:14:59',NULL),(3072,3022,40939,173435,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',323024.65,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3073,3022,40939,173435,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',215994.35,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3074,3022,40939,173435,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',215994.35,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3075,3022,40939,173435,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',131756.55,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3076,3022,40939,173435,2,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',97201.32,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3077,3022,40939,173435,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',301324.11,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL);
INSERT INTO `balance_libro` VALUES (3078,3022,40939,173435,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',184682.52,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3079,3022,40939,173435,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',116102.35,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3080,3022,40939,173435,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',116102.35,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3081,3022,40939,173435,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',116102.35,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3082,3022,40939,173435,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',655021.90,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3083,3022,40939,173435,2,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',116102.35,NULL,NULL,1,'2022-04-07 10:21:45','2022-04-07 10:21:45',NULL),(3084,3022,40939,173435,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',381892.42,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3085,3022,40939,173435,2,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',240324.24,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3086,3022,40939,173435,2,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',118787.50,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3087,3022,40939,173435,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',118787.50,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3088,3022,40939,173435,2,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',118787.50,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3089,3022,40939,173435,2,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',118787.50,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3090,3022,40939,173435,2,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',118787.50,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3091,3022,40939,173435,2,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',83151.25,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3092,3022,40939,173435,2,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',118787.50,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3093,3022,40939,173435,2,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',118787.50,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3094,3022,40939,173435,2,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3095,3022,40939,173435,2,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3096,3022,40939,173435,2,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3097,3022,40939,173435,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL);
INSERT INTO `balance_libro` VALUES (3098,3022,40939,173435,2,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3099,3022,40939,173435,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',64151.88,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3100,3022,40939,173435,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3101,3022,40939,173435,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',213839.60,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3102,3022,40939,173435,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',171071.68,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3103,3022,40939,173435,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3104,3022,40939,173435,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',85535.84,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3105,3022,40939,173435,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3106,3022,40939,173435,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3107,3022,40939,173435,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',106919.80,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3108,3022,40939,173435,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',128303.76,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3109,3022,40939,173435,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',75058.03,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3110,3022,40939,173435,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',75058.03,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3111,3022,40939,173435,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',75058.03,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3112,3022,40939,173435,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',75058.03,NULL,NULL,1,'2022-04-07 10:21:46','2022-04-07 10:21:46',NULL),(3113,3022,40939,173435,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',75058.03,NULL,NULL,1,'2022-04-07 10:21:47','2022-04-07 10:21:47',NULL),(3114,3022,40939,173435,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',100969.38,NULL,NULL,1,'2022-04-07 10:21:47','2022-04-07 10:21:47',NULL),(3115,3022,40939,173435,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',100969.38,NULL,NULL,1,'2022-04-07 10:21:47','2022-04-07 10:21:47',NULL),(3116,3022,40939,173435,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',105300.98,NULL,NULL,1,'2022-04-07 10:21:47','2022-04-07 10:21:47',NULL),(3117,3022,40939,173435,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',75058.03,NULL,NULL,1,'2022-04-07 10:21:47','2022-04-07 10:21:47',NULL);
INSERT INTO `balance_libro` VALUES (3118,3022,41024,175561,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1460.00,NULL,NULL,1,'2022-04-10 11:42:33','2022-04-11 09:28:20','2022-04-11 09:28:20'),(3119,3022,41024,175561,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1460.00,NULL,NULL,1,'2022-04-11 09:28:20','2022-04-28 10:04:43','2022-04-28 10:04:43'),(3120,3022,40939,173435,3,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',2599.90,NULL,NULL,1,'2022-04-11 11:32:15','2022-04-11 11:33:01','2022-04-11 11:33:01'),(3121,3022,40939,173435,3,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',25998.99,NULL,NULL,1,'2022-04-11 11:35:35','2022-04-11 11:35:35',NULL),(3122,3022,40939,173435,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',4000.65,NULL,NULL,1,'2022-04-11 11:47:27','2022-04-12 10:22:41','2022-04-12 10:22:41'),(3123,3022,40939,173435,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2999.99,NULL,NULL,1,'2022-04-11 11:49:44','2022-04-12 10:22:34','2022-04-12 10:22:34'),(3124,3022,40939,173435,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',5034.20,NULL,NULL,1,'2022-04-11 11:54:52','2022-04-12 10:22:25','2022-04-12 10:22:25'),(3125,3022,40939,173435,2,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2999.99,NULL,NULL,1,'2022-04-11 11:57:14','2022-04-12 10:22:16','2022-04-12 10:22:16'),(3126,3022,40939,173435,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',6306.48,NULL,NULL,1,'2022-04-11 11:59:33','2022-04-12 10:22:08','2022-04-12 10:22:08'),(3127,3022,40939,173435,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2999.99,NULL,NULL,1,'2022-04-11 12:02:00','2022-04-12 10:21:58','2022-04-12 10:21:58'),(3128,3022,40939,173435,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',4404.68,NULL,NULL,1,'2022-04-11 12:04:59','2022-04-12 10:21:49','2022-04-12 10:21:49'),(3129,3022,40939,173435,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',3999.99,NULL,NULL,1,'2022-04-12 09:30:41','2022-04-12 10:21:42','2022-04-12 10:21:42'),(3130,3022,40939,173435,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',3003.27,NULL,NULL,1,'2022-04-12 09:33:46','2022-04-12 10:21:30','2022-04-12 10:21:30'),(3131,3022,40939,173435,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',3999.99,NULL,NULL,1,'2022-04-12 09:35:17','2022-04-12 10:21:22','2022-04-12 10:21:22'),(3132,3022,40939,173435,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',5800.00,NULL,NULL,1,'2022-04-12 09:37:47','2022-04-12 10:21:13','2022-04-12 10:21:13'),(3133,3022,40939,173435,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',5500.07,NULL,NULL,1,'2022-04-12 09:40:44','2022-04-12 10:21:06','2022-04-12 10:21:06'),(3134,3022,40939,173435,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',5000.05,NULL,NULL,1,'2022-04-12 09:43:51','2022-04-12 10:20:57','2022-04-12 10:20:57'),(3135,3022,40939,173435,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',7249.53,NULL,NULL,1,'2022-04-12 09:46:01','2022-04-12 10:20:47','2022-04-12 10:20:47'),(3136,3022,40939,173435,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',5000.05,NULL,NULL,1,'2022-04-12 09:48:10','2022-04-12 10:20:37','2022-04-12 10:20:37');
INSERT INTO `balance_libro` VALUES (3137,3022,40939,173435,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',5000.05,NULL,NULL,1,'2022-04-12 09:52:19','2022-04-12 10:20:28','2022-04-12 10:20:28'),(3138,3022,40939,173435,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',6901.25,NULL,NULL,1,'2022-04-12 09:55:25','2022-04-12 10:20:13','2022-04-12 10:20:13'),(3139,3022,40939,173435,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',5000.03,NULL,NULL,1,'2022-04-12 09:58:14','2022-04-12 10:20:00','2022-04-12 10:20:00'),(3140,3022,40939,173435,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',6301.38,NULL,NULL,1,'2022-04-12 09:59:25','2022-04-12 10:19:48','2022-04-12 10:19:48'),(3141,3022,40939,173435,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1080.00,NULL,NULL,1,'2022-04-12 10:03:36','2022-04-12 10:19:38','2022-04-12 10:19:38'),(3142,3022,40939,173435,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',5000.05,NULL,NULL,1,'2022-04-12 10:05:29','2022-04-12 10:19:17','2022-04-12 10:19:17'),(3143,3022,40939,173435,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',5000.05,NULL,NULL,1,'2022-04-12 10:08:32','2022-04-12 10:19:02','2022-04-12 10:19:02'),(3144,3022,40939,173435,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5899.58,NULL,NULL,1,'2022-04-12 10:10:09','2022-04-12 10:18:45','2022-04-12 10:18:45'),(3145,3022,40939,173435,3,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',4000.65,NULL,NULL,1,'2022-04-12 10:24:50','2022-04-12 10:24:50',NULL),(3146,3022,40939,173435,3,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',5034.20,NULL,NULL,1,'2022-04-12 10:29:11','2022-04-12 10:29:11',NULL),(3147,3022,40939,173435,3,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2999.99,NULL,NULL,1,'2022-04-12 10:31:08','2022-04-12 10:31:08',NULL),(3148,3022,40939,173435,3,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',6006.38,NULL,NULL,1,'2022-04-12 10:32:24','2022-04-20 22:27:05','2022-04-20 22:27:05'),(3149,3022,40939,173435,3,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2999.99,NULL,NULL,1,'2022-04-12 10:34:41','2022-04-12 10:34:41',NULL),(3150,3022,40939,173435,3,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',4404.68,NULL,NULL,1,'2022-04-12 10:36:30','2022-04-12 10:36:30',NULL),(3151,3022,40939,173435,3,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',3999.99,NULL,NULL,1,'2022-04-12 10:38:35','2022-04-12 10:38:35',NULL),(3152,3022,40939,173435,3,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',3003.27,NULL,NULL,1,'2022-04-12 10:41:20','2022-04-12 10:41:20',NULL),(3153,3022,40939,173435,3,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',3999.99,NULL,NULL,1,'2022-04-12 10:46:46','2022-04-12 10:46:46',NULL),(3154,3022,40939,173435,3,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',5800.00,NULL,NULL,1,'2022-04-12 10:48:29','2022-04-12 10:48:29',NULL),(3155,3022,40939,173435,3,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',5500.07,NULL,NULL,1,'2022-04-12 10:49:47','2022-04-12 10:49:47',NULL),(3156,3022,40939,173435,3,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',5000.05,NULL,NULL,1,'2022-04-12 10:51:15','2022-04-12 10:51:15',NULL);
INSERT INTO `balance_libro` VALUES (3157,3022,40939,173435,3,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',7249.53,NULL,NULL,1,'2022-04-12 10:54:28','2022-04-12 10:54:28',NULL),(3158,3022,40939,173435,3,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',5000.05,NULL,NULL,1,'2022-04-12 10:55:55','2022-04-12 10:55:55',NULL),(3159,3022,40939,173435,3,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',5000.05,NULL,NULL,1,'2022-04-12 10:57:04','2022-04-12 10:57:04',NULL),(3160,3022,40939,173435,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',6901.25,NULL,NULL,1,'2022-04-12 10:58:31','2022-04-12 10:58:31',NULL),(3161,3022,40939,173435,3,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',5000.03,NULL,NULL,1,'2022-04-12 10:59:53','2022-04-12 10:59:53',NULL),(3162,3022,40939,173435,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',6301.38,NULL,NULL,1,'2022-04-12 11:00:57','2022-04-12 11:00:57',NULL),(3163,3022,40939,173435,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1080.00,NULL,NULL,1,'2022-04-12 11:01:55','2022-04-12 11:01:55',NULL),(3164,3022,40939,173435,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',5000.05,NULL,NULL,1,'2022-04-12 11:03:19','2022-04-12 11:03:19',NULL),(3165,3022,40939,173435,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',5000.05,NULL,NULL,1,'2022-04-12 11:04:22','2022-04-12 11:04:22',NULL),(3166,3022,40939,173435,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5899.58,NULL,NULL,1,'2022-04-12 11:05:34','2022-04-12 11:05:34',NULL),(3167,3022,40939,173435,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3527884.02,NULL,NULL,1,'2022-04-12 11:21:26','2022-04-12 11:21:26',NULL),(3168,3022,40939,173435,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2959865.82,NULL,NULL,1,'2022-04-12 11:22:27','2022-04-12 11:22:27',NULL),(3169,3022,40939,173435,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2999.99,NULL,NULL,1,'2022-04-13 10:10:26','2022-04-13 10:10:26',NULL),(3170,3022,40720,1544,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',3831.92,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3171,3022,40720,1544,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',6169.60,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3172,3022,40720,1544,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4195.31,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3173,3022,40720,1544,3,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',7848.19,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3174,3022,40720,1544,3,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4380.02,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3175,3022,40720,1544,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1772.78,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3176,3022,40720,1544,3,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',35194.25,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3177,3022,40720,1544,3,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',9630.91,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL);
INSERT INTO `balance_libro` VALUES (3178,3022,40720,1544,3,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',5692.00,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3179,3022,40720,1544,3,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1560.00,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3180,3022,40720,1544,3,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',3828.40,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3181,3022,40720,1544,3,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1444.15,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3182,3022,40720,1544,3,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',588.07,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3183,3022,40720,1544,3,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1928.64,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3184,3022,40720,1544,3,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',6792.58,NULL,NULL,1,'2022-04-13 11:02:28','2022-04-13 11:02:28',NULL),(3185,3022,40720,1544,3,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',9717.00,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3186,3022,40720,1544,3,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',4299.60,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3187,3022,40720,1544,3,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',2845.11,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3188,3022,40720,1544,3,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',3437.28,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3189,3022,40720,1544,3,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',11708.64,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3190,3022,40720,1544,3,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',3596.34,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3191,3022,40720,1544,3,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',4199.99,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3192,3022,40720,1544,3,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',3064.99,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3193,3022,40720,1544,3,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',6442.06,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3194,3022,40720,1544,3,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',292.13,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3195,3022,40720,1544,3,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',19262.10,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3196,3022,40720,1544,3,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',202.22,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3197,3022,40720,1544,3,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',404.04,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3198,3022,40720,1544,3,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',5892.40,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL);
INSERT INTO `balance_libro` VALUES (3199,3022,40720,1544,3,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',83221.91,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3200,3022,40720,1544,3,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',11132.40,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3201,3022,40720,1544,3,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',13920.00,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3202,3022,40720,1544,3,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',2475.39,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3203,3022,40720,1544,3,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',9039.80,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3204,3022,40720,1544,3,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',2054.75,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3205,3022,40720,1544,3,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',444.59,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3206,3022,40720,1544,3,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',1971.82,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3207,3022,40720,1544,3,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',4694.99,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3208,3022,40720,1544,3,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',3080.60,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3209,3022,40720,1544,3,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',7500.00,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3210,3022,40720,1544,3,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',983.22,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3211,3022,40720,1544,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',2227.06,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3212,3022,40720,1544,3,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',8891.73,NULL,NULL,1,'2022-04-13 11:02:29','2022-04-13 11:02:29',NULL),(3213,3022,40720,1544,3,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',2481.25,NULL,NULL,1,'2022-04-13 11:02:30','2022-04-13 11:02:30',NULL),(3214,3022,40720,1544,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',813.73,NULL,NULL,1,'2022-04-13 11:02:30','2022-04-13 11:02:30',NULL),(3215,3022,40720,1544,3,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1344.06,NULL,NULL,1,'2022-04-13 11:02:30','2022-04-13 11:02:30',NULL),(3216,3022,40720,1544,3,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',12798.00,NULL,NULL,1,'2022-04-13 11:02:30','2022-04-13 11:02:30',NULL),(3217,3022,40720,1544,3,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',6643.81,NULL,NULL,1,'2022-04-13 11:02:30','2022-04-13 11:02:30',NULL),(3218,3022,40720,1544,3,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5236.42,NULL,NULL,1,'2022-04-13 11:02:30','2022-04-13 11:02:30',NULL),(3219,3022,40720,1544,3,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',8256.22,NULL,NULL,1,'2022-04-13 11:02:30','2022-04-13 11:02:30',NULL);
INSERT INTO `balance_libro` VALUES (3220,3022,40720,1544,3,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1835.01,NULL,NULL,1,'2022-04-13 11:02:30','2022-04-13 11:02:30',NULL),(3221,3022,40720,1544,3,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',116102.35,NULL,NULL,1,'2022-04-13 11:02:30','2022-04-13 11:02:30',NULL),(3222,3022,41024,175563,3,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1528.22,NULL,NULL,1,'2022-04-20 12:23:59','2022-04-20 12:23:59',NULL),(3223,3022,41024,175563,3,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',4366.85,NULL,NULL,1,'2022-04-20 12:26:40','2022-04-20 12:26:40',NULL),(3224,3022,41024,175563,3,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1000.00,NULL,NULL,1,'2022-04-20 12:27:24','2022-04-20 12:27:24',NULL),(3225,3022,41024,175563,3,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1040.00,NULL,NULL,1,'2022-04-20 12:28:58','2022-04-20 12:28:58',NULL),(3226,3022,41024,175563,3,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1237.00,NULL,NULL,1,'2022-04-20 12:30:10','2022-04-20 12:30:10',NULL),(3227,3022,41024,175563,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1400.00,NULL,NULL,1,'2022-04-20 12:30:45','2022-04-20 12:30:45',NULL),(3228,3022,41024,175563,3,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',499.99,NULL,NULL,1,'2022-04-20 12:41:38','2022-04-20 12:41:38',NULL),(3229,3022,41024,175563,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',31500.00,NULL,NULL,1,'2022-04-20 12:42:33','2022-04-20 12:42:33',NULL),(3230,3022,41024,175563,3,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',2194.42,NULL,NULL,1,'2022-04-20 12:45:50','2022-04-20 12:45:50',NULL),(3231,3022,41024,175563,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',3055.35,NULL,NULL,1,'2022-04-20 12:47:54','2022-04-20 12:47:54',NULL),(3232,3022,41024,175563,3,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',76600.01,NULL,NULL,1,'2022-04-20 12:50:01','2022-04-20 12:50:01',NULL),(3233,3022,41024,175563,3,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1020.01,NULL,NULL,1,'2022-04-20 12:50:58','2022-04-20 12:50:58',NULL),(3234,3022,41024,175563,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',3325.00,NULL,NULL,1,'2022-04-20 12:51:38','2022-04-20 12:51:38',NULL),(3235,3022,41024,175563,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',920.00,NULL,NULL,1,'2022-04-20 12:52:44','2022-04-20 12:52:44',NULL),(3236,3022,40939,173435,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',6306.38,NULL,NULL,1,'2022-04-20 22:29:12','2022-04-20 22:29:12',NULL),(3237,3022,41024,175563,3,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',370.01,NULL,NULL,1,'2022-04-21 12:10:53','2022-04-21 12:10:53',NULL),(3238,3022,41024,175563,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1680.00,NULL,NULL,1,'2022-04-21 12:10:53','2022-04-21 12:10:53',NULL),(3239,3022,41024,175563,3,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',3598.55,NULL,NULL,1,'2022-04-21 12:10:53','2022-04-21 12:10:53',NULL),(3240,3022,41024,175563,3,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',2000.03,NULL,NULL,1,'2022-04-21 12:10:53','2022-04-21 12:10:53',NULL);
INSERT INTO `balance_libro` VALUES (3241,3022,41024,175563,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',12475.00,NULL,NULL,1,'2022-04-21 12:10:53','2022-04-21 12:10:53',NULL),(3242,3022,41024,175563,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',8199.00,NULL,NULL,1,'2022-04-21 12:10:53','2022-04-21 12:10:53',NULL),(3243,3022,41024,175563,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2720.00,NULL,NULL,1,'2022-04-21 12:10:53','2022-04-21 12:10:53',NULL),(3244,3022,41024,175563,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',4121.91,NULL,NULL,1,'2022-04-21 12:10:53','2022-04-21 12:10:53',NULL),(3245,3022,41024,175563,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',4116.88,NULL,NULL,1,'2022-04-21 12:10:53','2022-04-21 12:10:53',NULL),(3246,3022,41024,175563,3,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',5326.07,NULL,NULL,1,'2022-04-21 12:10:54','2022-04-21 12:10:54',NULL),(3247,3022,41024,175563,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',14500.00,NULL,NULL,1,'2022-04-21 12:10:54','2022-04-21 12:10:54',NULL),(3248,3022,41024,175563,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',14800.00,NULL,NULL,1,'2022-04-21 12:10:54','2022-04-21 12:10:54',NULL),(3249,3022,41024,175563,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',1599.00,NULL,NULL,1,'2022-04-21 12:10:54','2022-04-21 12:10:54',NULL),(3250,3022,41024,175563,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',2499.00,NULL,NULL,1,'2022-04-21 12:10:54','2022-04-21 12:10:54',NULL),(3251,3022,41024,175563,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',28235.36,NULL,NULL,1,'2022-04-21 12:10:54','2022-04-21 12:10:54',NULL),(3252,3022,41024,175563,3,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',28235.36,NULL,NULL,1,'2022-04-21 12:10:54','2022-04-21 12:10:54',NULL),(3253,3022,41024,175563,3,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',12719.45,NULL,NULL,1,'2022-04-21 12:10:54','2022-04-21 12:10:54',NULL),(3254,3022,41024,175563,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',4235.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3255,3022,41024,175563,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',3327.50,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3256,3022,41024,175563,2,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',2722.50,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3257,3022,41024,175563,2,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',10285.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3258,3022,41024,175563,2,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',4235.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3259,3022,41024,175563,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',4114.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3260,3022,41024,175563,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',32222.30,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL);
INSERT INTO `balance_libro` VALUES (3261,3022,41024,175563,2,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',800.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3262,3022,41024,175563,2,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',2904.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3263,3022,41024,175563,2,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1815.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3264,3022,41024,175563,2,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',2057.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3265,3022,41024,175563,2,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1996.50,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3266,3022,41024,175563,2,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',847.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3267,3022,41024,175563,2,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1028.50,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3268,3022,41024,175563,2,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',27563.80,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3269,3022,41024,175563,2,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',11616.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3270,3022,41024,175563,2,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',2904.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3271,3022,41024,175563,2,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',907.50,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3272,3022,41024,175563,2,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',17787.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3273,3022,41024,175563,2,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',3388.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3274,3022,41024,175563,2,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',2783.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3275,3022,41024,175563,2,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',847.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3276,3022,41024,175563,2,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',6751.80,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3277,3022,41024,175563,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',10890.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3278,3022,41024,175563,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',800.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3279,3022,41024,175563,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',847.00,NULL,NULL,1,'2022-04-22 09:30:08','2022-04-22 09:30:08',NULL),(3280,3022,41024,175563,2,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',907.50,NULL,NULL,1,'2022-04-22 09:30:09','2022-04-22 09:30:09',NULL),(3281,3022,41024,175563,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',7320.50,NULL,NULL,1,'2022-04-22 09:30:09','2022-04-22 09:30:09',NULL);
INSERT INTO `balance_libro` VALUES (3282,3022,41024,175563,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',968.00,NULL,NULL,1,'2022-04-22 09:30:09','2022-04-22 09:30:09',NULL),(3283,3022,41024,175563,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',7320.50,NULL,NULL,1,'2022-04-22 09:30:09','2022-04-22 09:30:09',NULL),(3284,3022,40819,151529,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',217000.00,NULL,NULL,1,'2022-04-26 11:11:41','2022-04-26 11:31:48','2022-04-26 11:31:48'),(3285,3022,40819,151529,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',168795.00,NULL,NULL,1,'2022-04-26 11:11:41','2022-04-26 11:11:41',NULL),(3286,3022,40819,151529,2,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',30008.00,NULL,NULL,1,'2022-04-26 11:11:41','2022-04-26 11:11:41',NULL),(3287,3022,40819,151529,2,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',76415.86,NULL,NULL,1,'2022-04-26 11:11:41','2022-04-26 11:11:41',NULL),(3288,3022,40819,151529,2,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',38000.00,NULL,NULL,1,'2022-04-26 11:11:41','2022-04-26 11:11:41',NULL),(3289,3022,40819,151529,2,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',39415.86,NULL,NULL,1,'2022-04-26 11:11:42','2022-04-26 11:11:42',NULL),(3290,3022,40819,151529,2,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',39000.00,NULL,NULL,1,'2022-04-26 11:11:42','2022-04-26 11:11:42',NULL),(3291,3022,40819,151529,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',38415.86,NULL,NULL,1,'2022-04-26 11:11:42','2022-04-26 11:11:42',NULL),(3292,3022,40819,151529,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',76415.86,NULL,NULL,1,'2022-04-26 11:11:42','2022-04-26 11:11:42',NULL),(3293,3022,40819,151529,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',38415.86,NULL,NULL,1,'2022-04-26 11:11:42','2022-04-26 11:11:42',NULL),(3294,3022,40819,151529,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',38000.00,NULL,NULL,1,'2022-04-26 11:11:42','2022-04-26 11:11:42',NULL),(3295,3022,40819,151529,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',78415.86,NULL,NULL,1,'2022-04-26 11:11:42','2022-04-26 11:11:42',NULL),(3296,3022,40819,151529,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',217000.19,NULL,NULL,1,'2022-04-26 11:36:02','2022-04-26 11:36:02',NULL),(3297,3022,41024,175561,3,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1460.00,NULL,NULL,1,'2022-04-28 10:14:29','2022-04-28 10:14:29',NULL),(3298,3022,41024,175562,3,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',11218.33,NULL,NULL,1,'2022-04-28 11:10:23','2022-04-28 11:10:23',NULL),(3299,3022,41024,175562,3,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',7900.00,NULL,NULL,1,'2022-04-28 11:15:26','2022-04-28 11:15:26',NULL),(3300,3022,41024,175562,3,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',4479.99,NULL,NULL,1,'2022-04-28 11:17:48','2022-04-28 11:17:48',NULL),(3301,3022,41024,175562,3,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',12595.66,NULL,NULL,1,'2022-04-28 11:19:36','2022-04-28 11:19:36',NULL);
INSERT INTO `balance_libro` VALUES (3302,3022,40819,151529,3,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',5562.50,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3303,3022,40819,151529,3,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',29720.27,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3304,3022,40819,151529,3,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',11979.00,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3305,3022,40819,151529,3,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',39000.00,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3306,3022,40819,151529,3,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',3550.00,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3307,3022,40819,151529,3,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',17950.00,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3308,3022,40819,151529,3,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',17950.00,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3309,3022,40819,151529,3,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',10000.00,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3310,3022,40819,151529,3,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',10800.00,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3311,3022,40819,151529,3,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',35215.16,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3312,3022,40819,151529,3,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',8021.09,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3313,3022,40819,151529,3,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1540.00,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3314,3022,40819,151529,3,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1623.68,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3315,3022,40819,151529,3,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',6671.45,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3316,3022,40819,151529,3,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3750.00,NULL,NULL,1,'2022-04-29 10:07:18','2022-04-29 10:07:18',NULL),(3317,3022,40819,151529,3,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',77681.78,NULL,NULL,1,'2022-04-29 11:25:09','2022-04-29 11:25:09',NULL),(3318,3022,40819,151529,3,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',87117.00,NULL,NULL,1,'2022-04-29 11:26:33','2022-04-29 11:26:33',NULL),(3319,3022,40819,151529,3,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1323.89,NULL,NULL,1,'2022-04-29 11:28:03','2022-04-29 11:28:03',NULL),(3320,3022,40819,151529,3,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1985.83,NULL,NULL,1,'2022-04-29 11:29:43','2022-04-29 11:29:43',NULL),(3321,3022,40819,151529,3,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',5022.67,NULL,NULL,1,'2022-04-29 11:37:37','2022-04-29 11:37:37',NULL);
INSERT INTO `balance_libro` VALUES (3322,3022,40819,151529,3,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',4832.26,NULL,NULL,1,'2022-04-29 11:38:38','2022-04-29 11:38:38',NULL),(3323,3022,40819,151529,3,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',7909.19,NULL,NULL,1,'2022-04-29 11:42:57','2022-04-29 11:42:57',NULL),(3324,3022,40819,151529,3,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1643.91,NULL,NULL,1,'2022-04-29 11:50:15','2022-04-29 11:50:15',NULL),(3325,3022,40819,151529,3,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',86499.65,NULL,NULL,1,'2022-04-29 11:52:06','2022-04-29 11:52:06',NULL),(3326,3022,41024,175564,3,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',500.01,NULL,NULL,1,'2022-05-02 11:51:52','2022-05-02 11:51:52',NULL),(3327,3022,41024,175564,3,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',8600.05,NULL,NULL,1,'2022-05-02 11:58:11','2022-05-02 11:58:11',NULL),(3328,3022,41024,175564,3,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',3079.99,NULL,NULL,1,'2022-05-02 12:00:44','2022-05-02 12:00:44',NULL),(3329,3022,41024,175564,3,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',19582.49,NULL,NULL,1,'2022-05-03 09:04:20','2022-05-03 09:04:20',NULL),(3330,3022,40817,148499,3,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',89110.24,NULL,NULL,1,'2022-05-03 09:53:14','2022-05-03 09:53:14',NULL),(3331,3022,40817,148499,3,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',34050.04,NULL,NULL,1,'2022-05-03 09:55:05','2022-05-03 09:55:05',NULL),(3332,3022,40817,148499,3,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',43241.31,NULL,NULL,1,'2022-05-03 09:58:49','2022-05-03 09:58:49',NULL),(3333,3022,40817,148499,3,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',8855.28,NULL,NULL,1,'2022-05-03 10:00:56','2022-05-03 10:00:56',NULL),(3334,3022,40817,148499,3,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',28091.76,NULL,NULL,1,'2022-05-03 10:02:56','2022-05-03 10:02:56',NULL),(3335,3022,40817,148499,3,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',5181.20,NULL,NULL,1,'2022-05-03 10:03:51','2022-05-03 10:03:51',NULL),(3336,3022,40720,1545,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',16870.00,NULL,NULL,1,'2022-05-09 11:04:51','2022-05-09 11:04:51',NULL),(3337,3022,40720,1545,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',26082.88,NULL,NULL,1,'2022-05-09 11:06:49','2022-05-09 11:06:49',NULL),(3338,3022,40720,1545,2,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',21852.77,NULL,NULL,1,'2022-05-09 11:08:31','2022-05-09 11:08:31',NULL),(3339,3022,40720,1545,2,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',16498.01,NULL,NULL,1,'2022-05-09 11:10:12','2022-05-09 11:10:12',NULL),(3340,3022,40720,1545,2,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',14015.00,NULL,NULL,1,'2022-05-09 11:11:25','2022-05-09 11:11:25',NULL),(3341,3022,40720,1545,2,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',10083.97,NULL,NULL,1,'2022-05-09 11:12:27','2022-05-09 11:12:27',NULL),(3342,3022,40720,1545,2,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',15733.67,NULL,NULL,1,'2022-05-09 11:13:39','2022-05-09 11:13:39',NULL);
INSERT INTO `balance_libro` VALUES (3343,3022,40720,1545,2,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',28152.51,NULL,NULL,1,'2022-05-09 11:15:01','2022-05-09 11:15:01',NULL),(3344,3022,40720,1545,2,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',14034.00,NULL,NULL,1,'2022-05-09 11:15:57','2022-05-09 11:15:57',NULL),(3345,3022,40720,1545,2,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',26128.10,NULL,NULL,1,'2022-05-09 11:17:40','2022-05-09 11:17:40',NULL),(3346,3022,40720,1545,2,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',20661.95,NULL,NULL,1,'2022-05-09 11:19:09','2022-05-09 11:19:09',NULL),(3347,3022,40720,1545,2,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',27057.02,NULL,NULL,1,'2022-05-09 11:20:22','2022-05-09 11:20:22',NULL),(3348,3022,40720,1545,2,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',0.01,NULL,NULL,1,'2022-05-09 11:21:10','2022-05-09 11:21:10',NULL),(3349,3022,40720,1545,2,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',12056.00,NULL,NULL,1,'2022-05-09 11:22:51','2022-05-09 11:22:51',NULL),(3350,3022,40720,1545,2,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',23429.13,NULL,NULL,1,'2022-05-09 11:23:37','2022-05-09 11:23:37',NULL),(3351,3022,40720,1545,2,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',27445.00,NULL,NULL,1,'2022-05-09 11:24:52','2022-05-09 11:24:52',NULL),(3352,3022,40720,1545,2,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',26679.78,NULL,NULL,1,'2022-05-09 11:25:56','2022-05-09 11:25:56',NULL),(3353,3022,40720,1545,2,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',28108.07,NULL,NULL,1,'2022-05-09 11:26:54','2022-05-09 11:26:54',NULL),(3354,3022,40720,1545,2,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',26836.12,NULL,NULL,1,'2022-05-09 11:27:45','2022-05-09 11:27:45',NULL),(3355,3022,40720,1545,2,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',32247.07,NULL,NULL,1,'2022-05-09 11:29:36','2022-05-09 11:29:36',NULL),(3356,3022,40720,1545,2,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',0.01,NULL,NULL,1,'2022-05-09 11:30:04','2022-05-09 11:30:04',NULL),(3357,3022,40720,1545,2,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',22046.00,NULL,NULL,1,'2022-05-09 11:31:02','2022-05-09 11:31:02',NULL),(3358,3022,40720,1545,2,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',33235.00,NULL,NULL,1,'2022-05-09 11:32:05','2022-05-09 11:32:05',NULL),(3359,3022,40720,1545,2,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',21167.31,NULL,NULL,1,'2022-05-09 11:32:41','2022-05-09 11:32:56','2022-05-09 11:32:56'),(3360,3022,40720,1545,2,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',21167.31,NULL,NULL,1,'2022-05-09 11:32:56','2022-05-09 11:32:56',NULL),(3361,3022,40720,1545,3,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3755.28,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3362,3022,40720,1545,3,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',405.01,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3363,3022,40720,1545,3,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',3072.45,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL);
INSERT INTO `balance_libro` VALUES (3364,3022,40720,1545,3,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',3581.52,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3365,3022,40720,1545,3,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',2229.96,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3366,3022,40720,1545,3,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',7724.55,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3367,3022,40720,1545,3,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',66521.00,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3368,3022,40720,1545,3,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',4485.77,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3369,3022,40720,1545,3,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',246.28,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3370,3022,40720,1545,3,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2062.68,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3371,3022,40720,1545,3,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',3972.73,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3372,3022,40720,1545,3,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',5321.26,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3373,3022,40720,1545,3,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',305.00,NULL,NULL,1,'2022-05-11 09:54:18','2022-05-11 09:54:18',NULL),(3374,3022,40720,1545,3,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',4303.69,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3375,3022,40720,1545,3,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',8282.01,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3376,3022,40720,1545,3,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',2090.68,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3377,3022,40720,1545,3,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',3072.24,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3378,3022,40720,1545,3,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',44088.66,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3379,3022,40720,1545,3,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',88593.24,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3380,3022,40720,1545,3,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1005.67,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3381,3022,40720,1545,3,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',4615.35,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3382,3022,40720,1545,3,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',4196.72,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3383,3022,40720,1545,3,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',3796.68,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3384,3022,40720,1545,3,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',15411.54,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL);
INSERT INTO `balance_libro` VALUES (3385,3022,40720,1545,3,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',5648.75,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3386,3022,40720,1545,3,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',7512.48,NULL,NULL,1,'2022-05-11 09:54:19','2022-05-11 09:54:19',NULL),(3387,3022,40720,1545,3,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',7520.23,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3388,3022,40720,1545,3,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',3136.19,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3389,3022,40720,1545,3,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',93983.70,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3390,3022,40720,1545,3,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',4832.67,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3391,3022,40720,1545,3,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',9128.54,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3392,3022,40720,1545,3,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',470.24,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3393,3022,40720,1545,3,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',2472.81,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3394,3022,40720,1545,3,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',7923.08,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3395,3022,40720,1545,3,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1172.96,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3396,3022,40720,1545,3,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',4251.67,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3397,3022,40720,1545,3,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',13843.22,NULL,NULL,1,'2022-05-11 09:54:20','2022-05-11 09:54:20',NULL),(3398,3022,40720,1545,3,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',6319.76,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3399,3022,40720,1545,3,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',4235.74,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3400,3022,40720,1545,3,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',4721.93,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3401,3022,40720,1545,3,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1500.00,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3402,3022,40720,1545,3,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',688.81,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3403,3022,40720,1545,3,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',7609.49,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3404,3022,40720,1545,3,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',3001.19,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3405,3022,40720,1545,3,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',6158.77,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL);
INSERT INTO `balance_libro` VALUES (3406,3022,40720,1545,3,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',6158.77,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3407,3022,40720,1545,3,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1985.60,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3408,3022,40720,1545,3,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',12452.60,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3409,3022,40720,1545,3,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',5407.11,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3410,3022,40720,1545,3,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',630.00,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3411,3022,40720,1545,3,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',911.23,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3412,3022,40720,1545,3,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',15508.07,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3413,3022,40720,1545,3,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',5244.88,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3414,3022,40720,1545,3,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',4117.50,NULL,NULL,1,'2022-05-11 09:54:21','2022-05-11 09:54:21',NULL),(3415,3022,40720,1545,2,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',0.01,NULL,NULL,1,'2022-05-11 10:57:52','2022-05-11 10:57:52',NULL),(3416,3022,40720,1545,3,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',16385.32,NULL,NULL,1,'2022-05-12 10:33:36','2022-05-12 10:33:36',NULL),(3417,3022,40720,1545,3,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',14878.84,NULL,NULL,1,'2022-05-12 10:38:20','2022-05-12 10:38:20',NULL),(3418,3022,40720,1545,3,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',17114.26,NULL,NULL,1,'2022-05-12 10:43:38','2022-05-12 10:43:38',NULL),(3419,3022,40939,173436,3,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',6999.75,NULL,NULL,1,'2022-05-12 12:59:32','2022-05-12 12:59:32',NULL),(3420,3022,40939,173436,3,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',5002.40,NULL,NULL,1,'2022-05-12 13:00:59','2022-05-12 13:00:59',NULL),(3421,3022,40939,173436,3,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',8801.52,NULL,NULL,1,'2022-05-12 13:03:04','2022-05-12 13:03:04',NULL),(3422,3022,40939,173436,3,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1080.00,NULL,NULL,1,'2022-05-12 13:09:34','2022-05-12 13:09:34',NULL),(3423,3022,40939,173436,3,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',3000.00,NULL,NULL,1,'2022-05-12 13:10:40','2022-05-12 13:10:40',NULL),(3424,3022,40939,173436,3,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',5000.05,NULL,NULL,1,'2022-05-12 13:14:16','2022-05-12 13:14:16',NULL),(3425,3022,40939,173436,3,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',8000.00,NULL,NULL,1,'2022-05-12 13:15:54','2022-05-12 13:15:54',NULL),(3426,3022,40939,173436,3,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',5999.94,NULL,NULL,1,'2022-05-12 13:17:19','2022-05-12 13:17:34','2022-05-12 13:17:34');
INSERT INTO `balance_libro` VALUES (3427,3022,40939,173436,3,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',5999.94,NULL,NULL,1,'2022-05-12 13:17:34','2022-05-12 13:17:34',NULL),(3428,3022,40939,173436,3,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',5000.05,NULL,NULL,1,'2022-05-12 13:20:52','2022-05-12 13:20:52',NULL),(3429,3022,40819,151530,3,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1441.84,NULL,NULL,1,'2022-05-13 09:21:41','2022-05-13 09:21:41',NULL),(3430,3022,40819,151530,3,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',26810.21,NULL,NULL,1,'2022-05-13 09:22:21','2022-05-13 09:22:51','2022-05-13 09:22:51'),(3431,3022,40819,151530,3,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',26810.21,NULL,NULL,1,'2022-05-13 09:22:51','2022-05-13 09:22:51',NULL),(3432,3022,40939,173436,3,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',5000.05,NULL,NULL,1,'2022-05-13 10:42:39','2022-05-13 10:43:06','2022-05-13 10:43:06'),(3433,3022,40819,151530,3,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',2800.00,NULL,NULL,1,'2022-05-13 10:42:43','2022-05-13 10:42:43',NULL),(3434,3022,40819,151530,3,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',144000.00,NULL,NULL,1,'2022-05-13 10:42:43','2022-05-13 10:42:43',NULL),(3435,3022,40819,151530,3,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',38400.00,NULL,NULL,1,'2022-05-13 10:42:43','2022-05-13 10:42:43',NULL),(3436,3022,40819,151530,3,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',21236.41,NULL,NULL,1,'2022-05-13 10:42:43','2022-05-13 10:42:43',NULL),(3437,3022,40819,151530,3,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',6983.20,NULL,NULL,1,'2022-05-13 10:42:43','2022-05-13 10:42:43',NULL),(3438,3022,40819,151530,3,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',11380.94,NULL,NULL,1,'2022-05-13 10:42:43','2022-05-13 10:42:43',NULL),(3439,3022,40819,151530,3,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',3750.00,NULL,NULL,1,'2022-05-13 10:42:43','2022-05-13 10:42:43',NULL),(3440,3022,40939,173436,3,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',5000.05,NULL,NULL,1,'2022-05-13 10:43:06','2022-05-13 10:43:06',NULL),(3441,3022,40939,173436,3,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',5859.59,NULL,NULL,1,'2022-05-13 10:45:54','2022-05-13 10:45:54',NULL),(3442,3022,40939,173436,3,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1080.00,NULL,NULL,1,'2022-05-13 10:46:34','2022-05-13 10:46:34',NULL),(3443,3022,40939,173436,3,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',3999.94,NULL,NULL,1,'2022-05-13 10:47:40','2022-05-13 10:47:40',NULL),(3444,3022,40939,173436,3,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',5000.05,NULL,NULL,1,'2022-05-13 10:48:37','2022-05-13 10:48:37',NULL),(3445,3022,40939,173436,3,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1080.00,NULL,NULL,1,'2022-05-13 10:49:25','2022-05-13 10:49:25',NULL),(3446,3022,40939,173436,3,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',8700.62,NULL,NULL,1,'2022-05-13 10:50:03','2022-05-13 10:50:03',NULL);
INSERT INTO `balance_libro` VALUES (3447,3022,40939,173436,3,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',5000.05,NULL,NULL,1,'2022-05-13 10:55:05','2022-05-13 10:55:05',NULL),(3448,3022,40939,173436,3,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',5500.04,NULL,NULL,1,'2022-05-13 10:56:13','2022-05-13 10:56:13',NULL),(3449,3022,40939,173436,3,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',600.00,NULL,NULL,1,'2022-05-13 10:56:47','2022-05-13 10:56:47',NULL),(3450,3022,40939,173436,3,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',730.01,NULL,NULL,1,'2022-05-13 10:57:27','2022-05-13 10:57:27',NULL),(3451,3022,40939,173436,3,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',1200.01,NULL,NULL,1,'2022-05-13 10:57:53','2022-05-13 10:57:53',NULL),(3452,3022,40939,173436,3,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',5000.05,NULL,NULL,1,'2022-05-13 10:58:41','2022-05-13 10:58:41',NULL),(3453,3022,40939,173436,3,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',7999.47,NULL,NULL,1,'2022-05-13 10:59:26','2022-05-13 10:59:26',NULL),(3454,3022,40939,173436,3,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',5000.05,NULL,NULL,1,'2022-05-13 11:00:43','2022-05-13 11:00:43',NULL),(3455,3022,40939,173436,3,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',4999.61,NULL,NULL,1,'2022-05-13 11:10:42','2022-05-13 11:10:42',NULL),(3456,3022,40939,173436,3,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',5001.69,NULL,NULL,1,'2022-05-13 11:11:09','2022-05-13 11:11:09',NULL),(3457,3022,40939,173436,3,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',32650.00,NULL,NULL,1,'2022-05-13 11:12:06','2022-05-13 11:12:06',NULL),(3458,3022,40939,173436,3,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',5000.05,NULL,NULL,1,'2022-05-13 11:13:03','2022-05-13 11:13:03',NULL),(3459,3022,40939,173436,3,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',5800.11,NULL,NULL,1,'2022-05-13 11:13:49','2022-05-13 11:13:49',NULL),(3460,3022,40939,173436,3,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',9999.90,NULL,NULL,1,'2022-05-13 11:14:26','2022-05-13 11:14:26',NULL),(3461,3022,40939,173436,3,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',5000.99,NULL,NULL,1,'2022-05-13 11:14:58','2022-05-13 11:14:58',NULL),(3462,3022,40939,173436,3,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',9000.91,NULL,NULL,1,'2022-05-13 11:19:59','2022-05-13 11:19:59',NULL),(3463,3022,40819,151530,2,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',3496.90,NULL,NULL,1,'2022-05-13 11:42:47','2022-05-13 11:42:47',NULL),(3464,3022,40819,151530,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',3484.80,NULL,NULL,1,'2022-05-13 11:42:47','2022-05-13 11:42:47',NULL),(3465,3022,41024,175564,3,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1000.00,NULL,NULL,1,'2022-05-17 09:16:54','2022-05-17 09:19:14','2022-05-17 09:19:14'),(3466,3022,41024,175564,3,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',500.01,NULL,NULL,1,'2022-05-17 09:18:37','2022-05-17 09:18:37',NULL);
INSERT INTO `balance_libro` VALUES (3467,3022,41024,175564,3,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1000.00,NULL,NULL,1,'2022-05-17 09:19:14','2022-05-17 09:19:14',NULL),(3468,3022,41024,175564,3,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',29579.01,NULL,NULL,1,'2022-05-17 09:38:41','2022-05-17 09:38:41',NULL),(3469,3022,41024,175564,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',579.99,NULL,NULL,1,'2022-05-17 09:42:31','2022-05-18 12:15:44','2022-05-18 12:15:44'),(3470,3022,41024,175564,3,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',2696.17,NULL,NULL,1,'2022-05-17 09:45:34','2022-05-17 09:45:34',NULL),(3471,3022,41024,175564,3,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',999.99,NULL,NULL,1,'2022-05-17 09:57:34','2022-05-17 09:57:34',NULL),(3472,3022,41024,175564,3,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',113.20,NULL,NULL,1,'2022-05-17 10:05:08','2022-05-17 10:05:08',NULL),(3473,3022,41024,175564,3,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1020.64,NULL,NULL,1,'2022-05-17 10:08:42','2022-05-17 10:08:42',NULL),(3474,3022,41024,175564,3,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',2499.00,NULL,NULL,1,'2022-05-17 10:47:59','2022-05-17 10:47:59',NULL),(3475,3022,41024,175564,3,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',2000.03,NULL,NULL,1,'2022-05-17 10:47:59','2022-05-17 10:47:59',NULL),(3476,3022,41024,175564,3,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',500.02,NULL,NULL,1,'2022-05-17 10:47:59','2022-05-17 10:47:59',NULL),(3477,3022,41024,175564,3,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',33422.32,NULL,NULL,1,'2022-05-17 10:47:59','2022-05-17 10:47:59',NULL),(3478,3022,41024,175564,3,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',2000.00,NULL,NULL,1,'2022-05-17 10:47:59','2022-05-17 10:47:59',NULL),(3479,3022,41024,175564,3,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',90750.00,NULL,NULL,1,'2022-05-17 10:47:59','2022-05-17 10:47:59',NULL),(3480,3022,41024,175564,3,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',4840.02,NULL,NULL,1,'2022-05-17 10:47:59','2022-05-17 10:47:59',NULL),(3481,3022,41024,175564,3,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',17000.00,NULL,NULL,1,'2022-05-17 10:47:59','2022-05-17 10:47:59',NULL),(3482,3022,41024,175564,3,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',6450.48,NULL,NULL,1,'2022-05-17 10:47:59','2022-05-23 09:58:22','2022-05-23 09:58:22'),(3483,3022,41024,175564,3,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',2355.49,NULL,NULL,1,'2022-05-17 10:48:00','2022-05-17 10:48:00',NULL),(3484,3022,41024,175564,3,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',5935.48,NULL,NULL,1,'2022-05-17 10:48:00','2022-05-17 10:48:00',NULL),(3485,3022,41024,175564,3,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',950.47,NULL,NULL,1,'2022-05-17 10:48:00','2022-05-17 10:48:00',NULL),(3486,3022,41024,175564,3,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',3105.00,NULL,NULL,1,'2022-05-17 10:48:00','2022-05-17 10:48:00',NULL);
INSERT INTO `balance_libro` VALUES (3487,3022,41024,175564,3,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',42500.00,NULL,NULL,1,'2022-05-17 10:48:00','2022-05-17 10:48:00',NULL),(3488,3022,41024,175564,3,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',4849.99,NULL,NULL,1,'2022-05-17 10:48:00','2022-05-17 10:48:00',NULL),(3489,3022,41024,175564,3,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',12266.17,NULL,NULL,1,'2022-05-17 10:48:00','2022-05-17 10:48:00',NULL),(3490,3022,41024,175564,3,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1592.02,NULL,NULL,1,'2022-05-17 10:48:00','2022-05-17 10:48:00',NULL),(3491,3022,41024,175564,2,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',2141.70,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3492,3022,41024,175564,2,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',4658.50,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3493,3022,41024,175564,2,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',145744.50,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3494,3022,41024,175564,2,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3993.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3495,3022,41024,175564,2,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',9438.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3496,3022,41024,175564,2,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',6171.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3497,3022,41024,175564,2,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',968.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3498,3022,41024,175564,2,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1815.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3499,3022,41024,175564,2,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',1815.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3500,3022,41024,175564,2,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',15173.40,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3501,3022,41024,175564,2,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2783.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3502,3022,41024,175564,2,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',6534.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3503,3022,41024,175564,2,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',8639.40,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3504,3022,41024,175564,2,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1694.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3505,3022,41024,175564,2,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',15173.40,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3506,3022,41024,175564,2,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',7260.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL);
INSERT INTO `balance_libro` VALUES (3507,3022,41024,175564,2,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1996.50,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3508,3022,41024,175564,2,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',5445.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3509,3022,41024,175564,2,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',6171.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3510,3022,41024,175564,2,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',968.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3511,3022,41024,175564,2,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',19493.10,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3512,3022,41024,175564,2,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',8349.00,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3513,3022,41024,175564,2,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',6630.80,NULL,NULL,1,'2022-05-17 11:55:43','2022-05-17 11:55:43',NULL),(3514,3022,41024,175564,2,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',968.00,NULL,NULL,1,'2022-05-17 11:55:44','2022-05-17 11:55:44',NULL),(3515,3022,41024,175564,2,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',53687.70,NULL,NULL,1,'2022-05-17 11:55:44','2022-05-17 11:55:44',NULL),(3516,3022,41024,175564,2,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',968.00,NULL,NULL,1,'2022-05-17 11:55:44','2022-05-17 11:55:44',NULL),(3517,3022,41024,175564,2,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4114.00,NULL,NULL,1,'2022-05-17 11:55:44','2022-05-17 11:55:44',NULL),(3518,3022,41024,175564,2,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',9498.50,NULL,NULL,1,'2022-05-17 11:55:44','2022-05-17 11:55:44',NULL),(3519,3022,41024,175564,2,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1936.00,NULL,NULL,1,'2022-05-17 11:55:44','2022-05-17 11:55:44',NULL),(3520,3022,41024,175564,2,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',968.00,NULL,NULL,1,'2022-05-17 11:55:44','2022-05-17 11:55:44',NULL),(3521,3022,41024,175564,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',579.99,NULL,NULL,1,'2022-05-18 12:15:44','2022-05-18 12:16:44','2022-05-18 12:16:44'),(3522,3022,41024,175564,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',579.99,NULL,NULL,1,'2022-05-18 12:16:44','2022-05-18 12:16:44',NULL),(3523,3022,40939,173436,3,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',31861.00,NULL,NULL,1,'2022-05-19 10:56:47','2022-05-19 10:56:47',NULL),(3524,3022,40939,173436,3,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',5618.00,NULL,NULL,1,'2022-05-19 10:56:47','2022-05-19 10:56:47',NULL),(3525,3022,40939,173436,3,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',2450.00,NULL,NULL,1,'2022-05-19 10:56:47','2022-05-19 10:56:47',NULL),(3526,3022,40939,173436,3,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',2700.01,NULL,NULL,1,'2022-05-19 10:56:47','2022-05-19 10:56:47',NULL);
INSERT INTO `balance_libro` VALUES (3527,3022,40939,173436,3,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',55800.00,NULL,NULL,1,'2022-05-19 10:56:47','2022-05-19 10:56:47',NULL),(3528,3022,40939,173436,3,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',330.00,NULL,NULL,1,'2022-05-19 10:56:47','2022-05-19 10:56:47',NULL),(3529,3022,40939,173436,2,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',215726.94,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3530,3022,40939,173436,2,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',215726.94,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3531,3022,40939,173436,2,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',76138.92,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3532,3022,40939,173436,2,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',253796.40,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3533,3022,40939,173436,2,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',259199.85,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3534,3022,40939,173436,2,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',259199.85,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3535,3022,40939,173436,2,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',259199.85,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3536,3022,40939,173436,2,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',402297.35,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3537,3022,40939,173436,2,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',182590.20,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3538,3022,40939,173436,2,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',116638.28,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3539,3022,40939,173436,2,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',116638.28,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3540,3022,40939,173436,2,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',116638.28,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3541,3022,40939,173436,2,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',116638.28,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3542,3022,40939,173436,2,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',116638.28,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3543,3022,40939,173436,2,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',116638.28,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3544,3022,40939,173436,2,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',116638.28,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3545,3022,40939,173436,2,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',116638.28,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3546,3022,40939,173436,2,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',116638.28,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL);
INSERT INTO `balance_libro` VALUES (3547,3022,40939,173436,2,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',614942.44,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3548,3022,40939,173436,2,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',306176.71,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3549,3022,40939,173436,2,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',121771.00,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3550,3022,40939,173436,2,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',269995.70,NULL,NULL,1,'2022-05-19 11:20:12','2022-05-19 11:20:12',NULL),(3551,3022,40939,173436,2,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',134997.85,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3552,3022,40939,173436,2,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',134997.85,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3553,3022,40939,173436,2,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',134997.85,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3554,3022,40939,173436,2,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',134997.85,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3555,3022,40939,173436,2,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',218700.50,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3556,3022,40939,173436,2,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',72900.16,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3557,3022,40939,173436,2,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',243000.55,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3558,3022,40939,173436,2,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',170100.38,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3559,3022,40939,173436,2,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',121500.28,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3560,3022,40939,173436,2,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',121500.28,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3561,3022,40939,173436,2,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',57239.00,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3562,3022,40939,173436,2,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',468741.00,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3563,3022,40939,173436,2,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',85858.50,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3564,3022,40939,173436,2,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',57239.00,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3565,3022,40939,173436,2,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',143097.50,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3566,3022,40939,173436,2,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',143097.50,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL);
INSERT INTO `balance_libro` VALUES (3567,3022,40939,173436,2,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',77272.65,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3568,3022,40939,173436,2,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',128787.75,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3569,3022,40939,173436,2,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',180302.85,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3570,3022,40939,173436,2,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',66969.63,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3571,3022,40939,173436,2,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',66969.63,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3572,3022,40939,173436,2,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',66969.63,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3573,3022,40939,173436,2,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',66969.63,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3574,3022,40939,173436,2,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',66969.63,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3575,3022,40939,173436,2,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',91295.10,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3576,3022,40939,173436,2,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',60885.50,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3577,3022,40939,173436,2,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',406087.50,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3578,3022,40939,173436,2,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',182590.20,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3579,3022,40939,173436,2,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',121771.00,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3580,3022,40939,173436,2,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',468741.00,NULL,NULL,1,'2022-05-19 11:20:13','2022-05-19 11:20:13',NULL),(3581,3022,41024,175564,3,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',6450.48,NULL,NULL,1,'2022-05-23 09:58:22','2022-05-23 10:01:52','2022-05-23 10:01:52'),(3582,3022,41024,175564,3,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',6450.48,NULL,NULL,1,'2022-05-23 10:01:52','2022-05-23 10:01:52',NULL),(3583,3022,40939,173436,3,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',704988.90,NULL,NULL,1,'2022-05-23 10:28:12','2022-05-23 10:28:12',NULL),(3584,3022,40939,173436,3,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2968888.59,NULL,NULL,1,'2022-05-23 10:30:29','2022-05-23 10:30:29',NULL),(3585,3022,40939,173436,3,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3211164.26,NULL,NULL,1,'2022-05-23 10:32:59','2022-05-23 10:32:59',NULL),(3586,3022,41024,175565,3,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1500.00,NULL,NULL,1,'2022-05-24 11:39:08','2022-05-24 11:39:08',NULL);
INSERT INTO `balance_libro` VALUES (3587,3022,41024,175565,3,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1755.00,NULL,NULL,1,'2022-05-24 11:42:27','2022-05-24 11:42:27',NULL),(3588,3022,40939,173437,3,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',6015.92,NULL,NULL,1,'2022-06-03 10:53:16','2022-06-03 10:53:16',NULL),(3589,3022,40939,173437,3,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',4999.61,NULL,NULL,1,'2022-06-03 10:54:26','2022-06-03 10:54:26',NULL),(3590,3022,40939,173437,3,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',5000.05,NULL,NULL,1,'2022-06-03 10:55:25','2022-06-03 10:55:25',NULL),(3591,3022,40939,173437,3,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',2001.01,NULL,NULL,1,'2022-06-03 10:56:17','2022-06-03 10:56:17',NULL),(3592,3022,40939,173437,3,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',5999.94,NULL,NULL,1,'2022-06-03 10:59:24','2022-06-03 10:59:24',NULL),(3593,3022,40939,173437,3,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',10000.00,NULL,NULL,1,'2022-06-03 11:00:00','2022-06-03 11:00:00',NULL),(3594,3022,40939,173437,3,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',7219.18,NULL,NULL,1,'2022-06-03 11:01:20','2022-06-03 11:01:20',NULL),(3595,3022,40939,173437,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',7148.09,NULL,NULL,1,'2022-06-03 11:02:32','2022-06-03 11:02:32',NULL),(3596,3022,40939,173437,3,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',7420.35,NULL,NULL,1,'2022-06-03 11:03:37','2022-06-03 11:03:37',NULL),(3597,3022,40939,173437,3,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1320.00,NULL,NULL,1,'2022-06-03 11:04:43','2022-06-03 11:04:43',NULL),(3598,3022,40939,173437,3,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1320.00,NULL,NULL,1,'2022-06-03 11:05:11','2022-06-03 11:05:11',NULL),(3599,3022,40939,173437,3,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1320.00,NULL,NULL,1,'2022-06-03 11:05:39','2022-06-03 11:05:39',NULL),(3600,3022,40939,173437,3,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',660.01,NULL,NULL,1,'2022-06-03 11:06:04','2022-06-03 11:06:04',NULL),(3601,3022,40939,173437,3,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',6013.19,NULL,NULL,1,'2022-06-03 11:08:32','2022-06-03 11:08:32',NULL),(3602,3022,40939,173437,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',6013.19,NULL,NULL,1,'2022-06-03 11:10:45','2022-06-03 11:10:45',NULL),(3603,3022,40939,173437,3,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',6013.24,NULL,NULL,1,'2022-06-03 11:12:06','2022-06-03 11:12:06',NULL),(3604,3022,40939,173437,3,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',6013.24,NULL,NULL,1,'2022-06-03 11:12:57','2022-06-03 11:12:57',NULL),(3605,3022,40939,173437,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',6013.24,NULL,NULL,1,'2022-06-03 11:13:37','2022-06-03 11:13:37',NULL),(3606,3022,40939,173437,3,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',6013.19,NULL,NULL,1,'2022-06-03 11:14:26','2022-06-03 11:14:26',NULL),(3607,3022,40939,173437,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',6400.73,NULL,NULL,1,'2022-06-03 11:16:26','2022-06-03 11:16:26',NULL);
INSERT INTO `balance_libro` VALUES (3608,3022,40939,173437,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',7499.61,NULL,NULL,1,'2022-06-03 11:17:42','2022-06-03 11:17:42',NULL),(3609,3022,40939,173437,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',5000.05,NULL,NULL,1,'2022-06-03 11:19:34','2022-06-03 11:19:34',NULL),(3610,3022,40720,1546,2,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',17464.00,NULL,NULL,1,'2022-06-07 10:30:16','2022-06-07 10:30:16',NULL),(3611,3022,40720,1546,2,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',0.01,NULL,NULL,1,'2022-06-07 10:30:36','2022-06-07 10:30:36',NULL),(3612,3022,40720,1546,2,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',17781.44,NULL,NULL,1,'2022-06-07 10:31:43','2022-06-07 10:31:43',NULL),(3613,3022,40720,1546,2,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',5135.03,NULL,NULL,1,'2022-06-07 10:34:15','2022-06-07 10:34:15',NULL),(3614,3022,40720,1546,2,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',15065.99,NULL,NULL,1,'2022-06-07 10:35:31','2022-06-07 10:35:31',NULL),(3615,3022,40720,1546,2,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',16320.30,NULL,NULL,1,'2022-06-07 10:36:35','2022-06-07 10:36:35',NULL),(3616,3022,40720,1546,2,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',6558.98,NULL,NULL,1,'2022-06-07 10:37:32','2022-06-07 10:37:32',NULL),(3617,3022,40720,1546,2,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',0.01,NULL,NULL,1,'2022-06-07 10:37:47','2022-06-07 10:39:27','2022-06-07 10:39:27'),(3618,3022,40720,1546,2,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',24983.02,NULL,NULL,1,'2022-06-07 10:38:49','2022-06-07 10:38:49',NULL),(3619,3022,40720,1546,2,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',0.01,NULL,NULL,1,'2022-06-07 10:39:52','2022-06-07 10:39:52',NULL),(3620,3022,40720,1546,2,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',39438.06,NULL,NULL,1,'2022-06-07 10:43:29','2022-06-07 10:43:29',NULL),(3621,3022,40720,1546,2,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',22129.10,NULL,NULL,1,'2022-06-07 10:44:20','2022-06-07 10:44:20',NULL),(3622,3022,40720,1546,2,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',22715.98,NULL,NULL,1,'2022-06-07 10:45:05','2022-06-07 10:45:05',NULL),(3623,3022,40720,1546,2,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',30359.64,NULL,NULL,1,'2022-06-07 10:45:44','2022-06-07 10:45:44',NULL),(3624,3022,40720,1546,2,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',23593.97,NULL,NULL,1,'2022-06-07 10:46:29','2022-06-07 10:46:29',NULL),(3625,3022,40720,1546,2,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',11456.05,NULL,NULL,1,'2022-06-07 11:00:39','2022-06-07 11:00:39',NULL),(3626,3022,40720,1546,2,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-18','2022-05-18',19209.11,NULL,NULL,1,'2022-06-07 11:01:30','2022-06-07 11:01:30',NULL),(3627,3022,40720,1546,2,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',21371.99,NULL,NULL,1,'2022-06-07 11:02:03','2022-06-07 11:02:03',NULL),(3628,3022,40720,1546,2,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',12551.96,NULL,NULL,1,'2022-06-07 11:03:08','2022-06-07 11:03:08',NULL);
INSERT INTO `balance_libro` VALUES (3629,3022,40720,1546,2,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',21712.06,NULL,NULL,1,'2022-06-07 11:03:53','2022-06-07 11:03:53',NULL),(3630,3022,40720,1546,2,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',20432.00,NULL,NULL,1,'2022-06-07 11:04:41','2022-06-07 11:04:41',NULL),(3631,3022,40720,1546,2,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',15550.51,NULL,NULL,1,'2022-06-07 11:05:23','2022-06-07 11:05:23',NULL),(3632,3022,40720,1546,2,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',18180.10,NULL,NULL,1,'2022-06-07 11:06:05','2022-06-07 11:06:05',NULL),(3633,3022,40720,1546,2,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',21517.01,NULL,NULL,1,'2022-06-07 11:07:41','2022-06-07 11:07:41',NULL),(3634,3022,40720,1546,2,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',20539.00,NULL,NULL,1,'2022-06-07 11:08:24','2022-06-07 11:08:24',NULL),(3635,3022,40720,1546,2,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',25186.03,NULL,NULL,1,'2022-06-07 11:09:08','2022-06-07 11:09:08',NULL),(3636,3022,40939,173437,3,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',34347.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3637,3022,40939,173437,3,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',2700.01,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3638,3022,40939,173437,3,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',2450.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3639,3022,40939,173437,3,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',14999.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3640,3022,40939,173437,3,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',24999.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3641,3022,40939,173437,3,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',55800.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3642,3022,40939,173437,3,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',24650.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3643,3022,40939,173437,3,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',5048.10,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3644,3022,40939,173437,3,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1965.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3645,3022,40939,173437,3,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1822.49,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3646,3022,40939,173437,3,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',1613.99,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3647,3022,40939,173437,3,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',2364.99,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3648,3022,40939,173437,3,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',33000.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL),(3649,3022,40939,173437,3,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',8000.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-08 11:18:09',NULL);
INSERT INTO `balance_libro` VALUES (3650,3022,40939,173437,3,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',4399.00,NULL,NULL,1,'2022-06-08 11:18:09','2022-06-10 09:55:59','2022-06-10 09:55:59'),(3651,3022,40939,173437,3,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',3895641.03,NULL,NULL,1,'2022-06-13 09:57:24','2022-06-13 09:57:24',NULL),(3652,3022,40939,173437,3,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',3566051.58,NULL,NULL,1,'2022-06-13 09:59:34','2022-06-13 09:59:34',NULL),(3653,3022,40939,173437,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',66969.63,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3654,3022,40939,173437,2,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',66969.63,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3655,3022,40939,173437,2,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',143097.50,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3656,3022,40939,173437,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',160379.70,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3657,3022,40939,173437,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',267299.50,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3658,3022,40939,173437,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3659,3022,40939,173437,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3660,3022,40939,173437,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3661,3022,40939,173437,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3662,3022,40939,173437,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',297001.90,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3663,3022,40939,173437,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',297001.90,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3664,3022,40939,173437,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',297001.90,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3665,3022,40939,173437,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',360848.80,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3666,3022,40939,173437,2,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3667,3022,40939,173437,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3668,3022,40939,173437,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3669,3022,40939,173437,2,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL);
INSERT INTO `balance_libro` VALUES (3670,3022,40939,173437,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3671,3022,40939,173437,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',861303.30,NULL,NULL,1,'2022-06-20 21:51:34','2022-06-20 21:51:34',NULL),(3672,3022,40939,173437,2,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',317738.55,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3673,3022,40939,173437,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',74250.48,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3674,3022,40939,173437,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',74250.48,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3675,3022,40939,173437,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',148500.95,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3676,3022,40939,173437,2,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',148500.95,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3677,3022,40939,173437,2,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',148500.95,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3678,3022,40939,173437,2,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',148500.95,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3679,3022,40939,173437,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',148500.95,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3680,3022,40939,173437,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',400949.25,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3681,3022,40939,173437,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',267299.50,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3682,3022,40939,173437,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3683,3022,40939,173437,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',267299.50,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3684,3022,40939,173437,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3685,3022,40939,173437,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',133649.75,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3686,3022,40939,173437,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',187109.65,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3687,3022,40939,173437,2,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',297001.90,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3688,3022,40939,173437,2,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',148500.95,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3689,3022,40939,173437,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',148500.95,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL);
INSERT INTO `balance_libro` VALUES (3690,3022,40939,173437,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',207901.33,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3691,3022,40939,173437,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',89100.57,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3692,3022,40939,173437,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',95040.61,NULL,NULL,1,'2022-06-20 21:51:35','2022-06-20 21:51:35',NULL),(3693,3022,40939,173437,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',89100.57,NULL,NULL,1,'2022-06-20 21:51:36','2022-06-20 21:51:36',NULL),(3694,3022,40939,173437,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',92070.59,NULL,NULL,1,'2022-06-20 21:51:36','2022-06-20 21:51:36',NULL),(3695,3022,40939,173437,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',80190.51,NULL,NULL,1,'2022-06-20 21:51:36','2022-06-20 21:51:36',NULL),(3696,3022,40939,173437,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',118800.76,NULL,NULL,1,'2022-06-20 21:51:36','2022-06-20 21:51:36',NULL),(3697,3022,40939,173437,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',159617.25,NULL,NULL,1,'2022-06-20 21:51:36','2022-06-20 21:51:36',NULL),(3698,3022,40939,173437,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',148500.95,NULL,NULL,1,'2022-06-20 21:51:36','2022-06-20 21:51:36',NULL),(3699,3022,40939,173437,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',12133.80,NULL,NULL,1,'2022-06-20 21:51:36','2022-06-20 21:51:36',NULL),(3700,3022,40819,151531,3,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',6983.20,NULL,NULL,1,'2022-06-22 11:51:59','2022-06-22 11:51:59',NULL),(3701,3022,40819,151531,3,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',2500.00,NULL,NULL,1,'2022-06-22 11:51:59','2022-06-22 11:51:59',NULL),(3702,3022,40819,151531,3,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',3662.99,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3703,3022,40819,151531,3,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',2800.00,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3704,3022,40819,151531,3,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',24391.80,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3705,3022,40819,151531,3,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',110000.00,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3706,3022,40819,151531,3,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3750.00,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3707,3022,40819,151531,3,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',25328.57,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3708,3022,40819,151531,3,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',12439.20,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3709,3022,40819,151531,3,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',2106.22,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL);
INSERT INTO `balance_libro` VALUES (3710,3022,40819,151531,3,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',13516.86,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3711,3022,40819,151531,3,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',5376.25,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3712,3022,40819,151531,3,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',922.00,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3713,3022,40819,151531,3,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',22385.00,NULL,NULL,1,'2022-06-22 11:52:00','2022-06-22 11:52:00',NULL),(3714,3022,40819,151531,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',351000.00,NULL,NULL,1,'2022-06-22 11:55:54','2022-06-22 11:55:54',NULL),(3715,3022,40819,151531,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',1850000.00,NULL,NULL,1,'2022-06-22 11:55:54','2022-06-22 11:55:54',NULL),(3716,3022,40819,151531,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',34243.00,NULL,NULL,1,'2022-06-22 11:55:54','2022-06-22 11:55:54',NULL),(3717,3022,40819,151531,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',34243.00,NULL,NULL,1,'2022-06-22 11:55:54','2022-06-22 11:55:54',NULL),(3718,3022,40819,151531,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',34243.00,NULL,NULL,1,'2022-06-22 11:55:54','2022-06-22 11:55:54',NULL),(3719,3022,40819,151531,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',220353.10,NULL,NULL,1,'2022-06-22 11:55:54','2022-06-22 11:55:54',NULL),(3720,3022,41024,175565,3,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',999.99,NULL,NULL,1,'2022-06-23 13:02:15','2022-06-23 13:02:15',NULL),(3721,3022,41024,175565,3,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2600.00,NULL,NULL,1,'2022-06-23 13:02:47','2022-06-23 13:02:47',NULL),(3722,3022,41024,175565,3,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',499.99,NULL,NULL,1,'2022-06-23 13:03:29','2022-06-23 13:03:29',NULL),(3723,3022,41024,175565,3,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1000.01,NULL,NULL,1,'2022-06-23 13:04:00','2022-06-23 13:04:00',NULL),(3724,3022,41024,175565,3,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',999.99,NULL,NULL,1,'2022-06-23 13:04:29','2022-06-23 13:04:29',NULL),(3725,3022,41024,175565,3,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',499.99,NULL,NULL,1,'2022-06-23 13:04:54','2022-06-23 13:04:54',NULL),(3726,3022,41024,175565,3,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',2099.99,NULL,NULL,1,'2022-06-23 13:06:27','2022-06-23 13:06:27',NULL),(3727,3022,41024,175565,3,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1000.02,NULL,NULL,1,'2022-06-23 13:07:11','2022-06-23 13:07:11',NULL),(3728,3022,41024,175565,3,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-22','2022-05-22',5000.00,NULL,NULL,1,'2022-06-23 13:07:51','2022-06-23 13:07:51',NULL),(3729,3022,41024,175565,3,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',2999.99,NULL,NULL,1,'2022-06-23 13:09:12','2022-06-23 13:09:12',NULL);
INSERT INTO `balance_libro` VALUES (3730,3022,41024,175565,3,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1999.99,NULL,NULL,1,'2022-06-23 13:10:32','2022-06-23 13:10:32',NULL),(3731,3022,40720,1546,3,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',6073.37,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3732,3022,40720,1546,3,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',2700.01,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3733,3022,40720,1546,3,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',8513.42,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3734,3022,40720,1546,3,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',7947.98,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3735,3022,40720,1546,3,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',2303.21,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3736,3022,40720,1546,3,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',980.86,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3737,3022,40720,1546,3,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',5037.43,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3738,3022,40720,1546,3,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1549.51,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3739,3022,40720,1546,3,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',3449.10,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3740,3022,40720,1546,3,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',6639.40,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3741,3022,40720,1546,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',919.82,NULL,NULL,1,'2022-06-24 10:14:53','2022-06-24 10:14:53',NULL),(3742,3022,40720,1546,3,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',5245.21,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3743,3022,40720,1546,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',3268.00,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3744,3022,40720,1546,3,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',3637.27,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3745,3022,40720,1546,3,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1258.02,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3746,3022,40720,1546,3,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',2270.23,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3747,3022,40720,1546,3,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',94906.91,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3748,3022,40720,1546,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',5131.52,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3749,3022,40720,1546,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2841.31,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3750,3022,40720,1546,3,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',2156.00,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL);
INSERT INTO `balance_libro` VALUES (3751,3022,40720,1546,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',18151.75,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3752,3022,40720,1546,3,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1190.97,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3753,3022,40720,1546,3,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1716.49,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3754,3022,40720,1546,3,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',4981.15,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3755,3022,40720,1546,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',2171.88,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3756,3022,40720,1546,3,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',2450.00,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3757,3022,40720,1546,3,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',3474.33,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3758,3022,40720,1546,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',6320.00,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3759,3022,40720,1546,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',5335.14,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3760,3022,40720,1546,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',5245.21,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-27 09:59:16','2022-06-27 09:59:16'),(3761,3022,40720,1546,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',6320.00,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3762,3022,40720,1546,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',3314.46,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3763,3022,40720,1546,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',2205.00,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3764,3022,40720,1546,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',1170.19,NULL,NULL,1,'2022-06-24 10:14:54','2022-06-24 10:14:54',NULL),(3765,3022,40720,1546,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',756.46,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3766,3022,40720,1546,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',598.63,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3767,3022,40720,1546,3,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',10796.74,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3768,3022,40720,1546,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1401.17,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3769,3022,40720,1546,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',3820.13,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3770,3022,40720,1546,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',11602.10,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3771,3022,40720,1546,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',47079.23,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL);
INSERT INTO `balance_libro` VALUES (3772,3022,40720,1546,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',15694.23,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3773,3022,40720,1546,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',9792.82,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3774,3022,40720,1546,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',3414.55,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3775,3022,40720,1546,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',6628.45,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3776,3022,40720,1546,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',7241.50,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3777,3022,40720,1546,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',2774.93,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3778,3022,40720,1546,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',6628.45,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3779,3022,40720,1546,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',655.10,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3780,3022,40720,1546,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',12932.22,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3781,3022,40720,1546,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',9666.42,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3782,3022,40720,1546,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',2132.38,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3783,3022,40720,1546,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',4006.72,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3784,3022,40720,1546,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',10500.00,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-27 09:58:52','2022-06-27 09:58:52'),(3785,3022,40720,1546,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1130.70,NULL,NULL,1,'2022-06-24 10:14:55','2022-06-24 10:14:55',NULL),(3786,3022,40720,1546,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6346.51,NULL,NULL,1,'2022-06-24 10:14:56','2022-06-24 10:14:56',NULL),(3787,3022,40720,1546,3,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2413.72,NULL,NULL,1,'2022-06-24 10:14:56','2022-06-24 10:14:56',NULL),(3788,3022,40720,1546,3,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',1990.00,NULL,NULL,1,'2022-06-24 10:14:56','2022-06-24 10:14:56',NULL),(3789,3022,40720,1546,3,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',450.00,NULL,NULL,1,'2022-06-24 10:14:56','2022-06-24 10:14:56',NULL),(3790,3022,41024,175565,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',1000.00,NULL,NULL,1,'2022-06-27 12:01:22','2022-06-29 11:55:42','2022-06-29 11:55:42'),(3791,3022,41024,175565,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',12727.00,NULL,NULL,1,'2022-06-27 12:04:01','2022-06-27 12:04:01',NULL),(3792,3022,41024,175565,3,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',10170.00,NULL,NULL,1,'2022-06-27 12:07:44','2022-06-27 12:07:44',NULL);
INSERT INTO `balance_libro` VALUES (3793,3022,41024,175565,3,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1800.01,NULL,NULL,1,'2022-06-28 11:45:52','2022-06-28 11:45:52',NULL),(3794,3022,41024,175565,3,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',5628.00,NULL,NULL,1,'2022-06-28 11:45:52','2022-06-28 11:45:52',NULL),(3795,3022,41024,175565,3,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',2523.49,NULL,NULL,1,'2022-06-28 11:45:52','2022-06-28 11:45:52',NULL),(3796,3022,41024,175565,3,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',2131.45,NULL,NULL,1,'2022-06-28 11:45:52','2022-06-28 11:45:52',NULL),(3797,3022,41024,175565,3,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',3677.90,NULL,NULL,1,'2022-06-28 11:45:52','2022-06-28 11:45:52',NULL),(3798,3022,41024,175565,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',6670.00,NULL,NULL,1,'2022-06-28 11:45:52','2022-06-28 11:45:52',NULL),(3799,3022,41024,175565,3,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',5026.80,NULL,NULL,1,'2022-06-28 11:45:53','2022-06-28 11:45:53',NULL),(3800,3022,41024,175565,3,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1459.93,NULL,NULL,1,'2022-06-28 11:45:53','2022-06-28 11:45:53',NULL),(3801,3022,41024,175565,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',2024.00,NULL,NULL,1,'2022-06-28 11:45:53','2022-06-28 11:45:53',NULL),(3802,3022,41024,175565,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',620.74,NULL,NULL,1,'2022-06-28 11:45:53','2022-06-28 11:45:53',NULL),(3803,3022,41024,175565,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',7228.00,NULL,NULL,1,'2022-06-28 11:45:53','2022-06-28 11:45:53',NULL),(3804,3022,41024,175565,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',30851.99,NULL,NULL,1,'2022-06-28 11:45:53','2022-06-28 11:45:53',NULL),(3805,3022,41024,175565,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',21602.20,NULL,NULL,1,'2022-06-28 11:45:53','2022-06-28 11:45:53',NULL),(3806,3022,41024,175565,2,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',907.50,NULL,NULL,1,'2022-06-29 11:36:11','2022-06-29 11:36:11',NULL),(3807,3022,41024,175565,2,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',968.00,NULL,NULL,1,'2022-06-29 11:36:11','2022-06-29 11:36:11',NULL),(3808,3022,41024,175565,2,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',18016.90,NULL,NULL,1,'2022-06-29 11:36:11','2022-06-29 11:36:11',NULL),(3809,3022,41024,175565,2,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',17520.80,NULL,NULL,1,'2022-06-29 11:36:11','2022-06-29 11:36:11',NULL),(3810,3022,41024,175565,2,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1923.90,NULL,NULL,1,'2022-06-29 11:36:11','2022-06-29 11:36:11',NULL),(3811,3022,41024,175565,2,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1210.00,NULL,NULL,1,'2022-06-29 11:36:11','2022-06-29 11:36:11',NULL),(3812,3022,41024,175565,2,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',25906.10,NULL,NULL,1,'2022-06-29 11:36:11','2022-06-29 11:36:11',NULL),(3813,3022,41024,175565,2,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',2722.50,NULL,NULL,1,'2022-06-29 11:36:11','2022-06-29 11:36:11',NULL);
INSERT INTO `balance_libro` VALUES (3814,3022,41024,175565,2,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',6534.00,NULL,NULL,1,'2022-06-29 11:36:11','2022-06-29 11:36:11',NULL),(3815,3022,41024,175565,2,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',16879.50,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3816,3022,41024,175565,2,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',4000.01,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3817,3022,41024,175565,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1028.50,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3818,3022,41024,175565,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',46185.70,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3819,3022,41024,175565,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',54111.20,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3820,3022,41024,175565,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',132676.50,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3821,3022,41024,175565,2,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',8409.50,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3822,3022,41024,175565,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',4235.00,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3823,3022,41024,175565,2,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',2420.00,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3824,3022,41024,175565,2,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',6836.50,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3825,3022,41024,175565,2,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',5263.50,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3826,3022,41024,175565,2,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',3025.00,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3827,3022,41024,175565,2,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',1663.75,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3828,3022,41024,175565,2,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',3025.00,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3829,3022,41024,175565,2,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',6134.70,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3830,3022,41024,175565,2,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',51788.00,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3831,3022,41024,175565,2,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',6534.00,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3832,3022,41024,175565,2,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',6534.00,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3833,3022,41024,175565,2,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',13310.00,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL);
INSERT INTO `balance_libro` VALUES (3834,3022,41024,175565,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',15596.90,NULL,NULL,1,'2022-06-29 11:36:12','2022-06-29 11:36:12',NULL),(3835,3022,41024,175566,3,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',1000.00,NULL,NULL,1,'2022-06-29 12:06:28','2022-06-29 12:06:28',NULL),(3836,3022,41024,175566,3,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',3999.95,NULL,NULL,1,'2022-06-29 12:10:09','2022-06-29 12:10:09',NULL),(3837,3022,41024,175566,3,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',999.95,NULL,NULL,1,'2022-06-29 12:13:01','2022-06-29 12:13:01',NULL),(3838,3022,41024,175566,3,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-06-29 12:14:11','2022-06-29 12:14:11',NULL),(3839,3022,41024,175566,3,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',999.99,NULL,NULL,1,'2022-06-29 12:15:26','2022-06-29 12:15:26',NULL),(3840,3022,40819,151532,2,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',27736.16,NULL,NULL,1,'2022-07-01 10:20:29','2022-07-01 10:25:40','2022-07-01 10:25:40'),(3841,3022,40819,151532,2,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',18525.10,NULL,NULL,1,'2022-07-01 10:24:44','2022-07-01 10:25:01','2022-07-01 10:25:01'),(3842,3022,40819,151532,3,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',27736.16,NULL,NULL,1,'2022-07-01 10:27:18','2022-07-21 23:34:34','2022-07-21 23:34:34'),(3843,3022,40819,151532,3,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',70000.00,NULL,NULL,1,'2022-07-01 10:29:03','2022-07-21 23:34:23','2022-07-21 23:34:23'),(3844,3022,40819,151532,3,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',4720.00,NULL,NULL,1,'2022-07-01 10:32:46','2022-07-21 23:34:17','2022-07-21 23:34:17'),(3845,3022,40720,1547,2,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',18597.54,NULL,NULL,1,'2022-07-07 11:03:39','2022-07-07 11:03:39',NULL),(3846,3022,40720,1547,2,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',18260.00,NULL,NULL,1,'2022-07-07 11:05:06','2022-07-07 11:05:06',NULL),(3847,3022,40720,1547,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',19192.96,NULL,NULL,1,'2022-07-07 11:06:16','2022-07-07 11:06:16',NULL),(3848,3022,40720,1547,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',21922.16,NULL,NULL,1,'2022-07-07 11:08:02','2022-07-07 11:08:02',NULL),(3849,3022,40720,1547,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',16697.02,NULL,NULL,1,'2022-07-07 11:09:00','2022-07-07 11:09:00',NULL),(3850,3022,40720,1547,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',24783.00,NULL,NULL,1,'2022-07-07 11:10:32','2022-07-07 11:10:32',NULL),(3851,3022,40720,1547,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',18492.08,NULL,NULL,1,'2022-07-07 11:11:33','2022-07-07 11:11:33',NULL),(3852,3022,40720,1547,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',26966.13,NULL,NULL,1,'2022-07-07 11:12:48','2022-07-07 11:12:48',NULL),(3853,3022,40720,1547,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',10139.97,NULL,NULL,1,'2022-07-07 11:14:39','2022-07-07 11:15:38','2022-07-07 11:15:38');
INSERT INTO `balance_libro` VALUES (3854,3022,40720,1547,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',21816.06,NULL,NULL,1,'2022-07-07 11:15:38','2022-07-07 11:15:38',NULL),(3855,3022,40720,1547,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',21287.10,NULL,NULL,1,'2022-07-07 11:17:27','2022-07-07 11:17:27',NULL),(3856,3022,40720,1547,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',36504.09,NULL,NULL,1,'2022-07-07 11:18:24','2022-07-07 11:19:50','2022-07-07 11:19:50'),(3857,3022,40720,1547,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',36504.09,NULL,NULL,1,'2022-07-07 11:19:50','2022-07-07 11:19:50',NULL),(3858,3022,40720,1547,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',53347.99,NULL,NULL,1,'2022-07-07 11:21:46','2022-07-07 11:21:46',NULL),(3859,3022,40720,1547,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',17810.05,NULL,NULL,1,'2022-07-07 11:23:17','2022-07-07 11:23:17',NULL),(3860,3022,40720,1547,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',18585.05,NULL,NULL,1,'2022-07-07 11:24:37','2022-07-07 11:24:37',NULL),(3861,3022,40720,1547,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',19646.08,NULL,NULL,1,'2022-07-07 11:34:54','2022-07-07 11:34:54',NULL),(3862,3022,40720,1547,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',28886.99,NULL,NULL,1,'2022-07-07 11:36:05','2022-07-07 11:36:05',NULL),(3863,3022,40720,1547,2,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',22216.02,NULL,NULL,1,'2022-07-07 11:37:43','2022-07-07 11:37:43',NULL),(3864,3022,40720,1547,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',18247.01,NULL,NULL,1,'2022-07-07 11:38:12','2022-07-07 11:39:56','2022-07-07 11:39:56'),(3865,3022,40720,1547,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',19947.00,NULL,NULL,1,'2022-07-07 11:38:33','2022-07-07 11:39:39','2022-07-07 11:39:39'),(3866,3022,40720,1547,2,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',24900.99,NULL,NULL,1,'2022-07-07 11:39:06','2022-07-07 11:39:06',NULL),(3867,3022,40720,1547,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',19947.00,NULL,NULL,1,'2022-07-07 11:39:39','2022-07-07 11:39:39',NULL),(3868,3022,40720,1547,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',18247.01,NULL,NULL,1,'2022-07-07 11:39:56','2022-07-07 11:39:56',NULL),(3869,3022,40720,1547,2,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',24900.99,NULL,NULL,1,'2022-07-07 11:40:26','2022-07-07 11:41:52','2022-07-07 11:41:52'),(3870,3022,40720,1547,2,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',22224.52,NULL,NULL,1,'2022-07-07 11:42:13','2022-07-07 11:42:13',NULL),(3871,3022,40720,1547,2,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',24327.92,NULL,NULL,1,'2022-07-07 11:43:54','2022-07-07 11:43:54',NULL),(3872,3022,40720,1547,2,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',22295.01,NULL,NULL,1,'2022-07-07 11:44:47','2022-07-07 11:44:47',NULL),(3873,3022,40720,1547,2,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',11401.01,NULL,NULL,1,'2022-07-07 11:46:19','2022-07-07 11:46:19',NULL);
INSERT INTO `balance_libro` VALUES (3874,3022,40720,1547,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',26220.00,NULL,NULL,1,'2022-07-07 11:47:43','2022-07-07 11:47:43',NULL),(3875,3022,40720,1547,3,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',7503.31,NULL,NULL,1,'2022-07-11 10:58:27','2022-07-11 10:58:27',NULL),(3876,3022,40720,1547,3,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',4550.68,NULL,NULL,1,'2022-07-11 10:58:27','2022-07-11 10:58:27',NULL),(3877,3022,40720,1547,3,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',10229.20,NULL,NULL,1,'2022-07-11 10:58:27','2022-07-11 10:58:27',NULL),(3878,3022,40720,1547,3,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',6073.37,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3879,3022,40720,1547,3,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1863.64,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3880,3022,40720,1547,3,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',4454.55,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3881,3022,40720,1547,3,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',7015.40,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3882,3022,40720,1547,3,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3609.83,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3883,3022,40720,1547,3,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',44132.75,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3884,3022,40720,1547,3,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',7849.84,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3885,3022,40720,1547,3,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',6724.00,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3886,3022,40720,1547,3,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',15803.57,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3887,3022,40720,1547,3,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',688.43,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3888,3022,40720,1547,3,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',24.20,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3889,3022,40720,1547,3,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',2672.19,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3890,3022,40720,1547,3,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',7515.33,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3891,3022,40720,1547,3,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',4244.99,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3892,3022,40720,1547,3,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',1843.49,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3893,3022,40720,1547,3,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',6532.13,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3894,3022,40720,1547,3,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',90503.31,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL);
INSERT INTO `balance_libro` VALUES (3895,3022,40720,1547,3,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',6704.00,NULL,NULL,1,'2022-07-11 10:58:28','2022-07-11 10:58:28',NULL),(3896,3022,40720,1547,3,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',4205.99,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3897,3022,40720,1547,3,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',4460.00,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3898,3022,40720,1547,3,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',776.76,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3899,3022,40720,1547,3,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',6060.90,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3900,3022,40720,1547,3,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',2716.88,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3901,3022,40720,1547,3,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1069.56,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3902,3022,40720,1547,3,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',4512.31,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3903,3022,40720,1547,3,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',3604.00,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3904,3022,40720,1547,3,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',3781.64,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3905,3022,40720,1547,3,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',8700.00,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3906,3022,40720,1547,3,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',10737.69,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3907,3022,40720,1547,3,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',435.51,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3908,3022,40720,1547,3,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',6736.10,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3909,3022,40720,1547,3,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',6805.78,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3910,3022,40720,1547,3,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',8700.00,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3911,3022,40720,1547,3,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1918.20,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3912,3022,40720,1547,3,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',7745.98,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3913,3022,40720,1547,3,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',4097.56,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3914,3022,40720,1547,3,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',17282.67,NULL,NULL,1,'2022-07-11 10:58:29','2022-07-11 10:58:29',NULL),(3915,3022,40720,1547,3,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',7838.71,NULL,NULL,1,'2022-07-11 10:58:30','2022-07-11 10:58:30',NULL);
INSERT INTO `balance_libro` VALUES (3916,3022,40720,1547,3,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',8700.00,NULL,NULL,1,'2022-07-11 10:58:30','2022-07-11 10:58:30',NULL),(3917,3022,40720,1547,3,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',0.00,NULL,NULL,1,'2022-07-11 10:58:30','2022-07-11 10:58:30',NULL),(3918,3022,40720,1547,3,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2585.90,NULL,NULL,1,'2022-07-11 10:58:30','2022-07-11 10:58:30',NULL),(3919,3022,40720,1547,3,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1629.70,NULL,NULL,1,'2022-07-11 10:58:30','2022-07-11 10:58:30',NULL),(3920,3022,40720,1547,3,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',8700.00,NULL,NULL,1,'2022-07-11 10:58:30','2022-07-11 10:58:30',NULL),(3921,3022,40720,1547,3,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',5245.21,NULL,NULL,1,'2022-07-11 10:58:30','2022-07-11 10:58:30',NULL),(3922,3022,40720,1547,3,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',16740.64,NULL,NULL,1,'2022-07-11 10:58:30','2022-07-11 10:58:30',NULL),(3923,3022,40720,1547,3,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',16740.63,NULL,NULL,1,'2022-07-11 10:58:30','2022-07-11 10:58:30',NULL),(3924,3022,41024,175566,3,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1959.99,NULL,NULL,1,'2022-07-14 11:28:54','2022-07-14 12:06:20','2022-07-14 12:06:20'),(3925,3022,41024,175566,3,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',2519.99,NULL,NULL,1,'2022-07-14 11:31:06','2022-07-14 12:05:31','2022-07-14 12:05:31'),(3926,3022,41024,175566,3,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',700.00,NULL,NULL,1,'2022-07-14 11:33:13','2022-07-14 12:04:54','2022-07-14 12:04:54'),(3927,3022,41024,175566,3,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',1880.00,NULL,NULL,1,'2022-07-14 11:34:56','2022-07-14 12:04:12','2022-07-14 12:04:12'),(3928,3022,41024,175566,3,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',999.97,NULL,NULL,1,'2022-07-14 11:46:39','2022-07-14 12:03:50','2022-07-14 12:03:50'),(3929,3022,41024,175566,3,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',2038.88,NULL,NULL,1,'2022-07-14 11:49:53','2022-07-14 12:03:16','2022-07-14 12:03:16'),(3930,3022,41024,175566,3,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2035.29,NULL,NULL,1,'2022-07-14 11:53:11','2022-07-14 12:02:50','2022-07-14 12:02:50'),(3931,3022,41024,175566,3,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3567.57,NULL,NULL,1,'2022-07-14 11:56:16','2022-07-14 11:56:16',NULL),(3932,3022,41024,175566,3,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',4076.19,NULL,NULL,1,'2022-07-14 11:59:20','2022-07-14 11:59:20',NULL),(3933,3022,41024,175566,3,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',3053.23,NULL,NULL,1,'2022-07-14 12:02:18','2022-07-14 12:02:18',NULL),(3934,3022,41024,175566,3,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2035.29,NULL,NULL,1,'2022-07-14 12:02:50','2022-07-14 12:02:50',NULL),(3935,3022,41024,175566,3,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',2038.88,NULL,NULL,1,'2022-07-14 12:03:16','2022-07-14 12:03:16',NULL);
INSERT INTO `balance_libro` VALUES (3936,3022,41024,175566,3,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',999.97,NULL,NULL,1,'2022-07-14 12:03:50','2022-07-14 12:03:50',NULL),(3937,3022,41024,175566,3,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',1880.00,NULL,NULL,1,'2022-07-14 12:04:12','2022-07-14 12:04:12',NULL),(3938,3022,41024,175566,3,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',700.00,NULL,NULL,1,'2022-07-14 12:04:54','2022-07-14 12:04:54',NULL),(3939,3022,41024,175566,3,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',2519.99,NULL,NULL,1,'2022-07-14 12:05:31','2022-07-14 12:05:31',NULL),(3940,3022,41024,175566,3,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1959.99,NULL,NULL,1,'2022-07-14 12:06:20','2022-07-14 12:06:20',NULL),(3941,3022,41024,175566,3,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2100.01,NULL,NULL,1,'2022-07-15 11:16:41','2022-07-15 11:16:41',NULL),(3942,3022,41024,175566,3,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1320.00,NULL,NULL,1,'2022-07-15 11:16:41','2022-07-15 11:16:41',NULL),(3943,3022,41024,175566,3,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',4973.23,NULL,NULL,1,'2022-07-15 11:16:41','2022-07-15 11:16:41',NULL),(3944,3022,41024,175566,3,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',3176.09,NULL,NULL,1,'2022-07-15 11:16:41','2022-07-15 11:16:41',NULL),(3945,3022,41024,175566,3,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',2813.99,NULL,NULL,1,'2022-07-15 11:16:41','2022-07-15 11:16:41',NULL),(3946,3022,41024,175566,3,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',254311.20,NULL,NULL,1,'2022-07-15 11:16:41','2022-07-15 11:16:41',NULL),(3947,3022,41024,175566,3,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',92625.00,NULL,NULL,1,'2022-07-15 11:16:41','2022-07-15 11:16:41',NULL),(3948,3022,41024,175566,3,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',123500.00,NULL,NULL,1,'2022-07-15 11:16:42','2022-07-15 11:16:42',NULL),(3949,3022,41024,175566,3,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',50122.80,NULL,NULL,1,'2022-07-15 11:16:42','2022-07-15 11:16:42',NULL),(3950,3022,41024,175566,3,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',300.00,NULL,NULL,1,'2022-07-15 11:16:42','2022-07-15 11:16:42',NULL),(3951,3022,41024,175566,3,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',17326.64,NULL,NULL,1,'2022-07-15 11:16:42','2022-07-15 11:16:42',NULL),(3988,3022,40939,173438,3,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',30624.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3989,3022,40939,173438,3,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',2700.01,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3990,3022,40939,173438,3,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',2450.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3991,3022,40939,173438,3,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',9299.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL);
INSERT INTO `balance_libro` VALUES (3992,3022,40939,173438,3,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',37200.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3993,3022,40939,173438,3,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',9299.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3994,3022,40939,173438,3,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',12789.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3995,3022,40939,173438,3,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',3998.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3996,3022,40939,173438,3,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',40399.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3997,3022,40939,173438,3,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',3826.26,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3998,3022,40939,173438,3,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',3998.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(3999,3022,40939,173438,3,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',3998.00,NULL,NULL,1,'2022-07-21 20:31:22','2022-07-21 20:31:22',NULL),(4000,3022,40939,173438,3,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',5820.17,NULL,NULL,1,'2022-07-21 20:47:24','2022-07-21 20:47:24',NULL),(4001,3022,40939,173438,3,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',7999.90,NULL,NULL,1,'2022-07-21 20:49:06','2022-07-21 20:49:06',NULL),(4002,3022,40939,173438,3,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',6005.16,NULL,NULL,1,'2022-07-21 20:50:22','2022-07-21 20:50:22',NULL),(4003,3022,40939,173438,3,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',6999.66,NULL,NULL,1,'2022-07-21 20:52:01','2022-07-21 20:52:01',NULL),(4004,3022,40939,173438,3,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',5101.35,NULL,NULL,1,'2022-07-21 20:57:07','2022-07-21 20:57:07',NULL),(4005,3022,40939,173438,3,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3803389.01,NULL,NULL,1,'2022-07-21 20:59:02','2022-07-21 20:59:02',NULL),(4006,3022,40939,173438,3,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3425295.58,NULL,NULL,1,'2022-07-21 21:00:29','2022-07-21 21:00:29',NULL),(4007,3022,40939,173438,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',6005.69,NULL,NULL,1,'2022-07-21 21:19:57','2022-07-21 21:19:57',NULL),(4008,3022,40939,173438,2,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',307797.75,NULL,NULL,1,'2022-07-21 23:03:27','2022-07-21 23:03:27',NULL),(4009,3022,40939,173438,2,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',307797.75,NULL,NULL,1,'2022-07-21 23:03:27','2022-07-21 23:03:27',NULL),(4010,3022,40939,173438,2,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',307797.75,NULL,NULL,1,'2022-07-21 23:03:27','2022-07-21 23:03:27',NULL),(4011,3022,40939,173438,2,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',307797.75,NULL,NULL,1,'2022-07-21 23:03:27','2022-07-21 23:03:27',NULL);
INSERT INTO `balance_libro` VALUES (4012,3022,40939,173438,2,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',193916.45,NULL,NULL,1,'2022-07-21 23:03:27','2022-07-21 23:03:27',NULL),(4013,3022,40939,173438,2,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',193916.45,NULL,NULL,1,'2022-07-21 23:03:27','2022-07-21 23:03:27',NULL),(4014,3022,40939,173438,2,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',249321.15,NULL,NULL,1,'2022-07-21 23:03:27','2022-07-21 23:03:27',NULL),(4015,3022,40939,173438,2,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',637154.05,NULL,NULL,1,'2022-07-21 23:03:27','2022-07-21 23:03:27',NULL),(4016,3022,40939,173438,2,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',264934.80,NULL,NULL,1,'2022-07-21 23:03:27','2022-07-21 23:03:27',NULL),(4017,3022,40939,173438,2,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',234900.90,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4018,3022,40939,173438,2,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',234900.90,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4019,3022,40939,173438,2,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',156600.60,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4020,3022,40939,173438,2,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',156600.60,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4021,3022,40939,173438,2,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',84532.50,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4022,3022,40939,173438,2,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',112710.00,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4023,3022,40939,173438,2,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',84532.50,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4024,3022,40939,173438,2,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',281775.00,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4025,3022,40939,173438,2,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',281775.00,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4026,3022,40939,173438,2,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',157948.70,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4027,3022,40939,173438,2,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',157948.70,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4028,3022,40939,173438,2,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',157948.70,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4029,3022,40939,173438,2,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',157948.70,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4030,3022,40939,173438,2,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',157948.70,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4031,3022,40939,173438,2,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',157948.70,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL);
INSERT INTO `balance_libro` VALUES (4032,3022,40939,173438,2,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',157948.70,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4033,3022,40939,173438,2,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',157948.70,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4034,3022,40939,173438,2,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',284305.45,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4035,3022,40939,173438,2,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',170583.27,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4036,3022,40939,173438,2,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',170583.27,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4037,3022,40939,173438,2,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',170583.27,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4038,3022,40939,173438,2,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',170583.27,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4039,3022,40939,173438,2,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',85291.64,NULL,NULL,1,'2022-07-21 23:03:28','2022-07-21 23:03:28',NULL),(4040,3022,40939,173438,2,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',170583.27,NULL,NULL,1,'2022-07-21 23:03:29','2022-07-21 23:03:29',NULL),(4041,3022,40939,173438,2,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',113722.18,NULL,NULL,1,'2022-07-21 23:03:29','2022-07-21 23:03:29',NULL),(4042,3022,40939,173438,2,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',170583.27,NULL,NULL,1,'2022-07-21 23:03:29','2022-07-21 23:03:29',NULL),(4043,3022,40939,173438,2,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',277023.50,NULL,NULL,1,'2022-07-21 23:03:29','2022-07-21 23:03:29',NULL),(4044,3022,40819,151532,2,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',351000.00,NULL,NULL,1,'2022-07-21 23:28:16','2022-07-21 23:28:16',NULL),(4053,3022,40819,151532,3,3880,'App\\Models\\Receipt',3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',21100.01,NULL,NULL,1,'2022-07-21 23:35:20','2022-07-21 23:35:20',NULL),(4054,3022,40819,151532,3,3881,'App\\Models\\Receipt',3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2860.12,NULL,NULL,1,'2022-07-21 23:35:20','2022-07-21 23:35:20',NULL),(4055,3022,40819,151532,3,3882,'App\\Models\\Receipt',3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',3616.30,NULL,NULL,1,'2022-07-21 23:35:20','2022-07-21 23:35:20',NULL),(4056,3022,40819,151532,3,3883,'App\\Models\\Receipt',3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',4500.00,NULL,NULL,1,'2022-07-21 23:35:20','2022-07-21 23:35:20',NULL),(4057,3022,40819,151532,3,3884,'App\\Models\\Receipt',3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',5418.00,NULL,NULL,1,'2022-07-21 23:35:20','2022-07-21 23:35:20',NULL),(4058,3022,40819,151532,3,3885,'App\\Models\\Receipt',3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',26620.00,NULL,NULL,1,'2022-07-21 23:35:20','2022-07-21 23:35:20',NULL),(4059,3022,40819,151532,3,3886,'App\\Models\\Receipt',3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',2500.00,NULL,NULL,1,'2022-07-21 23:35:20','2022-07-21 23:35:20',NULL);
INSERT INTO `balance_libro` VALUES (4060,3022,40819,151532,3,3887,'App\\Models\\Receipt',3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',3179.00,NULL,NULL,1,'2022-07-21 23:35:20','2022-07-21 23:35:20',NULL),(4061,3022,40819,151532,3,3888,'App\\Models\\Receipt',3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',4720.00,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4062,3022,40819,151532,3,3889,'App\\Models\\Receipt',3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',6000.00,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4063,3022,40819,151532,3,3890,'App\\Models\\Receipt',3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',6000.00,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4064,3022,40819,151532,3,3891,'App\\Models\\Receipt',3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',70000.00,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4065,3022,40819,151532,3,3892,'App\\Models\\Receipt',3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',18525.10,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4066,3022,40819,151532,3,3893,'App\\Models\\Receipt',3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',2965.60,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4067,3022,40819,151532,3,3894,'App\\Models\\Receipt',3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',27736.17,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4068,3022,40819,151532,3,3895,'App\\Models\\Receipt',3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',27813.39,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4069,3022,40819,151532,3,3896,'App\\Models\\Receipt',3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',32000.00,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4070,3022,40819,151532,3,3897,'App\\Models\\Receipt',3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',10244.53,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4071,3022,40819,151532,3,3898,'App\\Models\\Receipt',3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3750.00,NULL,NULL,1,'2022-07-21 23:35:21','2022-07-21 23:35:21',NULL),(4072,3022,40819,151532,2,3899,'App\\Models\\Receipt',3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',4633.70,NULL,NULL,1,'2022-07-21 23:49:04','2022-07-22 00:04:28','2022-07-22 00:04:28'),(4073,3022,40819,151532,2,3900,'App\\Models\\Receipt',3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',18525.10,NULL,NULL,1,'2022-07-21 23:53:55','2022-07-22 00:04:22','2022-07-22 00:04:22'),(4074,3022,40819,151532,2,3901,'App\\Models\\Receipt',3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',3750.57,NULL,NULL,1,'2022-07-21 23:56:08','2022-07-21 23:56:27','2022-07-21 23:56:27'),(4075,3022,40819,151532,3,3902,'App\\Models\\Receipt',3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',4633.70,NULL,NULL,1,'2022-07-22 00:06:18','2022-07-22 00:06:18',NULL),(4076,3022,40819,151532,3,3903,'App\\Models\\Receipt',3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',18525.10,NULL,NULL,1,'2022-07-22 00:07:44','2022-07-22 00:27:06','2022-07-22 00:27:06'),(4077,3022,40819,151532,3,3904,'App\\Models\\Receipt',3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',13282.00,NULL,NULL,1,'2022-07-23 21:05:31','2022-07-23 21:05:31',NULL),(4078,3022,40819,151532,3,3905,'App\\Models\\Receipt',3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',26027.21,NULL,NULL,1,'2022-07-23 21:06:51','2022-07-23 21:06:51',NULL),(4079,3022,40819,151532,3,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',3750.57,NULL,NULL,1,'2022-07-23 21:10:14','2022-07-23 21:10:14',NULL);
INSERT INTO `balance_libro` VALUES (4080,3022,41024,175566,2,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2783.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4081,3022,41024,175566,2,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',2541.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4082,3022,41024,175566,2,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',26257.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4083,3022,41024,175566,2,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',2420.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4084,3022,41024,175566,2,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',9559.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4085,3022,41024,175566,2,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',10164.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4086,3022,41024,175566,2,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2904.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4087,3022,41024,175566,2,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2904.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4088,3022,41024,175566,2,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',4840.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4089,3022,41024,175566,2,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',11616.00,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4090,3022,41024,175566,2,3917,'App\\Models\\Receipt',3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',8167.50,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4091,3022,41024,175566,2,3918,'App\\Models\\Receipt',3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',15427.50,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4092,3022,41024,175566,2,3919,'App\\Models\\Receipt',3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',132676.50,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4093,3022,41024,175566,2,3920,'App\\Models\\Receipt',3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',132676.50,NULL,NULL,1,'2022-07-23 23:45:50','2022-07-23 23:45:50',NULL),(4094,3022,41024,175566,2,3921,'App\\Models\\Receipt',3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',6836.50,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4095,3022,41024,175566,2,3922,'App\\Models\\Receipt',3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',7804.50,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4096,3022,41024,175566,2,3923,'App\\Models\\Receipt',3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',4235.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4097,3022,41024,175566,2,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',5687.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4098,3022,41024,175566,2,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',22748.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4099,3022,41024,175566,2,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',2420.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL);
INSERT INTO `balance_libro` VALUES (4100,3022,41024,175566,2,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',4114.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4101,3022,41024,175566,2,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',2722.50,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4102,3022,41024,175566,2,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',16335.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4103,3022,41024,175566,2,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',16335.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4104,3022,41024,175566,2,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',16335.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4105,3022,41024,175566,2,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',16335.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4106,3022,41024,175566,2,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',16375.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4107,3022,41024,175566,2,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',34170.40,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4108,3022,41024,175566,2,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',66180.95,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4109,3022,41024,175566,2,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',999.99,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4110,3022,41024,175566,2,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',12886.50,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4111,3022,41024,175566,2,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',18200.00,NULL,NULL,1,'2022-07-23 23:45:51','2022-07-23 23:45:51',NULL),(4112,3022,41024,175566,2,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',10587.50,NULL,NULL,1,'2022-07-23 23:45:52','2022-07-23 23:45:52',NULL),(4113,3022,41024,175566,2,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',28677.00,NULL,NULL,1,'2022-07-23 23:45:52','2022-07-23 23:45:52',NULL),(4114,3022,41024,175566,2,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',3630.00,NULL,NULL,1,'2022-07-23 23:45:52','2022-07-23 23:45:52',NULL),(4115,3022,41024,175566,2,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',8784.60,NULL,NULL,1,'2022-07-23 23:45:52','2022-07-23 23:45:52',NULL),(4116,3022,41024,175566,2,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',7441.50,NULL,NULL,1,'2022-07-23 23:45:52','2022-07-23 23:45:52',NULL),(4117,3022,41024,175566,2,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1512.50,NULL,NULL,1,'2022-07-23 23:45:52','2022-07-23 23:45:52',NULL),(4118,3022,40720,1548,2,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',30088.43,NULL,NULL,1,'2022-08-03 11:15:14','2022-08-03 11:15:14',NULL),(4119,3022,40720,1548,2,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',31872.51,NULL,NULL,1,'2022-08-03 11:16:20','2022-08-03 11:16:20',NULL);
INSERT INTO `balance_libro` VALUES (4120,3022,40720,1548,2,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',23342.98,NULL,NULL,1,'2022-08-03 11:17:43','2022-08-03 11:17:43',NULL),(4121,3022,40720,1548,2,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',13475.24,NULL,NULL,1,'2022-08-03 11:20:15','2022-08-03 11:20:15',NULL),(4122,3022,40720,1548,2,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',19224.09,NULL,NULL,1,'2022-08-03 11:31:20','2022-08-03 11:31:20',NULL),(4123,3022,40720,1548,2,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',26468.61,NULL,NULL,1,'2022-08-03 11:33:28','2022-08-03 11:33:28',NULL),(4124,3022,40720,1548,2,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',33123.82,NULL,NULL,1,'2022-08-03 11:34:55','2022-08-03 11:34:55',NULL),(4125,3022,40720,1548,2,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',37361.83,NULL,NULL,1,'2022-08-03 11:40:51','2022-08-03 11:40:51',NULL),(4126,3022,40720,1548,2,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',29866.10,NULL,NULL,1,'2022-08-03 11:41:53','2022-08-03 11:41:53',NULL),(4127,3022,40720,1548,2,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',32085.52,NULL,NULL,1,'2022-08-03 11:42:55','2022-08-03 11:42:55',NULL),(4128,3022,40720,1548,2,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',29843.76,NULL,NULL,1,'2022-08-03 11:46:23','2022-08-03 11:46:23',NULL),(4129,3022,40720,1548,2,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',30515.76,NULL,NULL,1,'2022-08-03 11:50:18','2022-08-03 11:50:18',NULL),(4130,3022,40720,1548,2,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',34324.05,NULL,NULL,1,'2022-08-03 11:51:38','2022-08-03 11:51:38',NULL),(4131,3022,40720,1548,2,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',36976.06,NULL,NULL,1,'2022-08-03 11:52:58','2022-08-03 11:52:58',NULL),(4132,3022,40720,1548,2,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',31311.64,NULL,NULL,1,'2022-08-03 11:54:51','2022-08-03 11:54:51',NULL),(4133,3022,40720,1548,2,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',22483.71,NULL,NULL,1,'2022-08-03 11:55:41','2022-08-03 11:55:41',NULL),(4134,3022,40720,1548,2,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',8592.09,NULL,NULL,1,'2022-08-03 11:56:43','2022-08-03 11:56:43',NULL),(4135,3022,40720,1548,2,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',24452.94,NULL,NULL,1,'2022-08-03 11:57:39','2022-08-03 11:57:39',NULL),(4136,3022,40720,1548,2,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',31763.88,NULL,NULL,1,'2022-08-03 12:00:58','2022-08-03 12:00:58',NULL),(4137,3022,40720,1548,2,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',23822.21,NULL,NULL,1,'2022-08-03 12:02:37','2022-08-03 12:02:37',NULL),(4138,3022,40720,1548,2,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',59136.83,NULL,NULL,1,'2022-08-03 12:03:22','2022-08-03 12:03:22',NULL),(4139,3022,40720,1548,3,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6073.37,NULL,NULL,1,'2022-08-04 09:45:48','2022-08-04 09:45:48',NULL),(4140,3022,40720,1548,3,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',37878.96,NULL,NULL,1,'2022-08-04 09:45:48','2022-08-04 09:45:48',NULL);
INSERT INTO `balance_libro` VALUES (4141,3022,40720,1548,3,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7180.20,NULL,NULL,1,'2022-08-04 09:45:48','2022-08-04 09:45:48',NULL),(4142,3022,40720,1548,3,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',85257.19,NULL,NULL,1,'2022-08-04 09:45:48','2022-08-04 09:45:48',NULL),(4143,3022,40720,1548,3,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',638.47,NULL,NULL,1,'2022-08-04 09:45:48','2022-08-04 09:45:48',NULL),(4144,3022,40720,1548,3,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3162.69,NULL,NULL,1,'2022-08-04 09:45:48','2022-08-04 09:45:48',NULL),(4145,3022,40720,1548,3,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3487.24,NULL,NULL,1,'2022-08-04 09:45:48','2022-08-04 09:45:48',NULL),(4146,3022,40720,1548,3,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',369.22,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4147,3022,40720,1548,3,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6707.65,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4148,3022,40720,1548,3,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5855.14,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4149,3022,40720,1548,3,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',6093.71,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4150,3022,40720,1548,3,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4142.63,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4151,3022,40720,1548,3,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4443.46,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4152,3022,40720,1548,3,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2510.64,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4153,3022,40720,1548,3,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5684.25,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4154,3022,40720,1548,3,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4429.29,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4155,3022,40720,1548,3,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',17420.47,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4156,3022,40720,1548,3,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',11073.23,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4157,3022,40720,1548,3,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',7516.45,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4158,3022,40720,1548,3,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5758.60,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4159,3022,40720,1548,3,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',37086.05,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4160,3022,40720,1548,3,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',0.00,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL),(4161,3022,40720,1548,3,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',0.00,NULL,NULL,1,'2022-08-04 09:45:49','2022-08-04 09:45:49',NULL);
INSERT INTO `balance_libro` VALUES (4162,3022,40720,1548,3,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',0.00,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4163,3022,40720,1548,3,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',35090.07,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4164,3022,40720,1548,3,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',16013.68,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4165,3022,40720,1548,3,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4114.63,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4166,3022,40720,1548,3,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',6862.52,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4167,3022,40720,1548,3,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',1870.07,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4168,3022,40720,1548,3,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',79631.52,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4169,3022,40720,1548,3,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7945.40,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4170,3022,40720,1548,3,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3631.09,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4171,3022,40720,1548,3,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3631.09,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4172,3022,40720,1548,3,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',16393.01,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4173,3022,40720,1548,3,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3760.88,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4174,3022,40720,1548,3,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',6963.04,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4175,3022,40720,1548,3,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',10417.92,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4176,3022,40720,1548,3,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',729.12,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4177,3022,40720,1548,3,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5737.08,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4178,3022,40720,1548,3,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5618.28,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4179,3022,40720,1548,3,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7776.14,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4180,3022,40720,1548,3,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',5869.98,NULL,NULL,1,'2022-08-04 09:45:50','2022-08-04 09:45:50',NULL),(4181,3022,40720,1548,3,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',174998.75,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4182,3022,40720,1548,3,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',7933.50,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL);
INSERT INTO `balance_libro` VALUES (4183,3022,40720,1548,3,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',40825.67,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4184,3022,40720,1548,3,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',10282.98,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4185,3022,40720,1548,3,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1293.19,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4186,3022,40720,1548,3,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',11361.72,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4187,3022,40720,1548,3,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',4731.17,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4188,3022,40720,1548,3,4015,'App\\Models\\Receipt',4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1649.90,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4189,3022,40720,1548,3,4016,'App\\Models\\Receipt',4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',2909.61,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4190,3022,40720,1548,3,4017,'App\\Models\\Receipt',4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4352.05,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4191,3022,40720,1548,3,4018,'App\\Models\\Receipt',4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',3179.94,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4192,3022,40720,1548,3,4019,'App\\Models\\Receipt',4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2200.86,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4193,3022,40720,1548,3,4020,'App\\Models\\Receipt',4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6084.03,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4194,3022,40720,1548,3,4021,'App\\Models\\Receipt',4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5496.51,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4195,3022,40720,1548,3,4022,'App\\Models\\Receipt',4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',0.00,NULL,NULL,1,'2022-08-04 09:45:51','2022-08-04 09:45:51',NULL),(4196,3022,40720,1548,2,4023,'App\\Models\\Receipt',4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',21954.92,NULL,NULL,1,'2022-08-04 10:43:02','2022-08-04 10:43:02',NULL),(4197,3022,40720,1548,2,4024,'App\\Models\\Receipt',4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',23674.95,NULL,NULL,1,'2022-08-04 10:46:31','2022-08-04 10:46:31',NULL),(4198,3022,40720,1548,2,4025,'App\\Models\\Receipt',4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',18539.24,NULL,NULL,1,'2022-08-04 10:48:23','2022-08-04 10:48:23',NULL),(4199,3022,40720,1548,2,4026,'App\\Models\\Receipt',4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',27886.06,NULL,NULL,1,'2022-08-04 10:49:14','2022-08-04 10:49:14',NULL),(4200,3022,40720,1548,2,4027,'App\\Models\\Receipt',4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',26860.56,NULL,NULL,1,'2022-08-04 10:50:11','2022-08-04 10:50:11',NULL),(4201,3022,40720,1548,2,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',41779.40,NULL,NULL,1,'2022-08-04 10:51:53','2022-08-04 10:51:53',NULL),(4202,3022,40819,151533,3,4029,'App\\Models\\Receipt',4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6600.05,NULL,NULL,1,'2022-08-09 09:23:13','2022-08-11 09:50:02','2022-08-11 09:50:02'),(4203,3022,40819,151533,3,4030,'App\\Models\\Receipt',4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',39999.00,NULL,NULL,1,'2022-08-09 09:23:13','2022-08-11 09:47:37','2022-08-11 09:47:37');
INSERT INTO `balance_libro` VALUES (4204,3022,40819,151533,3,4031,'App\\Models\\Receipt',4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3000.00,NULL,NULL,1,'2022-08-09 09:23:13','2022-08-11 09:02:31','2022-08-11 09:02:31'),(4205,3022,40819,151533,3,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',70000.00,NULL,NULL,1,'2022-08-09 09:23:13','2022-08-11 09:02:54','2022-08-11 09:02:54'),(4206,3022,40819,151533,3,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6600.05,NULL,NULL,1,'2022-08-09 09:23:13','2022-08-11 09:48:09','2022-08-11 09:48:09'),(4207,3022,40819,151533,3,4034,'App\\Models\\Receipt',4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',25199.46,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-11 09:48:22','2022-08-11 09:48:22'),(4208,3022,40819,151533,3,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3179.00,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-11 09:48:32','2022-08-11 09:48:32'),(4209,3022,40819,151533,3,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',60800.00,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-09 10:44:06','2022-08-09 10:44:06'),(4210,3022,40819,151533,3,4037,'App\\Models\\Receipt',4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3340.91,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-11 09:48:44','2022-08-11 09:48:44'),(4211,3022,40819,151533,3,4038,'App\\Models\\Receipt',4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5482.74,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-11 09:49:20','2022-08-11 09:49:20'),(4212,3022,40819,151533,3,4039,'App\\Models\\Receipt',4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',15000.03,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-11 09:49:31','2022-08-11 09:49:31'),(4213,3022,40819,151533,3,4040,'App\\Models\\Receipt',4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',24000.00,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-10 11:45:32','2022-08-10 11:45:32'),(4214,3022,40819,151533,3,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3750.00,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-11 09:49:41','2022-08-11 09:49:41'),(4215,3022,40819,151533,3,4042,'App\\Models\\Receipt',4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1800.00,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-11 09:47:03','2022-08-11 09:47:03'),(4216,3022,40819,151533,3,4043,'App\\Models\\Receipt',4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',648.00,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-11 09:49:07','2022-08-11 09:49:07'),(4217,3022,40819,151533,3,4044,'App\\Models\\Receipt',4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',70239.70,NULL,NULL,1,'2022-08-09 09:23:14','2022-08-11 09:47:56','2022-08-11 09:47:56'),(4218,3022,40819,151533,3,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',60800.00,NULL,NULL,1,'2022-08-09 10:44:06','2022-08-11 09:03:13','2022-08-11 09:03:13'),(4219,3022,40819,151533,3,4045,'App\\Models\\Receipt',4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6600.05,NULL,NULL,1,'2022-08-11 09:54:40','2022-08-11 09:54:40',NULL),(4220,3022,40819,151533,3,4046,'App\\Models\\Receipt',4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',39999.00,NULL,NULL,1,'2022-08-11 09:54:40','2022-08-11 09:54:40',NULL),(4221,3022,40819,151533,3,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3000.00,NULL,NULL,1,'2022-08-11 09:54:40','2022-08-11 09:54:40',NULL),(4222,3022,40819,151533,3,4048,'App\\Models\\Receipt',4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',70000.00,NULL,NULL,1,'2022-08-11 09:54:40','2022-08-11 09:54:40',NULL);
INSERT INTO `balance_libro` VALUES (4223,3022,40819,151533,3,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',6600.05,NULL,NULL,1,'2022-08-11 09:54:40','2022-08-11 09:54:40',NULL),(4224,3022,40819,151533,3,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',25199.46,NULL,NULL,1,'2022-08-11 09:54:40','2022-08-11 09:54:40',NULL),(4225,3022,40819,151533,3,4051,'App\\Models\\Receipt',4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3179.00,NULL,NULL,1,'2022-08-11 09:54:40','2022-08-11 09:54:40',NULL),(4226,3022,40819,151533,3,4052,'App\\Models\\Receipt',4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',60800.00,NULL,NULL,1,'2022-08-11 09:54:40','2022-08-11 09:54:40',NULL),(4227,3022,40819,151533,3,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3340.91,NULL,NULL,1,'2022-08-11 09:54:41','2022-08-11 09:54:41',NULL),(4228,3022,40819,151533,3,4054,'App\\Models\\Receipt',4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5482.74,NULL,NULL,1,'2022-08-11 09:54:41','2022-08-11 09:54:41',NULL),(4229,3022,40819,151533,3,4055,'App\\Models\\Receipt',4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',15000.03,NULL,NULL,1,'2022-08-11 09:54:41','2022-08-11 09:54:41',NULL),(4230,3022,40819,151533,3,4056,'App\\Models\\Receipt',4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',24000.00,NULL,NULL,1,'2022-08-11 09:54:41','2022-08-11 09:54:41',NULL),(4231,3022,40819,151533,3,4057,'App\\Models\\Receipt',4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3750.00,NULL,NULL,1,'2022-08-11 09:54:41','2022-08-11 09:54:41',NULL),(4232,3022,40819,151533,3,4058,'App\\Models\\Receipt',4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1800.00,NULL,NULL,1,'2022-08-11 09:54:41','2022-08-11 09:54:41',NULL),(4233,3022,40819,151533,3,4059,'App\\Models\\Receipt',4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',648.00,NULL,NULL,1,'2022-08-11 09:54:41','2022-08-11 09:54:41',NULL),(4234,3022,40819,151533,3,4060,'App\\Models\\Receipt',4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',70239.70,NULL,NULL,1,'2022-08-11 09:54:41','2022-08-11 09:54:41',NULL),(4235,3022,40819,151533,2,4061,'App\\Models\\Receipt',4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1100000.00,NULL,NULL,1,'2022-08-11 11:14:39','2022-08-11 11:14:39',NULL),(4236,3022,40819,151533,2,4062,'App\\Models\\Receipt',4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',351000.00,NULL,NULL,1,'2022-08-11 11:14:39','2022-08-11 11:14:39',NULL),(4237,3022,40819,151533,2,4063,'App\\Models\\Receipt',4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22687.50,NULL,NULL,1,'2022-08-11 11:14:39','2022-08-11 11:14:39',NULL),(4238,3022,40819,151533,2,4064,'App\\Models\\Receipt',4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',106262.20,NULL,NULL,1,'2022-08-11 11:14:39','2022-08-11 11:14:39',NULL),(4239,3022,40819,151533,2,4065,'App\\Models\\Receipt',4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',29040.00,NULL,NULL,1,'2022-08-11 11:14:39','2022-08-11 11:14:39',NULL),(4240,3022,41024,175567,2,4066,'App\\Models\\Receipt',4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',965.58,NULL,NULL,1,'2022-08-12 11:19:32','2022-08-12 11:19:32',NULL),(4241,3022,41024,175567,2,4067,'App\\Models\\Receipt',4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',49482.95,NULL,NULL,1,'2022-08-12 11:19:32','2022-08-12 11:19:32',NULL),(4242,3022,41024,175567,2,4068,'App\\Models\\Receipt',4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',34170.40,NULL,NULL,1,'2022-08-12 11:19:32','2022-08-12 11:19:32',NULL);
INSERT INTO `balance_libro` VALUES (4243,3022,41024,175567,2,4069,'App\\Models\\Receipt',4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',34557.60,NULL,NULL,1,'2022-08-12 11:19:32','2022-08-12 11:19:32',NULL),(4244,3022,41024,175567,2,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',11947.54,NULL,NULL,1,'2022-08-12 11:19:32','2022-08-12 11:19:32',NULL),(4245,3022,41024,175567,2,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',34170.40,NULL,NULL,1,'2022-08-12 11:19:32','2022-08-12 11:19:32',NULL),(4246,3022,41024,175567,2,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',66180.95,NULL,NULL,1,'2022-08-12 11:19:32','2022-08-12 11:19:32',NULL),(4247,3022,41024,175567,2,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',21876.80,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4248,3022,41024,175567,2,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',21005.60,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4249,3022,41024,175567,2,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',10973.49,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4250,3022,41024,175567,2,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',16274.50,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4251,3022,41024,175567,2,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',22990.00,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4252,3022,41024,175567,2,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',22990.00,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4253,3022,41024,175567,2,4079,'App\\Models\\Receipt',4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',22990.00,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4254,3022,41024,175567,2,4080,'App\\Models\\Receipt',4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',10769.00,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4255,3022,41024,175567,2,4081,'App\\Models\\Receipt',4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',388834.50,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4256,3022,41024,175567,2,4082,'App\\Models\\Receipt',4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',13840.04,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4257,3022,41024,175567,2,4083,'App\\Models\\Receipt',4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',6655.00,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4258,3022,41024,175567,2,4084,'App\\Models\\Receipt',4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',6655.00,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4259,3022,41024,175567,2,4085,'App\\Models\\Receipt',4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3025.00,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4260,3022,41024,175567,2,4086,'App\\Models\\Receipt',4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',13128.50,NULL,NULL,1,'2022-08-12 11:19:33','2022-08-12 11:19:33',NULL),(4261,3022,41024,175567,3,4087,'App\\Models\\Receipt',4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4293.00,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4262,3022,41024,175567,3,4088,'App\\Models\\Receipt',4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',12971.95,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL);
INSERT INTO `balance_libro` VALUES (4263,3022,41024,175567,3,4089,'App\\Models\\Receipt',4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',1160.00,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4264,3022,41024,175567,3,4090,'App\\Models\\Receipt',4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2400.01,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4265,3022,41024,175567,3,4091,'App\\Models\\Receipt',4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5600.00,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4266,3022,41024,175567,3,4092,'App\\Models\\Receipt',4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1020.67,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4267,3022,41024,175567,3,4093,'App\\Models\\Receipt',4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',8191.13,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4268,3022,41024,175567,3,4094,'App\\Models\\Receipt',4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',18318.34,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4269,3022,41024,175567,3,4095,'App\\Models\\Receipt',4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3105.33,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4270,3022,41024,175567,3,4096,'App\\Models\\Receipt',4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3105.33,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4271,3022,41024,175567,3,4097,'App\\Models\\Receipt',4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3176.09,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4272,3022,41024,175567,3,4098,'App\\Models\\Receipt',4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2479.13,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4273,3022,41024,175567,3,4099,'App\\Models\\Receipt',4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1700.00,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4274,3022,41024,175567,3,4100,'App\\Models\\Receipt',4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',52760.84,NULL,NULL,1,'2022-08-17 09:34:12','2022-08-17 09:34:12',NULL),(4275,3022,41024,175567,3,4101,'App\\Models\\Receipt',4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4005.33,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4276,3022,41024,175567,3,4102,'App\\Models\\Receipt',4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3588.50,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4277,3022,41024,175567,3,4103,'App\\Models\\Receipt',4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',12800.02,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4278,3022,41024,175567,3,4104,'App\\Models\\Receipt',4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',10999.95,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4279,3022,41024,175567,3,4105,'App\\Models\\Receipt',4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',2000.05,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4280,3022,41024,175567,3,4106,'App\\Models\\Receipt',4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',9620.02,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4281,3022,41024,175567,3,4107,'App\\Models\\Receipt',4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',7099.96,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4282,3022,41024,175567,3,4108,'App\\Models\\Receipt',4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',4000.00,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL);
INSERT INTO `balance_libro` VALUES (4283,3022,41024,175567,3,4109,'App\\Models\\Receipt',4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2200.05,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4284,3022,41024,175567,3,4110,'App\\Models\\Receipt',4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1030.88,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4285,3022,41024,175567,3,4111,'App\\Models\\Receipt',4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1970.00,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4286,3022,41024,175567,3,4112,'App\\Models\\Receipt',4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1169.99,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4287,3022,41024,175567,3,4113,'App\\Models\\Receipt',4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1000.01,NULL,NULL,1,'2022-08-17 09:34:13','2022-08-17 09:34:13',NULL),(4288,3022,40939,173439,2,4114,'App\\Models\\Receipt',4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',157948.70,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4289,3022,40939,173439,2,4115,'App\\Models\\Receipt',4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',84532.50,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4290,3022,40939,173439,2,4116,'App\\Models\\Receipt',4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',315897.40,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4291,3022,40939,173439,2,4117,'App\\Models\\Receipt',4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',169065.00,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4292,3022,40939,173439,2,4118,'App\\Models\\Receipt',4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',199013.82,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4293,3022,40939,173439,2,4119,'App\\Models\\Receipt',4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',113722.18,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4294,3022,40939,173439,2,4120,'App\\Models\\Receipt',4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',227444.36,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4295,3022,40939,173439,2,4121,'App\\Models\\Receipt',4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',323997.05,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4296,3022,40939,173439,2,4122,'App\\Models\\Receipt',4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',323997.05,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4297,3022,40939,173439,2,4123,'App\\Models\\Receipt',4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',323997.05,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4298,3022,40939,173439,2,4124,'App\\Models\\Receipt',4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',194398.23,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4299,3022,40939,173439,2,4125,'App\\Models\\Receipt',4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',291598.45,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4300,3022,40939,173439,2,4126,'App\\Models\\Receipt',4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',145799.22,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4301,3022,40939,173439,2,4127,'App\\Models\\Receipt',4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',233278.76,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL),(4302,3022,40939,173439,2,4128,'App\\Models\\Receipt',4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',58319.69,NULL,NULL,1,'2022-08-23 09:23:02','2022-08-23 09:23:02',NULL);
INSERT INTO `balance_libro` VALUES (4303,3022,40939,173439,2,4129,'App\\Models\\Receipt',4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',291598.45,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4304,3022,40939,173439,2,4130,'App\\Models\\Receipt',4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',286736.45,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4305,3022,40939,173439,2,4131,'App\\Models\\Receipt',4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',286736.45,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4306,3022,40939,173439,2,4132,'App\\Models\\Receipt',4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',144826.83,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4307,3022,40939,173439,2,4133,'App\\Models\\Receipt',4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',143368.22,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4308,3022,40939,173439,2,4134,'App\\Models\\Receipt',4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',719272.12,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4309,3022,40939,173439,2,4135,'App\\Models\\Receipt',4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',286736.45,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4310,3022,40939,173439,2,4136,'App\\Models\\Receipt',4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',191162.79,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4311,3022,40939,173439,2,4137,'App\\Models\\Receipt',4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',191162.79,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4312,3022,40939,173439,2,4138,'App\\Models\\Receipt',4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',191162.79,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4313,3022,40939,173439,2,4139,'App\\Models\\Receipt',4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',191162.79,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4314,3022,40939,173439,2,4140,'App\\Models\\Receipt',4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',223023.26,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4315,3022,40939,173439,2,4141,'App\\Models\\Receipt',4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',172041.87,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4316,3022,40939,173439,2,4142,'App\\Models\\Receipt',4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',200715.52,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4317,3022,40939,173439,2,4143,'App\\Models\\Receipt',4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',172041.87,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4318,3022,40939,173439,2,4144,'App\\Models\\Receipt',4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',172041.87,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4319,3022,40939,173439,2,4145,'App\\Models\\Receipt',4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',194398.23,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4320,3022,40939,173439,2,4146,'App\\Models\\Receipt',4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',194398.23,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4321,3022,40939,173439,2,4147,'App\\Models\\Receipt',4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',194398.23,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4322,3022,40939,173439,2,4148,'App\\Models\\Receipt',4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',194398.23,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL);
INSERT INTO `balance_libro` VALUES (4323,3022,40939,173439,2,4149,'App\\Models\\Receipt',4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',194398.23,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4324,3022,40939,173439,2,4150,'App\\Models\\Receipt',4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',161998.52,NULL,NULL,1,'2022-08-23 09:23:03','2022-08-23 09:23:03',NULL),(4325,3022,40939,173439,2,4151,'App\\Models\\Receipt',4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',161998.52,NULL,NULL,1,'2022-08-23 09:23:04','2022-08-23 09:23:04',NULL),(4326,3022,40939,173439,2,4152,'App\\Models\\Receipt',4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',161998.52,NULL,NULL,1,'2022-08-23 09:23:04','2022-08-23 09:23:04',NULL),(4327,3022,40939,173439,2,4153,'App\\Models\\Receipt',4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',161998.52,NULL,NULL,1,'2022-08-23 09:23:04','2022-08-23 09:23:04',NULL),(4328,3022,40939,173439,2,4154,'App\\Models\\Receipt',4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',291598.45,NULL,NULL,1,'2022-08-23 09:23:04','2022-08-23 09:23:04',NULL),(4329,3022,40939,173439,2,4155,'App\\Models\\Receipt',4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',52487.72,NULL,NULL,1,'2022-08-23 09:23:04','2022-08-23 09:23:04',NULL),(4330,3022,40939,173439,2,4156,'App\\Models\\Receipt',4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',145799.22,NULL,NULL,1,'2022-08-23 09:23:04','2022-08-23 09:23:04',NULL),(4331,3022,40939,173439,2,4157,'App\\Models\\Receipt',4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',61460.10,NULL,NULL,1,'2022-08-23 09:23:04','2022-08-23 09:23:04',NULL),(4332,3022,40939,173439,3,4158,'App\\Models\\Receipt',4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',29902.00,NULL,NULL,1,'2022-08-23 10:35:16','2022-08-23 10:35:16',NULL),(4333,3022,40939,173439,3,4159,'App\\Models\\Receipt',4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2450.00,NULL,NULL,1,'2022-08-23 10:35:16','2022-08-23 10:35:16',NULL),(4334,3022,40939,173439,3,4160,'App\\Models\\Receipt',4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2700.01,NULL,NULL,1,'2022-08-23 10:35:16','2022-08-23 10:35:16',NULL),(4335,3022,40939,173439,3,4161,'App\\Models\\Receipt',4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',37200.00,NULL,NULL,1,'2022-08-23 10:35:16','2022-08-23 10:35:16',NULL),(4336,3022,40939,173439,3,4162,'App\\Models\\Receipt',4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',3325.24,NULL,NULL,1,'2022-08-23 10:35:16','2022-08-23 10:39:40','2022-08-23 10:39:40'),(4337,3022,40939,173439,3,4163,'App\\Models\\Receipt',4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',990.00,NULL,NULL,1,'2022-08-23 10:35:16','2022-08-23 10:35:16',NULL),(4338,3022,40939,173439,3,4164,'App\\Models\\Receipt',4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2239.99,NULL,NULL,1,'2022-08-23 10:35:17','2022-08-23 10:40:02','2022-08-23 10:40:02'),(4339,3022,40939,173439,3,4165,'App\\Models\\Receipt',4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',9800.00,NULL,NULL,1,'2022-08-23 10:35:17','2022-08-23 10:35:17',NULL),(4340,3022,40939,173439,3,4166,'App\\Models\\Receipt',4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7906.00,NULL,NULL,1,'2022-08-23 10:35:17','2022-08-23 10:35:17',NULL),(4341,3022,40939,173439,3,4167,'App\\Models\\Receipt',4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',10659.00,NULL,NULL,1,'2022-08-23 10:35:17','2022-08-23 10:40:29','2022-08-23 10:40:29'),(4342,3022,40939,173439,3,4168,'App\\Models\\Receipt',4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',10659.00,NULL,NULL,1,'2022-08-23 10:35:17','2022-08-23 10:40:42','2022-08-23 10:40:42');
INSERT INTO `balance_libro` VALUES (4343,3022,40939,173439,3,4169,'App\\Models\\Receipt',4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',1094.79,NULL,NULL,1,'2022-08-23 10:35:17','2022-08-23 10:40:57','2022-08-23 10:40:57'),(4344,3022,40939,173439,3,4170,'App\\Models\\Receipt',4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1560.00,NULL,NULL,1,'2022-08-23 10:35:17','2022-08-23 10:41:15','2022-08-23 10:41:15'),(4345,3022,40939,173439,3,4171,'App\\Models\\Receipt',4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',16203.91,NULL,NULL,1,'2022-08-23 10:45:04','2022-08-23 10:45:04',NULL),(4346,3022,40939,173439,3,4172,'App\\Models\\Receipt',4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5500.83,NULL,NULL,1,'2022-08-23 10:51:13','2022-08-23 10:51:13',NULL),(4347,3022,40939,173439,3,4173,'App\\Models\\Receipt',4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8799.94,NULL,NULL,1,'2022-08-23 10:52:23','2022-08-23 10:52:23',NULL),(4348,3022,40939,173439,3,4174,'App\\Models\\Receipt',4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5000.27,NULL,NULL,1,'2022-08-23 10:53:14','2022-08-23 10:53:14',NULL),(4349,3022,40939,173439,3,4175,'App\\Models\\Receipt',4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2490.00,NULL,NULL,1,'2022-08-23 10:54:07','2022-08-23 10:54:07',NULL),(4350,3022,40939,173439,3,4176,'App\\Models\\Receipt',4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6002.12,NULL,NULL,1,'2022-08-23 10:55:44','2022-08-23 10:55:44',NULL),(4351,3022,40939,173439,3,4177,'App\\Models\\Receipt',4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5599.95,NULL,NULL,1,'2022-08-23 10:56:56','2022-08-23 10:56:56',NULL),(4352,3022,40939,173439,3,4178,'App\\Models\\Receipt',4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1660.00,NULL,NULL,1,'2022-08-23 10:57:47','2022-08-23 10:57:47',NULL),(4353,3022,40939,173439,3,4179,'App\\Models\\Receipt',4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6499.46,NULL,NULL,1,'2022-08-23 10:58:42','2022-08-23 10:58:42',NULL),(4354,3022,40939,173439,3,4180,'App\\Models\\Receipt',4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5899.61,NULL,NULL,1,'2022-08-23 10:59:43','2022-08-23 10:59:43',NULL),(4355,3022,40939,173439,3,4181,'App\\Models\\Receipt',4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4801.88,NULL,NULL,1,'2022-08-23 11:00:35','2022-08-23 11:00:35',NULL),(4356,3022,40939,173439,3,4182,'App\\Models\\Receipt',4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',8000.44,NULL,NULL,1,'2022-08-23 11:01:16','2022-08-23 11:01:16',NULL),(4357,3022,40939,173439,3,4183,'App\\Models\\Receipt',4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',7200.75,NULL,NULL,1,'2022-08-23 11:02:14','2022-08-23 11:02:14',NULL),(4358,3022,40939,173439,3,4184,'App\\Models\\Receipt',4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1000.00,NULL,NULL,1,'2022-08-23 11:03:01','2022-08-23 11:03:01',NULL),(4359,3022,40939,173439,3,4185,'App\\Models\\Receipt',4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',7008.78,NULL,NULL,1,'2022-08-23 11:03:38','2022-08-23 11:03:38',NULL),(4360,3022,40939,173439,3,4186,'App\\Models\\Receipt',4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5000.45,NULL,NULL,1,'2022-08-23 11:04:36','2022-08-23 11:04:36',NULL),(4361,3022,40939,173439,3,4187,'App\\Models\\Receipt',4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8999.77,NULL,NULL,1,'2022-08-23 11:05:20','2022-08-23 11:05:20',NULL),(4362,3022,40939,173439,3,4188,'App\\Models\\Receipt',4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',19402.63,NULL,NULL,1,'2022-08-23 11:08:50','2022-08-23 11:14:58','2022-08-23 11:14:58');
INSERT INTO `balance_libro` VALUES (4363,3022,40939,173439,3,4189,'App\\Models\\Receipt',4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',18920.24,NULL,NULL,1,'2022-08-23 11:10:52','2022-08-23 11:14:44','2022-08-23 11:14:44'),(4364,3022,40939,173439,3,4190,'App\\Models\\Receipt',4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',21585.69,NULL,NULL,1,'2022-08-23 11:14:24','2022-08-23 11:14:24',NULL),(4365,3022,40939,173439,3,4189,'App\\Models\\Receipt',4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',18920.24,NULL,NULL,1,'2022-08-23 11:14:44','2022-08-23 11:14:44',NULL),(4366,3022,40939,173439,3,4188,'App\\Models\\Receipt',4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',19402.63,NULL,NULL,1,'2022-08-23 11:14:58','2022-08-23 11:14:58',NULL),(4367,3022,40939,173439,3,4191,'App\\Models\\Receipt',4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',1660.00,NULL,NULL,1,'2022-08-23 11:18:14','2022-08-23 11:18:14',NULL),(4368,3022,40939,173439,3,4192,'App\\Models\\Receipt',4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',7271.06,NULL,NULL,1,'2022-08-24 09:12:53','2022-08-24 09:12:53',NULL),(4369,3022,40939,173439,3,4193,'App\\Models\\Receipt',4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5000.45,NULL,NULL,1,'2022-08-24 09:14:10','2022-08-24 09:14:10',NULL),(4370,3022,40939,173439,3,4194,'App\\Models\\Receipt',4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3876712.39,NULL,NULL,1,'2022-08-24 09:16:43','2022-08-24 09:16:43',NULL),(4371,3022,40939,173439,3,4195,'App\\Models\\Receipt',4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3581896.17,NULL,NULL,1,'2022-08-24 09:17:33','2022-08-24 09:17:33',NULL),(4372,3022,40720,1549,2,4196,'App\\Models\\Receipt',4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',16984.07,NULL,NULL,1,'2022-09-07 11:03:55','2022-09-07 11:03:55',NULL),(4373,3022,40720,1549,2,4197,'App\\Models\\Receipt',4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',27488.94,NULL,NULL,1,'2022-09-07 11:05:17','2022-09-07 11:05:17',NULL),(4374,3022,40720,1549,2,4198,'App\\Models\\Receipt',4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',31446.96,NULL,NULL,1,'2022-09-07 11:06:24','2022-09-07 11:06:24',NULL),(4375,3022,40720,1549,2,4199,'App\\Models\\Receipt',4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',32626.06,NULL,NULL,1,'2022-09-07 11:09:31','2022-09-07 11:09:31',NULL),(4376,3022,40720,1549,2,4200,'App\\Models\\Receipt',4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',32012.91,NULL,NULL,1,'2022-09-07 11:10:41','2022-09-07 11:10:41',NULL),(4377,3022,40720,1549,2,4201,'App\\Models\\Receipt',4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',36224.98,NULL,NULL,1,'2022-09-07 11:13:27','2022-09-07 11:13:27',NULL),(4378,3022,40720,1549,2,4202,'App\\Models\\Receipt',4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',30127.97,NULL,NULL,1,'2022-09-07 11:14:23','2022-09-07 11:14:23',NULL),(4379,3022,40720,1549,2,4203,'App\\Models\\Receipt',4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',29447.98,NULL,NULL,1,'2022-09-07 11:17:43','2022-09-07 11:17:43',NULL),(4380,3022,40720,1549,2,4204,'App\\Models\\Receipt',4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',32701.30,NULL,NULL,1,'2022-09-07 11:18:30','2022-09-07 11:18:30',NULL),(4381,3022,40720,1549,2,4205,'App\\Models\\Receipt',4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',25249.80,NULL,NULL,1,'2022-09-07 11:20:11','2022-09-07 11:20:11',NULL),(4382,3022,40720,1549,2,4206,'App\\Models\\Receipt',4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',72127.19,NULL,NULL,1,'2022-09-07 11:21:35','2022-09-07 11:21:35',NULL);
INSERT INTO `balance_libro` VALUES (4383,3022,40720,1549,2,4207,'App\\Models\\Receipt',4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',57071.91,NULL,NULL,1,'2022-09-07 11:22:59','2022-09-07 11:22:59',NULL),(4384,3022,40720,1549,2,4208,'App\\Models\\Receipt',4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',33992.07,NULL,NULL,1,'2022-09-07 11:25:59','2022-09-07 11:25:59',NULL),(4385,3022,40720,1549,2,4209,'App\\Models\\Receipt',4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',17312.95,NULL,NULL,1,'2022-09-07 11:27:17','2022-09-07 11:27:17',NULL),(4386,3022,40720,1549,2,4210,'App\\Models\\Receipt',4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',15548.03,NULL,NULL,1,'2022-09-07 11:29:44','2022-09-07 11:29:44',NULL),(4387,3022,40720,1549,2,4211,'App\\Models\\Receipt',4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',24796.02,NULL,NULL,1,'2022-09-07 11:31:32','2022-09-07 11:31:32',NULL),(4388,3022,40720,1549,2,4212,'App\\Models\\Receipt',4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',12306.00,NULL,NULL,1,'2022-09-07 11:32:00','2022-09-07 11:32:00',NULL),(4389,3022,40720,1549,2,4213,'App\\Models\\Receipt',4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',0.01,NULL,NULL,1,'2022-09-07 11:32:22','2022-09-07 12:05:08','2022-09-07 12:05:08'),(4390,3022,40720,1549,2,4214,'App\\Models\\Receipt',4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',8238.89,NULL,NULL,1,'2022-09-07 12:01:10','2022-09-07 12:01:10',NULL),(4391,3022,40720,1549,2,4215,'App\\Models\\Receipt',4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',22923.01,NULL,NULL,1,'2022-09-07 12:01:46','2022-09-07 12:01:46',NULL),(4392,3022,40720,1549,2,4216,'App\\Models\\Receipt',4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',3827.00,NULL,NULL,1,'2022-09-07 12:02:45','2022-09-07 12:02:45',NULL),(4393,3022,40720,1549,2,4217,'App\\Models\\Receipt',4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',0.01,NULL,NULL,1,'2022-09-07 12:03:15','2022-09-07 12:05:17','2022-09-07 12:05:17'),(4394,3022,40720,1549,2,4218,'App\\Models\\Receipt',4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',0.01,NULL,NULL,1,'2022-09-07 12:03:26','2022-09-07 12:05:27','2022-09-07 12:05:27'),(4395,3022,40720,1549,2,4219,'App\\Models\\Receipt',4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',11763.06,NULL,NULL,1,'2022-09-07 12:07:07','2022-09-07 12:07:07',NULL),(4396,3022,40720,1549,2,4220,'App\\Models\\Receipt',4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',22190.06,NULL,NULL,1,'2022-09-07 12:08:58','2022-09-07 12:08:58',NULL),(4397,3022,40720,1549,2,4221,'App\\Models\\Receipt',4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-28','2022-08-28',13468.92,NULL,NULL,1,'2022-09-07 12:12:12','2022-09-07 12:12:12',NULL),(4398,3022,40720,1549,2,4222,'App\\Models\\Receipt',4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',6735.00,NULL,NULL,1,'2022-09-07 12:14:09','2022-09-07 12:14:09',NULL),(4399,3022,40720,1549,2,4223,'App\\Models\\Receipt',4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',11761.04,NULL,NULL,1,'2022-09-07 12:15:56','2022-09-07 12:15:56',NULL),(4400,3022,40720,1549,2,4224,'App\\Models\\Receipt',4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',26858.00,NULL,NULL,1,'2022-09-07 12:16:57','2022-09-07 12:16:57',NULL),(4401,3022,40720,1549,3,4225,'App\\Models\\Receipt',4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6899.00,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4402,3022,40720,1549,3,4226,'App\\Models\\Receipt',4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',83976.66,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL);
INSERT INTO `balance_libro` VALUES (4403,3022,40720,1549,3,4227,'App\\Models\\Receipt',4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',10678.23,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4404,3022,40720,1549,3,4228,'App\\Models\\Receipt',4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',11205.65,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4405,3022,40720,1549,3,4229,'App\\Models\\Receipt',4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',16154.15,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4406,3022,40720,1549,3,4230,'App\\Models\\Receipt',4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',6812.85,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4407,3022,40720,1549,3,4231,'App\\Models\\Receipt',4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',11157.43,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4408,3022,40720,1549,3,4232,'App\\Models\\Receipt',4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',14060.25,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4409,3022,40720,1549,3,4233,'App\\Models\\Receipt',4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',13435.80,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4410,3022,40720,1549,3,4234,'App\\Models\\Receipt',4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',7080.61,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4411,3022,40720,1549,3,4235,'App\\Models\\Receipt',4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',4441.75,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4412,3022,40720,1549,3,4236,'App\\Models\\Receipt',4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',7896.08,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4413,3022,40720,1549,3,4237,'App\\Models\\Receipt',4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',651.75,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4414,3022,40720,1549,3,4238,'App\\Models\\Receipt',4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',6248.02,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4415,3022,40720,1549,3,4239,'App\\Models\\Receipt',4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1704.42,NULL,NULL,1,'2022-09-16 10:57:43','2022-09-16 10:57:43',NULL),(4416,3022,40720,1549,3,4240,'App\\Models\\Receipt',4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',7080.61,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4417,3022,40720,1549,3,4241,'App\\Models\\Receipt',4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',8591.44,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4418,3022,40720,1549,3,4242,'App\\Models\\Receipt',4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',5985.08,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4419,3022,40720,1549,3,4243,'App\\Models\\Receipt',4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',79390.07,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4420,3022,40720,1549,3,4244,'App\\Models\\Receipt',4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',3402.00,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4421,3022,40720,1549,3,4245,'App\\Models\\Receipt',4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',876.19,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4422,3022,40720,1549,3,4246,'App\\Models\\Receipt',4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3041.43,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4423,3022,40720,1549,3,4247,'App\\Models\\Receipt',4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',4836.39,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL);
INSERT INTO `balance_libro` VALUES (4424,3022,40720,1549,3,4248,'App\\Models\\Receipt',4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',7803.88,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4425,3022,40720,1549,3,4249,'App\\Models\\Receipt',4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',23471.56,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4426,3022,40720,1549,3,4250,'App\\Models\\Receipt',4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',883.84,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4427,3022,40720,1549,3,4251,'App\\Models\\Receipt',4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',8231.08,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4428,3022,40720,1549,3,4252,'App\\Models\\Receipt',4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',6700.67,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4429,3022,40720,1549,3,4253,'App\\Models\\Receipt',4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1831.61,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4430,3022,40720,1549,3,4254,'App\\Models\\Receipt',4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',37625.88,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4431,3022,40720,1549,3,4255,'App\\Models\\Receipt',4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',9294.48,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4432,3022,40720,1549,3,4256,'App\\Models\\Receipt',4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',7583.39,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4433,3022,40720,1549,3,4257,'App\\Models\\Receipt',4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',74782.04,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4434,3022,40720,1549,3,4258,'App\\Models\\Receipt',4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1034.57,NULL,NULL,1,'2022-09-16 10:57:44','2022-09-16 10:57:44',NULL),(4435,3022,40720,1549,3,4259,'App\\Models\\Receipt',4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',10525.93,NULL,NULL,1,'2022-09-16 10:57:45','2022-09-16 10:57:45',NULL),(4436,3022,40720,1549,3,4260,'App\\Models\\Receipt',4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',0.00,NULL,NULL,1,'2022-09-16 10:57:45','2022-09-16 10:57:45',NULL),(4437,3022,40720,1549,3,4261,'App\\Models\\Receipt',4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',11091.42,NULL,NULL,1,'2022-09-16 10:57:45','2022-09-16 10:57:45',NULL),(4438,3022,40720,1549,3,4262,'App\\Models\\Receipt',4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5610.58,NULL,NULL,1,'2022-09-16 10:57:45','2022-09-16 10:57:45',NULL),(4439,3022,40720,1549,3,4263,'App\\Models\\Receipt',4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5898.68,NULL,NULL,1,'2022-09-16 10:57:45','2022-09-16 10:57:45',NULL),(4440,3022,40939,173440,2,4264,'App\\Models\\Receipt',4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',161998.52,NULL,NULL,1,'2022-09-21 11:32:30','2022-09-21 11:32:30',NULL),(4441,3022,40939,173440,2,4265,'App\\Models\\Receipt',4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',207359.88,NULL,NULL,1,'2022-09-21 11:32:30','2022-09-21 11:32:30',NULL),(4442,3022,40939,173440,2,4266,'App\\Models\\Receipt',4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',291598.45,NULL,NULL,1,'2022-09-21 11:32:30','2022-09-21 11:32:30',NULL),(4443,3022,40939,173440,2,4267,'App\\Models\\Receipt',4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',323997.05,NULL,NULL,1,'2022-09-21 11:32:30','2022-09-21 11:32:30',NULL),(4444,3022,40939,173440,2,4268,'App\\Models\\Receipt',4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',195131.30,NULL,NULL,1,'2022-09-21 11:32:30','2022-09-21 11:32:30',NULL);
INSERT INTO `balance_libro` VALUES (4445,3022,40939,173440,2,4269,'App\\Models\\Receipt',4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',174959.07,NULL,NULL,1,'2022-09-21 11:32:30','2022-09-21 11:32:30',NULL),(4446,3022,40939,173440,2,4270,'App\\Models\\Receipt',4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',204119.02,NULL,NULL,1,'2022-09-21 11:32:31','2022-09-21 11:32:31',NULL),(4447,3022,40939,173440,2,4271,'App\\Models\\Receipt',4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',87479.64,NULL,NULL,1,'2022-09-21 11:32:31','2022-09-21 11:32:31',NULL),(4448,3022,40939,173440,2,4272,'App\\Models\\Receipt',4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',691199.60,NULL,NULL,1,'2022-09-21 11:32:31','2022-09-21 11:32:31',NULL),(4449,3022,4