-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-20614390-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-06 15:04:06','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-06 15:04:06','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'gabdala2010@gmail.com','2604390533',NULL,1,40719,'2024-04-02'),(2,'gabdala2010@gmail.com','2604390533','',1,40719,'2024-04-02');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12363 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7928,40720,1612,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',194615.19,NULL,NULL,1,'2023-02-09 19:32:41','2023-02-09 19:32:41',NULL),(2,7928,40720,1612,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',396880.00,NULL,NULL,1,'2023-02-09 19:33:42','2023-02-09 19:33:42',NULL),(3,7928,40720,1612,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',916581.72,NULL,NULL,1,'2023-02-09 19:35:37','2023-02-09 19:35:37',NULL),(4,7928,40720,1612,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',212525.71,NULL,NULL,1,'2023-02-09 19:38:56','2023-02-09 19:38:56',NULL),(5,7928,40720,1612,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1442334.39,NULL,NULL,1,'2023-02-09 19:40:15','2023-02-09 19:40:15',NULL),(6,7928,40723,3187,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',867570.00,NULL,NULL,1,'2023-02-09 20:04:34','2023-02-09 20:04:34',NULL),(7,7928,40723,3187,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',260271.00,NULL,NULL,1,'2023-02-09 20:05:43','2023-02-09 20:05:43',NULL),(8,7928,40723,3187,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',163955.00,NULL,NULL,1,'2023-02-09 20:07:20','2023-02-09 20:07:20',NULL),(9,7928,40723,3187,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',163955.00,NULL,NULL,1,'2023-02-09 20:07:45','2023-02-09 20:07:45',NULL),(10,7928,40723,3187,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',163955.00,NULL,NULL,1,'2023-02-09 20:08:09','2023-02-09 20:08:09',NULL),(11,7928,40725,4837,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3900.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(12,7928,40725,4837,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(13,7928,40725,4837,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',21900.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(14,7928,40725,4837,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8900.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(15,7928,40725,4837,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(16,7928,40725,4837,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(17,7928,40725,4837,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',13900.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(18,7928,40725,4837,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',15000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(19,7928,40725,4837,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',14900.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(20,7928,40725,4837,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',22000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(21,7928,40725,4837,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',10900.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL);
INSERT INTO `balance_libro` VALUES (22,7928,40725,4837,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(23,7928,40725,4837,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(24,7928,40725,4837,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',15900.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(25,7928,40725,4837,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7900.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(26,7928,40725,4837,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',9000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(27,7928,40725,4837,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',28800.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(28,7928,40725,4837,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6800.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(29,7928,40725,4837,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(30,7928,40725,4837,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(31,7928,40725,4837,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',18000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(32,7928,40725,4837,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',21000.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(33,7928,40725,4837,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7500.00,NULL,NULL,1,'2023-02-10 18:04:12','2023-02-10 18:04:12',NULL),(34,7928,40725,4837,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7500.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(35,7928,40725,4837,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',9900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(36,7928,40725,4837,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12890.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(37,7928,40725,4837,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(38,7928,40725,4837,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',9900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(39,7928,40725,4837,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(40,7928,40725,4837,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',30000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(41,7928,40725,4837,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',10900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(42,7928,40725,4837,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL);
INSERT INTO `balance_libro` VALUES (43,7928,40725,4837,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',19000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(44,7928,40725,4837,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(45,7928,40725,4837,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',10000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(46,7928,40725,4837,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(47,7928,40725,4837,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',13000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(48,7928,40725,4837,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(49,7928,40725,4837,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',14900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(50,7928,40725,4837,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',9000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(51,7928,40725,4837,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(52,7928,40725,4837,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',13000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(53,7928,40725,4837,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',22900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(54,7928,40725,4837,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(55,7928,40725,4837,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(56,7928,40725,4837,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(57,7928,40725,4837,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(58,7928,40725,4837,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(59,7928,40725,4837,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(60,7928,40725,4837,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(61,7928,40725,4837,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',14900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(62,7928,40725,4837,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',8900.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(63,7928,40725,4837,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',12000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL);
INSERT INTO `balance_libro` VALUES (64,7928,40725,4837,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',28000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(65,7928,40725,4837,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',22000.00,NULL,NULL,1,'2023-02-10 18:04:13','2023-02-10 18:04:13',NULL),(66,7928,40725,4837,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',20500.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(67,7928,40725,4837,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',10000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(68,7928,40725,4837,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',12900.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(69,7928,40725,4837,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',100.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(70,7928,40725,4837,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',100.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(71,7928,40725,4837,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',10000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(72,7928,40725,4837,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(73,7928,40725,4837,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',14900.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(74,7928,40725,4837,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5900.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(75,7928,40725,4837,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',9900.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(76,7928,40725,4837,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(77,7928,40725,4837,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',14000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(78,7928,40725,4837,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',28900.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(79,7928,40725,4837,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',12000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(80,7928,40725,4837,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(81,7928,40725,4837,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10900.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(82,7928,40725,4837,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(83,7928,40725,4837,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(84,7928,40725,4837,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',20000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL);
INSERT INTO `balance_libro` VALUES (85,7928,40725,4837,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8900.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(86,7928,40725,4837,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7800.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(87,7928,40725,4837,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',28600.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(88,7928,40725,4837,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',14900.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(89,7928,40725,4837,2,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',14900.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(90,7928,40725,4837,2,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5000.00,NULL,NULL,1,'2023-02-10 18:04:14','2023-02-10 18:04:14',NULL),(91,7928,40730,6458,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2030.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(92,7928,40730,6458,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',690.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(93,7928,40730,6458,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1780.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(94,7928,40730,6458,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1100.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(95,7928,40730,6458,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1400.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(96,7928,40730,6458,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1890.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(97,7928,40730,6458,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2230.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(98,7928,40730,6458,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3190.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(99,7928,40730,6458,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2340.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(100,7928,40730,6458,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',4150.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(101,7928,40730,6458,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2490.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(102,7928,40730,6458,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7750.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(103,7928,40730,6458,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1200.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(104,7928,40730,6458,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1200.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(105,7928,40730,6458,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2450.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL);
INSERT INTO `balance_libro` VALUES (106,7928,40730,6458,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2450.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(107,7928,40730,6458,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1400.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(108,7928,40730,6458,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2680.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(109,7928,40730,6458,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5590.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(110,7928,40730,6458,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',920.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(111,7928,40730,6458,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1150.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(112,7928,40730,6458,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2750.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(113,7928,40730,6458,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',690.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(114,7928,40730,6458,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5470.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(115,7928,40730,6458,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2590.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(116,7928,40730,6458,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1900.00,NULL,NULL,1,'2023-02-10 18:26:23','2023-02-10 18:26:23',NULL),(117,7928,40730,6458,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',790.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(118,7928,40730,6458,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1180.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(119,7928,40730,6458,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2130.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(120,7928,40730,6458,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',880.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(121,7928,40730,6458,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3400.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(122,7928,40730,6458,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4040.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(123,7928,40730,6458,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7170.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(124,7928,40730,6458,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',700.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(125,7928,40730,6458,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2340.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(126,7928,40730,6458,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7000.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL);
INSERT INTO `balance_libro` VALUES (127,7928,40730,6458,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1930.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(128,7928,40730,6458,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',390.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(129,7928,40730,6458,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4590.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(130,7928,40730,6458,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2990.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(131,7928,40730,6458,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',11550.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(132,7928,40730,6458,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',400.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(133,7928,40730,6458,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',10500.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(134,7928,40730,6458,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8165.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(135,7928,40730,6458,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1240.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(136,7928,40730,6458,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',13800.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(137,7928,40730,6458,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2540.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(138,7928,40730,6458,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',10540.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(139,7928,40730,6458,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7380.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(140,7928,40730,6458,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1660.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(141,7928,40730,6458,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8280.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(142,7928,40730,6458,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',690.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(143,7928,40730,6458,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6530.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(144,7928,40730,6458,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11350.00,NULL,NULL,1,'2023-02-10 18:26:24','2023-02-10 18:26:24',NULL),(145,7928,40730,6458,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',890.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(146,7928,40730,6458,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1080.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(147,7928,40730,6458,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1900.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL);
INSERT INTO `balance_libro` VALUES (148,7928,40730,6458,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7880.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(149,7928,40730,6458,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4500.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(150,7928,40730,6458,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12100.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(151,7928,40730,6458,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',900.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(152,7928,40730,6458,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3100.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(153,7928,40730,6458,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5450.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(154,7928,40730,6458,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2450.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(155,7928,40730,6458,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3260.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(156,7928,40730,6458,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3590.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(157,7928,40730,6458,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5290.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(158,7928,40730,6458,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2710.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(159,7928,40730,6458,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1780.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(160,7928,40730,6458,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11150.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(161,7928,40730,6458,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4340.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(162,7928,40730,6458,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1000.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(163,7928,40730,6458,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1290.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(164,7928,40730,6458,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',13300.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(165,7928,40730,6458,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6320.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(166,7928,40730,6458,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12090.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(167,7928,40730,6458,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12090.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(168,7928,40730,6458,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3580.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL);
INSERT INTO `balance_libro` VALUES (169,7928,40730,6458,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',780.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(170,7928,40730,6458,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4180.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(171,7928,40730,6458,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4500.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(172,7928,40730,6458,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',20100.00,NULL,NULL,1,'2023-02-10 18:26:25','2023-02-10 18:26:25',NULL),(173,7928,40730,6458,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1500.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(174,7928,40730,6458,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',900.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(175,7928,40730,6458,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1340.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(176,7928,40730,6458,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3290.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(177,7928,40730,6458,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3000.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(178,7928,40730,6458,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6300.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(179,7928,40730,6458,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6400.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(180,7928,40730,6458,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7360.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(181,7928,40730,6458,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3050.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(182,7928,40730,6458,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2200.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(183,7928,40730,6458,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4390.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(184,7928,40730,6458,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',15600.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(185,7928,40730,6458,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6100.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(186,7928,40730,6458,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5700.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(187,7928,40730,6458,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3500.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(188,7928,40730,6458,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2450.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(189,7928,40730,6458,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3240.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL);
INSERT INTO `balance_libro` VALUES (190,7928,40730,6458,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1400.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(191,7928,40730,6458,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10670.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(192,7928,40730,6458,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1500.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(193,7928,40730,6458,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2100.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(194,7928,40730,6458,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2900.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(195,7928,40730,6458,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4350.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(196,7928,40730,6458,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3170.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(197,7928,40730,6458,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4400.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(198,7928,40730,6458,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8240.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(199,7928,40730,6458,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7390.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(200,7928,40730,6458,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4390.00,NULL,NULL,1,'2023-02-10 18:26:26','2023-02-10 18:26:26',NULL),(201,7928,40730,6458,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7900.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(202,7928,40730,6458,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1500.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(203,7928,40730,6458,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',9180.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(204,7928,40730,6458,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5500.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(205,7928,40730,6458,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1770.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(206,7928,40730,6458,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5470.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(207,7928,40730,6458,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',19000.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(208,7928,40730,6458,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1040.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(209,7928,40730,6458,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4950.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(210,7928,40730,6458,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3870.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL);
INSERT INTO `balance_libro` VALUES (211,7928,40730,6458,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4630.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(212,7928,40730,6458,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2500.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(213,7928,40730,6458,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3500.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(214,7928,40730,6458,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5000.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(215,7928,40730,6458,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2600.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(216,7928,40730,6458,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1330.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(217,7928,40730,6458,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6690.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(218,7928,40730,6458,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3240.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(219,7928,40730,6458,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4600.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(220,7928,40730,6458,2,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13190.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(221,7928,40730,6458,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3190.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(222,7928,40730,6458,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1440.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(223,7928,40730,6458,2,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6100.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(224,7928,40730,6458,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6140.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(225,7928,40730,6458,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2800.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(226,7928,40730,6458,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2590.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(227,7928,40730,6458,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3200.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(228,7928,40730,6458,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2180.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(229,7928,40730,6458,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',9600.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(230,7928,40730,6458,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4130.00,NULL,NULL,1,'2023-02-10 18:26:27','2023-02-10 18:26:27',NULL),(231,7928,40730,6458,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1200.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL);
INSERT INTO `balance_libro` VALUES (232,7928,40730,6458,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8160.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(233,7928,40730,6458,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1700.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(234,7928,40730,6458,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5700.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(235,7928,40730,6458,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',320.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(236,7928,40730,6458,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',850.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(237,7928,40730,6458,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6200.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(238,7928,40730,6458,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8250.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(239,7928,40730,6458,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3780.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(240,7928,40730,6458,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1920.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(241,7928,40730,6458,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2900.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(242,7928,40730,6458,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8200.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(243,7928,40730,6458,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8180.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(244,7928,40730,6458,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4270.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(245,7928,40730,6458,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3900.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(246,7928,40730,6458,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',14800.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(247,7928,40730,6458,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5490.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(248,7928,40730,6458,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10370.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(249,7928,40730,6458,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',9300.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(250,7928,40730,6458,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',900.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(251,7928,40730,6458,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4390.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(252,7928,40730,6458,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5570.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL);
INSERT INTO `balance_libro` VALUES (253,7928,40730,6458,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6030.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(254,7928,40730,6458,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5600.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(255,7928,40730,6458,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2400.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(256,7928,40730,6458,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3850.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(257,7928,40730,6458,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3800.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(258,7928,40730,6458,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5190.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(259,7928,40730,6458,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2500.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(260,7928,40730,6458,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1840.00,NULL,NULL,1,'2023-02-10 18:26:28','2023-02-10 18:26:28',NULL),(261,7928,40730,6458,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1900.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(262,7928,40730,6458,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3800.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(263,7928,40730,6458,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7140.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(264,7928,40730,6458,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4990.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(265,7928,40730,6458,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7490.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(266,7928,40730,6458,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4290.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(267,7928,40730,6458,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2720.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(268,7928,40730,6458,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3140.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(269,7928,40730,6458,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2370.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(270,7928,40730,6458,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8540.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(271,7928,40730,6458,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2660.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(272,7928,40730,6458,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5410.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(273,7928,40730,6458,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1090.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL);
INSERT INTO `balance_libro` VALUES (274,7928,40730,6458,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1800.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(275,7928,40730,6458,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3480.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(276,7928,40730,6458,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4800.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(277,7928,40730,6458,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3220.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(278,7928,40730,6458,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3370.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(279,7928,40730,6458,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5000.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(280,7928,40730,6458,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3800.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(281,7928,40730,6458,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8000.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(282,7928,40730,6458,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3800.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(283,7928,40730,6458,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5400.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(284,7928,40730,6458,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',980.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(285,7928,40730,6458,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7370.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(286,7928,40730,6458,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7100.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(287,7928,40730,6458,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1270.00,NULL,NULL,1,'2023-02-10 18:26:29','2023-02-10 18:26:29',NULL),(288,7928,40730,6458,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',19390.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(289,7928,40730,6458,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4280.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(290,7928,40730,6458,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5980.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(291,7928,40730,6458,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6500.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(292,7928,40730,6458,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5650.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(293,7928,40730,6458,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',690.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(294,7928,40730,6458,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5900.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL);
INSERT INTO `balance_libro` VALUES (295,7928,40730,6458,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5890.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(296,7928,40730,6458,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2800.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(297,7928,40730,6458,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',12200.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(298,7928,40730,6458,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3790.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(299,7928,40730,6458,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2090.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(300,7928,40730,6458,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3590.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(301,7928,40730,6458,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1600.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(302,7928,40730,6458,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',12600.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(303,7928,40730,6458,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8800.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(304,7928,40730,6458,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1200.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(305,7928,40730,6458,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5890.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(306,7928,40730,6458,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5900.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(307,7928,40730,6458,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3500.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(308,7928,40730,6458,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5650.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(309,7928,40730,6458,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3600.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(310,7928,40730,6458,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1600.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(311,7928,40730,6458,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3350.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(312,7928,40730,6458,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10400.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(313,7928,40730,6458,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4170.00,NULL,NULL,1,'2023-02-10 18:26:30','2023-02-10 18:26:30',NULL),(314,7928,40730,6458,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',890.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(315,7928,40730,6458,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2900.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL);
INSERT INTO `balance_libro` VALUES (316,7928,40730,6458,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4080.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(317,7928,40730,6458,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11730.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(318,7928,40730,6458,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1780.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(319,7928,40730,6458,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4670.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(320,7928,40730,6458,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3740.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(321,7928,40730,6458,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',16590.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(322,7928,40730,6458,2,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3500.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(323,7928,40730,6458,2,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5300.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(324,7928,40730,6458,2,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',8490.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(325,7928,40730,6458,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3430.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(326,7928,40730,6458,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14790.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(327,7928,40730,6458,2,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2800.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(328,7928,40730,6458,2,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',9760.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(329,7928,40730,6458,2,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4950.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(330,7928,40730,6458,2,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3940.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(331,7928,40730,6458,2,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10360.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(332,7928,40730,6458,2,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1960.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(333,7928,40730,6458,2,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',7400.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(334,7928,40730,6458,2,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4890.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(335,7928,40730,6458,2,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2600.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(336,7928,40730,6458,2,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1900.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL);
INSERT INTO `balance_libro` VALUES (337,7928,40730,6458,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3200.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(338,7928,40730,6458,2,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1360.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(339,7928,40730,6458,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10330.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(340,7928,40730,6458,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2900.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(341,7928,40730,6458,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',590.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(342,7928,40730,6458,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1890.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(343,7928,40730,6458,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5200.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(344,7928,40730,6458,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3300.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(345,7928,40730,6458,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1380.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(346,7928,40730,6458,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5000.00,NULL,NULL,1,'2023-02-10 18:26:31','2023-02-10 18:26:31',NULL),(347,7928,40730,6458,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3120.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(348,7928,40730,6458,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10420.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(349,7928,40730,6458,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1580.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(350,7928,40730,6458,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1850.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(351,7928,40730,6458,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5440.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(352,7928,40730,6458,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4750.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(353,7928,40730,6458,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',13200.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(354,7928,40730,6458,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2600.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(355,7928,40730,6458,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2400.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(356,7928,40730,6458,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6080.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(357,7928,40730,6458,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2500.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL);
INSERT INTO `balance_libro` VALUES (358,7928,40730,6458,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6790.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(359,7928,40730,6458,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4690.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(360,7928,40730,6458,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',840.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(361,7928,40730,6458,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',9200.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(362,7928,40730,6458,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3010.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(363,7928,40730,6458,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',580.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(364,7928,40730,6458,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4500.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(365,7928,40730,6458,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',830.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(366,7928,40730,6458,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2390.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(367,7928,40730,6458,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3600.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(368,7928,40730,6458,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6450.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(369,7928,40730,6458,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1830.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(370,7928,40730,6458,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3900.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(371,7928,40730,6458,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4760.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(372,7928,40730,6458,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2990.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(373,7928,40730,6458,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6900.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(374,7928,40730,6458,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6900.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(375,7928,40730,6458,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',9700.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(376,7928,40730,6458,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2600.00,NULL,NULL,1,'2023-02-10 18:26:32','2023-02-10 18:26:32',NULL),(377,7928,40730,6458,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5500.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(378,7928,40730,6458,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3900.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL);
INSERT INTO `balance_libro` VALUES (379,7928,40730,6458,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6690.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(380,7928,40730,6458,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3740.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(381,7928,40730,6458,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2770.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(382,7928,40730,6458,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3870.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(383,7928,40730,6458,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1510.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(384,7928,40730,6458,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',980.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(385,7928,40730,6458,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',9380.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(386,7928,40730,6458,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1790.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(387,7928,40730,6458,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',8900.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(388,7928,40730,6458,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2400.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(389,7928,40730,6458,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1600.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(390,7928,40730,6458,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1000.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(391,7928,40730,6458,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1200.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(392,7928,40730,6458,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3360.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(393,7928,40730,6458,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1400.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(394,7928,40730,6458,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2500.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(395,7928,40730,6458,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3000.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(396,7928,40730,6458,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2090.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(397,7928,40730,6458,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1450.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(398,7928,40730,6458,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2140.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(399,7928,40730,6458,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',13890.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL);
INSERT INTO `balance_libro` VALUES (400,7928,40730,6458,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2700.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(401,7928,40730,6458,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2670.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(402,7928,40730,6458,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1750.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(403,7928,40730,6458,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2170.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(404,7928,40730,6458,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',890.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(405,7928,40730,6458,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2130.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(406,7928,40730,6458,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3500.00,NULL,NULL,1,'2023-02-10 18:26:33','2023-02-10 18:26:33',NULL),(407,7928,40730,6458,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4350.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(408,7928,40730,6458,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2000.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(409,7928,40730,6458,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5850.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(410,7928,40730,6458,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6500.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(411,7928,40730,6458,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',10690.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(412,7928,40730,6458,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1430.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(413,7928,40730,6458,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1780.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(414,7928,40730,6458,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1510.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(415,7928,40730,6458,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9580.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(416,7928,40730,6458,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4850.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(417,7928,40730,6458,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2590.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(418,7928,40730,6458,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4780.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(419,7928,40730,6458,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5100.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(420,7928,40730,6458,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',13430.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL);
INSERT INTO `balance_libro` VALUES (421,7928,40730,6458,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3760.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(422,7928,40730,6458,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3400.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(423,7928,40730,6458,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1200.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(424,7928,40730,6458,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1200.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(425,7928,40730,6458,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',890.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(426,7928,40730,6458,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1200.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(427,7928,40730,6458,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',750.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(428,7928,40730,6458,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2050.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(429,7928,40730,6458,2,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3140.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(430,7928,40730,6458,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',7310.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(431,7928,40730,6458,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4600.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(432,7928,40730,6458,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1190.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(433,7928,40730,6458,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1080.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(434,7928,40730,6458,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1930.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(435,7928,40730,6458,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4000.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(436,7928,40730,6458,2,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',550.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(437,7928,40730,6458,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',16320.00,NULL,NULL,1,'2023-02-10 18:26:34','2023-02-10 18:26:34',NULL),(438,7928,40730,6458,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',790.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(439,7928,40730,6458,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1180.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(440,7928,40730,6458,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',790.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(441,7928,40730,6458,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6150.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL);
INSERT INTO `balance_libro` VALUES (442,7928,40730,6458,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2330.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(443,7928,40730,6458,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2900.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(444,7928,40730,6458,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1000.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(445,7928,40730,6458,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2500.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(446,7928,40730,6458,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3520.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(447,7928,40730,6458,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3060.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(448,7928,40730,6458,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2400.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(449,7928,40730,6458,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',900.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(450,7928,40730,6458,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',990.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(451,7928,40730,6458,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',640.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(452,7928,40730,6458,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',700.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(453,7928,40730,6458,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5350.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(454,7928,40730,6458,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',690.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(455,7928,40730,6458,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5420.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(456,7928,40730,6458,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3990.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(457,7928,40730,6458,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2600.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(458,7928,40730,6458,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1240.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(459,7928,40730,6458,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3090.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(460,7928,40730,6458,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4270.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(461,7928,40730,6458,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4110.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(462,7928,40730,6458,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',790.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL);
INSERT INTO `balance_libro` VALUES (463,7928,40730,6458,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',390.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(464,7928,40730,6458,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1260.00,NULL,NULL,1,'2023-02-10 18:26:35','2023-02-10 18:26:35',NULL),(465,7928,40730,6458,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',470.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(466,7928,40730,6458,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1080.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(467,7928,40730,6458,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1140.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(468,7928,40730,6458,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1900.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(469,7928,40730,6458,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3380.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(470,7928,40730,6458,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3900.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(471,7928,40730,6458,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1250.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(472,7928,40730,6458,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',590.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(473,7928,40730,6458,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',990.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(474,7928,40730,6458,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1970.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(475,7928,40730,6458,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1230.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(476,7928,40730,6458,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4190.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(477,7928,40730,6458,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3600.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(478,7928,40730,6458,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5000.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(479,7928,40730,6458,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1430.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(480,7928,40730,6458,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1500.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(481,7928,40730,6458,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4590.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(482,7928,40730,6458,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',890.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(483,7928,40730,6458,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8600.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL);
INSERT INTO `balance_libro` VALUES (484,7928,40730,6458,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4110.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(485,7928,40730,6458,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3180.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(486,7928,40730,6458,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1200.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(487,7928,40730,6458,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3920.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(488,7928,40730,6458,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3050.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(489,7928,40730,6458,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2400.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(490,7928,40730,6458,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',690.00,NULL,NULL,1,'2023-02-10 18:26:36','2023-02-10 18:26:36',NULL),(491,7928,40730,6458,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',610.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(492,7928,40730,6458,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4290.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(493,7928,40730,6458,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',990.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(494,7928,40730,6458,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1900.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(495,7928,40730,6458,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',700.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(496,7928,40730,6458,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4180.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(497,7928,40730,6458,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3820.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(498,7928,40730,6458,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2500.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(499,7928,40730,6458,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1700.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(500,7928,40730,6458,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1900.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(501,7928,40730,6458,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1000.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(502,7928,40730,6458,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3500.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(503,7928,40730,6458,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1650.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(504,7928,40730,6458,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3490.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL);
INSERT INTO `balance_libro` VALUES (505,7928,40730,6458,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',890.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(506,7928,40730,6458,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4200.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(507,7928,40730,6458,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3900.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(508,7928,40730,6458,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1530.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(509,7928,40730,6458,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',450.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(510,7928,40730,6458,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',12800.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(511,7928,40730,6458,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2740.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(512,7928,40730,6458,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7050.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(513,7928,40730,6458,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1790.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(514,7928,40730,6458,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5700.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(515,7928,40730,6458,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3400.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(516,7928,40730,6458,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',900.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(517,7928,40730,6458,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3450.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(518,7928,40730,6458,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1900.00,NULL,NULL,1,'2023-02-10 18:26:37','2023-02-10 18:26:37',NULL),(519,7928,40730,6458,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',460.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(520,7928,40730,6458,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2050.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(521,7928,40730,6458,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',8250.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(522,7928,40730,6458,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1600.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(523,7928,40730,6458,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1140.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(524,7928,40730,6458,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',23500.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(525,7928,40730,6458,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',490.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL);
INSERT INTO `balance_libro` VALUES (526,7928,40730,6458,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6040.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(527,7928,40730,6458,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3800.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(528,7928,40730,6458,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2510.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(529,7928,40730,6458,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2070.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(530,7928,40730,6458,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3300.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(531,7928,40730,6458,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9580.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(532,7928,40730,6458,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1950.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(533,7928,40730,6458,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2700.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(534,7928,40730,6458,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1530.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(535,7928,40730,6458,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4500.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(536,7928,40730,6458,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2900.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(537,7928,40730,6458,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',10890.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(538,7928,40730,6458,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3900.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(539,7928,40730,6458,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2690.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(540,7928,40730,6458,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2600.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(541,7928,40730,6458,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',490.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(542,7928,40730,6458,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9330.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(543,7928,40730,6458,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2410.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(544,7928,40730,6458,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2380.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(545,7928,40730,6458,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1500.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL),(546,7928,40730,6458,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3880.00,NULL,NULL,1,'2023-02-10 18:26:38','2023-02-10 18:26:38',NULL);
INSERT INTO `balance_libro` VALUES (547,7928,40730,6458,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3000.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(548,7928,40730,6458,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2200.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(549,7928,40730,6458,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1150.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(550,7928,40730,6458,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1200.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(551,7928,40730,6458,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4140.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(552,7928,40730,6458,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',500.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(553,7928,40730,6458,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',6150.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(554,7928,40730,6458,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1280.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(555,7928,40730,6458,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9460.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(556,7928,40730,6458,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2030.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(557,7928,40730,6458,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7990.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(558,7928,40730,6458,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2330.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(559,7928,40730,6458,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2200.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(560,7928,40730,6458,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2250.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(561,7928,40730,6458,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3480.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(562,7928,40730,6458,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',380.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(563,7928,40730,6458,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3420.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(564,7928,40730,6458,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',290.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(565,7928,40730,6458,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',740.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(566,7928,40730,6458,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1080.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(567,7928,40730,6458,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3500.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL);
INSERT INTO `balance_libro` VALUES (568,7928,40730,6458,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2500.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(569,7928,40730,6458,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11700.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(570,7928,40730,6458,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2500.00,NULL,NULL,1,'2023-02-10 18:26:39','2023-02-10 18:26:39',NULL),(571,7928,40730,6458,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2400.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(572,7928,40730,6458,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4690.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(573,7928,40730,6458,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3850.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(574,7928,40730,6458,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5000.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(575,7928,40730,6458,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2390.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(576,7928,40730,6458,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3750.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(577,7928,40730,6458,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6800.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(578,7928,40730,6458,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3860.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(579,7928,40730,6458,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3590.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(580,7928,40730,6458,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5360.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(581,7928,40730,6458,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1200.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(582,7928,40730,6458,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2300.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(583,7928,40730,6458,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1000.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(584,7928,40730,6458,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',740.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(585,7928,40730,6458,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2020.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(586,7928,40730,6458,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8520.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(587,7928,40730,6458,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3180.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(588,7928,40730,6458,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',690.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL);
INSERT INTO `balance_libro` VALUES (589,7928,40730,6458,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',490.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(590,7928,40730,6458,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3900.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(591,7928,40730,6458,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1910.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(592,7928,40730,6458,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1250.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(593,7928,40730,6458,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',16640.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(594,7928,40730,6458,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1100.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(595,7928,40730,6458,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',300.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(596,7928,40730,6458,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',9440.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(597,7928,40730,6458,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2800.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(598,7928,40730,6458,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4470.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(599,7928,40730,6458,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',500.00,NULL,NULL,1,'2023-02-10 18:26:40','2023-02-10 18:26:40',NULL),(600,7928,40730,6458,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',6780.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(601,7928,40730,6458,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',450.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(602,7928,40730,6458,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',8090.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(603,7928,40730,6458,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2500.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(604,7928,40730,6458,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',690.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(605,7928,40730,6458,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5300.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(606,7928,40730,6458,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',690.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(607,7928,40730,6458,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3400.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(608,7928,40730,6458,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3100.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(609,7928,40730,6458,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3500.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL);
INSERT INTO `balance_libro` VALUES (610,7928,40730,6458,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2770.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(611,7928,40730,6458,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',900.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(612,7928,40730,6458,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',540.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(613,7928,40730,6458,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1140.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(614,7928,40730,6458,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',200.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(615,7928,40730,6458,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1200.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(616,7928,40730,6458,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2497.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(617,7928,40730,6458,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1280.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(618,7928,40730,6458,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',8520.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(619,7928,40730,6458,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',750.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(620,7928,40730,6458,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1580.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(621,7928,40730,6458,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',11530.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(622,7928,40730,6458,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4590.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(623,7928,40730,6458,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',950.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(624,7928,40730,6458,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1590.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(625,7928,40730,6458,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2320.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(626,7928,40730,6458,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3890.00,NULL,NULL,1,'2023-02-10 18:26:41','2023-02-10 18:26:41',NULL),(627,7928,40730,6458,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3990.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(628,7928,40730,6458,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',990.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(629,7928,40730,6458,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3580.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(630,7928,40730,6458,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4400.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL);
INSERT INTO `balance_libro` VALUES (631,7928,40730,6458,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1540.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(632,7928,40730,6458,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2340.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(633,7928,40730,6458,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3430.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(634,7928,40730,6458,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2400.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(635,7928,40730,6458,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2340.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(636,7928,40730,6458,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2150.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(637,7928,40730,6458,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1080.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(638,7928,40730,6458,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8300.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(639,7928,40730,6458,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',10940.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(640,7928,40730,6458,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',18350.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(641,7928,40730,6458,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1800.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(642,7928,40730,6458,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',7900.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(643,7928,40730,6458,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5010.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(644,7928,40730,6458,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3690.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(645,7928,40730,6458,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4590.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(646,7928,40730,6458,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2750.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(647,7928,40730,6458,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1500.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(648,7928,40730,6458,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2030.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(649,7928,40730,6458,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4250.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(650,7928,40730,6458,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1200.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(651,7928,40730,6458,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1220.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL);
INSERT INTO `balance_libro` VALUES (652,7928,40730,6458,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',750.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(653,7928,40730,6458,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',540.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(654,7928,40730,6458,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',400.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(655,7928,40730,6458,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2430.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(656,7928,40730,6458,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',865.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(657,7928,40730,6458,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4000.00,NULL,NULL,1,'2023-02-10 18:26:42','2023-02-10 18:26:42',NULL),(658,7928,40730,6458,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7900.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(659,7928,40730,6458,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1450.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(660,7928,40730,6458,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4000.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(661,7928,40730,6458,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3830.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(662,7928,40730,6458,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2500.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(663,7928,40730,6458,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2900.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(664,7928,40730,6458,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5490.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(665,7928,40730,6458,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6830.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(666,7928,40730,6458,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',20469.99,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(667,7928,40730,6458,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',620.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(668,7928,40730,6458,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2900.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(669,7928,40730,6458,2,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2200.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(670,7928,40730,6458,2,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',590.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(671,7928,40730,6458,2,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2500.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(672,7928,40730,6458,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4500.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL);
INSERT INTO `balance_libro` VALUES (673,7928,40730,6458,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3990.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(674,7928,40730,6458,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',11000.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(675,7928,40730,6458,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1900.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(676,7928,40730,6458,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3540.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(677,7928,40730,6458,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',11040.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(678,7928,40730,6458,2,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1900.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(679,7928,40730,6458,2,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',850.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(680,7928,40730,6458,2,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',10120.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(681,7928,40730,6458,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1200.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(682,7928,40730,6458,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',850.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(683,7928,40730,6458,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8950.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(684,7928,40730,6458,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4200.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(685,7928,40730,6458,2,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',7950.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(686,7928,40730,6458,2,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1780.00,NULL,NULL,1,'2023-02-10 18:26:43','2023-02-10 18:26:43',NULL),(687,7928,40730,6458,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6550.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(688,7928,40730,6458,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1200.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(689,7928,40730,6458,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2650.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(690,7928,40730,6458,2,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1800.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(691,7928,40730,6458,2,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',790.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(692,7928,40730,6458,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',200.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(693,7928,40730,6458,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2950.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL);
INSERT INTO `balance_libro` VALUES (694,7928,40730,6458,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',970.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(695,7928,40730,6458,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1740.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(696,7928,40730,6458,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2100.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(697,7928,40730,6458,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3560.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(698,7928,40730,6458,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3540.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(699,7928,40730,6458,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3150.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(700,7928,40730,6458,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9940.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(701,7928,40730,6458,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1480.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(702,7928,40730,6458,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',340.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(703,7928,40730,6458,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1080.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(704,7928,40730,6458,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2800.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(705,7928,40730,6458,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2200.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(706,7928,40730,6458,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',890.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(707,7928,40730,6458,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2450.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(708,7928,40730,6458,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1680.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(709,7928,40730,6458,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2260.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(710,7928,40730,6458,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2900.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(711,7928,40730,6458,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1700.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(712,7928,40730,6458,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2900.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(713,7928,40730,6458,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4500.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(714,7928,40730,6458,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1200.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL);
INSERT INTO `balance_libro` VALUES (715,7928,40730,6458,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1980.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(716,7928,40730,6458,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1140.00,NULL,NULL,1,'2023-02-10 18:26:44','2023-02-10 18:26:44',NULL),(717,7928,40730,6458,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',790.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(718,7928,40730,6458,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4070.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(719,7928,40730,6458,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4140.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(720,7928,40730,6458,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',14900.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(721,7928,40730,6458,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1770.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(722,7928,40730,6458,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1600.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(723,7928,40730,6458,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4650.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(724,7928,40730,6458,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1250.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(725,7928,40730,6458,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2500.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(726,7928,40730,6458,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2900.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(727,7928,40730,6458,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4590.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(728,7928,40730,6458,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',500.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(729,7928,40730,6458,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',150.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(730,7928,40730,6458,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',25542.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(731,7928,40730,6458,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1100.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(732,7928,40730,6458,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',840.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(733,7928,40730,6458,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',990.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(734,7928,40730,6458,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',7800.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(735,7928,40730,6458,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10000.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL);
INSERT INTO `balance_libro` VALUES (736,7928,40730,6458,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',740.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(737,7928,40730,6458,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',17200.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(738,7928,40730,6458,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3750.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(739,7928,40730,6458,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2550.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(740,7928,40730,6458,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',9500.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(741,7928,40730,6458,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',590.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(742,7928,40730,6458,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2390.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(743,7928,40730,6458,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',13190.00,NULL,NULL,1,'2023-02-10 18:26:45','2023-02-10 18:26:45',NULL),(744,7928,40730,6458,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2900.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(745,7928,40730,6458,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',980.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(746,7928,40730,6458,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',350.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(747,7928,40730,6458,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4700.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(748,7928,40730,6458,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1650.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(749,7928,40730,6458,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2590.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(750,7928,40730,6458,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6240.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(751,7928,40730,6458,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2870.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(752,7928,40730,6458,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2630.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(753,7928,40730,6458,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1930.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(754,7928,40730,6458,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',840.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(755,7928,40730,6458,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5870.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(756,7928,40730,6458,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2110.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL);
INSERT INTO `balance_libro` VALUES (757,7928,40730,6458,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2900.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(758,7928,40730,6458,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1010.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(759,7928,40730,6458,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',700.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(760,7928,40730,6458,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4390.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(761,7928,40730,6458,2,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',240.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(762,7928,40730,6458,2,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(763,7928,40730,6458,2,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4900.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(764,7928,40730,6458,2,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2240.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(765,7928,40730,6458,2,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(766,7928,40730,6458,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2350.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(767,7928,40730,6458,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',10650.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(768,7928,40730,6458,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12900.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(769,7928,40730,6458,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1600.00,NULL,NULL,1,'2023-02-10 18:26:46','2023-02-10 18:26:46',NULL),(770,7928,40730,6458,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3080.00,NULL,NULL,1,'2023-02-10 18:26:47','2023-02-10 18:26:47',NULL),(771,7928,40730,6458,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1700.00,NULL,NULL,1,'2023-02-10 18:26:47','2023-02-10 18:26:47',NULL),(772,7928,40730,6458,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3900.00,NULL,NULL,1,'2023-02-10 18:26:47','2023-02-10 18:26:47',NULL),(773,7928,40730,6458,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13540.00,NULL,NULL,1,'2023-02-10 18:26:47','2023-02-10 18:26:47',NULL),(774,7928,40730,6458,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',10650.00,NULL,NULL,1,'2023-02-10 18:26:47','2023-02-10 18:26:47',NULL),(775,7928,40730,6458,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1030.00,NULL,NULL,1,'2023-02-10 18:26:47','2023-02-10 18:26:47',NULL),(776,7928,40740,8111,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',9850.01,NULL,NULL,1,'2023-02-10 18:52:38','2023-02-10 18:52:38',NULL),(777,7928,40740,8111,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',171249.05,NULL,NULL,1,'2023-02-10 18:54:08','2023-02-10 18:54:08',NULL);
INSERT INTO `balance_libro` VALUES (778,7928,40740,8111,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',123030.00,NULL,NULL,1,'2023-02-10 19:05:26','2023-02-10 19:05:26',NULL),(779,7928,40740,8111,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',84050.00,NULL,NULL,1,'2023-02-10 19:06:08','2023-02-10 19:06:08',NULL),(780,7928,40740,8111,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',44650.00,NULL,NULL,1,'2023-02-10 19:07:06','2023-02-10 19:07:06',NULL),(781,7928,40740,8111,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',77490.00,NULL,NULL,1,'2023-02-10 19:08:29','2023-02-10 19:08:29',NULL),(782,7928,40740,8111,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',160945.00,NULL,NULL,1,'2023-02-10 19:09:13','2023-02-10 19:09:13',NULL),(783,7928,40740,8111,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',101245.00,NULL,NULL,1,'2023-02-10 19:09:53','2023-02-10 19:09:53',NULL),(784,7928,40740,8111,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',102100.01,NULL,NULL,1,'2023-02-10 19:10:26','2023-02-10 19:10:26',NULL),(785,7928,40740,8111,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',130210.00,NULL,NULL,1,'2023-02-10 19:11:06','2023-02-10 19:11:06',NULL),(786,7928,40740,8111,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',12770.00,NULL,NULL,1,'2023-02-10 19:11:32','2023-02-10 19:11:32',NULL),(787,7928,40740,8111,2,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',79480.00,NULL,NULL,1,'2023-02-10 19:12:14','2023-02-10 19:12:14',NULL),(788,7928,40740,8111,2,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',476683.03,NULL,NULL,1,'2023-02-10 19:12:52','2023-02-10 19:12:52',NULL),(789,7928,40740,8111,2,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',124350.01,NULL,NULL,1,'2023-02-10 19:13:27','2023-02-10 19:13:27',NULL),(790,7928,40740,8111,2,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',137190.01,NULL,NULL,1,'2023-02-10 19:14:32','2023-02-10 19:14:32',NULL),(791,7928,40740,8111,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',104590.00,NULL,NULL,1,'2023-02-10 19:15:33','2023-02-10 19:15:33',NULL),(792,7928,40740,8111,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',60650.00,NULL,NULL,1,'2023-02-10 19:17:59','2023-02-10 19:17:59',NULL),(793,7928,40740,8111,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',14625.00,NULL,NULL,1,'2023-02-10 19:18:18','2023-02-10 19:18:18',NULL),(794,7928,40740,8111,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',81683.00,NULL,NULL,1,'2023-02-10 19:18:52','2023-02-10 19:18:52',NULL),(795,7928,40740,8111,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',51800.00,NULL,NULL,1,'2023-02-10 19:19:37','2023-02-10 19:19:37',NULL),(796,7928,40740,8111,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',117900.00,NULL,NULL,1,'2023-02-10 19:20:14','2023-02-10 19:20:14',NULL),(797,7928,40740,8111,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',86960.00,NULL,NULL,1,'2023-02-10 19:23:44','2023-02-10 19:23:44',NULL),(798,7928,40740,8111,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',81280.00,NULL,NULL,1,'2023-02-10 19:24:25','2023-02-10 19:24:25',NULL);
INSERT INTO `balance_libro` VALUES (799,7928,40740,8111,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',71309.99,NULL,NULL,1,'2023-02-10 19:25:27','2023-02-10 19:25:27',NULL),(800,7928,40742,9764,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14799.99,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(801,7928,40742,9764,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',36100.06,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(802,7928,40742,9764,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1480.00,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(803,7928,40742,9764,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14799.99,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(804,7928,40742,9764,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',24880.03,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(805,7928,40742,9764,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7834.65,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(806,7928,40742,9764,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6126.41,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(807,7928,40742,9764,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',17305.92,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(808,7928,40742,9764,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2329.04,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(809,7928,40742,9764,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3237.14,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(810,7928,40742,9764,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',10201.18,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(811,7928,40742,9764,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3537.07,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(812,7928,40742,9764,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4239.97,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(813,7928,40742,9764,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5526.02,NULL,NULL,1,'2023-02-10 19:54:05','2023-02-10 19:54:05',NULL),(814,7928,40742,9764,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2444.68,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(815,7928,40742,9764,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7950.00,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(816,7928,40742,9764,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6157.00,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(817,7928,40742,9764,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4536.25,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(818,7928,40742,9764,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1720.00,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(819,7928,40742,9764,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',10320.02,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL);
INSERT INTO `balance_libro` VALUES (820,7928,40742,9764,2,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3109.35,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(821,7928,40742,9764,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',9276.72,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(822,7928,40742,9764,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',16389.99,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(823,7928,40742,9764,2,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7740.01,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(824,7928,40742,9764,2,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',28480.01,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(825,7928,40742,9764,2,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7800.01,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(826,7928,40742,9764,2,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8690.01,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(827,7928,40742,9764,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',15788.71,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(828,7928,40742,9764,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',45989.01,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(829,7928,40742,9764,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3899.99,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(830,7928,40742,9764,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',132865.72,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(831,7928,40742,9764,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11039.10,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(832,7928,40742,9764,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5276.00,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(833,7928,40742,9764,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4800.02,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(834,7928,40742,9764,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',9201.36,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(835,7928,40742,9764,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4239.97,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(836,7928,40742,9764,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',23950.00,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(837,7928,40742,9764,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',17296.73,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(838,7928,40742,9764,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3840.00,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(839,7928,40742,9764,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6670.34,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(840,7928,40742,9764,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10859.96,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL);
INSERT INTO `balance_libro` VALUES (841,7928,40742,9764,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',18297.40,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(842,7928,40742,9764,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7824.41,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(843,7928,40742,9764,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',11340.40,NULL,NULL,1,'2023-02-10 19:54:06','2023-02-10 19:54:06',NULL),(844,7928,40742,9764,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2750.00,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(845,7928,40742,9764,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4639.99,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(846,7928,40742,9764,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4948.07,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(847,7928,40742,9764,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',15609.35,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(848,7928,40742,9764,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8399.98,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(849,7928,40742,9764,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6093.38,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(850,7928,40742,9764,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4236.57,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(851,7928,40742,9764,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13402.69,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(852,7928,40742,9764,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',84125.07,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(853,7928,40742,9764,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',174129.98,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(854,7928,40742,9764,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',142303.58,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(855,7928,40742,9764,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',22982.42,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(856,7928,40742,9764,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7196.33,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(857,7928,40742,9764,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',63766.32,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(858,7928,40742,9764,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',74432.86,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(859,7928,40742,9764,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',99889.92,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(860,7928,40742,9764,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',25679.79,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(861,7928,40742,9764,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13580.77,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL);
INSERT INTO `balance_libro` VALUES (862,7928,40742,9764,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',69767.83,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(863,7928,40742,9764,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',37978.38,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(864,7928,40742,9764,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6360.00,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(865,7928,40742,9764,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1100.00,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(866,7928,40742,9764,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',16500.04,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(867,7928,40742,9764,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6099.96,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(868,7928,40742,9764,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',7054.00,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(869,7928,40742,9764,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3226.58,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(870,7928,40742,9764,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',860.00,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(871,7928,40742,9764,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14173.94,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(872,7928,40742,9764,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14173.94,NULL,NULL,1,'2023-02-10 19:54:07','2023-02-10 19:54:07',NULL),(873,7928,40742,9764,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',222.40,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(874,7928,40742,9764,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2245.59,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(875,7928,40742,9764,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',24239.99,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(876,7928,40742,9764,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2399.99,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(877,7928,40742,9764,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',9779.97,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(878,7928,40742,9764,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6000.00,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(879,7928,40742,9764,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',18602.95,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(880,7928,40742,9764,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',17589.99,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(881,7928,40742,9764,2,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1780.00,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(882,7928,40742,9764,2,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',13760.03,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL);
INSERT INTO `balance_libro` VALUES (883,7928,40742,9764,2,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',16669.98,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(884,7928,40742,9764,2,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',11210.21,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(885,7928,40742,9764,2,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6779.99,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(886,7928,40742,9764,2,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1780.00,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(887,7928,40742,9764,2,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',9350.57,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(888,7928,40742,9764,2,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',19000.99,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(889,7928,40742,9764,2,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',14749.97,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(890,7928,40742,9764,2,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',8303.37,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(891,7928,40742,9764,2,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2658.71,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(892,7928,40742,9764,2,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',4658.50,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(893,7928,40742,9764,2,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',25519.03,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(894,7928,40742,9764,2,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',85068.12,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(895,7928,40742,9764,2,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',10120.00,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(896,7928,40742,9764,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',7020.00,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(897,7928,40742,9764,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',22540.04,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(898,7928,40742,9764,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',4290.01,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(899,7928,40742,9764,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',4020.00,NULL,NULL,1,'2023-02-10 19:54:08','2023-02-10 19:54:08',NULL),(900,7928,40742,9764,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2380.00,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(901,7928,40742,9764,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6270.00,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(902,7928,40742,9764,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2988.42,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(903,7928,40742,9764,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2429.12,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL);
INSERT INTO `balance_libro` VALUES (904,7928,40742,9764,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',10733.62,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(905,7928,40742,9764,2,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',12120.00,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(906,7928,40742,9764,2,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',13420.44,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(907,7928,40742,9764,2,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1654.20,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(908,7928,40742,9764,2,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3230.00,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(909,7928,40742,9764,2,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4585.96,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(910,7928,40742,9764,2,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8751.36,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(911,7928,40742,9764,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',36808.35,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(912,7928,40742,9764,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8039.99,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(913,7928,40742,9764,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',48351.59,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(914,7928,40742,9764,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3416.79,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(915,7928,40742,9764,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',59399.93,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(916,7928,40742,9764,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',17119.99,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(917,7928,40742,9764,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',6009.98,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(918,7928,40742,9764,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',25810.00,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(919,7928,40742,9764,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5199.98,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(920,7928,40742,9764,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',11929.96,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(921,7928,40742,9764,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',11399.99,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(922,7928,40742,9764,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',12569.99,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(923,7928,40742,9764,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',11776.10,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(924,7928,40742,9764,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4620.00,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL);
INSERT INTO `balance_libro` VALUES (925,7928,40742,9764,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',22188.43,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(926,7928,40742,9764,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',10999.95,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(927,7928,40742,9764,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',160808.34,NULL,NULL,1,'2023-02-10 19:54:09','2023-02-10 19:54:09',NULL),(928,7928,40742,9764,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',34406.48,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(929,7928,40742,9764,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8289.02,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(930,7928,40742,9764,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8725.98,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(931,7928,40742,9764,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',38617.07,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(932,7928,40742,9764,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4297.25,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(933,7928,40742,9764,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4272.53,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(934,7928,40742,9764,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',6459.80,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(935,7928,40742,9764,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4076.78,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(936,7928,40742,9764,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8207.01,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(937,7928,40742,9764,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1480.00,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(938,7928,40742,9764,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1560.00,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(939,7928,40742,9764,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8854.45,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(940,7928,40742,9764,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5041.35,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(941,7928,40742,9764,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3363.30,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(942,7928,40742,9764,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',12800.00,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(943,7928,40742,9764,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1300.00,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(944,7928,40742,9764,2,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',30039.99,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(945,7928,40742,9764,2,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',22060.01,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL);
INSERT INTO `balance_libro` VALUES (946,7928,40742,9764,2,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',18440.39,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(947,7928,40742,9764,2,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',25969.35,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(948,7928,40742,9764,2,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8153.20,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(949,7928,40742,9764,2,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',24799.99,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(950,7928,40742,9764,2,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4306.06,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(951,7928,40742,9764,2,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7124.58,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(952,7928,40742,9764,2,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',30679.97,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(953,7928,40742,9764,2,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4870.00,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(954,7928,40742,9764,2,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4262.29,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(955,7928,40742,9764,2,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',20862.28,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(956,7928,40742,9764,2,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1329.35,NULL,NULL,1,'2023-02-10 19:54:10','2023-02-10 19:54:10',NULL),(957,7928,40742,9764,2,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',9679.98,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(958,7928,40742,9764,2,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',10859.98,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(959,7928,40742,9764,2,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',24500.02,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(960,7928,40742,9764,2,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',93049.97,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(961,7928,40742,9764,2,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',67870.45,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(962,7928,40742,9764,2,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',38316.18,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(963,7928,40742,9764,2,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4800.01,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(964,7928,40742,9764,2,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',94294.35,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(965,7928,40742,9764,2,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2650.54,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(966,7928,40742,9764,2,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14210.14,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL);
INSERT INTO `balance_libro` VALUES (967,7928,40742,9764,2,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10320.02,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(968,7928,40742,9764,2,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1780.00,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(969,7928,40742,9764,2,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3782.00,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(970,7928,40742,9764,2,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',7981.89,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(971,7928,40742,9764,2,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10599.96,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(972,7928,40742,9764,2,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1873.32,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(973,7928,40742,9764,2,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5160.01,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(974,7928,40742,9764,2,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',18000.08,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(975,7928,40742,9764,2,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2374.94,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(976,7928,40742,9764,2,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6709.99,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(977,7928,40742,9764,2,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6769.35,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(978,7928,40742,9764,2,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6419.99,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(979,7928,40742,9764,2,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',10530.00,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(980,7928,40742,9764,2,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',29390.01,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(981,7928,40742,9764,2,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',16750.01,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(982,7928,40742,9764,2,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6756.07,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(983,7928,40742,9764,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5139.99,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(984,7928,40742,9764,2,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',20499.97,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(985,7928,40742,9764,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',31009.98,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(986,7928,40742,9764,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3300.01,NULL,NULL,1,'2023-02-10 19:54:11','2023-02-10 19:54:11',NULL),(987,7928,40742,9764,2,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3080.00,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL);
INSERT INTO `balance_libro` VALUES (988,7928,40742,9764,2,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',9006.09,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(989,7928,40742,9764,2,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',25439.98,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(990,7928,40742,9764,2,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',74290.01,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(991,7928,40742,9764,2,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',19800.05,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(992,7928,40742,9764,2,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',16723.72,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(993,7928,40742,9764,2,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4350.01,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(994,7928,40742,9764,2,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7579.98,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(995,7928,40742,9764,2,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',17876.98,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(996,7928,40742,9764,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',16191.93,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(997,7928,40742,9764,2,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7715.78,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(998,7928,40742,9764,2,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',6136.03,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(999,7928,40742,9764,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5109.93,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1000,7928,40742,9764,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8208.24,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1001,7928,40742,9764,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9539.97,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1002,7928,40742,9764,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1780.00,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1003,7928,40742,9764,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2120.00,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1004,7928,40742,9764,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4278.54,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1005,7928,40742,9764,2,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5417.08,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1006,7928,40742,9764,2,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',15190.98,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1007,7928,40742,9764,2,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7930.00,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1008,7928,40742,9764,2,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',14610.00,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL);
INSERT INTO `balance_libro` VALUES (1009,7928,40742,9764,2,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7919.10,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1010,7928,40742,9764,2,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2424.67,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1011,7928,40742,9764,2,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3619.13,NULL,NULL,1,'2023-02-10 19:54:12','2023-02-10 19:54:12',NULL),(1012,7928,40742,9764,2,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',672.52,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1013,7928,40742,9764,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4648.60,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1014,7928,40742,9764,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4307.62,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1015,7928,40742,9764,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4177.43,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1016,7928,40742,9764,2,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2132.63,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1017,7928,40742,9764,2,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4729.16,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1018,7928,40742,9764,2,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',44757.85,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1019,7928,40742,9764,2,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',77423.80,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1020,7928,40742,9764,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7199.98,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1021,7928,40742,9764,2,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4190.00,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1022,7928,40742,9764,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',17680.00,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1023,7928,40742,9764,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11239.99,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1024,7928,40742,9764,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',17733.70,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1025,7928,40742,9764,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',8359.99,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1026,7928,40742,9764,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',17319.96,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1027,7928,40742,9764,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',26864.18,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1028,7928,40742,9764,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11617.92,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1029,7928,40742,9764,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1300.00,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL);
INSERT INTO `balance_libro` VALUES (1030,7928,40742,9764,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4060.01,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1031,7928,40742,9764,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7679.38,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1032,7928,40742,9764,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5420.00,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1033,7928,40742,9764,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2740.00,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1034,7928,40742,9764,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5360.00,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1035,7928,40742,9764,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3430.11,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1036,7928,40742,9764,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7596.08,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1037,7928,40742,9764,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',155913.22,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1038,7928,40742,9764,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',35297.31,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1039,7928,40742,9764,2,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',8199.96,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1040,7928,40742,9764,2,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',23597.45,NULL,NULL,1,'2023-02-10 19:54:13','2023-02-10 19:54:13',NULL),(1041,7928,40742,9764,2,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',28359.89,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1042,7928,40742,9764,2,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2220.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1043,7928,40742,9764,2,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',15945.68,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1044,7928,40742,9764,2,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',14379.44,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1045,7928,40742,9764,2,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',9846.51,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1046,7928,40742,9764,2,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',16684.87,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1047,7928,40742,9764,2,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',22449.35,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1048,7928,40742,9764,2,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',14020.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1049,7928,40742,9764,2,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',25877.97,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1050,7928,40742,9764,2,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',93400.04,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL);
INSERT INTO `balance_libro` VALUES (1051,7928,40742,9764,2,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3010.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1052,7928,40742,9764,2,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2213.55,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1053,7928,40742,9764,2,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6420.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1054,7928,40742,9764,2,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3850.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1055,7928,40742,9764,2,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1780.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1056,7928,40742,9764,2,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2973.98,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1057,7928,40742,9764,2,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3430.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1058,7928,40742,9764,2,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',18169.99,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1059,7928,40742,9764,2,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',16928.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1060,7928,40742,9764,2,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',39200.01,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1061,7928,40742,9764,2,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',35220.04,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1062,7928,40742,9764,2,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',97220.03,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1063,7928,40742,9764,2,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8082.09,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1064,7928,40742,9764,2,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',27264.88,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1065,7928,40742,9764,2,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4201.51,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1066,7928,40742,9764,2,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4050.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1067,7928,40742,9764,2,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5560.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1068,7928,40742,9764,2,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',29239.97,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1069,7928,40742,9764,2,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',19124.82,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1070,7928,40742,9764,2,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',13068.59,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1071,7928,40742,9764,2,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3055.01,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL);
INSERT INTO `balance_libro` VALUES (1072,7928,40742,9764,2,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',13893.89,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1073,7928,40742,9764,2,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3559.99,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1074,7928,40742,9764,2,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1960.00,NULL,NULL,1,'2023-02-10 19:54:14','2023-02-10 19:54:14',NULL),(1075,7928,40742,9764,2,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2210.00,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1076,7928,40742,9764,2,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2791.66,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1077,7928,40742,9764,2,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3479.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1078,7928,40742,9764,2,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4121.11,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1079,7928,40742,9764,2,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',82430.04,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1080,7928,40742,9764,2,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',59439.97,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1081,7928,40742,9764,2,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',24270.00,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1082,7928,40742,9764,2,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1123.98,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1083,7928,40742,9764,2,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5612.18,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1084,7928,40742,9764,2,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3560.00,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1085,7928,40742,9764,2,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4574.00,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1086,7928,40742,9764,2,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',34650.08,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1087,7928,40742,9764,2,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',5749.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1088,7928,40742,9764,2,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',8109.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1089,7928,40742,9764,2,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',24501.14,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1090,7928,40742,9764,2,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',9536.94,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1091,7928,40742,9764,2,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',10200.01,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1092,7928,40742,9764,2,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',7866.60,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL);
INSERT INTO `balance_libro` VALUES (1093,7928,40742,9764,2,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',20099.98,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1094,7928,40742,9764,2,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3909.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1095,7928,40742,9764,2,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4514.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1096,7928,40742,9764,2,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',5160.00,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1097,7928,40742,9764,2,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3919.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1098,7928,40742,9764,2,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3919.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1099,7928,40742,9764,2,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2559.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1100,7928,40742,9764,2,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2827.77,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1101,7928,40742,9764,2,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',6769.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1102,7928,40742,9764,2,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1300.00,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1103,7928,40742,9764,2,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1942.41,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1104,7928,40742,9764,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2669.99,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1105,7928,40742,9764,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',24339.97,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1106,7928,40742,9764,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',13020.22,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1107,7928,40742,9764,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',22172.14,NULL,NULL,1,'2023-02-10 19:54:15','2023-02-10 19:54:15',NULL),(1108,7928,40742,9764,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',39120.06,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1109,7928,40742,9764,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2430.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1110,7928,40742,9764,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2430.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1111,7928,40742,9764,2,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1370.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1112,7928,40742,9764,2,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1680.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1113,7928,40742,9764,2,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',18780.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL);
INSERT INTO `balance_libro` VALUES (1114,7928,40742,9764,2,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4100.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1115,7928,40742,9764,2,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',10800.02,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1116,7928,40742,9764,2,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3939.99,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1117,7928,40742,9764,2,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',11569.99,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1118,7928,40742,9764,2,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3795.83,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1119,7928,40742,9764,2,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',81480.03,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1120,7928,40742,9764,2,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',19909.93,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1121,7928,40742,9764,2,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3800.01,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1122,7928,40742,9764,2,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',680.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1123,7928,40742,9764,2,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',13135.20,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1124,7928,40742,9764,2,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11080.46,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1125,7928,40742,9764,2,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7810.06,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1126,7928,40742,9764,2,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1621.21,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1127,7928,40742,9764,2,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2559.99,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1128,7928,40742,9764,2,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',27177.75,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1129,7928,40742,9764,2,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3227.83,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1130,7928,40742,9764,2,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5490.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1131,7928,40742,9764,2,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5191.77,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1132,7928,40742,9764,2,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8992.71,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1133,7928,40742,9764,2,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',12974.73,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1134,7928,40742,9764,2,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',12106.61,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL);
INSERT INTO `balance_libro` VALUES (1135,7928,40742,9764,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2508.84,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1136,7928,40742,9764,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2088.70,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1137,7928,40742,9764,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4009.84,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1138,7928,40742,9764,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6961.11,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1139,7928,40742,9764,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',18140.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1140,7928,40742,9764,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10150.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1141,7928,40742,9764,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2600.00,NULL,NULL,1,'2023-02-10 19:54:16','2023-02-10 19:54:16',NULL),(1142,7928,40742,9764,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5369.53,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1143,7928,40742,9764,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11130.00,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1144,7928,40742,9764,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6015.84,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1145,7928,40742,9764,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10998.72,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1146,7928,40742,9764,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4820.72,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1147,7928,40742,9764,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2883.08,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1148,7928,40742,9764,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2071.42,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1149,7928,40742,9764,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',17770.00,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1150,7928,40742,9764,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',22615.84,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1151,7928,40742,9764,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6890.07,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1152,7928,40742,9764,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',20999.99,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1153,7928,40742,9764,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',8120.00,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1154,7928,40742,9764,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',27369.98,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1155,7928,40742,9764,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',15865.96,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL);
INSERT INTO `balance_libro` VALUES (1156,7928,40742,9764,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4040.00,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1157,7928,40742,9764,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2140.01,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1158,7928,40742,9764,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3242.41,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1159,7928,40742,9764,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4750.00,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1160,7928,40742,9764,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4809.99,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1161,7928,40742,9764,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3319.99,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1162,7928,40742,9764,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',7486.09,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1163,7928,40742,9764,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',14800.02,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1164,7928,40742,9764,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',123899.86,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1165,7928,40742,9764,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',24955.12,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1166,7928,40742,9764,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',18600.01,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1167,7928,40742,9764,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',61999.94,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1168,7928,40742,9764,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',63887.41,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1169,7928,40742,9764,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',168118.38,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1170,7928,40742,9764,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',41814.85,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1171,7928,40742,9764,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5440.83,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1172,7928,40742,9764,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',94599.95,NULL,NULL,1,'2023-02-10 19:54:17','2023-02-10 19:54:17',NULL),(1173,7928,40742,9764,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',27722.79,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1174,7928,40742,9764,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',121526.98,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1175,7928,40742,9764,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1537.50,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1176,7928,40742,9764,2,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',15480.03,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL);
INSERT INTO `balance_libro` VALUES (1177,7928,40742,9764,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3570.00,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1178,7928,40742,9764,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1780.00,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1179,7928,40742,9764,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3010.00,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1180,7928,40742,9764,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1510.00,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1181,7928,40742,9764,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5710.00,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1182,7928,40742,9764,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',17322.25,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1183,7928,40742,9764,2,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2282.48,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1184,7928,40742,9764,2,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1780.00,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1185,7928,40742,9764,2,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4406.49,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1186,7928,40742,9764,2,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1066.09,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1187,7928,40742,9764,2,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',17599.98,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1188,7928,40742,9764,2,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9140.00,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1189,7928,40742,9764,2,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',38211.69,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1190,7928,40742,9764,2,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8915.50,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1191,7928,40742,9764,2,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',17997.88,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1192,7928,40742,9764,2,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',26711.33,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1193,7928,40742,9764,2,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9439.98,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1194,7928,40742,9764,2,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',34876.57,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1195,7928,40742,9764,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6748.81,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1196,7928,40742,9764,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8220.00,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1197,7928,40742,9764,2,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4260.01,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL);
INSERT INTO `balance_libro` VALUES (1198,7928,40742,9764,2,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',19385.84,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1199,7928,40742,9764,2,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',18429.28,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1200,7928,40742,9764,2,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',77537.24,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1201,7928,40742,9764,2,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',99664.17,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1202,7928,40742,9764,2,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',48901.44,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1203,7928,40742,9764,2,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',118733.87,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1204,7928,40742,9764,2,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',94994.76,NULL,NULL,1,'2023-02-10 19:54:18','2023-02-10 19:54:18',NULL),(1205,7928,40742,9764,2,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',49600.04,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1206,7928,40742,9764,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4103.48,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1207,7928,40742,9764,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3340.72,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1208,7928,40742,9764,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8570.00,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1209,7928,40742,9764,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',11605.29,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1210,7928,40742,9764,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4687.11,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1211,7928,40742,9764,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1830.00,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1212,7928,40742,9764,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4420.00,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1213,7928,40742,9764,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',7806.07,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1214,7928,40742,9764,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1670.00,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1215,7928,40742,9764,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',14495.59,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1216,7928,40742,9764,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3239.99,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1217,7928,40742,9764,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1817.11,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1218,7928,40742,9764,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',15820.02,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL);
INSERT INTO `balance_libro` VALUES (1219,7928,40742,9764,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',57525.90,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1220,7928,40742,9764,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1041.81,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1221,7928,40742,9764,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',38280.03,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1222,7928,40742,9764,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',12717.27,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1223,7928,40742,9764,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3303.81,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1224,7928,40742,9764,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6097.44,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1225,7928,40742,9764,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',23411.47,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1226,7928,40742,9764,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',18104.71,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1227,7928,40742,9764,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1674.81,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1228,7928,40742,9764,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',33622.58,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1229,7928,40742,9764,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',10778.98,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1230,7928,40742,9764,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',143510.24,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1231,7928,40742,9764,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',11343.56,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1232,7928,40742,9764,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',5000.00,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1233,7928,40742,9764,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',7070.00,NULL,NULL,1,'2023-02-10 19:54:19','2023-02-10 19:54:19',NULL),(1234,7928,40742,9764,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3283.82,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1235,7928,40742,9764,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1936.79,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1236,7928,40742,9764,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',5580.52,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1237,7928,40742,9764,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2285.83,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1238,7928,40742,9764,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2036.64,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1239,7928,40742,9764,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2201.08,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL);
INSERT INTO `balance_libro` VALUES (1240,7928,40742,9764,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',5966.26,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1241,7928,40742,9764,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',21020.03,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1242,7928,40742,9764,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',13809.47,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1243,7928,40742,9764,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',20473.21,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1244,7928,40742,9764,2,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7710.00,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1245,7928,40742,9764,2,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',14780.00,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1246,7928,40742,9764,2,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',22638.94,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1247,7928,40742,9764,2,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',17019.99,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1248,7928,40742,9764,2,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',28367.83,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1249,7928,40742,9764,2,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5839.99,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1250,7928,40742,9764,2,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1970.00,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1251,7928,40742,9764,2,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7175.83,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1252,7928,40742,9764,2,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6961.11,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1253,7928,40742,9764,2,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',18645.01,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1254,7928,40742,9764,2,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8222.42,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1255,7928,40742,9764,2,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',13640.66,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1256,7928,40742,9764,2,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2948.98,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1257,7928,40742,9764,2,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',11413.68,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1258,7928,40742,9764,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3629.99,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1259,7928,40742,9764,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',11721.16,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1260,7928,40742,9764,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6351.65,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL);
INSERT INTO `balance_libro` VALUES (1261,7928,40742,9764,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5130.50,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1262,7928,40742,9764,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',13578.95,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1263,7928,40742,9764,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',23999.99,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1264,7928,40742,9764,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',89789.59,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1265,7928,40742,9764,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',960.00,NULL,NULL,1,'2023-02-10 19:54:20','2023-02-10 19:54:20',NULL),(1266,7928,40742,9764,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1679.49,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1267,7928,40742,9764,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4420.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1268,7928,40742,9764,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2134.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1269,7928,40742,9764,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8580.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1270,7928,40742,9764,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3320.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1271,7928,40742,9764,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2960.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1272,7928,40742,9764,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',13489.97,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1273,7928,40742,9764,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',5700.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1274,7928,40742,9764,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10320.02,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1275,7928,40742,9764,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2750.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1276,7928,40742,9764,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7021.66,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1277,7928,40742,9764,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5879.99,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1278,7928,40742,9764,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',34269.51,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1279,7928,40742,9764,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1355.37,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1280,7928,40742,9764,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',75189.90,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1281,7928,40742,9764,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6838.06,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL);
INSERT INTO `balance_libro` VALUES (1282,7928,40742,9764,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4314.86,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1283,7928,40742,9764,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5340.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1284,7928,40742,9764,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3560.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1285,7928,40742,9764,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13958.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1286,7928,40742,9764,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5340.00,NULL,NULL,1,'2023-02-10 19:54:21','2023-02-10 19:54:21',NULL),(1287,7928,40879,11444,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',65000.00,NULL,NULL,1,'2023-02-10 20:06:30','2023-02-10 20:06:30',NULL),(1288,7928,40880,14669,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',252200.00,NULL,NULL,1,'2023-02-10 20:20:00','2023-02-10 20:20:00',NULL),(1289,7928,40882,17972,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7000.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1290,7928,40882,17972,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',39000.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1291,7928,40882,17972,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3400.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1292,7928,40882,17972,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6000.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1293,7928,40882,17972,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',48000.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1294,7928,40882,17972,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',48000.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1295,7928,40882,17972,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',14000.03,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1296,7928,40882,17972,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',25000.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1297,7928,40882,17972,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3200.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1298,7928,40882,17972,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',15000.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1299,7928,40882,17972,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',7000.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1300,7928,40882,17972,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',22000.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1301,7928,40882,17972,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',13500.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1302,7928,40882,17972,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4800.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL);
INSERT INTO `balance_libro` VALUES (1303,7928,40882,17972,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',16000.01,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1304,7928,40882,17972,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3500.00,NULL,NULL,1,'2023-02-13 18:13:22','2023-02-13 18:13:22',NULL),(1305,7928,40881,16319,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',75200.00,NULL,NULL,1,'2023-02-13 18:13:53','2023-02-13 18:13:53',NULL),(1306,7928,40881,16319,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',15000.00,NULL,NULL,1,'2023-02-13 18:13:53','2023-02-13 18:13:53',NULL),(1307,7928,40881,16319,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',27000.00,NULL,NULL,1,'2023-02-13 18:13:53','2023-02-13 18:13:53',NULL),(1308,7928,40881,16319,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',45000.00,NULL,NULL,1,'2023-02-13 18:13:53','2023-02-13 18:13:53',NULL),(1309,7928,40881,16319,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',14400.00,NULL,NULL,1,'2023-02-13 18:13:53','2023-02-13 18:13:53',NULL),(1310,7928,40881,16319,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5000.00,NULL,NULL,1,'2023-02-13 18:13:53','2023-02-13 18:13:53',NULL),(1311,7928,40881,16319,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',121000.00,NULL,NULL,1,'2023-02-13 18:13:53','2023-02-13 18:13:53',NULL),(1312,7928,40881,16319,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',724800.00,NULL,NULL,1,'2023-02-13 18:13:53','2023-02-13 18:13:53',NULL),(1313,7928,40903,19625,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2024209.00,NULL,NULL,1,'2023-02-13 18:29:44','2023-02-13 18:29:44',NULL),(1314,7928,40903,19625,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1415203.90,NULL,NULL,1,'2023-02-13 18:29:44','2023-02-13 18:29:44',NULL),(1315,7928,40904,21278,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',100188.00,NULL,NULL,1,'2023-02-13 18:42:01','2023-02-13 18:42:01',NULL),(1316,7928,40907,24401,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',80000.00,NULL,NULL,1,'2023-02-13 18:52:02','2023-02-13 18:52:02',NULL),(1317,7928,40907,24401,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',28800.00,NULL,NULL,1,'2023-02-13 18:52:02','2023-02-13 18:52:02',NULL),(1318,7928,40907,24401,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',120000.00,NULL,NULL,1,'2023-02-13 18:52:02','2023-02-13 18:52:02',NULL),(1319,7928,40907,24401,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',26000.00,NULL,NULL,1,'2023-02-13 18:52:02','2023-02-13 18:52:02',NULL),(1320,7928,40907,24401,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',50000.00,NULL,NULL,1,'2023-02-13 18:52:02','2023-02-13 18:52:02',NULL),(1321,7928,40907,24401,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',30000.00,NULL,NULL,1,'2023-02-13 18:52:02','2023-02-13 18:52:02',NULL),(1322,7928,40907,24401,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',14666.00,NULL,NULL,1,'2023-02-13 18:52:03','2023-02-13 18:52:03',NULL);
INSERT INTO `balance_libro` VALUES (1323,7928,40907,24401,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9562.50,NULL,NULL,1,'2023-02-13 18:52:03','2023-02-13 18:52:03',NULL),(1324,7928,40907,24401,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',54000.00,NULL,NULL,1,'2023-02-13 18:52:03','2023-02-13 18:52:03',NULL),(1325,7928,40907,24401,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',54000.00,NULL,NULL,1,'2023-02-13 18:52:03','2023-02-13 18:52:03',NULL),(1326,7928,40907,24401,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',202500.00,NULL,NULL,1,'2023-02-13 18:52:03','2023-02-13 18:52:03',NULL),(1327,7928,40921,30938,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5039.96,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1328,7928,40921,30938,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4800.00,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1329,7928,40921,30938,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5000.93,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1330,7928,40921,30938,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2349.99,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1331,7928,40921,30938,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5000.02,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1332,7928,40921,30938,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13700.00,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1333,7928,40921,30938,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',28000.00,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1334,7928,40921,30938,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7900.01,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1335,7928,40921,30938,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4900.00,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1336,7928,40921,30938,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1600.00,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1337,7928,40921,30938,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',8999.99,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1338,7928,40921,30938,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',23458.79,NULL,NULL,1,'2023-02-13 19:20:26','2023-02-13 19:20:26',NULL),(1339,7928,40921,30938,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',121960.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1340,7928,40921,30938,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',15060.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1341,7928,40921,30938,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',15060.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1342,7928,40921,30938,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4260.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1343,7928,40921,30938,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2100.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL);
INSERT INTO `balance_libro` VALUES (1344,7928,40921,30938,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',207755.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1345,7928,40921,30938,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',20130.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1346,7928,40921,30938,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',19986.01,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1347,7928,40921,30938,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3400.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1348,7928,40921,30938,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2301.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1349,7928,40921,30938,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',10950.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1350,7928,40921,30938,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3000.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1351,7928,40921,30938,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',196345.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1352,7928,40921,30938,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',48096.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1353,7928,40921,30938,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',131380.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1354,7928,40921,30938,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',16509.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1355,7928,40921,30938,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10000.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1356,7928,40921,30938,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',194000.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1357,7928,40921,30938,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',70000.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1358,7928,40921,30938,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1500.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1359,7928,40921,30938,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10898.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1360,7928,40921,30938,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3342.38,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1361,7928,40921,30938,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',10533.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1362,7928,40921,30938,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8000.01,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1363,7928,40921,30938,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',720.00,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL),(1364,7928,40921,30938,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3015.01,NULL,NULL,1,'2023-02-13 19:20:27','2023-02-13 19:20:27',NULL);
INSERT INTO `balance_libro` VALUES (1365,7928,40921,30938,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',16000.01,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1366,7928,40921,30938,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6000.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1367,7928,40921,30938,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9500.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1368,7928,40921,30938,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5400.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1369,7928,40921,30938,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3300.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1370,7928,40921,30938,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4100.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1371,7928,40921,30938,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',950.01,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1372,7928,40921,30938,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2000.01,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1373,7928,40921,30938,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4000.01,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1374,7928,40921,30938,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1980.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1375,7928,40921,30938,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1330.01,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1376,7928,40921,30938,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',29999.99,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1377,7928,40921,30938,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',23000.01,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1378,7928,40921,30938,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2150.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1379,7928,40921,30938,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',450.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1380,7928,40921,30938,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',35000.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1381,7928,40921,30938,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3300.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1382,7928,40921,30938,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1017.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1383,7928,40921,30938,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9800.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1384,7928,40921,30938,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3619.98,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1385,7928,40921,30938,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3070.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL);
INSERT INTO `balance_libro` VALUES (1386,7928,40921,30938,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',500.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1387,7928,40921,30938,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',30250.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1388,7928,40921,30938,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',5000.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1389,7928,40921,30938,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1350.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1390,7928,40921,30938,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',590.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1391,7928,40921,30938,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2185.01,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1392,7928,40921,30938,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',99999.99,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1393,7928,40921,30938,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',26915.00,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1394,7928,40921,30938,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8999.99,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1395,7928,40921,30938,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',519.96,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1396,7928,40921,30938,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4499.99,NULL,NULL,1,'2023-02-13 19:20:28','2023-02-13 19:20:28',NULL),(1397,7928,40921,30938,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2400.00,NULL,NULL,1,'2023-02-13 19:20:29','2023-02-13 19:20:29',NULL),(1398,7928,40921,30938,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1350.00,NULL,NULL,1,'2023-02-13 19:20:29','2023-02-13 19:20:29',NULL),(1399,7928,40921,30938,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2620.00,NULL,NULL,1,'2023-02-13 19:20:29','2023-02-13 19:20:29',NULL),(1400,7928,40921,30938,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8099.99,NULL,NULL,1,'2023-02-13 19:20:29','2023-02-13 19:20:29',NULL),(1401,7928,40921,30938,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5000.00,NULL,NULL,1,'2023-02-13 19:20:29','2023-02-13 19:20:29',NULL),(1402,7928,40921,30938,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22000.00,NULL,NULL,1,'2023-02-13 19:20:29','2023-02-13 19:20:29',NULL),(1403,7928,40920,29315,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',86273.00,NULL,NULL,1,'2023-02-13 19:21:13','2023-02-13 19:21:13',NULL),(1404,7928,40920,29315,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',101640.00,NULL,NULL,1,'2023-02-13 19:21:13','2023-02-13 19:21:13',NULL),(1405,7928,40920,29315,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',660660.00,NULL,NULL,1,'2023-02-13 19:21:13','2023-02-13 19:21:13',NULL),(1406,7928,40920,29315,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',220000.00,NULL,NULL,1,'2023-02-13 19:21:13','2023-02-13 19:21:13',NULL);
INSERT INTO `balance_libro` VALUES (1407,7928,40920,29315,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',437052.00,NULL,NULL,1,'2023-02-13 19:21:13','2023-02-13 19:21:13',NULL),(1408,7928,40920,29315,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',133100.00,NULL,NULL,1,'2023-02-13 19:21:13','2023-02-13 19:21:13',NULL),(1409,7928,40920,29315,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',866989.20,NULL,NULL,1,'2023-02-13 19:21:13','2023-02-13 19:21:13',NULL),(1410,7928,40920,29315,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6050.00,NULL,NULL,1,'2023-02-13 19:21:13','2023-02-13 19:21:13',NULL),(1411,7928,40920,29315,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6050.00,NULL,NULL,1,'2023-02-13 19:21:13','2023-02-13 19:21:13',NULL),(1412,7928,40974,32591,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',72299.92,NULL,NULL,1,'2023-02-13 19:33:13','2023-02-13 19:33:13',NULL),(1413,7928,40974,32591,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3310.56,NULL,NULL,1,'2023-02-13 19:33:13','2023-02-13 19:33:13',NULL),(1414,7928,40974,32591,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',349000.30,NULL,NULL,1,'2023-02-13 19:33:13','2023-02-13 19:33:13',NULL),(1415,7928,40974,32591,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',30000.00,NULL,NULL,1,'2023-02-13 19:33:13','2023-02-13 19:33:13',NULL),(1416,7928,40940,34214,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',235865.30,NULL,NULL,1,'2023-02-13 19:43:04','2023-02-13 19:43:04',NULL),(1417,7928,40940,34214,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',18150.00,NULL,NULL,1,'2023-02-13 19:43:04','2023-02-13 19:43:04',NULL),(1418,7928,40940,34214,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',21175.00,NULL,NULL,1,'2023-02-13 19:43:04','2023-02-13 19:43:04',NULL),(1419,7928,40940,34214,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1210.00,NULL,NULL,1,'2023-02-13 19:43:04','2023-02-13 19:43:04',NULL),(1420,7928,40940,34214,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',91960.00,NULL,NULL,1,'2023-02-13 19:43:04','2023-02-13 19:43:04',NULL),(1421,7928,40940,34214,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',47734.50,NULL,NULL,1,'2023-02-13 19:43:04','2023-02-13 19:43:04',NULL),(1422,7928,40940,34214,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',92819.10,NULL,NULL,1,'2023-02-13 19:43:04','2023-02-13 19:43:04',NULL),(1423,7928,40940,34214,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',43983.50,NULL,NULL,1,'2023-02-13 19:43:04','2023-02-13 19:43:04',NULL),(1424,7928,40895,35834,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',142780.00,NULL,NULL,1,'2023-02-13 20:05:34','2023-02-13 20:05:34',NULL),(1425,7928,40895,35834,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',273312.55,NULL,NULL,1,'2023-02-13 20:05:34','2023-02-13 20:05:34',NULL),(1426,7928,40895,35834,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',684061.88,NULL,NULL,1,'2023-02-13 20:05:34','2023-02-13 20:05:34',NULL);
INSERT INTO `balance_libro` VALUES (1427,7928,40895,35834,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',579348.00,NULL,NULL,1,'2023-02-13 20:05:34','2023-02-13 20:05:34',NULL),(1428,7928,40958,37458,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',441371.70,NULL,NULL,1,'2023-02-14 18:07:17','2023-02-14 18:07:17',NULL),(1429,7928,40958,37458,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',882743.40,NULL,NULL,1,'2023-02-14 18:07:17','2023-02-14 18:07:17',NULL),(1430,7928,40921,30938,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',19950.00,NULL,NULL,1,'2023-02-14 18:49:16','2023-02-14 18:49:16',NULL),(1431,7928,40921,30938,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',96140.33,NULL,NULL,1,'2023-02-14 18:49:56','2023-02-14 18:49:56',NULL),(1432,7928,40921,30938,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',48409.99,NULL,NULL,1,'2023-02-14 18:50:18','2023-02-14 18:50:18',NULL),(1433,7928,40921,30938,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',52590.00,NULL,NULL,1,'2023-02-14 18:50:47','2023-02-14 18:50:47',NULL),(1434,7928,40921,30938,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',7390.00,NULL,NULL,1,'2023-02-14 18:51:31','2023-02-14 18:51:31',NULL),(1435,7928,40921,30938,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',25790.00,NULL,NULL,1,'2023-02-14 18:52:06','2023-02-14 18:52:06',NULL),(1436,7928,40921,30938,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',197575.00,NULL,NULL,1,'2023-02-14 18:52:46','2023-02-14 18:52:46',NULL),(1437,7928,40921,30938,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',32672.00,NULL,NULL,1,'2023-02-14 18:53:05','2023-02-14 18:53:05',NULL),(1438,7928,40921,30938,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',36131.22,NULL,NULL,1,'2023-02-14 18:53:26','2023-02-14 18:53:26',NULL),(1439,7928,40921,30938,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',44344.00,NULL,NULL,1,'2023-02-14 18:53:47','2023-02-14 18:53:47',NULL),(1440,7928,40921,30938,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',44838.99,NULL,NULL,1,'2023-02-14 18:54:13','2023-02-14 18:54:13',NULL),(1441,7928,40921,30938,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',15600.00,NULL,NULL,1,'2023-02-14 18:55:02','2023-02-14 18:55:02',NULL),(1442,7928,40921,30938,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',52850.00,NULL,NULL,1,'2023-02-14 18:55:25','2023-02-14 18:55:25',NULL),(1443,7928,40921,30938,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',26386.00,NULL,NULL,1,'2023-02-14 18:55:51','2023-02-14 18:55:51',NULL),(1444,7928,40921,30938,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',45590.00,NULL,NULL,1,'2023-02-14 18:56:13','2023-02-14 18:56:13',NULL),(1445,7928,40921,30938,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',17110.01,NULL,NULL,1,'2023-02-14 18:59:11','2023-02-14 18:59:11',NULL),(1446,7928,40921,30938,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',40209.99,NULL,NULL,1,'2023-02-14 18:59:33','2023-02-14 18:59:33',NULL),(1447,7928,40921,30938,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',20786.00,NULL,NULL,1,'2023-02-14 18:59:57','2023-02-14 18:59:57',NULL);
INSERT INTO `balance_libro` VALUES (1448,7928,40921,30938,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',52400.01,NULL,NULL,1,'2023-02-14 19:00:22','2023-02-14 19:00:22',NULL),(1449,7928,40921,30938,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',35610.00,NULL,NULL,1,'2023-02-14 19:00:42','2023-02-14 19:00:42',NULL),(1450,7928,40921,30938,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',92439.99,NULL,NULL,1,'2023-02-14 19:01:03','2023-02-14 19:01:03',NULL),(1451,7928,40921,30938,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',65660.00,NULL,NULL,1,'2023-02-14 19:11:41','2023-02-14 19:11:41',NULL),(1452,7928,40921,30938,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',33250.01,NULL,NULL,1,'2023-02-14 19:11:58','2023-02-14 19:11:58',NULL),(1453,7928,40921,30938,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',26850.00,NULL,NULL,1,'2023-02-14 19:12:22','2023-02-14 19:12:22',NULL),(1454,7928,40921,30938,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',119452.00,NULL,NULL,1,'2023-02-14 19:12:43','2023-02-14 19:12:43',NULL),(1455,7928,40921,30938,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',43880.00,NULL,NULL,1,'2023-02-14 19:13:04','2023-02-14 19:13:04',NULL),(1456,7928,40974,32591,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',257089.99,NULL,NULL,1,'2023-02-15 20:08:50','2023-02-15 20:08:50',NULL),(1457,7928,40974,32591,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',542130.00,NULL,NULL,1,'2023-02-15 20:09:14','2023-02-15 20:09:14',NULL),(1458,7928,40974,32591,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',603709.99,NULL,NULL,1,'2023-02-15 20:09:35','2023-02-15 20:09:35',NULL),(1459,7928,40974,32591,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',62060.00,NULL,NULL,1,'2023-02-15 20:09:54','2023-02-15 20:09:54',NULL),(1460,7928,40974,32591,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',51400.00,NULL,NULL,1,'2023-02-15 20:10:14','2023-02-15 20:10:14',NULL),(1461,7928,40974,32591,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',249900.01,NULL,NULL,1,'2023-02-15 20:10:35','2023-02-15 20:10:35',NULL),(1462,7928,40974,32591,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',138000.00,NULL,NULL,1,'2023-02-15 20:10:57','2023-02-15 20:10:57',NULL),(1463,7928,40974,32591,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',47900.00,NULL,NULL,1,'2023-02-15 20:11:20','2023-02-15 20:11:20',NULL),(1464,7928,40974,32591,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',66240.00,NULL,NULL,1,'2023-02-15 20:11:37','2023-02-15 20:11:37',NULL),(1465,7928,40974,32591,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',483750.00,NULL,NULL,1,'2023-02-15 20:11:58','2023-02-15 20:11:58',NULL),(1466,7928,40974,32591,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',40600.00,NULL,NULL,1,'2023-02-15 20:12:20','2023-02-15 20:12:20',NULL),(1467,7928,40974,32591,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',91000.00,NULL,NULL,1,'2023-02-15 20:12:42','2023-02-15 20:12:42',NULL);
INSERT INTO `balance_libro` VALUES (1468,7928,40974,32591,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',127059.99,NULL,NULL,1,'2023-02-15 20:13:01','2023-02-15 20:13:01',NULL),(1493,7928,40985,42283,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7730.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1494,7928,40985,42283,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',4820.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1495,7928,40985,42283,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',20000.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1496,7928,40985,42283,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',18800.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1497,7928,40985,42283,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',21500.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1498,7928,40985,42283,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',14285.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1499,7928,40985,42283,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',15800.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1500,7928,40985,42283,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6200.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1501,7928,40985,42283,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7000.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1502,7928,40985,42283,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7000.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1503,7928,40985,42283,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',9750.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1504,7928,40985,42283,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',15000.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1505,7928,40985,42283,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',20500.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1506,7928,40985,42283,2,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',19800.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1507,7928,40985,42283,2,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',14768.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1508,7928,40985,42283,2,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',15300.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1509,7928,40985,42283,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',14615.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1510,7928,40985,42283,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6430.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1511,7928,40985,42283,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5850.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1512,7928,40985,42283,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',21450.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL);
INSERT INTO `balance_libro` VALUES (1513,7928,40985,42283,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',16550.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1514,7928,40985,42283,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',10700.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1515,7928,40985,42283,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',20200.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1516,7928,40985,42283,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',11870.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1517,7928,40985,42283,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',15520.00,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1518,7928,40985,42283,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',7200.05,NULL,NULL,1,'2023-02-16 17:59:06','2023-02-16 17:59:06',NULL),(1519,7928,40985,42283,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',13080.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1520,7928,40985,42283,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',9500.07,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1521,7928,40985,42283,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',21850.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1522,7928,40985,42283,2,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',21650.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1523,7928,40985,42283,2,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',16500.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1524,7928,40985,42283,2,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14780.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1525,7928,40985,42283,2,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',19542.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1526,7928,40985,42283,2,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',36600.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1527,7928,40985,42283,2,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3660.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1528,7928,40985,42283,2,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',19410.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1529,7928,40985,42283,2,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7700.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1530,7928,40985,42283,2,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',115960.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1531,7928,40985,42283,2,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17250.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1532,7928,40985,42283,2,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',11650.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1533,7928,40985,42283,2,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',59690.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL);
INSERT INTO `balance_libro` VALUES (1534,7928,40985,42283,2,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',9200.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1535,7928,40985,42283,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',19610.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1536,7928,40985,42283,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',19610.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1537,7928,40985,42283,2,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',22100.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1538,7928,40985,42283,2,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4100.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1539,7928,40985,42283,2,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1900.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1540,7928,40985,42283,2,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',62300.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1541,7928,40985,42283,2,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',13000.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1542,7928,40985,42283,2,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1500.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1543,7928,40985,42283,2,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',13200.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1544,7928,40985,42283,2,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11495.00,NULL,NULL,1,'2023-02-16 17:59:07','2023-02-16 17:59:07',NULL),(1545,7928,40985,42283,2,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10400.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1546,7928,40985,42283,2,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',7390.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1547,7928,40985,42283,2,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',9000.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1548,7928,40985,42283,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',15020.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1549,7928,40985,42283,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',7725.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1550,7928,40985,42283,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',9300.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1551,7928,40985,42283,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1400.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1552,7928,40985,42283,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',12135.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1553,7928,40985,42283,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',19000.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1554,7928,40985,42283,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7600.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL);
INSERT INTO `balance_libro` VALUES (1555,7928,40985,42283,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',20750.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1556,7928,40985,42283,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',7900.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1557,7928,40985,42283,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3900.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1558,7928,40985,42283,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',18765.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1559,7928,40985,42283,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2700.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1560,7928,40985,42283,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4300.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1561,7928,40985,42283,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4400.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1562,7928,40985,42283,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',12400.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1563,7928,40985,42283,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4510.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1564,7928,40985,42283,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',6000.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1565,7928,40985,42283,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',5900.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1566,7928,40985,42283,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3600.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1567,7928,40985,42283,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',20410.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1568,7928,40985,42283,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1550.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1569,7928,40985,42283,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',14855.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1570,7928,40985,42283,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18820.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1571,7928,40985,42283,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8400.00,NULL,NULL,1,'2023-02-16 17:59:08','2023-02-16 17:59:08',NULL),(1572,7928,40985,42283,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7510.00,NULL,NULL,1,'2023-02-16 17:59:09','2023-02-16 17:59:09',NULL),(1573,7928,40985,42283,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21010.00,NULL,NULL,1,'2023-02-16 17:59:09','2023-02-16 17:59:09',NULL),(1574,7928,40985,42283,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',550.00,NULL,NULL,1,'2023-02-16 17:59:09','2023-02-16 17:59:09',NULL),(1575,7928,40985,42283,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',16012.21,NULL,NULL,1,'2023-02-16 18:01:50','2023-02-16 18:01:50',NULL);
INSERT INTO `balance_libro` VALUES (1576,7928,40985,42283,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',50229.82,NULL,NULL,1,'2023-02-16 18:01:50','2023-02-16 18:01:50',NULL),(1577,7928,40985,42283,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',6535.01,NULL,NULL,1,'2023-02-16 18:01:50','2023-02-16 18:02:19','2023-02-16 18:02:19'),(1578,7928,40985,42283,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',71898.15,NULL,NULL,1,'2023-02-16 18:01:50','2023-02-16 18:01:50',NULL),(1579,7928,40985,42283,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',174500.11,NULL,NULL,1,'2023-02-16 18:01:51','2023-02-16 18:01:51',NULL),(1580,7928,40985,42283,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',216875.92,NULL,NULL,1,'2023-02-16 18:01:51','2023-02-16 18:01:51',NULL),(1581,7928,40985,42283,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',331214.78,NULL,NULL,1,'2023-02-16 18:01:51','2023-02-16 18:22:26','2023-02-16 18:22:26'),(1582,7928,40985,42283,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',213459.44,NULL,NULL,1,'2023-02-16 18:01:51','2023-02-16 18:01:51',NULL),(1583,7928,40985,42283,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',122802.42,NULL,NULL,1,'2023-02-16 18:01:51','2023-02-16 18:23:23','2023-02-16 18:23:23'),(1584,7928,40985,42283,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-02-16 18:01:51','2023-02-16 18:01:51',NULL),(1585,7928,40985,42283,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',331214.80,NULL,NULL,1,'2023-02-16 18:22:26','2023-02-16 18:22:26',NULL),(1586,7928,40985,42283,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',122802.42,NULL,NULL,1,'2023-02-16 18:23:23','2023-02-16 18:23:23',NULL),(1587,7928,40985,42283,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',16701.01,NULL,NULL,1,'2023-02-16 18:25:59','2023-02-16 18:25:59',NULL),(1588,7928,40985,42283,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5053.99,NULL,NULL,1,'2023-02-16 18:28:59','2023-02-16 18:28:59',NULL),(1589,7928,40985,42283,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',18400.01,NULL,NULL,1,'2023-02-16 18:44:51','2023-02-16 18:44:51',NULL),(1590,7928,40985,42283,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16801.21,NULL,NULL,1,'2023-02-16 18:47:58','2023-02-16 18:47:58',NULL),(1591,7928,40985,42283,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17072.40,NULL,NULL,1,'2023-02-16 18:50:21','2023-02-16 18:50:21',NULL),(1592,7928,40720,1612,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',4999.99,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1593,7928,40720,1612,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',54579.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1594,7928,40720,1612,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',437.50,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1595,7928,40720,1612,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',28062.50,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL);
INSERT INTO `balance_libro` VALUES (1596,7928,40720,1612,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3299.99,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1597,7928,40720,1612,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1920.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1598,7928,40720,1612,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2646.74,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1599,7928,40720,1612,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',34404.52,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1600,7928,40720,1612,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',33922.37,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1601,7928,40720,1612,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8400.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1602,7928,40720,1612,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1289.88,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1603,7928,40720,1612,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14770.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1604,7928,40720,1612,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',57000.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1605,7928,40720,1612,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',4320.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1606,7928,40720,1612,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',37594.07,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1607,7928,40720,1612,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',59514.01,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1608,7928,40720,1612,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2180.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 19:21:35','2023-02-16 19:21:35'),(1609,7928,40720,1612,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2180.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1610,7928,40720,1612,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2180.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 19:21:27','2023-02-16 19:21:27'),(1611,7928,40720,1612,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2180.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 19:21:19','2023-02-16 19:21:19'),(1612,7928,40720,1612,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2180.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 19:21:07','2023-02-16 19:21:07'),(1613,7928,40720,1612,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',15800.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1614,7928,40720,1612,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',740000.00,NULL,NULL,1,'2023-02-16 18:56:34','2023-02-16 18:56:34',NULL),(1615,7928,40720,1612,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1344.49,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL);
INSERT INTO `balance_libro` VALUES (1616,7928,40720,1612,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',7000.03,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1617,7928,40720,1612,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',6999.98,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1618,7928,40720,1612,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',28300.00,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1619,7928,40720,1612,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',3000.05,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1620,7928,40720,1612,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',192000.00,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1621,7928,40720,1612,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',700.00,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1622,7928,40720,1612,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',700.00,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 19:20:56','2023-02-16 19:20:56'),(1623,7928,40720,1612,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',5060.00,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1624,7928,40720,1612,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',9000.00,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 19:20:50','2023-02-16 19:20:50'),(1625,7928,40720,1612,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',560.00,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1626,7928,40720,1612,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5600.00,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1627,7928,40720,1612,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4679.20,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 19:17:40','2023-02-16 19:17:40'),(1628,7928,40720,1612,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1510.08,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 19:20:43','2023-02-16 19:20:43'),(1629,7928,40720,1612,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2000.00,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1630,7928,40720,1612,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',29482.56,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1631,7928,40720,1612,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',25967.50,NULL,NULL,1,'2023-02-16 18:56:35','2023-02-16 18:56:35',NULL),(1632,7928,40723,3187,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',75876.46,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:24:03','2023-02-16 19:24:03'),(1633,7928,40723,3187,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2303.43,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1634,7928,40723,3187,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',17305.92,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1635,7928,40723,3187,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',16554.22,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:23:10','2023-02-16 19:23:10');
INSERT INTO `balance_libro` VALUES (1636,7928,40723,3187,3,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2900.00,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1637,7928,40723,3187,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',25084.72,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1638,7928,40723,3187,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5000.93,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1639,7928,40723,3187,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',11340.40,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1640,7928,40723,3187,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1271.16,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:23:01','2023-02-16 19:23:01'),(1641,7928,40723,3187,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',23431.14,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1642,7928,40723,3187,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',16499.46,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:22:46','2023-02-16 19:22:46'),(1643,7928,40723,3187,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2599.99,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1644,7928,40723,3187,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',10365.25,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1645,7928,40723,3187,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',30679.97,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1646,7928,40723,3187,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',37481.40,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1647,7928,40723,3187,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5151.57,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1648,7928,40723,3187,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',349000.30,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1649,7928,40723,3187,3,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1346.36,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1650,7928,40723,3187,3,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2916.05,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1651,7928,40723,3187,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',25574.12,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1652,7928,40723,3187,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',25574.12,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:22:37','2023-02-16 19:22:37'),(1653,7928,40723,3187,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4050.07,NULL,NULL,1,'2023-02-16 19:08:28','2023-02-16 19:08:28',NULL),(1654,7928,40723,3187,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7434.91,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1655,7928,40723,3187,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',32930.56,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL);
INSERT INTO `balance_libro` VALUES (1656,7928,40723,3187,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',16684.87,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1657,7928,40723,3187,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1060.01,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1658,7928,40723,3187,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',59635.90,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1659,7928,40723,3187,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5400.00,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1660,7928,40723,3187,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4100.00,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1661,7928,40723,3187,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',34235.54,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1662,7928,40723,3187,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1405.53,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1663,7928,40723,3187,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',900.24,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1664,7928,40723,3187,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1406.26,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1665,7928,40723,3187,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',25594.47,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1666,7928,40723,3187,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5594.27,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1667,7928,40723,3187,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',42561.73,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1668,7928,40723,3187,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',34876.57,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1669,7928,40723,3187,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',26342.96,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1670,7928,40723,3187,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1267.21,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:22:20','2023-02-16 19:22:20'),(1671,7928,40723,3187,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2827.64,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1672,7928,40723,3187,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',33391.93,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1673,7928,40723,3187,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3075.93,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:22:14','2023-02-16 19:22:14'),(1674,7928,40723,3187,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',25415.00,NULL,NULL,1,'2023-02-16 19:08:29','2023-02-16 19:08:29',NULL),(1675,7928,40725,4837,2,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3299.99,NULL,NULL,1,'2023-02-17 17:43:01','2023-02-17 17:44:57','2023-02-17 17:44:57');
INSERT INTO `balance_libro` VALUES (1676,7928,40725,4837,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4209.80,NULL,NULL,1,'2023-02-17 17:43:01','2023-02-17 17:44:49','2023-02-17 17:44:49'),(1677,7928,40725,4837,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',342842.05,NULL,NULL,1,'2023-02-17 17:43:01','2023-02-17 17:44:43','2023-02-17 17:44:43'),(1678,7928,40725,4837,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',7159.90,NULL,NULL,1,'2023-02-17 17:43:01','2023-02-17 17:44:36','2023-02-17 17:44:36'),(1679,7928,40725,4837,2,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',102063.50,NULL,NULL,1,'2023-02-17 17:43:01','2023-02-17 17:44:30','2023-02-17 17:44:30'),(1680,7928,40725,4837,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',500.00,NULL,NULL,1,'2023-02-17 17:43:01','2023-02-17 17:43:20','2023-02-17 17:43:20'),(1681,7928,40725,4837,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3299.99,NULL,NULL,1,'2023-02-17 17:46:08','2023-02-17 17:46:08',NULL),(1682,7928,40725,4837,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4209.80,NULL,NULL,1,'2023-02-17 17:46:08','2023-02-17 17:46:08',NULL),(1683,7928,40725,4837,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',342842.05,NULL,NULL,1,'2023-02-17 17:46:08','2023-02-17 17:46:08',NULL),(1684,7928,40725,4837,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',7159.90,NULL,NULL,1,'2023-02-17 17:46:08','2023-02-17 17:46:08',NULL),(1685,7928,40725,4837,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',102063.50,NULL,NULL,1,'2023-02-17 17:46:08','2023-02-17 17:46:08',NULL),(1686,7928,40725,4837,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',500.00,NULL,NULL,1,'2023-02-17 17:46:08','2023-02-17 17:46:53','2023-02-17 17:46:53'),(1687,7928,40725,4837,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',406862.55,NULL,NULL,1,'2023-02-17 17:50:22','2023-02-17 17:50:22',NULL),(1688,7928,40730,6458,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',36047.00,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1689,7928,40730,6458,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3120.35,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1690,7928,40730,6458,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',177886.48,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 18:00:46','2023-02-17 18:00:46'),(1691,7928,40730,6458,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',86583.31,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1692,7928,40730,6458,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',9465.06,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1693,7928,40730,6458,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',9922.52,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1694,7928,40730,6458,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7686.77,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1695,7928,40730,6458,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7444.60,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL);
INSERT INTO `balance_libro` VALUES (1696,7928,40730,6458,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4209.80,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1697,7928,40730,6458,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',294791.71,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:57:36','2023-02-17 17:57:36'),(1698,7928,40730,6458,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',224349.29,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 18:03:36','2023-02-17 18:03:36'),(1699,7928,40730,6458,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',219439.63,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1700,7928,40730,6458,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',143751.84,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 18:04:47','2023-02-17 18:04:47'),(1701,7928,40730,6458,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',273949.37,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:58:41','2023-02-17 17:58:41'),(1702,7928,40730,6458,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',118797.85,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1703,7928,40730,6458,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',139123.85,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 17:54:22',NULL),(1704,7928,40730,6458,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',502851.63,NULL,NULL,1,'2023-02-17 17:54:22','2023-02-17 18:01:28','2023-02-17 18:01:28'),(1705,7928,40730,6458,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',224515.31,NULL,NULL,1,'2023-02-17 17:54:23','2023-02-17 17:54:23',NULL),(1706,7928,40730,6458,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',403277.54,NULL,NULL,1,'2023-02-17 17:54:23','2023-02-17 17:59:55','2023-02-17 17:59:55'),(1707,7928,40730,6458,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',233162.12,NULL,NULL,1,'2023-02-17 17:54:23','2023-02-17 17:54:23',NULL),(1708,7928,40730,6458,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',281671.24,NULL,NULL,1,'2023-02-17 17:54:23','2023-02-17 17:54:23',NULL),(1709,7928,40730,6458,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',233026.64,NULL,NULL,1,'2023-02-17 17:54:23','2023-02-17 17:54:23',NULL),(1710,7928,40730,6458,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',235204.75,NULL,NULL,1,'2023-02-17 17:54:23','2023-02-17 18:02:22','2023-02-17 18:02:22'),(1711,7928,40730,6458,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',163924.32,NULL,NULL,1,'2023-02-17 17:54:23','2023-02-17 17:54:23',NULL),(1712,7928,40730,6458,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',45207.00,NULL,NULL,1,'2023-02-17 17:54:23','2023-02-17 17:54:23',NULL),(1713,7928,40730,6458,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',32904.00,NULL,NULL,1,'2023-02-17 17:54:23','2023-02-17 17:54:23',NULL),(1714,7928,40740,8111,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',737.45,NULL,NULL,1,'2023-02-17 18:12:16','2023-02-17 18:15:15','2023-02-17 18:15:15'),(1715,7928,40740,8111,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2449.99,NULL,NULL,1,'2023-02-17 18:12:16','2023-02-17 18:12:16',NULL);
INSERT INTO `balance_libro` VALUES (1716,7928,40740,8111,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',315981.02,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:18:27','2023-02-17 18:18:27'),(1717,7928,40740,8111,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',40482.92,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1718,7928,40740,8111,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',61322.51,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1719,7928,40740,8111,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',57837.89,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1720,7928,40740,8111,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',23361.01,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:15:06','2023-02-17 18:15:06'),(1721,7928,40740,8111,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1710.00,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1722,7928,40740,8111,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5521.63,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:15:00','2023-02-17 18:15:00'),(1723,7928,40740,8111,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5301.52,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:14:49','2023-02-17 18:14:49'),(1724,7928,40740,8111,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2543.90,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:14:39','2023-02-17 18:14:39'),(1725,7928,40740,8111,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',48642.88,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1726,7928,40740,8111,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',9715.50,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1727,7928,40740,8111,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',17411.67,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1728,7928,40740,8111,3,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',16236.46,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1729,7928,40740,8111,3,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',30657.97,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1730,7928,40740,8111,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',20514.07,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1731,7928,40740,8111,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',213110.93,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1732,7928,40740,8111,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4209.80,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1733,7928,40740,8111,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1708.00,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1734,7928,40740,8111,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',83099.41,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1735,7928,40740,8111,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',18612.53,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL);
INSERT INTO `balance_libro` VALUES (1736,7928,40740,8111,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',192034.43,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1737,7928,40740,8111,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',351392.58,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1738,7928,40740,8111,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',11209.24,NULL,NULL,1,'2023-02-17 18:12:17','2023-02-17 18:12:17',NULL),(1739,7928,40740,8111,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1818.07,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:14:23','2023-02-17 18:14:23'),(1740,7928,40740,8111,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',197521.06,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1741,7928,40740,8111,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',99040.91,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:14:16','2023-02-17 18:14:16'),(1742,7928,40740,8111,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',39318.39,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1743,7928,40740,8111,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',18111.95,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:14:06','2023-02-17 18:14:06'),(1744,7928,40740,8111,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',20514.07,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:13:39','2023-02-17 18:13:39'),(1745,7928,40740,8111,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',130019.39,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1746,7928,40740,8111,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',14018.29,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:13:32','2023-02-17 18:13:32'),(1747,7928,40740,8111,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',76263.80,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1748,7928,40740,8111,3,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',45797.12,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1749,7928,40740,8111,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',36518.04,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1750,7928,40740,8111,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5418.50,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:13:23','2023-02-17 18:13:23'),(1751,7928,40740,8111,3,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11949.65,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:13:16','2023-02-17 18:13:16'),(1752,7928,40740,8111,3,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',170872.26,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1753,7928,40740,8111,3,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',7226.41,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1754,7928,40740,8111,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',77592.57,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1755,7928,40740,8111,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2681.24,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:58','2023-02-17 18:12:58');
INSERT INTO `balance_libro` VALUES (1756,7928,40740,8111,3,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',66101.80,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1757,7928,40740,8111,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',5810.89,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1758,7928,40740,8111,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',77277.57,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1759,7928,40740,8111,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16512.81,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:49','2023-02-17 18:12:49'),(1760,7928,40740,8111,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',43501.56,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1761,7928,40740,8111,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22516.37,NULL,NULL,1,'2023-02-17 18:12:18','2023-02-17 18:12:18',NULL),(1762,7928,40740,8111,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1213.00,NULL,NULL,1,'2023-02-17 18:12:19','2023-02-17 18:12:19',NULL),(1763,7928,40740,8111,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',744.50,NULL,NULL,1,'2023-02-17 18:12:19','2023-02-17 18:12:41','2023-02-17 18:12:41'),(1764,7928,40740,8111,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',187357.99,NULL,NULL,1,'2023-02-17 18:12:19','2023-02-17 18:12:19',NULL),(1765,7928,40880,14669,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',10800.18,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1766,7928,40880,14669,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6136.00,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1767,7928,40880,14669,3,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',7794.00,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1768,7928,40880,14669,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8073.48,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1769,7928,40880,14669,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1942.00,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1770,7928,40880,14669,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',52000.00,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1771,7928,40880,14669,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',91500.00,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1772,7928,40880,14669,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',18000.00,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1773,7928,40880,14669,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',18821.21,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1774,7928,40880,14669,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',13230.32,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL),(1775,7928,40880,14669,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4483.86,NULL,NULL,1,'2023-02-17 19:11:28','2023-02-17 19:11:28',NULL);
INSERT INTO `balance_libro` VALUES (1776,7928,40880,14669,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',11488.00,NULL,NULL,1,'2023-02-17 19:11:29','2023-02-17 19:11:29',NULL),(1777,7928,40880,14669,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',15054.06,NULL,NULL,1,'2023-02-17 19:11:29','2023-02-17 19:11:29',NULL),(1778,7928,40880,14669,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',30709.99,NULL,NULL,1,'2023-02-17 19:11:29','2023-02-17 19:11:29',NULL),(1779,7928,40880,14669,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',21332.28,NULL,NULL,1,'2023-02-17 19:11:29','2023-02-17 19:11:29',NULL),(1780,7928,40879,11444,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3500.00,NULL,NULL,1,'2023-02-17 19:13:53','2023-02-17 19:13:53',NULL),(1781,7928,40879,11444,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',27003.87,NULL,NULL,1,'2023-02-17 19:13:53','2023-02-17 19:13:53',NULL),(1782,7928,40879,11444,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9937.00,NULL,NULL,1,'2023-02-17 19:13:53','2023-02-17 19:16:54','2023-02-17 19:16:54'),(1783,7928,40879,11444,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',19800.00,NULL,NULL,1,'2023-02-17 19:13:54','2023-02-17 19:20:11','2023-02-17 19:20:11'),(1784,7928,40879,11444,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',0.00,NULL,NULL,1,'2023-02-17 19:13:54','2023-02-17 19:13:54',NULL),(1785,7928,40881,16319,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',42350.00,NULL,NULL,1,'2023-02-17 19:23:54','2023-02-17 19:23:54',NULL),(1786,7928,40881,16319,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4209.80,NULL,NULL,1,'2023-02-17 19:23:54','2023-02-17 19:23:54',NULL),(1787,7928,40881,16319,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',54832.84,NULL,NULL,1,'2023-02-17 19:23:54','2023-02-17 19:23:54',NULL),(1788,7928,40881,16319,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3202.72,NULL,NULL,1,'2023-02-17 19:23:54','2023-02-17 19:23:54',NULL),(1789,7928,40881,16319,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2658.00,NULL,NULL,1,'2023-02-17 19:23:54','2023-02-17 19:27:08','2023-02-17 19:27:08'),(1790,7928,40881,16319,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',699.00,NULL,NULL,1,'2023-02-17 19:23:54','2023-02-17 19:25:55','2023-02-17 19:25:55'),(1791,7928,40881,16319,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',23760.53,NULL,NULL,1,'2023-02-17 19:30:06','2023-02-17 19:30:06',NULL),(1792,7928,40881,16319,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2353.51,NULL,NULL,1,'2023-02-17 19:30:39','2023-02-17 19:30:39',NULL),(1793,7928,40881,16319,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',125.53,NULL,NULL,1,'2023-02-17 19:30:55','2023-02-17 19:30:55',NULL),(1794,7928,40881,16319,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',57365.91,NULL,NULL,1,'2023-02-17 19:31:30','2023-02-17 19:31:30',NULL),(1795,7928,40881,16319,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',13323.79,NULL,NULL,1,'2023-02-17 19:31:51','2023-02-17 19:31:51',NULL);
INSERT INTO `balance_libro` VALUES (1796,7928,40881,16319,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',13150.62,NULL,NULL,1,'2023-02-17 19:32:14','2023-02-17 19:32:14',NULL),(1797,7928,40881,16319,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',129803.56,NULL,NULL,1,'2023-02-17 19:33:45','2023-02-17 19:33:45',NULL),(1798,7928,40903,19625,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6897.00,NULL,NULL,1,'2023-02-22 11:05:45','2023-02-22 11:05:45',NULL),(1799,7928,40903,19625,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',879.63,NULL,NULL,1,'2023-02-22 11:05:45','2023-02-22 11:05:45',NULL),(1800,7928,40903,19625,3,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4237.40,NULL,NULL,1,'2023-02-22 11:05:45','2023-02-22 11:05:45',NULL),(1801,7928,40903,19625,3,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',17666.00,NULL,NULL,1,'2023-02-22 11:05:45','2023-02-22 11:05:45',NULL),(1802,7928,40903,19625,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',113888.58,NULL,NULL,1,'2023-02-22 11:05:45','2023-02-22 11:05:45',NULL),(1803,7928,40903,19625,3,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',9627.53,NULL,NULL,1,'2023-02-22 11:05:45','2023-02-22 11:05:45',NULL),(1804,7928,40903,19625,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',671550.00,NULL,NULL,1,'2023-02-22 11:05:45','2023-02-22 11:05:45',NULL),(1805,7928,40903,19625,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5150.09,NULL,NULL,1,'2023-02-22 11:05:45','2023-02-22 11:05:45',NULL),(1806,7928,40903,19625,3,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',104792.99,NULL,NULL,1,'2023-02-22 11:05:45','2023-02-22 11:05:45',NULL),(1807,7928,40903,19625,3,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7900.00,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:05:46',NULL),(1808,7928,40903,19625,3,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7900.00,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:05:46',NULL),(1809,7928,40903,19625,3,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2400.00,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:05:46',NULL),(1810,7928,40903,19625,3,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',24595.00,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:28:51','2023-02-22 11:28:51'),(1811,7928,40903,19625,3,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',16768.23,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:05:46',NULL),(1812,7928,40903,19625,3,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',15428.00,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:09:50','2023-02-22 11:09:50'),(1813,7928,40903,19625,3,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3465.98,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:05:46',NULL),(1814,7928,40903,19625,3,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',31702.00,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:05:46',NULL),(1815,7928,40903,19625,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',20000.07,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:05:46',NULL);
INSERT INTO `balance_libro` VALUES (1816,7928,40903,19625,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5880.00,NULL,NULL,1,'2023-02-22 11:05:46','2023-02-22 11:29:04','2023-02-22 11:29:04'),(1817,7928,40903,19625,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3793.90,NULL,NULL,1,'2023-02-22 11:40:00','2023-02-22 11:40:00',NULL),(1818,7928,40903,19625,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',14142.29,NULL,NULL,1,'2023-02-22 11:41:54','2023-02-22 11:41:54',NULL),(1819,7928,40903,19625,3,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2460.00,NULL,NULL,1,'2023-02-22 11:43:11','2023-02-22 11:43:11',NULL),(1820,7928,40903,19625,3,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3299.00,NULL,NULL,1,'2023-02-22 11:43:49','2023-02-22 11:43:49',NULL),(1821,7928,40903,19625,3,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',10134.11,NULL,NULL,1,'2023-02-22 11:45:03','2023-02-22 11:45:03',NULL),(1822,7928,40903,19625,3,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5001.51,NULL,NULL,1,'2023-02-22 11:50:07','2023-02-22 11:50:07',NULL),(1823,7928,40903,19625,3,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',11018.09,NULL,NULL,1,'2023-02-22 11:51:36','2023-02-22 11:51:36',NULL),(1824,7928,40903,19625,3,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5007.56,NULL,NULL,1,'2023-02-22 11:52:23','2023-02-22 11:52:23',NULL),(1825,7928,40881,16319,3,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3752.94,NULL,NULL,1,'2023-02-22 17:24:44','2023-02-22 17:24:44',NULL),(1826,7928,40881,16319,3,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',17750.74,NULL,NULL,1,'2023-02-22 17:25:06','2023-02-22 17:25:06',NULL),(1827,7928,40881,16319,3,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2020.58,NULL,NULL,1,'2023-02-22 17:25:25','2023-02-22 17:25:25',NULL),(1828,7928,40881,16319,3,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',29717.42,NULL,NULL,1,'2023-02-22 17:25:52','2023-02-22 17:25:52',NULL),(1829,7928,40881,16319,3,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',210420.17,NULL,NULL,1,'2023-02-22 17:26:10','2023-02-22 17:26:10',NULL),(1830,7928,40881,16319,3,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1279.03,NULL,NULL,1,'2023-02-22 17:26:25','2023-02-22 17:26:25',NULL),(1831,7928,40881,16319,3,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',8710.10,NULL,NULL,1,'2023-02-22 17:26:42','2023-02-22 17:26:42',NULL),(1832,7928,40881,16319,3,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',23055.00,NULL,NULL,1,'2023-02-22 17:27:03','2023-02-22 17:27:03',NULL),(1833,7928,40881,16319,3,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',26063.32,NULL,NULL,1,'2023-02-22 17:27:20','2023-02-22 17:27:20',NULL),(1834,7928,40881,16319,3,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',158631.60,NULL,NULL,1,'2023-02-22 17:27:40','2023-02-22 17:27:40',NULL),(1835,7928,40881,16319,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10741.59,NULL,NULL,1,'2023-02-22 17:27:58','2023-02-22 17:27:58',NULL);
INSERT INTO `balance_libro` VALUES (1836,7928,40882,17972,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5149.99,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:56:30',NULL),(1837,7928,40882,17972,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',240.00,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:56:30',NULL),(1838,7928,40882,17972,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10890.00,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:56:30',NULL),(1839,7928,40882,17972,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',17537.56,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:57:33','2023-02-22 17:57:33'),(1840,7928,40882,17972,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',7015.00,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:56:30',NULL),(1841,7928,40882,17972,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',200.00,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:57:25','2023-02-22 17:57:25'),(1842,7928,40882,17972,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',17537.56,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:57:19','2023-02-22 17:57:19'),(1843,7928,40882,17972,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',9399.09,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:56:30',NULL),(1844,7928,40882,17972,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10001.39,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:56:30',NULL),(1845,7928,40882,17972,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',12967.87,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:56:30',NULL),(1846,7928,40882,17972,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',7361.19,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:56:30',NULL),(1847,7928,40882,17972,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8000.00,NULL,NULL,1,'2023-02-22 17:56:30','2023-02-22 17:56:51','2023-02-22 17:56:51'),(1848,7928,40904,21278,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1799.99,NULL,NULL,1,'2023-02-22 18:05:29','2023-02-22 18:05:29',NULL),(1849,7928,40904,21278,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10220.02,NULL,NULL,1,'2023-02-22 18:05:29','2023-02-22 18:05:29',NULL),(1850,7928,40904,21278,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',41699.95,NULL,NULL,1,'2023-02-22 18:05:29','2023-02-22 18:05:29',NULL),(1851,7928,40906,22838,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',19670.00,NULL,NULL,1,'2023-02-22 18:12:27','2023-02-22 18:12:27',NULL),(1852,7928,40906,22838,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3930.08,NULL,NULL,1,'2023-02-22 18:12:27','2023-02-22 18:12:27',NULL),(1853,7928,40906,22838,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',64866.96,NULL,NULL,1,'2023-02-22 18:12:27','2023-02-22 18:12:27',NULL),(1854,7928,40906,22838,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5950.00,NULL,NULL,1,'2023-02-22 18:12:27','2023-02-22 18:12:27',NULL),(1855,7928,40906,22838,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',26820.01,NULL,NULL,1,'2023-02-22 18:12:27','2023-02-22 18:12:27',NULL);
INSERT INTO `balance_libro` VALUES (1856,7928,40906,22838,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',6000.00,NULL,NULL,1,'2023-02-22 18:12:27','2023-02-22 18:12:27',NULL),(1857,7928,40907,24401,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2100.00,NULL,NULL,1,'2023-02-22 18:15:49','2023-02-22 18:15:49',NULL),(1858,7928,40907,24401,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',9975.00,NULL,NULL,1,'2023-02-22 18:15:49','2023-02-22 18:17:15','2023-02-22 18:17:15'),(1859,7928,40907,24401,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',9975.00,NULL,NULL,1,'2023-02-22 18:15:49','2023-02-22 18:17:23','2023-02-22 18:17:23'),(1860,7928,40907,24401,3,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3880.05,NULL,NULL,1,'2023-02-22 18:15:49','2023-02-22 18:15:49',NULL),(1861,7928,40907,24401,3,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',9975.00,NULL,NULL,1,'2023-02-22 18:15:49','2023-02-22 18:15:49',NULL),(1862,7928,40907,24401,3,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6500.00,NULL,NULL,1,'2023-02-22 18:15:49','2023-02-22 18:15:49',NULL),(1863,7928,40907,24401,3,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8047.00,NULL,NULL,1,'2023-02-22 18:15:49','2023-02-22 18:15:49',NULL),(1864,7928,40907,24401,3,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1158.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1865,7928,40907,24401,3,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6660.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1866,7928,40907,24401,3,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',11705.90,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1867,7928,40907,24401,3,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2020.99,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1868,7928,40907,24401,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',20000.09,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1869,7928,40907,24401,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3.08,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1870,7928,40907,24401,3,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11446.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1871,7928,40907,24401,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',20000.09,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:16:58','2023-02-22 18:16:58'),(1872,7928,40907,24401,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',40000.18,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1873,7928,40907,24401,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2989.99,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1874,7928,40907,24401,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',9000.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1875,7928,40907,24401,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5000.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL);
INSERT INTO `balance_libro` VALUES (1876,7928,40907,24401,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',15302.40,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1877,7928,40907,24401,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10440.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1878,7928,40907,24401,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',15752.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1879,7928,40907,24401,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5500.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1880,7928,40907,24401,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5200.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1881,7928,40907,24401,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',809.42,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1882,7928,40907,24401,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4400.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1883,7928,40907,24401,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4110.33,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1884,7928,40907,24401,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10023.94,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1885,7928,40907,24401,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',9756.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1886,7928,40907,24401,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3442.96,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1887,7928,40907,24401,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3412.20,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1888,7928,40907,24401,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',92999.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1889,7928,40907,24401,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',13680.08,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1890,7928,40907,24401,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4329.37,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1891,7928,40907,24401,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',10950.00,NULL,NULL,1,'2023-02-22 18:15:50','2023-02-22 18:15:50',NULL),(1892,7928,40732,27662,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5500.00,NULL,NULL,1,'2023-02-22 19:05:51','2023-02-22 19:05:51',NULL),(1893,7928,40732,27662,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',21000.00,NULL,NULL,1,'2023-02-22 19:05:51','2023-02-22 19:06:24','2023-02-22 19:06:24'),(1894,7928,40732,27662,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3413.24,NULL,NULL,1,'2023-02-22 19:05:52','2023-02-22 19:05:52',NULL),(1895,7928,40732,27662,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7618.38,NULL,NULL,1,'2023-02-22 19:05:52','2023-02-22 19:05:52',NULL);
INSERT INTO `balance_libro` VALUES (1896,7928,40732,27662,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',123400.00,NULL,NULL,1,'2023-02-22 19:05:52','2023-02-22 19:05:52',NULL),(1897,7928,40732,27662,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5330.94,NULL,NULL,1,'2023-02-22 19:05:52','2023-02-22 19:05:52',NULL),(1898,7928,40732,27662,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',32599.99,NULL,NULL,1,'2023-02-22 19:05:52','2023-02-22 19:05:52',NULL),(1899,7928,40732,27662,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4500.00,NULL,NULL,1,'2023-02-22 19:05:52','2023-02-22 19:06:16','2023-02-22 19:06:16'),(1900,7928,40732,27662,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1978.41,NULL,NULL,1,'2023-02-22 19:12:08','2023-02-22 19:12:08',NULL),(1901,7928,40732,27662,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3956.87,NULL,NULL,1,'2023-02-22 19:12:36','2023-02-22 19:12:36',NULL),(1902,7928,40732,27662,3,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1626.12,NULL,NULL,1,'2023-02-22 19:13:17','2023-02-22 19:13:17',NULL),(1903,7928,40732,27662,3,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3304.01,NULL,NULL,1,'2023-02-22 19:13:50','2023-02-22 19:13:50',NULL),(1904,7928,40732,27662,3,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',12272.05,NULL,NULL,1,'2023-02-22 19:15:07','2023-02-22 19:15:07',NULL),(1905,7928,40732,27662,3,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2967.61,NULL,NULL,1,'2023-02-22 19:15:27','2023-02-22 19:15:27',NULL),(1906,7928,40732,27662,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2967.61,NULL,NULL,1,'2023-02-22 19:15:48','2023-02-22 19:15:48',NULL),(1907,7928,40732,27662,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2299.58,NULL,NULL,1,'2023-02-22 19:16:32','2023-02-22 19:16:32',NULL),(1908,7928,40732,27662,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',6830.05,NULL,NULL,1,'2023-02-22 19:17:08','2023-02-22 19:17:08',NULL),(1909,7928,40732,27662,3,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5278.93,NULL,NULL,1,'2023-02-22 19:20:08','2023-02-22 19:20:08',NULL),(1910,7928,40732,27662,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8991.16,NULL,NULL,1,'2023-02-22 19:20:40','2023-02-22 19:20:40',NULL),(1911,7928,40732,27662,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7571.60,NULL,NULL,1,'2023-02-22 19:21:10','2023-02-22 19:21:10',NULL),(1912,7928,40732,27662,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3958.72,NULL,NULL,1,'2023-02-22 19:21:29','2023-02-22 19:21:29',NULL),(1913,7928,40732,27662,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1379.75,NULL,NULL,1,'2023-02-22 19:21:52','2023-02-22 19:21:52',NULL),(1914,7928,40920,29315,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7500.00,NULL,NULL,1,'2023-02-22 19:27:17','2023-02-22 19:27:17',NULL),(1915,7928,40920,29315,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3267.00,NULL,NULL,1,'2023-02-22 19:27:17','2023-02-22 19:27:17',NULL),(1916,7928,40920,29315,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',12299.93,NULL,NULL,1,'2023-02-22 19:27:17','2023-02-22 19:27:17',NULL);
INSERT INTO `balance_libro` VALUES (1917,7928,40920,29315,3,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5053.78,NULL,NULL,1,'2023-02-22 19:27:17','2023-02-22 19:27:17',NULL),(1918,7928,40920,29315,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',105599.99,NULL,NULL,1,'2023-02-22 19:27:17','2023-02-22 19:27:17',NULL),(1919,7928,40920,29315,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',24658.65,NULL,NULL,1,'2023-02-22 19:27:18','2023-02-22 19:27:18',NULL),(1920,7928,40921,30938,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',49671.98,NULL,NULL,1,'2023-02-23 09:30:37','2023-02-23 09:30:37',NULL),(1921,7928,40921,30938,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4572.65,NULL,NULL,1,'2023-02-23 09:30:37','2023-02-23 09:30:37',NULL),(1922,7928,40921,30938,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',11756.22,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1923,7928,40921,30938,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',232861.00,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1924,7928,40921,30938,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',13680.00,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1925,7928,40921,30938,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10645.10,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1926,7928,40921,30938,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11472.89,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1927,7928,40921,30938,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',458.92,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1928,7928,40921,30938,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4209.80,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1929,7928,40921,30938,3,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1193.18,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1930,7928,40921,30938,3,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',18716.99,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1931,7928,40921,30938,3,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',176400.00,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1932,7928,40921,30938,3,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',27943.00,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1933,7928,40921,30938,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',9959.96,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1934,7928,40921,30938,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',39843.57,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1935,7928,40921,30938,3,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',126762.00,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1936,7928,40921,30938,3,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5352.90,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:37:07','2023-02-23 09:37:07');
INSERT INTO `balance_libro` VALUES (1937,7928,40921,30938,3,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',20726.33,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1938,7928,40921,30938,3,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',148643.96,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1939,7928,40921,30938,3,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5000.00,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1940,7928,40921,30938,3,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',16962.94,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1941,7928,40921,30938,3,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',123414.00,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1942,7928,40921,30938,3,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',52262.28,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1943,7928,40921,30938,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',407475.98,NULL,NULL,1,'2023-02-23 09:30:38','2023-02-23 09:30:38',NULL),(1944,7928,40921,30938,3,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',39533.11,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1945,7928,40921,30938,3,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',118375.13,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1946,7928,40921,30938,3,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',443857.81,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1947,7928,40921,30938,3,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',294581.29,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1948,7928,40921,30938,3,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',39580.01,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1949,7928,40921,30938,3,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',17889.82,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1950,7928,40921,30938,3,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',71066.59,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1951,7928,40921,30938,3,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',40550.31,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1952,7928,40921,30938,3,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',145686.84,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1953,7928,40921,30938,3,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',55079.64,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1954,7928,40921,30938,3,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4462.76,NULL,NULL,1,'2023-02-23 09:30:39','2023-02-23 09:30:39',NULL),(1955,7928,40921,30938,3,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',44217.89,NULL,NULL,1,'2023-02-23 09:45:51','2023-02-23 09:45:51',NULL),(1956,7928,40921,30938,3,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',66328.42,NULL,NULL,1,'2023-02-23 09:48:32','2023-02-23 09:48:32',NULL);
INSERT INTO `balance_libro` VALUES (1957,7928,40921,30938,3,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',40548.89,NULL,NULL,1,'2023-02-23 09:49:21','2023-02-23 09:49:21',NULL),(1958,7928,40921,30938,3,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',38879.61,NULL,NULL,1,'2023-02-23 09:51:17','2023-02-23 09:51:17',NULL),(1959,7928,40921,30938,3,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6703.56,NULL,NULL,1,'2023-02-23 09:52:17','2023-02-23 09:52:17',NULL),(1960,7928,40921,30938,3,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1193.18,NULL,NULL,1,'2023-02-23 09:53:11','2023-02-23 09:53:11',NULL),(1961,7928,40921,30938,3,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11472.89,NULL,NULL,1,'2023-02-23 09:53:58','2023-02-23 09:53:58',NULL),(1962,7928,40921,30938,3,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',458.92,NULL,NULL,1,'2023-02-23 09:55:02','2023-02-23 09:55:02',NULL),(1963,7928,40921,30938,3,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',39533.11,NULL,NULL,1,'2023-02-23 09:55:36','2023-02-23 09:55:36',NULL),(1964,7928,40921,30938,3,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',13001.71,NULL,NULL,1,'2023-02-23 10:01:17','2023-02-23 10:01:17',NULL),(1965,7928,40895,35834,3,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',90000.00,NULL,NULL,1,'2023-02-23 10:40:02','2023-02-23 10:40:02',NULL),(1966,7928,40895,35834,3,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3299.99,NULL,NULL,1,'2023-02-23 10:40:02','2023-02-23 10:40:02',NULL),(1967,7928,40895,35834,3,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',60000.00,NULL,NULL,1,'2023-02-23 10:40:02','2023-02-23 10:40:02',NULL),(1968,7928,40895,35834,3,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',60000.00,NULL,NULL,1,'2023-02-23 10:40:02','2023-02-23 10:41:13','2023-02-23 10:41:13'),(1969,7928,40895,35834,3,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',25958.64,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1970,7928,40895,35834,3,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12600.00,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1971,7928,40895,35834,3,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2574.00,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1972,7928,40895,35834,3,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3294.75,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1973,7928,40895,35834,3,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',75200.00,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1974,7928,40895,35834,3,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',52490.00,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:41:51','2023-02-23 10:41:51'),(1975,7928,40895,35834,3,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',22417.77,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1976,7928,40895,35834,3,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7000.00,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL);
INSERT INTO `balance_libro` VALUES (1977,7928,40895,35834,3,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9710.32,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1978,7928,40895,35834,3,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',234943.52,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1979,7928,40895,35834,3,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',13896.73,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1980,7928,40895,35834,3,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',13919.25,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1981,7928,40895,35834,3,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',2037.45,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1982,7928,40895,35834,3,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',35069.55,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1983,7928,40895,35834,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',22469.82,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1984,7928,40895,35834,3,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6282.01,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1985,7928,40895,35834,3,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',3407.00,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1986,7928,40895,35834,3,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20527.00,NULL,NULL,1,'2023-02-23 10:40:03','2023-02-23 10:40:03',NULL),(1987,7928,40895,35834,3,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',60000.00,NULL,NULL,1,'2023-02-23 10:41:13','2023-02-23 10:41:13',NULL),(1988,7928,40895,35834,3,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',52490.00,NULL,NULL,1,'2023-02-23 10:41:51','2023-02-23 10:41:51',NULL),(1989,7928,40895,35834,3,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',23307.81,NULL,NULL,1,'2023-02-23 10:46:43','2023-02-23 10:46:43',NULL),(1990,7928,40895,35834,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',25878.84,NULL,NULL,1,'2023-02-23 10:50:10','2023-02-23 10:50:10',NULL),(1991,7928,40895,35834,3,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2000.00,NULL,NULL,1,'2023-02-23 10:51:51','2023-02-23 10:51:51',NULL),(1992,7928,40895,35834,3,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',5100.50,NULL,NULL,1,'2023-02-23 10:52:35','2023-02-23 10:52:35',NULL),(1993,7928,40895,35834,3,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4400.00,NULL,NULL,1,'2023-02-23 10:53:40','2023-02-23 10:53:40',NULL),(1994,7928,40895,35834,3,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3000.01,NULL,NULL,1,'2023-02-23 10:54:35','2023-02-23 10:54:35',NULL),(1995,7928,40950,40633,3,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3600.00,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(1996,7928,40950,40633,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',726.00,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(1997,7928,40950,40633,3,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',10320.49,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL);
INSERT INTO `balance_libro` VALUES (1998,7928,40950,40633,3,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4716.77,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(1999,7928,40950,40633,3,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5503.29,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2000,7928,40950,40633,3,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',45010.00,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2001,7928,40950,40633,3,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5880.00,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2002,7928,40950,40633,3,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',63817.63,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2003,7928,40950,40633,3,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17800.00,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2004,7928,40950,40633,3,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1400.01,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2005,7928,40950,40633,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3650.00,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2006,7928,40950,40633,3,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2000.01,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2007,7928,40950,40633,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',119868.98,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2008,7928,40950,40633,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7832.45,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2009,7928,40950,40633,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3159.04,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2010,7928,40950,40633,3,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',20629.40,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2011,7928,40950,40633,3,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1377.37,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2012,7928,40950,40633,3,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',156.17,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2013,7928,40950,40633,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',498.90,NULL,NULL,1,'2023-02-23 11:05:05','2023-02-23 11:05:05',NULL),(2014,7928,40950,40633,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5501.87,NULL,NULL,1,'2023-02-23 11:10:55','2023-02-23 11:10:55',NULL),(2015,7928,40950,40633,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7000.51,NULL,NULL,1,'2023-02-23 11:12:03','2023-02-23 11:12:03',NULL),(2016,7928,40950,40633,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',13601.61,NULL,NULL,1,'2023-02-23 11:13:12','2023-02-23 11:13:12',NULL),(2017,7928,40950,40633,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8000.98,NULL,NULL,1,'2023-02-23 11:13:57','2023-02-23 11:13:57',NULL),(2018,7928,40950,40633,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4502.28,NULL,NULL,1,'2023-02-23 11:15:24','2023-02-23 11:15:24',NULL);
INSERT INTO `balance_libro` VALUES (2019,7928,40950,40633,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2101.40,NULL,NULL,1,'2023-02-23 11:16:15','2023-02-23 11:16:15',NULL),(2020,7928,40950,40633,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',868.33,NULL,NULL,1,'2023-02-23 11:17:30','2023-02-23 11:17:30',NULL),(2021,7928,40950,40633,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',15702.00,NULL,NULL,1,'2023-02-23 11:18:12','2023-02-23 11:18:12',NULL),(2022,7928,40950,40633,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1920.97,NULL,NULL,1,'2023-02-23 11:44:18','2023-02-23 11:44:18',NULL),(2023,7928,40950,40633,3,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2125.01,NULL,NULL,1,'2023-02-23 11:45:12','2023-02-23 11:45:12',NULL),(2024,7928,40950,40633,3,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',20209.82,NULL,NULL,1,'2023-02-23 11:46:12','2023-02-23 11:46:12',NULL),(2025,7928,40950,40633,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1390.02,NULL,NULL,1,'2023-02-23 11:46:54','2023-02-23 11:46:54',NULL),(2026,7928,40950,40633,3,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10000.60,NULL,NULL,1,'2023-02-23 11:48:02','2023-02-23 11:48:02',NULL),(2027,7928,40950,40633,3,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4716.77,NULL,NULL,1,'2023-02-23 11:48:46','2023-02-23 11:48:46',NULL),(2028,7928,40950,40633,3,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',4449.69,NULL,NULL,1,'2023-02-23 11:49:39','2023-02-23 11:49:39',NULL),(2029,7928,40950,40633,3,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',17502.39,NULL,NULL,1,'2023-02-23 11:50:11','2023-02-23 11:50:11',NULL),(2030,7928,40950,40633,3,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',17300.25,NULL,NULL,1,'2023-02-23 11:51:07','2023-02-23 11:51:07',NULL),(2031,7928,40950,40633,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',9657.89,NULL,NULL,1,'2023-02-23 11:55:25','2023-02-23 11:55:25',NULL),(2032,7928,40940,34214,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2899.99,NULL,NULL,1,'2023-02-23 12:05:03','2023-02-23 12:05:03',NULL),(2033,7928,40940,34214,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5149.99,NULL,NULL,1,'2023-02-23 12:05:03','2023-02-23 12:05:03',NULL),(2034,7928,40940,34214,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',4346.97,NULL,NULL,1,'2023-02-23 12:05:03','2023-02-23 12:05:03',NULL),(2035,7928,40940,34214,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3499.99,NULL,NULL,1,'2023-02-23 12:05:03','2023-02-23 12:05:03',NULL),(2036,7928,40940,34214,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',13490.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2037,7928,40940,34214,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',250.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2038,7928,40940,34214,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1196.59,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2039,7928,40940,34214,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4633.14,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL);
INSERT INTO `balance_libro` VALUES (2040,7928,40940,34214,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3598.06,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2041,7928,40940,34214,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',10300.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2042,7928,40940,34214,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',90450.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2043,7928,40940,34214,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',14310.06,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2044,7928,40940,34214,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',11028.21,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2045,7928,40940,34214,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1300.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2046,7928,40940,34214,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',11551.47,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2047,7928,40940,34214,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5399.02,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2048,7928,40940,34214,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',112.98,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2049,7928,40940,34214,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10598.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2050,7928,40940,34214,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',175795.33,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2051,7928,40940,34214,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',19400.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2052,7928,40940,34214,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',198000.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2053,7928,40940,34214,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',194000.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2054,7928,40940,34214,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2000.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2055,7928,40940,34214,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2749.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2056,7928,40940,34214,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',18000.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2057,7928,40940,34214,3,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',19500.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2058,7928,40940,34214,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',872.51,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2059,7928,40940,34214,3,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6000.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2060,7928,40940,34214,3,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',10600.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL);
INSERT INTO `balance_libro` VALUES (2061,7928,40940,34214,3,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',23760.00,NULL,NULL,1,'2023-02-23 12:05:04','2023-02-23 12:05:04',NULL),(2062,7928,40940,34214,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',78668.01,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2063,7928,40940,34214,3,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1757.67,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2064,7928,40940,34214,3,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',6500.00,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2065,7928,40940,34214,3,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',54180.00,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2066,7928,40940,34214,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1879.00,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2067,7928,40940,34214,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8100.01,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2068,7928,40940,34214,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2400.81,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2069,7928,40940,34214,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',206000.00,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2070,7928,40940,34214,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6400.00,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2071,7928,40940,34214,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',102406.00,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2072,7928,40940,34214,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',660.01,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2073,7928,40940,34214,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1198.00,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2074,7928,40940,34214,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4890.00,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2075,7928,40940,34214,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',126998.00,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2076,7928,40940,34214,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',46378.25,NULL,NULL,1,'2023-02-23 12:05:05','2023-02-23 12:05:05',NULL),(2077,7928,40921,30938,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3074.61,NULL,NULL,1,'2023-02-23 17:33:43','2023-02-23 17:33:43',NULL),(2078,7928,40974,32591,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',141600.00,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:37:48',NULL),(2079,7928,40974,32591,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3049.99,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:37:48',NULL),(2080,7928,40974,32591,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',26999.00,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:46:17','2023-02-23 18:46:17');
INSERT INTO `balance_libro` VALUES (2081,7928,40974,32591,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',315.00,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:44:22','2023-02-23 18:44:22'),(2082,7928,40974,32591,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',28999.00,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:40:23','2023-02-23 18:40:23'),(2083,7928,40974,32591,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',20025.72,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:37:48',NULL),(2084,7928,40974,32591,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',78900.60,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:40:08','2023-02-23 18:40:08'),(2085,7928,40974,32591,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',633295.45,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:48:06','2023-02-23 18:48:06'),(2086,7928,40974,32591,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',210100.02,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:37:48',NULL),(2087,7928,40974,32591,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',18106.77,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:39:55','2023-02-23 18:39:55'),(2088,7928,40974,32591,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1808916.54,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:52:23','2023-02-23 18:52:23'),(2089,7928,40974,32591,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',52816.39,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:37:48',NULL),(2090,7928,40974,32591,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1083889.44,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:37:48',NULL),(2091,7928,40974,32591,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',180384.26,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:37:48',NULL),(2092,7928,40974,32591,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',802481.17,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:37:48',NULL),(2093,7928,40974,32591,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',492406.83,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:37:48',NULL),(2094,7928,40974,32591,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4354.79,NULL,NULL,1,'2023-02-23 18:37:48','2023-02-23 18:38:13','2023-02-23 18:38:13'),(2095,7928,40958,37458,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5149.99,NULL,NULL,1,'2023-02-23 19:13:28','2023-02-23 19:13:28',NULL),(2096,7928,40958,37458,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',13000.00,NULL,NULL,1,'2023-02-23 19:13:28','2023-02-23 19:13:28',NULL),(2097,7928,40958,37458,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1342.71,NULL,NULL,1,'2023-02-23 19:13:28','2023-02-23 19:13:28',NULL),(2098,7928,40958,37458,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2600.00,NULL,NULL,1,'2023-02-23 19:13:28','2023-02-23 19:13:28',NULL),(2099,7928,40958,37458,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1900.00,NULL,NULL,1,'2023-02-23 19:13:28','2023-02-23 19:13:28',NULL),(2100,7928,40958,37458,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',16200.81,NULL,NULL,1,'2023-02-23 19:13:28','2023-02-23 19:13:28',NULL);
INSERT INTO `balance_libro` VALUES (2101,7928,40958,37458,3,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',32000.00,NULL,NULL,1,'2023-02-23 19:13:28','2023-02-23 19:13:28',NULL),(2102,7928,40958,37458,3,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',11400.96,NULL,NULL,1,'2023-02-23 19:13:28','2023-02-23 19:13:28',NULL),(2103,7928,40958,37458,3,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3000.00,NULL,NULL,1,'2023-02-23 19:13:28','2023-02-23 19:13:28',NULL),(2104,7928,40958,37458,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4000.02,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2105,7928,40958,37458,3,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1500.01,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2106,7928,40958,37458,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',20798.60,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2107,7928,40958,37458,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',48000.01,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2108,7928,40958,37458,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2043.11,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2109,7928,40958,37458,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',10000.01,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2110,7928,40958,37458,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3300.00,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2111,7928,40958,37458,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',219990.10,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2112,7928,40958,37458,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',24300.00,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2113,7928,40958,37458,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',266200.00,NULL,NULL,1,'2023-02-23 19:13:29','2023-02-23 19:13:29',NULL),(2114,7928,40958,37458,3,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',9500.00,NULL,NULL,1,'2023-02-23 19:17:14','2023-02-23 19:17:14',NULL),(2115,7928,40958,37458,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',27500.00,NULL,NULL,1,'2023-02-23 19:17:33','2023-02-23 19:17:33',NULL),(2116,7928,40958,37458,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',4800.00,NULL,NULL,1,'2023-02-23 19:17:50','2023-02-23 19:17:50',NULL),(2117,7928,40958,37458,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',3750.00,NULL,NULL,1,'2023-02-23 19:18:03','2023-02-23 19:18:03',NULL),(2118,7928,40958,37458,3,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',4400.00,NULL,NULL,1,'2023-02-23 19:18:16','2023-02-23 19:18:16',NULL),(2119,7928,40958,37458,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',50000.00,NULL,NULL,1,'2023-02-23 19:18:29','2023-02-23 19:18:29',NULL),(2120,7928,40958,37458,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',55000.01,NULL,NULL,1,'2023-02-23 19:18:45','2023-02-23 19:18:45',NULL),(2121,7928,40958,37458,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2470.00,NULL,NULL,1,'2023-02-23 19:19:04','2023-02-23 19:19:04',NULL);
INSERT INTO `balance_libro` VALUES (2122,7928,40958,37458,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4300.00,NULL,NULL,1,'2023-02-23 19:19:19','2023-02-23 19:19:19',NULL),(2123,7928,40958,37458,3,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',9200.01,NULL,NULL,1,'2023-02-23 19:19:33','2023-02-23 19:19:33',NULL),(2124,7928,40958,37458,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',37400.00,NULL,NULL,1,'2023-02-23 19:19:45','2023-02-23 19:19:45',NULL),(2125,7928,40958,37458,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',4900.00,NULL,NULL,1,'2023-02-23 19:20:34','2023-02-23 19:20:34',NULL),(2126,7928,40958,37458,3,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',11290.00,NULL,NULL,1,'2023-02-23 19:21:10','2023-02-23 19:21:10',NULL),(2127,7928,40958,37458,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',11180.00,NULL,NULL,1,'2023-02-23 19:21:22','2023-02-23 19:21:22',NULL),(2128,7928,40958,37458,3,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',8450.00,NULL,NULL,1,'2023-02-23 19:21:35','2023-02-23 19:21:35',NULL),(2129,7928,40958,37458,3,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',10000.00,NULL,NULL,1,'2023-02-23 19:21:50','2023-02-23 19:21:50',NULL),(2130,7928,40958,37458,3,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',14130.00,NULL,NULL,1,'2023-02-23 19:22:08','2023-02-23 19:22:08',NULL),(2131,7928,40984,38980,3,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3499.99,NULL,NULL,1,'2023-02-23 19:28:41','2023-02-23 19:28:41',NULL),(2132,7928,40984,38980,3,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',4724.98,NULL,NULL,1,'2023-02-23 19:28:41','2023-02-23 19:28:41',NULL),(2133,7928,40984,38980,3,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2899.99,NULL,NULL,1,'2023-02-23 19:28:41','2023-02-23 19:28:41',NULL),(2134,7928,40984,38980,3,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',54585.00,NULL,NULL,1,'2023-02-23 19:28:41','2023-02-23 19:28:41',NULL),(2135,7928,40984,38980,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',9797.00,NULL,NULL,1,'2023-02-23 19:28:41','2023-02-23 19:28:41',NULL),(2136,7928,40742,9764,3,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',27580.00,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2137,7928,40742,9764,3,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',121764.47,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2138,7928,40742,9764,3,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3299.99,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2139,7928,40742,9764,3,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1048.57,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2140,7928,40742,9764,3,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',47210.11,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2141,7928,40742,9764,3,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4714.44,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2142,7928,40742,9764,3,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',9691.02,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL);
INSERT INTO `balance_libro` VALUES (2143,7928,40742,9764,3,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',32529.60,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2144,7928,40742,9764,3,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7770.22,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2145,7928,40742,9764,3,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',103954.37,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2146,7928,40742,9764,3,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',29050.60,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2147,7928,40742,9764,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',10717.50,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2148,7928,40742,9764,3,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',340474.84,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2149,7928,40742,9764,3,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',29192.74,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2150,7928,40742,9764,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',25492.09,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2151,7928,40742,9764,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',24383.15,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2152,7928,40742,9764,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',82368.41,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2153,7928,40742,9764,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',52512.91,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2154,7928,40742,9764,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14639.47,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2155,7928,40742,9764,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',851.62,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2156,7928,40742,9764,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',127647.97,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2157,7928,40742,9764,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',34495.54,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2158,7928,40742,9764,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',629.15,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2159,7928,40742,9764,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',50238.26,NULL,NULL,1,'2023-02-23 19:41:55','2023-02-23 19:41:55',NULL),(2160,7928,40742,9764,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',12150.00,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2161,7928,40742,9764,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4637.43,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2162,7928,40742,9764,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',46784.56,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2163,7928,40742,9764,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',62230.18,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL);
INSERT INTO `balance_libro` VALUES (2164,7928,40742,9764,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',106023.21,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2165,7928,40742,9764,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',19465.48,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2166,7928,40742,9764,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',26424.50,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2167,7928,40742,9764,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',70383.45,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2168,7928,40742,9764,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',51553.26,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2169,7928,40742,9764,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',901.22,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2170,7928,40742,9764,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',13393.28,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2171,7928,40742,9764,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3702.93,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2172,7928,40742,9764,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',422813.67,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2173,7928,40742,9764,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',654.28,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2174,7928,40742,9764,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',47322.89,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2175,7928,40742,9764,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',27838.44,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2176,7928,40742,9764,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',175651.61,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2177,7928,40742,9764,3,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17148.41,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2178,7928,40742,9764,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',78562.35,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2179,7928,40742,9764,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',710254.96,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2180,7928,40742,9764,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',243410.00,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2181,7928,40742,9764,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',0.01,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2182,7928,40742,9764,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7122.98,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2183,7928,40742,9764,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1132362.82,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2184,7928,40742,9764,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',87239.16,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL);
INSERT INTO `balance_libro` VALUES (2185,7928,40742,9764,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',52074.05,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2186,7928,40742,9764,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',24642.86,NULL,NULL,1,'2023-02-23 19:41:56','2023-02-23 19:41:56',NULL),(2187,7928,40742,9764,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',9918.97,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2188,7928,40742,9764,3,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',23658.76,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2189,7928,40742,9764,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8975.58,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2190,7928,40742,9764,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',99786.00,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2191,7928,40742,9764,3,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3000.00,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2192,7928,40742,9764,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1703.88,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2193,7928,40742,9764,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',109091.82,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2194,7928,40742,9764,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',81929.29,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2195,7928,40742,9764,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',83969.92,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2196,7928,40742,9764,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',11616.62,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2197,7928,40742,9764,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',107336.35,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2198,7928,40742,9764,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',540205.43,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2199,7928,40742,9764,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',78586.18,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2200,7928,40742,9764,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',16377.64,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2201,7928,40742,9764,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',104884.94,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2202,7928,40742,9764,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8710.45,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2203,7928,40742,9764,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',79096.14,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2204,7928,40742,9764,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',157234.08,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2205,7928,40742,9764,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',79739.08,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL);
INSERT INTO `balance_libro` VALUES (2206,7928,40742,9764,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',41060.55,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2207,7928,40742,9764,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1999.04,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2208,7928,40742,9764,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',211160.54,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2209,7928,40742,9764,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-02-23 19:41:57','2023-02-23 19:41:57',NULL),(2210,7928,40740,8112,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',139397.97,NULL,NULL,1,'2023-03-14 19:04:57','2023-03-14 19:04:57',NULL),(2211,7928,40740,8112,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',80820.00,NULL,NULL,1,'2023-03-14 19:07:14','2023-03-14 19:07:14',NULL),(2212,7928,40740,8112,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',42750.00,NULL,NULL,1,'2023-03-14 19:25:06','2023-03-14 19:25:06',NULL),(2213,7928,40740,8112,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',52450.00,NULL,NULL,1,'2023-03-14 19:26:13','2023-03-14 19:26:13',NULL),(2214,7928,40740,8112,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',102760.00,NULL,NULL,1,'2023-03-14 19:26:58','2023-03-14 19:26:58',NULL),(2215,7928,40740,8112,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',61300.00,NULL,NULL,1,'2023-03-14 19:28:00','2023-03-14 19:28:00',NULL),(2216,7928,40740,8112,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',301050.14,NULL,NULL,1,'2023-03-14 19:28:57','2023-03-14 19:28:57',NULL),(2217,7928,40740,8112,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',113360.00,NULL,NULL,1,'2023-03-14 19:40:40','2023-03-14 19:40:40',NULL),(2218,7928,40740,8112,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',37910.00,NULL,NULL,1,'2023-03-14 19:41:56','2023-03-14 19:41:56',NULL),(2219,7928,40740,8112,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',64310.00,NULL,NULL,1,'2023-03-14 19:51:07','2023-03-14 19:51:07',NULL),(2220,7928,40740,8112,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',161100.01,NULL,NULL,1,'2023-03-14 19:52:19','2023-03-14 19:52:19',NULL),(2221,7928,40740,8112,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',50350.00,NULL,NULL,1,'2023-03-14 19:52:57','2023-03-14 19:52:57',NULL),(2222,7928,40740,8112,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',53970.01,NULL,NULL,1,'2023-03-14 19:56:20','2023-03-14 19:56:20',NULL),(2223,7928,40740,8112,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',63340.00,NULL,NULL,1,'2023-03-14 19:57:27','2023-03-14 19:57:27',NULL),(2224,7928,40740,8112,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',89800.00,NULL,NULL,1,'2023-03-14 19:58:32','2023-03-14 19:58:32',NULL),(2225,7928,40740,8112,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',652590.90,NULL,NULL,1,'2023-03-14 20:06:30','2023-03-14 20:06:30',NULL),(2226,7928,40740,8112,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',91150.00,NULL,NULL,1,'2023-03-14 20:07:33','2023-03-14 20:07:33',NULL);
INSERT INTO `balance_libro` VALUES (2227,7928,40740,8112,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',100067.00,NULL,NULL,1,'2023-03-14 20:09:07','2023-03-14 20:09:07',NULL),(2228,7928,40740,8112,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',43450.00,NULL,NULL,1,'2023-03-14 20:09:59','2023-03-14 20:09:59',NULL),(2229,7928,40740,8112,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',94710.00,NULL,NULL,1,'2023-03-14 20:10:37','2023-03-14 20:10:37',NULL),(2230,7928,40740,8112,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',264993.50,NULL,NULL,1,'2023-03-14 20:11:08','2023-03-14 20:11:08',NULL),(2231,7928,40740,8113,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',31550.00,NULL,NULL,1,'2023-04-13 18:56:15','2023-04-13 18:56:15',NULL),(2232,7928,40740,8113,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',85539.99,NULL,NULL,1,'2023-04-13 18:57:46','2023-04-13 18:57:46',NULL),(2233,7928,40740,8113,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',133070.00,NULL,NULL,1,'2023-04-13 18:58:36','2023-04-13 18:58:36',NULL),(2234,7928,40740,8113,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',36309.99,NULL,NULL,1,'2023-04-13 18:59:11','2023-04-13 18:59:11',NULL),(2235,7928,40740,8113,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',152058.00,NULL,NULL,1,'2023-04-13 18:59:40','2023-04-13 18:59:40',NULL),(2236,7928,40740,8113,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',48290.00,NULL,NULL,1,'2023-04-13 19:00:28','2023-04-13 19:00:28',NULL),(2237,7928,40740,8113,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',146750.00,NULL,NULL,1,'2023-04-13 19:01:00','2023-04-13 19:01:00',NULL),(2238,7928,40740,8113,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',151529.99,NULL,NULL,1,'2023-04-13 19:01:30','2023-04-13 19:01:30',NULL),(2239,7928,40740,8113,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',89075.00,NULL,NULL,1,'2023-04-13 19:01:59','2023-04-13 19:01:59',NULL),(2240,7928,40740,8113,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',49284.99,NULL,NULL,1,'2023-04-13 19:02:34','2023-04-13 19:02:34',NULL),(2241,7928,40740,8113,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',165353.54,NULL,NULL,1,'2023-04-13 19:03:22','2023-04-13 19:03:22',NULL),(2242,7928,40740,8113,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',306900.71,NULL,NULL,1,'2023-04-13 19:04:12','2023-04-13 19:04:12',NULL),(2243,7928,40740,8113,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',38815.00,NULL,NULL,1,'2023-04-13 19:04:50','2023-04-13 19:04:50',NULL),(2244,7928,40740,8113,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',88000.00,NULL,NULL,1,'2023-04-13 19:06:05','2023-04-13 19:06:05',NULL),(2245,7928,40740,8113,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',84110.00,NULL,NULL,1,'2023-04-13 19:06:25','2023-04-13 19:06:25',NULL),(2246,7928,40740,8113,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',65780.00,NULL,NULL,1,'2023-04-13 19:06:51','2023-04-13 19:06:51',NULL),(2247,7928,40740,8113,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',217268.66,NULL,NULL,1,'2023-04-13 19:07:54','2023-04-13 19:07:54',NULL);
INSERT INTO `balance_libro` VALUES (2248,7928,40740,8113,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',143650.00,NULL,NULL,1,'2023-04-13 19:08:18','2023-04-13 19:08:18',NULL),(2249,7928,40740,8113,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',163092.00,NULL,NULL,1,'2023-04-13 19:08:47','2023-04-13 19:08:47',NULL),(2250,7928,40740,8113,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',68167.90,NULL,NULL,1,'2023-04-13 19:09:43','2023-04-13 19:09:43',NULL),(2251,7928,40740,8113,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',68085.01,NULL,NULL,1,'2023-04-13 19:10:36','2023-04-13 19:10:36',NULL),(2252,7928,40740,8113,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',81600.00,NULL,NULL,1,'2023-04-13 19:11:22','2023-04-13 19:11:22',NULL),(2253,7928,40740,8113,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',28810.00,NULL,NULL,1,'2023-04-13 19:11:41','2023-04-13 19:11:41',NULL),(2254,7928,40740,8113,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',192650.71,NULL,NULL,1,'2023-04-13 19:12:07','2023-04-13 19:12:07',NULL),(2255,7928,40740,8113,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',129600.00,NULL,NULL,1,'2023-04-13 19:13:52','2023-04-13 19:13:52',NULL),(2256,7928,40921,30940,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1790.00,NULL,NULL,1,'2023-04-14 18:25:14','2023-04-14 18:25:14',NULL),(2257,7928,40921,30940,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',56400.00,NULL,NULL,1,'2023-04-14 18:26:14','2023-04-14 18:26:14',NULL),(2258,7928,40921,30940,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',14540.00,NULL,NULL,1,'2023-04-14 18:26:55','2023-04-14 18:26:55',NULL),(2259,7928,40921,30940,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',26884.00,NULL,NULL,1,'2023-04-14 18:27:44','2023-04-14 18:27:44',NULL),(2260,7928,40921,30940,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',31420.00,NULL,NULL,1,'2023-04-14 18:28:16','2023-04-14 18:28:16',NULL),(2261,7928,40921,30940,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',50414.00,NULL,NULL,1,'2023-04-14 18:28:38','2023-04-14 18:28:38',NULL),(2262,7928,40921,30940,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',29319.99,NULL,NULL,1,'2023-04-14 18:29:28','2023-04-14 18:29:28',NULL),(2263,7928,40921,30940,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',68120.00,NULL,NULL,1,'2023-04-14 18:29:52','2023-04-14 18:29:52',NULL),(2264,7928,40921,30940,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',38180.00,NULL,NULL,1,'2023-04-14 18:32:15','2023-04-14 18:32:15',NULL),(2265,7928,40921,30940,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',221165.00,NULL,NULL,1,'2023-04-14 18:32:33','2023-04-14 18:32:33',NULL),(2266,7928,40921,30940,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',160751.00,NULL,NULL,1,'2023-04-14 18:33:19','2023-04-14 18:33:19',NULL),(2267,7928,40921,30940,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',20960.00,NULL,NULL,1,'2023-04-14 18:33:50','2023-04-14 18:33:50',NULL),(2268,7928,40921,30940,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',24850.00,NULL,NULL,1,'2023-04-14 18:35:32','2023-04-14 18:35:32',NULL);
INSERT INTO `balance_libro` VALUES (2269,7928,40921,30940,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',34660.00,NULL,NULL,1,'2023-04-14 18:36:22','2023-04-14 18:36:22',NULL),(2270,7928,40921,30940,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',26530.00,NULL,NULL,1,'2023-04-14 18:43:18','2023-04-14 18:43:18',NULL),(2271,7928,40921,30940,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',31600.00,NULL,NULL,1,'2023-04-14 18:43:50','2023-04-14 18:43:50',NULL),(2272,7928,40921,30940,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',47666.00,NULL,NULL,1,'2023-04-14 18:49:40','2023-04-14 18:49:40',NULL),(2273,7928,40921,30940,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',52330.00,NULL,NULL,1,'2023-04-14 18:50:12','2023-04-14 18:50:12',NULL),(2274,7928,40921,30940,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',60750.00,NULL,NULL,1,'2023-04-14 18:50:49','2023-04-14 18:50:49',NULL),(2275,7928,40921,30940,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',49350.00,NULL,NULL,1,'2023-04-14 18:51:11','2023-04-14 18:51:11',NULL),(2276,7928,40921,30940,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',80510.00,NULL,NULL,1,'2023-04-14 18:51:50','2023-04-14 18:51:50',NULL),(2277,7928,40921,30940,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',33740.00,NULL,NULL,1,'2023-04-14 18:52:21','2023-04-14 18:52:21',NULL),(2278,7928,40921,30940,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',71725.00,NULL,NULL,1,'2023-04-14 18:52:58','2023-04-14 18:52:58',NULL),(2279,7928,40921,30940,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',63640.00,NULL,NULL,1,'2023-04-14 18:53:43','2023-04-14 18:53:43',NULL),(2280,7928,40921,30940,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',39260.00,NULL,NULL,1,'2023-04-14 18:54:02','2023-04-14 18:54:02',NULL),(2281,7928,40921,30940,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',26261.01,NULL,NULL,1,'2023-04-14 18:54:22','2023-04-14 18:54:22',NULL),(2282,7928,40742,9767,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',68399.33,NULL,NULL,1,'2023-05-18 18:11:35','2023-05-18 18:11:35',NULL),(2283,7928,40742,9767,3,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',11791.89,NULL,NULL,1,'2023-05-18 18:13:45','2023-05-18 18:13:45',NULL),(2284,7928,40742,9767,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',18263.03,NULL,NULL,1,'2023-05-18 18:14:30','2023-05-18 18:14:30',NULL),(2285,7928,40742,9767,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',2278.61,NULL,NULL,1,'2023-05-18 18:17:01','2023-05-18 18:17:01',NULL),(2286,7928,40740,8115,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',56969.99,NULL,NULL,1,'2023-06-14 20:00:34','2023-06-14 20:00:34',NULL),(2287,7928,40740,8120,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',59876.34,NULL,NULL,1,'2023-11-22 15:30:52','2023-11-22 15:30:52',NULL),(2288,7928,40740,8120,3,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',22867.62,NULL,NULL,1,'2023-11-22 15:31:12','2023-11-22 15:31:12',NULL),(2289,7928,40740,8120,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',4800.00,NULL,NULL,1,'2023-11-22 15:32:46','2023-11-22 15:32:46',NULL);
INSERT INTO `balance_libro` VALUES (2290,7928,40740,8120,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',108951.78,NULL,NULL,1,'2023-11-22 15:38:04','2023-11-22 15:38:04',NULL),(2291,7928,40740,8120,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',22392.72,NULL,NULL,1,'2023-11-22 15:40:09','2023-11-22 15:40:09',NULL),(2292,7928,40740,8120,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',20769.75,NULL,NULL,1,'2023-11-22 15:45:12','2023-11-22 15:45:12',NULL),(2293,7928,40740,8120,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',36900.00,NULL,NULL,1,'2023-11-22 15:47:11','2023-11-22 15:47:11',NULL),(2294,7928,40740,8120,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',44000.00,NULL,NULL,1,'2023-11-22 15:48:23','2023-11-22 15:48:23',NULL),(2295,7928,40740,8120,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',119338.82,NULL,NULL,1,'2023-11-22 15:57:54','2023-11-22 15:57:54',NULL),(2296,7928,40740,8120,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',23159.29,NULL,NULL,1,'2023-11-22 15:59:05','2023-11-22 15:59:05',NULL),(2297,7928,40740,8120,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',164437.83,NULL,NULL,1,'2023-11-22 15:59:12','2023-11-22 15:59:12',NULL),(2298,7928,40740,8120,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',9411.13,NULL,NULL,1,'2023-11-22 16:03:57','2023-11-22 16:03:57',NULL),(2299,7928,40740,8120,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',22846.46,NULL,NULL,1,'2023-11-22 16:09:44','2023-11-22 16:09:44',NULL),(2300,7928,40974,32601,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',6162.98,NULL,NULL,1,'2023-12-04 16:03:33','2023-12-04 16:03:33',NULL),(2301,7928,40974,32601,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',275742.76,NULL,NULL,1,'2023-12-04 16:07:34','2023-12-04 16:07:34',NULL),(2302,7928,40974,32601,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',1095170.61,NULL,NULL,1,'2023-12-04 16:07:46','2023-12-04 16:07:46',NULL),(2303,7928,40974,32601,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',6400.76,NULL,NULL,1,'2023-12-04 16:08:08','2023-12-04 16:08:08',NULL),(2304,7928,40974,32601,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',19719.99,NULL,NULL,1,'2023-12-04 16:08:55','2023-12-04 16:08:55',NULL),(2305,7928,40974,32601,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',350900.00,NULL,NULL,1,'2023-12-04 16:13:42','2023-12-04 16:13:42',NULL),(2306,7928,40974,32601,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',76500.00,NULL,NULL,1,'2023-12-04 16:15:28','2023-12-04 16:15:28',NULL),(2307,7928,40974,32601,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',19500.00,NULL,NULL,1,'2023-12-04 16:15:42','2023-12-04 16:15:42',NULL),(2308,7928,40974,32600,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',1512216.86,NULL,NULL,1,'2023-12-04 16:25:33','2023-12-04 16:25:33',NULL),(2309,7928,40974,32600,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',32673.29,NULL,NULL,1,'2023-12-04 16:28:59','2023-12-04 16:28:59',NULL),(2310,7928,40974,32600,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',23994.00,NULL,NULL,1,'2023-12-04 16:31:14','2023-12-04 16:31:14',NULL);
INSERT INTO `balance_libro` VALUES (2311,7928,40974,32600,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',27903.75,NULL,NULL,1,'2023-12-04 16:32:02','2023-12-04 16:32:02',NULL),(2312,7928,40720,1613,2,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',116000.00,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2313,7928,40720,1613,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',553581.72,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2314,7928,40720,1613,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',74554.51,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2315,7928,40720,1613,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1499862.80,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2316,7928,40720,1613,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',53131.43,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2317,7928,40720,1613,2,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',53131.43,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2318,7928,40720,1613,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',108000.00,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2319,7928,40720,1613,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',100000.00,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2320,7928,40720,1613,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',212525.71,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2321,7928,40720,1613,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',100000.00,NULL,NULL,1,'2023-12-12 19:07:38','2023-12-12 19:07:38',NULL),(2322,7928,40720,1614,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',8000.00,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2323,7928,40720,1614,2,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',108000.00,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2324,7928,40720,1614,2,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',324909.20,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2325,7928,40720,1614,2,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1633892.52,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2326,7928,40720,1614,2,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',312567.20,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2327,7928,40720,1614,2,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',916581.05,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2328,7928,40720,1614,2,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1778.77,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2329,7928,40720,1614,2,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',212525.71,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2330,7928,40720,1614,2,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',71600.00,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2331,7928,40720,1614,2,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',53131.43,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL);
INSERT INTO `balance_libro` VALUES (2332,7928,40720,1614,2,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',74554.51,NULL,NULL,1,'2023-12-12 19:11:29','2023-12-12 19:11:29',NULL),(2333,7928,40720,1616,2,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',318067.26,NULL,NULL,1,'2023-12-12 19:12:52','2023-12-12 19:12:52',NULL),(2334,7928,40720,1616,2,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',40000.00,NULL,NULL,1,'2023-12-12 19:12:52','2023-12-12 19:12:52',NULL),(2335,7928,40720,1616,2,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1274226.80,NULL,NULL,1,'2023-12-12 19:12:52','2023-12-12 19:12:52',NULL),(2336,7928,40720,1616,2,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',318072.16,NULL,NULL,1,'2023-12-12 19:12:52','2023-12-12 19:12:52',NULL),(2337,7928,40720,1616,2,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',16000.00,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2338,7928,40720,1616,2,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1184452.79,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2339,7928,40720,1616,2,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',19360.00,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2340,7928,40720,1616,2,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',19360.00,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2341,7928,40720,1616,2,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',148200.00,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2342,7928,40720,1616,2,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1747207.62,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2343,7928,40720,1616,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',27000.00,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2344,7928,40720,1616,2,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',40000.00,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2345,7928,40720,1616,2,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',77457.93,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2346,7928,40720,1616,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',1822693.94,NULL,NULL,1,'2023-12-12 19:12:53','2023-12-12 19:12:53',NULL),(2347,7928,40720,1617,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',387200.00,NULL,NULL,1,'2023-12-12 19:13:47','2023-12-12 19:13:47',NULL),(2348,7928,40720,1617,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1107167.91,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2349,7928,40720,1617,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',269364.91,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2350,7928,40720,1617,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1724505.31,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2351,7928,40720,1617,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',94643.90,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2352,7928,40720,1617,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',269364.91,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL);
INSERT INTO `balance_libro` VALUES (2353,7928,40720,1617,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',284501.72,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2354,7928,40720,1617,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1244798.39,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2355,7928,40720,1617,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',318072.16,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2356,7928,40720,1617,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',40000.00,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2357,7928,40720,1617,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',84499.56,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2358,7928,40720,1617,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',2045435.40,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2359,7928,40720,1617,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',1895031.09,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2360,7928,40720,1617,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',971291.20,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2361,7928,40720,1617,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',550043.01,NULL,NULL,1,'2023-12-12 19:13:48','2023-12-12 19:13:48',NULL),(2362,7928,40720,1618,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',108900.00,NULL,NULL,1,'2023-12-12 19:14:24','2023-12-12 19:14:24',NULL),(2363,7928,40720,1618,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',1107167.91,NULL,NULL,1,'2023-12-12 19:14:24','2023-12-12 19:14:24',NULL),(2364,7928,40720,1618,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',224455.00,NULL,NULL,1,'2023-12-12 19:14:24','2023-12-12 19:14:24',NULL),(2365,7928,40720,1618,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',2129013.07,NULL,NULL,1,'2023-12-12 19:14:24','2023-12-12 19:14:24',NULL),(2366,7928,40720,1618,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',70416.30,NULL,NULL,1,'2023-12-12 19:14:24','2023-12-12 19:14:24',NULL),(2367,7928,40720,1618,2,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',14083.26,NULL,NULL,1,'2023-12-12 19:14:24','2023-12-12 19:14:24',NULL),(2368,7928,40720,1618,2,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',391491.14,NULL,NULL,1,'2023-12-12 19:14:24','2023-12-12 19:14:24',NULL),(2369,7928,40720,1619,2,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',1660.30,NULL,NULL,1,'2023-12-12 19:15:03','2023-12-12 19:15:03',NULL),(2370,7928,40720,1619,2,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',14083.26,NULL,NULL,1,'2023-12-12 19:15:03','2023-12-12 19:15:03',NULL),(2371,7928,40720,1619,2,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',318951.16,NULL,NULL,1,'2023-12-12 19:15:03','2023-12-12 19:15:03',NULL),(2372,7928,40720,1619,2,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1529150.93,NULL,NULL,1,'2023-12-12 19:15:03','2023-12-12 19:15:03',NULL),(2373,7928,40720,1619,2,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',1529150.93,NULL,NULL,1,'2023-12-12 19:15:03','2023-12-12 19:15:03',NULL);
INSERT INTO `balance_libro` VALUES (2374,7928,40720,1619,2,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',1057250.93,NULL,NULL,1,'2023-12-12 19:15:03','2023-12-12 19:15:03',NULL),(2375,7928,40720,1622,2,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',829697.00,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2376,7928,40720,1622,2,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',1493247.69,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2377,7928,40720,1622,2,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',390000.30,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2378,7928,40720,1622,2,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3045721.40,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2379,7928,40720,1622,2,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',3550160.38,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2380,7928,40720,1622,2,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',3353152.00,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2381,7928,40720,1622,2,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',63000.00,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2382,7928,40720,1622,2,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',156507.30,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2383,7928,40720,1622,2,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',104338.20,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2384,7928,40720,1622,2,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',135639.66,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2385,7928,40720,1622,2,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',279000.00,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2386,7928,40720,1622,2,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',2884367.05,NULL,NULL,1,'2023-12-12 19:17:04','2023-12-12 19:17:04',NULL),(2387,7928,40720,1621,2,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',1132731.94,NULL,NULL,1,'2023-12-12 19:19:19','2023-12-12 19:19:19',NULL),(2388,7928,40720,1621,2,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',279000.00,NULL,NULL,1,'2023-12-12 19:19:19','2023-12-12 19:19:19',NULL),(2389,7928,40720,1621,2,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',63000.00,NULL,NULL,1,'2023-12-12 19:19:19','2023-12-12 19:19:19',NULL),(2390,7928,40720,1621,2,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',156507.30,NULL,NULL,1,'2023-12-12 19:19:19','2023-12-12 19:19:19',NULL),(2391,7928,40720,1621,2,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',543174.87,NULL,NULL,1,'2023-12-12 19:19:19','2023-12-12 19:19:19',NULL),(2392,7928,40720,1621,2,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',279000.00,NULL,NULL,1,'2023-12-12 19:19:19','2023-12-12 19:19:19',NULL),(2393,7928,40720,1621,2,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',2969295.79,NULL,NULL,1,'2023-12-12 19:19:19','2023-12-12 19:19:19',NULL);
INSERT INTO `balance_libro` VALUES (2394,7928,40720,1621,2,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',2812983.39,NULL,NULL,1,'2023-12-12 19:19:19','2023-12-12 19:19:19',NULL),(2395,7928,40720,1620,2,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',391491.14,NULL,NULL,1,'2023-12-12 19:21:04','2023-12-12 19:21:04',NULL),(2396,7928,40720,1620,2,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',70416.30,NULL,NULL,1,'2023-12-12 19:21:04','2023-12-12 19:21:04',NULL),(2397,7928,40720,1620,2,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',2217556.38,NULL,NULL,1,'2023-12-12 19:21:04','2023-12-12 19:21:04',NULL),(2398,7928,40720,1620,2,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',2310267.06,NULL,NULL,1,'2023-12-12 19:21:04','2023-12-12 19:21:04',NULL),(2399,7928,40720,1620,2,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',91000.07,NULL,NULL,1,'2023-12-12 19:21:04','2023-12-12 19:21:04',NULL),(2400,7928,40720,1620,2,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',78253.65,NULL,NULL,1,'2023-12-12 19:21:04','2023-12-12 19:21:04',NULL),(2401,7928,40720,1620,2,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',391491.14,NULL,NULL,1,'2023-12-12 19:21:04','2023-12-12 19:21:04',NULL),(2402,7928,40720,1620,2,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',279000.00,NULL,NULL,1,'2023-12-12 19:21:04','2023-12-12 19:21:04',NULL),(2403,7928,40720,1620,2,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',2458041.96,NULL,NULL,1,'2023-12-12 19:21:05','2023-12-12 19:21:05',NULL),(2404,7928,40720,1620,2,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',2577516.48,NULL,NULL,1,'2023-12-12 19:21:05','2023-12-12 19:21:05',NULL),(2405,7928,40720,1620,2,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',780466.94,NULL,NULL,1,'2023-12-12 19:21:05','2023-12-12 19:21:05',NULL),(2406,7928,40720,1613,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3600.00,NULL,NULL,1,'2023-12-12 19:23:36','2023-12-12 19:23:36',NULL),(2407,7928,40720,1613,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5149.99,NULL,NULL,1,'2023-12-12 19:23:36','2023-12-12 19:23:36',NULL),(2408,7928,40720,1613,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',21808.99,NULL,NULL,1,'2023-12-12 19:23:36','2023-12-12 19:23:36',NULL),(2409,7928,40720,1613,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9346.63,NULL,NULL,1,'2023-12-12 19:23:36','2023-12-12 19:23:36',NULL),(2410,7928,40720,1613,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',5130.08,NULL,NULL,1,'2023-12-12 19:23:36','2023-12-12 19:23:36',NULL),(2411,7928,40720,1613,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',10482.90,NULL,NULL,1,'2023-12-12 19:23:36','2023-12-12 19:23:36',NULL),(2412,7928,40720,1613,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',4556.70,NULL,NULL,1,'2023-12-12 19:23:36','2023-12-12 19:23:36',NULL),(2413,7928,40720,1613,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',14759.63,NULL,NULL,1,'2023-12-12 19:23:36','2023-12-12 19:23:36',NULL),(2414,7928,40720,1613,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',16321.09,NULL,NULL,1,'2023-12-12 19:23:36','2023-12-12 19:23:36',NULL);
INSERT INTO `balance_libro` VALUES (2415,7928,40720,1613,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',918.89,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2416,7928,40720,1613,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',7525.79,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2417,7928,40720,1613,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',7795.80,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2418,7928,40720,1613,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4043.94,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2419,7928,40720,1613,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',47336.10,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2420,7928,40720,1613,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1244.46,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2421,7928,40720,1613,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',12612.97,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2422,7928,40720,1613,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',10783.80,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2423,7928,40720,1613,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',720.00,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2424,7928,40720,1613,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',22601.00,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2425,7928,40720,1613,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',192000.00,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2426,7928,40720,1613,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1499.19,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2427,7928,40720,1613,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',2948.64,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2428,7928,40720,1613,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',4899.00,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2429,7928,40720,1613,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',102500.04,NULL,NULL,1,'2023-12-12 19:23:37','2023-12-12 19:23:37',NULL),(2430,7928,40720,1613,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',22135.53,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2431,7928,40720,1613,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',25000.14,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2432,7928,40720,1613,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4128.44,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2433,7928,40720,1613,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',9136.54,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2434,7928,40720,1613,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',12555.20,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2435,7928,40720,1613,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',22869.00,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL);
INSERT INTO `balance_libro` VALUES (2436,7928,40720,1613,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',4400.00,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2437,7928,40720,1613,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',24926.44,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2438,7928,40720,1613,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2000.02,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2439,7928,40720,1613,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',7105.91,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2440,7928,40720,1613,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',35473.05,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2441,7928,40720,1613,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',20995.00,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2442,7928,40720,1613,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',38518.45,NULL,NULL,1,'2023-12-12 19:23:38','2023-12-12 19:23:38',NULL),(2443,7928,40720,1614,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',960.00,NULL,NULL,1,'2023-12-12 19:24:38','2023-12-12 19:24:38',NULL),(2444,7928,40720,1614,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5874.99,NULL,NULL,1,'2023-12-12 19:24:38','2023-12-12 19:24:38',NULL),(2445,7928,40720,1614,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3749.99,NULL,NULL,1,'2023-12-12 19:24:38','2023-12-12 19:24:38',NULL),(2446,7928,40720,1614,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',960.00,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2447,7928,40720,1614,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',13851.51,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2448,7928,40720,1614,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',11489.01,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2449,7928,40720,1614,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2800.00,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2450,7928,40720,1614,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',15213.94,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2451,7928,40720,1614,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',6626.46,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2452,7928,40720,1614,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',6121.98,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2453,7928,40720,1614,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8610.66,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2454,7928,40720,1614,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',2029.83,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2455,7928,40720,1614,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',2029.83,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2456,7928,40720,1614,3,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',17060.04,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL);
INSERT INTO `balance_libro` VALUES (2457,7928,40720,1614,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',26943.67,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2458,7928,40720,1614,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6194.72,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2459,7928,40720,1614,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',4077.02,NULL,NULL,1,'2023-12-12 19:24:39','2023-12-12 19:24:39',NULL),(2460,7928,40720,1614,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1293.32,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2461,7928,40720,1614,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',14438.82,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2462,7928,40720,1614,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',6422.86,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2463,7928,40720,1614,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',20449.00,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2464,7928,40720,1614,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',133022.10,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2465,7928,40720,1614,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',17135.07,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2466,7928,40720,1614,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4530.00,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2467,7928,40720,1614,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4500.00,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2468,7928,40720,1614,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',8825.34,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2469,7928,40720,1614,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',50000.03,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2470,7928,40720,1614,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',11163.33,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2471,7928,40720,1614,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1731.48,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2472,7928,40720,1614,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',44731.49,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2473,7928,40720,1614,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',11337.44,NULL,NULL,1,'2023-12-12 19:24:40','2023-12-12 19:24:40',NULL),(2474,7928,40720,1614,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',24000.00,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2475,7928,40720,1614,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',2404.11,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2476,7928,40720,1614,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',8832.82,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2477,7928,40720,1614,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',18869.99,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL);
INSERT INTO `balance_libro` VALUES (2478,7928,40720,1614,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',3100.00,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2479,7928,40720,1614,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6698.66,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2480,7928,40720,1614,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',19117.01,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2481,7928,40720,1614,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',7619.62,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2482,7928,40720,1614,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2400.00,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2483,7928,40720,1614,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2400.00,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2484,7928,40720,1614,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',12109.99,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2485,7928,40720,1614,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',10000.00,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2486,7928,40720,1614,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',5293.09,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2487,7928,40720,1614,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',10707.06,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2488,7928,40720,1614,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',50277.50,NULL,NULL,1,'2023-12-12 19:24:41','2023-12-12 19:24:41',NULL),(2489,7928,40720,1614,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',5884.60,NULL,NULL,1,'2023-12-12 19:24:42','2023-12-12 19:24:42',NULL),(2490,7928,40720,1614,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',7067.45,NULL,NULL,1,'2023-12-12 19:24:42','2023-12-12 19:24:42',NULL),(2491,7928,40720,1614,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',600.00,NULL,NULL,1,'2023-12-12 19:24:42','2023-12-12 19:24:42',NULL),(2492,7928,40720,1614,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',720.02,NULL,NULL,1,'2023-12-12 19:24:42','2023-12-12 19:24:42',NULL),(2493,7928,40720,1614,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',78373.33,NULL,NULL,1,'2023-12-12 19:24:42','2023-12-12 19:24:42',NULL),(2494,7928,40720,1614,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',15430.89,NULL,NULL,1,'2023-12-12 19:24:42','2023-12-12 19:24:42',NULL),(2495,7928,40720,1614,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',40770.14,NULL,NULL,1,'2023-12-12 19:24:42','2023-12-12 19:24:42',NULL),(2496,7928,40720,1615,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3899.99,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2497,7928,40720,1615,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',5674.99,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2498,7928,40720,1615,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1786.24,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL);
INSERT INTO `balance_libro` VALUES (2499,7928,40720,1615,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',11199.43,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2500,7928,40720,1615,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',11394.62,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2501,7928,40720,1615,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',24875.19,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2502,7928,40720,1615,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',78999.76,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2503,7928,40720,1615,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',8350.06,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2504,7928,40720,1615,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',15730.00,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2505,7928,40720,1615,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',7260.00,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2506,7928,40720,1615,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',4900.00,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2507,7928,40720,1615,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',11199.43,NULL,NULL,1,'2023-12-12 19:25:42','2023-12-12 19:25:42',NULL),(2508,7928,40720,1615,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',9000.00,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2509,7928,40720,1615,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',11198.14,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2510,7928,40720,1615,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',7400.01,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2511,7928,40720,1615,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',500.00,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2512,7928,40720,1615,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',239762.27,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2513,7928,40720,1615,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',164439.00,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2514,7928,40720,1615,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',19279.79,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2515,7928,40720,1615,3,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',17992.60,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2516,7928,40720,1615,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5735.00,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2517,7928,40720,1615,3,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',806.56,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2518,7928,40720,1615,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',6963.63,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2519,7928,40720,1615,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',5570.09,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL);
INSERT INTO `balance_libro` VALUES (2520,7928,40720,1615,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',5880.04,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2521,7928,40720,1615,3,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',228998.00,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2522,7928,40720,1615,3,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',96307.00,NULL,NULL,1,'2023-12-12 19:25:43','2023-12-12 19:25:43',NULL),(2523,7928,40720,1615,3,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',6655.29,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2524,7928,40720,1615,3,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',7675.18,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2525,7928,40720,1615,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1489.06,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2526,7928,40720,1615,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',8144.24,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2527,7928,40720,1615,3,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',73151.74,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2528,7928,40720,1615,3,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',7520.00,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2529,7928,40720,1615,3,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',630.07,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2530,7928,40720,1615,3,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',3760.00,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2531,7928,40720,1615,3,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',940.00,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2532,7928,40720,1615,3,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3418.21,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2533,7928,40720,1615,3,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',10136.74,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2534,7928,40720,1615,3,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',870.00,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2535,7928,40720,1615,3,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',44842.10,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2536,7928,40720,1615,3,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',4800.02,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2537,7928,40720,1615,3,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',10775.46,NULL,NULL,1,'2023-12-12 19:25:44','2023-12-12 19:25:44',NULL),(2538,7928,40720,1615,3,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',6771.14,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2539,7928,40720,1615,3,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',43535.80,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2540,7928,40720,1615,3,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',6041.58,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL);
INSERT INTO `balance_libro` VALUES (2541,7928,40720,1615,3,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',11354.84,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2542,7928,40720,1615,3,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',11318.49,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2543,7928,40720,1615,3,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',9951.00,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2544,7928,40720,1615,3,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',21628.00,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2545,7928,40720,1615,3,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',2450.15,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2546,7928,40720,1615,3,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4566.02,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2547,7928,40720,1615,3,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1017.42,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2548,7928,40720,1615,3,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',6889.99,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2549,7928,40720,1615,3,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',4150.02,NULL,NULL,1,'2023-12-12 19:25:45','2023-12-12 19:25:45',NULL),(2550,7928,40720,1616,3,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',5949.99,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2551,7928,40720,1616,3,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',3899.99,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2552,7928,40720,1616,3,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',1800.04,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2553,7928,40720,1616,3,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',23205.00,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2554,7928,40720,1616,3,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',34401.41,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2555,7928,40720,1616,3,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',31588.00,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2556,7928,40720,1616,3,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',5056.27,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2557,7928,40720,1616,3,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',4800.00,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2558,7928,40720,1616,3,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3013.51,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2559,7928,40720,1616,3,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',664009.69,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2560,7928,40720,1616,3,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',408031.13,NULL,NULL,1,'2023-12-12 19:26:40','2023-12-12 19:26:40',NULL),(2561,7928,40720,1616,3,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',436795.72,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL);
INSERT INTO `balance_libro` VALUES (2562,7928,40720,1616,3,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',10000.04,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2563,7928,40720,1616,3,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',4700.00,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2564,7928,40720,1616,3,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',4750.00,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2565,7928,40720,1616,3,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1489.06,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2566,7928,40720,1616,3,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',8000.00,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2567,7928,40720,1616,3,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',8132.84,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2568,7928,40720,1616,3,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',9000.00,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2569,7928,40720,1616,3,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',6775.28,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2570,7928,40720,1616,3,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',10944.99,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2571,7928,40720,1616,3,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',8999.00,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2572,7928,40720,1616,3,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',10080.99,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2573,7928,40720,1616,3,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',8870.00,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2574,7928,40720,1616,3,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',19940.00,NULL,NULL,1,'2023-12-12 19:26:41','2023-12-12 19:26:41',NULL),(2575,7928,40720,1616,3,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',17200.71,NULL,NULL,1,'2023-12-12 19:26:42','2023-12-12 19:26:42',NULL),(2576,7928,40720,1616,3,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',6880.28,NULL,NULL,1,'2023-12-12 19:26:42','2023-12-12 19:26:42',NULL),(2577,7928,40720,1616,3,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',4649.91,NULL,NULL,1,'2023-12-12 19:26:42','2023-12-12 19:26:42',NULL),(2578,7928,40720,1616,3,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',35729.99,NULL,NULL,1,'2023-12-12 19:26:42','2023-12-12 19:26:42',NULL),(2579,7928,40720,1617,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',8246.22,NULL,NULL,1,'2023-12-12 19:27:29','2023-12-12 19:27:29',NULL),(2580,7928,40720,1617,3,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',6449.99,NULL,NULL,1,'2023-12-12 19:27:29','2023-12-12 19:27:29',NULL),(2581,7928,40720,1617,3,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',4300.00,NULL,NULL,1,'2023-12-12 19:27:29','2023-12-12 19:27:29',NULL),(2582,7928,40720,1617,3,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3372.75,NULL,NULL,1,'2023-12-12 19:27:29','2023-12-12 19:27:29',NULL);
INSERT INTO `balance_libro` VALUES (2583,7928,40720,1617,3,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',57300.01,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2584,7928,40720,1617,3,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',60497.79,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2585,7928,40720,1617,3,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',8811.00,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2586,7928,40720,1617,3,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',5529.36,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2587,7928,40720,1617,3,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',2200.00,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2588,7928,40720,1617,3,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',104590.60,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2589,7928,40720,1617,3,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',671.51,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2590,7928,40720,1617,3,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',133502.36,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2591,7928,40720,1617,3,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',10638.56,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2592,7928,40720,1617,3,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',1797.59,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2593,7928,40720,1617,3,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',1608.19,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2594,7928,40720,1617,3,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',3200.00,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2595,7928,40720,1617,3,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',240947.99,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2596,7928,40720,1617,3,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',1918.49,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2597,7928,40720,1617,3,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',2643.46,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2598,7928,40720,1617,3,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',15047.18,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2599,7928,40720,1617,3,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',10704.46,NULL,NULL,1,'2023-12-12 19:27:30','2023-12-12 19:27:30',NULL),(2600,7928,40720,1617,3,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',5750.52,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2601,7928,40720,1617,3,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',6644.88,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2602,7928,40720,1617,3,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',200000.00,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2603,7928,40720,1617,3,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2000.00,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL);
INSERT INTO `balance_libro` VALUES (2604,7928,40720,1617,3,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2875.89,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2605,7928,40720,1617,3,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',9053.39,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2606,7928,40720,1617,3,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',238184.28,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2607,7928,40720,1617,3,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',401.16,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2608,7928,40720,1617,3,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',4500.00,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2609,7928,40720,1617,3,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',5532.05,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2610,7928,40720,1617,3,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',180243.81,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2611,7928,40720,1617,3,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',159581.94,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2612,7928,40720,1617,3,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',3341.05,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2613,7928,40720,1617,3,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1200.00,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2614,7928,40720,1617,3,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1900.00,NULL,NULL,1,'2023-12-12 19:27:31','2023-12-12 19:27:31',NULL),(2615,7928,40720,1617,3,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1900.00,NULL,NULL,1,'2023-12-12 19:27:32','2023-12-12 19:27:32',NULL),(2616,7928,40720,1617,3,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',4500.00,NULL,NULL,1,'2023-12-12 19:27:32','2023-12-12 19:27:32',NULL),(2617,7928,40720,1617,3,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',2400.00,NULL,NULL,1,'2023-12-12 19:27:32','2023-12-12 19:27:32',NULL),(2618,7928,40720,1617,3,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',3500.00,NULL,NULL,1,'2023-12-12 19:27:32','2023-12-12 19:27:32',NULL),(2619,7928,40720,1617,3,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',4000.00,NULL,NULL,1,'2023-12-12 19:27:32','2023-12-12 19:27:32',NULL),(2620,7928,40720,1617,3,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',12500.00,NULL,NULL,1,'2023-12-12 19:27:32','2023-12-12 19:27:32',NULL),(2621,7928,40720,1617,3,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',230937.03,NULL,NULL,1,'2023-12-12 19:27:32','2023-12-12 19:27:32',NULL),(2622,7928,40720,1617,3,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',99147.42,NULL,NULL,1,'2023-12-12 19:27:32','2023-12-12 19:27:32',NULL),(2623,7928,40720,1617,3,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',729388.12,NULL,NULL,1,'2023-12-12 19:27:32','2023-12-12 19:27:32',NULL),(2624,7928,40720,1618,3,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',4500.00,NULL,NULL,1,'2023-12-12 19:28:21','2023-12-12 19:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2625,7928,40720,1618,3,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',7299.99,NULL,NULL,1,'2023-12-12 19:28:21','2023-12-12 19:28:21',NULL),(2626,7928,40720,1618,3,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',229212.72,NULL,NULL,1,'2023-12-12 19:28:21','2023-12-12 19:28:21',NULL),(2627,7928,40720,1618,3,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1731.01,NULL,NULL,1,'2023-12-12 19:28:21','2023-12-12 19:28:21',NULL),(2628,7928,40720,1618,3,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',24027.03,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2629,7928,40720,1618,3,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',2600.00,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2630,7928,40720,1618,3,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',5395.22,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2631,7928,40720,1618,3,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',17199.99,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2632,7928,40720,1618,3,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',3380.18,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2633,7928,40720,1618,3,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',739.05,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2634,7928,40720,1618,3,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',128431.55,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2635,7928,40720,1618,3,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',100000.00,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2636,7928,40720,1618,3,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',20011.45,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2637,7928,40720,1618,3,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',2600.02,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2638,7928,40720,1618,3,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',120454.00,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2639,7928,40720,1618,3,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',10078.07,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2640,7928,40720,1618,3,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',54000.00,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2641,7928,40720,1618,3,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',7401.28,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2642,7928,40720,1618,3,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',1752.74,NULL,NULL,1,'2023-12-12 19:28:22','2023-12-12 19:28:22',NULL),(2643,7928,40720,1618,3,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',1950.00,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2644,7928,40720,1618,3,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',22680.99,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2645,7928,40720,1618,3,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',298257.96,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL);
INSERT INTO `balance_libro` VALUES (2646,7928,40720,1618,3,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',99147.42,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2647,7928,40720,1618,3,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',5812.05,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2648,7928,40720,1618,3,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',64442.64,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2649,7928,40720,1618,3,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',4800.01,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2650,7928,40720,1618,3,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',156365.00,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2651,7928,40720,1618,3,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',2457.61,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2652,7928,40720,1618,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',236890.00,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2653,7928,40720,1618,3,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',15167.59,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2654,7928,40720,1618,3,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',7854.16,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2655,7928,40720,1618,3,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',11109.09,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2656,7928,40720,1618,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',4300.00,NULL,NULL,1,'2023-12-12 19:28:23','2023-12-12 19:28:23',NULL),(2657,7928,40720,1618,3,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',6612.50,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2658,7928,40720,1618,3,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',1702.26,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2659,7928,40720,1618,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',7380.04,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2660,7928,40720,1618,3,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',35492.93,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2661,7928,40720,1618,3,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',73844.99,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2662,7928,40720,1618,3,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',4600.00,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2663,7928,40720,1618,3,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-23','2023-07-23',9941.33,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2664,7928,40720,1618,3,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',10093.09,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2665,7928,40720,1618,3,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',34671.00,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2666,7928,40720,1618,3,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',18914.95,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL);
INSERT INTO `balance_libro` VALUES (2667,7928,40720,1618,3,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',11208.00,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2668,7928,40720,1618,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',90000.00,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2669,7928,40720,1618,3,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',100417.92,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2670,7928,40720,1618,3,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',10062.94,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2671,7928,40720,1618,3,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',15999.00,NULL,NULL,1,'2023-12-12 19:28:24','2023-12-12 19:28:24',NULL),(2672,7928,40720,1618,3,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',2909807.52,NULL,NULL,1,'2023-12-12 19:28:25','2023-12-12 19:28:25',NULL),(2673,7928,40720,1618,3,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',15605.05,NULL,NULL,1,'2023-12-12 19:28:25','2023-12-12 19:28:25',NULL),(2674,7928,40720,1618,3,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',779.43,NULL,NULL,1,'2023-12-12 19:28:25','2023-12-12 19:28:25',NULL),(2675,7928,40720,1618,3,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',8700.00,NULL,NULL,1,'2023-12-12 19:28:25','2023-12-12 19:28:25',NULL),(2676,7928,40720,1618,3,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',2000.02,NULL,NULL,1,'2023-12-12 19:28:25','2023-12-12 19:28:25',NULL),(2677,7928,40720,1618,3,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',4602.96,NULL,NULL,1,'2023-12-12 19:28:25','2023-12-12 19:28:25',NULL),(2678,7928,40720,1618,3,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',28730.00,NULL,NULL,1,'2023-12-12 19:28:25','2023-12-12 19:28:25',NULL),(2679,7928,40720,1618,3,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2440.00,NULL,NULL,1,'2023-12-12 19:28:25','2023-12-12 19:28:25',NULL),(2680,7928,40720,1619,3,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',82006.20,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2681,7928,40720,1619,3,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',1689.51,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2682,7928,40720,1619,3,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',4700.00,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2683,7928,40720,1619,3,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',30000.02,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2684,7928,40720,1619,3,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',263596.08,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2685,7928,40720,1619,3,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',8149.99,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2686,7928,40720,1619,3,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',5739.05,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2687,7928,40720,1619,3,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',28388.00,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL);
INSERT INTO `balance_libro` VALUES (2688,7928,40720,1619,3,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',4590.00,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2689,7928,40720,1619,3,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',21626.78,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2690,7928,40720,1619,3,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',5400.01,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2691,7928,40720,1619,3,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',23600.02,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2692,7928,40720,1619,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',4300.00,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2693,7928,40720,1619,3,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',2370.05,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2694,7928,40720,1619,3,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',27646.08,NULL,NULL,1,'2023-12-12 19:29:22','2023-12-12 19:29:22',NULL),(2695,7928,40720,1619,3,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',41469.12,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2696,7928,40720,1619,3,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',8160.05,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2697,7928,40720,1619,3,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',24855.71,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2698,7928,40720,1619,3,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',25215.63,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2699,7928,40720,1619,3,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',1890.13,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2700,7928,40720,1619,3,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',58342.39,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2701,7928,40720,1619,3,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',30822.77,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2702,7928,40720,1619,3,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',451613.70,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2703,7928,40720,1619,3,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',6299.26,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2704,7928,40720,1619,3,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',8494.04,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2705,7928,40720,1619,3,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',89735.58,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2706,7928,40720,1619,3,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',8669.43,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2707,7928,40720,1619,3,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',12146.75,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2708,7928,40720,1619,3,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',78430.95,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL);
INSERT INTO `balance_libro` VALUES (2709,7928,40720,1619,3,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',12146.75,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2710,7928,40720,1619,3,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',74130.04,NULL,NULL,1,'2023-12-12 19:29:23','2023-12-12 19:29:23',NULL),(2711,7928,40720,1619,3,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',14927.28,NULL,NULL,1,'2023-12-12 19:29:24','2023-12-12 19:29:24',NULL),(2712,7928,40720,1619,3,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',159440.49,NULL,NULL,1,'2023-12-12 19:29:24','2023-12-12 19:29:24',NULL),(2713,7928,40720,1619,3,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',3935.91,NULL,NULL,1,'2023-12-12 19:29:24','2023-12-12 19:29:24',NULL),(2714,7928,40720,1619,3,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',200083.32,NULL,NULL,1,'2023-12-12 19:29:24','2023-12-12 19:29:24',NULL),(2715,7928,40720,1619,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',38700.01,NULL,NULL,1,'2023-12-12 19:29:24','2023-12-12 19:29:24',NULL),(2716,7928,40720,1619,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',176803.09,NULL,NULL,1,'2023-12-12 19:29:24','2023-12-12 19:29:24',NULL),(2717,7928,40720,1619,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',13690.01,NULL,NULL,1,'2023-12-12 19:29:24','2023-12-12 19:29:24',NULL),(2718,7928,40720,1619,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',153390.00,NULL,NULL,1,'2023-12-12 19:29:24','2023-12-12 19:29:24',NULL),(2719,7928,40720,1619,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1028.50,NULL,NULL,1,'2023-12-12 19:29:24','2023-12-12 19:29:24',NULL),(2720,7928,40720,1620,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',4900.00,NULL,NULL,1,'2023-12-12 19:30:16','2023-12-12 19:30:16',NULL),(2721,7928,40720,1620,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',8899.99,NULL,NULL,1,'2023-12-12 19:30:16','2023-12-12 19:30:16',NULL),(2722,7928,40720,1620,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',10222.91,NULL,NULL,1,'2023-12-12 19:30:16','2023-12-12 19:30:16',NULL),(2723,7928,40720,1620,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',25794.50,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2724,7928,40720,1620,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',100100.82,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2725,7928,40720,1620,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',34163.66,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2726,7928,40720,1620,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',8182.25,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2727,7928,40720,1620,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',10522.61,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2728,7928,40720,1620,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',2831.40,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2729,7928,40720,1620,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',41674.11,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL);
INSERT INTO `balance_libro` VALUES (2730,7928,40720,1620,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',11600.00,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2731,7928,40720,1620,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',7634.62,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2732,7928,40720,1620,3,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',22625.34,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2733,7928,40720,1620,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',7072.15,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2734,7928,40720,1620,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',3449.99,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2735,7928,40720,1620,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',7824.56,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2736,7928,40720,1620,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',23888.47,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2737,7928,40720,1620,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',5901.17,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2738,7928,40720,1620,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',41295.81,NULL,NULL,1,'2023-12-12 19:30:17','2023-12-12 19:30:17',NULL),(2739,7928,40720,1620,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',4412.47,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2740,7928,40720,1620,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',52697.94,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2741,7928,40720,1620,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',13090.02,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2742,7928,40720,1620,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',24145.21,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2743,7928,40720,1620,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',6000.00,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2744,7928,40720,1620,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',2217.37,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2745,7928,40720,1620,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',11942.66,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2746,7928,40720,1620,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',23454.01,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2747,7928,40720,1620,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',2050.58,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2748,7928,40720,1620,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',1171000.05,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2749,7928,40720,1620,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',13430.02,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2750,7928,40720,1620,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',2838.20,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL);
INSERT INTO `balance_libro` VALUES (2751,7928,40720,1620,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',12618.94,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2752,7928,40720,1620,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',37683.11,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2753,7928,40720,1620,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',838000.02,NULL,NULL,1,'2023-12-12 19:30:18','2023-12-12 19:30:18',NULL),(2754,7928,40720,1620,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',10581.48,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2755,7928,40720,1620,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',25282.43,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2756,7928,40720,1620,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',334336.70,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2757,7928,40720,1620,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',20200.81,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2758,7928,40720,1620,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',80963.24,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2759,7928,40720,1620,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',5820.98,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2760,7928,40720,1620,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',14264.87,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2761,7928,40720,1620,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',32299.56,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2762,7928,40720,1620,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',14443.27,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2763,7928,40720,1620,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',6000.00,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2764,7928,40720,1620,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',10100.00,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2765,7928,40720,1620,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',26651.29,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2766,7928,40720,1620,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',6281.93,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2767,7928,40720,1620,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',20000.05,NULL,NULL,1,'2023-12-12 19:30:19','2023-12-12 19:30:19',NULL),(2768,7928,40720,1620,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',73999.99,NULL,NULL,1,'2023-12-12 19:30:20','2023-12-12 19:30:20',NULL),(2769,7928,40720,1620,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',210928.43,NULL,NULL,1,'2023-12-12 19:30:20','2023-12-12 19:30:20',NULL),(2770,7928,40720,1621,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',10250.00,NULL,NULL,1,'2023-12-12 19:31:10','2023-12-12 19:31:10',NULL),(2771,7928,40720,1621,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',34365.52,NULL,NULL,1,'2023-12-12 19:31:10','2023-12-12 19:31:10',NULL);
INSERT INTO `balance_libro` VALUES (2772,7928,40720,1621,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',6400.00,NULL,NULL,1,'2023-12-12 19:31:10','2023-12-12 19:31:10',NULL),(2773,7928,40720,1621,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',14154.96,NULL,NULL,1,'2023-12-12 19:31:10','2023-12-12 19:31:10',NULL),(2774,7928,40720,1621,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',4590.00,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2775,7928,40720,1621,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',3000.00,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2776,7928,40720,1621,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',129400.18,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2777,7928,40720,1621,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',16802.39,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2778,7928,40720,1621,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',7866.00,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2779,7928,40720,1621,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',32791.00,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2780,7928,40720,1621,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',22072.16,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2781,7928,40720,1621,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',4850.83,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2782,7928,40720,1621,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',5745.39,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2783,7928,40720,1621,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',11637.18,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2784,7928,40720,1621,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',2904.00,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2785,7928,40720,1621,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',101204.05,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2786,7928,40720,1621,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',121125.00,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2787,7928,40720,1621,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',121125.00,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2788,7928,40720,1621,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',12126.90,NULL,NULL,1,'2023-12-12 19:31:11','2023-12-12 19:31:11',NULL),(2789,7928,40720,1621,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',189700.00,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2790,7928,40720,1621,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',2926.35,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2791,7928,40720,1621,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',37694.60,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2792,7928,40720,1621,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',9458.68,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL);
INSERT INTO `balance_libro` VALUES (2793,7928,40720,1621,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',494700.05,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2794,7928,40720,1621,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',85529.00,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2795,7928,40720,1621,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',8528.00,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2796,7928,40720,1621,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',7800.00,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2797,7928,40720,1621,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',9090.01,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2798,7928,40720,1621,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',3332.03,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2799,7928,40720,1621,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',5542.56,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2800,7928,40720,1621,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',2367.89,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2801,7928,40720,1621,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',29387.16,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2802,7928,40720,1621,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',14531.28,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2803,7928,40720,1621,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',97355.90,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2804,7928,40720,1621,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',110052.15,NULL,NULL,1,'2023-12-12 19:31:12','2023-12-12 19:31:12',NULL),(2805,7928,40720,1621,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',105197.04,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2806,7928,40720,1621,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',82022.27,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2807,7928,40720,1621,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',30931.41,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2808,7928,40720,1621,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',7200.00,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2809,7928,40720,1621,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',18172.54,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2810,7928,40720,1621,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',11177.52,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2811,7928,40720,1621,3,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',151599.18,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2812,7928,40720,1621,3,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',25679.61,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2813,7928,40720,1621,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',13999.99,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL);
INSERT INTO `balance_libro` VALUES (2814,7928,40720,1621,3,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',4203.70,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2815,7928,40720,1621,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',17392.72,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2816,7928,40720,1621,3,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',42738.83,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2817,7928,40720,1621,3,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',10700.86,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2818,7928,40720,1621,3,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',7611.65,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2819,7928,40720,1621,3,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',299790.60,NULL,NULL,1,'2023-12-12 19:31:13','2023-12-12 19:31:13',NULL),(2820,7928,40720,1621,3,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',11425.87,NULL,NULL,1,'2023-12-12 19:31:14','2023-12-12 19:31:14',NULL),(2821,7928,40720,1621,3,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',113999.64,NULL,NULL,1,'2023-12-12 19:31:14','2023-12-12 19:31:14',NULL),(2822,7928,40720,1621,3,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',39000.01,NULL,NULL,1,'2023-12-12 19:31:14','2023-12-12 19:31:14',NULL),(2823,7928,40720,1622,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',6400.00,NULL,NULL,1,'2023-12-14 19:37:51','2023-12-14 19:37:51',NULL),(2824,7928,40720,1622,3,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',9149.99,NULL,NULL,1,'2023-12-14 19:37:51','2023-12-14 19:37:51',NULL),(2825,7928,40720,1622,3,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',30132.19,NULL,NULL,1,'2023-12-14 19:37:51','2023-12-14 19:37:51',NULL),(2826,7928,40720,1622,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',174700.00,NULL,NULL,1,'2023-12-14 19:37:51','2023-12-14 19:37:51',NULL),(2827,7928,40720,1622,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',109008.25,NULL,NULL,1,'2023-12-14 19:37:51','2023-12-14 19:37:51',NULL),(2828,7928,40720,1622,3,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',8873.06,NULL,NULL,1,'2023-12-14 19:37:51','2023-12-14 19:37:51',NULL),(2829,7928,40720,1622,3,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',27281.21,NULL,NULL,1,'2023-12-14 19:37:51','2023-12-14 19:37:51',NULL),(2830,7928,40720,1622,3,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2900.00,NULL,NULL,1,'2023-12-14 19:37:51','2023-12-14 19:37:51',NULL),(2831,7928,40720,1622,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',13000.02,NULL,NULL,1,'2023-12-14 19:37:51','2023-12-14 19:37:51',NULL),(2832,7928,40720,1622,3,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',69126.25,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2833,7928,40720,1622,3,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',1320.41,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2834,7928,40720,1622,3,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',25748.05,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL);
INSERT INTO `balance_libro` VALUES (2835,7928,40720,1622,3,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',60000.00,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2836,7928,40720,1622,3,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',39339.17,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2837,7928,40720,1622,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',16766.85,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2838,7928,40720,1622,3,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',10082.79,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2839,7928,40720,1622,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',2800.00,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2840,7928,40720,1622,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',13342.75,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2841,7928,40720,1622,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',3377.81,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2842,7928,40720,1622,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',28302.20,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2843,7928,40720,1622,3,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',728665.63,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2844,7928,40720,1622,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',494814.45,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2845,7928,40720,1622,3,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',21515.30,NULL,NULL,1,'2023-12-14 19:37:52','2023-12-14 19:37:52',NULL),(2846,7928,40720,1622,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',45324.18,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL),(2847,7928,40720,1622,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',5918.22,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL),(2848,7928,40720,1622,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',270599.00,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL),(2849,7928,40720,1622,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',237506.40,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL),(2850,7928,40720,1622,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',2598.66,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL),(2851,7928,40720,1622,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',390000.00,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL),(2852,7928,40720,1622,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',8520.02,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL),(2853,7928,40720,1622,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',14000.11,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL),(2854,7928,40720,1622,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',77000.04,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL),(2855,7928,40720,1622,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',6766.32,NULL,NULL,1,'2023-12-14 19:37:53','2023-12-14 19:37:53',NULL);
INSERT INTO `balance_libro` VALUES (2856,7928,40881,16320,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4900.00,NULL,NULL,1,'2024-02-01 19:30:22','2024-02-01 19:30:22',NULL),(2857,7928,40881,16320,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4209.80,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2858,7928,40881,16320,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',4251.02,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2859,7928,40881,16320,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',74985.97,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2860,7928,40881,16320,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',20798.26,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2861,7928,40881,16320,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',10848.22,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2862,7928,40881,16320,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',16546.28,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2863,7928,40881,16320,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',55416.52,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2864,7928,40881,16320,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',31713.66,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2865,7928,40881,16320,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',5184.24,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2866,7928,40881,16320,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',11254.18,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2867,7928,40881,16320,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',58149.00,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2868,7928,40881,16320,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',10223.91,NULL,NULL,1,'2024-02-01 19:30:23','2024-02-01 19:30:23',NULL),(2869,7928,40881,16320,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',4656.06,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2870,7928,40881,16320,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',25631.26,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2871,7928,40881,16320,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',2896.78,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2872,7928,40881,16320,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',30933.71,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2873,7928,40881,16320,3,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',240488.04,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2874,7928,40881,16320,3,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',324933.40,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2875,7928,40881,16320,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',703003.95,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2876,7928,40881,16320,3,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',203941.87,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL);
INSERT INTO `balance_libro` VALUES (2877,7928,40881,16320,3,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',250288.50,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2878,7928,40881,16320,3,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',197059.39,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2879,7928,40881,16320,3,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',195524.06,NULL,NULL,1,'2024-02-01 19:30:24','2024-02-01 19:30:24',NULL),(2880,7928,40881,16320,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',883300.00,NULL,NULL,1,'2024-02-01 19:31:01','2024-02-01 19:31:01',NULL),(2881,7928,40881,16320,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',47000.03,NULL,NULL,1,'2024-02-01 19:31:01','2024-02-01 19:31:01',NULL),(2882,7928,40881,16320,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1800.04,NULL,NULL,1,'2024-02-01 19:31:01','2024-02-01 19:31:01',NULL),(2883,7928,40881,16320,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1356800.04,NULL,NULL,1,'2024-02-01 19:31:01','2024-02-01 19:31:01',NULL),(2884,7928,40881,16320,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',540000.02,NULL,NULL,1,'2024-02-01 19:31:02','2024-02-01 19:31:02',NULL),(2885,7928,40881,16321,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',9503.64,NULL,NULL,1,'2024-02-01 19:32:28','2024-02-01 19:32:28',NULL),(2886,7928,40881,16321,3,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4641.32,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2887,7928,40881,16321,3,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',3613.97,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2888,7928,40881,16321,3,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',900.00,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2889,7928,40881,16321,3,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',12004.78,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2890,7928,40881,16321,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',12990.90,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2891,7928,40881,16321,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',22099.20,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2892,7928,40881,16321,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',20566.60,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2893,7928,40881,16321,3,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',11351.66,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2894,7928,40881,16321,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',186570.83,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2895,7928,40881,16321,3,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',45010.51,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2896,7928,40881,16321,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',194435.99,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL);
INSERT INTO `balance_libro` VALUES (2897,7928,40881,16321,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',194035.87,NULL,NULL,1,'2024-02-01 19:32:29','2024-02-01 19:32:29',NULL),(2898,7928,40881,16321,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2368.10,NULL,NULL,1,'2024-02-01 19:32:30','2024-02-01 19:32:30',NULL),(2899,7928,40881,16321,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',86568.80,NULL,NULL,1,'2024-02-01 19:32:30','2024-02-01 19:32:30',NULL),(2900,7928,40881,16321,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',56941.31,NULL,NULL,1,'2024-02-01 19:32:30','2024-02-01 19:32:30',NULL),(2901,7928,40881,16321,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',216180.41,NULL,NULL,1,'2024-02-01 19:32:30','2024-02-01 19:32:30',NULL),(2902,7928,40881,16321,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',14246.54,NULL,NULL,1,'2024-02-01 19:32:30','2024-02-01 19:32:30',NULL),(2903,7928,40881,16321,2,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',81890.38,NULL,NULL,1,'2024-02-01 19:32:59','2024-02-01 19:32:59',NULL),(2904,7928,40881,16321,2,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',482481.45,NULL,NULL,1,'2024-02-01 19:32:59','2024-02-01 19:32:59',NULL),(2905,7928,40881,16321,2,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',239180.70,NULL,NULL,1,'2024-02-01 19:32:59','2024-02-01 19:32:59',NULL),(2906,7928,40881,16321,2,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',480103.80,NULL,NULL,1,'2024-02-01 19:32:59','2024-02-01 19:32:59',NULL),(2907,7928,40881,16321,2,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',995207.33,NULL,NULL,1,'2024-02-01 19:32:59','2024-02-01 19:32:59',NULL),(2908,7928,40881,16321,2,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1204944.74,NULL,NULL,1,'2024-02-01 19:32:59','2024-02-01 19:32:59',NULL),(2909,7928,40881,16321,2,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',27500.04,NULL,NULL,1,'2024-02-01 19:32:59','2024-02-01 19:32:59',NULL),(2910,7928,40881,16321,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1204944.74,NULL,NULL,1,'2024-02-01 19:33:00','2024-02-01 19:33:00',NULL),(2911,7928,40881,16321,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',91960.00,NULL,NULL,1,'2024-02-01 19:33:00','2024-02-01 19:33:00',NULL),(2912,7928,40881,16321,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',822485.40,NULL,NULL,1,'2024-02-01 19:33:00','2024-02-01 19:33:00',NULL),(2913,7928,40881,16322,3,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4947.65,NULL,NULL,1,'2024-02-01 19:35:13','2024-02-01 19:35:13',NULL),(2914,7928,40881,16322,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',7050.00,NULL,NULL,1,'2024-02-01 19:35:13','2024-02-01 19:35:13',NULL),(2915,7928,40881,16322,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',44019.56,NULL,NULL,1,'2024-02-01 19:35:13','2024-02-01 19:35:13',NULL),(2916,7928,40881,16322,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3596.24,NULL,NULL,1,'2024-02-01 19:35:14','2024-02-01 19:35:14',NULL);
INSERT INTO `balance_libro` VALUES (2917,7928,40881,16322,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',18204.45,NULL,NULL,1,'2024-02-01 19:35:14','2024-02-01 19:35:14',NULL),(2918,7928,40881,16322,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',126.31,NULL,NULL,1,'2024-02-01 19:35:14','2024-02-01 19:35:14',NULL),(2919,7928,40881,16322,3,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',2368.10,NULL,NULL,1,'2024-02-01 19:35:14','2024-02-01 19:35:14',NULL),(2920,7928,40881,16322,3,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',36736.84,NULL,NULL,1,'2024-02-01 19:35:14','2024-02-01 19:35:14',NULL),(2921,7928,40881,16322,3,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',32183.11,NULL,NULL,1,'2024-02-01 19:35:14','2024-02-01 19:35:14',NULL),(2922,7928,40881,16322,3,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',58859.99,NULL,NULL,1,'2024-02-01 19:35:14','2024-02-01 19:35:14',NULL),(2923,7928,40881,16322,3,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',8700.00,NULL,NULL,1,'2024-02-01 19:35:14','2024-02-01 19:35:14',NULL),(2924,7928,40881,16322,3,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',34335.25,NULL,NULL,1,'2024-02-01 19:35:14','2024-02-01 19:35:14',NULL),(2925,7928,40881,16322,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',82999.95,NULL,NULL,1,'2024-02-01 19:35:45','2024-02-01 19:35:45',NULL),(2926,7928,40881,16322,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',12000.00,NULL,NULL,1,'2024-02-01 19:35:45','2024-02-01 19:35:45',NULL),(2927,7928,40881,16322,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',3000.00,NULL,NULL,1,'2024-02-01 19:35:45','2024-02-01 19:35:45',NULL),(2928,7928,40881,16322,2,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',10000.04,NULL,NULL,1,'2024-02-01 19:35:45','2024-02-01 19:35:45',NULL),(2929,7928,40881,16322,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',6000.00,NULL,NULL,1,'2024-02-01 19:35:45','2024-02-01 19:35:45',NULL),(2930,7928,40881,16322,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',20000.00,NULL,NULL,1,'2024-02-01 19:35:46','2024-02-01 19:35:46',NULL),(2931,7928,40881,16323,3,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',15950.72,NULL,NULL,1,'2024-02-01 19:37:57','2024-02-01 19:37:57',NULL),(2932,7928,40881,16323,3,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',22981.13,NULL,NULL,1,'2024-02-01 19:37:57','2024-02-01 19:37:57',NULL),(2933,7928,40881,16323,3,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',51221.49,NULL,NULL,1,'2024-02-01 19:37:57','2024-02-01 19:37:57',NULL),(2934,7928,40881,16323,3,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',3959.99,NULL,NULL,1,'2024-02-01 19:37:57','2024-02-01 19:37:57',NULL),(2935,7928,40881,16323,3,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',5328.62,NULL,NULL,1,'2024-02-01 19:37:57','2024-02-01 19:37:57',NULL),(2936,7928,40881,16323,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',21666.84,NULL,NULL,1,'2024-02-01 19:37:57','2024-02-01 19:37:57',NULL),(2937,7928,40881,16323,3,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',7305.00,NULL,NULL,1,'2024-02-01 19:37:57','2024-02-01 19:37:57',NULL);
INSERT INTO `balance_libro` VALUES (2938,7928,40881,16323,3,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',30437.50,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2939,7928,40881,16323,3,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',50213.40,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2940,7928,40881,16323,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',2545.86,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2941,7928,40881,16323,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',4861.75,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2942,7928,40881,16323,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',2368.10,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2943,7928,40881,16323,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',126.31,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2944,7928,40881,16323,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',21150.12,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2945,7928,40881,16323,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',44546.86,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2946,7928,40881,16323,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',11916.87,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2947,7928,40881,16323,3,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',33042.95,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2948,7928,40881,16323,3,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',29901.83,NULL,NULL,1,'2024-02-01 19:37:58','2024-02-01 19:37:58',NULL),(2949,7928,40881,16323,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',193721.00,NULL,NULL,1,'2024-02-01 19:38:26','2024-02-01 19:38:26',NULL),(2950,7928,40881,16323,2,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',2500.00,NULL,NULL,1,'2024-02-01 19:38:26','2024-02-01 19:38:26',NULL),(2951,7928,40881,16323,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',7000.04,NULL,NULL,1,'2024-02-01 19:38:26','2024-02-01 19:38:26',NULL),(2952,7928,40881,16323,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',7001.06,NULL,NULL,1,'2024-02-01 19:38:26','2024-02-01 19:38:26',NULL),(2953,7928,40881,16323,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',82900.00,NULL,NULL,1,'2024-02-01 19:38:26','2024-02-01 19:38:26',NULL),(2954,7928,40881,16323,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',28000.00,NULL,NULL,1,'2024-02-01 19:38:26','2024-02-01 19:38:26',NULL),(2955,7928,40881,16324,3,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',33365.50,NULL,NULL,1,'2024-02-01 19:40:15','2024-02-01 19:40:15',NULL),(2956,7928,40881,16324,3,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',29694.17,NULL,NULL,1,'2024-02-01 19:40:15','2024-02-01 19:40:15',NULL),(2957,7928,40881,16324,3,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',16642.52,NULL,NULL,1,'2024-02-01 19:40:15','2024-02-01 19:40:15',NULL),(2958,7928,40881,16324,3,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',374385.37,NULL,NULL,1,'2024-02-01 19:40:15','2024-02-01 19:40:15',NULL);
INSERT INTO `balance_libro` VALUES (2959,7928,40881,16324,3,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',5776.22,NULL,NULL,1,'2024-02-01 19:40:15','2024-02-01 19:40:15',NULL),(2960,7928,40881,16324,3,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',21132.67,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2961,7928,40881,16324,3,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',4432.65,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2962,7928,40881,16324,3,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',58047.67,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2963,7928,40881,16324,3,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',24712.52,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2964,7928,40881,16324,3,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',10033.64,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2965,7928,40881,16324,3,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',2368.10,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2966,7928,40881,16324,3,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',126.31,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2967,7928,40881,16324,3,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',3956.10,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2968,7928,40881,16324,3,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',55268.47,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2969,7928,40881,16324,3,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',125852.81,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2970,7928,40881,16324,3,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',17918.84,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2971,7928,40881,16324,3,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',55996.92,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2972,7928,40881,16324,3,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',27346.13,NULL,NULL,1,'2024-02-01 19:40:16','2024-02-01 19:40:16',NULL),(2973,7928,40881,16324,3,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',42698.20,NULL,NULL,1,'2024-02-01 19:40:17','2024-02-01 19:40:17',NULL),(2974,7928,40881,16324,3,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',66750.11,NULL,NULL,1,'2024-02-01 19:40:17','2024-02-01 19:40:17',NULL),(2975,7928,40881,16324,3,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',374385.37,NULL,NULL,1,'2024-02-01 19:40:17','2024-02-01 19:40:17',NULL),(2976,7928,40881,16324,3,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',126160.09,NULL,NULL,1,'2024-02-01 19:40:17','2024-02-01 19:40:17',NULL),(2977,7928,40881,16324,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',320650.00,NULL,NULL,1,'2024-02-01 19:40:44','2024-02-01 19:40:44',NULL),(2978,7928,40881,16324,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',20000.00,NULL,NULL,1,'2024-02-01 19:40:44','2024-02-01 19:40:44',NULL),(2979,7928,40881,16324,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',1062985.00,NULL,NULL,1,'2024-02-01 19:40:44','2024-02-01 19:40:44',NULL);
INSERT INTO `balance_libro` VALUES (2980,7928,40881,16324,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',48000.02,NULL,NULL,1,'2024-02-01 19:40:44','2024-02-01 19:40:44',NULL),(2981,7928,40881,16324,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',338800.00,NULL,NULL,1,'2024-02-01 19:40:44','2024-02-01 19:40:44',NULL),(2982,7928,40881,16324,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',35000.00,NULL,NULL,1,'2024-02-01 19:40:45','2024-02-01 19:40:45',NULL),(2983,7928,40881,16324,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',17000.00,NULL,NULL,1,'2024-02-01 19:40:45','2024-02-01 19:40:45',NULL),(2984,7928,40881,16325,3,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',97278.25,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2985,7928,40881,16325,3,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',25811.00,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2986,7928,40881,16325,3,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',28040.84,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2987,7928,40881,16325,3,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',75082.75,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2988,7928,40881,16325,3,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',6226.76,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2989,7928,40881,16325,3,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',192886.22,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2990,7928,40881,16325,3,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',121628.25,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2991,7928,40881,16325,3,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',19000.00,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2992,7928,40881,16325,3,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',18556.41,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2993,7928,40881,16325,3,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',2760.15,NULL,NULL,1,'2024-02-01 19:53:30','2024-02-01 19:53:30',NULL),(2994,7928,40881,16325,3,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',4780.59,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(2995,7928,40881,16325,3,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',45754.39,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(2996,7928,40881,16325,3,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',22336.54,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(2997,7928,40881,16325,3,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',18221.85,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(2998,7928,40881,16325,3,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',96832.73,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(2999,7928,40881,16325,3,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',126.31,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(3000,7928,40881,16325,3,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',2368.10,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL);
INSERT INTO `balance_libro` VALUES (3001,7928,40881,16325,3,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',66636.37,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(3002,7928,40881,16325,3,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',1160.00,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(3003,7928,40881,16325,3,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',10935.63,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(3004,7928,40881,16325,3,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',64291.67,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(3005,7928,40881,16325,3,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',20508.51,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(3006,7928,40881,16325,3,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',55996.92,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(3007,7928,40881,16325,3,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',61650.01,NULL,NULL,1,'2024-02-01 19:53:31','2024-02-01 19:53:31',NULL),(3008,7928,40881,16325,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',494300.00,NULL,NULL,1,'2024-02-01 19:53:57','2024-02-01 19:53:57',NULL),(3009,7928,40881,16325,2,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',550550.00,NULL,NULL,1,'2024-02-01 19:53:57','2024-02-01 19:53:57',NULL),(3010,7928,40881,16325,2,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',550550.00,NULL,NULL,1,'2024-02-01 19:53:58','2024-02-01 19:53:58',NULL),(3011,7928,40881,16325,2,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',193650.02,NULL,NULL,1,'2024-02-01 19:53:58','2024-02-01 19:53:58',NULL),(3012,7928,40881,16325,2,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',550550.00,NULL,NULL,1,'2024-02-01 19:53:58','2024-02-01 19:53:58',NULL),(3013,7928,40881,16327,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',55200.00,NULL,NULL,1,'2024-02-01 20:00:00','2024-02-01 20:00:00',NULL),(3014,7928,40881,16327,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',37000.00,NULL,NULL,1,'2024-02-01 20:00:00','2024-02-01 20:00:00',NULL),(3015,7928,40881,16327,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',666666.67,NULL,NULL,1,'2024-02-01 20:00:00','2024-02-01 20:00:00',NULL),(3016,7928,40881,16327,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',8580.48,NULL,NULL,1,'2024-02-01 20:00:00','2024-02-01 20:00:00',NULL),(3017,7928,40881,16327,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',5063.56,NULL,NULL,1,'2024-02-01 20:00:00','2024-02-01 20:00:00',NULL),(3018,7928,40881,16327,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',38600.00,NULL,NULL,1,'2024-02-01 20:00:00','2024-02-01 20:00:00',NULL),(3019,7928,40881,16327,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',112700.00,NULL,NULL,1,'2024-02-01 20:00:01','2024-02-01 20:00:01',NULL),(3020,7928,40881,16327,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',20500.06,NULL,NULL,1,'2024-02-01 20:00:01','2024-02-01 20:00:01',NULL);
INSERT INTO `balance_libro` VALUES (3021,7928,40881,16327,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',373750.00,NULL,NULL,1,'2024-02-01 20:00:01','2024-02-01 20:00:01',NULL),(3022,7928,40881,16327,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',10399.86,NULL,NULL,1,'2024-02-01 20:00:01','2024-02-01 20:00:01',NULL),(3023,7928,40881,16327,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',373750.00,NULL,NULL,1,'2024-02-01 20:00:01','2024-02-01 20:00:01',NULL),(3024,7928,40881,16327,3,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',9999.99,NULL,NULL,1,'2024-02-01 20:00:01','2024-02-01 20:00:01',NULL),(3025,7928,40881,16327,3,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',16800.55,NULL,NULL,1,'2024-02-01 20:00:01','2024-02-01 20:00:01',NULL),(3026,7928,40881,16327,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',8750.00,NULL,NULL,1,'2024-02-01 20:00:02','2024-02-01 20:00:02',NULL),(3027,7928,40881,16327,3,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',21000.08,NULL,NULL,1,'2024-02-01 20:00:02','2024-02-01 20:00:02',NULL),(3028,7928,40881,16327,3,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',9562.70,NULL,NULL,1,'2024-02-01 20:00:02','2024-02-01 20:00:02',NULL),(3029,7928,40881,16327,3,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',90800.09,NULL,NULL,1,'2024-02-01 20:00:02','2024-02-01 20:00:02',NULL),(3030,7928,40881,16327,3,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',9000.51,NULL,NULL,1,'2024-02-01 20:00:02','2024-02-01 20:00:02',NULL),(3031,7928,40881,16327,3,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',7301.70,NULL,NULL,1,'2024-02-01 20:00:02','2024-02-01 20:00:02',NULL),(3032,7928,40881,16327,3,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',94175.71,NULL,NULL,1,'2024-02-01 20:00:03','2024-02-01 20:00:03',NULL),(3033,7928,40881,16327,3,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',13299.99,NULL,NULL,1,'2024-02-01 20:00:03','2024-02-01 20:00:03',NULL),(3034,7928,40881,16327,3,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',25253.19,NULL,NULL,1,'2024-02-01 20:00:03','2024-02-01 20:00:03',NULL),(3035,7928,40881,16327,3,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',6801.30,NULL,NULL,1,'2024-02-01 20:00:03','2024-02-01 20:00:03',NULL),(3036,7928,40881,16327,3,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',198000.02,NULL,NULL,1,'2024-02-01 20:00:03','2024-02-01 20:00:03',NULL),(3037,7928,40881,16327,3,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',198000.03,NULL,NULL,1,'2024-02-01 20:00:03','2024-02-01 20:00:03',NULL),(3038,7928,40881,16327,3,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',297000.00,NULL,NULL,1,'2024-02-01 20:00:03','2024-02-01 20:00:03',NULL),(3039,7928,40881,16327,3,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',218600.33,NULL,NULL,1,'2024-02-01 20:00:03','2024-02-01 20:00:03',NULL),(3040,7928,40881,16327,3,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',179057.01,NULL,NULL,1,'2024-02-01 20:00:03','2024-02-01 20:00:03',NULL),(3041,7928,40881,16327,3,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',228000.00,NULL,NULL,1,'2024-02-01 20:00:04','2024-02-01 20:00:04',NULL);
INSERT INTO `balance_libro` VALUES (3042,7928,40881,16327,3,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',179275.42,NULL,NULL,1,'2024-02-01 20:00:04','2024-02-01 20:00:04',NULL),(3043,7928,40881,16327,3,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',192269.00,NULL,NULL,1,'2024-02-01 20:00:04','2024-02-01 20:00:04',NULL),(3044,7928,40881,16327,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',205700.00,NULL,NULL,1,'2024-02-01 20:00:31','2024-02-01 20:00:31',NULL),(3045,7928,40881,16327,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',6100000.04,NULL,NULL,1,'2024-02-01 20:00:31','2024-02-01 20:00:31',NULL),(3046,7928,40881,16327,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',6100000.04,NULL,NULL,1,'2024-02-01 20:00:31','2024-02-01 20:00:31',NULL),(3047,7928,40881,16327,2,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',76230.00,NULL,NULL,1,'2024-02-01 20:00:31','2024-02-01 20:00:31',NULL),(3048,7928,40881,16327,2,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',6100000.04,NULL,NULL,1,'2024-02-01 20:00:31','2024-02-01 20:00:31',NULL),(3049,7928,40881,16327,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',216899.76,NULL,NULL,1,'2024-02-01 20:00:31','2024-02-01 20:00:31',NULL),(3050,7928,40881,16327,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',10000.04,NULL,NULL,1,'2024-02-01 20:00:31','2024-02-01 20:00:31',NULL),(3051,7928,40881,16328,3,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',9034.99,NULL,NULL,1,'2024-02-01 20:01:55','2024-02-01 20:01:55',NULL),(3052,7928,40881,16328,3,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',24591.90,NULL,NULL,1,'2024-02-01 20:01:55','2024-02-01 20:01:55',NULL),(3053,7928,40881,16328,3,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',232900.00,NULL,NULL,1,'2024-02-01 20:01:55','2024-02-01 20:01:55',NULL),(3054,7928,40881,16328,3,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',24859.45,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3055,7928,40881,16328,3,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',9644.46,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3056,7928,40881,16328,3,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',34890.00,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3057,7928,40881,16328,3,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',6592.64,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3058,7928,40881,16328,3,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',66000.29,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3059,7928,40881,16328,3,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',20501.89,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3060,7928,40881,16328,3,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1277429.23,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3061,7928,40881,16328,3,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',5571.53,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL);
INSERT INTO `balance_libro` VALUES (3062,7928,40881,16328,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',173804.40,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3063,7928,40881,16328,3,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',8247.89,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3064,7928,40881,16328,3,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',10092.51,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3065,7928,40881,16328,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',11500.02,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3066,7928,40881,16328,3,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',19500.02,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3067,7928,40881,16328,3,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',270000.00,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3068,7928,40881,16328,3,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-29','2023-10-29',14491.72,NULL,NULL,1,'2024-02-01 20:01:56','2024-02-01 20:01:56',NULL),(3069,7928,40881,16328,3,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',78045.00,NULL,NULL,1,'2024-02-01 20:01:57','2024-02-01 20:01:57',NULL),(3070,7928,40881,16328,2,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',162000.00,NULL,NULL,1,'2024-02-01 20:02:25','2024-02-01 20:02:25',NULL),(3071,7928,40881,16328,2,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',250000.00,NULL,NULL,1,'2024-02-01 20:02:25','2024-02-01 20:02:25',NULL),(3072,7928,40881,16328,2,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',64000.02,NULL,NULL,1,'2024-02-01 20:02:25','2024-02-01 20:02:25',NULL),(3073,7928,40881,16328,2,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',33500.00,NULL,NULL,1,'2024-02-01 20:02:25','2024-02-01 20:02:25',NULL),(3074,7928,40881,16328,2,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',25000.00,NULL,NULL,1,'2024-02-01 20:02:25','2024-02-01 20:02:25',NULL),(3075,7928,40881,16328,2,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',1450200.00,NULL,NULL,1,'2024-02-01 20:02:25','2024-02-01 20:02:25',NULL),(3076,7928,40881,16328,2,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',323000.00,NULL,NULL,1,'2024-02-01 20:02:25','2024-02-01 20:02:25',NULL),(3077,7928,40881,16328,2,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',260500.00,NULL,NULL,1,'2024-02-01 20:02:25','2024-02-01 20:02:25',NULL),(3078,NULL,40881,16329,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',30587.95,NULL,NULL,1,'2024-02-01 20:03:32','2024-02-01 20:03:32',NULL),(3079,NULL,40881,16329,3,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',10869.31,NULL,NULL,1,'2024-02-01 20:03:32','2024-02-01 20:03:32',NULL),(3080,NULL,40881,16329,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',6463.99,NULL,NULL,1,'2024-02-01 20:03:32','2024-02-01 20:03:32',NULL),(3081,NULL,40881,16329,3,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',15501.01,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL);
INSERT INTO `balance_libro` VALUES (3082,NULL,40881,16329,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',471818.79,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3083,NULL,40881,16329,3,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',8000.01,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3084,NULL,40881,16329,3,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',20198.92,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3085,NULL,40881,16329,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',5300.05,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3086,NULL,40881,16329,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',9605.72,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3087,NULL,40881,16329,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',2970.29,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3088,NULL,40881,16329,3,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',2942.24,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3089,NULL,40881,16329,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',4601.90,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3090,NULL,40881,16329,3,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',285609.72,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3091,NULL,40881,16329,3,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',285609.72,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3092,NULL,40881,16329,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',76500.00,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3093,NULL,40881,16329,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',112660.00,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3094,NULL,40881,16329,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',15500.00,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3095,NULL,40881,16329,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',3900.00,NULL,NULL,1,'2024-02-01 20:03:33','2024-02-01 20:03:33',NULL),(3096,NULL,40881,16329,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',16800.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3097,NULL,40881,16329,3,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',19000.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3098,NULL,40881,16329,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',9000.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3099,NULL,40881,16329,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',14300.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3100,NULL,40881,16329,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',9200.02,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3101,NULL,40881,16329,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',10000.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3102,NULL,40881,16329,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',62000.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL);
INSERT INTO `balance_libro` VALUES (3103,NULL,40881,16329,3,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',19000.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3104,NULL,40881,16329,3,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',11000.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3105,NULL,40881,16329,3,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',76000.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3106,NULL,40881,16329,3,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',88000.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3107,NULL,40881,16329,3,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',15200.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3108,NULL,40881,16329,3,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',5200.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3109,NULL,40881,16329,3,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',11500.00,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3110,NULL,40881,16329,3,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4700.03,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3111,NULL,40881,16329,3,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',23153.39,NULL,NULL,1,'2024-02-01 20:03:34','2024-02-01 20:03:34',NULL),(3112,NULL,40881,16329,3,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',1970.00,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3113,NULL,40881,16329,3,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',2000.01,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3114,NULL,40881,16329,3,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',3001.11,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3115,NULL,40881,16329,3,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',1999.99,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3116,NULL,40881,16329,3,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',7401.41,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3117,NULL,40881,16329,3,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',2600.79,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3118,NULL,40881,16329,3,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',2600.00,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3119,NULL,40881,16329,3,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',4500.91,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3120,NULL,40881,16329,3,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',3799.99,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3121,NULL,40881,16329,3,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',6701.44,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3122,NULL,40881,16329,3,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',47508.80,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3123,NULL,40881,16329,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',11502.22,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL);
INSERT INTO `balance_libro` VALUES (3124,NULL,40881,16329,3,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',24101.08,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3125,NULL,40881,16329,3,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',20506.32,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3126,NULL,40881,16329,3,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',3301.40,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3127,NULL,40881,16329,3,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',16999.08,NULL,NULL,1,'2024-02-01 20:03:35','2024-02-01 20:03:35',NULL),(3128,NULL,40881,16329,3,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',20499.30,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3129,NULL,40881,16329,3,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',10300.00,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3130,NULL,40881,16329,3,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',18978.11,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3131,NULL,40881,16329,3,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4869.00,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3132,NULL,40881,16329,3,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4801.36,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3133,NULL,40881,16329,3,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',2701.31,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3134,NULL,40881,16329,3,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',197999.97,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3135,NULL,40881,16329,3,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',396000.10,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3136,NULL,40881,16329,3,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',297000.02,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3137,NULL,40881,16329,3,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',297000.02,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3138,NULL,40881,16329,3,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',74000.14,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3139,NULL,40881,16329,3,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',297000.02,NULL,NULL,1,'2024-02-01 20:03:36','2024-02-01 20:03:36',NULL),(3140,NULL,40881,16329,3,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',197999.96,NULL,NULL,1,'2024-02-01 20:03:37','2024-02-01 20:03:37',NULL),(3141,NULL,40881,16329,3,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',197999.96,NULL,NULL,1,'2024-02-01 20:03:37','2024-02-01 20:03:37',NULL),(3142,7928,40881,16329,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',25000.00,NULL,NULL,1,'2024-02-01 20:04:00','2024-02-01 20:04:00',NULL),(3143,7928,40881,16329,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',713218.77,NULL,NULL,1,'2024-02-01 20:04:00','2024-02-01 20:04:00',NULL);
INSERT INTO `balance_libro` VALUES (3144,7928,40881,16329,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',112000.04,NULL,NULL,1,'2024-02-01 20:04:00','2024-02-01 20:04:00',NULL),(3145,7928,40881,16329,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4582603.96,NULL,NULL,1,'2024-02-01 20:04:00','2024-02-01 20:04:00',NULL),(3146,7928,40881,16329,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4582603.96,NULL,NULL,1,'2024-02-01 20:04:00','2024-02-01 20:04:00',NULL),(3147,7928,40881,16329,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4582603.96,NULL,NULL,1,'2024-02-01 20:04:00','2024-02-01 20:04:00',NULL),(3148,7928,40881,16330,3,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',40000.00,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3149,7928,40881,16330,3,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',6194.00,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3150,7928,40881,16330,3,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',12100.00,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3151,7928,40881,16330,3,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',19275.97,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3152,7928,40881,16330,3,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',100000.00,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3153,7928,40881,16330,3,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',6953.26,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3154,7928,40881,16330,3,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',12610.00,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3155,7928,40881,16330,3,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',33362.60,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3156,7928,40881,16330,3,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',33362.60,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3157,7928,40881,16330,3,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',5842.92,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3158,7928,40881,16330,3,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',6091.76,NULL,NULL,1,'2024-02-01 20:05:24','2024-02-01 20:05:24',NULL),(3159,7928,40881,16330,3,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',2344.54,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3160,7928,40881,16330,3,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',16210.21,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3161,7928,40881,16330,3,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',11771.45,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3162,7928,40881,16330,3,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',191000.00,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3163,7928,40881,16330,3,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',66500.39,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL);
INSERT INTO `balance_libro` VALUES (3164,7928,40881,16330,3,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-25','2023-12-25',25015.57,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3165,7928,40881,16330,3,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',11270.98,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3166,7928,40881,16330,3,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',185000.02,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3167,7928,40881,16330,3,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',1550.00,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3168,7928,40881,16330,3,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',24900.02,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3169,7928,40881,16330,3,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',113200.00,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3170,7928,40881,16330,3,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',134292.04,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3171,7928,40881,16330,3,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',14503.49,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3172,7928,40881,16330,3,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',130000.00,NULL,NULL,1,'2024-02-01 20:05:25','2024-02-01 20:05:25',NULL),(3173,7928,40881,16330,3,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',35500.00,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3174,7928,40881,16330,3,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',7580.00,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3175,7928,40881,16330,3,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',2900.00,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3176,7928,40881,16330,3,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',19300.00,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3177,7928,40881,16330,3,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',25000.00,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3178,7928,40881,16330,3,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',2000.01,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3179,7928,40881,16330,3,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',50799.29,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3180,7928,40881,16330,3,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',3999.99,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3181,7928,40881,16330,3,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2000.01,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3182,7928,40881,16330,3,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4999.99,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3183,7928,40881,16330,3,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',49304.18,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3184,7928,40881,16330,3,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',3132.92,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL);
INSERT INTO `balance_libro` VALUES (3185,7928,40881,16330,3,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',9999.99,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3186,7928,40881,16330,3,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',5002.97,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3187,7928,40881,16330,3,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',2000.01,NULL,NULL,1,'2024-02-01 20:05:26','2024-02-01 20:05:26',NULL),(3188,7928,40881,16330,3,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',7725.20,NULL,NULL,1,'2024-02-01 20:05:27','2024-02-01 20:05:27',NULL),(3189,7928,40881,16330,3,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',7303.58,NULL,NULL,1,'2024-02-01 20:05:27','2024-02-01 20:05:27',NULL),(3190,7928,40881,16330,3,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',42001.47,NULL,NULL,1,'2024-02-01 20:05:27','2024-02-01 20:05:27',NULL),(3191,7928,40881,16330,2,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',518650.04,NULL,NULL,1,'2024-02-01 20:05:47','2024-02-01 20:05:47',NULL),(3192,7928,40881,16330,2,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',290000.02,NULL,NULL,1,'2024-02-01 20:05:47','2024-02-01 20:05:47',NULL),(3193,7928,40903,19626,3,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',52300.00,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3194,7928,40903,19626,3,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',471900.00,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3195,7928,40903,19626,3,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',3265.38,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3196,7928,40903,19626,3,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',5386.92,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3197,7928,40903,19626,3,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',30516.26,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3198,7928,40903,19626,3,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',5230.05,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3199,7928,40903,19626,3,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',15131.94,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3200,7928,40903,19626,3,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2540.65,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3201,7928,40903,19626,3,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6900000.12,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3202,7928,40903,19626,3,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',15058.68,NULL,NULL,1,'2024-02-02 18:06:39','2024-02-02 18:06:39',NULL),(3203,7928,40903,19626,3,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',14888.45,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3204,7928,40903,19626,3,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',5451.98,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3205,7928,40903,19626,3,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2700.00,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL);
INSERT INTO `balance_libro` VALUES (3206,7928,40903,19626,3,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2177.72,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3207,7928,40903,19626,3,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',5386.92,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3208,7928,40903,19626,3,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4063.48,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3209,7928,40903,19626,3,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',4063.24,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3210,7928,40903,19626,3,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',15125.00,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3211,7928,40903,19626,3,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',34183.99,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3212,7928,40903,19626,3,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',16950.71,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3213,7928,40903,19626,3,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',6100.02,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3214,7928,40903,19626,3,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',10329.71,NULL,NULL,1,'2024-02-02 18:06:40','2024-02-02 18:06:40',NULL),(3215,7928,40903,19626,3,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',4296.81,NULL,NULL,1,'2024-02-02 18:06:41','2024-02-02 18:06:41',NULL),(3216,7928,40903,19626,3,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',10760.39,NULL,NULL,1,'2024-02-02 18:06:41','2024-02-02 18:06:41',NULL),(3217,7928,40903,19626,3,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',4060.14,NULL,NULL,1,'2024-02-02 18:06:41','2024-02-02 18:06:41',NULL),(3218,7928,40903,19626,3,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',18618.52,NULL,NULL,1,'2024-02-02 18:06:41','2024-02-02 18:06:41',NULL),(3219,7928,40903,19626,3,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',16617.88,NULL,NULL,1,'2024-02-02 18:06:41','2024-02-02 18:06:41',NULL),(3220,7928,40903,19626,2,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3861594.00,NULL,NULL,1,'2024-02-02 18:07:39','2024-02-02 18:07:39',NULL),(3221,7928,40903,19626,2,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',290399.04,NULL,NULL,1,'2024-02-02 18:07:39','2024-02-02 18:07:39',NULL),(3222,7928,40903,19627,2,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3370818.00,NULL,NULL,1,'2024-02-02 18:09:09','2024-02-02 18:09:09',NULL),(3223,7928,40903,19627,3,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',36455.17,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3224,7928,40903,19627,3,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',11268.08,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3225,7928,40903,19627,3,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',10738.49,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3226,7928,40903,19627,3,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7600.01,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL);
INSERT INTO `balance_libro` VALUES (3227,7928,40903,19627,3,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',9236.41,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3228,7928,40903,19627,3,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',12463.69,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3229,7928,40903,19627,3,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',8000.00,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3230,7928,40903,19627,3,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',8000.01,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3231,7928,40903,19627,3,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1800.04,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3232,7928,40903,19627,3,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',526350.00,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3233,7928,40903,19627,3,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',5368.48,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3234,7928,40903,19627,3,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',9033.86,NULL,NULL,1,'2024-02-02 18:11:08','2024-02-02 18:11:08',NULL),(3235,7928,40903,19627,3,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',17635.62,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3236,7928,40903,19627,3,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',10000.00,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3237,7928,40903,19627,3,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',10000.00,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3238,7928,40903,19627,3,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',13288.48,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3239,7928,40903,19627,3,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',28449.13,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3240,7928,40903,19627,3,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',34110.67,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3241,7928,40903,19627,3,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',10708.85,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3242,7928,40903,19627,3,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4565.01,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3243,7928,40903,19627,3,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5353.53,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3244,7928,40903,19627,3,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',21782.54,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3245,7928,40903,19627,3,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',6000.10,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3246,7928,40903,19627,3,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',5343.55,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL),(3247,7928,40903,19627,3,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',5071.64,NULL,NULL,1,'2024-02-02 18:11:09','2024-02-02 18:11:09',NULL);
INSERT INTO `balance_libro` VALUES (3248,7928,40903,19627,3,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',10707.06,NULL,NULL,1,'2024-02-02 18:11:10','2024-02-02 18:11:10',NULL),(3249,7928,40903,19627,3,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',34834.56,NULL,NULL,1,'2024-02-02 18:11:10','2024-02-02 18:11:10',NULL),(3250,7928,40903,19627,3,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',9636.34,NULL,NULL,1,'2024-02-02 18:11:10','2024-02-02 18:11:10',NULL),(3251,7928,40903,19627,3,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',10893.24,NULL,NULL,1,'2024-02-02 18:11:10','2024-02-02 18:11:10',NULL),(3252,7928,40903,19627,3,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',10895.70,NULL,NULL,1,'2024-02-02 18:11:10','2024-02-02 18:11:10',NULL),(3253,7928,40903,19627,3,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',24250.23,NULL,NULL,1,'2024-02-02 18:11:10','2024-02-02 18:11:10',NULL),(3254,7928,40903,19627,3,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',68500.00,NULL,NULL,1,'2024-02-02 18:11:10','2024-02-02 18:11:10',NULL),(3255,7928,40903,19627,3,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',5072.50,NULL,NULL,1,'2024-02-02 18:11:10','2024-02-02 18:11:10',NULL),(3256,7928,40903,19627,3,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',20809.05,NULL,NULL,1,'2024-02-02 18:11:10','2024-02-02 18:11:10',NULL),(3257,7928,40903,19628,2,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',232319.56,NULL,NULL,1,'2024-02-02 18:13:09','2024-02-02 18:13:09',NULL),(3258,7928,40903,19628,2,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4300703.00,NULL,NULL,1,'2024-02-02 18:13:09','2024-02-02 18:13:09',NULL),(3259,7928,40903,19628,3,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',13919.73,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3260,7928,40903,19628,3,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',12521.07,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3261,7928,40903,19628,3,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',8900.00,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3262,7928,40903,19628,3,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',6683.39,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3263,7928,40903,19628,3,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',34638.58,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3264,7928,40903,19628,3,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',20134.32,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3265,7928,40903,19628,3,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',10687.78,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3266,7928,40903,19628,3,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',13037.66,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3267,7928,40903,19628,3,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',17592.00,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3268,7928,40903,19628,3,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8352.19,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL);
INSERT INTO `balance_libro` VALUES (3269,7928,40903,19628,3,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',14217.50,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3270,7928,40903,19628,3,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',4680.22,NULL,NULL,1,'2024-02-02 18:13:55','2024-02-02 18:13:55',NULL),(3271,7928,40903,19628,3,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',82100.71,NULL,NULL,1,'2024-02-02 18:13:56','2024-02-02 18:13:56',NULL),(3272,7928,40903,19628,3,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1550.02,NULL,NULL,1,'2024-02-02 18:13:56','2024-02-02 18:13:56',NULL),(3273,7928,40903,19628,3,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',2714.18,NULL,NULL,1,'2024-02-02 18:13:56','2024-02-02 18:13:56',NULL),(3274,7928,40903,19628,3,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',37414.52,NULL,NULL,1,'2024-02-02 18:13:56','2024-02-02 18:13:56',NULL),(3275,7928,40903,19628,3,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',8235.51,NULL,NULL,1,'2024-02-02 18:13:56','2024-02-02 18:13:56',NULL),(3276,7928,40903,19628,3,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',2736.70,NULL,NULL,1,'2024-02-02 18:13:56','2024-02-02 18:13:56',NULL),(3277,7928,40903,19628,3,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',5357.14,NULL,NULL,1,'2024-02-02 18:13:56','2024-02-02 18:13:56',NULL),(3278,7928,40903,19629,3,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2170.98,NULL,NULL,1,'2024-02-02 18:15:17','2024-02-02 18:15:17',NULL),(3279,7928,40903,19629,3,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',19299.00,NULL,NULL,1,'2024-02-02 18:15:17','2024-02-02 18:15:17',NULL),(3280,7928,40903,19629,3,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',16791.07,NULL,NULL,1,'2024-02-02 18:15:17','2024-02-02 18:15:17',NULL),(3281,7928,40903,19629,3,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',5000.01,NULL,NULL,1,'2024-02-02 18:15:17','2024-02-02 18:15:17',NULL),(3282,7928,40903,19629,3,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3000.00,NULL,NULL,1,'2024-02-02 18:15:17','2024-02-02 18:15:17',NULL),(3283,7928,40903,19629,3,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6999.80,NULL,NULL,1,'2024-02-02 18:15:17','2024-02-02 18:15:17',NULL),(3284,7928,40903,19629,3,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',3000.81,NULL,NULL,1,'2024-02-02 18:15:17','2024-02-02 18:15:17',NULL),(3285,7928,40903,19629,3,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',10003.62,NULL,NULL,1,'2024-02-02 18:15:17','2024-02-02 18:15:17',NULL),(3286,7928,40903,19629,3,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',8409.63,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3287,7928,40903,19629,3,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',1130.00,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3288,7928,40903,19629,3,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1730.00,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3289,7928,40903,19629,3,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',7997.71,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL);
INSERT INTO `balance_libro` VALUES (3290,7928,40903,19629,3,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',55001.90,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3291,7928,40903,19629,3,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',10002.51,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3292,7928,40903,19629,3,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3993.00,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3293,7928,40903,19629,3,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',17036.05,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3294,7928,40903,19629,3,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2370.00,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3295,7928,40903,19629,3,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',5224.02,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3296,7928,40903,19629,3,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',10000.00,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3297,7928,40903,19629,3,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',60657.30,NULL,NULL,1,'2024-02-02 18:15:18','2024-02-02 18:15:18',NULL),(3298,7928,40903,19629,3,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',7702.19,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3299,7928,40903,19629,3,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',32509.14,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3300,7928,40903,19629,3,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1550.00,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3301,7928,40903,19629,3,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',19360.05,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3302,7928,40903,19629,3,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',18824.30,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3303,7928,40903,19629,3,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3850.00,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3304,7928,40903,19629,3,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',76903.43,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3305,7928,40903,19629,3,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',15001.05,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3306,7928,40903,19629,3,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1600.15,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3307,7928,40903,19629,3,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',13970.50,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3308,7928,40903,19629,3,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',5001.10,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3309,7928,40903,19629,3,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2973.00,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL),(3310,7928,40903,19629,3,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',19438.42,NULL,NULL,1,'2024-02-02 18:15:19','2024-02-02 18:15:19',NULL);
INSERT INTO `balance_libro` VALUES (3311,7928,40903,19629,3,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6000.00,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3312,7928,40903,19629,3,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',13964.70,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3313,7928,40903,19629,3,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',5000.00,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3314,7928,40903,19629,3,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2000.02,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3315,7928,40903,19629,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',10000.00,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3316,7928,40903,19629,3,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',10000.02,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3317,7928,40903,19629,3,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',2600.00,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3318,7928,40903,19629,3,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1150.00,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3319,7928,40903,19629,3,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',10001.21,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3320,7928,40903,19629,3,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',10001.60,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3321,7928,40903,19629,3,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8450.01,NULL,NULL,1,'2024-02-02 18:15:20','2024-02-02 18:15:20',NULL),(3322,7928,40903,19629,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',3750032.00,NULL,NULL,1,'2024-02-02 18:15:48','2024-02-02 18:15:48',NULL),(3323,7928,40903,19630,3,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',23603.04,NULL,NULL,1,'2024-02-02 18:17:12','2024-02-02 18:17:12',NULL),(3324,7928,40903,19630,3,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',671.77,NULL,NULL,1,'2024-02-02 18:17:12','2024-02-02 18:17:12',NULL),(3325,7928,40903,19630,3,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',6799.99,NULL,NULL,1,'2024-02-02 18:17:12','2024-02-02 18:17:12',NULL),(3326,7928,40903,19630,3,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',206000.03,NULL,NULL,1,'2024-02-02 18:17:12','2024-02-02 18:17:12',NULL),(3327,7928,40903,19630,3,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',284765.50,NULL,NULL,1,'2024-02-02 18:17:13','2024-02-02 18:17:13',NULL),(3328,7928,40903,19630,3,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',200000.00,NULL,NULL,1,'2024-02-02 18:17:13','2024-02-02 18:17:13',NULL),(3329,7928,40903,19630,3,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',19890.00,NULL,NULL,1,'2024-02-02 18:17:13','2024-02-02 18:17:13',NULL),(3330,7928,40903,19630,3,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',3100.04,NULL,NULL,1,'2024-02-02 18:17:13','2024-02-02 18:17:13',NULL),(3331,7928,40903,19632,3,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',100000.00,NULL,NULL,1,'2024-02-02 18:20:42','2024-02-02 18:20:42',NULL);
INSERT INTO `balance_libro` VALUES (3332,7928,40903,19632,3,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',8600.00,NULL,NULL,1,'2024-02-02 18:20:42','2024-02-02 18:20:42',NULL),(3333,7928,40903,19632,3,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',34769.08,NULL,NULL,1,'2024-02-02 18:20:42','2024-02-02 18:20:42',NULL),(3334,7928,40903,19632,2,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',4777080.00,NULL,NULL,1,'2024-02-02 18:21:09','2024-02-02 18:21:09',NULL),(3335,7928,40903,19633,3,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',25260.94,NULL,NULL,1,'2024-02-02 18:22:10','2024-02-02 18:22:10',NULL),(3336,7928,40903,19633,3,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',7366.85,NULL,NULL,1,'2024-02-02 18:22:10','2024-02-02 18:22:10',NULL),(3337,7928,40903,19633,3,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',100000.00,NULL,NULL,1,'2024-02-02 18:22:10','2024-02-02 18:22:10',NULL),(3338,7928,40903,19633,3,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',25400.00,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3339,7928,40903,19633,3,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',48365.42,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3340,7928,40903,19633,3,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',15396.85,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3341,7928,40903,19633,3,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',15618.90,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3342,7928,40903,19633,3,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',11109.14,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3343,7928,40903,19633,3,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',10522.51,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3344,7928,40903,19633,3,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',3039.28,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3345,7928,40903,19633,3,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',5500.00,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3346,7928,40903,19633,3,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',15145.53,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3347,7928,40903,19633,3,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',1653.91,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3348,7928,40903,19633,3,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',25097.00,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3349,7928,40903,19633,3,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',10509.95,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3350,7928,40903,19633,3,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',13500.00,NULL,NULL,1,'2024-02-02 18:22:11','2024-02-02 18:22:11',NULL),(3351,7928,40903,19633,3,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',54393.23,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3352,7928,40903,19633,3,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-17','2023-09-17',24177.47,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL);
INSERT INTO `balance_libro` VALUES (3353,7928,40903,19633,3,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',55300.00,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3354,7928,40903,19633,3,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',21392.32,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3355,7928,40903,19633,3,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',10509.95,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3356,7928,40903,19633,3,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',11609.35,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3357,7928,40903,19633,3,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',10510.07,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3358,7928,40903,19633,3,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',5000.20,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3359,7928,40903,19633,3,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',4912.09,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3360,7928,40903,19633,3,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',179.09,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3361,7928,40903,19633,3,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',5938.87,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3362,7928,40903,19633,3,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',10510.07,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3363,7928,40903,19633,3,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',5924.68,NULL,NULL,1,'2024-02-02 18:22:12','2024-02-02 18:22:12',NULL),(3364,7928,40903,19633,3,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',10510.07,NULL,NULL,1,'2024-02-02 18:22:13','2024-02-02 18:22:13',NULL),(3365,7928,40903,19633,3,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',5256.16,NULL,NULL,1,'2024-02-02 18:22:13','2024-02-02 18:22:13',NULL),(3366,7928,40903,19634,3,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',52168.49,NULL,NULL,1,'2024-02-02 18:23:19','2024-02-02 18:23:19',NULL),(3367,7928,40903,19634,3,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',18027.23,NULL,NULL,1,'2024-02-02 18:23:19','2024-02-02 18:23:19',NULL),(3368,7928,40903,19634,3,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',10519.51,NULL,NULL,1,'2024-02-02 18:23:19','2024-02-02 18:23:19',NULL),(3369,7928,40903,19634,3,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',10517.87,NULL,NULL,1,'2024-02-02 18:23:19','2024-02-02 18:23:19',NULL),(3370,7928,40903,19634,3,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',10510.07,NULL,NULL,1,'2024-02-02 18:23:19','2024-02-02 18:23:19',NULL),(3371,7928,40903,19634,3,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',1316.56,NULL,NULL,1,'2024-02-02 18:23:19','2024-02-02 18:23:19',NULL),(3372,7928,40903,19634,3,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',10513.87,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3373,7928,40903,19634,3,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',8803.65,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL);
INSERT INTO `balance_libro` VALUES (3374,7928,40903,19634,3,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-08','2023-10-08',10000.00,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3375,7928,40903,19634,3,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',122000.00,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3376,7928,40903,19634,3,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',10510.07,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3377,7928,40903,19634,3,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',10516.72,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3378,7928,40903,19634,3,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-15','2023-10-15',21019.99,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3379,7928,40903,19634,3,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',10510.07,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3380,7928,40903,19634,3,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',10603.90,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3381,7928,40903,19634,3,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',3000.00,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3382,7928,40903,19634,3,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',5262.93,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3383,7928,40903,19634,3,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',79932.18,NULL,NULL,1,'2024-02-02 18:23:20','2024-02-02 18:23:20',NULL),(3384,7928,40903,19634,3,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',2820.00,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3385,7928,40903,19634,3,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',9999.99,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3386,7928,40903,19634,3,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',25400.02,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3387,7928,40903,19634,3,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',10009.21,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3388,7928,40903,19634,3,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',10003.93,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3389,7928,40903,19634,3,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',10007.71,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3390,7928,40903,19634,3,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',8699.99,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3391,7928,40903,19634,3,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',18590.00,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3392,7928,40903,19634,3,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',10000.04,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3393,7928,40903,19634,3,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',10006.50,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3394,7928,40903,19634,3,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',3000.00,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL);
INSERT INTO `balance_libro` VALUES (3395,7928,40903,19634,3,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',9999.99,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3396,7928,40903,19634,3,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',10000.13,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3397,7928,40903,19634,3,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',10000.08,NULL,NULL,1,'2024-02-02 18:23:21','2024-02-02 18:23:21',NULL),(3398,7928,40903,19634,3,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',10002.64,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3399,7928,40903,19634,3,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',19801.09,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3400,7928,40903,19634,3,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',3400.00,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3401,7928,40903,19634,3,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',6677.00,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3402,7928,40903,19634,3,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',7904.61,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3403,7928,40903,19634,3,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',1302.02,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3404,7928,40903,19634,3,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',5000.01,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3405,7928,40903,19634,3,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',10000.11,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3406,7928,40903,19634,3,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',9999.99,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3407,7928,40903,19634,3,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',5001.22,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3408,7928,40903,19634,3,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',9999.99,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3409,7928,40903,19634,3,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',5017.79,NULL,NULL,1,'2024-02-02 18:23:22','2024-02-02 18:23:22',NULL),(3410,7928,40903,19634,2,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',6871590.00,NULL,NULL,1,'2024-02-02 18:23:42','2024-02-02 18:23:42',NULL),(3411,7928,40903,19634,2,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',6841340.00,NULL,NULL,1,'2024-02-02 18:23:42','2024-02-02 18:23:42',NULL),(3412,7928,40903,19634,2,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',21867120.00,NULL,NULL,1,'2024-02-02 18:23:42','2024-02-02 18:23:42',NULL),(3413,7928,40903,19634,2,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',21867120.00,NULL,NULL,1,'2024-02-02 18:23:42','2024-02-02 18:23:42',NULL),(3414,7928,40903,19635,2,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',1800480.00,NULL,NULL,1,'2024-02-02 18:26:06','2024-02-02 18:26:06',NULL);
INSERT INTO `balance_libro` VALUES (3415,7928,40903,19635,2,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',8857200.00,NULL,NULL,1,'2024-02-02 18:26:06','2024-02-02 18:26:06',NULL),(3416,7928,40903,19635,3,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',5232.50,NULL,NULL,1,'2024-02-02 18:26:45','2024-02-02 18:26:45',NULL),(3417,7928,40903,19635,3,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',21546.20,NULL,NULL,1,'2024-02-02 18:26:45','2024-02-02 18:26:45',NULL),(3418,7928,40903,19635,3,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',6371.42,NULL,NULL,1,'2024-02-02 18:26:45','2024-02-02 18:26:45',NULL),(3419,7928,40903,19635,3,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',10492.08,NULL,NULL,1,'2024-02-02 18:26:45','2024-02-02 18:26:45',NULL),(3420,7928,40903,19635,3,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',20168.04,NULL,NULL,1,'2024-02-02 18:26:45','2024-02-02 18:26:45',NULL),(3421,7928,40903,19635,3,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',10492.08,NULL,NULL,1,'2024-02-02 18:26:45','2024-02-02 18:26:45',NULL),(3422,7928,40903,19635,3,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',129141.29,NULL,NULL,1,'2024-02-02 18:26:45','2024-02-02 18:26:45',NULL),(3423,7928,40903,19635,3,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',22874.44,NULL,NULL,1,'2024-02-02 18:26:45','2024-02-02 18:26:45',NULL),(3424,7928,40903,19635,3,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',8068.69,NULL,NULL,1,'2024-02-02 18:26:45','2024-02-02 18:26:45',NULL),(3425,7928,40903,19635,3,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',12231.67,NULL,NULL,1,'2024-02-02 18:26:46','2024-02-02 18:26:46',NULL),(3426,7928,40903,19635,3,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',10000.02,NULL,NULL,1,'2024-02-02 18:26:46','2024-02-02 18:26:46',NULL),(3427,7928,40903,19635,3,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',10492.08,NULL,NULL,1,'2024-02-02 18:26:46','2024-02-02 18:26:46',NULL),(3428,7928,40903,19635,3,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1199999.95,NULL,NULL,1,'2024-02-02 18:26:46','2024-02-02 18:26:46',NULL),(3429,7928,40903,19635,3,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',34801.39,NULL,NULL,1,'2024-02-02 18:26:46','2024-02-02 18:26:46',NULL),(3430,7928,40903,19635,3,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2399999.91,NULL,NULL,1,'2024-02-02 18:26:46','2024-02-02 18:26:46',NULL),(3431,7928,40903,19635,3,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1199999.95,NULL,NULL,1,'2024-02-02 18:26:46','2024-02-02 18:26:46',NULL),(3432,7928,40903,19636,3,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',9600.00,NULL,NULL,1,'2024-02-02 18:28:10','2024-02-02 18:28:10',NULL),(3433,7928,40903,19636,3,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',17850.73,NULL,NULL,1,'2024-02-02 18:28:10','2024-02-02 18:28:10',NULL),(3434,7928,40903,19636,3,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',2000.02,NULL,NULL,1,'2024-02-02 18:28:10','2024-02-02 18:28:10',NULL);
INSERT INTO `balance_libro` VALUES (3435,7928,40903,19636,3,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',18646.32,NULL,NULL,1,'2024-02-02 18:28:11','2024-02-02 18:28:11',NULL),(3436,7928,40903,19636,3,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',525170.42,NULL,NULL,1,'2024-02-02 18:28:11','2024-02-02 18:28:11',NULL),(3437,7928,40903,19636,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',48400.00,NULL,NULL,1,'2024-02-02 18:28:11','2024-02-02 18:28:11',NULL),(3438,7928,40903,19636,3,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',10600.42,NULL,NULL,1,'2024-02-02 18:28:11','2024-02-02 18:28:11',NULL),(3439,7928,40903,19636,3,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',43595.23,NULL,NULL,1,'2024-02-02 18:28:11','2024-02-02 18:28:11',NULL),(3440,7928,40903,19636,2,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',6484995.00,NULL,NULL,1,'2024-02-02 18:28:32','2024-02-02 18:28:32',NULL),(3441,7928,40844,13035,3,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',8307.27,NULL,NULL,1,'2024-02-06 18:02:16','2024-02-06 18:02:16',NULL),(3442,7928,40844,13035,3,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4624.39,NULL,NULL,1,'2024-02-06 18:02:16','2024-02-06 18:02:16',NULL),(3443,7928,40844,13035,3,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',16701.34,NULL,NULL,1,'2024-02-06 18:02:16','2024-02-06 18:02:16',NULL),(3444,7928,40844,13035,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',52281.52,NULL,NULL,1,'2024-02-06 18:02:16','2024-02-06 18:02:16',NULL),(3445,7928,40844,13035,3,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4252.29,NULL,NULL,1,'2024-02-06 18:02:16','2024-02-06 18:02:16',NULL),(3446,7928,40844,13035,3,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3232.18,NULL,NULL,1,'2024-02-06 18:02:16','2024-02-06 18:02:16',NULL),(3447,7928,40844,13035,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1531.82,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3448,7928,40844,13035,3,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',22031.66,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3449,7928,40844,13035,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',5394.06,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3450,7928,40844,13035,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',7128.00,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3451,7928,40844,13035,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',16171.66,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3452,7928,40844,13035,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',5374.95,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3453,7928,40844,13035,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',21895.95,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3454,7928,40844,13035,3,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',3059.20,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3455,7928,40844,13035,3,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',5368.48,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL);
INSERT INTO `balance_libro` VALUES (3456,7928,40844,13035,3,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10768.29,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3457,7928,40844,13035,3,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',17613.00,NULL,NULL,1,'2024-02-06 18:02:17','2024-02-06 18:02:17',NULL),(3458,NULL,40844,13036,3,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',10716.14,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3459,NULL,40844,13036,3,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',11089.42,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3460,NULL,40844,13036,3,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5357.35,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3461,NULL,40844,13036,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',8570.96,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3462,NULL,40844,13036,3,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',33265.85,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3463,NULL,40844,13036,3,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',10714.05,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3464,NULL,40844,13036,3,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',20000.00,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3465,NULL,40844,13036,3,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5356.56,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3466,NULL,40844,13036,3,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',4821.80,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3467,NULL,40844,13036,3,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',9979.53,NULL,NULL,1,'2024-02-06 18:03:49','2024-02-06 18:03:49',NULL),(3468,NULL,40844,13036,3,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',7679.74,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3469,NULL,40844,13036,3,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',7450.13,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3470,NULL,40844,13036,3,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',21427.47,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3471,NULL,40844,13036,3,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4159.99,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3472,NULL,40844,13036,3,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4435.81,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3473,NULL,40844,13036,3,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',14540.07,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3474,NULL,40844,13036,3,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',16070.61,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3475,NULL,40844,13036,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',12027.18,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3476,NULL,40844,13036,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',8987.82,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL);
INSERT INTO `balance_libro` VALUES (3477,NULL,40844,13036,3,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',107089.65,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3478,NULL,40844,13036,3,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',9668.25,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3479,NULL,40844,13036,3,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',5544.34,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3480,NULL,40844,13036,3,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',13682.10,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3481,NULL,40844,13036,3,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',38381.90,NULL,NULL,1,'2024-02-06 18:03:50','2024-02-06 18:03:50',NULL),(3482,NULL,40844,13036,3,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',9584.75,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3483,NULL,40844,13036,3,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6999.89,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3484,NULL,40844,13036,3,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',21099.32,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3485,NULL,40844,13036,3,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15000.18,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3486,NULL,40844,13036,3,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',43729.72,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3487,NULL,40844,13036,3,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',12859.31,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3488,NULL,40844,13036,3,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',2100.00,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3489,NULL,40844,13036,3,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',140908.53,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3490,NULL,40844,13036,3,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',10897.44,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3491,NULL,40844,13036,3,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5344.20,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3492,NULL,40844,13036,3,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',7482.79,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3493,NULL,40844,13036,3,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5342.87,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3494,NULL,40844,13036,3,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',52299.46,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3495,NULL,40844,13036,3,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10318.40,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3496,NULL,40844,13036,3,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',6747.87,NULL,NULL,1,'2024-02-06 18:03:51','2024-02-06 18:03:51',NULL),(3497,NULL,40844,13036,3,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',5343.55,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL);
INSERT INTO `balance_libro` VALUES (3498,NULL,40844,13036,3,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',50766.15,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3499,NULL,40844,13036,3,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',21782.54,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3500,NULL,40844,13036,3,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',10687.01,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3501,NULL,40844,13036,3,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',16030.53,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3502,NULL,40844,13036,3,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',18418.85,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3503,NULL,40844,13036,3,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',32679.83,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3504,NULL,40844,13036,3,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',5954.26,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3505,NULL,40844,13036,3,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',48000.00,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3506,NULL,40844,13036,3,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',21782.54,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3507,NULL,40844,13036,3,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',3000.00,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3508,NULL,40844,13036,3,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',20000.00,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3509,NULL,40844,13036,3,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',254000.00,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3510,NULL,40844,13036,3,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',348000.00,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3511,NULL,40844,13036,3,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',112000.00,NULL,NULL,1,'2024-02-06 18:03:52','2024-02-06 18:03:52',NULL),(3512,NULL,40844,13036,3,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',256000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3513,NULL,40844,13036,3,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1860000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3514,NULL,40844,13036,3,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',116000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3515,NULL,40844,13036,3,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',378000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3516,NULL,40844,13036,3,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',78000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3517,NULL,40844,13036,3,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',356000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL);
INSERT INTO `balance_libro` VALUES (3518,NULL,40844,13036,3,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',516000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3519,NULL,40844,13036,3,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1860000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3520,NULL,40844,13036,3,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',844000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3521,NULL,40844,13036,3,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',858000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3522,NULL,40844,13036,3,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',318000.00,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3523,NULL,40844,13036,3,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1528.69,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3524,NULL,40844,13036,3,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',9798.45,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3525,NULL,40844,13036,3,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',54388.70,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3526,NULL,40844,13036,3,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',63917.22,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3527,NULL,40844,13036,3,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',16030.53,NULL,NULL,1,'2024-02-06 18:03:53','2024-02-06 18:03:53',NULL),(3528,NULL,40844,13036,3,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',63804.48,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3529,NULL,40844,13036,3,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',8514.86,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3530,NULL,40844,13036,3,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',54456.64,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3531,NULL,40844,13036,3,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',100000.00,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3532,NULL,40844,13036,3,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',120000.00,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3533,NULL,40844,13036,3,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',318000.00,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3534,NULL,40844,13036,3,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1736000.00,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3535,NULL,40844,13036,3,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',38000.00,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3536,NULL,40844,13036,3,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',80000.00,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3537,NULL,40844,13036,3,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',78000.00,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL);
INSERT INTO `balance_libro` VALUES (3538,NULL,40844,13036,3,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',9891.45,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3539,NULL,40844,13036,3,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',10390.02,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3540,NULL,40844,13036,3,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',25802.91,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3541,NULL,40844,13036,3,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',97672.33,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3542,NULL,40844,13036,3,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3212.09,NULL,NULL,1,'2024-02-06 18:03:54','2024-02-06 18:03:54',NULL),(3543,NULL,40844,13036,3,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',15000.01,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3544,NULL,40844,13036,3,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',13300.13,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3545,NULL,40844,13036,3,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4000.31,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3546,NULL,40844,13036,3,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',11001.40,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3547,NULL,40844,13036,3,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',8221.42,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3548,NULL,40844,13036,3,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',12140.68,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3549,NULL,40844,13036,3,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',30017.90,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3550,NULL,40844,13036,3,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6600.12,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3551,NULL,40844,13036,3,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',40000.30,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3552,NULL,40844,13036,3,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',19300.02,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3553,NULL,40844,13036,3,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',12002.61,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3554,NULL,40844,13036,3,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5000.68,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3555,NULL,40844,13036,3,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',4500.60,NULL,NULL,1,'2024-02-06 18:03:55','2024-02-06 18:03:55',NULL),(3556,NULL,40844,13036,3,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',10000.29,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3557,NULL,40844,13036,3,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',10002.28,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3558,NULL,40844,13036,3,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',8000.00,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL);
INSERT INTO `balance_libro` VALUES (3559,NULL,40844,13036,3,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5000.01,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3560,NULL,40844,13036,3,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',19999.99,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3561,NULL,40844,13036,3,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',23300.00,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3562,NULL,40844,13036,3,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',6307.71,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3563,NULL,40844,13036,3,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',55892.69,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3564,NULL,40844,13036,3,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',18370.03,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3565,NULL,40844,13036,3,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',61161.77,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3566,NULL,40844,13036,3,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',73391.05,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3567,NULL,40844,13036,3,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',43317.25,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3568,NULL,40844,13036,3,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',57970.99,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3569,NULL,40844,13036,3,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',112175.55,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3570,NULL,40844,13036,3,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',440440.00,NULL,NULL,1,'2024-02-06 18:03:56','2024-02-06 18:03:56',NULL),(3571,NULL,40844,13037,3,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',83739.21,NULL,NULL,1,'2024-02-06 18:20:47','2024-02-06 18:20:47',NULL),(3572,NULL,40844,13037,3,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',27601.84,NULL,NULL,1,'2024-02-06 18:20:47','2024-02-06 18:20:47',NULL),(3573,NULL,40844,13037,3,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',21784.26,NULL,NULL,1,'2024-02-06 18:20:47','2024-02-06 18:20:47',NULL),(3574,NULL,40844,13037,3,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',32673.88,NULL,NULL,1,'2024-02-06 18:20:47','2024-02-06 18:20:47',NULL),(3575,NULL,40844,13037,3,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',27228.39,NULL,NULL,1,'2024-02-06 18:20:47','2024-02-06 18:20:47',NULL),(3576,NULL,40844,13037,3,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',120000.00,NULL,NULL,1,'2024-02-06 18:20:47','2024-02-06 18:20:47',NULL),(3577,NULL,40844,13037,3,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',360000.00,NULL,NULL,1,'2024-02-06 18:20:47','2024-02-06 18:20:47',NULL),(3578,NULL,40844,13037,3,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',10687.01,NULL,NULL,1,'2024-02-06 18:20:47','2024-02-06 18:20:47',NULL),(3579,NULL,40844,13037,3,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2038.86,NULL,NULL,1,'2024-02-06 18:20:47','2024-02-06 18:20:47',NULL);
INSERT INTO `balance_libro` VALUES (3580,NULL,40844,13037,3,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',191210.91,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3581,NULL,40844,13037,3,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',5520.32,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3582,NULL,40844,13037,3,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',21822.29,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3583,NULL,40844,13037,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10707.06,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3584,NULL,40844,13037,3,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',12316.78,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3585,NULL,40844,13037,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',16604.48,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3586,NULL,40844,13037,3,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',17084.47,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3587,NULL,40844,13037,3,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',11604.47,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3588,NULL,40844,13037,3,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5354.41,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3589,NULL,40844,13037,3,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',57223.12,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3590,NULL,40844,13037,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',8704.57,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3591,NULL,40844,13037,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',21782.54,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3592,NULL,40844,13037,3,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',16030.53,NULL,NULL,1,'2024-02-06 18:20:48','2024-02-06 18:20:48',NULL),(3593,NULL,40844,13037,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13605.13,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3594,NULL,40844,13037,3,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3049.94,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3595,NULL,40844,13037,3,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',43594.59,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3596,NULL,40844,13037,3,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',44262.24,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3597,NULL,40844,13037,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',14283.22,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3598,NULL,40844,13037,3,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',12879.19,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3599,NULL,40844,13037,3,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',170424.00,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3600,NULL,40844,13037,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',13870.02,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL);
INSERT INTO `balance_libro` VALUES (3601,NULL,40844,13037,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',32972.04,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3602,NULL,40844,13037,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',21039.51,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3603,NULL,40844,13037,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',32548.68,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3604,NULL,40844,13037,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',53057.36,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3605,NULL,40844,13037,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3145.13,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3606,NULL,40844,13037,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1369.24,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3607,NULL,40844,13037,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',6487.64,NULL,NULL,1,'2024-02-06 18:20:49','2024-02-06 18:20:49',NULL),(3608,NULL,40844,13037,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',43756.13,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3609,NULL,40844,13037,3,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',7485.80,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3610,NULL,40844,13037,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4894.00,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3611,NULL,40844,13037,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',15007.15,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3612,NULL,40844,13037,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',27347.59,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3613,NULL,40844,13037,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',7485.03,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3614,NULL,40844,13037,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5469.57,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3615,NULL,40844,13037,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',39801.55,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3616,NULL,40844,13037,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',9378.92,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3617,NULL,40844,13037,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',135000.00,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3618,NULL,40844,13037,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',75000.00,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3619,NULL,40844,13037,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',225000.00,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3620,NULL,40844,13037,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',90000.00,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL),(3621,NULL,40844,13037,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',10714.33,NULL,NULL,1,'2024-02-06 18:20:50','2024-02-06 18:20:50',NULL);
INSERT INTO `balance_libro` VALUES (3622,NULL,40844,13037,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',360000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3623,NULL,40844,13037,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',45000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3624,NULL,40844,13037,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',60000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3625,NULL,40844,13037,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',300000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3626,NULL,40844,13037,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',180000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3627,NULL,40844,13037,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',180000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3628,NULL,40844,13037,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',630000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3629,NULL,40844,13037,3,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',90000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3630,NULL,40844,13037,3,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',6452.59,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3631,NULL,40844,13037,3,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',45000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3632,NULL,40844,13037,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',135000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3633,NULL,40844,13037,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',90000.00,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3634,NULL,40844,13037,3,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',9299.48,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3635,NULL,40844,13037,3,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',15704.27,NULL,NULL,1,'2024-02-06 18:20:51','2024-02-06 18:20:51',NULL),(3636,NULL,40844,13037,3,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',15314.95,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3637,NULL,40844,13037,3,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',17698.76,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3638,NULL,40844,13037,3,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',210000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3639,NULL,40844,13037,3,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',270000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3640,NULL,40844,13037,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',30000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3641,NULL,40844,13037,3,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',60000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL);
INSERT INTO `balance_libro` VALUES (3642,NULL,40844,13037,3,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',120000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3643,NULL,40844,13037,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',180000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3644,NULL,40844,13037,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',285000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3645,NULL,40844,13037,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',180000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3646,NULL,40844,13037,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',315000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3647,NULL,40844,13037,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',375000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3648,NULL,40844,13037,3,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',660000.00,NULL,NULL,1,'2024-02-06 18:20:52','2024-02-06 18:20:52',NULL),(3649,NULL,40844,13037,3,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',30000.00,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3650,NULL,40844,13037,3,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',135000.00,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3651,NULL,40844,13037,3,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',165000.00,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3652,NULL,40844,13037,3,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',105000.00,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3653,NULL,40844,13037,3,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',10050.16,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3654,NULL,40844,13037,3,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',11400.00,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3655,NULL,40844,13037,3,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',148431.32,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3656,NULL,40844,13037,3,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',75000.00,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3657,NULL,40844,13037,3,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',45000.00,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3658,NULL,40844,13037,3,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',435000.00,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3659,NULL,40844,13037,3,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',105000.00,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3660,NULL,40844,13037,3,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',60937.90,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3661,NULL,40844,13037,3,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',111574.16,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL);
INSERT INTO `balance_libro` VALUES (3662,NULL,40844,13037,3,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',58051.70,NULL,NULL,1,'2024-02-06 18:20:53','2024-02-06 18:20:53',NULL),(3663,NULL,40844,13037,3,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',100304.11,NULL,NULL,1,'2024-02-06 18:20:54','2024-02-06 18:20:54',NULL),(3664,NULL,40844,13037,3,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',97120.00,NULL,NULL,1,'2024-02-06 18:20:54','2024-02-06 18:20:54',NULL),(3665,NULL,40844,13037,3,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',184804.59,NULL,NULL,1,'2024-02-06 18:20:54','2024-02-06 18:20:54',NULL),(3666,NULL,40844,13037,3,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',171766.11,NULL,NULL,1,'2024-02-06 18:20:54','2024-02-06 18:20:54',NULL),(3667,NULL,40844,13037,3,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',52299.46,NULL,NULL,1,'2024-02-06 18:20:54','2024-02-06 18:20:54',NULL),(3668,NULL,40844,13037,3,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',64401.53,NULL,NULL,1,'2024-02-06 18:20:54','2024-02-06 18:20:54',NULL),(3669,NULL,40844,13037,3,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',107089.65,NULL,NULL,1,'2024-02-06 18:20:54','2024-02-06 18:20:54',NULL),(3670,NULL,40844,13037,3,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',82209.12,NULL,NULL,1,'2024-02-06 18:20:54','2024-02-06 18:20:54',NULL),(3671,NULL,40844,13037,3,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',84088.33,NULL,NULL,1,'2024-02-06 18:20:54','2024-02-06 18:20:54',NULL),(3672,7928,40844,13037,2,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2541500.00,NULL,NULL,1,'2024-02-06 18:21:10','2024-02-06 18:21:10',NULL),(3673,7928,40844,13037,2,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2541500.00,NULL,NULL,1,'2024-02-06 18:21:10','2024-02-06 18:21:10',NULL),(3674,7928,40844,13037,2,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2160275.00,NULL,NULL,1,'2024-02-06 18:21:10','2024-02-06 18:21:10',NULL),(3675,7928,40844,13037,2,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1423240.00,NULL,NULL,1,'2024-02-06 18:21:10','2024-02-06 18:21:10',NULL),(3676,7928,40844,13037,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1906125.00,NULL,NULL,1,'2024-02-06 18:21:10','2024-02-06 18:21:10',NULL),(3677,7928,40844,13037,2,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1753635.00,NULL,NULL,1,'2024-02-06 18:21:10','2024-02-06 18:21:10',NULL),(3678,NULL,40844,13038,3,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',100304.13,NULL,NULL,1,'2024-02-06 18:22:21','2024-02-06 18:22:21',NULL),(3679,NULL,40844,13038,3,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',5599.99,NULL,NULL,1,'2024-02-06 18:22:21','2024-02-06 18:22:21',NULL),(3680,NULL,40844,13038,3,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',220000.00,NULL,NULL,1,'2024-02-06 18:22:21','2024-02-06 18:22:21',NULL),(3681,NULL,40844,13038,3,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',17637.73,NULL,NULL,1,'2024-02-06 18:22:21','2024-02-06 18:22:21',NULL);
INSERT INTO `balance_libro` VALUES (3682,NULL,40844,13038,3,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',12626.18,NULL,NULL,1,'2024-02-06 18:22:21','2024-02-06 18:22:21',NULL),(3683,NULL,40844,13038,3,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',51062.11,NULL,NULL,1,'2024-02-06 18:22:21','2024-02-06 18:22:21',NULL),(3684,NULL,40844,13038,3,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',77658.89,NULL,NULL,1,'2024-02-06 18:22:21','2024-02-06 18:22:21',NULL),(3685,NULL,40844,13038,3,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',16688.27,NULL,NULL,1,'2024-02-06 18:22:21','2024-02-06 18:22:21',NULL),(3686,NULL,40844,13038,3,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',8749.99,NULL,NULL,1,'2024-02-06 18:22:21','2024-02-06 18:22:21',NULL),(3687,NULL,40844,13038,3,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',7413.03,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3688,NULL,40844,13038,3,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',38723.80,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3689,NULL,40844,13038,3,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',71259.89,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3690,NULL,40844,13038,3,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',49205.51,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3691,NULL,40844,13038,3,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',5160.21,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3692,NULL,40844,13038,3,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',7413.25,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3693,NULL,40844,13038,3,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',17107.39,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3694,NULL,40844,13038,3,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',47960.30,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3695,NULL,40844,13038,3,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',44631.95,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3696,NULL,40844,13038,3,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',7529.89,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3697,NULL,40844,13038,3,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',11895.00,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3698,NULL,40844,13038,3,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',11447.79,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3699,NULL,40844,13038,3,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',5400.00,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3700,NULL,40844,13038,3,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',12174.60,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3701,NULL,40844,13038,3,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',21227.48,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL),(3702,NULL,40844,13038,3,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',20000.00,NULL,NULL,1,'2024-02-06 18:22:22','2024-02-06 18:22:22',NULL);
INSERT INTO `balance_libro` VALUES (3703,NULL,40844,13038,3,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1060800.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3704,NULL,40844,13038,3,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1617720.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3705,NULL,40844,13038,3,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',490620.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3706,NULL,40844,13038,3,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',108290.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3707,NULL,40844,13038,3,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',300090.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3708,NULL,40844,13038,3,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',416000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3709,NULL,40844,13038,3,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',180000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3710,NULL,40844,13038,3,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',176000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3711,NULL,40844,13038,3,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',194000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3712,NULL,40844,13038,3,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',200000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3713,NULL,40844,13038,3,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',116000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3714,NULL,40844,13038,3,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',200000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3715,NULL,40844,13038,3,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',76000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3716,NULL,40844,13038,3,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',156000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3717,NULL,40844,13038,3,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',176000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3718,NULL,40844,13038,3,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',152000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3719,NULL,40844,13038,3,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',136000.00,NULL,NULL,1,'2024-02-06 18:22:23','2024-02-06 18:22:23',NULL),(3720,NULL,40844,13038,3,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',120000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3721,NULL,40844,13038,3,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',96000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3722,NULL,40844,13038,3,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',100000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL);
INSERT INTO `balance_libro` VALUES (3723,NULL,40844,13038,3,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',60000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3724,NULL,40844,13038,3,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10000.02,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3725,NULL,40844,13038,3,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',5430.38,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3726,NULL,40844,13038,3,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',138000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3727,NULL,40844,13038,3,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',176000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3728,NULL,40844,13038,3,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',140000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3729,NULL,40844,13038,3,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',200000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3730,NULL,40844,13038,3,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',94000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3731,NULL,40844,13038,3,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',60000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3732,NULL,40844,13038,3,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',40000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3733,NULL,40844,13038,3,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',78000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3734,NULL,40844,13038,3,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',414000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3735,NULL,40844,13038,3,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1103544.20,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3736,NULL,40844,13038,3,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',60000.00,NULL,NULL,1,'2024-02-06 18:22:24','2024-02-06 18:22:24',NULL),(3737,NULL,40844,13038,3,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',140000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3738,NULL,40844,13038,3,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',154000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3739,NULL,40844,13038,3,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',4999.99,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3740,NULL,40844,13038,3,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',25241.91,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3741,NULL,40844,13038,3,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',3841.64,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3742,NULL,40844,13038,3,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',648000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL);
INSERT INTO `balance_libro` VALUES (3743,NULL,40844,13038,3,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',93600.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3744,NULL,40844,13038,3,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',180000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3745,NULL,40844,13038,3,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',141600.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3746,NULL,40844,13038,3,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',120000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3747,NULL,40844,13038,3,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',48000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3748,NULL,40844,13038,3,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',379200.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3749,NULL,40844,13038,3,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',312000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3750,NULL,40844,13038,3,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',144000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3751,NULL,40844,13038,3,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',120000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3752,NULL,40844,13038,3,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',264000.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3753,NULL,40844,13038,3,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',405600.00,NULL,NULL,1,'2024-02-06 18:22:25','2024-02-06 18:22:25',NULL),(3754,NULL,40844,13038,3,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',77000.04,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3755,NULL,40844,13038,3,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',423500.00,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3756,NULL,40844,13038,3,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',8000.01,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3757,NULL,40844,13038,3,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',40200.81,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3758,NULL,40844,13038,3,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',5000.01,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3759,NULL,40844,13038,3,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',2775.00,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3760,NULL,40844,13038,3,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',5002.32,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3761,NULL,40844,13038,3,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',288095.24,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3762,NULL,40844,13038,3,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',5000.01,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL);
INSERT INTO `balance_libro` VALUES (3763,NULL,40844,13038,3,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',210309.58,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3764,NULL,40844,13038,3,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',30000.00,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3765,NULL,40844,13038,3,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',47901.91,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3766,NULL,40844,13038,3,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',30000.00,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3767,NULL,40844,13038,3,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',19999.99,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3768,NULL,40844,13038,3,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',40000.01,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3769,NULL,40844,13038,3,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',30001.90,NULL,NULL,1,'2024-02-06 18:22:26','2024-02-06 18:22:26',NULL),(3770,NULL,40844,13038,3,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',200001.80,NULL,NULL,1,'2024-02-06 18:22:27','2024-02-06 18:22:27',NULL),(3771,NULL,40844,13038,3,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',71616.58,NULL,NULL,1,'2024-02-06 18:22:27','2024-02-06 18:22:27',NULL),(3772,NULL,40844,13038,3,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',117409.05,NULL,NULL,1,'2024-02-06 18:22:27','2024-02-06 18:22:27',NULL),(3773,7928,40844,13038,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1060800.00,NULL,NULL,1,'2024-02-06 18:23:02','2024-02-06 18:23:02',NULL),(3774,7928,40844,13038,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3315000.00,NULL,NULL,1,'2024-02-06 18:23:02','2024-02-06 18:23:02',NULL),(3775,7928,40844,13038,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1617720.00,NULL,NULL,1,'2024-02-06 18:23:02','2024-02-06 18:23:02',NULL),(3776,7928,40844,13038,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',2771340.00,NULL,NULL,1,'2024-02-06 18:23:02','2024-02-06 18:23:02',NULL),(3777,7928,40844,13038,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',2681172.00,NULL,NULL,1,'2024-02-06 18:23:02','2024-02-06 18:23:02',NULL),(3778,7928,40844,13038,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',2929134.00,NULL,NULL,1,'2024-02-06 18:23:02','2024-02-06 18:23:02',NULL),(3779,7928,40844,13039,3,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',1103544.20,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3780,7928,40844,13039,3,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',11699.97,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3781,7928,40844,13039,3,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',21916.28,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3782,7928,40844,13039,3,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',17660.33,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL);
INSERT INTO `balance_libro` VALUES (3783,7928,40844,13039,3,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',108900.00,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3784,7928,40844,13039,3,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',46347.27,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3785,7928,40844,13039,3,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',27556.49,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3786,7928,40844,13039,3,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',8760.01,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3787,7928,40844,13039,3,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',12007.05,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3788,7928,40844,13039,3,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',31840.92,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3789,7928,40844,13039,3,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',499.95,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3790,7928,40844,13039,3,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',17355.71,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3791,7928,40844,13039,3,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',120146.26,NULL,NULL,1,'2024-02-06 18:32:37','2024-02-06 18:32:37',NULL),(3792,7928,40844,13039,3,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',18094.50,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3793,7928,40844,13039,3,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',89536.74,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3794,7928,40844,13039,3,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',8232.22,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3795,7928,40844,13039,3,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',8679.97,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3796,7928,40844,13039,3,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',8134.70,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3797,7928,40844,13039,3,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',7430.46,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3798,7928,40844,13039,3,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',3077.39,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3799,7928,40844,13039,3,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',192000.00,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3800,7928,40844,13039,3,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',120000.00,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3801,7928,40844,13039,3,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',96000.00,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3802,7928,40844,13039,3,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',360000.00,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3803,7928,40844,13039,3,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',328800.00,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL);
INSERT INTO `balance_libro` VALUES (3804,7928,40844,13039,3,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',93600.00,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3805,7928,40844,13039,3,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',96000.00,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3806,7928,40844,13039,3,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',265200.00,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3807,7928,40844,13039,3,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',168000.00,NULL,NULL,1,'2024-02-06 18:32:38','2024-02-06 18:32:38',NULL),(3808,7928,40844,13039,3,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',144000.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3809,7928,40844,13039,3,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',168000.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3810,7928,40844,13039,3,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',93600.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3811,7928,40844,13039,3,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',144000.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3812,7928,40844,13039,3,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',163200.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3813,7928,40844,13039,3,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',115200.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3814,7928,40844,13039,3,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',235200.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3815,7928,40844,13039,3,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',141600.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3816,7928,40844,13039,3,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',237600.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3817,7928,40844,13039,3,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',45600.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3818,7928,40844,13039,3,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',48000.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3819,7928,40844,13039,3,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',165600.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3820,7928,40844,13039,3,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',69600.00,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3821,7928,40844,13039,3,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',9799.96,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3822,7928,40844,13039,3,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',15504.90,NULL,NULL,1,'2024-02-06 18:32:39','2024-02-06 18:32:39',NULL),(3823,7928,40844,13039,3,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',171850.03,NULL,NULL,1,'2024-02-06 18:32:40','2024-02-06 18:32:40',NULL);
INSERT INTO `balance_libro` VALUES (3824,7928,40844,13039,3,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',1683008.26,NULL,NULL,1,'2024-02-06 18:32:40','2024-02-06 18:32:40',NULL),(3825,7928,40844,13039,3,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',22698.00,NULL,NULL,1,'2024-02-06 18:32:40','2024-02-06 18:32:40',NULL),(3826,7928,40844,13039,3,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5305.61,NULL,NULL,1,'2024-02-06 18:32:40','2024-02-06 18:32:40',NULL),(3827,7928,40844,13039,2,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',1883857.90,NULL,NULL,1,'2024-02-06 18:34:17','2024-02-06 18:34:17',NULL),(3828,NULL,40844,13040,3,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',11000.00,NULL,NULL,1,'2024-02-06 18:43:52','2024-02-06 18:43:52',NULL),(3829,NULL,40844,13040,3,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',5190.00,NULL,NULL,1,'2024-02-06 18:43:52','2024-02-06 18:43:52',NULL),(3830,NULL,40844,13040,3,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',3600.00,NULL,NULL,1,'2024-02-06 18:43:52','2024-02-06 18:43:52',NULL),(3831,NULL,40844,13040,3,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',1200.02,NULL,NULL,1,'2024-02-06 18:43:52','2024-02-06 18:43:52',NULL),(3832,NULL,40844,13040,3,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',2900.00,NULL,NULL,1,'2024-02-06 18:43:52','2024-02-06 18:43:52',NULL),(3833,NULL,40844,13040,3,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',4400.00,NULL,NULL,1,'2024-02-06 18:43:52','2024-02-06 18:43:52',NULL),(3834,NULL,40844,13040,3,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',10000.00,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3835,NULL,40844,13040,3,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',3300.00,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3836,NULL,40844,13040,3,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',4000.02,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3837,NULL,40844,13040,3,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',24500.00,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3838,NULL,40844,13040,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',7500.00,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3839,NULL,40844,13040,3,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-02','2023-07-02',7600.00,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3840,NULL,40844,13040,3,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',2500.02,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3841,NULL,40844,13040,3,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3900.00,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3842,NULL,40844,13040,3,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',10069.59,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3843,NULL,40844,13040,3,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',30000.00,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3844,NULL,40844,13040,3,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-30','2023-07-30',10000.01,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL);
INSERT INTO `balance_libro` VALUES (3845,NULL,40844,13040,3,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',15000.81,NULL,NULL,1,'2024-02-06 18:43:53','2024-02-06 18:43:53',NULL),(3846,NULL,40844,13040,3,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',5000.02,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3847,NULL,40844,13040,3,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',5000.02,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3848,NULL,40844,13040,3,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',14800.01,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3849,NULL,40844,13040,3,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',16402.53,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3850,NULL,40844,13040,3,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',5000.00,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3851,NULL,40844,13040,3,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',5001.68,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3852,NULL,40844,13040,3,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',8800.11,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3853,NULL,40844,13040,3,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',2001.90,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3854,NULL,40844,13040,3,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',5000.00,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3855,NULL,40844,13040,3,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',4009.90,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3856,NULL,40844,13040,3,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',10000.01,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3857,NULL,40844,13040,3,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',8000.02,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3858,NULL,40844,13040,3,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',8000.02,NULL,NULL,1,'2024-02-06 18:43:54','2024-02-06 18:43:54',NULL),(3859,NULL,40844,13040,3,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',3500.60,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3860,NULL,40844,13040,3,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',66506.11,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3861,NULL,40844,13040,3,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',5000.00,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3862,NULL,40844,13040,3,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',20000.02,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3863,NULL,40844,13040,3,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',18981.12,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3864,NULL,40844,13040,3,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',20577.72,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3865,NULL,40844,13040,3,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',21966.57,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL);
INSERT INTO `balance_libro` VALUES (3866,NULL,40844,13040,3,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',128800.00,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3867,NULL,40844,13040,3,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',347600.00,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3868,NULL,40844,13040,3,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',88113.51,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3869,NULL,40844,13040,3,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',3145.97,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3870,NULL,40844,13040,3,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',8390.00,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3871,NULL,40844,13040,3,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',3553.30,NULL,NULL,1,'2024-02-06 18:43:55','2024-02-06 18:43:55',NULL),(3872,NULL,40844,13040,3,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',2909.28,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3873,NULL,40844,13040,3,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',10360.00,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3874,NULL,40844,13040,3,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',4804.70,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3875,NULL,40844,13040,3,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',12599.95,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3876,NULL,40844,13040,3,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',8208.50,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3877,NULL,40844,13040,3,3873,'App\\Models\\Receipt',3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',8323.93,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3878,NULL,40844,13040,3,3874,'App\\Models\\Receipt',3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',20957.03,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3879,NULL,40844,13040,3,3875,'App\\Models\\Receipt',3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',4067.38,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3880,NULL,40844,13040,3,3876,'App\\Models\\Receipt',3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',24718.74,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3881,NULL,40844,13040,3,3877,'App\\Models\\Receipt',3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',34075.20,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3882,NULL,40844,13040,3,3878,'App\\Models\\Receipt',3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',0.00,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3883,NULL,40844,13040,3,3879,'App\\Models\\Receipt',3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',8169.73,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3884,NULL,40844,13040,3,3880,'App\\Models\\Receipt',3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',88769.42,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3885,NULL,40844,13040,3,3881,'App\\Models\\Receipt',3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',10946.33,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL),(3886,NULL,40844,13040,3,3882,'App\\Models\\Receipt',3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',20169.35,NULL,NULL,1,'2024-02-06 18:43:56','2024-02-06 18:43:56',NULL);
INSERT INTO `balance_libro` VALUES (3887,NULL,40844,13040,3,3883,'App\\Models\\Receipt',3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',13749.99,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3888,NULL,40844,13040,3,3884,'App\\Models\\Receipt',3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',8581.64,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3889,NULL,40844,13040,3,3885,'App\\Models\\Receipt',3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',66494.02,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3890,NULL,40844,13040,3,3886,'App\\Models\\Receipt',3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',63690.61,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3891,NULL,40844,13040,3,3887,'App\\Models\\Receipt',3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',3805.72,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3892,NULL,40844,13040,3,3888,'App\\Models\\Receipt',3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',2030.68,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3893,NULL,40844,13040,3,3889,'App\\Models\\Receipt',3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',32018.42,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3894,NULL,40844,13040,3,3890,'App\\Models\\Receipt',3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',490800.00,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3895,NULL,40844,13040,3,3891,'App\\Models\\Receipt',3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',464000.00,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3896,NULL,40844,13040,3,3892,'App\\Models\\Receipt',3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',94800.00,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3897,NULL,40844,13040,3,3893,'App\\Models\\Receipt',3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',126400.00,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3898,NULL,40844,13040,3,3894,'App\\Models\\Receipt',3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',63200.00,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3899,NULL,40844,13040,3,3895,'App\\Models\\Receipt',3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',31000.00,NULL,NULL,1,'2024-02-06 18:43:57','2024-02-06 18:43:57',NULL),(3900,7928,40844,13041,3,3896,'App\\Models\\Receipt',3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',20253.80,NULL,NULL,1,'2024-02-06 19:55:12','2024-02-06 19:55:12',NULL),(3901,7928,40844,13041,3,3897,'App\\Models\\Receipt',3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',58828.51,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3902,7928,40844,13041,3,3898,'App\\Models\\Receipt',3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',22804.88,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3903,7928,40844,13041,3,3899,'App\\Models\\Receipt',3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',129189.89,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3904,7928,40844,13041,3,3900,'App\\Models\\Receipt',3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',4275.97,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3905,7928,40844,13041,3,3901,'App\\Models\\Receipt',3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',14799.99,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3906,7928,40844,13041,3,3902,'App\\Models\\Receipt',3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',12709.46,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3907,7928,40844,13041,3,3903,'App\\Models\\Receipt',3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',76064.07,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL);
INSERT INTO `balance_libro` VALUES (3908,7928,40844,13041,3,3904,'App\\Models\\Receipt',3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',12883.85,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3909,7928,40844,13041,3,3905,'App\\Models\\Receipt',3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',29717.38,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3910,7928,40844,13041,3,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1502800.00,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3911,7928,40844,13041,3,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',113827.66,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3912,7928,40844,13041,3,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',5917.57,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3913,7928,40844,13041,3,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',210040.59,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3914,7928,40844,13041,3,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',14241.22,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3915,7928,40844,13041,3,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',29895.37,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3916,7928,40844,13041,3,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',8882.90,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3917,7928,40844,13041,3,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',1479.71,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3918,7928,40844,13041,3,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',183255.54,NULL,NULL,1,'2024-02-06 19:55:13','2024-02-06 19:55:13',NULL),(3919,7928,40844,13041,3,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',280786.45,NULL,NULL,1,'2024-02-06 19:55:14','2024-02-06 19:55:14',NULL),(3920,7928,40844,13041,3,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',290961.14,NULL,NULL,1,'2024-02-06 19:55:14','2024-02-06 19:55:14',NULL),(3921,7928,40844,13041,3,3917,'App\\Models\\Receipt',3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',16442.97,NULL,NULL,1,'2024-02-06 19:55:14','2024-02-06 19:55:14',NULL),(3922,7928,40844,13041,3,3918,'App\\Models\\Receipt',3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',26752.27,NULL,NULL,1,'2024-02-06 19:55:14','2024-02-06 19:55:14',NULL),(3923,7928,40844,13041,3,3919,'App\\Models\\Receipt',3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',11556.99,NULL,NULL,1,'2024-02-06 19:55:14','2024-02-06 19:55:14',NULL),(3924,7928,40844,13041,3,3920,'App\\Models\\Receipt',3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',11741.57,NULL,NULL,1,'2024-02-06 19:55:14','2024-02-06 19:55:14',NULL),(3925,7928,40844,13042,3,3921,'App\\Models\\Receipt',3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',5317.97,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3926,7928,40844,13042,3,3922,'App\\Models\\Receipt',3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',10618.03,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3927,7928,40844,13042,3,3923,'App\\Models\\Receipt',3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',5700.01,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3928,7928,40844,13042,3,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',19361.63,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL);
INSERT INTO `balance_libro` VALUES (3929,7928,40844,13042,3,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',21238.28,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3930,7928,40844,13042,3,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',10603.90,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3931,7928,40844,13042,3,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',7700.00,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3932,7928,40844,13042,3,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',78729.56,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3933,7928,40844,13042,3,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',12000.10,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3934,7928,40844,13042,3,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',6376.17,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3935,7928,40844,13042,3,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',2222.85,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3936,7928,40844,13042,3,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',2287.86,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3937,7928,40844,13042,3,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',24903.01,NULL,NULL,1,'2024-02-06 19:56:26','2024-02-06 19:56:26',NULL),(3938,7928,40844,13042,3,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',7749.61,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3939,7928,40844,13042,3,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',20255.81,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3940,7928,40844,13042,3,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',91901.36,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3941,7928,40844,13042,3,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',89335.49,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3942,7928,40844,13042,3,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',4960.38,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3943,7928,40844,13042,3,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',5303.60,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3944,7928,40844,13042,3,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',10603.90,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3945,7928,40844,13042,3,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',8476.52,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3946,7928,40844,13042,3,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',5719.66,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3947,7928,40844,13042,3,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',10603.90,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3948,7928,40844,13042,3,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',7000.15,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3949,7928,40844,13042,3,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',10400.01,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL);
INSERT INTO `balance_libro` VALUES (3950,7928,40844,13042,3,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',12321.26,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3951,7928,40844,13042,3,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',20089.88,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3952,7928,40844,13042,3,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',3038.81,NULL,NULL,1,'2024-02-06 19:56:27','2024-02-06 19:56:27',NULL),(3953,7928,40844,13042,3,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',10603.90,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3954,7928,40844,13042,3,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',142887.25,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3955,7928,40844,13042,3,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',16145.87,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3956,7928,40844,13042,3,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',197222.22,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3957,7928,40844,13042,3,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',126902.29,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3958,7928,40844,13042,3,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',25269.04,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3959,7928,40844,13042,3,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',19927.62,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3960,7928,40844,13042,3,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',15720.06,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3961,7928,40844,13042,3,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',6363.06,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3962,7928,40844,13042,3,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',21207.80,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3963,7928,40844,13042,3,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',10602.81,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3964,7928,40844,13042,3,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',10602.81,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3965,7928,40844,13042,3,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',10604.02,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3966,7928,40844,13042,3,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',3100.04,NULL,NULL,1,'2024-02-06 19:56:28','2024-02-06 19:56:28',NULL),(3967,7928,40844,13042,3,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',39124.57,NULL,NULL,1,'2024-02-06 19:56:29','2024-02-06 19:56:29',NULL),(3968,7928,40844,13042,3,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',11849.02,NULL,NULL,1,'2024-02-06 19:56:29','2024-02-06 19:56:29',NULL),(3969,NULL,40844,13043,3,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',15904.60,NULL,NULL,1,'2024-02-06 19:57:28','2024-02-06 19:57:28',NULL),(3970,NULL,40844,13043,3,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',65738.77,NULL,NULL,1,'2024-02-06 19:57:28','2024-02-06 19:57:28',NULL);
INSERT INTO `balance_libro` VALUES (3971,NULL,40844,13043,3,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',26675.03,NULL,NULL,1,'2024-02-06 19:57:28','2024-02-06 19:57:28',NULL),(3972,NULL,40844,13043,3,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',32418.17,NULL,NULL,1,'2024-02-06 19:57:28','2024-02-06 19:57:28',NULL),(3973,NULL,40844,13043,3,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',45741.56,NULL,NULL,1,'2024-02-06 19:57:28','2024-02-06 19:57:28',NULL),(3974,NULL,40844,13043,3,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',100001.08,NULL,NULL,1,'2024-02-06 19:57:28','2024-02-06 19:57:28',NULL),(3975,NULL,40844,13043,3,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',10603.90,NULL,NULL,1,'2024-02-06 19:57:28','2024-02-06 19:57:28',NULL),(3976,NULL,40844,13043,3,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',20400.00,NULL,NULL,1,'2024-02-06 19:57:28','2024-02-06 19:57:28',NULL),(3977,NULL,40844,13043,3,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',130000.00,NULL,NULL,1,'2024-02-06 19:57:28','2024-02-06 19:57:28',NULL),(3978,NULL,40844,13043,3,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',31808.59,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3979,NULL,40844,13043,3,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',87147.85,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3980,NULL,40844,13043,3,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',6011.56,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3981,NULL,40844,13043,3,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',156429.89,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3982,NULL,40844,13043,3,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',90002.25,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3983,NULL,40844,13043,3,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',32580.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3984,NULL,40844,13043,3,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',81450.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3985,NULL,40844,13043,3,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',65160.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3986,NULL,40844,13043,3,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',48870.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3987,NULL,40844,13043,3,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',32580.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3988,NULL,40844,13043,3,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',81450.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3989,NULL,40844,13043,3,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',48870.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3990,NULL,40844,13043,3,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',195480.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3991,NULL,40844,13043,3,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',16290.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL);
INSERT INTO `balance_libro` VALUES (3992,NULL,40844,13043,3,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',130320.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3993,NULL,40844,13043,3,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',114030.00,NULL,NULL,1,'2024-02-06 19:57:29','2024-02-06 19:57:29',NULL),(3994,NULL,40844,13043,3,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',32580.00,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(3995,NULL,40844,13043,3,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',162900.00,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(3996,NULL,40844,13043,3,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',97740.00,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(3997,NULL,40844,13043,3,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',211770.00,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(3998,NULL,40844,13043,3,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',162900.00,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(3999,NULL,40844,13043,3,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',488700.00,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4000,NULL,40844,13043,3,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',146610.00,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4001,NULL,40844,13043,3,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',358380.00,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4002,NULL,40844,13043,3,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',15900.02,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4003,NULL,40844,13043,3,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',89508.55,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4004,NULL,40844,13043,3,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',0.00,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4005,NULL,40844,13043,3,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',5307.15,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4006,NULL,40844,13043,3,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',11984.49,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4007,NULL,40844,13043,3,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',80104.21,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4008,NULL,40844,13043,3,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',7422.07,NULL,NULL,1,'2024-02-06 19:57:30','2024-02-06 19:57:30',NULL),(4009,NULL,40844,13043,3,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',5700.01,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4010,NULL,40844,13043,3,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',4250.83,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4011,NULL,40844,13043,3,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',6164.13,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4012,NULL,40844,13043,3,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',36090.27,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL);
INSERT INTO `balance_libro` VALUES (4013,NULL,40844,13043,3,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',391410.27,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4014,NULL,40844,13043,3,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',31808.59,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4015,NULL,40844,13043,3,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',31808.59,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4016,NULL,40844,13043,3,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',23463.06,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4017,NULL,40844,13043,3,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',194150.67,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4018,NULL,40844,13043,3,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',37981.59,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4019,NULL,40844,13043,3,4015,'App\\Models\\Receipt',4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',31418.78,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4020,NULL,40844,13043,3,4016,'App\\Models\\Receipt',4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',10602.82,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4021,NULL,40844,13043,3,4017,'App\\Models\\Receipt',4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',127167.97,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4022,NULL,40844,13043,3,4018,'App\\Models\\Receipt',4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',160208.42,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4023,NULL,40844,13043,3,4019,'App\\Models\\Receipt',4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',53545.34,NULL,NULL,1,'2024-02-06 19:57:31','2024-02-06 19:57:31',NULL),(4024,NULL,40844,13043,3,4020,'App\\Models\\Receipt',4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',25119.68,NULL,NULL,1,'2024-02-06 19:57:32','2024-02-06 19:57:32',NULL),(4025,NULL,40844,13043,3,4021,'App\\Models\\Receipt',4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',100662.40,NULL,NULL,1,'2024-02-06 19:57:32','2024-02-06 19:57:32',NULL),(4026,NULL,40844,13043,3,4022,'App\\Models\\Receipt',4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',10497.07,NULL,NULL,1,'2024-02-06 19:57:32','2024-02-06 19:57:32',NULL),(4027,NULL,40844,13043,3,4023,'App\\Models\\Receipt',4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-29','2023-10-29',3986.80,NULL,NULL,1,'2024-02-06 19:57:32','2024-02-06 19:57:32',NULL),(4028,7928,40844,13043,2,4024,'App\\Models\\Receipt',4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',3591250.00,NULL,NULL,1,'2024-02-06 19:57:57','2024-02-06 19:57:57',NULL),(4029,7928,40844,13043,2,4025,'App\\Models\\Receipt',4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',3513900.00,NULL,NULL,1,'2024-02-06 19:57:57','2024-02-06 19:57:57',NULL),(4030,7928,40844,13044,3,4026,'App\\Models\\Receipt',4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',5232.50,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4031,7928,40844,13044,3,4027,'App\\Models\\Receipt',4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',14779.48,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4032,7928,40844,13044,3,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',17138.65,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL);
INSERT INTO `balance_libro` VALUES (4033,7928,40844,13044,3,4029,'App\\Models\\Receipt',4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',4060.01,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4034,7928,40844,13044,3,4030,'App\\Models\\Receipt',4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',23000.04,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4035,7928,40844,13044,3,4031,'App\\Models\\Receipt',4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',5291.21,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4036,7928,40844,13044,3,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',27909.79,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4037,7928,40844,13044,3,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',24420.37,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4038,7928,40844,13044,3,4034,'App\\Models\\Receipt',4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',35117.19,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4039,7928,40844,13044,3,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',15984.51,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4040,7928,40844,13044,3,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4640.00,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4041,7928,40844,13044,3,4037,'App\\Models\\Receipt',4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',25383.80,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4042,7928,40844,13044,3,4038,'App\\Models\\Receipt',4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',16591.82,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4043,7928,40844,13044,3,4039,'App\\Models\\Receipt',4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',0.00,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4044,7928,40844,13044,3,4040,'App\\Models\\Receipt',4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',6090.01,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4045,7928,40844,13044,3,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',35475.13,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4046,7928,40844,13044,3,4042,'App\\Models\\Receipt',4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',12204.48,NULL,NULL,1,'2024-02-06 20:01:44','2024-02-06 20:01:44',NULL),(4047,7928,40844,13044,3,4043,'App\\Models\\Receipt',4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',10113.93,NULL,NULL,1,'2024-02-06 20:01:45','2024-02-06 20:01:45',NULL),(4048,7928,40844,13044,3,4044,'App\\Models\\Receipt',4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',29424.56,NULL,NULL,1,'2024-02-06 20:01:45','2024-02-06 20:01:45',NULL),(4049,7928,40844,13044,2,4045,'App\\Models\\Receipt',4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',607750.00,NULL,NULL,1,'2024-02-06 20:02:22','2024-02-06 20:02:22',NULL),(4050,7928,40844,13045,3,4046,'App\\Models\\Receipt',4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',46217.09,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4051,7928,40844,13045,3,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',45601.84,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4052,7928,40844,13045,3,4048,'App\\Models\\Receipt',4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',10200.01,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4053,7928,40844,13045,3,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',38545.75,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL);
INSERT INTO `balance_libro` VALUES (4054,7928,40844,13045,3,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',40622.96,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4055,7928,40844,13045,3,4051,'App\\Models\\Receipt',4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',0.00,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4056,7928,40844,13045,3,4052,'App\\Models\\Receipt',4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',10650.04,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4057,7928,40844,13045,3,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',26201.05,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4058,7928,40844,13045,3,4054,'App\\Models\\Receipt',4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',2041.75,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4059,7928,40844,13045,3,4055,'App\\Models\\Receipt',4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',97213.89,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4060,7928,40844,13045,3,4056,'App\\Models\\Receipt',4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',123100.76,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4061,7928,40844,13045,3,4057,'App\\Models\\Receipt',4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',85827.14,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4062,7928,40844,13045,3,4058,'App\\Models\\Receipt',4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',27312.82,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4063,7928,40844,13045,3,4059,'App\\Models\\Receipt',4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',0.00,NULL,NULL,1,'2024-02-06 20:12:10','2024-02-06 20:12:10',NULL),(4064,7928,40844,13045,3,4060,'App\\Models\\Receipt',4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',22536.52,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4065,7928,40844,13045,3,4061,'App\\Models\\Receipt',4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',19150.90,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4066,7928,40844,13045,3,4062,'App\\Models\\Receipt',4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',106004.24,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4067,7928,40844,13045,3,4063,'App\\Models\\Receipt',4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',17366.65,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4068,7928,40844,13045,3,4064,'App\\Models\\Receipt',4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',9603.64,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4069,7928,40844,13045,3,4065,'App\\Models\\Receipt',4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',37827.44,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4070,7928,40844,13045,3,4066,'App\\Models\\Receipt',4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',41755.59,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4071,7928,40844,13045,3,4067,'App\\Models\\Receipt',4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',48741.82,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4072,7928,40844,13045,3,4068,'App\\Models\\Receipt',4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',19449.38,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4073,7928,40844,13045,3,4069,'App\\Models\\Receipt',4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',7962.25,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4074,7928,40844,13045,3,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',25750.01,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL);
INSERT INTO `balance_libro` VALUES (4075,7928,40844,13045,3,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',38000.00,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4076,7928,40844,13045,3,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',42687.95,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4077,7928,40844,13045,3,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',28483.99,NULL,NULL,1,'2024-02-06 20:12:11','2024-02-06 20:12:11',NULL),(4078,7928,40844,13045,2,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',1200000.02,NULL,NULL,1,'2024-02-06 20:12:33','2024-02-06 20:12:33',NULL),(4079,7928,40844,13045,2,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',975000.02,NULL,NULL,1,'2024-02-06 20:12:33','2024-02-06 20:12:33',NULL),(4080,7928,40895,35835,2,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3013747.00,NULL,NULL,1,'2024-02-27 18:53:13','2024-02-27 18:53:13',NULL),(4081,7928,40895,35835,2,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',579348.00,NULL,NULL,1,'2024-02-27 18:53:13','2024-02-27 18:53:13',NULL),(4082,7928,40895,35835,3,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3600.00,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4083,7928,40895,35835,3,4079,'App\\Models\\Receipt',4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',4390.64,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4084,7928,40895,35835,3,4080,'App\\Models\\Receipt',4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',5394.89,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4085,7928,40895,35835,3,4081,'App\\Models\\Receipt',4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4950.00,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4086,7928,40895,35835,3,4082,'App\\Models\\Receipt',4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',105000.00,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4087,7928,40895,35835,3,4083,'App\\Models\\Receipt',4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',75000.00,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4088,7928,40895,35835,3,4084,'App\\Models\\Receipt',4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3048.99,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4089,7928,40895,35835,3,4085,'App\\Models\\Receipt',4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2032.66,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4090,7928,40895,35835,3,4086,'App\\Models\\Receipt',4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2696.96,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4091,7928,40895,35835,3,4087,'App\\Models\\Receipt',4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1553.07,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4092,7928,40895,35835,3,4088,'App\\Models\\Receipt',4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',14599.57,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4093,7928,40895,35835,3,4089,'App\\Models\\Receipt',4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5377.26,NULL,NULL,1,'2024-02-27 18:53:26','2024-02-27 18:53:26',NULL),(4094,7928,40895,35835,3,4090,'App\\Models\\Receipt',4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4285.50,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4095,7928,40895,35835,3,4091,'App\\Models\\Receipt',4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',2143.02,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL);
INSERT INTO `balance_libro` VALUES (4096,7928,40895,35835,3,4092,'App\\Models\\Receipt',4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',5677.40,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4097,7928,40895,35835,3,4093,'App\\Models\\Receipt',4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',21525.37,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4098,7928,40895,35835,3,4094,'App\\Models\\Receipt',4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',66720.00,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4099,7928,40895,35835,3,4095,'App\\Models\\Receipt',4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',399.50,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4100,7928,40895,35835,3,4096,'App\\Models\\Receipt',4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1779.99,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4101,7928,40895,35835,3,4097,'App\\Models\\Receipt',4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3214.12,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4102,7928,40895,35835,3,4098,'App\\Models\\Receipt',4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',33475.07,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4103,7928,40895,35835,3,4099,'App\\Models\\Receipt',4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',38341.78,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4104,7928,40895,35835,3,4100,'App\\Models\\Receipt',4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',4286.76,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4105,7928,40895,35835,3,4101,'App\\Models\\Receipt',4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',16966.78,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4106,7928,40895,35835,3,4102,'App\\Models\\Receipt',4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',800.00,NULL,NULL,1,'2024-02-27 18:53:27','2024-02-27 18:53:27',NULL),(4107,7928,40895,35835,3,4103,'App\\Models\\Receipt',4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16000.00,NULL,NULL,1,'2024-02-27 18:53:28','2024-02-27 18:53:28',NULL),(4108,7928,40895,35836,3,4104,'App\\Models\\Receipt',4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3749.99,NULL,NULL,1,'2024-02-27 18:54:46','2024-02-27 18:54:46',NULL),(4109,7928,40895,35836,3,4105,'App\\Models\\Receipt',4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',105000.00,NULL,NULL,1,'2024-02-27 18:54:46','2024-02-27 18:54:46',NULL),(4110,7928,40895,35836,3,4106,'App\\Models\\Receipt',4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',75000.00,NULL,NULL,1,'2024-02-27 18:54:46','2024-02-27 18:54:46',NULL),(4111,7928,40895,35836,3,4107,'App\\Models\\Receipt',4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',75000.00,NULL,NULL,1,'2024-02-27 18:54:46','2024-02-27 18:54:46',NULL),(4112,7928,40895,35836,3,4108,'App\\Models\\Receipt',4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',75000.00,NULL,NULL,1,'2024-02-27 18:54:46','2024-02-27 18:54:46',NULL),(4113,7928,40895,35836,3,4109,'App\\Models\\Receipt',4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',75000.00,NULL,NULL,1,'2024-02-27 18:54:46','2024-02-27 18:54:46',NULL),(4114,7928,40895,35836,3,4110,'App\\Models\\Receipt',4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',75000.00,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4115,7928,40895,35836,3,4111,'App\\Models\\Receipt',4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',75000.00,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4116,7928,40895,35836,3,4112,'App\\Models\\Receipt',4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',75000.00,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL);
INSERT INTO `balance_libro` VALUES (4117,7928,40895,35836,3,4113,'App\\Models\\Receipt',4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5990.54,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4118,7928,40895,35836,3,4114,'App\\Models\\Receipt',4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',17155.00,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4119,7928,40895,35836,3,4115,'App\\Models\\Receipt',4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3402.00,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4120,7928,40895,35836,3,4116,'App\\Models\\Receipt',4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',15291.01,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4121,7928,40895,35836,3,4117,'App\\Models\\Receipt',4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2980.72,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4122,7928,40895,35836,3,4118,'App\\Models\\Receipt',4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',31447.34,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4123,7928,40895,35836,3,4119,'App\\Models\\Receipt',4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4400.00,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4124,7928,40895,35836,3,4120,'App\\Models\\Receipt',4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',5073.14,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4125,7928,40895,35836,3,4121,'App\\Models\\Receipt',4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',9000.00,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4126,7928,40895,35836,3,4122,'App\\Models\\Receipt',4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3578.00,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4127,7928,40895,35836,3,4123,'App\\Models\\Receipt',4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2143.84,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4128,7928,40895,35836,3,4124,'App\\Models\\Receipt',4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',10875.00,NULL,NULL,1,'2024-02-27 18:54:47','2024-02-27 18:54:47',NULL),(4129,7928,40895,35836,3,4125,'App\\Models\\Receipt',4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',9374.00,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4130,7928,40895,35836,3,4126,'App\\Models\\Receipt',4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',6280.00,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4131,7928,40895,35836,3,4127,'App\\Models\\Receipt',4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3046.37,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4132,7928,40895,35836,3,4128,'App\\Models\\Receipt',4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',155969.00,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4133,7928,40895,35836,3,4129,'App\\Models\\Receipt',4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',19285.93,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4134,7928,40895,35836,3,4130,'App\\Models\\Receipt',4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3900.04,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4135,7928,40895,35836,3,4131,'App\\Models\\Receipt',4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',17500.00,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4136,7928,40895,35836,3,4132,'App\\Models\\Receipt',4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',2029.15,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4137,7928,40895,35836,3,4133,'App\\Models\\Receipt',4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2251.00,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL);
INSERT INTO `balance_libro` VALUES (4138,7928,40895,35836,3,4134,'App\\Models\\Receipt',4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',44000.00,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4139,7928,40895,35836,3,4135,'App\\Models\\Receipt',4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',3696.26,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4140,7928,40895,35836,3,4136,'App\\Models\\Receipt',4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',5492.00,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4141,7928,40895,35836,3,4137,'App\\Models\\Receipt',4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',9004.00,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4142,7928,40895,35836,3,4138,'App\\Models\\Receipt',4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',4668.53,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4143,7928,40895,35836,3,4139,'App\\Models\\Receipt',4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',2950.08,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4144,7928,40895,35836,3,4140,'App\\Models\\Receipt',4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',27243.18,NULL,NULL,1,'2024-02-27 18:54:48','2024-02-27 18:54:48',NULL),(4145,7928,40895,35836,3,4141,'App\\Models\\Receipt',4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1362.18,NULL,NULL,1,'2024-02-27 18:54:49','2024-02-27 18:54:49',NULL),(4146,7928,40895,35836,3,4142,'App\\Models\\Receipt',4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',6536.48,NULL,NULL,1,'2024-02-27 18:54:49','2024-02-27 18:54:49',NULL),(4147,7928,40895,35836,3,4143,'App\\Models\\Receipt',4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',10822.77,NULL,NULL,1,'2024-02-27 18:54:49','2024-02-27 18:54:49',NULL),(4148,7928,40895,35836,3,4144,'App\\Models\\Receipt',4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',43280.02,NULL,NULL,1,'2024-02-27 18:54:49','2024-02-27 18:54:49',NULL),(4149,7928,40895,35836,3,4145,'App\\Models\\Receipt',4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',105000.00,NULL,NULL,1,'2024-02-27 18:54:49','2024-02-27 18:54:49',NULL),(4150,7928,40895,35836,2,4146,'App\\Models\\Receipt',4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',334163.28,NULL,NULL,1,'2024-02-27 18:54:59','2024-02-27 18:54:59',NULL),(4151,7928,40895,35836,2,4147,'App\\Models\\Receipt',4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',811087.20,NULL,NULL,1,'2024-02-27 18:54:59','2024-02-27 18:54:59',NULL),(4152,7928,40895,35837,2,4148,'App\\Models\\Receipt',4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',604175.31,NULL,NULL,1,'2024-02-27 18:56:13','2024-02-27 18:56:13',NULL),(4153,7928,40895,35837,2,4149,'App\\Models\\Receipt',4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',202205.90,NULL,NULL,1,'2024-02-27 18:56:13','2024-02-27 18:56:13',NULL),(4154,7928,40895,35837,2,4150,'App\\Models\\Receipt',4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',202205.90,NULL,NULL,1,'2024-02-27 18:56:13','2024-02-27 18:56:13',NULL),(4155,7928,40895,35837,2,4151,'App\\Models\\Receipt',4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',900174.22,NULL,NULL,1,'2024-02-27 18:56:13','2024-02-27 18:56:13',NULL),(4156,7928,40895,35837,2,4152,'App\\Models\\Receipt',4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',312133.97,NULL,NULL,1,'2024-02-27 18:56:13','2024-02-27 18:56:13',NULL),(4157,7928,40895,35837,2,4153,'App\\Models\\Receipt',4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',202205.83,NULL,NULL,1,'2024-02-27 18:56:13','2024-02-27 18:56:13',NULL),(4158,7928,40895,35837,2,4154,'App\\Models\\Receipt',4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',179023.72,NULL,NULL,1,'2024-02-27 18:56:13','2024-02-27 18:56:13',NULL);
INSERT INTO `balance_libro` VALUES (4159,7928,40895,35837,2,4155,'App\\Models\\Receipt',4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',889280.30,NULL,NULL,1,'2024-02-27 18:56:13','2024-02-27 18:56:13',NULL),(4160,7928,40895,35837,3,4156,'App\\Models\\Receipt',4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3899.99,NULL,NULL,1,'2024-02-27 18:56:21','2024-02-27 18:56:21',NULL),(4161,7928,40895,35837,3,4157,'App\\Models\\Receipt',4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1723.80,NULL,NULL,1,'2024-02-27 18:56:21','2024-02-27 18:56:21',NULL),(4162,7928,40895,35837,3,4158,'App\\Models\\Receipt',4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',38520.65,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4163,7928,40895,35837,3,4159,'App\\Models\\Receipt',4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',15871.00,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4164,7928,40895,35837,3,4160,'App\\Models\\Receipt',4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',37800.64,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4165,7928,40895,35837,3,4161,'App\\Models\\Receipt',4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',147000.00,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4166,7928,40895,35837,3,4162,'App\\Models\\Receipt',4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3043.76,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4167,7928,40895,35837,3,4163,'App\\Models\\Receipt',4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',5445.68,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4168,7928,40895,35837,3,4164,'App\\Models\\Receipt',4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2500.08,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4169,7928,40895,35837,3,4165,'App\\Models\\Receipt',4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2671.76,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4170,7928,40895,35837,3,4166,'App\\Models\\Receipt',4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',4335.09,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4171,7928,40895,35837,3,4167,'App\\Models\\Receipt',4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',4857.00,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4172,7928,40895,35837,3,4168,'App\\Models\\Receipt',4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2321.71,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4173,7928,40895,35837,3,4169,'App\\Models\\Receipt',4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',16458.90,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4174,7928,40895,35837,3,4170,'App\\Models\\Receipt',4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12262.69,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4175,7928,40895,35837,3,4171,'App\\Models\\Receipt',4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12598.50,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4176,7928,40895,35837,3,4172,'App\\Models\\Receipt',4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',23554.60,NULL,NULL,1,'2024-02-27 18:56:22','2024-02-27 18:56:22',NULL),(4177,7928,40895,35837,3,4173,'App\\Models\\Receipt',4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',10891.33,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4178,7928,40895,35837,3,4174,'App\\Models\\Receipt',4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',2146.36,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4179,7928,40895,35837,3,4175,'App\\Models\\Receipt',4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',2683.05,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL);
INSERT INTO `balance_libro` VALUES (4180,7928,40895,35837,3,4176,'App\\Models\\Receipt',4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',62973.57,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4181,7928,40895,35837,3,4177,'App\\Models\\Receipt',4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2029.15,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4182,7928,40895,35837,3,4178,'App\\Models\\Receipt',4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3040.97,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4183,7928,40895,35837,3,4179,'App\\Models\\Receipt',4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',49899.00,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4184,7928,40895,35837,3,4180,'App\\Models\\Receipt',4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',99087.04,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4185,7928,40895,35837,3,4181,'App\\Models\\Receipt',4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3781.60,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4186,7928,40895,35837,3,4182,'App\\Models\\Receipt',4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',7104.00,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4187,7928,40895,35837,3,4183,'App\\Models\\Receipt',4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',14400.00,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4188,7928,40895,35837,3,4184,'App\\Models\\Receipt',4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',2700.00,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4189,7928,40895,35837,3,4185,'App\\Models\\Receipt',4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',2000.00,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4190,7928,40895,35837,3,4186,'App\\Models\\Receipt',4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',3900.00,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4191,7928,40895,35837,3,4187,'App\\Models\\Receipt',4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',4284.00,NULL,NULL,1,'2024-02-27 18:56:23','2024-02-27 18:56:23',NULL),(4192,7928,40895,35837,3,4188,'App\\Models\\Receipt',4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',400.00,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4193,7928,40895,35837,3,4189,'App\\Models\\Receipt',4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',17214.87,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4194,7928,40895,35837,3,4190,'App\\Models\\Receipt',4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',57999.00,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4195,7928,40895,35837,3,4191,'App\\Models\\Receipt',4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',14993.00,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4196,7928,40895,35837,3,4192,'App\\Models\\Receipt',4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',150017.01,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4197,7928,40895,35837,3,4193,'App\\Models\\Receipt',4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',11500.02,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4198,7928,40895,35837,3,4194,'App\\Models\\Receipt',4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',60000.00,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4199,7928,40895,35837,3,4195,'App\\Models\\Receipt',4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',2187.83,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4200,7928,40895,35837,3,4196,'App\\Models\\Receipt',4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',399.50,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL);
INSERT INTO `balance_libro` VALUES (4201,7928,40895,35837,3,4197,'App\\Models\\Receipt',4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',31303.30,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4202,7928,40895,35837,3,4198,'App\\Models\\Receipt',4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',82492.08,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4203,7928,40895,35837,3,4199,'App\\Models\\Receipt',4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',178760.00,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4204,7928,40895,35837,3,4200,'App\\Models\\Receipt',4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',6900.02,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4205,7928,40895,35837,3,4201,'App\\Models\\Receipt',4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',4107.00,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4206,7928,40895,35837,3,4202,'App\\Models\\Receipt',4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',113400.00,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4207,7928,40895,35837,3,4203,'App\\Models\\Receipt',4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',5509.86,NULL,NULL,1,'2024-02-27 18:56:24','2024-02-27 18:56:24',NULL),(4208,7928,40895,35838,2,4204,'App\\Models\\Receipt',4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',421983.42,NULL,NULL,1,'2024-02-27 18:57:50','2024-02-27 18:57:50',NULL),(4209,7928,40895,35838,2,4205,'App\\Models\\Receipt',4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',421983.42,NULL,NULL,1,'2024-02-27 18:57:50','2024-02-27 18:57:50',NULL),(4210,7928,40895,35838,2,4206,'App\\Models\\Receipt',4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',421983.42,NULL,NULL,1,'2024-02-27 18:57:50','2024-02-27 18:57:50',NULL),(4211,7928,40895,35838,2,4207,'App\\Models\\Receipt',4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2141046.60,NULL,NULL,1,'2024-02-27 18:57:50','2024-02-27 18:57:50',NULL),(4212,7928,40895,35838,2,4208,'App\\Models\\Receipt',4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',142036.32,NULL,NULL,1,'2024-02-27 18:57:50','2024-02-27 18:57:50',NULL),(4213,7928,40895,35838,2,4209,'App\\Models\\Receipt',4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',864853.51,NULL,NULL,1,'2024-02-27 18:57:50','2024-02-27 18:57:50',NULL),(4214,7928,40895,35838,2,4210,'App\\Models\\Receipt',4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',946052.10,NULL,NULL,1,'2024-02-27 18:57:50','2024-02-27 18:57:50',NULL),(4215,7928,40895,35838,3,4211,'App\\Models\\Receipt',4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',121239.00,NULL,NULL,1,'2024-02-27 18:58:00','2024-02-27 18:58:00',NULL),(4216,7928,40895,35838,3,4212,'App\\Models\\Receipt',4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',3899.99,NULL,NULL,1,'2024-02-27 18:58:00','2024-02-27 18:58:00',NULL),(4217,7928,40895,35838,3,4213,'App\\Models\\Receipt',4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',3288.06,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4218,7928,40895,35838,3,4214,'App\\Models\\Receipt',4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',2382.44,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4219,7928,40895,35838,3,4215,'App\\Models\\Receipt',4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',14279.00,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4220,7928,40895,35838,3,4216,'App\\Models\\Receipt',4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',359999.00,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL);
INSERT INTO `balance_libro` VALUES (4221,7928,40895,35838,3,4217,'App\\Models\\Receipt',4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',7357.14,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4222,7928,40895,35838,3,4218,'App\\Models\\Receipt',4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',9095.97,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4223,7928,40895,35838,3,4219,'App\\Models\\Receipt',4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',14376.39,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4224,7928,40895,35838,3,4220,'App\\Models\\Receipt',4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4233.28,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4225,7928,40895,35838,3,4221,'App\\Models\\Receipt',4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',24488.07,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4226,7928,40895,35838,3,4222,'App\\Models\\Receipt',4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',21927.64,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4227,7928,40895,35838,3,4223,'App\\Models\\Receipt',4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',15062.85,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4228,7928,40895,35838,3,4224,'App\\Models\\Receipt',4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',539.33,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4229,7928,40895,35838,3,4225,'App\\Models\\Receipt',4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',34755.66,NULL,NULL,1,'2024-02-27 18:58:01','2024-02-27 18:58:01',NULL),(4230,7928,40895,35838,3,4226,'App\\Models\\Receipt',4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',45623.06,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4231,7928,40895,35838,3,4227,'App\\Models\\Receipt',4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',52715.71,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4232,7928,40895,35838,3,4228,'App\\Models\\Receipt',4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10510.25,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4233,7928,40895,35838,3,4229,'App\\Models\\Receipt',4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',12436.51,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4234,7928,40895,35838,3,4230,'App\\Models\\Receipt',4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',122472.00,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4235,7928,40895,35838,3,4231,'App\\Models\\Receipt',4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',122472.00,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4236,7928,40895,35838,3,4232,'App\\Models\\Receipt',4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',122472.00,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4237,7928,40895,35838,3,4233,'App\\Models\\Receipt',4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',20000.00,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4238,7928,40895,35838,3,4234,'App\\Models\\Receipt',4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',5590.00,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4239,7928,40895,35838,3,4235,'App\\Models\\Receipt',4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',12000.00,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4240,7928,40895,35838,3,4236,'App\\Models\\Receipt',4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',171460.00,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL),(4241,7928,40895,35838,3,4237,'App\\Models\\Receipt',4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3900.01,NULL,NULL,1,'2024-02-27 18:58:02','2024-02-27 18:58:02',NULL);
INSERT INTO `balance_libro` VALUES (4242,7928,40895,35839,3,4238,'App\\Models\\Receipt',4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',4300.00,NULL,NULL,1,'2024-02-27 18:59:13','2024-02-27 18:59:13',NULL),(4243,7928,40895,35839,3,4239,'App\\Models\\Receipt',4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',332510.57,NULL,NULL,1,'2024-02-27 18:59:13','2024-02-27 18:59:13',NULL),(4244,7928,40895,35839,3,4240,'App\\Models\\Receipt',4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',72944.22,NULL,NULL,1,'2024-02-27 18:59:13','2024-02-27 18:59:13',NULL),(4245,7928,40895,35839,3,4241,'App\\Models\\Receipt',4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',317446.56,NULL,NULL,1,'2024-02-27 18:59:13','2024-02-27 18:59:13',NULL),(4246,7928,40895,35839,3,4242,'App\\Models\\Receipt',4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',3952.77,NULL,NULL,1,'2024-02-27 18:59:13','2024-02-27 18:59:13',NULL),(4247,7928,40895,35839,3,4243,'App\\Models\\Receipt',4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',11750.03,NULL,NULL,1,'2024-02-27 18:59:14','2024-02-27 18:59:14',NULL),(4248,7928,40895,35839,3,4244,'App\\Models\\Receipt',4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',7025.51,NULL,NULL,1,'2024-02-27 18:59:14','2024-02-27 18:59:14',NULL),(4249,7928,40895,35839,3,4245,'App\\Models\\Receipt',4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',3816.20,NULL,NULL,1,'2024-02-27 18:59:14','2024-02-27 18:59:14',NULL),(4250,7928,40895,35839,3,4246,'App\\Models\\Receipt',4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',123581.92,NULL,NULL,1,'2024-02-27 18:59:14','2024-02-27 18:59:14',NULL),(4251,7928,40895,35839,3,4247,'App\\Models\\Receipt',4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',207006.00,NULL,NULL,1,'2024-02-27 18:59:14','2024-02-27 18:59:14',NULL),(4252,7928,40895,35839,3,4248,'App\\Models\\Receipt',4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',49325.00,NULL,NULL,1,'2024-02-27 18:59:14','2024-02-27 18:59:14',NULL),(4253,7928,40895,35839,3,4249,'App\\Models\\Receipt',4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',36623.05,NULL,NULL,1,'2024-02-27 18:59:14','2024-02-27 18:59:14',NULL),(4254,7928,40895,35839,3,4250,'App\\Models\\Receipt',4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',19000.00,NULL,NULL,1,'2024-02-27 18:59:14','2024-02-27 18:59:14',NULL),(4255,7928,40895,35839,3,4251,'App\\Models\\Receipt',4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',41509.51,NULL,NULL,1,'2024-02-27 18:59:14','2024-02-27 18:59:14',NULL),(4256,7928,40895,35839,2,4252,'App\\Models\\Receipt',4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',34848.00,NULL,NULL,1,'2024-02-27 18:59:23','2024-02-27 18:59:23',NULL),(4257,7928,40895,35839,2,4253,'App\\Models\\Receipt',4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1021736.10,NULL,NULL,1,'2024-02-27 18:59:23','2024-02-27 18:59:23',NULL),(4258,7928,40895,35840,3,4254,'App\\Models\\Receipt',4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',11448.00,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4259,7928,40895,35840,3,4255,'App\\Models\\Receipt',4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',9507.24,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4260,7928,40895,35840,3,4256,'App\\Models\\Receipt',4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',4500.00,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4261,7928,40895,35840,3,4257,'App\\Models\\Receipt',4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',2857.32,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4262,7928,40895,35840,3,4258,'App\\Models\\Receipt',4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',342842.28,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL);
INSERT INTO `balance_libro` VALUES (4263,7928,40895,35840,3,4259,'App\\Models\\Receipt',4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',32620.00,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4264,7928,40895,35840,3,4260,'App\\Models\\Receipt',4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',12960.10,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4265,7928,40895,35840,3,4261,'App\\Models\\Receipt',4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',38150.00,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4266,7928,40895,35840,3,4262,'App\\Models\\Receipt',4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',14302.06,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4267,7928,40895,35840,3,4263,'App\\Models\\Receipt',4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',132270.00,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4268,7928,40895,35840,3,4264,'App\\Models\\Receipt',4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',13501.77,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4269,7928,40895,35840,3,4265,'App\\Models\\Receipt',4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',8500.00,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4270,7928,40895,35840,3,4266,'App\\Models\\Receipt',4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',16770.00,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4271,7928,40895,35840,3,4267,'App\\Models\\Receipt',4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',41100.00,NULL,NULL,1,'2024-02-27 19:00:42','2024-02-27 19:00:42',NULL),(4272,7928,40895,35840,3,4268,'App\\Models\\Receipt',4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',7500.00,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4273,7928,40895,35840,3,4269,'App\\Models\\Receipt',4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',10620.83,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4274,7928,40895,35840,3,4270,'App\\Models\\Receipt',4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',3540.47,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4275,7928,40895,35840,3,4271,'App\\Models\\Receipt',4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',23964.00,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4276,7928,40895,35840,3,4272,'App\\Models\\Receipt',4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',81250.00,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4277,7928,40895,35840,3,4273,'App\\Models\\Receipt',4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',91000.00,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4278,7928,40895,35840,3,4274,'App\\Models\\Receipt',4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',17900.00,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4279,7928,40895,35840,3,4275,'App\\Models\\Receipt',4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',9537.64,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4280,7928,40895,35840,3,4276,'App\\Models\\Receipt',4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',9750.40,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4281,7928,40895,35840,3,4277,'App\\Models\\Receipt',4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',9317.41,NULL,NULL,1,'2024-02-27 19:00:43','2024-02-27 19:00:43',NULL),(4282,7928,40895,35840,2,4278,'App\\Models\\Receipt',4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',925064.38,NULL,NULL,1,'2024-02-27 19:00:50','2024-02-27 19:00:50',NULL),(4283,7928,40895,35840,2,4279,'App\\Models\\Receipt',4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',496324.27,NULL,NULL,1,'2024-02-27 19:00:50','2024-02-27 19:00:50',NULL);
INSERT INTO `balance_libro` VALUES (4284,7928,40895,35840,2,4280,'App\\Models\\Receipt',4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1103474.02,NULL,NULL,1,'2024-02-27 19:00:51','2024-02-27 19:00:51',NULL),(4285,7928,40895,35841,2,4281,'App\\Models\\Receipt',4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1552579.53,NULL,NULL,1,'2024-02-27 19:02:04','2024-02-27 19:02:04',NULL),(4286,7928,40895,35841,2,4282,'App\\Models\\Receipt',4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',601370.00,NULL,NULL,1,'2024-02-27 19:02:04','2024-02-27 19:02:04',NULL),(4287,7928,40895,35841,2,4283,'App\\Models\\Receipt',4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',3590796.00,NULL,NULL,1,'2024-02-27 19:02:04','2024-02-27 19:02:04',NULL),(4288,7928,40895,35841,2,4284,'App\\Models\\Receipt',4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1191751.94,NULL,NULL,1,'2024-02-27 19:02:04','2024-02-27 19:02:04',NULL),(4289,7928,40895,35841,2,4285,'App\\Models\\Receipt',4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',890560.00,NULL,NULL,1,'2024-02-27 19:02:04','2024-02-27 19:02:04',NULL),(4290,7928,40895,35841,2,4286,'App\\Models\\Receipt',4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',613070.26,NULL,NULL,1,'2024-02-27 19:02:04','2024-02-27 19:02:04',NULL),(4291,7928,40895,35841,3,4287,'App\\Models\\Receipt',4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',4700.00,NULL,NULL,1,'2024-02-27 19:02:13','2024-02-27 19:02:13',NULL),(4292,7928,40895,35841,3,4288,'App\\Models\\Receipt',4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',5759.95,NULL,NULL,1,'2024-02-27 19:02:13','2024-02-27 19:02:13',NULL),(4293,7928,40895,35841,3,4289,'App\\Models\\Receipt',4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',1291121.36,NULL,NULL,1,'2024-02-27 19:02:13','2024-02-27 19:02:13',NULL),(4294,7928,40895,35841,3,4290,'App\\Models\\Receipt',4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',1100.02,NULL,NULL,1,'2024-02-27 19:02:13','2024-02-27 19:02:13',NULL),(4295,7928,40895,35841,3,4291,'App\\Models\\Receipt',4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',400000.00,NULL,NULL,1,'2024-02-27 19:02:13','2024-02-27 19:02:13',NULL),(4296,7928,40895,35841,3,4292,'App\\Models\\Receipt',4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',18815.76,NULL,NULL,1,'2024-02-27 19:02:13','2024-02-27 19:02:13',NULL),(4297,7928,40895,35841,3,4293,'App\\Models\\Receipt',4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',98812.32,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4298,7928,40895,35841,3,4294,'App\\Models\\Receipt',4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',125801.00,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4299,7928,40895,35841,3,4295,'App\\Models\\Receipt',4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',13222.99,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4300,7928,40895,35841,3,4296,'App\\Models\\Receipt',4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',174704.61,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4301,7928,40895,35841,3,4297,'App\\Models\\Receipt',4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10482.28,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4302,7928,40895,35841,3,4298,'App\\Models\\Receipt',4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',29300.00,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4303,7928,40895,35841,3,4299,'App\\Models\\Receipt',4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',11753.45,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL);
INSERT INTO `balance_libro` VALUES (4304,7928,40895,35841,3,4300,'App\\Models\\Receipt',4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',4457.01,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4305,7928,40895,35841,3,4301,'App\\Models\\Receipt',4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-20','2023-08-20',2525.78,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4306,7928,40895,35841,3,4302,'App\\Models\\Receipt',4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',8029.42,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4307,7928,40895,35841,3,4303,'App\\Models\\Receipt',4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',207477.02,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4308,7928,40895,35841,3,4304,'App\\Models\\Receipt',4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',16200.38,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4309,7928,40895,35841,3,4305,'App\\Models\\Receipt',4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',10000.02,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4310,7928,40895,35841,3,4306,'App\\Models\\Receipt',4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-20','2023-08-20',15500.31,NULL,NULL,1,'2024-02-27 19:02:14','2024-02-27 19:02:14',NULL),(4311,7928,40895,35841,3,4307,'App\\Models\\Receipt',4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',5000.00,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4312,7928,40895,35841,3,4308,'App\\Models\\Receipt',4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',3000.00,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4313,7928,40895,35841,3,4309,'App\\Models\\Receipt',4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',3000.00,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4314,7928,40895,35841,3,4310,'App\\Models\\Receipt',4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',10000.02,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4315,7928,40895,35841,3,4311,'App\\Models\\Receipt',4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',4000.02,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4316,7928,40895,35841,3,4312,'App\\Models\\Receipt',4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',3850.22,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4317,7928,40895,35841,3,4313,'App\\Models\\Receipt',4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',5130.00,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4318,7928,40895,35841,3,4314,'App\\Models\\Receipt',4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',5001.61,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4319,7928,40895,35841,3,4315,'App\\Models\\Receipt',4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',18004.25,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4320,7928,40895,35841,3,4316,'App\\Models\\Receipt',4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',4999.99,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4321,7928,40895,35841,3,4317,'App\\Models\\Receipt',4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',8000.01,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4322,7928,40895,35841,3,4318,'App\\Models\\Receipt',4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-13','2023-08-13',5000.00,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4323,7928,40895,35841,3,4319,'App\\Models\\Receipt',4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',4000.22,NULL,NULL,1,'2024-02-27 19:02:15','2024-02-27 19:02:15',NULL),(4324,7928,40895,35841,3,4320,'App\\Models\\Receipt',4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',7746.85,NULL,NULL,1,'2024-02-27 19:02:16','2024-02-27 19:02:16',NULL);
INSERT INTO `balance_libro` VALUES (4325,7928,40895,35841,3,4321,'App\\Models\\Receipt',4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',14505.39,NULL,NULL,1,'2024-02-27 19:02:16','2024-02-27 19:02:16',NULL),(4326,7928,40895,35841,3,4322,'App\\Models\\Receipt',4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',11901.70,NULL,NULL,1,'2024-02-27 19:02:16','2024-02-27 19:02:16',NULL),(4327,7928,40895,35841,3,4323,'App\\Models\\Receipt',4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',3100.00,NULL,NULL,1,'2024-02-27 19:02:16','2024-02-27 19:02:16',NULL),(4328,7928,40895,35841,3,4324,'App\\Models\\Receipt',4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',2999.91,NULL,NULL,1,'2024-02-27 19:02:16','2024-02-27 19:02:16',NULL),(4329,7928,40895,35841,3,4325,'App\\Models\\Receipt',4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',4000.00,NULL,NULL,1,'2024-02-27 19:02:16','2024-02-27 19:02:16',NULL),(4330,7928,40895,35842,2,4326,'App\\Models\\Receipt',4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',326211.42,NULL,NULL,1,'2024-02-27 19:04:00','2024-02-27 19:04:00',NULL),(4331,7928,40895,35842,2,4327,'App\\Models\\Receipt',4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',302500.00,NULL,NULL,1,'2024-02-27 19:04:00','2024-02-27 19:04:00',NULL),(4332,7928,40895,35842,2,4328,'App\\Models\\Receipt',4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',121484.00,NULL,NULL,1,'2024-02-27 19:04:00','2024-02-27 19:04:00',NULL),(4333,7928,40895,35842,2,4329,'App\\Models\\Receipt',4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',466803.48,NULL,NULL,1,'2024-02-27 19:04:00','2024-02-27 19:04:00',NULL),(4334,7928,40895,35842,2,4330,'App\\Models\\Receipt',4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',445280.00,NULL,NULL,1,'2024-02-27 19:04:00','2024-02-27 19:04:00',NULL),(4335,7928,40895,35842,2,4331,'App\\Models\\Receipt',4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',601370.00,NULL,NULL,1,'2024-02-27 19:04:00','2024-02-27 19:04:00',NULL),(4336,7928,40895,35842,2,4332,'App\\Models\\Receipt',4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',618068.00,NULL,NULL,1,'2024-02-27 19:04:00','2024-02-27 19:04:00',NULL),(4337,7928,40895,35842,2,4333,'App\\Models\\Receipt',4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',2393864.00,NULL,NULL,1,'2024-02-27 19:04:00','2024-02-27 19:04:00',NULL),(4338,7928,40895,35842,2,4334,'App\\Models\\Receipt',4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',108900.00,NULL,NULL,1,'2024-02-27 19:04:00','2024-02-27 19:04:00',NULL),(4339,7928,40895,35842,3,4335,'App\\Models\\Receipt',4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',4900.00,NULL,NULL,1,'2024-02-27 19:04:08','2024-02-27 19:04:08',NULL),(4340,7928,40895,35842,3,4336,'App\\Models\\Receipt',4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',215989.00,NULL,NULL,1,'2024-02-27 19:04:08','2024-02-27 19:04:08',NULL),(4341,7928,40895,35842,3,4337,'App\\Models\\Receipt',4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',2200.02,NULL,NULL,1,'2024-02-27 19:04:08','2024-02-27 19:04:08',NULL),(4342,7928,40895,35842,3,4338,'App\\Models\\Receipt',4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',115599.80,NULL,NULL,1,'2024-02-27 19:04:08','2024-02-27 19:04:08',NULL),(4343,7928,40895,35842,3,4339,'App\\Models\\Receipt',4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',43403.00,NULL,NULL,1,'2024-02-27 19:04:08','2024-02-27 19:04:08',NULL),(4344,7928,40895,35842,3,4340,'App\\Models\\Receipt',4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',25761.43,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL);
INSERT INTO `balance_libro` VALUES (4345,7928,40895,35842,3,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',19483.20,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4346,7928,40895,35842,3,4342,'App\\Models\\Receipt',4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',27328.99,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4347,7928,40895,35842,3,4343,'App\\Models\\Receipt',4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',54800.00,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4348,7928,40895,35842,3,4344,'App\\Models\\Receipt',4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',38717.75,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4349,7928,40895,35842,3,4345,'App\\Models\\Receipt',4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',3871.78,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4350,7928,40895,35842,3,4346,'App\\Models\\Receipt',4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',666666.67,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4351,7928,40895,35842,3,4347,'App\\Models\\Receipt',4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',9157.39,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4352,7928,40895,35842,3,4348,'App\\Models\\Receipt',4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',46487.06,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4353,7928,40895,35842,3,4349,'App\\Models\\Receipt',4349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',13665.21,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4354,7928,40895,35842,3,4350,'App\\Models\\Receipt',4350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',28850.00,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4355,7928,40895,35842,3,4351,'App\\Models\\Receipt',4351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',666666.67,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4356,7928,40895,35842,3,4352,'App\\Models\\Receipt',4352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',666666.67,NULL,NULL,1,'2024-02-27 19:04:09','2024-02-27 19:04:09',NULL),(4357,7928,40895,35843,3,4353,'App\\Models\\Receipt',4353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',383269043.00,NULL,NULL,1,'2024-02-27 19:05:32','2024-08-06 19:25:02','2024-08-06 19:25:02'),(4358,7928,40895,35843,3,4354,'App\\Models\\Receipt',4354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',383269043.00,NULL,NULL,1,'2024-02-27 19:05:32','2024-08-06 19:25:28','2024-08-06 19:25:28'),(4359,7928,40895,35843,3,4355,'App\\Models\\Receipt',4355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',1824.03,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL),(4360,7928,40895,35843,3,4356,'App\\Models\\Receipt',4356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',251929.90,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL),(4361,7928,40895,35843,3,4357,'App\\Models\\Receipt',4357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',6400.00,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL),(4362,7928,40895,35843,3,4358,'App\\Models\\Receipt',4358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',383269.43,NULL,NULL,1,'2024-02-27 19:05:32','2024-08-06 19:24:33','2024-08-06 19:24:33'),(4363,7928,40895,35843,3,4359,'App\\Models\\Receipt',4359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',146500.44,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL),(4364,7928,40895,35843,3,4360,'App\\Models\\Receipt',4360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',45006.45,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL);
INSERT INTO `balance_libro` VALUES (4365,7928,40895,35843,3,4361,'App\\Models\\Receipt',4361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',117861.89,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL),(4366,7928,40895,35843,3,4362,'App\\Models\\Receipt',4362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',12650.00,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL),(4367,7928,40895,35843,3,4363,'App\\Models\\Receipt',4363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',16483.50,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL),(4368,7928,40895,35843,3,4364,'App\\Models\\Receipt',4364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',124713.14,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL),(4369,7928,40895,35843,3,4365,'App\\Models\\Receipt',4365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',1500.00,NULL,NULL,1,'2024-02-27 19:05:32','2024-02-27 19:05:32',NULL),(4370,7928,40895,35843,3,4366,'App\\Models\\Receipt',4366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',7100.00,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4371,7928,40895,35843,3,4367,'App\\Models\\Receipt',4367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',257009.78,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4372,7928,40895,35843,3,4368,'App\\Models\\Receipt',4368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',43787.08,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4373,7928,40895,35843,3,4369,'App\\Models\\Receipt',4369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',4378.71,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4374,7928,40895,35843,3,4370,'App\\Models\\Receipt',4370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',41653.74,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4375,7928,40895,35843,3,4371,'App\\Models\\Receipt',4371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',16104.31,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4376,7928,40895,35843,3,4372,'App\\Models\\Receipt',4372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',54200.00,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4377,7928,40895,35843,3,4373,'App\\Models\\Receipt',4373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',50000.00,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4378,7928,40895,35843,3,4374,'App\\Models\\Receipt',4374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',15089.66,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4379,7928,40895,35843,3,4375,'App\\Models\\Receipt',4375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',4600.00,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4380,7928,40895,35843,3,4376,'App\\Models\\Receipt',4376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',181122.48,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4381,7928,40895,35843,3,4377,'App\\Models\\Receipt',4377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',137530.00,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4382,7928,40895,35843,3,4378,'App\\Models\\Receipt',4378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-29','2023-10-29',400000.00,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4383,7928,40895,35843,3,4379,'App\\Models\\Receipt',4379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',23730.06,NULL,NULL,1,'2024-02-27 19:05:33','2024-02-27 19:05:33',NULL),(4384,7928,40895,35843,3,4380,'App\\Models\\Receipt',4380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',15100.00,NULL,NULL,1,'2024-02-27 19:05:34','2024-02-27 19:05:34',NULL);
INSERT INTO `balance_libro` VALUES (4385,7928,40895,35843,2,4381,'App\\Models\\Receipt',4381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1390059.47,NULL,NULL,1,'2024-02-27 19:05:44','2024-02-27 19:05:44',NULL),(4386,7928,40895,35844,2,4382,'App\\Models\\Receipt',4382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',536937.50,NULL,NULL,1,'2024-02-27 19:06:51','2024-02-27 19:06:51',NULL),(4387,7928,40895,35844,2,4383,'App\\Models\\Receipt',4383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',1102342.67,NULL,NULL,1,'2024-02-27 19:06:51','2024-02-27 19:06:51',NULL),(4388,7928,40895,35844,2,4384,'App\\Models\\Receipt',4384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',423500.00,NULL,NULL,1,'2024-02-27 19:06:51','2024-02-27 19:06:51',NULL),(4389,7928,40895,35844,2,4385,'App\\Models\\Receipt',4385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1501264.23,NULL,NULL,1,'2024-02-27 19:06:51','2024-02-27 19:06:51',NULL),(4390,7928,40895,35844,2,4386,'App\\Models\\Receipt',4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',358160.00,NULL,NULL,1,'2024-02-27 19:06:52','2024-02-27 19:06:52',NULL),(4391,7928,40895,35844,2,4387,'App\\Models\\Receipt',4387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',2020102.26,NULL,NULL,1,'2024-02-27 19:06:52','2024-02-27 19:06:52',NULL),(4392,7928,40895,35844,2,4388,'App\\Models\\Receipt',4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3851226.72,NULL,NULL,1,'2024-02-27 19:06:52','2024-02-27 19:06:52',NULL),(4393,7928,40895,35844,3,4389,'App\\Models\\Receipt',4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',124168.05,NULL,NULL,1,'2024-02-27 19:07:01','2024-02-27 19:07:01',NULL),(4394,7928,40895,35844,3,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',6400.00,NULL,NULL,1,'2024-02-27 19:07:01','2024-02-27 19:07:01',NULL),(4395,7928,40895,35844,3,4391,'App\\Models\\Receipt',4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',6588.36,NULL,NULL,1,'2024-02-27 19:07:01','2024-02-27 19:07:01',NULL),(4396,7928,40895,35844,3,4392,'App\\Models\\Receipt',4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',184611.00,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4397,7928,40895,35844,3,4393,'App\\Models\\Receipt',4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',260000.00,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4398,7928,40895,35844,3,4394,'App\\Models\\Receipt',4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',7500.00,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4399,7928,40895,35844,3,4395,'App\\Models\\Receipt',4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',264736.48,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4400,7928,40895,35844,3,4396,'App\\Models\\Receipt',4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',302232.43,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4401,7928,40895,35844,3,4397,'App\\Models\\Receipt',4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',5900.03,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4402,7928,40895,35844,3,4398,'App\\Models\\Receipt',4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',8099.99,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4403,7928,40895,35844,3,4399,'App\\Models\\Receipt',4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',400000.00,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4404,7928,40895,35844,3,4400,'App\\Models\\Receipt',4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',340000.00,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL);
INSERT INTO `balance_libro` VALUES (4405,7928,40895,35844,3,4401,'App\\Models\\Receipt',4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',200000.00,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4406,7928,40895,35844,3,4402,'App\\Models\\Receipt',4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',8533.86,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4407,7928,40895,35844,3,4403,'App\\Models\\Receipt',4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',42990.50,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4408,7928,40895,35844,3,4404,'App\\Models\\Receipt',4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',49466.60,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4409,7928,40895,35844,3,4405,'App\\Models\\Receipt',4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',14101.59,NULL,NULL,1,'2024-02-27 19:07:02','2024-02-27 19:07:02',NULL),(4410,7928,40895,35844,3,4406,'App\\Models\\Receipt',4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',1327550.34,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4411,7928,40895,35844,3,4407,'App\\Models\\Receipt',4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',15739.30,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4412,7928,40895,35844,3,4408,'App\\Models\\Receipt',4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',78253.13,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4413,7928,40895,35844,3,4409,'App\\Models\\Receipt',4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',31160.46,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4414,7928,40895,35844,3,4410,'App\\Models\\Receipt',4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',10699.21,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4415,7928,40895,35844,3,4411,'App\\Models\\Receipt',4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',59646.65,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4416,7928,40895,35844,3,4412,'App\\Models\\Receipt',4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',39900.00,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4417,7928,40895,35844,3,4413,'App\\Models\\Receipt',4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',5318.58,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4418,7928,40895,35844,3,4414,'App\\Models\\Receipt',4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',8756.30,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4419,7928,40895,35844,3,4415,'App\\Models\\Receipt',4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',254089.98,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4420,7928,40895,35844,3,4416,'App\\Models\\Receipt',4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',160932.00,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4421,7928,40895,35844,3,4417,'App\\Models\\Receipt',4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',15230.70,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4422,7928,40895,35844,3,4418,'App\\Models\\Receipt',4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',287508.29,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4423,7928,40895,35844,3,4419,'App\\Models\\Receipt',4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',999.00,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4424,7928,40895,35844,3,4420,'App\\Models\\Receipt',4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',47233.33,NULL,NULL,1,'2024-02-27 19:07:03','2024-02-27 19:07:03',NULL),(4425,7928,40895,35844,3,4421,'App\\Models\\Receipt',4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',51880.00,NULL,NULL,1,'2024-02-27 19:07:04','2024-02-27 19:07:04',NULL);
INSERT INTO `balance_libro` VALUES (4426,7928,40895,35844,3,4422,'App\\Models\\Receipt',4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',9909.23,NULL,NULL,1,'2024-02-27 19:07:04','2024-02-27 19:07:04',NULL),(4427,7928,40895,35844,3,4423,'App\\Models\\Receipt',4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',5200.00,NULL,NULL,1,'2024-02-27 19:07:04','2024-02-27 19:07:04',NULL),(4428,7928,40895,35845,2,4424,'App\\Models\\Receipt',4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',834900.00,NULL,NULL,1,'2024-02-27 19:08:16','2024-02-27 19:08:16',NULL),(4429,7928,40895,35845,2,4425,'App\\Models\\Receipt',4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',1518678.26,NULL,NULL,1,'2024-02-27 19:08:16','2024-02-27 19:08:16',NULL),(4430,7928,40895,35845,2,4426,'App\\Models\\Receipt',4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',1621365.37,NULL,NULL,1,'2024-02-27 19:08:16','2024-02-27 19:08:16',NULL),(4431,7928,40895,35845,3,4427,'App\\Models\\Receipt',4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',6400.00,NULL,NULL,1,'2024-02-27 19:08:24','2024-02-27 19:08:24',NULL),(4432,7928,40895,35845,3,4428,'App\\Models\\Receipt',4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',107470.99,NULL,NULL,1,'2024-02-27 19:08:24','2024-02-27 19:08:24',NULL),(4433,7928,40895,35845,3,4429,'App\\Models\\Receipt',4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',824373.00,NULL,NULL,1,'2024-02-27 19:08:24','2024-02-27 19:08:24',NULL),(4434,7928,40895,35845,3,4430,'App\\Models\\Receipt',4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',139210.00,NULL,NULL,1,'2024-02-27 19:08:24','2024-02-27 19:08:24',NULL),(4435,7928,40895,35845,3,4431,'App\\Models\\Receipt',4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',155398.00,NULL,NULL,1,'2024-02-27 19:08:24','2024-02-27 19:08:24',NULL),(4436,7928,40895,35845,3,4432,'App\\Models\\Receipt',4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',24972.63,NULL,NULL,1,'2024-02-27 19:08:24','2024-02-27 19:08:24',NULL),(4437,7928,40895,35845,3,4433,'App\\Models\\Receipt',4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',33126.01,NULL,NULL,1,'2024-02-27 19:08:24','2024-02-27 19:08:24',NULL),(4438,7928,40895,35845,3,4434,'App\\Models\\Receipt',4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',43140.02,NULL,NULL,1,'2024-02-27 19:08:24','2024-02-27 19:08:24',NULL),(4439,7928,40895,35845,3,4435,'App\\Models\\Receipt',4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',70454.21,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4440,7928,40895,35845,3,4436,'App\\Models\\Receipt',4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',200000.00,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4441,7928,40895,35845,3,4437,'App\\Models\\Receipt',4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',2336.36,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4442,7928,40895,35845,3,4438,'App\\Models\\Receipt',4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',362224.50,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4443,7928,40895,35845,3,4439,'App\\Models\\Receipt',4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',90036.21,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4444,7928,40895,35845,3,4440,'App\\Models\\Receipt',4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',29265.00,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4445,7928,40895,35845,3,4441,'App\\Models\\Receipt',4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',154504.08,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL);
INSERT INTO `balance_libro` VALUES (4446,7928,40895,35845,3,4442,'App\\Models\\Receipt',4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',18125.00,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4447,7928,40895,35845,3,4443,'App\\Models\\Receipt',4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',36356.75,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4448,7928,40895,35845,3,4444,'App\\Models\\Receipt',4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',61556.16,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4449,7928,40895,35845,3,4445,'App\\Models\\Receipt',4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',53002.12,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4450,7928,40895,35845,3,4446,'App\\Models\\Receipt',4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',170702.82,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4451,7928,40895,35845,3,4447,'App\\Models\\Receipt',4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',405783.00,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4452,7928,40895,35845,3,4448,'App\\Models\\Receipt',4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',131800.00,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4453,7928,40895,35845,3,4449,'App\\Models\\Receipt',4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',35982.41,NULL,NULL,1,'2024-02-27 19:08:25','2024-02-27 19:08:25',NULL),(4454,7928,40895,35845,3,4450,'App\\Models\\Receipt',4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',53104.37,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4455,7928,40895,35845,3,4451,'App\\Models\\Receipt',4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',100750.04,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4456,7928,40895,35845,3,4452,'App\\Models\\Receipt',4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',10702.24,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4457,7928,40895,35845,3,4453,'App\\Models\\Receipt',4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',230000.00,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4458,7928,40895,35845,3,4454,'App\\Models\\Receipt',4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',9900.00,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4459,7928,40895,35845,3,4455,'App\\Models\\Receipt',4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',13856.45,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4460,7928,40895,35845,3,4456,'App\\Models\\Receipt',4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',61995.32,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4461,7928,40895,35845,3,4457,'App\\Models\\Receipt',4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-10','2023-12-10',13005.68,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4462,7928,40895,35845,3,4458,'App\\Models\\Receipt',4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',13856.45,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4463,7928,40895,35845,3,4459,'App\\Models\\Receipt',4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',23402.01,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4464,7928,40895,35845,3,4460,'App\\Models\\Receipt',4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',51373.45,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4465,7928,40895,35845,3,4461,'App\\Models\\Receipt',4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',31000.91,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL);
INSERT INTO `balance_libro` VALUES (4466,7928,40895,35845,3,4462,'App\\Models\\Receipt',4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-08','2023-12-08',10999.51,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4467,7928,40895,35845,3,4463,'App\\Models\\Receipt',4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',27002.99,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4468,7928,40895,35845,3,4464,'App\\Models\\Receipt',4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',26999.11,NULL,NULL,1,'2024-02-27 19:08:26','2024-02-27 19:08:26',NULL),(4469,7928,40895,35845,3,4465,'App\\Models\\Receipt',4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-10','2023-12-10',15000.81,NULL,NULL,1,'2024-02-27 19:08:27','2024-02-27 19:08:27',NULL),(4470,7928,40895,35845,3,4466,'App\\Models\\Receipt',4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',5000.00,NULL,NULL,1,'2024-02-27 19:08:27','2024-02-27 19:08:27',NULL),(4471,7928,40895,35845,3,4467,'App\\Models\\Receipt',4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',5000.00,NULL,NULL,1,'2024-02-27 19:08:27','2024-02-27 19:08:27',NULL),(4472,7928,40895,35849,3,4468,'App\\Models\\Receipt',4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',6251.24,NULL,NULL,1,'2024-02-27 19:09:38','2024-02-27 19:09:38',NULL),(4473,7928,40895,35849,3,4469,'App\\Models\\Receipt',4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',8949.99,NULL,NULL,1,'2024-02-27 19:09:38','2024-02-27 19:09:38',NULL),(4474,7928,40895,35849,3,4470,'App\\Models\\Receipt',4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',51200.00,NULL,NULL,1,'2024-02-27 19:09:38','2024-02-27 19:09:38',NULL),(4475,7928,40895,35849,3,4471,'App\\Models\\Receipt',4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',580563.21,NULL,NULL,1,'2024-02-27 19:09:38','2024-02-27 19:09:38',NULL),(4476,7928,40895,35849,3,4472,'App\\Models\\Receipt',4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',116575.00,NULL,NULL,1,'2024-02-27 19:09:38','2024-02-27 19:09:38',NULL),(4477,7928,40895,35849,3,4473,'App\\Models\\Receipt',4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',8622.04,NULL,NULL,1,'2024-02-27 19:09:38','2024-02-27 19:09:38',NULL),(4478,7928,40895,35849,3,4474,'App\\Models\\Receipt',4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',500000.00,NULL,NULL,1,'2024-02-27 19:09:38','2024-02-27 19:09:38',NULL),(4479,7928,40895,35849,3,4475,'App\\Models\\Receipt',4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',254905.29,NULL,NULL,1,'2024-02-27 19:09:38','2024-02-27 19:09:38',NULL),(4480,7928,40895,35849,3,4476,'App\\Models\\Receipt',4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',55423.14,NULL,NULL,1,'2024-02-27 19:09:38','2024-02-27 19:09:38',NULL),(4481,7928,40895,35849,3,4477,'App\\Models\\Receipt',4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',90999.06,NULL,NULL,1,'2024-02-27 19:09:39','2024-02-27 19:09:39',NULL),(4482,7928,40895,35849,3,4478,'App\\Models\\Receipt',4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',112400.00,NU