-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-20947687-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-02 12:14:29','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-02 12:14:29','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,'2023-11-13 17:22:14','2023-11-13 17:22:14',NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,'2023-11-13 17:22:26','2023-11-13 17:22:26',NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,'2023-11-13 17:22:39','2023-11-13 17:22:39',NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,'2023-11-13 17:22:52','2023-11-13 17:22:52',NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,'2023-11-13 17:23:03','2023-11-13 17:23:03',NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,'2023-11-13 17:23:11','2023-11-13 17:23:11',NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,'2023-11-13 17:23:22','2023-11-13 17:23:22',NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,'2023-11-13 17:23:32','2023-11-13 17:23:32',NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,'2023-11-13 17:23:41','2023-11-13 17:23:41',NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL),('2023-11','2023-11',2023,11,'2023-11-01','2023-11-30',2816.0628,'2025-07-29 13:39:07','2025-07-29 13:39:07',NULL),('2023-12','2023-12',2023,12,'2023-12-01','2023-12-31',3533.1922,'2025-07-29 13:39:26','2025-07-29 13:39:26',NULL),('2024-1','2024-01',2024,1,'2024-01-01','2024-01-31',4261.5324,'2025-07-29 13:40:01','2025-07-29 13:40:01',NULL),('2024-2','2024-02',2024,2,'2024-02-01','2024-02-28',4825.7881,'2025-07-29 13:40:14','2025-07-29 13:40:14',NULL),('2024-3','2024-03',2024,3,'2024-03-01','2024-03-31',5357.0929,'2025-07-29 13:40:33','2025-07-29 13:40:33',NULL),('2024-4','2024-04',2024,4,'2024-04-01','2024-04-30',5830.2271,'2025-07-29 16:40:44','2025-07-29 16:40:44',NULL),('2024-5','2024-05',2024,5,'2024-05-01','2024-05-31',6073.7165,'2025-07-29 13:41:52','2025-07-29 13:41:52',NULL),('2024-6','2024-06',2024,6,'2024-06-01','2024-06-30',6351.7145,'2025-07-29 13:42:07','2025-07-29 13:42:07',NULL),('2024-7','2024-07',2024,7,'2024-07-01','2024-07-31',6607.7479,'2025-07-29 13:42:18','2025-07-29 13:42:18',NULL),('2024-8','2024-08',2024,8,'2024-08-01','2024-08-31',6883.4412,'2025-07-29 13:42:41','2025-07-29 13:42:41',NULL),('2024-9','2024-09',2024,9,'2024-09-01','2024-09-30',7122.2421,'2025-07-29 13:42:52','2025-07-29 13:42:52',NULL),('2024-10','2024-10',2024,10,'2024-10-01','2024-10-31',7313.9542,'2025-07-29 13:43:01','2025-07-29 13:43:01',NULL),('2024-11','2024-11',2024,11,'2024-11-01','2024-11-30',7491.4314,'2025-07-29 13:43:14','2025-07-29 13:43:14',NULL),('2024-12','2024-12',2024,12,'2024-12-01','2024-12-31',7694.0075,'2025-07-29 13:43:24','2025-07-29 13:43:24',NULL),('2025-1','2025-01',2025,1,'2025-01-01','2025-01-31',7864.1257,'2025-07-29 13:43:34','2025-07-29 13:43:34',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2025-2','2025-02',2025,2,'2025-02-01','2025-02-28',8052.9927,'2025-07-29 13:43:45','2025-07-29 13:43:45',NULL),('2025-3','2025-03',2025,3,'2025-03-01','2025-03-31',8353.3158,'2025-07-29 13:44:01','2025-07-29 13:44:01',NULL),('2025-4','2025-04',2025,4,'2025-04-01','2025-04-30',8585.6078,'2025-07-29 13:44:12','2025-07-29 13:44:12',NULL),('2025-5','2025-05',2025,5,'2025-05-01','2025-05-31',8714.4871,'2025-07-29 13:44:24','2025-07-29 13:44:24',NULL),('2025-6','2025-06',2025,6,'2025-06-01','2025-06-30',8855.5681,'2025-07-29 13:44:36','2025-07-29 13:44:36',NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'sANTAMARIA10',NULL,1,40724,'2022-08-20'),(2,NULL,'sANTAMARIA10',NULL,1,40724,'2022-08-20'),(3,NULL,'sANTAMARIA10',NULL,1,40724,'2022-12-26'),(4,NULL,'sANTAMARIA10',NULL,1,40724,'2023-04-20'),(5,NULL,'sANTAMARIA10',NULL,1,40724,'2023-08-29'),(6,NULL,'sANTAMARIA10',NULL,1,40724,'2023-09-09');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'diegofourcade@hotmail.com','1164407594',NULL,1,40719,'2022-08-02');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(16,4,5,452,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(17,4,5,157,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(18,4,5,251,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(19,4,5,396,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(20,4,5,63,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(21,4,5,484,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(22,4,5,485,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(23,4,5,62,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(24,4,5,74,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(25,4,5,326,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(26,4,5,82,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(27,4,5,483,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(28,4,5,482,NULL,0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(29,5,16,208,NULL,0.00,'2023-09-11 08:25:51','2023-09-11 08:25:51',NULL),(30,5,16,251,NULL,0.00,'2023-09-11 08:25:51','2023-09-11 08:25:51',NULL),(31,5,16,482,NULL,0.00,'2023-09-11 08:25:51','2023-09-11 08:25:51',NULL),(32,5,16,301,NULL,0.00,'2023-09-11 08:25:51','2023-09-11 08:25:51',NULL),(33,5,16,326,NULL,0.00,'2023-09-11 08:25:52','2023-09-11 08:25:52',NULL),(34,6,15,67,NULL,0.00,'2023-09-11 08:30:07','2023-09-11 08:30:07',NULL),(35,6,15,68,NULL,0.00,'2023-09-11 08:30:07','2023-09-11 08:30:07',NULL),(36,6,15,483,NULL,0.00,'2023-09-11 08:30:07','2023-09-11 08:30:07',NULL),(37,6,15,25,NULL,0.00,'2023-09-11 08:30:07','2023-09-11 08:30:07',NULL),(38,6,15,353,NULL,0.00,'2023-09-11 08:30:07','2023-09-11 08:30:07',NULL),(39,6,15,74,NULL,0.00,'2023-09-11 08:30:07','2023-09-11 08:30:07',NULL),(40,7,1,110,NULL,0.00,'2023-09-11 10:12:13','2023-09-11 10:12:13',NULL),(41,7,1,111,NULL,0.00,'2023-09-11 10:12:13','2023-09-11 10:12:13',NULL),(42,7,1,62,NULL,0.00,'2023-09-11 10:12:13','2023-09-11 10:12:13',NULL),(43,7,1,63,NULL,0.00,'2023-09-11 10:12:13','2023-09-11 10:12:13',NULL),(44,7,1,64,NULL,0.00,'2023-09-11 10:12:13','2023-09-11 10:12:13',NULL),(45,8,1,5,NULL,0.00,'2023-09-12 10:22:28','2023-09-12 10:22:28',NULL),(46,8,1,62,NULL,0.00,'2023-09-12 10:22:29','2023-09-12 10:22:29',NULL),(47,9,21,64,NULL,0.00,'2023-09-13 09:36:34','2023-09-13 09:36:34',NULL),(48,9,21,5,NULL,0.00,'2023-09-13 09:36:34','2023-09-13 09:36:34',NULL),(49,10,21,64,NULL,0.00,'2023-09-13 09:37:11','2023-09-13 09:37:11',NULL),(50,10,21,5,NULL,0.00,'2023-09-13 09:37:11','2023-09-13 09:37:11',NULL),(51,11,17,1029,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(52,11,17,23,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(53,11,17,24,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(54,11,17,484,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(55,11,17,485,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(56,11,17,301,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(57,11,17,354,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(58,11,17,392,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(59,11,17,363,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(60,11,17,48,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(61,11,17,419,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(62,11,17,420,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(63,11,17,57,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(64,11,17,62,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(65,11,17,63,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(66,11,17,64,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL);
INSERT INTO `balance_asiento_modelo_detail` VALUES (67,11,17,79,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(68,11,17,82,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(69,11,17,486,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(70,11,17,88,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(71,11,17,89,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(72,11,17,369,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(73,11,17,91,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(74,11,17,93,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(75,11,17,383,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(76,11,17,381,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(77,11,17,96,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(78,11,17,218,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(79,11,17,110,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(80,11,17,111,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(81,11,17,476,NULL,0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(82,11,17,412,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(83,11,17,1028,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(84,11,17,487,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(85,11,17,136,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(86,11,17,192,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(87,11,17,217,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(88,11,17,396,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(89,11,17,396,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(90,11,17,140,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(91,11,17,1027,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(92,11,17,157,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(93,11,17,204,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(94,11,17,208,NULL,0.00,'2024-06-10 10:47:48','2024-06-10 10:47:48',NULL),(95,12,12,359,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(96,12,12,452,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(97,12,12,1029,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(98,12,12,13,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(99,12,12,23,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(100,12,12,24,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(101,12,12,484,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(102,12,12,485,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(103,12,12,20,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(104,12,12,301,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(105,12,12,354,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(106,12,12,392,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(107,12,12,363,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(108,12,12,48,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(109,12,12,419,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(110,12,12,420,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(111,12,12,57,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(112,12,12,62,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(113,12,12,63,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(114,12,12,64,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(115,12,12,74,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(116,12,12,79,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(117,12,12,82,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(118,12,12,76,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(119,12,12,88,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL);
INSERT INTO `balance_asiento_modelo_detail` VALUES (120,12,12,89,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(121,12,12,369,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(122,12,12,91,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(123,12,12,93,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(124,12,12,383,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(125,12,12,381,NULL,0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(126,13,20,359,NULL,0.00,'2025-04-17 09:03:37','2025-04-17 09:03:37',NULL),(127,13,20,13,NULL,0.00,'2025-04-17 09:03:37','2025-04-17 09:03:37',NULL),(128,13,20,1029,NULL,0.00,'2025-04-17 09:03:37','2025-04-17 09:03:37',NULL),(129,14,21,57,NULL,0.00,'2025-05-08 10:43:28','2025-05-08 10:43:28',NULL),(130,14,21,359,NULL,0.00,'2025-05-08 10:43:28','2025-05-08 10:43:28',NULL),(131,15,21,359,NULL,0.00,'2025-05-08 10:55:51','2025-05-08 10:55:51',NULL),(132,15,21,5,NULL,0.00,'2025-05-08 10:55:51','2025-05-08 10:55:51',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,7489,5,2,NULL,0.00,'2023-09-09 11:38:09','2023-09-09 11:51:38','2023-09-09 11:51:38'),(4,7489,5,2,'Liquidacion mensual',0.00,'2023-09-09 11:58:06','2023-09-09 11:58:06',NULL),(5,7489,16,2,'Liquidacion mensual',0.00,'2023-09-11 08:25:51','2023-09-11 08:25:51',NULL),(6,7489,15,2,'Liquidacion mensual',0.00,'2023-09-11 08:30:07','2023-09-11 08:30:07',NULL),(7,7489,1,2,'Liquidacion mensual',0.00,'2023-09-11 10:12:13','2023-09-11 10:12:13',NULL),(8,7489,1,2,'Pago mensual',0.00,'2023-09-12 10:22:28','2023-09-12 10:22:28',NULL),(9,7489,21,2,NULL,0.00,'2023-09-13 09:36:34','2023-09-13 09:36:34',NULL),(10,7489,21,2,NULL,0.00,'2023-09-13 09:37:11','2023-09-13 09:37:11',NULL),(11,7489,17,2,'Asiento de cierre',0.00,'2024-06-10 10:47:47','2024-06-10 10:47:47',NULL),(12,7489,12,2,'Asiento de Apertura',0.00,'2025-02-27 10:12:32','2025-02-27 10:12:32',NULL),(13,7489,20,2,'Cobranzas del mes',0.00,'2025-04-17 09:03:37','2025-04-17 09:03:37',NULL),(14,7489,21,2,'Pagos a Proveedores',0.00,'2025-05-08 10:43:28','2025-05-08 10:43:28',NULL),(15,7489,21,2,'Pagos a Proveedores',0.00,'2025-05-08 10:55:51','2025-05-08 10:55:51',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8505 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7489,40724,7769,1,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-07-31',NULL,1776967.79,NULL,NULL,1,'2022-09-02 10:33:50','2022-09-02 10:33:50',NULL),(2,7489,40724,7770,1,2,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-08-31',NULL,2469881.92,NULL,NULL,1,'2022-10-03 10:14:24','2022-10-03 10:14:24',NULL),(3,7489,40725,9346,1,3,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-09-30',NULL,33897.84,NULL,NULL,1,'2022-10-03 12:39:33','2022-10-03 12:41:08','2022-10-03 12:41:08'),(4,7489,40725,9345,1,4,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-08-31',NULL,303655.22,NULL,NULL,1,'2022-10-03 15:13:18','2022-10-03 15:13:18',NULL),(5,7489,40726,10897,1,5,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-08-31',NULL,164293.59,NULL,NULL,1,'2022-10-06 07:43:36','2022-10-06 07:43:36',NULL),(6,7489,40724,7771,1,6,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-09-30',NULL,2580147.50,NULL,NULL,1,'2022-11-02 11:15:53','2022-11-02 11:15:53',NULL),(7,7489,40725,9346,1,7,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-09-30',NULL,269768.98,NULL,NULL,1,'2022-11-03 15:40:12','2022-11-03 15:40:12',NULL),(8,7489,40727,12515,1,8,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-09-30',NULL,83336.66,NULL,NULL,1,'2022-11-04 07:40:40','2022-11-04 07:40:40',NULL),(9,7489,40728,14240,1,9,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-09-30',NULL,311609.21,NULL,NULL,1,'2022-11-16 18:14:48','2022-11-16 18:14:48',NULL),(10,7489,40726,10898,1,10,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-09-30',NULL,159475.42,NULL,NULL,1,'2022-12-01 15:52:47','2022-12-01 15:52:47',NULL),(11,7489,40726,10899,1,11,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,146821.94,NULL,NULL,1,'2022-12-01 15:53:29','2022-12-01 15:53:29',NULL),(12,7489,40724,7772,1,12,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,2833635.55,NULL,NULL,1,'2022-12-02 07:41:17','2022-12-02 07:41:17',NULL),(13,7489,40728,14241,1,13,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,355814.68,NULL,NULL,1,'2022-12-08 09:50:16','2022-12-08 09:50:16',NULL),(14,7489,40725,9347,1,14,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,254921.07,NULL,NULL,1,'2022-12-08 11:54:59','2022-12-08 11:54:59',NULL),(15,7489,40727,12516,1,15,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,87256.43,NULL,NULL,1,'2022-12-12 09:09:17','2022-12-12 09:09:17',NULL),(16,7489,40727,12517,1,16,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-11-30',NULL,96479.91,NULL,NULL,1,'2022-12-15 12:36:06','2022-12-15 12:36:06',NULL),(17,7489,40726,10900,1,17,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-11-30',NULL,175952.48,NULL,NULL,1,'2022-12-15 13:00:10','2022-12-15 13:00:10',NULL),(18,7489,40724,7773,1,18,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-11-30',NULL,2854029.20,NULL,NULL,1,'2022-12-26 14:33:31','2022-12-26 14:33:31',NULL),(19,7489,40725,9348,1,19,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-11-30',NULL,254957.18,NULL,NULL,1,'2022-12-28 08:57:54','2022-12-28 08:57:54',NULL),(20,7489,40728,14242,1,20,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-11-30',NULL,367879.59,NULL,NULL,1,'2022-12-29 09:36:15','2022-12-29 09:36:15',NULL),(21,7489,40726,10901,1,21,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-12-31',NULL,823395.60,NULL,NULL,1,'2023-01-31 15:32:29','2023-01-31 15:32:29',NULL);
INSERT INTO `balance_libro` VALUES (22,7489,40725,9349,1,22,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-12-31',NULL,467828.10,NULL,NULL,1,'2023-02-01 08:15:03','2023-02-01 08:15:03',NULL),(23,7489,40724,7774,1,23,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-12-31',NULL,4494447.75,NULL,NULL,1,'2023-02-02 08:08:31','2023-02-02 08:08:31',NULL),(24,7489,40727,12518,1,24,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-12-31',NULL,169969.44,NULL,NULL,1,'2023-02-04 09:03:52','2023-02-04 09:03:52',NULL),(25,7489,40728,14243,1,25,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-12-31',NULL,574699.37,NULL,NULL,1,'2023-02-07 10:42:39','2023-02-07 10:42:39',NULL),(26,7489,40724,7778,1,26,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,2873035.52,NULL,NULL,1,'2023-02-17 07:57:18','2023-02-17 07:57:18',NULL),(27,7489,40727,12522,1,27,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,109535.76,NULL,NULL,1,'2023-02-28 11:09:23','2023-02-28 11:09:23',NULL),(28,7489,40726,10905,1,28,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,163913.21,NULL,NULL,1,'2023-02-28 11:15:27','2023-02-28 11:15:27',NULL),(29,7489,40725,9353,1,29,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,172455.93,NULL,NULL,1,'2023-02-28 11:20:45','2023-02-28 11:20:45',NULL),(30,7489,40728,14247,1,30,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,422662.34,NULL,NULL,1,'2023-03-08 08:57:21','2023-03-08 08:57:21',NULL),(31,7489,40724,7779,1,31,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,4442140.19,NULL,NULL,1,'2023-04-03 12:17:25','2023-04-03 12:17:25',NULL),(32,7489,40725,9354,1,32,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,198416.07,NULL,NULL,1,'2023-04-03 16:06:24','2023-04-03 16:06:24',NULL),(33,7489,40726,10906,1,33,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,235799.07,NULL,NULL,1,'2023-04-04 08:59:40','2023-04-04 08:59:40',NULL),(34,7489,40727,12523,1,34,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,111626.19,NULL,NULL,1,'2023-04-04 09:18:36','2023-04-04 09:18:36',NULL),(35,7489,40728,14248,1,35,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,619173.55,NULL,NULL,1,'2023-04-04 10:19:06','2023-04-04 10:19:06',NULL),(36,7489,40724,7780,1,36,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,3618307.98,NULL,NULL,1,'2023-05-03 08:36:25','2023-05-03 08:36:25',NULL),(37,7489,40727,12524,1,37,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,128422.69,NULL,NULL,1,'2023-05-03 08:55:56','2023-05-03 08:55:56',NULL),(38,7489,40726,10907,1,38,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,123220.54,NULL,NULL,1,'2023-05-03 09:41:17','2023-05-03 09:41:17',NULL),(39,7489,40725,9355,1,39,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,197873.13,NULL,NULL,1,'2023-05-03 12:33:40','2023-05-03 12:33:40',NULL),(40,7489,40728,14249,1,40,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,318310.94,NULL,NULL,1,'2023-05-03 12:38:33','2023-05-03 12:38:33',NULL),(41,7489,40727,12525,1,41,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,133760.34,NULL,NULL,1,'2023-06-02 10:00:12','2023-06-02 10:00:12',NULL),(42,7489,40726,10908,1,42,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,148724.83,NULL,NULL,1,'2023-06-02 10:33:15','2023-06-02 10:33:15',NULL);
INSERT INTO `balance_libro` VALUES (43,7489,40724,7781,1,43,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,3964084.89,NULL,NULL,1,'2023-06-05 08:38:13','2023-06-05 08:38:13',NULL),(44,7489,40725,9356,1,44,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,210163.67,NULL,NULL,1,'2023-06-08 09:00:20','2023-06-08 09:00:20',NULL),(45,7489,40726,10909,1,45,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-05-31',NULL,157447.99,NULL,NULL,1,'2023-07-01 11:27:22','2023-07-01 11:27:22',NULL),(46,7489,40724,7782,1,46,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-05-31',NULL,3947939.35,NULL,NULL,1,'2023-07-03 09:26:44','2023-07-03 09:26:44',NULL),(47,7489,40727,12526,1,47,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-05-31',NULL,284428.21,NULL,NULL,1,'2023-07-03 15:49:49','2023-07-03 15:49:49',NULL),(48,7489,40728,14250,1,48,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,499866.17,NULL,NULL,1,'2023-07-08 08:37:21','2023-07-08 08:37:21',NULL),(49,7489,40728,14251,1,49,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-05-31',NULL,519467.35,NULL,NULL,1,'2023-07-08 08:37:45','2023-07-08 08:37:45',NULL),(50,7489,40725,9357,1,50,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-05-31',NULL,232330.52,NULL,NULL,1,'2023-07-08 10:22:46','2023-07-08 10:22:46',NULL),(51,7489,40726,10910,1,51,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-06-30',NULL,238921.96,NULL,NULL,1,'2023-07-21 09:41:23','2023-07-21 09:41:23',NULL),(52,7489,40724,7783,1,52,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-06-30',NULL,5808044.55,NULL,NULL,1,'2023-08-01 11:41:01','2023-08-01 11:41:01',NULL),(53,7489,40727,12527,1,53,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-06-30',NULL,400319.39,NULL,NULL,1,'2023-08-02 15:17:25','2023-08-02 15:17:25',NULL),(54,7489,40725,9358,1,54,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-06-30',NULL,325917.97,NULL,NULL,1,'2023-08-02 15:40:06','2023-08-02 15:40:06',NULL),(55,7489,40728,14252,1,55,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-06-30',NULL,865149.38,NULL,NULL,1,'2023-08-05 10:38:10','2023-08-05 10:38:10',NULL),(56,7489,40724,7754,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9032166.10,NULL,NULL,1,'2023-08-25 15:16:01','2023-08-25 15:16:01',NULL),(57,7489,40724,7755,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',8671560.01,NULL,NULL,1,'2023-08-25 15:20:17','2023-08-25 15:20:17',NULL),(58,7489,40724,7756,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',8009520.97,NULL,NULL,1,'2023-08-25 15:22:48','2023-08-25 15:22:48',NULL),(59,7489,40724,7757,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',9070028.38,NULL,NULL,1,'2023-08-25 15:24:42','2023-08-25 15:24:42',NULL),(60,7489,40724,7758,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',9568096.09,NULL,NULL,1,'2023-08-25 15:25:57','2023-08-25 15:25:57',NULL),(61,7489,40724,7759,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',14601261.08,NULL,NULL,1,'2023-08-25 15:27:09','2023-08-25 15:27:09',NULL),(62,7489,40724,7763,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',16757730.32,NULL,NULL,1,'2023-08-25 15:28:28','2023-08-25 15:28:28',NULL),(63,7489,40724,7764,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',11392809.67,NULL,NULL,1,'2023-08-25 15:29:48','2023-08-25 15:29:48',NULL);
INSERT INTO `balance_libro` VALUES (64,7489,40724,7765,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',15199786.29,NULL,NULL,1,'2023-08-25 15:30:53','2023-08-25 15:30:53',NULL),(65,7489,40724,7766,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',19357814.98,NULL,NULL,1,'2023-08-25 15:33:44','2023-08-25 15:33:44',NULL),(66,7489,40724,7767,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',19427548.71,NULL,NULL,1,'2023-08-25 15:34:54','2023-08-25 15:34:54',NULL),(67,7489,40724,7768,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',39597592.36,NULL,NULL,1,'2023-08-25 15:35:55','2023-08-25 15:35:55',NULL),(68,7489,40724,7769,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',28840812.18,NULL,NULL,1,'2023-08-25 15:37:22','2023-08-25 15:37:22',NULL),(69,7489,40724,7770,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',27372706.99,NULL,NULL,1,'2023-08-25 15:38:24','2023-08-25 15:38:24',NULL),(70,7489,40724,7771,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',25368265.11,NULL,NULL,1,'2023-08-25 15:40:02','2023-08-25 15:40:02',NULL),(71,7489,40724,7772,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',27266402.10,NULL,NULL,1,'2023-08-25 15:40:56','2023-08-25 15:41:40','2023-08-25 15:41:40'),(72,7489,40724,7772,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',27266402.10,NULL,NULL,1,'2023-08-25 15:41:40','2023-08-25 15:41:40',NULL),(73,7489,40724,7773,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',24349135.12,NULL,NULL,1,'2023-08-25 15:45:46','2023-08-25 15:45:46',NULL),(74,7489,40724,7774,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',31644249.57,NULL,NULL,1,'2023-08-25 15:47:04','2023-08-25 15:47:04',NULL),(75,7489,40724,7778,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',31124623.21,NULL,NULL,1,'2023-08-25 15:58:59','2023-11-11 09:14:19','2023-11-11 09:14:19'),(76,7489,40724,7779,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',29323838.32,NULL,NULL,1,'2023-08-25 16:00:15','2023-11-11 09:55:35','2023-11-11 09:55:35'),(77,7489,40724,7780,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',37377784.72,NULL,NULL,1,'2023-08-25 16:01:16','2023-11-11 09:46:24','2023-11-11 09:46:24'),(78,7489,40724,7781,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',35997285.46,NULL,NULL,1,'2023-08-25 16:02:32','2023-11-11 10:01:51','2023-11-11 10:01:51'),(79,7489,40724,7782,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',38550914.19,NULL,NULL,1,'2023-08-25 16:03:23','2023-11-11 10:45:51','2023-11-11 10:45:51'),(80,7489,40724,7783,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',43887313.97,NULL,NULL,1,'2023-08-25 16:06:40','2023-11-11 10:48:44','2023-11-11 10:48:44'),(81,7489,40724,7754,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10463080.90,NULL,NULL,1,'2023-08-26 12:11:49','2023-08-26 12:11:49',NULL),(82,7489,40724,7755,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',8028634.05,NULL,NULL,1,'2023-08-26 12:13:37','2023-08-26 12:14:01','2023-08-26 12:14:01'),(83,7489,40724,7755,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',8028634.05,NULL,NULL,1,'2023-08-26 12:14:01','2023-08-26 12:14:01',NULL);
INSERT INTO `balance_libro` VALUES (84,7489,40724,7755,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',5050000.00,NULL,NULL,1,'2023-08-26 12:18:44','2023-08-26 12:18:44',NULL),(85,7489,40724,7756,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',9116177.37,NULL,NULL,1,'2023-08-26 12:22:53','2023-08-26 12:22:53',NULL),(86,7489,40724,7757,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',11232246.13,NULL,NULL,1,'2023-08-26 12:24:20','2023-08-26 12:24:51','2023-08-26 12:24:51'),(87,7489,40724,7757,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',11232246.13,NULL,NULL,1,'2023-08-26 12:24:51','2023-08-26 12:24:51',NULL),(88,7489,40724,7758,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',10820996.06,NULL,NULL,1,'2023-08-26 12:29:53','2023-08-26 12:29:53',NULL),(89,7489,40724,7759,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',13741175.65,NULL,NULL,1,'2023-08-26 12:36:02','2023-08-26 12:36:02',NULL),(90,7489,40724,7763,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',18042668.29,NULL,NULL,1,'2023-08-26 12:42:04','2023-08-26 12:42:04',NULL),(91,7489,40724,7764,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',15535616.67,NULL,NULL,1,'2023-08-26 12:45:34','2023-08-28 14:11:42','2023-08-28 14:11:42'),(92,7489,40724,7764,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',15535616.67,NULL,NULL,1,'2023-08-28 14:11:42','2023-08-28 14:11:42',NULL),(93,7489,40724,7765,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',21558348.49,NULL,NULL,1,'2023-08-28 14:17:58','2023-08-28 14:17:58',NULL),(94,7489,40724,7766,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',21745647.59,NULL,NULL,1,'2023-08-28 14:20:27','2023-08-28 14:20:27',NULL),(95,7489,40724,7767,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',32549939.89,NULL,NULL,1,'2023-08-28 14:22:58','2023-08-28 14:22:58',NULL),(96,7489,40724,7768,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',24409006.30,NULL,NULL,1,'2023-08-28 14:25:06','2023-08-28 14:25:06',NULL),(97,7489,40724,7769,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',31857279.75,NULL,NULL,1,'2023-08-28 14:34:06','2023-08-28 14:34:06',NULL),(98,7489,40724,7770,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29077987.64,NULL,NULL,1,'2023-08-28 14:36:49','2023-08-28 14:36:49',NULL),(99,7489,40724,7771,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',27927451.82,NULL,NULL,1,'2023-08-28 14:39:23','2023-08-28 14:39:23',NULL),(100,7489,40724,7772,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',27277611.70,NULL,NULL,1,'2023-08-28 14:41:28','2023-08-28 14:41:28',NULL),(101,7489,40724,7773,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',28092456.10,NULL,NULL,1,'2023-08-28 14:43:27','2023-08-28 14:43:27',NULL),(102,7489,40724,7774,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',40301579.14,NULL,NULL,1,'2023-08-28 14:45:54','2023-08-28 14:45:54',NULL),(103,7489,40724,7778,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',26293641.26,NULL,NULL,1,'2023-08-28 14:47:51','2023-08-28 14:47:51',NULL),(104,7489,40724,7779,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',32533979.48,NULL,NULL,1,'2023-08-28 14:49:38','2023-08-28 14:49:38',NULL);
INSERT INTO `balance_libro` VALUES (105,7489,40724,7779,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',44476071.61,NULL,NULL,1,'2023-08-28 14:51:40','2023-08-28 15:04:00','2023-08-28 15:04:00'),(106,7489,40724,7781,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',38472105.21,NULL,NULL,1,'2023-08-28 14:53:39','2023-08-28 14:53:39',NULL),(107,7489,40724,7782,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',39190973.78,NULL,NULL,1,'2023-08-28 14:55:34','2023-08-28 14:55:34',NULL),(108,7489,40724,7783,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',51865673.65,NULL,NULL,1,'2023-08-28 15:03:32','2023-08-28 15:03:32',NULL),(109,7489,40724,7780,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',44476071.61,NULL,NULL,1,'2023-08-28 15:04:00','2023-08-28 15:04:00',NULL),(110,7489,40724,7754,12,110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',43345563.09,NULL,NULL,1,'2023-08-29 10:02:29','2023-08-29 10:02:29',NULL),(111,7489,40726,10911,1,111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-07-31',NULL,198631.68,NULL,NULL,1,'2023-09-01 11:49:23','2023-09-01 11:49:23',NULL),(112,7489,40724,7784,1,112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-07-31',NULL,3961655.81,NULL,NULL,1,'2023-09-02 09:11:43','2023-09-02 09:11:43',NULL),(113,7489,40727,12528,1,113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-07-31',NULL,319812.89,NULL,NULL,1,'2023-09-02 11:11:59','2023-09-02 11:11:59',NULL),(114,7489,40725,9359,1,114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-07-31',NULL,250711.57,NULL,NULL,1,'2023-09-02 11:37:44','2023-09-02 11:37:44',NULL),(115,7489,40728,14253,1,115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-07-31',NULL,684171.98,NULL,NULL,1,'2023-09-08 11:04:20','2023-09-08 11:04:20',NULL),(116,7489,40724,7754,20,55,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,55,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9032166.10,NULL,NULL,1,'2023-09-09 09:33:09','2023-09-09 09:45:25','2023-09-09 09:45:25'),(117,7489,40724,7755,20,56,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,56,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',8671560.01,NULL,NULL,1,'2023-09-09 09:35:52','2023-09-09 09:45:34','2023-09-09 09:45:34'),(118,7489,40724,7755,20,57,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,57,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',8009520.97,NULL,NULL,1,'2023-09-09 09:38:17','2023-09-09 09:45:28','2023-09-09 09:45:28'),(119,7489,40724,7757,20,58,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,58,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',9070028.38,NULL,NULL,1,'2023-09-09 09:39:34','2023-09-09 09:45:31','2023-09-09 09:45:31'),(120,7489,40724,7758,20,59,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,59,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',9568096.09,NULL,NULL,1,'2023-09-09 09:40:56','2023-09-09 09:45:36','2023-09-09 09:45:36'),(121,7489,40724,7759,20,60,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,60,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',14601261.08,NULL,NULL,1,'2023-09-09 09:44:48','2023-09-09 09:45:51','2023-09-09 09:45:51'),(122,7489,40724,7754,20,61,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,61,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9032166.10,NULL,NULL,1,'2023-09-09 09:49:20','2023-09-09 09:49:20',NULL),(123,7489,40724,7755,20,62,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,62,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',8671560.01,NULL,NULL,1,'2023-09-09 09:58:11','2023-09-09 09:58:11',NULL),(124,7489,40724,7756,20,63,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,63,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',8009520.97,NULL,NULL,1,'2023-09-09 10:01:05','2023-09-09 10:01:05',NULL);
INSERT INTO `balance_libro` VALUES (125,7489,40724,7757,20,64,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,64,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',9070028.38,NULL,NULL,1,'2023-09-09 10:02:57','2023-09-09 10:02:57',NULL),(126,7489,40724,7758,20,65,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,65,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',9568096.09,NULL,NULL,1,'2023-09-09 10:05:09','2023-09-09 10:05:09',NULL),(127,7489,40724,7759,20,66,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,66,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',14601261.08,NULL,NULL,1,'2023-09-09 10:06:53','2023-09-09 10:06:53',NULL),(128,7489,40724,7763,20,67,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,67,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',16757730.32,NULL,NULL,1,'2023-09-09 10:09:07','2023-09-09 10:09:07',NULL),(129,7489,40724,7764,20,68,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,68,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',11392809.67,NULL,NULL,1,'2023-09-09 10:10:53','2023-09-09 10:10:53',NULL),(130,7489,40724,7750,20,69,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,69,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',18415865.87,NULL,NULL,1,'2023-09-09 10:18:14','2023-09-11 11:58:39','2023-09-11 11:58:39'),(131,7489,40724,7766,20,70,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,70,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',21923396.78,NULL,NULL,1,'2023-09-09 10:21:03','2023-09-09 10:21:03',NULL),(132,7489,40724,7767,20,71,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,71,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',22724666.99,NULL,NULL,1,'2023-09-09 10:23:33','2023-09-09 10:23:33',NULL),(133,7489,40724,7768,20,72,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,72,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',30518812.70,NULL,NULL,1,'2023-09-09 10:26:01','2023-09-09 10:26:01',NULL),(134,7489,40724,7754,21,73,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,73,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10463080.90,NULL,NULL,1,'2023-09-09 10:29:09','2023-09-09 10:29:09',NULL),(135,7489,40724,7755,21,74,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,74,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',8028634.05,NULL,NULL,1,'2023-09-09 10:30:55','2023-09-09 10:30:55',NULL),(136,7489,40724,7756,21,75,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,75,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',9116177.37,NULL,NULL,1,'2023-09-09 10:32:10','2023-09-09 10:32:10',NULL),(137,7489,40724,7757,21,76,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,76,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',11232246.13,NULL,NULL,1,'2023-09-09 10:33:41','2023-09-09 10:33:41',NULL),(138,7489,40724,7758,21,77,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,77,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',10820996.06,NULL,NULL,1,'2023-09-09 10:34:47','2023-09-09 10:34:47',NULL),(139,7489,40724,7759,21,78,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,78,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',13741175.65,NULL,NULL,1,'2023-09-09 10:36:01','2023-09-09 10:36:01',NULL),(140,7489,40724,7763,21,79,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,79,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',18042668.29,NULL,NULL,1,'2023-09-09 10:38:17','2023-09-09 10:38:17',NULL),(141,7489,40724,7764,21,80,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,80,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',15535616.67,NULL,NULL,1,'2023-09-09 10:39:23','2023-09-09 10:39:23',NULL),(142,7489,40724,7765,21,81,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,81,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',21558348.49,NULL,NULL,1,'2023-09-09 10:40:39','2023-09-09 10:40:39',NULL),(143,7489,40724,7766,21,82,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,82,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',21745647.59,NULL,NULL,1,'2023-09-09 10:41:51','2023-09-09 10:41:51',NULL),(144,7489,40724,7767,21,83,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,83,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',32549939.89,NULL,NULL,1,'2023-09-09 10:43:08','2023-09-09 10:43:08',NULL);
INSERT INTO `balance_libro` VALUES (145,7489,40724,7768,21,84,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,84,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',20271218.77,NULL,NULL,1,'2023-09-09 10:44:17','2023-09-09 10:44:17',NULL),(146,7489,40724,7754,5,146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1104518.60,'Liquidacion mensual',NULL,1,'2023-09-09 12:00:08','2023-09-09 12:38:36','2023-09-09 12:38:36'),(147,7489,40724,7755,5,147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',917796.65,'Liquidacion mensual',NULL,1,'2023-09-09 12:01:44','2023-09-09 12:01:44',NULL),(148,7489,40724,7756,5,148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',729186.12,'Liquidacion mensual',NULL,1,'2023-09-09 12:03:08','2023-09-09 12:03:08',NULL),(149,7489,40724,7757,5,149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',933357.82,'Liquidacion mensual',NULL,1,'2023-09-09 12:06:58','2023-09-09 12:06:58',NULL),(150,7489,40724,7758,5,150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',949648.83,'Liquidacion mensual',NULL,1,'2023-09-09 12:09:05','2023-09-09 12:09:05',NULL),(151,7489,40724,7759,5,151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1334382.39,'Liquidacion mensual',NULL,1,'2023-09-09 12:12:18','2023-09-09 12:39:54','2023-09-09 12:39:54'),(152,7489,40724,7763,5,152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1553042.40,'Liquidacion mensual',NULL,1,'2023-09-09 12:16:04','2023-09-09 12:16:04',NULL),(153,7489,40724,7763,21,85,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,85,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',215362.00,NULL,NULL,1,'2023-09-09 12:22:16','2023-09-09 12:22:16',NULL),(154,7489,40724,7764,5,154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',859286.47,'Liquidacion mensual',NULL,1,'2023-09-09 12:28:23','2023-09-11 10:40:53','2023-09-11 10:40:53'),(155,7489,40724,7765,5,155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1505853.03,'Liquidacion mensual',NULL,1,'2023-09-09 12:31:42','2023-09-09 12:31:42',NULL),(156,7489,40724,7766,5,156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1389465.98,'Liquidacion mensual',NULL,1,'2023-09-09 12:33:39','2023-09-09 12:33:39',NULL),(157,7489,40724,7767,5,157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1888206.14,'Liquidacion mensual',NULL,1,'2023-09-09 12:35:12','2023-09-09 12:35:12',NULL),(158,7489,40724,7768,5,158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2272200.81,'Liquidacion mensual',NULL,1,'2023-09-09 12:36:45','2023-09-11 12:36:54','2023-09-11 12:36:54'),(159,7489,40724,7754,5,159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1104518.60,'Liquidacion mensual',NULL,1,'2023-09-09 12:38:36','2023-09-09 12:38:36',NULL),(160,7489,40724,7759,5,160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1334382.39,'Liquidacion mensual',NULL,1,'2023-09-09 12:39:54','2023-09-11 12:23:52','2023-09-11 12:23:52'),(161,7489,40724,7754,16,161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',229357.83,'Liquidacion mensual',NULL,1,'2023-09-11 08:31:29','2023-09-11 08:31:29',NULL),(162,7489,40724,7755,16,162,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',221339.28,'Liquidacion mensual',NULL,1,'2023-09-11 08:32:28','2023-09-11 08:32:28',NULL);
INSERT INTO `balance_libro` VALUES (163,7489,40724,7756,16,163,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',204462.23,'Liquidacion mensual',NULL,1,'2023-09-11 08:33:15','2023-09-11 08:33:15',NULL),(164,7489,40724,7757,16,164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',232217.76,'Liquidacion mensual',NULL,1,'2023-09-11 08:34:00','2023-09-11 08:34:00',NULL),(165,7489,40724,7758,16,165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',268784.51,'Liquidacion mensual',NULL,1,'2023-09-11 08:34:42','2023-09-11 08:34:42',NULL),(166,7489,40724,7759,16,166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',408463.76,'Liquidacion mensual',NULL,1,'2023-09-11 08:35:28','2023-09-11 08:35:28',NULL),(167,7489,40724,7763,16,167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',499853.33,'Liquidacion mensual',NULL,1,'2023-09-11 08:36:10','2023-09-11 08:36:10',NULL),(168,7489,40724,7764,16,168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',651760.73,'Liquidacion mensual',NULL,1,'2023-09-11 08:36:59','2023-09-11 08:36:59',NULL),(169,7489,40724,7765,16,169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',936330.57,'Liquidacion mensual',NULL,1,'2023-09-11 08:38:29','2023-09-11 08:38:29',NULL),(170,7489,40724,7766,16,170,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',647855.17,'Liquidacion mensual',NULL,1,'2023-09-11 08:39:13','2023-09-11 08:39:13',NULL),(171,7489,40724,7767,16,171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1418860.82,'Liquidacion mensual',NULL,1,'2023-09-11 08:40:03','2023-09-11 08:40:03',NULL),(172,7489,40724,7768,16,172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1461042.11,'Liquidacion mensual',NULL,1,'2023-09-11 08:40:40','2023-09-11 08:40:40',NULL),(173,7489,40724,7754,15,173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1452468.42,'Liquidacion mensual',NULL,1,'2023-09-11 08:41:53','2023-09-11 15:17:27','2023-09-11 15:17:27'),(174,7489,40724,7755,15,174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1486319.74,'Liquidacion mensual',NULL,1,'2023-09-11 08:42:37','2023-09-11 08:42:37',NULL),(175,7489,40724,7756,15,175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1226773.78,'Liquidacion mensual',NULL,1,'2023-09-11 08:43:21','2023-09-11 08:43:21',NULL),(176,7489,40724,7757,15,176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1486080.35,'Liquidacion mensual',NULL,1,'2023-09-11 08:44:34','2023-09-11 08:44:34',NULL),(177,7489,40724,7758,15,177,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1612707.68,'Liquidacion mensual',NULL,1,'2023-09-11 08:45:16','2023-09-11 08:45:16',NULL),(178,7489,40724,7759,15,178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2450783.18,'Liquidacion mensual',NULL,1,'2023-09-11 08:46:27','2023-09-12 12:12:45','2023-09-12 12:12:45'),(179,7489,40724,7763,15,179,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2801149.07,'Liquidacion mensual',NULL,1,'2023-09-11 08:47:06','2023-09-11 08:47:06',NULL),(180,7489,40724,7764,15,180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2185122.38,'Liquidacion mensual',NULL,1,'2023-09-11 08:47:40','2023-09-11 08:47:40',NULL);
INSERT INTO `balance_libro` VALUES (181,7489,40724,7765,15,181,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3090356.62,'Liquidacion mensual',NULL,1,'2023-09-11 08:48:21','2023-09-11 08:48:21',NULL),(182,7489,40724,7766,15,182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3260724.75,'Liquidacion mensual',NULL,1,'2023-09-11 08:49:04','2023-09-11 08:49:04',NULL),(183,7489,40724,7767,15,183,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',5333479.61,'Liquidacion mensual',NULL,1,'2023-09-11 08:49:40','2023-09-11 08:49:40',NULL),(184,7489,40724,7768,15,184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4582824.76,'Liquidacion mensual',NULL,1,'2023-09-11 08:50:22','2023-09-11 08:50:22',NULL),(185,7489,40724,7754,1,185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1018863.58,'Liquidacion mensual',NULL,1,'2023-09-11 10:13:25','2023-09-11 10:13:25',NULL),(186,7489,40724,7755,1,186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1086384.90,'Liquidacion mensual',NULL,1,'2023-09-11 10:14:10','2023-09-11 10:14:10',NULL),(187,7489,40724,7756,1,187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1079948.25,'Liquidacion mensual',NULL,1,'2023-09-11 10:15:03','2023-09-11 10:15:03',NULL),(188,7489,40724,7757,1,188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1165469.74,'Liquidacion mensual',NULL,1,'2023-09-11 10:15:51','2023-09-11 10:15:51',NULL),(189,7489,40724,7758,1,189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1174620.66,'Liquidacion mensual',NULL,1,'2023-09-11 10:16:40','2023-09-11 10:16:40',NULL),(190,7489,40724,7759,1,190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1774114.53,'Liquidacion mensual',NULL,1,'2023-09-11 10:17:55','2023-09-11 12:21:23','2023-09-11 12:21:23'),(191,7489,40724,7763,1,191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1177496.54,'Liquidacion mensual',NULL,1,'2023-09-11 10:19:08','2023-09-11 10:19:08',NULL),(192,7489,40724,7764,1,192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1817406.80,'Liquidacion mensual',NULL,1,'2023-09-11 10:19:54','2023-09-11 10:19:54',NULL),(193,7489,40724,7765,1,193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1915002.86,'Liquidacion mensual',NULL,1,'2023-09-11 10:21:17','2023-09-11 10:21:17',NULL),(194,7489,40724,7766,1,194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1899607.76,'Liquidacion mensual',NULL,1,'2023-09-11 10:22:03','2023-09-11 10:22:03',NULL),(195,7489,40724,7767,1,195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2097526.28,'Liquidacion mensual',NULL,1,'2023-09-11 10:23:05','2023-09-11 10:23:05',NULL),(196,7489,40724,7768,1,196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3295734.05,'Liquidacion mensual',NULL,1,'2023-09-11 10:23:49','2023-09-11 10:23:49',NULL),(197,7489,40724,7764,5,197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',964924.47,'Liquidacion mensual',NULL,1,'2023-09-11 10:40:53','2023-09-11 12:21:40','2023-09-11 12:21:40'),(198,7489,40724,7765,20,86,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,86,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',18415865.87,NULL,NULL,1,'2023-09-11 12:01:20','2023-09-11 12:30:12','2023-09-11 12:30:12');
INSERT INTO `balance_libro` VALUES (199,7489,40724,7759,1,199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1774114.53,'Liquidacion mensual',NULL,1,'2023-09-11 12:21:23','2023-09-11 12:21:23',NULL),(200,7489,40724,7764,5,200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',964924.47,'Liquidacion mensual',NULL,1,'2023-09-11 12:21:40','2023-09-11 12:21:40',NULL),(201,7489,40724,7759,5,201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1483014.09,'Liquidacion mensual',NULL,1,'2023-09-11 12:23:52','2023-09-11 12:23:52',NULL),(202,7489,40724,7765,20,87,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,87,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',18415865.87,NULL,NULL,1,'2023-09-11 12:32:42','2023-09-11 12:32:42',NULL),(203,7489,40724,7768,5,203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2272201.31,'Liquidacion mensual',NULL,1,'2023-09-11 12:36:54','2023-09-11 12:36:54',NULL),(204,7489,40724,7754,15,204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1452468.42,'Liquidacion mensual','contabilidad/40719/lfbMLos6w0j9eAPReUoBrtGlRDe4esIIw4tXVPV5.xlsx',1,'2023-09-11 15:17:27','2023-09-11 15:17:27',NULL),(205,7489,40724,7768,11,205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5629160.28,NULL,NULL,1,'2023-09-11 15:24:51','2023-09-12 08:30:20','2023-09-12 08:30:20'),(206,7489,40724,7765,10,206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',662195.12,NULL,NULL,1,'2023-09-11 15:38:17','2023-09-11 15:38:17',NULL),(207,7489,40724,7755,18,207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',4570135.75,NULL,NULL,1,'2023-09-12 08:30:09','2023-09-12 08:30:09',NULL),(208,7489,40724,7768,18,208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5629160.28,NULL,NULL,1,'2023-09-12 08:30:20','2023-09-12 08:30:20',NULL),(209,7489,40724,7763,18,209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',496840.08,NULL,NULL,1,'2023-09-12 08:54:44','2023-09-13 09:01:35','2023-09-13 09:01:35'),(210,7489,40724,7754,1,210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',387762.05,'Pago mensual',NULL,1,'2023-09-12 10:24:28','2023-09-12 10:24:28',NULL),(211,7489,40724,7755,1,211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',152390.17,'Pago mensual',NULL,1,'2023-09-12 10:25:09','2023-09-12 10:25:09',NULL),(212,7489,40724,7756,1,212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',448956.48,'Pago mensual',NULL,1,'2023-09-12 10:25:38','2023-09-12 10:25:38',NULL),(213,7489,40724,7757,1,213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',278061.46,'Pago mensual',NULL,1,'2023-09-12 10:26:18','2023-09-12 10:26:18',NULL),(214,7489,40724,7758,1,214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',290241.40,'Pago mensual',NULL,1,'2023-09-12 10:27:34','2023-09-12 10:27:34',NULL),(215,7489,40724,7759,1,215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',734189.13,'Pago mensual',NULL,1,'2023-09-12 10:28:09','2023-09-12 10:28:09',NULL),(216,7489,40724,7764,1,216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',519817.15,'Pago mensual',NULL,1,'2023-09-12 10:30:09','2023-09-12 10:30:09',NULL),(217,7489,40724,7765,1,217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',337917.35,'Pago mensual',NULL,1,'2023-09-12 10:30:41','2023-09-12 10:30:41',NULL);
INSERT INTO `balance_libro` VALUES (218,7489,40724,7766,1,218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',844961.12,'Pago mensual',NULL,1,'2023-09-12 10:31:46','2023-09-12 10:31:46',NULL),(219,7489,40724,7767,1,219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',708649.16,'Pago mensual',NULL,1,'2023-09-12 10:32:19','2023-09-12 10:32:19',NULL),(220,7489,40724,7768,1,220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1135329.85,'Pago mensual',NULL,1,'2023-09-12 10:34:19','2023-09-12 10:34:19',NULL),(221,7489,40724,7759,15,221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2450783.18,'Liquidacion mensual',NULL,1,'2023-09-12 12:12:45','2023-09-12 12:12:45',NULL),(222,7489,40724,7763,18,222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',534493.77,NULL,NULL,1,'2023-09-13 09:01:35','2023-09-13 09:01:35',NULL),(223,7489,40724,7768,15,223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',373682.79,NULL,NULL,1,'2023-09-13 09:07:57','2023-09-13 09:10:37','2023-09-13 09:10:37'),(224,7489,40724,7768,15,224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',373682.79,NULL,NULL,1,'2023-09-13 09:10:37','2023-09-13 09:17:58','2023-09-13 09:17:58'),(225,7489,40724,7768,15,225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2029765.09,NULL,NULL,1,'2023-09-13 09:17:58','2023-09-13 09:17:58',NULL),(226,7489,40724,7754,21,226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',260205.53,NULL,NULL,1,'2023-09-13 09:31:53','2023-09-13 09:43:58','2023-09-13 09:43:58'),(227,7489,40724,7755,21,227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',32348.98,NULL,NULL,1,'2023-09-13 09:32:36','2023-09-13 09:43:47','2023-09-13 09:43:47'),(228,7489,40724,7756,21,228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',34469.12,NULL,NULL,1,'2023-09-13 09:33:28','2023-09-13 09:43:39','2023-09-13 09:43:39'),(229,7489,40724,7757,21,229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',34267.01,NULL,NULL,1,'2023-09-13 09:34:08','2023-09-13 09:43:31','2023-09-13 09:43:31'),(230,7489,40724,7758,21,230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',36949.84,NULL,NULL,1,'2023-09-13 09:34:48','2023-09-13 09:43:24','2023-09-13 09:43:24'),(231,7489,40724,7759,21,231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',37237.17,NULL,NULL,1,'2023-09-13 09:35:39','2023-09-13 09:43:17','2023-09-13 09:43:17'),(232,7489,40724,7763,21,232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',56061.10,NULL,NULL,1,'2023-09-13 09:38:38','2023-09-13 09:43:10','2023-09-13 09:43:10'),(233,7489,40724,7764,21,233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',37314.93,NULL,NULL,1,'2023-09-13 09:39:50','2023-09-13 09:43:03','2023-09-13 09:43:03'),(234,7489,40724,7765,21,234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',48984.23,NULL,NULL,1,'2023-09-13 09:40:23','2023-09-13 09:42:55','2023-09-13 09:42:55'),(235,7489,40724,7766,21,235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',60610.19,NULL,NULL,1,'2023-09-13 09:40:47','2023-09-13 09:42:42','2023-09-13 09:42:42'),(236,7489,40724,7767,21,236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',60122.38,NULL,NULL,1,'2023-09-13 09:41:13','2023-09-13 09:42:27','2023-09-13 09:42:27');
INSERT INTO `balance_libro` VALUES (237,7489,40724,7768,21,237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',61862.37,NULL,NULL,1,'2023-09-13 09:41:36','2023-09-13 09:42:18','2023-09-13 09:42:18'),(238,7489,40724,7768,21,238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',61862.37,'Pagos sindicato',NULL,1,'2023-09-13 09:42:18','2023-09-13 09:42:34','2023-09-13 09:42:34'),(239,7489,40724,7767,21,239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',60122.38,'Pagos sindicato',NULL,1,'2023-09-13 09:42:27','2023-09-13 09:42:47','2023-09-13 09:42:47'),(240,7489,40724,7768,21,240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',61862.37,'Pagos sindicato',NULL,1,'2023-09-13 09:42:34','2023-09-13 09:42:34',NULL),(241,7489,40724,7766,21,241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',60610.19,'Pagos sindicato',NULL,1,'2023-09-13 09:42:42','2023-09-13 09:42:42',NULL),(242,7489,40724,7767,21,242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',60122.38,'Pagos sindicato',NULL,1,'2023-09-13 09:42:47','2023-09-13 09:42:47',NULL),(243,7489,40724,7765,21,243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',48984.23,'Pagos sindicato',NULL,1,'2023-09-13 09:42:55','2023-09-13 09:42:55',NULL),(244,7489,40724,7764,21,244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',37314.93,'Pagos sindicato',NULL,1,'2023-09-13 09:43:03','2023-09-13 09:43:03',NULL),(245,7489,40724,7763,21,245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',56061.10,'Pagos sindicato',NULL,1,'2023-09-13 09:43:10','2023-09-13 09:43:10',NULL),(246,7489,40724,7759,21,246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',37237.17,'Pagos sindicato',NULL,1,'2023-09-13 09:43:17','2023-09-13 09:43:17',NULL),(247,7489,40724,7758,21,247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',36949.84,'Pagos sindicato',NULL,1,'2023-09-13 09:43:24','2023-09-13 09:43:24',NULL),(248,7489,40724,7757,21,248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',34267.01,'Pagos sindicato',NULL,1,'2023-09-13 09:43:31','2023-09-13 09:43:31',NULL),(249,7489,40724,7756,21,249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',34469.12,'Pagos sindicato',NULL,1,'2023-09-13 09:43:39','2023-09-13 09:43:39',NULL),(250,7489,40724,7755,21,250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',32348.98,'Pagos sindicato',NULL,1,'2023-09-13 09:43:47','2023-09-13 09:43:47',NULL),(251,7489,40724,7754,21,251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',260205.53,'Pagos sindicato',NULL,1,'2023-09-13 09:43:58','2023-09-13 09:43:58',NULL),(252,7489,40724,7768,21,88,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,88,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',9421178.03,NULL,NULL,1,'2023-09-14 15:34:44','2023-09-14 15:34:44',NULL),(253,7489,40724,7756,19,253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1938000.00,'Asignacion Honorarios',NULL,1,'2023-09-14 15:43:49','2023-09-14 15:59:56','2023-09-14 15:59:56'),(254,7489,40724,7756,19,254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1938000.00,'Asignacion Honorarios',NULL,1,'2023-09-14 15:59:56','2023-09-14 15:59:56',NULL),(255,7489,40724,7756,19,255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1938000.00,'Asignacion Honorarios',NULL,1,'2023-09-14 16:01:14','2023-09-14 16:01:14',NULL);
INSERT INTO `balance_libro` VALUES (256,7489,40724,7756,19,256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',154820.74,'liquidacion Impuesto',NULL,1,'2023-09-14 16:02:53','2023-09-20 10:00:20','2023-09-20 10:00:20'),(257,7489,40724,7756,6,257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1643296.09,'liquidacion Impuesto',NULL,1,'2023-09-14 16:06:29','2023-09-14 16:06:29',NULL),(258,7489,40724,7768,4,258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',942136.85,NULL,NULL,1,'2023-09-15 08:27:14','2023-09-15 08:30:33','2023-09-15 08:30:33'),(259,7489,40724,7768,4,259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',942136.85,'Amortizaciones',NULL,1,'2023-09-15 08:30:33','2023-09-15 08:30:33',NULL),(260,7489,40724,7768,11,260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',9307030.14,NULL,NULL,1,'2023-09-16 08:49:13','2023-09-18 10:28:14','2023-09-18 10:28:14'),(261,7489,40724,7768,11,261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',33563679.69,NULL,NULL,1,'2023-09-16 11:18:46','2023-09-20 08:51:55','2023-09-20 08:51:55'),(262,7489,40725,9360,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',86243.00,NULL,NULL,1,'2023-09-16 12:24:07','2023-09-16 12:24:07',NULL),(263,7489,40725,9360,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',99673.00,NULL,NULL,1,'2023-09-16 12:24:07','2023-09-16 12:24:07',NULL),(264,7489,40725,9360,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',107085.00,NULL,NULL,1,'2023-09-16 12:24:07','2023-09-16 12:24:07',NULL),(265,7489,40725,9360,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',2125486.00,NULL,NULL,1,'2023-09-16 12:24:07','2023-09-16 12:24:07',NULL),(266,7489,40725,9360,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',62799.00,NULL,NULL,1,'2023-09-16 12:24:07','2023-09-16 12:24:07',NULL),(267,7489,40725,9360,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',92900.00,NULL,NULL,1,'2023-09-16 12:24:07','2023-09-16 12:24:07',NULL),(268,7489,40725,9360,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',119987.00,NULL,NULL,1,'2023-09-16 12:24:07','2023-09-16 12:24:07',NULL),(269,7489,40725,9360,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',77488.00,NULL,NULL,1,'2023-09-16 12:24:07','2023-09-16 12:24:07',NULL),(270,7489,40725,9360,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',86243.00,NULL,NULL,1,'2023-09-16 12:24:49','2023-09-16 12:27:23','2023-09-16 12:27:23'),(271,7489,40725,9360,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',99673.00,NULL,NULL,1,'2023-09-16 12:24:49','2023-09-16 12:27:32','2023-09-16 12:27:32'),(272,7489,40725,9360,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',107085.00,NULL,NULL,1,'2023-09-16 12:24:49','2023-09-16 12:26:53','2023-09-16 12:26:53'),(273,7489,40725,9360,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',2125486.00,NULL,NULL,1,'2023-09-16 12:24:49','2023-09-16 12:26:42','2023-09-16 12:26:42'),(274,7489,40725,9360,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',62799.00,NULL,NULL,1,'2023-09-16 12:24:49','2023-09-16 12:27:39','2023-09-16 12:27:39'),(275,7489,40725,9360,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',92900.00,NULL,NULL,1,'2023-09-16 12:24:49','2023-09-16 12:27:51','2023-09-16 12:27:51');
INSERT INTO `balance_libro` VALUES (276,7489,40725,9360,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',119987.00,NULL,NULL,1,'2023-09-16 12:24:49','2023-09-16 12:28:00','2023-09-16 12:28:00'),(277,7489,40725,9360,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',77488.00,NULL,NULL,1,'2023-09-16 12:24:49','2023-09-16 12:27:14','2023-09-16 12:27:14'),(278,7489,40725,9360,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',42139.04,NULL,NULL,1,'2023-09-16 12:25:00','2023-09-16 12:27:03','2023-09-16 12:27:03'),(279,7489,40725,9360,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',150.00,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-18 08:35:57','2023-09-18 08:35:57'),(280,7489,40725,9360,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',4590.64,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-18 08:32:54','2023-09-18 08:32:54'),(281,7489,40725,9360,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',23900.00,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-18 08:35:47','2023-09-18 08:35:47'),(282,7489,40725,9360,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',81960.56,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-16 12:25:01',NULL),(283,7489,40725,9360,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',12808.75,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-16 12:26:22','2023-09-16 12:26:22'),(284,7489,40725,9360,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',30885.07,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-16 12:25:01',NULL),(285,7489,40725,9360,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7367.69,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-16 12:25:01',NULL),(286,7489,40725,9360,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',1277.38,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-16 12:26:14','2023-09-16 12:26:14'),(287,7489,40725,9360,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',20000.00,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-16 12:28:24','2023-09-16 12:28:24'),(288,7489,40725,9360,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',132.00,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-16 12:26:08','2023-09-16 12:26:08'),(289,7489,40725,9360,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',3574.52,NULL,NULL,1,'2023-09-16 12:25:01','2023-09-16 12:25:58','2023-09-16 12:25:58'),(290,7489,40725,9360,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',437890.53,NULL,NULL,1,'2023-09-16 12:25:02','2023-09-16 12:25:02',NULL),(291,7489,40725,9360,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',25000.00,NULL,NULL,1,'2023-09-16 12:25:02','2023-09-16 12:25:51','2023-09-16 12:25:51'),(292,7489,40725,9360,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',14359.07,NULL,NULL,1,'2023-09-16 12:25:02','2023-09-16 12:25:02',NULL),(293,7489,40725,9360,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',22493.90,NULL,NULL,1,'2023-09-16 12:25:02','2023-09-16 12:25:02',NULL),(294,7489,40725,9360,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1680.00,NULL,NULL,1,'2023-09-16 12:25:02','2023-09-16 12:25:45','2023-09-16 12:25:45'),(295,7489,40725,9360,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1200.00,NULL,NULL,1,'2023-09-16 12:25:02','2023-09-16 12:25:38','2023-09-16 12:25:38');
INSERT INTO `balance_libro` VALUES (296,7489,40725,9360,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',20000.00,NULL,NULL,1,'2023-09-16 12:28:24','2023-09-16 12:28:24',NULL),(297,7489,40725,9360,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',333083.22,NULL,NULL,1,'2023-09-16 12:35:39','2023-09-16 12:35:39',NULL),(298,7489,40725,9360,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',266466.57,NULL,NULL,1,'2023-09-16 12:36:35','2023-09-16 12:36:35',NULL),(299,7489,40725,9360,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',15466.11,NULL,NULL,1,'2023-09-18 08:23:43','2023-09-18 08:23:43',NULL),(300,7489,40727,12529,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',10000.00,NULL,NULL,1,'2023-09-18 09:00:02','2023-09-18 09:00:02',NULL),(301,7489,40727,12529,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',225810.37,NULL,NULL,1,'2023-09-18 09:00:02','2023-09-18 09:00:02',NULL),(302,7489,40727,12529,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',36781.40,NULL,NULL,1,'2023-09-18 09:00:03','2023-09-18 09:00:03',NULL),(303,7489,40727,12529,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',268207.58,NULL,NULL,1,'2023-09-18 09:00:03','2023-09-18 09:00:03',NULL),(304,7489,40727,12529,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',53346.70,NULL,NULL,1,'2023-09-18 09:00:03','2023-09-18 09:00:03',NULL),(305,7489,40727,12529,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',9647.40,NULL,NULL,1,'2023-09-18 09:00:03','2023-09-18 09:00:03',NULL),(306,7489,40727,12529,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',5760.00,NULL,NULL,1,'2023-09-18 09:00:03','2023-09-18 09:00:03',NULL),(307,7489,40727,12529,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',732573.93,NULL,NULL,1,'2023-09-18 09:00:03','2023-09-18 09:00:03',NULL),(308,7489,40727,12529,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',595936.73,NULL,NULL,1,'2023-09-18 09:00:04','2023-09-18 09:00:04',NULL),(309,7489,40727,12529,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',5500.00,NULL,NULL,1,'2023-09-18 09:00:04','2023-09-18 09:00:04',NULL),(310,7489,40727,12529,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',5500.00,NULL,NULL,1,'2023-09-18 09:00:04','2023-09-18 09:00:04',NULL),(311,7489,40727,12529,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',196552.66,NULL,NULL,1,'2023-09-18 09:00:04','2023-09-18 09:00:04',NULL),(312,7489,40727,12529,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',16191.31,NULL,NULL,1,'2023-09-18 09:00:50','2023-09-18 09:15:10','2023-09-18 09:15:10'),(313,7489,40727,12529,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',193847.49,NULL,NULL,1,'2023-09-18 09:00:50','2023-09-18 09:00:50',NULL),(314,7489,40727,12529,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',63906.23,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:00:51',NULL),(315,7489,40727,12529,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',60532.21,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:00:51',NULL),(316,7489,40727,12529,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',16225.13,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:00:51',NULL);
INSERT INTO `balance_libro` VALUES (317,7489,40727,12529,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',57030.89,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:15:42','2023-09-18 09:15:42'),(318,7489,40727,12529,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',59293.35,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:16:14','2023-09-18 09:16:14'),(319,7489,40727,12529,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',49999.00,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:00:51',NULL),(320,7489,40727,12529,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',1850.35,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:00:51',NULL),(321,7489,40727,12529,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',25198.00,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:17:41','2023-09-18 09:17:41'),(322,7489,40727,12529,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',22999.00,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:00:51',NULL),(323,7489,40727,12529,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',3886.02,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:18:19','2023-09-18 09:18:19'),(324,7489,40727,12529,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',14334.00,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:16:35','2023-09-18 09:16:35'),(325,7489,40727,12529,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7534.66,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:18:43','2023-09-18 09:18:43'),(326,7489,40727,12529,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',17651.21,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:22:28','2023-09-18 09:22:28'),(327,7489,40727,12529,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',42992.21,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:21:52','2023-09-18 09:21:52'),(328,7489,40727,12529,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',3886.02,NULL,NULL,1,'2023-09-18 09:00:51','2023-09-18 09:22:52','2023-09-18 09:22:52'),(329,7489,40727,12529,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',9894.51,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:21:05','2023-09-18 09:21:05'),(330,7489,40727,12529,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',17086.37,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:24:30','2023-09-18 09:24:30'),(331,7489,40727,12529,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',14073.49,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:23:57','2023-09-18 09:23:57'),(332,7489,40727,12529,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',15299.00,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:00:52',NULL),(333,7489,40727,12529,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',23360.01,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:17:05','2023-09-18 09:17:05'),(334,7489,40727,12529,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',11378.36,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:24:57','2023-09-18 09:24:57'),(335,7489,40727,12529,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',195998.60,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:00:52',NULL),(336,7489,40727,12529,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',45500.00,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:17:27','2023-09-18 09:17:27');
INSERT INTO `balance_libro` VALUES (337,7489,40727,12529,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',12046.95,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:00:52',NULL),(338,7489,40727,12529,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',29804.55,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:25:41','2023-09-18 09:25:41'),(339,7489,40727,12529,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',97250.48,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:26:05','2023-09-18 09:26:05'),(340,7489,40727,12529,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',122213.93,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:26:43','2023-09-18 09:26:43'),(341,7489,40727,12529,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',21360.00,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:17:13','2023-09-18 09:17:13'),(342,7489,40727,12529,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',5511.61,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:27:05','2023-09-18 09:27:05'),(343,7489,40727,12529,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',120464.06,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:27:26','2023-09-18 09:27:26'),(344,7489,40727,12529,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',9598.13,NULL,NULL,1,'2023-09-18 09:00:52','2023-09-18 09:00:52',NULL),(345,7489,40727,12529,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',24444.00,NULL,NULL,1,'2023-09-18 09:00:53','2023-09-18 09:16:55','2023-09-18 09:16:55'),(346,7489,40727,12529,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3115.00,NULL,NULL,1,'2023-09-18 09:00:53','2023-09-18 09:16:49','2023-09-18 09:16:49'),(347,7489,40727,12529,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',21000.00,NULL,NULL,1,'2023-09-18 09:00:53','2023-09-18 09:27:40','2023-09-18 09:27:40'),(348,7489,40727,12529,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',12338.41,NULL,NULL,1,'2023-09-18 09:00:53','2023-09-18 09:27:58','2023-09-18 09:27:58'),(349,7489,40727,12529,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4400.04,NULL,NULL,1,'2023-09-18 09:00:53','2023-09-18 09:00:53',NULL),(350,7489,40727,12529,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',15000.00,NULL,NULL,1,'2023-09-18 09:00:53','2023-09-18 09:28:08','2023-09-18 09:28:08'),(351,7489,40727,12529,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',16402.62,NULL,NULL,1,'2023-09-18 09:15:10','2023-09-18 09:15:10',NULL),(352,7489,40727,12529,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',57775.18,NULL,NULL,1,'2023-09-18 09:15:42','2023-09-18 09:15:42',NULL),(353,7489,40727,12529,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',60067.16,NULL,NULL,1,'2023-09-18 09:16:14','2023-09-18 09:16:14',NULL),(354,7489,40727,12529,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',3936.73,NULL,NULL,1,'2023-09-18 09:18:19','2023-09-18 09:18:19',NULL),(355,7489,40727,12529,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7632.99,NULL,NULL,1,'2023-09-18 09:18:43','2023-09-18 09:18:43',NULL),(356,7489,40727,12529,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10023.64,NULL,NULL,1,'2023-09-18 09:21:05','2023-09-18 09:23:17','2023-09-18 09:23:17');
INSERT INTO `balance_libro` VALUES (357,7489,40727,12529,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',43553.28,NULL,NULL,1,'2023-09-18 09:21:52','2023-09-18 09:21:52',NULL),(358,7489,40727,12529,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',17881.57,NULL,NULL,1,'2023-09-18 09:22:28','2023-09-18 09:22:28',NULL),(359,7489,40727,12529,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',3936.73,NULL,NULL,1,'2023-09-18 09:22:52','2023-09-18 09:22:52',NULL),(360,7489,40727,12529,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',10023.64,NULL,NULL,1,'2023-09-18 09:23:17','2023-09-18 09:23:17',NULL),(361,7489,40727,12529,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',14413.98,NULL,NULL,1,'2023-09-18 09:23:57','2023-09-18 09:23:57',NULL),(362,7489,40727,12529,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',17499.75,NULL,NULL,1,'2023-09-18 09:24:30','2023-09-18 09:24:30',NULL),(363,7489,40727,12529,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',11961.72,NULL,NULL,1,'2023-09-18 09:24:57','2023-09-18 09:24:57',NULL),(364,7489,40727,12529,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',30193.52,NULL,NULL,1,'2023-09-18 09:25:41','2023-09-18 09:25:41',NULL),(365,7489,40727,12529,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',98519.65,NULL,NULL,1,'2023-09-18 09:26:05','2023-09-18 09:26:05',NULL),(366,7489,40727,12529,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',123808.89,NULL,NULL,1,'2023-09-18 09:26:43','2023-09-18 09:26:43',NULL),(367,7489,40727,12529,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',5583.54,NULL,NULL,1,'2023-09-18 09:27:05','2023-09-18 09:27:05',NULL),(368,7489,40727,12529,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',122036.18,NULL,NULL,1,'2023-09-18 09:27:26','2023-09-18 09:27:26',NULL),(369,7489,40727,12529,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',21000.00,NULL,NULL,1,'2023-09-18 09:27:40','2023-09-18 09:27:40',NULL),(370,7489,40727,12529,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',12629.87,NULL,NULL,1,'2023-09-18 09:27:58','2023-09-18 09:27:58',NULL),(371,7489,40727,12529,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',15000.00,NULL,NULL,1,'2023-09-18 09:28:08','2023-09-18 09:28:08',NULL),(372,7489,40724,7768,11,372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6633143.18,NULL,NULL,1,'2023-09-18 10:28:14','2023-09-18 10:28:14',NULL),(373,7489,40728,14254,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',17020.03,NULL,NULL,1,'2023-09-18 10:33:52','2023-09-18 14:32:52','2023-09-18 14:32:52'),(374,7489,40728,14254,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',11360.00,NULL,NULL,1,'2023-09-18 10:33:52','2023-09-18 14:33:06','2023-09-18 14:33:06'),(375,7489,40728,14254,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',2990.03,NULL,NULL,1,'2023-09-18 10:33:52','2023-09-18 14:32:38','2023-09-18 14:32:38'),(376,7489,40728,14254,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',2000.01,NULL,NULL,1,'2023-09-18 10:33:52','2023-09-18 14:32:28','2023-09-18 14:32:28');
INSERT INTO `balance_libro` VALUES (377,7489,40728,14254,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',500.02,NULL,NULL,1,'2023-09-18 10:33:52','2023-09-18 14:32:16','2023-09-18 14:32:16'),(378,7489,40728,14254,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',77307.38,NULL,NULL,1,'2023-09-18 14:30:07','2023-09-18 14:30:07',NULL),(379,7489,40728,14254,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',162637.89,NULL,NULL,1,'2023-09-18 14:30:07','2023-09-18 14:30:07',NULL),(380,7489,40728,14254,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',119531.18,NULL,NULL,1,'2023-09-18 14:30:07','2023-09-18 14:30:07',NULL),(381,7489,40728,14254,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',189484.94,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(382,7489,40728,14254,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',74996.00,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(383,7489,40728,14254,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',159173.06,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(384,7489,40728,14254,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',96448.68,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(385,7489,40728,14254,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',176618.45,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(386,7489,40728,14254,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',83603.56,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(387,7489,40728,14254,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',190559.25,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(388,7489,40728,14254,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',127431.00,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(389,7489,40728,14254,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',280679.45,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(390,7489,40728,14254,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',173910.43,NULL,NULL,1,'2023-09-18 14:30:08','2023-09-18 14:30:08',NULL),(391,7489,40728,14254,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',133944.36,NULL,NULL,1,'2023-09-18 14:30:09','2023-09-18 14:30:09',NULL),(392,7489,40728,14254,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',27836.01,NULL,NULL,1,'2023-09-18 14:30:09','2023-09-18 14:30:09',NULL),(393,7489,40728,14254,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',190200.77,NULL,NULL,1,'2023-09-18 14:30:09','2023-09-18 14:30:09',NULL),(394,7489,40728,14254,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',130294.00,NULL,NULL,1,'2023-09-18 14:30:09','2023-09-18 14:30:09',NULL),(395,7489,40728,14254,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',116784.99,NULL,NULL,1,'2023-09-18 14:30:09','2023-09-18 14:30:09',NULL),(396,7489,40728,14254,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',139688.12,NULL,NULL,1,'2023-09-18 14:30:09','2023-09-18 14:30:09',NULL),(397,7489,40728,14254,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',165726.33,NULL,NULL,1,'2023-09-18 14:30:09','2023-09-18 14:30:09',NULL);
INSERT INTO `balance_libro` VALUES (398,7489,40728,14254,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',299358.96,NULL,NULL,1,'2023-09-18 14:30:09','2023-09-18 14:30:09',NULL),(399,7489,40728,14254,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',132093.97,NULL,NULL,1,'2023-09-18 14:30:10','2023-09-18 14:30:10',NULL),(400,7489,40728,14254,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',89853.00,NULL,NULL,1,'2023-09-18 14:30:10','2023-09-18 14:30:10',NULL),(401,7489,40728,14254,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',146144.83,NULL,NULL,1,'2023-09-18 14:30:10','2023-09-18 14:30:10',NULL),(402,7489,40728,14254,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',58329.74,NULL,NULL,1,'2023-09-18 14:30:10','2023-09-18 14:30:10',NULL),(403,7489,40728,14254,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',184146.74,NULL,NULL,1,'2023-09-18 14:30:10','2023-09-18 14:30:10',NULL),(404,7489,40728,14254,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',5826729.24,NULL,NULL,1,'2023-09-18 14:48:48','2023-09-18 14:48:48',NULL),(405,7489,40728,14254,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',47712.83,NULL,NULL,1,'2023-09-18 14:49:59','2023-09-18 14:49:59',NULL),(406,7489,40728,14254,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',837639.05,NULL,NULL,1,'2023-09-18 14:52:41','2023-09-18 14:52:41',NULL),(407,7489,40724,7757,21,407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',400000.00,NULL,NULL,1,'2023-09-19 09:30:31','2023-09-19 10:15:05','2023-09-19 10:15:05'),(408,7489,40724,7759,21,408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',400000.00,NULL,NULL,1,'2023-09-19 09:31:33','2023-09-19 10:15:29','2023-09-19 10:15:29'),(409,7489,40724,7764,21,409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',400000.00,NULL,NULL,1,'2023-09-19 09:32:58','2023-09-19 09:32:58',NULL),(410,7489,40724,7766,21,410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',200000.00,NULL,NULL,1,'2023-09-19 09:33:54','2023-09-20 09:18:46','2023-09-20 09:18:46'),(411,7489,40724,7754,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1970216.84,NULL,NULL,1,'2023-09-19 10:01:33','2023-09-19 10:01:33',NULL),(412,7489,40724,7755,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2404342.18,NULL,NULL,1,'2023-09-19 10:02:15','2023-09-19 10:09:19','2023-09-19 10:09:19'),(413,7489,40724,7756,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2653584.46,NULL,NULL,1,'2023-09-19 10:03:05','2023-09-19 10:03:05',NULL),(414,7489,40724,7757,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',3220627.98,NULL,NULL,1,'2023-09-19 10:03:40','2023-09-19 10:03:40',NULL),(415,7489,40724,7758,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3435183.92,NULL,NULL,1,'2023-09-19 10:04:14','2023-09-19 10:04:14',NULL),(416,7489,40724,7759,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3302031.22,NULL,NULL,1,'2023-09-19 10:04:44','2023-09-19 10:04:44',NULL),(417,7489,40724,7763,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3426976.84,NULL,NULL,1,'2023-09-19 10:05:30','2023-09-19 10:05:30',NULL);
INSERT INTO `balance_libro` VALUES (418,7489,40724,7764,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',6626150.28,NULL,NULL,1,'2023-09-19 10:05:58','2023-09-19 10:05:58',NULL),(419,7489,40724,7765,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',8049758.82,NULL,NULL,1,'2023-09-19 10:06:39','2023-09-19 10:06:39',NULL),(420,7489,40724,7766,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',7254142.48,NULL,NULL,1,'2023-09-19 10:07:24','2023-09-19 10:07:24',NULL),(421,7489,40724,7767,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6645975.48,NULL,NULL,1,'2023-09-19 10:07:47','2023-09-19 10:07:47',NULL),(422,7489,40724,7768,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1011009.50,NULL,NULL,1,'2023-09-19 10:08:11','2023-09-19 10:08:11',NULL),(423,7489,40724,7755,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2404342.18,NULL,NULL,1,'2023-09-19 10:09:19','2023-09-19 10:09:19',NULL),(424,7489,40724,7757,21,424,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',400000.00,NULL,NULL,1,'2023-09-19 10:15:05','2023-09-19 10:15:05',NULL),(425,7489,40724,7759,21,425,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',400000.00,NULL,NULL,1,'2023-09-19 10:15:29','2023-09-19 10:15:29',NULL),(426,7489,40724,7754,20,246,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,246,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1970216.84,NULL,NULL,1,'2023-09-19 11:52:48','2023-09-19 11:52:48',NULL),(427,7489,40724,7755,20,247,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,247,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2404342.18,NULL,NULL,1,'2023-09-19 11:53:44','2023-09-19 11:53:44',NULL),(428,7489,40724,7756,20,248,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,248,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2653584.46,NULL,NULL,1,'2023-09-19 11:54:45','2023-09-19 11:54:45',NULL),(429,7489,40724,7757,20,249,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,249,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',3220627.98,NULL,NULL,1,'2023-09-19 11:55:36','2023-09-19 11:55:36',NULL),(430,7489,40724,7758,20,250,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,250,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3435183.92,NULL,NULL,1,'2023-09-19 11:57:21','2023-09-19 11:57:21',NULL),(431,7489,40724,7759,20,251,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,251,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3302031.22,NULL,NULL,1,'2023-09-19 11:58:06','2023-09-19 11:58:06',NULL),(432,7489,40724,7763,20,252,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,252,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3426976.84,NULL,NULL,1,'2023-09-19 11:59:31','2023-09-19 11:59:31',NULL),(433,7489,40724,7764,20,253,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,253,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',6626150.28,NULL,NULL,1,'2023-09-19 12:00:19','2023-09-19 12:00:19',NULL),(434,7489,40724,7765,20,254,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,254,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',8049758.82,NULL,NULL,1,'2023-09-19 12:01:15','2023-09-19 12:01:15',NULL),(435,7489,40724,7766,20,255,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,255,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',7254142.48,NULL,NULL,1,'2023-09-19 12:11:53','2023-09-19 12:11:53',NULL),(436,7489,40724,7767,20,256,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,256,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6645975.48,NULL,NULL,1,'2023-09-19 12:14:53','2023-09-19 12:14:53',NULL),(437,7489,40724,7768,20,257,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,257,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1011009.50,NULL,NULL,1,'2023-09-19 12:15:41','2023-09-19 12:15:41',NULL);
INSERT INTO `balance_libro` VALUES (438,7489,40724,7756,6,438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1643296.09,NULL,NULL,1,'2023-09-20 08:24:43','2023-09-20 08:25:11','2023-09-20 08:25:11'),(439,7489,40724,7756,18,439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1643296.09,NULL,NULL,1,'2023-09-20 08:25:11','2023-09-20 08:25:11',NULL),(440,7489,40724,7768,11,440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',128746894.91,NULL,NULL,1,'2023-09-20 08:51:55','2023-09-20 08:52:16','2023-09-20 08:52:16'),(441,7489,40724,7768,11,441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',128746894.91,'Costo mercaderias vendidas',NULL,1,'2023-09-20 08:52:16','2023-09-20 09:02:38','2023-09-20 09:02:38'),(442,7489,40724,7768,11,442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',126746894.91,'Costo mercaderias vendidas',NULL,1,'2023-09-20 09:02:38','2023-09-20 09:02:38',NULL),(443,7489,40724,7756,19,443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',154820.74,'liquidacion Impuesto',NULL,1,'2023-09-20 09:15:20','2023-09-20 09:15:20',NULL),(444,7489,40724,7766,21,444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',190000.00,NULL,NULL,1,'2023-09-20 09:18:46','2023-09-20 10:01:21','2023-09-20 10:01:21'),(445,7489,40724,7766,21,445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',200000.00,NULL,NULL,1,'2023-09-20 10:01:21','2023-09-20 10:01:21',NULL),(446,7489,40799,17251,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',31460.00,NULL,NULL,1,'2023-09-20 10:32:46','2023-09-20 10:32:46',NULL),(447,7489,40799,17251,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',56628.00,NULL,NULL,1,'2023-09-20 10:32:46','2023-09-20 10:32:46',NULL),(448,7489,40799,17251,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',90821.91,NULL,NULL,1,'2023-09-20 10:33:03','2023-09-20 10:37:11','2023-09-20 10:37:11'),(449,7489,40799,17251,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',8723.97,NULL,NULL,1,'2023-09-20 10:33:03','2023-09-20 10:44:20','2023-09-20 10:44:20'),(450,7489,40799,17251,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',8732.75,NULL,NULL,1,'2023-09-20 10:33:03','2023-09-20 10:34:57','2023-09-20 10:34:57'),(451,7489,40799,17251,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',3675.04,NULL,NULL,1,'2023-09-20 10:33:03','2023-09-20 10:43:42','2023-09-20 10:43:42'),(452,7489,40799,17251,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',69970.40,NULL,NULL,1,'2023-09-20 10:33:03','2023-09-20 10:35:58','2023-09-20 10:35:58'),(453,7489,40799,17251,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',16387.40,NULL,NULL,1,'2023-09-20 10:33:03','2023-09-20 10:43:12','2023-09-20 10:43:12'),(454,7489,40799,17251,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',58699.52,NULL,NULL,1,'2023-09-20 10:33:03','2023-09-20 10:42:51','2023-09-20 10:42:51'),(455,7489,40799,17251,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',58699.52,NULL,NULL,1,'2023-09-20 10:33:03','2023-09-20 10:42:36','2023-09-20 10:42:36'),(456,7489,40799,17251,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',9000.00,NULL,NULL,1,'2023-09-20 10:33:03','2023-09-20 10:42:16','2023-09-20 10:42:16');
INSERT INTO `balance_libro` VALUES (457,7489,40799,17251,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',8732.75,NULL,NULL,1,'2023-09-20 10:34:57','2023-09-20 10:44:04','2023-09-20 10:44:04'),(458,7489,40799,17251,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',69970.40,NULL,NULL,1,'2023-09-20 10:35:58','2023-09-20 10:43:24','2023-09-20 10:43:24'),(459,7489,40799,17251,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',90821.91,NULL,NULL,1,'2023-09-20 10:37:11','2023-09-20 10:44:41','2023-09-20 10:44:41'),(460,7489,40799,17251,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',9000.00,NULL,NULL,1,'2023-09-20 10:42:16','2023-09-20 10:42:16',NULL),(461,7489,40799,17251,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',58699.52,NULL,NULL,1,'2023-09-20 10:42:36','2023-09-20 10:42:36',NULL),(462,7489,40799,17251,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',58699.52,NULL,NULL,1,'2023-09-20 10:42:51','2023-09-20 10:42:51',NULL),(463,7489,40799,17251,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',16387.40,NULL,NULL,1,'2023-09-20 10:43:12','2023-09-20 10:43:12',NULL),(464,7489,40799,17251,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',69970.40,NULL,NULL,1,'2023-09-20 10:43:24','2023-09-20 10:43:24',NULL),(465,7489,40799,17251,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',3675.04,NULL,NULL,1,'2023-09-20 10:43:42','2023-09-20 10:43:42',NULL),(466,7489,40799,17251,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',8732.75,NULL,NULL,1,'2023-09-20 10:44:04','2023-09-20 10:44:04',NULL),(467,7489,40799,17251,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',8723.97,NULL,NULL,1,'2023-09-20 10:44:20','2023-09-20 10:44:20',NULL),(468,7489,40799,17251,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',90821.91,NULL,NULL,1,'2023-09-20 10:44:41','2023-09-20 10:44:41',NULL),(469,7489,40724,7768,23,469,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',73735171.02,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-09-21 08:46:19','2023-09-21 08:47:59','2023-09-21 08:47:59'),(470,7489,40724,7768,23,470,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',73819279.16,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-09-21 08:47:21','2023-09-21 10:08:57','2023-09-21 10:08:57'),(471,7489,40724,7768,23,471,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',74342548.30,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-09-21 10:08:57','2023-09-21 10:17:01','2023-09-21 10:17:01'),(472,7489,40724,7768,23,472,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',74342548.30,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-09-21 10:17:01','2023-09-21 10:17:01',NULL),(473,7489,40724,7771,9,473,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',95240.53,'Agosto 2022',NULL,1,'2023-09-21 15:57:43','2023-09-21 15:57:43',NULL),(474,7489,40724,7772,9,474,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',30621.28,NULL,NULL,1,'2023-09-21 16:01:08','2023-09-21 16:01:08',NULL),(475,7489,40724,7773,9,475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',556965.39,NULL,NULL,1,'2023-09-21 16:03:34','2023-09-21 16:03:34',NULL);
INSERT INTO `balance_libro` VALUES (476,7489,40724,7779,9,476,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1406860.10,NULL,NULL,1,'2023-09-21 16:06:07','2023-09-21 16:06:07',NULL),(477,7489,40724,7781,9,477,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1379368.05,NULL,NULL,1,'2023-09-21 16:11:03','2023-09-21 16:11:03',NULL),(478,7489,40724,7782,9,478,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1254982.93,NULL,NULL,1,'2023-09-21 16:12:36','2023-10-27 11:01:55','2023-10-27 11:01:55'),(479,7489,40724,7768,17,479,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',322279093.42,'Asiento de cierre',NULL,1,'2023-09-28 08:45:23','2023-09-28 08:45:23',NULL),(480,7489,40724,7769,12,480,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',110706688.02,'Asiento de apertura',NULL,1,'2023-09-28 08:56:38','2023-09-28 08:56:38',NULL),(481,7489,40724,7769,16,481,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',814431.05,'Liquidacion mensual',NULL,1,'2023-09-28 09:03:39','2023-09-28 09:03:39',NULL),(482,7489,40724,7770,16,482,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',772299.53,'Liquidacion mensual',NULL,1,'2023-09-28 09:04:21','2023-09-28 09:04:21',NULL),(483,7489,40724,7771,16,483,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',719166.73,'Liquidacion mensual',NULL,1,'2023-09-28 09:05:00','2023-09-28 09:05:00',NULL),(484,7489,40724,7772,16,484,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',772419.75,'Liquidacion mensual',NULL,1,'2023-09-28 09:05:56','2023-09-28 09:05:56',NULL),(485,7489,40724,7773,16,485,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',703396.85,'Liquidacion mensual',NULL,1,'2023-09-28 09:06:43','2023-09-28 09:06:43',NULL),(486,7489,40724,7774,16,486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1041529.44,'Liquidacion mensual',NULL,1,'2023-09-28 09:07:25','2023-09-28 09:07:25',NULL),(487,7489,40724,7778,16,487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',885747.40,'Liquidacion mensual',NULL,1,'2023-09-28 09:08:05','2023-09-28 09:08:05',NULL),(488,7489,40724,7779,16,488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',857570.77,'Liquidacion mensual',NULL,1,'2023-09-28 09:08:45','2023-09-28 09:08:45',NULL),(489,7489,40724,7780,16,489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1133448.65,'Liquidacion mensual',NULL,1,'2023-09-28 09:09:22','2023-09-28 09:09:22',NULL),(490,7489,40724,7781,16,490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1000945.60,'Liquidacion mensual',NULL,1,'2023-09-28 09:10:05','2023-09-28 09:10:05',NULL),(491,7489,40724,7782,16,491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1074623.84,'Liquidacion mensual',NULL,1,'2023-09-28 09:10:39','2023-09-28 09:10:39',NULL),(492,7489,40724,7783,16,492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1308486.97,'Liquidacion mensual',NULL,1,'2023-09-28 09:11:20','2023-09-28 09:11:20',NULL),(493,7489,40724,7782,16,493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',248251.46,'Liquidacion mensual por ajuste',NULL,1,'2023-09-28 09:13:39','2023-09-28 10:07:08','2023-09-28 10:07:08');
INSERT INTO `balance_libro` VALUES (494,7489,40724,7769,15,494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5134295.80,'Liquidacion mensual',NULL,1,'2023-09-28 09:32:23','2023-09-28 09:32:23',NULL),(495,7489,40724,7770,15,495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4633797.62,'Liquidacion mensual',NULL,1,'2023-09-28 09:33:26','2023-09-28 09:33:26',NULL),(496,7489,40724,7771,15,496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',4313091.92,'Liquidacion mensual',NULL,1,'2023-09-28 09:34:27','2023-09-28 09:34:27',NULL),(497,7489,40724,7772,15,497,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4634518.94,'Liquidacion mensual',NULL,1,'2023-09-28 09:35:55','2023-09-28 09:35:55',NULL),(498,7489,40724,7773,15,498,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4262546.35,'Liquidacion mensual',NULL,1,'2023-09-28 09:36:54','2023-09-28 09:36:54',NULL),(499,7489,40724,7774,15,499,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6095088.11,'Liquidacion mensual',NULL,1,'2023-09-28 09:38:54','2023-09-28 09:38:54',NULL),(500,7489,40724,7778,15,500,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5314484.96,'Liquidacion mensual',NULL,1,'2023-09-28 09:40:01','2023-09-28 09:40:01',NULL),(501,7489,40724,7779,15,501,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5045021.75,'Liquidacion mensual',NULL,1,'2023-09-28 09:43:34','2023-09-28 09:43:34',NULL),(502,7489,40724,7780,15,502,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6930642.30,'Liquidacion mensual',NULL,1,'2023-09-28 09:44:27','2023-09-28 09:44:27',NULL),(503,7489,40724,7781,15,503,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6005674.40,'Liquidacion mensual',NULL,1,'2023-09-28 09:45:17','2023-09-28 09:45:17',NULL),(504,7489,40724,7782,15,504,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6397603.17,'Liquidacion mensual',NULL,1,'2023-09-28 09:46:02','2023-09-28 09:46:02',NULL),(505,7489,40724,7783,15,505,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',8268430.05,'Liquidacion mensual',NULL,1,'2023-09-28 09:46:53','2023-09-28 09:46:53',NULL),(506,7489,40724,7769,1,506,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',451763.47,NULL,NULL,1,'2023-09-28 09:59:43','2023-09-28 09:59:43',NULL),(507,7489,40724,7782,16,507,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',239894.50,'Liquidacion mensual por ajuste',NULL,1,'2023-09-28 10:07:08','2023-09-28 10:07:08',NULL),(508,7489,40724,7771,19,508,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',493743.34,NULL,NULL,1,'2023-09-28 10:27:28','2023-10-27 09:29:39','2023-10-27 09:29:39'),(509,7489,40724,7780,11,509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3853511.81,NULL,NULL,1,'2023-09-28 10:39:22','2023-09-28 10:39:22',NULL),(510,7489,40724,7771,19,510,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1600000.00,'Asignacion Honorarios',NULL,1,'2023-09-28 10:44:52','2023-09-28 10:44:52',NULL),(511,7489,40724,7771,18,511,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',49370689.51,NULL,NULL,1,'2023-09-28 10:47:37','2023-09-28 10:47:37',NULL),(512,7489,40724,7784,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',47083500.06,NULL,NULL,1,'2023-09-30 09:47:42','2023-09-30 12:31:32','2023-09-30 12:31:32');
INSERT INTO `balance_libro` VALUES (513,7489,40724,7785,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',63562118.24,NULL,NULL,1,'2023-09-30 09:56:41','2023-09-30 12:24:04','2023-09-30 12:24:04'),(514,7489,40724,7784,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',46629279.08,NULL,NULL,1,'2023-09-30 10:01:39','2023-09-30 10:01:39',NULL),(515,7489,40724,7785,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',50896854.09,NULL,NULL,1,'2023-09-30 10:03:13','2023-09-30 10:03:13',NULL),(516,7489,40724,7784,15,344,'App\\Models\\PeriodLiquidation',NULL,344,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',7867705.96,NULL,NULL,1,'2023-09-30 10:21:57','2023-09-30 10:23:22','2023-09-30 10:23:22'),(517,7489,40724,7784,15,517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',7867705.96,'Liquidacion mensual',NULL,1,'2023-09-30 10:24:37','2023-10-02 08:56:55','2023-10-02 08:56:55'),(518,7489,40724,7784,16,518,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1311284.30,'Liquidacion mensual',NULL,1,'2023-09-30 10:25:31','2023-09-30 12:30:04','2023-09-30 12:30:04'),(519,7489,40724,7785,15,519,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',10462452.47,'Liquidacion mensual',NULL,1,'2023-09-30 10:28:56','2023-09-30 12:22:39','2023-09-30 12:22:39'),(520,7489,40724,7785,16,520,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1653129.84,'Liquidacion mensual',NULL,1,'2023-09-30 10:29:36','2023-10-02 09:01:22','2023-10-02 09:01:22'),(521,7489,40724,7785,15,521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',10456299.03,'Liquidacion mensual',NULL,1,'2023-09-30 12:22:39','2023-10-02 08:56:20','2023-10-02 08:56:20'),(522,7489,40724,7785,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',63562118.24,NULL,NULL,1,'2023-09-30 12:24:04','2023-09-30 12:24:04',NULL),(523,7489,40724,7784,16,523,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1311284.30,'Liquidacion mensual',NULL,1,'2023-09-30 12:30:04','2023-10-02 09:00:00','2023-10-02 09:00:00'),(524,7489,40724,7784,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',47083500.06,NULL,NULL,1,'2023-09-30 12:31:32','2023-09-30 12:31:32',NULL),(525,7489,40724,7785,15,525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',10456299.03,'Liquidacion mensual',NULL,1,'2023-10-02 08:56:20','2023-10-02 08:56:20',NULL),(526,7489,40724,7784,15,526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',7867705.96,'Liquidacion mensual',NULL,1,'2023-10-02 08:56:55','2023-10-02 08:56:55',NULL),(527,7489,40724,7784,16,527,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1311284.30,'Liquidacion mensual',NULL,1,'2023-10-02 09:00:00','2023-10-02 09:00:00',NULL),(528,7489,40724,7785,16,528,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1653129.84,'Liquidacion mensual',NULL,1,'2023-10-02 09:01:22','2023-10-02 09:01:22',NULL),(529,7489,40726,10912,1,529,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-08-31',NULL,188689.00,NULL,NULL,1,'2023-10-02 10:03:06','2023-10-02 10:03:06',NULL),(530,7489,40727,12529,1,530,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-08-31',NULL,345900.98,NULL,NULL,1,'2023-10-02 10:13:13','2023-10-02 10:13:13',NULL),(531,7489,40724,7785,1,531,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-08-31',NULL,4302359.83,NULL,NULL,1,'2023-10-02 11:03:24','2023-10-02 11:03:24',NULL);
INSERT INTO `balance_libro` VALUES (532,7489,40725,9360,1,532,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-08-31',NULL,261374.49,NULL,NULL,1,'2023-10-02 15:30:27','2023-10-02 15:30:27',NULL),(533,7489,40725,9361,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',9121.90,NULL,NULL,1,'2023-10-03 09:29:51','2023-10-03 09:29:51',NULL),(534,7489,40725,9361,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',8084.40,NULL,NULL,1,'2023-10-03 09:30:26','2023-10-03 09:30:26',NULL),(535,7489,40725,9361,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',10904.21,NULL,NULL,1,'2023-10-03 09:31:12','2023-10-03 09:31:12',NULL),(536,7489,40725,9361,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',9199.51,NULL,NULL,1,'2023-10-03 09:32:50','2023-10-03 09:32:50',NULL),(537,7489,40725,9361,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',6100.48,NULL,NULL,1,'2023-10-03 09:35:22','2023-10-03 09:35:22',NULL),(538,7489,40725,9361,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',2502.00,NULL,NULL,1,'2023-10-03 09:38:03','2023-10-03 09:38:03',NULL),(539,7489,40725,9361,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',5999.73,NULL,NULL,1,'2023-10-03 09:39:38','2023-10-03 09:39:38',NULL),(540,7489,40728,14254,1,540,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-08-31',NULL,711019.01,NULL,NULL,1,'2023-10-04 12:46:16','2023-10-04 12:46:16',NULL),(541,7489,40799,17252,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',87120.00,NULL,NULL,1,'2023-10-09 12:26:46','2023-10-09 12:26:46',NULL),(542,7489,40799,17252,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',137940.00,NULL,NULL,1,'2023-10-09 12:26:46','2023-10-09 12:26:46',NULL),(543,7489,40799,17252,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',160930.00,NULL,NULL,1,'2023-10-09 12:26:46','2023-10-09 12:26:46',NULL),(544,7489,40799,17252,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',266200.00,NULL,NULL,1,'2023-10-09 12:26:47','2023-10-09 12:26:47',NULL),(545,7489,40799,17252,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',64342.60,NULL,NULL,1,'2023-10-09 12:27:43','2023-10-09 12:29:51','2023-10-09 12:29:51'),(546,7489,40799,17252,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',10119.80,NULL,NULL,1,'2023-10-09 12:27:43','2023-10-09 12:30:30','2023-10-09 12:30:30'),(547,7489,40799,17252,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',10129.99,NULL,NULL,1,'2023-10-09 12:27:43','2023-10-09 12:30:56','2023-10-09 12:30:56'),(548,7489,40799,17252,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',9000.00,NULL,NULL,1,'2023-10-09 12:27:43','2023-10-09 12:31:24','2023-10-09 12:31:24'),(549,7489,40799,17252,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',90070.26,NULL,NULL,1,'2023-10-09 12:27:43','2023-10-09 12:32:07','2023-10-09 12:32:07'),(550,7489,40799,17252,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',3997.06,NULL,NULL,1,'2023-10-09 12:27:44','2023-10-09 12:27:44',NULL),(551,7489,40799,17252,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',21900.00,NULL,NULL,1,'2023-10-09 12:27:44','2023-10-09 12:39:20','2023-10-09 12:39:20');
INSERT INTO `balance_libro` VALUES (552,7489,40799,17252,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',21900.00,NULL,NULL,1,'2023-10-09 12:27:44','2023-10-09 12:39:03','2023-10-09 12:39:03'),(553,7489,40799,17252,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',62799.90,NULL,NULL,1,'2023-10-09 12:27:44','2023-10-09 12:33:33','2023-10-09 12:33:33'),(554,7489,40799,17252,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',11392.80,NULL,NULL,1,'2023-10-09 12:27:44','2023-10-09 12:27:44',NULL),(555,7489,40799,17252,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',22313.48,NULL,NULL,1,'2023-10-09 12:27:44','2023-10-09 12:34:18','2023-10-09 12:34:18'),(556,7489,40799,17252,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',7831.43,NULL,NULL,1,'2023-10-09 12:27:45','2023-10-09 12:27:45',NULL),(557,7489,40799,17252,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',10119.80,NULL,NULL,1,'2023-10-09 12:27:45','2023-10-09 12:27:45',NULL),(558,7489,40799,17252,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',10129.99,NULL,NULL,1,'2023-10-09 12:27:45','2023-10-09 12:27:45',NULL),(559,7489,40799,17252,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',7839.31,NULL,NULL,1,'2023-10-09 12:27:45','2023-10-09 12:27:45',NULL),(560,7489,40799,17252,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',64342.60,NULL,NULL,1,'2023-10-09 12:29:51','2023-10-09 12:29:51',NULL),(561,7489,40799,17252,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',10119.80,NULL,NULL,1,'2023-10-09 12:30:30','2023-10-09 12:30:30',NULL),(562,7489,40799,17252,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',10129.99,NULL,NULL,1,'2023-10-09 12:30:56','2023-10-09 12:30:56',NULL),(563,7489,40799,17252,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',9000.00,NULL,NULL,1,'2023-10-09 12:31:24','2023-10-09 12:31:24',NULL),(564,7489,40799,17252,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',90070.26,NULL,NULL,1,'2023-10-09 12:32:07','2023-10-09 12:32:07',NULL),(565,7489,40799,17252,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',62799.90,NULL,NULL,1,'2023-10-09 12:33:33','2023-10-09 12:33:33',NULL),(566,7489,40799,17252,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',22313.48,NULL,NULL,1,'2023-10-09 12:34:18','2023-10-09 12:34:18',NULL),(567,7489,40799,17252,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',21900.00,NULL,NULL,1,'2023-10-09 12:39:03','2023-10-09 12:39:03',NULL),(568,7489,40799,17252,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',21900.00,NULL,NULL,1,'2023-10-09 12:39:20','2023-10-09 12:39:20',NULL),(569,7489,40724,7786,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',52384421.20,NULL,NULL,1,'2023-10-11 12:08:25','2023-10-11 12:08:25',NULL),(570,7489,40724,7786,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',54697665.67,NULL,NULL,1,'2023-10-11 12:11:26','2023-10-11 12:11:26',NULL),(571,7489,40724,7786,15,571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',9398098.02,'Liquidacion mensual',NULL,1,'2023-10-11 12:15:45','2023-10-11 12:15:45',NULL);
INSERT INTO `balance_libro` VALUES (572,7489,40724,7786,16,572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',1458289.10,'Liquidacion mensual',NULL,1,'2023-10-11 12:17:09','2023-10-11 12:17:09',NULL),(573,7489,40725,9361,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',99673.00,NULL,NULL,1,'2023-10-17 15:16:46','2023-10-17 15:16:46',NULL),(574,7489,40725,9361,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',86243.00,NULL,NULL,1,'2023-10-17 15:16:46','2023-10-17 15:19:40','2023-10-17 15:19:40'),(575,7489,40725,9361,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',186098.00,NULL,NULL,1,'2023-10-17 15:16:46','2023-10-17 15:16:46',NULL),(576,7489,40725,9361,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',65037.00,NULL,NULL,1,'2023-10-17 15:16:46','2023-10-17 15:24:25','2023-10-17 15:24:25'),(577,7489,40725,9361,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',149435.00,NULL,NULL,1,'2023-10-17 15:16:46','2023-10-17 15:16:46',NULL),(578,7489,40725,9361,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',2125486.00,NULL,NULL,1,'2023-10-17 15:16:46','2023-10-17 15:16:46',NULL),(579,7489,40725,9361,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',92900.00,NULL,NULL,1,'2023-10-17 15:16:46','2023-10-17 15:16:46',NULL),(580,7489,40725,9361,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',103092.00,NULL,NULL,1,'2023-10-17 15:16:47','2023-10-17 15:16:47',NULL),(581,7489,40725,9361,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',86243.02,NULL,NULL,1,'2023-10-17 15:19:40','2023-10-17 15:21:07','2023-10-17 15:21:07'),(582,7489,40725,9361,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',86243.02,NULL,NULL,1,'2023-10-17 15:21:07','2023-10-17 15:21:50','2023-10-17 15:21:50'),(583,7489,40725,9361,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',86243.00,NULL,NULL,1,'2023-10-17 15:21:50','2023-10-17 15:22:32','2023-10-17 15:22:32'),(584,7489,40725,9361,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',86243.00,NULL,NULL,1,'2023-10-17 15:22:32','2023-10-17 15:22:32',NULL),(585,7489,40725,9361,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',65037.00,NULL,NULL,1,'2023-10-17 15:24:25','2023-10-17 15:24:25',NULL),(586,7489,40725,9361,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',46713.55,NULL,NULL,1,'2023-10-17 15:29:34','2023-10-17 15:29:34',NULL),(587,7489,40725,9361,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',21999.00,NULL,NULL,1,'2023-10-17 15:29:34','2023-10-17 15:29:34',NULL),(588,7489,40725,9361,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',17544.00,NULL,NULL,1,'2023-10-17 15:29:34','2023-10-17 15:29:34',NULL),(589,7489,40725,9361,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',76254.20,NULL,NULL,1,'2023-10-17 15:29:34','2023-10-17 15:29:34',NULL),(590,7489,40725,9361,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',25923.04,NULL,NULL,1,'2023-10-17 15:29:34','2023-10-17 16:09:24','2023-10-17 16:09:24'),(591,7489,40725,9361,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',3363.80,NULL,NULL,1,'2023-10-17 15:29:34','2023-10-17 15:29:34',NULL);
INSERT INTO `balance_libro` VALUES (592,7489,40725,9361,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',50209.97,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:40:25','2023-10-17 15:40:25'),(593,7489,40725,9361,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',14500.00,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(594,7489,40725,9361,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',212887.40,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(595,7489,40725,9361,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',3347.74,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(596,7489,40725,9361,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',62157.70,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(597,7489,40725,9361,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',1434.71,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:32:23','2023-10-17 15:32:23'),(598,7489,40725,9361,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',73352.62,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(599,7489,40725,9361,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',23662.00,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(600,7489,40725,9361,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',13204.73,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(601,7489,40725,9361,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',12288.76,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(602,7489,40725,9361,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',2939.98,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(603,7489,40725,9361,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',4560.00,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(604,7489,40725,9361,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',4560.00,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(605,7489,40725,9361,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',32760.75,NULL,NULL,1,'2023-10-17 15:29:35','2023-10-17 15:29:35',NULL),(606,7489,40725,9361,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',15730.00,NULL,NULL,1,'2023-10-17 15:29:36','2023-10-17 15:29:36',NULL),(607,7489,40725,9361,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',20000.00,NULL,NULL,1,'2023-10-17 15:29:36','2023-10-17 15:30:37','2023-10-17 15:30:37'),(608,7489,40725,9361,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',20000.00,NULL,NULL,1,'2023-10-17 15:30:37','2023-10-17 15:30:37',NULL),(609,7489,40725,9361,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',1434.70,NULL,NULL,1,'2023-10-17 15:32:23','2023-10-17 15:32:23',NULL),(610,7489,40725,9361,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',306436.59,NULL,NULL,1,'2023-10-17 15:57:57','2023-10-17 15:57:57',NULL),(611,7489,40725,9361,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',25923.04,NULL,NULL,1,'2023-10-17 16:09:24','2023-10-17 16:09:24',NULL),(612,7489,40728,14255,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',159133.65,NULL,NULL,1,'2023-10-18 08:13:42','2023-10-18 08:13:42',NULL);
INSERT INTO `balance_libro` VALUES (613,7489,40728,14255,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',138887.89,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(614,7489,40728,14255,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',96415.18,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(615,7489,40728,14255,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',191278.00,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(616,7489,40728,14255,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',121394.71,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(617,7489,40728,14255,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',38280.00,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(618,7489,40728,14255,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',126027.78,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(619,7489,40728,14255,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',121009.02,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(620,7489,40728,14255,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',290468.67,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(621,7489,40728,14255,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',170454.95,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(622,7489,40728,14255,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',152936.99,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(623,7489,40728,14255,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',149228.28,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(624,7489,40728,14255,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',177450.27,NULL,NULL,1,'2023-10-18 08:13:43','2023-10-18 08:13:43',NULL),(625,7489,40728,14255,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',37866.00,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(626,7489,40728,14255,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',122223.70,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(627,7489,40728,14255,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',120120.52,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(628,7489,40728,14255,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',114356.51,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(629,7489,40728,14255,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',168276.46,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(630,7489,40728,14255,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',140534.91,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(631,7489,40728,14255,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',59014.00,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(632,7489,40728,14255,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-24','2023-09-24',7340.00,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(633,7489,40728,14255,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',147053.70,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL);
INSERT INTO `balance_libro` VALUES (634,7489,40728,14255,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',226160.72,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(635,7489,40728,14255,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',158060.00,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(636,7489,40728,14255,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',101384.00,NULL,NULL,1,'2023-10-18 08:13:44','2023-10-18 08:13:44',NULL),(637,7489,40728,14255,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',168517.69,NULL,NULL,1,'2023-10-18 08:13:45','2023-10-18 08:13:45',NULL),(638,7489,40728,14255,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',55085.00,NULL,NULL,1,'2023-10-18 08:13:45','2023-10-18 08:13:45',NULL),(639,7489,40728,14255,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',6454974.22,NULL,NULL,1,'2023-10-18 08:37:20','2023-10-18 08:37:20',NULL),(640,7489,40728,14255,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',53912.24,NULL,NULL,1,'2023-10-18 08:38:18','2023-10-18 08:38:18',NULL),(641,7489,40728,14255,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',867465.12,NULL,NULL,1,'2023-10-18 08:38:57','2023-10-18 08:38:57',NULL),(642,7489,40728,14255,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',164482.93,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(643,7489,40728,14255,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',298425.28,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(644,7489,40728,14255,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',181134.36,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(645,7489,40728,14255,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',28740.59,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(646,7489,40728,14255,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',153407.66,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(647,7489,40728,14255,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',199604.68,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(648,7489,40728,14255,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',15871.17,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(649,7489,40728,14255,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',15674.26,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(650,7489,40728,14255,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',6917.73,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(651,7489,40728,14255,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',157330.82,NULL,NULL,1,'2023-10-18 08:41:17','2023-10-18 08:41:17',NULL),(652,7489,40728,14255,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',111903.32,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(653,7489,40728,14255,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',8646.38,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(654,7489,40728,14255,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',145342.67,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL);
INSERT INTO `balance_libro` VALUES (655,7489,40728,14255,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',2868.14,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(656,7489,40728,14255,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',4782.07,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(657,7489,40728,14255,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',79811.66,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(658,7489,40728,14255,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',228787.36,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(659,7489,40728,14255,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',186903.45,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(660,7489,40728,14255,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',40757.35,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(661,7489,40728,14255,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',3080.54,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(662,7489,40728,14255,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',3370.30,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(663,7489,40728,14255,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',119184.36,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(664,7489,40728,14255,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',97808.06,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(665,7489,40728,14255,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',10124.66,NULL,NULL,1,'2023-10-18 08:41:18','2023-10-18 08:41:18',NULL),(666,7489,40728,14255,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',2440.65,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(667,7489,40728,14255,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',1230.63,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(668,7489,40728,14255,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',50940.00,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(669,7489,40728,14255,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',2835.00,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(670,7489,40728,14255,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',10650.24,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(671,7489,40728,14255,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',30748.62,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(672,7489,40728,14255,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',268421.60,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(673,7489,40728,14255,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',10608.63,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(674,7489,40728,14255,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',2495.95,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(675,7489,40728,14255,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',45000.00,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL);
INSERT INTO `balance_libro` VALUES (676,7489,40728,14255,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',182215.33,NULL,NULL,1,'2023-10-18 08:41:19','2023-10-18 08:41:19',NULL),(677,7489,40728,14255,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',162233.36,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(678,7489,40728,14255,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',4956.29,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(679,7489,40728,14255,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',13019.70,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(680,7489,40728,14255,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',18696.70,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(681,7489,40728,14255,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',2226.81,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(682,7489,40728,14255,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',12538.53,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(683,7489,40728,14255,3,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',11898.82,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(684,7489,40728,14255,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',80482.35,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(685,7489,40728,14255,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',57762.80,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(686,7489,40728,14255,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',315.45,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(687,7489,40728,14255,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',5204.59,NULL,NULL,1,'2023-10-18 08:41:20','2023-10-18 08:41:20',NULL),(688,7489,40728,14255,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',6164.94,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL),(689,7489,40728,14255,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',53935.77,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL),(690,7489,40728,14255,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',42030.10,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:44:18','2023-10-18 08:44:18'),(691,7489,40728,14255,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',24403.64,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL),(692,7489,40728,14255,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',309970.72,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL),(693,7489,40728,14255,3,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',1809.85,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL),(694,7489,40728,14255,3,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',35556.64,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL),(695,7489,40728,14255,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',66811.73,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL),(696,7489,40728,14255,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',1207.82,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL);
INSERT INTO `balance_libro` VALUES (697,7489,40728,14255,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',167267.55,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL),(698,7489,40728,14255,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',1977.86,NULL,NULL,1,'2023-10-18 08:41:21','2023-10-18 08:41:21',NULL),(699,7489,40728,14255,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',72484.62,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(700,7489,40728,14255,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',137024.84,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(701,7489,40728,14255,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',3530.44,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(702,7489,40728,14255,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',682.55,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(703,7489,40728,14255,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',140710.88,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(704,7489,40728,14255,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',17326.48,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(705,7489,40728,14255,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',261629.31,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(706,7489,40728,14255,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',24947.55,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(707,7489,40728,14255,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',155939.82,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(708,7489,40728,14255,3,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',8371.55,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(709,7489,40728,14255,3,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',863558.92,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(710,7489,40728,14255,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',2942.27,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(711,7489,40728,14255,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',2463624.85,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(712,7489,40728,14255,3,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',8225.43,NULL,NULL,1,'2023-10-18 08:41:22','2023-10-18 08:41:22',NULL),(713,7489,40728,14255,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',3280.13,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(714,7489,40728,14255,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',10756.90,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(715,7489,40728,14255,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',272451.55,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(716,7489,40728,14255,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',176819.80,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(717,7489,40728,14255,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',13123.39,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL);
INSERT INTO `balance_libro` VALUES (718,7489,40728,14255,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',10420.21,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(719,7489,40728,14255,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',88481.47,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(720,7489,40728,14255,3,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',3357.42,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(721,7489,40728,14255,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',96137.32,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(722,7489,40728,14255,3,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',239344.37,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(723,7489,40728,14255,3,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',35240.23,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(724,7489,40728,14255,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',112328.71,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(725,7489,40728,14255,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',5181.90,NULL,NULL,1,'2023-10-18 08:41:23','2023-10-18 08:41:23',NULL),(726,7489,40728,14255,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',107319.64,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(727,7489,40728,14255,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',8821.63,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(728,7489,40728,14255,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',4935.02,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(729,7489,40728,14255,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',2236.21,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(730,7489,40728,14255,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',51756.99,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(731,7489,40728,14255,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',206342.82,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(732,7489,40728,14255,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',83175.16,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(733,7489,40728,14255,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',124009.33,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(734,7489,40728,14255,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',12791.66,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(735,7489,40728,14255,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',8201.12,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(736,7489,40728,14255,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',300187.13,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(737,7489,40728,14255,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',278555.13,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(738,7489,40728,14255,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',53475.77,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL);
INSERT INTO `balance_libro` VALUES (739,7489,40728,14255,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',145140.87,NULL,NULL,1,'2023-10-18 08:41:24','2023-10-18 08:41:24',NULL),(740,7489,40728,14255,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',9101.32,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(741,7489,40728,14255,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',7897.73,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(742,7489,40728,14255,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',4782.83,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(743,7489,40728,14255,3,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',166488.12,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(744,7489,40728,14255,3,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',7916.46,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(745,7489,40728,14255,3,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',23188.97,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(746,7489,40728,14255,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',242358.35,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(747,7489,40728,14255,3,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',102812.56,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(748,7489,40728,14255,3,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',228921.63,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(749,7489,40728,14255,3,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',10012.05,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(750,7489,40728,14255,3,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',10265.26,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(751,7489,40728,14255,3,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',21129.64,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(752,7489,40728,14255,3,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',4823.10,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(753,7489,40728,14255,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',141818.54,NULL,NULL,1,'2023-10-18 08:41:25','2023-10-18 08:41:25',NULL),(754,7489,40728,14255,3,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',106637.57,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(755,7489,40728,14255,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',2504.76,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(756,7489,40728,14255,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',4468.94,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(757,7489,40728,14255,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',6341.71,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(758,7489,40728,14255,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',4512.59,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(759,7489,40728,14255,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',8054.24,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL);
INSERT INTO `balance_libro` VALUES (760,7489,40728,14255,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',3175.52,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(761,7489,40728,14255,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',37119.51,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(762,7489,40728,14255,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',5910.00,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(763,7489,40728,14255,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',2533.68,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(764,7489,40728,14255,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',10394.99,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(765,7489,40728,14255,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',201172.27,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(766,7489,40728,14255,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',232119.93,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(767,7489,40728,14255,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',188713.78,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(768,7489,40728,14255,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',16434.34,NULL,NULL,1,'2023-10-18 08:41:26','2023-10-18 08:41:26',NULL),(769,7489,40728,14255,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',100582.80,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(770,7489,40728,14255,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',11938.11,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(771,7489,40728,14255,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',137289.20,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(772,7489,40728,14255,3,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',189576.23,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(773,7489,40728,14255,3,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',19425.59,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(774,7489,40728,14255,3,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',21105.11,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(775,7489,40728,14255,3,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',90845.72,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(776,7489,40728,14255,3,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',3918.30,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(777,7489,40728,14255,3,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',12136.04,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(778,7489,40728,14255,3,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',6148.28,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(779,7489,40728,14255,3,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',146522.13,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL),(780,7489,40728,14255,3,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',202513.72,NULL,NULL,1,'2023-10-18 08:41:27','2023-10-18 08:41:27',NULL);
INSERT INTO `balance_libro` VALUES (781,7489,40728,14255,3,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',2882.13,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(782,7489,40728,14255,3,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',126699.99,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(783,7489,40728,14255,3,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',8578.18,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(784,7489,40728,14255,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',325.45,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(785,7489,40728,14255,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',44148.66,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(786,7489,40728,14255,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',30816.57,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(787,7489,40728,14255,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',1689.12,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(788,7489,40728,14255,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',7897.73,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(789,7489,40728,14255,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',45622.97,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(790,7489,40728,14255,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',1233.67,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(791,7489,40728,14255,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',5221.66,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(792,7489,40728,14255,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',67779.23,NULL,NULL,1,'2023-10-18 08:41:28','2023-10-18 08:41:28',NULL),(793,7489,40728,14255,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',46634.86,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(794,7489,40728,14255,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',83309.96,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(795,7489,40728,14255,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',35666.10,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(796,7489,40728,14255,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',211887.87,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(797,7489,40728,14255,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',55537.38,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(798,7489,40728,14255,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',157116.92,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(799,7489,40728,14255,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',26112.81,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(800,7489,40728,14255,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',2591218.65,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(801,7489,40728,14255,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',35990.02,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL);
INSERT INTO `balance_libro` VALUES (802,7489,40728,14255,3,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',14696.96,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(803,7489,40728,14255,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',986364.08,NULL,NULL,1,'2023-10-18 08:41:29','2023-10-18 08:41:29',NULL),(804,7489,40728,14255,3,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',11718.87,NULL,NULL,1,'2023-10-18 08:41:30','2023-10-18 08:41:30',NULL),(805,7489,40728,14255,3,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',28544.38,NULL,NULL,1,'2023-10-18 08:41:30','2023-10-18 08:41:30',NULL),(806,7489,40728,14255,3,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',753.88,NULL,NULL,1,'2023-10-18 08:41:30','2023-10-18 08:41:30',NULL),(807,7489,40728,14255,3,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',2389.22,NULL,NULL,1,'2023-10-18 08:41:30','2023-10-18 08:41:30',NULL),(808,7489,40728,14255,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',204528.54,NULL,NULL,1,'2023-10-18 08:41:30','2023-10-18 08:41:30',NULL),(809,7489,40728,14255,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',1007.75,NULL,NULL,1,'2023-10-18 08:41:30','2023-10-18 08:41:30',NULL),(810,7489,40728,14255,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',149189.13,NULL,NULL,1,'2023-10-18 08:41:30','2023-10-18 08:41:30',NULL),(811,7489,40728,14255,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',1809.85,NULL,NULL,1,'2023-10-18 08:41:30','2023-10-18 08:41:30',NULL),(812,7489,40728,14255,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',10649.35,NULL,NULL,1,'2023-10-18 08:41:30','2023-10-18 08:41:30',NULL),(813,7489,40728,14255,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',174163.11,NULL,NULL,1,'2023-10-18 08:41:31','2023-10-18 08:41:31',NULL),(814,7489,40728,14255,3,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',23012.01,NULL,NULL,1,'2023-10-18 08:41:31','2023-10-18 08:41:31',NULL),(815,7489,40728,14255,3,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',260279.31,NULL,NULL,1,'2023-10-18 08:41:31','2023-10-18 08:41:31',NULL),(816,7489,40728,14255,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',39170.69,NULL,NULL,1,'2023-10-18 08:41:31','2023-10-18 08:41:31',NULL),(817,7489,40728,14255,3,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',37118.25,NULL,NULL,1,'2023-10-18 08:41:31','2023-10-18 08:41:31',NULL),(818,7489,40728,14255,3,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',4484.28,NULL,NULL,1,'2023-10-18 08:41:31','2023-10-18 08:41:31',NULL),(819,7489,40728,14255,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',4823.10,NULL,NULL,1,'2023-10-18 08:41:31','2023-10-18 08:41:31',NULL),(820,7489,40728,14255,3,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',10094.64,NULL,NULL,1,'2023-10-18 08:41:31','2023-10-18 08:41:31',NULL),(821,7489,40728,14255,3,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',41137.63,NULL,NULL,1,'2023-10-18 08:41:31','2023-10-18 08:41:31',NULL),(822,7489,40728,14255,3,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',9764.77,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL);
INSERT INTO `balance_libro` VALUES (823,7489,40728,14255,3,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',107407.13,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(824,7489,40728,14255,3,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',243214.09,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(825,7489,40728,14255,3,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',113926.52,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(826,7489,40728,14255,3,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',2462.57,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(827,7489,40728,14255,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',149628.91,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(828,7489,40728,14255,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',81211.91,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(829,7489,40728,14255,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',109772.00,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(830,7489,40728,14255,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',6882.48,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(831,7489,40728,14255,3,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',58342.58,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(832,7489,40728,14255,3,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',253982.64,NULL,NULL,1,'2023-10-18 08:41:32','2023-10-18 08:41:32',NULL),(833,7489,40728,14255,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',32304.43,NULL,NULL,1,'2023-10-18 08:41:33','2023-10-18 08:41:33',NULL),(834,7489,40728,14255,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',9078.85,NULL,NULL,1,'2023-10-18 08:41:33','2023-10-18 08:41:33',NULL),(835,7489,40727,12530,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',254624.01,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:12:09',NULL),(836,7489,40727,12530,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',10000.00,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:12:09',NULL),(837,7489,40727,12530,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',32041.75,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:12:09',NULL),(838,7489,40727,12530,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',7000.00,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:12:09',NULL),(839,7489,40727,12530,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',85713.40,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:12:09',NULL),(840,7489,40727,12530,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',5760.00,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:12:09',NULL),(841,7489,40727,12530,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',6400.00,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:12:09',NULL),(842,7489,40727,12530,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',876926.42,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:21:17','2023-10-18 09:21:17'),(843,7489,40727,12530,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',660154.03,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:12:09',NULL);
INSERT INTO `balance_libro` VALUES (844,7489,40727,12530,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',266340.36,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:19:10','2023-10-18 09:19:10'),(845,7489,40727,12530,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',5700.00,NULL,NULL,1,'2023-10-18 09:12:09','2023-10-18 09:17:34','2023-10-18 09:17:34'),(846,7489,40727,12530,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',194890.94,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(847,7489,40727,12530,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',71122.31,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(848,7489,40727,12530,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',11797.06,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(849,7489,40727,12530,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',25980.00,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(850,7489,40727,12530,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',21000.00,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:27:52','2023-10-18 09:27:52'),(851,7489,40727,12530,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',34734.65,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(852,7489,40727,12530,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',35000.00,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(853,7489,40727,12530,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',210475.87,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:28:42','2023-10-18 09:28:42'),(854,7489,40727,12530,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',862.31,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:28:59','2023-10-18 09:28:59'),(855,7489,40727,12530,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',4454.75,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(856,7489,40727,12530,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',82030.08,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(857,7489,40727,12530,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',15029.29,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(858,7489,40727,12530,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',5366.63,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(859,7489,40727,12530,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',7034.47,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:29:27','2023-10-18 09:29:27'),(860,7489,40727,12530,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',19206.67,NULL,NULL,1,'2023-10-18 09:14:32','2023-10-18 09:14:32',NULL),(861,7489,40727,12530,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',15804.37,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(862,7489,40727,12530,3,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',11441.73,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(863,7489,40727,12530,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',34265.26,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL);
INSERT INTO `balance_libro` VALUES (864,7489,40727,12530,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',61738.99,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(865,7489,40727,12530,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',29213.82,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(866,7489,40727,12530,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',12641.77,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(867,7489,40727,12530,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',8100.01,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(868,7489,40727,12530,3,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',19654.62,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(869,7489,40727,12530,3,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',160000.72,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(870,7489,40727,12530,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',15833.05,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(871,7489,40727,12530,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',34452.51,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(872,7489,40727,12530,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',29591.10,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(873,7489,40727,12530,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',16200.00,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(874,7489,40727,12530,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',18268.41,NULL,NULL,1,'2023-10-18 09:14:33','2023-10-18 09:14:33',NULL),(875,7489,40727,12530,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',21360.00,NULL,NULL,1,'2023-10-18 09:14:34','2023-10-18 09:14:34',NULL),(876,7489,40727,12530,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',5600.03,NULL,NULL,1,'2023-10-18 09:14:34','2023-10-18 09:14:34',NULL),(877,7489,40727,12530,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',3064.88,NULL,NULL,1,'2023-10-18 09:14:34','2023-10-18 09:14:34',NULL),(878,7489,40727,12530,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',60740.54,NULL,NULL,1,'2023-10-18 09:14:34','2023-10-18 09:14:34',NULL),(879,7489,40727,12530,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',15000.00,NULL,NULL,1,'2023-10-18 09:14:34','2023-10-18 09:14:34',NULL),(880,7489,40727,12530,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',5700.00,NULL,NULL,1,'2023-10-18 09:17:34','2023-10-18 09:17:34',NULL),(881,7489,40727,12530,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',266340.36,NULL,NULL,1,'2023-10-18 09:19:10','2023-10-18 09:19:10',NULL),(882,7489,40727,12530,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',876926.42,NULL,NULL,1,'2023-10-18 09:21:17','2023-10-18 09:21:17',NULL),(883,7489,40724,7769,5,883,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2365838.29,'Liquidacion mensual',NULL,1,'2023-10-25 15:21:55','2023-10-25 15:21:55',NULL),(884,7489,40724,7770,5,884,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1846778.93,'Liquidacion mensual',NULL,1,'2023-10-25 15:24:02','2023-10-25 15:24:02',NULL);
INSERT INTO `balance_libro` VALUES (885,7489,40724,7771,5,885,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1889130.82,'Liquidacion mensual',NULL,1,'2023-10-25 15:25:39','2023-10-25 15:25:39',NULL),(886,7489,40724,7772,5,886,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2188431.64,'Liquidacion mensual',NULL,1,'2023-10-25 15:27:03','2023-10-27 08:47:50','2023-10-27 08:47:50'),(887,7489,40724,7773,5,887,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2306060.98,'Liquidacion mensual',NULL,1,'2023-10-25 15:29:26','2023-10-27 08:49:35','2023-10-27 08:49:35'),(888,7489,40724,7774,5,888,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2989693.31,'Liquidacion mensual',NULL,1,'2023-10-25 15:39:00','2023-10-25 15:39:00',NULL),(889,7489,40724,7778,5,889,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2796544.75,'Liquidacion mensual',NULL,1,'2023-10-25 15:40:29','2023-10-27 08:58:52','2023-10-27 08:58:52'),(890,7489,40724,7779,5,890,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2398637.67,'Liquidacion mensual',NULL,1,'2023-10-25 15:42:04','2023-10-25 15:42:04',NULL),(891,7489,40724,7780,5,891,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3896935.95,'Liquidacion mensual',NULL,1,'2023-10-25 15:45:28','2023-10-25 15:45:28',NULL),(892,7489,40724,7781,5,892,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3165394.31,'Liquidacion mensual',NULL,1,'2023-10-25 15:46:49','2023-10-25 15:46:49',NULL),(893,7489,40724,7782,5,893,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6921824.59,'Liquidacion mensual',NULL,1,'2023-10-25 15:53:24','2023-10-25 15:59:55','2023-10-25 15:59:55'),(894,7489,40724,7782,5,894,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6921824.59,'Liquidacion mensual',NULL,1,'2023-10-25 15:59:55','2023-10-25 16:01:31','2023-10-25 16:01:31'),(895,7489,40724,7782,5,895,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6921824.59,'Liquidacion mensual',NULL,1,'2023-10-25 16:01:31','2023-10-25 16:01:31',NULL),(896,7489,40724,7783,5,896,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4166557.57,'Liquidacion mensual',NULL,1,'2023-10-25 16:04:16','2023-10-25 16:04:16',NULL),(897,7489,40724,7782,19,897,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3472910.48,NULL,NULL,1,'2023-10-25 16:06:08','2023-10-25 16:06:40','2023-10-25 16:06:40'),(898,7489,40724,7782,19,898,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3472910.48,'Liquidación moratoria',NULL,1,'2023-10-25 16:06:40','2023-10-25 16:06:40',NULL),(899,7489,40724,7770,20,634,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,634,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',28840812.18,NULL,NULL,1,'2023-10-26 10:27:58','2023-10-26 10:27:58',NULL),(900,7489,40724,7770,20,635,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,635,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',27372706.99,NULL,NULL,1,'2023-10-26 10:30:46','2023-10-26 10:30:46',NULL),(901,7489,40724,7771,20,636,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,636,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',26992515.36,NULL,NULL,1,'2023-10-26 10:38:26','2023-10-26 10:38:26',NULL),(902,7489,40724,7772,20,637,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,637,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',25642151.85,NULL,NULL,1,'2023-10-26 10:40:44','2023-10-26 10:40:44',NULL);
INSERT INTO `balance_libro` VALUES (903,7489,40724,7773,20,638,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,638,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',24349135.12,NULL,NULL,1,'2023-10-26 10:42:20','2023-10-26 10:42:20',NULL),(904,7489,40724,7774,20,639,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,639,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',38431401.00,NULL,NULL,1,'2023-10-26 10:44:48','2023-10-27 09:20:07','2023-10-27 09:20:07'),(905,7489,40724,7778,20,640,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,640,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',31124623.21,NULL,NULL,1,'2023-10-26 10:48:05','2023-10-26 11:15:55','2023-10-26 11:15:55'),(906,7489,40724,7764,20,641,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,641,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',24893511.05,NULL,NULL,1,'2023-10-26 10:52:16','2023-10-26 15:50:15','2023-10-26 15:50:15'),(907,7489,40724,7780,20,642,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,642,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',42319327.03,NULL,NULL,1,'2023-10-26 10:56:59','2023-11-11 09:13:09','2023-11-11 09:13:09'),(908,7489,40724,7781,20,643,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,643,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',33031228.91,NULL,NULL,1,'2023-10-26 10:59:48','2023-11-11 09:13:14','2023-11-11 09:13:14'),(909,7489,40724,7782,20,644,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,644,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',40327850.78,NULL,NULL,1,'2023-10-26 11:03:48','2023-11-11 09:13:19','2023-11-11 09:13:19'),(910,7489,40724,7778,20,645,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,645,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',26124623.21,NULL,NULL,1,'2023-10-26 11:19:39','2023-10-27 09:23:09','2023-10-27 09:23:09'),(911,7489,40724,7783,20,646,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,646,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',42778067.46,NULL,NULL,1,'2023-10-26 11:21:45','2023-11-11 09:13:24','2023-11-11 09:13:24'),(912,7489,40724,7769,21,912,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1408281.00,'Pago de Sueldos',NULL,1,'2023-10-26 12:14:24','2023-10-26 12:14:24',NULL),(913,7489,40724,7769,21,913,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1228008.04,'Pago de Sueldos',NULL,1,'2023-10-26 12:15:19','2023-10-26 12:15:19',NULL),(914,7489,40724,7770,21,914,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',878710.46,'Pago de Sueldos',NULL,1,'2023-10-26 12:16:09','2023-10-26 12:16:09',NULL),(915,7489,40724,7771,21,915,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',993798.28,'Pago de Sueldos',NULL,1,'2023-10-26 12:17:19','2023-10-26 12:17:19',NULL),(916,7489,40724,7772,21,916,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',832596.43,'Pago de Sueldos',NULL,1,'2023-10-26 12:18:45','2023-10-26 12:46:14','2023-10-26 12:46:14'),(917,7489,40724,7772,21,917,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',832596.43,'Pago de Sueldos',NULL,1,'2023-10-26 12:46:14','2023-10-26 12:46:14',NULL),(918,7489,40724,7773,21,918,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',736835.35,'Pago de Sueldos',NULL,1,'2023-10-26 12:47:05','2023-10-26 12:47:05',NULL),(919,7489,40724,7774,21,919,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1302429.09,'Pago de Sueldos',NULL,1,'2023-10-26 12:48:06','2023-10-26 12:48:06',NULL),(920,7489,40724,7778,21,920,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',731599.44,'Pago de Sueldos',NULL,1,'2023-10-26 12:48:46','2023-10-26 12:48:46',NULL),(921,7489,40724,7779,21,921,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1817905.07,'Pago de Sueldos',NULL,1,'2023-10-26 12:49:36','2023-10-26 12:49:36',NULL);
INSERT INTO `balance_libro` VALUES (922,7489,40724,7780,21,922,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',222745.77,'Pago de Sueldos',NULL,1,'2023-10-26 12:50:22','2023-10-26 12:50:22',NULL),(923,7489,40724,7781,21,923,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',951564.48,'Pago de Sueldos',NULL,1,'2023-10-26 12:51:19','2023-10-26 12:51:19',NULL),(924,7489,40724,7782,21,924,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',991670.56,'Pago de Sueldos',NULL,1,'2023-10-26 12:52:02','2023-10-26 12:54:22','2023-10-26 12:54:22'),(925,7489,40724,7782,21,925,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1001643.03,'Pago de Sueldos',NULL,1,'2023-10-26 12:54:22','2023-10-26 12:54:22',NULL),(926,7489,40724,7770,21,647,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,647,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',35779705.28,NULL,NULL,1,'2023-10-26 14:43:38','2023-10-26 14:43:38',NULL),(927,7489,40724,7770,21,648,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,648,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29077987.64,NULL,NULL,1,'2023-10-26 14:44:59','2023-10-26 14:44:59',NULL),(928,7489,40724,7771,21,649,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,649,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',27927451.82,NULL,NULL,1,'2023-10-26 14:46:08','2023-10-26 14:46:08',NULL),(929,7489,40724,7772,21,650,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,650,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',27277611.70,NULL,NULL,1,'2023-10-26 14:47:25','2023-10-26 14:47:25',NULL),(930,7489,40724,7773,21,651,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,651,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',28092456.10,NULL,NULL,1,'2023-10-26 14:48:38','2023-10-26 14:48:38',NULL),(931,7489,40724,7774,21,652,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,652,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',40301579.14,NULL,NULL,1,'2023-10-26 14:49:43','2023-10-26 14:49:43',NULL),(932,7489,40724,7778,21,653,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,653,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',26293641.26,NULL,NULL,1,'2023-10-26 14:50:47','2023-10-27 09:11:22','2023-10-27 09:11:22'),(933,7489,40724,7779,21,654,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,654,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',32533979.48,NULL,NULL,1,'2023-10-26 14:52:15','2023-10-26 14:52:15',NULL),(934,7489,40724,7780,21,655,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,655,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',44476071.61,NULL,NULL,1,'2023-10-26 14:53:32','2023-10-26 14:53:32',NULL),(935,7489,40724,7781,21,656,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,656,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',38472105.21,NULL,NULL,1,'2023-10-26 14:54:41','2023-10-26 14:54:41',NULL),(936,7489,40724,7782,21,657,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,657,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',39190973.78,NULL,NULL,1,'2023-10-26 14:55:45','2023-10-26 15:02:40','2023-10-26 15:02:40'),(937,7489,40724,7782,21,658,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,658,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',31151657.32,NULL,NULL,1,'2023-10-26 15:11:32','2023-10-26 15:11:32',NULL),(938,7489,40724,7783,21,659,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,659,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',41195947.09,NULL,NULL,1,'2023-10-26 15:27:48','2023-10-27 12:52:33','2023-10-27 12:52:33'),(939,7489,40724,7779,20,660,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,660,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',24893511.05,NULL,NULL,1,'2023-10-26 15:52:32','2023-11-11 09:13:00','2023-11-11 09:13:00'),(940,7489,40724,7772,6,940,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',17216.03,'liquidacion Impuesto',NULL,1,'2023-10-26 15:54:22','2023-10-26 15:54:22',NULL);
INSERT INTO `balance_libro` VALUES (941,7489,40724,7772,5,941,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2188071.64,'Liquidacion mensual',NULL,1,'2023-10-27 08:47:50','2023-10-27 08:47:50',NULL),(942,7489,40724,7773,5,942,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2388835.37,'Liquidacion mensual',NULL,1,'2023-10-27 08:49:35','2023-10-27 08:49:35',NULL),(943,7489,40724,7778,5,943,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2796544.75,'Liquidacion mensual',NULL,1,'2023-10-27 08:58:52','2023-10-27 09:08:53','2023-10-27 09:08:53'),(944,7489,40724,7778,5,944,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2876154.32,'Liquidacion mensual',NULL,1,'2023-10-27 09:08:53','2023-10-27 09:08:53',NULL),(945,7489,40724,7778,21,661,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,661,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',26293641.26,NULL,NULL,1,'2023-10-27 09:12:39','2023-10-27 09:12:39',NULL),(946,7489,40724,7774,20,662,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,662,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',36137030.39,NULL,NULL,1,'2023-10-27 09:22:52','2023-11-11 09:54:59','2023-11-11 09:54:59'),(947,7489,40724,7778,20,663,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,663,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',28418993.82,NULL,NULL,1,'2023-10-27 09:25:37','2023-11-11 09:12:54','2023-11-11 09:12:54'),(948,7489,40724,7771,19,948,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',493743.34,NULL,NULL,1,'2023-10-27 09:29:39','2023-10-27 09:29:39',NULL),(949,7489,40724,7774,9,949,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2668115.66,NULL,NULL,1,'2023-10-27 10:57:10','2023-10-27 10:59:23','2023-10-27 10:59:23'),(950,7489,40724,7774,9,950,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2668115.66,NULL,NULL,1,'2023-10-27 10:59:23','2023-10-27 10:59:23',NULL),(951,7489,40724,7782,9,951,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1254982.93,NULL,NULL,1,'2023-10-27 11:01:55','2023-10-27 11:01:55',NULL),(952,7489,40724,7787,9,952,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',565547.89,NULL,NULL,1,'2023-10-27 11:45:08','2023-10-27 11:45:08',NULL),(953,7489,40724,7782,18,953,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',16113165.64,NULL,NULL,1,'2023-10-27 12:03:55','2023-10-27 12:03:55',NULL),(954,7489,40724,7783,21,664,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,664,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',49051507.80,NULL,NULL,1,'2023-10-27 12:56:30','2023-10-27 12:56:30',NULL),(955,7489,40724,7786,1,955,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-09-30',NULL,4749419.34,NULL,NULL,1,'2023-11-01 16:14:20','2023-11-01 16:14:20',NULL),(956,7489,40726,10913,1,956,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-09-30',NULL,199642.13,NULL,NULL,1,'2023-11-02 12:25:33','2023-11-02 12:25:33',NULL),(957,7489,40727,12530,1,957,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-09-30',NULL,400547.46,NULL,NULL,1,'2023-11-02 16:12:20','2023-11-02 16:12:20',NULL),(958,7489,40725,9361,1,958,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-09-30',NULL,316660.92,NULL,NULL,1,'2023-11-03 09:44:07','2023-11-03 09:44:07',NULL),(959,7489,40725,9362,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',9310.95,NULL,NULL,1,'2023-11-04 09:05:32','2023-11-04 09:05:32',NULL),(960,7489,40725,9362,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',9503.32,NULL,NULL,1,'2023-11-04 09:06:35','2023-11-04 09:06:35',NULL);
INSERT INTO `balance_libro` VALUES (961,7489,40725,9362,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',9024.73,NULL,NULL,1,'2023-11-04 09:07:24','2023-11-04 09:07:24',NULL),(962,7489,40725,9362,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',10926.41,NULL,NULL,1,'2023-11-04 09:08:04','2023-11-04 09:08:04',NULL),(963,7489,40725,9362,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',9880.10,NULL,NULL,1,'2023-11-04 09:10:49','2023-11-04 09:10:49',NULL),(964,7489,40725,9362,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',15098.55,NULL,NULL,1,'2023-11-04 09:12:08','2023-11-04 09:12:08',NULL),(965,7489,40725,9362,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',199183.78,NULL,NULL,1,'2023-11-04 09:15:41','2023-11-04 09:15:41',NULL),(966,7489,40728,14255,1,966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-09-30',NULL,737779.06,NULL,NULL,1,'2023-11-07 08:24:33','2023-11-07 08:24:33',NULL),(967,7489,40724,7778,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',39124623.21,NULL,NULL,1,'2023-11-11 09:14:19','2023-11-11 09:14:19',NULL),(968,7489,40724,7778,20,673,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,673,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',39124623.21,NULL,NULL,1,'2023-11-11 09:43:50','2023-11-11 09:43:50',NULL),(969,7489,40724,7780,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',52377784.72,NULL,NULL,1,'2023-11-11 09:46:24','2023-11-11 09:46:24',NULL),(970,7489,40724,7780,20,675,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,675,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',52377784.72,NULL,NULL,1,'2023-11-11 09:49:31','2023-11-11 09:49:31',NULL),(971,7489,40724,7779,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',39323838.32,NULL,NULL,1,'2023-11-11 09:55:35','2023-11-11 09:55:35',NULL),(972,7489,40724,7774,20,677,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,677,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',36137030.39,NULL,NULL,1,'2023-11-11 09:58:17','2023-11-11 09:58:17',NULL),(973,7489,40724,7779,20,678,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,678,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',34831057.50,NULL,NULL,1,'2023-11-11 10:00:39','2023-11-11 10:00:39',NULL),(974,7489,40724,7781,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',50997285.46,NULL,NULL,1,'2023-11-11 10:01:51','2023-11-11 10:01:51',NULL),(975,7489,40724,7781,20,680,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,680,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',50997285.46,NULL,NULL,1,'2023-11-11 10:03:50','2023-11-11 10:03:50',NULL),(976,7489,40724,7782,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',53550914.19,NULL,NULL,1,'2023-11-11 10:45:51','2023-11-11 10:45:51',NULL),(977,7489,40724,7782,20,682,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,682,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',53550914.19,NULL,NULL,1,'2023-11-11 10:48:03','2023-11-11 10:48:03',NULL),(978,7489,40724,7783,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',58887313.97,NULL,NULL,1,'2023-11-11 10:48:44','2023-11-11 10:48:44',NULL),(979,7489,40724,7783,20,684,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,684,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',58887313.97,NULL,NULL,1,'2023-11-11 10:50:40','2023-11-11 10:50:40',NULL),(980,7489,40725,9362,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',719587.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL),(981,7489,40725,9362,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',719587.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL);
INSERT INTO `balance_libro` VALUES (982,7489,40725,9362,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',719587.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL),(983,7489,40725,9362,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',45980.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL),(984,7489,40725,9362,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',86243.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:46:12','2023-11-13 08:46:12'),(985,7489,40725,9362,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',99673.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL),(986,7489,40725,9362,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',719587.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL),(987,7489,40725,9362,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',2125486.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL),(988,7489,40725,9362,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',92900.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL),(989,7489,40725,9362,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',399269.75,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL),(990,7489,40725,9362,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',138610.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:46:57','2023-11-13 08:46:57'),(991,7489,40725,9362,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',18150.00,NULL,NULL,1,'2023-11-13 08:44:27','2023-11-13 08:44:27',NULL),(992,7489,40725,9362,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',86243.00,NULL,NULL,1,'2023-11-13 08:46:12','2023-11-13 08:46:12',NULL),(993,7489,40725,9362,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',138610.00,NULL,NULL,1,'2023-11-13 08:46:57','2023-11-13 08:46:57',NULL),(994,7489,40725,9362,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',22990.00,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:50:09',NULL),(995,7489,40725,9362,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',79124.32,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:50:09',NULL),(996,7489,40725,9362,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',441507.22,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:50:09',NULL),(997,7489,40725,9362,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',5256.24,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:50:09',NULL),(998,7489,40725,9362,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',67125.96,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:50:09',NULL),(999,7489,40725,9362,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',5240.51,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:50:09',NULL),(1000,7489,40725,9362,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',6392.00,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:50:09',NULL),(1001,7489,40725,9362,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',6327.00,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:50:09',NULL),(1002,7489,40725,9362,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',12000.01,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:52:35','2023-11-13 08:52:35');
INSERT INTO `balance_libro` VALUES (1003,7489,40725,9362,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',200.00,NULL,NULL,1,'2023-11-13 08:50:09','2023-11-13 08:50:09',NULL),(1004,7489,40725,9362,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',50898.65,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:50:10',NULL),(1005,7489,40725,9362,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',64000.00,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:53:12','2023-11-13 08:53:12'),(1006,7489,40725,9362,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',173666.46,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:50:10',NULL),(1007,7489,40725,9362,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',45731.95,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:50:10',NULL),(1008,7489,40725,9362,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',18118.00,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:50:10',NULL),(1009,7489,40725,9362,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',98360.90,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:50:10',NULL),(1010,7489,40725,9362,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',20000.00,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:53:46','2023-11-13 08:53:46'),(1011,7489,40725,9362,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',130000.00,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:53:58','2023-11-13 08:53:58'),(1012,7489,40725,9362,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',130000.00,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:54:20','2023-11-13 08:54:20'),(1013,7489,40725,9362,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',42133.41,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:50:10',NULL),(1014,7489,40725,9362,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',819.83,NULL,NULL,1,'2023-11-13 08:50:10','2023-11-13 08:54:53','2023-11-13 08:54:53'),(1015,7489,40725,9362,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',12000.01,NULL,NULL,1,'2023-11-13 08:52:36','2023-11-13 08:52:36',NULL),(1016,7489,40725,9362,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',64000.00,NULL,NULL,1,'2023-11-13 08:53:12','2023-11-13 08:53:12',NULL),(1017,7489,40725,9362,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',20000.00,NULL,NULL,1,'2023-11-13 08:53:46','2023-11-13 08:53:46',NULL),(1018,7489,40725,9362,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',130000.00,NULL,NULL,1,'2023-11-13 08:53:58','2023-11-13 08:53:58',NULL),(1019,7489,40725,9362,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',130000.00,NULL,NULL,1,'2023-11-13 08:54:20','2023-11-13 08:54:20',NULL),(1020,7489,40725,9362,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',819.83,NULL,NULL,1,'2023-11-13 08:54:53','2023-11-13 08:54:53',NULL),(1021,7489,40724,7783,18,1021,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',328737304.16,'CMV',NULL,1,'2023-11-13 10:13:24','2023-11-13 15:40:35','2023-11-13 15:40:35'),(1022,7489,40724,7783,4,1022,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1465405.99,NULL,NULL,1,'2023-11-13 10:15:49','2023-11-13 15:14:35','2023-11-13 15:14:35');
INSERT INTO `balance_libro` VALUES (1023,7489,40724,7783,23,1023,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',0.00,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-11-13 14:27:00','2023-11-13 15:14:44','2023-11-13 15:14:44'),(1024,7489,40724,7783,23,1024,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',263708043.42,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-11-13 14:30:36','2023-11-13 15:59:38','2023-11-13 15:59:38'),(1025,7489,40724,7783,4,1025,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2941288.62,NULL,NULL,1,'2023-11-13 15:14:35','2023-11-13 15:14:35',NULL),(1026,7489,40724,7783,18,1026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',575947443.36,'CMV',NULL,1,'2023-11-13 15:40:35','2023-11-13 15:44:56','2023-11-13 15:44:56'),(1027,7489,40724,7783,18,1027,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',328737304.20,'CMV',NULL,1,'2023-11-13 15:44:56','2023-11-13 15:44:56',NULL),(1028,7489,40724,7783,23,1028,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',263708043.42,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-11-13 15:59:38','2023-11-13 16:04:24','2023-11-13 16:04:24'),(1029,7489,40724,7783,23,1029,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',263708043.42,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-11-13 16:04:24','2023-11-13 16:04:24',NULL),(1030,7489,40724,7787,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',74468675.92,NULL,NULL,1,'2023-11-21 09:51:47','2023-11-21 09:51:47',NULL),(1031,7489,40724,7787,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',70307972.76,NULL,NULL,1,'2023-11-21 09:55:32','2023-12-18 13:02:00','2023-12-18 13:02:00'),(1032,7489,40724,7787,15,1032,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',11745344.32,'Liquidacion mensual',NULL,1,'2023-11-21 09:59:14','2025-07-28 11:47:15','2025-07-28 11:47:15'),(1033,7489,40724,7787,16,1033,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1957557.30,'Liquidacion mensual',NULL,1,'2023-11-21 10:00:54','2023-11-21 10:00:54',NULL),(1034,7489,40727,12531,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',5000.00,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:24:46',NULL),(1035,7489,40727,12531,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',290432.99,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:24:46',NULL),(1036,7489,40727,12531,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',105163.22,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:28:07','2023-11-21 10:28:07'),(1037,7489,40727,12531,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1170059.00,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:24:46',NULL),(1038,7489,40727,12531,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',78023.82,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:29:14','2023-11-21 10:29:14'),(1039,7489,40727,12531,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',7680.00,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:24:46',NULL),(1040,7489,40727,12531,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',295313.34,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:24:46',NULL),(1041,7489,40727,12531,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',898825.64,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:24:46',NULL);
INSERT INTO `balance_libro` VALUES (1042,7489,40727,12531,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',887222.21,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:24:46',NULL),(1043,7489,40727,12531,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',5500.00,NULL,NULL,1,'2023-11-21 10:24:46','2023-11-21 10:24:46',NULL),(1044,7489,40727,12531,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',211222.22,NULL,NULL,1,'2023-11-21 10:24:47','2023-11-21 10:42:23','2023-11-21 10:42:23'),(1045,7489,40727,12531,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',6000.00,NULL,NULL,1,'2023-11-21 10:24:47','2023-11-21 10:24:47',NULL),(1046,7489,40727,12531,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4735.51,NULL,NULL,1,'2023-11-21 10:24:47','2023-11-21 10:24:47',NULL),(1047,7489,40727,12531,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',67738.46,NULL,NULL,1,'2023-11-21 10:24:47','2023-11-21 10:24:47',NULL),(1048,7489,40727,12531,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',116783.83,NULL,NULL,1,'2023-11-21 10:24:47','2023-11-21 10:24:47',NULL),(1049,7489,40727,12531,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',34062.14,NULL,NULL,1,'2023-11-21 10:24:47','2023-11-21 10:24:47',NULL),(1050,7489,40727,12531,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',105163.22,NULL,NULL,1,'2023-11-21 10:28:07','2023-11-21 10:28:07',NULL),(1051,7489,40727,12531,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',78023.82,NULL,NULL,1,'2023-11-21 10:29:14','2023-11-21 10:29:14',NULL),(1052,7489,40727,12531,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',211222.27,NULL,NULL,1,'2023-11-21 10:42:23','2023-11-21 10:42:23',NULL),(1053,7489,40727,12531,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',5083.00,NULL,NULL,1,'2023-11-21 10:44:32','2023-11-21 11:43:42','2023-11-21 11:43:42'),(1054,7489,40727,12531,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',5774.82,NULL,NULL,1,'2023-11-21 10:44:32','2023-11-21 11:43:08','2023-11-21 11:43:08'),(1055,7489,40727,12531,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',3472.54,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:42:32','2023-11-21 11:42:32'),(1056,7489,40727,12531,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',38032.09,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:41:54','2023-11-21 11:41:54'),(1057,7489,40727,12531,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',52512.10,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:41:12','2023-11-21 11:41:12'),(1058,7489,40727,12531,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',12632.79,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:40:40','2023-11-21 11:40:40'),(1059,7489,40727,12531,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',318456.78,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 10:44:33',NULL),(1060,7489,40727,12531,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',59019.54,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:39:52','2023-11-21 11:39:52'),(1061,7489,40727,12531,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',56580.03,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:39:16','2023-11-21 11:39:16');
INSERT INTO `balance_libro` VALUES (1062,7489,40727,12531,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',13016.27,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:38:43','2023-11-21 11:38:43'),(1063,7489,40727,12531,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',7414.32,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 12:23:27','2023-11-21 12:23:27'),(1064,7489,40727,12531,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-15','2023-10-15',16162.68,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 10:44:33',NULL),(1065,7489,40727,12531,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',32960.00,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 10:44:33',NULL),(1066,7489,40727,12531,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',137669.99,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:35:15','2023-11-21 11:35:15'),(1067,7489,40727,12531,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',21380.37,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:36:03','2023-11-21 11:36:03'),(1068,7489,40727,12531,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',17034.91,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:34:30','2023-11-21 11:34:30'),(1069,7489,40727,12531,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',20428.04,NULL,NULL,1,'2023-11-21 10:44:33','2023-11-21 11:33:33','2023-11-21 11:33:33'),(1070,7489,40727,12531,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',3472.54,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:32:51','2023-11-21 11:32:51'),(1071,7489,40727,12531,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',95040.34,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:31:59','2023-11-21 11:31:59'),(1072,7489,40727,12531,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',22115.45,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:31:01','2023-11-21 11:31:01'),(1073,7489,40727,12531,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',57113.97,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:28:45','2023-11-21 11:28:45'),(1074,7489,40727,12531,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',18215.00,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 10:44:34',NULL),(1075,7489,40727,12531,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',30433.17,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:27:38','2023-11-21 11:27:38'),(1076,7489,40727,12531,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',1006.48,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:28:07','2023-11-21 11:28:07'),(1077,7489,40727,12531,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',6428.60,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:26:40','2023-11-21 11:26:40'),(1078,7489,40727,12531,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',41681.60,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:25:46','2023-11-21 11:25:46'),(1079,7489,40727,12531,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',100340.06,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:25:06','2023-11-21 11:25:06'),(1080,7489,40727,12531,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',44412.37,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:24:24','2023-11-21 11:24:24');
INSERT INTO `balance_libro` VALUES (1081,7489,40727,12531,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',7500.00,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 10:44:34',NULL),(1082,7489,40727,12531,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',12000.00,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 10:44:34',NULL),(1083,7489,40727,12531,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-11-21 10:44:34','2023-11-21 11:23:18','2023-11-21 11:23:18'),(1084,7489,40727,12531,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',44412.37,NULL,NULL,1,'2023-11-21 11:24:24','2023-11-21 11:24:24',NULL),(1085,7489,40727,12531,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',100340.06,NULL,NULL,1,'2023-11-21 11:25:06','2023-11-21 11:25:06',NULL),(1086,7489,40727,12531,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',41681.60,NULL,NULL,1,'2023-11-21 11:25:46','2023-11-21 11:25:46',NULL),(1087,7489,40727,12531,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',6428.60,NULL,NULL,1,'2023-11-21 11:26:40','2023-11-21 11:29:14','2023-11-21 11:29:14'),(1088,7489,40727,12531,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',30433.17,NULL,NULL,1,'2023-11-21 11:27:38','2023-11-21 11:27:38',NULL),(1089,7489,40727,12531,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',1006.48,NULL,NULL,1,'2023-11-21 11:28:07','2023-11-21 11:28:07',NULL),(1090,7489,40727,12531,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',57113.97,NULL,NULL,1,'2023-11-21 11:28:45','2023-11-21 11:28:45',NULL),(1091,7489,40727,12531,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',6428.60,NULL,NULL,1,'2023-11-21 11:29:14','2023-11-21 11:29:14',NULL),(1092,7489,40727,12531,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',22115.45,NULL,NULL,1,'2023-11-21 11:31:01','2023-11-21 11:31:01',NULL),(1093,7489,40727,12531,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',95040.34,NULL,NULL,1,'2023-11-21 11:31:59','2023-11-21 11:31:59',NULL),(1094,7489,40727,12531,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',3472.54,NULL,NULL,1,'2023-11-21 11:32:51','2023-11-21 11:32:51',NULL),(1095,7489,40727,12531,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',20725.06,NULL,NULL,1,'2023-11-21 11:33:33','2023-11-21 12:27:05','2023-11-21 12:27:05'),(1096,7489,40727,12531,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',17034.91,NULL,NULL,1,'2023-11-21 11:34:30','2023-11-21 11:34:30',NULL),(1097,7489,40727,12531,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',137669.99,NULL,NULL,1,'2023-11-21 11:35:15','2023-11-21 11:35:15',NULL),(1098,7489,40727,12531,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',21380.37,NULL,NULL,1,'2023-11-21 11:36:03','2023-11-21 11:36:03',NULL),(1099,7489,40727,12531,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',13016.27,NULL,NULL,1,'2023-11-21 11:38:43','2023-11-21 11:38:43',NULL),(1100,7489,40727,12531,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',56580.03,NULL,NULL,1,'2023-11-21 11:39:16','2023-11-21 11:39:16',NULL),(1101,7489,40727,12531,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',59019.54,NULL,NULL,1,'2023-11-21 11:39:52','2023-11-21 11:39:52',NULL);
INSERT INTO `balance_libro` VALUES (1102,7489,40727,12531,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',12632.79,NULL,NULL,1,'2023-11-21 11:40:40','2023-11-21 11:40:40',NULL),(1103,7489,40727,12531,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',52512.10,NULL,NULL,1,'2023-11-21 11:41:12','2023-11-21 11:41:12',NULL),(1104,7489,40727,12531,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',38032.09,NULL,NULL,1,'2023-11-21 11:41:54','2023-11-21 11:41:54',NULL),(1105,7489,40727,12531,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',3472.54,NULL,NULL,1,'2023-11-21 11:42:32','2023-11-21 11:42:32',NULL),(1106,7489,40727,12531,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',5774.82,NULL,NULL,1,'2023-11-21 11:43:08','2023-11-21 11:43:08',NULL),(1107,7489,40727,12531,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',5083.00,NULL,NULL,1,'2023-11-21 11:43:42','2023-11-21 11:43:42',NULL),(1108,7489,40727,12531,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',7414.32,NULL,NULL,1,'2023-11-21 12:23:27','2023-11-21 12:23:27',NULL),(1109,7489,40727,12531,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',20428.04,NULL,NULL,1,'2023-11-21 12:27:05','2023-11-21 12:27:05',NULL),(1110,7489,40728,14256,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',89572.01,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1111,7489,40728,14256,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',163011.50,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1112,7489,40728,14256,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',157286.25,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1113,7489,40728,14256,2,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',202772.10,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1114,7489,40728,14256,2,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',271882.90,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1115,7489,40728,14256,2,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',90059.00,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1116,7489,40728,14256,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',139738.21,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1117,7489,40728,14256,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',148419.24,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1118,7489,40728,14256,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',127167.44,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1119,7489,40728,14256,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',147945.27,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1120,7489,40728,14256,2,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',186413.56,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1121,7489,40728,14256,2,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',140524.99,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1122,7489,40728,14256,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',217166.45,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL);
INSERT INTO `balance_libro` VALUES (1123,7489,40728,14256,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',286644.18,NULL,NULL,1,'2023-11-21 12:55:38','2023-11-21 12:55:38',NULL),(1124,7489,40728,14256,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',180709.45,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1125,7489,40728,14256,2,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',135720.99,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1126,7489,40728,14256,2,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',140656.15,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1127,7489,40728,14256,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',139743.29,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1128,7489,40728,14256,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',124829.18,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1129,7489,40728,14256,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',148261.52,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1130,7489,40728,14256,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',206460.71,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1131,7489,40728,14256,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',65803.62,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1132,7489,40728,14256,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',102209.00,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1133,7489,40728,14256,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',147926.44,NULL,NULL,1,'2023-11-21 12:55:39','2023-11-21 12:55:39',NULL),(1134,7489,40728,14256,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',6767315.72,NULL,NULL,1,'2023-11-21 14:11:44','2023-11-21 14:11:44',NULL),(1135,7489,40728,14256,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',57700.98,NULL,NULL,1,'2023-11-21 14:12:36','2023-11-21 14:12:36',NULL),(1136,7489,40728,14256,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',913712.18,NULL,NULL,1,'2023-11-21 14:13:28','2023-11-21 14:13:28',NULL),(1137,7489,40799,17253,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',87120.00,NULL,NULL,1,'2023-11-21 15:37:30','2023-11-21 15:37:30',NULL),(1138,7489,40799,17253,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',344850.00,NULL,NULL,1,'2023-11-21 15:37:30','2023-11-21 15:37:30',NULL),(1139,7489,40799,17253,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',96800.00,NULL,NULL,1,'2023-11-21 15:37:30','2023-11-21 15:37:30',NULL),(1140,7489,40799,17253,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',56628.00,NULL,NULL,1,'2023-11-21 15:37:30','2023-11-21 15:37:30',NULL),(1141,7489,40799,17253,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',7831.42,NULL,NULL,1,'2023-11-21 15:39:35','2023-11-21 15:46:06','2023-11-21 15:46:06'),(1142,7489,40799,17253,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',7839.30,NULL,NULL,1,'2023-11-21 15:39:35','2023-11-21 15:45:38','2023-11-21 15:45:38');
INSERT INTO `balance_libro` VALUES (1143,7489,40799,17253,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',73481.70,NULL,NULL,1,'2023-11-21 15:39:35','2023-11-21 15:41:39','2023-11-21 15:41:39'),(1144,7489,40799,17253,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',23354.72,NULL,NULL,1,'2023-11-21 15:39:35','2023-11-21 15:48:23','2023-11-21 15:48:23'),(1145,7489,40799,17253,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',15707.74,NULL,NULL,1,'2023-11-21 15:39:35','2023-11-21 15:45:09','2023-11-21 15:45:09'),(1146,7489,40799,17253,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',33830.75,NULL,NULL,1,'2023-11-21 15:39:35','2023-11-21 15:44:43','2023-11-21 15:44:43'),(1147,7489,40799,17253,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',40000.00,NULL,NULL,1,'2023-11-21 15:39:35','2023-11-21 15:42:06','2023-11-21 15:42:06'),(1148,7489,40799,17253,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',4345.31,NULL,NULL,1,'2023-11-21 15:39:35','2023-11-21 15:48:49','2023-11-21 15:48:49'),(1149,7489,40799,17253,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',76160.80,NULL,NULL,1,'2023-11-21 15:39:35','2023-11-21 15:42:51','2023-11-21 15:42:51'),(1150,7489,40799,17253,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',73481.70,NULL,NULL,1,'2023-11-21 15:41:39','2023-11-21 15:41:39',NULL),(1151,7489,40799,17253,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',40000.00,NULL,NULL,1,'2023-11-21 15:42:06','2023-11-21 15:42:06',NULL),(1152,7489,40799,17253,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',76160.80,NULL,NULL,1,'2023-11-21 15:42:51','2023-11-21 15:42:51',NULL),(1153,7489,40799,17253,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',33830.75,NULL,NULL,1,'2023-11-21 15:44:43','2023-11-21 15:44:43',NULL),(1154,7489,40799,17253,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',15707.74,NULL,NULL,1,'2023-11-21 15:45:09','2023-11-21 15:45:09',NULL),(1155,7489,40799,17253,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',7839.30,NULL,NULL,1,'2023-11-21 15:45:38','2023-11-21 15:45:38',NULL),(1156,7489,40799,17253,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',7831.42,NULL,NULL,1,'2023-11-21 15:46:06','2023-11-21 15:46:06',NULL),(1157,7489,40799,17253,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',23354.72,NULL,NULL,1,'2023-11-21 15:48:23','2023-11-21 15:48:23',NULL),(1158,7489,40799,17253,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',4345.31,NULL,NULL,1,'2023-11-21 15:48:49','2023-11-21 15:48:49',NULL),(1159,7489,40799,17253,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',107458.21,NULL,NULL,1,'2023-11-21 15:51:32','2023-11-21 15:51:32',NULL),(1160,7489,40724,7788,9,1160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',356304.75,NULL,NULL,1,'2023-11-27 14:40:04','2023-11-27 14:40:04',NULL),(1161,7489,40725,9363,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',266279.79,NULL,NULL,1,'2023-11-28 10:58:24','2023-11-28 10:58:24',NULL),(1162,7489,40725,9363,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',266279.79,NULL,NULL,1,'2023-11-28 10:58:53','2023-11-28 10:58:53',NULL);
INSERT INTO `balance_libro` VALUES (1163,7489,40724,7787,1,1163,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-10-31',NULL,5367517.25,NULL,NULL,1,'2023-12-02 08:33:28','2023-12-02 08:33:28',NULL),(1164,7489,40726,10914,1,1164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-10-31',NULL,247220.20,NULL,NULL,1,'2023-12-02 11:31:47','2023-12-02 11:31:47',NULL),(1165,7489,40727,12531,1,1165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-10-31',NULL,403503.61,NULL,NULL,1,'2023-12-04 10:59:41','2023-12-04 10:59:41',NULL),(1166,7489,40728,14256,1,1166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-10-31',NULL,940564.08,NULL,NULL,1,'2023-12-07 09:30:56','2023-12-07 09:30:56',NULL),(1167,7489,40725,9362,1,1167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-10-31',NULL,300414.44,NULL,NULL,1,'2023-12-07 12:05:48','2023-12-07 12:05:48',NULL),(1168,7489,40725,9363,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',86243.00,NULL,NULL,1,'2023-12-15 08:18:01','2023-12-15 08:21:36','2023-12-15 08:21:36'),(1169,7489,40725,9363,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',99673.00,NULL,NULL,1,'2023-12-15 08:18:01','2023-12-15 08:18:01',NULL),(1170,7489,40725,9363,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',278663.00,NULL,NULL,1,'2023-12-15 08:18:01','2023-12-15 08:18:01',NULL),(1171,7489,40725,9363,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',92900.00,NULL,NULL,1,'2023-12-15 08:18:02','2023-12-15 08:18:02',NULL),(1172,7489,40725,9363,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',399269.75,NULL,NULL,1,'2023-12-15 08:18:02','2023-12-15 08:18:02',NULL),(1173,7489,40725,9363,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',2125486.00,NULL,NULL,1,'2023-12-15 08:18:02','2023-12-15 08:18:02',NULL),(1174,7489,40725,9363,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',86243.00,NULL,NULL,1,'2023-12-15 08:21:36','2023-12-15 08:21:36',NULL),(1175,7489,40725,9363,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',229579.35,NULL,NULL,1,'2023-12-15 08:28:51','2023-12-15 08:28:51',NULL),(1176,7489,40725,9363,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',18079.00,NULL,NULL,1,'2023-12-15 08:28:51','2023-12-15 08:28:51',NULL),(1177,7489,40725,9363,3,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',65753.82,NULL,NULL,1,'2023-12-15 08:28:51','2023-12-15 08:28:51',NULL),(1178,7489,40725,9363,3,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',209121.28,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1179,7489,40725,9363,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',177909.93,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1180,7489,40725,9363,3,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',161172.00,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1181,7489,40725,9363,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',9599.95,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-18 08:19:04','2023-12-18 08:19:04'),(1182,7489,40725,9363,3,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',176950.40,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1183,7489,40725,9363,3,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',6013.70,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL);
INSERT INTO `balance_libro` VALUES (1184,7489,40725,9363,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',296070.00,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1185,7489,40725,9363,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',409.92,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1186,7489,40725,9363,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',67025.28,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-16 12:45:16','2023-12-16 12:45:16'),(1187,7489,40725,9363,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',22615.44,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1188,7489,40725,9363,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',75033.31,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1189,7489,40725,9363,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',43007.03,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1190,7489,40725,9363,3,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1434.71,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1191,7489,40725,9363,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',6013.70,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:28:52',NULL),(1192,7489,40725,9363,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-12-15 08:28:52','2023-12-15 08:35:03','2023-12-15 08:35:03'),(1193,7489,40727,12532,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',290039.70,NULL,NULL,1,'2023-12-15 09:07:22','2023-12-15 09:07:22',NULL),(1194,7489,40727,12532,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',941479.62,NULL,NULL,1,'2023-12-15 09:07:22','2023-12-15 09:07:22',NULL),(1195,7489,40727,12532,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',43506.00,NULL,NULL,1,'2023-12-15 09:07:22','2023-12-15 09:07:22',NULL),(1196,7489,40727,12532,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',4000.00,NULL,NULL,1,'2023-12-15 09:07:22','2023-12-15 09:09:07','2023-12-15 09:09:07'),(1197,7489,40727,12532,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',355555.94,NULL,NULL,1,'2023-12-15 09:07:22','2023-12-15 09:10:59','2023-12-15 09:10:59'),(1198,7489,40727,12532,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',658916.09,NULL,NULL,1,'2023-12-15 09:07:23','2023-12-15 09:07:23',NULL),(1199,7489,40727,12532,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',4000.00,NULL,NULL,1,'2023-12-15 09:09:07','2023-12-15 09:09:07',NULL),(1200,7489,40727,12532,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',355555.95,NULL,NULL,1,'2023-12-15 09:10:59','2023-12-15 09:10:59',NULL),(1201,7489,40727,12532,3,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',230237.39,NULL,NULL,1,'2023-12-15 09:13:19','2023-12-15 09:13:19',NULL),(1202,7489,40727,12532,3,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',15585.88,NULL,NULL,1,'2023-12-15 09:13:19','2023-12-15 09:13:19',NULL),(1203,7489,40727,12532,3,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',18170.99,NULL,NULL,1,'2023-12-15 09:13:19','2023-12-15 09:13:19',NULL);
INSERT INTO `balance_libro` VALUES (1204,7489,40727,12532,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',18759.48,NULL,NULL,1,'2023-12-15 09:13:19','2023-12-15 09:13:19',NULL),(1205,7489,40727,12532,3,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',65095.01,NULL,NULL,1,'2023-12-15 09:13:19','2023-12-15 09:13:19',NULL),(1206,7489,40727,12532,3,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',16124.46,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1207,7489,40727,12532,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2000.00,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1208,7489,40727,12532,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',3102.52,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1209,7489,40727,12532,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',14111.95,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1210,7489,40727,12532,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',33980.00,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1211,7489,40727,12532,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',84497.35,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1212,7489,40727,12532,3,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',24970.53,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1213,7489,40727,12532,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',38455.95,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1214,7489,40727,12532,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',57406.01,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1215,7489,40727,12532,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',23956.19,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1216,7489,40727,12532,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',30592.02,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1217,7489,40727,12532,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',6372.85,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1218,7489,40727,12532,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',22575.29,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:19:33','2023-12-15 09:19:33'),(1219,7489,40727,12532,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',102057.99,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1220,7489,40727,12532,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',30680.64,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1221,7489,40727,12532,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',79911.57,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1222,7489,40727,12532,3,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',35500.00,NULL,NULL,1,'2023-12-15 09:13:20','2023-12-15 09:13:20',NULL),(1223,7489,40727,12532,3,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',39169.66,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:13:21',NULL),(1224,7489,40727,12532,3,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',25092.40,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:13:21',NULL);
INSERT INTO `balance_libro` VALUES (1225,7489,40727,12532,3,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',79580.57,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:13:21',NULL),(1226,7489,40727,12532,3,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',6800.20,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:13:21',NULL),(1227,7489,40727,12532,3,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',70401.95,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:13:21',NULL),(1228,7489,40727,12532,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',12500.00,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:18:39','2023-12-15 09:18:39'),(1229,7489,40727,12532,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2669.26,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:18:08','2023-12-15 09:18:08'),(1230,7489,40727,12532,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',30000.00,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:17:52','2023-12-15 09:17:52'),(1231,7489,40727,12532,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',195000.00,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:17:34','2023-12-15 09:17:34'),(1232,7489,40727,12532,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',30000.00,NULL,NULL,1,'2023-12-15 09:13:21','2023-12-15 09:17:08','2023-12-15 09:17:08'),(1233,7489,40727,12532,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',30000.00,NULL,NULL,1,'2023-12-15 09:17:08','2023-12-15 09:17:08',NULL),(1234,7489,40727,12532,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',195000.00,NULL,NULL,1,'2023-12-15 09:17:34','2023-12-15 09:17:34',NULL),(1235,7489,40727,12532,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',30000.00,NULL,NULL,1,'2023-12-15 09:17:52','2023-12-15 09:17:52',NULL),(1236,7489,40727,12532,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',2669.26,NULL,NULL,1,'2023-12-15 09:18:08','2023-12-15 09:18:08',NULL),(1237,7489,40727,12532,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',12500.00,NULL,NULL,1,'2023-12-15 09:18:39','2023-12-15 09:18:39',NULL),(1238,7489,40727,12532,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',22885.21,NULL,NULL,1,'2023-12-15 09:19:33','2023-12-18 09:33:45','2023-12-18 09:33:45'),(1239,7489,40728,14257,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',56790.41,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1240,7489,40728,14257,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',59644.44,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1241,7489,40728,14257,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',7270.73,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1242,7489,40728,14257,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',94615.40,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1243,7489,40728,14257,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',21854.52,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1244,7489,40728,14257,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',343278.11,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL);
INSERT INTO `balance_libro` VALUES (1245,7489,40728,14257,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',15145.33,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1246,7489,40728,14257,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',155461.01,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1247,7489,40728,14257,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',118205.30,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1248,7489,40728,14257,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',63944.46,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1249,7489,40728,14257,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',230132.98,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1250,7489,40728,14257,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',13339.22,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1251,7489,40728,14257,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',42144.29,NULL,NULL,1,'2023-12-15 09:28:08','2023-12-15 09:28:08',NULL),(1252,7489,40728,14257,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',5440.15,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1253,7489,40728,14257,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',245590.85,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1254,7489,40728,14257,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',1602.56,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1255,7489,40728,14257,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',3333.53,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1256,7489,40728,14257,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',297097.54,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1257,7489,40728,14257,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',278816.35,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1258,7489,40728,14257,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',20235.61,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1259,7489,40728,14257,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',68508.44,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1260,7489,40728,14257,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',5499.16,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1261,7489,40728,14257,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',25175.35,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1262,7489,40728,14257,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',38989.79,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1263,7489,40728,14257,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',20369.31,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1264,7489,40728,14257,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',6223.12,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1265,7489,40728,14257,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',941.64,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL);
INSERT INTO `balance_libro` VALUES (1266,7489,40728,14257,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',39491.05,NULL,NULL,1,'2023-12-15 09:28:09','2023-12-15 09:28:09',NULL),(1267,7489,40728,14257,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',4128.60,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1268,7489,40728,14257,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',285265.46,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1269,7489,40728,14257,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',57709.80,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1270,7489,40728,14257,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',1872.52,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1271,7489,40728,14257,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',156531.01,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1272,7489,40728,14257,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',324749.23,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1273,7489,40728,14257,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',8403.19,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1274,7489,40728,14257,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',51264.50,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1275,7489,40728,14257,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',350576.61,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1276,7489,40728,14257,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',94878.78,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1277,7489,40728,14257,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',9627.29,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1278,7489,40728,14257,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',127637.48,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1279,7489,40728,14257,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',15202.17,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1280,7489,40728,14257,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',204317.17,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1281,7489,40728,14257,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',125233.94,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1282,7489,40728,14257,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',82593.28,NULL,NULL,1,'2023-12-15 09:28:10','2023-12-15 09:28:10',NULL),(1283,7489,40728,14257,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',22937.79,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1284,7489,40728,14257,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',23817.32,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1285,7489,40728,14257,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',6389.90,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1286,7489,40728,14257,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',268882.05,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL);
INSERT INTO `balance_libro` VALUES (1287,7489,40728,14257,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',3768.29,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1288,7489,40728,14257,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',12735.10,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1289,7489,40728,14257,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',5751.03,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1290,7489,40728,14257,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',6263.86,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1291,7489,40728,14257,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',3985.63,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1292,7489,40728,14257,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',3985.96,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1293,7489,40728,14257,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',175517.72,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1294,7489,40728,14257,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',280775.49,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1295,7489,40728,14257,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',327281.06,NULL,NULL,1,'2023-12-15 09:28:11','2023-12-15 09:28:11',NULL),(1296,7489,40728,14257,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',167171.74,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1297,7489,40728,14257,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',77466.33,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1298,7489,40728,14257,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',2845.49,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1299,7489,40728,14257,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',10979.90,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1300,7489,40728,14257,3,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',166853.28,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1301,7489,40728,14257,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',299268.26,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1302,7489,40728,14257,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',66689.39,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1303,7489,40728,14257,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',12864.85,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1304,7489,40728,14257,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',4396.05,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1305,7489,40728,14257,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',17621.74,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1306,7489,40728,14257,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',26285.64,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1307,7489,40728,14257,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',1412.46,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL);
INSERT INTO `balance_libro` VALUES (1308,7489,40728,14257,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',47505.27,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1309,7489,40728,14257,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',26584.62,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1310,7489,40728,14257,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',110730.65,NULL,NULL,1,'2023-12-15 09:28:12','2023-12-15 09:28:12',NULL),(1311,7489,40728,14257,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',77321.07,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1312,7489,40728,14257,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',164214.13,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1313,7489,40728,14257,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',177698.24,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1314,7489,40728,14257,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',7545.94,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1315,7489,40728,14257,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',234257.68,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1316,7489,40728,14257,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',9816.92,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1317,7489,40728,14257,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',40118.99,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1318,7489,40728,14257,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',188925.40,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1319,7489,40728,14257,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',303439.47,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1320,7489,40728,14257,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',3316.22,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1321,7489,40728,14257,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',49060.56,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1322,7489,40728,14257,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',2331.10,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1323,7489,40728,14257,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',26894.66,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1324,7489,40728,14257,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',6370.36,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1325,7489,40728,14257,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',3043.72,NULL,NULL,1,'2023-12-15 09:28:13','2023-12-15 09:28:13',NULL),(1326,7489,40728,14257,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',127006.93,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1327,7489,40728,14257,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',46354.70,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1328,7489,40728,14257,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',227340.94,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL);
INSERT INTO `balance_libro` VALUES (1329,7489,40728,14257,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',378917.46,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1330,7489,40728,14257,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',230703.05,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1331,7489,40728,14257,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',10394.13,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1332,7489,40728,14257,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',100210.83,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1333,7489,40728,14257,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',149887.45,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1334,7489,40728,14257,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',221204.21,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1335,7489,40728,14257,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',151505.65,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1336,7489,40728,14257,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',125539.00,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1337,7489,40728,14257,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',5440.15,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1338,7489,40728,14257,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',2535.09,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1339,7489,40728,14257,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',19460.59,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1340,7489,40728,14257,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',6437.68,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1341,7489,40728,14257,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',30227.37,NULL,NULL,1,'2023-12-15 09:28:14','2023-12-15 09:28:14',NULL),(1342,7489,40728,14257,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',7340.99,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1343,7489,40728,14257,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',212454.80,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1344,7489,40728,14257,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1476.42,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1345,7489,40728,14257,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',133176.49,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1346,7489,40728,14257,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',2475.39,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1347,7489,40728,14257,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',19524.03,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1348,7489,40728,14257,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',2603.15,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1349,7489,40728,14257,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4057.41,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL);
INSERT INTO `balance_libro` VALUES (1350,7489,40728,14257,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',59021.85,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1351,7489,40728,14257,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',2438.16,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1352,7489,40728,14257,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',1972.50,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1353,7489,40728,14257,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3942.55,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1354,7489,40728,14257,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',18265.33,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1355,7489,40728,14257,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',1838.76,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1356,7489,40728,14257,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',149774.48,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1357,7489,40728,14257,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',1048.60,NULL,NULL,1,'2023-12-15 09:28:15','2023-12-15 09:28:15',NULL),(1358,7489,40728,14257,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',865.79,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1359,7489,40728,14257,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',107213.39,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1360,7489,40728,14257,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',75859.87,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1361,7489,40728,14257,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',15668.77,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1362,7489,40728,14257,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',273503.16,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1363,7489,40728,14257,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',177263.54,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1364,7489,40728,14257,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',15451.42,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1365,7489,40728,14257,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',21219.03,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1366,7489,40728,14257,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',155919.61,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1367,7489,40728,14257,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',3391.95,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1368,7489,40728,14257,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',7348.19,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1369,7489,40728,14257,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',231442.94,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1370,7489,40728,14257,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',269416.67,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL);
INSERT INTO `balance_libro` VALUES (1371,7489,40728,14257,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',238799.19,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1372,7489,40728,14257,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',6900.31,NULL,NULL,1,'2023-12-15 09:28:16','2023-12-15 09:28:16',NULL),(1373,7489,40728,14257,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',17023.05,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1374,7489,40728,14257,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',547.77,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1375,7489,40728,14257,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',234915.11,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1376,7489,40728,14257,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',13177.77,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1377,7489,40728,14257,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',27852.77,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1378,7489,40728,14257,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',1048.60,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1379,7489,40728,14257,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',93642.29,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1380,7489,40728,14257,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',5440.15,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1381,7489,40728,14257,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',131343.39,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1382,7489,40728,14257,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1256.24,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1383,7489,40728,14257,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',5422.59,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1384,7489,40728,14257,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',8261.97,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1385,7489,40728,14257,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3600.55,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1386,7489,40728,14257,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',221655.30,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1387,7489,40728,14257,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',27447.90,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1388,7489,40728,14257,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3335.41,NULL,NULL,1,'2023-12-15 09:28:17','2023-12-15 09:28:17',NULL),(1389,7489,40728,14257,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',22507.23,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1390,7489,40728,14257,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',6989.15,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1391,7489,40728,14257,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',8152.98,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL);
INSERT INTO `balance_libro` VALUES (1392,7489,40728,14257,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',225387.20,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1393,7489,40728,14257,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',89156.37,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1394,7489,40728,14257,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',45000.00,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1395,7489,40728,14257,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',142572.00,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1396,7489,40728,14257,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',22770.00,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1397,7489,40728,14257,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',1718.96,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1398,7489,40728,14257,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',16989.07,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1399,7489,40728,14257,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',18605.21,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1400,7489,40728,14257,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',8099.32,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1401,7489,40728,14257,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',100549.11,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1402,7489,40728,14257,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',21765.34,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1403,7489,40728,14257,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',10103.08,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1404,7489,40728,14257,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',5030.86,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1405,7489,40728,14257,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',7365.22,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1406,7489,40728,14257,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',11504.40,NULL,NULL,1,'2023-12-15 09:28:18','2023-12-15 09:28:18',NULL),(1407,7489,40728,14257,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',38989.79,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1408,7489,40728,14257,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',4076.04,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1409,7489,40728,14257,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',2309600.65,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1410,7489,40728,14257,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',9527.85,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1411,7489,40728,14257,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',928677.61,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1412,7489,40728,14257,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',3158.12,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL);
INSERT INTO `balance_libro` VALUES (1413,7489,40728,14257,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',2936.07,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1414,7489,40728,14257,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',6104.98,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1415,7489,40728,14257,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',8236.63,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1416,7489,40728,14257,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',33853.50,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1417,7489,40728,14257,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',20695.77,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1418,7489,40728,14257,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',23426.70,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1419,7489,40728,14257,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',20666.84,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1420,7489,40728,14257,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',7940.45,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1421,7489,40728,14257,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',750.40,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1422,7489,40728,14257,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',4667.23,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1423,7489,40728,14257,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',3084627.55,NULL,NULL,1,'2023-12-15 09:28:19','2023-12-15 09:28:19',NULL),(1424,7489,40728,14257,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',61230.68,NULL,NULL,1,'2023-12-15 09:28:20','2023-12-15 09:28:20',NULL),(1425,7489,40728,14257,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',1104674.89,NULL,NULL,1,'2023-12-15 09:28:20','2023-12-15 09:28:20',NULL),(1426,7489,40728,14257,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',17530.92,NULL,NULL,1,'2023-12-15 09:28:20','2023-12-15 09:28:20',NULL),(1427,7489,40728,14257,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',3576.96,NULL,NULL,1,'2023-12-15 09:28:20','2023-12-15 09:28:20',NULL),(1428,7489,40728,14257,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',6969.30,NULL,NULL,1,'2023-12-15 09:28:20','2023-12-15 09:28:20',NULL),(1429,7489,40728,14257,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',12743.74,NULL,NULL,1,'2023-12-15 09:28:20','2023-12-15 09:28:20',NULL),(1430,7489,40728,14257,2,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',192374.00,NULL,NULL,1,'2023-12-16 09:15:34','2023-12-16 09:15:34',NULL),(1431,7489,40728,14257,2,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',39330.00,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1432,7489,40728,14257,2,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',194872.05,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1433,7489,40728,14257,2,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',113435.18,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL);
INSERT INTO `balance_libro` VALUES (1434,7489,40728,14257,2,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',304494.12,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1435,7489,40728,14257,2,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',112317.49,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1436,7489,40728,14257,2,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',215991.02,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1437,7489,40728,14257,2,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',212609.08,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1438,7489,40728,14257,2,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',71735.95,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1439,7489,40728,14257,2,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',177337.00,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1440,7489,40728,14257,2,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',175918.11,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1441,7489,40728,14257,2,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',129121.80,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1442,7489,40728,14257,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',175704.00,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1443,7489,40728,14257,2,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',100779.60,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1444,7489,40728,14257,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',164556.12,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1445,7489,40728,14257,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',102996.00,NULL,NULL,1,'2023-12-16 09:15:35','2023-12-16 09:15:35',NULL),(1446,7489,40728,14257,2,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',121104.01,NULL,NULL,1,'2023-12-16 09:15:36','2023-12-16 09:15:36',NULL),(1447,7489,40728,14257,2,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',223633.00,NULL,NULL,1,'2023-12-16 09:15:36','2023-12-16 09:15:36',NULL),(1448,7489,40728,14257,2,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',267678.06,NULL,NULL,1,'2023-12-16 09:15:36','2023-12-16 09:15:36',NULL),(1449,7489,40728,14257,2,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',276283.76,NULL,NULL,1,'2023-12-16 09:15:36','2023-12-16 09:15:36',NULL),(1450,7489,40728,14257,2,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',123074.23,NULL,NULL,1,'2023-12-16 09:15:36','2023-12-16 09:15:36',NULL),(1451,7489,40728,14257,2,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',127857.01,NULL,NULL,1,'2023-12-16 09:15:36','2023-12-16 09:15:36',NULL),(1452,7489,40728,14257,2,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',145638.00,NULL,NULL,1,'2023-12-16 09:15:36','2023-12-16 09:15:36',NULL),(1453,7489,40728,14257,2,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',126864.00,NULL,NULL,1,'2023-12-16 09:15:36','2023-12-16 09:15:36',NULL),(1454,7489,40728,14257,2,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',146625.18,NULL,NULL,1,'2023-12-16 09:15:36','2023-12-16 09:15:36',NULL);
INSERT INTO `balance_libro` VALUES (1455,7489,40728,14257,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',7066154.06,NULL,NULL,1,'2023-12-16 09:34:24','2023-12-16 09:34:24',NULL),(1456,7489,40728,14257,2,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',63721.10,NULL,NULL,1,'2023-12-16 09:35:07','2023-12-16 09:35:07',NULL),(1457,7489,40728,14257,2,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',953787.91,NULL,NULL,1,'2023-12-16 09:35:42','2023-12-16 09:35:42',NULL),(1458,7489,40725,9363,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',67025.30,NULL,NULL,1,'2023-12-16 12:45:16','2023-12-16 12:45:16',NULL),(1459,7489,40725,9363,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',9599.97,NULL,NULL,1,'2023-12-18 08:19:04','2023-12-18 08:19:04',NULL),(1460,7489,40725,9363,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',10111.99,NULL,NULL,1,'2023-12-18 08:43:31','2024-01-11 10:25:17','2024-01-11 10:25:17'),(1461,7489,40725,9363,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',6000.00,NULL,NULL,1,'2023-12-18 08:44:43','2024-01-11 10:25:08','2024-01-11 10:25:08'),(1462,7489,40727,12532,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',22885.21,NULL,NULL,1,'2023-12-18 09:33:45','2023-12-18 09:33:45',NULL),(1463,7489,40724,7788,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',9568096.09,NULL,NULL,1,'2023-12-18 09:59:04','2023-12-18 13:01:19','2023-12-18 13:01:19'),(1464,7489,40799,17254,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',96800.00,NULL,NULL,1,'2023-12-18 10:07:35','2023-12-18 10:07:35',NULL),(1465,7489,40799,17254,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',302500.00,NULL,NULL,1,'2023-12-18 10:07:35','2023-12-18 10:07:35',NULL),(1466,7489,40799,17254,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',56628.00,NULL,NULL,1,'2023-12-18 10:07:35','2023-12-18 10:07:35',NULL),(1467,7489,40799,17254,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',9093.59,NULL,NULL,1,'2023-12-18 10:07:50','2023-12-18 10:12:45','2023-12-18 10:12:45'),(1468,7489,40799,17254,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',9084.45,NULL,NULL,1,'2023-12-18 10:07:50','2023-12-18 10:13:04','2023-12-18 10:13:04'),(1469,7489,40799,17254,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',65925.70,NULL,NULL,1,'2023-12-18 10:07:51','2023-12-18 10:11:24','2023-12-18 10:11:24'),(1470,7489,40799,17254,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',10000.00,NULL,NULL,1,'2023-12-18 10:07:51','2023-12-18 10:13:50','2023-12-18 10:13:50'),(1471,7489,40799,17254,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',4732.00,NULL,NULL,1,'2023-12-18 10:07:51','2023-12-18 10:14:25','2023-12-18 10:14:25'),(1472,7489,40799,17254,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',54662.80,NULL,NULL,1,'2023-12-18 10:07:51','2023-12-18 10:12:12','2023-12-18 10:12:12'),(1473,7489,40799,17254,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',21631.63,NULL,NULL,1,'2023-12-18 10:07:51','2023-12-18 10:14:51','2023-12-18 10:14:51'),(1474,7489,40799,17254,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',65925.70,NULL,NULL,1,'2023-12-18 10:11:24','2023-12-18 10:13:26','2023-12-18 10:13:26');
INSERT INTO `balance_libro` VALUES (1475,7489,40799,17254,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',54662.80,NULL,NULL,1,'2023-12-18 10:12:12','2023-12-18 10:12:12',NULL),(1476,7489,40799,17254,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',9093.59,NULL,NULL,1,'2023-12-18 10:12:45','2023-12-18 10:12:45',NULL),(1477,7489,40799,17254,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',9084.45,NULL,NULL,1,'2023-12-18 10:13:04','2023-12-18 10:13:04',NULL),(1478,7489,40799,17254,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',65925.70,NULL,NULL,1,'2023-12-18 10:13:26','2023-12-18 10:13:26',NULL),(1479,7489,40799,17254,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',10000.00,NULL,NULL,1,'2023-12-18 10:13:50','2023-12-18 10:13:50',NULL),(1480,7489,40799,17254,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',4732.00,NULL,NULL,1,'2023-12-18 10:14:25','2023-12-18 10:14:25',NULL),(1481,7489,40799,17254,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',21631.63,NULL,NULL,1,'2023-12-18 10:14:51','2023-12-18 10:14:51',NULL),(1482,7489,40799,17254,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',9220.97,NULL,NULL,1,'2023-12-18 10:16:51','2023-12-18 10:16:51',NULL),(1483,7489,40724,7788,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',80146547.01,NULL,NULL,1,'2023-12-18 13:01:19','2023-12-18 13:01:19',NULL),(1484,7489,40724,7787,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',70307972.76,NULL,NULL,1,'2023-12-18 13:02:00','2023-12-18 13:02:00',NULL),(1485,7489,40724,7788,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',86958709.21,NULL,NULL,1,'2023-12-18 13:05:09','2023-12-18 13:05:09',NULL),(1486,7489,40724,7788,16,1486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',2366366.53,'Liquidacion mensual',NULL,1,'2023-12-18 13:09:05','2023-12-18 13:09:05',NULL),(1487,7489,40724,7788,15,1487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',14496671.02,'Liquidacion mensual',NULL,1,'2023-12-18 13:13:43','2023-12-18 13:13:43',NULL),(1488,7489,40724,7788,1,1488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-11-30',NULL,5741627.76,NULL,NULL,1,'2023-12-19 09:26:25','2023-12-19 09:26:25',NULL),(1489,7489,40725,9363,1,1489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-11-30',NULL,444601.32,NULL,NULL,1,'2023-12-22 12:23:16','2023-12-22 12:23:16',NULL),(1490,7489,40727,12532,1,1490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-11-30',NULL,469758.05,NULL,NULL,1,'2024-01-04 15:51:18','2024-01-04 15:51:18',NULL),(1491,7489,40724,7793,9,1491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',2632071.32,'COMPENSACION iNTERESES',NULL,1,'2024-01-05 15:45:34','2024-01-05 15:45:34',NULL),(1492,7489,40724,7783,11,1492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3577099.87,NULL,NULL,1,'2024-01-06 09:47:49','2024-01-06 09:48:32','2024-01-06 09:48:32'),(1493,7489,40724,7783,11,1493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3577099.87,'Errores  de imputación',NULL,1,'2024-01-06 09:48:32','2024-01-06 09:48:32',NULL),(1494,7489,40728,14257,1,1494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-11-30',NULL,1000293.34,NULL,NULL,1,'2024-01-08 10:24:20','2024-01-08 10:24:20',NULL);
INSERT INTO `balance_libro` VALUES (1495,7489,40728,14258,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',218837.79,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1496,7489,40728,14258,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',89772.00,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1497,7489,40728,14258,2,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',236018.76,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1498,7489,40728,14258,2,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',238598.85,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1499,7489,40728,14258,2,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',361001.96,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1500,7489,40728,14258,2,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',298992.89,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1501,7489,40728,14258,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',76048.65,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:48:27','2024-01-10 15:48:27'),(1502,7489,40728,14258,2,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',286360.49,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1503,7489,40728,14258,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',175951.45,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1504,7489,40728,14258,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',263046.87,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1505,7489,40728,14258,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',180292.43,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1506,7489,40728,14258,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',322057.00,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1507,7489,40728,14258,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',241955.36,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1508,7489,40728,14258,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',248104.68,NULL,NULL,1,'2024-01-10 15:38:45','2024-01-10 15:38:45',NULL),(1509,7489,40728,14258,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',40935.95,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1510,7489,40728,14258,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',191151.00,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1511,7489,40728,14258,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',248351.64,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1512,7489,40728,14258,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',180274.80,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1513,7489,40728,14258,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',440847.69,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1514,7489,40728,14258,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',205609.92,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL);
INSERT INTO `balance_libro` VALUES (1515,7489,40728,14258,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',204239.89,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1516,7489,40728,14258,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',302009.84,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1517,7489,40728,14258,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',177128.00,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1518,7489,40728,14258,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',245497.45,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1519,7489,40728,14258,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',55233.00,NULL,NULL,1,'2024-01-10 15:38:46','2024-01-10 15:38:46',NULL),(1520,7489,40728,14258,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',76081.00,NULL,NULL,1,'2024-01-10 15:48:27','2024-01-10 15:48:27',NULL),(1521,7489,40728,14258,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',0.01,NULL,NULL,1,'2024-01-11 08:54:01','2024-01-11 08:54:01',NULL),(1522,7489,40728,14258,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',295277.76,NULL,NULL,1,'2024-01-11 08:54:01','2024-01-11 08:54:01',NULL),(1523,7489,40728,14258,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',140900.98,NULL,NULL,1,'2024-01-11 08:54:01','2024-01-11 08:54:01',NULL),(1524,7489,40728,14258,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',1188.73,NULL,NULL,1,'2024-01-11 08:54:01','2024-01-11 08:54:01',NULL),(1525,7489,40728,14258,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',1557.17,NULL,NULL,1,'2024-01-11 08:54:01','2024-01-11 08:54:01',NULL),(1526,7489,40728,14258,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',411009.04,NULL,NULL,1,'2024-01-11 08:54:01','2024-01-11 08:54:01',NULL),(1527,7489,40728,14258,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',24517.31,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1528,7489,40728,14258,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',85643.51,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1529,7489,40728,14258,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',380142.22,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1530,7489,40728,14258,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',10431.61,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1531,7489,40728,14258,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',86809.54,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1532,7489,40728,14258,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',57967.79,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1533,7489,40728,14258,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',1784.70,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1534,7489,40728,14258,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',264023.98,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1535,7489,40728,14258,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',3477.14,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL);
INSERT INTO `balance_libro` VALUES (1536,7489,40728,14258,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',283750.22,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1537,7489,40728,14258,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',225189.82,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1538,7489,40728,14258,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',78754.22,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1539,7489,40728,14258,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',341839.54,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1540,7489,40728,14258,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',8474.29,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1541,7489,40728,14258,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',15332.79,NULL,NULL,1,'2024-01-11 08:54:02','2024-01-11 08:54:02',NULL),(1542,7489,40728,14258,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',259059.56,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1543,7489,40728,14258,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',1984.08,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1544,7489,40728,14258,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',294655.65,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1545,7489,40728,14258,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',7957.00,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1546,7489,40728,14258,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',114120.87,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1547,7489,40728,14258,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',71102.28,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1548,7489,40728,14258,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',3104.15,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1549,7489,40728,14258,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',19283.50,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1550,7489,40728,14258,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',3710.30,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1551,7489,40728,14258,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',310102.27,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1552,7489,40728,14258,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',10395.29,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1553,7489,40728,14258,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',95124.14,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1554,7489,40728,14258,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',29692.77,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1555,7489,40728,14258,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',266596.39,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL),(1556,7489,40728,14258,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',1930.66,NULL,NULL,1,'2024-01-11 08:54:03','2024-01-11 08:54:03',NULL);
INSERT INTO `balance_libro` VALUES (1557,7489,40728,14258,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',25047.00,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1558,7489,40728,14258,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',13009.73,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1559,7489,40728,14258,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',1325.46,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1560,7489,40728,14258,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',28685.15,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1561,7489,40728,14258,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',6129.55,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1562,7489,40728,14258,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',5736.40,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1563,7489,40728,14258,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',2143.38,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1564,7489,40728,14258,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',8629.29,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1565,7489,40728,14258,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',285684.29,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1566,7489,40728,14258,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',4683.26,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1567,7489,40728,14258,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',7325.98,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1568,7489,40728,14258,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',8895.02,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1569,7489,40728,14258,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',276905.85,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1570,7489,40728,14258,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',5191.19,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1571,7489,40728,14258,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',353789.52,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1572,7489,40728,14258,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',3723.49,NULL,NULL,1,'2024-01-11 08:54:04','2024-01-11 08:54:04',NULL),(1573,7489,40728,14258,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',404821.93,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1574,7489,40728,14258,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',29256.53,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1575,7489,40728,14258,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',23691.76,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1576,7489,40728,14258,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',268406.93,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1577,7489,40728,14258,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',3268.19,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL);
INSERT INTO `balance_libro` VALUES (1578,7489,40728,14258,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',465574.83,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1579,7489,40728,14258,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',4698.81,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1580,7489,40728,14258,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',34397.63,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1581,7489,40728,14258,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',49663.30,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1582,7489,40728,14258,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',32038.77,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1583,7489,40728,14258,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',467099.63,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1584,7489,40728,14258,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',64866.92,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1585,7489,40728,14258,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',745543.11,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1586,7489,40728,14258,3,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',3697.61,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1587,7489,40728,14258,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',2494776.50,NULL,NULL,1,'2024-01-11 08:54:05','2024-01-11 08:54:05',NULL),(1588,7489,40728,14258,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',11835.17,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1589,7489,40728,14258,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',6976.58,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1590,7489,40728,14258,3,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',5040.81,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1591,7489,40728,14258,3,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',25789.82,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1592,7489,40728,14258,3,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',24883.03,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1593,7489,40728,14258,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',14076.25,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 09:16:04','2024-01-11 09:16:04'),(1594,7489,40728,14258,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',5613.42,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 09:00:54','2024-01-11 09:00:54'),(1595,7489,40728,14258,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',125260.74,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1596,7489,40728,14258,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',3262.63,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1597,7489,40728,14258,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',332937.39,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL);
INSERT INTO `balance_libro` VALUES (1598,7489,40728,14258,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',540983.89,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1599,7489,40728,14258,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',335230.62,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1600,7489,40728,14258,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',10259.91,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1601,7489,40728,14258,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',3616.19,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1602,7489,40728,14258,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',4427.74,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1603,7489,40728,14258,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',15408.96,NULL,NULL,1,'2024-01-11 08:54:06','2024-01-11 08:54:06',NULL),(1604,7489,40728,14258,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',70413.89,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1605,7489,40728,14258,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',2212.49,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1606,7489,40728,14258,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',347128.06,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1607,7489,40728,14258,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',393765.27,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1608,7489,40728,14258,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',8341.53,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1609,7489,40728,14258,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',4454.99,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1610,7489,40728,14258,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',231980.01,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1611,7489,40728,14258,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',86363.12,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1612,7489,40728,14258,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',2639.68,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1613,7489,40728,14258,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',4821.73,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1614,7489,40728,14258,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',25165.79,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1615,7489,40728,14258,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',5447.74,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1616,7489,40728,14258,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',50000.00,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1617,7489,40728,14258,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',10081.60,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1618,7489,40728,14258,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',633.73,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL);
INSERT INTO `balance_libro` VALUES (1619,7489,40728,14258,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',12185.92,NULL,NULL,1,'2024-01-11 08:54:07','2024-01-11 08:54:07',NULL),(1620,7489,40728,14258,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',365189.87,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1621,7489,40728,14258,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',372588.88,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1622,7489,40728,14258,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',528837.34,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1623,7489,40728,14258,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',241156.85,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1624,7489,40728,14258,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',12474.35,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1625,7489,40728,14258,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',42320.71,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1626,7489,40728,14258,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',20870.73,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1627,7489,40728,14258,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',50897.78,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1628,7489,40728,14258,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',328277.39,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1629,7489,40728,14258,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',16291.00,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1630,7489,40728,14258,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',2311.01,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1631,7489,40728,14258,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',1274.07,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1632,7489,40728,14258,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',357983.44,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1633,7489,40728,14258,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',2556.42,NULL,NULL,1,'2024-01-11 08:54:08','2024-01-11 08:54:08',NULL),(1634,7489,40728,14258,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',104434.74,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1635,7489,40728,14258,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',161139.06,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1636,7489,40728,14258,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',360673.40,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1637,7489,40728,14258,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',22282.63,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1638,7489,40728,14258,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',378410.23,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL);
INSERT INTO `balance_libro` VALUES (1639,7489,40728,14258,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',2380.90,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1640,7489,40728,14258,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',159550.99,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1641,7489,40728,14258,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',15915.06,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1642,7489,40728,14258,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',29839.09,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1643,7489,40728,14258,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',2440.85,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1644,7489,40728,14258,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',313204.31,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1645,7489,40728,14258,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',4394.75,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1646,7489,40728,14258,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',40000.01,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1647,7489,40728,14258,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',90372.51,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1648,7489,40728,14258,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',2206.72,NULL,NULL,1,'2024-01-11 08:54:09','2024-01-11 08:54:09',NULL),(1649,7489,40728,14258,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',21569.09,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1650,7489,40728,14258,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',171227.20,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1651,7489,40728,14258,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',4332.72,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1652,7489,40728,14258,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',2891.48,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1653,7489,40728,14258,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',1021.54,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1654,7489,40728,14258,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',8152.98,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1655,7489,40728,14258,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',12917.35,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1656,7489,40728,14258,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',12259.14,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1657,7489,40728,14258,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',139929.33,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1658,7489,40728,14258,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',264521.53,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1659,7489,40728,14258,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',432404.69,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL);
INSERT INTO `balance_libro` VALUES (1660,7489,40728,14258,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',225363.26,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1661,7489,40728,14258,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',29839.09,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1662,7489,40728,14258,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',8132.42,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1663,7489,40728,14258,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',293421.22,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1664,7489,40728,14258,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',70899.00,NULL,NULL,1,'2024-01-11 08:54:10','2024-01-11 08:54:10',NULL),(1665,7489,40728,14258,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',26984.25,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1666,7489,40728,14258,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',10029.18,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1667,7489,40728,14258,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',64533.91,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1668,7489,40728,14258,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',7278.44,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1669,7489,40728,14258,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',235478.93,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1670,7489,40728,14258,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',12368.77,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1671,7489,40728,14258,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',338339.42,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1672,7489,40728,14258,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',29556.04,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1673,7489,40728,14258,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',14161.80,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1674,7489,40728,14258,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',2008.07,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1675,7489,40728,14258,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',79100.80,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1676,7489,40728,14258,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',5348.41,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1677,7489,40728,14258,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',142098.56,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1678,7489,40728,14258,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',29839.09,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1679,7489,40728,14258,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',3571.18,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL),(1680,7489,40728,14258,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',206391.72,NULL,NULL,1,'2024-01-11 08:54:11','2024-01-11 08:54:11',NULL);
INSERT INTO `balance_libro` VALUES (1681,7489,40728,14258,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',481539.26,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1682,7489,40728,14258,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',235103.47,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1683,7489,40728,14258,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',439355.58,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1684,7489,40728,14258,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',10784.54,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1685,7489,40728,14258,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',16600.00,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1686,7489,40728,14258,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',231399.66,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1687,7489,40728,14258,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',16573.12,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1688,7489,40728,14258,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',11033.93,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1689,7489,40728,14258,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',1029796.38,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1690,7489,40728,14258,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',19918.21,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1691,7489,40728,14258,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',5495439.56,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1692,7489,40728,14258,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',72794.98,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1693,7489,40728,14258,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',305391.01,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1694,7489,40728,14258,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',368374.97,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1695,7489,40728,14258,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',68505.24,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1696,7489,40728,14258,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',24948.70,NULL,NULL,1,'2024-01-11 08:54:12','2024-01-11 08:54:12',NULL),(1697,7489,40728,14258,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',18958.25,NULL,NULL,1,'2024-01-11 08:54:13','2024-01-11 08:54:13',NULL),(1698,7489,40728,14258,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',40072.77,NULL,NULL,1,'2024-01-11 08:54:13','2024-01-11 08:54:13',NULL),(1699,7489,40728,14258,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',306083.11,NULL,NULL,1,'2024-01-11 08:54:13','2024-01-11 08:54:13',NULL),(1700,7489,40728,14258,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',24590.45,NULL,NULL,1,'2024-01-11 08:54:13','2024-01-11 08:54:13',NULL);
INSERT INTO `balance_libro` VALUES (1701,7489,40728,14258,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',9712.41,NULL,NULL,1,'2024-01-11 08:54:13','2024-01-11 08:54:13',NULL),(1702,7489,40728,14258,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',110488.65,NULL,NULL,1,'2024-01-11 08:54:13','2024-01-11 08:54:13',NULL),(1703,7489,40728,14258,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',5613.42,NULL,NULL,1,'2024-01-11 09:00:54','2024-01-11 09:00:54',NULL),(1704,7489,40728,14258,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',14076.24,NULL,NULL,1,'2024-01-11 09:16:04','2024-01-11 09:16:04',NULL),(1705,7489,40725,9364,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',36790.58,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 11:02:39','2024-01-11 11:02:39'),(1706,7489,40725,9364,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',9000.00,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1707,7489,40725,9364,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',23569.22,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1708,7489,40725,9364,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',1332.23,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1709,7489,40725,9364,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',320000.00,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1710,7489,40725,9364,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',20000.00,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1711,7489,40725,9364,3,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',130000.00,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1712,7489,40725,9364,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',320000.00,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1713,7489,40725,9364,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',320000.00,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1714,7489,40725,9364,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',290000.00,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1715,7489,40725,9364,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',20000.00,NULL,NULL,1,'2024-01-11 09:29:02','2024-01-11 09:29:02',NULL),(1716,7489,40725,9364,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',160000.00,NULL,NULL,1,'2024-01-11 09:29:03','2024-01-11 09:29:03',NULL),(1717,7489,40725,9364,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',86243.00,NULL,NULL,1,'2024-01-11 09:29:57','2024-01-11 10:11:52','2024-01-11 10:11:52'),(1718,7489,40725,9364,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',99673.00,NULL,NULL,1,'2024-01-11 09:29:57','2024-01-11 10:12:25','2024-01-11 10:12:25'),(1719,7489,40725,9364,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',2763132.00,NULL,NULL,1,'2024-01-11 09:29:57','2024-01-11 10:11:01','2024-01-11 10:11:01'),(1720,7489,40725,9364,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',22500.00,NULL,NULL,1,'2024-01-11 09:29:57','2024-01-11 10:13:10','2024-01-11 10:13:10');
INSERT INTO `balance_libro` VALUES (1721,7489,40725,9364,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',120770.00,NULL,NULL,1,'2024-01-11 09:29:57','2024-01-11 10:00:39','2024-01-11 10:00:39'),(1722,7489,40725,9364,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',9000.00,NULL,NULL,1,'2024-01-11 09:29:57','2024-01-11 09:29:57',NULL),(1723,7489,40725,9364,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',120770.00,NULL,NULL,1,'2024-01-11 10:00:39','2024-01-11 10:00:39',NULL),(1724,7489,40725,9364,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',2763132.00,NULL,NULL,1,'2024-01-11 10:11:01','2024-01-11 10:11:01',NULL),(1725,7489,40725,9364,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',86243.00,NULL,NULL,1,'2024-01-11 10:11:52','2024-01-11 10:11:52',NULL),(1726,7489,40725,9364,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',99673.00,NULL,NULL,1,'2024-01-11 10:12:25','2024-01-11 10:12:25',NULL),(1727,7489,40725,9364,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',22500.00,NULL,NULL,1,'2024-01-11 10:13:10','2024-01-11 10:13:10',NULL),(1728,7489,40725,9364,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',10227.45,NULL,NULL,1,'2024-01-11 10:28:31','2024-01-11 10:28:31',NULL),(1729,7489,40725,9364,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',9620.92,NULL,NULL,1,'2024-01-11 10:29:35','2024-01-11 10:37:29','2024-01-11 10:37:29'),(1730,7489,40725,9364,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',12760.95,NULL,NULL,1,'2024-01-11 10:31:36','2024-01-11 10:31:36',NULL),(1731,7489,40725,9364,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',9215.56,NULL,NULL,1,'2024-01-11 10:32:19','2024-01-11 10:32:19',NULL),(1732,7489,40725,9364,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',14939.49,NULL,NULL,1,'2024-01-11 10:33:36','2024-01-11 10:33:36',NULL),(1733,7489,40725,9364,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',11100.00,NULL,NULL,1,'2024-01-11 10:34:21','2024-01-11 10:34:21',NULL),(1734,7489,40725,9364,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',11730.11,NULL,NULL,1,'2024-01-11 10:35:10','2024-01-11 10:35:10',NULL),(1735,7489,40725,9364,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',13625.09,NULL,NULL,1,'2024-01-11 10:35:54','2024-01-11 10:35:54',NULL),(1736,7489,40725,9364,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',12495.37,NULL,NULL,1,'2024-01-11 10:37:29','2024-01-11 10:37:29',NULL),(1737,7489,40725,9364,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',9620.92,NULL,NULL,1,'2024-01-11 10:38:38','2024-01-11 10:38:38',NULL),(1738,7489,40725,9364,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',7200.66,NULL,NULL,1,'2024-01-11 10:40:34','2024-01-11 10:40:34',NULL),(1739,7489,40725,9364,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',7501.11,NULL,NULL,1,'2024-01-11 10:41:28','2024-01-11 10:41:28',NULL),(1740,7489,40725,9364,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',18905.11,NULL,NULL,1,'2024-01-11 10:42:21','2024-01-11 10:42:21',NULL);
INSERT INTO `balance_libro` VALUES (1741,7489,40725,9364,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',119790.00,NULL,NULL,1,'2024-01-11 10:45:23','2024-01-11 10:45:23',NULL),(1742,7489,40725,9364,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',10111.99,NULL,NULL,1,'2024-01-11 10:46:37','2024-01-11 11:10:29','2024-01-11 11:10:29'),(1743,7489,40725,9364,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',6000.00,NULL,NULL,1,'2024-01-11 10:47:53','2024-01-11 11:11:06','2024-01-11 11:11:06'),(1744,7489,40725,9364,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',36790.58,NULL,NULL,1,'2024-01-11 11:02:39','2024-01-11 11:02:39',NULL),(1745,7489,40725,9363,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',10111.99,NULL,NULL,1,'2024-01-11 11:10:29','2024-01-11 11:10:29',NULL),(1746,7489,40725,9363,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',6000.00,NULL,NULL,1,'2024-01-11 11:11:06','2024-01-11 11:11:06',NULL),(1747,7489,40727,12533,2,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',367128.22,NULL,NULL,1,'2024-01-11 12:11:21','2024-01-11 12:11:21',NULL),(1748,7489,40727,12533,2,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',8419.95,NULL,NULL,1,'2024-01-11 12:11:21','2024-01-11 12:11:21',NULL),(1749,7489,40727,12533,2,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',2880.00,NULL,NULL,1,'2024-01-11 12:11:21','2024-01-11 12:11:21',NULL),(1750,7489,40727,12533,2,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',4000.00,NULL,NULL,1,'2024-01-11 12:11:21','2024-01-11 12:11:21',NULL),(1751,7489,40727,12533,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',36419.68,NULL,NULL,1,'2024-01-11 12:11:21','2024-01-11 12:16:43','2024-01-11 12:16:43'),(1752,7489,40727,12533,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',55776.76,NULL,NULL,1,'2024-01-11 12:11:22','2024-01-11 12:11:22',NULL),(1753,7489,40727,12533,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',37315.27,NULL,NULL,1,'2024-01-11 12:11:22','2024-01-11 12:16:06','2024-01-11 12:16:06'),(1754,7489,40727,12533,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',13500.00,NULL,NULL,1,'2024-01-11 12:11:22','2024-01-11 12:13:18','2024-01-11 12:13:18'),(1755,7489,40727,12533,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',1225011.88,NULL,NULL,1,'2024-01-11 12:11:22','2024-01-11 12:11:22',NULL),(1756,7489,40727,12533,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',1271705.89,NULL,NULL,1,'2024-01-11 12:11:22','2024-01-11 12:11:22',NULL),(1757,7489,40727,12533,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',7500.00,NULL,NULL,1,'2024-01-11 12:11:22','2024-01-11 12:11:22',NULL),(1758,7489,40727,12533,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',298950.26,NULL,NULL,1,'2024-01-11 12:11:22','2024-01-11 12:11:22',NULL),(1759,7489,40727,12533,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',8640.00,NULL,NULL,1,'2024-01-11 12:11:22','2024-01-11 12:11:22',NULL),(1760,7489,40727,12533,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',4000.00,NULL,NULL,1,'2024-01-11 12:11:22','2024-01-11 12:11:22',NULL);
INSERT INTO `balance_libro` VALUES (1761,7489,40727,12533,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',13500.00,NULL,NULL,1,'2024-01-11 12:13:18','2024-01-11 12:13:18',NULL),(1762,7489,40727,12533,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',37315.27,NULL,NULL,1,'2024-01-11 12:16:06','2024-01-11 12:16:06',NULL),(1763,7489,40727,12533,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',36419.68,NULL,NULL,1,'2024-01-11 12:16:43','2024-01-11 12:16:43',NULL),(1764,7489,40727,12533,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',309761.28,NULL,NULL,1,'2024-01-11 12:17:23','2024-01-11 12:17:23',NULL),(1765,7489,40727,12533,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',88879.88,NULL,NULL,1,'2024-01-11 12:17:23','2024-01-11 12:17:23',NULL),(1766,7489,40727,12533,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',82889.61,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1767,7489,40727,12533,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',39973.92,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1768,7489,40727,12533,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',21766.88,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1769,7489,40727,12533,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',71298.55,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1770,7489,40727,12533,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',76084.05,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1771,7489,40727,12533,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',41258.34,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1772,7489,40727,12533,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',7053.09,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1773,7489,40727,12533,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',80269.44,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1774,7489,40727,12533,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',10000.00,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1775,7489,40727,12533,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',31623.66,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1776,7489,40727,12533,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',44962.27,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1777,7489,40727,12533,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',86651.79,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1778,7489,40727,12533,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',27070.12,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:33:23','2024-01-11 12:33:23'),(1779,7489,40727,12533,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',17990.00,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1780,7489,40727,12533,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',21298.46,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL);
INSERT INTO `balance_libro` VALUES (1781,7489,40727,12533,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',46242.06,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1782,7489,40727,12533,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',110885.44,NULL,NULL,1,'2024-01-11 12:17:24','2024-01-11 12:17:24',NULL),(1783,7489,40727,12533,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',58633.99,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1784,7489,40727,12533,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',5660.86,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1785,7489,40727,12533,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',9599.99,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1786,7489,40727,12533,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',195000.00,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1787,7489,40727,12533,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',195000.00,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1788,7489,40727,12533,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',38000.00,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1789,7489,40727,12533,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',14605.00,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1790,7489,40727,12533,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',30000.00,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1791,7489,40727,12533,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',36000.00,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1792,7489,40727,12533,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',9332.61,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1793,7489,40727,12533,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',7418.87,NULL,NULL,1,'2024-01-11 12:17:25','2024-01-11 12:17:25',NULL),(1794,7489,40727,12533,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',27070.12,NULL,NULL,1,'2024-01-11 12:33:23','2024-01-11 12:33:23',NULL),(1795,7489,40728,14258,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',8117645.57,NULL,NULL,1,'2024-01-12 08:50:49','2024-01-12 08:50:49',NULL),(1796,7489,40728,14258,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',72837.74,NULL,NULL,1,'2024-01-12 08:51:46','2024-01-12 08:51:46',NULL),(1797,7489,40728,14258,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',908543.32,NULL,NULL,1,'2024-01-12 08:52:16','2024-01-12 08:52:16',NULL),(1798,7489,40724,7789,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',110806477.30,NULL,NULL,1,'2024-01-12 10:01:24','2024-01-12 10:01:24',NULL),(1799,7489,40724,7789,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',101504609.90,NULL,NULL,1,'2024-01-12 10:04:27','2024-01-12 10:04:27',NULL),(1800,7489,40724,7789,15,1800,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',17623767.36,'Liquidacion mensual',NULL,1,'2024-01-12 10:08:23','2024-01-12 15:41:10','2024-01-12 15:41:10');
INSERT INTO `balance_libro` VALUES (1801,7489,40724,7789,16,1801,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2937294.50,'Liquidacion mensual',NULL,1,'2024-01-12 10:09:38','2024-01-12 10:09:38',NULL),(1802,7489,40799,17255,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',406560.00,NULL,NULL,1,'2024-01-12 10:40:16','2024-01-12 10:40:16',NULL),(1803,7489,40799,17255,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',1530650.00,NULL,NULL,1,'2024-01-12 10:40:16','2024-01-12 10:40:16',NULL),(1804,7489,40799,17255,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',179080.00,NULL,NULL,1,'2024-01-12 10:40:16','2024-01-12 10:40:16',NULL),(1805,7489,40799,17255,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',56628.00,NULL,NULL,1,'2024-01-12 10:40:16','2024-01-12 10:40:16',NULL),(1806,7489,40799,17255,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',56628.00,NULL,NULL,1,'2024-01-12 10:40:16','2024-01-12 10:40:16',NULL),(1807,7489,40799,17255,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',9084.45,NULL,NULL,1,'2024-01-12 10:40:31','2024-01-12 10:45:42','2024-01-12 10:45:42'),(1808,7489,40799,17255,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',9093.59,NULL,NULL,1,'2024-01-12 10:40:31','2024-01-12 10:45:21','2024-01-12 10:45:21'),(1809,7489,40799,17255,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',97302.90,NULL,NULL,1,'2024-01-12 10:40:31','2024-01-12 10:43:06','2024-01-12 10:43:06'),(1810,7489,40799,17255,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',10000.00,NULL,NULL,1,'2024-01-12 10:40:31','2024-01-12 10:43:25','2024-01-12 10:43:25'),(1811,7489,40799,17255,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',5194.80,NULL,NULL,1,'2024-01-12 10:40:31','2024-01-12 10:43:43','2024-01-12 10:43:43'),(1812,7489,40799,17255,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',96320.40,NULL,NULL,1,'2024-01-12 10:40:31','2024-01-12 10:42:33','2024-01-12 10:42:33'),(1813,7489,40799,17255,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-25','2023-12-25',28568.65,NULL,NULL,1,'2024-01-12 10:40:32','2024-01-12 10:40:32',NULL),(1814,7489,40799,17255,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',96320.40,NULL,NULL,1,'2024-01-12 10:42:33','2024-01-12 10:44:06','2024-01-12 10:44:06'),(1815,7489,40799,17255,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',97302.90,NULL,NULL,1,'2024-01-12 10:43:06','2024-01-12 10:44:55','2024-01-12 10:44:55'),(1816,7489,40799,17255,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',10000.00,NULL,NULL,1,'2024-01-12 10:43:25','2024-01-12 10:44:35','2024-01-12 10:44:35'),(1817,7489,40799,17255,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',5194.80,NULL,NULL,1,'2024-01-12 10:43:43','2024-01-12 10:44:21','2024-01-12 10:44:21'),(1818,7489,40799,17255,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',96320.40,NULL,NULL,1,'2024-01-12 10:44:06','2024-01-12 10:44:06',NULL),(1819,7489,40799,17255,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',5194.80,NULL,NULL,1,'2024-01-12 10:44:21','2024-01-12 10:44:21',NULL),(1820,7489,40799,17255,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',10000.00,NULL,NULL,1,'2024-01-12 10:44:35','2024-01-12 10:44:35',NULL);
INSERT INTO `balance_libro` VALUES (1821,7489,40799,17255,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',97302.90,NULL,NULL,1,'2024-01-12 10:44:55','2024-01-12 10:44:55',NULL),(1822,7489,40799,17255,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',9093.59,NULL,NULL,1,'2024-01-12 10:45:21','2024-01-12 10:45:21',NULL),(1823,7489,40799,17255,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',9084.45,NULL,NULL,1,'2024-01-12 10:45:42','2024-01-12 10:45:42',NULL),(1824,7489,40799,17255,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',10876.46,NULL,NULL,1,'2024-01-12 10:50:46','2024-01-12 10:50:46',NULL),(1825,7489,40799,17255,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',617217.01,NULL,NULL,1,'2024-01-12 10:52:05','2024-01-12 10:52:05',NULL),(1826,7489,40799,17255,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',234215.10,NULL,NULL,1,'2024-01-12 10:55:22','2024-01-12 10:55:22',NULL),(1827,7489,40799,17255,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',235690.32,NULL,NULL,1,'2024-01-12 10:56:06','2024-01-12 10:56:06',NULL),(1828,7489,40799,17255,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',235648.39,NULL,NULL,1,'2024-01-12 10:56:38','2024-01-12 10:56:38',NULL),(1829,7489,40799,17255,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',235257.64,NULL,NULL,1,'2024-01-12 10:58:12','2024-01-12 10:58:12',NULL),(1830,7489,40724,7789,15,1830,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',17623767.36,'Liquidacion mensual',NULL,1,'2024-01-12 15:41:10','2024-01-12 15:41:10',NULL),(1831,7489,40724,7789,1,1831,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-12-31',NULL,9558074.61,NULL,NULL,1,'2024-02-02 09:16:42','2024-02-02 09:16:42',NULL),(1832,7489,40726,10915,1,1832,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-11-30',NULL,274015.77,NULL,NULL,1,'2024-02-02 15:07:35','2024-02-02 15:07:35',NULL),(1833,7489,40726,10916,1,1833,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-12-31',NULL,450649.47,NULL,NULL,1,'2024-02-02 15:07:50','2024-02-02 15:07:50',NULL),(1834,7489,40727,12533,1,1834,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-12-31',NULL,814751.15,NULL,NULL,1,'2024-02-07 14:58:50','2024-02-07 14:58:50',NULL),(1835,7489,40725,9364,1,1835,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-12-31',NULL,630857.35,NULL,NULL,1,'2024-02-08 08:16:20','2024-02-08 08:16:20',NULL),(1836,7489,40728,14258,1,1836,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-12-31',NULL,1494139.35,NULL,NULL,1,'2024-02-08 08:58:45','2024-02-08 08:58:45',NULL),(1837,7489,40724,7793,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',148915610.27,NULL,NULL,1,'2024-02-08 10:43:34','2024-02-08 10:43:34',NULL),(1838,7489,40725,9368,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',409322.65,NULL,NULL,1,'2024-02-10 09:59:48','2024-02-17 10:41:17','2024-02-17 10:41:17'),(1839,7489,40725,9368,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',409322.65,NULL,NULL,1,'2024-02-10 10:01:03','2024-02-17 10:41:07','2024-02-17 10:41:07'),(1840,7489,40725,9368,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',15098.55,NULL,NULL,1,'2024-02-10 10:02:01','2024-02-17 10:40:54','2024-02-17 10:40:54');
INSERT INTO `balance_libro` VALUES (1841,7489,40725,9369,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',1376039.99,NULL,NULL,1,'2024-02-10 10:04:40','2024-02-17 10:40:28','2024-02-17 10:40:28'),(1859,7489,40728,14262,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',277903.99,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1860,7489,40728,14262,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',163440.00,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1861,7489,40728,14262,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',156824.97,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1862,7489,40728,14262,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',386086.20,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1863,7489,40728,14262,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',103880.00,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1864,7489,40728,14262,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',334962.70,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1865,7489,40728,14262,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',242094.26,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1866,7489,40728,14262,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',180033.83,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1867,7489,40728,14262,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',203940.45,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1868,7489,40728,14262,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',206608.56,NULL,NULL,1,'2024-02-17 09:00:51','2024-02-17 09:00:51',NULL),(1869,7489,40728,14262,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',196435.01,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1870,7489,40728,14262,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',219868.42,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1871,7489,40728,14262,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',166234.96,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1872,7489,40728,14262,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',241580.45,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1873,7489,40728,14262,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',112671.34,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1874,7489,40728,14262,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',290087.83,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1875,7489,40728,14262,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',98308.80,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1876,7489,40728,14262,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',236842.56,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1877,7489,40728,14262,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',210868.77,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL);
INSERT INTO `balance_libro` VALUES (1878,7489,40728,14262,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',80837.34,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1879,7489,40728,14262,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',289156.54,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1880,7489,40728,14262,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',237859.22,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1881,7489,40728,14262,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',94615.29,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1882,7489,40728,14262,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',188523.43,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1883,7489,40728,14262,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',108406.88,NULL,NULL,1,'2024-02-17 09:00:52','2024-02-17 09:00:52',NULL),(1884,7489,40728,14262,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',224085.00,NULL,NULL,1,'2024-02-17 09:00:53','2024-02-17 09:00:53',NULL),(1885,7489,40728,14262,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',229594.93,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1886,7489,40728,14262,3,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',12864.97,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1887,7489,40728,14262,3,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',257572.56,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1888,7489,40728,14262,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',3933.96,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1889,7489,40728,14262,3,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',2827.65,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1890,7489,40728,14262,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',401285.75,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1891,7489,40728,14262,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',467806.65,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1892,7489,40728,14262,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',196743.25,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1893,7489,40728,14262,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',26752.79,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1894,7489,40728,14262,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',16772.50,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1895,7489,40728,14262,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',102024.88,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1896,7489,40728,14262,3,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',8911.65,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1897,7489,40728,14262,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',8163.75,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL);
INSERT INTO `balance_libro` VALUES (1898,7489,40728,14262,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',148262.55,NULL,NULL,1,'2024-02-17 09:27:40','2024-02-17 09:27:40',NULL),(1899,7489,40728,14262,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',2115.72,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1900,7489,40728,14262,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',51475.24,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1901,7489,40728,14262,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',2222.88,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1902,7489,40728,14262,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',26368.58,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1903,7489,40728,14262,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',479505.50,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1904,7489,40728,14262,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',477339.04,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1905,7489,40728,14262,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',12474.35,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1906,7489,40728,14262,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',474964.07,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1907,7489,40728,14262,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',433831.09,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1908,7489,40728,14262,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',575254.61,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1909,7489,40728,14262,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',144007.71,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1910,7489,40728,14262,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',14814.80,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1911,7489,40728,14262,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',26974.64,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1912,7489,40728,14262,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',3440.70,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1913,7489,40728,14262,3,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',381036.06,NULL,NULL,1,'2024-02-17 09:27:41','2024-02-17 09:27:41',NULL),(1914,7489,40728,14262,3,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',207522.69,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1915,7489,40728,14262,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',187509.05,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1916,7489,40728,14262,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',6229.42,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1917,7489,40728,14262,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',486136.67,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL);
INSERT INTO `balance_libro` VALUES (1918,7489,40728,14262,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',19174.23,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1919,7489,40728,14262,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',428129.73,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1920,7489,40728,14262,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',95373.72,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1921,7489,40728,14262,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',576814.33,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1922,7489,40728,14262,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',485140.43,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1923,7489,40728,14262,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',218821.07,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1924,7489,40728,14262,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',7569.66,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1925,7489,40728,14262,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',167993.96,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1926,7489,40728,14262,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',19609.41,NULL,NULL,1,'2024-02-17 09:27:42','2024-02-17 09:27:42',NULL),(1927,7489,40728,14262,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',4172.27,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1928,7489,40728,14262,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',389943.71,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1929,7489,40728,14262,3,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',323156.45,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1930,7489,40728,14262,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',3195.53,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1931,7489,40728,14262,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',753293.75,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1932,7489,40728,14262,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',18365.68,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1933,7489,40728,14262,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',164514.36,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1934,7489,40728,14262,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',28884.58,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1935,7489,40728,14262,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',74175.64,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1936,7489,40728,14262,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',20889.48,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1937,7489,40728,14262,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',1235.16,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL);
INSERT INTO `balance_libro` VALUES (1938,7489,40728,14262,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',75444.10,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1939,7489,40728,14262,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',7663.96,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1940,7489,40728,14262,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',114991.93,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1941,7489,40728,14262,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',236490.90,NULL,NULL,1,'2024-02-17 09:27:43','2024-02-17 09:27:43',NULL),(1942,7489,40728,14262,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',6339.28,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1943,7489,40728,14262,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',11255.43,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1944,7489,40728,14262,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',7844.71,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1945,7489,40728,14262,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',11572.13,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1946,7489,40728,14262,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',10103.86,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1947,7489,40728,14262,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',81801.13,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1948,7489,40728,14262,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',2715.35,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1949,7489,40728,14262,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',37901.28,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1950,7489,40728,14262,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',227987.21,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1951,7489,40728,14262,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',121854.53,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1952,7489,40728,14262,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',595379.31,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1953,7489,40728,14262,3,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',220646.72,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1954,7489,40728,14262,3,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',457486.22,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1955,7489,40728,14262,3,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',435619.11,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1956,7489,40728,14262,3,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',494759.05,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL),(1957,7489,40728,14262,3,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',39078.45,NULL,NULL,1,'2024-02-17 09:27:44','2024-02-17 09:27:44',NULL);
INSERT INTO `balance_libro` VALUES (1958,7489,40728,14262,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',6884.37,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1959,7489,40728,14262,3,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',423011.63,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1960,7489,40728,14262,3,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',8174.79,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1961,7489,40728,14262,3,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',6911.94,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1962,7489,40728,14262,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',32814.36,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1963,7489,40728,14262,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',16549.02,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:43:58','2024-02-17 09:43:58'),(1964,7489,40728,14262,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',4834.23,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1965,7489,40728,14262,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',270047.13,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1966,7489,40728,14262,3,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',16062.24,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1967,7489,40728,14262,3,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',484739.04,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1968,7489,40728,14262,3,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',2488.01,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1969,7489,40728,14262,3,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',503059.80,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1970,7489,40728,14262,3,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',3195.53,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1971,7489,40728,14262,3,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',7029.53,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1972,7489,40728,14262,3,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',2064.02,NULL,NULL,1,'2024-02-17 09:27:45','2024-02-17 09:27:45',NULL),(1973,7489,40728,14262,3,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',71694.45,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1974,7489,40728,14262,3,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',444451.26,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1975,7489,40728,14262,3,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',57148.62,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1976,7489,40728,14262,3,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',5360.88,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1977,7489,40728,14262,3,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',8871.98,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL);
INSERT INTO `balance_libro` VALUES (1978,7489,40728,14262,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',34231.91,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1979,7489,40728,14262,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',230844.39,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1980,7489,40728,14262,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',234898.63,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1981,7489,40728,14262,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',10170.36,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1982,7489,40728,14262,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',6744.02,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1983,7489,40728,14262,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',199404.70,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1984,7489,40728,14262,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',23965.66,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1985,7489,40728,14262,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',711253.70,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1986,7489,40728,14262,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',10999.62,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1987,7489,40728,14262,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',63787.95,NULL,NULL,1,'2024-02-17 09:27:46','2024-02-17 09:27:46',NULL),(1988,7489,40728,14262,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',25208.78,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1989,7489,40728,14262,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',13721.78,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1990,7489,40728,14262,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',34715.89,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1991,7489,40728,14262,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',268650.35,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1992,7489,40728,14262,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',38166.65,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1993,7489,40728,14262,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',5582.42,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1994,7489,40728,14262,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',46402.30,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1995,7489,40728,14262,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',7436.53,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1996,7489,40728,14262,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',1114.65,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1997,7489,40728,14262,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',202491.79,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(1998,7489,40728,14262,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',10062.94,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL);
INSERT INTO `balance_libro` VALUES (1999,7489,40728,14262,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',34425.60,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(2000,7489,40728,14262,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',106991.57,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(2001,7489,40728,14262,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',12300.47,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(2002,7489,40728,14262,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',5469.27,NULL,NULL,1,'2024-02-17 09:27:47','2024-02-17 09:27:47',NULL),(2003,7489,40728,14262,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',111059.59,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2004,7489,40728,14262,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',360822.42,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2005,7489,40728,14262,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',428651.32,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2006,7489,40728,14262,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',39566.34,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2007,7489,40728,14262,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',385702.63,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2008,7489,40728,14262,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',2442.12,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2009,7489,40728,14262,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',49804.96,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2010,7489,40728,14262,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',125463.91,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2011,7489,40728,14262,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',146934.85,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2012,7489,40728,14262,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',3176.95,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2013,7489,40728,14262,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',69064.79,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2014,7489,40728,14262,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',5316.27,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2015,7489,40728,14262,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',153101.56,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2016,7489,40728,14262,3,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',4327.33,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2017,7489,40728,14262,3,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',273378.07,NULL,NULL,1,'2024-02-17 09:27:48','2024-02-17 09:27:48',NULL),(2018,7489,40728,14262,3,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',519732.05,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL);
INSERT INTO `balance_libro` VALUES (2019,7489,40728,14262,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',83852.71,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2020,7489,40728,14262,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',30503.84,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2021,7489,40728,14262,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',17358.20,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2022,7489,40728,14262,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',97109.18,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2023,7489,40728,14262,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',5356.78,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2024,7489,40728,14262,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',97769.61,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2025,7489,40728,14262,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',21098.77,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2026,7489,40728,14262,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',19175.65,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2027,7489,40728,14262,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',50905.69,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2028,7489,40728,14262,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',51206.45,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2029,7489,40728,14262,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',7843.66,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2030,7489,40728,14262,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',182035.81,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2031,7489,40728,14262,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',4982.72,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2032,7489,40728,14262,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',1502.25,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2033,7489,40728,14262,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',295572.89,NULL,NULL,1,'2024-02-17 09:27:49','2024-02-17 09:27:49',NULL),(2034,7489,40728,14262,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',12526.82,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2035,7489,40728,14262,3,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',4178.60,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2036,7489,40728,14262,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',124042.99,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2037,7489,40728,14262,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',7317.76,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2038,7489,40728,14262,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',186125.92,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2039,7489,40728,14262,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',2787.80,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL);
INSERT INTO `balance_libro` VALUES (2040,7489,40728,14262,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',13721.79,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2041,7489,40728,14262,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',228183.98,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2042,7489,40728,14262,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',505857.42,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2043,7489,40728,14262,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',141541.00,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2044,7489,40728,14262,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',69815.32,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2045,7489,40728,14262,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',3366.33,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2046,7489,40728,14262,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',457197.10,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2047,7489,40728,14262,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',18964.41,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2048,7489,40728,14262,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',68245.96,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2049,7489,40728,14262,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',133748.20,NULL,NULL,1,'2024-02-17 09:27:50','2024-02-17 09:27:50',NULL),(2050,7489,40728,14262,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',3866.16,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2051,7489,40728,14262,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',426914.60,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2052,7489,40728,14262,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',1518.31,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2053,7489,40728,14262,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',65299.46,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2054,7489,40728,14262,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',106862.03,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2055,7489,40728,14262,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',54988.71,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2056,7489,40728,14262,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',262042.10,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2057,7489,40728,14262,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3195.53,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2058,7489,40728,14262,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',11782.98,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2059,7489,40728,14262,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',91031.28,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL);
INSERT INTO `balance_libro` VALUES (2060,7489,40728,14262,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',196483.24,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2061,7489,40728,14262,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',39757.71,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2062,7489,40728,14262,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',25728.73,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2063,7489,40728,14262,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',199400.00,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2064,7489,40728,14262,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',50000.00,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2065,7489,40728,14262,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',239180.00,NULL,NULL,1,'2024-02-17 09:27:51','2024-02-17 09:27:51',NULL),(2066,7489,40728,14262,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',70.18,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2067,7489,40728,14262,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',2991.33,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2068,7489,40728,14262,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',27956.50,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2069,7489,40728,14262,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',180.29,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2070,7489,40728,14262,3,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',9602.91,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2071,7489,40728,14262,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',8235.51,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2072,7489,40728,14262,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',4282.52,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2073,7489,40728,14262,3,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',6978.30,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2074,7489,40728,14262,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',28046.36,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2075,7489,40728,14262,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',9887.20,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2076,7489,40728,14262,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',128428.76,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2077,7489,40728,14262,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',23393.97,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2078,7489,40728,14262,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',3570946.98,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2079,7489,40728,14262,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',24203.86,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2080,7489,40728,14262,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',576583.20,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL);
INSERT INTO `balance_libro` VALUES (2081,7489,40728,14262,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',4144.44,NULL,NULL,1,'2024-02-17 09:27:52','2024-02-17 09:27:52',NULL),(2082,7489,40728,14262,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',23158.70,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2083,7489,40728,14262,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',9497.16,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2084,7489,40728,14262,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',2010.34,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2085,7489,40728,14262,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',11223.63,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2086,7489,40728,14262,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',4857.21,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2087,7489,40728,14262,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',5634.95,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2088,7489,40728,14262,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',2101.20,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2089,7489,40728,14262,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',23881.92,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2090,7489,40728,14262,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',2319.29,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2091,7489,40728,14262,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',33278.54,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2092,7489,40728,14262,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',12873.90,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2093,7489,40728,14262,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',43812.33,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2094,7489,40728,14262,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',24694.80,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2095,7489,40728,14262,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',6423.30,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2096,7489,40728,14262,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',2142.45,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2097,7489,40728,14262,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',79734.63,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2098,7489,40728,14262,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',1186215.39,NULL,NULL,1,'2024-02-17 09:27:53','2024-02-17 09:27:53',NULL),(2099,7489,40728,14262,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',7324017.43,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2100,7489,40728,14262,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',527436.28,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2101,7489,40728,14262,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',26061.91,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL);
INSERT INTO `balance_libro` VALUES (2102,7489,40728,14262,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',22512.60,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2103,7489,40728,14262,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',4150.30,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2104,7489,40728,14262,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',16518.91,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2105,7489,40728,14262,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',11844.97,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2106,7489,40728,14262,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',5340.41,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2107,7489,40728,14262,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',11325.59,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2108,7489,40728,14262,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',23001.71,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2109,7489,40728,14262,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',14551.23,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2110,7489,40728,14262,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',3535.95,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2111,7489,40728,14262,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',24125.38,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2112,7489,40728,14262,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',1778.33,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2113,7489,40728,14262,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',8884.68,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2114,7489,40728,14262,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',7819.80,NULL,NULL,1,'2024-02-17 09:27:54','2024-02-17 09:27:54',NULL),(2115,7489,40728,14262,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',16549.02,NULL,NULL,1,'2024-02-17 09:43:58','2024-02-17 09:43:58',NULL),(2116,7489,40727,12537,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',530524.66,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2117,7489,40727,12537,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',26577.86,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2118,7489,40727,12537,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',301262.40,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2119,7489,40727,12537,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',1660.84,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2120,7489,40727,12537,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',36300.77,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2121,7489,40727,12537,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',204871.78,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2122,7489,40727,12537,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',1103551.21,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL);
INSERT INTO `balance_libro` VALUES (2123,7489,40727,12537,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',1081472.64,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2124,7489,40727,12537,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',8500.00,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2125,7489,40727,12537,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',4000.00,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2126,7489,40727,12537,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',198546.10,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:52:27','2024-02-17 09:52:27'),(2127,7489,40727,12537,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',19500.00,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2128,7489,40727,12537,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',75000.00,NULL,NULL,1,'2024-02-17 09:48:23','2024-02-17 09:48:23',NULL),(2129,7489,40727,12537,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',189673.74,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2130,7489,40727,12537,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',322073.27,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:50:56','2024-02-17 09:50:56'),(2131,7489,40727,12537,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',88774.11,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2132,7489,40727,12537,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',27980.33,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2133,7489,40727,12537,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',62279.47,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2134,7489,40727,12537,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',21487.49,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2135,7489,40727,12537,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',16019.99,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2136,7489,40727,12537,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',5600.00,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2137,7489,40727,12537,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',15000.00,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2138,7489,40727,12537,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',45896.84,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2139,7489,40727,12537,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',242031.94,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2140,7489,40727,12537,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',40099.21,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2141,7489,40727,12537,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',40347.00,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2142,7489,40727,12537,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',104330.62,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL);
INSERT INTO `balance_libro` VALUES (2143,7489,40727,12537,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',68663.63,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2144,7489,40727,12537,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',87729.22,NULL,NULL,1,'2024-02-17 09:49:43','2024-02-17 09:49:43',NULL),(2145,7489,40727,12537,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',71464.27,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2146,7489,40727,12537,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',142928.53,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2147,7489,40727,12537,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',142928.53,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2148,7489,40727,12537,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',24466.77,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 10:21:51','2024-02-17 10:21:51'),(2149,7489,40727,12537,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',10500.00,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2150,7489,40727,12537,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',10000.00,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2151,7489,40727,12537,3,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',10500.00,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2152,7489,40727,12537,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',185171.99,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2153,7489,40727,12537,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',31797.69,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2154,7489,40727,12537,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',67350.54,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2155,7489,40727,12537,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',3950.00,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2156,7489,40727,12537,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',20670.43,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2157,7489,40727,12537,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',16420.04,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2158,7489,40727,12537,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',0.00,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2159,7489,40727,12537,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',41759.00,NULL,NULL,1,'2024-02-17 09:49:44','2024-02-17 09:49:44',NULL),(2160,7489,40727,12537,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',31945.69,NULL,NULL,1,'2024-02-17 09:49:45','2024-02-17 09:49:45',NULL),(2161,7489,40727,12537,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',77193.26,NULL,NULL,1,'2024-02-17 09:49:45','2024-02-17 09:49:45',NULL),(2162,7489,40727,12537,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',91895.40,NULL,NULL,1,'2024-02-17 09:49:45','2024-02-17 09:49:45',NULL);
INSERT INTO `balance_libro` VALUES (2163,7489,40727,12537,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2900.01,NULL,NULL,1,'2024-02-17 09:49:45','2024-02-17 09:49:45',NULL),(2164,7489,40727,12537,3,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1200.00,NULL,NULL,1,'2024-02-17 09:49:45','2024-02-17 09:50:41','2024-02-17 09:50:41'),(2165,7489,40727,12537,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',198546.10,NULL,NULL,1,'2024-02-17 09:52:27','2024-02-17 09:52:27',NULL),(2166,7489,40727,12537,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',24466.77,NULL,NULL,1,'2024-02-17 10:21:51','2024-02-17 10:21:51',NULL),(2167,7489,40725,9368,2,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',129575.00,NULL,NULL,1,'2024-02-17 10:25:23','2024-02-17 10:25:23',NULL),(2168,7489,40725,9368,2,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',112116.00,NULL,NULL,1,'2024-02-17 10:25:23','2024-02-17 10:25:23',NULL),(2169,7489,40725,9368,2,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',332500.00,NULL,NULL,1,'2024-02-17 10:25:23','2024-02-17 10:25:23',NULL),(2170,7489,40725,9368,2,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',399300.00,NULL,NULL,1,'2024-02-17 10:25:23','2024-02-17 10:25:23',NULL),(2171,7489,40725,9368,2,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',57800.00,NULL,NULL,1,'2024-02-17 10:25:23','2024-02-17 10:25:23',NULL),(2172,7489,40725,9368,2,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',3315758.00,NULL,NULL,1,'2024-02-17 10:25:23','2024-02-17 10:25:23',NULL),(2173,7489,40725,9368,2,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',144924.00,NULL,NULL,1,'2024-02-17 10:25:23','2024-03-12 10:08:06','2024-03-12 10:08:06'),(2174,7489,40725,9368,2,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',205700.00,NULL,NULL,1,'2024-02-17 10:25:23','2024-02-17 10:25:23',NULL),(2175,7489,40725,9368,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',665000.00,NULL,NULL,1,'2024-02-17 10:25:23','2024-02-17 10:25:23',NULL),(2176,7489,40725,9368,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',145299.00,NULL,NULL,1,'2024-02-17 10:27:25','2024-02-17 10:28:09','2024-02-17 10:28:09'),(2177,7489,40725,9368,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',38600.04,NULL,NULL,1,'2024-02-17 10:27:25','2024-02-17 10:27:25',NULL),(2178,7489,40725,9368,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',203266.69,NULL,NULL,1,'2024-02-17 10:27:25','2024-02-17 10:27:25',NULL),(2179,7489,40725,9368,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',16698.00,NULL,NULL,1,'2024-02-17 10:27:25','2024-02-17 10:27:25',NULL),(2180,7489,40725,9368,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',9100.00,NULL,NULL,1,'2024-02-17 10:27:25','2024-02-17 10:27:25',NULL),(2181,7489,40725,9368,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',32397.00,NULL,NULL,1,'2024-02-17 10:27:25','2024-02-17 10:27:25',NULL),(2182,7489,40725,9368,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',110367.73,NULL,NULL,1,'2024-02-17 10:27:25','2024-02-17 10:27:25',NULL);
INSERT INTO `balance_libro` VALUES (2183,7489,40725,9368,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',9776.80,NULL,NULL,1,'2024-02-17 10:27:26','2024-02-17 10:27:26',NULL),(2184,7489,40725,9368,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',50000.00,NULL,NULL,1,'2024-02-17 10:27:26','2024-02-17 10:27:26',NULL),(2185,7489,40725,9368,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',409322.65,NULL,NULL,1,'2024-02-17 10:31:15','2024-02-17 10:37:24','2024-02-17 10:37:24'),(2186,7489,40725,9368,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',409322.65,NULL,NULL,1,'2024-02-17 10:33:05','2024-02-17 10:37:00','2024-02-17 10:37:00'),(2187,7489,40725,9368,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',409322.65,NULL,NULL,1,'2024-02-17 10:37:00','2024-02-17 10:37:00',NULL),(2188,7489,40725,9368,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',409322.65,NULL,NULL,1,'2024-02-17 10:37:24','2024-02-17 10:37:24',NULL),(2189,7489,40725,9369,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',1376039.99,NULL,NULL,1,'2024-02-17 10:42:45','2024-02-17 10:42:45',NULL),(2190,7489,40799,17259,2,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',56628.00,NULL,NULL,1,'2024-02-17 12:07:18','2024-02-17 12:07:18',NULL),(2191,7489,40799,17259,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',10416.30,NULL,NULL,1,'2024-02-17 12:07:47','2024-02-17 12:09:42','2024-02-17 12:09:42'),(2192,7489,40799,17259,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',10405.82,NULL,NULL,1,'2024-02-17 12:07:48','2024-02-17 12:10:10','2024-02-17 12:10:10'),(2193,7489,40799,17259,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',262650.65,NULL,NULL,1,'2024-02-17 12:07:48','2024-02-17 12:11:06','2024-02-17 12:11:06'),(2194,7489,40799,17259,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',71355.73,NULL,NULL,1,'2024-02-17 12:07:48','2024-02-17 12:14:47','2024-02-17 12:14:47'),(2195,7489,40799,17259,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',15000.00,NULL,NULL,1,'2024-02-17 12:07:48','2024-02-17 12:09:00','2024-02-17 12:09:00'),(2196,7489,40799,17259,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',6383.41,NULL,NULL,1,'2024-02-17 12:07:48','2024-02-17 12:15:20','2024-02-17 12:15:20'),(2197,7489,40799,17259,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',125383.03,NULL,NULL,1,'2024-02-17 12:07:48','2024-02-17 12:13:18','2024-02-17 12:13:18'),(2198,7489,40799,17259,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',35871.76,NULL,NULL,1,'2024-02-17 12:07:48','2024-02-17 12:16:00','2024-02-17 12:16:00'),(2199,7489,40799,17259,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',15000.00,NULL,NULL,1,'2024-02-17 12:09:00','2024-02-17 12:13:47','2024-02-17 12:13:47'),(2200,7489,40799,17259,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',10416.30,NULL,NULL,1,'2024-02-17 12:09:42','2024-02-17 12:11:40','2024-02-17 12:11:40'),(2201,7489,40799,17259,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',10405.82,NULL,NULL,1,'2024-02-17 12:10:10','2024-02-17 12:12:02','2024-02-17 12:12:02');
INSERT INTO `balance_libro` VALUES (2202,7489,40799,17259,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',262650.65,NULL,NULL,1,'2024-02-17 12:11:06','2024-02-17 12:12:23','2024-02-17 12:12:23'),(2203,7489,40799,17259,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',10416.30,NULL,NULL,1,'2024-02-17 12:11:40','2024-02-17 12:11:40',NULL),(2204,7489,40799,17259,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',10405.82,NULL,NULL,1,'2024-02-17 12:12:02','2024-02-17 12:12:02',NULL),(2205,7489,40799,17259,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',262650.65,NULL,NULL,1,'2024-02-17 12:12:23','2024-02-17 12:12:23',NULL),(2206,7489,40799,17259,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',125383.03,NULL,NULL,1,'2024-02-17 12:13:18','2024-02-17 12:13:18',NULL),(2207,7489,40799,17259,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',15000.00,NULL,NULL,1,'2024-02-17 12:13:47','2024-02-17 12:13:47',NULL),(2208,7489,40799,17259,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',71355.73,NULL,NULL,1,'2024-02-17 12:14:47','2024-02-17 12:14:47',NULL),(2209,7489,40799,17259,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',6383.41,NULL,NULL,1,'2024-02-17 12:15:20','2024-02-17 12:15:20',NULL),(2210,7489,40799,17259,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',35871.76,NULL,NULL,1,'2024-02-17 12:16:00','2024-02-17 12:16:00',NULL),(2211,7489,40728,14262,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',9487715.34,NULL,NULL,1,'2024-02-19 15:31:05','2024-02-19 15:31:05',NULL),(2212,7489,40728,14262,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',310737.18,NULL,NULL,1,'2024-02-19 15:32:06','2024-03-13 10:36:29','2024-03-13 10:36:29'),(2213,7489,40728,14262,2,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1076489.59,NULL,NULL,1,'2024-02-19 15:32:33','2024-02-19 15:32:33',NULL),(2214,7489,40724,7793,15,2214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',24039673.17,'Liquidacion mensual',NULL,1,'2024-02-20 15:52:49','2024-02-20 15:52:49',NULL),(2215,7489,40724,7793,16,2215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4006612.10,'Liquidacion mensual',NULL,1,'2024-02-20 15:59:21','2024-02-20 15:59:21',NULL),(2216,7489,40724,7793,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',135239643.17,NULL,NULL,1,'2024-02-20 16:04:17','2024-02-20 16:04:17',NULL),(2217,7489,40725,9369,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',8000.00,NULL,NULL,1,'2024-02-24 10:22:30','2024-02-24 10:22:30',NULL),(2218,7489,40725,9369,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',9998.29,NULL,NULL,1,'2024-02-24 10:23:30','2024-02-24 10:23:30',NULL),(2219,7489,40725,9369,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',31962.58,NULL,NULL,1,'2024-02-24 10:24:10','2024-02-24 10:24:10',NULL),(2220,7489,40725,9369,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',19416.99,NULL,NULL,1,'2024-02-24 10:24:59','2024-02-24 10:24:59',NULL),(2221,7489,40725,9369,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',17230.86,NULL,NULL,1,'2024-02-24 10:26:19','2024-02-24 10:26:19',NULL);
INSERT INTO `balance_libro` VALUES (2222,7489,40725,9369,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',17100.81,NULL,NULL,1,'2024-02-24 10:26:57','2024-02-24 10:26:57',NULL),(2223,7489,40725,9369,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',13997.59,NULL,NULL,1,'2024-02-24 10:27:42','2024-02-24 10:27:42',NULL),(2224,7489,40725,9369,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',25123.14,NULL,NULL,1,'2024-02-24 10:28:22','2024-02-24 10:28:22',NULL),(2225,7489,40725,9369,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',13000.26,NULL,NULL,1,'2024-02-24 10:28:45','2024-02-24 10:28:45',NULL),(2226,7489,40725,9369,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',28975.98,NULL,NULL,1,'2024-02-24 10:29:53','2024-02-24 10:29:53',NULL),(2227,7489,40725,9369,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',14270.88,NULL,NULL,1,'2024-02-24 10:30:22','2024-02-24 10:30:22',NULL),(2228,7489,40725,9369,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',35876.23,NULL,NULL,1,'2024-02-24 10:31:19','2024-02-24 10:31:19',NULL),(2229,7489,40725,9369,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',5499.99,NULL,NULL,1,'2024-02-24 11:08:19','2024-02-24 11:08:19',NULL),(2230,7489,40725,9369,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',30400.03,NULL,NULL,1,'2024-02-24 11:09:03','2024-02-24 11:09:03',NULL),(2231,7489,40727,12537,1,2231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-01-31',NULL,558230.90,NULL,NULL,1,'2024-02-28 14:51:52','2024-02-28 14:51:52',NULL),(2232,7489,40726,10920,1,2232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-01-31',NULL,407251.45,NULL,NULL,1,'2024-02-29 12:30:04','2024-02-29 12:30:04',NULL),(2233,7489,40724,7793,1,2233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-01-31',NULL,9153505.05,NULL,NULL,1,'2024-03-02 09:07:02','2024-03-02 09:07:02',NULL),(2234,7489,40728,14262,1,2234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-01-31',NULL,1372347.88,NULL,NULL,1,'2024-03-08 08:56:26','2024-03-08 08:56:26',NULL),(2235,7489,40725,9368,1,2235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-01-31',NULL,547580.44,NULL,NULL,1,'2024-03-08 12:13:38','2024-03-08 12:13:38',NULL),(2236,7489,40725,9369,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',155490.00,NULL,NULL,1,'2024-03-12 10:00:01','2024-03-12 10:05:56','2024-03-12 10:05:56'),(2237,7489,40725,9369,2,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',160128.00,NULL,NULL,1,'2024-03-12 10:00:01','2024-03-12 10:00:01',NULL),(2238,7489,40725,9369,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',134539.00,NULL,NULL,1,'2024-03-12 10:00:01','2024-03-12 10:06:56','2024-03-12 10:06:56'),(2239,7489,40725,9369,2,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',399300.00,NULL,NULL,1,'2024-03-12 10:00:02','2024-03-12 10:00:02',NULL),(2240,7489,40725,9369,2,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',391931.10,NULL,NULL,1,'2024-03-12 10:00:02','2024-03-12 10:00:02',NULL),(2241,7489,40725,9369,2,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',144924.00,NULL,NULL,1,'2024-03-12 10:00:02','2024-03-12 10:00:02',NULL);
INSERT INTO `balance_libro` VALUES (2242,7489,40725,9369,2,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',3315758.00,NULL,NULL,1,'2024-03-12 10:00:02','2024-03-12 10:00:02',NULL),(2243,7489,40725,9369,2,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',665000.00,NULL,NULL,1,'2024-03-12 10:00:02','2024-03-12 10:04:37','2024-03-12 10:04:37'),(2244,7489,40725,9369,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',13849.37,NULL,NULL,1,'2024-03-12 10:02:48','2024-03-12 10:02:48',NULL),(2245,7489,40725,9369,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',828000.00,NULL,NULL,1,'2024-03-12 10:02:48','2024-03-12 10:02:48',NULL),(2246,7489,40725,9369,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',58284.49,NULL,NULL,1,'2024-03-12 10:02:48','2024-03-12 10:02:48',NULL),(2247,7489,40725,9369,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',16611.84,NULL,NULL,1,'2024-03-12 10:02:48','2024-03-12 10:02:48',NULL),(2248,7489,40725,9369,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',25613.28,NULL,NULL,1,'2024-03-12 10:02:48','2024-03-12 10:02:48',NULL),(2249,7489,40725,9369,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',1811.37,NULL,NULL,1,'2024-03-12 10:02:48','2024-03-12 10:02:48',NULL),(2250,7489,40725,9369,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',169899.73,NULL,NULL,1,'2024-03-12 10:02:48','2024-03-12 10:02:48',NULL),(2251,7489,40725,9369,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',83332.70,NULL,NULL,1,'2024-03-12 10:02:48','2024-03-12 10:02:48',NULL),(2252,7489,40725,9369,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',32397.00,NULL,NULL,1,'2024-03-12 10:02:48','2024-03-12 10:02:48',NULL),(2253,7489,40725,9369,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-25','2024-02-25',10459.23,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2254,7489,40725,9369,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',15110.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2255,7489,40725,9369,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',29330.40,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2256,7489,40725,9369,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',360000.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2257,7489,40725,9369,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',360000.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2258,7489,40725,9369,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',260000.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2259,7489,40725,9369,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',360000.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2260,7489,40725,9369,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',50000.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2261,7489,40725,9369,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',180000.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL);
INSERT INTO `balance_libro` VALUES (2262,7489,40725,9369,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',180000.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2263,7489,40725,9369,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',360000.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2264,7489,40725,9369,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',29000.00,NULL,NULL,1,'2024-03-12 10:02:49','2024-03-12 10:02:49',NULL),(2265,7489,40725,9369,2,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',665000.00,NULL,NULL,1,'2024-03-12 10:04:37','2024-03-12 10:04:37',NULL),(2266,7489,40725,9369,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',155490.00,NULL,NULL,1,'2024-03-12 10:05:56','2024-03-12 10:05:56',NULL),(2267,7489,40725,9369,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',134539.00,NULL,NULL,1,'2024-03-12 10:06:56','2024-03-12 10:06:56',NULL),(2268,7489,40725,9368,2,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',144924.00,NULL,NULL,1,'2024-03-12 10:08:06','2024-03-12 10:08:06',NULL),(2269,7489,40728,14263,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',381842.58,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2270,7489,40728,14263,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',310567.00,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2271,7489,40728,14263,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',242147.99,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2272,7489,40728,14263,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',205825.56,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2273,7489,40728,14263,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',371874.39,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2274,7489,40728,14263,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',464466.84,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2275,7489,40728,14263,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',199901.51,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2276,7489,40728,14263,2,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',538886.22,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2277,7489,40728,14263,2,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',436504.97,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2278,7489,40728,14263,2,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',399900.24,NULL,NULL,1,'2024-03-12 14:44:43','2024-03-12 14:44:43',NULL),(2279,7489,40728,14263,2,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',386188.56,NULL,NULL,1,'2024-03-12 14:44:44','2024-03-12 14:44:44',NULL),(2280,7489,40728,14263,2,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',29670.00,NULL,NULL,1,'2024-03-12 14:44:44','2024-03-12 14:44:44',NULL),(2281,7489,40728,14262,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',310737.18,NULL,NULL,1,'2024-03-13 10:36:29','2024-03-13 10:36:29',NULL);
INSERT INTO `balance_libro` VALUES (2282,7489,40728,14263,2,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',7141249.79,NULL,NULL,1,'2024-03-13 10:37:44','2024-03-13 10:37:44',NULL),(2283,7489,40728,14263,2,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',121883.45,NULL,NULL,1,'2024-03-13 10:38:36','2024-03-13 10:38:36',NULL),(2284,7489,40728,14263,2,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',811008.26,NULL,NULL,1,'2024-03-13 10:39:05','2024-03-13 10:39:05',NULL),(2285,7489,40728,14263,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',60332.09,NULL,NULL,1,'2024-03-13 10:46:14','2024-03-13 10:46:14',NULL),(2286,7489,40728,14263,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',19961.96,NULL,NULL,1,'2024-03-13 10:46:14','2024-03-13 10:46:14',NULL),(2287,7489,40728,14263,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',22220.37,NULL,NULL,1,'2024-03-13 10:46:14','2024-03-13 10:46:14',NULL),(2288,7489,40728,14263,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',199776.21,NULL,NULL,1,'2024-03-13 10:46:14','2024-03-13 10:46:14',NULL),(2289,7489,40728,14263,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',2360.91,NULL,NULL,1,'2024-03-13 10:46:14','2024-03-13 10:46:14',NULL),(2290,7489,40728,14263,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',37532.41,NULL,NULL,1,'2024-03-13 10:46:14','2024-03-13 10:46:14',NULL),(2291,7489,40728,14263,3,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',24531.09,NULL,NULL,1,'2024-03-13 10:46:14','2024-03-13 10:46:14',NULL),(2292,7489,40728,14263,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',14894.57,NULL,NULL,1,'2024-03-13 10:46:14','2024-03-13 10:46:14',NULL),(2293,7489,40728,14263,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',6103.21,NULL,NULL,1,'2024-03-13 10:46:14','2024-03-13 10:46:14',NULL),(2294,7489,40728,14263,3,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',10717.67,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2295,7489,40728,14263,3,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',1489.26,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2296,7489,40728,14263,3,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',7029.53,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2297,7489,40728,14263,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',339275.97,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2298,7489,40728,14263,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',284044.91,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2299,7489,40728,14263,3,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',13721.79,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2300,7489,40728,14263,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',223417.84,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2301,7489,40728,14263,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',24846.94,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL);
INSERT INTO `balance_libro` VALUES (2302,7489,40728,14263,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',51156.93,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2303,7489,40728,14263,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',574001.66,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2304,7489,40728,14263,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',165895.27,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2305,7489,40728,14263,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',14151.48,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2306,7489,40728,14263,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',163686.45,NULL,NULL,1,'2024-03-13 10:46:15','2024-03-13 10:46:15',NULL),(2307,7489,40728,14263,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',452563.46,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2308,7489,40728,14263,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',284946.72,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2309,7489,40728,14263,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',16020.29,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2310,7489,40728,14263,3,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',310786.77,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2311,7489,40728,14263,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',590865.70,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2312,7489,40728,14263,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',16875.16,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2313,7489,40728,14263,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',47178.56,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2314,7489,40728,14263,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',21011.86,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2315,7489,40728,14263,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',9668.47,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2316,7489,40728,14263,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',5510.20,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2317,7489,40728,14263,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',444447.44,NULL,NULL,1,'2024-03-13 10:46:16','2024-03-13 10:46:16',NULL),(2318,7489,40728,14263,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',45534.61,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2319,7489,40728,14263,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',490404.69,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2320,7489,40728,14263,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',4834.23,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2321,7489,40728,14263,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',218424.53,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL);
INSERT INTO `balance_libro` VALUES (2322,7489,40728,14263,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',133506.78,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2323,7489,40728,14263,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',445822.79,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2324,7489,40728,14263,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',418217.31,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2325,7489,40728,14263,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',6093.73,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2326,7489,40728,14263,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',45534.61,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2327,7489,40728,14263,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',177936.04,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2328,7489,40728,14263,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',9668.47,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2329,7489,40728,14263,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',105703.90,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2330,7489,40728,14263,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',7844.71,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2331,7489,40728,14263,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',114649.91,NULL,NULL,1,'2024-03-13 10:46:17','2024-03-13 10:46:17',NULL),(2332,7489,40728,14263,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',456902.88,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2333,7489,40728,14263,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',71585.39,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2334,7489,40728,14263,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',360130.53,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2335,7489,40728,14263,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',44950.15,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2336,7489,40728,14263,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',298494.97,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2337,7489,40728,14263,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',516144.02,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2338,7489,40728,14263,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',4834.23,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2339,7489,40728,14263,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',3182.86,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2340,7489,40728,14263,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',421130.23,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2341,7489,40728,14263,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',447477.07,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL);
INSERT INTO `balance_libro` VALUES (2342,7489,40728,14263,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',581271.47,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2343,7489,40728,14263,3,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',349165.04,NULL,NULL,1,'2024-03-13 10:46:18','2024-03-13 10:46:18',NULL),(2344,7489,40728,14263,3,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',13721.79,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2345,7489,40728,14263,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',212329.51,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2346,7489,40728,14263,3,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-12','2024-02-12',9506.29,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2347,7489,40728,14263,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-12','2024-02-12',19137.63,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2348,7489,40728,14263,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',481374.05,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2349,7489,40728,14263,3,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',590830.13,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2350,7489,40728,14263,3,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',17506.56,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2351,7489,40728,14263,3,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',51029.11,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2352,7489,40728,14263,3,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',17519.70,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2353,7489,40728,14263,3,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',5843.19,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2354,7489,40728,14263,3,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',431488.54,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2355,7489,40728,14263,3,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',246866.27,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2356,7489,40728,14263,3,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',4559.14,NULL,NULL,1,'2024-03-13 10:46:19','2024-03-13 10:46:19',NULL),(2357,7489,40728,14263,3,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',394723.73,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2358,7489,40728,14263,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',180614.29,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2359,7489,40728,14263,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',14355.56,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2360,7489,40728,14263,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',9668.47,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2361,7489,40728,14263,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',126882.73,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL);
INSERT INTO `balance_libro` VALUES (2362,7489,40728,14263,3,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',37586.72,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2363,7489,40728,14263,3,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',275139.26,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2364,7489,40728,14263,3,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',6423.95,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2365,7489,40728,14263,3,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',10062.94,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2366,7489,40728,14263,3,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',33592.13,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2367,7489,40728,14263,3,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',356435.62,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2368,7489,40728,14263,3,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',579764.55,NULL,NULL,1,'2024-03-13 10:46:20','2024-03-13 10:46:20',NULL),(2369,7489,40728,14263,3,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',3784.77,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2370,7489,40728,14263,3,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',118504.09,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2371,7489,40728,14263,3,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',0.01,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2372,7489,40728,14263,3,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',12066.12,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2373,7489,40728,14263,3,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',50000.00,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2374,7489,40728,14263,3,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',267821.00,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2375,7489,40728,14263,3,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',31625.00,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2376,7489,40728,14263,3,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',138134.98,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2377,7489,40728,14263,3,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',23254.63,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2378,7489,40728,14263,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',10217.44,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2379,7489,40728,14263,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',7958.98,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2380,7489,40728,14263,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',3268.28,NULL,NULL,1,'2024-03-13 10:46:21','2024-03-13 10:46:21',NULL),(2381,7489,40728,14263,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',19175.65,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2382,7489,40728,14263,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',15905.89,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL);
INSERT INTO `balance_libro` VALUES (2383,7489,40728,14263,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',2024.90,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2384,7489,40728,14263,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',20175.41,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2385,7489,40728,14263,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',697640.86,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2386,7489,40728,14263,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',96276.15,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2387,7489,40728,14263,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',3626757.31,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2388,7489,40728,14263,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',4314.16,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2389,7489,40728,14263,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',17248.36,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2390,7489,40728,14263,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',23432.64,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2391,7489,40728,14263,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',2879.57,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2392,7489,40728,14263,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',15640.03,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2393,7489,40728,14263,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',7059.85,NULL,NULL,1,'2024-03-13 10:46:22','2024-03-13 10:46:22',NULL),(2394,7489,40728,14263,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',14332.13,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL),(2395,7489,40728,14263,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',10668.94,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL),(2396,7489,40728,14263,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',24161.10,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL),(2397,7489,40728,14263,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',6482937.94,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL),(2398,7489,40728,14263,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',257191.01,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL),(2399,7489,40728,14263,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',1448833.98,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL),(2400,7489,40728,14263,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',39720.05,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL),(2401,7489,40728,14263,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',4017.85,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL),(2402,7489,40728,14263,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',5394.18,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL),(2403,7489,40728,14263,3,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',22486.90,NULL,NULL,1,'2024-03-13 10:46:23','2024-03-13 10:46:23',NULL);
INSERT INTO `balance_libro` VALUES (2404,7489,40727,12538,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',3608.55,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2405,7489,40727,12538,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',82579.56,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2406,7489,40727,12538,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',58227.46,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2407,7489,40727,12538,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',940.72,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2408,7489,40727,12538,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',7200.00,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2409,7489,40727,12538,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',34317.51,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2410,7489,40727,12538,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',670763.93,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2411,7489,40727,12538,2,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',26000.00,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2412,7489,40727,12538,2,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',2109074.78,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2413,7489,40727,12538,2,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',1045902.27,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2414,7489,40727,12538,2,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',75000.00,NULL,NULL,1,'2024-03-14 09:56:54','2024-03-14 09:56:54',NULL),(2415,7489,40727,12538,2,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',30000.00,NULL,NULL,1,'2024-03-14 09:56:55','2024-03-14 09:56:55',NULL),(2416,7489,40727,12538,2,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',325686.42,NULL,NULL,1,'2024-03-14 09:56:55','2024-03-14 09:56:55',NULL),(2417,7489,40727,12538,2,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',7000.00,NULL,NULL,1,'2024-03-14 09:56:55','2024-03-14 09:56:55',NULL),(2418,7489,40727,12538,2,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',268305.57,NULL,NULL,1,'2024-03-14 09:56:55','2024-03-14 09:56:55',NULL),(2419,7489,40727,12538,2,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',45000.00,NULL,NULL,1,'2024-03-14 09:56:55','2024-03-14 09:56:55',NULL),(2420,7489,40727,12538,2,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',7500.00,NULL,NULL,1,'2024-03-14 09:56:55','2024-03-14 09:56:55',NULL),(2421,7489,40727,12538,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',6500.00,NULL,NULL,1,'2024-03-14 09:56:55','2024-03-14 09:56:55',NULL),(2422,7489,40727,12538,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',12000.00,NULL,NULL,1,'2024-03-14 09:56:55','2024-03-14 09:56:55',NULL),(2423,7489,40727,12538,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',404176.57,NULL,NULL,1,'2024-03-14 09:57:13','2024-03-14 09:57:13',NULL),(2424,7489,40727,12538,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',198367.12,NULL,NULL,1,'2024-03-14 09:57:13','2024-03-14 09:57:13',NULL);
INSERT INTO `balance_libro` VALUES (2425,7489,40727,12538,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',27200.00,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2426,7489,40727,12538,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',30000.00,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2427,7489,40727,12538,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',20125.00,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2428,7489,40727,12538,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',23357.09,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2429,7489,40727,12538,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',18164.44,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2430,7489,40727,12538,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',23585.63,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2431,7489,40727,12538,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',40347.00,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2432,7489,40727,12538,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',22489.72,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2433,7489,40727,12538,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',26990.00,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2434,7489,40727,12538,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',35893.09,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2435,7489,40727,12538,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',244228.99,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2436,7489,40727,12538,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',12609.41,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2437,7489,40727,12538,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',89618.15,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2438,7489,40727,12538,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',34174.15,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2439,7489,40727,12538,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',12000.01,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2440,7489,40727,12538,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',84948.07,NULL,NULL,1,'2024-03-14 09:57:14','2024-03-14 09:57:14',NULL),(2441,7489,40727,12538,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-18','2024-02-18',56803.95,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 10:02:41','2024-03-14 10:02:41'),(2442,7489,40727,12538,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',50055.64,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2443,7489,40727,12538,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',36967.80,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2444,7489,40727,12538,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',88868.17,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL);
INSERT INTO `balance_libro` VALUES (2445,7489,40727,12538,3,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',91800.70,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2446,7489,40727,12538,3,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',153448.79,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2447,7489,40727,12538,3,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',6169.60,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2448,7489,40727,12538,3,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',51081.36,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2449,7489,40727,12538,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',108042.69,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2450,7489,40727,12538,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',18002.50,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2451,7489,40727,12538,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',175325.90,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:58:51','2024-03-14 09:58:51'),(2452,7489,40727,12538,3,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',45999.56,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2453,7489,40727,12538,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',56856.93,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2454,7489,40727,12538,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',106575.29,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2455,7489,40727,12538,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',10048.14,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2456,7489,40727,12538,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',30000.00,NULL,NULL,1,'2024-03-14 09:57:15','2024-03-14 09:57:15',NULL),(2457,7489,40727,12538,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',11600.03,NULL,NULL,1,'2024-03-14 09:57:16','2024-03-14 09:57:16',NULL),(2458,7489,40727,12538,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1000.00,NULL,NULL,1,'2024-03-14 09:57:16','2024-03-14 09:58:38','2024-03-14 09:58:38'),(2459,7489,40727,12538,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',45000.00,NULL,NULL,1,'2024-03-14 09:57:16','2024-03-14 09:58:31','2024-03-14 09:58:31'),(2460,7489,40727,12538,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-18','2024-02-18',56803.95,NULL,NULL,1,'2024-03-14 10:02:41','2024-03-14 10:02:41',NULL),(2461,7489,40724,7794,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',144046557.53,NULL,NULL,1,'2024-03-18 09:53:23','2024-03-18 09:53:23',NULL),(2462,7489,40724,7794,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',140011200.23,NULL,NULL,1,'2024-03-18 09:57:44','2024-03-18 09:57:44',NULL),(2463,7489,40724,7794,15,2463,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',22654798.45,'Liquidacion mensual',NULL,1,'2024-03-18 10:01:40','2024-03-18 10:01:40',NULL),(2464,7489,40724,7794,16,2464,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',4996900.53,'Liquidacion mensual',NULL,1,'2024-03-18 10:15:01','2024-03-18 10:15:01',NULL);
INSERT INTO `balance_libro` VALUES (2465,7489,40799,17260,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',503360.00,NULL,NULL,1,'2024-03-19 09:36:22','2024-03-19 09:36:22',NULL),(2466,7489,40799,17260,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',11446.40,NULL,NULL,1,'2024-03-19 09:36:36','2024-03-19 09:38:45','2024-03-19 09:38:45'),(2467,7489,40799,17260,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',11457.92,NULL,NULL,1,'2024-03-19 09:36:36','2024-03-19 09:39:30','2024-03-19 09:39:30'),(2468,7489,40799,17260,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',92183.28,NULL,NULL,1,'2024-03-19 09:36:36','2024-03-19 09:40:56','2024-03-19 09:40:56'),(2469,7489,40799,17260,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-12','2024-02-12',7268.40,NULL,NULL,1,'2024-03-19 09:36:36','2024-03-19 10:04:51','2024-03-19 10:04:51'),(2470,7489,40799,17260,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',99120.16,NULL,NULL,1,'2024-03-19 09:36:36','2024-03-19 09:42:41','2024-03-19 09:42:41'),(2471,7489,40799,17260,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',15000.00,NULL,NULL,1,'2024-03-19 09:36:36','2024-03-19 09:41:23','2024-03-19 09:41:23'),(2472,7489,40799,17260,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-25','2024-02-25',36366.01,NULL,NULL,1,'2024-03-19 09:36:36','2024-03-19 10:04:28','2024-03-19 10:04:28'),(2473,7489,40799,17260,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',11446.40,NULL,NULL,1,'2024-03-19 09:38:45','2024-03-19 09:38:45',NULL),(2474,7489,40799,17260,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',11457.92,NULL,NULL,1,'2024-03-19 09:39:30','2024-03-19 09:39:30',NULL),(2475,7489,40799,17260,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',92183.28,NULL,NULL,1,'2024-03-19 09:40:56','2024-03-19 09:40:56',NULL),(2476,7489,40799,17260,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',15000.00,NULL,NULL,1,'2024-03-19 09:41:23','2024-03-19 09:41:23',NULL),(2477,7489,40799,17260,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',99120.16,NULL,NULL,1,'2024-03-19 09:42:41','2024-03-19 09:42:41',NULL),(2478,7489,40799,17260,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-25','2024-02-25',36366.01,NULL,NULL,1,'2024-03-19 10:04:28','2024-03-19 10:08:03','2024-03-19 10:08:03'),(2479,7489,40799,17260,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-12','2024-02-12',7268.40,NULL,NULL,1,'2024-03-19 10:04:51','2024-03-19 10:07:00','2024-03-19 10:07:00'),(2480,7489,40799,17260,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-12','2024-02-12',7268.40,NULL,NULL,1,'2024-03-19 10:07:00','2024-03-19 10:07:00',NULL),(2481,7489,40799,17260,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-25','2024-02-25',36366.01,NULL,NULL,1,'2024-03-19 10:08:03','2024-03-19 10:08:03',NULL),(2482,7489,40725,9370,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',28299.07,NULL,NULL,1,'2024-03-28 15:42:52','2024-03-28 15:42:52',NULL),(2483,7489,40725,9370,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',28503.48,NULL,NULL,1,'2024-03-28 15:43:28','2024-03-28 15:43:28',NULL),(2484,7489,40725,9370,3,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',37884.23,NULL,NULL,1,'2024-03-28 15:44:03','2024-03-28 15:44:03',NULL);
INSERT INTO `balance_libro` VALUES (2485,7489,40725,9370,3,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',32298.10,NULL,NULL,1,'2024-03-28 15:44:57','2024-03-28 15:44:57',NULL),(2486,7489,40725,9370,3,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',33084.71,NULL,NULL,1,'2024-03-28 15:45:46','2024-03-28 15:45:46',NULL),(2487,7489,40725,9370,3,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',426377.77,NULL,NULL,1,'2024-03-28 15:49:14','2024-03-28 15:49:14',NULL),(2488,7489,40725,9370,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',428132.42,NULL,NULL,1,'2024-03-28 15:50:35','2024-03-28 15:50:35',NULL),(2489,7489,40724,7794,1,2489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-02-29',NULL,11692911.82,NULL,NULL,1,'2024-04-03 15:08:06','2024-04-03 15:08:06',NULL),(2490,7489,40726,10921,1,2490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-02-29',NULL,460509.92,NULL,NULL,1,'2024-04-03 15:47:12','2024-04-03 15:47:12',NULL),(2491,7489,40725,9370,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',28004.60,NULL,NULL,1,'2024-04-04 09:20:23','2024-04-04 09:23:33','2024-04-04 09:23:33'),(2492,7489,40725,9370,3,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',59886.62,NULL,NULL,1,'2024-04-04 09:21:42','2024-04-04 09:21:42',NULL),(2493,7489,40725,9370,3,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',29355.98,NULL,NULL,1,'2024-04-04 09:22:45','2024-04-04 09:22:45',NULL),(2494,7489,40725,9370,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',28004.60,NULL,NULL,1,'2024-04-04 09:23:33','2024-04-04 09:25:23','2024-04-04 09:25:23'),(2495,7489,40725,9370,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',37999.57,NULL,NULL,1,'2024-04-04 09:25:23','2024-04-04 09:25:23',NULL),(2496,7489,40727,12538,1,2496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-02-29',NULL,804206.47,NULL,NULL,1,'2024-04-05 10:48:38','2024-04-05 10:48:38',NULL),(2497,7489,40728,14263,1,2497,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-02-29',NULL,1699836.00,NULL,NULL,1,'2024-04-06 09:20:02','2024-04-06 09:20:02',NULL),(2498,7489,40725,9369,1,2498,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-02-29',NULL,523855.15,NULL,NULL,1,'2024-04-06 12:22:06','2024-04-06 12:22:06',NULL),(2499,7489,40724,7795,1,2499,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-03-31',NULL,13322869.64,NULL,NULL,1,'2024-04-08 15:38:14','2024-04-08 15:38:14',NULL),(2500,7489,40728,14264,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',454397.00,NULL,NULL,1,'2024-04-16 10:34:52','2024-04-16 10:34:52',NULL),(2501,7489,40728,14264,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',537785.66,NULL,NULL,1,'2024-04-16 10:34:52','2024-04-16 10:34:52',NULL),(2502,7489,40728,14264,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',542966.45,NULL,NULL,1,'2024-04-16 10:34:52','2024-04-16 10:34:52',NULL),(2503,7489,40728,14264,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',443609.16,NULL,NULL,1,'2024-04-16 10:34:52','2024-04-16 10:34:52',NULL),(2504,7489,40728,14264,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',628758.09,NULL,NULL,1,'2024-04-16 10:34:52','2024-04-16 10:34:52',NULL);
INSERT INTO `balance_libro` VALUES (2505,7489,40728,14264,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',182392.00,NULL,NULL,1,'2024-04-16 10:34:52','2024-04-16 10:34:52',NULL),(2506,7489,40728,14264,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-10','2024-03-10',41545.00,NULL,NULL,1,'2024-04-16 10:34:52','2024-04-16 10:34:52',NULL),(2507,7489,40728,14264,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',114412.00,NULL,NULL,1,'2024-04-16 10:34:52','2024-04-16 10:34:52',NULL),(2508,7489,40728,14264,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',50000.00,NULL,NULL,1,'2024-04-16 10:34:52','2024-04-16 10:34:52',NULL),(2509,7489,40728,14264,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',241786.73,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2510,7489,40728,14264,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',174421.12,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2511,7489,40728,14264,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',497773.95,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:43:07','2024-04-16 10:43:07'),(2512,7489,40728,14264,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',226583.31,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2513,7489,40728,14264,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',319745.21,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2514,7489,40728,14264,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',114018.98,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2515,7489,40728,14264,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',86785.59,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2516,7489,40728,14264,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',273602.29,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2517,7489,40728,14264,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',279770.09,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2518,7489,40728,14264,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',77675.00,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2519,7489,40728,14264,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',267602.01,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2520,7489,40728,14264,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',283980.49,NULL,NULL,1,'2024-04-16 10:34:53','2024-04-16 10:34:53',NULL),(2521,7489,40728,14264,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',400920.63,NULL,NULL,1,'2024-04-16 10:34:54','2024-04-16 10:34:54',NULL),(2522,7489,40728,14264,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',200727.20,NULL,NULL,1,'2024-04-16 10:34:54','2024-04-16 10:34:54',NULL),(2523,7489,40728,14264,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',185914.08,NULL,NULL,1,'2024-04-16 10:34:54','2024-04-16 10:34:54',NULL),(2524,7489,40728,14264,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',498373.95,NULL,NULL,1,'2024-04-16 10:43:07','2024-04-16 10:43:07',NULL);
INSERT INTO `balance_libro` VALUES (2525,7489,40728,14264,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',12840661.44,NULL,NULL,1,'2024-04-16 10:47:06','2024-04-16 10:47:06',NULL),(2526,7489,40728,14264,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',245832.37,NULL,NULL,1,'2024-04-16 10:47:43','2024-04-16 10:47:43',NULL),(2527,7489,40728,14264,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1451797.51,NULL,NULL,1,'2024-04-16 10:48:08','2024-04-16 10:48:08',NULL),(2528,7489,40725,9370,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',134539.00,NULL,NULL,1,'2024-04-17 12:40:43','2024-04-17 12:47:36','2024-04-17 12:47:36'),(2529,7489,40725,9370,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',155490.00,NULL,NULL,1,'2024-04-17 12:40:43','2024-04-17 12:46:56','2024-04-17 12:46:56'),(2530,7489,40725,9370,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',738100.00,NULL,NULL,1,'2024-04-17 12:40:44','2024-04-17 12:40:44',NULL),(2531,7489,40725,9370,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',127000.00,NULL,NULL,1,'2024-04-17 12:40:44','2024-04-17 12:48:04','2024-04-17 12:48:04'),(2532,7489,40725,9370,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',3315758.00,NULL,NULL,1,'2024-04-17 12:40:44','2024-04-17 12:46:22','2024-04-17 12:46:22'),(2533,7489,40725,9370,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',738100.00,NULL,NULL,1,'2024-04-17 12:40:44','2024-04-17 12:40:44',NULL),(2534,7489,40725,9370,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',665000.00,NULL,NULL,1,'2024-04-17 12:40:44','2024-04-17 12:45:40','2024-04-17 12:45:40'),(2535,7489,40725,9370,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',134539.00,NULL,NULL,1,'2024-04-17 12:40:44','2024-04-17 12:45:06','2024-04-17 12:45:06'),(2536,7489,40725,9370,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',144924.00,NULL,NULL,1,'2024-04-17 12:40:44','2024-04-17 12:40:44',NULL),(2537,7489,40725,9370,3,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',614.88,NULL,NULL,1,'2024-04-17 12:41:50','2024-04-17 12:41:50',NULL),(2538,7489,40725,9370,3,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',113505.27,NULL,NULL,1,'2024-04-17 12:41:50','2024-04-17 12:43:51','2024-04-17 12:43:51'),(2539,7489,40725,9370,3,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',80604.15,NULL,NULL,1,'2024-04-17 12:41:50','2024-04-17 12:41:50',NULL),(2540,7489,40725,9370,3,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',131039.37,NULL,NULL,1,'2024-04-17 12:41:51','2024-04-17 12:41:51',NULL),(2541,7489,40725,9370,3,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',55572.88,NULL,NULL,1,'2024-04-17 12:41:51','2024-04-17 12:41:51',NULL),(2542,7489,40725,9370,3,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',240312.05,NULL,NULL,1,'2024-04-17 12:41:51','2024-04-17 12:41:51',NULL),(2543,7489,40725,9370,3,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',105654.80,NULL,NULL,1,'2024-04-17 12:41:51','2024-04-17 12:41:51',NULL),(2544,7489,40725,9370,3,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',300.00,NULL,NULL,1,'2024-04-17 12:41:51','2024-04-17 12:43:07','2024-04-17 12:43:07');
INSERT INTO `balance_libro` VALUES (2545,7489,40725,9370,3,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',50000.00,NULL,NULL,1,'2024-04-17 12:41:51','2024-04-17 12:42:38','2024-04-17 12:42:38'),(2546,7489,40725,9370,3,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',50000.00,NULL,NULL,1,'2024-04-17 12:42:38','2024-04-17 12:42:38',NULL),(2547,7489,40725,9370,3,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',300.00,NULL,NULL,1,'2024-04-17 12:43:07','2024-04-17 12:43:07',NULL),(2548,7489,40725,9370,3,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',113505.27,NULL,NULL,1,'2024-04-17 12:43:51','2024-04-17 12:43:51',NULL),(2549,7489,40725,9370,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',134539.00,NULL,NULL,1,'2024-04-17 12:45:06','2024-04-17 12:45:06',NULL),(2550,7489,40725,9370,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',665000.00,NULL,NULL,1,'2024-04-17 12:45:40','2024-04-17 12:45:40',NULL),(2551,7489,40725,9370,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',3315758.00,NULL,NULL,1,'2024-04-17 12:46:22','2024-04-17 12:46:22',NULL),(2552,7489,40725,9370,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',155490.00,NULL,NULL,1,'2024-04-17 12:46:56','2024-04-17 12:46:56',NULL),(2553,7489,40725,9370,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',134539.00,NULL,NULL,1,'2024-04-17 12:47:36','2024-04-17 12:47:36',NULL),(2554,7489,40725,9370,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',127000.00,NULL,NULL,1,'2024-04-17 12:48:04','2024-04-17 12:48:04',NULL),(2555,7489,40725,9370,3,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',114638.01,NULL,NULL,1,'2024-04-17 15:39:56','2024-04-17 15:39:56',NULL),(2556,7489,40727,12539,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',40000.00,NULL,NULL,1,'2024-04-18 08:23:21','2024-04-18 08:23:21',NULL),(2557,7489,40727,12539,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',562978.63,NULL,NULL,1,'2024-04-18 08:23:21','2024-04-18 08:23:21',NULL),(2558,7489,40727,12539,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',13440.00,NULL,NULL,1,'2024-04-18 08:23:21','2024-04-18 08:23:21',NULL),(2559,7489,40727,12539,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',711.79,NULL,NULL,1,'2024-04-18 08:23:21','2024-04-18 08:23:21',NULL),(2560,7489,40727,12539,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',112050.44,NULL,NULL,1,'2024-04-18 08:23:21','2024-04-18 08:30:49','2024-04-18 08:30:49'),(2561,7489,40727,12539,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',8567.03,NULL,NULL,1,'2024-04-18 08:23:21','2024-04-18 08:23:21',NULL),(2562,7489,40727,12539,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',106843.36,NULL,NULL,1,'2024-04-18 08:23:22','2024-04-18 08:23:22',NULL),(2563,7489,40727,12539,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',127790.70,NULL,NULL,1,'2024-04-18 08:23:22','2024-04-18 08:30:09','2024-04-18 08:30:09'),(2564,7489,40727,12539,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',1807552.63,NULL,NULL,1,'2024-04-18 08:23:22','2024-04-18 08:23:22',NULL);
INSERT INTO `balance_libro` VALUES (2565,7489,40727,12539,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',2572132.94,NULL,NULL,1,'2024-04-18 08:23:22','2024-04-18 08:23:22',NULL),(2566,7489,40727,12539,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',229689.74,NULL,NULL,1,'2024-04-18 08:23:22','2024-04-18 08:29:12','2024-04-18 08:29:12'),(2567,7489,40727,12539,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',403491.80,NULL,NULL,1,'2024-04-18 08:24:11','2024-04-18 08:24:11',NULL),(2568,7489,40727,12539,3,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',29079.93,NULL,NULL,1,'2024-04-18 08:24:11','2024-04-18 08:24:11',NULL),(2569,7489,40727,12539,3,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',107023.88,NULL,NULL,1,'2024-04-18 08:24:11','2024-04-18 08:24:11',NULL),(2570,7489,40727,12539,3,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',94551.69,NULL,NULL,1,'2024-04-18 08:24:11','2024-04-18 08:24:11',NULL),(2571,7489,40727,12539,3,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',26696.47,NULL,NULL,1,'2024-04-18 08:24:11','2024-04-18 08:24:11',NULL),(2572,7489,40727,12539,3,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',21017.66,NULL,NULL,1,'2024-04-18 08:24:11','2024-04-18 08:24:11',NULL),(2573,7489,40727,12539,3,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-10','2024-03-10',200013.00,NULL,NULL,1,'2024-04-18 08:24:11','2024-04-18 08:24:11',NULL),(2574,7489,40727,12539,3,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',124681.38,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:24:12',NULL),(2575,7489,40727,12539,3,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',32503.82,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:24:12',NULL),(2576,7489,40727,12539,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',25199.97,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:24:12',NULL),(2577,7489,40727,12539,3,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',67205.06,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:24:12',NULL),(2578,7489,40727,12539,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',69009.08,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:24:12',NULL),(2579,7489,40727,12539,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',44007.62,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:48:07','2024-04-18 08:48:07'),(2580,7489,40727,12539,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',12000.01,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:24:12',NULL),(2581,7489,40727,12539,3,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',218775.91,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:24:12',NULL),(2582,7489,40727,12539,3,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',266091.32,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:24:12',NULL),(2583,7489,40727,12539,3,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',37559.74,NULL,NULL,1,'2024-04-18 08:24:12','2024-04-18 08:24:12',NULL),(2584,7489,40727,12539,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',93766.51,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL);
INSERT INTO `balance_libro` VALUES (2585,7489,40727,12539,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',33608.96,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2586,7489,40727,12539,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',68634.10,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2587,7489,40727,12539,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',54924.08,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2588,7489,40727,12539,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',207006.80,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2589,7489,40727,12539,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',62480.77,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2590,7489,40727,12539,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',15550.00,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2591,7489,40727,12539,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',13199.99,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2592,7489,40727,12539,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',20125.00,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2593,7489,40727,12539,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',40347.00,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2594,7489,40727,12539,3,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',30000.00,NULL,NULL,1,'2024-04-18 08:24:13','2024-04-18 08:24:13',NULL),(2595,7489,40727,12539,3,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',2743.42,NULL,NULL,1,'2024-04-18 08:24:14','2024-04-18 08:24:14',NULL),(2596,7489,40727,12539,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',229689.79,NULL,NULL,1,'2024-04-18 08:29:12','2024-04-18 08:29:12',NULL),(2597,7489,40727,12539,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',127790.70,NULL,NULL,1,'2024-04-18 08:30:09','2024-04-18 08:30:09',NULL),(2598,7489,40727,12539,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',112050.44,NULL,NULL,1,'2024-04-18 08:30:49','2024-04-18 08:30:49',NULL),(2599,7489,40727,12539,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',44007.62,NULL,NULL,1,'2024-04-18 08:48:07','2024-04-18 08:48:07',NULL),(2600,7489,40728,14264,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',85480.49,NULL,NULL,1,'2024-04-18 09:02:21','2024-04-18 09:02:21',NULL),(2601,7489,40728,14264,3,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',16701.55,NULL,NULL,1,'2024-04-18 09:02:21','2024-04-18 09:02:21',NULL),(2602,7489,40728,14264,3,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',389771.56,NULL,NULL,1,'2024-04-18 09:02:21','2024-04-18 09:02:21',NULL),(2603,7489,40728,14264,3,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',107992.99,NULL,NULL,1,'2024-04-18 09:02:21','2024-04-18 09:02:21',NULL),(2604,7489,40728,14264,3,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',11118.73,NULL,NULL,1,'2024-04-18 09:02:21','2024-04-18 09:02:21',NULL);
INSERT INTO `balance_libro` VALUES (2605,7489,40728,14264,3,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',16425.07,NULL,NULL,1,'2024-04-18 09:02:21','2024-04-18 09:02:21',NULL),(2606,7489,40728,14264,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',141116.98,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2607,7489,40728,14264,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',24039.95,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2608,7489,40728,14264,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',141737.39,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2609,7489,40728,14264,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',150313.87,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2610,7489,40728,14264,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',651580.04,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2611,7489,40728,14264,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',108192.44,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2612,7489,40728,14264,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',83392.74,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2613,7489,40728,14264,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',140863.97,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2614,7489,40728,14264,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',82001.86,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2615,7489,40728,14264,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',215738.90,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2616,7489,40728,14264,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',180031.77,NULL,NULL,1,'2024-04-18 09:02:22','2024-04-18 09:02:22',NULL),(2617,7489,40728,14264,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',477507.16,NULL,NULL,1,'2024-04-18 09:02:23','2024-04-18 09:02:23',NULL),(2618,7489,40728,14264,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',25954.73,NULL,NULL,1,'2024-04-18 09:02:23','2024-04-18 09:02:23',NULL),(2619,7489,40728,14264,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',2028.23,NULL,NULL,1,'2024-04-18 09:02:23','2024-04-18 09:02:23',NULL),(2620,7489,40728,14264,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',630466.79,NULL,NULL,1,'2024-04-18 09:02:23','2024-04-18 09:02:23',NULL),(2621,7489,40728,14264,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',1735.59,NULL,NULL,1,'2024-04-18 09:02:23','2024-04-18 09:02:23',NULL),(2622,7489,40728,14264,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',19549.59,NULL,NULL,1,'2024-04-18 09:02:23','2024-04-18 09:02:23',NULL),(2623,7489,40728,14264,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',338216.30,NULL,NULL,1,'2024-04-18 09:02:23','2024-04-18 09:02:23',NULL),(2624,7489,40728,14264,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',51909.45,NULL,NULL,1,'2024-04-18 09:02:23','2024-04-18 09:02:23',NULL);
INSERT INTO `balance_libro` VALUES (2625,7489,40728,14264,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',16678.09,NULL,NULL,1,'2024-04-18 09:02:23','2024-04-18 09:02:23',NULL),(2626,7489,40728,14264,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',408619.90,NULL,NULL,1,'2024-04-18 09:02:24','2024-04-18 09:02:24',NULL),(2627,7489,40728,14264,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',19131.32,NULL,NULL,1,'2024-04-18 09:02:24','2024-04-18 09:02:24',NULL),(2628,7489,40728,14264,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',368642.56,NULL,NULL,1,'2024-04-18 09:02:24','2024-04-18 09:02:24',NULL),(2629,7489,40728,14264,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',675237.11,NULL,NULL,1,'2024-04-18 09:02:24','2024-04-18 09:02:24',NULL),(2630,7489,40728,14264,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',34876.15,NULL,NULL,1,'2024-04-18 09:02:24','2024-04-18 09:02:24',NULL),(2631,7489,40728,14264,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',1357.00,NULL,NULL,1,'2024-04-18 09:02:24','2024-04-18 09:02:24',NULL),(2632,7489,40728,14264,3,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',2084.21,NULL,NULL,1,'2024-04-18 09:02:24','2024-04-18 09:02:24',NULL),(2633,7489,40728,14264,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',225300.55,NULL,NULL,1,'2024-04-18 09:02:24','2024-04-18 09:02:24',NULL),(2634,7489,40728,14264,3,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',81384.21,NULL,NULL,1,'2024-04-18 09:02:25','2024-04-18 09:02:25',NULL),(2635,7489,40728,14264,3,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',37698.22,NULL,NULL,1,'2024-04-18 09:02:25','2024-04-18 09:02:25',NULL),(2636,7489,40728,14264,3,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',10151.82,NULL,NULL,1,'2024-04-18 09:02:25','2024-04-18 09:02:25',NULL),(2637,7489,40728,14264,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',174787.30,NULL,NULL,1,'2024-04-18 09:02:25','2024-04-18 09:02:25',NULL),(2638,7489,40728,14264,3,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',435434.01,NULL,NULL,1,'2024-04-18 09:02:25','2024-04-18 09:02:25',NULL),(2639,7489,40728,14264,3,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',536423.28,NULL,NULL,1,'2024-04-18 09:02:25','2024-04-18 09:02:25',NULL),(2640,7489,40728,14264,3,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',290064.26,NULL,NULL,1,'2024-04-18 09:02:25','2024-04-18 09:02:25',NULL),(2641,7489,40728,14264,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',542858.69,NULL,NULL,1,'2024-04-18 09:02:25','2024-04-18 09:02:25',NULL),(2642,7489,40728,14264,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',221982.06,NULL,NULL,1,'2024-04-18 09:02:25','2024-04-18 09:02:25',NULL),(2643,7489,40728,14264,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',468394.17,NULL,NULL,1,'2024-04-18 09:02:26','2024-04-18 09:02:26',NULL),(2644,7489,40728,14264,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',579787.14,NULL,NULL,1,'2024-04-18 09:02:26','2024-04-18 09:02:26',NULL);
INSERT INTO `balance_libro` VALUES (2645,7489,40728,14264,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',675930.24,NULL,NULL,1,'2024-04-18 09:02:26','2024-04-18 09:02:26',NULL),(2646,7489,40728,14264,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',15780.05,NULL,NULL,1,'2024-04-18 09:02:26','2024-04-18 09:02:26',NULL),(2647,7489,40728,14264,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',3503.87,NULL,NULL,1,'2024-04-18 09:02:26','2024-04-18 09:02:26',NULL),(2648,7489,40728,14264,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',230227.06,NULL,NULL,1,'2024-04-18 09:02:26','2024-04-18 09:02:26',NULL),(2649,7489,40728,14264,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',21089.93,NULL,NULL,1,'2024-04-18 09:02:26','2024-04-18 09:02:26',NULL),(2650,7489,40728,14264,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',28030.78,NULL,NULL,1,'2024-04-18 09:02:26','2024-04-18 09:02:26',NULL),(2651,7489,40728,14264,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',494246.23,NULL,NULL,1,'2024-04-18 09:02:27','2024-04-18 09:02:27',NULL),(2652,7489,40728,14264,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',11118.73,NULL,NULL,1,'2024-04-18 09:02:27','2024-04-18 09:02:27',NULL),(2653,7489,40728,14264,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',506610.73,NULL,NULL,1,'2024-04-18 09:02:27','2024-04-18 09:02:27',NULL),(2654,7489,40728,14264,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',151620.32,NULL,NULL,1,'2024-04-18 09:02:27','2024-04-18 09:02:27',NULL),(2655,7489,40728,14264,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',135587.03,NULL,NULL,1,'2024-04-18 09:02:27','2024-04-18 09:02:27',NULL),(2656,7489,40728,14264,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',15780.05,NULL,NULL,1,'2024-04-18 09:02:27','2024-04-18 09:02:27',NULL),(2657,7489,40728,14264,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',16493.65,NULL,NULL,1,'2024-04-18 09:02:27','2024-04-18 09:02:27',NULL),(2658,7489,40728,14264,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',48321.56,NULL,NULL,1,'2024-04-18 09:02:27','2024-04-18 09:02:27',NULL),(2659,7489,40728,14264,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',127011.18,NULL,NULL,1,'2024-04-18 09:02:28','2024-04-18 09:02:28',NULL),(2660,7489,40728,14264,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',41570.71,NULL,NULL,1,'2024-04-18 09:02:28','2024-04-18 09:02:28',NULL),(2661,7489,40728,14264,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',6150.89,NULL,NULL,1,'2024-04-18 09:02:28','2024-04-18 09:02:28',NULL),(2662,7489,40728,14264,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',21958.19,NULL,NULL,1,'2024-04-18 09:02:28','2024-04-18 09:02:28',NULL),(2663,7489,40728,14264,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',3055.74,NULL,NULL,1,'2024-04-18 09:02:28','2024-04-18 09:02:28',NULL),(2664,7489,40728,14264,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',547607.43,NULL,NULL,1,'2024-04-18 09:02:28','2024-04-18 09:02:28',NULL);
INSERT INTO `balance_libro` VALUES (2665,7489,40728,14264,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',669488.75,NULL,NULL,1,'2024-04-18 09:02:28','2024-04-18 09:02:28',NULL),(2666,7489,40728,14264,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',24906.50,NULL,NULL,1,'2024-04-18 09:02:28','2024-04-18 09:02:28',NULL),(2667,7489,40728,14264,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',12644.39,NULL,NULL,1,'2024-04-18 09:02:28','2024-04-18 09:02:28',NULL),(2668,7489,40728,14264,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',11574.75,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2669,7489,40728,14264,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',382409.73,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2670,7489,40728,14264,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',932102.39,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2671,7489,40728,14264,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',11245.04,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2672,7489,40728,14264,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',170713.29,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2673,7489,40728,14264,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',53639.93,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2674,7489,40728,14264,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',17200.27,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2675,7489,40728,14264,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',182628.37,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2676,7489,40728,14264,3,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',5533.76,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2677,7489,40728,14264,3,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',180525.99,NULL,NULL,1,'2024-04-18 09:02:29','2024-04-18 09:02:29',NULL),(2678,7489,40728,14264,3,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',9780.11,NULL,NULL,1,'2024-04-18 09:02:30','2024-04-18 09:02:30',NULL),(2679,7489,40728,14264,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',676717.51,NULL,NULL,1,'2024-04-18 09:02:30','2024-04-18 09:02:30',NULL),(2680,7489,40728,14264,3,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',320523.21,NULL,NULL,1,'2024-04-18 09:02:30','2024-04-18 09:02:30',NULL),(2681,7489,40728,14264,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',116746.71,NULL,NULL,1,'2024-04-18 09:02:30','2024-04-18 09:02:30',NULL),(2682,7489,40728,14264,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',4744.20,NULL,NULL,1,'2024-04-18 09:02:30','2024-04-18 09:02:30',NULL),(2683,7489,40728,14264,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',463274.94,NULL,NULL,1,'2024-04-18 09:02:30','2024-04-18 09:02:30',NULL),(2684,7489,40728,14264,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',441223.69,NULL,NULL,1,'2024-04-18 09:02:30','2024-04-18 09:02:30',NULL);
INSERT INTO `balance_libro` VALUES (2685,7489,40728,14264,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',14919.90,NULL,NULL,1,'2024-04-18 09:02:30','2024-04-18 09:02:30',NULL),(2686,7489,40728,14264,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',275790.61,NULL,NULL,1,'2024-04-18 09:02:30','2024-04-18 09:02:30',NULL),(2687,7489,40728,14264,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',8375.45,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2688,7489,40728,14264,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',17200.26,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2689,7489,40728,14264,3,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',44297.13,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2690,7489,40728,14264,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',703410.72,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2691,7489,40728,14264,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',75204.10,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2692,7489,40728,14264,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',15940.07,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2693,7489,40728,14264,3,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',1101694.51,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2694,7489,40728,14264,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',50429.64,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2695,7489,40728,14264,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',396634.07,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2696,7489,40728,14264,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',381691.68,NULL,NULL,1,'2024-04-18 09:02:31','2024-04-18 09:02:31',NULL),(2697,7489,40728,14264,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',8807.95,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL),(2698,7489,40728,14264,3,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',631915.73,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL),(2699,7489,40728,14264,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',2268.11,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL),(2700,7489,40728,14264,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',5396.71,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL),(2701,7489,40728,14264,3,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',533928.61,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL),(2702,7489,40728,14264,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',15778.22,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL),(2703,7489,40728,14264,3,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',393946.67,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL),(2704,7489,40728,14264,3,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',609544.97,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL),(2705,7489,40728,14264,3,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',0.01,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL);
INSERT INTO `balance_libro` VALUES (2706,7489,40728,14264,3,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',4744.20,NULL,NULL,1,'2024-04-18 09:02:32','2024-04-18 09:02:32',NULL),(2707,7489,40728,14264,3,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',309104.53,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2708,7489,40728,14264,3,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',5837.34,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2709,7489,40728,14264,3,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',6241.20,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2710,7489,40728,14264,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',448856.42,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2711,7489,40728,14264,3,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',6113.72,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2712,7489,40728,14264,3,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',447717.91,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2713,7489,40728,14264,3,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',36099.82,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2714,7489,40728,14264,3,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',3004.79,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2715,7489,40728,14264,3,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',218172.08,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2716,7489,40728,14264,3,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',9112.24,NULL,NULL,1,'2024-04-18 09:02:33','2024-04-18 09:02:33',NULL),(2717,7489,40728,14264,3,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',81919.46,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL),(2718,7489,40728,14264,3,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',8139.06,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL),(2719,7489,40728,14264,3,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',95850.77,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL),(2720,7489,40728,14264,3,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',4218.10,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL),(2721,7489,40728,14264,3,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',14215.67,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL),(2722,7489,40728,14264,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',37630.11,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL),(2723,7489,40728,14264,3,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',79086.90,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL),(2724,7489,40728,14264,3,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',64406.48,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL),(2725,7489,40728,14264,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',23102.29,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL),(2726,7489,40728,14264,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',47840.86,NULL,NULL,1,'2024-04-18 09:02:34','2024-04-18 09:02:34',NULL);
INSERT INTO `balance_libro` VALUES (2727,7489,40728,14264,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',214919.36,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2728,7489,40728,14264,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',699891.60,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2729,7489,40728,14264,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',444872.50,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2730,7489,40728,14264,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',1248.45,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2731,7489,40728,14264,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',35340.61,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2732,7489,40728,14264,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',68573.70,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2733,7489,40728,14264,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',17512.02,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2734,7489,40728,14264,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',18727.95,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2735,7489,40728,14264,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',304054.50,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2736,7489,40728,14264,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',1502.25,NULL,NULL,1,'2024-04-18 09:02:35','2024-04-18 09:02:35',NULL),(2737,7489,40728,14264,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',9363.97,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL),(2738,7489,40728,14264,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',11097.79,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL),(2739,7489,40728,14264,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',93158.37,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL),(2740,7489,40728,14264,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',21480.01,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL),(2741,7489,40728,14264,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',3624.12,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL),(2742,7489,40728,14264,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',148965.93,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL),(2743,7489,40728,14264,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',27495.84,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL),(2744,7489,40728,14264,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',282371.16,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL),(2745,7489,40728,14264,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',72182.41,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL),(2746,7489,40728,14264,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',394509.23,NULL,NULL,1,'2024-04-18 09:02:36','2024-04-18 09:02:36',NULL);
INSERT INTO `balance_libro` VALUES (2747,7489,40728,14264,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',302998.30,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2748,7489,40728,14264,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',224810.84,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2749,7489,40728,14264,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',304409.31,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2750,7489,40728,14264,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',161676.98,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2751,7489,40728,14264,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',70265.67,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2752,7489,40728,14264,3,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',286787.07,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2753,7489,40728,14264,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',11054.23,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2754,7489,40728,14264,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',1003262.17,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2755,7489,40728,14264,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',34848.72,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2756,7489,40728,14264,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',271055.74,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2757,7489,40728,14264,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',281429.26,NULL,NULL,1,'2024-04-18 09:02:37','2024-04-18 09:02:37',NULL),(2758,7489,40728,14264,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',144806.47,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL),(2759,7489,40728,14264,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',41564.08,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL),(2760,7489,40728,14264,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',45107.25,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL),(2761,7489,40728,14264,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',23127.36,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL),(2762,7489,40728,14264,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',342933.38,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL),(2763,7489,40728,14264,3,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',260302.52,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL),(2764,7489,40728,14264,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',12066.12,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL),(2765,7489,40728,14264,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',70000.00,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL),(2766,7489,40728,14264,3,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',289209.00,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL);
INSERT INTO `balance_libro` VALUES (2767,7489,40728,14264,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',4017.85,NULL,NULL,1,'2024-04-18 09:02:38','2024-04-18 09:02:38',NULL),(2768,7489,40728,14264,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',37950.00,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2769,7489,40728,14264,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',3111.54,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2770,7489,40728,14264,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',97688.80,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2771,7489,40728,14264,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',5864.56,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2772,7489,40728,14264,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',48719.53,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2773,7489,40728,14264,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',16436.49,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2774,7489,40728,14264,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',12686.92,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2775,7489,40728,14264,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',44974.93,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2776,7489,40728,14264,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',6995.12,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2777,7489,40728,14264,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',55241.90,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2778,7489,40728,14264,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',120024.06,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2779,7489,40728,14264,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',116746.71,NULL,NULL,1,'2024-04-18 09:02:39','2024-04-18 09:02:39',NULL),(2780,7489,40728,14264,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',23076.99,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2781,7489,40728,14264,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',9557.21,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2782,7489,40728,14264,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1772617.58,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2783,7489,40728,14264,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',61553.57,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2784,7489,40728,14264,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',7443190.84,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2785,7489,40728,14264,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',410415.42,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2786,7489,40728,14264,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',55901.50,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2787,7489,40728,14264,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',37440.66,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL);
INSERT INTO `balance_libro` VALUES (2788,7489,40728,14264,3,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',28161.95,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2789,7489,40728,14264,3,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',42119.32,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2790,7489,40728,14264,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',4860.00,NULL,NULL,1,'2024-04-18 09:02:40','2024-04-18 09:02:40',NULL),(2791,7489,40728,14264,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',66203.76,NULL,NULL,1,'2024-04-18 09:02:41','2024-04-18 09:02:41',NULL),(2792,7489,40799,17261,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',372680.00,NULL,NULL,1,'2024-04-18 15:17:47','2024-04-18 15:17:47',NULL),(2793,7489,40799,17261,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',56628.00,NULL,NULL,1,'2024-04-18 15:17:47','2024-04-18 15:17:47',NULL),(2794,7489,40799,17261,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',125840.00,NULL,NULL,1,'2024-04-18 15:17:47','2024-04-18 15:17:47',NULL),(2795,7489,40799,17261,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',12591.06,NULL,NULL,1,'2024-04-18 15:18:52','2024-04-18 15:33:35','2024-04-18 15:33:35'),(2796,7489,40799,17261,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',12603.72,NULL,NULL,1,'2024-04-18 15:18:52','2024-04-18 15:33:02','2024-04-18 15:33:02'),(2797,7489,40799,17261,3,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',187994.74,NULL,NULL,1,'2024-04-18 15:18:52','2024-04-18 15:29:37','2024-04-18 15:29:37'),(2798,7489,40799,17261,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',9440.55,NULL,NULL,1,'2024-04-18 15:18:52','2024-04-18 15:32:22','2024-04-18 15:32:22'),(2799,7489,40799,17261,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',6196.03,NULL,NULL,1,'2024-04-18 15:18:52','2024-04-18 15:31:32','2024-04-18 15:31:32'),(2800,7489,40799,17261,3,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',163701.69,NULL,NULL,1,'2024-04-18 15:18:52','2024-04-18 15:30:43','2024-04-18 15:30:43'),(2801,7489,40799,17261,3,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',8182.77,NULL,NULL,1,'2024-04-18 15:18:52','2024-04-18 15:28:33','2024-04-18 15:28:33'),(2802,7489,40799,17261,3,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',15614.29,NULL,NULL,1,'2024-04-18 15:18:52','2024-04-18 15:27:42','2024-04-18 15:27:42'),(2803,7489,40799,17261,3,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',47418.91,NULL,NULL,1,'2024-04-18 15:18:52','2025-05-31 09:13:35','2025-05-31 09:13:35'),(2804,7489,40799,17261,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',20000.00,NULL,NULL,1,'2024-04-18 15:18:52','2024-04-18 15:26:05','2024-04-18 15:26:05'),(2805,7489,40799,17261,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',20000.00,NULL,NULL,1,'2024-04-18 15:26:05','2025-05-31 09:13:17','2025-05-31 09:13:17'),(2806,7489,40799,17261,3,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',15614.29,NULL,NULL,1,'2024-04-18 15:27:42','2024-04-18 15:27:42',NULL),(2807,7489,40799,17261,3,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',8182.77,NULL,NULL,1,'2024-04-18 15:28:33','2024-04-18 15:28:33',NULL);
INSERT INTO `balance_libro` VALUES (2808,7489,40799,17261,3,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',187994.74,NULL,NULL,1,'2024-04-18 15:29:37','2024-04-18 15:29:37',NULL),(2809,7489,40799,17261,3,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',163701.69,NULL,NULL,1,'2024-04-18 15:30:43','2024-04-18 15:30:43',NULL),(2810,7489,40799,17261,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',6196.03,NULL,NULL,1,'2024-04-18 15:31:32','2024-04-18 15:31:32',NULL),(2811,7489,40799,17261,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',9440.55,NULL,NULL,1,'2024-04-18 15:32:22','2024-04-18 15:32:22',NULL),(2812,7489,40799,17261,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',12603.72,NULL,NULL,1,'2024-04-18 15:33:02','2024-04-18 15:33:02',NULL),(2813,7489,40799,17261,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',12591.06,NULL,NULL,1,'2024-04-18 15:33:35','2024-04-18 15:33:35',NULL),(2814,7489,40724,7795,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',192200829.92,NULL,NULL,1,'2024-04-19 11:34:23','2024-04-19 11:34:23',NULL),(2815,7489,40724,7795,3,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',176852110.00,NULL,NULL,1,'2024-04-24 08:40:13','2024-04-24 08:59:27','2024-04-24 08:59:27'),(2816,7489,40724,7795,15,2816,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',29988199.48,'Liquidacion mensual',NULL,1,'2024-04-24 08:56:04','2024-04-24 08:56:04',NULL),(2817,7489,40724,7795,16,2817,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',5215260.33,'Liquidacion mensual',NULL,1,'2024-04-24 08:57:56','2024-04-24 08:57:56',NULL),(2818,7489,40724,7795,3,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',176852110.00,NULL,NULL,1,'2024-04-24 08:59:27','2024-04-24 08:59:27',NULL),(2819,7489,40725,9371,3,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',582533.99,NULL,NULL,1,'2024-04-26 11:40:07','2024-04-26 11:40:07',NULL),(2820,7489,40726,10922,1,2820,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-03-31',NULL,460778.45,NULL,NULL,1,'2024-05-02 15:20:12','2024-05-02 15:20:12',NULL),(2821,7489,40727,12539,1,2821,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-03-31',NULL,803423.26,NULL,NULL,1,'2024-05-07 10:00:17','2024-05-07 10:00:17',NULL),(2822,7489,40725,9370,1,2822,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-03-31',NULL,321886.40,NULL,NULL,1,'2024-05-07 12:32:08','2024-05-07 12:32:08',NULL),(2823,7489,40728,14264,1,2823,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-03-31',NULL,1854046.25,NULL,NULL,1,'2024-05-07 15:27:57','2024-05-07 15:27:57',NULL),(2824,7489,40725,9371,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',780450.00,NULL,NULL,1,'2024-05-18 11:01:07','2024-05-18 11:01:07',NULL),(2825,7489,40725,9371,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-02','2024-04-02',155490.00,NULL,NULL,1,'2024-05-18 11:01:07','2024-05-18 11:01:07',NULL),(2826,7489,40725,9371,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',431063.00,NULL,NULL,1,'2024-05-18 11:01:07','2024-05-18 11:01:07',NULL),(2827,7489,40725,9371,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',127000.00,NULL,NULL,1,'2024-05-18 11:01:07','2024-05-18 11:01:07',NULL);
INSERT INTO `balance_libro` VALUES (2828,7489,40725,9371,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',175500.00,NULL,NULL,1,'2024-05-18 11:01:07','2024-05-18 11:01:07',NULL),(2829,7489,40725,9371,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',4012067.00,NULL,NULL,1,'2024-05-18 11:01:07','2024-05-18 11:01:07',NULL),(2830,7489,40725,9371,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',804650.00,NULL,NULL,1,'2024-05-18 11:01:07','2024-05-18 11:01:07',NULL),(2831,7489,40725,9371,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',804650.00,NULL,NULL,1,'2024-05-18 11:01:07','2024-05-18 11:01:07',NULL),(2832,7489,40725,9371,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',995152.40,NULL,NULL,1,'2024-05-18 11:01:07','2024-05-18 11:01:07',NULL),(2833,7489,40725,9371,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',243815.00,NULL,NULL,1,'2024-05-18 11:01:08','2024-05-18 11:01:08',NULL),(2834,7489,40725,9371,3,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',8600.68,NULL,NULL,1,'2024-05-18 11:01:24','2024-05-18 11:01:24',NULL),(2835,7489,40725,9371,3,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',33000.00,NULL,NULL,1,'2024-05-18 11:01:24','2024-05-18 11:01:24',NULL),(2836,7489,40725,9371,3,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',786000.00,NULL,NULL,1,'2024-05-18 11:01:24','2024-05-18 11:01:24',NULL),(2837,7489,40725,9371,3,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',2420.00,NULL,NULL,1,'2024-05-18 11:01:24','2024-05-18 11:01:24',NULL),(2838,7489,40725,9371,3,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',84700.00,NULL,NULL,1,'2024-05-18 11:01:24','2024-05-18 11:01:24',NULL),(2839,7489,40725,9371,3,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',323796.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2840,7489,40725,9371,3,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',27676.98,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2841,7489,40725,9371,3,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',614.88,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2842,7489,40725,9371,3,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',200000.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2843,7489,40725,9371,3,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',200000.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2844,7489,40725,9371,3,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',200000.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2845,7489,40725,9371,3,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',220000.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2846,7489,40725,9371,3,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',200000.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2847,7489,40725,9371,3,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',200000.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2848,7489,40725,9371,3,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',200000.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL);
INSERT INTO `balance_libro` VALUES (2849,7489,40725,9371,3,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',50000.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2850,7489,40725,9371,3,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',220000.00,NULL,NULL,1,'2024-05-18 11:01:25','2024-05-18 11:01:25',NULL),(2851,7489,40725,9371,3,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',25914.07,NULL,NULL,1,'2024-05-18 11:04:24','2024-05-18 11:04:24',NULL),(2852,7489,40725,9371,3,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',33632.86,NULL,NULL,1,'2024-05-18 11:05:13','2024-05-18 11:05:13',NULL),(2853,7489,40725,9371,3,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',35878.67,NULL,NULL,1,'2024-05-18 11:10:29','2024-05-18 11:11:33','2024-05-18 11:11:33'),(2854,7489,40725,9371,3,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',35878.67,NULL,NULL,1,'2024-05-18 11:11:33','2024-05-18 11:12:04','2024-05-18 11:12:04'),(2855,7489,40725,9371,3,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',35878.67,NULL,NULL,1,'2024-05-18 11:12:04','2024-05-18 11:12:04',NULL),(2856,7489,40725,9371,3,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',29604.85,NULL,NULL,1,'2024-05-18 11:14:05','2024-05-18 11:14:05',NULL),(2857,7489,40725,9371,3,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',436900.49,NULL,NULL,1,'2024-05-18 11:19:59','2024-05-18 11:19:59',NULL),(2858,7489,40727,12540,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',90000.00,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2859,7489,40727,12540,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',783197.20,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2860,7489,40727,12540,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',9600.00,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2861,7489,40727,12540,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',7090.15,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2862,7489,40727,12540,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',35945.00,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2863,7489,40727,12540,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',174523.97,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2864,7489,40727,12540,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',22330.00,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2865,7489,40727,12540,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',2595968.82,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2866,7489,40727,12540,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',1365246.38,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2867,7489,40727,12540,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',40000.00,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2868,7489,40727,12540,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',420862.42,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL);
INSERT INTO `balance_libro` VALUES (2869,7489,40727,12540,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',10080.00,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2870,7489,40727,12540,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',9000.00,NULL,NULL,1,'2024-05-18 12:07:50','2024-05-18 12:07:50',NULL),(2871,7489,40727,12540,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',23500.00,NULL,NULL,1,'2024-05-18 12:07:51','2024-05-18 12:07:51',NULL),(2872,7489,40727,12540,3,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',58311.75,NULL,NULL,1,'2024-05-18 12:08:07','2024-05-18 12:08:07',NULL),(2873,7489,40727,12540,3,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',29309.37,NULL,NULL,1,'2024-05-18 12:08:07','2024-05-18 12:08:07',NULL),(2874,7489,40727,12540,3,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',579234.40,NULL,NULL,1,'2024-05-18 12:08:07','2024-05-18 12:08:07',NULL),(2875,7489,40727,12540,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',105309.84,NULL,NULL,1,'2024-05-18 12:08:07','2024-05-18 12:08:07',NULL),(2876,7489,40727,12540,3,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',15998.18,NULL,NULL,1,'2024-05-18 12:08:07','2024-05-18 12:08:07',NULL),(2877,7489,40727,12540,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',61593.01,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2878,7489,40727,12540,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',234661.15,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2879,7489,40727,12540,3,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',169336.09,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2880,7489,40727,12540,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',35980.00,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2881,7489,40727,12540,3,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',12000.01,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2882,7489,40727,12540,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',262951.34,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2883,7489,40727,12540,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',133893.30,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2884,7489,40727,12540,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',59778.79,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2885,7489,40727,12540,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',144468.09,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2886,7489,40727,12540,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',22338.01,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2887,7489,40727,12540,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',19159.93,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2888,7489,40727,12540,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',42405.76,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-20 10:46:08','2024-05-20 10:46:08');
INSERT INTO `balance_libro` VALUES (2889,7489,40727,12540,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',22500.00,NULL,NULL,1,'2024-05-18 12:08:08','2024-05-18 12:08:08',NULL),(2890,7489,40727,12540,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',91642.52,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2891,7489,40727,12540,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',276332.71,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2892,7489,40727,12540,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',37800.00,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2893,7489,40727,12540,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',15998.18,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2894,7489,40727,12540,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',78719.14,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2895,7489,40727,12540,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',3950.00,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2896,7489,40727,12540,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',70306.11,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2897,7489,40727,12540,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',143213.01,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2898,7489,40727,12540,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',53997.00,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2899,7489,40727,12540,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',31319.88,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2900,7489,40727,12540,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',9508.28,NULL,NULL,1,'2024-05-18 12:08:09','2024-05-18 12:08:09',NULL),(2901,7489,40727,12540,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',15998.18,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL),(2902,7489,40727,12540,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',96335.41,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL),(2903,7489,40727,12540,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',14000.04,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL),(2904,7489,40727,12540,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',123125.54,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL),(2905,7489,40727,12540,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',35000.00,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL),(2906,7489,40727,12540,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',58654.07,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL),(2907,7489,40727,12540,3,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',20125.00,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL),(2908,7489,40727,12540,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',53290.22,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL),(2909,7489,40727,12540,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',22500.00,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL);
INSERT INTO `balance_libro` VALUES (2910,7489,40727,12540,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',30000.00,NULL,NULL,1,'2024-05-18 12:08:10','2024-05-18 12:08:10',NULL),(2911,7489,40724,7796,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',166480653.65,NULL,NULL,1,'2024-05-18 12:35:37','2024-05-18 12:35:37',NULL),(2912,7489,40724,7796,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',170146162.59,NULL,NULL,1,'2024-05-18 12:38:42','2024-05-18 12:38:42',NULL),(2913,7489,40724,7796,15,2913,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',26105187.05,'Liquidacion mensual',NULL,1,'2024-05-18 12:42:57','2024-05-18 12:42:57',NULL),(2914,7489,40724,7796,16,2914,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',6139434.86,'Liquidacion mensual',NULL,1,'2024-05-18 12:44:18','2024-05-18 12:44:18',NULL),(2937,7489,40728,14265,2,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',208105.00,NULL,NULL,1,'2024-05-20 08:48:41','2024-05-20 08:48:41',NULL),(2938,7489,40728,14265,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',438597.99,NULL,NULL,1,'2024-05-20 08:48:41','2024-05-20 09:02:11','2024-05-20 09:02:11'),(2939,7489,40728,14265,2,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',343264.70,NULL,NULL,1,'2024-05-20 08:48:41','2024-05-20 08:48:41',NULL),(2940,7489,40728,14265,2,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',398596.52,NULL,NULL,1,'2024-05-20 08:48:41','2024-05-20 08:48:41',NULL),(2941,7489,40728,14265,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',493323.52,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2942,7489,40728,14265,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',519421.00,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2943,7489,40728,14265,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',263940.66,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2944,7489,40728,14265,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',293339.26,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2945,7489,40728,14265,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',355192.70,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2946,7489,40728,14265,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',224971.63,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2947,7489,40728,14265,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',394327.31,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2948,7489,40728,14265,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',268159.95,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2949,7489,40728,14265,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',265532.27,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2950,7489,40728,14265,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',306543.00,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL),(2951,7489,40728,14265,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',225442.76,NULL,NULL,1,'2024-05-20 08:48:42','2024-05-20 08:48:42',NULL);
INSERT INTO `balance_libro` VALUES (2952,7489,40728,14265,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',117455.94,NULL,NULL,1,'2024-05-20 08:48:43','2024-05-20 08:48:43',NULL),(2953,7489,40728,14265,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',145688.00,NULL,NULL,1,'2024-05-20 08:48:43','2024-05-20 08:48:43',NULL),(2954,7489,40728,14265,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',253187.64,NULL,NULL,1,'2024-05-20 08:48:43','2024-05-20 08:48:43',NULL),(2955,7489,40728,14265,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',342979.63,NULL,NULL,1,'2024-05-20 08:48:43','2024-05-20 08:48:43',NULL),(2956,7489,40728,14265,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',301899.79,NULL,NULL,1,'2024-05-20 08:48:43','2024-05-20 09:10:03','2024-05-20 09:10:03'),(2957,7489,40728,14265,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',329902.55,NULL,NULL,1,'2024-05-20 08:48:43','2024-05-20 08:48:43',NULL),(2958,7489,40728,14265,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',97555.00,NULL,NULL,1,'2024-05-20 08:48:43','2024-05-20 08:48:43',NULL),(2959,7489,40728,14265,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',258720.13,NULL,NULL,1,'2024-05-20 08:48:43','2024-05-20 08:48:43',NULL),(2960,7489,40728,14265,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',426826.00,NULL,NULL,1,'2024-05-20 08:48:43','2024-05-20 08:48:43',NULL),(2961,7489,40728,14265,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',437997.99,NULL,NULL,1,'2024-05-20 09:02:11','2024-05-20 09:03:54','2024-05-20 09:03:54'),(2962,7489,40728,14265,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',437997.99,NULL,NULL,1,'2024-05-20 09:03:54','2024-05-20 09:03:54',NULL),(2963,7489,40728,14265,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',301839.29,NULL,NULL,1,'2024-05-20 09:10:03','2024-05-20 09:10:03',NULL),(2964,7489,40728,14265,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',15245541.25,NULL,NULL,1,'2024-05-20 09:18:18','2024-05-20 09:18:18',NULL),(2965,7489,40728,14265,2,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',229441.00,NULL,NULL,1,'2024-05-20 09:18:58','2024-05-20 09:18:58',NULL),(2966,7489,40728,14265,2,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1707743.80,NULL,NULL,1,'2024-05-20 09:19:22','2024-05-20 09:19:22',NULL),(2967,7489,40728,14265,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',505047.18,NULL,NULL,1,'2024-05-20 10:22:03','2024-05-20 10:22:03',NULL),(2968,7489,40728,14265,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',305558.69,NULL,NULL,1,'2024-05-20 10:22:03','2024-05-20 10:22:03',NULL),(2969,7489,40728,14265,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',2706.70,NULL,NULL,1,'2024-05-20 10:22:03','2024-05-20 10:22:03',NULL),(2970,7489,40728,14265,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',2953.26,NULL,NULL,1,'2024-05-20 10:22:03','2024-05-20 10:22:03',NULL),(2971,7489,40728,14265,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',14019.38,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL);
INSERT INTO `balance_libro` VALUES (2972,7489,40728,14265,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',58070.11,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2973,7489,40728,14265,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',19867.37,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2974,7489,40728,14265,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',98505.80,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2975,7489,40728,14265,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',1169.32,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2976,7489,40728,14265,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',62454.09,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2977,7489,40728,14265,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',118630.35,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2978,7489,40728,14265,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',436551.35,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2979,7489,40728,14265,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',18475.73,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2980,7489,40728,14265,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',141636.27,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2981,7489,40728,14265,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',0.00,NULL,NULL,1,'2024-05-20 10:22:04','2024-05-20 10:22:04',NULL),(2982,7489,40728,14265,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',30959.48,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2983,7489,40728,14265,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',66026.73,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2984,7489,40728,14265,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',27072.85,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2985,7489,40728,14265,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',7869.72,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2986,7489,40728,14265,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',4515.02,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2987,7489,40728,14265,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',449158.89,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2988,7489,40728,14265,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',628807.10,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2989,7489,40728,14265,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',11674.68,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2990,7489,40728,14265,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',385287.61,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2991,7489,40728,14265,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',31564.94,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL),(2992,7489,40728,14265,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',361883.73,NULL,NULL,1,'2024-05-20 10:22:05','2024-05-20 10:22:05',NULL);
INSERT INTO `balance_libro` VALUES (2993,7489,40728,14265,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',99047.30,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(2994,7489,40728,14265,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',421235.76,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(2995,7489,40728,14265,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',258540.36,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(2996,7489,40728,14265,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',751651.00,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(2997,7489,40728,14265,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',113710.27,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(2998,7489,40728,14265,3,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',5542.80,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(2999,7489,40728,14265,3,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',10403.38,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(3000,7489,40728,14265,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',603934.77,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(3001,7489,40728,14265,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',66080.02,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(3002,7489,40728,14265,3,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',419821.39,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(3003,7489,40728,14265,3,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',33767.38,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(3004,7489,40728,14265,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',383378.61,NULL,NULL,1,'2024-05-20 10:22:06','2024-05-20 10:22:06',NULL),(3005,7489,40728,14265,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',90617.43,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3006,7489,40728,14265,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',189927.78,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3007,7489,40728,14265,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',760532.04,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3008,7489,40728,14265,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',44310.89,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3009,7489,40728,14265,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',4744.20,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3010,7489,40728,14265,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',285703.83,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3011,7489,40728,14265,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',140654.81,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3012,7489,40728,14265,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',117002.80,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL);
INSERT INTO `balance_libro` VALUES (3013,7489,40728,14265,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',340999.42,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3014,7489,40728,14265,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',70467.50,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3015,7489,40728,14265,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',22191.35,NULL,NULL,1,'2024-05-20 10:22:07','2024-05-20 10:22:07',NULL),(3016,7489,40728,14265,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',129715.91,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3017,7489,40728,14265,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',13158.85,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3018,7489,40728,14265,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',21298.77,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3019,7489,40728,14265,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',6751.34,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3020,7489,40728,14265,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',30400.12,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3021,7489,40728,14265,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',151295.08,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3022,7489,40728,14265,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',4744.19,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3023,7489,40728,14265,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',50838.70,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3024,7489,40728,14265,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',2896.86,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3025,7489,40728,14265,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',577254.33,NULL,NULL,1,'2024-05-20 10:22:08','2024-05-20 10:22:08',NULL),(3026,7489,40728,14265,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',45233.50,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3027,7489,40728,14265,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',14993.91,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3028,7489,40728,14265,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',95250.10,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3029,7489,40728,14265,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',176228.94,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3030,7489,40728,14265,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',18356.16,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3031,7489,40728,14265,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',29784.83,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3032,7489,40728,14265,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',552129.20,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL);
INSERT INTO `balance_libro` VALUES (3033,7489,40728,14265,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',735942.18,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3034,7489,40728,14265,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',255247.28,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3035,7489,40728,14265,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',39144.72,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3036,7489,40728,14265,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',262340.58,NULL,NULL,1,'2024-05-20 10:22:09','2024-05-20 10:22:09',NULL),(3037,7489,40728,14265,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',196722.79,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3038,7489,40728,14265,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',26454.65,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3039,7489,40728,14265,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',308554.21,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3040,7489,40728,14265,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',505582.46,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3041,7489,40728,14265,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',431939.01,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3042,7489,40728,14265,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',611636.61,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3043,7489,40728,14265,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',44297.13,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3044,7489,40728,14265,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',660707.98,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3045,7489,40728,14265,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',64750.31,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3046,7489,40728,14265,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',551742.84,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3047,7489,40728,14265,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',6419.41,NULL,NULL,1,'2024-05-20 10:22:10','2024-05-20 10:22:10',NULL),(3048,7489,40728,14265,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',143805.58,NULL,NULL,1,'2024-05-20 10:22:11','2024-05-20 10:22:11',NULL),(3049,7489,40728,14265,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',3642.19,NULL,NULL,1,'2024-05-20 10:22:11','2024-05-20 10:22:11',NULL),(3050,7489,40728,14265,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',308769.67,NULL,NULL,1,'2024-05-20 10:22:11','2024-05-20 10:22:11',NULL),(3051,7489,40728,14265,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',391897.22,NULL,NULL,1,'2024-05-20 10:22:11','2024-05-20 10:22:11',NULL),(3052,7489,40728,14265,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',5837.34,NULL,NULL,1,'2024-05-20 10:22:11','2024-05-20 10:22:11',NULL);
INSERT INTO `balance_libro` VALUES (3053,7489,40728,14265,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',201059.37,NULL,NULL,1,'2024-05-20 10:22:11','2024-05-20 10:22:11',NULL),(3054,7489,40728,14265,3,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',457.94,NULL,NULL,1,'2024-05-20 10:22:11','2024-05-20 10:22:11',NULL),(3055,7489,40728,14265,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',186977.57,NULL,NULL,1,'2024-05-20 10:22:11','2024-05-20 10:22:11',NULL),(3056,7489,40728,14265,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',87353.20,NULL,NULL,1,'2024-05-20 10:22:11','2024-05-20 10:22:11',NULL),(3057,7489,40728,14265,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',447999.79,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3058,7489,40728,14265,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',99047.30,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3059,7489,40728,14265,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',153464.47,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3060,7489,40728,14265,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',257401.75,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3061,7489,40728,14265,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',436896.68,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3062,7489,40728,14265,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',737553.03,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3063,7489,40728,14265,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',18475.79,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3064,7489,40728,14265,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',775436.22,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3065,7489,40728,14265,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',710319.80,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3066,7489,40728,14265,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',106767.04,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3067,7489,40728,14265,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',483025.29,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3068,7489,40728,14265,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',34734.53,NULL,NULL,1,'2024-05-20 10:22:12','2024-05-20 10:22:12',NULL),(3069,7489,40728,14265,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',47713.92,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3070,7489,40728,14265,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',169428.95,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3071,7489,40728,14265,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',16661.40,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3072,7489,40728,14265,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',13158.85,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL);
INSERT INTO `balance_libro` VALUES (3073,7489,40728,14265,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',11674.68,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3074,7489,40728,14265,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',47149.10,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3075,7489,40728,14265,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',322504.58,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3076,7489,40728,14265,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',14688.68,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3077,7489,40728,14265,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',86272.19,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3078,7489,40728,14265,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',316222.09,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3079,7489,40728,14265,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',9982.57,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3080,7489,40728,14265,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',115983.76,NULL,NULL,1,'2024-05-20 10:22:13','2024-05-20 10:22:13',NULL),(3081,7489,40728,14265,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',261669.71,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3082,7489,40728,14265,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',4185.43,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3083,7489,40728,14265,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',253583.55,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3084,7489,40728,14265,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',11611.37,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3085,7489,40728,14265,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',510964.77,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3086,7489,40728,14265,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',521274.95,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3087,7489,40728,14265,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',443619.30,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3088,7489,40728,14265,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',11674.68,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3089,7489,40728,14265,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',275057.64,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3090,7489,40728,14265,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',9306.05,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3091,7489,40728,14265,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',0.00,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3092,7489,40728,14265,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',87884.39,NULL,NULL,1,'2024-05-20 10:22:14','2024-05-20 10:22:14',NULL),(3093,7489,40728,14265,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',778100.15,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL);
INSERT INTO `balance_libro` VALUES (3094,7489,40728,14265,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',30012.22,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3095,7489,40728,14265,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',8349.02,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3096,7489,40728,14265,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',368537.76,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3097,7489,40728,14265,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',1123.61,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3098,7489,40728,14265,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',785192.71,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3099,7489,40728,14265,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',337929.71,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3100,7489,40728,14265,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',20437.73,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3101,7489,40728,14265,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',1123.61,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3102,7489,40728,14265,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',127502.18,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3103,7489,40728,14265,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',10985.26,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3104,7489,40728,14265,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',6126.29,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3105,7489,40728,14265,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',480280.62,NULL,NULL,1,'2024-05-20 10:22:15','2024-05-20 10:22:15',NULL),(3106,7489,40728,14265,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',98020.36,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3107,7489,40728,14265,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',191996.52,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3108,7489,40728,14265,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',13398.21,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3109,7489,40728,14265,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',19333.68,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3110,7489,40728,14265,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',271349.88,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3111,7489,40728,14265,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',34734.53,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3112,7489,40728,14265,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',41417.37,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3113,7489,40728,14265,3,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',3534.16,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3114,7489,40728,14265,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',294724.41,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL);
INSERT INTO `balance_libro` VALUES (3115,7489,40728,14265,3,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',18356.16,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3116,7489,40728,14265,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',14883.46,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3117,7489,40728,14265,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',29883.05,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3118,7489,40728,14265,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',21125.82,NULL,NULL,1,'2024-05-20 10:22:16','2024-05-20 10:22:16',NULL),(3119,7489,40728,14265,3,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',17995.12,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3120,7489,40728,14265,3,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',28030.78,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3121,7489,40728,14265,3,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',79543.87,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3122,7489,40728,14265,3,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',502488.43,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3123,7489,40728,14265,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',118421.41,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3124,7489,40728,14265,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',70000.00,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3125,7489,40728,14265,3,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',323853.00,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3126,7489,40728,14265,3,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',43642.50,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3127,7489,40728,14265,3,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',34160.01,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3128,7489,40728,14265,3,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',123154.74,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3129,7489,40728,14265,3,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',55980.44,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3130,7489,40728,14265,3,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',9410.23,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3131,7489,40728,14265,3,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',12935.46,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3132,7489,40728,14265,3,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',3853313.95,NULL,NULL,1,'2024-05-20 10:22:17','2024-05-20 10:22:17',NULL),(3133,7489,40728,14265,3,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',91637.08,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3134,7489,40728,14265,3,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',7248.28,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL);
INSERT INTO `balance_libro` VALUES (3135,7489,40728,14265,3,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',785982.46,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3136,7489,40728,14265,3,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',13730.64,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3137,7489,40728,14265,3,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',9525.63,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3138,7489,40728,14265,3,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',8013.88,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3139,7489,40728,14265,3,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',55871.54,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3140,7489,40728,14265,3,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',1824519.06,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3141,7489,40728,14265,3,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',6332109.73,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3142,7489,40728,14265,3,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',339236.93,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3143,7489,40728,14265,3,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',7355.23,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3144,7489,40728,14265,3,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',5863.82,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3145,7489,40728,14265,3,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',7769.75,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3146,7489,40728,14265,3,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',38090.48,NULL,NULL,1,'2024-05-20 10:22:18','2024-05-20 10:22:18',NULL),(3147,7489,40728,14265,3,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',3284.16,NULL,NULL,1,'2024-05-20 10:22:19','2024-05-20 10:22:19',NULL),(3148,7489,40728,14265,3,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',7769.60,NULL,NULL,1,'2024-05-20 10:22:19','2024-05-20 10:22:19',NULL),(3149,7489,40728,14265,3,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3507.55,NULL,NULL,1,'2024-05-20 10:22:19','2024-05-20 10:22:19',NULL),(3150,7489,40728,14265,3,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',10481.44,NULL,NULL,1,'2024-05-20 10:22:19','2024-05-20 10:22:19',NULL),(3151,7489,40728,14265,3,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',14688.68,NULL,NULL,1,'2024-05-20 10:22:19','2024-05-20 10:22:19',NULL),(3152,7489,40728,14265,3,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',10587.75,NULL,NULL,1,'2024-05-20 10:22:19','2024-05-20 10:22:19',NULL),(3153,7489,40727,12540,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',42405.76,NULL,NULL,1,'2024-05-20 10:46:08','2024-05-20 10:46:08',NULL),(3154,7489,40799,17262,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',1650440.00,NULL,NULL,1,'2024-05-21 08:52:10','2024-05-21 08:52:10',NULL),(3155,7489,40799,17262,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',372680.00,NULL,NULL,1,'2024-05-21 08:52:10','2024-05-21 08:52:10',NULL);
INSERT INTO `balance_libro` VALUES (3156,7489,40799,17262,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',1524600.00,NULL,NULL,1,'2024-05-21 08:52:10','2024-05-21 08:52:10',NULL),(3157,7489,40799,17262,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',266200.00,NULL,NULL,1,'2024-05-21 08:52:10','2024-05-21 08:52:10',NULL),(3158,7489,40799,17262,3,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',13300.55,NULL,NULL,1,'2024-05-21 08:52:25','2024-05-21 09:04:26','2024-05-21 09:04:26'),(3159,7489,40799,17262,3,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',13313.93,NULL,NULL,1,'2024-05-21 08:52:25','2024-05-21 09:04:02','2024-05-21 09:04:02'),(3160,7489,40799,17262,3,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-02','2024-04-02',223729.00,NULL,NULL,1,'2024-05-21 08:52:25','2024-05-21 08:56:54','2024-05-21 08:56:54'),(3161,7489,40799,17262,3,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',12521.90,NULL,NULL,1,'2024-05-21 08:52:25','2024-05-21 09:03:33','2024-05-21 09:03:33'),(3162,7489,40799,17262,3,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',353455.00,NULL,NULL,1,'2024-05-21 08:52:25','2024-05-21 08:56:21','2024-05-21 08:56:21'),(3163,7489,40799,17262,3,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',20000.00,NULL,NULL,1,'2024-05-21 08:52:25','2024-05-21 08:59:29','2024-05-21 08:59:29'),(3164,7489,40799,17262,3,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',505172.30,NULL,NULL,1,'2024-05-21 08:52:26','2024-05-21 08:55:06','2024-05-21 08:55:06'),(3165,7489,40799,17262,3,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',30962.79,NULL,NULL,1,'2024-05-21 08:52:26','2024-05-21 08:59:06','2024-05-21 08:59:06'),(3166,7489,40799,17262,3,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',2729784.20,NULL,NULL,1,'2024-05-21 08:52:26','2024-05-21 08:58:29','2024-05-21 08:58:29'),(3167,7489,40799,17262,3,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',4132494.85,NULL,NULL,1,'2024-05-21 08:52:26','2024-05-21 08:58:09','2024-05-21 08:58:09'),(3168,7489,40799,17262,3,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4132494.85,NULL,NULL,1,'2024-05-21 08:52:26','2024-05-21 08:57:54','2024-05-21 08:57:54'),(3169,7489,40799,17262,3,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1289884.20,NULL,NULL,1,'2024-05-21 08:52:26','2024-05-21 08:57:31','2024-05-21 08:57:31'),(3170,7489,40799,17262,3,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',505172.30,NULL,NULL,1,'2024-05-21 08:55:06','2024-05-21 08:55:06',NULL),(3171,7489,40799,17262,3,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',353455.00,NULL,NULL,1,'2024-05-21 08:56:21','2024-05-21 08:56:21',NULL),(3172,7489,40799,17262,3,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-02','2024-04-02',223729.00,NULL,NULL,1,'2024-05-21 08:56:54','2024-05-21 08:56:54',NULL),(3173,7489,40799,17262,3,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1289884.20,NULL,NULL,1,'2024-05-21 08:57:31','2024-05-21 08:57:31',NULL),(3174,7489,40799,17262,3,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',4132494.85,NULL,NULL,1,'2024-05-21 08:57:54','2024-05-21 08:57:54',NULL);
INSERT INTO `balance_libro` VALUES (3175,7489,40799,17262,3,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',4132494.85,NULL,NULL,1,'2024-05-21 08:58:09','2024-05-21 08:58:09',NULL),(3176,7489,40799,17262,3,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',2729784.20,NULL,NULL,1,'2024-05-21 08:58:29','2024-05-21 08:58:29',NULL),(3177,7489,40799,17262,3,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',30962.79,NULL,NULL,1,'2024-05-21 08:59:06','2024-05-21 08:59:06',NULL),(3178,7489,40799,17262,3,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',20000.00,NULL,NULL,1,'2024-05-21 08:59:29','2024-05-21 08:59:29',NULL),(3179,7489,40799,17262,3,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',12521.90,NULL,NULL,1,'2024-05-21 09:03:33','2024-05-21 09:03:33',NULL),(3180,7489,40799,17262,3,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',13313.93,NULL,NULL,1,'2024-05-21 09:04:02','2024-05-21 09:04:02',NULL),(3181,7489,40799,17262,3,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',13300.55,NULL,NULL,1,'2024-05-21 09:04:26','2024-05-21 09:04:26',NULL),(3182,7489,40799,17262,3,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',41450.40,NULL,NULL,1,'2024-05-21 09:11:40','2024-05-21 09:11:40',NULL),(3183,7489,40799,17262,3,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',39919.41,NULL,NULL,1,'2024-05-21 09:12:28','2024-05-21 09:12:28',NULL),(3184,7489,40727,12540,1,3184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-04-30',NULL,882985.04,NULL,NULL,1,'2024-05-28 09:10:52','2024-05-28 09:10:52',NULL),(3185,7489,40725,9371,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-04-30',NULL,472960.44,NULL,NULL,1,'2024-06-08 09:36:58','2024-06-08 09:36:58',NULL),(3186,7489,40728,14265,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-04-30',NULL,2196093.74,NULL,NULL,1,'2024-06-08 10:31:02','2024-06-08 10:31:02',NULL),(3187,7489,40724,7783,17,3187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',781082407.08,'Asiento de cierre',NULL,1,'2024-06-10 11:08:06','2024-06-10 11:08:06',NULL),(3212,7489,40728,14266,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',171330.64,NULL,NULL,1,'2024-06-15 09:24:37','2024-06-15 09:24:37',NULL),(3213,7489,40728,14266,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',323224.03,NULL,NULL,1,'2024-06-15 09:24:37','2024-06-15 09:24:37',NULL),(3214,7489,40728,14266,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',334288.92,NULL,NULL,1,'2024-06-15 09:24:37','2024-06-15 09:24:37',NULL),(3215,7489,40728,14266,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',290987.00,NULL,NULL,1,'2024-06-15 09:24:37','2024-06-15 09:24:37',NULL),(3216,7489,40728,14266,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',688152.24,NULL,NULL,1,'2024-06-15 09:24:37','2024-06-15 09:24:37',NULL),(3217,7489,40728,14266,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',243407.67,NULL,NULL,1,'2024-06-15 09:24:37','2024-06-15 09:24:37',NULL),(3218,7489,40728,14266,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',185540.07,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3219,7489,40728,14266,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',578834.28,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL);
INSERT INTO `balance_libro` VALUES (3220,7489,40728,14266,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',388090.99,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3221,7489,40728,14266,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',390957.48,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3222,7489,40728,14266,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',496014.71,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3223,7489,40728,14266,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',530596.21,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3224,7489,40728,14266,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',362936.00,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3225,7489,40728,14266,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',435234.90,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:34:36','2024-06-15 09:34:36'),(3226,7489,40728,14266,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',138676.00,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3227,7489,40728,14266,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',300180.87,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3228,7489,40728,14266,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',349188.05,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:35:20','2024-06-15 09:35:20'),(3229,7489,40728,14266,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',176796.00,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3230,7489,40728,14266,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',314179.09,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3231,7489,40728,14266,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',355530.71,NULL,NULL,1,'2024-06-15 09:24:38','2024-06-15 09:24:38',NULL),(3232,7489,40728,14266,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',187749.50,NULL,NULL,1,'2024-06-15 09:24:39','2024-06-15 09:24:39',NULL),(3233,7489,40728,14266,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',302290.75,NULL,NULL,1,'2024-06-15 09:24:39','2024-06-15 09:24:39',NULL),(3234,7489,40728,14266,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',306507.01,NULL,NULL,1,'2024-06-15 09:24:39','2024-06-15 09:24:39',NULL),(3235,7489,40728,14266,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',214497.38,NULL,NULL,1,'2024-06-15 09:24:39','2024-06-15 09:24:39',NULL),(3236,7489,40728,14266,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',459976.81,NULL,NULL,1,'2024-06-15 09:24:39','2024-06-15 09:24:39',NULL),(3237,7489,40728,14266,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',435234.91,NULL,NULL,1,'2024-06-15 09:34:36','2024-06-15 09:34:36',NULL),(3238,7489,40728,14266,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',349188.06,NULL,NULL,1,'2024-06-15 09:35:20','2024-06-15 09:35:20',NULL),(3239,7489,40728,14266,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',17687199.15,NULL,NULL,1,'2024-06-15 09:56:07','2024-06-15 09:56:07',NULL);
INSERT INTO `balance_libro` VALUES (3240,7489,40728,14266,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1196065.80,NULL,NULL,1,'2024-06-15 09:56:40','2024-06-15 09:56:40',NULL),(3241,7489,40728,14266,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1991941.45,NULL,NULL,1,'2024-06-15 09:57:05','2024-06-15 09:57:05',NULL),(3242,7489,40725,9372,3,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',31026.95,NULL,NULL,1,'2024-06-15 10:35:18','2024-06-15 10:35:18',NULL),(3243,7489,40725,9372,3,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',31446.89,NULL,NULL,1,'2024-06-15 10:36:03','2024-06-15 10:36:03',NULL),(3244,7489,40725,9372,3,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',31346.16,NULL,NULL,1,'2024-06-15 10:36:39','2024-06-15 10:36:39',NULL),(3245,7489,40725,9372,3,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',46999.96,NULL,NULL,1,'2024-06-15 10:38:42','2024-06-15 10:39:23','2024-06-15 10:39:23'),(3246,7489,40725,9372,3,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',47000.01,NULL,NULL,1,'2024-06-15 10:39:23','2024-06-15 10:40:28','2024-06-15 10:40:28'),(3247,7489,40725,9372,3,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',44845.27,NULL,NULL,1,'2024-06-15 10:40:28','2024-06-15 10:41:07','2024-06-15 10:41:07'),(3248,7489,40725,9372,3,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',30903.85,NULL,NULL,1,'2024-06-15 10:41:07','2024-06-15 10:41:07',NULL),(3249,7489,40725,9372,3,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',10602.97,NULL,NULL,1,'2024-06-15 10:43:47','2024-06-15 10:43:47',NULL),(3250,7489,40725,9372,3,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',30414.20,NULL,NULL,1,'2024-06-15 10:44:26','2024-06-15 10:44:26',NULL),(3251,7489,40725,9372,3,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',585900.70,NULL,NULL,1,'2024-06-15 10:48:30','2024-06-15 10:48:30',NULL),(3252,7489,40725,9372,3,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',35310.00,NULL,NULL,1,'2024-06-15 10:49:55','2024-06-15 10:49:55',NULL),(3253,7489,40725,9372,3,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',106315.44,NULL,NULL,1,'2024-06-15 10:49:55','2024-06-15 10:49:55',NULL),(3254,7489,40725,9372,3,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',93472.50,NULL,NULL,1,'2024-06-15 10:49:55','2024-06-15 10:49:55',NULL),(3255,7489,40725,9372,3,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',235950.00,NULL,NULL,1,'2024-06-15 10:49:55','2024-06-15 10:49:55',NULL),(3256,7489,40725,9372,3,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',235950.00,NULL,NULL,1,'2024-06-15 10:49:56','2024-06-15 10:49:56',NULL),(3257,7489,40725,9372,3,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-19','2024-05-19',27000.00,NULL,NULL,1,'2024-06-15 10:49:56','2024-06-15 10:49:56',NULL),(3258,7489,40725,9372,3,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',35399.00,NULL,NULL,1,'2024-06-15 10:49:56','2024-06-15 10:49:56',NULL),(3259,7489,40725,9372,3,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',224799.85,NULL,NULL,1,'2024-06-15 10:49:56','2024-06-15 10:49:56',NULL);
INSERT INTO `balance_libro` VALUES (3260,7489,40725,9372,3,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',1844.63,NULL,NULL,1,'2024-06-15 10:49:56','2024-06-15 10:49:56',NULL),(3261,7489,40725,9372,3,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',121597.78,NULL,NULL,1,'2024-06-15 10:49:56','2024-06-15 10:54:18','2024-06-15 10:54:18'),(3262,7489,40725,9372,3,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',11020.66,NULL,NULL,1,'2024-06-15 10:49:56','2024-06-15 10:53:24','2024-06-15 10:53:24'),(3263,7489,40725,9372,3,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',50000.00,NULL,NULL,1,'2024-06-15 10:49:56','2024-06-15 10:49:56',NULL),(3264,7489,40725,9372,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',217686.00,NULL,NULL,1,'2024-06-15 10:51:04','2024-06-15 10:51:04',NULL),(3265,7489,40725,9372,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',188355.00,NULL,NULL,1,'2024-06-15 10:51:04','2024-06-15 10:51:04',NULL),(3266,7489,40725,9372,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',187550.00,NULL,NULL,1,'2024-06-15 10:51:04','2024-06-15 10:51:04',NULL),(3267,7489,40725,9372,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',738100.00,NULL,NULL,1,'2024-06-15 10:51:04','2024-06-15 10:51:04',NULL),(3268,7489,40725,9372,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',431063.00,NULL,NULL,1,'2024-06-15 10:51:04','2024-06-15 10:51:04',NULL),(3269,7489,40725,9372,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',4012067.00,NULL,NULL,1,'2024-06-15 10:51:04','2024-06-15 10:51:04',NULL),(3270,7489,40725,9372,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',804650.00,NULL,NULL,1,'2024-06-15 10:51:04','2024-06-15 10:51:04',NULL),(3271,7489,40725,9372,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',175500.00,NULL,NULL,1,'2024-06-15 10:51:05','2024-06-15 10:51:05',NULL),(3272,7489,40725,9372,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',738100.00,NULL,NULL,1,'2024-06-15 10:51:05','2024-06-15 10:51:05',NULL),(3273,7489,40725,9372,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',188355.00,NULL,NULL,1,'2024-06-15 10:51:05','2024-06-15 10:51:05',NULL),(3274,7489,40725,9372,2,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',217686.00,NULL,NULL,1,'2024-06-15 10:51:05','2024-06-15 10:51:05',NULL),(3275,7489,40725,9372,3,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',11020.66,NULL,NULL,1,'2024-06-15 10:53:24','2024-06-15 10:53:24',NULL),(3276,7489,40725,9372,3,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',121597.78,NULL,NULL,1,'2024-06-15 10:54:18','2024-06-15 10:54:18',NULL),(3277,7489,40724,7797,2,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',193063031.10,NULL,NULL,1,'2024-06-18 09:51:19','2024-06-18 09:51:19',NULL),(3278,7489,40724,7797,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',181978276.60,NULL,NULL,1,'2024-06-18 09:57:06','2025-07-28 15:21:56','2025-07-28 15:21:56'),(3279,7489,40724,7797,15,3279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',29834694.58,'Liquidacion mensual',NULL,1,'2024-06-18 10:01:46','2024-06-18 10:01:46',NULL);
INSERT INTO `balance_libro` VALUES (3280,7489,40724,7797,16,3280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',5900219.93,'Liquidacion mensual',NULL,1,'2024-06-18 10:04:33','2024-06-18 10:04:33',NULL),(3293,7489,40727,12541,2,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',128107.70,NULL,NULL,1,'2024-06-18 10:10:02','2024-06-18 10:10:02',NULL),(3294,7489,40727,12541,2,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',81610.38,NULL,NULL,1,'2024-06-18 10:10:02','2024-06-18 10:10:02',NULL),(3295,7489,40727,12541,2,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',179185.52,NULL,NULL,1,'2024-06-18 10:10:02','2024-06-18 10:10:02',NULL),(3296,7489,40727,12541,2,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',346.82,NULL,NULL,1,'2024-06-18 10:10:03','2024-06-18 10:10:03',NULL),(3297,7489,40727,12541,2,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',3671.58,NULL,NULL,1,'2024-06-18 10:10:03','2024-06-18 10:10:03',NULL),(3298,7489,40727,12541,2,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',676511.79,NULL,NULL,1,'2024-06-18 10:10:03','2024-06-18 10:10:03',NULL),(3299,7489,40727,12541,2,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',9000.00,NULL,NULL,1,'2024-06-18 10:10:03','2024-06-18 10:10:03',NULL),(3300,7489,40727,12541,2,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',180000.00,NULL,NULL,1,'2024-06-18 10:10:03','2024-06-18 10:10:03',NULL),(3301,7489,40727,12541,2,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',1806885.13,NULL,NULL,1,'2024-06-18 10:10:03','2024-06-18 10:10:03',NULL),(3302,7489,40727,12541,2,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',2948103.83,NULL,NULL,1,'2024-06-18 10:10:04','2024-06-18 10:10:04',NULL),(3303,7489,40727,12541,2,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',18000.00,NULL,NULL,1,'2024-06-18 10:10:04','2024-06-18 10:10:04',NULL),(3304,7489,40727,12541,2,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',9000.00,NULL,NULL,1,'2024-06-18 10:10:04','2024-06-18 10:10:04',NULL),(3305,7489,40727,12541,2,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',18000.00,NULL,NULL,1,'2024-06-18 10:10:04','2024-06-18 10:10:04',NULL),(3306,7489,40727,12541,2,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',19500.00,NULL,NULL,1,'2024-06-18 10:10:04','2024-06-18 10:10:04',NULL),(3307,7489,40727,12541,2,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',505261.84,NULL,NULL,1,'2024-06-18 10:10:04','2024-06-18 10:10:04',NULL),(3308,7489,40727,12541,2,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',3300.00,NULL,NULL,1,'2024-06-18 10:10:04','2024-06-18 10:10:04',NULL),(3309,7489,40727,12541,2,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',25000.00,NULL,NULL,1,'2024-06-18 10:10:05','2024-06-18 10:10:05',NULL),(3310,7489,40727,12541,3,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',725512.95,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL),(3311,7489,40727,12541,3,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',187589.69,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL);
INSERT INTO `balance_libro` VALUES (3312,7489,40727,12541,3,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',131120.36,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL),(3313,7489,40727,12541,3,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',61593.01,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL),(3314,7489,40727,12541,3,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',20125.00,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL),(3315,7489,40727,12541,3,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',53290.22,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL),(3316,7489,40727,12541,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',14000.00,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL),(3317,7489,40727,12541,3,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',28790.47,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL),(3318,7489,40727,12541,3,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',70127.48,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL),(3319,7489,40727,12541,3,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',113923.54,NULL,NULL,1,'2024-06-18 10:10:18','2024-06-18 10:10:18',NULL),(3320,7489,40727,12541,3,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',119457.52,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 10:10:19',NULL),(3321,7489,40727,12541,3,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',84064.66,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 10:10:19',NULL),(3322,7489,40727,12541,3,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',29772.00,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 10:18:35','2024-06-18 10:18:35'),(3323,7489,40727,12541,3,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',51040.51,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 11:04:13','2024-06-18 11:04:13'),(3324,7489,40727,12541,3,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',154080.87,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 10:10:19',NULL),(3325,7489,40727,12541,3,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',42000.00,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 10:10:19',NULL),(3326,7489,40727,12541,3,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',15998.18,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 10:10:19',NULL),(3327,7489,40727,12541,3,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',359913.92,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 10:10:19',NULL),(3328,7489,40727,12541,3,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',28685.95,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 10:10:19',NULL),(3329,7489,40727,12541,3,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',163150.24,NULL,NULL,1,'2024-06-18 10:10:19','2024-06-18 10:10:19',NULL),(3330,7489,40727,12541,3,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',11160.58,NULL,NULL,1,'2024-06-18 10:10:20','2024-06-18 10:10:20',NULL),(3331,7489,40727,12541,3,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',162167.00,NULL,NULL,1,'2024-06-18 10:10:20','2024-06-18 10:10:20',NULL);
INSERT INTO `balance_libro` VALUES (3332,7489,40727,12541,3,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',43761.53,NULL,NULL,1,'2024-06-18 10:10:20','2024-06-18 10:10:20',NULL),(3333,7489,40727,12541,3,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',31293.00,NULL,NULL,1,'2024-06-18 10:10:20','2024-06-18 10:10:20',NULL),(3334,7489,40727,12541,3,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',17561.75,NULL,NULL,1,'2024-06-18 10:10:20','2024-06-18 10:10:20',NULL),(3335,7489,40727,12541,3,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',78650.00,NULL,NULL,1,'2024-06-18 10:10:20','2024-06-18 10:10:20',NULL),(3336,7489,40727,12541,3,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',13999.99,NULL,NULL,1,'2024-06-18 10:10:20','2024-06-18 10:10:20',NULL),(3337,7489,40727,12541,3,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',30000.00,NULL,NULL,1,'2024-06-18 10:10:20','2024-06-18 10:10:20',NULL),(3338,7489,40727,12541,3,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',51040.51,NULL,NULL,1,'2024-06-18 11:04:13','2024-06-18 11:04:13',NULL),(3339,7489,40728,14266,3,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',149589.75,NULL,NULL,1,'2024-06-18 11:43:58','2024-06-18 11:43:58',NULL),(3340,7489,40728,14266,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',89131.98,NULL,NULL,1,'2024-06-18 11:43:58','2024-06-18 11:43:58',NULL),(3341,7489,40728,14266,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',35078.52,NULL,NULL,1,'2024-06-18 11:43:58','2024-06-18 11:43:58',NULL),(3342,7489,40728,14266,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',11244.20,NULL,NULL,1,'2024-06-18 11:43:58','2024-06-18 11:43:58',NULL),(3343,7489,40728,14266,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',148296.97,NULL,NULL,1,'2024-06-18 11:43:58','2024-06-18 11:43:58',NULL),(3344,7489,40728,14266,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',761475.86,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3345,7489,40728,14266,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',66353.72,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3346,7489,40728,14266,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',87672.06,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3347,7489,40728,14266,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',201267.16,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3348,7489,40728,14266,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',8386.88,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3349,7489,40728,14266,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',120532.91,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3350,7489,40728,14266,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',10264.33,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3351,7489,40728,14266,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',150927.47,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL);
INSERT INTO `balance_libro` VALUES (3352,7489,40728,14266,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',226345.37,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3353,7489,40728,14266,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',14173.44,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3354,7489,40728,14266,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',443120.44,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3355,7489,40728,14266,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',32251.09,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3356,7489,40728,14266,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',13730.46,NULL,NULL,1,'2024-06-18 11:43:59','2024-06-18 11:43:59',NULL),(3357,7489,40728,14266,3,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',494143.91,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3358,7489,40728,14266,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',401595.09,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3359,7489,40728,14266,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',131170.81,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3360,7489,40728,14266,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',202951.67,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3361,7489,40728,14266,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',194651.25,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3362,7489,40728,14266,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',10050.53,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3363,7489,40728,14266,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',31770.48,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3364,7489,40728,14266,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',43066.32,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3365,7489,40728,14266,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',95068.67,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3366,7489,40728,14266,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',46954.90,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3367,7489,40728,14266,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',574986.92,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3368,7489,40728,14266,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',524495.22,NULL,NULL,1,'2024-06-18 11:44:00','2024-06-18 11:44:00',NULL),(3369,7489,40728,14266,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',3954.48,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3370,7489,40728,14266,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',725938.87,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3371,7489,40728,14266,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',283862.81,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL);
INSERT INTO `balance_libro` VALUES (3372,7489,40728,14266,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',300312.35,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3373,7489,40728,14266,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',2988.53,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3374,7489,40728,14266,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',503340.17,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3375,7489,40728,14266,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',54199.89,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3376,7489,40728,14266,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',4744.20,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3377,7489,40728,14266,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',586014.05,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3378,7489,40728,14266,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',195808.97,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3379,7489,40728,14266,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',658223.53,NULL,NULL,1,'2024-06-18 11:44:01','2024-06-18 11:44:01',NULL),(3380,7489,40728,14266,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',150722.14,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3381,7489,40728,14266,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',404705.66,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3382,7489,40728,14266,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',591173.37,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3383,7489,40728,14266,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',17200.26,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3384,7489,40728,14266,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',656138.88,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3385,7489,40728,14266,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',13601.15,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3386,7489,40728,14266,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',832991.01,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3387,7489,40728,14266,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',299303.30,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3388,7489,40728,14266,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',100559.64,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3389,7489,40728,14266,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',387141.46,NULL,NULL,1,'2024-06-18 11:44:02','2024-06-18 11:44:02',NULL),(3390,7489,40728,14266,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',10220.77,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3391,7489,40728,14266,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',513274.63,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL);
INSERT INTO `balance_libro` VALUES (3392,7489,40728,14266,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-12','2024-05-12',16941.70,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3393,7489,40728,14266,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-12','2024-05-12',68423.12,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3394,7489,40728,14266,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',204017.56,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3395,7489,40728,14266,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',14495.96,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3396,7489,40728,14266,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',15108.91,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3397,7489,40728,14266,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',3495.48,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3398,7489,40728,14266,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',3896.03,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3399,7489,40728,14266,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',14409.78,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3400,7489,40728,14266,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',317993.75,NULL,NULL,1,'2024-06-18 11:44:03','2024-06-18 11:44:03',NULL),(3401,7489,40728,14266,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',134276.88,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3402,7489,40728,14266,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',641888.40,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3403,7489,40728,14266,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',18318.28,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3404,7489,40728,14266,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',680747.46,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3405,7489,40728,14266,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',473605.76,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3406,7489,40728,14266,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',1976.37,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3407,7489,40728,14266,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',570721.78,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3408,7489,40728,14266,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',20063.36,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3409,7489,40728,14266,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',157903.94,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3410,7489,40728,14266,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',106866.88,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL),(3411,7489,40728,14266,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',276950.03,NULL,NULL,1,'2024-06-18 11:44:04','2024-06-18 11:44:04',NULL);
INSERT INTO `balance_libro` VALUES (3412,7489,40728,14266,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',321430.25,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3413,7489,40728,14266,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',6740.37,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3414,7489,40728,14266,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',1088507.25,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3415,7489,40728,14266,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',316796.82,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3416,7489,40728,14266,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',485052.04,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3417,7489,40728,14266,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',18318.28,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3418,7489,40728,14266,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',698923.98,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3419,7489,40728,14266,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',116641.13,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3420,7489,40728,14266,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',11002.33,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3421,7489,40728,14266,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',58831.52,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3422,7489,40728,14266,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',631151.02,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3423,7489,40728,14266,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',54049.40,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3424,7489,40728,14266,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',18730.14,NULL,NULL,1,'2024-06-18 11:44:05','2024-06-18 11:44:05',NULL),(3425,7489,40728,14266,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',32953.53,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3426,7489,40728,14266,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',23899.39,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3427,7489,40728,14266,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',6711.94,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3428,7489,40728,14266,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',588621.76,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3429,7489,40728,14266,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',18124.92,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3430,7489,40728,14266,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',52860.14,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3431,7489,40728,14266,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',4954.05,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL);
INSERT INTO `balance_libro` VALUES (3432,7489,40728,14266,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',522282.75,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3433,7489,40728,14266,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',170183.12,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3434,7489,40728,14266,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',485110.18,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3435,7489,40728,14266,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',50297.29,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3436,7489,40728,14266,3,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',5080.16,NULL,NULL,1,'2024-06-18 11:44:06','2024-06-18 11:44:06',NULL),(3437,7489,40728,14266,3,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',355897.51,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3438,7489,40728,14266,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',3624.93,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3439,7489,40728,14266,3,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',512814.74,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3440,7489,40728,14266,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',23785.66,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3441,7489,40728,14266,3,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',448800.51,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3442,7489,40728,14266,3,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',3890.31,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3443,7489,40728,14266,3,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',34038.72,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3444,7489,40728,14266,3,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',3896.03,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3445,7489,40728,14266,3,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',15513.76,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3446,7489,40728,14266,3,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',24407.42,NULL,NULL,1,'2024-06-18 11:44:07','2024-06-18 11:44:07',NULL),(3447,7489,40728,14266,3,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',428565.45,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL),(3448,7489,40728,14266,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',224473.29,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL),(3449,7489,40728,14266,3,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',11867.41,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL),(3450,7489,40728,14266,3,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',30823.03,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL),(3451,7489,40728,14266,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',160361.44,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL);
INSERT INTO `balance_libro` VALUES (3452,7489,40728,14266,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',352306.37,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL),(3453,7489,40728,14266,3,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',9745.87,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL),(3454,7489,40728,14266,3,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',90827.64,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL),(3455,7489,40728,14266,3,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',144411.56,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL),(3456,7489,40728,14266,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',160693.72,NULL,NULL,1,'2024-06-18 11:44:08','2024-06-18 11:44:08',NULL),(3457,7489,40728,14266,3,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',23182.97,NULL,NULL,1,'2024-06-18 11:44:09','2024-06-18 11:44:09',NULL),(3458,7489,40728,14266,3,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',248238.83,NULL,NULL,1,'2024-06-18 11:44:09','2024-06-18 11:44:09',NULL),(3459,7489,40728,14266,3,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',20763.78,NULL,NULL,1,'2024-06-18 11:44:09','2024-06-18 11:44:09',NULL),(3460,7489,40728,14266,3,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',332150.24,NULL,NULL,1,'2024-06-18 11:44:09','2024-06-18 11:44:09',NULL),(3461,7489,40728,14266,3,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',948908.06,NULL,NULL,1,'2024-06-18 11:44:09','2024-06-18 11:44:09',NULL),(3462,7489,40728,14266,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',268136.53,NULL,NULL,1,'2024-06-18 11:44:09','2024-06-18 11:44:09',NULL),(3463,7489,40728,14266,3,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',0.00,NULL,NULL,1,'2024-06-18 11:44:09','2024-06-18 11:44:09',NULL),(3464,7489,40728,14266,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',11457.86,NULL,NULL,1,'2024-06-18 11:44:09','2024-06-18 11:44:09',NULL),(3465,7489,40728,14266,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',19359.06,NULL,NULL,1,'2024-06-18 11:44:09','2024-06-18 11:44:09',NULL),(3466,7489,40728,14266,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',104582.08,NULL,NULL,1,'2024-06-18 11:44:10','2024-06-18 11:44:10',NULL),(3467,7489,40728,14266,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',3398.40,NULL,NULL,1,'2024-06-18 11:44:10','2024-06-18 11:44:10',NULL),(3468,7489,40728,14266,3,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',37182.43,NULL,NULL,1,'2024-06-18 11:44:10','2024-06-18 11:44:10',NULL),(3469,7489,40728,14266,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',4790.27,NULL,NULL,1,'2024-06-18 11:44:10','2024-06-18 11:44:10',NULL),(3470,7489,40728,14266,3,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',14021.72,NULL,NULL,1,'2024-06-18 11:44:10','2024-06-18 11:44:10',NULL),(3471,7489,40728,14266,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',280416.29,NULL,NULL,1,'2024-06-18 11:44:10','2024-06-18 11:44:10',NULL),(3472,7489,40728,14266,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',6041.64,NULL,NULL,1,'2024-06-18 11:44:10','2024-06-18 11:44:10',NULL);
INSERT INTO `balance_libro` VALUES (3473,7489,40728,14266,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',33234.97,NULL,NULL,1,'2024-06-18 11:44:11','2024-06-18 11:44:11',NULL),(3474,7489,40728,14266,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',43283.95,NULL,NULL,1,'2024-06-18 11:44:11','2024-06-18 11:44:11',NULL),(3475,7489,40728,14266,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',301108.38,NULL,NULL,1,'2024-06-18 11:44:11','2024-06-18 11:44:11',NULL),(3476,7489,40728,14266,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',208569.52,NULL,NULL,1,'2024-06-18 11:44:11','2024-06-18 11:44:11',NULL),(3477,7489,40728,14266,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',227865.49,NULL,NULL,1,'2024-06-18 11:44:11','2024-06-18 11:44:11',NULL),(3478,7489,40728,14266,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',10021.90,NULL,NULL,1,'2024-06-18 11:44:11','2024-06-18 11:44:11',NULL),(3479,7489,40728,14266,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',380116.83,NULL,NULL,1,'2024-06-18 11:44:11','2024-06-18 11:44:11',NULL),(3480,7489,40728,14266,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',8124.30,NULL,NULL,1,'2024-06-18 11:44:11','2024-06-18 11:44:11',NULL),(3481,7489,40728,14266,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',110287.77,NULL,NULL,1,'2024-06-18 11:44:11','2024-06-18 11:44:11',NULL),(3482,7489,40728,14266,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',15522.41,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3483,7489,40728,14266,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',69344.18,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3484,7489,40728,14266,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',0.00,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3485,7489,40728,14266,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',415720.81,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3486,7489,40728,14266,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',12083.28,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3487,7489,40728,14266,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',63581.67,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3488,7489,40728,14266,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',1036.73,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3489,7489,40728,14266,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',7883.78,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3490,7489,40728,14266,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',10985.26,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3491,7489,40728,14266,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',102222.70,NULL,NULL,1,'2024-06-18 11:44:12','2024-06-18 11:44:12',NULL),(3492,7489,40728,14266,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',566365.30,NULL,NULL,1,'2024-06-18 11:44:13','2024-06-18 11:44:13',NULL),(3493,7489,40728,14266,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',302741.08,NULL,NULL,1,'2024-06-18 11:44:13','2024-06-18 11:44:13',NULL);
INSERT INTO `balance_libro` VALUES (3494,7489,40728,14266,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',95010.58,NULL,NULL,1,'2024-06-18 11:44:13','2024-06-18 11:44:13',NULL),(3495,7489,40728,14266,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',292469.74,NULL,NULL,1,'2024-06-18 11:44:13','2024-06-18 11:44:13',NULL),(3496,7489,40728,14266,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',3464.20,NULL,NULL,1,'2024-06-18 11:44:13','2024-06-18 11:44:13',NULL),(3497,7489,40728,14266,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',0.00,NULL,NULL,1,'2024-06-18 11:44:13','2024-06-18 11:44:13',NULL),(3498,7489,40728,14266,3,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',145332.00,NULL,NULL,1,'2024-06-18 11:44:13','2024-06-18 11:44:13',NULL),(3499,7489,40728,14266,3,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',254847.29,NULL,NULL,1,'2024-06-18 11:44:13','2024-06-18 11:44:13',NULL),(3500,7489,40728,14266,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',1918.90,NULL,NULL,1,'2024-06-18 11:44:13','2024-06-18 11:44:13',NULL),(3501,7489,40728,14266,3,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',5368.26,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3502,7489,40728,14266,3,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',78120.35,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3503,7489,40728,14266,3,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',4748.71,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3504,7489,40728,14266,3,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',203889.64,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3505,7489,40728,14266,3,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',104086.83,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3506,7489,40728,14266,3,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',11117.77,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3507,7489,40728,14266,3,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',4760.07,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3508,7489,40728,14266,3,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',249066.16,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3509,7489,40728,14266,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',168947.12,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3510,7489,40728,14266,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',3200.11,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3511,7489,40728,14266,3,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',27366.33,NULL,NULL,1,'2024-06-18 11:44:14','2024-06-18 11:44:14',NULL),(3512,7489,40728,14266,3,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',13497.81,NULL,NULL,1,'2024-06-18 11:44:15','2024-06-18 11:44:15',NULL),(3513,7489,40728,14266,3,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',774321.14,NULL,NULL,1,'2024-06-18 11:44:15','2024-06-18 11:44:15',NULL),(3514,7489,40728,14266,3,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',209842.55,NULL,NULL,1,'2024-06-18 11:44:15','2024-06-18 11:44:15',NULL);
INSERT INTO `balance_libro` VALUES (3515,7489,40728,14266,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',83340.12,NULL,NULL,1,'2024-06-18 11:44:15','2024-06-18 11:44:15',NULL),(3516,7489,40728,14266,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',18366.92,NULL,NULL,1,'2024-06-18 11:44:15','2024-06-18 11:44:15',NULL),(3517,7489,40728,14266,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',70000.00,NULL,NULL,1,'2024-06-18 11:44:15','2024-06-18 11:44:15',NULL),(3518,7489,40728,14266,3,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',324353.00,NULL,NULL,1,'2024-06-18 11:44:15','2024-06-18 11:44:15',NULL),(3519,7489,40728,14266,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',50220.50,NULL,NULL,1,'2024-06-18 11:44:15','2024-06-18 11:44:15',NULL),(3520,7489,40728,14266,3,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',46655.03,NULL,NULL,1,'2024-06-18 11:44:15','2024-06-18 11:44:15',NULL),(3521,7489,40728,14266,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',66573.98,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3522,7489,40728,14266,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',50539.82,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3523,7489,40728,14266,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',144073.54,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3524,7489,40728,14266,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',52000.63,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3525,7489,40728,14266,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',42574.00,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3526,7489,40728,14266,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',12709.58,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3527,7489,40728,14266,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',70102.96,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3528,7489,40728,14266,3,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',12669.13,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3529,7489,40728,14266,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',3011.63,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3530,7489,40728,14266,3,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',16041.51,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3531,7489,40728,14266,3,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',1237767.87,NULL,NULL,1,'2024-06-18 11:44:16','2024-06-18 11:44:16',NULL),(3532,7489,40728,14266,3,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',5298.79,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3533,7489,40728,14266,3,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',4592475.99,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3534,7489,40728,14266,3,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',101947.61,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL);
INSERT INTO `balance_libro` VALUES (3535,7489,40728,14266,3,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',41845.24,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3536,7489,40728,14266,3,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',17412.68,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3537,7489,40728,14266,3,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',3966.09,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3538,7489,40728,14266,3,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',16138.82,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3539,7489,40728,14266,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',31979.41,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3540,7489,40728,14266,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',38254.65,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3541,7489,40728,14266,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',211570.77,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3542,7489,40728,14266,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',8999.21,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3543,7489,40728,14266,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',4995.20,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3544,7489,40728,14266,3,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',24723.52,NULL,NULL,1,'2024-06-18 11:44:17','2024-06-18 11:44:17',NULL),(3545,7489,40728,14266,3,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',56479.88,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3546,7489,40728,14266,3,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',28220.80,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3547,7489,40728,14266,3,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',30784.05,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3548,7489,40728,14266,3,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',18704.48,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3549,7489,40728,14266,3,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',12702.92,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3550,7489,40728,14266,3,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',8207.41,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3551,7489,40728,14266,3,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',15004.30,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3552,7489,40728,14266,3,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',9037.28,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3553,7489,40728,14266,3,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',2246940.72,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3554,7489,40728,14266,3,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',39483.67,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3555,7489,40728,14266,3,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',6209332.80,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL);
INSERT INTO `balance_libro` VALUES (3556,7489,40728,14266,3,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',80568.97,NULL,NULL,1,'2024-06-18 11:44:18','2024-06-18 11:44:18',NULL),(3557,7489,40728,14266,3,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',23055.98,NULL,NULL,1,'2024-06-18 11:44:19','2024-06-18 11:44:19',NULL),(3558,7489,40728,14266,3,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',31266.88,NULL,NULL,1,'2024-06-18 11:44:19','2024-06-18 11:44:19',NULL),(3559,7489,40728,14266,3,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',48489.58,NULL,NULL,1,'2024-06-18 11:44:19','2024-06-18 11:44:19',NULL),(3560,7489,40728,14266,3,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',16442.92,NULL,NULL,1,'2024-06-18 11:44:19','2024-06-18 11:44:19',NULL),(3561,7489,40728,14266,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',23383.53,NULL,NULL,1,'2024-06-18 11:44:19','2024-06-18 11:44:19',NULL),(3562,7489,40728,14266,3,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',12619.27,NULL,NULL,1,'2024-06-18 11:44:19','2024-06-18 11:44:19',NULL),(3563,7489,40799,17263,2,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',580800.00,NULL,NULL,1,'2024-06-19 09:34:38','2024-06-19 09:34:38',NULL),(3564,7489,40799,17263,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',508200.00,NULL,NULL,1,'2024-06-19 09:34:38','2024-06-19 09:34:38',NULL),(3565,7489,40799,17263,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',14630.61,NULL,NULL,1,'2024-06-19 09:34:51','2024-06-19 10:46:41','2024-06-19 10:46:41'),(3566,7489,40799,17263,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',14645.33,NULL,NULL,1,'2024-06-19 09:34:51','2024-06-19 10:46:23','2024-06-19 10:46:23'),(3567,7489,40799,17263,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',155502.00,NULL,NULL,1,'2024-06-19 09:34:51','2024-06-19 09:36:39','2024-06-19 09:36:39'),(3568,7489,40799,17263,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-12','2024-05-12',14173.12,NULL,NULL,1,'2024-06-19 09:34:51','2024-06-19 10:45:43','2024-06-19 10:45:43'),(3569,7489,40799,17263,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',198350.00,NULL,NULL,1,'2024-06-19 09:34:51','2024-06-19 10:45:25','2024-06-19 10:45:25'),(3570,7489,40799,17263,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-25','2024-05-25',38799.38,NULL,NULL,1,'2024-06-19 09:34:51','2024-06-19 10:45:06','2024-06-19 10:45:06'),(3571,7489,40799,17263,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',20000.00,NULL,NULL,1,'2024-06-19 09:34:51','2024-06-19 10:44:46','2024-06-19 10:44:46'),(3572,7489,40799,17263,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',155502.00,NULL,NULL,1,'2024-06-19 09:36:39','2024-06-19 10:46:06','2024-06-19 10:46:06'),(3573,7489,40799,17263,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',20000.00,NULL,NULL,1,'2024-06-19 10:44:46','2024-06-19 10:44:46',NULL),(3574,7489,40799,17263,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-25','2024-05-25',38799.38,NULL,NULL,1,'2024-06-19 10:45:06','2024-06-19 10:45:06',NULL),(3575,7489,40799,17263,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',198350.00,NULL,NULL,1,'2024-06-19 10:45:25','2024-06-19 10:45:25',NULL);
INSERT INTO `balance_libro` VALUES (3576,7489,40799,17263,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-12','2024-05-12',14173.12,NULL,NULL,1,'2024-06-19 10:45:43','2024-06-19 10:45:43',NULL),(3577,7489,40799,17263,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',155502.00,NULL,NULL,1,'2024-06-19 10:46:06','2024-06-19 10:46:06',NULL),(3578,7489,40799,17263,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',14645.33,NULL,NULL,1,'2024-06-19 10:46:23','2024-06-19 10:46:23',NULL),(3579,7489,40799,17263,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',14630.61,NULL,NULL,1,'2024-06-19 10:46:41','2024-06-19 10:46:41',NULL),(3580,7489,40726,10923,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-04-30',NULL,517577.05,NULL,NULL,1,'2024-06-29 12:19:03','2024-06-29 12:19:03',NULL),(3581,7489,40726,10924,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-05-31',NULL,523242.71,NULL,NULL,1,'2024-06-29 12:26:58','2024-06-29 12:26:58',NULL),(3582,7489,40725,9373,3,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',896545.74,NULL,NULL,1,'2024-06-29 12:45:29','2024-06-29 12:45:29',NULL),(3583,7489,40725,9373,3,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',597697.17,NULL,NULL,1,'2024-06-29 12:46:19','2024-06-29 12:46:19',NULL),(3584,7489,40724,7796,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-04-30',NULL,13387608.36,NULL,NULL,1,'2024-07-01 11:08:53','2024-07-01 11:08:53',NULL),(3585,7489,40724,7797,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-05-31',NULL,13489697.00,NULL,NULL,1,'2024-07-01 11:18:46','2024-07-01 11:18:46',NULL),(3586,7489,40725,9372,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-05-31',NULL,408651.17,NULL,NULL,1,'2024-07-02 14:38:46','2024-07-02 14:38:46',NULL),(3587,7489,40727,12541,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-05-31',NULL,973502.79,NULL,NULL,1,'2024-07-02 15:00:07','2024-07-02 15:00:07',NULL),(3588,7489,40728,14266,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-05-31',NULL,2198197.01,NULL,NULL,1,'2024-07-04 10:28:05','2024-07-04 10:28:05',NULL),(3589,7489,40724,7798,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',186955131.44,NULL,NULL,1,'2024-07-15 16:11:35','2024-07-15 16:11:35',NULL),(3590,7489,40724,7798,3,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',168044535.21,NULL,NULL,1,'2024-07-15 16:14:05','2024-07-15 16:14:05',NULL),(3591,7489,40724,7798,15,3591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',28304247.56,'Liquidacion mensual',NULL,1,'2024-07-15 16:16:24','2024-07-15 16:16:24',NULL),(3592,7489,40724,7798,16,3592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',4717374.50,'Liquidacion mensual',NULL,1,'2024-07-15 16:18:20','2024-07-15 16:18:20',NULL),(3593,7489,40728,14267,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',110407.00,NULL,NULL,1,'2024-07-17 09:51:14','2024-07-17 09:51:14',NULL),(3594,7489,40728,14267,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',186697.18,NULL,NULL,1,'2024-07-17 09:51:14','2024-07-17 09:51:14',NULL),(3595,7489,40728,14267,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',281812.00,NULL,NULL,1,'2024-07-17 09:51:14','2024-07-17 09:51:14',NULL),(3596,7489,40728,14267,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',346644.06,NULL,NULL,1,'2024-07-17 09:51:14','2024-07-17 09:51:14',NULL);
INSERT INTO `balance_libro` VALUES (3597,7489,40728,14267,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',582473.19,NULL,NULL,1,'2024-07-17 09:51:14','2024-07-17 09:51:14',NULL),(3598,7489,40728,14267,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',691903.94,NULL,NULL,1,'2024-07-17 09:51:14','2024-07-17 09:51:14',NULL),(3599,7489,40728,14267,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',276172.03,NULL,NULL,1,'2024-07-17 09:51:14','2024-07-17 09:51:14',NULL),(3600,7489,40728,14267,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',624538.92,NULL,NULL,1,'2024-07-17 09:51:14','2024-07-17 09:51:14',NULL),(3601,7489,40728,14267,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',440689.98,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3602,7489,40728,14267,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',314016.44,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3603,7489,40728,14267,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',269533.83,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3604,7489,40728,14267,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',545880.00,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3605,7489,40728,14267,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',162566.00,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3606,7489,40728,14267,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',493247.64,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 10:05:39','2024-07-17 10:05:39'),(3607,7489,40728,14267,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',608662.20,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3608,7489,40728,14267,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',189290.34,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 10:07:50','2024-07-17 10:07:50'),(3609,7489,40728,14267,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',276602.73,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3610,7489,40728,14267,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',148594.97,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3611,7489,40728,14267,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',443490.58,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3612,7489,40728,14267,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',438945.46,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 10:09:45','2024-07-17 10:09:45'),(3613,7489,40728,14267,2,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',387051.55,NULL,NULL,1,'2024-07-17 09:51:15','2024-07-17 09:51:15',NULL),(3614,7489,40728,14267,2,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',233838.27,NULL,NULL,1,'2024-07-17 09:51:16','2024-07-17 09:51:16',NULL),(3615,7489,40728,14267,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',493427.64,NULL,NULL,1,'2024-07-17 10:05:39','2024-07-17 10:05:39',NULL),(3616,7489,40728,14267,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',189290.94,NULL,NULL,1,'2024-07-17 10:07:50','2024-07-17 10:07:50',NULL);
INSERT INTO `balance_libro` VALUES (3617,7489,40728,14267,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',441041.38,NULL,NULL,1,'2024-07-17 10:09:45','2024-07-17 10:16:38','2024-07-17 10:16:38'),(3618,7489,40728,14267,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',441631.46,NULL,NULL,1,'2024-07-17 10:16:38','2024-07-17 10:16:38',NULL),(3619,7489,40728,14267,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',19181279.88,NULL,NULL,1,'2024-07-17 10:26:03','2024-07-17 10:26:03',NULL),(3620,7489,40728,14267,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1620317.66,NULL,NULL,1,'2024-07-17 10:26:42','2024-07-17 10:26:42',NULL),(3621,7489,40728,14267,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',2174069.90,NULL,NULL,1,'2024-07-17 10:27:14','2024-07-17 10:27:14',NULL),(3622,7489,40728,14267,3,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',26113.56,NULL,NULL,1,'2024-07-17 10:33:46','2024-07-17 10:33:46',NULL),(3623,7489,40728,14267,3,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',163958.65,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3624,7489,40728,14267,3,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',41527.57,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3625,7489,40728,14267,3,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',1902.85,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3626,7489,40728,14267,3,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',208322.21,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3627,7489,40728,14267,3,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',24223.64,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3628,7489,40728,14267,3,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',451751.22,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3629,7489,40728,14267,3,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',4889.31,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3630,7489,40728,14267,3,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',3557.50,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3631,7489,40728,14267,3,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',296085.80,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3632,7489,40728,14267,3,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',18697.65,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3633,7489,40728,14267,3,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',560681.55,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3634,7489,40728,14267,3,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',46954.90,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3635,7489,40728,14267,3,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',59469.99,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL),(3636,7489,40728,14267,3,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',104824.34,NULL,NULL,1,'2024-07-17 10:33:47','2024-07-17 10:33:47',NULL);
INSERT INTO `balance_libro` VALUES (3637,7489,40728,14267,3,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',399874.25,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3638,7489,40728,14267,3,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',27181.62,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3639,7489,40728,14267,3,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',3557.50,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3640,7489,40728,14267,3,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',45600.06,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3641,7489,40728,14267,3,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',33628.99,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3642,7489,40728,14267,3,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',39598.13,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3643,7489,40728,14267,3,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',180584.03,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3644,7489,40728,14267,3,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',120532.91,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3645,7489,40728,14267,3,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',360214.88,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3646,7489,40728,14267,3,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',168314.14,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3647,7489,40728,14267,3,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',99357.53,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3648,7489,40728,14267,3,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',23212.08,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3649,7489,40728,14267,3,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',222719.32,NULL,NULL,1,'2024-07-17 10:33:48','2024-07-17 10:33:48',NULL),(3650,7489,40728,14267,3,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',33057.75,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3651,7489,40728,14267,3,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',642046.30,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3652,7489,40728,14267,3,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',29492.79,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3653,7489,40728,14267,3,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',249954.32,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3654,7489,40728,14267,3,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',540879.45,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3655,7489,40728,14267,3,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',3495.48,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3656,7489,40728,14267,3,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',258292.79,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL);
INSERT INTO `balance_libro` VALUES (3657,7489,40728,14267,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',129346.29,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3658,7489,40728,14267,3,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',145878.59,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3659,7489,40728,14267,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',506224.71,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3660,7489,40728,14267,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',258630.35,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3661,7489,40728,14267,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',36144.22,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3662,7489,40728,14267,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',206420.84,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3663,7489,40728,14267,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',425920.02,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3664,7489,40728,14267,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',1957.41,NULL,NULL,1,'2024-07-17 10:33:49','2024-07-17 10:33:49',NULL),(3665,7489,40728,14267,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',537778.84,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3666,7489,40728,14267,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',22193.94,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3667,7489,40728,14267,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',321333.12,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3668,7489,40728,14267,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',758492.13,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3669,7489,40728,14267,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',389274.40,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3670,7489,40728,14267,3,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',28423.43,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3671,7489,40728,14267,3,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',5881.76,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3672,7489,40728,14267,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',9039.39,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3673,7489,40728,14267,3,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',49895.21,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3674,7489,40728,14267,3,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',570509.19,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3675,7489,40728,14267,3,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',59693.50,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3676,7489,40728,14267,3,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',814094.03,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL);
INSERT INTO `balance_libro` VALUES (3677,7489,40728,14267,3,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',10914.38,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3678,7489,40728,14267,3,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',18713.65,NULL,NULL,1,'2024-07-17 10:33:50','2024-07-17 10:33:50',NULL),(3679,7489,40728,14267,3,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',39727.74,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3680,7489,40728,14267,3,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',431849.89,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3681,7489,40728,14267,3,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',58927.97,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3682,7489,40728,14267,3,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',457.94,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3683,7489,40728,14267,3,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',52265.13,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3684,7489,40728,14267,3,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',5833.93,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3685,7489,40728,14267,3,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',33580.15,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3686,7489,40728,14267,3,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',31112.67,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3687,7489,40728,14267,3,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',25522.27,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3688,7489,40728,14267,3,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',31112.67,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3689,7489,40728,14267,3,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',294403.12,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3690,7489,40728,14267,3,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',54485.77,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3691,7489,40728,14267,3,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',9628.17,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3692,7489,40728,14267,3,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',9806.59,NULL,NULL,1,'2024-07-17 10:33:51','2024-07-17 10:33:51',NULL),(3693,7489,40728,14267,3,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',155425.02,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3694,7489,40728,14267,3,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',7.99,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3695,7489,40728,14267,3,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',7.99,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3696,7489,40728,14267,3,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',12472.24,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3697,7489,40728,14267,3,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',31734.26,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL);
INSERT INTO `balance_libro` VALUES (3698,7489,40728,14267,3,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',22825.17,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3699,7489,40728,14267,3,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',14054.49,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3700,7489,40728,14267,3,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',15267.10,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3701,7489,40728,14267,3,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',814725.95,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3702,7489,40728,14267,3,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',6565.94,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3703,7489,40728,14267,3,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',798866.74,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3704,7489,40728,14267,3,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',48128.73,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3705,7489,40728,14267,3,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',713727.81,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3706,7489,40728,14267,3,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',23370.85,NULL,NULL,1,'2024-07-17 10:33:52','2024-07-17 10:33:52',NULL),(3707,7489,40728,14267,3,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',548161.62,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3708,7489,40728,14267,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',683763.78,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3709,7489,40728,14267,3,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',96029.11,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3710,7489,40728,14267,3,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',9774.53,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3711,7489,40728,14267,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',271591.53,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3712,7489,40728,14267,3,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',182016.77,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3713,7489,40728,14267,3,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',10604.96,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3714,7489,40728,14267,3,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',107.20,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3715,7489,40728,14267,3,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',9804.57,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3716,7489,40728,14267,3,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',70538.40,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3717,7489,40728,14267,3,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',156819.85,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3718,7489,40728,14267,3,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',180.72,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL);
INSERT INTO `balance_libro` VALUES (3719,7489,40728,14267,3,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',18858.70,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3720,7489,40728,14267,3,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',18900.40,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3721,7489,40728,14267,3,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',50696.00,NULL,NULL,1,'2024-07-17 10:33:53','2024-07-17 10:33:53',NULL),(3722,7489,40728,14267,3,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',3617.81,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3723,7489,40728,14267,3,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',11112.03,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3724,7489,40728,14267,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',523847.96,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3725,7489,40728,14267,3,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',266405.42,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3726,7489,40728,14267,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',24902.47,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3727,7489,40728,14267,3,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',29145.14,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3728,7489,40728,14267,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',476335.04,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3729,7489,40728,14267,3,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',418925.91,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3730,7489,40728,14267,3,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',1302.48,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3731,7489,40728,14267,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',77307.35,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3732,7489,40728,14267,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',745189.03,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3733,7489,40728,14267,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',3751.81,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3734,7489,40728,14267,3,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',199069.17,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3735,7489,40728,14267,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',6330.21,NULL,NULL,1,'2024-07-17 10:33:54','2024-07-17 10:33:54',NULL),(3736,7489,40728,14267,3,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',213630.15,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3737,7489,40728,14267,3,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',23559.01,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3738,7489,40728,14267,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',20346.73,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3739,7489,40728,14267,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',1957.41,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL);
INSERT INTO `balance_libro` VALUES (3740,7489,40728,14267,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',5985.60,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3741,7489,40728,14267,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',327617.23,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3742,7489,40728,14267,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',579454.54,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3743,7489,40728,14267,3,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',35043.29,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3744,7489,40728,14267,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',161851.48,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3745,7489,40728,14267,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',830315.21,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3746,7489,40728,14267,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',630686.38,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3747,7489,40728,14267,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',43938.52,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3748,7489,40728,14267,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',2928.08,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3749,7489,40728,14267,3,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',542394.62,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3750,7489,40728,14267,3,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',19842.87,NULL,NULL,1,'2024-07-17 10:33:55','2024-07-17 10:33:55',NULL),(3751,7489,40728,14267,3,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',93118.28,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3752,7489,40728,14267,3,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',719931.87,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3753,7489,40728,14267,3,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',279570.27,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3754,7489,40728,14267,3,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',266103.18,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3755,7489,40728,14267,3,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',385991.86,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3756,7489,40728,14267,3,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',54953.26,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3757,7489,40728,14267,3,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',487872.18,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3758,7489,40728,14267,3,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',14512.48,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3759,7489,40728,14267,3,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',158465.76,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL);
INSERT INTO `balance_libro` VALUES (3760,7489,40728,14267,3,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',9881.24,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3761,7489,40728,14267,3,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',10021.90,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3762,7489,40728,14267,3,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',3421.45,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3763,7489,40728,14267,3,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',470694.16,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3764,7489,40728,14267,3,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',7241.78,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3765,7489,40728,14267,3,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',23359.26,NULL,NULL,1,'2024-07-17 10:33:56','2024-07-17 10:33:56',NULL),(3766,7489,40728,14267,3,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',0.00,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3767,7489,40728,14267,3,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',51601.52,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3768,7489,40728,14267,3,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',15898.63,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3769,7489,40728,14267,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',780186.56,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3770,7489,40728,14267,3,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',59999.28,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3771,7489,40728,14267,3,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',2858.14,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3772,7489,40728,14267,3,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',310850.04,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3773,7489,40728,14267,3,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',109408.94,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3774,7489,40728,14267,3,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',85186.66,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3775,7489,40728,14267,3,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',88827.45,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3776,7489,40728,14267,3,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',12872.65,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3777,7489,40728,14267,3,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',173821.37,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3778,7489,40728,14267,3,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',263323.45,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3779,7489,40728,14267,3,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',525458.39,NULL,NULL,1,'2024-07-17 10:33:57','2024-07-17 10:33:57',NULL),(3780,7489,40728,14267,3,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',30036.38,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL);
INSERT INTO `balance_libro` VALUES (3781,7489,40728,14267,3,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',145397.13,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3782,7489,40728,14267,3,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',450190.53,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3783,7489,40728,14267,3,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',12602.07,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3784,7489,40728,14267,3,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',384994.20,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3785,7489,40728,14267,3,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',6185.00,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3786,7489,40728,14267,3,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',10264.33,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3787,7489,40728,14267,3,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',354843.25,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3788,7489,40728,14267,3,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',2268.11,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3789,7489,40728,14267,3,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',18366.92,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3790,7489,40728,14267,3,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',80000.00,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3791,7489,40728,14267,3,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',352809.00,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3792,7489,40728,14267,3,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',55154.00,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3793,7489,40728,14267,3,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',26113.56,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3794,7489,40728,14267,3,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',150561.39,NULL,NULL,1,'2024-07-17 10:33:58','2024-07-17 10:33:58',NULL),(3795,7489,40728,14267,3,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',249077.88,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3796,7489,40728,14267,3,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',14774.31,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3797,7489,40728,14267,3,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',36727.88,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3798,7489,40728,14267,3,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',4363.08,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3799,7489,40728,14267,3,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',17096.28,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3800,7489,40728,14267,3,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',10397.88,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL);
INSERT INTO `balance_libro` VALUES (3801,7489,40728,14267,3,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',18347.53,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3802,7489,40728,14267,3,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',1366685.07,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3803,7489,40728,14267,3,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',3901315.35,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3804,7489,40728,14267,3,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',11483.83,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3805,7489,40728,14267,3,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',13265.40,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3806,7489,40728,14267,3,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',39128.62,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3807,7489,40728,14267,3,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',102513.74,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3808,7489,40728,14267,3,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',18174.28,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3809,7489,40728,14267,3,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',5680.43,NULL,NULL,1,'2024-07-17 10:33:59','2024-07-17 10:33:59',NULL),(3810,7489,40728,14267,3,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',23091.57,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3811,7489,40728,14267,3,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',5135.70,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3812,7489,40728,14267,3,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',44118.02,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3813,7489,40728,14267,3,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',17556.70,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3814,7489,40728,14267,3,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',20000.00,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3815,7489,40728,14267,3,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',12664.78,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3816,7489,40728,14267,3,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',5357856.61,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3817,7489,40728,14267,3,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',226335.09,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3818,7489,40728,14267,3,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',2392062.66,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3819,7489,40728,14267,3,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',51508.74,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3820,7489,40728,14267,3,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',29927.27,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL);
INSERT INTO `balance_libro` VALUES (3821,7489,40728,14267,3,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',8519.72,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3822,7489,40728,14267,3,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',5769.15,NULL,NULL,1,'2024-07-17 10:34:00','2024-07-17 10:34:00',NULL),(3823,7489,40725,9373,2,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',3223389.18,NULL,NULL,1,'2024-07-17 11:04:30','2024-07-17 11:04:30',NULL),(3824,7489,40725,9373,2,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',2063050.00,NULL,NULL,1,'2024-07-17 11:04:30','2024-07-17 11:04:30',NULL),(3825,7489,40725,9373,2,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',1611694.59,NULL,NULL,1,'2024-07-17 11:04:30','2024-07-17 11:04:30',NULL),(3826,7489,40725,9373,2,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',738100.00,NULL,NULL,1,'2024-07-17 11:04:30','2024-07-17 11:04:30',NULL),(3827,7489,40725,9373,2,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',3223389.18,NULL,NULL,1,'2024-07-17 11:04:30','2024-07-17 11:04:30',NULL),(3828,7489,40725,9373,2,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',738100.00,NULL,NULL,1,'2024-07-17 11:04:30','2024-07-17 11:04:30',NULL),(3829,7489,40725,9373,2,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',2063050.00,NULL,NULL,1,'2024-07-17 11:04:30','2024-07-17 11:04:30',NULL),(3830,7489,40725,9373,2,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',1611694.59,NULL,NULL,1,'2024-07-17 11:04:30','2024-07-17 11:04:30',NULL),(3831,7489,40725,9373,2,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',4012067.00,NULL,NULL,1,'2024-07-17 11:04:30','2024-07-17 11:04:30',NULL),(3832,7489,40725,9373,2,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',2063050.00,NULL,NULL,1,'2024-07-17 11:04:31','2024-07-17 11:04:31',NULL),(3833,7489,40725,9373,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',175500.00,NULL,NULL,1,'2024-07-17 11:04:31','2024-07-17 11:04:31',NULL),(3834,7489,40725,9373,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',188355.00,NULL,NULL,1,'2024-07-17 11:04:31','2024-07-17 11:04:31',NULL),(3835,7489,40725,9373,2,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',217686.00,NULL,NULL,1,'2024-07-17 11:04:31','2024-07-17 11:04:31',NULL),(3836,7489,40725,9373,2,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',804650.00,NULL,NULL,1,'2024-07-17 11:04:31','2024-07-17 11:04:31',NULL),(3837,7489,40725,9373,3,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-02','2024-06-02',140000.00,NULL,NULL,1,'2024-07-17 11:04:44','2024-07-17 12:46:46','2024-07-17 12:46:46'),(3838,7489,40725,9373,3,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',16620.00,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:04:45',NULL),(3839,7489,40725,9373,3,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',121500.00,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 12:47:16','2024-07-17 12:47:16'),(3840,7489,40725,9373,3,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',1989024.62,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:04:45',NULL);
INSERT INTO `balance_libro` VALUES (3841,7489,40725,9373,3,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',22791.56,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:04:45',NULL),(3842,7489,40725,9373,3,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',96800.00,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:04:45',NULL),(3843,7489,40725,9373,3,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',193600.00,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:04:45',NULL),(3844,7489,40725,9373,3,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',1844.63,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:07:46','2024-07-17 11:07:46'),(3845,7489,40725,9373,3,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',387200.00,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:04:45',NULL),(3846,7489,40725,9373,3,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',387200.00,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:04:45',NULL),(3847,7489,40725,9373,3,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',755040.00,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:04:45',NULL),(3848,7489,40725,9373,3,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',1896.01,NULL,NULL,1,'2024-07-17 11:04:45','2024-07-17 11:07:05','2024-07-17 11:07:05'),(3849,7489,40725,9373,3,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',1896.01,NULL,NULL,1,'2024-07-17 11:07:05','2024-07-17 11:07:05',NULL),(3850,7489,40725,9373,3,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',1844.63,NULL,NULL,1,'2024-07-17 11:07:46','2024-07-17 11:07:46',NULL),(3851,7489,40725,9373,3,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',38004.71,NULL,NULL,1,'2024-07-17 11:09:59','2024-07-17 11:09:59',NULL),(3852,7489,40725,9373,3,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',28182.74,NULL,NULL,1,'2024-07-17 11:10:48','2024-07-17 11:10:48',NULL),(3853,7489,40725,9373,3,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',24701.88,NULL,NULL,1,'2024-07-17 11:11:32','2024-07-17 11:11:32',NULL),(3854,7489,40725,9373,3,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',29933.56,NULL,NULL,1,'2024-07-17 11:12:07','2024-07-17 11:12:07',NULL),(3855,7489,40725,9373,3,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',38704.13,NULL,NULL,1,'2024-07-17 11:16:30','2024-07-17 11:16:30',NULL),(3856,7489,40725,9373,3,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',34496.89,NULL,NULL,1,'2024-07-17 11:17:13','2024-07-17 11:17:13',NULL),(3857,7489,40725,9374,3,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',35008.20,NULL,NULL,1,'2024-07-17 11:18:10','2024-07-17 11:18:10',NULL),(3858,7489,40725,9374,3,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',43473.38,NULL,NULL,1,'2024-07-17 11:19:38','2024-07-17 11:19:38',NULL),(3859,7489,40725,9374,3,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',27078.13,NULL,NULL,1,'2024-07-17 11:27:45','2024-07-17 11:27:45',NULL),(3860,7489,40727,12542,2,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',49368.00,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:39:35','2025-07-11 12:39:35');
INSERT INTO `balance_libro` VALUES (3861,7489,40727,12542,2,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',54925.17,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:40:03','2025-07-11 12:40:03'),(3862,7489,40727,12542,2,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',94975.19,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:41:04','2025-07-11 12:41:04'),(3863,7489,40727,12542,2,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',77009.26,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:42:09','2025-07-11 12:42:09'),(3864,7489,40727,12542,2,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',15985.13,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:41:58','2025-07-11 12:41:58'),(3865,7489,40727,12542,2,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',35539.35,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:41:47','2025-07-11 12:41:47'),(3866,7489,40727,12542,2,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',656108.32,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:42:21','2025-07-11 12:42:21'),(3867,7489,40727,12542,2,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',15990.38,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:41:17','2025-07-11 12:41:17'),(3868,7489,40727,12542,2,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',24000.00,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:40:27','2025-07-11 12:40:27'),(3869,7489,40727,12542,2,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',14056.01,NULL,NULL,1,'2024-07-17 15:27:48','2025-07-11 12:41:35','2025-07-11 12:41:34'),(3870,7489,40727,12542,2,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',298690.99,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:42:33','2025-07-11 12:42:33'),(3871,7489,40727,12542,2,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',112937.32,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:42:49','2025-07-11 12:42:49'),(3872,7489,40727,12542,2,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',39291.59,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:44:02','2025-07-11 12:44:02'),(3873,7489,40727,12542,2,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',88452.11,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:43:52','2025-07-11 12:43:52'),(3874,7489,40727,12542,2,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',16111.51,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:43:42','2025-07-11 12:43:42'),(3875,7489,40727,12542,2,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',155930.60,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:43:32','2025-07-11 12:43:32'),(3876,7489,40727,12542,2,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',59365.79,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:43:21','2025-07-11 12:43:21'),(3877,7489,40727,12542,2,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',320809.63,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:43:11','2025-07-11 12:43:11'),(3878,7489,40727,12542,2,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',90711.25,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:43:00','2025-07-11 12:43:00'),(3879,7489,40727,12542,2,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',107717.05,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:44:13','2025-07-11 12:44:13');
INSERT INTO `balance_libro` VALUES (3880,7489,40727,12542,2,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',15985.13,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:44:21','2025-07-11 12:44:21'),(3881,7489,40727,12542,2,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',63290.81,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:44:31','2025-07-11 12:44:31'),(3882,7489,40727,12542,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',11906.49,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:53:12','2025-07-11 12:53:12'),(3883,7489,40727,12542,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',300000.14,NULL,NULL,1,'2024-07-17 15:27:49','2025-07-11 12:45:48','2025-07-11 12:45:48'),(3884,7489,40727,12542,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',14000.04,NULL,NULL,1,'2024-07-17 15:27:50','2025-07-11 12:45:36','2025-07-11 12:45:36'),(3885,7489,40727,12542,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',22000.00,NULL,NULL,1,'2024-07-17 15:27:50','2025-07-11 12:45:20','2025-07-11 12:45:20'),(3886,7489,40727,12542,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',53237.77,NULL,NULL,1,'2024-07-17 15:27:50','2025-07-11 12:45:05','2025-07-11 12:45:05'),(3887,7489,40727,12542,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',30000.00,NULL,NULL,1,'2024-07-17 15:27:50','2025-07-11 12:44:52','2025-07-11 12:44:52'),(3888,7489,40727,12542,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',17547.43,NULL,NULL,1,'2024-07-17 15:27:50','2025-07-11 12:44:41','2025-07-11 12:44:41'),(3889,7489,40727,12542,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',162718.25,NULL,NULL,1,'2024-07-17 15:28:05','2024-07-17 15:28:05',NULL),(3890,7489,40727,12542,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',87023.48,NULL,NULL,1,'2024-07-17 15:28:05','2024-07-17 15:28:05',NULL),(3891,7489,40727,12542,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',578658.72,NULL,NULL,1,'2024-07-17 15:28:05','2024-07-17 15:28:05',NULL),(3892,7489,40727,12542,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',346.82,NULL,NULL,1,'2024-07-17 15:28:06','2024-07-17 15:28:06',NULL),(3893,7489,40727,12542,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',5760.00,NULL,NULL,1,'2024-07-17 15:28:06','2024-07-17 15:28:06',NULL),(3894,7489,40727,12542,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',873467.77,NULL,NULL,1,'2024-07-17 15:28:06','2025-07-11 12:50:32','2025-07-11 12:50:32'),(3895,7489,40727,12542,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',54000.00,NULL,NULL,1,'2024-07-17 15:28:06','2025-07-11 12:50:31','2025-07-11 12:50:31'),(3896,7489,40727,12542,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',2376703.67,NULL,NULL,1,'2024-07-17 15:28:06','2025-07-11 12:46:04','2025-07-11 12:46:04'),(3897,7489,40727,12542,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',2770806.79,NULL,NULL,1,'2024-07-17 15:28:06','2024-07-17 15:28:06',NULL),(3898,7489,40727,12542,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',32000.00,NULL,NULL,1,'2024-07-17 15:28:06','2025-07-11 12:50:30','2025-07-11 12:50:30');
INSERT INTO `balance_libro` VALUES (3899,7489,40727,12542,2,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',9000.00,NULL,NULL,1,'2024-07-17 15:28:06','2025-07-11 12:50:14','2025-07-11 12:50:14'),(3900,7489,40727,12542,2,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',9000.00,NULL,NULL,1,'2024-07-17 15:28:06','2025-07-11 12:50:08','2025-07-11 12:50:08'),(3901,7489,40727,12542,2,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',9000.00,NULL,NULL,1,'2024-07-17 15:28:06','2025-07-11 12:50:01','2025-07-11 12:50:01'),(3902,7489,40727,12542,3,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',49368.00,NULL,NULL,1,'2024-07-17 15:28:18','2024-07-17 15:28:18',NULL),(3903,7489,40727,12542,3,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',54925.17,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3904,7489,40727,12542,3,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',94975.19,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3905,7489,40727,12542,3,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',77009.26,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3906,7489,40727,12542,3,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',15985.13,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3907,7489,40727,12542,3,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',35539.35,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3908,7489,40727,12542,3,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',656108.32,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3909,7489,40727,12542,3,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',15990.38,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3910,7489,40727,12542,3,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',24000.00,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3911,7489,40727,12542,3,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',14056.01,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3912,7489,40727,12542,3,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',298690.99,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3913,7489,40727,12542,3,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',112937.32,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3914,7489,40727,12542,3,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',39291.59,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3915,7489,40727,12542,3,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',88452.11,NULL,NULL,1,'2024-07-17 15:28:19','2024-07-17 15:28:19',NULL),(3916,7489,40727,12542,3,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',16111.51,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3917,7489,40727,12542,3,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',155930.60,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3918,7489,40727,12542,3,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',59365.79,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL);
INSERT INTO `balance_libro` VALUES (3919,7489,40727,12542,3,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',320809.63,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3920,7489,40727,12542,3,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',90711.25,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3921,7489,40727,12542,3,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',107717.05,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3922,7489,40727,12542,3,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',15985.13,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3923,7489,40727,12542,3,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',63290.81,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3924,7489,40727,12542,3,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',11906.49,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3925,7489,40727,12542,3,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',300000.14,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3926,7489,40727,12542,3,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',14000.04,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3927,7489,40727,12542,3,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',22000.00,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3928,7489,40727,12542,3,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',53237.77,NULL,NULL,1,'2024-07-17 15:28:20','2024-07-17 15:28:20',NULL),(3929,7489,40727,12542,3,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',30000.00,NULL,NULL,1,'2024-07-17 15:28:21','2024-07-17 15:28:21',NULL),(3930,7489,40727,12542,3,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',17547.43,NULL,NULL,1,'2024-07-17 15:28:21','2024-07-17 15:28:21',NULL),(3931,7489,40799,17264,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',677600.00,NULL,NULL,1,'2024-07-20 09:45:16','2024-07-20 09:45:16',NULL),(3932,7489,40799,17264,2,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',363000.00,NULL,NULL,1,'2024-07-20 09:45:16','2024-07-20 09:45:16',NULL),(3933,7489,40799,17264,2,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',100000.00,NULL,NULL,1,'2024-07-20 09:45:16','2024-07-20 09:45:16',NULL),(3934,7489,40799,17264,2,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',100000.00,NULL,NULL,1,'2024-07-20 09:45:16','2024-07-20 09:45:16',NULL),(3935,7489,40799,17264,3,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',16093.67,NULL,NULL,1,'2024-07-20 09:45:32','2024-07-20 09:49:27','2024-07-20 09:49:27'),(3936,7489,40799,17264,3,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',16109.87,NULL,NULL,1,'2024-07-20 09:45:32','2024-07-20 09:49:05','2024-07-20 09:49:05'),(3937,7489,40799,17264,3,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',235483.00,NULL,NULL,1,'2024-07-20 09:45:32','2024-07-20 09:48:37','2024-07-20 09:48:37'),(3938,7489,40799,17264,3,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',8500.00,NULL,NULL,1,'2024-07-20 09:45:32','2024-07-20 09:50:48','2024-07-20 09:50:48');
INSERT INTO `balance_libro` VALUES (3939,7489,40799,17264,3,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',190000.00,NULL,NULL,1,'2024-07-20 09:45:33','2024-07-20 09:50:21','2024-07-20 09:50:21'),(3940,7489,40799,17264,3,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',15613.86,NULL,NULL,1,'2024-07-20 09:45:33','2024-07-20 09:52:34','2024-07-20 09:52:34'),(3941,7489,40799,17264,3,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',219999.01,NULL,NULL,1,'2024-07-20 09:45:33','2024-07-20 09:52:06','2024-07-20 09:52:06'),(3942,7489,40799,17264,3,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',309411.00,NULL,NULL,1,'2024-07-20 09:45:33','2024-07-20 09:48:05','2024-07-20 09:48:05'),(3943,7489,40799,17264,3,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',46549.93,NULL,NULL,1,'2024-07-20 09:45:33','2025-05-31 09:14:07','2025-05-31 09:14:07'),(3944,7489,40799,17264,3,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',20000.00,NULL,NULL,1,'2024-07-20 09:45:33','2024-07-20 09:47:18','2024-07-20 09:47:18'),(3945,7489,40799,17264,3,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',20000.00,NULL,NULL,1,'2024-07-20 09:47:18','2024-07-20 09:47:18',NULL),(3946,7489,40799,17264,3,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',309410.99,NULL,NULL,1,'2024-07-20 09:48:05','2024-07-20 09:48:05',NULL),(3947,7489,40799,17264,3,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',235483.00,NULL,NULL,1,'2024-07-20 09:48:37','2024-07-20 09:48:37',NULL),(3948,7489,40799,17264,3,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',16109.87,NULL,NULL,1,'2024-07-20 09:49:05','2024-07-20 09:49:05',NULL),(3949,7489,40799,17264,3,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',16093.67,NULL,NULL,1,'2024-07-20 09:49:27','2024-07-20 09:49:27',NULL),(3950,7489,40799,17264,3,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',190000.00,NULL,NULL,1,'2024-07-20 09:50:21','2024-07-20 09:50:21',NULL),(3951,7489,40799,17264,3,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',8500.00,NULL,NULL,1,'2024-07-20 09:50:48','2024-07-20 09:50:48',NULL),(3952,7489,40799,17264,3,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',219999.01,NULL,NULL,1,'2024-07-20 09:52:06','2024-07-20 09:52:06',NULL),(3953,7489,40799,17264,3,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',15613.86,NULL,NULL,1,'2024-07-20 09:52:34','2024-07-20 09:52:34',NULL),(3954,7489,40799,17264,3,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',309488.89,NULL,NULL,1,'2024-07-20 09:56:42','2024-07-20 09:56:42',NULL),(3955,7489,40724,7798,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-06-30',NULL,24043185.68,NULL,NULL,1,'2024-08-01 11:34:37','2024-08-01 11:34:37',NULL),(3956,7489,40727,12542,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-06-30',NULL,1563287.58,NULL,NULL,1,'2024-08-07 09:22:46','2024-08-07 09:22:46',NULL),(3957,7489,40725,9373,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-06-30',NULL,591654.92,NULL,NULL,1,'2024-08-07 09:59:07','2024-08-07 09:59:07',NULL),(3958,7489,40728,14267,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-06-30',NULL,3369715.61,NULL,NULL,1,'2024-08-08 08:40:33','2024-08-08 08:40:33',NULL);
INSERT INTO `balance_libro` VALUES (3959,7489,40728,14268,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',365627.47,NULL,NULL,1,'2024-08-16 09:44:12','2024-08-16 09:54:26','2024-08-16 09:54:26'),(3960,7489,40728,14268,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',286430.78,NULL,NULL,1,'2024-08-16 09:44:12','2024-08-16 09:44:12',NULL),(3961,7489,40728,14268,2,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',283000.98,NULL,NULL,1,'2024-08-16 09:44:13','2024-08-16 09:44:13',NULL),(3962,7489,40728,14268,2,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',368024.66,NULL,NULL,1,'2024-08-16 09:44:13','2024-08-16 09:44:13',NULL),(3963,7489,40728,14268,2,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',633685.63,NULL,NULL,1,'2024-08-16 09:44:13','2024-08-16 09:44:13',NULL),(3964,7489,40728,14268,2,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',441548.07,NULL,NULL,1,'2024-08-16 09:44:13','2024-08-16 09:44:13',NULL),(3965,7489,40728,14268,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',410742.65,NULL,NULL,1,'2024-08-16 09:44:13','2024-08-16 09:44:13',NULL),(3966,7489,40728,14268,2,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',404939.24,NULL,NULL,1,'2024-08-16 09:44:13','2024-08-16 09:44:13',NULL),(3967,7489,40728,14268,2,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',573121.20,NULL,NULL,1,'2024-08-16 09:44:13','2024-08-16 09:44:13',NULL),(3968,7489,40728,14268,2,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',555795.30,NULL,NULL,1,'2024-08-16 09:44:13','2024-08-16 10:02:27','2024-08-16 10:02:27'),(3969,7489,40728,14268,2,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',469245.04,NULL,NULL,1,'2024-08-16 09:44:13','2024-08-16 09:44:13',NULL),(3970,7489,40728,14268,2,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',462570.48,NULL,NULL,1,'2024-08-16 09:44:14','2024-08-16 09:44:14',NULL),(3971,7489,40728,14268,2,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',535174.62,NULL,NULL,1,'2024-08-16 09:44:14','2024-08-16 09:44:14',NULL),(3972,7489,40728,14268,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',203392.46,NULL,NULL,1,'2024-08-16 09:44:14','2024-08-16 09:44:14',NULL),(3973,7489,40728,14268,2,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',262971.00,NULL,NULL,1,'2024-08-16 09:44:14','2024-08-16 09:44:14',NULL),(3974,7489,40728,14268,2,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',233857.41,NULL,NULL,1,'2024-08-16 09:44:14','2024-08-16 09:44:14',NULL),(3975,7489,40728,14268,2,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',218535.10,NULL,NULL,1,'2024-08-16 09:44:14','2024-08-16 09:44:14',NULL),(3976,7489,40728,14268,2,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',497879.99,NULL,NULL,1,'2024-08-16 09:44:14','2024-08-16 09:44:14',NULL),(3977,7489,40728,14268,2,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',177461.78,NULL,NULL,1,'2024-08-16 09:44:14','2024-08-16 09:44:14',NULL),(3978,7489,40728,14268,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',387504.68,NULL,NULL,1,'2024-08-16 09:44:14','2024-08-16 09:44:14',NULL);
INSERT INTO `balance_libro` VALUES (3979,7489,40728,14268,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',334452.52,NULL,NULL,1,'2024-08-16 09:44:15','2024-08-16 09:44:15',NULL),(3980,7489,40728,14268,2,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',236979.75,NULL,NULL,1,'2024-08-16 09:44:15','2024-08-16 09:44:15',NULL),(3981,7489,40728,14268,2,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',258245.00,NULL,NULL,1,'2024-08-16 09:44:15','2024-08-16 09:44:15',NULL),(3982,7489,40728,14268,2,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',417368.72,NULL,NULL,1,'2024-08-16 09:44:15','2024-08-16 09:44:15',NULL),(3983,7489,40728,14268,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',172419.00,NULL,NULL,1,'2024-08-16 09:44:15','2024-08-16 09:56:10','2024-08-16 09:56:10'),(3984,7489,40728,14268,2,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',223649.77,NULL,NULL,1,'2024-08-16 09:44:15','2024-08-16 09:44:15',NULL),(3985,7489,40728,14268,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',365627.00,NULL,NULL,1,'2024-08-16 09:54:26','2024-08-16 09:54:26',NULL),(3986,7489,40728,14268,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',174219.00,NULL,NULL,1,'2024-08-16 09:56:10','2024-08-16 09:56:10',NULL),(3987,7489,40728,14268,2,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',560795.30,NULL,NULL,1,'2024-08-16 10:02:27','2024-08-16 10:02:27',NULL),(3988,7489,40728,14268,2,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',21190366.02,NULL,NULL,1,'2024-08-16 10:10:17','2024-08-16 10:10:17',NULL),(3989,7489,40728,14268,2,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1755322.42,NULL,NULL,1,'2024-08-16 10:11:09','2024-08-16 10:11:09',NULL),(3990,7489,40728,14268,2,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2454237.47,NULL,NULL,1,'2024-08-16 10:11:39','2024-08-16 10:11:39',NULL),(3991,7489,40728,14268,3,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',82402.56,NULL,NULL,1,'2024-08-16 11:26:50','2024-08-16 11:26:50',NULL),(3992,7489,40728,14268,3,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',9037.80,NULL,NULL,1,'2024-08-16 11:26:50','2024-08-16 11:26:50',NULL),(3993,7489,40728,14268,3,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',145332.00,NULL,NULL,1,'2024-08-16 11:26:50','2024-08-16 11:26:50',NULL),(3994,7489,40728,14268,3,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',470965.92,NULL,NULL,1,'2024-08-16 11:26:50','2024-08-16 11:26:50',NULL),(3995,7489,40728,14268,3,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',3385.32,NULL,NULL,1,'2024-08-16 11:26:50','2024-08-16 11:26:50',NULL),(3996,7489,40728,14268,3,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',512957.49,NULL,NULL,1,'2024-08-16 11:26:50','2024-08-16 11:26:50',NULL),(3997,7489,40728,14268,3,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',113119.74,NULL,NULL,1,'2024-08-16 11:26:50','2024-08-16 11:26:50',NULL),(3998,7489,40728,14268,3,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',385888.37,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL);
INSERT INTO `balance_libro` VALUES (3999,7489,40728,14268,3,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',14833.29,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4000,7489,40728,14268,3,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',334478.69,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4001,7489,40728,14268,3,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',14229.81,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4002,7489,40728,14268,3,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',404224.24,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4003,7489,40728,14268,3,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',20346.73,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4004,7489,40728,14268,3,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',8105.42,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4005,7489,40728,14268,3,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',112305.06,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4006,7489,40728,14268,3,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',172333.86,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4007,7489,40728,14268,3,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',74788.16,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4008,7489,40728,14268,3,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',16638.81,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4009,7489,40728,14268,3,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',15411.51,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4010,7489,40728,14268,3,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',20347.45,NULL,NULL,1,'2024-08-16 11:26:51','2024-08-16 11:26:51',NULL),(4011,7489,40728,14268,3,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',4356.65,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4012,7489,40728,14268,3,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',7442.68,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4013,7489,40728,14268,3,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',2456.69,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4014,7489,40728,14268,3,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',511063.30,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4015,7489,40728,14268,3,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',6842.89,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4016,7489,40728,14268,3,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',31112.67,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4017,7489,40728,14268,3,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',18149.88,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4018,7489,40728,14268,3,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',13064.36,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4019,7489,40728,14268,3,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',5321.49,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL);
INSERT INTO `balance_libro` VALUES (4020,7489,40728,14268,3,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',5329.58,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4021,7489,40728,14268,3,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',78117.26,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4022,7489,40728,14268,3,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',100000.00,NULL,NULL,1,'2024-08-16 11:26:52','2024-08-16 11:26:52',NULL),(4023,7489,40728,14268,3,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',120118.19,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4024,7489,40728,14268,3,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',413423.32,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4025,7489,40728,14268,3,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',229388.41,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4026,7489,40728,14268,3,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',123546.19,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4027,7489,40728,14268,3,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',424215.58,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4028,7489,40728,14268,3,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',713731.25,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4029,7489,40728,14268,3,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',691136.51,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4030,7489,40728,14268,3,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',11574.75,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4031,7489,40728,14268,3,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',10099.36,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4032,7489,40728,14268,3,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',312320.77,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4033,7489,40728,14268,3,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',11676.06,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4034,7489,40728,14268,3,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',28603.17,NULL,NULL,1,'2024-08-16 11:26:53','2024-08-16 11:26:53',NULL),(4035,7489,40728,14268,3,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',7150.58,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4036,7489,40728,14268,3,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',8325.04,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4037,7489,40728,14268,3,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',664190.31,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4038,7489,40728,14268,3,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',25887.81,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4039,7489,40728,14268,3,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',214497.08,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL);
INSERT INTO `balance_libro` VALUES (4040,7489,40728,14268,3,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',52060.31,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4041,7489,40728,14268,3,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',59581.50,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4042,7489,40728,14268,3,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',159933.58,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4043,7489,40728,14268,3,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',402875.16,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4044,7489,40728,14268,3,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',2347.45,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4045,7489,40728,14268,3,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',610403.57,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4046,7489,40728,14268,3,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',2347.45,NULL,NULL,1,'2024-08-16 11:26:54','2024-08-16 11:26:54',NULL),(4047,7489,40728,14268,3,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',27252.55,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4048,7489,40728,14268,3,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',51141.51,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4049,7489,40728,14268,3,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',14763.92,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4050,7489,40728,14268,3,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',1468519.73,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4051,7489,40728,14268,3,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',20674.07,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4052,7489,40728,14268,3,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',4279.33,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4053,7489,40728,14268,3,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',3352402.72,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4054,7489,40728,14268,3,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',96961.17,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4055,7489,40728,14268,3,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',358906.39,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4056,7489,40728,14268,3,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',291087.52,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4057,7489,40728,14268,3,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',5345.01,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4058,7489,40728,14268,3,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',2268.11,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL),(4059,7489,40728,14268,3,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',369964.08,NULL,NULL,1,'2024-08-16 11:26:55','2024-08-16 11:26:55',NULL);
INSERT INTO `balance_libro` VALUES (4060,7489,40728,14268,3,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',18697.65,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4061,7489,40728,14268,3,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',5924.18,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4062,7489,40728,14268,3,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',170870.98,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4063,7489,40728,14268,3,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',69034.86,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4064,7489,40728,14268,3,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',11369.25,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4065,7489,40728,14268,3,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',144333.56,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4066,7489,40728,14268,3,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',24851.02,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4067,7489,40728,14268,3,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',12591.64,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4068,7489,40728,14268,3,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',20208.31,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4069,7489,40728,14268,3,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',22138.42,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4070,7489,40728,14268,3,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',598850.23,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4071,7489,40728,14268,3,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',6861.42,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4072,7489,40728,14268,3,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',759330.41,NULL,NULL,1,'2024-08-16 11:26:56','2024-08-16 11:26:56',NULL),(4073,7489,40728,14268,3,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',731600.27,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4074,7489,40728,14268,3,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',50951.56,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4075,7489,40728,14268,3,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',4622.70,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4076,7489,40728,14268,3,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',3260.88,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4077,7489,40728,14268,3,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',68456.64,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4078,7489,40728,14268,3,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',159608.29,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4079,7489,40728,14268,3,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',552969.64,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4080,7489,40728,14268,3,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',6471.95,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL);
INSERT INTO `balance_libro` VALUES (4081,7489,40728,14268,3,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',73572.05,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4082,7489,40728,14268,3,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',778.97,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4083,7489,40728,14268,3,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',5297.10,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4084,7489,40728,14268,3,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',28603.17,NULL,NULL,1,'2024-08-16 11:26:57','2024-08-16 11:26:57',NULL),(4085,7489,40728,14268,3,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',38396.46,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4086,7489,40728,14268,3,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',18787.17,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4087,7489,40728,14268,3,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',23097.34,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4088,7489,40728,14268,3,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',42062.96,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4089,7489,40728,14268,3,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',37676.99,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4090,7489,40728,14268,3,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',548863.33,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4091,7489,40728,14268,3,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',17363.40,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4092,7489,40728,14268,3,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',647016.62,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4093,7489,40728,14268,3,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',46718.52,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4094,7489,40728,14268,3,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',583520.86,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4095,7489,40728,14268,3,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',560713.84,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4096,7489,40728,14268,3,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',20347.45,NULL,NULL,1,'2024-08-16 11:26:58','2024-08-16 11:26:58',NULL),(4097,7489,40728,14268,3,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',831413.94,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4098,7489,40728,14268,3,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',925438.11,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4099,7489,40728,14268,3,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',468162.37,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4100,7489,40728,14268,3,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',74498.36,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4101,7489,40728,14268,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',7778.23,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL);
INSERT INTO `balance_libro` VALUES (4102,7489,40728,14268,3,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',6281.30,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4103,7489,40728,14268,3,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',226407.84,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4104,7489,40728,14268,3,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',354927.28,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4105,7489,40728,14268,3,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',31232.82,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4106,7489,40728,14268,3,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',1209.14,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4107,7489,40728,14268,3,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',369717.62,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4108,7489,40728,14268,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',7605.59,NULL,NULL,1,'2024-08-16 11:26:59','2024-08-16 11:26:59',NULL),(4109,7489,40728,14268,3,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',18419.88,NULL,NULL,1,'2024-08-16 11:27:00','2024-08-16 11:27:00',NULL),(4110,7489,40728,14268,3,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',573329.35,NULL,NULL,1,'2024-08-16 11:27:00','2024-08-16 11:27:00',NULL),(4111,7489,40728,14268,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',23855.31,NULL,NULL,1,'2024-08-16 11:27:00','2024-08-16 11:27:00',NULL),(4112,7489,40728,14268,3,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',706669.03,NULL,NULL,1,'2024-08-16 11:27:00','2024-08-16 11:27:00',NULL),(4113,7489,40728,14268,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',20347.45,NULL,NULL,1,'2024-08-16 11:27:00','2024-08-16 11:27:00',NULL),(4114,7489,40728,14268,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',10354.88,NULL,NULL,1,'2024-08-16 11:27:00','2024-08-16 11:27:00',NULL),(4115,7489,40728,14268,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',139253.97,NULL,NULL,1,'2024-08-16 11:27:00','2024-08-16 11:27:00',NULL),(4116,7489,40728,14268,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',262098.72,NULL,NULL,1,'2024-08-16 11:27:00','2024-08-16 11:27:00',NULL),(4117,7489,40728,14268,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',14986.61,NULL,NULL,1,'2024-08-16 11:27:01','2024-08-16 11:27:01',NULL),(4118,7489,40728,14268,3,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',3657.54,NULL,NULL,1,'2024-08-16 11:27:01','2024-08-16 11:27:01',NULL),(4119,7489,40728,14268,3,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',26172.40,NULL,NULL,1,'2024-08-16 11:27:01','2024-08-16 11:27:01',NULL),(4120,7489,40728,14268,3,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',85249.06,NULL,NULL,1,'2024-08-16 11:27:01','2024-08-16 11:27:01',NULL),(4121,7489,40728,14268,3,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',68404.57,NULL,NULL,1,'2024-08-16 11:27:01','2024-08-16 11:27:01',NULL),(4122,7489,40728,14268,3,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',2762.31,NULL,NULL,1,'2024-08-16 11:27:02','2024-08-16 11:27:02',NULL);
INSERT INTO `balance_libro` VALUES (4123,7489,40728,14268,3,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',191851.57,NULL,NULL,1,'2024-08-16 11:27:02','2024-08-16 11:27:02',NULL),(4124,7489,40728,14268,3,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',161851.48,NULL,NULL,1,'2024-08-16 11:27:02','2024-08-16 11:27:02',NULL),(4125,7489,40728,14268,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',210284.45,NULL,NULL,1,'2024-08-16 11:27:02','2024-08-16 11:27:02',NULL),(4126,7489,40728,14268,3,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',123546.19,NULL,NULL,1,'2024-08-16 11:27:02','2024-08-16 11:27:02',NULL),(4127,7489,40728,14268,3,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',853880.04,NULL,NULL,1,'2024-08-16 11:27:02','2024-08-16 11:27:02',NULL),(4128,7489,40728,14268,3,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',8741.29,NULL,NULL,1,'2024-08-16 11:27:03','2024-08-16 11:27:03',NULL),(4129,7489,40728,14268,3,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',542406.44,NULL,NULL,1,'2024-08-16 11:27:03','2024-08-16 11:27:03',NULL),(4130,7489,40728,14268,3,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',5985.60,NULL,NULL,1,'2024-08-16 11:27:03','2024-08-16 11:27:03',NULL),(4131,7489,40728,14268,3,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',463932.73,NULL,NULL,1,'2024-08-16 11:27:03','2024-08-16 11:27:03',NULL),(4132,7489,40728,14268,3,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',724132.79,NULL,NULL,1,'2024-08-16 11:27:03','2024-08-16 11:27:03',NULL),(4133,7489,40728,14268,3,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',16898.32,NULL,NULL,1,'2024-08-16 11:27:03','2024-08-16 11:27:03',NULL),(4134,7489,40728,14268,3,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',28470.21,NULL,NULL,1,'2024-08-16 11:27:03','2024-08-16 11:27:03',NULL),(4135,7489,40728,14268,3,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',5359.12,NULL,NULL,1,'2024-08-16 11:27:04','2024-08-16 11:27:04',NULL),(4136,7489,40728,14268,3,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',4885.79,NULL,NULL,1,'2024-08-16 11:27:04','2024-08-16 11:27:04',NULL),(4137,7489,40728,14268,3,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',426357.05,NULL,NULL,1,'2024-08-16 11:27:04','2024-08-16 11:27:04',NULL),(4138,7489,40728,14268,3,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',4805.15,NULL,NULL,1,'2024-08-16 11:27:04','2024-08-16 11:27:04',NULL),(4139,7489,40728,14268,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',11284.07,NULL,NULL,1,'2024-08-16 11:27:04','2024-08-16 11:27:04',NULL),(4140,7489,40728,14268,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',24333.56,NULL,NULL,1,'2024-08-16 11:27:04','2024-08-16 11:27:04',NULL),(4141,7489,40728,14268,3,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',1000205.03,NULL,NULL,1,'2024-08-16 11:27:04','2024-08-16 11:27:04',NULL),(4142,7489,40728,14268,3,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',872026.11,NULL,NULL,1,'2024-08-16 11:27:05','2024-08-16 11:27:05',NULL);
INSERT INTO `balance_libro` VALUES (4143,7489,40728,14268,3,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',10354.63,NULL,NULL,1,'2024-08-16 11:27:05','2024-08-16 11:27:05',NULL),(4144,7489,40728,14268,3,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',177570.15,NULL,NULL,1,'2024-08-16 11:27:05','2024-08-16 11:27:05',NULL),(4145,7489,40728,14268,3,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',1018242.39,NULL,NULL,1,'2024-08-16 11:27:05','2024-08-16 11:27:05',NULL),(4146,7489,40728,14268,3,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',346750.23,NULL,NULL,1,'2024-08-16 11:27:05','2024-08-16 11:27:05',NULL),(4147,7489,40728,14268,3,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',14496.30,NULL,NULL,1,'2024-08-16 11:27:05','2024-08-16 11:27:05',NULL),(4148,7489,40728,14268,3,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',8159.85,NULL,NULL,1,'2024-08-16 11:27:05','2024-08-16 11:27:05',NULL),(4149,7489,40728,14268,3,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',4431.99,NULL,NULL,1,'2024-08-16 11:27:05','2024-08-16 11:27:05',NULL),(4150,7489,40728,14268,3,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',4760642.89,NULL,NULL,1,'2024-08-16 11:27:05','2024-08-16 11:27:05',NULL),(4151,7489,40728,14268,3,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',231327.68,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4152,7489,40728,14268,3,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',35065.81,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4153,7489,40728,14268,3,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',15119.24,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4154,7489,40728,14268,3,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',2431834.95,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4155,7489,40728,14268,3,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',55541.88,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4156,7489,40728,14268,3,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',38884.44,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4157,7489,40728,14268,3,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',628206.52,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4158,7489,40728,14268,3,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',32159.49,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4159,7489,40728,14268,3,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',20717.13,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4160,7489,40728,14268,3,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',1318.76,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4161,7489,40728,14268,3,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',9751.10,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL),(4162,7489,40728,14268,3,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',346759.88,NULL,NULL,1,'2024-08-16 11:27:06','2024-08-16 11:27:06',NULL);
INSERT INTO `balance_libro` VALUES (4163,7489,40728,14268,3,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',23359.26,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4164,7489,40728,14268,3,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',6842.89,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4165,7489,40728,14268,3,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',145360.29,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4166,7489,40728,14268,3,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',60352.26,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4167,7489,40728,14268,3,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',63973.43,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4168,7489,40728,14268,3,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',208003.41,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4169,7489,40728,14268,3,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',114630.68,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4170,7489,40728,14268,3,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',4023.88,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4171,7489,40728,14268,3,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',3623.49,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4172,7489,40728,14268,3,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',3304.12,NULL,NULL,1,'2024-08-16 11:27:07','2024-08-16 11:27:07',NULL),(4173,7489,40728,14268,3,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',10351.45,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4174,7489,40728,14268,3,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',15108.57,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4175,7489,40728,14268,3,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',27439.26,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4176,7489,40728,14268,3,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',722358.60,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4177,7489,40728,14268,3,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',449409.46,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4178,7489,40728,14268,3,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',19415.86,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4179,7489,40728,14268,3,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',329187.57,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4180,7489,40728,14268,3,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',24972.42,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4181,7489,40728,14268,3,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',337314.36,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4182,7489,40728,14268,3,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',4256.08,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL),(4183,7489,40728,14268,3,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',34606.45,NULL,NULL,1,'2024-08-16 11:27:08','2024-08-16 11:27:08',NULL);
INSERT INTO `balance_libro` VALUES (4184,7489,40728,14268,3,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',360754.19,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4185,7489,40728,14268,3,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',59959.72,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4186,7489,40728,14268,3,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',7187.38,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4187,7489,40728,14268,3,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',112305.06,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4188,7489,40728,14268,3,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',366880.00,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4189,7489,40728,14268,3,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',659632.44,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4190,7489,40728,14268,3,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',1305.87,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4191,7489,40728,14268,3,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',282919.62,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4192,7489,40728,14268,3,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',6471.95,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4193,7489,40728,14268,3,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',68456.64,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4194,7489,40728,14268,3,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',14850.59,NULL,NULL,1,'2024-08-16 11:27:09','2024-08-16 11:27:09',NULL),(4195,7489,40728,14268,3,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',18366.92,NULL,NULL,1,'2024-08-16 11:27:10','2024-08-16 11:27:10',NULL),(4196,7489,40728,14268,3,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',148120.30,NULL,NULL,1,'2024-08-16 11:27:10','2024-08-16 11:27:10',NULL),(4197,7489,40728,14268,3,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',301451.16,NULL,NULL,1,'2024-08-16 11:27:10','2024-08-16 11:27:10',NULL),(4198,7489,40727,12543,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',253686.67,NULL,NULL,1,'2024-08-16 12:28:11','2024-08-16 12:28:11',NULL),(4199,7489,40727,12543,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',362455.64,NULL,NULL,1,'2024-08-16 12:28:11','2024-08-16 12:28:11',NULL),(4200,7489,40727,12543,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',3187.28,NULL,NULL,1,'2024-08-16 12:28:11','2024-08-16 12:28:11',NULL),(4201,7489,40727,12543,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',7748.64,NULL,NULL,1,'2024-08-16 12:28:11','2024-08-16 12:28:11',NULL),(4202,7489,40727,12543,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',2404782.90,NULL,NULL,1,'2024-08-16 12:28:11','2024-08-16 12:28:11',NULL),(4203,7489,40727,12543,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',28800.00,NULL,NULL,1,'2024-08-16 12:28:11','2024-08-16 12:28:11',NULL);
INSERT INTO `balance_libro` VALUES (4204,7489,40727,12543,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',254248.54,NULL,NULL,1,'2024-08-16 12:28:11','2024-08-16 12:28:11',NULL),(4205,7489,40727,12543,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',691416.45,NULL,NULL,1,'2024-08-16 12:28:11','2024-08-16 12:28:11',NULL),(4206,7489,40727,12543,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',1929703.88,NULL,NULL,1,'2024-08-16 12:28:12','2024-08-16 12:28:12',NULL),(4207,7489,40727,12543,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',425673.71,NULL,NULL,1,'2024-08-16 12:28:12','2024-08-16 12:28:12',NULL),(4208,7489,40727,12543,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',352425.63,NULL,NULL,1,'2024-08-16 12:28:12','2024-08-16 12:28:12',NULL),(4209,7489,40727,12543,3,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',84043.14,NULL,NULL,1,'2024-08-16 12:28:27','2024-08-16 12:28:27',NULL),(4210,7489,40727,12543,3,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',42621.34,NULL,NULL,1,'2024-08-16 12:28:27','2024-08-16 12:28:27',NULL),(4211,7489,40727,12543,3,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',46147.59,NULL,NULL,1,'2024-08-16 12:28:27','2024-08-16 12:28:27',NULL),(4212,7489,40727,12543,3,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',15789.39,NULL,NULL,1,'2024-08-16 12:28:27','2024-08-16 12:28:27',NULL),(4213,7489,40727,12543,3,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',26103.95,NULL,NULL,1,'2024-08-16 12:28:27','2024-08-16 12:28:27',NULL),(4214,7489,40727,12543,3,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',28000.00,NULL,NULL,1,'2024-08-16 12:28:27','2024-08-16 12:28:27',NULL),(4215,7489,40727,12543,3,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',24268.49,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4216,7489,40727,12543,3,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',46372.56,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4217,7489,40727,12543,3,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',45504.00,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4218,7489,40727,12543,3,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',335013.02,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4219,7489,40727,12543,3,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',261095.00,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4220,7489,40727,12543,3,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',48609.26,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4221,7489,40727,12543,3,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',187550.00,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4222,7489,40727,12543,3,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',197923.75,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4223,7489,40727,12543,3,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',45573.46,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL);
INSERT INTO `balance_libro` VALUES (4224,7489,40727,12543,3,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',44078.73,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4225,7489,40727,12543,3,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',8036.11,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4226,7489,40727,12543,3,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-14','2024-07-14',899.00,NULL,NULL,1,'2024-08-16 12:28:28','2024-08-16 12:28:28',NULL),(4227,7489,40727,12543,3,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',56164.56,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4228,7489,40727,12543,3,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',84845.60,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4229,7489,40727,12543,3,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',59338.16,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4230,7489,40727,12543,3,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',15789.39,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4231,7489,40727,12543,3,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',29438.19,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4232,7489,40727,12543,3,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',65307.99,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:48:53','2024-08-16 12:48:53'),(4233,7489,40727,12543,3,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',218227.26,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4234,7489,40727,12543,3,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',57144.19,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4235,7489,40727,12543,3,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',17187.38,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4236,7489,40727,12543,3,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',8598.74,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4237,7489,40727,12543,3,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',47529.10,NULL,NULL,1,'2024-08-16 12:28:29','2024-08-16 12:28:29',NULL),(4238,7489,40727,12543,3,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',212861.35,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4239,7489,40727,12543,3,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',37800.00,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4240,7489,40727,12543,3,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',81557.00,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4241,7489,40727,12543,3,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',47529.10,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4242,7489,40727,12543,3,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',247939.21,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4243,7489,40727,12543,3,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',58776.54,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL);
INSERT INTO `balance_libro` VALUES (4244,7489,40727,12543,3,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',49911.96,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4245,7489,40727,12543,3,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',14000.04,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4246,7489,40727,12543,3,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',59808.00,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4247,7489,40727,12543,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',22000.00,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4248,7489,40727,12543,3,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',61893.00,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4249,7489,40727,12543,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',60000.00,NULL,NULL,1,'2024-08-16 12:28:30','2024-08-16 12:28:30',NULL),(4250,7489,40727,12543,3,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',65307.99,NULL,NULL,1,'2024-08-16 12:48:53','2024-08-16 12:48:53',NULL),(4251,7489,40725,9374,2,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',738100.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4252,7489,40725,9374,2,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',84700.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4253,7489,40725,9374,2,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',36300.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4254,7489,40725,9374,2,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',263901.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4255,7489,40725,9374,2,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',256520.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4256,7489,40725,9374,2,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',402325.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4257,7489,40725,9374,2,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',4012067.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4258,7489,40725,9374,2,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',196540.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4259,7489,40725,9374,2,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',211600.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4260,7489,40725,9374,2,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',162980.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4261,7489,40725,9374,2,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',1064467.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4262,7489,40725,9374,2,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',250288.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4263,7489,40725,9374,2,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',30250.00,NULL,NULL,1,'2024-08-16 15:36:52','2024-08-16 15:36:52',NULL),(4264,7489,40725,9374,2,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',1047866.05,NULL,NULL,1,'2024-08-16 15:36:53','2024-08-16 15:36:53',NULL);
INSERT INTO `balance_libro` VALUES (4265,7489,40725,9374,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',298320.66,NULL,NULL,1,'2024-08-16 15:37:08','2024-08-16 15:37:08',NULL),(4266,7489,40725,9374,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',16336.00,NULL,NULL,1,'2024-08-16 15:37:08','2024-08-16 15:37:08',NULL),(4267,7489,40725,9374,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',195106.45,NULL,NULL,1,'2024-08-16 15:37:09','2024-08-16 15:37:09',NULL),(4268,7489,40725,9374,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',132110.22,NULL,NULL,1,'2024-08-16 15:37:09','2024-08-16 15:37:09',NULL),(4269,7489,40725,9374,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',188760.00,NULL,NULL,1,'2024-08-16 15:37:09','2024-08-16 15:37:09',NULL),(4270,7489,40725,9374,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-09','2024-07-09',38057.03,NULL,NULL,1,'2024-08-16 15:37:09','2024-08-16 15:37:09',NULL),(4271,7489,40725,9374,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',125434.70,NULL,NULL,1,'2024-08-16 15:37:09','2024-08-16 15:37:09',NULL),(4272,7489,40725,9374,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',1896.01,NULL,NULL,1,'2024-08-16 15:37:09','2024-08-16 15:37:09',NULL),(4273,7489,40725,9374,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',151124.16,NULL,NULL,1,'2024-08-16 15:37:09','2024-08-16 15:37:09',NULL),(4274,7489,40725,9374,3,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',672300.20,NULL,NULL,1,'2024-08-16 15:37:09','2024-08-16 15:37:09',NULL),(4275,7489,40725,9374,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',56144.00,NULL,NULL,1,'2024-08-16 15:37:09','2024-08-16 15:37:09',NULL),(4276,7489,40725,9374,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',37534.20,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL),(4277,7489,40725,9374,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',32000.00,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL),(4278,7489,40725,9374,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',50000.00,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL),(4279,7489,40725,9374,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',250000.00,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL),(4280,7489,40725,9374,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',250000.00,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL),(4281,7489,40725,9374,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',230000.00,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL),(4282,7489,40725,9374,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',250000.00,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL),(4283,7489,40725,9374,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',250000.00,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL),(4284,7489,40725,9374,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',200000.00,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL),(4285,7489,40725,9374,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',250000.00,NULL,NULL,1,'2024-08-16 15:37:10','2024-08-16 15:37:10',NULL);
INSERT INTO `balance_libro` VALUES (4286,7489,40725,9374,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',230000.00,NULL,NULL,1,'2024-08-16 15:37:11','2024-08-16 15:37:11',NULL),(4287,7489,40725,9374,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',415000.00,NULL,NULL,1,'2024-08-16 15:37:11','2024-08-16 15:37:11',NULL),(4288,7489,40725,9374,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',50000.00,NULL,NULL,1,'2024-08-16 15:37:11','2024-08-16 15:37:11',NULL),(4289,7489,40725,9374,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2024-08-16 15:37:11','2024-08-16 15:42:12','2024-08-16 15:42:12'),(4290,7489,40725,9374,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',738100.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:42:03','2024-08-16 15:42:03'),(4291,7489,40725,9374,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',84700.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:41:53','2024-08-16 15:41:53'),(4292,7489,40725,9374,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',36300.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:41:45','2024-08-16 15:41:45'),(4293,7489,40725,9374,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',263901.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:41:37','2024-08-16 15:41:37'),(4294,7489,40725,9374,3,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',256520.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:41:29','2024-08-16 15:41:29'),(4295,7489,40725,9374,3,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',402325.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:41:22','2024-08-16 15:41:22'),(4296,7489,40725,9374,3,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',4012067.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:41:13','2024-08-16 15:41:13'),(4297,7489,40725,9374,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',196540.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:41:05','2024-08-16 15:41:05'),(4298,7489,40725,9374,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',211600.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:40:56','2024-08-16 15:40:56'),(4299,7489,40725,9374,3,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',162980.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:40:48','2024-08-16 15:40:48'),(4300,7489,40725,9374,3,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',1064467.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:40:33','2024-08-16 15:40:33'),(4301,7489,40725,9374,3,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',250288.00,NULL,NULL,1,'2024-08-16 15:37:42','2024-08-16 15:40:23','2024-08-16 15:40:23'),(4302,7489,40725,9374,3,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',30250.00,NULL,NULL,1,'2024-08-16 15:37:43','2024-08-16 15:40:11','2024-08-16 15:40:11'),(4303,7489,40725,9374,3,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',1047866.05,NULL,NULL,1,'2024-08-16 15:37:43','2024-08-16 15:39:58','2024-08-16 15:39:58'),(4304,7489,40724,7799,2,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',239962381.80,NULL,NULL,1,'2024-08-20 09:31:07','2024-08-20 09:31:07',NULL);
INSERT INTO `balance_libro` VALUES (4305,7489,40724,7799,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',237166208.21,NULL,NULL,1,'2024-08-20 09:36:59','2024-08-20 09:36:59',NULL),(4306,7489,40724,7799,15,4306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',36888758.90,'Liquidacion mensual',NULL,1,'2024-08-20 09:41:03','2024-08-20 09:41:03',NULL),(4307,7489,40724,7799,16,4307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',7597401.75,'Liquidacion mensual',NULL,1,'2024-08-20 09:45:52','2024-08-20 09:45:52',NULL),(4308,7489,40799,17265,2,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',435600.00,NULL,NULL,1,'2024-08-20 15:38:10','2024-08-20 15:38:10',NULL),(4309,7489,40799,17265,2,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',1524600.00,NULL,NULL,1,'2024-08-20 15:38:10','2024-08-20 15:38:10',NULL),(4310,7489,40799,17265,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',17720.85,NULL,NULL,1,'2024-08-20 15:38:20','2024-08-20 15:46:38','2024-08-20 15:46:38'),(4311,7489,40799,17265,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',17703.04,NULL,NULL,1,'2024-08-20 15:38:20','2024-08-20 15:46:16','2024-08-20 15:46:16'),(4312,7489,40799,17265,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',144206.94,NULL,NULL,1,'2024-08-20 15:38:20','2024-08-20 15:45:48','2024-08-20 15:45:48'),(4313,7489,40799,17265,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',148502.94,NULL,NULL,1,'2024-08-20 15:38:20','2024-08-20 15:44:42','2024-08-20 15:44:42'),(4314,7489,40799,17265,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',13753.91,NULL,NULL,1,'2024-08-20 15:38:20','2024-08-20 15:44:07','2024-08-20 15:44:07'),(4315,7489,40799,17265,3,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',457529.00,NULL,NULL,1,'2024-08-20 15:38:20','2024-08-20 15:43:36','2024-08-20 15:43:36'),(4316,7489,40799,17265,3,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',25000.00,NULL,NULL,1,'2024-08-20 15:38:20','2024-08-20 15:42:51','2024-08-20 15:42:51'),(4317,7489,40799,17265,3,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',62347.23,NULL,NULL,1,'2024-08-20 15:38:20','2024-08-20 15:42:28','2024-08-20 15:42:28'),(4318,7489,40799,17265,3,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',20986.68,NULL,NULL,1,'2024-08-20 15:38:20','2024-08-20 15:40:03','2024-08-20 15:40:03'),(4319,7489,40799,17265,3,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',20986.68,NULL,NULL,1,'2024-08-20 15:40:03','2024-08-20 15:40:03',NULL),(4320,7489,40799,17265,3,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',62347.23,NULL,NULL,1,'2024-08-20 15:42:28','2024-08-20 15:42:28',NULL),(4321,7489,40799,17265,3,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',25000.00,NULL,NULL,1,'2024-08-20 15:42:51','2024-08-20 15:42:51',NULL),(4322,7489,40799,17265,3,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',457529.00,NULL,NULL,1,'2024-08-20 15:43:36','2024-08-20 15:43:36',NULL),(4323,7489,40799,17265,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',13753.91,NULL,NULL,1,'2024-08-20 15:44:07','2024-08-20 15:44:07',NULL);
INSERT INTO `balance_libro` VALUES (4324,7489,40799,17265,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',148502.94,NULL,NULL,1,'2024-08-20 15:44:42','2024-08-20 15:44:42',NULL),(4325,7489,40799,17265,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',144206.94,NULL,NULL,1,'2024-08-20 15:45:48','2024-08-20 15:45:48',NULL),(4326,7489,40799,17265,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',17703.04,NULL,NULL,1,'2024-08-20 15:46:16','2024-08-20 15:46:16',NULL),(4327,7489,40799,17265,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',17720.85,NULL,NULL,1,'2024-08-20 15:46:38','2024-08-20 15:46:38',NULL),(4328,7489,40799,17265,3,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',564490.70,NULL,NULL,1,'2024-08-20 15:48:14','2024-08-20 15:48:14',NULL),(4329,7489,40727,12543,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-07-31',NULL,1120694.71,NULL,NULL,1,'2024-08-28 09:02:35','2024-08-28 09:02:35',NULL),(4330,7489,40724,7799,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-07-31',NULL,15238350.49,NULL,NULL,1,'2024-09-02 10:57:01','2024-09-02 10:57:01',NULL),(4331,7489,40726,10925,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-06-30',NULL,819702.89,NULL,NULL,1,'2024-09-02 11:51:27','2024-09-02 11:51:27',NULL),(4332,7489,40726,10926,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-07-31',NULL,616748.84,NULL,NULL,1,'2024-09-02 11:51:46','2024-09-02 11:51:46',NULL),(4333,7489,40725,9374,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-07-31',NULL,513928.87,NULL,NULL,1,'2024-09-02 12:23:47','2024-09-02 12:23:47',NULL),(4334,7489,40728,14268,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2024-07-31',NULL,2619447.30,NULL,NULL,1,'2024-09-07 10:37:56','2024-09-07 10:37:56',NULL),(4335,7489,40725,9375,2,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',42350.00,NULL,NULL,1,'2024-09-18 15:00:27','2024-09-18 15:00:27',NULL),(4336,7489,40725,9375,2,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',828960.11,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4337,7489,40725,9375,2,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',1047866.05,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4338,7489,40725,9375,2,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',38115.00,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4339,7489,40725,9375,2,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',383328.00,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4340,7489,40725,9375,2,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',250228.00,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4341,7489,40725,9375,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',520145.12,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4342,7489,40725,9375,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',204185.00,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4343,7489,40725,9375,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',211600.00,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4344,7489,40725,9375,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',162980.00,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL);
INSERT INTO `balance_libro` VALUES (4345,7489,40725,9375,2,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',4505950.00,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4346,7489,40725,9375,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',577775.00,NULL,NULL,1,'2024-09-18 15:00:28','2024-09-18 15:00:28',NULL),(4347,7489,40725,9375,3,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',83105.22,NULL,NULL,1,'2024-09-18 15:00:44','2024-09-18 15:00:44',NULL),(4348,7489,40725,9375,3,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',34969.00,NULL,NULL,1,'2024-09-18 15:00:44','2024-09-18 15:00:44',NULL),(4349,7489,40725,9375,3,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',72630.25,NULL,NULL,1,'2024-09-18 15:00:44','2024-09-18 15:00:44',NULL),(4350,7489,40725,9375,3,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',22307.56,NULL,NULL,1,'2024-09-18 15:00:44','2024-09-18 15:00:44',NULL),(4351,7489,40725,9375,3,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',79321.55,NULL,NULL,1,'2024-09-18 15:00:44','2024-09-18 15:00:44',NULL),(4352,7489,40725,9375,3,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',475638.90,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4353,7489,40725,9375,3,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',86715.18,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4354,7489,40725,9375,3,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',186545.70,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4355,7489,40725,9375,3,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',55329.67,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4356,7489,40725,9375,3,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',201906.65,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4357,7489,40725,9375,3,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',63462.08,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4358,7489,40725,9375,3,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',276188.55,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4359,7489,40725,9375,3,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',474834.25,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4360,7489,40725,9375,3,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',228515.76,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4361,7489,40725,9375,3,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',30392.00,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4362,7489,40725,9375,3,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',285100.20,NULL,NULL,1,'2024-09-18 15:00:45','2024-09-18 15:00:45',NULL),(4363,7489,40725,9375,3,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',88451.00,NULL,NULL,1,'2024-09-18 15:00:46','2024-09-18 15:00:46',NULL),(4364,7489,40725,9375,3,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',328908.25,NULL,NULL,1,'2024-09-18 15:00:46','2024-09-18 15:00:46',NULL),(4365,7489,40725,9375,3,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',40991.17,NULL,NULL,1,'2024-09-18 15:00:46','2024-09-18 15:00:46',NULL);
INSERT INTO `balance_libro` VALUES (4366,7489,40725,9375,3,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',2152.50,NULL,NULL,1,'2024-09-18 15:00:46','2024-09-18 15:00:46',NULL),(4367,7489,40725,9375,3,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',350000.00,NULL,NULL,1,'2024-09-18 15:00:46','2024-09-18 15:00:46',NULL),(4368,7489,40725,9375,3,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',350000.00,NULL,NULL,1,'2024-09-18 15:00:46','2024-09-18 15:00:46',NULL),(4369,7489,40725,9375,3,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',350000.00,NULL,NULL,1,'2024-09-18 15:00:46','2024-09-18 15:00:46',NULL),(4370,7489,40725,9375,3,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',50000.00,NULL,NULL,1,'2024-09-18 15:00:46','2024-09-18 15:00:46',NULL),(4371,7489,40727,12544,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',581381.76,NULL,NULL,1,'2024-09-18 15:16:45','2024-09-18 15:16:45',NULL),(4372,7489,40727,12544,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',22449.69,NULL,NULL,1,'2024-09-18 15:16:45','2024-09-18 15:16:45',NULL),(4373,7489,40727,12544,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',11520.00,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4374,7489,40727,12544,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',3419561.46,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4375,7489,40727,12544,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',449969.91,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4376,7489,40727,12544,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',247635.13,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4377,7489,40727,12544,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',377733.43,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4378,7489,40727,12544,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',223189.32,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4379,7489,40727,12544,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',1776536.50,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4380,7489,40727,12544,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',109752.68,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4381,7489,40727,12544,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',452096.21,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4382,7489,40727,12544,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',20000.00,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4383,7489,40727,12544,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',12000.00,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4384,7489,40727,12544,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',12000.00,NULL,NULL,1,'2024-09-18 15:16:46','2024-09-18 15:16:46',NULL),(4385,7489,40727,12544,3,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',418116.94,NULL,NULL,1,'2024-09-18 15:17:46','2024-09-18 15:17:46',NULL);
INSERT INTO `balance_libro` VALUES (4386,7489,40727,12544,3,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',82352.10,NULL,NULL,1,'2024-09-18 15:17:46','2024-09-18 15:17:46',NULL),(4387,7489,40727,12544,3,3701,'App\\Models\\Receipt',3701,NULL,NULL