-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-21011016-0
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-25 10:44:12','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-25 10:44:12','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Longitud25',NULL,1,40720,'2022-11-02'),(2,NULL,'Longitud25',NULL,1,40720,'2022-11-04'),(3,NULL,'Longitud25',NULL,1,40720,'2022-11-04'),(4,NULL,'Cañasr2022',NULL,1,40721,'2022-11-04'),(5,NULL,'Juana1714v',NULL,1,40763,'2022-11-04'),(6,NULL,'Newells2023',NULL,1,40767,'2022-11-11'),(7,NULL,'Aljanaticristina13',NULL,1,40760,'2022-11-17'),(8,NULL,'Aljanaticristina13',NULL,1,40760,'2022-11-17'),(9,NULL,'Juana1714v',NULL,1,40763,'2023-02-10');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'joseosvaldomure@hotmail.com',NULL,'',1,40720,'2022-11-02'),(2,'joseosvaldomure@hotmail.com',NULL,'',1,40720,'2022-11-04'),(3,'joseosvaldomure@hotmail.com',NULL,'',1,40720,'2022-11-04'),(4,'info@lascandelasfunes.com.ar',NULL,'',1,40721,'2022-11-04'),(5,'rolando-cb@hotmail.com',NULL,'',1,40721,'2022-11-04');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7985,40720,1527,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',5780.80,NULL,NULL,1,'2022-10-26 17:44:18','2022-10-26 17:44:18',NULL),(2,7985,40720,1527,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',3690.57,NULL,NULL,1,'2022-10-26 17:44:18','2022-11-01 21:00:10','2022-11-01 21:00:10'),(3,7985,40720,1527,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',5000.00,NULL,NULL,1,'2022-10-26 20:49:21','2022-10-26 20:49:21',NULL),(4,7985,40720,1527,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',7260.00,NULL,NULL,1,'2022-10-26 20:49:21','2022-10-26 20:49:21',NULL),(5,7985,40720,1527,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',7000.00,NULL,NULL,1,'2022-10-26 20:49:21','2022-10-26 20:49:21',NULL),(6,7985,40720,1527,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',8000.00,NULL,NULL,1,'2022-10-26 20:49:21','2022-10-26 20:49:21',NULL),(7,7985,40720,1527,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',45000.00,NULL,NULL,1,'2022-10-26 20:49:21','2022-10-26 20:49:21',NULL),(8,7985,40720,1527,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',24200.00,NULL,NULL,1,'2022-10-26 20:49:21','2022-10-26 20:49:21',NULL),(9,7985,40721,3041,15,6,'App\\Models\\PeriodLiquidation',NULL,6,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1841.92,NULL,NULL,1,'2022-10-27 12:25:28','2023-03-16 11:45:09','2023-03-16 11:45:09'),(10,7985,40721,3042,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',30000.00,NULL,NULL,1,'2022-10-27 12:41:09','2022-10-27 14:04:58','2022-10-27 14:04:58'),(11,7985,40721,3042,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',30000.00,NULL,NULL,1,'2022-10-27 12:41:09','2022-10-27 14:04:03','2022-10-27 14:04:03'),(12,7985,40721,3042,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',42000.00,NULL,NULL,1,'2022-10-27 12:41:09','2022-10-27 14:03:30','2022-10-27 14:03:30'),(13,7985,40721,3042,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',12500.00,NULL,NULL,1,'2022-10-27 12:41:09','2022-10-27 17:15:07','2022-10-27 17:15:07'),(14,7985,40721,3042,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',150000.00,NULL,NULL,1,'2022-10-27 12:41:09','2022-10-27 12:41:09',NULL),(15,7985,40721,3042,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',12705.00,NULL,NULL,1,'2022-10-27 12:41:09','2022-10-27 12:41:09',NULL),(16,7985,40721,3042,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',21000.00,NULL,NULL,1,'2022-10-27 12:41:09','2022-10-27 14:02:44','2022-10-27 14:02:44'),(17,7985,40721,3042,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',17993.00,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-28 09:35:54','2022-10-28 09:35:54'),(18,7985,40721,3042,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',13956.52,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-27 12:42:59',NULL),(19,7985,40721,3042,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',3505.93,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-28 12:01:20','2022-10-28 12:01:20'),(20,7985,40721,3042,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',31694.71,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-28 09:04:57','2022-10-28 09:04:57');
INSERT INTO `balance_libro` VALUES (21,7985,40721,3042,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',59686.20,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-28 11:59:46','2022-10-28 11:59:46'),(22,7985,40721,3042,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',726.87,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-28 12:28:20','2022-10-28 12:28:20'),(23,7985,40721,3042,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',20226.30,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-27 12:42:59',NULL),(24,7985,40721,3042,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',10643.20,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-27 12:42:59',NULL),(25,7985,40721,3042,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',13863.60,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-27 12:42:59',NULL),(26,7985,40721,3042,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',6611.22,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-27 12:42:59',NULL),(27,7985,40721,3042,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',25470.00,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-28 08:40:07','2022-10-28 08:40:07'),(28,7985,40721,3042,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',15000.01,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-27 12:42:59',NULL),(29,7985,40721,3042,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',55621.23,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-28 08:39:51','2022-10-28 08:39:51'),(30,7985,40721,3042,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',99205.49,NULL,NULL,1,'2022-10-27 12:42:59','2022-10-27 12:42:59',NULL),(31,7985,40721,3042,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',950.00,NULL,NULL,1,'2022-10-27 12:43:00','2022-10-28 08:38:47','2022-10-28 08:38:47'),(32,7985,40721,3042,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',21000.00,NULL,NULL,1,'2022-10-27 14:02:44','2022-10-27 14:02:44',NULL),(33,7985,40721,3042,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',42000.00,NULL,NULL,1,'2022-10-27 14:03:30','2022-10-27 14:03:30',NULL),(34,7985,40721,3042,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',30000.00,NULL,NULL,1,'2022-10-27 14:04:03','2022-10-27 14:04:03',NULL),(35,7985,40721,3042,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',30000.00,NULL,NULL,1,'2022-10-27 14:04:58','2022-10-27 14:04:58',NULL),(36,7985,40721,3042,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',12500.00,NULL,NULL,1,'2022-10-27 17:15:07','2022-10-27 17:15:07',NULL),(37,7985,40721,3042,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',169999.16,NULL,NULL,1,'2022-10-27 23:05:33','2022-10-27 23:05:33',NULL),(38,7985,40721,3042,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',57700.06,NULL,NULL,1,'2022-10-28 11:59:46','2022-10-28 11:59:46',NULL),(39,7985,40721,3042,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',3634.95,NULL,NULL,1,'2022-10-28 12:01:20','2022-10-28 12:01:20',NULL),(40,7985,40721,3042,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',821.15,NULL,NULL,1,'2022-10-28 12:28:20','2022-10-28 12:28:20',NULL),(41,7985,40721,3042,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',14599.00,NULL,NULL,1,'2022-10-31 13:07:06','2022-10-31 13:07:06',NULL);
INSERT INTO `balance_libro` VALUES (42,7985,40721,3042,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',46500.00,NULL,NULL,1,'2022-10-31 13:07:06','2022-10-31 13:07:06',NULL),(43,7985,40721,3042,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',185130.00,NULL,NULL,1,'2022-10-31 15:22:15','2022-10-31 15:22:15',NULL),(44,7985,40720,1527,15,4,'App\\Models\\PeriodLiquidation',NULL,4,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',16740.99,NULL,NULL,1,'2022-11-01 20:14:17','2022-11-01 20:58:55','2022-11-01 20:58:55'),(45,7985,40720,1527,15,43,'App\\Models\\PeriodLiquidation',NULL,43,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',16740.99,NULL,NULL,1,'2022-11-01 21:09:40','2022-11-01 21:09:40',NULL),(46,7985,40721,3042,15,41,'App\\Models\\PeriodLiquidation',NULL,41,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',83884.59,NULL,NULL,1,'2022-11-02 17:44:15','2022-11-02 18:21:16','2022-11-02 18:21:16'),(47,7985,40721,3042,15,41,'App\\Models\\PeriodLiquidation',NULL,41,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',83884.59,NULL,NULL,1,'2022-11-02 17:44:35','2022-11-02 20:01:59','2022-11-02 20:01:59'),(48,7985,40721,3042,15,41,'App\\Models\\PeriodLiquidation',NULL,41,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',83884.59,NULL,NULL,1,'2022-11-02 18:22:00','2022-11-02 18:22:00',NULL),(49,7985,40721,3042,15,41,'App\\Models\\PeriodLiquidation',NULL,41,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',83884.59,NULL,NULL,1,'2022-11-03 13:54:37','2022-11-03 13:54:37',NULL),(50,7985,40721,3042,16,46,'App\\Models\\PeriodLiquidation',NULL,46,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5039.26,NULL,NULL,1,'2022-11-04 15:21:34','2022-11-04 15:21:34',NULL),(51,7985,40763,28695,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1650.94,NULL,NULL,1,'2022-11-04 15:48:06','2022-11-04 15:48:06',NULL),(52,7985,40763,28695,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',4445.00,NULL,NULL,1,'2022-11-04 15:48:06','2022-11-04 15:48:06',NULL),(53,7985,40763,28695,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',3515.03,NULL,NULL,1,'2022-11-04 15:48:06','2022-11-04 15:48:06',NULL),(54,7985,40763,28695,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',188845.61,NULL,NULL,1,'2022-11-04 15:48:06','2022-11-04 15:48:06',NULL),(55,7985,40763,28695,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',71481.96,NULL,NULL,1,'2022-11-04 15:53:45','2022-11-04 15:53:45',NULL),(56,7985,40763,28695,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',16001.05,NULL,NULL,1,'2022-11-04 15:53:45','2022-11-04 15:53:45',NULL),(57,7985,40763,28695,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',49605.65,NULL,NULL,1,'2022-11-04 15:53:45','2022-11-04 15:53:45',NULL),(58,7985,40763,28695,15,51,'App\\Models\\PeriodLiquidation',NULL,51,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',33384.90,NULL,NULL,1,'2022-11-05 15:21:43','2022-11-06 18:10:43','2022-11-06 18:10:43'),(59,7985,40763,28695,15,51,'App\\Models\\PeriodLiquidation',NULL,51,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',33384.90,NULL,NULL,1,'2022-11-06 18:13:58','2022-11-07 08:52:50','2022-11-07 08:52:50'),(65,7985,40767,31698,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22223.68,NULL,NULL,1,'2022-11-07 12:19:22','2022-11-07 15:21:58','2022-11-07 15:21:58'),(66,7985,40767,31698,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5753.68,NULL,NULL,1,'2022-11-07 12:19:22','2022-11-07 15:21:58','2022-11-07 15:21:58');
INSERT INTO `balance_libro` VALUES (67,7985,40767,31698,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',33383.09,NULL,NULL,1,'2022-11-07 12:19:22','2022-11-07 15:21:58','2022-11-07 15:21:58'),(68,7985,40767,31698,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1109.55,NULL,NULL,1,'2022-11-07 12:19:22','2022-11-07 15:21:58','2022-11-07 15:21:58'),(69,7985,40767,31698,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6502.37,NULL,NULL,1,'2022-11-07 12:19:22','2022-11-07 15:21:58','2022-11-07 15:21:58'),(70,7985,40767,31698,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5341.29,NULL,NULL,1,'2022-11-07 12:19:22','2022-11-07 15:21:58','2022-11-07 15:21:58'),(71,7985,40767,31698,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',28320.00,NULL,NULL,1,'2022-11-07 12:19:22','2022-11-07 15:21:58','2022-11-07 15:21:58'),(72,7985,40767,31698,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13800.00,NULL,NULL,1,'2022-11-07 12:19:22','2022-11-07 15:21:58','2022-11-07 15:21:58'),(73,7985,40767,31698,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15445.45,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(74,7985,40767,31698,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2536.10,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(75,7985,40767,31698,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',33611.34,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(76,7985,40767,31698,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',15450.07,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(77,7985,40767,31698,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7984.25,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(78,7985,40767,31698,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',93794.16,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(79,7985,40767,31698,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12305.41,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(80,7985,40767,31698,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',457.97,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(81,7985,40767,31698,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9143.07,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(82,7985,40767,31698,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(83,7985,40767,31698,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(84,7985,40767,31698,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',36550.00,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58'),(85,7985,40767,31698,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2605.32,NULL,NULL,1,'2022-11-07 12:19:23','2022-11-07 15:21:58','2022-11-07 15:21:58');
INSERT INTO `balance_libro` VALUES (86,7985,40767,31698,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',43999.96,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:58','2022-11-07 15:21:58'),(87,7985,40767,31698,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2254.01,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:58','2022-11-07 15:21:58'),(88,7985,40767,31698,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',8207.92,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:58','2022-11-07 15:21:58'),(89,7985,40767,31698,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9309.76,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:58','2022-11-07 15:21:58'),(90,7985,40767,31698,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',17732.47,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:58','2022-11-07 15:21:58'),(91,7985,40767,31698,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',92230.17,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:59','2022-11-07 15:21:59'),(92,7985,40767,31698,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',125254.93,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:59','2022-11-07 15:21:59'),(93,7985,40767,31698,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',14799.11,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:59','2022-11-07 15:21:59'),(94,7985,40767,31698,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',34243.98,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:59','2022-11-07 15:21:59'),(95,7985,40767,31698,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',18428.42,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:59','2022-11-07 15:21:59'),(96,7985,40767,31698,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',80074.57,NULL,NULL,1,'2022-11-07 12:19:24','2022-11-07 15:21:59','2022-11-07 15:21:59'),(97,7985,40767,31698,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',20642.24,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(98,7985,40767,31698,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5968.46,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(99,7985,40767,31698,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',16001.05,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(100,7985,40767,31698,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1629.49,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(101,7985,40767,31698,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',401.94,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(102,7985,40767,31698,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1006.60,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(103,7985,40767,31698,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',339.77,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(104,7985,40767,31698,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6253.28,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59');
INSERT INTO `balance_libro` VALUES (105,7985,40767,31698,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4486.32,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(106,7985,40767,31698,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3050.81,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(107,7985,40767,31698,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6788.46,NULL,NULL,1,'2022-11-07 12:19:25','2022-11-07 15:21:59','2022-11-07 15:21:59'),(108,7985,40767,31698,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3813.25,NULL,NULL,1,'2022-11-07 12:19:26','2022-11-07 15:21:59','2022-11-07 15:21:59'),(109,7985,40767,31698,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1600.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(110,7985,40767,31698,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2770.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(111,7985,40767,31698,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',350.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(112,7985,40767,31698,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',3885.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(113,7985,40767,31698,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',5938.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(114,7985,40767,31698,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2740.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(115,7985,40767,31698,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',310.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(116,7985,40767,31698,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',7728.02,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(117,7985,40767,31698,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',916.42,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(118,7985,40767,31698,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1410.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(119,7985,40767,31698,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',11900.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(120,7985,40767,31698,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',720.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(121,7985,40767,31698,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5187.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(122,7985,40767,31698,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7610.03,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(123,7985,40767,31698,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',14819.66,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41');
INSERT INTO `balance_libro` VALUES (124,7985,40767,31698,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7998.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(125,7985,40767,31698,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5360.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(126,7985,40767,31698,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1520.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(127,7985,40767,31698,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2845.00,NULL,NULL,1,'2022-11-07 12:20:21','2022-11-07 15:21:41','2022-11-07 15:21:41'),(128,7985,40767,31698,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2050.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(129,7985,40767,31698,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7960.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(130,7985,40767,31698,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',240.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(131,7985,40767,31698,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',3329.04,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(132,7985,40767,31698,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',11673.46,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(133,7985,40767,31698,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',220.10,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(134,7985,40767,31698,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2290.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(135,7985,40767,31698,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2412.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(136,7985,40767,31698,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1040.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(137,7985,40767,31698,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2380.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(138,7985,40767,31698,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1300.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(139,7985,40767,31698,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',300.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(140,7985,40767,31698,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',770.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(141,7985,40767,31698,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3281.55,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(142,7985,40767,31698,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3755.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41');
INSERT INTO `balance_libro` VALUES (143,7985,40767,31698,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2670.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(144,7985,40767,31698,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2330.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(145,7985,40767,31698,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2420.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(146,7985,40767,31698,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2715.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(147,7985,40767,31698,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1368.99,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(148,7985,40767,31698,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',700.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(149,7985,40767,31698,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2200.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(150,7985,40767,31698,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',980.00,NULL,NULL,1,'2022-11-07 12:20:22','2022-11-07 15:21:41','2022-11-07 15:21:41'),(151,7985,40767,31698,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2000.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:41','2022-11-07 15:21:41'),(152,7985,40767,31698,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',3926.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(153,7985,40767,31698,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',620.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(154,7985,40767,31698,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2250.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(155,7985,40767,31698,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2620.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(156,7985,40767,31698,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',3038.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(157,7985,40767,31698,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',660.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(158,7985,40767,31698,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',13715.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(159,7985,40767,31698,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',13740.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(160,7985,40767,31698,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1750.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(161,7985,40767,31698,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',4900.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42');
INSERT INTO `balance_libro` VALUES (162,7985,40767,31698,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',970.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(163,7985,40767,31698,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',4650.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(164,7985,40767,31698,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2113.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(165,7985,40767,31698,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1180.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(166,7985,40767,31698,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',3680.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(167,7985,40767,31698,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2180.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(168,7985,40767,31698,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2240.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(169,7985,40767,31698,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1200.01,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(170,7985,40767,31698,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',6700.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(171,7985,40767,31698,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1380.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(172,7985,40767,31698,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1560.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(173,7985,40767,31698,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',3250.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(174,7985,40767,31698,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1990.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(175,7985,40767,31698,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1500.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(176,7985,40767,31698,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1300.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(177,7985,40767,31698,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',660.00,NULL,NULL,1,'2022-11-07 12:20:23','2022-11-07 15:21:42','2022-11-07 15:21:42'),(178,7985,40767,31698,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1870.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(179,7985,40767,31698,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1120.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(180,7985,40767,31698,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1740.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42');
INSERT INTO `balance_libro` VALUES (181,7985,40767,31698,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',56760.67,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(182,7985,40767,31698,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',10141.07,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(183,7985,40767,31698,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',866.23,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(184,7985,40767,31698,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',755.19,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(185,7985,40767,31698,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4320.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(186,7985,40767,31698,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',530.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(187,7985,40767,31698,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3220.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(188,7985,40767,31698,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(189,7985,40767,31698,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1520.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(190,7985,40767,31698,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1080.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(191,7985,40767,31698,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',951.80,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(192,7985,40767,31698,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',14430.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(193,7985,40767,31698,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1120.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(194,7985,40767,31698,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',6550.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(195,7985,40767,31698,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',975.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(196,7985,40767,31698,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1714.90,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(197,7985,40767,31698,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',3367.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(198,7985,40767,31698,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2400.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(199,7985,40767,31698,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',275.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42');
INSERT INTO `balance_libro` VALUES (200,7985,40767,31698,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',7790.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(201,7985,40767,31698,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4780.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(202,7985,40767,31698,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',540.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(203,7985,40767,31698,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2400.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(204,7985,40767,31698,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3270.00,NULL,NULL,1,'2022-11-07 12:20:24','2022-11-07 15:21:42','2022-11-07 15:21:42'),(205,7985,40767,31698,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',14600.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(206,7985,40767,31698,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1020.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(207,7985,40767,31698,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1690.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(208,7985,40767,31698,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',830.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(209,7985,40767,31698,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3220.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(210,7985,40767,31698,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',5200.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(211,7985,40767,31698,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4710.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(212,7985,40767,31698,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2010.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(213,7985,40767,31698,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',21210.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(214,7985,40767,31698,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1290.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(215,7985,40767,31698,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2494.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(216,7985,40767,31698,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2650.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(217,7985,40767,31698,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',37001.20,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42'),(218,7985,40767,31698,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',8010.05,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:42','2022-11-07 15:21:42');
INSERT INTO `balance_libro` VALUES (219,7985,40767,31698,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5448.65,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(220,7985,40767,31698,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2377.12,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(221,7985,40767,31698,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',37001.20,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(222,7985,40767,31698,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',480.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(223,7985,40767,31698,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4400.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(224,7985,40767,31698,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4800.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(225,7985,40767,31698,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',590.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(226,7985,40767,31698,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5000.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(227,7985,40767,31698,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3210.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(228,7985,40767,31698,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3860.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(229,7985,40767,31698,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',980.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(230,7985,40767,31698,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',480.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(231,7985,40767,31698,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2930.00,NULL,NULL,1,'2022-11-07 12:20:25','2022-11-07 15:21:43','2022-11-07 15:21:43'),(232,7985,40767,31698,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2460.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(233,7985,40767,31698,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1420.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(234,7985,40767,31698,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3240.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(235,7985,40767,31698,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',940.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(236,7985,40767,31698,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',12223.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(237,7985,40767,31698,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3670.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43');
INSERT INTO `balance_libro` VALUES (238,7985,40767,31698,2,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2480.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(239,7985,40767,31698,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1850.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(240,7985,40767,31698,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',8380.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(241,7985,40767,31698,2,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',7600.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(242,7985,40767,31698,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',12540.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(243,7985,40767,31698,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',670.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(244,7985,40767,31698,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1845.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(245,7985,40767,31698,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',700.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(246,7985,40767,31698,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',850.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(247,7985,40767,31698,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',5100.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(248,7985,40767,31698,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',200.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(249,7985,40767,31698,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',5420.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(250,7985,40767,31698,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1150.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(251,7985,40767,31698,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',490.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(252,7985,40767,31698,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',400.00,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(253,7985,40767,31698,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',125.01,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(254,7985,40767,31698,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',15550.01,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(255,7985,40767,31698,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',11315.76,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(256,7985,40767,31698,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2885.60,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43');
INSERT INTO `balance_libro` VALUES (257,7985,40767,31698,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',10749.36,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(258,7985,40767,31698,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',4800.01,NULL,NULL,1,'2022-11-07 12:20:26','2022-11-07 15:21:43','2022-11-07 15:21:43'),(259,7985,40767,31698,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2350.01,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:43','2022-11-07 15:21:43'),(260,7985,40767,31698,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',6000.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:43','2022-11-07 15:21:43'),(261,7985,40767,31698,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1050.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:43','2022-11-07 15:21:43'),(262,7985,40767,31698,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',700.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(263,7985,40767,31698,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',330.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(264,7985,40767,31698,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2650.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(265,7985,40767,31698,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1759.99,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(266,7985,40767,31698,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',7844.63,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(267,7985,40767,31698,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1440.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(268,7985,40767,31698,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3270.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(269,7985,40767,31698,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4250.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(270,7985,40767,31698,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6800.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(271,7985,40767,31698,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2818.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(272,7985,40767,31698,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3460.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(273,7985,40767,31698,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4684.02,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(274,7985,40767,31698,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',960.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(275,7985,40767,31698,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',840.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44');
INSERT INTO `balance_libro` VALUES (276,7985,40767,31698,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',700.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(277,7985,40767,31698,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4530.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(278,7985,40767,31698,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',580.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(279,7985,40767,31698,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2860.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(280,7985,40767,31698,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3010.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(281,7985,40767,31698,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',900.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(282,7985,40767,31698,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2240.00,NULL,NULL,1,'2022-11-07 12:20:27','2022-11-07 15:21:44','2022-11-07 15:21:44'),(283,7985,40767,31698,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',7340.86,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(284,7985,40767,31698,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',25266.90,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(285,7985,40767,31698,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3290.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(286,7985,40767,31698,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2360.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(287,7985,40767,31698,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2470.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(288,7985,40767,31698,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',480.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(289,7985,40767,31698,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2080.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(290,7985,40767,31698,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',10750.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(291,7985,40767,31698,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2041.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(292,7985,40767,31698,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1310.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(293,7985,40767,31698,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',600.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(294,7985,40767,31698,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',850.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44');
INSERT INTO `balance_libro` VALUES (295,7985,40767,31698,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1010.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(296,7985,40767,31698,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',5250.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(297,7985,40767,31698,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2060.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(298,7985,40767,31698,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',5350.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(299,7985,40767,31698,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',340.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(300,7985,40767,31698,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2440.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(301,7985,40767,31698,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1135.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(302,7985,40767,31698,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2500.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(303,7985,40767,31698,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',700.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(304,7985,40767,31698,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',15080.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(305,7985,40767,31698,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',700.00,NULL,NULL,1,'2022-11-07 12:20:28','2022-11-07 15:21:44','2022-11-07 15:21:44'),(306,7985,40767,31698,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',700.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44'),(307,7985,40767,31698,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1765.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44'),(308,7985,40767,31698,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3382.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44'),(309,7985,40767,31698,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',4310.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44'),(310,7985,40767,31698,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',13590.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44'),(311,7985,40767,31698,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6431.50,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44'),(312,7985,40767,31698,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3059.42,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44'),(313,7985,40767,31698,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',382.55,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44');
INSERT INTO `balance_libro` VALUES (314,7985,40767,31698,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',623.85,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44'),(315,7985,40767,31698,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',19774.47,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:44','2022-11-07 15:21:44'),(316,7985,40767,31698,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',68355.55,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(317,7985,40767,31698,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3880.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(318,7985,40767,31698,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4498.70,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(319,7985,40767,31698,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',15100.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(320,7985,40767,31698,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1930.03,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(321,7985,40767,31698,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1600.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(322,7985,40767,31698,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4390.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(323,7985,40767,31698,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2160.50,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(324,7985,40767,31698,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',17800.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(325,7985,40767,31698,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',480.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(326,7985,40767,31698,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1340.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(327,7985,40767,31698,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1150.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(328,7985,40767,31698,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1070.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(329,7985,40767,31698,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2010.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(330,7985,40767,31698,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',980.00,NULL,NULL,1,'2022-11-07 12:20:29','2022-11-07 15:21:45','2022-11-07 15:21:45'),(342,7985,40767,31698,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1109.55,NULL,NULL,1,'2022-11-07 15:50:04','2022-11-09 10:20:15','2022-11-09 10:20:15'),(343,7985,40767,31698,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6502.37,NULL,NULL,1,'2022-11-07 15:50:04','2022-11-09 10:20:15','2022-11-09 10:20:15');
INSERT INTO `balance_libro` VALUES (344,7985,40767,31698,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',33383.09,NULL,NULL,1,'2022-11-07 15:50:04','2022-11-09 10:20:15','2022-11-09 10:20:15'),(345,7985,40767,31698,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22223.68,NULL,NULL,1,'2022-11-07 15:50:04','2022-11-09 10:20:15','2022-11-09 10:20:15'),(346,7985,40767,31698,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5753.68,NULL,NULL,1,'2022-11-07 15:50:04','2022-11-09 10:20:16','2022-11-09 10:20:16'),(347,7985,40767,31698,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13800.00,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(348,7985,40767,31698,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',33611.34,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(349,7985,40767,31698,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15445.45,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(350,7985,40767,31698,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',28320.00,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(351,7985,40767,31698,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2536.10,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(352,7985,40767,31698,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5341.29,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(353,7985,40767,31698,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',15450.07,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(354,7985,40767,31698,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7984.29,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(355,7985,40767,31698,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',93794.16,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(356,7985,40767,31698,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12305.41,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(357,7985,40767,31698,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',457.97,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(358,7985,40767,31698,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9143.07,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(359,7985,40767,31698,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(360,7985,40767,31698,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',36550.00,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(361,7985,40767,31698,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(362,7985,40767,31698,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2605.32,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16');
INSERT INTO `balance_libro` VALUES (363,7985,40767,31698,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',43999.96,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(364,7985,40767,31698,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2254.01,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(365,7985,40767,31698,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',8207.94,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(366,7985,40767,31698,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',17732.47,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(367,7985,40767,31698,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9309.76,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(368,7985,40767,31698,3,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',125254.93,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(369,7985,40767,31698,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',92230.17,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(370,7985,40767,31698,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',34243.98,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(371,7985,40767,31698,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',14799.11,NULL,NULL,1,'2022-11-07 15:50:05','2022-11-09 10:20:16','2022-11-09 10:20:16'),(372,7985,40767,31698,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',20642.24,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16'),(373,7985,40767,31698,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',18428.42,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16'),(374,7985,40767,31698,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',80074.57,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16'),(375,7985,40767,31698,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5968.46,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16'),(376,7985,40767,31698,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',16001.15,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16'),(377,7985,40767,31698,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1629.49,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16'),(378,7985,40767,31698,3,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',401.94,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16'),(379,7985,40767,31698,3,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1006.60,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16'),(380,7985,40767,31698,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',339.77,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16'),(381,7985,40767,31698,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6788.46,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:16','2022-11-09 10:20:16');
INSERT INTO `balance_libro` VALUES (382,7985,40767,31698,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6253.28,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:17','2022-11-09 10:20:17'),(383,7985,40767,31698,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3050.81,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:17','2022-11-09 10:20:17'),(384,7985,40767,31698,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4486.32,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:17','2022-11-09 10:20:17'),(385,7985,40767,31698,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3813.25,NULL,NULL,1,'2022-11-07 15:50:06','2022-11-09 10:20:17','2022-11-09 10:20:17'),(574,7985,40767,31698,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2770.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(575,7985,40767,31698,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',350.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(576,7985,40767,31698,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',3885.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(577,7985,40767,31698,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',5938.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(578,7985,40767,31698,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2740.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(579,7985,40767,31698,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',310.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(580,7985,40767,31698,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1600.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(581,7985,40767,31698,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',11900.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(582,7985,40767,31698,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',720.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(583,7985,40767,31698,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5187.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(584,7985,40767,31698,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',7728.02,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(585,7985,40767,31698,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',916.42,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(586,7985,40767,31698,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1410.00,NULL,NULL,1,'2022-11-09 10:49:32','2022-11-09 10:49:32',NULL),(587,7985,40767,31698,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7998.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(588,7985,40767,31698,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5360.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(589,7985,40767,31698,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1520.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(590,7985,40767,31698,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2845.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL);
INSERT INTO `balance_libro` VALUES (591,7985,40767,31698,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2050.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(592,7985,40767,31698,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7960.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(593,7985,40767,31698,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',240.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(594,7985,40767,31698,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7610.03,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(595,7985,40767,31698,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',14819.66,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(596,7985,40767,31698,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',3329.04,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(597,7985,40767,31698,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',11673.46,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(598,7985,40767,31698,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',220.10,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(599,7985,40767,31698,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2290.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(600,7985,40767,31698,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2412.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(601,7985,40767,31698,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1040.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(602,7985,40767,31698,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2380.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(603,7985,40767,31698,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1300.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(604,7985,40767,31698,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',300.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(605,7985,40767,31698,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',770.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(606,7985,40767,31698,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3281.55,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(607,7985,40767,31698,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3755.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(608,7985,40767,31698,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2670.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(609,7985,40767,31698,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2330.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(610,7985,40767,31698,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2420.00,NULL,NULL,1,'2022-11-09 10:49:33','2022-11-09 10:49:33',NULL),(611,7985,40767,31698,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2715.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL);
INSERT INTO `balance_libro` VALUES (612,7985,40767,31698,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',700.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(613,7985,40767,31698,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2200.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(614,7985,40767,31698,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',980.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(615,7985,40767,31698,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2000.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(616,7985,40767,31698,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',3926.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(617,7985,40767,31698,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',620.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(618,7985,40767,31698,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2250.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(619,7985,40767,31698,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2620.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(620,7985,40767,31698,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',3038.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(621,7985,40767,31698,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',660.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(622,7985,40767,31698,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',13715.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(623,7985,40767,31698,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',13740.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(624,7985,40767,31698,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1750.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(625,7985,40767,31698,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',4900.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(626,7985,40767,31698,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',970.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(627,7985,40767,31698,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',4650.00,NULL,NULL,1,'2022-11-09 10:49:34','2022-11-09 10:49:34',NULL),(628,7985,40767,31698,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2113.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(629,7985,40767,31698,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1180.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(630,7985,40767,31698,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',3680.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(631,7985,40767,31698,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2180.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(632,7985,40767,31698,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2240.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL);
INSERT INTO `balance_libro` VALUES (633,7985,40767,31698,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1368.99,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(634,7985,40767,31698,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1380.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(635,7985,40767,31698,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1560.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(636,7985,40767,31698,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',3250.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(637,7985,40767,31698,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1990.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(638,7985,40767,31698,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1500.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(639,7985,40767,31698,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1300.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(640,7985,40767,31698,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',660.00,NULL,NULL,1,'2022-11-09 10:49:35','2022-11-09 10:49:35',NULL),(641,7985,40767,31698,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1870.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(642,7985,40767,31698,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1120.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(643,7985,40767,31698,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1740.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(644,7985,40767,31698,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1200.01,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(645,7985,40767,31698,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',6700.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(646,7985,40767,31698,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',56760.67,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(647,7985,40767,31698,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',10141.07,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(648,7985,40767,31698,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',866.23,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(649,7985,40767,31698,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',755.19,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(650,7985,40767,31698,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4320.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(651,7985,40767,31698,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',530.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(652,7985,40767,31698,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3220.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(653,7985,40767,31698,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL);
INSERT INTO `balance_libro` VALUES (654,7985,40767,31698,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1520.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(655,7985,40767,31698,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1080.00,NULL,NULL,1,'2022-11-09 10:49:36','2022-11-09 10:49:36',NULL),(656,7985,40767,31698,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',951.80,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(657,7985,40767,31698,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',14430.00,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(658,7985,40767,31698,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1120.00,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(659,7985,40767,31698,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',6550.00,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(660,7985,40767,31698,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',975.00,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(661,7985,40767,31698,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',3367.00,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(662,7985,40767,31698,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2400.00,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(663,7985,40767,31698,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',275.00,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(664,7985,40767,31698,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1714.90,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(665,7985,40767,31698,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',540.00,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(666,7985,40767,31698,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2400.00,NULL,NULL,1,'2022-11-09 10:49:37','2022-11-09 10:49:37',NULL),(667,7985,40767,31698,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3270.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(668,7985,40767,31698,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',14600.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(669,7985,40767,31698,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1020.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(670,7985,40767,31698,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1690.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(671,7985,40767,31698,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',830.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(672,7985,40767,31698,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3220.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(673,7985,40767,31698,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',5200.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(674,7985,40767,31698,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4710.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL);
INSERT INTO `balance_libro` VALUES (675,7985,40767,31698,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2010.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(676,7985,40767,31698,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',21210.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(677,7985,40767,31698,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1290.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(678,7985,40767,31698,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2494.00,NULL,NULL,1,'2022-11-09 10:49:38','2022-11-09 10:49:38',NULL),(679,7985,40767,31698,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2650.00,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(680,7985,40767,31698,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',7790.00,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(681,7985,40767,31698,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4780.00,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(682,7985,40767,31698,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',37001.20,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(683,7985,40767,31698,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',8010.05,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(684,7985,40767,31698,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5448.65,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(685,7985,40767,31698,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2377.12,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(686,7985,40767,31698,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',37001.20,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(687,7985,40767,31698,2,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',480.00,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(688,7985,40767,31698,2,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4400.00,NULL,NULL,1,'2022-11-09 10:49:39','2022-11-09 10:49:39',NULL),(689,7985,40767,31698,2,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4800.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(690,7985,40767,31698,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',590.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(691,7985,40767,31698,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5000.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(692,7985,40767,31698,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3210.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(693,7985,40767,31698,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3860.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(694,7985,40767,31698,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',980.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(695,7985,40767,31698,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',480.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL);
INSERT INTO `balance_libro` VALUES (696,7985,40767,31698,2,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2930.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(697,7985,40767,31698,2,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2460.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(698,7985,40767,31698,2,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1420.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(699,7985,40767,31698,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3240.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(700,7985,40767,31698,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',940.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(701,7985,40767,31698,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',12223.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(702,7985,40767,31698,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3670.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(703,7985,40767,31698,2,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2480.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(704,7985,40767,31698,2,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1850.00,NULL,NULL,1,'2022-11-09 10:49:40','2022-11-09 10:49:40',NULL),(705,7985,40767,31698,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',8380.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(706,7985,40767,31698,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',7600.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(707,7985,40767,31698,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',12540.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(708,7985,40767,31698,2,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',670.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(709,7985,40767,31698,2,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1845.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(710,7985,40767,31698,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',700.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(711,7985,40767,31698,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',850.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(712,7985,40767,31698,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',5100.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(713,7985,40767,31698,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',200.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(714,7985,40767,31698,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',5420.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(715,7985,40767,31698,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1150.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(716,7985,40767,31698,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',490.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL);
INSERT INTO `balance_libro` VALUES (717,7985,40767,31698,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',400.00,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(718,7985,40767,31698,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',125.01,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(719,7985,40767,31698,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',15550.01,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(720,7985,40767,31698,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',11315.76,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(721,7985,40767,31698,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2885.60,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(722,7985,40767,31698,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',10749.36,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(723,7985,40767,31698,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',4800.01,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(724,7985,40767,31698,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2350.01,NULL,NULL,1,'2022-11-09 10:49:41','2022-11-09 10:49:41',NULL),(725,7985,40767,31698,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',6000.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(726,7985,40767,31698,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1050.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(727,7985,40767,31698,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',700.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(728,7985,40767,31698,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',330.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(729,7985,40767,31698,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2650.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(730,7985,40767,31698,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1759.99,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(731,7985,40767,31698,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',7844.63,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(732,7985,40767,31698,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1440.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(733,7985,40767,31698,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3270.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(734,7985,40767,31698,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4250.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(735,7985,40767,31698,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6800.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(736,7985,40767,31698,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2818.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(737,7985,40767,31698,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3460.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL);
INSERT INTO `balance_libro` VALUES (738,7985,40767,31698,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4684.02,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(739,7985,40767,31698,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',960.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(740,7985,40767,31698,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',840.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(741,7985,40767,31698,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',700.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(742,7985,40767,31698,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4530.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(743,7985,40767,31698,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',580.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(744,7985,40767,31698,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2860.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(745,7985,40767,31698,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3010.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(746,7985,40767,31698,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',900.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(747,7985,40767,31698,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2240.00,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(748,7985,40767,31698,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',7340.86,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(749,7985,40767,31698,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',25266.90,NULL,NULL,1,'2022-11-09 10:49:42','2022-11-09 10:49:42',NULL),(750,7985,40767,31698,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3290.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(751,7985,40767,31698,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2360.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(752,7985,40767,31698,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2470.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(753,7985,40767,31698,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',480.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(754,7985,40767,31698,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2080.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(755,7985,40767,31698,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',10750.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(756,7985,40767,31698,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2041.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(757,7985,40767,31698,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1310.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(758,7985,40767,31698,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',600.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL);
INSERT INTO `balance_libro` VALUES (759,7985,40767,31698,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',850.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(760,7985,40767,31698,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1010.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(761,7985,40767,31698,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',5250.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(762,7985,40767,31698,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2060.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(763,7985,40767,31698,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',5350.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(764,7985,40767,31698,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',340.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(765,7985,40767,31698,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2440.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(766,7985,40767,31698,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1135.00,NULL,NULL,1,'2022-11-09 10:49:43','2022-11-09 10:49:43',NULL),(767,7985,40767,31698,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2500.00,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(768,7985,40767,31698,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',700.00,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(769,7985,40767,31698,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',15080.00,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(770,7985,40767,31698,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',700.00,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(771,7985,40767,31698,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',700.00,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(772,7985,40767,31698,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1765.00,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(773,7985,40767,31698,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3382.00,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(774,7985,40767,31698,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',4310.00,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(775,7985,40767,31698,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',13590.00,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(776,7985,40767,31698,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6431.50,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(777,7985,40767,31698,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3059.42,NULL,NULL,1,'2022-11-09 10:49:44','2022-11-09 10:49:44',NULL),(778,7985,40767,31698,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',382.55,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(779,7985,40767,31698,2,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',623.85,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL);
INSERT INTO `balance_libro` VALUES (780,7985,40767,31698,2,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',19774.47,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(781,7985,40767,31698,2,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',68355.55,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(782,7985,40767,31698,2,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3880.00,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(783,7985,40767,31698,2,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4498.70,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(784,7985,40767,31698,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',15100.00,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(785,7985,40767,31698,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1930.03,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(786,7985,40767,31698,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1600.00,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(787,7985,40767,31698,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4390.00,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(788,7985,40767,31698,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2160.50,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(789,7985,40767,31698,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',17800.00,NULL,NULL,1,'2022-11-09 10:49:45','2022-11-09 10:49:45',NULL),(790,7985,40767,31698,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',480.00,NULL,NULL,1,'2022-11-09 10:49:46','2022-11-09 10:49:46',NULL),(791,7985,40767,31698,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1340.00,NULL,NULL,1,'2022-11-09 10:49:46','2022-11-09 10:49:46',NULL),(792,7985,40767,31698,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1150.00,NULL,NULL,1,'2022-11-09 10:49:46','2022-11-09 10:49:46',NULL),(793,7985,40767,31698,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1070.00,NULL,NULL,1,'2022-11-09 10:49:46','2022-11-09 10:49:46',NULL),(794,7985,40767,31698,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2010.00,NULL,NULL,1,'2022-11-09 10:49:46','2022-11-09 10:49:46',NULL),(795,7985,40767,31698,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',980.00,NULL,NULL,1,'2022-11-09 10:49:46','2022-11-09 10:49:46',NULL),(796,7985,40767,31698,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22223.68,NULL,NULL,1,'2022-11-09 11:02:42','2022-11-09 11:10:26','2022-11-09 11:10:26'),(797,7985,40767,31698,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5753.68,NULL,NULL,1,'2022-11-09 11:02:42','2022-11-09 11:10:26','2022-11-09 11:10:26'),(798,7985,40767,31698,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',33383.09,NULL,NULL,1,'2022-11-09 11:02:42','2022-11-09 11:10:26','2022-11-09 11:10:26'),(799,7985,40767,31698,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1109.55,NULL,NULL,1,'2022-11-09 11:02:42','2022-11-09 11:10:26','2022-11-09 11:10:26');
INSERT INTO `balance_libro` VALUES (800,7985,40767,31698,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6502.37,NULL,NULL,1,'2022-11-09 11:02:42','2022-11-09 11:10:26','2022-11-09 11:10:26'),(801,7985,40767,31698,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5341.29,NULL,NULL,1,'2022-11-09 11:02:42','2022-11-09 11:10:26','2022-11-09 11:10:26'),(802,7985,40767,31698,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',28320.00,NULL,NULL,1,'2022-11-09 11:02:42','2022-11-09 11:10:26','2022-11-09 11:10:26'),(803,7985,40767,31698,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13800.00,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:26','2022-11-09 11:10:26'),(804,7985,40767,31698,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15445.45,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:26','2022-11-09 11:10:26'),(805,7985,40767,31698,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2536.10,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:26','2022-11-09 11:10:26'),(806,7985,40767,31698,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',33611.34,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:26','2022-11-09 11:10:26'),(807,7985,40767,31698,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',15450.07,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:26','2022-11-09 11:10:26'),(808,7985,40767,31698,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7984.25,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:27','2022-11-09 11:10:27'),(809,7985,40767,31698,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',93794.16,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:27','2022-11-09 11:10:27'),(810,7985,40767,31698,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12305.41,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:27','2022-11-09 11:10:27'),(811,7985,40767,31698,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',457.97,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:27','2022-11-09 11:10:27'),(812,7985,40767,31698,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9143.07,NULL,NULL,1,'2022-11-09 11:02:43','2022-11-09 11:10:27','2022-11-09 11:10:27'),(813,7985,40767,31698,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(814,7985,40767,31698,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(815,7985,40767,31698,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',36550.00,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(816,7985,40767,31698,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2605.32,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(817,7985,40767,31698,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',43999.96,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(818,7985,40767,31698,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2254.01,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27');
INSERT INTO `balance_libro` VALUES (819,7985,40767,31698,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',8207.92,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(820,7985,40767,31698,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9309.76,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(821,7985,40767,31698,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',17732.47,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(822,7985,40767,31698,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',34243.98,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(823,7985,40767,31698,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',92230.17,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(824,7985,40767,31698,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',125254.93,NULL,NULL,1,'2022-11-09 11:02:44','2022-11-09 11:10:27','2022-11-09 11:10:27'),(825,7985,40767,31698,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',14799.11,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(826,7985,40767,31698,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',18428.42,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(827,7985,40767,31698,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',80074.57,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(828,7985,40767,31698,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',20642.24,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(829,7985,40767,31698,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5968.46,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(830,7985,40767,31698,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',16001.05,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(831,7985,40767,31698,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1629.49,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(832,7985,40767,31698,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',401.94,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(833,7985,40767,31698,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1006.60,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(834,7985,40767,31698,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',339.77,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(835,7985,40767,31698,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6253.28,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(836,7985,40767,31698,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4486.32,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(837,7985,40767,31698,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3050.81,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27');
INSERT INTO `balance_libro` VALUES (838,7985,40767,31698,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6788.46,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(839,7985,40767,31698,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3813.25,NULL,NULL,1,'2022-11-09 11:02:45','2022-11-09 11:10:27','2022-11-09 11:10:27'),(840,7985,40767,31698,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22223.68,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(841,7985,40767,31698,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5753.68,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(842,7985,40767,31698,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',33383.09,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(843,7985,40767,31698,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1109.55,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(844,7985,40767,31698,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6502.37,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(845,7985,40767,31698,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5341.29,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(846,7985,40767,31698,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',28320.00,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(847,7985,40767,31698,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13800.00,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(848,7985,40767,31698,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15445.45,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(849,7985,40767,31698,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2536.10,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(850,7985,40767,31698,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',33611.34,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(851,7985,40767,31698,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',15450.07,NULL,NULL,1,'2022-11-09 11:11:16','2022-11-09 11:12:18','2022-11-09 11:12:18'),(852,7985,40767,31698,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7984.25,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(853,7985,40767,31698,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',93794.16,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(854,7985,40767,31698,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12305.41,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(855,7985,40767,31698,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',457.97,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(856,7985,40767,31698,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9143.07,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18');
INSERT INTO `balance_libro` VALUES (857,7985,40767,31698,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(858,7985,40767,31698,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(859,7985,40767,31698,3,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',36550.00,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(860,7985,40767,31698,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2605.32,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(861,7985,40767,31698,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',43999.96,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(862,7985,40767,31698,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2254.01,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(863,7985,40767,31698,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',8207.93,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(864,7985,40767,31698,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9309.76,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(865,7985,40767,31698,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',17732.47,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(866,7985,40767,31698,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',34243.98,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(867,7985,40767,31698,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',92230.17,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(868,7985,40767,31698,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',125254.93,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(869,7985,40767,31698,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',14799.11,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(870,7985,40767,31698,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',18428.42,NULL,NULL,1,'2022-11-09 11:11:17','2022-11-09 11:12:18','2022-11-09 11:12:18'),(871,7985,40767,31698,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',78453.63,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(872,7985,40767,31698,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',20642.24,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(873,7985,40767,31698,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5968.46,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(874,7985,40767,31698,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',16001.05,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(875,7985,40767,31698,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1629.49,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18');
INSERT INTO `balance_libro` VALUES (876,7985,40767,31698,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',401.94,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(877,7985,40767,31698,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1006.60,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(878,7985,40767,31698,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',339.77,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(879,7985,40767,31698,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6253.28,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(880,7985,40767,31698,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4486.32,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(881,7985,40767,31698,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3050.81,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(882,7985,40767,31698,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6788.46,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(883,7985,40767,31698,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3813.25,NULL,NULL,1,'2022-11-09 11:11:18','2022-11-09 11:12:18','2022-11-09 11:12:18'),(884,7985,40767,31698,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22223.68,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(885,7985,40767,31698,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5753.68,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(886,7985,40767,31698,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',33383.09,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(887,7985,40767,31698,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1109.55,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(888,7985,40767,31698,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6502.37,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(889,7985,40767,31698,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5341.29,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(890,7985,40767,31698,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',28320.00,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(891,7985,40767,31698,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13800.00,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(892,7985,40767,31698,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15445.45,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(893,7985,40767,31698,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2536.10,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(894,7985,40767,31698,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',33611.34,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09');
INSERT INTO `balance_libro` VALUES (895,7985,40767,31698,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',15450.07,NULL,NULL,1,'2022-11-09 11:29:31','2022-11-09 11:30:09','2022-11-09 11:30:09'),(896,7985,40767,31698,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7984.25,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(897,7985,40767,31698,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',93794.16,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(898,7985,40767,31698,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12305.41,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(899,7985,40767,31698,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',457.97,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(900,7985,40767,31698,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9143.07,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(901,7985,40767,31698,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(902,7985,40767,31698,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(903,7985,40767,31698,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',36550.00,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(904,7985,40767,31698,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2605.32,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(905,7985,40767,31698,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',43999.96,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(906,7985,40767,31698,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2254.01,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(907,7985,40767,31698,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',8207.93,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(908,7985,40767,31698,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9309.76,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(909,7985,40767,31698,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',17732.47,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(910,7985,40767,31698,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',34243.98,NULL,NULL,1,'2022-11-09 11:29:32','2022-11-09 11:30:09','2022-11-09 11:30:09'),(911,7985,40767,31698,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',92230.17,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(912,7985,40767,31698,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',125254.93,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(913,7985,40767,31698,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',14799.11,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09');
INSERT INTO `balance_libro` VALUES (914,7985,40767,31698,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',18428.42,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(915,7985,40767,31698,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',78453.63,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(916,7985,40767,31698,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',20642.24,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(917,7985,40767,31698,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5968.46,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(918,7985,40767,31698,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',16001.05,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(919,7985,40767,31698,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1629.49,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(920,7985,40767,31698,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',401.94,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(921,7985,40767,31698,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1006.60,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(922,7985,40767,31698,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',339.77,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(923,7985,40767,31698,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6253.28,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(924,7985,40767,31698,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4486.32,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(925,7985,40767,31698,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3050.81,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(926,7985,40767,31698,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6788.46,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(927,7985,40767,31698,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3813.25,NULL,NULL,1,'2022-11-09 11:29:33','2022-11-09 11:30:09','2022-11-09 11:30:09'),(928,7985,40767,31698,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22223.68,NULL,NULL,1,'2022-11-09 11:34:49','2022-11-09 16:50:26','2022-11-09 16:50:26'),(929,7985,40767,31698,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5753.68,NULL,NULL,1,'2022-11-09 11:34:49','2022-11-09 16:50:26','2022-11-09 16:50:26'),(930,7985,40767,31698,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',33383.09,NULL,NULL,1,'2022-11-09 11:34:49','2022-11-09 16:50:26','2022-11-09 16:50:26'),(931,7985,40767,31698,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1109.55,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(932,7985,40767,31698,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6502.37,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26');
INSERT INTO `balance_libro` VALUES (933,7985,40767,31698,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5341.29,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(934,7985,40767,31698,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',28320.00,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(935,7985,40767,31698,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13800.00,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(936,7985,40767,31698,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15445.45,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:43:08','2022-11-09 16:43:08'),(937,7985,40767,31698,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2536.10,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(938,7985,40767,31698,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',33611.34,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:39:43','2022-11-09 16:39:43'),(939,7985,40767,31698,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',15450.07,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(940,7985,40767,31698,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7984.25,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(941,7985,40767,31698,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',93794.16,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(942,7985,40767,31698,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12305.41,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(943,7985,40767,31698,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',457.97,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(944,7985,40767,31698,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9143.07,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(945,7985,40767,31698,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(946,7985,40767,31698,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:26','2022-11-09 16:50:26'),(947,7985,40767,31698,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',36550.00,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:27','2022-11-09 16:50:27'),(948,7985,40767,31698,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2605.32,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:27','2022-11-09 16:50:27'),(949,7985,40767,31698,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',43999.96,NULL,NULL,1,'2022-11-09 11:34:50','2022-11-09 16:50:27','2022-11-09 16:50:27'),(950,7985,40767,31698,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2254.01,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(951,7985,40767,31698,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',8207.92,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27');
INSERT INTO `balance_libro` VALUES (952,7985,40767,31698,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9309.76,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(953,7985,40767,31698,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',17732.47,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(954,7985,40767,31698,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',92230.17,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(955,7985,40767,31698,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',125254.93,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(956,7985,40767,31698,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',14799.11,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(957,7985,40767,31698,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',34243.98,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(958,7985,40767,31698,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',18428.42,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(959,7985,40767,31698,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',80074.57,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(960,7985,40767,31698,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',20642.24,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(961,7985,40767,31698,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5968.46,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(962,7985,40767,31698,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',16001.05,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(963,7985,40767,31698,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1629.49,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(964,7985,40767,31698,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',401.94,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(965,7985,40767,31698,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1006.60,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(966,7985,40767,31698,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',339.77,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(967,7985,40767,31698,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6253.28,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(968,7985,40767,31698,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4486.32,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(969,7985,40767,31698,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3050.81,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(970,7985,40767,31698,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6788.46,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27');
INSERT INTO `balance_libro` VALUES (971,7985,40767,31698,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3813.25,NULL,NULL,1,'2022-11-09 11:34:51','2022-11-09 16:50:27','2022-11-09 16:50:27'),(972,7985,40767,31698,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',30827.51,NULL,NULL,1,'2022-11-09 16:39:43','2022-11-09 16:50:26','2022-11-09 16:50:26'),(973,7985,40767,31698,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13885.61,NULL,NULL,1,'2022-11-09 16:43:08','2022-11-09 16:47:23','2022-11-09 16:47:23'),(974,7985,40767,31698,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',22223.68,NULL,NULL,1,'2022-11-09 17:50:39','2022-11-09 17:50:39',NULL),(975,7985,40767,31698,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5753.68,NULL,NULL,1,'2022-11-09 17:50:39','2022-11-09 17:50:39',NULL),(976,7985,40767,31698,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',33383.09,NULL,NULL,1,'2022-11-09 17:50:39','2022-11-09 17:50:39',NULL),(977,7985,40767,31698,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1109.55,NULL,NULL,1,'2022-11-09 17:50:39','2022-11-09 17:50:39',NULL),(978,7985,40767,31698,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6502.37,NULL,NULL,1,'2022-11-09 17:50:39','2022-11-09 17:50:39',NULL),(979,7985,40767,31698,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5341.29,NULL,NULL,1,'2022-11-09 17:50:39','2022-11-09 17:50:39',NULL),(980,7985,40767,31698,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',28320.00,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(981,7985,40767,31698,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13800.00,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(982,7985,40767,31698,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15445.45,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(983,7985,40767,31698,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2536.10,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(984,7985,40767,31698,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',33611.34,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(985,7985,40767,31698,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',15450.07,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(986,7985,40767,31698,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7984.25,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(987,7985,40767,31698,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',93794.16,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(988,7985,40767,31698,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12305.41,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(989,7985,40767,31698,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',457.97,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(990,7985,40767,31698,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9143.07,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(991,7985,40767,31698,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL);
INSERT INTO `balance_libro` VALUES (992,7985,40767,31698,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',31075.22,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(993,7985,40767,31698,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',36550.00,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(994,7985,40767,31698,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2605.32,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(995,7985,40767,31698,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',43999.96,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(996,7985,40767,31698,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2254.01,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(997,7985,40767,31698,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',8207.92,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(998,7985,40767,31698,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9309.76,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(999,7985,40767,31698,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',17732.47,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(1000,7985,40767,31698,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',92230.17,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(1001,7985,40767,31698,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',125254.93,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(1002,7985,40767,31698,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',14799.11,NULL,NULL,1,'2022-11-09 17:50:40','2022-11-09 17:50:40',NULL),(1003,7985,40767,31698,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',34243.98,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1004,7985,40767,31698,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',18428.42,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1005,7985,40767,31698,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',80074.57,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1006,7985,40767,31698,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',20642.24,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1007,7985,40767,31698,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5968.46,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1008,7985,40767,31698,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',16001.05,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1009,7985,40767,31698,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1629.49,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1010,7985,40767,31698,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',401.94,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1011,7985,40767,31698,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1006.60,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1012,7985,40767,31698,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',339.77,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL);
INSERT INTO `balance_libro` VALUES (1013,7985,40767,31698,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6253.28,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1014,7985,40767,31698,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4486.32,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1015,7985,40767,31698,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3050.81,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1016,7985,40767,31698,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6788.46,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1017,7985,40767,31698,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3813.25,NULL,NULL,1,'2022-11-09 17:50:41','2022-11-09 17:50:41',NULL),(1018,7985,40767,31698,7,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',625.86,NULL,NULL,1,'2022-11-10 13:58:29','2022-11-10 13:58:29',NULL),(1019,7985,40763,28695,16,52,'App\\Models\\PeriodLiquidation',NULL,52,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',33.85,NULL,NULL,1,'2022-11-10 17:08:00','2022-11-10 17:08:00',NULL),(1020,7985,40763,28695,15,51,'App\\Models\\PeriodLiquidation',NULL,51,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',33384.90,NULL,NULL,1,'2022-11-10 17:08:23','2022-11-10 17:08:23',NULL),(1021,7985,41102,40781,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',11300.00,NULL,NULL,1,'2022-11-11 11:23:01','2022-11-11 11:23:01',NULL),(1022,7985,41102,40781,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',13320.00,NULL,NULL,1,'2022-11-11 11:23:01','2022-11-11 11:23:01',NULL),(1023,7985,41102,40781,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',29660.00,NULL,NULL,1,'2022-11-11 11:23:01','2022-11-11 11:23:01',NULL),(1024,7985,41102,40781,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',28600.00,NULL,NULL,1,'2022-11-11 11:23:01','2022-11-11 11:23:01',NULL),(1025,7985,41102,40781,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',23700.00,NULL,NULL,1,'2022-11-11 11:23:01','2022-11-11 11:23:01',NULL),(1026,7985,41102,40781,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',33960.00,NULL,NULL,1,'2022-11-11 11:23:01','2022-11-11 11:23:01',NULL),(1027,7985,41102,40781,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',26882.19,NULL,NULL,1,'2022-11-11 11:30:02','2022-11-11 11:30:02',NULL),(1028,7985,41102,40781,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',49909.90,NULL,NULL,1,'2022-11-11 11:30:02','2022-11-11 11:30:02',NULL),(1029,7985,41102,40781,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',5449.20,NULL,NULL,1,'2022-11-11 11:30:03','2022-11-11 11:30:03',NULL),(1030,7985,41102,40781,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',24847.66,NULL,NULL,1,'2022-11-11 11:30:03','2022-11-11 11:30:03',NULL),(1031,7985,41102,40781,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',13631.30,NULL,NULL,1,'2022-11-11 11:30:03','2022-11-11 11:30:03',NULL),(1032,7985,41102,40781,16,97,'App\\Models\\PeriodLiquidation',NULL,97,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6324.30,NULL,NULL,1,'2022-11-12 10:29:19','2022-11-12 10:29:19',NULL);
INSERT INTO `balance_libro` VALUES (1033,7985,41102,40782,2,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5860.00,NULL,NULL,1,'2022-11-12 10:30:14','2022-11-12 10:32:26','2022-11-12 10:32:26'),(1034,7985,41102,40782,2,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',9900.00,NULL,NULL,1,'2022-11-12 10:30:14','2022-11-12 10:32:26','2022-11-12 10:32:26'),(1035,7985,41102,40782,2,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29200.00,NULL,NULL,1,'2022-11-12 10:30:14','2022-11-12 10:32:26','2022-11-12 10:32:26'),(1036,7985,41102,40782,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',52750.00,NULL,NULL,1,'2022-11-12 10:30:14','2022-11-12 10:32:26','2022-11-12 10:32:26'),(1037,7985,41102,40782,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29400.00,NULL,NULL,1,'2022-11-12 10:30:14','2022-11-12 10:32:26','2022-11-12 10:32:26'),(1038,7985,41102,40782,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',36800.00,NULL,NULL,1,'2022-11-12 10:30:14','2022-11-12 10:32:26','2022-11-12 10:32:26'),(1039,7985,41102,40782,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',21527.08,NULL,NULL,1,'2022-11-12 10:30:34','2022-11-12 10:32:42','2022-11-12 10:32:42'),(1040,7985,41102,40782,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',17905.93,NULL,NULL,1,'2022-11-12 10:30:34','2022-11-12 10:32:42','2022-11-12 10:32:42'),(1041,7985,41102,40782,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3461.30,NULL,NULL,1,'2022-11-12 10:30:34','2022-11-12 10:32:42','2022-11-12 10:32:42'),(1042,7985,41102,40782,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',18524.22,NULL,NULL,1,'2022-11-12 10:30:34','2022-11-12 10:32:42','2022-11-12 10:32:42'),(1043,7985,41102,40782,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',31662.74,NULL,NULL,1,'2022-11-12 10:30:34','2022-11-12 10:32:42','2022-11-12 10:32:42'),(1044,7985,41102,40782,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',20733.24,NULL,NULL,1,'2022-11-12 10:30:34','2022-11-12 10:32:42','2022-11-12 10:32:42'),(1045,7985,41102,40782,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5860.00,NULL,NULL,1,'2022-11-12 10:33:23','2022-11-12 10:33:58','2022-11-12 10:33:58'),(1046,7985,41102,40782,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',9900.00,NULL,NULL,1,'2022-11-12 10:33:23','2022-11-12 10:33:58','2022-11-12 10:33:58'),(1047,7985,41102,40782,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29200.00,NULL,NULL,1,'2022-11-12 10:33:23','2022-11-12 10:33:58','2022-11-12 10:33:58'),(1048,7985,41102,40782,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',52750.00,NULL,NULL,1,'2022-11-12 10:33:23','2022-11-12 10:33:58','2022-11-12 10:33:58'),(1049,7985,41102,40782,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29400.00,NULL,NULL,1,'2022-11-12 10:33:23','2022-11-12 10:33:58','2022-11-12 10:33:58'),(1050,7985,41102,40782,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',36800.00,NULL,NULL,1,'2022-11-12 10:33:23','2022-11-12 10:33:58','2022-11-12 10:33:58'),(1051,7985,41102,40782,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5860.00,NULL,NULL,1,'2022-11-12 10:38:13','2022-11-12 10:39:04','2022-11-12 10:39:04');
INSERT INTO `balance_libro` VALUES (1052,7985,41102,40782,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',9900.00,NULL,NULL,1,'2022-11-12 10:38:13','2022-11-12 10:39:04','2022-11-12 10:39:04'),(1053,7985,41102,40782,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29200.00,NULL,NULL,1,'2022-11-12 10:38:13','2022-11-12 10:39:04','2022-11-12 10:39:04'),(1054,7985,41102,40782,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',52750.00,NULL,NULL,1,'2022-11-12 10:38:13','2022-11-12 10:39:04','2022-11-12 10:39:04'),(1055,7985,41102,40782,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29400.00,NULL,NULL,1,'2022-11-12 10:38:13','2022-11-12 10:39:04','2022-11-12 10:39:04'),(1056,7985,41102,40782,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',36800.00,NULL,NULL,1,'2022-11-12 10:38:13','2022-11-12 10:39:04','2022-11-12 10:39:04'),(1057,7985,41102,40782,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5860.00,NULL,NULL,1,'2022-11-12 10:40:08','2022-11-12 10:40:08',NULL),(1058,7985,41102,40782,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',9900.00,NULL,NULL,1,'2022-11-12 10:40:08','2022-11-12 10:40:08',NULL),(1059,7985,41102,40782,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29200.00,NULL,NULL,1,'2022-11-12 10:40:08','2022-11-12 10:40:08',NULL),(1060,7985,41102,40782,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',52750.00,NULL,NULL,1,'2022-11-12 10:40:08','2022-11-12 10:40:08',NULL),(1061,7985,41102,40782,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29400.00,NULL,NULL,1,'2022-11-12 10:40:08','2022-11-12 10:40:08',NULL),(1062,7985,41102,40782,2,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',36800.00,NULL,NULL,1,'2022-11-12 10:40:08','2022-11-12 10:40:08',NULL),(1063,7985,40720,1527,16,45,'App\\Models\\PeriodLiquidation',NULL,45,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3587.36,NULL,NULL,1,'2022-11-12 10:42:18','2022-11-12 10:42:18',NULL),(1064,7985,41102,40782,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',21527.08,NULL,NULL,1,'2022-11-12 10:53:18','2022-11-12 10:53:18',NULL),(1065,7985,41102,40782,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',17905.93,NULL,NULL,1,'2022-11-12 10:53:18','2022-11-12 10:53:18',NULL),(1066,7985,41102,40782,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3461.30,NULL,NULL,1,'2022-11-12 10:53:18','2022-11-12 10:53:18',NULL),(1067,7985,41102,40782,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',18524.22,NULL,NULL,1,'2022-11-12 10:53:18','2022-11-12 10:53:18',NULL),(1068,7985,41102,40782,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',31662.74,NULL,NULL,1,'2022-11-12 10:53:18','2022-11-12 10:53:18',NULL),(1069,7985,41102,40782,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',20733.24,NULL,NULL,1,'2022-11-12 10:53:18','2022-11-12 10:53:18',NULL),(1070,7985,40767,31698,15,94,'App\\Models\\PeriodLiquidation',NULL,94,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',179611.50,NULL,NULL,1,'2022-11-13 17:27:37','2022-12-12 12:40:37','2022-12-12 12:40:37'),(1071,7985,40767,31698,16,95,'App\\Models\\PeriodLiquidation',NULL,95,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',34563.30,NULL,NULL,1,'2022-11-13 17:30:57','2023-02-05 12:51:11','2023-02-05 12:51:11');
INSERT INTO `balance_libro` VALUES (1072,7985,41102,40782,16,108,'App\\Models\\PeriodLiquidation',NULL,108,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7375.95,NULL,NULL,1,'2022-11-14 09:30:27','2022-11-14 09:30:27',NULL),(1073,7985,40721,3043,2,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',60000.00,NULL,NULL,1,'2022-11-28 08:45:19','2022-11-28 08:45:19',NULL),(1074,7985,40721,3043,2,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',75000.00,NULL,NULL,1,'2022-11-28 08:45:19','2022-11-28 08:45:19',NULL),(1075,7985,40721,3043,2,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',140000.00,NULL,NULL,1,'2022-11-28 08:45:19','2022-11-28 08:45:19',NULL),(1076,7985,40721,3043,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3576.21,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1077,7985,40721,3043,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',27888.96,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1078,7985,40721,3043,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',24524.73,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1079,7985,40721,3043,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6297.50,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1080,7985,40721,3043,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',205112.38,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1081,7985,40721,3043,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',843.37,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1082,7985,40721,3043,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',45299.00,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1083,7985,40721,3043,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',3066.20,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1084,7985,40721,3043,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',12199.14,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1085,7985,40721,3043,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',6611.22,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1086,7985,40721,3043,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',12272.53,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1087,7985,40721,3043,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2022-11-28 08:45:53','2022-11-28 08:45:53',NULL),(1088,7985,40721,3043,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',28230.00,NULL,NULL,1,'2022-12-01 11:25:04','2022-12-01 11:40:12','2022-12-01 11:40:12'),(1089,7985,40721,3043,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',58798.44,NULL,NULL,1,'2022-12-01 11:25:04','2022-12-01 11:25:04',NULL),(1090,7985,40721,3043,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',134999.00,NULL,NULL,1,'2022-12-01 11:25:04','2022-12-01 11:25:04',NULL),(1091,7985,40721,3043,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',950.00,NULL,NULL,1,'2022-12-01 11:25:04','2022-12-01 11:39:07','2022-12-01 11:39:07');
INSERT INTO `balance_libro` VALUES (1092,7985,40721,3043,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',785.12,NULL,NULL,1,'2022-12-01 11:39:07','2022-12-01 11:39:07',NULL),(1093,7985,40721,3043,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',25547.51,NULL,NULL,1,'2022-12-01 11:40:12','2022-12-01 11:40:12',NULL),(1094,7985,40721,3043,2,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',447700.00,NULL,NULL,1,'2022-12-01 13:42:36','2022-12-01 13:42:36',NULL),(1095,7985,40720,1528,2,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',5000.00,NULL,NULL,1,'2022-12-04 19:35:35','2022-12-04 19:35:35',NULL),(1096,7985,40720,1528,2,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',7260.00,NULL,NULL,1,'2022-12-04 19:35:36','2022-12-04 19:35:36',NULL),(1097,7985,40720,1528,2,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',7000.00,NULL,NULL,1,'2022-12-04 19:35:36','2022-12-04 19:35:36',NULL),(1098,7985,40720,1528,2,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',8000.00,NULL,NULL,1,'2022-12-04 19:35:36','2022-12-04 19:35:36',NULL),(1099,7985,40720,1528,2,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',45000.00,NULL,NULL,1,'2022-12-04 19:35:36','2022-12-04 19:35:36',NULL),(1100,7985,40720,1528,2,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',24200.00,NULL,NULL,1,'2022-12-04 19:35:36','2022-12-04 19:35:36',NULL),(1101,7985,40720,1528,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3539.89,NULL,NULL,1,'2022-12-04 19:35:48','2022-12-04 19:35:48',NULL),(1102,7985,40720,1528,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',189.00,NULL,NULL,1,'2022-12-04 19:35:48','2022-12-04 19:35:48',NULL),(1103,7985,40720,1528,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',5841.01,NULL,NULL,1,'2022-12-04 19:35:48','2022-12-04 19:35:48',NULL),(1104,7985,40720,1528,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2000.14,NULL,NULL,1,'2022-12-04 19:35:48','2022-12-04 19:35:48',NULL),(1105,7985,40720,1528,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',32991.00,NULL,NULL,1,'2022-12-04 19:35:48','2022-12-04 19:35:48',NULL),(1106,7985,40720,1528,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',32991.00,NULL,NULL,1,'2022-12-04 19:35:48','2022-12-04 19:35:48',NULL),(1107,7985,40720,1528,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',32991.00,NULL,NULL,1,'2022-12-04 19:35:48','2022-12-04 19:35:48',NULL),(1108,7985,40720,1528,16,131,'App\\Models\\PeriodLiquidation',NULL,131,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3587.36,NULL,NULL,1,'2022-12-04 19:50:34','2023-02-05 18:23:29','2023-02-05 18:23:29'),(1109,7985,40763,28696,2,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',45994.13,NULL,NULL,1,'2022-12-05 09:31:08','2022-12-05 09:31:08',NULL),(1110,7985,40763,28696,2,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',85388.93,NULL,NULL,1,'2022-12-05 09:31:08','2022-12-05 09:31:08',NULL),(1111,7985,40763,28696,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1700.00,NULL,NULL,1,'2022-12-05 09:31:23','2022-12-05 09:31:23',NULL),(1112,7985,40763,28696,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4509.56,NULL,NULL,1,'2022-12-05 09:31:23','2022-12-05 09:31:23',NULL);
INSERT INTO `balance_libro` VALUES (1113,7985,40763,28696,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',3487.95,NULL,NULL,1,'2022-12-05 09:31:23','2022-12-05 09:31:23',NULL),(1114,7985,40763,28696,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3682.36,NULL,NULL,1,'2022-12-05 09:31:23','2022-12-05 09:31:23',NULL),(1115,7985,40720,1528,15,130,'App\\Models\\PeriodLiquidation',NULL,130,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',16740.99,NULL,NULL,1,'2022-12-05 12:39:50','2022-12-05 12:39:50',NULL),(1116,7985,40721,3043,15,121,'App\\Models\\PeriodLiquidation',NULL,121,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',125427.27,NULL,NULL,1,'2022-12-12 10:37:11','2022-12-12 10:37:11',NULL),(1117,7985,40721,3043,16,125,'App\\Models\\PeriodLiquidation',NULL,125,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',0.00,NULL,NULL,1,'2022-12-12 10:40:55','2022-12-12 10:40:55',NULL),(1118,7985,40763,28696,15,136,'App\\Models\\PeriodLiquidation',NULL,136,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',22802.02,NULL,NULL,1,'2022-12-12 11:53:23','2022-12-12 11:53:23',NULL),(1119,7985,40763,28696,16,137,'App\\Models\\PeriodLiquidation',NULL,137,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',32.44,NULL,NULL,1,'2022-12-12 12:40:37','2022-12-12 12:40:37',NULL),(1125,7985,40767,31699,2,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',320.00,NULL,NULL,1,'2022-12-16 10:23:35','2022-12-16 10:23:35',NULL),(1126,7985,40767,31699,2,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',990.00,NULL,NULL,1,'2022-12-16 10:23:35','2022-12-16 10:23:35',NULL),(1127,7985,40767,31699,2,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',16600.00,NULL,NULL,1,'2022-12-16 10:23:35','2022-12-16 10:23:35',NULL),(1128,7985,40767,31699,2,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',4050.00,NULL,NULL,1,'2022-12-16 10:23:35','2022-12-16 10:23:35',NULL),(1129,7985,40767,31699,2,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',4980.00,NULL,NULL,1,'2022-12-16 10:23:35','2022-12-16 10:23:35',NULL),(1130,7985,40767,31699,2,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',8626.00,NULL,NULL,1,'2022-12-16 10:23:35','2022-12-16 10:23:35',NULL),(1131,7985,40767,31699,2,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',920.00,NULL,NULL,1,'2022-12-16 10:23:35','2022-12-16 10:23:35',NULL),(1132,7985,40767,31699,2,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1120.00,NULL,NULL,1,'2022-12-16 10:23:35','2022-12-16 10:23:35',NULL),(1133,7985,40767,31699,2,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2543.00,NULL,NULL,1,'2022-12-16 10:23:35','2022-12-16 10:23:35',NULL),(1134,7985,40767,31699,2,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',3200.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1135,7985,40767,31699,2,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',5520.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1136,7985,40767,31699,2,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',500.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1137,7985,40767,31699,2,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',5800.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL);
INSERT INTO `balance_libro` VALUES (1138,7985,40767,31699,2,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1360.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1139,7985,40767,31699,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1230.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1140,7985,40767,31699,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',200.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1141,7985,40767,31699,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1640.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1142,7985,40767,31699,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',37500.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1143,7985,40767,31699,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1220.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1144,7985,40767,31699,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',150.40,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1145,7985,40767,31699,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',260.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1146,7985,40767,31699,2,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',630.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1147,7985,40767,31699,2,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',930.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1148,7985,40767,31699,2,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2007.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1149,7985,40767,31699,2,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2430.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1150,7985,40767,31699,2,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1760.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1151,7985,40767,31699,2,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1930.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1152,7985,40767,31699,2,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2860.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1153,7985,40767,31699,2,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',877.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1154,7985,40767,31699,2,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',600.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1155,7985,40767,31699,2,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2880.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1156,7985,40767,31699,2,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1040.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1157,7985,40767,31699,2,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2420.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL),(1158,7985,40767,31699,2,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2340.00,NULL,NULL,1,'2022-12-16 10:23:36','2022-12-16 10:23:36',NULL);
INSERT INTO `balance_libro` VALUES (1159,7985,40767,31699,2,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1790.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1160,7985,40767,31699,2,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',560.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1161,7985,40767,31699,2,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',11321.97,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1162,7985,40767,31699,2,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',5853.95,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1163,7985,40767,31699,2,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3078.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1164,7985,40767,31699,2,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2290.01,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1165,7985,40767,31699,2,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',7600.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1166,7985,40767,31699,2,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',25914.51,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1167,7985,40767,31699,2,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1580.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1168,7985,40767,31699,2,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1710.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1169,7985,40767,31699,2,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',5950.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1170,7985,40767,31699,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',590.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1171,7985,40767,31699,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',4300.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1172,7985,40767,31699,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',430.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1173,7985,40767,31699,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',920.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1174,7985,40767,31699,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1130.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1175,7985,40767,31699,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',994.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1176,7985,40767,31699,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',5853.95,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1177,7985,40767,31699,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',12000.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1178,7985,40767,31699,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',14400.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1179,7985,40767,31699,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',1544.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL);
INSERT INTO `balance_libro` VALUES (1180,7985,40767,31699,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',910.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1181,7985,40767,31699,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',10530.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1182,7985,40767,31699,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',530.00,NULL,NULL,1,'2022-12-16 10:23:37','2022-12-16 10:23:37',NULL),(1183,7985,40767,31699,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2800.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1184,7985,40767,31699,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',6120.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1185,7985,40767,31699,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2890.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1186,7985,40767,31699,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',7900.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1187,7985,40767,31699,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',8480.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1188,7985,40767,31699,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',5000.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1189,7985,40767,31699,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',750.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1190,7985,40767,31699,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',12948.05,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1191,7985,40767,31699,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',13185.01,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1192,7985,40767,31699,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',5309.56,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1193,7985,40767,31699,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',4030.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1194,7985,40767,31699,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',13962.70,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1195,7985,40767,31699,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',1078.45,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1196,7985,40767,31699,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',407.77,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1197,7985,40767,31699,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',9425.52,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1198,7985,40767,31699,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2700.12,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1199,7985,40767,31699,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3520.01,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1200,7985,40767,31699,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',5853.95,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL);
INSERT INTO `balance_libro` VALUES (1201,7985,40767,31699,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',590.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1202,7985,40767,31699,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',120.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1203,7985,40767,31699,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3650.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1204,7985,40767,31699,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2190.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1205,7985,40767,31699,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',29717.87,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1206,7985,40767,31699,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',5840.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1207,7985,40767,31699,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',490.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1208,7985,40767,31699,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',7260.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1209,7985,40767,31699,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',4260.00,NULL,NULL,1,'2022-12-16 10:23:38','2022-12-16 10:23:38',NULL),(1210,7985,40767,31699,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',3290.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1211,7985,40767,31699,2,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2870.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1212,7985,40767,31699,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1920.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1213,7985,40767,31699,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',11680.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1214,7985,40767,31699,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',970.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1215,7985,40767,31699,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',14800.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1216,7985,40767,31699,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',670.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1217,7985,40767,31699,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2750.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1218,7985,40767,31699,2,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',610.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1219,7985,40767,31699,2,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',440.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1220,7985,40767,31699,2,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',980.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1221,7985,40767,31699,2,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5590.20,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL);
INSERT INTO `balance_libro` VALUES (1222,7985,40767,31699,2,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',3321.86,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1223,7985,40767,31699,2,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',3600.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1224,7985,40767,31699,2,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',530.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1225,7985,40767,31699,2,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',530.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1226,7985,40767,31699,2,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1620.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1227,7985,40767,31699,2,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5110.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1228,7985,40767,31699,2,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5474.70,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1229,7985,40767,31699,2,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',500.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1230,7985,40767,31699,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',15923.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1231,7985,40767,31699,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1560.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1232,7985,40767,31699,2,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',4600.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1233,7985,40767,31699,2,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',4600.00,NULL,NULL,1,'2022-12-16 10:23:39','2022-12-16 10:23:39',NULL),(1234,7985,40767,31699,2,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',990.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1235,7985,40767,31699,2,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2750.10,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1236,7985,40767,31699,2,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2140.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1237,7985,40767,31699,2,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',580.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1238,7985,40767,31699,2,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1400.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1239,7985,40767,31699,2,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1810.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1240,7985,40767,31699,2,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1475.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1241,7985,40767,31699,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2700.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1242,7985,40767,31699,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1195.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL);
INSERT INTO `balance_libro` VALUES (1243,7985,40767,31699,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',490.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1244,7985,40767,31699,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7100.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1245,7985,40767,31699,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1630.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1246,7985,40767,31699,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1480.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1247,7985,40767,31699,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2350.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1248,7985,40767,31699,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5810.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1249,7985,40767,31699,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',440.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1250,7985,40767,31699,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2222.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1251,7985,40767,31699,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2500.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1252,7985,40767,31699,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3545.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1253,7985,40767,31699,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2220.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1254,7985,40767,31699,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2210.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1255,7985,40767,31699,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2910.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1256,7985,40767,31699,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3060.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1257,7985,40767,31699,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7000.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1258,7985,40767,31699,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',11480.00,NULL,NULL,1,'2022-12-16 10:23:40','2022-12-16 10:23:40',NULL),(1259,7985,40767,31699,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2460.05,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1260,7985,40767,31699,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2733.98,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1261,7985,40767,31699,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2420.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1262,7985,40767,31699,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2730.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1263,7985,40767,31699,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',560.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL);
INSERT INTO `balance_libro` VALUES (1264,7985,40767,31699,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',1460.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1265,7985,40767,31699,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',3490.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1266,7985,40767,31699,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',4317.04,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1267,7985,40767,31699,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1542.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1268,7985,40767,31699,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2780.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1269,7985,40767,31699,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',650.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1270,7985,40767,31699,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5950.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1271,7985,40767,31699,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2780.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1272,7985,40767,31699,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3740.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1273,7985,40767,31699,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1505.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1274,7985,40767,31699,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',820.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1275,7985,40767,31699,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1310.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1276,7985,40767,31699,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',790.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1277,7985,40767,31699,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',500.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1278,7985,40767,31699,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2680.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1279,7985,40767,31699,2,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',250.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1280,7985,40767,31699,2,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',110.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1281,7985,40767,31699,2,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1320.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1282,7985,40767,31699,2,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',12140.01,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1283,7985,40767,31699,2,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',250.11,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1284,7985,40767,31699,2,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',850.00,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL);
INSERT INTO `balance_libro` VALUES (1285,7985,40767,31699,2,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2356.08,NULL,NULL,1,'2022-12-16 10:23:41','2022-12-16 10:23:41',NULL),(1286,7985,40767,31699,2,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6288.75,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1287,7985,40767,31699,2,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',650.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1288,7985,40767,31699,2,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1580.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1289,7985,40767,31699,2,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',970.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1290,7985,40767,31699,2,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',460.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1291,7985,40767,31699,2,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2110.02,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1292,7985,40767,31699,2,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',920.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1293,7985,40767,31699,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',810.04,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1294,7985,40767,31699,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2512.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1295,7985,40767,31699,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2540.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1296,7985,40767,31699,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',190.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1297,7985,40767,31699,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',4170.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1298,7985,40767,31699,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1420.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1299,7985,40767,31699,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',14600.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1300,7985,40767,31699,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1930.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1301,7985,40767,31699,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1970.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1302,7985,40767,31699,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',6595.10,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1303,7985,40767,31699,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2400.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1304,7985,40767,31699,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',9340.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1305,7985,40767,31699,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',9080.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL);
INSERT INTO `balance_libro` VALUES (1306,7985,40767,31699,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2280.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1307,7985,40767,31699,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1370.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1308,7985,40767,31699,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',3520.00,NULL,NULL,1,'2022-12-16 10:23:42','2022-12-16 10:23:42',NULL),(1309,7985,40767,31699,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',7115.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1310,7985,40767,31699,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',1260.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1311,7985,40767,31699,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2700.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1312,7985,40767,31699,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2900.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1313,7985,40767,31699,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',490.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1314,7985,40767,31699,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',970.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1315,7985,40767,31699,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',17350.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1316,7985,40767,31699,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',1600.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1317,7985,40767,31699,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',1050.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1318,7985,40767,31699,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',995.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1319,7985,40767,31699,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',14800.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1320,7985,40767,31699,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2430.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1321,7985,40767,31699,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1200.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1322,7985,40767,31699,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',710.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1323,7985,40767,31699,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1620.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1324,7985,40767,31699,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1270.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1325,7985,40767,31699,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2252.12,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1326,7985,40767,31699,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1931.60,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL);
INSERT INTO `balance_libro` VALUES (1327,7985,40767,31699,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1898.10,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1328,7985,40767,31699,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',900.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1329,7985,40767,31699,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1700.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1330,7985,40767,31699,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',900.00,NULL,NULL,1,'2022-12-16 10:23:43','2022-12-16 10:23:43',NULL),(1331,7985,40767,31699,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',440.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1332,7985,40767,31699,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1720.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1333,7985,40767,31699,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',690.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1334,7985,40767,31699,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',340.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1335,7985,40767,31699,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1160.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1336,7985,40767,31699,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1470.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1337,7985,40767,31699,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',500.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1338,7985,40767,31699,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2300.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1339,7985,40767,31699,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1060.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1340,7985,40767,31699,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',380.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1341,7985,40767,31699,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1400.41,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1342,7985,40767,31699,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',16256.68,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1343,7985,40767,31699,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',819.39,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1344,7985,40767,31699,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8412.83,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1345,7985,40767,31699,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2503.65,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1346,7985,40767,31699,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2020.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1347,7985,40767,31699,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8100.50,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL);
INSERT INTO `balance_libro` VALUES (1348,7985,40767,31699,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',3444.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1349,7985,40767,31699,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1421.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1350,7985,40767,31699,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',470.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1351,7985,40767,31699,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',400.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1352,7985,40767,31699,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',3000.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1353,7985,40767,31699,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',4380.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1354,7985,40767,31699,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2080.00,NULL,NULL,1,'2022-12-16 10:23:44','2022-12-16 10:23:44',NULL),(1355,7985,40767,31699,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',750.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1356,7985,40767,31699,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',18830.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1357,7985,40767,31699,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1300.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1358,7985,40767,31699,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1940.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1359,7985,40767,31699,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',850.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1360,7985,40767,31699,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',930.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1361,7985,40767,31699,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1720.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1362,7985,40767,31699,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',7400.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1363,7985,40767,31699,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',29150.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1364,7985,40767,31699,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',4790.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1365,7985,40767,31699,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',4744.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1366,7985,40767,31699,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1901.49,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1367,7985,40767,31699,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',56290.34,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1368,7985,40767,31699,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',9074.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL);
INSERT INTO `balance_libro` VALUES (1369,7985,40767,31699,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2064.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1370,7985,40767,31699,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3420.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1371,7985,40767,31699,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',780.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1372,7985,40767,31699,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1960.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1373,7985,40767,31699,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2970.00,NULL,NULL,1,'2022-12-16 10:23:45','2022-12-16 10:23:45',NULL),(1374,7985,40767,31699,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1400.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1375,7985,40767,31699,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',500.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1376,7985,40767,31699,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',15500.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1377,7985,40767,31699,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',950.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1378,7985,40767,31699,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',550.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1379,7985,40767,31699,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1330.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1380,7985,40767,31699,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',780.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1381,7985,40767,31699,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2980.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1382,7985,40767,31699,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',720.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1383,7985,40767,31699,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1608.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1384,7985,40767,31699,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1320.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1385,7985,40767,31699,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3280.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1386,7985,40767,31699,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',8510.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1387,7985,40767,31699,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2020.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1388,7985,40767,31699,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2105.00,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1389,7985,40767,31699,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',15830.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL);
INSERT INTO `balance_libro` VALUES (1390,7985,40767,31699,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',290.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1391,7985,40767,31699,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',560.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1392,7985,40767,31699,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1450.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1393,7985,40767,31699,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1170.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1394,7985,40767,31699,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',9800.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1395,7985,40767,31699,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',580.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1396,7985,40767,31699,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',470.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1397,7985,40767,31699,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4250.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1398,7985,40767,31699,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1500.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1399,7985,40767,31699,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1910.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1400,7985,40767,31699,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',101995.88,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1401,7985,40767,31699,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',730.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1402,7985,40767,31699,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6670.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1403,7985,40767,31699,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',560.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1404,7985,40767,31699,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3700.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1405,7985,40767,31699,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',680.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1406,7985,40767,31699,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1480.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1407,7985,40767,31699,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3940.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1408,7985,40767,31699,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',340.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1409,7985,40767,31699,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1240.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1410,7985,40767,31699,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13505.40,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL);
INSERT INTO `balance_libro` VALUES (1411,7985,40767,31699,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1130.00,NULL,NULL,1,'2022-12-16 10:23:47','2022-12-16 10:23:47',NULL),(1412,7985,40767,31699,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1640.00,NULL,NULL,1,'2022-12-16 10:23:48','2022-12-16 10:23:48',NULL),(1413,7985,40767,31699,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1360.00,NULL,NULL,1,'2022-12-16 10:23:48','2022-12-16 10:23:48',NULL),(1414,7985,40767,31699,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',300.00,NULL,NULL,1,'2022-12-16 10:23:48','2022-12-16 10:23:48',NULL),(1415,7985,40767,31699,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2080.00,NULL,NULL,1,'2022-12-16 10:23:48','2022-12-16 10:23:48',NULL),(1416,7985,40767,31699,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',780.00,NULL,NULL,1,'2022-12-16 10:23:48','2022-12-16 10:23:48',NULL),(1417,7985,40767,31699,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1030.00,NULL,NULL,1,'2022-12-16 10:23:48','2022-12-16 10:23:48',NULL),(1418,7985,40767,31699,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1400.00,NULL,NULL,1,'2022-12-16 10:23:48','2022-12-16 10:23:48',NULL),(1419,7985,40767,31699,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6167.38,NULL,NULL,1,'2022-12-17 07:46:19','2022-12-17 13:06:37','2022-12-17 13:06:37'),(1420,7985,40767,31699,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',4200.00,NULL,NULL,1,'2022-12-17 07:46:19','2022-12-17 07:46:19',NULL),(1421,7985,40767,31699,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',127836.42,NULL,NULL,1,'2022-12-17 07:46:19','2022-12-17 07:46:19',NULL),(1422,7985,40767,31699,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',42806.03,NULL,NULL,1,'2022-12-17 07:46:19','2022-12-17 13:04:22','2022-12-17 13:04:22'),(1423,7985,40767,31699,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',43040.82,NULL,NULL,1,'2022-12-17 07:46:19','2022-12-17 07:46:19',NULL),(1424,7985,40767,31699,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',59632.62,NULL,NULL,1,'2022-12-17 07:46:19','2022-12-17 07:46:19',NULL),(1425,7985,40767,31699,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',22567.40,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1426,7985,40767,31699,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',68479.36,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 12:59:30','2022-12-17 12:59:30'),(1427,7985,40767,31699,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2058.41,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1428,7985,40767,31699,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',6856.46,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1429,7985,40767,31699,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',83518.99,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1430,7985,40767,31699,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',1577.39,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL);
INSERT INTO `balance_libro` VALUES (1431,7985,40767,31699,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',517.54,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1432,7985,40767,31699,3,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2598.96,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1433,7985,40767,31699,3,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',16311.59,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1434,7985,40767,31699,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',23996.16,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1435,7985,40767,31699,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',27417.24,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1436,7985,40767,31699,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',4494.52,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1437,7985,40767,31699,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',29752.82,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1438,7985,40767,31699,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',25352.89,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1439,7985,40767,31699,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',10204.66,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1440,7985,40767,31699,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5945.35,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1441,7985,40767,31699,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',28693.27,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1442,7985,40767,31699,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',29501.49,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1443,7985,40767,31699,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6022.23,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1444,7985,40767,31699,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',53278.32,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1445,7985,40767,31699,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',28693.27,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1446,7985,40767,31699,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',35866.60,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1447,7985,40767,31699,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',55043.28,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1448,7985,40767,31699,3,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1906.65,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1449,7985,40767,31699,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',14773.00,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1450,7985,40767,31699,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',35866.60,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1451,7985,40767,31699,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',197957.73,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL);
INSERT INTO `balance_libro` VALUES (1452,7985,40767,31699,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2352.80,NULL,NULL,1,'2022-12-17 07:46:20','2022-12-17 07:46:20',NULL),(1453,7985,40767,31699,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',41866.98,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1454,7985,40767,31699,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',8279.99,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1455,7985,40767,31699,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',82592.66,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1456,7985,40767,31699,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',123898.51,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 12:30:24','2022-12-17 12:30:24'),(1457,7985,40767,31699,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',14982.22,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1458,7985,40767,31699,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',43685.11,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1459,7985,40767,31699,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8642.29,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1460,7985,40767,31699,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',22149.41,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1461,7985,40767,31699,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',482.38,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1462,7985,40767,31699,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',9667.63,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1463,7985,40767,31699,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1523.62,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1464,7985,40767,31699,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1505.32,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1465,7985,40767,31699,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',35930.91,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1466,7985,40767,31699,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1444.96,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1467,7985,40767,31699,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',34694.26,NULL,NULL,1,'2022-12-17 07:46:21','2022-12-17 07:46:21',NULL),(1468,7985,40767,31699,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',122973.33,NULL,NULL,1,'2022-12-17 12:30:24','2022-12-17 12:30:24',NULL),(1469,7985,40767,31699,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',59066.54,NULL,NULL,1,'2022-12-17 12:59:30','2022-12-17 12:59:30',NULL),(1470,7985,40767,31699,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',40256.18,NULL,NULL,1,'2022-12-17 13:04:22','2022-12-17 13:04:22',NULL),(1471,7985,40767,31699,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',5449.28,NULL,NULL,1,'2022-12-17 13:06:37','2022-12-17 13:06:37',NULL);
INSERT INTO `balance_libro` VALUES (1472,7985,40767,31699,7,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',794.32,NULL,NULL,1,'2022-12-18 07:39:12','2022-12-18 07:39:12',NULL),(1473,7985,40767,31699,7,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',124.68,NULL,NULL,1,'2022-12-18 07:39:29','2022-12-18 07:39:29',NULL),(1474,7985,40767,31699,7,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',50.40,NULL,NULL,1,'2022-12-18 07:39:29','2022-12-18 07:39:29',NULL),(1475,7985,40767,31699,7,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',255.19,NULL,NULL,1,'2022-12-18 07:39:29','2022-12-18 07:39:29',NULL),(1476,7985,40767,31699,7,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',155.19,NULL,NULL,1,'2022-12-18 07:48:51','2022-12-18 07:48:51',NULL),(1477,7985,40767,31699,7,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',72.99,NULL,NULL,1,'2022-12-18 07:48:51','2022-12-18 07:48:51',NULL),(1478,7985,40721,3044,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',242000.00,NULL,NULL,1,'2022-12-29 15:33:37','2022-12-29 15:33:37',NULL),(1479,7985,40721,3044,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',242000.00,NULL,NULL,1,'2022-12-29 19:57:02','2022-12-29 19:57:02',NULL),(1480,7985,40721,3044,3,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',5644.95,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:10:59',NULL),(1481,7985,40721,3044,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',843.37,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:10:59',NULL),(1482,7985,40721,3044,3,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',30976.71,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:10:59',NULL),(1483,7985,40721,3044,3,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',7067.58,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:10:59',NULL),(1484,7985,40721,3044,3,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',27198.72,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:25:50','2022-12-29 20:25:50'),(1485,7985,40721,3044,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',30600.00,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:25:38','2022-12-29 20:25:38'),(1486,7985,40721,3044,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3898.62,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:10:59',NULL),(1487,7985,40721,3044,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4797.21,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:10:59',NULL),(1488,7985,40721,3044,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',28980.00,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:25:19','2022-12-29 20:25:19'),(1489,7985,40721,3044,3,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',103597.84,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:10:59',NULL),(1490,7985,40721,3044,3,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',26690.00,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:25:02','2022-12-29 20:25:02'),(1491,7985,40721,3044,3,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1282.00,NULL,NULL,1,'2022-12-29 20:10:59','2022-12-29 20:24:53','2022-12-29 20:24:53');
INSERT INTO `balance_libro` VALUES (1492,7985,40721,3044,3,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',28216.85,NULL,NULL,1,'2022-12-29 20:39:10','2022-12-29 20:39:10',NULL),(1493,7985,40721,3044,3,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2657.85,NULL,NULL,1,'2022-12-29 20:40:22','2022-12-29 20:40:22',NULL),(1494,7985,40721,3044,15,176,'App\\Models\\PeriodLiquidation',NULL,176,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',84000.00,NULL,NULL,1,'2023-01-09 22:53:26','2023-04-13 14:59:14','2023-04-13 14:59:14'),(1495,7985,40721,3044,16,177,'App\\Models\\PeriodLiquidation',NULL,177,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-01-09 22:53:37','2023-01-09 22:53:37',NULL),(1496,7985,40720,1529,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5000.00,NULL,NULL,1,'2023-01-09 22:57:23','2023-01-09 22:57:23',NULL),(1497,7985,40720,1529,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',7260.00,NULL,NULL,1,'2023-01-09 22:57:24','2023-01-09 22:57:24',NULL),(1498,7985,40720,1529,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',7000.00,NULL,NULL,1,'2023-01-09 22:57:24','2023-01-09 22:57:24',NULL),(1499,7985,40720,1529,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',45000.00,NULL,NULL,1,'2023-01-09 22:57:24','2023-01-09 22:57:24',NULL),(1500,7985,40720,1529,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',8000.00,NULL,NULL,1,'2023-01-09 22:57:24','2023-01-09 22:57:24',NULL),(1501,7985,40720,1529,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',24200.00,NULL,NULL,1,'2023-01-09 22:57:24','2023-01-09 22:57:24',NULL),(1502,7985,40720,1529,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-01-09 22:57:24','2023-01-09 22:57:24',NULL),(1503,7985,40720,1529,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3602.05,NULL,NULL,1,'2023-01-09 23:03:00','2023-01-09 23:03:00',NULL),(1504,7985,40720,1529,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',499.97,NULL,NULL,1,'2023-01-09 23:03:00','2023-01-09 23:03:00',NULL),(1505,7985,40720,1529,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',11952.02,NULL,NULL,1,'2023-01-09 23:03:00','2023-01-09 23:03:00',NULL),(1506,7985,40720,1529,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',19618.69,NULL,NULL,1,'2023-01-09 23:03:00','2023-01-09 23:03:00',NULL),(1507,7985,40720,1529,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',10250.76,NULL,NULL,1,'2023-01-09 23:03:00','2023-01-09 23:03:00',NULL),(1508,7985,40720,1529,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1890.01,NULL,NULL,1,'2023-01-09 23:03:00','2023-01-09 23:03:00',NULL),(1509,7985,40720,1529,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-01-09 23:03:00','2023-01-09 23:03:00',NULL),(1510,7985,40720,1529,15,182,'App\\Models\\PeriodLiquidation',NULL,182,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',16740.99,NULL,NULL,1,'2023-01-10 16:45:27','2023-01-10 16:45:27',NULL),(1511,7985,40720,1529,16,183,'App\\Models\\PeriodLiquidation',NULL,183,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3587.36,NULL,NULL,1,'2023-01-10 16:45:43','2023-01-10 16:45:43',NULL);
INSERT INTO `balance_libro` VALUES (1512,7985,40763,28697,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',213951.06,NULL,NULL,1,'2023-01-10 17:45:25','2023-01-10 17:45:25',NULL),(1513,7985,40763,28697,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',47713.08,NULL,NULL,1,'2023-01-10 17:45:25','2023-01-10 17:45:25',NULL),(1514,7985,40763,28697,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',3504.32,NULL,NULL,1,'2023-01-10 17:49:26','2023-01-10 17:49:26',NULL),(1515,7985,40763,28697,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',164265.10,NULL,NULL,1,'2023-01-10 17:49:26','2023-01-10 17:49:26',NULL),(1516,7985,40763,28697,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',6330.01,NULL,NULL,1,'2023-01-10 17:49:26','2023-01-10 17:49:26',NULL),(1517,7985,40763,28697,16,189,'App\\Models\\PeriodLiquidation',NULL,189,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',64.62,NULL,NULL,1,'2023-01-11 23:21:25','2023-01-11 23:21:25',NULL),(1518,7985,40763,28697,15,188,'App\\Models\\PeriodLiquidation',NULL,188,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',45412.78,NULL,NULL,1,'2023-01-11 23:21:46','2023-01-11 23:21:46',NULL),(1519,7985,40767,31699,15,156,'App\\Models\\PeriodLiquidation',NULL,156,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',238604.49,NULL,NULL,1,'2023-01-12 22:28:13','2023-01-12 22:28:13',NULL),(1520,7985,40767,31699,16,157,'App\\Models\\PeriodLiquidation',NULL,157,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',44901.72,NULL,NULL,1,'2023-01-12 22:28:33','2023-01-12 22:28:33',NULL),(1531,7985,40767,31700,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7674.54,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1532,7985,40767,31700,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',37031.04,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1533,7985,40767,31700,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2996.42,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1534,7985,40767,31700,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',103756.00,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1535,7985,40767,31700,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',45948.11,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1536,7985,40767,31700,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',68720.17,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1537,7985,40767,31700,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',37576.48,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1538,7985,40767,31700,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',25733.16,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1539,7985,40767,31700,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',4108.56,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1540,7985,40767,31700,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',54568.37,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1541,7985,40767,31700,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',5562.96,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL);
INSERT INTO `balance_libro` VALUES (1542,7985,40767,31700,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',14203.55,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1543,7985,40767,31700,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',14390.19,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1544,7985,40767,31700,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',34260.48,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1545,7985,40767,31700,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',767.97,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1546,7985,40767,31700,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',8372.38,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1547,7985,40767,31700,3,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',37299.52,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1548,7985,40767,31700,3,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1919.21,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1549,7985,40767,31700,3,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',27323.11,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1550,7985,40767,31700,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',43061.03,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1551,7985,40767,31700,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',21731.20,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1552,7985,40767,31700,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',30828.38,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1553,7985,40767,31700,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',6900.00,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1554,7985,40767,31700,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4979.39,NULL,NULL,1,'2023-01-12 22:55:34','2023-01-12 22:55:34',NULL),(1555,7985,40767,31700,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',15379.23,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1556,7985,40767,31700,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',8058.62,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1557,7985,40767,31700,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',40909.36,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1558,7985,40767,31700,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',97537.60,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1559,7985,40767,31700,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',39285.72,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1560,7985,40767,31700,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',6281.35,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1561,7985,40767,31700,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5172.96,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1562,7985,40767,31700,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',9617.81,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL);
INSERT INTO `balance_libro` VALUES (1563,7985,40767,31700,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',8667.90,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1564,7985,40767,31700,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5039.77,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1565,7985,40767,31700,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',4715.66,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1566,7985,40767,31700,3,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2038.83,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1567,7985,40767,31700,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',4369.43,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1568,7985,40767,31700,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',677.81,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1569,7985,40767,31700,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2930.69,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1570,7985,40767,31700,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',10576.46,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1571,7985,40767,31700,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',32786.80,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1572,7985,40767,31700,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',95654.08,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1573,7985,40767,31700,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',81206.03,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1574,7985,40767,31700,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',7501.05,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1575,7985,40767,31700,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',47713.08,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1576,7985,40767,31700,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',35169.13,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1577,7985,40767,31700,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',31499.85,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1578,7985,40767,31700,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',67417.71,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1579,7985,40767,31700,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',24643.28,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1580,7985,40767,31700,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',7969.46,NULL,NULL,1,'2023-01-12 22:55:35','2023-01-12 22:55:35',NULL),(1581,7985,40767,31700,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2428.60,NULL,NULL,1,'2023-01-12 22:55:36','2023-01-12 22:55:36',NULL),(1582,7985,40767,31700,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',11524.92,NULL,NULL,1,'2023-01-12 22:55:36','2023-01-12 22:55:36',NULL),(1757,7985,40767,31700,2,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1047.99,NULL,NULL,1,'2023-01-12 23:16:34','2023-01-12 23:16:34',NULL);
INSERT INTO `balance_libro` VALUES (1758,7985,40767,31700,2,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',541.86,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1759,7985,40767,31700,2,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7785.95,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1760,7985,40767,31700,2,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',8364.26,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1761,7985,40767,31700,2,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1037.61,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1762,7985,40767,31700,2,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',13433.63,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1763,7985,40767,31700,2,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',990.02,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1764,7985,40767,31700,2,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5560.00,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1765,7985,40767,31700,2,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5560.00,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1766,7985,40767,31700,2,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1800.00,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1767,7985,40767,31700,2,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2000.01,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1768,7985,40767,31700,2,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',6179.99,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1769,7985,40767,31700,2,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',2643.01,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1770,7985,40767,31700,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',7533.80,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1771,7985,40767,31700,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1640.00,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1772,7985,40767,31700,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1294.98,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1773,7985,40767,31700,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1093.02,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1774,7985,40767,31700,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',2543.00,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1775,7985,40767,31700,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',12560.07,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1776,7985,40767,31700,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',20026.95,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1777,7985,40767,31700,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',3040.00,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1778,7985,40767,31700,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',22131.08,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL);
INSERT INTO `balance_libro` VALUES (1779,7985,40767,31700,2,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',784.83,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1780,7985,40767,31700,2,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',3653.84,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1781,7985,40767,31700,2,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',8630.06,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1782,7985,40767,31700,2,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',200.00,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1783,7985,40767,31700,2,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',33807.75,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1784,7985,40767,31700,2,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',3900.01,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1785,7985,40767,31700,2,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3893.86,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1786,7985,40767,31700,2,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2900.01,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1787,7985,40767,31700,2,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',17005.84,NULL,NULL,1,'2023-01-12 23:16:35','2023-01-12 23:16:35',NULL),(1788,7985,40767,31700,2,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4990.20,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1789,7985,40767,31700,2,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1369.21,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1790,7985,40767,31700,2,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',6589.81,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1791,7985,40767,31700,2,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1681.90,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1792,7985,40767,31700,2,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',882.78,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1793,7985,40767,31700,2,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2257.19,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1794,7985,40767,31700,2,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',11434.63,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1795,7985,40767,31700,2,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',10063.10,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1796,7985,40767,31700,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',7971.94,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1797,7985,40767,31700,2,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',445.07,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1798,7985,40767,31700,2,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3051.03,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1799,7985,40767,31700,2,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3420.06,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL);
INSERT INTO `balance_libro` VALUES (1800,7985,40767,31700,2,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',14387.41,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1801,7985,40767,31700,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',5800.26,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1802,7985,40767,31700,2,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',15429.71,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1803,7985,40767,31700,2,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',79356.10,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1804,7985,40767,31700,2,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1911.80,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1805,7985,40767,31700,2,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1760.40,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1806,7985,40767,31700,2,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',710.00,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1807,7985,40767,31700,2,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',760.00,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1808,7985,40767,31700,2,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',4334.00,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1809,7985,40767,31700,2,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',5440.01,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1810,7985,40767,31700,2,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',7030.05,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1811,7985,40767,31700,2,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',5999.20,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1812,7985,40767,31700,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',35804.33,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1813,7985,40767,31700,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',13958.74,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1814,7985,40767,31700,2,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',5178.46,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1815,7985,40767,31700,2,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5644.23,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1816,7985,40767,31700,2,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1497.00,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1817,7985,40767,31700,2,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1380.00,NULL,NULL,1,'2023-01-12 23:16:36','2023-01-12 23:16:36',NULL),(1818,7985,40767,31700,2,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',360.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1819,7985,40767,31700,2,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',6100.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1820,7985,40767,31700,2,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',600.05,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL);
INSERT INTO `balance_libro` VALUES (1821,7985,40767,31700,2,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1700.17,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1822,7985,40767,31700,2,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3720.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1823,7985,40767,31700,2,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',7088.06,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1824,7985,40767,31700,2,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1680.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1825,7985,40767,31700,2,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',150.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1826,7985,40767,31700,2,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1210.02,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1827,7985,40767,31700,2,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',960.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1828,7985,40767,31700,2,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5700.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1829,7985,40767,31700,2,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1520.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1830,7985,40767,31700,2,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1090.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1831,7985,40767,31700,2,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',910.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1832,7985,40767,31700,2,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2440.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1833,7985,40767,31700,2,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1270.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1834,7985,40767,31700,2,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2280.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1835,7985,40767,31700,2,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3680.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1836,7985,40767,31700,2,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5500.37,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1837,7985,40767,31700,2,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',9815.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1838,7985,40767,31700,2,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1950.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1839,7985,40767,31700,2,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',8140.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1840,7985,40767,31700,2,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1730.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1841,7985,40767,31700,2,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4400.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL);
INSERT INTO `balance_libro` VALUES (1842,7985,40767,31700,2,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',54595.30,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1843,7985,40767,31700,2,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2284.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1844,7985,40767,31700,2,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',3240.00,NULL,NULL,1,'2023-01-12 23:16:37','2023-01-12 23:16:37',NULL),(1845,7985,40767,31700,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1800.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1846,7985,40767,31700,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1900.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1847,7985,40767,31700,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',4125.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1848,7985,40767,31700,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2010.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1849,7985,40767,31700,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',895.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1850,7985,40767,31700,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',580.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1851,7985,40767,31700,2,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1395.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1852,7985,40767,31700,2,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1982.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1853,7985,40767,31700,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',600.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1854,7985,40767,31700,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2230.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1855,7985,40767,31700,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1350.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1856,7985,40767,31700,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5750.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1857,7985,40767,31700,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',4870.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1858,7985,40767,31700,2,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2690.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1859,7985,40767,31700,2,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',180.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1860,7985,40767,31700,2,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',3786.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1861,7985,40767,31700,2,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',5480.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1862,7985,40767,31700,2,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',320.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL);
INSERT INTO `balance_libro` VALUES (1863,7985,40767,31700,2,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',820.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1864,7985,40767,31700,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1130.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1865,7985,40767,31700,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',6185.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1866,7985,40767,31700,2,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1060.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1867,7985,40767,31700,2,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',5000.30,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1868,7985,40767,31700,2,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',27208.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1869,7985,40767,31700,2,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',7280.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1870,7985,40767,31700,2,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',4919.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1871,7985,40767,31700,2,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1640.00,NULL,NULL,1,'2023-01-12 23:16:38','2023-01-12 23:16:38',NULL),(1872,7985,40767,31700,2,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1465.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1873,7985,40767,31700,2,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',860.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1874,7985,40767,31700,2,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',9127.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1875,7985,40767,31700,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',13890.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1876,7985,40767,31700,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2290.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1877,7985,40767,31700,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2910.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1878,7985,40767,31700,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2980.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1879,7985,40767,31700,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',4590.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1880,7985,40767,31700,2,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',625.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1881,7985,40767,31700,2,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',14140.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1882,7985,40767,31700,2,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',6650.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1883,7985,40767,31700,2,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',7485.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL);
INSERT INTO `balance_libro` VALUES (1884,7985,40767,31700,2,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2270.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1885,7985,40767,31700,2,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2400.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1886,7985,40767,31700,2,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',8400.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1887,7985,40767,31700,2,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1900.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1888,7985,40767,31700,2,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2300.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1889,7985,40767,31700,2,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2400.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1890,7985,40767,31700,2,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',460.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1891,7985,40767,31700,2,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1310.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1892,7985,40767,31700,2,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',3100.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1893,7985,40767,31700,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1438.25,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1894,7985,40767,31700,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',800.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1895,7985,40767,31700,2,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',836.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1896,7985,40767,31700,2,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',3460.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1897,7985,40767,31700,2,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2500.00,NULL,NULL,1,'2023-01-12 23:16:39','2023-01-12 23:16:39',NULL),(1898,7985,40767,31700,2,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1480.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1899,7985,40767,31700,2,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',300.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1900,7985,40767,31700,2,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4360.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1901,7985,40767,31700,2,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4160.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1902,7985,40767,31700,2,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2280.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1903,7985,40767,31700,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2340.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1904,7985,40767,31700,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',9050.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL);
INSERT INTO `balance_libro` VALUES (1905,7985,40767,31700,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1180.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1906,7985,40767,31700,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',720.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1907,7985,40767,31700,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1500.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1908,7985,40767,31700,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1160.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1909,7985,40767,31700,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',3750.01,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1910,7985,40767,31700,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',5800.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1911,7985,40767,31700,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',230.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1912,7985,40767,31700,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',720.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1913,7985,40767,31700,2,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',430.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1914,7985,40767,31700,2,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',860.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1915,7985,40767,31700,2,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2230.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1916,7985,40767,31700,2,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1420.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1917,7985,40767,31700,2,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',400.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1918,7985,40767,31700,2,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2320.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1919,7985,40767,31700,2,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2300.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1920,7985,40767,31700,2,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',410.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1921,7985,40767,31700,2,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2977.00,NULL,NULL,1,'2023-01-12 23:16:40','2023-01-12 23:16:40',NULL),(1922,7985,40767,31700,2,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1280.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1923,7985,40767,31700,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',510.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1924,7985,40767,31700,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',9670.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1925,7985,40767,31700,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1080.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL);
INSERT INTO `balance_libro` VALUES (1926,7985,40767,31700,2,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',970.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1927,7985,40767,31700,2,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4590.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1928,7985,40767,31700,2,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',610.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1929,7985,40767,31700,2,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',19000.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1930,7985,40767,31700,2,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',16730.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1931,7985,40767,31700,2,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',3380.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1932,7985,40767,31700,2,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',3540.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1933,7985,40767,31700,2,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',9640.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1934,7985,40767,31700,2,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',113718.06,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1935,7985,40767,31700,2,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',10520.01,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1936,7985,40767,31700,2,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',9840.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1937,7985,40767,31700,2,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',650.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1938,7985,40767,31700,2,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2940.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1939,7985,40767,31700,2,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1800.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1940,7985,40767,31700,2,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1960.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1941,7985,40767,31700,2,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',7000.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1942,7985,40767,31700,2,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1250.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1943,7985,40767,31700,2,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',685.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1944,7985,40767,31700,2,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',7370.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1945,7985,40767,31700,2,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',3160.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1946,7985,40767,31700,2,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1220.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL);
INSERT INTO `balance_libro` VALUES (1947,7985,40767,31700,2,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',3890.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1948,7985,40767,31700,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',3500.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1949,7985,40767,31700,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2350.00,NULL,NULL,1,'2023-01-12 23:16:41','2023-01-12 23:16:41',NULL),(1950,7985,40767,31700,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',230.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1951,7985,40767,31700,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1010.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1952,7985,40767,31700,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3600.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1953,7985,40767,31700,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',4900.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1954,7985,40767,31700,2,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2480.01,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1955,7985,40767,31700,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',740.04,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1956,7985,40767,31700,2,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1860.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1957,7985,40767,31700,2,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1180.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1958,7985,40767,31700,2,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2650.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1959,7985,40767,31700,2,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',12950.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1960,7985,40767,31700,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',6000.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1961,7985,40767,31700,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',410.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1962,7985,40767,31700,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1800.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1963,7985,40767,31700,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1350.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1964,7985,40767,31700,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2720.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1965,7985,40767,31700,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',780.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1966,7985,40767,31700,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1260.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1967,7985,40767,31700,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3150.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL);
INSERT INTO `balance_libro` VALUES (1968,7985,40767,31700,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1920.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1969,7985,40767,31700,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',7040.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1970,7985,40767,31700,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',6670.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1971,7985,40767,31700,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2540.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1972,7985,40767,31700,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',14970.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1973,7985,40767,31700,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',220.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1974,7985,40767,31700,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',9950.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1975,7985,40767,31700,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3420.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1976,7985,40767,31700,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',230.00,NULL,NULL,1,'2023-01-12 23:16:42','2023-01-12 23:16:42',NULL),(1977,7985,40767,31700,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',580.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1978,7985,40767,31700,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',420.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1979,7985,40767,31700,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',380.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1980,7985,40767,31700,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2040.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1981,7985,40767,31700,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2590.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1982,7985,40767,31700,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',380.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1983,7985,40767,31700,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',1300.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1984,7985,40767,31700,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',5600.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1985,7985,40767,31700,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3386.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1986,7985,40767,31700,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3120.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1987,7985,40767,31700,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',580.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1988,7985,40767,31700,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',4850.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL);
INSERT INTO `balance_libro` VALUES (1989,7985,40767,31700,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',10960.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1990,7985,40767,31700,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',5900.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1991,7985,40767,31700,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3700.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1992,7985,40767,31700,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1690.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1993,7985,40767,31700,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',13800.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1994,7985,40767,31700,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',7600.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1995,7985,40767,31700,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3550.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1996,7985,40767,31700,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',650.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1997,7985,40767,31700,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2615.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1998,7985,40767,31700,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1630.02,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(1999,7985,40767,31700,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3880.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(2000,7985,40767,31700,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',490.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(2001,7985,40767,31700,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3200.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(2002,7985,40767,31700,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',9400.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(2003,7985,40767,31700,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1640.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(2004,7985,40767,31700,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1430.00,NULL,NULL,1,'2023-01-12 23:16:43','2023-01-12 23:16:43',NULL),(2005,7985,40767,31700,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3520.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2006,7985,40767,31700,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',4877.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2007,7985,40767,31700,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',6130.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2008,7985,40767,31700,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',5060.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2009,7985,40767,31700,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1650.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL);
INSERT INTO `balance_libro` VALUES (2010,7985,40767,31700,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3526.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2011,7985,40767,31700,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1300.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2012,7985,40767,31700,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1490.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2013,7985,40767,31700,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1450.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2014,7985,40767,31700,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',5490.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2015,7985,40767,31700,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3331.75,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2016,7985,40767,31700,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3000.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2017,7985,40767,31700,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1595.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2018,7985,40767,31700,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',155.52,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2019,7985,40767,31700,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',536.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2020,7985,40767,31700,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',980.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2021,7985,40767,31700,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',930.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2022,7985,40767,31700,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',100.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2023,7985,40767,31700,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',4180.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2024,7985,40767,31700,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',3050.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2025,7985,40767,31700,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',770.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2026,7985,40767,31700,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',10700.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2027,7985,40767,31700,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1910.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2028,7985,40767,31700,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',3580.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2029,7985,40767,31700,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',3580.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2030,7985,40767,31700,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',3175.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL);
INSERT INTO `balance_libro` VALUES (2031,7985,40767,31700,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',360.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2032,7985,40767,31700,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1900.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2033,7985,40767,31700,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2720.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2034,7985,40767,31700,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2140.00,NULL,NULL,1,'2023-01-12 23:16:44','2023-01-12 23:16:44',NULL),(2035,7985,40767,31700,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',350.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2036,7985,40767,31700,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',150.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2037,7985,40767,31700,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2450.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2038,7985,40767,31700,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',12550.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2039,7985,40767,31700,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',7320.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2040,7985,40767,31700,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3290.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2041,7985,40767,31700,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1600.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2042,7985,40767,31700,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2200.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2043,7985,40767,31700,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3440.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2044,7985,40767,31700,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1780.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2045,7985,40767,31700,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5970.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2046,7985,40767,31700,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7610.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2047,7985,40767,31700,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1320.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2048,7985,40767,31700,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',16560.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2049,7985,40767,31700,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2630.00,NULL,NULL,1,'2023-01-12 23:16:45','2023-01-12 23:16:45',NULL),(2050,7985,40767,31700,7,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',161.69,NULL,NULL,1,'2023-01-17 07:36:27','2023-01-17 07:36:27',NULL),(2051,7985,40767,31700,7,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',141.40,NULL,NULL,1,'2023-01-17 07:36:27','2023-01-17 07:36:27',NULL);
INSERT INTO `balance_libro` VALUES (2052,7985,40767,31700,7,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',72.99,NULL,NULL,1,'2023-01-17 07:36:27','2023-01-17 07:36:27',NULL),(2053,7985,40767,31700,7,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',445.10,NULL,NULL,1,'2023-01-17 07:36:41','2023-01-17 07:36:41',NULL),(2054,7985,40767,31700,7,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',178.38,NULL,NULL,1,'2023-01-17 07:36:53','2023-01-17 07:36:53',NULL),(2055,7985,40767,31700,7,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',155.50,NULL,NULL,1,'2023-01-17 07:36:53','2023-01-17 07:36:53',NULL),(2056,7985,40721,3048,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',338800.00,NULL,NULL,1,'2023-02-01 15:44:21','2023-02-01 15:44:21',NULL),(2057,7985,40721,3048,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6039.08,NULL,NULL,1,'2023-02-01 15:49:39','2023-02-01 15:49:39',NULL),(2058,7985,40721,3048,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',26603.29,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2059,7985,40721,3048,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',843.37,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2060,7985,40721,3048,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',15000.00,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2061,7985,40721,3048,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',15000.00,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2062,7985,40721,3048,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',7523.95,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2063,7985,40721,3048,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1282.00,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2064,7985,40721,3048,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6865.46,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2065,7985,40721,3048,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',33500.00,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2066,7985,40721,3048,3,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',401.80,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2067,7985,40721,3048,3,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',8129.00,NULL,NULL,1,'2023-02-01 15:49:40','2023-02-01 15:49:40',NULL),(2068,7985,40721,3048,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',32417.21,NULL,NULL,1,'2023-02-01 15:49:41','2023-02-01 15:49:41',NULL),(2069,7985,40721,3048,3,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',14201.21,NULL,NULL,1,'2023-02-01 15:49:41','2023-02-01 15:49:41',NULL),(2070,7985,40721,3048,15,206,'App\\Models\\PeriodLiquidation',NULL,206,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',58885.42,NULL,NULL,1,'2023-02-05 12:51:11','2023-02-05 12:51:11',NULL),(2071,7985,40721,3048,16,207,'App\\Models\\PeriodLiquidation',NULL,207,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-02-05 12:53:11','2023-02-05 12:53:11',NULL),(2072,7985,40720,1533,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',45000.04,NULL,NULL,1,'2023-02-05 17:00:23','2023-02-05 17:00:23',NULL);
INSERT INTO `balance_libro` VALUES (2073,7985,40720,1533,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7000.04,NULL,NULL,1,'2023-02-05 17:00:23','2023-02-05 17:00:23',NULL),(2074,7985,40720,1533,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5000.02,NULL,NULL,1,'2023-02-05 17:00:23','2023-02-05 17:00:23',NULL),(2075,7985,40720,1533,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8000.00,NULL,NULL,1,'2023-02-05 17:00:23','2023-02-05 17:00:23',NULL),(2076,7985,40720,1533,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',24200.00,NULL,NULL,1,'2023-02-05 17:00:23','2023-02-05 17:00:23',NULL),(2077,7985,40720,1533,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7260.00,NULL,NULL,1,'2023-02-05 17:00:23','2023-02-05 17:00:23',NULL),(2078,7985,40720,1533,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6002.57,NULL,NULL,1,'2023-02-05 17:12:34','2023-02-05 17:14:31','2023-02-05 17:14:31'),(2079,7985,40720,1533,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1059.35,NULL,NULL,1,'2023-02-05 17:12:34','2023-02-05 17:14:40','2023-02-05 17:14:40'),(2080,7985,40720,1533,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10400.76,NULL,NULL,1,'2023-02-05 17:12:34','2023-02-05 17:14:48','2023-02-05 17:14:48'),(2081,7985,40720,1533,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3652.37,NULL,NULL,1,'2023-02-05 17:12:34','2023-02-05 17:14:55','2023-02-05 17:14:55'),(2082,7985,40720,1533,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6002.57,NULL,NULL,1,'2023-02-05 17:19:05','2023-02-05 17:19:05',NULL),(2083,7985,40720,1533,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1059.35,NULL,NULL,1,'2023-02-05 17:19:05','2023-02-05 17:19:05',NULL),(2084,7985,40720,1533,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10400.76,NULL,NULL,1,'2023-02-05 17:19:05','2023-02-05 17:19:05',NULL),(2085,7985,40720,1533,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3652.37,NULL,NULL,1,'2023-02-05 17:19:05','2023-02-05 17:19:05',NULL),(2086,7985,40720,1533,15,222,'App\\Models\\PeriodLiquidation',NULL,222,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16741.00,NULL,NULL,1,'2023-02-05 17:41:40','2023-02-05 17:41:40',NULL),(2087,7985,40720,1533,16,223,'App\\Models\\PeriodLiquidation',NULL,223,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3587.36,NULL,NULL,1,'2023-02-05 17:42:31','2023-04-22 16:29:37','2023-04-22 16:29:37'),(2175,7985,40767,31701,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3930.00,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2176,7985,40767,31701,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',11500.00,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2177,7985,40767,31701,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',21182.99,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2178,7985,40767,31701,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',15475.34,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2179,7985,40767,31701,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2155.00,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL);
INSERT INTO `balance_libro` VALUES (2180,7985,40767,31701,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5597.45,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2181,7985,40767,31701,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2370.00,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2182,7985,40767,31701,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1690.01,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2183,7985,40767,31701,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9014.16,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2184,7985,40767,31701,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1489.99,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2185,7985,40767,31701,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3979.69,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2186,7985,40767,31701,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3979.69,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2187,7985,40767,31701,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',731.52,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2188,7985,40767,31701,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1603.10,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2189,7985,40767,31701,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',516.44,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2190,7985,40767,31701,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7325.58,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2191,7985,40767,31701,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3979.69,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2192,7985,40767,31701,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',10454.50,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2193,7985,40767,31701,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1470.00,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2194,7985,40767,31701,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2299.00,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2195,7985,40767,31701,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',22780.00,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2196,7985,40767,31701,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3737.45,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2197,7985,40767,31701,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2183.63,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2198,7985,40767,31701,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',40238.96,NULL,NULL,1,'2023-02-05 18:22:32','2023-02-05 18:22:32',NULL),(2199,7985,40767,31701,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4040.02,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2200,7985,40767,31701,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',19420.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL);
INSERT INTO `balance_libro` VALUES (2201,7985,40767,31701,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9758.64,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2202,7985,40767,31701,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2305.03,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2203,7985,40767,31701,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',13331.05,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2204,7985,40767,31701,2,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6480.29,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2205,7985,40767,31701,2,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',27298.29,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2206,7985,40767,31701,2,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',50125.70,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2207,7985,40767,31701,2,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',622.04,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2208,7985,40767,31701,2,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',24636.23,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2209,7985,40767,31701,2,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',263.01,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2210,7985,40767,31701,2,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',20660.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2211,7985,40767,31701,2,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',890.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2212,7985,40767,31701,2,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3020.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2213,7985,40767,31701,2,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2100.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2214,7985,40767,31701,2,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2120.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2215,7985,40767,31701,2,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',790.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2216,7985,40767,31701,2,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',350.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2217,7985,40767,31701,2,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',990.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2218,7985,40767,31701,2,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4340.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2219,7985,40767,31701,2,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',710.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2220,7985,40767,31701,2,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2700.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2221,7985,40767,31701,2,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7610.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL);
INSERT INTO `balance_libro` VALUES (2222,7985,40767,31701,2,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3180.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2223,7985,40767,31701,2,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3950.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2224,7985,40767,31701,2,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3760.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2225,7985,40767,31701,2,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12620.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2226,7985,40767,31701,2,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7160.00,NULL,NULL,1,'2023-02-05 18:22:33','2023-02-05 18:22:33',NULL),(2227,7985,40767,31701,2,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2240.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2228,7985,40767,31701,2,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11500.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2229,7985,40767,31701,2,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7270.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2230,7985,40767,31701,2,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3180.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2231,7985,40767,31701,2,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',18520.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2232,7985,40767,31701,2,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',961.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2233,7985,40767,31701,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2885.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2234,7985,40767,31701,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2890.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2235,7985,40767,31701,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2730.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2236,7985,40767,31701,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',24550.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2237,7985,40767,31701,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',250.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2238,7985,40767,31701,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',47800.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2239,7985,40767,31701,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',850.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2240,7985,40767,31701,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6930.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2241,7985,40767,31701,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',430.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2242,7985,40767,31701,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1850.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL);
INSERT INTO `balance_libro` VALUES (2243,7985,40767,31701,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2060.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2244,7985,40767,31701,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3150.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2245,7985,40767,31701,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',390.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2246,7985,40767,31701,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2010.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2247,7985,40767,31701,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',14348.80,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2248,7985,40767,31701,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',200.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2249,7985,40767,31701,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1600.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2250,7985,40767,31701,2,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1230.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2251,7985,40767,31701,2,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2300.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2252,7985,40767,31701,2,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',900.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2253,7985,40767,31701,2,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3710.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2254,7985,40767,31701,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4500.00,NULL,NULL,1,'2023-02-05 18:22:34','2023-02-05 18:22:34',NULL),(2255,7985,40767,31701,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5210.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2256,7985,40767,31701,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',670.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2257,7985,40767,31701,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2920.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2258,7985,40767,31701,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',640.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2259,7985,40767,31701,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4040.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2260,7985,40767,31701,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2460.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2261,7985,40767,31701,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8340.20,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2262,7985,40767,31701,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',790.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2263,7985,40767,31701,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',19950.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL);
INSERT INTO `balance_libro` VALUES (2264,7985,40767,31701,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1105.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2265,7985,40767,31701,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',15480.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2266,7985,40767,31701,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',45000.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2267,7985,40767,31701,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3320.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2268,7985,40767,31701,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3157.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2269,7985,40767,31701,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',950.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2270,7985,40767,31701,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1400.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2271,7985,40767,31701,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3790.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2272,7985,40767,31701,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3880.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2273,7985,40767,31701,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3370.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2274,7985,40767,31701,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6680.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2275,7985,40767,31701,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',840.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2276,7985,40767,31701,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',700.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2277,7985,40767,31701,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4320.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2278,7985,40767,31701,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3200.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2279,7985,40767,31701,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2200.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2280,7985,40767,31701,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1580.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2281,7985,40767,31701,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3260.00,NULL,NULL,1,'2023-02-05 18:22:35','2023-02-05 18:22:35',NULL),(2282,7985,40767,31701,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2860.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2283,7985,40767,31701,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4440.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2284,7985,40767,31701,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2120.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL);
INSERT INTO `balance_libro` VALUES (2285,7985,40767,31701,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1850.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2286,7985,40767,31701,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',11060.01,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2287,7985,40767,31701,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1720.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2288,7985,40767,31701,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3200.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2289,7985,40767,31701,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4520.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2290,7985,40767,31701,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1350.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2291,7985,40767,31701,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1100.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2292,7985,40767,31701,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5180.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2293,7985,40767,31701,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2930.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2294,7985,40767,31701,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4820.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2295,7985,40767,31701,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2300.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2296,7985,40767,31701,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1780.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2297,7985,40767,31701,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',12890.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2298,7985,40767,31701,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2640.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2299,7985,40767,31701,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',510.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2300,7985,40767,31701,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',650.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2301,7985,40767,31701,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4850.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2302,7985,40767,31701,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',660.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2303,7985,40767,31701,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3490.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2304,7985,40767,31701,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',670.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2305,7985,40767,31701,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3345.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL);
INSERT INTO `balance_libro` VALUES (2306,7985,40767,31701,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1634.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2307,7985,40767,31701,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3460.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2308,7985,40767,31701,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10620.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2309,7985,40767,31701,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5300.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2310,7985,40767,31701,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1780.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2311,7985,40767,31701,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2700.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2312,7985,40767,31701,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3180.00,NULL,NULL,1,'2023-02-05 18:22:36','2023-02-05 18:22:36',NULL),(2313,7985,40767,31701,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2650.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2314,7985,40767,31701,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2550.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2315,7985,40767,31701,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1320.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2316,7985,40767,31701,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1960.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2317,7985,40767,31701,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',650.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2318,7985,40767,31701,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',9200.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2319,7985,40767,31701,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4300.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2320,7985,40767,31701,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6160.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2321,7985,40767,31701,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1800.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2322,7985,40767,31701,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2180.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2323,7985,40767,31701,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',610.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2324,7985,40767,31701,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3420.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2325,7985,40767,31701,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5220.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2326,7985,40767,31701,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2930.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL);
INSERT INTO `balance_libro` VALUES (2327,7985,40767,31701,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',370.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2328,7985,40767,31701,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1890.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2329,7985,40767,31701,2,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5305.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2330,7985,40767,31701,2,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2315.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2331,7985,40767,31701,2,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1570.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2332,7985,40767,31701,2,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2950.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2333,7985,40767,31701,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2530.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2334,7985,40767,31701,2,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7940.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2335,7985,40767,31701,2,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3005.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2336,7985,40767,31701,2,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1415.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2337,7985,40767,31701,2,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2630.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2338,7985,40767,31701,2,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2180.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2339,7985,40767,31701,2,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5585.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2340,7985,40767,31701,2,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4200.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2341,7985,40767,31701,2,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',7000.00,NULL,NULL,1,'2023-02-05 18:22:37','2023-02-05 18:22:37',NULL),(2342,7985,40767,31701,2,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2370.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2343,7985,40767,31701,2,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3000.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2344,7985,40767,31701,2,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2110.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2345,7985,40767,31701,2,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',520.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2346,7985,40767,31701,2,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1380.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2347,7985,40767,31701,2,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4299.80,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL);
INSERT INTO `balance_libro` VALUES (2348,7985,40767,31701,2,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1170.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2349,7985,40767,31701,2,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3600.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2350,7985,40767,31701,2,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7440.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2351,7985,40767,31701,2,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1670.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2352,7985,40767,31701,2,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4950.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2353,7985,40767,31701,2,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1100.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2354,7985,40767,31701,2,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3420.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2355,7985,40767,31701,2,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',11750.40,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2356,7985,40767,31701,2,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1288.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2357,7985,40767,31701,2,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',920.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2358,7985,40767,31701,2,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1170.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2359,7985,40767,31701,2,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',380.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2360,7985,40767,31701,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',750.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2361,7985,40767,31701,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',16000.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2362,7985,40767,31701,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2070.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2363,7985,40767,31701,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9600.00,NULL,NULL,1,'2023-02-05 18:22:38','2023-02-05 18:22:38',NULL),(2364,7985,40767,31701,2,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2380.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2365,7985,40767,31701,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',600.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2366,7985,40767,31701,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',280.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2367,7985,40767,31701,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',290.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2368,7985,40767,31701,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2110.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL);
INSERT INTO `balance_libro` VALUES (2369,7985,40767,31701,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',700.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2370,7985,40767,31701,2,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',760.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2371,7985,40767,31701,2,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3320.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2372,7985,40767,31701,2,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1300.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2373,7985,40767,31701,2,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1820.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2374,7985,40767,31701,2,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',42109.35,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2375,7985,40767,31701,2,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',6160.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2376,7985,40767,31701,2,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',210.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2377,7985,40767,31701,2,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3410.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2378,7985,40767,31701,2,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4565.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2379,7985,40767,31701,2,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4180.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2380,7985,40767,31701,2,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4600.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2381,7985,40767,31701,2,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1790.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2382,7985,40767,31701,2,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1160.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2383,7985,40767,31701,2,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4000.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2384,7985,40767,31701,2,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2690.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2385,7985,40767,31701,2,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3130.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2386,7985,40767,31701,2,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',715.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2387,7985,40767,31701,2,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',920.00,NULL,NULL,1,'2023-02-05 18:22:39','2023-02-05 18:22:39',NULL),(2388,7985,40767,31701,2,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',840.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2389,7985,40767,31701,2,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',760.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL);
INSERT INTO `balance_libro` VALUES (2390,7985,40767,31701,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',665.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2391,7985,40767,31701,2,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5810.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2392,7985,40767,31701,2,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3380.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2393,7985,40767,31701,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5090.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2394,7985,40767,31701,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',280.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2395,7985,40767,31701,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1040.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2396,7985,40767,31701,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5540.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2397,7985,40767,31701,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1920.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2398,7985,40767,31701,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',590.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2399,7985,40767,31701,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',170.04,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2400,7985,40767,31701,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4200.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2401,7985,40767,31701,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',480.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2402,7985,40767,31701,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4817.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2403,7985,40767,31701,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',130.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2404,7985,40767,31701,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2900.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2405,7985,40767,31701,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',480.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2406,7985,40767,31701,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6000.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2407,7985,40767,31701,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',640.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2408,7985,40767,31701,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',340.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2409,7985,40767,31701,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',860.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2410,7985,40767,31701,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',420.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL);
INSERT INTO `balance_libro` VALUES (2411,7985,40767,31701,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2908.60,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2412,7985,40767,31701,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',852.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2413,7985,40767,31701,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4840.00,NULL,NULL,1,'2023-02-05 18:22:40','2023-02-05 18:22:40',NULL),(2414,7985,40767,31701,2,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3100.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2415,7985,40767,31701,2,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',330.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2416,7985,40767,31701,2,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',780.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2417,7985,40767,31701,2,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1770.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2418,7985,40767,31701,2,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',715.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2419,7985,40767,31701,2,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1000.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2420,7985,40767,31701,2,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',700.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2421,7985,40767,31701,2,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3930.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2422,7985,40767,31701,2,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1200.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2423,7985,40767,31701,2,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',390.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2424,7985,40767,31701,2,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7000.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2425,7985,40767,31701,2,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2900.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2426,7985,40767,31701,2,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15000.00,NULL,NULL,1,'2023-02-05 18:22:41','2023-02-05 18:22:41',NULL),(2427,7985,40767,31700,15,202,'App\\Models\\PeriodLiquidation',NULL,202,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',266212.68,NULL,NULL,1,'2023-02-05 18:23:20','2023-02-05 18:23:20',NULL),(2428,7985,40767,31700,16,203,'App\\Models\\PeriodLiquidation',NULL,203,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',53443.41,NULL,NULL,1,'2023-02-05 18:23:29','2023-06-14 18:42:05','2023-06-14 18:42:05'),(2429,7985,40767,31701,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',10305.37,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2430,7985,40767,31701,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',30943.58,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL);
INSERT INTO `balance_libro` VALUES (2431,7985,40767,31701,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',22422.75,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2432,7985,40767,31701,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',29184.44,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2433,7985,40767,31701,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',50259.05,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2434,7985,40767,31701,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',32834.57,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2435,7985,40767,31701,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8421.42,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2436,7985,40767,31701,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',33557.38,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2437,7985,40767,31701,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',91968.33,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2438,7985,40767,31701,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',113544.15,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2439,7985,40767,31701,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',41898.25,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2440,7985,40767,31701,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3819.79,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2441,7985,40767,31701,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',538.13,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2442,7985,40767,31701,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6106.31,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2443,7985,40767,31701,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',29753.78,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2444,7985,40767,31701,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',100046.09,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2445,7985,40767,31701,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',34990.30,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2446,7985,40767,31701,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6292.69,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2447,7985,40767,31701,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',9304.23,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2448,7985,40767,31701,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3014.27,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2449,7985,40767,31701,3,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',239231.02,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2450,7985,40767,31701,3,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',13263.54,NULL,NULL,1,'2023-02-05 18:35:18','2023-02-05 18:35:18',NULL),(2451,7985,40767,31701,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11466.32,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL);
INSERT INTO `balance_libro` VALUES (2452,7985,40767,31701,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',33303.29,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2453,7985,40767,31701,3,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',95749.93,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2454,7985,40767,31701,3,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',65164.55,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2455,7985,40767,31701,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',15319.99,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2456,7985,40767,31701,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',124937.08,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2457,7985,40767,31701,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',5684.42,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2458,7985,40767,31701,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',59779.85,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2459,7985,40767,31701,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',58320.80,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2460,7985,40767,31701,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16500.00,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2461,7985,40767,31701,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1863.40,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2462,7985,40767,31701,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8898.75,NULL,NULL,1,'2023-02-05 18:35:19','2023-02-05 18:35:19',NULL),(2463,7985,40767,31701,7,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',158.48,NULL,NULL,1,'2023-02-06 11:03:43','2023-02-06 11:03:43',NULL),(2464,7985,40767,31701,7,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',73.50,NULL,NULL,1,'2023-02-06 11:03:43','2023-02-06 11:03:43',NULL),(2465,7985,40767,31701,15,228,'App\\Models\\PeriodLiquidation',NULL,228,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',233247.58,NULL,NULL,1,'2023-02-06 11:21:50','2023-02-06 11:21:50',NULL),(2466,7985,40767,31701,16,229,'App\\Models\\PeriodLiquidation',NULL,229,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',44695.46,NULL,NULL,1,'2023-02-06 11:30:20','2023-02-06 11:30:20',NULL),(2467,7985,40763,28698,2,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',147053.28,NULL,NULL,1,'2023-02-06 12:21:19','2023-02-06 12:21:19',NULL),(2468,7985,40763,28698,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5576.85,NULL,NULL,1,'2023-02-06 14:19:03','2023-02-06 14:19:03',NULL),(2469,7985,40763,28698,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2208.92,NULL,NULL,1,'2023-02-06 14:19:03','2023-02-06 14:19:03',NULL),(2470,7985,40763,28698,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',43509.18,NULL,NULL,1,'2023-02-06 14:19:03','2023-02-06 14:19:03',NULL),(2471,7985,40763,28698,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6715.50,NULL,NULL,1,'2023-02-06 14:19:03','2023-02-06 14:19:03',NULL);
INSERT INTO `balance_libro` VALUES (2472,7985,40763,28698,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6715.50,NULL,NULL,1,'2023-02-06 14:19:03','2023-02-06 14:19:03',NULL),(2473,7985,40763,28698,15,234,'App\\Models\\PeriodLiquidation',NULL,234,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',25521.64,NULL,NULL,1,'2023-02-06 16:53:08','2023-02-06 16:53:08',NULL),(2474,7985,40763,28698,16,235,'App\\Models\\PeriodLiquidation',NULL,235,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',36.31,NULL,NULL,1,'2023-02-10 14:01:49','2023-02-10 14:32:11','2023-02-10 14:32:11'),(2475,7985,40763,28698,16,236,'App\\Models\\PeriodLiquidation',NULL,236,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',26.69,NULL,NULL,1,'2023-02-10 14:49:21','2023-02-10 14:49:21',NULL),(2476,7985,40721,3049,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3602.25,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2477,7985,40721,3049,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',35000.00,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2478,7985,40721,3049,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',32539.47,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2479,7985,40721,3049,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',14650.00,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2480,7985,40721,3049,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1025.72,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2481,7985,40721,3049,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',5971.42,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2482,7985,40721,3049,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',88431.72,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2483,7985,40721,3049,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',102324.33,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2484,7985,40721,3049,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',8141.64,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2485,7985,40721,3049,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',19094.51,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2486,7985,40721,3049,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',3655.00,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2487,7985,40721,3049,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',42333.00,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2488,7985,40721,3049,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3630.00,NULL,NULL,1,'2023-03-01 22:35:34','2023-03-01 22:35:34',NULL),(2489,7985,40721,3049,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',34650.00,NULL,NULL,1,'2023-03-01 22:35:35','2023-03-01 22:35:35',NULL),(2490,7985,40721,3049,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7176.24,NULL,NULL,1,'2023-03-01 22:35:35','2023-03-01 22:35:35',NULL),(2491,7985,40721,3049,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',81804.76,NULL,NULL,1,'2023-03-01 22:35:35','2023-03-01 22:35:35',NULL);
INSERT INTO `balance_libro` VALUES (2492,7985,40721,3049,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',9119.37,NULL,NULL,1,'2023-03-01 22:35:35','2023-03-01 22:35:35',NULL),(2493,7985,40721,3049,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',8698.48,NULL,NULL,1,'2023-03-01 22:35:35','2023-03-01 22:35:35',NULL),(2494,7985,40721,3049,2,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',423500.00,NULL,NULL,1,'2023-03-03 07:58:24','2023-03-03 07:58:24',NULL),(2495,7985,40720,1534,2,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7260.00,NULL,NULL,1,'2023-03-05 20:55:37','2023-03-05 20:55:37',NULL),(2496,7985,40720,1534,2,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',5000.02,NULL,NULL,1,'2023-03-05 20:55:37','2023-03-05 20:55:37',NULL),(2497,7985,40720,1534,2,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',8000.00,NULL,NULL,1,'2023-03-05 20:55:37','2023-03-05 20:55:37',NULL),(2498,7985,40720,1534,2,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',45000.04,NULL,NULL,1,'2023-03-05 20:55:37','2023-03-05 20:55:37',NULL),(2499,7985,40720,1534,2,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',24200.00,NULL,NULL,1,'2023-03-05 20:55:37','2023-03-05 20:55:37',NULL),(2500,7985,40720,1534,2,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7000.04,NULL,NULL,1,'2023-03-05 20:55:37','2023-03-05 20:55:37',NULL),(2501,7985,40720,1534,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4394.42,NULL,NULL,1,'2023-03-05 20:55:51','2023-03-05 20:55:51',NULL),(2502,7985,40720,1534,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',45024.66,NULL,NULL,1,'2023-03-05 20:55:51','2023-03-05 20:55:51',NULL),(2503,7985,40720,1534,15,247,'App\\Models\\PeriodLiquidation',NULL,247,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16741.00,NULL,NULL,1,'2023-03-05 21:21:25','2023-03-05 21:21:25',NULL),(2504,7985,40720,1534,16,248,'App\\Models\\PeriodLiquidation',NULL,248,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3587.36,NULL,NULL,1,'2023-03-05 21:23:25','2023-03-05 21:23:25',NULL),(2505,7985,40763,28699,2,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',34046.50,NULL,NULL,1,'2023-03-05 23:31:31','2023-03-05 23:31:31',NULL),(2506,7985,40763,28699,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2208.92,NULL,NULL,1,'2023-03-05 23:33:12','2023-03-05 23:33:12',NULL),(2507,7985,40763,28699,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5612.43,NULL,NULL,1,'2023-03-05 23:33:12','2023-03-05 23:33:12',NULL),(2508,7985,40763,28699,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',3788.44,NULL,NULL,1,'2023-03-05 23:33:12','2023-03-05 23:33:12',NULL),(2509,7985,40763,28699,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1980.02,NULL,NULL,1,'2023-03-05 23:33:12','2023-03-05 23:33:12',NULL),(2510,7985,40763,28699,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',7590.00,NULL,NULL,1,'2023-03-05 23:33:12','2023-03-05 23:33:12',NULL),(2511,7985,40763,28699,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7100.28,NULL,NULL,1,'2023-03-05 23:33:12','2023-03-05 23:33:12',NULL),(2512,7985,40721,3049,15,241,'App\\Models\\PeriodLiquidation',NULL,241,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',73500.00,NULL,NULL,1,'2023-03-07 20:29:35','2023-03-07 20:29:35',NULL);
INSERT INTO `balance_libro` VALUES (2513,7985,40721,3049,16,242,'App\\Models\\PeriodLiquidation',NULL,242,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-07 20:30:24','2023-03-07 20:30:24',NULL),(2514,7985,40763,28699,15,253,'App\\Models\\PeriodLiquidation',NULL,253,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5908.90,NULL,NULL,1,'2023-03-08 16:15:20','2023-03-08 16:15:20',NULL),(2515,7985,40763,28699,16,254,'App\\Models\\PeriodLiquidation',NULL,254,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6.18,NULL,NULL,1,'2023-03-08 17:04:06','2023-06-14 18:44:38','2023-06-14 18:44:38'),(2516,7985,40767,31702,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1350.00,NULL,NULL,1,'2023-03-08 17:29:38','2023-03-08 17:29:38',NULL),(2517,7985,40767,31702,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',30390.80,NULL,NULL,1,'2023-03-08 17:29:38','2023-03-08 17:29:38',NULL),(2518,7985,40767,31702,2,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1090.00,NULL,NULL,1,'2023-03-08 17:29:38','2023-03-08 17:29:38',NULL),(2519,7985,40767,31702,2,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3400.00,NULL,NULL,1,'2023-03-08 17:29:38','2023-03-08 17:29:38',NULL),(2520,7985,40767,31702,2,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',847.00,NULL,NULL,1,'2023-03-08 17:29:38','2023-03-08 17:29:38',NULL),(2521,7985,40767,31702,2,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3625.00,NULL,NULL,1,'2023-03-08 17:29:38','2023-03-08 17:29:38',NULL),(2522,7985,40767,31702,2,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3215.00,NULL,NULL,1,'2023-03-08 17:29:38','2023-03-08 17:29:38',NULL),(2523,7985,40767,31702,2,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',4130.40,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2524,7985,40767,31702,2,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',3110.13,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2525,7985,40767,31702,2,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',9000.10,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2526,7985,40767,31702,2,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',650.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2527,7985,40767,31702,2,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',7290.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2528,7985,40767,31702,2,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',3280.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2529,7985,40767,31702,2,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',11400.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2530,7985,40767,31702,2,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1190.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2531,7985,40767,31702,2,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',170.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2532,7985,40767,31702,2,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',7000.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL);
INSERT INTO `balance_libro` VALUES (2533,7985,40767,31702,2,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',5515.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2534,7985,40767,31702,2,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',39643.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2535,7985,40767,31702,2,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2022.50,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2536,7985,40767,31702,2,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',770.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2537,7985,40767,31702,2,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',570.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2538,7985,40767,31702,2,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',390.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2539,7985,40767,31702,2,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4030.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2540,7985,40767,31702,2,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4900.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2541,7985,40767,31702,2,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',26700.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2542,7985,40767,31702,2,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1260.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2543,7985,40767,31702,2,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4160.06,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2544,7985,40767,31702,2,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2060.00,NULL,NULL,1,'2023-03-08 17:29:39','2023-03-08 17:29:39',NULL),(2545,7985,40767,31702,2,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',730.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2546,7985,40767,31702,2,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2170.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2547,7985,40767,31702,2,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',9580.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2548,7985,40767,31702,2,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2240.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2549,7985,40767,31702,2,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',550.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2550,7985,40767,31702,2,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4535.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2551,7985,40767,31702,2,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',11400.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2552,7985,40767,31702,2,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',300.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2553,7985,40767,31702,2,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1730.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL);
INSERT INTO `balance_libro` VALUES (2554,7985,40767,31702,2,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1100.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2555,7985,40767,31702,2,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1632.05,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2556,7985,40767,31702,2,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',20124.84,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2557,7985,40767,31702,2,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',3500.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2558,7985,40767,31702,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',6500.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2559,7985,40767,31702,2,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',2050.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2560,7985,40767,31702,2,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',310.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2561,7985,40767,31702,2,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',6000.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2562,7985,40767,31702,2,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4050.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2563,7985,40767,31702,2,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',42861.41,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2564,7985,40767,31702,2,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',6994.30,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2565,7985,40767,31702,2,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',12117.12,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2566,7985,40767,31702,2,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1877.86,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2567,7985,40767,31702,2,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1360.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2568,7985,40767,31702,2,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7870.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2569,7985,40767,31702,2,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4370.00,NULL,NULL,1,'2023-03-08 17:29:40','2023-03-08 17:29:40',NULL),(2570,7985,40767,31702,2,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4375.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2571,7985,40767,31702,2,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3860.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2572,7985,40767,31702,2,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',6820.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2573,7985,40767,31702,2,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1550.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2574,7985,40767,31702,2,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2840.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL);
INSERT INTO `balance_libro` VALUES (2575,7985,40767,31702,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1500.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2576,7985,40767,31702,2,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',630.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2577,7985,40767,31702,2,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1320.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2578,7985,40767,31702,2,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1220.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2579,7985,40767,31702,2,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',850.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2580,7985,40767,31702,2,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3700.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2581,7985,40767,31702,2,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4020.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2582,7985,40767,31702,2,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2203.41,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2583,7985,40767,31702,2,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',11889.09,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2584,7985,40767,31702,2,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1795.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2585,7985,40767,31702,2,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',6000.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2586,7985,40767,31702,2,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',270.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2587,7985,40767,31702,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2500.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2588,7985,40767,31702,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',980.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2589,7985,40767,31702,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2321.50,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2590,7985,40767,31702,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2706.63,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2591,7985,40767,31702,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',6350.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2592,7985,40767,31702,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2650.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2593,7985,40767,31702,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2135.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2594,7985,40767,31702,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',150.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2595,7985,40767,31702,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3070.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL);
INSERT INTO `balance_libro` VALUES (2596,7985,40767,31702,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3680.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2597,7985,40767,31702,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1820.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2598,7985,40767,31702,2,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1420.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2599,7985,40767,31702,2,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',11440.01,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2600,7985,40767,31702,2,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',21270.00,NULL,NULL,1,'2023-03-08 17:29:41','2023-03-08 17:29:41',NULL),(2601,7985,40767,31702,2,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',5703.98,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2602,7985,40767,31702,2,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',740.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2603,7985,40767,31702,2,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',500.01,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2604,7985,40767,31702,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',380.51,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2605,7985,40767,31702,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',10502.87,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2606,7985,40767,31702,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',770.65,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2607,7985,40767,31702,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',12842.50,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2608,7985,40767,31702,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',14571.57,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2609,7985,40767,31702,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',7870.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2610,7985,40767,31702,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5010.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2611,7985,40767,31702,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',4770.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2612,7985,40767,31702,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2800.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2613,7985,40767,31702,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2360.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2614,7985,40767,31702,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',3900.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2615,7985,40767,31702,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',675.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2616,7985,40767,31702,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2184.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL);
INSERT INTO `balance_libro` VALUES (2617,7985,40767,31702,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2573.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2618,7985,40767,31702,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5800.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2619,7985,40767,31702,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',3200.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2620,7985,40767,31702,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',9220.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2621,7985,40767,31702,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',3120.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2622,7985,40767,31702,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',4186.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2623,7985,40767,31702,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',3230.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2624,7985,40767,31702,2,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',4850.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2625,7985,40767,31702,2,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',4360.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2626,7985,40767,31702,2,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',433.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2627,7985,40767,31702,2,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2690.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2628,7985,40767,31702,2,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',10870.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2629,7985,40767,31702,2,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1550.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2630,7985,40767,31702,2,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',975.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2631,7985,40767,31702,2,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1500.00,NULL,NULL,1,'2023-03-08 17:29:42','2023-03-08 17:29:42',NULL),(2632,7985,40767,31702,2,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',340.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2633,7985,40767,31702,2,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',500.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2634,7985,40767,31702,2,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',3150.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2635,7985,40767,31702,2,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',750.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2636,7985,40767,31702,2,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',870.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2637,7985,40767,31702,2,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',21312.29,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL);
INSERT INTO `balance_libro` VALUES (2638,7985,40767,31702,2,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',10832.42,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2639,7985,40767,31702,2,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',11479.10,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2640,7985,40767,31702,2,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',13575.68,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2641,7985,40767,31702,2,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',5459.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2642,7985,40767,31702,2,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1600.01,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2643,7985,40767,31702,2,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',25000.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2644,7985,40767,31702,2,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',620.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2645,7985,40767,31702,2,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1100.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2646,7985,40767,31702,2,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',750.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2647,7985,40767,31702,2,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',12635.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2648,7985,40767,31702,2,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2105.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2649,7985,40767,31702,2,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',19070.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2650,7985,40767,31702,2,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',480.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2651,7985,40767,31702,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',11970.18,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2652,7985,40767,31702,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',6960.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2653,7985,40767,31702,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',10600.00,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2654,7985,40767,31702,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4626.90,NULL,NULL,1,'2023-03-08 17:29:43','2023-03-08 17:29:43',NULL),(2655,7985,40767,31702,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6775.93,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2656,7985,40767,31702,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',23000.07,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2657,7985,40767,31702,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',31000.01,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2658,7985,40767,31702,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',480.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL);
INSERT INTO `balance_libro` VALUES (2659,7985,40767,31702,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',21129.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2660,7985,40767,31702,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2800.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2661,7985,40767,31702,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1410.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2662,7985,40767,31702,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',805.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2663,7985,40767,31702,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1090.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2664,7985,40767,31702,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1500.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2665,7985,40767,31702,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',4400.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2666,7985,40767,31702,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3180.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2667,7985,40767,31702,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',290.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2668,7985,40767,31702,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1710.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2669,7985,40767,31702,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',18660.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2670,7985,40767,31702,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',710.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2671,7985,40767,31702,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3135.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2672,7985,40767,31702,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',8380.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2673,7985,40767,31702,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',14225.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2674,7985,40767,31702,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',950.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2675,7985,40767,31702,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1120.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2676,7985,40767,31702,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1400.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2677,7985,40767,31702,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',70.00,NULL,NULL,1,'2023-03-08 17:29:44','2023-03-08 17:29:44',NULL),(2678,7985,40767,31702,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1250.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2679,7985,40767,31702,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',4140.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL);
INSERT INTO `balance_libro` VALUES (2680,7985,40767,31702,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',7470.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2681,7985,40767,31702,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1640.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2682,7985,40767,31702,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1470.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2683,7985,40767,31702,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',390.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2684,7985,40767,31702,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',7590.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2685,7985,40767,31702,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',7320.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2686,7985,40767,31702,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',2100.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2687,7985,40767,31702,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',7890.00,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2688,7985,40767,31702,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',12466.55,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2689,7985,40767,31702,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',5890.42,NULL,NULL,1,'2023-03-08 17:29:45','2023-03-08 17:29:45',NULL),(2690,7985,40767,31702,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1050.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2691,7985,40767,31702,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',900.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2692,7985,40767,31702,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1600.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2693,7985,40767,31702,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',24000.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2694,7985,40767,31702,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2450.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2695,7985,40767,31702,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',45000.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2696,7985,40767,31702,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',11630.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2697,7985,40767,31702,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',860.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2698,7985,40767,31702,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',600.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2699,7985,40767,31702,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1300.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2700,7985,40767,31702,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',6260.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL);
INSERT INTO `balance_libro` VALUES (2701,7985,40767,31702,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1040.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2702,7985,40767,31702,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',810.00,NULL,NULL,1,'2023-03-08 17:29:46','2023-03-08 17:29:46',NULL),(2703,7985,40767,31702,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8566.00,NULL,NULL,1,'2023-03-08 17:29:47','2023-03-08 17:29:47',NULL),(2704,7985,40767,31702,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3401.85,NULL,NULL,1,'2023-03-08 17:29:47','2023-03-08 17:29:47',NULL),(2705,7985,40767,31702,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13620.00,NULL,NULL,1,'2023-03-08 17:29:47','2023-03-08 17:29:47',NULL),(2706,7985,40767,31702,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3140.00,NULL,NULL,1,'2023-03-08 17:29:47','2023-03-08 17:29:47',NULL),(2707,7985,40767,31702,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2800.00,NULL,NULL,1,'2023-03-08 17:29:47','2023-03-08 17:29:47',NULL),(2708,7985,40767,31702,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1350.00,NULL,NULL,1,'2023-03-08 17:29:47','2023-03-08 17:29:47',NULL),(2709,7985,40767,31702,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3410.00,NULL,NULL,1,'2023-03-08 17:29:47','2023-03-08 17:29:47',NULL),(2710,7985,40767,31702,3,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',13154.91,NULL,NULL,1,'2023-03-08 17:35:22','2023-03-08 17:35:22',NULL),(2711,7985,40767,31702,3,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9181.01,NULL,NULL,1,'2023-03-08 17:35:22','2023-03-08 17:35:22',NULL),(2712,7985,40767,31702,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',72000.00,NULL,NULL,1,'2023-03-08 17:35:22','2023-03-08 17:35:22',NULL),(2713,7985,40767,31702,3,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',3193.64,NULL,NULL,1,'2023-03-08 17:35:22','2023-03-08 17:35:22',NULL),(2714,7985,40767,31702,3,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',36735.30,NULL,NULL,1,'2023-03-08 17:35:22','2023-03-08 17:35:22',NULL),(2715,7985,40767,31702,3,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2349.02,NULL,NULL,1,'2023-03-08 17:35:22','2023-03-08 17:35:22',NULL),(2716,7985,40767,31702,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',11109.31,NULL,NULL,1,'2023-03-08 17:35:22','2023-03-08 17:35:22',NULL),(2717,7985,40767,31702,3,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',126000.95,NULL,NULL,1,'2023-03-08 17:35:22','2023-03-08 17:35:22',NULL),(2718,7985,40767,31702,3,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',54729.82,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2719,7985,40767,31702,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',8756.77,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2720,7985,40767,31702,3,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',5887.13,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2721,7985,40767,31702,3,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',833.39,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL);
INSERT INTO `balance_libro` VALUES (2722,7985,40767,31702,3,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',12488.40,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2723,7985,40767,31702,3,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',62898.91,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2724,7985,40767,31702,3,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',23062.65,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2725,7985,40767,31702,3,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',35910.40,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2726,7985,40767,31702,3,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',47835.75,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2727,7985,40767,31702,3,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',48209.05,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2728,7985,40767,31702,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',13437.81,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2729,7985,40767,31702,3,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',13437.81,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2730,7985,40767,31702,3,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2968.83,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2731,7985,40767,31702,3,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2968.83,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2732,7985,40767,31702,3,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',40603.60,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2733,7985,40767,31702,3,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2523.25,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2734,7985,40767,31702,3,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1234.66,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2735,7985,40767,31702,3,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2331.23,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2736,7985,40767,31702,3,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1.21,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2737,7985,40767,31702,3,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',71719.20,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2738,7985,40767,31702,3,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',113462.66,NULL,NULL,1,'2023-03-08 17:35:23','2023-03-08 17:35:23',NULL),(2739,7985,40767,31702,3,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',11475.07,NULL,NULL,1,'2023-03-08 17:35:24','2023-03-08 17:35:24',NULL),(2740,7985,40767,31702,3,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',63929.79,NULL,NULL,1,'2023-03-08 17:35:24','2023-03-08 17:35:24',NULL),(2741,7985,40767,31702,3,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',34654.63,NULL,NULL,1,'2023-03-08 17:35:24','2023-03-08 17:35:24',NULL),(2742,7985,40767,31702,7,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',252.17,NULL,NULL,1,'2023-03-08 18:19:50','2023-03-08 18:19:50',NULL);
INSERT INTO `balance_libro` VALUES (2743,7985,40767,31702,7,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',108.95,NULL,NULL,1,'2023-03-08 18:20:00','2023-03-08 18:20:00',NULL),(2744,7985,40767,31702,7,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',76.35,NULL,NULL,1,'2023-03-08 18:20:00','2023-03-08 18:20:00',NULL),(2745,7985,40767,31702,7,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',76.35,NULL,NULL,1,'2023-03-08 18:20:00','2023-03-08 18:20:00',NULL),(2746,7985,40767,31702,7,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',76.35,NULL,NULL,1,'2023-03-08 18:20:00','2023-03-08 18:20:00',NULL),(2747,7985,40767,31702,7,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',166.98,NULL,NULL,1,'2023-03-08 18:20:00','2023-03-08 18:20:00',NULL),(2748,7985,40767,31702,15,263,'App\\Models\\PeriodLiquidation',NULL,263,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',202430.41,NULL,NULL,1,'2023-03-08 18:26:46','2023-07-02 18:28:36','2023-07-02 18:28:36'),(2749,7985,40767,31702,16,264,'App\\Models\\PeriodLiquidation',NULL,264,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',40834.55,NULL,NULL,1,'2023-03-08 18:30:24','2023-03-08 18:30:24',NULL),(2750,7985,41102,40788,2,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12080.00,NULL,NULL,1,'2023-03-10 09:53:55','2023-03-10 09:53:55',NULL),(2751,7985,41102,40788,2,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',32900.00,NULL,NULL,1,'2023-03-10 09:53:55','2023-03-10 09:53:55',NULL),(2752,7985,41102,40788,2,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',9200.00,NULL,NULL,1,'2023-03-10 09:53:55','2023-03-10 09:53:55',NULL),(2753,7985,41102,40788,2,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10070.00,NULL,NULL,1,'2023-03-10 09:53:55','2023-03-10 09:53:55',NULL),(2754,7985,41102,40788,2,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-10 09:53:55','2023-03-10 09:53:55',NULL),(2755,7985,41102,40789,2,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',29050.00,NULL,NULL,1,'2023-03-10 10:06:00','2023-03-10 10:06:00',NULL),(2756,7985,41102,40789,2,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',20250.00,NULL,NULL,1,'2023-03-10 10:06:00','2023-03-10 10:06:00',NULL),(2757,7985,41102,40789,2,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',26670.00,NULL,NULL,1,'2023-03-10 10:06:00','2023-03-10 10:06:00',NULL),(2758,7985,41102,40789,2,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',10300.00,NULL,NULL,1,'2023-03-10 10:06:00','2023-03-10 10:06:00',NULL),(2759,7985,40721,3033,3,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',923.63,NULL,NULL,1,'2023-03-16 11:51:49','2023-03-16 11:51:49',NULL),(2760,7985,40721,3033,3,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',3103.33,NULL,NULL,1,'2023-03-16 11:51:49','2023-03-16 11:51:49',NULL),(2761,7985,40721,3033,3,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',637.66,NULL,NULL,1,'2023-03-16 11:51:49','2023-03-16 11:51:49',NULL),(2762,7985,40721,3033,3,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',17396.75,NULL,NULL,1,'2023-03-16 11:51:49','2023-03-16 11:51:49',NULL);
INSERT INTO `balance_libro` VALUES (2763,7985,40721,3033,3,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',3701.75,NULL,NULL,1,'2023-03-16 11:51:49','2023-03-16 11:51:49',NULL),(2764,7985,40721,3033,3,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',4000.00,NULL,NULL,1,'2023-03-16 11:51:49','2023-03-16 11:51:49',NULL),(2765,7985,40721,3033,3,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',30648.94,NULL,NULL,1,'2023-03-16 11:51:49','2023-03-16 11:51:49',NULL),(2766,7985,40721,3033,3,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',12165.00,NULL,NULL,1,'2023-03-16 11:51:50','2023-03-16 11:51:50',NULL),(2767,7985,40721,3033,3,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',69496.86,NULL,NULL,1,'2023-03-16 11:51:50','2023-03-16 11:51:50',NULL),(2768,7985,40721,3033,3,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',134593.35,NULL,NULL,1,'2023-03-16 11:51:50','2023-03-16 11:51:50',NULL),(2769,7985,40721,3033,3,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',126960.86,NULL,NULL,1,'2023-03-16 11:51:50','2023-03-16 11:51:50',NULL),(2770,7985,40721,3033,3,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',730.00,NULL,NULL,1,'2023-03-16 11:51:50','2023-03-16 11:51:50',NULL),(2771,7985,40721,3033,3,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',10227.44,NULL,NULL,1,'2023-03-16 11:51:50','2023-03-16 11:51:50',NULL),(2772,7985,40721,3033,16,279,'App\\Models\\PeriodLiquidation',NULL,279,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',972.58,NULL,NULL,1,'2023-03-16 12:02:28','2023-03-16 12:26:09','2023-03-16 12:26:09'),(2773,7985,40721,3033,15,278,'App\\Models\\PeriodLiquidation',NULL,278,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',49428.87,NULL,NULL,1,'2023-03-16 12:03:15','2023-03-16 12:26:00','2023-03-16 12:26:00'),(2774,7985,40721,3033,2,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',100000.00,NULL,NULL,1,'2023-03-16 12:27:17','2023-03-16 12:27:17',NULL),(2775,7985,40721,3034,2,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',75000.02,NULL,NULL,1,'2023-03-17 20:18:55','2023-03-17 20:18:55',NULL),(2776,7985,40721,3034,2,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',75000.02,NULL,NULL,1,'2023-03-17 20:18:55','2023-03-17 20:18:55',NULL),(2777,7985,40721,3034,2,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',150000.02,NULL,NULL,1,'2023-03-17 20:18:55','2023-03-17 20:18:55',NULL),(2778,7985,40721,3034,2,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',150000.02,NULL,NULL,1,'2023-03-17 20:18:56','2023-03-17 20:18:56',NULL),(2779,7985,40721,3034,2,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',3000.00,NULL,NULL,1,'2023-03-17 20:18:56','2023-03-17 20:18:56',NULL),(2780,7985,40721,3034,2,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',18000.00,NULL,NULL,1,'2023-03-17 20:18:56','2023-03-17 20:18:56',NULL),(2781,7985,40721,3034,2,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-13','2022-02-13',3000.00,NULL,NULL,1,'2023-03-17 20:18:56','2023-03-17 20:18:56',NULL),(2782,7985,40721,3034,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1784.29,NULL,NULL,1,'2023-03-17 20:19:11','2023-03-17 20:19:11',NULL);
INSERT INTO `balance_libro` VALUES (2783,7985,40721,3034,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',3677.56,NULL,NULL,1,'2023-03-17 20:19:11','2023-03-17 20:19:11',NULL),(2784,7985,40721,3034,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1130.00,NULL,NULL,1,'2023-03-17 20:19:11','2023-03-17 20:19:11',NULL),(2785,7985,40721,3034,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1830.17,NULL,NULL,1,'2023-03-17 20:19:11','2023-03-17 20:19:11',NULL),(2786,7985,40721,3034,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',20500.00,NULL,NULL,1,'2023-03-17 20:19:11','2023-03-17 20:19:11',NULL),(2787,7985,40721,3034,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',360.00,NULL,NULL,1,'2023-03-17 20:19:12','2023-03-17 20:19:12',NULL),(2788,7985,40721,3034,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',94761.00,NULL,NULL,1,'2023-03-17 20:19:12','2023-03-17 20:19:12',NULL),(2789,7985,40721,3034,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',94761.00,NULL,NULL,1,'2023-03-17 20:19:12','2023-03-17 20:19:12',NULL),(2790,7985,40721,3034,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',3701.75,NULL,NULL,1,'2023-03-17 20:19:12','2023-03-17 20:19:12',NULL),(2791,7985,40721,3034,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',94761.00,NULL,NULL,1,'2023-03-17 20:19:12','2023-03-17 20:19:12',NULL),(2792,7985,40721,3034,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',2777.80,NULL,NULL,1,'2023-03-17 20:19:12','2023-03-17 20:19:12',NULL),(2793,7985,40721,3034,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',73723.12,NULL,NULL,1,'2023-03-17 20:19:12','2023-03-17 20:19:12',NULL),(2794,7985,40721,3035,2,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',36000.06,NULL,NULL,1,'2023-03-17 20:19:56','2023-03-17 20:19:56',NULL),(2795,7985,40721,3035,2,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',12000.05,NULL,NULL,1,'2023-03-17 20:19:56','2023-03-17 20:19:56',NULL),(2796,7985,40721,3035,2,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',120000.04,NULL,NULL,1,'2023-03-17 20:19:56','2023-03-17 20:19:56',NULL),(2797,7985,40721,3035,2,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',100000.00,NULL,NULL,1,'2023-03-17 20:19:56','2023-03-17 20:19:56',NULL),(2798,7985,40721,3035,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1159.52,NULL,NULL,1,'2023-03-17 20:20:09','2023-03-17 20:20:09',NULL),(2799,7985,40721,3035,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3627.14,NULL,NULL,1,'2023-03-17 20:20:09','2023-03-17 20:20:09',NULL),(2800,7985,40721,3035,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',46226.77,NULL,NULL,1,'2023-03-17 20:20:09','2023-03-17 20:20:09',NULL),(2801,7985,40721,3035,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1830.17,NULL,NULL,1,'2023-03-17 20:20:09','2023-03-17 20:20:09',NULL),(2802,7985,40721,3035,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',40467.46,NULL,NULL,1,'2023-03-17 20:20:09','2023-03-17 20:20:09',NULL),(2803,7985,40721,3035,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',3923.86,NULL,NULL,1,'2023-03-17 20:20:09','2023-03-17 20:20:09',NULL);
INSERT INTO `balance_libro` VALUES (2804,7985,40721,3035,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',11107.80,NULL,NULL,1,'2023-03-17 20:20:09','2023-03-17 20:20:09',NULL),(2805,7985,40721,3035,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',117059.54,NULL,NULL,1,'2023-03-17 20:20:10','2023-03-17 20:20:10',NULL),(2806,7985,40721,3035,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',35653.37,NULL,NULL,1,'2023-03-17 20:20:10','2023-03-17 20:20:10',NULL),(2807,7985,40721,3035,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',61599.24,NULL,NULL,1,'2023-03-17 20:20:10','2023-03-17 20:20:10',NULL),(2808,7985,40721,3035,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',30858.51,NULL,NULL,1,'2023-03-17 20:20:10','2023-03-17 20:20:10',NULL),(2809,7985,40721,3035,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',13324.13,NULL,NULL,1,'2023-03-17 20:20:10','2023-03-17 20:20:10',NULL),(2810,7985,40721,3035,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',730.00,NULL,NULL,1,'2023-03-17 20:20:10','2023-03-17 20:20:10',NULL),(2811,7985,40721,3035,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',387790.00,NULL,NULL,1,'2023-03-17 20:20:10','2023-03-17 20:20:10',NULL),(2812,7985,40721,3036,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',4610.37,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2813,7985,40721,3036,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1784.29,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2814,7985,40721,3036,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',11395.04,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2815,7985,40721,3036,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',40253.91,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2816,7985,40721,3036,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',20953.73,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2817,7985,40721,3036,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',549.46,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2818,7985,40721,3036,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',197438.58,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2819,7985,40721,3036,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',5949.12,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2820,7985,40721,3036,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',4182.43,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2821,7985,40721,3036,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',5500.00,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2822,7985,40721,3036,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',5870.00,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2823,7985,40721,3036,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',25497.68,NULL,NULL,1,'2023-03-17 20:20:45','2023-03-17 20:20:45',NULL),(2824,7985,40721,3036,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',40060.13,NULL,NULL,1,'2023-03-17 20:20:46','2023-03-17 20:20:46',NULL);
INSERT INTO `balance_libro` VALUES (2825,7985,40721,3036,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1410.00,NULL,NULL,1,'2023-03-17 20:20:46','2023-03-17 20:20:46',NULL),(2826,7985,40721,3036,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',54520.00,NULL,NULL,1,'2023-03-17 20:20:46','2023-03-17 20:20:46',NULL),(2827,7985,40721,3036,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',25153.51,NULL,NULL,1,'2023-03-17 20:20:46','2023-03-17 20:20:46',NULL),(2828,7985,40721,3036,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',27562.40,NULL,NULL,1,'2023-03-17 20:20:46','2023-03-17 20:20:46',NULL),(2829,7985,40721,3036,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',730.00,NULL,NULL,1,'2023-03-17 20:20:46','2023-03-17 20:20:46',NULL),(2830,7985,40721,3036,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',163895.41,NULL,NULL,1,'2023-03-17 20:20:46','2023-03-17 20:20:46',NULL),(2831,7985,40721,3037,2,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',266200.00,NULL,NULL,1,'2023-03-17 20:23:36','2023-03-17 20:23:36',NULL),(2832,7985,40721,3037,2,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',242000.00,NULL,NULL,1,'2023-03-17 20:23:37','2023-03-17 20:23:37',NULL),(2833,7985,40721,3037,2,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',150000.02,NULL,NULL,1,'2023-03-17 20:23:37','2023-03-17 20:23:37',NULL),(2834,7985,40721,3037,2,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',300000.03,NULL,NULL,1,'2023-03-17 20:23:37','2023-03-17 20:23:37',NULL),(2835,7985,40721,3037,2,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',150000.02,NULL,NULL,1,'2023-03-17 20:23:37','2023-03-17 20:23:37',NULL),(2836,7985,40721,3037,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1154.54,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2837,7985,40721,3037,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',3625.20,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2838,7985,40721,3037,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',3124.21,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2839,7985,40721,3037,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',4467.37,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2840,7985,40721,3037,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',84421.07,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2841,7985,40721,3037,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',631.39,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2842,7985,40721,3037,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',2781.92,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2843,7985,40721,3037,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',9462.80,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2844,7985,40721,3037,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',21900.00,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2845,7985,40721,3037,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',5018.91,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL);
INSERT INTO `balance_libro` VALUES (2846,7985,40721,3037,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',93672.65,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2847,7985,40721,3037,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',118687.97,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2848,7985,40721,3037,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',119170.01,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2849,7985,40721,3037,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',10577.80,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2850,7985,40721,3037,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-22','2022-05-22',13000.00,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2851,7985,40721,3037,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',56953.05,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2852,7985,40721,3037,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',730.00,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2853,7985,40721,3037,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',50796.24,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2854,7985,40721,3037,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',24159.92,NULL,NULL,1,'2023-03-17 20:27:04','2023-03-17 20:27:04',NULL),(2855,7985,40721,3038,2,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',26000.04,NULL,NULL,1,'2023-03-17 20:28:44','2023-03-17 20:28:44',NULL),(2856,7985,40721,3038,2,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',17545.00,NULL,NULL,1,'2023-03-17 20:28:44','2023-03-17 20:28:44',NULL),(2857,7985,40721,3038,2,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',181500.00,NULL,NULL,1,'2023-03-17 20:28:44','2023-03-17 20:28:44',NULL),(2858,7985,40721,3038,2,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',60500.00,NULL,NULL,1,'2023-03-17 20:28:44','2023-03-17 20:28:44',NULL),(2859,7985,40721,3038,2,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',23000.06,NULL,NULL,1,'2023-03-17 20:28:44','2023-03-17 20:28:44',NULL),(2860,7985,40721,3038,2,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',24000.00,NULL,NULL,1,'2023-03-17 20:28:44','2023-03-17 20:28:44',NULL),(2861,7985,40721,3038,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',1249.02,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2862,7985,40721,3038,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',3499.66,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2863,7985,40721,3038,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',7819.88,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2864,7985,40721,3038,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',48965.58,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2865,7985,40721,3038,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',21552.03,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2866,7985,40721,3038,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',17930.00,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL);
INSERT INTO `balance_libro` VALUES (2867,7985,40721,3038,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',120134.02,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2868,7985,40721,3038,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',631.39,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2869,7985,40721,3038,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',40461.59,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2870,7985,40721,3038,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',32035.46,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2871,7985,40721,3038,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',26290.00,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2872,7985,40721,3038,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',8470.00,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2873,7985,40721,3038,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',5018.91,NULL,NULL,1,'2023-03-17 20:28:55','2023-03-17 20:28:55',NULL),(2874,7985,40721,3038,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',22141.55,NULL,NULL,1,'2023-03-17 20:28:56','2023-03-17 20:28:56',NULL),(2875,7985,40721,3038,3,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',62947.03,NULL,NULL,1,'2023-03-17 20:28:56','2023-03-17 20:28:56',NULL),(2876,7985,40721,3038,3,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',34703.16,NULL,NULL,1,'2023-03-17 20:28:56','2023-03-17 20:28:56',NULL),(2877,7985,40721,3038,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',13605.15,NULL,NULL,1,'2023-03-17 20:28:56','2023-03-17 20:28:56',NULL),(2878,7985,40721,3038,3,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',19720.00,NULL,NULL,1,'2023-03-17 20:28:56','2023-03-17 20:28:56',NULL),(2879,7985,40721,3038,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',87060.95,NULL,NULL,1,'2023-03-17 20:28:56','2023-03-17 20:28:56',NULL),(2880,7985,40721,3038,3,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',10018.27,NULL,NULL,1,'2023-03-17 20:28:56','2023-03-17 20:28:56',NULL),(2881,7985,40721,3039,2,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',42000.04,NULL,NULL,1,'2023-03-17 20:29:13','2023-03-17 20:29:13',NULL),(2882,7985,40721,3039,2,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',15000.03,NULL,NULL,1,'2023-03-17 20:29:13','2023-03-17 20:29:13',NULL),(2883,7985,40721,3039,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',160000.02,NULL,NULL,1,'2023-03-17 20:29:13','2023-03-17 20:29:13',NULL),(2884,7985,40721,3039,2,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',200000.00,NULL,NULL,1,'2023-03-17 20:29:13','2023-03-17 20:29:13',NULL),(2885,7985,40721,3039,2,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',269201.60,NULL,NULL,1,'2023-03-17 20:29:13','2023-03-17 20:29:13',NULL),(2886,7985,40721,3039,3,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2913.37,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2887,7985,40721,3039,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',22260.13,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL);
INSERT INTO `balance_libro` VALUES (2888,7985,40721,3039,3,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',21124.47,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2889,7985,40721,3039,3,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',23740.20,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2890,7985,40721,3039,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',631.39,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2891,7985,40721,3039,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',10187.52,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2892,7985,40721,3039,3,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2711.00,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2893,7985,40721,3039,3,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5269.75,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2894,7985,40721,3039,3,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',10770.05,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2895,7985,40721,3039,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',7028.80,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2896,7985,40721,3039,3,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',87241.00,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2897,7985,40721,3039,3,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',54414.61,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2898,7985,40721,3039,3,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',29911.08,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2899,7985,40721,3039,3,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',6663.01,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2900,7985,40721,3039,3,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5445.00,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2901,7985,40721,3039,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',22830.00,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2902,7985,40721,3039,3,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',381900.00,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2903,7985,40721,3039,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',21599.49,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2904,7985,40721,3039,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',28517.61,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2905,7985,40721,3039,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',6775.75,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2906,7985,40721,3039,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',49852.00,NULL,NULL,1,'2023-03-17 20:29:27','2023-03-17 20:29:27',NULL),(2907,7985,40721,3040,2,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',51000.00,NULL,NULL,1,'2023-03-17 20:29:42','2023-03-17 20:29:42',NULL),(2908,7985,40721,3040,2,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',423500.00,NULL,NULL,1,'2023-03-17 20:29:42','2023-03-17 20:29:42',NULL);
INSERT INTO `balance_libro` VALUES (2909,7985,40721,3040,2,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',290400.00,NULL,NULL,1,'2023-03-17 20:29:42','2023-03-17 20:29:42',NULL),(2910,7985,40721,3040,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2982.84,NULL,NULL,1,'2023-03-17 20:29:51','2023-03-17 20:29:51',NULL),(2911,7985,40721,3040,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',248868.36,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2912,7985,40721,3040,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',33291.90,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2913,7985,40721,3040,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',70483.00,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2914,7985,40721,3040,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',726.87,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2915,7985,40721,3040,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',7180.87,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2916,7985,40721,3040,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1249.02,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2917,7985,40721,3040,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',4356.32,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2918,7985,40721,3040,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',85578.86,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2919,7985,40721,3040,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',5902.91,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2920,7985,40721,3040,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',11296.29,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2921,7985,40721,3040,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2468.99,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2922,7985,40721,3040,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2042.38,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2923,7985,40721,3040,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',4009.30,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2924,7985,40721,3040,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',115169.67,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2925,7985,40721,3040,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',114790.55,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2926,7985,40721,3040,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1621.03,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2927,7985,40721,3040,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',115169.67,NULL,NULL,1,'2023-03-17 20:29:52','2023-03-17 20:29:52',NULL),(2928,7985,40721,3040,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',12055.23,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2929,7985,40721,3040,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',24593.60,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL);
INSERT INTO `balance_libro` VALUES (2930,7985,40721,3040,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',22830.00,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2931,7985,40721,3040,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',10114.45,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2932,7985,40721,3040,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',103200.00,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2933,7985,40721,3040,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',43750.00,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2934,7985,40721,3040,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',103200.00,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2935,7985,40721,3040,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',121116.00,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2936,7985,40721,3040,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',950.00,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2937,7985,40721,3040,3,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10103.88,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2938,7985,40721,3040,3,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',8317.26,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2939,7985,40721,3040,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',52877.00,NULL,NULL,1,'2023-03-17 20:29:53','2023-03-17 20:29:53',NULL),(2940,7985,40721,3041,2,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',140000.00,NULL,NULL,1,'2023-03-17 20:32:37','2023-03-17 20:32:37',NULL),(2941,7985,40721,3041,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',17000.00,NULL,NULL,1,'2023-03-17 20:32:37','2023-03-17 20:32:37',NULL),(2942,7985,40721,3041,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',140000.00,NULL,NULL,1,'2023-03-17 20:32:37','2023-03-17 20:32:37',NULL),(2943,7985,40721,3041,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',45000.04,NULL,NULL,1,'2023-03-17 20:32:37','2023-03-17 20:32:37',NULL),(2944,7985,40721,3041,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',140000.00,NULL,NULL,1,'2023-03-17 20:32:37','2023-03-17 20:32:37',NULL),(2945,7985,40721,3041,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',140000.00,NULL,NULL,1,'2023-03-17 20:32:37','2023-03-17 20:32:37',NULL),(2946,7985,40721,3041,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',140000.00,NULL,NULL,1,'2023-03-17 20:32:37','2023-03-17 20:32:37',NULL),(2947,7985,40721,3041,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',140000.00,NULL,NULL,1,'2023-03-17 20:32:38','2023-03-17 20:32:38',NULL),(2948,7985,40721,3041,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',45900.04,NULL,NULL,1,'2023-03-17 20:32:38','2023-03-17 20:32:38',NULL),(2949,7985,40721,3041,2,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',140000.00,NULL,NULL,1,'2023-03-17 20:32:38','2023-03-17 20:32:38',NULL),(2950,7985,40721,3041,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',140000.00,NULL,NULL,1,'2023-03-17 20:32:38','2023-03-17 20:32:38',NULL);
INSERT INTO `balance_libro` VALUES (2951,7985,40721,3041,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',60000.00,NULL,NULL,1,'2023-03-17 20:32:38','2023-03-17 20:32:38',NULL),(2952,7985,40721,3041,3,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',3199.94,NULL,NULL,1,'2023-03-17 20:32:50','2023-03-17 20:32:50',NULL),(2953,7985,40721,3041,3,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',23429.32,NULL,NULL,1,'2023-03-17 20:32:50','2023-03-17 20:32:50',NULL),(2954,7985,40721,3041,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',63231.84,NULL,NULL,1,'2023-03-17 20:32:50','2023-03-17 20:32:50',NULL),(2955,7985,40721,3041,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',10050.00,NULL,NULL,1,'2023-03-17 20:32:50','2023-03-17 20:32:50',NULL),(2956,7985,40721,3041,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',166600.00,NULL,NULL,1,'2023-03-17 20:32:50','2023-03-17 20:32:50',NULL),(2957,7985,40721,3041,3,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',726.87,NULL,NULL,1,'2023-03-17 20:32:50','2023-03-17 20:32:50',NULL),(2958,7985,40721,3041,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',10350.00,NULL,NULL,1,'2023-03-17 20:32:50','2023-03-17 20:32:50',NULL),(2959,7985,40721,3041,3,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',5902.91,NULL,NULL,1,'2023-03-17 20:32:50','2023-03-17 20:32:50',NULL),(2960,7985,40721,3041,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',142997.80,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2961,7985,40721,3041,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',142997.80,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2962,7985,40721,3041,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',143000.00,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2963,7985,40721,3041,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',35062.30,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2964,7985,40721,3041,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',25984.64,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2965,7985,40721,3041,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',25470.00,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2966,7985,40721,3041,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',120745.70,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2967,7985,40721,3041,3,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',7108.75,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2968,7985,40721,3041,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',67599.00,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2969,7985,40721,3041,3,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',52060.63,NULL,NULL,1,'2023-03-17 20:32:51','2023-03-17 20:32:51',NULL),(2970,7985,40721,3050,2,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',72600.00,NULL,NULL,1,'2023-04-01 14:39:23','2023-04-01 14:39:23',NULL),(2971,7985,40721,3050,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',30000.00,NULL,NULL,1,'2023-04-01 14:39:23','2023-04-01 14:39:23',NULL);
INSERT INTO `balance_libro` VALUES (2972,7985,40721,3050,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',350900.00,NULL,NULL,1,'2023-04-01 14:39:23','2023-04-01 14:39:23',NULL),(2973,7985,40721,3050,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',50000.00,NULL,NULL,1,'2023-04-01 14:39:23','2023-04-01 14:39:23',NULL),(2974,7985,40721,3050,2,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',180000.02,NULL,NULL,1,'2023-04-01 14:39:23','2023-04-01 14:39:23',NULL),(2975,7985,40721,3050,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',4033.04,NULL,NULL,1,'2023-04-01 14:39:38','2023-04-01 14:39:38',NULL),(2976,7985,40721,3050,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5347.68,NULL,NULL,1,'2023-04-01 14:39:38','2023-04-01 14:39:38',NULL),(2977,7985,40721,3050,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1051.99,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2978,7985,40721,3050,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8764.86,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2979,7985,40721,3050,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',279579.55,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2980,7985,40721,3050,3,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',109374.58,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2981,7985,40721,3050,3,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',20720.00,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2982,7985,40721,3050,3,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',19966.96,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2983,7985,40721,3050,3,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8458.84,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2984,7985,40721,3050,3,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',22535.39,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2985,7985,40721,3050,3,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',159242.90,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2986,7985,40721,3050,3,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',40000.00,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2987,7985,40721,3050,3,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',58367.42,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2988,7985,40721,3050,3,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',8601.49,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2989,7985,40721,3050,3,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1500.00,NULL,NULL,1,'2023-04-01 14:39:39','2023-04-01 14:39:39',NULL),(2990,7985,40720,1535,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5000.02,NULL,NULL,1,'2023-04-03 15:37:06','2023-04-03 15:37:06',NULL),(2991,7985,40720,1535,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7260.00,NULL,NULL,1,'2023-04-03 15:37:06','2023-04-03 15:37:06',NULL),(2992,7985,40720,1535,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7000.04,NULL,NULL,1,'2023-04-03 15:37:06','2023-04-03 15:37:06',NULL);
INSERT INTO `balance_libro` VALUES (2993,7985,40720,1535,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',45000.04,NULL,NULL,1,'2023-04-03 15:37:06','2023-04-03 15:37:06',NULL),(2994,7985,40720,1535,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7000.04,NULL,NULL,1,'2023-04-03 15:37:06','2023-04-03 15:37:06',NULL),(2995,7985,40720,1535,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',24200.00,NULL,NULL,1,'2023-04-03 15:37:06','2023-04-03 15:37:06',NULL),(2996,7985,40720,1535,2,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',8000.00,NULL,NULL,1,'2023-04-03 15:37:06','2023-04-03 15:37:06',NULL),(2997,7985,40720,1535,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7000.04,NULL,NULL,1,'2023-04-03 15:37:06','2023-04-03 15:37:06',NULL),(2998,7985,40720,1535,3,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',4509.96,NULL,NULL,1,'2023-04-03 15:37:25','2023-04-03 15:37:25',NULL),(2999,7985,40720,1535,3,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',67536.99,NULL,NULL,1,'2023-04-03 15:37:25','2023-04-03 15:37:25',NULL),(3000,7985,40720,1535,3,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',2140.01,NULL,NULL,1,'2023-04-03 15:37:25','2023-04-03 15:37:25',NULL),(3001,7985,40720,1535,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1919.72,NULL,NULL,1,'2023-04-03 15:37:25','2023-04-03 15:37:25',NULL),(3002,7985,40720,1535,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',864.00,NULL,NULL,1,'2023-04-03 15:37:25','2023-04-03 15:37:25',NULL),(3003,7985,40763,28700,2,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',34871.23,NULL,NULL,1,'2023-04-12 17:39:38','2023-04-12 17:39:38',NULL),(3004,7985,40763,28700,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2302.81,NULL,NULL,1,'2023-04-12 17:39:50','2023-04-12 17:39:50',NULL),(3005,7985,40763,28700,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5990.95,NULL,NULL,1,'2023-04-12 17:39:50','2023-04-12 17:39:50',NULL),(3006,7985,40763,28700,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',9500.00,NULL,NULL,1,'2023-04-12 17:39:50','2023-04-12 17:39:50',NULL),(3007,7985,40763,28700,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',7625.42,NULL,NULL,1,'2023-04-12 17:39:50','2023-04-12 17:39:50',NULL),(3008,7985,40763,28700,16,337,'App\\Models\\PeriodLiquidation',NULL,337,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6.33,NULL,NULL,1,'2023-04-12 18:50:11','2023-10-24 13:05:14','2023-10-24 13:05:14'),(3009,7985,41102,40790,2,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',23700.00,NULL,NULL,1,'2023-04-13 14:10:15','2023-04-13 14:10:15',NULL),(3010,7985,41102,40790,2,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',28100.00,NULL,NULL,1,'2023-04-13 14:10:15','2023-04-13 14:10:15',NULL),(3011,7985,41102,40790,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',27500.00,NULL,NULL,1,'2023-04-13 14:10:15','2023-04-13 14:10:15',NULL),(3012,7985,41102,40790,2,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',37000.00,NULL,NULL,1,'2023-04-13 14:10:15','2023-04-13 14:10:15',NULL),(3013,7985,41102,40790,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',31750.00,NULL,NULL,1,'2023-04-13 14:10:15','2023-04-13 14:10:15',NULL);
INSERT INTO `balance_libro` VALUES (3014,7985,41102,40790,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',29920.00,NULL,NULL,1,'2023-04-13 14:10:15','2023-04-13 14:10:15',NULL),(3015,7985,41102,40790,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',23700.00,NULL,NULL,1,'2023-04-13 14:10:15','2023-04-13 14:10:15',NULL),(3016,7985,41102,40790,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',23700.00,NULL,NULL,1,'2023-04-13 14:10:15','2023-04-13 14:10:15',NULL),(3017,7985,41102,40790,16,339,'App\\Models\\PeriodLiquidation',NULL,339,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8008.65,NULL,NULL,1,'2023-04-13 14:59:05','2023-04-13 14:59:05',NULL),(3018,7985,41102,40789,16,268,'App\\Models\\PeriodLiquidation',NULL,268,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3882.15,NULL,NULL,1,'2023-04-13 14:59:14','2023-04-13 14:59:14',NULL),(3019,7985,41102,40788,16,267,'App\\Models\\PeriodLiquidation',NULL,267,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2891.25,NULL,NULL,1,'2023-04-13 14:59:21','2023-04-13 14:59:21',NULL),(3020,7985,40720,1518,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',21780.00,NULL,NULL,1,'2023-04-17 13:50:14','2023-04-17 13:50:14',NULL),(3021,7985,40720,1518,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',7260.00,NULL,NULL,1,'2023-04-17 13:50:15','2023-04-17 13:50:15',NULL),(3022,7985,40720,1518,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',5000.00,NULL,NULL,1,'2023-04-17 13:50:15','2023-04-17 13:50:15',NULL),(3023,7985,40720,1518,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',30250.00,NULL,NULL,1,'2023-04-17 13:50:15','2023-04-17 13:50:15',NULL),(3024,7985,40720,1518,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',7000.00,NULL,NULL,1,'2023-04-17 13:50:15','2023-04-17 13:50:15',NULL),(3025,7985,40720,1519,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',21780.00,NULL,NULL,1,'2023-04-17 13:50:55','2023-04-17 13:50:55',NULL),(3026,7985,40720,1519,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',7260.00,NULL,NULL,1,'2023-04-17 13:50:55','2023-04-17 13:50:55',NULL),(3027,7985,40720,1519,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',5000.00,NULL,NULL,1,'2023-04-17 13:50:55','2023-04-17 13:50:55',NULL),(3028,7985,40720,1519,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',30250.00,NULL,NULL,1,'2023-04-17 13:50:55','2023-04-17 13:50:55',NULL),(3029,7985,40720,1519,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',7000.00,NULL,NULL,1,'2023-04-17 13:50:55','2023-04-17 13:50:55',NULL),(3030,7985,40720,1520,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',21780.00,NULL,NULL,1,'2023-04-17 14:07:37','2023-04-17 14:07:37',NULL),(3031,7985,40720,1520,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',7260.00,NULL,NULL,1,'2023-04-17 14:07:37','2023-04-17 14:07:37',NULL),(3032,7985,40720,1520,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',5000.00,NULL,NULL,1,'2023-04-17 14:07:37','2023-04-17 14:07:37',NULL),(3033,7985,40720,1520,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',30250.00,NULL,NULL,1,'2023-04-17 14:07:38','2023-04-17 14:07:38',NULL),(3034,7985,40720,1520,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',7000.00,NULL,NULL,1,'2023-04-17 14:07:38','2023-04-17 14:07:38',NULL);
INSERT INTO `balance_libro` VALUES (3035,7985,40720,1536,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',21780.00,NULL,NULL,1,'2023-04-17 21:02:38','2023-04-18 17:19:03','2023-04-18 17:19:03'),(3036,7985,40720,1536,2,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',7260.00,NULL,NULL,1,'2023-04-17 21:02:38','2023-04-18 17:19:03','2023-04-18 17:19:03'),(3037,7985,40720,1536,2,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',5000.00,NULL,NULL,1,'2023-04-17 21:02:38','2023-04-18 17:19:03','2023-04-18 17:19:03'),(3038,7985,40720,1536,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',30250.00,NULL,NULL,1,'2023-04-17 21:02:38','2023-04-18 17:19:03','2023-04-18 17:19:03'),(3039,7985,40720,1536,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',7000.00,NULL,NULL,1,'2023-04-17 21:02:38','2023-04-18 17:19:03','2023-04-18 17:19:03'),(3040,7985,40720,1537,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',21780.00,NULL,NULL,1,'2023-04-17 21:04:35','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3041,7985,40720,1537,2,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',7260.00,NULL,NULL,1,'2023-04-17 21:04:35','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3042,7985,40720,1537,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',5000.00,NULL,NULL,1,'2023-04-17 21:04:35','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3043,7985,40720,1537,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',30250.00,NULL,NULL,1,'2023-04-17 21:04:35','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3044,7985,40720,1537,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',7000.00,NULL,NULL,1,'2023-04-17 21:04:35','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3045,7985,40720,1537,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',18000.00,NULL,NULL,1,'2023-04-17 21:04:35','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3046,7985,40720,1537,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',24000.00,NULL,NULL,1,'2023-04-17 21:04:35','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3047,7985,40720,1537,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',21780.00,NULL,NULL,1,'2023-04-17 21:04:35','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3048,7985,40720,1537,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',30250.00,NULL,NULL,1,'2023-04-17 21:04:35','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3049,7985,40720,1537,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',5000.00,NULL,NULL,1,'2023-04-17 21:04:52','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3050,7985,40720,1537,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',7260.00,NULL,NULL,1,'2023-04-17 21:04:52','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3051,7985,40720,1537,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',7000.00,NULL,NULL,1,'2023-04-17 21:04:52','2023-04-18 07:53:44','2023-04-18 07:53:44'),(3052,7985,40720,1537,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',18000.00,NULL,NULL,1,'2023-04-17 21:04:52','2023-04-18 07:53:05','2023-04-18 07:53:05'),(3053,7985,40720,1537,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',8000.00,NULL,NULL,1,'2023-04-17 21:04:52','2023-04-18 07:52:52','2023-04-18 07:52:52');
INSERT INTO `balance_libro` VALUES (3054,7985,40720,1537,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',45000.00,NULL,NULL,1,'2023-04-17 21:04:52','2023-04-18 07:52:46','2023-04-18 07:52:46'),(3055,7985,40720,1537,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5000.00,NULL,NULL,1,'2023-04-17 21:05:05','2023-04-18 07:52:40','2023-04-18 07:52:40'),(3056,7985,40720,1537,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7260.00,NULL,NULL,1,'2023-04-17 21:05:05','2023-04-18 07:52:29','2023-04-18 07:52:29'),(3057,7985,40720,1537,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7000.00,NULL,NULL,1,'2023-04-17 21:05:05','2023-04-18 07:52:23','2023-04-18 07:52:23'),(3058,7985,40720,1537,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',18000.00,NULL,NULL,1,'2023-04-17 21:05:05','2023-04-18 07:52:18','2023-04-18 07:52:18'),(3059,7985,40720,1537,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',8000.00,NULL,NULL,1,'2023-04-17 21:05:05','2023-04-18 07:52:13','2023-04-18 07:52:13'),(3060,7985,40720,1537,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',18000.00,NULL,NULL,1,'2023-04-17 21:05:05','2023-04-18 07:52:08','2023-04-18 07:52:08'),(3061,7985,40720,1537,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',45000.00,NULL,NULL,1,'2023-04-17 21:05:05','2023-04-18 07:51:55','2023-04-18 07:51:55'),(3062,7985,40720,1537,2,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',8000.00,NULL,NULL,1,'2023-04-17 21:05:26','2023-04-18 07:51:50','2023-04-18 07:51:50'),(3063,7985,40720,1537,2,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',45000.00,NULL,NULL,1,'2023-04-17 21:05:26','2023-04-18 07:51:45','2023-04-18 07:51:45'),(3064,7985,40720,1537,2,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',5000.00,NULL,NULL,1,'2023-04-17 21:05:26','2023-04-18 07:51:41','2023-04-18 07:51:41'),(3065,7985,40720,1537,2,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',7260.00,NULL,NULL,1,'2023-04-17 21:05:27','2023-04-18 07:51:36','2023-04-18 07:51:36'),(3066,7985,40720,1537,2,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',7000.00,NULL,NULL,1,'2023-04-17 21:05:27','2023-04-18 07:51:28','2023-04-18 07:51:28'),(3067,7985,40720,1537,2,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',24200.00,NULL,NULL,1,'2023-04-17 21:05:27','2023-04-18 07:51:23','2023-04-18 07:51:23'),(3068,7985,40720,1541,2,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',24200.00,NULL,NULL,1,'2023-04-17 21:05:41','2023-04-18 07:51:19','2023-04-18 07:51:19'),(3069,7985,40720,1541,2,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',7000.00,NULL,NULL,1,'2023-04-17 21:05:41','2023-04-18 07:51:09','2023-04-18 07:51:09'),(3070,7985,40720,1541,2,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',7260.00,NULL,NULL,1,'2023-04-17 21:05:41','2023-04-18 07:51:04','2023-04-18 07:51:04'),(3071,7985,40720,1541,2,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',5000.00,NULL,NULL,1,'2023-04-17 21:05:41','2023-04-18 07:50:59','2023-04-18 07:50:59'),(3072,7985,40720,1541,2,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',45000.00,NULL,NULL,1,'2023-04-17 21:05:41','2023-04-18 07:50:52','2023-04-18 07:50:52');
INSERT INTO `balance_libro` VALUES (3073,7985,40720,1541,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',8000.00,NULL,NULL,1,'2023-04-17 21:05:41','2023-04-18 07:50:39','2023-04-18 07:50:39'),(3074,7985,40720,1537,2,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',21780.00,NULL,NULL,1,'2023-04-18 07:55:06','2023-04-18 07:56:06','2023-04-18 07:56:06'),(3075,7985,40720,1537,2,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',7260.00,NULL,NULL,1,'2023-04-18 07:55:06','2023-04-18 07:56:06','2023-04-18 07:56:06'),(3076,7985,40720,1537,2,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',5000.00,NULL,NULL,1,'2023-04-18 07:55:06','2023-04-18 07:56:06','2023-04-18 07:56:06'),(3077,7985,40720,1537,2,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',30250.00,NULL,NULL,1,'2023-04-18 07:55:06','2023-04-18 07:56:06','2023-04-18 07:56:06'),(3078,7985,40720,1537,2,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',7000.00,NULL,NULL,1,'2023-04-18 07:55:06','2023-04-18 07:56:06','2023-04-18 07:56:06'),(3079,7985,40720,1537,2,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',18000.00,NULL,NULL,1,'2023-04-18 07:55:06','2023-04-18 07:56:06','2023-04-18 07:56:06'),(3080,7985,40720,1537,2,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',24000.00,NULL,NULL,1,'2023-04-18 07:55:06','2023-04-18 07:56:06','2023-04-18 07:56:06'),(3081,7985,40720,1537,2,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',21780.00,NULL,NULL,1,'2023-04-18 07:55:06','2023-04-18 07:56:06','2023-04-18 07:56:06'),(3082,7985,40720,1537,2,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',30250.00,NULL,NULL,1,'2023-04-18 07:55:06','2023-04-18 07:56:06','2023-04-18 07:56:06'),(3083,7985,40720,1522,2,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',21780.00,NULL,NULL,1,'2023-04-18 07:58:19','2023-04-18 07:58:19',NULL),(3084,7985,40720,1522,2,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',7260.00,NULL,NULL,1,'2023-04-18 07:58:19','2023-04-18 07:58:19',NULL),(3085,7985,40720,1522,2,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',5000.00,NULL,NULL,1,'2023-04-18 07:58:19','2023-04-18 07:58:19',NULL),(3086,7985,40720,1522,2,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',30250.00,NULL,NULL,1,'2023-04-18 07:58:19','2023-04-18 07:58:19',NULL),(3087,7985,40720,1522,2,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',7000.00,NULL,NULL,1,'2023-04-18 07:58:19','2023-04-18 07:58:19',NULL),(3088,7985,40720,1522,2,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',18000.00,NULL,NULL,1,'2023-04-18 07:58:19','2023-04-18 07:58:19',NULL),(3089,7985,40720,1522,2,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',24000.00,NULL,NULL,1,'2023-04-18 07:58:19','2023-04-18 07:58:19',NULL),(3090,7985,40720,1522,2,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',21780.00,NULL,NULL,1,'2023-04-18 07:58:19','2023-04-18 07:58:19',NULL),(3091,7985,40720,1522,2,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',30250.00,NULL,NULL,1,'2023-04-18 07:58:19','2023-04-18 07:58:19',NULL),(3092,7985,40720,1523,2,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',5000.00,NULL,NULL,1,'2023-04-18 08:09:58','2023-04-18 08:09:58',NULL);
INSERT INTO `balance_libro` VALUES (3093,7985,40720,1523,2,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',7260.00,NULL,NULL,1,'2023-04-18 08:09:58','2023-04-18 08:09:58',NULL),(3094,7985,40720,1523,2,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',7000.00,NULL,NULL,1,'2023-04-18 08:09:58','2023-04-18 08:09:58',NULL),(3095,7985,40720,1523,2,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',18000.00,NULL,NULL,1,'2023-04-18 08:09:58','2023-04-18 08:09:58',NULL),(3096,7985,40720,1523,2,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',8000.00,NULL,NULL,1,'2023-04-18 08:09:58','2023-04-18 08:09:58',NULL),(3097,7985,40720,1523,2,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',45000.00,NULL,NULL,1,'2023-04-18 08:09:58','2023-04-18 08:09:58',NULL),(3098,7985,40720,1524,2,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5000.00,NULL,NULL,1,'2023-04-18 08:12:32','2023-04-18 08:12:32',NULL),(3099,7985,40720,1524,2,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7260.00,NULL,NULL,1,'2023-04-18 08:12:32','2023-04-18 08:12:32',NULL),(3100,7985,40720,1524,2,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7000.00,NULL,NULL,1,'2023-04-18 08:12:32','2023-04-18 08:12:32',NULL),(3101,7985,40720,1524,2,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',18000.00,NULL,NULL,1,'2023-04-18 08:12:32','2023-04-18 08:12:32',NULL),(3102,7985,40720,1524,2,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',8000.00,NULL,NULL,1,'2023-04-18 08:12:32','2023-04-18 08:12:32',NULL),(3103,7985,40720,1524,2,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',18000.00,NULL,NULL,1,'2023-04-18 08:12:32','2023-04-18 08:12:32',NULL),(3104,7985,40720,1524,2,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',45000.00,NULL,NULL,1,'2023-04-18 08:12:32','2023-04-18 08:12:32',NULL),(3105,7985,40720,1525,2,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',8000.00,NULL,NULL,1,'2023-04-18 08:17:41','2023-04-18 08:17:41',NULL),(3106,7985,40720,1525,2,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',45000.00,NULL,NULL,1,'2023-04-18 08:17:42','2023-04-18 08:17:42',NULL),(3107,7985,40720,1525,2,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',5000.00,NULL,NULL,1,'2023-04-18 08:17:42','2023-04-18 08:17:42',NULL),(3108,7985,40720,1525,2,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',7260.00,NULL,NULL,1,'2023-04-18 08:17:42','2023-04-18 08:17:42',NULL),(3109,7985,40720,1525,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',7000.00,NULL,NULL,1,'2023-04-18 08:17:42','2023-04-18 08:17:42',NULL),(3110,7985,40720,1525,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',24200.00,NULL,NULL,1,'2023-04-18 08:17:42','2023-04-18 08:17:42',NULL),(3111,7985,40720,1526,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',24200.00,NULL,NULL,1,'2023-04-18 08:19:07','2023-04-18 08:19:07',NULL),(3112,7985,40720,1526,2,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',7000.00,NULL,NULL,1,'2023-04-18 08:19:07','2023-04-18 08:19:07',NULL),(3113,7985,40720,1526,2,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',7260.00,NULL,NULL,1,'2023-04-18 08:19:07','2023-04-18 08:19:07',NULL);
INSERT INTO `balance_libro` VALUES (3114,7985,40720,1526,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',5000.00,NULL,NULL,1,'2023-04-18 08:19:07','2023-04-18 08:19:07',NULL),(3115,7985,40720,1526,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',45000.00,NULL,NULL,1,'2023-04-18 08:19:07','2023-04-18 08:19:07',NULL),(3116,7985,40720,1526,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',8000.00,NULL,NULL,1,'2023-04-18 08:19:07','2023-04-18 08:19:07',NULL),(3117,7985,40720,1521,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',21780.00,NULL,NULL,1,'2023-04-18 17:21:46','2023-04-18 17:21:46',NULL),(3118,7985,40720,1521,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',7260.00,NULL,NULL,1,'2023-04-18 17:21:46','2023-04-18 17:21:46',NULL),(3119,7985,40720,1521,2,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',5000.00,NULL,NULL,1,'2023-04-18 17:21:46','2023-04-18 17:21:46',NULL),(3120,7985,40720,1521,2,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',30250.00,NULL,NULL,1,'2023-04-18 17:21:46','2023-04-18 17:21:46',NULL),(3121,7985,40720,1521,2,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',7000.00,NULL,NULL,1,'2023-04-18 17:21:46','2023-04-18 17:21:46',NULL),(3127,7985,40767,31703,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',9796.97,NULL,NULL,1,'2023-04-20 15:12:31','2023-04-20 15:12:31',NULL),(3128,7985,40767,31703,3,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',19939.65,NULL,NULL,1,'2023-04-20 15:12:31','2023-04-20 15:12:31',NULL),(3129,7985,40767,31703,3,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',52986.77,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3130,7985,40767,31703,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',47665.38,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3131,7985,40767,31703,3,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3316.37,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3132,7985,40767,31703,3,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8907.58,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3133,7985,40767,31703,3,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',57604.94,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3134,7985,40767,31703,3,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2900.62,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3135,7985,40767,31703,3,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',42902.47,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3136,7985,40767,31703,3,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4184.59,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3137,7985,40767,31703,3,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',38406.94,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3138,7985,40767,31703,3,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',160836.72,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3139,7985,40767,31703,3,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',199413.05,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL);
INSERT INTO `balance_libro` VALUES (3140,7985,40767,31703,3,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',37903.88,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3141,7985,40767,31703,3,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',26594.14,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3142,7985,40767,31703,3,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',37032.79,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3143,7985,40767,31703,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',33660.16,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3144,7985,40767,31703,3,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',5775.45,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3145,7985,40767,31703,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',21318.34,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3146,7985,40767,31703,3,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',59709.02,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3147,7985,40767,31703,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',483.68,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3148,7985,40767,31703,3,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',18877.14,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3149,7985,40767,31703,3,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6700.00,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3150,7985,40767,31703,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',120021.63,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3151,7985,40767,31703,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',15637.29,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3152,7985,40767,31703,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',49376.31,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3153,7985,40767,31703,3,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',12181.08,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3154,7985,40767,31703,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3374.63,NULL,NULL,1,'2023-04-20 15:12:32','2023-04-20 15:12:32',NULL),(3155,7985,40767,31703,3,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',7900.21,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3156,7985,40767,31703,3,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1097.29,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3157,7985,40767,31703,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',17687.38,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3158,7985,40767,31703,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',96110.45,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3159,7985,40767,31703,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',28539.80,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3160,7985,40767,31703,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',20274.48,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL);
INSERT INTO `balance_libro` VALUES (3161,7985,40767,31703,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',78241.23,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3162,7985,40767,31703,3,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',64483.82,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3163,7985,40767,31703,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1555.91,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3164,7985,40767,31703,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',7220.57,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3165,7985,40767,31703,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',5111.77,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3166,7985,40767,31703,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',29887.68,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3167,7985,40767,31703,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',23376.30,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3168,7985,40767,31703,3,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',9340.12,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3169,7985,40767,31703,3,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',71104.17,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3170,7985,40767,31703,3,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4400.89,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3171,7985,40767,31703,3,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',6104.32,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3172,7985,40767,31703,3,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',29090.34,NULL,NULL,1,'2023-04-20 15:12:33','2023-04-20 15:12:33',NULL),(3173,7985,40767,31703,2,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',4864.50,NULL,NULL,1,'2023-04-20 15:17:05','2023-04-20 15:17:05',NULL),(3174,7985,40767,31703,2,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2553.72,NULL,NULL,1,'2023-04-20 15:17:05','2023-04-20 15:17:05',NULL),(3175,7985,40767,31703,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',15283.02,NULL,NULL,1,'2023-04-20 15:17:05','2023-04-20 15:17:05',NULL),(3176,7985,40767,31703,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',15280.01,NULL,NULL,1,'2023-04-20 15:17:05','2023-04-20 15:17:05',NULL),(3177,7985,40767,31703,2,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',11506.49,NULL,NULL,1,'2023-04-20 15:17:05','2023-04-20 15:17:05',NULL),(3178,7985,40767,31703,2,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',19000.00,NULL,NULL,1,'2023-04-20 15:17:05','2023-04-20 15:17:05',NULL),(3179,7985,40767,31703,2,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',13820.00,NULL,NULL,1,'2023-04-20 15:17:05','2023-04-20 15:17:05',NULL),(3180,7985,40767,31703,2,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',460.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3181,7985,40767,31703,2,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2960.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL);
INSERT INTO `balance_libro` VALUES (3182,7985,40767,31703,2,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',4500.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3183,7985,40767,31703,2,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2800.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3184,7985,40767,31703,2,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',540.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3185,7985,40767,31703,2,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1120.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3186,7985,40767,31703,2,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1240.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3187,7985,40767,31703,2,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2200.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3188,7985,40767,31703,2,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3750.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3189,7985,40767,31703,2,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1360.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3190,7985,40767,31703,2,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',8280.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3191,7985,40767,31703,2,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1738.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3192,7985,40767,31703,2,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',890.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3193,7985,40767,31703,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',470.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3194,7985,40767,31703,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3770.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3195,7985,40767,31703,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',6050.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3196,7985,40767,31703,2,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',200.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3197,7985,40767,31703,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2720.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3198,7985,40767,31703,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1380.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3199,7985,40767,31703,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5440.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3200,7985,40767,31703,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5940.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3201,7985,40767,31703,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',14660.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3202,7985,40767,31703,2,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',200.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL);
INSERT INTO `balance_libro` VALUES (3203,7985,40767,31703,2,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2600.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3204,7985,40767,31703,2,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1140.00,NULL,NULL,1,'2023-04-20 15:17:06','2023-04-20 15:17:06',NULL),(3205,7985,40767,31703,2,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3000.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3206,7985,40767,31703,2,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',330.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3207,7985,40767,31703,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',820.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3208,7985,40767,31703,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1960.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3209,7985,40767,31703,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2450.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3210,7985,40767,31703,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3140.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3211,7985,40767,31703,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',27466.15,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3212,7985,40767,31703,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3011.58,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3213,7985,40767,31703,2,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',10907.93,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3214,7985,40767,31703,2,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2330.33,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3215,7985,40767,31703,2,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',47632.92,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3216,7985,40767,31703,2,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2764.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3217,7985,40767,31703,2,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',780.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3218,7985,40767,31703,2,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',26588.80,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3219,7985,40767,31703,2,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',4815.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3220,7985,40767,31703,2,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5066.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3221,7985,40767,31703,2,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1290.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3222,7985,40767,31703,2,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',790.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3223,7985,40767,31703,2,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',450.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL);
INSERT INTO `balance_libro` VALUES (3224,7985,40767,31703,2,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',29100.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3225,7985,40767,31703,2,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',8595.80,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3226,7985,40767,31703,2,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',22177.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3227,7985,40767,31703,2,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1660.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3228,7985,40767,31703,2,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2710.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3229,7985,40767,31703,2,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',4645.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3230,7985,40767,31703,2,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',93800.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3231,7985,40767,31703,2,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1200.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3232,7985,40767,31703,2,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',470.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3233,7985,40767,31703,2,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1580.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3234,7985,40767,31703,2,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',780.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3235,7985,40767,31703,2,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1525.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3236,7985,40767,31703,2,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2540.00,NULL,NULL,1,'2023-04-20 15:17:07','2023-04-20 15:17:07',NULL),(3237,7985,40767,31703,2,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5659.65,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3238,7985,40767,31703,2,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',7000.09,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3239,7985,40767,31703,2,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',900.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3240,7985,40767,31703,2,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',130.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3241,7985,40767,31703,2,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1110.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3242,7985,40767,31703,2,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3400.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3243,7985,40767,31703,2,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2430.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3244,7985,40767,31703,2,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1230.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL);
INSERT INTO `balance_libro` VALUES (3245,7985,40767,31703,2,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',17070.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3246,7985,40767,31703,2,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2780.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3247,7985,40767,31703,2,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2290.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3248,7985,40767,31703,2,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1440.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3249,7985,40767,31703,2,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4770.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3250,7985,40767,31703,2,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6460.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3251,7985,40767,31703,2,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',260.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3252,7985,40767,31703,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2835.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3253,7985,40767,31703,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1370.50,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3254,7985,40767,31703,2,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3080.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3255,7985,40767,31703,2,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3400.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3256,7985,40767,31703,2,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1580.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3257,7985,40767,31703,2,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',630.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3258,7985,40767,31703,2,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2300.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3259,7985,40767,31703,2,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2740.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3260,7985,40767,31703,2,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',9560.02,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3261,7985,40767,31703,2,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1280.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3262,7985,40767,31703,2,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',540.00,NULL,NULL,1,'2023-04-20 15:17:08','2023-04-20 15:17:08',NULL),(3263,7985,40767,31703,2,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',19308.02,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3264,7985,40767,31703,2,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',14558.20,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3265,7985,40767,31703,2,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1991.76,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL);
INSERT INTO `balance_libro` VALUES (3266,7985,40767,31703,2,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1500.04,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3267,7985,40767,31703,2,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',390.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3268,7985,40767,31703,2,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1440.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3269,7985,40767,31703,2,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',950.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3270,7985,40767,31703,2,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1000.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3271,7985,40767,31703,2,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1050.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3272,7985,40767,31703,2,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',420.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3273,7985,40767,31703,2,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',5415.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3274,7985,40767,31703,2,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',770.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3275,7985,40767,31703,2,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3550.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3276,7985,40767,31703,2,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',9268.54,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3277,7985,40767,31703,2,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',16800.25,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3278,7985,40767,31703,2,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',4680.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3279,7985,40767,31703,2,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',13600.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3280,7985,40767,31703,2,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',15000.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3281,7985,40767,31703,2,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1000.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3282,7985,40767,31703,2,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1330.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3283,7985,40767,31703,2,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',650.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3284,7985,40767,31703,2,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3830.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3285,7985,40767,31703,2,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2330.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3286,7985,40767,31703,2,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2135.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL);
INSERT INTO `balance_libro` VALUES (3287,7985,40767,31703,2,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',270.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3288,7985,40767,31703,2,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2305.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3289,7985,40767,31703,2,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3600.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3290,7985,40767,31703,2,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',2000.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3291,7985,40767,31703,2,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',840.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3292,7985,40767,31703,2,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',2450.00,NULL,NULL,1,'2023-04-20 15:17:09','2023-04-20 15:17:09',NULL),(3293,7985,40767,31703,2,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1400.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3294,7985,40767,31703,2,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4880.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3295,7985,40767,31703,2,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',2150.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3296,7985,40767,31703,2,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4360.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3297,7985,40767,31703,2,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',11174.01,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3298,7985,40767,31703,2,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',2500.80,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3299,7985,40767,31703,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5140.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3300,7985,40767,31703,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1716.25,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3301,7985,40767,31703,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1300.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3302,7985,40767,31703,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2230.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3303,7985,40767,31703,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3880.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3304,7985,40767,31703,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',310.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3305,7985,40767,31703,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',8000.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3306,7985,40767,31703,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',9670.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3307,7985,40767,31703,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2660.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL);
INSERT INTO `balance_libro` VALUES (3308,7985,40767,31703,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4320.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3309,7985,40767,31703,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',895.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3310,7985,40767,31703,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',16600.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3311,7985,40767,31703,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',805.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3312,7985,40767,31703,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',10647.12,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3313,7985,40767,31703,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',13044.19,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3314,7985,40767,31703,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',46884.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3315,7985,40767,31703,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1855.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3316,7985,40767,31703,2,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1855.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3317,7985,40767,31703,2,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1440.00,NULL,NULL,1,'2023-04-20 15:17:10','2023-04-20 15:17:10',NULL),(3318,7985,40767,31703,2,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1480.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3319,7985,40767,31703,2,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3000.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3320,7985,40767,31703,2,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',9350.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3321,7985,40767,31703,2,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',470.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3322,7985,40767,31703,2,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',730.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3323,7985,40767,31703,2,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',590.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3324,7985,40767,31703,2,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',14590.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3325,7985,40767,31703,2,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1480.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3326,7985,40767,31703,2,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',7080.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3327,7985,40767,31703,2,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',3310.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3328,7985,40767,31703,2,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1040.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL);
INSERT INTO `balance_libro` VALUES (3329,7985,40767,31703,2,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1440.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3330,7985,40767,31703,2,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1085.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3331,7985,40767,31703,2,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',3820.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3332,7985,40767,31703,2,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2660.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3333,7985,40767,31703,2,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',2780.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3334,7985,40767,31703,2,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1080.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3335,7985,40767,31703,2,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1100.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3336,7985,40767,31703,2,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',17733.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3337,7985,40767,31703,2,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6211.29,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3338,7985,40767,31703,2,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',731.52,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3339,7985,40767,31703,2,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',4544.05,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3340,7985,40767,31703,2,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',20375.00,NULL,NULL,1,'2023-04-20 15:17:11','2023-04-20 15:17:11',NULL),(3341,7985,40767,31703,2,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',5677.80,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3342,7985,40767,31703,2,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',150.03,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3343,7985,40767,31703,2,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',160.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3344,7985,40767,31703,2,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',150.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3345,7985,40767,31703,2,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',8520.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3346,7985,40767,31703,2,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',4800.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3347,7985,40767,31703,2,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',270.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3348,7985,40767,31703,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',4250.40,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3349,7985,40767,31703,2,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',17748.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL);
INSERT INTO `balance_libro` VALUES (3350,7985,40767,31703,2,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2620.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3351,7985,40767,31703,2,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',830.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3352,7985,40767,31703,2,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6422.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3353,7985,40767,31703,2,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',800.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3354,7985,40767,31703,2,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',150.03,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3355,7985,40767,31703,2,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1460.01,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3356,7985,40767,31703,2,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',15602.38,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3357,7985,40767,31703,2,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',4050.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3358,7985,40767,31703,2,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',4250.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3359,7985,40767,31703,2,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',750.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3360,7985,40767,31703,2,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',80.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3361,7985,40767,31703,2,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',13240.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3362,7985,40767,31703,2,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',2300.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3363,7985,40767,31703,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1180.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3364,7985,40767,31703,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',640.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3365,7985,40767,31703,2,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',360.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3366,7985,40767,31703,2,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',850.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3367,7985,40767,31703,2,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',890.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3368,7985,40767,31703,2,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1340.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3369,7985,40767,31703,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1130.00,NULL,NULL,1,'2023-04-20 15:17:12','2023-04-20 15:17:12',NULL),(3370,7985,40767,31703,2,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1500.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL);
INSERT INTO `balance_libro` VALUES (3371,7985,40767,31703,2,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',2750.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3372,7985,40767,31703,2,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',690.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3373,7985,40767,31703,2,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',512.07,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3374,7985,40767,31703,2,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1380.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3375,7985,40767,31703,2,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',20500.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3376,7985,40767,31703,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',7690.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3377,7985,40767,31703,2,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1750.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3378,7985,40767,31703,2,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2970.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3379,7985,40767,31703,2,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',5210.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3380,7985,40767,31703,2,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',5190.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3381,7985,40767,31703,2,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2030.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3382,7985,40767,31703,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',3660.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3383,7985,40767,31703,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',9020.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3384,7985,40767,31703,2,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1870.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3385,7985,40767,31703,2,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',7290.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3386,7985,40767,31703,2,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1600.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3387,7985,40767,31703,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1380.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3388,7985,40767,31703,2,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',975.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3389,7985,40767,31703,2,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2200.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3390,7985,40767,31703,2,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',15000.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3391,7985,40767,31703,2,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1290.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL);
INSERT INTO `balance_libro` VALUES (3392,7985,40767,31703,2,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1710.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3393,7985,40767,31703,2,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',5520.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3394,7985,40767,31703,2,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',990.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3395,7985,40767,31703,2,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1090.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3396,7985,40767,31703,2,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',37780.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3397,7985,40767,31703,2,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',9610.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3398,7985,40767,31703,2,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',450.00,NULL,NULL,1,'2023-04-20 15:17:13','2023-04-20 15:17:13',NULL),(3399,7985,40767,31703,2,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1380.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3400,7985,40767,31703,2,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',4835.20,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3401,7985,40767,31703,2,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',15890.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3402,7985,40767,31703,2,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',2280.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3403,7985,40767,31703,2,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',4825.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3404,7985,40767,31703,2,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1300.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3405,7985,40767,31703,2,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',13000.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3406,7985,40767,31703,2,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',800.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3407,7985,40767,31703,2,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1900.02,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3408,7985,40767,31703,2,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',6911.60,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3409,7985,40767,31703,2,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',15544.28,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3410,7985,40767,31703,2,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',7074.46,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3411,7985,40767,31703,2,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',731.52,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3412,7985,40767,31703,2,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',34200.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL);
INSERT INTO `balance_libro` VALUES (3413,7985,40767,31703,2,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',20864.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3414,7985,40767,31703,2,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',17493.26,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3415,7985,40767,31703,2,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4100.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3416,7985,40767,31703,2,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1050.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3417,7985,40767,31703,2,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2360.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3418,7985,40767,31703,2,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',12000.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3419,7985,40767,31703,2,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',590.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3420,7985,40767,31703,2,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3500.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3421,7985,40767,31703,2,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4960.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3422,7985,40767,31703,2,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2170.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3423,7985,40767,31703,2,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2965.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3424,7985,40767,31703,2,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3300.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3425,7985,40767,31703,2,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5070.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3426,7985,40767,31703,2,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1290.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3427,7985,40767,31703,2,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1734.00,NULL,NULL,1,'2023-04-20 15:17:14','2023-04-20 15:17:14',NULL),(3428,7985,40767,31703,2,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3470.01,NULL,NULL,1,'2023-04-20 15:17:15','2023-04-20 15:17:15',NULL),(3429,7985,40767,31703,2,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3190.00,NULL,NULL,1,'2023-04-20 15:17:15','2023-04-20 15:17:15',NULL),(3430,7985,40767,31703,2,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3100.00,NULL,NULL,1,'2023-04-20 15:17:15','2023-04-20 15:17:15',NULL),(3431,7985,40767,31703,2,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2320.00,NULL,NULL,1,'2023-04-20 15:17:15','2023-04-20 15:17:15',NULL),(3432,7985,40767,31703,2,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1886.00,NULL,NULL,1,'2023-04-20 15:17:15','2023-04-20 15:17:15',NULL),(3433,7985,40767,31703,2,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',430.00,NULL,NULL,1,'2023-04-20 15:17:15','2023-04-20 15:17:15',NULL);
INSERT INTO `balance_libro` VALUES (3434,7985,40767,31703,2,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9429.99,NULL,NULL,1,'2023-04-20 15:17:15','2023-04-20 15:17:15',NULL),(3435,7985,40767,31703,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1000.00,NULL,NULL,1,'2023-04-20 15:17:15','2023-04-20 15:17:15',NULL),(3436,7985,40767,31703,7,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',835.77,NULL,NULL,1,'2023-04-20 15:25:29','2023-04-20 15:25:29',NULL),(3437,7985,40767,31703,7,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',171.23,NULL,NULL,1,'2023-04-20 15:25:40','2023-04-20 15:25:40',NULL),(3438,7985,40767,31703,7,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',70.05,NULL,NULL,1,'2023-04-20 15:25:40','2023-04-20 15:25:40',NULL),(3439,7985,40767,31703,7,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',114.50,NULL,NULL,1,'2023-04-20 15:25:40','2023-04-20 15:25:40',NULL),(3440,7985,40721,3051,2,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',140000.00,NULL,NULL,1,'2023-04-20 15:51:09','2023-04-20 15:51:09',NULL),(3441,7985,40767,31703,15,446,'App\\Models\\PeriodLiquidation',NULL,446,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',267944.50,NULL,NULL,1,'2023-04-20 15:54:15','2023-04-20 15:54:15',NULL),(3442,7985,40767,31703,16,447,'App\\Models\\PeriodLiquidation',NULL,447,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',53370.99,NULL,NULL,1,'2023-04-20 15:55:17','2024-01-04 23:08:54','2024-01-04 23:08:54'),(3443,7985,40721,3051,2,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',140000.00,NULL,NULL,1,'2023-04-20 22:28:15','2023-04-20 22:28:15',NULL),(3444,7985,40721,3051,2,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',140000.00,NULL,NULL,1,'2023-04-20 22:36:58','2023-04-20 22:36:58',NULL),(3445,7985,40721,3051,2,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',140000.00,NULL,NULL,1,'2023-04-20 22:41:39','2023-04-20 22:41:39',NULL),(3446,7985,40721,3051,2,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',140000.00,NULL,NULL,1,'2023-04-20 22:47:59','2023-04-20 22:47:59',NULL),(3447,7985,40721,3051,2,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',140000.00,NULL,NULL,1,'2023-04-21 19:32:31','2023-04-21 19:32:31',NULL),(3448,7985,40721,3050,7,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',66.62,NULL,NULL,1,'2023-04-22 15:50:28','2023-04-22 15:50:28',NULL),(3449,7985,40721,3050,7,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',242.25,NULL,NULL,1,'2023-04-22 15:50:28','2023-04-22 15:50:28',NULL),(3450,7985,40721,3050,7,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',88.92,NULL,NULL,1,'2023-04-22 15:50:28','2023-04-22 15:50:28',NULL),(3451,7985,40721,3050,7,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',448.39,NULL,NULL,1,'2023-04-22 15:50:28','2023-04-22 15:50:28',NULL),(3452,7985,40721,3050,7,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',520.05,NULL,NULL,1,'2023-04-22 15:50:28','2023-04-22 15:56:06','2023-04-22 15:56:06'),(3453,7985,40721,3050,7,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',123.62,NULL,NULL,1,'2023-04-22 15:50:28','2023-04-22 15:50:28',NULL);
INSERT INTO `balance_libro` VALUES (3454,7985,40721,3050,15,462,'App\\Models\\PeriodLiquidation',NULL,462,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',119419.56,NULL,NULL,1,'2023-04-22 16:29:37','2023-04-22 16:29:37',NULL),(3455,7985,40721,3050,16,463,'App\\Models\\PeriodLiquidation',NULL,463,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.00,NULL,NULL,1,'2023-04-22 16:29:45','2023-04-22 16:29:45',NULL),(3456,7985,40721,3051,2,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',140000.00,NULL,NULL,1,'2023-04-25 19:15:53','2023-04-25 19:15:53',NULL),(3457,7985,40721,3051,2,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',140000.00,NULL,NULL,1,'2023-04-25 20:22:08','2023-04-25 20:22:08',NULL),(3458,7985,40720,1536,2,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',5000.02,NULL,NULL,1,'2023-05-11 16:44:58','2023-05-11 16:44:58',NULL),(3459,7985,40720,1536,2,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',8000.00,NULL,NULL,1,'2023-05-11 16:44:58','2023-05-11 16:44:58',NULL),(3460,7985,40720,1536,2,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',24200.00,NULL,NULL,1,'2023-05-11 16:44:58','2023-05-11 16:44:58',NULL),(3461,7985,40720,1536,2,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',7260.00,NULL,NULL,1,'2023-05-11 16:44:58','2023-05-11 16:44:58',NULL),(3462,7985,40720,1536,2,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',7000.04,NULL,NULL,1,'2023-05-11 16:44:58','2023-05-11 16:44:58',NULL),(3463,7985,40720,1536,2,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',45000.04,NULL,NULL,1,'2023-05-11 16:44:58','2023-05-11 16:44:58',NULL),(3464,7985,40720,1536,2,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',7260.00,NULL,NULL,1,'2023-05-11 16:44:58','2023-05-11 16:44:58',NULL),(3465,7985,40720,1536,2,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',25000.00,NULL,NULL,1,'2023-05-11 16:44:58','2023-05-11 16:44:58',NULL),(3466,7985,40720,1536,2,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',8000.00,NULL,NULL,1,'2023-05-11 16:44:58','2023-05-11 16:44:58',NULL),(3467,7985,40720,1536,3,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',5090.41,NULL,NULL,1,'2023-05-11 16:45:12','2023-05-11 16:45:12',NULL),(3468,7985,40720,1536,3,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',22675.69,NULL,NULL,1,'2023-05-11 16:45:12','2023-05-11 16:45:12',NULL),(3469,7985,40720,1536,3,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',7860.18,NULL,NULL,1,'2023-05-11 16:45:12','2023-05-11 16:45:12',NULL),(3470,7985,40720,1536,3,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1030.54,NULL,NULL,1,'2023-05-11 16:45:12','2023-05-11 16:45:12',NULL),(3471,7985,40720,1536,3,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',6829.72,NULL,NULL,1,'2023-05-11 16:45:12','2023-05-11 16:45:12',NULL),(3472,7985,40720,1536,3,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',10710.00,NULL,NULL,1,'2023-05-11 16:45:12','2023-05-11 16:45:12',NULL),(3473,7985,40720,1536,3,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',4836.81,NULL,NULL,1,'2023-05-11 16:45:12','2023-05-11 16:45:12',NULL),(3474,7985,40720,1536,3,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',39564.66,NULL,NULL,1,'2023-05-11 16:45:12','2023-05-11 16:45:12',NULL);
INSERT INTO `balance_libro` VALUES (3475,7985,40720,1536,3,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',91700.00,NULL,NULL,1,'2023-05-11 16:45:13','2023-05-11 16:45:13',NULL),(3476,7985,40720,1536,3,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',2379.24,NULL,NULL,1,'2023-05-11 16:45:13','2023-05-11 16:45:13',NULL),(3477,7985,40720,1536,3,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',23737.05,NULL,NULL,1,'2023-05-11 16:45:13','2023-05-11 16:45:13',NULL),(3478,7985,40720,1536,3,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',9000.00,NULL,NULL,1,'2023-05-11 16:45:13','2023-05-11 16:45:13',NULL),(3479,7985,40720,1536,15,470,'App\\Models\\PeriodLiquidation',NULL,470,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',23587.86,NULL,NULL,1,'2023-05-11 16:55:10','2023-05-11 16:55:10',NULL),(3480,7985,40720,1536,16,471,'App\\Models\\PeriodLiquidation',NULL,471,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3949.59,NULL,NULL,1,'2023-05-11 16:59:39','2023-05-11 16:59:39',NULL),(3481,7985,41102,40791,2,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',10150.00,NULL,NULL,1,'2023-05-12 10:42:46','2023-05-12 10:42:46',NULL),(3482,7985,41102,40791,2,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',23450.00,NULL,NULL,1,'2023-05-12 10:42:46','2023-05-12 10:42:46',NULL),(3483,7985,41102,40791,3,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',46039.40,NULL,NULL,1,'2023-05-12 10:43:20','2023-05-12 10:43:20',NULL),(3484,7985,41102,40791,3,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',28176.35,NULL,NULL,1,'2023-05-12 10:43:20','2023-05-12 10:43:20',NULL),(3485,7985,41102,40791,3,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',5743.62,NULL,NULL,1,'2023-05-12 10:43:20','2023-05-12 10:43:20',NULL),(3486,7985,41102,40791,3,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',22015.80,NULL,NULL,1,'2023-05-12 10:43:20','2023-05-12 10:43:20',NULL),(3487,7985,41102,40791,16,474,'App\\Models\\PeriodLiquidation',NULL,474,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1512.00,NULL,NULL,1,'2023-05-12 10:48:18','2023-05-12 10:48:18',NULL),(3488,7985,40763,28700,15,336,'App\\Models\\PeriodLiquidation',NULL,336,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6052.03,NULL,NULL,1,'2023-05-15 11:15:39','2023-05-15 11:15:39',NULL),(3489,7985,40763,28701,2,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',210394.51,NULL,NULL,1,'2023-05-15 11:20:20','2023-05-15 11:20:20',NULL),(3490,7985,40763,28701,3,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',6140.00,NULL,NULL,1,'2023-05-15 11:20:36','2023-05-15 11:20:36',NULL),(3491,7985,40763,28701,3,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2564.64,NULL,NULL,1,'2023-05-15 11:20:36','2023-05-15 11:20:36',NULL),(3492,7985,40763,28701,3,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6581.20,NULL,NULL,1,'2023-05-15 11:20:36','2023-05-15 11:20:36',NULL),(3493,7985,40763,28701,3,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6970.17,NULL,NULL,1,'2023-05-15 11:20:36','2023-05-15 11:20:36',NULL),(3494,7985,40763,28701,3,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',64247.93,NULL,NULL,1,'2023-05-15 11:20:36','2023-05-15 11:20:36',NULL);
INSERT INTO `balance_libro` VALUES (3495,7985,40763,28701,3,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',18080.50,NULL,NULL,1,'2023-05-15 11:20:36','2023-05-15 11:20:36',NULL),(3496,7985,40763,28701,15,479,'App\\Models\\PeriodLiquidation',NULL,479,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',36514.75,NULL,NULL,1,'2023-05-15 11:36:56','2024-01-04 23:08:11','2024-01-04 23:08:11'),(3497,7985,40721,3051,2,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',40000.01,NULL,NULL,1,'2023-05-16 11:00:43','2023-05-16 11:00:43',NULL),(3498,7985,40721,3051,2,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',100000.00,NULL,NULL,1,'2023-05-16 11:00:43','2023-05-16 11:00:43',NULL),(3499,7985,40721,3051,2,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',100000.00,NULL,NULL,1,'2023-05-16 11:00:43','2023-05-16 11:00:43',NULL),(3500,7985,40721,3051,2,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',140000.00,NULL,NULL,1,'2023-05-16 11:00:43','2023-05-16 11:00:43',NULL),(3501,7985,40721,3051,2,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',140000.00,NULL,NULL,1,'2023-05-16 11:00:43','2023-05-16 11:00:43',NULL),(3502,7985,40721,3051,3,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',4411.19,NULL,NULL,1,'2023-05-16 11:01:20','2023-05-16 11:18:32','2023-05-16 11:18:32'),(3503,7985,40721,3051,3,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',170558.34,NULL,NULL,1,'2023-05-16 11:01:20','2023-05-16 11:18:32','2023-05-16 11:18:32'),(3504,7985,40721,3051,3,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',61996.65,NULL,NULL,1,'2023-05-16 11:01:20','2023-05-16 11:18:32','2023-05-16 11:18:32'),(3505,7985,40721,3051,3,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1657.47,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:18:32','2023-05-16 11:18:32'),(3506,7985,40721,3051,3,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',233960.77,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:18:32','2023-05-16 11:18:32'),(3507,7985,40721,3051,3,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',47395.13,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:18:32','2023-05-16 11:18:32'),(3508,7985,40721,3051,3,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',8971.50,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:18:32','2023-05-16 11:18:32'),(3509,7985,40721,3051,3,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',152707.05,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:18:32','2023-05-16 11:18:32'),(3510,7985,40721,3051,3,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',10216.55,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:14:56','2023-05-16 11:14:56'),(3511,7985,40721,3051,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',3367.00,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:14:46','2023-05-16 11:14:46'),(3512,7985,40721,3051,3,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',5437.50,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:14:32','2023-05-16 11:14:32'),(3513,7985,40721,3051,3,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',56203.94,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:18:32','2023-05-16 11:18:32');
INSERT INTO `balance_libro` VALUES (3514,7985,40721,3051,3,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',179900.00,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:14:20','2023-05-16 11:14:20'),(3515,7985,40721,3051,3,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',36200.00,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:14:09','2023-05-16 11:14:09'),(3516,7985,40721,3051,3,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',102908.59,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:18:32','2023-05-16 11:18:32'),(3517,7985,40721,3051,3,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1795.00,NULL,NULL,1,'2023-05-16 11:01:21','2023-05-16 11:13:56','2023-05-16 11:13:56'),(3518,7985,40721,3051,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',4411.19,NULL,NULL,1,'2023-05-16 11:20:01','2023-05-16 11:39:51','2023-05-16 11:39:51'),(3519,7985,40721,3051,3,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',170558.34,NULL,NULL,1,'2023-05-16 11:20:01','2023-05-16 11:20:01',NULL),(3520,7985,40721,3051,3,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',61996.65,NULL,NULL,1,'2023-05-16 11:20:02','2023-05-16 11:20:02',NULL),(3521,7985,40721,3051,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1657.47,NULL,NULL,1,'2023-05-16 11:20:02','2023-05-16 11:32:48','2023-05-16 11:32:48'),(3522,7985,40721,3051,3,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',233960.77,NULL,NULL,1,'2023-05-16 11:20:02','2023-05-16 11:20:02',NULL),(3523,7985,40721,3051,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',47395.13,NULL,NULL,1,'2023-05-16 11:20:02','2023-05-16 11:20:02',NULL),(3524,7985,40721,3051,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',8971.50,NULL,NULL,1,'2023-05-16 11:20:02','2023-05-16 11:20:02',NULL),(3525,7985,40721,3051,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',152707.05,NULL,NULL,1,'2023-05-16 11:20:02','2023-05-16 11:20:02',NULL),(3526,7985,40721,3051,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',56203.94,NULL,NULL,1,'2023-05-16 11:20:02','2023-05-16 11:20:02',NULL),(3527,7985,40721,3051,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',102908.59,NULL,NULL,1,'2023-05-16 11:20:02','2023-05-16 11:20:02',NULL),(3528,7985,40721,3051,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1495.77,NULL,NULL,1,'2023-05-16 11:32:48','2023-05-16 11:32:48',NULL),(3529,7985,40721,3051,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',4499.01,NULL,NULL,1,'2023-05-16 11:39:51','2023-05-16 11:39:51',NULL),(3530,7985,40767,31704,2,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',6460.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL),(3531,7985,40767,31704,2,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',2600.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL),(3532,7985,40767,31704,2,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1540.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL),(3533,7985,40767,31704,2,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',22110.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL);
INSERT INTO `balance_libro` VALUES (3534,7985,40767,31704,2,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',600.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL),(3535,7985,40767,31704,2,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',2120.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL),(3536,7985,40767,31704,2,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',480.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL),(3537,7985,40767,31704,2,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',695.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL),(3538,7985,40767,31704,2,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1950.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL),(3539,7985,40767,31704,2,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2135.00,NULL,NULL,1,'2023-05-19 16:27:02','2023-05-19 16:27:02',NULL),(3540,7985,40767,31704,2,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',5700.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3541,7985,40767,31704,2,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',175084.07,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3542,7985,40767,31704,2,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',850.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3543,7985,40767,31704,2,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1760.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3544,7985,40767,31704,2,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',530.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3545,7985,40767,31704,2,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1950.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3546,7985,40767,31704,2,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5396.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3547,7985,40767,31704,2,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5770.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3548,7985,40767,31704,2,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4339.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3549,7985,40767,31704,2,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',6623.98,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3550,7985,40767,31704,2,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2199.60,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3551,7985,40767,31704,2,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',21338.79,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3552,7985,40767,31704,2,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3620.10,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3553,7985,40767,31704,2,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2650.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3554,7985,40767,31704,2,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1555.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL);
INSERT INTO `balance_libro` VALUES (3555,7985,40767,31704,2,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',4500.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3556,7985,40767,31704,2,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',221.10,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3557,7985,40767,31704,2,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',280.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3558,7985,40767,31704,2,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',3380.00,NULL,NULL,1,'2023-05-19 16:27:03','2023-05-19 16:27:03',NULL),(3559,7985,40767,31704,2,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5400.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3560,7985,40767,31704,2,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2950.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3561,7985,40767,31704,2,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2170.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3562,7985,40767,31704,2,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1570.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3563,7985,40767,31704,2,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',800.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3564,7985,40767,31704,2,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1940.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3565,7985,40767,31704,2,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2110.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3566,7985,40767,31704,2,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2490.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3567,7985,40767,31704,2,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',4215.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3568,7985,40767,31704,2,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2700.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3569,7985,40767,31704,2,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1540.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3570,7985,40767,31704,2,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',770.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3571,7985,40767,31704,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1160.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3572,7985,40767,31704,2,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',680.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3573,7985,40767,31704,2,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',570.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3574,7985,40767,31704,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3034.10,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3575,7985,40767,31704,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1689.99,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL);
INSERT INTO `balance_libro` VALUES (3576,7985,40767,31704,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1464.98,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3577,7985,40767,31704,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',16829.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3578,7985,40767,31704,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8700.02,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3579,7985,40767,31704,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',15270.01,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3580,7985,40767,31704,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3170.00,NULL,NULL,1,'2023-05-19 16:27:04','2023-05-19 16:27:04',NULL),(3581,7985,40767,31704,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',2740.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3582,7985,40767,31704,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',13625.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3583,7985,40767,31704,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3030.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3584,7985,40767,31704,2,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',2575.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3585,7985,40767,31704,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',6200.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3586,7985,40767,31704,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',900.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3587,7985,40767,31704,2,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8365.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3588,7985,40767,31704,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',2100.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3589,7985,40767,31704,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',510.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3590,7985,40767,31704,2,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',2370.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3591,7985,40767,31704,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',165.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3592,7985,40767,31704,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1740.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3593,7985,40767,31704,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',5570.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3594,7985,40767,31704,2,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',5510.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3595,7985,40767,31704,2,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3160.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3596,7985,40767,31704,2,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',5750.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL);
INSERT INTO `balance_libro` VALUES (3597,7985,40767,31704,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12540.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3598,7985,40767,31704,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1620.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3599,7985,40767,31704,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',560.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3600,7985,40767,31704,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',24865.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3601,7985,40767,31704,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',680.00,NULL,NULL,1,'2023-05-19 16:27:05','2023-05-19 16:27:05',NULL),(3602,7985,40767,31704,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',2814.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3603,7985,40767,31704,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',8090.60,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3604,7985,40767,31704,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1860.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3605,7985,40767,31704,2,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',3790.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3606,7985,40767,31704,2,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2760.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3607,7985,40767,31704,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',3565.03,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3608,7985,40767,31704,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2280.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3609,7985,40767,31704,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',4680.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3610,7985,40767,31704,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',25570.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3611,7985,40767,31704,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2437.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3612,7985,40767,31704,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',760.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3613,7985,40767,31704,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',1930.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3614,7985,40767,31704,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',22450.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3615,7985,40767,31704,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2150.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3616,7985,40767,31704,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',5490.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3617,7985,40767,31704,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2740.01,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL);
INSERT INTO `balance_libro` VALUES (3618,7985,40767,31704,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1200.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3619,7985,40767,31704,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1080.00,NULL,NULL,1,'2023-05-19 16:27:06','2023-05-19 16:27:06',NULL),(3620,7985,40767,31704,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',8130.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3621,7985,40767,31704,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1580.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3622,7985,40767,31704,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',30600.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3623,7985,40767,31704,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1080.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3624,7985,40767,31704,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',750.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3625,7985,40767,31704,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',5850.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3626,7985,40767,31704,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',1760.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3627,7985,40767,31704,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',10330.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3628,7985,40767,31704,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',6240.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3629,7985,40767,31704,2,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',880.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3630,7985,40767,31704,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',2750.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3631,7985,40767,31704,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',1180.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3632,7985,40767,31704,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',5620.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3633,7985,40767,31704,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8036.72,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3634,7985,40767,31704,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',600.85,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3635,7985,40767,31704,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',17699.25,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3636,7985,40767,31704,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',23857.26,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3637,7985,40767,31704,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3480.79,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL),(3638,7985,40767,31704,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',515.00,NULL,NULL,1,'2023-05-19 16:27:07','2023-05-19 16:27:07',NULL);
INSERT INTO `balance_libro` VALUES (3639,7985,40767,31704,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3070.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3640,7985,40767,31704,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1520.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3641,7985,40767,31704,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3970.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3642,7985,40767,31704,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1100.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3643,7985,40767,31704,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1360.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3644,7985,40767,31704,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1960.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3645,7985,40767,31704,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',6745.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3646,7985,40767,31704,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',2060.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3647,7985,40767,31704,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',29200.03,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3648,7985,40767,31704,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1900.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3649,7985,40767,31704,2,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',10350.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3650,7985,40767,31704,2,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',10680.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3651,7985,40767,31704,2,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1470.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3652,7985,40767,31704,2,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',680.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3653,7985,40767,31704,2,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1200.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3654,7985,40767,31704,2,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',7290.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3655,7985,40767,31704,2,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',4100.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3656,7985,40767,31704,2,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',1760.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3657,7985,40767,31704,2,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',31800.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3658,7985,40767,31704,2,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',6775.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3659,7985,40767,31704,2,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',7900.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL);
INSERT INTO `balance_libro` VALUES (3660,7985,40767,31704,2,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4410.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3661,7985,40767,31704,2,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',2860.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3662,7985,40767,31704,2,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',2870.00,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3663,7985,40767,31704,2,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',739.99,NULL,NULL,1,'2023-05-19 16:27:08','2023-05-19 16:27:08',NULL),(3664,7985,40767,31704,2,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',2160.30,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3665,7985,40767,31704,2,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',920.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3666,7985,40767,31704,2,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',620.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3667,7985,40767,31704,2,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',3960.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3668,7985,40767,31704,2,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',1790.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3669,7985,40767,31704,2,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',9524.25,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3670,7985,40767,31704,2,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',3363.40,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3671,7985,40767,31704,2,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',1490.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3672,7985,40767,31704,2,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',2290.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3673,7985,40767,31704,2,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',680.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3674,7985,40767,31704,2,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',900.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3675,7985,40767,31704,2,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',910.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3676,7985,40767,31704,2,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',2870.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3677,7985,40767,31704,2,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',4709.94,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3678,7985,40767,31704,2,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3643.25,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3679,7985,40767,31704,2,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',34369.24,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3680,7985,40767,31704,2,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',5408.58,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL);
INSERT INTO `balance_libro` VALUES (3681,7985,40767,31704,2,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',4900.00,NULL,NULL,1,'2023-05-19 16:27:09','2023-05-19 16:27:09',NULL),(3682,7985,40767,31704,2,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3200.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3683,7985,40767,31704,2,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3520.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3684,7985,40767,31704,2,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',1230.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3685,7985,40767,31704,2,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3320.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3686,7985,40767,31704,2,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',12500.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3687,7985,40767,31704,2,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',925.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3688,7985,40767,31704,2,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3790.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3689,7985,40767,31704,2,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',2460.04,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3690,7985,40767,31704,2,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',182.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3691,7985,40767,31704,2,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',600.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3692,7985,40767,31704,2,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',350.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3693,7985,40767,31704,2,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3570.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3694,7985,40767,31704,2,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',1770.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3695,7985,40767,31704,2,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',745.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3696,7985,40767,31704,2,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',4350.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3697,7985,40767,31704,2,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',1155.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3698,7985,40767,31704,2,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',2500.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3699,7985,40767,31704,2,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3440.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3700,7985,40767,31704,2,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',4120.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3701,7985,40767,31704,2,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',500.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL);
INSERT INTO `balance_libro` VALUES (3702,7985,40767,31704,2,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',6800.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3703,7985,40767,31704,2,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',4800.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3704,7985,40767,31704,2,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3660.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3705,7985,40767,31704,2,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',6770.00,NULL,NULL,1,'2023-05-19 16:27:10','2023-05-19 16:27:10',NULL),(3706,7985,40767,31704,2,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',5380.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3707,7985,40767,31704,2,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',12450.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3708,7985,40767,31704,2,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',5640.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3709,7985,40767,31704,2,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3210.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3710,7985,40767,31704,2,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1740.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3711,7985,40767,31704,2,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',5480.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3712,7985,40767,31704,2,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1000.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3713,7985,40767,31704,2,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',2630.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3714,7985,40767,31704,2,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1720.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3715,7985,40767,31704,2,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',230.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3716,7985,40767,31704,2,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1000.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3717,7985,40767,31704,2,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',10260.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3718,7985,40767,31704,2,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1997.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3719,7985,40767,31704,2,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',21930.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3720,7985,40767,31704,2,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',830.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3721,7985,40767,31704,2,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3480.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3722,7985,40767,31704,2,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4790.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL);
INSERT INTO `balance_libro` VALUES (3723,7985,40767,31704,2,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3300.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3724,7985,40767,31704,2,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',520.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3725,7985,40767,31704,2,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1440.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3726,7985,40767,31704,2,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',9870.00,NULL,NULL,1,'2023-05-19 16:27:11','2023-05-19 16:27:11',NULL),(3727,7985,40767,31704,2,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',995.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3728,7985,40767,31704,2,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1220.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3729,7985,40767,31704,2,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',865.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3730,7985,40767,31704,2,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',420.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3731,7985,40767,31704,2,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',2960.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3732,7985,40767,31704,2,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1700.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3733,7985,40767,31704,2,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3000.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3734,7985,40767,31704,2,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',15200.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3735,7985,40767,31704,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',660.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3736,7985,40767,31704,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',2635.88,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3737,7985,40767,31704,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',4767.53,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3738,7985,40767,31704,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',2290.05,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3739,7985,40767,31704,2,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',1870.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3740,7985,40767,31704,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',990.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3741,7985,40767,31704,2,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',30800.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3742,7985,40767,31704,2,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',11500.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3743,7985,40767,31704,2,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',1940.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL);
INSERT INTO `balance_libro` VALUES (3744,7985,40767,31704,2,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',840.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3745,7985,40767,31704,2,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',17409.67,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3746,7985,40767,31704,2,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1936.50,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3747,7985,40767,31704,2,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',693.06,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3748,7985,40767,31704,2,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',22505.42,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3749,7985,40767,31704,2,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1537.00,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3750,7985,40767,31704,2,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',11487.78,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3751,7985,40767,31704,2,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1905.42,NULL,NULL,1,'2023-05-19 16:27:12','2023-05-19 16:27:12',NULL),(3752,7985,40767,31704,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',620.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3753,7985,40767,31704,2,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6380.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3754,7985,40767,31704,2,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1650.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3755,7985,40767,31704,2,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',2270.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3756,7985,40767,31704,2,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3380.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3757,7985,40767,31704,2,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',2850.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3758,7985,40767,31704,2,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1840.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3759,7985,40767,31704,2,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',450.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3760,7985,40767,31704,2,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',8970.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3761,7985,40767,31704,2,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',4000.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3762,7985,40767,31704,2,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',11080.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3763,7985,40767,31704,2,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',4780.02,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3764,7985,40767,31704,2,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',2730.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL);
INSERT INTO `balance_libro` VALUES (3765,7985,40767,31704,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1770.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3766,7985,40767,31704,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1230.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3767,7985,40767,31704,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6190.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3768,7985,40767,31704,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',760.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3769,7985,40767,31704,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',4710.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3770,7985,40767,31704,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',5960.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3771,7985,40767,31704,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1350.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3772,7985,40767,31704,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1760.00,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3773,7985,40767,31704,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',74150.01,NULL,NULL,1,'2023-05-19 16:27:13','2023-05-19 16:27:13',NULL),(3774,7985,40767,31704,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',5160.04,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3775,7985,40767,31704,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1475.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3776,7985,40767,31704,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1490.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3777,7985,40767,31704,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2070.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3778,7985,40767,31704,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',4775.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3779,7985,40767,31704,2,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3920.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3780,7985,40767,31704,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3060.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3781,7985,40767,31704,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1820.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3782,7985,40767,31704,2,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1630.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3783,7985,40767,31704,2,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',8900.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3784,7985,40767,31704,2,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',5098.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3785,7985,40767,31704,2,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2770.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL);
INSERT INTO `balance_libro` VALUES (3786,7985,40767,31704,2,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',770.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3787,7985,40767,31704,2,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3080.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3788,7985,40767,31704,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',7300.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3789,7985,40767,31704,2,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',5190.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3790,7985,40767,31704,2,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',4280.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3791,7985,40767,31704,2,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1660.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3792,7985,40767,31704,2,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',14400.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3793,7985,40767,31704,2,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',30000.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3794,7985,40767,31704,2,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3980.46,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3795,7985,40767,31704,2,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',5160.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3796,7985,40767,31704,2,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1160.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3797,7985,40767,31704,2,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1055.00,NULL,NULL,1,'2023-05-19 16:27:14','2023-05-19 16:27:14',NULL),(3798,7985,40767,31704,2,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2415.04,NULL,NULL,1,'2023-05-19 16:27:15','2023-05-19 16:27:15',NULL),(3799,7985,40767,31704,2,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3700.00,NULL,NULL,1,'2023-05-19 16:27:15','2023-05-19 16:27:15',NULL),(3800,7985,40767,31704,3,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',10587.16,NULL,NULL,1,'2023-05-19 16:28:40','2023-05-19 16:28:40',NULL),(3801,7985,40767,31704,3,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',62167.31,NULL,NULL,1,'2023-05-19 16:28:40','2023-05-19 16:28:40',NULL),(3802,7985,40767,31704,3,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',3336.57,NULL,NULL,1,'2023-05-19 16:28:40','2023-05-19 16:28:40',NULL),(3803,7985,40767,31704,3,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3194.40,NULL,NULL,1,'2023-05-19 16:28:40','2023-05-19 16:28:40',NULL),(3804,7985,40767,31704,3,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',14166.23,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3805,7985,40767,31704,3,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1919.07,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3806,7985,40767,31704,3,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1026.48,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL);
INSERT INTO `balance_libro` VALUES (3807,7985,40767,31704,3,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',29580.86,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3808,7985,40767,31704,3,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',34277.88,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3809,7985,40767,31704,3,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',48476.67,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3810,7985,40767,31704,3,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',96383.37,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3811,7985,40767,31704,3,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',31644.40,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3812,7985,40767,31704,3,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',541.62,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3813,7985,40767,31704,3,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',38205.39,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3814,7985,40767,31704,3,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',6112.86,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3815,7985,40767,31704,3,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',54054.43,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3816,7985,40767,31704,3,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',28796.92,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3817,7985,40767,31704,3,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',24076.94,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3818,7985,40767,31704,3,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',11232.87,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3819,7985,40767,31704,3,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',58683.02,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3820,7985,40767,31704,3,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',36006.48,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3821,7985,40767,31704,3,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',42519.05,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3822,7985,40767,31704,3,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',6727.73,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3823,7985,40767,31704,3,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',6746.37,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3824,7985,40767,31704,3,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',6091.47,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3825,7985,40767,31704,3,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',57520.11,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3826,7985,40767,31704,3,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3123.58,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3827,7985,40767,31704,3,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',67092.76,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL);
INSERT INTO `balance_libro` VALUES (3828,7985,40767,31704,3,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',47325.41,NULL,NULL,1,'2023-05-19 16:28:41','2023-05-19 16:28:41',NULL),(3829,7985,40767,31704,3,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',42302.57,NULL,NULL,1,'2023-05-19 16:28:42','2023-05-19 16:28:42',NULL),(3830,7985,40767,31704,3,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',6768.41,NULL,NULL,1,'2023-05-19 16:28:42','2023-05-19 16:28:42',NULL),(3831,7985,40767,31704,3,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',59476.88,NULL,NULL,1,'2023-05-19 16:28:42','2023-05-19 16:28:42',NULL),(3832,7985,40767,31704,3,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',17706.76,NULL,NULL,1,'2023-05-19 16:28:42','2023-05-19 16:28:42',NULL),(3833,7985,40767,31704,3,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',44225.72,NULL,NULL,1,'2023-05-19 16:28:42','2023-05-19 16:28:42',NULL),(3834,7985,40767,31704,3,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',7076.12,NULL,NULL,1,'2023-05-19 16:28:42','2023-05-19 16:28:42',NULL),(3835,7985,40767,31704,3,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',18403.84,NULL,NULL,1,'2023-05-19 16:28:42','2023-05-19 16:28:42',NULL),(3836,7985,40767,31704,3,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',25578.82,NULL,NULL,1,'2023-05-19 16:28:42','2023-05-19 16:28:42',NULL),(3837,7985,40767,31704,3,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',27293.32,NULL,NULL,1,'2023-05-19 16:28:42','2023-05-19 16:28:42',NULL),(3841,7985,40767,31704,7,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',116.08,NULL,NULL,1,'2023-05-22 12:28:01','2023-05-22 12:28:01',NULL),(3842,7985,40767,31704,7,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',92.40,NULL,NULL,1,'2023-05-22 12:28:01','2023-05-22 12:28:01',NULL),(3843,7985,40767,31704,7,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',80.23,NULL,NULL,1,'2023-05-22 12:28:01','2023-05-22 12:28:01',NULL),(3844,7985,40767,31704,7,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',54.00,NULL,NULL,1,'2023-05-22 12:28:01','2023-05-22 12:28:01',NULL),(3845,7985,40767,31704,15,517,'App\\Models\\PeriodLiquidation',NULL,517,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',289483.75,NULL,NULL,1,'2023-05-22 12:31:27','2023-05-22 12:31:27',NULL),(3846,7985,40767,31704,16,518,'App\\Models\\PeriodLiquidation',NULL,518,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',56736.53,NULL,NULL,1,'2023-05-22 12:32:23','2023-05-22 12:32:23',NULL),(3847,7985,40763,28701,16,480,'App\\Models\\PeriodLiquidation',NULL,480,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',38.18,NULL,NULL,1,'2023-06-12 12:31:00','2023-06-12 12:31:00',NULL),(3848,7985,40763,28702,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',32670.00,NULL,NULL,1,'2023-06-12 12:32:32','2023-06-12 12:32:32',NULL),(3849,7985,40763,28702,3,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',7345.76,NULL,NULL,1,'2023-06-12 12:32:52','2023-06-12 12:32:52',NULL),(3850,7985,40763,28702,3,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',2761.17,NULL,NULL,1,'2023-06-12 12:32:52','2023-06-12 12:32:52',NULL);
INSERT INTO `balance_libro` VALUES (3851,7985,40763,28702,3,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8920.12,NULL,NULL,1,'2023-06-12 12:32:52','2023-06-12 12:32:52',NULL),(3852,7985,40763,28702,16,524,'App\\Models\\PeriodLiquidation',NULL,524,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5.93,NULL,NULL,1,'2023-06-14 00:13:40','2023-06-14 00:13:40',NULL),(3853,7985,40763,28702,15,523,'App\\Models\\PeriodLiquidation',NULL,523,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5670.00,NULL,NULL,1,'2023-06-14 00:14:04','2023-06-14 00:14:04',NULL),(3854,7985,40720,1535,15,330,'App\\Models\\PeriodLiquidation',NULL,330,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',17955.88,NULL,NULL,1,'2023-06-14 18:39:20','2023-06-14 18:39:20',NULL),(3855,7985,40720,1535,16,331,'App\\Models\\PeriodLiquidation',NULL,331,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3587.36,NULL,NULL,1,'2023-06-14 18:39:38','2023-06-14 18:39:38',NULL),(3856,7985,40720,1526,15,426,'App\\Models\\PeriodLiquidation',NULL,426,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',16740.99,NULL,NULL,1,'2023-06-14 18:41:06','2023-06-14 18:41:06',NULL),(3857,7985,40720,1526,16,427,'App\\Models\\PeriodLiquidation',NULL,427,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3587.36,NULL,NULL,1,'2023-06-14 18:41:16','2023-11-06 10:14:17','2023-11-06 10:14:17'),(3858,7985,40720,1525,15,424,'App\\Models\\PeriodLiquidation',NULL,424,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',16740.99,NULL,NULL,1,'2023-06-14 18:41:37','2023-06-14 18:41:37',NULL),(3859,7985,40720,1525,16,425,'App\\Models\\PeriodLiquidation',NULL,425,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3587.36,NULL,NULL,1,'2023-06-14 18:41:48','2023-06-14 18:41:48',NULL),(3860,7985,40720,1524,15,422,'App\\Models\\PeriodLiquidation',NULL,422,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15664.96,NULL,NULL,1,'2023-06-14 18:42:05','2023-06-14 18:42:05',NULL),(3861,7985,40720,1524,16,423,'App\\Models\\PeriodLiquidation',NULL,423,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2687.36,NULL,NULL,1,'2023-06-14 18:42:14','2023-06-14 18:42:14',NULL),(3862,7985,40720,1523,15,418,'App\\Models\\PeriodLiquidation',NULL,418,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',15664.96,NULL,NULL,1,'2023-06-14 18:42:29','2023-10-24 13:05:23','2023-10-24 13:05:23'),(3863,7985,40720,1523,16,419,'App\\Models\\PeriodLiquidation',NULL,419,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3356.78,NULL,NULL,1,'2023-06-14 18:42:58','2023-06-14 18:42:58',NULL),(3864,7985,40720,1522,15,416,'App\\Models\\PeriodLiquidation',NULL,416,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',19661.90,NULL,NULL,1,'2023-06-14 18:43:45','2023-06-14 18:43:45',NULL),(3865,7985,40720,1522,16,417,'App\\Models\\PeriodLiquidation',NULL,417,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2278.26,NULL,NULL,1,'2023-06-14 18:44:38','2023-06-14 18:44:38',NULL),(3866,7985,40720,1537,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',45000.04,NULL,NULL,1,'2023-06-14 18:47:06','2023-06-14 18:47:06',NULL),(3867,7985,40720,1537,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',7000.04,NULL,NULL,1,'2023-06-14 18:47:06','2023-06-14 18:47:06',NULL),(3868,7985,40720,1537,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',5000.02,NULL,NULL,1,'2023-06-14 18:47:06','2023-06-14 18:47:06',NULL),(3869,7985,40720,1537,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',24200.00,NULL,NULL,1,'2023-06-14 18:47:06','2023-06-14 18:47:06',NULL),(3870,7985,40720,1537,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',25000.00,NULL,NULL,1,'2023-06-14 18:47:06','2023-06-14 18:47:06',NULL);
INSERT INTO `balance_libro` VALUES (3871,7985,40720,1537,3,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',6510.55,NULL,NULL,1,'2023-06-14 18:47:21','2023-06-14 18:47:21',NULL),(3872,7985,40720,1537,3,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',5460.79,NULL,NULL,1,'2023-06-14 18:47:21','2023-06-14 18:47:21',NULL),(3873,7985,40720,1537,3,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1694.00,NULL,NULL,1,'2023-06-14 18:47:21','2023-06-14 18:47:21',NULL),(3874,7985,40720,1537,3,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',10079.36,NULL,NULL,1,'2023-06-14 18:47:21','2023-06-14 18:47:21',NULL),(3875,7985,40720,1537,3,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',25213.05,NULL,NULL,1,'2023-06-14 18:47:21','2023-06-14 18:47:21',NULL),(3876,7985,40721,3051,15,509,'App\\Models\\PeriodLiquidation',NULL,509,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',260330.58,NULL,NULL,1,'2023-06-27 22:26:02','2023-06-27 22:26:02',NULL),(3877,7985,40721,3051,16,510,'App\\Models\\PeriodLiquidation',NULL,510,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',31239.67,NULL,NULL,1,'2023-06-27 22:26:10','2023-06-27 22:26:10',NULL),(3878,7985,40721,3052,2,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',250000.00,NULL,NULL,1,'2023-06-27 22:32:00','2023-06-27 22:32:00',NULL),(3879,7985,40721,3052,2,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',250000.00,NULL,NULL,1,'2023-06-27 22:32:00','2023-06-27 22:32:00',NULL),(3880,7985,40721,3052,2,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',50000.04,NULL,NULL,1,'2023-06-27 22:32:01','2023-06-27 22:32:01',NULL),(3881,7985,40721,3052,2,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',1588125.00,NULL,NULL,1,'2023-06-27 22:32:01','2023-06-27 22:32:01',NULL),(3882,7985,40721,3052,3,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',9901.57,NULL,NULL,1,'2023-06-27 22:32:12','2023-06-27 22:32:12',NULL),(3883,7985,40721,3052,3,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',5845.59,NULL,NULL,1,'2023-06-27 22:32:12','2023-06-27 22:32:12',NULL),(3884,7985,40721,3052,3,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1657.47,NULL,NULL,1,'2023-06-27 22:32:12','2023-06-27 22:32:12',NULL),(3885,7985,40721,3052,3,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1795.00,NULL,NULL,1,'2023-06-27 22:32:12','2023-06-27 22:32:12',NULL),(3886,7985,40721,3052,3,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',43278.84,NULL,NULL,1,'2023-06-27 22:32:12','2023-06-27 22:32:12',NULL),(3887,7985,40721,3052,3,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',7199.85,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3888,7985,40721,3052,3,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',19349.00,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3889,7985,40721,3052,3,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',50631.21,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3890,7985,40721,3052,3,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',74247.66,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3891,7985,40721,3052,3,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',29046.32,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL);
INSERT INTO `balance_libro` VALUES (3892,7985,40721,3052,3,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',7615.40,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3893,7985,40721,3052,3,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',80090.51,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3894,7985,40721,3052,3,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',9398.02,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3895,7985,40721,3052,3,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',38190.00,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3896,7985,40721,3052,3,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',26784.96,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3897,7985,40721,3052,3,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1588125.00,NULL,NULL,1,'2023-06-27 22:32:13','2023-06-27 22:32:13',NULL),(3898,7985,40721,3052,7,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',1256.11,NULL,NULL,1,'2023-06-27 23:39:24','2023-06-27 23:39:24',NULL),(3899,7985,40721,3052,15,535,'App\\Models\\PeriodLiquidation',NULL,535,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',371079.55,NULL,NULL,1,'2023-06-27 23:46:39','2023-06-27 23:46:39',NULL),(3900,7985,40721,3052,16,536,'App\\Models\\PeriodLiquidation',NULL,536,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',506.30,NULL,NULL,1,'2023-06-27 23:48:39','2023-06-27 23:48:39',NULL),(3901,7985,40767,31705,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',6400.00,NULL,NULL,1,'2023-06-30 15:51:06','2023-06-30 15:51:06',NULL),(3902,7985,40767,31705,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',18240.00,NULL,NULL,1,'2023-06-30 15:51:06','2023-06-30 15:51:06',NULL),(3903,7985,40767,31705,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',2910.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3904,7985,40767,31705,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',6200.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3905,7985,40767,31705,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',900.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3906,7985,40767,31705,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',360.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3907,7985,40767,31705,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',53300.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3908,7985,40767,31705,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',4840.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3909,7985,40767,31705,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',2400.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3910,7985,40767,31705,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',7000.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3911,7985,40767,31705,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1330.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3912,7985,40767,31705,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',3720.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL);
INSERT INTO `balance_libro` VALUES (3913,7985,40767,31705,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',4160.00,NULL,NULL,1,'2023-06-30 15:51:07','2023-06-30 15:51:07',NULL),(3914,7985,40767,31705,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',2100.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3915,7985,40767,31705,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',850.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3916,7985,40767,31705,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1700.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3917,7985,40767,31705,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1010.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3918,7985,40767,31705,2,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',9185.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3919,7985,40767,31705,2,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',8240.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3920,7985,40767,31705,2,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',3120.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3921,7985,40767,31705,2,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',2460.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3922,7985,40767,31705,2,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',8979.17,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3923,7985,40767,31705,2,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',2760.01,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3924,7985,40767,31705,2,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',980.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3925,7985,40767,31705,2,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',1740.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3926,7985,40767,31705,2,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',3780.00,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3927,7985,40767,31705,2,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',8799.28,NULL,NULL,1,'2023-06-30 15:51:08','2023-06-30 15:51:08',NULL),(3928,7985,40767,31705,2,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',10285.75,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3929,7985,40767,31705,2,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',22358.94,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3930,7985,40767,31705,2,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',1825.54,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3931,7985,40767,31705,2,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',890.00,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3932,7985,40767,31705,2,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',3450.00,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3933,7985,40767,31705,2,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',4600.00,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL);
INSERT INTO `balance_libro` VALUES (3934,7985,40767,31705,2,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',6480.00,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3935,7985,40767,31705,2,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',1800.00,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3936,7985,40767,31705,2,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',4930.00,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3937,7985,40767,31705,2,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',4750.00,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3938,7985,40767,31705,2,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',440.00,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3939,7985,40767,31705,2,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',6000.00,NULL,NULL,1,'2023-06-30 15:51:09','2023-06-30 15:51:09',NULL),(3940,7985,40767,31705,2,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',19050.80,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3941,7985,40767,31705,2,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',19062.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3942,7985,40767,31705,2,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1520.05,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3943,7985,40767,31705,2,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1530.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3944,7985,40767,31705,2,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4635.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3945,7985,40767,31705,2,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',2270.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3946,7985,40767,31705,2,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3320.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3947,7985,40767,31705,2,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4300.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3948,7985,40767,31705,2,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3380.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3949,7985,40767,31705,2,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3860.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3950,7985,40767,31705,2,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1840.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3951,7985,40767,31705,2,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',2080.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3952,7985,40767,31705,2,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',2650.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3953,7985,40767,31705,2,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',615.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3954,7985,40767,31705,2,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',7375.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL);
INSERT INTO `balance_libro` VALUES (3955,7985,40767,31705,2,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1520.00,NULL,NULL,1,'2023-06-30 15:51:10','2023-06-30 15:51:10',NULL),(3956,7985,40767,31705,2,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1240.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3957,7985,40767,31705,2,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',10100.05,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3958,7985,40767,31705,2,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',30291.59,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3959,7985,40767,31705,2,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',3252.90,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3960,7985,40767,31705,2,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',29980.17,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3961,7985,40767,31705,2,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',9700.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3962,7985,40767,31705,2,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',9700.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3963,7985,40767,31705,2,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',28200.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3964,7985,40767,31705,2,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',9710.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3965,7985,40767,31705,2,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',1736.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3966,7985,40767,31705,2,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',2270.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3967,7985,40767,31705,2,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',2000.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3968,7985,40767,31705,2,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',2000.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3969,7985,40767,31705,2,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',3030.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3970,7985,40767,31705,2,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',4450.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3971,7985,40767,31705,2,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',1340.00,NULL,NULL,1,'2023-06-30 15:51:11','2023-06-30 15:51:11',NULL),(3972,7985,40767,31705,2,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',2650.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3973,7985,40767,31705,2,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',1800.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3974,7985,40767,31705,2,3873,'App\\Models\\Receipt',3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',2740.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3975,7985,40767,31705,2,3874,'App\\Models\\Receipt',3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',4810.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL);
INSERT INTO `balance_libro` VALUES (3976,7985,40767,31705,2,3875,'App\\Models\\Receipt',3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',5160.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3977,7985,40767,31705,2,3876,'App\\Models\\Receipt',3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1050.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3978,7985,40767,31705,2,3877,'App\\Models\\Receipt',3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',10700.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3979,7985,40767,31705,2,3878,'App\\Models\\Receipt',3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',3950.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3980,7985,40767,31705,2,3879,'App\\Models\\Receipt',3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',5900.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3981,7985,40767,31705,2,3880,'App\\Models\\Receipt',3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',3050.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3982,7985,40767,31705,2,3881,'App\\Models\\Receipt',3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',11800.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3983,7985,40767,31705,2,3882,'App\\Models\\Receipt',3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',935.00,NULL,NULL,1,'2023-06-30 15:51:12','2023-06-30 15:51:12',NULL),(3984,7985,40767,31705,2,3883,'App\\Models\\Receipt',3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1855.00,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3985,7985,40767,31705,2,3884,'App\\Models\\Receipt',3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',3380.00,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3986,7985,40767,31705,2,3885,'App\\Models\\Receipt',3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1730.00,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3987,7985,40767,31705,2,3886,'App\\Models\\Receipt',3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',415.00,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3988,7985,40767,31705,2,3887,'App\\Models\\Receipt',3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',6910.00,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3989,7985,40767,31705,2,3888,'App\\Models\\Receipt',3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',2800.00,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3990,7985,40767,31705,2,3889,'App\\Models\\Receipt',3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',5516.95,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3991,7985,40767,31705,2,3890,'App\\Models\\Receipt',3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1853.00,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3992,7985,40767,31705,2,3891,'App\\Models\\Receipt',3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',4760.00,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3993,7985,40767,31705,2,3892,'App\\Models\\Receipt',3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1210.00,NULL,NULL,1,'2023-06-30 15:51:13','2023-06-30 15:51:13',NULL),(3994,7985,40767,31705,2,3893,'App\\Models\\Receipt',3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1420.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(3995,7985,40767,31705,2,3894,'App\\Models\\Receipt',3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',2880.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(3996,7985,40767,31705,2,3895,'App\\Models\\Receipt',3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1010.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL);
INSERT INTO `balance_libro` VALUES (3997,7985,40767,31705,2,3896,'App\\Models\\Receipt',3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',3534.40,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(3998,7985,40767,31705,2,3897,'App\\Models\\Receipt',3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',22153.31,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(3999,7985,40767,31705,2,3898,'App\\Models\\Receipt',3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',5299.80,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(4000,7985,40767,31705,2,3899,'App\\Models\\Receipt',3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',22920.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(4001,7985,40767,31705,2,3900,'App\\Models\\Receipt',3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',22920.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(4002,7985,40767,31705,2,3901,'App\\Models\\Receipt',3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',8883.30,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(4003,7985,40767,31705,2,3902,'App\\Models\\Receipt',3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',2360.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(4004,7985,40767,31705,2,3903,'App\\Models\\Receipt',3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',8239.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(4005,7985,40767,31705,2,3904,'App\\Models\\Receipt',3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1440.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(4006,7985,40767,31705,2,3905,'App\\Models\\Receipt',3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',4000.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(4007,7985,40767,31705,2,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',14830.00,NULL,NULL,1,'2023-06-30 15:51:14','2023-06-30 15:51:14',NULL),(4008,7985,40767,31705,2,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',360.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4009,7985,40767,31705,2,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',2150.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4010,7985,40767,31705,2,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1210.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4011,7985,40767,31705,2,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',8600.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4012,7985,40767,31705,2,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',2500.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4013,7985,40767,31705,2,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',2150.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4014,7985,40767,31705,2,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',10425.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4015,7985,40767,31705,2,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',5167.62,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4016,7985,40767,31705,2,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',420.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4017,7985,40767,31705,2,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',1890.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL);
INSERT INTO `balance_libro` VALUES (4018,7985,40767,31705,2,3917,'App\\Models\\Receipt',3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',1100.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4019,7985,40767,31705,2,3918,'App\\Models\\Receipt',3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',1337.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4020,7985,40767,31705,2,3919,'App\\Models\\Receipt',3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',4170.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4021,7985,40767,31705,2,3920,'App\\Models\\Receipt',3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',6140.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4022,7985,40767,31705,2,3921,'App\\Models\\Receipt',3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',3010.59,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4023,7985,40767,31705,2,3922,'App\\Models\\Receipt',3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',15232.00,NULL,NULL,1,'2023-06-30 15:51:15','2023-06-30 15:51:15',NULL),(4024,7985,40767,31705,2,3923,'App\\Models\\Receipt',3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',2620.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4025,7985,40767,31705,2,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',1090.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4026,7985,40767,31705,2,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',850.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4027,7985,40767,31705,2,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',170.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4028,7985,40767,31705,2,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',3560.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4029,7985,40767,31705,2,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',1900.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4030,7985,40767,31705,2,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',1280.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4031,7985,40767,31705,2,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',1660.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4032,7985,40767,31705,2,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',10413.48,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4033,7985,40767,31705,2,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',5341.91,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4034,7985,40767,31705,2,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',9470.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4035,7985,40767,31705,2,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',9000.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4036,7985,40767,31705,2,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',1130.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4037,7985,40767,31705,2,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',3980.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4038,7985,40767,31705,2,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',620.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL);
INSERT INTO `balance_libro` VALUES (4039,7985,40767,31705,2,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',4640.00,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4040,7985,40767,31705,2,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',5802.15,NULL,NULL,1,'2023-06-30 15:51:16','2023-06-30 15:51:16',NULL),(4041,7985,40767,31705,2,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',508.35,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4042,7985,40767,31705,2,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',52000.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4043,7985,40767,31705,2,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',24547.29,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4044,7985,40767,31705,2,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',1045.80,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4045,7985,40767,31705,2,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',22666.81,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4046,7985,40767,31705,2,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',3767.23,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4047,7985,40767,31705,2,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',1225.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4048,7985,40767,31705,2,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',17062.43,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4049,7985,40767,31705,2,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',1935.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4050,7985,40767,31705,2,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',1980.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4051,7985,40767,31705,2,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',2650.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4052,7985,40767,31705,2,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',73648.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4053,7985,40767,31705,2,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',1610.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4054,7985,40767,31705,2,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',620.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4055,7985,40767,31705,2,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',4550.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4056,7985,40767,31705,2,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',9700.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4057,7985,40767,31705,2,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',360.00,NULL,NULL,1,'2023-06-30 15:51:17','2023-06-30 15:51:17',NULL),(4058,7985,40767,31705,2,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',4690.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4059,7985,40767,31705,2,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',770.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL);
INSERT INTO `balance_libro` VALUES (4060,7985,40767,31705,2,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',7190.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4061,7985,40767,31705,2,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',3950.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4062,7985,40767,31705,2,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',2900.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4063,7985,40767,31705,2,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',2050.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4064,7985,40767,31705,2,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',800.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4065,7985,40767,31705,2,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',3680.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4066,7985,40767,31705,2,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',4575.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4067,7985,40767,31705,2,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',2565.20,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4068,7985,40767,31705,2,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',2900.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4069,7985,40767,31705,2,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',7140.00,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4070,7985,40767,31705,2,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',12837.69,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4071,7985,40767,31705,2,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',14394.32,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4072,7985,40767,31705,2,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',19590.36,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4073,7985,40767,31705,2,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',25397.74,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4074,7985,40767,31705,2,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',1155.97,NULL,NULL,1,'2023-06-30 15:51:18','2023-06-30 15:51:18',NULL),(4075,7985,40767,31705,2,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',6300.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4076,7985,40767,31705,2,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',1930.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4077,7985,40767,31705,2,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',3990.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4078,7985,40767,31705,2,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',1940.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4079,7985,40767,31705,2,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',3346.46,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4080,7985,40767,31705,2,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',3346.46,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL);
INSERT INTO `balance_libro` VALUES (4081,7985,40767,31705,2,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',2190.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4082,7985,40767,31705,2,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',460.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4083,7985,40767,31705,2,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',9500.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4084,7985,40767,31705,2,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1340.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4085,7985,40767,31705,2,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',630.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4086,7985,40767,31705,2,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',3310.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4087,7985,40767,31705,2,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1300.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4088,7985,40767,31705,2,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',9950.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4089,7985,40767,31705,2,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1230.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4090,7985,40767,31705,2,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',850.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4091,7985,40767,31705,2,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',2745.00,NULL,NULL,1,'2023-06-30 15:51:19','2023-06-30 15:51:19',NULL),(4092,7985,40767,31705,2,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1620.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4093,7985,40767,31705,2,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',7150.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4094,7985,40767,31705,2,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',945.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4095,7985,40767,31705,2,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1600.10,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4096,7985,40767,31705,2,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',10380.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4097,7985,40767,31705,2,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1380.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4098,7985,40767,31705,2,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8380.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4099,7985,40767,31705,2,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5930.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4100,7985,40767,31705,2,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2470.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4101,7985,40767,31705,2,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2960.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL);
INSERT INTO `balance_libro` VALUES (4102,7985,40767,31705,2,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4010.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4103,7985,40767,31705,2,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4165.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4104,7985,40767,31705,2,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1363.02,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4105,7985,40767,31705,2,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1950.00,NULL,NULL,1,'2023-06-30 15:51:20','2023-06-30 15:51:20',NULL),(4106,7985,40767,31705,3,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',13056.89,NULL,NULL,1,'2023-06-30 15:52:22','2023-06-30 15:52:22',NULL),(4107,7985,40767,31705,3,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',57301.07,NULL,NULL,1,'2023-06-30 15:52:22','2023-06-30 15:52:22',NULL),(4108,7985,40767,31705,3,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',67024.56,NULL,NULL,1,'2023-06-30 15:52:22','2023-06-30 15:52:22',NULL),(4109,7985,40767,31705,3,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',3153.20,NULL,NULL,1,'2023-06-30 15:52:22','2023-06-30 15:52:22',NULL),(4110,7985,40767,31705,3,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',65994.01,NULL,NULL,1,'2023-06-30 15:52:22','2023-06-30 15:52:22',NULL),(4111,7985,40767,31705,3,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',26095.88,NULL,NULL,1,'2023-06-30 15:52:22','2023-06-30 15:52:22',NULL),(4112,7985,40767,31705,3,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',3346.64,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4113,7985,40767,31705,3,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',16840.22,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4114,7985,40767,31705,3,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',34113.47,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4115,7985,40767,31705,3,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',25657.94,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4116,7985,40767,31705,3,4015,'App\\Models\\Receipt',4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',2070.66,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4117,7985,40767,31705,3,4016,'App\\Models\\Receipt',4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',56664.72,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4118,7985,40767,31705,3,4017,'App\\Models\\Receipt',4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',1295.58,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4119,7985,40767,31705,3,4018,'App\\Models\\Receipt',4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',9066.36,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4120,7985,40767,31705,3,4019,'App\\Models\\Receipt',4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',36877.20,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4121,7985,40767,31705,3,4020,'App\\Models\\Receipt',4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',46164.83,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4122,7985,40767,31705,3,4021,'App\\Models\\Receipt',4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',91344.10,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL);
INSERT INTO `balance_libro` VALUES (4123,7985,40767,31705,3,4022,'App\\Models\\Receipt',4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',38057.63,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4124,7985,40767,31705,3,4023,'App\\Models\\Receipt',4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',61782.37,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4125,7985,40767,31705,3,4024,'App\\Models\\Receipt',4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',37302.34,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4126,7985,40767,31705,3,4025,'App\\Models\\Receipt',4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',17946.49,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4127,7985,40767,31705,3,4026,'App\\Models\\Receipt',4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',5968.37,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4128,7985,40767,31705,3,4027,'App\\Models\\Receipt',4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',10387.55,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4129,7985,40767,31705,3,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',61390.35,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4130,7985,40767,31705,3,4029,'App\\Models\\Receipt',4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',204750.54,NULL,NULL,1,'2023-06-30 15:52:23','2023-06-30 15:52:23',NULL),(4131,7985,40767,31705,3,4030,'App\\Models\\Receipt',4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1797.94,NULL,NULL,1,'2023-06-30 15:52:24','2023-06-30 15:52:24',NULL),(4132,7985,40767,31705,3,4031,'App\\Models\\Receipt',4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',2015.79,NULL,NULL,1,'2023-06-30 15:52:24','2023-06-30 15:52:24',NULL),(4133,7985,40767,31705,3,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',128124.45,NULL,NULL,1,'2023-06-30 15:52:24','2023-07-02 18:23:38','2023-07-02 18:23:38'),(4134,7985,40767,31705,3,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',18659.52,NULL,NULL,1,'2023-06-30 15:52:24','2023-06-30 15:52:24',NULL),(4135,7985,40767,31705,3,4034,'App\\Models\\Receipt',4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',21953.21,NULL,NULL,1,'2023-06-30 15:52:24','2023-06-30 15:52:24',NULL),(4136,7985,40767,31705,3,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',103434.07,NULL,NULL,1,'2023-06-30 15:52:24','2023-06-30 15:52:24',NULL),(4137,7985,40767,31705,3,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',5521.87,NULL,NULL,1,'2023-06-30 15:52:24','2023-06-30 15:52:24',NULL),(4138,7985,40767,31705,3,4037,'App\\Models\\Receipt',4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',20888.70,NULL,NULL,1,'2023-06-30 15:52:24','2023-06-30 15:52:24',NULL),(4140,7985,40767,31705,7,4039,'App\\Models\\Receipt',4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',20.45,NULL,NULL,1,'2023-07-02 18:08:09','2023-07-02 18:08:09',NULL),(4141,7985,40767,31705,7,4040,'App\\Models\\Receipt',4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',144.80,NULL,NULL,1,'2023-07-02 18:08:09','2023-07-02 18:08:09',NULL),(4142,7985,40767,31705,7,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',182.70,NULL,NULL,1,'2023-07-02 18:08:09','2023-07-02 18:08:09',NULL),(4144,7985,40767,31705,3,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',131561.81,NULL,NULL,1,'2023-07-02 18:23:38','2023-07-02 18:23:38',NULL);
INSERT INTO `balance_libro` VALUES (4145,7985,40767,31705,15,545,'App\\Models\\PeriodLiquidation',NULL,545,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',221448.77,NULL,NULL,1,'2023-07-02 18:28:36','2023-07-02 18:28:36',NULL),(4146,7985,40767,31705,16,546,'App\\Models\\PeriodLiquidation',NULL,546,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',46289.01,NULL,NULL,1,'2023-07-02 18:33:34','2023-07-02 18:33:34',NULL),(4147,7985,40721,3053,2,4043,'App\\Models\\Receipt',4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',200000.00,NULL,NULL,1,'2023-07-11 21:41:21','2023-07-11 21:41:21',NULL),(4148,7985,40721,3053,2,4044,'App\\Models\\Receipt',4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',325000.02,NULL,NULL,1,'2023-07-11 21:41:21','2023-07-11 21:41:21',NULL),(4149,7985,40721,3053,2,4045,'App\\Models\\Receipt',4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',741312.00,NULL,NULL,1,'2023-07-11 21:41:21','2023-07-11 21:41:21',NULL),(4150,7985,40721,3053,2,4046,'App\\Models\\Receipt',4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',852508.80,NULL,NULL,1,'2023-07-11 21:41:22','2023-07-11 21:41:22',NULL),(4151,7985,40721,3053,2,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',25000.00,NULL,NULL,1,'2023-07-11 21:41:22','2023-07-11 21:41:22',NULL),(4152,7985,40721,3053,2,4048,'App\\Models\\Receipt',4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',741312.00,NULL,NULL,1,'2023-07-11 21:41:22','2023-07-11 21:41:22',NULL),(4153,7985,40721,3053,2,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',741312.00,NULL,NULL,1,'2023-07-11 21:41:22','2023-07-11 21:41:22',NULL),(4154,7985,40721,3053,3,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',5801.17,NULL,NULL,1,'2023-07-11 21:41:32','2023-07-11 21:41:32',NULL),(4155,7985,40721,3053,3,4051,'App\\Models\\Receipt',4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',6475.44,NULL,NULL,1,'2023-07-11 21:41:32','2023-07-11 21:41:32',NULL),(4156,7985,40721,3053,3,4052,'App\\Models\\Receipt',4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',1657.47,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4157,7985,40721,3053,3,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',21200.00,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4158,7985,40721,3053,3,4054,'App\\Models\\Receipt',4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',18494.92,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4159,7985,40721,3053,3,4055,'App\\Models\\Receipt',4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',9914.06,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4160,7985,40721,3053,3,4056,'App\\Models\\Receipt',4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',107999.92,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4161,7985,40721,3053,3,4057,'App\\Models\\Receipt',4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',6429.70,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4162,7985,40721,3053,3,4058,'App\\Models\\Receipt',4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',11049.50,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4163,7985,40721,3053,3,4059,'App\\Models\\Receipt',4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',232938.33,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4164,7985,40721,3053,3,4060,'App\\Models\\Receipt',4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',7887.00,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4165,7985,40721,3053,3,4061,'App\\Models\\Receipt',4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',23023.52,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL);
INSERT INTO `balance_libro` VALUES (4166,7985,40721,3053,3,4062,'App\\Models\\Receipt',4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',136659.87,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4167,7985,40721,3053,3,4063,'App\\Models\\Receipt',4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',246651.16,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4168,7985,40721,3053,3,4064,'App\\Models\\Receipt',4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',94101.00,NULL,NULL,1,'2023-07-11 21:41:33','2023-07-11 21:41:33',NULL),(4169,7985,40721,3053,3,4065,'App\\Models\\Receipt',4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',41430.00,NULL,NULL,1,'2023-07-11 21:41:34','2023-07-11 21:41:34',NULL),(4170,7985,40721,3053,3,4066,'App\\Models\\Receipt',4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',55343.55,NULL,NULL,1,'2023-07-11 21:41:34','2023-07-11 21:41:34',NULL),(4171,7985,40721,3053,3,4067,'App\\Models\\Receipt',4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',90467.10,NULL,NULL,1,'2023-07-11 21:41:34','2023-07-11 21:41:34',NULL),(4172,7985,40721,3053,3,4068,'App\\Models\\Receipt',4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',20000.01,NULL,NULL,1,'2023-07-11 21:41:34','2023-07-11 21:41:34',NULL),(4173,7985,40721,3053,3,4069,'App\\Models\\Receipt',4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1593819.26,NULL,NULL,1,'2023-07-11 21:41:34','2023-07-11 21:41:34',NULL),(4174,7985,40721,3053,3,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1795.00,NULL,NULL,1,'2023-07-11 21:41:34','2023-07-11 21:41:34',NULL),(4175,7985,40721,3053,15,551,'App\\Models\\PeriodLiquidation',NULL,551,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',569778.95,NULL,NULL,1,'2023-07-11 21:50:29','2023-07-11 21:50:29',NULL),(4176,7985,40721,3053,16,552,'App\\Models\\PeriodLiquidation',NULL,552,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',506.30,NULL,NULL,1,'2023-07-11 21:54:34','2023-07-11 21:54:34',NULL),(4177,7985,40720,1537,15,527,'App\\Models\\PeriodLiquidation',NULL,527,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',18431.41,NULL,NULL,1,'2023-07-12 11:45:07','2023-07-12 11:45:07',NULL),(4178,7985,40720,1537,16,528,'App\\Models\\PeriodLiquidation',NULL,528,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3949.59,NULL,NULL,1,'2023-07-12 11:45:13','2023-07-12 11:45:13',NULL),(4179,7985,40720,1538,2,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',24200.00,NULL,NULL,1,'2023-07-12 15:54:25','2023-07-12 15:54:25',NULL),(4180,7985,40720,1538,2,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',25000.00,NULL,NULL,1,'2023-07-12 15:54:25','2023-07-12 15:54:25',NULL),(4181,7985,40720,1538,2,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',7000.04,NULL,NULL,1,'2023-07-12 15:54:25','2023-07-12 15:54:25',NULL),(4182,7985,40720,1538,2,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',50000.03,NULL,NULL,1,'2023-07-12 15:54:25','2023-07-12 15:54:25',NULL),(4183,7985,40720,1538,2,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',5000.02,NULL,NULL,1,'2023-07-12 15:54:25','2023-07-12 15:54:25',NULL),(4184,7985,40720,1538,2,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',45000.04,NULL,NULL,1,'2023-07-12 15:54:25','2023-07-12 15:54:25',NULL),(4185,7985,40720,1538,3,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',5509.23,NULL,NULL,1,'2023-07-12 15:54:38','2023-07-12 15:54:38',NULL);
INSERT INTO `balance_libro` VALUES (4186,7985,40720,1538,3,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',1702.47,NULL,NULL,1,'2023-07-12 15:54:38','2023-07-12 15:54:38',NULL),(4187,7985,40720,1538,3,4079,'App\\Models\\Receipt',4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',7917.57,NULL,NULL,1,'2023-07-12 15:54:38','2023-07-12 15:54:38',NULL),(4188,7985,40720,1538,15,557,'App\\Models\\PeriodLiquidation',NULL,557,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',27109.10,NULL,NULL,1,'2023-07-12 16:29:58','2023-07-12 16:29:58',NULL),(4189,7985,40720,1538,16,558,'App\\Models\\PeriodLiquidation',NULL,558,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5809.10,NULL,NULL,1,'2023-07-12 16:30:41','2023-07-12 16:30:41',NULL),(4423,7985,40767,31706,2,4313,'App\\Models\\Receipt',4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',50675.79,NULL,NULL,1,'2023-07-17 09:26:04','2023-07-17 09:26:04',NULL),(4424,7985,40767,31706,2,4314,'App\\Models\\Receipt',4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3610.00,NULL,NULL,1,'2023-07-17 09:26:04','2023-07-17 09:26:04',NULL),(4425,7985,40767,31706,2,4315,'App\\Models\\Receipt',4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3000.00,NULL,NULL,1,'2023-07-17 09:26:04','2023-07-17 09:26:04',NULL),(4426,7985,40767,31706,2,4316,'App\\Models\\Receipt',4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',640.00,NULL,NULL,1,'2023-07-17 09:26:04','2023-07-17 09:26:04',NULL),(4427,7985,40767,31706,2,4317,'App\\Models\\Receipt',4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',4420.00,NULL,NULL,1,'2023-07-17 09:26:05','2023-07-17 09:26:05',NULL),(4428,7985,40767,31706,2,4318,'App\\Models\\Receipt',4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',8847.00,NULL,NULL,1,'2023-07-17 09:26:05','2023-07-17 09:26:05',NULL),(4429,7985,40767,31706,2,4319,'App\\Models\\Receipt',4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',2760.00,NULL,NULL,1,'2023-07-17 09:26:05','2023-07-17 09:26:05',NULL),(4430,7985,40767,31706,2,4320,'App\\Models\\Receipt',4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',240.00,NULL,NULL,1,'2023-07-17 09:26:05','2023-07-17 09:26:05',NULL),(4431,7985,40767,31706,2,4321,'App\\Models\\Receipt',4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',870.00,NULL,NULL,1,'2023-07-17 09:26:05','2023-07-17 09:26:05',NULL),(4432,7985,40767,31706,2,4322,'App\\Models\\Receipt',4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',5820.00,NULL,NULL,1,'2023-07-17 09:26:05','2023-07-17 09:26:05',NULL),(4433,7985,40767,31706,2,4323,'App\\Models\\Receipt',4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',520.00,NULL,NULL,1,'2023-07-17 09:26:05','2023-07-17 09:26:05',NULL),(4434,7985,40767,31706,2,4324,'App\\Models\\Receipt',4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',8786.00,NULL,NULL,1,'2023-07-17 09:26:05','2023-07-17 09:26:05',NULL),(4435,7985,40767,31706,2,4325,'App\\Models\\Receipt',4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',36500.00,NULL,NULL,1,'2023-07-17 09:26:06','2023-07-17 09:26:06',NULL),(4436,7985,40767,31706,2,4326,'App\\Models\\Receipt',4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',860.00,NULL,NULL,1,'2023-07-17 09:26:06','2023-07-17 09:26:06',NULL),(4437,7985,40767,31706,2,4327,'App\\Models\\Receipt',4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',1445.00,NULL,NULL,1,'2023-07-17 09:26:06','2023-07-17 09:26:06',NULL),(4438,7985,40767,31706,2,4328,'App\\Models\\Receipt',4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',11334.00,NULL,NULL,1,'2023-07-17 09:26:06','2023-07-17 09:26:06',NULL),(4439,7985,40767,31706,2,4329,'App\\Models\\Receipt',4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',1100.00,NULL,NULL,1,'2023-07-17 09:26:06','2023-07-17 09:26:06',NULL);
INSERT INTO `balance_libro` VALUES (4440,7985,40767,31706,2,4330,'App\\Models\\Receipt',4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',3400.00,NULL,NULL,1,'2023-07-17 09:26:06','2023-07-17 09:26:06',NULL),(4441,7985,40767,31706,2,4331,'App\\Models\\Receipt',4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',2600.00,NULL,NULL,1,'2023-07-17 09:26:06','2023-07-17 09:26:06',NULL),(4442,7985,40767,31706,2,4332,'App\\Models\\Receipt',4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',1020.00,NULL,NULL,1,'2023-07-17 09:26:06','2023-07-17 09:26:06',NULL),(4443,7985,40767,31706,2,4333,'App\\Models\\Receipt',4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',2840.00,NULL,NULL,1,'2023-07-17 09:26:06','2023-07-17 09:26:06',NULL),(4444,7985,40767,31706,2,4334,'App\\Models\\Receipt',4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',1175.00,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4445,7985,40767,31706,2,4335,'App\\Models\\Receipt',4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',3075.00,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4446,7985,40767,31706,2,4336,'App\\Models\\Receipt',4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',280.00,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4447,7985,40767,31706,2,4337,'App\\Models\\Receipt',4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',17059.00,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4448,7985,40767,31706,2,4338,'App\\Models\\Receipt',4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',860.00,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4449,7985,40767,31706,2,4339,'App\\Models\\Receipt',4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',2070.00,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4450,7985,40767,31706,2,4340,'App\\Models\\Receipt',4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',5520.00,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4451,7985,40767,31706,2,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',1665.00,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4452,7985,40767,31706,2,4342,'App\\Models\\Receipt',4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',4274.80,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4453,7985,40767,31706,2,4343,'App\\Models\\Receipt',4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',5060.00,NULL,NULL,1,'2023-07-17 09:26:07','2023-07-17 09:26:07',NULL),(4454,7985,40767,31706,2,4344,'App\\Models\\Receipt',4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',3830.00,NULL,NULL,1,'2023-07-17 09:26:08','2023-07-17 09:26:08',NULL),(4455,7985,40767,31706,2,4345,'App\\Models\\Receipt',4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',7975.00,NULL,NULL,1,'2023-07-17 09:26:08','2023-07-17 09:26:08',NULL),(4456,7985,40767,31706,2,4346,'App\\Models\\Receipt',4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',11570.00,NULL,NULL,1,'2023-07-17 09:26:08','2023-07-17 09:26:08',NULL),(4457,7985,40767,31706,2,4347,'App\\Models\\Receipt',4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',4500.00,NULL,NULL,1,'2023-07-17 09:26:08','2023-07-17 09:26:08',NULL),(4458,7985,40767,31706,2,4348,'App\\Models\\Receipt',4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',3315.00,NULL,NULL,1,'2023-07-17 09:26:08','2023-07-17 09:26:08',NULL),(4459,7985,40767,31706,2,4349,'App\\Models\\Receipt',4349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',1185.00,NULL,NULL,1,'2023-07-17 09:26:08','2023-07-17 09:26:08',NULL),(4460,7985,40767,31706,2,4350,'App\\Models\\Receipt',4350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',1002.00,NULL,NULL,1,'2023-07-17 09:26:08','2023-07-17 09:26:08',NULL);
INSERT INTO `balance_libro` VALUES (4461,7985,40767,31706,2,4351,'App\\Models\\Receipt',4351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',10500.00,NULL,NULL,1,'2023-07-17 09:26:08','2023-07-17 09:26:08',NULL),(4462,7985,40767,31706,2,4352,'App\\Models\\Receipt',4352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',9350.00,NULL,NULL,1,'2023-07-17 09:26:08','2023-07-17 09:26:08',NULL),(4463,7985,40767,31706,2,4353,'App\\Models\\Receipt',4353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',4326.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4464,7985,40767,31706,2,4354,'App\\Models\\Receipt',4354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',1550.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4465,7985,40767,31706,2,4355,'App\\Models\\Receipt',4355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',1620.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4466,7985,40767,31706,2,4356,'App\\Models\\Receipt',4356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',2650.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4467,7985,40767,31706,2,4357,'App\\Models\\Receipt',4357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',656.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4468,7985,40767,31706,2,4358,'App\\Models\\Receipt',4358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',10630.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4469,7985,40767,31706,2,4359,'App\\Models\\Receipt',4359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',6229.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4470,7985,40767,31706,2,4360,'App\\Models\\Receipt',4360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',5550.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4471,7985,40767,31706,2,4361,'App\\Models\\Receipt',4361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',3440.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4472,7985,40767,31706,2,4362,'App\\Models\\Receipt',4362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',210.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4473,7985,40767,31706,2,4363,'App\\Models\\Receipt',4363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',20160.00,NULL,NULL,1,'2023-07-17 09:26:09','2023-07-17 09:26:09',NULL),(4474,7985,40767,31706,2,4364,'App\\Models\\Receipt',4364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1097.29,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4475,7985,40767,31706,2,4365,'App\\Models\\Receipt',4365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',57305.50,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4476,7985,40767,31706,2,4366,'App\\Models\\Receipt',4366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',14033.00,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4477,7985,40767,31706,2,4367,'App\\Models\\Receipt',4367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1097.29,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4478,7985,40767,31706,2,4368,'App\\Models\\Receipt',4368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1495.90,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4479,7985,40767,31706,2,4369,'App\\Models\\Receipt',4369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',3821.00,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4480,7985,40767,31706,2,4370,'App\\Models\\Receipt',4370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',7523.77,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4481,7985,40767,31706,2,4371,'App\\Models\\Receipt',4371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',901.28,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL);
INSERT INTO `balance_libro` VALUES (4482,7985,40767,31706,2,4372,'App\\Models\\Receipt',4372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',21722.75,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4483,7985,40767,31706,2,4373,'App\\Models\\Receipt',4373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1097.29,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4484,7985,40767,31706,2,4374,'App\\Models\\Receipt',4374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1960.00,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4485,7985,40767,31706,2,4375,'App\\Models\\Receipt',4375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',760.00,NULL,NULL,1,'2023-07-17 09:26:10','2023-07-17 09:26:10',NULL),(4486,7985,40767,31706,2,4376,'App\\Models\\Receipt',4376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',2660.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4487,7985,40767,31706,2,4377,'App\\Models\\Receipt',4377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1250.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4488,7985,40767,31706,2,4378,'App\\Models\\Receipt',4378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1140.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4489,7985,40767,31706,2,4379,'App\\Models\\Receipt',4379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',2260.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4490,7985,40767,31706,2,4380,'App\\Models\\Receipt',4380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',6820.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4491,7985,40767,31706,2,4381,'App\\Models\\Receipt',4381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',680.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4492,7985,40767,31706,2,4382,'App\\Models\\Receipt',4382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',2910.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4493,7985,40767,31706,2,4383,'App\\Models\\Receipt',4383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',7360.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4494,7985,40767,31706,2,4384,'App\\Models\\Receipt',4384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',13540.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4495,7985,40767,31706,2,4385,'App\\Models\\Receipt',4385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',2960.00,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4496,7985,40767,31706,2,4386,'App\\Models\\Receipt',4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',26601.80,NULL,NULL,1,'2023-07-17 09:26:11','2023-07-17 09:26:11',NULL),(4497,7985,40767,31706,2,4387,'App\\Models\\Receipt',4387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',1290.00,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL),(4498,7985,40767,31706,2,4388,'App\\Models\\Receipt',4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',9190.00,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL),(4499,7985,40767,31706,2,4389,'App\\Models\\Receipt',4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',10270.00,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL),(4500,7985,40767,31706,2,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',1400.00,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL),(4501,7985,40767,31706,2,4391,'App\\Models\\Receipt',4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',500.00,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL),(4502,7985,40767,31706,2,4392,'App\\Models\\Receipt',4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',2610.00,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL);
INSERT INTO `balance_libro` VALUES (4503,7985,40767,31706,2,4393,'App\\Models\\Receipt',4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',6720.00,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL),(4504,7985,40767,31706,2,4394,'App\\Models\\Receipt',4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',3965.00,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL),(4505,7985,40767,31706,2,4395,'App\\Models\\Receipt',4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',2166.30,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL),(4506,7985,40767,31706,2,4396,'App\\Models\\Receipt',4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',670.00,NULL,NULL,1,'2023-07-17 09:26:12','2023-07-17 09:26:12',NULL),(4507,7985,40767,31706,2,4397,'App\\Models\\Receipt',4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',3260.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4508,7985,40767,31706,2,4398,'App\\Models\\Receipt',4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',2120.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4509,7985,40767,31706,2,4399,'App\\Models\\Receipt',4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',6380.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4510,7985,40767,31706,2,4400,'App\\Models\\Receipt',4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',2540.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4511,7985,40767,31706,2,4401,'App\\Models\\Receipt',4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',3137.50,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4512,7985,40767,31706,2,4402,'App\\Models\\Receipt',4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',3035.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4513,7985,40767,31706,2,4403,'App\\Models\\Receipt',4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',1250.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4514,7985,40767,31706,2,4404,'App\\Models\\Receipt',4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',1790.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4515,7985,40767,31706,2,4405,'App\\Models\\Receipt',4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',720.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4516,7985,40767,31706,2,4406,'App\\Models\\Receipt',4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',880.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4517,7985,40767,31706,2,4407,'App\\Models\\Receipt',4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',7220.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4518,7985,40767,31706,2,4408,'App\\Models\\Receipt',4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',7025.00,NULL,NULL,1,'2023-07-17 09:26:13','2023-07-17 09:26:13',NULL),(4519,7985,40767,31706,2,4409,'App\\Models\\Receipt',4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',1060.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4520,7985,40767,31706,2,4410,'App\\Models\\Receipt',4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',2550.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4521,7985,40767,31706,2,4411,'App\\Models\\Receipt',4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',2140.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4522,7985,40767,31706,2,4412,'App\\Models\\Receipt',4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',1130.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4523,7985,40767,31706,2,4413,'App\\Models\\Receipt',4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',4710.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL);
INSERT INTO `balance_libro` VALUES (4524,7985,40767,31706,2,4414,'App\\Models\\Receipt',4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',480.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4525,7985,40767,31706,2,4415,'App\\Models\\Receipt',4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',5568.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4526,7985,40767,31706,2,4416,'App\\Models\\Receipt',4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',780.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4527,7985,40767,31706,2,4417,'App\\Models\\Receipt',4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',16300.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4528,7985,40767,31706,2,4418,'App\\Models\\Receipt',4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',760.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4529,7985,40767,31706,2,4419,'App\\Models\\Receipt',4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',3570.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4530,7985,40767,31706,2,4420,'App\\Models\\Receipt',4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',815.00,NULL,NULL,1,'2023-07-17 09:26:14','2023-07-17 09:26:14',NULL),(4531,7985,40767,31706,2,4421,'App\\Models\\Receipt',4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',9100.00,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4532,7985,40767,31706,2,4422,'App\\Models\\Receipt',4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',1620.00,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4533,7985,40767,31706,2,4423,'App\\Models\\Receipt',4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',3165.00,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4534,7985,40767,31706,2,4424,'App\\Models\\Receipt',4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',3575.00,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4535,7985,40767,31706,2,4425,'App\\Models\\Receipt',4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',4770.00,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4536,7985,40767,31706,2,4426,'App\\Models\\Receipt',4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',3680.00,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4537,7985,40767,31706,2,4427,'App\\Models\\Receipt',4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',31086.79,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4538,7985,40767,31706,2,4428,'App\\Models\\Receipt',4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',21702.10,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4539,7985,40767,31706,2,4429,'App\\Models\\Receipt',4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',9378.15,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4540,7985,40767,31706,2,4430,'App\\Models\\Receipt',4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',2789.97,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4541,7985,40767,31706,2,4431,'App\\Models\\Receipt',4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',10830.00,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4542,7985,40767,31706,2,4432,'App\\Models\\Receipt',4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',2595.00,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4543,7985,40767,31706,2,4433,'App\\Models\\Receipt',4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',200.00,NULL,NULL,1,'2023-07-17 09:26:15','2023-07-17 09:26:15',NULL),(4544,7985,40767,31706,2,4434,'App\\Models\\Receipt',4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',9825.20,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL);
INSERT INTO `balance_libro` VALUES (4545,7985,40767,31706,2,4435,'App\\Models\\Receipt',4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',19032.88,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4546,7985,40767,31706,2,4436,'App\\Models\\Receipt',4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',7790.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4547,7985,40767,31706,2,4437,'App\\Models\\Receipt',4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',1080.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4548,7985,40767,31706,2,4438,'App\\Models\\Receipt',4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',1360.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4549,7985,40767,31706,2,4439,'App\\Models\\Receipt',4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',4540.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4550,7985,40767,31706,2,4440,'App\\Models\\Receipt',4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',380.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4551,7985,40767,31706,2,4441,'App\\Models\\Receipt',4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',6530.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4552,7985,40767,31706,2,4442,'App\\Models\\Receipt',4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',9920.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4553,7985,40767,31706,2,4443,'App\\Models\\Receipt',4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',2050.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4554,7985,40767,31706,2,4444,'App\\Models\\Receipt',4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',2950.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4555,7985,40767,31706,2,4445,'App\\Models\\Receipt',4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',8223.00,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4556,7985,40767,31706,2,4446,'App\\Models\\Receipt',4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',2140.01,NULL,NULL,1,'2023-07-17 09:26:16','2023-07-17 09:26:16',NULL),(4557,7985,40767,31706,2,4447,'App\\Models\\Receipt',4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',180.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4558,7985,40767,31706,2,4448,'App\\Models\\Receipt',4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',3750.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4559,7985,40767,31706,2,4449,'App\\Models\\Receipt',4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',3700.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4560,7985,40767,31706,2,4450,'App\\Models\\Receipt',4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',2140.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4561,7985,40767,31706,2,4451,'App\\Models\\Receipt',4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',3800.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4562,7985,40767,31706,2,4452,'App\\Models\\Receipt',4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',2580.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4563,7985,40767,31706,2,4453,'App\\Models\\Receipt',4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',350.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4564,7985,40767,31706,2,4454,'App\\Models\\Receipt',4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',7480.01,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4565,7985,40767,31706,2,4455,'App\\Models\\Receipt',4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',421.52,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL);
INSERT INTO `balance_libro` VALUES (4566,7985,40767,31706,2,4456,'App\\Models\\Receipt',4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',4140.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4567,7985,40767,31706,2,4457,'App\\Models\\Receipt',4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',1170.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4568,7985,40767,31706,2,4458,'App\\Models\\Receipt',4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',7370.00,NULL,NULL,1,'2023-07-17 09:26:17','2023-07-17 09:26:17',NULL),(4569,7985,40767,31706,2,4459,'App\\Models\\Receipt',4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',6300.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4570,7985,40767,31706,2,4460,'App\\Models\\Receipt',4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',1290.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4571,7985,40767,31706,2,4461,'App\\Models\\Receipt',4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',9400.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4572,7985,40767,31706,2,4462,'App\\Models\\Receipt',4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',1697.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4573,7985,40767,31706,2,4463,'App\\Models\\Receipt',4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',15840.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4574,7985,40767,31706,2,4464,'App\\Models\\Receipt',4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',630.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4575,7985,40767,31706,2,4465,'App\\Models\\Receipt',4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',6170.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4576,7985,40767,31706,2,4466,'App\\Models\\Receipt',4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',1900.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4577,7985,40767,31706,2,4467,'App\\Models\\Receipt',4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2400.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4578,7985,40767,31706,2,4468,'App\\Models\\Receipt',4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',4186.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4579,7985,40767,31706,2,4469,'App\\Models\\Receipt',4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',3655.02,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4580,7985,40767,31706,2,4470,'App\\Models\\Receipt',4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',4790.00,NULL,NULL,1,'2023-07-17 09:26:18','2023-07-17 09:26:18',NULL),(4581,7985,40767,31706,2,4471,'App\\Models\\Receipt',4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',1750.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4582,7985,40767,31706,2,4472,'App\\Models\\Receipt',4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',430.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4583,7985,40767,31706,2,4473,'App\\Models\\Receipt',4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',5450.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4584,7985,40767,31706,2,4474,'App\\Models\\Receipt',4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',2240.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4585,7985,40767,31706,2,4475,'App\\Models\\Receipt',4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',410.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4586,7985,40767,31706,2,4476,'App\\Models\\Receipt',4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',3980.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL);
INSERT INTO `balance_libro` VALUES (4587,7985,40767,31706,2,4477,'App\\Models\\Receipt',4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',4260.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4588,7985,40767,31706,2,4478,'App\\Models\\Receipt',4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',1890.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4589,7985,40767,31706,2,4479,'App\\Models\\Receipt',4479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',14750.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4590,7985,40767,31706,2,4480,'App\\Models\\Receipt',4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',8830.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4591,7985,40767,31706,2,4481,'App\\Models\\Receipt',4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',3090.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4592,7985,40767,31706,2,4482,'App\\Models\\Receipt',4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',12650.00,NULL,NULL,1,'2023-07-17 09:26:19','2023-07-17 09:26:19',NULL),(4593,7985,40767,31706,2,4483,'App\\Models\\Receipt',4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',7490.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4594,7985,40767,31706,2,4484,'App\\Models\\Receipt',4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',2190.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4595,7985,40767,31706,2,4485,'App\\Models\\Receipt',4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',3000.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4596,7985,40767,31706,2,4486,'App\\Models\\Receipt',4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',2140.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4597,7985,40767,31706,2,4487,'App\\Models\\Receipt',4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',2190.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4598,7985,40767,31706,2,4488,'App\\Models\\Receipt',4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',6998.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4599,7985,40767,31706,2,4489,'App\\Models\\Receipt',4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',5300.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4600,7985,40767,31706,2,4490,'App\\Models\\Receipt',4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',3930.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4601,7985,40767,31706,2,4491,'App\\Models\\Receipt',4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',740.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4602,7985,40767,31706,2,4492,'App\\Models\\Receipt',4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',1746.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4603,7985,40767,31706,2,4493,'App\\Models\\Receipt',4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',7160.00,NULL,NULL,1,'2023-07-17 09:26:20','2023-07-17 09:26:20',NULL),(4604,7985,40767,31706,2,4494,'App\\Models\\Receipt',4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',5460.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4605,7985,40767,31706,2,4495,'App\\Models\\Receipt',4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',740.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4606,7985,40767,31706,2,4496,'App\\Models\\Receipt',4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',1200.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4607,7985,40767,31706,2,4497,'App\\Models\\Receipt',4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',2900.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL);
INSERT INTO `balance_libro` VALUES (4608,7985,40767,31706,2,4498,'App\\Models\\Receipt',4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',760.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4609,7985,40767,31706,2,4499,'App\\Models\\Receipt',4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',3660.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4610,7985,40767,31706,2,4500,'App\\Models\\Receipt',4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',11943.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4611,7985,40767,31706,2,4501,'App\\Models\\Receipt',4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',2200.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4612,7985,40767,31706,2,4502,'App\\Models\\Receipt',4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',14145.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4613,7985,40767,31706,2,4503,'App\\Models\\Receipt',4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',2210.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4614,7985,40767,31706,2,4504,'App\\Models\\Receipt',4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',3130.00,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4615,7985,40767,31706,2,4505,'App\\Models\\Receipt',4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',32285.64,NULL,NULL,1,'2023-07-17 09:26:21','2023-07-17 09:26:21',NULL),(4616,7985,40767,31706,2,4506,'App\\Models\\Receipt',4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',1360.83,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4617,7985,40767,31706,2,4507,'App\\Models\\Receipt',4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',18922.78,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4618,7985,40767,31706,2,4508,'App\\Models\\Receipt',4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',6557.26,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4619,7985,40767,31706,2,4509,'App\\Models\\Receipt',4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',760.00,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4620,7985,40767,31706,2,4510,'App\\Models\\Receipt',4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',180.05,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4621,7985,40767,31706,2,4511,'App\\Models\\Receipt',4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',5200.00,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4622,7985,40767,31706,2,4512,'App\\Models\\Receipt',4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',5590.00,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4623,7985,40767,31706,2,4513,'App\\Models\\Receipt',4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',16000.00,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4624,7985,40767,31706,2,4514,'App\\Models\\Receipt',4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',1520.00,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4625,7985,40767,31706,2,4515,'App\\Models\\Receipt',4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',1250.00,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4626,7985,40767,31706,2,4516,'App\\Models\\Receipt',4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',1600.00,NULL,NULL,1,'2023-07-17 09:26:22','2023-07-17 09:26:22',NULL),(4627,7985,40767,31706,2,4517,'App\\Models\\Receipt',4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',4420.00,NULL,NULL,1,'2023-07-17 09:26:23','2023-07-17 09:26:23',NULL),(4628,7985,40767,31706,2,4518,'App\\Models\\Receipt',4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',570.00,NULL,NULL,1,'2023-07-17 09:26:23','2023-07-17 09:26:23',NULL);
INSERT INTO `balance_libro` VALUES (4629,7985,40767,31706,2,4519,'App\\Models\\Receipt',4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',300.00,NULL,NULL,1,'2023-07-17 09:26:23','2023-07-17 09:26:23',NULL),(4630,7985,40767,31706,2,4520,'App\\Models\\Receipt',4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',400.00,NULL,NULL,1,'2023-07-17 09:26:23','2023-07-17 09:26:23',NULL),(4631,7985,40767,31706,2,4521,'App\\Models\\Receipt',4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',9525.00,NULL,NULL,1,'2023-07-17 09:26:23','2023-07-17 09:26:23',NULL),(4632,7985,40767,31706,2,4522,'App\\Models\\Receipt',4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',1924.81,NULL,NULL,1,'2023-07-17 09:26:23','2023-07-17 09:26:23',NULL),(4633,7985,40767,31706,2,4523,'App\\Models\\Receipt',4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',4541.10,NULL,NULL,1,'2023-07-17 09:26:23','2023-07-17 09:26:23',NULL),(4634,7985,40767,31706,2,4524,'App\\Models\\Receipt',4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',1520.00,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4635,7985,40767,31706,2,4525,'App\\Models\\Receipt',4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',2590.00,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4636,7985,40767,31706,2,4526,'App\\Models\\Receipt',4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',2020.00,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4637,7985,40767,31706,2,4527,'App\\Models\\Receipt',4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',9000.00,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4638,7985,40767,31706,2,4528,'App\\Models\\Receipt',4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',6800.00,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4639,7985,40767,31706,2,4529,'App\\Models\\Receipt',4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',1040.01,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4640,7985,40767,31706,2,4530,'App\\Models\\Receipt',4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',6817.10,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4641,7985,40767,31706,2,4531,'App\\Models\\Receipt',4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',7240.00,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4642,7985,40767,31706,2,4532,'App\\Models\\Receipt',4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',2065.00,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4643,7985,40767,31706,2,4533,'App\\Models\\Receipt',4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',2780.00,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4644,7985,40767,31706,2,4534,'App\\Models\\Receipt',4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',3326.00,NULL,NULL,1,'2023-07-17 09:26:24','2023-07-17 09:26:24',NULL),(4645,7985,40767,31706,2,4535,'App\\Models\\Receipt',4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',4370.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4646,7985,40767,31706,2,4536,'App\\Models\\Receipt',4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',300.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4647,7985,40767,31706,2,4537,'App\\Models\\Receipt',4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',2670.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4648,7985,40767,31706,2,4538,'App\\Models\\Receipt',4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',6210.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4649,7985,40767,31706,2,4539,'App\\Models\\Receipt',4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',3400.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL);
INSERT INTO `balance_libro` VALUES (4650,7985,40767,31706,2,4540,'App\\Models\\Receipt',4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',15600.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4651,7985,40767,31706,2,4541,'App\\Models\\Receipt',4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',8200.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4652,7985,40767,31706,2,4542,'App\\Models\\Receipt',4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',695.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4653,7985,40767,31706,2,4543,'App\\Models\\Receipt',4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',9600.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4654,7985,40767,31706,2,4544,'App\\Models\\Receipt',4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',4020.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4655,7985,40767,31706,2,4545,'App\\Models\\Receipt',4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',1290.00,NULL,NULL,1,'2023-07-17 09:26:25','2023-07-17 09:26:25',NULL),(4656,7985,40767,31706,2,4546,'App\\Models\\Receipt',4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',5680.00,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4657,7985,40767,31706,2,4547,'App\\Models\\Receipt',4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',41213.00,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4658,7985,40767,31706,2,4548,'App\\Models\\Receipt',4548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',1420.00,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4659,7985,40767,31706,2,4549,'App\\Models\\Receipt',4549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',6950.00,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4660,7985,40767,31706,2,4550,'App\\Models\\Receipt',4550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',1100.00,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4661,7985,40767,31706,2,4551,'App\\Models\\Receipt',4551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',15800.00,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4662,7985,40767,31706,2,4552,'App\\Models\\Receipt',4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',9521.61,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4663,7985,40767,31706,2,4553,'App\\Models\\Receipt',4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',1300.00,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4664,7985,40767,31706,2,4554,'App\\Models\\Receipt',4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',960.00,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4665,7985,40767,31706,2,4555,'App\\Models\\Receipt',4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',8435.00,NULL,NULL,1,'2023-07-17 09:26:26','2023-07-17 09:26:26',NULL),(4666,7985,40767,31706,2,4556,'App\\Models\\Receipt',4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',440.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4667,7985,40767,31706,2,4557,'App\\Models\\Receipt',4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',8630.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4668,7985,40767,31706,2,4558,'App\\Models\\Receipt',4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',970.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4669,7985,40767,31706,2,4559,'App\\Models\\Receipt',4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',4090.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4670,7985,40767,31706,2,4560,'App\\Models\\Receipt',4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',3880.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL);
INSERT INTO `balance_libro` VALUES (4671,7985,40767,31706,2,4561,'App\\Models\\Receipt',4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',1130.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4672,7985,40767,31706,2,4562,'App\\Models\\Receipt',4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',16520.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4673,7985,40767,31706,2,4563,'App\\Models\\Receipt',4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',670.60,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4674,7985,40767,31706,2,4564,'App\\Models\\Receipt',4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',2650.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4675,7985,40767,31706,2,4565,'App\\Models\\Receipt',4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',690.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4676,7985,40767,31706,2,4566,'App\\Models\\Receipt',4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',12740.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4677,7985,40767,31706,2,4567,'App\\Models\\Receipt',4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1860.00,NULL,NULL,1,'2023-07-17 09:26:27','2023-07-17 09:26:27',NULL),(4678,7985,40767,31706,2,4568,'App\\Models\\Receipt',4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',4200.00,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4679,7985,40767,31706,2,4569,'App\\Models\\Receipt',4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',4550.00,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4680,7985,40767,31706,2,4570,'App\\Models\\Receipt',4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',170.00,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4681,7985,40767,31706,2,4571,'App\\Models\\Receipt',4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1290.00,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4682,7985,40767,31706,2,4572,'App\\Models\\Receipt',4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',14721.10,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4683,7985,40767,31706,2,4573,'App\\Models\\Receipt',4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',31472.97,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4684,7985,40767,31706,2,4574,'App\\Models\\Receipt',4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',7356.80,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4685,7985,40767,31706,2,4575,'App\\Models\\Receipt',4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',5260.00,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4686,7985,40767,31706,2,4576,'App\\Models\\Receipt',4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',10500.00,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4687,7985,40767,31706,2,4577,'App\\Models\\Receipt',4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',11500.00,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4688,7985,40767,31706,2,4578,'App\\Models\\Receipt',4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',2090.00,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4689,7985,40767,31706,2,4579,'App\\Models\\Receipt',4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',2470.00,NULL,NULL,1,'2023-07-17 09:26:28','2023-07-17 09:26:28',NULL),(4690,7985,40767,31706,2,4580,'App\\Models\\Receipt',4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',2167.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4691,7985,40767,31706,2,4581,'App\\Models\\Receipt',4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',38977.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL);
INSERT INTO `balance_libro` VALUES (4692,7985,40767,31706,2,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',120.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4693,7985,40767,31706,2,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',14980.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4694,7985,40767,31706,2,4584,'App\\Models\\Receipt',4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',900.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4695,7985,40767,31706,2,4585,'App\\Models\\Receipt',4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4150.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4696,7985,40767,31706,2,4586,'App\\Models\\Receipt',4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1200.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4697,7985,40767,31706,2,4587,'App\\Models\\Receipt',4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',800.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4698,7985,40767,31706,2,4588,'App\\Models\\Receipt',4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2530.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4699,7985,40767,31706,2,4589,'App\\Models\\Receipt',4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1390.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4700,7985,40767,31706,2,4590,'App\\Models\\Receipt',4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4660.00,NULL,NULL,1,'2023-07-17 09:26:29','2023-07-17 09:26:29',NULL),(4701,7985,40767,31706,2,4591,'App\\Models\\Receipt',4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',13320.00,NULL,NULL,1,'2023-07-17 09:26:30','2023-07-17 09:26:30',NULL),(4702,7985,40767,31706,2,4592,'App\\Models\\Receipt',4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',870.00,NULL,NULL,1,'2023-07-17 09:26:30','2023-07-17 09:26:30',NULL),(4703,7985,40767,31706,2,4593,'App\\Models\\Receipt',4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',700.00,NULL,NULL,1,'2023-07-17 09:26:30','2023-07-17 09:26:30',NULL),(4704,7985,40769,30203,3,4594,'App\\Models\\Receipt',4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',12890.30,NULL,NULL,1,'2023-07-17 09:27:47','2023-07-17 09:27:47',NULL),(4705,7985,40769,30203,3,4595,'App\\Models\\Receipt',4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',37670.46,NULL,NULL,1,'2023-07-17 09:27:47','2023-07-17 09:27:47',NULL),(4706,7985,40769,30203,3,4596,'App\\Models\\Receipt',4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',65632.76,NULL,NULL,1,'2023-07-17 09:27:47','2023-07-17 09:27:47',NULL),(4707,7985,40769,30203,3,4597,'App\\Models\\Receipt',4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',5307.00,NULL,NULL,1,'2023-07-17 09:27:47','2023-07-17 09:27:47',NULL),(4708,7985,40769,30203,3,4598,'App\\Models\\Receipt',4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',29174.74,NULL,NULL,1,'2023-07-17 09:27:47','2023-07-17 09:27:47',NULL),(4709,7985,40769,30203,3,4599,'App\\Models\\Receipt',4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',5168.37,NULL,NULL,1,'2023-07-17 09:27:47','2023-07-17 09:27:47',NULL),(4710,7985,40769,30203,3,4600,'App\\Models\\Receipt',4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',58631.01,NULL,NULL,1,'2023-07-17 09:27:47','2023-07-17 09:27:47',NULL),(4711,7985,40769,30203,3,4601,'App\\Models\\Receipt',4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',78165.30,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4712,7985,40769,30203,3,4602,'App\\Models\\Receipt',4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',12755.72,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL);
INSERT INTO `balance_libro` VALUES (4713,7985,40769,30203,3,4603,'App\\Models\\Receipt',4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',6523.21,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4714,7985,40769,30203,3,4604,'App\\Models\\Receipt',4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',10207.90,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4715,7985,40769,30203,3,4605,'App\\Models\\Receipt',4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',22573.66,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4716,7985,40769,30203,3,4606,'App\\Models\\Receipt',4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',9630.10,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4717,7985,40769,30203,3,4607,'App\\Models\\Receipt',4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',17821.38,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4718,7985,40769,30203,3,4608,'App\\Models\\Receipt',4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',405.56,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4719,7985,40769,30203,3,4609,'App\\Models\\Receipt',4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',46984.08,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4720,7985,40769,30203,3,4610,'App\\Models\\Receipt',4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',4324.77,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4721,7985,40769,30203,3,4611,'App\\Models\\Receipt',4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',5840.08,NULL,NULL,1,'2023-07-17 09:27:48','2023-07-17 09:27:48',NULL),(4722,7985,40769,30203,3,4612,'App\\Models\\Receipt',4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',5711.14,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4723,7985,40769,30203,3,4613,'App\\Models\\Receipt',4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',22694.41,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4724,7985,40769,30203,3,4614,'App\\Models\\Receipt',4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',31473.76,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4725,7985,40769,30203,3,4615,'App\\Models\\Receipt',4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',28801.03,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4726,7985,40769,30203,3,4616,'App\\Models\\Receipt',4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',96202.96,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4727,7985,40769,30203,3,4617,'App\\Models\\Receipt',4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',124136.64,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4728,7985,40769,30203,3,4618,'App\\Models\\Receipt',4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10313.96,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4729,7985,40769,30203,3,4619,'App\\Models\\Receipt',4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',25020.51,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4730,7985,40769,30203,3,4620,'App\\Models\\Receipt',4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',28092.00,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4731,7985,40769,30203,3,4621,'App\\Models\\Receipt',4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',9197.50,NULL,NULL,1,'2023-07-17 09:27:49','2023-07-17 09:27:49',NULL),(4732,7985,40767,31706,3,4622,'App\\Models\\Receipt',4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',12890.30,NULL,NULL,1,'2023-07-17 09:33:05','2023-07-17 09:33:05',NULL),(4733,7985,40767,31706,3,4623,'App\\Models\\Receipt',4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',37670.46,NULL,NULL,1,'2023-07-17 09:33:05','2023-07-17 09:33:05',NULL);
INSERT INTO `balance_libro` VALUES (4734,7985,40767,31706,3,4624,'App\\Models\\Receipt',4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',65632.76,NULL,NULL,1,'2023-07-17 09:33:05','2023-07-17 09:33:05',NULL),(4735,7985,40767,31706,3,4625,'App\\Models\\Receipt',4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',5307.00,NULL,NULL,1,'2023-07-17 09:33:05','2023-07-17 09:33:05',NULL),(4736,7985,40767,31706,3,4626,'App\\Models\\Receipt',4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',29174.74,NULL,NULL,1,'2023-07-17 09:33:05','2023-07-17 09:33:05',NULL),(4737,7985,40767,31706,3,4627,'App\\Models\\Receipt',4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',5168.37,NULL,NULL,1,'2023-07-17 09:33:05','2023-07-17 09:33:05',NULL),(4738,7985,40767,31706,3,4628,'App\\Models\\Receipt',4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',58631.01,NULL,NULL,1,'2023-07-17 09:33:05','2023-07-17 09:33:05',NULL),(4739,7985,40767,31706,3,4629,'App\\Models\\Receipt',4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',78165.30,NULL,NULL,1,'2023-07-17 09:33:05','2023-07-17 09:33:05',NULL),(4740,7985,40767,31706,3,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',12755.72,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4741,7985,40767,31706,3,4631,'App\\Models\\Receipt',4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',6523.21,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4742,7985,40767,31706,3,4632,'App\\Models\\Receipt',4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',10207.90,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4743,7985,40767,31706,3,4633,'App\\Models\\Receipt',4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',22573.66,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4744,7985,40767,31706,3,4634,'App\\Models\\Receipt',4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',9630.10,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4745,7985,40767,31706,3,4635,'App\\Models\\Receipt',4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',17821.38,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4746,7985,40767,31706,3,4636,'App\\Models\\Receipt',4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',405.56,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4747,7985,40767,31706,3,4637,'App\\Models\\Receipt',4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',46984.08,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4748,7985,40767,31706,3,4638,'App\\Models\\Receipt',4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',4324.77,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4749,7985,40767,31706,3,4639,'App\\Models\\Receipt',4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',5840.08,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4750,7985,40767,31706,3,4640,'App\\Models\\Receipt',4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',5711.14,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4751,7985,40767,31706,3,4641,'App\\Models\\Receipt',4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',22694.41,NULL,NULL,1,'2023-07-17 09:33:06','2023-07-17 09:33:06',NULL),(4752,7985,40767,31706,3,4642,'App\\Models\\Receipt',4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',31473.76,NULL,NULL,1,'2023-07-17 09:33:07','2023-07-17 09:33:07',NULL),(4753,7985,40767,31706,3,4643,'App\\Models\\Receipt',4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',28801.03,NULL,NULL,1,'2023-07-17 09:33:07','2023-07-17 09:33:07',NULL),(4754,7985,40767,31706,3,4644,'App\\Models\\Receipt',4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',96202.96,NULL,NULL,1,'2023-07-17 09:33:07','2023-07-17 09:33:07',NULL);
INSERT INTO `balance_libro` VALUES (4755,7985,40767,31706,3,4645,'App\\Models\\Receipt',4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',124136.64,NULL,NULL,1,'2023-07-17 09:33:07','2023-07-17 09:33:07',NULL),(4756,7985,40767,31706,3,4646,'App\\Models\\Receipt',4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10313.96,NULL,NULL,1,'2023-07-17 09:33:07','2023-07-17 09:33:07',NULL),(4757,7985,40767,31706,3,4647,'App\\Models\\Receipt',4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',25020.51,NULL,NULL,1,'2023-07-17 09:33:07','2023-07-17 09:33:07',NULL),(4758,7985,40767,31706,3,4648,'App\\Models\\Receipt',4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',28092.00,NULL,NULL,1,'2023-07-17 09:33:07','2023-07-17 11:17:32','2023-07-17 11:17:32'),(4759,7985,40767,31706,3,4649,'App\\Models\\Receipt',4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',9197.50,NULL,NULL,1,'2023-07-17 09:33:07','2023-07-17 09:33:07',NULL),(4760,7985,40767,31706,7,4650,'App\\Models\\Receipt',4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',471.57,NULL,NULL,1,'2023-07-17 10:01:09','2023-07-17 10:01:09',NULL),(4761,7985,40767,31706,7,4651,'App\\Models\\Receipt',4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',907.98,NULL,NULL,1,'2023-07-17 10:01:09','2023-07-17 10:01:09',NULL),(4762,7985,40767,31706,7,4652,'App\\Models\\Receipt',4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',80.15,NULL,NULL,1,'2023-07-17 10:01:18','2023-07-17 10:01:18',NULL),(4763,7985,40767,31706,7,4653,'App\\Models\\Receipt',4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2.70,NULL,NULL,1,'2023-07-17 10:01:18','2023-07-17 10:01:18',NULL),(4764,7985,40767,31706,7,4654,'App\\Models\\Receipt',4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',221.10,NULL,NULL,1,'2023-07-17 10:01:18','2023-07-17 10:01:18',NULL),(4765,7985,40767,31706,3,4655,'App\\Models\\Receipt',4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',28922.58,NULL,NULL,1,'2023-07-17 11:25:05','2023-07-17 11:25:05',NULL),(4766,7985,40767,31706,15,572,'App\\Models\\PeriodLiquidation',NULL,572,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',282237.05,NULL,NULL,1,'2023-07-17 12:09:53','2023-07-17 12:09:53',NULL),(4767,7985,40763,28703,2,4656,'App\\Models\\Receipt',4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',29174.74,NULL,NULL,1,'2023-07-18 16:13:21','2023-07-18 16:13:21',NULL),(4768,7985,40763,28703,2,4657,'App\\Models\\Receipt',4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',329531.40,NULL,NULL,1,'2023-07-18 16:13:21','2023-07-18 16:13:21',NULL),(4769,7985,40763,28703,3,4658,'App\\Models\\Receipt',4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',2761.17,NULL,NULL,1,'2023-07-18 16:13:42','2023-07-18 16:13:42',NULL),(4770,7985,40763,28703,3,4659,'App\\Models\\Receipt',4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',7556.32,NULL,NULL,1,'2023-07-18 16:13:42','2023-07-18 16:13:42',NULL),(4771,7985,40763,28703,3,4660,'App\\Models\\Receipt',4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',10760.01,NULL,NULL,1,'2023-07-18 16:13:43','2023-07-18 16:13:43',NULL),(4772,7985,40763,28703,3,4661,'App\\Models\\Receipt',4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',252840.34,NULL,NULL,1,'2023-07-18 16:13:43','2023-07-18 16:13:43',NULL),(4773,7985,40763,28703,3,4662,'App\\Models\\Receipt',4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',10844.28,NULL,NULL,1,'2023-07-18 16:13:43','2023-07-18 16:13:43',NULL),(4774,7985,40763,28703,15,578,'App\\Models\\PeriodLiquidation',NULL,578,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',62254.78,NULL,NULL,1,'2023-07-18 16:21:24','2023-07-18 16:21:24',NULL);
INSERT INTO `balance_libro` VALUES (4775,7985,40763,28703,16,579,'App\\Models\\PeriodLiquidation',NULL,579,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',65.10,NULL,NULL,1,'2023-07-18 16:54:41','2023-07-18 16:54:41',NULL),(4776,7985,40721,3054,2,4663,'App\\Models\\Receipt',4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',852508.80,NULL,NULL,1,'2023-08-09 11:15:57','2023-08-09 11:15:57',NULL),(4777,7985,40721,3054,3,4664,'App\\Models\\Receipt',4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',5384.92,NULL,NULL,1,'2023-08-09 11:16:10','2023-08-09 11:16:10',NULL),(4778,7985,40721,3054,3,4665,'App\\Models\\Receipt',4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',7975.94,NULL,NULL,1,'2023-08-09 11:16:10','2023-08-09 11:16:10',NULL),(4779,7985,40721,3054,3,4666,'App\\Models\\Receipt',4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',7780.31,NULL,NULL,1,'2023-08-09 11:16:10','2023-08-09 11:16:10',NULL),(4780,7985,40721,3054,3,4667,'App\\Models\\Receipt',4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',852509.13,NULL,NULL,1,'2023-08-09 11:16:10','2023-08-09 11:16:10',NULL),(4781,7985,40721,3054,3,4668,'App\\Models\\Receipt',4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',65798.51,NULL,NULL,1,'2023-08-09 11:16:10','2023-08-09 11:16:10',NULL),(4782,7985,40721,3054,3,4669,'App\\Models\\Receipt',4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1790.07,NULL,NULL,1,'2023-08-09 11:16:10','2023-08-09 11:16:10',NULL),(4783,7985,40721,3054,3,4670,'App\\Models\\Receipt',4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',20989.75,NULL,NULL,1,'2023-08-09 11:16:10','2023-08-09 11:16:10',NULL),(4784,7985,40721,3054,3,4671,'App\\Models\\Receipt',4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',33958.40,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4785,7985,40721,3054,3,4672,'App\\Models\\Receipt',4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',101875.19,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4786,7985,40721,3054,3,4673,'App\\Models\\Receipt',4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',81257.10,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4787,7985,40721,3054,3,4674,'App\\Models\\Receipt',4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',14149.63,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4788,7985,40721,3054,3,4675,'App\\Models\\Receipt',4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',6500.00,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4789,7985,40721,3054,3,4676,'App\\Models\\Receipt',4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-09','2023-07-09',12740.00,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4790,7985,40721,3054,3,4677,'App\\Models\\Receipt',4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',16700.00,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4791,7985,40721,3054,3,4678,'App\\Models\\Receipt',4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',10756.07,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4792,7985,40721,3054,3,4679,'App\\Models\\Receipt',4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',6728.69,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4793,7985,40721,3054,3,4680,'App\\Models\\Receipt',4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',88578.97,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4794,7985,40721,3054,3,4681,'App\\Models\\Receipt',4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',15629.52,NULL,NULL,1,'2023-08-09 11:16:11','2023-08-09 11:16:11',NULL),(4795,7985,40721,3054,3,4682,'App\\Models\\Receipt',4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',194561.52,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL);
INSERT INTO `balance_libro` VALUES (4796,7985,40721,3054,3,4683,'App\\Models\\Receipt',4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-23','2023-07-23',278863.00,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4797,7985,40721,3054,3,4684,'App\\Models\\Receipt',4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',45040.00,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4798,7985,40721,3054,3,4685,'App\\Models\\Receipt',4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',17401.28,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4799,7985,40721,3054,3,4686,'App\\Models\\Receipt',4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',17401.28,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4800,7985,40721,3054,3,4687,'App\\Models\\Receipt',4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',2410.00,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4801,7985,40721,3054,3,4688,'App\\Models\\Receipt',4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',20510.00,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4802,7985,40721,3054,3,4689,'App\\Models\\Receipt',4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',22351.69,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4803,7985,40721,3054,3,4690,'App\\Models\\Receipt',4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',8000.00,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4804,7985,40721,3054,3,4691,'App\\Models\\Receipt',4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',1795.00,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4805,7985,40721,3054,3,4692,'App\\Models\\Receipt',4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',21850.32,NULL,NULL,1,'2023-08-09 11:16:12','2023-08-09 11:16:12',NULL),(4810,7985,40720,1539,2,4697,'App\\Models\\Receipt',4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',25000.00,NULL,NULL,1,'2023-08-15 21:05:37','2023-08-15 21:05:37',NULL),(4811,7985,40720,1539,2,4698,'App\\Models\\Receipt',4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',5000.02,NULL,NULL,1,'2023-08-15 21:05:37','2023-08-15 21:05:37',NULL),(4812,7985,40720,1539,2,4699,'App\\Models\\Receipt',4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',24200.00,NULL,NULL,1,'2023-08-15 21:05:37','2023-08-15 21:05:37',NULL),(4813,7985,40720,1539,2,4700,'App\\Models\\Receipt',4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',95000.00,NULL,NULL,1,'2023-08-15 21:05:37','2023-08-15 21:05:37',NULL),(4814,7985,40720,1539,2,4701,'App\\Models\\Receipt',4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',7000.04,NULL,NULL,1,'2023-08-15 21:05:37','2023-08-15 21:05:37',NULL),(4815,7985,40720,1539,3,4702,'App\\Models\\Receipt',4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',5889.18,NULL,NULL,1,'2023-08-15 21:05:48','2023-08-15 21:05:48',NULL),(4816,7985,40720,1539,3,4703,'App\\Models\\Receipt',4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',5186.32,NULL,NULL,1,'2023-08-15 21:05:49','2023-08-15 21:05:49',NULL),(4817,7985,40720,1539,3,4704,'App\\Models\\Receipt',4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',12020.19,NULL,NULL,1,'2023-08-15 21:05:49','2023-08-15 21:05:49',NULL),(4818,7985,40720,1539,3,4705,'App\\Models\\Receipt',4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',4469.12,NULL,NULL,1,'2023-08-15 21:05:49','2023-08-15 21:05:49',NULL),(4819,7985,40720,1539,3,4706,'App\\Models\\Receipt',4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',16000.62,NULL,NULL,1,'2023-08-15 21:05:49','2023-08-15 21:05:49',NULL),(4820,7985,40720,1539,3,4707,'App\\Models\\Receipt',4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',13994.19,NULL,NULL,1,'2023-08-15 21:05:49','2023-08-15 21:05:49',NULL);
INSERT INTO `balance_libro` VALUES (4821,7985,40720,1539,3,4708,'App\\Models\\Receipt',4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',6501.94,NULL,NULL,1,'2023-08-15 21:05:49','2023-08-15 21:05:49',NULL),(4822,7985,40720,1539,3,4709,'App\\Models\\Receipt',4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',600.00,NULL,NULL,1,'2023-08-15 21:05:49','2023-08-15 21:05:49',NULL),(4823,7985,40720,1539,3,4710,'App\\Models\\Receipt',4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',45180.96,NULL,NULL,1,'2023-08-15 21:05:49','2023-08-15 21:05:49',NULL),(4824,7985,40720,1539,15,590,'App\\Models\\PeriodLiquidation',NULL,590,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',27109.09,NULL,NULL,1,'2023-08-15 21:08:34','2023-08-15 21:08:34',NULL),(4825,7985,40720,1539,16,591,'App\\Models\\PeriodLiquidation',NULL,591,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5809.09,NULL,NULL,1,'2023-08-16 11:01:00','2023-08-16 11:01:00',NULL),(4831,7985,40721,3054,7,4716,'App\\Models\\Receipt',4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2968.86,NULL,NULL,1,'2023-08-17 16:54:30','2023-08-17 16:54:30',NULL),(4832,7985,40763,28704,2,4717,'App\\Models\\Receipt',4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',56683.22,NULL,NULL,1,'2023-08-20 10:36:43','2023-08-20 10:36:43',NULL),(4833,7985,40763,28704,3,4718,'App\\Models\\Receipt',4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',2885.43,NULL,NULL,1,'2023-08-20 10:36:56','2023-08-20 10:36:56',NULL),(4834,7985,40763,28704,3,4719,'App\\Models\\Receipt',4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',7990.01,NULL,NULL,1,'2023-08-20 10:36:56','2023-08-20 10:36:56',NULL),(4835,7985,40763,28704,3,4720,'App\\Models\\Receipt',4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',10144.64,NULL,NULL,1,'2023-08-20 10:36:56','2023-08-20 10:36:56',NULL),(4836,7985,40763,28704,3,4721,'App\\Models\\Receipt',4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',12340.20,NULL,NULL,1,'2023-08-20 10:36:56','2023-08-20 10:36:56',NULL),(4837,7985,40763,28704,7,4722,'App\\Models\\Receipt',4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',173.70,NULL,NULL,1,'2023-08-20 19:43:15','2023-08-20 19:43:15',NULL),(4838,7985,40767,31706,16,573,'App\\Models\\PeriodLiquidation',NULL,573,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',58367.94,NULL,NULL,1,'2023-08-21 18:38:44','2023-08-21 18:38:44',NULL),(4839,7985,40767,31707,3,4723,'App\\Models\\Receipt',4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',79063.60,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4840,7985,40767,31707,3,4724,'App\\Models\\Receipt',4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',13680.27,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4841,7985,40767,31707,3,4725,'App\\Models\\Receipt',4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',12650.17,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4842,7985,40767,31707,3,4726,'App\\Models\\Receipt',4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',8700.65,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4843,7985,40767,31707,3,4727,'App\\Models\\Receipt',4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',86564.67,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4844,7985,40767,31707,3,4728,'App\\Models\\Receipt',4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',124428.82,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4845,7985,40767,31707,3,4729,'App\\Models\\Receipt',4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',49954.59,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL);
INSERT INTO `balance_libro` VALUES (4846,7985,40767,31707,3,4730,'App\\Models\\Receipt',4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',6555.02,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4847,7985,40767,31707,3,4731,'App\\Models\\Receipt',4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',90271.66,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4848,7985,40767,31707,3,4732,'App\\Models\\Receipt',4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',14443.47,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4849,7985,40767,31707,3,4733,'App\\Models\\Receipt',4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',356.84,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4850,7985,40767,31707,3,4734,'App\\Models\\Receipt',4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',144767.38,NULL,NULL,1,'2023-08-21 18:41:07','2023-08-21 18:41:07',NULL),(4851,7985,40767,31707,3,4735,'App\\Models\\Receipt',4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',76235.26,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4852,7985,40767,31707,3,4736,'App\\Models\\Receipt',4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',104858.43,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4853,7985,40767,31707,3,4737,'App\\Models\\Receipt',4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',91817.99,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4854,7985,40767,31707,3,4738,'App\\Models\\Receipt',4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',20498.10,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4855,7985,40767,31707,3,4739,'App\\Models\\Receipt',4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',3319.64,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4856,7985,40767,31707,3,4740,'App\\Models\\Receipt',4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',82343.07,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4857,7985,40767,31707,3,4741,'App\\Models\\Receipt',4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',21549.89,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4858,7985,40767,31707,3,4742,'App\\Models\\Receipt',4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',33992.44,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4859,7985,40767,31707,3,4743,'App\\Models\\Receipt',4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',32793.00,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4860,7985,40767,31707,3,4744,'App\\Models\\Receipt',4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',98900.00,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4861,7985,40767,31707,3,4745,'App\\Models\\Receipt',4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',101024.35,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4862,7985,40767,31707,3,4746,'App\\Models\\Receipt',4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',19689.83,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4863,7985,40767,31707,3,4747,'App\\Models\\Receipt',4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',106608.80,NULL,NULL,1,'2023-08-21 18:41:08','2023-08-21 18:41:08',NULL),(4864,7985,40767,31707,3,4748,'App\\Models\\Receipt',4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',63510.14,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4865,7985,40767,31707,3,4749,'App\\Models\\Receipt',4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',281069.03,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4866,7985,40767,31707,3,4750,'App\\Models\\Receipt',4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',43791.85,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL);
INSERT INTO `balance_libro` VALUES (4867,7985,40767,31707,3,4751,'App\\Models\\Receipt',4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',61229.07,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4868,7985,40767,31707,3,4752,'App\\Models\\Receipt',4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',70265.27,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4869,7985,40767,31707,3,4753,'App\\Models\\Receipt',4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',5471.57,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4870,7985,40767,31707,3,4754,'App\\Models\\Receipt',4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',17386.24,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4871,7985,40767,31707,3,4755,'App\\Models\\Receipt',4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',23097.71,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4872,7985,40767,31707,3,4756,'App\\Models\\Receipt',4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',10161.63,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4873,7985,40767,31707,3,4757,'App\\Models\\Receipt',4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',11165.00,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4874,7985,40767,31707,3,4758,'App\\Models\\Receipt',4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',18035.15,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4875,7985,40767,31707,3,4759,'App\\Models\\Receipt',4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',6717.23,NULL,NULL,1,'2023-08-21 18:41:09','2023-08-21 18:41:09',NULL),(4876,7985,40767,31707,3,4760,'App\\Models\\Receipt',4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',17724.08,NULL,NULL,1,'2023-08-21 18:41:10','2023-08-21 18:41:10',NULL),(4877,7985,40767,31707,3,4761,'App\\Models\\Receipt',4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',9350.70,NULL,NULL,1,'2023-08-21 18:41:10','2023-08-21 18:41:10',NULL),(4878,7985,40767,31707,3,4762,'App\\Models\\Receipt',4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',167420.93,NULL,NULL,1,'2023-08-21 18:41:10','2023-08-21 18:41:10',NULL),(4879,7985,40767,31707,3,4763,'App\\Models\\Receipt',4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',14050.70,NULL,NULL,1,'2023-08-21 18:41:10','2023-08-21 18:41:10',NULL),(4880,7985,40767,31707,3,4764,'App\\Models\\Receipt',4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',51509.80,NULL,NULL,1,'2023-08-21 18:41:10','2023-08-21 18:41:10',NULL),(4881,7985,40767,31707,3,4765,'App\\Models\\Receipt',4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',1244.07,NULL,NULL,1,'2023-08-21 18:41:10','2023-08-21 18:41:10',NULL),(4882,7985,40767,31707,3,4766,'App\\Models\\Receipt',4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',125643.42,NULL,NULL,1,'2023-08-21 18:41:10','2023-08-21 18:41:10',NULL),(4883,7985,40767,31707,3,4767,'App\\Models\\Receipt',4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',20102.95,NULL,NULL,1,'2023-08-21 18:41:10','2023-08-21 18:41:10',NULL),(4884,7985,40767,31707,2,4768,'App\\Models\\Receipt',4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',13400.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4885,7985,40767,31707,2,4769,'App\\Models\\Receipt',4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',1225.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4886,7985,40767,31707,2,4770,'App\\Models\\Receipt',4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',1550.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4887,7985,40767,31707,2,4771,'App\\Models\\Receipt',4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',240.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL);
INSERT INTO `balance_libro` VALUES (4888,7985,40767,31707,2,4772,'App\\Models\\Receipt',4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',160.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4889,7985,40767,31707,2,4773,'App\\Models\\Receipt',4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',3575.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4890,7985,40767,31707,2,4774,'App\\Models\\Receipt',4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',6600.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4891,7985,40767,31707,2,4775,'App\\Models\\Receipt',4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',6490.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4892,7985,40767,31707,2,4776,'App\\Models\\Receipt',4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',31687.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4893,7985,40767,31707,2,4777,'App\\Models\\Receipt',4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',820.00,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4894,7985,40767,31707,2,4778,'App\\Models\\Receipt',4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',23973.19,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4895,7985,40767,31707,2,4779,'App\\Models\\Receipt',4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',285.39,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4896,7985,40767,31707,2,4780,'App\\Models\\Receipt',4780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',6906.26,NULL,NULL,1,'2023-08-21 18:42:59','2023-08-21 18:42:59',NULL),(4897,7985,40767,31707,2,4781,'App\\Models\\Receipt',4781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',53998.96,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4898,7985,40767,31707,2,4782,'App\\Models\\Receipt',4782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',3780.28,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4899,7985,40767,31707,2,4783,'App\\Models\\Receipt',4783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',6968.60,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4900,7985,40767,31707,2,4784,'App\\Models\\Receipt',4784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',800.00,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4901,7985,40767,31707,2,4785,'App\\Models\\Receipt',4785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',2430.00,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4902,7985,40767,31707,2,4786,'App\\Models\\Receipt',4786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',7099.00,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4903,7985,40767,31707,2,4787,'App\\Models\\Receipt',4787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1880.00,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4904,7985,40767,31707,2,4788,'App\\Models\\Receipt',4788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',4855.00,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4905,7985,40767,31707,2,4789,'App\\Models\\Receipt',4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',2080.00,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4906,7985,40767,31707,2,4790,'App\\Models\\Receipt',4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',3420.00,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4907,7985,40767,31707,2,4791,'App\\Models\\Receipt',4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',11490.00,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL),(4908,7985,40767,31707,2,4792,'App\\Models\\Receipt',4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',6025.05,NULL,NULL,1,'2023-08-21 18:43:00','2023-08-21 18:43:00',NULL);
INSERT INTO `balance_libro` VALUES (4909,7985,40767,31707,2,4793,'App\\Models\\Receipt',4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',7810.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4910,7985,40767,31707,2,4794,'App\\Models\\Receipt',4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',4200.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4911,7985,40767,31707,2,4795,'App\\Models\\Receipt',4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',1940.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4912,7985,40767,31707,2,4796,'App\\Models\\Receipt',4796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',3650.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4913,7985,40767,31707,2,4797,'App\\Models\\Receipt',4797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',12800.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4914,7985,40767,31707,2,4798,'App\\Models\\Receipt',4798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',1890.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4915,7985,40767,31707,2,4799,'App\\Models\\Receipt',4799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',3100.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4916,7985,40767,31707,2,4800,'App\\Models\\Receipt',4800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',5480.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4917,7985,40767,31707,2,4801,'App\\Models\\Receipt',4801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',7260.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4918,7985,40767,31707,2,4802,'App\\Models\\Receipt',4802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',27305.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4919,7985,40767,31707,2,4803,'App\\Models\\Receipt',4803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',3690.00,NULL,NULL,1,'2023-08-21 18:43:01','2023-08-21 18:43:01',NULL),(4920,7985,40767,31707,2,4804,'App\\Models\\Receipt',4804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',1700.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4921,7985,40767,31707,2,4805,'App\\Models\\Receipt',4805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',270.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4922,7985,40767,31707,2,4806,'App\\Models\\Receipt',4806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',1125.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4923,7985,40767,31707,2,4807,'App\\Models\\Receipt',4807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',1760.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4924,7985,40767,31707,2,4808,'App\\Models\\Receipt',4808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',1720.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4925,7985,40767,31707,2,4809,'App\\Models\\Receipt',4809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',1390.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4926,7985,40767,31707,2,4810,'App\\Models\\Receipt',4810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',6200.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4927,7985,40767,31707,2,4811,'App\\Models\\Receipt',4811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',6430.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4928,7985,40767,31707,2,4812,'App\\Models\\Receipt',4812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',6270.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4929,7985,40767,31707,2,4813,'App\\Models\\Receipt',4813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',2085.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL);
INSERT INTO `balance_libro` VALUES (4930,7985,40767,31707,2,4814,'App\\Models\\Receipt',4814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',2290.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4931,7985,40767,31707,2,4815,'App\\Models\\Receipt',4815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',200.00,NULL,NULL,1,'2023-08-21 18:43:02','2023-08-21 18:43:02',NULL),(4932,7985,40767,31707,2,4816,'App\\Models\\Receipt',4816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',10950.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4933,7985,40767,31707,2,4817,'App\\Models\\Receipt',4817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',5600.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4934,7985,40767,31707,2,4818,'App\\Models\\Receipt',4818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',340.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4935,7985,40767,31707,2,4819,'App\\Models\\Receipt',4819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',655.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4936,7985,40767,31707,2,4820,'App\\Models\\Receipt',4820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',435.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4937,7985,40767,31707,2,4821,'App\\Models\\Receipt',4821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',2800.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4938,7985,40767,31707,2,4822,'App\\Models\\Receipt',4822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',2190.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4939,7985,40767,31707,2,4823,'App\\Models\\Receipt',4823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',1860.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4940,7985,40767,31707,2,4824,'App\\Models\\Receipt',4824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',1995.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4941,7985,40767,31707,2,4825,'App\\Models\\Receipt',4825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',6550.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4942,7985,40767,31707,2,4826,'App\\Models\\Receipt',4826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',1970.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4943,7985,40767,31707,2,4827,'App\\Models\\Receipt',4827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',2000.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4944,7985,40767,31707,2,4828,'App\\Models\\Receipt',4828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',3350.00,NULL,NULL,1,'2023-08-21 18:43:03','2023-08-21 18:43:03',NULL),(4945,7985,40767,31707,2,4829,'App\\Models\\Receipt',4829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',2100.70,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4946,7985,40767,31707,2,4830,'App\\Models\\Receipt',4830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',5200.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4947,7985,40767,31707,2,4831,'App\\Models\\Receipt',4831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',3300.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4948,7985,40767,31707,2,4832,'App\\Models\\Receipt',4832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',1900.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4949,7985,40767,31707,2,4833,'App\\Models\\Receipt',4833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',10265.04,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4950,7985,40767,31707,2,4834,'App\\Models\\Receipt',4834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',990.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL);
INSERT INTO `balance_libro` VALUES (4951,7985,40767,31707,2,4835,'App\\Models\\Receipt',4835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',500.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4952,7985,40767,31707,2,4836,'App\\Models\\Receipt',4836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',2154.65,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4953,7985,40767,31707,2,4837,'App\\Models\\Receipt',4837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',3940.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4954,7985,40767,31707,2,4838,'App\\Models\\Receipt',4838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',1995.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4955,7985,40767,31707,2,4839,'App\\Models\\Receipt',4839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',3980.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4956,7985,40767,31707,2,4840,'App\\Models\\Receipt',4840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',2750.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4957,7985,40767,31707,2,4841,'App\\Models\\Receipt',4841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',18250.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4958,7985,40767,31707,2,4842,'App\\Models\\Receipt',4842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',6310.00,NULL,NULL,1,'2023-08-21 18:43:04','2023-08-21 18:43:04',NULL),(4959,7985,40767,31707,2,4843,'App\\Models\\Receipt',4843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',1320.00,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4960,7985,40767,31707,2,4844,'App\\Models\\Receipt',4844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',2140.00,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4961,7985,40767,31707,2,4845,'App\\Models\\Receipt',4845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',3300.00,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4962,7985,40767,31707,2,4846,'App\\Models\\Receipt',4846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',6817.00,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4963,7985,40767,31707,2,4847,'App\\Models\\Receipt',4847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',22892.30,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4964,7985,40767,31707,2,4848,'App\\Models\\Receipt',4848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',14176.76,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4965,7985,40767,31707,2,4849,'App\\Models\\Receipt',4849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',36716.20,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4966,7985,40767,31707,2,4850,'App\\Models\\Receipt',4850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',1618.33,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4967,7985,40767,31707,2,4851,'App\\Models\\Receipt',4851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',6560.00,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4968,7985,40767,31707,2,4852,'App\\Models\\Receipt',4852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',52500.00,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4969,7985,40767,31707,2,4853,'App\\Models\\Receipt',4853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',7590.00,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4970,7985,40767,31707,2,4854,'App\\Models\\Receipt',4854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',7000.00,NULL,NULL,1,'2023-08-21 18:43:05','2023-08-21 18:43:05',NULL),(4971,7985,40767,31707,2,4855,'App\\Models\\Receipt',4855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',1400.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL);
INSERT INTO `balance_libro` VALUES (4972,7985,40767,31707,2,4856,'App\\Models\\Receipt',4856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',4780.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4973,7985,40767,31707,2,4857,'App\\Models\\Receipt',4857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',2950.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4974,7985,40767,31707,2,4858,'App\\Models\\Receipt',4858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',9040.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4975,7985,40767,31707,2,4859,'App\\Models\\Receipt',4859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',2760.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4976,7985,40767,31707,2,4860,'App\\Models\\Receipt',4860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',460.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4977,7985,40767,31707,2,4861,'App\\Models\\Receipt',4861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',13500.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4978,7985,40767,31707,2,4862,'App\\Models\\Receipt',4862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',1380.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4979,7985,40767,31707,2,4863,'App\\Models\\Receipt',4863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',9700.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4980,7985,40767,31707,2,4864,'App\\Models\\Receipt',4864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',1625.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4981,7985,40767,31707,2,4865,'App\\Models\\Receipt',4865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',400.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4982,7985,40767,31707,2,4866,'App\\Models\\Receipt',4866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',5760.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4983,7985,40767,31707,2,4867,'App\\Models\\Receipt',4867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',580.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4984,7985,40767,31707,2,4868,'App\\Models\\Receipt',4868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',1902.80,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4985,7985,40767,31707,2,4869,'App\\Models\\Receipt',4869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',642.00,NULL,NULL,1,'2023-08-21 18:43:06','2023-08-21 18:43:06',NULL),(4986,7985,40767,31707,2,4870,'App\\Models\\Receipt',4870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',4388.80,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4987,7985,40767,31707,2,4871,'App\\Models\\Receipt',4871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',1080.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4988,7985,40767,31707,2,4872,'App\\Models\\Receipt',4872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',370.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4989,7985,40767,31707,2,4873,'App\\Models\\Receipt',4873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',1080.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4990,7985,40767,31707,2,4874,'App\\Models\\Receipt',4874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',400.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4991,7985,40767,31707,2,4875,'App\\Models\\Receipt',4875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',1150.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4992,7985,40767,31707,2,4876,'App\\Models\\Receipt',4876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',1140.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL);
INSERT INTO `balance_libro` VALUES (4993,7985,40767,31707,2,4877,'App\\Models\\Receipt',4877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',7140.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4994,7985,40767,31707,2,4878,'App\\Models\\Receipt',4878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',3010.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4995,7985,40767,31707,2,4879,'App\\Models\\Receipt',4879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',7070.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4996,7985,40767,31707,2,4880,'App\\Models\\Receipt',4880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',4360.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4997,7985,40767,31707,2,4881,'App\\Models\\Receipt',4881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',2130.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4998,7985,40767,31707,2,4882,'App\\Models\\Receipt',4882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',1610.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(4999,7985,40767,31707,2,4883,'App\\Models\\Receipt',4883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',2590.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(5000,7985,40767,31707,2,4884,'App\\Models\\Receipt',4884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',1330.00,NULL,NULL,1,'2023-08-21 18:43:07','2023-08-21 18:43:07',NULL),(5001,7985,40767,31707,2,4885,'App\\Models\\Receipt',4885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',2350.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5002,7985,40767,31707,2,4886,'App\\Models\\Receipt',4886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',5100.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5003,7985,40767,31707,2,4887,'App\\Models\\Receipt',4887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',3940.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5004,7985,40767,31707,2,4888,'App\\Models\\Receipt',4888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',4200.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5005,7985,40767,31707,2,4889,'App\\Models\\Receipt',4889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',12920.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5006,7985,40767,31707,2,4890,'App\\Models\\Receipt',4890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',420.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5007,7985,40767,31707,2,4891,'App\\Models\\Receipt',4891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',2750.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5008,7985,40767,31707,2,4892,'App\\Models\\Receipt',4892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',7190.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5009,7985,40767,31707,2,4893,'App\\Models\\Receipt',4893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',850.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5010,7985,40767,31707,2,4894,'App\\Models\\Receipt',4894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',1790.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5011,7985,40767,31707,2,4895,'App\\Models\\Receipt',4895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',3695.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5012,7985,40767,31707,2,4896,'App\\Models\\Receipt',4896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',2720.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL),(5013,7985,40767,31707,2,4897,'App\\Models\\Receipt',4897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',500.00,NULL,NULL,1,'2023-08-21 18:43:08','2023-08-21 18:43:08',NULL);
INSERT INTO `balance_libro` VALUES (5014,7985,40767,31707,2,4898,'App\\Models\\Receipt',4898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',120.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5015,7985,40767,31707,2,4899,'App\\Models\\Receipt',4899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',1080.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5016,7985,40767,31707,2,4900,'App\\Models\\Receipt',4900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',540.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5017,7985,40767,31707,2,4901,'App\\Models\\Receipt',4901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',2050.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5018,7985,40767,31707,2,4902,'App\\Models\\Receipt',4902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',1480.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5019,7985,40767,31707,2,4903,'App\\Models\\Receipt',4903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',640.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5020,7985,40767,31707,2,4904,'App\\Models\\Receipt',4904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',3880.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5021,7985,40767,31707,2,4905,'App\\Models\\Receipt',4905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',6600.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5022,7985,40767,31707,2,4906,'App\\Models\\Receipt',4906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',2570.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5023,7985,40767,31707,2,4907,'App\\Models\\Receipt',4907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',6850.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5024,7985,40767,31707,2,4908,'App\\Models\\Receipt',4908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',4754.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5025,7985,40767,31707,2,4909,'App\\Models\\Receipt',4909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',3030.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5026,7985,40767,31707,2,4910,'App\\Models\\Receipt',4910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',3670.00,NULL,NULL,1,'2023-08-21 18:43:09','2023-08-21 18:43:09',NULL),(5027,7985,40767,31707,2,4911,'App\\Models\\Receipt',4911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',1360.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5028,7985,40767,31707,2,4912,'App\\Models\\Receipt',4912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',3950.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5029,7985,40767,31707,2,4913,'App\\Models\\Receipt',4913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',4790.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5030,7985,40767,31707,2,4914,'App\\Models\\Receipt',4914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',200.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5031,7985,40767,31707,2,4915,'App\\Models\\Receipt',4915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',1970.01,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5032,7985,40767,31707,2,4916,'App\\Models\\Receipt',4916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',12920.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5033,7985,40767,31707,2,4917,'App\\Models\\Receipt',4917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',2040.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5034,7985,40767,31707,2,4918,'App\\Models\\Receipt',4918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',1750.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL);
INSERT INTO `balance_libro` VALUES (5035,7985,40767,31707,2,4919,'App\\Models\\Receipt',4919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',1670.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5036,7985,40767,31707,2,4920,'App\\Models\\Receipt',4920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',3760.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5037,7985,40767,31707,2,4921,'App\\Models\\Receipt',4921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',3490.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5038,7985,40767,31707,2,4922,'App\\Models\\Receipt',4922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',1320.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5039,7985,40767,31707,2,4923,'App\\Models\\Receipt',4923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',3950.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5040,7985,40767,31707,2,4924,'App\\Models\\Receipt',4924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',660.00,NULL,NULL,1,'2023-08-21 18:43:10','2023-08-21 18:43:10',NULL),(5041,7985,40767,31707,2,4925,'App\\Models\\Receipt',4925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',20686.45,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5042,7985,40767,31707,2,4926,'App\\Models\\Receipt',4926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',12324.25,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5043,7985,40767,31707,2,4927,'App\\Models\\Receipt',4927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',1650.00,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5044,7985,40767,31707,2,4928,'App\\Models\\Receipt',4928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',1350.00,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5045,7985,40767,31707,2,4929,'App\\Models\\Receipt',4929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',5780.00,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5046,7985,40767,31707,2,4930,'App\\Models\\Receipt',4930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',23848.83,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5047,7985,40767,31707,2,4931,'App\\Models\\Receipt',4931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',2199.19,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5048,7985,40767,31707,2,4932,'App\\Models\\Receipt',4932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',24656.63,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5049,7985,40767,31707,2,4933,'App\\Models\\Receipt',4933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',954.69,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5050,7985,40767,31707,2,4934,'App\\Models\\Receipt',4934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',11400.00,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5051,7985,40767,31707,2,4935,'App\\Models\\Receipt',4935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',480.00,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5052,7985,40767,31707,2,4936,'App\\Models\\Receipt',4936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',2630.00,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5053,7985,40767,31707,2,4937,'App\\Models\\Receipt',4937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',4420.00,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5054,7985,40767,31707,2,4938,'App\\Models\\Receipt',4938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',3970.00,NULL,NULL,1,'2023-08-21 18:43:11','2023-08-21 18:43:11',NULL),(5055,7985,40767,31707,2,4939,'App\\Models\\Receipt',4939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',4620.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL);
INSERT INTO `balance_libro` VALUES (5056,7985,40767,31707,2,4940,'App\\Models\\Receipt',4940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',4220.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5057,7985,40767,31707,2,4941,'App\\Models\\Receipt',4941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',1060.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5058,7985,40767,31707,2,4942,'App\\Models\\Receipt',4942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',2560.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5059,7985,40767,31707,2,4943,'App\\Models\\Receipt',4943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',360.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5060,7985,40767,31707,2,4944,'App\\Models\\Receipt',4944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',4600.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5061,7985,40767,31707,2,4945,'App\\Models\\Receipt',4945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',3480.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5062,7985,40767,31707,2,4946,'App\\Models\\Receipt',4946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',1300.05,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5063,7985,40767,31707,2,4947,'App\\Models\\Receipt',4947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',7740.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5064,7985,40767,31707,2,4948,'App\\Models\\Receipt',4948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',9280.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5065,7985,40767,31707,2,4949,'App\\Models\\Receipt',4949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',2550.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5066,7985,40767,31707,2,4950,'App\\Models\\Receipt',4950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',120008.40,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5067,7985,40767,31707,2,4951,'App\\Models\\Receipt',4951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',895.40,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5068,7985,40767,31707,2,4952,'App\\Models\\Receipt',4952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',1235.00,NULL,NULL,1,'2023-08-21 18:43:12','2023-08-21 18:43:12',NULL),(5069,7985,40767,31707,2,4953,'App\\Models\\Receipt',4953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',750.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5070,7985,40767,31707,2,4954,'App\\Models\\Receipt',4954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',12540.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5071,7985,40767,31707,2,4955,'App\\Models\\Receipt',4955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',22070.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5072,7985,40767,31707,2,4956,'App\\Models\\Receipt',4956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',37100.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5073,7985,40767,31707,2,4957,'App\\Models\\Receipt',4957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',7440.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5074,7985,40767,31707,2,4958,'App\\Models\\Receipt',4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',6750.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5075,7985,40767,31707,2,4959,'App\\Models\\Receipt',4959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',3290.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5076,7985,40767,31707,2,4960,'App\\Models\\Receipt',4960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',1995.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL);
INSERT INTO `balance_libro` VALUES (5077,7985,40767,31707,2,4961,'App\\Models\\Receipt',4961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',1750.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5078,7985,40767,31707,2,4962,'App\\Models\\Receipt',4962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',4860.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5079,7985,40767,31707,2,4963,'App\\Models\\Receipt',4963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',1205.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5080,7985,40767,31707,2,4964,'App\\Models\\Receipt',4964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',14230.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5081,7985,40767,31707,2,4965,'App\\Models\\Receipt',4965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',1740.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5082,7985,40767,31707,2,4966,'App\\Models\\Receipt',4966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',4380.00,NULL,NULL,1,'2023-08-21 18:43:13','2023-08-21 18:43:13',NULL),(5083,7985,40767,31707,2,4967,'App\\Models\\Receipt',4967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',7868.75,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5084,7985,40767,31707,2,4968,'App\\Models\\Receipt',4968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',2794.00,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5085,7985,40767,31707,2,4969,'App\\Models\\Receipt',4969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',3360.00,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5086,7985,40767,31707,2,4970,'App\\Models\\Receipt',4970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',4250.00,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5087,7985,40767,31707,2,4971,'App\\Models\\Receipt',4971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',3320.01,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5088,7985,40767,31707,2,4972,'App\\Models\\Receipt',4972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',3670.00,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5089,7985,40767,31707,2,4973,'App\\Models\\Receipt',4973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',3250.00,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5090,7985,40767,31707,2,4974,'App\\Models\\Receipt',4974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',7390.00,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5091,7985,40767,31707,2,4975,'App\\Models\\Receipt',4975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',3510.00,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5092,7985,40767,31707,2,4976,'App\\Models\\Receipt',4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',760.05,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5093,7985,40767,31707,2,4977,'App\\Models\\Receipt',4977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',16753.00,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5094,7985,40767,31707,2,4978,'App\\Models\\Receipt',4978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',29700.01,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5095,7985,40767,31707,2,4979,'App\\Models\\Receipt',4979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2993.20,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5096,7985,40767,31707,2,4980,'App\\Models\\Receipt',4980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',17000.02,NULL,NULL,1,'2023-08-21 18:43:14','2023-08-21 18:43:14',NULL),(5097,7985,40767,31707,2,4981,'App\\Models\\Receipt',4981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2200.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL);
INSERT INTO `balance_libro` VALUES (5098,7985,40767,31707,2,4982,'App\\Models\\Receipt',4982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2400.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5099,7985,40767,31707,2,4983,'App\\Models\\Receipt',4983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1070.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5100,7985,40767,31707,2,4984,'App\\Models\\Receipt',4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',9200.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5101,7985,40767,31707,2,4985,'App\\Models\\Receipt',4985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3390.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5102,7985,40767,31707,2,4986,'App\\Models\\Receipt',4986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',6280.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5103,7985,40767,31707,2,4987,'App\\Models\\Receipt',4987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',18520.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5104,7985,40767,31707,2,4988,'App\\Models\\Receipt',4988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3290.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5105,7985,40767,31707,2,4989,'App\\Models\\Receipt',4989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1465.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5106,7985,40767,31707,2,4990,'App\\Models\\Receipt',4990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',13520.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5107,7985,40767,31707,2,4991,'App\\Models\\Receipt',4991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1550.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5108,7985,40767,31707,2,4992,'App\\Models\\Receipt',4992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2470.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5109,7985,40767,31707,2,4993,'App\\Models\\Receipt',4993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4430.00,NULL,NULL,1,'2023-08-21 18:43:15','2023-08-21 18:43:15',NULL),(5110,7985,40767,31707,2,4994,'App\\Models\\Receipt',4994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1950.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5111,7985,40767,31707,2,4995,'App\\Models\\Receipt',4995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',11800.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5112,7985,40767,31707,2,4996,'App\\Models\\Receipt',4996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',950.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5113,7985,40767,31707,2,4997,'App\\Models\\Receipt',4997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2437.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5114,7985,40767,31707,2,4998,'App\\Models\\Receipt',4998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',6080.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5115,7985,40767,31707,2,4999,'App\\Models\\Receipt',4999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5200.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5116,7985,40767,31707,2,5000,'App\\Models\\Receipt',5000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',450.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5117,7985,40767,31707,2,5001,'App\\Models\\Receipt',5001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',6660.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5118,7985,40767,31707,2,5002,'App\\Models\\Receipt',5002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2520.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL);
INSERT INTO `balance_libro` VALUES (5119,7985,40767,31707,2,5003,'App\\Models\\Receipt',5003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4740.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5120,7985,40767,31707,2,5004,'App\\Models\\Receipt',5004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3271.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5121,7985,40767,31707,2,5005,'App\\Models\\Receipt',5005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4520.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5122,7985,40767,31707,2,5006,'App\\Models\\Receipt',5006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2690.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5123,7985,40767,31707,2,5007,'App\\Models\\Receipt',5007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1550.00,NULL,NULL,1,'2023-08-21 18:43:16','2023-08-21 18:43:16',NULL),(5124,7985,40767,31707,2,5008,'App\\Models\\Receipt',5008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3550.00,NULL,NULL,1,'2023-08-21 18:43:17','2023-08-21 18:43:17',NULL),(5125,7985,40767,31707,7,5009,'App\\Models\\Receipt',5009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',481.19,NULL,NULL,1,'2023-08-21 19:19:26','2023-08-21 19:33:20','2023-08-21 19:33:20'),(5129,7985,40767,31707,7,5013,'App\\Models\\Receipt',5013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',481.19,NULL,NULL,1,'2023-08-21 19:25:58','2023-08-21 19:30:12','2023-08-21 19:30:12'),(5131,7985,40767,31707,7,5009,'App\\Models\\Receipt',5009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',892.37,NULL,NULL,1,'2023-08-21 19:33:20','2023-08-21 19:33:20',NULL),(5132,7985,40767,31707,15,614,'App\\Models\\PeriodLiquidation',NULL,614,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',395688.17,NULL,NULL,1,'2023-08-21 19:37:46','2023-08-21 19:37:46',NULL),(5133,7985,40767,31707,16,615,'App\\Models\\PeriodLiquidation',NULL,615,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',53540.45,NULL,NULL,1,'2023-08-21 19:38:30','2023-08-21 19:38:30',NULL),(5134,7985,40763,28704,16,601,'App\\Models\\PeriodLiquidation',NULL,601,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',10.29,NULL,NULL,1,'2023-08-22 10:31:06','2023-08-22 10:31:06',NULL),(5135,7985,40721,3054,16,593,'App\\Models\\PeriodLiquidation',NULL,593,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',506.30,NULL,NULL,1,'2023-09-01 18:06:07','2023-09-01 18:06:07',NULL),(5136,7985,40721,3054,15,592,'App\\Models\\PeriodLiquidation',NULL,592,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',333184.06,NULL,NULL,1,'2023-09-01 18:06:15','2023-09-01 18:06:15',NULL),(5137,7985,40721,3055,2,5015,'App\\Models\\Receipt',5015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',50000.03,NULL,NULL,1,'2023-09-01 18:09:51','2023-09-01 18:09:51',NULL),(5138,7985,40721,3055,2,5016,'App\\Models\\Receipt',5016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',710000.00,NULL,NULL,1,'2023-09-01 18:0