-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-23906983-6
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-04-02 13:48:55','Actividad Generica 1','000001',NULL),(2,NULL,'2021-04-02 13:48:55','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=956 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,3687,40720,1533,3,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6900.00,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:07:04','2021-05-15 18:07:04'),(2,3687,40720,1533,3,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',21175.00,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(3,3687,40720,1533,3,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',4272.53,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:08:21','2021-05-15 18:08:21'),(4,3687,40720,1533,3,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',11339.00,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(5,3687,40720,1533,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',56276.00,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:09:16','2021-05-15 18:09:16'),(6,3687,40720,1533,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6900.00,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:09:44','2021-05-15 18:09:44'),(7,3687,40720,1533,3,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',58337.45,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(8,3687,40720,1533,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',58442.93,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(9,3687,40720,1533,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1380.09,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(10,3687,40720,1533,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',38938.38,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(11,3687,40720,1533,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',58337.45,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(12,3687,40720,1533,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',30219.15,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(13,3687,40720,1533,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',845.00,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(14,3687,40720,1533,3,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',716.26,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(15,3687,40720,1533,3,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',9121.23,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:10:53','2021-05-15 18:10:53'),(16,3687,40720,1533,3,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',2005.99,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(17,3687,40720,1533,3,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1828.00,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(18,3687,40720,1533,3,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',42671.09,NULL,NULL,1,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(19,3687,40720,1533,3,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1644.00,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(20,3687,40720,1533,3,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',81019.88,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(21,3687,40720,1533,3,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',89299.06,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(22,3687,40720,1533,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',96971.80,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(23,3687,40720,1533,3,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',96971.80,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(24,3687,40720,1533,3,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',15951.92,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(25,3687,40720,1533,3,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',15951.92,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL);
INSERT INTO `balance_libro` VALUES (26,3687,40720,1533,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',89299.06,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(27,3687,40720,1533,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',96971.80,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(28,3687,40720,1533,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',4584.45,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(29,3687,40720,1533,3,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6900.00,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(30,3687,40720,1533,3,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',10291.12,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(31,3687,40720,1533,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',35080.69,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-16 14:29:49','2021-05-16 14:29:49'),(32,3687,40720,1533,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',17785.33,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(33,3687,40720,1533,3,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',33013.00,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(34,3687,40720,1533,3,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',116268.90,NULL,NULL,1,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(35,3687,40720,1533,3,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6900.00,NULL,NULL,1,'2021-05-15 18:07:04','2021-05-15 18:07:04',NULL),(36,3687,40720,1533,3,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',4173.93,NULL,NULL,1,'2021-05-15 18:08:21','2021-05-15 18:22:25','2021-05-15 18:22:25'),(37,3687,40720,1533,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',56276.00,NULL,NULL,1,'2021-05-15 18:09:16','2021-05-15 19:14:47','2021-05-15 19:14:47'),(38,3687,40720,1533,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6900.00,NULL,NULL,1,'2021-05-15 18:09:44','2021-05-15 18:09:44',NULL),(39,3687,40720,1533,3,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',9299.18,NULL,NULL,1,'2021-05-15 18:10:53','2021-05-15 18:57:27','2021-05-15 18:57:27'),(40,3687,40720,1533,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3439.99,NULL,NULL,1,'2021-05-15 18:18:25','2021-05-15 19:06:59','2021-05-15 19:06:59'),(41,3687,40720,1533,3,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',4272.53,NULL,NULL,1,'2021-05-15 18:22:25','2021-05-15 18:22:25',NULL),(42,3687,40720,1533,3,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3099.97,NULL,NULL,1,'2021-05-15 18:29:58','2021-05-15 18:29:58',NULL),(43,3687,40720,1533,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2007.45,NULL,NULL,1,'2021-05-15 18:32:08','2021-05-15 18:32:08',NULL),(44,3687,40720,1533,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2000.00,NULL,NULL,1,'2021-05-15 18:35:46','2021-05-15 18:35:46',NULL),(45,3687,40720,1533,3,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1000.00,NULL,NULL,1,'2021-05-15 18:38:19','2021-05-15 18:38:19',NULL),(46,3687,40720,1533,3,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1500.00,NULL,NULL,1,'2021-05-15 18:40:37','2021-05-15 18:40:37',NULL),(47,3687,40720,1533,3,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10991.03,NULL,NULL,1,'2021-05-15 18:45:55','2021-05-15 18:45:55',NULL),(48,3687,40720,1533,3,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',6237.61,NULL,NULL,1,'2021-05-15 18:48:14','2021-05-15 18:48:14',NULL),(49,3687,40720,1533,3,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',574.93,NULL,NULL,1,'2021-05-15 18:49:21','2021-05-15 18:49:21',NULL);
INSERT INTO `balance_libro` VALUES (50,3687,40720,1533,3,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',27909.94,NULL,NULL,1,'2021-05-15 18:52:23','2021-05-15 18:52:23',NULL),(51,3687,40720,1533,3,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',1755.23,NULL,NULL,1,'2021-05-15 18:57:27','2021-05-15 18:57:59','2021-05-15 18:57:59'),(52,3687,40720,1533,3,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',9121.23,NULL,NULL,1,'2021-05-15 18:57:59','2021-05-15 18:57:59',NULL),(53,3687,40720,1533,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3439.99,NULL,NULL,1,'2021-05-15 19:06:59','2021-05-15 19:08:45','2021-05-15 19:08:45'),(54,3687,40720,1533,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3439.99,NULL,NULL,1,'2021-05-15 19:08:45','2021-05-15 22:52:50','2021-05-15 22:52:50'),(55,3687,40720,1533,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',56276.00,NULL,NULL,1,'2021-05-15 19:14:47','2021-05-15 19:14:47',NULL),(56,3687,40720,1533,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3439.99,NULL,NULL,1,'2021-05-15 22:52:50','2021-05-15 22:52:50',NULL),(57,3687,40720,1533,3,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',900.01,NULL,NULL,1,'2021-05-15 23:55:53','2021-05-15 23:55:53',NULL),(58,3687,40720,1533,3,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',1131.21,NULL,NULL,1,'2021-05-15 23:57:43','2021-05-15 23:57:43',NULL),(59,3687,40720,1533,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',694200.00,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(60,3687,40720,1533,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',13095.23,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(61,3687,40720,1533,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',41940.10,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(62,3687,40720,1533,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',60356.01,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(63,3687,40720,1533,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',41050.00,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(64,3687,40720,1533,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',29840.00,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(65,3687,40720,1533,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',29500.01,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(66,3687,40720,1533,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',45917.16,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(67,3687,40720,1533,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',55400.58,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(68,3687,40720,1533,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',115615.50,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(69,3687,40720,1533,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',44168.68,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(70,3687,40720,1533,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1373.56,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(71,3687,40720,1533,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',93481.36,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(72,3687,40720,1533,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',16041.27,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(73,3687,40720,1533,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',48451.79,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(74,3687,40720,1533,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',11868.38,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL);
INSERT INTO `balance_libro` VALUES (75,3687,40720,1533,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',56178.46,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(76,3687,40720,1533,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',135927.77,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(77,3687,40720,1533,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',9510.60,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(78,3687,40720,1533,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',30517.75,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(79,3687,40720,1533,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',22516.35,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(80,3687,40720,1533,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',34552.91,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(81,3687,40720,1533,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',31000.01,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(82,3687,40720,1533,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',6600.01,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(83,3687,40720,1533,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',445000.01,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(84,3687,40720,1533,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',406600.03,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(85,3687,40720,1533,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',16248.86,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(86,3687,40720,1533,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',20277.18,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(87,3687,40720,1533,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',85024.76,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(88,3687,40720,1533,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',18337.03,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(89,3687,40720,1533,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',51759.95,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(90,3687,40720,1533,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',42454.42,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(91,3687,40720,1533,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',40643.55,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(92,3687,40720,1533,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',60124.83,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(93,3687,40720,1533,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',41947.69,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(94,3687,40720,1533,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',125064.39,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(95,3687,40720,1533,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',34600.00,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(96,3687,40720,1533,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',28550.00,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(97,3687,40720,1533,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',62515.30,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(98,3687,40720,1533,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',67256.58,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(99,3687,40720,1533,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',40440.26,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL);
INSERT INTO `balance_libro` VALUES (100,3687,40720,1533,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',25120.04,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(101,3687,40720,1533,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',101594.02,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(102,3687,40720,1533,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',52722.91,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(103,3687,40720,1533,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',17475.73,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(104,3687,40720,1533,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',247700.01,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(105,3687,40720,1533,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',16600.00,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(106,3687,40720,1533,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',62400.00,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(107,3687,40720,1533,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',140043.59,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(108,3687,40720,1533,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1128.00,NULL,NULL,1,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(109,3687,40720,1530,3,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',148095.76,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(110,3687,40720,1530,3,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',35094.57,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(111,3687,40720,1530,3,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',3727.07,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(112,3687,40720,1530,3,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',1406.00,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(113,3687,40720,1530,3,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',384232.45,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(114,3687,40720,1530,3,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',1102.00,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(115,3687,40720,1530,3,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',5349.93,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(116,3687,40720,1530,3,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',8020.52,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(117,3687,40720,1530,3,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',2000.00,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(118,3687,40720,1530,3,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',2347.39,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(119,3687,40720,1530,3,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',30525.00,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(120,3687,40720,1530,3,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',28395.63,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(121,3687,40720,1530,3,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1154.00,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(122,3687,40720,1530,3,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',238617.69,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(123,3687,40720,1530,3,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',1049.75,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(124,3687,40720,1530,3,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',27121.42,NULL,NULL,1,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL);
INSERT INTO `balance_libro` VALUES (125,3687,40720,1531,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1630.00,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(126,3687,40720,1531,3,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',80000.00,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(127,3687,40720,1531,3,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',6900.00,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(128,3687,40720,1531,3,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',407521.66,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(129,3687,40720,1531,3,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',604961.28,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(130,3687,40720,1531,3,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',18150.00,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(131,3687,40720,1531,3,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',831501.00,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(132,3687,40720,1531,3,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',18451.20,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(133,3687,40720,1531,3,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',18150.00,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(134,3687,40720,1531,3,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',18150.00,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(135,3687,40720,1531,3,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',170210.02,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(136,3687,40720,1531,3,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',394877.00,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(137,3687,40720,1531,3,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',1147624.89,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(138,3687,40720,1531,3,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',463045.64,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(139,3687,40720,1531,3,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',99726.09,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(140,3687,40720,1531,3,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',672293.35,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(141,3687,40720,1531,3,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',59176.26,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(142,3687,40720,1531,3,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',13796.84,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(143,3687,40720,1531,3,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1103.60,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(144,3687,40720,1531,3,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',676012.46,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(145,3687,40720,1531,3,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',5307.49,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(146,3687,40720,1531,3,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',92595.25,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(147,3687,40720,1531,3,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',247272.87,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(148,3687,40720,1531,3,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',30525.00,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL);
INSERT INTO `balance_libro` VALUES (149,3687,40720,1531,3,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',36042.93,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(150,3687,40720,1531,3,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3883.62,NULL,NULL,1,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(186,3687,40720,1530,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',96520.79,NULL,NULL,1,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(187,3687,40720,1530,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',38201.15,NULL,NULL,1,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(188,3687,40720,1530,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',43299.99,NULL,NULL,1,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(189,3687,40720,1530,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',230332.21,NULL,NULL,1,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(190,3687,40720,1530,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',12248.16,NULL,NULL,1,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(191,3687,40720,1530,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',121732.05,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(192,3687,40720,1530,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',3503.92,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(193,3687,40720,1530,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',105624.45,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(194,3687,40720,1530,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',309019.95,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(195,3687,40720,1530,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',112376.38,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(196,3687,40720,1530,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',80380.00,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(197,3687,40720,1530,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',22076.23,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(198,3687,40720,1530,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',11785.40,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(199,3687,40720,1530,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',357649.45,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(200,3687,40720,1530,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',6514.25,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(201,3687,40720,1530,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',16831.10,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(202,3687,40720,1530,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',1751.96,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(203,3687,40720,1530,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',56758.08,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(204,3687,40720,1530,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',6975.05,NULL,NULL,1,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(205,3687,40720,1531,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',70340.47,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(206,3687,40720,1531,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',234863.14,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(207,3687,40720,1531,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',144677.04,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(208,3687,40720,1531,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',114178.02,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL);
INSERT INTO `balance_libro` VALUES (209,3687,40720,1531,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',13247.08,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(210,3687,40720,1531,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',130780.31,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(211,3687,40720,1531,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1390.31,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(212,3687,40720,1531,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',11400.02,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(213,3687,40720,1531,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',20460.65,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(214,3687,40720,1531,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',111778.59,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(215,3687,40720,1531,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',28340.00,NULL,NULL,1,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(216,3687,40720,1531,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',9037.89,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(217,3687,40720,1531,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',322344.00,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(218,3687,40720,1531,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',322344.00,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(219,3687,40720,1531,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',322344.00,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(220,3687,40720,1531,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',20460.65,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(221,3687,40720,1531,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3159.43,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(222,3687,40720,1531,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',358158.54,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(223,3687,40720,1531,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',165842.31,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(224,3687,40720,1531,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',143850.70,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(225,3687,40720,1531,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3113.09,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(226,3687,40720,1531,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',64000.00,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(227,3687,40720,1531,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',14211.45,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(228,3687,40720,1531,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',93350.00,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(229,3687,40720,1531,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',62350.01,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(230,3687,40720,1531,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',221350.01,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(231,3687,40720,1531,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',20588.91,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(232,3687,40720,1531,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',49713.99,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(233,3687,40720,1531,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',66871.42,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL);
INSERT INTO `balance_libro` VALUES (234,3687,40720,1531,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',23522.40,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(235,3687,40720,1531,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',46756.38,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(236,3687,40720,1531,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',26299.35,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(237,3687,40720,1531,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',54722.26,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(238,3687,40720,1531,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',20820.32,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(239,3687,40720,1531,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',50966.77,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(240,3687,40720,1531,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',181815.12,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(241,3687,40720,1531,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',17889.25,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(242,3687,40720,1531,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',394877.00,NULL,NULL,1,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(243,3687,40720,1532,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',342890.01,NULL,NULL,1,'2021-05-16 12:19:28','2021-05-16 12:19:28',NULL),(244,3687,40720,1532,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',100887.38,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(245,3687,40720,1532,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6878.85,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(246,3687,40720,1532,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',65590.01,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(247,3687,40720,1532,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',84449.35,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(248,3687,40720,1532,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',30067.46,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(249,3687,40720,1532,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',22149.90,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(250,3687,40720,1532,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',180180.01,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(251,3687,40720,1532,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',192788.94,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(252,3687,40720,1532,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',125373.92,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(253,3687,40720,1532,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',58093.60,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(254,3687,40720,1532,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',142085.10,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(255,3687,40720,1532,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',312361.69,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(256,3687,40720,1532,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',60929.88,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(257,3687,40720,1532,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',150509.24,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL);
INSERT INTO `balance_libro` VALUES (258,3687,40720,1532,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',57782.34,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(259,3687,40720,1532,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',18950.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(260,3687,40720,1532,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',73694.25,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(261,3687,40720,1532,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',64400.74,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(262,3687,40720,1532,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',0.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(263,3687,40720,1532,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',30554.98,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(264,3687,40720,1532,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',14643.19,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(265,3687,40720,1532,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',117317.97,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(266,3687,40720,1532,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',31293.99,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(267,3687,40720,1532,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',45907.50,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(268,3687,40720,1532,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',117317.97,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(269,3687,40720,1532,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',24058.55,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(270,3687,40720,1532,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',77650.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(271,3687,40720,1532,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',33123.75,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(272,3687,40720,1532,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',33100.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(273,3687,40720,1532,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',22383.67,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(274,3687,40720,1532,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',80515.17,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(275,3687,40720,1532,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',71481.75,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(276,3687,40720,1532,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',73615.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(277,3687,40720,1532,2,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',23101.50,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(278,3687,40720,1532,2,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',186104.05,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(279,3687,40720,1532,2,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',62500.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(280,3687,40720,1532,2,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',40199.84,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(281,3687,40720,1532,2,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',133181.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(282,3687,40720,1532,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',28900.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL);
INSERT INTO `balance_libro` VALUES (283,3687,40720,1532,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',23000.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(284,3687,40720,1532,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',120500.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(285,3687,40720,1532,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',23350.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(286,3687,40720,1532,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',157400.01,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(287,3687,40720,1532,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',70980.37,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(288,3687,40720,1532,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',32266.73,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(289,3687,40720,1532,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',33316.83,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(290,3687,40720,1532,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',60266.35,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(291,3687,40720,1532,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',14553.83,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(292,3687,40720,1532,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',28600.18,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(293,3687,40720,1532,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',8836.25,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(294,3687,40720,1532,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',8160.88,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(295,3687,40720,1532,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',132900.48,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(296,3687,40720,1532,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',23400.00,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(297,3687,40720,1532,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1765.09,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(298,3687,40720,1532,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',29654.66,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(299,3687,40720,1532,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',89200.33,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(300,3687,40720,1532,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',29654.66,NULL,NULL,1,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(301,3687,40720,1533,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',35080.65,NULL,NULL,1,'2021-05-16 14:29:49','2021-05-16 14:29:49',NULL),(302,3687,40812,3042,3,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',3100.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(303,3687,40812,3042,3,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-03','2021-01-03',4356.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(304,3687,40812,3042,3,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',102.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(305,3687,40812,3042,3,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4526.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(306,3687,40812,3042,3,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',55000.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(307,3687,40812,3042,3,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',344933.65,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL);
INSERT INTO `balance_libro` VALUES (308,3687,40812,3042,3,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',12000.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(309,3687,40812,3042,3,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',12000.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(310,3687,40812,3042,3,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7350.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(311,3687,40812,3042,3,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2420.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(312,3687,40812,3042,3,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',8050.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(313,3687,40812,3042,3,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',56166.38,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(314,3687,40812,3042,3,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',17131.72,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(315,3687,40812,3042,3,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',2299.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(316,3687,40812,3042,3,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',5600.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(317,3687,40812,3042,3,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',39961.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(318,3687,40812,3042,3,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',979616.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(319,3687,40812,3042,3,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',4900.00,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(320,3687,40812,3042,3,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',16012.99,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(321,3687,40812,3042,3,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',213592.71,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(322,3687,40812,3042,3,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',252449.80,NULL,NULL,1,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(323,3687,40812,3042,3,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',100000.00,NULL,NULL,1,'2021-05-17 17:34:22','2021-05-17 17:34:22',NULL),(324,3687,40812,3042,3,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',10000.00,NULL,NULL,1,'2021-05-17 17:34:22','2021-05-17 17:34:22',NULL),(325,3687,40812,3043,3,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',3100.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(326,3687,40812,3043,3,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',5227.20,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(327,3687,40812,3043,3,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',12000.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(328,3687,40812,3043,3,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',12000.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(329,3687,40812,3043,3,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',4526.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(330,3687,40812,3043,3,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',6900.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(331,3687,40812,3043,3,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',106.80,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(332,3687,40812,3043,3,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',346267.97,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL);
INSERT INTO `balance_libro` VALUES (333,3687,40812,3043,3,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',55000.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(334,3687,40812,3043,3,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',369161.72,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(335,3687,40812,3043,3,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5600.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(336,3687,40812,3043,3,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2977.33,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(337,3687,40812,3043,3,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4174.50,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(338,3687,40812,3043,3,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',608100.63,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(339,3687,40812,3043,3,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9450.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(340,3687,40812,3043,3,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1685.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(341,3687,40812,3043,3,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',90.10,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(342,3687,40812,3043,3,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',17123.80,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(343,3687,40812,3043,3,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1573.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(344,3687,40812,3043,3,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',0.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(345,3687,40812,3043,3,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',4550.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(346,3687,40812,3043,3,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',4550.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(347,3687,40812,3043,3,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',369161.72,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(348,3687,40812,3043,3,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',346267.97,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(349,3687,40812,3043,3,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',23427.73,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(350,3687,40812,3043,3,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',6655.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(351,3687,40812,3043,3,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',39961.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(352,3687,40812,3043,3,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',100000.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(353,3687,40812,3043,3,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',5250.00,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(354,3687,40812,3043,3,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',156752.11,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(355,3687,40812,3043,3,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',281022.50,NULL,NULL,1,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(356,3687,40812,3044,3,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3100.00,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(357,3687,40812,3044,3,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',5227.20,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL);
INSERT INTO `balance_libro` VALUES (358,3687,40812,3044,3,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',12000.00,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(359,3687,40812,3044,3,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',12000.00,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(360,3687,40812,3044,3,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',90.10,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(361,3687,40812,3044,3,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',4836.00,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(362,3687,40812,3044,3,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',273487.50,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(363,3687,40812,3044,3,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',7200.00,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(364,3687,40812,3044,3,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',55000.00,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(365,3687,40812,3044,3,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(366,3687,40812,3044,3,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(367,3687,40812,3044,3,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(368,3687,40812,3044,3,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(369,3687,40812,3044,3,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(370,3687,40812,3044,3,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(371,3687,40812,3044,3,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(372,3687,40812,3044,3,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(373,3687,40812,3044,3,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(374,3687,40812,3044,3,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(375,3687,40812,3044,3,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',29.22,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(376,3687,40812,3044,3,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',7200.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(377,3687,40812,3044,3,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(378,3687,40812,3044,3,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(379,3687,40812,3044,3,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(380,3687,40812,3044,3,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(381,3687,40812,3044,3,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(382,3687,40812,3044,3,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL);
INSERT INTO `balance_libro` VALUES (383,3687,40812,3044,3,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(384,3687,40812,3044,3,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(385,3687,40812,3044,3,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(386,3687,40812,3044,3,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(387,3687,40812,3044,3,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',135.26,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(388,3687,40812,3044,3,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2783.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(389,3687,40812,3044,3,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',17800.73,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(390,3687,40812,3044,3,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',180.20,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(391,3687,40812,3044,3,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',8000.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(392,3687,40812,3044,3,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',6900.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(393,3687,40812,3044,3,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',15125.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(394,3687,40812,3044,3,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',41359.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(395,3687,40812,3044,3,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',10527.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(396,3687,40812,3044,3,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',8000.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(397,3687,40812,3044,3,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',2516.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(398,3687,40812,3044,3,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',182483.73,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(399,3687,40812,3044,3,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',100000.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(400,3687,40812,3044,3,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3639024.48,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(401,3687,40812,3044,3,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',25000.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(402,3687,40812,3044,3,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',136851.00,NULL,NULL,1,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(403,3687,40812,3045,3,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3100.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:23:43','2021-05-18 02:23:43'),(404,3687,40812,3045,3,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6900.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:45:58','2021-05-17 17:45:58'),(405,3687,40812,3045,3,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',5227.20,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:23:32','2021-05-18 02:23:32'),(406,3687,40812,3045,3,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6400.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:50:37','2021-05-17 17:50:37');
INSERT INTO `balance_libro` VALUES (407,3687,40812,3045,3,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',21175.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:23:24','2021-05-18 02:23:24'),(408,3687,40812,3045,3,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4836.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:52:08','2021-05-17 17:52:08'),(409,3687,40812,3045,3,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6900.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:54:20','2021-05-17 17:54:20'),(410,3687,40812,3045,3,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:55:29','2021-05-17 17:55:29'),(411,3687,40812,3045,3,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',55000.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:55:55','2021-05-17 17:55:55'),(412,3687,40812,3045,3,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:56:22','2021-05-17 17:56:22'),(413,3687,40812,3045,3,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',7200.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:56:55','2021-05-17 17:56:55'),(414,3687,40812,3045,3,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',20500.06,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:22:40','2021-05-18 02:22:40'),(415,3687,40812,3045,3,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4400.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:57:16','2021-05-17 17:57:16'),(416,3687,40812,3045,3,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',18488.23,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:22:30','2021-05-18 02:22:30'),(417,3687,40812,3045,3,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',6400.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:48:38','2021-05-17 17:48:38'),(418,3687,40812,3045,3,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',990.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:57:44','2021-05-17 17:57:44'),(419,3687,40812,3045,3,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1875.50,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:22:07','2021-05-18 02:22:07'),(420,3687,40812,3045,3,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3859.42,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:22:01','2021-05-18 02:22:01'),(421,3687,40812,3045,3,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7200.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 17:58:02','2021-05-17 17:58:02'),(422,3687,40812,3045,3,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',9227.65,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:21:50','2021-05-18 02:21:50'),(423,3687,40812,3045,3,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',68716.12,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:21:44','2021-05-18 02:21:44'),(424,3687,40812,3045,3,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',5600.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 18:00:32','2021-05-17 18:00:32'),(425,3687,40812,3045,3,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',132.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 13:14:26','2021-05-18 13:14:26'),(426,3687,40812,3045,3,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6900.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 18:00:51','2021-05-17 18:00:51'),(427,3687,40812,3045,3,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7200.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 18:01:08','2021-05-17 18:01:08'),(428,3687,40812,3045,3,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',43218.99,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:21:34','2021-05-18 02:21:34');
INSERT INTO `balance_libro` VALUES (429,3687,40812,3045,3,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1117.60,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:21:29','2021-05-18 02:21:29'),(430,3687,40812,3045,3,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5200.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 18:01:22','2021-05-17 18:01:22'),(431,3687,40812,3045,3,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1059256.69,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:21:16','2021-05-18 02:21:16'),(432,3687,40812,3045,3,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',298147.63,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:21:11','2021-05-18 02:21:11'),(433,3687,40812,3045,3,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',670415.63,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:21:03','2021-05-18 02:21:03'),(434,3687,40812,3045,3,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',120000.00,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-17 18:02:00','2021-05-17 18:02:00'),(435,3687,40812,3045,3,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',327234.34,NULL,NULL,1,'2021-05-17 17:36:21','2021-05-18 02:20:49','2021-05-18 02:20:49'),(436,3687,40812,3045,3,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',337505.78,NULL,NULL,1,'2021-05-17 17:36:22','2021-05-18 02:20:43','2021-05-18 02:20:43'),(437,3687,40812,3045,3,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7200.00,NULL,NULL,1,'2021-05-17 17:36:22','2021-05-17 18:02:15','2021-05-17 18:02:15'),(438,3687,40812,3042,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',14132.80,NULL,NULL,1,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(439,3687,40812,3042,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',79309.45,NULL,NULL,1,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(440,3687,40812,3042,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',14132.80,NULL,NULL,1,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(441,3687,40812,3042,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',43130.45,NULL,NULL,1,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(442,3687,40812,3042,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',53155.30,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(443,3687,40812,3042,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',34418.45,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(444,3687,40812,3042,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',202070.00,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(445,3687,40812,3042,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',312530.90,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(446,3687,40812,3042,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',6183.10,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(447,3687,40812,3042,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',124897.41,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(448,3687,40812,3042,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',38502.20,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(449,3687,40812,3042,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',7647.20,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(450,3687,40812,3042,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',13358.40,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(451,3687,40812,3042,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',33166.10,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(452,3687,40812,3042,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',8082.80,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL);
INSERT INTO `balance_libro` VALUES (453,3687,40812,3042,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',94519.15,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(454,3687,40812,3042,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',23788.60,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(455,3687,40812,3042,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',49543.45,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(456,3687,40812,3042,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',42973.15,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(457,3687,40812,3042,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',25276.90,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(458,3687,40812,3042,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',17545.00,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(459,3687,40812,3042,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',38986.20,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(460,3687,40812,3042,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',56083.50,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(461,3687,40812,3042,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',62169.80,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(462,3687,40812,3042,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',38530.03,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(463,3687,40812,3042,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',91705.90,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(464,3687,40812,3042,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',83617.05,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(465,3687,40812,3042,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',36039.85,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(466,3687,40812,3042,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',19710.90,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(467,3687,40812,3042,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',40716.50,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(468,3687,40812,3042,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',15548.50,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(469,3687,40812,3042,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',31850.83,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(470,3687,40812,3042,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',30855.00,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(471,3687,40812,3042,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',80138.30,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(472,3687,40812,3042,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',353380.50,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(473,3687,40812,3042,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',11622.05,NULL,NULL,1,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(474,3687,40812,3043,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',29723.65,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(475,3687,40812,3043,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',56265.00,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(476,3687,40812,3043,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',72013.15,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(477,3687,40812,3043,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',43910.90,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL);
INSERT INTO `balance_libro` VALUES (478,3687,40812,3043,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',9438.00,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(479,3687,40812,3043,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',236557.06,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(480,3687,40812,3043,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',72909.76,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(481,3687,40812,3043,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',39058.80,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(482,3687,40812,3043,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',30673.50,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(483,3687,40812,3043,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',26674.45,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(484,3687,40812,3043,2,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',79860.00,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(485,3687,40812,3043,2,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',25289.00,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(486,3687,40812,3043,2,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',53161.35,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(487,3687,40812,3043,2,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',20859.94,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(488,3687,40812,3043,2,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',9308.69,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(489,3687,40812,3043,2,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',21979.80,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(490,3687,40812,3043,2,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',40589.45,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(491,3687,40812,3043,2,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',11389.73,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(492,3687,40812,3043,2,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',16891.60,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(493,3687,40812,3043,2,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',13000.00,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(494,3687,40812,3043,2,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',483443.40,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(495,3687,40812,3043,2,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',38980.15,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(496,3687,40812,3043,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',71347.65,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(497,3687,40812,3043,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',34642.30,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(498,3687,40812,3043,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',181270.10,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(499,3687,40812,3043,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',637381.17,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(500,3687,40812,3043,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',21392.80,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(501,3687,40812,3043,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',76230.00,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(502,3687,40812,3043,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',129218.20,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL);
INSERT INTO `balance_libro` VALUES (503,3687,40812,3043,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',28798.00,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(504,3687,40812,3043,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',10036.95,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(505,3687,40812,3043,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',130353.30,NULL,NULL,1,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(506,3687,40812,3043,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',43547.90,NULL,NULL,1,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(507,3687,40812,3043,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',42658.55,NULL,NULL,1,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(508,3687,40812,3043,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',9413.80,NULL,NULL,1,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(509,3687,40812,3044,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',29524.00,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(510,3687,40812,3044,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',121157.30,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(511,3687,40812,3044,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',294661.57,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(512,3687,40812,3044,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',51718.24,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(513,3687,40812,3044,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',13404.38,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(514,3687,40812,3044,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',22723.80,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(515,3687,40812,3044,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',64783.40,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(516,3687,40812,3044,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',58564.00,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(517,3687,40812,3044,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',89273.80,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(518,3687,40812,3044,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',25289.00,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(519,3687,40812,3044,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',7223.70,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(520,3687,40812,3044,2,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',21755.80,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(521,3687,40812,3044,2,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',32924.10,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(522,3687,40812,3044,2,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',23595.00,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(523,3687,40812,3044,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',57596.00,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(524,3687,40812,3044,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',17085.20,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(525,3687,40812,3044,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',37449.50,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(526,3687,40812,3044,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',503338.91,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(527,3687,40812,3044,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',19535.45,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL);
INSERT INTO `balance_libro` VALUES (528,3687,40812,3044,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',19389.04,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(529,3687,40812,3044,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',288101.00,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(530,3687,40812,3044,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',6340.40,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(531,3687,40812,3044,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',36711.40,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(532,3687,40812,3044,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',201065.70,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(533,3687,40812,3044,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',36977.60,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(534,3687,40812,3044,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',18101.60,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(535,3687,40812,3044,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',10944.45,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(536,3687,40812,3044,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',61280.45,NULL,NULL,1,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(537,3687,40812,3044,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',65582.00,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(538,3687,40812,3044,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',53057.29,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(539,3687,40812,3044,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',25174.05,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(540,3687,40812,3044,2,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',49368.00,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(541,3687,40812,3044,2,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',10272.90,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(542,3687,40812,3044,2,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',25289.00,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(543,3687,40812,3044,2,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4646.40,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(544,3687,40812,3044,2,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',666982.25,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(545,3687,40812,3044,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',16516.50,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(546,3687,40812,3044,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',70853.92,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(547,3687,40812,3044,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',2879.80,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(548,3687,40812,3044,2,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',4186.60,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(549,3687,40812,3044,2,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',6074.20,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(550,3687,40812,3044,2,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',56410.20,NULL,NULL,1,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(551,3687,40812,3045,2,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',19226.90,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:16:29','2021-05-18 02:16:29');
INSERT INTO `balance_libro` VALUES (552,3687,40812,3045,2,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',78202.30,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:16:23','2021-05-18 02:16:23'),(553,3687,40812,3045,2,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',141328.00,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:16:19','2021-05-18 02:16:19'),(554,3687,40812,3045,2,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',48708.55,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:16:15','2021-05-18 02:16:15'),(555,3687,40812,3045,2,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',64009.00,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:16:11','2021-05-18 02:16:11'),(556,3687,40812,3045,2,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',7810.55,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:16:06','2021-05-18 02:16:06'),(557,3687,40812,3045,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',143983.95,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(558,3687,40812,3045,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',15028.20,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(559,3687,40812,3045,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',68268.20,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(560,3687,40812,3045,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',116768.63,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:58','2021-05-18 02:15:58'),(561,3687,40812,3045,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',33250.80,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:53','2021-05-18 02:15:53'),(562,3687,40812,3045,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',237281.00,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:49','2021-05-18 02:15:49'),(563,3687,40812,3045,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',102569.28,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:44','2021-05-18 02:15:44'),(564,3687,40812,3045,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7514.10,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:39','2021-05-18 02:15:39'),(565,3687,40812,3045,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',50820.00,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:35','2021-05-18 02:15:35'),(566,3687,40812,3045,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7623.00,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:30','2021-05-18 02:15:30'),(567,3687,40812,3045,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',56410.20,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(568,3687,40812,3045,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',63949.71,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(569,3687,40812,3045,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',29403.00,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(570,3687,40812,3045,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',47105.30,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(571,3687,40812,3045,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',49912.50,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:23','2021-05-18 02:15:23'),(572,3687,40812,3045,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',28967.40,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:19','2021-05-18 02:15:19'),(573,3687,40812,3045,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',63633.90,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:15','2021-05-18 02:15:15');
INSERT INTO `balance_libro` VALUES (574,3687,40812,3045,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2048.05,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:10','2021-05-18 02:15:10'),(575,3687,40812,3045,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',30534.35,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:05','2021-05-18 02:15:05'),(576,3687,40812,3045,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',21235.50,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:15:01','2021-05-18 02:15:01'),(577,3687,40812,3045,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',29838.60,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(578,3687,40812,3045,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',37274.05,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(579,3687,40812,3045,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',66562.10,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(580,3687,40812,3045,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',23637.35,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:55','2021-05-18 02:14:55'),(581,3687,40812,3045,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',80856.14,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:49','2021-05-18 02:14:49'),(582,3687,40812,3045,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',76697.54,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:44','2021-05-18 02:14:44'),(583,3687,40812,3045,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',668632.69,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:40','2021-05-18 02:14:40'),(584,3687,40812,3045,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',18367.80,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:36','2021-05-18 02:14:36'),(585,3687,40812,3045,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',37485.80,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:32','2021-05-18 02:14:32'),(586,3687,40812,3045,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',856268.60,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:27','2021-05-18 02:14:27'),(587,3687,40812,3045,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',7332.60,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(588,3687,40812,3045,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',30056.40,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(589,3687,40812,3045,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',12559.80,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(590,3687,40812,3045,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',26136.00,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(591,3687,40812,3045,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',67687.40,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(592,3687,40812,3045,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',68716.12,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:18','2021-05-18 02:14:18'),(593,3687,40812,3045,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',41539.30,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:11','2021-05-18 02:14:11'),(594,3687,40812,3045,2,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',63875.90,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:14:04','2021-05-18 02:14:04'),(595,3687,40812,3045,2,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',69012.35,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:13:45','2021-05-18 02:13:45');
INSERT INTO `balance_libro` VALUES (596,3687,40812,3045,2,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',17532.90,NULL,NULL,1,'2021-05-17 17:44:53','2021-05-18 02:13:19','2021-05-18 02:13:19'),(597,3687,40812,3045,3,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6900.00,NULL,NULL,1,'2021-05-17 17:45:58','2021-05-18 02:23:38','2021-05-18 02:23:38'),(598,3687,40812,3045,3,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',6400.00,NULL,NULL,1,'2021-05-17 17:48:38','2021-05-17 17:57:30','2021-05-17 17:57:30'),(599,3687,40812,3045,3,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6400.00,NULL,NULL,1,'2021-05-17 17:50:37','2021-05-18 02:23:28','2021-05-18 02:23:28'),(600,3687,40812,3045,3,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4953.00,NULL,NULL,1,'2021-05-17 17:52:08','2021-05-17 17:53:42','2021-05-17 17:53:42'),(601,3687,40812,3045,3,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4836.00,NULL,NULL,1,'2021-05-17 17:53:42','2021-05-18 02:23:14','2021-05-18 02:23:14'),(602,3687,40812,3045,3,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6900.00,NULL,NULL,1,'2021-05-17 17:54:20','2021-05-18 02:23:08','2021-05-18 02:23:08'),(603,3687,40812,3045,3,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-17 17:55:29','2021-05-18 02:23:03','2021-05-18 02:23:03'),(604,3687,40812,3045,3,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',55000.00,NULL,NULL,1,'2021-05-17 17:55:55','2021-05-18 02:22:56','2021-05-18 02:22:56'),(605,3687,40812,3045,3,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-17 17:56:22','2021-05-18 02:22:50','2021-05-18 02:22:50'),(606,3687,40812,3045,3,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',7200.00,NULL,NULL,1,'2021-05-17 17:56:55','2021-05-18 02:22:45','2021-05-18 02:22:45'),(607,3687,40812,3045,3,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4400.00,NULL,NULL,1,'2021-05-17 17:57:16','2021-05-18 02:22:36','2021-05-18 02:22:36'),(608,3687,40812,3045,3,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',6400.00,NULL,NULL,1,'2021-05-17 17:57:30','2021-05-18 02:22:25','2021-05-18 02:22:25'),(609,3687,40812,3045,3,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',990.00,NULL,NULL,1,'2021-05-17 17:57:44','2021-05-18 02:22:15','2021-05-18 02:22:15'),(610,3687,40812,3045,3,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7200.00,NULL,NULL,1,'2021-05-17 17:58:02','2021-05-18 02:21:56','2021-05-18 02:21:56'),(611,3687,40812,3045,3,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',5600.00,NULL,NULL,1,'2021-05-17 18:00:32','2021-05-18 13:14:26','2021-05-18 13:14:26'),(612,3687,40812,3045,3,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6900.00,NULL,NULL,1,'2021-05-17 18:00:51','2021-05-18 13:14:26','2021-05-18 13:14:26'),(613,3687,40812,3045,3,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7200.00,NULL,NULL,1,'2021-05-17 18:01:08','2021-05-18 13:14:26','2021-05-18 13:14:26'),(614,3687,40812,3045,3,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5200.00,NULL,NULL,1,'2021-05-17 18:01:22','2021-05-18 02:21:23','2021-05-18 02:21:23'),(615,3687,40812,3045,3,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',120000.00,NULL,NULL,1,'2021-05-17 18:02:00','2021-05-18 02:20:55','2021-05-18 02:20:55'),(616,3687,40812,3045,3,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7200.00,NULL,NULL,1,'2021-05-17 18:02:15','2021-05-18 02:20:33','2021-05-18 02:20:33'),(617,3687,40812,3045,3,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3100.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23');
INSERT INTO `balance_libro` VALUES (618,3687,40812,3045,3,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6900.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:02:53','2021-05-19 02:02:53'),(619,3687,40812,3045,3,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',5227.20,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(620,3687,40812,3045,3,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6400.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:03:16','2021-05-19 02:03:16'),(621,3687,40812,3045,3,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',21175.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(622,3687,40812,3045,3,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4836.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:06:10','2021-05-19 02:06:10'),(623,3687,40812,3045,3,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6900.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:08:12','2021-05-19 02:08:12'),(624,3687,40812,3045,3,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:08:43','2021-05-19 02:08:43'),(625,3687,40812,3045,3,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',55000.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:09:08','2021-05-19 02:09:08'),(626,3687,40812,3045,3,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:09:28','2021-05-19 02:09:28'),(627,3687,40812,3045,3,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',7200.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:10:05','2021-05-19 02:10:05'),(628,3687,40812,3045,3,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',20500.06,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(629,3687,40812,3045,3,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4400.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:10:18','2021-05-19 02:10:18'),(630,3687,40812,3045,3,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',18488.23,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(631,3687,40812,3045,3,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',6400.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:10:28','2021-05-19 02:10:28'),(632,3687,40812,3045,3,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',990.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:11:17','2021-05-19 02:11:17'),(633,3687,40812,3045,3,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1875.50,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(634,3687,40812,3045,3,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3859.42,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(635,3687,40812,3045,3,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7200.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:11:33','2021-05-19 02:11:33'),(636,3687,40812,3045,3,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',9227.65,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:12:33','2021-05-19 02:12:33'),(637,3687,40812,3045,3,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',68716.12,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(638,3687,40812,3045,3,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',132.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(639,3687,40812,3045,3,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',5600.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:12:49','2021-05-19 02:12:49');
INSERT INTO `balance_libro` VALUES (640,3687,40812,3045,3,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6900.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:01:56','2021-05-19 02:01:56'),(641,3687,40812,3045,3,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7200.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:13:28','2021-05-19 02:13:28'),(642,3687,40812,3045,3,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',43218.99,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(643,3687,40812,3045,3,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1117.60,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(644,3687,40812,3045,3,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5200.00,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:13:43','2021-05-19 02:13:43'),(645,3687,40812,3045,3,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1059256.69,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(646,3687,40812,3045,3,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',298147.63,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(647,3687,40812,3045,3,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',670415.63,NULL,NULL,1,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(648,3687,40812,3045,3,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',120000.00,NULL,NULL,1,'2021-05-19 02:00:28','2021-05-19 02:02:22','2021-05-19 02:02:22'),(649,3687,40812,3045,3,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',327234.34,NULL,NULL,1,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(650,3687,40812,3045,3,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',337505.78,NULL,NULL,1,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(651,3687,40812,3045,3,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7200.00,NULL,NULL,1,'2021-05-19 02:00:28','2021-05-19 02:02:10','2021-05-19 02:02:10'),(652,3687,40812,3045,3,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6900.00,NULL,NULL,1,'2021-05-19 02:01:56','2021-05-19 02:13:11','2021-05-19 02:13:11'),(653,3687,40812,3045,3,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7200.00,NULL,NULL,1,'2021-05-19 02:02:10','2021-05-19 02:14:13','2021-05-19 02:14:13'),(654,3687,40812,3045,3,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',120000.00,NULL,NULL,1,'2021-05-19 02:02:22','2021-05-19 02:13:56','2021-05-19 02:13:56'),(655,3687,40812,3045,3,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6900.00,NULL,NULL,1,'2021-05-19 02:02:53','2021-05-19 02:40:23','2021-05-19 02:40:23'),(656,3687,40812,3045,3,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6400.00,NULL,NULL,1,'2021-05-19 02:03:16','2021-05-19 02:40:23','2021-05-19 02:40:23'),(657,3687,40812,3045,3,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4953.00,NULL,NULL,1,'2021-05-19 02:06:10','2021-05-19 02:07:37','2021-05-19 02:07:37'),(658,3687,40812,3045,3,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4836.00,NULL,NULL,1,'2021-05-19 02:07:37','2021-05-19 02:40:23','2021-05-19 02:40:23'),(659,3687,40812,3045,3,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6900.00,NULL,NULL,1,'2021-05-19 02:08:12','2021-05-19 02:40:23','2021-05-19 02:40:23'),(660,3687,40812,3045,3,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-19 02:08:43','2021-05-19 02:40:23','2021-05-19 02:40:23'),(661,3687,40812,3045,3,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',55000.00,NULL,NULL,1,'2021-05-19 02:09:08','2021-05-19 02:40:23','2021-05-19 02:40:23');
INSERT INTO `balance_libro` VALUES (662,3687,40812,3045,3,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-19 02:09:28','2021-05-19 02:40:23','2021-05-19 02:40:23'),(663,3687,40812,3045,3,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',7200.00,NULL,NULL,1,'2021-05-19 02:10:05','2021-05-19 02:40:23','2021-05-19 02:40:23'),(664,3687,40812,3045,3,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4400.00,NULL,NULL,1,'2021-05-19 02:10:18','2021-05-19 02:40:24','2021-05-19 02:40:24'),(665,3687,40812,3045,3,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',6400.00,NULL,NULL,1,'2021-05-19 02:10:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(666,3687,40812,3045,3,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',990.00,NULL,NULL,1,'2021-05-19 02:11:17','2021-05-19 02:40:24','2021-05-19 02:40:24'),(667,3687,40812,3045,3,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7200.00,NULL,NULL,1,'2021-05-19 02:11:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(668,3687,40812,3045,3,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',9227.65,NULL,NULL,1,'2021-05-19 02:12:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(669,3687,40812,3045,3,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',5600.00,NULL,NULL,1,'2021-05-19 02:12:49','2021-05-19 02:40:24','2021-05-19 02:40:24'),(670,3687,40812,3045,3,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6900.00,NULL,NULL,1,'2021-05-19 02:13:11','2021-05-19 02:40:24','2021-05-19 02:40:24'),(671,3687,40812,3045,3,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7200.00,NULL,NULL,1,'2021-05-19 02:13:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(672,3687,40812,3045,3,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5200.00,NULL,NULL,1,'2021-05-19 02:13:43','2021-05-19 02:40:24','2021-05-19 02:40:24'),(673,3687,40812,3045,3,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',120000.00,NULL,NULL,1,'2021-05-19 02:13:56','2021-05-19 02:40:24','2021-05-19 02:40:24'),(674,3687,40812,3045,3,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7200.00,NULL,NULL,1,'2021-05-19 02:14:13','2021-05-19 02:40:24','2021-05-19 02:40:24'),(675,3687,40812,3045,3,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3100.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-23 14:06:06','2021-05-23 14:06:06'),(676,3687,40812,3045,3,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6900.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(677,3687,40812,3045,3,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',5227.20,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(678,3687,40812,3045,3,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6400.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(679,3687,40812,3045,3,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',21175.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(680,3687,40812,3045,3,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4836.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(681,3687,40812,3045,3,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6900.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(682,3687,40812,3045,3,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(683,3687,40812,3045,3,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',55000.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(684,3687,40812,3045,3,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12000.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL);
INSERT INTO `balance_libro` VALUES (685,3687,40812,3045,3,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',7200.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(686,3687,40812,3045,3,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',20500.06,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(687,3687,40812,3045,3,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4400.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(688,3687,40812,3045,3,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',18488.23,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(689,3687,40812,3045,3,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',6400.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(690,3687,40812,3045,3,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',990.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(691,3687,40812,3045,3,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1875.50,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(692,3687,40812,3045,3,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3859.42,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(693,3687,40812,3045,3,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7200.00,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(694,3687,40812,3045,3,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',9227.65,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(695,3687,40812,3045,3,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',68716.12,NULL,NULL,1,'2021-05-19 02:42:46','2021-05-20 18:01:57','2021-05-20 18:01:57'),(696,3687,40812,3045,3,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',132.00,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-23 13:02:08','2021-05-23 13:02:08'),(697,3687,40812,3045,3,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',5600.00,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(698,3687,40812,3045,3,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6900.00,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(699,3687,40812,3045,3,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7200.00,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(700,3687,40812,3045,3,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',43218.99,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(701,3687,40812,3045,3,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1117.60,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(702,3687,40812,3045,3,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5200.00,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(703,3687,40812,3045,3,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1059256.69,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(704,3687,40812,3045,3,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',298147.63,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(705,3687,40812,3045,3,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',670415.63,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(706,3687,40812,3045,3,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',120000.00,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(707,3687,40812,3045,3,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',327234.34,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(708,3687,40812,3045,3,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',337505.78,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL);
INSERT INTO `balance_libro` VALUES (709,3687,40812,3045,3,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7200.00,NULL,NULL,1,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(710,3687,40812,3045,3,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',68716.12,NULL,NULL,1,'2021-05-20 18:01:57','2021-05-20 18:01:57',NULL),(711,3687,40812,3045,3,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1810.00,NULL,NULL,1,'2021-05-20 18:32:43','2021-05-20 18:32:43',NULL),(712,3687,40812,3045,3,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3900.68,NULL,NULL,1,'2021-05-20 18:35:08','2021-05-20 18:35:08',NULL),(713,3687,40812,3045,3,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1263.90,NULL,NULL,1,'2021-05-20 18:37:14','2021-05-20 18:37:14',NULL),(714,3687,40812,3045,3,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',895.88,NULL,NULL,1,'2021-05-20 18:38:25','2021-05-20 18:38:25',NULL),(715,3687,40812,3045,3,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',50345.21,NULL,NULL,1,'2021-05-20 18:41:01','2021-05-20 18:41:01',NULL),(716,3687,40812,3045,3,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',3435.74,NULL,NULL,1,'2021-05-20 18:42:35','2021-05-23 13:56:23','2021-05-23 13:56:23'),(717,3687,40812,3045,3,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',43366.44,NULL,NULL,1,'2021-05-20 18:44:27','2021-05-23 13:57:07','2021-05-23 13:57:07'),(718,3687,40812,3045,3,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',4300.44,NULL,NULL,1,'2021-05-20 18:45:37','2021-05-20 18:45:37',NULL),(719,3687,40812,3045,3,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',530.00,NULL,NULL,1,'2021-05-20 18:47:27','2021-05-20 18:47:27',NULL),(720,3687,40812,3045,3,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',842.81,NULL,NULL,1,'2021-05-20 18:50:01','2021-05-20 18:50:01',NULL),(721,3687,40812,3045,3,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1097.04,NULL,NULL,1,'2021-05-20 18:51:15','2021-05-20 18:51:15',NULL),(722,3687,40812,3045,3,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7534.82,NULL,NULL,1,'2021-05-20 18:54:12','2021-05-20 18:54:12',NULL),(723,3687,40812,3045,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',34239.22,NULL,NULL,1,'2021-05-23 13:12:48','2021-05-23 13:16:16','2021-05-23 13:16:16'),(724,3687,40812,3045,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',27909.94,NULL,NULL,1,'2021-05-23 13:16:16','2021-05-23 14:31:16','2021-05-23 14:31:16'),(725,3687,40812,3045,3,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',26285.49,NULL,NULL,1,'2021-05-23 13:24:37','2021-05-23 13:24:37',NULL),(726,3687,40812,3045,3,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',3435.74,NULL,NULL,1,'2021-05-23 13:56:23','2021-05-23 13:56:23',NULL),(727,3687,40812,3045,3,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',43366.44,NULL,NULL,1,'2021-05-23 13:57:07','2021-05-23 13:57:07',NULL),(728,3687,40812,3045,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',19226.90,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(729,3687,40812,3045,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',78202.30,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(730,3687,40812,3045,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',141328.00,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(731,3687,40812,3045,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',48708.55,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(732,3687,40812,3045,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',64009.00,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL);
INSERT INTO `balance_libro` VALUES (733,3687,40812,3045,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',7810.55,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(734,3687,40812,3045,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',143983.95,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(735,3687,40812,3045,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',15028.20,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(736,3687,40812,3045,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',68268.20,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(737,3687,40812,3045,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',116768.63,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(738,3687,40812,3045,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',33250.80,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(739,3687,40812,3045,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',237281.00,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(740,3687,40812,3045,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',102569.28,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(741,3687,40812,3045,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7514.10,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(742,3687,40812,3045,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',50820.00,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(743,3687,40812,3045,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7623.00,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(744,3687,40812,3045,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',56410.20,NULL,NULL,1,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(745,3687,40812,3045,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',63949.71,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(746,3687,40812,3045,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',29403.00,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(747,3687,40812,3045,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',47105.30,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(748,3687,40812,3045,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',49912.50,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(749,3687,40812,3045,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',28967.40,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(750,3687,40812,3045,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',63633.90,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(751,3687,40812,3045,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2048.05,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(752,3687,40812,3045,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',30534.35,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(753,3687,40812,3045,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',21235.50,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(754,3687,40812,3045,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',29838.60,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(755,3687,40812,3045,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',37274.05,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(756,3687,40812,3045,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',66562.10,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(757,3687,40812,3045,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',23637.35,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL);
INSERT INTO `balance_libro` VALUES (758,3687,40812,3045,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',80856.14,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(759,3687,40812,3045,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',76697.54,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(760,3687,40812,3045,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',668632.69,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(761,3687,40812,3045,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',18367.80,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(762,3687,40812,3045,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',37485.80,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(763,3687,40812,3045,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',856268.60,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(764,3687,40812,3045,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',7332.60,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(765,3687,40812,3045,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',30056.40,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(766,3687,40812,3045,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',12559.80,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(767,3687,40812,3045,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',26136.00,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(768,3687,40812,3045,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',67687.40,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(769,3687,40812,3045,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',68716.12,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(770,3687,40812,3045,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',41539.30,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(771,3687,40812,3045,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',63875.90,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(772,3687,40812,3045,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',69012.35,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(773,3687,40812,3045,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',17532.90,NULL,NULL,1,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(774,3687,40720,1534,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',441173.01,NULL,NULL,1,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(775,3687,40720,1534,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',205000.00,NULL,NULL,1,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(776,3687,40720,1534,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',57685.54,NULL,NULL,1,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(777,3687,40720,1534,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',54700.00,NULL,NULL,1,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(778,3687,40720,1534,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',16547.65,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(779,3687,40720,1534,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',257797.16,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(780,3687,40720,1534,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',19305.59,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(781,3687,40720,1534,2,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',104288.70,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(782,3687,40720,1534,2,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',35953.79,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL);
INSERT INTO `balance_libro` VALUES (783,3687,40720,1534,2,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',48974.05,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(784,3687,40720,1534,2,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',125789.28,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(785,3687,40720,1534,2,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',37566.87,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(786,3687,40720,1534,2,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',27117.69,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(787,3687,40720,1534,2,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',2475.18,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(788,3687,40720,1534,2,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',102975.84,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(789,3687,40720,1534,2,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',29479.06,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(790,3687,40720,1534,2,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',41118.83,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(791,3687,40720,1534,2,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',12336.14,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(792,3687,40720,1534,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',29479.06,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(793,3687,40720,1534,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',257797.16,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(794,3687,40720,1534,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',29479.06,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(795,3687,40720,1534,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',257797.16,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(796,3687,40720,1534,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',29000.00,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(797,3687,40720,1534,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',7738.13,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(798,3687,40720,1534,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',286000.00,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(799,3687,40720,1534,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',41118.83,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(800,3687,40720,1534,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',41118.83,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(801,3687,40720,1534,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',427304.22,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(802,3687,40720,1534,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',153343.00,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(803,3687,40720,1534,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3124.69,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(804,3687,40720,1534,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',20073.17,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(805,3687,40720,1534,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',17113.18,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(806,3687,40720,1534,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',74865.66,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(807,3687,40720,1534,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',58441.81,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL);
INSERT INTO `balance_libro` VALUES (808,3687,40720,1534,2,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',60076.28,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(809,3687,40720,1534,2,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',470.48,NULL,NULL,1,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(810,3687,40720,1534,3,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',21175.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(811,3687,40720,1534,3,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',2322525.84,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(812,3687,40720,1534,3,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',56375.72,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(813,3687,40720,1534,3,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',753469.17,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(814,3687,40720,1534,3,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',10400.98,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 13:36:42','2021-06-14 13:36:42'),(815,3687,40720,1534,3,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',90000.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(816,3687,40720,1534,3,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',100000.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(817,3687,40720,1534,3,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',100000.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:38:01','2021-06-14 12:38:01'),(818,3687,40720,1534,3,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',100000.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(819,3687,40720,1534,3,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',1972.51,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(820,3687,40720,1534,3,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',6000.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(821,3687,40720,1534,3,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',15609.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(822,3687,40720,1534,3,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1611.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(823,3687,40720,1534,3,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',974052.30,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(824,3687,40720,1534,3,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',34828.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(825,3687,40720,1534,3,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',89235.08,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(826,3687,40720,1534,3,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',9780.01,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(827,3687,40720,1534,3,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',650000.00,NULL,NULL,1,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(828,3687,40812,3046,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',16008.30,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(829,3687,40812,3046,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',63198.30,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(830,3687,40812,3046,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',229900.00,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(831,3687,40812,3046,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',15730.00,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL);
INSERT INTO `balance_libro` VALUES (832,3687,40812,3046,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',37570.50,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(833,3687,40812,3046,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',174248.48,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(834,3687,40812,3046,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',20636.55,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(835,3687,40812,3046,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',45352.01,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(836,3687,40812,3046,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',57293.50,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(837,3687,40812,3046,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',95348.00,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(838,3687,40812,3046,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',321036.72,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(839,3687,40812,3046,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',55381.70,NULL,NULL,1,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(840,3687,40812,3046,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',30413.35,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(841,3687,40812,3046,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',340292.17,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(842,3687,40812,3046,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',42247.15,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(843,3687,40812,3046,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',118592.10,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(844,3687,40812,3046,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',34642.30,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(845,3687,40812,3046,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',47716.35,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(846,3687,40812,3046,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',159199.70,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(847,3687,40812,3046,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',11519.20,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(848,3687,40812,3046,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',17557.10,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(849,3687,40812,3046,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',72321.70,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(850,3687,40812,3046,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',48841.65,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(851,3687,40812,3046,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',621262.40,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(852,3687,40812,3046,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',28798.00,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(853,3687,40812,3046,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',69502.40,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(854,3687,40812,3046,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',32379.60,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(855,3687,40812,3046,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',160506.50,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL);
INSERT INTO `balance_libro` VALUES (856,3687,40812,3046,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',161864.12,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(857,3687,40812,3046,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',56144.00,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(858,3687,40812,3046,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',28386.60,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(859,3687,40812,3046,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',21592.45,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(860,3687,40812,3046,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',17756.75,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(861,3687,40812,3046,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',105814.50,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(862,3687,40812,3046,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',26378.00,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(863,3687,40812,3046,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',11531.30,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(864,3687,40812,3046,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',41563.50,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(865,3687,40812,3046,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',66749.65,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(866,3687,40812,3046,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',257840.35,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(867,3687,40812,3046,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',53772.40,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(868,3687,40812,3046,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',43197.00,NULL,NULL,1,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(869,3687,40812,3046,3,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',4600.00,NULL,NULL,1,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(870,3687,40812,3046,3,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',21175.00,NULL,NULL,1,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(871,3687,40812,3046,3,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',5227.20,NULL,NULL,1,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(872,3687,40812,3046,3,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',12000.00,NULL,NULL,1,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(873,3687,40812,3046,3,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',6000.00,NULL,NULL,1,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(874,3687,40812,3046,3,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',12000.00,NULL,NULL,1,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(875,3687,40812,3046,3,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',4836.00,NULL,NULL,1,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(876,3687,40812,3046,3,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6400.00,NULL,NULL,1,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(877,3687,40812,3046,3,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6400.00,NULL,NULL,1,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(878,3687,40812,3046,3,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',2783.00,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59');
INSERT INTO `balance_libro` VALUES (879,3687,40812,3046,3,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9500.00,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(880,3687,40812,3046,3,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',55000.00,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(881,3687,40812,3046,3,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',219934.44,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(882,3687,40812,3046,3,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',47400.00,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(883,3687,40812,3046,3,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',518647.74,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(884,3687,40812,3046,3,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',7200.00,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(885,3687,40812,3046,3,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',6400.00,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(886,3687,40812,3046,3,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',492.57,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(887,3687,40812,3046,3,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',10079.45,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(888,3687,40812,3046,3,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8800.00,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(889,3687,40812,3046,3,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',45595.01,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(890,3687,40812,3046,3,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',2178.00,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(891,3687,40812,3046,3,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',328095.86,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(892,3687,40812,3046,3,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',220425.70,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(893,3687,40812,3046,3,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',150000.00,NULL,NULL,1,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(894,3687,40720,1534,3,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',100000.00,NULL,NULL,1,'2021-06-14 12:38:01','2021-06-14 12:38:01',NULL),(895,3687,40720,1534,3,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',978.80,NULL,NULL,1,'2021-06-14 13:12:49','2021-06-14 13:12:49',NULL),(896,3687,40720,1534,3,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',1087.17,NULL,NULL,1,'2021-06-14 13:16:11','2021-06-14 13:16:11',NULL),(897,3687,40720,1534,3,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',246286.56,NULL,NULL,1,'2021-06-14 13:19:01','2021-06-14 13:19:01',NULL),(898,3687,40720,1534,3,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',267.32,NULL,NULL,1,'2021-06-14 13:20:16','2021-06-14 13:20:16',NULL),(899,3687,40720,1534,3,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',1623.11,NULL,NULL,1,'2021-06-14 13:22:07','2021-06-14 13:22:07',NULL),(900,3687,40720,1534,3,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',3400.01,NULL,NULL,1,'2021-06-14 13:24:46','2021-06-14 13:24:46',NULL),(901,3687,40720,1534,3,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',51186.21,NULL,NULL,1,'2021-06-14 13:27:54','2021-06-14 13:27:54',NULL);
INSERT INTO `balance_libro` VALUES (902,3687,40720,1534,3,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',10400.98,NULL,NULL,1,'2021-06-14 13:36:42','2021-06-14 13:42:23','2021-06-14 13:42:23'),(903,3687,40720,1534,3,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',10400.98,NULL,NULL,1,'2021-06-14 13:42:23','2021-06-14 13:42:23',NULL),(904,3687,40812,3046,3,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',4600.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 15:11:40','2021-06-20 15:11:40'),(905,3687,40812,3046,3,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',21175.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(906,3687,40812,3046,3,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',5227.20,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(907,3687,40812,3046,3,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',12000.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:42:25','2021-06-20 13:42:25'),(908,3687,40812,3046,3,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',6000.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:43:06','2021-06-20 13:43:06'),(909,3687,40812,3046,3,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',12000.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:43:35','2021-06-20 13:43:35'),(910,3687,40812,3046,3,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',4836.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:44:37','2021-06-20 13:44:37'),(911,3687,40812,3046,3,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6400.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:45:25','2021-06-20 13:45:25'),(912,3687,40812,3046,3,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6400.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:45:33','2021-06-20 13:45:33'),(913,3687,40812,3046,3,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',2783.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(914,3687,40812,3046,3,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9500.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(915,3687,40812,3046,3,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',55000.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:46:10','2021-06-20 13:46:10'),(916,3687,40812,3046,3,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',219934.44,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(917,3687,40812,3046,3,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',47400.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:46:35','2021-06-20 13:46:35'),(918,3687,40812,3046,3,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',518647.74,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(919,3687,40812,3046,3,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',7200.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:46:52','2021-06-20 13:46:52'),(920,3687,40812,3046,3,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',6400.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:47:08','2021-06-20 13:47:08'),(921,3687,40812,3046,3,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',492.57,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-22 17:59:01','2021-06-22 17:59:01'),(922,3687,40812,3046,3,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',10079.45,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:48:42','2021-06-20 13:48:42'),(923,3687,40812,3046,3,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8800.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:48:59','2021-06-20 13:48:59'),(924,3687,40812,3046,3,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',45595.01,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL);
INSERT INTO `balance_libro` VALUES (925,3687,40812,3046,3,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',2178.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(926,3687,40812,3046,3,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',328095.86,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(927,3687,40812,3046,3,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',220425.70,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(928,3687,40812,3046,3,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',150000.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:49:28','2021-06-20 13:49:28'),(929,3687,40812,3046,3,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',1810.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(930,3687,40812,3046,3,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',790.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(931,3687,40812,3046,3,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',4300.00,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(932,3687,40812,3046,3,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',1013.42,NULL,NULL,1,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(933,3687,40812,3046,3,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',1312.20,NULL,NULL,1,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(934,3687,40812,3046,3,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',994.50,NULL,NULL,1,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(935,3687,40812,3046,3,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',711.22,NULL,NULL,1,'2021-06-20 13:38:16','2021-06-22 16:53:43','2021-06-22 16:53:43'),(936,3687,40812,3046,3,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',1307.61,NULL,NULL,1,'2021-06-20 13:38:16','2021-06-22 16:53:24','2021-06-22 16:53:24'),(937,3687,40812,3046,3,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',835.89,NULL,NULL,1,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(938,3687,40812,3046,3,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',1121.90,NULL,NULL,1,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(939,3687,40812,3046,3,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',3039.67,NULL,NULL,1,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(940,3687,40812,3046,3,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',32500.98,NULL,NULL,1,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(941,3687,40812,3046,3,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',12000.00,NULL,NULL,1,'2021-06-20 13:42:25','2021-06-20 13:42:25',NULL),(942,3687,40812,3046,3,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',6000.00,NULL,NULL,1,'2021-06-20 13:43:06','2021-06-20 13:43:06',NULL),(943,3687,40812,3046,3,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',12000.00,NULL,NULL,1,'2021-06-20 13:43:35','2021-06-20 13:43:35',NULL),(944,3687,40812,3046,3,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',4836.00,NULL,NULL,1,'2021-06-20 13:44:37','2021-06-20 13:44:37',NULL),(945,3687,40812,3046,3,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6400.00,NULL,NULL,1,'2021-06-20 13:45:25','2021-06-20 13:45:41','2021-06-20 13:45:41'),(946,3687,40812,3046,3,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6400.00,NULL,NULL,1,'2021-06-20 13:45:33','2021-06-20 13:45:33',NULL),(947,3687,40812,3046,3,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6400.00,NULL,NULL,1,'2021-06-20 13:45:41','2021-06-20 13:45:41',NULL),(948,3687,40812,3046,3,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',55000.00,NULL,NULL,1,'2021-06-20 13:46:10','2021-06-20 13:46:10',NULL);
INSERT INTO `balance_libro` VALUES (949,3687,40812,3046,3,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',47400.00,NULL,NULL,1,'2021-06-20 13:46:35','2021-06-20 13:46:35',NULL),(950,3687,40812,3046,3,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',7200.00,NULL,NULL,1,'2021-06-20 13:46:52','2021-06-20 13:46:52',NULL),(951,3687,40812,3046,3,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',6400.00,NULL,NULL,1,'2021-06-20 13:47:08','2021-06-20 13:47:08',NULL),(952,3687,40812,3046,3,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',10079.45,NULL,NULL,1,'2021-06-20 13:48:42','2021-06-20 13:48:42',NULL),(953,3687,40812,3046,3,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8800.00,NULL,NULL,1,'2021-06-20 13:48:59','2021-06-20 13:48:59',NULL),(954,3687,40812,3046,3,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',150000.00,NULL,NULL,1,'2021-06-20 13:49:28','2021-06-20 13:49:28',NULL),(955,3687,40812,3046,3,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',4600.00,NULL,NULL,1,'2021-06-20 15:11:40','2021-06-20 15:11:40',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2820 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,3687,1,40720,1533,3,250,1,6900.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:07:04','2021-05-15 18:07:04'),(2,3687,1,40720,1533,3,57,2,6900.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:07:04','2021-05-15 18:07:04'),(3,3687,2,40720,1533,3,217,1,17500.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(4,3687,2,40720,1533,3,68,1,3675.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(5,3687,2,40720,1533,3,57,2,21175.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(6,3687,3,40720,1533,3,217,1,3286.56,NULL,'2021-05-15 18:03:01','2021-05-15 18:08:21','2021-05-15 18:08:21'),(7,3687,3,40720,1533,3,68,1,690.18,NULL,'2021-05-15 18:03:01','2021-05-15 18:08:21','2021-05-15 18:08:21'),(8,3687,3,40720,1533,3,217,1,295.79,NULL,'2021-05-15 18:03:01','2021-05-15 18:08:21','2021-05-15 18:08:21'),(9,3687,3,40720,1533,3,57,2,4272.53,NULL,'2021-05-15 18:03:01','2021-05-15 18:08:21','2021-05-15 18:08:21'),(10,3687,4,40720,1533,3,217,1,9371.07,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(11,3687,4,40720,1533,3,68,1,1967.93,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(12,3687,4,40720,1533,3,57,2,11339.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(13,3687,5,40720,1533,3,250,1,56276.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:09:16','2021-05-15 18:09:16'),(14,3687,5,40720,1533,3,57,2,56276.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:09:16','2021-05-15 18:09:16'),(15,3687,6,40720,1533,3,250,2,6900.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:09:44','2021-05-15 18:09:44'),(16,3687,6,40720,1533,3,57,1,6900.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:09:44','2021-05-15 18:09:44'),(17,3687,7,40720,1533,3,217,1,48212.77,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(18,3687,7,40720,1533,3,68,1,10124.68,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(19,3687,7,40720,1533,3,57,2,58337.45,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(20,3687,8,40720,1533,3,217,1,48299.94,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(21,3687,8,40720,1533,3,68,1,10142.99,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(22,3687,8,40720,1533,3,57,2,58442.93,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(23,3687,9,40720,1533,3,217,1,1140.57,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(24,3687,9,40720,1533,3,68,1,239.52,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(25,3687,9,40720,1533,3,57,2,1380.09,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(26,3687,10,40720,1533,3,217,1,32180.48,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(27,3687,10,40720,1533,3,68,1,6757.90,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(28,3687,10,40720,1533,3,57,2,38938.38,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(29,3687,11,40720,1533,3,217,2,48212.77,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(30,3687,11,40720,1533,3,67,2,10124.68,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(31,3687,11,40720,1533,3,57,1,58337.45,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(32,3687,12,40720,1533,3,217,1,24974.50,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(33,3687,12,40720,1533,3,68,1,5244.65,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(34,3687,12,40720,1533,3,57,2,30219.15,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(35,3687,13,40720,1533,3,217,1,698.35,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(36,3687,13,40720,1533,3,68,1,146.65,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(37,3687,13,40720,1533,3,57,2,845.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(38,3687,14,40720,1533,3,217,1,591.95,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(39,3687,14,40720,1533,3,68,1,124.31,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(40,3687,14,40720,1533,3,57,2,716.26,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(41,3687,15,40720,1533,3,217,1,6768.31,NULL,'2021-05-15 18:03:01','2021-05-15 18:10:53','2021-05-15 18:10:53');
INSERT INTO `balance_libro_details` VALUES (42,3687,15,40720,1533,3,68,1,1809.44,NULL,'2021-05-15 18:03:01','2021-05-15 18:10:53','2021-05-15 18:10:53'),(43,3687,15,40720,1533,3,217,1,543.48,NULL,'2021-05-15 18:03:01','2021-05-15 18:10:53','2021-05-15 18:10:53'),(44,3687,15,40720,1533,3,57,2,9121.23,NULL,'2021-05-15 18:03:01','2021-05-15 18:10:53','2021-05-15 18:10:53'),(45,3687,16,40720,1533,3,217,1,1657.84,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(46,3687,16,40720,1533,3,68,1,348.15,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(47,3687,16,40720,1533,3,57,2,2005.99,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(48,3687,17,40720,1533,3,217,1,1510.74,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(49,3687,17,40720,1533,3,68,1,317.26,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(50,3687,17,40720,1533,3,57,2,1828.00,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(51,3687,18,40720,1533,3,217,1,35265.36,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(52,3687,18,40720,1533,3,68,1,7405.73,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(53,3687,18,40720,1533,3,57,2,42671.09,NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(54,3687,19,40720,1533,3,217,2,1358.68,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(55,3687,19,40720,1533,3,67,2,285.32,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(56,3687,19,40720,1533,3,57,1,1644.00,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(57,3687,20,40720,1533,3,217,1,66958.58,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(58,3687,20,40720,1533,3,68,1,14061.30,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(59,3687,20,40720,1533,3,57,2,81019.88,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(60,3687,21,40720,1533,3,217,1,73800.88,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(61,3687,21,40720,1533,3,68,1,15498.18,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(62,3687,21,40720,1533,3,57,2,89299.06,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(63,3687,22,40720,1533,3,217,1,80141.98,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(64,3687,22,40720,1533,3,68,1,16829.82,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(65,3687,22,40720,1533,3,57,2,96971.80,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(66,3687,23,40720,1533,3,217,2,80141.98,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(67,3687,23,40720,1533,3,67,2,16829.82,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(68,3687,23,40720,1533,3,57,1,96971.80,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(69,3687,24,40720,1533,3,217,2,13183.40,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(70,3687,24,40720,1533,3,67,2,2768.52,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(71,3687,24,40720,1533,3,57,1,15951.92,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(72,3687,25,40720,1533,3,217,1,13183.40,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(73,3687,25,40720,1533,3,68,1,2768.52,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(74,3687,25,40720,1533,3,57,2,15951.92,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(75,3687,26,40720,1533,3,217,2,73800.88,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(76,3687,26,40720,1533,3,67,2,15498.18,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(77,3687,26,40720,1533,3,57,1,89299.06,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(78,3687,27,40720,1533,3,217,1,80141.98,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(79,3687,27,40720,1533,3,68,1,16829.82,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(80,3687,27,40720,1533,3,57,2,96971.80,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(81,3687,28,40720,1533,3,217,2,3788.80,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(82,3687,28,40720,1533,3,67,2,795.65,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(83,3687,28,40720,1533,3,57,1,4584.45,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL);
INSERT INTO `balance_libro_details` VALUES (84,3687,29,40720,1533,3,250,1,6900.00,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(85,3687,29,40720,1533,3,57,2,6900.00,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(86,3687,30,40720,1533,3,217,1,8505.06,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(87,3687,30,40720,1533,3,68,1,1786.06,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(88,3687,30,40720,1533,3,57,2,10291.12,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(89,3687,31,40720,1533,3,217,1,30949.00,NULL,'2021-05-15 18:03:02','2021-05-16 14:29:49','2021-05-16 14:29:49'),(90,3687,31,40720,1533,3,68,1,4131.69,NULL,'2021-05-15 18:03:02','2021-05-16 14:29:49','2021-05-16 14:29:49'),(91,3687,31,40720,1533,3,57,2,35080.69,NULL,'2021-05-15 18:03:02','2021-05-16 14:29:49','2021-05-16 14:29:49'),(92,3687,32,40720,1533,3,217,1,14698.62,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(93,3687,32,40720,1533,3,68,1,3086.71,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(94,3687,32,40720,1533,3,57,2,17785.33,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(95,3687,33,40720,1533,3,217,1,29876.02,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(96,3687,33,40720,1533,3,68,1,3136.98,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(97,3687,33,40720,1533,3,57,2,33013.00,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(98,3687,34,40720,1533,3,217,1,96090.00,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(99,3687,34,40720,1533,3,68,1,20178.90,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(100,3687,34,40720,1533,3,57,2,116268.90,NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(101,3687,35,40720,1533,3,250,1,6900.00,NULL,'2021-05-15 18:07:04','2021-05-15 18:07:04',NULL),(102,3687,35,40720,1533,3,57,2,6900.00,NULL,'2021-05-15 18:07:04','2021-05-15 18:07:04',NULL),(103,3687,36,40720,1533,3,217,1,3286.56,NULL,'2021-05-15 18:08:21','2021-05-15 18:22:25','2021-05-15 18:22:25'),(104,3687,36,40720,1533,3,68,1,690.18,NULL,'2021-05-15 18:08:21','2021-05-15 18:22:25','2021-05-15 18:22:25'),(105,3687,36,40720,1533,3,217,1,197.19,NULL,'2021-05-15 18:08:21','2021-05-15 18:22:25','2021-05-15 18:22:25'),(106,3687,36,40720,1533,3,57,2,4173.93,NULL,'2021-05-15 18:08:21','2021-05-15 18:22:25','2021-05-15 18:22:25'),(107,3687,37,40720,1533,3,250,1,56276.00,NULL,'2021-05-15 18:09:16','2021-05-15 19:14:47','2021-05-15 19:14:47'),(108,3687,37,40720,1533,3,57,2,56276.00,NULL,'2021-05-15 18:09:16','2021-05-15 19:14:47','2021-05-15 19:14:47'),(109,3687,38,40720,1533,3,250,2,6900.00,NULL,'2021-05-15 18:09:44','2021-05-15 18:09:44',NULL),(110,3687,38,40720,1533,3,57,1,6900.00,NULL,'2021-05-15 18:09:44','2021-05-15 18:09:44',NULL),(111,3687,39,40720,1533,3,217,1,6768.31,NULL,'2021-05-15 18:10:53','2021-05-15 18:57:27','2021-05-15 18:57:27'),(112,3687,39,40720,1533,3,68,1,1827.44,NULL,'2021-05-15 18:10:53','2021-05-15 18:57:27','2021-05-15 18:57:27'),(113,3687,39,40720,1533,3,217,1,300.00,NULL,'2021-05-15 18:10:53','2021-05-15 18:57:27','2021-05-15 18:57:27'),(114,3687,39,40720,1533,3,68,1,63.00,NULL,'2021-05-15 18:10:53','2021-05-15 18:57:27','2021-05-15 18:57:27'),(115,3687,39,40720,1533,3,217,1,340.43,NULL,'2021-05-15 18:10:53','2021-05-15 18:57:27','2021-05-15 18:57:27'),(116,3687,39,40720,1533,3,57,2,9299.18,NULL,'2021-05-15 18:10:53','2021-05-15 18:57:27','2021-05-15 18:57:27'),(117,3687,40,40720,1533,3,217,1,2781.67,NULL,'2021-05-15 18:18:25','2021-05-15 19:06:59','2021-05-15 19:06:59'),(118,3687,40,40720,1533,3,68,1,584.15,NULL,'2021-05-15 18:18:25','2021-05-15 19:06:59','2021-05-15 19:06:59'),(119,3687,40,40720,1533,3,217,1,74.17,NULL,'2021-05-15 18:18:25','2021-05-15 19:06:59','2021-05-15 19:06:59'),(120,3687,40,40720,1533,3,57,2,3439.99,NULL,'2021-05-15 18:18:25','2021-05-15 19:06:59','2021-05-15 19:06:59'),(121,3687,41,40720,1533,3,217,1,3286.56,NULL,'2021-05-15 18:22:25','2021-05-15 18:22:25',NULL),(122,3687,41,40720,1533,3,68,1,690.18,NULL,'2021-05-15 18:22:25','2021-05-15 18:22:25',NULL);
INSERT INTO `balance_libro_details` VALUES (123,3687,41,40720,1533,3,217,1,197.19,NULL,'2021-05-15 18:22:25','2021-05-15 18:22:25',NULL),(124,3687,41,40720,1533,3,226,1,98.60,NULL,'2021-05-15 18:22:25','2021-05-15 18:22:25',NULL),(125,3687,41,40720,1533,3,57,2,4272.53,NULL,'2021-05-15 18:22:25','2021-05-15 18:22:25',NULL),(126,3687,42,40720,1533,3,217,1,2006.70,NULL,'2021-05-15 18:29:58','2021-05-15 18:29:58',NULL),(127,3687,42,40720,1533,3,68,1,421.41,NULL,'2021-05-15 18:29:58','2021-05-15 18:29:58',NULL),(128,3687,42,40720,1533,3,217,1,671.86,NULL,'2021-05-15 18:29:58','2021-05-15 18:29:58',NULL),(129,3687,42,40720,1533,3,57,2,3099.97,NULL,'2021-05-15 18:29:58','2021-05-15 18:29:58',NULL),(130,3687,43,40720,1533,3,217,1,1659.05,NULL,'2021-05-15 18:32:08','2021-05-15 18:32:08',NULL),(131,3687,43,40720,1533,3,68,1,348.40,NULL,'2021-05-15 18:32:08','2021-05-15 18:32:08',NULL),(132,3687,43,40720,1533,3,57,2,2007.45,NULL,'2021-05-15 18:32:08','2021-05-15 18:32:08',NULL),(133,3687,44,40720,1533,3,217,1,1359.94,NULL,'2021-05-15 18:35:46','2021-05-15 18:35:46',NULL),(134,3687,44,40720,1533,3,68,1,285.59,NULL,'2021-05-15 18:35:46','2021-05-15 18:35:46',NULL),(135,3687,44,40720,1533,3,217,1,354.47,NULL,'2021-05-15 18:35:46','2021-05-15 18:35:46',NULL),(136,3687,44,40720,1533,3,57,2,2000.00,NULL,'2021-05-15 18:35:46','2021-05-15 18:35:46',NULL),(137,3687,45,40720,1533,3,217,1,679.97,NULL,'2021-05-15 18:38:19','2021-05-15 18:38:19',NULL),(138,3687,45,40720,1533,3,68,1,142.79,NULL,'2021-05-15 18:38:19','2021-05-15 18:38:19',NULL),(139,3687,45,40720,1533,3,217,1,177.24,NULL,'2021-05-15 18:38:19','2021-05-15 18:38:19',NULL),(140,3687,45,40720,1533,3,57,2,1000.00,NULL,'2021-05-15 18:38:19','2021-05-15 18:38:19',NULL),(141,3687,46,40720,1533,3,217,1,1239.67,NULL,'2021-05-15 18:40:37','2021-05-15 18:40:37',NULL),(142,3687,46,40720,1533,3,68,1,260.33,NULL,'2021-05-15 18:40:37','2021-05-15 18:40:37',NULL),(143,3687,46,40720,1533,3,57,2,1500.00,NULL,'2021-05-15 18:40:37','2021-05-15 18:40:37',NULL),(144,3687,47,40720,1533,3,217,1,3928.48,NULL,'2021-05-15 18:45:55','2021-05-15 18:45:55',NULL),(145,3687,47,40720,1533,3,68,1,824.98,NULL,'2021-05-15 18:45:55','2021-05-15 18:45:55',NULL),(146,3687,47,40720,1533,3,217,1,5644.86,NULL,'2021-05-15 18:45:55','2021-05-15 18:45:55',NULL),(147,3687,47,40720,1533,3,68,1,592.71,NULL,'2021-05-15 18:45:55','2021-05-15 18:45:55',NULL),(148,3687,47,40720,1533,3,57,2,10991.03,NULL,'2021-05-15 18:45:55','2021-05-15 18:45:55',NULL),(149,3687,48,40720,1533,3,217,1,5644.90,NULL,'2021-05-15 18:48:14','2021-05-15 18:48:14',NULL),(150,3687,48,40720,1533,3,68,1,592.71,NULL,'2021-05-15 18:48:14','2021-05-15 18:48:14',NULL),(151,3687,48,40720,1533,3,57,2,6237.61,NULL,'2021-05-15 18:48:14','2021-05-15 18:48:14',NULL),(152,3687,49,40720,1533,3,217,1,475.15,NULL,'2021-05-15 18:49:21','2021-05-15 18:49:21',NULL),(153,3687,49,40720,1533,3,68,1,99.78,NULL,'2021-05-15 18:49:21','2021-05-15 18:49:21',NULL),(154,3687,49,40720,1533,3,57,2,574.93,NULL,'2021-05-15 18:49:21','2021-05-15 18:49:21',NULL),(155,3687,50,40720,1533,3,217,1,1949.00,NULL,'2021-05-15 18:52:23','2021-05-15 18:52:23',NULL),(156,3687,50,40720,1533,3,68,1,409.29,NULL,'2021-05-15 18:52:23','2021-05-15 18:52:23',NULL),(157,3687,50,40720,1533,3,217,1,17119.61,NULL,'2021-05-15 18:52:23','2021-05-15 18:52:23',NULL),(158,3687,50,40720,1533,3,225,1,8432.04,NULL,'2021-05-15 18:52:23','2021-05-15 18:52:23',NULL),(159,3687,50,40720,1533,3,57,2,27909.94,NULL,'2021-05-15 18:52:23','2021-05-15 18:52:23',NULL),(160,3687,51,40720,1533,3,217,1,668.31,NULL,'2021-05-15 18:57:27','2021-05-15 18:57:59','2021-05-15 18:57:59'),(161,3687,51,40720,1533,3,68,1,180.44,NULL,'2021-05-15 18:57:27','2021-05-15 18:57:59','2021-05-15 18:57:59'),(162,3687,51,40720,1533,3,217,1,300.00,NULL,'2021-05-15 18:57:27','2021-05-15 18:57:59','2021-05-15 18:57:59'),(163,3687,51,40720,1533,3,68,1,63.00,NULL,'2021-05-15 18:57:27','2021-05-15 18:57:59','2021-05-15 18:57:59');
INSERT INTO `balance_libro_details` VALUES (164,3687,51,40720,1533,3,217,1,340.43,NULL,'2021-05-15 18:57:27','2021-05-15 18:57:59','2021-05-15 18:57:59'),(165,3687,51,40720,1533,3,225,1,203.05,NULL,'2021-05-15 18:57:27','2021-05-15 18:57:59','2021-05-15 18:57:59'),(166,3687,51,40720,1533,3,57,2,1755.23,NULL,'2021-05-15 18:57:27','2021-05-15 18:57:59','2021-05-15 18:57:59'),(167,3687,52,40720,1533,3,217,1,6468.31,NULL,'2021-05-15 18:57:59','2021-05-15 18:57:59',NULL),(168,3687,52,40720,1533,3,68,1,1746.44,NULL,'2021-05-15 18:57:59','2021-05-15 18:57:59',NULL),(169,3687,52,40720,1533,3,217,1,300.00,NULL,'2021-05-15 18:57:59','2021-05-15 18:57:59',NULL),(170,3687,52,40720,1533,3,68,1,63.00,NULL,'2021-05-15 18:57:59','2021-05-15 18:57:59',NULL),(171,3687,52,40720,1533,3,217,1,340.43,NULL,'2021-05-15 18:57:59','2021-05-15 18:57:59',NULL),(172,3687,52,40720,1533,3,225,1,203.05,NULL,'2021-05-15 18:57:59','2021-05-15 18:57:59',NULL),(173,3687,52,40720,1533,3,57,2,9121.23,NULL,'2021-05-15 18:57:59','2021-05-15 18:57:59',NULL),(174,3687,53,40720,1533,3,217,1,2781.67,NULL,'2021-05-15 19:06:59','2021-05-15 19:08:45','2021-05-15 19:08:45'),(175,3687,53,40720,1533,3,68,1,584.15,NULL,'2021-05-15 19:06:59','2021-05-15 19:08:45','2021-05-15 19:08:45'),(176,3687,53,40720,1533,3,217,1,74.17,NULL,'2021-05-15 19:06:59','2021-05-15 19:08:45','2021-05-15 19:08:45'),(177,3687,53,40720,1533,3,57,2,3439.99,NULL,'2021-05-15 19:06:59','2021-05-15 19:08:45','2021-05-15 19:08:45'),(178,3687,54,40720,1533,3,217,1,2781.67,NULL,'2021-05-15 19:08:45','2021-05-15 22:52:50','2021-05-15 22:52:50'),(179,3687,54,40720,1533,3,68,1,584.15,NULL,'2021-05-15 19:08:45','2021-05-15 22:52:50','2021-05-15 22:52:50'),(180,3687,54,40720,1533,3,217,1,74.17,NULL,'2021-05-15 19:08:45','2021-05-15 22:52:50','2021-05-15 22:52:50'),(181,3687,54,40720,1533,3,57,2,3439.99,NULL,'2021-05-15 19:08:45','2021-05-15 22:52:50','2021-05-15 22:52:50'),(182,3687,55,40720,1533,3,250,1,56276.00,NULL,'2021-05-15 19:14:47','2021-05-15 19:14:47',NULL),(183,3687,55,40720,1533,3,57,2,56276.00,NULL,'2021-05-15 19:14:47','2021-05-15 19:14:47',NULL),(184,3687,56,40720,1533,3,217,1,2781.67,NULL,'2021-05-15 22:52:50','2021-05-15 22:52:50',NULL),(185,3687,56,40720,1533,3,68,1,584.15,NULL,'2021-05-15 22:52:50','2021-05-15 22:52:50',NULL),(186,3687,56,40720,1533,3,217,1,74.17,NULL,'2021-05-15 22:52:50','2021-05-15 22:52:50',NULL),(187,3687,56,40720,1533,3,57,2,3439.99,NULL,'2021-05-15 22:52:50','2021-05-15 22:52:50',NULL),(188,3687,57,40720,1533,3,217,1,900.01,NULL,'2021-05-15 23:55:53','2021-05-15 23:55:53',NULL),(189,3687,57,40720,1533,3,57,2,900.01,NULL,'2021-05-15 23:55:53','2021-05-15 23:55:53',NULL),(190,3687,58,40720,1533,3,217,1,890.72,NULL,'2021-05-15 23:57:43','2021-05-15 23:57:43',NULL),(191,3687,58,40720,1533,3,68,1,240.49,NULL,'2021-05-15 23:57:43','2021-05-15 23:57:43',NULL),(192,3687,58,40720,1533,3,57,2,1131.21,NULL,'2021-05-15 23:57:43','2021-05-15 23:57:43',NULL),(193,3687,59,40720,1533,2,96,2,573719.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(194,3687,59,40720,1533,2,67,2,120480.99,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(195,3687,59,40720,1533,2,13,1,694200.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(196,3687,60,40720,1533,2,96,2,10822.50,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(197,3687,60,40720,1533,2,67,2,2272.73,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(198,3687,60,40720,1533,2,13,1,13095.23,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(199,3687,61,40720,1533,2,96,2,34661.24,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(200,3687,61,40720,1533,2,67,2,7278.86,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(201,3687,61,40720,1533,2,13,1,41940.10,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(202,3687,62,40720,1533,2,96,2,49881.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(203,3687,62,40720,1533,2,67,2,10475.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL);
INSERT INTO `balance_libro_details` VALUES (204,3687,62,40720,1533,2,13,1,60356.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(205,3687,63,40720,1533,2,96,2,33925.62,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(206,3687,63,40720,1533,2,67,2,7124.38,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(207,3687,63,40720,1533,2,13,1,41050.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(208,3687,64,40720,1533,2,96,2,24661.16,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(209,3687,64,40720,1533,2,67,2,5178.84,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(210,3687,64,40720,1533,2,13,1,29840.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(211,3687,65,40720,1533,2,96,2,24380.17,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(212,3687,65,40720,1533,2,67,2,5119.84,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(213,3687,65,40720,1533,2,13,1,29500.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(214,3687,66,40720,1533,2,96,1,37948.07,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(215,3687,66,40720,1533,2,68,1,7969.09,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(216,3687,66,40720,1533,2,13,2,45917.16,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(217,3687,67,40720,1533,2,96,2,45785.60,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(218,3687,67,40720,1533,2,67,2,9614.98,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(219,3687,67,40720,1533,2,13,1,55400.58,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(220,3687,68,40720,1533,2,96,2,95550.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(221,3687,68,40720,1533,2,67,2,20065.50,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(222,3687,68,40720,1533,2,13,1,115615.50,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(223,3687,69,40720,1533,2,96,2,36503.04,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(224,3687,69,40720,1533,2,67,2,7665.64,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(225,3687,69,40720,1533,2,13,1,44168.68,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(226,3687,70,40720,1533,2,96,2,1135.17,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(227,3687,70,40720,1533,2,67,2,238.39,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(228,3687,70,40720,1533,2,13,1,1373.56,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(229,3687,71,40720,1533,2,96,2,77257.32,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(230,3687,71,40720,1533,2,67,2,16224.04,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(231,3687,71,40720,1533,2,13,1,93481.36,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(232,3687,72,40720,1533,2,96,2,13257.25,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(233,3687,72,40720,1533,2,67,2,2784.02,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(234,3687,72,40720,1533,2,13,1,16041.27,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(235,3687,73,40720,1533,2,96,2,40042.80,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(236,3687,73,40720,1533,2,67,2,8408.99,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(237,3687,73,40720,1533,2,13,1,48451.79,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(238,3687,74,40720,1533,2,96,2,9808.58,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(239,3687,74,40720,1533,2,67,2,2059.80,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(240,3687,74,40720,1533,2,13,1,11868.38,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(241,3687,75,40720,1533,2,96,2,46428.48,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(242,3687,75,40720,1533,2,67,2,9749.98,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(243,3687,75,40720,1533,2,13,1,56178.46,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(244,3687,76,40720,1533,2,96,2,112337.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(245,3687,76,40720,1533,2,67,2,23590.77,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL);
INSERT INTO `balance_libro_details` VALUES (246,3687,76,40720,1533,2,13,1,135927.77,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(247,3687,77,40720,1533,2,96,2,7860.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(248,3687,77,40720,1533,2,67,2,1650.60,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(249,3687,77,40720,1533,2,13,1,9510.60,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(250,3687,78,40720,1533,2,96,2,25221.28,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(251,3687,78,40720,1533,2,67,2,5296.47,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(252,3687,78,40720,1533,2,13,1,30517.75,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(253,3687,79,40720,1533,2,96,2,18608.55,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(254,3687,79,40720,1533,2,67,2,3907.80,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(255,3687,79,40720,1533,2,13,1,22516.35,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(256,3687,80,40720,1533,2,96,2,28556.12,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(257,3687,80,40720,1533,2,67,2,5996.79,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(258,3687,80,40720,1533,2,13,1,34552.91,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(259,3687,81,40720,1533,2,96,2,25619.84,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(260,3687,81,40720,1533,2,67,2,5380.17,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(261,3687,81,40720,1533,2,13,1,31000.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(262,3687,82,40720,1533,2,96,2,5454.55,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(263,3687,82,40720,1533,2,67,2,1145.46,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(264,3687,82,40720,1533,2,13,1,6600.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(265,3687,83,40720,1533,2,96,2,367768.60,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(266,3687,83,40720,1533,2,67,2,77231.41,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(267,3687,83,40720,1533,2,13,1,445000.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(268,3687,84,40720,1533,2,96,2,336033.08,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(269,3687,84,40720,1533,2,67,2,70566.95,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(270,3687,84,40720,1533,2,13,1,406600.03,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(271,3687,85,40720,1533,2,96,2,13428.81,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(272,3687,85,40720,1533,2,67,2,2820.05,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(273,3687,85,40720,1533,2,13,1,16248.86,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(274,3687,86,40720,1533,2,96,2,16758.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(275,3687,86,40720,1533,2,67,2,3519.18,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(276,3687,86,40720,1533,2,13,1,20277.18,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(277,3687,87,40720,1533,2,96,2,70268.40,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(278,3687,87,40720,1533,2,67,2,14756.36,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(279,3687,87,40720,1533,2,13,1,85024.76,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(280,3687,88,40720,1533,2,96,2,15154.57,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(281,3687,88,40720,1533,2,67,2,3182.46,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(282,3687,88,40720,1533,2,13,1,18337.03,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(283,3687,89,40720,1533,2,96,2,42776.82,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(284,3687,89,40720,1533,2,67,2,8983.13,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(285,3687,89,40720,1533,2,13,1,51759.95,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(286,3687,90,40720,1533,2,96,2,35086.30,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(287,3687,90,40720,1533,2,67,2,7368.12,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL);
INSERT INTO `balance_libro_details` VALUES (288,3687,90,40720,1533,2,13,1,42454.42,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(289,3687,91,40720,1533,2,96,2,33589.71,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(290,3687,91,40720,1533,2,67,2,7053.84,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(291,3687,91,40720,1533,2,13,1,40643.55,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(292,3687,92,40720,1533,2,96,2,49689.94,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(293,3687,92,40720,1533,2,67,2,10434.89,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(294,3687,92,40720,1533,2,13,1,60124.83,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(295,3687,93,40720,1533,2,96,2,34667.51,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(296,3687,93,40720,1533,2,67,2,7280.18,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(297,3687,93,40720,1533,2,13,1,41947.69,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(298,3687,94,40720,1533,2,96,2,103359.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(299,3687,94,40720,1533,2,67,2,21705.39,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(300,3687,94,40720,1533,2,13,1,125064.39,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(301,3687,95,40720,1533,2,96,2,28595.05,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(302,3687,95,40720,1533,2,67,2,6004.96,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(303,3687,95,40720,1533,2,13,1,34600.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(304,3687,95,40720,1533,2,136,1,0.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(305,3687,96,40720,1533,2,96,2,23595.04,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(306,3687,96,40720,1533,2,67,2,4954.96,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(307,3687,96,40720,1533,2,13,1,28550.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(308,3687,97,40720,1533,2,96,2,51665.53,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(309,3687,97,40720,1533,2,67,2,10849.76,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(310,3687,97,40720,1533,2,13,1,62515.30,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(311,3687,97,40720,1533,2,136,2,0.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(312,3687,98,40720,1533,2,96,2,55583.95,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(313,3687,98,40720,1533,2,67,2,11672.63,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(314,3687,98,40720,1533,2,13,1,67256.58,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(315,3687,99,40720,1533,2,96,2,33421.70,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(316,3687,99,40720,1533,2,67,2,7018.56,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(317,3687,99,40720,1533,2,13,1,40440.26,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(318,3687,100,40720,1533,2,96,2,20760.36,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(319,3687,100,40720,1533,2,67,2,4359.68,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(320,3687,100,40720,1533,2,13,1,25120.04,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(321,3687,101,40720,1533,2,96,2,83962.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(322,3687,101,40720,1533,2,67,2,17632.02,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(323,3687,101,40720,1533,2,13,1,101594.02,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(324,3687,102,40720,1533,2,96,2,43572.65,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(325,3687,102,40720,1533,2,67,2,9150.26,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(326,3687,102,40720,1533,2,13,1,52722.91,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(327,3687,103,40720,1533,2,96,2,14442.75,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(328,3687,103,40720,1533,2,67,2,3032.98,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(329,3687,103,40720,1533,2,13,1,17475.73,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL);
INSERT INTO `balance_libro_details` VALUES (330,3687,104,40720,1533,2,96,2,204710.75,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(331,3687,104,40720,1533,2,67,2,42989.26,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(332,3687,104,40720,1533,2,13,1,247700.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(333,3687,105,40720,1533,2,96,2,13719.01,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(334,3687,105,40720,1533,2,67,2,2880.99,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(335,3687,105,40720,1533,2,13,1,16600.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(336,3687,106,40720,1533,2,96,2,51570.25,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(337,3687,106,40720,1533,2,67,2,10829.75,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(338,3687,106,40720,1533,2,13,1,62400.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(339,3687,107,40720,1533,2,96,2,115738.50,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(340,3687,107,40720,1533,2,67,2,24305.09,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(341,3687,107,40720,1533,2,13,1,140043.59,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(342,3687,108,40720,1533,2,96,2,932.23,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(343,3687,108,40720,1533,2,67,2,195.77,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(344,3687,108,40720,1533,2,13,1,1128.00,NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(345,3687,109,40720,1530,3,217,1,122393.19,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(346,3687,109,40720,1530,3,68,1,25702.57,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(347,3687,109,40720,1530,3,57,2,148095.76,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(348,3687,110,40720,1530,3,217,1,29003.78,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(349,3687,110,40720,1530,3,68,1,6090.79,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(350,3687,110,40720,1530,3,57,2,35094.57,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(351,3687,111,40720,1530,3,217,1,3080.23,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(352,3687,111,40720,1530,3,68,1,646.84,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(353,3687,111,40720,1530,3,57,2,3727.07,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(354,3687,112,40720,1530,3,217,1,1161.98,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(355,3687,112,40720,1530,3,68,1,244.02,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(356,3687,112,40720,1530,3,57,2,1406.00,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(357,3687,113,40720,1530,3,217,1,317547.48,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(358,3687,113,40720,1530,3,68,1,66684.97,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(359,3687,113,40720,1530,3,57,2,384232.45,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(360,3687,114,40720,1530,3,217,1,910.74,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(361,3687,114,40720,1530,3,68,1,191.26,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(362,3687,114,40720,1530,3,57,2,1102.00,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(363,3687,115,40720,1530,3,217,1,3955.20,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(364,3687,115,40720,1530,3,68,1,1067.90,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(365,3687,115,40720,1530,3,217,1,326.83,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(366,3687,115,40720,1530,3,57,2,5349.93,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(367,3687,116,40720,1530,3,217,1,6628.53,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(368,3687,116,40720,1530,3,68,1,1391.99,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(369,3687,116,40720,1530,3,57,2,8020.52,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(370,3687,117,40720,1530,3,250,1,2000.00,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL);
INSERT INTO `balance_libro_details` VALUES (371,3687,117,40720,1530,3,57,2,2000.00,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(372,3687,118,40720,1530,3,217,1,1939.99,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(373,3687,118,40720,1530,3,68,1,407.40,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(374,3687,118,40720,1530,3,57,2,2347.39,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(375,3687,119,40720,1530,3,217,1,27624.43,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(376,3687,119,40720,1530,3,68,1,2900.57,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(377,3687,119,40720,1530,3,57,2,30525.00,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(378,3687,120,40720,1530,3,217,1,23467.46,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(379,3687,120,40720,1530,3,68,1,4928.17,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(380,3687,120,40720,1530,3,57,2,28395.63,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(381,3687,121,40720,1530,3,250,1,1154.00,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(382,3687,121,40720,1530,3,57,2,1154.00,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(383,3687,122,40720,1530,3,217,1,197204.70,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(384,3687,122,40720,1530,3,68,1,41412.99,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(385,3687,122,40720,1530,3,57,2,238617.69,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(386,3687,123,40720,1530,3,217,1,950.00,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(387,3687,123,40720,1530,3,68,1,99.75,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(388,3687,123,40720,1530,3,57,2,1049.75,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(389,3687,124,40720,1530,3,217,1,22414.40,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(390,3687,124,40720,1530,3,68,1,4707.02,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(391,3687,124,40720,1530,3,57,2,27121.42,NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(392,3687,125,40720,1531,3,217,1,1347.11,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(393,3687,125,40720,1531,3,68,1,282.89,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(394,3687,125,40720,1531,3,57,2,1630.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(395,3687,126,40720,1531,3,250,1,80000.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(396,3687,126,40720,1531,3,57,2,80000.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(397,3687,127,40720,1531,3,250,1,6900.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(398,3687,127,40720,1531,3,57,2,6900.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(399,3687,128,40720,1531,3,217,1,336794.76,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(400,3687,128,40720,1531,3,68,1,70726.90,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(401,3687,128,40720,1531,3,57,2,407521.66,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(402,3687,129,40720,1531,3,217,1,499968.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(403,3687,129,40720,1531,3,68,1,104993.28,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(404,3687,129,40720,1531,3,57,2,604961.28,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(405,3687,130,40720,1531,3,217,1,15000.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(406,3687,130,40720,1531,3,68,1,3150.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(407,3687,130,40720,1531,3,57,2,18150.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(408,3687,131,40720,1531,3,217,1,687190.91,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(409,3687,131,40720,1531,3,68,1,144310.09,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(410,3687,131,40720,1531,3,57,2,831501.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(411,3687,132,40720,1531,3,217,1,15248.93,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL);
INSERT INTO `balance_libro_details` VALUES (412,3687,132,40720,1531,3,68,1,3202.27,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(413,3687,132,40720,1531,3,57,2,18451.20,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(414,3687,133,40720,1531,3,217,2,15000.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(415,3687,133,40720,1531,3,67,2,3150.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(416,3687,133,40720,1531,3,57,1,18150.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(417,3687,134,40720,1531,3,217,1,15000.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(418,3687,134,40720,1531,3,68,1,3150.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(419,3687,134,40720,1531,3,57,2,18150.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(420,3687,135,40720,1531,3,217,1,140669.44,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(421,3687,135,40720,1531,3,68,1,29540.58,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(422,3687,135,40720,1531,3,57,2,170210.02,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(423,3687,136,40720,1531,3,250,1,0.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(424,3687,136,40720,1531,3,250,1,394877.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(425,3687,136,40720,1531,3,57,2,394877.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(426,3687,137,40720,1531,3,217,1,948450.32,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(427,3687,137,40720,1531,3,68,1,199174.57,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(428,3687,137,40720,1531,3,57,2,1147624.89,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(429,3687,138,40720,1531,3,217,1,382682.35,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(430,3687,138,40720,1531,3,68,1,80363.29,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(431,3687,138,40720,1531,3,57,2,463045.64,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(432,3687,139,40720,1531,3,217,1,82418.26,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(433,3687,139,40720,1531,3,68,1,17307.83,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(434,3687,139,40720,1531,3,57,2,99726.09,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(435,3687,140,40720,1531,3,217,1,555614.34,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(436,3687,140,40720,1531,3,68,1,116679.01,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(437,3687,140,40720,1531,3,57,2,672293.35,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(438,3687,141,40720,1531,3,217,1,52261.15,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(439,3687,141,40720,1531,3,68,1,6915.11,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(440,3687,141,40720,1531,3,57,2,59176.26,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(441,3687,142,40720,1531,3,217,1,11518.53,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(442,3687,142,40720,1531,3,68,1,2278.31,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(443,3687,142,40720,1531,3,57,2,13796.84,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(444,3687,143,40720,1531,3,217,1,912.07,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(445,3687,143,40720,1531,3,68,1,191.53,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(446,3687,143,40720,1531,3,57,2,1103.60,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(447,3687,144,40720,1531,3,217,1,558687.98,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(448,3687,144,40720,1531,3,68,1,117324.48,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(449,3687,144,40720,1531,3,57,2,676012.46,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(450,3687,145,40720,1531,3,217,1,3923.83,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(451,3687,145,40720,1531,3,68,1,1059.43,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(452,3687,145,40720,1531,3,217,1,324.23,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL);
INSERT INTO `balance_libro_details` VALUES (453,3687,145,40720,1531,3,57,2,5307.49,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(454,3687,146,40720,1531,3,217,1,76525.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(455,3687,146,40720,1531,3,68,1,16070.25,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(456,3687,146,40720,1531,3,57,2,92595.25,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(457,3687,147,40720,1531,3,217,1,204357.74,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(458,3687,147,40720,1531,3,68,1,42915.13,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(459,3687,147,40720,1531,3,57,2,247272.87,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(460,3687,148,40720,1531,3,217,1,27624.43,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(461,3687,148,40720,1531,3,68,1,2900.57,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(462,3687,148,40720,1531,3,57,2,30525.00,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(463,3687,149,40720,1531,3,217,1,29787.55,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(464,3687,149,40720,1531,3,68,1,6255.38,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(465,3687,149,40720,1531,3,57,2,36042.93,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(466,3687,150,40720,1531,3,217,1,3209.60,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(467,3687,150,40720,1531,3,68,1,674.02,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(468,3687,150,40720,1531,3,57,2,3883.62,NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(584,3687,186,40720,1530,2,96,2,79769.25,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(585,3687,186,40720,1530,2,67,2,16751.54,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(586,3687,186,40720,1530,2,13,1,96520.79,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(587,3687,187,40720,1530,2,96,2,31571.20,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(588,3687,187,40720,1530,2,67,2,6629.95,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(589,3687,187,40720,1530,2,13,1,38201.15,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(590,3687,188,40720,1530,2,96,2,35785.12,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(591,3687,188,40720,1530,2,67,2,7514.87,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(592,3687,188,40720,1530,2,13,1,43299.99,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(593,3687,189,40720,1530,2,96,2,190357.20,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(594,3687,189,40720,1530,2,67,2,39975.01,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(595,3687,189,40720,1530,2,13,1,230332.21,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(596,3687,190,40720,1530,2,96,2,10122.45,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(597,3687,190,40720,1530,2,67,2,2125.71,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(598,3687,190,40720,1530,2,13,1,12248.16,NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(599,3687,191,40720,1530,2,96,2,100605.00,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(600,3687,191,40720,1530,2,67,2,21127.05,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(601,3687,191,40720,1530,2,13,1,121732.05,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(602,3687,192,40720,1530,2,96,2,2895.80,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(603,3687,192,40720,1530,2,67,2,608.12,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(604,3687,192,40720,1530,2,13,1,3503.92,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(605,3687,193,40720,1530,2,96,2,87292.93,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(606,3687,193,40720,1530,2,67,2,18331.52,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(607,3687,193,40720,1530,2,13,1,105624.45,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(608,3687,194,40720,1530,2,96,2,255388.39,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL);
INSERT INTO `balance_libro_details` VALUES (609,3687,194,40720,1530,2,67,2,53631.56,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(610,3687,194,40720,1530,2,13,1,309019.95,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(611,3687,195,40720,1530,2,96,2,92873.04,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(612,3687,195,40720,1530,2,67,2,19503.34,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(613,3687,195,40720,1530,2,13,1,112376.38,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(614,3687,196,40720,1530,2,96,2,66429.75,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(615,3687,196,40720,1530,2,67,2,13950.25,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(616,3687,196,40720,1530,2,13,1,80380.00,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(617,3687,197,40720,1530,2,96,2,18244.82,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(618,3687,197,40720,1530,2,67,2,3831.41,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(619,3687,197,40720,1530,2,13,1,22076.23,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(620,3687,198,40720,1530,2,96,2,9740.00,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(621,3687,198,40720,1530,2,67,2,2045.40,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(622,3687,198,40720,1530,2,13,1,11785.40,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(623,3687,199,40720,1530,2,96,2,295578.06,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(624,3687,199,40720,1530,2,67,2,62071.39,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(625,3687,199,40720,1530,2,13,1,357649.45,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(626,3687,200,40720,1530,2,96,2,5383.68,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(627,3687,200,40720,1530,2,67,2,1130.57,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(628,3687,200,40720,1530,2,13,1,6514.25,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(629,3687,201,40720,1530,2,96,2,13910.00,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(630,3687,201,40720,1530,2,67,2,2921.10,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(631,3687,201,40720,1530,2,13,1,16831.10,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(632,3687,202,40720,1530,2,96,1,1447.90,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(633,3687,202,40720,1530,2,68,1,304.06,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(634,3687,202,40720,1530,2,13,2,1751.96,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(635,3687,203,40720,1530,2,96,2,46907.50,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(636,3687,203,40720,1530,2,67,2,9850.58,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(637,3687,203,40720,1530,2,13,1,56758.08,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(638,3687,204,40720,1530,2,96,2,5764.50,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(639,3687,204,40720,1530,2,67,2,1210.55,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(640,3687,204,40720,1530,2,13,1,6975.05,NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(641,3687,205,40720,1531,2,96,2,58132.62,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(642,3687,205,40720,1531,2,67,2,12207.85,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(643,3687,205,40720,1531,2,13,1,70340.47,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(644,3687,206,40720,1531,2,96,2,194101.77,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(645,3687,206,40720,1531,2,67,2,40761.37,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(646,3687,206,40720,1531,2,13,1,234863.14,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(647,3687,207,40720,1531,2,96,2,119567.80,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(648,3687,207,40720,1531,2,67,2,25109.24,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(649,3687,207,40720,1531,2,13,1,144677.04,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL);
INSERT INTO `balance_libro_details` VALUES (650,3687,208,40720,1531,2,96,2,94362.00,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(651,3687,208,40720,1531,2,67,2,19816.02,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(652,3687,208,40720,1531,2,13,1,114178.02,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(653,3687,209,40720,1531,2,96,2,10948.00,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(654,3687,209,40720,1531,2,67,2,2299.08,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(655,3687,209,40720,1531,2,13,1,13247.08,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(656,3687,210,40720,1531,2,96,2,108082.90,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(657,3687,210,40720,1531,2,67,2,22697.41,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(658,3687,210,40720,1531,2,13,1,130780.31,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(659,3687,211,40720,1531,2,96,1,1149.02,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(660,3687,211,40720,1531,2,68,1,241.29,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(661,3687,211,40720,1531,2,13,2,1390.31,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(662,3687,212,40720,1531,2,96,2,9421.50,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(663,3687,212,40720,1531,2,67,2,1978.52,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(664,3687,212,40720,1531,2,13,1,11400.02,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(665,3687,213,40720,1531,2,96,2,16909.63,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(666,3687,213,40720,1531,2,67,2,3551.02,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(667,3687,213,40720,1531,2,13,1,20460.65,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(668,3687,214,40720,1531,2,96,2,92379.00,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(669,3687,214,40720,1531,2,67,2,19399.59,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(670,3687,214,40720,1531,2,13,1,111778.59,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(671,3687,215,40720,1531,2,96,2,23421.49,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(672,3687,215,40720,1531,2,67,2,4918.51,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(673,3687,215,40720,1531,2,13,1,28340.00,NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(674,3687,216,40720,1531,2,96,2,7469.33,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(675,3687,216,40720,1531,2,67,2,1568.56,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(676,3687,216,40720,1531,2,13,1,9037.89,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(677,3687,217,40720,1531,2,96,2,266400.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(678,3687,217,40720,1531,2,67,2,55944.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(679,3687,217,40720,1531,2,13,1,322344.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(680,3687,218,40720,1531,2,96,2,266400.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(681,3687,218,40720,1531,2,67,2,55944.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(682,3687,218,40720,1531,2,13,1,322344.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(683,3687,219,40720,1531,2,96,1,266400.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(684,3687,219,40720,1531,2,68,1,55944.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(685,3687,219,40720,1531,2,13,2,322344.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(686,3687,220,40720,1531,2,96,1,16909.63,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(687,3687,220,40720,1531,2,68,1,3551.02,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(688,3687,220,40720,1531,2,13,2,20460.65,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(689,3687,221,40720,1531,2,96,2,2611.10,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(690,3687,221,40720,1531,2,67,2,548.33,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL);
INSERT INTO `balance_libro_details` VALUES (691,3687,221,40720,1531,2,13,1,3159.43,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(692,3687,222,40720,1531,2,96,2,295998.79,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(693,3687,222,40720,1531,2,67,2,62159.75,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(694,3687,222,40720,1531,2,13,1,358158.54,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(695,3687,223,40720,1531,2,96,2,137059.76,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(696,3687,223,40720,1531,2,67,2,28782.55,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(697,3687,223,40720,1531,2,13,1,165842.31,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(698,3687,224,40720,1531,2,96,2,118884.88,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(699,3687,224,40720,1531,2,67,2,24965.82,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(700,3687,224,40720,1531,2,13,1,143850.70,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(701,3687,225,40720,1531,2,96,2,2572.80,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(702,3687,225,40720,1531,2,67,2,540.29,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(703,3687,225,40720,1531,2,13,1,3113.09,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(704,3687,226,40720,1531,2,96,2,52892.56,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(705,3687,226,40720,1531,2,67,2,11107.44,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(706,3687,226,40720,1531,2,13,1,64000.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(707,3687,227,40720,1531,2,96,2,11745.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(708,3687,227,40720,1531,2,67,2,2466.45,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(709,3687,227,40720,1531,2,13,1,14211.45,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(710,3687,228,40720,1531,2,96,2,77148.76,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(711,3687,228,40720,1531,2,67,2,16201.24,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(712,3687,228,40720,1531,2,13,1,93350.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(713,3687,229,40720,1531,2,96,2,51528.93,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(714,3687,229,40720,1531,2,67,2,10821.08,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(715,3687,229,40720,1531,2,13,1,62350.01,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(716,3687,230,40720,1531,2,96,2,182933.89,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(717,3687,230,40720,1531,2,67,2,38416.12,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(718,3687,230,40720,1531,2,13,1,221350.01,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(719,3687,231,40720,1531,2,96,2,17015.63,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(720,3687,231,40720,1531,2,67,2,3573.28,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(721,3687,231,40720,1531,2,13,1,20588.91,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(722,3687,232,40720,1531,2,96,2,41085.94,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(723,3687,232,40720,1531,2,67,2,8628.05,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(724,3687,232,40720,1531,2,13,1,49713.99,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(725,3687,233,40720,1531,2,96,2,55265.64,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(726,3687,233,40720,1531,2,67,2,11605.78,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(727,3687,233,40720,1531,2,13,1,66871.42,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(728,3687,234,40720,1531,2,96,2,19440.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(729,3687,234,40720,1531,2,67,2,4082.40,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(730,3687,234,40720,1531,2,13,1,23522.40,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(731,3687,235,40720,1531,2,96,2,38641.64,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL);
INSERT INTO `balance_libro_details` VALUES (732,3687,235,40720,1531,2,67,2,8114.74,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(733,3687,235,40720,1531,2,13,1,46756.38,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(734,3687,236,40720,1531,2,96,2,21735.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(735,3687,236,40720,1531,2,67,2,4564.35,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(736,3687,236,40720,1531,2,13,1,26299.35,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(737,3687,237,40720,1531,2,96,2,45225.01,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(738,3687,237,40720,1531,2,67,2,9497.25,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(739,3687,237,40720,1531,2,13,1,54722.26,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(740,3687,238,40720,1531,2,96,2,17206.88,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(741,3687,238,40720,1531,2,67,2,3613.44,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(742,3687,238,40720,1531,2,13,1,20820.32,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(743,3687,239,40720,1531,2,96,2,42121.30,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(744,3687,239,40720,1531,2,67,2,8845.47,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(745,3687,239,40720,1531,2,13,1,50966.77,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(746,3687,240,40720,1531,2,96,2,150260.43,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(747,3687,240,40720,1531,2,67,2,31554.69,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(748,3687,240,40720,1531,2,13,1,181815.12,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(749,3687,241,40720,1531,2,96,2,14784.50,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(750,3687,241,40720,1531,2,67,2,3104.75,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(751,3687,241,40720,1531,2,13,1,17889.25,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(752,3687,242,40720,1531,2,218,2,0.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(753,3687,242,40720,1531,2,218,2,394877.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(754,3687,242,40720,1531,2,13,1,394877.00,NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(755,3687,243,40720,1532,2,96,2,283380.17,NULL,'2021-05-16 12:19:28','2021-05-16 12:19:28',NULL),(756,3687,243,40720,1532,2,67,2,59509.84,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(757,3687,243,40720,1532,2,13,1,342890.01,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(758,3687,244,40720,1532,2,96,2,83378.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(759,3687,244,40720,1532,2,67,2,17509.38,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(760,3687,244,40720,1532,2,13,1,100887.38,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(761,3687,245,40720,1532,2,96,2,5685.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(762,3687,245,40720,1532,2,67,2,1193.85,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(763,3687,245,40720,1532,2,13,1,6878.85,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(764,3687,246,40720,1532,2,96,2,54206.62,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(765,3687,246,40720,1532,2,67,2,11383.39,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(766,3687,246,40720,1532,2,13,1,65590.01,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(767,3687,247,40720,1532,2,96,2,69792.85,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(768,3687,247,40720,1532,2,67,2,14656.50,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(769,3687,247,40720,1532,2,13,1,84449.35,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(770,3687,248,40720,1532,2,96,2,24849.14,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(771,3687,248,40720,1532,2,67,2,5218.32,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(772,3687,248,40720,1532,2,13,1,30067.46,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL);
INSERT INTO `balance_libro_details` VALUES (773,3687,249,40720,1532,2,96,2,18305.70,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(774,3687,249,40720,1532,2,67,2,3844.20,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(775,3687,249,40720,1532,2,13,1,22149.90,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(776,3687,250,40720,1532,2,96,2,148909.10,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(777,3687,250,40720,1532,2,67,2,31270.91,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(778,3687,250,40720,1532,2,13,1,180180.01,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(779,3687,251,40720,1532,2,96,2,159329.70,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(780,3687,251,40720,1532,2,67,2,33459.24,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(781,3687,251,40720,1532,2,13,1,192788.94,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(782,3687,252,40720,1532,2,96,2,103614.81,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(783,3687,252,40720,1532,2,67,2,21759.11,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(784,3687,252,40720,1532,2,13,1,125373.92,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(785,3687,253,40720,1532,2,96,2,48011.24,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(786,3687,253,40720,1532,2,67,2,10082.36,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(787,3687,253,40720,1532,2,13,1,58093.60,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(788,3687,254,40720,1532,2,96,2,117425.70,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(789,3687,254,40720,1532,2,67,2,24659.40,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(790,3687,254,40720,1532,2,13,1,142085.10,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(791,3687,255,40720,1532,2,96,2,258150.16,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(792,3687,255,40720,1532,2,67,2,54211.53,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(793,3687,255,40720,1532,2,13,1,312361.69,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(794,3687,256,40720,1532,2,96,2,50355.27,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(795,3687,256,40720,1532,2,67,2,10574.61,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(796,3687,256,40720,1532,2,13,1,60929.88,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(797,3687,257,40720,1532,2,96,2,124387.80,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(798,3687,257,40720,1532,2,67,2,26121.44,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(799,3687,257,40720,1532,2,13,1,150509.24,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(800,3687,258,40720,1532,2,96,2,47754.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(801,3687,258,40720,1532,2,67,2,10028.34,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(802,3687,258,40720,1532,2,13,1,57782.34,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(803,3687,259,40720,1532,2,96,2,15661.16,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(804,3687,259,40720,1532,2,67,2,3288.84,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(805,3687,259,40720,1532,2,13,1,18950.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(806,3687,260,40720,1532,2,96,2,60904.34,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(807,3687,260,40720,1532,2,67,2,12789.91,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(808,3687,260,40720,1532,2,13,1,73694.25,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(809,3687,261,40720,1532,2,96,2,53223.75,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(810,3687,261,40720,1532,2,67,2,11176.99,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(811,3687,261,40720,1532,2,13,1,64400.74,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(812,3687,262,40720,1532,2,218,2,0.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(813,3687,262,40720,1532,2,13,1,0.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL);
INSERT INTO `balance_libro_details` VALUES (814,3687,263,40720,1532,2,96,2,25252.05,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(815,3687,263,40720,1532,2,67,2,5302.93,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(816,3687,263,40720,1532,2,13,1,30554.98,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(817,3687,264,40720,1532,2,96,2,12101.81,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(818,3687,264,40720,1532,2,67,2,2541.38,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(819,3687,264,40720,1532,2,13,1,14643.19,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(820,3687,265,40720,1532,2,96,2,96957.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(821,3687,265,40720,1532,2,67,2,20360.97,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(822,3687,265,40720,1532,2,13,1,117317.97,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(823,3687,266,40720,1532,2,96,2,25862.80,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(824,3687,266,40720,1532,2,67,2,5431.19,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(825,3687,266,40720,1532,2,13,1,31293.99,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(826,3687,267,40720,1532,2,96,2,750.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(827,3687,267,40720,1532,2,67,2,157.50,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(828,3687,267,40720,1532,2,218,2,45000.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(829,3687,267,40720,1532,2,13,1,45907.50,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(830,3687,268,40720,1532,2,96,1,96957.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(831,3687,268,40720,1532,2,68,1,20360.97,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(832,3687,268,40720,1532,2,13,2,117317.97,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(833,3687,269,40720,1532,2,96,2,19883.10,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(834,3687,269,40720,1532,2,67,2,4175.45,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(835,3687,269,40720,1532,2,13,1,24058.55,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(836,3687,270,40720,1532,2,96,2,64173.55,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(837,3687,270,40720,1532,2,67,2,13476.45,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(838,3687,270,40720,1532,2,13,1,77650.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(839,3687,271,40720,1532,2,96,2,27375.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(840,3687,271,40720,1532,2,67,2,5748.75,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(841,3687,271,40720,1532,2,13,1,33123.75,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(842,3687,272,40720,1532,2,96,2,27355.37,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(843,3687,272,40720,1532,2,67,2,5744.63,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(844,3687,272,40720,1532,2,13,1,33100.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(845,3687,273,40720,1532,2,96,2,18498.90,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(846,3687,273,40720,1532,2,67,2,3884.77,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(847,3687,273,40720,1532,2,13,1,22383.67,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(848,3687,274,40720,1532,2,96,2,66541.46,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(849,3687,274,40720,1532,2,67,2,13973.71,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(850,3687,274,40720,1532,2,13,1,80515.17,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(851,3687,275,40720,1532,2,96,2,59075.83,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(852,3687,275,40720,1532,2,67,2,12405.92,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(853,3687,275,40720,1532,2,13,1,71481.75,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(854,3687,276,40720,1532,2,96,2,60838.84,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL);
INSERT INTO `balance_libro_details` VALUES (855,3687,276,40720,1532,2,67,2,12776.16,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(856,3687,276,40720,1532,2,13,1,73615.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(857,3687,277,40720,1532,2,96,2,19092.15,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(858,3687,277,40720,1532,2,67,2,4009.35,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(859,3687,277,40720,1532,2,13,1,23101.50,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(860,3687,278,40720,1532,2,96,2,153805.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(861,3687,278,40720,1532,2,67,2,32299.05,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(862,3687,278,40720,1532,2,13,1,186104.05,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(863,3687,279,40720,1532,2,96,2,51652.89,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(864,3687,279,40720,1532,2,67,2,10847.11,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(865,3687,279,40720,1532,2,13,1,62500.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(866,3687,280,40720,1532,2,96,2,33223.01,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(867,3687,280,40720,1532,2,67,2,6976.83,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(868,3687,280,40720,1532,2,13,1,40199.84,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(869,3687,281,40720,1532,2,96,2,110066.94,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(870,3687,281,40720,1532,2,67,2,23114.06,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(871,3687,281,40720,1532,2,13,1,133181.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(872,3687,282,40720,1532,2,96,2,23884.30,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(873,3687,282,40720,1532,2,67,2,5015.70,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(874,3687,282,40720,1532,2,13,1,28900.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(875,3687,283,40720,1532,2,96,2,19008.26,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(876,3687,283,40720,1532,2,67,2,3991.74,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(877,3687,283,40720,1532,2,13,1,23000.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(878,3687,284,40720,1532,2,96,2,99586.78,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(879,3687,284,40720,1532,2,67,2,20913.22,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(880,3687,284,40720,1532,2,13,1,120500.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(881,3687,285,40720,1532,2,96,2,19297.52,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(882,3687,285,40720,1532,2,67,2,4052.48,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(883,3687,285,40720,1532,2,13,1,23350.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(884,3687,286,40720,1532,2,96,2,130082.65,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(885,3687,286,40720,1532,2,67,2,27317.36,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(886,3687,286,40720,1532,2,13,1,157400.01,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(887,3687,287,40720,1532,2,96,2,58661.46,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(888,3687,287,40720,1532,2,67,2,12318.91,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(889,3687,287,40720,1532,2,13,1,70980.37,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(890,3687,288,40720,1532,2,96,2,26666.72,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(891,3687,288,40720,1532,2,67,2,5600.01,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(892,3687,288,40720,1532,2,13,1,32266.73,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(893,3687,289,40720,1532,2,96,2,27534.57,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(894,3687,289,40720,1532,2,67,2,5782.26,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(895,3687,289,40720,1532,2,13,1,33316.83,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL);
INSERT INTO `balance_libro_details` VALUES (896,3687,290,40720,1532,2,96,2,49806.90,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(897,3687,290,40720,1532,2,67,2,10459.45,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(898,3687,290,40720,1532,2,13,1,60266.35,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(899,3687,291,40720,1532,2,96,2,12027.96,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(900,3687,291,40720,1532,2,67,2,2525.87,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(901,3687,291,40720,1532,2,13,1,14553.83,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(902,3687,292,40720,1532,2,96,2,23636.51,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(903,3687,292,40720,1532,2,67,2,4963.67,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(904,3687,292,40720,1532,2,13,1,28600.18,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(905,3687,293,40720,1532,2,96,2,7302.69,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(906,3687,293,40720,1532,2,67,2,1533.56,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(907,3687,293,40720,1532,2,13,1,8836.25,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(908,3687,294,40720,1532,2,96,2,6744.53,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(909,3687,294,40720,1532,2,67,2,1416.35,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(910,3687,294,40720,1532,2,13,1,8160.88,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(911,3687,295,40720,1532,2,96,2,109835.11,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(912,3687,295,40720,1532,2,67,2,23065.37,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(913,3687,295,40720,1532,2,13,1,132900.48,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(914,3687,296,40720,1532,2,96,2,19338.84,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(915,3687,296,40720,1532,2,67,2,4061.16,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(916,3687,296,40720,1532,2,13,1,23400.00,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(917,3687,297,40720,1532,2,96,2,1458.75,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(918,3687,297,40720,1532,2,67,2,306.34,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(919,3687,297,40720,1532,2,13,1,1765.09,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(920,3687,298,40720,1532,2,96,2,24507.98,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(921,3687,298,40720,1532,2,67,2,5146.68,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(922,3687,298,40720,1532,2,13,1,29654.66,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(923,3687,299,40720,1532,2,96,2,73719.28,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(924,3687,299,40720,1532,2,67,2,15481.05,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(925,3687,299,40720,1532,2,13,1,89200.33,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(926,3687,300,40720,1532,2,96,1,24507.98,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(927,3687,300,40720,1532,2,68,1,5146.68,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(928,3687,300,40720,1532,2,13,2,29654.66,NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(929,3687,301,40720,1533,3,217,1,8400.48,NULL,'2021-05-16 14:29:49','2021-05-16 14:29:49',NULL),(930,3687,301,40720,1533,3,68,1,1764.10,NULL,'2021-05-16 14:29:49','2021-05-16 14:29:49',NULL),(931,3687,301,40720,1533,3,217,1,22548.48,NULL,'2021-05-16 14:29:49','2021-05-16 14:29:49',NULL),(932,3687,301,40720,1533,3,68,1,2367.59,NULL,'2021-05-16 14:29:49','2021-05-16 14:29:49',NULL),(933,3687,301,40720,1533,3,57,2,35080.65,NULL,'2021-05-16 14:29:49','2021-05-16 14:29:49',NULL),(934,3687,302,40812,3042,3,217,1,2561.98,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(935,3687,302,40812,3042,3,68,1,538.02,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(936,3687,302,40812,3042,3,57,2,3100.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL);
INSERT INTO `balance_libro_details` VALUES (937,3687,303,40812,3042,3,217,1,3600.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(938,3687,303,40812,3042,3,68,1,756.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(939,3687,303,40812,3042,3,57,2,4356.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(940,3687,304,40812,3042,3,217,1,84.30,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(941,3687,304,40812,3042,3,68,1,17.70,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(942,3687,304,40812,3042,3,57,2,102.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(943,3687,305,40812,3042,3,217,1,3650.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(944,3687,305,40812,3042,3,68,1,766.50,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(945,3687,305,40812,3042,3,217,1,109.50,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(946,3687,305,40812,3042,3,57,2,4526.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(947,3687,306,40812,3042,3,250,1,55000.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(948,3687,306,40812,3042,3,57,2,55000.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(949,3687,307,40812,3042,3,217,1,285069.13,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(950,3687,307,40812,3042,3,68,1,59864.52,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(951,3687,307,40812,3042,3,57,2,344933.65,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(952,3687,308,40812,3042,3,250,1,12000.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(953,3687,308,40812,3042,3,57,2,12000.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(954,3687,309,40812,3042,3,250,1,12000.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(955,3687,309,40812,3042,3,57,2,12000.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(956,3687,310,40812,3042,3,250,1,7350.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(957,3687,310,40812,3042,3,57,2,7350.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(958,3687,311,40812,3042,3,217,1,2000.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(959,3687,311,40812,3042,3,68,1,420.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(960,3687,311,40812,3042,3,57,2,2420.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(961,3687,312,40812,3042,3,250,1,8050.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(962,3687,312,40812,3042,3,57,2,8050.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(963,3687,313,40812,3042,3,217,1,46418.50,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(964,3687,313,40812,3042,3,68,1,9747.88,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(965,3687,313,40812,3042,3,57,2,56166.38,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(966,3687,314,40812,3042,3,217,1,12665.48,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(967,3687,314,40812,3042,3,68,1,3419.68,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(968,3687,314,40812,3042,3,217,1,1046.56,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(969,3687,314,40812,3042,3,57,2,17131.72,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(970,3687,315,40812,3042,3,217,1,1900.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(971,3687,315,40812,3042,3,68,1,399.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(972,3687,315,40812,3042,3,57,2,2299.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(973,3687,316,40812,3042,3,250,1,5600.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(974,3687,316,40812,3042,3,57,2,5600.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(975,3687,317,40812,3042,3,217,1,36163.80,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(976,3687,317,40812,3042,3,68,1,3797.20,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(977,3687,317,40812,3042,3,57,2,39961.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL);
INSERT INTO `balance_libro_details` VALUES (978,3687,318,40812,3042,3,217,1,809600.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(979,3687,318,40812,3042,3,68,1,170016.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(980,3687,318,40812,3042,3,57,2,979616.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(981,3687,319,40812,3042,3,250,1,4900.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(982,3687,319,40812,3042,3,57,2,4900.00,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(983,3687,320,40812,3042,3,217,2,13233.88,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(984,3687,320,40812,3042,3,67,2,2779.11,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(985,3687,320,40812,3042,3,57,1,16012.99,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(986,3687,321,40812,3042,3,217,1,176522.90,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(987,3687,321,40812,3042,3,68,1,37069.81,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(988,3687,321,40812,3042,3,57,2,213592.71,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(989,3687,322,40812,3042,3,217,1,208636.20,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(990,3687,322,40812,3042,3,68,1,43813.60,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(991,3687,322,40812,3042,3,57,2,252449.80,NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(992,3687,323,40812,3042,3,250,1,100000.00,NULL,'2021-05-17 17:34:22','2021-05-17 17:34:22',NULL),(993,3687,323,40812,3042,3,57,2,100000.00,NULL,'2021-05-17 17:34:22','2021-05-17 17:34:22',NULL),(994,3687,324,40812,3042,3,250,1,10000.00,NULL,'2021-05-17 17:34:22','2021-05-17 17:34:22',NULL),(995,3687,324,40812,3042,3,57,2,10000.00,NULL,'2021-05-17 17:34:22','2021-05-17 17:34:22',NULL),(996,3687,325,40812,3043,3,217,1,2561.98,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(997,3687,325,40812,3043,3,68,1,538.02,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(998,3687,325,40812,3043,3,57,2,3100.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(999,3687,326,40812,3043,3,217,1,4320.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1000,3687,326,40812,3043,3,68,1,907.20,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1001,3687,326,40812,3043,3,57,2,5227.20,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1002,3687,327,40812,3043,3,250,1,12000.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1003,3687,327,40812,3043,3,57,2,12000.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1004,3687,328,40812,3043,3,250,1,12000.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1005,3687,328,40812,3043,3,57,2,12000.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1006,3687,329,40812,3043,3,217,1,3650.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1007,3687,329,40812,3043,3,68,1,766.50,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1008,3687,329,40812,3043,3,217,1,109.50,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1009,3687,329,40812,3043,3,57,2,4526.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1010,3687,330,40812,3043,3,250,1,6900.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1011,3687,330,40812,3043,3,57,2,6900.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1012,3687,331,40812,3043,3,217,1,88.26,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1013,3687,331,40812,3043,3,68,1,18.54,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1014,3687,331,40812,3043,3,57,2,106.80,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1015,3687,332,40812,3043,3,217,1,286171.88,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1016,3687,332,40812,3043,3,68,1,60096.09,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1017,3687,332,40812,3043,3,57,2,346267.97,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1018,3687,333,40812,3043,3,250,1,55000.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1019,3687,333,40812,3043,3,57,2,55000.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1020,3687,334,40812,3043,3,217,1,286171.88,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1021,3687,334,40812,3043,3,68,1,60096.09,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1022,3687,334,40812,3043,3,217,1,22893.75,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1023,3687,334,40812,3043,3,57,2,369161.72,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1024,3687,335,40812,3043,3,250,1,5600.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1025,3687,335,40812,3043,3,57,2,5600.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1026,3687,336,40812,3043,3,217,1,2460.60,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1027,3687,336,40812,3043,3,68,1,516.73,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1028,3687,336,40812,3043,3,57,2,2977.33,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1029,3687,337,40812,3043,3,217,1,3450.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1030,3687,337,40812,3043,3,68,1,724.50,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1031,3687,337,40812,3043,3,57,2,4174.50,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1032,3687,338,40812,3043,3,217,1,502562.50,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1033,3687,338,40812,3043,3,68,1,105538.13,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1034,3687,338,40812,3043,3,57,2,608100.63,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1035,3687,339,40812,3043,3,250,1,9450.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1036,3687,339,40812,3043,3,57,2,9450.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1037,3687,340,40812,3043,3,217,2,1392.56,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1038,3687,340,40812,3043,3,67,2,292.44,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1039,3687,340,40812,3043,3,57,1,1685.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1040,3687,341,40812,3043,3,217,1,74.46,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1041,3687,341,40812,3043,3,68,1,15.64,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1042,3687,341,40812,3043,3,57,2,90.10,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1043,3687,342,40812,3043,3,217,1,12659.62,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1044,3687,342,40812,3043,3,68,1,3418.10,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1045,3687,342,40812,3043,3,217,1,1046.08,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1046,3687,342,40812,3043,3,57,2,17123.80,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1047,3687,343,40812,3043,3,217,1,1300.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1048,3687,343,40812,3043,3,68,1,273.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1049,3687,343,40812,3043,3,57,2,1573.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1050,3687,344,40812,3043,3,250,1,0.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1051,3687,344,40812,3043,3,57,2,0.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1052,3687,345,40812,3043,3,250,1,4550.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1053,3687,345,40812,3043,3,57,2,4550.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1054,3687,346,40812,3043,3,250,1,4550.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1055,3687,346,40812,3043,3,57,2,4550.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1056,3687,347,40812,3043,3,217,2,286171.88,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1057,3687,347,40812,3043,3,67,2,60096.09,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1058,3687,347,40812,3043,3,217,2,22893.75,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1059,3687,347,40812,3043,3,57,1,369161.72,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1060,3687,348,40812,3043,3,217,1,286171.88,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1061,3687,348,40812,3043,3,68,1,60096.09,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1062,3687,348,40812,3043,3,57,2,346267.97,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1063,3687,349,40812,3043,3,217,1,19361.76,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1064,3687,349,40812,3043,3,68,1,4065.97,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1065,3687,349,40812,3043,3,57,2,23427.73,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1066,3687,350,40812,3043,3,217,2,5500.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1067,3687,350,40812,3043,3,67,2,1155.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1068,3687,350,40812,3043,3,57,1,6655.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1069,3687,351,40812,3043,3,217,1,36163.80,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1070,3687,351,40812,3043,3,68,1,3797.20,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1071,3687,351,40812,3043,3,57,2,39961.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1072,3687,352,40812,3043,3,250,1,100000.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1073,3687,352,40812,3043,3,57,2,100000.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1074,3687,353,40812,3043,3,250,1,5250.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1075,3687,353,40812,3043,3,57,2,5250.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1076,3687,354,40812,3043,3,217,1,129547.20,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1077,3687,354,40812,3043,3,68,1,27204.91,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1078,3687,354,40812,3043,3,57,2,156752.11,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1079,3687,355,40812,3043,3,217,1,232250.00,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1080,3687,355,40812,3043,3,68,1,48772.50,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1081,3687,355,40812,3043,3,57,2,281022.50,NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(1082,3687,356,40812,3044,3,217,1,2561.98,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1083,3687,356,40812,3044,3,68,1,538.02,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1084,3687,356,40812,3044,3,57,2,3100.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1085,3687,357,40812,3044,3,217,1,4320.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1086,3687,357,40812,3044,3,68,1,907.20,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1087,3687,357,40812,3044,3,57,2,5227.20,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1088,3687,358,40812,3044,3,250,1,12000.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1089,3687,358,40812,3044,3,57,2,12000.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1090,3687,359,40812,3044,3,250,1,12000.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1091,3687,359,40812,3044,3,57,2,12000.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1092,3687,360,40812,3044,3,217,1,74.46,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1093,3687,360,40812,3044,3,68,1,15.64,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1094,3687,360,40812,3044,3,57,2,90.10,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1095,3687,361,40812,3044,3,217,1,3900.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1096,3687,361,40812,3044,3,68,1,819.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1097,3687,361,40812,3044,3,217,1,117.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1098,3687,361,40812,3044,3,57,2,4836.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1099,3687,362,40812,3044,3,217,1,247500.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1100,3687,362,40812,3044,3,68,1,25987.50,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL);
INSERT INTO `balance_libro_details` VALUES (1101,3687,362,40812,3044,3,57,2,273487.50,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1102,3687,363,40812,3044,3,250,1,7200.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1103,3687,363,40812,3044,3,57,2,7200.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1104,3687,364,40812,3044,3,250,1,55000.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1105,3687,364,40812,3044,3,57,2,55000.00,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1106,3687,365,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1107,3687,365,40812,3044,3,67,2,5.83,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1108,3687,365,40812,3044,3,217,2,1.79,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1109,3687,365,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1110,3687,366,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1111,3687,366,40812,3044,3,67,2,5.83,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1112,3687,366,40812,3044,3,217,2,1.79,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1113,3687,366,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1114,3687,367,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1115,3687,367,40812,3044,3,67,2,5.84,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1116,3687,367,40812,3044,3,217,2,1.78,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1117,3687,367,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1118,3687,368,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1119,3687,368,40812,3044,3,67,2,5.83,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1120,3687,368,40812,3044,3,217,2,1.79,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1121,3687,368,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1122,3687,369,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1123,3687,369,40812,3044,3,67,2,5.84,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1124,3687,369,40812,3044,3,217,2,1.78,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1125,3687,369,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(1126,3687,370,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1127,3687,370,40812,3044,3,67,2,5.84,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1128,3687,370,40812,3044,3,217,2,1.78,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1129,3687,370,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1130,3687,371,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1131,3687,371,40812,3044,3,67,2,5.84,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1132,3687,371,40812,3044,3,217,2,1.78,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1133,3687,371,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1134,3687,372,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1135,3687,372,40812,3044,3,67,2,5.83,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1136,3687,372,40812,3044,3,217,2,1.79,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1137,3687,372,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1138,3687,373,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1139,3687,373,40812,3044,3,67,2,5.84,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1140,3687,373,40812,3044,3,217,2,1.78,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1141,3687,373,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1142,3687,374,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1143,3687,374,40812,3044,3,67,2,5.84,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1144,3687,374,40812,3044,3,217,2,1.78,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1145,3687,374,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1146,3687,375,40812,3044,3,217,2,21.60,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1147,3687,375,40812,3044,3,67,2,5.83,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1148,3687,375,40812,3044,3,217,2,1.79,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1149,3687,375,40812,3044,3,57,1,29.22,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1150,3687,376,40812,3044,3,250,1,7200.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1151,3687,376,40812,3044,3,57,2,7200.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1152,3687,377,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1153,3687,377,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1154,3687,377,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1155,3687,377,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1156,3687,378,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1157,3687,378,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1158,3687,378,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1159,3687,378,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1160,3687,379,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1161,3687,379,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1162,3687,379,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1163,3687,379,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1164,3687,380,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1165,3687,380,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1166,3687,380,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1167,3687,380,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1168,3687,381,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1169,3687,381,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1170,3687,381,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1171,3687,381,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1172,3687,382,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1173,3687,382,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1174,3687,382,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1175,3687,382,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1176,3687,383,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1177,3687,383,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1178,3687,383,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1179,3687,383,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1180,3687,384,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1181,3687,384,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1182,3687,384,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1183,3687,384,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1184,3687,385,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1185,3687,385,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1186,3687,385,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1187,3687,385,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1188,3687,386,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1189,3687,386,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1190,3687,386,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1191,3687,386,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1192,3687,387,40812,3044,3,217,2,100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1193,3687,387,40812,3044,3,67,2,27.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1194,3687,387,40812,3044,3,217,2,8.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1195,3687,387,40812,3044,3,57,1,135.26,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1196,3687,388,40812,3044,3,217,1,2300.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1197,3687,388,40812,3044,3,68,1,483.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1198,3687,388,40812,3044,3,57,2,2783.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1199,3687,389,40812,3044,3,217,1,13160.08,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1200,3687,389,40812,3044,3,68,1,3553.22,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1201,3687,389,40812,3044,3,217,1,1087.43,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1202,3687,389,40812,3044,3,57,2,17800.73,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1203,3687,390,40812,3044,3,217,1,148.92,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1204,3687,390,40812,3044,3,68,1,31.28,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1205,3687,390,40812,3044,3,57,2,180.20,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1206,3687,391,40812,3044,3,250,1,8000.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1207,3687,391,40812,3044,3,57,2,8000.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1208,3687,392,40812,3044,3,250,1,6900.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1209,3687,392,40812,3044,3,57,2,6900.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1210,3687,393,40812,3044,3,217,1,12500.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1211,3687,393,40812,3044,3,68,1,2625.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1212,3687,393,40812,3044,3,57,2,15125.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1213,3687,394,40812,3044,3,217,1,37428.96,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1214,3687,394,40812,3044,3,68,1,3930.04,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1215,3687,394,40812,3044,3,57,2,41359.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1216,3687,395,40812,3044,3,217,2,8700.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1217,3687,395,40812,3044,3,67,2,1827.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1218,3687,395,40812,3044,3,57,1,10527.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1219,3687,396,40812,3044,3,250,1,8000.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1220,3687,396,40812,3044,3,57,2,8000.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1221,3687,397,40812,3044,3,250,1,2516.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1222,3687,397,40812,3044,3,57,2,2516.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1223,3687,398,40812,3044,3,217,1,150813.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1224,3687,398,40812,3044,3,68,1,31670.73,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1225,3687,398,40812,3044,3,57,2,182483.73,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1226,3687,399,40812,3044,3,250,1,100000.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1227,3687,399,40812,3044,3,57,2,100000.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1228,3687,400,40812,3044,3,217,1,3007458.25,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1229,3687,400,40812,3044,3,68,1,631566.23,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1230,3687,400,40812,3044,3,57,2,3639024.48,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1231,3687,401,40812,3044,3,250,1,25000.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1232,3687,401,40812,3044,3,57,2,25000.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1233,3687,402,40812,3044,3,217,1,113100.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1234,3687,402,40812,3044,3,68,1,23751.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1235,3687,402,40812,3044,3,57,2,136851.00,NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(1236,3687,403,40812,3045,3,217,1,2561.98,NULL,'2021-05-17 17:36:21','2021-05-18 02:23:43','2021-05-18 02:23:43'),(1237,3687,403,40812,3045,3,68,1,538.02,NULL,'2021-05-17 17:36:21','2021-05-18 02:23:43','2021-05-18 02:23:43'),(1238,3687,403,40812,3045,3,57,2,3100.00,NULL,'2021-05-17 17:36:21','2021-05-18 02:23:43','2021-05-18 02:23:43'),(1239,3687,404,40812,3045,3,250,1,6900.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:45:58','2021-05-17 17:45:58'),(1240,3687,404,40812,3045,3,57,2,6900.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:45:58','2021-05-17 17:45:58'),(1241,3687,405,40812,3045,3,217,1,4320.00,NULL,'2021-05-17 17:36:21','2021-05-18 02:23:32','2021-05-18 02:23:32'),(1242,3687,405,40812,3045,3,68,1,907.20,NULL,'2021-05-17 17:36:21','2021-05-18 02:23:32','2021-05-18 02:23:32'),(1243,3687,405,40812,3045,3,57,2,5227.20,NULL,'2021-05-17 17:36:21','2021-05-18 02:23:32','2021-05-18 02:23:32'),(1244,3687,406,40812,3045,3,250,1,6400.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:50:37','2021-05-17 17:50:37'),(1245,3687,406,40812,3045,3,57,2,6400.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:50:37','2021-05-17 17:50:37'),(1246,3687,407,40812,3045,3,217,1,17500.00,NULL,'2021-05-17 17:36:21','2021-05-18 02:23:24','2021-05-18 02:23:24'),(1247,3687,407,40812,3045,3,68,1,3675.00,NULL,'2021-05-17 17:36:21','2021-05-18 02:23:24','2021-05-18 02:23:24'),(1248,3687,407,40812,3045,3,57,2,21175.00,NULL,'2021-05-17 17:36:21','2021-05-18 02:23:24','2021-05-18 02:23:24'),(1249,3687,408,40812,3045,3,217,1,3900.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:52:08','2021-05-17 17:52:08'),(1250,3687,408,40812,3045,3,68,1,819.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:52:08','2021-05-17 17:52:08'),(1251,3687,408,40812,3045,3,217,1,117.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:52:08','2021-05-17 17:52:08'),(1252,3687,408,40812,3045,3,57,2,4836.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:52:08','2021-05-17 17:52:08'),(1253,3687,409,40812,3045,3,250,2,6900.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:54:20','2021-05-17 17:54:20'),(1254,3687,409,40812,3045,3,57,1,6900.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:54:20','2021-05-17 17:54:20'),(1255,3687,410,40812,3045,3,250,1,12000.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:55:29','2021-05-17 17:55:29'),(1256,3687,410,40812,3045,3,57,2,12000.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:55:29','2021-05-17 17:55:29'),(1257,3687,411,40812,3045,3,250,1,55000.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:55:55','2021-05-17 17:55:55'),(1258,3687,411,40812,3045,3,57,2,55000.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:55:55','2021-05-17 17:55:55'),(1259,3687,412,40812,3045,3,250,1,12000.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:56:22','2021-05-17 17:56:22'),(1260,3687,412,40812,3045,3,57,2,12000.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:56:22','2021-05-17 17:56:22'),(1261,3687,413,40812,3045,3,250,1,7200.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:56:55','2021-05-17 17:56:55');
INSERT INTO `balance_libro_details` VALUES (1262,3687,413,40812,3045,3,57,2,7200.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:56:55','2021-05-17 17:56:55'),(1263,3687,414,40812,3045,3,217,1,16942.20,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:40','2021-05-18 02:22:40'),(1264,3687,414,40812,3045,3,68,1,3557.86,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:40','2021-05-18 02:22:40'),(1265,3687,414,40812,3045,3,57,2,20500.06,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:40','2021-05-18 02:22:40'),(1266,3687,415,40812,3045,3,250,1,4400.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:57:16','2021-05-17 17:57:16'),(1267,3687,415,40812,3045,3,57,2,4400.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:57:16','2021-05-17 17:57:16'),(1268,3687,416,40812,3045,3,217,1,15279.53,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:30','2021-05-18 02:22:30'),(1269,3687,416,40812,3045,3,68,1,3208.70,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:30','2021-05-18 02:22:30'),(1270,3687,416,40812,3045,3,57,2,18488.23,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:30','2021-05-18 02:22:30'),(1271,3687,417,40812,3045,3,250,1,6400.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:48:38','2021-05-17 17:48:38'),(1272,3687,417,40812,3045,3,57,2,6400.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:48:38','2021-05-17 17:48:38'),(1273,3687,418,40812,3045,3,250,1,990.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:57:44','2021-05-17 17:57:44'),(1274,3687,418,40812,3045,3,57,2,990.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:57:44','2021-05-17 17:57:44'),(1275,3687,419,40812,3045,3,217,1,1550.00,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:07','2021-05-18 02:22:07'),(1276,3687,419,40812,3045,3,68,1,325.50,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:07','2021-05-18 02:22:07'),(1277,3687,419,40812,3045,3,57,2,1875.50,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:07','2021-05-18 02:22:07'),(1278,3687,420,40812,3045,3,217,1,3189.60,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:01','2021-05-18 02:22:01'),(1279,3687,420,40812,3045,3,68,1,669.82,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:01','2021-05-18 02:22:01'),(1280,3687,420,40812,3045,3,57,2,3859.42,NULL,'2021-05-17 17:36:21','2021-05-18 02:22:01','2021-05-18 02:22:01'),(1281,3687,421,40812,3045,3,250,1,7200.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:58:02','2021-05-17 17:58:02'),(1282,3687,421,40812,3045,3,57,2,7200.00,NULL,'2021-05-17 17:36:21','2021-05-17 17:58:02','2021-05-17 17:58:02'),(1283,3687,422,40812,3045,3,217,1,6822.00,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:50','2021-05-18 02:21:50'),(1284,3687,422,40812,3045,3,68,1,1841.94,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:50','2021-05-18 02:21:50'),(1285,3687,422,40812,3045,3,217,1,563.71,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:50','2021-05-18 02:21:50'),(1286,3687,422,40812,3045,3,57,2,9227.65,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:50','2021-05-18 02:21:50'),(1287,3687,423,40812,3045,3,217,1,68611.12,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:44','2021-05-18 02:21:44'),(1288,3687,423,40812,3045,3,68,1,105.00,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:44','2021-05-18 02:21:44'),(1289,3687,423,40812,3045,3,57,2,68716.12,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:44','2021-05-18 02:21:44'),(1290,3687,424,40812,3045,3,250,1,5600.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:00:32','2021-05-17 18:00:32'),(1291,3687,424,40812,3045,3,57,2,5600.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:00:32','2021-05-17 18:00:32'),(1292,3687,425,40812,3045,3,217,1,109.05,NULL,'2021-05-17 17:36:21','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1293,3687,425,40812,3045,3,68,1,22.90,NULL,'2021-05-17 17:36:21','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1294,3687,425,40812,3045,3,217,1,0.05,NULL,'2021-05-17 17:36:21','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1295,3687,425,40812,3045,3,57,2,132.00,NULL,'2021-05-17 17:36:21','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1296,3687,426,40812,3045,3,250,1,6900.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:00:51','2021-05-17 18:00:51');
INSERT INTO `balance_libro_details` VALUES (1297,3687,426,40812,3045,3,57,2,6900.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:00:51','2021-05-17 18:00:51'),(1298,3687,427,40812,3045,3,250,1,7200.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:01:08','2021-05-17 18:01:08'),(1299,3687,427,40812,3045,3,57,2,7200.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:01:08','2021-05-17 18:01:08'),(1300,3687,428,40812,3045,3,217,1,39112.21,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:34','2021-05-18 02:21:34'),(1301,3687,428,40812,3045,3,68,1,4106.78,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:34','2021-05-18 02:21:34'),(1302,3687,428,40812,3045,3,57,2,43218.99,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:34','2021-05-18 02:21:34'),(1303,3687,429,40812,3045,3,217,1,923.64,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:29','2021-05-18 02:21:29'),(1304,3687,429,40812,3045,3,68,1,193.96,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:29','2021-05-18 02:21:29'),(1305,3687,429,40812,3045,3,57,2,1117.60,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:29','2021-05-18 02:21:29'),(1306,3687,430,40812,3045,3,250,1,5200.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:01:22','2021-05-17 18:01:22'),(1307,3687,430,40812,3045,3,57,2,5200.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:01:22','2021-05-17 18:01:22'),(1308,3687,431,40812,3045,3,217,1,875418.75,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:16','2021-05-18 02:21:16'),(1309,3687,431,40812,3045,3,68,1,183837.94,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:16','2021-05-18 02:21:16'),(1310,3687,431,40812,3045,3,57,2,1059256.69,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:16','2021-05-18 02:21:16'),(1311,3687,432,40812,3045,3,217,1,246403.00,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:11','2021-05-18 02:21:11'),(1312,3687,432,40812,3045,3,68,1,51744.63,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:11','2021-05-18 02:21:11'),(1313,3687,432,40812,3045,3,57,2,298147.63,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:11','2021-05-18 02:21:11'),(1314,3687,433,40812,3045,3,217,1,554062.50,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:03','2021-05-18 02:21:03'),(1315,3687,433,40812,3045,3,68,1,116353.13,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:03','2021-05-18 02:21:03'),(1316,3687,433,40812,3045,3,57,2,670415.63,NULL,'2021-05-17 17:36:21','2021-05-18 02:21:03','2021-05-18 02:21:03'),(1317,3687,434,40812,3045,3,250,1,120000.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:02:00','2021-05-17 18:02:00'),(1318,3687,434,40812,3045,3,57,2,120000.00,NULL,'2021-05-17 17:36:21','2021-05-17 18:02:00','2021-05-17 18:02:00'),(1319,3687,435,40812,3045,3,217,1,270441.60,NULL,'2021-05-17 17:36:21','2021-05-18 02:20:49','2021-05-18 02:20:49'),(1320,3687,435,40812,3045,3,68,1,56792.74,NULL,'2021-05-17 17:36:21','2021-05-18 02:20:49','2021-05-18 02:20:49'),(1321,3687,435,40812,3045,3,57,2,327234.34,NULL,'2021-05-17 17:36:21','2021-05-18 02:20:49','2021-05-18 02:20:49'),(1322,3687,436,40812,3045,3,217,1,278930.40,NULL,'2021-05-17 17:36:22','2021-05-18 02:20:43','2021-05-18 02:20:43'),(1323,3687,436,40812,3045,3,68,1,58575.38,NULL,'2021-05-17 17:36:22','2021-05-18 02:20:43','2021-05-18 02:20:43'),(1324,3687,436,40812,3045,3,57,2,337505.78,NULL,'2021-05-17 17:36:22','2021-05-18 02:20:43','2021-05-18 02:20:43'),(1325,3687,437,40812,3045,3,250,1,7200.00,NULL,'2021-05-17 17:36:22','2021-05-17 18:02:15','2021-05-17 18:02:15'),(1326,3687,437,40812,3045,3,57,2,7200.00,NULL,'2021-05-17 17:36:22','2021-05-17 18:02:15','2021-05-17 18:02:15'),(1327,3687,438,40812,3042,2,96,2,11680.00,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1328,3687,438,40812,3042,2,67,2,2452.80,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1329,3687,438,40812,3042,2,13,1,14132.80,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1330,3687,439,40812,3042,2,96,2,65545.00,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1331,3687,439,40812,3042,2,67,2,13764.45,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1332,3687,439,40812,3042,2,13,1,79309.45,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1333,3687,440,40812,3042,2,96,1,11680.00,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1334,3687,440,40812,3042,2,68,1,2452.80,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1335,3687,440,40812,3042,2,13,2,14132.80,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1336,3687,441,40812,3042,2,96,2,35645.00,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1337,3687,441,40812,3042,2,67,2,7485.45,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1338,3687,441,40812,3042,2,13,1,43130.45,NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(1339,3687,442,40812,3042,2,96,2,43930.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1340,3687,442,40812,3042,2,67,2,9225.30,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1341,3687,442,40812,3042,2,13,1,53155.30,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1342,3687,443,40812,3042,2,96,2,28445.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1343,3687,443,40812,3042,2,67,2,5973.45,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1344,3687,443,40812,3042,2,13,1,34418.45,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1345,3687,444,40812,3042,2,96,2,167000.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1346,3687,444,40812,3042,2,67,2,35070.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1347,3687,444,40812,3042,2,13,1,202070.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1348,3687,445,40812,3042,2,96,2,258290.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1349,3687,445,40812,3042,2,67,2,54240.90,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1350,3687,445,40812,3042,2,13,1,312530.90,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1351,3687,446,40812,3042,2,96,2,5110.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1352,3687,446,40812,3042,2,67,2,1073.10,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1353,3687,446,40812,3042,2,13,1,6183.10,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1354,3687,447,40812,3042,2,96,2,103221.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1355,3687,447,40812,3042,2,67,2,21676.41,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1356,3687,447,40812,3042,2,13,1,124897.41,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1357,3687,448,40812,3042,2,96,2,31820.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1358,3687,448,40812,3042,2,67,2,6682.20,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1359,3687,448,40812,3042,2,13,1,38502.20,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1360,3687,449,40812,3042,2,96,2,6320.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1361,3687,449,40812,3042,2,67,2,1327.20,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1362,3687,449,40812,3042,2,13,1,7647.20,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1363,3687,450,40812,3042,2,96,2,11040.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1364,3687,450,40812,3042,2,67,2,2318.40,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1365,3687,450,40812,3042,2,13,1,13358.40,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1366,3687,451,40812,3042,2,96,2,27410.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1367,3687,451,40812,3042,2,67,2,5756.10,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1368,3687,451,40812,3042,2,13,1,33166.10,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1369,3687,452,40812,3042,2,96,2,6680.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1370,3687,452,40812,3042,2,67,2,1402.80,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1371,3687,452,40812,3042,2,13,1,8082.80,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1372,3687,453,40812,3042,2,96,2,78115.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL);
INSERT INTO `balance_libro_details` VALUES (1373,3687,453,40812,3042,2,67,2,16404.15,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1374,3687,453,40812,3042,2,13,1,94519.15,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1375,3687,454,40812,3042,2,96,2,19660.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1376,3687,454,40812,3042,2,67,2,4128.60,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1377,3687,454,40812,3042,2,13,1,23788.60,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1378,3687,455,40812,3042,2,96,2,40945.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1379,3687,455,40812,3042,2,67,2,8598.45,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1380,3687,455,40812,3042,2,13,1,49543.45,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1381,3687,456,40812,3042,2,96,2,35515.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1382,3687,456,40812,3042,2,67,2,7458.15,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1383,3687,456,40812,3042,2,13,1,42973.15,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1384,3687,457,40812,3042,2,96,2,20890.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1385,3687,457,40812,3042,2,67,2,4386.90,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1386,3687,457,40812,3042,2,13,1,25276.90,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1387,3687,458,40812,3042,2,96,2,14500.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1388,3687,458,40812,3042,2,67,2,3045.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1389,3687,458,40812,3042,2,13,1,17545.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1390,3687,459,40812,3042,2,96,2,32220.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1391,3687,459,40812,3042,2,67,2,6766.20,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1392,3687,459,40812,3042,2,13,1,38986.20,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1393,3687,460,40812,3042,2,96,2,46350.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1394,3687,460,40812,3042,2,67,2,9733.50,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1395,3687,460,40812,3042,2,13,1,56083.50,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1396,3687,461,40812,3042,2,96,2,51380.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1397,3687,461,40812,3042,2,67,2,10789.80,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1398,3687,461,40812,3042,2,13,1,62169.80,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1399,3687,462,40812,3042,2,96,2,31843.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1400,3687,462,40812,3042,2,67,2,6687.03,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1401,3687,462,40812,3042,2,13,1,38530.03,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1402,3687,463,40812,3042,2,96,2,75790.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1403,3687,463,40812,3042,2,67,2,15915.90,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1404,3687,463,40812,3042,2,13,1,91705.90,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1405,3687,464,40812,3042,2,96,2,69105.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1406,3687,464,40812,3042,2,67,2,14512.05,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1407,3687,464,40812,3042,2,13,1,83617.05,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1408,3687,465,40812,3042,2,96,2,29785.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1409,3687,465,40812,3042,2,67,2,6254.85,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1410,3687,465,40812,3042,2,13,1,36039.85,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1411,3687,466,40812,3042,2,96,2,16290.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1412,3687,466,40812,3042,2,67,2,3420.90,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1413,3687,466,40812,3042,2,13,1,19710.90,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL);
INSERT INTO `balance_libro_details` VALUES (1414,3687,467,40812,3042,2,96,2,33650.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1415,3687,467,40812,3042,2,67,2,7066.50,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1416,3687,467,40812,3042,2,13,1,40716.50,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1417,3687,468,40812,3042,2,96,2,12850.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1418,3687,468,40812,3042,2,67,2,2698.50,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1419,3687,468,40812,3042,2,13,1,15548.50,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1420,3687,469,40812,3042,2,96,2,26323.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1421,3687,469,40812,3042,2,67,2,5527.83,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1422,3687,469,40812,3042,2,13,1,31850.83,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1423,3687,470,40812,3042,2,96,2,25500.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1424,3687,470,40812,3042,2,67,2,5355.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1425,3687,470,40812,3042,2,13,1,30855.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1426,3687,471,40812,3042,2,96,2,66230.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1427,3687,471,40812,3042,2,67,2,13908.30,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1428,3687,471,40812,3042,2,13,1,80138.30,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1429,3687,472,40812,3042,2,96,2,292050.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1430,3687,472,40812,3042,2,67,2,61330.50,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1431,3687,472,40812,3042,2,13,1,353380.50,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1432,3687,473,40812,3042,2,96,2,9605.00,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1433,3687,473,40812,3042,2,67,2,2017.05,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1434,3687,473,40812,3042,2,13,1,11622.05,NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(1435,3687,474,40812,3043,2,96,2,24565.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1436,3687,474,40812,3043,2,67,2,5158.65,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1437,3687,474,40812,3043,2,13,1,29723.65,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1438,3687,475,40812,3043,2,96,2,46500.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1439,3687,475,40812,3043,2,67,2,9765.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1440,3687,475,40812,3043,2,13,1,56265.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1441,3687,476,40812,3043,2,96,2,59515.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1442,3687,476,40812,3043,2,67,2,12498.15,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1443,3687,476,40812,3043,2,13,1,72013.15,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1444,3687,477,40812,3043,2,96,2,36290.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1445,3687,477,40812,3043,2,67,2,7620.90,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1446,3687,477,40812,3043,2,13,1,43910.90,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1447,3687,478,40812,3043,2,96,2,7800.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1448,3687,478,40812,3043,2,67,2,1638.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1449,3687,478,40812,3043,2,13,1,9438.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1450,3687,479,40812,3043,2,96,2,195501.70,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1451,3687,479,40812,3043,2,67,2,41055.36,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1452,3687,479,40812,3043,2,13,1,236557.06,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1453,3687,480,40812,3043,2,96,2,60256.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1454,3687,480,40812,3043,2,67,2,12653.76,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL);
INSERT INTO `balance_libro_details` VALUES (1455,3687,480,40812,3043,2,13,1,72909.76,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1456,3687,481,40812,3043,2,96,2,32280.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1457,3687,481,40812,3043,2,67,2,6778.80,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1458,3687,481,40812,3043,2,13,1,39058.80,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1459,3687,482,40812,3043,2,96,2,25350.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1460,3687,482,40812,3043,2,67,2,5323.50,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1461,3687,482,40812,3043,2,13,1,30673.50,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1462,3687,483,40812,3043,2,96,2,22045.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1463,3687,483,40812,3043,2,67,2,4629.45,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1464,3687,483,40812,3043,2,13,1,26674.45,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1465,3687,484,40812,3043,2,96,2,66000.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1466,3687,484,40812,3043,2,67,2,13860.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1467,3687,484,40812,3043,2,13,1,79860.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1468,3687,485,40812,3043,2,96,2,20900.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1469,3687,485,40812,3043,2,67,2,4389.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1470,3687,485,40812,3043,2,13,1,25289.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1471,3687,486,40812,3043,2,96,2,43935.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1472,3687,486,40812,3043,2,67,2,9226.35,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1473,3687,486,40812,3043,2,13,1,53161.35,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1474,3687,487,40812,3043,2,96,2,17239.62,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1475,3687,487,40812,3043,2,67,2,3620.32,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1476,3687,487,40812,3043,2,13,1,20859.94,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1477,3687,488,40812,3043,2,96,2,7693.13,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1478,3687,488,40812,3043,2,67,2,1615.56,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1479,3687,488,40812,3043,2,13,1,9308.69,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1480,3687,489,40812,3043,2,96,2,18165.12,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1481,3687,489,40812,3043,2,67,2,3814.68,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1482,3687,489,40812,3043,2,13,1,21979.80,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1483,3687,490,40812,3043,2,96,2,33545.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1484,3687,490,40812,3043,2,67,2,7044.45,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1485,3687,490,40812,3043,2,13,1,40589.45,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1486,3687,491,40812,3043,2,96,2,9413.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1487,3687,491,40812,3043,2,67,2,1976.73,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1488,3687,491,40812,3043,2,13,1,11389.73,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1489,3687,492,40812,3043,2,96,2,13960.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1490,3687,492,40812,3043,2,67,2,2931.60,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1491,3687,492,40812,3043,2,13,1,16891.60,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1492,3687,493,40812,3043,2,218,2,0.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1493,3687,493,40812,3043,2,218,2,13000.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1494,3687,493,40812,3043,2,13,1,13000.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1495,3687,494,40812,3043,2,96,2,399540.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL);
INSERT INTO `balance_libro_details` VALUES (1496,3687,494,40812,3043,2,67,2,83903.40,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1497,3687,494,40812,3043,2,13,1,483443.40,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1498,3687,495,40812,3043,2,96,2,32215.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1499,3687,495,40812,3043,2,67,2,6765.15,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1500,3687,495,40812,3043,2,13,1,38980.15,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1501,3687,496,40812,3043,2,96,2,58965.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1502,3687,496,40812,3043,2,67,2,12382.65,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1503,3687,496,40812,3043,2,13,1,71347.65,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1504,3687,497,40812,3043,2,96,2,28630.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1505,3687,497,40812,3043,2,67,2,6012.30,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1506,3687,497,40812,3043,2,13,1,34642.30,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1507,3687,498,40812,3043,2,96,2,149810.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1508,3687,498,40812,3043,2,67,2,31460.10,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1509,3687,498,40812,3043,2,13,1,181270.10,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1510,3687,499,40812,3043,2,96,2,526761.30,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1511,3687,499,40812,3043,2,67,2,110619.87,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1512,3687,499,40812,3043,2,13,1,637381.17,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1513,3687,500,40812,3043,2,96,2,17680.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1514,3687,500,40812,3043,2,67,2,3712.80,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1515,3687,500,40812,3043,2,13,1,21392.80,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1516,3687,501,40812,3043,2,96,2,63000.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1517,3687,501,40812,3043,2,67,2,13230.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1518,3687,501,40812,3043,2,13,1,76230.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1519,3687,502,40812,3043,2,96,2,106791.90,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1520,3687,502,40812,3043,2,67,2,22426.30,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1521,3687,502,40812,3043,2,13,1,129218.20,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1522,3687,503,40812,3043,2,96,2,23800.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1523,3687,503,40812,3043,2,67,2,4998.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1524,3687,503,40812,3043,2,13,1,28798.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1525,3687,504,40812,3043,2,96,2,8295.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1526,3687,504,40812,3043,2,67,2,1741.95,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1527,3687,504,40812,3043,2,13,1,10036.95,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1528,3687,505,40812,3043,2,96,2,107730.00,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1529,3687,505,40812,3043,2,67,2,22623.30,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1530,3687,505,40812,3043,2,13,1,130353.30,NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(1531,3687,506,40812,3043,2,96,2,35990.00,NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(1532,3687,506,40812,3043,2,67,2,7557.90,NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(1533,3687,506,40812,3043,2,13,1,43547.90,NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(1534,3687,507,40812,3043,2,96,2,35255.00,NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(1535,3687,507,40812,3043,2,67,2,7403.55,NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(1536,3687,507,40812,3043,2,13,1,42658.55,NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1537,3687,508,40812,3043,2,96,2,7780.00,NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(1538,3687,508,40812,3043,2,67,2,1633.80,NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(1539,3687,508,40812,3043,2,13,1,9413.80,NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(1540,3687,509,40812,3044,2,96,2,24400.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1541,3687,509,40812,3044,2,67,2,5124.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1542,3687,509,40812,3044,2,13,1,29524.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1543,3687,510,40812,3044,2,96,2,100130.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1544,3687,510,40812,3044,2,67,2,21027.30,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1545,3687,510,40812,3044,2,13,1,121157.30,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1546,3687,511,40812,3044,2,96,2,243521.96,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1547,3687,511,40812,3044,2,67,2,51139.61,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1548,3687,511,40812,3044,2,13,1,294661.57,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1549,3687,512,40812,3044,2,96,2,42742.35,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1550,3687,512,40812,3044,2,67,2,8975.89,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1551,3687,512,40812,3044,2,13,1,51718.24,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1552,3687,513,40812,3044,2,96,2,11078.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1553,3687,513,40812,3044,2,67,2,2326.38,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1554,3687,513,40812,3044,2,13,1,13404.38,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1555,3687,514,40812,3044,2,96,2,18780.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1556,3687,514,40812,3044,2,67,2,3943.80,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1557,3687,514,40812,3044,2,13,1,22723.80,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1558,3687,515,40812,3044,2,96,2,53540.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1559,3687,515,40812,3044,2,67,2,11243.40,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1560,3687,515,40812,3044,2,13,1,64783.40,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1561,3687,516,40812,3044,2,96,2,48400.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1562,3687,516,40812,3044,2,67,2,10164.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1563,3687,516,40812,3044,2,13,1,58564.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1564,3687,517,40812,3044,2,96,2,73780.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1565,3687,517,40812,3044,2,67,2,15493.80,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1566,3687,517,40812,3044,2,13,1,89273.80,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1567,3687,518,40812,3044,2,96,2,20900.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1568,3687,518,40812,3044,2,67,2,4389.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1569,3687,518,40812,3044,2,13,1,25289.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1570,3687,519,40812,3044,2,96,2,5970.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1571,3687,519,40812,3044,2,67,2,1253.70,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1572,3687,519,40812,3044,2,13,1,7223.70,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1573,3687,520,40812,3044,2,96,2,17980.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1574,3687,520,40812,3044,2,67,2,3775.80,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1575,3687,520,40812,3044,2,13,1,21755.80,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1576,3687,521,40812,3044,2,96,2,27210.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1577,3687,521,40812,3044,2,67,2,5714.10,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL);
INSERT INTO `balance_libro_details` VALUES (1578,3687,521,40812,3044,2,13,1,32924.10,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1579,3687,522,40812,3044,2,96,2,19500.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1580,3687,522,40812,3044,2,67,2,4095.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1581,3687,522,40812,3044,2,13,1,23595.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1582,3687,523,40812,3044,2,96,2,47600.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1583,3687,523,40812,3044,2,67,2,9996.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1584,3687,523,40812,3044,2,13,1,57596.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1585,3687,524,40812,3044,2,96,2,14120.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1586,3687,524,40812,3044,2,67,2,2965.20,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1587,3687,524,40812,3044,2,13,1,17085.20,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1588,3687,525,40812,3044,2,96,2,30950.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1589,3687,525,40812,3044,2,67,2,6499.50,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1590,3687,525,40812,3044,2,13,1,37449.50,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1591,3687,526,40812,3044,2,96,2,415982.57,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1592,3687,526,40812,3044,2,67,2,87356.34,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1593,3687,526,40812,3044,2,13,1,503338.91,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1594,3687,527,40812,3044,2,96,2,16145.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1595,3687,527,40812,3044,2,67,2,3390.45,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1596,3687,527,40812,3044,2,13,1,19535.45,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1597,3687,528,40812,3044,2,96,2,16024.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1598,3687,528,40812,3044,2,67,2,3365.04,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1599,3687,528,40812,3044,2,13,1,19389.04,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1600,3687,529,40812,3044,2,96,2,238100.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1601,3687,529,40812,3044,2,67,2,50001.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1602,3687,529,40812,3044,2,13,1,288101.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1603,3687,530,40812,3044,2,96,2,5240.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1604,3687,530,40812,3044,2,67,2,1100.40,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1605,3687,530,40812,3044,2,13,1,6340.40,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1606,3687,531,40812,3044,2,96,2,30340.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1607,3687,531,40812,3044,2,67,2,6371.40,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1608,3687,531,40812,3044,2,13,1,36711.40,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1609,3687,532,40812,3044,2,96,2,166170.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1610,3687,532,40812,3044,2,67,2,34895.70,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1611,3687,532,40812,3044,2,13,1,201065.70,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1612,3687,533,40812,3044,2,96,2,30560.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1613,3687,533,40812,3044,2,67,2,6417.60,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1614,3687,533,40812,3044,2,13,1,36977.60,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1615,3687,534,40812,3044,2,96,2,14960.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1616,3687,534,40812,3044,2,67,2,3141.60,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1617,3687,534,40812,3044,2,13,1,18101.60,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1618,3687,535,40812,3044,2,96,2,9045.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL);
INSERT INTO `balance_libro_details` VALUES (1619,3687,535,40812,3044,2,67,2,1899.45,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1620,3687,535,40812,3044,2,13,1,10944.45,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1621,3687,536,40812,3044,2,96,2,50645.00,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1622,3687,536,40812,3044,2,67,2,10635.45,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1623,3687,536,40812,3044,2,13,1,61280.45,NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(1624,3687,537,40812,3044,2,96,2,54200.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1625,3687,537,40812,3044,2,67,2,11382.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1626,3687,537,40812,3044,2,13,1,65582.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1627,3687,538,40812,3044,2,96,2,43849.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1628,3687,538,40812,3044,2,67,2,9208.29,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1629,3687,538,40812,3044,2,13,1,53057.29,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1630,3687,539,40812,3044,2,96,2,20805.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1631,3687,539,40812,3044,2,67,2,4369.05,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1632,3687,539,40812,3044,2,13,1,25174.05,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1633,3687,540,40812,3044,2,96,2,40800.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1634,3687,540,40812,3044,2,67,2,8568.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1635,3687,540,40812,3044,2,13,1,49368.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1636,3687,541,40812,3044,2,96,2,8490.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1637,3687,541,40812,3044,2,67,2,1782.90,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1638,3687,541,40812,3044,2,13,1,10272.90,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1639,3687,542,40812,3044,2,96,2,20900.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1640,3687,542,40812,3044,2,67,2,4389.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1641,3687,542,40812,3044,2,13,1,25289.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1642,3687,543,40812,3044,2,96,2,3840.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1643,3687,543,40812,3044,2,67,2,806.40,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1644,3687,543,40812,3044,2,13,1,4646.40,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1645,3687,544,40812,3044,2,96,2,551225.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1646,3687,544,40812,3044,2,67,2,115757.25,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1647,3687,544,40812,3044,2,13,1,666982.25,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1648,3687,545,40812,3044,2,96,2,13650.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1649,3687,545,40812,3044,2,67,2,2866.50,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1650,3687,545,40812,3044,2,13,1,16516.50,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1651,3687,546,40812,3044,2,96,2,58556.96,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1652,3687,546,40812,3044,2,67,2,12296.96,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1653,3687,546,40812,3044,2,13,1,70853.92,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1654,3687,547,40812,3044,2,96,2,2380.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1655,3687,547,40812,3044,2,67,2,499.80,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1656,3687,547,40812,3044,2,13,1,2879.80,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1657,3687,548,40812,3044,2,96,2,3460.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1658,3687,548,40812,3044,2,67,2,726.60,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1659,3687,548,40812,3044,2,13,1,4186.60,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL);
INSERT INTO `balance_libro_details` VALUES (1660,3687,549,40812,3044,2,96,2,5020.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1661,3687,549,40812,3044,2,67,2,1054.20,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1662,3687,549,40812,3044,2,13,1,6074.20,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1663,3687,550,40812,3044,2,96,2,46620.00,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1664,3687,550,40812,3044,2,67,2,9790.20,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1665,3687,550,40812,3044,2,13,1,56410.20,NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(1666,3687,551,40812,3045,2,96,2,15890.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:29','2021-05-18 02:16:29'),(1667,3687,551,40812,3045,2,67,2,3336.90,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:29','2021-05-18 02:16:29'),(1668,3687,551,40812,3045,2,13,1,19226.90,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:29','2021-05-18 02:16:29'),(1669,3687,552,40812,3045,2,96,2,64630.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:23','2021-05-18 02:16:23'),(1670,3687,552,40812,3045,2,67,2,13572.30,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:23','2021-05-18 02:16:23'),(1671,3687,552,40812,3045,2,13,1,78202.30,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:23','2021-05-18 02:16:23'),(1672,3687,553,40812,3045,2,96,2,116800.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:19','2021-05-18 02:16:19'),(1673,3687,553,40812,3045,2,67,2,24528.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:19','2021-05-18 02:16:19'),(1674,3687,553,40812,3045,2,13,1,141328.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:19','2021-05-18 02:16:19'),(1675,3687,554,40812,3045,2,96,2,40255.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:15','2021-05-18 02:16:15'),(1676,3687,554,40812,3045,2,67,2,8453.55,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:15','2021-05-18 02:16:15'),(1677,3687,554,40812,3045,2,13,1,48708.55,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:15','2021-05-18 02:16:15'),(1678,3687,555,40812,3045,2,96,2,52900.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:11','2021-05-18 02:16:11'),(1679,3687,555,40812,3045,2,67,2,11109.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:11','2021-05-18 02:16:11'),(1680,3687,555,40812,3045,2,13,1,64009.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:11','2021-05-18 02:16:11'),(1681,3687,556,40812,3045,2,96,2,6455.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:06','2021-05-18 02:16:06'),(1682,3687,556,40812,3045,2,67,2,1355.55,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:06','2021-05-18 02:16:06'),(1683,3687,556,40812,3045,2,13,1,7810.55,NULL,'2021-05-17 17:44:53','2021-05-18 02:16:06','2021-05-18 02:16:06'),(1684,3687,557,40812,3045,2,96,2,118995.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1685,3687,557,40812,3045,2,67,2,24988.95,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1686,3687,557,40812,3045,2,13,1,143983.95,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1687,3687,558,40812,3045,2,96,2,12420.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1688,3687,558,40812,3045,2,67,2,2608.20,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1689,3687,558,40812,3045,2,13,1,15028.20,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1690,3687,559,40812,3045,2,96,2,56420.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1691,3687,559,40812,3045,2,67,2,11848.20,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1692,3687,559,40812,3045,2,13,1,68268.20,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1693,3687,560,40812,3045,2,96,2,96503.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:58','2021-05-18 02:15:58'),(1694,3687,560,40812,3045,2,67,2,20265.63,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:58','2021-05-18 02:15:58'),(1695,3687,560,40812,3045,2,13,1,116768.63,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:58','2021-05-18 02:15:58');
INSERT INTO `balance_libro_details` VALUES (1696,3687,561,40812,3045,2,96,2,27480.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:53','2021-05-18 02:15:53'),(1697,3687,561,40812,3045,2,67,2,5770.80,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:53','2021-05-18 02:15:53'),(1698,3687,561,40812,3045,2,13,1,33250.80,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:53','2021-05-18 02:15:53'),(1699,3687,562,40812,3045,2,96,2,196100.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:49','2021-05-18 02:15:49'),(1700,3687,562,40812,3045,2,67,2,41181.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:49','2021-05-18 02:15:49'),(1701,3687,562,40812,3045,2,13,1,237281.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:49','2021-05-18 02:15:49'),(1702,3687,563,40812,3045,2,96,2,84768.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:44','2021-05-18 02:15:44'),(1703,3687,563,40812,3045,2,67,2,17801.28,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:44','2021-05-18 02:15:44'),(1704,3687,563,40812,3045,2,13,1,102569.28,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:44','2021-05-18 02:15:44'),(1705,3687,564,40812,3045,2,96,2,6210.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:39','2021-05-18 02:15:39'),(1706,3687,564,40812,3045,2,67,2,1304.10,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:39','2021-05-18 02:15:39'),(1707,3687,564,40812,3045,2,13,1,7514.10,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:39','2021-05-18 02:15:39'),(1708,3687,565,40812,3045,2,96,2,42000.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:35','2021-05-18 02:15:35'),(1709,3687,565,40812,3045,2,67,2,8820.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:35','2021-05-18 02:15:35'),(1710,3687,565,40812,3045,2,13,1,50820.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:35','2021-05-18 02:15:35'),(1711,3687,566,40812,3045,2,96,2,6300.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:30','2021-05-18 02:15:30'),(1712,3687,566,40812,3045,2,67,2,1323.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:30','2021-05-18 02:15:30'),(1713,3687,566,40812,3045,2,13,1,7623.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:30','2021-05-18 02:15:30'),(1714,3687,567,40812,3045,2,96,1,46620.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1715,3687,567,40812,3045,2,68,1,9790.20,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1716,3687,567,40812,3045,2,13,2,56410.20,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1717,3687,568,40812,3045,2,96,2,52851.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1718,3687,568,40812,3045,2,67,2,11098.71,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1719,3687,568,40812,3045,2,13,1,63949.71,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1720,3687,569,40812,3045,2,96,2,24300.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1721,3687,569,40812,3045,2,67,2,5103.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1722,3687,569,40812,3045,2,13,1,29403.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1723,3687,570,40812,3045,2,96,2,38930.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1724,3687,570,40812,3045,2,67,2,8175.30,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1725,3687,570,40812,3045,2,13,1,47105.30,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1726,3687,571,40812,3045,2,96,2,41250.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:23','2021-05-18 02:15:23'),(1727,3687,571,40812,3045,2,67,2,8662.50,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:23','2021-05-18 02:15:23'),(1728,3687,571,40812,3045,2,13,1,49912.50,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:23','2021-05-18 02:15:23'),(1729,3687,572,40812,3045,2,96,2,23940.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:19','2021-05-18 02:15:19'),(1730,3687,572,40812,3045,2,67,2,5027.40,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:19','2021-05-18 02:15:19');
INSERT INTO `balance_libro_details` VALUES (1731,3687,572,40812,3045,2,13,1,28967.40,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:19','2021-05-18 02:15:19'),(1732,3687,573,40812,3045,2,96,2,52590.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:15','2021-05-18 02:15:15'),(1733,3687,573,40812,3045,2,67,2,11043.90,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:15','2021-05-18 02:15:15'),(1734,3687,573,40812,3045,2,13,1,63633.90,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:15','2021-05-18 02:15:15'),(1735,3687,574,40812,3045,2,96,1,1692.60,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:10','2021-05-18 02:15:10'),(1736,3687,574,40812,3045,2,68,1,355.45,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:10','2021-05-18 02:15:10'),(1737,3687,574,40812,3045,2,13,2,2048.05,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:10','2021-05-18 02:15:10'),(1738,3687,575,40812,3045,2,96,2,25235.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:05','2021-05-18 02:15:05'),(1739,3687,575,40812,3045,2,67,2,5299.35,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:05','2021-05-18 02:15:05'),(1740,3687,575,40812,3045,2,13,1,30534.35,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:05','2021-05-18 02:15:05'),(1741,3687,576,40812,3045,2,96,2,17550.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:01','2021-05-18 02:15:01'),(1742,3687,576,40812,3045,2,67,2,3685.50,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:01','2021-05-18 02:15:01'),(1743,3687,576,40812,3045,2,13,1,21235.50,NULL,'2021-05-17 17:44:53','2021-05-18 02:15:01','2021-05-18 02:15:01'),(1744,3687,577,40812,3045,2,96,2,24660.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1745,3687,577,40812,3045,2,67,2,5178.60,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1746,3687,577,40812,3045,2,13,1,29838.60,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1747,3687,578,40812,3045,2,96,2,30805.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1748,3687,578,40812,3045,2,67,2,6469.05,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1749,3687,578,40812,3045,2,13,1,37274.05,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1750,3687,579,40812,3045,2,96,2,55010.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1751,3687,579,40812,3045,2,67,2,11552.10,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1752,3687,579,40812,3045,2,13,1,66562.10,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1753,3687,580,40812,3045,2,96,2,19535.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:55','2021-05-18 02:14:55'),(1754,3687,580,40812,3045,2,67,2,4102.35,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:55','2021-05-18 02:14:55'),(1755,3687,580,40812,3045,2,13,1,23637.35,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:55','2021-05-18 02:14:55'),(1756,3687,581,40812,3045,2,96,2,66823.26,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:49','2021-05-18 02:14:49'),(1757,3687,581,40812,3045,2,67,2,14032.88,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:49','2021-05-18 02:14:49'),(1758,3687,581,40812,3045,2,13,1,80856.14,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:49','2021-05-18 02:14:49'),(1759,3687,582,40812,3045,2,96,2,63386.40,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:44','2021-05-18 02:14:44'),(1760,3687,582,40812,3045,2,67,2,13311.14,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:44','2021-05-18 02:14:44'),(1761,3687,582,40812,3045,2,13,1,76697.54,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:44','2021-05-18 02:14:44'),(1762,3687,583,40812,3045,2,96,2,552589.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:40','2021-05-18 02:14:40'),(1763,3687,583,40812,3045,2,67,2,116043.69,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:40','2021-05-18 02:14:40'),(1764,3687,583,40812,3045,2,13,1,668632.69,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:40','2021-05-18 02:14:40'),(1765,3687,584,40812,3045,2,96,2,15180.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:36','2021-05-18 02:14:36');
INSERT INTO `balance_libro_details` VALUES (1766,3687,584,40812,3045,2,67,2,3187.80,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:36','2021-05-18 02:14:36'),(1767,3687,584,40812,3045,2,13,1,18367.80,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:36','2021-05-18 02:14:36'),(1768,3687,585,40812,3045,2,96,2,30980.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:32','2021-05-18 02:14:32'),(1769,3687,585,40812,3045,2,67,2,6505.80,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:32','2021-05-18 02:14:32'),(1770,3687,585,40812,3045,2,13,1,37485.80,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:32','2021-05-18 02:14:32'),(1771,3687,586,40812,3045,2,96,2,707660.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:27','2021-05-18 02:14:27'),(1772,3687,586,40812,3045,2,67,2,148608.60,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:27','2021-05-18 02:14:27'),(1773,3687,586,40812,3045,2,13,1,856268.60,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:27','2021-05-18 02:14:27'),(1774,3687,587,40812,3045,2,96,2,6060.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1775,3687,587,40812,3045,2,67,2,1272.60,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1776,3687,587,40812,3045,2,13,1,7332.60,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1777,3687,588,40812,3045,2,96,2,24840.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1778,3687,588,40812,3045,2,67,2,5216.40,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1779,3687,588,40812,3045,2,13,1,30056.40,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1780,3687,589,40812,3045,2,96,2,10380.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1781,3687,589,40812,3045,2,67,2,2179.80,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1782,3687,589,40812,3045,2,13,1,12559.80,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1783,3687,590,40812,3045,2,96,2,21600.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1784,3687,590,40812,3045,2,67,2,4536.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1785,3687,590,40812,3045,2,13,1,26136.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1786,3687,591,40812,3045,2,96,2,55940.00,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1787,3687,591,40812,3045,2,67,2,11747.40,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1788,3687,591,40812,3045,2,13,1,67687.40,NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(1789,3687,592,40812,3045,2,96,2,500.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:18','2021-05-18 02:14:18'),(1790,3687,592,40812,3045,2,67,2,105.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:18','2021-05-18 02:14:18'),(1791,3687,592,40812,3045,2,218,2,68111.12,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:18','2021-05-18 02:14:18'),(1792,3687,592,40812,3045,2,13,1,68716.12,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:18','2021-05-18 02:14:18'),(1793,3687,593,40812,3045,2,96,2,34330.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:11','2021-05-18 02:14:11'),(1794,3687,593,40812,3045,2,67,2,7209.30,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:11','2021-05-18 02:14:11'),(1795,3687,593,40812,3045,2,13,1,41539.30,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:11','2021-05-18 02:14:11'),(1796,3687,594,40812,3045,2,96,2,52790.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:04','2021-05-18 02:14:04'),(1797,3687,594,40812,3045,2,67,2,11085.90,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:04','2021-05-18 02:14:04'),(1798,3687,594,40812,3045,2,13,1,63875.90,NULL,'2021-05-17 17:44:53','2021-05-18 02:14:04','2021-05-18 02:14:04'),(1799,3687,595,40812,3045,2,96,2,57035.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:13:45','2021-05-18 02:13:45'),(1800,3687,595,40812,3045,2,67,2,11977.35,NULL,'2021-05-17 17:44:53','2021-05-18 02:13:45','2021-05-18 02:13:45');
INSERT INTO `balance_libro_details` VALUES (1801,3687,595,40812,3045,2,13,1,69012.35,NULL,'2021-05-17 17:44:53','2021-05-18 02:13:45','2021-05-18 02:13:45'),(1802,3687,596,40812,3045,2,96,2,14490.00,NULL,'2021-05-17 17:44:53','2021-05-18 02:13:19','2021-05-18 02:13:19'),(1803,3687,596,40812,3045,2,67,2,3042.90,NULL,'2021-05-17 17:44:53','2021-05-18 02:13:19','2021-05-18 02:13:19'),(1804,3687,596,40812,3045,2,13,1,17532.90,NULL,'2021-05-17 17:44:53','2021-05-18 02:13:19','2021-05-18 02:13:19'),(1805,3687,597,40812,3045,3,250,1,6900.00,NULL,'2021-05-17 17:45:58','2021-05-18 02:23:38','2021-05-18 02:23:38'),(1806,3687,597,40812,3045,3,57,2,6900.00,NULL,'2021-05-17 17:45:58','2021-05-18 02:23:38','2021-05-18 02:23:38'),(1807,3687,598,40812,3045,3,250,1,6400.00,NULL,'2021-05-17 17:48:38','2021-05-17 17:57:30','2021-05-17 17:57:30'),(1808,3687,598,40812,3045,3,57,2,6400.00,NULL,'2021-05-17 17:48:38','2021-05-17 17:57:30','2021-05-17 17:57:30'),(1809,3687,599,40812,3045,3,250,1,6400.00,NULL,'2021-05-17 17:50:37','2021-05-18 02:23:28','2021-05-18 02:23:28'),(1810,3687,599,40812,3045,3,57,2,6400.00,NULL,'2021-05-17 17:50:37','2021-05-18 02:23:28','2021-05-18 02:23:28'),(1811,3687,600,40812,3045,3,217,1,3900.00,NULL,'2021-05-17 17:52:08','2021-05-17 17:53:42','2021-05-17 17:53:42'),(1812,3687,600,40812,3045,3,68,1,819.00,NULL,'2021-05-17 17:52:08','2021-05-17 17:53:42','2021-05-17 17:53:42'),(1813,3687,600,40812,3045,3,217,1,117.00,NULL,'2021-05-17 17:52:08','2021-05-17 17:53:42','2021-05-17 17:53:42'),(1814,3687,600,40812,3045,3,226,1,117.00,NULL,'2021-05-17 17:52:08','2021-05-17 17:53:42','2021-05-17 17:53:42'),(1815,3687,600,40812,3045,3,57,2,4953.00,NULL,'2021-05-17 17:52:08','2021-05-17 17:53:42','2021-05-17 17:53:42'),(1816,3687,601,40812,3045,3,217,1,3900.00,NULL,'2021-05-17 17:53:42','2021-05-18 02:23:14','2021-05-18 02:23:14'),(1817,3687,601,40812,3045,3,68,1,819.00,NULL,'2021-05-17 17:53:42','2021-05-18 02:23:14','2021-05-18 02:23:14'),(1818,3687,601,40812,3045,3,226,1,117.00,NULL,'2021-05-17 17:53:42','2021-05-18 02:23:14','2021-05-18 02:23:14'),(1819,3687,601,40812,3045,3,57,2,4836.00,NULL,'2021-05-17 17:53:42','2021-05-18 02:23:14','2021-05-18 02:23:14'),(1820,3687,602,40812,3045,3,250,2,6900.00,NULL,'2021-05-17 17:54:20','2021-05-18 02:23:08','2021-05-18 02:23:08'),(1821,3687,602,40812,3045,3,57,1,6900.00,NULL,'2021-05-17 17:54:20','2021-05-18 02:23:08','2021-05-18 02:23:08'),(1822,3687,603,40812,3045,3,250,1,12000.00,NULL,'2021-05-17 17:55:29','2021-05-18 02:23:03','2021-05-18 02:23:03'),(1823,3687,603,40812,3045,3,57,2,12000.00,NULL,'2021-05-17 17:55:29','2021-05-18 02:23:03','2021-05-18 02:23:03'),(1824,3687,604,40812,3045,3,250,1,55000.00,NULL,'2021-05-17 17:55:55','2021-05-18 02:22:56','2021-05-18 02:22:56'),(1825,3687,604,40812,3045,3,57,2,55000.00,NULL,'2021-05-17 17:55:55','2021-05-18 02:22:56','2021-05-18 02:22:56'),(1826,3687,605,40812,3045,3,250,1,12000.00,NULL,'2021-05-17 17:56:22','2021-05-18 02:22:50','2021-05-18 02:22:50'),(1827,3687,605,40812,3045,3,57,2,12000.00,NULL,'2021-05-17 17:56:22','2021-05-18 02:22:50','2021-05-18 02:22:50'),(1828,3687,606,40812,3045,3,250,1,7200.00,NULL,'2021-05-17 17:56:55','2021-05-18 02:22:45','2021-05-18 02:22:45'),(1829,3687,606,40812,3045,3,57,2,7200.00,NULL,'2021-05-17 17:56:55','2021-05-18 02:22:45','2021-05-18 02:22:45'),(1830,3687,607,40812,3045,3,250,1,4400.00,NULL,'2021-05-17 17:57:16','2021-05-18 02:22:36','2021-05-18 02:22:36'),(1831,3687,607,40812,3045,3,57,2,4400.00,NULL,'2021-05-17 17:57:16','2021-05-18 02:22:36','2021-05-18 02:22:36'),(1832,3687,608,40812,3045,3,250,1,6400.00,NULL,'2021-05-17 17:57:30','2021-05-18 02:22:25','2021-05-18 02:22:25'),(1833,3687,608,40812,3045,3,57,2,6400.00,NULL,'2021-05-17 17:57:30','2021-05-18 02:22:25','2021-05-18 02:22:25'),(1834,3687,609,40812,3045,3,250,1,990.00,NULL,'2021-05-17 17:57:44','2021-05-18 02:22:15','2021-05-18 02:22:15'),(1835,3687,609,40812,3045,3,57,2,990.00,NULL,'2021-05-17 17:57:44','2021-05-18 02:22:15','2021-05-18 02:22:15');
INSERT INTO `balance_libro_details` VALUES (1836,3687,610,40812,3045,3,250,1,7200.00,NULL,'2021-05-17 17:58:02','2021-05-18 02:21:56','2021-05-18 02:21:56'),(1837,3687,610,40812,3045,3,57,2,7200.00,NULL,'2021-05-17 17:58:02','2021-05-18 02:21:56','2021-05-18 02:21:56'),(1838,3687,611,40812,3045,3,250,1,5600.00,NULL,'2021-05-17 18:00:32','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1839,3687,611,40812,3045,3,57,2,5600.00,NULL,'2021-05-17 18:00:32','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1840,3687,612,40812,3045,3,250,1,6900.00,NULL,'2021-05-17 18:00:51','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1841,3687,612,40812,3045,3,57,2,6900.00,NULL,'2021-05-17 18:00:51','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1842,3687,613,40812,3045,3,250,1,7200.00,NULL,'2021-05-17 18:01:08','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1843,3687,613,40812,3045,3,57,2,7200.00,NULL,'2021-05-17 18:01:08','2021-05-18 13:14:26','2021-05-18 13:14:26'),(1844,3687,614,40812,3045,3,250,1,5200.00,NULL,'2021-05-17 18:01:22','2021-05-18 02:21:23','2021-05-18 02:21:23'),(1845,3687,614,40812,3045,3,57,2,5200.00,NULL,'2021-05-17 18:01:22','2021-05-18 02:21:23','2021-05-18 02:21:23'),(1846,3687,615,40812,3045,3,250,1,120000.00,NULL,'2021-05-17 18:02:00','2021-05-18 02:20:55','2021-05-18 02:20:55'),(1847,3687,615,40812,3045,3,57,2,120000.00,NULL,'2021-05-17 18:02:00','2021-05-18 02:20:55','2021-05-18 02:20:55'),(1848,3687,616,40812,3045,3,250,1,7200.00,NULL,'2021-05-17 18:02:15','2021-05-18 02:20:33','2021-05-18 02:20:33'),(1849,3687,616,40812,3045,3,57,2,7200.00,NULL,'2021-05-17 18:02:15','2021-05-18 02:20:33','2021-05-18 02:20:33'),(1850,3687,617,40812,3045,3,217,1,2561.98,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1851,3687,617,40812,3045,3,68,1,538.02,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1852,3687,617,40812,3045,3,57,2,3100.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1853,3687,618,40812,3045,3,250,1,6900.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:02:53','2021-05-19 02:02:53'),(1854,3687,618,40812,3045,3,57,2,6900.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:02:53','2021-05-19 02:02:53'),(1855,3687,619,40812,3045,3,217,1,4320.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1856,3687,619,40812,3045,3,68,1,907.20,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1857,3687,619,40812,3045,3,57,2,5227.20,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1858,3687,620,40812,3045,3,250,1,6400.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:03:16','2021-05-19 02:03:16'),(1859,3687,620,40812,3045,3,57,2,6400.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:03:16','2021-05-19 02:03:16'),(1860,3687,621,40812,3045,3,217,1,17500.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1861,3687,621,40812,3045,3,68,1,3675.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1862,3687,621,40812,3045,3,57,2,21175.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1863,3687,622,40812,3045,3,217,1,3900.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:06:10','2021-05-19 02:06:10'),(1864,3687,622,40812,3045,3,68,1,819.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:06:10','2021-05-19 02:06:10'),(1865,3687,622,40812,3045,3,217,1,117.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:06:10','2021-05-19 02:06:10'),(1866,3687,622,40812,3045,3,57,2,4836.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:06:10','2021-05-19 02:06:10'),(1867,3687,623,40812,3045,3,250,2,6900.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:08:12','2021-05-19 02:08:12'),(1868,3687,623,40812,3045,3,57,1,6900.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:08:12','2021-05-19 02:08:12'),(1869,3687,624,40812,3045,3,250,1,12000.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:08:43','2021-05-19 02:08:43'),(1870,3687,624,40812,3045,3,57,2,12000.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:08:43','2021-05-19 02:08:43');
INSERT INTO `balance_libro_details` VALUES (1871,3687,625,40812,3045,3,250,1,55000.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:09:08','2021-05-19 02:09:08'),(1872,3687,625,40812,3045,3,57,2,55000.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:09:08','2021-05-19 02:09:08'),(1873,3687,626,40812,3045,3,250,1,12000.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:09:28','2021-05-19 02:09:28'),(1874,3687,626,40812,3045,3,57,2,12000.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:09:28','2021-05-19 02:09:28'),(1875,3687,627,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:10:05','2021-05-19 02:10:05'),(1876,3687,627,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:10:05','2021-05-19 02:10:05'),(1877,3687,628,40812,3045,3,217,1,16942.20,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1878,3687,628,40812,3045,3,68,1,3557.86,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1879,3687,628,40812,3045,3,57,2,20500.06,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1880,3687,629,40812,3045,3,250,1,4400.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:10:18','2021-05-19 02:10:18'),(1881,3687,629,40812,3045,3,57,2,4400.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:10:18','2021-05-19 02:10:18'),(1882,3687,630,40812,3045,3,217,1,15279.53,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1883,3687,630,40812,3045,3,68,1,3208.70,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1884,3687,630,40812,3045,3,57,2,18488.23,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1885,3687,631,40812,3045,3,250,1,6400.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:10:28','2021-05-19 02:10:28'),(1886,3687,631,40812,3045,3,57,2,6400.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:10:28','2021-05-19 02:10:28'),(1887,3687,632,40812,3045,3,250,1,990.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:11:17','2021-05-19 02:11:17'),(1888,3687,632,40812,3045,3,57,2,990.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:11:17','2021-05-19 02:11:17'),(1889,3687,633,40812,3045,3,217,1,1550.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1890,3687,633,40812,3045,3,68,1,325.50,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1891,3687,633,40812,3045,3,57,2,1875.50,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1892,3687,634,40812,3045,3,217,1,3189.60,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1893,3687,634,40812,3045,3,68,1,669.82,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1894,3687,634,40812,3045,3,57,2,3859.42,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1895,3687,635,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:11:33','2021-05-19 02:11:33'),(1896,3687,635,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:11:33','2021-05-19 02:11:33'),(1897,3687,636,40812,3045,3,217,1,6822.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:12:33','2021-05-19 02:12:33'),(1898,3687,636,40812,3045,3,68,1,1841.94,NULL,'2021-05-19 02:00:27','2021-05-19 02:12:33','2021-05-19 02:12:33'),(1899,3687,636,40812,3045,3,217,1,563.71,NULL,'2021-05-19 02:00:27','2021-05-19 02:12:33','2021-05-19 02:12:33'),(1900,3687,636,40812,3045,3,57,2,9227.65,NULL,'2021-05-19 02:00:27','2021-05-19 02:12:33','2021-05-19 02:12:33'),(1901,3687,637,40812,3045,3,217,1,68611.12,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1902,3687,637,40812,3045,3,68,1,105.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1903,3687,637,40812,3045,3,57,2,68716.12,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1904,3687,638,40812,3045,3,217,1,109.05,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1905,3687,638,40812,3045,3,68,1,22.90,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24');
INSERT INTO `balance_libro_details` VALUES (1906,3687,638,40812,3045,3,217,1,0.05,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1907,3687,638,40812,3045,3,57,2,132.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1908,3687,639,40812,3045,3,250,1,5600.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:12:49','2021-05-19 02:12:49'),(1909,3687,639,40812,3045,3,57,2,5600.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:12:49','2021-05-19 02:12:49'),(1910,3687,640,40812,3045,3,250,1,6900.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:01:56','2021-05-19 02:01:56'),(1911,3687,640,40812,3045,3,57,2,6900.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:01:56','2021-05-19 02:01:56'),(1912,3687,641,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:13:28','2021-05-19 02:13:28'),(1913,3687,641,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:13:28','2021-05-19 02:13:28'),(1914,3687,642,40812,3045,3,217,1,39112.21,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1915,3687,642,40812,3045,3,68,1,4106.78,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1916,3687,642,40812,3045,3,57,2,43218.99,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1917,3687,643,40812,3045,3,217,1,923.64,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1918,3687,643,40812,3045,3,68,1,193.96,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1919,3687,643,40812,3045,3,57,2,1117.60,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1920,3687,644,40812,3045,3,250,1,5200.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:13:43','2021-05-19 02:13:43'),(1921,3687,644,40812,3045,3,57,2,5200.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:13:43','2021-05-19 02:13:43'),(1922,3687,645,40812,3045,3,217,1,875418.75,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1923,3687,645,40812,3045,3,68,1,183837.94,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1924,3687,645,40812,3045,3,57,2,1059256.69,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1925,3687,646,40812,3045,3,217,1,246403.00,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1926,3687,646,40812,3045,3,68,1,51744.63,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1927,3687,646,40812,3045,3,57,2,298147.63,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1928,3687,647,40812,3045,3,217,1,554062.50,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1929,3687,647,40812,3045,3,68,1,116353.13,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1930,3687,647,40812,3045,3,57,2,670415.63,NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1931,3687,648,40812,3045,3,250,1,120000.00,NULL,'2021-05-19 02:00:28','2021-05-19 02:02:22','2021-05-19 02:02:22'),(1932,3687,648,40812,3045,3,57,2,120000.00,NULL,'2021-05-19 02:00:28','2021-05-19 02:02:22','2021-05-19 02:02:22'),(1933,3687,649,40812,3045,3,217,1,270441.60,NULL,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1934,3687,649,40812,3045,3,68,1,56792.74,NULL,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1935,3687,649,40812,3045,3,57,2,327234.34,NULL,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1936,3687,650,40812,3045,3,217,1,278930.40,NULL,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1937,3687,650,40812,3045,3,68,1,58575.38,NULL,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1938,3687,650,40812,3045,3,57,2,337505.78,NULL,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1939,3687,651,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:00:28','2021-05-19 02:02:10','2021-05-19 02:02:10'),(1940,3687,651,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:00:28','2021-05-19 02:02:10','2021-05-19 02:02:10');
INSERT INTO `balance_libro_details` VALUES (1941,3687,652,40812,3045,3,250,1,6900.00,NULL,'2021-05-19 02:01:56','2021-05-19 02:13:11','2021-05-19 02:13:11'),(1942,3687,652,40812,3045,3,57,2,6900.00,NULL,'2021-05-19 02:01:56','2021-05-19 02:13:11','2021-05-19 02:13:11'),(1943,3687,653,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:02:10','2021-05-19 02:14:13','2021-05-19 02:14:13'),(1944,3687,653,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:02:10','2021-05-19 02:14:13','2021-05-19 02:14:13'),(1945,3687,654,40812,3045,3,250,1,120000.00,NULL,'2021-05-19 02:02:22','2021-05-19 02:13:56','2021-05-19 02:13:56'),(1946,3687,654,40812,3045,3,57,2,120000.00,NULL,'2021-05-19 02:02:22','2021-05-19 02:13:56','2021-05-19 02:13:56'),(1947,3687,655,40812,3045,3,250,1,6900.00,NULL,'2021-05-19 02:02:53','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1948,3687,655,40812,3045,3,57,2,6900.00,NULL,'2021-05-19 02:02:53','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1949,3687,656,40812,3045,3,250,1,6400.00,NULL,'2021-05-19 02:03:16','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1950,3687,656,40812,3045,3,57,2,6400.00,NULL,'2021-05-19 02:03:16','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1951,3687,657,40812,3045,3,217,1,3900.00,NULL,'2021-05-19 02:06:10','2021-05-19 02:07:37','2021-05-19 02:07:37'),(1952,3687,657,40812,3045,3,68,1,819.00,NULL,'2021-05-19 02:06:10','2021-05-19 02:07:37','2021-05-19 02:07:37'),(1953,3687,657,40812,3045,3,217,1,117.00,NULL,'2021-05-19 02:06:10','2021-05-19 02:07:37','2021-05-19 02:07:37'),(1954,3687,657,40812,3045,3,226,1,117.00,NULL,'2021-05-19 02:06:10','2021-05-19 02:07:37','2021-05-19 02:07:37'),(1955,3687,657,40812,3045,3,57,2,4953.00,NULL,'2021-05-19 02:06:10','2021-05-19 02:07:37','2021-05-19 02:07:37'),(1956,3687,658,40812,3045,3,217,1,3900.00,NULL,'2021-05-19 02:07:37','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1957,3687,658,40812,3045,3,68,1,819.00,NULL,'2021-05-19 02:07:37','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1958,3687,658,40812,3045,3,226,1,117.00,NULL,'2021-05-19 02:07:37','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1959,3687,658,40812,3045,3,57,2,4836.00,NULL,'2021-05-19 02:07:37','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1960,3687,659,40812,3045,3,250,2,6900.00,NULL,'2021-05-19 02:08:12','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1961,3687,659,40812,3045,3,57,1,6900.00,NULL,'2021-05-19 02:08:12','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1962,3687,660,40812,3045,3,250,1,12000.00,NULL,'2021-05-19 02:08:43','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1963,3687,660,40812,3045,3,57,2,12000.00,NULL,'2021-05-19 02:08:43','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1964,3687,661,40812,3045,3,250,1,55000.00,NULL,'2021-05-19 02:09:08','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1965,3687,661,40812,3045,3,57,2,55000.00,NULL,'2021-05-19 02:09:08','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1966,3687,662,40812,3045,3,250,1,12000.00,NULL,'2021-05-19 02:09:28','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1967,3687,662,40812,3045,3,57,2,12000.00,NULL,'2021-05-19 02:09:28','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1968,3687,663,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:10:05','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1969,3687,663,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:10:05','2021-05-19 02:40:23','2021-05-19 02:40:23'),(1970,3687,664,40812,3045,3,250,1,4400.00,NULL,'2021-05-19 02:10:18','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1971,3687,664,40812,3045,3,57,2,4400.00,NULL,'2021-05-19 02:10:18','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1972,3687,665,40812,3045,3,250,1,6400.00,NULL,'2021-05-19 02:10:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1973,3687,665,40812,3045,3,57,2,6400.00,NULL,'2021-05-19 02:10:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1974,3687,666,40812,3045,3,250,1,990.00,NULL,'2021-05-19 02:11:17','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1975,3687,666,40812,3045,3,57,2,990.00,NULL,'2021-05-19 02:11:17','2021-05-19 02:40:24','2021-05-19 02:40:24');
INSERT INTO `balance_libro_details` VALUES (1976,3687,667,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:11:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1977,3687,667,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:11:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1978,3687,668,40812,3045,3,217,1,6822.00,NULL,'2021-05-19 02:12:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1979,3687,668,40812,3045,3,68,1,1841.94,NULL,'2021-05-19 02:12:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1980,3687,668,40812,3045,3,217,1,563.71,NULL,'2021-05-19 02:12:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1981,3687,668,40812,3045,3,57,2,9227.65,NULL,'2021-05-19 02:12:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1982,3687,669,40812,3045,3,250,1,5600.00,NULL,'2021-05-19 02:12:49','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1983,3687,669,40812,3045,3,57,2,5600.00,NULL,'2021-05-19 02:12:49','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1984,3687,670,40812,3045,3,250,1,6900.00,NULL,'2021-05-19 02:13:11','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1985,3687,670,40812,3045,3,57,2,6900.00,NULL,'2021-05-19 02:13:11','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1986,3687,671,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:13:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1987,3687,671,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:13:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1988,3687,672,40812,3045,3,250,1,5200.00,NULL,'2021-05-19 02:13:43','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1989,3687,672,40812,3045,3,57,2,5200.00,NULL,'2021-05-19 02:13:43','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1990,3687,673,40812,3045,3,250,1,120000.00,NULL,'2021-05-19 02:13:56','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1991,3687,673,40812,3045,3,57,2,120000.00,NULL,'2021-05-19 02:13:56','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1992,3687,674,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:14:13','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1993,3687,674,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:14:13','2021-05-19 02:40:24','2021-05-19 02:40:24'),(1994,3687,675,40812,3045,3,217,1,2561.98,NULL,'2021-05-19 02:42:46','2021-05-23 14:06:06','2021-05-23 14:06:06'),(1995,3687,675,40812,3045,3,68,1,538.02,NULL,'2021-05-19 02:42:46','2021-05-23 14:06:06','2021-05-23 14:06:06'),(1996,3687,675,40812,3045,3,57,2,3100.00,NULL,'2021-05-19 02:42:46','2021-05-23 14:06:06','2021-05-23 14:06:06'),(1997,3687,676,40812,3045,3,250,1,6900.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(1998,3687,676,40812,3045,3,57,2,6900.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(1999,3687,677,40812,3045,3,217,1,4320.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2000,3687,677,40812,3045,3,68,1,907.20,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2001,3687,677,40812,3045,3,57,2,5227.20,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2002,3687,678,40812,3045,3,250,1,6400.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2003,3687,678,40812,3045,3,57,2,6400.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2004,3687,679,40812,3045,3,217,1,17500.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2005,3687,679,40812,3045,3,68,1,3675.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2006,3687,679,40812,3045,3,57,2,21175.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2007,3687,680,40812,3045,3,217,1,3900.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2008,3687,680,40812,3045,3,68,1,819.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2009,3687,680,40812,3045,3,217,1,117.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2010,3687,680,40812,3045,3,57,2,4836.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2011,3687,681,40812,3045,3,250,2,6900.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2012,3687,681,40812,3045,3,57,1,6900.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL);
INSERT INTO `balance_libro_details` VALUES (2013,3687,682,40812,3045,3,250,1,12000.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2014,3687,682,40812,3045,3,57,2,12000.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2015,3687,683,40812,3045,3,250,1,55000.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2016,3687,683,40812,3045,3,57,2,55000.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2017,3687,684,40812,3045,3,250,1,12000.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2018,3687,684,40812,3045,3,57,2,12000.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2019,3687,685,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2020,3687,685,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2021,3687,686,40812,3045,3,217,1,16942.20,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2022,3687,686,40812,3045,3,68,1,3557.86,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2023,3687,686,40812,3045,3,57,2,20500.06,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2024,3687,687,40812,3045,3,250,1,4400.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2025,3687,687,40812,3045,3,57,2,4400.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2026,3687,688,40812,3045,3,217,1,15279.53,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2027,3687,688,40812,3045,3,68,1,3208.70,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2028,3687,688,40812,3045,3,57,2,18488.23,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2029,3687,689,40812,3045,3,250,1,6400.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2030,3687,689,40812,3045,3,57,2,6400.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2031,3687,690,40812,3045,3,250,1,990.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2032,3687,690,40812,3045,3,57,2,990.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2033,3687,691,40812,3045,3,217,1,1550.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2034,3687,691,40812,3045,3,68,1,325.50,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2035,3687,691,40812,3045,3,57,2,1875.50,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2036,3687,692,40812,3045,3,217,1,3189.60,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2037,3687,692,40812,3045,3,68,1,669.82,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2038,3687,692,40812,3045,3,57,2,3859.42,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2039,3687,693,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2040,3687,693,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2041,3687,694,40812,3045,3,217,1,6822.00,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2042,3687,694,40812,3045,3,68,1,1841.94,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2043,3687,694,40812,3045,3,217,1,563.71,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2044,3687,694,40812,3045,3,57,2,9227.65,NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(2045,3687,695,40812,3045,3,217,1,68611.12,NULL,'2021-05-19 02:42:46','2021-05-20 18:01:57','2021-05-20 18:01:57'),(2046,3687,695,40812,3045,3,68,1,105.00,NULL,'2021-05-19 02:42:46','2021-05-20 18:01:57','2021-05-20 18:01:57'),(2047,3687,695,40812,3045,3,57,2,68716.12,NULL,'2021-05-19 02:42:46','2021-05-20 18:01:57','2021-05-20 18:01:57'),(2048,3687,696,40812,3045,3,217,1,109.05,NULL,'2021-05-19 02:42:47','2021-05-23 13:02:08','2021-05-23 13:02:08'),(2049,3687,696,40812,3045,3,68,1,22.90,NULL,'2021-05-19 02:42:47','2021-05-23 13:02:08','2021-05-23 13:02:08'),(2050,3687,696,40812,3045,3,217,1,0.05,NULL,'2021-05-19 02:42:47','2021-05-23 13:02:08','2021-05-23 13:02:08'),(2051,3687,696,40812,3045,3,57,2,132.00,NULL,'2021-05-19 02:42:47','2021-05-23 13:02:08','2021-05-23 13:02:08'),(2052,3687,697,40812,3045,3,250,1,5600.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL);
INSERT INTO `balance_libro_details` VALUES (2053,3687,697,40812,3045,3,57,2,5600.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2054,3687,698,40812,3045,3,250,1,6900.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2055,3687,698,40812,3045,3,57,2,6900.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2056,3687,699,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2057,3687,699,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2058,3687,700,40812,3045,3,217,1,39112.21,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2059,3687,700,40812,3045,3,68,1,4106.78,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2060,3687,700,40812,3045,3,57,2,43218.99,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2061,3687,701,40812,3045,3,217,1,923.64,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2062,3687,701,40812,3045,3,68,1,193.96,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2063,3687,701,40812,3045,3,57,2,1117.60,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2064,3687,702,40812,3045,3,250,1,5200.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2065,3687,702,40812,3045,3,57,2,5200.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2066,3687,703,40812,3045,3,217,1,875418.75,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2067,3687,703,40812,3045,3,68,1,183837.94,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2068,3687,703,40812,3045,3,57,2,1059256.69,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2069,3687,704,40812,3045,3,217,1,246403.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2070,3687,704,40812,3045,3,68,1,51744.63,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2071,3687,704,40812,3045,3,57,2,298147.63,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2072,3687,705,40812,3045,3,217,1,554062.50,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2073,3687,705,40812,3045,3,68,1,116353.13,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2074,3687,705,40812,3045,3,57,2,670415.63,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2075,3687,706,40812,3045,3,250,1,120000.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2076,3687,706,40812,3045,3,57,2,120000.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2077,3687,707,40812,3045,3,217,1,270441.60,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2078,3687,707,40812,3045,3,68,1,56792.74,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2079,3687,707,40812,3045,3,57,2,327234.34,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2080,3687,708,40812,3045,3,217,1,278930.40,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2081,3687,708,40812,3045,3,68,1,58575.38,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2082,3687,708,40812,3045,3,57,2,337505.78,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2083,3687,709,40812,3045,3,250,1,7200.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2084,3687,709,40812,3045,3,57,2,7200.00,NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(2085,3687,710,40812,3045,3,217,1,500.00,NULL,'2021-05-20 18:01:57','2021-05-20 18:01:57',NULL),(2086,3687,710,40812,3045,3,68,1,105.00,NULL,'2021-05-20 18:01:57','2021-05-20 18:01:57',NULL),(2087,3687,710,40812,3045,3,217,1,68111.12,NULL,'2021-05-20 18:01:57','2021-05-20 18:01:57',NULL),(2088,3687,710,40812,3045,3,57,2,68716.12,NULL,'2021-05-20 18:01:57','2021-05-20 18:01:57',NULL),(2089,3687,711,40812,3045,3,217,1,1810.00,NULL,'2021-05-20 18:32:43','2021-05-20 18:32:43',NULL),(2090,3687,711,40812,3045,3,57,2,1810.00,NULL,'2021-05-20 18:32:43','2021-05-20 18:32:43',NULL),(2091,3687,712,40812,3045,3,217,1,2646.84,NULL,'2021-05-20 18:35:08','2021-05-20 18:35:08',NULL),(2092,3687,712,40812,3045,3,68,1,555.84,NULL,'2021-05-20 18:35:08','2021-05-20 18:35:08',NULL),(2093,3687,712,40812,3045,3,217,1,698.00,NULL,'2021-05-20 18:35:08','2021-05-20 18:35:08',NULL);
INSERT INTO `balance_libro_details` VALUES (2094,3687,712,40812,3045,3,57,2,3900.68,NULL,'2021-05-20 18:35:08','2021-05-20 18:35:08',NULL),(2095,3687,713,40812,3045,3,217,1,995.20,NULL,'2021-05-20 18:37:14','2021-05-20 18:37:14',NULL),(2096,3687,713,40812,3045,3,68,1,268.70,NULL,'2021-05-20 18:37:14','2021-05-20 18:37:14',NULL),(2097,3687,713,40812,3045,3,57,2,1263.90,NULL,'2021-05-20 18:37:14','2021-05-20 18:37:14',NULL),(2098,3687,714,40812,3045,3,217,1,673.59,NULL,'2021-05-20 18:38:25','2021-05-20 18:38:25',NULL),(2099,3687,714,40812,3045,3,68,1,181.87,NULL,'2021-05-20 18:38:25','2021-05-20 18:38:25',NULL),(2100,3687,714,40812,3045,3,217,1,40.42,NULL,'2021-05-20 18:38:25','2021-05-20 18:38:25',NULL),(2101,3687,714,40812,3045,3,57,2,895.88,NULL,'2021-05-20 18:38:25','2021-05-20 18:38:25',NULL),(2102,3687,715,40812,3045,3,217,1,39735.00,NULL,'2021-05-20 18:41:01','2021-05-20 18:41:01',NULL),(2103,3687,715,40812,3045,3,68,1,8344.35,NULL,'2021-05-20 18:41:01','2021-05-20 18:41:01',NULL),(2104,3687,715,40812,3045,3,217,1,1073.81,NULL,'2021-05-20 18:41:01','2021-05-20 18:41:01',NULL),(2105,3687,715,40812,3045,3,226,1,1192.05,NULL,'2021-05-20 18:41:01','2021-05-20 18:41:01',NULL),(2106,3687,715,40812,3045,3,57,2,50345.21,NULL,'2021-05-20 18:41:01','2021-05-20 18:41:01',NULL),(2107,3687,716,40812,3045,3,217,1,2224.05,NULL,'2021-05-20 18:42:35','2021-05-23 13:56:23','2021-05-23 13:56:23'),(2108,3687,716,40812,3045,3,68,1,467.05,NULL,'2021-05-20 18:42:35','2021-05-23 13:56:23','2021-05-23 13:56:23'),(2109,3687,716,40812,3045,3,217,1,744.64,NULL,'2021-05-20 18:42:35','2021-05-23 13:56:23','2021-05-23 13:56:23'),(2110,3687,716,40812,3045,3,57,2,3435.74,NULL,'2021-05-20 18:42:35','2021-05-23 13:56:23','2021-05-23 13:56:23'),(2111,3687,717,40812,3045,3,217,1,34227.00,NULL,'2021-05-20 18:44:27','2021-05-23 13:57:07','2021-05-23 13:57:07'),(2112,3687,717,40812,3045,3,68,1,7187.67,NULL,'2021-05-20 18:44:27','2021-05-23 13:57:07','2021-05-23 13:57:07'),(2113,3687,717,40812,3045,3,217,1,924.96,NULL,'2021-05-20 18:44:27','2021-05-23 13:57:07','2021-05-23 13:57:07'),(2114,3687,717,40812,3045,3,226,1,1026.81,NULL,'2021-05-20 18:44:27','2021-05-23 13:57:07','2021-05-23 13:57:07'),(2115,3687,717,40812,3045,3,57,2,43366.44,NULL,'2021-05-20 18:44:27','2021-05-23 13:57:07','2021-05-23 13:57:07'),(2116,3687,718,40812,3045,3,217,1,2959.00,NULL,'2021-05-20 18:45:37','2021-05-20 18:45:37',NULL),(2117,3687,718,40812,3045,3,68,1,621.39,NULL,'2021-05-20 18:45:37','2021-05-20 18:45:37',NULL),(2118,3687,718,40812,3045,3,217,1,720.05,NULL,'2021-05-20 18:45:37','2021-05-20 18:45:37',NULL),(2119,3687,718,40812,3045,3,57,2,4300.44,NULL,'2021-05-20 18:45:37','2021-05-20 18:45:37',NULL),(2120,3687,719,40812,3045,3,217,1,530.00,NULL,'2021-05-20 18:47:27','2021-05-20 18:47:27',NULL),(2121,3687,719,40812,3045,3,57,2,530.00,NULL,'2021-05-20 18:47:27','2021-05-20 18:47:27',NULL),(2122,3687,720,40812,3045,3,217,1,842.81,NULL,'2021-05-20 18:50:01','2021-05-20 18:50:01',NULL),(2123,3687,720,40812,3045,3,57,2,842.81,NULL,'2021-05-20 18:50:01','2021-05-20 18:50:01',NULL),(2124,3687,721,40812,3045,3,217,1,704.14,NULL,'2021-05-20 18:51:15','2021-05-20 18:51:15',NULL),(2125,3687,721,40812,3045,3,68,1,190.12,NULL,'2021-05-20 18:51:15','2021-05-20 18:51:15',NULL),(2126,3687,721,40812,3045,3,217,1,202.78,NULL,'2021-05-20 18:51:15','2021-05-20 18:51:15',NULL),(2127,3687,721,40812,3045,3,57,2,1097.04,NULL,'2021-05-20 18:51:15','2021-05-20 18:51:15',NULL),(2128,3687,722,40812,3045,3,217,1,1450.00,NULL,'2021-05-20 18:54:12','2021-05-20 18:54:12',NULL),(2129,3687,722,40812,3045,3,68,1,304.50,NULL,'2021-05-20 18:54:12','2021-05-20 18:54:12',NULL),(2130,3687,722,40812,3045,3,217,1,3901.52,NULL,'2021-05-20 18:54:12','2021-05-20 18:54:12',NULL),(2131,3687,722,40812,3045,3,226,1,1878.80,NULL,'2021-05-20 18:54:12','2021-05-20 18:54:12',NULL),(2132,3687,722,40812,3045,3,57,2,7534.82,NULL,'2021-05-20 18:54:12','2021-05-20 18:54:12',NULL);
INSERT INTO `balance_libro_details` VALUES (2133,3687,723,40812,3045,2,218,2,17119.61,NULL,'2021-05-23 13:12:48','2021-05-23 13:16:16','2021-05-23 13:16:16'),(2134,3687,723,40812,3045,2,218,2,17119.61,NULL,'2021-05-23 13:12:48','2021-05-23 13:16:16','2021-05-23 13:16:16'),(2135,3687,723,40812,3045,2,13,1,34239.22,NULL,'2021-05-23 13:12:48','2021-05-23 13:16:16','2021-05-23 13:16:16'),(2136,3687,724,40812,3045,2,96,2,1949.00,NULL,'2021-05-23 13:16:16','2021-05-23 14:31:16','2021-05-23 14:31:16'),(2137,3687,724,40812,3045,2,67,2,409.29,NULL,'2021-05-23 13:16:16','2021-05-23 14:31:16','2021-05-23 14:31:16'),(2138,3687,724,40812,3045,2,218,2,17119.61,NULL,'2021-05-23 13:16:16','2021-05-23 14:31:16','2021-05-23 14:31:16'),(2139,3687,724,40812,3045,2,226,2,8432.04,NULL,'2021-05-23 13:16:16','2021-05-23 14:31:16','2021-05-23 14:31:16'),(2140,3687,724,40812,3045,2,13,1,27909.94,NULL,'2021-05-23 13:16:16','2021-05-23 14:31:16','2021-05-23 14:31:16'),(2141,3687,725,40812,3045,3,217,1,1581.00,NULL,'2021-05-23 13:24:37','2021-05-23 13:24:37',NULL),(2142,3687,725,40812,3045,3,68,1,332.01,NULL,'2021-05-23 13:24:37','2021-05-23 13:24:37',NULL),(2143,3687,725,40812,3045,3,217,1,16467.50,NULL,'2021-05-23 13:24:37','2021-05-23 13:24:37',NULL),(2144,3687,725,40812,3045,3,226,1,7904.98,NULL,'2021-05-23 13:24:37','2021-05-23 13:24:37',NULL),(2145,3687,725,40812,3045,3,57,2,26285.49,NULL,'2021-05-23 13:24:37','2021-05-23 13:24:37',NULL),(2146,3687,726,40812,3045,3,217,1,2224.05,NULL,'2021-05-23 13:56:23','2021-05-23 13:56:23',NULL),(2147,3687,726,40812,3045,3,68,1,467.05,NULL,'2021-05-23 13:56:23','2021-05-23 13:56:23',NULL),(2148,3687,726,40812,3045,3,217,1,744.64,NULL,'2021-05-23 13:56:23','2021-05-23 13:56:23',NULL),(2149,3687,726,40812,3045,3,57,2,3435.74,NULL,'2021-05-23 13:56:23','2021-05-23 13:56:23',NULL),(2150,3687,727,40812,3045,3,217,1,34227.00,NULL,'2021-05-23 13:57:07','2021-05-23 13:57:07',NULL),(2151,3687,727,40812,3045,3,68,1,7187.67,NULL,'2021-05-23 13:57:07','2021-05-23 13:57:07',NULL),(2152,3687,727,40812,3045,3,217,1,924.96,NULL,'2021-05-23 13:57:07','2021-05-23 13:57:07',NULL),(2153,3687,727,40812,3045,3,226,1,1026.81,NULL,'2021-05-23 13:57:07','2021-05-23 13:57:07',NULL),(2154,3687,727,40812,3045,3,57,2,43366.44,NULL,'2021-05-23 13:57:07','2021-05-23 13:57:07',NULL),(2155,3687,728,40812,3045,2,96,2,15890.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2156,3687,728,40812,3045,2,67,2,3336.90,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2157,3687,728,40812,3045,2,13,1,19226.90,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2158,3687,729,40812,3045,2,96,2,64630.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2159,3687,729,40812,3045,2,67,2,13572.30,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2160,3687,729,40812,3045,2,13,1,78202.30,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2161,3687,730,40812,3045,2,96,2,116800.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2162,3687,730,40812,3045,2,67,2,24528.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2163,3687,730,40812,3045,2,13,1,141328.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2164,3687,731,40812,3045,2,96,2,40255.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2165,3687,731,40812,3045,2,67,2,8453.55,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2166,3687,731,40812,3045,2,13,1,48708.55,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2167,3687,732,40812,3045,2,96,2,52900.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2168,3687,732,40812,3045,2,67,2,11109.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2169,3687,732,40812,3045,2,13,1,64009.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2170,3687,733,40812,3045,2,96,2,6455.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2171,3687,733,40812,3045,2,67,2,1355.55,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2172,3687,733,40812,3045,2,13,1,7810.55,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL);
INSERT INTO `balance_libro_details` VALUES (2173,3687,734,40812,3045,2,96,2,118995.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2174,3687,734,40812,3045,2,67,2,24988.95,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2175,3687,734,40812,3045,2,13,1,143983.95,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2176,3687,735,40812,3045,2,96,2,12420.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2177,3687,735,40812,3045,2,67,2,2608.20,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2178,3687,735,40812,3045,2,13,1,15028.20,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2179,3687,736,40812,3045,2,96,2,56420.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2180,3687,736,40812,3045,2,67,2,11848.20,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2181,3687,736,40812,3045,2,13,1,68268.20,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2182,3687,737,40812,3045,2,96,2,96503.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2183,3687,737,40812,3045,2,67,2,20265.63,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2184,3687,737,40812,3045,2,13,1,116768.63,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2185,3687,738,40812,3045,2,96,2,27480.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2186,3687,738,40812,3045,2,67,2,5770.80,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2187,3687,738,40812,3045,2,13,1,33250.80,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2188,3687,739,40812,3045,2,96,2,196100.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2189,3687,739,40812,3045,2,67,2,41181.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2190,3687,739,40812,3045,2,13,1,237281.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2191,3687,740,40812,3045,2,96,2,84768.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2192,3687,740,40812,3045,2,67,2,17801.28,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2193,3687,740,40812,3045,2,13,1,102569.28,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2194,3687,741,40812,3045,2,96,2,6210.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2195,3687,741,40812,3045,2,67,2,1304.10,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2196,3687,741,40812,3045,2,13,1,7514.10,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2197,3687,742,40812,3045,2,96,2,42000.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2198,3687,742,40812,3045,2,67,2,8820.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2199,3687,742,40812,3045,2,13,1,50820.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2200,3687,743,40812,3045,2,96,2,6300.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2201,3687,743,40812,3045,2,67,2,1323.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2202,3687,743,40812,3045,2,13,1,7623.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2203,3687,744,40812,3045,2,96,1,46620.00,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2204,3687,744,40812,3045,2,68,1,9790.20,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2205,3687,744,40812,3045,2,13,2,56410.20,NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(2206,3687,745,40812,3045,2,96,2,52851.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2207,3687,745,40812,3045,2,67,2,11098.71,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2208,3687,745,40812,3045,2,13,1,63949.71,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2209,3687,746,40812,3045,2,96,2,24300.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2210,3687,746,40812,3045,2,67,2,5103.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2211,3687,746,40812,3045,2,13,1,29403.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2212,3687,747,40812,3045,2,96,2,38930.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2213,3687,747,40812,3045,2,67,2,8175.30,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL);
INSERT INTO `balance_libro_details` VALUES (2214,3687,747,40812,3045,2,13,1,47105.30,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2215,3687,748,40812,3045,2,96,2,41250.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2216,3687,748,40812,3045,2,67,2,8662.50,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2217,3687,748,40812,3045,2,13,1,49912.50,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2218,3687,749,40812,3045,2,96,2,23940.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2219,3687,749,40812,3045,2,67,2,5027.40,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2220,3687,749,40812,3045,2,13,1,28967.40,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2221,3687,750,40812,3045,2,96,2,52590.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2222,3687,750,40812,3045,2,67,2,11043.90,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2223,3687,750,40812,3045,2,13,1,63633.90,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2224,3687,751,40812,3045,2,96,1,1692.60,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2225,3687,751,40812,3045,2,68,1,355.45,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2226,3687,751,40812,3045,2,13,2,2048.05,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2227,3687,752,40812,3045,2,96,2,25235.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2228,3687,752,40812,3045,2,67,2,5299.35,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2229,3687,752,40812,3045,2,13,1,30534.35,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2230,3687,753,40812,3045,2,96,2,17550.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2231,3687,753,40812,3045,2,67,2,3685.50,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2232,3687,753,40812,3045,2,13,1,21235.50,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2233,3687,754,40812,3045,2,96,2,24660.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2234,3687,754,40812,3045,2,67,2,5178.60,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2235,3687,754,40812,3045,2,13,1,29838.60,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2236,3687,755,40812,3045,2,96,2,30805.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2237,3687,755,40812,3045,2,67,2,6469.05,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2238,3687,755,40812,3045,2,13,1,37274.05,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2239,3687,756,40812,3045,2,96,2,55010.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2240,3687,756,40812,3045,2,67,2,11552.10,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2241,3687,756,40812,3045,2,13,1,66562.10,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2242,3687,757,40812,3045,2,96,2,19535.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2243,3687,757,40812,3045,2,67,2,4102.35,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2244,3687,757,40812,3045,2,13,1,23637.35,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2245,3687,758,40812,3045,2,96,2,66823.26,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2246,3687,758,40812,3045,2,67,2,14032.88,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2247,3687,758,40812,3045,2,13,1,80856.14,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2248,3687,759,40812,3045,2,96,2,63386.40,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2249,3687,759,40812,3045,2,67,2,13311.14,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2250,3687,759,40812,3045,2,13,1,76697.54,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2251,3687,760,40812,3045,2,96,2,552589.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2252,3687,760,40812,3045,2,67,2,116043.69,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2253,3687,760,40812,3045,2,13,1,668632.69,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2254,3687,761,40812,3045,2,96,2,15180.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL);
INSERT INTO `balance_libro_details` VALUES (2255,3687,761,40812,3045,2,67,2,3187.80,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2256,3687,761,40812,3045,2,13,1,18367.80,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2257,3687,762,40812,3045,2,96,2,30980.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2258,3687,762,40812,3045,2,67,2,6505.80,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2259,3687,762,40812,3045,2,13,1,37485.80,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2260,3687,763,40812,3045,2,96,2,707660.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2261,3687,763,40812,3045,2,67,2,148608.60,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2262,3687,763,40812,3045,2,13,1,856268.60,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2263,3687,764,40812,3045,2,96,2,6060.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2264,3687,764,40812,3045,2,67,2,1272.60,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2265,3687,764,40812,3045,2,13,1,7332.60,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2266,3687,765,40812,3045,2,96,2,24840.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2267,3687,765,40812,3045,2,67,2,5216.40,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2268,3687,765,40812,3045,2,13,1,30056.40,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2269,3687,766,40812,3045,2,96,2,10380.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2270,3687,766,40812,3045,2,67,2,2179.80,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2271,3687,766,40812,3045,2,13,1,12559.80,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2272,3687,767,40812,3045,2,96,2,21600.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2273,3687,767,40812,3045,2,67,2,4536.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2274,3687,767,40812,3045,2,13,1,26136.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2275,3687,768,40812,3045,2,96,2,55940.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2276,3687,768,40812,3045,2,67,2,11747.40,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2277,3687,768,40812,3045,2,13,1,67687.40,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2278,3687,769,40812,3045,2,96,2,500.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2279,3687,769,40812,3045,2,67,2,105.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2280,3687,769,40812,3045,2,218,2,68111.12,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2281,3687,769,40812,3045,2,13,1,68716.12,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2282,3687,770,40812,3045,2,96,2,34330.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2283,3687,770,40812,3045,2,67,2,7209.30,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2284,3687,770,40812,3045,2,13,1,41539.30,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2285,3687,771,40812,3045,2,96,2,52790.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2286,3687,771,40812,3045,2,67,2,11085.90,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2287,3687,771,40812,3045,2,13,1,63875.90,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2288,3687,772,40812,3045,2,96,2,57035.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2289,3687,772,40812,3045,2,67,2,11977.35,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2290,3687,772,40812,3045,2,13,1,69012.35,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2291,3687,773,40812,3045,2,96,2,14490.00,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2292,3687,773,40812,3045,2,67,2,3042.90,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2293,3687,773,40812,3045,2,13,1,17532.90,NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(2294,3687,774,40720,1534,2,96,2,364605.79,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2295,3687,774,40720,1534,2,67,2,76567.22,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL);
INSERT INTO `balance_libro_details` VALUES (2296,3687,774,40720,1534,2,13,1,441173.01,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2297,3687,775,40720,1534,2,96,2,169421.49,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2298,3687,775,40720,1534,2,67,2,35578.51,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2299,3687,775,40720,1534,2,13,1,205000.00,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2300,3687,776,40720,1534,2,96,2,47674.00,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2301,3687,776,40720,1534,2,67,2,10011.54,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2302,3687,776,40720,1534,2,13,1,57685.54,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2303,3687,777,40720,1534,2,96,2,45206.61,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2304,3687,777,40720,1534,2,67,2,9493.39,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2305,3687,777,40720,1534,2,13,1,54700.00,NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(2306,3687,778,40720,1534,2,96,2,13675.74,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2307,3687,778,40720,1534,2,67,2,2871.91,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2308,3687,778,40720,1534,2,13,1,16547.65,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2309,3687,779,40720,1534,2,96,2,213055.50,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2310,3687,779,40720,1534,2,67,2,44741.66,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2311,3687,779,40720,1534,2,13,1,257797.16,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2312,3687,780,40720,1534,2,96,2,15955.03,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2313,3687,780,40720,1534,2,67,2,3350.56,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2314,3687,780,40720,1534,2,13,1,19305.59,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2315,3687,781,40720,1534,2,96,2,86189.01,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2316,3687,781,40720,1534,2,67,2,18099.69,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2317,3687,781,40720,1534,2,13,1,104288.70,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2318,3687,782,40720,1534,2,96,2,29713.88,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2319,3687,782,40720,1534,2,67,2,6239.91,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2320,3687,782,40720,1534,2,13,1,35953.79,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2321,3687,783,40720,1534,2,96,2,40474.42,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2322,3687,783,40720,1534,2,67,2,8499.63,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2323,3687,783,40720,1534,2,13,1,48974.05,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2324,3687,784,40720,1534,2,96,2,103958.08,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2325,3687,784,40720,1534,2,67,2,21831.20,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2326,3687,784,40720,1534,2,13,1,125789.28,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2327,3687,785,40720,1534,2,96,2,31047.00,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2328,3687,785,40720,1534,2,67,2,6519.87,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2329,3687,785,40720,1534,2,13,1,37566.87,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2330,3687,786,40720,1534,2,96,2,22411.31,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2331,3687,786,40720,1534,2,67,2,4706.38,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2332,3687,786,40720,1534,2,13,1,27117.69,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2333,3687,787,40720,1534,2,96,2,2045.60,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2334,3687,787,40720,1534,2,67,2,429.58,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2335,3687,787,40720,1534,2,13,1,2475.18,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2336,3687,788,40720,1534,2,96,2,85104.00,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL);
INSERT INTO `balance_libro_details` VALUES (2337,3687,788,40720,1534,2,67,2,17871.84,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2338,3687,788,40720,1534,2,13,1,102975.84,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2339,3687,789,40720,1534,2,96,2,24362.86,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2340,3687,789,40720,1534,2,67,2,5116.20,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2341,3687,789,40720,1534,2,13,1,29479.06,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2342,3687,790,40720,1534,2,96,2,33982.50,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2343,3687,790,40720,1534,2,67,2,7136.33,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2344,3687,790,40720,1534,2,13,1,41118.83,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2345,3687,791,40720,1534,2,96,2,10195.16,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2346,3687,791,40720,1534,2,67,2,2140.98,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2347,3687,791,40720,1534,2,13,1,12336.14,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2348,3687,792,40720,1534,2,96,2,24362.86,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2349,3687,792,40720,1534,2,67,2,5116.20,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2350,3687,792,40720,1534,2,13,1,29479.06,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2351,3687,793,40720,1534,2,96,2,213055.50,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2352,3687,793,40720,1534,2,67,2,44741.66,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2353,3687,793,40720,1534,2,13,1,257797.16,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2354,3687,794,40720,1534,2,96,1,24362.86,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2355,3687,794,40720,1534,2,68,1,5116.20,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2356,3687,794,40720,1534,2,13,2,29479.06,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2357,3687,795,40720,1534,2,96,1,213055.50,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2358,3687,795,40720,1534,2,68,1,44741.66,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2359,3687,795,40720,1534,2,13,2,257797.16,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2360,3687,796,40720,1534,2,96,2,23966.94,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2361,3687,796,40720,1534,2,67,2,5033.06,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2362,3687,796,40720,1534,2,13,1,29000.00,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2363,3687,797,40720,1534,2,96,2,6395.15,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2364,3687,797,40720,1534,2,67,2,1342.98,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2365,3687,797,40720,1534,2,13,1,7738.13,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2366,3687,798,40720,1534,2,96,2,236363.64,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2367,3687,798,40720,1534,2,67,2,49636.36,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2368,3687,798,40720,1534,2,13,1,286000.00,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2369,3687,799,40720,1534,2,96,2,33982.50,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2370,3687,799,40720,1534,2,67,2,7136.33,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2371,3687,799,40720,1534,2,13,1,41118.83,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2372,3687,800,40720,1534,2,96,1,33982.50,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2373,3687,800,40720,1534,2,68,1,7136.33,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2374,3687,800,40720,1534,2,13,2,41118.83,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2375,3687,801,40720,1534,2,96,2,353143.98,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2376,3687,801,40720,1534,2,67,2,74160.24,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2377,3687,801,40720,1534,2,13,1,427304.22,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL);
INSERT INTO `balance_libro_details` VALUES (2378,3687,802,40720,1534,2,96,2,126729.75,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2379,3687,802,40720,1534,2,67,2,26613.25,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2380,3687,802,40720,1534,2,13,1,153343.00,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2381,3687,803,40720,1534,2,96,2,2582.39,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2382,3687,803,40720,1534,2,67,2,542.30,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2383,3687,803,40720,1534,2,13,1,3124.69,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2384,3687,804,40720,1534,2,96,2,16589.40,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2385,3687,804,40720,1534,2,67,2,3483.77,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2386,3687,804,40720,1534,2,13,1,20073.17,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2387,3687,805,40720,1534,2,96,2,14143.12,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2388,3687,805,40720,1534,2,67,2,2970.06,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2389,3687,805,40720,1534,2,13,1,17113.18,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2390,3687,806,40720,1534,2,96,2,61872.45,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2391,3687,806,40720,1534,2,67,2,12993.21,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2392,3687,806,40720,1534,2,13,1,74865.66,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2393,3687,807,40720,1534,2,96,2,48299.02,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2394,3687,807,40720,1534,2,67,2,10142.79,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2395,3687,807,40720,1534,2,13,1,58441.81,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2396,3687,808,40720,1534,2,96,2,49649.82,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2397,3687,808,40720,1534,2,67,2,10426.46,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2398,3687,808,40720,1534,2,13,1,60076.28,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2399,3687,809,40720,1534,2,96,2,388.83,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2400,3687,809,40720,1534,2,67,2,81.65,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2401,3687,809,40720,1534,2,13,1,470.48,NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(2402,3687,810,40720,1534,3,217,1,17500.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2403,3687,810,40720,1534,3,68,1,3675.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2404,3687,810,40720,1534,3,57,2,21175.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2405,3687,811,40720,1534,3,217,1,1919442.84,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2406,3687,811,40720,1534,3,68,1,403083.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2407,3687,811,40720,1534,3,57,2,2322525.84,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2408,3687,812,40720,1534,3,217,1,46591.50,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2409,3687,812,40720,1534,3,68,1,9784.22,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2410,3687,812,40720,1534,3,57,2,56375.72,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2411,3687,813,40720,1534,3,217,1,622701.79,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2412,3687,813,40720,1534,3,68,1,130767.38,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2413,3687,813,40720,1534,3,57,2,753469.17,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2414,3687,814,40720,1534,3,217,1,7756.06,NULL,'2021-06-14 12:29:19','2021-06-14 13:36:42','2021-06-14 13:36:42'),(2415,3687,814,40720,1534,3,68,1,2046.14,NULL,'2021-06-14 12:29:19','2021-06-14 13:36:42','2021-06-14 13:36:42'),(2416,3687,814,40720,1534,3,217,1,598.78,NULL,'2021-06-14 12:29:19','2021-06-14 13:36:42','2021-06-14 13:36:42'),(2417,3687,814,40720,1534,3,57,2,10400.98,NULL,'2021-06-14 12:29:19','2021-06-14 13:36:42','2021-06-14 13:36:42');
INSERT INTO `balance_libro_details` VALUES (2418,3687,815,40720,1534,3,250,1,90000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2419,3687,815,40720,1534,3,57,2,90000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2420,3687,816,40720,1534,3,250,1,100000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2421,3687,816,40720,1534,3,57,2,100000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2422,3687,817,40720,1534,3,250,1,100000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:38:01','2021-06-14 12:38:01'),(2423,3687,817,40720,1534,3,57,2,100000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:38:01','2021-06-14 12:38:01'),(2424,3687,818,40720,1534,3,250,1,100000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2425,3687,818,40720,1534,3,57,2,100000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2426,3687,819,40720,1534,3,217,1,1630.17,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2427,3687,819,40720,1534,3,68,1,342.34,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2428,3687,819,40720,1534,3,57,2,1972.51,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2429,3687,820,40720,1534,3,250,1,6000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2430,3687,820,40720,1534,3,57,2,6000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2431,3687,821,40720,1534,3,217,1,12900.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2432,3687,821,40720,1534,3,68,1,2709.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2433,3687,821,40720,1534,3,57,2,15609.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2434,3687,822,40720,1534,3,250,1,1611.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2435,3687,822,40720,1534,3,57,2,1611.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2436,3687,823,40720,1534,3,217,1,805001.90,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2437,3687,823,40720,1534,3,68,1,169050.40,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2438,3687,823,40720,1534,3,57,2,974052.30,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2439,3687,824,40720,1534,3,217,1,31518.55,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2440,3687,824,40720,1534,3,68,1,3309.45,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2441,3687,824,40720,1534,3,57,2,34828.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2442,3687,825,40720,1534,3,217,1,73748.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2443,3687,825,40720,1534,3,68,1,15487.08,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2444,3687,825,40720,1534,3,57,2,89235.08,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2445,3687,826,40720,1534,3,217,1,8082.65,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2446,3687,826,40720,1534,3,68,1,1697.36,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2447,3687,826,40720,1534,3,57,2,9780.01,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2448,3687,827,40720,1534,3,217,1,537190.08,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2449,3687,827,40720,1534,3,68,1,112809.92,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2450,3687,827,40720,1534,3,57,2,650000.00,NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(2451,3687,828,40812,3046,2,96,2,13230.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2452,3687,828,40812,3046,2,67,2,2778.30,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2453,3687,828,40812,3046,2,13,1,16008.30,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2454,3687,829,40812,3046,2,96,2,52230.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2455,3687,829,40812,3046,2,67,2,10968.30,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2456,3687,829,40812,3046,2,13,1,63198.30,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2457,3687,830,40812,3046,2,96,2,190000.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL);
INSERT INTO `balance_libro_details` VALUES (2458,3687,830,40812,3046,2,67,2,39900.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2459,3687,830,40812,3046,2,13,1,229900.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2460,3687,831,40812,3046,2,96,2,13000.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2461,3687,831,40812,3046,2,67,2,2730.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2462,3687,831,40812,3046,2,13,1,15730.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2463,3687,832,40812,3046,2,96,2,31050.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2464,3687,832,40812,3046,2,67,2,6520.50,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2465,3687,832,40812,3046,2,13,1,37570.50,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2466,3687,833,40812,3046,2,96,2,144007.01,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2467,3687,833,40812,3046,2,67,2,30241.47,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2468,3687,833,40812,3046,2,13,1,174248.48,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2469,3687,834,40812,3046,2,96,2,17055.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2470,3687,834,40812,3046,2,67,2,3581.55,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2471,3687,834,40812,3046,2,13,1,20636.55,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2472,3687,835,40812,3046,2,96,2,37481.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2473,3687,835,40812,3046,2,67,2,7871.01,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2474,3687,835,40812,3046,2,13,1,45352.01,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2475,3687,836,40812,3046,2,96,2,47350.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2476,3687,836,40812,3046,2,67,2,9943.50,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2477,3687,836,40812,3046,2,13,1,57293.50,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2478,3687,837,40812,3046,2,96,2,78800.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2479,3687,837,40812,3046,2,67,2,16548.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2480,3687,837,40812,3046,2,13,1,95348.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2481,3687,838,40812,3046,2,96,2,265319.60,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2482,3687,838,40812,3046,2,67,2,55717.12,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2483,3687,838,40812,3046,2,13,1,321036.72,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2484,3687,839,40812,3046,2,96,2,45770.00,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2485,3687,839,40812,3046,2,67,2,9611.70,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2486,3687,839,40812,3046,2,13,1,55381.70,NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(2487,3687,840,40812,3046,2,96,2,25135.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2488,3687,840,40812,3046,2,67,2,5278.35,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2489,3687,840,40812,3046,2,13,1,30413.35,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2490,3687,841,40812,3046,2,96,2,281233.20,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2491,3687,841,40812,3046,2,67,2,59058.97,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2492,3687,841,40812,3046,2,13,1,340292.17,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2493,3687,842,40812,3046,2,96,2,34915.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2494,3687,842,40812,3046,2,67,2,7332.15,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2495,3687,842,40812,3046,2,13,1,42247.15,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2496,3687,843,40812,3046,2,96,2,98010.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2497,3687,843,40812,3046,2,67,2,20582.10,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2498,3687,843,40812,3046,2,13,1,118592.10,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL);
INSERT INTO `balance_libro_details` VALUES (2499,3687,844,40812,3046,2,96,2,28630.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2500,3687,844,40812,3046,2,67,2,6012.30,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2501,3687,844,40812,3046,2,13,1,34642.30,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2502,3687,845,40812,3046,2,96,2,39435.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2503,3687,845,40812,3046,2,67,2,8281.35,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2504,3687,845,40812,3046,2,13,1,47716.35,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2505,3687,846,40812,3046,2,96,2,131570.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2506,3687,846,40812,3046,2,67,2,27629.70,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2507,3687,846,40812,3046,2,13,1,159199.70,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2508,3687,847,40812,3046,2,96,2,9520.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2509,3687,847,40812,3046,2,67,2,1999.20,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2510,3687,847,40812,3046,2,13,1,11519.20,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2511,3687,848,40812,3046,2,96,2,14510.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2512,3687,848,40812,3046,2,67,2,3047.10,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2513,3687,848,40812,3046,2,13,1,17557.10,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2514,3687,849,40812,3046,2,96,2,59770.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2515,3687,849,40812,3046,2,67,2,12551.70,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2516,3687,849,40812,3046,2,13,1,72321.70,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2517,3687,850,40812,3046,2,96,2,40365.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2518,3687,850,40812,3046,2,67,2,8476.65,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2519,3687,850,40812,3046,2,13,1,48841.65,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2520,3687,851,40812,3046,2,96,2,513440.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2521,3687,851,40812,3046,2,67,2,107822.40,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2522,3687,851,40812,3046,2,13,1,621262.40,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2523,3687,852,40812,3046,2,96,2,23800.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2524,3687,852,40812,3046,2,67,2,4998.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2525,3687,852,40812,3046,2,13,1,28798.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2526,3687,853,40812,3046,2,96,2,57440.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2527,3687,853,40812,3046,2,67,2,12062.40,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2528,3687,853,40812,3046,2,13,1,69502.40,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2529,3687,854,40812,3046,2,96,2,26760.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2530,3687,854,40812,3046,2,67,2,5619.60,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2531,3687,854,40812,3046,2,13,1,32379.60,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2532,3687,855,40812,3046,2,96,2,132650.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2533,3687,855,40812,3046,2,67,2,27856.50,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2534,3687,855,40812,3046,2,13,1,160506.50,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2535,3687,856,40812,3046,2,96,2,133772.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2536,3687,856,40812,3046,2,67,2,28092.12,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2537,3687,856,40812,3046,2,13,1,161864.12,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2538,3687,857,40812,3046,2,96,2,46400.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2539,3687,857,40812,3046,2,67,2,9744.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL);
INSERT INTO `balance_libro_details` VALUES (2540,3687,857,40812,3046,2,13,1,56144.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2541,3687,858,40812,3046,2,96,2,23460.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2542,3687,858,40812,3046,2,67,2,4926.60,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2543,3687,858,40812,3046,2,13,1,28386.60,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2544,3687,859,40812,3046,2,96,2,17845.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2545,3687,859,40812,3046,2,67,2,3747.45,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2546,3687,859,40812,3046,2,13,1,21592.45,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2547,3687,860,40812,3046,2,96,2,14675.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2548,3687,860,40812,3046,2,67,2,3081.75,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2549,3687,860,40812,3046,2,13,1,17756.75,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2550,3687,861,40812,3046,2,96,2,87450.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2551,3687,861,40812,3046,2,67,2,18364.50,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2552,3687,861,40812,3046,2,13,1,105814.50,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2553,3687,862,40812,3046,2,96,2,21800.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2554,3687,862,40812,3046,2,67,2,4578.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2555,3687,862,40812,3046,2,13,1,26378.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2556,3687,863,40812,3046,2,96,2,9530.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2557,3687,863,40812,3046,2,67,2,2001.30,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2558,3687,863,40812,3046,2,13,1,11531.30,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2559,3687,864,40812,3046,2,96,2,34350.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2560,3687,864,40812,3046,2,67,2,7213.50,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2561,3687,864,40812,3046,2,13,1,41563.50,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2562,3687,865,40812,3046,2,96,2,55165.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2563,3687,865,40812,3046,2,67,2,11584.65,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2564,3687,865,40812,3046,2,13,1,66749.65,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2565,3687,866,40812,3046,2,96,2,213091.20,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2566,3687,866,40812,3046,2,67,2,44749.15,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2567,3687,866,40812,3046,2,13,1,257840.35,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2568,3687,867,40812,3046,2,96,2,44440.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2569,3687,867,40812,3046,2,67,2,9332.40,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2570,3687,867,40812,3046,2,13,1,53772.40,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2571,3687,868,40812,3046,2,96,2,35700.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2572,3687,868,40812,3046,2,67,2,7497.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2573,3687,868,40812,3046,2,13,1,43197.00,NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(2574,3687,869,40812,3046,3,217,1,3801.65,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2575,3687,869,40812,3046,3,68,1,798.35,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2576,3687,869,40812,3046,3,57,2,4600.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2577,3687,870,40812,3046,3,217,1,17500.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2578,3687,870,40812,3046,3,68,1,3675.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2579,3687,870,40812,3046,3,57,2,21175.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59');
INSERT INTO `balance_libro_details` VALUES (2580,3687,871,40812,3046,3,217,1,4320.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2581,3687,871,40812,3046,3,68,1,907.20,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2582,3687,871,40812,3046,3,57,2,5227.20,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2583,3687,872,40812,3046,3,250,1,12000.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2584,3687,872,40812,3046,3,57,2,12000.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2585,3687,873,40812,3046,3,250,1,6000.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2586,3687,873,40812,3046,3,57,2,6000.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2587,3687,874,40812,3046,3,250,1,12000.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2588,3687,874,40812,3046,3,57,2,12000.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2589,3687,875,40812,3046,3,217,1,3900.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2590,3687,875,40812,3046,3,68,1,819.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2591,3687,875,40812,3046,3,217,1,117.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2592,3687,875,40812,3046,3,57,2,4836.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2593,3687,876,40812,3046,3,250,1,6400.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2594,3687,876,40812,3046,3,57,2,6400.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2595,3687,877,40812,3046,3,250,1,6400.00,NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2596,3687,877,40812,3046,3,57,2,6400.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2597,3687,878,40812,3046,3,217,1,2300.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2598,3687,878,40812,3046,3,68,1,483.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2599,3687,878,40812,3046,3,57,2,2783.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2600,3687,879,40812,3046,3,217,1,7851.24,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2601,3687,879,40812,3046,3,68,1,1648.76,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2602,3687,879,40812,3046,3,57,2,9500.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2603,3687,880,40812,3046,3,250,1,55000.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2604,3687,880,40812,3046,3,57,2,55000.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2605,3687,881,40812,3046,3,217,1,181764.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2606,3687,881,40812,3046,3,68,1,38170.44,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2607,3687,881,40812,3046,3,57,2,219934.44,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2608,3687,882,40812,3046,3,250,1,47400.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2609,3687,882,40812,3046,3,57,2,47400.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2610,3687,883,40812,3046,3,217,1,428634.50,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2611,3687,883,40812,3046,3,68,1,90013.24,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2612,3687,883,40812,3046,3,57,2,518647.74,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2613,3687,884,40812,3046,3,250,1,7200.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2614,3687,884,40812,3046,3,57,2,7200.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59');
INSERT INTO `balance_libro_details` VALUES (2615,3687,885,40812,3046,3,250,1,6400.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2616,3687,885,40812,3046,3,57,2,6400.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2617,3687,886,40812,3046,3,217,1,407.08,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2618,3687,886,40812,3046,3,68,1,85.49,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2619,3687,886,40812,3046,3,57,2,492.57,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2620,3687,887,40812,3046,3,217,1,7451.74,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2621,3687,887,40812,3046,3,68,1,2011.97,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2622,3687,887,40812,3046,3,217,1,615.74,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2623,3687,887,40812,3046,3,57,2,10079.45,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2624,3687,888,40812,3046,3,250,1,8800.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2625,3687,888,40812,3046,3,57,2,8800.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2626,3687,889,40812,3046,3,217,1,41262.45,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2627,3687,889,40812,3046,3,68,1,4332.56,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2628,3687,889,40812,3046,3,57,2,45595.01,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2629,3687,890,40812,3046,3,217,1,1800.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2630,3687,890,40812,3046,3,68,1,378.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2631,3687,890,40812,3046,3,57,2,2178.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2632,3687,891,40812,3046,3,217,1,271153.60,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2633,3687,891,40812,3046,3,68,1,56942.26,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2634,3687,891,40812,3046,3,57,2,328095.86,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2635,3687,892,40812,3046,3,217,1,182170.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2636,3687,892,40812,3046,3,68,1,38255.70,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2637,3687,892,40812,3046,3,57,2,220425.70,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2638,3687,893,40812,3046,3,250,1,150000.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2639,3687,893,40812,3046,3,57,2,150000.00,NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(2640,3687,894,40720,1534,3,250,1,100000.00,NULL,'2021-06-14 12:38:01','2021-06-14 12:38:01',NULL),(2641,3687,894,40720,1534,3,57,2,100000.00,NULL,'2021-06-14 12:38:01','2021-06-14 12:38:01',NULL),(2642,3687,895,40720,1534,3,250,1,978.80,NULL,'2021-06-14 13:12:49','2021-06-14 13:12:49',NULL),(2643,3687,895,40720,1534,3,57,2,978.80,NULL,'2021-06-14 13:12:49','2021-06-14 13:12:49',NULL),(2644,3687,896,40720,1534,3,250,1,1087.17,NULL,'2021-06-14 13:16:11','2021-06-14 13:16:11',NULL),(2645,3687,896,40720,1534,3,57,2,1087.17,NULL,'2021-06-14 13:16:11','2021-06-14 13:16:11',NULL),(2646,3687,897,40720,1534,3,217,1,203542.61,NULL,'2021-06-14 13:19:01','2021-06-14 13:19:01',NULL),(2647,3687,897,40720,1534,3,68,1,42743.95,NULL,'2021-06-14 13:19:01','2021-06-14 13:19:01',NULL),(2648,3687,897,40720,1534,3,57,2,246286.56,NULL,'2021-06-14 13:19:01','2021-06-14 13:19:01',NULL),(2649,3687,898,40720,1534,3,250,1,267.32,NULL,'2021-06-14 13:20:16','2021-06-14 13:20:16',NULL),(2650,3687,898,40720,1534,3,57,2,267.32,NULL,'2021-06-14 13:20:16','2021-06-14 13:20:16',NULL),(2651,3687,899,40720,1534,3,217,1,1278.04,NULL,'2021-06-14 13:22:07','2021-06-14 13:22:07',NULL);
INSERT INTO `balance_libro_details` VALUES (2652,3687,899,40720,1534,3,68,1,345.07,NULL,'2021-06-14 13:22:07','2021-06-14 13:22:07',NULL),(2653,3687,899,40720,1534,3,57,2,1623.11,NULL,'2021-06-14 13:22:07','2021-06-14 13:22:07',NULL),(2654,3687,900,40720,1534,3,217,1,2342.12,NULL,'2021-06-14 13:24:46','2021-06-14 13:24:46',NULL),(2655,3687,900,40720,1534,3,68,1,491.85,NULL,'2021-06-14 13:24:46','2021-06-14 13:24:46',NULL),(2656,3687,900,40720,1534,3,217,1,566.04,NULL,'2021-06-14 13:24:46','2021-06-14 13:24:46',NULL),(2657,3687,900,40720,1534,3,57,2,3400.01,NULL,'2021-06-14 13:24:46','2021-06-14 13:24:46',NULL),(2658,3687,901,40720,1534,3,217,1,2927.84,NULL,'2021-06-14 13:27:54','2021-06-14 13:27:54',NULL),(2659,3687,901,40720,1534,3,68,1,614.85,NULL,'2021-06-14 13:27:54','2021-06-14 13:27:54',NULL),(2660,3687,901,40720,1534,3,217,1,31921.20,NULL,'2021-06-14 13:27:54','2021-06-14 13:27:54',NULL),(2661,3687,901,40720,1534,3,226,1,15722.32,NULL,'2021-06-14 13:27:54','2021-06-14 13:27:54',NULL),(2662,3687,901,40720,1534,3,57,2,51186.21,NULL,'2021-06-14 13:27:54','2021-06-14 13:27:54',NULL),(2663,3687,902,40720,1534,3,217,1,6956.07,NULL,'2021-06-14 13:36:42','2021-06-14 13:42:23','2021-06-14 13:42:23'),(2664,3687,902,40720,1534,3,68,1,1878.14,NULL,'2021-06-14 13:36:42','2021-06-14 13:42:23','2021-06-14 13:42:23'),(2665,3687,902,40720,1534,3,217,1,800.00,NULL,'2021-06-14 13:36:42','2021-06-14 13:42:23','2021-06-14 13:42:23'),(2666,3687,902,40720,1534,3,68,1,168.00,NULL,'2021-06-14 13:36:42','2021-06-14 13:42:23','2021-06-14 13:42:23'),(2667,3687,902,40720,1534,3,217,1,366.10,NULL,'2021-06-14 13:36:42','2021-06-14 13:42:23','2021-06-14 13:42:23'),(2668,3687,902,40720,1534,3,226,1,232.67,NULL,'2021-06-14 13:36:42','2021-06-14 13:42:23','2021-06-14 13:42:23'),(2669,3687,902,40720,1534,3,57,2,10400.98,NULL,'2021-06-14 13:36:42','2021-06-14 13:42:23','2021-06-14 13:42:23'),(2670,3687,903,40720,1534,3,217,1,6956.07,NULL,'2021-06-14 13:42:23','2021-06-14 13:42:23',NULL),(2671,3687,903,40720,1534,3,68,1,1878.14,NULL,'2021-06-14 13:42:23','2021-06-14 13:42:23',NULL),(2672,3687,903,40720,1534,3,217,1,800.00,NULL,'2021-06-14 13:42:23','2021-06-14 13:42:23',NULL),(2673,3687,903,40720,1534,3,68,1,168.00,NULL,'2021-06-14 13:42:23','2021-06-14 13:42:23',NULL),(2674,3687,903,40720,1534,3,217,1,366.10,NULL,'2021-06-14 13:42:23','2021-06-14 13:42:23',NULL),(2675,3687,903,40720,1534,3,220,1,232.67,NULL,'2021-06-14 13:42:23','2021-06-14 13:42:23',NULL),(2676,3687,903,40720,1534,3,57,2,10400.98,NULL,'2021-06-14 13:42:23','2021-06-14 13:42:23',NULL),(2677,3687,904,40812,3046,3,217,1,3801.65,NULL,'2021-06-20 13:38:15','2021-06-20 15:11:40','2021-06-20 15:11:40'),(2678,3687,904,40812,3046,3,68,1,798.35,NULL,'2021-06-20 13:38:15','2021-06-20 15:11:40','2021-06-20 15:11:40'),(2679,3687,904,40812,3046,3,57,2,4600.00,NULL,'2021-06-20 13:38:15','2021-06-20 15:11:40','2021-06-20 15:11:40'),(2680,3687,905,40812,3046,3,217,1,17500.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2681,3687,905,40812,3046,3,68,1,3675.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2682,3687,905,40812,3046,3,57,2,21175.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2683,3687,906,40812,3046,3,217,1,4320.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2684,3687,906,40812,3046,3,68,1,907.20,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2685,3687,906,40812,3046,3,57,2,5227.20,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2686,3687,907,40812,3046,3,250,1,12000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:42:25','2021-06-20 13:42:25'),(2687,3687,907,40812,3046,3,57,2,12000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:42:25','2021-06-20 13:42:25'),(2688,3687,908,40812,3046,3,250,1,6000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:43:06','2021-06-20 13:43:06'),(2689,3687,908,40812,3046,3,57,2,6000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:43:06','2021-06-20 13:43:06');
INSERT INTO `balance_libro_details` VALUES (2690,3687,909,40812,3046,3,250,1,12000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:43:35','2021-06-20 13:43:35'),(2691,3687,909,40812,3046,3,57,2,12000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:43:35','2021-06-20 13:43:35'),(2692,3687,910,40812,3046,3,217,1,3900.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:44:37','2021-06-20 13:44:37'),(2693,3687,910,40812,3046,3,68,1,819.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:44:37','2021-06-20 13:44:37'),(2694,3687,910,40812,3046,3,217,1,117.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:44:37','2021-06-20 13:44:37'),(2695,3687,910,40812,3046,3,57,2,4836.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:44:37','2021-06-20 13:44:37'),(2696,3687,911,40812,3046,3,250,1,6400.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:45:25','2021-06-20 13:45:25'),(2697,3687,911,40812,3046,3,57,2,6400.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:45:25','2021-06-20 13:45:25'),(2698,3687,912,40812,3046,3,250,1,6400.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:45:33','2021-06-20 13:45:33'),(2699,3687,912,40812,3046,3,57,2,6400.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:45:33','2021-06-20 13:45:33'),(2700,3687,913,40812,3046,3,217,1,2300.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2701,3687,913,40812,3046,3,68,1,483.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2702,3687,913,40812,3046,3,57,2,2783.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2703,3687,914,40812,3046,3,217,1,7851.24,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2704,3687,914,40812,3046,3,68,1,1648.76,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2705,3687,914,40812,3046,3,57,2,9500.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2706,3687,915,40812,3046,3,250,1,55000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:46:10','2021-06-20 13:46:10'),(2707,3687,915,40812,3046,3,57,2,55000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:46:10','2021-06-20 13:46:10'),(2708,3687,916,40812,3046,3,217,1,181764.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2709,3687,916,40812,3046,3,68,1,38170.44,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2710,3687,916,40812,3046,3,57,2,219934.44,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2711,3687,917,40812,3046,3,250,1,47400.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:46:35','2021-06-20 13:46:35'),(2712,3687,917,40812,3046,3,57,2,47400.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:46:35','2021-06-20 13:46:35'),(2713,3687,918,40812,3046,3,217,1,428634.50,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2714,3687,918,40812,3046,3,68,1,90013.24,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2715,3687,918,40812,3046,3,57,2,518647.74,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2716,3687,919,40812,3046,3,250,1,7200.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:46:52','2021-06-20 13:46:52'),(2717,3687,919,40812,3046,3,57,2,7200.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:46:52','2021-06-20 13:46:52'),(2718,3687,920,40812,3046,3,250,1,6400.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:47:08','2021-06-20 13:47:08'),(2719,3687,920,40812,3046,3,57,2,6400.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:47:08','2021-06-20 13:47:08'),(2720,3687,921,40812,3046,3,217,1,407.08,NULL,'2021-06-20 13:38:15','2021-06-22 17:59:01','2021-06-22 17:59:01'),(2721,3687,921,40812,3046,3,68,1,85.49,NULL,'2021-06-20 13:38:15','2021-06-22 17:59:01','2021-06-22 17:59:01'),(2722,3687,921,40812,3046,3,57,2,492.57,NULL,'2021-06-20 13:38:15','2021-06-22 17:59:01','2021-06-22 17:59:01'),(2723,3687,922,40812,3046,3,217,1,7451.74,NULL,'2021-06-20 13:38:15','2021-06-20 13:48:42','2021-06-20 13:48:42'),(2724,3687,922,40812,3046,3,68,1,2011.97,NULL,'2021-06-20 13:38:15','2021-06-20 13:48:42','2021-06-20 13:48:42'),(2725,3687,922,40812,3046,3,217,1,615.74,NULL,'2021-06-20 13:38:15','2021-06-20 13:48:42','2021-06-20 13:48:42'),(2726,3687,922,40812,3046,3,57,2,10079.45,NULL,'2021-06-20 13:38:15','2021-06-20 13:48:42','2021-06-20 13:48:42');
INSERT INTO `balance_libro_details` VALUES (2727,3687,923,40812,3046,3,250,1,8800.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:48:59','2021-06-20 13:48:59'),(2728,3687,923,40812,3046,3,57,2,8800.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:48:59','2021-06-20 13:48:59'),(2729,3687,924,40812,3046,3,217,1,41262.45,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2730,3687,924,40812,3046,3,68,1,4332.56,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2731,3687,924,40812,3046,3,57,2,45595.01,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2732,3687,925,40812,3046,3,217,1,1800.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2733,3687,925,40812,3046,3,68,1,378.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2734,3687,925,40812,3046,3,57,2,2178.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2735,3687,926,40812,3046,3,217,1,271153.60,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2736,3687,926,40812,3046,3,68,1,56942.26,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2737,3687,926,40812,3046,3,57,2,328095.86,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2738,3687,927,40812,3046,3,217,1,182170.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2739,3687,927,40812,3046,3,68,1,38255.70,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2740,3687,927,40812,3046,3,57,2,220425.70,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2741,3687,928,40812,3046,3,250,1,150000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:49:28','2021-06-20 13:49:28'),(2742,3687,928,40812,3046,3,57,2,150000.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:49:28','2021-06-20 13:49:28'),(2743,3687,929,40812,3046,3,250,1,1810.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2744,3687,929,40812,3046,3,57,2,1810.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2745,3687,930,40812,3046,3,250,1,0.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2746,3687,930,40812,3046,3,250,1,790.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2747,3687,930,40812,3046,3,57,2,790.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2748,3687,931,40812,3046,3,217,1,2958.69,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2749,3687,931,40812,3046,3,68,1,621.32,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2750,3687,931,40812,3046,3,217,1,719.99,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2751,3687,931,40812,3046,3,57,2,4300.00,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2752,3687,932,40812,3046,3,217,1,761.97,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2753,3687,932,40812,3046,3,68,1,205.73,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2754,3687,932,40812,3046,3,217,1,45.72,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2755,3687,932,40812,3046,3,57,2,1013.42,NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(2756,3687,933,40812,3046,3,217,1,1033.23,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2757,3687,933,40812,3046,3,68,1,278.97,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2758,3687,933,40812,3046,3,57,2,1312.20,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2759,3687,934,40812,3046,3,250,1,0.00,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2760,3687,934,40812,3046,3,250,1,994.50,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2761,3687,934,40812,3046,3,57,2,994.50,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2762,3687,935,40812,3046,3,250,1,0.00,NULL,'2021-06-20 13:38:16','2021-06-22 16:53:43','2021-06-22 16:53:43'),(2763,3687,935,40812,3046,3,250,1,711.22,NULL,'2021-06-20 13:38:16','2021-06-22 16:53:43','2021-06-22 16:53:43'),(2764,3687,935,40812,3046,3,57,2,711.22,NULL,'2021-06-20 13:38:16','2021-06-22 16:53:43','2021-06-22 16:53:43'),(2765,3687,936,40812,3046,3,250,1,0.00,NULL,'2021-06-20 13:38:16','2021-06-22 16:53:24','2021-06-22 16:53:24'),(2766,3687,936,40812,3046,3,250,1,1307.61,NULL,'2021-06-20 13:38:16','2021-06-22 16:53:24','2021-06-22 16:53:24');
INSERT INTO `balance_libro_details` VALUES (2767,3687,936,40812,3046,3,57,2,1307.61,NULL,'2021-06-20 13:38:16','2021-06-22 16:53:24','2021-06-22 16:53:24'),(2768,3687,937,40812,3046,3,250,1,0.00,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2769,3687,937,40812,3046,3,250,1,835.89,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2770,3687,937,40812,3046,3,57,2,835.89,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2771,3687,938,40812,3046,3,217,1,722.77,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2772,3687,938,40812,3046,3,68,1,195.15,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2773,3687,938,40812,3046,3,217,1,203.98,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2774,3687,938,40812,3046,3,57,2,1121.90,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2775,3687,939,40812,3046,3,217,1,1450.00,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2776,3687,939,40812,3046,3,68,1,304.50,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2777,3687,939,40812,3046,3,217,1,889.77,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2778,3687,939,40812,3046,3,217,1,395.40,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2779,3687,939,40812,3046,3,57,2,3039.67,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2780,3687,940,40812,3046,3,217,1,3680.48,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2781,3687,940,40812,3046,3,68,1,772.91,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2782,3687,940,40812,3046,3,217,1,18929.50,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2783,3687,940,40812,3046,3,217,1,9118.09,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2784,3687,940,40812,3046,3,57,2,32500.98,NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(2785,3687,941,40812,3046,3,250,1,12000.00,NULL,'2021-06-20 13:42:25','2021-06-20 13:42:25',NULL),(2786,3687,941,40812,3046,3,57,2,12000.00,NULL,'2021-06-20 13:42:25','2021-06-20 13:42:25',NULL),(2787,3687,942,40812,3046,3,250,1,6000.00,NULL,'2021-06-20 13:43:06','2021-06-20 13:43:06',NULL),(2788,3687,942,40812,3046,3,57,2,6000.00,NULL,'2021-06-20 13:43:06','2021-06-20 13:43:06',NULL),(2789,3687,943,40812,3046,3,250,1,12000.00,NULL,'2021-06-20 13:43:35','2021-06-20 13:43:35',NULL),(2790,3687,943,40812,3046,3,57,2,12000.00,NULL,'2021-06-20 13:43:35','2021-06-20 13:43:35',NULL),(2791,3687,944,40812,3046,3,217,1,3900.00,NULL,'2021-06-20 13:44:37','2021-06-20 13:44:37',NULL),(2792,3687,944,40812,3046,3,68,1,819.00,NULL,'2021-06-20 13:44:37','2021-06-20 13:44:37',NULL),(2793,3687,944,40812,3046,3,226,1,117.00,NULL,'2021-06-20 13:44:37','2021-06-20 13:44:37',NULL),(2794,3687,944,40812,3046,3,57,2,4836.00,NULL,'2021-06-20 13:44:37','2021-06-20 13:44:37',NULL),(2795,3687,945,40812,3046,3,250,1,6400.00,NULL,'2021-06-20 13:45:25','2021-06-20 13:45:41','2021-06-20 13:45:41'),(2796,3687,945,40812,3046,3,57,2,6400.00,NULL,'2021-06-20 13:45:25','2021-06-20 13:45:41','2021-06-20 13:45:41'),(2797,3687,946,40812,3046,3,250,1,6400.00,NULL,'2021-06-20 13:45:33','2021-06-20 13:45:33',NULL),(2798,3687,946,40812,3046,3,57,2,6400.00,NULL,'2021-06-20 13:45:33','2021-06-20 13:45:33',NULL),(2799,3687,947,40812,3046,3,250,1,6400.00,NULL,'2021-06-20 13:45:41','2021-06-20 13:45:41',NULL),(2800,3687,947,40812,3046,3,57,2,6400.00,NULL,'2021-06-20 13:45:41','2021-06-20 13:45:41',NULL),(2801,3687,948,40812,3046,3,250,1,55000.00,NULL,'2021-06-20 13:46:10','2021-06-20 13:46:10',NULL),(2802,3687,948,40812,3046,3,57,2,55000.00,NULL,'2021-06-20 13:46:10','2021-06-20 13:46:10',NULL),(2803,3687,949,40812,3046,3,250,1,47400.00,NULL,'2021-06-20 13:46:35','2021-06-20 13:46:35',NULL),(2804,3687,949,40812,3046,3,57,2,47400.00,NULL,'2021-06-20 13:46:35','2021-06-20 13:46:35',NULL),(2805,3687,950,40812,3046,3,250,1,7200.00,NULL,'2021-06-20 13:46:52','2021-06-20 13:46:52',NULL),(2806,3687,950,40812,3046,3,57,2,7200.00,NULL,'2021-06-20 13:46:52','2021-06-20 13:46:52',NULL),(2807,3687,951,40812,3046,3,250,1,6400.00,NULL,'2021-06-20 13:47:08','2021-06-20 13:47:08',NULL);
INSERT INTO `balance_libro_details` VALUES (2808,3687,951,40812,3046,3,57,2,6400.00,NULL,'2021-06-20 13:47:08','2021-06-20 13:47:08',NULL),(2809,3687,952,40812,3046,3,217,1,7451.74,NULL,'2021-06-20 13:48:42','2021-06-20 13:48:42',NULL),(2810,3687,952,40812,3046,3,68,1,2011.97,NULL,'2021-06-20 13:48:42','2021-06-20 13:48:42',NULL),(2811,3687,952,40812,3046,3,217,1,392.19,NULL,'2021-06-20 13:48:42','2021-06-20 13:48:42',NULL),(2812,3687,952,40812,3046,3,220,1,223.55,NULL,'2021-06-20 13:48:42','2021-06-20 13:48:42',NULL),(2813,3687,952,40812,3046,3,57,2,10079.45,NULL,'2021-06-20 13:48:42','2021-06-20 13:48:42',NULL),(2814,3687,953,40812,3046,3,250,1,8800.00,NULL,'2021-06-20 13:48:59','2021-06-20 13:48:59',NULL),(2815,3687,953,40812,3046,3,57,2,8800.00,NULL,'2021-06-20 13:48:59','2021-06-20 13:48:59',NULL),(2816,3687,954,40812,3046,3,250,1,150000.00,NULL,'2021-06-20 13:49:28','2021-06-20 13:49:28',NULL),(2817,3687,954,40812,3046,3,57,2,150000.00,NULL,'2021-06-20 13:49:28','2021-06-20 13:49:28',NULL),(2818,3687,955,40812,3046,3,217,1,4600.00,NULL,'2021-06-20 15:11:40','2021-06-20 15:11:40',NULL),(2819,3687,955,40812,3046,3,57,2,4600.00,NULL,'2021-06-20 15:11:40','2021-06-20 15:11:40',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2021-04-02 13:48:54',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2021-04-02 13:48:54',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2021-04-02 13:48:54',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2021-04-02 13:48:54','2021-04-02 13:48:54',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2021-06-15 20:43:22','2021-06-30 13:13:40',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2021-06-15 20:43:22','2021-06-30 13:13:40',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2021-06-15 20:43:22','2021-06-30 13:13:40',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2021-06-15 20:43:22','2021-06-30 13:13:40',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-05-17 16:47:03','2022-05-17 16:47:03',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-05-17 16:47:03','2022-05-17 16:47:03',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-05-17 16:47:03','2022-05-17 16:47:03',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-05-17 16:47:03','2022-05-17 16:47:03',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1045.00,6270.00,208739.25,30,3300,NULL,'1',NULL,NULL,NULL),(2,'B',1565.00,9390.00,313108.87,45,5000,NULL,'1',NULL,NULL,NULL),(3,'C',2090.00,12540.00,417478.51,60,6700,NULL,'1',NULL,NULL,NULL),(4,'D',3130.00,18780.00,626217.78,85,10000,NULL,'1',NULL,NULL,NULL),(5,'E',4175.00,25050.00,834957.00,110,13000,NULL,'1',NULL,NULL,NULL),(6,'F',5220.00,31320.00,1043696.27,150,16500,NULL,'1',NULL,NULL,NULL),(7,'G',6260.00,37560.00,1252435.53,200,20000,NULL,'1',NULL,NULL,NULL),(8,'H',8700.00,52200.00,1739493.79,200,20000,NULL,'1',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',748382.07,62365.17,'No Excluida','0',30,3330,133455.58,288.07,288.07,1270.99,1775.18,3334.24,3334.24,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',1112459.83,92704.99,'No Excluida','0',45,5000,133455.58,555.02,555.02,1398.09,1775.18,3728.29,3728.29,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',1557443.75,129786.98,'No Excluida','0',60,6700,266911.14,949.02,876.97,1537.91,1775.18,4262.11,4190.06,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',1934273.04,161189.42,'No Excluida','0',85,10000,266911.14,1559.09,1440.47,1691.69,1775.18,5025.96,4907.34,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',2277684.56,189807.05,'No Excluida','0',110,13000,332579.74,2965.66,2300.50,1860.87,1775.18,6601.71,5936.55,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',2847105.70,237258.81,'No Excluida','0',150,16500,333638.90,4079.93,3003.79,2046.95,1775.18,7902.06,6825.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',3416526.83,284710.57,'No Excluida','0',200,20000,400366.71,5189.94,3745.19,2251.64,1775.18,9216.76,7772.01,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',4229985.60,352498.80,'No Excluida','0',200,20000,533822.27,11862.69,9193.62,2476.80,1775.18,16114.68,13445.60,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',4734330.03,394527.50,'Venta de Bs Muebles','0',200,20000,533822.27,NULL,14828.38,2724.49,1775.18,NULL,19328.05,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',5425770.00,452147.50,'Venta de Bs Muebles','0',200,20000,533822.27,NULL,17425.48,2996.96,1775.18,NULL,22197.62,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',6019594.89,501632.91,'Venta de Bs Muebles','0',200,20000,533822.27,NULL,20018.33,3296.62,1775.18,NULL,25090.13,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',208739.25,17394.94,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,'Clave Fiscal',NULL,NULL),(2,'Clave Ciudad',NULL,NULL),(3,'Clave ARBA',NULL,NULL),(4,'Clave ANSES',NULL,NULL),(5,'Catedral',NULL,NULL),(6,'CEMIBA',NULL,NULL),(7,'COMPRA ARG',NULL,NULL),(8,'Consejo Ciencias Economicas',NULL,NULL),(9,'Correo',NULL,NULL),(10,'CUR',NULL,NULL),(11,'Firma Digital',NULL,NULL),(12,'Interbanking',NULL,NULL),(13,'Banco Citibank',NULL,NULL),(14,'Banco Ciudad',NULL,NULL),(15,'Banco Frances',NULL,NULL),(16,'Banco Galicia',NULL,NULL),(17,'Banco HSBC',NULL,NULL),(18,'Banco Itau',NULL,NULL),(19,'Banco Nacion',NULL,NULL),(20,'Banco Macro',NULL,NULL),(21,'Banco Patagonia',NULL,NULL),(22,'Banco Provincia',NULL,NULL),(23,'Banco Santander',NULL,NULL),(24,'Banco Supervielle',NULL,NULL),(25,'Seguridad e Higiene',NULL,NULL),(26,'Sindicato - ANSES',NULL,NULL),(27,'Sindicato - AOT',NULL,NULL),(28,'Sindicato - ATSA',NULL,NULL),(29,'Sindicato - Camioneros',NULL,NULL),(30,'Sindicato - Guinchero',NULL,NULL),(31,'Sindicato - IERIC',NULL,NULL),(32,'Sindicato - La Estrella',NULL,NULL),(33,'Sindicato - Nemesis',NULL,NULL),(34,'Sindicato - Pasta',NULL,NULL),(35,'Sindicato - SEC',NULL,NULL),(36,'Sindicato - SICOP',NULL,NULL),(37,'Sindicato - SOCAYA',NULL,NULL),(38,'Sindicato - UTHGRA',NULL,NULL),(39,'Sindicato - INACAP',NULL,NULL),(40,'Sindicato - Otro',NULL,NULL),(41,'Otra',NULL,NULL),(42,'Prisma - Firma Digital',NULL,NULL),(43,'Sindicato - FATSA',NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (1,3687,NULL,'Vlynch2021',NULL,40,40720,1,'2021-04-25 21:22:08','2021-04-25 21:22:08',NULL),(2,3687,NULL,'Persianas2017',NULL,3,40720,1,'2021-04-25 21:22:08','2021-04-25 21:22:08',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL),(2,NULL,'Articulo 6',6,0,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL),(3,NULL,'Articulo 7',7,0,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL),(4,NULL,'Articulo 8',8,0,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL),(5,NULL,'Articulo 9',9,0,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL),(6,NULL,'Articulo 10',10,0,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL),(7,NULL,'Articulo 11',11,0,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL),(8,NULL,'Articulo 12',12,0,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL),(9,NULL,'Articulo 13',13,0,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL),(10,NULL,'Articulo 14',14,1,'2021-07-26 03:48:08','2021-07-29 08:44:14',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,NULL),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,NULL),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,NULL),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,NULL),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,NULL),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,NULL),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,NULL),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,NULL),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,NULL),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,NULL),(174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,NULL),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,NULL),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Tarjeta Shopping','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(216,NULL,5120157,5,1,5120100,'Tarjeta Cencosud','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL),(258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL),(347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,NULL),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,NULL),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL),(438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,NULL),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,NULL),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,NULL),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,NULL),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=956 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,3687,3,40720,40721,57,1533,2,0,'2021-04-01',6900.00,'Factura C N°: 0004-00000666',NULL,'2021-05-15 18:03:01','2021-05-15 18:07:04','2021-05-15 18:07:04'),(2,3687,3,40720,40722,57,1533,2,0,'2021-04-01',21175.00,'Factura A N°: 0004-00000068',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(3,3687,3,40720,40723,57,1533,2,0,'2021-04-03',4272.53,'Factura A N°: 3193-00086121',NULL,'2021-05-15 18:03:01','2021-05-15 18:08:21','2021-05-15 18:08:21'),(4,3687,3,40720,40724,57,1533,2,0,'2021-04-05',11339.00,'Factura A N°: 0003-00003355',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(5,3687,3,40720,40725,57,1533,2,0,'2021-04-06',56276.00,'Factura C N°: 0002-00000208',NULL,'2021-05-15 18:03:01','2021-05-15 18:09:16','2021-05-15 18:09:16'),(6,3687,3,40720,40721,57,1533,1,0,'2021-04-07',6900.00,'Nota de crédito C N°: 0004-00000006',NULL,'2021-05-15 18:03:01','2021-05-15 18:09:44','2021-05-15 18:09:44'),(7,3687,3,40720,40726,57,1533,2,0,'2021-04-13',58337.45,'Factura A N°: 0010-00000062',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(8,3687,3,40720,40727,57,1533,2,0,'2021-04-14',58442.93,'Factura A N°: 0010-00033622',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(9,3687,3,40720,40728,57,1533,2,0,'2021-04-14',1380.09,'Factura A N°: 0003-00020820',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(10,3687,3,40720,40726,57,1533,2,0,'2021-04-14',38938.38,'Factura A N°: 0010-00000070',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(11,3687,3,40720,40726,57,1533,1,0,'2021-04-14',58337.45,'Nota de crédito A N°: 0010-00000008',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(12,3687,3,40720,40729,57,1533,2,0,'2021-04-15',30219.15,'Factura A N°: 0002-00009105',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(13,3687,3,40720,40730,57,1533,2,0,'2021-04-16',845.00,'Factura A N°: 0004-00061309',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(14,3687,3,40720,40731,57,1533,2,0,'2021-04-16',716.26,'Factura A N°: 0002-00054774',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(15,3687,3,40720,40732,57,1533,2,0,'2021-04-18',9121.23,'Factura A N°: 2468-00167608',NULL,'2021-05-15 18:03:01','2021-05-15 18:10:53','2021-05-15 18:10:53'),(16,3687,3,40720,40733,57,1533,2,0,'2021-04-19',2005.99,'Factura A N°: 0007-00021283',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(17,3687,3,40720,40730,57,1533,2,0,'2021-04-19',1828.00,'Factura A N°: 0004-00061487',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(18,3687,3,40720,40730,57,1533,2,0,'2021-04-19',42671.09,'Factura A N°: 0004-00061480',NULL,'2021-05-15 18:03:01','2021-05-15 18:03:01',NULL),(19,3687,3,40720,40730,57,1533,1,0,'2021-04-19',1644.00,'Nota de crédito A N°: 0004-00005080',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(20,3687,3,40720,40731,57,1533,2,0,'2021-04-20',81019.88,'Factura A N°: 0002-00054815',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(21,3687,3,40720,40731,57,1533,2,0,'2021-04-20',89299.06,'Factura A N°: 0002-00054814',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(22,3687,3,40720,40731,57,1533,2,0,'2021-04-20',96971.80,'Factura A N°: 0002-00054817',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(23,3687,3,40720,40731,57,1533,1,0,'2021-04-20',96971.80,'Nota de crédito A N°: 0002-00003910',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(24,3687,3,40720,40731,57,1533,1,0,'2021-04-20',15951.92,'Nota de crédito A N°: 0002-00003911',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(25,3687,3,40720,40731,57,1533,2,0,'2021-04-20',15951.92,'Nota de débito A N°: 0002-00000967',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(26,3687,3,40720,40731,57,1533,1,0,'2021-04-20',89299.06,'Nota de crédito A N°: 0002-00003909',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(27,3687,3,40720,40731,57,1533,2,0,'2021-04-20',96971.80,'Nota de débito A N°: 0002-00000968',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL);
INSERT INTO `cta_cte_cliente` VALUES (28,3687,3,40720,40729,57,1533,1,0,'2021-04-21',4584.45,'Nota de crédito A N°: 0002-00000557',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(29,3687,3,40720,40721,57,1533,2,0,'2021-04-22',6900.00,'Factura C N°: 0004-00000671',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(30,3687,3,40720,40733,57,1533,2,0,'2021-04-22',10291.12,'Factura A N°: 0007-00021555',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(31,3687,3,40720,40734,57,1533,2,0,'2021-04-22',35080.69,'Factura A N°: 0001-00002299',NULL,'2021-05-15 18:03:02','2021-05-16 14:29:49','2021-05-16 14:29:49'),(32,3687,3,40720,40735,57,1533,2,0,'2021-04-24',17785.33,'Factura A N°: 0376-00020065',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(33,3687,3,40720,40736,57,1533,2,0,'2021-04-26',33013.00,'Factura A N°: 0083-00119592',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(34,3687,3,40720,40737,57,1533,2,0,'2021-04-29',116268.90,'Factura A N°: 0003-00009318',NULL,'2021-05-15 18:03:02','2021-05-15 18:03:02',NULL),(35,3687,3,40720,40721,57,1533,2,0,'2021-04-01',6900.00,'Factura C N°: 0004-00000666',NULL,'2021-05-15 18:07:04','2021-05-15 18:07:04',NULL),(36,3687,3,40720,40723,57,1533,2,0,'2021-04-03',4173.93,'Factura A N°: 3193-00086121',NULL,'2021-05-15 18:08:21','2021-05-15 18:22:25','2021-05-15 18:22:25'),(37,3687,3,40720,40725,57,1533,2,0,'2021-04-06',56276.00,'Factura C N°: 0002-00000208',NULL,'2021-05-15 18:09:16','2021-05-15 19:14:47','2021-05-15 19:14:47'),(38,3687,3,40720,40721,57,1533,1,0,'2021-04-07',6900.00,'Nota de crédito C N°: 0004-00000006',NULL,'2021-05-15 18:09:44','2021-05-15 18:09:44',NULL),(39,3687,3,40720,40732,57,1533,2,0,'2021-04-18',9299.18,'Factura A N°: 2468-00167608',NULL,'2021-05-15 18:10:53','2021-05-15 18:57:27','2021-05-15 18:57:27'),(40,3687,3,40720,40738,57,1533,2,0,'2021-04-01',3439.99,'Factura A N°: 0024-00270122',NULL,'2021-05-15 18:18:25','2021-05-15 19:06:59','2021-05-15 19:06:59'),(41,3687,3,40720,40723,57,1533,2,0,'2021-04-03',4272.53,'Factura A N°: 3193-00086121',NULL,'2021-05-15 18:22:25','2021-05-15 18:22:25',NULL),(42,3687,3,40720,40739,57,1533,2,0,'2021-04-08',3099.97,'Factura A N°: 0015-00005958',NULL,'2021-05-15 18:29:58','2021-05-15 18:29:58',NULL),(43,3687,3,40720,40740,57,1533,2,0,'2021-04-12',2007.45,'Factura A N°: 0012-00002377',NULL,'2021-05-15 18:32:08','2021-05-15 18:32:08',NULL),(44,3687,3,40720,40741,57,1533,2,0,'2021-04-13',2000.00,'Factura A N°: 0003-00043319',NULL,'2021-05-15 18:35:46','2021-05-15 18:35:46',NULL),(45,3687,3,40720,40741,57,1533,2,0,'2021-04-13',1000.00,'Factura A N°: 0004-00043318',NULL,'2021-05-15 18:38:19','2021-05-15 18:38:19',NULL),(46,3687,3,40720,40742,57,1533,2,0,'2021-04-23',1500.00,'Factura A N°: 0004-00043955',NULL,'2021-05-15 18:40:37','2021-05-15 18:40:37',NULL),(47,3687,3,40720,40743,57,1533,2,0,'2021-04-30',10991.03,'Factura A N°: 0013-00023738',NULL,'2021-05-15 18:45:55','2021-05-15 18:45:55',NULL),(48,3687,3,40720,40743,57,1533,2,0,'2021-04-30',6237.61,'Factura A N°: 0013-00023739',NULL,'2021-05-15 18:48:14','2021-05-15 18:48:14',NULL),(49,3687,3,40720,40743,57,1533,2,0,'2021-04-30',574.93,'Factura A N°: 0013-00023803',NULL,'2021-05-15 18:49:21','2021-05-15 18:49:21',NULL),(50,3687,3,40720,40744,57,1533,2,0,'2021-04-30',27909.94,'Factura A N°: 0029-20210430',NULL,'2021-05-15 18:52:23','2021-05-15 18:52:23',NULL),(51,3687,3,40720,40732,57,1533,2,0,'2021-04-18',1755.23,'Factura A N°: 2468-00167608',NULL,'2021-05-15 18:57:27','2021-05-15 18:57:59','2021-05-15 18:57:59'),(52,3687,3,40720,40732,57,1533,2,0,'2021-04-18',9121.23,'Factura A N°: 2468-00167608',NULL,'2021-05-15 18:57:59','2021-05-15 18:57:59',NULL),(53,3687,3,40720,40738,57,1533,2,0,'2021-04-01',3439.99,'Factura A N°: 0024-00270122',NULL,'2021-05-15 19:06:59','2021-05-15 19:08:45','2021-05-15 19:08:45'),(54,3687,3,40720,40738,57,1533,2,0,'2021-04-01',3439.99,'Factura A N°: 0024-00270122',NULL,'2021-05-15 19:08:45','2021-05-15 22:52:50','2021-05-15 22:52:50');
INSERT INTO `cta_cte_cliente` VALUES (55,3687,3,40720,40725,57,1533,2,0,'2021-04-06',56276.00,'Factura C N°: 0002-00000208',NULL,'2021-05-15 19:14:47','2021-05-15 19:14:47',NULL),(56,3687,3,40720,40738,57,1533,2,0,'2021-04-01',3439.99,'Factura A N°: 0024-00270122',NULL,'2021-05-15 22:52:50','2021-05-15 22:52:50',NULL),(57,3687,3,40720,40745,57,1533,2,0,'2021-04-01',900.01,'Factura A N°: 0010-00318012',NULL,'2021-05-15 23:55:53','2021-05-15 23:55:53',NULL),(58,3687,3,40720,40746,57,1533,2,0,'2021-04-11',1131.21,'Factura A N°: 72071-06050161',NULL,'2021-05-15 23:57:43','2021-05-15 23:57:43',NULL),(59,3687,2,40720,40747,13,1533,1,0,'2021-04-05',694200.00,'Factura A N°: 0001-00000904',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(60,3687,2,40720,40748,13,1533,1,0,'2021-04-05',13095.23,'Factura A N°: 0001-00000905',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(61,3687,2,40720,40749,13,1533,1,0,'2021-04-05',41940.10,'Factura A N°: 0001-00000906',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(62,3687,2,40720,40750,13,1533,1,0,'2021-04-05',60356.01,'Factura A N°: 0001-00000907',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(63,3687,2,40720,40751,13,1533,1,0,'2021-04-05',41050.00,'Factura A N°: 0001-00000908',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(64,3687,2,40720,40752,13,1533,1,0,'2021-04-07',29840.00,'Factura A N°: 0001-00000909',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(65,3687,2,40720,40753,13,1533,1,0,'2021-04-07',29500.01,'Factura A N°: 0001-00000910',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(66,3687,2,40720,40754,13,1533,2,0,'2021-04-08',45917.16,'Nota de crédito A N°: 0001-00000039',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(67,3687,2,40720,40755,13,1533,1,0,'2021-04-08',55400.58,'Factura A N°: 0001-00000911',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(68,3687,2,40720,40755,13,1533,1,0,'2021-04-08',115615.50,'Factura A N°: 0001-00000912',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(69,3687,2,40720,40755,13,1533,1,0,'2021-04-08',44168.68,'Factura A N°: 0001-00000913',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(70,3687,2,40720,40755,13,1533,1,0,'2021-04-08',1373.56,'Factura A N°: 0001-00000914',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(71,3687,2,40720,40754,13,1533,1,0,'2021-04-08',93481.36,'Factura A N°: 0001-00000915',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(72,3687,2,40720,40756,13,1533,1,0,'2021-04-09',16041.27,'Factura B N°: 0001-00000086',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(73,3687,2,40720,40755,13,1533,1,0,'2021-04-12',48451.79,'Factura A N°: 0001-00000916',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(74,3687,2,40720,40757,13,1533,1,0,'2021-04-12',11868.38,'Factura A N°: 0001-00000917',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(75,3687,2,40720,40758,13,1533,1,0,'2021-04-12',56178.46,'Factura A N°: 0001-00000918',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(76,3687,2,40720,40759,13,1533,1,0,'2021-04-12',135927.77,'Factura A N°: 0001-00000919',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(77,3687,2,40720,40760,13,1533,1,0,'2021-04-15',9510.60,'Factura A N°: 0001-00000920',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(78,3687,2,40720,40750,13,1533,1,0,'2021-04-15',30517.75,'Factura A N°: 0001-00000921',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(79,3687,2,40720,40755,13,1533,1,0,'2021-04-15',22516.35,'Factura A N°: 0001-00000922',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(80,3687,2,40720,40755,13,1533,1,0,'2021-04-16',34552.91,'Factura A N°: 0001-00000923',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(81,3687,2,40720,40761,13,1533,1,0,'2021-04-16',31000.01,'Factura A N°: 0001-00000924',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(82,3687,2,40720,40762,13,1533,1,0,'2021-04-19',6600.01,'Factura A N°: 0001-00000925',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL);
INSERT INTO `cta_cte_cliente` VALUES (83,3687,2,40720,40763,13,1533,1,0,'2021-04-19',445000.01,'Factura A N°: 0001-00000926',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(84,3687,2,40720,40764,13,1533,1,0,'2021-04-19',406600.03,'Factura A N°: 0001-00000927',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(85,3687,2,40720,40750,13,1533,1,0,'2021-04-19',16248.86,'Factura A N°: 0001-00000928',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(86,3687,2,40720,40750,13,1533,1,0,'2021-04-19',20277.18,'Factura A N°: 0001-00000929',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(87,3687,2,40720,40755,13,1533,1,0,'2021-04-19',85024.76,'Factura A N°: 0001-00000930',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(88,3687,2,40720,40755,13,1533,1,0,'2021-04-19',18337.03,'Factura A N°: 0001-00000931',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(89,3687,2,40720,40755,13,1533,1,0,'2021-04-19',51759.95,'Factura A N°: 0001-00000932',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(90,3687,2,40720,40755,13,1533,1,0,'2021-04-19',42454.42,'Factura A N°: 0001-00000933',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(91,3687,2,40720,40755,13,1533,1,0,'2021-04-19',40643.55,'Factura A N°: 0001-00000934',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(92,3687,2,40720,40755,13,1533,1,0,'2021-04-19',60124.83,'Factura A N°: 0001-00000935',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(93,3687,2,40720,40755,13,1533,1,0,'2021-04-19',41947.69,'Factura A N°: 0001-00000936',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(94,3687,2,40720,40750,13,1533,1,0,'2021-04-20',125064.39,'Factura A N°: 0001-00000937',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(95,3687,2,40720,40759,13,1533,1,0,'2021-04-21',34600.00,'Factura A N°: 0001-00000938',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(96,3687,2,40720,40765,13,1533,1,0,'2021-04-22',28550.00,'Factura A N°: 0001-00000939',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(97,3687,2,40720,40748,13,1533,1,0,'2021-04-22',62515.30,'Factura A N°: 0001-00000940',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(98,3687,2,40720,40766,13,1533,1,0,'2021-04-22',67256.58,'Factura A N°: 0001-00000941',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(99,3687,2,40720,40766,13,1533,1,0,'2021-04-22',40440.26,'Factura A N°: 0001-00000942',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(100,3687,2,40720,40761,13,1533,1,0,'2021-04-22',25120.04,'Factura A N°: 0001-00000943',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(101,3687,2,40720,40761,13,1533,1,0,'2021-04-22',101594.02,'Factura A N°: 0001-00000944',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(102,3687,2,40720,40761,13,1533,1,0,'2021-04-22',52722.91,'Factura A N°: 0001-00000945',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(103,3687,2,40720,40760,13,1533,1,0,'2021-04-22',17475.73,'Factura A N°: 0001-00000946',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(104,3687,2,40720,40767,13,1533,1,0,'2021-04-23',247700.01,'Factura A N°: 0001-00000947',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(105,3687,2,40720,40767,13,1533,1,0,'2021-04-23',16600.00,'Factura A N°: 0001-00000948',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(106,3687,2,40720,40768,13,1533,1,0,'2021-04-23',62400.00,'Factura A N°: 0001-00000949',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(107,3687,2,40720,40769,13,1533,1,0,'2021-04-23',140043.59,'Factura A N°: 0001-00000950',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(108,3687,2,40720,40770,13,1533,1,0,'2021-04-28',1128.00,'Factura B N°: 0001-00000087',NULL,'2021-05-16 00:00:46','2021-05-16 00:00:46',NULL),(109,3687,3,40720,40727,57,1530,2,0,'2021-01-07',148095.76,'Factura A N°: 0010-00032285',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(110,3687,3,40720,40727,57,1530,2,0,'2021-01-11',35094.57,'Factura A N°: 0010-00032322',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL);
INSERT INTO `cta_cte_cliente` VALUES (111,3687,3,40720,40771,57,1530,2,0,'2021-01-12',3727.07,'Factura A N°: 0003-00025951',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(112,3687,3,40720,40730,57,1530,2,0,'2021-01-13',1406.00,'Factura A N°: 0004-00053345',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(113,3687,3,40720,40727,57,1530,2,0,'2021-01-15',384232.45,'Factura A N°: 0010-00032407',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(114,3687,3,40720,40730,57,1530,2,0,'2021-01-15',1102.00,'Factura A N°: 0004-00053592',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(115,3687,3,40720,40732,57,1530,2,0,'2021-01-18',5349.93,'Factura A N°: 2468-00140090',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(116,3687,3,40720,40728,57,1530,2,0,'2021-01-20',8020.52,'Factura A N°: 0003-00019693',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(117,3687,3,40720,40772,57,1530,2,0,'2021-01-22',2000.00,'Factura C N°: 0002-00001601',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(118,3687,3,40720,40773,57,1530,2,0,'2021-01-22',2347.39,'Factura A N°: 0003-00139301',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(119,3687,3,40720,40736,57,1530,2,0,'2021-01-26',30525.00,'Factura A N°: 0073-00107864',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(120,3687,3,40720,40730,57,1530,2,0,'2021-01-27',28395.63,'Factura A N°: 0004-00054548',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(121,3687,3,40720,40774,57,1530,2,0,'2021-01-27',1154.00,'Factura C N°: 0002-00000428',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(122,3687,3,40720,40727,57,1530,2,0,'2021-01-28',238617.69,'Factura A N°: 0010-00032632',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(123,3687,3,40720,40775,57,1530,2,0,'2021-01-28',1049.75,'Factura A N°: 0004-00003704',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(124,3687,3,40720,40776,57,1530,2,0,'2021-01-28',27121.42,'Factura A N°: 0007-00201883',NULL,'2021-05-16 12:16:29','2021-05-16 12:16:29',NULL),(125,3687,3,40720,40777,57,1531,2,0,'2021-02-01',1630.00,'Factura A N°: 0006-00409484',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(126,3687,3,40720,40778,57,1531,2,0,'2021-02-03',80000.00,'Factura C N°: 0002-00000063',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(127,3687,3,40720,40721,57,1531,2,0,'2021-02-03',6900.00,'Factura C N°: 0004-00000649',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(128,3687,3,40720,40729,57,1531,2,0,'2021-02-04',407521.66,'Factura A N°: 0002-00008803',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(129,3687,3,40720,40779,57,1531,2,0,'2021-02-05',604961.28,'Factura A N°: 0002-00007369',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(130,3687,3,40720,40780,57,1531,2,0,'2021-02-06',18150.00,'Factura A N°: 0003-00000659',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(131,3687,3,40720,40724,57,1531,2,0,'2021-02-08',831501.00,'Factura A N°: 0003-00003277',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(132,3687,3,40720,40724,57,1531,2,0,'2021-02-08',18451.20,'Factura A N°: 0003-00003276',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(133,3687,3,40720,40780,57,1531,1,0,'2021-02-08',18150.00,'Nota de crédito A N°: 0003-00000003',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(134,3687,3,40720,40780,57,1531,2,0,'2021-02-08',18150.00,'Factura A N°: 0003-00000660',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(135,3687,3,40720,40771,57,1531,2,0,'2021-02-08',170210.02,'Factura A N°: 0003-00026375',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(136,3687,3,40720,40727,57,1531,2,0,'2021-02-09',394877.00,'Nota de débito A N°: 0010-00003917',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(137,3687,3,40720,40727,57,1531,2,0,'2021-02-13',1147624.89,'Factura A N°: 0010-00032811',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL);
INSERT INTO `cta_cte_cliente` VALUES (138,3687,3,40720,40727,57,1531,2,0,'2021-02-17',463045.64,'Factura A N°: 0010-00032828',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(139,3687,3,40720,40727,57,1531,2,0,'2021-02-17',99726.09,'Factura A N°: 0010-00032829',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(140,3687,3,40720,40727,57,1531,2,0,'2021-02-17',672293.35,'Factura A N°: 0010-00032830',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(141,3687,3,40720,40775,57,1531,2,0,'2021-02-17',59176.26,'Factura A N°: 0004-00003916',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(142,3687,3,40720,40775,57,1531,2,0,'2021-02-17',13796.84,'Factura A N°: 0004-00003917',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(143,3687,3,40720,40730,57,1531,2,0,'2021-02-17',1103.60,'Factura A N°: 0004-00056131',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(144,3687,3,40720,40727,57,1531,2,0,'2021-02-18',676012.46,'Factura A N°: 0010-00032840',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(145,3687,3,40720,40732,57,1531,2,0,'2021-02-18',5307.49,'Factura A N°: 2468-00149602',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(146,3687,3,40720,40737,57,1531,2,0,'2021-02-18',92595.25,'Factura A N°: 0003-00008757',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(147,3687,3,40720,40727,57,1531,2,0,'2021-02-20',247272.87,'Factura A N°: 0010-00032865',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(148,3687,3,40720,40736,57,1531,2,0,'2021-02-24',30525.00,'Factura A N°: 0079-00111960',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(149,3687,3,40720,40731,57,1531,2,0,'2021-02-24',36042.93,'Factura A N°: 0002-00054074',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(150,3687,3,40720,40731,57,1531,2,0,'2021-02-26',3883.62,'Factura A N°: 0002-00054124',NULL,'2021-05-16 12:17:19','2021-05-16 12:17:19',NULL),(186,3687,2,40720,40755,13,1530,1,0,'2021-01-14',96520.79,'Factura A N°: 0001-00000806',NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(187,3687,2,40720,40761,13,1530,1,0,'2021-01-14',38201.15,'Factura A N°: 0001-00000807',NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(188,3687,2,40720,40757,13,1530,1,0,'2021-01-14',43299.99,'Factura A N°: 0001-00000808',NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(189,3687,2,40720,40754,13,1530,1,0,'2021-01-14',230332.21,'Factura A N°: 0001-00000809',NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(190,3687,2,40720,40785,13,1530,1,0,'2021-01-14',12248.16,'Factura B N°: 0001-00000078',NULL,'2021-05-16 12:18:56','2021-05-16 12:18:56',NULL),(191,3687,2,40720,40748,13,1530,1,0,'2021-01-20',121732.05,'Factura A N°: 0001-00000810',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(192,3687,2,40720,40755,13,1530,1,0,'2021-01-21',3503.92,'Factura A N°: 0001-00000811',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(193,3687,2,40720,40786,13,1530,1,0,'2021-01-21',105624.45,'Factura A N°: 0001-00000812',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(194,3687,2,40720,40754,13,1530,1,0,'2021-01-21',309019.95,'Factura A N°: 0001-00000813',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(195,3687,2,40720,40750,13,1530,1,0,'2021-01-21',112376.38,'Factura A N°: 0001-00000814',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(196,3687,2,40720,40761,13,1530,1,0,'2021-01-25',80380.00,'Factura A N°: 0001-00000815',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(197,3687,2,40720,40787,13,1530,1,0,'2021-01-25',22076.23,'Factura A N°: 0001-00000816',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(198,3687,2,40720,40757,13,1530,1,0,'2021-01-27',11785.40,'Factura A N°: 0001-00000817',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(199,3687,2,40720,40755,13,1530,1,0,'2021-01-27',357649.45,'Factura A N°: 0001-00000818',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL);
INSERT INTO `cta_cte_cliente` VALUES (200,3687,2,40720,40763,13,1530,1,0,'2021-01-27',6514.25,'Factura B N°: 0001-00000079',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(201,3687,2,40720,40748,13,1530,1,0,'2021-01-28',16831.10,'Factura A N°: 0001-00000819',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(202,3687,2,40720,40755,13,1530,2,0,'2021-01-28',1751.96,'Nota de crédito A N°: 0001-00000034',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(203,3687,2,40720,40788,13,1530,1,0,'2021-01-29',56758.08,'Factura A N°: 0001-00000820',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(204,3687,2,40720,40789,13,1530,1,0,'2021-01-29',6975.05,'Factura A N°: 0001-00000821',NULL,'2021-05-16 12:18:57','2021-05-16 12:18:57',NULL),(205,3687,2,40720,40790,13,1531,1,0,'2021-02-01',70340.47,'Factura A N°: 0001-00000822',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(206,3687,2,40720,40755,13,1531,1,0,'2021-02-04',234863.14,'Factura A N°: 0001-00000823',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(207,3687,2,40720,40750,13,1531,1,0,'2021-02-04',144677.04,'Factura A N°: 0001-00000824',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(208,3687,2,40720,40761,13,1531,1,0,'2021-02-04',114178.02,'Factura A N°: 0001-00000825',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(209,3687,2,40720,40791,13,1531,1,0,'2021-02-04',13247.08,'Factura A N°: 0001-00000826',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(210,3687,2,40720,40792,13,1531,1,0,'2021-02-04',130780.31,'Factura B N°: 0001-00000080',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(211,3687,2,40720,40792,13,1531,2,0,'2021-02-04',1390.31,'Nota de crédito B N°: 0001-00000002',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(212,3687,2,40720,40793,13,1531,1,0,'2021-02-08',11400.02,'Factura B N°: 0001-00000081',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(213,3687,2,40720,40750,13,1531,1,0,'2021-02-10',20460.65,'Factura A N°: 0001-00000827',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(214,3687,2,40720,40750,13,1531,1,0,'2021-02-10',111778.59,'Factura A N°: 0001-00000828',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(215,3687,2,40720,40794,13,1531,1,0,'2021-02-10',28340.00,'Factura A N°: 0001-00000829',NULL,'2021-05-16 12:19:12','2021-05-16 12:19:12',NULL),(216,3687,2,40720,40757,13,1531,1,0,'2021-02-10',9037.89,'Factura A N°: 0001-00000830',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(217,3687,2,40720,40750,13,1531,1,0,'2021-02-11',322344.00,'Factura A N°: 0001-00000831',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(218,3687,2,40720,40750,13,1531,1,0,'2021-02-12',322344.00,'Nota de débito A N°: 0001-00000013',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(219,3687,2,40720,40750,13,1531,2,0,'2021-02-12',322344.00,'Nota de crédito A N°: 0001-00000035',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(220,3687,2,40720,40750,13,1531,2,0,'2021-02-12',20460.65,'Nota de crédito A N°: 0001-00000036',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(221,3687,2,40720,40795,13,1531,1,0,'2021-02-17',3159.43,'Factura A N°: 0001-00000832',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(222,3687,2,40720,40751,13,1531,1,0,'2021-02-17',358158.54,'Factura A N°: 0001-00000833',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(223,3687,2,40720,40796,13,1531,1,0,'2021-02-17',165842.31,'Factura A N°: 0001-00000834',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(224,3687,2,40720,40796,13,1531,1,0,'2021-02-17',143850.70,'Factura A N°: 0001-00000835',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(225,3687,2,40720,40797,13,1531,1,0,'2021-02-17',3113.09,'Factura B N°: 0001-00000082',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(226,3687,2,40720,40798,13,1531,1,0,'2021-02-17',64000.00,'Factura B N°: 0001-00000083',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL);
INSERT INTO `cta_cte_cliente` VALUES (227,3687,2,40720,40799,13,1531,1,0,'2021-02-18',14211.45,'Factura A N°: 0001-00000836',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(228,3687,2,40720,40800,13,1531,1,0,'2021-02-18',93350.00,'Factura A N°: 0001-00000837',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(229,3687,2,40720,40801,13,1531,1,0,'2021-02-18',62350.01,'Factura A N°: 0001-00000838',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(230,3687,2,40720,40800,13,1531,1,0,'2021-02-18',221350.01,'Factura A N°: 0001-00000839',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(231,3687,2,40720,40755,13,1531,1,0,'2021-02-18',20588.91,'Factura A N°: 0001-00000840',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(232,3687,2,40720,40755,13,1531,1,0,'2021-02-18',49713.99,'Factura A N°: 0001-00000841',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(233,3687,2,40720,40755,13,1531,1,0,'2021-02-18',66871.42,'Factura A N°: 0001-00000842',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(234,3687,2,40720,40755,13,1531,1,0,'2021-02-18',23522.40,'Factura A N°: 0001-00000843',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(235,3687,2,40720,40755,13,1531,1,0,'2021-02-18',46756.38,'Factura A N°: 0001-00000844',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(236,3687,2,40720,40755,13,1531,1,0,'2021-02-18',26299.35,'Factura A N°: 0001-00000845',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(237,3687,2,40720,40755,13,1531,1,0,'2021-02-18',54722.26,'Factura A N°: 0001-00000846',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(238,3687,2,40720,40755,13,1531,1,0,'2021-02-18',20820.32,'Factura A N°: 0001-00000847',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(239,3687,2,40720,40760,13,1531,1,0,'2021-02-25',50966.77,'Factura A N°: 0001-00000848',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(240,3687,2,40720,40750,13,1531,1,0,'2021-02-25',181815.12,'Factura A N°: 0001-00000849',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(241,3687,2,40720,40757,13,1531,1,0,'2021-02-25',17889.25,'Factura A N°: 0001-00000850',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(242,3687,2,40720,40802,13,1531,1,0,'2021-02-25',394877.00,'Nota de débito A N°: 0001-00000014',NULL,'2021-05-16 12:19:13','2021-05-16 12:19:13',NULL),(243,3687,2,40720,40761,13,1532,1,0,'2021-03-01',342890.01,'Factura A N°: 0001-00000851',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(244,3687,2,40720,40761,13,1532,1,0,'2021-03-01',100887.38,'Factura A N°: 0001-00000852',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(245,3687,2,40720,40786,13,1532,1,0,'2021-03-01',6878.85,'Factura A N°: 0001-00000853',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(246,3687,2,40720,40803,13,1532,1,0,'2021-03-02',65590.01,'Factura A N°: 0001-00000854',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(247,3687,2,40720,40755,13,1532,1,0,'2021-03-02',84449.35,'Factura A N°: 0001-00000855',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(248,3687,2,40720,40755,13,1532,1,0,'2021-03-02',30067.46,'Factura A N°: 0001-00000856',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(249,3687,2,40720,40755,13,1532,1,0,'2021-03-02',22149.90,'Factura A N°: 0001-00000857',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(250,3687,2,40720,40755,13,1532,1,0,'2021-03-02',180180.01,'Factura A N°: 0001-00000858',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(251,3687,2,40720,40754,13,1532,1,0,'2021-03-02',192788.94,'Factura A N°: 0001-00000859',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(252,3687,2,40720,40754,13,1532,1,0,'2021-03-02',125373.92,'Factura A N°: 0001-00000860',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(253,3687,2,40720,40754,13,1532,1,0,'2021-03-02',58093.60,'Factura A N°: 0001-00000861',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL);
INSERT INTO `cta_cte_cliente` VALUES (254,3687,2,40720,40754,13,1532,1,0,'2021-03-02',142085.10,'Factura A N°: 0001-00000862',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(255,3687,2,40720,40754,13,1532,1,0,'2021-03-02',312361.69,'Factura A N°: 0001-00000863',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(256,3687,2,40720,40804,13,1532,1,0,'2021-03-02',60929.88,'Factura A N°: 0001-00000864',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(257,3687,2,40720,40755,13,1532,1,0,'2021-03-02',150509.24,'Factura A N°: 0001-00000865',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(258,3687,2,40720,40755,13,1532,1,0,'2021-03-02',57782.34,'Factura A N°: 0001-00000866',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(259,3687,2,40720,40760,13,1532,1,0,'2021-03-02',18950.00,'Factura A N°: 0001-00000867',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(260,3687,2,40720,40786,13,1532,1,0,'2021-03-02',73694.25,'Factura A N°: 0001-00000868',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(261,3687,2,40720,40754,13,1532,1,0,'2021-03-04',64400.74,'Factura A N°: 0001-00000869',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(262,3687,2,40720,40805,13,1532,1,0,'2021-03-04',0.00,'Factura A N°: 0001-00000870',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(263,3687,2,40720,40805,13,1532,1,0,'2021-03-04',30554.98,'Factura A N°: 0001-00000871',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(264,3687,2,40720,40755,13,1532,1,0,'2021-03-05',14643.19,'Factura A N°: 0001-00000872',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(265,3687,2,40720,40786,13,1532,1,0,'2021-03-05',117317.97,'Factura A N°: 0001-00000873',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(266,3687,2,40720,40786,13,1532,1,0,'2021-03-05',31293.99,'Factura A N°: 0001-00000874',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(267,3687,2,40720,40761,13,1532,1,0,'2021-03-08',45907.50,'Nota de débito A N°: 0001-00000015',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(268,3687,2,40720,40786,13,1532,2,0,'2021-03-08',117317.97,'Nota de crédito A N°: 0001-00000037',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(269,3687,2,40720,40801,13,1532,1,0,'2021-03-10',24058.55,'Factura A N°: 0001-00000875',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(270,3687,2,40720,40806,13,1532,1,0,'2021-03-11',77650.00,'Factura A N°: 0001-00000876',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(271,3687,2,40720,40757,13,1532,1,0,'2021-03-11',33123.75,'Factura A N°: 0001-00000877',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(272,3687,2,40720,40807,13,1532,1,0,'2021-03-11',33100.00,'Factura A N°: 0001-00000878',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(273,3687,2,40720,40755,13,1532,1,0,'2021-03-12',22383.67,'Factura A N°: 0001-00000879',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(274,3687,2,40720,40754,13,1532,1,0,'2021-03-15',80515.17,'Factura A N°: 0001-00000880',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(275,3687,2,40720,40754,13,1532,1,0,'2021-03-15',71481.75,'Factura A N°: 0001-00000881',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(276,3687,2,40720,40808,13,1532,1,0,'2021-03-16',73615.00,'Factura B N°: 0001-00000084',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(277,3687,2,40720,40748,13,1532,1,0,'2021-03-17',23101.50,'Factura A N°: 0001-00000882',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(278,3687,2,40720,40786,13,1532,1,0,'2021-03-18',186104.05,'Factura A N°: 0001-00000883',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(279,3687,2,40720,40750,13,1532,1,0,'2021-03-18',62500.00,'Factura A N°: 0001-00000884',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(280,3687,2,40720,40750,13,1532,1,0,'2021-03-18',40199.84,'Factura A N°: 0001-00000885',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL);
INSERT INTO `cta_cte_cliente` VALUES (281,3687,2,40720,40809,13,1532,1,0,'2021-03-18',133181.00,'Factura A N°: 0001-00000886',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(282,3687,2,40720,40788,13,1532,1,0,'2021-03-19',28900.00,'Factura A N°: 0001-00000887',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(283,3687,2,40720,40786,13,1532,1,0,'2021-03-19',23000.00,'Factura A N°: 0001-00000888',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(284,3687,2,40720,40761,13,1532,1,0,'2021-03-19',120500.00,'Factura A N°: 0001-00000889',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(285,3687,2,40720,40793,13,1532,1,0,'2021-03-19',23350.00,'Factura B N°: 0001-00000085',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(286,3687,2,40720,40766,13,1532,1,0,'2021-03-22',157400.01,'Factura A N°: 0001-00000890',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(287,3687,2,40720,40755,13,1532,1,0,'2021-03-25',70980.37,'Factura A N°: 0001-00000891',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(288,3687,2,40720,40755,13,1532,1,0,'2021-03-25',32266.73,'Factura A N°: 0001-00000892',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(289,3687,2,40720,40755,13,1532,1,0,'2021-03-25',33316.83,'Factura A N°: 0001-00000893',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(290,3687,2,40720,40755,13,1532,1,0,'2021-03-25',60266.35,'Factura A N°: 0001-00000894',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(291,3687,2,40720,40755,13,1532,1,0,'2021-03-25',14553.83,'Factura A N°: 0001-00000895',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(292,3687,2,40720,40755,13,1532,1,0,'2021-03-25',28600.18,'Factura A N°: 0001-00000896',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(293,3687,2,40720,40755,13,1532,1,0,'2021-03-25',8836.25,'Factura A N°: 0001-00000897',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(294,3687,2,40720,40757,13,1532,1,0,'2021-03-25',8160.88,'Factura A N°: 0001-00000898',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(295,3687,2,40720,40810,13,1532,1,0,'2021-03-29',132900.48,'Factura A N°: 0001-00000899',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(296,3687,2,40720,40811,13,1532,1,0,'2021-03-30',23400.00,'Factura A N°: 0001-00000900',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(297,3687,2,40720,40749,13,1532,1,0,'2021-03-30',1765.09,'Factura A N°: 0001-00000901',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(298,3687,2,40720,40749,13,1532,1,0,'2021-03-31',29654.66,'Factura A N°: 0001-00000902',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(299,3687,2,40720,40766,13,1532,1,0,'2021-03-31',89200.33,'Factura A N°: 0001-00000903',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(300,3687,2,40720,40749,13,1532,2,0,'2021-03-31',29654.66,'Nota de crédito A N°: 0001-00000038',NULL,'2021-05-16 12:19:29','2021-05-16 12:19:29',NULL),(301,3687,3,40720,40734,57,1533,2,0,'2021-04-22',35080.65,'Factura A N°: 0001-00002299',NULL,'2021-05-16 14:29:49','2021-05-16 14:29:49',NULL),(302,3687,3,40812,40813,57,3042,2,0,'2021-01-02',3100.00,'Factura B N°: 0003-00000674',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(303,3687,3,40812,40814,57,3042,2,0,'2021-01-03',4356.00,'Factura A N°: 0002-00003903',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(304,3687,3,40812,40815,57,3042,2,0,'2021-01-04',102.00,'Factura A N°: 0711-01245241',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(305,3687,3,40812,40816,57,3042,2,0,'2021-01-05',4526.00,'Factura A N°: 0063-01396611',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(306,3687,3,40812,40817,57,3042,2,0,'2021-01-05',55000.00,'Factura C N°: 0002-00000032',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(307,3687,3,40812,40818,57,3042,2,0,'2021-01-06',344933.65,'Factura A N°: 0010-00015105',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL);
INSERT INTO `cta_cte_cliente` VALUES (308,3687,3,40812,40819,57,3042,2,0,'2021-01-07',12000.00,'Factura C N°: 0001-00000072',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(309,3687,3,40812,40820,57,3042,2,0,'2021-01-07',12000.00,'Factura C N°: 0001-00000066',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(310,3687,3,40812,40821,57,3042,2,0,'2021-01-12',7350.00,'Factura C N°: 0001-00000122',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(311,3687,3,40812,40822,57,3042,2,0,'2021-01-14',2420.00,'Factura A N°: 0001-00021952',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(312,3687,3,40812,40821,57,3042,2,0,'2021-01-15',8050.00,'Factura C N°: 0001-00000123',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(313,3687,3,40812,40823,57,3042,2,0,'2021-01-15',56166.38,'Factura A N°: 0002-00005546',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(314,3687,3,40812,40732,57,3042,2,0,'2021-01-18',17131.72,'Factura A N°: 2468-00141233',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(315,3687,3,40812,40824,57,3042,2,0,'2021-01-22',2299.00,'Factura A N°: 0004-00007299',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(316,3687,3,40812,40821,57,3042,2,0,'2021-01-22',5600.00,'Factura C N°: 0001-00000124',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(317,3687,3,40812,40736,57,3042,2,0,'2021-01-26',39961.00,'Factura A N°: 0084-00003739',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(318,3687,3,40812,40818,57,3042,2,0,'2021-01-27',979616.00,'Factura A N°: 0010-00015176',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(319,3687,3,40812,40821,57,3042,2,0,'2021-01-28',4900.00,'Factura C N°: 0001-00000125',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(320,3687,3,40812,40825,57,3042,1,0,'2021-01-30',16012.99,'Nota de crédito A N°: 0002-00000013',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(321,3687,3,40812,40826,57,3042,2,0,'2021-01-30',213592.71,'Factura A N°: 0002-00000207',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(322,3687,3,40812,40825,57,3042,2,0,'2021-01-30',252449.80,'Factura A N°: 0002-00000426',NULL,'2021-05-17 17:34:21','2021-05-17 17:34:21',NULL),(323,3687,3,40812,40827,57,3042,2,0,'2021-01-31',100000.00,'Factura C N°: 0003-00000046',NULL,'2021-05-17 17:34:22','2021-05-17 17:34:22',NULL),(324,3687,3,40812,40828,57,3042,2,0,'2021-01-31',10000.00,'Factura C N°: 0003-00000050',NULL,'2021-05-17 17:34:22','2021-05-17 17:34:22',NULL),(325,3687,3,40812,40813,57,3043,2,0,'2021-02-01',3100.00,'Factura B N°: 0003-00000680',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(326,3687,3,40812,40814,57,3043,2,0,'2021-02-01',5227.20,'Factura A N°: 0002-00003959',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(327,3687,3,40812,40819,57,3043,2,0,'2021-02-01',12000.00,'Factura C N°: 0001-00000074',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(328,3687,3,40812,40820,57,3043,2,0,'2021-02-01',12000.00,'Factura C N°: 0001-00000068',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(329,3687,3,40812,40816,57,3043,2,0,'2021-02-03',4526.00,'Factura A N°: 0063-01421920',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(330,3687,3,40812,40721,57,3043,2,0,'2021-02-03',6900.00,'Factura C N°: 0004-00000650',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(331,3687,3,40812,40829,57,3043,2,0,'2021-02-03',106.80,'Factura A N°: 0629-02129715',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(332,3687,3,40812,40818,57,3043,2,0,'2021-02-03',346267.97,'Factura A N°: 0010-00015202',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(333,3687,3,40812,40817,57,3043,2,0,'2021-02-04',55000.00,'Factura C N°: 0002-00000034',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(334,3687,3,40812,40818,57,3043,2,0,'2021-02-05',369161.72,'Factura A N°: 0010-00015221',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL);
INSERT INTO `cta_cte_cliente` VALUES (335,3687,3,40812,40821,57,3043,2,0,'2021-02-05',5600.00,'Factura C N°: 0001-00000127',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(336,3687,3,40812,40730,57,3043,2,0,'2021-02-08',2977.33,'Factura A N°: 0004-00055502',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(337,3687,3,40812,40830,57,3043,2,0,'2021-02-09',4174.50,'Factura A N°: 0002-00000448',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(338,3687,3,40812,40831,57,3043,2,0,'2021-02-11',608100.63,'Factura A N°: 0004-00007453',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(339,3687,3,40812,40821,57,3043,2,0,'2021-02-12',9450.00,'Factura C N°: 0001-00000128',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(340,3687,3,40812,40823,57,3043,1,0,'2021-02-17',1685.00,'Nota de crédito A N°: 0002-00000256',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(341,3687,3,40812,40829,57,3043,2,0,'2021-02-18',90.10,'Factura A N°: 0629-02162212',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(342,3687,3,40812,40732,57,3043,2,0,'2021-02-18',17123.80,'Factura A N°: 2468-00149045',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(343,3687,3,40812,40824,57,3043,2,0,'2021-02-19',1573.00,'Factura A N°: 0004-00007517',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(344,3687,3,40812,40732,57,3043,2,0,'2021-02-19',0.00,'Factura A N°: 2229-00123329',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(345,3687,3,40812,40821,57,3043,2,0,'2021-02-19',4550.00,'Factura C N°: 0001-00000130',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(346,3687,3,40812,40821,57,3043,2,0,'2021-02-19',4550.00,'Factura C N°: 0001-00000129',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(347,3687,3,40812,40818,57,3043,1,0,'2021-02-23',369161.72,'Nota de crédito A N°: 0010-00000832',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(348,3687,3,40812,40818,57,3043,2,0,'2021-02-23',346267.97,'Factura A N°: 0010-00015283',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(349,3687,3,40812,40832,57,3043,2,0,'2021-02-24',23427.73,'Factura A N°: 0002-00001191',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(350,3687,3,40812,40832,57,3043,1,0,'2021-02-24',6655.00,'Nota de crédito A N°: 0002-00001037',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(351,3687,3,40812,40736,57,3043,2,0,'2021-02-24',39961.00,'Factura A N°: 0079-00111719',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(352,3687,3,40812,40827,57,3043,2,0,'2021-02-26',100000.00,'Factura C N°: 0003-00000047',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(353,3687,3,40812,40821,57,3043,2,0,'2021-02-26',5250.00,'Factura C N°: 0001-00000131',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(354,3687,3,40812,40825,57,3043,2,0,'2021-02-27',156752.11,'Factura A N°: 0002-00000444',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(355,3687,3,40812,40826,57,3043,2,0,'2021-02-28',281022.50,'Factura A N°: 0002-00000208',NULL,'2021-05-17 17:35:04','2021-05-17 17:35:04',NULL),(356,3687,3,40812,40813,57,3044,2,0,'2021-03-01',3100.00,'Factura B N°: 0003-00000685',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(357,3687,3,40812,40814,57,3044,2,0,'2021-03-01',5227.20,'Factura A N°: 0002-00004023',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(358,3687,3,40812,40819,57,3044,2,0,'2021-03-01',12000.00,'Factura C N°: 0001-00000076',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(359,3687,3,40812,40820,57,3044,2,0,'2021-03-01',12000.00,'Factura C N°: 0001-00000070',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(360,3687,3,40812,40829,57,3044,2,0,'2021-03-03',90.10,'Factura A N°: 0629-02197250',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(361,3687,3,40812,40816,57,3044,2,0,'2021-03-03',4836.00,'Factura A N°: 0063-01447499',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL);
INSERT INTO `cta_cte_cliente` VALUES (362,3687,3,40812,40833,57,3044,2,0,'2021-03-05',273487.50,'Factura A N°: 0020-00001061',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(363,3687,3,40812,40821,57,3044,2,0,'2021-03-06',7200.00,'Factura C N°: 0001-00000132',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(364,3687,3,40812,40817,57,3044,2,0,'2021-03-08',55000.00,'Factura C N°: 0002-00000035',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(365,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419616',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(366,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419455',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(367,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419460',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(368,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419461',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(369,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419462',NULL,'2021-05-17 17:35:46','2021-05-17 17:35:46',NULL),(370,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419463',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(371,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419464',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(372,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419595',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(373,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419596',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(374,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419597',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(375,3687,3,40812,40732,57,3044,1,0,'2021-03-11',29.22,'Nota de crédito A N°: 2524-00419598',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(376,3687,3,40812,40821,57,3044,2,0,'2021-03-11',7200.00,'Factura C N°: 0001-00000133',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(377,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429886',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(378,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429887',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(379,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429888',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(380,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429761',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(381,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429789',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(382,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429790',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(383,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429791',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(384,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429792',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(385,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429793',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(386,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429824',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(387,3687,3,40812,40732,57,3044,1,0,'2021-03-12',135.26,'Nota de crédito A N°: 2524-00429868',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (388,3687,3,40812,40824,57,3044,2,0,'2021-03-15',2783.00,'Factura A N°: 0004-00007741',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(389,3687,3,40812,40732,57,3044,2,0,'2021-03-18',17800.73,'Factura A N°: 2468-00156591',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(390,3687,3,40812,40829,57,3044,2,0,'2021-03-19',180.20,'Factura A N°: 0629-02231865',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(391,3687,3,40812,40821,57,3044,2,0,'2021-03-20',8000.00,'Factura C N°: 0001-00000136',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(392,3687,3,40812,40721,57,3044,2,0,'2021-03-23',6900.00,'Factura C N°: 0004-00000658',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(393,3687,3,40812,40822,57,3044,2,0,'2021-03-23',15125.00,'Factura A N°: 0001-00022556',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(394,3687,3,40812,40736,57,3044,2,0,'2021-03-26',41359.00,'Factura A N°: 0082-00113423',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(395,3687,3,40812,40822,57,3044,1,0,'2021-03-26',10527.00,'Nota de crédito A N°: 0001-00002315',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(396,3687,3,40812,40821,57,3044,2,0,'2021-03-27',8000.00,'Factura C N°: 0001-00000137',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(397,3687,3,40812,40834,57,3044,2,0,'2021-03-29',2516.00,'Factura C N°: 0003-00001077',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(398,3687,3,40812,40826,57,3044,2,0,'2021-03-30',182483.73,'Factura A N°: 0002-00000210',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(399,3687,3,40812,40827,57,3044,2,0,'2021-03-31',100000.00,'Factura C N°: 0003-00000048',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(400,3687,3,40812,40818,57,3044,2,0,'2021-03-31',3639024.48,'Factura A N°: 0010-00015414',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(401,3687,3,40812,40828,57,3044,2,0,'2021-03-31',25000.00,'Factura C N°: 0003-00000053',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(402,3687,3,40812,40825,57,3044,2,0,'2021-03-31',136851.00,'Factura A N°: 0002-00000454',NULL,'2021-05-17 17:35:47','2021-05-17 17:35:47',NULL),(403,3687,3,40812,40813,57,3045,2,0,'2021-04-01',3100.00,'Factura B N°: 0003-00000690',NULL,'2021-05-17 17:36:21','2021-05-18 02:23:43','2021-05-18 02:23:43'),(404,3687,3,40812,40721,57,3045,2,0,'2021-04-01',6900.00,'Factura C N°: 0004-00000665',NULL,'2021-05-17 17:36:21','2021-05-17 17:45:58','2021-05-17 17:45:58'),(405,3687,3,40812,40814,57,3045,2,0,'2021-04-01',5227.20,'Factura A N°: 0002-00004083',NULL,'2021-05-17 17:36:21','2021-05-18 02:23:32','2021-05-18 02:23:32'),(406,3687,3,40812,40821,57,3045,2,0,'2021-04-01',6400.00,'Factura C N°: 0001-00000138',NULL,'2021-05-17 17:36:21','2021-05-17 17:50:37','2021-05-17 17:50:37'),(407,3687,3,40812,40722,57,3045,2,0,'2021-04-01',21175.00,'Factura A N°: 0004-00000067',NULL,'2021-05-17 17:36:21','2021-05-18 02:23:24','2021-05-18 02:23:24'),(408,3687,3,40812,40816,57,3045,2,0,'2021-04-05',4836.00,'Factura A N°: 0063-01473308',NULL,'2021-05-17 17:36:21','2021-05-17 17:52:08','2021-05-17 17:52:08'),(409,3687,3,40812,40721,57,3045,1,0,'2021-04-07',6900.00,'Nota de crédito C N°: 0004-00000007',NULL,'2021-05-17 17:36:21','2021-05-17 17:54:20','2021-05-17 17:54:20'),(410,3687,3,40812,40819,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000078',NULL,'2021-05-17 17:36:21','2021-05-17 17:55:29','2021-05-17 17:55:29'),(411,3687,3,40812,40817,57,3045,2,0,'2021-04-08',55000.00,'Factura C N°: 0002-00000036',NULL,'2021-05-17 17:36:21','2021-05-17 17:55:55','2021-05-17 17:55:55'),(412,3687,3,40812,40820,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000072',NULL,'2021-05-17 17:36:21','2021-05-17 17:56:22','2021-05-17 17:56:22'),(413,3687,3,40812,40821,57,3045,2,0,'2021-04-10',7200.00,'Factura C N°: 0001-00000139',NULL,'2021-05-17 17:36:21','2021-05-17 17:56:55','2021-05-17 17:56:55');
INSERT INTO `cta_cte_cliente` VALUES (414,3687,3,40812,40835,57,3045,2,0,'2021-04-12',20500.06,'Factura A N°: 0001-00000242',NULL,'2021-05-17 17:36:21','2021-05-18 02:22:40','2021-05-18 02:22:40'),(415,3687,3,40812,40821,57,3045,2,0,'2021-04-14',4400.00,'Factura C N°: 0001-00000142',NULL,'2021-05-17 17:36:21','2021-05-17 17:57:16','2021-05-17 17:57:16'),(416,3687,3,40812,40726,57,3045,2,0,'2021-04-14',18488.23,'Factura A N°: 0010-00000071',NULL,'2021-05-17 17:36:21','2021-05-18 02:22:30','2021-05-18 02:22:30'),(417,3687,3,40812,40821,57,3045,2,0,'2021-04-15',6400.00,'Factura C N°: 0001-00000143',NULL,'2021-05-17 17:36:21','2021-05-17 17:48:38','2021-05-17 17:48:38'),(418,3687,3,40812,40774,57,3045,2,0,'2021-04-15',990.00,'Factura C N°: 0002-00000482',NULL,'2021-05-17 17:36:21','2021-05-17 17:57:44','2021-05-17 17:57:44'),(419,3687,3,40812,40824,57,3045,2,0,'2021-04-16',1875.50,'Factura A N°: 0004-00008015',NULL,'2021-05-17 17:36:21','2021-05-18 02:22:07','2021-05-18 02:22:07'),(420,3687,3,40812,40730,57,3045,2,0,'2021-04-16',3859.42,'Factura A N°: 0004-00061308',NULL,'2021-05-17 17:36:21','2021-05-18 02:22:01','2021-05-18 02:22:01'),(421,3687,3,40812,40821,57,3045,2,0,'2021-04-16',7200.00,'Factura C N°: 0001-00000144',NULL,'2021-05-17 17:36:21','2021-05-17 17:58:02','2021-05-17 17:58:02'),(422,3687,3,40812,40732,57,3045,2,0,'2021-04-18',9227.65,'Factura A N°: 2468-00168936',NULL,'2021-05-17 17:36:21','2021-05-18 02:21:50','2021-05-18 02:21:50'),(423,3687,3,40812,40818,57,3045,2,0,'2021-04-20',68716.12,'Nota de débito A N°: 0010-00001360',NULL,'2021-05-17 17:36:21','2021-05-18 02:21:44','2021-05-18 02:21:44'),(424,3687,3,40812,40821,57,3045,2,0,'2021-04-21',5600.00,'Factura C N°: 0001-00000145',NULL,'2021-05-17 17:36:21','2021-05-17 18:00:32','2021-05-17 18:00:32'),(425,3687,3,40812,40836,57,3045,2,0,'2021-04-21',132.00,'Factura A N°: 0050-02114270',NULL,'2021-05-17 17:36:21','2021-05-18 13:14:26','2021-05-18 13:14:26'),(426,3687,3,40812,40721,57,3045,2,0,'2021-04-22',6900.00,'Factura C N°: 0004-00000670',NULL,'2021-05-17 17:36:21','2021-05-17 18:00:51','2021-05-17 18:00:51'),(427,3687,3,40812,40821,57,3045,2,0,'2021-04-24',7200.00,'Factura C N°: 0001-00000147',NULL,'2021-05-17 17:36:21','2021-05-17 18:01:08','2021-05-17 18:01:08'),(428,3687,3,40812,40736,57,3045,2,0,'2021-04-26',43218.99,'Factura A N°: 0078-00119280',NULL,'2021-05-17 17:36:21','2021-05-18 02:21:34','2021-05-18 02:21:34'),(429,3687,3,40812,40730,57,3045,2,0,'2021-04-27',1117.60,'Factura A N°: 0004-00062246',NULL,'2021-05-17 17:36:21','2021-05-18 02:21:29','2021-05-18 02:21:29'),(430,3687,3,40812,40821,57,3045,2,0,'2021-04-27',5200.00,'Factura C N°: 0001-00000148',NULL,'2021-05-17 17:36:21','2021-05-17 18:01:22','2021-05-17 18:01:22'),(431,3687,3,40812,40837,57,3045,2,0,'2021-04-28',1059256.69,'Factura A N°: 0005-00055876',NULL,'2021-05-17 17:36:21','2021-05-18 02:21:16','2021-05-18 02:21:16'),(432,3687,3,40812,40826,57,3045,2,0,'2021-04-29',298147.63,'Factura A N°: 0002-00000215',NULL,'2021-05-17 17:36:21','2021-05-18 02:21:11','2021-05-18 02:21:11'),(433,3687,3,40812,40837,57,3045,2,0,'2021-04-30',670415.63,'Factura A N°: 0005-00055948',NULL,'2021-05-17 17:36:21','2021-05-18 02:21:03','2021-05-18 02:21:03'),(434,3687,3,40812,40827,57,3045,2,0,'2021-04-30',120000.00,'Factura C N°: 0003-00000049',NULL,'2021-05-17 17:36:21','2021-05-17 18:02:00','2021-05-17 18:02:00'),(435,3687,3,40812,40838,57,3045,2,0,'2021-04-30',327234.34,'Factura A N°: 0003-00000092',NULL,'2021-05-17 17:36:22','2021-05-18 02:20:49','2021-05-18 02:20:49'),(436,3687,3,40812,40825,57,3045,2,0,'2021-04-30',337505.78,'Factura A N°: 0002-00000468',NULL,'2021-05-17 17:36:22','2021-05-18 02:20:43','2021-05-18 02:20:43'),(437,3687,3,40812,40821,57,3045,2,0,'2021-04-30',7200.00,'Factura C N°: 0001-00000149',NULL,'2021-05-17 17:36:22','2021-05-17 18:02:15','2021-05-17 18:02:15'),(438,3687,2,40812,40839,13,3042,1,0,'2021-01-11',14132.80,'Factura A N°: 0004-00003370',NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL);
INSERT INTO `cta_cte_cliente` VALUES (439,3687,2,40812,40787,13,3042,1,0,'2021-01-13',79309.45,'Factura A N°: 0004-00003371',NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(440,3687,2,40812,40839,13,3042,2,0,'2021-01-13',14132.80,'Nota de crédito A N°: 0004-00000092',NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(441,3687,2,40812,40840,13,3042,1,0,'2021-01-14',43130.45,'Factura A N°: 0004-00003372',NULL,'2021-05-17 17:44:08','2021-05-17 17:44:08',NULL),(442,3687,2,40812,40841,13,3042,1,0,'2021-01-14',53155.30,'Factura A N°: 0004-00003373',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(443,3687,2,40812,40842,13,3042,1,0,'2021-01-14',34418.45,'Factura A N°: 0004-00003374',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(444,3687,2,40812,40843,13,3042,1,0,'2021-01-14',202070.00,'Factura A N°: 0004-00003375',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(445,3687,2,40812,40844,13,3042,1,0,'2021-01-14',312530.90,'Factura A N°: 0004-00003376',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(446,3687,2,40812,40845,13,3042,1,0,'2021-01-14',6183.10,'Factura A N°: 0004-00003377',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(447,3687,2,40812,40846,13,3042,1,0,'2021-01-14',124897.41,'Factura A N°: 0004-00003378',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(448,3687,2,40812,40847,13,3042,1,0,'2021-01-14',38502.20,'Factura A N°: 0004-00003379',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(449,3687,2,40812,40848,13,3042,1,0,'2021-01-14',7647.20,'Factura A N°: 0004-00003380',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(450,3687,2,40812,40849,13,3042,1,0,'2021-01-14',13358.40,'Factura A N°: 0004-00003381',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(451,3687,2,40812,40850,13,3042,1,0,'2021-01-14',33166.10,'Factura A N°: 0004-00003382',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(452,3687,2,40812,40841,13,3042,1,0,'2021-01-14',8082.80,'Factura A N°: 0004-00003383',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(453,3687,2,40812,40851,13,3042,1,0,'2021-01-14',94519.15,'Factura A N°: 0004-00003384',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(454,3687,2,40812,40852,13,3042,1,0,'2021-01-18',23788.60,'Factura A N°: 0004-00003385',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(455,3687,2,40812,40853,13,3042,1,0,'2021-01-18',49543.45,'Factura A N°: 0004-00003386',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(456,3687,2,40812,40854,13,3042,1,0,'2021-01-18',42973.15,'Factura A N°: 0004-00003387',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(457,3687,2,40812,40855,13,3042,1,0,'2021-01-18',25276.90,'Factura A N°: 0004-00003388',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(458,3687,2,40812,40856,13,3042,1,0,'2021-01-20',17545.00,'Factura A N°: 0004-00003389',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(459,3687,2,40812,40757,13,3042,1,0,'2021-01-20',38986.20,'Factura A N°: 0004-00003390',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(460,3687,2,40812,40857,13,3042,1,0,'2021-01-20',56083.50,'Factura A N°: 0004-00003391',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(461,3687,2,40812,40858,13,3042,1,0,'2021-01-20',62169.80,'Factura A N°: 0004-00003392',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(462,3687,2,40812,40859,13,3042,1,0,'2021-01-20',38530.03,'Factura A N°: 0004-00003393',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(463,3687,2,40812,40860,13,3042,1,0,'2021-01-20',91705.90,'Factura A N°: 0004-00003394',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(464,3687,2,40812,40846,13,3042,1,0,'2021-01-20',83617.05,'Factura A N°: 0004-00003395',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(465,3687,2,40812,40861,13,3042,1,0,'2021-01-21',36039.85,'Factura A N°: 0004-00003396',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL);
INSERT INTO `cta_cte_cliente` VALUES (466,3687,2,40812,40862,13,3042,1,0,'2021-01-21',19710.90,'Factura A N°: 0004-00003397',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(467,3687,2,40812,40863,13,3042,1,0,'2021-01-21',40716.50,'Factura A N°: 0004-00003398',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(468,3687,2,40812,40841,13,3042,1,0,'2021-01-27',15548.50,'Factura A N°: 0004-00003399',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(469,3687,2,40812,40864,13,3042,1,0,'2021-01-27',31850.83,'Factura A N°: 0004-00003400',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(470,3687,2,40812,40865,13,3042,1,0,'2021-01-27',30855.00,'Factura A N°: 0004-00003401',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(471,3687,2,40812,40866,13,3042,1,0,'2021-01-27',80138.30,'Factura A N°: 0004-00003402',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(472,3687,2,40812,40867,13,3042,1,0,'2021-01-28',353380.50,'Factura A N°: 0004-00003403',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(473,3687,2,40812,40868,13,3042,1,0,'2021-01-29',11622.05,'Factura A N°: 0004-00003404',NULL,'2021-05-17 17:44:09','2021-05-17 17:44:09',NULL),(474,3687,2,40812,40839,13,3043,1,0,'2021-02-01',29723.65,'Factura A N°: 0004-00003405',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(475,3687,2,40812,40862,13,3043,1,0,'2021-02-03',56265.00,'Factura A N°: 0004-00003406',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(476,3687,2,40812,40858,13,3043,1,0,'2021-02-03',72013.15,'Factura A N°: 0004-00003407',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(477,3687,2,40812,40869,13,3043,1,0,'2021-02-03',43910.90,'Factura A N°: 0004-00003408',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(478,3687,2,40812,40870,13,3043,1,0,'2021-02-03',9438.00,'Factura A N°: 0004-00003409',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(479,3687,2,40812,40844,13,3043,1,0,'2021-02-03',236557.06,'Factura A N°: 0004-00003410',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(480,3687,2,40812,40859,13,3043,1,0,'2021-02-03',72909.76,'Factura A N°: 0004-00003411',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(481,3687,2,40812,40871,13,3043,1,0,'2021-02-04',39058.80,'Factura A N°: 0004-00003412',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(482,3687,2,40812,40872,13,3043,1,0,'2021-02-04',30673.50,'Factura A N°: 0004-00003413',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(483,3687,2,40812,40873,13,3043,1,0,'2021-02-04',26674.45,'Factura A N°: 0004-00003414',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(484,3687,2,40812,40857,13,3043,1,0,'2021-02-10',79860.00,'Factura A N°: 0004-00003415',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(485,3687,2,40812,40874,13,3043,1,0,'2021-02-10',25289.00,'Factura A N°: 0004-00003416',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(486,3687,2,40812,40875,13,3043,1,0,'2021-02-10',53161.35,'Factura A N°: 0004-00003417',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(487,3687,2,40812,40724,13,3043,1,0,'2021-02-10',20859.94,'Factura A N°: 0004-00003418',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(488,3687,2,40812,40876,13,3043,1,0,'2021-02-10',9308.69,'Factura A N°: 0004-00003419',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(489,3687,2,40812,40876,13,3043,1,0,'2021-02-10',21979.80,'Factura A N°: 0004-00003420',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(490,3687,2,40812,40877,13,3043,1,0,'2021-02-10',40589.45,'Factura A N°: 0004-00003421',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(491,3687,2,40812,40878,13,3043,1,0,'2021-02-17',11389.73,'Factura A N°: 0004-00003422',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(492,3687,2,40812,40879,13,3043,1,0,'2021-02-17',16891.60,'Factura A N°: 0004-00003423',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL);
INSERT INTO `cta_cte_cliente` VALUES (493,3687,2,40812,40859,13,3043,1,0,'2021-02-17',13000.00,'Nota de débito A N°: 0004-00000090',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(494,3687,2,40812,40844,13,3043,1,0,'2021-02-18',483443.40,'Factura A N°: 0004-00003424',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(495,3687,2,40812,40880,13,3043,1,0,'2021-02-18',38980.15,'Factura A N°: 0004-00003425',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(496,3687,2,40812,40881,13,3043,1,0,'2021-02-18',71347.65,'Factura A N°: 0004-00003426',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(497,3687,2,40812,40758,13,3043,1,0,'2021-02-18',34642.30,'Factura A N°: 0004-00003427',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(498,3687,2,40812,40882,13,3043,1,0,'2021-02-18',181270.10,'Factura A N°: 0004-00003428',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(499,3687,2,40812,40802,13,3043,1,0,'2021-02-18',637381.17,'Factura A N°: 0004-00003429',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(500,3687,2,40812,40872,13,3043,1,0,'2021-02-25',21392.80,'Factura A N°: 0004-00003430',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(501,3687,2,40812,40847,13,3043,1,0,'2021-02-25',76230.00,'Factura A N°: 0004-00003431',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(502,3687,2,40812,40802,13,3043,1,0,'2021-02-25',129218.20,'Factura A N°: 0004-00003432',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(503,3687,2,40812,40869,13,3043,1,0,'2021-02-25',28798.00,'Factura A N°: 0004-00003433',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(504,3687,2,40812,40883,13,3043,1,0,'2021-02-25',10036.95,'Factura A N°: 0004-00003434',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(505,3687,2,40812,40843,13,3043,1,0,'2021-02-25',130353.30,'Factura A N°: 0004-00003435',NULL,'2021-05-17 17:44:23','2021-05-17 17:44:23',NULL),(506,3687,2,40812,40861,13,3043,1,0,'2021-02-25',43547.90,'Factura A N°: 0004-00003436',NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(507,3687,2,40812,40884,13,3043,1,0,'2021-02-25',42658.55,'Factura A N°: 0004-00003437',NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(508,3687,2,40812,40870,13,3043,1,0,'2021-02-25',9413.80,'Factura A N°: 0004-00003438',NULL,'2021-05-17 17:44:24','2021-05-17 17:44:24',NULL),(509,3687,2,40812,40842,13,3044,1,0,'2021-03-03',29524.00,'Factura A N°: 0004-00003439',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(510,3687,2,40812,40846,13,3044,1,0,'2021-03-03',121157.30,'Factura A N°: 0004-00003440',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(511,3687,2,40812,40727,13,3044,1,0,'2021-03-03',294661.57,'Factura A N°: 0004-00003441',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(512,3687,2,40812,40885,13,3044,1,0,'2021-03-03',51718.24,'Factura A N°: 0004-00003442',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(513,3687,2,40812,40864,13,3044,1,0,'2021-03-03',13404.38,'Factura A N°: 0004-00003443',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(514,3687,2,40812,40886,13,3044,1,0,'2021-03-03',22723.80,'Factura A N°: 0004-00003444',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(515,3687,2,40812,40887,13,3044,1,0,'2021-03-03',64783.40,'Factura A N°: 0004-00003445',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(516,3687,2,40812,40888,13,3044,1,0,'2021-03-03',58564.00,'Factura A N°: 0004-00003446',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(517,3687,2,40812,40754,13,3044,1,0,'2021-03-04',89273.80,'Factura A N°: 0004-00003447',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(518,3687,2,40812,40850,13,3044,1,0,'2021-03-04',25289.00,'Factura A N°: 0004-00003448',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(519,3687,2,40812,40852,13,3044,1,0,'2021-03-10',7223.70,'Factura A N°: 0004-00003449',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL);
INSERT INTO `cta_cte_cliente` VALUES (520,3687,2,40812,40849,13,3044,1,0,'2021-03-10',21755.80,'Factura A N°: 0004-00003450',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(521,3687,2,40812,40875,13,3044,1,0,'2021-03-10',32924.10,'Factura A N°: 0004-00003451',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(522,3687,2,40812,40757,13,3044,1,0,'2021-03-10',23595.00,'Factura A N°: 0004-00003452',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(523,3687,2,40812,40889,13,3044,1,0,'2021-03-10',57596.00,'Factura A N°: 0004-00003453',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(524,3687,2,40812,40890,13,3044,1,0,'2021-03-10',17085.20,'Factura A N°: 0004-00003454',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(525,3687,2,40812,40809,13,3044,1,0,'2021-03-10',37449.50,'Factura A N°: 0004-00003455',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(526,3687,2,40812,40844,13,3044,1,0,'2021-03-10',503338.91,'Factura A N°: 0004-00003456',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(527,3687,2,40812,40891,13,3044,1,0,'2021-03-10',19535.45,'Factura A N°: 0004-00003457',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(528,3687,2,40812,40840,13,3044,1,0,'2021-03-10',19389.04,'Factura A N°: 0004-00003458',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(529,3687,2,40812,40844,13,3044,1,0,'2021-03-10',288101.00,'Factura A N°: 0004-00003459',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(530,3687,2,40812,40892,13,3044,1,0,'2021-03-11',6340.40,'Factura A N°: 0004-00003460',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(531,3687,2,40812,40893,13,3044,1,0,'2021-03-11',36711.40,'Factura A N°: 0004-00003461',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(532,3687,2,40812,40727,13,3044,1,0,'2021-03-11',201065.70,'Factura A N°: 0004-00003462',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(533,3687,2,40812,40727,13,3044,1,0,'2021-03-11',36977.60,'Factura A N°: 0004-00003463',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(534,3687,2,40812,40894,13,3044,1,0,'2021-03-11',18101.60,'Factura A N°: 0004-00003464',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(535,3687,2,40812,40864,13,3044,1,0,'2021-03-18',10944.45,'Factura A N°: 0004-00003465',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(536,3687,2,40812,40842,13,3044,1,0,'2021-03-18',61280.45,'Factura A N°: 0004-00003466',NULL,'2021-05-17 17:44:41','2021-05-17 17:44:41',NULL),(537,3687,2,40812,40851,13,3044,1,0,'2021-03-18',65582.00,'Factura A N°: 0004-00003467',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(538,3687,2,40812,40859,13,3044,1,0,'2021-03-18',53057.29,'Factura A N°: 0004-00003468',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(539,3687,2,40812,40856,13,3044,1,0,'2021-03-18',25174.05,'Factura A N°: 0004-00003469',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(540,3687,2,40812,40724,13,3044,1,0,'2021-03-18',49368.00,'Factura A N°: 0004-00003470',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(541,3687,2,40812,40846,13,3044,1,0,'2021-03-18',10272.90,'Factura A N°: 0004-00003471',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(542,3687,2,40812,40868,13,3044,1,0,'2021-03-22',25289.00,'Factura A N°: 0004-00003472',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(543,3687,2,40812,40868,13,3044,1,0,'2021-03-22',4646.40,'Factura A N°: 0004-00003473',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(544,3687,2,40812,40776,13,3044,1,0,'2021-03-25',666982.25,'Factura A N°: 0004-00003474',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(545,3687,2,40812,40872,13,3044,1,0,'2021-03-25',16516.50,'Factura A N°: 0004-00003475',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(546,3687,2,40812,40727,13,3044,1,0,'2021-03-25',70853.92,'Factura A N°: 0004-00003476',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (547,3687,2,40812,40758,13,3044,1,0,'2021-03-30',2879.80,'Factura A N°: 0004-00003477',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(548,3687,2,40812,40848,13,3044,1,0,'2021-03-30',4186.60,'Factura A N°: 0004-00003478',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(549,3687,2,40812,40895,13,3044,1,0,'2021-03-30',6074.20,'Factura A N°: 0004-00003479',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(550,3687,2,40812,40896,13,3044,1,0,'2021-03-30',56410.20,'Factura A N°: 0004-00003480',NULL,'2021-05-17 17:44:42','2021-05-17 17:44:42',NULL),(551,3687,2,40812,40875,13,3045,1,0,'2021-04-07',19226.90,'Factura A N°: 0004-00003481',NULL,'2021-05-17 17:44:53','2021-05-18 02:16:29','2021-05-18 02:16:29'),(552,3687,2,40812,40897,13,3045,1,0,'2021-04-07',78202.30,'Factura A N°: 0004-00003482',NULL,'2021-05-17 17:44:53','2021-05-18 02:16:23','2021-05-18 02:16:23'),(553,3687,2,40812,40843,13,3045,1,0,'2021-04-07',141328.00,'Factura A N°: 0004-00003483',NULL,'2021-05-17 17:44:53','2021-05-18 02:16:19','2021-05-18 02:16:19'),(554,3687,2,40812,40898,13,3045,1,0,'2021-04-07',48708.55,'Factura A N°: 0004-00003484',NULL,'2021-05-17 17:44:53','2021-05-18 02:16:15','2021-05-18 02:16:15'),(555,3687,2,40812,40899,13,3045,1,0,'2021-04-07',64009.00,'Factura A N°: 0004-00003485',NULL,'2021-05-17 17:44:53','2021-05-18 02:16:11','2021-05-18 02:16:11'),(556,3687,2,40812,40839,13,3045,1,0,'2021-04-07',7810.55,'Factura A N°: 0004-00003486',NULL,'2021-05-17 17:44:53','2021-05-18 02:16:06','2021-05-18 02:16:06'),(557,3687,2,40812,40882,13,3045,1,0,'2021-04-07',143983.95,'Factura A N°: 0004-00003487',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(558,3687,2,40812,40841,13,3045,1,0,'2021-04-07',15028.20,'Factura A N°: 0004-00003488',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(559,3687,2,40812,40878,13,3045,1,0,'2021-04-07',68268.20,'Factura A N°: 0004-00003489',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(560,3687,2,40812,40846,13,3045,1,0,'2021-04-08',116768.63,'Factura A N°: 0004-00003490',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:58','2021-05-18 02:15:58'),(561,3687,2,40812,40855,13,3045,1,0,'2021-04-09',33250.80,'Factura A N°: 0004-00003491',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:53','2021-05-18 02:15:53'),(562,3687,2,40812,40776,13,3045,1,0,'2021-04-13',237281.00,'Factura A N°: 0004-00003492',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:49','2021-05-18 02:15:49'),(563,3687,2,40812,40900,13,3045,1,0,'2021-04-13',102569.28,'Factura A N°: 0004-00003493',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:44','2021-05-18 02:15:44'),(564,3687,2,40812,40864,13,3045,1,0,'2021-04-13',7514.10,'Factura A N°: 0004-00003494',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:39','2021-05-18 02:15:39'),(565,3687,2,40812,40847,13,3045,1,0,'2021-04-13',50820.00,'Factura A N°: 0004-00003495',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:35','2021-05-18 02:15:35'),(566,3687,2,40812,40848,13,3045,1,0,'2021-04-13',7623.00,'Factura A N°: 0004-00003496',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:30','2021-05-18 02:15:30'),(567,3687,2,40812,40896,13,3045,2,0,'2021-04-13',56410.20,'Nota de crédito A N°: 0004-00000093',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(568,3687,2,40812,40901,13,3045,1,0,'2021-04-14',63949.71,'Factura A N°: 0004-00003497',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(569,3687,2,40812,40873,13,3045,1,0,'2021-04-14',29403.00,'Factura A N°: 0004-00003498',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(570,3687,2,40812,40851,13,3045,1,0,'2021-04-14',47105.30,'Factura A N°: 0004-00003499',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(571,3687,2,40812,40882,13,3045,1,0,'2021-04-14',49912.50,'Factura A N°: 0004-00003500',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:23','2021-05-18 02:15:23');
INSERT INTO `cta_cte_cliente` VALUES (572,3687,2,40812,40902,13,3045,1,0,'2021-04-14',28967.40,'Factura A N°: 0004-00003501',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:19','2021-05-18 02:15:19'),(573,3687,2,40812,40850,13,3045,1,0,'2021-04-14',63633.90,'Factura A N°: 0004-00003502',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:15','2021-05-18 02:15:15'),(574,3687,2,40812,40878,13,3045,2,0,'2021-04-14',2048.05,'Nota de crédito A N°: 0004-00000094',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:10','2021-05-18 02:15:10'),(575,3687,2,40812,40903,13,3045,1,0,'2021-04-15',30534.35,'Factura A N°: 0004-00003503',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:05','2021-05-18 02:15:05'),(576,3687,2,40812,40904,13,3045,1,0,'2021-04-15',21235.50,'Factura A N°: 0004-00003504',NULL,'2021-05-17 17:44:53','2021-05-18 02:15:01','2021-05-18 02:15:01'),(577,3687,2,40812,40852,13,3045,1,0,'2021-04-15',29838.60,'Factura A N°: 0004-00003505',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(578,3687,2,40812,40859,13,3045,1,0,'2021-04-15',37274.05,'Factura A N°: 0004-00003506',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(579,3687,2,40812,40861,13,3045,1,0,'2021-04-15',66562.10,'Factura A N°: 0004-00003507',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(580,3687,2,40812,40758,13,3045,1,0,'2021-04-15',23637.35,'Factura A N°: 0004-00003508',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:55','2021-05-18 02:14:55'),(581,3687,2,40812,40844,13,3045,1,0,'2021-04-15',80856.14,'Factura A N°: 0004-00003509',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:49','2021-05-18 02:14:49'),(582,3687,2,40812,40727,13,3045,1,0,'2021-04-15',76697.54,'Factura A N°: 0004-00003510',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:44','2021-05-18 02:14:44'),(583,3687,2,40812,40844,13,3045,1,0,'2021-04-15',668632.69,'Factura A N°: 0004-00003511',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:40','2021-05-18 02:14:40'),(584,3687,2,40812,40841,13,3045,1,0,'2021-04-21',18367.80,'Factura A N°: 0004-00003512',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:36','2021-05-18 02:14:36'),(585,3687,2,40812,40905,13,3045,1,0,'2021-04-21',37485.80,'Factura A N°: 0004-00003513',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:32','2021-05-18 02:14:32'),(586,3687,2,40812,40844,13,3045,1,0,'2021-04-21',856268.60,'Factura A N°: 0004-00003514',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:27','2021-05-18 02:14:27'),(587,3687,2,40812,40904,13,3045,1,0,'2021-04-21',7332.60,'Factura A N°: 0004-00003515',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(588,3687,2,40812,40872,13,3045,1,0,'2021-04-22',30056.40,'Factura A N°: 0004-00003516',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(589,3687,2,40812,40906,13,3045,1,0,'2021-04-22',12559.80,'Factura A N°: 0004-00003517',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(590,3687,2,40812,40758,13,3045,1,0,'2021-04-22',26136.00,'Factura A N°: 0004-00003518',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(591,3687,2,40812,40787,13,3045,1,0,'2021-04-22',67687.40,'Factura A N°: 0004-00003519',NULL,'2021-05-17 17:44:53','2021-05-23 14:31:16','2021-05-23 14:31:16'),(592,3687,2,40812,40844,13,3045,1,0,'2021-04-22',68716.12,'Nota de débito A N°: 0004-00000091',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:18','2021-05-18 02:14:18'),(593,3687,2,40812,40877,13,3045,1,0,'2021-04-29',41539.30,'Factura A N°: 0004-00003520',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:11','2021-05-18 02:14:11'),(594,3687,2,40812,40842,13,3045,1,0,'2021-04-29',63875.90,'Factura A N°: 0004-00003521',NULL,'2021-05-17 17:44:53','2021-05-18 02:14:04','2021-05-18 02:14:04'),(595,3687,2,40812,40875,13,3045,1,0,'2021-04-29',69012.35,'Factura A N°: 0004-00003522',NULL,'2021-05-17 17:44:53','2021-05-18 02:13:45','2021-05-18 02:13:45');
INSERT INTO `cta_cte_cliente` VALUES (596,3687,2,40812,40907,13,3045,1,0,'2021-04-29',17532.90,'Factura A N°: 0004-00003523',NULL,'2021-05-17 17:44:53','2021-05-18 02:13:19','2021-05-18 02:13:19'),(597,3687,3,40812,40721,57,3045,2,0,'2021-04-01',6900.00,'Factura C N°: 0004-00000665',NULL,'2021-05-17 17:45:58','2021-05-18 02:23:38','2021-05-18 02:23:38'),(598,3687,3,40812,40821,57,3045,2,0,'2021-04-15',6400.00,'Factura C N°: 0001-00000143',NULL,'2021-05-17 17:48:38','2021-05-17 17:57:30','2021-05-17 17:57:30'),(599,3687,3,40812,40821,57,3045,2,0,'2021-04-01',6400.00,'Factura C N°: 0001-00000138',NULL,'2021-05-17 17:50:37','2021-05-18 02:23:28','2021-05-18 02:23:28'),(600,3687,3,40812,40816,57,3045,2,0,'2021-04-05',4953.00,'Factura A N°: 0063-01473308',NULL,'2021-05-17 17:52:08','2021-05-17 17:53:42','2021-05-17 17:53:42'),(601,3687,3,40812,40816,57,3045,2,0,'2021-04-05',4836.00,'Factura A N°: 0063-01473308',NULL,'2021-05-17 17:53:42','2021-05-18 02:23:14','2021-05-18 02:23:14'),(602,3687,3,40812,40721,57,3045,1,0,'2021-04-07',6900.00,'Nota de crédito C N°: 0004-00000007',NULL,'2021-05-17 17:54:20','2021-05-18 02:23:08','2021-05-18 02:23:08'),(603,3687,3,40812,40819,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000078',NULL,'2021-05-17 17:55:29','2021-05-18 02:23:03','2021-05-18 02:23:03'),(604,3687,3,40812,40817,57,3045,2,0,'2021-04-08',55000.00,'Factura C N°: 0002-00000036',NULL,'2021-05-17 17:55:55','2021-05-18 02:22:56','2021-05-18 02:22:56'),(605,3687,3,40812,40820,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000072',NULL,'2021-05-17 17:56:22','2021-05-18 02:22:50','2021-05-18 02:22:50'),(606,3687,3,40812,40821,57,3045,2,0,'2021-04-10',7200.00,'Factura C N°: 0001-00000139',NULL,'2021-05-17 17:56:55','2021-05-18 02:22:45','2021-05-18 02:22:45'),(607,3687,3,40812,40821,57,3045,2,0,'2021-04-14',4400.00,'Factura C N°: 0001-00000142',NULL,'2021-05-17 17:57:16','2021-05-18 02:22:36','2021-05-18 02:22:36'),(608,3687,3,40812,40821,57,3045,2,0,'2021-04-15',6400.00,'Factura C N°: 0001-00000143',NULL,'2021-05-17 17:57:30','2021-05-18 02:22:25','2021-05-18 02:22:25'),(609,3687,3,40812,40774,57,3045,2,0,'2021-04-15',990.00,'Factura C N°: 0002-00000482',NULL,'2021-05-17 17:57:44','2021-05-18 02:22:15','2021-05-18 02:22:15'),(610,3687,3,40812,40821,57,3045,2,0,'2021-04-16',7200.00,'Factura C N°: 0001-00000144',NULL,'2021-05-17 17:58:02','2021-05-18 02:21:56','2021-05-18 02:21:56'),(611,3687,3,40812,40821,57,3045,2,0,'2021-04-21',5600.00,'Factura C N°: 0001-00000145',NULL,'2021-05-17 18:00:32','2021-05-18 13:14:26','2021-05-18 13:14:26'),(612,3687,3,40812,40721,57,3045,2,0,'2021-04-22',6900.00,'Factura C N°: 0004-00000670',NULL,'2021-05-17 18:00:51','2021-05-18 13:14:26','2021-05-18 13:14:26'),(613,3687,3,40812,40821,57,3045,2,0,'2021-04-24',7200.00,'Factura C N°: 0001-00000147',NULL,'2021-05-17 18:01:08','2021-05-18 13:14:26','2021-05-18 13:14:26'),(614,3687,3,40812,40821,57,3045,2,0,'2021-04-27',5200.00,'Factura C N°: 0001-00000148',NULL,'2021-05-17 18:01:22','2021-05-18 02:21:23','2021-05-18 02:21:23'),(615,3687,3,40812,40827,57,3045,2,0,'2021-04-30',120000.00,'Factura C N°: 0003-00000049',NULL,'2021-05-17 18:02:00','2021-05-18 02:20:55','2021-05-18 02:20:55'),(616,3687,3,40812,40821,57,3045,2,0,'2021-04-30',7200.00,'Factura C N°: 0001-00000149',NULL,'2021-05-17 18:02:15','2021-05-18 02:20:33','2021-05-18 02:20:33'),(617,3687,3,40812,40813,57,3045,2,0,'2021-04-01',3100.00,'Factura B N°: 0003-00000690',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(618,3687,3,40812,40721,57,3045,2,0,'2021-04-01',6900.00,'Factura C N°: 0004-00000665',NULL,'2021-05-19 02:00:27','2021-05-19 02:02:53','2021-05-19 02:02:53'),(619,3687,3,40812,40814,57,3045,2,0,'2021-04-01',5227.20,'Factura A N°: 0002-00004083',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(620,3687,3,40812,40821,57,3045,2,0,'2021-04-01',6400.00,'Factura C N°: 0001-00000138',NULL,'2021-05-19 02:00:27','2021-05-19 02:03:16','2021-05-19 02:03:16');
INSERT INTO `cta_cte_cliente` VALUES (621,3687,3,40812,40722,57,3045,2,0,'2021-04-01',21175.00,'Factura A N°: 0004-00000067',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(622,3687,3,40812,40816,57,3045,2,0,'2021-04-05',4836.00,'Factura A N°: 0063-01473308',NULL,'2021-05-19 02:00:27','2021-05-19 02:06:10','2021-05-19 02:06:10'),(623,3687,3,40812,40721,57,3045,1,0,'2021-04-07',6900.00,'Nota de crédito C N°: 0004-00000007',NULL,'2021-05-19 02:00:27','2021-05-19 02:08:12','2021-05-19 02:08:12'),(624,3687,3,40812,40819,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000078',NULL,'2021-05-19 02:00:27','2021-05-19 02:08:43','2021-05-19 02:08:43'),(625,3687,3,40812,40817,57,3045,2,0,'2021-04-08',55000.00,'Factura C N°: 0002-00000036',NULL,'2021-05-19 02:00:27','2021-05-19 02:09:08','2021-05-19 02:09:08'),(626,3687,3,40812,40820,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000072',NULL,'2021-05-19 02:00:27','2021-05-19 02:09:28','2021-05-19 02:09:28'),(627,3687,3,40812,40821,57,3045,2,0,'2021-04-10',7200.00,'Factura C N°: 0001-00000139',NULL,'2021-05-19 02:00:27','2021-05-19 02:10:05','2021-05-19 02:10:05'),(628,3687,3,40812,40835,57,3045,2,0,'2021-04-12',20500.06,'Factura A N°: 0001-00000242',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:23','2021-05-19 02:40:23'),(629,3687,3,40812,40821,57,3045,2,0,'2021-04-14',4400.00,'Factura C N°: 0001-00000142',NULL,'2021-05-19 02:00:27','2021-05-19 02:10:18','2021-05-19 02:10:18'),(630,3687,3,40812,40726,57,3045,2,0,'2021-04-14',18488.23,'Factura A N°: 0010-00000071',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(631,3687,3,40812,40821,57,3045,2,0,'2021-04-15',6400.00,'Factura C N°: 0001-00000143',NULL,'2021-05-19 02:00:27','2021-05-19 02:10:28','2021-05-19 02:10:28'),(632,3687,3,40812,40774,57,3045,2,0,'2021-04-15',990.00,'Factura C N°: 0002-00000482',NULL,'2021-05-19 02:00:27','2021-05-19 02:11:17','2021-05-19 02:11:17'),(633,3687,3,40812,40824,57,3045,2,0,'2021-04-16',1875.50,'Factura A N°: 0004-00008015',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(634,3687,3,40812,40730,57,3045,2,0,'2021-04-16',3859.42,'Factura A N°: 0004-00061308',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(635,3687,3,40812,40821,57,3045,2,0,'2021-04-16',7200.00,'Factura C N°: 0001-00000144',NULL,'2021-05-19 02:00:27','2021-05-19 02:11:33','2021-05-19 02:11:33'),(636,3687,3,40812,40732,57,3045,2,0,'2021-04-18',9227.65,'Factura A N°: 2468-00168936',NULL,'2021-05-19 02:00:27','2021-05-19 02:12:33','2021-05-19 02:12:33'),(637,3687,3,40812,40818,57,3045,2,0,'2021-04-20',68716.12,'Nota de débito A N°: 0010-00001360',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(638,3687,3,40812,40836,57,3045,2,0,'2021-04-21',132.00,'Factura A N°: 0050-02114270',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(639,3687,3,40812,40821,57,3045,2,0,'2021-04-21',5600.00,'Factura C N°: 0001-00000145',NULL,'2021-05-19 02:00:27','2021-05-19 02:12:49','2021-05-19 02:12:49'),(640,3687,3,40812,40721,57,3045,2,0,'2021-04-22',6900.00,'Factura C N°: 0004-00000670',NULL,'2021-05-19 02:00:27','2021-05-19 02:01:56','2021-05-19 02:01:56'),(641,3687,3,40812,40821,57,3045,2,0,'2021-04-24',7200.00,'Factura C N°: 0001-00000147',NULL,'2021-05-19 02:00:27','2021-05-19 02:13:28','2021-05-19 02:13:28'),(642,3687,3,40812,40736,57,3045,2,0,'2021-04-26',43218.99,'Factura A N°: 0078-00119280',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(643,3687,3,40812,40730,57,3045,2,0,'2021-04-27',1117.60,'Factura A N°: 0004-00062246',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(644,3687,3,40812,40821,57,3045,2,0,'2021-04-27',5200.00,'Factura C N°: 0001-00000148',NULL,'2021-05-19 02:00:27','2021-05-19 02:13:43','2021-05-19 02:13:43'),(645,3687,3,40812,40837,57,3045,2,0,'2021-04-28',1059256.69,'Factura A N°: 0005-00055876',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24');
INSERT INTO `cta_cte_cliente` VALUES (646,3687,3,40812,40826,57,3045,2,0,'2021-04-29',298147.63,'Factura A N°: 0002-00000215',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(647,3687,3,40812,40837,57,3045,2,0,'2021-04-30',670415.63,'Factura A N°: 0005-00055948',NULL,'2021-05-19 02:00:27','2021-05-19 02:40:24','2021-05-19 02:40:24'),(648,3687,3,40812,40827,57,3045,2,0,'2021-04-30',120000.00,'Factura C N°: 0003-00000049',NULL,'2021-05-19 02:00:28','2021-05-19 02:02:22','2021-05-19 02:02:22'),(649,3687,3,40812,40838,57,3045,2,0,'2021-04-30',327234.34,'Factura A N°: 0003-00000092',NULL,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(650,3687,3,40812,40825,57,3045,2,0,'2021-04-30',337505.78,'Factura A N°: 0002-00000468',NULL,'2021-05-19 02:00:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(651,3687,3,40812,40821,57,3045,2,0,'2021-04-30',7200.00,'Factura C N°: 0001-00000149',NULL,'2021-05-19 02:00:28','2021-05-19 02:02:10','2021-05-19 02:02:10'),(652,3687,3,40812,40721,57,3045,2,0,'2021-04-22',6900.00,'Factura C N°: 0004-00000670',NULL,'2021-05-19 02:01:56','2021-05-19 02:13:11','2021-05-19 02:13:11'),(653,3687,3,40812,40821,57,3045,2,0,'2021-04-30',7200.00,'Factura C N°: 0001-00000149',NULL,'2021-05-19 02:02:10','2021-05-19 02:14:13','2021-05-19 02:14:13'),(654,3687,3,40812,40827,57,3045,2,0,'2021-04-30',120000.00,'Factura C N°: 0003-00000049',NULL,'2021-05-19 02:02:22','2021-05-19 02:13:56','2021-05-19 02:13:56'),(655,3687,3,40812,40721,57,3045,2,0,'2021-04-01',6900.00,'Factura C N°: 0004-00000665',NULL,'2021-05-19 02:02:53','2021-05-19 02:40:23','2021-05-19 02:40:23'),(656,3687,3,40812,40821,57,3045,2,0,'2021-04-01',6400.00,'Factura C N°: 0001-00000138',NULL,'2021-05-19 02:03:16','2021-05-19 02:40:23','2021-05-19 02:40:23'),(657,3687,3,40812,40816,57,3045,2,0,'2021-04-05',4953.00,'Factura A N°: 0063-01473308',NULL,'2021-05-19 02:06:10','2021-05-19 02:07:37','2021-05-19 02:07:37'),(658,3687,3,40812,40816,57,3045,2,0,'2021-04-05',4836.00,'Factura A N°: 0063-01473308',NULL,'2021-05-19 02:07:37','2021-05-19 02:40:23','2021-05-19 02:40:23'),(659,3687,3,40812,40721,57,3045,1,0,'2021-04-07',6900.00,'Nota de crédito C N°: 0004-00000007',NULL,'2021-05-19 02:08:12','2021-05-19 02:40:23','2021-05-19 02:40:23'),(660,3687,3,40812,40819,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000078',NULL,'2021-05-19 02:08:43','2021-05-19 02:40:23','2021-05-19 02:40:23'),(661,3687,3,40812,40817,57,3045,2,0,'2021-04-08',55000.00,'Factura C N°: 0002-00000036',NULL,'2021-05-19 02:09:08','2021-05-19 02:40:23','2021-05-19 02:40:23'),(662,3687,3,40812,40820,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000072',NULL,'2021-05-19 02:09:28','2021-05-19 02:40:23','2021-05-19 02:40:23'),(663,3687,3,40812,40821,57,3045,2,0,'2021-04-10',7200.00,'Factura C N°: 0001-00000139',NULL,'2021-05-19 02:10:05','2021-05-19 02:40:23','2021-05-19 02:40:23'),(664,3687,3,40812,40821,57,3045,2,0,'2021-04-14',4400.00,'Factura C N°: 0001-00000142',NULL,'2021-05-19 02:10:18','2021-05-19 02:40:24','2021-05-19 02:40:24'),(665,3687,3,40812,40821,57,3045,2,0,'2021-04-15',6400.00,'Factura C N°: 0001-00000143',NULL,'2021-05-19 02:10:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(666,3687,3,40812,40774,57,3045,2,0,'2021-04-15',990.00,'Factura C N°: 0002-00000482',NULL,'2021-05-19 02:11:17','2021-05-19 02:40:24','2021-05-19 02:40:24'),(667,3687,3,40812,40821,57,3045,2,0,'2021-04-16',7200.00,'Factura C N°: 0001-00000144',NULL,'2021-05-19 02:11:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(668,3687,3,40812,40732,57,3045,2,0,'2021-04-18',9227.65,'Factura A N°: 2468-00168936',NULL,'2021-05-19 02:12:33','2021-05-19 02:40:24','2021-05-19 02:40:24'),(669,3687,3,40812,40821,57,3045,2,0,'2021-04-21',5600.00,'Factura C N°: 0001-00000145',NULL,'2021-05-19 02:12:49','2021-05-19 02:40:24','2021-05-19 02:40:24'),(670,3687,3,40812,40721,57,3045,2,0,'2021-04-22',6900.00,'Factura C N°: 0004-00000670',NULL,'2021-05-19 02:13:11','2021-05-19 02:40:24','2021-05-19 02:40:24');
INSERT INTO `cta_cte_cliente` VALUES (671,3687,3,40812,40821,57,3045,2,0,'2021-04-24',7200.00,'Factura C N°: 0001-00000147',NULL,'2021-05-19 02:13:28','2021-05-19 02:40:24','2021-05-19 02:40:24'),(672,3687,3,40812,40821,57,3045,2,0,'2021-04-27',5200.00,'Factura C N°: 0001-00000148',NULL,'2021-05-19 02:13:43','2021-05-19 02:40:24','2021-05-19 02:40:24'),(673,3687,3,40812,40827,57,3045,2,0,'2021-04-30',120000.00,'Factura C N°: 0003-00000049',NULL,'2021-05-19 02:13:56','2021-05-19 02:40:24','2021-05-19 02:40:24'),(674,3687,3,40812,40821,57,3045,2,0,'2021-04-30',7200.00,'Factura C N°: 0001-00000149',NULL,'2021-05-19 02:14:13','2021-05-19 02:40:24','2021-05-19 02:40:24'),(675,3687,3,40812,40813,57,3045,2,0,'2021-04-01',3100.00,'Factura B N°: 0003-00000690',NULL,'2021-05-19 02:42:46','2021-05-23 14:06:06','2021-05-23 14:06:06'),(676,3687,3,40812,40721,57,3045,2,0,'2021-04-01',6900.00,'Factura C N°: 0004-00000665',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(677,3687,3,40812,40814,57,3045,2,0,'2021-04-01',5227.20,'Factura A N°: 0002-00004083',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(678,3687,3,40812,40821,57,3045,2,0,'2021-04-01',6400.00,'Factura C N°: 0001-00000138',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(679,3687,3,40812,40722,57,3045,2,0,'2021-04-01',21175.00,'Factura A N°: 0004-00000067',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(680,3687,3,40812,40816,57,3045,2,0,'2021-04-05',4836.00,'Factura A N°: 0063-01473308',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(681,3687,3,40812,40721,57,3045,1,0,'2021-04-07',6900.00,'Nota de crédito C N°: 0004-00000007',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(682,3687,3,40812,40819,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000078',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(683,3687,3,40812,40817,57,3045,2,0,'2021-04-08',55000.00,'Factura C N°: 0002-00000036',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(684,3687,3,40812,40820,57,3045,2,0,'2021-04-08',12000.00,'Factura C N°: 0001-00000072',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(685,3687,3,40812,40821,57,3045,2,0,'2021-04-10',7200.00,'Factura C N°: 0001-00000139',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(686,3687,3,40812,40835,57,3045,2,0,'2021-04-12',20500.06,'Factura A N°: 0001-00000242',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(687,3687,3,40812,40821,57,3045,2,0,'2021-04-14',4400.00,'Factura C N°: 0001-00000142',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(688,3687,3,40812,40726,57,3045,2,0,'2021-04-14',18488.23,'Factura A N°: 0010-00000071',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(689,3687,3,40812,40821,57,3045,2,0,'2021-04-15',6400.00,'Factura C N°: 0001-00000143',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(690,3687,3,40812,40774,57,3045,2,0,'2021-04-15',990.00,'Factura C N°: 0002-00000482',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(691,3687,3,40812,40824,57,3045,2,0,'2021-04-16',1875.50,'Factura A N°: 0004-00008015',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(692,3687,3,40812,40730,57,3045,2,0,'2021-04-16',3859.42,'Factura A N°: 0004-00061308',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(693,3687,3,40812,40821,57,3045,2,0,'2021-04-16',7200.00,'Factura C N°: 0001-00000144',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(694,3687,3,40812,40732,57,3045,2,0,'2021-04-18',9227.65,'Factura A N°: 2468-00168936',NULL,'2021-05-19 02:42:46','2021-05-19 02:42:46',NULL),(695,3687,3,40812,40818,57,3045,2,0,'2021-04-20',68716.12,'Nota de débito A N°: 0010-00001360',NULL,'2021-05-19 02:42:47','2021-05-20 18:01:57','2021-05-20 18:01:57'),(696,3687,3,40812,40836,57,3045,2,0,'2021-04-21',132.00,'Factura A N°: 0050-02114270',NULL,'2021-05-19 02:42:47','2021-05-23 13:02:08','2021-05-23 13:02:08'),(697,3687,3,40812,40821,57,3045,2,0,'2021-04-21',5600.00,'Factura C N°: 0001-00000145',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (698,3687,3,40812,40721,57,3045,2,0,'2021-04-22',6900.00,'Factura C N°: 0004-00000670',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(699,3687,3,40812,40821,57,3045,2,0,'2021-04-24',7200.00,'Factura C N°: 0001-00000147',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(700,3687,3,40812,40736,57,3045,2,0,'2021-04-26',43218.99,'Factura A N°: 0078-00119280',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(701,3687,3,40812,40730,57,3045,2,0,'2021-04-27',1117.60,'Factura A N°: 0004-00062246',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(702,3687,3,40812,40821,57,3045,2,0,'2021-04-27',5200.00,'Factura C N°: 0001-00000148',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(703,3687,3,40812,40837,57,3045,2,0,'2021-04-28',1059256.69,'Factura A N°: 0005-00055876',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(704,3687,3,40812,40826,57,3045,2,0,'2021-04-29',298147.63,'Factura A N°: 0002-00000215',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(705,3687,3,40812,40837,57,3045,2,0,'2021-04-30',670415.63,'Factura A N°: 0005-00055948',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(706,3687,3,40812,40827,57,3045,2,0,'2021-04-30',120000.00,'Factura C N°: 0003-00000049',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(707,3687,3,40812,40838,57,3045,2,0,'2021-04-30',327234.34,'Factura A N°: 0003-00000092',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(708,3687,3,40812,40825,57,3045,2,0,'2021-04-30',337505.78,'Factura A N°: 0002-00000468',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(709,3687,3,40812,40821,57,3045,2,0,'2021-04-30',7200.00,'Factura C N°: 0001-00000149',NULL,'2021-05-19 02:42:47','2021-05-19 02:42:47',NULL),(710,3687,3,40812,40818,57,3045,2,0,'2021-04-20',68716.12,'Nota de débito A N°: 0010-00001360',NULL,'2021-05-20 18:01:57','2021-05-20 18:01:57',NULL),(711,3687,3,40812,40950,57,3045,2,0,'2021-04-01',1810.00,'Factura A N°: 0011-00027656',NULL,'2021-05-20 18:32:43','2021-05-20 18:32:43',NULL),(712,3687,3,40812,40951,57,3045,2,0,'2021-04-08',3900.68,'Factura A N°: 0032-00039516',NULL,'2021-05-20 18:35:08','2021-05-20 18:35:08',NULL),(713,3687,3,40812,40746,57,3045,2,0,'2021-04-08',1263.90,'Factura A N°: 72051-06062343',NULL,'2021-05-20 18:37:14','2021-05-20 18:37:14',NULL),(714,3687,3,40812,40746,57,3045,2,0,'2021-04-08',895.88,'Factura A N°: 72051-06072863',NULL,'2021-05-20 18:38:25','2021-05-20 18:38:25',NULL),(715,3687,3,40812,40952,57,3045,2,0,'2021-04-13',50345.21,'Factura A N°: 0001-02686404',NULL,'2021-05-20 18:41:01','2021-05-20 18:41:01',NULL),(716,3687,3,40812,40953,57,3045,2,0,'2021-04-13',3435.74,'Factura A N°: 0006-00032132',NULL,'2021-05-20 18:42:35','2021-05-23 13:56:23','2021-05-23 13:56:23'),(717,3687,3,40812,40952,57,3045,2,0,'2021-04-21',43366.44,'Factura A N°: 0001-05455234',NULL,'2021-05-20 18:44:27','2021-05-23 13:57:07','2021-05-23 13:57:07'),(718,3687,3,40812,40951,57,3045,2,0,'2021-04-24',4300.44,'Factura A N°: 0034-00000751',NULL,'2021-05-20 18:45:37','2021-05-20 18:45:37',NULL),(719,3687,3,40812,40954,57,3045,2,0,'2021-04-28',530.00,'Factura A N°: 24509-00005331',NULL,'2021-05-20 18:47:27','2021-05-20 18:47:27',NULL),(720,3687,3,40812,40955,57,3045,2,0,'2021-04-29',842.81,'Factura A N°: 0231-09885047',NULL,'2021-05-20 18:50:01','2021-05-20 18:50:01',NULL),(721,3687,3,40812,40955,57,3045,2,0,'2021-04-29',1097.04,'Factura A N°: 0014-00310511',NULL,'2021-05-20 18:51:15','2021-05-20 18:51:15',NULL),(722,3687,3,40812,40956,57,3045,2,0,'2021-04-30',7534.82,'Factura A N°: 0014-20210430',NULL,'2021-05-20 18:54:12','2021-05-20 18:54:12',NULL),(723,3687,2,40812,40744,13,3045,1,0,'2021-04-29',34239.22,'Factura A N°: 0029-20210429',NULL,'2021-05-23 13:12:48','2021-05-23 13:16:16','2021-05-23 13:16:16'),(724,3687,2,40812,40744,13,3045,1,0,'2021-04-29',27909.94,'Factura A N°: 0029-20210429',NULL,'2021-05-23 13:16:16','2021-05-23 14:31:16','2021-05-23 14:31:16');
INSERT INTO `cta_cte_cliente` VALUES (725,3687,3,40812,40744,57,3045,2,0,'2021-04-29',26285.49,'Factura A N°: 0029-20210429',NULL,'2021-05-23 13:24:37','2021-05-23 13:24:37',NULL),(726,3687,3,40812,40953,57,3045,2,0,'2021-04-13',3435.74,'Factura A N°: 0006-00032132',NULL,'2021-05-23 13:56:23','2021-05-23 13:56:23',NULL),(727,3687,3,40812,40952,57,3045,2,0,'2021-04-21',43366.44,'Factura A N°: 0001-05455234',NULL,'2021-05-23 13:57:07','2021-05-23 13:57:07',NULL),(728,3687,2,40812,40875,13,3045,1,0,'2021-04-07',19226.90,'Factura A N°: 0004-00003481',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(729,3687,2,40812,40897,13,3045,1,0,'2021-04-07',78202.30,'Factura A N°: 0004-00003482',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(730,3687,2,40812,40843,13,3045,1,0,'2021-04-07',141328.00,'Factura A N°: 0004-00003483',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(731,3687,2,40812,40898,13,3045,1,0,'2021-04-07',48708.55,'Factura A N°: 0004-00003484',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(732,3687,2,40812,40899,13,3045,1,0,'2021-04-07',64009.00,'Factura A N°: 0004-00003485',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(733,3687,2,40812,40839,13,3045,1,0,'2021-04-07',7810.55,'Factura A N°: 0004-00003486',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(734,3687,2,40812,40882,13,3045,1,0,'2021-04-07',143983.95,'Factura A N°: 0004-00003487',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(735,3687,2,40812,40841,13,3045,1,0,'2021-04-07',15028.20,'Factura A N°: 0004-00003488',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(736,3687,2,40812,40878,13,3045,1,0,'2021-04-07',68268.20,'Factura A N°: 0004-00003489',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(737,3687,2,40812,40846,13,3045,1,0,'2021-04-08',116768.63,'Factura A N°: 0004-00003490',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(738,3687,2,40812,40855,13,3045,1,0,'2021-04-09',33250.80,'Factura A N°: 0004-00003491',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(739,3687,2,40812,40776,13,3045,1,0,'2021-04-13',237281.00,'Factura A N°: 0004-00003492',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(740,3687,2,40812,40900,13,3045,1,0,'2021-04-13',102569.28,'Factura A N°: 0004-00003493',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(741,3687,2,40812,40864,13,3045,1,0,'2021-04-13',7514.10,'Factura A N°: 0004-00003494',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(742,3687,2,40812,40847,13,3045,1,0,'2021-04-13',50820.00,'Factura A N°: 0004-00003495',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(743,3687,2,40812,40848,13,3045,1,0,'2021-04-13',7623.00,'Factura A N°: 0004-00003496',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(744,3687,2,40812,40896,13,3045,2,0,'2021-04-13',56410.20,'Nota de crédito A N°: 0004-00000093',NULL,'2021-05-23 14:33:37','2021-05-23 14:33:37',NULL),(745,3687,2,40812,40901,13,3045,1,0,'2021-04-14',63949.71,'Factura A N°: 0004-00003497',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(746,3687,2,40812,40873,13,3045,1,0,'2021-04-14',29403.00,'Factura A N°: 0004-00003498',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(747,3687,2,40812,40851,13,3045,1,0,'2021-04-14',47105.30,'Factura A N°: 0004-00003499',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(748,3687,2,40812,40882,13,3045,1,0,'2021-04-14',49912.50,'Factura A N°: 0004-00003500',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(749,3687,2,40812,40902,13,3045,1,0,'2021-04-14',28967.40,'Factura A N°: 0004-00003501',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(750,3687,2,40812,40850,13,3045,1,0,'2021-04-14',63633.90,'Factura A N°: 0004-00003502',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(751,3687,2,40812,40878,13,3045,2,0,'2021-04-14',2048.05,'Nota de crédito A N°: 0004-00000094',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL);
INSERT INTO `cta_cte_cliente` VALUES (752,3687,2,40812,40903,13,3045,1,0,'2021-04-15',30534.35,'Factura A N°: 0004-00003503',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(753,3687,2,40812,40904,13,3045,1,0,'2021-04-15',21235.50,'Factura A N°: 0004-00003504',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(754,3687,2,40812,40852,13,3045,1,0,'2021-04-15',29838.60,'Factura A N°: 0004-00003505',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(755,3687,2,40812,40859,13,3045,1,0,'2021-04-15',37274.05,'Factura A N°: 0004-00003506',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(756,3687,2,40812,40861,13,3045,1,0,'2021-04-15',66562.10,'Factura A N°: 0004-00003507',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(757,3687,2,40812,40758,13,3045,1,0,'2021-04-15',23637.35,'Factura A N°: 0004-00003508',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(758,3687,2,40812,40844,13,3045,1,0,'2021-04-15',80856.14,'Factura A N°: 0004-00003509',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(759,3687,2,40812,40727,13,3045,1,0,'2021-04-15',76697.54,'Factura A N°: 0004-00003510',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(760,3687,2,40812,40844,13,3045,1,0,'2021-04-15',668632.69,'Factura A N°: 0004-00003511',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(761,3687,2,40812,40841,13,3045,1,0,'2021-04-21',18367.80,'Factura A N°: 0004-00003512',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(762,3687,2,40812,40905,13,3045,1,0,'2021-04-21',37485.80,'Factura A N°: 0004-00003513',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(763,3687,2,40812,40844,13,3045,1,0,'2021-04-21',856268.60,'Factura A N°: 0004-00003514',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(764,3687,2,40812,40904,13,3045,1,0,'2021-04-21',7332.60,'Factura A N°: 0004-00003515',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(765,3687,2,40812,40872,13,3045,1,0,'2021-04-22',30056.40,'Factura A N°: 0004-00003516',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(766,3687,2,40812,40906,13,3045,1,0,'2021-04-22',12559.80,'Factura A N°: 0004-00003517',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(767,3687,2,40812,40758,13,3045,1,0,'2021-04-22',26136.00,'Factura A N°: 0004-00003518',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(768,3687,2,40812,40787,13,3045,1,0,'2021-04-22',67687.40,'Factura A N°: 0004-00003519',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(769,3687,2,40812,40844,13,3045,1,0,'2021-04-22',68716.12,'Nota de débito A N°: 0004-00000091',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(770,3687,2,40812,40877,13,3045,1,0,'2021-04-29',41539.30,'Factura A N°: 0004-00003520',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(771,3687,2,40812,40842,13,3045,1,0,'2021-04-29',63875.90,'Factura A N°: 0004-00003521',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(772,3687,2,40812,40875,13,3045,1,0,'2021-04-29',69012.35,'Factura A N°: 0004-00003522',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(773,3687,2,40812,40907,13,3045,1,0,'2021-04-29',17532.90,'Factura A N°: 0004-00003523',NULL,'2021-05-23 14:33:38','2021-05-23 14:33:38',NULL),(774,3687,2,40720,40796,13,1534,1,0,'2021-05-03',441173.01,'Factura A N°: 0001-00000951',NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(775,3687,2,40720,40750,13,1534,1,0,'2021-05-03',205000.00,'Factura A N°: 0001-00000952',NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(776,3687,2,40720,40750,13,1534,1,0,'2021-05-03',57685.54,'Factura A N°: 0001-00000953',NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(777,3687,2,40720,40957,13,1534,1,0,'2021-05-04',54700.00,'Factura A N°: 0001-00000954',NULL,'2021-06-14 12:29:05','2021-06-14 12:29:05',NULL),(778,3687,2,40720,40786,13,1534,1,0,'2021-05-04',16547.65,'Factura A N°: 0001-00000955',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL);
INSERT INTO `cta_cte_cliente` VALUES (779,3687,2,40720,40755,13,1534,1,0,'2021-05-04',257797.16,'Factura A N°: 0001-00000956',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(780,3687,2,40720,40786,13,1534,1,0,'2021-05-05',19305.59,'Factura A N°: 0001-00000957',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(781,3687,2,40720,40755,13,1534,1,0,'2021-05-05',104288.70,'Factura A N°: 0001-00000958',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(782,3687,2,40720,40755,13,1534,1,0,'2021-05-05',35953.79,'Factura A N°: 0001-00000959',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(783,3687,2,40720,40755,13,1534,1,0,'2021-05-05',48974.05,'Factura A N°: 0001-00000960',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(784,3687,2,40720,40755,13,1534,1,0,'2021-05-05',125789.28,'Factura A N°: 0001-00000961',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(785,3687,2,40720,40755,13,1534,1,0,'2021-05-05',37566.87,'Factura A N°: 0001-00000962',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(786,3687,2,40720,40804,13,1534,1,0,'2021-05-06',27117.69,'Factura A N°: 0001-00000963',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(787,3687,2,40720,40786,13,1534,1,0,'2021-05-06',2475.18,'Factura A N°: 0001-00000964',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(788,3687,2,40720,40958,13,1534,1,0,'2021-05-06',102975.84,'Factura A N°: 0001-00000965',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(789,3687,2,40720,40755,13,1534,1,0,'2021-05-06',29479.06,'Factura A N°: 0001-00000966',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(790,3687,2,40720,40750,13,1534,1,0,'2021-05-07',41118.83,'Factura A N°: 0001-00000967',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(791,3687,2,40720,40892,13,1534,1,0,'2021-05-10',12336.14,'Factura A N°: 0001-00000968',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(792,3687,2,40720,40959,13,1534,1,0,'2021-05-10',29479.06,'Factura A N°: 0001-00000969',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(793,3687,2,40720,40959,13,1534,1,0,'2021-05-10',257797.16,'Factura A N°: 0001-00000970',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(794,3687,2,40720,40755,13,1534,2,0,'2021-05-10',29479.06,'Nota de crédito A N°: 0001-00000040',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(795,3687,2,40720,40755,13,1534,2,0,'2021-05-10',257797.16,'Nota de crédito A N°: 0001-00000041',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(796,3687,2,40720,40806,13,1534,1,0,'2021-05-12',29000.00,'Factura A N°: 0001-00000971',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(797,3687,2,40720,40757,13,1534,1,0,'2021-05-12',7738.13,'Factura A N°: 0001-00000972',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(798,3687,2,40720,40761,13,1534,1,0,'2021-05-12',286000.00,'Factura A N°: 0001-00000973',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(799,3687,2,40720,40750,13,1534,1,0,'2021-05-13',41118.83,'Factura A N°: 0001-00000974',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(800,3687,2,40720,40750,13,1534,2,0,'2021-05-13',41118.83,'Nota de crédito A N°: 0001-00000042',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(801,3687,2,40720,40960,13,1534,1,0,'2021-05-17',427304.22,'Factura A N°: 0001-00000975',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(802,3687,2,40720,40796,13,1534,1,0,'2021-05-17',153343.00,'Factura A N°: 0001-00000976',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(803,3687,2,40720,40755,13,1534,1,0,'2021-05-19',3124.69,'Factura A N°: 0001-00000977',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(804,3687,2,40720,40749,13,1534,1,0,'2021-05-19',20073.17,'Factura A N°: 0001-00000978',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(805,3687,2,40720,40757,13,1534,1,0,'2021-05-20',17113.18,'Factura A N°: 0001-00000979',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL);
INSERT INTO `cta_cte_cliente` VALUES (806,3687,2,40720,40764,13,1534,1,0,'2021-05-20',74865.66,'Factura A N°: 0001-00000980',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(807,3687,2,40720,40764,13,1534,1,0,'2021-05-20',58441.81,'Factura A N°: 0001-00000981',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(808,3687,2,40720,40754,13,1534,1,0,'2021-05-20',60076.28,'Factura A N°: 0001-00000982',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(809,3687,2,40720,40958,13,1534,1,0,'2021-05-26',470.48,'Nota de débito A N°: 0001-00000016',NULL,'2021-06-14 12:29:06','2021-06-14 12:29:06',NULL),(810,3687,3,40720,40722,57,1534,2,0,'2021-05-01',21175.00,'Factura A N°: 0004-00000081',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(811,3687,3,40720,40779,57,1534,2,0,'2021-05-03',2322525.84,'Factura A N°: 0002-00007475',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(812,3687,3,40720,40727,57,1534,2,0,'2021-05-04',56375.72,'Factura A N°: 0010-00033910',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(813,3687,3,40720,40729,57,1534,2,0,'2021-05-11',753469.17,'Factura A N°: 0002-00009243',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(814,3687,3,40720,40732,57,1534,2,0,'2021-05-18',10400.98,'Factura A N°: 2468-00172102',NULL,'2021-06-14 12:29:19','2021-06-14 13:36:42','2021-06-14 13:36:42'),(815,3687,3,40720,40778,57,1534,2,0,'2021-05-20',90000.00,'Factura C N°: 0002-00000064',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(816,3687,3,40720,40778,57,1534,2,0,'2021-05-20',100000.00,'Factura C N°: 0002-00000067',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(817,3687,3,40720,40778,57,1534,2,0,'2021-05-20',100000.00,'Factura C N°: 0002-00000066',NULL,'2021-06-14 12:29:19','2021-06-14 12:38:01','2021-06-14 12:38:01'),(818,3687,3,40720,40778,57,1534,2,0,'2021-05-20',100000.00,'Factura C N°: 0002-00000065',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(819,3687,3,40720,40730,57,1534,2,0,'2021-05-20',1972.51,'Factura A N°: 0004-00064511',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(820,3687,3,40720,40772,57,1534,2,0,'2021-05-21',6000.00,'Factura C N°: 0002-00001676',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(821,3687,3,40720,40830,57,1534,2,0,'2021-05-21',15609.00,'Factura A N°: 0002-00000470',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(822,3687,3,40720,40774,57,1534,2,0,'2021-05-21',1611.00,'Factura C N°: 0002-00000493',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(823,3687,3,40720,40724,57,1534,2,0,'2021-05-27',974052.30,'Factura A N°: 0003-00003419',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(824,3687,3,40720,40736,57,1534,2,0,'2021-05-27',34828.00,'Factura A N°: 0075-00123513',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(825,3687,3,40720,40727,57,1534,2,0,'2021-05-29',89235.08,'Factura A N°: 0010-00034166',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(826,3687,3,40720,40961,57,1534,2,0,'2021-05-29',9780.01,'Factura A N°: 0008-00046598',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(827,3687,3,40720,40724,57,1534,2,0,'2021-05-31',650000.00,'Factura A N°: 0003-00003435',NULL,'2021-06-14 12:29:19','2021-06-14 12:29:19',NULL),(828,3687,2,40812,40870,13,3046,1,0,'2021-05-03',16008.30,'Factura A N°: 0004-00003524',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(829,3687,2,40812,40962,13,3046,1,0,'2021-05-03',63198.30,'Factura A N°: 0004-00003525',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(830,3687,2,40812,40857,13,3046,1,0,'2021-05-03',229900.00,'Factura A N°: 0004-00003526',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(831,3687,2,40812,40879,13,3046,1,0,'2021-05-03',15730.00,'Factura A N°: 0004-00003527',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(832,3687,2,40812,40757,13,3046,1,0,'2021-05-03',37570.50,'Factura A N°: 0004-00003528',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL);
INSERT INTO `cta_cte_cliente` VALUES (833,3687,2,40812,40724,13,3046,1,0,'2021-05-04',174248.48,'Factura A N°: 0004-00003529',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(834,3687,2,40812,40874,13,3046,1,0,'2021-05-04',20636.55,'Factura A N°: 0004-00003530',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(835,3687,2,40812,40859,13,3046,1,0,'2021-05-04',45352.01,'Factura A N°: 0004-00003531',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(836,3687,2,40812,40882,13,3046,1,0,'2021-05-04',57293.50,'Factura A N°: 0004-00003532',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(837,3687,2,40812,40727,13,3046,1,0,'2021-05-05',95348.00,'Factura A N°: 0004-00003533',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(838,3687,2,40812,40727,13,3046,1,0,'2021-05-05',321036.72,'Factura A N°: 0004-00003534',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(839,3687,2,40812,40880,13,3046,1,0,'2021-05-05',55381.70,'Factura A N°: 0004-00003535',NULL,'2021-06-14 12:30:27','2021-06-14 12:30:27',NULL),(840,3687,2,40812,40963,13,3046,1,0,'2021-05-06',30413.35,'Factura A N°: 0004-00003536',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(841,3687,2,40812,40841,13,3046,1,0,'2021-05-06',340292.17,'Factura A N°: 0004-00003537',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(842,3687,2,40812,40766,13,3046,1,0,'2021-05-06',42247.15,'Factura A N°: 0004-00003538',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(843,3687,2,40812,40964,13,3046,1,0,'2021-05-10',118592.10,'Factura A N°: 0004-00003539',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(844,3687,2,40812,40787,13,3046,1,0,'2021-05-10',34642.30,'Factura A N°: 0004-00003540',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(845,3687,2,40812,40965,13,3046,1,0,'2021-05-12',47716.35,'Factura A N°: 0004-00003541',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(846,3687,2,40812,40843,13,3046,1,0,'2021-05-12',159199.70,'Factura A N°: 0004-00003542',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(847,3687,2,40812,40866,13,3046,1,0,'2021-05-12',11519.20,'Factura A N°: 0004-00003543',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(848,3687,2,40812,40883,13,3046,1,0,'2021-05-12',17557.10,'Factura A N°: 0004-00003544',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(849,3687,2,40812,40869,13,3046,1,0,'2021-05-12',72321.70,'Factura A N°: 0004-00003545',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(850,3687,2,40812,40884,13,3046,1,0,'2021-05-12',48841.65,'Factura A N°: 0004-00003546',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(851,3687,2,40812,40844,13,3046,1,0,'2021-05-12',621262.40,'Factura A N°: 0004-00003547',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(852,3687,2,40812,40790,13,3046,1,0,'2021-05-12',28798.00,'Factura A N°: 0004-00003548',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(853,3687,2,40812,40845,13,3046,1,0,'2021-05-13',69502.40,'Factura A N°: 0004-00003549',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(854,3687,2,40812,40966,13,3046,1,0,'2021-05-13',32379.60,'Factura A N°: 0004-00003550',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(855,3687,2,40812,40967,13,3046,1,0,'2021-05-13',160506.50,'Factura A N°: 0004-00003551',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(856,3687,2,40812,40841,13,3046,1,0,'2021-05-13',161864.12,'Factura A N°: 0004-00003552',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(857,3687,2,40812,40764,13,3046,1,0,'2021-05-19',56144.00,'Factura A N°: 0004-00003553',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(858,3687,2,40812,40855,13,3046,1,0,'2021-05-19',28386.60,'Factura A N°: 0004-00003554',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(859,3687,2,40812,40875,13,3046,1,0,'2021-05-19',21592.45,'Factura A N°: 0004-00003555',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL);
INSERT INTO `cta_cte_cliente` VALUES (860,3687,2,40812,40758,13,3046,1,0,'2021-05-19',17756.75,'Factura A N°: 0004-00003556',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(861,3687,2,40812,40844,13,3046,1,0,'2021-05-19',105814.50,'Factura A N°: 0004-00003557',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(862,3687,2,40812,40882,13,3046,1,0,'2021-05-19',26378.00,'Factura A N°: 0004-00003558',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(863,3687,2,40812,40968,13,3046,1,0,'2021-05-19',11531.30,'Factura A N°: 0004-00003559',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(864,3687,2,40812,40861,13,3046,1,0,'2021-05-19',41563.50,'Factura A N°: 0004-00003560',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(865,3687,2,40812,40859,13,3046,1,0,'2021-05-20',66749.65,'Factura A N°: 0004-00003561',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(866,3687,2,40812,40841,13,3046,1,0,'2021-05-20',257840.35,'Factura A N°: 0004-00003562',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(867,3687,2,40812,40856,13,3046,1,0,'2021-05-21',53772.40,'Factura A N°: 0004-00003563',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(868,3687,2,40812,40872,13,3046,1,0,'2021-05-21',43197.00,'Factura A N°: 0004-00003564',NULL,'2021-06-14 12:30:28','2021-06-14 12:30:28',NULL),(869,3687,3,40812,40813,57,3046,2,0,'2021-05-01',4600.00,'Factura B N°: 0003-00000696',NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(870,3687,3,40812,40722,57,3046,2,0,'2021-05-01',21175.00,'Factura A N°: 0004-00000079',NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(871,3687,3,40812,40814,57,3046,2,0,'2021-05-03',5227.20,'Factura A N°: 0002-00004144',NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(872,3687,3,40812,40819,57,3046,2,0,'2021-05-03',12000.00,'Factura C N°: 0001-00000080',NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(873,3687,3,40812,40821,57,3046,2,0,'2021-05-03',6000.00,'Factura C N°: 0001-00000150',NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(874,3687,3,40812,40820,57,3046,2,0,'2021-05-03',12000.00,'Factura C N°: 0001-00000074',NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(875,3687,3,40812,40816,57,3046,2,0,'2021-05-05',4836.00,'Factura A N°: 0063-01499095',NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(876,3687,3,40812,40821,57,3046,2,0,'2021-05-05',6400.00,'Factura C N°: 0001-00000151',NULL,'2021-06-14 12:30:40','2021-06-19 13:07:59','2021-06-19 13:07:59'),(877,3687,3,40812,40821,57,3046,2,0,'2021-05-08',6400.00,'Factura C N°: 0001-00000154',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(878,3687,3,40812,40824,57,3046,2,0,'2021-05-10',2783.00,'Factura A N°: 0004-00008217',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(879,3687,3,40812,40961,57,3046,2,0,'2021-05-10',9500.00,'Factura A N°: 0008-00046012',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(880,3687,3,40812,40817,57,3046,2,0,'2021-05-10',55000.00,'Factura C N°: 0002-00000037',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(881,3687,3,40812,40969,57,3046,2,0,'2021-05-10',219934.44,'Factura A N°: 0002-00013918',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(882,3687,3,40812,40721,57,3046,2,0,'2021-05-11',47400.00,'Factura C N°: 0004-00000678',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(883,3687,3,40812,40838,57,3046,2,0,'2021-05-12',518647.74,'Factura A N°: 0003-00000094',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(884,3687,3,40812,40821,57,3046,2,0,'2021-05-14',7200.00,'Factura C N°: 0001-00000155',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(885,3687,3,40812,40821,57,3046,2,0,'2021-05-14',6400.00,'Factura C N°: 0001-00000158',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59');
INSERT INTO `cta_cte_cliente` VALUES (886,3687,3,40812,40970,57,3046,2,0,'2021-05-18',492.57,'Factura A N°: 0003-00122700',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(887,3687,3,40812,40732,57,3046,2,0,'2021-05-18',10079.45,'Factura A N°: 2468-00171565',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(888,3687,3,40812,40821,57,3046,2,0,'2021-05-21',8800.00,'Factura C N°: 0001-00000159',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(889,3687,3,40812,40736,57,3046,2,0,'2021-05-27',45595.01,'Factura A N°: 0075-00122117',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(890,3687,3,40812,40971,57,3046,2,0,'2021-05-27',2178.00,'Factura A N°: 0001-00000617',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(891,3687,3,40812,40825,57,3046,2,0,'2021-05-28',328095.86,'Factura A N°: 0002-00000486',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(892,3687,3,40812,40826,57,3046,2,0,'2021-05-29',220425.70,'Factura A N°: 0002-00000217',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(893,3687,3,40812,40827,57,3046,2,0,'2021-05-31',150000.00,'Factura C N°: 0003-00000050',NULL,'2021-06-14 12:30:41','2021-06-19 13:07:59','2021-06-19 13:07:59'),(894,3687,3,40720,40778,57,1534,2,0,'2021-05-20',100000.00,'Factura C N°: 0002-00000066',NULL,'2021-06-14 12:38:01','2021-06-14 12:38:01',NULL),(895,3687,3,40720,40745,57,1534,2,0,'2021-05-03',978.80,'Factura A N°: 0001-00318013',NULL,'2021-06-14 13:12:49','2021-06-14 13:12:49',NULL),(896,3687,3,40720,40738,57,1534,2,0,'2021-05-04',1087.17,'Factura A N°: 0019-00743328',NULL,'2021-06-14 13:16:11','2021-06-14 13:16:11',NULL),(897,3687,3,40720,40731,57,1534,2,0,'2021-05-06',246286.56,'Factura A N°: 0002-00054365',NULL,'2021-06-14 13:19:01','2021-06-14 13:19:01',NULL),(898,3687,3,40720,40738,57,1534,2,0,'2021-05-07',267.32,'Factura A N°: 0019-00743329',NULL,'2021-06-14 13:20:16','2021-06-14 13:20:16',NULL),(899,3687,3,40720,40746,57,1534,2,0,'2021-05-11',1623.11,'Factura A N°: 7204-16113449',NULL,'2021-06-14 13:22:07','2021-06-14 13:22:07',NULL),(900,3687,3,40720,40741,57,1534,2,0,'2021-05-13',3400.01,'Factura A N°: 0003-00043893',NULL,'2021-06-14 13:24:46','2021-06-14 13:24:46',NULL),(901,3687,3,40720,40744,57,1534,2,0,'2021-05-31',51186.21,'Factura A N°: 0029-20210531',NULL,'2021-06-14 13:27:54','2021-06-14 13:27:54',NULL),(902,3687,3,40720,40732,57,1534,2,0,'2021-05-18',10400.98,'Factura A N°: 2468-00172102',NULL,'2021-06-14 13:36:42','2021-06-14 13:42:23','2021-06-14 13:42:23'),(903,3687,3,40720,40732,57,1534,2,0,'2021-05-18',10400.98,'Factura A N°: 2468-00172102',NULL,'2021-06-14 13:42:23','2021-06-14 13:42:23',NULL),(904,3687,3,40812,40813,57,3046,2,0,'2021-05-01',4600.00,'Factura B N°: 0003-00000696',NULL,'2021-06-20 13:38:15','2021-06-20 15:11:40','2021-06-20 15:11:40'),(905,3687,3,40812,40722,57,3046,2,0,'2021-05-01',21175.00,'Factura A N°: 0004-00000079',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(906,3687,3,40812,40814,57,3046,2,0,'2021-05-03',5227.20,'Factura A N°: 0002-00004144',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(907,3687,3,40812,40819,57,3046,2,0,'2021-05-03',12000.00,'Factura C N°: 0001-00000080',NULL,'2021-06-20 13:38:15','2021-06-20 13:42:25','2021-06-20 13:42:25'),(908,3687,3,40812,40821,57,3046,2,0,'2021-05-03',6000.00,'Factura C N°: 0001-00000150',NULL,'2021-06-20 13:38:15','2021-06-20 13:43:06','2021-06-20 13:43:06'),(909,3687,3,40812,40820,57,3046,2,0,'2021-05-03',12000.00,'Factura C N°: 0001-00000074',NULL,'2021-06-20 13:38:15','2021-06-20 13:43:35','2021-06-20 13:43:35'),(910,3687,3,40812,40816,57,3046,2,0,'2021-05-05',4836.00,'Factura A N°: 0063-01499095',NULL,'2021-06-20 13:38:15','2021-06-20 13:44:37','2021-06-20 13:44:37'),(911,3687,3,40812,40821,57,3046,2,0,'2021-05-05',6400.00,'Factura C N°: 0001-00000151',NULL,'2021-06-20 13:38:15','2021-06-20 13:45:25','2021-06-20 13:45:25');
INSERT INTO `cta_cte_cliente` VALUES (912,3687,3,40812,40821,57,3046,2,0,'2021-05-08',6400.00,'Factura C N°: 0001-00000154',NULL,'2021-06-20 13:38:15','2021-06-20 13:45:33','2021-06-20 13:45:33'),(913,3687,3,40812,40824,57,3046,2,0,'2021-05-10',2783.00,'Factura A N°: 0004-00008217',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(914,3687,3,40812,40961,57,3046,2,0,'2021-05-10',9500.00,'Factura A N°: 0008-00046012',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(915,3687,3,40812,40817,57,3046,2,0,'2021-05-10',55000.00,'Factura C N°: 0002-00000037',NULL,'2021-06-20 13:38:15','2021-06-20 13:46:10','2021-06-20 13:46:10'),(916,3687,3,40812,40969,57,3046,2,0,'2021-05-10',219934.44,'Factura A N°: 0002-00013918',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(917,3687,3,40812,40721,57,3046,2,0,'2021-05-11',47400.00,'Factura C N°: 0004-00000678',NULL,'2021-06-20 13:38:15','2021-06-20 13:46:35','2021-06-20 13:46:35'),(918,3687,3,40812,40838,57,3046,2,0,'2021-05-12',518647.74,'Factura A N°: 0003-00000094',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(919,3687,3,40812,40821,57,3046,2,0,'2021-05-14',7200.00,'Factura C N°: 0001-00000155',NULL,'2021-06-20 13:38:15','2021-06-20 13:46:52','2021-06-20 13:46:52'),(920,3687,3,40812,40821,57,3046,2,0,'2021-05-14',6400.00,'Factura C N°: 0001-00000158',NULL,'2021-06-20 13:38:15','2021-06-20 13:47:08','2021-06-20 13:47:08'),(921,3687,3,40812,40970,57,3046,2,0,'2021-05-18',492.57,'Factura A N°: 0003-00122700',NULL,'2021-06-20 13:38:15','2021-06-22 17:59:01','2021-06-22 17:59:01'),(922,3687,3,40812,40732,57,3046,2,0,'2021-05-18',10079.45,'Factura A N°: 2468-00171565',NULL,'2021-06-20 13:38:15','2021-06-20 13:48:42','2021-06-20 13:48:42'),(923,3687,3,40812,40821,57,3046,2,0,'2021-05-21',8800.00,'Factura C N°: 0001-00000159',NULL,'2021-06-20 13:38:15','2021-06-20 13:48:59','2021-06-20 13:48:59'),(924,3687,3,40812,40736,57,3046,2,0,'2021-05-27',45595.01,'Factura A N°: 0075-00122117',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(925,3687,3,40812,40971,57,3046,2,0,'2021-05-27',2178.00,'Factura A N°: 0001-00000617',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(926,3687,3,40812,40825,57,3046,2,0,'2021-05-28',328095.86,'Factura A N°: 0002-00000486',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(927,3687,3,40812,40826,57,3046,2,0,'2021-05-29',220425.70,'Factura A N°: 0002-00000217',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(928,3687,3,40812,40827,57,3046,2,0,'2021-05-31',150000.00,'Factura C N°: 0003-00000050',NULL,'2021-06-20 13:38:15','2021-06-20 13:49:28','2021-06-20 13:49:28'),(929,3687,3,40812,40950,57,3046,2,0,'1969-12-31',1810.00,'Factura C N°: 0001-00028960',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(930,3687,3,40812,40954,57,3046,2,0,'1969-12-31',790.00,'Factura A N°: 2450-00095437',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(931,3687,3,40812,40951,57,3046,2,0,'1969-12-31',4300.00,'Factura A N°: 0034-00000897',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(932,3687,3,40812,40746,57,3046,2,0,'1969-12-31',1013.42,'Factura A N°: 7204-16126702',NULL,'2021-06-20 13:38:15','2021-06-20 13:38:15',NULL),(933,3687,3,40812,40746,57,3046,2,0,'1969-12-31',1312.20,'Factura A N°: 72041-06115911',NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(934,3687,3,40812,40972,57,3046,2,0,'1969-12-31',994.50,'Factura B N°: 0046-88924692',NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(935,3687,3,40812,40973,57,3046,2,0,'1969-12-31',711.22,'Factura B N°: 0108-89791460',NULL,'2021-06-20 13:38:16','2021-06-22 16:53:43','2021-06-22 16:53:43'),(936,3687,3,40812,40973,57,3046,2,0,'1969-12-31',1307.61,'Factura B N°: 0108-89843581',NULL,'2021-06-20 13:38:16','2021-06-22 16:53:24','2021-06-22 16:53:24'),(937,3687,3,40812,40955,57,3046,2,0,'1969-12-31',835.89,'Factura A N°: 0023-24790402',NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL);
INSERT INTO `cta_cte_cliente` VALUES (938,3687,3,40812,40955,57,3046,2,0,'1969-12-31',1121.90,'Factura A N°: 0014-10465484',NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(939,3687,3,40812,40956,57,3046,2,0,'1969-12-31',3039.67,'Factura A N°: 0014-20210531',NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(940,3687,3,40812,40744,57,3046,2,0,'1969-12-31',32500.98,'Factura A N°: 0029-20210531',NULL,'2021-06-20 13:38:16','2021-06-20 13:38:16',NULL),(941,3687,3,40812,40819,57,3046,2,0,'2021-05-03',12000.00,'Factura C N°: 0001-00000080',NULL,'2021-06-20 13:42:25','2021-06-20 13:42:25',NULL),(942,3687,3,40812,40821,57,3046,2,0,'2021-05-03',6000.00,'Factura C N°: 0001-00000150',NULL,'2021-06-20 13:43:06','2021-06-20 13:43:06',NULL),(943,3687,3,40812,40820,57,3046,2,0,'2021-05-03',12000.00,'Factura C N°: 0001-00000074',NULL,'2021-06-20 13:43:35','2021-06-20 13:43:35',NULL),(944,3687,3,40812,40816,57,3046,2,0,'2021-05-05',4836.00,'Factura A N°: 0063-01499095',NULL,'2021-06-20 13:44:37','2021-06-20 13:44:37',NULL),(945,3687,3,40812,40821,57,3046,2,0,'2021-05-05',6400.00,'Factura C N°: 0001-00000151',NULL,'2021-06-20 13:45:25','2021-06-20 13:45:41','2021-06-20 13:45:41'),(946,3687,3,40812,40821,57,3046,2,0,'2021-05-08',6400.00,'Factura C N°: 0001-00000154',NULL,'2021-06-20 13:45:33','2021-06-20 13:45:33',NULL),(947,3687,3,40812,40821,57,3046,2,0,'2021-05-05',6400.00,'Factura C N°: 0001-00000151',NULL,'2021-06-20 13:45:41','2021-06-20 13:45:41',NULL),(948,3687,3,40812,40817,57,3046,2,0,'2021-05-10',55000.00,'Factura C N°: 0002-00000037',NULL,'2021-06-20 13:46:10','2021-06-20 13:46:10',NULL),(949,3687,3,40812,40721,57,3046,2,0,'2021-05-11',47400.00,'Factura C N°: 0004-00000678',NULL,'2021-06-20 13:46:35','2021-06-20 13:46:35',NULL),(950,3687,3,40812,40821,57,3046,2,0,'2021-05-14',7200.00,'Factura C N°: 0001-00000155',NULL,'2021-06-20 13:46:52','2021-06-20 13:46:52',NULL),(951,3687,3,40812,40821,57,3046,2,0,'2021-05-14',6400.00,'Factura C N°: 0001-00000158',NULL,'2021-06-20 13:47:08','2021-06-20 13:47:08',NULL),(952,3687,3,40812,40732,57,3046,2,0,'2021-05-18',10079.45,'Factura A N°: 2468-00171565',NULL,'2021-06-20 13:48:42','2021-06-20 13:48:42',NULL),(953,3687,3,40812,40821,57,3046,2,0,'2021-05-21',8800.00,'Factura C N°: 0001-00000159',NULL,'2021-06-20 13:48:59','2021-06-20 13:48:59',NULL),(954,3687,3,40812,40827,57,3046,2,0,'2021-05-31',150000.00,'Factura C N°: 0003-00000050',NULL,'2021-06-20 13:49:28','2021-06-20 13:49:28',NULL),(955,3687,3,40812,40813,57,3046,2,0,'2021-05-01',4600.00,'Factura B N°: 0003-00000696',NULL,'2021-06-20 15:11:40','2021-06-20 15:11:40',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=956 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,NULL,1,1,NULL,NULL,NULL,NULL),(2,NULL,2,2,NULL,NULL,NULL,NULL),(3,NULL,3,3,NULL,NULL,NULL,NULL),(4,NULL,4,4,NULL,NULL,NULL,NULL),(5,NULL,5,5,NULL,NULL,NULL,NULL),(6,NULL,6,6,NULL,NULL,NULL,NULL),(7,NULL,7,7,NULL,NULL,NULL,NULL),(8,NULL,8,8,NULL,NULL,NULL,NULL),(9,NULL,9,9,NULL,NULL,NULL,NULL),(10,NULL,10,10,NULL,NULL,NULL,NULL),(11,NULL,11,11,NULL,NULL,NULL,NULL),(12,NULL,12,12,NULL,NULL,NULL,NULL),(13,NULL,13,13,NULL,NULL,NULL,NULL),(14,NULL,14,14,NULL,NULL,NULL,NULL),(15,NULL,15,15,NULL,NULL,NULL,NULL),(16,NULL,16,16,NULL,NULL,NULL,NULL),(17,NULL,17,17,NULL,NULL,NULL,NULL),(18,NULL,18,18,NULL,NULL,NULL,NULL),(19,NULL,19,19,NULL,NULL,NULL,NULL),(20,NULL,20,20,NULL,NULL,NULL,NULL),(21,NULL,21,21,NULL,NULL,NULL,NULL),(22,NULL,22,22,NULL,NULL,NULL,NULL),(23,NULL,23,23,NULL,NULL,NULL,NULL),(24,NULL,24,24,NULL,NULL,NULL,NULL),(25,NULL,25,25,NULL,NULL,NULL,NULL),(26,NULL,26,26,NULL,NULL,NULL,NULL),(27,NULL,27,27,NULL,NULL,NULL,NULL),(28,NULL,28,28,NULL,NULL,NULL,NULL),(29,NULL,29,29,NULL,NULL,NULL,NULL),(30,NULL,30,30,NULL,NULL,NULL,NULL),(31,NULL,31,31,NULL,NULL,NULL,NULL),(32,NULL,32,32,NULL,NULL,NULL,NULL),(33,NULL,33,33,NULL,NULL,NULL,NULL),(34,NULL,34,34,NULL,NULL,NULL,NULL),(35,NULL,35,1,NULL,NULL,NULL,NULL),(36,NULL,36,3,NULL,NULL,NULL,NULL),(37,NULL,37,5,NULL,NULL,NULL,NULL),(38,NULL,38,6,NULL,NULL,NULL,NULL),(39,NULL,39,15,NULL,NULL,NULL,NULL),(40,NULL,40,35,NULL,NULL,NULL,NULL),(41,NULL,41,3,NULL,NULL,NULL,NULL),(42,NULL,42,36,NULL,NULL,NULL,NULL),(43,NULL,43,37,NULL,NULL,NULL,NULL),(44,NULL,44,38,NULL,NULL,NULL,NULL),(45,NULL,45,39,NULL,NULL,NULL,NULL),(46,NULL,46,40,NULL,NULL,NULL,NULL),(47,NULL,47,41,NULL,NULL,NULL,NULL),(48,NULL,48,42,NULL,NULL,NULL,NULL),(49,NULL,49,43,NULL,NULL,NULL,NULL),(50,NULL,50,44,NULL,NULL,NULL,NULL),(51,NULL,51,15,NULL,NULL,NULL,NULL),(52,NULL,52,15,NULL,NULL,NULL,NULL),(53,NULL,53,35,NULL,NULL,NULL,NULL),(54,NULL,54,35,NULL,NULL,NULL,NULL),(55,NULL,55,5,NULL,NULL,NULL,NULL),(56,NULL,56,35,NULL,NULL,NULL,NULL),(57,NULL,57,45,NULL,NULL,NULL,NULL),(58,NULL,58,46,NULL,NULL,NULL,NULL),(59,NULL,59,47,NULL,NULL,NULL,NULL),(60,NULL,60,48,NULL,NULL,NULL,NULL),(61,NULL,61,49,NULL,NULL,NULL,NULL),(62,NULL,62,50,NULL,NULL,NULL,NULL),(63,NULL,63,51,NULL,NULL,NULL,NULL),(64,NULL,64,52,NULL,NULL,NULL,NULL),(65,NULL,65,53,NULL,NULL,NULL,NULL),(66,NULL,66,54,NULL,NULL,NULL,NULL),(67,NULL,67,55,NULL,NULL,NULL,NULL),(68,NULL,68,56,NULL,NULL,NULL,NULL),(69,NULL,69,57,NULL,NULL,NULL,NULL),(70,NULL,70,58,NULL,NULL,NULL,NULL),(71,NULL,71,59,NULL,NULL,NULL,NULL),(72,NULL,72,60,NULL,NULL,NULL,NULL),(73,NULL,73,61,NULL,NULL,NULL,NULL),(74,NULL,74,62,NULL,NULL,NULL,NULL),(75,NULL,75,63,NULL,NULL,NULL,NULL),(76,NULL,76,64,NULL,NULL,NULL,NULL),(77,NULL,77,65,NULL,NULL,NULL,NULL),(78,NULL,78,66,NULL,NULL,NULL,NULL),(79,NULL,79,67,NULL,NULL,NULL,NULL),(80,NULL,80,68,NULL,NULL,NULL,NULL),(81,NULL,81,69,NULL,NULL,NULL,NULL),(82,NULL,82,70,NULL,NULL,NULL,NULL),(83,NULL,83,71,NULL,NULL,NULL,NULL),(84,NULL,84,72,NULL,NULL,NULL,NULL),(85,NULL,85,73,NULL,NULL,NULL,NULL),(86,NULL,86,74,NULL,NULL,NULL,NULL),(87,NULL,87,75,NULL,NULL,NULL,NULL),(88,NULL,88,76,NULL,NULL,NULL,NULL),(89,NULL,89,77,NULL,NULL,NULL,NULL),(90,NULL,90,78,NULL,NULL,NULL,NULL),(91,NULL,91,79,NULL,NULL,NULL,NULL),(92,NULL,92,80,NULL,NULL,NULL,NULL),(93,NULL,93,81,NULL,NULL,NULL,NULL),(94,NULL,94,82,NULL,NULL,NULL,NULL),(95,NULL,95,83,NULL,NULL,NULL,NULL),(96,NULL,96,84,NULL,NULL,NULL,NULL),(97,NULL,97,85,NULL,NULL,NULL,NULL),(98,NULL,98,86,NULL,NULL,NULL,NULL),(99,NULL,99,87,NULL,NULL,NULL,NULL),(100,NULL,100,88,NULL,NULL,NULL,NULL),(101,NULL,101,89,NULL,NULL,NULL,NULL),(102,NULL,102,90,NULL,NULL,NULL,NULL),(103,NULL,103,91,NULL,NULL,NULL,NULL),(104,NULL,104,92,NULL,NULL,NULL,NULL),(105,NULL,105,93,NULL,NULL,NULL,NULL),(106,NULL,106,94,NULL,NULL,NULL,NULL),(107,NULL,107,95,NULL,NULL,NULL,NULL),(108,NULL,108,96,NULL,NULL,NULL,NULL),(109,NULL,109,97,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (110,NULL,110,98,NULL,NULL,NULL,NULL),(111,NULL,111,99,NULL,NULL,NULL,NULL),(112,NULL,112,100,NULL,NULL,NULL,NULL),(113,NULL,113,101,NULL,NULL,NULL,NULL),(114,NULL,114,102,NULL,NULL,NULL,NULL),(115,NULL,115,103,NULL,NULL,NULL,NULL),(116,NULL,116,104,NULL,NULL,NULL,NULL),(117,NULL,117,105,NULL,NULL,NULL,NULL),(118,NULL,118,106,NULL,NULL,NULL,NULL),(119,NULL,119,107,NULL,NULL,NULL,NULL),(120,NULL,120,108,NULL,NULL,NULL,NULL),(121,NULL,121,109,NULL,NULL,NULL,NULL),(122,NULL,122,110,NULL,NULL,NULL,NULL),(123,NULL,123,111,NULL,NULL,NULL,NULL),(124,NULL,124,112,NULL,NULL,NULL,NULL),(125,NULL,125,113,NULL,NULL,NULL,NULL),(126,NULL,126,114,NULL,NULL,NULL,NULL),(127,NULL,127,115,NULL,NULL,NULL,NULL),(128,NULL,128,116,NULL,NULL,NULL,NULL),(129,NULL,129,117,NULL,NULL,NULL,NULL),(130,NULL,130,118,NULL,NULL,NULL,NULL),(131,NULL,131,119,NULL,NULL,NULL,NULL),(132,NULL,132,120,NULL,NULL,NULL,NULL),(133,NULL,133,121,NULL,NULL,NULL,NULL),(134,NULL,134,122,NULL,NULL,NULL,NULL),(135,NULL,135,123,NULL,NULL,NULL,NULL),(136,NULL,136,124,NULL,NULL,NULL,NULL),(137,NULL,137,125,NULL,NULL,NULL,NULL),(138,NULL,138,126,NULL,NULL,NULL,NULL),(139,NULL,139,127,NULL,NULL,NULL,NULL),(140,NULL,140,128,NULL,NULL,NULL,NULL),(141,NULL,141,129,NULL,NULL,NULL,NULL),(142,NULL,142,130,NULL,NULL,NULL,NULL),(143,NULL,143,131,NULL,NULL,NULL,NULL),(144,NULL,144,132,NULL,NULL,NULL,NULL),(145,NULL,145,133,NULL,NULL,NULL,NULL),(146,NULL,146,134,NULL,NULL,NULL,NULL),(147,NULL,147,135,NULL,NULL,NULL,NULL),(148,NULL,148,136,NULL,NULL,NULL,NULL),(149,NULL,149,137,NULL,NULL,NULL,NULL),(150,NULL,150,138,NULL,NULL,NULL,NULL),(186,NULL,186,174,NULL,NULL,NULL,NULL),(187,NULL,187,175,NULL,NULL,NULL,NULL),(188,NULL,188,176,NULL,NULL,NULL,NULL),(189,NULL,189,177,NULL,NULL,NULL,NULL),(190,NULL,190,178,NULL,NULL,NULL,NULL),(191,NULL,191,179,NULL,NULL,NULL,NULL),(192,NULL,192,180,NULL,NULL,NULL,NULL),(193,NULL,193,181,NULL,NULL,NULL,NULL),(194,NULL,194,182,NULL,NULL,NULL,NULL),(195,NULL,195,183,NULL,NULL,NULL,NULL),(196,NULL,196,184,NULL,NULL,NULL,NULL),(197,NULL,197,185,NULL,NULL,NULL,NULL),(198,NULL,198,186,NULL,NULL,NULL,NULL),(199,NULL,199,187,NULL,NULL,NULL,NULL),(200,NULL,200,188,NULL,NULL,NULL,NULL),(201,NULL,201,189,NULL,NULL,NULL,NULL),(202,NULL,202,190,NULL,NULL,NULL,NULL),(203,NULL,203,191,NULL,NULL,NULL,NULL),(204,NULL,204,192,NULL,NULL,NULL,NULL),(205,NULL,205,193,NULL,NULL,NULL,NULL),(206,NULL,206,194,NULL,NULL,NULL,NULL),(207,NULL,207,195,NULL,NULL,NULL,NULL),(208,NULL,208,196,NULL,NULL,NULL,NULL),(209,NULL,209,197,NULL,NULL,NULL,NULL),(210,NULL,210,198,NULL,NULL,NULL,NULL),(211,NULL,211,199,NULL,NULL,NULL,NULL),(212,NULL,212,200,NULL,NULL,NULL,NULL),(213,NULL,213,201,NULL,NULL,NULL,NULL),(214,NULL,214,202,NULL,NULL,NULL,NULL),(215,NULL,215,203,NULL,NULL,NULL,NULL),(216,NULL,216,204,NULL,NULL,NULL,NULL),(217,NULL,217,205,NULL,NULL,NULL,NULL),(218,NULL,218,206,NULL,NULL,NULL,NULL),(219,NULL,219,207,NULL,NULL,NULL,NULL),(220,NULL,220,208,NULL,NULL,NULL,NULL),(221,NULL,221,209,NULL,NULL,NULL,NULL),(222,NULL,222,210,NULL,NULL,NULL,NULL),(223,NULL,223,211,NULL,NULL,NULL,NULL),(224,NULL,224,212,NULL,NULL,NULL,NULL),(225,NULL,225,213,NULL,NULL,NULL,NULL),(226,NULL,226,214,NULL,NULL,NULL,NULL),(227,NULL,227,215,NULL,NULL,NULL,NULL),(228,NULL,228,216,NULL,NULL,NULL,NULL),(229,NULL,229,217,NULL,NULL,NULL,NULL),(230,NULL,230,218,NULL,NULL,NULL,NULL),(231,NULL,231,219,NULL,NULL,NULL,NULL),(232,NULL,232,220,NULL,NULL,NULL,NULL),(233,NULL,233,221,NULL,NULL,NULL,NULL),(234,NULL,234,222,NULL,NULL,NULL,NULL),(235,NULL,235,223,NULL,NULL,NULL,NULL),(236,NULL,236,224,NULL,NULL,NULL,NULL),(237,NULL,237,225,NULL,NULL,NULL,NULL),(238,NULL,238,226,NULL,NULL,NULL,NULL),(239,NULL,239,227,NULL,NULL,NULL,NULL),(240,NULL,240,228,NULL,NULL,NULL,NULL),(241,NULL,241,229,NULL,NULL,NULL,NULL),(242,NULL,242,230,NULL,NULL,NULL,NULL),(243,NULL,243,231,NULL,NULL,NULL,NULL),(244,NULL,244,232,NULL,NULL,NULL,NULL),(245,NULL,245,233,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (246,NULL,246,234,NULL,NULL,NULL,NULL),(247,NULL,247,235,NULL,NULL,NULL,NULL),(248,NULL,248,236,NULL,NULL,NULL,NULL),(249,NULL,249,237,NULL,NULL,NULL,NULL),(250,NULL,250,238,NULL,NULL,NULL,NULL),(251,NULL,251,239,NULL,NULL,NULL,NULL),(252,NULL,252,240,NULL,NULL,NULL,NULL),(253,NULL,253,241,NULL,NULL,NULL,NULL),(254,NULL,254,242,NULL,NULL,NULL,NULL),(255,NULL,255,243,NULL,NULL,NULL,NULL),(256,NULL,256,244,NULL,NULL,NULL,NULL),(257,NULL,257,245,NULL,NULL,NULL,NULL),(258,NULL,258,246,NULL,NULL,NULL,NULL),(259,NULL,259,247,NULL,NULL,NULL,NULL),(260,NULL,260,248,NULL,NULL,NULL,NULL),(261,NULL,261,249,NULL,NULL,NULL,NULL),(262,NULL,262,250,NULL,NULL,NULL,NULL),(263,NULL,263,251,NULL,NULL,NULL,NULL),(264,NULL,264,252,NULL,NULL,NULL,NULL),(265,NULL,265,253,NULL,NULL,NULL,NULL),(266,NULL,266,254,NULL,NULL,NULL,NULL),(267,NULL,267,255,NULL,NULL,NULL,NULL),(268,NULL,268,256,NULL,NULL,NULL,NULL),(269,NULL,269,257,NULL,NULL,NULL,NULL),(270,NULL,270,258,NULL,NULL,NULL,NULL),(271,NULL,271,259,NULL,NULL,NULL,NULL),(272,NULL,272,260,NULL,NULL,NULL,NULL),(273,NULL,273,261,NULL,NULL,NULL,NULL),(274,NULL,274,262,NULL,NULL,NULL,NULL),(275,NULL,275,263,NULL,NULL,NULL,NULL),(276,NULL,276,264,NULL,NULL,NULL,NULL),(277,NULL,277,265,NULL,NULL,NULL,NULL),(278,NULL,278,266,NULL,NULL,NULL,NULL),(279,NULL,279,267,NULL,NULL,NULL,NULL),(280,NULL,280,268,NULL,NULL,NULL,NULL),(281,NULL,281,269,NULL,NULL,NULL,NULL),(282,NULL,282,270,NULL,NULL,NULL,NULL),(283,NULL,283,271,NULL,NULL,NULL,NULL),(284,NULL,284,272,NULL,NULL,NULL,NULL),(285,NULL,285,273,NULL,NULL,NULL,NULL),(286,NULL,286,274,NULL,NULL,NULL,NULL),(287,NULL,287,275,NULL,NULL,NULL,NULL),(288,NULL,288,276,NULL,NULL,NULL,NULL),(289,NULL,289,277,NULL,NULL,NULL,NULL),(290,NULL,290,278,NULL,NULL,NULL,NULL),(291,NULL,291,279,NULL,NULL,NULL,NULL),(292,NULL,292,280,NULL,NULL,NULL,NULL),(293,NULL,293,281,NULL,NULL,NULL,NULL),(294,NULL,294,282,NULL,NULL,NULL,NULL),(295,NULL,295,283,NULL,NULL,NULL,NULL),(296,NULL,296,284,NULL,NULL,NULL,NULL),(297,NULL,297,285,NULL,NULL,NULL,NULL),(298,NULL,298,286,NULL,NULL,NULL,NULL),(299,NULL,299,287,NULL,NULL,NULL,NULL),(300,NULL,300,288,NULL,NULL,NULL,NULL),(301,NULL,301,31,NULL,NULL,NULL,NULL),(302,NULL,302,289,NULL,NULL,NULL,NULL),(303,NULL,303,290,NULL,NULL,NULL,NULL),(304,NULL,304,291,NULL,NULL,NULL,NULL),(305,NULL,305,292,NULL,NULL,NULL,NULL),(306,NULL,306,293,NULL,NULL,NULL,NULL),(307,NULL,307,294,NULL,NULL,NULL,NULL),(308,NULL,308,295,NULL,NULL,NULL,NULL),(309,NULL,309,296,NULL,NULL,NULL,NULL),(310,NULL,310,297,NULL,NULL,NULL,NULL),(311,NULL,311,298,NULL,NULL,NULL,NULL),(312,NULL,312,299,NULL,NULL,NULL,NULL),(313,NULL,313,300,NULL,NULL,NULL,NULL),(314,NULL,314,301,NULL,NULL,NULL,NULL),(315,NULL,315,302,NULL,NULL,NULL,NULL),(316,NULL,316,303,NULL,NULL,NULL,NULL),(317,NULL,317,304,NULL,NULL,NULL,NULL),(318,NULL,318,305,NULL,NULL,NULL,NULL),(319,NULL,319,306,NULL,NULL,NULL,NULL),(320,NULL,320,307,NULL,NULL,NULL,NULL),(321,NULL,321,308,NULL,NULL,NULL,NULL),(322,NULL,322,309,NULL,NULL,NULL,NULL),(323,NULL,323,310,NULL,NULL,NULL,NULL),(324,NULL,324,311,NULL,NULL,NULL,NULL),(325,NULL,325,312,NULL,NULL,NULL,NULL),(326,NULL,326,313,NULL,NULL,NULL,NULL),(327,NULL,327,314,NULL,NULL,NULL,NULL),(328,NULL,328,315,NULL,NULL,NULL,NULL),(329,NULL,329,316,NULL,NULL,NULL,NULL),(330,NULL,330,317,NULL,NULL,NULL,NULL),(331,NULL,331,318,NULL,NULL,NULL,NULL),(332,NULL,332,319,NULL,NULL,NULL,NULL),(333,NULL,333,320,NULL,NULL,NULL,NULL),(334,NULL,334,321,NULL,NULL,NULL,NULL),(335,NULL,335,322,NULL,NULL,NULL,NULL),(336,NULL,336,323,NULL,NULL,NULL,NULL),(337,NULL,337,324,NULL,NULL,NULL,NULL),(338,NULL,338,325,NULL,NULL,NULL,NULL),(339,NULL,339,326,NULL,NULL,NULL,NULL),(340,NULL,340,327,NULL,NULL,NULL,NULL),(341,NULL,341,328,NULL,NULL,NULL,NULL),(342,NULL,342,329,NULL,NULL,NULL,NULL),(343,NULL,343,330,NULL,NULL,NULL,NULL),(344,NULL,344,331,NULL,NULL,NULL,NULL),(345,NULL,345,332,NULL,NULL,NULL,NULL),(346,NULL,346,333,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (347,NULL,347,334,NULL,NULL,NULL,NULL),(348,NULL,348,335,NULL,NULL,NULL,NULL),(349,NULL,349,336,NULL,NULL,NULL,NULL),(350,NULL,350,337,NULL,NULL,NULL,NULL),(351,NULL,351,338,NULL,NULL,NULL,NULL),(352,NULL,352,339,NULL,NULL,NULL,NULL),(353,NULL,353,340,NULL,NULL,NULL,NULL),(354,NULL,354,341,NULL,NULL,NULL,NULL),(355,NULL,355,342,NULL,NULL,NULL,NULL),(356,NULL,356,343,NULL,NULL,NULL,NULL),(357,NULL,357,344,NULL,NULL,NULL,NULL),(358,NULL,358,345,NULL,NULL,NULL,NULL),(359,NULL,359,346,NULL,NULL,NULL,NULL),(360,NULL,360,347,NULL,NULL,NULL,NULL),(361,NULL,361,348,NULL,NULL,NULL,NULL),(362,NULL,362,349,NULL,NULL,NULL,NULL),(363,NULL,363,350,NULL,NULL,NULL,NULL),(364,NULL,364,351,NULL,NULL,NULL,NULL),(365,NULL,365,352,NULL,NULL,NULL,NULL),(366,NULL,366,353,NULL,NULL,NULL,NULL),(367,NULL,367,354,NULL,NULL,NULL,NULL),(368,NULL,368,355,NULL,NULL,NULL,NULL),(369,NULL,369,356,NULL,NULL,NULL,NULL),(370,NULL,370,357,NULL,NULL,NULL,NULL),(371,NULL,371,358,NULL,NULL,NULL,NULL),(372,NULL,372,359,NULL,NULL,NULL,NULL),(373,NULL,373,360,NULL,NULL,NULL,NULL),(374,NULL,374,361,NULL,NULL,NULL,NULL),(375,NULL,375,362,NULL,NULL,NULL,NULL),(376,NULL,376,363,NULL,NULL,NULL,NULL),(377,NULL,377,364,NULL,NULL,NULL,NULL),(378,NULL,378,365,NULL,NULL,NULL,NULL),(379,NULL,379,366,NULL,NULL,NULL,NULL),(380,NULL,380,367,NULL,NULL,NULL,NULL),(381,NULL,381,368,NULL,NULL,NULL,NULL),(382,NULL,382,369,NULL,NULL,NULL,NULL),(383,NULL,383,370,NULL,NULL,NULL,NULL),(384,NULL,384,371,NULL,NULL,NULL,NULL),(385,NULL,385,372,NULL,NULL,NULL,NULL),(386,NULL,386,373,NULL,NULL,NULL,NULL),(387,NULL,387,374,NULL,NULL,NULL,NULL),(388,NULL,388,375,NULL,NULL,NULL,NULL),(389,NULL,389,376,NULL,NULL,NULL,NULL),(390,NULL,390,377,NULL,NULL,NULL,NULL),(391,NULL,391,378,NULL,NULL,NULL,NULL),(392,NULL,392,379,NULL,NULL,NULL,NULL),(393,NULL,393,380,NULL,NULL,NULL,NULL),(394,NULL,394,381,NULL,NULL,NULL,NULL),(395,NULL,395,382,NULL,NULL,NULL,NULL),(396,NULL,396,383,NULL,NULL,NULL,NULL),(397,NULL,397,384,NULL,NULL,NULL,NULL),(398,NULL,398,385,NULL,NULL,NULL,NULL),(399,NULL,399,386,NULL,NULL,NULL,NULL),(400,NULL,400,387,NULL,NULL,NULL,NULL),(401,NULL,401,388,NULL,NULL,NULL,NULL),(402,NULL,402,389,NULL,NULL,NULL,NULL),(438,NULL,438,425,NULL,NULL,NULL,NULL),(439,NULL,439,426,NULL,NULL,NULL,NULL),(440,NULL,440,427,NULL,NULL,NULL,NULL),(441,NULL,441,428,NULL,NULL,NULL,NULL),(442,NULL,442,429,NULL,NULL,NULL,NULL),(443,NULL,443,430,NULL,NULL,NULL,NULL),(444,NULL,444,431,NULL,NULL,NULL,NULL),(445,NULL,445,432,NULL,NULL,NULL,NULL),(446,NULL,446,433,NULL,NULL,NULL,NULL),(447,NULL,447,434,NULL,NULL,NULL,NULL),(448,NULL,448,435,NULL,NULL,NULL,NULL),(449,NULL,449,436,NULL,NULL,NULL,NULL),(450,NULL,450,437,NULL,NULL,NULL,NULL),(451,NULL,451,438,NULL,NULL,NULL,NULL),(452,NULL,452,439,NULL,NULL,NULL,NULL),(453,NULL,453,440,NULL,NULL,NULL,NULL),(454,NULL,454,441,NULL,NULL,NULL,NULL),(455,NULL,455,442,NULL,NULL,NULL,NULL),(456,NULL,456,443,NULL,NULL,NULL,NULL),(457,NULL,457,444,NULL,NULL,NULL,NULL),(458,NULL,458,445,NULL,NULL,NULL,NULL),(459,NULL,459,446,NULL,NULL,NULL,NULL),(460,NULL,460,447,NULL,NULL,NULL,NULL),(461,NULL,461,448,NULL,NULL,NULL,NULL),(462,NULL,462,449,NULL,NULL,NULL,NULL),(463,NULL,463,450,NULL,NULL,NULL,NULL),(464,NULL,464,451,NULL,NULL,NULL,NULL),(465,NULL,465,452,NULL,NULL,NULL,NULL),(466,NULL,466,453,NULL,NULL,NULL,NULL),(467,NULL,467,454,NULL,NULL,NULL,NULL),(468,NULL,468,455,NULL,NULL,NULL,NULL),(469,NULL,469,456,NULL,NULL,NULL,NULL),(470,NULL,470,457,NULL,NULL,NULL,NULL),(471,NULL,471,458,NULL,NULL,NULL,NULL),(472,NULL,472,459,NULL,NULL,NULL,NULL),(473,NULL,473,460,NULL,NULL,NULL,NULL),(474,NULL,474,461,NULL,NULL,NULL,NULL),(475,NULL,475,462,NULL,NULL,NULL,NULL),(476,NULL,476,463,NULL,NULL,NULL,NULL),(477,NULL,477,464,NULL,NULL,NULL,NULL),(478,NULL,478,465,NULL,NULL,NULL,NULL),(479,NULL,479,466,NULL,NULL,NULL,NULL),(480,NULL,480,467,NULL,NULL,NULL,NULL),(481,NULL,481,468,NULL,NULL,NULL,NULL),(482,NULL,482,469,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (483,NULL,483,470,NULL,NULL,NULL,NULL),(484,NULL,484,471,NULL,NULL,NULL,NULL),(485,NULL,485,472,NULL,NULL,NULL,NULL),(486,NULL,486,473,NULL,NULL,NULL,NULL),(487,NULL,487,474,NULL,NULL,NULL,NULL),(488,NULL,488,475,NULL,NULL,NULL,NULL),(489,NULL,489,476,NULL,NULL,NULL,NULL),(490,NULL,490,477,NULL,NULL,NULL,NULL),(491,NULL,491,478,NULL,NULL,NULL,NULL),(492,NULL,492,479,NULL,NULL,NULL,NULL),(493,NULL,493,480,NULL,NULL,NULL,NULL),(494,NULL,494,481,NULL,NULL,NULL,NULL),(495,NULL,495,482,NULL,NULL,NULL,NULL),(496,NULL,496,483,NULL,NULL,NULL,NULL),(497,NULL,497,484,NULL,NULL,NULL,NULL),(498,NULL,498,485,NULL,NULL,NULL,NULL),(499,NULL,499,486,NULL,NULL,NULL,NULL),(500,NULL,500,487,NULL,NULL,NULL,NULL),(501,NULL,501,488,NULL,NULL,NULL,NULL),(502,NULL,502,489,NULL,NULL,NULL,NULL),(503,NULL,503,490,NULL,NULL,NULL,NULL),(504,NULL,504,491,NULL,NULL,NULL,NULL),(505,NULL,505,492,NULL,NULL,NULL,NULL),(506,NULL,506,493,NULL,NULL,NULL,NULL),(507,NULL,507,494,NULL,NULL,NULL,NULL),(508,NULL,508,495,NULL,NULL,NULL,NULL),(509,NULL,509,496,NULL,NULL,NULL,NULL),(510,NULL,510,497,NULL,NULL,NULL,NULL),(511,NULL,511,498,NULL,NULL,NULL,NULL),(512,NULL,512,499,NULL,NULL,NULL,NULL),(513,NULL,513,500,NULL,NULL,NULL,NULL),(514,NULL,514,501,NULL,NULL,NULL,NULL),(515,NULL,515,502,NULL,NULL,NULL,NULL),(516,NULL,516,503,NULL,NULL,NULL,NULL),(517,NULL,517,504,NULL,NULL,NULL,NULL),(518,NULL,518,505,NULL,NULL,NULL,NULL),(519,NULL,519,506,NULL,NULL,NULL,NULL),(520,NULL,520,507,NULL,NULL,NULL,NULL),(521,NULL,521,508,NULL,NULL,NULL,NULL),(522,NULL,522,509,NULL,NULL,NULL,NULL),(523,NULL,523,510,NULL,NULL,NULL,NULL),(524,NULL,524,511,NULL,NULL,NULL,NULL),(525,NULL,525,512,NULL,NULL,NULL,NULL),(526,NULL,526,513,NULL,NULL,NULL,NULL),(527,NULL,527,514,NULL,NULL,NULL,NULL),(528,NULL,528,515,NULL,NULL,NULL,NULL),(529,NULL,529,516,NULL,NULL,NULL,NULL),(530,NULL,530,517,NULL,NULL,NULL,NULL),(531,NULL,531,518,NULL,NULL,NULL,NULL),(532,NULL,532,519,NULL,NULL,NULL,NULL),(533,NULL,533,520,NULL,NULL,NULL,NULL),(534,NULL,534,521,NULL,NULL,NULL,NULL),(535,NULL,535,522,NULL,NULL,NULL,NULL),(536,NULL,536,523,NULL,NULL,NULL,NULL),(537,NULL,537,524,NULL,NULL,NULL,NULL),(538,NULL,538,525,NULL,NULL,NULL,NULL),(539,NULL,539,526,NULL,NULL,NULL,NULL),(540,NULL,540,527,NULL,NULL,NULL,NULL),(541,NULL,541,528,NULL,NULL,NULL,NULL),(542,NULL,542,529,NULL,NULL,NULL,NULL),(543,NULL,543,530,NULL,NULL,NULL,NULL),(544,NULL,544,531,NULL,NULL,NULL,NULL),(545,NULL,545,532,NULL,NULL,NULL,NULL),(546,NULL,546,533,NULL,NULL,NULL,NULL),(547,NULL,547,534,NULL,NULL,NULL,NULL),(548,NULL,548,535,NULL,NULL,NULL,NULL),(549,NULL,549,536,NULL,NULL,NULL,NULL),(550,NULL,550,537,NULL,NULL,NULL,NULL),(676,NULL,676,620,NULL,NULL,NULL,NULL),(677,NULL,677,621,NULL,NULL,NULL,NULL),(678,NULL,678,622,NULL,NULL,NULL,NULL),(679,NULL,679,623,NULL,NULL,NULL,NULL),(680,NULL,680,624,NULL,NULL,NULL,NULL),(681,NULL,681,625,NULL,NULL,NULL,NULL),(682,NULL,682,626,NULL,NULL,NULL,NULL),(683,NULL,683,627,NULL,NULL,NULL,NULL),(684,NULL,684,628,NULL,NULL,NULL,NULL),(685,NULL,685,629,NULL,NULL,NULL,NULL),(686,NULL,686,630,NULL,NULL,NULL,NULL),(687,NULL,687,631,NULL,NULL,NULL,NULL),(688,NULL,688,632,NULL,NULL,NULL,NULL),(689,NULL,689,633,NULL,NULL,NULL,NULL),(690,NULL,690,634,NULL,NULL,NULL,NULL),(691,NULL,691,635,NULL,NULL,NULL,NULL),(692,NULL,692,636,NULL,NULL,NULL,NULL),(693,NULL,693,637,NULL,NULL,NULL,NULL),(694,NULL,694,638,NULL,NULL,NULL,NULL),(695,NULL,695,639,NULL,NULL,NULL,NULL),(697,NULL,697,641,NULL,NULL,NULL,NULL),(698,NULL,698,642,NULL,NULL,NULL,NULL),(699,NULL,699,643,NULL,NULL,NULL,NULL),(700,NULL,700,644,NULL,NULL,NULL,NULL),(701,NULL,701,645,NULL,NULL,NULL,NULL),(702,NULL,702,646,NULL,NULL,NULL,NULL),(703,NULL,703,647,NULL,NULL,NULL,NULL),(704,NULL,704,648,NULL,NULL,NULL,NULL),(705,NULL,705,649,NULL,NULL,NULL,NULL),(706,NULL,706,650,NULL,NULL,NULL,NULL),(707,NULL,707,651,NULL,NULL,NULL,NULL),(708,NULL,708,652,NULL,NULL,NULL,NULL),(709,NULL,709,653,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (710,NULL,710,639,NULL,NULL,NULL,NULL),(711,NULL,711,654,NULL,NULL,NULL,NULL),(712,NULL,712,655,NULL,NULL,NULL,NULL),(713,NULL,713,656,NULL,NULL,NULL,NULL),(714,NULL,714,657,NULL,NULL,NULL,NULL),(715,NULL,715,658,NULL,NULL,NULL,NULL),(716,NULL,716,659,NULL,NULL,NULL,NULL),(717,NULL,717,660,NULL,NULL,NULL,NULL),(718,NULL,718,661,NULL,NULL,NULL,NULL),(719,NULL,719,662,NULL,NULL,NULL,NULL),(720,NULL,720,663,NULL,NULL,NULL,NULL),(721,NULL,721,664,NULL,NULL,NULL,NULL),(722,NULL,722,665,NULL,NULL,NULL,NULL),(725,NULL,725,667,NULL,NULL,NULL,NULL),(726,NULL,726,659,NULL,NULL,NULL,NULL),(727,NULL,727,660,NULL,NULL,NULL,NULL),(728,NULL,728,668,NULL,NULL,NULL,NULL),(729,NULL,729,669,NULL,NULL,NULL,NULL),(730,NULL,730,670,NULL,NULL,NULL,NULL),(731,NULL,731,671,NULL,NULL,NULL,NULL),(732,NULL,732,672,NULL,NULL,NULL,NULL),(733,NULL,733,673,NULL,NULL,NULL,NULL),(734,NULL,734,674,NULL,NULL,NULL,NULL),(735,NULL,735,675,NULL,NULL,NULL,NULL),(736,NULL,736,676,NULL,NULL,NULL,NULL),(737,NULL,737,677,NULL,NULL,NULL,NULL),(738,NULL,738,678,NULL,NULL,NULL,NULL),(739,NULL,739,679,NULL,NULL,NULL,NULL),(740,NULL,740,680,NULL,NULL,NULL,NULL),(741,NULL,741,681,NULL,NULL,NULL,NULL),(742,NULL,742,682,NULL,NULL,NULL,NULL),(743,NULL,743,683,NULL,NULL,NULL,NULL),(744,NULL,744,684,NULL,NULL,NULL,NULL),(745,NULL,745,685,NULL,NULL,NULL,NULL),(746,NULL,746,686,NULL,NULL,NULL,NULL),(747,NULL,747,687,NULL,NULL,NULL,NULL),(748,NULL,748,688,NULL,NULL,NULL,NULL),(749,NULL,749,689,NULL,NULL,NULL,NULL),(750,NULL,750,690,NULL,NULL,NULL,NULL),(751,NULL,751,691,NULL,NULL,NULL,NULL),(752,NULL,752,692,NULL,NULL,NULL,NULL),(753,NULL,753,693,NULL,NULL,NULL,NULL),(754,NULL,754,694,NULL,NULL,NULL,NULL),(755,NULL,755,695,NULL,NULL,NULL,NULL),(756,NULL,756,696,NULL,NULL,NULL,NULL),(757,NULL,757,697,NULL,NULL,NULL,NULL),(758,NULL,758,698,NULL,NULL,NULL,NULL),(759,NULL,759,699,NULL,NULL,NULL,NULL),(760,NULL,760,700,NULL,NULL,NULL,NULL),(761,NULL,761,701,NULL,NULL,NULL,NULL),(762,NULL,762,702,NULL,NULL,NULL,NULL),(763,NULL,763,703,NULL,NULL,NULL,NULL),(764,NULL,764,704,NULL,NULL,NULL,NULL),(765,NULL,765,705,NULL,NULL,NULL,NULL),(766,NULL,766,706,NULL,NULL,NULL,NULL),(767,NULL,767,707,NULL,NULL,NULL,NULL),(768,NULL,768,708,NULL,NULL,NULL,NULL),(769,NULL,769,709,NULL,NULL,NULL,NULL),(770,NULL,770,710,NULL,NULL,NULL,NULL),(771,NULL,771,711,NULL,NULL,NULL,NULL),(772,NULL,772,712,NULL,NULL,NULL,NULL),(773,NULL,773,713,NULL,NULL,NULL,NULL),(774,NULL,774,714,NULL,NULL,NULL,NULL),(775,NULL,775,715,NULL,NULL,NULL,NULL),(776,NULL,776,716,NULL,NULL,NULL,NULL),(777,NULL,777,717,NULL,NULL,NULL,NULL),(778,NULL,778,718,NULL,NULL,NULL,NULL),(779,NULL,779,719,NULL,NULL,NULL,NULL),(780,NULL,780,720,NULL,NULL,NULL,NULL),(781,NULL,781,721,NULL,NULL,NULL,NULL),(782,NULL,782,722,NULL,NULL,NULL,NULL),(783,NULL,783,723,NULL,NULL,NULL,NULL),(784,NULL,784,724,NULL,NULL,NULL,NULL),(785,NULL,785,725,NULL,NULL,NULL,NULL),(786,NULL,786,726,NULL,NULL,NULL,NULL),(787,NULL,787,727,NULL,NULL,NULL,NULL),(788,NULL,788,728,NULL,NULL,NULL,NULL),(789,NULL,789,729,NULL,NULL,NULL,NULL),(790,NULL,790,730,NULL,NULL,NULL,NULL),(791,NULL,791,731,NULL,NULL,NULL,NULL),(792,NULL,792,732,NULL,NULL,NULL,NULL),(793,NULL,793,733,NULL,NULL,NULL,NULL),(794,NULL,794,734,NULL,NULL,NULL,NULL),(795,NULL,795,735,NULL,NULL,NULL,NULL),(796,NULL,796,736,NULL,NULL,NULL,NULL),(797,NULL,797,737,NULL,NULL,NULL,NULL),(798,NULL,798,738,NULL,NULL,NULL,NULL),(799,NULL,799,739,NULL,NULL,NULL,NULL),(800,NULL,800,740,NULL,NULL,NULL,NULL),(801,NULL,801,741,NULL,NULL,NULL,NULL),(802,NULL,802,742,NULL,NULL,NULL,NULL),(803,NULL,803,743,NULL,NULL,NULL,NULL),(804,NULL,804,744,NULL,NULL,NULL,NULL),(805,NULL,805,745,NULL,NULL,NULL,NULL),(806,NULL,806,746,NULL,NULL,NULL,NULL),(807,NULL,807,747,NULL,NULL,NULL,NULL),(808,NULL,808,748,NULL,NULL,NULL,NULL),(809,NULL,809,749,NULL,NULL,NULL,NULL),(810,NULL,810,750,NULL,NULL,NULL,NULL),(811,NULL,811,751,NULL,NULL,NULL,NULL),(812,NULL,812,752,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (813,NULL,813,753,NULL,NULL,NULL,NULL),(814,NULL,814,754,NULL,NULL,NULL,NULL),(815,NULL,815,755,NULL,NULL,NULL,NULL),(816,NULL,816,756,NULL,NULL,NULL,NULL),(817,NULL,817,757,NULL,NULL,NULL,NULL),(818,NULL,818,758,NULL,NULL,NULL,NULL),(819,NULL,819,759,NULL,NULL,NULL,NULL),(820,NULL,820,760,NULL,NULL,NULL,NULL),(821,NULL,821,761,NULL,NULL,NULL,NULL),(822,NULL,822,762,NULL,NULL,NULL,NULL),(823,NULL,823,763,NULL,NULL,NULL,NULL),(824,NULL,824,764,NULL,NULL,NULL,NULL),(825,NULL,825,765,NULL,NULL,NULL,NULL),(826,NULL,826,766,NULL,NULL,NULL,NULL),(827,NULL,827,767,NULL,NULL,NULL,NULL),(828,NULL,828,768,NULL,NULL,NULL,NULL),(829,NULL,829,769,NULL,NULL,NULL,NULL),(830,NULL,830,770,NULL,NULL,NULL,NULL),(831,NULL,831,771,NULL,NULL,NULL,NULL),(832,NULL,832,772,NULL,NULL,NULL,NULL),(833,NULL,833,773,NULL,NULL,NULL,NULL),(834,NULL,834,774,NULL,NULL,NULL,NULL),(835,NULL,835,775,NULL,NULL,NULL,NULL),(836,NULL,836,776,NULL,NULL,NULL,NULL),(837,NULL,837,777,NULL,NULL,NULL,NULL),(838,NULL,838,778,NULL,NULL,NULL,NULL),(839,NULL,839,779,NULL,NULL,NULL,NULL),(840,NULL,840,780,NULL,NULL,NULL,NULL),(841,NULL,841,781,NULL,NULL,NULL,NULL),(842,NULL,842,782,NULL,NULL,NULL,NULL),(843,NULL,843,783,NULL,NULL,NULL,NULL),(844,NULL,844,784,NULL,NULL,NULL,NULL),(845,NULL,845,785,NULL,NULL,NULL,NULL),(846,NULL,846,786,NULL,NULL,NULL,NULL),(847,NULL,847,787,NULL,NULL,NULL,NULL),(848,NULL,848,788,NULL,NULL,NULL,NULL),(849,NULL,849,789,NULL,NULL,NULL,NULL),(850,NULL,850,790,NULL,NULL,NULL,NULL),(851,NULL,851,791,NULL,NULL,NULL,NULL),(852,NULL,852,792,NULL,NULL,NULL,NULL),(853,NULL,853,793,NULL,NULL,NULL,NULL),(854,NULL,854,794,NULL,NULL,NULL,NULL),(855,NULL,855,795,NULL,NULL,NULL,NULL),(856,NULL,856,796,NULL,NULL,NULL,NULL),(857,NULL,857,797,NULL,NULL,NULL,NULL),(858,NULL,858,798,NULL,NULL,NULL,NULL),(859,NULL,859,799,NULL,NULL,NULL,NULL),(860,NULL,860,800,NULL,NULL,NULL,NULL),(861,NULL,861,801,NULL,NULL,NULL,NULL),(862,NULL,862,802,NULL,NULL,NULL,NULL),(863,NULL,863,803,NULL,NULL,NULL,NULL),(864,NULL,864,804,NULL,NULL,NULL,NULL),(865,NULL,865,805,NULL,NULL,NULL,NULL),(866,NULL,866,806,NULL,NULL,NULL,NULL),(867,NULL,867,807,NULL,NULL,NULL,NULL),(868,NULL,868,808,NULL,NULL,NULL,NULL),(894,NULL,894,757,NULL,NULL,NULL,NULL),(895,NULL,895,834,NULL,NULL,NULL,NULL),(896,NULL,896,835,NULL,NULL,NULL,NULL),(897,NULL,897,836,NULL,NULL,NULL,NULL),(898,NULL,898,837,NULL,NULL,NULL,NULL),(899,NULL,899,838,NULL,NULL,NULL,NULL),(900,NULL,900,839,NULL,NULL,NULL,NULL),(901,NULL,901,840,NULL,NULL,NULL,NULL),(902,NULL,902,754,NULL,NULL,NULL,NULL),(903,NULL,903,754,NULL,NULL,NULL,NULL),(904,NULL,904,841,NULL,NULL,NULL,NULL),(905,NULL,905,842,NULL,NULL,NULL,NULL),(906,NULL,906,843,NULL,NULL,NULL,NULL),(907,NULL,907,844,NULL,NULL,NULL,NULL),(908,NULL,908,845,NULL,NULL,NULL,NULL),(909,NULL,909,846,NULL,NULL,NULL,NULL),(910,NULL,910,847,NULL,NULL,NULL,NULL),(911,NULL,911,848,NULL,NULL,NULL,NULL),(912,NULL,912,849,NULL,NULL,NULL,NULL),(913,NULL,913,850,NULL,NULL,NULL,NULL),(914,NULL,914,851,NULL,NULL,NULL,NULL),(915,NULL,915,852,NULL,NULL,NULL,NULL),(916,NULL,916,853,NULL,NULL,NULL,NULL),(917,NULL,917,854,NULL,NULL,NULL,NULL),(918,NULL,918,855,NULL,NULL,NULL,NULL),(919,NULL,919,856,NULL,NULL,NULL,NULL),(920,NULL,920,857,NULL,NULL,NULL,NULL),(922,NULL,922,859,NULL,NULL,NULL,NULL),(923,NULL,923,860,NULL,NULL,NULL,NULL),(924,NULL,924,861,NULL,NULL,NULL,NULL),(925,NULL,925,862,NULL,NULL,NULL,NULL),(926,NULL,926,863,NULL,NULL,NULL,NULL),(927,NULL,927,864,NULL,NULL,NULL,NULL),(928,NULL,928,865,NULL,NULL,NULL,NULL),(929,NULL,929,866,NULL,NULL,NULL,NULL),(930,NULL,930,867,NULL,NULL,NULL,NULL),(931,NULL,931,868,NULL,NULL,NULL,NULL),(932,NULL,932,869,NULL,NULL,NULL,NULL),(933,NULL,933,870,NULL,NULL,NULL,NULL),(934,NULL,934,871,NULL,NULL,NULL,NULL),(937,NULL,937,874,NULL,NULL,NULL,NULL),(938,NULL,938,875,NULL,NULL,NULL,NULL),(939,NULL,939,876,NULL,NULL,NULL,NULL),(940,NULL,940,877,NULL,NULL,NULL,NULL),(941,NULL,941,844,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (942,NULL,942,845,NULL,NULL,NULL,NULL),(943,NULL,943,846,NULL,NULL,NULL,NULL),(944,NULL,944,847,NULL,NULL,NULL,NULL),(945,NULL,945,848,NULL,NULL,NULL,NULL),(946,NULL,946,849,NULL,NULL,NULL,NULL),(947,NULL,947,848,NULL,NULL,NULL,NULL),(948,NULL,948,852,NULL,NULL,NULL,NULL),(949,NULL,949,854,NULL,NULL,NULL,NULL),(950,NULL,950,856,NULL,NULL,NULL,NULL),(951,NULL,951,857,NULL,NULL,NULL,NULL),(952,NULL,952,859,NULL,NULL,NULL,NULL),(953,NULL,953,860,NULL,NULL,NULL,NULL),(954,NULL,954,865,NULL,NULL,NULL,NULL),(955,NULL,955,841,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,13,NULL,'Clientes - Deudores',0,0,0,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,20,NULL,'Anticipos Impuesto a las Ganancias',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,23,NULL,'Retenciones Impuesto a las Ganancias',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(25,NULL,25,NULL,'Retenciones de IVA',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(57,NULL,57,NULL,'Proveedores en Cta. Cte. locales',0,0,0,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,60,NULL,'Cheques emitidos ',0,1,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(62,NULL,62,NULL,'Sueldos y Jornales a pagar',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,140,NULL,'Intereses y Gastos bancarios',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(162,NULL,162,NULL,'Retenciones SUSS',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(176,NULL,176,NULL,'Cheques en Cartera',1,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(201,NULL,201,NULL,'Monotributo',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(203,NULL,203,NULL,'Autonomos',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(219,NULL,219,NULL,'Pagos AFIP',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,251,NULL,'Retenciones de IIBB Buenos Aires',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(252,NULL,252,NULL,'Retenciones de IIBB Capital Federal',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(253,NULL,253,NULL,'Retenciones de IIBB Catamarca',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(254,NULL,254,NULL,'Retenciones de IIBB Chaco',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(255,NULL,255,NULL,'Retenciones de IIBB Chubut',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(256,NULL,256,NULL,'Retenciones de IIBB Córdoba',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(257,NULL,257,NULL,'Retenciones de IIBB Corrientes',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(258,NULL,258,NULL,'Retenciones de IIBB Entre Ríos',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(259,NULL,259,NULL,'Retenciones de IIBB Formosa',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(260,NULL,260,NULL,'Retenciones de IIBB Jujuy',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(261,NULL,261,NULL,'Retenciones de IIBB La Pampa',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(262,NULL,262,NULL,'Retenciones de IIBB La Rioja',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(263,NULL,263,NULL,'Retenciones de IIBB Mendoza',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(264,NULL,264,NULL,'Retenciones de IIBB Misiones',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(265,NULL,265,NULL,'Retenciones de IIBB Neuquén',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(266,NULL,266,NULL,'Retenciones de IIBB Pascua Lama',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(267,NULL,267,NULL,'Retenciones de IIBB Río Negro',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(268,NULL,268,NULL,'Retenciones de IIBB Salta',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(269,NULL,269,NULL,'Retenciones de IIBB San Juan',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(270,NULL,270,NULL,'Retenciones de IIBB San Luis',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(271,NULL,271,NULL,'Retenciones de IIBB Santa Cruz',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(272,NULL,272,NULL,'Retenciones de IIBB Santa Fe',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(273,NULL,273,NULL,'Retenciones de IIBB Santiago del Estero',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (274,NULL,274,NULL,'Retenciones de IIBB Tierra del Fuego',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(275,NULL,275,NULL,'Retenciones de IIBB Tucuman',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(351,NULL,351,NULL,'BANCO SIRCREB',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,359,NULL,'Caja en Pesos',0,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(360,NULL,360,NULL,'Retenciones Bancarias de Ganancias a Favor',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,364,NULL,'Anticipo de Clientes',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,384,NULL,'Caja en Dolares',0,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(409,NULL,409,NULL,'IVA Crédito Fiscal No computable',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(418,NULL,418,NULL,'Deudas Bancarias',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,433,NULL,'Préstamo',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,441,NULL,'Leasing',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,448,NULL,'Planes de Pagos AFIP',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,450,NULL,'Cheques Rechazados',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(467,NULL,467,NULL,'Interés',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(468,0,14,NULL,'Deudores por ventas comunes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(469,0,15,NULL,'Deudores por ventas morosos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(470,0,16,NULL,'Deudores en gestión judicial',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(471,0,17,NULL,'Previsión deudores incobrables',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(472,0,22,NULL,'Anticipo Impto.Ganancia Mínima Presunta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(473,0,24,NULL,'Impuesto a las Ganancias (Saldo a favor)',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(474,0,27,NULL,'Anticipos de proveedores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(475,0,28,NULL,'Depósito en garantía alquileres',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(476,0,29,NULL,'Derechos adquiridos a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(477,0,30,NULL,'Intereses a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(478,0,31,NULL,'Cuentas a rendir - Directores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(479,0,32,NULL,'Alquileres no devengados',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(480,0,38,NULL,'Equipos de computación valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(481,0,39,NULL,'Equipos de computación ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(482,0,40,NULL,'Amortización Acumulada Equipos de comput.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(483,0,42,NULL,'Instalaciones valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(484,0,43,NULL,'Instalaciones ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(485,0,44,NULL,'Amortización Acumulada Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(486,0,46,NULL,'Muebles y utiles valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(487,0,47,NULL,'Muebles y utiles ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(488,0,48,NULL,'Amortización Acumulada Muebles y Útiles',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(489,0,50,NULL,'Gastos de organización valores historicos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (490,0,51,NULL,'Gastos de organización ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(491,0,52,NULL,'Amortización acumulada gs. de organización',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(492,0,58,NULL,'Proveedores en cta. cte. exterior',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(493,0,59,NULL,'Derechos de exhibición a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(494,0,63,NULL,'Cargas sociales a pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(495,0,64,NULL,'Sindicatos a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(496,0,67,NULL,'IVA Debito Fiscal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(497,0,68,NULL,'IVA Credito Fiscal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(498,0,69,NULL,'Impuestos Internos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(499,0,70,NULL,'Impuestos al Combustible',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(500,0,71,NULL,'IVA Retenciones de terceros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(501,0,72,NULL,'IVA Percepciones realiz.por terceros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(502,0,73,NULL,'IVA Saldo a favor',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(503,0,74,NULL,'IVA a pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(504,0,75,NULL,'Percepciones Ingresos Brutos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(505,0,76,NULL,'Otros Pagos AFIP',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(506,0,78,NULL,'Impuesto a los Ingresos Brutos Pasivo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(507,0,79,NULL,'Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(508,0,80,NULL,'Impuesto a la Ganancia Mínima Presunta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(509,0,81,NULL,'AFIP - Retenciones Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(510,0,82,NULL,'AFIP - Plan de Facilidades Decreto 338/02',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(511,0,87,NULL,'Acciones en circulación',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(512,0,88,NULL,'Ajuste del Capital',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(513,0,89,NULL,'Aportes Irrevocables Futuras Suscripciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(514,0,91,NULL,'Resultado del ejercicio',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(515,0,92,NULL,'Resultado ejercicios anteriores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(516,0,93,NULL,'A.R.E.A.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(517,0,96,NULL,'VENTAS',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-04-02 13:48:54',NULL),(518,0,97,NULL,'Honorarios',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-04-02 13:48:54',NULL),(519,0,99,NULL,'Descuentos obtenidos',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-04-02 13:48:54',NULL),(520,0,100,NULL,'Reintegros por exportaciones',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-04-02 13:48:54',NULL),(521,0,102,NULL,'Intereses Cobrados',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-04-02 13:48:54',NULL),(522,0,103,NULL,'Diferencias de cambio',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-04-02 13:48:54',NULL),(523,0,104,NULL,'Descuentos obtenidos',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-04-02 13:48:54',NULL),(524,0,110,NULL,'Sueldos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(525,0,111,NULL,'Contribuciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(526,0,112,NULL,'Sindicato',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(527,0,114,NULL,'ACA',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (528,0,115,NULL,'Aereos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(529,0,116,NULL,'Alquiler',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(530,0,117,NULL,'AGUA AYSA',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(531,0,118,NULL,'TV Cablevision',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(532,0,119,NULL,'Caja Jubilacion Consejo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(533,0,120,NULL,'Celulares',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(534,0,121,NULL,'Cheques',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(535,0,123,NULL,'Comida',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(536,0,126,NULL,'Fletes y acarreos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(537,0,127,NULL,'Luz Edesur',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(538,0,128,NULL,'Movilidad y Viáticos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(539,0,129,NULL,'Mantenimiento',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(540,0,130,NULL,'IVA No Computable',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(541,0,131,NULL,'Entretenimiento',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(542,0,132,NULL,'Amortización Bienes de Uso',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(543,0,135,NULL,'Gastos varios',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(544,0,136,NULL,'Ajuste por redondeo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(545,0,137,NULL,'Deudores Incobrables',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(546,0,141,NULL,'Intereses Proveedores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(547,0,143,NULL,'Diferencias de cambio',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(548,0,144,NULL,'Diferencia de Cambio Bces. en M.Extranjera',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(549,0,145,NULL,'Diferencia tipo cambio Vendedor/Comprador',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(550,0,146,NULL,'Diferencia por conversion en Bce. en Mon. Extranj.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(551,0,147,NULL,'Diferencia de cambio CMV',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(552,0,148,NULL,'Diferencia de cambio PT',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(553,0,149,NULL,'Resultado por Exposición a la Inflación',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(554,0,150,NULL,'Diferencia de cambio PE',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(555,0,151,NULL,'Diferencia de cambio Ds.Vtas.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(556,0,152,NULL,'Diferencia de cambio ME',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(557,0,153,NULL,'Descuentos otorgados',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(558,0,155,NULL,'Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(559,0,156,NULL,'Impuesto a los Ingresos Brutos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(560,0,157,NULL,'Impuesto al Debito y Credito Bancario',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(561,0,159,NULL,'Pérdida por venta bienes de uso',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(562,0,160,NULL,'Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(563,0,161,NULL,'Amortizaciones extraordinarias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(564,0,178,NULL,'Google',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(565,0,188,NULL,'Publicidad',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(566,0,191,NULL,'Cargas Sociales',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (567,0,192,NULL,'Honorarios',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(568,0,193,NULL,'Telefono Fijo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(569,0,198,NULL,'Seguros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(570,0,199,NULL,'Internet',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(571,0,204,NULL,'Multas Impositivas',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(572,0,208,NULL,'Impuesto a los Ingresos Brutos - BS AS',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(573,0,209,NULL,'SIRCREB',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(574,0,212,NULL,'Tarjeta Visa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(575,0,213,NULL,'Tarjeta American Express',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(576,0,214,NULL,'Tarjeta Mastercard',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(577,0,215,NULL,'Tarjeta Shopping',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(578,0,216,NULL,'Tarjeta Cencosud',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(579,0,217,NULL,'Compras',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(580,0,218,NULL,'Ventas No Gravadas',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-04-02 13:48:54',NULL),(581,0,220,NULL,'Perc IVA -RG3337',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(582,0,221,NULL,'Imps. Internos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(583,0,222,NULL,'Imp. Gasoil',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(584,0,223,NULL,'Imp. Hídricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(585,0,224,NULL,'ITC',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(586,0,225,NULL,'Perc IIBB  Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(587,0,226,NULL,'Perc IIBB  Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(588,0,227,NULL,'Perc IIBB  Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(589,0,228,NULL,'Perc IIBB  Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(590,0,229,NULL,'Perc IIBB  Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(591,0,230,NULL,'Perc IIBB  Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(592,0,231,NULL,'Perc IIBB  Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(593,0,232,NULL,'Perc IIBB  Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(594,0,233,NULL,'Perc IIBB  Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(595,0,234,NULL,'Perc IIBB  Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(596,0,235,NULL,'Perc IIBB  La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(597,0,236,NULL,'Perc IIBB  La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(598,0,237,NULL,'Perc IIBB  Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(599,0,238,NULL,'Perc IIBB  Misiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(600,0,239,NULL,'Perc IIBB  Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(601,0,240,NULL,'Perc IIBB  Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(602,0,241,NULL,'Perc IIBB  Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(603,0,242,NULL,'Perc IIBB  Salta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(604,0,243,NULL,'Perc IIBB  San Juan',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(605,0,244,NULL,'Perc IIBB  San Luis',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(606,0,245,NULL,'Perc IIBB  Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (607,0,246,NULL,'Perc IIBB  Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(608,0,247,NULL,'Perc IIBB  Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(609,0,248,NULL,'Perc IIBB  Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(610,0,249,NULL,'Perc IIBB  Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(611,0,250,NULL,'Compras No Gravadas',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(612,0,276,NULL,'SIRCREB Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(613,0,277,NULL,'SIRCREB Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(614,0,278,NULL,'SIRCREB Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(615,0,279,NULL,'SIRCREB Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(616,0,280,NULL,'SIRCREB Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(617,0,281,NULL,'SIRCREB Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(618,0,282,NULL,'SIRCREB Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(619,0,283,NULL,'SIRCREB Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(620,0,284,NULL,'SIRCREB Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(621,0,285,NULL,'SIRCREB Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(622,0,286,NULL,'SIRCREB La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(623,0,287,NULL,'SIRCREB La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(624,0,288,NULL,'SIRCREB Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(625,0,289,NULL,'SIRCREB Misiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(626,0,290,NULL,'SIRCREB Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(627,0,291,NULL,'SIRCREB Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(628,0,292,NULL,'SIRCREB Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(629,0,293,NULL,'SIRCREB Salta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(630,0,294,NULL,'SIRCREB San Juan',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(631,0,295,NULL,'SIRCREB San Luis',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(632,0,296,NULL,'SIRCREB Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(633,0,297,NULL,'SIRCREB Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(634,0,298,NULL,'SIRCREB Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(635,0,299,NULL,'SIRCREB Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(636,0,300,NULL,'SIRCREB Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(637,0,301,NULL,'IIBB a Favor Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(638,0,302,NULL,'IIBB a Favor Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(639,0,303,NULL,'IIBB a Favor Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(640,0,304,NULL,'IIBB a Favor Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(641,0,305,NULL,'IIBB a Favor Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(642,0,306,NULL,'IIBB a Favor Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(643,0,307,NULL,'IIBB a Favor Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(644,0,308,NULL,'IIBB a Favor Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(645,0,309,NULL,'IIBB a Favor Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(646,0,310,NULL,'IIBB a Favor Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (647,0,311,NULL,'IIBB a Favor La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(648,0,312,NULL,'IIBB a Favor La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(649,0,313,NULL,'IIBB a Favor Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(650,0,314,NULL,'IIBB a Favor Misiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(651,0,315,NULL,'IIBB a Favor Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(652,0,316,NULL,'IIBB a Favor Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(653,0,317,NULL,'IIBB a Favor Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(654,0,318,NULL,'IIBB a Favor Salta',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(655,0,319,NULL,'IIBB a Favor San Juan',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(656,0,320,NULL,'IIBB a Favor San Luis',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(657,0,321,NULL,'IIBB a Favor Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(658,0,322,NULL,'IIBB a Favor Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(659,0,323,NULL,'IIBB a Favor Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(660,0,324,NULL,'IIBB a Favor Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(661,0,325,NULL,'IIBB a Favor Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(662,0,326,NULL,'IIBB a Pagar Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(663,0,327,NULL,'IIBB a Pagar Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(664,0,328,NULL,'IIBB a Pagar Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(665,0,329,NULL,'IIBB a Pagar Chaco',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(666,0,330,NULL,'IIBB a Pagar Chubut',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(667,0,331,NULL,'IIBB a Pagar Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(668,0,332,NULL,'IIBB a Pagar Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(669,0,333,NULL,'IIBB a Pagar Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(670,0,334,NULL,'IIBB a Pagar Formosa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(671,0,335,NULL,'IIBB a Pagar Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(672,0,336,NULL,'IIBB a Pagar La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(673,0,337,NULL,'IIBB a Pagar La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(674,0,338,NULL,'IIBB a Pagar Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(675,0,339,NULL,'IIBB a Pagar Misiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(676,0,340,NULL,'IIBB a Pagar Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(677,0,341,NULL,'IIBB a Pagar Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(678,0,342,NULL,'IIBB a Pagar Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(679,0,343,NULL,'IIBB a Pagar Salta',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(680,0,344,NULL,'IIBB a Pagar San Juan',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(681,0,345,NULL,'IIBB a Pagar San Luis',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(682,0,346,NULL,'IIBB a Pagar Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(683,0,347,NULL,'IIBB a Pagar Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(684,0,348,NULL,'IIBB a Pagar Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (685,0,349,NULL,'IIBB a Pagar Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(686,0,350,NULL,'IIBB a Pagar Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(687,0,352,NULL,'Compensacion',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(688,0,353,NULL,'IVA Saldo Tecnico',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(689,0,354,NULL,'IVA Saldo Libre Disponibilidad',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(690,0,361,NULL,'Equipos de Computación',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(691,0,362,NULL,'Computadoras',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(692,0,363,NULL,'Muebles y Utiles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(693,0,365,NULL,'Provision Honorarios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(694,0,366,NULL,'Cta. Cte Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(695,0,367,NULL,'Provisión Honorarios Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(696,0,368,NULL,'Cuenta Particular Socio 1',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(697,0,369,NULL,'Capital',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(698,0,380,NULL,'Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(699,0,381,NULL,'Reserva Legal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(700,0,382,NULL,'Reserva Legal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(701,0,383,NULL,'Resultado no asignado',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(702,0,386,NULL,'PLAZO FIJO',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(703,0,388,NULL,'ACCIONES',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(704,0,389,NULL,'Inmuebles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(705,0,390,NULL,'Vehiculos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(706,0,391,NULL,'Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(707,0,392,NULL,'MERCADERIAS',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(708,0,393,NULL,'OTROS',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(709,0,395,NULL,'Cuenta Particular Socio 2',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(710,0,396,NULL,'Comisiones Y gastos Bancarios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(711,0,411,NULL,'Provisión Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(712,0,412,NULL,'Amortización Muebles y Útiles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(713,0,413,NULL,'Amortización Equipos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(714,0,414,NULL,'Amortizacion Acumulada Equipos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(715,0,415,NULL,'Amortización Acumulada Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(716,0,416,NULL,'Materias Primas',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(717,0,419,NULL,'Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(718,0,420,NULL,'Amortización Acumulada Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(719,0,421,NULL,'Amortización Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(720,0,422,NULL,'Amortización Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(721,0,423,NULL,'Accesorios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(722,0,424,NULL,'Amortización Acumulada Accesorios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(723,0,426,NULL,'Reserva Facultativa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (724,0,427,NULL,'Créditos por Impuestos Diferidos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(725,0,428,NULL,'Fondo de Comercio',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(726,0,429,NULL,'Amortizacion Acumulada Fondo de Comercio',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(727,0,430,NULL,'Intereses a devengar AGIP',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(728,0,431,NULL,'PFP IIBB',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(729,0,434,NULL,'Productos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(730,0,435,NULL,'Intereses a devengar PFP',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(731,0,437,NULL,'Imp. Ley 25413 Cred 0.6%',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(732,0,438,NULL,'Honorarios Directorio a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(733,0,439,NULL,'Reserva para Futuras Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(734,0,440,NULL,'TEAC - Trabajos Ejecutados a Certificar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(735,0,444,NULL,'Banco Santander Rio Cta Cte',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(736,0,449,NULL,'Leasing',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(737,0,453,NULL,'Inversión Central Caribe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(738,0,454,NULL,'Otras Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(739,0,455,NULL,'Otros Créditos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(740,0,456,NULL,'Provisión Honorarios Socio Gerente',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(741,0,459,NULL,'Moratoria SUSS a pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(742,0,460,NULL,'Impuestos Municipales a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(743,0,461,NULL,'Amortización Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(744,0,462,NULL,'Amortización Equipos de comput.',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(745,0,463,NULL,'Cuenta Particular Socio 3',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(746,0,464,NULL,'Cuenta Particular Socio 4',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(747,0,465,NULL,'Otras Reservas',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(748,0,466,NULL,'IGMP (Saldo a Favor)',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(749,0,468,NULL,'Productos en Proceso',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(750,0,469,NULL,'Depósitos en Garantía Socio Gerente',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(751,0,470,NULL,'Fondos Embargados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(752,0,471,NULL,'Cuota Solid.',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(753,0,472,NULL,'Anticipo Honorarios Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(754,0,473,NULL,'SICORE a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(755,0,476,NULL,'RECPAM',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(756,0,478,NULL,'CO2 - Imp. Al Carbono',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'PEDIDO',1,NULL,NULL,NULL),(2,NULL,'ACEPTADO',1,NULL,NULL,NULL),(3,NULL,'RECHAZADO',1,NULL,NULL,NULL),(4,NULL,'PAGADO',1,NULL,NULL,NULL),(5,NULL,'CONCILIADO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `numero` int(11) NOT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'COMPRAS',1,NULL,NULL,NULL),(2,NULL,'VENTAS',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq`
--

DROP TABLE IF EXISTS `faq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pregunta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `respuesta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq`
--

LOCK TABLES `faq` WRITE;
/*!40000 ALTER TABLE `faq` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_upload_details`
--

DROP TABLE IF EXISTS `file_upload_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_upload_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_upload_id` int(10) unsigned NOT NULL,
  `detail` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_upload_details_file_upload_id_foreign` (`file_upload_id`),
  CONSTRAINT `file_upload_details_file_upload_id_foreign` FOREIGN KEY (`file_upload_id`) REFERENCES `file_uploads` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_upload_details`
--

LOCK TABLES `file_upload_details` WRITE;
/*!40000 ALTER TABLE `file_upload_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_upload_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_uploads`
--

DROP TABLE IF EXISTS `file_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_uploads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_type_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_uploads_data_type_id_foreign` (`data_type_id`),
  KEY `file_uploads_user_id_foreign` (`user_id`),
  KEY `file_uploads_person_id_foreign` (`person_id`),
  KEY `file_uploads_period_id_foreign` (`period_id`),
  CONSTRAINT `file_uploads_data_type_id_foreign` FOREIGN KEY (`data_type_id`) REFERENCES `data_types` (`id`),
  CONSTRAINT `file_uploads_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `file_uploads_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `file_uploads_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tusers` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_uploads`
--

LOCK TABLES `file_uploads` WRITE;
/*!40000 ALTER TABLE `file_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_art_90`
--

DROP TABLE IF EXISTS `ganan_art_90`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_art_90` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_art_90`
--

LOCK TABLES `ganan_art_90` WRITE;
/*!40000 ALTER TABLE `ganan_art_90` DISABLE KEYS */;
INSERT INTO `ganan_art_90` VALUES (1,2017,0.00,20000.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,2017,20000.00,40000.00,1000.00,0.09,20000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,2017,40000.00,60000.00,2800.00,0.12,40000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,2017,60000.00,80000.00,5200.00,0.15,60000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,2017,80000.00,120000.00,8200.00,0.19,80000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,2017,120000.00,160000.00,15800.00,0.23,120000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,2017,160000.00,240000.00,25000.00,0.27,160000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,2017,240000.00,320000.00,46600.00,0.31,240000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,2017,320000.00,999999999.99,71400.00,0.35,320000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,2018,0.00,25754.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,2018,25754.00,51508.00,1287.70,0.09,25754.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,2018,51508.00,77262.00,3605.56,0.12,51508.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,2018,77262.00,103016.00,6696.04,0.15,77262.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,2018,103016.00,154524.00,10559.14,0.19,103016.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(15,2018,154524.00,206032.00,20345.66,0.23,154524.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(16,2018,206032.00,309048.00,32192.50,0.27,206032.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(17,2018,309048.00,412064.00,60006.82,0.31,309048.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(18,2018,412064.00,999999999.99,91941.78,0.35,412064.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(19,2019,0.00,33039.81,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(20,2019,33039.81,66079.61,1651.99,0.09,33039.81,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(21,2019,66079.61,99119.42,4625.57,0.12,66079.61,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(22,2019,99119.42,132159.23,8590.35,0.15,99119.42,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(23,2019,132159.23,198238.84,13546.32,0.19,132159.23,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(24,2019,198238.84,264318.45,26101.45,0.23,198238.84,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(25,2019,264318.45,396477.68,41299.76,0.27,264318.45,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(26,2019,396477.68,528636.91,76982.75,0.31,396477.68,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(27,2019,528636.91,999999999.99,117952.11,0.35,528636.91,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(28,2016,0.00,10000.00,0.00,0.09,0.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(29,2016,10000.00,20000.00,900.00,0.14,10000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(30,2016,20000.00,30000.00,2300.00,0.19,20000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(31,2016,30000.00,60000.00,4200.00,0.23,30000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(32,2016,60000.00,90000.00,11100.00,0.27,60000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(33,2016,90000.00,120000.00,19200.00,0.31,90000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(34,2016,120000.00,999999999.00,28500.00,0.35,120000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(37,2020,0.00,47669.16,0.00,0.05,0.00,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(38,2020,47669.16,95338.32,2383.46,0.09,47669.16,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(39,2020,95338.32,143007.48,6673.68,0.12,95338.32,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(40,2020,143007.48,190676.65,12393.98,0.15,143007.48,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(41,2020,190676.65,286014.96,19544.36,0.19,190676.65,'2020-01-28 14:17:39','2021-04-02 13:48:56',NULL),(42,2020,286014.96,381353.28,37658.64,0.23,286014.96,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_art_90` VALUES (43,2020,381353.28,572029.92,59586.45,0.27,381353.28,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(44,2020,572029.92,762706.57,111069.14,0.31,572029.92,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(45,2020,762706.57,999999999.99,170178.90,0.35,762706.57,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(46,2021,0.00,64532.64,0.00,0.05,0.00,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(47,2021,64532.64,129065.29,3226.63,0.09,64532.64,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(48,2021,129065.29,193597.93,9034.57,0.12,129065.29,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(49,2021,193597.93,258130.58,16778.49,0.15,193597.93,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(50,2021,258130.58,387195.86,26458.39,0.19,258130.58,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(51,2021,387195.86,516261.14,50980.79,0.23,387195.86,'2021-04-02 13:48:56','2022-06-07 11:11:37',NULL),(52,2021,516261.14,774391.71,80665.80,0.27,516261.14,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(53,2021,774391.71,1032522.30,150361.06,0.31,774391.71,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(54,2021,1032522.30,999999999.99,230381.54,0.35,1032522.30,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(55,2022,0.00,97201.99,0.00,0.05,0.00,'2022-01-11 14:08:05','2022-02-06 22:41:02',NULL),(56,2022,97201.99,194404.01,4860.10,0.09,97201.99,'2022-01-11 14:08:05','2022-01-11 14:08:05',NULL),(57,2022,194404.01,291606.01,13608.29,0.12,194404.01,'2022-01-11 14:08:05','2022-01-11 14:08:05',NULL),(58,2022,291606.01,388808.02,25272.52,0.15,291606.01,'2022-01-11 14:08:05','2022-01-11 14:08:05',NULL),(59,2022,388808.02,583212.02,39852.82,0.19,388808.02,'2022-01-11 14:08:05','2022-01-11 14:08:05',NULL),(60,2022,583212.02,777616.02,76789.59,0.23,583212.02,'2022-01-11 14:08:05','2022-01-11 14:08:05',NULL),(61,2022,777616.02,1166424.03,121502.49,0.27,777616.02,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(62,2022,1166424.03,1555232.07,226480.67,0.31,1166424.03,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(63,2022,1555232.07,9999999.00,347011.15,0.35,1555232.07,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL);
/*!40000 ALTER TABLE `ganan_art_90` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_categorias`
--

DROP TABLE IF EXISTS `ganan_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_categorias`
--

LOCK TABLES `ganan_categorias` WRITE;
/*!40000 ALTER TABLE `ganan_categorias` DISABLE KEYS */;
INSERT INTO `ganan_categorias` VALUES (1,'Primera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,'Segunda',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(3,'Tercera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(4,'Cuarta',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_conceptos_anticipos`
--

DROP TABLE IF EXISTS `ganan_conceptos_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_conceptos_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ganan_conceptos_anticipos_nombre_unique` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_conceptos_anticipos`
--

LOCK TABLES `ganan_conceptos_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` DISABLE KEYS */;
INSERT INTO `ganan_conceptos_anticipos` VALUES (1,NULL,'Anticipos',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,'Retenciones y Percepciones',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,'Saldo a Favor Anterior',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL);
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_anticipos`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_anticipos`
--

LOCK TABLES `ganan_ddjj_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_deducciones`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_deduccion_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_deducciones_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` (`ganan_deduccion_id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` FOREIGN KEY (`ganan_deduccion_id`) REFERENCES `ganan_deducciones` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_deducciones`
--

LOCK TABLES `ganan_ddjj_detail_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_ing_egr`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_ing_egr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_ing_egr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `ganan_categoria_id` int(10) unsigned NOT NULL,
  `ganan_tipo_op_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_ing_egr_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` (`ganan_categoria_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` (`ganan_tipo_op_id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` FOREIGN KEY (`ganan_categoria_id`) REFERENCES `ganan_categorias` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` FOREIGN KEY (`ganan_tipo_op_id`) REFERENCES `ganan_tipos_op` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_ing_egr`
--

LOCK TABLES `ganan_ddjj_detail_ing_egr` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjjs`
--

DROP TABLE IF EXISTS `ganan_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ingresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `ingresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deducciones_total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `ganan_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjjs`
--

LOCK TABLES `ganan_ddjjs` WRITE;
/*!40000 ALTER TABLE `ganan_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_deducciones`
--

DROP TABLE IF EXISTS `ganan_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `generales` tinyint(1) NOT NULL DEFAULT '0',
  `particulares` tinyint(1) NOT NULL DEFAULT '0',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_deducciones`
--

LOCK TABLES `ganan_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_deducciones` DISABLE KEYS */;
INSERT INTO `ganan_deducciones` VALUES (1,NULL,2017,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,2017,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,2017,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,NULL,2017,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,NULL,2017,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,NULL,2017,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,NULL,2017,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,NULL,2017,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,NULL,2017,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,NULL,2017,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,NULL,2017,1,0,'Servicio Doméstico',51967.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,NULL,2017,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,NULL,2017,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,NULL,2017,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(15,NULL,2017,0,1,'Conyuge',48447.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(16,NULL,2017,0,1,'Hijo Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(17,NULL,2017,0,1,'Hijo Menor 18 años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(18,NULL,2017,0,1,'Hijastro Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(19,NULL,2017,0,1,'Hijastro Menor 18 Años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(20,NULL,2017,0,1,'Ganancia No Imponible',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(21,NULL,2017,0,1,'Deduccion Especial',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(22,NULL,2018,1,0,'Primas de seguro para el caso de muerte',12000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(23,NULL,2018,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(24,NULL,2018,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(25,NULL,2018,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(26,NULL,2018,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(27,NULL,2018,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(28,NULL,2018,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(29,NULL,2018,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(30,NULL,2018,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (31,NULL,2018,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(32,NULL,2018,1,0,'Servicio Doméstico',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(33,NULL,2018,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(34,NULL,2018,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(35,NULL,2018,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(36,NULL,2018,0,1,'Conyuge',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(37,NULL,2018,0,1,'Hijo Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(38,NULL,2018,0,1,'Hijo Menor 18 años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(39,NULL,2018,0,1,'Hijastro Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(40,NULL,2018,0,1,'Hijastro Menor 18 Años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(41,NULL,2018,0,1,'Ganancia No Imponible',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(42,NULL,2018,0,1,'Deduccion Especial',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(43,NULL,2019,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(44,NULL,2019,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(45,NULL,2019,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(46,NULL,2019,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(47,NULL,2019,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(48,NULL,2019,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(49,NULL,2019,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(50,NULL,2019,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(51,NULL,2019,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(52,NULL,2019,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(53,NULL,2019,1,0,'Servicio Doméstico',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(54,NULL,2019,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(55,NULL,2019,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(56,NULL,2019,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(57,NULL,2019,0,1,'Conyuge',80033.97,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(58,NULL,2019,0,1,'Hijo Incapacitado',40361.43,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(59,NULL,2019,0,1,'Hijo Menor 18 años',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(60,NULL,2019,0,1,'Hijastro Incapacitado',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(61,NULL,2019,0,1,'Hijastro Menor 18 Años',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(62,NULL,2019,0,1,'Ganancia No Imponible',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(63,NULL,2019,0,1,'Deduccion Especial',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (64,NULL,2016,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(65,NULL,2016,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(66,NULL,2016,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(67,NULL,2016,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(68,NULL,2016,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(69,NULL,2016,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(70,NULL,2016,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(71,NULL,2016,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(72,NULL,2016,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(73,NULL,2016,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(74,NULL,2016,1,0,'Servicio Doméstico',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(75,NULL,2016,1,0,'Donaciones',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(76,NULL,2016,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(77,NULL,2016,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y \n            Paramédica',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(78,NULL,2016,0,1,'Conyuge',39778.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(79,NULL,2016,0,1,'Hijo Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(80,NULL,2016,0,1,'Hijo Menor 18 años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(81,NULL,2016,0,1,'Hijastro Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(82,NULL,2016,0,1,'Hijastro Menor 18 Años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(83,NULL,2016,0,1,'Ganancia No Imponible',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(84,NULL,2016,0,1,'Deduccion Especial',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(85,NULL,2019,1,0,'Alquileres',103018.97,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(86,NULL,2020,1,0,'Alquileres',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(87,NULL,2020,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(88,NULL,2020,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(89,NULL,2020,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(90,NULL,2020,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(91,NULL,2020,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(92,NULL,2020,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(93,NULL,2020,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_deducciones` VALUES (94,NULL,2020,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(95,NULL,2020,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(96,NULL,2020,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(97,NULL,2020,1,0,'Servicio Doméstico',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(98,NULL,2020,1,0,'Donaciones',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(99,NULL,2020,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(100,NULL,2020,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(101,NULL,2020,0,1,'Conyuge',115471.38,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(102,NULL,2020,0,1,'Hijo Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(103,NULL,2020,0,1,'Hijo Menor 18 años',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(104,NULL,2020,0,1,'Hijastro Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(105,NULL,2020,0,1,'Hijastro Menor 18 Años',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(106,NULL,2020,0,1,'Ganancia No Imponible',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(107,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1',103018.79,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(108,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1 \"Nuevos Profesionales / Emprendedores',309652.93,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(109,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 2',594533.62,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(110,NULL,2021,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(111,NULL,2021,1,0,'Gastos de Sepelio',996.23,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(112,NULL,2021,1,0,'Aportes a Obras Sociales',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(113,NULL,2021,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(114,NULL,2021,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(115,NULL,2021,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(116,NULL,2021,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(117,NULL,2021,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(118,NULL,2021,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(119,NULL,2021,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(120,NULL,2021,1,0,'Servicio Doméstico',167678.40,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(121,NULL,2021,1,0,'Donaciones',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(122,NULL,2021,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(123,NULL,2021,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(124,NULL,2021,0,1,'Conyuge',156320.63,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(125,NULL,2021,0,1,'Hijo Menor 18 años',78833.08,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL);
INSERT INTO `ganan_deducciones` VALUES (126,NULL,2021,0,1,'Ganancia No Imponible',167678.40,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(127,NULL,2021,0,1,'Deduccion Especial',804856.34,1,'2021-04-02 13:48:56','2021-04-02 13:48:56',NULL),(128,NULL,2022,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(129,NULL,2022,1,0,'Gastos de Sepelio',996.23,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(130,NULL,2022,1,0,'Aportes a Obras Sociales',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(131,NULL,2022,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(132,NULL,2022,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(133,NULL,2022,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(134,NULL,2022,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(135,NULL,2022,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(136,NULL,2022,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(137,NULL,2022,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(138,NULL,2022,1,0,'Servicio Doméstico',252564.84,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(139,NULL,2022,1,0,'Donaciones',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(140,NULL,2022,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(141,NULL,2022,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(142,NULL,2022,1,0,'Alquileres',252564.84,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(143,NULL,2022,0,1,'Conyuge',235457.25,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(144,NULL,2022,0,1,'Hijo Menor 18 años',118741.97,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(145,NULL,2022,0,1,'Ganancia No Imponible',252564.84,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(146,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',1212311.24,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(147,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',505129.68,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(148,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',631412.10,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(149,NULL,2022,0,1,'Hijo Incapacitado',237483.94,1,'2022-01-11 14:08:06','2022-01-11 14:08:06',NULL),(150,NULL,2021,1,0,'Alquileres',167678.40,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ganan_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_tipos_op`
--

DROP TABLE IF EXISTS `ganan_tipos_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_tipos_op` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_tipos_op`
--

LOCK TABLES `ganan_tipos_op` WRITE;
/*!40000 ALTER TABLE `ganan_tipos_op` DISABLE KEYS */;
INSERT INTO `ganan_tipos_op` VALUES (1,NULL,'Gravado',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,NULL,'Exento',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_tipos_op` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iibb_perceptions`
--

DROP TABLE IF EXISTS `iibb_perceptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iibb_perceptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iibb_perceptions`
--

LOCK TABLES `iibb_perceptions` WRITE;
/*!40000 ALTER TABLE `iibb_perceptions` DISABLE KEYS */;
INSERT INTO `iibb_perceptions` VALUES (1,NULL,NULL,NULL,'IIBB CABA','IIBBCABA'),(2,NULL,NULL,NULL,'IIBB Bs. As.','IIBBBSAS'),(3,NULL,NULL,NULL,'Percepcion IIBB Tucuman','IIBBTucuman'),(4,NULL,NULL,NULL,'Perc IIBB Misiones','IIBBMisiones'),(5,NULL,NULL,NULL,'Perc IIBB Cordoba','IIBBCba'),(6,NULL,NULL,NULL,'Pec IIBB La Pampa','IIBB La Pampa'),(7,NULL,NULL,NULL,'Perc IIBB Rio Negro','IIBB Rio Negro'),(8,NULL,NULL,NULL,'Perc IIBB Corrientes','IIIBB Corrientes'),(9,NULL,NULL,NULL,'Perc IIBB Santiago del Estero','IIBBSantiago');
/*!40000 ALTER TABLE `iibb_perceptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_combos`
--

DROP TABLE IF EXISTS `inv_combos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_combos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inv_product_combo_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `cantidades` int(11) NOT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_combos_inv_product_combo_id_foreign` (`inv_product_combo_id`),
  KEY `inv_combos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_combos_inv_product_combo_id_foreign` FOREIGN KEY (`inv_product_combo_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_combos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_combos`
--

LOCK TABLES `inv_combos` WRITE;
/*!40000 ALTER TABLE `inv_combos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_combos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock`
--

DROP TABLE IF EXISTS `inv_control_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_control_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock`
--

LOCK TABLES `inv_control_stock` WRITE;
/*!40000 ALTER TABLE `inv_control_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock_detail`
--

DROP TABLE IF EXISTS `inv_control_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_control_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `stock_actual` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_real` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_control_stock_detail_inv_control_stock_id_foreign` (`inv_control_stock_id`),
  KEY `inv_control_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_control_stock_detail_inv_control_stock_id_foreign` FOREIGN KEY (`inv_control_stock_id`) REFERENCES `inv_control_stock` (`id`),
  CONSTRAINT `inv_control_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_control_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock_detail`
--

LOCK TABLES `inv_control_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_control_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores`
--

DROP TABLE IF EXISTS `inv_indicadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orden` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores`
--

LOCK TABLES `inv_indicadores` WRITE;
/*!40000 ALTER TABLE `inv_indicadores` DISABLE KEYS */;
INSERT INTO `inv_indicadores` VALUES (1,NULL,'Datos Grales','datos_grales','card_info',5,1,NULL,'2022-05-19 22:15:46',NULL),(2,NULL,'Impuestos Asociados','impuestos_asociados','card_info',6,1,NULL,'2022-05-19 22:15:46',NULL),(3,NULL,'Informacion de Liquidacion','informacion_de_liquidacion','card_info',7,1,NULL,'2022-05-19 22:15:46',NULL),(4,NULL,'Cantidad Ventas del Mes','cantidad_ventas_del_mes','card',1,1,NULL,'2022-05-19 22:15:46',NULL),(5,NULL,'Total Facturado En El Mes','total_facturado_en_el_mes','card',2,1,NULL,'2022-05-19 22:15:46',NULL),(6,NULL,'Total Facturado En El Dia','total_facturado_en_el_dia','card',3,1,NULL,'2022-05-19 22:15:46',NULL),(7,NULL,'Total Facturado En El Año','total_facturado_en_el_anio','card',4,1,NULL,'2022-05-19 22:15:46',NULL),(8,NULL,'Facturacion Mensual','facturacion_mensual','grafico',8,1,NULL,'2022-05-19 22:15:46',NULL),(9,NULL,'Proyeccion de Ganancias','proyeccion_de_ganancias','tabla',9,1,NULL,'2022-05-19 22:15:46',NULL),(10,NULL,'Posicion IVA','posicion_de_iva','tabla',10,1,NULL,'2022-05-19 22:15:46',NULL);
/*!40000 ALTER TABLE `inv_indicadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores_persons`
--

DROP TABLE IF EXISTS `inv_indicadores_persons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores_persons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_indicador_id` bigint(20) unsigned NOT NULL,
  `objetivo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_indicadores_persons_person_id_foreign` (`person_id`),
  KEY `inv_indicadores_persons_inv_indicador_id_foreign` (`inv_indicador_id`),
  CONSTRAINT `inv_indicadores_persons_inv_indicador_id_foreign` FOREIGN KEY (`inv_indicador_id`) REFERENCES `inv_indicadores` (`id`),
  CONSTRAINT `inv_indicadores_persons_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores_persons`
--

LOCK TABLES `inv_indicadores_persons` WRITE;
/*!40000 ALTER TABLE `inv_indicadores_persons` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_indicadores_persons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ing_egr_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock`
--

LOCK TABLES `inv_ing_egr_stock` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock_detail`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_ing_egr_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `sumar1_restar0` tinyint(1) NOT NULL DEFAULT '1',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` (`inv_ing_egr_stock_id`),
  KEY `inv_ing_egr_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` FOREIGN KEY (`inv_ing_egr_stock_id`) REFERENCES `inv_ing_egr_stock` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock_detail`
--

LOCK TABLES `inv_ing_egr_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_lista_de_precios`
--

DROP TABLE IF EXISTS `inv_lista_de_precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_lista_de_precios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `porcentaje_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_lista_de_precios_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_lista_de_precios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_lista_de_precios`
--

LOCK TABLES `inv_lista_de_precios` WRITE;
/*!40000 ALTER TABLE `inv_lista_de_precios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_lista_de_precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_config_cc`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_config_cc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_config_cc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `horas_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `horas_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `asiento_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_config_cc_person_id_foreign` (`person_id`),
  KEY `hcc_id_foreign` (`horas_conta_plan_cuenta_id`),
  KEY `gcc_id_foreign` (`gastos_conta_plan_cuenta_id`),
  KEY `pcc_id_foreign` (`productos_conta_plan_cuenta_id`),
  KEY `h_contra_cc_id_foreign` (`horas_contra_conta_plan_cuenta_id`),
  KEY `g_contra_cc_id_foreign` (`gastos_contra_conta_plan_cuenta_id`),
  KEY `p_contra_cc_id_foreign` (`productos_contra_conta_plan_cuenta_id`),
  KEY `ahcc_id_foreign` (`asiento_horas_cpc_id`),
  KEY `agcc_id_foreign` (`asiento_gastos_cpc_id`),
  KEY `apcc_id_foreign` (`asiento_productos_cpc_id`),
  KEY `ah_contra_cc_id_foreign` (`asiento_contra_horas_cpc_id`),
  KEY `ag_contra_cc_id_foreign` (`asiento_contra_gastos_cpc_id`),
  KEY `ap_contra_cc_id_foreign` (`asiento_contra_productos_cpc_id`),
  CONSTRAINT `ag_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `agcc_id_foreign` FOREIGN KEY (`asiento_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ah_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ahcc_id_foreign` FOREIGN KEY (`asiento_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ap_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `apcc_id_foreign` FOREIGN KEY (`asiento_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `g_contra_cc_id_foreign` FOREIGN KEY (`gastos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `gcc_id_foreign` FOREIGN KEY (`gastos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `h_contra_cc_id_foreign` FOREIGN KEY (`horas_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `hcc_id_foreign` FOREIGN KEY (`horas_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `inv_orden_trabajo_config_cc_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `p_contra_cc_id_foreign` FOREIGN KEY (`productos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `pcc_id_foreign` FOREIGN KEY (`productos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_config_cc`
--

LOCK TABLES `inv_orden_trabajo_config_cc` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_facturada`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_facturada_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_facturada`
--

LOCK TABLES `inv_orden_trabajo_facturada` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:15:16',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_gastos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajo_gastos_receipt_id_foreign` (`receipt_id`),
  KEY `i_o_t_g_t_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `i_o_t_g_t_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos`
--

LOCK TABLES `inv_orden_trabajo_gastos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_gastos_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos_tipos`
--

LOCK TABLES `inv_orden_trabajo_gastos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:15:16',
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_horas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas`
--

LOCK TABLES `inv_orden_trabajo_horas` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_horas_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_tipos`
--

LOCK TABLES `inv_orden_trabajo_horas_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_product