-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-25206330-8
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-03-29 21:09:08','Actividad Generica 1','000001',NULL),(2,NULL,'2021-03-29 21:09:08','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL),('2023-11','2023-11',2023,11,'2023-11-01','2023-11-30',2816.0628,'2025-07-08 17:01:44','2025-07-08 17:01:44',NULL),('2023-12','2023-12',2023,12,'2023-12-01','2023-12-31',3533.1922,'2025-07-08 17:02:12','2025-07-08 17:02:12',NULL),('2024-1','2024-01',2024,1,'2024-01-01','2024-01-31',4261.5324,'2025-08-07 15:51:59','2025-08-07 15:51:59',NULL),('2024-2','2024-02',2024,2,'2024-02-01','2024-02-28',4825.7881,'2025-08-07 15:58:55','2025-08-07 15:58:55',NULL),('2024-3','2024-03',2024,3,'2024-03-01','2024-03-31',5327.0929,'2025-08-07 15:59:19','2025-08-07 15:59:19',NULL),('2024-4','2024-04',2024,4,'2024-04-01','2024-04-30',5830.2271,'2025-08-07 15:59:46','2025-08-07 15:59:46',NULL),('2024-5','2024-05',2024,5,'2024-05-01','2024-05-31',6073.7165,'2025-08-07 16:00:01','2025-08-07 16:00:01',NULL),('2024-6','2024-06',2024,6,'2024-06-01','2024-06-30',6351.7145,'2025-08-07 16:00:44','2025-08-07 16:00:44',NULL),('2024-7','2024-07',2024,7,'2024-07-01','2024-07-31',6607.7479,'2025-08-07 16:01:03','2025-08-07 16:01:03',NULL),('2024-8','2024-08',2024,8,'2024-08-01','2024-08-31',6883.4412,'2025-08-07 16:01:17','2025-08-07 16:01:17',NULL),('2024-9','2024-09',2024,9,'2024-09-01','2024-09-30',7122.2421,'2025-08-07 16:01:33','2025-08-07 16:01:33',NULL),('2024-10','2024-10',2024,10,'2024-10-01','2024-10-31',7313.9452,'2025-08-07 16:01:47','2025-08-07 16:01:47',NULL),('2024-11','2024-11',2024,11,'2024-11-01','2024-11-30',7491.4314,'2025-08-07 16:02:03','2025-08-07 16:02:03',NULL),('2024-12','2024-12',2024,12,'2024-12-01','2024-12-31',7694.0075,'2025-08-07 16:02:20','2025-08-07 16:02:20',NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Luciana2020',NULL,1,40720,'2021-03-31'),(2,NULL,'Luciana2020',NULL,1,40720,'2021-04-01'),(3,NULL,'Luciana2020',NULL,1,40720,'2021-04-16'),(4,NULL,'Luciana2020',NULL,1,40720,'2021-04-16'),(5,NULL,'Luciana2020',NULL,1,40720,'2021-04-20'),(6,NULL,'Luciana2020',NULL,1,40720,'2021-04-20'),(7,NULL,'Luciana2020',NULL,1,40720,'2021-04-20'),(8,'clave sebastián','Afip202020',NULL,1,40721,'2021-10-16'),(9,'clave sebastián','Afip202020',NULL,1,40721,'2021-10-16'),(10,'clave sebastián','Afip202020',NULL,1,40721,'2021-10-16'),(11,'clave sebastián','Afip202020',NULL,1,40721,'2021-10-16'),(12,'clave sebastián','Afip202020',NULL,1,40721,'2021-10-16'),(13,'clave sebastián','Afip202020',NULL,1,40721,'2022-03-07'),(14,NULL,'1928maricruZ','maricruz pregot',1,41336,'2022-04-19'),(15,NULL,'1928maricruZ','maricruz pregot',1,41336,'2022-04-23'),(16,NULL,'1928maricruZ','maricruz pregot',1,41336,'2022-05-04'),(17,NULL,'1928maricruZ','maricruz pregot',1,41336,'2023-01-16'),(18,'clave sebastián','Afip202020',NULL,1,40721,'2023-06-08'),(19,'clave sebastián','Afip202020',NULL,1,40721,'2023-06-08'),(20,NULL,'Agustina2024*',NULL,1,42000,'2024-11-26'),(21,NULL,'Perla27loca',NULL,1,42052,'2024-12-12'),(22,NULL,'Agustina2024*',NULL,1,42000,'2024-12-12'),(23,NULL,'Perla27loca',NULL,1,42052,'2025-03-06'),(24,NULL,'Perla27loca',NULL,1,42052,'2025-10-06'),(25,NULL,'Perla27loca',NULL,1,42052,'2025-11-05');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'luciana@frogsmall.com','3416029102','',1,40720,'2021-03-31'),(2,'luciana@frogsmall.com','3416029102','',1,40720,'2021-04-01'),(3,'luciana@frogsmall.com','3416029102','',1,40720,'2021-04-16'),(4,'luciana@frogsmall.com','3416029102','',1,40720,'2021-04-16'),(5,'luciana@frogsmall.com','3416029102','',1,40720,'2021-04-20'),(6,'luciana@frogsmall.com','3416029102','',1,40720,'2021-04-20'),(7,'luciana@frogsmall.com','3416029102','',1,40720,'2021-04-20'),(8,'seba.ardanza@gmail.com','3416203000','',1,40721,'2021-10-16'),(9,'seba.ardanza@gmail.com','3416203000','',1,40721,'2021-10-16'),(10,'seba.ardanza@gmail.com','3416203000','',1,40721,'2021-10-16'),(11,'seba.ardanza@gmail.com','3416203000','',1,40721,'2021-10-16'),(12,'seba.ardanza@gmail.com','3416203000','',1,40721,'2021-10-16'),(13,'seba.ardanza@gmail.com','3416203000','',1,40721,'2022-03-07'),(14,'seba.ardanza@gmail.com','3416203000','',1,40721,'2023-06-08'),(15,'seba.ardanza@gmail.com','3416203000','',1,40721,'2023-06-08');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27276 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,3661,40720,1532,1,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-03-31',NULL,120552.20,NULL,NULL,1,'2021-04-16 17:45:48','2021-04-16 17:45:48',NULL),(2,3661,40720,1532,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',378.37,NULL,NULL,1,'2021-04-19 20:34:15','2021-04-19 20:34:15',NULL),(3,3661,40720,1532,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',8530.62,NULL,NULL,1,'2021-04-19 20:34:15','2021-04-19 20:34:15',NULL),(4,3661,40720,1532,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2800.21,NULL,NULL,1,'2021-04-19 20:34:15','2021-04-19 20:34:15',NULL),(5,3661,40720,1532,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1210.00,NULL,NULL,1,'2021-04-19 20:34:15','2021-04-19 20:34:15',NULL),(6,3661,40720,1532,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2904.00,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(7,3661,40720,1532,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2904.00,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(8,3661,40720,1532,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',4123.32,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(9,3661,40720,1532,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1142.49,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(10,3661,40720,1532,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',4053.23,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(11,3661,40720,1532,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',24357.55,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(12,3661,40720,1532,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',848.77,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(13,3661,40720,1532,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',577.00,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(14,3661,40720,1532,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2165.67,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(15,3661,40720,1532,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',14272.35,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(16,3661,40720,1532,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',4620.05,NULL,NULL,1,'2021-04-19 20:34:16','2021-04-19 20:34:16',NULL),(17,3661,40720,1532,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2921.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(18,3661,40720,1532,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1094.49,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(19,3661,40720,1532,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1404.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(20,3661,40720,1532,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1076.50,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(21,3661,40720,1532,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',7930.34,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46');
INSERT INTO `balance_libro` VALUES (22,3661,40720,1532,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2380.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(23,3661,40720,1532,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1003.01,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(24,3661,40720,1532,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3729.93,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(25,3661,40720,1532,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',14697.87,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(26,3661,40720,1532,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4488.01,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(27,3661,40720,1532,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4502.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(28,3661,40720,1532,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1126.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(29,3661,40720,1532,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1126.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(30,3661,40720,1532,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8455.48,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(31,3661,40720,1532,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2983.99,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(32,3661,40720,1532,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2456.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(33,3661,40720,1532,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1254.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(34,3661,40720,1532,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1790.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(35,3661,40720,1532,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1950.52,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(36,3661,40720,1532,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',828.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(37,3661,40720,1532,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2420.00,NULL,NULL,1,'2021-04-19 20:50:12','2021-04-19 21:00:46','2021-04-19 21:00:46'),(38,3661,40720,1532,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3512.00,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(39,3661,40720,1532,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1850.01,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(40,3661,40720,1532,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2342.00,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(41,3661,40720,1532,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8277.61,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46');
INSERT INTO `balance_libro` VALUES (42,3661,40720,1532,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',7359.22,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(43,3661,40720,1532,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',13723.82,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(44,3661,40720,1532,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3512.99,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(45,3661,40720,1532,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3372.00,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(46,3661,40720,1532,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6130.01,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(47,3661,40720,1532,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1699.00,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(48,3661,40720,1532,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2092.01,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(49,3661,40720,1532,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1148.00,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(50,3661,40720,1532,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',5104.00,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(51,3661,40720,1532,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3136.01,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(52,3661,40720,1532,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2092.01,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(53,3661,40720,1532,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2786.00,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(54,3661,40720,1532,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4120.00,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(55,3661,40720,1532,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1070.00,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(56,3661,40720,1532,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2988.01,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:46','2021-04-19 21:00:46'),(57,3661,40720,1532,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1870.01,NULL,NULL,1,'2021-04-19 20:50:13','2021-04-19 21:00:06','2021-04-19 21:00:06'),(58,3661,40720,1532,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2921.00,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(59,3661,40720,1532,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1094.49,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(60,3661,40720,1532,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1404.00,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(61,3661,40720,1532,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1076.50,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL);
INSERT INTO `balance_libro` VALUES (62,3661,40720,1532,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',7930.34,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(63,3661,40720,1532,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2380.00,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(64,3661,40720,1532,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1003.01,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(65,3661,40720,1532,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3729.93,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(66,3661,40720,1532,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',14697.87,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(67,3661,40720,1532,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4488.01,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(68,3661,40720,1532,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4502.00,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(69,3661,40720,1532,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1126.00,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(70,3661,40720,1532,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1126.00,NULL,NULL,1,'2021-04-20 13:24:57','2021-04-20 13:24:57',NULL),(71,3661,40720,1532,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8455.48,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(72,3661,40720,1532,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2983.99,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(73,3661,40720,1532,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2456.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(74,3661,40720,1532,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1254.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(75,3661,40720,1532,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1790.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(76,3661,40720,1532,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1950.52,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(77,3661,40720,1532,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',828.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(78,3661,40720,1532,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2420.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(79,3661,40720,1532,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3512.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(80,3661,40720,1532,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1850.01,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(81,3661,40720,1532,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2342.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(82,3661,40720,1532,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8277.61,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL);
INSERT INTO `balance_libro` VALUES (83,3661,40720,1532,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',7359.22,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(84,3661,40720,1532,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',13723.82,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(85,3661,40720,1532,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3512.99,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(86,3661,40720,1532,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3372.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(87,3661,40720,1532,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6130.01,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(88,3661,40720,1532,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1699.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(89,3661,40720,1532,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2092.01,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(90,3661,40720,1532,2,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1148.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(91,3661,40720,1532,2,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',5104.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(92,3661,40720,1532,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3136.01,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(93,3661,40720,1532,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2092.01,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(94,3661,40720,1532,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2786.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(95,3661,40720,1532,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4120.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(96,3661,40720,1532,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1070.00,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(97,3661,40720,1532,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2988.01,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(98,3661,40720,1532,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1870.01,NULL,NULL,1,'2021-04-20 13:24:58','2021-04-20 13:24:58',NULL),(99,3661,40720,1532,20,98,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,98,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',9880.86,'',NULL,1,'2021-04-20 16:41:14','2021-04-20 16:41:14',NULL),(100,3661,40720,1532,20,99,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,99,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',14697.83,'',NULL,1,'2021-04-20 16:41:59','2021-04-20 16:41:59',NULL),(101,3661,40720,1532,20,100,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,100,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',3729.93,'',NULL,1,'2021-04-20 16:43:02','2021-04-20 16:43:02',NULL),(102,3661,40720,1532,20,101,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,101,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',8455.48,'',NULL,1,'2021-04-20 16:43:45','2021-04-20 16:43:45',NULL),(103,3661,40720,1532,20,102,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,102,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',8277.61,'',NULL,1,'2021-04-20 16:44:27','2021-04-20 16:44:27',NULL);
INSERT INTO `balance_libro` VALUES (104,3661,40720,1532,20,103,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,103,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7359.22,'',NULL,1,'2021-04-20 16:45:15','2021-04-20 16:45:15',NULL),(105,3661,40720,1532,20,104,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,104,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',13723.82,'',NULL,1,'2021-04-20 16:46:27','2021-04-20 16:46:27',NULL),(106,3661,40720,1532,21,105,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,105,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',11074.66,'',NULL,1,'2021-04-20 16:48:38','2021-04-20 16:48:38',NULL),(107,3661,40720,1532,21,106,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,106,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',14272.35,'',NULL,1,'2021-04-20 16:49:14','2021-04-20 16:49:14',NULL),(108,3661,40720,1531,14,108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',34000.00,'Asiento de Capital',NULL,1,'2021-04-20 18:49:11','2021-04-20 18:49:11',NULL),(109,3661,40720,1531,22,10,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,10,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',34000.00,'',NULL,1,'2021-04-20 19:02:00','2021-04-20 19:02:31','2021-04-20 19:02:31'),(110,3661,40720,1531,22,11,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,11,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',34000.00,'',NULL,1,'2021-04-20 19:03:23','2021-04-20 19:03:23',NULL),(111,3661,40722,4559,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',125051.20,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(112,3661,40722,4559,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',38200.00,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(113,3661,40722,4559,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',36192.24,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(114,3661,40722,4559,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',57192.24,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(115,3661,40722,4559,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',53240.00,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(116,3661,40722,4559,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',63111.40,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(117,3661,40722,4559,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',18890.00,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(118,3661,40722,4559,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',2165.00,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(119,3661,40722,4559,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',2265.00,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(120,3661,40722,4559,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',49841.65,NULL,NULL,1,'2021-04-21 14:53:06','2021-04-21 14:53:06',NULL),(121,3661,40722,4559,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',57510.00,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(122,3661,40722,4559,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',56012.00,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(123,3661,40722,4559,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',12550.00,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(124,3661,40722,4559,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',109616.67,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL);
INSERT INTO `balance_libro` VALUES (125,3661,40722,4559,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',2265.00,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(126,3661,40722,4559,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',25982.69,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(127,3661,40722,4559,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',41632.26,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(128,3661,40722,4559,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',109201.79,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(129,3661,40722,4559,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',17054.69,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(130,3661,40722,4559,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',16802.28,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(131,3661,40722,4559,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',34536.33,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(132,3661,40722,4559,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',2265.00,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(133,3661,40722,4559,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',2265.00,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(134,3661,40722,4559,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',47652.68,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(135,3661,40722,4559,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',42795.05,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(136,3661,40722,4559,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',16491.00,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(137,3661,40722,4559,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',53993.90,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(138,3661,40722,4559,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',125530.00,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(139,3661,40722,4559,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',96786.37,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(140,3661,40722,4559,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',374270.00,NULL,NULL,1,'2021-04-21 14:53:07','2021-04-21 14:53:07',NULL),(141,3661,40722,4559,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1348.91,NULL,NULL,1,'2021-04-21 14:55:43','2021-04-21 14:55:43',NULL),(142,3661,40722,4559,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1900.00,NULL,NULL,1,'2021-04-21 14:55:43','2021-04-21 14:55:43',NULL),(143,3661,40722,4559,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',6063.00,NULL,NULL,1,'2021-04-21 14:55:43','2021-04-21 14:55:43',NULL),(144,3661,40722,4559,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',45260.00,NULL,NULL,1,'2021-04-21 14:55:43','2021-04-21 14:55:43',NULL),(145,3661,40722,4559,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',371.70,NULL,NULL,1,'2021-04-21 14:55:44','2021-04-21 14:55:44',NULL);
INSERT INTO `balance_libro` VALUES (146,3661,40722,4559,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',2428.80,NULL,NULL,1,'2021-04-21 14:55:44','2021-04-21 14:55:44',NULL),(147,3661,40723,6074,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1815.00,NULL,NULL,1,'2021-04-21 15:46:56','2021-04-21 15:46:56',NULL),(148,3661,40723,6074,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',10248.90,NULL,NULL,1,'2021-04-21 15:46:56','2021-04-21 15:46:56',NULL),(149,3661,40723,6074,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',10248.90,NULL,NULL,1,'2021-04-21 15:46:57','2021-04-21 15:46:57',NULL),(150,3661,40723,6074,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',10248.90,NULL,NULL,1,'2021-04-21 15:46:57','2021-04-21 15:46:57',NULL),(151,3661,40723,6074,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',5445.00,NULL,NULL,1,'2021-04-21 15:46:57','2021-04-21 15:46:57',NULL),(152,3661,40723,6074,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',4392.00,NULL,NULL,1,'2021-04-21 15:46:57','2021-04-21 15:46:57',NULL),(153,3661,40723,6074,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',11419.20,NULL,NULL,1,'2021-04-21 15:46:57','2021-04-21 15:46:57',NULL),(154,3661,40723,6074,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',43694.92,NULL,NULL,1,'2021-04-21 15:46:57','2021-04-21 15:46:57',NULL),(155,3661,40723,6074,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1210.00,NULL,NULL,1,'2021-04-21 15:46:57','2021-04-21 15:46:57',NULL),(156,3661,40723,6074,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1210.00,NULL,NULL,1,'2021-04-21 15:46:57','2021-04-21 15:46:57',NULL),(157,3661,40723,6074,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',10248.90,NULL,NULL,1,'2021-04-21 15:46:57','2021-04-21 15:46:57',NULL),(158,3661,40723,6074,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',100000.00,NULL,NULL,1,'2021-04-21 15:47:28','2021-04-21 15:47:28',NULL),(159,3661,40723,6074,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',5799.52,NULL,NULL,1,'2021-04-21 15:47:28','2021-04-21 15:58:08','2021-04-21 15:58:08'),(160,3661,40723,6074,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',1038.16,NULL,NULL,1,'2021-04-21 15:47:28','2021-04-21 15:47:28',NULL),(161,3661,40723,6074,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',4688.28,NULL,NULL,1,'2021-04-21 15:47:28','2021-04-21 15:47:28',NULL),(162,3661,40723,6074,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',20000.00,NULL,NULL,1,'2021-04-21 15:47:28','2021-04-21 15:58:55','2021-04-21 15:58:55'),(163,3661,40723,6074,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',18074.00,NULL,NULL,1,'2021-04-21 15:47:28','2021-04-21 15:47:28',NULL),(164,3661,40723,6074,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',5799.52,NULL,NULL,1,'2021-04-21 15:58:08','2021-04-21 15:58:08',NULL),(165,3661,40723,6074,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',20000.00,NULL,NULL,1,'2021-04-21 15:58:55','2021-04-21 15:58:55',NULL),(166,3661,40720,1532,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',39180.00,NULL,NULL,1,'2021-04-21 19:48:34','2021-04-21 20:39:47','2021-04-21 20:39:47');
INSERT INTO `balance_libro` VALUES (167,3661,40720,1532,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',58138.00,NULL,NULL,1,'2021-04-21 19:48:34','2021-04-21 20:39:24','2021-04-21 20:39:24'),(168,3661,40720,1532,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',4824.21,NULL,NULL,1,'2021-04-21 19:48:34','2021-04-21 20:39:00','2021-04-21 20:39:00'),(169,3661,40720,1532,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',4102.17,NULL,NULL,1,'2021-04-21 19:48:34','2021-04-21 20:38:25','2021-04-21 20:38:25'),(170,3661,40720,1532,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',146195.83,NULL,NULL,1,'2021-04-21 19:48:34','2021-04-21 20:31:30','2021-04-21 20:31:30'),(171,3661,40720,1532,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1247.00,NULL,NULL,1,'2021-04-21 19:48:34','2021-04-21 20:35:00','2021-04-21 20:35:00'),(172,3661,40720,1532,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',2610.95,NULL,NULL,1,'2021-04-21 19:48:34','2021-04-21 20:34:13','2021-04-21 20:34:13'),(173,3661,40720,1532,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',830.00,NULL,NULL,1,'2021-04-21 19:48:35','2021-04-21 20:33:11','2021-04-21 20:33:11'),(174,3661,40720,1532,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',52184.76,NULL,NULL,1,'2021-04-21 19:48:35','2021-04-21 20:29:24','2021-04-21 20:29:24'),(175,3661,40720,1531,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',2363.74,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(176,3661,40720,1531,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',4040.24,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(177,3661,40720,1531,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',3876.25,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(178,3661,40720,1531,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',14879.37,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(179,3661,40720,1531,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',704.22,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(180,3661,40720,1531,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',6722.16,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(181,3661,40720,1531,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',17581.90,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(182,3661,40720,1531,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',14224.16,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(183,3661,40720,1531,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',5094.10,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(184,3661,40720,1531,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',10969.86,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(185,3661,40720,1531,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6268.49,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(186,3661,40720,1531,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6268.49,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL);
INSERT INTO `balance_libro` VALUES (187,3661,40720,1531,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9576.24,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(188,3661,40720,1531,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',10969.86,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(189,3661,40720,1531,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6268.49,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(190,3661,40720,1531,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',23074.17,NULL,NULL,1,'2021-04-21 19:52:43','2021-04-21 19:52:43',NULL),(191,3661,40720,1531,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1635.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(192,3661,40720,1531,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',261.25,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(193,3661,40720,1531,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1756.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(194,3661,40720,1531,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1391.50,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(195,3661,40720,1531,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1800.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(196,3661,40720,1531,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1237.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(197,3661,40720,1531,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',451.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(198,3661,40720,1531,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',2183.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(199,3661,40720,1531,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',1618.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(200,3661,40720,1531,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',2251.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(201,3661,40720,1531,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1170.50,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(202,3661,40720,1531,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1131.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(203,3661,40720,1531,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',1373.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(204,3661,40720,1531,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',1406.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(205,3661,40720,1531,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2279.00,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(206,3661,40720,1531,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',1839.01,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(207,3661,40720,1531,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',11896.01,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL);
INSERT INTO `balance_libro` VALUES (208,3661,40720,1531,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',2909.01,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(209,3661,40720,1531,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',501.50,NULL,NULL,1,'2021-04-21 19:54:13','2021-04-21 19:54:13',NULL),(210,3661,40720,1531,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',2156.00,NULL,NULL,1,'2021-04-21 19:54:14','2021-04-21 19:54:14',NULL),(211,3661,40720,1530,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',10320.20,NULL,NULL,1,'2021-04-21 20:06:28','2021-04-21 20:06:28',NULL),(212,3661,40720,1530,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',1.00,NULL,NULL,1,'2021-04-21 20:06:28','2021-04-21 20:06:28',NULL),(213,3661,40720,1530,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',10266.00,NULL,NULL,1,'2021-04-21 20:06:28','2021-04-21 20:06:28',NULL),(214,3661,40720,1530,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',901.45,NULL,NULL,1,'2021-04-21 20:06:28','2021-04-21 20:06:28',NULL),(215,3661,40720,1530,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',5776.58,NULL,NULL,1,'2021-04-21 20:06:28','2021-04-21 20:06:28',NULL),(216,3661,40720,1530,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',907.50,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(217,3661,40720,1530,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1536.00,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(218,3661,40720,1530,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1280.00,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(219,3661,40720,1530,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1525.00,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(220,3661,40720,1530,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1984.00,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(221,3661,40720,1530,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',4778.80,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(222,3661,40720,1530,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1295.45,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(223,3661,40720,1530,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',742.00,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(224,3661,40720,1530,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',1137.00,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(225,3661,40720,1530,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',1379.40,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(226,3661,40720,1530,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',1036.75,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(227,3661,40720,1530,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2413.80,NULL,NULL,1,'2021-04-21 20:07:19','2021-04-21 20:07:19',NULL),(228,3661,40720,1530,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',1374.00,NULL,NULL,1,'2021-04-21 20:07:20','2021-04-21 20:07:20',NULL);
INSERT INTO `balance_libro` VALUES (229,3661,40720,1530,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',1241.00,NULL,NULL,1,'2021-04-21 20:07:20','2021-04-21 20:07:20',NULL),(230,3661,40720,1531,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',52184.76,NULL,NULL,1,'2021-04-21 20:29:24','2021-04-21 20:29:24',NULL),(231,3661,40720,1531,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',146195.83,NULL,NULL,1,'2021-04-21 20:31:30','2021-04-21 20:31:30',NULL),(232,3661,40720,1532,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',830.00,NULL,NULL,1,'2021-04-21 20:33:11','2021-04-21 20:33:28','2021-04-21 20:33:28'),(233,3661,40720,1532,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',830.00,NULL,NULL,1,'2021-04-21 20:33:28','2021-04-21 20:34:27','2021-04-21 20:34:27'),(234,3661,40720,1531,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',2610.95,NULL,NULL,1,'2021-04-21 20:34:13','2021-04-21 20:34:13',NULL),(235,3661,40720,1531,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',830.00,NULL,NULL,1,'2021-04-21 20:34:27','2021-04-21 20:34:27',NULL),(236,3661,40720,1531,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1247.00,NULL,NULL,1,'2021-04-21 20:35:00','2021-04-21 20:35:00',NULL),(237,3661,40720,1531,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',4102.17,NULL,NULL,1,'2021-04-21 20:38:25','2021-04-21 20:38:25',NULL),(238,3661,40720,1531,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',4824.21,NULL,NULL,1,'2021-04-21 20:39:00','2021-04-21 20:39:00',NULL),(239,3661,40720,1531,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',58138.00,NULL,NULL,1,'2021-04-21 20:39:24','2021-04-21 20:39:24',NULL),(240,3661,40720,1531,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',39180.01,NULL,NULL,1,'2021-04-21 20:39:47','2021-04-21 20:39:47',NULL),(241,3661,40723,6075,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',10248.90,NULL,NULL,1,'2021-05-12 20:15:53','2021-05-12 20:15:53',NULL),(242,3661,40723,6075,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',10248.90,NULL,NULL,1,'2021-05-12 20:15:53','2021-05-12 20:15:53',NULL),(243,3661,40723,6075,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',10248.90,NULL,NULL,1,'2021-05-12 20:15:53','2021-05-12 20:15:53',NULL),(244,3661,40723,6075,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',58603.93,NULL,NULL,1,'2021-05-12 20:15:53','2021-05-12 20:15:53',NULL),(245,3661,40723,6075,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2178.00,NULL,NULL,1,'2021-05-12 20:15:53','2021-05-12 20:15:53',NULL),(246,3661,40723,6075,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',20000.00,NULL,NULL,1,'2021-05-12 20:17:06','2021-05-12 20:17:06',NULL),(247,3661,40723,6075,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',17523.35,NULL,NULL,1,'2021-05-12 20:17:06','2021-05-12 20:17:06',NULL),(248,3661,40723,6075,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',14947.30,NULL,NULL,1,'2021-05-12 20:17:06','2021-05-12 20:17:06',NULL),(249,3661,40723,6075,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',26952.94,NULL,NULL,1,'2021-05-12 20:17:06','2021-05-12 20:17:06',NULL);
INSERT INTO `balance_libro` VALUES (250,3661,40723,6075,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',5202.00,NULL,NULL,1,'2021-05-12 20:17:06','2021-05-12 20:17:06',NULL),(251,3661,40723,6075,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',4084.17,NULL,NULL,1,'2021-05-12 20:17:06','2021-05-12 20:17:06',NULL),(252,3661,40723,6075,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',100000.00,NULL,NULL,1,'2021-05-12 20:17:06','2021-05-12 20:17:06',NULL),(253,3661,40723,6075,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',17634.65,NULL,NULL,1,'2021-05-12 20:17:06','2021-05-12 20:17:06',NULL),(254,3661,40722,4560,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',40784.90,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(255,3661,40722,4560,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2265.00,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(256,3661,40722,4560,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',8560.00,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(257,3661,40722,4560,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2265.00,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(258,3661,40722,4560,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',88127.01,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(259,3661,40722,4560,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',39930.00,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(260,3661,40722,4560,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',48863.18,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(261,3661,40722,4560,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',92644.37,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(262,3661,40722,4560,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',45123.34,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(263,3661,40722,4560,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',38807.03,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(264,3661,40722,4560,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',34645.45,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(265,3661,40722,4560,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',4379.56,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(266,3661,40722,4560,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4579.56,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(267,3661,40722,4560,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',13743.91,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(268,3661,40722,4560,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',36192.24,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(269,3661,40722,4560,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',27593.01,NULL,NULL,1,'2021-05-12 20:31:10','2021-05-12 20:31:10',NULL),(270,3661,40722,4560,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',40141.44,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL);
INSERT INTO `balance_libro` VALUES (271,3661,40722,4560,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',41748.51,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(272,3661,40722,4560,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',31235.03,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(273,3661,40722,4560,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',32430.69,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(274,3661,40722,4560,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',30709.28,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(275,3661,40722,4560,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',4930.00,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(276,3661,40722,4560,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',21300.00,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(277,3661,40722,4560,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',19436.17,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(278,3661,40722,4560,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',45782.90,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(279,3661,40722,4560,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',60886.73,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(280,3661,40722,4560,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',20257.64,NULL,NULL,1,'2021-05-12 20:31:11','2021-05-12 20:31:11',NULL),(281,3661,40722,4560,3,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1620.09,NULL,NULL,1,'2021-05-12 20:32:14','2021-05-12 20:32:14',NULL),(282,3661,40722,4560,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1900.00,NULL,NULL,1,'2021-05-12 20:32:14','2021-05-12 20:32:14',NULL),(283,3661,40722,4558,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',2165.00,NULL,NULL,1,'2021-05-12 20:34:31','2021-05-12 20:34:31',NULL),(284,3661,40722,4558,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',15013.60,NULL,NULL,1,'2021-05-12 20:34:31','2021-05-12 20:34:31',NULL),(285,3661,40722,4558,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',20310.00,NULL,NULL,1,'2021-05-12 20:34:31','2021-05-12 20:34:31',NULL),(286,3661,40722,4558,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',197746.00,NULL,NULL,1,'2021-05-12 20:34:32','2021-05-12 20:34:32',NULL),(287,3661,40722,4558,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',37934.60,NULL,NULL,1,'2021-05-12 20:34:32','2021-05-12 20:34:32',NULL),(288,3661,40722,4558,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',31244.40,NULL,NULL,1,'2021-05-12 20:34:32','2021-05-12 20:34:32',NULL),(289,3661,40722,4558,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',119006.00,NULL,NULL,1,'2021-05-12 20:34:32','2021-05-12 20:34:32',NULL),(290,3661,40722,4558,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',6002.00,NULL,NULL,1,'2021-05-12 20:34:32','2021-05-12 20:34:32',NULL),(291,3661,40722,4558,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',2165.00,NULL,NULL,1,'2021-05-12 20:35:07','2021-05-12 20:35:07',NULL);
INSERT INTO `balance_libro` VALUES (292,3661,40722,4558,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',15013.60,NULL,NULL,1,'2021-05-12 20:35:07','2021-05-12 20:35:07',NULL),(293,3661,40722,4558,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',20310.00,NULL,NULL,1,'2021-05-12 20:35:07','2021-05-12 20:35:07',NULL),(294,3661,40722,4558,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',197746.00,NULL,NULL,1,'2021-05-12 20:35:07','2021-05-12 20:35:07',NULL),(295,3661,40722,4558,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',37934.60,NULL,NULL,1,'2021-05-12 20:35:07','2021-05-12 20:35:07',NULL),(296,3661,40722,4558,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',31244.40,NULL,NULL,1,'2021-05-12 20:35:07','2021-05-12 20:35:07',NULL),(297,3661,40722,4558,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',119006.00,NULL,NULL,1,'2021-05-12 20:35:07','2021-05-12 20:35:07',NULL),(298,3661,40722,4558,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',6002.00,NULL,NULL,1,'2021-05-12 20:35:07','2021-05-12 20:35:07',NULL),(299,3661,40722,4558,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1348.91,NULL,NULL,1,'2021-05-12 20:35:28','2021-05-12 20:35:28',NULL),(300,3661,40722,4558,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1900.00,NULL,NULL,1,'2021-05-12 20:35:28','2021-05-12 20:35:28',NULL),(301,3661,40722,4558,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1900.00,NULL,NULL,1,'2021-05-12 20:35:28','2021-05-12 20:35:28',NULL),(302,3661,40722,4557,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',29275.82,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(303,3661,40722,4557,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',59480.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(304,3661,40722,4557,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(305,3661,40722,4557,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(306,3661,40722,4557,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(307,3661,40722,4557,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(308,3661,40722,4557,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(309,3661,40722,4557,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(310,3661,40722,4557,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(311,3661,40722,4557,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(312,3661,40722,4557,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',126723.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL);
INSERT INTO `balance_libro` VALUES (313,3661,40722,4557,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(314,3661,40722,4557,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(315,3661,40722,4557,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(316,3661,40722,4557,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(317,3661,40722,4557,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(318,3661,40722,4557,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1850.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(319,3661,40722,4557,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(320,3661,40722,4557,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(321,3661,40722,4557,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(322,3661,40722,4557,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2165.00,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(323,3661,40722,4557,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2238.50,NULL,NULL,1,'2021-05-12 20:36:36','2021-05-12 20:36:36',NULL),(324,3661,40722,4557,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',29275.82,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(325,3661,40722,4557,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',59480.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(326,3661,40722,4557,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(327,3661,40722,4557,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(328,3661,40722,4557,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(329,3661,40722,4557,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(330,3661,40722,4557,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(331,3661,40722,4557,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(332,3661,40722,4557,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(333,3661,40722,4557,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL);
INSERT INTO `balance_libro` VALUES (334,3661,40722,4557,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',126723.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(335,3661,40722,4557,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(336,3661,40722,4557,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(337,3661,40722,4557,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(338,3661,40722,4557,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(339,3661,40722,4557,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(340,3661,40722,4557,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1850.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(341,3661,40722,4557,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(342,3661,40722,4557,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(343,3661,40722,4557,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(344,3661,40722,4557,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2165.00,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(345,3661,40722,4557,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2238.50,NULL,NULL,1,'2021-05-12 20:37:15','2021-05-12 20:37:15',NULL),(346,3661,40722,4557,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',1335.48,NULL,NULL,1,'2021-05-12 20:37:37','2021-05-12 20:37:37',NULL),(347,3661,40722,4557,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',1900.00,NULL,NULL,1,'2021-05-12 20:37:37','2021-05-12 20:37:37',NULL),(348,3661,40722,4557,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',3850.00,NULL,NULL,1,'2021-05-12 20:37:37','2021-05-12 20:37:37',NULL),(349,3661,40722,4557,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',9899.09,NULL,NULL,1,'2021-05-12 20:37:37','2021-05-12 20:37:37',NULL),(350,3661,40722,4557,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',555.00,NULL,NULL,1,'2021-05-12 20:37:37','2021-05-12 20:37:37',NULL),(351,3661,40723,6073,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1815.00,NULL,NULL,1,'2021-05-12 20:48:03','2021-05-12 20:48:03',NULL),(352,3661,40723,6073,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',63067.62,NULL,NULL,1,'2021-05-12 20:48:03','2021-05-12 20:48:03',NULL),(353,3661,40723,6073,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',100000.00,NULL,NULL,1,'2021-05-12 20:48:19','2021-05-12 20:48:19',NULL),(354,3661,40723,6073,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',3000.00,NULL,NULL,1,'2021-05-12 20:48:19','2021-10-21 14:23:46','2021-10-21 14:23:46');
INSERT INTO `balance_libro` VALUES (355,3661,40723,6073,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-14','2021-02-14',5799.52,NULL,NULL,1,'2021-05-12 20:48:19','2021-10-21 14:23:17','2021-10-21 14:23:17'),(356,3661,40723,6073,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',27600.00,NULL,NULL,1,'2021-05-12 20:48:19','2021-05-12 20:48:19',NULL),(357,3661,40723,6073,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',50000.00,NULL,NULL,1,'2021-05-12 20:48:19','2021-05-12 20:48:19',NULL),(358,3661,40723,6073,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',15575.27,NULL,NULL,1,'2021-05-12 20:48:19','2021-05-12 20:48:19',NULL),(359,3661,40723,6072,2,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',116150.00,NULL,NULL,1,'2021-05-12 20:50:09','2021-05-12 20:50:09',NULL),(360,3661,40723,6072,2,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',51794.29,NULL,NULL,1,'2021-05-12 20:50:09','2021-05-12 20:50:09',NULL),(361,3661,40723,6072,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',5999.00,NULL,NULL,1,'2021-05-12 20:50:31','2021-10-21 14:08:26','2021-10-21 14:08:26'),(362,3661,40723,6072,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',190299.00,NULL,NULL,1,'2021-05-12 20:50:31','2021-10-21 14:07:45','2021-10-21 14:07:45'),(363,3661,40723,6072,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',36171.74,NULL,NULL,1,'2021-05-12 20:50:31','2021-05-12 20:50:31',NULL),(364,3661,40723,6072,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',5799.52,NULL,NULL,1,'2021-05-12 20:50:31','2021-10-21 14:06:49','2021-10-21 14:06:49'),(365,3661,40723,6072,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',40500.00,NULL,NULL,1,'2021-05-12 20:50:31','2021-05-12 20:50:31',NULL),(366,3661,40723,6072,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',13826.83,NULL,NULL,1,'2021-05-12 20:50:31','2021-05-12 20:50:31',NULL),(367,3661,40720,1533,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',20000.00,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(368,3661,40720,1533,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1200.01,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(369,3661,40720,1533,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',0.00,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(370,3661,40720,1533,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',4620.00,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(371,3661,40720,1533,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',12765.50,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(372,3661,40720,1533,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1632.65,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(373,3661,40720,1533,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',5611.00,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(374,3661,40720,1533,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2904.00,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(375,3661,40720,1533,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',529.00,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL);
INSERT INTO `balance_libro` VALUES (376,3661,40720,1533,3,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',8875.55,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(377,3661,40720,1533,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',362.82,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(378,3661,40720,1533,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',5324.62,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(379,3661,40720,1533,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1054.87,NULL,NULL,1,'2021-05-19 20:47:53','2021-05-19 20:47:53',NULL),(380,3661,40720,1533,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',923.77,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(381,3661,40720,1533,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',10230.55,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(382,3661,40720,1533,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',18049.57,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(383,3661,40720,1533,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',10893.63,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(384,3661,40720,1533,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',31841.15,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(385,3661,40720,1533,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',9723.56,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(386,3661,40720,1533,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7059.14,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(387,3661,40720,1533,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',11228.80,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(388,3661,40720,1533,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7917.03,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(389,3661,40720,1533,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2575.00,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(390,3661,40720,1533,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',18045.94,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(391,3661,40720,1533,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',34212.75,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(392,3661,40720,1533,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',8787.02,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(393,3661,40720,1533,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',22053.46,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(394,3661,40720,1533,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',15904.24,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(395,3661,40720,1533,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',22745.58,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(396,3661,40720,1533,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',9411.38,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL);
INSERT INTO `balance_libro` VALUES (397,3661,40720,1533,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',20953.57,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(398,3661,40720,1533,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',60990.05,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(399,3661,40720,1533,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',18591.65,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(400,3661,40720,1533,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',28155.49,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(401,3661,40720,1533,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',8794.28,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(402,3661,40720,1533,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',14348.18,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(403,3661,40720,1533,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',60243.48,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(404,3661,40720,1533,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',8115.47,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(405,3661,40720,1533,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',6419.99,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(406,3661,40720,1533,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1084.99,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(407,3661,40720,1533,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',4155.01,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(408,3661,40720,1533,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',12857.46,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(409,3661,40720,1533,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',28132.50,NULL,NULL,1,'2021-05-19 20:53:54','2021-05-19 20:53:54',NULL),(410,3661,40720,1533,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2557.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(411,3661,40720,1533,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1145.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(412,3661,40720,1533,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1433.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(413,3661,40720,1533,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',8215.02,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(414,3661,40720,1533,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',8391.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(415,3661,40720,1533,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',5930.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(416,3661,40720,1533,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2557.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(417,3661,40720,1533,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2943.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL);
INSERT INTO `balance_libro` VALUES (418,3661,40720,1533,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1260.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(419,3661,40720,1533,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',4190.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(420,3661,40720,1533,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',1375.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(421,3661,40720,1533,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',1747.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(422,3661,40720,1533,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',890.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(423,3661,40720,1533,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',5170.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(424,3661,40720,1533,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',9475.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(425,3661,40720,1533,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2006.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(426,3661,40720,1533,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2091.99,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(427,3661,40720,1533,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2771.99,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(428,3661,40720,1533,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',1593.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(429,3661,40720,1533,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',3070.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(430,3661,40720,1533,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',2616.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(431,3661,40720,1533,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',2392.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(432,3661,40720,1533,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',4410.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(433,3661,40720,1533,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',2557.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(434,3661,40720,1533,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',1148.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(435,3661,40720,1533,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2828.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(436,3661,40720,1533,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',1490.01,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(437,3661,40720,1533,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',4795.01,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(438,3661,40720,1533,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',5518.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL);
INSERT INTO `balance_libro` VALUES (439,3661,40720,1533,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',2405.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(440,3661,40720,1533,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',2899.99,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(441,3661,40720,1533,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',3500.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(442,3661,40720,1533,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',2956.01,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(443,3661,40720,1533,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',2091.99,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(444,3661,40720,1533,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',6651.01,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(445,3661,40720,1533,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',3416.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(446,3661,40720,1533,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',898.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(447,3661,40720,1533,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',744.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(448,3661,40720,1533,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2399.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(449,3661,40720,1533,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5459.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(450,3661,40720,1533,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2660.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(451,3661,40720,1533,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',3427.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(452,3661,40720,1533,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2831.00,NULL,NULL,1,'2021-05-19 20:59:06','2021-05-19 20:59:06',NULL),(453,3661,40720,1533,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2943.00,NULL,NULL,1,'2021-05-19 20:59:07','2021-05-19 20:59:07',NULL),(454,3661,40720,1533,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',5399.02,NULL,NULL,1,'2021-05-19 20:59:07','2021-05-19 20:59:07',NULL),(455,3661,40721,3045,2,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-02','2021-05-02',1390.00,NULL,NULL,1,'2021-06-18 20:16:49','2021-06-18 20:16:49',NULL),(456,3661,40721,3045,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-02','2021-05-02',1550.00,NULL,NULL,1,'2021-06-18 20:16:49','2021-06-18 20:16:49',NULL),(457,3661,40721,3045,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-02','2021-05-02',1460.00,NULL,NULL,1,'2021-06-18 20:16:49','2021-06-18 20:16:49',NULL),(458,3661,40721,3045,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-02','2021-05-02',1300.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(459,3661,40721,3045,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-02','2021-05-02',1440.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL);
INSERT INTO `balance_libro` VALUES (460,3661,40721,3045,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',2030.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(461,3661,40721,3045,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1940.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(462,3661,40721,3045,2,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',1460.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(463,3661,40721,3045,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',2340.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(464,3661,40721,3045,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',1240.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(465,3661,40721,3045,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1130.50,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(466,3661,40721,3045,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',1550.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(467,3661,40721,3045,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1240.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(468,3661,40721,3045,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1550.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(469,3661,40721,3045,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1300.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(470,3661,40721,3045,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1550.00,NULL,NULL,1,'2021-06-18 20:16:50','2021-06-18 20:16:50',NULL),(471,3661,40721,3045,3,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',7018.00,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(472,3661,40721,3045,3,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',2703.14,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(473,3661,40721,3045,3,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',18624.30,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(474,3661,40721,3045,3,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1278.72,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(475,3661,40721,3045,3,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',79188.30,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(476,3661,40721,3045,3,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',14323.73,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(477,3661,40721,3045,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',0.00,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(478,3661,40721,3045,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',14296.65,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(479,3661,40721,3045,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',78740.31,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(480,3661,40721,3045,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',970.61,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL);
INSERT INTO `balance_libro` VALUES (481,3661,40721,3045,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',2163.04,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(482,3661,40721,3045,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',15874.56,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(483,3661,40721,3045,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',3027.24,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(484,3661,40721,3045,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',42108.00,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(485,3661,40721,3045,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',26688.01,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(486,3661,40721,3045,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',2104.48,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(487,3661,40721,3045,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',79605.43,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(488,3661,40721,3045,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',15874.56,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(489,3661,40721,3045,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',3509.00,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(490,3661,40721,3045,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1882.80,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(491,3661,40721,3045,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',15600.54,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(492,3661,40721,3045,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',67194.70,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(493,3661,40721,3045,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',1034.13,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(494,3661,40721,3045,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4312.00,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(495,3661,40721,3045,3,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',14799.04,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(496,3661,40721,3045,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',70300.18,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(497,3661,40721,3045,3,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',91417.31,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(498,3661,40721,3045,3,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',91417.31,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(499,3661,40721,3045,3,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1433.08,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(500,3661,40721,3045,3,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',88519.31,NULL,NULL,1,'2021-06-18 20:17:08','2021-06-18 20:17:08',NULL),(501,3661,40720,1534,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-02','2021-05-02',20000.00,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL);
INSERT INTO `balance_libro` VALUES (502,3661,40720,1534,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',7248.03,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL),(503,3661,40720,1534,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',36127.94,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL),(504,3661,40720,1534,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',2025.48,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL),(505,3661,40720,1534,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',0.00,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL),(506,3661,40720,1534,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1617.08,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL),(507,3661,40720,1534,3,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',24027.82,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL),(508,3661,40720,1534,3,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',2904.00,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL),(509,3661,40720,1534,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',1162.45,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL),(510,3661,40720,1534,3,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8832.03,NULL,NULL,1,'2021-06-22 19:24:33','2021-06-22 19:24:33',NULL),(511,3661,40720,1534,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',19003.05,NULL,NULL,1,'2021-06-22 19:28:52','2021-06-22 19:28:52',NULL),(512,3661,40720,1534,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',8132.41,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(513,3661,40720,1534,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',14157.00,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(514,3661,40720,1534,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',141198.53,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(515,3661,40720,1534,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',20675.27,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(516,3661,40720,1534,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',9053.22,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(517,3661,40720,1534,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6180.68,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(518,3661,40720,1534,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6180.68,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(519,3661,40720,1534,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6180.68,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(520,3661,40720,1534,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',12483.57,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(521,3661,40720,1534,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',8777.73,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(522,3661,40720,1534,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',26920.08,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL);
INSERT INTO `balance_libro` VALUES (523,3661,40720,1534,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',4996.09,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(524,3661,40720,1534,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',27848.15,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(525,3661,40720,1534,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',36815.46,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(526,3661,40720,1534,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',2384.00,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(527,3661,40720,1534,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1084.99,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(528,3661,40720,1534,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',4196.99,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(529,3661,40720,1534,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',4127.01,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(530,3661,40720,1534,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',6759.06,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(531,3661,40720,1534,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',5413.99,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(532,3661,40720,1534,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',2996.96,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(533,3661,40720,1534,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',7243.06,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(534,3661,40720,1534,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',5111.04,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(535,3661,40720,1534,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',7007.11,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(536,3661,40720,1534,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',10958.97,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(537,3661,40720,1534,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',12889.16,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(538,3661,40720,1534,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',6786.89,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(539,3661,40720,1534,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',2190.00,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(540,3661,40720,1534,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4547.00,NULL,NULL,1,'2021-06-22 19:28:53','2021-06-22 19:28:53',NULL),(541,3661,40720,1534,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',3751.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(542,3661,40720,1534,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',12716.01,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(543,3661,40720,1534,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',6287.01,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL);
INSERT INTO `balance_libro` VALUES (544,3661,40720,1534,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',1880.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(545,3661,40720,1534,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',1880.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(546,3661,40720,1534,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',3319.01,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(547,3661,40720,1534,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',3450.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(548,3661,40720,1534,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',2296.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(549,3661,40720,1534,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',1392.01,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(550,3661,40720,1534,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',1989.99,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(551,3661,40720,1534,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',2943.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(552,3661,40720,1534,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',2049.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(553,3661,40720,1534,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',651.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(554,3661,40720,1534,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',1758.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(555,3661,40720,1534,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',2848.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(556,3661,40720,1534,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',11314.00,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(557,3661,40720,1534,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',3059.99,NULL,NULL,1,'2021-06-22 19:29:09','2021-06-22 19:29:09',NULL),(558,3661,40720,1534,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',2112.01,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(559,3661,40720,1534,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',3020.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(560,3661,40720,1534,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1512.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(561,3661,40720,1534,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1797.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(562,3661,40720,1534,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',7243.06,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(563,3661,40720,1534,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',7243.06,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(564,3661,40720,1534,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',4094.01,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL);
INSERT INTO `balance_libro` VALUES (565,3661,40720,1534,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',2525.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(566,3661,40720,1534,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3008.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(567,3661,40720,1534,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',7390.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(568,3661,40720,1534,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',450.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(569,3661,40720,1534,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',5453.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(570,3661,40720,1534,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',2189.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(571,3661,40720,1534,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',3008.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(572,3661,40720,1534,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',5010.01,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(573,3661,40720,1534,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',7754.01,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(574,3661,40720,1534,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1240.00,NULL,NULL,1,'2021-06-22 19:29:10','2021-06-22 19:29:10',NULL),(575,3661,40723,6076,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',1815.00,NULL,NULL,1,'2021-06-22 20:25:22','2021-06-22 20:25:22',NULL),(576,3661,40723,6076,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',10390.37,NULL,NULL,1,'2021-06-22 20:25:22','2021-06-22 20:25:22',NULL),(577,3661,40723,6076,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',1815.00,NULL,NULL,1,'2021-06-22 20:25:22','2021-06-22 20:25:22',NULL),(578,3661,40723,6076,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',5445.00,NULL,NULL,1,'2021-06-22 20:25:23','2021-06-22 20:25:23',NULL),(579,3661,40723,6076,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',12705.00,NULL,NULL,1,'2021-06-22 20:25:23','2021-06-22 20:25:23',NULL),(580,3661,40723,6076,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',10390.00,NULL,NULL,1,'2021-06-22 20:25:23','2021-06-22 20:25:23',NULL),(581,3661,40723,6076,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',87366.84,NULL,NULL,1,'2021-06-22 20:25:23','2021-06-22 20:25:23',NULL),(582,3661,40723,6076,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',100000.00,NULL,NULL,1,'2021-06-22 20:25:45','2021-06-22 20:25:45',NULL),(583,3661,40723,6076,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',2798.00,NULL,NULL,1,'2021-06-22 20:25:45','2021-06-22 20:29:30','2021-06-22 20:29:30'),(584,3661,40723,6076,3,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',7585.84,NULL,NULL,1,'2021-06-22 20:25:45','2021-06-22 20:25:45',NULL),(585,3661,40723,6076,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',3508.38,NULL,NULL,1,'2021-06-22 20:25:46','2021-06-22 20:25:46',NULL);
INSERT INTO `balance_libro` VALUES (586,3661,40723,6076,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',12147.76,NULL,NULL,1,'2021-06-22 20:25:46','2021-06-22 20:25:46',NULL),(587,3661,40723,6076,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',2712.39,NULL,NULL,1,'2021-06-22 20:25:46','2021-06-22 20:25:46',NULL),(588,3661,40723,6076,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',18017.19,NULL,NULL,1,'2021-06-22 20:25:46','2021-06-22 20:25:46',NULL),(589,3661,40723,6076,3,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1455.24,NULL,NULL,1,'2021-06-22 20:25:46','2021-06-22 20:27:18','2021-06-22 20:27:18'),(590,3661,40723,6076,3,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1428.75,NULL,NULL,1,'2021-06-22 20:27:18','2021-06-22 20:28:49','2021-06-22 20:28:49'),(591,3661,40723,6076,3,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1428.75,NULL,NULL,1,'2021-06-22 20:28:49','2021-06-22 20:28:49',NULL),(592,3661,40723,6076,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',2798.00,NULL,NULL,1,'2021-06-22 20:29:30','2021-06-22 20:29:30',NULL),(593,3661,40722,4561,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',132790.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(594,3661,40722,4561,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',54595.92,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(595,3661,40722,4561,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',26561.52,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(596,3661,40722,4561,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',86474.38,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(597,3661,40722,4561,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',67168.20,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(598,3661,40722,4561,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',86235.16,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(599,3661,40722,4561,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',31062.68,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(600,3661,40722,4561,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',36192.24,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(601,3661,40722,4561,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',162276.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(602,3661,40722,4561,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',46611.39,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(603,3661,40722,4561,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',26963.44,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(604,3661,40722,4561,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',56167.30,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(605,3661,40722,4561,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',37202.06,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(606,3661,40722,4561,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',46913.79,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL);
INSERT INTO `balance_libro` VALUES (607,3661,40722,4561,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(608,3661,40722,4561,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',4930.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(609,3661,40722,4561,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(610,3661,40722,4561,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(611,3661,40722,4561,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(612,3661,40722,4561,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(613,3661,40722,4561,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',80014.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(614,3661,40722,4561,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(615,3661,40722,4561,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(616,3661,40722,4561,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',12795.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(617,3661,40722,4561,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(618,3661,40722,4561,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',79795.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(619,3661,40722,4561,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(620,3661,40722,4561,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(621,3661,40722,4561,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(622,3661,40722,4561,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(623,3661,40722,4561,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2365.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(624,3661,40722,4561,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',129160.00,NULL,NULL,1,'2021-06-22 20:43:40','2021-06-22 20:43:40',NULL),(625,3661,40722,4561,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',1620.09,NULL,NULL,1,'2021-06-22 20:43:53','2021-06-22 20:45:48','2021-06-22 20:45:48'),(626,3661,40722,4561,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',1900.00,NULL,NULL,1,'2021-06-22 20:43:53','2021-06-22 20:43:53',NULL),(627,3661,40722,4561,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',16331.50,NULL,NULL,1,'2021-06-22 20:43:53','2021-06-22 20:43:53',NULL);
INSERT INTO `balance_libro` VALUES (628,3661,40722,4561,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',9827.35,NULL,NULL,1,'2021-06-22 20:43:53','2021-06-22 20:43:53',NULL),(629,3661,40722,4561,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',16370.00,NULL,NULL,1,'2021-06-22 20:43:53','2021-06-22 20:43:53',NULL),(630,3661,40722,4561,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',670.00,NULL,NULL,1,'2021-06-22 20:43:53','2021-06-22 20:43:53',NULL),(631,3661,40722,4561,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',1620.09,NULL,NULL,1,'2021-06-22 20:45:48','2021-06-22 20:45:48',NULL),(632,3661,40720,1533,1,632,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-04-30',NULL,132352.01,NULL,NULL,1,'2021-07-08 02:16:38','2021-07-08 02:16:38',NULL),(633,3661,40720,1534,1,633,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-05-31',NULL,140976.09,NULL,NULL,1,'2021-07-08 02:17:00','2021-07-08 02:17:00',NULL),(634,3661,40720,1535,1,634,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-06-30',NULL,80032.69,NULL,NULL,1,'2021-07-08 02:19:46','2021-07-08 02:21:38','2021-07-08 02:21:38'),(635,3661,40722,4562,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',79795.00,NULL,NULL,1,'2021-07-16 11:12:34','2021-07-16 11:12:34',NULL),(636,3661,40722,4562,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',36468.90,NULL,NULL,1,'2021-07-16 11:12:35','2021-07-16 11:12:35',NULL),(637,3661,40722,4562,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2365.00,NULL,NULL,1,'2021-07-16 11:12:35','2021-07-16 11:12:35',NULL),(638,3661,40722,4562,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',23658.56,NULL,NULL,1,'2021-07-16 11:12:35','2021-07-16 11:12:35',NULL),(639,3661,40722,4562,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',47371.65,NULL,NULL,1,'2021-07-16 11:12:35','2021-07-16 11:12:35',NULL),(640,3661,40722,4562,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',45980.00,NULL,NULL,1,'2021-07-16 11:12:35','2021-07-16 11:12:35',NULL),(641,3661,40722,4562,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',175970.00,NULL,NULL,1,'2021-07-16 11:12:35','2021-07-16 11:12:35',NULL),(642,3661,40722,4562,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',134000.00,NULL,NULL,1,'2021-07-16 11:12:35','2021-07-16 11:12:35',NULL),(643,3661,40722,4562,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',129160.00,NULL,NULL,1,'2021-07-16 11:12:35','2021-07-16 11:12:35',NULL),(644,3661,40722,4562,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1620.09,NULL,NULL,1,'2021-07-16 11:13:01','2021-07-16 11:15:03','2021-07-16 11:15:03'),(645,3661,40722,4562,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2200.01,NULL,NULL,1,'2021-07-16 11:13:01','2021-07-16 11:13:01',NULL),(646,3661,40722,4562,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1620.09,NULL,NULL,1,'2021-07-16 11:15:03','2021-07-16 11:15:03',NULL),(647,3661,40723,6077,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',10390.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(648,3661,40723,6077,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',10390.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL);
INSERT INTO `balance_libro` VALUES (649,3661,40723,6077,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',10390.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(650,3661,40723,6077,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',10390.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(651,3661,40723,6077,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2178.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(652,3661,40723,6077,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',81305.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(653,3661,40723,6077,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',17266.70,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(654,3661,40723,6077,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1815.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(655,3661,40723,6077,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',137440.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(656,3661,40723,6077,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',142902.21,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(657,3661,40723,6077,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',10390.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(658,3661,40723,6077,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',10171.87,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(659,3661,40723,6077,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',10171.87,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(660,3661,40723,6077,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2178.00,NULL,NULL,1,'2021-07-16 11:29:37','2021-07-16 11:29:37',NULL),(661,3661,40723,6077,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',127556.44,NULL,NULL,1,'2021-07-16 11:30:36','2021-07-16 11:37:21','2021-07-16 11:37:21'),(662,3661,40723,6077,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',17399.80,NULL,NULL,1,'2021-07-16 11:30:36','2021-07-16 11:35:09','2021-07-16 11:35:09'),(663,3661,40723,6077,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',70829.76,NULL,NULL,1,'2021-07-16 11:30:36','2021-07-16 11:36:29','2021-07-16 11:36:29'),(664,3661,40723,6077,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',17399.80,NULL,NULL,1,'2021-07-16 11:35:09','2021-07-16 11:35:09',NULL),(665,3661,40723,6077,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',70829.76,NULL,NULL,1,'2021-07-16 11:36:29','2021-07-16 11:36:29',NULL),(666,3661,40723,6077,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',128674.81,NULL,NULL,1,'2021-07-16 11:37:21','2021-07-16 11:39:48','2021-07-16 11:39:48'),(667,3661,40723,6077,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',127556.44,NULL,NULL,1,'2021-07-16 11:39:48','2021-07-16 11:39:48',NULL),(668,3661,40721,3046,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',170.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(669,3661,40721,3046,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1390.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL);
INSERT INTO `balance_libro` VALUES (670,3661,40721,3046,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',850.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(671,3661,40721,3046,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1330.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(672,3661,40721,3046,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1550.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(673,3661,40721,3046,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',3640.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(674,3661,40721,3046,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1330.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(675,3661,40721,3046,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1550.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(676,3661,40721,3046,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1330.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(677,3661,40721,3046,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',1380.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(678,3661,40721,3046,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',0.10,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(679,3661,40721,3046,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2200.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(680,3661,40721,3046,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1470.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(681,3661,40721,3046,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1040.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(682,3661,40721,3046,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2760.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(683,3661,40721,3046,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',1550.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(684,3661,40721,3046,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',890.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(685,3661,40721,3046,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',150.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(686,3661,40721,3046,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',1550.01,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(687,3661,40721,3046,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',2850.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(688,3661,40721,3046,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',820.00,NULL,NULL,1,'2021-07-16 13:30:04','2021-07-16 13:30:04',NULL),(689,3661,40721,3046,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3097.60,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(690,3661,40721,3046,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',8483.40,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL);
INSERT INTO `balance_libro` VALUES (691,3661,40721,3046,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',16746.71,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(692,3661,40721,3046,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',1108.53,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(693,3661,40721,3046,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',98233.62,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(694,3661,40721,3046,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',17371.19,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(695,3661,40721,3046,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',2163.04,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(696,3661,40721,3046,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',13896.96,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(697,3661,40721,3046,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',11439.50,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(698,3661,40721,3046,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',910.40,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(699,3661,40721,3046,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',42108.00,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(700,3661,40721,3046,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',94547.38,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(701,3661,40721,3046,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',34742.39,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(702,3661,40721,3046,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',4007.15,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(703,3661,40721,3046,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',22582.57,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(704,3661,40721,3046,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',27112.39,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(705,3661,40721,3046,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',1920.98,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(706,3661,40721,3046,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',143306.98,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(707,3661,40721,3046,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',35698.85,NULL,NULL,1,'2021-07-16 13:30:17','2021-07-16 13:30:17',NULL),(708,3661,40721,3046,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',5353.61,NULL,NULL,1,'2021-07-16 13:30:18','2021-07-16 13:30:18',NULL),(709,3661,40721,3046,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',26057.10,NULL,NULL,1,'2021-07-16 13:30:18','2021-07-16 13:30:18',NULL),(710,3661,40721,3046,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',13942.75,NULL,NULL,1,'2021-07-16 13:30:18','2021-07-16 13:30:18',NULL),(711,3661,40721,3046,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',1284.87,NULL,NULL,1,'2021-07-16 13:30:18','2021-07-16 13:30:18',NULL);
INSERT INTO `balance_libro` VALUES (712,3661,40721,3046,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',167825.06,NULL,NULL,1,'2021-07-16 13:30:18','2021-07-16 13:30:18',NULL),(713,3661,40721,3046,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2647.00,NULL,NULL,1,'2021-07-16 13:30:18','2021-07-16 13:30:18',NULL),(714,3661,40721,3046,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',6000.05,NULL,NULL,1,'2021-07-16 13:30:18','2021-07-16 13:30:18',NULL),(715,3661,40721,3046,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',25420.95,NULL,NULL,1,'2021-07-16 13:30:18','2021-07-16 13:30:18',NULL),(716,3661,40721,3046,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',6036.26,NULL,NULL,1,'2021-07-16 13:30:18','2021-07-16 13:30:18',NULL),(863,3661,40720,1535,2,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',12857.46,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(864,3661,40720,1535,2,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',6733.65,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(865,3661,40720,1535,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',8430.07,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(866,3661,40720,1535,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2501.50,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(867,3661,40720,1535,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',10904.00,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(868,3661,40720,1535,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',13567.73,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(869,3661,40720,1535,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4211.01,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(870,3661,40720,1535,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',898.00,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(871,3661,40720,1535,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',898.00,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(872,3661,40720,1535,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3079.24,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(873,3661,40720,1535,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',15527.20,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(874,3661,40720,1535,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',9263.64,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(875,3661,40720,1535,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',18289.88,NULL,NULL,1,'2021-07-16 14:47:57','2021-07-16 14:47:57',NULL),(876,3661,40720,1535,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2789.00,NULL,NULL,1,'2021-07-16 14:48:38','2021-07-16 14:48:38',NULL),(877,3661,40720,1535,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1790.00,NULL,NULL,1,'2021-07-16 14:48:38','2021-07-16 14:48:38',NULL),(878,3661,40720,1535,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',3587.01,NULL,NULL,1,'2021-07-16 14:48:38','2021-07-16 14:48:38',NULL);
INSERT INTO `balance_libro` VALUES (879,3661,40720,1535,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',2490.00,NULL,NULL,1,'2021-07-16 14:48:38','2021-07-16 14:48:38',NULL),(880,3661,40720,1535,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',5217.53,NULL,NULL,1,'2021-07-16 14:48:38','2021-07-16 14:48:38',NULL),(881,3661,40720,1535,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',4593.00,NULL,NULL,1,'2021-07-16 14:48:38','2021-07-16 14:48:38',NULL),(882,3661,40720,1535,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',5647.00,NULL,NULL,1,'2021-07-16 14:48:38','2021-07-16 14:48:38',NULL),(883,3661,40720,1535,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3712.50,NULL,NULL,1,'2021-07-16 14:48:38','2021-07-16 14:48:38',NULL),(884,3661,40720,1535,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1343.25,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(885,3661,40720,1535,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1627.49,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(886,3661,40720,1535,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1650.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(887,3661,40720,1535,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3703.50,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(888,3661,40720,1535,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2102.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(889,3661,40720,1535,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1452.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(890,3661,40720,1535,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',5557.53,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(891,3661,40720,1535,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1707.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(892,3661,40720,1535,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1707.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(893,3661,40720,1535,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',8744.67,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(894,3661,40720,1535,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',3070.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(895,3661,40720,1535,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',3194.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(896,3661,40720,1535,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',889.99,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(897,3661,40720,1535,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',2626.99,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(898,3661,40720,1535,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',839.99,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(899,3661,40720,1535,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',3070.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL);
INSERT INTO `balance_libro` VALUES (900,3661,40720,1535,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',2890.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(901,3661,40720,1535,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1090.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(902,3661,40720,1535,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',890.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(903,3661,40720,1535,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4044.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(904,3661,40720,1535,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4842.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(905,3661,40720,1535,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1230.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(906,3661,40720,1535,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2780.24,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(907,3661,40720,1535,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1681.50,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(908,3661,40720,1535,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3337.49,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(909,3661,40720,1535,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1288.50,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(910,3661,40720,1535,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',525.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(911,3661,40720,1535,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',3580.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(912,3661,40720,1535,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',650.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(913,3661,40720,1535,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',8715.01,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(914,3661,40720,1535,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',4919.10,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(915,3661,40720,1535,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5604.81,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(916,3661,40720,1535,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1640.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(917,3661,40720,1535,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1640.00,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(918,3661,40720,1535,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',759.50,NULL,NULL,1,'2021-07-16 14:48:39','2021-07-16 14:48:39',NULL),(919,3661,40720,1535,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',5169.38,NULL,NULL,1,'2021-07-16 14:50:42','2021-07-16 14:50:42',NULL),(920,3661,40720,1535,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1649.03,NULL,NULL,1,'2021-07-16 14:50:42','2021-07-16 14:50:42',NULL);
INSERT INTO `balance_libro` VALUES (921,3661,40720,1535,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',0.00,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(922,3661,40720,1535,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',23609.88,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(923,3661,40720,1535,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',2904.00,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(924,3661,40720,1535,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',59654.21,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(925,3661,40720,1535,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',2869.64,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(926,3661,40720,1535,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',100846.24,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(927,3661,40720,1535,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',119805.14,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(928,3661,40720,1535,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',72026.94,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(929,3661,40720,1535,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1601.00,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(930,3661,40720,1535,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',25000.00,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(931,3661,40720,1535,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',6630.80,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(932,3661,40720,1535,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2526.13,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(933,3661,40720,1535,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',874.16,NULL,NULL,1,'2021-07-16 14:50:43','2021-07-16 14:50:43',NULL),(934,3661,40723,6078,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',28435.00,NULL,NULL,1,'2021-08-19 15:02:02','2021-08-19 15:02:02',NULL),(935,3661,40723,6078,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',10390.37,NULL,NULL,1,'2021-08-19 15:02:02','2021-08-19 15:02:02',NULL),(936,3661,40723,6078,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',10390.37,NULL,NULL,1,'2021-08-19 15:02:03','2021-08-19 15:02:03',NULL),(937,3661,40723,6078,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1815.00,NULL,NULL,1,'2021-08-19 15:02:03','2021-08-19 15:02:03',NULL),(938,3661,40723,6078,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1815.00,NULL,NULL,1,'2021-08-19 15:02:03','2021-08-19 15:02:03',NULL),(939,3661,40723,6078,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',5445.00,NULL,NULL,1,'2021-08-19 15:02:03','2021-08-19 15:02:03',NULL),(940,3661,40723,6078,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',90547.32,NULL,NULL,1,'2021-08-19 15:02:03','2021-08-19 15:02:03',NULL),(941,3661,40723,6078,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',25740.00,NULL,NULL,1,'2021-08-19 15:02:03','2021-08-19 15:02:03',NULL);
INSERT INTO `balance_libro` VALUES (942,3661,40723,6078,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',5445.00,NULL,NULL,1,'2021-08-19 15:02:03','2021-08-19 15:02:03',NULL),(943,3661,40723,6078,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',13000.00,NULL,NULL,1,'2021-08-19 15:02:40','2021-08-19 15:02:40',NULL),(944,3661,40723,6078,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1998.00,NULL,NULL,1,'2021-08-19 15:02:40','2021-08-19 15:19:20','2021-08-19 15:19:20'),(945,3661,40723,6078,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',236999.99,NULL,NULL,1,'2021-08-19 15:02:40','2021-08-19 15:02:40',NULL),(946,3661,40723,6078,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',18920.47,NULL,NULL,1,'2021-08-19 15:02:40','2021-08-19 15:02:40',NULL),(947,3661,40723,6078,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',26460.00,NULL,NULL,1,'2021-08-19 15:02:40','2021-08-19 15:17:59','2021-08-19 15:17:59'),(948,3661,40723,6078,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',20488.29,NULL,NULL,1,'2021-08-19 15:02:40','2021-08-19 15:02:40',NULL),(949,3661,40723,6078,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',26460.00,NULL,NULL,1,'2021-08-19 15:17:59','2021-08-19 15:17:59',NULL),(950,3661,40723,6078,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1998.00,NULL,NULL,1,'2021-08-19 15:19:20','2021-08-19 15:19:20',NULL),(951,3661,40722,4563,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',163450.00,NULL,NULL,1,'2021-08-19 15:42:31','2021-08-19 15:42:31',NULL),(952,3661,40722,4563,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',66210.89,NULL,NULL,1,'2021-08-19 15:42:31','2021-08-19 15:42:31',NULL),(953,3661,40722,4563,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',7865.00,NULL,NULL,1,'2021-08-19 15:42:31','2021-08-19 15:42:31',NULL),(954,3661,40722,4563,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',7865.00,NULL,NULL,1,'2021-08-19 15:42:31','2021-08-19 15:42:31',NULL),(955,3661,40722,4563,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',7865.00,NULL,NULL,1,'2021-08-19 15:42:31','2021-08-19 15:42:31',NULL),(956,3661,40722,4563,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2415.00,NULL,NULL,1,'2021-08-19 15:42:32','2021-08-19 15:42:32',NULL),(957,3661,40722,4563,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1620.09,NULL,NULL,1,'2021-08-19 15:42:43','2021-08-19 15:48:33','2021-08-19 15:48:33'),(958,3661,40722,4563,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',7827.31,NULL,NULL,1,'2021-08-19 15:42:43','2021-08-19 15:46:54','2021-08-19 15:46:54'),(959,3661,40722,4563,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',96110.42,NULL,NULL,1,'2021-08-19 15:42:44','2021-08-19 15:42:44',NULL),(960,3661,40722,4563,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',31601.98,NULL,NULL,1,'2021-08-19 15:42:44','2021-08-19 15:42:44',NULL),(961,3661,40722,4563,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',3025.00,NULL,NULL,1,'2021-08-19 15:42:44','2021-08-19 15:42:44',NULL),(962,3661,40722,4563,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',3025.00,NULL,NULL,1,'2021-08-19 15:42:44','2021-08-19 15:42:44',NULL);
INSERT INTO `balance_libro` VALUES (963,3661,40722,4563,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',7827.31,NULL,NULL,1,'2021-08-19 15:46:54','2021-08-19 15:46:54',NULL),(964,3661,40722,4563,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1620.09,NULL,NULL,1,'2021-08-19 15:48:33','2021-08-19 15:48:33',NULL),(965,3661,40721,3047,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1410.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(966,3661,40721,3047,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1700.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(967,3661,40721,3047,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1360.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(968,3661,40721,3047,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2440.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(969,3661,40721,3047,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1500.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(970,3661,40721,3047,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',990.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(971,3661,40721,3047,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1410.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(972,3661,40721,3047,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2310.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(973,3661,40721,3047,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1500.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(974,3661,40721,3047,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1930.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(975,3661,40721,3047,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',2070.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(976,3661,40721,3047,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1410.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(977,3661,40721,3047,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',540.00,NULL,NULL,1,'2021-08-19 16:05:12','2021-08-19 16:05:12',NULL),(978,3661,40721,3047,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2420.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(979,3661,40721,3047,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1410.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(980,3661,40721,3047,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2400.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(981,3661,40721,3047,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1610.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(982,3661,40721,3047,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2970.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(983,3661,40721,3047,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',680.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL);
INSERT INTO `balance_libro` VALUES (984,3661,40721,3047,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1930.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(985,3661,40721,3047,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1400.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(986,3661,40721,3047,2,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1710.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(987,3661,40721,3047,2,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2640.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(988,3661,40721,3047,2,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2420.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(989,3661,40721,3047,2,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1480.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(990,3661,40721,3047,2,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2020.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(991,3661,40721,3047,2,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2020.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(992,3661,40721,3047,2,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4270.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(993,3661,40721,3047,2,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',640.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(994,3661,40721,3047,2,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1670.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(995,3661,40721,3047,2,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3080.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(996,3661,40721,3047,2,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',860.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(997,3661,40721,3047,2,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2550.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(998,3661,40721,3047,2,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1190.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(999,3661,40721,3047,2,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2220.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(1000,3661,40721,3047,2,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1490.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(1001,3661,40721,3047,2,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2720.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(1002,3661,40721,3047,2,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1640.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(1003,3661,40721,3047,2,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2600.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(1004,3661,40721,3047,2,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1950.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL);
INSERT INTO `balance_libro` VALUES (1005,3661,40721,3047,2,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1420.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(1006,3661,40721,3047,2,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1640.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(1007,3661,40721,3047,2,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5070.00,NULL,NULL,1,'2021-08-19 16:05:13','2021-08-19 16:05:13',NULL),(1008,3661,40721,3047,2,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1950.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1009,3661,40721,3047,2,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1370.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1010,3661,40721,3047,2,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1370.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1011,3661,40721,3047,2,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4080.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1012,3661,40721,3047,2,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',830.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1013,3661,40721,3047,2,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3320.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1014,3661,40721,3047,2,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3050.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1015,3661,40721,3047,2,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2050.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1016,3661,40721,3047,2,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',510.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1017,3661,40721,3047,2,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1500.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1018,3661,40721,3047,2,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1460.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1019,3661,40721,3047,2,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',220.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1020,3661,40721,3047,2,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3150.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1021,3661,40721,3047,2,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1490.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1022,3661,40721,3047,2,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3710.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1023,3661,40721,3047,2,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2490.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1024,3661,40721,3047,2,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2350.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1025,3661,40721,3047,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1920.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL);
INSERT INTO `balance_libro` VALUES (1026,3661,40721,3047,2,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',600.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1027,3661,40721,3047,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1900.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1028,3661,40721,3047,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',460.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1029,3661,40721,3047,2,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1920.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1030,3661,40721,3047,2,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',990.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1031,3661,40721,3047,2,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1980.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1032,3661,40721,3047,2,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1500.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1033,3661,40721,3047,2,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1870.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1034,3661,40721,3047,2,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1500.00,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1035,3661,40721,3047,2,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',0.10,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1036,3661,40721,3047,2,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',3310.04,NULL,NULL,1,'2021-08-19 16:05:14','2021-08-19 16:05:14',NULL),(1037,3661,40721,3047,2,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1500.02,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1038,3661,40721,3047,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',2680.02,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1039,3661,40721,3047,2,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1230.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1040,3661,40721,3047,2,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1540.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1041,3661,40721,3047,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',2220.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1042,3661,40721,3047,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',130.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1043,3661,40721,3047,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',220.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1044,3661,40721,3047,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',360.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1045,3661,40721,3047,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',130.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1046,3661,40721,3047,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1410.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL);
INSERT INTO `balance_libro` VALUES (1047,3661,40721,3047,2,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1960.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1048,3661,40721,3047,2,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',5290.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1049,3661,40721,3047,2,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',2060.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1050,3661,40721,3047,2,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1780.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1051,3661,40721,3047,2,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1610.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1052,3661,40721,3047,2,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',100.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1053,3661,40721,3047,2,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1610.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1054,3661,40721,3047,2,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',830.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1055,3661,40721,3047,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',50.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1056,3661,40721,3047,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',50.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1057,3661,40721,3047,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',100.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1058,3661,40721,3047,2,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1600.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1059,3661,40721,3047,2,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1700.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1060,3661,40721,3047,2,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1500.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1061,3661,40721,3047,2,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1900.02,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1062,3661,40721,3047,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1700.02,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1063,3661,40721,3047,2,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1410.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1064,3661,40721,3047,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1610.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1065,3661,40721,3047,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2830.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1066,3661,40721,3047,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2220.00,NULL,NULL,1,'2021-08-19 16:05:15','2021-08-19 16:05:15',NULL),(1067,3661,40721,3047,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1660.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL);
INSERT INTO `balance_libro` VALUES (1068,3661,40721,3047,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',2190.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1069,3661,40721,3047,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1970.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1070,3661,40721,3047,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1690.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1071,3661,40721,3047,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',540.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1072,3661,40721,3047,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1750.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1073,3661,40721,3047,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1500.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1074,3661,40721,3047,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',50.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1075,3661,40721,3047,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',50.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1076,3661,40721,3047,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',190.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1077,3661,40721,3047,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',780.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1078,3661,40721,3047,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',190.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1079,3661,40721,3047,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1930.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1080,3661,40721,3047,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1610.00,NULL,NULL,1,'2021-08-19 16:05:16','2021-08-19 16:05:16',NULL),(1081,3661,40721,3047,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',3097.60,NULL,NULL,1,'2021-08-19 16:05:39','2021-08-19 16:05:39',NULL),(1082,3661,40721,3047,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',4335.29,NULL,NULL,1,'2021-08-19 16:05:39','2021-08-19 16:05:39',NULL),(1083,3661,40721,3047,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',0.00,NULL,NULL,1,'2021-08-19 16:05:39','2021-08-19 16:05:39',NULL),(1084,3661,40721,3047,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',28730.52,NULL,NULL,1,'2021-08-19 16:05:39','2021-08-19 16:05:39',NULL),(1085,3661,40721,3047,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',215006.65,NULL,NULL,1,'2021-08-19 16:05:39','2021-08-19 16:05:39',NULL),(1086,3661,40721,3047,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2004.09,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1087,3661,40721,3047,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',36579.72,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1088,3661,40721,3047,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',7675.38,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL);
INSERT INTO `balance_libro` VALUES (1089,3661,40721,3047,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',26246.61,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1090,3661,40721,3047,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1597.64,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1091,3661,40721,3047,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',102969.11,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1092,3661,40721,3047,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',3239.05,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1093,3661,40721,3047,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',32296.03,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1094,3661,40721,3047,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',5385.50,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1095,3661,40721,3047,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',37491.34,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1096,3661,40721,3047,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25372.50,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1097,3661,40721,3047,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2482.34,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1098,3661,40721,3047,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',105329.27,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1099,3661,40721,3047,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',15039.90,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1100,3661,40721,3047,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',6110.86,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1101,3661,40721,3047,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',92212.39,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1102,3661,40721,3047,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',18047.88,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1103,3661,40721,3047,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',20891.63,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1104,3661,40721,3047,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',896.30,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1105,3661,40721,3047,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',114655.36,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1106,3661,40721,3047,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',19108.33,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1107,3661,40721,3047,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',6362.30,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1108,3661,40721,3047,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',5057.98,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL),(1109,3661,40721,3047,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',12189.30,NULL,NULL,1,'2021-08-19 16:05:40','2021-08-19 16:05:40',NULL);
INSERT INTO `balance_libro` VALUES (1110,3661,40720,1536,2,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',20671.82,NULL,NULL,1,'2021-08-19 17:16:25','2021-08-19 17:16:25',NULL),(1111,3661,40720,1536,2,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',11027.30,NULL,NULL,1,'2021-08-19 17:16:25','2021-08-19 17:16:25',NULL),(1112,3661,40720,1536,2,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',6020.00,NULL,NULL,1,'2021-08-19 17:16:25','2021-08-19 17:16:25',NULL),(1113,3661,40720,1536,2,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1914.40,NULL,NULL,1,'2021-08-19 17:16:25','2021-08-19 17:16:25',NULL),(1114,3661,40720,1536,2,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',20439.92,NULL,NULL,1,'2021-08-19 17:16:25','2021-08-19 17:16:25',NULL),(1115,3661,40720,1536,2,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2359.01,NULL,NULL,1,'2021-08-19 17:16:25','2021-08-19 17:16:25',NULL),(1116,3661,40720,1536,2,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2470.01,NULL,NULL,1,'2021-08-19 17:16:25','2021-08-19 17:16:25',NULL),(1117,3661,40720,1536,2,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3382.40,NULL,NULL,1,'2021-08-19 17:16:25','2021-08-19 17:16:25',NULL),(1118,3661,40720,1536,2,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',15830.43,NULL,NULL,1,'2021-08-19 17:16:25','2021-08-19 17:16:25',NULL),(1119,3661,40720,1536,2,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',890.00,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1120,3661,40720,1536,2,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',890.00,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1121,3661,40720,1536,2,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',20094.47,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1122,3661,40720,1536,2,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',10157.43,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1123,3661,40720,1536,2,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',24248.40,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1124,3661,40720,1536,2,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',21760.64,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1125,3661,40720,1536,2,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',9019.28,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1126,3661,40720,1536,2,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',3227.49,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1127,3661,40720,1536,2,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2644.99,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1128,3661,40720,1536,2,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',12493.79,NULL,NULL,1,'2021-08-19 17:16:26','2021-08-19 17:16:26',NULL),(1129,3661,40720,1536,2,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',32447.72,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1130,3661,40720,1536,2,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',638.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL);
INSERT INTO `balance_libro` VALUES (1131,3661,40720,1536,2,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',4258.10,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1132,3661,40720,1536,2,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2374.60,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1133,3661,40720,1536,2,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1374.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1134,3661,40720,1536,2,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2884.99,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1135,3661,40720,1536,2,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1366.80,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1136,3661,40720,1536,2,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1253.70,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1137,3661,40720,1536,2,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2470.99,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1138,3661,40720,1536,2,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2139.99,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1139,3661,40720,1536,2,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2045.60,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1140,3661,40720,1536,2,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',6042.99,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1141,3661,40720,1536,2,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',6117.40,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1142,3661,40720,1536,2,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',880.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1143,3661,40720,1536,2,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1681.50,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1144,3661,40720,1536,2,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3070.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1145,3661,40720,1536,2,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3596.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1146,3661,40720,1536,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3596.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1147,3661,40720,1536,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',5177.99,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1148,3661,40720,1536,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4181.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1149,3661,40720,1536,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1385.99,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1150,3661,40720,1536,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3194.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1151,3661,40720,1536,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1385.99,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL);
INSERT INTO `balance_libro` VALUES (1152,3661,40720,1536,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3194.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1153,3661,40720,1536,2,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',2943.00,NULL,NULL,1,'2021-08-19 17:17:06','2021-08-19 17:17:06',NULL),(1154,3661,40720,1536,2,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',2299.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1155,3661,40720,1536,2,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',5351.50,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1156,3661,40720,1536,2,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1703.99,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1157,3661,40720,1536,2,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3869.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1158,3661,40720,1536,2,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1174.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1159,3661,40720,1536,2,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3580.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1160,3661,40720,1536,2,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',595.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1161,3661,40720,1536,2,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',4016.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1162,3661,40720,1536,2,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',3159.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1163,3661,40720,1536,2,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',2432.50,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1164,3661,40720,1536,2,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1686.99,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1165,3661,40720,1536,2,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1631.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1166,3661,40720,1536,2,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',759.50,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1167,3661,40720,1536,2,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1668.80,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1168,3661,40720,1536,2,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1798.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1169,3661,40720,1536,2,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',3269.50,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1170,3661,40720,1536,2,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1668.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1171,3661,40720,1536,2,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2543.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1172,3661,40720,1536,2,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',5331.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL);
INSERT INTO `balance_libro` VALUES (1173,3661,40720,1536,2,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2500.01,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1174,3661,40720,1536,2,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',3248.50,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1175,3661,40720,1536,2,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',6277.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1176,3661,40720,1536,2,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1372.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1177,3661,40720,1536,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2741.99,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1178,3661,40720,1536,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',7597.00,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1179,3661,40720,1536,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2979.99,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1180,3661,40720,1536,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2595.99,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1181,3661,40720,1536,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',889.99,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1182,3661,40720,1536,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2595.99,NULL,NULL,1,'2021-08-19 17:17:07','2021-08-19 17:17:07',NULL),(1183,3661,40720,1536,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1375.00,NULL,NULL,1,'2021-08-19 17:17:08','2021-08-19 17:17:08',NULL),(1184,3661,40720,1536,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1224.00,NULL,NULL,1,'2021-08-19 17:17:08','2021-08-19 17:17:08',NULL),(1185,3661,40720,1536,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',542.50,NULL,NULL,1,'2021-08-19 17:17:08','2021-08-19 17:17:08',NULL),(1186,3661,40720,1536,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',2243.50,NULL,NULL,1,'2021-08-19 17:17:08','2021-08-19 17:17:08',NULL),(1187,3661,40720,1536,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1333.00,NULL,NULL,1,'2021-08-19 17:17:08','2021-08-19 17:17:08',NULL),(1188,3661,40720,1536,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',540.00,NULL,NULL,1,'2021-08-19 17:17:08','2021-08-19 17:17:08',NULL),(1189,3661,40720,1536,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2211.00,NULL,NULL,1,'2021-08-19 17:17:08','2021-08-19 17:17:08',NULL),(1190,3661,40720,1536,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',25000.00,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1191,3661,40720,1536,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',4980.05,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1192,3661,40720,1536,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',230286.99,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1193,3661,40720,1536,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',14084.40,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL);
INSERT INTO `balance_libro` VALUES (1194,3661,40720,1536,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',468.54,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1195,3661,40720,1536,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',33980.32,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1196,3661,40720,1536,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',798.00,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1197,3661,40720,1536,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3387.00,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1198,3661,40720,1536,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',700.13,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1199,3661,40720,1536,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',0.00,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1200,3661,40720,1536,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',7530.68,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1201,3661,40720,1536,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',2626.32,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1202,3661,40720,1536,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2904.00,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1203,3661,40720,1536,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',10011.18,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1204,3661,40720,1536,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1332.04,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1205,3661,40720,1536,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',810.00,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1206,3661,40720,1536,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',852.00,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1207,3661,40720,1536,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',17924.13,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1208,3661,40720,1536,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',15839.25,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1209,3661,40720,1536,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',429.34,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1210,3661,40720,1536,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',33980.32,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1211,3661,40720,1536,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',6311.70,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1212,3661,40720,1536,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1567.75,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1213,3661,40720,1536,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1900.00,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL),(1214,3661,40720,1536,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',421.08,NULL,NULL,1,'2021-08-19 17:17:47','2021-08-19 17:17:47',NULL);
INSERT INTO `balance_libro` VALUES (1215,3661,40723,6079,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',10390.00,NULL,NULL,1,'2021-09-22 17:44:25','2021-09-22 17:44:25',NULL),(1216,3661,40723,6079,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',25894.00,NULL,NULL,1,'2021-09-22 17:44:25','2021-09-22 17:44:25',NULL),(1217,3661,40723,6079,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',12644.50,NULL,NULL,1,'2021-09-22 17:44:25','2021-09-22 17:44:25',NULL),(1218,3661,40723,6079,2,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',12460.60,NULL,NULL,1,'2021-09-22 17:44:25','2021-09-22 17:44:25',NULL),(1219,3661,40723,6079,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',21198.00,NULL,NULL,1,'2021-09-22 17:44:25','2021-09-22 17:44:25',NULL),(1220,3661,40723,6079,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',10390.00,NULL,NULL,1,'2021-09-22 17:44:25','2021-09-22 17:44:25',NULL),(1221,3661,40723,6079,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',5445.00,NULL,NULL,1,'2021-09-22 17:44:26','2021-09-22 17:44:26',NULL),(1222,3661,40723,6079,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',10390.00,NULL,NULL,1,'2021-09-22 17:44:26','2021-09-22 17:44:26',NULL),(1223,3661,40723,6079,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',16141.40,NULL,NULL,1,'2021-09-22 17:44:26','2021-09-22 17:44:26',NULL),(1224,3661,40723,6079,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',213075.56,NULL,NULL,1,'2021-09-22 17:44:26','2021-09-22 17:44:26',NULL),(1225,3661,40723,6079,2,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',30250.00,NULL,NULL,1,'2021-09-22 17:44:26','2021-09-22 17:44:26',NULL),(1226,3661,40723,6079,2,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',10390.00,NULL,NULL,1,'2021-09-22 17:44:26','2021-09-22 17:44:26',NULL),(1227,3661,40723,6079,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',3900.00,NULL,NULL,1,'2021-09-22 17:44:46','2021-09-22 17:51:12','2021-09-22 17:51:12'),(1228,3661,40723,6079,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',28193.99,NULL,NULL,1,'2021-09-22 17:44:46','2021-09-22 17:49:03','2021-09-22 17:49:03'),(1229,3661,40723,6079,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',35994.00,NULL,NULL,1,'2021-09-22 17:44:46','2021-09-22 17:48:40','2021-09-22 17:48:40'),(1230,3661,40723,6079,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',28193.99,NULL,NULL,1,'2021-09-22 17:44:46','2021-09-22 17:48:09','2021-09-22 17:48:09'),(1231,3661,40723,6079,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',220.00,NULL,NULL,1,'2021-09-22 17:44:46','2021-09-22 17:50:46','2021-09-22 17:50:46'),(1232,3661,40723,6079,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',100000.00,NULL,NULL,1,'2021-09-22 17:44:46','2021-09-22 17:44:46',NULL),(1233,3661,40723,6079,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',1204.23,NULL,NULL,1,'2021-09-22 17:44:46','2021-09-22 17:44:46',NULL),(1234,3661,40723,6079,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',17281.53,NULL,NULL,1,'2021-09-22 17:44:46','2021-09-22 17:44:46',NULL);
INSERT INTO `balance_libro` VALUES (1235,3661,40723,6079,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',10281.00,NULL,NULL,1,'2021-09-22 17:44:47','2021-09-22 17:50:26','2021-09-22 17:50:26'),(1236,3661,40723,6079,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',17576.85,NULL,NULL,1,'2021-09-22 17:44:47','2021-09-22 17:44:47',NULL),(1237,3661,40723,6079,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',28193.99,NULL,NULL,1,'2021-09-22 17:48:09','2021-09-22 17:48:09',NULL),(1238,3661,40723,6079,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',35994.00,NULL,NULL,1,'2021-09-22 17:48:40','2021-09-22 17:48:40',NULL),(1239,3661,40723,6079,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',28193.99,NULL,NULL,1,'2021-09-22 17:49:03','2021-09-22 17:49:03',NULL),(1240,3661,40723,6079,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',10280.99,NULL,NULL,1,'2021-09-22 17:50:26','2021-09-22 17:50:26',NULL),(1241,3661,40723,6079,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',220.00,NULL,NULL,1,'2021-09-22 17:50:46','2021-09-22 17:50:46',NULL),(1242,3661,40723,6079,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',3900.00,NULL,NULL,1,'2021-09-22 17:51:12','2021-09-22 17:51:12',NULL),(1243,3661,40722,4564,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',16230.93,NULL,NULL,1,'2021-09-23 10:47:55','2021-09-23 10:47:55',NULL),(1244,3661,40722,4564,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',39420.00,NULL,NULL,1,'2021-09-23 10:47:55','2021-09-23 10:47:55',NULL),(1245,3661,40722,4564,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1620.09,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 11:13:23','2021-09-23 11:13:23'),(1246,3661,40722,4564,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',3983.90,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 11:13:56','2021-09-23 11:13:56'),(1247,3661,40722,4564,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',3025.00,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 10:48:11',NULL),(1248,3661,40722,4564,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',3025.00,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 10:48:11',NULL),(1249,3661,40722,4564,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',3025.00,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 10:48:11',NULL),(1250,3661,40722,4564,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',3025.00,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 10:48:11',NULL),(1251,3661,40722,4564,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',3025.00,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 10:48:11',NULL),(1252,3661,40722,4564,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',33135.95,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 10:48:11',NULL),(1253,3661,40722,4564,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',12480.00,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 10:48:11',NULL),(1254,3661,40722,4564,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',7999.00,NULL,NULL,1,'2021-09-23 10:48:11','2021-09-23 10:48:11',NULL);
INSERT INTO `balance_libro` VALUES (1255,3661,40722,4564,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1620.09,NULL,NULL,1,'2021-09-23 11:13:23','2021-09-23 11:13:23',NULL),(1256,3661,40722,4564,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',3983.90,NULL,NULL,1,'2021-09-23 11:13:56','2021-09-23 11:13:56',NULL),(1257,3661,40721,3048,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',100.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1258,3661,40721,3048,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',50.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1259,3661,40721,3048,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1410.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1260,3661,40721,3048,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',270.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1261,3661,40721,3048,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',990.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1262,3661,40721,3048,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',50.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1263,3661,40721,3048,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',1490.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1264,3661,40721,3048,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',1910.02,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1265,3661,40721,3048,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',50.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1266,3661,40721,3048,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',100.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1267,3661,40721,3048,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',480.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1268,3661,40721,3048,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',2840.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1269,3661,40721,3048,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',560.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1270,3661,40721,3048,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',2440.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1271,3661,40721,3048,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',50.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1272,3661,40721,3048,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',1170.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1273,3661,40721,3048,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1190.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1274,3661,40721,3048,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1410.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1275,3661,40721,3048,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',830.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL);
INSERT INTO `balance_libro` VALUES (1276,3661,40721,3048,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1560.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1277,3661,40721,3048,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2690.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1278,3661,40721,3048,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',260.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1279,3661,40721,3048,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1240.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1280,3661,40721,3048,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1080.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1281,3661,40721,3048,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1170.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1282,3661,40721,3048,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1283,3661,40721,3048,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1530.00,NULL,NULL,1,'2021-09-23 17:46:10','2021-09-23 17:46:10',NULL),(1284,3661,40721,3048,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1350.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1285,3661,40721,3048,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1640.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1286,3661,40721,3048,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2830.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1287,3661,40721,3048,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1810.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1288,3661,40721,3048,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1880.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1289,3661,40721,3048,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2180.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1290,3661,40721,3048,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2320.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1291,3661,40721,3048,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',570.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1292,3661,40721,3048,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2050.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1293,3661,40721,3048,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1820.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1294,3661,40721,3048,2,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1610.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1295,3661,40721,3048,2,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',950.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1296,3661,40721,3048,2,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1800.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL);
INSERT INTO `balance_libro` VALUES (1297,3661,40721,3048,2,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2580.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1298,3661,40721,3048,2,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1240.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1299,3661,40721,3048,2,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2790.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1300,3661,40721,3048,2,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1360.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1301,3661,40721,3048,2,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1370.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1302,3661,40721,3048,2,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1800.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1303,3661,40721,3048,2,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2680.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1304,3661,40721,3048,2,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2890.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1305,3661,40721,3048,2,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2310.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1306,3661,40721,3048,2,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',5380.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1307,3661,40721,3048,2,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',2790.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1308,3661,40721,3048,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',50.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1309,3661,40721,3048,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',1200.02,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1310,3661,40721,3048,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',50.00,NULL,NULL,1,'2021-09-23 17:46:11','2021-09-23 17:46:11',NULL),(1311,3661,40721,3048,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',50.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1312,3661,40721,3048,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',100.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1313,3661,40721,3048,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',1500.01,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1314,3661,40721,3048,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1610.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1315,3661,40721,3048,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2280.02,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1316,3661,40721,3048,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',3020.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1317,3661,40721,3048,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',3020.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL);
INSERT INTO `balance_libro` VALUES (1318,3661,40721,3048,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',0.10,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1319,3661,40721,3048,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',990.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1320,3661,40721,3048,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',0.04,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1321,3661,40721,3048,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',1120.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1322,3661,40721,3048,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',1360.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1323,3661,40721,3048,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',2960.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1324,3661,40721,3048,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',2860.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1325,3661,40721,3048,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',2000.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1326,3661,40721,3048,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',2190.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1327,3661,40721,3048,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',3050.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1328,3661,40721,3048,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',50.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1329,3661,40721,3048,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',1810.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1330,3661,40721,3048,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',990.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1331,3661,40721,3048,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',1380.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1332,3661,40721,3048,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',2320.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1333,3661,40721,3048,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',2010.00,NULL,NULL,1,'2021-09-23 17:46:12','2021-09-23 17:46:12',NULL),(1334,3661,40721,3048,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',1400.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1335,3661,40721,3048,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',2070.04,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1336,3661,40721,3048,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',2070.04,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1337,3661,40721,3048,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',870.01,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1338,3661,40721,3048,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',1450.02,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL);
INSERT INTO `balance_libro` VALUES (1339,3661,40721,3048,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',5880.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1340,3661,40721,3048,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2130.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1341,3661,40721,3048,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1410.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1342,3661,40721,3048,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1890.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1343,3661,40721,3048,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',3280.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1344,3661,40721,3048,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2960.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1345,3661,40721,3048,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1560.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1346,3661,40721,3048,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',8660.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1347,3661,40721,3048,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1120.00,NULL,NULL,1,'2021-09-23 17:46:13','2021-09-23 17:46:13',NULL),(1348,3661,40721,3048,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3800.00,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1349,3661,40721,3048,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3097.60,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1350,3661,40721,3048,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',25440.23,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1351,3661,40721,3048,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',98565.24,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1352,3661,40721,3048,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',2246.15,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1353,3661,40721,3048,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',11276.89,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1354,3661,40721,3048,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',10512.03,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1355,3661,40721,3048,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',13484.20,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1356,3661,40721,3048,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',12563.70,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1357,3661,40721,3048,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',774.94,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1358,3661,40721,3048,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',119955.68,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1359,3661,40721,3048,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',3143.73,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL);
INSERT INTO `balance_libro` VALUES (1360,3661,40721,3048,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',23336.52,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1361,3661,40721,3048,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',10727.67,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1362,3661,40721,3048,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',56672.65,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1363,3661,40721,3048,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',95268.32,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1364,3661,40721,3048,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',42108.00,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1365,3661,40721,3048,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',25540.24,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1366,3661,40721,3048,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',14531.89,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1367,3661,40721,3048,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',8512.62,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1368,3661,40721,3048,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',616.31,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1369,3661,40721,3048,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',106624.98,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1370,3661,40721,3048,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',32370.54,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1371,3661,40721,3048,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',29422.13,NULL,NULL,1,'2021-09-23 17:46:30','2021-09-23 17:46:30',NULL),(1372,3661,40721,3048,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',11936.43,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1373,3661,40721,3048,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',108277.66,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1374,3661,40721,3048,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',602.60,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1375,3661,40721,3048,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',20045.42,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1376,3661,40721,3048,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',18934.48,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1377,3661,40721,3048,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',18934.48,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1378,3661,40721,3048,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',23155.45,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1379,3661,40721,3048,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',12000.72,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1380,3661,40721,3048,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',105585.49,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL);
INSERT INTO `balance_libro` VALUES (1381,3661,40721,3048,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',473.76,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1382,3661,40721,3048,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2021.00,NULL,NULL,1,'2021-09-23 17:46:31','2021-09-23 17:46:31',NULL),(1383,3661,40720,1537,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',8838.53,NULL,NULL,1,'2021-10-04 14:54:11','2021-10-04 14:54:11',NULL),(1384,3661,40720,1537,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',5178.00,NULL,NULL,1,'2021-10-04 14:54:11','2021-10-04 14:54:11',NULL),(1385,3661,40720,1537,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',4801.89,NULL,NULL,1,'2021-10-04 14:54:11','2021-10-04 14:54:11',NULL),(1386,3661,40720,1537,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',2636.00,NULL,NULL,1,'2021-10-04 14:54:11','2021-10-04 14:54:11',NULL),(1387,3661,40720,1537,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',2682.00,NULL,NULL,1,'2021-10-04 14:54:11','2021-10-04 14:54:11',NULL),(1388,3661,40720,1537,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',13721.40,NULL,NULL,1,'2021-10-04 15:02:12','2021-10-04 15:02:12',NULL),(1389,3661,40720,1537,3,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',14407.47,NULL,NULL,1,'2021-10-04 15:02:12','2021-10-04 15:02:12',NULL),(1390,3661,40720,1537,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',14407.47,NULL,NULL,1,'2021-10-04 15:02:12','2021-10-04 15:02:12',NULL),(1391,3661,40720,1537,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',597.97,NULL,NULL,1,'2021-10-04 15:02:12','2021-10-04 15:02:12',NULL),(1392,3661,40720,1537,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',412.20,NULL,NULL,1,'2021-10-04 15:02:12','2021-10-04 15:02:12',NULL),(1393,3661,40720,1537,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',23000.00,NULL,NULL,1,'2021-10-04 15:02:12','2021-10-04 15:02:12',NULL),(1394,3661,40720,1537,3,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',6608.84,NULL,NULL,1,'2021-10-04 15:02:12','2021-10-04 15:02:12',NULL),(1395,3661,40720,1537,3,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',1201.28,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1396,3661,40720,1537,3,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',0.00,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1397,3661,40720,1537,3,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',508.54,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1398,3661,40720,1537,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2904.00,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1399,3661,40720,1537,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',45646.04,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1400,3661,40720,1537,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',1206.98,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1401,3661,40720,1537,3,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',354.05,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL);
INSERT INTO `balance_libro` VALUES (1402,3661,40720,1537,3,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',11732.16,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1403,3661,40720,1537,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',855.00,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1404,3661,40720,1537,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',562.40,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1405,3661,40720,1537,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1424.53,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1406,3661,40720,1537,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2082.01,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1407,3661,40720,1537,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2694.65,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1408,3661,40720,1537,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1900.00,NULL,NULL,1,'2021-10-04 15:02:13','2021-10-04 15:02:13',NULL),(1409,3661,40720,1537,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',1245.00,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1410,3661,40720,1537,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',3684.00,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1411,3661,40720,1537,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2439.99,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1412,3661,40720,1537,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2429.99,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1413,3661,40720,1537,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2651.00,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1414,3661,40720,1537,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',610.00,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1415,3661,40720,1537,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',1345.00,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1416,3661,40720,1537,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',2074.00,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1417,3661,40720,1537,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1960.01,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1418,3661,40720,1537,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',871.00,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1419,3661,40720,1537,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2284.00,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1420,3661,40720,1537,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2411.00,NULL,NULL,1,'2021-10-04 15:02:49','2021-10-04 15:02:49',NULL),(1421,3661,40720,1537,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2314.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1422,3661,40720,1537,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',3489.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL);
INSERT INTO `balance_libro` VALUES (1423,3661,40720,1537,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4044.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1424,3661,40720,1537,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',5887.20,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1425,3661,40720,1537,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1500.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1426,3661,40720,1537,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',749.99,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1427,3661,40720,1537,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',871.01,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1428,3661,40720,1537,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',871.01,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1429,3661,40720,1537,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',784.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1430,3661,40720,1537,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',2352.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1431,3661,40720,1537,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',6809.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1432,3661,40720,1537,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',1695.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1433,3661,40720,1537,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',3696.01,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1434,3661,40720,1537,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',2570.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1435,3661,40720,1537,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',5235.17,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1436,3661,40720,1537,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1807.06,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1437,3661,40720,1537,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',5740.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1438,3661,40720,1537,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',3463.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1439,3661,40720,1537,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',6027.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1440,3661,40720,1537,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1821.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1441,3661,40720,1537,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3563.41,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1442,3661,40720,1537,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',6069.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1443,3661,40720,1537,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',6687.01,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL);
INSERT INTO `balance_libro` VALUES (1444,3661,40720,1537,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1132.56,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1445,3661,40720,1537,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1722.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1446,3661,40720,1537,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',5024.44,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1447,3661,40720,1537,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4300.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1448,3661,40720,1537,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4300.00,NULL,NULL,1,'2021-10-04 15:02:50','2021-10-04 15:02:50',NULL),(1449,3661,40721,3042,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1450,3661,40721,3042,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',810.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1451,3661,40721,3042,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1452,3661,40721,3042,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1453,3661,40721,3042,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1454,3661,40721,3042,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1455,3661,40721,3042,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1456,3661,40721,3042,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',810.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1457,3661,40721,3042,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1035.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1458,3661,40721,3042,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1210.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1459,3661,40721,3042,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1680.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1460,3661,40721,3042,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1310.00,NULL,NULL,1,'2021-10-04 17:50:18','2021-10-04 17:50:18',NULL),(1461,3661,40721,3042,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1940.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1462,3661,40721,3042,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1170.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1463,3661,40721,3042,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1710.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1464,3661,40721,3042,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1170.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL);
INSERT INTO `balance_libro` VALUES (1465,3661,40721,3042,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1120.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1466,3661,40721,3042,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1170.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1467,3661,40721,3042,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1170.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1468,3661,40721,3042,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1080.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1469,3661,40721,3042,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1080.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1470,3661,40721,3042,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1080.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1471,3661,40721,3042,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2880.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1472,3661,40721,3042,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1790.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1473,3661,40721,3042,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1120.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1474,3661,40721,3042,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1170.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1475,3661,40721,3042,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1170.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1476,3661,40721,3042,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1080.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1477,3661,40721,3042,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',880.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1478,3661,40721,3042,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1750.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1479,3661,40721,3042,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1480,3661,40721,3042,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1481,3661,40721,3042,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',810.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1482,3661,40721,3042,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',720.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1483,3661,40721,3042,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1940.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1484,3661,40721,3042,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1710.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1485,3661,40721,3042,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',950.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL);
INSERT INTO `balance_libro` VALUES (1486,3661,40721,3042,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1570.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1487,3661,40721,3042,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1450.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1488,3661,40721,3042,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1750.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1489,3661,40721,3042,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1760.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1490,3661,40721,3042,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1080.00,NULL,NULL,1,'2021-10-04 17:50:19','2021-10-04 17:50:19',NULL),(1491,3661,40721,3042,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1430.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1492,3661,40721,3042,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',250.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1493,3661,40721,3042,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',540.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1494,3661,40721,3042,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',200.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1495,3661,40721,3042,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',200.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1496,3661,40721,3042,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1630.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1497,3661,40721,3042,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',2105.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1498,3661,40721,3042,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',310.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1499,3661,40721,3042,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',400.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1500,3661,40721,3042,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',620.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1501,3661,40721,3042,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',890.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1502,3661,40721,3042,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1430.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1503,3661,40721,3042,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',890.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1504,3661,40721,3042,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',530.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1505,3661,40721,3042,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1330.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1506,3661,40721,3042,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',440.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL);
INSERT INTO `balance_libro` VALUES (1507,3661,40721,3042,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',940.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1508,3661,40721,3042,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1509,3661,40721,3042,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1730.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1510,3661,40721,3042,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',2690.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1511,3661,40721,3042,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1080.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1512,3661,40721,3042,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',2870.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1513,3661,40721,3042,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1730.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1514,3661,40721,3042,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',870.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1515,3661,40721,3042,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',200.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1516,3661,40721,3042,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2080.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1517,3661,40721,3042,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',420.00,NULL,NULL,1,'2021-10-04 17:50:20','2021-10-04 17:50:20',NULL),(1518,3661,40721,3042,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',630.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1519,3661,40721,3042,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',440.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1520,3661,40721,3042,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1350.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1521,3661,40721,3042,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',600.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1522,3661,40721,3042,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',400.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1523,3661,40721,3042,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1230.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1524,3661,40721,3042,2,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2080.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1525,3661,40721,3042,2,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',330.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1526,3661,40721,3042,2,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',200.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1527,3661,40721,3042,2,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',720.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL);
INSERT INTO `balance_libro` VALUES (1528,3661,40721,3042,2,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',400.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1529,3661,40721,3042,2,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',400.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1530,3661,40721,3042,2,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',400.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1531,3661,40721,3042,2,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',780.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1532,3661,40721,3042,2,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',320.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1533,3661,40721,3042,2,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',400.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1534,3661,40721,3042,2,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1080.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1535,3661,40721,3042,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1200.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1536,3661,40721,3042,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',970.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1537,3661,40721,3042,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',200.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1538,3661,40721,3042,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',880.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1539,3661,40721,3042,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1880.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1540,3661,40721,3042,2,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2390.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1541,3661,40721,3042,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',950.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1542,3661,40721,3042,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2220.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1543,3661,40721,3042,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1570.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1544,3661,40721,3042,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2580.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1545,3661,40721,3042,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1920.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1546,3661,40721,3042,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1030.00,NULL,NULL,1,'2021-10-04 17:50:21','2021-10-04 17:50:21',NULL),(1547,3661,40721,3042,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1030.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1548,3661,40721,3042,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1920.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL);
INSERT INTO `balance_libro` VALUES (1549,3661,40721,3042,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1260.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1550,3661,40721,3042,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1170.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1551,3661,40721,3042,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1030.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1552,3661,40721,3042,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2120.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1553,3661,40721,3042,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1350.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1554,3661,40721,3042,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1555,3661,40721,3042,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1260.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1556,3661,40721,3042,2,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',500.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1557,3661,40721,3042,2,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1030.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1558,3661,40721,3042,2,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1460.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1559,3661,40721,3042,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',3180.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1560,3661,40721,3042,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2250.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1561,3661,40721,3042,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2280.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1562,3661,40721,3042,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',600.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1563,3661,40721,3042,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1190.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1564,3661,40721,3042,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2200.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1565,3661,40721,3042,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',220.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1566,3661,40721,3042,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1880.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1567,3661,40721,3042,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2000.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1568,3661,40721,3042,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',3010.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1569,3661,40721,3042,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',630.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL);
INSERT INTO `balance_libro` VALUES (1570,3661,40721,3042,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',3100.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1571,3661,40721,3042,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2180.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1572,3661,40721,3042,2,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1880.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1573,3661,40721,3042,2,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',550.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1574,3661,40721,3042,2,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',540.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1575,3661,40721,3042,2,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',200.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1576,3661,40721,3042,2,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1.00,NULL,NULL,1,'2021-10-04 17:50:22','2021-10-04 17:50:22',NULL),(1577,3661,40721,3042,2,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1578,3661,40721,3042,2,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1350.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1579,3661,40721,3042,2,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1580,3661,40721,3042,2,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1581,3661,40721,3042,2,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',330.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1582,3661,40721,3042,2,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1030.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1583,3661,40721,3042,2,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1890.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1584,3661,40721,3042,2,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',1310.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1585,3661,40721,3042,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',720.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1586,3661,40721,3042,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',660.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1587,3661,40721,3042,2,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',810.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1588,3661,40721,3042,2,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',3680.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1589,3661,40721,3042,2,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1820.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1590,3661,40721,3042,2,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',750.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL);
INSERT INTO `balance_libro` VALUES (1591,3661,40721,3042,2,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',2200.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1592,3661,40721,3042,2,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1660.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1593,3661,40721,3042,2,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1720.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1594,3661,40721,3042,2,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',400.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1595,3661,40721,3042,2,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',900.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1596,3661,40721,3042,2,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1950.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1597,3661,40721,3042,2,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1930.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1598,3661,40721,3042,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',400.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1599,3661,40721,3042,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',3270.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1600,3661,40721,3042,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',990.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1601,3661,40721,3042,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1620.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1602,3661,40721,3042,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1030.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1603,3661,40721,3042,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1150.00,NULL,NULL,1,'2021-10-04 17:50:23','2021-10-04 17:50:23',NULL),(1604,3661,40721,3042,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1480.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1605,3661,40721,3042,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',450.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1606,3661,40721,3042,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1270.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1607,3661,40721,3042,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1030.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1608,3661,40721,3042,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1080.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1609,3661,40721,3042,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',870.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1610,3661,40721,3042,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',400.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1611,3661,40721,3042,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',840.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL);
INSERT INTO `balance_libro` VALUES (1612,3661,40721,3042,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',440.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1613,3661,40721,3042,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1080.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1614,3661,40721,3042,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',260.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1615,3661,40721,3042,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',870.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1616,3661,40721,3042,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1920.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1617,3661,40721,3042,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1640.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1618,3661,40721,3042,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',400.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1619,3661,40721,3042,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',400.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1620,3661,40721,3042,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',320.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1621,3661,40721,3042,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',400.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1622,3661,40721,3042,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',2430.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1623,3661,40721,3042,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1430.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1624,3661,40721,3042,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1330.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1625,3661,40721,3042,2,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1310.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1626,3661,40721,3042,2,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',2080.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1627,3661,40721,3042,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1630.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1628,3661,40721,3042,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',630.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1629,3661,40721,3042,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',2.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1630,3661,40721,3042,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',3010.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1631,3661,40721,3042,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1440.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1632,3661,40721,3042,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',620.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL);
INSERT INTO `balance_libro` VALUES (1633,3661,40721,3042,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1260.00,NULL,NULL,1,'2021-10-04 17:50:24','2021-10-04 17:50:24',NULL),(1634,3661,40721,3042,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1720.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1635,3661,40721,3042,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1240.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1636,3661,40721,3042,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',2205.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1637,3661,40721,3042,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1280.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1638,3661,40721,3042,2,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1150.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1639,3661,40721,3042,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1030.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1640,3661,40721,3042,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',830.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1641,3661,40721,3042,2,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',940.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1642,3661,40721,3042,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1250.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1643,3661,40721,3042,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',2060.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1644,3661,40721,3042,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',770.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1645,3661,40721,3042,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1800.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1646,3661,40721,3042,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1230.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1647,3661,40721,3042,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',630.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1648,3661,40721,3042,2,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1250.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1649,3661,40721,3042,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',2210.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1650,3661,40721,3042,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',5660.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1651,3661,40721,3042,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',850.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1652,3661,40721,3042,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',2120.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1653,3661,40721,3042,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',600.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL);
INSERT INTO `balance_libro` VALUES (1654,3661,40721,3042,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',400.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1655,3661,40721,3042,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',3190.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1656,3661,40721,3042,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1430.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1657,3661,40721,3042,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',220.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1658,3661,40721,3042,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1180.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1659,3661,40721,3042,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',3510.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1660,3661,40721,3042,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',1440.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1661,3661,40721,3042,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',880.00,NULL,NULL,1,'2021-10-04 17:50:25','2021-10-04 17:50:25',NULL),(1662,3661,40721,3042,2,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',540.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1663,3661,40721,3042,2,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',2330.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1664,3661,40721,3042,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',2340.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1665,3661,40721,3042,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1170.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1666,3661,40721,3042,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',720.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1667,3661,40721,3042,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1170.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1668,3661,40721,3042,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1310.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1669,3661,40721,3042,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1760.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1670,3661,40721,3042,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2390.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1671,3661,40721,3042,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1170.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1672,3661,40721,3042,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',870.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1673,3661,40721,3042,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1170.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1674,3661,40721,3042,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1800.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL);
INSERT INTO `balance_libro` VALUES (1675,3661,40721,3042,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1030.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1676,3661,40721,3042,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2040.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1677,3661,40721,3042,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1060.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1678,3661,40721,3042,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1460.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1679,3661,40721,3042,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1680,3661,40721,3042,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',400.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1681,3661,40721,3042,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',400.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1682,3661,40721,3042,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',3050.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1683,3661,40721,3042,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1150.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1684,3661,40721,3042,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',2120.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1685,3661,40721,3042,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',755.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1686,3661,40721,3042,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1290.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1687,3661,40721,3042,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1310.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1688,3661,40721,3042,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',720.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1689,3661,40721,3042,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',890.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1690,3661,40721,3042,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1310.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1691,3661,40721,3042,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',910.00,NULL,NULL,1,'2021-10-04 17:50:26','2021-10-04 17:50:26',NULL),(1692,3661,40721,3042,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1100.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1693,3661,40721,3042,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1070.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1694,3661,40721,3042,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1580.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1695,3661,40721,3042,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1090.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL);
INSERT INTO `balance_libro` VALUES (1696,3661,40721,3042,2,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1500.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1697,3661,40721,3042,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1120.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1698,3661,40721,3042,2,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1570.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1699,3661,40721,3042,2,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',2490.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1700,3661,40721,3042,2,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',2100.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1701,3661,40721,3042,2,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1330.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1702,3661,40721,3042,2,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1150.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1703,3661,40721,3042,2,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1540.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1704,3661,40721,3042,2,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1360.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1705,3661,40721,3042,2,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',1885.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1706,3661,40721,3042,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',2440.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1707,3661,40721,3042,2,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',3150.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1708,3661,40721,3042,2,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',660.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1709,3661,40721,3042,2,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',954.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1710,3661,40721,3042,2,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1200.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1711,3661,40721,3042,2,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1070.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1712,3661,40721,3042,2,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',630.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1713,3661,40721,3042,2,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',630.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1714,3661,40721,3042,2,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1740.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1715,3661,40721,3042,2,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2620.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1716,3661,40721,3042,2,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2080.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL);
INSERT INTO `balance_libro` VALUES (1717,3661,40721,3042,2,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',980.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1718,3661,40721,3042,2,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',630.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1719,3661,40721,3042,2,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1170.00,NULL,NULL,1,'2021-10-04 17:50:27','2021-10-04 17:50:27',NULL),(1720,3661,40721,3042,2,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',3020.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1721,3661,40721,3042,2,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',280.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1722,3661,40721,3042,2,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',440.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1723,3661,40721,3042,2,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1960.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1724,3661,40721,3042,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1980.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1725,3661,40721,3042,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',910.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1726,3661,40721,3042,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',3260.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1727,3661,40721,3042,2,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1290.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1728,3661,40721,3042,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1500.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1729,3661,40721,3042,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1920.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1730,3661,40721,3042,2,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2400.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1731,3661,40721,3042,2,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2620.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1732,3661,40721,3042,2,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',630.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1733,3661,40721,3042,2,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1730.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1734,3661,40721,3042,2,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',880.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1735,3661,40721,3042,2,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',440.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1736,3661,40721,3042,2,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',980.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1737,3661,40721,3042,2,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1520.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL);
INSERT INTO `balance_libro` VALUES (1738,3661,40721,3042,2,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',440.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1739,3661,40721,3042,2,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',440.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1740,3661,40721,3042,2,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',220.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1741,3661,40721,3042,2,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',130.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1742,3661,40721,3042,2,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',150.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1743,3661,40721,3042,2,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1030.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1744,3661,40721,3042,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',440.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1745,3661,40721,3042,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',400.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1746,3661,40721,3042,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',440.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1747,3661,40721,3042,2,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',2000.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1748,3661,40721,3042,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1220.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1749,3661,40721,3042,2,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1220.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1750,3661,40721,3042,2,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',220.00,NULL,NULL,1,'2021-10-04 17:50:28','2021-10-04 17:50:28',NULL),(1751,3661,40721,3042,2,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',130.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1752,3661,40721,3042,2,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',130.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1753,3661,40721,3042,2,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1710.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1754,3661,40721,3042,2,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1220.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1755,3661,40721,3042,2,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',440.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1756,3661,40721,3042,2,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',220.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1757,3661,40721,3042,2,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1080.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1758,3661,40721,3042,2,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',440.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL);
INSERT INTO `balance_libro` VALUES (1759,3661,40721,3042,2,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',370.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1760,3661,40721,3042,2,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',440.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1761,3661,40721,3042,2,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',850.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1762,3661,40721,3042,2,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',2380.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1763,3661,40721,3042,2,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',660.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1764,3661,40721,3042,2,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',2130.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1765,3661,40721,3042,2,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1780.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1766,3661,40721,3042,2,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',2490.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1767,3661,40721,3042,2,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3575.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1768,3661,40721,3042,2,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',940.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1769,3661,40721,3042,2,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3000.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1770,3661,40721,3042,2,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3450.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1771,3661,40721,3042,2,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',4310.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1772,3661,40721,3042,2,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',7730.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1773,3661,40721,3042,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1100.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1774,3661,40721,3042,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1810.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1775,3661,40721,3042,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1270.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1776,3661,40721,3042,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1070.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1777,3661,40721,3042,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',2810.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1778,3661,40721,3042,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1660.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1779,3661,40721,3042,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',840.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL);
INSERT INTO `balance_libro` VALUES (1780,3661,40721,3042,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',5610.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1781,3661,40721,3042,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',7530.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1782,3661,40721,3042,2,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1210.00,NULL,NULL,1,'2021-10-04 17:50:29','2021-10-04 17:50:29',NULL),(1783,3661,40721,3042,2,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2100.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1784,3661,40721,3042,2,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2520.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1785,3661,40721,3042,2,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2920.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1786,3661,40721,3042,2,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',600.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1787,3661,40721,3042,2,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',350.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1788,3661,40721,3042,2,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',430.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1789,3661,40721,3042,2,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1790.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1790,3661,40721,3042,2,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',220.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1791,3661,40721,3042,2,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1320.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1792,3661,40721,3042,2,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',810.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1793,3661,40721,3042,2,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1080.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1794,3661,40721,3042,2,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1080.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1795,3661,40721,3042,2,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1070.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1796,3661,40721,3042,2,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',660.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1797,3661,40721,3042,2,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',400.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1798,3661,40721,3042,2,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1720.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1799,3661,40721,3042,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1790.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1800,3661,40721,3042,2,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',460.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL);
INSERT INTO `balance_libro` VALUES (1801,3661,40721,3042,2,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',730.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1802,3661,40721,3042,2,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',440.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1803,3661,40721,3042,2,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',3170.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1804,3661,40721,3042,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2220.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1805,3661,40721,3042,2,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2310.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1806,3661,40721,3042,2,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1290.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1807,3661,40721,3042,2,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1510.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1808,3661,40721,3042,2,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1290.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1809,3661,40721,3042,2,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',630.00,NULL,NULL,1,'2021-10-04 17:50:30','2021-10-04 17:50:30',NULL),(1810,3661,40721,3042,2,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',910.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1811,3661,40721,3042,2,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1590.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1812,3661,40721,3042,2,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1550.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1813,3661,40721,3042,2,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',590.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1814,3661,40721,3042,2,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2940.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1815,3661,40721,3042,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2170.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1816,3661,40721,3042,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1070.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1817,3661,40721,3042,2,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',910.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1818,3661,40721,3042,2,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',3170.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1819,3661,40721,3042,2,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2310.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1820,3661,40721,3042,2,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1290.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1821,3661,40721,3042,2,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',810.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL);
INSERT INTO `balance_libro` VALUES (1822,3661,40721,3042,2,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1510.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1823,3661,40721,3042,2,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2935.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1824,3661,40721,3042,2,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1520.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1825,3661,40721,3042,2,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1100.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1826,3661,40721,3042,2,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1630.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1827,3661,40721,3042,2,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1100.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1828,3661,40721,3042,2,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1840.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1829,3661,40721,3042,2,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1520.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1830,3661,40721,3042,2,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',3190.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1831,3661,40721,3042,2,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2860.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1832,3661,40721,3042,2,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1110.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1833,3661,40721,3042,2,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1600.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1834,3661,40721,3042,2,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',350.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1835,3661,40721,3042,2,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2630.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1836,3661,40721,3042,2,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1130.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1837,3661,40721,3042,2,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',760.00,NULL,NULL,1,'2021-10-04 17:50:31','2021-10-04 17:50:31',NULL),(1838,3661,40721,3042,2,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1820.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1839,3661,40721,3042,2,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',720.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1840,3661,40721,3042,2,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1220.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1841,3661,40721,3042,2,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1650.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1842,3661,40721,3042,2,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1220.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL);
INSERT INTO `balance_libro` VALUES (1843,3661,40721,3042,2,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1195.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1844,3661,40721,3042,2,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1290.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1845,3661,40721,3042,2,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1290.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1846,3661,40721,3042,2,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2280.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1847,3661,40721,3042,2,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1510.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1848,3661,40721,3042,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1720.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1849,3661,40721,3042,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',630.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1850,3661,40721,3042,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',350.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1851,3661,40721,3042,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',260.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1852,3661,40721,3042,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',6040.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1853,3661,40721,3042,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1080.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1854,3661,40721,3042,2,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2210.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1855,3661,40721,3042,2,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1760.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1856,3661,40721,3042,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1820.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1857,3661,40721,3042,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1230.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1858,3661,40721,3042,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',660.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1859,3661,40721,3042,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',220.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1860,3661,40721,3042,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',220.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1861,3661,40721,3042,2,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1430.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1862,3661,40721,3042,2,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1230.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1863,3661,40721,3042,2,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1740.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL);
INSERT INTO `balance_libro` VALUES (1864,3661,40721,3042,2,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',130.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1865,3661,40721,3042,2,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1295.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1866,3661,40721,3042,2,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2035.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1867,3661,40721,3042,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1070.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1868,3661,40721,3042,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',3130.00,NULL,NULL,1,'2021-10-04 17:50:32','2021-10-04 17:50:32',NULL),(1869,3661,40721,3042,2,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',3390.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1870,3661,40721,3042,2,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1070.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1871,3661,40721,3042,2,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4030.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1872,3661,40721,3042,2,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1455.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1873,3661,40721,3042,2,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1420.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1874,3661,40721,3042,2,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2800.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1875,3661,40721,3042,2,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1250.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1876,3661,40721,3042,2,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1730.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1877,3661,40721,3042,2,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1360.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1878,3661,40721,3042,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',630.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1879,3661,40721,3042,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1740.00,NULL,NULL,1,'2021-10-04 17:50:33','2021-10-04 17:50:33',NULL),(1880,3661,40721,3042,3,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',21575.67,NULL,NULL,1,'2021-10-04 17:51:03','2021-10-04 17:51:03',NULL),(1881,3661,40721,3042,3,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',81526.26,NULL,NULL,1,'2021-10-04 17:51:03','2021-10-04 17:51:03',NULL),(1882,3661,40721,3042,3,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',6380.00,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1883,3661,40721,3042,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',22280.94,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1884,3661,40721,3042,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',20439.81,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL);
INSERT INTO `balance_libro` VALUES (1885,3661,40721,3042,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',14228.09,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1886,3661,40721,3042,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',22280.94,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1887,3661,40721,3042,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',22280.94,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1888,3661,40721,3042,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6967.30,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1889,3661,40721,3042,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',20439.81,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1890,3661,40721,3042,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',0.00,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1891,3661,40721,3042,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',40696.14,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1892,3661,40721,3042,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',55366.64,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1893,3661,40721,3042,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',18977.83,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1894,3661,40721,3042,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',116221.90,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1895,3661,40721,3042,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',116221.90,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1896,3661,40721,3042,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',116221.90,NULL,NULL,1,'2021-10-04 17:51:04','2021-10-04 17:51:04',NULL),(1897,3661,40721,3043,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',445.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1898,3661,40721,3043,2,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1220.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1899,3661,40721,3043,2,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',630.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1900,3661,40721,3043,2,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',630.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1901,3661,40721,3043,2,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1170.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1902,3661,40721,3043,2,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',720.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1903,3661,40721,3043,2,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1170.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1904,3661,40721,3043,2,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1170.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1905,3661,40721,3043,2,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1170.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL);
INSERT INTO `balance_libro` VALUES (1906,3661,40721,3043,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1640.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1907,3661,40721,3043,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1660.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1908,3661,40721,3043,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',220.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1909,3661,40721,3043,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',630.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1910,3661,40721,3043,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',2.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1911,3661,40721,3043,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1170.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1912,3661,40721,3043,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1200.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1913,3661,40721,3043,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1850.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1914,3661,40721,3043,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',290.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1915,3661,40721,3043,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',440.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1916,3661,40721,3043,2,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1650.00,NULL,NULL,1,'2021-10-04 17:52:16','2021-10-04 17:52:16',NULL),(1917,3661,40721,3043,2,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',280.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1918,3661,40721,3043,2,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1860.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1919,3661,40721,3043,2,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',630.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1920,3661,40721,3043,2,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1950.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1921,3661,40721,3043,2,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',630.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1922,3661,40721,3043,2,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1430.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1923,3661,40721,3043,2,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1710.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1924,3661,40721,3043,2,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1225.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1925,3661,40721,3043,2,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',980.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1926,3661,40721,3043,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2090.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL);
INSERT INTO `balance_libro` VALUES (1927,3661,40721,3043,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',630.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1928,3661,40721,3043,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1590.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1929,3661,40721,3043,2,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1620.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1930,3661,40721,3043,2,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',850.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1931,3661,40721,3043,2,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1510.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1932,3661,40721,3043,2,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2000.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1933,3661,40721,3043,2,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1220.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1934,3661,40721,3043,2,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1310.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1935,3661,40721,3043,2,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1180.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1936,3661,40721,3043,2,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2080.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1937,3661,40721,3043,2,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3670.00,NULL,NULL,1,'2021-10-04 17:52:17','2021-10-04 17:52:17',NULL),(1938,3661,40721,3043,2,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1730.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1939,3661,40721,3043,2,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1290.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1940,3661,40721,3043,2,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1690.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1941,3661,40721,3043,2,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1130.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1942,3661,40721,3043,2,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1420.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1943,3661,40721,3043,2,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',690.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1944,3661,40721,3043,2,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',360.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1945,3661,40721,3043,2,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1790.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1946,3661,40721,3043,2,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2080.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1947,3661,40721,3043,2,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1130.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL);
INSERT INTO `balance_libro` VALUES (1948,3661,40721,3043,2,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1570.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1949,3661,40721,3043,2,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2980.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1950,3661,40721,3043,2,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1970.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1951,3661,40721,3043,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1620.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1952,3661,40721,3043,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2210.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1953,3661,40721,3043,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2460.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1954,3661,40721,3043,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1520.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1955,3661,40721,3043,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2040.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1956,3661,40721,3043,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1920.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1957,3661,40721,3043,2,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2540.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1958,3661,40721,3043,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1430.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1959,3661,40721,3043,2,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1700.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1960,3661,40721,3043,2,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3080.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1961,3661,40721,3043,2,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',5030.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1962,3661,40721,3043,2,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3510.00,NULL,NULL,1,'2021-10-04 17:52:18','2021-10-04 17:52:18',NULL),(1963,3661,40721,3043,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3700.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1964,3661,40721,3043,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2710.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1965,3661,40721,3043,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',4680.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1966,3661,40721,3043,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3470.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1967,3661,40721,3043,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2450.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1968,3661,40721,3043,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1840.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL);
INSERT INTO `balance_libro` VALUES (1969,3661,40721,3043,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2480.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1970,3661,40721,3043,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1330.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1971,3661,40721,3043,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',3420.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1972,3661,40721,3043,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1810.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1973,3661,40721,3043,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1560.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1974,3661,40721,3043,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1550.64,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1975,3661,40721,3043,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1950.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1976,3661,40721,3043,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1040.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1977,3661,40721,3043,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2940.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1978,3661,40721,3043,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',930.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1979,3661,40721,3043,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1440.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1980,3661,40721,3043,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1330.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1981,3661,40721,3043,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1330.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1982,3661,40721,3043,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',690.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1983,3661,40721,3043,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',3420.00,NULL,NULL,1,'2021-10-04 17:52:19','2021-10-04 17:52:19',NULL),(1984,3661,40721,3043,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',650.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1985,3661,40721,3043,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1180.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1986,3661,40721,3043,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',3770.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1987,3661,40721,3043,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1290.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1988,3661,40721,3043,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',570.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1989,3661,40721,3043,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1810.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL);
INSERT INTO `balance_libro` VALUES (1990,3661,40721,3043,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1350.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1991,3661,40721,3043,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1810.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1992,3661,40721,3043,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1350.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1993,3661,40721,3043,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',950.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1994,3661,40721,3043,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2210.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1995,3661,40721,3043,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2550.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1996,3661,40721,3043,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1220.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1997,3661,40721,3043,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1370.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1998,3661,40721,3043,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1560.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(1999,3661,40721,3043,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1550.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(2000,3661,40721,3043,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1372.80,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(2001,3661,40721,3043,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2260.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(2002,3661,40721,3043,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',4170.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(2003,3661,40721,3043,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1270.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(2004,3661,40721,3043,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1630.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(2005,3661,40721,3043,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',5900.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(2006,3661,40721,3043,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',5830.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(2007,3661,40721,3043,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2480.00,NULL,NULL,1,'2021-10-04 17:52:20','2021-10-04 17:52:20',NULL),(2008,3661,40721,3043,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2550.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2009,3661,40721,3043,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1970.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2010,3661,40721,3043,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',3680.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL);
INSERT INTO `balance_libro` VALUES (2011,3661,40721,3043,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1210.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2012,3661,40721,3043,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1160.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2013,3661,40721,3043,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',470.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2014,3661,40721,3043,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1130.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2015,3661,40721,3043,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2260.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2016,3661,40721,3043,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2530.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2017,3661,40721,3043,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',440.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2018,3661,40721,3043,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1160.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2019,3661,40721,3043,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1380.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2020,3661,40721,3043,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',790.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2021,3661,40721,3043,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',780.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2022,3661,40721,3043,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1190.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2023,3661,40721,3043,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1130.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2024,3661,40721,3043,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1180.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2025,3661,40721,3043,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2010.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2026,3661,40721,3043,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2220.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2027,3661,40721,3043,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1130.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2028,3661,40721,3043,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2590.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2029,3661,40721,3043,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2190.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2030,3661,40721,3043,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',800.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2031,3661,40721,3043,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2940.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL);
INSERT INTO `balance_libro` VALUES (2032,3661,40721,3043,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',220.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2033,3661,40721,3043,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1920.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2034,3661,40721,3043,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',390.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2035,3661,40721,3043,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1180.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2036,3661,40721,3043,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1670.00,NULL,NULL,1,'2021-10-04 17:52:21','2021-10-04 17:52:21',NULL),(2037,3661,40721,3043,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',480.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2038,3661,40721,3043,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',270.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2039,3661,40721,3043,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1180.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2040,3661,40721,3043,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2670.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2041,3661,40721,3043,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1760.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2042,3661,40721,3043,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1400.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2043,3661,40721,3043,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2160.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2044,3661,40721,3043,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',220.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2045,3661,40721,3043,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1680.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2046,3661,40721,3043,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',390.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2047,3661,40721,3043,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2220.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2048,3661,40721,3043,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1440.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2049,3661,40721,3043,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',140.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2050,3661,40721,3043,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2770.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2051,3661,40721,3043,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1970.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2052,3661,40721,3043,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1130.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL);
INSERT INTO `balance_libro` VALUES (2053,3661,40721,3043,2,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',880.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2054,3661,40721,3043,2,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',3460.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2055,3661,40721,3043,2,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',5940.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2056,3661,40721,3043,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',4220.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2057,3661,40721,3043,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1850.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2058,3661,40721,3043,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',820.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2059,3661,40721,3043,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2770.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2060,3661,40721,3043,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2100.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2061,3661,40721,3043,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',800.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2062,3661,40721,3043,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1090.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2063,3661,40721,3043,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',360.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2064,3661,40721,3043,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1970.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2065,3661,40721,3043,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2390.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2066,3661,40721,3043,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1350.00,NULL,NULL,1,'2021-10-04 17:52:22','2021-10-04 17:52:22',NULL),(2067,3661,40721,3043,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1970.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2068,3661,40721,3043,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2940.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2069,3661,40721,3043,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1740.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2070,3661,40721,3043,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2870.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2071,3661,40721,3043,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1630.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2072,3661,40721,3043,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',660.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2073,3661,40721,3043,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1150.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL);
INSERT INTO `balance_libro` VALUES (2074,3661,40721,3043,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',220.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2075,3661,40721,3043,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1120.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2076,3661,40721,3043,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',880.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2077,3661,40721,3043,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1600.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2078,3661,40721,3043,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',3820.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2079,3661,40721,3043,2,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1420.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2080,3661,40721,3043,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1070.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2081,3661,40721,3043,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1910.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2082,3661,40721,3043,2,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1420.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2083,3661,40721,3043,2,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',440.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2084,3661,40721,3043,2,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1130.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2085,3661,40721,3043,2,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',980.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2086,3661,40721,3043,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1290.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2087,3661,40721,3043,2,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',440.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2088,3661,40721,3043,2,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2070.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2089,3661,40721,3043,2,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1930.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2090,3661,40721,3043,2,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1180.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2091,3661,40721,3043,2,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1450.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2092,3661,40721,3043,2,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',890.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2093,3661,40721,3043,2,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',890.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2094,3661,40721,3043,2,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',690.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL);
INSERT INTO `balance_libro` VALUES (2095,3661,40721,3043,2,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2340.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2096,3661,40721,3043,2,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',4220.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2097,3661,40721,3043,2,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2110.00,NULL,NULL,1,'2021-10-04 17:52:23','2021-10-04 17:52:23',NULL),(2098,3661,40721,3043,2,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1130.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2099,3661,40721,3043,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2020.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2100,3661,40721,3043,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',4690.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2101,3661,40721,3043,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1630.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2102,3661,40721,3043,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2330.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2103,3661,40721,3043,2,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2020.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2104,3661,40721,3043,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1850.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2105,3661,40721,3043,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1980.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2106,3661,40721,3043,2,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',690.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2107,3661,40721,3043,2,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1160.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2108,3661,40721,3043,2,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1880.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2109,3661,40721,3043,2,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2250.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2110,3661,40721,3043,2,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1670.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2111,3661,40721,3043,2,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2380.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2112,3661,40721,3043,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2070.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2113,3661,40721,3043,2,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1044.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2114,3661,40721,3043,2,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1600.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2115,3661,40721,3043,2,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2530.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL);
INSERT INTO `balance_libro` VALUES (2116,3661,40721,3043,2,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1160.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2117,3661,40721,3043,2,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1220.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2118,3661,40721,3043,2,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1440.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2119,3661,40721,3043,2,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1620.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2120,3661,40721,3043,2,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1570.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2121,3661,40721,3043,2,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2240.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2122,3661,40721,3043,2,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1380.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2123,3661,40721,3043,2,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1070.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2124,3661,40721,3043,2,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',4930.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2125,3661,40721,3043,2,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1330.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2126,3661,40721,3043,2,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1390.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2127,3661,40721,3043,2,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2010.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2128,3661,40721,3043,2,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1330.00,NULL,NULL,1,'2021-10-04 17:52:24','2021-10-04 17:52:24',NULL),(2129,3661,40721,3043,2,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1600.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2130,3661,40721,3043,2,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',1130.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2131,3661,40721,3043,2,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',2190.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2132,3661,40721,3043,2,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1750.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2133,3661,40721,3043,2,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',880.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2134,3661,40721,3043,2,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2400.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2135,3661,40721,3043,2,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',609.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2136,3661,40721,3043,2,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2080.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL);
INSERT INTO `balance_libro` VALUES (2137,3661,40721,3043,2,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2060.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2138,3661,40721,3043,2,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1350.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2139,3661,40721,3043,2,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1220.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2140,3661,40721,3043,2,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1420.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2141,3661,40721,3043,2,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1220.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2142,3661,40721,3043,2,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1130.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2143,3661,40721,3043,2,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',2860.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2144,3661,40721,3043,2,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1420.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2145,3661,40721,3043,2,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1270.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2146,3661,40721,3043,2,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',2600.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2147,3661,40721,3043,2,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',690.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2148,3661,40721,3043,2,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1570.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2149,3661,40721,3043,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1380.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2150,3661,40721,3043,2,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1230.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2151,3661,40721,3043,2,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1330.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2152,3661,40721,3043,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',690.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2153,3661,40721,3043,2,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',890.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2154,3661,40721,3043,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3180.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2155,3661,40721,3043,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',915.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2156,3661,40721,3043,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3670.00,NULL,NULL,1,'2021-10-04 17:52:25','2021-10-04 17:52:25',NULL),(2157,3661,40721,3043,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1160.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL);
INSERT INTO `balance_libro` VALUES (2158,3661,40721,3043,2,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3640.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2159,3661,40721,3043,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',2290.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2160,3661,40721,3043,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',6320.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2161,3661,40721,3043,2,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3400.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2162,3661,40721,3043,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',2270.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2163,3661,40721,3043,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',980.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2164,3661,40721,3043,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1130.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2165,3661,40721,3043,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2320.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2166,3661,40721,3043,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1330.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2167,3661,40721,3043,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',690.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2168,3661,40721,3043,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1820.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2169,3661,40721,3043,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',690.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2170,3661,40721,3043,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1130.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2171,3661,40721,3043,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1130.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2172,3661,40721,3043,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',720.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2173,3661,40721,3043,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1380.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2174,3661,40721,3043,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3460.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2175,3661,40721,3043,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2050.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2176,3661,40721,3043,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',360.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2177,3661,40721,3043,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1070.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2178,3661,40721,3043,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3010.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL);
INSERT INTO `balance_libro` VALUES (2179,3661,40721,3043,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1750.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2180,3661,40721,3043,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',8420.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2181,3661,40721,3043,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1570.00,NULL,NULL,1,'2021-10-04 17:52:26','2021-10-04 17:52:26',NULL),(2182,3661,40721,3043,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1490.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2183,3661,40721,3043,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',4010.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2184,3661,40721,3043,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1900.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2185,3661,40721,3043,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2920.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2186,3661,40721,3043,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',7540.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2187,3661,40721,3043,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',970.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2188,3661,40721,3043,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2960.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2189,3661,40721,3043,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1130.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2190,3661,40721,3043,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',3820.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2191,3661,40721,3043,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1120.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2192,3661,40721,3043,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1180.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2193,3661,40721,3043,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1330.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2194,3661,40721,3043,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1130.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2195,3661,40721,3043,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1130.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2196,3661,40721,3043,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',2710.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2197,3661,40721,3043,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',18.50,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2198,3661,40721,3043,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',2430.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2199,3661,40721,3043,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',690.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL);
INSERT INTO `balance_libro` VALUES (2200,3661,40721,3043,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',820.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2201,3661,40721,3043,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1920.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2202,3661,40721,3043,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1070.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2203,3661,40721,3043,2,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',3910.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2204,3661,40721,3043,2,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1920.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2205,3661,40721,3043,2,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',3820.00,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2206,3661,40721,3043,2,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1.27,NULL,NULL,1,'2021-10-04 17:52:27','2021-10-04 17:52:27',NULL),(2207,3661,40721,3043,2,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',4260.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2208,3661,40721,3043,2,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',2270.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2209,3661,40721,3043,2,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',2410.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2210,3661,40721,3043,2,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',690.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2211,3661,40721,3043,2,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1130.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2212,3661,40721,3043,2,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1180.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2213,3661,40721,3043,2,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1570.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2214,3661,40721,3043,2,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1790.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2215,3661,40721,3043,2,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',5460.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2216,3661,40721,3043,2,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1610.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2217,3661,40721,3043,2,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1650.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2218,3661,40721,3043,2,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1480.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2219,3661,40721,3043,2,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',440.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2220,3661,40721,3043,2,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',950.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL);
INSERT INTO `balance_libro` VALUES (2221,3661,40721,3043,2,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1630.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2222,3661,40721,3043,2,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1000.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2223,3661,40721,3043,2,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1070.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2224,3661,40721,3043,2,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1130.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2225,3661,40721,3043,2,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1670.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2226,3661,40721,3043,2,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',440.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2227,3661,40721,3043,2,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',890.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2228,3661,40721,3043,2,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',690.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2229,3661,40721,3043,2,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',440.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2230,3661,40721,3043,2,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',2280.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2231,3661,40721,3043,2,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',950.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2232,3661,40721,3043,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1130.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2233,3661,40721,3043,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1160.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2234,3661,40721,3043,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',2310.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2235,3661,40721,3043,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1160.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2236,3661,40721,3043,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',260.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2237,3661,40721,3043,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1130.00,NULL,NULL,1,'2021-10-04 17:52:28','2021-10-04 17:52:28',NULL),(2238,3661,40721,3043,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',260.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2239,3661,40721,3043,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1040.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2240,3661,40721,3043,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2160.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2241,3661,40721,3043,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',1880.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL);
INSERT INTO `balance_libro` VALUES (2242,3661,40721,3043,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',660.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2243,3661,40721,3043,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',1980.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2244,3661,40721,3043,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2380.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2245,3661,40721,3043,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1990.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2246,3661,40721,3043,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',2510.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2247,3661,40721,3043,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1420.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2248,3661,40721,3043,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1490.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2249,3661,40721,3043,2,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',690.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2250,3661,40721,3043,2,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',440.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2251,3661,40721,3043,2,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',2400.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2252,3661,40721,3043,2,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1420.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2253,3661,40721,3043,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1990.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2254,3661,40721,3043,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',720.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2255,3661,40721,3043,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',950.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2256,3661,40721,3043,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1130.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2257,3661,40721,3043,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1450.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2258,3661,40721,3043,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1600.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2259,3661,40721,3043,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',690.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2260,3661,40721,3043,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',690.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2261,3661,40721,3043,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',690.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2262,3661,40721,3043,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',890.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL);
INSERT INTO `balance_libro` VALUES (2263,3661,40721,3043,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',2260.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2264,3661,40721,3043,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',690.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2265,3661,40721,3043,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',220.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2266,3661,40721,3043,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',690.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2267,3661,40721,3043,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',220.00,NULL,NULL,1,'2021-10-04 17:52:29','2021-10-04 17:52:29',NULL),(2268,3661,40721,3043,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1130.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2269,3661,40721,3043,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1900.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2270,3661,40721,3043,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',3160.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2271,3661,40721,3043,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',7110.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2272,3661,40721,3043,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',2500.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2273,3661,40721,3043,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',2030.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2274,3661,40721,3043,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1400.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2275,3661,40721,3043,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',2590.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2276,3661,40721,3043,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1580.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2277,3661,40721,3043,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1570.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2278,3661,40721,3043,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2040.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2279,3661,40721,3043,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2750.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2280,3661,40721,3043,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2750.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2281,3661,40721,3043,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',600.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2282,3661,40721,3043,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2040.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2283,3661,40721,3043,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2040.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL);
INSERT INTO `balance_libro` VALUES (2284,3661,40721,3043,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1460.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2285,3661,40721,3043,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1960.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2286,3661,40721,3043,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1980.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2287,3661,40721,3043,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1130.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2288,3661,40721,3043,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1130.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2289,3661,40721,3043,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1390.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2290,3661,40721,3043,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1270.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2291,3661,40721,3043,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2750.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2292,3661,40721,3043,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',6000.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2293,3661,40721,3043,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',3330.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2294,3661,40721,3043,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2740.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2295,3661,40721,3043,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2750.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2296,3661,40721,3043,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1290.00,NULL,NULL,1,'2021-10-04 17:52:30','2021-10-04 17:52:30',NULL),(2297,3661,40721,3043,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',4350.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2298,3661,40721,3043,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1070.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2299,3661,40721,3043,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',950.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2300,3661,40721,3043,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1070.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2301,3661,40721,3043,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1180.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2302,3661,40721,3043,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1180.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2303,3661,40721,3043,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',630.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2304,3661,40721,3043,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1000.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL);
INSERT INTO `balance_libro` VALUES (2305,3661,40721,3043,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',2180.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2306,3661,40721,3043,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',2680.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2307,3661,40721,3043,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1290.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2308,3661,40721,3043,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1070.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2309,3661,40721,3043,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',2180.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2310,3661,40721,3043,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1010.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2311,3661,40721,3043,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1180.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2312,3661,40721,3043,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',4420.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2313,3661,40721,3043,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',550.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2314,3661,40721,3043,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1130.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2315,3661,40721,3043,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',1590.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2316,3661,40721,3043,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',4790.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2317,3661,40721,3043,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2680.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2318,3661,40721,3043,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2460.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2319,3661,40721,3043,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2260.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2320,3661,40721,3043,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',680.10,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2321,3661,40721,3043,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',0.78,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2322,3661,40721,3043,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',780.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2323,3661,40721,3043,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',880.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2324,3661,40721,3043,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',1180.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL),(2325,3661,40721,3043,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',880.00,NULL,NULL,1,'2021-10-04 17:52:31','2021-10-04 17:52:31',NULL);
INSERT INTO `balance_libro` VALUES (2326,3661,40721,3043,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',130.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2327,3661,40721,3043,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',560.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2328,3661,40721,3043,2,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',950.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2329,3661,40721,3043,2,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2240.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2330,3661,40721,3043,2,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2820.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2331,3661,40721,3043,2,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',1850.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2332,3661,40721,3043,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',280.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2333,3661,40721,3043,2,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',3020.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2334,3661,40721,3043,2,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',1670.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2335,3661,40721,3043,2,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2260.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2336,3661,40721,3043,2,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',3550.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2337,3661,40721,3043,2,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2740.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2338,3661,40721,3043,2,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',830.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2339,3661,40721,3043,2,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2850.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2340,3661,40721,3043,2,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2880.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2341,3661,40721,3043,2,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',660.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2342,3661,40721,3043,2,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2310.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2343,3661,40721,3043,2,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',1410.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2344,3661,40721,3043,2,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',1830.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2345,3661,40721,3043,2,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',1490.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2346,3661,40721,3043,2,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2680.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL);
INSERT INTO `balance_libro` VALUES (2347,3661,40721,3043,2,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2680.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2348,3661,40721,3043,2,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',692.91,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2349,3661,40721,3043,2,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',880.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2350,3661,40721,3043,2,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1240.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2351,3661,40721,3043,2,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',880.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2352,3661,40721,3043,2,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1130.50,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2353,3661,40721,3043,2,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1130.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2354,3661,40721,3043,2,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',2170.00,NULL,NULL,1,'2021-10-04 17:52:32','2021-10-04 17:52:32',NULL),(2355,3661,40721,3043,2,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1870.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2356,3661,40721,3043,2,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',730.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2357,3661,40721,3043,2,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1490.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2358,3661,40721,3043,2,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',2860.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2359,3661,40721,3043,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1680.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2360,3661,40721,3043,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1160.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2361,3661,40721,3043,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1350.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2362,3661,40721,3043,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1280.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2363,3661,40721,3043,2,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',2270.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2364,3661,40721,3043,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1520.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2365,3661,40721,3043,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1330.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2366,3661,40721,3043,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1270.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2367,3661,40721,3043,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1270.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL);
INSERT INTO `balance_libro` VALUES (2368,3661,40721,3043,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',780.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2369,3661,40721,3043,2,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',780.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2370,3661,40721,3043,2,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',780.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2371,3661,40721,3043,2,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1351.50,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2372,3661,40721,3043,2,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1150.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2373,3661,40721,3043,2,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',612.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2374,3661,40721,3043,2,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',5057.50,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2375,3661,40721,3043,2,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',2740.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2376,3661,40721,3043,2,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1270.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2377,3661,40721,3043,2,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',780.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2378,3661,40721,3043,2,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1270.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2379,3661,40721,3043,2,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',780.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2380,3661,40721,3043,2,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',780.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2381,3661,40721,3043,2,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1910.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2382,3661,40721,3043,2,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1380.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2383,3661,40721,3043,2,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1870.00,NULL,NULL,1,'2021-10-04 17:52:33','2021-10-04 17:52:33',NULL),(2384,3661,40721,3043,2,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1350.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2385,3661,40721,3043,2,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1827.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2386,3661,40721,3043,2,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1380.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2387,3661,40721,3043,2,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1870.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2388,3661,40721,3043,2,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',1330.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL);
INSERT INTO `balance_libro` VALUES (2389,3661,40721,3043,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',360.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2390,3661,40721,3043,2,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',1270.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2391,3661,40721,3043,2,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',2230.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2392,3661,40721,3043,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',3020.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2393,3661,40721,3043,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',1070.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2394,3661,40721,3043,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',1260.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2395,3661,40721,3043,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1440.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2396,3661,40721,3043,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',390.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2397,3661,40721,3043,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',0.10,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2398,3661,40721,3043,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',2020.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2399,3661,40721,3043,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',690.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2400,3661,40721,3043,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1180.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2401,3661,40721,3043,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1270.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2402,3661,40721,3043,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',2450.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2403,3661,40721,3043,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',5211.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2404,3661,40721,3043,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',390.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2405,3661,40721,3043,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',1180.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2406,3661,40721,3043,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',1610.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2407,3661,40721,3043,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',1460.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2408,3661,40721,3043,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',9290.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2409,3661,40721,3043,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',1180.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL);
INSERT INTO `balance_libro` VALUES (2410,3661,40721,3043,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1420.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2411,3661,40721,3043,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1330.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2412,3661,40721,3043,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1270.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2413,3661,40721,3043,2,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',890.00,NULL,NULL,1,'2021-10-04 17:52:34','2021-10-04 17:52:34',NULL),(2414,3661,40721,3043,2,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1420.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2415,3661,40721,3043,2,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1317.50,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2416,3661,40721,3043,2,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',780.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2417,3661,40721,3043,2,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1270.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2418,3661,40721,3043,2,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1420.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2419,3661,40721,3043,2,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',780.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2420,3661,40721,3043,2,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',780.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2421,3661,40721,3043,2,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',690.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2422,3661,40721,3043,2,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',380.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2423,3661,40721,3043,2,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1130.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2424,3661,40721,3043,2,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1270.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2425,3661,40721,3043,2,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1390.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2426,3661,40721,3043,2,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',2050.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2427,3661,40721,3043,2,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1490.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2428,3661,40721,3043,2,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1620.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2429,3661,40721,3043,2,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1130.00,NULL,NULL,1,'2021-10-04 17:52:35','2021-10-04 17:52:35',NULL),(2430,3661,40721,3043,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2703.14,NULL,NULL,1,'2021-10-04 17:53:07','2021-10-04 17:53:07',NULL);
INSERT INTO `balance_libro` VALUES (2431,3661,40721,3043,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',5052.09,NULL,NULL,1,'2021-10-04 17:53:07','2021-10-04 17:53:07',NULL),(2432,3661,40721,3043,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',67565.47,NULL,NULL,1,'2021-10-04 17:53:07','2021-10-04 17:53:07',NULL),(2433,3661,40721,3043,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',67051.81,NULL,NULL,1,'2021-10-04 17:53:07','2021-10-04 17:53:07',NULL),(2434,3661,40721,3043,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1948.39,NULL,NULL,1,'2021-10-04 17:53:07','2021-10-04 17:53:07',NULL),(2435,3661,40721,3043,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',4543.45,NULL,NULL,1,'2021-10-04 17:53:07','2021-10-04 17:53:07',NULL),(2436,3661,40721,3043,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',56718.45,NULL,NULL,1,'2021-10-04 17:53:07','2021-10-04 17:53:07',NULL),(2437,3661,40721,3043,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',4770.56,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2438,3661,40721,3043,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3085.21,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2439,3661,40721,3043,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',240.68,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2440,3661,40721,3043,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',71283.37,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2441,3661,40721,3043,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',39098.77,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2442,3661,40721,3043,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',0.00,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2443,3661,40721,3043,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',5032.89,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2444,3661,40721,3043,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',3984.54,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2445,3661,40721,3043,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',295.47,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2446,3661,40721,3043,3,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',67371.12,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2447,3661,40721,3043,3,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',7539.15,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2448,3661,40721,3043,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',10952.44,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2449,3661,40721,3043,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',17670.00,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2450,3661,40721,3043,3,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',12460.90,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2451,3661,40721,3043,3,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',12460.90,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL);
INSERT INTO `balance_libro` VALUES (2452,3661,40721,3043,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',21180.89,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2453,3661,40721,3043,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3026.22,NULL,NULL,1,'2021-10-04 17:53:08','2021-10-04 17:53:08',NULL),(2454,3661,40721,3043,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',164.91,NULL,NULL,1,'2021-10-04 17:53:09','2021-10-04 17:53:09',NULL),(2455,3661,40721,3043,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',88396.52,NULL,NULL,1,'2021-10-04 17:53:09','2021-10-04 17:53:09',NULL),(2456,3661,40721,3043,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',962.70,NULL,NULL,1,'2021-10-04 17:53:09','2021-10-04 17:53:09',NULL),(2457,3661,40721,3043,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',51490.79,NULL,NULL,1,'2021-10-04 17:53:09','2021-10-04 17:53:09',NULL),(2458,3661,40721,3043,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',9381.63,NULL,NULL,1,'2021-10-04 17:53:09','2021-10-04 17:53:09',NULL),(2459,3661,40721,3044,2,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',690.00,NULL,NULL,1,'2021-10-04 17:54:24','2021-10-04 17:54:24',NULL),(2460,3661,40721,3044,2,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2110.00,NULL,NULL,1,'2021-10-04 17:54:24','2021-10-04 17:54:24',NULL),(2461,3661,40721,3044,2,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1220.00,NULL,NULL,1,'2021-10-04 17:54:24','2021-10-04 17:54:24',NULL),(2462,3661,40721,3044,2,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1420.00,NULL,NULL,1,'2021-10-04 17:54:24','2021-10-04 17:54:24',NULL),(2463,3661,40721,3044,2,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1180.00,NULL,NULL,1,'2021-10-04 17:54:24','2021-10-04 17:54:24',NULL),(2464,3661,40721,3044,2,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',990.00,NULL,NULL,1,'2021-10-04 17:54:24','2021-10-04 17:54:24',NULL),(2465,3661,40721,3044,2,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1260.00,NULL,NULL,1,'2021-10-04 17:54:24','2021-10-04 17:54:24',NULL),(2466,3661,40721,3044,2,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1310.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2467,3661,40721,3044,2,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',970.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2468,3661,40721,3044,2,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',2277.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2469,3661,40721,3044,2,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',2240.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2470,3661,40721,3044,2,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2471,3661,40721,3044,2,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',690.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2472,3661,40721,3044,2,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3740.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL);
INSERT INTO `balance_libro` VALUES (2473,3661,40721,3044,2,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1380.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2474,3661,40721,3044,2,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1950.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2475,3661,40721,3044,2,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',2170.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2476,3661,40721,3044,2,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1290.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2477,3661,40721,3044,2,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',2140.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2478,3661,40721,3044,2,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',1064.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2479,3661,40721,3044,2,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',810.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2480,3661,40721,3044,2,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',720.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2481,3661,40721,3044,2,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1650.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2482,3661,40721,3044,2,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',780.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2483,3661,40721,3044,2,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',690.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2484,3661,40721,3044,2,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',4130.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2485,3661,40721,3044,2,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',1810.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2486,3661,40721,3044,2,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1136.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2487,3661,40721,3044,2,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',720.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2488,3661,40721,3044,2,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',990.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2489,3661,40721,3044,2,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',690.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2490,3661,40721,3044,2,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1350.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2491,3661,40721,3044,2,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',2010.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2492,3661,40721,3044,2,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1590.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2493,3661,40721,3044,2,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',1270.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL);
INSERT INTO `balance_libro` VALUES (2494,3661,40721,3044,2,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',1900.00,NULL,NULL,1,'2021-10-04 17:54:25','2021-10-04 17:54:25',NULL),(2495,3661,40721,3044,2,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',1900.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2496,3661,40721,3044,2,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',1180.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2497,3661,40721,3044,2,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',3110.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2498,3661,40721,3044,2,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',2020.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2499,3661,40721,3044,2,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1270.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2500,3661,40721,3044,2,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1440.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2501,3661,40721,3044,2,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1300.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2502,3661,40721,3044,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1790.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2503,3661,40721,3044,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1390.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2504,3661,40721,3044,2,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',1290.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2505,3661,40721,3044,2,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',1650.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2506,3661,40721,3044,2,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',1550.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2507,3661,40721,3044,2,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2508,3661,40721,3044,2,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1310.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2509,3661,40721,3044,2,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',950.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2510,3661,40721,3044,2,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1330.00,NULL,NULL,1,'2021-10-04 17:54:26','2021-10-04 17:54:26',NULL),(2511,3661,40721,3044,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',4252.00,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2512,3661,40721,3044,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2703.14,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2513,3661,40721,3044,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',7913.05,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2514,3661,40721,3044,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',498.12,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL);
INSERT INTO `balance_libro` VALUES (2515,3661,40721,3044,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',76999.30,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2516,3661,40721,3044,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',21152.67,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2517,3661,40721,3044,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6226.88,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2518,3661,40721,3044,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',15162.43,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2519,3661,40721,3044,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',952.22,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2520,3661,40721,3044,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',74191.32,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2521,3661,40721,3044,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2036.24,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2522,3661,40721,3044,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',29153.37,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2523,3661,40721,3044,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1131.29,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2524,3661,40721,3044,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',10405.71,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2525,3661,40721,3044,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',10312.75,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2526,3661,40721,3044,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',94994.54,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2527,3661,40721,3044,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',571.42,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2528,3661,40721,3044,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',42108.00,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2529,3661,40721,3044,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',51504.53,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2530,3661,40721,3044,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',7493.64,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2531,3661,40721,3044,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',0.00,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2532,3661,40721,3044,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',13565.23,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2533,3661,40721,3044,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',822.68,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2534,3661,40721,3044,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',83244.33,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2535,3661,40721,3044,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',25490.84,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL);
INSERT INTO `balance_libro` VALUES (2536,3661,40721,3044,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',2254.84,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2537,3661,40721,3044,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3396.00,NULL,NULL,1,'2021-10-04 17:55:30','2021-10-04 17:55:30',NULL),(2538,3661,40723,6080,2,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',116150.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2539,3661,40723,6080,2,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',16425.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2540,3661,40723,6080,2,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',15086.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2541,3661,40723,6080,2,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',10390.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2542,3661,40723,6080,2,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',10390.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2543,3661,40723,6080,2,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',5445.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2544,3661,40723,6080,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',10390.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2545,3661,40723,6080,2,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',13206.50,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2546,3661,40723,6080,2,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',5445.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2547,3661,40723,6080,2,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',5445.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2548,3661,40723,6080,2,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',16335.00,NULL,NULL,1,'2021-10-21 12:56:30','2021-10-21 12:56:30',NULL),(2549,3661,40723,6080,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',35994.00,NULL,NULL,1,'2021-10-21 13:03:54','2021-10-21 13:03:54',NULL),(2550,3661,40723,6080,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',28193.99,NULL,NULL,1,'2021-10-21 13:03:54','2021-10-21 13:03:54',NULL),(2551,3661,40723,6080,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',28193.99,NULL,NULL,1,'2021-10-21 13:03:54','2021-10-21 13:03:54',NULL),(2552,3661,40723,6080,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',21134.08,NULL,NULL,1,'2021-10-21 13:03:54','2021-10-21 13:03:54',NULL),(2553,3661,40723,6080,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',16980.00,NULL,NULL,1,'2021-10-21 13:03:54','2021-10-21 13:03:54',NULL),(2554,3661,40723,6080,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',8000.00,NULL,NULL,1,'2021-10-21 13:03:54','2021-10-21 13:03:54',NULL),(2555,3661,40723,6080,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',22389.66,NULL,NULL,1,'2021-10-21 13:03:55','2021-10-21 13:03:55',NULL),(2556,3661,40723,6080,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',61952.00,NULL,NULL,1,'2021-10-21 13:03:55','2021-10-21 13:03:55',NULL);
INSERT INTO `balance_libro` VALUES (2557,3661,40723,6080,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',21164.16,NULL,NULL,1,'2021-10-21 13:03:55','2021-10-21 13:03:55',NULL),(2558,3661,40723,6080,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10228.01,NULL,NULL,1,'2021-10-21 13:03:55','2021-10-21 13:03:55',NULL),(2559,3661,40723,6080,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10228.01,NULL,NULL,1,'2021-10-21 13:03:55','2021-10-21 13:03:55',NULL),(2560,3661,40723,6080,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10228.01,NULL,NULL,1,'2021-10-21 13:03:55','2021-10-21 13:03:55',NULL),(2561,3661,40723,6072,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',5799.52,NULL,NULL,1,'2021-10-21 14:06:49','2021-10-21 14:06:49',NULL),(2562,3661,40723,6072,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',190299.00,NULL,NULL,1,'2021-10-21 14:07:45','2021-10-21 14:07:45',NULL),(2563,3661,40723,6072,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',5999.00,NULL,NULL,1,'2021-10-21 14:08:26','2021-10-21 14:08:26',NULL),(2564,3661,40723,6073,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-14','2021-02-14',5799.52,NULL,NULL,1,'2021-10-21 14:23:17','2021-10-21 14:23:17',NULL),(2565,3661,40723,6073,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',3000.00,NULL,NULL,1,'2021-10-21 14:23:46','2021-10-21 14:23:46',NULL),(2566,3661,40721,3049,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',2390.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2567,3661,40721,3049,2,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1350.02,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2568,3661,40721,3049,2,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',0.10,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2569,3661,40721,3049,2,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1650.01,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2570,3661,40721,3049,2,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',3250.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2571,3661,40721,3049,2,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1650.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2572,3661,40721,3049,2,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',80.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2573,3661,40721,3049,2,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1870.02,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2574,3661,40721,3049,2,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',910.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2575,3661,40721,3049,2,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1590.02,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2576,3661,40721,3049,2,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',1416.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2577,3661,40721,3049,2,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1920.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL);
INSERT INTO `balance_libro` VALUES (2578,3661,40721,3049,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2050.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2579,3661,40721,3049,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',3710.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2580,3661,40721,3049,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',1450.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2581,3661,40721,3049,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',1870.02,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2582,3661,40721,3049,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',3120.04,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2583,3661,40721,3049,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',1870.02,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2584,3661,40721,3049,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',3250.04,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2585,3661,40721,3049,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',1650.02,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2586,3661,40721,3049,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',1550.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2587,3661,40721,3049,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',80.00,NULL,NULL,1,'2021-10-21 17:07:49','2021-10-21 17:07:49',NULL),(2588,3661,40721,3049,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',3250.00,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2589,3661,40721,3049,2,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',1.90,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2590,3661,40721,3049,2,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1100.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2591,3661,40721,3049,2,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',960.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2592,3661,40721,3049,2,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1672.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2593,3661,40721,3049,2,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1590.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2594,3661,40721,3049,2,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1650.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2595,3661,40721,3049,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1590.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2596,3661,40721,3049,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1568.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2597,3661,40721,3049,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1100.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2598,3661,40721,3049,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',2630.04,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL);
INSERT INTO `balance_libro` VALUES (2599,3661,40721,3049,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1100.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2600,3661,40721,3049,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1010.00,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2601,3661,40721,3049,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1770.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2602,3661,40721,3049,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1590.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2603,3661,40721,3049,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1592.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2604,3661,40721,3049,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1010.00,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2605,3661,40721,3049,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1870.03,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2606,3661,40721,3049,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1590.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2607,3661,40721,3049,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1550.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2608,3661,40721,3049,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',840.00,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2609,3661,40721,3049,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1870.02,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2610,3661,40721,3049,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1870.01,NULL,NULL,1,'2021-10-21 17:07:50','2021-10-21 17:07:50',NULL),(2611,3661,40721,3049,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1870.02,NULL,NULL,1,'2021-10-21 17:07:51','2021-10-21 17:07:51',NULL),(2612,3661,40721,3049,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1490.02,NULL,NULL,1,'2021-10-21 17:07:51','2021-10-21 17:07:51',NULL),(2613,3661,40721,3049,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1010.00,NULL,NULL,1,'2021-10-21 17:07:51','2021-10-21 17:07:51',NULL),(2614,3661,40721,3049,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',430.00,NULL,NULL,1,'2021-10-21 17:07:51','2021-10-21 17:07:51',NULL),(2615,3661,40721,3049,3,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',7500.00,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2616,3661,40721,3049,3,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3800.00,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2617,3661,40721,3049,3,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3298.94,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2618,3661,40721,3049,3,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',15910.44,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2619,3661,40721,3049,3,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',10088.18,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL);
INSERT INTO `balance_libro` VALUES (2620,3661,40721,3049,3,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',43334.14,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2621,3661,40721,3049,3,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',10914.88,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2622,3661,40721,3049,3,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',757.96,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2623,3661,40721,3049,3,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',114847.41,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2624,3661,40721,3049,3,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',21004.15,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2625,3661,40721,3049,3,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',9427.95,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2626,3661,40721,3049,3,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3460.86,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2627,3661,40721,3049,3,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',9427.95,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2628,3661,40721,3049,3,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',54863.17,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2629,3661,40721,3049,3,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',6199.96,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2630,3661,40721,3049,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',18124.10,NULL,NULL,1,'2021-10-21 17:08:21','2021-10-21 17:08:21',NULL),(2631,3661,40721,3049,3,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',7560.08,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2632,3661,40721,3049,3,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',417.74,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2633,3661,40721,3049,3,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',113159.88,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2634,3661,40721,3049,3,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',17188.48,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2635,3661,40721,3049,3,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',42108.00,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2636,3661,40721,3049,3,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',24007.12,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2637,3661,40721,3049,3,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',11148.40,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2638,3661,40721,3049,3,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',10699.30,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2639,3661,40721,3049,3,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',594.03,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2640,3661,40721,3049,3,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',117112.39,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL);
INSERT INTO `balance_libro` VALUES (2641,3661,40721,3049,3,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',26968.40,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2642,3661,40721,3049,3,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',4682.70,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2643,3661,40721,3049,3,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',23168.66,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2644,3661,40721,3049,3,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',12621.75,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2645,3661,40721,3049,3,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',690.14,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2646,3661,40721,3049,3,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',112123.40,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2647,3661,40721,3049,3,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',23369.33,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2648,3661,40721,3049,3,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',864.00,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2649,3661,40721,3049,3,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',51626.48,NULL,NULL,1,'2021-10-21 17:08:22','2021-10-21 17:08:22',NULL),(2650,3661,40720,1538,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',11511.94,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2651,3661,40720,1538,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',52357.30,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2652,3661,40720,1538,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',17651.48,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2653,3661,40720,1538,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',720.60,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2654,3661,40720,1538,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',12567.66,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2655,3661,40720,1538,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',720.60,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2656,3661,40720,1538,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',4722.02,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2657,3661,40720,1538,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',11375.21,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2658,3661,40720,1538,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',13824.86,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2659,3661,40720,1538,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',25867.38,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2660,3661,40720,1538,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',20634.74,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2661,3661,40720,1538,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',26773.67,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL);
INSERT INTO `balance_libro` VALUES (2662,3661,40720,1538,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1113.00,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2663,3661,40720,1538,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',6378.01,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2664,3661,40720,1538,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',6378.01,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2665,3661,40720,1538,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',51530.88,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2666,3661,40720,1538,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',10947.47,NULL,NULL,1,'2021-10-22 08:34:05','2021-10-22 08:34:05',NULL),(2667,3661,40720,1538,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',142032.82,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2668,3661,40720,1538,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',10312.83,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2669,3661,40720,1538,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',5799.53,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2670,3661,40720,1538,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',24362.74,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2671,3661,40720,1538,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',20024.89,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2672,3661,40720,1538,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',20904.56,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2673,3661,40720,1538,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',10234.18,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2674,3661,40720,1538,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',21232.48,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2675,3661,40720,1538,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',17224.52,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2676,3661,40720,1538,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',15191.55,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2677,3661,40720,1538,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',27903.21,NULL,NULL,1,'2021-10-22 08:34:06','2021-10-22 08:34:06',NULL),(2678,3661,40720,1538,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',2086.00,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2679,3661,40720,1538,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',2829.00,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2680,3661,40720,1538,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',9956.00,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2681,3661,40720,1538,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',2255.00,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2682,3661,40720,1538,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',4189.00,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL);
INSERT INTO `balance_libro` VALUES (2683,3661,40720,1538,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',6163.00,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2684,3661,40720,1538,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',720.60,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2685,3661,40720,1538,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',3567.60,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2686,3661,40720,1538,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',9638.00,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2687,3661,40720,1538,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',3150.01,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2688,3661,40720,1538,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',2451.00,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2689,3661,40720,1538,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',3075.00,NULL,NULL,1,'2021-10-22 08:34:49','2021-10-22 08:34:49',NULL),(2690,3661,40720,1538,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',7646.99,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2691,3661,40720,1538,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',5078.28,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2692,3661,40720,1538,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',4848.01,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2693,3661,40720,1538,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',4083.99,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2694,3661,40720,1538,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',4083.99,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2695,3661,40720,1538,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',2042.00,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2696,3661,40720,1538,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',3736.00,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2697,3661,40720,1538,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',1552.32,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2698,3661,40720,1538,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',2042.00,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2699,3661,40720,1538,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',2042.00,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2700,3661,40720,1538,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',8945.00,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2701,3661,40720,1538,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1167.00,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2702,3661,40720,1538,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',12176.92,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL),(2703,3661,40720,1538,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5679.00,NULL,NULL,1,'2021-10-22 08:34:50','2021-10-22 08:34:50',NULL);
INSERT INTO `balance_libro` VALUES (2704,3661,40720,1538,3,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',2844.01,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2705,3661,40720,1538,3,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',261.42,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2706,3661,40720,1538,3,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',6655.61,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2707,3661,40720,1538,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',2904.00,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2708,3661,40720,1538,3,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',0.00,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2709,3661,40720,1538,3,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',801.00,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2710,3661,40720,1538,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',3621.69,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2711,3661,40720,1538,3,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',25000.00,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2712,3661,40720,1538,3,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',7623.00,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2713,3661,40720,1538,3,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',6860.70,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2714,3661,40720,1538,3,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',6860.70,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2715,3661,40720,1538,3,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',8088.85,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2716,3661,40720,1538,3,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',7623.00,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2717,3661,40720,1538,3,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1414.18,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2718,3661,40720,1538,3,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2825.43,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2719,3661,40720,1538,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2500.01,NULL,NULL,1,'2021-10-22 08:35:15','2021-10-22 08:35:15',NULL),(2720,3661,40722,4565,2,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',41834.32,NULL,NULL,1,'2021-10-22 09:17:20','2021-10-22 09:17:20',NULL),(2721,3661,40722,4565,2,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',2315.00,NULL,NULL,1,'2021-10-22 09:17:20','2021-10-22 09:17:20',NULL),(2722,3661,40722,4565,2,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',48400.00,NULL,NULL,1,'2021-10-22 09:17:21','2021-10-22 09:17:21',NULL),(2723,3661,40722,4565,2,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',4409.20,NULL,NULL,1,'2021-10-22 09:17:21','2021-10-22 09:17:21',NULL),(2724,3661,40722,4565,2,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',2315.00,NULL,NULL,1,'2021-10-22 09:17:21','2021-10-22 09:17:21',NULL);
INSERT INTO `balance_libro` VALUES (2725,3661,40722,4565,2,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',2315.00,NULL,NULL,1,'2021-10-22 09:17:21','2021-10-22 09:17:21',NULL),(2726,3661,40722,4565,2,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',2315.00,NULL,NULL,1,'2021-10-22 09:17:21','2021-10-22 09:17:21',NULL),(2727,3661,40722,4565,2,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',368345.00,NULL,NULL,1,'2021-10-22 09:17:21','2021-10-22 09:17:21',NULL),(2728,3661,40722,4565,2,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',196949.17,NULL,NULL,1,'2021-10-22 09:17:21','2021-10-22 09:17:21',NULL),(2729,3661,40722,4565,3,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',41834.32,NULL,NULL,1,'2021-10-22 09:18:39','2021-10-22 09:21:24','2021-10-22 09:21:24'),(2730,3661,40722,4565,3,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',2315.00,NULL,NULL,1,'2021-10-22 09:18:39','2021-10-22 09:21:00','2021-10-22 09:21:00'),(2731,3661,40722,4565,3,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',48400.00,NULL,NULL,1,'2021-10-22 09:18:39','2021-10-22 09:21:06','2021-10-22 09:21:06'),(2732,3661,40722,4565,3,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',4409.20,NULL,NULL,1,'2021-10-22 09:18:39','2021-10-22 09:20:54','2021-10-22 09:20:54'),(2733,3661,40722,4565,3,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',2315.00,NULL,NULL,1,'2021-10-22 09:18:39','2021-10-22 09:20:48','2021-10-22 09:20:48'),(2734,3661,40722,4565,3,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',2315.00,NULL,NULL,1,'2021-10-22 09:18:39','2021-10-22 09:20:41','2021-10-22 09:20:41'),(2735,3661,40722,4565,3,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',2315.00,NULL,NULL,1,'2021-10-22 09:18:39','2021-10-22 09:20:35','2021-10-22 09:20:35'),(2736,3661,40722,4565,3,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',368345.00,NULL,NULL,1,'2021-10-22 09:18:39','2021-10-22 09:20:29','2021-10-22 09:20:29'),(2737,3661,40722,4565,3,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',196949.17,NULL,NULL,1,'2021-10-22 09:18:39','2021-10-22 09:20:21','2021-10-22 09:20:21'),(2738,3661,40722,4565,3,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1846.36,NULL,NULL,1,'2021-10-22 09:18:54','2021-10-22 09:18:54',NULL),(2739,3661,40722,4565,3,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',4198.89,NULL,NULL,1,'2021-10-22 09:18:54','2021-10-22 09:18:54',NULL),(2740,3661,40722,4565,3,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',14580.00,NULL,NULL,1,'2021-10-22 09:18:54','2021-10-22 09:18:54',NULL),(2741,3661,40720,1535,1,2741,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-06-30',NULL,198468.20,NULL,NULL,1,'2021-11-03 11:45:47','2021-11-03 11:45:47',NULL),(2742,3661,40720,1536,1,2742,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-07-31',NULL,173050.44,NULL,NULL,1,'2021-11-03 11:55:24','2021-11-03 11:55:24',NULL),(2743,3661,40720,1537,1,2743,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-08-31',NULL,155069.16,NULL,NULL,1,'2021-11-03 11:55:58','2021-11-03 11:55:58',NULL),(2744,3661,40720,1538,1,2744,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-09-30',NULL,205024.19,NULL,NULL,1,'2021-11-03 11:56:14','2021-11-03 11:56:14',NULL);
INSERT INTO `balance_libro` VALUES (2745,3661,40722,4567,2,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',9060.80,NULL,NULL,1,'2021-12-06 13:33:49','2021-12-06 13:33:49',NULL),(2746,3661,40722,4567,2,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',246836.00,NULL,NULL,1,'2021-12-06 13:33:49','2021-12-06 13:33:49',NULL),(2747,3661,40722,4567,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',1846.36,NULL,NULL,1,'2021-12-06 13:34:42','2021-12-06 13:34:42',NULL),(2748,3661,40722,4567,3,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',4176.74,NULL,NULL,1,'2021-12-06 13:34:42','2021-12-06 13:34:42',NULL),(2749,3661,40722,4567,3,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-07','2021-11-07',19000.00,NULL,NULL,1,'2021-12-06 13:34:42','2021-12-06 13:34:42',NULL),(2750,3661,40722,4566,2,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',14023.90,NULL,NULL,1,'2021-12-06 13:51:49','2021-12-06 13:51:49',NULL),(2751,3661,40722,4566,2,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',10577.82,NULL,NULL,1,'2021-12-06 13:51:49','2021-12-06 13:51:49',NULL),(2752,3661,40722,4566,2,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',5522.66,NULL,NULL,1,'2021-12-06 13:51:49','2021-12-06 13:51:49',NULL),(2753,3661,40722,4566,2,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',92701.40,NULL,NULL,1,'2021-12-06 13:51:49','2021-12-06 13:51:49',NULL),(2754,3661,40722,4566,2,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',43005.60,NULL,NULL,1,'2021-12-06 13:51:49','2021-12-06 13:51:49',NULL),(2755,3661,40722,4566,2,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',153110.00,NULL,NULL,1,'2021-12-06 13:51:49','2021-12-06 13:51:49',NULL),(2756,3661,40722,4566,2,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',30657.00,NULL,NULL,1,'2021-12-06 13:51:49','2021-12-06 13:51:49',NULL),(2757,3661,40722,4566,2,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',69784.00,NULL,NULL,1,'2021-12-06 13:51:49','2021-12-06 13:51:49',NULL),(2758,3661,40722,4566,3,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',1846.36,NULL,NULL,1,'2021-12-06 13:52:05','2021-12-06 13:52:05',NULL),(2759,3661,40722,4566,3,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',5566.90,NULL,NULL,1,'2021-12-06 13:52:05','2021-12-06 13:52:05',NULL),(2760,3661,40722,4566,3,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',6610.00,NULL,NULL,1,'2021-12-06 13:52:05','2021-12-06 13:52:05',NULL),(2761,3661,40722,4566,3,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',79953.17,NULL,NULL,1,'2021-12-06 13:52:05','2021-12-06 13:52:05',NULL),(2762,3661,40722,4566,3,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',58000.00,NULL,NULL,1,'2021-12-06 13:52:05','2021-12-06 13:52:05',NULL),(2763,3661,40722,4566,3,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',2000.00,NULL,NULL,1,'2021-12-06 13:52:05','2021-12-06 13:52:05',NULL),(2764,3661,40723,6081,2,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',73637.58,NULL,NULL,1,'2021-12-06 14:13:49','2021-12-06 14:13:49',NULL),(2765,3661,40723,6081,2,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',10406.00,NULL,NULL,1,'2021-12-06 14:13:49','2021-12-06 14:13:49',NULL);
INSERT INTO `balance_libro` VALUES (2766,3661,40723,6081,2,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',18150.00,NULL,NULL,1,'2021-12-06 14:13:50','2021-12-06 14:13:50',NULL),(2767,3661,40723,6081,2,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',23230.00,NULL,NULL,1,'2021-12-06 14:13:50','2021-12-06 14:13:50',NULL),(2768,3661,40723,6081,2,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',5445.00,NULL,NULL,1,'2021-12-06 14:13:50','2021-12-06 14:13:50',NULL),(2769,3661,40723,6081,2,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',5445.00,NULL,NULL,1,'2021-12-06 14:13:50','2021-12-06 14:13:50',NULL),(2770,3661,40723,6081,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',37577.40,NULL,NULL,1,'2021-12-06 14:14:09','2021-12-06 14:14:09',NULL),(2771,3661,40723,6081,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',0.00,NULL,NULL,1,'2021-12-06 14:14:09','2021-12-06 14:14:09',NULL),(2772,3661,40723,6081,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',75020.00,NULL,NULL,1,'2021-12-06 14:14:09','2021-12-06 14:14:09',NULL),(2773,3661,40723,6081,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',42.00,NULL,NULL,1,'2021-12-06 14:14:09','2021-12-06 14:14:09',NULL),(2774,3661,40723,6081,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',35212.31,NULL,NULL,1,'2021-12-06 14:14:09','2021-12-06 14:14:09',NULL),(2775,3661,40723,6081,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',61.03,NULL,NULL,1,'2021-12-06 14:14:09','2021-12-06 14:14:09',NULL),(2776,3661,40723,6081,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',22708.86,NULL,NULL,1,'2021-12-06 14:14:09','2021-12-06 14:14:09',NULL),(2777,3661,40723,6081,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',121157.87,NULL,NULL,1,'2021-12-06 14:14:09','2021-12-06 14:14:09',NULL),(2778,3661,40723,6081,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',20805.99,NULL,NULL,1,'2021-12-06 14:14:09','2021-12-06 14:14:09',NULL),(2779,3661,40720,1539,2,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',24092.31,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2780,3661,40720,1539,2,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',4683.91,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2781,3661,40720,1539,2,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',21957.87,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2782,3661,40720,1539,2,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',3548.93,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2783,3661,40720,1539,2,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',44840.18,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2784,3661,40720,1539,2,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',9514.23,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2785,3661,40720,1539,2,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',50591.31,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2786,3661,40720,1539,2,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',21644.98,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL);
INSERT INTO `balance_libro` VALUES (2787,3661,40720,1539,2,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',8486.01,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2788,3661,40720,1539,2,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',49617.26,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2789,3661,40720,1539,2,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',44840.18,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2790,3661,40720,1539,2,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',34287.17,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2791,3661,40720,1539,2,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',28330.34,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2792,3661,40720,1539,2,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',33907.10,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2793,3661,40720,1539,2,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',3957.43,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2794,3661,40720,1539,2,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',302.50,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2795,3661,40720,1539,2,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',12277.87,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2796,3661,40720,1539,2,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',5188.48,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2797,3661,40720,1539,2,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',11411.00,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2798,3661,40720,1539,2,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',9961.93,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2799,3661,40720,1539,2,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1904.54,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2800,3661,40720,1539,2,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1287.44,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2801,3661,40720,1539,2,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',51812.20,NULL,NULL,1,'2021-12-06 17:55:38','2021-12-06 17:55:38',NULL),(2802,3661,40720,1539,2,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',3575.55,NULL,NULL,1,'2021-12-06 17:55:39','2021-12-06 17:55:39',NULL),(2803,3661,40720,1539,2,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',31094.58,NULL,NULL,1,'2021-12-06 17:55:39','2021-12-06 17:55:39',NULL),(2804,3661,40720,1539,2,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',3637.26,NULL,NULL,1,'2021-12-06 17:55:39','2021-12-06 17:55:39',NULL),(2805,3661,40720,1539,2,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1021.24,NULL,NULL,1,'2021-12-06 17:55:39','2021-12-06 17:55:39',NULL),(2806,3661,40720,1539,2,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',3770.00,NULL,NULL,1,'2021-12-06 17:55:39','2021-12-06 17:55:39',NULL),(2807,3661,40720,1539,2,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',1646.00,NULL,NULL,1,'2021-12-06 17:55:39','2021-12-06 17:55:39',NULL);
INSERT INTO `balance_libro` VALUES (2808,3661,40720,1539,2,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',24982.87,NULL,NULL,1,'2021-12-06 17:55:39','2021-12-06 17:55:39',NULL),(2809,3661,40720,1539,2,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',10178.52,NULL,NULL,1,'2021-12-06 17:55:39','2021-12-06 17:55:39',NULL),(2810,3661,40720,1539,2,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',3119.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2811,3661,40720,1539,2,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',7268.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2812,3661,40720,1539,2,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',6937.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2813,3661,40720,1539,2,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',29697.03,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2814,3661,40720,1539,2,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',3916.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2815,3661,40720,1539,2,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',1532.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2816,3661,40720,1539,2,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1342.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2817,3661,40720,1539,2,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',6745.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2818,3661,40720,1539,2,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',1037.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2819,3661,40720,1539,2,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',2589.44,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2820,3661,40720,1539,2,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',2897.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2821,3661,40720,1539,2,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',2244.39,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2822,3661,40720,1539,2,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',3110.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2823,3661,40720,1539,2,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',5642.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2824,3661,40720,1539,2,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',1159.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2825,3661,40720,1539,2,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4039.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2826,3661,40720,1539,2,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',2825.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2827,3661,40720,1539,2,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',1696.00,NULL,NULL,1,'2021-12-06 17:56:07','2021-12-06 17:56:07',NULL),(2828,3661,40720,1539,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',8000.00,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL);
INSERT INTO `balance_libro` VALUES (2829,3661,40720,1539,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',25000.00,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2830,3661,40720,1539,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',1529.85,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2831,3661,40720,1539,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2443.63,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2832,3661,40720,1539,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',0.00,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2833,3661,40720,1539,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',2904.00,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2834,3661,40720,1539,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2988.00,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2835,3661,40720,1539,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',148753.17,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2836,3661,40720,1539,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',2942.72,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2837,3661,40720,1539,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3085.64,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2838,3661,40720,1539,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',8390.00,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2839,3661,40720,1539,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',5180.00,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2840,3661,40720,1539,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',4655.06,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2841,3661,40720,1539,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2766.81,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2842,3661,40720,1539,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2500.01,NULL,NULL,1,'2021-12-06 17:56:40','2021-12-06 17:56:40',NULL),(2843,3661,40720,1540,2,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',5417.00,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL),(2844,3661,40720,1540,2,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',26691.39,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL),(2845,3661,40720,1540,2,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',8122.68,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL),(2846,3661,40720,1540,2,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',4337.85,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL),(2847,3661,40720,1540,2,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',30696.49,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL),(2848,3661,40720,1540,2,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',29532.47,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL),(2849,3661,40720,1540,2,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',25298.68,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL);
INSERT INTO `balance_libro` VALUES (2850,3661,40720,1540,2,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',31687.48,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL),(2851,3661,40720,1540,2,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',24485.56,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL),(2852,3661,40720,1540,2,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',21331.09,NULL,NULL,1,'2021-12-13 13:21:50','2021-12-13 13:21:50',NULL),(2853,3661,40720,1540,2,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3179.88,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2854,3661,40720,1540,2,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',14010.59,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2855,3661,40720,1540,2,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',58706.78,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2856,3661,40720,1540,2,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',29827.71,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2857,3661,40720,1540,2,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',5009.40,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2858,3661,40720,1540,2,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3043.00,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2859,3661,40720,1540,2,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3043.00,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2860,3661,40720,1540,2,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',577.17,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2861,3661,40720,1540,2,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',2684.99,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2862,3661,40720,1540,2,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',4265.01,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2863,3661,40720,1540,2,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',18676.35,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2864,3661,40720,1540,2,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',12794.54,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2865,3661,40720,1540,2,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',1297.12,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2866,3661,40720,1540,2,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',10914.20,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2867,3661,40720,1540,2,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',3143.58,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2868,3661,40720,1540,2,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',1722.00,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2869,3661,40720,1540,2,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',31687.48,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2870,3661,40720,1540,2,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',27984.88,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL);
INSERT INTO `balance_libro` VALUES (2871,3661,40720,1540,2,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',5432.90,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2872,3661,40720,1540,2,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1076.90,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2873,3661,40720,1540,2,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',15318.60,NULL,NULL,1,'2021-12-13 13:21:51','2021-12-13 13:21:51',NULL),(2874,3661,40720,1540,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',31687.48,NULL,NULL,1,'2021-12-13 13:21:52','2021-12-13 13:21:52',NULL),(2875,3661,40720,1540,2,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',2927.23,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2876,3661,40720,1540,2,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',4652.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2877,3661,40720,1540,2,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',8216.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2878,3661,40720,1540,2,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',3944.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2879,3661,40720,1540,2,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',4751.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2880,3661,40720,1540,2,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',2300.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2881,3661,40720,1540,2,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',2020.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2882,3661,40720,1540,2,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',1285.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2883,3661,40720,1540,2,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',960.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2884,3661,40720,1540,2,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',2098.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2885,3661,40720,1540,2,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',1748.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2886,3661,40720,1540,2,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',2195.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2887,3661,40720,1540,2,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',2838.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2888,3661,40720,1540,2,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',2342.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2889,3661,40720,1540,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',3865.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2890,3661,40720,1540,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',3025.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2891,3661,40720,1540,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',2310.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL);
INSERT INTO `balance_libro` VALUES (2892,3661,40720,1540,2,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',4115.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2893,3661,40720,1540,2,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',4067.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2894,3661,40720,1540,2,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',12519.87,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2895,3661,40720,1540,2,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',4867.01,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2896,3661,40720,1540,2,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',1410.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2897,3661,40720,1540,2,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',11406.60,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2898,3661,40720,1540,2,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4610.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2899,3661,40720,1540,2,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',2885.00,NULL,NULL,1,'2021-12-13 13:22:32','2021-12-13 13:22:32',NULL),(2900,3661,40720,1540,2,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1457.00,NULL,NULL,1,'2021-12-13 13:22:33','2021-12-13 13:22:33',NULL),(2901,3661,40720,1540,2,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1303.20,NULL,NULL,1,'2021-12-13 13:22:33','2021-12-13 13:22:33',NULL),(2902,3661,40720,1540,2,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',9958.00,NULL,NULL,1,'2021-12-13 13:22:33','2021-12-13 13:22:33',NULL),(2903,3661,40720,1540,2,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',3945.86,NULL,NULL,1,'2021-12-13 13:22:33','2021-12-13 13:22:33',NULL),(2904,3661,40720,1540,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',8584.95,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2905,3661,40720,1540,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',339.28,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2906,3661,40720,1540,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',20000.00,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2907,3661,40720,1540,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',2376.00,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2908,3661,40720,1540,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',2559.15,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2909,3661,40720,1540,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',3239.45,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2910,3661,40720,1540,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',12923.00,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2911,3661,40720,1540,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',3150.01,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2912,3661,40720,1540,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',1060.71,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL);
INSERT INTO `balance_libro` VALUES (2913,3661,40720,1540,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',2904.00,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2914,3661,40720,1540,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',1300.00,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2915,3661,40720,1540,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',782.00,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2916,3661,40720,1540,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',0.00,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2917,3661,40720,1540,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',1011.45,NULL,NULL,1,'2021-12-13 13:22:57','2021-12-13 13:22:57',NULL),(2918,3661,40720,1540,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',11616.00,NULL,NULL,1,'2021-12-13 13:22:58','2021-12-13 13:22:58',NULL),(2919,3661,40720,1540,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',21078.00,NULL,NULL,1,'2021-12-13 13:22:58','2021-12-13 13:22:58',NULL),(2920,3661,40720,1540,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1748.84,NULL,NULL,1,'2021-12-13 13:22:58','2021-12-13 13:22:58',NULL),(2921,3661,40720,1540,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3623.54,NULL,NULL,1,'2021-12-13 13:22:58','2021-12-13 13:22:58',NULL),(2922,3661,40720,1540,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2500.01,NULL,NULL,1,'2021-12-13 13:22:58','2021-12-13 13:22:58',NULL),(2923,3661,40721,3051,2,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',180.00,NULL,NULL,1,'2021-12-13 13:48:09','2021-12-13 14:31:21','2021-12-13 14:31:21'),(2924,3661,40721,3051,2,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',2460.02,NULL,NULL,1,'2021-12-13 13:48:09','2021-12-13 14:31:21','2021-12-13 14:31:21'),(2925,3661,40721,3051,2,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',3030.00,NULL,NULL,1,'2021-12-13 13:48:09','2021-12-13 14:31:21','2021-12-13 14:31:21'),(2926,3661,40721,3051,2,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',3340.00,NULL,NULL,1,'2021-12-13 13:48:09','2021-12-13 14:31:21','2021-12-13 14:31:21'),(2927,3661,40721,3051,2,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',2620.00,NULL,NULL,1,'2021-12-13 13:48:09','2021-12-13 14:31:21','2021-12-13 14:31:21'),(2928,3661,40721,3051,2,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',1550.00,NULL,NULL,1,'2021-12-13 13:48:09','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2929,3661,40721,3051,2,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',1090.00,NULL,NULL,1,'2021-12-13 13:48:09','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2930,3661,40721,3051,2,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1550.02,NULL,NULL,1,'2021-12-13 13:48:09','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2931,3661,40721,3051,2,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',3080.04,NULL,NULL,1,'2021-12-13 13:48:09','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2932,3661,40721,3051,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1590.02,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22');
INSERT INTO `balance_libro` VALUES (2933,3661,40721,3051,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1870.02,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2934,3661,40721,3051,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',650.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2935,3661,40721,3051,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1590.02,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2936,3661,40721,3051,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',2980.04,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2937,3661,40721,3051,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1290.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2938,3661,40721,3051,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1650.02,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2939,3661,40721,3051,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1650.02,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2940,3661,40721,3051,2,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1590.02,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2941,3661,40721,3051,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',2230.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2942,3661,40721,3051,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1770.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2943,3661,40721,3051,2,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',80.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2944,3661,40721,3051,2,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',7230.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2945,3661,40721,3051,2,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',3690.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2946,3661,40721,3051,2,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',4020.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2947,3661,40721,3051,2,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',3860.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2948,3661,40721,3051,2,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1660.02,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2949,3661,40721,3051,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',2740.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2950,3661,40721,3051,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2951,3661,40721,3051,2,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22');
INSERT INTO `balance_libro` VALUES (2952,3661,40721,3051,2,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2953,3661,40721,3051,2,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2954,3661,40721,3051,2,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2955,3661,40721,3051,2,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2956,3661,40721,3051,2,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',950.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2957,3661,40721,3051,2,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',2090.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2958,3661,40721,3051,2,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',1770.00,NULL,NULL,1,'2021-12-13 13:48:10','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2959,3661,40721,3051,2,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',2880.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2960,3661,40721,3051,2,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',2250.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2961,3661,40721,3051,2,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',2670.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2962,3661,40721,3051,2,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',5280.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2963,3661,40721,3051,2,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',240.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2964,3661,40721,3051,2,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1660.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2965,3661,40721,3051,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',1610.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2966,3661,40721,3051,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',860.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2967,3661,40721,3051,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',2600.02,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2968,3661,40721,3051,2,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2969,3661,40721,3051,2,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2970,3661,40721,3051,2,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22');
INSERT INTO `balance_libro` VALUES (2971,3661,40721,3051,2,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2972,3661,40721,3051,2,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2973,3661,40721,3051,2,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2974,3661,40721,3051,2,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2975,3661,40721,3051,2,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1350.02,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2976,3661,40721,3051,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',2980.04,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2977,3661,40721,3051,2,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3250.04,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2978,3661,40721,3051,2,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',4180.06,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2979,3661,40721,3051,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1590.02,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2980,3661,40721,3051,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',910.00,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2981,3661,40721,3051,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1200.02,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2982,3661,40721,3051,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',2690.04,NULL,NULL,1,'2021-12-13 13:48:11','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2983,3661,40721,3051,2,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',210.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2984,3661,40721,3051,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',1600.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2985,3661,40721,3051,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',4850.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2986,3661,40721,3051,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',960.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2987,3661,40721,3051,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',480.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2988,3661,40721,3051,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',150.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:22','2021-12-13 14:31:22'),(2989,3661,40721,3051,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:22','2021-12-13 14:31:22');
INSERT INTO `balance_libro` VALUES (2990,3661,40721,3051,2,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:23','2021-12-13 14:31:23'),(2991,3661,40721,3051,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:29:23','2021-12-13 14:29:23'),(2992,3661,40721,3051,2,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',210.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:23','2021-12-13 14:31:23'),(2993,3661,40721,3051,2,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',100.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:31:23','2021-12-13 14:31:23'),(2994,3661,40721,3051,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',1190.00,NULL,NULL,1,'2021-12-13 13:48:12','2021-12-13 14:29:00','2021-12-13 14:29:00'),(2995,3661,40721,3051,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',7500.00,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(2996,3661,40721,3051,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',3800.00,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(2997,3661,40721,3051,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',3298.94,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(2998,3661,40721,3051,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',0.00,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(2999,3661,40721,3051,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',8921.50,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3000,3661,40721,3051,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',8339.48,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3001,3661,40721,3051,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',422.68,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3002,3661,40721,3051,3,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',113068.43,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3003,3661,40721,3051,3,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',8921.50,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3004,3661,40721,3051,3,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',2386.95,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3005,3661,40721,3051,3,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',60391.45,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3006,3661,40721,3051,3,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',8186.03,NULL,NULL,1,'2021-12-13 13:48:44','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3007,3661,40721,3051,3,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',61151.36,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3008,3661,40721,3051,3,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2601.50,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34');
INSERT INTO `balance_libro` VALUES (3009,3661,40721,3051,3,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',9057.30,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3010,3661,40721,3051,3,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',1142.30,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3011,3661,40721,3051,3,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',108378.47,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3012,3661,40721,3051,3,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',327.87,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3013,3661,40721,3051,3,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',3806.73,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3014,3661,40721,3051,3,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',37971.42,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3015,3661,40721,3051,3,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',21247.60,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3016,3661,40721,3051,3,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',52161.47,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3017,3661,40721,3051,3,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',13718.77,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3018,3661,40721,3051,3,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',8367.41,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3019,3661,40721,3051,3,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',661.63,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3020,3661,40721,3051,3,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',109123.14,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3021,3661,40721,3051,3,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',16748.72,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3022,3661,40721,3051,3,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',42108.00,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3023,3661,40721,3051,3,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',10602.74,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3024,3661,40721,3051,3,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',12405.92,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3025,3661,40721,3051,3,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',3751.00,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3026,3661,40721,3051,3,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',9319.31,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3027,3661,40721,3051,3,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',107943.45,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34');
INSERT INTO `balance_libro` VALUES (3028,3661,40721,3051,3,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',492.41,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3029,3661,40721,3051,3,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',30703.57,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3030,3661,40721,3051,3,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',11534.99,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3031,3661,40721,3051,3,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',72758.56,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3032,3661,40721,3051,3,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',13840.49,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3033,3661,40721,3051,3,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1145.99,NULL,NULL,1,'2021-12-13 13:48:45','2021-12-13 14:31:34','2021-12-13 14:31:34'),(3034,3661,40721,3051,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',2840.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3035,3661,40721,3051,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',1460.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3036,3661,40721,3051,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',100.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3037,3661,40721,3051,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',2840.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3038,3661,40721,3051,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',0.20,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3039,3661,40721,3051,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',1790.02,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3040,3661,40721,3051,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-07','2021-11-07',1790.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3041,3661,40721,3051,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',1940.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3042,3661,40721,3051,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',2540.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3043,3661,40721,3051,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',1320.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3044,3661,40721,3051,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',2790.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3045,3661,40721,3051,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',2200.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3046,3661,40721,3051,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',4600.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23');
INSERT INTO `balance_libro` VALUES (3047,3661,40721,3051,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',1730.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3048,3661,40721,3051,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',3000.02,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3049,3661,40721,3051,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',9738.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3050,3661,40721,3051,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',9748.00,NULL,NULL,1,'2021-12-13 14:01:10','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3051,3661,40721,3051,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',1690.00,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3052,3661,40721,3051,2,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',1360.00,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3053,3661,40721,3051,2,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',1320.00,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3054,3661,40721,3051,2,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',1950.00,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3055,3661,40721,3051,2,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',2050.02,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3056,3661,40721,3051,2,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',2050.02,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3057,3661,40721,3051,2,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',1740.02,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3058,3661,40721,3051,2,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',1740.03,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3059,3661,40721,3051,2,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',100.00,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3060,3661,40721,3051,2,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1360.02,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3061,3661,40721,3051,2,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1790.00,NULL,NULL,1,'2021-12-13 14:01:11','2021-12-13 14:28:24','2021-12-13 14:28:24'),(3062,3661,40721,3051,3,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',3800.00,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3063,3661,40721,3051,3,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',9290.27,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3064,3661,40721,3051,3,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',3298.94,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3065,3661,40721,3051,3,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',933.03,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35');
INSERT INTO `balance_libro` VALUES (3066,3661,40721,3051,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',144467.90,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3067,3661,40721,3051,3,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',11400.00,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3068,3661,40721,3051,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',42108.00,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3069,3661,40721,3051,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',17675.21,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3070,3661,40721,3051,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',4119.19,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3071,3661,40721,3051,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',2473.99,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3072,3661,40721,3051,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',2704.35,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3073,3661,40721,3051,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',7103.80,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3074,3661,40721,3051,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',9878.92,NULL,NULL,1,'2021-12-13 14:01:38','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3075,3661,40721,3051,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',113048.36,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3076,3661,40721,3051,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',744.96,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3077,3661,40721,3051,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',2601.50,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3078,3661,40721,3051,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',25534.22,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3079,3661,40721,3051,3,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',12244.34,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3080,3661,40721,3051,3,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',3806.73,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3081,3661,40721,3051,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',50021.51,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3082,3661,40721,3051,3,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',3053.17,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3083,3661,40721,3051,3,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',79160.62,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3084,3661,40721,3051,3,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',21634.51,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35');
INSERT INTO `balance_libro` VALUES (3085,3661,40721,3051,3,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',10930.17,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3086,3661,40721,3051,3,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',4596.50,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3087,3661,40721,3051,3,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',784.27,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3088,3661,40721,3051,3,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',146342.66,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3089,3661,40721,3051,3,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',35355.60,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3090,3661,40721,3051,3,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',0.00,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3091,3661,40721,3051,3,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',13746.29,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3092,3661,40721,3051,3,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',10404.55,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3093,3661,40721,3051,3,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',597.40,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3094,3661,40721,3051,3,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',149727.60,NULL,NULL,1,'2021-12-13 14:01:39','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3095,3661,40721,3051,3,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',35748.43,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3096,3661,40721,3051,3,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',883.76,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3097,3661,40721,3051,3,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',18324.23,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3098,3661,40721,3051,3,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',883.76,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3099,3661,40721,3051,3,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',48847.70,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3100,3661,40721,3051,3,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',36720.09,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3101,3661,40721,3051,3,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',9158.73,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3102,3661,40721,3051,3,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',143819.91,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3103,3661,40721,3051,3,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',713.16,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35');
INSERT INTO `balance_libro` VALUES (3104,3661,40721,3051,3,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',388.01,NULL,NULL,1,'2021-12-13 14:01:40','2021-12-13 14:31:35','2021-12-13 14:31:35'),(3105,3661,40721,3051,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',1190.00,NULL,NULL,1,'2021-12-13 14:29:00','2021-12-13 14:29:39','2021-12-13 14:29:39'),(3106,3661,40721,3051,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 14:29:23','2021-12-13 14:29:58','2021-12-13 14:29:58'),(3107,3661,40721,3051,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',1190.00,NULL,NULL,1,'2021-12-13 14:29:39','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3108,3661,40721,3051,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 14:29:58','2021-12-13 14:30:32','2021-12-13 14:30:32'),(3109,3661,40721,3051,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 14:30:32','2021-12-13 14:30:47','2021-12-13 14:30:47'),(3110,3661,40721,3051,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 14:30:47','2021-12-13 14:31:23','2021-12-13 14:31:23'),(3111,3661,40721,3050,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',180.00,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3112,3661,40721,3050,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',2460.02,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3113,3661,40721,3050,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',3030.00,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3114,3661,40721,3050,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',3340.00,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3115,3661,40721,3050,2,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',2620.00,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3116,3661,40721,3050,2,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',1550.00,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3117,3661,40721,3050,2,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',1090.00,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3118,3661,40721,3050,2,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1550.02,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3119,3661,40721,3050,2,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',3080.04,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3120,3661,40721,3050,2,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1590.02,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3121,3661,40721,3050,2,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1870.02,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3122,3661,40721,3050,2,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',650.00,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3123,3661,40721,3050,2,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1590.02,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL);
INSERT INTO `balance_libro` VALUES (3124,3661,40721,3050,2,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',2980.04,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3125,3661,40721,3050,2,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1290.00,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3126,3661,40721,3050,2,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1650.02,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3127,3661,40721,3050,2,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1650.02,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3128,3661,40721,3050,2,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1590.02,NULL,NULL,1,'2021-12-13 14:32:32','2021-12-13 14:32:32',NULL),(3129,3661,40721,3050,2,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',2230.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3130,3661,40721,3050,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1770.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3131,3661,40721,3050,2,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',80.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3132,3661,40721,3050,2,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',7230.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3133,3661,40721,3050,2,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',3690.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3134,3661,40721,3050,2,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',4020.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3135,3661,40721,3050,2,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',3860.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3136,3661,40721,3050,2,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1660.02,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3137,3661,40721,3050,2,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',2740.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3138,3661,40721,3050,2,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3139,3661,40721,3050,2,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3140,3661,40721,3050,2,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3141,3661,40721,3050,2,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3142,3661,40721,3050,2,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3143,3661,40721,3050,2,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1500.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3144,3661,40721,3050,2,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',950.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL);
INSERT INTO `balance_libro` VALUES (3145,3661,40721,3050,2,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',2090.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3146,3661,40721,3050,2,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',1770.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3147,3661,40721,3050,2,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',2880.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3148,3661,40721,3050,2,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',2250.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3149,3661,40721,3050,2,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',2670.00,NULL,NULL,1,'2021-12-13 14:32:33','2021-12-13 14:32:33',NULL),(3150,3661,40721,3050,2,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',5280.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3151,3661,40721,3050,2,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',240.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3152,3661,40721,3050,2,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1660.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3153,3661,40721,3050,2,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',1610.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3154,3661,40721,3050,2,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',860.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3155,3661,40721,3050,2,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',2600.02,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3156,3661,40721,3050,2,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3157,3661,40721,3050,2,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3158,3661,40721,3050,2,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3159,3661,40721,3050,2,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3160,3661,40721,3050,2,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3161,3661,40721,3050,2,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3162,3661,40721,3050,2,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3380.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3163,3661,40721,3050,2,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1350.02,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3164,3661,40721,3050,2,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',2980.04,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3165,3661,40721,3050,2,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',3250.04,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL);
INSERT INTO `balance_libro` VALUES (3166,3661,40721,3050,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',4180.06,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3167,3661,40721,3050,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1590.02,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3168,3661,40721,3050,2,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',910.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3169,3661,40721,3050,2,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1200.02,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3170,3661,40721,3050,2,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',2690.04,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3171,3661,40721,3050,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',210.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3172,3661,40721,3050,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',1600.00,NULL,NULL,1,'2021-12-13 14:32:34','2021-12-13 14:32:34',NULL),(3173,3661,40721,3050,2,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',4850.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3174,3661,40721,3050,2,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',960.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3175,3661,40721,3050,2,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',480.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3176,3661,40721,3050,2,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',150.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3177,3661,40721,3050,2,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3178,3661,40721,3050,2,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3179,3661,40721,3050,2,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',240.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3180,3661,40721,3050,2,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',210.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3181,3661,40721,3050,2,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',100.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3182,3661,40721,3050,2,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',1190.00,NULL,NULL,1,'2021-12-13 14:32:35','2021-12-13 14:32:35',NULL),(3183,3661,40721,3050,3,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',7500.00,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3184,3661,40721,3050,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',3800.00,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3185,3661,40721,3050,3,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',3298.94,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3186,3661,40721,3050,3,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',0.00,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL);
INSERT INTO `balance_libro` VALUES (3187,3661,40721,3050,3,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',8921.50,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3188,3661,40721,3050,3,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',8339.48,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3189,3661,40721,3050,3,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',422.68,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3190,3661,40721,3050,3,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',113068.43,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3191,3661,40721,3050,3,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',8921.50,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3192,3661,40721,3050,3,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',2386.95,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3193,3661,40721,3050,3,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',60391.45,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3194,3661,40721,3050,3,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',8186.03,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3195,3661,40721,3050,3,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',61151.36,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3196,3661,40721,3050,3,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2601.50,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3197,3661,40721,3050,3,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',9057.30,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3198,3661,40721,3050,3,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',1142.30,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3199,3661,40721,3050,3,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',108378.47,NULL,NULL,1,'2021-12-13 14:32:58','2021-12-13 14:32:58',NULL),(3200,3661,40721,3050,3,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',327.87,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL),(3201,3661,40721,3050,3,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',3806.73,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL),(3202,3661,40721,3050,3,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',37971.42,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL),(3203,3661,40721,3050,3,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',21247.60,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL),(3204,3661,40721,3050,3,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',52161.47,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL),(3205,3661,40721,3050,3,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',13718.77,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL),(3206,3661,40721,3050,3,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',8367.41,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL),(3207,3661,40721,3050,3,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',661.63,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL);
INSERT INTO `balance_libro` VALUES (3208,3661,40721,3050,3,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',109123.14,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL),(3209,3661,40721,3050,3,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',16748.72,NULL,NULL,1,'2021-12-13 14:32:59','2021-12-13 14:32:59',NULL),(3210,3661,40721,3050,3,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',42108.00,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3211,3661,40721,3050,3,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',10602.74,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3212,3661,40721,3050,3,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',12405.92,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3213,3661,40721,3050,3,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',3751.00,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3214,3661,40721,3050,3,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',9319.31,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3215,3661,40721,3050,3,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',107943.45,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3216,3661,40721,3050,3,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',492.41,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3217,3661,40721,3050,3,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',30703.57,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3218,3661,40721,3050,3,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',11534.99,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3219,3661,40721,3050,3,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',72758.56,NULL,NULL,1,'2021-12-13 14:33:00','2021-12-13 14:33:00',NULL),(3220,3661,40721,3050,3,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',13840.49,NULL,NULL,1,'2021-12-13 14:33:01','2021-12-13 14:33:01',NULL),(3221,3661,40721,3050,3,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1145.99,NULL,NULL,1,'2021-12-13 14:33:01','2021-12-13 14:33:01',NULL),(3222,3661,40721,3051,2,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',2840.00,NULL,NULL,1,'2021-12-13 14:34:08','2021-12-13 14:34:08',NULL),(3223,3661,40721,3051,2,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',1460.00,NULL,NULL,1,'2021-12-13 14:34:08','2021-12-13 14:34:08',NULL),(3224,3661,40721,3051,2,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',100.00,NULL,NULL,1,'2021-12-13 14:34:08','2021-12-13 14:34:08',NULL),(3225,3661,40721,3051,2,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',2840.00,NULL,NULL,1,'2021-12-13 14:34:08','2021-12-13 14:34:08',NULL),(3226,3661,40721,3051,2,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',0.20,NULL,NULL,1,'2021-12-13 14:34:08','2021-12-13 14:34:08',NULL),(3227,3661,40721,3051,2,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',1790.02,NULL,NULL,1,'2021-12-13 14:34:08','2021-12-13 14:34:08',NULL),(3228,3661,40721,3051,2,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-07','2021-11-07',1790.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL);
INSERT INTO `balance_libro` VALUES (3229,3661,40721,3051,2,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',1940.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3230,3661,40721,3051,2,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',2540.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3231,3661,40721,3051,2,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',1320.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3232,3661,40721,3051,2,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',2790.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3233,3661,40721,3051,2,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',2200.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3234,3661,40721,3051,2,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',4600.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3235,3661,40721,3051,2,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',1730.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3236,3661,40721,3051,2,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',3000.02,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3237,3661,40721,3051,2,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',9738.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3238,3661,40721,3051,2,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',9748.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3239,3661,40721,3051,2,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',1690.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3240,3661,40721,3051,2,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',1360.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3241,3661,40721,3051,2,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',1320.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3242,3661,40721,3051,2,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',1950.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3243,3661,40721,3051,2,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',2050.02,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3244,3661,40721,3051,2,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',2050.02,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3245,3661,40721,3051,2,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',1740.02,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3246,3661,40721,3051,2,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',1740.03,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3247,3661,40721,3051,2,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',100.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3248,3661,40721,3051,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1360.02,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL),(3249,3661,40721,3051,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1790.00,NULL,NULL,1,'2021-12-13 14:34:09','2021-12-13 14:34:09',NULL);
INSERT INTO `balance_libro` VALUES (3250,3661,40721,3051,3,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',3800.00,NULL,NULL,1,'2021-12-13 14:34:30','2021-12-13 14:34:30',NULL),(3251,3661,40721,3051,3,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',9290.27,NULL,NULL,1,'2021-12-13 14:34:30','2021-12-13 14:34:30',NULL),(3252,3661,40721,3051,3,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',3298.94,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3253,3661,40721,3051,3,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',933.03,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3254,3661,40721,3051,3,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',144467.90,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3255,3661,40721,3051,3,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',11400.00,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3256,3661,40721,3051,3,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',42108.00,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3257,3661,40721,3051,3,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',17675.21,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3258,3661,40721,3051,3,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',4119.19,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3259,3661,40721,3051,3,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',2473.99,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3260,3661,40721,3051,3,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',2704.35,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3261,3661,40721,3051,3,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',7103.80,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3262,3661,40721,3051,3,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',9878.92,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3263,3661,40721,3051,3,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',113048.36,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3264,3661,40721,3051,3,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',744.96,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3265,3661,40721,3051,3,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',2601.50,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3266,3661,40721,3051,3,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',25534.22,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3267,3661,40721,3051,3,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',12244.34,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3268,3661,40721,3051,3,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',3806.73,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3269,3661,40721,3051,3,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',50021.51,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3270,3661,40721,3051,3,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',3053.17,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL);
INSERT INTO `balance_libro` VALUES (3271,3661,40721,3051,3,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',79160.62,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3272,3661,40721,3051,3,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',21634.51,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3273,3661,40721,3051,3,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',10930.17,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3274,3661,40721,3051,3,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',4596.50,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3275,3661,40721,3051,3,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',784.27,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3276,3661,40721,3051,3,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',146342.66,NULL,NULL,1,'2021-12-13 14:34:31','2021-12-13 14:34:31',NULL),(3277,3661,40721,3051,3,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',35355.60,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3278,3661,40721,3051,3,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',0.00,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3279,3661,40721,3051,3,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',13746.29,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3280,3661,40721,3051,3,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',10404.55,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3281,3661,40721,3051,3,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',597.40,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3282,3661,40721,3051,3,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',149727.60,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3283,3661,40721,3051,3,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',35748.43,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3284,3661,40721,3051,3,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',883.76,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3285,3661,40721,3051,3,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',18324.23,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3286,3661,40721,3051,3,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',883.76,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3287,3661,40721,3051,3,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',48847.70,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3288,3661,40721,3051,3,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',36720.09,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3289,3661,40721,3051,3,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',9158.73,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3290,3661,40721,3051,3,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',143819.91,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3291,3661,40721,3051,3,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',713.16,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL);
INSERT INTO `balance_libro` VALUES (3292,3661,40721,3051,3,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',388.01,NULL,NULL,1,'2021-12-13 14:34:32','2021-12-13 14:34:32',NULL),(3293,3661,40723,6082,2,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',149129.48,NULL,NULL,1,'2021-12-31 09:26:46','2021-12-31 09:26:46',NULL),(3294,3661,40723,6082,2,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',5445.00,NULL,NULL,1,'2021-12-31 09:26:46','2021-12-31 09:26:46',NULL),(3295,3661,40723,6082,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',5445.00,NULL,NULL,1,'2021-12-31 09:26:46','2021-12-31 09:26:46',NULL),(3296,3661,40723,6082,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',10523.80,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3297,3661,40723,6082,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',20570.00,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3298,3661,40723,6082,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',78429.16,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3299,3661,40723,6082,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',34845.00,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3300,3661,40723,6082,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',39491.00,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3301,3661,40723,6082,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',10519.00,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3302,3661,40723,6082,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',12584.00,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3303,3661,40723,6082,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',10890.00,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3304,3661,40723,6082,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',10519.80,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3305,3661,40723,6082,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',5445.00,NULL,NULL,1,'2021-12-31 09:26:47','2021-12-31 09:26:47',NULL),(3306,3661,40723,6082,3,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',60500.00,NULL,NULL,1,'2021-12-31 09:27:15','2021-12-31 09:27:15',NULL),(3307,3661,40723,6082,3,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',50000.83,NULL,NULL,1,'2021-12-31 09:27:15','2021-12-31 09:27:15',NULL),(3308,3661,40723,6082,3,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',14300.00,NULL,NULL,1,'2021-12-31 09:27:15','2021-12-31 09:27:15',NULL),(3309,3661,40723,6082,3,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',6800.00,NULL,NULL,1,'2021-12-31 09:27:15','2021-12-31 09:27:15',NULL),(3310,3661,40723,6082,3,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',592.90,NULL,NULL,1,'2021-12-31 09:27:15','2021-12-31 09:27:15',NULL),(3311,3661,40723,6082,3,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',5793.48,NULL,NULL,1,'2021-12-31 09:27:15','2021-12-31 09:27:15',NULL),(3312,3661,40723,6082,3,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',19904.27,NULL,NULL,1,'2021-12-31 09:27:15','2021-12-31 09:27:15',NULL);
INSERT INTO `balance_libro` VALUES (3313,3661,40723,6082,3,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',125066.26,NULL,NULL,1,'2021-12-31 09:27:15','2021-12-31 09:27:15',NULL),(3314,3661,40720,1541,2,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',907.50,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3315,3661,40720,1541,2,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',1110.01,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3316,3661,40720,1541,2,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',1057.09,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3317,3661,40720,1541,2,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',2410.76,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3318,3661,40720,1541,2,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',4324.00,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3319,3661,40720,1541,2,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',8971.00,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3320,3661,40720,1541,2,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',28512.44,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3321,3661,40720,1541,2,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',13235.46,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3322,3661,40720,1541,2,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',18515.42,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3323,3661,40720,1541,2,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',37918.98,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3324,3661,40720,1541,2,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',7680.11,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3325,3661,40720,1541,2,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',600.00,NULL,NULL,1,'2022-01-20 17:30:14','2022-01-20 17:30:14',NULL),(3326,3661,40720,1541,2,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',17513.54,NULL,NULL,1,'2022-01-20 17:30:15','2022-01-20 17:30:15',NULL),(3327,3661,40720,1541,2,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',24485.56,NULL,NULL,1,'2022-01-20 17:30:15','2022-01-20 17:30:15',NULL),(3328,3661,40720,1541,2,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',16483.83,NULL,NULL,1,'2022-01-20 17:30:15','2022-01-20 17:30:15',NULL),(3329,3661,40720,1541,2,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',36762.22,NULL,NULL,1,'2022-01-20 17:30:15','2022-01-20 17:30:15',NULL),(3330,3661,40720,1541,2,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',33686.40,NULL,NULL,1,'2022-01-20 17:30:15','2022-01-20 17:30:15',NULL),(3331,3661,40720,1541,2,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',7766.99,NULL,NULL,1,'2022-01-20 17:30:15','2022-01-20 17:30:15',NULL),(3332,3661,40720,1541,2,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',3041.94,NULL,NULL,1,'2022-01-20 17:30:15','2022-01-20 17:30:15',NULL),(3333,3661,40720,1541,2,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',3770.36,NULL,NULL,1,'2022-01-20 17:30:15','2022-01-20 17:30:15',NULL);
INSERT INTO `balance_libro` VALUES (3334,3661,40720,1541,2,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',1020.00,NULL,NULL,1,'2022-01-20 17:30:15','2022-01-20 17:30:15',NULL),(3335,3661,40720,1541,2,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8094.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3336,3661,40720,1541,2,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',2328.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3337,3661,40720,1541,2,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',8094.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3338,3661,40720,1541,2,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1980.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3339,3661,40720,1541,2,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',7046.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3340,3661,40720,1541,2,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',7862.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3341,3661,40720,1541,2,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',1688.78,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3342,3661,40720,1541,2,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1850.01,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3343,3661,40720,1541,2,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1742.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3344,3661,40720,1541,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1850.01,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3345,3661,40720,1541,2,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1850.01,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3346,3661,40720,1541,2,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',3170.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3347,3661,40720,1541,2,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',3357.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3348,3661,40720,1541,2,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',1568.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3349,3661,40720,1541,2,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',6937.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3350,3661,40720,1541,2,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',4200.01,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3351,3661,40720,1541,2,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',2880.01,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3352,3661,40720,1541,2,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',3159.99,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3353,3661,40720,1541,2,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',1732.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3354,3661,40720,1541,2,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',5903.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL);
INSERT INTO `balance_libro` VALUES (3355,3661,40720,1541,2,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',2183.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3356,3661,40720,1541,2,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',6206.00,NULL,NULL,1,'2022-01-20 17:30:36','2022-01-20 17:30:36',NULL),(3357,3661,40720,1541,2,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',5860.01,NULL,NULL,1,'2022-01-20 17:30:37','2022-01-20 17:30:37',NULL),(3358,3661,40720,1541,2,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',2262.00,NULL,NULL,1,'2022-01-20 17:30:37','2022-01-20 17:30:37',NULL),(3359,3661,40720,1541,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',2320.01,NULL,NULL,1,'2022-01-20 17:30:37','2022-01-20 17:30:37',NULL),(3360,3661,40720,1541,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',5765.01,NULL,NULL,1,'2022-01-20 17:30:37','2022-01-20 17:30:37',NULL),(3361,3661,40720,1541,2,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',2493.01,NULL,NULL,1,'2022-01-20 17:30:37','2022-01-20 17:30:37',NULL),(3362,3661,40720,1541,2,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',1732.00,NULL,NULL,1,'2022-01-20 17:30:37','2022-01-20 17:30:37',NULL),(3363,3661,40720,1541,2,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',1557.00,NULL,NULL,1,'2022-01-20 17:30:37','2022-01-20 17:30:37',NULL),(3364,3661,40720,1541,2,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',1557.00,NULL,NULL,1,'2022-01-20 17:30:37','2022-01-20 17:30:37',NULL),(3365,3661,40720,1541,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',4305.00,NULL,NULL,1,'2022-01-20 17:30:37','2022-01-20 17:30:37',NULL),(3366,3661,40720,1541,3,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',13800.00,NULL,NULL,1,'2022-01-20 17:31:07','2022-01-20 17:31:07',NULL),(3367,3661,40720,1541,3,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',25000.00,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL),(3368,3661,40720,1541,3,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',7752.79,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL),(3369,3661,40720,1541,3,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',2420.00,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL),(3370,3661,40720,1541,3,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',0.00,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL),(3371,3661,40720,1541,3,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',2704.35,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL),(3372,3661,40720,1541,3,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',2904.00,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL),(3373,3661,40720,1541,3,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',3882.94,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL),(3374,3661,40720,1541,3,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',2000.00,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL),(3375,3661,40720,1541,3,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',2500.01,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL);
INSERT INTO `balance_libro` VALUES (3376,3661,40720,1541,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',500.58,NULL,NULL,1,'2022-01-20 17:31:08','2022-01-20 17:31:08',NULL),(3377,3661,40721,3052,2,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3790.04,NULL,NULL,1,'2022-01-21 10:13:31','2022-01-21 10:13:31',NULL),(3378,3661,40721,3052,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4810.00,NULL,NULL,1,'2022-01-21 10:13:31','2022-01-21 10:13:31',NULL),(3379,3661,40721,3052,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',3090.00,NULL,NULL,1,'2022-01-21 10:13:31','2022-01-21 10:13:31',NULL),(3380,3661,40721,3052,2,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',2610.00,NULL,NULL,1,'2022-01-21 10:13:31','2022-01-21 10:13:31',NULL),(3381,3661,40721,3052,2,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',3770.00,NULL,NULL,1,'2022-01-21 10:13:31','2022-01-21 10:13:31',NULL),(3382,3661,40721,3052,2,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1840.00,NULL,NULL,1,'2022-01-21 10:13:31','2022-01-21 10:13:31',NULL),(3383,3661,40721,3052,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1690.00,NULL,NULL,1,'2022-01-21 10:13:31','2022-01-21 10:13:31',NULL),(3384,3661,40721,3052,2,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1640.00,NULL,NULL,1,'2022-01-21 10:13:31','2022-01-21 10:13:31',NULL),(3385,3661,40721,3052,2,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1640.00,NULL,NULL,1,'2022-01-21 10:13:31','2022-01-21 10:13:31',NULL),(3386,3661,40721,3052,2,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',3430.05,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3387,3661,40721,3052,2,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',7770.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3388,3661,40721,3052,2,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1540.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3389,3661,40721,3052,2,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1650.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3390,3661,40721,3052,2,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1650.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3391,3661,40721,3052,2,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',3130.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3392,3661,40721,3052,2,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',320.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3393,3661,40721,3052,2,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',1650.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3394,3661,40721,3052,2,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',3280.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3395,3661,40721,3052,2,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',430.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3396,3661,40721,3052,2,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',1540.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL);
INSERT INTO `balance_libro` VALUES (3397,3661,40721,3052,2,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',850.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3398,3661,40721,3052,2,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',3180.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3399,3661,40721,3052,2,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',4370.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3400,3661,40721,3052,2,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',4590.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3401,3661,40721,3052,2,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',3380.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3402,3661,40721,3052,2,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',2310.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3403,3661,40721,3052,2,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',4860.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3404,3661,40721,3052,2,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',1810.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3405,3661,40721,3052,2,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',3555.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3406,3661,40721,3052,2,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2390.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3407,3661,40721,3052,2,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2780.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3408,3661,40721,3052,2,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',1580.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3409,3661,40721,3052,2,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',3350.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3410,3661,40721,3052,2,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',200.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3411,3661,40721,3052,2,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',1430.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3412,3661,40721,3052,2,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',1760.00,NULL,NULL,1,'2022-01-21 10:13:32','2022-01-21 10:13:32',NULL),(3413,3661,40721,3052,2,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',3720.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3414,3661,40721,3052,2,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',2580.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3415,3661,40721,3052,2,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',2580.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3416,3661,40721,3052,2,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',4360.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3417,3661,40721,3052,2,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',3400.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL);
INSERT INTO `balance_libro` VALUES (3418,3661,40721,3052,2,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',4360.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3419,3661,40721,3052,2,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',5770.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3420,3661,40721,3052,2,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',2500.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3421,3661,40721,3052,2,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',2240.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3422,3661,40721,3052,2,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',2680.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3423,3661,40721,3052,2,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',2580.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3424,3661,40721,3052,2,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',4360.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3425,3661,40721,3052,2,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',1090.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3426,3661,40721,3052,2,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',1190.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3427,3661,40721,3052,2,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',2340.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3428,3661,40721,3052,2,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',5160.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3429,3661,40721,3052,2,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',2480.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3430,3661,40721,3052,2,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',1890.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3431,3661,40721,3052,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',3870.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3432,3661,40721,3052,2,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',1830.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3433,3661,40721,3052,2,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',2580.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3434,3661,40721,3052,2,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',2840.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3435,3661,40721,3052,2,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',2890.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3436,3661,40721,3052,2,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',3040.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3437,3661,40721,3052,2,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',2570.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3438,3661,40721,3052,2,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',5220.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL);
INSERT INTO `balance_libro` VALUES (3439,3661,40721,3052,2,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',2990.00,NULL,NULL,1,'2022-01-21 10:13:33','2022-01-21 10:13:33',NULL),(3440,3661,40721,3052,2,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',2720.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3441,3661,40721,3052,2,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',2080.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3442,3661,40721,3052,2,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',1640.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3443,3661,40721,3052,2,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',100.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3444,3661,40721,3052,2,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',2100.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3445,3661,40721,3052,2,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',8950.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3446,3661,40721,3052,2,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',1500.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3447,3661,40721,3052,2,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',4080.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3448,3661,40721,3052,2,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',1700.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3449,3661,40721,3052,2,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',2650.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3450,3661,40721,3052,2,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',3190.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3451,3661,40721,3052,2,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',2520.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3452,3661,40721,3052,2,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',2440.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3453,3661,40721,3052,2,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-19','2021-12-19',3070.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3454,3661,40721,3052,2,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-19','2021-12-19',2620.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3455,3661,40721,3052,2,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-19','2021-12-19',3230.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3456,3661,40721,3052,2,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',4000.04,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3457,3661,40721,3052,2,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',2260.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3458,3661,40721,3052,2,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',2750.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3459,3661,40721,3052,2,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',6740.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL);
INSERT INTO `balance_libro` VALUES (3460,3661,40721,3052,2,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',2970.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3461,3661,40721,3052,2,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1940.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3462,3661,40721,3052,2,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',2700.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3463,3661,40721,3052,2,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1810.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3464,3661,40721,3052,2,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-25','2021-12-25',2860.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3465,3661,40721,3052,2,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-25','2021-12-25',2600.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3466,3661,40721,3052,2,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-25','2021-12-25',1700.00,NULL,NULL,1,'2022-01-21 10:13:34','2022-01-21 10:13:34',NULL),(3467,3661,40721,3052,2,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-25','2021-12-25',3910.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3468,3661,40721,3052,2,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-25','2021-12-25',6570.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3469,3661,40721,3052,2,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-25','2021-12-25',1640.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3470,3661,40721,3052,2,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-26','2021-12-26',1640.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3471,3661,40721,3052,2,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-26','2021-12-26',2390.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3472,3661,40721,3052,2,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',3280.05,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3473,3661,40721,3052,2,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',6140.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3474,3661,40721,3052,2,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',4260.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3475,3661,40721,3052,2,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',1920.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3476,3661,40721,3052,2,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',3990.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3477,3661,40721,3052,2,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',3000.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3478,3661,40721,3052,2,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',100.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3479,3661,40721,3052,2,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',1450.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3480,3661,40721,3052,2,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',8260.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL);
INSERT INTO `balance_libro` VALUES (3481,3661,40721,3052,2,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',3190.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3482,3661,40721,3052,2,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',1.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3483,3661,40721,3052,2,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',1920.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3484,3661,40721,3052,2,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',3400.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3485,3661,40721,3052,2,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',2170.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3486,3661,40721,3052,2,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',3768.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3487,3661,40721,3052,2,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',2820.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3488,3661,40721,3052,2,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',7690.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3489,3661,40721,3052,2,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',1.00,NULL,NULL,1,'2022-01-21 10:13:35','2022-01-21 10:13:35',NULL),(3490,3661,40721,3052,3,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3800.00,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3491,3661,40721,3052,3,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',3726.80,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3492,3661,40721,3052,3,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',15879.04,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3493,3661,40721,3052,3,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',10634.42,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3494,3661,40721,3052,3,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',33661.68,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3495,3661,40721,3052,3,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',9038.63,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3496,3661,40721,3052,3,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',6872.80,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3497,3661,40721,3052,3,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',135706.09,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3498,3661,40721,3052,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',701.09,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3499,3661,40721,3052,3,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',2601.50,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3500,3661,40721,3052,3,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',13808.86,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3501,3661,40721,3052,3,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',0.00,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL);
INSERT INTO `balance_libro` VALUES (3502,3661,40721,3052,3,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',13378.75,NULL,NULL,1,'2022-01-21 10:14:07','2022-01-21 10:14:07',NULL),(3503,3661,40721,3052,3,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',11369.54,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3504,3661,40721,3052,3,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',3806.73,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3505,3661,40721,3052,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',1024.60,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3506,3661,40721,3052,3,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',175294.87,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3507,3661,40721,3052,3,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',53952.76,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3508,3661,40721,3052,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',8698.02,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3509,3661,40721,3052,3,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',39378.87,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3510,3661,40721,3052,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',4399.06,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3511,3661,40721,3052,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',228.36,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3512,3661,40721,3052,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',127940.14,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3513,3661,40721,3052,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',60791.89,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3514,3661,40721,3052,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',11272.45,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3515,3661,40721,3052,3,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',48847.70,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3516,3661,40721,3052,3,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',16132.06,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3517,3661,40721,3052,3,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',4564.88,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3518,3661,40721,3052,3,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',346.51,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3519,3661,40721,3052,3,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',127962.16,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3520,3661,40721,3052,3,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',1984.00,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3521,3661,40721,3052,3,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',118878.73,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL),(3522,3661,40721,3052,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',26493.80,NULL,NULL,1,'2022-01-21 10:14:08','2022-01-21 10:14:08',NULL);
INSERT INTO `balance_libro` VALUES (3523,3661,40723,6083,2,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',96685.66,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3524,3661,40723,6083,2,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',5445.00,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3525,3661,40723,6083,2,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',18270.00,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3526,3661,40723,6083,2,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',10515.00,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3527,3661,40723,6083,2,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',13473.40,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3528,3661,40723,6083,2,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',11797.50,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3529,3661,40723,6083,2,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',12705.00,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3530,3661,40723,6083,2,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',5445.00,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3531,3661,40723,6083,2,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',116150.00,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3532,3661,40723,6083,2,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',1318.90,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3533,3661,40723,6083,2,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',29037.50,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3534,3661,40723,6083,2,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',5445.00,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3535,3661,40723,6083,2,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1318.90,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3536,3661,40723,6083,2,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',8578.90,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3537,3661,40723,6083,2,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',14640.00,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3538,3661,40723,6083,2,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',5445.00,NULL,NULL,1,'2022-01-21 10:30:20','2022-01-21 10:30:20',NULL),(3539,3661,40723,6083,3,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',104.63,NULL,NULL,1,'2022-01-21 10:30:39','2022-01-21 10:30:39',NULL),(3540,3661,40723,6083,3,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',15300.00,NULL,NULL,1,'2022-01-21 10:30:39','2022-01-21 10:30:39',NULL),(3541,3661,40723,6083,3,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',10163.86,NULL,NULL,1,'2022-01-21 10:30:39','2022-01-21 10:30:39',NULL),(3542,3661,40723,6083,3,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',23656.53,NULL,NULL,1,'2022-01-21 10:30:39','2022-01-21 10:30:39',NULL),(3543,3661,40722,4568,2,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',122361.80,NULL,NULL,1,'2022-01-21 11:01:11','2022-01-21 11:01:11',NULL);
INSERT INTO `balance_libro` VALUES (3544,3661,40722,4568,2,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',19823.96,NULL,NULL,1,'2022-01-21 11:01:11','2022-01-21 11:01:11',NULL),(3545,3661,40722,4568,2,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4440.22,NULL,NULL,1,'2022-01-21 11:01:11','2022-01-21 11:01:11',NULL),(3546,3661,40722,4568,3,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4395.00,NULL,NULL,1,'2022-01-21 11:01:23','2022-01-21 11:01:23',NULL),(3547,3661,40722,4568,3,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',14484.74,NULL,NULL,1,'2022-01-21 11:01:23','2022-01-21 11:01:23',NULL),(3548,3661,40722,4568,3,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',2600.00,NULL,NULL,1,'2022-01-21 11:01:23','2022-01-21 11:01:23',NULL),(3549,3661,40720,1539,1,3549,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-10-31',NULL,90860.79,NULL,NULL,1,'2022-02-07 11:09:21','2022-02-07 11:09:21',NULL),(3550,3661,40720,1540,1,3550,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-11-30',NULL,88106.79,NULL,NULL,1,'2022-02-07 11:12:11','2022-02-07 11:12:11',NULL),(3551,3661,40720,1541,1,3551,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-12-31',NULL,130004.45,NULL,NULL,1,'2022-02-07 11:12:37','2022-02-07 11:12:37',NULL),(3552,3661,40720,1545,2,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',25095.40,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3553,3661,40720,1545,2,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',62766.33,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3554,3661,40720,1545,2,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',9113.72,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3555,3661,40720,1545,2,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1557.85,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3556,3661,40720,1545,2,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1557.85,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3557,3661,40720,1545,2,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',2976.60,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3558,3661,40720,1545,2,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',1571.00,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3559,3661,40720,1545,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',566.00,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3560,3661,40720,1545,2,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',69516.92,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3561,3661,40720,1545,2,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',23438.98,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3562,3661,40720,1545,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',30281.58,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3563,3661,40720,1545,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',30361.32,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3564,3661,40720,1545,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',17609.13,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL);
INSERT INTO `balance_libro` VALUES (3565,3661,40720,1545,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',27304.86,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3566,3661,40720,1545,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',59282.74,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3567,3661,40720,1545,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',57551.23,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3568,3661,40720,1545,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1466.00,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3569,3661,40720,1545,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1466.00,NULL,NULL,1,'2022-02-21 15:56:42','2022-02-21 15:56:42',NULL),(3570,3661,40720,1545,3,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',5025.66,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3571,3661,40720,1545,3,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',0.00,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3572,3661,40720,1545,3,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',2904.00,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3573,3661,40720,1545,3,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',178241.19,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3574,3661,40720,1545,3,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',7643.93,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3575,3661,40720,1545,3,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',262599.89,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3576,3661,40720,1545,3,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',45012.00,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3577,3661,40720,1545,3,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',4273.00,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3578,3661,40720,1545,3,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',278.07,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3579,3661,40720,1545,3,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',3811.05,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3580,3661,40720,1545,3,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1439.88,NULL,NULL,1,'2022-02-21 16:00:00','2022-02-21 16:00:00',NULL),(3581,3661,40720,1545,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',3508.80,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3582,3661,40720,1545,2,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3940.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3583,3661,40720,1545,2,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',1552.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3584,3661,40720,1545,2,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',3832.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3585,3661,40720,1545,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',3260.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL);
INSERT INTO `balance_libro` VALUES (3586,3661,40720,1545,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2380.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3587,3661,40720,1545,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2091.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3588,3661,40720,1545,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2091.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3589,3661,40720,1545,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',22550.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3590,3661,40720,1545,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',4782.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3591,3661,40720,1545,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2576.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3592,3661,40720,1545,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2330.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3593,3661,40720,1545,2,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1192.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3594,3661,40720,1545,2,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',8309.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3595,3661,40720,1545,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',14277.01,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3596,3661,40720,1545,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',11013.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3597,3661,40720,1545,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',8864.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3598,3661,40720,1545,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1440.00,NULL,NULL,1,'2022-02-21 16:08:25','2022-02-21 16:08:25',NULL),(3599,3661,40720,1545,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1440.00,NULL,NULL,1,'2022-02-21 16:08:26','2022-02-21 16:08:26',NULL),(3600,3661,40720,1545,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',7371.22,NULL,NULL,1,'2022-02-21 16:08:26','2022-02-21 16:08:26',NULL),(3601,3661,40720,1545,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',4724.00,NULL,NULL,1,'2022-02-21 16:08:26','2022-02-21 16:08:26',NULL),(3602,3661,40720,1545,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6397.00,NULL,NULL,1,'2022-02-21 16:08:26','2022-02-21 16:08:26',NULL),(3603,3661,40721,3057,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',4010.04,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:08:05','2022-03-05 12:08:05'),(3604,3661,40721,3057,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',4010.04,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:57','2022-03-05 12:07:57'),(3605,3661,40721,3057,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',3520.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:52','2022-03-05 12:07:52');
INSERT INTO `balance_libro` VALUES (3606,3661,40721,3057,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',170.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:47','2022-03-05 12:07:47'),(3607,3661,40721,3057,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',3520.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:42','2022-03-05 12:07:42'),(3608,3661,40721,3057,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',1570.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:37','2022-03-05 12:07:37'),(3609,3661,40721,3057,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',1570.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:32','2022-03-05 12:07:32'),(3610,3661,40721,3057,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2150.02,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:27','2022-03-05 12:07:27'),(3611,3661,40721,3057,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1090.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:22','2022-03-05 12:07:22'),(3612,3661,40721,3057,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1800.02,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:17','2022-03-05 12:07:17'),(3613,3661,40721,3057,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1860.02,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:13','2022-03-05 12:07:13'),(3614,3661,40721,3057,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',2890.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:07','2022-03-05 12:07:07'),(3615,3661,40721,3057,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1920.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:07:02','2022-03-05 12:07:02'),(3616,3661,40721,3057,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1640.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:06:56','2022-03-05 12:06:56'),(3617,3661,40721,3057,2,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',4020.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:06:51','2022-03-05 12:06:51'),(3618,3661,40721,3057,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',2410.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:06:46','2022-03-05 12:06:46'),(3619,3661,40721,3057,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1920.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:06:42','2022-03-05 12:06:42'),(3620,3661,40721,3057,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',2520.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:06:37','2022-03-05 12:06:37'),(3621,3661,40721,3057,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',2860.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:06:31','2022-03-05 12:06:31'),(3622,3661,40721,3057,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',5940.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:06:25','2022-03-05 12:06:25'),(3623,3661,40721,3057,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',1380.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:06:20','2022-03-05 12:06:20'),(3624,3661,40721,3057,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',2130.00,NULL,NULL,1,'2022-02-21 16:58:37','2022-03-05 12:06:15','2022-03-05 12:06:15');
INSERT INTO `balance_libro` VALUES (3625,3661,40721,3057,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',500.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:06:09','2022-03-05 12:06:09'),(3626,3661,40721,3057,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1728.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:06:03','2022-03-05 12:06:03'),(3627,3661,40721,3057,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',2850.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:59','2022-03-05 12:05:59'),(3628,3661,40721,3057,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',1080.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:54','2022-03-05 12:05:54'),(3629,3661,40721,3057,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',4650.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:50','2022-03-05 12:05:50'),(3630,3661,40721,3057,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',3700.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:46','2022-03-05 12:05:46'),(3631,3661,40721,3057,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',3640.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:42','2022-03-05 12:05:42'),(3632,3661,40721,3057,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2010.03,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:38','2022-03-05 12:05:38'),(3633,3661,40721,3057,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2890.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:31','2022-03-05 12:05:31'),(3634,3661,40721,3057,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2030.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:26','2022-03-05 12:05:26'),(3635,3661,40721,3057,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',7970.10,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:22','2022-03-05 12:05:22'),(3636,3661,40721,3057,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1750.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:17','2022-03-05 12:05:17'),(3637,3661,40721,3057,2,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:12','2022-03-05 12:05:12'),(3638,3661,40721,3057,2,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',2940.02,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:08','2022-03-05 12:05:08'),(3639,3661,40721,3057,2,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',2750.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:05:02','2022-03-05 12:05:02'),(3640,3661,40721,3057,2,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',7730.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:58','2022-03-05 12:04:58'),(3641,3661,40721,3057,2,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',5660.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:53','2022-03-05 12:04:53'),(3642,3661,40721,3057,2,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',3430.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:48','2022-03-05 12:04:48'),(3643,3661,40721,3057,2,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',1640.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:43','2022-03-05 12:04:43');
INSERT INTO `balance_libro` VALUES (3644,3661,40721,3057,2,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',3720.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:39','2022-03-05 12:04:39'),(3645,3661,40721,3057,2,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',3720.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:34','2022-03-05 12:04:34'),(3646,3661,40721,3057,2,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',2180.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:30','2022-03-05 12:04:30'),(3647,3661,40721,3057,2,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3000.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:25','2022-03-05 12:04:25'),(3648,3661,40721,3057,2,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',340.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:20','2022-03-05 12:04:20'),(3649,3661,40721,3057,2,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3280.00,NULL,NULL,1,'2022-02-21 16:58:38','2022-03-05 12:04:15','2022-03-05 12:04:15'),(3650,3661,40721,3057,2,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3280.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:04:10','2022-03-05 12:04:10'),(3651,3661,40721,3057,2,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',2710.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:04:03','2022-03-05 12:04:03'),(3652,3661,40721,3057,2,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3470.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:58','2022-03-05 12:03:58'),(3653,3661,40721,3057,2,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',2870.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:53','2022-03-05 12:03:53'),(3654,3661,40721,3057,2,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',2600.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:48','2022-03-05 12:03:48'),(3655,3661,40721,3057,2,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3870.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:43','2022-03-05 12:03:43'),(3656,3661,40721,3057,2,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',1540.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:39','2022-03-05 12:03:39'),(3657,3661,40721,3057,2,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',1710.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:34','2022-03-05 12:03:34'),(3658,3661,40721,3057,2,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3280.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:30','2022-03-05 12:03:30'),(3659,3661,40721,3057,2,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',2910.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:25','2022-03-05 12:03:25'),(3660,3661,40721,3057,2,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3050.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:20','2022-03-05 12:03:20'),(3661,3661,40721,3057,2,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',660.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:16','2022-03-05 12:03:16'),(3662,3661,40721,3057,2,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',2520.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:11','2022-03-05 12:03:11');
INSERT INTO `balance_libro` VALUES (3663,3661,40721,3057,2,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',2190.00,NULL,NULL,1,'2022-02-21 16:58:39','2022-03-05 12:03:06','2022-03-05 12:03:06'),(3664,3661,40721,3057,2,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3050.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:03:01','2022-03-05 12:03:01'),(3665,3661,40721,3057,2,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1260.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:57','2022-03-05 12:02:57'),(3666,3661,40721,3057,2,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2430.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:53','2022-03-05 12:02:53'),(3667,3661,40721,3057,2,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',3640.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:49','2022-03-05 12:02:49'),(3668,3661,40721,3057,2,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2810.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:44','2022-03-05 12:02:44'),(3669,3661,40721,3057,2,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1640.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:40','2022-03-05 12:02:40'),(3670,3661,40721,3057,2,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1430.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:35','2022-03-05 12:02:35'),(3671,3661,40721,3057,2,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1940.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:31','2022-03-05 12:02:31'),(3672,3661,40721,3057,2,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2700.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:26','2022-03-05 12:02:26'),(3673,3661,40721,3057,2,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',4660.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:21','2022-03-05 12:02:21'),(3674,3661,40721,3057,2,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2080.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:16','2022-03-05 12:02:16'),(3675,3661,40721,3057,2,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',3260.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:10','2022-03-05 12:02:10'),(3676,3661,40721,3057,2,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-23','2022-01-23',1610.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:05','2022-03-05 12:02:05'),(3677,3661,40721,3057,2,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1.00,NULL,NULL,1,'2022-02-21 16:58:40','2022-03-05 12:02:00','2022-03-05 12:02:00'),(3678,3661,40721,3057,2,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1.00,NULL,NULL,1,'2022-02-21 16:58:41','2022-03-05 12:01:54','2022-03-05 12:01:54'),(3679,3661,40721,3057,2,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',10.00,NULL,NULL,1,'2022-02-21 16:58:41','2022-03-05 12:01:50','2022-03-05 12:01:50'),(3680,3661,40721,3057,2,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',10.00,NULL,NULL,1,'2022-02-21 16:58:41','2022-03-05 12:01:40','2022-03-05 12:01:40'),(3681,3661,40721,3057,2,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1.10,NULL,NULL,1,'2022-02-21 16:58:41','2022-03-05 12:01:35','2022-03-05 12:01:35');
INSERT INTO `balance_libro` VALUES (3682,3661,40721,3057,2,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3870.04,NULL,NULL,1,'2022-02-21 16:58:41','2022-03-05 12:00:23','2022-03-05 12:00:23'),(3683,3661,40721,3057,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',3800.00,NULL,NULL,1,'2022-02-21 16:59:05','2022-03-05 12:11:11','2022-03-05 12:11:11'),(3684,3661,40721,3057,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',3726.80,NULL,NULL,1,'2022-02-21 16:59:05','2022-03-05 12:11:05','2022-03-05 12:11:05'),(3685,3661,40721,3057,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1515.68,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:11:01','2022-03-05 12:11:01'),(3686,3661,40721,3057,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',89.15,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:56','2022-03-05 12:10:56'),(3687,3661,40721,3057,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',142962.79,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:52','2022-03-05 12:10:52'),(3688,3661,40721,3057,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',2681.92,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:48','2022-03-05 12:10:48'),(3689,3661,40721,3057,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',2601.50,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:44','2022-03-05 12:10:44'),(3690,3661,40721,3057,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',6834.42,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:41','2022-03-05 12:10:41'),(3691,3661,40721,3057,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',0.00,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:35','2022-03-05 12:10:35'),(3692,3661,40721,3057,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',31230.00,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:32','2022-03-05 12:10:32'),(3693,3661,40721,3057,3,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',14864.40,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:27','2022-03-05 12:10:27'),(3694,3661,40721,3057,3,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',3638.72,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:24','2022-03-05 12:10:24'),(3695,3661,40721,3057,3,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',217.07,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:20','2022-03-05 12:10:20'),(3696,3661,40721,3057,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',112720.12,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:16','2022-03-05 12:10:16'),(3697,3661,40721,3057,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',4186.85,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:13','2022-03-05 12:10:13'),(3698,3661,40721,3057,3,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',52991.46,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:09','2022-03-05 12:10:09'),(3699,3661,40721,3057,3,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',221.07,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:05','2022-03-05 12:10:05'),(3700,3661,40721,3057,3,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',19693.47,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:10:01','2022-03-05 12:10:01');
INSERT INTO `balance_libro` VALUES (3701,3661,40721,3057,3,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',7050.90,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:58','2022-03-05 12:09:58'),(3702,3661,40721,3057,3,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',19531.61,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:53','2022-03-05 12:09:53'),(3703,3661,40721,3057,3,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',48847.70,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:50','2022-03-05 12:09:50'),(3704,3661,40721,3057,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',15000.01,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:46','2022-03-05 12:09:46'),(3705,3661,40721,3057,3,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',7016.94,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:42','2022-03-05 12:09:42'),(3706,3661,40721,3057,3,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',608.12,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:38','2022-03-05 12:09:38'),(3707,3661,40721,3057,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',240471.10,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:34','2022-03-05 12:09:34'),(3708,3661,40721,3057,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',44169.59,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:31','2022-03-05 12:09:31'),(3709,3661,40721,3057,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',25643.33,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:26','2022-03-05 12:09:26'),(3710,3661,40721,3057,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',85653.70,NULL,NULL,1,'2022-02-21 16:59:06','2022-03-05 12:09:22','2022-03-05 12:09:22'),(3711,3661,40721,3057,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',9348.85,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:09:18','2022-03-05 12:09:18'),(3712,3661,40721,3057,3,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',38276.27,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:09:14','2022-03-05 12:09:14'),(3713,3661,40721,3057,3,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',4858.10,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:09:09','2022-03-05 12:09:09'),(3714,3661,40721,3057,3,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',378.69,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:09:05','2022-03-05 12:09:05'),(3715,3661,40721,3057,3,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',179445.11,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:09:01','2022-03-05 12:09:01'),(3716,3661,40721,3057,3,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',62685.03,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:08:57','2022-03-05 12:08:57'),(3717,3661,40721,3057,3,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',55125.66,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:08:53','2022-03-05 12:08:53'),(3718,3661,40721,3057,3,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',42231.92,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:08:50','2022-03-05 12:08:50'),(3719,3661,40721,3057,3,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7727.25,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:08:46','2022-03-05 12:08:46');
INSERT INTO `balance_libro` VALUES (3720,3661,40721,3057,3,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1724.00,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:08:43','2022-03-05 12:08:43'),(3721,3661,40721,3057,3,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',533.16,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:08:38','2022-03-05 12:08:38'),(3722,3661,40721,3057,3,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',187746.76,NULL,NULL,1,'2022-02-21 16:59:07','2022-03-05 12:08:28','2022-03-05 12:08:28'),(3723,3661,40723,6087,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',90957.52,NULL,NULL,1,'2022-02-22 15:30:30','2022-02-22 15:30:30',NULL),(3724,3661,40723,6087,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',11797.50,NULL,NULL,1,'2022-02-22 15:30:30','2022-02-22 15:30:30',NULL),(3725,3661,40723,6087,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',12705.00,NULL,NULL,1,'2022-02-22 15:30:30','2022-02-22 15:30:30',NULL),(3726,3661,40723,6087,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',8167.50,NULL,NULL,1,'2022-02-22 15:30:30','2022-02-22 15:30:30',NULL),(3727,3661,40723,6087,2,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',9075.00,NULL,NULL,1,'2022-02-22 15:30:30','2022-02-22 15:30:30',NULL),(3728,3661,40723,6087,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',11495.00,NULL,NULL,1,'2022-02-22 15:30:30','2022-02-22 15:30:30',NULL),(3729,3661,40723,6087,2,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',4684.80,NULL,NULL,1,'2022-02-22 15:30:30','2022-02-22 15:30:30',NULL),(3730,3661,40723,6087,2,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',5445.00,NULL,NULL,1,'2022-02-22 15:30:30','2022-02-22 15:30:30',NULL),(3731,3661,40723,6087,2,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',189720.44,NULL,NULL,1,'2022-02-22 15:30:30','2022-02-22 15:30:30',NULL),(3732,3661,40723,6087,3,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',43.59,NULL,NULL,1,'2022-02-22 15:31:22','2022-02-22 15:31:22',NULL),(3733,3661,40723,6087,3,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',14160.82,NULL,NULL,1,'2022-02-22 15:31:22','2022-02-22 15:31:22',NULL),(3734,3661,40723,6087,3,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',148.22,NULL,NULL,1,'2022-02-22 15:31:22','2022-02-22 15:31:22',NULL),(3735,3661,40723,6087,3,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',77570.00,NULL,NULL,1,'2022-02-22 15:31:22','2022-02-22 15:31:22',NULL),(3736,3661,40723,6087,3,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',22349.47,NULL,NULL,1,'2022-02-22 15:31:22','2022-02-22 15:31:22',NULL),(3737,3661,40723,6087,3,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',721.80,NULL,NULL,1,'2022-02-22 15:31:22','2022-02-22 15:31:22',NULL),(3738,3661,40722,4572,2,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',56003.00,NULL,NULL,1,'2022-02-23 17:06:23','2022-02-23 17:06:23',NULL),(3739,3661,40722,4572,2,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',37756.40,NULL,NULL,1,'2022-02-23 17:06:23','2022-02-23 17:06:23',NULL);
INSERT INTO `balance_libro` VALUES (3740,3661,40722,4572,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',72600.00,NULL,NULL,1,'2022-02-23 17:06:23','2022-02-23 17:06:23',NULL),(3741,3661,40722,4572,2,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',43878.98,NULL,NULL,1,'2022-02-23 17:06:23','2022-02-23 17:06:23',NULL),(3742,3661,40722,4572,2,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',66588.00,NULL,NULL,1,'2022-02-23 17:06:23','2022-02-23 17:06:23',NULL),(3743,3661,40722,4572,2,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',58013.20,NULL,NULL,1,'2022-02-23 17:06:23','2022-02-23 17:06:23',NULL),(3744,3661,40722,4572,3,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4650.01,NULL,NULL,1,'2022-02-23 17:06:51','2022-02-23 17:06:51',NULL),(3745,3661,40722,4572,3,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',39330.00,NULL,NULL,1,'2022-02-23 17:06:51','2022-02-23 17:06:51',NULL),(3746,3661,40720,1546,2,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',4183.00,NULL,NULL,1,'2022-03-05 11:21:45','2022-03-05 11:21:45',NULL),(3747,3661,40720,1546,2,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',3172.01,NULL,NULL,1,'2022-03-05 11:21:45','2022-03-05 11:21:45',NULL),(3748,3661,40720,1546,2,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',1280.00,NULL,NULL,1,'2022-03-05 11:21:45','2022-03-05 11:21:45',NULL),(3749,3661,40720,1546,2,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',3248.00,NULL,NULL,1,'2022-03-05 11:21:45','2022-03-05 11:21:45',NULL),(3750,3661,40720,1546,2,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',22485.43,NULL,NULL,1,'2022-03-05 11:21:45','2022-03-05 11:21:45',NULL),(3751,3661,40720,1546,2,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',16388.24,NULL,NULL,1,'2022-03-05 11:21:45','2022-03-05 11:21:45',NULL),(3752,3661,40720,1546,2,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',7140.21,NULL,NULL,1,'2022-03-05 11:21:45','2022-03-05 11:21:45',NULL),(3753,3661,40720,1546,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',126020.05,NULL,NULL,1,'2022-03-05 11:21:45','2022-03-05 11:21:45',NULL),(3754,3661,40720,1546,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',8203.99,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3755,3661,40720,1546,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',7760.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3756,3661,40720,1546,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',3700.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3757,3661,40720,1546,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1109.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3758,3661,40720,1546,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1109.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3759,3661,40720,1546,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',4796.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3760,3661,40720,1546,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',8800.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL);
INSERT INTO `balance_libro` VALUES (3761,3661,40720,1546,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',3062.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3762,3661,40720,1546,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',6726.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3763,3661,40720,1546,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',1122.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3764,3661,40720,1546,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',12836.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3765,3661,40720,1546,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',4127.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3766,3661,40720,1546,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',15936.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3767,3661,40720,1546,2,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',3717.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3768,3661,40720,1546,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',4407.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3769,3661,40720,1546,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',3123.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3770,3661,40720,1546,2,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',2632.00,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3771,3661,40720,1546,2,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',4371.20,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3772,3661,40720,1546,2,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',3102.40,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3773,3661,40720,1546,2,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',3212.01,NULL,NULL,1,'2022-03-05 11:22:07','2022-03-05 11:22:07',NULL),(3774,3661,40720,1546,2,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',770.00,NULL,NULL,1,'2022-03-05 11:22:08','2022-03-05 11:22:08',NULL),(3775,3661,40720,1546,2,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',2817.86,NULL,NULL,1,'2022-03-05 11:22:08','2022-03-05 11:22:08',NULL),(3776,3661,40720,1546,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',3993.59,NULL,NULL,1,'2022-03-05 11:22:08','2022-03-05 11:22:08',NULL),(3777,3661,40720,1546,2,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',9981.00,NULL,NULL,1,'2022-03-05 11:22:08','2022-03-05 11:22:08',NULL),(3778,3661,40720,1546,2,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1633.00,NULL,NULL,1,'2022-03-05 11:22:08','2022-03-05 11:22:08',NULL),(3779,3661,40720,1546,3,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2500.01,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3780,3661,40720,1546,3,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',216055.32,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3781,3661,40720,1546,3,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',24653.75,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL);
INSERT INTO `balance_libro` VALUES (3782,3661,40720,1546,3,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',9317.22,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3783,3661,40720,1546,3,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',1097.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3784,3661,40720,1546,3,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',25047.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3785,3661,40720,1546,3,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',64916.50,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3786,3661,40720,1546,3,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',1806.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3787,3661,40720,1546,3,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',0.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3788,3661,40720,1546,3,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',50616.72,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3789,3661,40720,1546,3,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',1507.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3790,3661,40720,1546,3,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',3388.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3791,3661,40720,1546,3,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',3630.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3792,3661,40720,1546,3,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',102945.50,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3793,3661,40720,1546,3,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',851.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3794,3661,40720,1546,3,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',23269.99,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3795,3661,40720,1546,3,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',6262.96,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3796,3661,40720,1546,3,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',2854.05,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3797,3661,40720,1546,3,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',2000.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3798,3661,40720,1546,3,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',851.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3799,3661,40720,1546,3,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',3207.57,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3800,3661,40720,1546,3,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',36280.64,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3801,3661,40720,1546,3,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',1480.00,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL),(3802,3661,40720,1546,3,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',103717.60,NULL,NULL,1,'2022-03-05 11:22:38','2022-03-05 11:22:38',NULL);
INSERT INTO `balance_libro` VALUES (3803,3661,40720,1546,3,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',102945.50,NULL,NULL,1,'2022-03-05 11:22:39','2022-03-05 11:22:39',NULL),(3804,3661,40720,1546,3,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',3920.68,NULL,NULL,1,'2022-03-05 11:22:39','2022-03-05 11:22:39',NULL),(3805,3661,40720,1546,3,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',8215.83,NULL,NULL,1,'2022-03-05 11:22:39','2022-03-05 11:22:39',NULL),(3806,3661,40720,1546,3,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1571.79,NULL,NULL,1,'2022-03-05 11:22:39','2022-03-05 11:22:39',NULL),(3807,3661,40720,1546,3,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2500.01,NULL,NULL,1,'2022-03-05 11:22:39','2022-03-05 11:22:39',NULL),(3808,3661,40721,3057,2,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3870.04,NULL,NULL,1,'2022-03-05 12:00:23','2022-03-05 12:01:29','2022-03-05 12:01:29'),(3809,3661,40721,3057,3,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',3800.00,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3810,3661,40721,3057,3,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',3726.80,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3811,3661,40721,3057,3,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',22911.94,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3812,3661,40721,3057,3,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',24169.34,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3813,3661,40721,3057,3,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',12306.29,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3814,3661,40721,3057,3,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',936.42,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3815,3661,40721,3057,3,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',176642.35,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3816,3661,40721,3057,3,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',55911.73,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3817,3661,40721,3057,3,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',14009.49,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3818,3661,40721,3057,3,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',4806.85,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3819,3661,40721,3057,3,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',31373.07,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3820,3661,40721,3057,3,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',2601.50,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3821,3661,40721,3057,3,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',16965.13,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3822,3661,40721,3057,3,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',1307.37,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3823,3661,40721,3057,3,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',168825.51,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL);
INSERT INTO `balance_libro` VALUES (3824,3661,40721,3057,3,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',10000.00,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3825,3661,40721,3057,3,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',34758.96,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3826,3661,40721,3057,3,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',19267.66,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3827,3661,40721,3057,3,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',48847.70,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3828,3661,40721,3057,3,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',32372.22,NULL,NULL,1,'2022-03-05 12:21:26','2022-03-05 12:21:26',NULL),(3829,3661,40721,3057,3,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',8329.80,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3830,3661,40721,3057,3,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',654.89,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3831,3661,40721,3057,3,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',176758.12,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3832,3661,40721,3057,3,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',44979.38,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3833,3661,40721,3057,3,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',18290.58,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3834,3661,40721,3057,3,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',7970.72,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3835,3661,40721,3057,3,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',43864.78,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3836,3661,40721,3057,3,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',27816.05,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3837,3661,40721,3057,3,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',10756.38,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3838,3661,40721,3057,3,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1925.00,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3839,3661,40721,3057,3,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',498.59,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3840,3661,40721,3057,3,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',182554.80,NULL,NULL,1,'2022-03-05 12:21:27','2022-03-05 12:21:27',NULL),(3841,3661,40721,3057,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',3750.04,NULL,NULL,1,'2022-03-05 12:23:40','2022-03-05 12:35:34','2022-03-05 12:35:34'),(3842,3661,40721,3057,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',2050.00,NULL,NULL,1,'2022-03-05 12:23:40','2022-03-05 12:35:28','2022-03-05 12:35:28'),(3843,3661,40721,3057,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-27','2022-02-27',1519.01,NULL,NULL,1,'2022-03-05 12:23:40','2022-03-05 12:35:22','2022-03-05 12:35:22');
INSERT INTO `balance_libro` VALUES (3844,3661,40723,6088,2,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',9680.00,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3845,3661,40723,6088,2,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',12356.52,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3846,3661,40723,6088,2,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',12959.10,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3847,3661,40723,6088,2,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',10285.00,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3848,3661,40723,6088,2,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',10515.00,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3849,3661,40723,6088,2,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',12705.00,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3850,3661,40723,6088,2,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',8167.50,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3851,3661,40723,6088,2,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',6534.00,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3852,3661,40723,6088,2,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',5445.00,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3853,3661,40723,6088,2,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',9680.00,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3854,3661,40723,6088,2,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',173967.75,NULL,NULL,1,'2022-03-30 11:10:43','2022-03-30 11:10:43',NULL),(3855,3661,40723,6088,3,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',76499.87,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3856,3661,40723,6088,3,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',27970.06,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3857,3661,40723,6088,3,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',3574.80,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3858,3661,40723,6088,3,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',23831.99,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3859,3661,40723,6088,3,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',16850.27,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3860,3661,40723,6088,3,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',9502.00,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3861,3661,40723,6088,3,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',20328.00,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3862,3661,40723,6088,3,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',20328.00,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3863,3661,40723,6088,3,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',20328.00,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3864,3661,40723,6088,3,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',4144.99,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL);
INSERT INTO `balance_libro` VALUES (3865,3661,40723,6088,3,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',30000.00,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3866,3661,40723,6088,3,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',80000.00,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3867,3661,40723,6088,3,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',21937.52,NULL,NULL,1,'2022-03-30 11:11:01','2022-03-30 11:11:01',NULL),(3868,3661,40722,4573,3,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',4650.01,NULL,NULL,1,'2022-03-30 13:15:01','2022-03-30 13:15:01',NULL),(3869,3661,40721,7600,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',4010.04,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3870,3661,40721,7600,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',4010.04,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3871,3661,40721,7600,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',3520.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3872,3661,40721,7600,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',170.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3873,3661,40721,7600,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',3520.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3874,3661,40721,7600,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',1570.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3875,3661,40721,7600,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',1570.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3876,3661,40721,7600,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2150.02,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3877,3661,40721,7600,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1090.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3878,3661,40721,7600,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1800.02,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3879,3661,40721,7600,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1860.02,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3880,3661,40721,7600,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',2890.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3881,3661,40721,7600,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1920.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3882,3661,40721,7600,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1640.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3883,3661,40721,7600,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',4020.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3884,3661,40721,7600,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',2410.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3885,3661,40721,7600,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',1920.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL);
INSERT INTO `balance_libro` VALUES (3886,3661,40721,7600,2,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',2520.00,NULL,NULL,1,'2022-03-30 15:34:18','2022-03-30 15:34:18',NULL),(3887,3661,40721,7600,2,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',2860.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3888,3661,40721,7600,2,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',5940.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3889,3661,40721,7600,2,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',1380.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3890,3661,40721,7600,2,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',2130.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3891,3661,40721,7600,2,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',500.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3892,3661,40721,7600,2,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1728.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3893,3661,40721,7600,2,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',2850.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3894,3661,40721,7600,2,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',1080.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3895,3661,40721,7600,2,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',4650.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3896,3661,40721,7600,2,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',3700.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3897,3661,40721,7600,2,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',3640.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3898,3661,40721,7600,2,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2010.03,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3899,3661,40721,7600,2,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2890.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3900,3661,40721,7600,2,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2030.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3901,3661,40721,7600,2,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',7970.10,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3902,3661,40721,7600,2,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1750.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3903,3661,40721,7600,2,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3904,3661,40721,7600,2,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',2940.02,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3905,3661,40721,7600,2,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',2750.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3906,3661,40721,7600,2,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',7730.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL);
INSERT INTO `balance_libro` VALUES (3907,3661,40721,7600,2,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',5660.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3908,3661,40721,7600,2,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',3430.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3909,3661,40721,7600,2,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',1640.00,NULL,NULL,1,'2022-03-30 15:34:19','2022-03-30 15:34:19',NULL),(3910,3661,40721,7600,2,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',3720.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3911,3661,40721,7600,2,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',3720.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3912,3661,40721,7600,2,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',2180.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3913,3661,40721,7600,2,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3000.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3914,3661,40721,7600,2,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',340.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3915,3661,40721,7600,2,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3280.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3916,3661,40721,7600,2,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3280.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3917,3661,40721,7600,2,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',2710.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3918,3661,40721,7600,2,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3470.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3919,3661,40721,7600,2,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',2870.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3920,3661,40721,7600,2,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',2600.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3921,3661,40721,7600,2,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3870.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3922,3661,40721,7600,2,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',1540.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3923,3661,40721,7600,2,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',1710.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3924,3661,40721,7600,2,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3280.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3925,3661,40721,7600,2,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',2910.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3926,3661,40721,7600,2,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3050.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3927,3661,40721,7600,2,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',660.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL);
INSERT INTO `balance_libro` VALUES (3928,3661,40721,7600,2,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',2520.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3929,3661,40721,7600,2,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',2190.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3930,3661,40721,7600,2,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3050.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3931,3661,40721,7600,2,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1260.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3932,3661,40721,7600,2,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2430.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3933,3661,40721,7600,2,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',3640.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3934,3661,40721,7600,2,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2810.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3935,3661,40721,7600,2,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1640.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3936,3661,40721,7600,2,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1430.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3937,3661,40721,7600,2,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1940.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3938,3661,40721,7600,2,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2700.00,NULL,NULL,1,'2022-03-30 15:34:20','2022-03-30 15:34:20',NULL),(3939,3661,40721,7600,2,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',4660.00,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL),(3940,3661,40721,7600,2,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2080.00,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL),(3941,3661,40721,7600,2,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',3260.00,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL),(3942,3661,40721,7600,2,3873,'App\\Models\\Receipt',3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-23','2022-01-23',1610.00,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL),(3943,3661,40721,7600,2,3874,'App\\Models\\Receipt',3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1.00,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL),(3944,3661,40721,7600,2,3875,'App\\Models\\Receipt',3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1.00,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL),(3945,3661,40721,7600,2,3876,'App\\Models\\Receipt',3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',10.00,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL),(3946,3661,40721,7600,2,3877,'App\\Models\\Receipt',3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',10.00,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL),(3947,3661,40721,7600,2,3878,'App\\Models\\Receipt',3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1.10,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL),(3948,3661,40721,7600,2,3879,'App\\Models\\Receipt',3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3870.04,NULL,NULL,1,'2022-03-30 15:34:21','2022-03-30 15:34:21',NULL);
INSERT INTO `balance_libro` VALUES (3949,3661,40721,7600,3,3880,'App\\Models\\Receipt',3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',3800.00,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3950,3661,40721,7600,3,3881,'App\\Models\\Receipt',3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',3726.80,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3951,3661,40721,7600,3,3882,'App\\Models\\Receipt',3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1515.68,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3952,3661,40721,7600,3,3883,'App\\Models\\Receipt',3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',89.15,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3953,3661,40721,7600,3,3884,'App\\Models\\Receipt',3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',142962.79,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3954,3661,40721,7600,3,3885,'App\\Models\\Receipt',3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',2681.92,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3955,3661,40721,7600,3,3886,'App\\Models\\Receipt',3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',2601.50,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3956,3661,40721,7600,3,3887,'App\\Models\\Receipt',3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',6834.42,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3957,3661,40721,7600,3,3888,'App\\Models\\Receipt',3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',0.00,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3958,3661,40721,7600,3,3889,'App\\Models\\Receipt',3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',31230.00,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3959,3661,40721,7600,3,3890,'App\\Models\\Receipt',3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',14864.40,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3960,3661,40721,7600,3,3891,'App\\Models\\Receipt',3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',3638.72,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3961,3661,40721,7600,3,3892,'App\\Models\\Receipt',3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',217.07,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3962,3661,40721,7600,3,3893,'App\\Models\\Receipt',3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',112720.12,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3963,3661,40721,7600,3,3894,'App\\Models\\Receipt',3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',4186.85,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3964,3661,40721,7600,3,3895,'App\\Models\\Receipt',3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',52991.46,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3965,3661,40721,7600,3,3896,'App\\Models\\Receipt',3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',221.07,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3966,3661,40721,7600,3,3897,'App\\Models\\Receipt',3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',19693.47,NULL,NULL,1,'2022-03-30 15:34:35','2022-03-30 15:34:35',NULL),(3967,3661,40721,7600,3,3898,'App\\Models\\Receipt',3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',7050.90,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3968,3661,40721,7600,3,3899,'App\\Models\\Receipt',3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',19531.61,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3969,3661,40721,7600,3,3900,'App\\Models\\Receipt',3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',48847.70,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL);
INSERT INTO `balance_libro` VALUES (3970,3661,40721,7600,3,3901,'App\\Models\\Receipt',3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',15000.01,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3971,3661,40721,7600,3,3902,'App\\Models\\Receipt',3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',7016.94,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3972,3661,40721,7600,3,3903,'App\\Models\\Receipt',3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',608.12,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3973,3661,40721,7600,3,3904,'App\\Models\\Receipt',3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',240471.10,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3974,3661,40721,7600,3,3905,'App\\Models\\Receipt',3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',44169.59,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3975,3661,40721,7600,3,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',25643.33,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3976,3661,40721,7600,3,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',85653.70,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3977,3661,40721,7600,3,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',9348.85,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3978,3661,40721,7600,3,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',38276.27,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3979,3661,40721,7600,3,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',4858.10,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3980,3661,40721,7600,3,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',378.69,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3981,3661,40721,7600,3,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',179445.11,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3982,3661,40721,7600,3,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',62685.03,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3983,3661,40721,7600,3,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',55125.66,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3984,3661,40721,7600,3,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',42231.92,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3985,3661,40721,7600,3,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7727.25,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3986,3661,40721,7600,3,3917,'App\\Models\\Receipt',3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1724.00,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3987,3661,40721,7600,3,3918,'App\\Models\\Receipt',3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',533.16,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3988,3661,40721,7600,3,3919,'App\\Models\\Receipt',3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',187746.76,NULL,NULL,1,'2022-03-30 15:34:36','2022-03-30 15:34:36',NULL),(3989,3661,40721,3057,2,3920,'App\\Models\\Receipt',3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',3750.04,NULL,NULL,1,'2022-03-30 16:03:43','2022-03-30 16:03:43',NULL),(3990,3661,40721,3057,2,3921,'App\\Models\\Receipt',3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',2050.00,NULL,NULL,1,'2022-03-30 16:03:43','2022-03-30 16:03:43',NULL);
INSERT INTO `balance_libro` VALUES (3991,3661,40721,3057,2,3922,'App\\Models\\Receipt',3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-27','2022-02-27',1519.01,NULL,NULL,1,'2022-03-30 16:03:43','2022-03-30 16:03:43',NULL),(3992,3661,40722,4574,2,3923,'App\\Models\\Receipt',3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',236360.00,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(3993,3661,40722,4574,2,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',241200.00,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(3994,3661,40722,4574,2,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',149672.00,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(3995,3661,40722,4574,2,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',105128.16,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(3996,3661,40722,4574,2,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',239990.00,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(3997,3661,40722,4574,2,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',262268.00,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(3998,3661,40722,4574,2,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',241200.00,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(3999,3661,40722,4574,2,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',156250.93,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(4000,3661,40722,4574,2,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',186897.20,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(4001,3661,40722,4574,2,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',240595.00,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(4002,3661,40722,4574,2,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',236360.00,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(4003,3661,40722,4574,2,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',342748.24,NULL,NULL,1,'2022-04-22 08:42:38','2022-04-22 08:42:38',NULL),(4004,3661,40722,4574,3,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4759.01,NULL,NULL,1,'2022-04-22 08:42:55','2022-04-22 08:42:55',NULL),(4005,3661,40722,4574,3,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',40000.00,NULL,NULL,1,'2022-04-22 08:42:55','2022-04-22 08:42:55',NULL),(4006,3661,40722,4574,3,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',12287.55,NULL,NULL,1,'2022-04-22 08:42:55','2022-04-22 08:42:55',NULL),(4007,3661,40722,4574,3,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',11679.00,NULL,NULL,1,'2022-04-22 08:42:55','2022-04-22 08:42:55',NULL),(4008,3661,40722,4574,3,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',0.00,NULL,NULL,1,'2022-04-22 08:42:55','2022-04-22 08:42:55',NULL),(4009,3661,40723,6089,2,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',10890.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4010,3661,40723,6089,2,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',42950.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4011,3661,40723,6089,2,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',10043.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL);
INSERT INTO `balance_libro` VALUES (4012,3661,40723,6089,2,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',15268.50,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4013,3661,40723,6089,2,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',7865.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4014,3661,40723,6089,2,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',23595.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4015,3661,40723,6089,2,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',12705.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4016,3661,40723,6089,2,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',12705.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4017,3661,40723,6089,2,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',18150.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4018,3661,40723,6089,2,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',5445.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4019,3661,40723,6089,2,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',5445.00,NULL,NULL,1,'2022-04-22 09:38:06','2022-04-22 09:38:06',NULL),(4020,3661,40723,6089,3,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',76782.00,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4021,3661,40723,6089,3,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',295.00,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4022,3661,40723,6089,3,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',5949.15,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4023,3661,40723,6089,3,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',24627.75,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4024,3661,40723,6089,3,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',15300.00,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4025,3661,40723,6089,3,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',100000.00,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4026,3661,40723,6089,3,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',3358.95,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4027,3661,40723,6089,3,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',100000.00,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4028,3661,40723,6089,3,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',29980.00,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4029,3661,40723,6089,3,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',100000.00,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4030,3661,40723,6089,3,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',55000.00,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4031,3661,40723,6089,3,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',2692.29,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4032,3661,40723,6089,3,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',2414.87,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL);
INSERT INTO `balance_libro` VALUES (4033,3661,40723,6089,3,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',25742.87,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4034,3661,40723,6089,3,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',24313.27,NULL,NULL,1,'2022-04-22 09:38:17','2022-04-22 09:38:17',NULL),(4035,3661,40720,1547,2,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',30153.20,NULL,NULL,1,'2022-04-22 10:05:57','2022-04-22 10:05:57',NULL),(4036,3661,40720,1547,2,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',126020.05,NULL,NULL,1,'2022-04-22 10:05:57','2022-04-22 10:05:57',NULL),(4037,3661,40720,1547,2,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',25742.75,NULL,NULL,1,'2022-04-22 10:05:57','2022-04-22 10:05:57',NULL),(4038,3661,40720,1547,2,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',8874.00,NULL,NULL,1,'2022-04-22 10:05:57','2022-04-22 10:05:57',NULL),(4039,3661,40720,1547,2,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',9017.00,NULL,NULL,1,'2022-04-22 10:06:16','2022-04-22 10:06:16',NULL),(4040,3661,40720,1547,2,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1515.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4041,3661,40720,1547,2,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2254.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4042,3661,40720,1547,2,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',3903.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4043,3661,40720,1547,2,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',6429.01,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4044,3661,40720,1547,2,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',7874.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4045,3661,40720,1547,2,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',8679.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4046,3661,40720,1547,2,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2276.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4047,3661,40720,1547,2,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',767.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4048,3661,40720,1547,2,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2276.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4049,3661,40720,1547,2,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',767.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4050,3661,40720,1547,2,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',9292.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4051,3661,40720,1547,2,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',3976.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4052,3661,40720,1547,2,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',9846.40,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4053,3661,40720,1547,2,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',6340.05,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL);
INSERT INTO `balance_libro` VALUES (4054,3661,40720,1547,2,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2226.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4055,3661,40720,1547,2,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',17725.01,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4056,3661,40720,1547,2,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',7610.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4057,3661,40720,1547,2,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',4776.01,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4058,3661,40720,1547,2,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1371.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4059,3661,40720,1547,2,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',2929.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4060,3661,40720,1547,2,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1825.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4061,3661,40720,1547,2,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',714.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4062,3661,40720,1547,2,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',2015.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4063,3661,40720,1547,2,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1254.00,NULL,NULL,1,'2022-04-22 10:06:17','2022-04-22 10:06:17',NULL),(4064,3661,40720,1547,3,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',96726.00,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4065,3661,40720,1547,3,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',25411.21,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4066,3661,40720,1547,3,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',14238.88,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4067,3661,40720,1547,3,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2349.00,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4068,3661,40720,1547,3,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1084.16,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4069,3661,40720,1547,3,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',30000.00,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4070,3661,40720,1547,3,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',20757.55,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4071,3661,40720,1547,3,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',0.00,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4072,3661,40720,1547,3,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',3630.00,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4073,3661,40720,1547,3,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',5469.01,NULL,NULL,1,'2022-04-22 10:06:34','2022-04-22 10:06:34',NULL),(4074,3661,40720,1547,3,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',3949.84,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL);
INSERT INTO `balance_libro` VALUES (4075,3661,40720,1547,3,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',4700.00,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4076,3661,40720,1547,3,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',7002.27,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4077,3661,40720,1547,3,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',300.00,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4078,3661,40720,1547,3,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',2959.46,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4079,3661,40720,1547,3,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',713.90,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4080,3661,40720,1547,3,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1836.89,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4081,3661,40720,1547,3,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1813.19,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4082,3661,40720,1547,3,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',308.22,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4083,3661,40720,1547,3,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',8000.00,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4084,3661,40720,1547,3,4015,'App\\Models\\Receipt',4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',7139.00,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4085,3661,40720,1547,3,4016,'App\\Models\\Receipt',4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',7505.42,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4086,3661,40720,1547,3,4017,'App\\Models\\Receipt',4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3750.00,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4087,3661,40720,1547,3,4018,'App\\Models\\Receipt',4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',300.00,NULL,NULL,1,'2022-04-22 10:06:35','2022-04-22 10:06:35',NULL),(4088,3661,40721,3058,2,4019,'App\\Models\\Receipt',4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',2590.00,NULL,NULL,1,'2022-04-22 12:23:42','2022-04-22 12:23:42',NULL),(4089,3661,40721,3058,2,4020,'App\\Models\\Receipt',4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',2360.00,NULL,NULL,1,'2022-04-22 12:23:42','2022-04-22 12:23:42',NULL),(4090,3661,40721,3058,2,4021,'App\\Models\\Receipt',4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',3400.00,NULL,NULL,1,'2022-04-22 12:23:42','2022-04-22 12:23:42',NULL),(4091,3661,40721,3058,2,4022,'App\\Models\\Receipt',4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',1430.00,NULL,NULL,1,'2022-04-22 12:23:42','2022-04-22 12:23:42',NULL),(4092,3661,40721,3058,2,4023,'App\\Models\\Receipt',4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',6000.00,NULL,NULL,1,'2022-04-22 12:23:42','2022-04-22 12:23:42',NULL),(4093,3661,40721,3058,2,4024,'App\\Models\\Receipt',4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',4690.00,NULL,NULL,1,'2022-04-22 12:23:42','2022-04-22 12:23:42',NULL),(4094,3661,40721,3058,2,4025,'App\\Models\\Receipt',4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',3190.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4095,3661,40721,3058,2,4026,'App\\Models\\Receipt',4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1.20,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL);
INSERT INTO `balance_libro` VALUES (4096,3661,40721,3058,2,4027,'App\\Models\\Receipt',4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',0.10,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4097,3661,40721,3058,2,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',2510.02,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4098,3661,40721,3058,2,4029,'App\\Models\\Receipt',4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1610.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4099,3661,40721,3058,2,4030,'App\\Models\\Receipt',4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',420.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4100,3661,40721,3058,2,4031,'App\\Models\\Receipt',4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',2390.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4101,3661,40721,3058,2,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',3700.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4102,3661,40721,3058,2,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',3490.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4103,3661,40721,3058,2,4034,'App\\Models\\Receipt',4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',5000.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4104,3661,40721,3058,2,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',2990.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4105,3661,40721,3058,2,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',2640.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4106,3661,40721,3058,2,4037,'App\\Models\\Receipt',4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',4510.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4107,3661,40721,3058,2,4038,'App\\Models\\Receipt',4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',3260.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4108,3661,40721,3058,2,4039,'App\\Models\\Receipt',4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',4370.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4109,3661,40721,3058,2,4040,'App\\Models\\Receipt',4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',2010.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4110,3661,40721,3058,2,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',3440.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4111,3661,40721,3058,2,4042,'App\\Models\\Receipt',4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',2510.02,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4112,3661,40721,3058,2,4043,'App\\Models\\Receipt',4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',1880.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4113,3661,40721,3058,2,4044,'App\\Models\\Receipt',4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',2770.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4114,3661,40721,3058,2,4045,'App\\Models\\Receipt',4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',6650.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4115,3661,40721,3058,2,4046,'App\\Models\\Receipt',4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',2360.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4116,3661,40721,3058,2,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',4610.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL);
INSERT INTO `balance_libro` VALUES (4117,3661,40721,3058,2,4048,'App\\Models\\Receipt',4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',6930.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4118,3661,40721,3058,2,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',1710.00,NULL,NULL,1,'2022-04-22 12:23:43','2022-04-22 12:23:43',NULL),(4119,3661,40721,3058,3,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',4000.00,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4120,3661,40721,3058,3,4051,'App\\Models\\Receipt',4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',4323.09,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4121,3661,40721,3058,3,4052,'App\\Models\\Receipt',4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',13319.00,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4122,3661,40721,3058,3,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1024.18,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4123,3661,40721,3058,3,4054,'App\\Models\\Receipt',4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',170548.22,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4124,3661,40721,3058,3,4055,'App\\Models\\Receipt',4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',4438.79,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4125,3661,40721,3058,3,4056,'App\\Models\\Receipt',4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',2932.82,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4126,3661,40721,3058,3,4057,'App\\Models\\Receipt',4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',16223.07,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4127,3661,40721,3058,3,4058,'App\\Models\\Receipt',4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',9516.23,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4128,3661,40721,3058,3,4059,'App\\Models\\Receipt',4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',2601.50,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4129,3661,40721,3058,3,4060,'App\\Models\\Receipt',4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',48847.70,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4130,3661,40721,3058,3,4061,'App\\Models\\Receipt',4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',11266.01,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4131,3661,40721,3058,3,4062,'App\\Models\\Receipt',4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',11818.70,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4132,3661,40721,3058,3,4063,'App\\Models\\Receipt',4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',824.39,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4133,3661,40721,3058,3,4064,'App\\Models\\Receipt',4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',209931.25,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4134,3661,40721,3058,3,4065,'App\\Models\\Receipt',4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',35160.86,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4135,3661,40721,3058,3,4066,'App\\Models\\Receipt',4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',12205.82,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4136,3661,40721,3058,3,4067,'App\\Models\\Receipt',4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',20597.31,NULL,NULL,1,'2022-04-22 12:23:55','2022-04-22 12:23:55',NULL),(4137,3661,40721,3058,3,4068,'App\\Models\\Receipt',4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',13757.70,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL);
INSERT INTO `balance_libro` VALUES (4138,3661,40721,3058,3,4069,'App\\Models\\Receipt',4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',195491.11,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4139,3661,40721,3058,3,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1157.66,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4140,3661,40721,3058,3,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',0.00,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4141,3661,40721,3058,3,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',9875.39,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4142,3661,40721,3058,3,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',36747.89,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4143,3661,40721,3058,3,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',15739.41,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4144,3661,40721,3058,3,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',781.49,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4145,3661,40721,3058,3,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',265531.00,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4146,3661,40721,3058,3,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',16573.73,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4147,3661,40721,3058,3,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2868.00,NULL,NULL,1,'2022-04-22 12:23:56','2022-04-22 12:23:56',NULL),(4175,3661,41336,7689,2,4106,'App\\Models\\Receipt',4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4100.00,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:36','2022-04-23 07:54:36'),(4176,3661,41336,7689,2,4107,'App\\Models\\Receipt',4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2800.00,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:31','2022-04-23 07:54:31'),(4177,3661,41336,7689,2,4108,'App\\Models\\Receipt',4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',2386.12,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:28','2022-04-23 07:54:28'),(4178,3661,41336,7689,2,4109,'App\\Models\\Receipt',4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2386.12,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:24','2022-04-23 07:54:24'),(4179,3661,41336,7689,2,4110,'App\\Models\\Receipt',4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',12912.64,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:21','2022-04-23 07:54:21'),(4180,3661,41336,7689,2,4111,'App\\Models\\Receipt',4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1231.26,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:18','2022-04-23 07:54:18'),(4181,3661,41336,7689,2,4112,'App\\Models\\Receipt',4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1969.67,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:14','2022-04-23 07:54:14'),(4182,3661,41336,7689,2,4113,'App\\Models\\Receipt',4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',3923.86,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:11','2022-04-23 07:54:11'),(4183,3661,41336,7689,2,4114,'App\\Models\\Receipt',4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',4669.39,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:07','2022-04-23 07:54:07'),(4184,3661,41336,7689,2,4115,'App\\Models\\Receipt',4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',0.00,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:54:01','2022-04-23 07:54:01');
INSERT INTO `balance_libro` VALUES (4185,3661,41336,7689,2,4116,'App\\Models\\Receipt',4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',5474.40,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:59','2022-04-23 07:53:59'),(4186,3661,41336,7689,2,4117,'App\\Models\\Receipt',4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',351.46,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:55','2022-04-23 07:53:55'),(4187,3661,41336,7689,2,4118,'App\\Models\\Receipt',4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',5592.02,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:52','2022-04-23 07:53:52'),(4188,3661,41336,7689,2,4119,'App\\Models\\Receipt',4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',406.81,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:47','2022-04-23 07:53:47'),(4189,3661,41336,7689,2,4120,'App\\Models\\Receipt',4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',7757.02,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:43','2022-04-23 07:53:43'),(4190,3661,41336,7689,2,4121,'App\\Models\\Receipt',4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1208.79,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:40','2022-04-23 07:53:40'),(4191,3661,41336,7689,2,4122,'App\\Models\\Receipt',4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1208.79,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:34','2022-04-23 07:53:34'),(4192,3661,41336,7689,2,4123,'App\\Models\\Receipt',4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',565.30,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:26','2022-04-23 07:53:26'),(4193,3661,41336,7689,2,4124,'App\\Models\\Receipt',4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1847.00,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:23','2022-04-23 07:53:23'),(4194,3661,41336,7689,2,4125,'App\\Models\\Receipt',4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',8712.00,NULL,NULL,1,'2022-04-23 07:52:07','2022-04-23 07:53:20','2022-04-23 07:53:20'),(4195,3661,41336,7689,3,4126,'App\\Models\\Receipt',4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4100.00,NULL,NULL,1,'2022-04-23 07:52:39','2022-04-23 07:52:39',NULL),(4196,3661,41336,7689,3,4127,'App\\Models\\Receipt',4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2800.00,NULL,NULL,1,'2022-04-23 07:52:39','2022-04-23 07:52:39',NULL),(4197,3661,41336,7689,3,4128,'App\\Models\\Receipt',4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',2386.12,NULL,NULL,1,'2022-04-23 07:52:39','2022-04-23 07:52:39',NULL),(4198,3661,41336,7689,3,4129,'App\\Models\\Receipt',4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2386.12,NULL,NULL,1,'2022-04-23 07:52:39','2022-04-23 07:52:39',NULL),(4199,3661,41336,7689,3,4130,'App\\Models\\Receipt',4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',12912.64,NULL,NULL,1,'2022-04-23 07:52:39','2022-04-23 07:52:39',NULL),(4200,3661,41336,7689,3,4131,'App\\Models\\Receipt',4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1231.26,NULL,NULL,1,'2022-04-23 07:52:39','2022-04-23 07:52:39',NULL),(4201,3661,41336,7689,3,4132,'App\\Models\\Receipt',4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1969.67,NULL,NULL,1,'2022-04-23 07:52:39','2022-04-23 07:52:39',NULL),(4202,3661,41336,7689,3,4133,'App\\Models\\Receipt',4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',3923.86,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4203,3661,41336,7689,3,4134,'App\\Models\\Receipt',4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',4669.39,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4204,3661,41336,7689,3,4135,'App\\Models\\Receipt',4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',0.00,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL);
INSERT INTO `balance_libro` VALUES (4205,3661,41336,7689,3,4136,'App\\Models\\Receipt',4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',5474.40,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4206,3661,41336,7689,3,4137,'App\\Models\\Receipt',4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',351.46,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4207,3661,41336,7689,3,4138,'App\\Models\\Receipt',4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',5592.02,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4208,3661,41336,7689,3,4139,'App\\Models\\Receipt',4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',406.81,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4209,3661,41336,7689,3,4140,'App\\Models\\Receipt',4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',7757.02,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4210,3661,41336,7689,3,4141,'App\\Models\\Receipt',4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1208.79,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4211,3661,41336,7689,3,4142,'App\\Models\\Receipt',4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1208.79,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4212,3661,41336,7689,3,4143,'App\\Models\\Receipt',4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',565.30,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4213,3661,41336,7689,3,4144,'App\\Models\\Receipt',4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1847.00,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4214,3661,41336,7689,3,4145,'App\\Models\\Receipt',4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',8712.00,NULL,NULL,1,'2022-04-23 07:52:40','2022-04-23 07:52:40',NULL),(4457,3661,41336,7689,2,4388,'App\\Models\\Receipt',4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',440.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4458,3661,41336,7689,2,4389,'App\\Models\\Receipt',4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',520.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4459,3661,41336,7689,2,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',1170.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4460,3661,41336,7689,2,4391,'App\\Models\\Receipt',4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',580.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4461,3661,41336,7689,2,4392,'App\\Models\\Receipt',4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',470.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4462,3661,41336,7689,2,4393,'App\\Models\\Receipt',4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',440.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4463,3661,41336,7689,2,4394,'App\\Models\\Receipt',4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',1000.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4464,3661,41336,7689,2,4395,'App\\Models\\Receipt',4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1800.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4465,3661,41336,7689,2,4396,'App\\Models\\Receipt',4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',500.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4466,3661,41336,7689,2,4397,'App\\Models\\Receipt',4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1040.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4467,3661,41336,7689,2,4398,'App\\Models\\Receipt',4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',760.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL);
INSERT INTO `balance_libro` VALUES (4468,3661,41336,7689,2,4399,'App\\Models\\Receipt',4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',500.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4469,3661,41336,7689,2,4400,'App\\Models\\Receipt',4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2370.00,NULL,NULL,1,'2022-04-23 08:07:00','2022-04-23 08:07:00',NULL),(4470,3661,41336,7689,2,4401,'App\\Models\\Receipt',4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1480.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4471,3661,41336,7689,2,4402,'App\\Models\\Receipt',4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',3820.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4472,3661,41336,7689,2,4403,'App\\Models\\Receipt',4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2030.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4473,3661,41336,7689,2,4404,'App\\Models\\Receipt',4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1000.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4474,3661,41336,7689,2,4405,'App\\Models\\Receipt',4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1040.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4475,3661,41336,7689,2,4406,'App\\Models\\Receipt',4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1840.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4476,3661,41336,7689,2,4407,'App\\Models\\Receipt',4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',100.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4477,3661,41336,7689,2,4408,'App\\Models\\Receipt',4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',690.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4478,3661,41336,7689,2,4409,'App\\Models\\Receipt',4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1280.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4479,3661,41336,7689,2,4410,'App\\Models\\Receipt',4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1060.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4480,3661,41336,7689,2,4411,'App\\Models\\Receipt',4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1520.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4481,3661,41336,7689,2,4412,'App\\Models\\Receipt',4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1570.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4482,3661,41336,7689,2,4413,'App\\Models\\Receipt',4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',490.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4483,3661,41336,7689,2,4414,'App\\Models\\Receipt',4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1230.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4484,3661,41336,7689,2,4415,'App\\Models\\Receipt',4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1790.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4485,3661,41336,7689,2,4416,'App\\Models\\Receipt',4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1230.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4486,3661,41336,7689,2,4417,'App\\Models\\Receipt',4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1790.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4487,3661,41336,7689,2,4418,'App\\Models\\Receipt',4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',500.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4488,3661,41336,7689,2,4419,'App\\Models\\Receipt',4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',500.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL);
INSERT INTO `balance_libro` VALUES (4489,3661,41336,7689,2,4420,'App\\Models\\Receipt',4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',240.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4490,3661,41336,7689,2,4421,'App\\Models\\Receipt',4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',520.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4491,3661,41336,7689,2,4422,'App\\Models\\Receipt',4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1420.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4492,3661,41336,7689,2,4423,'App\\Models\\Receipt',4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',720.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4493,3661,41336,7689,2,4424,'App\\Models\\Receipt',4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',490.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4494,3661,41336,7689,2,4425,'App\\Models\\Receipt',4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1380.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4495,3661,41336,7689,2,4426,'App\\Models\\Receipt',4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1790.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4496,3661,41336,7689,2,4427,'App\\Models\\Receipt',4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1840.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4497,3661,41336,7689,2,4428,'App\\Models\\Receipt',4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',210.00,NULL,NULL,1,'2022-04-23 08:07:01','2022-04-23 08:07:01',NULL),(4498,3661,41336,7689,2,4429,'App\\Models\\Receipt',4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1230.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4499,3661,41336,7689,2,4430,'App\\Models\\Receipt',4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1585.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4500,3661,41336,7689,2,4431,'App\\Models\\Receipt',4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1790.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4501,3661,41336,7689,2,4432,'App\\Models\\Receipt',4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2380.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4502,3661,41336,7689,2,4433,'App\\Models\\Receipt',4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2440.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4503,3661,41336,7689,2,4434,'App\\Models\\Receipt',4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1560.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4504,3661,41336,7689,2,4435,'App\\Models\\Receipt',4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1280.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4505,3661,41336,7689,2,4436,'App\\Models\\Receipt',4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1660.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4506,3661,41336,7689,2,4437,'App\\Models\\Receipt',4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2580.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4507,3661,41336,7689,2,4438,'App\\Models\\Receipt',4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1330.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4508,3661,41336,7689,2,4439,'App\\Models\\Receipt',4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2330.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4509,3661,41336,7689,2,4440,'App\\Models\\Receipt',4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1350.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL);
INSERT INTO `balance_libro` VALUES (4510,3661,41336,7689,2,4441,'App\\Models\\Receipt',4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',3230.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4511,3661,41336,7689,2,4442,'App\\Models\\Receipt',4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2600.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4512,3661,41336,7689,2,4443,'App\\Models\\Receipt',4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2380.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4513,3661,41336,7689,2,4444,'App\\Models\\Receipt',4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2030.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4514,3661,41336,7689,2,4445,'App\\Models\\Receipt',4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',608.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4515,3661,41336,7689,2,4446,'App\\Models\\Receipt',4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',2440.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4516,3661,41336,7689,2,4447,'App\\Models\\Receipt',4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1840.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4517,3661,41336,7689,2,4448,'App\\Models\\Receipt',4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1830.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4518,3661,41336,7689,2,4449,'App\\Models\\Receipt',4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',11250.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4519,3661,41336,7689,2,4450,'App\\Models\\Receipt',4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',6000.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4520,3661,41336,7689,2,4451,'App\\Models\\Receipt',4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',6000.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4521,3661,41336,7689,2,4452,'App\\Models\\Receipt',4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',3320.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4522,3661,41336,7689,2,4453,'App\\Models\\Receipt',4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',810.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4523,3661,41336,7689,2,4454,'App\\Models\\Receipt',4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',520.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4524,3661,41336,7689,2,4455,'App\\Models\\Receipt',4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1040.00,NULL,NULL,1,'2022-04-23 08:07:02','2022-04-23 08:07:02',NULL),(4525,3661,41336,7689,2,4456,'App\\Models\\Receipt',4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',770.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4526,3661,41336,7689,2,4457,'App\\Models\\Receipt',4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',790.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4527,3661,41336,7689,2,4458,'App\\Models\\Receipt',4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',250.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4528,3661,41336,7689,2,4459,'App\\Models\\Receipt',4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',670.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4529,3661,41336,7689,2,4460,'App\\Models\\Receipt',4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1210.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4530,3661,41336,7689,2,4461,'App\\Models\\Receipt',4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',470.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL);
INSERT INTO `balance_libro` VALUES (4531,3661,41336,7689,2,4462,'App\\Models\\Receipt',4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1460.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4532,3661,41336,7689,2,4463,'App\\Models\\Receipt',4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',580.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4533,3661,41336,7689,2,4464,'App\\Models\\Receipt',4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1410.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4534,3661,41336,7689,2,4465,'App\\Models\\Receipt',4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1000.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4535,3661,41336,7689,2,4466,'App\\Models\\Receipt',4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1732.50,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4536,3661,41336,7689,2,4467,'App\\Models\\Receipt',4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1370.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4537,3661,41336,7689,2,4468,'App\\Models\\Receipt',4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',2259.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4538,3661,41336,7689,2,4469,'App\\Models\\Receipt',4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',882.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4539,3661,41336,7689,2,4470,'App\\Models\\Receipt',4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1488.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4540,3661,41336,7689,2,4471,'App\\Models\\Receipt',4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',594.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4541,3661,41336,7689,2,4472,'App\\Models\\Receipt',4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1230.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4542,3661,41336,7689,2,4473,'App\\Models\\Receipt',4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',2150.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4543,3661,41336,7689,2,4474,'App\\Models\\Receipt',4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1340.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4544,3661,41336,7689,2,4475,'App\\Models\\Receipt',4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',250.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4545,3661,41336,7689,2,4476,'App\\Models\\Receipt',4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',632.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4546,3661,41336,7689,2,4477,'App\\Models\\Receipt',4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2530.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4547,3661,41336,7689,2,4478,'App\\Models\\Receipt',4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1960.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4548,3661,41336,7689,2,4479,'App\\Models\\Receipt',4479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',390.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4549,3661,41336,7689,2,4480,'App\\Models\\Receipt',4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',608.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4550,3661,41336,7689,2,4481,'App\\Models\\Receipt',4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',760.00,NULL,NULL,1,'2022-04-23 08:07:03','2022-04-23 08:07:03',NULL),(4551,3661,41336,7689,2,4482,'App\\Models\\Receipt',4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',860.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL);
INSERT INTO `balance_libro` VALUES (4552,3661,41336,7689,2,4483,'App\\Models\\Receipt',4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1340.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4553,3661,41336,7689,2,4484,'App\\Models\\Receipt',4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1400.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4554,3661,41336,7689,2,4485,'App\\Models\\Receipt',4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1190.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4555,3661,41336,7689,2,4486,'App\\Models\\Receipt',4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1510.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4556,3661,41336,7689,2,4487,'App\\Models\\Receipt',4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',780.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4557,3661,41336,7689,2,4488,'App\\Models\\Receipt',4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',510.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4558,3661,41336,7689,2,4489,'App\\Models\\Receipt',4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',290.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4559,3661,41336,7689,2,4490,'App\\Models\\Receipt',4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1070.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4560,3661,41336,7689,2,4491,'App\\Models\\Receipt',4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1680.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4561,3661,41336,7689,2,4492,'App\\Models\\Receipt',4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',760.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4562,3661,41336,7689,2,4493,'App\\Models\\Receipt',4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',2300.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4563,3661,41336,7689,2,4494,'App\\Models\\Receipt',4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1510.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4564,3661,41336,7689,2,4495,'App\\Models\\Receipt',4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',880.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4565,3661,41336,7689,2,4496,'App\\Models\\Receipt',4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',810.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4566,3661,41336,7689,2,4497,'App\\Models\\Receipt',4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',190.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4567,3661,41336,7689,2,4498,'App\\Models\\Receipt',4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1420.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4568,3661,41336,7689,2,4499,'App\\Models\\Receipt',4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1000.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4569,3661,41336,7689,2,4500,'App\\Models\\Receipt',4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',190.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4570,3661,41336,7689,2,4501,'App\\Models\\Receipt',4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1000.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4571,3661,41336,7689,2,4502,'App\\Models\\Receipt',4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',790.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4572,3661,41336,7689,2,4503,'App\\Models\\Receipt',4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',3080.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL);
INSERT INTO `balance_libro` VALUES (4573,3661,41336,7689,2,4504,'App\\Models\\Receipt',4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1040.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4574,3661,41336,7689,2,4505,'App\\Models\\Receipt',4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',400.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4575,3661,41336,7689,2,4506,'App\\Models\\Receipt',4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1040.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4576,3661,41336,7689,2,4507,'App\\Models\\Receipt',4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',4070.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4577,3661,41336,7689,2,4508,'App\\Models\\Receipt',4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1440.00,NULL,NULL,1,'2022-04-23 08:07:04','2022-04-23 08:07:04',NULL),(4578,3661,41336,7689,2,4509,'App\\Models\\Receipt',4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',750.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4579,3661,41336,7689,2,4510,'App\\Models\\Receipt',4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',500.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4580,3661,41336,7689,2,4511,'App\\Models\\Receipt',4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',760.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4581,3661,41336,7689,2,4512,'App\\Models\\Receipt',4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',350.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4582,3661,41336,7689,2,4513,'App\\Models\\Receipt',4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1040.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4583,3661,41336,7689,2,4514,'App\\Models\\Receipt',4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1000.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4584,3661,41336,7689,2,4515,'App\\Models\\Receipt',4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',400.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4585,3661,41336,7689,2,4516,'App\\Models\\Receipt',4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',350.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4586,3661,41336,7689,2,4517,'App\\Models\\Receipt',4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',2080.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4587,3661,41336,7689,2,4518,'App\\Models\\Receipt',4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',850.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4588,3661,41336,7689,2,4519,'App\\Models\\Receipt',4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1100.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4589,3661,41336,7689,2,4520,'App\\Models\\Receipt',4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1270.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4590,3661,41336,7689,2,4521,'App\\Models\\Receipt',4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',500.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4591,3661,41336,7689,2,4522,'App\\Models\\Receipt',4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1440.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4592,3661,41336,7689,2,4523,'App\\Models\\Receipt',4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1480.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4593,3661,41336,7689,2,4524,'App\\Models\\Receipt',4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1900.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL);
INSERT INTO `balance_libro` VALUES (4594,3661,41336,7689,2,4525,'App\\Models\\Receipt',4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',700.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4595,3661,41336,7689,2,4526,'App\\Models\\Receipt',4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',770.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4596,3661,41336,7689,2,4527,'App\\Models\\Receipt',4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1520.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4597,3661,41336,7689,2,4528,'App\\Models\\Receipt',4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',390.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4598,3661,41336,7689,2,4529,'App\\Models\\Receipt',4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1270.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4599,3661,41336,7689,2,4530,'App\\Models\\Receipt',4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',870.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4600,3661,41336,7689,2,4531,'App\\Models\\Receipt',4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1000.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4601,3661,41336,7689,2,4532,'App\\Models\\Receipt',4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1510.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4602,3661,41336,7689,2,4533,'App\\Models\\Receipt',4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',2220.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4603,3661,41336,7689,2,4534,'App\\Models\\Receipt',4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',500.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4604,3661,41336,7689,2,4535,'App\\Models\\Receipt',4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',920.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4605,3661,41336,7689,2,4536,'App\\Models\\Receipt',4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1910.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4606,3661,41336,7689,2,4537,'App\\Models\\Receipt',4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',420.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4607,3661,41336,7689,2,4538,'App\\Models\\Receipt',4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1520.00,NULL,NULL,1,'2022-04-23 08:07:05','2022-04-23 08:07:05',NULL),(4608,3661,41336,7689,2,4539,'App\\Models\\Receipt',4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',580.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4609,3661,41336,7689,2,4540,'App\\Models\\Receipt',4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',815.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4610,3661,41336,7689,2,4541,'App\\Models\\Receipt',4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1560.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4611,3661,41336,7689,2,4542,'App\\Models\\Receipt',4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',783.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4612,3661,41336,7689,2,4543,'App\\Models\\Receipt',4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',250.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4613,3661,41336,7689,2,4544,'App\\Models\\Receipt',4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',270.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4614,3661,41336,7689,2,4545,'App\\Models\\Receipt',4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',441.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL);
INSERT INTO `balance_libro` VALUES (4615,3661,41336,7689,2,4546,'App\\Models\\Receipt',4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1610.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4616,3661,41336,7689,2,4547,'App\\Models\\Receipt',4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',3750.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4617,3661,41336,7689,2,4548,'App\\Models\\Receipt',4548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1510.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4618,3661,41336,7689,2,4549,'App\\Models\\Receipt',4549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1440.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4619,3661,41336,7689,2,4550,'App\\Models\\Receipt',4550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1440.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4620,3661,41336,7689,2,4551,'App\\Models\\Receipt',4551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2016.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4621,3661,41336,7689,2,4552,'App\\Models\\Receipt',4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2190.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4622,3661,41336,7689,2,4553,'App\\Models\\Receipt',4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',190.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4623,3661,41336,7689,2,4554,'App\\Models\\Receipt',4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',450.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4624,3661,41336,7689,2,4555,'App\\Models\\Receipt',4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',250.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4625,3661,41336,7689,2,4556,'App\\Models\\Receipt',4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',660.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4626,3661,41336,7689,2,4557,'App\\Models\\Receipt',4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',520.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4627,3661,41336,7689,2,4558,'App\\Models\\Receipt',4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',815.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4628,3661,41336,7689,2,4559,'App\\Models\\Receipt',4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',400.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4629,3661,41336,7689,2,4560,'App\\Models\\Receipt',4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1050.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4630,3661,41336,7689,2,4561,'App\\Models\\Receipt',4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1280.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4631,3661,41336,7689,2,4562,'App\\Models\\Receipt',4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1000.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4632,3661,41336,7689,2,4563,'App\\Models\\Receipt',4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',3000.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4633,3661,41336,7689,2,4564,'App\\Models\\Receipt',4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2090.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4634,3661,41336,7689,2,4565,'App\\Models\\Receipt',4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',820.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4635,3661,41336,7689,2,4566,'App\\Models\\Receipt',4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2620.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL);
INSERT INTO `balance_libro` VALUES (4636,3661,41336,7689,2,4567,'App\\Models\\Receipt',4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',3270.00,NULL,NULL,1,'2022-04-23 08:07:06','2022-04-23 08:07:06',NULL),(4637,3661,41336,7689,2,4568,'App\\Models\\Receipt',4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',2020.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4638,3661,41336,7689,2,4569,'App\\Models\\Receipt',4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1680.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4639,3661,41336,7689,2,4570,'App\\Models\\Receipt',4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',500.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4640,3661,41336,7689,2,4571,'App\\Models\\Receipt',4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',670.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4641,3661,41336,7689,2,4572,'App\\Models\\Receipt',4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',2770.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4642,3661,41336,7689,2,4573,'App\\Models\\Receipt',4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1000.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4643,3661,41336,7689,2,4574,'App\\Models\\Receipt',4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',2180.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4644,3661,41336,7689,2,4575,'App\\Models\\Receipt',4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1910.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4645,3661,41336,7689,2,4576,'App\\Models\\Receipt',4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',3270.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4646,3661,41336,7689,2,4577,'App\\Models\\Receipt',4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',2779.50,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4647,3661,41336,7689,2,4578,'App\\Models\\Receipt',4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',2020.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4648,3661,41336,7689,2,4579,'App\\Models\\Receipt',4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',735.30,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4649,3661,41336,7689,2,4580,'App\\Models\\Receipt',4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1250.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4650,3661,41336,7689,2,4581,'App\\Models\\Receipt',4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',850.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4651,3661,41336,7689,2,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',5250.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4652,3661,41336,7689,2,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1040.40,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4653,3661,41336,7689,2,4584,'App\\Models\\Receipt',4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1680.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4654,3661,41336,7689,2,4585,'App\\Models\\Receipt',4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1813.50,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4655,3661,41336,7689,2,4586,'App\\Models\\Receipt',4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1870.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4656,3661,41336,7689,2,4587,'App\\Models\\Receipt',4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',3130.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL);
INSERT INTO `balance_libro` VALUES (4657,3661,41336,7689,2,4588,'App\\Models\\Receipt',4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',7490.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4658,3661,41336,7689,2,4589,'App\\Models\\Receipt',4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',2030.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4659,3661,41336,7689,2,4590,'App\\Models\\Receipt',4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',2190.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4660,3661,41336,7689,2,4591,'App\\Models\\Receipt',4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',3550.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4661,3661,41336,7689,2,4592,'App\\Models\\Receipt',4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',365.50,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4662,3661,41336,7689,2,4593,'App\\Models\\Receipt',4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',620.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4663,3661,41336,7689,2,4594,'App\\Models\\Receipt',4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',790.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4664,3661,41336,7689,2,4595,'App\\Models\\Receipt',4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',1490.00,NULL,NULL,1,'2022-04-23 08:07:07','2022-04-23 08:07:07',NULL),(4665,3661,41336,7689,2,4596,'App\\Models\\Receipt',4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',430.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4666,3661,41336,7689,2,4597,'App\\Models\\Receipt',4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',1620.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4667,3661,41336,7689,2,4598,'App\\Models\\Receipt',4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',1260.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4668,3661,41336,7689,2,4599,'App\\Models\\Receipt',4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',940.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4669,3661,41336,7689,2,4600,'App\\Models\\Receipt',4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',3120.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4670,3661,41336,7689,2,4601,'App\\Models\\Receipt',4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',496.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4671,3661,41336,7689,2,4602,'App\\Models\\Receipt',4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',1147.50,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4672,3661,41336,7689,2,4603,'App\\Models\\Receipt',4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',625.50,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4673,3661,41336,7689,2,4604,'App\\Models\\Receipt',4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',1551.25,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4674,3661,41336,7689,2,4605,'App\\Models\\Receipt',4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',1050.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4675,3661,41336,7689,2,4606,'App\\Models\\Receipt',4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',2190.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4676,3661,41336,7689,2,4607,'App\\Models\\Receipt',4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',790.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4677,3661,41336,7689,2,4608,'App\\Models\\Receipt',4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',1737.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL);
INSERT INTO `balance_libro` VALUES (4678,3661,41336,7689,2,4609,'App\\Models\\Receipt',4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1610.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4679,3661,41336,7689,2,4610,'App\\Models\\Receipt',4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1610.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4680,3661,41336,7689,2,4611,'App\\Models\\Receipt',4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',270.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4681,3661,41336,7689,2,4612,'App\\Models\\Receipt',4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1610.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4682,3661,41336,7689,2,4613,'App\\Models\\Receipt',4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',500.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4683,3661,41336,7689,2,4614,'App\\Models\\Receipt',4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1030.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4684,3661,41336,7689,2,4615,'App\\Models\\Receipt',4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',500.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4685,3661,41336,7689,2,4616,'App\\Models\\Receipt',4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1220.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4686,3661,41336,7689,2,4617,'App\\Models\\Receipt',4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',570.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4687,3661,41336,7689,2,4618,'App\\Models\\Receipt',4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',500.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4688,3661,41336,7689,2,4619,'App\\Models\\Receipt',4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',580.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4689,3661,41336,7689,2,4620,'App\\Models\\Receipt',4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',390.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4690,3661,41336,7689,2,4621,'App\\Models\\Receipt',4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1410.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4691,3661,41336,7689,2,4622,'App\\Models\\Receipt',4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1510.00,NULL,NULL,1,'2022-04-23 08:07:08','2022-04-23 08:07:08',NULL),(4692,3661,41336,7689,2,4623,'App\\Models\\Receipt',4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1930.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4693,3661,41336,7689,2,4624,'App\\Models\\Receipt',4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',180.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4694,3661,41336,7689,2,4625,'App\\Models\\Receipt',4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1040.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4695,3661,41336,7689,2,4626,'App\\Models\\Receipt',4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1180.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4696,3661,41336,7689,2,4627,'App\\Models\\Receipt',4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',270.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4697,3661,41336,7689,2,4628,'App\\Models\\Receipt',4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1040.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4698,3661,41336,7689,2,4629,'App\\Models\\Receipt',4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',980.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL);
INSERT INTO `balance_libro` VALUES (4699,3661,41336,7689,2,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',9650.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4700,3661,41336,7689,2,4631,'App\\Models\\Receipt',4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',6000.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4701,3661,41336,7689,2,4632,'App\\Models\\Receipt',4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',380.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4702,3661,41336,7689,2,4633,'App\\Models\\Receipt',4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1820.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4703,3661,41336,7689,2,4634,'App\\Models\\Receipt',4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1000.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4704,3661,41336,7689,2,4635,'App\\Models\\Receipt',4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',290.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4705,3661,41336,7689,2,4636,'App\\Models\\Receipt',4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',190.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4706,3661,41336,7689,2,4637,'App\\Models\\Receipt',4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1260.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4707,3661,41336,7689,2,4638,'App\\Models\\Receipt',4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',740.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4708,3661,41336,7689,2,4639,'App\\Models\\Receipt',4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',441.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4709,3661,41336,7689,2,4640,'App\\Models\\Receipt',4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',552.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4710,3661,41336,7689,2,4641,'App\\Models\\Receipt',4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',790.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4711,3661,41336,7689,2,4642,'App\\Models\\Receipt',4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1410.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4712,3661,41336,7689,2,4643,'App\\Models\\Receipt',4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1840.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4713,3661,41336,7689,2,4644,'App\\Models\\Receipt',4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',3600.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4714,3661,41336,7689,2,4645,'App\\Models\\Receipt',4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',190.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4715,3661,41336,7689,2,4646,'App\\Models\\Receipt',4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',190.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4716,3661,41336,7689,2,4647,'App\\Models\\Receipt',4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1220.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4717,3661,41336,7689,2,4648,'App\\Models\\Receipt',4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',500.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4718,3661,41336,7689,2,4649,'App\\Models\\Receipt',4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',770.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL),(4719,3661,41336,7689,2,4650,'App\\Models\\Receipt',4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',520.00,NULL,NULL,1,'2022-04-23 08:07:09','2022-04-23 08:07:09',NULL);
INSERT INTO `balance_libro` VALUES (4720,3661,41336,7689,2,4651,'App\\Models\\Receipt',4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',760.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4721,3661,41336,7689,2,4652,'App\\Models\\Receipt',4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',2800.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4722,3661,41336,7689,2,4653,'App\\Models\\Receipt',4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',510.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4723,3661,41336,7689,2,4654,'App\\Models\\Receipt',4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1300.01,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4724,3661,41336,7689,2,4655,'App\\Models\\Receipt',4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',560.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4725,3661,41336,7689,2,4656,'App\\Models\\Receipt',4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',520.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4726,3661,41336,7689,2,4657,'App\\Models\\Receipt',4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1170.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4727,3661,41336,7689,2,4658,'App\\Models\\Receipt',4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',660.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4728,3661,41336,7689,2,4659,'App\\Models\\Receipt',4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',450.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4729,3661,41336,7689,2,4660,'App\\Models\\Receipt',4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1430.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4730,3661,41336,7689,2,4661,'App\\Models\\Receipt',4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',5420.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4731,3661,41336,7689,2,4662,'App\\Models\\Receipt',4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',520.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4732,3661,41336,7689,2,4663,'App\\Models\\Receipt',4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',900.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4733,3661,41336,7689,2,4664,'App\\Models\\Receipt',4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',2730.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4734,3661,41336,7689,2,4665,'App\\Models\\Receipt',4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1710.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4735,3661,41336,7689,2,4666,'App\\Models\\Receipt',4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1570.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4736,3661,41336,7689,2,4667,'App\\Models\\Receipt',4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1872.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4737,3661,41336,7689,2,4668,'App\\Models\\Receipt',4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1300.50,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4738,3661,41336,7689,2,4669,'App\\Models\\Receipt',4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',580.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4739,3661,41336,7689,2,4670,'App\\Models\\Receipt',4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1710.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4740,3661,41336,7689,2,4671,'App\\Models\\Receipt',4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1440.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL);
INSERT INTO `balance_libro` VALUES (4741,3661,41336,7689,2,4672,'App\\Models\\Receipt',4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',2870.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4742,3661,41336,7689,2,4673,'App\\Models\\Receipt',4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1872.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4743,3661,41336,7689,2,4674,'App\\Models\\Receipt',4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1570.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4744,3661,41336,7689,2,4675,'App\\Models\\Receipt',4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',790.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4745,3661,41336,7689,2,4676,'App\\Models\\Receipt',4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1300.50,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4746,3661,41336,7689,2,4677,'App\\Models\\Receipt',4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',427.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4747,3661,41336,7689,2,4678,'App\\Models\\Receipt',4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',250.00,NULL,NULL,1,'2022-04-23 08:07:10','2022-04-23 08:07:10',NULL),(4748,3661,41336,7689,2,4679,'App\\Models\\Receipt',4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1000.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4749,3661,41336,7689,2,4680,'App\\Models\\Receipt',4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',855.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4750,3661,41336,7689,2,4681,'App\\Models\\Receipt',4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1070.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4751,3661,41336,7689,2,4682,'App\\Models\\Receipt',4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',830.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4752,3661,41336,7689,2,4683,'App\\Models\\Receipt',4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1040.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4753,3661,41336,7689,2,4684,'App\\Models\\Receipt',4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',810.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4754,3661,41336,7689,2,4685,'App\\Models\\Receipt',4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',4370.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4755,3661,41336,7689,2,4686,'App\\Models\\Receipt',4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1720.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4756,3661,41336,7689,2,4687,'App\\Models\\Receipt',4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1740.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4757,3661,41336,7689,2,4688,'App\\Models\\Receipt',4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',2530.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4758,3661,41336,7689,2,4689,'App\\Models\\Receipt',4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',450.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4759,3661,41336,7689,2,4690,'App\\Models\\Receipt',4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',180.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4760,3661,41336,7689,2,4691,'App\\Models\\Receipt',4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',1000.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4761,3661,41336,7689,2,4692,'App\\Models\\Receipt',4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',2340.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL);
INSERT INTO `balance_libro` VALUES (4762,3661,41336,7689,2,4693,'App\\Models\\Receipt',4693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',1740.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4763,3661,41336,7689,2,4694,'App\\Models\\Receipt',4694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',540.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4764,3661,41336,7689,2,4695,'App\\Models\\Receipt',4695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',1640.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4765,3661,41336,7689,2,4696,'App\\Models\\Receipt',4696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',390.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4766,3661,41336,7689,2,4697,'App\\Models\\Receipt',4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',2670.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4767,3661,41336,7689,2,4698,'App\\Models\\Receipt',4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',1180.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4768,3661,41336,7689,2,4699,'App\\Models\\Receipt',4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',810.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4769,3661,41336,7689,2,4700,'App\\Models\\Receipt',4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',1190.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4770,3661,41336,7689,2,4701,'App\\Models\\Receipt',4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',670.50,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4771,3661,41336,7689,2,4702,'App\\Models\\Receipt',4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',715.50,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4772,3661,41336,7689,2,4703,'App\\Models\\Receipt',4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',594.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4773,3661,41336,7689,2,4704,'App\\Models\\Receipt',4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',1674.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4774,3661,41336,7689,2,4705,'App\\Models\\Receipt',4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1160.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4775,3661,41336,7689,2,4706,'App\\Models\\Receipt',4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',890.00,NULL,NULL,1,'2022-04-23 08:07:11','2022-04-23 08:07:11',NULL),(4776,3661,41336,7689,2,4707,'App\\Models\\Receipt',4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',520.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4777,3661,41336,7689,2,4708,'App\\Models\\Receipt',4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',210.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4778,3661,41336,7689,2,4709,'App\\Models\\Receipt',4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',310.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4779,3661,41336,7689,2,4710,'App\\Models\\Receipt',4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',580.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4780,3661,41336,7689,2,4711,'App\\Models\\Receipt',4711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',580.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4781,3661,41336,7689,2,4712,'App\\Models\\Receipt',4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',520.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4782,3661,41336,7689,2,4713,'App\\Models\\Receipt',4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',400.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL);
INSERT INTO `balance_libro` VALUES (4783,3661,41336,7689,2,4714,'App\\Models\\Receipt',4714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1752.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4784,3661,41336,7689,2,4715,'App\\Models\\Receipt',4715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',380.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4785,3661,41336,7689,2,4716,'App\\Models\\Receipt',4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1720.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4786,3661,41336,7689,2,4717,'App\\Models\\Receipt',4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1520.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4787,3661,41336,7689,2,4718,'App\\Models\\Receipt',4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',715.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4788,3661,41336,7689,2,4719,'App\\Models\\Receipt',4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',830.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4789,3661,41336,7689,2,4720,'App\\Models\\Receipt',4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',750.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4790,3661,41336,7689,2,4721,'App\\Models\\Receipt',4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',520.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4791,3661,41336,7689,2,4722,'App\\Models\\Receipt',4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1370.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4792,3661,41336,7689,2,4723,'App\\Models\\Receipt',4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',500.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4793,3661,41336,7689,2,4724,'App\\Models\\Receipt',4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1040.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4794,3661,41336,7689,2,4725,'App\\Models\\Receipt',4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1040.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4795,3661,41336,7689,2,4726,'App\\Models\\Receipt',4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',770.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4796,3661,41336,7689,2,4727,'App\\Models\\Receipt',4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',190.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4797,3661,41336,7689,2,4728,'App\\Models\\Receipt',4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1380.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4798,3661,41336,7689,2,4729,'App\\Models\\Receipt',4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',720.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4799,3661,41336,7689,2,4730,'App\\Models\\Receipt',4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',540.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4800,3661,41336,7689,2,4731,'App\\Models\\Receipt',4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',720.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4801,3661,41336,7689,2,4732,'App\\Models\\Receipt',4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1090.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4802,3661,41336,7689,2,4733,'App\\Models\\Receipt',4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1000.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4803,3661,41336,7689,2,4734,'App\\Models\\Receipt',4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',700.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL);
INSERT INTO `balance_libro` VALUES (4804,3661,41336,7689,2,4735,'App\\Models\\Receipt',4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',290.00,NULL,NULL,1,'2022-04-23 08:07:12','2022-04-23 08:07:12',NULL),(4805,3661,41336,7689,2,4736,'App\\Models\\Receipt',4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',580.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4806,3661,41336,7689,2,4737,'App\\Models\\Receipt',4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',760.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4807,3661,41336,7689,2,4738,'App\\Models\\Receipt',4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',940.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4808,3661,41336,7689,2,4739,'App\\Models\\Receipt',4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',660.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4809,3661,41336,7689,2,4740,'App\\Models\\Receipt',4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',500.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4810,3661,41336,7689,2,4741,'App\\Models\\Receipt',4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1210.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4811,3661,41336,7689,2,4742,'App\\Models\\Receipt',4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',910.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4812,3661,41336,7689,2,4743,'App\\Models\\Receipt',4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',3080.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4813,3661,41336,7689,2,4744,'App\\Models\\Receipt',4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',290.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4814,3661,41336,7689,2,4745,'App\\Models\\Receipt',4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1210.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4815,3661,41336,7689,2,4746,'App\\Models\\Receipt',4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',940.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4816,3661,41336,7689,2,4747,'App\\Models\\Receipt',4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',290.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4817,3661,41336,7689,2,4748,'App\\Models\\Receipt',4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',1010.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4818,3661,41336,7689,2,4749,'App\\Models\\Receipt',4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',580.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4819,3661,41336,7689,2,4750,'App\\Models\\Receipt',4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',4410.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4820,3661,41336,7689,2,4751,'App\\Models\\Receipt',4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',2260.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4821,3661,41336,7689,2,4752,'App\\Models\\Receipt',4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',620.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4822,3661,41336,7689,2,4753,'App\\Models\\Receipt',4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',2030.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4823,3661,41336,7689,2,4754,'App\\Models\\Receipt',4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',750.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4824,3661,41336,7689,2,4755,'App\\Models\\Receipt',4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',1040.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL);
INSERT INTO `balance_libro` VALUES (4825,3661,41336,7689,2,4756,'App\\Models\\Receipt',4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',1040.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4826,3661,41336,7689,2,4757,'App\\Models\\Receipt',4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',2210.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4827,3661,41336,7689,2,4758,'App\\Models\\Receipt',4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',1250.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4828,3661,41336,7689,2,4759,'App\\Models\\Receipt',4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',1040.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4829,3661,41336,7689,2,4760,'App\\Models\\Receipt',4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',760.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4830,3661,41336,7689,2,4761,'App\\Models\\Receipt',4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',1505.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4831,3661,41336,7689,2,4762,'App\\Models\\Receipt',4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',2370.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4832,3661,41336,7689,2,4763,'App\\Models\\Receipt',4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',750.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4833,3661,41336,7689,2,4764,'App\\Models\\Receipt',4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',270.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4834,3661,41336,7689,2,4765,'App\\Models\\Receipt',4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',570.00,NULL,NULL,1,'2022-04-23 08:07:13','2022-04-23 08:07:13',NULL),(4835,3661,41336,7689,2,4766,'App\\Models\\Receipt',4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',440.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4836,3661,41336,7689,2,4767,'App\\Models\\Receipt',4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',3680.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4837,3661,41336,7689,2,4768,'App\\Models\\Receipt',4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',720.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4838,3661,41336,7689,2,4769,'App\\Models\\Receipt',4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',500.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4839,3661,41336,7689,2,4770,'App\\Models\\Receipt',4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',440.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4840,3661,41336,7689,2,4771,'App\\Models\\Receipt',4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1660.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4841,3661,41336,7689,2,4772,'App\\Models\\Receipt',4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1390.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4842,3661,41336,7689,2,4773,'App\\Models\\Receipt',4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',310.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4843,3661,41336,7689,2,4774,'App\\Models\\Receipt',4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1000.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4844,3661,41336,7689,2,4775,'App\\Models\\Receipt',4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1160.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4845,3661,41336,7689,2,4776,'App\\Models\\Receipt',4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1255.50,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL);
INSERT INTO `balance_libro` VALUES (4846,3661,41336,7689,2,4777,'App\\Models\\Receipt',4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',380.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4847,3661,41336,7689,2,4778,'App\\Models\\Receipt',4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',180.00,NULL,NULL,1,'2022-04-23 08:07:14','2022-04-23 08:07:14',NULL),(4848,3661,41336,7689,2,4779,'App\\Models\\Receipt',4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-