-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-25411551-8
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-09-11 21:18:03','Actividad Generica 1','000001',NULL),(2,NULL,'2022-09-11 21:18:03','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'EliasJ52022',NULL,1,40720,'2022-09-27'),(2,NULL,'EliasJ52022',NULL,1,40720,'2022-09-27'),(3,NULL,'EliasJ52022',NULL,1,40720,'2022-09-27'),(4,NULL,'EliasJ52022',NULL,1,40720,'2022-09-27'),(5,NULL,'EliasJ52022',NULL,1,40720,'2022-09-27'),(6,NULL,'EliasJ52022',NULL,1,40720,'2022-09-27'),(7,NULL,'EliasJ52022',NULL,1,40720,'2022-10-20'),(8,NULL,'EliasJ52022',NULL,1,40720,'2022-10-20'),(9,NULL,'EliasJ52022',NULL,1,40720,'2022-10-21'),(10,NULL,'EliasJ52022',NULL,1,40720,'2022-10-21'),(11,'clave fiscal daniel','Daniel03112022',NULL,1,40787,'2023-05-29'),(12,NULL,'EliasJ52022',NULL,1,40720,'2023-07-20'),(13,NULL,'EliasJ52022',NULL,1,40720,'2023-08-23'),(14,NULL,'Jorgees2023',NULL,1,40720,'2023-11-21'),(15,'AFIP','Jorgees2023',NULL,1,40720,'2024-09-02');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'milo.ianni@gmail.com','3876538251',NULL,1,40719,'2022-09-12'),(2,'milo.ianni@gmail.com','3876538251','',1,40719,'2022-09-15');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1402 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7812,40720,1518,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',74112.50,NULL,NULL,1,'2022-09-15 16:45:07','2022-09-15 16:45:07',NULL),(2,7812,40720,1518,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',105082.09,NULL,NULL,1,'2022-09-15 16:45:07','2022-09-15 16:45:07',NULL),(3,7812,40720,1520,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',56325.50,NULL,NULL,1,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(4,7812,40720,1520,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',23000.00,NULL,NULL,1,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(5,7812,40720,1520,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',22999.99,NULL,NULL,1,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(6,7812,40720,1520,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',13915.00,NULL,NULL,1,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(7,7812,40720,1518,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',599.99,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(8,7812,40720,1518,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',49999.93,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(9,7812,40720,1518,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',2750.02,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(10,7812,40720,1518,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3900.00,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(11,7812,40720,1518,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3900.00,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(12,7812,40720,1518,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',3599.99,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(13,7812,40720,1518,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',1600.01,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(14,7812,40720,1518,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',1300.00,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(15,7812,40720,1518,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',38500.00,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(16,7812,40720,1518,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',900.00,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(17,7812,40720,1518,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1500.00,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(18,7812,40720,1518,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',810.00,NULL,NULL,1,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(19,7812,40720,1518,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',810.00,NULL,NULL,1,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(20,7812,40720,1518,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',13288.50,NULL,NULL,1,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(21,7812,40720,1518,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2800.00,NULL,NULL,1,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(22,7812,40720,1518,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8000.00,NULL,NULL,1,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL);
INSERT INTO `balance_libro` VALUES (23,7812,40720,1518,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1500.00,NULL,NULL,1,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(24,7812,40720,1518,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2999.98,NULL,NULL,1,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(25,7812,40720,1519,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',600.00,NULL,NULL,1,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(26,7812,40720,1519,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',8600.00,NULL,NULL,1,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(27,7812,40720,1519,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',2050.00,NULL,NULL,1,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(28,7812,40720,1519,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',53500.00,NULL,NULL,1,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(29,7812,40720,1519,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1200.01,NULL,NULL,1,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(30,7812,40720,1519,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',4700.00,NULL,NULL,1,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(31,7812,40720,1519,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',14300.02,NULL,NULL,1,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(32,7812,40720,1519,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2100.00,NULL,NULL,1,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(33,7812,40720,1520,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',605.00,NULL,NULL,1,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(34,7812,40720,1520,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',3037.10,NULL,NULL,1,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(35,7812,40720,1520,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',5434.99,NULL,NULL,1,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(36,7812,40719,11,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',75000.00,NULL,NULL,1,'2022-09-26 19:16:53','2022-09-26 19:16:53',NULL),(37,7812,40720,1528,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',59399.74,NULL,NULL,1,'2022-09-28 08:07:54','2022-09-28 08:07:54',NULL),(38,7812,40720,1528,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',129271.56,NULL,NULL,1,'2022-09-28 08:07:54','2022-09-28 08:07:54',NULL),(39,7812,40720,1529,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',116218.08,NULL,NULL,1,'2022-09-28 08:08:18','2022-09-28 08:08:18',NULL),(40,7812,40720,1529,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',156707.10,NULL,NULL,1,'2022-09-28 08:08:19','2022-09-28 08:08:19',NULL),(41,7812,40720,1533,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',3751.00,NULL,NULL,1,'2022-09-28 08:08:37','2022-09-28 08:08:37',NULL),(42,7812,40720,1533,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',7502.00,NULL,NULL,1,'2022-09-28 08:08:37','2022-09-28 08:08:37',NULL),(43,7812,40720,1537,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',36300.00,NULL,NULL,1,'2022-09-28 08:08:51','2022-09-28 08:08:51',NULL);
INSERT INTO `balance_libro` VALUES (44,7812,40720,1537,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',168292.68,NULL,NULL,1,'2022-09-28 08:08:51','2022-09-28 08:08:51',NULL),(45,7812,40720,1538,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',195058.99,NULL,NULL,1,'2022-09-28 08:09:08','2022-09-28 08:09:08',NULL),(46,7812,40720,1538,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',56470.71,NULL,NULL,1,'2022-09-28 08:09:08','2022-09-28 08:09:08',NULL),(47,7812,40720,1539,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',80168.55,NULL,NULL,1,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(48,7812,40720,1539,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',66255.00,NULL,NULL,1,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(49,7812,40720,1539,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',125906.55,NULL,NULL,1,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(50,7812,40720,1539,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',54268.50,NULL,NULL,1,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(51,7812,40720,1539,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',277714.36,NULL,NULL,1,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(52,7812,40720,1539,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',220486.20,NULL,NULL,1,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(53,7812,40720,1539,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',80168.55,NULL,NULL,1,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(54,7812,40720,1539,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',125607.68,NULL,NULL,1,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(55,7812,40720,1540,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',52816.50,NULL,NULL,1,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(56,7812,40720,1540,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',100786.95,NULL,NULL,1,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(57,7812,40720,1540,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',250808.80,NULL,NULL,1,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(58,7812,40720,1540,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',85556.68,NULL,NULL,1,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(59,7812,40720,1540,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',7000.00,NULL,NULL,1,'2022-09-28 08:09:56','2022-10-19 08:48:00','2022-10-19 08:48:00'),(60,7812,40720,1540,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3500.00,NULL,NULL,1,'2022-09-28 08:09:56','2022-10-19 08:47:35','2022-10-19 08:47:35'),(61,7812,40720,1540,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',95931.22,NULL,NULL,1,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(62,7812,40720,1540,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',226032.84,NULL,NULL,1,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(63,7812,40720,1540,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',239799.62,NULL,NULL,1,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(64,7812,40720,1540,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',193358.00,NULL,NULL,1,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL);
INSERT INTO `balance_libro` VALUES (65,7812,40720,1540,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',252851.28,NULL,NULL,1,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(66,7812,40720,1540,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',115982.98,NULL,NULL,1,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(67,7812,40720,1521,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1450.00,NULL,NULL,1,'2022-09-28 08:10:23','2022-09-28 08:10:23',NULL),(68,7812,40720,1521,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',67450.00,NULL,NULL,1,'2022-09-28 08:10:23','2022-09-28 08:10:23',NULL),(69,7812,40720,1521,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',3460.02,NULL,NULL,1,'2022-09-28 08:10:24','2022-09-28 08:10:24',NULL),(70,7812,40720,1522,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',56250.00,NULL,NULL,1,'2022-09-28 08:10:34','2022-09-28 08:10:34',NULL),(71,7812,40720,1523,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1500.00,NULL,NULL,1,'2022-09-28 08:10:45','2022-09-28 08:10:45',NULL),(72,7812,40720,1523,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',8799.99,NULL,NULL,1,'2022-09-28 08:10:45','2022-09-28 08:10:45',NULL),(73,7812,40720,1524,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',15000.00,NULL,NULL,1,'2022-09-28 08:10:58','2022-09-28 08:10:58',NULL),(74,7812,40720,1525,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',21000.00,NULL,NULL,1,'2022-09-28 08:12:56','2022-09-28 08:12:56',NULL),(75,7812,40720,1525,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1460.01,NULL,NULL,1,'2022-09-28 08:12:56','2022-09-28 08:12:56',NULL),(76,7812,40720,1526,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',11385.61,NULL,NULL,1,'2022-09-28 08:13:11','2022-09-28 08:13:11',NULL),(77,7812,40720,1526,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',35000.00,NULL,NULL,1,'2022-09-28 08:13:11','2022-09-28 08:13:11',NULL),(78,7812,40720,1527,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',22500.00,NULL,NULL,1,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(79,7812,40720,1527,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',35000.00,NULL,NULL,1,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(80,7812,40720,1527,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',35000.00,NULL,NULL,1,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(81,7812,40720,1528,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',22000.00,NULL,NULL,1,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(82,7812,40720,1528,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',8000.00,NULL,NULL,1,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(83,7812,40720,1528,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',80999.99,NULL,NULL,1,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(84,7812,40720,1528,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',1000.00,NULL,NULL,1,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(85,7812,40720,1528,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',1250.00,NULL,NULL,1,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL);
INSERT INTO `balance_libro` VALUES (86,7812,40720,1528,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',440.00,NULL,NULL,1,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(87,7812,40720,1528,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',43900.00,NULL,NULL,1,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(88,7812,40720,1529,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',58940.00,NULL,NULL,1,'2022-09-28 08:14:08','2022-09-28 08:14:08',NULL),(89,7812,40720,1533,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',76999.99,NULL,NULL,1,'2022-09-28 08:16:10','2022-09-28 08:16:10',NULL),(90,7812,40720,1533,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1399.99,NULL,NULL,1,'2022-09-28 08:16:10','2022-09-28 08:16:10',NULL),(91,7812,40720,1534,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2000.00,NULL,NULL,1,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(92,7812,40720,1534,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',2799.99,NULL,NULL,1,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(93,7812,40720,1534,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',2000.01,NULL,NULL,1,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(94,7812,40720,1538,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',12100.00,NULL,NULL,1,'2022-09-28 08:16:51','2022-10-19 10:38:52','2022-10-19 10:38:52'),(95,7812,40720,1538,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',15450.15,NULL,NULL,1,'2022-09-28 08:16:51','2022-10-19 10:38:21','2022-10-19 10:38:21'),(96,7812,40720,1538,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',4987.51,NULL,NULL,1,'2022-09-28 08:16:51','2022-10-19 10:38:38','2022-10-19 10:38:38'),(97,7812,40720,1538,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2000.01,NULL,NULL,1,'2022-09-28 08:16:51','2022-10-19 10:38:10','2022-10-19 10:38:10'),(98,7812,40720,1538,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',3600.00,NULL,NULL,1,'2022-09-28 08:16:51','2022-10-19 10:38:01','2022-10-19 10:38:01'),(99,7812,40720,1538,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',25000.00,NULL,NULL,1,'2022-09-28 08:16:52','2022-10-19 10:39:17','2022-10-19 10:39:17'),(100,7812,40720,1538,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',8600.01,NULL,NULL,1,'2022-09-28 08:16:52','2022-10-19 10:37:35','2022-10-19 10:37:35'),(101,7812,40720,1539,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4100.00,NULL,NULL,1,'2022-09-28 08:17:06','2022-10-19 11:25:43','2022-10-19 11:25:43'),(102,7812,40720,1539,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5400.00,NULL,NULL,1,'2022-09-28 08:17:06','2022-10-19 11:25:51','2022-10-19 11:25:51'),(103,7812,40720,1539,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',71700.00,NULL,NULL,1,'2022-09-28 08:17:06','2022-10-19 11:25:25','2022-10-19 11:25:25'),(104,7812,40720,1540,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',70.00,NULL,NULL,1,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(105,7812,40720,1540,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',21147.00,NULL,NULL,1,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL);
INSERT INTO `balance_libro` VALUES (106,7812,40720,1540,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',104000.00,NULL,NULL,1,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(107,7812,40720,1540,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',4049.99,NULL,NULL,1,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(108,7812,40720,1540,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3939.70,NULL,NULL,1,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(109,7812,40720,1540,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',13006.00,NULL,NULL,1,'2022-10-19 08:18:25','2022-10-19 08:43:09','2022-10-19 08:43:09'),(110,7812,40720,1540,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',5000.01,NULL,NULL,1,'2022-10-19 08:19:50','2022-10-19 08:43:36','2022-10-19 08:43:36'),(111,7812,40720,1540,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',15499.99,NULL,NULL,1,'2022-10-19 08:20:40','2022-10-19 08:44:15','2022-10-19 08:44:15'),(112,7812,40720,1540,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4505.00,NULL,NULL,1,'2022-10-19 08:21:34','2022-10-19 08:44:36','2022-10-19 08:44:36'),(113,7812,40720,1540,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',7500.31,NULL,NULL,1,'2022-10-19 08:22:15','2022-10-19 08:45:19','2022-10-19 08:45:19'),(114,7812,40720,1540,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',5007.60,NULL,NULL,1,'2022-10-19 08:22:55','2022-10-19 08:45:46','2022-10-19 08:45:46'),(115,7812,40720,1540,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',24002.90,NULL,NULL,1,'2022-10-19 08:23:40','2022-10-19 08:46:22','2022-10-19 08:46:22'),(116,7812,40720,1540,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',3500.50,NULL,NULL,1,'2022-10-19 08:24:44','2022-10-19 08:46:49','2022-10-19 08:46:49'),(117,7812,40720,1541,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',13001.40,NULL,NULL,1,'2022-10-19 08:31:28','2022-10-21 08:43:36','2022-10-21 08:43:36'),(118,7812,40720,1541,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',5000.01,NULL,NULL,1,'2022-10-19 08:32:05','2022-10-19 08:41:56','2022-10-19 08:41:56'),(119,7812,40720,1541,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',12000.01,NULL,NULL,1,'2022-10-19 08:32:54','2022-10-19 08:42:12','2022-10-19 08:42:12'),(120,7812,40720,1541,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',14004.80,NULL,NULL,1,'2022-10-19 08:33:19','2022-10-19 08:42:25','2022-10-19 08:42:25'),(121,7812,40720,1541,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',15000.00,NULL,NULL,1,'2022-10-19 08:33:56','2022-10-21 08:41:43','2022-10-21 08:41:43'),(122,7812,40720,1541,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',13999.99,NULL,NULL,1,'2022-10-19 08:34:23','2022-10-21 08:41:11','2022-10-21 08:41:11'),(123,7812,40720,1541,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',5000.01,NULL,NULL,1,'2022-10-19 08:35:03','2022-10-21 08:40:40','2022-10-21 08:40:40'),(124,7812,40720,1541,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',17005.30,NULL,NULL,1,'2022-10-19 08:35:33','2022-10-21 08:40:14','2022-10-21 08:40:14');
INSERT INTO `balance_libro` VALUES (125,7812,40720,1541,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1000.46,NULL,NULL,1,'2022-10-19 08:36:49','2022-10-21 08:39:39','2022-10-21 08:39:39'),(126,7812,40720,1541,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',10000.07,NULL,NULL,1,'2022-10-19 08:39:15','2022-10-19 08:39:15',NULL),(127,7812,40720,1541,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',13999.99,NULL,NULL,1,'2022-10-19 08:39:52','2022-10-19 08:39:52',NULL),(128,7812,40720,1541,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',5000.01,NULL,NULL,1,'2022-10-19 08:41:56','2022-10-21 08:43:10','2022-10-21 08:43:10'),(129,7812,40720,1541,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',12000.01,NULL,NULL,1,'2022-10-19 08:42:12','2022-10-21 08:42:41','2022-10-21 08:42:41'),(130,7812,40720,1541,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',14004.80,NULL,NULL,1,'2022-10-19 08:42:25','2022-10-21 08:42:08','2022-10-21 08:42:08'),(131,7812,40720,1540,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',13006.00,NULL,NULL,1,'2022-10-19 08:43:09','2022-10-19 08:43:09',NULL),(132,7812,40720,1540,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',5000.01,NULL,NULL,1,'2022-10-19 08:43:36','2022-10-19 08:43:36',NULL),(133,7812,40720,1540,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',15499.99,NULL,NULL,1,'2022-10-19 08:44:15','2022-10-19 08:44:15',NULL),(134,7812,40720,1540,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4505.00,NULL,NULL,1,'2022-10-19 08:44:36','2022-10-19 08:44:36',NULL),(135,7812,40720,1540,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',7500.31,NULL,NULL,1,'2022-10-19 08:45:19','2022-10-19 08:45:19',NULL),(136,7812,40720,1540,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',5007.60,NULL,NULL,1,'2022-10-19 08:45:46','2022-10-19 08:45:46',NULL),(137,7812,40720,1540,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',24002.90,NULL,NULL,1,'2022-10-19 08:46:22','2022-10-19 08:46:22',NULL),(138,7812,40720,1540,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',3500.50,NULL,NULL,1,'2022-10-19 08:46:49','2022-10-19 08:46:49',NULL),(139,7812,40720,1540,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3500.00,NULL,NULL,1,'2022-10-19 08:47:35','2022-10-19 08:47:35',NULL),(140,7812,40720,1540,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',7000.00,NULL,NULL,1,'2022-10-19 08:48:00','2022-10-19 08:48:00',NULL),(141,7812,40720,1541,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',38000.04,NULL,NULL,1,'2022-10-19 09:01:50','2022-10-21 09:05:42','2022-10-21 09:05:42'),(142,7812,40720,1541,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',360.00,NULL,NULL,1,'2022-10-19 09:01:50','2022-10-19 09:01:50',NULL),(143,7812,40720,1533,15,128,'App\\Models\\PeriodLiquidation',NULL,128,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',289419.73,NULL,NULL,1,'2022-10-19 09:20:53','2022-10-19 09:20:53',NULL),(144,7812,40720,1534,15,129,'App\\Models\\PeriodLiquidation',NULL,129,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',288646.89,NULL,NULL,1,'2022-10-19 09:22:58','2022-10-19 09:22:58',NULL);
INSERT INTO `balance_libro` VALUES (145,7812,40720,1535,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',12100.00,NULL,NULL,1,'2022-10-19 09:36:10','2022-10-19 09:56:07','2022-10-19 09:56:07'),(146,7812,40720,1535,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',4987.51,NULL,NULL,1,'2022-10-19 09:40:32','2022-10-19 09:56:00','2022-10-19 09:56:00'),(147,7812,40720,1535,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2000.01,NULL,NULL,1,'2022-10-19 09:41:36','2022-10-19 09:55:55','2022-10-19 09:55:55'),(148,7812,40720,1535,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',25000.00,NULL,NULL,1,'2022-10-19 09:42:33','2022-10-19 09:55:47','2022-10-19 09:55:47'),(149,7812,40720,1535,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',8600.01,NULL,NULL,1,'2022-10-19 09:43:37','2022-10-19 09:55:40','2022-10-19 09:55:40'),(150,7812,40720,1535,15,152,'App\\Models\\PeriodLiquidation',NULL,152,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',297790.91,NULL,NULL,1,'2022-10-19 10:19:57','2022-10-19 10:19:57',NULL),(151,7812,40720,1536,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1800.00,NULL,NULL,1,'2022-10-19 10:23:50','2022-10-19 10:23:50',NULL),(152,7812,40720,1536,15,154,'App\\Models\\PeriodLiquidation',NULL,154,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',298103.31,NULL,NULL,1,'2022-10-19 10:24:35','2022-10-19 10:24:35',NULL),(153,7812,40720,1537,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',7500.00,NULL,NULL,1,'2022-10-19 10:28:13','2022-10-19 10:28:13',NULL),(154,7812,40720,1537,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',20199.99,NULL,NULL,1,'2022-10-19 10:28:13','2022-10-19 10:32:57','2022-10-19 10:32:57'),(155,7812,40720,1537,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',20199.92,NULL,NULL,1,'2022-10-19 10:32:57','2022-10-19 10:32:57',NULL),(156,7812,40720,1537,15,158,'App\\Models\\PeriodLiquidation',NULL,158,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',302910.73,NULL,NULL,1,'2022-10-19 10:34:40','2022-10-19 10:34:40',NULL),(157,7812,40720,1538,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',50.00,NULL,NULL,1,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(158,7812,40720,1538,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',1399.99,NULL,NULL,1,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(159,7812,40720,1538,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',600.00,NULL,NULL,1,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(160,7812,40720,1538,15,174,'App\\Models\\PeriodLiquidation',NULL,174,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',267758.69,NULL,NULL,1,'2022-10-19 10:41:28','2022-10-19 10:41:28',NULL),(161,7812,40720,1539,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',4100.00,NULL,NULL,1,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(162,7812,40720,1539,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5400.00,NULL,NULL,1,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(163,7812,40720,1539,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',71700.00,NULL,NULL,1,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(164,7812,40720,1539,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',38592.31,NULL,NULL,1,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL);
INSERT INTO `balance_libro` VALUES (165,7812,40720,1539,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',77184.92,NULL,NULL,1,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(166,7812,40720,1539,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',38592.31,NULL,NULL,1,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(167,7812,40720,1539,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',38592.31,NULL,NULL,1,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(168,7812,40720,1539,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',47466.83,NULL,NULL,1,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(169,7812,40720,1539,15,182,'App\\Models\\PeriodLiquidation',NULL,182,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',274417.96,NULL,NULL,1,'2022-10-19 11:38:25','2022-10-19 11:38:25',NULL),(170,7812,40720,1540,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',12590.00,NULL,NULL,1,'2022-10-20 09:55:55','2022-10-20 09:55:55',NULL),(171,7812,40720,1540,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',6002.90,NULL,NULL,1,'2022-10-20 09:57:53','2022-10-20 09:57:53',NULL),(172,7812,40720,1540,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',6103.50,NULL,NULL,1,'2022-10-20 09:58:32','2022-10-20 09:58:32',NULL),(173,7812,40720,1540,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',3504.61,NULL,NULL,1,'2022-10-20 09:59:03','2022-10-20 09:59:03',NULL),(174,7812,40720,1540,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',15000.01,NULL,NULL,1,'2022-10-20 09:59:43','2022-10-20 09:59:43',NULL),(175,7812,40720,1540,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',13000.00,NULL,NULL,1,'2022-10-20 10:00:17','2022-10-20 10:00:17',NULL),(176,7812,40720,1540,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',9003.11,NULL,NULL,1,'2022-10-20 10:00:58','2022-10-20 10:00:58',NULL),(177,7812,40720,1540,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',8002.21,NULL,NULL,1,'2022-10-20 10:01:32','2022-10-20 10:01:32',NULL),(178,7812,40720,1540,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',36053.19,NULL,NULL,1,'2022-10-20 10:02:17','2022-10-20 10:02:17',NULL),(179,7812,40720,1540,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',10801.20,NULL,NULL,1,'2022-10-20 10:03:20','2022-10-20 10:03:20',NULL),(180,7812,40720,1540,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',10000.00,NULL,NULL,1,'2022-10-20 10:03:50','2022-10-20 10:03:50',NULL),(181,7812,40720,1540,3,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',40003.81,NULL,NULL,1,'2022-10-20 10:04:25','2022-10-20 10:04:25',NULL),(182,7812,40720,1540,3,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4000.00,NULL,NULL,1,'2022-10-20 10:05:46','2022-10-20 10:05:46',NULL),(183,7812,40720,1540,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',15009.82,NULL,NULL,1,'2022-10-20 10:06:39','2022-10-20 10:14:04','2022-10-20 10:14:04'),(184,7812,40720,1540,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',20001.90,NULL,NULL,1,'2022-10-20 10:07:07','2022-10-20 10:13:35','2022-10-20 10:13:35'),(185,7812,40720,1540,3,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',12007.50,NULL,NULL,1,'2022-10-20 10:07:52','2022-10-20 10:07:52',NULL);
INSERT INTO `balance_libro` VALUES (186,7812,40720,1540,3,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',12000.00,NULL,NULL,1,'2022-10-20 10:08:18','2022-10-20 10:08:18',NULL),(187,7812,40720,1540,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8000.00,NULL,NULL,1,'2022-10-20 10:09:03','2022-10-20 10:09:03',NULL),(188,7812,40720,1541,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',10000.00,NULL,NULL,1,'2022-10-20 10:09:56','2022-10-21 08:37:05','2022-10-21 08:37:05'),(189,7812,40720,1540,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',20001.90,NULL,NULL,1,'2022-10-20 10:13:35','2022-10-20 10:13:35',NULL),(190,7812,40720,1540,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-28','2022-08-28',15009.82,NULL,NULL,1,'2022-10-20 10:14:04','2022-10-20 10:14:04',NULL),(191,7812,40720,1542,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',6500.00,NULL,NULL,1,'2022-10-20 12:47:40','2022-12-09 09:27:23','2022-12-09 09:27:23'),(192,7812,40720,1540,7,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',92.63,NULL,NULL,1,'2022-10-21 08:02:48','2022-10-21 08:02:48',NULL),(193,7812,40720,1540,15,229,'App\\Models\\PeriodLiquidation',NULL,229,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',281924.97,NULL,NULL,1,'2022-10-21 08:18:07','2022-10-21 08:18:07',NULL),(194,7812,40720,1541,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',10000.00,NULL,NULL,1,'2022-10-21 08:37:05','2022-10-21 09:18:35','2022-10-21 09:18:35'),(195,7812,40720,1541,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1000.46,NULL,NULL,1,'2022-10-21 08:39:39','2022-10-21 08:39:39',NULL),(196,7812,40720,1541,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',17005.30,NULL,NULL,1,'2022-10-21 08:40:14','2022-10-21 08:40:14',NULL),(197,7812,40720,1541,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',5000.01,NULL,NULL,1,'2022-10-21 08:40:40','2022-10-21 08:40:40',NULL),(198,7812,40720,1541,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',13999.99,NULL,NULL,1,'2022-10-21 08:41:11','2022-10-21 08:41:11',NULL),(199,7812,40720,1541,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',15000.00,NULL,NULL,1,'2022-10-21 08:41:43','2022-10-21 08:41:43',NULL),(200,7812,40720,1541,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',14004.80,NULL,NULL,1,'2022-10-21 08:42:08','2022-10-21 08:42:08',NULL),(201,7812,40720,1541,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',12000.01,NULL,NULL,1,'2022-10-21 08:42:41','2022-10-21 08:42:41',NULL),(202,7812,40720,1541,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',5000.01,NULL,NULL,1,'2022-10-21 08:43:10','2022-10-21 08:43:10',NULL),(203,7812,40720,1541,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',13001.40,NULL,NULL,1,'2022-10-21 08:43:36','2022-10-21 08:43:36',NULL),(204,7812,40720,1541,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',38000.04,NULL,NULL,1,'2022-10-21 09:05:42','2022-10-21 09:05:42',NULL),(205,7812,40720,1541,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',10000.05,NULL,NULL,1,'2022-10-21 09:18:35','2022-10-21 09:18:35',NULL),(206,7812,40720,1541,15,253,'App\\Models\\PeriodLiquidation',NULL,253,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',24750.85,NULL,NULL,1,'2022-10-21 09:21:00','2022-10-21 09:21:00',NULL);
INSERT INTO `balance_libro` VALUES (207,7812,40720,1542,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',11340.00,NULL,NULL,1,'2022-12-09 09:03:21','2022-12-09 09:27:14','2022-12-09 09:27:14'),(208,7812,40720,1542,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',30000.02,NULL,NULL,1,'2022-12-09 09:05:22','2022-12-09 09:27:09','2022-12-09 09:27:09'),(209,7812,40720,1542,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',16999.99,NULL,NULL,1,'2022-12-09 09:07:26','2022-12-09 09:27:04','2022-12-09 09:27:04'),(210,7812,40720,1542,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3000.00,NULL,NULL,1,'2022-12-09 09:12:12','2022-12-09 09:26:59','2022-12-09 09:26:59'),(211,7812,40720,1542,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',30000.90,NULL,NULL,1,'2022-12-09 09:12:58','2022-12-09 09:26:55','2022-12-09 09:26:55'),(212,7812,40720,1542,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',14000.00,NULL,NULL,1,'2022-12-09 09:13:55','2022-12-09 09:26:49','2022-12-09 09:26:49'),(213,7812,40720,1542,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',10000.00,NULL,NULL,1,'2022-12-09 09:14:55','2022-12-09 09:26:44','2022-12-09 09:26:44'),(214,7812,40720,1542,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13007.60,NULL,NULL,1,'2022-12-09 09:16:05','2022-12-09 09:26:39','2022-12-09 09:26:39'),(215,7812,40720,1542,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2000.01,NULL,NULL,1,'2022-12-09 09:16:54','2022-12-09 09:26:34','2022-12-09 09:26:34'),(216,7812,40720,1542,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',7020.80,NULL,NULL,1,'2022-12-09 09:17:30','2022-12-09 09:26:29','2022-12-09 09:26:29'),(217,7812,40720,1542,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',30001.31,NULL,NULL,1,'2022-12-09 09:18:07','2022-12-09 09:26:24','2022-12-09 09:26:24'),(218,7812,40720,1542,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',14000.00,NULL,NULL,1,'2022-12-09 09:18:57','2022-12-09 09:26:19','2022-12-09 09:26:19'),(219,7812,40720,1542,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',13003.00,NULL,NULL,1,'2022-12-09 09:19:38','2022-12-09 09:26:13','2022-12-09 09:26:13'),(220,7812,40720,1542,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',5000.01,NULL,NULL,1,'2022-12-09 09:21:40','2022-12-09 09:26:08','2022-12-09 09:26:08'),(221,7812,40720,1542,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',11001.21,NULL,NULL,1,'2022-12-09 09:23:07','2022-12-09 09:26:02','2022-12-09 09:26:02'),(222,7812,40720,1542,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',11999.99,NULL,NULL,1,'2022-12-09 09:23:51','2022-12-09 09:25:57','2022-12-09 09:25:57'),(223,7812,40720,1542,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',11499.70,NULL,NULL,1,'2022-12-09 09:24:46','2022-12-09 09:25:51','2022-12-09 09:25:51'),(224,7812,40720,1542,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',11340.00,NULL,NULL,1,'2022-12-09 09:32:38','2022-12-09 09:32:38',NULL),(225,7812,40720,1542,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',30000.02,NULL,NULL,1,'2022-12-09 09:34:03','2022-12-09 09:34:03',NULL);
INSERT INTO `balance_libro` VALUES (226,7812,40720,1542,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',16999.99,NULL,NULL,1,'2022-12-09 09:34:59','2022-12-09 09:34:59',NULL),(227,7812,40720,1542,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3000.00,NULL,NULL,1,'2022-12-09 09:36:03','2022-12-09 09:36:03',NULL),(228,7812,40720,1542,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',30000.90,NULL,NULL,1,'2022-12-09 09:36:38','2022-12-09 09:36:38',NULL),(229,7812,40720,1542,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',14000.00,NULL,NULL,1,'2022-12-09 09:37:17','2022-12-09 09:37:17',NULL),(230,7812,40720,1542,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',10000.00,NULL,NULL,1,'2022-12-09 09:38:00','2022-12-09 09:38:00',NULL),(231,7812,40720,1542,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13007.60,NULL,NULL,1,'2022-12-09 09:38:36','2022-12-09 09:38:36',NULL),(232,7812,40720,1542,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2000.01,NULL,NULL,1,'2022-12-09 09:39:04','2022-12-09 09:39:04',NULL),(233,7812,40720,1542,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',7020.80,NULL,NULL,1,'2022-12-09 09:39:39','2022-12-09 09:39:39',NULL),(234,7812,40720,1542,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',30001.31,NULL,NULL,1,'2022-12-09 09:40:10','2022-12-09 09:40:10',NULL),(235,7812,40720,1542,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',14000.00,NULL,NULL,1,'2022-12-09 09:41:02','2022-12-09 09:41:02',NULL),(236,7812,40720,1542,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',13003.00,NULL,NULL,1,'2022-12-09 09:41:39','2022-12-09 09:41:39',NULL),(237,7812,40720,1542,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',6500.00,NULL,NULL,1,'2022-12-09 09:42:10','2022-12-09 09:42:10',NULL),(238,7812,40720,1542,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',5000.01,NULL,NULL,1,'2022-12-09 09:42:59','2022-12-09 09:42:59',NULL),(239,7812,40720,1542,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',11001.21,NULL,NULL,1,'2022-12-09 09:44:09','2022-12-09 09:44:09',NULL),(240,7812,40720,1542,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',11999.99,NULL,NULL,1,'2022-12-09 09:44:41','2022-12-09 09:44:41',NULL),(241,7812,40720,1542,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',11499.70,NULL,NULL,1,'2022-12-09 09:45:12','2022-12-09 09:45:12',NULL),(242,7812,40720,1542,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',12001.02,NULL,NULL,1,'2022-12-09 09:45:56','2022-12-09 09:45:56',NULL),(243,7812,40720,1542,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',14006.20,NULL,NULL,1,'2022-12-14 07:31:13','2022-12-14 07:31:13',NULL),(244,7812,40720,1542,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',8000.00,NULL,NULL,1,'2022-12-14 07:32:21','2022-12-14 07:32:21',NULL),(245,7812,40720,1542,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',15003.70,NULL,NULL,1,'2022-12-14 07:33:17','2022-12-14 07:33:17',NULL),(246,7812,40720,1542,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',13000.11,NULL,NULL,1,'2022-12-14 07:34:22','2022-12-14 07:34:22',NULL);
INSERT INTO `balance_libro` VALUES (247,7812,40720,1542,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',12999.97,NULL,NULL,1,'2022-12-14 07:36:31','2022-12-14 07:36:31',NULL),(248,7812,40720,1542,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',18002.89,NULL,NULL,1,'2022-12-14 07:37:18','2022-12-14 07:37:18',NULL),(249,7812,40720,1542,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',14000.11,NULL,NULL,1,'2022-12-14 07:38:06','2022-12-14 07:38:06',NULL),(250,7812,40720,1542,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',10001.60,NULL,NULL,1,'2022-12-14 07:38:41','2022-12-14 07:38:41',NULL),(251,7812,40720,1542,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',14003.21,NULL,NULL,1,'2022-12-14 07:39:25','2022-12-14 07:39:25',NULL),(252,7812,40720,1542,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',5000.05,NULL,NULL,1,'2022-12-14 07:40:29','2022-12-14 07:40:29',NULL),(253,7812,40720,1542,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',62000.00,NULL,NULL,1,'2022-12-14 07:55:31','2022-12-14 07:55:31',NULL),(254,7812,40720,1542,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',129.50,NULL,NULL,1,'2022-12-14 07:55:31','2022-12-21 07:31:37','2022-12-21 07:31:37'),(255,7812,40720,1542,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',69500.00,NULL,NULL,1,'2022-12-14 07:55:31','2022-12-14 07:55:31',NULL),(256,7812,40720,1542,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3002.62,NULL,NULL,1,'2022-12-14 07:55:31','2022-12-21 07:28:37','2022-12-21 07:28:37'),(257,7812,40720,1543,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',15569.22,NULL,NULL,1,'2022-12-14 07:57:28','2022-12-14 07:57:28',NULL),(258,7812,40720,1543,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',15000.00,NULL,NULL,1,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(259,7812,40720,1543,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',87800.00,NULL,NULL,1,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(260,7812,40720,1543,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',7858.57,NULL,NULL,1,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(261,7812,40720,1543,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',45000.00,NULL,NULL,1,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(262,7812,40720,1543,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',5000.00,NULL,NULL,1,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(263,7812,40720,1543,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',12600.00,NULL,NULL,1,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(264,7812,40720,1542,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',193358.00,NULL,NULL,1,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(265,7812,40720,1542,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',193358.00,NULL,NULL,1,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(266,7812,40720,1542,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',111604.35,NULL,NULL,1,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(267,7812,40720,1543,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',63800.00,NULL,NULL,1,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL);
INSERT INTO `balance_libro` VALUES (268,7812,40720,1543,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',16200.00,NULL,NULL,1,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(269,7812,40720,1543,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',63800.00,NULL,NULL,1,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(270,7812,40720,1543,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',63800.00,NULL,NULL,1,'2022-12-14 07:58:35','2022-12-14 07:58:35',NULL),(271,7812,40720,1542,15,393,'App\\Models\\PeriodLiquidation',NULL,393,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',140721.09,NULL,NULL,1,'2022-12-21 09:00:10','2022-12-21 09:00:10',NULL),(272,7812,40720,1543,15,395,'App\\Models\\PeriodLiquidation',NULL,395,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',123656.80,NULL,NULL,1,'2022-12-21 11:49:33','2022-12-21 11:49:33',NULL),(273,7812,40720,1549,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4000.00,NULL,NULL,1,'2023-03-06 17:25:11','2023-03-25 16:35:58','2023-03-25 16:35:58'),(274,7812,40720,1544,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',20550.00,NULL,NULL,1,'2023-03-06 17:25:46','2023-03-06 17:25:46',NULL),(275,7812,40720,1544,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',24748.19,NULL,NULL,1,'2023-03-06 17:25:46','2023-03-06 17:25:46',NULL),(276,7812,40720,1548,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5028.99,NULL,NULL,1,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(277,7812,40720,1548,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8062.76,NULL,NULL,1,'2023-03-06 17:26:05','2023-03-07 07:39:42','2023-03-07 07:39:42'),(278,7812,40720,1548,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',10955.77,NULL,NULL,1,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(279,7812,40720,1548,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',10075.00,NULL,NULL,1,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(280,7812,40720,1548,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5909.99,NULL,NULL,1,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(281,7812,40720,1548,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9319.20,NULL,NULL,1,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(282,7812,40720,1548,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',48981.26,NULL,NULL,1,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(283,7812,40720,1548,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',39704.58,NULL,NULL,1,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(284,7812,40720,1544,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',4400.00,NULL,NULL,1,'2023-03-06 17:50:21','2023-03-06 17:50:21',NULL),(285,7812,40720,1544,3,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',13000.00,NULL,NULL,1,'2023-03-06 17:51:03','2023-03-06 17:51:03',NULL),(286,7812,40720,1544,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',3550.01,NULL,NULL,1,'2023-03-06 17:51:34','2023-03-06 17:51:34',NULL),(287,7812,40720,1544,3,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3000.00,NULL,NULL,1,'2023-03-06 17:52:13','2023-03-06 17:52:13',NULL),(288,7812,40720,1544,3,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',9900.00,NULL,NULL,1,'2023-03-06 17:52:35','2023-03-06 17:52:35',NULL);
INSERT INTO `balance_libro` VALUES (289,7812,40720,1544,3,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',10000.00,NULL,NULL,1,'2023-03-06 17:54:42','2023-03-06 17:54:42',NULL),(290,7812,40720,1544,3,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',25001.18,NULL,NULL,1,'2023-03-06 17:57:25','2023-03-06 17:57:25',NULL),(291,7812,40720,1544,3,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',77600.10,NULL,NULL,1,'2023-03-06 17:59:12','2023-03-06 17:59:12',NULL),(292,7812,40720,1544,3,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',14000.03,NULL,NULL,1,'2023-03-06 18:00:41','2023-03-06 18:00:41',NULL),(293,7812,40720,1544,3,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',10501.71,NULL,NULL,1,'2023-03-06 18:01:35','2023-03-06 18:01:35',NULL),(294,7812,40720,1544,3,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',20000.01,NULL,NULL,1,'2023-03-06 18:02:13','2023-03-06 18:02:13',NULL),(295,7812,40720,1544,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',25002.21,NULL,NULL,1,'2023-03-06 18:02:54','2023-03-06 18:02:54',NULL),(296,7812,40720,1544,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6002.01,NULL,NULL,1,'2023-03-06 18:03:38','2023-03-06 18:03:38',NULL),(297,7812,40720,1544,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',13000.00,NULL,NULL,1,'2023-03-06 18:04:00','2023-03-06 18:04:00',NULL),(298,7812,40720,1544,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',17102.32,NULL,NULL,1,'2023-03-06 18:04:32','2023-03-06 18:04:32',NULL),(299,7812,40720,1544,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',18000.01,NULL,NULL,1,'2023-03-06 18:05:03','2023-03-06 18:05:03',NULL),(300,7812,40720,1544,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',70004.20,NULL,NULL,1,'2023-03-06 18:05:49','2023-03-06 18:05:49',NULL),(301,7812,40720,1544,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',60306.01,NULL,NULL,1,'2023-03-06 18:06:18','2023-03-06 18:06:18',NULL),(302,7812,40720,1544,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',7701.62,NULL,NULL,1,'2023-03-06 18:06:49','2023-03-06 18:06:49',NULL),(303,7812,40720,1544,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',8377.39,NULL,NULL,1,'2023-03-06 18:07:19','2023-03-06 18:07:19',NULL),(304,7812,40720,1544,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',43005.30,NULL,NULL,1,'2023-03-06 18:08:07','2023-03-06 18:08:07',NULL),(305,7812,40720,1544,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',21000.77,NULL,NULL,1,'2023-03-06 18:08:43','2023-03-06 18:08:43',NULL),(306,7812,40720,1544,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',20002.41,NULL,NULL,1,'2023-03-06 18:09:38','2023-03-06 18:09:38',NULL),(307,7812,40720,1544,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',10001.91,NULL,NULL,1,'2023-03-06 18:10:05','2023-03-06 18:10:05',NULL),(308,7812,40720,1544,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2001.40,NULL,NULL,1,'2023-03-06 18:10:37','2023-03-06 18:10:37',NULL),(309,7812,40720,1544,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',4601.51,NULL,NULL,1,'2023-03-06 18:11:07','2023-03-06 18:11:07',NULL);
INSERT INTO `balance_libro` VALUES (310,7812,40720,1544,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1500.00,NULL,NULL,1,'2023-03-06 18:11:42','2023-03-06 18:11:42',NULL),(311,7812,40720,1548,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',60970.10,NULL,NULL,1,'2023-03-06 18:21:26','2023-03-06 18:21:26',NULL),(312,7812,40720,1548,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',35000.04,NULL,NULL,1,'2023-03-06 18:21:54','2023-03-06 18:21:54',NULL),(313,7812,40720,1548,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',15001.89,NULL,NULL,1,'2023-03-06 18:22:49','2023-03-06 18:22:49',NULL),(314,7812,40720,1548,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6000.70,NULL,NULL,1,'2023-03-06 18:23:11','2023-03-06 18:23:11',NULL),(315,7812,40720,1548,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2999.99,NULL,NULL,1,'2023-03-06 18:23:39','2023-03-06 18:23:39',NULL),(316,7812,40720,1548,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',15000.01,NULL,NULL,1,'2023-03-06 18:24:01','2023-03-06 18:24:01',NULL),(317,7812,40720,1548,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5000.00,NULL,NULL,1,'2023-03-06 18:24:28','2023-03-06 18:24:28',NULL),(318,7812,40720,1548,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',7500.00,NULL,NULL,1,'2023-03-06 18:24:52','2023-03-06 18:24:52',NULL),(319,7812,40720,1548,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',73800.01,NULL,NULL,1,'2023-03-06 18:25:45','2023-03-06 18:25:45',NULL),(320,7812,40720,1548,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2500.01,NULL,NULL,1,'2023-03-06 18:26:25','2023-03-06 18:26:25',NULL),(321,7812,40720,1544,15,454,'App\\Models\\PeriodLiquidation',NULL,454,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',181807.10,NULL,NULL,1,'2023-03-06 18:44:43','2023-03-06 18:44:43',NULL),(322,7812,40720,1548,15,476,'App\\Models\\PeriodLiquidation',NULL,476,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',240537.76,NULL,NULL,1,'2023-03-07 09:17:00','2023-03-07 09:17:00',NULL),(323,7812,40720,1549,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',118310.11,NULL,NULL,1,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(324,7812,40720,1549,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',30387.45,NULL,NULL,1,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(325,7812,40720,1549,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',12500.00,NULL,NULL,1,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(326,7812,40720,1549,3,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',10635.31,NULL,NULL,1,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(327,7812,40720,1549,3,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',77999.00,NULL,NULL,1,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(328,7812,40720,1549,3,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',22985.16,NULL,NULL,1,'2023-03-25 15:56:45','2023-03-25 15:56:45',NULL),(329,7812,40720,1549,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',61043.77,NULL,NULL,1,'2023-03-25 15:56:45','2023-03-25 15:56:45',NULL),(330,7812,40720,1549,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',19999.99,NULL,NULL,1,'2023-03-25 16:14:26','2023-03-25 16:14:26',NULL);
INSERT INTO `balance_libro` VALUES (331,7812,40720,1549,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',25007.30,NULL,NULL,1,'2023-03-25 16:15:27','2023-03-25 16:15:27',NULL),(332,7812,40720,1549,3,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',20005.01,NULL,NULL,1,'2023-03-25 16:15:59','2023-03-25 16:15:59',NULL),(333,7812,40720,1549,3,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',4000.40,NULL,NULL,1,'2023-03-25 16:16:37','2023-03-25 16:16:37',NULL),(334,7812,40720,1549,3,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',17999.99,NULL,NULL,1,'2023-03-25 16:17:16','2023-03-25 16:17:16',NULL),(335,7812,40720,1549,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',17998.09,NULL,NULL,1,'2023-03-25 16:17:51','2023-03-25 16:17:51',NULL),(336,7812,40720,1549,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',36800.10,NULL,NULL,1,'2023-03-25 16:18:18','2023-03-25 16:18:18',NULL),(337,7812,40720,1549,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30033.00,NULL,NULL,1,'2023-03-25 16:18:44','2023-03-25 16:18:44',NULL),(338,7812,40720,1549,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',27167.39,NULL,NULL,1,'2023-03-25 16:19:35','2023-03-25 16:19:35',NULL),(339,7812,40720,1549,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',24004.92,NULL,NULL,1,'2023-03-25 16:20:33','2023-03-25 16:20:33',NULL),(340,7812,40720,1549,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',20051.30,NULL,NULL,1,'2023-03-25 16:21:04','2023-03-25 16:21:04',NULL),(341,7812,40720,1549,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',10000.00,NULL,NULL,1,'2023-03-25 16:21:38','2023-03-25 16:21:38',NULL),(342,7812,40720,1549,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',18000.00,NULL,NULL,1,'2023-03-25 16:22:19','2023-03-25 16:22:19',NULL),(343,7812,40720,1549,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10000.00,NULL,NULL,1,'2023-03-25 16:23:02','2023-03-25 16:23:02',NULL),(344,7812,40720,1549,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',18000.01,NULL,NULL,1,'2023-03-25 16:23:30','2023-03-25 16:23:30',NULL),(345,7812,40720,1549,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2775.57,NULL,NULL,1,'2023-03-25 16:24:30','2023-03-25 16:24:30',NULL),(346,7812,40720,1549,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2999.99,NULL,NULL,1,'2023-03-25 16:25:06','2023-03-25 16:25:06',NULL),(347,7812,40720,1549,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',4100.00,NULL,NULL,1,'2023-03-25 16:27:52','2023-03-25 16:27:52',NULL),(348,7812,40720,1549,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',13400.00,NULL,NULL,1,'2023-03-25 16:28:50','2023-03-25 16:28:50',NULL),(349,7812,40720,1549,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3999.99,NULL,NULL,1,'2023-03-25 16:35:58','2023-03-25 16:36:29','2023-03-25 16:36:29'),(350,7812,40720,1549,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4000.01,NULL,NULL,1,'2023-03-25 16:36:29','2023-03-25 16:36:29',NULL),(351,7812,40720,1549,15,520,'App\\Models\\PeriodLiquidation',NULL,520,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',349919.67,NULL,NULL,1,'2023-03-25 16:45:21','2023-03-25 16:45:21',NULL);
INSERT INTO `balance_libro` VALUES (352,7812,40720,1550,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',22000.00,NULL,NULL,1,'2023-04-25 10:50:56','2023-04-25 10:54:21','2023-04-25 10:54:21'),(353,7812,40720,1550,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5000.01,NULL,NULL,1,'2023-04-25 10:51:09','2023-04-25 10:51:09',NULL),(354,7812,40720,1550,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',55000.00,NULL,NULL,1,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(355,7812,40720,1550,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',6500.00,NULL,NULL,1,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(356,7812,40720,1550,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',18450.00,NULL,NULL,1,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(357,7812,40720,1550,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3500.00,NULL,NULL,1,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(358,7812,40720,1550,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',27849.34,NULL,NULL,1,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(359,7812,40720,1550,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',22000.00,NULL,NULL,1,'2023-04-25 10:54:21','2023-04-25 10:54:21',NULL),(360,7812,40720,1550,15,526,'App\\Models\\PeriodLiquidation',NULL,526,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',369409.64,NULL,NULL,1,'2023-04-25 11:16:35','2023-04-25 11:16:35',NULL),(361,7812,40787,3045,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',392400.00,NULL,NULL,1,'2023-05-29 09:04:52','2023-05-29 09:04:52',NULL),(362,7812,40787,3045,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',516361.80,NULL,NULL,1,'2023-05-29 09:04:52','2023-05-29 09:04:52',NULL),(363,7812,40787,3047,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',616737.19,NULL,NULL,1,'2023-05-29 09:05:14','2023-05-29 09:39:42','2023-05-29 09:39:42'),(364,7812,40787,3047,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',616737.19,NULL,NULL,1,'2023-05-29 09:05:14','2023-06-05 17:31:04','2023-06-05 17:31:04'),(365,7812,40787,3047,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',616737.19,NULL,NULL,1,'2023-05-29 09:05:14','2023-05-29 09:05:14',NULL),(366,7812,40787,3047,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',502046.71,NULL,NULL,1,'2023-05-29 09:05:14','2023-05-29 09:40:07','2023-05-29 09:40:07'),(367,7812,40787,3048,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',850200.00,NULL,NULL,1,'2023-05-29 09:06:05','2023-05-29 09:40:33','2023-05-29 09:40:33'),(368,7812,40787,3048,2,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',180000.00,NULL,NULL,1,'2023-05-29 09:06:05','2023-05-29 09:06:05',NULL),(369,7812,40787,3047,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',192422.00,NULL,NULL,1,'2023-05-29 09:07:17','2023-05-29 09:07:17',NULL),(370,7812,40787,3048,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',168478.72,NULL,NULL,1,'2023-05-29 09:07:30','2023-05-29 09:07:30',NULL),(371,7812,40787,3048,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',198944.49,NULL,NULL,1,'2023-05-29 09:07:30','2023-05-29 09:07:30',NULL);
INSERT INTO `balance_libro` VALUES (372,7812,40787,3048,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',10004.20,NULL,NULL,1,'2023-05-29 09:20:45','2023-05-29 09:20:45',NULL),(373,7812,40787,3048,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',6000.01,NULL,NULL,1,'2023-05-29 09:22:37','2023-05-29 09:22:37',NULL),(374,7812,40787,3048,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',16999.96,NULL,NULL,1,'2023-05-29 09:23:34','2023-05-29 09:23:34',NULL),(375,7812,40787,3048,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',12800.02,NULL,NULL,1,'2023-05-29 09:24:30','2023-05-29 09:24:30',NULL),(376,7812,40787,3048,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',8999.99,NULL,NULL,1,'2023-05-29 09:25:13','2023-05-29 09:25:13',NULL),(377,7812,40787,3048,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',15000.00,NULL,NULL,1,'2023-05-29 09:25:45','2023-05-29 09:25:45',NULL),(378,7812,40787,3048,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5001.60,NULL,NULL,1,'2023-05-29 09:32:37','2023-05-29 09:32:37',NULL),(379,7812,40787,3047,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',616737.19,NULL,NULL,1,'2023-05-29 09:39:42','2023-06-05 17:30:05','2023-06-05 17:30:05'),(380,7812,40787,3047,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',502046.71,NULL,NULL,1,'2023-05-29 09:40:07','2023-05-29 09:40:07',NULL),(381,7812,40787,3048,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',850200.00,NULL,NULL,1,'2023-05-29 09:40:33','2023-05-29 09:40:33',NULL),(382,7812,40720,1551,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3600.00,NULL,NULL,1,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(383,7812,40720,1551,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3727.80,NULL,NULL,1,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(384,7812,40720,1551,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',27244.33,NULL,NULL,1,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(385,7812,40720,1551,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',19275.30,NULL,NULL,1,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(386,7812,40720,1551,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',27244.33,NULL,NULL,1,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(387,7812,40720,1551,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',10299.99,NULL,NULL,1,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(388,7812,40720,1551,15,558,'App\\Models\\PeriodLiquidation',NULL,558,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',381452.84,NULL,NULL,1,'2023-06-03 09:50:07','2023-06-03 09:50:07',NULL),(389,7812,40787,3047,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',616737.19,NULL,NULL,1,'2023-06-05 17:30:05','2023-06-05 17:30:05',NULL),(390,7812,40787,3047,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',616737.19,NULL,NULL,1,'2023-06-05 17:31:04','2023-06-05 17:31:04',NULL),(391,7812,40720,1552,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',338555.58,NULL,NULL,1,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(392,7812,40720,1552,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',154405.68,NULL,NULL,1,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL);
INSERT INTO `balance_libro` VALUES (393,7812,40720,1552,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',231332.64,NULL,NULL,1,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(394,7812,40720,1552,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',158863.32,NULL,NULL,1,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(395,7812,40720,1552,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',231332.64,NULL,NULL,1,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(396,7812,40720,1552,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',150538.52,NULL,NULL,1,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(397,7812,40720,1552,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',27244.33,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(398,7812,40720,1552,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',27244.33,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(399,7812,40720,1552,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',9999.00,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(400,7812,40720,1552,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1312.85,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(401,7812,40720,1552,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',7235.80,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(402,7812,40720,1552,3,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',10479.53,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(403,7812,40720,1552,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',2899.99,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(404,7812,40720,1552,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',27244.33,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(405,7812,40720,1552,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',27244.33,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(406,7812,40720,1552,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',1042.32,NULL,NULL,1,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(407,7812,40720,1552,15,566,'App\\Models\\PeriodLiquidation',NULL,566,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',436662.19,NULL,NULL,1,'2023-06-21 07:49:11','2023-06-21 07:49:11',NULL),(408,7812,40787,3045,15,528,'App\\Models\\PeriodLiquidation',NULL,528,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',157718.99,NULL,NULL,1,'2023-06-21 20:03:01','2023-06-21 20:03:01',NULL),(409,7812,40787,3047,15,562,'App\\Models\\PeriodLiquidation',NULL,562,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',194169.11,NULL,NULL,1,'2023-06-21 20:03:19','2023-06-21 20:03:19',NULL),(410,7812,40787,3048,15,556,'App\\Models\\PeriodLiquidation',NULL,556,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',178795.04,NULL,NULL,1,'2023-06-30 18:09:39','2023-06-30 18:09:39',NULL),(411,7812,40787,3049,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',195000.00,NULL,NULL,1,'2023-06-30 18:24:12','2023-06-30 18:24:12',NULL),(412,7812,40787,3050,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',362736.00,NULL,NULL,1,'2023-06-30 18:24:26','2023-06-30 18:24:26',NULL),(413,7812,40787,3050,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',785928.00,NULL,NULL,1,'2023-06-30 18:24:26','2023-06-30 18:24:26',NULL);
INSERT INTO `balance_libro` VALUES (414,7812,40787,3049,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4000.00,NULL,NULL,1,'2023-06-30 18:32:09','2023-06-30 18:32:09',NULL),(415,7812,40787,3049,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',13002.06,NULL,NULL,1,'2023-06-30 18:33:12','2023-06-30 18:33:12',NULL),(416,7812,40787,3049,3,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',1001.20,NULL,NULL,1,'2023-06-30 18:34:21','2023-06-30 18:34:21',NULL),(417,7812,40787,3049,3,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1008.11,NULL,NULL,1,'2023-06-30 18:35:57','2023-06-30 18:35:57',NULL),(418,7812,40787,3049,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2000.00,NULL,NULL,1,'2023-06-30 18:36:51','2023-06-30 18:36:51',NULL),(419,7812,40787,3049,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',4999.99,NULL,NULL,1,'2023-06-30 18:37:42','2023-06-30 18:37:42',NULL),(420,7812,40787,3049,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',5001.01,NULL,NULL,1,'2023-06-30 18:38:16','2023-06-30 18:38:16',NULL),(421,7812,40787,3049,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3460.50,NULL,NULL,1,'2023-06-30 18:39:36','2023-06-30 18:39:36',NULL),(422,7812,40787,3049,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',1500.00,NULL,NULL,1,'2023-06-30 18:40:06','2023-06-30 18:40:06',NULL),(423,7812,40787,3049,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',5537.70,NULL,NULL,1,'2023-06-30 18:41:25','2023-06-30 18:41:25',NULL),(424,7812,40787,3049,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10000.11,NULL,NULL,1,'2023-06-30 18:42:38','2023-06-30 18:42:38',NULL),(425,7812,40787,3050,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',802.91,NULL,NULL,1,'2023-06-30 18:56:37','2023-06-30 18:56:37',NULL),(426,7812,40787,3050,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',7514.68,NULL,NULL,1,'2023-06-30 18:57:27','2023-06-30 18:57:27',NULL),(427,7812,40787,3050,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',6663.30,NULL,NULL,1,'2023-06-30 18:57:55','2023-06-30 18:57:55',NULL),(428,7812,40787,3050,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',2450.19,NULL,NULL,1,'2023-06-30 18:58:40','2023-06-30 18:58:40',NULL),(429,7812,40787,3050,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',5501.17,NULL,NULL,1,'2023-06-30 18:59:05','2023-06-30 18:59:05',NULL),(430,7812,40787,3050,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',557.68,NULL,NULL,1,'2023-06-30 18:59:27','2023-06-30 18:59:27',NULL),(431,7812,40787,3050,3,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',1080.00,NULL,NULL,1,'2023-06-30 19:00:17','2023-06-30 19:00:17',NULL),(432,7812,40787,3050,3,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',25549.00,NULL,NULL,1,'2023-06-30 19:00:42','2023-06-30 19:00:42',NULL),(433,7812,40787,3050,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',3143.98,NULL,NULL,1,'2023-06-30 19:01:05','2023-06-30 19:01:05',NULL),(434,7812,40787,3050,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',2000.61,NULL,NULL,1,'2023-06-30 19:01:51','2023-06-30 19:01:51',NULL);
INSERT INTO `balance_libro` VALUES (435,7812,40787,3050,3,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',2000.00,NULL,NULL,1,'2023-06-30 19:02:48','2023-06-30 19:02:48',NULL),(436,7812,40787,3050,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',3000.01,NULL,NULL,1,'2023-06-30 19:03:20','2023-06-30 19:03:20',NULL),(437,7812,40787,3050,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',2004.50,NULL,NULL,1,'2023-06-30 19:04:01','2023-06-30 19:04:01',NULL),(438,7812,40787,3050,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',5000.01,NULL,NULL,1,'2023-06-30 19:04:35','2023-06-30 19:04:35',NULL),(439,7812,40787,3050,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',6001.31,NULL,NULL,1,'2023-06-30 19:05:21','2023-06-30 19:05:21',NULL),(440,7812,40787,3050,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',4999.99,NULL,NULL,1,'2023-06-30 19:05:52','2023-06-30 19:05:52',NULL),(441,7812,40787,3050,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',2003.22,NULL,NULL,1,'2023-06-30 19:06:19','2023-06-30 19:06:19',NULL),(442,7812,40787,3050,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',5000.59,NULL,NULL,1,'2023-06-30 19:06:50','2023-06-30 19:06:50',NULL),(443,7812,40720,1553,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',201279.87,NULL,NULL,1,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(444,7812,40720,1553,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',199691.14,NULL,NULL,1,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(445,7812,40720,1553,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',96800.00,NULL,NULL,1,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(446,7812,40720,1553,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',96800.00,NULL,NULL,1,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(447,7812,40720,1553,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',96800.00,NULL,NULL,1,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(448,7812,40720,1553,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',84700.00,NULL,NULL,1,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(449,7812,40720,1553,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',50722.84,NULL,NULL,1,'2023-07-20 16:27:49','2023-07-20 16:27:49',NULL),(450,7812,40720,1553,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',8043.84,NULL,NULL,1,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(451,7812,40720,1553,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',12999.00,NULL,NULL,1,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(452,7812,40720,1553,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',19200.00,NULL,NULL,1,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(453,7812,40720,1553,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',42000.00,NULL,NULL,1,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(454,7812,40720,1553,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',12000.01,NULL,NULL,1,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(455,7812,40720,1553,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',3630.00,NULL,NULL,1,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL);
INSERT INTO `balance_libro` VALUES (456,7812,40720,1553,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',60000.00,NULL,NULL,1,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(457,7812,40720,1553,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2990.00,NULL,NULL,1,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(458,7812,40720,1553,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',48000.01,NULL,NULL,1,'2023-07-20 16:58:48','2023-07-20 16:58:48',NULL),(459,7812,40720,1553,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',30000.00,NULL,NULL,1,'2023-07-20 16:59:41','2023-07-20 16:59:41',NULL),(460,7812,40720,1553,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',52400.01,NULL,NULL,1,'2023-07-20 17:00:47','2023-07-20 17:00:47',NULL),(461,7812,40720,1553,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',6880.98,NULL,NULL,1,'2023-07-20 17:08:31','2023-07-20 17:08:31',NULL),(462,7812,40720,1553,15,640,'App\\Models\\PeriodLiquidation',NULL,640,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',307431.46,NULL,NULL,1,'2023-07-20 18:02:02','2023-07-20 18:02:02',NULL),(463,7812,40787,3045,16,529,'App\\Models\\PeriodLiquidation',NULL,529,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-07-27 20:31:54','2023-12-18 19:29:59','2023-12-18 19:29:59'),(464,7812,40720,1554,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',201344.00,NULL,NULL,1,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(465,7812,40720,1554,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',200588.96,NULL,NULL,1,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(466,7812,40720,1554,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',200840.64,NULL,NULL,1,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(467,7812,40720,1554,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',181500.00,NULL,NULL,1,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(468,7812,40720,1554,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',72990.22,NULL,NULL,1,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(469,7812,40720,1554,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',194084.00,NULL,NULL,1,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(470,7812,40720,1554,3,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',115999.99,NULL,NULL,1,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(471,7812,40720,1554,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',93700.00,NULL,NULL,1,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(472,7812,40720,1554,3,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',33500.00,NULL,NULL,1,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(473,7812,40720,1554,3,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',16999.99,NULL,NULL,1,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(474,7812,40720,1554,3,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',11000.00,NULL,NULL,1,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(475,7812,40720,1554,3,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',9001.02,NULL,NULL,1,'2023-08-17 17:22:32','2023-08-17 17:22:32',NULL),(476,7812,40720,1554,3,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',9702.69,NULL,NULL,1,'2023-08-17 17:23:56','2023-08-17 17:23:56',NULL);
INSERT INTO `balance_libro` VALUES (477,7812,40720,1554,3,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',10000.01,NULL,NULL,1,'2023-08-17 17:25:09','2023-08-17 17:25:09',NULL),(478,7812,40720,1554,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',32001.71,NULL,NULL,1,'2023-08-23 07:14:04','2023-08-23 07:14:04',NULL),(479,7812,40720,1554,3,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',30000.00,NULL,NULL,1,'2023-08-23 07:14:51','2023-08-23 07:14:51',NULL),(480,7812,40720,1554,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',13099.99,NULL,NULL,1,'2023-08-23 07:16:08','2023-08-23 07:16:08',NULL),(481,7812,40720,1554,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',10304.31,NULL,NULL,1,'2023-08-23 07:17:29','2023-08-23 07:17:29',NULL),(482,7812,40720,1554,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',5002.41,NULL,NULL,1,'2023-08-23 07:18:08','2023-08-23 07:18:08',NULL),(483,7812,40720,1554,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',4999.99,NULL,NULL,1,'2023-08-23 07:18:53','2023-08-23 07:18:53',NULL),(484,7812,40720,1554,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',15007.52,NULL,NULL,1,'2023-08-23 07:19:35','2023-08-23 07:19:35',NULL),(485,7812,40720,1554,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',12100.19,NULL,NULL,1,'2023-08-23 07:20:11','2023-08-23 07:20:11',NULL),(486,7812,40720,1554,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',5002.89,NULL,NULL,1,'2023-08-23 07:20:45','2023-08-23 07:20:45',NULL),(487,7812,40720,1554,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',3000.00,NULL,NULL,1,'2023-08-23 07:21:11','2023-08-23 07:21:11',NULL),(488,7812,40720,1554,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',21004.09,NULL,NULL,1,'2023-08-23 07:21:47','2023-08-23 07:21:47',NULL),(489,7812,40720,1554,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',20009.08,NULL,NULL,1,'2023-08-23 07:22:40','2023-08-23 07:22:40',NULL),(490,7812,40720,1554,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',20000.00,NULL,NULL,1,'2023-08-23 07:23:16','2023-08-23 07:23:16',NULL),(491,7812,40720,1554,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',20115.80,NULL,NULL,1,'2023-08-23 07:23:49','2023-08-23 07:23:49',NULL),(492,7812,40720,1554,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',20000.01,NULL,NULL,1,'2023-08-23 07:25:03','2023-08-23 07:25:03',NULL),(493,7812,40720,1554,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',21001.40,NULL,NULL,1,'2023-08-23 07:25:40','2023-08-23 07:25:40',NULL),(494,7812,40720,1554,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',22003.40,NULL,NULL,1,'2023-08-23 07:26:14','2023-08-23 07:26:14',NULL),(495,7812,40720,1554,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',25000.00,NULL,NULL,1,'2023-08-23 07:26:53','2023-08-23 07:26:53',NULL),(496,7812,40720,1554,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',7807.91,NULL,NULL,1,'2023-08-23 07:27:37','2023-08-23 07:27:37',NULL),(497,7812,40720,1554,3,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',28037.70,NULL,NULL,1,'2023-08-23 07:28:11','2023-08-23 07:28:11',NULL);
INSERT INTO `balance_libro` VALUES (498,7812,40720,1554,3,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',31000.40,NULL,NULL,1,'2023-08-23 07:28:54','2023-08-23 07:28:54',NULL),(499,7812,40720,1554,3,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',23004.31,NULL,NULL,1,'2023-08-23 07:29:53','2023-08-23 07:29:53',NULL),(500,7812,40720,1554,3,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',48003.50,NULL,NULL,1,'2023-08-23 07:30:24','2023-08-23 07:30:24',NULL),(501,7812,40720,1554,3,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',22001.79,NULL,NULL,1,'2023-08-23 07:30:55','2023-08-23 07:30:55',NULL),(502,7812,40720,1554,3,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',18010.71,NULL,NULL,1,'2023-08-23 07:31:22','2023-08-23 07:31:22',NULL),(503,7812,40720,1554,3,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',15000.30,NULL,NULL,1,'2023-08-23 07:31:56','2023-08-23 07:31:56',NULL),(504,7812,40720,1554,3,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',32000.91,NULL,NULL,1,'2023-08-23 07:33:01','2023-08-23 07:33:01',NULL),(505,7812,40720,1554,3,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',9601.81,NULL,NULL,1,'2023-08-23 07:33:31','2023-08-23 07:33:31',NULL),(506,7812,40720,1554,3,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',10902.90,NULL,NULL,1,'2023-08-23 07:35:10','2023-08-23 07:35:10',NULL),(507,7812,40720,1554,3,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',8002.20,NULL,NULL,1,'2023-08-23 07:35:44','2023-08-23 07:35:44',NULL),(508,7812,40720,1554,3,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',6810.20,NULL,NULL,1,'2023-08-23 07:36:19','2023-08-23 07:36:19',NULL),(509,7812,40720,1554,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',19002.99,NULL,NULL,1,'2023-08-23 07:36:56','2023-08-23 07:36:56',NULL),(510,7812,40720,1554,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',19607.10,NULL,NULL,1,'2023-08-23 07:37:29','2023-08-23 07:37:29',NULL),(511,7812,40720,1554,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',5588.21,NULL,NULL,1,'2023-08-23 07:38:09','2023-08-23 07:38:09',NULL),(512,7812,40720,1554,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',8403.72,NULL,NULL,1,'2023-08-23 07:39:29','2023-08-23 07:39:29',NULL),(513,7812,40720,1554,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',15019.00,NULL,NULL,1,'2023-08-23 07:39:58','2023-08-23 07:39:58',NULL),(514,7812,40720,1554,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-02','2023-07-02',30303.00,NULL,NULL,1,'2023-08-23 07:40:32','2023-08-23 07:40:32',NULL),(515,7812,40720,1554,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',29811.31,NULL,NULL,1,'2023-08-23 07:41:02','2023-08-23 07:41:02',NULL),(516,7812,40720,1554,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',5008.20,NULL,NULL,1,'2023-08-23 07:41:34','2023-08-23 07:41:34',NULL),(517,7812,40720,1554,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',3001.10,NULL,NULL,1,'2023-08-23 07:43:40','2023-08-23 07:43:40',NULL),(518,7812,40720,1554,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',80000.01,NULL,NULL,1,'2023-08-23 07:44:25','2023-08-23 07:44:25',NULL);
INSERT INTO `balance_libro` VALUES (519,7812,40720,1554,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',80000.01,NULL,NULL,1,'2023-08-23 07:45:20','2023-08-23 07:45:20',NULL),(520,7812,40720,1554,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',9121.60,NULL,NULL,1,'2023-08-23 07:46:48','2023-08-23 07:46:48',NULL),(521,7812,40720,1554,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',70879.00,NULL,NULL,1,'2023-08-23 07:47:38','2023-08-23 07:47:38',NULL),(522,7812,40720,1554,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',5300.00,NULL,NULL,1,'2023-08-23 07:51:08','2023-08-23 07:51:08',NULL),(523,7812,40720,1554,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',3200.00,NULL,NULL,1,'2023-08-23 07:52:47','2023-08-23 07:52:47',NULL),(524,7812,40720,1554,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',7452.00,NULL,NULL,1,'2023-08-23 07:53:10','2023-08-23 07:53:10',NULL),(525,7812,40720,1554,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',80011.27,NULL,NULL,1,'2023-08-23 07:56:04','2023-08-23 07:56:04',NULL),(526,7812,40720,1554,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',100000.56,NULL,NULL,1,'2023-08-23 07:56:50','2023-08-23 07:56:50',NULL),(527,7812,40720,1554,3,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',59999.22,NULL,NULL,1,'2023-08-23 07:58:16','2023-08-23 07:58:16',NULL),(528,7812,40720,1554,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',30000.00,NULL,NULL,1,'2023-08-23 07:59:04','2023-08-23 07:59:04',NULL),(529,7812,40720,1554,3,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',7400.45,NULL,NULL,1,'2023-08-23 08:00:09','2023-08-23 08:00:09',NULL),(530,7812,40720,1554,15,763,'App\\Models\\PeriodLiquidation',NULL,763,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',414295.65,NULL,NULL,1,'2023-08-23 17:33:57','2023-08-23 17:33:57',NULL),(531,7812,40720,1555,3,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',86499.99,NULL,NULL,1,'2023-09-17 10:09:41','2023-09-17 10:09:41',NULL),(532,7812,40720,1555,3,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-20','2023-08-20',30007.49,NULL,NULL,1,'2023-09-17 10:10:28','2023-09-17 10:10:28',NULL),(533,7812,40720,1555,3,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',43303.01,NULL,NULL,1,'2023-09-17 10:11:09','2023-09-17 10:11:09',NULL),(534,7812,40720,1555,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',43003.39,NULL,NULL,1,'2023-09-17 10:11:58','2023-09-17 10:11:58',NULL),(535,7812,40720,1555,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',30000.50,NULL,NULL,1,'2023-09-17 10:13:18','2023-09-17 10:15:27','2023-09-17 10:15:27'),(536,7812,40720,1555,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',10001.41,NULL,NULL,1,'2023-09-17 10:13:54','2023-09-17 10:15:43','2023-09-17 10:15:43'),(537,7812,40720,1555,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',30001.62,NULL,NULL,1,'2023-09-17 10:14:40','2023-09-17 10:14:40',NULL),(538,7812,40720,1555,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',30000.50,NULL,NULL,1,'2023-09-17 10:15:27','2023-09-17 10:15:27',NULL),(539,7812,40720,1555,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',10001.41,NULL,NULL,1,'2023-09-17 10:15:43','2023-09-17 10:15:43',NULL);
INSERT INTO `balance_libro` VALUES (540,7812,40720,1555,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',29913.59,NULL,NULL,1,'2023-09-17 10:18:10','2023-09-17 10:18:10',NULL),(541,7812,40720,1555,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',30000.59,NULL,NULL,1,'2023-09-17 10:21:25','2023-09-17 10:21:25',NULL),(542,7812,40720,1555,3,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',3406.79,NULL,NULL,1,'2023-09-17 10:22:09','2023-09-17 10:22:09',NULL),(543,7812,40720,1555,3,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',5000.01,NULL,NULL,1,'2023-09-17 10:23:20','2023-09-17 10:23:20',NULL),(544,7812,40720,1555,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',25000.01,NULL,NULL,1,'2023-09-17 10:23:54','2023-09-17 10:23:54',NULL),(545,7812,40720,1555,3,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',15000.01,NULL,NULL,1,'2023-09-17 10:24:43','2023-09-17 10:24:43',NULL),(546,7812,40720,1555,3,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',5000.00,NULL,NULL,1,'2023-09-17 10:25:28','2023-09-17 10:25:28',NULL),(547,7812,40720,1555,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',30000.01,NULL,NULL,1,'2023-09-17 10:27:52','2023-09-17 10:27:52',NULL),(548,7812,40720,1555,3,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',30000.01,NULL,NULL,1,'2023-09-17 10:28:36','2023-09-17 10:28:36',NULL),(549,7812,40720,1555,3,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',7301.61,NULL,NULL,1,'2023-09-17 10:29:14','2023-09-17 10:29:14',NULL),(550,7812,40720,1555,3,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-27','2023-08-27',30089.39,NULL,NULL,1,'2023-09-17 10:29:46','2023-09-17 10:29:46',NULL),(551,7812,40720,1555,3,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-27','2023-08-27',75807.61,NULL,NULL,1,'2023-09-17 10:30:17','2023-09-17 10:30:17',NULL),(552,7812,40720,1555,3,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3001.50,NULL,NULL,1,'2023-09-17 10:31:23','2023-09-17 10:31:23',NULL),(553,7812,40720,1555,3,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',18638.11,NULL,NULL,1,'2023-09-17 10:32:52','2023-09-17 10:32:52',NULL),(554,7812,40720,1555,3,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',10000.10,NULL,NULL,1,'2023-09-17 10:33:47','2023-09-17 10:33:47',NULL),(555,7812,40720,1555,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',9616.72,NULL,NULL,1,'2023-09-17 10:34:58','2023-09-17 10:34:58',NULL),(556,7812,40720,1555,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',19999.98,NULL,NULL,1,'2023-09-17 10:35:30','2023-09-17 10:35:30',NULL),(557,7812,40720,1555,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8700.90,NULL,NULL,1,'2023-09-17 10:36:11','2023-09-17 10:36:11',NULL),(558,7812,40720,1555,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',10000.00,NULL,NULL,1,'2023-09-17 10:36:43','2023-09-17 10:36:43',NULL),(559,7812,40720,1555,3,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',20000.10,NULL,NULL,1,'2023-09-17 10:37:13','2023-09-17 10:37:13',NULL),(560,7812,40720,1555,3,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',36003.59,NULL,NULL,1,'2023-09-17 10:37:46','2023-09-17 10:37:46',NULL);
INSERT INTO `balance_libro` VALUES (561,7812,40720,1555,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',20000.00,NULL,NULL,1,'2023-09-17 10:38:53','2023-09-17 10:38:53',NULL),(562,7812,40720,1555,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',8415.71,NULL,NULL,1,'2023-09-17 10:39:24','2023-09-17 10:39:24',NULL),(563,7812,40720,1555,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',25003.31,NULL,NULL,1,'2023-09-17 10:40:03','2023-09-17 10:40:03',NULL),(564,7812,40720,1555,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',40018.39,NULL,NULL,1,'2023-09-17 10:40:37','2023-09-17 10:40:37',NULL),(565,7812,40720,1555,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',30307.00,NULL,NULL,1,'2023-09-17 10:41:49','2023-09-17 10:41:49',NULL),(566,7812,40720,1555,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',35000.51,NULL,NULL,1,'2023-09-17 10:42:28','2023-09-17 10:42:28',NULL),(567,7812,40720,1555,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',25001.41,NULL,NULL,1,'2023-09-17 10:43:01','2023-09-17 10:43:01',NULL),(568,7812,40720,1555,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',30012.70,NULL,NULL,1,'2023-09-17 10:43:29','2023-09-17 10:43:29',NULL),(569,7812,40720,1555,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-30','2023-07-30',25118.21,NULL,NULL,1,'2023-09-17 10:44:06','2023-09-17 10:44:06',NULL),(570,7812,40720,1555,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',10506.08,NULL,NULL,1,'2023-09-17 10:44:53','2023-09-17 10:44:53',NULL),(571,7812,40720,1555,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',28399.99,NULL,NULL,1,'2023-09-17 10:48:19','2023-09-17 10:48:19',NULL),(572,7812,40720,1555,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',88000.00,NULL,NULL,1,'2023-09-17 10:48:59','2023-09-17 10:48:59',NULL),(573,7812,40720,1555,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',41000.00,NULL,NULL,1,'2023-09-17 10:49:28','2023-09-17 10:49:28',NULL),(574,7812,40720,1555,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',1800.00,NULL,NULL,1,'2023-09-17 10:50:30','2023-09-17 10:50:30',NULL),(575,7812,40720,1555,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',5700.01,NULL,NULL,1,'2023-09-17 10:51:02','2023-09-17 10:51:02',NULL),(576,7812,40720,1555,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',23776.00,NULL,NULL,1,'2023-09-17 10:51:43','2023-09-17 10:51:43',NULL),(577,7812,40720,1555,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',7300.00,NULL,NULL,1,'2023-09-17 10:52:13','2023-09-17 10:52:13',NULL),(578,7812,40720,1555,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',14000.19,NULL,NULL,1,'2023-09-17 10:54:27','2023-09-17 10:54:27',NULL),(579,7812,40720,1555,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',29999.98,NULL,NULL,1,'2023-09-17 10:55:15','2023-09-17 10:55:15',NULL),(580,7812,40720,1555,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',8000.00,NULL,NULL,1,'2023-09-17 10:55:55','2023-09-17 10:55:55',NULL),(581,7812,40720,1555,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',24999.99,NULL,NULL,1,'2023-09-17 10:56:39','2023-09-17 10:56:39',NULL);
INSERT INTO `balance_libro` VALUES (582,7812,40720,1555,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',69999.99,NULL,NULL,1,'2023-09-17 10:57:30','2023-09-17 10:57:30',NULL),(583,7812,40720,1555,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',30000.00,NULL,NULL,1,'2023-09-17 10:58:22','2023-09-17 10:58:22',NULL),(584,7812,40720,1555,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',59999.99,NULL,NULL,1,'2023-09-17 10:59:08','2023-09-17 10:59:08',NULL),(585,7812,40720,1555,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',59999.99,NULL,NULL,1,'2023-09-17 10:59:51','2023-09-17 10:59:51',NULL),(586,7812,40720,1555,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',35873.41,NULL,NULL,1,'2023-09-17 11:02:58','2023-09-17 11:02:58',NULL),(587,7812,40720,1555,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',8000.04,NULL,NULL,1,'2023-09-17 11:03:24','2023-09-17 11:03:24',NULL),(588,7812,40720,1555,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',85801.50,NULL,NULL,1,'2023-09-17 11:04:49','2023-09-17 11:04:49',NULL),(589,7812,40720,1555,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',357039.54,NULL,NULL,1,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(590,7812,40720,1555,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',192861.90,NULL,NULL,1,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(591,7812,40720,1555,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',229348.24,NULL,NULL,1,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(592,7812,40720,1555,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',419671.56,NULL,NULL,1,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(593,7812,40720,1555,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',252220.87,NULL,NULL,1,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(594,7812,40720,1555,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',418150.59,NULL,NULL,1,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(595,7812,40720,1555,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',193237.00,NULL,NULL,1,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(596,7812,40720,1555,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',199323.30,NULL,NULL,1,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(597,7812,40720,1555,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',491449.37,NULL,NULL,1,'2023-09-17 11:07:24','2023-09-17 11:07:24',NULL),(598,7812,40720,1555,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',515253.09,NULL,NULL,1,'2023-09-17 11:07:24','2023-09-17 11:07:24',NULL),(599,7812,40720,1555,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',6500.00,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(600,7812,40720,1555,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',744990.32,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(601,7812,40720,1555,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',31871.81,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(602,7812,40720,1555,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',49999.00,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL);
INSERT INTO `balance_libro` VALUES (603,7812,40720,1555,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',110000.00,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(604,7812,40720,1555,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',36608.00,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(605,7812,40720,1555,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',17969.99,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(606,7812,40720,1555,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',86100.00,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(607,7812,40720,1555,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',4132.33,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(608,7812,40720,1555,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',35239.00,NULL,NULL,1,'2023-09-17 11:07:45','2023-09-19 19:51:22','2023-09-19 19:51:22'),(609,7812,40720,1555,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',38000.00,NULL,NULL,1,'2023-09-17 11:07:46','2023-09-17 11:07:46',NULL),(610,7812,40720,1555,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',4180.01,NULL,NULL,1,'2023-09-17 11:07:46','2023-09-17 11:07:46',NULL),(611,7812,40720,1555,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',35239.00,NULL,NULL,1,'2023-09-19 19:51:22','2023-09-19 19:51:22',NULL),(612,7812,40720,1555,15,887,'App\\Models\\PeriodLiquidation',NULL,887,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',686763.83,NULL,NULL,1,'2023-09-19 19:54:42','2025-06-07 09:10:07','2025-06-07 09:10:07'),(613,7812,40720,1556,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',501985.44,NULL,NULL,1,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(614,7812,40720,1556,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',257080.23,NULL,NULL,1,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(615,7812,40720,1556,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',502609.80,NULL,NULL,1,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(616,7812,40720,1556,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',326700.00,NULL,NULL,1,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(617,7812,40720,1556,3,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',36000.00,NULL,NULL,1,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(618,7812,40720,1556,3,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',253745.09,NULL,NULL,1,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(619,7812,40720,1556,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',90000.00,NULL,NULL,1,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(620,7812,40720,1556,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',14000.00,NULL,NULL,1,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(621,7812,40720,1556,3,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',111000.02,NULL,NULL,1,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(622,7812,40720,1556,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',30100.00,NULL,NULL,1,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(623,7812,40720,1556,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',750000.35,NULL,NULL,1,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL);
INSERT INTO `balance_libro` VALUES (624,7812,40720,1556,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',50000.00,NULL,NULL,1,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(625,7812,40720,1556,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',14000.00,NULL,NULL,1,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(626,7812,40720,1556,15,891,'App\\Models\\PeriodLiquidation',NULL,891,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',342483.56,NULL,NULL,1,'2023-11-01 18:19:59','2025-06-07 09:35:23','2025-06-07 09:35:23'),(627,7812,40720,1557,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',326700.00,NULL,NULL,1,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(628,7812,40720,1557,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',326700.00,NULL,NULL,1,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(629,7812,40720,1557,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',392040.00,NULL,NULL,1,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(630,7812,40720,1557,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',326700.00,NULL,NULL,1,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(631,7812,40720,1557,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',653400.00,NULL,NULL,1,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(632,7812,40720,1557,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',653400.00,NULL,NULL,1,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(633,7812,40720,1557,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',196020.00,NULL,NULL,1,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(634,7812,40720,1557,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',8700.00,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(635,7812,40720,1557,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',12553.99,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(636,7812,40720,1557,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',14309.99,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(637,7812,40720,1557,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',47349.99,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(638,7812,40720,1557,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',1993.00,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(639,7812,40720,1557,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',98521.35,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(640,7812,40720,1557,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',19000.00,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(641,7812,40720,1557,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',135100.00,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:20:16','2023-11-21 17:20:16'),(642,7812,40720,1557,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',199920.00,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:20:08','2023-11-21 17:20:08'),(643,7812,40720,1557,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',107107.00,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:19:59','2023-11-21 17:19:59');
INSERT INTO `balance_libro` VALUES (644,7812,40720,1557,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',199920.00,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:19:51','2023-11-21 17:19:51'),(645,7812,40720,1557,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',16000.00,NULL,NULL,1,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(646,7812,40720,1557,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',19500.00,NULL,NULL,1,'2023-11-21 17:11:06','2023-11-21 17:18:05','2023-11-21 17:18:05'),(647,7812,40720,1557,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',19500.00,NULL,NULL,1,'2023-11-21 17:18:05','2023-11-21 17:18:05',NULL),(648,7812,40720,1557,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',23092.60,NULL,NULL,1,'2023-11-21 17:26:29','2023-11-21 17:26:29',NULL),(649,7812,40720,1557,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-23','2023-07-23',17001.49,NULL,NULL,1,'2023-11-21 17:27:16','2023-11-21 17:27:16',NULL),(650,7812,40720,1557,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',9423.41,NULL,NULL,1,'2023-11-21 17:28:04','2023-11-21 17:28:04',NULL),(651,7812,40720,1557,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',19999.99,NULL,NULL,1,'2023-11-21 17:28:43','2023-11-21 17:28:43',NULL),(652,7812,40720,1557,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',35005.42,NULL,NULL,1,'2023-11-21 17:29:26','2023-11-21 17:29:26',NULL),(653,7812,40720,1557,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',6000.01,NULL,NULL,1,'2023-11-21 17:30:50','2023-11-21 17:30:50',NULL),(654,7812,40720,1557,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',30003.69,NULL,NULL,1,'2023-11-21 17:31:31','2023-11-21 17:31:31',NULL),(655,7812,40720,1557,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',30019.60,NULL,NULL,1,'2023-11-21 17:32:09','2023-11-21 17:32:09',NULL),(656,7812,40720,1557,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',7999.99,NULL,NULL,1,'2023-11-21 17:32:56','2023-11-21 17:32:56',NULL),(657,7812,40720,1557,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',25004.92,NULL,NULL,1,'2023-11-21 17:33:43','2023-11-21 17:33:43',NULL),(658,7812,40720,1557,3,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-17','2023-09-17',30000.00,NULL,NULL,1,'2023-11-21 17:34:31','2023-11-21 17:34:31',NULL),(659,7812,40720,1557,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-17','2023-09-17',157465.02,NULL,NULL,1,'2023-11-21 17:35:12','2023-11-21 17:35:12',NULL),(660,7812,40720,1557,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',3003.01,NULL,NULL,1,'2023-11-21 17:36:12','2023-11-21 17:36:12',NULL),(661,7812,40720,1557,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',16000.02,NULL,NULL,1,'2023-11-21 17:36:50','2023-11-21 17:36:50',NULL),(662,7812,40720,1557,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',17203.10,NULL,NULL,1,'2023-11-21 17:38:15','2023-11-21 17:38:15',NULL),(663,7812,40720,1557,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',7000.01,NULL,NULL,1,'2023-11-21 17:39:25','2023-11-21 17:39:25',NULL),(664,7812,40720,1557,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',35001.50,NULL,NULL,1,'2023-11-21 17:40:10','2023-11-21 17:40:10',NULL);
INSERT INTO `balance_libro` VALUES (665,7812,40720,1557,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',47999.19,NULL,NULL,1,'2023-11-21 17:40:50','2023-11-21 17:40:50',NULL),(666,7812,40720,1557,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',87253.61,NULL,NULL,1,'2023-11-21 17:41:54','2023-11-21 17:41:54',NULL),(667,7812,40720,1557,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',6000.01,NULL,NULL,1,'2023-11-21 17:42:31','2023-11-21 17:42:31',NULL),(668,7812,40720,1557,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',40008.62,NULL,NULL,1,'2023-11-21 17:43:33','2023-11-21 17:43:33',NULL),(669,7812,40720,1557,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',30029.19,NULL,NULL,1,'2023-11-21 17:44:19','2023-11-21 17:44:19',NULL),(670,7812,40720,1557,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',9704.89,NULL,NULL,1,'2023-11-21 17:45:00','2023-11-21 17:45:00',NULL),(671,7812,40720,1557,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',29972.49,NULL,NULL,1,'2023-11-21 17:45:46','2023-11-21 17:45:46',NULL),(672,7812,40720,1557,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',5000.00,NULL,NULL,1,'2023-11-21 17:47:26','2023-11-21 17:47:26',NULL),(673,7812,40720,1557,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-22','2023-10-22',40047.21,NULL,NULL,1,'2023-11-21 17:48:15','2023-11-21 17:48:15',NULL),(674,7812,40720,1557,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-22','2023-10-22',30000.00,NULL,NULL,1,'2023-11-21 17:48:55','2023-11-21 17:48:55',NULL),(675,7812,40720,1557,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',59999.99,NULL,NULL,1,'2023-11-21 17:49:30','2023-11-21 17:49:30',NULL),(676,7812,40720,1557,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',32001.59,NULL,NULL,1,'2023-11-21 17:50:00','2023-11-21 17:50:00',NULL),(677,7812,40720,1557,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',9200.01,NULL,NULL,1,'2023-11-21 17:52:03','2023-11-21 17:52:03',NULL),(678,7812,40720,1557,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',70000.00,NULL,NULL,1,'2023-11-21 17:53:03','2023-11-21 17:53:03',NULL),(679,7812,40720,1557,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',35850.00,NULL,NULL,1,'2023-11-21 17:53:51','2023-11-21 17:53:51',NULL),(680,7812,40720,1557,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',31000.02,NULL,NULL,1,'2023-11-21 17:54:53','2023-11-21 17:54:53',NULL),(681,7812,40720,1557,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',60000.01,NULL,NULL,1,'2023-11-21 17:55:30','2023-11-21 17:55:30',NULL),(682,7812,40720,1557,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',42002.11,NULL,NULL,1,'2023-11-21 17:56:09','2023-11-21 17:56:09',NULL),(683,7812,40720,1557,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',6802.99,NULL,NULL,1,'2023-11-21 17:56:42','2023-11-21 17:56:42',NULL),(684,7812,40720,1557,15,981,'App\\Models\\PeriodLiquidation',NULL,981,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',406890.14,NULL,NULL,1,'2023-11-22 07:56:25','2023-11-22 07:56:25',NULL),(685,7812,40825,4557,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',83172.60,NULL,NULL,1,'2023-12-14 17:45:33','2023-12-14 18:42:52','2023-12-14 18:42:52');
INSERT INTO `balance_libro` VALUES (686,7812,40825,4557,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',98500.00,NULL,NULL,1,'2023-12-14 17:46:37','2023-12-14 18:42:40','2023-12-14 18:42:40'),(687,7812,40825,4557,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',152001.72,NULL,NULL,1,'2023-12-14 17:52:14','2023-12-14 18:42:29','2023-12-14 18:42:29'),(688,7812,40825,4557,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',86740.20,NULL,NULL,1,'2023-12-14 17:52:53','2023-12-14 18:42:17','2023-12-14 18:42:17'),(689,7812,40825,4557,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',98999.99,NULL,NULL,1,'2023-12-14 17:56:28','2023-12-14 18:42:06','2023-12-14 18:42:06'),(690,7812,40825,4557,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',98999.99,NULL,NULL,1,'2023-12-14 17:58:46','2023-12-14 18:41:39','2023-12-14 18:41:39'),(691,7812,40825,4557,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',326700.00,NULL,NULL,1,'2023-12-14 18:00:05','2023-12-14 18:45:20','2023-12-14 18:45:20'),(692,7812,40825,4557,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',326700.00,NULL,NULL,1,'2023-12-14 18:00:05','2023-12-14 18:45:08','2023-12-14 18:45:08'),(693,7812,40825,4557,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',326700.00,NULL,NULL,1,'2023-12-14 18:00:05','2023-12-14 18:44:57','2023-12-14 18:44:57'),(694,7812,40825,4557,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',696306.60,NULL,NULL,1,'2023-12-14 18:00:05','2023-12-14 18:44:45','2023-12-14 18:44:45'),(695,7812,40825,4557,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',326700.00,NULL,NULL,1,'2023-12-14 18:00:05','2023-12-14 18:44:35','2023-12-14 18:44:35'),(696,7812,40825,4557,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',315810.00,NULL,NULL,1,'2023-12-14 18:00:06','2023-12-14 18:44:24','2023-12-14 18:44:24'),(697,7812,40825,4557,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',584793.00,NULL,NULL,1,'2023-12-14 18:00:06','2023-12-14 18:44:13','2023-12-14 18:44:13'),(698,7812,40825,4557,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',696306.60,NULL,NULL,1,'2023-12-14 18:00:06','2023-12-14 18:44:01','2023-12-14 18:44:01'),(699,7812,40825,4557,7,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',56700.00,NULL,NULL,1,'2023-12-14 18:13:24','2023-12-14 18:13:24',NULL),(700,7812,40825,4557,7,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',56700.00,NULL,NULL,1,'2023-12-14 18:14:11','2023-12-14 18:14:11',NULL),(701,7812,40825,4557,7,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',54810.00,NULL,NULL,1,'2023-12-14 18:14:49','2023-12-14 18:14:49',NULL),(702,7812,40825,4557,7,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',101493.00,NULL,NULL,1,'2023-12-14 18:15:26','2023-12-14 18:15:26',NULL),(703,7812,40825,4557,7,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',120846.60,NULL,NULL,1,'2023-12-14 18:16:01','2023-12-14 18:16:01',NULL),(704,7812,40825,4557,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',174000.60,NULL,NULL,1,'2023-12-14 18:36:58','2023-12-14 18:37:52','2023-12-14 18:37:52'),(705,7812,40825,4557,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',174000.61,NULL,NULL,1,'2023-12-14 18:41:10','2023-12-14 18:41:10',NULL);
INSERT INTO `balance_libro` VALUES (706,7812,40825,4557,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',98999.99,NULL,NULL,1,'2023-12-14 18:41:39','2023-12-14 18:41:39',NULL),(707,7812,40825,4557,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',98999.99,NULL,NULL,1,'2023-12-14 18:42:06','2023-12-14 18:42:06',NULL),(708,7812,40825,4557,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',86740.20,NULL,NULL,1,'2023-12-14 18:42:17','2023-12-14 18:42:17',NULL),(709,7812,40825,4557,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',152001.72,NULL,NULL,1,'2023-12-14 18:42:29','2023-12-14 18:42:29',NULL),(710,7812,40825,4557,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',98500.00,NULL,NULL,1,'2023-12-14 18:42:40','2023-12-14 18:42:40',NULL),(711,7812,40825,4557,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',83172.60,NULL,NULL,1,'2023-12-14 18:42:52','2023-12-14 18:42:52',NULL),(712,7812,40825,4557,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',696306.60,NULL,NULL,1,'2023-12-14 18:44:01','2023-12-14 18:44:01',NULL),(713,7812,40825,4557,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',584793.00,NULL,NULL,1,'2023-12-14 18:44:13','2023-12-14 18:44:13',NULL),(714,7812,40825,4557,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',315810.00,NULL,NULL,1,'2023-12-14 18:44:24','2023-12-14 18:44:24',NULL),(715,7812,40825,4557,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',326700.00,NULL,NULL,1,'2023-12-14 18:44:35','2023-12-14 18:44:35',NULL),(716,7812,40825,4557,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',696306.60,NULL,NULL,1,'2023-12-14 18:44:45','2023-12-14 18:44:45',NULL),(717,7812,40825,4557,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',326700.00,NULL,NULL,1,'2023-12-14 18:44:57','2023-12-14 18:44:57',NULL),(718,7812,40825,4557,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',326700.00,NULL,NULL,1,'2023-12-14 18:45:08','2023-12-14 18:45:08',NULL),(719,7812,40825,4557,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',326700.00,NULL,NULL,1,'2023-12-14 18:45:20','2023-12-14 18:45:20',NULL),(720,7812,40825,4557,15,1041,'App\\Models\\PeriodLiquidation',NULL,1041,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',578375.39,NULL,NULL,1,'2023-12-18 19:29:59','2023-12-18 19:29:59',NULL),(721,7812,40720,1558,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',326700.00,NULL,NULL,1,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(722,7812,40720,1558,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',112500.00,NULL,NULL,1,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(723,7812,40720,1558,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',30000.00,NULL,NULL,1,'2023-12-18 19:36:00','2023-12-18 19:37:55','2023-12-18 19:37:55'),(724,7812,40720,1558,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',370260.00,NULL,NULL,1,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(725,7812,40720,1558,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',326700.00,NULL,NULL,1,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(726,7812,40720,1558,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',326700.00,NULL,NULL,1,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL);
INSERT INTO `balance_libro` VALUES (727,7812,40720,1558,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',529863.84,NULL,NULL,1,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(728,7812,40720,1558,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',275761.25,NULL,NULL,1,'2023-12-18 19:36:18','2023-12-18 19:40:00','2023-12-18 19:40:00'),(729,7812,40720,1558,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',285000.00,NULL,NULL,1,'2023-12-18 19:36:18','2023-12-18 19:39:49','2023-12-18 19:39:49'),(730,7812,40720,1558,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',151920.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:39:01','2023-12-18 19:39:01'),(731,7812,40720,1558,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',50000.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(732,7812,40720,1558,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',201020.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:39:38','2023-12-18 19:39:38'),(733,7812,40720,1558,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',49000.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(734,7812,40720,1558,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',44000.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(735,7812,40720,1558,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',287640.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:39:27','2023-12-18 19:39:27'),(736,7812,40720,1558,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',215910.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:39:16','2023-12-18 19:39:16'),(737,7812,40720,1558,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',29653.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(738,7812,40720,1558,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',665999.10,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(739,7812,40720,1558,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',25000.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(740,7812,40720,1558,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',10800.00,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(741,7812,40720,1558,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',55183.23,NULL,NULL,1,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(742,7812,40720,1558,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',30000.00,NULL,NULL,1,'2023-12-18 19:37:55','2023-12-18 19:37:55',NULL),(743,7812,40720,1558,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',20000.04,NULL,NULL,1,'2023-12-19 18:42:34','2023-12-19 18:42:34',NULL),(744,7812,40720,1558,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',31002.83,NULL,NULL,1,'2023-12-19 18:43:20','2023-12-19 18:43:20',NULL),(745,7812,40720,1558,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',24114.67,NULL,NULL,1,'2023-12-19 18:44:01','2023-12-19 18:44:01',NULL),(746,7812,40720,1558,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',30000.02,NULL,NULL,1,'2023-12-19 18:46:14','2023-12-19 18:46:14',NULL);
INSERT INTO `balance_libro` VALUES (747,7812,40720,1558,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',150001.20,NULL,NULL,1,'2023-12-19 18:47:59','2023-12-19 18:47:59',NULL),(748,7812,40720,1558,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',30637.66,NULL,NULL,1,'2023-12-19 18:49:35','2023-12-19 18:50:52','2023-12-19 18:50:52'),(749,7812,40720,1558,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',32000.67,NULL,NULL,1,'2023-12-19 18:50:52','2023-12-19 18:50:52',NULL),(750,7812,40720,1558,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',152601.21,NULL,NULL,1,'2023-12-19 18:52:43','2023-12-19 18:52:43',NULL),(751,7812,40720,1558,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',99999.77,NULL,NULL,1,'2023-12-19 18:56:02','2023-12-19 18:56:02',NULL),(752,7812,40720,1558,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',109999.94,NULL,NULL,1,'2023-12-19 19:00:36','2023-12-19 19:00:36',NULL),(753,7812,40720,1558,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-08','2023-10-08',140200.63,NULL,NULL,1,'2023-12-19 19:02:00','2023-12-19 19:02:00',NULL),(754,7812,40720,1558,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',70000.01,NULL,NULL,1,'2023-12-19 19:02:39','2023-12-19 19:02:39',NULL),(755,7812,40720,1558,15,1082,'App\\Models\\PeriodLiquidation',NULL,1082,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',351051.24,NULL,NULL,1,'2023-12-19 20:35:50','2023-12-19 20:35:50',NULL),(756,7812,40825,4558,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',1085754.78,NULL,NULL,1,'2024-01-18 18:33:19','2024-01-18 18:33:19',NULL),(757,7812,40825,4558,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',696306.60,NULL,NULL,1,'2024-01-18 18:33:19','2024-01-18 18:33:19',NULL),(758,7812,40825,4558,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-08','2023-12-08',580000.00,NULL,NULL,1,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(759,7812,40825,4558,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',63505.00,NULL,NULL,1,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(760,7812,40825,4558,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',65900.00,NULL,NULL,1,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(761,7812,40825,4558,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',37500.03,NULL,NULL,1,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(762,7812,40825,4558,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',65922.64,NULL,NULL,1,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(763,7812,40825,4558,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',79999.99,NULL,NULL,1,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(764,7812,40825,4558,7,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',188436.78,NULL,NULL,1,'2024-01-18 18:46:09','2024-01-18 18:46:09',NULL),(765,7812,40720,1559,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',370913.40,NULL,NULL,1,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(766,7812,40720,1559,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',370260.00,NULL,NULL,1,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(767,7812,40720,1559,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',367973.10,NULL,NULL,1,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL);
INSERT INTO `balance_libro` VALUES (768,7812,40720,1559,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',370260.00,NULL,NULL,1,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(769,7812,40720,1559,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',64000.00,NULL,NULL,1,'2024-01-22 18:47:03','2024-02-11 11:21:03','2024-02-11 11:21:03'),(770,7812,40720,1559,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',25068.60,NULL,NULL,1,'2024-01-22 18:47:03','2024-01-22 18:47:03',NULL),(771,7812,40720,1559,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',67800.00,NULL,NULL,1,'2024-01-26 18:18:23','2024-02-11 11:26:14','2024-02-11 11:26:14'),(772,7812,40720,1559,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',49007.49,NULL,NULL,1,'2024-01-26 18:20:24','2024-02-11 11:26:06','2024-02-11 11:26:06'),(773,7812,40720,1559,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',55088.29,NULL,NULL,1,'2024-01-26 18:20:59','2024-02-11 11:25:59','2024-02-11 11:25:59'),(774,7812,40720,1559,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',50432.39,NULL,NULL,1,'2024-02-11 10:36:43','2024-02-11 10:36:43',NULL),(775,7812,40720,1559,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',14504.61,NULL,NULL,1,'2024-02-11 10:37:29','2024-02-11 10:37:29',NULL),(776,7812,40720,1559,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',40016.93,NULL,NULL,1,'2024-02-11 10:39:31','2024-02-11 10:39:31',NULL),(777,7812,40720,1559,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',132407.00,NULL,NULL,1,'2024-02-11 10:40:48','2024-02-11 10:40:48',NULL),(778,7812,40720,1559,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',98999.98,NULL,NULL,1,'2024-02-11 10:41:35','2024-02-11 10:41:35',NULL),(779,7812,40720,1559,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',85001.40,NULL,NULL,1,'2024-02-11 10:43:26','2024-02-11 10:43:26',NULL),(780,7812,40720,1559,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',70996.32,NULL,NULL,1,'2024-02-11 10:44:10','2024-02-11 10:44:10',NULL),(781,7812,40720,1559,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',72000.00,NULL,NULL,1,'2024-02-11 10:45:21','2024-02-11 10:45:21',NULL),(782,7812,40720,1559,3,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',98999.82,NULL,NULL,1,'2024-02-11 10:47:18','2024-02-11 10:47:18',NULL),(783,7812,40720,1559,3,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',197999.82,NULL,NULL,1,'2024-02-11 10:49:07','2024-02-11 10:49:07',NULL),(784,7812,40720,1559,3,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',180000.20,NULL,NULL,1,'2024-02-11 10:49:52','2024-02-11 10:49:52',NULL),(785,7812,40720,1559,3,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',98999.98,NULL,NULL,1,'2024-02-11 10:51:46','2024-02-11 10:51:46',NULL),(786,7812,40720,1559,3,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',83599.99,NULL,NULL,1,'2024-02-11 10:52:54','2024-02-11 10:52:54',NULL),(787,7812,40720,1559,3,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',40006.31,NULL,NULL,1,'2024-02-11 10:53:49','2024-02-11 10:53:49',NULL),(788,7812,40720,1559,3,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-08','2023-12-08',94365.41,NULL,NULL,1,'2024-02-11 10:54:34','2024-02-11 10:54:34',NULL);
INSERT INTO `balance_libro` VALUES (789,7812,40720,1559,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-10','2023-12-10',29999.98,NULL,NULL,1,'2024-02-11 10:55:16','2024-02-11 10:55:16',NULL),(790,7812,40720,1559,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',99990.00,NULL,NULL,1,'2024-02-11 10:55:52','2024-02-11 10:55:52',NULL),(791,7812,40720,1559,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',99990.00,NULL,NULL,1,'2024-02-11 10:56:35','2024-02-11 10:56:35',NULL),(792,7812,40720,1559,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',199980.01,NULL,NULL,1,'2024-02-11 10:57:25','2024-02-11 10:57:25',NULL),(793,7812,40720,1559,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',199980.01,NULL,NULL,1,'2024-02-11 10:57:59','2024-02-11 10:57:59',NULL),(794,7812,40720,1559,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',199980.01,NULL,NULL,1,'2024-02-11 10:58:37','2024-02-11 10:58:37',NULL),(795,7812,40720,1559,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',200000.04,NULL,NULL,1,'2024-02-11 10:59:11','2024-02-11 10:59:11',NULL),(796,7812,40720,1559,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',9999.97,NULL,NULL,1,'2024-02-11 10:59:55','2024-02-11 10:59:55',NULL),(797,7812,40720,1559,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',40026.61,NULL,NULL,1,'2024-02-11 11:01:00','2024-02-11 11:01:00',NULL),(798,7812,40720,1559,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',64000.00,NULL,NULL,1,'2024-02-11 11:21:03','2024-02-11 11:21:03',NULL),(799,7812,40825,4560,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',493680.00,NULL,NULL,1,'2024-02-20 11:57:45','2024-02-20 11:57:45',NULL),(800,7812,40825,4560,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1593570.00,NULL,NULL,1,'2024-02-20 11:57:45','2024-02-20 11:57:45',NULL),(801,7812,40825,4560,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',620000.01,NULL,NULL,1,'2024-02-20 11:58:07','2024-02-20 11:58:07',NULL),(802,7812,40825,4560,7,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',85680.00,NULL,NULL,1,'2024-02-20 12:07:06','2024-02-20 12:07:06',NULL),(803,7812,40825,4560,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',125001.01,NULL,NULL,1,'2024-02-20 12:40:50','2024-02-20 12:40:50',NULL),(804,7812,40825,4560,15,1165,'App\\Models\\PeriodLiquidation',NULL,1165,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',488409.65,NULL,NULL,1,'2024-02-20 12:57:55','2024-02-20 12:57:55',NULL),(805,7812,40720,1559,15,1156,'App\\Models\\PeriodLiquidation',NULL,1156,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',422698.40,NULL,NULL,1,'2024-02-20 18:21:04','2024-02-20 18:21:04',NULL),(806,7812,40720,1563,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',321472.80,NULL,NULL,1,'2024-02-20 18:23:50','2024-02-20 18:23:50',NULL),(807,7812,40720,1563,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',328616.64,NULL,NULL,1,'2024-02-20 18:23:50','2024-02-20 18:23:50',NULL),(808,7812,40720,1563,3,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',39999.00,NULL,NULL,1,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(809,7812,40720,1563,3,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',27000.00,NULL,NULL,1,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL);
INSERT INTO `balance_libro` VALUES (810,7812,40720,1563,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',50000.00,NULL,NULL,1,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(811,7812,40720,1563,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',92421.00,NULL,NULL,1,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(812,7812,40720,1563,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',99888.36,NULL,NULL,1,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(813,7812,40720,1563,15,1169,'App\\Models\\PeriodLiquidation',NULL,1169,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',216482.35,NULL,NULL,1,'2024-02-20 18:38:21','2024-02-20 18:38:21',NULL),(814,7812,40825,4558,15,1158,'App\\Models\\PeriodLiquidation',NULL,1158,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',462295.88,NULL,NULL,1,'2024-03-06 18:09:52','2024-03-06 18:09:52',NULL),(815,7812,40825,4561,3,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',50000.01,NULL,NULL,1,'2024-03-16 08:28:36','2024-03-16 08:28:36',NULL),(816,7812,40825,4561,3,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',442998.40,NULL,NULL,1,'2024-03-16 08:30:47','2024-03-16 08:30:47',NULL),(817,7812,40825,4561,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',200000.00,NULL,NULL,1,'2024-03-16 08:31:49','2024-03-16 08:31:49',NULL),(818,7812,40825,4561,3,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',380007.80,NULL,NULL,1,'2024-03-16 08:34:08','2024-03-16 08:34:08',NULL),(819,7812,40825,4561,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',424001.09,NULL,NULL,1,'2024-03-16 08:35:37','2024-03-16 08:35:37',NULL),(820,7812,40825,4561,3,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',430039.58,NULL,NULL,1,'2024-03-16 08:39:17','2024-03-16 08:39:17',NULL),(821,7812,40825,4561,3,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',50000.00,NULL,NULL,1,'2024-03-16 08:40:45','2024-03-16 08:40:45',NULL),(822,7812,40825,4561,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',96371.00,NULL,NULL,1,'2024-03-16 08:42:23','2024-03-16 08:42:23',NULL),(823,7812,40825,4561,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',100000.00,NULL,NULL,1,'2024-03-16 08:43:07','2024-03-16 08:43:07',NULL),(824,7812,40825,4561,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',390000.96,NULL,NULL,1,'2024-03-16 08:46:18','2024-03-16 08:46:18',NULL),(825,7812,40825,4561,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',390000.96,NULL,NULL,1,'2024-03-16 08:47:04','2024-03-16 08:47:04',NULL),(826,7812,40825,4561,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',1233837.00,NULL,NULL,1,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(827,7812,40825,4561,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',1482.78,NULL,NULL,1,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(828,7812,40825,4561,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',1482782.40,NULL,NULL,1,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(829,7812,40825,4561,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',1482.78,NULL,NULL,1,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(830,7812,40825,4561,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',250000.00,NULL,NULL,1,'2024-03-16 08:54:49','2024-03-16 08:54:49',NULL);
INSERT INTO `balance_libro` VALUES (831,7812,40825,4561,3,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',200000.00,NULL,NULL,1,'2024-03-16 08:54:49','2024-03-16 08:54:49',NULL),(832,7812,40720,1564,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-11','2024-02-11',494841.60,NULL,NULL,1,'2024-03-16 10:11:45','2024-03-16 10:11:45',NULL),(833,7812,40720,1564,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',504424.80,NULL,NULL,1,'2024-03-16 10:11:45','2024-03-16 10:11:45',NULL),(834,7812,40720,1564,3,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',26500.00,NULL,NULL,1,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(835,7812,40720,1564,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',80999.99,NULL,NULL,1,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(836,7812,40720,1564,3,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',51596.22,NULL,NULL,1,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(837,7812,40825,4561,7,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',276570.00,NULL,NULL,1,'2024-03-19 19:56:27','2024-03-19 19:58:43','2024-03-19 19:58:43'),(838,7812,40825,4561,7,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',214137.00,NULL,NULL,1,'2024-03-19 19:57:06','2024-03-19 19:58:30','2024-03-19 19:58:30'),(839,7812,40825,4561,7,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',214137.00,NULL,NULL,1,'2024-03-19 19:58:30','2024-03-19 19:58:30',NULL),(840,7812,40825,4561,7,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',276570.00,NULL,NULL,1,'2024-03-19 19:58:43','2024-03-19 19:58:43',NULL),(841,7812,40720,1564,3,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-14','2024-01-14',80003.03,NULL,NULL,1,'2024-03-20 18:06:21','2024-03-20 18:06:21',NULL),(842,7812,40720,1564,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',88501.99,NULL,NULL,1,'2024-03-20 18:07:15','2024-03-20 18:07:15',NULL),(843,7812,40720,1564,3,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',100013.96,NULL,NULL,1,'2024-03-20 18:08:06','2024-03-20 18:08:06',NULL),(844,7812,40720,1564,3,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',90019.99,NULL,NULL,1,'2024-03-20 18:09:46','2024-03-20 18:09:46',NULL),(845,7812,40720,1564,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',47001.01,NULL,NULL,1,'2024-03-20 18:10:58','2024-03-20 18:10:58',NULL),(846,7812,40720,1564,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',43005.00,NULL,NULL,1,'2024-03-20 18:11:40','2024-03-20 18:11:40',NULL),(847,7812,40720,1564,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',100000.01,NULL,NULL,1,'2024-03-20 18:13:21','2024-03-20 18:13:21',NULL),(848,7812,40720,1564,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',70003.99,NULL,NULL,1,'2024-03-20 18:14:22','2024-03-20 18:14:22',NULL),(849,7812,40825,4562,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',1856309.40,NULL,NULL,1,'2024-05-13 17:43:01','2024-05-13 17:43:01',NULL),(850,7812,40825,4562,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',1852824.60,NULL,NULL,1,'2024-05-13 17:43:01','2024-05-13 17:43:01',NULL),(851,7812,40825,4562,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',13999.99,NULL,NULL,1,'2024-05-13 17:43:12','2024-05-23 15:53:52','2024-05-23 15:53:52');
INSERT INTO `balance_libro` VALUES (852,7812,40825,4562,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',32780.00,NULL,NULL,1,'2024-05-13 17:43:12','2024-05-23 15:53:09','2024-05-23 15:53:09'),(853,7812,40825,4562,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',30327.60,NULL,NULL,1,'2024-05-13 17:43:13','2024-05-23 15:52:57','2024-05-23 15:52:57'),(854,7812,40825,4562,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',91800.04,NULL,NULL,1,'2024-05-13 17:43:13','2024-05-23 15:53:40','2024-05-23 15:53:40'),(855,7812,40825,4562,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',34499.99,NULL,NULL,1,'2024-05-13 17:43:13','2024-05-23 15:52:42','2024-05-23 15:52:42'),(856,7812,40825,4562,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',456003.18,NULL,NULL,1,'2024-05-13 17:59:06','2024-05-13 17:59:06',NULL),(857,7812,40825,4562,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',453102.43,NULL,NULL,1,'2024-05-13 18:00:18','2024-05-13 18:00:18',NULL),(858,7812,40825,4562,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-17','2024-03-17',50006.02,NULL,NULL,1,'2024-05-13 18:01:24','2024-05-13 18:01:24',NULL),(859,7812,40825,4562,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',50008.99,NULL,NULL,1,'2024-05-13 18:02:04','2024-05-13 18:02:04',NULL),(860,7812,40825,4562,3,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',49999.98,NULL,NULL,1,'2024-05-13 18:03:49','2024-05-13 18:03:49',NULL),(861,7812,40825,4562,3,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',50000.03,NULL,NULL,1,'2024-05-13 18:04:23','2024-05-13 18:04:23',NULL),(862,7812,40825,4562,3,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',50000.03,NULL,NULL,1,'2024-05-13 18:05:12','2024-05-13 18:05:12',NULL),(863,7812,40720,1564,15,1223,'App\\Models\\PeriodLiquidation',NULL,1223,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',236252.99,NULL,NULL,1,'2024-05-13 18:29:53','2024-05-13 18:29:53',NULL),(864,7812,40720,1565,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',742262.40,NULL,NULL,1,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(865,7812,40720,1565,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',247856.40,NULL,NULL,1,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(866,7812,40720,1565,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',124363.80,NULL,NULL,1,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(867,7812,40720,1565,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',51596.22,NULL,NULL,1,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(868,7812,40720,1565,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',46425.00,NULL,NULL,1,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(869,7812,40720,1565,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',49499.10,NULL,NULL,1,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(870,7812,40720,1565,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',93999.00,NULL,NULL,1,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(871,7812,40720,1565,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',275000.00,NULL,NULL,1,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL);
INSERT INTO `balance_libro` VALUES (872,7812,40720,1565,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',39500.00,NULL,NULL,1,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(873,7812,40825,4562,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',438004.80,NULL,NULL,1,'2024-05-14 17:19:29','2024-05-14 17:19:29',NULL),(874,7812,40825,4561,15,1207,'App\\Models\\PeriodLiquidation',NULL,1207,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1197139.36,NULL,NULL,1,'2024-05-14 17:29:34','2024-05-14 17:29:34',NULL),(875,7812,40825,4562,15,1247,'App\\Models\\PeriodLiquidation',NULL,1247,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1032619.04,NULL,NULL,1,'2024-05-23 15:41:27','2024-05-23 15:51:50','2024-05-23 15:51:50'),(876,7812,40825,4562,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',13999.99,NULL,NULL,1,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(877,7812,40825,4562,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',32780.00,NULL,NULL,1,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(878,7812,40825,4562,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',30327.60,NULL,NULL,1,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(879,7812,40825,4562,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',91800.04,NULL,NULL,1,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(880,7812,40825,4562,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',34499.99,NULL,NULL,1,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(881,7812,40825,4562,15,1259,'App\\Models\\PeriodLiquidation',NULL,1259,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1032619.04,NULL,NULL,1,'2024-05-23 15:58:46','2024-05-23 15:58:46',NULL),(882,7812,40825,4563,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',1220000.00,NULL,NULL,1,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(883,7812,40825,4563,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-07','2024-04-07',50008.84,NULL,NULL,1,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(884,7812,40825,4563,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',32900.00,NULL,NULL,1,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(885,7812,40825,4563,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',185000.00,NULL,NULL,1,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(886,7812,40825,4563,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',31500.00,NULL,NULL,1,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(887,7812,40825,4563,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',431837.40,NULL,NULL,1,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(888,7812,40825,4563,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',79002.00,NULL,NULL,1,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(889,7812,40825,4563,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',387300.01,NULL,NULL,1,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(890,7812,40825,4563,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',100477.41,NULL,NULL,1,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(891,7812,40825,4563,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',230016.97,NULL,NULL,1,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(892,7812,40825,4563,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',141900.00,NULL,NULL,1,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL);
INSERT INTO `balance_libro` VALUES (893,7812,40825,4563,15,1263,'App\\Models\\PeriodLiquidation',NULL,1263,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',787797.70,NULL,NULL,1,'2024-05-23 16:21:04','2024-05-23 16:21:04',NULL),(894,7812,40720,1565,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',16997.99,NULL,NULL,1,'2024-05-26 09:43:07','2024-05-26 09:43:07',NULL),(895,7812,40720,1565,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',60701.00,NULL,NULL,1,'2024-05-26 09:43:51','2024-05-26 09:43:51',NULL),(896,7812,40720,1565,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-24','2023-09-24',95015.01,NULL,NULL,1,'2024-05-26 09:45:11','2024-05-26 09:45:11',NULL),(897,7812,40720,1565,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',50000.00,NULL,NULL,1,'2024-05-26 09:46:15','2024-05-26 09:46:15',NULL),(898,7812,40720,1565,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',154081.01,NULL,NULL,1,'2024-05-26 09:49:08','2024-05-26 09:49:08',NULL),(899,7812,40720,1565,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',100013.96,NULL,NULL,1,'2024-05-26 09:50:23','2024-05-26 09:50:23',NULL),(900,7812,40720,1565,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',396312.05,NULL,NULL,1,'2024-05-26 09:51:08','2024-05-26 09:51:08',NULL),(901,7812,40720,1565,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',42006.04,NULL,NULL,1,'2024-05-26 09:52:13','2024-05-26 09:52:13',NULL),(902,7812,40720,1565,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',30004.98,NULL,NULL,1,'2024-05-26 09:53:22','2024-05-26 09:53:22',NULL),(903,7812,40720,1565,15,1281,'App\\Models\\PeriodLiquidation',NULL,1281,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',303072.79,NULL,NULL,1,'2024-05-26 10:04:51','2024-05-26 10:04:51',NULL),(904,7812,40720,1566,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',166500.00,NULL,NULL,1,'2024-05-26 10:11:54','2024-05-26 10:11:54',NULL),(905,7812,40720,1566,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-11','2024-02-11',14999.98,NULL,NULL,1,'2024-05-26 10:12:38','2024-05-26 10:12:38',NULL),(906,7812,40720,1566,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',100000.04,NULL,NULL,1,'2024-05-26 10:13:34','2024-05-26 10:13:34',NULL),(907,7812,40720,1566,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',20000.05,NULL,NULL,1,'2024-05-26 10:14:17','2024-05-26 10:14:17',NULL),(908,7812,40720,1566,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',185000.00,NULL,NULL,1,'2024-05-26 10:15:07','2024-05-26 10:15:07',NULL),(909,7812,40720,1566,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-18','2024-02-18',100000.04,NULL,NULL,1,'2024-05-26 10:15:58','2024-05-26 10:15:58',NULL),(910,7812,40720,1566,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',24999.98,NULL,NULL,1,'2024-05-26 10:16:53','2024-05-26 10:16:53',NULL),(911,7812,40720,1566,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',129999.96,NULL,NULL,1,'2024-05-26 10:17:35','2024-05-26 10:17:35',NULL),(912,7812,40720,1566,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',125033.06,NULL,NULL,1,'2024-05-26 10:18:22','2024-05-26 10:18:22',NULL),(913,7812,40720,1566,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',100016.97,NULL,NULL,1,'2024-05-26 10:19:02','2024-05-26 10:19:02',NULL);
INSERT INTO `balance_libro` VALUES (914,7812,40720,1566,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-25','2024-02-25',130007.95,NULL,NULL,1,'2024-05-26 10:19:47','2024-05-26 10:19:47',NULL),(915,7812,40720,1566,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-25','2024-02-25',43000.05,NULL,NULL,1,'2024-05-26 10:20:24','2024-05-26 10:20:24',NULL),(916,7812,40720,1566,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',46603.98,NULL,NULL,1,'2024-05-26 10:21:31','2024-05-26 10:21:31',NULL),(917,7812,40720,1566,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',43815.00,NULL,NULL,1,'2024-05-26 10:22:11','2024-05-26 10:22:11',NULL),(918,7812,40720,1566,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',285004.04,NULL,NULL,1,'2024-05-26 10:23:05','2024-05-26 10:23:05',NULL),(919,7812,40720,1566,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',300000.04,NULL,NULL,1,'2024-05-26 10:26:19','2024-05-26 10:26:19',NULL),(920,7812,40720,1566,15,1313,'App\\Models\\PeriodLiquidation',NULL,1313,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',403446.44,NULL,NULL,1,'2024-05-26 11:00:06','2024-05-26 11:00:06',NULL),(921,7812,40825,4564,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',29999.95,NULL,NULL,1,'2024-06-18 16:46:27','2024-06-18 16:46:27',NULL),(922,7812,40825,4564,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',87003.99,NULL,NULL,1,'2024-06-18 16:47:05','2024-06-18 16:47:05',NULL),(923,7812,40825,4564,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',19999.96,NULL,NULL,1,'2024-06-18 16:47:55','2024-06-18 16:47:55',NULL),(924,7812,40825,4564,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',49999.89,NULL,NULL,1,'2024-06-18 16:49:33','2024-06-18 16:49:33',NULL),(925,7812,40825,4564,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-05','2024-05-05',85046.05,NULL,NULL,1,'2024-06-18 16:52:25','2024-06-18 16:52:25',NULL),(926,7812,40825,4564,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',300000.00,NULL,NULL,1,'2024-06-18 16:54:26','2024-06-18 16:54:26',NULL),(927,7812,40825,4564,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',199999.99,NULL,NULL,1,'2024-06-18 16:55:02','2024-06-18 16:55:02',NULL),(928,7812,40825,4564,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',656875.10,NULL,NULL,1,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(929,7812,40825,4564,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',654826.20,NULL,NULL,1,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(930,7812,40825,4564,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',678593.36,NULL,NULL,1,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(931,7812,40825,4564,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',612742.40,NULL,NULL,1,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(932,7812,40825,4564,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',626122.78,NULL,NULL,1,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(933,7812,40825,4564,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',655244.77,NULL,NULL,1,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(934,7812,40825,4564,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',1153952.80,NULL,NULL,1,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL);
INSERT INTO `balance_libro` VALUES (935,7812,40720,1567,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',786969.72,NULL,NULL,1,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(936,7812,40720,1567,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',804012.38,NULL,NULL,1,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(937,7812,40720,1567,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',828573.85,NULL,NULL,1,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(938,7812,40720,1567,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',795491.05,NULL,NULL,1,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(939,7812,40720,1567,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',767922.05,NULL,NULL,1,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(940,7812,40720,1567,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',1154291.60,NULL,NULL,1,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(941,7812,40720,1567,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',246840.00,NULL,NULL,1,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(942,7812,40720,1567,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',121677.60,NULL,NULL,1,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(943,7812,40720,1567,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',902055.00,NULL,NULL,1,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(944,7812,40720,1567,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',31265.99,NULL,NULL,1,'2024-06-23 15:57:49','2024-07-09 10:15:10','2024-07-09 10:15:10'),(945,7812,40720,1567,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',54999.00,NULL,NULL,1,'2024-06-23 15:57:49','2024-07-09 10:15:34','2024-07-09 10:15:34'),(946,7812,40720,1567,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',66499.00,NULL,NULL,1,'2024-06-23 15:57:49','2024-07-09 10:15:51','2024-07-09 10:15:51'),(947,7812,40720,1567,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',19999.98,NULL,NULL,1,'2024-06-23 15:57:49','2024-07-09 10:16:26','2024-07-09 10:16:26'),(948,7812,40720,1567,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',32000.00,NULL,NULL,1,'2024-06-23 15:57:49','2024-07-09 10:16:48','2024-07-09 10:16:48'),(949,7812,40720,1567,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',120000.00,NULL,NULL,1,'2024-06-23 15:57:49','2024-07-09 10:17:05','2024-07-09 10:17:05'),(950,7812,40720,1567,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',46425.00,NULL,NULL,1,'2024-06-23 15:57:50','2024-07-09 10:17:19','2024-07-09 10:17:19'),(951,7812,40720,1567,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',89043.03,NULL,NULL,1,'2024-06-23 16:06:12','2024-06-23 16:06:12',NULL),(952,7812,40720,1567,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',179772.97,NULL,NULL,1,'2024-06-23 16:06:55','2024-06-23 16:06:55',NULL),(953,7812,40720,1567,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',26008.03,NULL,NULL,1,'2024-06-23 16:07:46','2024-06-23 16:07:46',NULL),(954,7812,40720,1567,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',35020.00,NULL,NULL,1,'2024-06-23 16:08:47','2024-06-23 16:08:47',NULL);
INSERT INTO `balance_libro` VALUES (955,7812,40720,1567,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-03','2024-03-03',40000.03,NULL,NULL,1,'2024-06-23 16:09:43','2024-06-23 16:09:43',NULL),(956,7812,40720,1567,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',215006.94,NULL,NULL,1,'2024-06-23 16:10:50','2024-06-23 16:10:50',NULL),(957,7812,40720,1567,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',149250.00,NULL,NULL,1,'2024-06-23 16:12:18','2024-06-23 16:12:18',NULL),(958,7812,40720,1567,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',31009.01,NULL,NULL,1,'2024-06-23 16:13:06','2024-06-23 16:13:06',NULL),(959,7812,40720,1567,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',99999.97,NULL,NULL,1,'2024-06-23 16:13:58','2024-06-23 16:13:58',NULL),(960,7812,40720,1567,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',100000.03,NULL,NULL,1,'2024-06-23 16:14:43','2024-06-23 16:14:43',NULL),(961,7812,40720,1567,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',54610.01,NULL,NULL,1,'2024-06-23 16:15:58','2024-06-23 16:15:58',NULL),(962,7812,40720,1567,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-10','2024-03-10',110051.05,NULL,NULL,1,'2024-06-23 16:16:46','2024-06-23 16:16:46',NULL),(963,7812,40720,1567,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',10000.02,NULL,NULL,1,'2024-06-23 16:19:09','2024-06-23 16:19:09',NULL),(964,7812,40720,1567,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',100008.07,NULL,NULL,1,'2024-06-23 16:20:27','2024-06-23 16:20:27',NULL),(965,7812,40720,1567,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-17','2024-03-17',124630.97,NULL,NULL,1,'2024-06-23 16:21:16','2024-06-23 16:21:16',NULL),(966,7812,40720,1567,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',14999.96,NULL,NULL,1,'2024-06-23 16:22:01','2024-06-23 16:22:01',NULL),(967,7812,40720,1567,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-24','2024-03-24',94060.03,NULL,NULL,1,'2024-06-23 16:22:46','2024-06-23 16:22:46',NULL),(968,7812,40720,1567,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',99999.99,NULL,NULL,1,'2024-06-23 16:26:24','2024-06-23 16:26:24',NULL),(969,7812,40720,1567,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',150000.05,NULL,NULL,1,'2024-06-23 16:30:19','2024-06-23 16:30:19',NULL),(970,7812,40720,1567,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',99999.97,NULL,NULL,1,'2024-06-23 16:31:25','2024-06-23 16:31:25',NULL),(971,7812,40720,1567,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',11000.00,NULL,NULL,1,'2024-06-23 16:32:55','2024-06-23 16:32:55',NULL),(972,7812,40720,1567,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',18800.00,NULL,NULL,1,'2024-06-23 16:33:49','2024-06-23 16:33:49',NULL),(973,7812,40720,1567,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',20002.00,NULL,NULL,1,'2024-06-23 16:36:22','2024-07-09 10:51:35','2024-07-09 10:51:35'),(974,7812,40720,1567,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',6999.96,NULL,NULL,1,'2024-06-23 16:37:00','2024-07-09 10:51:26','2024-07-09 10:51:26'),(975,7812,40720,1567,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',23999.97,NULL,NULL,1,'2024-06-23 16:37:39','2024-07-09 10:51:17','2024-07-09 10:51:17');
INSERT INTO `balance_libro` VALUES (976,7812,40720,1567,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',37999.98,NULL,NULL,1,'2024-06-23 16:38:21','2024-07-09 10:51:08','2024-07-09 10:51:08'),(977,7812,40720,1567,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',100000.04,NULL,NULL,1,'2024-06-23 16:38:59','2024-07-09 10:50:54','2024-07-09 10:50:54'),(978,7812,40720,1567,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',120005.04,NULL,NULL,1,'2024-06-23 16:39:42','2024-07-09 10:50:41','2024-07-09 10:50:41'),(979,7812,40720,1567,2,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',37000.03,NULL,NULL,1,'2024-06-23 16:41:44','2024-07-09 10:50:29','2024-07-09 10:50:29'),(980,7812,40720,1567,2,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',9999.98,NULL,NULL,1,'2024-06-23 16:42:50','2024-07-09 10:50:12','2024-07-09 10:50:12'),(981,7812,40720,1567,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',22000.01,NULL,NULL,1,'2024-06-30 19:09:48','2024-06-30 19:09:48',NULL),(982,7812,40720,1567,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',140019.01,NULL,NULL,1,'2024-06-30 19:10:51','2024-06-30 19:10:51',NULL),(983,7812,40720,1567,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',10000.00,NULL,NULL,1,'2024-06-30 19:11:44','2024-06-30 19:11:44',NULL),(984,7812,40720,1567,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',30012.98,NULL,NULL,1,'2024-06-30 19:12:23','2024-06-30 19:12:23',NULL),(985,7812,40720,1567,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',120055.02,NULL,NULL,1,'2024-06-30 19:13:03','2024-06-30 19:13:03',NULL),(986,7812,40720,1567,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',251036.05,NULL,NULL,1,'2024-06-30 19:13:37','2024-06-30 19:13:37',NULL),(987,7812,40720,1567,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',30000.01,NULL,NULL,1,'2024-06-30 19:14:21','2024-06-30 19:14:21',NULL),(988,7812,40720,1567,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',129865.06,NULL,NULL,1,'2024-06-30 19:15:14','2024-06-30 19:15:14',NULL),(989,7812,40720,1567,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',14500.01,NULL,NULL,1,'2024-06-30 19:16:09','2024-06-30 19:16:09',NULL),(990,7812,40720,1567,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',32008.98,NULL,NULL,1,'2024-06-30 19:19:06','2024-06-30 19:19:06',NULL),(991,7812,40720,1567,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',220016.01,NULL,NULL,1,'2024-06-30 19:19:45','2024-06-30 19:19:45',NULL),(992,7812,40720,1567,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',14999.96,NULL,NULL,1,'2024-06-30 19:20:39','2024-06-30 19:20:39',NULL),(993,7812,40720,1567,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',10000.04,NULL,NULL,1,'2024-06-30 19:21:46','2024-06-30 19:21:46',NULL),(994,7812,40720,1567,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',230216.01,NULL,NULL,1,'2024-06-30 19:22:35','2024-06-30 19:22:35',NULL),(995,7812,40720,1567,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',19999.98,NULL,NULL,1,'2024-06-30 19:23:21','2024-06-30 19:23:21',NULL);
INSERT INTO `balance_libro` VALUES (996,7812,40720,1567,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',45000.04,NULL,NULL,1,'2024-06-30 19:24:30','2024-06-30 19:24:30',NULL),(997,7812,40720,1567,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-26','2024-05-26',120000.04,NULL,NULL,1,'2024-06-30 19:25:12','2024-06-30 19:25:12',NULL),(998,7812,40720,1567,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',120045.99,NULL,NULL,1,'2024-06-30 19:25:47','2024-06-30 19:25:47',NULL),(999,7812,40720,1567,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',13101.05,NULL,NULL,1,'2024-06-30 19:26:30','2024-06-30 19:26:30',NULL),(1000,7812,40720,1567,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',39999.99,NULL,NULL,1,'2024-06-30 19:27:15','2024-06-30 19:27:15',NULL),(1001,7812,40720,1567,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',43011.03,NULL,NULL,1,'2024-06-30 19:28:02','2024-06-30 19:28:02',NULL),(1002,7812,40720,1567,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',55008.03,NULL,NULL,1,'2024-06-30 19:28:46','2024-06-30 19:28:46',NULL),(1003,7812,40720,1567,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',107008.94,NULL,NULL,1,'2024-06-30 19:30:05','2024-06-30 19:30:05',NULL),(1004,7812,40720,1567,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',29999.96,NULL,NULL,1,'2024-06-30 19:30:48','2024-06-30 19:30:48',NULL),(1005,7812,40720,1567,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',126508.98,NULL,NULL,1,'2024-06-30 19:31:36','2024-06-30 19:31:36',NULL),(1006,7812,40720,1567,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-05','2024-05-05',143808.04,NULL,NULL,1,'2024-06-30 19:32:24','2024-06-30 19:32:24',NULL),(1007,7812,40720,1567,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-04','2024-05-04',100048.96,NULL,NULL,1,'2024-06-30 19:33:15','2024-06-30 19:33:15',NULL),(1008,7812,40720,1567,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',41012.03,NULL,NULL,1,'2024-06-30 19:34:06','2024-06-30 19:34:06',NULL),(1009,7812,40720,1567,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',200007.96,NULL,NULL,1,'2024-06-30 19:34:45','2024-06-30 19:34:45',NULL),(1010,7812,40720,1567,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',150000.00,NULL,NULL,1,'2024-06-30 19:35:33','2024-06-30 19:35:33',NULL),(1011,7812,40720,1567,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-05','2024-05-05',300000.00,NULL,NULL,1,'2024-06-30 19:36:37','2024-06-30 19:36:37',NULL),(1012,7812,40720,1567,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',99999.96,NULL,NULL,1,'2024-06-30 19:37:34','2024-06-30 19:37:34',NULL),(1013,7812,40720,1567,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',9450.20,NULL,NULL,1,'2024-06-30 19:38:49','2024-06-30 19:38:49',NULL),(1014,7812,40720,1567,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',190550.03,NULL,NULL,1,'2024-06-30 19:39:28','2024-06-30 19:39:28',NULL),(1015,7812,40825,4564,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',360002.70,NULL,NULL,1,'2024-07-06 09:24:17','2024-07-06 09:24:17',NULL),(1016,7812,40825,4564,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',390003.73,NULL,NULL,1,'2024-07-06 09:26:12','2024-07-06 09:26:12',NULL);
INSERT INTO `balance_libro` VALUES (1017,7812,40825,4564,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',300000.00,NULL,NULL,1,'2024-07-06 09:30:10','2024-07-06 09:30:10',NULL),(1018,7812,40825,4564,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',355366.97,NULL,NULL,1,'2024-07-06 09:33:37','2024-07-06 09:33:37',NULL),(1019,7812,40825,4564,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-25','2024-05-25',184020.00,NULL,NULL,1,'2024-07-06 09:37:49','2024-07-06 09:37:49',NULL),(1020,7812,40825,4564,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',300000.00,NULL,NULL,1,'2024-07-06 09:40:08','2024-07-06 09:40:08',NULL),(1021,7812,40825,4564,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',300000.00,NULL,NULL,1,'2024-07-06 09:43:13','2024-07-06 09:43:13',NULL),(1022,7812,40825,4564,15,1479,'App\\Models\\PeriodLiquidation',NULL,1479,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1273754.42,NULL,NULL,1,'2024-07-09 10:11:33','2024-07-09 10:11:33',NULL),(1023,7812,40720,1567,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',31265.99,NULL,NULL,1,'2024-07-09 10:26:15','2024-07-09 11:06:12','2024-07-09 11:06:12'),(1024,7812,40720,1567,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',54999.00,NULL,NULL,1,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(1025,7812,40720,1567,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',66499.00,NULL,NULL,1,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(1026,7812,40720,1567,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',19999.98,NULL,NULL,1,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(1027,7812,40720,1567,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',32000.00,NULL,NULL,1,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(1028,7812,40720,1567,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',120000.00,NULL,NULL,1,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(1029,7812,40720,1567,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',46425.00,NULL,NULL,1,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(1030,7812,40720,1567,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',31265.98,NULL,NULL,1,'2024-07-09 11:06:12','2024-07-09 11:07:33','2024-07-09 11:07:33'),(1031,7812,40720,1567,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',31265.98,NULL,NULL,1,'2024-07-09 11:07:33','2024-07-09 11:07:33',NULL),(1032,7812,40720,1567,15,1515,'App\\Models\\PeriodLiquidation',NULL,1515,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1234395.50,NULL,NULL,1,'2024-07-09 11:17:44','2024-07-09 11:17:44',NULL),(1033,7812,40720,1568,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',689692.64,NULL,NULL,1,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(1034,7812,40720,1568,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',804012.38,NULL,NULL,1,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(1035,7812,40720,1568,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',804012.38,NULL,NULL,1,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(1036,7812,40720,1568,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',1020465.60,NULL,NULL,1,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL);
INSERT INTO `balance_libro` VALUES (1037,7812,40720,1568,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',1026685.00,NULL,NULL,1,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(1038,7812,40720,1568,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',54999.00,NULL,NULL,1,'2024-07-22 17:28:00','2024-07-22 17:59:57','2024-07-22 17:59:57'),(1039,7812,40720,1568,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',20900.00,NULL,NULL,1,'2024-07-22 17:28:00','2024-07-22 17:28:00',NULL),(1040,7812,40720,1568,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',76490.00,NULL,NULL,1,'2024-07-22 17:28:00','2024-07-22 17:59:40','2024-07-22 17:59:40'),(1041,7812,40720,1568,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',92009.61,NULL,NULL,1,'2024-07-22 17:28:00','2024-07-22 17:28:00',NULL),(1042,7812,40720,1568,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',10000.01,NULL,NULL,1,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(1043,7812,40720,1568,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',229800.01,NULL,NULL,1,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(1044,7812,40720,1568,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',1815000.00,NULL,NULL,1,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(1045,7812,40720,1568,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',229800.01,NULL,NULL,1,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(1046,7812,40720,1568,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',310600.01,NULL,NULL,1,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(1047,7812,40720,1568,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-20','2024-06-20',13800.00,NULL,NULL,1,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(1048,7812,40720,1568,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',30800.01,NULL,NULL,1,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(1049,7812,40720,1568,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',88600.00,NULL,NULL,1,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(1050,7812,40720,1568,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',88600.00,NULL,NULL,1,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(1051,7812,40720,1568,15,1523,'App\\Models\\PeriodLiquidation',NULL,1523,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',793058.26,NULL,NULL,1,'2024-07-22 18:08:51','2024-07-22 18:08:51',NULL),(1052,7812,40825,4565,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-02','2024-06-02',145007.55,NULL,NULL,1,'2024-07-26 19:00:24','2024-07-26 19:00:24',NULL),(1053,7812,40825,4565,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',360004.93,NULL,NULL,1,'2024-07-26 19:01:13','2024-07-26 19:01:13',NULL),(1054,7812,40825,4565,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',235006.87,NULL,NULL,1,'2024-07-26 19:02:01','2024-07-26 19:02:01',NULL),(1055,7812,40825,4565,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',227498.49,NULL,NULL,1,'2024-07-26 19:02:38','2024-07-26 19:02:38',NULL),(1056,7812,40825,4565,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',9980.00,NULL,NULL,1,'2024-07-26 19:03:25','2024-07-26 19:03:25',NULL),(1057,7812,40825,4565,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',388053.60,NULL,NULL,1,'2024-07-26 19:04:17','2024-07-26 19:04:17',NULL);
INSERT INTO `balance_libro` VALUES (1058,7812,40825,4565,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-20','2024-06-20',199999.97,NULL,NULL,1,'2024-07-26 19:05:49','2024-07-26 19:05:49',NULL),(1059,7812,40825,4565,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',276002.97,NULL,NULL,1,'2024-07-26 19:06:39','2024-07-26 19:06:39',NULL),(1060,7812,40825,4565,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-09','2024-06-09',315973.05,NULL,NULL,1,'2024-07-26 19:07:22','2024-07-26 19:07:22',NULL),(1061,7812,40825,4565,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',100000.00,NULL,NULL,1,'2024-07-26 19:08:05','2024-07-26 19:08:05',NULL),(1062,7812,40825,4565,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',299999.97,NULL,NULL,1,'2024-07-26 19:08:43','2024-07-26 19:08:43',NULL),(1063,7812,40825,4565,2,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',2056092.50,NULL,NULL,1,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(1064,7812,40825,4565,2,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-09','2024-06-09',698557.59,NULL,NULL,1,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(1065,7812,40825,4565,2,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',2306550.40,NULL,NULL,1,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(1066,7812,40825,4565,2,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',1028500.00,NULL,NULL,1,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(1067,7812,40825,4565,2,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',1028500.00,NULL,NULL,1,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(1068,7812,40825,4565,2,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',923230.00,NULL,NULL,1,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(1069,7812,40825,4565,2,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',1029710.00,NULL,NULL,1,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(1070,7812,40825,4565,2,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',1035155.00,NULL,NULL,1,'2024-07-26 19:13:40','2024-07-26 19:13:40',NULL),(1071,7812,40825,4565,2,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',759653.54,NULL,NULL,1,'2024-07-26 19:13:40','2024-07-26 19:13:40',NULL),(1072,7812,40825,4565,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',411004.02,NULL,NULL,1,'2024-08-03 16:00:52','2024-08-03 16:00:52',NULL),(1073,7812,40825,4565,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',303001.99,NULL,NULL,1,'2024-08-03 16:02:05','2024-08-03 16:02:05',NULL),(1074,7812,40825,4566,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',416010.00,NULL,NULL,1,'2024-08-03 16:03:22','2024-09-14 17:25:13','2024-09-14 17:25:13'),(1075,7812,40825,4566,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',400000.01,NULL,NULL,1,'2024-08-03 16:04:12','2024-09-14 17:25:38','2024-09-14 17:25:38'),(1076,7812,40825,4565,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',257003.35,NULL,NULL,1,'2024-08-03 16:05:45','2024-08-03 16:05:45',NULL),(1077,7812,40825,4566,2,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',1043322.50,NULL,NULL,1,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(1078,7812,40825,4566,2,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-09','2024-07-09',1092775.20,NULL,NULL,1,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL);
INSERT INTO `balance_libro` VALUES (1079,7812,40825,4566,2,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',1322549.89,NULL,NULL,1,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(1080,7812,40825,4566,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',300000.01,NULL,NULL,1,'2024-08-03 16:17:59','2024-09-14 17:25:29','2024-09-14 17:25:29'),(1081,7812,40825,4566,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',64400.00,NULL,NULL,1,'2024-08-03 16:17:59','2024-09-14 17:25:21','2024-09-14 17:25:21'),(1082,7812,40825,4566,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',223713.62,NULL,NULL,1,'2024-08-03 16:17:59','2024-09-14 17:24:57','2024-09-14 17:24:57'),(1083,7812,40720,1569,2,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',791982.27,NULL,NULL,1,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(1084,7812,40720,1569,2,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',1020937.50,NULL,NULL,1,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(1085,7812,40720,1569,2,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',691238.39,NULL,NULL,1,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(1086,7812,40720,1569,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',1147854.40,NULL,NULL,1,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(1087,7812,40720,1569,2,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',621591.71,NULL,NULL,1,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(1088,7812,40720,1569,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',805516.14,NULL,NULL,1,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(1089,7812,40720,1569,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',798999.83,NULL,NULL,1,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(1090,7812,40720,1569,2,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',804513.63,NULL,NULL,1,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(1091,7812,40720,1569,2,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',818548.76,NULL,NULL,1,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(1092,7812,40720,1569,2,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',811531.20,NULL,NULL,1,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(1093,7812,40720,1569,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',17100.00,NULL,NULL,1,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(1094,7812,40720,1569,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',44501.49,NULL,NULL,1,'2024-08-21 18:14:34','2024-09-02 17:35:42','2024-09-02 17:35:42'),(1095,7812,40720,1569,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',288000.00,NULL,NULL,1,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(1096,7812,40720,1569,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',102100.01,NULL,NULL,1,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(1097,7812,40720,1569,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',101619.22,NULL,NULL,1,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(1098,7812,40720,1569,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-21','2024-07-21',386750.00,NULL,NULL,1,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL);
INSERT INTO `balance_libro` VALUES (1099,7812,40720,1569,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-21','2024-07-21',5525.00,NULL,NULL,1,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(1100,7812,40720,1569,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',580125.00,NULL,NULL,1,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(1101,7812,40720,1569,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',4972.50,NULL,NULL,1,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(1102,7812,40720,1569,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',680000.00,NULL,NULL,1,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(1103,7812,40720,1569,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-28','2024-07-28',464100.00,NULL,NULL,1,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(1104,7812,40720,1569,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',42600.00,NULL,NULL,1,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(1105,7812,40720,1569,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',199999.97,NULL,NULL,1,'2024-09-01 18:51:36','2024-09-01 18:55:28','2024-09-01 18:55:28'),(1106,7812,40720,1569,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',317007.98,NULL,NULL,1,'2024-09-01 18:57:57','2024-09-01 18:57:57',NULL),(1107,7812,40720,1569,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-20','2024-06-20',451067.07,NULL,NULL,1,'2024-09-01 18:58:52','2024-09-01 18:58:52',NULL),(1108,7812,40720,1569,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',71076.95,NULL,NULL,1,'2024-09-01 19:00:15','2024-09-01 19:00:15',NULL),(1109,7812,40720,1569,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',100017.02,NULL,NULL,1,'2024-09-01 19:01:07','2024-09-01 19:01:07',NULL),(1110,7812,40720,1569,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-12','2024-05-12',140079.96,NULL,NULL,1,'2024-09-01 19:02:19','2024-09-01 19:02:19',NULL),(1111,7812,40720,1569,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',105010.99,NULL,NULL,1,'2024-09-01 19:03:04','2024-09-01 19:03:04',NULL),(1112,7812,40720,1569,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',120710.97,NULL,NULL,1,'2024-09-01 19:03:42','2024-09-01 19:03:42',NULL),(1113,7812,40720,1569,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',120000.03,NULL,NULL,1,'2024-09-01 19:04:19','2024-09-01 19:04:19',NULL),(1114,7812,40720,1569,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',390549.96,NULL,NULL,1,'2024-09-01 19:13:07','2024-09-01 19:13:07',NULL),(1115,7812,40720,1569,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',400000.01,NULL,NULL,1,'2024-09-01 19:13:46','2024-09-01 19:14:25','2024-09-01 19:14:25'),(1116,7812,40720,1569,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',400000.01,NULL,NULL,1,'2024-09-01 19:14:25','2024-09-01 19:14:25',NULL),(1117,7812,40720,1569,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',199999.95,NULL,NULL,1,'2024-09-01 19:15:51','2024-09-01 19:15:51',NULL),(1118,7812,40720,1569,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',40000.00,NULL,NULL,1,'2024-09-01 19:17:32','2024-09-01 19:17:32',NULL);
INSERT INTO `balance_libro` VALUES (1119,7812,40720,1569,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-21','2024-07-21',15000.02,NULL,NULL,1,'2024-09-01 19:18:26','2024-09-01 19:18:26',NULL),(1120,7812,40720,1569,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',35012.02,NULL,NULL,1,'2024-09-01 19:19:06','2024-09-01 19:19:06',NULL),(1121,7812,40720,1569,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',40000.01,NULL,NULL,1,'2024-09-01 19:20:20','2024-09-01 19:20:20',NULL),(1122,7812,40720,1569,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',200000.07,NULL,NULL,1,'2024-09-01 19:21:31','2024-09-01 19:21:31',NULL),(1123,7812,40720,1569,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-21','2024-07-21',120062.98,NULL,NULL,1,'2024-09-01 19:22:25','2024-09-01 19:22:25',NULL),(1124,7812,40720,1569,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',150005.06,NULL,NULL,1,'2024-09-01 19:23:16','2024-09-01 19:23:16',NULL),(1125,7812,40720,1569,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',20000.03,NULL,NULL,1,'2024-09-01 19:24:25','2024-09-01 19:24:25',NULL),(1126,7812,40720,1569,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',39999.95,NULL,NULL,1,'2024-09-01 19:25:32','2024-09-01 19:25:32',NULL),(1127,7812,40720,1569,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',139999.99,NULL,NULL,1,'2024-09-01 19:26:31','2024-09-01 19:26:31',NULL),(1128,7812,40720,1569,3,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',33000.04,NULL,NULL,1,'2024-09-01 19:28:02','2024-09-01 19:28:02',NULL),(1129,7812,40720,1569,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',113511.99,NULL,NULL,1,'2024-09-01 19:28:33','2024-09-01 19:28:33',NULL),(1130,7812,40720,1569,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',31007.98,NULL,NULL,1,'2024-09-01 19:29:06','2024-09-01 19:29:06',NULL),(1131,7812,40720,1569,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',49009.04,NULL,NULL,1,'2024-09-01 19:29:47','2024-09-01 19:29:47',NULL),(1132,7812,40720,1569,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',99000.00,NULL,NULL,1,'2024-09-01 19:31:17','2024-09-01 19:31:17',NULL),(1133,7812,40720,1569,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',67410.00,NULL,NULL,1,'2024-09-01 19:32:11','2024-09-01 19:32:11',NULL),(1134,7812,40720,1569,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',120019.96,NULL,NULL,1,'2024-09-02 16:46:19','2024-09-02 16:46:19',NULL),(1135,7812,40720,1569,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',130000.01,NULL,NULL,1,'2024-09-02 16:47:22','2024-09-02 16:47:22',NULL),(1136,7812,40720,1569,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',43838.96,NULL,NULL,1,'2024-09-02 16:48:05','2024-09-02 16:48:05',NULL),(1137,7812,40720,1569,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',40003.98,NULL,NULL,1,'2024-09-02 16:48:48','2024-09-02 16:48:48',NULL),(1138,7812,40720,1569,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',150008.01,NULL,NULL,1,'2024-09-02 16:49:39','2024-09-02 16:49:39',NULL),(1139,7812,40720,1569,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-14','2024-07-14',52002.95,NULL,NULL,1,'2024-09-02 16:50:15','2024-09-02 16:50:15',NULL);
INSERT INTO `balance_libro` VALUES (1140,7812,40720,1569,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',20021.04,NULL,NULL,1,'2024-09-02 16:51:11','2024-09-02 16:51:11',NULL),(1141,7812,40720,1569,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',15003.04,NULL,NULL,1,'2024-09-02 16:51:56','2024-09-02 16:51:56',NULL),(1142,7812,40720,1569,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',20005.96,NULL,NULL,1,'2024-09-02 16:53:22','2024-09-02 16:53:22',NULL),(1143,7812,40720,1569,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-28','2024-07-28',110051.01,NULL,NULL,1,'2024-09-02 16:54:09','2024-09-02 16:54:09',NULL),(1144,7812,40720,1569,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',457950.01,NULL,NULL,1,'2024-09-02 16:54:41','2024-09-02 16:54:41',NULL),(1145,7812,40720,1569,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',30000.05,NULL,NULL,1,'2024-09-02 16:55:22','2024-09-02 16:55:22',NULL),(1146,7812,40720,1569,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',262003.02,NULL,NULL,1,'2024-09-02 16:56:29','2024-09-02 16:56:29',NULL),(1147,7812,40720,1569,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',49999.98,NULL,NULL,1,'2024-09-02 16:57:38','2024-09-02 16:57:38',NULL),(1148,7812,40720,1569,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',300000.04,NULL,NULL,1,'2024-09-02 16:58:33','2024-09-02 16:58:33',NULL),(1149,7812,40720,1569,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',99999.98,NULL,NULL,1,'2024-09-02 16:59:09','2024-09-02 16:59:09',NULL),(1150,7812,40720,1569,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',199999.95,NULL,NULL,1,'2024-09-02 16:59:48','2024-09-02 16:59:48',NULL),(1151,7812,40720,1569,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',250000.04,NULL,NULL,1,'2024-09-02 17:02:59','2024-09-02 17:02:59',NULL),(1152,7812,40720,1569,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',9450.20,NULL,NULL,1,'2024-09-02 17:03:45','2024-09-02 17:03:45',NULL),(1153,7812,40720,1569,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',44501.49,NULL,NULL,1,'2024-09-02 17:35:42','2024-09-02 17:35:42',NULL),(1154,7812,40720,1569,15,1666,'App\\Models\\PeriodLiquidation',NULL,1666,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',1488049.33,NULL,NULL,1,'2024-09-02 18:00:25','2024-09-02 18:00:25',NULL),(1155,7812,40825,4565,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',347737.09,NULL,NULL,1,'2024-09-08 09:49:34','2024-09-08 10:13:29','2024-09-08 10:13:29'),(1156,7812,40825,4565,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',115912.40,NULL,NULL,1,'2024-09-08 09:49:34','2024-09-08 10:02:13','2024-09-08 10:02:13'),(1157,7812,40825,4565,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-09','2024-06-09',366251.83,NULL,NULL,1,'2024-09-08 09:49:34','2024-09-08 10:01:53','2024-09-08 10:01:53'),(1158,7812,40825,4565,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',476404.40,NULL,NULL,1,'2024-09-08 09:49:34','2024-09-08 10:11:23','2024-09-08 10:11:23'),(1159,7812,40825,4565,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',319921.57,NULL,NULL,1,'2024-09-08 09:49:34','2024-09-08 10:01:22','2024-09-08 10:01:22');
INSERT INTO `balance_libro` VALUES (1160,7812,40825,4565,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-20','2024-06-20',231824.65,NULL,NULL,1,'2024-09-08 09:49:34','2024-09-08 10:01:04','2024-09-08 10:01:04'),(1161,7812,40825,4566,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',268229.66,NULL,NULL,1,'2024-09-08 11:12:26','2024-09-08 11:12:26',NULL),(1162,7812,40825,4565,15,1680,'App\\Models\\PeriodLiquidation',NULL,1680,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',1707325.87,NULL,NULL,1,'2024-09-08 11:22:08','2024-09-08 11:22:08',NULL),(1163,7812,40825,4567,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-04','2024-08-04',30000.05,NULL,NULL,1,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(1164,7812,40825,4567,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',30000.01,NULL,NULL,1,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(1165,7812,40825,4567,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',30000.01,NULL,NULL,1,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(1166,7812,40825,4567,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-11','2024-08-11',78305.05,NULL,NULL,1,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(1167,7812,40825,4566,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',486674.92,NULL,NULL,1,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(1168,7812,40825,4566,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',300000.03,NULL,NULL,1,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(1169,7812,40825,4566,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',467945.35,NULL,NULL,1,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(1170,7812,40825,4566,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',223713.62,NULL,NULL,1,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(1171,7812,40825,4566,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',64400.00,NULL,NULL,1,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(1172,7812,40825,4566,15,1696,'App\\Models\\PeriodLiquidation',NULL,1696,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',600261.15,NULL,NULL,1,'2024-09-14 18:04:18','2024-09-14 18:04:18',NULL),(1173,7812,40825,4567,15,1684,'App\\Models\\PeriodLiquidation',NULL,1684,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',27083.12,NULL,NULL,1,'2024-09-14 18:06:27','2024-09-14 18:06:27',NULL),(1174,7812,40720,1570,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',386750.00,NULL,NULL,1,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(1175,7812,40720,1570,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',35441.34,NULL,NULL,1,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(1176,7812,40720,1570,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-04','2024-08-04',386750.00,NULL,NULL,1,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(1177,7812,40720,1570,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',773500.00,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(1178,7812,40720,1570,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',193375.00,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(1179,7812,40720,1570,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',13800.00,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL);
INSERT INTO `balance_libro` VALUES (1180,7812,40720,1570,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-11','2024-08-11',773500.00,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(1181,7812,40720,1570,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-13','2024-08-13',10000.04,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(1182,7812,40720,1570,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-13','2024-08-13',2160255.50,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(1183,7812,40720,1570,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',580125.00,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(1184,7812,40720,1570,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',773500.00,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(1185,7812,40720,1570,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-24','2024-08-24',21000.00,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(1186,7812,40720,1570,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-25','2024-08-25',386750.00,NULL,NULL,1,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(1187,7812,40720,1570,2,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',225896.74,NULL,NULL,1,'2024-09-26 16:27:00','2024-09-26 16:27:00',NULL),(1188,7812,40720,1570,2,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',705823.43,NULL,NULL,1,'2024-09-26 16:27:00','2024-09-26 16:27:00',NULL),(1189,7812,40720,1570,15,1700,'App\\Models\\PeriodLiquidation',NULL,1700,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',660682.84,NULL,NULL,1,'2024-09-26 16:35:12','2024-09-26 16:35:12',NULL),(1190,7812,40825,4568,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',30008.96,NULL,NULL,1,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(1191,7812,40825,4568,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-12','2024-09-12',160000.00,NULL,NULL,1,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(1192,7812,40825,4568,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-14','2024-09-14',8000.00,NULL,NULL,1,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(1193,7812,40825,4568,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',59000.00,NULL,NULL,1,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(1194,7812,40825,4568,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',201197.00,NULL,NULL,1,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(1195,7812,40825,4568,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',42998.99,NULL,NULL,1,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(1196,7812,40825,4568,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-21','2024-09-21',135166.80,NULL,NULL,1,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(1197,7812,40825,4568,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',344000.00,NULL,NULL,1,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(1198,7812,40825,4568,15,1702,'App\\Models\\PeriodLiquidation',NULL,1702,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',129614.33,NULL,NULL,1,'2024-10-14 17:21:27','2024-10-14 17:21:27',NULL),(1199,7812,40720,1571,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',580125.00,NULL,NULL,1,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL);
INSERT INTO `balance_libro` VALUES (1200,7812,40720,1571,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',6422.49,NULL,NULL,1,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(1201,7812,40720,1571,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',696150.00,NULL,NULL,1,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(1202,7812,40720,1571,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-29','2024-09-29',663000.00,NULL,NULL,1,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(1203,7812,40720,1571,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-08','2024-09-08',580125.00,NULL,NULL,1,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(1204,7812,40720,1571,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-08','2024-09-08',353310.07,NULL,NULL,1,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(1205,7812,40720,1571,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-12','2024-09-12',999.01,NULL,NULL,1,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(1206,7812,40720,1571,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-12','2024-09-12',580125.00,NULL,NULL,1,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(1207,7812,40720,1571,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-15','2024-09-15',309400.00,NULL,NULL,1,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(1208,7812,40720,1571,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',386750.00,NULL,NULL,1,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(1209,7812,40720,1571,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-22','2024-09-22',580125.00,NULL,NULL,1,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(1210,7812,40720,1571,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',828750.00,NULL,NULL,1,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(1211,7812,40720,1571,15,1704,'App\\Models\\PeriodLiquidation',NULL,1704,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',1042149.49,NULL,NULL,1,'2024-11-19 17:30:09','2024-11-19 17:30:09',NULL),(1212,7812,40720,1572,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',147500.06,NULL,NULL,1,'2024-11-19 17:32:55','2024-11-19 17:32:55',NULL),(1213,7812,40720,1572,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',552500.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1214,7812,40720,1572,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',47255.08,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1215,7812,40720,1572,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',552500.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1216,7812,40720,1572,3,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',828750.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1217,7812,40720,1572,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',47254.43,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1218,7812,40720,1572,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',950000.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1219,7812,40720,1572,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',29280.69,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1220,7812,40720,1572,3,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',58460.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL);
INSERT INTO `balance_libro` VALUES (1221,7812,40720,1572,3,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',64765.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1222,7812,40720,1572,3,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',18800.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1223,7812,40720,1572,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',47268.03,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1224,7812,40720,1572,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',552500.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1225,7812,40720,1572,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',1657500.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1226,7812,40720,1572,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',59068.70,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1227,7812,40720,1572,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',663000.00,NULL,NULL,1,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(1228,7812,40720,1572,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-22','2024-10-22',178000.00,NULL,NULL,1,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(1229,7812,40720,1572,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',146300.00,NULL,NULL,1,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(1230,7812,40720,1572,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-24','2024-10-24',442000.00,NULL,NULL,1,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(1231,7812,40720,1572,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-25','2024-10-25',42529.54,NULL,NULL,1,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(1232,7812,40720,1572,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-26','2024-10-26',3500.00,NULL,NULL,1,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(1233,7812,40720,1572,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-27','2024-10-27',552500.00,NULL,NULL,1,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(1234,7812,40720,1572,15,1706,'App\\Models\\PeriodLiquidation',NULL,1706,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',1890562.49,NULL,NULL,1,'2024-11-19 17:37:46','2024-11-19 17:37:46',NULL),(1235,7812,40825,4569,2,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',1063154.40,NULL,NULL,1,'2024-11-19 17:45:13','2024-11-19 17:45:13',NULL),(1236,7812,40825,4569,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',147680.43,NULL,NULL,1,'2024-11-19 17:46:32','2024-11-19 17:46:32',NULL),(1237,7812,40825,4569,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',59096.07,NULL,NULL,1,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(1238,7812,40825,4569,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',210000.00,NULL,NULL,1,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(1239,7812,40825,4569,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',142898.00,NULL,NULL,1,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(1240,7812,40825,4569,15,1712,'App\\Models\\PeriodLiquidation',NULL,1712,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',184514.40,NULL,NULL,1,'2025-02-03 17:41:06','2025-02-03 17:41:06',NULL);
INSERT INTO `balance_libro` VALUES (1241,7812,40825,4570,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',76000.00,NULL,NULL,1,'2025-02-03 17:43:38','2025-02-03 17:43:38',NULL),(1242,7812,40825,4571,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',192000.00,NULL,NULL,1,'2025-02-03 17:44:25','2025-02-03 17:44:25',NULL),(1243,7812,40825,4575,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',498799.99,NULL,NULL,1,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(1244,7812,40825,4575,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',218000.00,NULL,NULL,1,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(1245,7812,40825,4575,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',194300.00,NULL,NULL,1,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(1246,7812,40825,4575,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-13','2025-01-13',19999.99,NULL,NULL,1,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(1247,7812,40825,4575,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',218000.00,NULL,NULL,1,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(1248,7812,40825,4570,15,1714,'App\\Models\\PeriodLiquidation',NULL,1714,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',13190.08,NULL,NULL,1,'2025-02-03 17:46:53','2025-02-03 17:46:53',NULL),(1249,7812,40825,4571,15,1716,'App\\Models\\PeriodLiquidation',NULL,1716,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',46512.39,NULL,NULL,1,'2025-02-03 17:48:35','2025-02-03 17:48:35',NULL),(1250,7812,40825,4575,15,1718,'App\\Models\\PeriodLiquidation',NULL,1718,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',208108.25,NULL,NULL,1,'2025-02-03 17:55:10','2025-02-03 17:55:10',NULL),(1251,7812,40720,1573,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-02','2024-11-02',828750.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1252,7812,40720,1573,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',331500.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1253,7812,40720,1573,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-10','2024-11-10',331500.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1254,7812,40720,1573,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',331500.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1255,7812,40720,1573,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',14999.99,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1256,7812,40720,1573,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-14','2024-11-14',331500.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1257,7812,40720,1573,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-17','2024-11-17',331500.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1258,7812,40720,1573,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',120000.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1259,7812,40720,1573,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',331500.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1260,7812,40720,1573,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',54000.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL);
INSERT INTO `balance_libro` VALUES (1261,7812,40720,1573,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-24','2024-11-24',331500.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1262,7812,40720,1573,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',27900.00,NULL,NULL,1,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(1263,7812,40720,1574,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',331500.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1264,7812,40720,1574,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',12000.01,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1265,7812,40720,1574,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',331500.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1266,7812,40720,1574,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',331500.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1267,7812,40720,1574,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',60000.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1268,7812,40720,1574,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',40000.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1269,7812,40720,1574,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-09','2024-12-09',331500.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1270,7812,40720,1574,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-09','2024-12-09',250600.01,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1271,7812,40720,1574,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-10','2024-12-10',1452000.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1272,7812,40720,1574,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',39893.77,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1273,7812,40720,1574,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',331500.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1274,7812,40720,1574,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-15','2024-12-15',331500.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1275,7812,40720,1574,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',331500.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1276,7812,40720,1574,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-22','2024-12-22',331500.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1277,7812,40720,1574,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',331500.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1278,7812,40720,1574,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',0.00,NULL,NULL,1,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(1279,7812,40720,1578,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',331500.00,NULL,NULL,1,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(1280,7812,40720,1578,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',70029.94,NULL,NULL,1,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(1281,7812,40720,1578,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',10899.99,NULL,NULL,1,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL);
INSERT INTO `balance_libro` VALUES (1282,7812,40720,1578,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-05','2025-01-05',331500.00,NULL,NULL,1,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(1283,7812,40720,1578,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-08','2025-01-08',46926.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1284,7812,40720,1578,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-09','2025-01-09',331500.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1285,7812,40720,1578,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-12','2025-01-12',331500.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1286,7812,40720,1578,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',331500.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1287,7812,40720,1578,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-19','2025-01-19',331500.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1288,7812,40720,1578,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',95599.99,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1289,7812,40720,1578,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',268800.72,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1290,7812,40720,1578,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',238034.78,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1291,7812,40720,1578,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',246497.33,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1292,7812,40720,1578,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',246497.33,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1293,7812,40720,1578,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-23','2025-01-23',331500.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1294,7812,40720,1578,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',14000.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1295,7812,40720,1578,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',73615.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1296,7812,40720,1578,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',74985.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1297,7812,40720,1578,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-30','2025-01-30',497250.00,NULL,NULL,1,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(1298,7812,40720,1573,15,1720,'App\\Models\\PeriodLiquidation',NULL,1720,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',2222614.14,NULL,NULL,1,'2025-02-16 10:22:15','2025-02-16 10:22:15',NULL),(1299,7812,40720,1574,15,1722,'App\\Models\\PeriodLiquidation',NULL,1722,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2694010.25,NULL,NULL,1,'2025-02-16 10:24:26','2025-02-16 10:24:26',NULL),(1300,7812,40720,1578,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-07','2025-01-07',25333.83,NULL,NULL,1,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(1301,7812,40720,1578,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',40092.44,NULL,NULL,1,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL);
INSERT INTO `balance_libro` VALUES (1302,7812,40720,1578,15,1726,'App\\Models\\PeriodLiquidation',NULL,1726,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',3202692.59,NULL,NULL,1,'2025-02-16 10:35:48','2025-02-16 10:35:48',NULL),(1303,7812,40825,4576,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-08','2025-02-08',629500.04,NULL,NULL,1,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(1304,7812,40825,4576,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-10','2025-02-10',23000.00,NULL,NULL,1,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(1305,7812,40825,4576,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',5289.26,NULL,NULL,1,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(1306,7812,40825,4576,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',51834.70,NULL,NULL,1,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(1307,7812,40825,4576,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',31800.00,NULL,NULL,1,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(1308,7812,40825,4576,15,1728,'App\\Models\\PeriodLiquidation',NULL,1728,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',294416.52,NULL,NULL,1,'2025-04-02 19:35:34','2025-04-02 19:35:34',NULL),(1309,7812,40825,4577,15,1730,'App\\Models\\PeriodLiquidation',NULL,1730,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',294416.52,NULL,NULL,1,'2025-04-02 19:39:09','2025-04-02 19:39:09',NULL),(1310,7812,40825,4578,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-15','2025-04-15',166800.00,NULL,NULL,1,'2025-06-07 08:48:27','2025-06-07 08:48:27',NULL),(1311,7812,40825,4578,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-19','2025-04-19',360956.79,NULL,NULL,1,'2025-06-07 08:48:27','2025-06-07 08:48:27',NULL),(1312,7812,40825,4580,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-09','2025-05-09',525000.00,NULL,NULL,1,'2025-06-07 08:53:33','2025-06-07 09:06:37','2025-06-07 09:06:37'),(1313,7812,40825,4580,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-09','2025-05-09',29000.00,NULL,NULL,1,'2025-06-07 08:53:33','2025-06-07 09:06:37','2025-06-07 09:06:37'),(1314,7812,40825,4580,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-10','2025-05-10',100000.00,NULL,NULL,1,'2025-06-07 08:53:33','2025-06-07 09:06:24','2025-06-07 09:06:24'),(1315,7812,40825,4578,15,1731,'App\\Models\\PeriodLiquidation',NULL,1731,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',323365.28,NULL,NULL,1,'2025-06-07 08:57:19','2025-06-07 08:57:19',NULL),(1316,7812,40825,4580,15,1733,'App\\Models\\PeriodLiquidation',NULL,1733,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',112205.08,NULL,NULL,1,'2025-06-07 08:57:42','2025-06-07 08:57:55','2025-06-07 08:57:55'),(1317,7812,40825,4579,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-09','2025-05-09',525000.00,NULL,NULL,1,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(1318,7812,40825,4579,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-09','2025-05-09',29000.00,NULL,NULL,1,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(1319,7812,40825,4579,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-10','2025-05-10',100000.00,NULL,NULL,1,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(1320,7812,40825,4580,15,1751,'App\\Models\\PeriodLiquidation',NULL,1751,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',0.00,NULL,NULL,1,'2025-06-07 09:07:40','2025-06-07 09:07:46','2025-06-07 09:07:46'),(1321,7812,40825,4579,15,1753,'App\\Models\\PeriodLiquidation',NULL,1753,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',435570.36,NULL,NULL,1,'2025-06-07 09:10:07','2025-06-07 09:10:07',NULL);
INSERT INTO `balance_libro` VALUES (1322,7812,40720,1579,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-02','2025-02-02',331500.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1323,7812,40720,1579,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',20332.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1324,7812,40720,1579,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',186557.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1325,7812,40720,1579,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-27','2025-02-27',331500.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1326,7812,40720,1579,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',497250.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1327,7812,40720,1579,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',22964.99,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1328,7812,40720,1579,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-08','2025-02-08',150000.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1329,7812,40720,1579,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-08','2025-02-08',22500.02,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1330,7812,40720,1579,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-09','2025-02-09',414375.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1331,7812,40720,1579,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',497250.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1332,7812,40720,1579,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',497250.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1333,7812,40720,1579,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-16','2025-02-16',97078.41,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1334,7812,40720,1579,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-17','2025-02-17',44000.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1335,7812,40720,1579,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-17','2025-02-17',11000.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1336,7812,40720,1579,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-19','2025-02-19',14000.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1337,7812,40720,1579,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',298350.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1338,7812,40720,1579,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-23','2025-02-23',265200.00,NULL,NULL,1,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(1339,7812,40720,1580,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-06','2025-03-06',331500.00,NULL,NULL,1,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(1340,7812,40720,1580,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-09','2025-03-09',331500.00,NULL,NULL,1,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(1341,7812,40720,1580,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',88000.04,NULL,NULL,1,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(1342,7812,40720,1580,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-30','2025-03-30',331500.00,NULL,NULL,1,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL);
INSERT INTO `balance_libro` VALUES (1343,7812,40720,1580,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',85499.10,NULL,NULL,1,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(1344,7812,40720,1580,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',497250.00,NULL,NULL,1,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(1345,7812,40720,1580,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-16','2025-03-16',331500.00,NULL,NULL,1,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(1346,7812,40720,1580,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',331500.00,NULL,NULL,1,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(1347,7812,40720,1580,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',331500.00,NULL,NULL,1,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(1348,7812,40720,1580,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',134315.71,NULL,NULL,1,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(1349,7812,40720,1580,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',331500.00,NULL,NULL,1,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(1350,7812,40720,1580,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',27500.00,NULL,NULL,1,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(1351,7812,40720,1581,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-15','2025-04-15',789109.87,NULL,NULL,1,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(1352,7812,40720,1581,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-15','2025-04-15',904962.87,NULL,NULL,1,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(1353,7812,40720,1581,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-15','2025-04-15',990905.30,NULL,NULL,1,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(1354,7812,40720,1581,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',1792808.60,NULL,NULL,1,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(1355,7812,40720,1581,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-22','2025-04-22',1881858.33,NULL,NULL,1,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(1356,7812,40720,1581,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',161000.00,NULL,NULL,1,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(1357,7812,40720,1581,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',331500.00,NULL,NULL,1,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(1358,7812,40720,1581,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',1770000.00,NULL,NULL,1,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(1359,7812,40720,1581,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-29','2025-04-29',143424.69,NULL,NULL,1,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(1360,7812,40720,1581,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-06','2025-04-06',209100.00,NULL,NULL,1,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(1361,7812,40720,1581,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-06','2025-04-06',331500.00,NULL,NULL,1,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(1362,7812,40720,1581,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-07','2025-04-07',25000.00,NULL,NULL,1,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(1363,7812,40720,1581,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-13','2025-04-13',165750.00,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL);
INSERT INTO `balance_libro` VALUES (1364,7812,40720,1581,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',79272.42,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(1365,7812,40720,1581,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',1000000.00,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(1366,7812,40720,1581,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',300000.08,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(1367,7812,40720,1581,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',300000.04,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(1368,7812,40720,1581,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',300000.08,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(1369,7812,40720,1581,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-19','2025-04-19',278800.00,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(1370,7812,40720,1581,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-19','2025-04-19',52010.01,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(1371,7812,40720,1581,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-24','2025-04-24',165750.00,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(1372,7812,40720,1581,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-27','2025-04-27',331500.00,NULL,NULL,1,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(1373,7812,40720,1582,2,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-06','2025-05-06',703153.08,NULL,NULL,1,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(1374,7812,40720,1582,2,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-06','2025-05-06',2252230.88,NULL,NULL,1,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(1375,7812,40720,1582,2,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-12','2025-05-12',1865507.67,NULL,NULL,1,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(1376,7812,40720,1582,2,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-27','2025-05-27',1040552.53,NULL,NULL,1,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(1377,7812,40720,1582,2,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-12','2025-05-12',725075.05,NULL,NULL,1,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(1378,7812,40720,1582,2,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-19','2025-05-19',2164849.68,NULL,NULL,1,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(1379,7812,40720,1582,2,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-27','2025-05-27',3045824.98,NULL,NULL,1,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(1380,7812,40720,1582,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-04','2025-05-04',198900.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1381,7812,40720,1582,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-04','2025-05-04',7463.68,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1382,7812,40720,1582,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-06','2025-05-06',89909.10,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1383,7812,40720,1582,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',232050.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1384,7812,40720,1582,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-07','2025-05-07',165750.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL);
INSERT INTO `balance_libro` VALUES (1385,7812,40720,1582,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-08','2025-05-08',180000.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1386,7812,40720,1582,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-09','2025-05-09',119799.99,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1387,7812,40720,1582,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-11','2025-05-11',232050.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1388,7812,40720,1582,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-15','2025-05-15',165750.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1389,7812,40720,1582,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-15','2025-05-15',312741.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1390,7812,40720,1582,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-18','2025-05-18',165750.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1391,7812,40720,1582,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-22','2025-05-22',248625.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1392,7812,40720,1582,3,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-25','2025-05-25',232050.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1393,7812,40720,1582,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',165750.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1394,7812,40720,1582,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',165461.51,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1395,7812,40720,1582,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',83600.00,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1396,7812,40720,1582,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',170456.12,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1397,7812,40720,1582,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',136264.06,NULL,NULL,1,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(1398,7812,40720,1579,15,1755,'App\\Models\\PeriodLiquidation',NULL,1755,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',3549648.95,NULL,NULL,1,'2025-06-07 09:25:39','2025-06-07 09:25:39',NULL),(1399,7812,40720,1580,15,1757,'App\\Models\\PeriodLiquidation',NULL,1757,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',3870147.85,NULL,NULL,1,'2025-06-07 09:30:06','2025-06-07 09:30:06',NULL),(1400,7812,40720,1581,15,1761,'App\\Models\\PeriodLiquidation',NULL,1761,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',4240767.82,NULL,NULL,1,'2025-06-07 09:35:23','2025-06-07 09:35:23',NULL),(1401,7812,40720,1582,15,1765,'App\\Models\\PeriodLiquidation',NULL,1765,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',3331828.24,NULL,NULL,1,'2025-06-07 09:38:14','2025-06-07 09:38:14',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4987 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7812,1,40720,1518,2,96,2,61250.00,NULL,'2022-09-15 16:45:07','2022-09-15 16:45:07',NULL),(2,7812,1,40720,1518,2,67,2,12862.50,NULL,'2022-09-15 16:45:07','2022-09-15 16:45:07',NULL),(3,7812,1,40720,1518,2,13,1,74112.50,NULL,'2022-09-15 16:45:07','2022-09-15 16:45:07',NULL),(4,7812,2,40720,1518,2,96,2,86844.70,NULL,'2022-09-15 16:45:07','2022-09-15 16:45:07',NULL),(5,7812,2,40720,1518,2,67,2,18237.39,NULL,'2022-09-15 16:45:07','2022-09-15 16:45:07',NULL),(6,7812,2,40720,1518,2,13,1,105082.09,NULL,'2022-09-15 16:45:07','2022-09-15 16:45:07',NULL),(7,7812,3,40720,1520,2,96,2,46550.00,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(8,7812,3,40720,1520,2,67,2,9775.50,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(9,7812,3,40720,1520,2,13,1,56325.50,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(10,7812,4,40720,1520,2,96,2,19008.26,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(11,7812,4,40720,1520,2,67,2,3991.74,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(12,7812,4,40720,1520,2,13,1,23000.00,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(13,7812,5,40720,1520,2,96,1,19008.26,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(14,7812,5,40720,1520,2,68,1,3991.73,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(15,7812,5,40720,1520,2,13,2,22999.99,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(16,7812,6,40720,1520,2,96,2,11500.00,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(17,7812,6,40720,1520,2,67,2,2415.00,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(18,7812,6,40720,1520,2,13,1,13915.00,NULL,'2022-09-15 16:45:29','2022-09-15 16:45:29',NULL),(19,7812,7,40720,1518,3,217,1,495.86,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(20,7812,7,40720,1518,3,68,1,104.13,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(21,7812,7,40720,1518,3,57,2,599.99,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(22,7812,8,40720,1518,3,217,1,41322.26,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(23,7812,8,40720,1518,3,68,1,8677.67,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(24,7812,8,40720,1518,3,57,2,49999.93,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(25,7812,9,40720,1518,3,217,1,2272.74,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(26,7812,9,40720,1518,3,68,1,477.28,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(27,7812,9,40720,1518,3,57,2,2750.02,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(28,7812,10,40720,1518,3,217,2,3223.14,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(29,7812,10,40720,1518,3,67,2,676.86,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(30,7812,10,40720,1518,3,57,1,3900.00,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(31,7812,11,40720,1518,3,217,1,3223.14,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(32,7812,11,40720,1518,3,68,1,676.86,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(33,7812,11,40720,1518,3,57,2,3900.00,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(34,7812,12,40720,1518,3,217,1,2975.20,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(35,7812,12,40720,1518,3,68,1,624.79,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(36,7812,12,40720,1518,3,57,2,3599.99,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(37,7812,13,40720,1518,3,217,1,1322.32,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(38,7812,13,40720,1518,3,68,1,277.69,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(39,7812,13,40720,1518,3,57,2,1600.01,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(40,7812,14,40720,1518,3,217,1,1074.38,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(41,7812,14,40720,1518,3,68,1,225.62,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(42,7812,14,40720,1518,3,57,2,1300.00,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(43,7812,15,40720,1518,3,217,1,31818.18,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL);
INSERT INTO `balance_libro_details` VALUES (44,7812,15,40720,1518,3,68,1,6681.82,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(45,7812,15,40720,1518,3,57,2,38500.00,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(46,7812,16,40720,1518,3,217,1,743.80,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(47,7812,16,40720,1518,3,68,1,156.20,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(48,7812,16,40720,1518,3,57,2,900.00,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(49,7812,17,40720,1518,3,217,1,1239.67,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(50,7812,17,40720,1518,3,68,1,260.33,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(51,7812,17,40720,1518,3,57,2,1500.00,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(52,7812,18,40720,1518,3,217,2,669.42,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(53,7812,18,40720,1518,3,67,2,140.58,NULL,'2022-09-15 16:45:46','2022-09-15 16:45:46',NULL),(54,7812,18,40720,1518,3,57,1,810.00,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(55,7812,19,40720,1518,3,217,2,669.42,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(56,7812,19,40720,1518,3,67,2,140.58,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(57,7812,19,40720,1518,3,57,1,810.00,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(58,7812,20,40720,1518,3,217,1,10982.23,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(59,7812,20,40720,1518,3,68,1,2306.27,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(60,7812,20,40720,1518,3,57,2,13288.50,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(61,7812,21,40720,1518,3,217,1,2314.05,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(62,7812,21,40720,1518,3,68,1,485.95,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(63,7812,21,40720,1518,3,57,2,2800.00,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(64,7812,22,40720,1518,3,250,1,8000.00,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(65,7812,22,40720,1518,3,57,2,8000.00,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(66,7812,23,40720,1518,3,217,1,1239.67,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(67,7812,23,40720,1518,3,68,1,260.33,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(68,7812,23,40720,1518,3,57,2,1500.00,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(69,7812,24,40720,1518,3,217,1,2479.32,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(70,7812,24,40720,1518,3,68,1,520.66,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(71,7812,24,40720,1518,3,57,2,2999.98,NULL,'2022-09-15 16:45:47','2022-09-15 16:45:47',NULL),(72,7812,25,40720,1519,3,217,1,495.87,NULL,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(73,7812,25,40720,1519,3,68,1,104.13,NULL,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(74,7812,25,40720,1519,3,57,2,600.00,NULL,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(75,7812,26,40720,1519,3,217,1,7107.44,NULL,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(76,7812,26,40720,1519,3,68,1,1492.56,NULL,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(77,7812,26,40720,1519,3,57,2,8600.00,NULL,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(78,7812,27,40720,1519,3,217,1,1694.21,NULL,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(79,7812,27,40720,1519,3,68,1,355.79,NULL,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(80,7812,27,40720,1519,3,57,2,2050.00,NULL,'2022-09-15 16:47:50','2022-09-15 16:47:50',NULL),(81,7812,28,40720,1519,3,217,1,44214.87,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(82,7812,28,40720,1519,3,68,1,9285.13,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(83,7812,28,40720,1519,3,57,2,53500.00,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(84,7812,29,40720,1519,3,217,1,991.74,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(85,7812,29,40720,1519,3,68,1,208.27,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(86,7812,29,40720,1519,3,57,2,1200.01,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL);
INSERT INTO `balance_libro_details` VALUES (87,7812,30,40720,1519,3,217,1,3884.29,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(88,7812,30,40720,1519,3,68,1,815.70,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(89,7812,30,40720,1519,3,217,1,0.01,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(90,7812,30,40720,1519,3,57,2,4700.00,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(91,7812,31,40720,1519,3,217,1,11818.20,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(92,7812,31,40720,1519,3,68,1,2481.82,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(93,7812,31,40720,1519,3,57,2,14300.02,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(94,7812,32,40720,1519,3,217,1,1735.54,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(95,7812,32,40720,1519,3,68,1,364.46,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(96,7812,32,40720,1519,3,57,2,2100.00,NULL,'2022-09-15 16:47:51','2022-09-15 16:47:51',NULL),(97,7812,33,40720,1520,3,217,1,500.00,NULL,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(98,7812,33,40720,1520,3,68,1,105.00,NULL,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(99,7812,33,40720,1520,3,57,2,605.00,NULL,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(100,7812,34,40720,1520,3,217,1,2510.00,NULL,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(101,7812,34,40720,1520,3,68,1,527.10,NULL,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(102,7812,34,40720,1520,3,57,2,3037.10,NULL,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(103,7812,35,40720,1520,3,217,1,4491.73,NULL,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(104,7812,35,40720,1520,3,68,1,943.26,NULL,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(105,7812,35,40720,1520,3,57,2,5434.99,NULL,'2022-09-15 16:48:18','2022-09-15 16:48:18',NULL),(106,7812,36,40719,11,2,218,2,75000.00,NULL,'2022-09-26 19:16:53','2022-09-26 19:16:53',NULL),(107,7812,36,40719,11,2,13,1,75000.00,NULL,'2022-09-26 19:16:53','2022-09-26 19:16:53',NULL),(108,7812,37,40720,1528,2,96,2,49090.69,NULL,'2022-09-28 08:07:54','2022-09-28 08:07:54',NULL),(109,7812,37,40720,1528,2,67,2,10309.05,NULL,'2022-09-28 08:07:54','2022-09-28 08:07:54',NULL),(110,7812,37,40720,1528,2,13,1,59399.74,NULL,'2022-09-28 08:07:54','2022-09-28 08:07:54',NULL),(111,7812,38,40720,1528,2,96,2,106836.00,NULL,'2022-09-28 08:07:54','2022-09-28 08:07:54',NULL),(112,7812,38,40720,1528,2,67,2,22435.56,NULL,'2022-09-28 08:07:54','2022-09-28 08:07:54',NULL),(113,7812,38,40720,1528,2,13,1,129271.56,NULL,'2022-09-28 08:07:54','2022-09-28 08:07:54',NULL),(114,7812,39,40720,1529,2,96,2,96048.00,NULL,'2022-09-28 08:08:18','2022-09-28 08:08:18',NULL),(115,7812,39,40720,1529,2,67,2,20170.08,NULL,'2022-09-28 08:08:18','2022-09-28 08:08:18',NULL),(116,7812,39,40720,1529,2,13,1,116218.08,NULL,'2022-09-28 08:08:18','2022-09-28 08:08:18',NULL),(117,7812,40,40720,1529,2,96,2,129510.00,NULL,'2022-09-28 08:08:19','2022-09-28 08:08:19',NULL),(118,7812,40,40720,1529,2,67,2,27197.10,NULL,'2022-09-28 08:08:19','2022-09-28 08:08:19',NULL),(119,7812,40,40720,1529,2,13,1,156707.10,NULL,'2022-09-28 08:08:19','2022-09-28 08:08:19',NULL),(120,7812,41,40720,1533,2,96,2,3100.00,NULL,'2022-09-28 08:08:37','2022-09-28 08:08:37',NULL),(121,7812,41,40720,1533,2,67,2,651.00,NULL,'2022-09-28 08:08:37','2022-09-28 08:08:37',NULL),(122,7812,41,40720,1533,2,13,1,3751.00,NULL,'2022-09-28 08:08:37','2022-09-28 08:08:37',NULL),(123,7812,42,40720,1533,2,96,2,6200.00,NULL,'2022-09-28 08:08:37','2022-09-28 08:08:37',NULL),(124,7812,42,40720,1533,2,67,2,1302.00,NULL,'2022-09-28 08:08:37','2022-09-28 08:08:37',NULL),(125,7812,42,40720,1533,2,13,1,7502.00,NULL,'2022-09-28 08:08:37','2022-09-28 08:08:37',NULL),(126,7812,43,40720,1537,2,96,2,30000.00,NULL,'2022-09-28 08:08:51','2022-09-28 08:08:51',NULL),(127,7812,43,40720,1537,2,67,2,6300.00,NULL,'2022-09-28 08:08:51','2022-09-28 08:08:51',NULL),(128,7812,43,40720,1537,2,13,1,36300.00,NULL,'2022-09-28 08:08:51','2022-09-28 08:08:51',NULL);
INSERT INTO `balance_libro_details` VALUES (129,7812,44,40720,1537,2,96,2,139084.86,NULL,'2022-09-28 08:08:51','2022-09-28 08:08:51',NULL),(130,7812,44,40720,1537,2,67,2,29207.82,NULL,'2022-09-28 08:08:51','2022-09-28 08:08:51',NULL),(131,7812,44,40720,1537,2,13,1,168292.68,NULL,'2022-09-28 08:08:51','2022-09-28 08:08:51',NULL),(132,7812,45,40720,1538,2,96,2,161205.77,NULL,'2022-09-28 08:09:08','2022-09-28 08:09:08',NULL),(133,7812,45,40720,1538,2,67,2,33853.22,NULL,'2022-09-28 08:09:08','2022-09-28 08:09:08',NULL),(134,7812,45,40720,1538,2,13,1,195058.99,NULL,'2022-09-28 08:09:08','2022-09-28 08:09:08',NULL),(135,7812,46,40720,1538,2,96,2,46670.01,NULL,'2022-09-28 08:09:08','2022-09-28 08:09:08',NULL),(136,7812,46,40720,1538,2,67,2,9800.70,NULL,'2022-09-28 08:09:08','2022-09-28 08:09:08',NULL),(137,7812,46,40720,1538,2,13,1,56470.71,NULL,'2022-09-28 08:09:08','2022-09-28 08:09:08',NULL),(138,7812,47,40720,1539,2,96,2,66255.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(139,7812,47,40720,1539,2,67,2,13913.55,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(140,7812,47,40720,1539,2,13,1,80168.55,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(141,7812,48,40720,1539,2,218,2,0.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(142,7812,48,40720,1539,2,218,2,66255.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(143,7812,48,40720,1539,2,13,1,66255.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(144,7812,49,40720,1539,2,96,2,104055.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(145,7812,49,40720,1539,2,67,2,21851.55,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(146,7812,49,40720,1539,2,13,1,125906.55,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(147,7812,50,40720,1539,2,96,2,44850.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(148,7812,50,40720,1539,2,67,2,9418.50,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(149,7812,50,40720,1539,2,13,1,54268.50,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(150,7812,51,40720,1539,2,96,2,229516.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(151,7812,51,40720,1539,2,67,2,48198.36,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(152,7812,51,40720,1539,2,13,1,277714.36,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(153,7812,52,40720,1539,2,96,2,182220.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(154,7812,52,40720,1539,2,67,2,38266.20,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(155,7812,52,40720,1539,2,13,1,220486.20,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(156,7812,53,40720,1539,2,96,1,66255.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(157,7812,53,40720,1539,2,68,1,13913.55,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(158,7812,53,40720,1539,2,13,2,80168.55,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(159,7812,54,40720,1539,2,96,2,103808.00,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(160,7812,54,40720,1539,2,67,2,21799.68,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(161,7812,54,40720,1539,2,13,1,125607.68,NULL,'2022-09-28 08:09:45','2022-09-28 08:09:45',NULL),(162,7812,55,40720,1540,2,96,2,43650.00,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(163,7812,55,40720,1540,2,67,2,9166.50,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(164,7812,55,40720,1540,2,13,1,52816.50,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(165,7812,56,40720,1540,2,96,2,83295.00,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(166,7812,56,40720,1540,2,67,2,17491.95,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(167,7812,56,40720,1540,2,13,1,100786.95,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(168,7812,57,40720,1540,2,96,2,207280.00,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(169,7812,57,40720,1540,2,67,2,43528.80,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(170,7812,57,40720,1540,2,13,1,250808.80,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL);
INSERT INTO `balance_libro_details` VALUES (171,7812,58,40720,1540,2,96,2,70708.00,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(172,7812,58,40720,1540,2,67,2,14848.68,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(173,7812,58,40720,1540,2,13,1,85556.68,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(174,7812,59,40720,1540,2,218,2,0.00,NULL,'2022-09-28 08:09:56','2022-10-19 08:48:00','2022-10-19 08:48:00'),(175,7812,59,40720,1540,2,218,2,7000.00,NULL,'2022-09-28 08:09:56','2022-10-19 08:48:00','2022-10-19 08:48:00'),(176,7812,59,40720,1540,2,13,1,7000.00,NULL,'2022-09-28 08:09:56','2022-10-19 08:48:00','2022-10-19 08:48:00'),(177,7812,60,40720,1540,2,218,2,0.00,NULL,'2022-09-28 08:09:56','2022-10-19 08:47:35','2022-10-19 08:47:35'),(178,7812,60,40720,1540,2,218,2,3500.00,NULL,'2022-09-28 08:09:56','2022-10-19 08:47:35','2022-10-19 08:47:35'),(179,7812,60,40720,1540,2,13,1,3500.00,NULL,'2022-09-28 08:09:56','2022-10-19 08:47:35','2022-10-19 08:47:35'),(180,7812,61,40720,1540,2,96,2,79282.00,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(181,7812,61,40720,1540,2,67,2,16649.22,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(182,7812,61,40720,1540,2,13,1,95931.22,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(183,7812,62,40720,1540,2,96,2,186804.00,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(184,7812,62,40720,1540,2,67,2,39228.84,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(185,7812,62,40720,1540,2,13,1,226032.84,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(186,7812,63,40720,1540,2,96,2,198181.50,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(187,7812,63,40720,1540,2,67,2,41618.12,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(188,7812,63,40720,1540,2,13,1,239799.62,NULL,'2022-09-28 08:09:56','2022-09-28 08:09:56',NULL),(189,7812,64,40720,1540,2,96,2,159800.00,NULL,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(190,7812,64,40720,1540,2,67,2,33558.00,NULL,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(191,7812,64,40720,1540,2,13,1,193358.00,NULL,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(192,7812,65,40720,1540,2,96,2,208968.00,NULL,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(193,7812,65,40720,1540,2,67,2,43883.28,NULL,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(194,7812,65,40720,1540,2,13,1,252851.28,NULL,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(195,7812,66,40720,1540,2,96,2,95853.70,NULL,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(196,7812,66,40720,1540,2,67,2,20129.28,NULL,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(197,7812,66,40720,1540,2,13,1,115982.98,NULL,'2022-09-28 08:09:57','2022-09-28 08:09:57',NULL),(198,7812,67,40720,1521,3,217,1,1198.35,NULL,'2022-09-28 08:10:23','2022-09-28 08:10:23',NULL),(199,7812,67,40720,1521,3,68,1,251.65,NULL,'2022-09-28 08:10:23','2022-09-28 08:10:23',NULL),(200,7812,67,40720,1521,3,57,2,1450.00,NULL,'2022-09-28 08:10:23','2022-09-28 08:10:23',NULL),(201,7812,68,40720,1521,3,217,1,55743.80,NULL,'2022-09-28 08:10:23','2022-09-28 08:10:23',NULL),(202,7812,68,40720,1521,3,68,1,11706.20,NULL,'2022-09-28 08:10:23','2022-09-28 08:10:23',NULL),(203,7812,68,40720,1521,3,57,2,67450.00,NULL,'2022-09-28 08:10:23','2022-09-28 08:10:23',NULL),(204,7812,69,40720,1521,3,217,1,2859.52,NULL,'2022-09-28 08:10:24','2022-09-28 08:10:24',NULL),(205,7812,69,40720,1521,3,68,1,600.50,NULL,'2022-09-28 08:10:24','2022-09-28 08:10:24',NULL),(206,7812,69,40720,1521,3,57,2,3460.02,NULL,'2022-09-28 08:10:24','2022-09-28 08:10:24',NULL),(207,7812,70,40720,1522,3,217,1,46487.60,NULL,'2022-09-28 08:10:34','2022-09-28 08:10:34',NULL),(208,7812,70,40720,1522,3,68,1,9762.40,NULL,'2022-09-28 08:10:34','2022-09-28 08:10:34',NULL),(209,7812,70,40720,1522,3,57,2,56250.00,NULL,'2022-09-28 08:10:34','2022-09-28 08:10:34',NULL),(210,7812,71,40720,1523,3,217,1,1239.67,NULL,'2022-09-28 08:10:45','2022-09-28 08:10:45',NULL),(211,7812,71,40720,1523,3,68,1,260.33,NULL,'2022-09-28 08:10:45','2022-09-28 08:10:45',NULL);
INSERT INTO `balance_libro_details` VALUES (212,7812,71,40720,1523,3,57,2,1500.00,NULL,'2022-09-28 08:10:45','2022-09-28 08:10:45',NULL),(213,7812,72,40720,1523,3,217,1,7272.72,NULL,'2022-09-28 08:10:45','2022-09-28 08:10:45',NULL),(214,7812,72,40720,1523,3,68,1,1527.27,NULL,'2022-09-28 08:10:45','2022-09-28 08:10:45',NULL),(215,7812,72,40720,1523,3,57,2,8799.99,NULL,'2022-09-28 08:10:45','2022-09-28 08:10:45',NULL),(216,7812,73,40720,1524,3,250,1,15000.00,NULL,'2022-09-28 08:10:58','2022-09-28 08:10:58',NULL),(217,7812,73,40720,1524,3,57,2,15000.00,NULL,'2022-09-28 08:10:58','2022-09-28 08:10:58',NULL),(218,7812,74,40720,1525,3,217,1,17355.37,NULL,'2022-09-28 08:12:56','2022-09-28 08:12:56',NULL),(219,7812,74,40720,1525,3,68,1,3644.63,NULL,'2022-09-28 08:12:56','2022-09-28 08:12:56',NULL),(220,7812,74,40720,1525,3,57,2,21000.00,NULL,'2022-09-28 08:12:56','2022-09-28 08:12:56',NULL),(221,7812,75,40720,1525,3,217,1,1206.62,NULL,'2022-09-28 08:12:56','2022-09-28 08:12:56',NULL),(222,7812,75,40720,1525,3,68,1,253.39,NULL,'2022-09-28 08:12:56','2022-09-28 08:12:56',NULL),(223,7812,75,40720,1525,3,57,2,1460.01,NULL,'2022-09-28 08:12:56','2022-09-28 08:12:56',NULL),(224,7812,76,40720,1526,3,217,1,9409.60,NULL,'2022-09-28 08:13:11','2022-09-28 08:13:11',NULL),(225,7812,76,40720,1526,3,68,1,1976.01,NULL,'2022-09-28 08:13:11','2022-09-28 08:13:11',NULL),(226,7812,76,40720,1526,3,57,2,11385.61,NULL,'2022-09-28 08:13:11','2022-09-28 08:13:11',NULL),(227,7812,77,40720,1526,3,217,1,28925.62,NULL,'2022-09-28 08:13:11','2022-09-28 08:13:11',NULL),(228,7812,77,40720,1526,3,68,1,6074.38,NULL,'2022-09-28 08:13:11','2022-09-28 08:13:11',NULL),(229,7812,77,40720,1526,3,57,2,35000.00,NULL,'2022-09-28 08:13:11','2022-09-28 08:13:11',NULL),(230,7812,78,40720,1527,3,217,1,18595.04,NULL,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(231,7812,78,40720,1527,3,68,1,3904.96,NULL,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(232,7812,78,40720,1527,3,57,2,22500.00,NULL,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(233,7812,79,40720,1527,3,217,1,28925.62,NULL,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(234,7812,79,40720,1527,3,68,1,6074.38,NULL,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(235,7812,79,40720,1527,3,57,2,35000.00,NULL,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(236,7812,80,40720,1527,3,217,1,28925.62,NULL,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(237,7812,80,40720,1527,3,68,1,6074.38,NULL,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(238,7812,80,40720,1527,3,57,2,35000.00,NULL,'2022-09-28 08:13:27','2022-09-28 08:13:27',NULL),(239,7812,81,40720,1528,3,217,1,18181.82,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(240,7812,81,40720,1528,3,68,1,3818.18,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(241,7812,81,40720,1528,3,57,2,22000.00,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(242,7812,82,40720,1528,3,250,1,8000.00,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(243,7812,82,40720,1528,3,57,2,8000.00,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(244,7812,83,40720,1528,3,217,1,66942.14,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(245,7812,83,40720,1528,3,68,1,14057.85,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(246,7812,83,40720,1528,3,57,2,80999.99,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(247,7812,84,40720,1528,3,217,1,826.45,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(248,7812,84,40720,1528,3,68,1,173.55,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(249,7812,84,40720,1528,3,57,2,1000.00,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(250,7812,85,40720,1528,3,250,1,1250.00,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(251,7812,85,40720,1528,3,57,2,1250.00,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(252,7812,86,40720,1528,3,217,1,363.64,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(253,7812,86,40720,1528,3,68,1,76.36,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL);
INSERT INTO `balance_libro_details` VALUES (254,7812,86,40720,1528,3,57,2,440.00,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(255,7812,87,40720,1528,3,217,1,36280.99,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(256,7812,87,40720,1528,3,68,1,7619.01,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(257,7812,87,40720,1528,3,57,2,43900.00,NULL,'2022-09-28 08:13:38','2022-09-28 08:13:38',NULL),(258,7812,88,40720,1529,3,217,1,48710.75,NULL,'2022-09-28 08:14:08','2022-09-28 08:14:08',NULL),(259,7812,88,40720,1529,3,68,1,10229.26,NULL,'2022-09-28 08:14:08','2022-09-28 08:14:08',NULL),(260,7812,88,40720,1529,3,217,1,-0.01,NULL,'2022-09-28 08:14:08','2022-09-28 08:14:08',NULL),(261,7812,88,40720,1529,3,57,2,58940.00,NULL,'2022-09-28 08:14:08','2022-09-28 08:14:08',NULL),(262,7812,89,40720,1533,3,217,1,63636.36,NULL,'2022-09-28 08:16:10','2022-09-28 08:16:10',NULL),(263,7812,89,40720,1533,3,68,1,13363.63,NULL,'2022-09-28 08:16:10','2022-09-28 08:16:10',NULL),(264,7812,89,40720,1533,3,57,2,76999.99,NULL,'2022-09-28 08:16:10','2022-09-28 08:16:10',NULL),(265,7812,90,40720,1533,3,217,1,1157.02,NULL,'2022-09-28 08:16:10','2022-09-28 08:16:10',NULL),(266,7812,90,40720,1533,3,68,1,242.97,NULL,'2022-09-28 08:16:10','2022-09-28 08:16:10',NULL),(267,7812,90,40720,1533,3,57,2,1399.99,NULL,'2022-09-28 08:16:10','2022-09-28 08:16:10',NULL),(268,7812,91,40720,1534,3,217,1,1652.89,NULL,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(269,7812,91,40720,1534,3,68,1,347.11,NULL,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(270,7812,91,40720,1534,3,57,2,2000.00,NULL,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(271,7812,92,40720,1534,3,217,1,2314.04,NULL,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(272,7812,92,40720,1534,3,68,1,485.95,NULL,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(273,7812,92,40720,1534,3,57,2,2799.99,NULL,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(274,7812,93,40720,1534,3,217,1,1652.90,NULL,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(275,7812,93,40720,1534,3,68,1,347.11,NULL,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(276,7812,93,40720,1534,3,57,2,2000.01,NULL,'2022-09-28 08:16:26','2022-09-28 08:16:26',NULL),(277,7812,94,40720,1538,3,217,1,10000.00,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:52','2022-10-19 10:38:52'),(278,7812,94,40720,1538,3,68,1,2100.00,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:52','2022-10-19 10:38:52'),(279,7812,94,40720,1538,3,57,2,12100.00,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:52','2022-10-19 10:38:52'),(280,7812,95,40720,1538,3,217,1,12768.72,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:21','2022-10-19 10:38:21'),(281,7812,95,40720,1538,3,68,1,2681.43,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:21','2022-10-19 10:38:21'),(282,7812,95,40720,1538,3,57,2,15450.15,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:21','2022-10-19 10:38:21'),(283,7812,96,40720,1538,3,217,1,4121.91,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:38','2022-10-19 10:38:38'),(284,7812,96,40720,1538,3,68,1,865.60,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:38','2022-10-19 10:38:38'),(285,7812,96,40720,1538,3,57,2,4987.51,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:38','2022-10-19 10:38:38'),(286,7812,97,40720,1538,3,217,1,1652.90,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:10','2022-10-19 10:38:10'),(287,7812,97,40720,1538,3,68,1,347.11,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:10','2022-10-19 10:38:10'),(288,7812,97,40720,1538,3,57,2,2000.01,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:10','2022-10-19 10:38:10'),(289,7812,98,40720,1538,3,217,1,2975.21,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:01','2022-10-19 10:38:01'),(290,7812,98,40720,1538,3,68,1,624.79,NULL,'2022-09-28 08:16:51','2022-10-19 10:38:01','2022-10-19 10:38:01'),(291,7812,98,40720,1538,3,57,2,3600.00,NULL,'2022-09-28 08:16:52','2022-10-19 10:38:01','2022-10-19 10:38:01'),(292,7812,99,40720,1538,3,217,1,20661.16,NULL,'2022-09-28 08:16:52','2022-10-19 10:39:17','2022-10-19 10:39:17');
INSERT INTO `balance_libro_details` VALUES (293,7812,99,40720,1538,3,68,1,4338.84,NULL,'2022-09-28 08:16:52','2022-10-19 10:39:17','2022-10-19 10:39:17'),(294,7812,99,40720,1538,3,57,2,25000.00,NULL,'2022-09-28 08:16:52','2022-10-19 10:39:17','2022-10-19 10:39:17'),(295,7812,100,40720,1538,3,217,1,7107.45,NULL,'2022-09-28 08:16:52','2022-10-19 10:37:35','2022-10-19 10:37:35'),(296,7812,100,40720,1538,3,68,1,1492.56,NULL,'2022-09-28 08:16:52','2022-10-19 10:37:35','2022-10-19 10:37:35'),(297,7812,100,40720,1538,3,57,2,8600.01,NULL,'2022-09-28 08:16:52','2022-10-19 10:37:35','2022-10-19 10:37:35'),(298,7812,101,40720,1539,3,217,1,3388.43,NULL,'2022-09-28 08:17:06','2022-10-19 11:25:43','2022-10-19 11:25:43'),(299,7812,101,40720,1539,3,68,1,711.57,NULL,'2022-09-28 08:17:06','2022-10-19 11:25:43','2022-10-19 11:25:43'),(300,7812,101,40720,1539,3,57,2,4100.00,NULL,'2022-09-28 08:17:06','2022-10-19 11:25:43','2022-10-19 11:25:43'),(301,7812,102,40720,1539,3,217,1,4462.81,NULL,'2022-09-28 08:17:06','2022-10-19 11:25:51','2022-10-19 11:25:51'),(302,7812,102,40720,1539,3,68,1,937.19,NULL,'2022-09-28 08:17:06','2022-10-19 11:25:51','2022-10-19 11:25:51'),(303,7812,102,40720,1539,3,57,2,5400.00,NULL,'2022-09-28 08:17:06','2022-10-19 11:25:51','2022-10-19 11:25:51'),(304,7812,103,40720,1539,3,217,1,59256.20,NULL,'2022-09-28 08:17:06','2022-10-19 11:25:25','2022-10-19 11:25:25'),(305,7812,103,40720,1539,3,68,1,12443.80,NULL,'2022-09-28 08:17:06','2022-10-19 11:25:25','2022-10-19 11:25:25'),(306,7812,103,40720,1539,3,57,2,71700.00,NULL,'2022-09-28 08:17:06','2022-10-19 11:25:25','2022-10-19 11:25:25'),(307,7812,104,40720,1540,3,217,1,57.85,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(308,7812,104,40720,1540,3,68,1,12.15,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(309,7812,104,40720,1540,3,57,2,70.00,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(310,7812,105,40720,1540,3,217,1,17476.86,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(311,7812,105,40720,1540,3,68,1,3670.14,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(312,7812,105,40720,1540,3,57,2,21147.00,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(313,7812,106,40720,1540,3,217,1,85950.41,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(314,7812,106,40720,1540,3,68,1,18049.59,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(315,7812,106,40720,1540,3,57,2,104000.00,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(316,7812,107,40720,1540,3,217,1,3347.10,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(317,7812,107,40720,1540,3,68,1,702.89,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(318,7812,107,40720,1540,3,57,2,4049.99,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(319,7812,108,40720,1540,3,217,1,3087.54,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(320,7812,108,40720,1540,3,68,1,648.38,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(321,7812,108,40720,1540,3,217,1,203.78,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(322,7812,108,40720,1540,3,57,2,3939.70,NULL,'2022-09-28 08:17:36','2022-09-28 08:17:36',NULL),(323,7812,109,40720,1540,3,217,1,9546.87,NULL,'2022-10-19 08:18:25','2022-10-19 08:43:09','2022-10-19 08:43:09'),(324,7812,109,40720,1540,3,68,1,2004.84,NULL,'2022-10-19 08:18:25','2022-10-19 08:43:09','2022-10-19 08:43:09'),(325,7812,109,40720,1540,3,222,1,1454.29,NULL,'2022-10-19 08:18:25','2022-10-19 08:43:09','2022-10-19 08:43:09'),(326,7812,109,40720,1540,3,57,2,13006.00,NULL,'2022-10-19 08:18:25','2022-10-19 08:43:09','2022-10-19 08:43:09'),(327,7812,110,40720,1540,3,217,1,3754.50,NULL,'2022-10-19 08:19:50','2022-10-19 08:43:36','2022-10-19 08:43:36'),(328,7812,110,40720,1540,3,68,1,788.45,NULL,'2022-10-19 08:19:50','2022-10-19 08:43:36','2022-10-19 08:43:36'),(329,7812,110,40720,1540,3,222,1,457.06,NULL,'2022-10-19 08:19:50','2022-10-19 08:43:36','2022-10-19 08:43:36'),(330,7812,110,40720,1540,3,57,2,5000.01,NULL,'2022-10-19 08:19:50','2022-10-19 08:43:36','2022-10-19 08:43:36');
INSERT INTO `balance_libro_details` VALUES (331,7812,111,40720,1540,3,217,1,11965.10,NULL,'2022-10-19 08:20:40','2022-10-19 08:44:15','2022-10-19 08:44:15'),(332,7812,111,40720,1540,3,68,1,2512.67,NULL,'2022-10-19 08:20:40','2022-10-19 08:44:15','2022-10-19 08:44:15'),(333,7812,111,40720,1540,3,222,1,1022.22,NULL,'2022-10-19 08:20:40','2022-10-19 08:44:15','2022-10-19 08:44:15'),(334,7812,111,40720,1540,3,57,2,15499.99,NULL,'2022-10-19 08:20:40','2022-10-19 08:44:15','2022-10-19 08:44:15'),(335,7812,112,40720,1540,3,217,1,3382.80,NULL,'2022-10-19 08:21:34','2022-10-19 08:44:36','2022-10-19 08:44:36'),(336,7812,112,40720,1540,3,68,1,710.39,NULL,'2022-10-19 08:21:34','2022-10-19 08:44:36','2022-10-19 08:44:36'),(337,7812,112,40720,1540,3,222,1,411.81,NULL,'2022-10-19 08:21:34','2022-10-19 08:44:36','2022-10-19 08:44:36'),(338,7812,112,40720,1540,3,57,2,4505.00,NULL,'2022-10-19 08:21:34','2022-10-19 08:44:36','2022-10-19 08:44:36'),(339,7812,113,40720,1540,3,217,1,5631.98,NULL,'2022-10-19 08:22:15','2022-10-19 08:45:19','2022-10-19 08:45:19'),(340,7812,113,40720,1540,3,68,1,1182.72,NULL,'2022-10-19 08:22:15','2022-10-19 08:45:19','2022-10-19 08:45:19'),(341,7812,113,40720,1540,3,222,1,685.61,NULL,'2022-10-19 08:22:15','2022-10-19 08:45:19','2022-10-19 08:45:19'),(342,7812,113,40720,1540,3,57,2,7500.31,NULL,'2022-10-19 08:22:15','2022-10-19 08:45:19','2022-10-19 08:45:19'),(343,7812,114,40720,1540,3,217,1,3752.24,NULL,'2022-10-19 08:22:55','2022-10-19 08:45:46','2022-10-19 08:45:46'),(344,7812,114,40720,1540,3,68,1,787.97,NULL,'2022-10-19 08:22:55','2022-10-19 08:45:46','2022-10-19 08:45:46'),(345,7812,114,40720,1540,3,222,1,467.39,NULL,'2022-10-19 08:22:55','2022-10-19 08:45:46','2022-10-19 08:45:46'),(346,7812,114,40720,1540,3,57,2,5007.60,NULL,'2022-10-19 08:22:55','2022-10-19 08:45:46','2022-10-19 08:45:46'),(347,7812,115,40720,1540,3,217,1,18122.97,NULL,'2022-10-19 08:23:40','2022-10-19 08:46:22','2022-10-19 08:46:22'),(348,7812,115,40720,1540,3,68,1,3805.82,NULL,'2022-10-19 08:23:40','2022-10-19 08:46:22','2022-10-19 08:46:22'),(349,7812,115,40720,1540,3,222,1,2074.11,NULL,'2022-10-19 08:23:40','2022-10-19 08:46:22','2022-10-19 08:46:22'),(350,7812,115,40720,1540,3,57,2,24002.90,NULL,'2022-10-19 08:23:40','2022-10-19 08:46:22','2022-10-19 08:46:22'),(351,7812,116,40720,1540,3,217,1,2504.11,NULL,'2022-10-19 08:24:44','2022-10-19 08:46:49','2022-10-19 08:46:49'),(352,7812,116,40720,1540,3,68,1,525.86,NULL,'2022-10-19 08:24:44','2022-10-19 08:46:49','2022-10-19 08:46:49'),(353,7812,116,40720,1540,3,221,1,470.53,NULL,'2022-10-19 08:24:44','2022-10-19 08:46:49','2022-10-19 08:46:49'),(354,7812,116,40720,1540,3,57,2,3500.50,NULL,'2022-10-19 08:24:44','2022-10-19 08:46:49','2022-10-19 08:46:49'),(355,7812,117,40720,1541,3,217,1,9816.48,NULL,'2022-10-19 08:31:28','2022-10-21 08:43:36','2022-10-21 08:43:36'),(356,7812,117,40720,1541,3,68,1,2061.46,NULL,'2022-10-19 08:31:28','2022-10-21 08:43:36','2022-10-21 08:43:36'),(357,7812,117,40720,1541,3,224,1,1123.46,NULL,'2022-10-19 08:31:28','2022-10-21 08:43:36','2022-10-21 08:43:36'),(358,7812,117,40720,1541,3,57,2,13001.40,NULL,'2022-10-19 08:31:28','2022-10-21 08:43:36','2022-10-21 08:43:36'),(359,7812,118,40720,1541,3,217,1,3576.79,NULL,'2022-10-19 08:32:05','2022-10-19 08:41:56','2022-10-19 08:41:56'),(360,7812,118,40720,1541,3,68,1,751.13,NULL,'2022-10-19 08:32:05','2022-10-19 08:41:56','2022-10-19 08:41:56'),(361,7812,118,40720,1541,3,224,1,672.09,NULL,'2022-10-19 08:32:05','2022-10-19 08:41:56','2022-10-19 08:41:56'),(362,7812,118,40720,1541,3,57,2,5000.01,NULL,'2022-10-19 08:32:05','2022-10-19 08:41:56','2022-10-19 08:41:56'),(363,7812,119,40720,1541,3,217,1,9060.40,NULL,'2022-10-19 08:32:54','2022-10-19 08:42:12','2022-10-19 08:42:12'),(364,7812,119,40720,1541,3,68,1,1902.68,NULL,'2022-10-19 08:32:54','2022-10-19 08:42:12','2022-10-19 08:42:12'),(365,7812,119,40720,1541,3,224,1,1036.93,NULL,'2022-10-19 08:32:54','2022-10-19 08:42:12','2022-10-19 08:42:12');
INSERT INTO `balance_libro_details` VALUES (366,7812,119,40720,1541,3,57,2,12000.01,NULL,'2022-10-19 08:32:54','2022-10-19 08:42:12','2022-10-19 08:42:12'),(367,7812,120,40720,1541,3,217,1,10864.75,NULL,'2022-10-19 08:33:19','2022-10-19 08:42:25','2022-10-19 08:42:25'),(368,7812,120,40720,1541,3,68,1,2281.60,NULL,'2022-10-19 08:33:19','2022-10-19 08:42:25','2022-10-19 08:42:25'),(369,7812,120,40720,1541,3,224,1,858.45,NULL,'2022-10-19 08:33:19','2022-10-19 08:42:25','2022-10-19 08:42:25'),(370,7812,120,40720,1541,3,57,2,14004.80,NULL,'2022-10-19 08:33:19','2022-10-19 08:42:25','2022-10-19 08:42:25'),(371,7812,121,40720,1541,3,217,1,11325.49,NULL,'2022-10-19 08:33:56','2022-10-21 08:41:43','2022-10-21 08:41:43'),(372,7812,121,40720,1541,3,68,1,2378.35,NULL,'2022-10-19 08:33:56','2022-10-21 08:41:43','2022-10-21 08:41:43'),(373,7812,121,40720,1541,3,224,1,1296.16,NULL,'2022-10-19 08:33:56','2022-10-21 08:41:43','2022-10-21 08:41:43'),(374,7812,121,40720,1541,3,57,2,15000.00,NULL,'2022-10-19 08:33:56','2022-10-21 08:41:43','2022-10-21 08:41:43'),(375,7812,122,40720,1541,3,217,1,10570.45,NULL,'2022-10-19 08:34:23','2022-10-21 08:41:11','2022-10-21 08:41:11'),(376,7812,122,40720,1541,3,68,1,2219.79,NULL,'2022-10-19 08:34:23','2022-10-21 08:41:11','2022-10-21 08:41:11'),(377,7812,122,40720,1541,3,224,1,1209.75,NULL,'2022-10-19 08:34:23','2022-10-21 08:41:11','2022-10-21 08:41:11'),(378,7812,122,40720,1541,3,57,2,13999.99,NULL,'2022-10-19 08:34:23','2022-10-21 08:41:11','2022-10-21 08:41:11'),(379,7812,123,40720,1541,3,217,1,3576.79,NULL,'2022-10-19 08:35:03','2022-10-21 08:40:40','2022-10-21 08:40:40'),(380,7812,123,40720,1541,3,68,1,751.13,NULL,'2022-10-19 08:35:03','2022-10-21 08:40:40','2022-10-21 08:40:40'),(381,7812,123,40720,1541,3,224,1,672.09,NULL,'2022-10-19 08:35:03','2022-10-21 08:40:40','2022-10-21 08:40:40'),(382,7812,123,40720,1541,3,57,2,5000.01,NULL,'2022-10-19 08:35:03','2022-10-21 08:40:40','2022-10-21 08:40:40'),(383,7812,124,40720,1541,3,217,1,12839.55,NULL,'2022-10-19 08:35:33','2022-10-21 08:40:14','2022-10-21 08:40:14'),(384,7812,124,40720,1541,3,68,1,2696.31,NULL,'2022-10-19 08:35:33','2022-10-21 08:40:14','2022-10-21 08:40:14'),(385,7812,124,40720,1541,3,224,1,1469.44,NULL,'2022-10-19 08:35:33','2022-10-21 08:40:14','2022-10-21 08:40:14'),(386,7812,124,40720,1541,3,57,2,17005.30,NULL,'2022-10-19 08:35:33','2022-10-21 08:40:14','2022-10-21 08:40:14'),(387,7812,125,40720,1541,3,217,1,765.48,NULL,'2022-10-19 08:36:49','2022-10-21 08:39:39','2022-10-21 08:39:39'),(388,7812,125,40720,1541,3,68,1,160.75,NULL,'2022-10-19 08:36:49','2022-10-21 08:39:39','2022-10-21 08:39:39'),(389,7812,125,40720,1541,3,224,1,74.23,NULL,'2022-10-19 08:36:49','2022-10-21 08:39:39','2022-10-21 08:39:39'),(390,7812,125,40720,1541,3,57,2,1000.46,NULL,'2022-10-19 08:36:49','2022-10-21 08:39:39','2022-10-21 08:39:39'),(391,7812,126,40720,1541,3,217,1,7757.94,NULL,'2022-10-19 08:39:15','2022-10-19 08:39:15',NULL),(392,7812,126,40720,1541,3,68,1,1629.17,NULL,'2022-10-19 08:39:15','2022-10-19 08:39:15',NULL),(393,7812,126,40720,1541,3,224,1,612.96,NULL,'2022-10-19 08:39:15','2022-10-19 08:39:15',NULL),(394,7812,126,40720,1541,3,57,2,10000.07,NULL,'2022-10-19 08:39:15','2022-10-19 08:39:15',NULL),(395,7812,127,40720,1541,3,217,1,10570.45,NULL,'2022-10-19 08:39:52','2022-10-19 08:39:52',NULL),(396,7812,127,40720,1541,3,68,1,2219.79,NULL,'2022-10-19 08:39:52','2022-10-19 08:39:52',NULL),(397,7812,127,40720,1541,3,224,1,1209.75,NULL,'2022-10-19 08:39:52','2022-10-19 08:39:52',NULL),(398,7812,127,40720,1541,3,57,2,13999.99,NULL,'2022-10-19 08:39:52','2022-10-19 08:39:52',NULL),(399,7812,128,40720,1541,3,217,1,3576.79,NULL,'2022-10-19 08:41:56','2022-10-21 08:43:10','2022-10-21 08:43:10'),(400,7812,128,40720,1541,3,68,1,751.13,NULL,'2022-10-19 08:41:56','2022-10-21 08:43:10','2022-10-21 08:43:10'),(401,7812,128,40720,1541,3,224,1,672.09,NULL,'2022-10-19 08:41:56','2022-10-21 08:43:10','2022-10-21 08:43:10');
INSERT INTO `balance_libro_details` VALUES (402,7812,128,40720,1541,3,57,2,5000.01,NULL,'2022-10-19 08:41:56','2022-10-21 08:43:10','2022-10-21 08:43:10'),(403,7812,129,40720,1541,3,217,1,9060.40,NULL,'2022-10-19 08:42:12','2022-10-21 08:42:41','2022-10-21 08:42:41'),(404,7812,129,40720,1541,3,68,1,1902.68,NULL,'2022-10-19 08:42:12','2022-10-21 08:42:41','2022-10-21 08:42:41'),(405,7812,129,40720,1541,3,224,1,1036.93,NULL,'2022-10-19 08:42:12','2022-10-21 08:42:41','2022-10-21 08:42:41'),(406,7812,129,40720,1541,3,57,2,12000.01,NULL,'2022-10-19 08:42:12','2022-10-21 08:42:41','2022-10-21 08:42:41'),(407,7812,130,40720,1541,3,217,1,10864.75,NULL,'2022-10-19 08:42:25','2022-10-21 08:42:08','2022-10-21 08:42:08'),(408,7812,130,40720,1541,3,68,1,2281.60,NULL,'2022-10-19 08:42:25','2022-10-21 08:42:08','2022-10-21 08:42:08'),(409,7812,130,40720,1541,3,224,1,858.45,NULL,'2022-10-19 08:42:25','2022-10-21 08:42:08','2022-10-21 08:42:08'),(410,7812,130,40720,1541,3,57,2,14004.80,NULL,'2022-10-19 08:42:25','2022-10-21 08:42:08','2022-10-21 08:42:08'),(411,7812,131,40720,1540,3,217,1,9546.87,NULL,'2022-10-19 08:43:09','2022-10-19 08:43:09',NULL),(412,7812,131,40720,1540,3,68,1,2004.84,NULL,'2022-10-19 08:43:09','2022-10-19 08:43:09',NULL),(413,7812,131,40720,1540,3,224,1,1454.29,NULL,'2022-10-19 08:43:09','2022-10-19 08:43:09',NULL),(414,7812,131,40720,1540,3,57,2,13006.00,NULL,'2022-10-19 08:43:09','2022-10-19 08:43:09',NULL),(415,7812,132,40720,1540,3,217,1,3754.50,NULL,'2022-10-19 08:43:36','2022-10-19 08:43:36',NULL),(416,7812,132,40720,1540,3,68,1,788.45,NULL,'2022-10-19 08:43:36','2022-10-19 08:43:36',NULL),(417,7812,132,40720,1540,3,224,1,457.06,NULL,'2022-10-19 08:43:36','2022-10-19 08:43:36',NULL),(418,7812,132,40720,1540,3,57,2,5000.01,NULL,'2022-10-19 08:43:36','2022-10-19 08:43:36',NULL),(419,7812,133,40720,1540,3,217,1,11965.10,NULL,'2022-10-19 08:44:15','2022-10-19 08:44:15',NULL),(420,7812,133,40720,1540,3,68,1,2512.67,NULL,'2022-10-19 08:44:15','2022-10-19 08:44:15',NULL),(421,7812,133,40720,1540,3,224,1,1022.22,NULL,'2022-10-19 08:44:15','2022-10-19 08:44:15',NULL),(422,7812,133,40720,1540,3,57,2,15499.99,NULL,'2022-10-19 08:44:15','2022-10-19 08:44:15',NULL),(423,7812,134,40720,1540,3,217,1,3382.80,NULL,'2022-10-19 08:44:36','2022-10-19 08:44:36',NULL),(424,7812,134,40720,1540,3,68,1,710.39,NULL,'2022-10-19 08:44:36','2022-10-19 08:44:36',NULL),(425,7812,134,40720,1540,3,224,1,411.81,NULL,'2022-10-19 08:44:36','2022-10-19 08:44:36',NULL),(426,7812,134,40720,1540,3,57,2,4505.00,NULL,'2022-10-19 08:44:36','2022-10-19 08:44:36',NULL),(427,7812,135,40720,1540,3,217,1,5631.98,NULL,'2022-10-19 08:45:19','2022-10-19 08:45:19',NULL),(428,7812,135,40720,1540,3,68,1,1182.72,NULL,'2022-10-19 08:45:19','2022-10-19 08:45:19',NULL),(429,7812,135,40720,1540,3,224,1,685.61,NULL,'2022-10-19 08:45:19','2022-10-19 08:45:19',NULL),(430,7812,135,40720,1540,3,57,2,7500.31,NULL,'2022-10-19 08:45:19','2022-10-19 08:45:19',NULL),(431,7812,136,40720,1540,3,217,1,3752.24,NULL,'2022-10-19 08:45:46','2022-10-19 08:45:46',NULL),(432,7812,136,40720,1540,3,68,1,787.97,NULL,'2022-10-19 08:45:46','2022-10-19 08:45:46',NULL),(433,7812,136,40720,1540,3,224,1,467.39,NULL,'2022-10-19 08:45:46','2022-10-19 08:45:46',NULL),(434,7812,136,40720,1540,3,57,2,5007.60,NULL,'2022-10-19 08:45:46','2022-10-19 08:45:46',NULL),(435,7812,137,40720,1540,3,217,1,18122.97,NULL,'2022-10-19 08:46:22','2022-10-19 08:46:22',NULL),(436,7812,137,40720,1540,3,68,1,3805.82,NULL,'2022-10-19 08:46:22','2022-10-19 08:46:22',NULL),(437,7812,137,40720,1540,3,224,1,2074.11,NULL,'2022-10-19 08:46:22','2022-10-19 08:46:22',NULL),(438,7812,137,40720,1540,3,57,2,24002.90,NULL,'2022-10-19 08:46:22','2022-10-19 08:46:22',NULL),(439,7812,138,40720,1540,3,217,1,2504.11,NULL,'2022-10-19 08:46:49','2022-10-19 08:46:49',NULL),(440,7812,138,40720,1540,3,68,1,525.86,NULL,'2022-10-19 08:46:49','2022-10-19 08:46:49',NULL),(441,7812,138,40720,1540,3,224,1,470.53,NULL,'2022-10-19 08:46:49','2022-10-19 08:46:49',NULL);
INSERT INTO `balance_libro_details` VALUES (442,7812,138,40720,1540,3,57,2,3500.50,NULL,'2022-10-19 08:46:49','2022-10-19 08:46:49',NULL),(443,7812,139,40720,1540,2,96,2,2892.56,NULL,'2022-10-19 08:47:35','2022-10-19 08:47:35',NULL),(444,7812,139,40720,1540,2,67,2,607.44,NULL,'2022-10-19 08:47:35','2022-10-19 08:47:35',NULL),(445,7812,139,40720,1540,2,13,1,3500.00,NULL,'2022-10-19 08:47:35','2022-10-19 08:47:35',NULL),(446,7812,140,40720,1540,2,96,2,5785.12,NULL,'2022-10-19 08:48:00','2022-10-19 08:48:00',NULL),(447,7812,140,40720,1540,2,67,2,1214.88,NULL,'2022-10-19 08:48:00','2022-10-19 08:48:00',NULL),(448,7812,140,40720,1540,2,13,1,7000.00,NULL,'2022-10-19 08:48:00','2022-10-19 08:48:00',NULL),(449,7812,141,40720,1541,3,217,1,33949.40,NULL,'2022-10-19 09:01:50','2022-10-21 09:05:42','2022-10-21 09:05:42'),(450,7812,141,40720,1541,3,68,1,4050.64,NULL,'2022-10-19 09:01:50','2022-10-21 09:05:42','2022-10-21 09:05:42'),(451,7812,141,40720,1541,3,57,2,38000.04,NULL,'2022-10-19 09:01:50','2022-10-21 09:05:42','2022-10-21 09:05:42'),(452,7812,142,40720,1541,3,217,1,297.52,NULL,'2022-10-19 09:01:50','2022-10-19 09:01:50',NULL),(453,7812,142,40720,1541,3,68,1,62.48,NULL,'2022-10-19 09:01:50','2022-10-19 09:01:50',NULL),(454,7812,142,40720,1541,3,57,2,360.00,NULL,'2022-10-19 09:01:50','2022-10-19 09:01:50',NULL),(455,7812,143,40720,1533,15,67,1,1953.00,NULL,'2022-10-19 09:20:53','2022-10-19 09:20:53',NULL),(456,7812,143,40720,1533,15,68,2,13606.61,NULL,'2022-10-19 09:20:53','2022-10-19 09:20:53',NULL),(457,7812,143,40720,1533,15,353,2,12465.63,NULL,'2022-10-19 09:20:53','2022-10-19 09:20:53',NULL),(458,7812,143,40720,1533,15,353,1,287466.73,NULL,'2022-10-19 09:20:53','2022-10-19 09:20:53',NULL),(459,7812,143,40720,1533,15,136,2,263347.49,NULL,'2022-10-19 09:20:53','2022-10-19 09:20:53',NULL),(460,7812,144,40720,1534,15,68,2,1180.16,NULL,'2022-10-19 09:22:58','2022-10-19 09:22:58',NULL),(461,7812,144,40720,1534,15,353,2,287466.73,NULL,'2022-10-19 09:22:58','2022-10-19 09:22:58',NULL),(462,7812,144,40720,1534,15,353,1,288646.89,NULL,'2022-10-19 09:22:58','2022-10-19 09:22:58',NULL),(463,7812,145,40720,1535,2,96,2,10000.00,NULL,'2022-10-19 09:36:10','2022-10-19 09:56:07','2022-10-19 09:56:07'),(464,7812,145,40720,1535,2,67,2,2100.00,NULL,'2022-10-19 09:36:10','2022-10-19 09:56:07','2022-10-19 09:56:07'),(465,7812,145,40720,1535,2,13,1,12100.00,NULL,'2022-10-19 09:36:10','2022-10-19 09:56:07','2022-10-19 09:56:07'),(466,7812,146,40720,1535,2,96,2,4121.91,NULL,'2022-10-19 09:40:32','2022-10-19 09:56:00','2022-10-19 09:56:00'),(467,7812,146,40720,1535,2,67,2,865.60,NULL,'2022-10-19 09:40:32','2022-10-19 09:56:00','2022-10-19 09:56:00'),(468,7812,146,40720,1535,2,13,1,4987.51,NULL,'2022-10-19 09:40:32','2022-10-19 09:56:00','2022-10-19 09:56:00'),(469,7812,147,40720,1535,2,96,2,1652.90,NULL,'2022-10-19 09:41:36','2022-10-19 09:55:55','2022-10-19 09:55:55'),(470,7812,147,40720,1535,2,67,2,347.11,NULL,'2022-10-19 09:41:36','2022-10-19 09:55:55','2022-10-19 09:55:55'),(471,7812,147,40720,1535,2,13,1,2000.01,NULL,'2022-10-19 09:41:36','2022-10-19 09:55:55','2022-10-19 09:55:55'),(472,7812,148,40720,1535,2,96,2,20661.16,NULL,'2022-10-19 09:42:33','2022-10-19 09:55:47','2022-10-19 09:55:47'),(473,7812,148,40720,1535,2,67,2,4338.84,NULL,'2022-10-19 09:42:33','2022-10-19 09:55:47','2022-10-19 09:55:47'),(474,7812,148,40720,1535,2,13,1,25000.00,NULL,'2022-10-19 09:42:33','2022-10-19 09:55:47','2022-10-19 09:55:47'),(475,7812,149,40720,1535,2,96,2,7107.45,NULL,'2022-10-19 09:43:37','2022-10-19 09:55:40','2022-10-19 09:55:40'),(476,7812,149,40720,1535,2,67,2,1492.56,NULL,'2022-10-19 09:43:37','2022-10-19 09:55:40','2022-10-19 09:55:40'),(477,7812,149,40720,1535,2,13,1,8600.01,NULL,'2022-10-19 09:43:37','2022-10-19 09:55:40','2022-10-19 09:55:40'),(478,7812,150,40720,1535,15,68,2,9144.02,NULL,'2022-10-19 10:19:57','2022-10-19 10:19:57',NULL),(479,7812,150,40720,1535,15,353,2,288646.89,NULL,'2022-10-19 10:19:57','2022-10-19 10:19:57',NULL);
INSERT INTO `balance_libro_details` VALUES (480,7812,150,40720,1535,15,353,1,297790.91,NULL,'2022-10-19 10:19:57','2022-10-19 10:19:57',NULL),(481,7812,151,40720,1536,3,217,1,1487.60,NULL,'2022-10-19 10:23:50','2022-10-19 10:23:50',NULL),(482,7812,151,40720,1536,3,68,1,312.40,NULL,'2022-10-19 10:23:50','2022-10-19 10:23:50',NULL),(483,7812,151,40720,1536,3,57,2,1800.00,NULL,'2022-10-19 10:23:50','2022-10-19 10:23:50',NULL),(484,7812,152,40720,1536,15,68,2,312.40,NULL,'2022-10-19 10:24:35','2022-10-19 10:24:35',NULL),(485,7812,152,40720,1536,15,353,2,297790.91,NULL,'2022-10-19 10:24:35','2022-10-19 10:24:35',NULL),(486,7812,152,40720,1536,15,353,1,298103.31,NULL,'2022-10-19 10:24:35','2022-10-19 10:24:35',NULL),(487,7812,153,40720,1537,3,217,1,6198.35,NULL,'2022-10-19 10:28:13','2022-10-19 10:28:13',NULL),(488,7812,153,40720,1537,3,68,1,1301.65,NULL,'2022-10-19 10:28:13','2022-10-19 10:28:13',NULL),(489,7812,153,40720,1537,3,57,2,7500.00,NULL,'2022-10-19 10:28:13','2022-10-19 10:28:13',NULL),(490,7812,154,40720,1537,3,217,1,16694.21,NULL,'2022-10-19 10:28:13','2022-10-19 10:32:57','2022-10-19 10:32:57'),(491,7812,154,40720,1537,3,68,1,3505.78,NULL,'2022-10-19 10:28:13','2022-10-19 10:32:57','2022-10-19 10:32:57'),(492,7812,154,40720,1537,3,57,2,20199.99,NULL,'2022-10-19 10:28:13','2022-10-19 10:32:57','2022-10-19 10:32:57'),(493,7812,155,40720,1537,3,217,1,16694.15,NULL,'2022-10-19 10:32:57','2022-10-19 10:32:57',NULL),(494,7812,155,40720,1537,3,68,1,3505.77,NULL,'2022-10-19 10:32:57','2022-10-19 10:32:57',NULL),(495,7812,155,40720,1537,3,57,2,20199.92,NULL,'2022-10-19 10:32:57','2022-10-19 10:32:57',NULL),(496,7812,156,40720,1537,15,67,1,35507.82,NULL,'2022-10-19 10:34:40','2022-10-19 10:34:40',NULL),(497,7812,156,40720,1537,15,68,2,4807.43,NULL,'2022-10-19 10:34:40','2022-10-19 10:34:40',NULL),(498,7812,156,40720,1537,15,353,2,298103.31,NULL,'2022-10-19 10:34:40','2022-10-19 10:34:40',NULL),(499,7812,156,40720,1537,15,353,1,267402.91,NULL,'2022-10-19 10:34:40','2022-10-19 10:34:40',NULL),(500,7812,156,40720,1537,15,136,1,0.01,NULL,'2022-10-19 10:34:40','2022-10-19 10:34:40',NULL),(501,7812,157,40720,1538,3,217,1,41.32,NULL,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(502,7812,157,40720,1538,3,68,1,8.68,NULL,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(503,7812,157,40720,1538,3,57,2,50.00,NULL,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(504,7812,158,40720,1538,3,217,1,1157.02,NULL,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(505,7812,158,40720,1538,3,68,1,242.97,NULL,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(506,7812,158,40720,1538,3,57,2,1399.99,NULL,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(507,7812,159,40720,1538,3,217,1,495.87,NULL,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(508,7812,159,40720,1538,3,68,1,104.13,NULL,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(509,7812,159,40720,1538,3,57,2,600.00,NULL,'2022-10-19 10:40:22','2022-10-19 10:40:22',NULL),(510,7812,160,40720,1538,15,67,1,43653.91,NULL,'2022-10-19 10:41:28','2022-10-19 10:41:28',NULL),(511,7812,160,40720,1538,15,68,2,355.78,NULL,'2022-10-19 10:41:28','2022-10-19 10:41:28',NULL),(512,7812,160,40720,1538,15,353,2,267402.91,NULL,'2022-10-19 10:41:28','2022-10-19 10:41:28',NULL),(513,7812,160,40720,1538,15,353,1,224104.78,NULL,'2022-10-19 10:41:28','2022-10-19 10:41:28',NULL),(514,7812,161,40720,1539,3,250,1,3388.43,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(515,7812,161,40720,1539,3,68,1,711.57,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(516,7812,161,40720,1539,3,57,2,4100.00,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(517,7812,162,40720,1539,3,250,1,4462.81,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(518,7812,162,40720,1539,3,68,1,937.19,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(519,7812,162,40720,1539,3,57,2,5400.00,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(520,7812,163,40720,1539,3,250,1,59256.20,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL);
INSERT INTO `balance_libro_details` VALUES (521,7812,163,40720,1539,3,68,1,12443.80,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(522,7812,163,40720,1539,3,57,2,71700.00,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(523,7812,164,40720,1539,3,221,1,4592.40,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(524,7812,164,40720,1539,3,250,1,26201.43,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(525,7812,164,40720,1539,3,68,1,5502.30,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(526,7812,164,40720,1539,3,250,1,2296.18,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(527,7812,164,40720,1539,3,57,2,38592.31,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(528,7812,165,40720,1539,3,221,1,9184.82,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(529,7812,165,40720,1539,3,250,1,52403.05,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(530,7812,165,40720,1539,3,68,1,11004.64,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(531,7812,165,40720,1539,3,250,1,4592.41,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(532,7812,165,40720,1539,3,57,2,77184.92,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(533,7812,166,40720,1539,3,221,1,4592.40,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(534,7812,166,40720,1539,3,250,1,26201.43,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(535,7812,166,40720,1539,3,68,1,5502.30,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(536,7812,166,40720,1539,3,250,1,2296.18,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(537,7812,166,40720,1539,3,57,2,38592.31,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(538,7812,167,40720,1539,3,221,1,4592.40,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(539,7812,167,40720,1539,3,250,1,26201.43,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(540,7812,167,40720,1539,3,68,1,5502.30,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(541,7812,167,40720,1539,3,250,1,2296.18,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(542,7812,167,40720,1539,3,57,2,38592.31,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(543,7812,168,40720,1539,3,221,1,7466.82,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(544,7812,168,40720,1539,3,250,1,29972.38,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(545,7812,168,40720,1539,3,68,1,6294.20,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(546,7812,168,40720,1539,3,250,1,3733.43,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(547,7812,168,40720,1539,3,57,2,47466.83,NULL,'2022-10-19 11:29:39','2022-10-19 11:29:39',NULL),(548,7812,169,40720,1539,15,67,1,153447.84,NULL,'2022-10-19 11:38:25','2022-10-19 11:38:25',NULL),(549,7812,169,40720,1539,15,68,2,61811.85,NULL,'2022-10-19 11:38:25','2022-10-19 11:38:25',NULL),(550,7812,169,40720,1539,15,353,2,224104.78,NULL,'2022-10-19 11:38:25','2022-10-19 11:38:25',NULL),(551,7812,169,40720,1539,15,353,1,120970.12,NULL,'2022-10-19 11:38:25','2022-10-19 11:38:25',NULL),(552,7812,169,40720,1539,15,136,1,11498.67,NULL,'2022-10-19 11:38:25','2022-10-19 11:38:25',NULL),(553,7812,170,40720,1540,3,217,1,10404.96,NULL,'2022-10-20 09:55:55','2022-10-20 09:55:55',NULL),(554,7812,170,40720,1540,3,68,1,2185.04,NULL,'2022-10-20 09:55:55','2022-10-20 09:55:55',NULL),(555,7812,170,40720,1540,3,57,2,12590.00,NULL,'2022-10-20 09:55:55','2022-10-20 09:55:55',NULL),(556,7812,171,40720,1540,3,217,1,4217.55,NULL,'2022-10-20 09:57:53','2022-10-20 09:57:53',NULL),(557,7812,171,40720,1540,3,68,1,885.69,NULL,'2022-10-20 09:57:53','2022-10-20 09:57:53',NULL),(558,7812,171,40720,1540,3,224,1,899.66,NULL,'2022-10-20 09:57:53','2022-10-20 09:57:53',NULL),(559,7812,171,40720,1540,3,57,2,6002.90,NULL,'2022-10-20 09:57:53','2022-10-20 09:57:53',NULL),(560,7812,172,40720,1540,3,217,1,4480.18,NULL,'2022-10-20 09:58:32','2022-10-20 09:58:32',NULL),(561,7812,172,40720,1540,3,68,1,940.84,NULL,'2022-10-20 09:58:32','2022-10-20 09:58:32',NULL);
INSERT INTO `balance_libro_details` VALUES (562,7812,172,40720,1540,3,224,1,682.48,NULL,'2022-10-20 09:58:32','2022-10-20 09:58:32',NULL),(563,7812,172,40720,1540,3,57,2,6103.50,NULL,'2022-10-20 09:58:32','2022-10-20 09:58:32',NULL),(564,7812,173,40720,1540,3,217,1,2572.51,NULL,'2022-10-20 09:59:03','2022-10-20 09:59:03',NULL),(565,7812,173,40720,1540,3,68,1,540.23,NULL,'2022-10-20 09:59:03','2022-10-20 09:59:03',NULL),(566,7812,173,40720,1540,3,224,1,391.87,NULL,'2022-10-20 09:59:03','2022-10-20 09:59:03',NULL),(567,7812,173,40720,1540,3,57,2,3504.61,NULL,'2022-10-20 09:59:03','2022-10-20 09:59:03',NULL),(568,7812,174,40720,1540,3,217,1,11422.24,NULL,'2022-10-20 09:59:43','2022-10-20 09:59:43',NULL),(569,7812,174,40720,1540,3,68,1,2398.67,NULL,'2022-10-20 09:59:43','2022-10-20 09:59:43',NULL),(570,7812,174,40720,1540,3,224,1,1179.10,NULL,'2022-10-20 09:59:43','2022-10-20 09:59:43',NULL),(571,7812,174,40720,1540,3,57,2,15000.01,NULL,'2022-10-20 09:59:43','2022-10-20 09:59:43',NULL),(572,7812,175,40720,1540,3,217,1,10035.26,NULL,'2022-10-20 10:00:17','2022-10-20 10:00:17',NULL),(573,7812,175,40720,1540,3,68,1,2107.40,NULL,'2022-10-20 10:00:17','2022-10-20 10:00:17',NULL),(574,7812,175,40720,1540,3,224,1,857.34,NULL,'2022-10-20 10:00:17','2022-10-20 10:00:17',NULL),(575,7812,175,40720,1540,3,57,2,13000.00,NULL,'2022-10-20 10:00:17','2022-10-20 10:00:17',NULL),(576,7812,176,40720,1540,3,217,1,6781.52,NULL,'2022-10-20 10:00:58','2022-10-20 10:00:58',NULL),(577,7812,176,40720,1540,3,68,1,1424.12,NULL,'2022-10-20 10:00:58','2022-10-20 10:00:58',NULL),(578,7812,176,40720,1540,3,224,1,797.47,NULL,'2022-10-20 10:00:58','2022-10-20 10:00:58',NULL),(579,7812,176,40720,1540,3,57,2,9003.11,NULL,'2022-10-20 10:00:58','2022-10-20 10:00:58',NULL),(580,7812,177,40720,1540,3,217,1,6008.86,NULL,'2022-10-20 10:01:32','2022-10-20 10:01:32',NULL),(581,7812,177,40720,1540,3,68,1,1261.86,NULL,'2022-10-20 10:01:32','2022-10-20 10:01:32',NULL),(582,7812,177,40720,1540,3,224,1,731.49,NULL,'2022-10-20 10:01:32','2022-10-20 10:01:32',NULL),(583,7812,177,40720,1540,3,57,2,8002.21,NULL,'2022-10-20 10:01:32','2022-10-20 10:01:32',NULL),(584,7812,178,40720,1540,3,217,1,27072.32,NULL,'2022-10-20 10:02:17','2022-10-20 10:02:17',NULL),(585,7812,178,40720,1540,3,68,1,5685.19,NULL,'2022-10-20 10:02:17','2022-10-20 10:02:17',NULL),(586,7812,178,40720,1540,3,224,1,3295.68,NULL,'2022-10-20 10:02:17','2022-10-20 10:02:17',NULL),(587,7812,178,40720,1540,3,57,2,36053.19,NULL,'2022-10-20 10:02:17','2022-10-20 10:02:17',NULL),(588,7812,179,40720,1540,3,217,1,8110.61,NULL,'2022-10-20 10:03:20','2022-10-20 10:03:20',NULL),(589,7812,179,40720,1540,3,68,1,1703.23,NULL,'2022-10-20 10:03:20','2022-10-20 10:03:20',NULL),(590,7812,179,40720,1540,3,224,1,987.36,NULL,'2022-10-20 10:03:20','2022-10-20 10:03:20',NULL),(591,7812,179,40720,1540,3,57,2,10801.20,NULL,'2022-10-20 10:03:20','2022-10-20 10:03:20',NULL),(592,7812,180,40720,1540,3,217,1,7053.91,NULL,'2022-10-20 10:03:50','2022-10-20 10:03:50',NULL),(593,7812,180,40720,1540,3,68,1,1481.32,NULL,'2022-10-20 10:03:50','2022-10-20 10:03:50',NULL),(594,7812,180,40720,1540,3,224,1,1464.77,NULL,'2022-10-20 10:03:50','2022-10-20 10:03:50',NULL),(595,7812,180,40720,1540,3,57,2,10000.00,NULL,'2022-10-20 10:03:50','2022-10-20 10:03:50',NULL),(596,7812,181,40720,1540,3,217,1,30038.84,NULL,'2022-10-20 10:04:25','2022-10-20 10:04:25',NULL),(597,7812,181,40720,1540,3,68,1,6308.16,NULL,'2022-10-20 10:04:25','2022-10-20 10:04:25',NULL),(598,7812,181,40720,1540,3,224,1,3656.81,NULL,'2022-10-20 10:04:25','2022-10-20 10:04:25',NULL),(599,7812,181,40720,1540,3,57,2,40003.81,NULL,'2022-10-20 10:04:25','2022-10-20 10:04:25',NULL),(600,7812,182,40720,1540,3,217,1,2810.35,NULL,'2022-10-20 10:05:46','2022-10-20 10:05:46',NULL),(601,7812,182,40720,1540,3,68,1,590.17,NULL,'2022-10-20 10:05:46','2022-10-20 10:05:46',NULL),(602,7812,182,40720,1540,3,224,1,599.48,NULL,'2022-10-20 10:05:46','2022-10-20 10:05:46',NULL);
INSERT INTO `balance_libro_details` VALUES (603,7812,182,40720,1540,3,57,2,4000.00,NULL,'2022-10-20 10:05:46','2022-10-20 10:05:46',NULL),(604,7812,183,40720,1540,3,217,1,11403.50,NULL,'2022-10-20 10:06:39','2022-10-20 10:14:04','2022-10-20 10:14:04'),(605,7812,183,40720,1540,3,68,1,2394.74,NULL,'2022-10-20 10:06:39','2022-10-20 10:14:04','2022-10-20 10:14:04'),(606,7812,183,40720,1540,3,224,1,1211.58,NULL,'2022-10-20 10:06:39','2022-10-20 10:14:04','2022-10-20 10:14:04'),(607,7812,183,40720,1540,3,57,2,15009.82,NULL,'2022-10-20 10:06:39','2022-10-20 10:14:04','2022-10-20 10:14:04'),(608,7812,184,40720,1540,3,217,1,14987.62,NULL,'2022-10-20 10:07:07','2022-10-20 10:13:35','2022-10-20 10:13:35'),(609,7812,184,40720,1540,3,68,1,3147.40,NULL,'2022-10-20 10:07:07','2022-10-20 10:13:35','2022-10-20 10:13:35'),(610,7812,184,40720,1540,3,224,1,1866.88,NULL,'2022-10-20 10:07:07','2022-10-20 10:13:35','2022-10-20 10:13:35'),(611,7812,184,40720,1540,3,57,2,20001.90,NULL,'2022-10-20 10:07:07','2022-10-20 10:13:35','2022-10-20 10:13:35'),(612,7812,185,40720,1540,3,217,1,9066.05,NULL,'2022-10-20 10:07:52','2022-10-20 10:07:52',NULL),(613,7812,185,40720,1540,3,68,1,1903.87,NULL,'2022-10-20 10:07:52','2022-10-20 10:07:52',NULL),(614,7812,185,40720,1540,3,224,1,1037.58,NULL,'2022-10-20 10:07:52','2022-10-20 10:07:52',NULL),(615,7812,185,40720,1540,3,57,2,12007.50,NULL,'2022-10-20 10:07:52','2022-10-20 10:07:52',NULL),(616,7812,186,40720,1540,3,217,1,8991.72,NULL,'2022-10-20 10:08:18','2022-10-20 10:08:18',NULL),(617,7812,186,40720,1540,3,68,1,1888.26,NULL,'2022-10-20 10:08:18','2022-10-20 10:08:18',NULL),(618,7812,186,40720,1540,3,224,1,1120.02,NULL,'2022-10-20 10:08:18','2022-10-20 10:08:18',NULL),(619,7812,186,40720,1540,3,57,2,12000.00,NULL,'2022-10-20 10:08:18','2022-10-20 10:08:18',NULL),(620,7812,187,40720,1540,3,217,1,6040.26,NULL,'2022-10-20 10:09:03','2022-10-20 10:09:03',NULL),(621,7812,187,40720,1540,3,68,1,1268.45,NULL,'2022-10-20 10:09:03','2022-10-20 10:09:03',NULL),(622,7812,187,40720,1540,3,224,1,691.29,NULL,'2022-10-20 10:09:03','2022-10-20 10:09:03',NULL),(623,7812,187,40720,1540,3,57,2,8000.00,NULL,'2022-10-20 10:09:03','2022-10-20 10:09:03',NULL),(624,7812,188,40720,1541,3,217,1,7550.33,NULL,'2022-10-20 10:09:56','2022-10-21 08:37:05','2022-10-21 08:37:05'),(625,7812,188,40720,1541,3,68,1,1585.57,NULL,'2022-10-20 10:09:56','2022-10-21 08:37:05','2022-10-21 08:37:05'),(626,7812,188,40720,1541,3,224,1,864.10,NULL,'2022-10-20 10:09:56','2022-10-21 08:37:05','2022-10-21 08:37:05'),(627,7812,188,40720,1541,3,57,2,10000.00,NULL,'2022-10-20 10:09:56','2022-10-21 08:37:05','2022-10-21 08:37:05'),(628,7812,189,40720,1540,3,217,1,14987.62,NULL,'2022-10-20 10:13:35','2022-10-20 10:13:35',NULL),(629,7812,189,40720,1540,3,68,1,3147.40,NULL,'2022-10-20 10:13:35','2022-10-20 10:13:35',NULL),(630,7812,189,40720,1540,3,224,1,1866.88,NULL,'2022-10-20 10:13:35','2022-10-20 10:13:35',NULL),(631,7812,189,40720,1540,3,57,2,20001.90,NULL,'2022-10-20 10:13:35','2022-10-20 10:13:35',NULL),(632,7812,190,40720,1540,3,217,1,11403.50,NULL,'2022-10-20 10:14:04','2022-10-20 10:14:04',NULL),(633,7812,190,40720,1540,3,68,1,2394.74,NULL,'2022-10-20 10:14:04','2022-10-20 10:14:04',NULL),(634,7812,190,40720,1540,3,224,1,1211.58,NULL,'2022-10-20 10:14:04','2022-10-20 10:14:04',NULL),(635,7812,190,40720,1540,3,57,2,15009.82,NULL,'2022-10-20 10:14:04','2022-10-20 10:14:04',NULL),(636,7812,191,40720,1542,2,96,2,4836.26,NULL,'2022-10-20 12:47:40','2022-12-09 09:27:23','2022-12-09 09:27:23'),(637,7812,191,40720,1542,2,67,2,1015.61,NULL,'2022-10-20 12:47:40','2022-12-09 09:27:23','2022-12-09 09:27:23'),(638,7812,191,40720,1542,2,224,2,648.13,NULL,'2022-10-20 12:47:40','2022-12-09 09:27:23','2022-12-09 09:27:23'),(639,7812,191,40720,1542,2,13,1,6500.00,NULL,'2022-10-20 12:47:40','2022-12-09 09:27:23','2022-12-09 09:27:23'),(640,7812,192,40720,1540,7,25,1,92.63,NULL,'2022-10-21 08:02:48','2022-10-21 08:02:48',NULL),(641,7812,192,40720,1540,7,13,2,92.63,NULL,'2022-10-21 08:02:48','2022-10-21 08:02:48',NULL);
INSERT INTO `balance_libro_details` VALUES (642,7812,193,40720,1540,15,67,1,281924.97,NULL,'2022-10-21 08:18:07','2022-10-21 08:18:07',NULL),(643,7812,193,40720,1540,15,68,2,73516.50,NULL,'2022-10-21 08:18:07','2022-10-21 08:18:07',NULL),(644,7812,193,40720,1540,15,353,2,120970.12,NULL,'2022-10-21 08:18:07','2022-10-21 08:18:07',NULL),(645,7812,193,40720,1540,15,25,2,92.63,NULL,'2022-10-21 08:18:07','2022-10-21 08:18:07',NULL),(646,7812,193,40720,1540,15,74,2,87345.72,NULL,'2022-10-21 08:18:07','2022-10-21 08:18:07',NULL),(647,7812,194,40720,1541,3,217,1,7550.33,NULL,'2022-10-21 08:37:05','2022-10-21 09:18:35','2022-10-21 09:18:35'),(648,7812,194,40720,1541,3,68,1,1585.57,NULL,'2022-10-21 08:37:05','2022-10-21 09:18:35','2022-10-21 09:18:35'),(649,7812,194,40720,1541,3,221,1,864.10,NULL,'2022-10-21 08:37:05','2022-10-21 09:18:35','2022-10-21 09:18:35'),(650,7812,194,40720,1541,3,57,2,10000.00,NULL,'2022-10-21 08:37:05','2022-10-21 09:18:35','2022-10-21 09:18:35'),(651,7812,195,40720,1541,3,217,1,765.48,NULL,'2022-10-21 08:39:39','2022-10-21 08:39:39',NULL),(652,7812,195,40720,1541,3,68,1,160.75,NULL,'2022-10-21 08:39:39','2022-10-21 08:39:39',NULL),(653,7812,195,40720,1541,3,221,1,74.23,NULL,'2022-10-21 08:39:39','2022-10-21 08:39:39',NULL),(654,7812,195,40720,1541,3,57,2,1000.46,NULL,'2022-10-21 08:39:39','2022-10-21 08:39:39',NULL),(655,7812,196,40720,1541,3,217,1,12839.55,NULL,'2022-10-21 08:40:14','2022-10-21 08:40:14',NULL),(656,7812,196,40720,1541,3,68,1,2696.31,NULL,'2022-10-21 08:40:14','2022-10-21 08:40:14',NULL),(657,7812,196,40720,1541,3,221,1,1469.44,NULL,'2022-10-21 08:40:14','2022-10-21 08:40:14',NULL),(658,7812,196,40720,1541,3,57,2,17005.30,NULL,'2022-10-21 08:40:14','2022-10-21 08:40:14',NULL),(659,7812,197,40720,1541,3,217,1,3576.79,NULL,'2022-10-21 08:40:40','2022-10-21 08:40:40',NULL),(660,7812,197,40720,1541,3,68,1,751.13,NULL,'2022-10-21 08:40:40','2022-10-21 08:40:40',NULL),(661,7812,197,40720,1541,3,221,1,672.09,NULL,'2022-10-21 08:40:40','2022-10-21 08:40:40',NULL),(662,7812,197,40720,1541,3,57,2,5000.01,NULL,'2022-10-21 08:40:40','2022-10-21 08:40:40',NULL),(663,7812,198,40720,1541,3,217,1,10570.45,NULL,'2022-10-21 08:41:11','2022-10-21 08:41:11',NULL),(664,7812,198,40720,1541,3,68,1,2219.79,NULL,'2022-10-21 08:41:11','2022-10-21 08:41:11',NULL),(665,7812,198,40720,1541,3,221,1,1209.75,NULL,'2022-10-21 08:41:11','2022-10-21 08:41:11',NULL),(666,7812,198,40720,1541,3,57,2,13999.99,NULL,'2022-10-21 08:41:11','2022-10-21 08:41:11',NULL),(667,7812,199,40720,1541,3,217,1,11325.49,NULL,'2022-10-21 08:41:43','2022-10-21 08:41:43',NULL),(668,7812,199,40720,1541,3,68,1,2378.35,NULL,'2022-10-21 08:41:43','2022-10-21 08:41:43',NULL),(669,7812,199,40720,1541,3,221,1,1296.16,NULL,'2022-10-21 08:41:43','2022-10-21 08:41:43',NULL),(670,7812,199,40720,1541,3,57,2,15000.00,NULL,'2022-10-21 08:41:43','2022-10-21 08:41:43',NULL),(671,7812,200,40720,1541,3,217,1,10864.75,NULL,'2022-10-21 08:42:08','2022-10-21 08:42:08',NULL),(672,7812,200,40720,1541,3,68,1,2281.60,NULL,'2022-10-21 08:42:08','2022-10-21 08:42:08',NULL),(673,7812,200,40720,1541,3,221,1,858.45,NULL,'2022-10-21 08:42:08','2022-10-21 08:42:08',NULL),(674,7812,200,40720,1541,3,57,2,14004.80,NULL,'2022-10-21 08:42:08','2022-10-21 08:42:08',NULL),(675,7812,201,40720,1541,3,217,1,9060.40,NULL,'2022-10-21 08:42:41','2022-10-21 08:42:41',NULL),(676,7812,201,40720,1541,3,68,1,1902.68,NULL,'2022-10-21 08:42:41','2022-10-21 08:42:41',NULL),(677,7812,201,40720,1541,3,221,1,1036.93,NULL,'2022-10-21 08:42:41','2022-10-21 08:42:41',NULL),(678,7812,201,40720,1541,3,57,2,12000.01,NULL,'2022-10-21 08:42:41','2022-10-21 08:42:41',NULL),(679,7812,202,40720,1541,3,217,1,3576.79,NULL,'2022-10-21 08:43:10','2022-10-21 08:43:10',NULL),(680,7812,202,40720,1541,3,68,1,751.13,NULL,'2022-10-21 08:43:10','2022-10-21 08:43:10',NULL),(681,7812,202,40720,1541,3,221,1,672.09,NULL,'2022-10-21 08:43:10','2022-10-21 08:43:10',NULL),(682,7812,202,40720,1541,3,57,2,5000.01,NULL,'2022-10-21 08:43:10','2022-10-21 08:43:10',NULL);
INSERT INTO `balance_libro_details` VALUES (683,7812,203,40720,1541,3,217,1,9816.48,NULL,'2022-10-21 08:43:36','2022-10-21 08:43:36',NULL),(684,7812,203,40720,1541,3,68,1,2061.46,NULL,'2022-10-21 08:43:36','2022-10-21 08:43:36',NULL),(685,7812,203,40720,1541,3,221,1,1123.46,NULL,'2022-10-21 08:43:36','2022-10-21 08:43:36',NULL),(686,7812,203,40720,1541,3,57,2,13001.40,NULL,'2022-10-21 08:43:36','2022-10-21 08:43:36',NULL),(687,7812,204,40720,1541,3,217,1,4628.12,NULL,'2022-10-21 09:05:42','2022-10-21 09:05:42',NULL),(688,7812,204,40720,1541,3,68,1,971.91,NULL,'2022-10-21 09:05:42','2022-10-21 09:05:42',NULL),(689,7812,204,40720,1541,3,217,1,29321.28,NULL,'2022-10-21 09:05:42','2022-10-21 09:05:42',NULL),(690,7812,204,40720,1541,3,68,1,3078.73,NULL,'2022-10-21 09:05:42','2022-10-21 09:05:42',NULL),(691,7812,204,40720,1541,3,57,2,38000.04,NULL,'2022-10-21 09:05:42','2022-10-21 09:05:42',NULL),(692,7812,205,40720,1541,3,217,1,7550.37,NULL,'2022-10-21 09:18:35','2022-10-21 09:18:35',NULL),(693,7812,205,40720,1541,3,68,1,1585.58,NULL,'2022-10-21 09:18:35','2022-10-21 09:18:35',NULL),(694,7812,205,40720,1541,3,221,1,864.10,NULL,'2022-10-21 09:18:35','2022-10-21 09:18:35',NULL),(695,7812,205,40720,1541,3,57,2,10000.05,NULL,'2022-10-21 09:18:35','2022-10-21 09:18:35',NULL),(696,7812,206,40720,1541,15,68,2,24750.86,NULL,'2022-10-21 09:21:00','2022-10-21 09:21:00',NULL),(697,7812,206,40720,1541,15,353,1,24750.85,NULL,'2022-10-21 09:21:00','2022-10-21 09:21:00',NULL),(698,7812,206,40720,1541,15,136,1,0.01,NULL,'2022-10-21 09:21:00','2022-10-21 09:21:00',NULL),(699,7812,207,40720,1542,2,96,2,9371.90,NULL,'2022-12-09 09:03:21','2022-12-09 09:27:14','2022-12-09 09:27:14'),(700,7812,207,40720,1542,2,67,2,1968.10,NULL,'2022-12-09 09:03:21','2022-12-09 09:27:14','2022-12-09 09:27:14'),(701,7812,207,40720,1542,2,13,1,11340.00,NULL,'2022-12-09 09:03:21','2022-12-09 09:27:14','2022-12-09 09:27:14'),(702,7812,208,40720,1542,2,96,2,22321.21,NULL,'2022-12-09 09:05:22','2022-12-09 09:27:09','2022-12-09 09:27:09'),(703,7812,208,40720,1542,2,67,2,4687.45,NULL,'2022-12-09 09:05:22','2022-12-09 09:27:09','2022-12-09 09:27:09'),(704,7812,208,40720,1542,2,222,2,2991.36,NULL,'2022-12-09 09:05:22','2022-12-09 09:27:09','2022-12-09 09:27:09'),(705,7812,208,40720,1542,2,13,1,30000.02,NULL,'2022-12-09 09:05:22','2022-12-09 09:27:09','2022-12-09 09:27:09'),(706,7812,209,40720,1542,2,96,2,14049.58,NULL,'2022-12-09 09:07:26','2022-12-09 09:27:04','2022-12-09 09:27:04'),(707,7812,209,40720,1542,2,67,2,2950.41,NULL,'2022-12-09 09:07:26','2022-12-09 09:27:04','2022-12-09 09:27:04'),(708,7812,209,40720,1542,2,13,1,16999.99,NULL,'2022-12-09 09:07:26','2022-12-09 09:27:04','2022-12-09 09:27:04'),(709,7812,210,40720,1542,2,96,2,2087.19,NULL,'2022-12-09 09:12:12','2022-12-09 09:26:59','2022-12-09 09:26:59'),(710,7812,210,40720,1542,2,67,2,438.31,NULL,'2022-12-09 09:12:12','2022-12-09 09:26:59','2022-12-09 09:26:59'),(711,7812,210,40720,1542,2,221,2,474.50,NULL,'2022-12-09 09:12:12','2022-12-09 09:26:59','2022-12-09 09:26:59'),(712,7812,210,40720,1542,2,13,1,3000.00,NULL,'2022-12-09 09:12:12','2022-12-09 09:26:59','2022-12-09 09:26:59'),(713,7812,211,40720,1542,2,96,2,22321.87,NULL,'2022-12-09 09:12:58','2022-12-09 09:26:55','2022-12-09 09:26:55'),(714,7812,211,40720,1542,2,67,2,4687.59,NULL,'2022-12-09 09:12:58','2022-12-09 09:26:55','2022-12-09 09:26:55'),(715,7812,211,40720,1542,2,221,2,2991.44,NULL,'2022-12-09 09:12:58','2022-12-09 09:26:55','2022-12-09 09:26:55'),(716,7812,211,40720,1542,2,13,1,30000.90,NULL,'2022-12-09 09:12:58','2022-12-09 09:26:55','2022-12-09 09:26:55'),(717,7812,212,40720,1542,2,96,2,10751.68,NULL,'2022-12-09 09:13:55','2022-12-09 09:26:49','2022-12-09 09:26:49'),(718,7812,212,40720,1542,2,67,2,2257.85,NULL,'2022-12-09 09:13:55','2022-12-09 09:26:49','2022-12-09 09:26:49'),(719,7812,212,40720,1542,2,221,2,990.47,NULL,'2022-12-09 09:13:55','2022-12-09 09:26:49','2022-12-09 09:26:49'),(720,7812,212,40720,1542,2,13,1,14000.00,NULL,'2022-12-09 09:13:55','2022-12-09 09:26:49','2022-12-09 09:26:49');
INSERT INTO `balance_libro_details` VALUES (721,7812,213,40720,1542,2,96,2,7440.40,NULL,'2022-12-09 09:14:55','2022-12-09 09:26:44','2022-12-09 09:26:44'),(722,7812,213,40720,1542,2,67,2,1562.48,NULL,'2022-12-09 09:14:55','2022-12-09 09:26:44','2022-12-09 09:26:44'),(723,7812,213,40720,1542,2,221,2,997.12,NULL,'2022-12-09 09:14:55','2022-12-09 09:26:44','2022-12-09 09:26:44'),(724,7812,213,40720,1542,2,13,1,10000.00,NULL,'2022-12-09 09:14:55','2022-12-09 09:26:44','2022-12-09 09:26:44'),(725,7812,214,40720,1542,2,96,2,9533.24,NULL,'2022-12-09 09:16:05','2022-12-09 09:26:39','2022-12-09 09:26:39'),(726,7812,214,40720,1542,2,67,2,2001.98,NULL,'2022-12-09 09:16:05','2022-12-09 09:26:39','2022-12-09 09:26:39'),(727,7812,214,40720,1542,2,221,2,1472.38,NULL,'2022-12-09 09:16:05','2022-12-09 09:26:39','2022-12-09 09:26:39'),(728,7812,214,40720,1542,2,13,1,13007.60,NULL,'2022-12-09 09:16:05','2022-12-09 09:26:39','2022-12-09 09:26:39'),(729,7812,215,40720,1542,2,96,2,1391.47,NULL,'2022-12-09 09:16:54','2022-12-09 09:26:34','2022-12-09 09:26:34'),(730,7812,215,40720,1542,2,67,2,292.21,NULL,'2022-12-09 09:16:54','2022-12-09 09:26:34','2022-12-09 09:26:34'),(731,7812,215,40720,1542,2,221,2,316.33,NULL,'2022-12-09 09:16:54','2022-12-09 09:26:34','2022-12-09 09:26:34'),(732,7812,215,40720,1542,2,13,1,2000.01,NULL,'2022-12-09 09:16:54','2022-12-09 09:26:34','2022-12-09 09:26:34'),(733,7812,216,40720,1542,2,96,2,5223.75,NULL,'2022-12-09 09:17:30','2022-12-09 09:26:29','2022-12-09 09:26:29'),(734,7812,216,40720,1542,2,67,2,1096.99,NULL,'2022-12-09 09:17:30','2022-12-09 09:26:29','2022-12-09 09:26:29'),(735,7812,216,40720,1542,2,221,2,700.06,NULL,'2022-12-09 09:17:30','2022-12-09 09:26:29','2022-12-09 09:26:29'),(736,7812,216,40720,1542,2,13,1,7020.80,NULL,'2022-12-09 09:17:30','2022-12-09 09:26:29','2022-12-09 09:26:29'),(737,7812,217,40720,1542,2,96,2,23040.32,NULL,'2022-12-09 09:18:07','2022-12-09 09:26:24','2022-12-09 09:26:24'),(738,7812,217,40720,1542,2,67,2,4838.47,NULL,'2022-12-09 09:18:07','2022-12-09 09:26:24','2022-12-09 09:26:24'),(739,7812,217,40720,1542,2,221,2,2122.52,NULL,'2022-12-09 09:18:07','2022-12-09 09:26:24','2022-12-09 09:26:24'),(740,7812,217,40720,1542,2,13,1,30001.31,NULL,'2022-12-09 09:18:07','2022-12-09 09:26:24','2022-12-09 09:26:24'),(741,7812,218,40720,1542,2,96,2,10416.55,NULL,'2022-12-09 09:18:57','2022-12-09 09:26:19','2022-12-09 09:26:19'),(742,7812,218,40720,1542,2,67,2,2187.48,NULL,'2022-12-09 09:18:57','2022-12-09 09:26:19','2022-12-09 09:26:19'),(743,7812,218,40720,1542,2,221,2,1395.97,NULL,'2022-12-09 09:18:57','2022-12-09 09:26:19','2022-12-09 09:26:19'),(744,7812,218,40720,1542,2,13,1,14000.00,NULL,'2022-12-09 09:18:57','2022-12-09 09:26:19','2022-12-09 09:26:19'),(745,7812,219,40720,1542,2,96,2,9674.75,NULL,'2022-12-09 09:19:38','2022-12-09 09:26:13','2022-12-09 09:26:13'),(746,7812,219,40720,1542,2,67,2,2031.70,NULL,'2022-12-09 09:19:38','2022-12-09 09:26:13','2022-12-09 09:26:13'),(747,7812,219,40720,1542,2,221,2,1296.55,NULL,'2022-12-09 09:19:38','2022-12-09 09:26:13','2022-12-09 09:26:13'),(748,7812,219,40720,1542,2,13,1,13003.00,NULL,'2022-12-09 09:19:38','2022-12-09 09:26:13','2022-12-09 09:26:13'),(749,7812,220,40720,1542,2,96,2,3478.66,NULL,'2022-12-09 09:21:40','2022-12-09 09:26:08','2022-12-09 09:26:08'),(750,7812,220,40720,1542,2,67,2,730.52,NULL,'2022-12-09 09:21:40','2022-12-09 09:26:08','2022-12-09 09:26:08'),(751,7812,220,40720,1542,2,221,2,790.83,NULL,'2022-12-09 09:21:40','2022-12-09 09:26:08','2022-12-09 09:26:08'),(752,7812,220,40720,1542,2,13,1,5000.01,NULL,'2022-12-09 09:21:40','2022-12-09 09:26:08','2022-12-09 09:26:08'),(753,7812,221,40720,1542,2,96,2,8448.68,NULL,'2022-12-09 09:23:07','2022-12-09 09:26:02','2022-12-09 09:26:02'),(754,7812,221,40720,1542,2,67,2,1774.22,NULL,'2022-12-09 09:23:07','2022-12-09 09:26:02','2022-12-09 09:26:02'),(755,7812,221,40720,1542,2,221,2,778.31,NULL,'2022-12-09 09:23:07','2022-12-09 09:26:02','2022-12-09 09:26:02');
INSERT INTO `balance_libro_details` VALUES (756,7812,221,40720,1542,2,13,1,11001.21,NULL,'2022-12-09 09:23:07','2022-12-09 09:26:02','2022-12-09 09:26:02'),(757,7812,222,40720,1542,2,96,2,8928.47,NULL,'2022-12-09 09:23:51','2022-12-09 09:25:57','2022-12-09 09:25:57'),(758,7812,222,40720,1542,2,67,2,1874.98,NULL,'2022-12-09 09:23:51','2022-12-09 09:25:57','2022-12-09 09:25:57'),(759,7812,222,40720,1542,2,221,2,1196.54,NULL,'2022-12-09 09:23:51','2022-12-09 09:25:57','2022-12-09 09:25:57'),(760,7812,222,40720,1542,2,13,1,11999.99,NULL,'2022-12-09 09:23:51','2022-12-09 09:25:57','2022-12-09 09:25:57'),(761,7812,223,40720,1542,2,96,2,8699.85,NULL,'2022-12-09 09:24:46','2022-12-09 09:25:51','2022-12-09 09:25:51'),(762,7812,223,40720,1542,2,67,2,1826.97,NULL,'2022-12-09 09:24:46','2022-12-09 09:25:51','2022-12-09 09:25:51'),(763,7812,223,40720,1542,2,221,2,972.88,NULL,'2022-12-09 09:24:46','2022-12-09 09:25:51','2022-12-09 09:25:51'),(764,7812,223,40720,1542,2,13,1,11499.70,NULL,'2022-12-09 09:24:46','2022-12-09 09:25:51','2022-12-09 09:25:51'),(765,7812,224,40720,1542,3,217,1,9371.90,NULL,'2022-12-09 09:32:38','2022-12-09 09:32:38',NULL),(766,7812,224,40720,1542,3,68,1,1968.10,NULL,'2022-12-09 09:32:38','2022-12-09 09:32:38',NULL),(767,7812,224,40720,1542,3,57,2,11340.00,NULL,'2022-12-09 09:32:38','2022-12-09 09:32:38',NULL),(768,7812,225,40720,1542,3,217,1,22321.21,NULL,'2022-12-09 09:34:03','2022-12-09 09:34:03',NULL),(769,7812,225,40720,1542,3,68,1,4687.45,NULL,'2022-12-09 09:34:03','2022-12-09 09:34:03',NULL),(770,7812,225,40720,1542,3,221,1,2991.36,NULL,'2022-12-09 09:34:03','2022-12-09 09:34:03',NULL),(771,7812,225,40720,1542,3,57,2,30000.02,NULL,'2022-12-09 09:34:03','2022-12-09 09:34:03',NULL),(772,7812,226,40720,1542,3,217,1,14049.58,NULL,'2022-12-09 09:34:59','2022-12-09 09:34:59',NULL),(773,7812,226,40720,1542,3,68,1,2950.41,NULL,'2022-12-09 09:34:59','2022-12-09 09:34:59',NULL),(774,7812,226,40720,1542,3,57,2,16999.99,NULL,'2022-12-09 09:34:59','2022-12-09 09:34:59',NULL),(775,7812,227,40720,1542,3,217,1,2087.19,NULL,'2022-12-09 09:36:03','2022-12-09 09:36:03',NULL),(776,7812,227,40720,1542,3,68,1,438.31,NULL,'2022-12-09 09:36:03','2022-12-09 09:36:03',NULL),(777,7812,227,40720,1542,3,221,1,474.50,NULL,'2022-12-09 09:36:03','2022-12-09 09:36:03',NULL),(778,7812,227,40720,1542,3,57,2,3000.00,NULL,'2022-12-09 09:36:03','2022-12-09 09:36:03',NULL),(779,7812,228,40720,1542,3,217,1,22321.87,NULL,'2022-12-09 09:36:38','2022-12-09 09:36:38',NULL),(780,7812,228,40720,1542,3,68,1,4687.59,NULL,'2022-12-09 09:36:38','2022-12-09 09:36:38',NULL),(781,7812,228,40720,1542,3,221,1,2991.44,NULL,'2022-12-09 09:36:38','2022-12-09 09:36:38',NULL),(782,7812,228,40720,1542,3,57,2,30000.90,NULL,'2022-12-09 09:36:38','2022-12-09 09:36:38',NULL),(783,7812,229,40720,1542,3,217,1,10751.68,NULL,'2022-12-09 09:37:17','2022-12-09 09:37:17',NULL),(784,7812,229,40720,1542,3,68,1,2257.85,NULL,'2022-12-09 09:37:17','2022-12-09 09:37:17',NULL),(785,7812,229,40720,1542,3,221,1,990.47,NULL,'2022-12-09 09:37:17','2022-12-09 09:37:17',NULL),(786,7812,229,40720,1542,3,57,2,14000.00,NULL,'2022-12-09 09:37:17','2022-12-09 09:37:17',NULL),(787,7812,230,40720,1542,3,217,1,7440.40,NULL,'2022-12-09 09:38:00','2022-12-09 09:38:00',NULL),(788,7812,230,40720,1542,3,68,1,1562.48,NULL,'2022-12-09 09:38:00','2022-12-09 09:38:00',NULL),(789,7812,230,40720,1542,3,221,1,997.12,NULL,'2022-12-09 09:38:00','2022-12-09 09:38:00',NULL),(790,7812,230,40720,1542,3,57,2,10000.00,NULL,'2022-12-09 09:38:00','2022-12-09 09:38:00',NULL),(791,7812,231,40720,1542,3,217,1,9533.24,NULL,'2022-12-09 09:38:36','2022-12-09 09:38:36',NULL),(792,7812,231,40720,1542,3,68,1,2001.98,NULL,'2022-12-09 09:38:36','2022-12-09 09:38:36',NULL),(793,7812,231,40720,1542,3,221,1,1472.38,NULL,'2022-12-09 09:38:36','2022-12-09 09:38:36',NULL),(794,7812,231,40720,1542,3,57,2,13007.60,NULL,'2022-12-09 09:38:36','2022-12-09 09:38:36',NULL),(795,7812,232,40720,1542,3,217,1,1391.47,NULL,'2022-12-09 09:39:04','2022-12-09 09:39:04',NULL);
INSERT INTO `balance_libro_details` VALUES (796,7812,232,40720,1542,3,68,1,292.21,NULL,'2022-12-09 09:39:04','2022-12-09 09:39:04',NULL),(797,7812,232,40720,1542,3,221,1,316.33,NULL,'2022-12-09 09:39:04','2022-12-09 09:39:04',NULL),(798,7812,232,40720,1542,3,57,2,2000.01,NULL,'2022-12-09 09:39:04','2022-12-09 09:39:04',NULL),(799,7812,233,40720,1542,3,217,1,5223.75,NULL,'2022-12-09 09:39:39','2022-12-09 09:39:39',NULL),(800,7812,233,40720,1542,3,68,1,1096.99,NULL,'2022-12-09 09:39:39','2022-12-09 09:39:39',NULL),(801,7812,233,40720,1542,3,221,1,700.06,NULL,'2022-12-09 09:39:39','2022-12-09 09:39:39',NULL),(802,7812,233,40720,1542,3,57,2,7020.80,NULL,'2022-12-09 09:39:39','2022-12-09 09:39:39',NULL),(803,7812,234,40720,1542,3,217,1,23040.32,NULL,'2022-12-09 09:40:10','2022-12-09 09:40:10',NULL),(804,7812,234,40720,1542,3,68,1,4838.47,NULL,'2022-12-09 09:40:10','2022-12-09 09:40:10',NULL),(805,7812,234,40720,1542,3,221,1,2122.52,NULL,'2022-12-09 09:40:10','2022-12-09 09:40:10',NULL),(806,7812,234,40720,1542,3,57,2,30001.31,NULL,'2022-12-09 09:40:10','2022-12-09 09:40:10',NULL),(807,7812,235,40720,1542,3,217,1,10416.55,NULL,'2022-12-09 09:41:02','2022-12-09 09:41:02',NULL),(808,7812,235,40720,1542,3,68,1,2187.48,NULL,'2022-12-09 09:41:02','2022-12-09 09:41:02',NULL),(809,7812,235,40720,1542,3,221,1,1395.97,NULL,'2022-12-09 09:41:02','2022-12-09 09:41:02',NULL),(810,7812,235,40720,1542,3,57,2,14000.00,NULL,'2022-12-09 09:41:02','2022-12-09 09:41:02',NULL),(811,7812,236,40720,1542,3,217,1,9674.75,NULL,'2022-12-09 09:41:39','2022-12-09 09:41:39',NULL),(812,7812,236,40720,1542,3,68,1,2031.70,NULL,'2022-12-09 09:41:39','2022-12-09 09:41:39',NULL),(813,7812,236,40720,1542,3,221,1,1296.55,NULL,'2022-12-09 09:41:39','2022-12-09 09:41:39',NULL),(814,7812,236,40720,1542,3,57,2,13003.00,NULL,'2022-12-09 09:41:39','2022-12-09 09:41:39',NULL),(815,7812,237,40720,1542,3,217,1,4836.26,NULL,'2022-12-09 09:42:10','2022-12-09 09:42:10',NULL),(816,7812,237,40720,1542,3,68,1,1015.61,NULL,'2022-12-09 09:42:10','2022-12-09 09:42:10',NULL),(817,7812,237,40720,1542,3,221,1,648.13,NULL,'2022-12-09 09:42:10','2022-12-09 09:42:10',NULL),(818,7812,237,40720,1542,3,57,2,6500.00,NULL,'2022-12-09 09:42:10','2022-12-09 09:42:10',NULL),(819,7812,238,40720,1542,3,217,1,3478.66,NULL,'2022-12-09 09:42:59','2022-12-09 09:42:59',NULL),(820,7812,238,40720,1542,3,68,1,730.52,NULL,'2022-12-09 09:42:59','2022-12-09 09:42:59',NULL),(821,7812,238,40720,1542,3,221,1,790.83,NULL,'2022-12-09 09:42:59','2022-12-09 09:42:59',NULL),(822,7812,238,40720,1542,3,57,2,5000.01,NULL,'2022-12-09 09:42:59','2022-12-09 09:42:59',NULL),(823,7812,239,40720,1542,3,217,1,8448.68,NULL,'2022-12-09 09:44:09','2022-12-09 09:44:09',NULL),(824,7812,239,40720,1542,3,68,1,1774.22,NULL,'2022-12-09 09:44:09','2022-12-09 09:44:09',NULL),(825,7812,239,40720,1542,3,221,1,778.31,NULL,'2022-12-09 09:44:09','2022-12-09 09:44:09',NULL),(826,7812,239,40720,1542,3,57,2,11001.21,NULL,'2022-12-09 09:44:09','2022-12-09 09:44:09',NULL),(827,7812,240,40720,1542,3,217,1,8928.47,NULL,'2022-12-09 09:44:41','2022-12-09 09:44:41',NULL),(828,7812,240,40720,1542,3,68,1,1874.98,NULL,'2022-12-09 09:44:41','2022-12-09 09:44:41',NULL),(829,7812,240,40720,1542,3,221,1,1196.54,NULL,'2022-12-09 09:44:41','2022-12-09 09:44:41',NULL),(830,7812,240,40720,1542,3,57,2,11999.99,NULL,'2022-12-09 09:44:41','2022-12-09 09:44:41',NULL),(831,7812,241,40720,1542,3,217,1,8699.85,NULL,'2022-12-09 09:45:12','2022-12-09 09:45:12',NULL),(832,7812,241,40720,1542,3,68,1,1826.97,NULL,'2022-12-09 09:45:12','2022-12-09 09:45:12',NULL),(833,7812,241,40720,1542,3,221,1,972.88,NULL,'2022-12-09 09:45:12','2022-12-09 09:45:12',NULL),(834,7812,241,40720,1542,3,57,2,11499.70,NULL,'2022-12-09 09:45:12','2022-12-09 09:45:12',NULL),(835,7812,242,40720,1542,3,217,1,8929.23,NULL,'2022-12-09 09:45:56','2022-12-09 09:45:56',NULL),(836,7812,242,40720,1542,3,68,1,1875.14,NULL,'2022-12-09 09:45:56','2022-12-09 09:45:56',NULL);
INSERT INTO `balance_libro_details` VALUES (837,7812,242,40720,1542,3,221,1,1196.65,NULL,'2022-12-09 09:45:56','2022-12-09 09:45:56',NULL),(838,7812,242,40720,1542,3,57,2,12001.02,NULL,'2022-12-09 09:45:56','2022-12-09 09:45:56',NULL),(839,7812,243,40720,1542,3,217,1,10494.98,NULL,'2022-12-14 07:31:13','2022-12-14 07:31:13',NULL),(840,7812,243,40720,1542,3,68,1,2203.95,NULL,'2022-12-14 07:31:13','2022-12-14 07:31:13',NULL),(841,7812,243,40720,1542,3,221,1,1307.27,NULL,'2022-12-14 07:31:13','2022-12-14 07:31:13',NULL),(842,7812,243,40720,1542,3,57,2,14006.20,NULL,'2022-12-14 07:31:13','2022-12-14 07:31:13',NULL),(843,7812,244,40720,1542,3,217,1,6040.26,NULL,'2022-12-14 07:32:21','2022-12-14 07:32:21',NULL),(844,7812,244,40720,1542,3,68,1,1268.45,NULL,'2022-12-14 07:32:21','2022-12-14 07:32:21',NULL),(845,7812,244,40720,1542,3,221,1,691.29,NULL,'2022-12-14 07:32:21','2022-12-14 07:32:21',NULL),(846,7812,244,40720,1542,3,57,2,8000.00,NULL,'2022-12-14 07:32:21','2022-12-14 07:32:21',NULL),(847,7812,245,40720,1542,3,217,1,11328.28,NULL,'2022-12-14 07:33:17','2022-12-14 07:33:17',NULL),(848,7812,245,40720,1542,3,68,1,2378.94,NULL,'2022-12-14 07:33:17','2022-12-14 07:33:17',NULL),(849,7812,245,40720,1542,3,221,1,1296.48,NULL,'2022-12-14 07:33:17','2022-12-14 07:33:17',NULL),(850,7812,245,40720,1542,3,57,2,15003.70,NULL,'2022-12-14 07:33:17','2022-12-14 07:33:17',NULL),(851,7812,246,40720,1542,3,217,1,9815.50,NULL,'2022-12-14 07:34:22','2022-12-14 07:34:22',NULL),(852,7812,246,40720,1542,3,68,1,2061.26,NULL,'2022-12-14 07:34:22','2022-12-14 07:34:22',NULL),(853,7812,246,40720,1542,3,221,1,1123.35,NULL,'2022-12-14 07:34:22','2022-12-14 07:34:22',NULL),(854,7812,246,40720,1542,3,57,2,13000.11,NULL,'2022-12-14 07:34:22','2022-12-14 07:34:22',NULL),(855,7812,247,40720,1542,3,217,1,9815.40,NULL,'2022-12-14 07:36:31','2022-12-14 07:36:31',NULL),(856,7812,247,40720,1542,3,68,1,2061.23,NULL,'2022-12-14 07:36:31','2022-12-14 07:36:31',NULL),(857,7812,247,40720,1542,3,221,1,1123.34,NULL,'2022-12-14 07:36:31','2022-12-14 07:36:31',NULL),(858,7812,247,40720,1542,3,57,2,12999.97,NULL,'2022-12-14 07:36:31','2022-12-14 07:36:31',NULL),(859,7812,248,40720,1542,3,217,1,13382.54,NULL,'2022-12-14 07:37:18','2022-12-14 07:37:18',NULL),(860,7812,248,40720,1542,3,68,1,2810.33,NULL,'2022-12-14 07:37:18','2022-12-14 07:37:18',NULL),(861,7812,248,40720,1542,3,221,1,1810.02,NULL,'2022-12-14 07:37:18','2022-12-14 07:37:18',NULL),(862,7812,248,40720,1542,3,57,2,18002.89,NULL,'2022-12-14 07:37:18','2022-12-14 07:37:18',NULL),(863,7812,249,40720,1542,3,217,1,10490.42,NULL,'2022-12-14 07:38:06','2022-12-14 07:38:06',NULL),(864,7812,249,40720,1542,3,68,1,2202.99,NULL,'2022-12-14 07:38:06','2022-12-14 07:38:06',NULL),(865,7812,249,40720,1542,3,221,1,1306.70,NULL,'2022-12-14 07:38:06','2022-12-14 07:38:06',NULL),(866,7812,249,40720,1542,3,57,2,14000.11,NULL,'2022-12-14 07:38:06','2022-12-14 07:38:06',NULL),(867,7812,250,40720,1542,3,217,1,7551.53,NULL,'2022-12-14 07:38:41','2022-12-14 07:38:41',NULL),(868,7812,250,40720,1542,3,68,1,1585.82,NULL,'2022-12-14 07:38:41','2022-12-14 07:38:41',NULL),(869,7812,250,40720,1542,3,221,1,864.25,NULL,'2022-12-14 07:38:41','2022-12-14 07:38:41',NULL),(870,7812,250,40720,1542,3,57,2,10001.60,NULL,'2022-12-14 07:38:41','2022-12-14 07:38:41',NULL),(871,7812,251,40720,1542,3,217,1,10418.94,NULL,'2022-12-14 07:39:25','2022-12-14 07:39:25',NULL),(872,7812,251,40720,1542,3,68,1,2187.98,NULL,'2022-12-14 07:39:25','2022-12-14 07:39:25',NULL),(873,7812,251,40720,1542,3,221,1,1396.29,NULL,'2022-12-14 07:39:25','2022-12-14 07:39:25',NULL),(874,7812,251,40720,1542,3,57,2,14003.21,NULL,'2022-12-14 07:39:25','2022-12-14 07:39:25',NULL),(875,7812,252,40720,1542,3,217,1,3478.69,NULL,'2022-12-14 07:40:29','2022-12-14 07:40:29',NULL),(876,7812,252,40720,1542,3,68,1,730.52,NULL,'2022-12-14 07:40:29','2022-12-14 07:40:29',NULL),(877,7812,252,40720,1542,3,221,1,790.84,NULL,'2022-12-14 07:40:29','2022-12-14 07:40:29',NULL);
INSERT INTO `balance_libro_details` VALUES (878,7812,252,40720,1542,3,57,2,5000.05,NULL,'2022-12-14 07:40:29','2022-12-14 07:40:29',NULL),(879,7812,253,40720,1542,3,217,1,51239.67,NULL,'2022-12-14 07:55:31','2022-12-14 07:55:31',NULL),(880,7812,253,40720,1542,3,68,1,10760.33,NULL,'2022-12-14 07:55:31','2022-12-14 07:55:31',NULL),(881,7812,253,40720,1542,3,57,2,62000.00,NULL,'2022-12-14 07:55:31','2022-12-14 07:55:31',NULL),(882,7812,254,40720,1542,3,217,1,107.02,NULL,'2022-12-14 07:55:31','2022-12-21 07:31:37','2022-12-21 07:31:37'),(883,7812,254,40720,1542,3,68,1,22.48,NULL,'2022-12-14 07:55:31','2022-12-21 07:31:37','2022-12-21 07:31:37'),(884,7812,254,40720,1542,3,57,2,129.50,NULL,'2022-12-14 07:55:31','2022-12-21 07:31:37','2022-12-21 07:31:37'),(885,7812,255,40720,1542,3,217,1,57438.02,NULL,'2022-12-14 07:55:31','2022-12-14 07:55:31',NULL),(886,7812,255,40720,1542,3,68,1,12061.98,NULL,'2022-12-14 07:55:31','2022-12-14 07:55:31',NULL),(887,7812,255,40720,1542,3,57,2,69500.00,NULL,'2022-12-14 07:55:31','2022-12-14 07:55:31',NULL),(888,7812,256,40720,1542,3,217,1,2481.50,NULL,'2022-12-14 07:55:31','2022-12-21 07:28:37','2022-12-21 07:28:37'),(889,7812,256,40720,1542,3,68,1,521.12,NULL,'2022-12-14 07:55:31','2022-12-21 07:28:37','2022-12-21 07:28:37'),(890,7812,256,40720,1542,3,57,2,3002.62,NULL,'2022-12-14 07:55:31','2022-12-21 07:28:37','2022-12-21 07:28:37'),(891,7812,257,40720,1543,3,217,1,12867.12,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(892,7812,257,40720,1543,3,68,1,2702.10,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(893,7812,257,40720,1543,3,57,2,15569.22,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(894,7812,258,40720,1543,3,217,1,11579.59,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(895,7812,258,40720,1543,3,68,1,2431.71,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(896,7812,258,40720,1543,3,217,1,988.70,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(897,7812,258,40720,1543,3,57,2,15000.00,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(898,7812,259,40720,1543,3,217,1,72562.31,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(899,7812,259,40720,1543,3,68,1,15237.69,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(900,7812,259,40720,1543,3,57,2,87800.00,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(901,7812,260,40720,1543,3,217,1,6494.69,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(902,7812,260,40720,1543,3,68,1,1363.88,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(903,7812,260,40720,1543,3,57,2,7858.57,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(904,7812,261,40720,1543,3,217,2,37190.25,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(905,7812,261,40720,1543,3,67,2,7809.75,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(906,7812,261,40720,1543,3,57,1,45000.00,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(907,7812,262,40720,1543,3,217,1,4132.25,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(908,7812,262,40720,1543,3,68,1,867.75,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(909,7812,262,40720,1543,3,57,2,5000.00,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(910,7812,263,40720,1543,3,217,1,10413.22,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(911,7812,263,40720,1543,3,68,1,2186.78,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(912,7812,263,40720,1543,3,57,2,12600.00,NULL,'2022-12-14 07:57:29','2022-12-14 07:57:29',NULL),(913,7812,264,40720,1542,2,96,2,159800.00,NULL,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(914,7812,264,40720,1542,2,67,2,33558.00,NULL,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(915,7812,264,40720,1542,2,13,1,193358.00,NULL,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(916,7812,265,40720,1542,2,96,1,159800.00,NULL,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(917,7812,265,40720,1542,2,68,1,33558.00,NULL,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL);
INSERT INTO `balance_libro_details` VALUES (918,7812,265,40720,1542,2,13,2,193358.00,NULL,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(919,7812,266,40720,1542,2,96,2,92235.00,NULL,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(920,7812,266,40720,1542,2,67,2,19369.35,NULL,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(921,7812,266,40720,1542,2,13,1,111604.35,NULL,'2022-12-14 07:58:14','2022-12-14 07:58:14',NULL),(922,7812,267,40720,1543,2,96,2,52727.27,NULL,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(923,7812,267,40720,1543,2,67,2,11072.73,NULL,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(924,7812,267,40720,1543,2,13,1,63800.00,NULL,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(925,7812,268,40720,1543,2,96,2,13388.44,NULL,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(926,7812,268,40720,1543,2,67,2,2811.56,NULL,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(927,7812,268,40720,1543,2,13,1,16200.00,NULL,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(928,7812,269,40720,1543,2,96,2,52727.27,NULL,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(929,7812,269,40720,1543,2,67,2,11072.73,NULL,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(930,7812,269,40720,1543,2,13,1,63800.00,NULL,'2022-12-14 07:58:34','2022-12-14 07:58:34',NULL),(931,7812,270,40720,1543,2,96,1,52727.27,NULL,'2022-12-14 07:58:35','2022-12-14 07:58:35',NULL),(932,7812,270,40720,1543,2,68,1,11072.73,NULL,'2022-12-14 07:58:35','2022-12-14 07:58:35',NULL),(933,7812,270,40720,1543,2,13,2,63800.00,NULL,'2022-12-14 07:58:35','2022-12-14 07:58:35',NULL),(934,7812,271,40720,1542,15,67,1,52927.35,NULL,'2022-12-21 09:00:10','2022-12-21 09:00:10',NULL),(935,7812,271,40720,1542,15,68,2,115970.25,NULL,'2022-12-21 09:00:10','2022-12-21 09:00:10',NULL),(936,7812,271,40720,1542,15,353,2,24750.85,NULL,'2022-12-21 09:00:10','2022-12-21 09:00:10',NULL),(937,7812,271,40720,1542,15,353,1,87793.74,NULL,'2022-12-21 09:00:10','2022-12-21 09:00:10',NULL),(938,7812,271,40720,1542,15,136,1,0.01,NULL,'2022-12-21 09:00:10','2022-12-21 09:00:10',NULL),(939,7812,272,40720,1543,15,67,1,32766.98,NULL,'2022-12-21 11:49:33','2022-12-21 11:49:33',NULL),(940,7812,272,40720,1543,15,68,2,35863.05,NULL,'2022-12-21 11:49:33','2022-12-21 11:49:33',NULL),(941,7812,272,40720,1543,15,353,2,87793.74,NULL,'2022-12-21 11:49:33','2022-12-21 11:49:33',NULL),(942,7812,272,40720,1543,15,353,1,90889.82,NULL,'2022-12-21 11:49:33','2022-12-21 11:49:33',NULL),(943,7812,272,40720,1543,15,136,2,0.01,NULL,'2022-12-21 11:49:33','2022-12-21 11:49:33',NULL),(944,7812,273,40720,1549,2,218,2,0.00,NULL,'2023-03-06 17:25:11','2023-03-25 16:35:58','2023-03-25 16:35:58'),(945,7812,273,40720,1549,2,218,2,4000.00,NULL,'2023-03-06 17:25:11','2023-03-25 16:35:58','2023-03-25 16:35:58'),(946,7812,273,40720,1549,2,13,1,4000.00,NULL,'2023-03-06 17:25:11','2023-03-25 16:35:58','2023-03-25 16:35:58'),(947,7812,274,40720,1544,3,217,1,16983.47,NULL,'2023-03-06 17:25:46','2023-03-06 17:25:46',NULL),(948,7812,274,40720,1544,3,68,1,3566.53,NULL,'2023-03-06 17:25:46','2023-03-06 17:25:46',NULL),(949,7812,274,40720,1544,3,57,2,20550.00,NULL,'2023-03-06 17:25:46','2023-03-06 17:25:46',NULL),(950,7812,275,40720,1544,3,217,1,20453.05,NULL,'2023-03-06 17:25:46','2023-03-06 17:25:46',NULL),(951,7812,275,40720,1544,3,68,1,4295.14,NULL,'2023-03-06 17:25:46','2023-03-06 17:25:46',NULL),(952,7812,275,40720,1544,3,57,2,24748.19,NULL,'2023-03-06 17:25:46','2023-03-06 17:25:46',NULL),(953,7812,276,40720,1548,3,217,1,4156.19,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(954,7812,276,40720,1548,3,68,1,872.80,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(955,7812,276,40720,1548,3,57,2,5028.99,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(956,7812,277,40720,1548,3,217,1,6470.33,NULL,'2023-03-06 17:26:05','2023-03-07 07:39:42','2023-03-07 07:39:42'),(957,7812,277,40720,1548,3,68,1,1359.63,NULL,'2023-03-06 17:26:05','2023-03-07 07:39:42','2023-03-07 07:39:42');
INSERT INTO `balance_libro_details` VALUES (958,7812,277,40720,1548,3,217,1,1.25,NULL,'2023-03-06 17:26:05','2023-03-07 07:39:42','2023-03-07 07:39:42'),(959,7812,277,40720,1548,3,57,2,8062.76,NULL,'2023-03-06 17:26:05','2023-03-07 07:39:42','2023-03-07 07:39:42'),(960,7812,277,40720,1548,3,136,1,231.55,NULL,'2023-03-06 17:26:05','2023-03-07 07:39:42','2023-03-07 07:39:42'),(961,7812,278,40720,1548,3,217,1,8921.64,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(962,7812,278,40720,1548,3,68,1,1873.54,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(963,7812,278,40720,1548,3,217,1,160.59,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(964,7812,278,40720,1548,3,57,2,10955.77,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(965,7812,279,40720,1548,3,217,1,8326.45,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(966,7812,279,40720,1548,3,68,1,1748.55,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(967,7812,279,40720,1548,3,57,2,10075.00,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(968,7812,280,40720,1548,3,217,1,4884.29,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(969,7812,280,40720,1548,3,68,1,1025.70,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(970,7812,280,40720,1548,3,57,2,5909.99,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(971,7812,281,40720,1548,3,217,1,7701.81,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(972,7812,281,40720,1548,3,68,1,1617.38,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(973,7812,281,40720,1548,3,217,1,0.01,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(974,7812,281,40720,1548,3,57,2,9319.20,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(975,7812,282,40720,1548,3,217,1,40480.38,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(976,7812,282,40720,1548,3,68,1,8500.88,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(977,7812,282,40720,1548,3,57,2,48981.26,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(978,7812,283,40720,1548,3,217,1,31865.64,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(979,7812,283,40720,1548,3,68,1,6691.78,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(980,7812,283,40720,1548,3,217,1,1147.16,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(981,7812,283,40720,1548,3,57,2,39704.58,NULL,'2023-03-06 17:26:05','2023-03-06 17:26:05',NULL),(982,7812,284,40720,1544,3,217,1,3636.36,NULL,'2023-03-06 17:50:21','2023-03-06 17:50:21',NULL),(983,7812,284,40720,1544,3,68,1,763.64,NULL,'2023-03-06 17:50:21','2023-03-06 17:50:21',NULL),(984,7812,284,40720,1544,3,57,2,4400.00,NULL,'2023-03-06 17:50:21','2023-03-06 17:50:21',NULL),(985,7812,285,40720,1544,3,217,1,10743.80,NULL,'2023-03-06 17:51:03','2023-03-06 17:51:03',NULL),(986,7812,285,40720,1544,3,68,1,2256.20,NULL,'2023-03-06 17:51:03','2023-03-06 17:51:03',NULL),(987,7812,285,40720,1544,3,57,2,13000.00,NULL,'2023-03-06 17:51:03','2023-03-06 17:51:03',NULL),(988,7812,286,40720,1544,3,217,1,2933.89,NULL,'2023-03-06 17:51:34','2023-03-06 17:51:34',NULL),(989,7812,286,40720,1544,3,68,1,616.12,NULL,'2023-03-06 17:51:34','2023-03-06 17:51:34',NULL),(990,7812,286,40720,1544,3,57,2,3550.01,NULL,'2023-03-06 17:51:34','2023-03-06 17:51:34',NULL),(991,7812,287,40720,1544,3,217,1,2479.34,NULL,'2023-03-06 17:52:13','2023-03-06 17:52:13',NULL),(992,7812,287,40720,1544,3,68,1,520.66,NULL,'2023-03-06 17:52:13','2023-03-06 17:52:13',NULL),(993,7812,287,40720,1544,3,57,2,3000.00,NULL,'2023-03-06 17:52:13','2023-03-06 17:52:13',NULL),(994,7812,288,40720,1544,3,217,1,8181.82,NULL,'2023-03-06 17:52:35','2023-03-06 17:52:35',NULL),(995,7812,288,40720,1544,3,68,1,1718.18,NULL,'2023-03-06 17:52:35','2023-03-06 17:52:35',NULL),(996,7812,288,40720,1544,3,57,2,9900.00,NULL,'2023-03-06 17:52:35','2023-03-06 17:52:35',NULL),(997,7812,289,40720,1544,3,217,1,8264.46,NULL,'2023-03-06 17:54:42','2023-03-06 17:54:42',NULL),(998,7812,289,40720,1544,3,68,1,1735.54,NULL,'2023-03-06 17:54:42','2023-03-06 17:54:42',NULL);
INSERT INTO `balance_libro_details` VALUES (999,7812,289,40720,1544,3,57,2,10000.00,NULL,'2023-03-06 17:54:42','2023-03-06 17:54:42',NULL),(1000,7812,290,40720,1544,3,217,1,19295.71,NULL,'2023-03-06 17:57:25','2023-03-06 17:57:25',NULL),(1001,7812,290,40720,1544,3,68,1,4052.10,NULL,'2023-03-06 17:57:25','2023-03-06 17:57:25',NULL),(1002,7812,290,40720,1544,3,215,1,169.24,NULL,'2023-03-06 17:57:25','2023-03-06 17:57:25',NULL),(1003,7812,290,40720,1544,3,221,1,1484.13,NULL,'2023-03-06 17:57:25','2023-03-06 17:57:25',NULL),(1004,7812,290,40720,1544,3,57,2,25001.18,NULL,'2023-03-06 17:57:25','2023-03-06 17:57:25',NULL),(1005,7812,291,40720,1544,3,217,1,58072.49,NULL,'2023-03-06 17:59:12','2023-03-06 17:59:12',NULL),(1006,7812,291,40720,1544,3,68,1,12195.22,NULL,'2023-03-06 17:59:12','2023-03-06 17:59:12',NULL),(1007,7812,291,40720,1544,3,478,1,750.55,NULL,'2023-03-06 17:59:12','2023-03-06 17:59:12',NULL),(1008,7812,291,40720,1544,3,221,1,6581.84,NULL,'2023-03-06 17:59:12','2023-03-06 17:59:12',NULL),(1009,7812,291,40720,1544,3,57,2,77600.10,NULL,'2023-03-06 17:59:12','2023-03-06 17:59:12',NULL),(1010,7812,292,40720,1544,3,217,1,10776.45,NULL,'2023-03-06 18:00:41','2023-03-06 18:00:41',NULL),(1011,7812,292,40720,1544,3,68,1,2263.05,NULL,'2023-03-06 18:00:41','2023-03-06 18:00:41',NULL),(1012,7812,292,40720,1544,3,221,1,960.53,NULL,'2023-03-06 18:00:41','2023-03-06 18:00:41',NULL),(1013,7812,292,40720,1544,3,57,2,14000.03,NULL,'2023-03-06 18:00:41','2023-03-06 18:00:41',NULL),(1014,7812,293,40720,1544,3,217,1,7808.88,NULL,'2023-03-06 18:01:35','2023-03-06 18:01:35',NULL),(1015,7812,293,40720,1544,3,68,1,1639.86,NULL,'2023-03-06 18:01:35','2023-03-06 18:01:35',NULL),(1016,7812,293,40720,1544,3,221,1,1052.97,NULL,'2023-03-06 18:01:35','2023-03-06 18:01:35',NULL),(1017,7812,293,40720,1544,3,57,2,10501.71,NULL,'2023-03-06 18:01:35','2023-03-06 18:01:35',NULL),(1018,7812,294,40720,1544,3,217,1,15359.55,NULL,'2023-03-06 18:02:13','2023-03-06 18:02:13',NULL),(1019,7812,294,40720,1544,3,68,1,3225.51,NULL,'2023-03-06 18:02:13','2023-03-06 18:02:13',NULL),(1020,7812,294,40720,1544,3,221,1,1414.95,NULL,'2023-03-06 18:02:13','2023-03-06 18:02:13',NULL),(1021,7812,294,40720,1544,3,57,2,20000.01,NULL,'2023-03-06 18:02:13','2023-03-06 18:02:13',NULL),(1022,7812,295,40720,1544,3,217,1,19201.12,NULL,'2023-03-06 18:02:54','2023-03-06 18:02:54',NULL),(1023,7812,295,40720,1544,3,68,1,4032.24,NULL,'2023-03-06 18:02:54','2023-03-06 18:02:54',NULL),(1024,7812,295,40720,1544,3,221,1,1768.85,NULL,'2023-03-06 18:02:54','2023-03-06 18:02:54',NULL),(1025,7812,295,40720,1544,3,57,2,25002.21,NULL,'2023-03-06 18:02:54','2023-03-06 18:02:54',NULL),(1026,7812,296,40720,1544,3,217,1,4491.22,NULL,'2023-03-06 18:03:38','2023-03-06 18:03:38',NULL),(1027,7812,296,40720,1544,3,68,1,943.16,NULL,'2023-03-06 18:03:38','2023-03-06 18:03:38',NULL),(1028,7812,296,40720,1544,3,221,1,567.63,NULL,'2023-03-06 18:03:38','2023-03-06 18:03:38',NULL),(1029,7812,296,40720,1544,3,57,2,6002.01,NULL,'2023-03-06 18:03:38','2023-03-06 18:03:38',NULL),(1030,7812,297,40720,1544,3,217,1,9983.70,NULL,'2023-03-06 18:04:00','2023-03-06 18:04:00',NULL),(1031,7812,297,40720,1544,3,68,1,2096.58,NULL,'2023-03-06 18:04:00','2023-03-06 18:04:00',NULL),(1032,7812,297,40720,1544,3,221,1,919.72,NULL,'2023-03-06 18:04:00','2023-03-06 18:04:00',NULL),(1033,7812,297,40720,1544,3,57,2,13000.00,NULL,'2023-03-06 18:04:00','2023-03-06 18:04:00',NULL),(1034,7812,298,40720,1544,3,217,1,12483.42,NULL,'2023-03-06 18:04:32','2023-03-06 18:04:32',NULL),(1035,7812,298,40720,1544,3,68,1,2621.52,NULL,'2023-03-06 18:04:32','2023-03-06 18:04:32',NULL),(1036,7812,298,40720,1544,3,221,1,1997.38,NULL,'2023-03-06 18:04:32','2023-03-06 18:04:32',NULL),(1037,7812,298,40720,1544,3,57,2,17102.32,NULL,'2023-03-06 18:04:32','2023-03-06 18:04:32',NULL),(1038,7812,299,40720,1544,3,217,1,13864.93,NULL,'2023-03-06 18:05:03','2023-03-06 18:05:03',NULL),(1039,7812,299,40720,1544,3,68,1,2911.64,NULL,'2023-03-06 18:05:03','2023-03-06 18:05:03',NULL);
INSERT INTO `balance_libro_details` VALUES (1040,7812,299,40720,1544,3,221,1,1223.44,NULL,'2023-03-06 18:05:03','2023-03-06 18:05:03',NULL),(1041,7812,299,40720,1544,3,57,2,18000.01,NULL,'2023-03-06 18:05:03','2023-03-06 18:05:03',NULL),(1042,7812,300,40720,1544,3,217,1,52713.59,NULL,'2023-03-06 18:05:49','2023-03-06 18:05:49',NULL),(1043,7812,300,40720,1544,3,68,1,11069.85,NULL,'2023-03-06 18:05:49','2023-03-06 18:05:49',NULL),(1044,7812,300,40720,1544,3,221,1,6220.76,NULL,'2023-03-06 18:05:49','2023-03-06 18:05:49',NULL),(1045,7812,300,40720,1544,3,57,2,70004.20,NULL,'2023-03-06 18:05:49','2023-03-06 18:05:49',NULL),(1046,7812,301,40720,1544,3,217,1,46452.13,NULL,'2023-03-06 18:06:18','2023-03-06 18:06:18',NULL),(1047,7812,301,40720,1544,3,68,1,9754.95,NULL,'2023-03-06 18:06:18','2023-03-06 18:06:18',NULL),(1048,7812,301,40720,1544,3,221,1,4098.93,NULL,'2023-03-06 18:06:18','2023-03-06 18:06:18',NULL),(1049,7812,301,40720,1544,3,57,2,60306.01,NULL,'2023-03-06 18:06:18','2023-03-06 18:06:18',NULL),(1050,7812,302,40720,1544,3,217,1,5730.31,NULL,'2023-03-06 18:06:49','2023-03-06 18:06:49',NULL),(1051,7812,302,40720,1544,3,68,1,1203.37,NULL,'2023-03-06 18:06:49','2023-03-06 18:06:49',NULL),(1052,7812,302,40720,1544,3,221,1,767.94,NULL,'2023-03-06 18:06:49','2023-03-06 18:06:49',NULL),(1053,7812,302,40720,1544,3,57,2,7701.62,NULL,'2023-03-06 18:06:49','2023-03-06 18:06:49',NULL),(1054,7812,303,40720,1544,3,217,1,6308.22,NULL,'2023-03-06 18:07:19','2023-03-06 18:07:19',NULL),(1055,7812,303,40720,1544,3,68,1,1324.73,NULL,'2023-03-06 18:07:19','2023-03-06 18:07:19',NULL),(1056,7812,303,40720,1544,3,221,1,744.44,NULL,'2023-03-06 18:07:19','2023-03-06 18:07:19',NULL),(1057,7812,303,40720,1544,3,57,2,8377.39,NULL,'2023-03-06 18:07:19','2023-03-06 18:07:19',NULL),(1058,7812,304,40720,1544,3,217,1,32383.26,NULL,'2023-03-06 18:08:07','2023-03-06 18:08:07',NULL),(1059,7812,304,40720,1544,3,68,1,6800.48,NULL,'2023-03-06 18:08:07','2023-03-06 18:08:07',NULL),(1060,7812,304,40720,1544,3,221,1,3821.56,NULL,'2023-03-06 18:08:07','2023-03-06 18:08:07',NULL),(1061,7812,304,40720,1544,3,57,2,43005.30,NULL,'2023-03-06 18:08:07','2023-03-06 18:08:07',NULL),(1062,7812,305,40720,1544,3,217,1,15822.04,NULL,'2023-03-06 18:08:43','2023-03-06 18:08:43',NULL),(1063,7812,305,40720,1544,3,68,1,3322.63,NULL,'2023-03-06 18:08:43','2023-03-06 18:08:43',NULL),(1064,7812,305,40720,1544,3,221,1,1856.10,NULL,'2023-03-06 18:08:43','2023-03-06 18:08:43',NULL),(1065,7812,305,40720,1544,3,57,2,21000.77,NULL,'2023-03-06 18:08:43','2023-03-06 18:08:43',NULL),(1066,7812,306,40720,1544,3,217,1,15061.93,NULL,'2023-03-06 18:09:38','2023-03-06 18:09:38',NULL),(1067,7812,306,40720,1544,3,68,1,3163.01,NULL,'2023-03-06 18:09:38','2023-03-06 18:09:38',NULL),(1068,7812,306,40720,1544,3,221,1,1777.47,NULL,'2023-03-06 18:09:38','2023-03-06 18:09:38',NULL),(1069,7812,306,40720,1544,3,57,2,20002.41,NULL,'2023-03-06 18:09:38','2023-03-06 18:09:38',NULL),(1070,7812,307,40720,1544,3,217,1,7531.50,NULL,'2023-03-06 18:10:05','2023-03-06 18:10:05',NULL),(1071,7812,307,40720,1544,3,68,1,1581.62,NULL,'2023-03-06 18:10:05','2023-03-06 18:10:05',NULL),(1072,7812,307,40720,1544,3,221,1,888.80,NULL,'2023-03-06 18:10:05','2023-03-06 18:10:05',NULL),(1073,7812,307,40720,1544,3,57,2,10001.91,NULL,'2023-03-06 18:10:05','2023-03-06 18:10:05',NULL),(1074,7812,307,40720,1544,3,136,2,0.01,NULL,'2023-03-06 18:10:05','2023-03-06 18:10:05',NULL),(1075,7812,308,40720,1544,3,217,1,1404.90,NULL,'2023-03-06 18:10:37','2023-03-06 18:10:37',NULL),(1076,7812,308,40720,1544,3,68,1,295.03,NULL,'2023-03-06 18:10:37','2023-03-06 18:10:37',NULL),(1077,7812,308,40720,1544,3,221,1,301.47,NULL,'2023-03-06 18:10:37','2023-03-06 18:10:37',NULL),(1078,7812,308,40720,1544,3,57,2,2001.40,NULL,'2023-03-06 18:10:37','2023-03-06 18:10:37',NULL),(1079,7812,309,40720,1544,3,217,1,3464.97,NULL,'2023-03-06 18:11:07','2023-03-06 18:11:07',NULL),(1080,7812,309,40720,1544,3,68,1,727.64,NULL,'2023-03-06 18:11:07','2023-03-06 18:11:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1081,7812,309,40720,1544,3,221,1,408.90,NULL,'2023-03-06 18:11:07','2023-03-06 18:11:07',NULL),(1082,7812,309,40720,1544,3,57,2,4601.51,NULL,'2023-03-06 18:11:07','2023-03-06 18:11:07',NULL),(1083,7812,310,40720,1544,3,217,1,1052.94,NULL,'2023-03-06 18:11:42','2023-03-06 18:11:42',NULL),(1084,7812,310,40720,1544,3,68,1,221.12,NULL,'2023-03-06 18:11:42','2023-03-06 18:11:42',NULL),(1085,7812,310,40720,1544,3,221,1,225.94,NULL,'2023-03-06 18:11:42','2023-03-06 18:11:42',NULL),(1086,7812,310,40720,1544,3,57,2,1500.00,NULL,'2023-03-06 18:11:42','2023-03-06 18:11:42',NULL),(1087,7812,311,40720,1548,3,217,1,45948.46,NULL,'2023-03-06 18:21:26','2023-03-06 18:21:26',NULL),(1088,7812,311,40720,1548,3,68,1,9649.18,NULL,'2023-03-06 18:21:26','2023-03-06 18:21:26',NULL),(1089,7812,311,40720,1548,3,221,1,5372.46,NULL,'2023-03-06 18:21:26','2023-03-06 18:21:26',NULL),(1090,7812,311,40720,1548,3,57,2,60970.10,NULL,'2023-03-06 18:21:26','2023-03-06 18:21:26',NULL),(1091,7812,312,40720,1548,3,217,1,26305.05,NULL,'2023-03-06 18:21:54','2023-03-06 18:21:54',NULL),(1092,7812,312,40720,1548,3,68,1,5524.06,NULL,'2023-03-06 18:21:54','2023-03-06 18:21:54',NULL),(1093,7812,312,40720,1548,3,221,1,3170.93,NULL,'2023-03-06 18:21:54','2023-03-06 18:21:54',NULL),(1094,7812,312,40720,1548,3,57,2,35000.04,NULL,'2023-03-06 18:21:54','2023-03-06 18:21:54',NULL),(1095,7812,313,40720,1548,3,217,1,11338.03,NULL,'2023-03-06 18:22:49','2023-03-06 18:22:49',NULL),(1096,7812,313,40720,1548,3,68,1,2380.99,NULL,'2023-03-06 18:22:49','2023-03-06 18:22:49',NULL),(1097,7812,313,40720,1548,3,221,1,1282.87,NULL,'2023-03-06 18:22:49','2023-03-06 18:22:49',NULL),(1098,7812,313,40720,1548,3,57,2,15001.89,NULL,'2023-03-06 18:22:49','2023-03-06 18:22:49',NULL),(1099,7812,314,40720,1548,3,217,1,4240.27,NULL,'2023-03-06 18:23:11','2023-03-06 18:23:11',NULL),(1100,7812,314,40720,1548,3,68,1,890.46,NULL,'2023-03-06 18:23:11','2023-03-06 18:23:11',NULL),(1101,7812,314,40720,1548,3,221,1,869.97,NULL,'2023-03-06 18:23:11','2023-03-06 18:23:11',NULL),(1102,7812,314,40720,1548,3,57,2,6000.70,NULL,'2023-03-06 18:23:11','2023-03-06 18:23:11',NULL),(1103,7812,315,40720,1548,3,217,1,2135.45,NULL,'2023-03-06 18:23:39','2023-03-06 18:23:39',NULL),(1104,7812,315,40720,1548,3,68,1,448.44,NULL,'2023-03-06 18:23:39','2023-03-06 18:23:39',NULL),(1105,7812,315,40720,1548,3,221,1,416.10,NULL,'2023-03-06 18:23:39','2023-03-06 18:23:39',NULL),(1106,7812,315,40720,1548,3,57,2,2999.99,NULL,'2023-03-06 18:23:39','2023-03-06 18:23:39',NULL),(1107,7812,316,40720,1548,3,217,1,11322.40,NULL,'2023-03-06 18:24:01','2023-03-06 18:24:01',NULL),(1108,7812,316,40720,1548,3,68,1,2377.70,NULL,'2023-03-06 18:24:01','2023-03-06 18:24:01',NULL),(1109,7812,316,40720,1548,3,221,1,1299.91,NULL,'2023-03-06 18:24:01','2023-03-06 18:24:01',NULL),(1110,7812,316,40720,1548,3,57,2,15000.01,NULL,'2023-03-06 18:24:01','2023-03-06 18:24:01',NULL),(1111,7812,317,40720,1548,3,217,1,3647.25,NULL,'2023-03-06 18:24:28','2023-03-06 18:24:28',NULL),(1112,7812,317,40720,1548,3,68,1,765.92,NULL,'2023-03-06 18:24:28','2023-03-06 18:24:28',NULL),(1113,7812,317,40720,1548,3,221,1,586.83,NULL,'2023-03-06 18:24:28','2023-03-06 18:24:28',NULL),(1114,7812,317,40720,1548,3,57,2,5000.00,NULL,'2023-03-06 18:24:28','2023-03-06 18:24:28',NULL),(1115,7812,318,40720,1548,3,217,1,5338.64,NULL,'2023-03-06 18:24:52','2023-03-06 18:24:52',NULL),(1116,7812,318,40720,1548,3,68,1,1121.11,NULL,'2023-03-06 18:24:52','2023-03-06 18:24:52',NULL),(1117,7812,318,40720,1548,3,221,1,1040.25,NULL,'2023-03-06 18:24:52','2023-03-06 18:24:52',NULL),(1118,7812,318,40720,1548,3,57,2,7500.00,NULL,'2023-03-06 18:24:52','2023-03-06 18:24:52',NULL),(1119,7812,319,40720,1548,3,217,1,60991.74,NULL,'2023-03-06 18:25:45','2023-03-06 18:25:45',NULL),(1120,7812,319,40720,1548,3,68,1,12808.27,NULL,'2023-03-06 18:25:45','2023-03-06 18:25:45',NULL),(1121,7812,319,40720,1548,3,57,2,73800.01,NULL,'2023-03-06 18:25:45','2023-03-06 18:25:45',NULL);
INSERT INTO `balance_libro_details` VALUES (1122,7812,320,40720,1548,3,217,1,2066.12,NULL,'2023-03-06 18:26:25','2023-03-06 18:26:25',NULL),(1123,7812,320,40720,1548,3,68,1,433.89,NULL,'2023-03-06 18:26:25','2023-03-06 18:26:25',NULL),(1124,7812,320,40720,1548,3,57,2,2500.01,NULL,'2023-03-06 18:26:25','2023-03-06 18:26:25',NULL),(1125,7812,321,40720,1544,15,68,2,90917.28,NULL,'2023-03-06 18:44:43','2023-03-06 18:44:43',NULL),(1126,7812,321,40720,1544,15,353,2,90889.82,NULL,'2023-03-06 18:44:43','2023-03-06 18:44:43',NULL),(1127,7812,321,40720,1544,15,353,1,181807.10,NULL,'2023-03-06 18:44:43','2023-03-06 18:44:43',NULL),(1128,7812,322,40720,1548,15,68,2,58730.66,NULL,'2023-03-07 09:17:00','2023-03-07 09:17:00',NULL),(1129,7812,322,40720,1548,15,353,2,181807.10,NULL,'2023-03-07 09:17:00','2023-03-07 09:17:00',NULL),(1130,7812,322,40720,1548,15,353,1,240537.76,NULL,'2023-03-07 09:17:00','2023-03-07 09:17:00',NULL),(1131,7812,323,40720,1549,3,217,1,97776.95,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1132,7812,323,40720,1549,3,68,1,20533.16,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1133,7812,323,40720,1549,3,57,2,118310.11,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1134,7812,324,40720,1549,3,217,1,25113.60,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1135,7812,324,40720,1549,3,68,1,5273.85,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1136,7812,324,40720,1549,3,57,2,30387.45,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1137,7812,325,40720,1549,3,217,1,10330.58,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1138,7812,325,40720,1549,3,68,1,2169.42,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1139,7812,325,40720,1549,3,57,2,12500.00,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1140,7812,326,40720,1549,3,217,1,8789.51,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1141,7812,326,40720,1549,3,68,1,1845.80,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1142,7812,326,40720,1549,3,57,2,10635.31,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1143,7812,327,40720,1549,3,217,1,64461.98,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1144,7812,327,40720,1549,3,68,1,13537.02,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1145,7812,327,40720,1549,3,57,2,77999.00,NULL,'2023-03-25 15:56:44','2023-03-25 15:56:44',NULL),(1146,7812,328,40720,1549,3,217,1,18996.00,NULL,'2023-03-25 15:56:45','2023-03-25 15:56:45',NULL),(1147,7812,328,40720,1549,3,68,1,3989.16,NULL,'2023-03-25 15:56:45','2023-03-25 15:56:45',NULL),(1148,7812,328,40720,1549,3,57,2,22985.16,NULL,'2023-03-25 15:56:45','2023-03-25 15:56:45',NULL),(1149,7812,329,40720,1549,3,217,1,50449.40,NULL,'2023-03-25 15:56:45','2023-03-25 15:56:45',NULL),(1150,7812,329,40720,1549,3,68,1,10594.37,NULL,'2023-03-25 15:56:45','2023-03-25 15:56:45',NULL),(1151,7812,329,40720,1549,3,57,2,61043.77,NULL,'2023-03-25 15:56:45','2023-03-25 15:56:45',NULL),(1152,7812,330,40720,1549,3,217,1,15136.06,NULL,'2023-03-25 16:14:26','2023-03-25 16:14:26',NULL),(1153,7812,330,40720,1549,3,68,1,3178.57,NULL,'2023-03-25 16:14:26','2023-03-25 16:14:26',NULL),(1154,7812,330,40720,1549,3,221,1,1685.36,NULL,'2023-03-25 16:14:26','2023-03-25 16:14:26',NULL),(1155,7812,330,40720,1549,3,57,2,19999.99,NULL,'2023-03-25 16:14:26','2023-03-25 16:14:26',NULL),(1156,7812,331,40720,1549,3,217,1,19027.08,NULL,'2023-03-25 16:15:27','2023-03-25 16:15:27',NULL),(1157,7812,331,40720,1549,3,68,1,3995.69,NULL,'2023-03-25 16:15:27','2023-03-25 16:15:27',NULL),(1158,7812,331,40720,1549,3,221,1,1984.53,NULL,'2023-03-25 16:15:27','2023-03-25 16:15:27',NULL),(1159,7812,331,40720,1549,3,57,2,25007.30,NULL,'2023-03-25 16:15:27','2023-03-25 16:15:27',NULL),(1160,7812,332,40720,1549,3,217,1,15139.85,NULL,'2023-03-25 16:15:59','2023-03-25 16:15:59',NULL),(1161,7812,332,40720,1549,3,68,1,3179.37,NULL,'2023-03-25 16:15:59','2023-03-25 16:15:59',NULL),(1162,7812,332,40720,1549,3,221,1,1685.79,NULL,'2023-03-25 16:15:59','2023-03-25 16:15:59',NULL);
INSERT INTO `balance_libro_details` VALUES (1163,7812,332,40720,1549,3,57,2,20005.01,NULL,'2023-03-25 16:15:59','2023-03-25 16:15:59',NULL),(1164,7812,333,40720,1549,3,217,1,2869.69,NULL,'2023-03-25 16:16:37','2023-03-25 16:16:37',NULL),(1165,7812,333,40720,1549,3,68,1,602.63,NULL,'2023-03-25 16:16:37','2023-03-25 16:16:37',NULL),(1166,7812,333,40720,1549,3,221,1,528.08,NULL,'2023-03-25 16:16:37','2023-03-25 16:16:37',NULL),(1167,7812,333,40720,1549,3,57,2,4000.40,NULL,'2023-03-25 16:16:37','2023-03-25 16:16:37',NULL),(1168,7812,334,40720,1549,3,217,1,13622.45,NULL,'2023-03-25 16:17:16','2023-03-25 16:17:16',NULL),(1169,7812,334,40720,1549,3,68,1,2860.71,NULL,'2023-03-25 16:17:16','2023-03-25 16:17:16',NULL),(1170,7812,334,40720,1549,3,221,1,1516.83,NULL,'2023-03-25 16:17:16','2023-03-25 16:17:16',NULL),(1171,7812,334,40720,1549,3,57,2,17999.99,NULL,'2023-03-25 16:17:16','2023-03-25 16:17:16',NULL),(1172,7812,335,40720,1549,3,217,1,13621.01,NULL,'2023-03-25 16:17:51','2023-03-25 16:17:51',NULL),(1173,7812,335,40720,1549,3,68,1,2860.41,NULL,'2023-03-25 16:17:51','2023-03-25 16:17:51',NULL),(1174,7812,335,40720,1549,3,221,1,1516.67,NULL,'2023-03-25 16:17:51','2023-03-25 16:17:51',NULL),(1175,7812,335,40720,1549,3,57,2,17998.09,NULL,'2023-03-25 16:17:51','2023-03-25 16:17:51',NULL),(1176,7812,336,40720,1549,3,217,1,27925.57,NULL,'2023-03-25 16:18:18','2023-03-25 16:18:18',NULL),(1177,7812,336,40720,1549,3,68,1,5864.37,NULL,'2023-03-25 16:18:18','2023-03-25 16:18:18',NULL),(1178,7812,336,40720,1549,3,221,1,3010.16,NULL,'2023-03-25 16:18:18','2023-03-25 16:18:18',NULL),(1179,7812,336,40720,1549,3,57,2,36800.10,NULL,'2023-03-25 16:18:18','2023-03-25 16:18:18',NULL),(1180,7812,337,40720,1549,3,217,1,22790.39,NULL,'2023-03-25 16:18:44','2023-03-25 16:18:44',NULL),(1181,7812,337,40720,1549,3,68,1,4785.98,NULL,'2023-03-25 16:18:44','2023-03-25 16:18:44',NULL),(1182,7812,337,40720,1549,3,221,1,2456.63,NULL,'2023-03-25 16:18:44','2023-03-25 16:18:44',NULL),(1183,7812,337,40720,1549,3,57,2,30033.00,NULL,'2023-03-25 16:18:44','2023-03-25 16:18:44',NULL),(1184,7812,338,40720,1549,3,217,1,20871.39,NULL,'2023-03-25 16:19:35','2023-03-25 16:19:35',NULL),(1185,7812,338,40720,1549,3,68,1,4382.99,NULL,'2023-03-25 16:19:35','2023-03-25 16:19:35',NULL),(1186,7812,338,40720,1549,3,221,1,1913.01,NULL,'2023-03-25 16:19:35','2023-03-25 16:19:35',NULL),(1187,7812,338,40720,1549,3,57,2,27167.39,NULL,'2023-03-25 16:19:35','2023-03-25 16:19:35',NULL),(1188,7812,339,40720,1549,3,217,1,18216.02,NULL,'2023-03-25 16:20:33','2023-03-25 16:20:33',NULL),(1189,7812,339,40720,1549,3,68,1,3825.36,NULL,'2023-03-25 16:20:33','2023-03-25 16:20:33',NULL),(1190,7812,339,40720,1549,3,221,1,1963.54,NULL,'2023-03-25 16:20:33','2023-03-25 16:20:33',NULL),(1191,7812,339,40720,1549,3,57,2,24004.92,NULL,'2023-03-25 16:20:33','2023-03-25 16:20:33',NULL),(1192,7812,340,40720,1549,3,217,1,15215.83,NULL,'2023-03-25 16:21:04','2023-03-25 16:21:04',NULL),(1193,7812,340,40720,1549,3,68,1,3195.32,NULL,'2023-03-25 16:21:04','2023-03-25 16:21:04',NULL),(1194,7812,340,40720,1549,3,221,1,1640.15,NULL,'2023-03-25 16:21:04','2023-03-25 16:21:04',NULL),(1195,7812,340,40720,1549,3,57,2,20051.30,NULL,'2023-03-25 16:21:04','2023-03-25 16:21:04',NULL),(1196,7812,341,40720,1549,3,217,1,7588.45,NULL,'2023-03-25 16:21:38','2023-03-25 16:21:38',NULL),(1197,7812,341,40720,1549,3,68,1,1593.57,NULL,'2023-03-25 16:21:38','2023-03-25 16:21:38',NULL),(1198,7812,341,40720,1549,3,221,1,817.98,NULL,'2023-03-25 16:21:38','2023-03-25 16:21:38',NULL),(1199,7812,341,40720,1549,3,57,2,10000.00,NULL,'2023-03-25 16:21:38','2023-03-25 16:21:38',NULL),(1200,7812,342,40720,1549,3,217,1,13586.87,NULL,'2023-03-25 16:22:19','2023-03-25 16:22:19',NULL),(1201,7812,342,40720,1549,3,68,1,2853.24,NULL,'2023-03-25 16:22:19','2023-03-25 16:22:19',NULL),(1202,7812,342,40720,1549,3,221,1,1559.89,NULL,'2023-03-25 16:22:19','2023-03-25 16:22:19',NULL),(1203,7812,342,40720,1549,3,57,2,18000.00,NULL,'2023-03-25 16:22:19','2023-03-25 16:22:19',NULL);
INSERT INTO `balance_libro_details` VALUES (1204,7812,343,40720,1549,3,217,1,7548.26,NULL,'2023-03-25 16:23:02','2023-03-25 16:23:02',NULL),(1205,7812,343,40720,1549,3,68,1,1585.13,NULL,'2023-03-25 16:23:02','2023-03-25 16:23:02',NULL),(1206,7812,343,40720,1549,3,221,1,866.61,NULL,'2023-03-25 16:23:02','2023-03-25 16:23:02',NULL),(1207,7812,343,40720,1549,3,57,2,10000.00,NULL,'2023-03-25 16:23:02','2023-03-25 16:23:02',NULL),(1208,7812,344,40720,1549,3,217,1,13603.93,NULL,'2023-03-25 16:23:30','2023-03-25 16:23:30',NULL),(1209,7812,344,40720,1549,3,68,1,2856.83,NULL,'2023-03-25 16:23:30','2023-03-25 16:23:30',NULL),(1210,7812,344,40720,1549,3,221,1,1539.25,NULL,'2023-03-25 16:23:30','2023-03-25 16:23:30',NULL),(1211,7812,344,40720,1549,3,57,2,18000.01,NULL,'2023-03-25 16:23:30','2023-03-25 16:23:30',NULL),(1212,7812,345,40720,1549,3,217,1,1587.13,NULL,'2023-03-25 16:24:30','2023-03-25 16:24:30',NULL),(1213,7812,345,40720,1549,3,68,1,333.30,NULL,'2023-03-25 16:24:30','2023-03-25 16:24:30',NULL),(1214,7812,345,40720,1549,3,221,1,855.14,NULL,'2023-03-25 16:24:30','2023-03-25 16:24:30',NULL),(1215,7812,345,40720,1549,3,57,2,2775.57,NULL,'2023-03-25 16:24:30','2023-03-25 16:24:30',NULL),(1216,7812,346,40720,1549,3,217,1,2135.45,NULL,'2023-03-25 16:25:06','2023-03-25 16:25:06',NULL),(1217,7812,346,40720,1549,3,68,1,448.44,NULL,'2023-03-25 16:25:06','2023-03-25 16:25:06',NULL),(1218,7812,346,40720,1549,3,221,1,416.10,NULL,'2023-03-25 16:25:06','2023-03-25 16:25:06',NULL),(1219,7812,346,40720,1549,3,57,2,2999.99,NULL,'2023-03-25 16:25:06','2023-03-25 16:25:06',NULL),(1220,7812,347,40720,1549,3,217,1,3388.43,NULL,'2023-03-25 16:27:52','2023-03-25 16:27:52',NULL),(1221,7812,347,40720,1549,3,68,1,711.57,NULL,'2023-03-25 16:27:52','2023-03-25 16:27:52',NULL),(1222,7812,347,40720,1549,3,57,2,4100.00,NULL,'2023-03-25 16:27:52','2023-03-25 16:27:52',NULL),(1223,7812,348,40720,1549,3,217,1,11074.38,NULL,'2023-03-25 16:28:50','2023-03-25 16:28:50',NULL),(1224,7812,348,40720,1549,3,68,1,2325.62,NULL,'2023-03-25 16:28:50','2023-03-25 16:28:50',NULL),(1225,7812,348,40720,1549,3,57,2,13400.00,NULL,'2023-03-25 16:28:50','2023-03-25 16:28:50',NULL),(1226,7812,349,40720,1549,2,96,2,3305.78,NULL,'2023-03-25 16:35:58','2023-03-25 16:36:29','2023-03-25 16:36:29'),(1227,7812,349,40720,1549,2,67,2,694.21,NULL,'2023-03-25 16:35:58','2023-03-25 16:36:29','2023-03-25 16:36:29'),(1228,7812,349,40720,1549,2,13,1,3999.99,NULL,'2023-03-25 16:35:58','2023-03-25 16:36:29','2023-03-25 16:36:29'),(1229,7812,350,40720,1549,2,96,2,3305.79,NULL,'2023-03-25 16:36:29','2023-03-25 16:36:29',NULL),(1230,7812,350,40720,1549,2,67,2,694.22,NULL,'2023-03-25 16:36:29','2023-03-25 16:36:29',NULL),(1231,7812,350,40720,1549,2,13,1,4000.01,NULL,'2023-03-25 16:36:29','2023-03-25 16:36:29',NULL),(1232,7812,351,40720,1549,15,67,1,694.22,NULL,'2023-03-25 16:45:21','2023-03-25 16:45:21',NULL),(1233,7812,351,40720,1549,15,68,2,109381.91,NULL,'2023-03-25 16:45:21','2023-03-25 16:45:21',NULL),(1234,7812,351,40720,1549,15,353,2,240537.76,NULL,'2023-03-25 16:45:21','2023-03-25 16:45:21',NULL),(1235,7812,351,40720,1549,15,353,1,349225.45,NULL,'2023-03-25 16:45:21','2023-03-25 16:45:21',NULL),(1236,7812,352,40720,1550,2,218,2,0.00,NULL,'2023-04-25 10:50:56','2023-04-25 10:54:21','2023-04-25 10:54:21'),(1237,7812,352,40720,1550,2,218,2,22000.00,NULL,'2023-04-25 10:50:56','2023-04-25 10:54:21','2023-04-25 10:54:21'),(1238,7812,352,40720,1550,2,13,1,22000.00,NULL,'2023-04-25 10:50:56','2023-04-25 10:54:21','2023-04-25 10:54:21'),(1239,7812,353,40720,1550,3,217,1,4132.24,NULL,'2023-04-25 10:51:09','2023-04-25 10:51:09',NULL),(1240,7812,353,40720,1550,3,68,1,867.77,NULL,'2023-04-25 10:51:09','2023-04-25 10:51:09',NULL),(1241,7812,353,40720,1550,3,57,2,5000.01,NULL,'2023-04-25 10:51:09','2023-04-25 10:51:09',NULL),(1242,7812,354,40720,1550,3,217,1,45454.55,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1243,7812,354,40720,1550,3,68,1,9545.45,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL);
INSERT INTO `balance_libro_details` VALUES (1244,7812,354,40720,1550,3,57,2,55000.00,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1245,7812,355,40720,1550,3,217,1,5371.90,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1246,7812,355,40720,1550,3,68,1,1128.10,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1247,7812,355,40720,1550,3,57,2,6500.00,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1248,7812,356,40720,1550,3,217,1,15247.93,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1249,7812,356,40720,1550,3,68,1,3202.07,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1250,7812,356,40720,1550,3,57,2,18450.00,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1251,7812,357,40720,1550,3,217,1,2892.56,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1252,7812,357,40720,1550,3,68,1,607.44,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1253,7812,357,40720,1550,3,57,2,3500.00,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1254,7812,358,40720,1550,3,217,1,23015.99,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1255,7812,358,40720,1550,3,68,1,4833.35,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1256,7812,358,40720,1550,3,57,2,27849.34,NULL,'2023-04-25 10:51:10','2023-04-25 10:51:10',NULL),(1257,7812,359,40720,1550,2,96,2,18181.82,NULL,'2023-04-25 10:54:21','2023-04-25 10:54:21',NULL),(1258,7812,359,40720,1550,2,67,2,3818.18,NULL,'2023-04-25 10:54:21','2023-04-25 10:54:21',NULL),(1259,7812,359,40720,1550,2,13,1,22000.00,NULL,'2023-04-25 10:54:21','2023-04-25 10:54:21',NULL),(1260,7812,360,40720,1550,15,67,1,3818.18,NULL,'2023-04-25 11:16:35','2023-04-25 11:16:35',NULL),(1261,7812,360,40720,1550,15,68,2,20184.19,NULL,'2023-04-25 11:16:35','2023-04-25 11:16:35',NULL),(1262,7812,360,40720,1550,15,353,2,349225.45,NULL,'2023-04-25 11:16:35','2023-04-25 11:16:35',NULL),(1263,7812,360,40720,1550,15,353,1,365591.46,NULL,'2023-04-25 11:16:35','2023-04-25 11:16:35',NULL),(1264,7812,361,40787,3045,2,96,2,324297.52,NULL,'2023-05-29 09:04:52','2023-05-29 09:04:52',NULL),(1265,7812,361,40787,3045,2,67,2,68102.48,NULL,'2023-05-29 09:04:52','2023-05-29 09:04:52',NULL),(1266,7812,361,40787,3045,2,13,1,392400.00,NULL,'2023-05-29 09:04:52','2023-05-29 09:04:52',NULL),(1267,7812,362,40787,3045,2,96,2,426745.29,NULL,'2023-05-29 09:04:52','2023-05-29 09:04:52',NULL),(1268,7812,362,40787,3045,2,67,2,89616.51,NULL,'2023-05-29 09:04:52','2023-05-29 09:04:52',NULL),(1269,7812,362,40787,3045,2,13,1,516361.80,NULL,'2023-05-29 09:04:52','2023-05-29 09:04:52',NULL),(1270,7812,363,40787,3047,2,218,2,0.00,NULL,'2023-05-29 09:05:14','2023-05-29 09:39:42','2023-05-29 09:39:42'),(1271,7812,363,40787,3047,2,218,2,616737.19,NULL,'2023-05-29 09:05:14','2023-05-29 09:39:42','2023-05-29 09:39:42'),(1272,7812,363,40787,3047,2,13,1,616737.19,NULL,'2023-05-29 09:05:14','2023-05-29 09:39:42','2023-05-29 09:39:42'),(1273,7812,364,40787,3047,2,218,2,0.00,NULL,'2023-05-29 09:05:14','2023-06-05 17:31:04','2023-06-05 17:31:04'),(1274,7812,364,40787,3047,2,218,2,616737.19,NULL,'2023-05-29 09:05:14','2023-06-05 17:31:04','2023-06-05 17:31:04'),(1275,7812,364,40787,3047,2,13,1,616737.19,NULL,'2023-05-29 09:05:14','2023-06-05 17:31:04','2023-06-05 17:31:04'),(1276,7812,365,40787,3047,2,218,1,0.00,NULL,'2023-05-29 09:05:14','2023-05-29 09:05:14',NULL),(1277,7812,365,40787,3047,2,218,1,616737.19,NULL,'2023-05-29 09:05:14','2023-05-29 09:05:14',NULL),(1278,7812,365,40787,3047,2,13,2,616737.19,NULL,'2023-05-29 09:05:14','2023-05-29 09:05:14',NULL),(1279,7812,366,40787,3047,2,218,2,0.00,NULL,'2023-05-29 09:05:14','2023-05-29 09:40:07','2023-05-29 09:40:07'),(1280,7812,366,40787,3047,2,218,2,502046.71,NULL,'2023-05-29 09:05:14','2023-05-29 09:40:07','2023-05-29 09:40:07'),(1281,7812,366,40787,3047,2,13,1,502046.71,NULL,'2023-05-29 09:05:14','2023-05-29 09:40:07','2023-05-29 09:40:07'),(1282,7812,367,40787,3048,2,218,2,0.00,NULL,'2023-05-29 09:06:05','2023-05-29 09:40:33','2023-05-29 09:40:33');
INSERT INTO `balance_libro_details` VALUES (1283,7812,367,40787,3048,2,218,2,850200.00,NULL,'2023-05-29 09:06:05','2023-05-29 09:40:33','2023-05-29 09:40:33'),(1284,7812,367,40787,3048,2,13,1,850200.00,NULL,'2023-05-29 09:06:05','2023-05-29 09:40:33','2023-05-29 09:40:33'),(1285,7812,368,40787,3048,2,96,2,148760.33,NULL,'2023-05-29 09:06:05','2023-05-29 09:06:05',NULL),(1286,7812,368,40787,3048,2,67,2,31239.67,NULL,'2023-05-29 09:06:05','2023-05-29 09:06:05',NULL),(1287,7812,368,40787,3048,2,13,1,180000.00,NULL,'2023-05-29 09:06:05','2023-05-29 09:06:05',NULL),(1288,7812,369,40787,3047,3,217,1,159026.45,NULL,'2023-05-29 09:07:17','2023-05-29 09:07:17',NULL),(1289,7812,369,40787,3047,3,68,1,33395.55,NULL,'2023-05-29 09:07:17','2023-05-29 09:07:17',NULL),(1290,7812,369,40787,3047,3,57,2,192422.00,NULL,'2023-05-29 09:07:17','2023-05-29 09:07:17',NULL),(1291,7812,370,40787,3048,3,217,1,139238.61,NULL,'2023-05-29 09:07:30','2023-05-29 09:07:30',NULL),(1292,7812,370,40787,3048,3,68,1,29240.11,NULL,'2023-05-29 09:07:30','2023-05-29 09:07:30',NULL),(1293,7812,370,40787,3048,3,57,2,168478.72,NULL,'2023-05-29 09:07:30','2023-05-29 09:07:30',NULL),(1294,7812,371,40787,3048,3,217,1,164416.93,NULL,'2023-05-29 09:07:30','2023-05-29 09:07:30',NULL),(1295,7812,371,40787,3048,3,68,1,34527.56,NULL,'2023-05-29 09:07:30','2023-05-29 09:07:30',NULL),(1296,7812,371,40787,3048,3,57,2,198944.49,NULL,'2023-05-29 09:07:30','2023-05-29 09:07:30',NULL),(1297,7812,372,40787,3048,3,217,1,7806.81,NULL,'2023-05-29 09:20:45','2023-05-29 09:20:45',NULL),(1298,7812,372,40787,3048,3,68,1,1639.43,NULL,'2023-05-29 09:20:45','2023-05-29 09:20:45',NULL),(1299,7812,372,40787,3048,3,221,1,557.96,NULL,'2023-05-29 09:20:45','2023-05-29 09:20:45',NULL),(1300,7812,372,40787,3048,3,57,2,10004.20,NULL,'2023-05-29 09:20:45','2023-05-29 09:20:45',NULL),(1301,7812,373,40787,3048,3,217,1,4682.13,NULL,'2023-05-29 09:22:37','2023-05-29 09:22:37',NULL),(1302,7812,373,40787,3048,3,68,1,983.25,NULL,'2023-05-29 09:22:37','2023-05-29 09:22:37',NULL),(1303,7812,373,40787,3048,3,221,1,334.63,NULL,'2023-05-29 09:22:37','2023-05-29 09:22:37',NULL),(1304,7812,373,40787,3048,3,57,2,6000.01,NULL,'2023-05-29 09:22:37','2023-05-29 09:22:37',NULL),(1305,7812,374,40787,3048,3,217,1,13116.21,NULL,'2023-05-29 09:23:34','2023-05-29 09:23:34',NULL),(1306,7812,374,40787,3048,3,68,1,2754.40,NULL,'2023-05-29 09:23:34','2023-05-29 09:23:34',NULL),(1307,7812,374,40787,3048,3,221,1,1129.35,NULL,'2023-05-29 09:23:34','2023-05-29 09:23:34',NULL),(1308,7812,374,40787,3048,3,57,2,16999.96,NULL,'2023-05-29 09:23:34','2023-05-29 09:23:34',NULL),(1309,7812,375,40787,3048,3,217,1,9823.41,NULL,'2023-05-29 09:24:30','2023-05-29 09:24:30',NULL),(1310,7812,375,40787,3048,3,68,1,2062.92,NULL,'2023-05-29 09:24:30','2023-05-29 09:24:30',NULL),(1311,7812,375,40787,3048,3,221,1,913.69,NULL,'2023-05-29 09:24:30','2023-05-29 09:24:30',NULL),(1312,7812,375,40787,3048,3,57,2,12800.02,NULL,'2023-05-29 09:24:30','2023-05-29 09:24:30',NULL),(1313,7812,376,40787,3048,3,217,1,6722.64,NULL,'2023-05-29 09:25:13','2023-05-29 09:25:13',NULL),(1314,7812,376,40787,3048,3,68,1,1411.75,NULL,'2023-05-29 09:25:13','2023-05-29 09:25:13',NULL),(1315,7812,376,40787,3048,3,221,1,865.60,NULL,'2023-05-29 09:25:13','2023-05-29 09:25:13',NULL),(1316,7812,376,40787,3048,3,57,2,8999.99,NULL,'2023-05-29 09:25:13','2023-05-29 09:25:13',NULL),(1317,7812,377,40787,3048,3,217,1,11717.14,NULL,'2023-05-29 09:25:45','2023-05-29 09:25:45',NULL),(1318,7812,377,40787,3048,3,68,1,2460.60,NULL,'2023-05-29 09:25:45','2023-05-29 09:25:45',NULL),(1319,7812,377,40787,3048,3,221,1,822.26,NULL,'2023-05-29 09:25:45','2023-05-29 09:25:45',NULL),(1320,7812,377,40787,3048,3,57,2,15000.00,NULL,'2023-05-29 09:25:45','2023-05-29 09:25:45',NULL),(1321,7812,378,40787,3048,3,217,1,3903.02,NULL,'2023-05-29 09:32:37','2023-05-29 09:32:37',NULL),(1322,7812,378,40787,3048,3,68,1,819.63,NULL,'2023-05-29 09:32:37','2023-05-29 09:32:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1323,7812,378,40787,3048,3,221,1,278.95,NULL,'2023-05-29 09:32:37','2023-05-29 09:32:37',NULL),(1324,7812,378,40787,3048,3,57,2,5001.60,NULL,'2023-05-29 09:32:37','2023-05-29 09:32:37',NULL),(1325,7812,379,40787,3047,2,96,2,509700.16,NULL,'2023-05-29 09:39:42','2023-06-05 17:30:05','2023-06-05 17:30:05'),(1326,7812,379,40787,3047,2,67,2,107037.03,NULL,'2023-05-29 09:39:42','2023-06-05 17:30:05','2023-06-05 17:30:05'),(1327,7812,379,40787,3047,2,13,1,616737.19,NULL,'2023-05-29 09:39:42','2023-06-05 17:30:05','2023-06-05 17:30:05'),(1328,7812,380,40787,3047,2,96,2,414914.64,NULL,'2023-05-29 09:40:07','2023-05-29 09:40:07',NULL),(1329,7812,380,40787,3047,2,67,2,87132.07,NULL,'2023-05-29 09:40:07','2023-05-29 09:40:07',NULL),(1330,7812,380,40787,3047,2,13,1,502046.71,NULL,'2023-05-29 09:40:07','2023-05-29 09:40:07',NULL),(1331,7812,381,40787,3048,2,96,2,702644.63,NULL,'2023-05-29 09:40:33','2023-05-29 09:40:33',NULL),(1332,7812,381,40787,3048,2,67,2,147555.37,NULL,'2023-05-29 09:40:33','2023-05-29 09:40:33',NULL),(1333,7812,381,40787,3048,2,13,1,850200.00,NULL,'2023-05-29 09:40:33','2023-05-29 09:40:33',NULL),(1334,7812,382,40720,1551,3,217,1,2975.21,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1335,7812,382,40720,1551,3,68,1,624.79,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1336,7812,382,40720,1551,3,57,2,3600.00,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1337,7812,383,40720,1551,3,217,1,3080.83,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1338,7812,383,40720,1551,3,68,1,646.97,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1339,7812,383,40720,1551,3,57,2,3727.80,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1340,7812,384,40720,1551,3,217,1,22515.98,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1341,7812,384,40720,1551,3,68,1,4728.35,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1342,7812,384,40720,1551,3,57,2,27244.33,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1343,7812,385,40720,1551,3,217,1,15930.00,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1344,7812,385,40720,1551,3,68,1,3345.30,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1345,7812,385,40720,1551,3,57,2,19275.30,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1346,7812,386,40720,1551,3,217,1,22515.98,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1347,7812,386,40720,1551,3,68,1,4728.35,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1348,7812,386,40720,1551,3,57,2,27244.33,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1349,7812,387,40720,1551,3,217,1,8512.39,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1350,7812,387,40720,1551,3,68,1,1787.60,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1351,7812,387,40720,1551,3,57,2,10299.99,NULL,'2023-06-03 09:32:39','2023-06-03 09:32:39',NULL),(1352,7812,388,40720,1551,15,68,2,15861.38,NULL,'2023-06-03 09:50:07','2023-06-03 09:50:07',NULL),(1353,7812,388,40720,1551,15,353,2,365591.46,NULL,'2023-06-03 09:50:07','2023-06-03 09:50:07',NULL),(1354,7812,388,40720,1551,15,353,1,381452.84,NULL,'2023-06-03 09:50:07','2023-06-03 09:50:07',NULL),(1355,7812,389,40787,3047,2,218,2,616737.19,NULL,'2023-06-05 17:30:05','2023-06-05 17:30:05',NULL),(1356,7812,389,40787,3047,2,13,1,616737.19,NULL,'2023-06-05 17:30:05','2023-06-05 17:30:05',NULL),(1357,7812,390,40787,3047,2,96,2,509700.16,NULL,'2023-06-05 17:31:04','2023-06-05 17:31:04',NULL),(1358,7812,390,40787,3047,2,67,2,107037.03,NULL,'2023-06-05 17:31:04','2023-06-05 17:31:04',NULL),(1359,7812,390,40787,3047,2,13,1,616737.19,NULL,'2023-06-05 17:31:04','2023-06-05 17:31:04',NULL),(1360,7812,391,40720,1552,2,96,2,279798.00,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1361,7812,391,40720,1552,2,67,2,58757.58,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1362,7812,391,40720,1552,2,13,1,338555.58,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL);
INSERT INTO `balance_libro_details` VALUES (1363,7812,392,40720,1552,2,96,2,127608.00,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1364,7812,392,40720,1552,2,67,2,26797.68,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1365,7812,392,40720,1552,2,13,1,154405.68,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1366,7812,393,40720,1552,2,96,2,191184.00,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1367,7812,393,40720,1552,2,67,2,40148.64,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1368,7812,393,40720,1552,2,13,1,231332.64,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1369,7812,394,40720,1552,2,96,2,131292.00,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1370,7812,394,40720,1552,2,67,2,27571.32,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1371,7812,394,40720,1552,2,13,1,158863.32,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1372,7812,395,40720,1552,2,96,1,191184.00,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1373,7812,395,40720,1552,2,68,1,40148.64,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1374,7812,395,40720,1552,2,13,2,231332.64,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1375,7812,396,40720,1552,2,96,2,124412.00,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1376,7812,396,40720,1552,2,67,2,26126.52,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1377,7812,396,40720,1552,2,13,1,150538.52,NULL,'2023-06-21 07:19:43','2023-06-21 07:19:43',NULL),(1378,7812,397,40720,1552,3,217,1,22515.98,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1379,7812,397,40720,1552,3,68,1,4728.35,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1380,7812,397,40720,1552,3,57,2,27244.33,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1381,7812,398,40720,1552,3,217,1,22515.98,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1382,7812,398,40720,1552,3,68,1,4728.35,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1383,7812,398,40720,1552,3,57,2,27244.33,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1384,7812,399,40720,1552,3,217,1,8263.64,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1385,7812,399,40720,1552,3,68,1,1735.36,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1386,7812,399,40720,1552,3,57,2,9999.00,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1387,7812,400,40720,1552,3,217,1,1085.00,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1388,7812,400,40720,1552,3,68,1,227.85,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1389,7812,400,40720,1552,3,57,2,1312.85,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1390,7812,401,40720,1552,3,217,1,5808.00,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1391,7812,401,40720,1552,3,68,1,1219.68,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1392,7812,401,40720,1552,3,217,1,0.86,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1393,7812,401,40720,1552,3,57,2,7235.80,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1394,7812,401,40720,1552,3,136,1,207.26,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1395,7812,402,40720,1552,3,217,1,8660.77,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1396,7812,402,40720,1552,3,68,1,1818.76,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1397,7812,402,40720,1552,3,57,2,10479.53,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1398,7812,403,40720,1552,3,217,1,2396.69,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1399,7812,403,40720,1552,3,68,1,503.30,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1400,7812,403,40720,1552,3,57,2,2899.99,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1401,7812,404,40720,1552,3,217,2,22515.98,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1402,7812,404,40720,1552,3,67,2,4728.35,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1403,7812,404,40720,1552,3,57,1,27244.33,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL);
INSERT INTO `balance_libro_details` VALUES (1404,7812,405,40720,1552,3,217,2,22515.98,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1405,7812,405,40720,1552,3,67,2,4728.35,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1406,7812,405,40720,1552,3,57,1,27244.33,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1407,7812,406,40720,1552,3,217,1,943.28,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1408,7812,406,40720,1552,3,68,1,99.04,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1409,7812,406,40720,1552,3,57,2,1042.32,NULL,'2023-06-21 07:19:54','2023-06-21 07:19:54',NULL),(1410,7812,407,40720,1552,15,67,1,188858.45,NULL,'2023-06-21 07:49:11','2023-06-21 07:49:11',NULL),(1411,7812,407,40720,1552,15,68,2,55209.36,NULL,'2023-06-21 07:49:11','2023-06-21 07:49:11',NULL),(1412,7812,407,40720,1552,15,353,2,381452.84,NULL,'2023-06-21 07:49:11','2023-06-21 07:49:11',NULL),(1413,7812,407,40720,1552,15,353,1,247803.74,NULL,'2023-06-21 07:49:11','2023-06-21 07:49:11',NULL),(1414,7812,407,40720,1552,15,136,1,0.01,NULL,'2023-06-21 07:49:11','2023-06-21 07:49:11',NULL),(1415,7812,408,40787,3045,15,67,1,157718.99,NULL,'2023-06-21 20:03:01','2023-06-21 20:03:01',NULL),(1416,7812,408,40787,3045,15,74,2,157718.99,NULL,'2023-06-21 20:03:01','2023-06-21 20:03:01',NULL),(1417,7812,409,40787,3047,15,67,1,194169.11,NULL,'2023-06-21 20:03:19','2023-06-21 20:03:19',NULL),(1418,7812,409,40787,3047,15,68,2,33395.55,NULL,'2023-06-21 20:03:19','2023-06-21 20:03:19',NULL),(1419,7812,409,40787,3047,15,74,2,160773.55,NULL,'2023-06-21 20:03:19','2023-06-21 20:03:19',NULL),(1420,7812,409,40787,3047,15,136,2,0.01,NULL,'2023-06-21 20:03:19','2023-06-21 20:03:19',NULL),(1421,7812,410,40787,3048,15,67,1,178795.04,NULL,'2023-06-30 18:09:39','2023-06-30 18:09:39',NULL),(1422,7812,410,40787,3048,15,68,2,75899.65,NULL,'2023-06-30 18:09:39','2023-06-30 18:09:39',NULL),(1423,7812,410,40787,3048,15,74,2,102895.39,NULL,'2023-06-30 18:09:39','2023-06-30 18:09:39',NULL),(1424,7812,411,40787,3049,2,96,2,161157.02,NULL,'2023-06-30 18:24:12','2023-06-30 18:24:12',NULL),(1425,7812,411,40787,3049,2,67,2,33842.98,NULL,'2023-06-30 18:24:12','2023-06-30 18:24:12',NULL),(1426,7812,411,40787,3049,2,13,1,195000.00,NULL,'2023-06-30 18:24:12','2023-06-30 18:24:12',NULL),(1427,7812,412,40787,3050,2,96,2,299781.82,NULL,'2023-06-30 18:24:26','2023-06-30 18:24:26',NULL),(1428,7812,412,40787,3050,2,67,2,62954.18,NULL,'2023-06-30 18:24:26','2023-06-30 18:24:26',NULL),(1429,7812,412,40787,3050,2,13,1,362736.00,NULL,'2023-06-30 18:24:26','2023-06-30 18:24:26',NULL),(1430,7812,413,40787,3050,2,96,2,649527.27,NULL,'2023-06-30 18:24:26','2023-06-30 18:24:26',NULL),(1431,7812,413,40787,3050,2,67,2,136400.73,NULL,'2023-06-30 18:24:26','2023-06-30 18:24:26',NULL),(1432,7812,413,40787,3050,2,13,1,785928.00,NULL,'2023-06-30 18:24:26','2023-06-30 18:24:26',NULL),(1433,7812,414,40787,3049,3,217,1,3121.41,NULL,'2023-06-30 18:32:09','2023-06-30 18:32:09',NULL),(1434,7812,414,40787,3049,3,68,1,655.50,NULL,'2023-06-30 18:32:09','2023-06-30 18:32:09',NULL),(1435,7812,414,40787,3049,3,221,1,223.09,NULL,'2023-06-30 18:32:09','2023-06-30 18:32:09',NULL),(1436,7812,414,40787,3049,3,57,2,4000.00,NULL,'2023-06-30 18:32:09','2023-06-30 18:32:09',NULL),(1437,7812,415,40787,3049,3,217,1,9856.21,NULL,'2023-06-30 18:33:12','2023-06-30 18:33:12',NULL),(1438,7812,415,40787,3049,3,68,1,2069.80,NULL,'2023-06-30 18:33:12','2023-06-30 18:33:12',NULL),(1439,7812,415,40787,3049,3,221,1,1076.05,NULL,'2023-06-30 18:33:12','2023-06-30 18:33:12',NULL),(1440,7812,415,40787,3049,3,57,2,13002.06,NULL,'2023-06-30 18:33:12','2023-06-30 18:33:12',NULL),(1441,7812,416,40787,3049,3,217,1,735.26,NULL,'2023-06-30 18:34:21','2023-06-30 18:34:21',NULL),(1442,7812,416,40787,3049,3,68,1,154.40,NULL,'2023-06-30 18:34:21','2023-06-30 18:34:21',NULL),(1443,7812,416,40787,3049,3,221,1,111.54,NULL,'2023-06-30 18:34:21','2023-06-30 18:34:21',NULL),(1444,7812,416,40787,3049,3,57,2,1001.20,NULL,'2023-06-30 18:34:21','2023-06-30 18:34:21',NULL);
INSERT INTO `balance_libro_details` VALUES (1445,7812,417,40787,3049,3,217,1,723.17,NULL,'2023-06-30 18:35:57','2023-06-30 18:35:57',NULL),(1446,7812,417,40787,3049,3,68,1,151.87,NULL,'2023-06-30 18:35:57','2023-06-30 18:35:57',NULL),(1447,7812,417,40787,3049,3,221,1,133.07,NULL,'2023-06-30 18:35:57','2023-06-30 18:35:57',NULL),(1448,7812,417,40787,3049,3,57,2,1008.11,NULL,'2023-06-30 18:35:57','2023-06-30 18:35:57',NULL),(1449,7812,418,40787,3049,3,217,1,1468.75,NULL,'2023-06-30 18:36:51','2023-06-30 18:36:51',NULL),(1450,7812,418,40787,3049,3,68,1,308.44,NULL,'2023-06-30 18:36:51','2023-06-30 18:36:51',NULL),(1451,7812,418,40787,3049,3,221,1,222.81,NULL,'2023-06-30 18:36:51','2023-06-30 18:36:51',NULL),(1452,7812,418,40787,3049,3,57,2,2000.00,NULL,'2023-06-30 18:36:51','2023-06-30 18:36:51',NULL),(1453,7812,419,40787,3049,3,217,1,3671.88,NULL,'2023-06-30 18:37:42','2023-06-30 18:37:42',NULL),(1454,7812,419,40787,3049,3,68,1,771.09,NULL,'2023-06-30 18:37:42','2023-06-30 18:37:42',NULL),(1455,7812,419,40787,3049,3,221,1,557.02,NULL,'2023-06-30 18:37:42','2023-06-30 18:37:42',NULL),(1456,7812,419,40787,3049,3,57,2,4999.99,NULL,'2023-06-30 18:37:42','2023-06-30 18:37:42',NULL),(1457,7812,420,40787,3049,3,217,1,3672.63,NULL,'2023-06-30 18:38:16','2023-06-30 18:38:16',NULL),(1458,7812,420,40787,3049,3,68,1,771.25,NULL,'2023-06-30 18:38:16','2023-06-30 18:38:16',NULL),(1459,7812,420,40787,3049,3,221,1,557.13,NULL,'2023-06-30 18:38:16','2023-06-30 18:38:16',NULL),(1460,7812,420,40787,3049,3,57,2,5001.01,NULL,'2023-06-30 18:38:16','2023-06-30 18:38:16',NULL),(1461,7812,421,40787,3049,3,217,1,2859.92,NULL,'2023-06-30 18:39:36','2023-06-30 18:39:36',NULL),(1462,7812,421,40787,3049,3,68,1,600.58,NULL,'2023-06-30 18:39:36','2023-06-30 18:39:36',NULL),(1463,7812,421,40787,3049,3,57,2,3460.50,NULL,'2023-06-30 18:39:36','2023-06-30 18:39:36',NULL),(1464,7812,422,40787,3049,3,217,1,1239.67,NULL,'2023-06-30 18:40:06','2023-06-30 18:40:06',NULL),(1465,7812,422,40787,3049,3,68,1,260.33,NULL,'2023-06-30 18:40:06','2023-06-30 18:40:06',NULL),(1466,7812,422,40787,3049,3,57,2,1500.00,NULL,'2023-06-30 18:40:06','2023-06-30 18:40:06',NULL),(1467,7812,423,40787,3049,3,217,1,4576.61,NULL,'2023-06-30 18:41:25','2023-06-30 18:41:25',NULL),(1468,7812,423,40787,3049,3,68,1,961.09,NULL,'2023-06-30 18:41:25','2023-06-30 18:41:25',NULL),(1469,7812,423,40787,3049,3,57,2,5537.70,NULL,'2023-06-30 18:41:25','2023-06-30 18:41:25',NULL),(1470,7812,424,40787,3049,3,217,1,7817.40,NULL,'2023-06-30 18:42:38','2023-06-30 18:42:38',NULL),(1471,7812,424,40787,3049,3,68,1,1641.65,NULL,'2023-06-30 18:42:38','2023-06-30 18:42:38',NULL),(1472,7812,424,40787,3049,3,221,1,541.06,NULL,'2023-06-30 18:42:38','2023-06-30 18:42:38',NULL),(1473,7812,424,40787,3049,3,57,2,10000.11,NULL,'2023-06-30 18:42:38','2023-06-30 18:42:38',NULL),(1474,7812,425,40787,3050,3,217,1,663.56,NULL,'2023-06-30 18:56:37','2023-06-30 18:56:37',NULL),(1475,7812,425,40787,3050,3,68,1,139.35,NULL,'2023-06-30 18:56:37','2023-06-30 18:56:37',NULL),(1476,7812,425,40787,3050,3,57,2,802.91,NULL,'2023-06-30 18:56:37','2023-06-30 18:56:37',NULL),(1477,7812,426,40787,3050,3,217,1,6210.48,NULL,'2023-06-30 18:57:27','2023-06-30 18:57:27',NULL),(1478,7812,426,40787,3050,3,68,1,1304.20,NULL,'2023-06-30 18:57:27','2023-06-30 18:57:27',NULL),(1479,7812,426,40787,3050,3,57,2,7514.68,NULL,'2023-06-30 18:57:27','2023-06-30 18:57:27',NULL),(1480,7812,427,40787,3050,3,217,1,5506.86,NULL,'2023-06-30 18:57:55','2023-06-30 18:57:55',NULL),(1481,7812,427,40787,3050,3,68,1,1156.44,NULL,'2023-06-30 18:57:55','2023-06-30 18:57:55',NULL),(1482,7812,427,40787,3050,3,57,2,6663.30,NULL,'2023-06-30 18:57:55','2023-06-30 18:57:55',NULL),(1483,7812,428,40787,3050,3,217,1,2024.95,NULL,'2023-06-30 18:58:40','2023-06-30 18:58:40',NULL),(1484,7812,428,40787,3050,3,68,1,425.24,NULL,'2023-06-30 18:58:40','2023-06-30 18:58:40',NULL),(1485,7812,428,40787,3050,3,57,2,2450.19,NULL,'2023-06-30 18:58:40','2023-06-30 18:58:40',NULL);
INSERT INTO `balance_libro_details` VALUES (1486,7812,429,40787,3050,3,217,1,4546.42,NULL,'2023-06-30 18:59:05','2023-06-30 18:59:05',NULL),(1487,7812,429,40787,3050,3,68,1,954.75,NULL,'2023-06-30 18:59:05','2023-06-30 18:59:05',NULL),(1488,7812,429,40787,3050,3,57,2,5501.17,NULL,'2023-06-30 18:59:05','2023-06-30 18:59:05',NULL),(1489,7812,430,40787,3050,3,217,1,460.89,NULL,'2023-06-30 18:59:27','2023-06-30 18:59:27',NULL),(1490,7812,430,40787,3050,3,68,1,96.79,NULL,'2023-06-30 18:59:27','2023-06-30 18:59:27',NULL),(1491,7812,430,40787,3050,3,57,2,557.68,NULL,'2023-06-30 18:59:27','2023-06-30 18:59:27',NULL),(1492,7812,431,40787,3050,3,217,1,892.56,NULL,'2023-06-30 19:00:17','2023-06-30 19:00:17',NULL),(1493,7812,431,40787,3050,3,68,1,187.44,NULL,'2023-06-30 19:00:17','2023-06-30 19:00:17',NULL),(1494,7812,431,40787,3050,3,57,2,1080.00,NULL,'2023-06-30 19:00:17','2023-06-30 19:00:17',NULL),(1495,7812,432,40787,3050,3,217,1,21114.88,NULL,'2023-06-30 19:00:42','2023-06-30 19:00:42',NULL),(1496,7812,432,40787,3050,3,68,1,4434.12,NULL,'2023-06-30 19:00:42','2023-06-30 19:00:42',NULL),(1497,7812,432,40787,3050,3,57,2,25549.00,NULL,'2023-06-30 19:00:42','2023-06-30 19:00:42',NULL),(1498,7812,433,40787,3050,3,217,1,2598.33,NULL,'2023-06-30 19:01:05','2023-06-30 19:01:05',NULL),(1499,7812,433,40787,3050,3,68,1,545.65,NULL,'2023-06-30 19:01:05','2023-06-30 19:01:05',NULL),(1500,7812,433,40787,3050,3,57,2,3143.98,NULL,'2023-06-30 19:01:05','2023-06-30 19:01:05',NULL),(1501,7812,434,40787,3050,3,217,1,1469.20,NULL,'2023-06-30 19:01:51','2023-06-30 19:01:51',NULL),(1502,7812,434,40787,3050,3,68,1,308.53,NULL,'2023-06-30 19:01:51','2023-06-30 19:01:51',NULL),(1503,7812,434,40787,3050,3,221,1,222.88,NULL,'2023-06-30 19:01:51','2023-06-30 19:01:51',NULL),(1504,7812,434,40787,3050,3,57,2,2000.61,NULL,'2023-06-30 19:01:51','2023-06-30 19:01:51',NULL),(1505,7812,435,40787,3050,3,217,1,1468.75,NULL,'2023-06-30 19:02:48','2023-06-30 19:02:48',NULL),(1506,7812,435,40787,3050,3,68,1,308.44,NULL,'2023-06-30 19:02:48','2023-06-30 19:02:48',NULL),(1507,7812,435,40787,3050,3,221,1,222.81,NULL,'2023-06-30 19:02:48','2023-06-30 19:02:48',NULL),(1508,7812,435,40787,3050,3,57,2,2000.00,NULL,'2023-06-30 19:02:48','2023-06-30 19:02:48',NULL),(1509,7812,436,40787,3050,3,217,1,2203.14,NULL,'2023-06-30 19:03:20','2023-06-30 19:03:20',NULL),(1510,7812,436,40787,3050,3,68,1,462.66,NULL,'2023-06-30 19:03:20','2023-06-30 19:03:20',NULL),(1511,7812,436,40787,3050,3,221,1,334.21,NULL,'2023-06-30 19:03:20','2023-06-30 19:03:20',NULL),(1512,7812,436,40787,3050,3,57,2,3000.01,NULL,'2023-06-30 19:03:20','2023-06-30 19:03:20',NULL),(1513,7812,437,40787,3050,3,217,1,1472.06,NULL,'2023-06-30 19:04:01','2023-06-30 19:04:01',NULL),(1514,7812,437,40787,3050,3,68,1,309.13,NULL,'2023-06-30 19:04:01','2023-06-30 19:04:01',NULL),(1515,7812,437,40787,3050,3,221,1,223.31,NULL,'2023-06-30 19:04:01','2023-06-30 19:04:01',NULL),(1516,7812,437,40787,3050,3,57,2,2004.50,NULL,'2023-06-30 19:04:01','2023-06-30 19:04:01',NULL),(1517,7812,438,40787,3050,3,217,1,3782.26,NULL,'2023-06-30 19:04:35','2023-06-30 19:04:35',NULL),(1518,7812,438,40787,3050,3,68,1,794.27,NULL,'2023-06-30 19:04:35','2023-06-30 19:04:35',NULL),(1519,7812,438,40787,3050,3,221,1,423.48,NULL,'2023-06-30 19:04:35','2023-06-30 19:04:35',NULL),(1520,7812,438,40787,3050,3,57,2,5000.01,NULL,'2023-06-30 19:04:35','2023-06-30 19:04:35',NULL),(1521,7812,439,40787,3050,3,217,1,4407.22,NULL,'2023-06-30 19:05:21','2023-06-30 19:05:21',NULL),(1522,7812,439,40787,3050,3,68,1,925.52,NULL,'2023-06-30 19:05:21','2023-06-30 19:05:21',NULL),(1523,7812,439,40787,3050,3,221,1,668.57,NULL,'2023-06-30 19:05:21','2023-06-30 19:05:21',NULL),(1524,7812,439,40787,3050,3,57,2,6001.31,NULL,'2023-06-30 19:05:21','2023-06-30 19:05:21',NULL),(1525,7812,440,40787,3050,3,217,1,3697.92,NULL,'2023-06-30 19:05:52','2023-06-30 19:05:52',NULL),(1526,7812,440,40787,3050,3,68,1,776.56,NULL,'2023-06-30 19:05:52','2023-06-30 19:05:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1527,7812,440,40787,3050,3,221,1,525.51,NULL,'2023-06-30 19:05:52','2023-06-30 19:05:52',NULL),(1528,7812,440,40787,3050,3,57,2,4999.99,NULL,'2023-06-30 19:05:52','2023-06-30 19:05:52',NULL),(1529,7812,441,40787,3050,3,217,1,1471.12,NULL,'2023-06-30 19:06:19','2023-06-30 19:06:19',NULL),(1530,7812,441,40787,3050,3,68,1,308.94,NULL,'2023-06-30 19:06:19','2023-06-30 19:06:19',NULL),(1531,7812,441,40787,3050,3,221,1,223.16,NULL,'2023-06-30 19:06:19','2023-06-30 19:06:19',NULL),(1532,7812,441,40787,3050,3,57,2,2003.22,NULL,'2023-06-30 19:06:19','2023-06-30 19:06:19',NULL),(1533,7812,442,40787,3050,3,217,1,3920.52,NULL,'2023-06-30 19:06:50','2023-06-30 19:06:50',NULL),(1534,7812,442,40787,3050,3,68,1,823.31,NULL,'2023-06-30 19:06:50','2023-06-30 19:06:50',NULL),(1535,7812,442,40787,3050,3,221,1,256.76,NULL,'2023-06-30 19:06:50','2023-06-30 19:06:50',NULL),(1536,7812,442,40787,3050,3,57,2,5000.59,NULL,'2023-06-30 19:06:50','2023-06-30 19:06:50',NULL),(1537,7812,443,40720,1553,2,96,2,166347.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1538,7812,443,40720,1553,2,67,2,34932.87,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1539,7812,443,40720,1553,2,13,1,201279.87,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1540,7812,444,40720,1553,2,96,2,165034.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1541,7812,444,40720,1553,2,67,2,34657.14,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1542,7812,444,40720,1553,2,13,1,199691.14,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1543,7812,445,40720,1553,2,96,2,80000.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1544,7812,445,40720,1553,2,67,2,16800.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1545,7812,445,40720,1553,2,13,1,96800.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1546,7812,446,40720,1553,2,96,2,80000.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1547,7812,446,40720,1553,2,67,2,16800.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1548,7812,446,40720,1553,2,13,1,96800.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1549,7812,447,40720,1553,2,96,2,80000.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1550,7812,447,40720,1553,2,67,2,16800.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1551,7812,447,40720,1553,2,13,1,96800.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1552,7812,448,40720,1553,2,96,2,70000.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1553,7812,448,40720,1553,2,67,2,14700.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1554,7812,448,40720,1553,2,13,1,84700.00,NULL,'2023-07-20 16:27:33','2023-07-20 16:27:33',NULL),(1555,7812,449,40720,1553,3,217,1,41919.70,NULL,'2023-07-20 16:27:49','2023-07-20 16:27:49',NULL),(1556,7812,449,40720,1553,3,68,1,8803.14,NULL,'2023-07-20 16:27:49','2023-07-20 16:27:49',NULL),(1557,7812,449,40720,1553,3,57,2,50722.84,NULL,'2023-07-20 16:27:49','2023-07-20 16:27:49',NULL),(1558,7812,450,40720,1553,3,217,1,6647.80,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1559,7812,450,40720,1553,3,68,1,1396.04,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1560,7812,450,40720,1553,3,57,2,8043.84,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1561,7812,451,40720,1553,3,217,1,10742.98,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1562,7812,451,40720,1553,3,68,1,2256.02,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1563,7812,451,40720,1553,3,57,2,12999.00,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1564,7812,452,40720,1553,3,217,1,15867.77,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1565,7812,452,40720,1553,3,68,1,3332.23,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1566,7812,452,40720,1553,3,57,2,19200.00,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1567,7812,453,40720,1553,3,217,1,34710.74,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1568,7812,453,40720,1553,3,68,1,7289.26,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1569,7812,453,40720,1553,3,57,2,42000.00,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1570,7812,454,40720,1553,3,217,1,9917.36,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1571,7812,454,40720,1553,3,68,1,2082.65,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1572,7812,454,40720,1553,3,57,2,12000.01,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1573,7812,455,40720,1553,3,217,1,3000.00,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1574,7812,455,40720,1553,3,68,1,630.00,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1575,7812,455,40720,1553,3,57,2,3630.00,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1576,7812,456,40720,1553,3,217,1,49586.78,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1577,7812,456,40720,1553,3,68,1,10413.22,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1578,7812,456,40720,1553,3,57,2,60000.00,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1579,7812,457,40720,1553,3,217,1,2471.07,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1580,7812,457,40720,1553,3,68,1,518.93,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1581,7812,457,40720,1553,3,57,2,2990.00,NULL,'2023-07-20 16:27:50','2023-07-20 16:27:50',NULL),(1582,7812,458,40720,1553,3,217,1,36969.65,NULL,'2023-07-20 16:58:48','2023-07-20 16:58:48',NULL),(1583,7812,458,40720,1553,3,68,1,7763.63,NULL,'2023-07-20 16:58:48','2023-07-20 16:58:48',NULL),(1584,7812,458,40720,1553,3,221,1,3266.73,NULL,'2023-07-20 16:58:48','2023-07-20 16:58:48',NULL),(1585,7812,458,40720,1553,3,57,2,48000.01,NULL,'2023-07-20 16:58:48','2023-07-20 16:58:48',NULL),(1586,7812,459,40720,1553,3,217,1,23115.10,NULL,'2023-07-20 16:59:41','2023-07-20 16:59:41',NULL),(1587,7812,459,40720,1553,3,68,1,4854.17,NULL,'2023-07-20 16:59:41','2023-07-20 16:59:41',NULL),(1588,7812,459,40720,1553,3,221,1,2030.73,NULL,'2023-07-20 16:59:41','2023-07-20 16:59:41',NULL),(1589,7812,459,40720,1553,3,57,2,30000.00,NULL,'2023-07-20 16:59:41','2023-07-20 16:59:41',NULL),(1590,7812,460,40720,1553,3,217,1,43305.79,NULL,'2023-07-20 17:00:47','2023-07-20 17:00:47',NULL),(1591,7812,460,40720,1553,3,68,1,9094.22,NULL,'2023-07-20 17:00:47','2023-07-20 17:00:47',NULL),(1592,7812,460,40720,1553,3,57,2,52400.01,NULL,'2023-07-20 17:00:47','2023-07-20 17:00:47',NULL),(1593,7812,461,40720,1553,3,217,1,5686.76,NULL,'2023-07-20 17:08:31','2023-07-20 17:08:31',NULL),(1594,7812,461,40720,1553,3,68,1,1194.22,NULL,'2023-07-20 17:08:31','2023-07-20 17:08:31',NULL),(1595,7812,461,40720,1553,3,57,2,6880.98,NULL,'2023-07-20 17:08:31','2023-07-20 17:08:31',NULL),(1596,7812,462,40720,1553,15,67,1,134690.01,NULL,'2023-07-20 18:02:02','2023-07-20 18:02:02',NULL),(1597,7812,462,40720,1553,15,68,2,59627.72,NULL,'2023-07-20 18:02:02','2023-07-20 18:02:02',NULL),(1598,7812,462,40720,1553,15,353,2,247803.74,NULL,'2023-07-20 18:02:02','2023-07-20 18:02:02',NULL),(1599,7812,462,40720,1553,15,353,1,172741.45,NULL,'2023-07-20 18:02:02','2023-07-20 18:02:02',NULL),(1600,7812,464,40720,1554,2,96,2,166400.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1601,7812,464,40720,1554,2,67,2,34944.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1602,7812,464,40720,1554,2,13,1,201344.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1603,7812,465,40720,1554,2,96,2,165776.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1604,7812,465,40720,1554,2,67,2,34812.96,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1605,7812,465,40720,1554,2,13,1,200588.96,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1606,7812,466,40720,1554,2,96,2,165984.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1607,7812,466,40720,1554,2,67,2,34856.64,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1608,7812,466,40720,1554,2,13,1,200840.64,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL);
INSERT INTO `balance_libro_details` VALUES (1609,7812,467,40720,1554,2,96,2,150000.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1610,7812,467,40720,1554,2,67,2,31500.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1611,7812,467,40720,1554,2,13,1,181500.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1612,7812,468,40720,1554,2,96,2,60322.50,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1613,7812,468,40720,1554,2,67,2,12667.72,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1614,7812,468,40720,1554,2,13,1,72990.22,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1615,7812,469,40720,1554,2,96,2,160400.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1616,7812,469,40720,1554,2,67,2,33684.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1617,7812,469,40720,1554,2,13,1,194084.00,NULL,'2023-08-17 17:14:46','2023-08-17 17:14:46',NULL),(1618,7812,470,40720,1554,3,217,1,95867.76,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1619,7812,470,40720,1554,3,68,1,20132.23,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1620,7812,470,40720,1554,3,57,2,115999.99,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1621,7812,471,40720,1554,3,217,1,84796.38,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1622,7812,471,40720,1554,3,68,1,8903.62,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1623,7812,471,40720,1554,3,57,2,93700.00,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1624,7812,472,40720,1554,3,217,1,27685.95,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1625,7812,472,40720,1554,3,68,1,5814.05,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1626,7812,472,40720,1554,3,57,2,33500.00,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1627,7812,473,40720,1554,3,217,1,14049.58,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1628,7812,473,40720,1554,3,68,1,2950.41,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1629,7812,473,40720,1554,3,57,2,16999.99,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1630,7812,474,40720,1554,3,217,2,9090.91,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1631,7812,474,40720,1554,3,67,2,1909.09,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1632,7812,474,40720,1554,3,57,1,11000.00,NULL,'2023-08-17 17:15:58','2023-08-17 17:15:58',NULL),(1633,7812,475,40720,1554,3,217,1,6690.62,NULL,'2023-08-17 17:22:32','2023-08-17 17:22:32',NULL),(1634,7812,475,40720,1554,3,68,1,1405.03,NULL,'2023-08-17 17:22:32','2023-08-17 17:22:32',NULL),(1635,7812,475,40720,1554,3,221,1,905.37,NULL,'2023-08-17 17:22:32','2023-08-17 17:22:32',NULL),(1636,7812,475,40720,1554,3,57,2,9001.02,NULL,'2023-08-17 17:22:32','2023-08-17 17:22:32',NULL),(1637,7812,476,40720,1554,3,217,1,7125.43,NULL,'2023-08-17 17:23:56','2023-08-17 17:23:56',NULL),(1638,7812,476,40720,1554,3,68,1,1496.34,NULL,'2023-08-17 17:23:56','2023-08-17 17:23:56',NULL),(1639,7812,476,40720,1554,3,221,1,1080.92,NULL,'2023-08-17 17:23:56','2023-08-17 17:23:56',NULL),(1640,7812,476,40720,1554,3,57,2,9702.69,NULL,'2023-08-17 17:23:56','2023-08-17 17:23:56',NULL),(1641,7812,477,40720,1554,3,217,1,7715.60,NULL,'2023-08-17 17:25:09','2023-08-17 17:25:09',NULL),(1642,7812,477,40720,1554,3,68,1,1620.28,NULL,'2023-08-17 17:25:09','2023-08-17 17:25:09',NULL),(1643,7812,477,40720,1554,3,221,1,664.13,NULL,'2023-08-17 17:25:09','2023-08-17 17:25:09',NULL),(1644,7812,477,40720,1554,3,57,2,10000.01,NULL,'2023-08-17 17:25:09','2023-08-17 17:25:09',NULL),(1645,7812,478,40720,1554,3,217,1,24786.27,NULL,'2023-08-23 07:14:04','2023-08-23 07:14:04',NULL),(1646,7812,478,40720,1554,3,68,1,5205.12,NULL,'2023-08-23 07:14:04','2023-08-23 07:14:04',NULL),(1647,7812,478,40720,1554,3,221,1,2010.32,NULL,'2023-08-23 07:14:04','2023-08-23 07:14:04',NULL),(1648,7812,478,40720,1554,3,57,2,32001.71,NULL,'2023-08-23 07:14:04','2023-08-23 07:14:04',NULL),(1649,7812,479,40720,1554,3,217,1,23023.58,NULL,'2023-08-23 07:14:51','2023-08-23 07:14:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1650,7812,479,40720,1554,3,68,1,4834.95,NULL,'2023-08-23 07:14:51','2023-08-23 07:14:51',NULL),(1651,7812,479,40720,1554,3,221,1,2141.47,NULL,'2023-08-23 07:14:51','2023-08-23 07:14:51',NULL),(1652,7812,479,40720,1554,3,57,2,30000.00,NULL,'2023-08-23 07:14:51','2023-08-23 07:14:51',NULL),(1653,7812,480,40720,1554,3,217,1,10089.63,NULL,'2023-08-23 07:16:08','2023-08-23 07:16:08',NULL),(1654,7812,480,40720,1554,3,68,1,2118.82,NULL,'2023-08-23 07:16:08','2023-08-23 07:16:08',NULL),(1655,7812,480,40720,1554,3,221,1,891.54,NULL,'2023-08-23 07:16:08','2023-08-23 07:16:08',NULL),(1656,7812,480,40720,1554,3,57,2,13099.99,NULL,'2023-08-23 07:16:08','2023-08-23 07:16:08',NULL),(1657,7812,481,40720,1554,3,217,1,7520.79,NULL,'2023-08-23 07:17:29','2023-08-23 07:17:29',NULL),(1658,7812,481,40720,1554,3,68,1,1579.37,NULL,'2023-08-23 07:17:29','2023-08-23 07:17:29',NULL),(1659,7812,481,40720,1554,3,221,1,1204.15,NULL,'2023-08-23 07:17:29','2023-08-23 07:17:29',NULL),(1660,7812,481,40720,1554,3,57,2,10304.31,NULL,'2023-08-23 07:17:29','2023-08-23 07:17:29',NULL),(1661,7812,482,40720,1554,3,217,1,3651.10,NULL,'2023-08-23 07:18:08','2023-08-23 07:18:08',NULL),(1662,7812,482,40720,1554,3,68,1,766.73,NULL,'2023-08-23 07:18:08','2023-08-23 07:18:08',NULL),(1663,7812,482,40720,1554,3,221,1,584.58,NULL,'2023-08-23 07:18:08','2023-08-23 07:18:08',NULL),(1664,7812,482,40720,1554,3,57,2,5002.41,NULL,'2023-08-23 07:18:08','2023-08-23 07:18:08',NULL),(1665,7812,483,40720,1554,3,217,1,3649.34,NULL,'2023-08-23 07:18:53','2023-08-23 07:18:53',NULL),(1666,7812,483,40720,1554,3,68,1,766.36,NULL,'2023-08-23 07:18:53','2023-08-23 07:18:53',NULL),(1667,7812,483,40720,1554,3,221,1,584.29,NULL,'2023-08-23 07:18:53','2023-08-23 07:18:53',NULL),(1668,7812,483,40720,1554,3,57,2,4999.99,NULL,'2023-08-23 07:18:53','2023-08-23 07:18:53',NULL),(1669,7812,484,40720,1554,3,217,1,11558.81,NULL,'2023-08-23 07:19:35','2023-08-23 07:19:35',NULL),(1670,7812,484,40720,1554,3,68,1,2427.35,NULL,'2023-08-23 07:19:35','2023-08-23 07:19:35',NULL),(1671,7812,484,40720,1554,3,221,1,1021.36,NULL,'2023-08-23 07:19:35','2023-08-23 07:19:35',NULL),(1672,7812,484,40720,1554,3,57,2,15007.52,NULL,'2023-08-23 07:19:35','2023-08-23 07:19:35',NULL),(1673,7812,485,40720,1554,3,217,1,8886.11,NULL,'2023-08-23 07:20:11','2023-08-23 07:20:11',NULL),(1674,7812,485,40720,1554,3,68,1,1866.08,NULL,'2023-08-23 07:20:11','2023-08-23 07:20:11',NULL),(1675,7812,485,40720,1554,3,221,1,1348.00,NULL,'2023-08-23 07:20:11','2023-08-23 07:20:11',NULL),(1676,7812,485,40720,1554,3,57,2,12100.19,NULL,'2023-08-23 07:20:11','2023-08-23 07:20:11',NULL),(1677,7812,486,40720,1554,3,217,1,3853.23,NULL,'2023-08-23 07:20:45','2023-08-23 07:20:45',NULL),(1678,7812,486,40720,1554,3,68,1,809.18,NULL,'2023-08-23 07:20:45','2023-08-23 07:20:45',NULL),(1679,7812,486,40720,1554,3,221,1,340.48,NULL,'2023-08-23 07:20:45','2023-08-23 07:20:45',NULL),(1680,7812,486,40720,1554,3,57,2,5002.89,NULL,'2023-08-23 07:20:45','2023-08-23 07:20:45',NULL),(1681,7812,487,40720,1554,3,217,1,2310.60,NULL,'2023-08-23 07:21:11','2023-08-23 07:21:11',NULL),(1682,7812,487,40720,1554,3,68,1,485.23,NULL,'2023-08-23 07:21:11','2023-08-23 07:21:11',NULL),(1683,7812,487,40720,1554,3,221,1,204.17,NULL,'2023-08-23 07:21:11','2023-08-23 07:21:11',NULL),(1684,7812,487,40720,1554,3,57,2,3000.00,NULL,'2023-08-23 07:21:11','2023-08-23 07:21:11',NULL),(1685,7812,488,40720,1554,3,217,1,16177.37,NULL,'2023-08-23 07:21:47','2023-08-23 07:21:47',NULL),(1686,7812,488,40720,1554,3,68,1,3397.25,NULL,'2023-08-23 07:21:47','2023-08-23 07:21:47',NULL),(1687,7812,488,40720,1554,3,221,1,1429.47,NULL,'2023-08-23 07:21:47','2023-08-23 07:21:47',NULL),(1688,7812,488,40720,1554,3,57,2,21004.09,NULL,'2023-08-23 07:21:47','2023-08-23 07:21:47',NULL),(1689,7812,489,40720,1554,3,217,1,15294.26,NULL,'2023-08-23 07:22:40','2023-08-23 07:22:40',NULL),(1690,7812,489,40720,1554,3,68,1,3211.79,NULL,'2023-08-23 07:22:40','2023-08-23 07:22:40',NULL);
INSERT INTO `balance_libro_details` VALUES (1691,7812,489,40720,1554,3,221,1,1503.03,NULL,'2023-08-23 07:22:40','2023-08-23 07:22:40',NULL),(1692,7812,489,40720,1554,3,57,2,20009.08,NULL,'2023-08-23 07:22:40','2023-08-23 07:22:40',NULL),(1693,7812,490,40720,1554,3,217,1,15287.31,NULL,'2023-08-23 07:23:16','2023-08-23 07:23:16',NULL),(1694,7812,490,40720,1554,3,68,1,3210.34,NULL,'2023-08-23 07:23:16','2023-08-23 07:23:16',NULL),(1695,7812,490,40720,1554,3,221,1,1502.35,NULL,'2023-08-23 07:23:16','2023-08-23 07:23:16',NULL),(1696,7812,490,40720,1554,3,57,2,20000.00,NULL,'2023-08-23 07:23:16','2023-08-23 07:23:16',NULL),(1697,7812,491,40720,1554,3,217,1,15493.21,NULL,'2023-08-23 07:23:49','2023-08-23 07:23:49',NULL),(1698,7812,491,40720,1554,3,68,1,3253.57,NULL,'2023-08-23 07:23:49','2023-08-23 07:23:49',NULL),(1699,7812,491,40720,1554,3,221,1,1369.02,NULL,'2023-08-23 07:23:49','2023-08-23 07:23:49',NULL),(1700,7812,491,40720,1554,3,57,2,20115.80,NULL,'2023-08-23 07:23:49','2023-08-23 07:23:49',NULL),(1701,7812,492,40720,1554,3,217,1,15654.78,NULL,'2023-08-23 07:25:03','2023-08-23 07:25:03',NULL),(1702,7812,492,40720,1554,3,68,1,3287.50,NULL,'2023-08-23 07:25:03','2023-08-23 07:25:03',NULL),(1703,7812,492,40720,1554,3,221,1,1057.73,NULL,'2023-08-23 07:25:03','2023-08-23 07:25:03',NULL),(1704,7812,492,40720,1554,3,57,2,20000.01,NULL,'2023-08-23 07:25:03','2023-08-23 07:25:03',NULL),(1705,7812,493,40720,1554,3,217,1,16175.30,NULL,'2023-08-23 07:25:40','2023-08-23 07:25:40',NULL),(1706,7812,493,40720,1554,3,68,1,3396.81,NULL,'2023-08-23 07:25:40','2023-08-23 07:25:40',NULL),(1707,7812,493,40720,1554,3,221,1,1429.29,NULL,'2023-08-23 07:25:40','2023-08-23 07:25:40',NULL),(1708,7812,493,40720,1554,3,57,2,21001.40,NULL,'2023-08-23 07:25:40','2023-08-23 07:25:40',NULL),(1709,7812,494,40720,1554,3,217,1,16947.04,NULL,'2023-08-23 07:26:14','2023-08-23 07:26:14',NULL),(1710,7812,494,40720,1554,3,68,1,3558.88,NULL,'2023-08-23 07:26:14','2023-08-23 07:26:14',NULL),(1711,7812,494,40720,1554,3,221,1,1497.48,NULL,'2023-08-23 07:26:14','2023-08-23 07:26:14',NULL),(1712,7812,494,40720,1554,3,57,2,22003.40,NULL,'2023-08-23 07:26:14','2023-08-23 07:26:14',NULL),(1713,7812,495,40720,1554,3,217,1,19568.46,NULL,'2023-08-23 07:26:53','2023-08-23 07:26:53',NULL),(1714,7812,495,40720,1554,3,68,1,4109.38,NULL,'2023-08-23 07:26:53','2023-08-23 07:26:53',NULL),(1715,7812,495,40720,1554,3,221,1,1322.16,NULL,'2023-08-23 07:26:53','2023-08-23 07:26:53',NULL),(1716,7812,495,40720,1554,3,57,2,25000.00,NULL,'2023-08-23 07:26:53','2023-08-23 07:26:53',NULL),(1717,7812,496,40720,1554,3,217,1,6013.66,NULL,'2023-08-23 07:27:37','2023-08-23 07:27:37',NULL),(1718,7812,496,40720,1554,3,68,1,1262.87,NULL,'2023-08-23 07:27:37','2023-08-23 07:27:37',NULL),(1719,7812,496,40720,1554,3,221,1,531.38,NULL,'2023-08-23 07:27:37','2023-08-23 07:27:37',NULL),(1720,7812,496,40720,1554,3,57,2,7807.91,NULL,'2023-08-23 07:27:37','2023-08-23 07:27:37',NULL),(1721,7812,497,40720,1554,3,217,1,21603.13,NULL,'2023-08-23 07:28:11','2023-08-23 07:28:11',NULL),(1722,7812,497,40720,1554,3,68,1,4536.66,NULL,'2023-08-23 07:28:11','2023-08-23 07:28:11',NULL),(1723,7812,497,40720,1554,3,221,1,1897.91,NULL,'2023-08-23 07:28:11','2023-08-23 07:28:11',NULL),(1724,7812,497,40720,1554,3,57,2,28037.70,NULL,'2023-08-23 07:28:11','2023-08-23 07:28:11',NULL),(1725,7812,498,40720,1554,3,217,1,23984.19,NULL,'2023-08-23 07:28:54','2023-08-23 07:28:54',NULL),(1726,7812,498,40720,1554,3,68,1,5036.68,NULL,'2023-08-23 07:28:54','2023-08-23 07:28:54',NULL),(1727,7812,498,40720,1554,3,221,1,1979.53,NULL,'2023-08-23 07:28:54','2023-08-23 07:28:54',NULL),(1728,7812,498,40720,1554,3,57,2,31000.40,NULL,'2023-08-23 07:28:54','2023-08-23 07:28:54',NULL),(1729,7812,499,40720,1554,3,217,1,18035.65,NULL,'2023-08-23 07:29:53','2023-08-23 07:29:53',NULL),(1730,7812,499,40720,1554,3,68,1,3787.49,NULL,'2023-08-23 07:29:53','2023-08-23 07:29:53',NULL),(1731,7812,499,40720,1554,3,221,1,1181.17,NULL,'2023-08-23 07:29:53','2023-08-23 07:29:53',NULL);
INSERT INTO `balance_libro_details` VALUES (1732,7812,499,40720,1554,3,57,2,23004.31,NULL,'2023-08-23 07:29:53','2023-08-23 07:29:53',NULL),(1733,7812,500,40720,1554,3,217,1,37139.03,NULL,'2023-08-23 07:30:24','2023-08-23 07:30:24',NULL),(1734,7812,500,40720,1554,3,68,1,7799.20,NULL,'2023-08-23 07:30:24','2023-08-23 07:30:24',NULL),(1735,7812,500,40720,1554,3,221,1,3065.27,NULL,'2023-08-23 07:30:24','2023-08-23 07:30:24',NULL),(1736,7812,500,40720,1554,3,57,2,48003.50,NULL,'2023-08-23 07:30:24','2023-08-23 07:30:24',NULL),(1737,7812,501,40720,1554,3,217,1,17022.20,NULL,'2023-08-23 07:30:55','2023-08-23 07:30:55',NULL),(1738,7812,501,40720,1554,3,68,1,3574.66,NULL,'2023-08-23 07:30:55','2023-08-23 07:30:55',NULL),(1739,7812,501,40720,1554,3,221,1,1404.93,NULL,'2023-08-23 07:30:55','2023-08-23 07:30:55',NULL),(1740,7812,501,40720,1554,3,57,2,22001.79,NULL,'2023-08-23 07:30:55','2023-08-23 07:30:55',NULL),(1741,7812,502,40720,1554,3,217,1,13949.83,NULL,'2023-08-23 07:31:22','2023-08-23 07:31:22',NULL),(1742,7812,502,40720,1554,3,68,1,2929.46,NULL,'2023-08-23 07:31:22','2023-08-23 07:31:22',NULL),(1743,7812,502,40720,1554,3,221,1,1131.42,NULL,'2023-08-23 07:31:22','2023-08-23 07:31:22',NULL),(1744,7812,502,40720,1554,3,57,2,18010.71,NULL,'2023-08-23 07:31:22','2023-08-23 07:31:22',NULL),(1745,7812,503,40720,1554,3,217,1,11618.17,NULL,'2023-08-23 07:31:56','2023-08-23 07:31:56',NULL),(1746,7812,503,40720,1554,3,68,1,2439.82,NULL,'2023-08-23 07:31:56','2023-08-23 07:31:56',NULL),(1747,7812,503,40720,1554,3,221,1,942.31,NULL,'2023-08-23 07:31:56','2023-08-23 07:31:56',NULL),(1748,7812,503,40720,1554,3,57,2,15000.30,NULL,'2023-08-23 07:31:56','2023-08-23 07:31:56',NULL),(1749,7812,504,40720,1554,3,217,1,24785.65,NULL,'2023-08-23 07:33:01','2023-08-23 07:33:01',NULL),(1750,7812,504,40720,1554,3,68,1,5204.99,NULL,'2023-08-23 07:33:01','2023-08-23 07:33:01',NULL),(1751,7812,504,40720,1554,3,221,1,2010.27,NULL,'2023-08-23 07:33:01','2023-08-23 07:33:01',NULL),(1752,7812,504,40720,1554,3,57,2,32000.91,NULL,'2023-08-23 07:33:01','2023-08-23 07:33:01',NULL),(1753,7812,505,40720,1554,3,217,1,7398.22,NULL,'2023-08-23 07:33:31','2023-08-23 07:33:31',NULL),(1754,7812,505,40720,1554,3,68,1,1553.63,NULL,'2023-08-23 07:33:31','2023-08-23 07:33:31',NULL),(1755,7812,505,40720,1554,3,221,1,649.96,NULL,'2023-08-23 07:33:31','2023-08-23 07:33:31',NULL),(1756,7812,505,40720,1554,3,57,2,9601.81,NULL,'2023-08-23 07:33:31','2023-08-23 07:33:31',NULL),(1757,7812,506,40720,1554,3,217,1,8397.42,NULL,'2023-08-23 07:35:10','2023-08-23 07:35:10',NULL),(1758,7812,506,40720,1554,3,68,1,1763.46,NULL,'2023-08-23 07:35:10','2023-08-23 07:35:10',NULL),(1759,7812,506,40720,1554,3,221,1,742.02,NULL,'2023-08-23 07:35:10','2023-08-23 07:35:10',NULL),(1760,7812,506,40720,1554,3,57,2,10902.90,NULL,'2023-08-23 07:35:10','2023-08-23 07:35:10',NULL),(1761,7812,507,40720,1554,3,217,1,6165.72,NULL,'2023-08-23 07:35:44','2023-08-23 07:35:44',NULL),(1762,7812,507,40720,1554,3,68,1,1294.80,NULL,'2023-08-23 07:35:44','2023-08-23 07:35:44',NULL),(1763,7812,507,40720,1554,3,221,1,541.68,NULL,'2023-08-23 07:35:44','2023-08-23 07:35:44',NULL),(1764,7812,507,40720,1554,3,57,2,8002.20,NULL,'2023-08-23 07:35:44','2023-08-23 07:35:44',NULL),(1765,7812,508,40720,1554,3,217,1,5247.28,NULL,'2023-08-23 07:36:19','2023-08-23 07:36:19',NULL),(1766,7812,508,40720,1554,3,68,1,1101.93,NULL,'2023-08-23 07:36:19','2023-08-23 07:36:19',NULL),(1767,7812,508,40720,1554,3,221,1,460.99,NULL,'2023-08-23 07:36:19','2023-08-23 07:36:19',NULL),(1768,7812,508,40720,1554,3,57,2,6810.20,NULL,'2023-08-23 07:36:19','2023-08-23 07:36:19',NULL),(1769,7812,509,40720,1554,3,217,1,14525.24,NULL,'2023-08-23 07:36:56','2023-08-23 07:36:56',NULL),(1770,7812,509,40720,1554,3,68,1,3050.30,NULL,'2023-08-23 07:36:56','2023-08-23 07:36:56',NULL),(1771,7812,509,40720,1554,3,221,1,1427.45,NULL,'2023-08-23 07:36:56','2023-08-23 07:36:56',NULL),(1772,7812,509,40720,1554,3,57,2,19002.99,NULL,'2023-08-23 07:36:56','2023-08-23 07:36:56',NULL);
INSERT INTO `balance_libro_details` VALUES (1773,7812,510,40720,1554,3,217,1,14987.00,NULL,'2023-08-23 07:37:29','2023-08-23 07:37:29',NULL),(1774,7812,510,40720,1554,3,68,1,3147.27,NULL,'2023-08-23 07:37:29','2023-08-23 07:37:29',NULL),(1775,7812,510,40720,1554,3,221,1,1472.83,NULL,'2023-08-23 07:37:29','2023-08-23 07:37:29',NULL),(1776,7812,510,40720,1554,3,57,2,19607.10,NULL,'2023-08-23 07:37:29','2023-08-23 07:37:29',NULL),(1777,7812,511,40720,1554,3,217,1,4439.32,NULL,'2023-08-23 07:38:09','2023-08-23 07:38:09',NULL),(1778,7812,511,40720,1554,3,68,1,932.26,NULL,'2023-08-23 07:38:09','2023-08-23 07:38:09',NULL),(1779,7812,511,40720,1554,3,221,1,216.63,NULL,'2023-08-23 07:38:09','2023-08-23 07:38:09',NULL),(1780,7812,511,40720,1554,3,57,2,5588.21,NULL,'2023-08-23 07:38:09','2023-08-23 07:38:09',NULL),(1781,7812,512,40720,1554,3,217,1,6472.55,NULL,'2023-08-23 07:39:29','2023-08-23 07:39:29',NULL),(1782,7812,512,40720,1554,3,68,1,1359.24,NULL,'2023-08-23 07:39:29','2023-08-23 07:39:29',NULL),(1783,7812,512,40720,1554,3,221,1,571.93,NULL,'2023-08-23 07:39:29','2023-08-23 07:39:29',NULL),(1784,7812,512,40720,1554,3,57,2,8403.72,NULL,'2023-08-23 07:39:29','2023-08-23 07:39:29',NULL),(1785,7812,513,40720,1554,3,217,1,11619.80,NULL,'2023-08-23 07:39:58','2023-08-23 07:39:58',NULL),(1786,7812,513,40720,1554,3,68,1,2440.16,NULL,'2023-08-23 07:39:58','2023-08-23 07:39:58',NULL),(1787,7812,513,40720,1554,3,221,1,959.04,NULL,'2023-08-23 07:39:58','2023-08-23 07:39:58',NULL),(1788,7812,513,40720,1554,3,57,2,15019.00,NULL,'2023-08-23 07:39:58','2023-08-23 07:39:58',NULL),(1789,7812,514,40720,1554,3,217,1,23195.72,NULL,'2023-08-23 07:40:32','2023-08-23 07:40:32',NULL),(1790,7812,514,40720,1554,3,68,1,4871.10,NULL,'2023-08-23 07:40:32','2023-08-23 07:40:32',NULL),(1791,7812,514,40720,1554,3,221,1,2236.18,NULL,'2023-08-23 07:40:32','2023-08-23 07:40:32',NULL),(1792,7812,514,40720,1554,3,57,2,30303.00,NULL,'2023-08-23 07:40:32','2023-08-23 07:40:32',NULL),(1793,7812,515,40720,1554,3,217,1,23064.22,NULL,'2023-08-23 07:41:02','2023-08-23 07:41:02',NULL),(1794,7812,515,40720,1554,3,68,1,4843.49,NULL,'2023-08-23 07:41:02','2023-08-23 07:41:02',NULL),(1795,7812,515,40720,1554,3,221,1,1903.60,NULL,'2023-08-23 07:41:02','2023-08-23 07:41:02',NULL),(1796,7812,515,40720,1554,3,57,2,29811.31,NULL,'2023-08-23 07:41:02','2023-08-23 07:41:02',NULL),(1797,7812,516,40720,1554,3,217,1,3655.33,NULL,'2023-08-23 07:41:34','2023-08-23 07:41:34',NULL),(1798,7812,516,40720,1554,3,68,1,767.62,NULL,'2023-08-23 07:41:34','2023-08-23 07:41:34',NULL),(1799,7812,516,40720,1554,3,221,1,585.25,NULL,'2023-08-23 07:41:34','2023-08-23 07:41:34',NULL),(1800,7812,516,40720,1554,3,57,2,5008.20,NULL,'2023-08-23 07:41:34','2023-08-23 07:41:34',NULL),(1801,7812,517,40720,1554,3,217,1,2203.94,NULL,'2023-08-23 07:43:40','2023-08-23 07:43:40',NULL),(1802,7812,517,40720,1554,3,68,1,462.83,NULL,'2023-08-23 07:43:40','2023-08-23 07:43:40',NULL),(1803,7812,517,40720,1554,3,221,1,334.33,NULL,'2023-08-23 07:43:40','2023-08-23 07:43:40',NULL),(1804,7812,517,40720,1554,3,57,2,3001.10,NULL,'2023-08-23 07:43:40','2023-08-23 07:43:40',NULL),(1805,7812,518,40720,1554,3,217,1,61893.89,NULL,'2023-08-23 07:44:25','2023-08-23 07:44:25',NULL),(1806,7812,518,40720,1554,3,68,1,12997.72,NULL,'2023-08-23 07:44:25','2023-08-23 07:44:25',NULL),(1807,7812,518,40720,1554,3,221,1,5108.40,NULL,'2023-08-23 07:44:25','2023-08-23 07:44:25',NULL),(1808,7812,518,40720,1554,3,57,2,80000.01,NULL,'2023-08-23 07:44:25','2023-08-23 07:44:25',NULL),(1809,7812,519,40720,1554,3,217,1,61893.89,NULL,'2023-08-23 07:45:20','2023-08-23 07:45:20',NULL),(1810,7812,519,40720,1554,3,68,1,12997.72,NULL,'2023-08-23 07:45:20','2023-08-23 07:45:20',NULL),(1811,7812,519,40720,1554,3,221,1,5108.40,NULL,'2023-08-23 07:45:20','2023-08-23 07:45:20',NULL),(1812,7812,519,40720,1554,3,57,2,80000.01,NULL,'2023-08-23 07:45:20','2023-08-23 07:45:20',NULL),(1813,7812,520,40720,1554,3,217,1,7538.51,NULL,'2023-08-23 07:46:48','2023-08-23 07:46:48',NULL);
INSERT INTO `balance_libro_details` VALUES (1814,7812,520,40720,1554,3,68,1,1583.09,NULL,'2023-08-23 07:46:48','2023-08-23 07:46:48',NULL),(1815,7812,520,40720,1554,3,57,2,9121.60,NULL,'2023-08-23 07:46:48','2023-08-23 07:46:48',NULL),(1816,7812,521,40720,1554,3,217,1,54837.21,NULL,'2023-08-23 07:47:38','2023-08-23 07:47:38',NULL),(1817,7812,521,40720,1554,3,68,1,11515.81,NULL,'2023-08-23 07:47:38','2023-08-23 07:47:38',NULL),(1818,7812,521,40720,1554,3,221,1,4525.98,NULL,'2023-08-23 07:47:38','2023-08-23 07:47:38',NULL),(1819,7812,521,40720,1554,3,57,2,70879.00,NULL,'2023-08-23 07:47:38','2023-08-23 07:47:38',NULL),(1820,7812,522,40720,1554,3,217,1,4093.73,NULL,'2023-08-23 07:51:08','2023-08-23 07:51:08',NULL),(1821,7812,522,40720,1554,3,68,1,859.68,NULL,'2023-08-23 07:51:08','2023-08-23 07:51:08',NULL),(1822,7812,522,40720,1554,3,221,1,346.59,NULL,'2023-08-23 07:51:08','2023-08-23 07:51:08',NULL),(1823,7812,522,40720,1554,3,57,2,5300.00,NULL,'2023-08-23 07:51:08','2023-08-23 07:51:08',NULL),(1824,7812,523,40720,1554,3,217,1,2644.63,NULL,'2023-08-23 07:52:47','2023-08-23 07:52:47',NULL),(1825,7812,523,40720,1554,3,68,1,555.37,NULL,'2023-08-23 07:52:47','2023-08-23 07:52:47',NULL),(1826,7812,523,40720,1554,3,57,2,3200.00,NULL,'2023-08-23 07:52:47','2023-08-23 07:52:47',NULL),(1827,7812,524,40720,1554,3,217,1,6158.68,NULL,'2023-08-23 07:53:10','2023-08-23 07:53:10',NULL),(1828,7812,524,40720,1554,3,68,1,1293.32,NULL,'2023-08-23 07:53:10','2023-08-23 07:53:10',NULL),(1829,7812,524,40720,1554,3,57,2,7452.00,NULL,'2023-08-23 07:53:10','2023-08-23 07:53:10',NULL),(1830,7812,525,40720,1554,3,217,1,61648.94,NULL,'2023-08-23 07:56:04','2023-08-23 07:56:04',NULL),(1831,7812,525,40720,1554,3,68,1,12946.28,NULL,'2023-08-23 07:56:04','2023-08-23 07:56:04',NULL),(1832,7812,525,40720,1554,3,221,1,5416.05,NULL,'2023-08-23 07:56:04','2023-08-23 07:56:04',NULL),(1833,7812,525,40720,1554,3,57,2,80011.27,NULL,'2023-08-23 07:56:04','2023-08-23 07:56:04',NULL),(1834,7812,526,40720,1554,3,217,1,77050.76,NULL,'2023-08-23 07:56:50','2023-08-23 07:56:50',NULL),(1835,7812,526,40720,1554,3,68,1,16180.66,NULL,'2023-08-23 07:56:50','2023-08-23 07:56:50',NULL),(1836,7812,526,40720,1554,3,221,1,6769.14,NULL,'2023-08-23 07:56:50','2023-08-23 07:56:50',NULL),(1837,7812,526,40720,1554,3,57,2,100000.56,NULL,'2023-08-23 07:56:50','2023-08-23 07:56:50',NULL),(1838,7812,527,40720,1554,3,217,1,46514.55,NULL,'2023-08-23 07:58:16','2023-08-23 07:58:16',NULL),(1839,7812,527,40720,1554,3,68,1,9768.06,NULL,'2023-08-23 07:58:16','2023-08-23 07:58:16',NULL),(1840,7812,527,40720,1554,3,221,1,3716.61,NULL,'2023-08-23 07:58:16','2023-08-23 07:58:16',NULL),(1841,7812,527,40720,1554,3,57,2,59999.22,NULL,'2023-08-23 07:58:16','2023-08-23 07:58:16',NULL),(1842,7812,528,40720,1554,3,217,1,23210.21,NULL,'2023-08-23 07:59:04','2023-08-23 07:59:04',NULL),(1843,7812,528,40720,1554,3,68,1,4874.14,NULL,'2023-08-23 07:59:04','2023-08-23 07:59:04',NULL),(1844,7812,528,40720,1554,3,221,1,1915.65,NULL,'2023-08-23 07:59:04','2023-08-23 07:59:04',NULL),(1845,7812,528,40720,1554,3,57,2,30000.00,NULL,'2023-08-23 07:59:04','2023-08-23 07:59:04',NULL),(1846,7812,529,40720,1554,3,217,1,5789.51,NULL,'2023-08-23 08:00:09','2023-08-23 08:00:09',NULL),(1847,7812,529,40720,1554,3,68,1,1215.80,NULL,'2023-08-23 08:00:09','2023-08-23 08:00:09',NULL),(1848,7812,529,40720,1554,3,221,1,395.14,NULL,'2023-08-23 08:00:09','2023-08-23 08:00:09',NULL),(1849,7812,529,40720,1554,3,57,2,7400.45,NULL,'2023-08-23 08:00:09','2023-08-23 08:00:09',NULL),(1850,7812,530,40720,1554,15,67,1,184374.42,NULL,'2023-08-23 17:33:57','2023-08-23 17:33:57',NULL),(1851,7812,530,40720,1554,15,68,2,241554.20,NULL,'2023-08-23 17:33:57','2023-08-23 17:33:57',NULL),(1852,7812,530,40720,1554,15,353,2,172741.45,NULL,'2023-08-23 17:33:57','2023-08-23 17:33:57',NULL),(1853,7812,530,40720,1554,15,353,1,229921.23,NULL,'2023-08-23 17:33:57','2023-08-23 17:33:57',NULL),(1854,7812,531,40720,1555,3,217,1,67470.88,NULL,'2023-09-17 10:09:42','2023-09-17 10:09:42',NULL);
INSERT INTO `balance_libro_details` VALUES (1855,7812,531,40720,1555,3,68,1,14168.88,NULL,'2023-09-17 10:09:42','2023-09-17 10:09:42',NULL),(1856,7812,531,40720,1555,3,221,1,4860.23,NULL,'2023-09-17 10:09:42','2023-09-17 10:09:42',NULL),(1857,7812,531,40720,1555,3,57,2,86499.99,NULL,'2023-09-17 10:09:42','2023-09-17 10:09:42',NULL),(1858,7812,532,40720,1555,3,217,1,23406.15,NULL,'2023-09-17 10:10:28','2023-09-17 10:10:28',NULL),(1859,7812,532,40720,1555,3,68,1,4915.29,NULL,'2023-09-17 10:10:28','2023-09-17 10:10:28',NULL),(1860,7812,532,40720,1555,3,221,1,1686.05,NULL,'2023-09-17 10:10:28','2023-09-17 10:10:28',NULL),(1861,7812,532,40720,1555,3,57,2,30007.49,NULL,'2023-09-17 10:10:28','2023-09-17 10:10:28',NULL),(1862,7812,533,40720,1555,3,217,1,33776.79,NULL,'2023-09-17 10:11:09','2023-09-17 10:11:09',NULL),(1863,7812,533,40720,1555,3,68,1,7093.13,NULL,'2023-09-17 10:11:09','2023-09-17 10:11:09',NULL),(1864,7812,533,40720,1555,3,221,1,2433.09,NULL,'2023-09-17 10:11:09','2023-09-17 10:11:09',NULL),(1865,7812,533,40720,1555,3,57,2,43303.01,NULL,'2023-09-17 10:11:09','2023-09-17 10:11:09',NULL),(1866,7812,534,40720,1555,3,217,1,33748.35,NULL,'2023-09-17 10:11:58','2023-09-17 10:11:58',NULL),(1867,7812,534,40720,1555,3,68,1,7087.15,NULL,'2023-09-17 10:11:58','2023-09-17 10:11:58',NULL),(1868,7812,534,40720,1555,3,221,1,2167.89,NULL,'2023-09-17 10:11:58','2023-09-17 10:11:58',NULL),(1869,7812,534,40720,1555,3,57,2,43003.39,NULL,'2023-09-17 10:11:58','2023-09-17 10:11:58',NULL),(1870,7812,535,40720,1555,3,217,1,23278.92,NULL,'2023-09-17 10:13:18','2023-09-17 10:15:27','2023-09-17 10:15:27'),(1871,7812,535,40720,1555,3,68,1,4888.57,NULL,'2023-09-17 10:13:18','2023-09-17 10:15:27','2023-09-17 10:15:27'),(1872,7812,535,40720,1555,3,221,1,1833.01,NULL,'2023-09-17 10:13:19','2023-09-17 10:15:27','2023-09-17 10:15:27'),(1873,7812,535,40720,1555,3,57,2,30000.50,NULL,'2023-09-17 10:13:19','2023-09-17 10:15:27','2023-09-17 10:15:27'),(1874,7812,536,40720,1555,3,217,1,7760.60,NULL,'2023-09-17 10:13:54','2023-09-17 10:15:43','2023-09-17 10:15:43'),(1875,7812,536,40720,1555,3,68,1,1629.73,NULL,'2023-09-17 10:13:54','2023-09-17 10:15:43','2023-09-17 10:15:43'),(1876,7812,536,40720,1555,3,221,1,611.08,NULL,'2023-09-17 10:13:54','2023-09-17 10:15:43','2023-09-17 10:15:43'),(1877,7812,536,40720,1555,3,57,2,10001.41,NULL,'2023-09-17 10:13:54','2023-09-17 10:15:43','2023-09-17 10:15:43'),(1878,7812,537,40720,1555,3,217,1,23279.79,NULL,'2023-09-17 10:14:40','2023-09-17 10:14:40',NULL),(1879,7812,537,40720,1555,3,68,1,4888.76,NULL,'2023-09-17 10:14:40','2023-09-17 10:14:40',NULL),(1880,7812,537,40720,1555,3,221,1,1833.07,NULL,'2023-09-17 10:14:40','2023-09-17 10:14:40',NULL),(1881,7812,537,40720,1555,3,57,2,30001.62,NULL,'2023-09-17 10:14:40','2023-09-17 10:14:40',NULL),(1882,7812,538,40720,1555,3,217,1,23278.92,NULL,'2023-09-17 10:15:27','2023-09-17 10:15:27',NULL),(1883,7812,538,40720,1555,3,68,1,4888.57,NULL,'2023-09-17 10:15:27','2023-09-17 10:15:27',NULL),(1884,7812,538,40720,1555,3,221,1,1833.01,NULL,'2023-09-17 10:15:27','2023-09-17 10:15:27',NULL),(1885,7812,538,40720,1555,3,57,2,30000.50,NULL,'2023-09-17 10:15:27','2023-09-17 10:15:27',NULL),(1886,7812,539,40720,1555,3,217,1,7760.60,NULL,'2023-09-17 10:15:43','2023-09-17 10:15:43',NULL),(1887,7812,539,40720,1555,3,68,1,1629.73,NULL,'2023-09-17 10:15:43','2023-09-17 10:15:43',NULL),(1888,7812,539,40720,1555,3,221,1,611.08,NULL,'2023-09-17 10:15:43','2023-09-17 10:15:43',NULL),(1889,7812,539,40720,1555,3,57,2,10001.41,NULL,'2023-09-17 10:15:43','2023-09-17 10:15:43',NULL),(1890,7812,540,40720,1555,3,217,1,23159.33,NULL,'2023-09-17 10:18:10','2023-09-17 10:18:10',NULL),(1891,7812,540,40720,1555,3,68,1,4863.46,NULL,'2023-09-17 10:18:10','2023-09-17 10:18:10',NULL),(1892,7812,540,40720,1555,3,221,1,1890.80,NULL,'2023-09-17 10:18:10','2023-09-17 10:18:10',NULL),(1893,7812,540,40720,1555,3,57,2,29913.59,NULL,'2023-09-17 10:18:10','2023-09-17 10:18:10',NULL);
INSERT INTO `balance_libro_details` VALUES (1894,7812,541,40720,1555,3,217,1,23344.22,NULL,'2023-09-17 10:21:25','2023-09-17 10:21:25',NULL),(1895,7812,541,40720,1555,3,68,1,4902.29,NULL,'2023-09-17 10:21:25','2023-09-17 10:21:25',NULL),(1896,7812,541,40720,1555,3,221,1,1754.08,NULL,'2023-09-17 10:21:25','2023-09-17 10:21:25',NULL),(1897,7812,541,40720,1555,3,57,2,30000.59,NULL,'2023-09-17 10:21:25','2023-09-17 10:21:25',NULL),(1898,7812,542,40720,1555,3,217,1,2544.54,NULL,'2023-09-17 10:22:09','2023-09-17 10:22:09',NULL),(1899,7812,542,40720,1555,3,68,1,534.35,NULL,'2023-09-17 10:22:09','2023-09-17 10:22:09',NULL),(1900,7812,542,40720,1555,3,221,1,327.90,NULL,'2023-09-17 10:22:09','2023-09-17 10:22:09',NULL),(1901,7812,542,40720,1555,3,57,2,3406.79,NULL,'2023-09-17 10:22:09','2023-09-17 10:22:09',NULL),(1902,7812,543,40720,1555,3,217,1,3734.51,NULL,'2023-09-17 10:23:20','2023-09-17 10:23:20',NULL),(1903,7812,543,40720,1555,3,68,1,784.25,NULL,'2023-09-17 10:23:20','2023-09-17 10:23:20',NULL),(1904,7812,543,40720,1555,3,221,1,481.25,NULL,'2023-09-17 10:23:20','2023-09-17 10:23:20',NULL),(1905,7812,543,40720,1555,3,57,2,5000.01,NULL,'2023-09-17 10:23:20','2023-09-17 10:23:20',NULL),(1906,7812,544,40720,1555,3,217,1,19453.15,NULL,'2023-09-17 10:23:54','2023-09-17 10:23:54',NULL),(1907,7812,544,40720,1555,3,68,1,4085.16,NULL,'2023-09-17 10:23:54','2023-09-17 10:23:54',NULL),(1908,7812,544,40720,1555,3,221,1,1461.70,NULL,'2023-09-17 10:23:54','2023-09-17 10:23:54',NULL),(1909,7812,544,40720,1555,3,57,2,25000.01,NULL,'2023-09-17 10:23:54','2023-09-17 10:23:54',NULL),(1910,7812,545,40720,1555,3,217,1,11613.12,NULL,'2023-09-17 10:24:43','2023-09-17 10:24:43',NULL),(1911,7812,545,40720,1555,3,68,1,2438.76,NULL,'2023-09-17 10:24:43','2023-09-17 10:24:43',NULL),(1912,7812,545,40720,1555,3,221,1,948.13,NULL,'2023-09-17 10:24:43','2023-09-17 10:24:43',NULL),(1913,7812,545,40720,1555,3,57,2,15000.01,NULL,'2023-09-17 10:24:43','2023-09-17 10:24:43',NULL),(1914,7812,546,40720,1555,3,217,1,3778.68,NULL,'2023-09-17 10:25:28','2023-09-17 10:25:28',NULL),(1915,7812,546,40720,1555,3,68,1,793.52,NULL,'2023-09-17 10:25:28','2023-09-17 10:25:28',NULL),(1916,7812,546,40720,1555,3,221,1,427.80,NULL,'2023-09-17 10:25:28','2023-09-17 10:25:28',NULL),(1917,7812,546,40720,1555,3,57,2,5000.00,NULL,'2023-09-17 10:25:28','2023-09-17 10:25:28',NULL),(1918,7812,547,40720,1555,3,217,1,23400.31,NULL,'2023-09-17 10:27:52','2023-09-17 10:27:52',NULL),(1919,7812,547,40720,1555,3,68,1,4914.07,NULL,'2023-09-17 10:27:52','2023-09-17 10:27:52',NULL),(1920,7812,547,40720,1555,3,221,1,1685.63,NULL,'2023-09-17 10:27:52','2023-09-17 10:27:52',NULL),(1921,7812,547,40720,1555,3,57,2,30000.01,NULL,'2023-09-17 10:27:52','2023-09-17 10:27:52',NULL),(1922,7812,548,40720,1555,3,217,1,23400.31,NULL,'2023-09-17 10:28:36','2023-09-17 10:28:36',NULL),(1923,7812,548,40720,1555,3,68,1,4914.07,NULL,'2023-09-17 10:28:36','2023-09-17 10:28:36',NULL),(1924,7812,548,40720,1555,3,221,1,1685.63,NULL,'2023-09-17 10:28:36','2023-09-17 10:28:36',NULL),(1925,7812,548,40720,1555,3,57,2,30000.01,NULL,'2023-09-17 10:28:36','2023-09-17 10:28:36',NULL),(1926,7812,549,40720,1555,3,217,1,5559.26,NULL,'2023-09-17 10:29:14','2023-09-17 10:29:14',NULL),(1927,7812,549,40720,1555,3,68,1,1167.44,NULL,'2023-09-17 10:29:14','2023-09-17 10:29:14',NULL),(1928,7812,549,40720,1555,3,221,1,574.91,NULL,'2023-09-17 10:29:14','2023-09-17 10:29:14',NULL),(1929,7812,549,40720,1555,3,57,2,7301.61,NULL,'2023-09-17 10:29:14','2023-09-17 10:29:14',NULL),(1930,7812,550,40720,1555,3,217,1,23470.03,NULL,'2023-09-17 10:29:46','2023-09-17 10:29:46',NULL),(1931,7812,550,40720,1555,3,68,1,4928.71,NULL,'2023-09-17 10:29:46','2023-09-17 10:29:46',NULL),(1932,7812,550,40720,1555,3,221,1,1690.65,NULL,'2023-09-17 10:29:46','2023-09-17 10:29:46',NULL),(1933,7812,550,40720,1555,3,57,2,30089.39,NULL,'2023-09-17 10:29:46','2023-09-17 10:29:46',NULL),(1934,7812,551,40720,1555,3,217,1,59130.71,NULL,'2023-09-17 10:30:17','2023-09-17 10:30:17',NULL);
INSERT INTO `balance_libro_details` VALUES (1935,7812,551,40720,1555,3,68,1,12417.45,NULL,'2023-09-17 10:30:17','2023-09-17 10:30:17',NULL),(1936,7812,551,40720,1555,3,221,1,4259.45,NULL,'2023-09-17 10:30:17','2023-09-17 10:30:17',NULL),(1937,7812,551,40720,1555,3,57,2,75807.61,NULL,'2023-09-17 10:30:17','2023-09-17 10:30:17',NULL),(1938,7812,552,40720,1555,3,217,1,2120.95,NULL,'2023-09-17 10:31:23','2023-09-17 10:31:23',NULL),(1939,7812,552,40720,1555,3,68,1,445.40,NULL,'2023-09-17 10:31:23','2023-09-17 10:31:23',NULL),(1940,7812,552,40720,1555,3,221,1,435.15,NULL,'2023-09-17 10:31:23','2023-09-17 10:31:23',NULL),(1941,7812,552,40720,1555,3,57,2,3001.50,NULL,'2023-09-17 10:31:23','2023-09-17 10:31:23',NULL),(1942,7812,553,40720,1555,3,217,1,14192.60,NULL,'2023-09-17 10:32:52','2023-09-17 10:32:52',NULL),(1943,7812,553,40720,1555,3,68,1,2980.45,NULL,'2023-09-17 10:32:52','2023-09-17 10:32:52',NULL),(1944,7812,553,40720,1555,3,221,1,1465.06,NULL,'2023-09-17 10:32:52','2023-09-17 10:32:52',NULL),(1945,7812,553,40720,1555,3,57,2,18638.11,NULL,'2023-09-17 10:32:52','2023-09-17 10:32:52',NULL),(1946,7812,554,40720,1555,3,217,1,7533.72,NULL,'2023-09-17 10:33:47','2023-09-17 10:33:47',NULL),(1947,7812,554,40720,1555,3,68,1,1582.08,NULL,'2023-09-17 10:33:47','2023-09-17 10:33:47',NULL),(1948,7812,554,40720,1555,3,221,1,884.30,NULL,'2023-09-17 10:33:47','2023-09-17 10:33:47',NULL),(1949,7812,554,40720,1555,3,57,2,10000.10,NULL,'2023-09-17 10:33:47','2023-09-17 10:33:47',NULL),(1950,7812,555,40720,1555,3,217,1,7297.60,NULL,'2023-09-17 10:34:58','2023-09-17 10:34:58',NULL),(1951,7812,555,40720,1555,3,68,1,1532.50,NULL,'2023-09-17 10:34:58','2023-09-17 10:34:58',NULL),(1952,7812,555,40720,1555,3,221,1,786.62,NULL,'2023-09-17 10:34:58','2023-09-17 10:34:58',NULL),(1953,7812,555,40720,1555,3,57,2,9616.72,NULL,'2023-09-17 10:34:58','2023-09-17 10:34:58',NULL),(1954,7812,556,40720,1555,3,217,1,15205.69,NULL,'2023-09-17 10:35:30','2023-09-17 10:35:30',NULL),(1955,7812,556,40720,1555,3,68,1,3193.19,NULL,'2023-09-17 10:35:30','2023-09-17 10:35:30',NULL),(1956,7812,556,40720,1555,3,221,1,1601.10,NULL,'2023-09-17 10:35:30','2023-09-17 10:35:30',NULL),(1957,7812,556,40720,1555,3,57,2,19999.98,NULL,'2023-09-17 10:35:30','2023-09-17 10:35:30',NULL),(1958,7812,557,40720,1555,3,217,1,6241.60,NULL,'2023-09-17 10:36:11','2023-09-17 10:36:11',NULL),(1959,7812,557,40720,1555,3,68,1,1310.74,NULL,'2023-09-17 10:36:11','2023-09-17 10:36:11',NULL),(1960,7812,557,40720,1555,3,221,1,1148.56,NULL,'2023-09-17 10:36:11','2023-09-17 10:36:11',NULL),(1961,7812,557,40720,1555,3,57,2,8700.90,NULL,'2023-09-17 10:36:11','2023-09-17 10:36:11',NULL),(1962,7812,558,40720,1555,3,217,1,7602.85,NULL,'2023-09-17 10:36:43','2023-09-17 10:36:43',NULL),(1963,7812,558,40720,1555,3,68,1,1596.60,NULL,'2023-09-17 10:36:43','2023-09-17 10:36:43',NULL),(1964,7812,558,40720,1555,3,221,1,800.55,NULL,'2023-09-17 10:36:43','2023-09-17 10:36:43',NULL),(1965,7812,558,40720,1555,3,57,2,10000.00,NULL,'2023-09-17 10:36:43','2023-09-17 10:36:43',NULL),(1966,7812,559,40720,1555,3,217,1,15233.64,NULL,'2023-09-17 10:37:13','2023-09-17 10:37:13',NULL),(1967,7812,559,40720,1555,3,68,1,3199.06,NULL,'2023-09-17 10:37:13','2023-09-17 10:37:13',NULL),(1968,7812,559,40720,1555,3,221,1,1567.40,NULL,'2023-09-17 10:37:13','2023-09-17 10:37:13',NULL),(1969,7812,559,40720,1555,3,57,2,20000.10,NULL,'2023-09-17 10:37:13','2023-09-17 10:37:13',NULL),(1970,7812,560,40720,1555,3,217,1,27423.15,NULL,'2023-09-17 10:37:46','2023-09-17 10:37:46',NULL),(1971,7812,560,40720,1555,3,68,1,5758.86,NULL,'2023-09-17 10:37:46','2023-09-17 10:37:46',NULL),(1972,7812,560,40720,1555,3,221,1,2821.58,NULL,'2023-09-17 10:37:46','2023-09-17 10:37:46',NULL),(1973,7812,560,40720,1555,3,57,2,36003.59,NULL,'2023-09-17 10:37:46','2023-09-17 10:37:46',NULL),(1974,7812,561,40720,1555,3,217,1,15287.31,NULL,'2023-09-17 10:38:53','2023-09-17 10:38:53',NULL),(1975,7812,561,40720,1555,3,68,1,3210.34,NULL,'2023-09-17 10:38:53','2023-09-17 10:38:53',NULL);
INSERT INTO `balance_libro_details` VALUES (1976,7812,561,40720,1555,3,221,1,1502.35,NULL,'2023-09-17 10:38:53','2023-09-17 10:38:53',NULL),(1977,7812,561,40720,1555,3,57,2,20000.00,NULL,'2023-09-17 10:38:53','2023-09-17 10:38:53',NULL),(1978,7812,562,40720,1555,3,217,1,6432.68,NULL,'2023-09-17 10:39:24','2023-09-17 10:39:24',NULL),(1979,7812,562,40720,1555,3,68,1,1350.86,NULL,'2023-09-17 10:39:24','2023-09-17 10:39:24',NULL),(1980,7812,562,40720,1555,3,221,1,632.17,NULL,'2023-09-17 10:39:24','2023-09-17 10:39:24',NULL),(1981,7812,562,40720,1555,3,57,2,8415.71,NULL,'2023-09-17 10:39:24','2023-09-17 10:39:24',NULL),(1982,7812,563,40720,1555,3,217,1,19365.80,NULL,'2023-09-17 10:40:03','2023-09-17 10:40:03',NULL),(1983,7812,563,40720,1555,3,68,1,4066.82,NULL,'2023-09-17 10:40:03','2023-09-17 10:40:03',NULL),(1984,7812,563,40720,1555,3,221,1,1570.69,NULL,'2023-09-17 10:40:03','2023-09-17 10:40:03',NULL),(1985,7812,563,40720,1555,3,57,2,25003.31,NULL,'2023-09-17 10:40:03','2023-09-17 10:40:03',NULL),(1986,7812,564,40720,1555,3,217,1,30995.43,NULL,'2023-09-17 10:40:37','2023-09-17 10:40:37',NULL),(1987,7812,564,40720,1555,3,68,1,6509.04,NULL,'2023-09-17 10:40:37','2023-09-17 10:40:37',NULL),(1988,7812,564,40720,1555,3,221,1,2513.92,NULL,'2023-09-17 10:40:37','2023-09-17 10:40:37',NULL),(1989,7812,564,40720,1555,3,57,2,40018.39,NULL,'2023-09-17 10:40:37','2023-09-17 10:40:37',NULL),(1990,7812,565,40720,1555,3,217,1,23447.73,NULL,'2023-09-17 10:41:49','2023-09-17 10:41:49',NULL),(1991,7812,565,40720,1555,3,68,1,4924.02,NULL,'2023-09-17 10:41:49','2023-09-17 10:41:49',NULL),(1992,7812,565,40720,1555,3,221,1,1935.25,NULL,'2023-09-17 10:41:49','2023-09-17 10:41:49',NULL),(1993,7812,565,40720,1555,3,57,2,30307.00,NULL,'2023-09-17 10:41:49','2023-09-17 10:41:49',NULL),(1994,7812,566,40720,1555,3,217,1,27158.68,NULL,'2023-09-17 10:42:28','2023-09-17 10:42:28',NULL),(1995,7812,566,40720,1555,3,68,1,5703.32,NULL,'2023-09-17 10:42:28','2023-09-17 10:42:28',NULL),(1996,7812,566,40720,1555,3,221,1,2138.51,NULL,'2023-09-17 10:42:28','2023-09-17 10:42:28',NULL),(1997,7812,566,40720,1555,3,57,2,35000.51,NULL,'2023-09-17 10:42:28','2023-09-17 10:42:28',NULL),(1998,7812,567,40720,1555,3,217,1,19399.87,NULL,'2023-09-17 10:43:01','2023-09-17 10:43:01',NULL),(1999,7812,567,40720,1555,3,68,1,4073.97,NULL,'2023-09-17 10:43:01','2023-09-17 10:43:01',NULL),(2000,7812,567,40720,1555,3,221,1,1527.57,NULL,'2023-09-17 10:43:01','2023-09-17 10:43:01',NULL),(2001,7812,567,40720,1555,3,57,2,25001.41,NULL,'2023-09-17 10:43:01','2023-09-17 10:43:01',NULL),(2002,7812,568,40720,1555,3,217,1,23288.39,NULL,'2023-09-17 10:43:29','2023-09-17 10:43:29',NULL),(2003,7812,568,40720,1555,3,68,1,4890.56,NULL,'2023-09-17 10:43:29','2023-09-17 10:43:29',NULL),(2004,7812,568,40720,1555,3,221,1,1833.75,NULL,'2023-09-17 10:43:29','2023-09-17 10:43:29',NULL),(2005,7812,568,40720,1555,3,57,2,30012.70,NULL,'2023-09-17 10:43:29','2023-09-17 10:43:29',NULL),(2006,7812,569,40720,1555,3,217,1,19490.50,NULL,'2023-09-17 10:44:06','2023-09-17 10:44:06',NULL),(2007,7812,569,40720,1555,3,68,1,4093.01,NULL,'2023-09-17 10:44:06','2023-09-17 10:44:06',NULL),(2008,7812,569,40720,1555,3,221,1,1534.70,NULL,'2023-09-17 10:44:06','2023-09-17 10:44:06',NULL),(2009,7812,569,40720,1555,3,57,2,25118.21,NULL,'2023-09-17 10:44:06','2023-09-17 10:44:06',NULL),(2010,7812,570,40720,1555,3,217,1,7907.25,NULL,'2023-09-17 10:44:53','2023-09-17 10:44:53',NULL),(2011,7812,570,40720,1555,3,68,1,1660.52,NULL,'2023-09-17 10:44:53','2023-09-17 10:44:53',NULL),(2012,7812,570,40720,1555,3,221,1,938.31,NULL,'2023-09-17 10:44:53','2023-09-17 10:44:53',NULL),(2013,7812,570,40720,1555,3,57,2,10506.08,NULL,'2023-09-17 10:44:53','2023-09-17 10:44:53',NULL),(2014,7812,571,40720,1555,3,217,1,23471.07,NULL,'2023-09-17 10:48:19','2023-09-17 10:48:19',NULL),(2015,7812,571,40720,1555,3,68,1,4928.92,NULL,'2023-09-17 10:48:19','2023-09-17 10:48:19',NULL),(2016,7812,571,40720,1555,3,57,2,28399.99,NULL,'2023-09-17 10:48:19','2023-09-17 10:48:19',NULL);
INSERT INTO `balance_libro_details` VALUES (2017,7812,572,40720,1555,3,217,1,72727.27,NULL,'2023-09-17 10:48:59','2023-09-17 10:48:59',NULL),(2018,7812,572,40720,1555,3,68,1,15272.73,NULL,'2023-09-17 10:48:59','2023-09-17 10:48:59',NULL),(2019,7812,572,40720,1555,3,57,2,88000.00,NULL,'2023-09-17 10:48:59','2023-09-17 10:48:59',NULL),(2020,7812,573,40720,1555,3,217,1,33884.30,NULL,'2023-09-17 10:49:28','2023-09-17 10:49:28',NULL),(2021,7812,573,40720,1555,3,68,1,7115.70,NULL,'2023-09-17 10:49:28','2023-09-17 10:49:28',NULL),(2022,7812,573,40720,1555,3,57,2,41000.00,NULL,'2023-09-17 10:49:28','2023-09-17 10:49:28',NULL),(2023,7812,574,40720,1555,3,217,1,1487.60,NULL,'2023-09-17 10:50:30','2023-09-17 10:50:30',NULL),(2024,7812,574,40720,1555,3,68,1,312.40,NULL,'2023-09-17 10:50:30','2023-09-17 10:50:30',NULL),(2025,7812,574,40720,1555,3,57,2,1800.00,NULL,'2023-09-17 10:50:30','2023-09-17 10:50:30',NULL),(2026,7812,575,40720,1555,3,217,1,4710.75,NULL,'2023-09-17 10:51:02','2023-09-17 10:51:02',NULL),(2027,7812,575,40720,1555,3,68,1,989.26,NULL,'2023-09-17 10:51:02','2023-09-17 10:51:02',NULL),(2028,7812,575,40720,1555,3,57,2,5700.01,NULL,'2023-09-17 10:51:02','2023-09-17 10:51:02',NULL),(2029,7812,576,40720,1555,3,217,1,19649.59,NULL,'2023-09-17 10:51:43','2023-09-17 10:51:43',NULL),(2030,7812,576,40720,1555,3,68,1,4126.41,NULL,'2023-09-17 10:51:43','2023-09-17 10:51:43',NULL),(2031,7812,576,40720,1555,3,57,2,23776.00,NULL,'2023-09-17 10:51:43','2023-09-17 10:51:43',NULL),(2032,7812,577,40720,1555,3,217,1,6033.06,NULL,'2023-09-17 10:52:13','2023-09-17 10:52:13',NULL),(2033,7812,577,40720,1555,3,68,1,1266.94,NULL,'2023-09-17 10:52:13','2023-09-17 10:52:13',NULL),(2034,7812,577,40720,1555,3,57,2,7300.00,NULL,'2023-09-17 10:52:13','2023-09-17 10:52:13',NULL),(2035,7812,578,40720,1555,3,217,1,10580.45,NULL,'2023-09-17 10:54:27','2023-09-17 10:54:27',NULL),(2036,7812,578,40720,1555,3,68,1,2221.89,NULL,'2023-09-17 10:54:27','2023-09-17 10:54:27',NULL),(2037,7812,578,40720,1555,3,221,1,1128.69,NULL,'2023-09-17 10:54:27','2023-09-17 10:54:27',NULL),(2038,7812,578,40720,1555,3,224,1,69.16,NULL,'2023-09-17 10:54:27','2023-09-17 10:54:27',NULL),(2039,7812,578,40720,1555,3,57,2,14000.19,NULL,'2023-09-17 10:54:27','2023-09-17 10:54:27',NULL),(2040,7812,579,40720,1555,3,217,1,23400.30,NULL,'2023-09-17 10:55:15','2023-09-17 10:55:15',NULL),(2041,7812,579,40720,1555,3,68,1,4914.06,NULL,'2023-09-17 10:55:15','2023-09-17 10:55:15',NULL),(2042,7812,579,40720,1555,3,221,1,1513.08,NULL,'2023-09-17 10:55:15','2023-09-17 10:55:15',NULL),(2043,7812,579,40720,1555,3,224,1,172.54,NULL,'2023-09-17 10:55:15','2023-09-17 10:55:15',NULL),(2044,7812,579,40720,1555,3,57,2,29999.98,NULL,'2023-09-17 10:55:15','2023-09-17 10:55:15',NULL),(2045,7812,580,40720,1555,3,217,1,6075.65,NULL,'2023-09-17 10:55:55','2023-09-17 10:55:55',NULL),(2046,7812,580,40720,1555,3,68,1,1275.89,NULL,'2023-09-17 10:55:55','2023-09-17 10:55:55',NULL),(2047,7812,580,40720,1555,3,221,1,611.02,NULL,'2023-09-17 10:55:55','2023-09-17 10:55:55',NULL),(2048,7812,580,40720,1555,3,224,1,37.44,NULL,'2023-09-17 10:55:55','2023-09-17 10:55:55',NULL),(2049,7812,580,40720,1555,3,57,2,8000.00,NULL,'2023-09-17 10:55:55','2023-09-17 10:55:55',NULL),(2050,7812,581,40720,1555,3,217,1,19255.02,NULL,'2023-09-17 10:56:39','2023-09-17 10:56:39',NULL),(2051,7812,581,40720,1555,3,68,1,4043.55,NULL,'2023-09-17 10:56:40','2023-09-17 10:56:40',NULL),(2052,7812,581,40720,1555,3,221,1,1527.26,NULL,'2023-09-17 10:56:40','2023-09-17 10:56:40',NULL),(2053,7812,581,40720,1555,3,224,1,174.16,NULL,'2023-09-17 10:56:40','2023-09-17 10:56:40',NULL),(2054,7812,581,40720,1555,3,57,2,24999.99,NULL,'2023-09-17 10:56:40','2023-09-17 10:56:40',NULL),(2055,7812,582,40720,1555,3,217,1,53914.07,NULL,'2023-09-17 10:57:30','2023-09-17 10:57:30',NULL),(2056,7812,582,40720,1555,3,68,1,11321.95,NULL,'2023-09-17 10:57:30','2023-09-17 10:57:30',NULL),(2057,7812,582,40720,1555,3,221,1,4276.32,NULL,'2023-09-17 10:57:30','2023-09-17 10:57:30',NULL);
INSERT INTO `balance_libro_details` VALUES (2058,7812,582,40720,1555,3,224,1,487.65,NULL,'2023-09-17 10:57:30','2023-09-17 10:57:30',NULL),(2059,7812,582,40720,1555,3,57,2,69999.99,NULL,'2023-09-17 10:57:30','2023-09-17 10:57:30',NULL),(2060,7812,583,40720,1555,3,217,1,23278.54,NULL,'2023-09-17 10:58:22','2023-09-17 10:58:22',NULL),(2061,7812,583,40720,1555,3,68,1,4888.49,NULL,'2023-09-17 10:58:22','2023-09-17 10:58:22',NULL),(2062,7812,583,40720,1555,3,221,1,1645.35,NULL,'2023-09-17 10:58:22','2023-09-17 10:58:22',NULL),(2063,7812,583,40720,1555,3,224,1,187.62,NULL,'2023-09-17 10:58:22','2023-09-17 10:58:22',NULL),(2064,7812,583,40720,1555,3,57,2,30000.00,NULL,'2023-09-17 10:58:22','2023-09-17 10:58:22',NULL),(2065,7812,584,40720,1555,3,217,1,46557.06,NULL,'2023-09-17 10:59:08','2023-09-17 10:59:08',NULL),(2066,7812,584,40720,1555,3,68,1,9776.98,NULL,'2023-09-17 10:59:08','2023-09-17 10:59:08',NULL),(2067,7812,584,40720,1555,3,221,1,3290.70,NULL,'2023-09-17 10:59:08','2023-09-17 10:59:08',NULL),(2068,7812,584,40720,1555,3,224,1,375.25,NULL,'2023-09-17 10:59:08','2023-09-17 10:59:08',NULL),(2069,7812,584,40720,1555,3,57,2,59999.99,NULL,'2023-09-17 10:59:08','2023-09-17 10:59:08',NULL),(2070,7812,585,40720,1555,3,217,1,46557.06,NULL,'2023-09-17 10:59:51','2023-09-17 10:59:51',NULL),(2071,7812,585,40720,1555,3,68,1,9776.98,NULL,'2023-09-17 10:59:51','2023-09-17 10:59:51',NULL),(2072,7812,585,40720,1555,3,221,1,3290.70,NULL,'2023-09-17 10:59:51','2023-09-17 10:59:51',NULL),(2073,7812,585,40720,1555,3,224,1,375.25,NULL,'2023-09-17 10:59:51','2023-09-17 10:59:51',NULL),(2074,7812,585,40720,1555,3,57,2,59999.99,NULL,'2023-09-17 10:59:51','2023-09-17 10:59:51',NULL),(2075,7812,586,40720,1555,3,217,1,29647.45,NULL,'2023-09-17 11:02:58','2023-09-17 11:02:58',NULL),(2076,7812,586,40720,1555,3,68,1,6225.96,NULL,'2023-09-17 11:02:58','2023-09-17 11:02:58',NULL),(2077,7812,586,40720,1555,3,57,2,35873.41,NULL,'2023-09-17 11:02:58','2023-09-17 11:02:58',NULL),(2078,7812,587,40720,1555,3,217,1,6611.60,NULL,'2023-09-17 11:03:24','2023-09-17 11:03:24',NULL),(2079,7812,587,40720,1555,3,68,1,1388.44,NULL,'2023-09-17 11:03:24','2023-09-17 11:03:24',NULL),(2080,7812,587,40720,1555,3,57,2,8000.04,NULL,'2023-09-17 11:03:24','2023-09-17 11:03:24',NULL),(2081,7812,588,40720,1555,3,217,1,65285.70,NULL,'2023-09-17 11:04:49','2023-09-17 11:04:49',NULL),(2082,7812,588,40720,1555,3,68,1,13710.00,NULL,'2023-09-17 11:04:49','2023-09-17 11:04:49',NULL),(2083,7812,588,40720,1555,3,221,1,6805.80,NULL,'2023-09-17 11:04:49','2023-09-17 11:04:49',NULL),(2084,7812,588,40720,1555,3,57,2,85801.50,NULL,'2023-09-17 11:04:49','2023-09-17 11:04:49',NULL),(2085,7812,589,40720,1555,2,96,2,295074.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2086,7812,589,40720,1555,2,67,2,61965.54,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2087,7812,589,40720,1555,2,13,1,357039.54,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2088,7812,590,40720,1555,2,96,2,159390.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2089,7812,590,40720,1555,2,67,2,33471.90,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2090,7812,590,40720,1555,2,13,1,192861.90,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2091,7812,591,40720,1555,2,96,2,189544.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2092,7812,591,40720,1555,2,67,2,39804.24,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2093,7812,591,40720,1555,2,13,1,229348.24,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2094,7812,592,40720,1555,2,96,2,346836.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2095,7812,592,40720,1555,2,67,2,72835.56,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2096,7812,592,40720,1555,2,13,1,419671.56,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2097,7812,593,40720,1555,2,96,2,208447.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2098,7812,593,40720,1555,2,67,2,43773.87,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL);
INSERT INTO `balance_libro_details` VALUES (2099,7812,593,40720,1555,2,13,1,252220.87,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2100,7812,594,40720,1555,2,96,2,345579.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2101,7812,594,40720,1555,2,67,2,72571.59,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2102,7812,594,40720,1555,2,13,1,418150.59,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2103,7812,595,40720,1555,2,96,2,159700.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2104,7812,595,40720,1555,2,67,2,33537.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2105,7812,595,40720,1555,2,13,1,193237.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2106,7812,596,40720,1555,2,96,2,164730.00,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2107,7812,596,40720,1555,2,67,2,34593.30,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2108,7812,596,40720,1555,2,13,1,199323.30,NULL,'2023-09-17 11:07:23','2023-09-17 11:07:23',NULL),(2109,7812,597,40720,1555,2,96,2,406156.50,NULL,'2023-09-17 11:07:24','2023-09-17 11:07:24',NULL),(2110,7812,597,40720,1555,2,67,2,85292.87,NULL,'2023-09-17 11:07:24','2023-09-17 11:07:24',NULL),(2111,7812,597,40720,1555,2,13,1,491449.37,NULL,'2023-09-17 11:07:24','2023-09-17 11:07:24',NULL),(2112,7812,598,40720,1555,2,96,2,425829.00,NULL,'2023-09-17 11:07:24','2023-09-17 11:07:24',NULL),(2113,7812,598,40720,1555,2,67,2,89424.09,NULL,'2023-09-17 11:07:24','2023-09-17 11:07:24',NULL),(2114,7812,598,40720,1555,2,13,1,515253.09,NULL,'2023-09-17 11:07:24','2023-09-17 11:07:24',NULL),(2115,7812,599,40720,1555,3,217,1,5371.90,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2116,7812,599,40720,1555,3,68,1,1128.10,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2117,7812,599,40720,1555,3,57,2,6500.00,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2118,7812,600,40720,1555,3,217,1,615694.48,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2119,7812,600,40720,1555,3,68,1,129295.84,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2120,7812,600,40720,1555,3,57,2,744990.32,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2121,7812,601,40720,1555,3,217,1,28843.27,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2122,7812,601,40720,1555,3,68,1,3028.54,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2123,7812,601,40720,1555,3,57,2,31871.81,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2124,7812,602,40720,1555,3,217,1,41321.49,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2125,7812,602,40720,1555,3,68,1,8677.51,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2126,7812,602,40720,1555,3,57,2,49999.00,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2127,7812,603,40720,1555,3,217,1,90909.09,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2128,7812,603,40720,1555,3,68,1,19090.91,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2129,7812,603,40720,1555,3,57,2,110000.00,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2130,7812,604,40720,1555,3,217,1,30254.54,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2131,7812,604,40720,1555,3,68,1,6353.46,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2132,7812,604,40720,1555,3,57,2,36608.00,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2133,7812,605,40720,1555,3,217,1,14851.23,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2134,7812,605,40720,1555,3,68,1,3118.76,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2135,7812,605,40720,1555,3,57,2,17969.99,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2136,7812,606,40720,1555,3,217,1,71157.02,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2137,7812,606,40720,1555,3,68,1,14942.98,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2138,7812,606,40720,1555,3,57,2,86100.00,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2139,7812,607,40720,1555,3,217,1,3415.15,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL);
INSERT INTO `balance_libro_details` VALUES (2140,7812,607,40720,1555,3,68,1,717.18,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2141,7812,607,40720,1555,3,57,2,4132.33,NULL,'2023-09-17 11:07:45','2023-09-17 11:07:45',NULL),(2142,7812,608,40720,1555,3,217,1,29123.14,NULL,'2023-09-17 11:07:45','2023-09-19 19:51:22','2023-09-19 19:51:22'),(2143,7812,608,40720,1555,3,68,1,6115.86,NULL,'2023-09-17 11:07:45','2023-09-19 19:51:22','2023-09-19 19:51:22'),(2144,7812,608,40720,1555,3,57,2,35239.00,NULL,'2023-09-17 11:07:45','2023-09-19 19:51:22','2023-09-19 19:51:22'),(2145,7812,609,40720,1555,3,217,1,31405.10,NULL,'2023-09-17 11:07:46','2023-09-17 11:07:46',NULL),(2146,7812,609,40720,1555,3,68,1,6594.90,NULL,'2023-09-17 11:07:46','2023-09-17 11:07:46',NULL),(2147,7812,609,40720,1555,3,57,2,38000.00,NULL,'2023-09-17 11:07:46','2023-09-17 11:07:46',NULL),(2148,7812,610,40720,1555,3,217,1,3454.55,NULL,'2023-09-17 11:07:46','2023-09-17 11:07:46',NULL),(2149,7812,610,40720,1555,3,68,1,725.46,NULL,'2023-09-17 11:07:46','2023-09-17 11:07:46',NULL),(2150,7812,610,40720,1555,3,57,2,4180.01,NULL,'2023-09-17 11:07:46','2023-09-17 11:07:46',NULL),(2151,7812,611,40720,1555,3,217,1,29123.14,NULL,'2023-09-19 19:51:22','2023-09-19 19:51:22',NULL),(2152,7812,611,40720,1555,3,68,1,6115.86,NULL,'2023-09-19 19:51:22','2023-09-19 19:51:22',NULL),(2153,7812,611,40720,1555,3,57,2,35239.00,NULL,'2023-09-19 19:51:22','2023-09-19 19:51:22',NULL),(2154,7812,612,40720,1555,15,67,1,567269.96,NULL,'2023-09-19 19:54:42','2025-06-07 09:10:07','2025-06-07 09:10:07'),(2155,7812,612,40720,1555,15,68,2,456842.60,NULL,'2023-09-19 19:54:42','2025-06-07 09:10:07','2025-06-07 09:10:07'),(2156,7812,612,40720,1555,15,353,2,229921.23,NULL,'2023-09-19 19:54:42','2025-06-07 09:10:07','2025-06-07 09:10:07'),(2157,7812,612,40720,1555,15,353,1,119493.87,NULL,'2023-09-19 19:54:42','2025-06-07 09:10:07','2025-06-07 09:10:07'),(2158,7812,613,40720,1556,2,96,2,414864.00,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2159,7812,613,40720,1556,2,67,2,87121.44,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2160,7812,613,40720,1556,2,13,1,501985.44,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2161,7812,614,40720,1556,2,96,2,212463.00,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2162,7812,614,40720,1556,2,67,2,44617.23,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2163,7812,614,40720,1556,2,13,1,257080.23,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2164,7812,615,40720,1556,2,96,2,415380.00,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2165,7812,615,40720,1556,2,67,2,87229.80,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2166,7812,615,40720,1556,2,13,1,502609.80,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2167,7812,616,40720,1556,2,96,2,270000.00,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2168,7812,616,40720,1556,2,67,2,56700.00,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2169,7812,616,40720,1556,2,13,1,326700.00,NULL,'2023-10-12 19:43:08','2023-10-12 19:43:08',NULL),(2170,7812,617,40720,1556,3,217,1,29752.07,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2171,7812,617,40720,1556,3,68,1,6247.93,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2172,7812,617,40720,1556,3,57,2,36000.00,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2173,7812,618,40720,1556,3,217,1,209706.67,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2174,7812,618,40720,1556,3,68,1,44038.40,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2175,7812,618,40720,1556,3,217,1,0.02,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2176,7812,618,40720,1556,3,57,2,253745.09,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2177,7812,619,40720,1556,3,217,1,74380.14,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2178,7812,619,40720,1556,3,68,1,15619.83,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL);
INSERT INTO `balance_libro_details` VALUES (2179,7812,619,40720,1556,3,217,1,0.03,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2180,7812,619,40720,1556,3,57,2,90000.00,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2181,7812,620,40720,1556,3,217,2,11570.24,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2182,7812,620,40720,1556,3,67,2,2429.75,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2183,7812,620,40720,1556,3,217,2,0.01,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2184,7812,620,40720,1556,3,57,1,14000.00,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2185,7812,621,40720,1556,3,217,1,91735.52,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2186,7812,621,40720,1556,3,68,1,19264.46,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2187,7812,621,40720,1556,3,217,1,0.04,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2188,7812,621,40720,1556,3,57,2,111000.02,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2189,7812,622,40720,1556,3,217,1,24876.03,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2190,7812,622,40720,1556,3,68,1,5223.97,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2191,7812,622,40720,1556,3,57,2,30100.00,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2192,7812,623,40720,1556,3,217,1,619835.00,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2193,7812,623,40720,1556,3,68,1,130165.35,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2194,7812,623,40720,1556,3,57,2,750000.35,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2195,7812,624,40720,1556,3,250,1,50000.00,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2196,7812,624,40720,1556,3,57,2,50000.00,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2197,7812,625,40720,1556,3,217,1,11570.24,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2198,7812,625,40720,1556,3,68,1,2429.75,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2199,7812,625,40720,1556,3,217,1,0.01,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2200,7812,625,40720,1556,3,57,2,14000.00,NULL,'2023-10-12 19:43:21','2023-10-12 19:43:21',NULL),(2201,7812,626,40720,1556,15,67,1,278098.22,NULL,'2023-11-01 18:19:59','2025-06-07 09:35:23','2025-06-07 09:35:23'),(2202,7812,626,40720,1556,15,68,2,222989.69,NULL,'2023-11-01 18:19:59','2025-06-07 09:35:23','2025-06-07 09:35:23'),(2203,7812,626,40720,1556,15,353,2,119493.87,NULL,'2023-11-01 18:19:59','2025-06-07 09:35:23','2025-06-07 09:35:23'),(2204,7812,626,40720,1556,15,353,1,64385.34,NULL,'2023-11-01 18:19:59','2025-06-07 09:35:23','2025-06-07 09:35:23'),(2205,7812,627,40720,1557,2,96,2,270000.00,NULL,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(2206,7812,627,40720,1557,2,67,2,56700.00,NULL,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(2207,7812,627,40720,1557,2,13,1,326700.00,NULL,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(2208,7812,628,40720,1557,2,96,2,270000.00,NULL,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(2209,7812,628,40720,1557,2,67,2,56700.00,NULL,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(2210,7812,628,40720,1557,2,13,1,326700.00,NULL,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(2211,7812,629,40720,1557,2,96,2,324000.00,NULL,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(2212,7812,629,40720,1557,2,67,2,68040.00,NULL,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(2213,7812,629,40720,1557,2,13,1,392040.00,NULL,'2023-11-21 17:10:43','2023-11-21 17:10:43',NULL),(2214,7812,630,40720,1557,2,96,2,270000.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2215,7812,630,40720,1557,2,67,2,56700.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2216,7812,630,40720,1557,2,13,1,326700.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2217,7812,631,40720,1557,2,96,2,540000.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2218,7812,631,40720,1557,2,67,2,113400.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL);
INSERT INTO `balance_libro_details` VALUES (2219,7812,631,40720,1557,2,13,1,653400.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2220,7812,632,40720,1557,2,96,1,540000.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2221,7812,632,40720,1557,2,68,1,113400.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2222,7812,632,40720,1557,2,13,2,653400.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2223,7812,633,40720,1557,2,96,2,162000.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2224,7812,633,40720,1557,2,67,2,34020.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2225,7812,633,40720,1557,2,13,1,196020.00,NULL,'2023-11-21 17:10:44','2023-11-21 17:10:44',NULL),(2226,7812,634,40720,1557,3,217,1,7190.08,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2227,7812,634,40720,1557,3,68,1,1509.92,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2228,7812,634,40720,1557,3,57,2,8700.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2229,7812,635,40720,1557,3,217,1,10375.20,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2230,7812,635,40720,1557,3,68,1,2178.79,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2231,7812,635,40720,1557,3,57,2,12553.99,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2232,7812,636,40720,1557,3,217,1,11826.43,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2233,7812,636,40720,1557,3,68,1,2483.55,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2234,7812,636,40720,1557,3,217,1,0.01,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2235,7812,636,40720,1557,3,57,2,14309.99,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2236,7812,637,40720,1557,3,217,1,37383.68,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2237,7812,637,40720,1557,3,68,1,7850.57,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2238,7812,637,40720,1557,3,217,1,2115.74,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2239,7812,637,40720,1557,3,57,2,47349.99,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2240,7812,638,40720,1557,3,217,1,1647.11,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2241,7812,638,40720,1557,3,68,1,345.89,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2242,7812,638,40720,1557,3,57,2,1993.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2243,7812,639,40720,1557,3,217,1,81422.60,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2244,7812,639,40720,1557,3,68,1,17098.75,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2245,7812,639,40720,1557,3,57,2,98521.35,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2246,7812,640,40720,1557,3,217,1,15702.48,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2247,7812,640,40720,1557,3,68,1,3297.52,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2248,7812,640,40720,1557,3,57,2,19000.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2249,7812,641,40720,1557,3,250,1,0.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:20:16','2023-11-21 17:20:16'),(2250,7812,641,40720,1557,3,250,1,135100.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:20:16','2023-11-21 17:20:16'),(2251,7812,641,40720,1557,3,57,2,135100.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:20:16','2023-11-21 17:20:16'),(2252,7812,642,40720,1557,3,250,1,0.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:20:08','2023-11-21 17:20:08'),(2253,7812,642,40720,1557,3,250,1,199920.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:20:08','2023-11-21 17:20:08'),(2254,7812,642,40720,1557,3,57,2,199920.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:20:08','2023-11-21 17:20:08'),(2255,7812,643,40720,1557,3,250,1,0.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:19:59','2023-11-21 17:19:59'),(2256,7812,643,40720,1557,3,250,1,107107.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:19:59','2023-11-21 17:19:59'),(2257,7812,643,40720,1557,3,57,2,107107.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:19:59','2023-11-21 17:19:59');
INSERT INTO `balance_libro_details` VALUES (2258,7812,644,40720,1557,3,250,2,0.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:19:51','2023-11-21 17:19:51'),(2259,7812,644,40720,1557,3,250,2,199920.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:19:51','2023-11-21 17:19:51'),(2260,7812,644,40720,1557,3,57,1,199920.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:19:51','2023-11-21 17:19:51'),(2261,7812,645,40720,1557,3,217,1,13223.14,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2262,7812,645,40720,1557,3,68,1,2776.86,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2263,7812,645,40720,1557,3,57,2,16000.00,NULL,'2023-11-21 17:11:05','2023-11-21 17:11:05',NULL),(2264,7812,646,40720,1557,3,217,1,16115.71,NULL,'2023-11-21 17:11:06','2023-11-21 17:18:05','2023-11-21 17:18:05'),(2265,7812,646,40720,1557,3,68,1,3384.30,NULL,'2023-11-21 17:11:06','2023-11-21 17:18:05','2023-11-21 17:18:05'),(2266,7812,646,40720,1557,3,217,1,-0.01,NULL,'2023-11-21 17:11:06','2023-11-21 17:18:05','2023-11-21 17:18:05'),(2267,7812,646,40720,1557,3,57,2,19500.00,NULL,'2023-11-21 17:11:06','2023-11-21 17:18:05','2023-11-21 17:18:05'),(2268,7812,647,40720,1557,3,217,1,16115.70,NULL,'2023-11-21 17:18:05','2023-11-21 17:18:05',NULL),(2269,7812,647,40720,1557,3,68,1,3384.30,NULL,'2023-11-21 17:18:05','2023-11-21 17:18:05',NULL),(2270,7812,647,40720,1557,3,57,2,19500.00,NULL,'2023-11-21 17:18:05','2023-11-21 17:18:05',NULL),(2271,7812,648,40720,1557,3,217,1,17918.73,NULL,'2023-11-21 17:26:29','2023-11-21 17:26:29',NULL),(2272,7812,648,40720,1557,3,68,1,3762.93,NULL,'2023-11-21 17:26:29','2023-11-21 17:26:29',NULL),(2273,7812,648,40720,1557,3,221,1,1410.94,NULL,'2023-11-21 17:26:29','2023-11-21 17:26:29',NULL),(2274,7812,648,40720,1557,3,57,2,23092.60,NULL,'2023-11-21 17:26:29','2023-11-21 17:26:29',NULL),(2275,7812,649,40720,1557,3,217,1,13192.55,NULL,'2023-11-21 17:27:16','2023-11-21 17:27:16',NULL),(2276,7812,649,40720,1557,3,68,1,2770.44,NULL,'2023-11-21 17:27:16','2023-11-21 17:27:16',NULL),(2277,7812,649,40720,1557,3,221,1,1038.50,NULL,'2023-11-21 17:27:16','2023-11-21 17:27:16',NULL),(2278,7812,649,40720,1557,3,57,2,17001.49,NULL,'2023-11-21 17:27:16','2023-11-21 17:27:16',NULL),(2279,7812,650,40720,1557,3,217,1,7312.11,NULL,'2023-11-21 17:28:04','2023-11-21 17:28:04',NULL),(2280,7812,650,40720,1557,3,68,1,1535.54,NULL,'2023-11-21 17:28:04','2023-11-21 17:28:04',NULL),(2281,7812,650,40720,1557,3,221,1,575.76,NULL,'2023-11-21 17:28:04','2023-11-21 17:28:04',NULL),(2282,7812,650,40720,1557,3,57,2,9423.41,NULL,'2023-11-21 17:28:04','2023-11-21 17:28:04',NULL),(2283,7812,651,40720,1557,3,217,1,15519.02,NULL,'2023-11-21 17:28:43','2023-11-21 17:28:43',NULL),(2284,7812,651,40720,1557,3,68,1,3258.99,NULL,'2023-11-21 17:28:43','2023-11-21 17:28:43',NULL),(2285,7812,651,40720,1557,3,221,1,1221.98,NULL,'2023-11-21 17:28:43','2023-11-21 17:28:43',NULL),(2286,7812,651,40720,1557,3,57,2,19999.99,NULL,'2023-11-21 17:28:43','2023-11-21 17:28:43',NULL),(2287,7812,652,40720,1557,3,217,1,27217.42,NULL,'2023-11-21 17:29:26','2023-11-21 17:29:26',NULL),(2288,7812,652,40720,1557,3,68,1,5715.66,NULL,'2023-11-21 17:29:26','2023-11-21 17:29:26',NULL),(2289,7812,652,40720,1557,3,221,1,2072.34,NULL,'2023-11-21 17:29:26','2023-11-21 17:29:26',NULL),(2290,7812,652,40720,1557,3,57,2,35005.42,NULL,'2023-11-21 17:29:26','2023-11-21 17:29:26',NULL),(2291,7812,653,40720,1557,3,217,1,4481.41,NULL,'2023-11-21 17:30:50','2023-11-21 17:30:50',NULL),(2292,7812,653,40720,1557,3,68,1,941.10,NULL,'2023-11-21 17:30:50','2023-11-21 17:30:50',NULL),(2293,7812,653,40720,1557,3,221,1,577.50,NULL,'2023-11-21 17:30:50','2023-11-21 17:30:50',NULL),(2294,7812,653,40720,1557,3,57,2,6000.01,NULL,'2023-11-21 17:30:50','2023-11-21 17:30:50',NULL),(2295,7812,654,40720,1557,3,217,1,23403.18,NULL,'2023-11-21 17:31:31','2023-11-21 17:31:31',NULL),(2296,7812,654,40720,1557,3,68,1,4914.67,NULL,'2023-11-21 17:31:31','2023-11-21 17:31:31',NULL),(2297,7812,654,40720,1557,3,221,1,1685.84,NULL,'2023-11-21 17:31:31','2023-11-21 17:31:31',NULL);
INSERT INTO `balance_libro_details` VALUES (2298,7812,654,40720,1557,3,57,2,30003.69,NULL,'2023-11-21 17:31:31','2023-11-21 17:31:31',NULL),(2299,7812,655,40720,1557,3,217,1,23499.23,NULL,'2023-11-21 17:32:09','2023-11-21 17:32:09',NULL),(2300,7812,655,40720,1557,3,68,1,4934.84,NULL,'2023-11-21 17:32:09','2023-11-21 17:32:09',NULL),(2301,7812,655,40720,1557,3,221,1,1585.53,NULL,'2023-11-21 17:32:09','2023-11-21 17:32:09',NULL),(2302,7812,655,40720,1557,3,57,2,30019.60,NULL,'2023-11-21 17:32:09','2023-11-21 17:32:09',NULL),(2303,7812,656,40720,1557,3,217,1,6045.88,NULL,'2023-11-21 17:32:56','2023-11-21 17:32:56',NULL),(2304,7812,656,40720,1557,3,68,1,1269.63,NULL,'2023-11-21 17:32:56','2023-11-21 17:32:56',NULL),(2305,7812,656,40720,1557,3,221,1,684.48,NULL,'2023-11-21 17:32:56','2023-11-21 17:32:56',NULL),(2306,7812,656,40720,1557,3,57,2,7999.99,NULL,'2023-11-21 17:32:56','2023-11-21 17:32:56',NULL),(2307,7812,657,40720,1557,3,217,1,19504.09,NULL,'2023-11-21 17:33:43','2023-11-21 17:33:43',NULL),(2308,7812,657,40720,1557,3,68,1,4095.86,NULL,'2023-11-21 17:33:43','2023-11-21 17:33:43',NULL),(2309,7812,657,40720,1557,3,221,1,1404.97,NULL,'2023-11-21 17:33:43','2023-11-21 17:33:43',NULL),(2310,7812,657,40720,1557,3,57,2,25004.92,NULL,'2023-11-21 17:33:43','2023-11-21 17:33:43',NULL),(2311,7812,658,40720,1557,3,217,1,23483.89,NULL,'2023-11-21 17:34:31','2023-11-21 17:34:31',NULL),(2312,7812,658,40720,1557,3,68,1,4931.62,NULL,'2023-11-21 17:34:31','2023-11-21 17:34:31',NULL),(2313,7812,658,40720,1557,3,221,1,1584.49,NULL,'2023-11-21 17:34:31','2023-11-21 17:34:31',NULL),(2314,7812,658,40720,1557,3,57,2,30000.00,NULL,'2023-11-21 17:34:31','2023-11-21 17:34:31',NULL),(2315,7812,659,40720,1557,3,217,1,123263.04,NULL,'2023-11-21 17:35:12','2023-11-21 17:35:12',NULL),(2316,7812,659,40720,1557,3,68,1,25885.24,NULL,'2023-11-21 17:35:12','2023-11-21 17:35:12',NULL),(2317,7812,659,40720,1557,3,221,1,8316.74,NULL,'2023-11-21 17:35:12','2023-11-21 17:35:12',NULL),(2318,7812,659,40720,1557,3,57,2,157465.02,NULL,'2023-11-21 17:35:12','2023-11-21 17:35:12',NULL),(2319,7812,660,40720,1557,3,217,1,2310.69,NULL,'2023-11-21 17:36:12','2023-11-21 17:36:12',NULL),(2320,7812,660,40720,1557,3,68,1,485.24,NULL,'2023-11-21 17:36:12','2023-11-21 17:36:12',NULL),(2321,7812,660,40720,1557,3,221,1,207.08,NULL,'2023-11-21 17:36:12','2023-11-21 17:36:12',NULL),(2322,7812,660,40720,1557,3,57,2,3003.01,NULL,'2023-11-21 17:36:12','2023-11-21 17:36:12',NULL),(2323,7812,661,40720,1557,3,217,1,12524.76,NULL,'2023-11-21 17:36:50','2023-11-21 17:36:50',NULL),(2324,7812,661,40720,1557,3,68,1,2630.20,NULL,'2023-11-21 17:36:50','2023-11-21 17:36:50',NULL),(2325,7812,661,40720,1557,3,221,1,845.06,NULL,'2023-11-21 17:36:50','2023-11-21 17:36:50',NULL),(2326,7812,661,40720,1557,3,57,2,16000.02,NULL,'2023-11-21 17:36:50','2023-11-21 17:36:50',NULL),(2327,7812,662,40720,1557,3,217,1,13249.84,NULL,'2023-11-21 17:38:15','2023-11-21 17:38:15',NULL),(2328,7812,662,40720,1557,3,68,1,2782.47,NULL,'2023-11-21 17:38:15','2023-11-21 17:38:15',NULL),(2329,7812,662,40720,1557,3,221,1,1170.79,NULL,'2023-11-21 17:38:15','2023-11-21 17:38:15',NULL),(2330,7812,662,40720,1557,3,57,2,17203.10,NULL,'2023-11-21 17:38:15','2023-11-21 17:38:15',NULL),(2331,7812,663,40720,1557,3,217,1,5290.16,NULL,'2023-11-21 17:39:25','2023-11-21 17:39:25',NULL),(2332,7812,663,40720,1557,3,68,1,1110.93,NULL,'2023-11-21 17:39:25','2023-11-21 17:39:25',NULL),(2333,7812,663,40720,1557,3,221,1,598.92,NULL,'2023-11-21 17:39:25','2023-11-21 17:39:25',NULL),(2334,7812,663,40720,1557,3,57,2,7000.01,NULL,'2023-11-21 17:39:25','2023-11-21 17:39:25',NULL),(2335,7812,664,40720,1557,3,217,1,27379.21,NULL,'2023-11-21 17:40:10','2023-11-21 17:40:10',NULL),(2336,7812,664,40720,1557,3,68,1,5749.63,NULL,'2023-11-21 17:40:10','2023-11-21 17:40:10',NULL),(2337,7812,664,40720,1557,3,221,1,1872.66,NULL,'2023-11-21 17:40:10','2023-11-21 17:40:10',NULL),(2338,7812,664,40720,1557,3,57,2,35001.50,NULL,'2023-11-21 17:40:10','2023-11-21 17:40:10',NULL);
INSERT INTO `balance_libro_details` VALUES (2339,7812,665,40720,1557,3,217,1,37546.38,NULL,'2023-11-21 17:40:50','2023-11-21 17:40:50',NULL),(2340,7812,665,40720,1557,3,68,1,7884.74,NULL,'2023-11-21 17:40:50','2023-11-21 17:40:50',NULL),(2341,7812,665,40720,1557,3,221,1,2568.07,NULL,'2023-11-21 17:40:50','2023-11-21 17:40:50',NULL),(2342,7812,665,40720,1557,3,57,2,47999.19,NULL,'2023-11-21 17:40:50','2023-11-21 17:40:50',NULL),(2343,7812,666,40720,1557,3,217,1,68252.34,NULL,'2023-11-21 17:41:54','2023-11-21 17:41:54',NULL),(2344,7812,666,40720,1557,3,68,1,14332.99,NULL,'2023-11-21 17:41:54','2023-11-21 17:41:54',NULL),(2345,7812,666,40720,1557,3,221,1,4668.28,NULL,'2023-11-21 17:41:54','2023-11-21 17:41:54',NULL),(2346,7812,666,40720,1557,3,57,2,87253.61,NULL,'2023-11-21 17:41:54','2023-11-21 17:41:54',NULL),(2347,7812,667,40720,1557,3,217,1,4693.39,NULL,'2023-11-21 17:42:31','2023-11-21 17:42:31',NULL),(2348,7812,667,40720,1557,3,68,1,985.61,NULL,'2023-11-21 17:42:31','2023-11-21 17:42:31',NULL),(2349,7812,667,40720,1557,3,221,1,321.01,NULL,'2023-11-21 17:42:31','2023-11-21 17:42:31',NULL),(2350,7812,667,40720,1557,3,57,2,6000.01,NULL,'2023-11-21 17:42:31','2023-11-21 17:42:31',NULL),(2351,7812,668,40720,1557,3,217,1,31318.60,NULL,'2023-11-21 17:43:33','2023-11-21 17:43:33',NULL),(2352,7812,668,40720,1557,3,68,1,6576.91,NULL,'2023-11-21 17:43:33','2023-11-21 17:43:33',NULL),(2353,7812,668,40720,1557,3,221,1,2113.11,NULL,'2023-11-21 17:43:33','2023-11-21 17:43:33',NULL),(2354,7812,668,40720,1557,3,57,2,40008.62,NULL,'2023-11-21 17:43:33','2023-11-21 17:43:33',NULL),(2355,7812,669,40720,1557,3,217,1,23506.74,NULL,'2023-11-21 17:44:19','2023-11-21 17:44:19',NULL),(2356,7812,669,40720,1557,3,68,1,4936.42,NULL,'2023-11-21 17:44:19','2023-11-21 17:44:19',NULL),(2357,7812,669,40720,1557,3,221,1,1586.03,NULL,'2023-11-21 17:44:19','2023-11-21 17:44:19',NULL),(2358,7812,669,40720,1557,3,57,2,30029.19,NULL,'2023-11-21 17:44:19','2023-11-21 17:44:19',NULL),(2359,7812,670,40720,1557,3,217,1,7334.33,NULL,'2023-11-21 17:45:00','2023-11-21 17:45:00',NULL),(2360,7812,670,40720,1557,3,68,1,1540.21,NULL,'2023-11-21 17:45:00','2023-11-21 17:45:00',NULL),(2361,7812,670,40720,1557,3,221,1,830.35,NULL,'2023-11-21 17:45:00','2023-11-21 17:45:00',NULL),(2362,7812,670,40720,1557,3,57,2,9704.89,NULL,'2023-11-21 17:45:00','2023-11-21 17:45:00',NULL),(2363,7812,671,40720,1557,3,217,1,23420.60,NULL,'2023-11-21 17:45:46','2023-11-21 17:45:46',NULL),(2364,7812,671,40720,1557,3,68,1,4918.33,NULL,'2023-11-21 17:45:46','2023-11-21 17:45:46',NULL),(2365,7812,671,40720,1557,3,221,1,1633.56,NULL,'2023-11-21 17:45:46','2023-11-21 17:45:46',NULL),(2366,7812,671,40720,1557,3,57,2,29972.49,NULL,'2023-11-21 17:45:46','2023-11-21 17:45:46',NULL),(2367,7812,672,40720,1557,3,217,1,3847.29,NULL,'2023-11-21 17:47:26','2023-11-21 17:47:26',NULL),(2368,7812,672,40720,1557,3,68,1,807.93,NULL,'2023-11-21 17:47:26','2023-11-21 17:47:26',NULL),(2369,7812,672,40720,1557,3,221,1,344.78,NULL,'2023-11-21 17:47:26','2023-11-21 17:47:26',NULL),(2370,7812,672,40720,1557,3,57,2,5000.00,NULL,'2023-11-21 17:47:26','2023-11-21 17:47:26',NULL),(2371,7812,673,40720,1557,3,217,1,31274.43,NULL,'2023-11-21 17:48:15','2023-11-21 17:48:15',NULL),(2372,7812,673,40720,1557,3,68,1,6567.63,NULL,'2023-11-21 17:48:15','2023-11-21 17:48:15',NULL),(2373,7812,673,40720,1557,3,221,1,2205.15,NULL,'2023-11-21 17:48:15','2023-11-21 17:48:15',NULL),(2374,7812,673,40720,1557,3,57,2,40047.21,NULL,'2023-11-21 17:48:15','2023-11-21 17:48:15',NULL),(2375,7812,674,40720,1557,3,217,1,23428.17,NULL,'2023-11-21 17:48:55','2023-11-21 17:48:55',NULL),(2376,7812,674,40720,1557,3,68,1,4919.92,NULL,'2023-11-21 17:48:55','2023-11-21 17:48:55',NULL),(2377,7812,674,40720,1557,3,221,1,1651.91,NULL,'2023-11-21 17:48:55','2023-11-21 17:48:55',NULL),(2378,7812,674,40720,1557,3,57,2,30000.00,NULL,'2023-11-21 17:48:55','2023-11-21 17:48:55',NULL),(2379,7812,675,40720,1557,3,217,1,46856.34,NULL,'2023-11-21 17:49:30','2023-11-21 17:49:30',NULL);
INSERT INTO `balance_libro_details` VALUES (2380,7812,675,40720,1557,3,68,1,9839.83,NULL,'2023-11-21 17:49:30','2023-11-21 17:49:30',NULL),(2381,7812,675,40720,1557,3,221,1,3303.82,NULL,'2023-11-21 17:49:30','2023-11-21 17:49:30',NULL),(2382,7812,675,40720,1557,3,57,2,59999.99,NULL,'2023-11-21 17:49:30','2023-11-21 17:49:30',NULL),(2383,7812,676,40720,1557,3,217,1,24991.29,NULL,'2023-11-21 17:50:00','2023-11-21 17:50:00',NULL),(2384,7812,676,40720,1557,3,68,1,5248.17,NULL,'2023-11-21 17:50:00','2023-11-21 17:50:00',NULL),(2385,7812,676,40720,1557,3,221,1,1762.13,NULL,'2023-11-21 17:50:00','2023-11-21 17:50:00',NULL),(2386,7812,676,40720,1557,3,57,2,32001.59,NULL,'2023-11-21 17:50:00','2023-11-21 17:50:00',NULL),(2387,7812,677,40720,1557,3,217,1,7603.31,NULL,'2023-11-21 17:52:03','2023-11-21 17:52:03',NULL),(2388,7812,677,40720,1557,3,68,1,1596.70,NULL,'2023-11-21 17:52:03','2023-11-21 17:52:03',NULL),(2389,7812,677,40720,1557,3,57,2,9200.01,NULL,'2023-11-21 17:52:03','2023-11-21 17:52:03',NULL),(2390,7812,678,40720,1557,3,217,1,57851.24,NULL,'2023-11-21 17:53:03','2023-11-21 17:53:03',NULL),(2391,7812,678,40720,1557,3,68,1,12148.76,NULL,'2023-11-21 17:53:03','2023-11-21 17:53:03',NULL),(2392,7812,678,40720,1557,3,57,2,70000.00,NULL,'2023-11-21 17:53:03','2023-11-21 17:53:03',NULL),(2393,7812,679,40720,1557,3,217,1,29628.10,NULL,'2023-11-21 17:53:51','2023-11-21 17:53:51',NULL),(2394,7812,679,40720,1557,3,68,1,6221.90,NULL,'2023-11-21 17:53:51','2023-11-21 17:53:51',NULL),(2395,7812,679,40720,1557,3,57,2,35850.00,NULL,'2023-11-21 17:53:51','2023-11-21 17:53:51',NULL),(2396,7812,680,40720,1557,3,217,1,24223.51,NULL,'2023-11-21 17:54:53','2023-11-21 17:54:53',NULL),(2397,7812,680,40720,1557,3,68,1,5086.94,NULL,'2023-11-21 17:54:53','2023-11-21 17:54:53',NULL),(2398,7812,680,40720,1557,3,221,1,1689.57,NULL,'2023-11-21 17:54:53','2023-11-21 17:54:53',NULL),(2399,7812,680,40720,1557,3,57,2,31000.02,NULL,'2023-11-21 17:54:53','2023-11-21 17:54:53',NULL),(2400,7812,681,40720,1557,3,217,1,46697.17,NULL,'2023-11-21 17:55:30','2023-11-21 17:55:30',NULL),(2401,7812,681,40720,1557,3,68,1,9806.41,NULL,'2023-11-21 17:55:30','2023-11-21 17:55:30',NULL),(2402,7812,681,40720,1557,3,221,1,3496.43,NULL,'2023-11-21 17:55:30','2023-11-21 17:55:30',NULL),(2403,7812,681,40720,1557,3,57,2,60000.01,NULL,'2023-11-21 17:55:30','2023-11-21 17:55:30',NULL),(2404,7812,682,40720,1557,3,217,1,32879.10,NULL,'2023-11-21 17:56:09','2023-11-21 17:56:09',NULL),(2405,7812,682,40720,1557,3,68,1,6904.61,NULL,'2023-11-21 17:56:09','2023-11-21 17:56:09',NULL),(2406,7812,682,40720,1557,3,221,1,2218.40,NULL,'2023-11-21 17:56:09','2023-11-21 17:56:09',NULL),(2407,7812,682,40720,1557,3,57,2,42002.11,NULL,'2023-11-21 17:56:09','2023-11-21 17:56:09',NULL),(2408,7812,683,40720,1557,3,217,1,5141.26,NULL,'2023-11-21 17:56:42','2023-11-21 17:56:42',NULL),(2409,7812,683,40720,1557,3,68,1,1079.66,NULL,'2023-11-21 17:56:42','2023-11-21 17:56:42',NULL),(2410,7812,683,40720,1557,3,221,1,582.07,NULL,'2023-11-21 17:56:42','2023-11-21 17:56:42',NULL),(2411,7812,683,40720,1557,3,57,2,6802.99,NULL,'2023-11-21 17:56:42','2023-11-21 17:56:42',NULL),(2412,7812,684,40720,1557,15,67,1,385560.00,NULL,'2023-11-22 07:56:25','2023-11-22 07:56:25',NULL),(2413,7812,684,40720,1557,15,68,2,342504.80,NULL,'2023-11-22 07:56:25','2023-11-22 07:56:25',NULL),(2414,7812,684,40720,1557,15,353,2,64385.34,NULL,'2023-11-22 07:56:25','2023-11-22 07:56:25',NULL),(2415,7812,684,40720,1557,15,353,1,21330.14,NULL,'2023-11-22 07:56:25','2023-11-22 07:56:25',NULL),(2416,7812,685,40825,4557,3,217,1,65574.99,NULL,'2023-12-14 17:45:33','2023-12-14 18:42:52','2023-12-14 18:42:52'),(2417,7812,685,40825,4557,3,68,1,13770.75,NULL,'2023-12-14 17:45:33','2023-12-14 18:42:52','2023-12-14 18:42:52'),(2418,7812,685,40825,4557,3,221,1,3826.86,NULL,'2023-12-14 17:45:33','2023-12-14 18:42:52','2023-12-14 18:42:52'),(2419,7812,685,40825,4557,3,57,2,83172.60,NULL,'2023-12-14 17:45:33','2023-12-14 18:42:52','2023-12-14 18:42:52');
INSERT INTO `balance_libro_details` VALUES (2420,7812,686,40825,4557,3,217,1,77659.42,NULL,'2023-12-14 17:46:37','2023-12-14 18:42:40','2023-12-14 18:42:40'),(2421,7812,686,40825,4557,3,68,1,16308.48,NULL,'2023-12-14 17:46:37','2023-12-14 18:42:40','2023-12-14 18:42:40'),(2422,7812,686,40825,4557,3,221,1,4532.10,NULL,'2023-12-14 17:46:37','2023-12-14 18:42:40','2023-12-14 18:42:40'),(2423,7812,686,40825,4557,3,57,2,98500.00,NULL,'2023-12-14 17:46:37','2023-12-14 18:42:40','2023-12-14 18:42:40'),(2424,7812,687,40825,4557,3,217,1,119841.29,NULL,'2023-12-14 17:52:14','2023-12-14 18:42:29','2023-12-14 18:42:29'),(2425,7812,687,40825,4557,3,68,1,25166.67,NULL,'2023-12-14 17:52:14','2023-12-14 18:42:29','2023-12-14 18:42:29'),(2426,7812,687,40825,4557,3,221,1,6993.76,NULL,'2023-12-14 17:52:14','2023-12-14 18:42:29','2023-12-14 18:42:29'),(2427,7812,687,40825,4557,3,57,2,152001.72,NULL,'2023-12-14 17:52:14','2023-12-14 18:42:29','2023-12-14 18:42:29'),(2428,7812,688,40825,4557,3,217,1,68387.76,NULL,'2023-12-14 17:52:53','2023-12-14 18:42:17','2023-12-14 18:42:17'),(2429,7812,688,40825,4557,3,68,1,14361.43,NULL,'2023-12-14 17:52:53','2023-12-14 18:42:17','2023-12-14 18:42:17'),(2430,7812,688,40825,4557,3,221,1,3991.01,NULL,'2023-12-14 17:52:53','2023-12-14 18:42:17','2023-12-14 18:42:17'),(2431,7812,688,40825,4557,3,57,2,86740.20,NULL,'2023-12-14 17:52:53','2023-12-14 18:42:17','2023-12-14 18:42:17'),(2432,7812,689,40825,4557,3,217,1,77879.69,NULL,'2023-12-14 17:56:28','2023-12-14 18:42:06','2023-12-14 18:42:06'),(2433,7812,689,40825,4557,3,68,1,16354.73,NULL,'2023-12-14 17:56:28','2023-12-14 18:42:06','2023-12-14 18:42:06'),(2434,7812,689,40825,4557,3,221,1,4765.57,NULL,'2023-12-14 17:56:28','2023-12-14 18:42:06','2023-12-14 18:42:06'),(2435,7812,689,40825,4557,3,57,2,98999.99,NULL,'2023-12-14 17:56:28','2023-12-14 18:42:06','2023-12-14 18:42:06'),(2436,7812,690,40825,4557,3,217,1,77879.69,NULL,'2023-12-14 17:58:46','2023-12-14 18:41:39','2023-12-14 18:41:39'),(2437,7812,690,40825,4557,3,68,1,16354.73,NULL,'2023-12-14 17:58:46','2023-12-14 18:41:39','2023-12-14 18:41:39'),(2438,7812,690,40825,4557,3,221,1,4765.57,NULL,'2023-12-14 17:58:46','2023-12-14 18:41:39','2023-12-14 18:41:39'),(2439,7812,690,40825,4557,3,57,2,98999.99,NULL,'2023-12-14 17:58:46','2023-12-14 18:41:39','2023-12-14 18:41:39'),(2440,7812,691,40825,4557,2,96,2,270000.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:45:20','2023-12-14 18:45:20'),(2441,7812,691,40825,4557,2,67,2,56700.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:45:20','2023-12-14 18:45:20'),(2442,7812,691,40825,4557,2,13,1,326700.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:45:20','2023-12-14 18:45:20'),(2443,7812,692,40825,4557,2,96,2,270000.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:45:08','2023-12-14 18:45:08'),(2444,7812,692,40825,4557,2,67,2,56700.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:45:08','2023-12-14 18:45:08'),(2445,7812,692,40825,4557,2,13,1,326700.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:45:08','2023-12-14 18:45:08'),(2446,7812,693,40825,4557,2,96,2,270000.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:44:57','2023-12-14 18:44:57'),(2447,7812,693,40825,4557,2,67,2,56700.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:44:57','2023-12-14 18:44:57'),(2448,7812,693,40825,4557,2,13,1,326700.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:44:57','2023-12-14 18:44:57'),(2449,7812,694,40825,4557,2,96,2,575460.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:44:45','2023-12-14 18:44:45'),(2450,7812,694,40825,4557,2,67,2,120846.60,NULL,'2023-12-14 18:00:05','2023-12-14 18:44:45','2023-12-14 18:44:45'),(2451,7812,694,40825,4557,2,13,1,696306.60,NULL,'2023-12-14 18:00:05','2023-12-14 18:44:45','2023-12-14 18:44:45'),(2452,7812,695,40825,4557,2,96,1,270000.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:44:35','2023-12-14 18:44:35'),(2453,7812,695,40825,4557,2,68,1,56700.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:44:35','2023-12-14 18:44:35'),(2454,7812,695,40825,4557,2,13,2,326700.00,NULL,'2023-12-14 18:00:05','2023-12-14 18:44:35','2023-12-14 18:44:35');
INSERT INTO `balance_libro_details` VALUES (2455,7812,696,40825,4557,2,96,2,261000.00,NULL,'2023-12-14 18:00:06','2023-12-14 18:44:24','2023-12-14 18:44:24'),(2456,7812,696,40825,4557,2,67,2,54810.00,NULL,'2023-12-14 18:00:06','2023-12-14 18:44:24','2023-12-14 18:44:24'),(2457,7812,696,40825,4557,2,13,1,315810.00,NULL,'2023-12-14 18:00:06','2023-12-14 18:44:24','2023-12-14 18:44:24'),(2458,7812,697,40825,4557,2,96,2,483300.00,NULL,'2023-12-14 18:00:06','2023-12-14 18:44:13','2023-12-14 18:44:13'),(2459,7812,697,40825,4557,2,67,2,101493.00,NULL,'2023-12-14 18:00:06','2023-12-14 18:44:13','2023-12-14 18:44:13'),(2460,7812,697,40825,4557,2,13,1,584793.00,NULL,'2023-12-14 18:00:06','2023-12-14 18:44:13','2023-12-14 18:44:13'),(2461,7812,698,40825,4557,2,96,2,575460.00,NULL,'2023-12-14 18:00:06','2023-12-14 18:44:01','2023-12-14 18:44:01'),(2462,7812,698,40825,4557,2,67,2,120846.60,NULL,'2023-12-14 18:00:06','2023-12-14 18:44:01','2023-12-14 18:44:01'),(2463,7812,698,40825,4557,2,13,1,696306.60,NULL,'2023-12-14 18:00:06','2023-12-14 18:44:01','2023-12-14 18:44:01'),(2464,7812,699,40825,4557,7,25,1,56700.00,NULL,'2023-12-14 18:13:24','2023-12-14 18:13:24',NULL),(2465,7812,699,40825,4557,7,13,2,56700.00,NULL,'2023-12-14 18:13:24','2023-12-14 18:13:24',NULL),(2466,7812,700,40825,4557,7,25,1,56700.00,NULL,'2023-12-14 18:14:11','2023-12-14 18:14:11',NULL),(2467,7812,700,40825,4557,7,13,2,56700.00,NULL,'2023-12-14 18:14:11','2023-12-14 18:14:11',NULL),(2468,7812,701,40825,4557,7,25,1,54810.00,NULL,'2023-12-14 18:14:49','2023-12-14 18:14:49',NULL),(2469,7812,701,40825,4557,7,13,2,54810.00,NULL,'2023-12-14 18:14:49','2023-12-14 18:14:49',NULL),(2470,7812,702,40825,4557,7,25,1,101493.00,NULL,'2023-12-14 18:15:26','2023-12-14 18:15:26',NULL),(2471,7812,702,40825,4557,7,13,2,101493.00,NULL,'2023-12-14 18:15:26','2023-12-14 18:15:26',NULL),(2472,7812,703,40825,4557,7,25,1,120846.60,NULL,'2023-12-14 18:16:01','2023-12-14 18:16:01',NULL),(2473,7812,703,40825,4557,7,13,2,120846.60,NULL,'2023-12-14 18:16:01','2023-12-14 18:16:01',NULL),(2474,7812,704,40825,4557,2,96,2,137185.66,NULL,'2023-12-14 18:36:58','2023-12-14 18:37:52','2023-12-14 18:37:52'),(2475,7812,704,40825,4557,2,67,2,28808.99,NULL,'2023-12-14 18:36:58','2023-12-14 18:37:52','2023-12-14 18:37:52'),(2476,7812,704,40825,4557,2,221,2,8005.95,NULL,'2023-12-14 18:36:58','2023-12-14 18:37:52','2023-12-14 18:37:52'),(2477,7812,704,40825,4557,2,13,1,174000.60,NULL,'2023-12-14 18:36:58','2023-12-14 18:37:52','2023-12-14 18:37:52'),(2478,7812,705,40825,4557,3,217,1,137185.66,NULL,'2023-12-14 18:41:10','2023-12-14 18:41:10',NULL),(2479,7812,705,40825,4557,3,68,1,28808.99,NULL,'2023-12-14 18:41:10','2023-12-14 18:41:10',NULL),(2480,7812,705,40825,4557,3,221,1,8005.96,NULL,'2023-12-14 18:41:10','2023-12-14 18:41:10',NULL),(2481,7812,705,40825,4557,3,57,2,174000.61,NULL,'2023-12-14 18:41:10','2023-12-14 18:41:10',NULL),(2482,7812,706,40825,4557,3,217,1,77879.69,NULL,'2023-12-14 18:41:39','2023-12-14 18:41:39',NULL),(2483,7812,706,40825,4557,3,68,1,16354.73,NULL,'2023-12-14 18:41:39','2023-12-14 18:41:39',NULL),(2484,7812,706,40825,4557,3,221,1,4765.57,NULL,'2023-12-14 18:41:39','2023-12-14 18:41:39',NULL),(2485,7812,706,40825,4557,3,57,2,98999.99,NULL,'2023-12-14 18:41:39','2023-12-14 18:41:39',NULL),(2486,7812,707,40825,4557,3,217,1,77879.69,NULL,'2023-12-14 18:42:06','2023-12-14 18:42:06',NULL),(2487,7812,707,40825,4557,3,68,1,16354.73,NULL,'2023-12-14 18:42:06','2023-12-14 18:42:06',NULL),(2488,7812,707,40825,4557,3,221,1,4765.57,NULL,'2023-12-14 18:42:06','2023-12-14 18:42:06',NULL),(2489,7812,707,40825,4557,3,57,2,98999.99,NULL,'2023-12-14 18:42:06','2023-12-14 18:42:06',NULL),(2490,7812,708,40825,4557,3,217,1,68387.76,NULL,'2023-12-14 18:42:17','2023-12-14 18:42:17',NULL),(2491,7812,708,40825,4557,3,68,1,14361.43,NULL,'2023-12-14 18:42:17','2023-12-14 18:42:17',NULL),(2492,7812,708,40825,4557,3,221,1,3991.01,NULL,'2023-12-14 18:42:17','2023-12-14 18:42:17',NULL);
INSERT INTO `balance_libro_details` VALUES (2493,7812,708,40825,4557,3,57,2,86740.20,NULL,'2023-12-14 18:42:17','2023-12-14 18:42:17',NULL),(2494,7812,709,40825,4557,3,217,1,119841.29,NULL,'2023-12-14 18:42:29','2023-12-14 18:42:29',NULL),(2495,7812,709,40825,4557,3,68,1,25166.67,NULL,'2023-12-14 18:42:29','2023-12-14 18:42:29',NULL),(2496,7812,709,40825,4557,3,221,1,6993.76,NULL,'2023-12-14 18:42:29','2023-12-14 18:42:29',NULL),(2497,7812,709,40825,4557,3,57,2,152001.72,NULL,'2023-12-14 18:42:29','2023-12-14 18:42:29',NULL),(2498,7812,710,40825,4557,3,217,1,77659.42,NULL,'2023-12-14 18:42:40','2023-12-14 18:42:40',NULL),(2499,7812,710,40825,4557,3,68,1,16308.48,NULL,'2023-12-14 18:42:40','2023-12-14 18:42:40',NULL),(2500,7812,710,40825,4557,3,221,1,4532.10,NULL,'2023-12-14 18:42:40','2023-12-14 18:42:40',NULL),(2501,7812,710,40825,4557,3,57,2,98500.00,NULL,'2023-12-14 18:42:40','2023-12-14 18:42:40',NULL),(2502,7812,711,40825,4557,3,217,1,65574.99,NULL,'2023-12-14 18:42:52','2023-12-14 18:42:52',NULL),(2503,7812,711,40825,4557,3,68,1,13770.75,NULL,'2023-12-14 18:42:52','2023-12-14 18:42:52',NULL),(2504,7812,711,40825,4557,3,221,1,3826.86,NULL,'2023-12-14 18:42:52','2023-12-14 18:42:52',NULL),(2505,7812,711,40825,4557,3,57,2,83172.60,NULL,'2023-12-14 18:42:52','2023-12-14 18:42:52',NULL),(2506,7812,712,40825,4557,2,96,2,575460.00,NULL,'2023-12-14 18:44:01','2023-12-14 18:44:01',NULL),(2507,7812,712,40825,4557,2,67,2,120846.60,NULL,'2023-12-14 18:44:01','2023-12-14 18:44:01',NULL),(2508,7812,712,40825,4557,2,13,1,696306.60,NULL,'2023-12-14 18:44:01','2023-12-14 18:44:01',NULL),(2509,7812,713,40825,4557,2,96,2,483300.00,NULL,'2023-12-14 18:44:13','2023-12-14 18:44:13',NULL),(2510,7812,713,40825,4557,2,67,2,101493.00,NULL,'2023-12-14 18:44:13','2023-12-14 18:44:13',NULL),(2511,7812,713,40825,4557,2,13,1,584793.00,NULL,'2023-12-14 18:44:13','2023-12-14 18:44:13',NULL),(2512,7812,714,40825,4557,2,96,2,261000.00,NULL,'2023-12-14 18:44:24','2023-12-14 18:44:24',NULL),(2513,7812,714,40825,4557,2,67,2,54810.00,NULL,'2023-12-14 18:44:24','2023-12-14 18:44:24',NULL),(2514,7812,714,40825,4557,2,13,1,315810.00,NULL,'2023-12-14 18:44:24','2023-12-14 18:44:24',NULL),(2515,7812,715,40825,4557,2,96,1,270000.00,NULL,'2023-12-14 18:44:35','2023-12-14 18:44:35',NULL),(2516,7812,715,40825,4557,2,68,1,56700.00,NULL,'2023-12-14 18:44:35','2023-12-14 18:44:35',NULL),(2517,7812,715,40825,4557,2,13,2,326700.00,NULL,'2023-12-14 18:44:35','2023-12-14 18:44:35',NULL),(2518,7812,716,40825,4557,2,96,2,575460.00,NULL,'2023-12-14 18:44:45','2023-12-14 18:44:45',NULL),(2519,7812,716,40825,4557,2,67,2,120846.60,NULL,'2023-12-14 18:44:45','2023-12-14 18:44:45',NULL),(2520,7812,716,40825,4557,2,13,1,696306.60,NULL,'2023-12-14 18:44:45','2023-12-14 18:44:45',NULL),(2521,7812,717,40825,4557,2,96,2,270000.00,NULL,'2023-12-14 18:44:57','2023-12-14 18:44:57',NULL),(2522,7812,717,40825,4557,2,67,2,56700.00,NULL,'2023-12-14 18:44:57','2023-12-14 18:44:57',NULL),(2523,7812,717,40825,4557,2,13,1,326700.00,NULL,'2023-12-14 18:44:57','2023-12-14 18:44:57',NULL),(2524,7812,718,40825,4557,2,96,2,270000.00,NULL,'2023-12-14 18:45:08','2023-12-14 18:45:08',NULL),(2525,7812,718,40825,4557,2,67,2,56700.00,NULL,'2023-12-14 18:45:08','2023-12-14 18:45:08',NULL),(2526,7812,718,40825,4557,2,13,1,326700.00,NULL,'2023-12-14 18:45:08','2023-12-14 18:45:08',NULL),(2527,7812,719,40825,4557,2,96,2,270000.00,NULL,'2023-12-14 18:45:20','2023-12-14 18:45:20',NULL),(2528,7812,719,40825,4557,2,67,2,56700.00,NULL,'2023-12-14 18:45:20','2023-12-14 18:45:20',NULL),(2529,7812,719,40825,4557,2,13,1,326700.00,NULL,'2023-12-14 18:45:20','2023-12-14 18:45:20',NULL),(2530,7812,720,40825,4557,15,67,1,568096.20,NULL,'2023-12-18 19:29:59','2023-12-18 19:29:59',NULL),(2531,7812,720,40825,4557,15,68,2,187825.79,NULL,'2023-12-18 19:29:59','2023-12-18 19:29:59',NULL),(2532,7812,720,40825,4557,15,25,2,390549.60,NULL,'2023-12-18 19:29:59','2023-12-18 19:29:59',NULL);
INSERT INTO `balance_libro_details` VALUES (2533,7812,720,40825,4557,15,354,1,10279.19,NULL,'2023-12-18 19:29:59','2023-12-18 19:29:59',NULL),(2534,7812,721,40720,1558,2,96,2,270000.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2535,7812,721,40720,1558,2,67,2,56700.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2536,7812,721,40720,1558,2,13,1,326700.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2537,7812,722,40720,1558,2,96,2,92975.19,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2538,7812,722,40720,1558,2,67,2,19524.79,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2539,7812,722,40720,1558,2,218,2,0.02,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2540,7812,722,40720,1558,2,13,1,112500.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2541,7812,723,40720,1558,2,96,2,24793.38,NULL,'2023-12-18 19:36:00','2023-12-18 19:37:55','2023-12-18 19:37:55'),(2542,7812,723,40720,1558,2,67,2,5206.61,NULL,'2023-12-18 19:36:00','2023-12-18 19:37:55','2023-12-18 19:37:55'),(2543,7812,723,40720,1558,2,218,2,0.01,NULL,'2023-12-18 19:36:00','2023-12-18 19:37:55','2023-12-18 19:37:55'),(2544,7812,723,40720,1558,2,13,1,30000.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:37:55','2023-12-18 19:37:55'),(2545,7812,724,40720,1558,2,96,2,306000.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2546,7812,724,40720,1558,2,67,2,64260.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2547,7812,724,40720,1558,2,13,1,370260.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2548,7812,725,40720,1558,2,96,2,270000.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2549,7812,725,40720,1558,2,67,2,56700.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2550,7812,725,40720,1558,2,13,1,326700.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2551,7812,726,40720,1558,2,96,2,270000.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2552,7812,726,40720,1558,2,67,2,56700.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2553,7812,726,40720,1558,2,13,1,326700.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2554,7812,727,40720,1558,2,96,2,437904.00,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2555,7812,727,40720,1558,2,67,2,91959.84,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2556,7812,727,40720,1558,2,13,1,529863.84,NULL,'2023-12-18 19:36:00','2023-12-18 19:36:00',NULL),(2557,7812,728,40720,1558,3,250,1,0.00,NULL,'2023-12-18 19:36:18','2023-12-18 19:40:00','2023-12-18 19:40:00'),(2558,7812,728,40720,1558,3,250,1,275761.25,NULL,'2023-12-18 19:36:18','2023-12-18 19:40:00','2023-12-18 19:40:00'),(2559,7812,728,40720,1558,3,57,2,275761.25,NULL,'2023-12-18 19:36:18','2023-12-18 19:40:00','2023-12-18 19:40:00'),(2560,7812,729,40720,1558,3,250,1,0.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:49','2023-12-18 19:39:49'),(2561,7812,729,40720,1558,3,250,1,285000.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:49','2023-12-18 19:39:49'),(2562,7812,729,40720,1558,3,57,2,285000.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:49','2023-12-18 19:39:49'),(2563,7812,730,40720,1558,3,250,1,0.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:01','2023-12-18 19:39:01'),(2564,7812,730,40720,1558,3,250,1,151920.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:01','2023-12-18 19:39:01'),(2565,7812,730,40720,1558,3,57,2,151920.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:01','2023-12-18 19:39:01'),(2566,7812,731,40720,1558,3,217,1,41322.31,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2567,7812,731,40720,1558,3,68,1,8677.69,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2568,7812,731,40720,1558,3,57,2,50000.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2569,7812,732,40720,1558,3,250,1,0.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:38','2023-12-18 19:39:38'),(2570,7812,732,40720,1558,3,250,1,201020.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:38','2023-12-18 19:39:38');
INSERT INTO `balance_libro_details` VALUES (2571,7812,732,40720,1558,3,57,2,201020.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:38','2023-12-18 19:39:38'),(2572,7812,733,40720,1558,3,217,1,40495.87,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2573,7812,733,40720,1558,3,68,1,8504.13,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2574,7812,733,40720,1558,3,57,2,49000.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2575,7812,734,40720,1558,3,217,1,36363.64,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2576,7812,734,40720,1558,3,68,1,7636.36,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2577,7812,734,40720,1558,3,57,2,44000.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2578,7812,735,40720,1558,3,250,1,0.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:27','2023-12-18 19:39:27'),(2579,7812,735,40720,1558,3,250,1,287640.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:27','2023-12-18 19:39:27'),(2580,7812,735,40720,1558,3,57,2,287640.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:27','2023-12-18 19:39:27'),(2581,7812,736,40720,1558,3,250,1,0.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:16','2023-12-18 19:39:16'),(2582,7812,736,40720,1558,3,250,1,215910.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:16','2023-12-18 19:39:16'),(2583,7812,736,40720,1558,3,57,2,215910.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:39:16','2023-12-18 19:39:16'),(2584,7812,737,40720,1558,3,217,1,24506.61,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2585,7812,737,40720,1558,3,68,1,5146.39,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2586,7812,737,40720,1558,3,57,2,29653.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2587,7812,738,40720,1558,3,217,1,550412.48,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2588,7812,738,40720,1558,3,68,1,115586.62,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2589,7812,738,40720,1558,3,57,2,665999.10,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2590,7812,739,40720,1558,3,217,1,20661.14,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2591,7812,739,40720,1558,3,68,1,4338.84,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2592,7812,739,40720,1558,3,217,1,0.02,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2593,7812,739,40720,1558,3,57,2,25000.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2594,7812,740,40720,1558,3,217,1,8925.62,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2595,7812,740,40720,1558,3,68,1,1874.38,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2596,7812,740,40720,1558,3,57,2,10800.00,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2597,7812,741,40720,1558,3,217,1,45605.98,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2598,7812,741,40720,1558,3,68,1,9577.25,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2599,7812,741,40720,1558,3,57,2,55183.23,NULL,'2023-12-18 19:36:19','2023-12-18 19:36:19',NULL),(2600,7812,742,40720,1558,2,96,2,24793.38,NULL,'2023-12-18 19:37:55','2023-12-18 19:37:55',NULL),(2601,7812,742,40720,1558,2,67,2,5206.61,NULL,'2023-12-18 19:37:55','2023-12-18 19:37:55',NULL),(2602,7812,742,40720,1558,2,218,2,0.01,NULL,'2023-12-18 19:37:55','2023-12-18 19:37:55',NULL),(2603,7812,742,40720,1558,2,13,1,30000.00,NULL,'2023-12-18 19:37:55','2023-12-18 19:37:55',NULL),(2604,7812,743,40720,1558,3,217,1,15520.58,NULL,'2023-12-19 18:42:34','2023-12-19 18:42:34',NULL),(2605,7812,743,40720,1558,3,68,1,3259.32,NULL,'2023-12-19 18:42:34','2023-12-19 18:42:34',NULL),(2606,7812,743,40720,1558,3,221,1,1220.14,NULL,'2023-12-19 18:42:34','2023-12-19 18:42:34',NULL),(2607,7812,743,40720,1558,3,57,2,20000.04,NULL,'2023-12-19 18:42:34','2023-12-19 18:42:34',NULL),(2608,7812,744,40720,1558,3,217,1,23679.22,NULL,'2023-12-19 18:43:20','2023-12-19 18:43:20',NULL),(2609,7812,744,40720,1558,3,68,1,4972.64,NULL,'2023-12-19 18:43:20','2023-12-19 18:43:20',NULL),(2610,7812,744,40720,1558,3,221,1,2350.97,NULL,'2023-12-19 18:43:20','2023-12-19 18:43:20',NULL);
INSERT INTO `balance_libro_details` VALUES (2611,7812,744,40720,1558,3,57,2,31002.83,NULL,'2023-12-19 18:43:20','2023-12-19 18:43:20',NULL),(2612,7812,745,40720,1558,3,217,1,18704.00,NULL,'2023-12-19 18:44:01','2023-12-19 18:44:01',NULL),(2613,7812,745,40720,1558,3,68,1,3927.84,NULL,'2023-12-19 18:44:01','2023-12-19 18:44:01',NULL),(2614,7812,745,40720,1558,3,221,1,1482.83,NULL,'2023-12-19 18:44:01','2023-12-19 18:44:01',NULL),(2615,7812,745,40720,1558,3,57,2,24114.67,NULL,'2023-12-19 18:44:01','2023-12-19 18:44:01',NULL),(2616,7812,746,40720,1558,3,217,1,23833.46,NULL,'2023-12-19 18:46:14','2023-12-19 18:46:14',NULL),(2617,7812,746,40720,1558,3,68,1,5005.03,NULL,'2023-12-19 18:46:14','2023-12-19 18:46:14',NULL),(2618,7812,746,40720,1558,3,221,1,1161.53,NULL,'2023-12-19 18:46:14','2023-12-19 18:46:14',NULL),(2619,7812,746,40720,1558,3,57,2,30000.02,NULL,'2023-12-19 18:46:14','2023-12-19 18:46:14',NULL),(2620,7812,747,40720,1558,3,217,1,118264.07,NULL,'2023-12-19 18:47:59','2023-12-19 18:47:59',NULL),(2621,7812,747,40720,1558,3,68,1,24835.45,NULL,'2023-12-19 18:47:59','2023-12-19 18:47:59',NULL),(2622,7812,747,40720,1558,3,221,1,6901.68,NULL,'2023-12-19 18:47:59','2023-12-19 18:47:59',NULL),(2623,7812,747,40720,1558,3,57,2,150001.20,NULL,'2023-12-19 18:47:59','2023-12-19 18:47:59',NULL),(2624,7812,748,40720,1558,3,217,1,25320.36,NULL,'2023-12-19 18:49:35','2023-12-19 18:50:52','2023-12-19 18:50:52'),(2625,7812,748,40720,1558,3,68,1,5317.28,NULL,'2023-12-19 18:49:35','2023-12-19 18:50:52','2023-12-19 18:50:52'),(2626,7812,748,40720,1558,3,221,1,0.02,NULL,'2023-12-19 18:49:35','2023-12-19 18:50:52','2023-12-19 18:50:52'),(2627,7812,748,40720,1558,3,57,2,30637.66,NULL,'2023-12-19 18:49:35','2023-12-19 18:50:52','2023-12-19 18:50:52'),(2628,7812,749,40720,1558,3,217,1,25320.36,NULL,'2023-12-19 18:50:52','2023-12-19 18:50:52',NULL),(2629,7812,749,40720,1558,3,68,1,5317.28,NULL,'2023-12-19 18:50:52','2023-12-19 18:50:52',NULL),(2630,7812,749,40720,1558,3,221,1,1363.03,NULL,'2023-12-19 18:50:52','2023-12-19 18:50:52',NULL),(2631,7812,749,40720,1558,3,57,2,32000.67,NULL,'2023-12-19 18:50:52','2023-12-19 18:50:52',NULL),(2632,7812,750,40720,1558,3,217,1,119561.97,NULL,'2023-12-19 18:52:43','2023-12-19 18:52:43',NULL),(2633,7812,750,40720,1558,3,68,1,25108.01,NULL,'2023-12-19 18:52:43','2023-12-19 18:52:43',NULL),(2634,7812,750,40720,1558,3,221,1,7931.23,NULL,'2023-12-19 18:52:43','2023-12-19 18:52:43',NULL),(2635,7812,750,40720,1558,3,57,2,152601.21,NULL,'2023-12-19 18:52:43','2023-12-19 18:52:43',NULL),(2636,7812,751,40720,1558,3,217,1,78349.11,NULL,'2023-12-19 18:56:02','2023-12-19 18:56:02',NULL),(2637,7812,751,40720,1558,3,68,1,16453.31,NULL,'2023-12-19 18:56:02','2023-12-19 18:56:02',NULL),(2638,7812,751,40720,1558,3,221,1,5197.35,NULL,'2023-12-19 18:56:02','2023-12-19 18:56:02',NULL),(2639,7812,751,40720,1558,3,57,2,99999.77,NULL,'2023-12-19 18:56:02','2023-12-19 18:56:02',NULL),(2640,7812,752,40720,1558,3,217,1,86184.17,NULL,'2023-12-19 19:00:36','2023-12-19 19:00:36',NULL),(2641,7812,752,40720,1558,3,68,1,18098.68,NULL,'2023-12-19 19:00:36','2023-12-19 19:00:36',NULL),(2642,7812,752,40720,1558,3,221,1,5717.09,NULL,'2023-12-19 19:00:36','2023-12-19 19:00:36',NULL),(2643,7812,752,40720,1558,3,57,2,109999.94,NULL,'2023-12-19 19:00:36','2023-12-19 19:00:36',NULL),(2644,7812,753,40720,1558,3,217,1,109846.19,NULL,'2023-12-19 19:02:00','2023-12-19 19:02:00',NULL),(2645,7812,753,40720,1558,3,68,1,23067.70,NULL,'2023-12-19 19:02:00','2023-12-19 19:02:00',NULL),(2646,7812,753,40720,1558,3,221,1,7286.74,NULL,'2023-12-19 19:02:00','2023-12-19 19:02:00',NULL),(2647,7812,753,40720,1558,3,57,2,140200.63,NULL,'2023-12-19 19:02:00','2023-12-19 19:02:00',NULL),(2648,7812,754,40720,1558,3,217,1,54844.50,NULL,'2023-12-19 19:02:39','2023-12-19 19:02:39',NULL),(2649,7812,754,40720,1558,3,68,1,11517.35,NULL,'2023-12-19 19:02:39','2023-12-19 19:02:39',NULL),(2650,7812,754,40720,1558,3,221,1,3638.16,NULL,'2023-12-19 19:02:39','2023-12-19 19:02:39',NULL);
INSERT INTO `balance_libro_details` VALUES (2651,7812,754,40720,1558,3,57,2,70000.01,NULL,'2023-12-19 19:02:39','2023-12-19 19:02:39',NULL),(2652,7812,755,40720,1558,15,67,1,351051.24,NULL,'2023-12-19 20:35:50','2023-12-19 20:35:50',NULL),(2653,7812,755,40720,1558,15,68,2,302904.27,NULL,'2023-12-19 20:35:50','2023-12-19 20:35:50',NULL),(2654,7812,755,40720,1558,15,353,2,21330.14,NULL,'2023-12-19 20:35:50','2023-12-19 20:35:50',NULL),(2655,7812,755,40720,1558,15,74,2,26816.83,NULL,'2023-12-19 20:35:50','2023-12-19 20:35:50',NULL),(2656,7812,756,40825,4558,2,96,2,897318.00,NULL,'2024-01-18 18:33:19','2024-01-18 18:33:19',NULL),(2657,7812,756,40825,4558,2,67,2,188436.78,NULL,'2024-01-18 18:33:19','2024-01-18 18:33:19',NULL),(2658,7812,756,40825,4558,2,13,1,1085754.78,NULL,'2024-01-18 18:33:19','2024-01-18 18:33:19',NULL),(2659,7812,757,40825,4558,2,96,1,575460.00,NULL,'2024-01-18 18:33:19','2024-01-18 18:33:19',NULL),(2660,7812,757,40825,4558,2,68,1,120846.60,NULL,'2024-01-18 18:33:19','2024-01-18 18:33:19',NULL),(2661,7812,757,40825,4558,2,13,2,696306.60,NULL,'2024-01-18 18:33:19','2024-01-18 18:33:19',NULL),(2662,7812,758,40825,4558,3,217,1,479338.86,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2663,7812,758,40825,4558,3,68,1,100661.16,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2664,7812,758,40825,4558,3,217,1,-0.02,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2665,7812,758,40825,4558,3,57,2,580000.00,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2666,7812,759,40825,4558,3,217,1,51330.75,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2667,7812,759,40825,4558,3,68,1,10779.46,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2668,7812,759,40825,4558,3,217,1,1394.79,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2669,7812,759,40825,4558,3,57,2,63505.00,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2670,7812,760,40825,4558,3,250,1,0.00,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2671,7812,760,40825,4558,3,250,1,65900.00,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2672,7812,760,40825,4558,3,57,2,65900.00,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2673,7812,761,40825,4558,3,217,1,30169.58,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2674,7812,761,40825,4558,3,68,1,6335.61,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2675,7812,761,40825,4558,3,217,1,994.84,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2676,7812,761,40825,4558,3,57,2,37500.03,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2677,7812,762,40825,4558,3,217,1,54481.52,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2678,7812,762,40825,4558,3,68,1,11441.12,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2679,7812,762,40825,4558,3,57,2,65922.64,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2680,7812,763,40825,4558,3,217,1,64361.72,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2681,7812,763,40825,4558,3,68,1,13515.96,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2682,7812,763,40825,4558,3,217,1,2122.31,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2683,7812,763,40825,4558,3,57,2,79999.99,NULL,'2024-01-18 18:33:35','2024-01-18 18:33:35',NULL),(2684,7812,764,40825,4558,7,25,1,188436.78,NULL,'2024-01-18 18:46:09','2024-01-18 18:46:09',NULL),(2685,7812,764,40825,4558,7,13,2,188436.78,NULL,'2024-01-18 18:46:09','2024-01-18 18:46:09',NULL),(2686,7812,765,40720,1559,2,96,2,306540.00,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2687,7812,765,40720,1559,2,67,2,64373.40,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2688,7812,765,40720,1559,2,13,1,370913.40,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2689,7812,766,40720,1559,2,96,2,306000.00,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2690,7812,766,40720,1559,2,67,2,64260.00,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2691,7812,766,40720,1559,2,13,1,370260.00,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL);
INSERT INTO `balance_libro_details` VALUES (2692,7812,767,40720,1559,2,96,2,304110.00,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2693,7812,767,40720,1559,2,67,2,63863.10,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2694,7812,767,40720,1559,2,13,1,367973.10,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2695,7812,768,40720,1559,2,96,2,306000.00,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2696,7812,768,40720,1559,2,67,2,64260.00,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2697,7812,768,40720,1559,2,13,1,370260.00,NULL,'2024-01-22 18:46:50','2024-01-22 18:46:50',NULL),(2698,7812,769,40720,1559,3,217,1,52892.57,NULL,'2024-01-22 18:47:03','2024-02-11 11:21:03','2024-02-11 11:21:03'),(2699,7812,769,40720,1559,3,68,1,11107.44,NULL,'2024-01-22 18:47:03','2024-02-11 11:21:03','2024-02-11 11:21:03'),(2700,7812,769,40720,1559,3,217,1,-0.01,NULL,'2024-01-22 18:47:03','2024-02-11 11:21:03','2024-02-11 11:21:03'),(2701,7812,769,40720,1559,3,57,2,64000.00,NULL,'2024-01-22 18:47:03','2024-02-11 11:21:03','2024-02-11 11:21:03'),(2702,7812,770,40720,1559,3,217,1,20717.85,NULL,'2024-01-22 18:47:03','2024-01-22 18:47:03',NULL),(2703,7812,770,40720,1559,3,68,1,4350.75,NULL,'2024-01-22 18:47:03','2024-01-22 18:47:03',NULL),(2704,7812,770,40720,1559,3,57,2,25068.60,NULL,'2024-01-22 18:47:03','2024-01-22 18:47:03',NULL),(2705,7812,771,40720,1559,2,96,2,53132.43,NULL,'2024-01-26 18:18:23','2024-02-11 11:26:14','2024-02-11 11:26:14'),(2706,7812,771,40720,1559,2,67,2,11157.81,NULL,'2024-01-26 18:18:23','2024-02-11 11:26:14','2024-02-11 11:26:14'),(2707,7812,771,40720,1559,2,221,2,3509.76,NULL,'2024-01-26 18:18:23','2024-02-11 11:26:14','2024-02-11 11:26:14'),(2708,7812,771,40720,1559,2,13,1,67800.00,NULL,'2024-01-26 18:18:23','2024-02-11 11:26:14','2024-02-11 11:26:14'),(2709,7812,772,40720,1559,2,96,2,38335.10,NULL,'2024-01-26 18:20:24','2024-02-11 11:26:06','2024-02-11 11:26:06'),(2710,7812,772,40720,1559,2,67,2,8050.37,NULL,'2024-01-26 18:20:24','2024-02-11 11:26:06','2024-02-11 11:26:06'),(2711,7812,772,40720,1559,2,221,2,2622.02,NULL,'2024-01-26 18:20:25','2024-02-11 11:26:06','2024-02-11 11:26:06'),(2712,7812,772,40720,1559,2,13,1,49007.49,NULL,'2024-01-26 18:20:25','2024-02-11 11:26:06','2024-02-11 11:26:06'),(2713,7812,773,40720,1559,2,96,2,43091.68,NULL,'2024-01-26 18:20:59','2024-02-11 11:25:59','2024-02-11 11:25:59'),(2714,7812,773,40720,1559,2,67,2,9049.25,NULL,'2024-01-26 18:20:59','2024-02-11 11:25:59','2024-02-11 11:25:59'),(2715,7812,773,40720,1559,2,221,2,2947.36,NULL,'2024-01-26 18:20:59','2024-02-11 11:25:59','2024-02-11 11:25:59'),(2716,7812,773,40720,1559,2,13,1,55088.29,NULL,'2024-01-26 18:20:59','2024-02-11 11:25:59','2024-02-11 11:25:59'),(2717,7812,774,40720,1559,3,217,1,39606.45,NULL,'2024-02-11 10:36:43','2024-02-11 10:36:43',NULL),(2718,7812,774,40720,1559,3,68,1,8317.35,NULL,'2024-02-11 10:36:43','2024-02-11 10:36:43',NULL),(2719,7812,774,40720,1559,3,221,1,2508.59,NULL,'2024-02-11 10:36:43','2024-02-11 10:36:43',NULL),(2720,7812,774,40720,1559,3,57,2,50432.39,NULL,'2024-02-11 10:36:43','2024-02-11 10:36:43',NULL),(2721,7812,775,40720,1559,3,217,1,11147.04,NULL,'2024-02-11 10:37:29','2024-02-11 10:37:29',NULL),(2722,7812,775,40720,1559,3,68,1,2340.88,NULL,'2024-02-11 10:37:29','2024-02-11 10:37:29',NULL),(2723,7812,775,40720,1559,3,221,1,1016.69,NULL,'2024-02-11 10:37:29','2024-02-11 10:37:29',NULL),(2724,7812,775,40720,1559,3,57,2,14504.61,NULL,'2024-02-11 10:37:29','2024-02-11 10:37:29',NULL),(2725,7812,776,40720,1559,3,217,1,31426.79,NULL,'2024-02-11 10:39:31','2024-02-11 10:39:31',NULL),(2726,7812,776,40720,1559,3,68,1,6599.63,NULL,'2024-02-11 10:39:31','2024-02-11 10:39:31',NULL),(2727,7812,776,40720,1559,3,221,1,1990.51,NULL,'2024-02-11 10:39:31','2024-02-11 10:39:31',NULL),(2728,7812,776,40720,1559,3,57,2,40016.93,NULL,'2024-02-11 10:39:31','2024-02-11 10:39:31',NULL),(2729,7812,777,40720,1559,3,217,1,105450.85,NULL,'2024-02-11 10:40:48','2024-02-11 10:40:48',NULL);
INSERT INTO `balance_libro_details` VALUES (2730,7812,777,40720,1559,3,68,1,22144.68,NULL,'2024-02-11 10:40:48','2024-02-11 10:40:48',NULL),(2731,7812,777,40720,1559,3,221,1,4811.47,NULL,'2024-02-11 10:40:48','2024-02-11 10:40:48',NULL),(2732,7812,777,40720,1559,3,57,2,132407.00,NULL,'2024-02-11 10:40:48','2024-02-11 10:40:48',NULL),(2733,7812,778,40720,1559,3,217,1,78200.59,NULL,'2024-02-11 10:41:35','2024-02-11 10:41:35',NULL),(2734,7812,778,40720,1559,3,68,1,16422.12,NULL,'2024-02-11 10:41:35','2024-02-11 10:41:35',NULL),(2735,7812,778,40720,1559,3,221,1,4377.27,NULL,'2024-02-11 10:41:35','2024-02-11 10:41:35',NULL),(2736,7812,778,40720,1559,3,57,2,98999.98,NULL,'2024-02-11 10:41:35','2024-02-11 10:41:35',NULL),(2737,7812,779,40720,1559,3,217,1,67016.85,NULL,'2024-02-11 10:43:26','2024-02-11 10:43:26',NULL),(2738,7812,779,40720,1559,3,68,1,14073.54,NULL,'2024-02-11 10:43:26','2024-02-11 10:43:26',NULL),(2739,7812,779,40720,1559,3,221,1,3911.01,NULL,'2024-02-11 10:43:26','2024-02-11 10:43:26',NULL),(2740,7812,779,40720,1559,3,57,2,85001.40,NULL,'2024-02-11 10:43:26','2024-02-11 10:43:26',NULL),(2741,7812,780,40720,1559,3,217,1,55974.96,NULL,'2024-02-11 10:44:10','2024-02-11 10:44:10',NULL),(2742,7812,780,40720,1559,3,68,1,11754.74,NULL,'2024-02-11 10:44:10','2024-02-11 10:44:10',NULL),(2743,7812,780,40720,1559,3,221,1,3266.62,NULL,'2024-02-11 10:44:10','2024-02-11 10:44:10',NULL),(2744,7812,780,40720,1559,3,57,2,70996.32,NULL,'2024-02-11 10:44:10','2024-02-11 10:44:10',NULL),(2745,7812,781,40720,1559,3,217,1,56766.28,NULL,'2024-02-11 10:45:21','2024-02-11 10:45:21',NULL),(2746,7812,781,40720,1559,3,68,1,11920.92,NULL,'2024-02-11 10:45:21','2024-02-11 10:45:21',NULL),(2747,7812,781,40720,1559,3,221,1,3312.80,NULL,'2024-02-11 10:45:21','2024-02-11 10:45:21',NULL),(2748,7812,781,40720,1559,3,57,2,72000.00,NULL,'2024-02-11 10:45:21','2024-02-11 10:45:21',NULL),(2749,7812,782,40720,1559,3,217,1,78471.78,NULL,'2024-02-11 10:47:18','2024-02-11 10:47:18',NULL),(2750,7812,782,40720,1559,3,68,1,16479.07,NULL,'2024-02-11 10:47:18','2024-02-11 10:47:18',NULL),(2751,7812,782,40720,1559,3,221,1,4048.97,NULL,'2024-02-11 10:47:18','2024-02-11 10:47:18',NULL),(2752,7812,782,40720,1559,3,57,2,98999.82,NULL,'2024-02-11 10:47:18','2024-02-11 10:47:18',NULL),(2753,7812,783,40720,1559,3,217,1,158279.55,NULL,'2024-02-11 10:49:07','2024-02-11 10:49:07',NULL),(2754,7812,783,40720,1559,3,68,1,33238.71,NULL,'2024-02-11 10:49:07','2024-02-11 10:49:07',NULL),(2755,7812,783,40720,1559,3,221,1,6481.56,NULL,'2024-02-11 10:49:07','2024-02-11 10:49:07',NULL),(2756,7812,783,40720,1559,3,57,2,197999.82,NULL,'2024-02-11 10:49:07','2024-02-11 10:49:07',NULL),(2757,7812,784,40720,1559,3,217,1,145163.31,NULL,'2024-02-11 10:49:52','2024-02-11 10:49:52',NULL),(2758,7812,784,40720,1559,3,68,1,30484.30,NULL,'2024-02-11 10:49:52','2024-02-11 10:49:52',NULL),(2759,7812,784,40720,1559,3,221,1,4352.59,NULL,'2024-02-11 10:49:52','2024-02-11 10:49:52',NULL),(2760,7812,784,40720,1559,3,57,2,180000.20,NULL,'2024-02-11 10:49:52','2024-02-11 10:49:52',NULL),(2761,7812,785,40720,1559,3,217,1,78200.59,NULL,'2024-02-11 10:51:46','2024-02-11 10:51:46',NULL),(2762,7812,785,40720,1559,3,68,1,16422.12,NULL,'2024-02-11 10:51:46','2024-02-11 10:51:46',NULL),(2763,7812,785,40720,1559,3,221,1,4377.27,NULL,'2024-02-11 10:51:46','2024-02-11 10:51:46',NULL),(2764,7812,785,40720,1559,3,57,2,98999.98,NULL,'2024-02-11 10:51:46','2024-02-11 10:51:46',NULL),(2765,7812,786,40720,1559,3,217,1,66131.07,NULL,'2024-02-11 10:52:54','2024-02-11 10:52:54',NULL),(2766,7812,786,40720,1559,3,68,1,13887.52,NULL,'2024-02-11 10:52:54','2024-02-11 10:52:54',NULL),(2767,7812,786,40720,1559,3,221,1,3581.40,NULL,'2024-02-11 10:52:54','2024-02-11 10:52:54',NULL),(2768,7812,786,40720,1559,3,57,2,83599.99,NULL,'2024-02-11 10:52:54','2024-02-11 10:52:54',NULL),(2769,7812,787,40720,1559,3,217,1,31601.19,NULL,'2024-02-11 10:53:49','2024-02-11 10:53:49',NULL),(2770,7812,787,40720,1559,3,68,1,6636.25,NULL,'2024-02-11 10:53:49','2024-02-11 10:53:49',NULL);
INSERT INTO `balance_libro_details` VALUES (2771,7812,787,40720,1559,3,221,1,1768.87,NULL,'2024-02-11 10:53:49','2024-02-11 10:53:49',NULL),(2772,7812,787,40720,1559,3,57,2,40006.31,NULL,'2024-02-11 10:53:49','2024-02-11 10:53:49',NULL),(2773,7812,788,40720,1559,3,217,1,74539.73,NULL,'2024-02-11 10:54:34','2024-02-11 10:54:34',NULL),(2774,7812,788,40720,1559,3,68,1,15653.34,NULL,'2024-02-11 10:54:34','2024-02-11 10:54:34',NULL),(2775,7812,788,40720,1559,3,221,1,4172.34,NULL,'2024-02-11 10:54:34','2024-02-11 10:54:34',NULL),(2776,7812,788,40720,1559,3,57,2,94365.41,NULL,'2024-02-11 10:54:34','2024-02-11 10:54:34',NULL),(2777,7812,789,40720,1559,3,217,1,23915.95,NULL,'2024-02-11 10:55:16','2024-02-11 10:55:16',NULL),(2778,7812,789,40720,1559,3,68,1,5022.35,NULL,'2024-02-11 10:55:16','2024-02-11 10:55:16',NULL),(2779,7812,789,40720,1559,3,221,1,1061.68,NULL,'2024-02-11 10:55:16','2024-02-11 10:55:16',NULL),(2780,7812,789,40720,1559,3,57,2,29999.98,NULL,'2024-02-11 10:55:16','2024-02-11 10:55:16',NULL),(2781,7812,790,40720,1559,3,217,1,79711.92,NULL,'2024-02-11 10:55:52','2024-02-11 10:55:52',NULL),(2782,7812,790,40720,1559,3,68,1,16739.50,NULL,'2024-02-11 10:55:52','2024-02-11 10:55:52',NULL),(2783,7812,790,40720,1559,3,221,1,3538.58,NULL,'2024-02-11 10:55:52','2024-02-11 10:55:52',NULL),(2784,7812,790,40720,1559,3,57,2,99990.00,NULL,'2024-02-11 10:55:52','2024-02-11 10:55:52',NULL),(2785,7812,791,40720,1559,3,217,1,79711.92,NULL,'2024-02-11 10:56:35','2024-02-11 10:56:35',NULL),(2786,7812,791,40720,1559,3,68,1,16739.50,NULL,'2024-02-11 10:56:35','2024-02-11 10:56:35',NULL),(2787,7812,791,40720,1559,3,221,1,3538.58,NULL,'2024-02-11 10:56:35','2024-02-11 10:56:35',NULL),(2788,7812,791,40720,1559,3,57,2,99990.00,NULL,'2024-02-11 10:56:35','2024-02-11 10:56:35',NULL),(2789,7812,792,40720,1559,3,217,1,159423.84,NULL,'2024-02-11 10:57:25','2024-02-11 10:57:25',NULL),(2790,7812,792,40720,1559,3,68,1,33479.01,NULL,'2024-02-11 10:57:25','2024-02-11 10:57:25',NULL),(2791,7812,792,40720,1559,3,221,1,7077.16,NULL,'2024-02-11 10:57:25','2024-02-11 10:57:25',NULL),(2792,7812,792,40720,1559,3,57,2,199980.01,NULL,'2024-02-11 10:57:25','2024-02-11 10:57:25',NULL),(2793,7812,793,40720,1559,3,217,1,159423.84,NULL,'2024-02-11 10:57:59','2024-02-11 10:57:59',NULL),(2794,7812,793,40720,1559,3,68,1,33479.01,NULL,'2024-02-11 10:57:59','2024-02-11 10:57:59',NULL),(2795,7812,793,40720,1559,3,221,1,7077.16,NULL,'2024-02-11 10:57:59','2024-02-11 10:57:59',NULL),(2796,7812,793,40720,1559,3,57,2,199980.01,NULL,'2024-02-11 10:57:59','2024-02-11 10:57:59',NULL),(2797,7812,794,40720,1559,3,217,1,159423.84,NULL,'2024-02-11 10:58:37','2024-02-11 10:58:37',NULL),(2798,7812,794,40720,1559,3,68,1,33479.01,NULL,'2024-02-11 10:58:37','2024-02-11 10:58:37',NULL),(2799,7812,794,40720,1559,3,221,1,7077.16,NULL,'2024-02-11 10:58:37','2024-02-11 10:58:37',NULL),(2800,7812,794,40720,1559,3,57,2,199980.01,NULL,'2024-02-11 10:58:37','2024-02-11 10:58:37',NULL),(2801,7812,795,40720,1559,3,217,1,159439.82,NULL,'2024-02-11 10:59:11','2024-02-11 10:59:11',NULL),(2802,7812,795,40720,1559,3,68,1,33482.36,NULL,'2024-02-11 10:59:11','2024-02-11 10:59:11',NULL),(2803,7812,795,40720,1559,3,221,1,7077.86,NULL,'2024-02-11 10:59:11','2024-02-11 10:59:11',NULL),(2804,7812,795,40720,1559,3,57,2,200000.04,NULL,'2024-02-11 10:59:11','2024-02-11 10:59:11',NULL),(2805,7812,796,40720,1559,3,217,1,7995.85,NULL,'2024-02-11 10:59:55','2024-02-11 10:59:55',NULL),(2806,7812,796,40720,1559,3,68,1,1679.13,NULL,'2024-02-11 10:59:55','2024-02-11 10:59:55',NULL),(2807,7812,796,40720,1559,3,221,1,324.99,NULL,'2024-02-11 10:59:55','2024-02-11 10:59:55',NULL),(2808,7812,796,40720,1559,3,57,2,9999.97,NULL,'2024-02-11 10:59:55','2024-02-11 10:59:55',NULL),(2809,7812,797,40720,1559,3,217,1,32215.08,NULL,'2024-02-11 11:01:00','2024-02-11 11:01:00',NULL),(2810,7812,797,40720,1559,3,68,1,6765.17,NULL,'2024-02-11 11:01:00','2024-02-11 11:01:00',NULL),(2811,7812,797,40720,1559,3,221,1,1046.36,NULL,'2024-02-11 11:01:00','2024-02-11 11:01:00',NULL);
INSERT INTO `balance_libro_details` VALUES (2812,7812,797,40720,1559,3,57,2,40026.61,NULL,'2024-02-11 11:01:00','2024-02-11 11:01:00',NULL),(2813,7812,798,40720,1559,3,217,1,52892.56,NULL,'2024-02-11 11:21:03','2024-02-11 11:21:03',NULL),(2814,7812,798,40720,1559,3,68,1,11107.44,NULL,'2024-02-11 11:21:03','2024-02-11 11:21:03',NULL),(2815,7812,798,40720,1559,3,57,2,64000.00,NULL,'2024-02-11 11:21:03','2024-02-11 11:21:03',NULL),(2816,7812,799,40825,4560,2,96,2,408000.00,NULL,'2024-02-20 11:57:45','2024-02-20 11:57:45',NULL),(2817,7812,799,40825,4560,2,67,2,85680.00,NULL,'2024-02-20 11:57:45','2024-02-20 11:57:45',NULL),(2818,7812,799,40825,4560,2,13,1,493680.00,NULL,'2024-02-20 11:57:45','2024-02-20 11:57:45',NULL),(2819,7812,800,40825,4560,2,96,2,1317000.00,NULL,'2024-02-20 11:57:45','2024-02-20 11:57:45',NULL),(2820,7812,800,40825,4560,2,67,2,276570.00,NULL,'2024-02-20 11:57:45','2024-02-20 11:57:45',NULL),(2821,7812,800,40825,4560,2,13,1,1593570.00,NULL,'2024-02-20 11:57:45','2024-02-20 11:57:45',NULL),(2822,7812,801,40825,4560,3,217,1,512396.71,NULL,'2024-02-20 11:58:07','2024-02-20 11:58:07',NULL),(2823,7812,801,40825,4560,3,68,1,107603.31,NULL,'2024-02-20 11:58:07','2024-02-20 11:58:07',NULL),(2824,7812,801,40825,4560,3,217,1,-0.01,NULL,'2024-02-20 11:58:07','2024-02-20 11:58:07',NULL),(2825,7812,801,40825,4560,3,57,2,620000.01,NULL,'2024-02-20 11:58:07','2024-02-20 11:58:07',NULL),(2826,7812,802,40825,4560,7,25,1,85680.00,NULL,'2024-02-20 12:07:06','2024-02-20 12:07:06',NULL),(2827,7812,802,40825,4560,7,13,2,85680.00,NULL,'2024-02-20 12:07:06','2024-02-20 12:07:06',NULL),(2828,7812,803,40825,4560,3,217,1,101272.57,NULL,'2024-02-20 12:40:50','2024-02-20 12:40:50',NULL),(2829,7812,803,40825,4560,3,68,1,21267.24,NULL,'2024-02-20 12:40:50','2024-02-20 12:40:50',NULL),(2830,7812,803,40825,4560,3,221,1,2461.20,NULL,'2024-02-20 12:40:50','2024-02-20 12:40:50',NULL),(2831,7812,803,40825,4560,3,57,2,125001.01,NULL,'2024-02-20 12:40:50','2024-02-20 12:40:50',NULL),(2832,7812,804,40825,4560,15,67,1,362250.00,NULL,'2024-02-20 12:57:55','2024-02-20 12:57:55',NULL),(2833,7812,804,40825,4560,15,68,2,128870.55,NULL,'2024-02-20 12:57:55','2024-02-20 12:57:55',NULL),(2834,7812,804,40825,4560,15,353,2,75143.13,NULL,'2024-02-20 12:57:55','2024-02-20 12:57:55',NULL),(2835,7812,804,40825,4560,15,354,2,198715.97,NULL,'2024-02-20 12:57:55','2024-02-20 12:57:55',NULL),(2836,7812,804,40825,4560,15,25,2,85680.00,NULL,'2024-02-20 12:57:55','2024-02-20 12:57:55',NULL),(2837,7812,804,40825,4560,15,354,1,126159.65,NULL,'2024-02-20 12:57:55','2024-02-20 12:57:55',NULL),(2838,7812,805,40720,1559,15,67,1,256756.50,NULL,'2024-02-20 18:21:04','2024-02-20 18:21:04',NULL),(2839,7812,805,40720,1559,15,68,2,422698.40,NULL,'2024-02-20 18:21:04','2024-02-20 18:21:04',NULL),(2840,7812,805,40720,1559,15,353,1,165941.90,NULL,'2024-02-20 18:21:04','2024-02-20 18:21:04',NULL),(2841,7812,806,40720,1563,2,96,2,265680.00,NULL,'2024-02-20 18:23:50','2024-02-20 18:23:50',NULL),(2842,7812,806,40720,1563,2,67,2,55792.80,NULL,'2024-02-20 18:23:50','2024-02-20 18:23:50',NULL),(2843,7812,806,40720,1563,2,13,1,321472.80,NULL,'2024-02-20 18:23:50','2024-02-20 18:23:50',NULL),(2844,7812,807,40720,1563,2,96,2,271584.00,NULL,'2024-02-20 18:23:50','2024-02-20 18:23:50',NULL),(2845,7812,807,40720,1563,2,67,2,57032.64,NULL,'2024-02-20 18:23:50','2024-02-20 18:23:50',NULL),(2846,7812,807,40720,1563,2,13,1,328616.64,NULL,'2024-02-20 18:23:50','2024-02-20 18:23:50',NULL),(2847,7812,808,40720,1563,3,217,1,36198.19,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2848,7812,808,40720,1563,3,68,1,3800.81,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2849,7812,808,40720,1563,3,57,2,39999.00,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2850,7812,809,40720,1563,3,217,1,22314.05,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2851,7812,809,40720,1563,3,68,1,4685.95,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL);
INSERT INTO `balance_libro_details` VALUES (2852,7812,809,40720,1563,3,57,2,27000.00,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2853,7812,810,40720,1563,3,217,1,41322.31,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2854,7812,810,40720,1563,3,68,1,8677.69,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2855,7812,810,40720,1563,3,57,2,50000.00,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2856,7812,811,40720,1563,3,217,1,76381.00,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2857,7812,811,40720,1563,3,68,1,16040.01,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2858,7812,811,40720,1563,3,217,1,-0.01,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2859,7812,811,40720,1563,3,57,2,92421.00,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2860,7812,812,40720,1563,3,217,1,82552.36,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2861,7812,812,40720,1563,3,68,1,17336.00,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2862,7812,812,40720,1563,3,57,2,99888.36,NULL,'2024-02-20 18:24:02','2024-02-20 18:24:02',NULL),(2863,7812,813,40720,1563,15,67,1,112825.44,NULL,'2024-02-20 18:38:21','2024-02-20 18:38:21',NULL),(2864,7812,813,40720,1563,15,68,2,50540.45,NULL,'2024-02-20 18:38:21','2024-02-20 18:38:21',NULL),(2865,7812,813,40720,1563,15,353,2,165941.90,NULL,'2024-02-20 18:38:21','2024-02-20 18:38:21',NULL),(2866,7812,813,40720,1563,15,353,1,103656.91,NULL,'2024-02-20 18:38:21','2024-02-20 18:38:21',NULL),(2867,7812,814,40825,4558,15,67,1,188436.78,NULL,'2024-03-06 18:09:52','2024-03-06 18:09:52',NULL),(2868,7812,814,40825,4558,15,68,2,263579.91,NULL,'2024-03-06 18:09:52','2024-03-06 18:09:52',NULL),(2869,7812,814,40825,4558,15,354,2,10279.19,NULL,'2024-03-06 18:09:52','2024-03-06 18:09:52',NULL),(2870,7812,814,40825,4558,15,25,2,188436.78,NULL,'2024-03-06 18:09:52','2024-03-06 18:09:52',NULL),(2871,7812,814,40825,4558,15,353,1,75143.13,NULL,'2024-03-06 18:09:52','2024-03-06 18:09:52',NULL),(2872,7812,814,40825,4558,15,354,1,198715.97,NULL,'2024-03-06 18:09:52','2024-03-06 18:09:52',NULL),(2873,7812,815,40825,4561,3,217,1,39576.85,NULL,'2024-03-16 08:28:36','2024-03-16 08:28:36',NULL),(2874,7812,815,40825,4561,3,68,1,8311.14,NULL,'2024-03-16 08:28:36','2024-03-16 08:28:36',NULL),(2875,7812,815,40825,4561,3,221,1,2112.02,NULL,'2024-03-16 08:28:36','2024-03-16 08:28:36',NULL),(2876,7812,815,40825,4561,3,57,2,50000.01,NULL,'2024-03-16 08:28:36','2024-03-16 08:28:36',NULL),(2877,7812,816,40825,4561,3,217,1,359522.73,NULL,'2024-03-16 08:30:47','2024-03-16 08:30:47',NULL),(2878,7812,816,40825,4561,3,68,1,75499.77,NULL,'2024-03-16 08:30:47','2024-03-16 08:30:47',NULL),(2879,7812,816,40825,4561,3,221,1,7975.90,NULL,'2024-03-16 08:30:47','2024-03-16 08:30:47',NULL),(2880,7812,816,40825,4561,3,57,2,442998.40,NULL,'2024-03-16 08:30:47','2024-03-16 08:30:47',NULL),(2881,7812,817,40825,4561,3,217,1,158345.12,NULL,'2024-03-16 08:31:49','2024-03-16 08:31:49',NULL),(2882,7812,817,40825,4561,3,68,1,33252.48,NULL,'2024-03-16 08:31:49','2024-03-16 08:31:49',NULL),(2883,7812,817,40825,4561,3,221,1,8402.40,NULL,'2024-03-16 08:31:49','2024-03-16 08:31:49',NULL),(2884,7812,817,40825,4561,3,57,2,200000.00,NULL,'2024-03-16 08:31:49','2024-03-16 08:31:49',NULL),(2885,7812,818,40825,4561,3,217,1,308401.69,NULL,'2024-03-16 08:34:08','2024-03-16 08:34:08',NULL),(2886,7812,818,40825,4561,3,68,1,64764.35,NULL,'2024-03-16 08:34:08','2024-03-16 08:34:08',NULL),(2887,7812,818,40825,4561,3,221,1,6841.76,NULL,'2024-03-16 08:34:08','2024-03-16 08:34:08',NULL),(2888,7812,818,40825,4561,3,57,2,380007.80,NULL,'2024-03-16 08:34:08','2024-03-16 08:34:08',NULL),(2889,7812,819,40825,4561,3,217,1,343696.23,NULL,'2024-03-16 08:35:37','2024-03-16 08:35:37',NULL),(2890,7812,819,40825,4561,3,68,1,72176.21,NULL,'2024-03-16 08:35:37','2024-03-16 08:35:37',NULL),(2891,7812,819,40825,4561,3,221,1,8128.65,NULL,'2024-03-16 08:35:37','2024-03-16 08:35:37',NULL);
INSERT INTO `balance_libro_details` VALUES (2892,7812,819,40825,4561,3,57,2,424001.09,NULL,'2024-03-16 08:35:37','2024-03-16 08:35:37',NULL),(2893,7812,820,40825,4561,3,217,1,348591.05,NULL,'2024-03-16 08:39:17','2024-03-16 08:39:17',NULL),(2894,7812,820,40825,4561,3,68,1,73204.12,NULL,'2024-03-16 08:39:17','2024-03-16 08:39:17',NULL),(2895,7812,820,40825,4561,3,221,1,8244.41,NULL,'2024-03-16 08:39:17','2024-03-16 08:39:17',NULL),(2896,7812,820,40825,4561,3,57,2,430039.58,NULL,'2024-03-16 08:39:17','2024-03-16 08:39:17',NULL),(2897,7812,821,40825,4561,3,217,1,40534.67,NULL,'2024-03-16 08:40:45','2024-03-16 08:40:45',NULL),(2898,7812,821,40825,4561,3,68,1,8512.28,NULL,'2024-03-16 08:40:45','2024-03-16 08:40:45',NULL),(2899,7812,821,40825,4561,3,221,1,953.05,NULL,'2024-03-16 08:40:45','2024-03-16 08:40:45',NULL),(2900,7812,821,40825,4561,3,57,2,50000.00,NULL,'2024-03-16 08:40:45','2024-03-16 08:40:45',NULL),(2901,7812,822,40825,4561,3,217,1,78077.27,NULL,'2024-03-16 08:42:23','2024-03-16 08:42:23',NULL),(2902,7812,822,40825,4561,3,68,1,16396.23,NULL,'2024-03-16 08:42:23','2024-03-16 08:42:23',NULL),(2903,7812,822,40825,4561,3,221,1,1897.50,NULL,'2024-03-16 08:42:23','2024-03-16 08:42:23',NULL),(2904,7812,822,40825,4561,3,57,2,96371.00,NULL,'2024-03-16 08:42:23','2024-03-16 08:42:23',NULL),(2905,7812,823,40825,4561,3,217,1,81060.22,NULL,'2024-03-16 08:43:07','2024-03-16 08:43:07',NULL),(2906,7812,823,40825,4561,3,68,1,17022.65,NULL,'2024-03-16 08:43:07','2024-03-16 08:43:07',NULL),(2907,7812,823,40825,4561,3,221,1,1917.13,NULL,'2024-03-16 08:43:07','2024-03-16 08:43:07',NULL),(2908,7812,823,40825,4561,3,57,2,100000.00,NULL,'2024-03-16 08:43:07','2024-03-16 08:43:07',NULL),(2909,7812,824,40825,4561,3,217,1,316135.65,NULL,'2024-03-16 08:46:18','2024-03-16 08:46:18',NULL),(2910,7812,824,40825,4561,3,68,1,66388.49,NULL,'2024-03-16 08:46:18','2024-03-16 08:46:18',NULL),(2911,7812,824,40825,4561,3,221,1,7476.82,NULL,'2024-03-16 08:46:18','2024-03-16 08:46:18',NULL),(2912,7812,824,40825,4561,3,57,2,390000.96,NULL,'2024-03-16 08:46:18','2024-03-16 08:46:18',NULL),(2913,7812,825,40825,4561,3,217,1,316135.65,NULL,'2024-03-16 08:47:04','2024-03-16 08:47:04',NULL),(2914,7812,825,40825,4561,3,68,1,66388.49,NULL,'2024-03-16 08:47:04','2024-03-16 08:47:04',NULL),(2915,7812,825,40825,4561,3,221,1,7476.82,NULL,'2024-03-16 08:47:04','2024-03-16 08:47:04',NULL),(2916,7812,825,40825,4561,3,57,2,390000.96,NULL,'2024-03-16 08:47:04','2024-03-16 08:47:04',NULL),(2917,7812,826,40825,4561,2,96,2,1019700.00,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2918,7812,826,40825,4561,2,67,2,214137.00,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2919,7812,826,40825,4561,2,13,1,1233837.00,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2920,7812,827,40825,4561,2,96,2,1225.43,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2921,7812,827,40825,4561,2,67,2,257.34,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2922,7812,827,40825,4561,2,218,2,0.01,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2923,7812,827,40825,4561,2,13,1,1482.78,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2924,7812,828,40825,4561,2,96,2,1225440.00,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2925,7812,828,40825,4561,2,67,2,257342.40,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2926,7812,828,40825,4561,2,13,1,1482782.40,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2927,7812,829,40825,4561,2,96,1,1225.43,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2928,7812,829,40825,4561,2,68,1,257.34,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2929,7812,829,40825,4561,2,218,1,0.01,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2930,7812,829,40825,4561,2,13,2,1482.78,NULL,'2024-03-16 08:54:24','2024-03-16 08:54:24',NULL),(2931,7812,830,40825,4561,3,217,1,206611.57,NULL,'2024-03-16 08:54:49','2024-03-16 08:54:49',NULL),(2932,7812,830,40825,4561,3,68,1,43388.43,NULL,'2024-03-16 08:54:49','2024-03-16 08:54:49',NULL);
INSERT INTO `balance_libro_details` VALUES (2933,7812,830,40825,4561,3,57,2,250000.00,NULL,'2024-03-16 08:54:49','2024-03-16 08:54:49',NULL),(2934,7812,831,40825,4561,3,217,1,165289.24,NULL,'2024-03-16 08:54:49','2024-03-16 08:54:49',NULL),(2935,7812,831,40825,4561,3,68,1,34710.74,NULL,'2024-03-16 08:54:49','2024-03-16 08:54:49',NULL),(2936,7812,831,40825,4561,3,217,1,0.02,NULL,'2024-03-16 08:54:49','2024-03-16 08:54:49',NULL),(2937,7812,831,40825,4561,3,57,2,200000.00,NULL,'2024-03-16 08:54:49','2024-03-16 08:54:49',NULL),(2938,7812,832,40720,1564,2,96,2,408960.00,NULL,'2024-03-16 10:11:45','2024-03-16 10:11:45',NULL),(2939,7812,832,40720,1564,2,67,2,85881.60,NULL,'2024-03-16 10:11:45','2024-03-16 10:11:45',NULL),(2940,7812,832,40720,1564,2,13,1,494841.60,NULL,'2024-03-16 10:11:45','2024-03-16 10:11:45',NULL),(2941,7812,833,40720,1564,2,96,2,416880.00,NULL,'2024-03-16 10:11:45','2024-03-16 10:11:45',NULL),(2942,7812,833,40720,1564,2,67,2,87544.80,NULL,'2024-03-16 10:11:45','2024-03-16 10:11:45',NULL),(2943,7812,833,40720,1564,2,13,1,504424.80,NULL,'2024-03-16 10:11:45','2024-03-16 10:11:45',NULL),(2944,7812,834,40720,1564,3,217,1,21900.81,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2945,7812,834,40720,1564,3,68,1,4599.17,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2946,7812,834,40720,1564,3,217,1,0.02,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2947,7812,834,40720,1564,3,57,2,26500.00,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2948,7812,835,40720,1564,3,217,1,66942.14,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2949,7812,835,40720,1564,3,68,1,14057.85,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2950,7812,835,40720,1564,3,57,2,80999.99,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2951,7812,836,40720,1564,3,217,1,42641.50,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2952,7812,836,40720,1564,3,68,1,8954.72,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2953,7812,836,40720,1564,3,57,2,51596.22,NULL,'2024-03-16 10:11:58','2024-03-16 10:11:58',NULL),(2954,7812,837,40825,4561,7,23,1,276570.00,NULL,'2024-03-19 19:56:27','2024-03-19 19:58:43','2024-03-19 19:58:43'),(2955,7812,837,40825,4561,7,13,2,276570.00,NULL,'2024-03-19 19:56:27','2024-03-19 19:58:43','2024-03-19 19:58:43'),(2956,7812,838,40825,4561,7,23,1,214137.00,NULL,'2024-03-19 19:57:06','2024-03-19 19:58:30','2024-03-19 19:58:30'),(2957,7812,838,40825,4561,7,13,2,214137.00,NULL,'2024-03-19 19:57:06','2024-03-19 19:58:30','2024-03-19 19:58:30'),(2958,7812,839,40825,4561,7,25,1,214137.00,NULL,'2024-03-19 19:58:30','2024-03-19 19:58:30',NULL),(2959,7812,839,40825,4561,7,13,2,214137.00,NULL,'2024-03-19 19:58:30','2024-03-19 19:58:30',NULL),(2960,7812,840,40825,4561,7,25,1,276570.00,NULL,'2024-03-19 19:58:43','2024-03-19 19:58:43',NULL),(2961,7812,840,40825,4561,7,13,2,276570.00,NULL,'2024-03-19 19:58:43','2024-03-19 19:58:43',NULL),(2962,7812,841,40720,1564,3,217,1,64747.86,NULL,'2024-03-20 18:06:21','2024-03-20 18:06:21',NULL),(2963,7812,841,40720,1564,3,68,1,13597.05,NULL,'2024-03-20 18:06:21','2024-03-20 18:06:21',NULL),(2964,7812,841,40720,1564,3,221,1,1658.12,NULL,'2024-03-20 18:06:21','2024-03-20 18:06:21',NULL),(2965,7812,841,40720,1564,3,57,2,80003.03,NULL,'2024-03-20 18:06:21','2024-03-20 18:06:21',NULL),(2966,7812,842,40720,1564,3,217,1,71611.84,NULL,'2024-03-20 18:07:15','2024-03-20 18:07:15',NULL),(2967,7812,842,40720,1564,3,68,1,15038.49,NULL,'2024-03-20 18:07:15','2024-03-20 18:07:15',NULL),(2968,7812,842,40720,1564,3,221,1,1851.66,NULL,'2024-03-20 18:07:15','2024-03-20 18:07:15',NULL),(2969,7812,842,40720,1564,3,57,2,88501.99,NULL,'2024-03-20 18:07:15','2024-03-20 18:07:15',NULL),(2970,7812,843,40720,1564,3,217,1,81028.71,NULL,'2024-03-20 18:08:06','2024-03-20 18:08:06',NULL),(2971,7812,843,40720,1564,3,68,1,17016.03,NULL,'2024-03-20 18:08:06','2024-03-20 18:08:06',NULL),(2972,7812,843,40720,1564,3,221,1,1969.22,NULL,'2024-03-20 18:08:06','2024-03-20 18:08:06',NULL);
INSERT INTO `balance_libro_details` VALUES (2973,7812,843,40720,1564,3,57,2,100013.96,NULL,'2024-03-20 18:08:06','2024-03-20 18:08:06',NULL),(2974,7812,844,40720,1564,3,217,1,72854.76,NULL,'2024-03-20 18:09:46','2024-03-20 18:09:46',NULL),(2975,7812,844,40720,1564,3,68,1,15299.50,NULL,'2024-03-20 18:09:46','2024-03-20 18:09:46',NULL),(2976,7812,844,40720,1564,3,221,1,1865.73,NULL,'2024-03-20 18:09:46','2024-03-20 18:09:46',NULL),(2977,7812,844,40720,1564,3,57,2,90019.99,NULL,'2024-03-20 18:09:46','2024-03-20 18:09:46',NULL),(2978,7812,845,40720,1564,3,217,1,38038.74,NULL,'2024-03-20 18:10:58','2024-03-20 18:10:58',NULL),(2979,7812,845,40720,1564,3,68,1,7988.14,NULL,'2024-03-20 18:10:58','2024-03-20 18:10:58',NULL),(2980,7812,845,40720,1564,3,221,1,974.13,NULL,'2024-03-20 18:10:58','2024-03-20 18:10:58',NULL),(2981,7812,845,40720,1564,3,57,2,47001.01,NULL,'2024-03-20 18:10:58','2024-03-20 18:10:58',NULL),(2982,7812,846,40720,1564,3,217,1,34804.70,NULL,'2024-03-20 18:11:40','2024-03-20 18:11:40',NULL),(2983,7812,846,40720,1564,3,68,1,7308.99,NULL,'2024-03-20 18:11:40','2024-03-20 18:11:40',NULL),(2984,7812,846,40720,1564,3,221,1,891.31,NULL,'2024-03-20 18:11:40','2024-03-20 18:11:40',NULL),(2985,7812,846,40720,1564,3,57,2,43005.00,NULL,'2024-03-20 18:11:40','2024-03-20 18:11:40',NULL),(2986,7812,847,40720,1564,3,217,1,80496.72,NULL,'2024-03-20 18:13:21','2024-03-20 18:13:21',NULL),(2987,7812,847,40720,1564,3,68,1,16904.31,NULL,'2024-03-20 18:13:21','2024-03-20 18:13:21',NULL),(2988,7812,847,40720,1564,3,221,1,2598.98,NULL,'2024-03-20 18:13:21','2024-03-20 18:13:21',NULL),(2989,7812,847,40720,1564,3,57,2,100000.01,NULL,'2024-03-20 18:13:21','2024-03-20 18:13:21',NULL),(2990,7812,848,40720,1564,3,217,1,56342.12,NULL,'2024-03-20 18:14:22','2024-03-20 18:14:22',NULL),(2991,7812,848,40720,1564,3,68,1,11831.85,NULL,'2024-03-20 18:14:23','2024-03-20 18:14:23',NULL),(2992,7812,848,40720,1564,3,221,1,1830.02,NULL,'2024-03-20 18:14:23','2024-03-20 18:14:23',NULL),(2993,7812,848,40720,1564,3,57,2,70003.99,NULL,'2024-03-20 18:14:23','2024-03-20 18:14:23',NULL),(2994,7812,849,40825,4562,2,96,2,1534140.00,NULL,'2024-05-13 17:43:01','2024-05-13 17:43:01',NULL),(2995,7812,849,40825,4562,2,67,2,322169.40,NULL,'2024-05-13 17:43:01','2024-05-13 17:43:01',NULL),(2996,7812,849,40825,4562,2,13,1,1856309.40,NULL,'2024-05-13 17:43:01','2024-05-13 17:43:01',NULL),(2997,7812,850,40825,4562,2,96,2,1531260.00,NULL,'2024-05-13 17:43:01','2024-05-13 17:43:01',NULL),(2998,7812,850,40825,4562,2,67,2,321564.60,NULL,'2024-05-13 17:43:01','2024-05-13 17:43:01',NULL),(2999,7812,850,40825,4562,2,13,1,1852824.60,NULL,'2024-05-13 17:43:01','2024-05-13 17:43:01',NULL),(3000,7812,851,40825,4562,3,217,1,11570.24,NULL,'2024-05-13 17:43:12','2024-05-23 15:53:52','2024-05-23 15:53:52'),(3001,7812,851,40825,4562,3,68,1,2429.75,NULL,'2024-05-13 17:43:12','2024-05-23 15:53:52','2024-05-23 15:53:52'),(3002,7812,851,40825,4562,3,57,2,13999.99,NULL,'2024-05-13 17:43:12','2024-05-23 15:53:52','2024-05-23 15:53:52'),(3003,7812,852,40825,4562,3,217,1,27090.91,NULL,'2024-05-13 17:43:12','2024-05-23 15:53:09','2024-05-23 15:53:09'),(3004,7812,852,40825,4562,3,68,1,5689.09,NULL,'2024-05-13 17:43:12','2024-05-23 15:53:09','2024-05-23 15:53:09'),(3005,7812,852,40825,4562,3,57,2,32780.00,NULL,'2024-05-13 17:43:12','2024-05-23 15:53:09','2024-05-23 15:53:09'),(3006,7812,853,40825,4562,3,217,1,25064.13,NULL,'2024-05-13 17:43:13','2024-05-23 15:52:57','2024-05-23 15:52:57'),(3007,7812,853,40825,4562,3,68,1,5263.47,NULL,'2024-05-13 17:43:13','2024-05-23 15:52:57','2024-05-23 15:52:57'),(3008,7812,853,40825,4562,3,57,2,30327.60,NULL,'2024-05-13 17:43:13','2024-05-23 15:52:57','2024-05-23 15:52:57'),(3009,7812,854,40825,4562,3,217,1,75867.81,NULL,'2024-05-13 17:43:13','2024-05-23 15:53:40','2024-05-23 15:53:40'),(3010,7812,854,40825,4562,3,68,1,15932.24,NULL,'2024-05-13 17:43:13','2024-05-23 15:53:40','2024-05-23 15:53:40'),(3011,7812,854,40825,4562,3,217,1,-0.01,NULL,'2024-05-13 17:43:13','2024-05-23 15:53:40','2024-05-23 15:53:40');
INSERT INTO `balance_libro_details` VALUES (3012,7812,854,40825,4562,3,57,2,91800.04,NULL,'2024-05-13 17:43:13','2024-05-23 15:53:40','2024-05-23 15:53:40'),(3013,7812,855,40825,4562,3,217,1,28512.39,NULL,'2024-05-13 17:43:13','2024-05-23 15:52:42','2024-05-23 15:52:42'),(3014,7812,855,40825,4562,3,68,1,5987.60,NULL,'2024-05-13 17:43:13','2024-05-23 15:52:42','2024-05-23 15:52:42'),(3015,7812,855,40825,4562,3,57,2,34499.99,NULL,'2024-05-13 17:43:13','2024-05-23 15:52:42','2024-05-23 15:52:42'),(3016,7812,856,40825,4562,3,217,1,370550.36,NULL,'2024-05-13 17:59:06','2024-05-13 17:59:06',NULL),(3017,7812,856,40825,4562,3,68,1,77815.58,NULL,'2024-05-13 17:59:06','2024-05-13 17:59:06',NULL),(3018,7812,856,40825,4562,3,221,1,7637.24,NULL,'2024-05-13 17:59:06','2024-05-13 17:59:06',NULL),(3019,7812,856,40825,4562,3,57,2,456003.18,NULL,'2024-05-13 17:59:06','2024-05-13 17:59:06',NULL),(3020,7812,857,40825,4562,3,217,1,368193.20,NULL,'2024-05-13 18:00:18','2024-05-13 18:00:18',NULL),(3021,7812,857,40825,4562,3,68,1,77320.57,NULL,'2024-05-13 18:00:18','2024-05-13 18:00:18',NULL),(3022,7812,857,40825,4562,3,221,1,7588.66,NULL,'2024-05-13 18:00:18','2024-05-13 18:00:18',NULL),(3023,7812,857,40825,4562,3,57,2,453102.43,NULL,'2024-05-13 18:00:18','2024-05-13 18:00:18',NULL),(3024,7812,858,40825,4562,3,217,1,40579.01,NULL,'2024-05-13 18:01:24','2024-05-13 18:01:24',NULL),(3025,7812,858,40825,4562,3,68,1,8521.59,NULL,'2024-05-13 18:01:24','2024-05-13 18:01:24',NULL),(3026,7812,858,40825,4562,3,221,1,905.42,NULL,'2024-05-13 18:01:24','2024-05-13 18:01:24',NULL),(3027,7812,858,40825,4562,3,57,2,50006.02,NULL,'2024-05-13 18:01:24','2024-05-13 18:01:24',NULL),(3028,7812,859,40825,4562,3,217,1,40581.41,NULL,'2024-05-13 18:02:04','2024-05-13 18:02:04',NULL),(3029,7812,859,40825,4562,3,68,1,8522.10,NULL,'2024-05-13 18:02:04','2024-05-13 18:02:04',NULL),(3030,7812,859,40825,4562,3,221,1,905.48,NULL,'2024-05-13 18:02:04','2024-05-13 18:02:04',NULL),(3031,7812,859,40825,4562,3,57,2,50008.99,NULL,'2024-05-13 18:02:04','2024-05-13 18:02:04',NULL),(3032,7812,860,40825,4562,3,217,1,40722.53,NULL,'2024-05-13 18:03:49','2024-05-13 18:03:49',NULL),(3033,7812,860,40825,4562,3,68,1,8551.73,NULL,'2024-05-13 18:03:49','2024-05-13 18:03:49',NULL),(3034,7812,860,40825,4562,3,221,1,725.72,NULL,'2024-05-13 18:03:49','2024-05-13 18:03:49',NULL),(3035,7812,860,40825,4562,3,57,2,49999.98,NULL,'2024-05-13 18:03:49','2024-05-13 18:03:49',NULL),(3036,7812,861,40825,4562,3,217,1,40190.54,NULL,'2024-05-13 18:04:23','2024-05-13 18:04:23',NULL),(3037,7812,861,40825,4562,3,68,1,8440.01,NULL,'2024-05-13 18:04:23','2024-05-13 18:04:23',NULL),(3038,7812,861,40825,4562,3,221,1,1369.48,NULL,'2024-05-13 18:04:23','2024-05-13 18:04:23',NULL),(3039,7812,861,40825,4562,3,57,2,50000.03,NULL,'2024-05-13 18:04:23','2024-05-13 18:04:23',NULL),(3040,7812,862,40825,4562,3,217,1,40190.54,NULL,'2024-05-13 18:05:12','2024-05-13 18:05:12',NULL),(3041,7812,862,40825,4562,3,68,1,8440.01,NULL,'2024-05-13 18:05:12','2024-05-13 18:05:12',NULL),(3042,7812,862,40825,4562,3,221,1,1369.48,NULL,'2024-05-13 18:05:12','2024-05-13 18:05:12',NULL),(3043,7812,862,40825,4562,3,57,2,50000.03,NULL,'2024-05-13 18:05:12','2024-05-13 18:05:12',NULL),(3044,7812,863,40720,1564,15,67,1,173426.40,NULL,'2024-05-13 18:29:53','2024-05-13 18:29:53',NULL),(3045,7812,863,40720,1564,15,68,2,132596.08,NULL,'2024-05-13 18:29:53','2024-05-13 18:29:53',NULL),(3046,7812,863,40720,1564,15,353,2,103656.91,NULL,'2024-05-13 18:29:53','2024-05-13 18:29:53',NULL),(3047,7812,863,40720,1564,15,353,1,62826.59,NULL,'2024-05-13 18:29:53','2024-05-13 18:29:53',NULL),(3048,7812,864,40720,1565,2,96,2,613440.00,NULL,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(3049,7812,864,40720,1565,2,67,2,128822.40,NULL,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(3050,7812,864,40720,1565,2,13,1,742262.40,NULL,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(3051,7812,865,40720,1565,2,96,2,204840.00,NULL,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3052,7812,865,40720,1565,2,67,2,43016.40,NULL,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(3053,7812,865,40720,1565,2,13,1,247856.40,NULL,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(3054,7812,866,40720,1565,2,96,2,102780.00,NULL,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(3055,7812,866,40720,1565,2,67,2,21583.80,NULL,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(3056,7812,866,40720,1565,2,13,1,124363.80,NULL,'2024-05-13 18:32:21','2024-05-13 18:32:21',NULL),(3057,7812,867,40720,1565,3,217,2,42641.50,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3058,7812,867,40720,1565,3,67,2,8954.72,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3059,7812,867,40720,1565,3,57,1,51596.22,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3060,7812,868,40720,1565,3,217,1,38367.77,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3061,7812,868,40720,1565,3,68,1,8057.23,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3062,7812,868,40720,1565,3,57,2,46425.00,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3063,7812,869,40720,1565,3,217,1,40908.35,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3064,7812,869,40720,1565,3,68,1,8590.75,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3065,7812,869,40720,1565,3,57,2,49499.10,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3066,7812,870,40720,1565,3,217,1,85066.97,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3067,7812,870,40720,1565,3,68,1,8932.03,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3068,7812,870,40720,1565,3,57,2,93999.00,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3069,7812,871,40720,1565,3,217,1,227272.73,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3070,7812,871,40720,1565,3,68,1,47727.27,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3071,7812,871,40720,1565,3,57,2,275000.00,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3072,7812,872,40720,1565,3,217,1,32644.63,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3073,7812,872,40720,1565,3,68,1,6855.37,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3074,7812,872,40720,1565,3,57,2,39500.00,NULL,'2024-05-13 18:32:33','2024-05-13 18:32:33',NULL),(3075,7812,873,40825,4562,3,217,1,355047.67,NULL,'2024-05-14 17:19:29','2024-05-14 17:19:29',NULL),(3076,7812,873,40825,4562,3,68,1,74560.01,NULL,'2024-05-14 17:19:29','2024-05-14 17:19:29',NULL),(3077,7812,873,40825,4562,3,221,1,8397.12,NULL,'2024-05-14 17:19:29','2024-05-14 17:19:29',NULL),(3078,7812,873,40825,4562,3,57,2,438004.80,NULL,'2024-05-14 17:19:29','2024-05-14 17:19:29',NULL),(3079,7812,874,40825,4561,15,67,1,471736.74,NULL,'2024-05-14 17:29:34','2024-05-14 17:29:34',NULL),(3080,7812,874,40825,4561,15,68,2,580272.71,NULL,'2024-05-14 17:29:34','2024-05-14 17:29:34',NULL),(3081,7812,874,40825,4561,15,354,2,126159.65,NULL,'2024-05-14 17:29:34','2024-05-14 17:29:34',NULL),(3082,7812,874,40825,4561,15,25,2,490707.00,NULL,'2024-05-14 17:29:34','2024-05-14 17:29:34',NULL),(3083,7812,874,40825,4561,15,353,1,108535.97,NULL,'2024-05-14 17:29:34','2024-05-14 17:29:34',NULL),(3084,7812,874,40825,4561,15,354,1,616866.65,NULL,'2024-05-14 17:29:34','2024-05-14 17:29:34',NULL),(3085,7812,875,40825,4562,15,67,1,643734.00,NULL,'2024-05-23 15:41:27','2024-05-23 15:51:50','2024-05-23 15:51:50'),(3086,7812,875,40825,4562,15,68,2,307473.76,NULL,'2024-05-23 15:41:27','2024-05-23 15:51:50','2024-05-23 15:51:50'),(3087,7812,875,40825,4562,15,353,2,108535.97,NULL,'2024-05-23 15:41:27','2024-05-23 15:51:50','2024-05-23 15:51:50'),(3088,7812,875,40825,4562,15,354,2,616866.65,NULL,'2024-05-23 15:41:27','2024-05-23 15:51:50','2024-05-23 15:51:50'),(3089,7812,875,40825,4562,15,354,1,388885.04,NULL,'2024-05-23 15:41:27','2024-05-23 15:51:50','2024-05-23 15:51:50'),(3090,7812,875,40825,4562,15,136,1,257.34,NULL,'2024-05-23 15:41:27','2024-05-23 15:51:50','2024-05-23 15:51:50');
INSERT INTO `balance_libro_details` VALUES (3091,7812,876,40825,4562,3,217,1,11570.24,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3092,7812,876,40825,4562,3,68,1,2429.75,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3093,7812,876,40825,4562,3,57,2,13999.99,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3094,7812,877,40825,4562,3,217,1,27090.91,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3095,7812,877,40825,4562,3,68,1,5689.09,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3096,7812,877,40825,4562,3,57,2,32780.00,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3097,7812,878,40825,4562,3,217,1,25064.13,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3098,7812,878,40825,4562,3,68,1,5263.47,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3099,7812,878,40825,4562,3,57,2,30327.60,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3100,7812,879,40825,4562,3,217,1,75867.81,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3101,7812,879,40825,4562,3,68,1,15932.24,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3102,7812,879,40825,4562,3,217,1,-0.01,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3103,7812,879,40825,4562,3,57,2,91800.04,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3104,7812,880,40825,4562,3,217,1,28512.39,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3105,7812,880,40825,4562,3,68,1,5987.60,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3106,7812,880,40825,4562,3,57,2,34499.99,NULL,'2024-05-23 15:56:33','2024-05-23 15:56:33',NULL),(3107,7812,881,40825,4562,15,67,1,643734.00,NULL,'2024-05-23 15:58:46','2024-05-23 15:58:46',NULL),(3108,7812,881,40825,4562,15,68,2,307473.76,NULL,'2024-05-23 15:58:46','2024-05-23 15:58:46',NULL),(3109,7812,881,40825,4562,15,353,2,108535.97,NULL,'2024-05-23 15:58:46','2024-05-23 15:58:46',NULL),(3110,7812,881,40825,4562,15,354,2,616866.65,NULL,'2024-05-23 15:58:46','2024-05-23 15:58:46',NULL),(3111,7812,881,40825,4562,15,354,1,388885.04,NULL,'2024-05-23 15:58:46','2024-05-23 15:58:46',NULL),(3112,7812,881,40825,4562,15,136,1,257.34,NULL,'2024-05-23 15:58:46','2024-05-23 15:58:46',NULL),(3113,7812,882,40825,4563,3,217,1,1008264.48,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3114,7812,882,40825,4563,3,68,1,211735.54,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3115,7812,882,40825,4563,3,217,1,-0.02,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3116,7812,882,40825,4563,3,57,2,1220000.00,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3117,7812,883,40825,4563,3,217,1,38670.41,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3118,7812,883,40825,4563,3,68,1,8120.79,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3119,7812,883,40825,4563,3,217,1,3217.64,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3120,7812,883,40825,4563,3,57,2,50008.84,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3121,7812,884,40825,4563,3,250,1,0.00,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3122,7812,884,40825,4563,3,250,1,32900.00,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3123,7812,884,40825,4563,3,57,2,32900.00,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3124,7812,885,40825,4563,3,217,1,152892.56,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3125,7812,885,40825,4563,3,68,1,32107.44,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3126,7812,885,40825,4563,3,57,2,185000.00,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3127,7812,886,40825,4563,3,217,1,26033.06,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3128,7812,886,40825,4563,3,68,1,5466.94,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3129,7812,886,40825,4563,3,57,2,31500.00,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3130,7812,887,40825,4563,3,250,1,0.00,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3131,7812,887,40825,4563,3,250,1,431837.40,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL);
INSERT INTO `balance_libro_details` VALUES (3132,7812,887,40825,4563,3,57,2,431837.40,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3133,7812,888,40825,4563,3,217,1,61101.10,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3134,7812,888,40825,4563,3,68,1,12831.23,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3135,7812,888,40825,4563,3,217,1,5069.67,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3136,7812,888,40825,4563,3,57,2,79002.00,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3137,7812,889,40825,4563,3,217,1,320082.67,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3138,7812,889,40825,4563,3,68,1,67217.36,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3139,7812,889,40825,4563,3,217,1,-0.02,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3140,7812,889,40825,4563,3,57,2,387300.01,NULL,'2024-05-23 16:00:34','2024-05-23 16:00:34',NULL),(3141,7812,890,40825,4563,3,250,1,0.00,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3142,7812,890,40825,4563,3,250,1,100477.41,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3143,7812,890,40825,4563,3,57,2,100477.41,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3144,7812,891,40825,4563,3,217,1,175267.08,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3145,7812,891,40825,4563,3,68,1,36806.09,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3146,7812,891,40825,4563,3,217,1,17943.80,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3147,7812,891,40825,4563,3,57,2,230016.97,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3148,7812,892,40825,4563,3,217,1,117272.73,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3149,7812,892,40825,4563,3,68,1,24627.27,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3150,7812,892,40825,4563,3,57,2,141900.00,NULL,'2024-05-23 16:00:35','2024-05-23 16:00:35',NULL),(3151,7812,893,40825,4563,15,68,2,398912.66,NULL,'2024-05-23 16:21:04','2024-05-23 16:21:04',NULL),(3152,7812,893,40825,4563,15,354,2,388885.04,NULL,'2024-05-23 16:21:04','2024-05-23 16:21:04',NULL),(3153,7812,893,40825,4563,15,353,1,398912.66,NULL,'2024-05-23 16:21:04','2024-05-23 16:21:04',NULL),(3154,7812,893,40825,4563,15,354,1,388885.04,NULL,'2024-05-23 16:21:04','2024-05-23 16:21:04',NULL),(3155,7812,894,40720,1565,3,217,1,13680.69,NULL,'2024-05-26 09:43:07','2024-05-26 09:43:07',NULL),(3156,7812,894,40720,1565,3,68,1,2872.94,NULL,'2024-05-26 09:43:07','2024-05-26 09:43:07',NULL),(3157,7812,894,40720,1565,3,221,1,444.36,NULL,'2024-05-26 09:43:07','2024-05-26 09:43:07',NULL),(3158,7812,894,40720,1565,3,57,2,16997.99,NULL,'2024-05-26 09:43:07','2024-05-26 09:43:07',NULL),(3159,7812,895,40720,1565,3,217,1,47670.77,NULL,'2024-05-26 09:43:51','2024-05-26 09:43:51',NULL),(3160,7812,895,40720,1565,3,68,1,10010.86,NULL,'2024-05-26 09:43:51','2024-05-26 09:43:51',NULL),(3161,7812,895,40720,1565,3,221,1,3019.37,NULL,'2024-05-26 09:43:51','2024-05-26 09:43:51',NULL),(3162,7812,895,40720,1565,3,57,2,60701.00,NULL,'2024-05-26 09:43:51','2024-05-26 09:43:51',NULL),(3163,7812,896,40720,1565,3,217,1,74377.40,NULL,'2024-05-26 09:45:11','2024-05-26 09:45:11',NULL),(3164,7812,896,40720,1565,3,68,1,15619.25,NULL,'2024-05-26 09:45:11','2024-05-26 09:45:11',NULL),(3165,7812,896,40720,1565,3,221,1,5018.36,NULL,'2024-05-26 09:45:11','2024-05-26 09:45:11',NULL),(3166,7812,896,40720,1565,3,57,2,95015.01,NULL,'2024-05-26 09:45:11','2024-05-26 09:45:11',NULL),(3167,7812,897,40720,1565,3,217,1,41322.31,NULL,'2024-05-26 09:46:15','2024-05-26 09:46:15',NULL),(3168,7812,897,40720,1565,3,68,1,8677.69,NULL,'2024-05-26 09:46:15','2024-05-26 09:46:15',NULL),(3169,7812,897,40720,1565,3,57,2,50000.00,NULL,'2024-05-26 09:46:15','2024-05-26 09:46:15',NULL),(3170,7812,898,40720,1565,3,217,1,124898.41,NULL,'2024-05-26 09:49:08','2024-05-26 09:49:08',NULL),(3171,7812,898,40720,1565,3,68,1,26228.67,NULL,'2024-05-26 09:49:08','2024-05-26 09:49:08',NULL),(3172,7812,898,40720,1565,3,221,1,2953.93,NULL,'2024-05-26 09:49:08','2024-05-26 09:49:08',NULL);
INSERT INTO `balance_libro_details` VALUES (3173,7812,898,40720,1565,3,57,2,154081.01,NULL,'2024-05-26 09:49:08','2024-05-26 09:49:08',NULL),(3174,7812,899,40720,1565,3,217,1,81028.71,NULL,'2024-05-26 09:50:23','2024-05-26 09:50:23',NULL),(3175,7812,899,40720,1565,3,68,1,17016.03,NULL,'2024-05-26 09:50:23','2024-05-26 09:50:23',NULL),(3176,7812,899,40720,1565,3,221,1,1969.22,NULL,'2024-05-26 09:50:23','2024-05-26 09:50:23',NULL),(3177,7812,899,40720,1565,3,57,2,100013.96,NULL,'2024-05-26 09:50:23','2024-05-26 09:50:23',NULL),(3178,7812,900,40720,1565,3,217,1,321251.44,NULL,'2024-05-26 09:51:08','2024-05-26 09:51:08',NULL),(3179,7812,900,40720,1565,3,68,1,67462.80,NULL,'2024-05-26 09:51:08','2024-05-26 09:51:08',NULL),(3180,7812,900,40720,1565,3,221,1,7597.81,NULL,'2024-05-26 09:51:08','2024-05-26 09:51:08',NULL),(3181,7812,900,40720,1565,3,57,2,396312.05,NULL,'2024-05-26 09:51:08','2024-05-26 09:51:08',NULL),(3182,7812,901,40720,1565,3,217,1,34050.19,NULL,'2024-05-26 09:52:13','2024-05-26 09:52:13',NULL),(3183,7812,901,40720,1565,3,68,1,7150.54,NULL,'2024-05-26 09:52:13','2024-05-26 09:52:13',NULL),(3184,7812,901,40720,1565,3,221,1,805.31,NULL,'2024-05-26 09:52:13','2024-05-26 09:52:13',NULL),(3185,7812,901,40720,1565,3,57,2,42006.04,NULL,'2024-05-26 09:52:13','2024-05-26 09:52:13',NULL),(3186,7812,902,40720,1565,3,217,1,24022.65,NULL,'2024-05-26 09:53:22','2024-05-26 09:53:22',NULL),(3187,7812,902,40720,1565,3,68,1,5044.76,NULL,'2024-05-26 09:53:22','2024-05-26 09:53:22',NULL),(3188,7812,902,40720,1565,3,221,1,937.57,NULL,'2024-05-26 09:53:22','2024-05-26 09:53:22',NULL),(3189,7812,902,40720,1565,3,57,2,30004.98,NULL,'2024-05-26 09:53:22','2024-05-26 09:53:22',NULL),(3190,7812,903,40720,1565,15,67,1,202377.32,NULL,'2024-05-26 10:04:51','2024-05-26 10:04:51',NULL),(3191,7812,903,40720,1565,15,68,2,240246.20,NULL,'2024-05-26 10:04:51','2024-05-26 10:04:51',NULL),(3192,7812,903,40720,1565,15,353,2,62826.59,NULL,'2024-05-26 10:04:51','2024-05-26 10:04:51',NULL),(3193,7812,903,40720,1565,15,353,1,100695.47,NULL,'2024-05-26 10:04:51','2024-05-26 10:04:51',NULL),(3194,7812,904,40720,1566,3,217,1,131822.31,NULL,'2024-05-26 10:11:54','2024-05-26 10:11:54',NULL),(3195,7812,904,40720,1566,3,68,1,27682.69,NULL,'2024-05-26 10:11:54','2024-05-26 10:11:54',NULL),(3196,7812,904,40720,1566,3,221,1,6995.00,NULL,'2024-05-26 10:11:54','2024-05-26 10:11:54',NULL),(3197,7812,904,40720,1566,3,57,2,166500.00,NULL,'2024-05-26 10:11:54','2024-05-26 10:11:54',NULL),(3198,7812,905,40720,1566,3,217,1,11688.02,NULL,'2024-05-26 10:12:38','2024-05-26 10:12:38',NULL),(3199,7812,905,40720,1566,3,68,1,2454.48,NULL,'2024-05-26 10:12:38','2024-05-26 10:12:38',NULL),(3200,7812,905,40720,1566,3,221,1,857.48,NULL,'2024-05-26 10:12:38','2024-05-26 10:12:38',NULL),(3201,7812,905,40720,1566,3,57,2,14999.98,NULL,'2024-05-26 10:12:38','2024-05-26 10:12:38',NULL),(3202,7812,906,40720,1566,3,217,1,79153.73,NULL,'2024-05-26 10:13:34','2024-05-26 10:13:34',NULL),(3203,7812,906,40720,1566,3,68,1,16622.28,NULL,'2024-05-26 10:13:34','2024-05-26 10:13:34',NULL),(3204,7812,906,40720,1566,3,221,1,4224.03,NULL,'2024-05-26 10:13:34','2024-05-26 10:13:34',NULL),(3205,7812,906,40720,1566,3,57,2,100000.04,NULL,'2024-05-26 10:13:34','2024-05-26 10:13:34',NULL),(3206,7812,907,40720,1566,3,217,1,15390.31,NULL,'2024-05-26 10:14:17','2024-05-26 10:14:17',NULL),(3207,7812,907,40720,1566,3,68,1,3231.97,NULL,'2024-05-26 10:14:17','2024-05-26 10:14:17',NULL),(3208,7812,907,40720,1566,3,221,1,1377.77,NULL,'2024-05-26 10:14:17','2024-05-26 10:14:17',NULL),(3209,7812,907,40720,1566,3,57,2,20000.05,NULL,'2024-05-26 10:14:17','2024-05-26 10:14:17',NULL),(3210,7812,908,40720,1566,3,217,1,146469.24,NULL,'2024-05-26 10:15:07','2024-05-26 10:15:07',NULL),(3211,7812,908,40720,1566,3,68,1,30758.54,NULL,'2024-05-26 10:15:07','2024-05-26 10:15:07',NULL),(3212,7812,908,40720,1566,3,221,1,7772.22,NULL,'2024-05-26 10:15:07','2024-05-26 10:15:07',NULL),(3213,7812,908,40720,1566,3,57,2,185000.00,NULL,'2024-05-26 10:15:07','2024-05-26 10:15:07',NULL);
INSERT INTO `balance_libro_details` VALUES (3214,7812,909,40720,1566,3,217,1,79153.73,NULL,'2024-05-26 10:15:58','2024-05-26 10:15:58',NULL),(3215,7812,909,40720,1566,3,68,1,16622.28,NULL,'2024-05-26 10:15:58','2024-05-26 10:15:58',NULL),(3216,7812,909,40720,1566,3,221,1,4224.03,NULL,'2024-05-26 10:15:58','2024-05-26 10:15:58',NULL),(3217,7812,909,40720,1566,3,57,2,100000.04,NULL,'2024-05-26 10:15:58','2024-05-26 10:15:58',NULL),(3218,7812,910,40720,1566,3,217,1,19237.83,NULL,'2024-05-26 10:16:53','2024-05-26 10:16:53',NULL),(3219,7812,910,40720,1566,3,68,1,4039.94,NULL,'2024-05-26 10:16:53','2024-05-26 10:16:53',NULL),(3220,7812,910,40720,1566,3,221,1,1722.21,NULL,'2024-05-26 10:16:53','2024-05-26 10:16:53',NULL),(3221,7812,910,40720,1566,3,57,2,24999.98,NULL,'2024-05-26 10:16:53','2024-05-26 10:16:53',NULL),(3222,7812,911,40720,1566,3,217,1,102899.77,NULL,'2024-05-26 10:17:35','2024-05-26 10:17:35',NULL),(3223,7812,911,40720,1566,3,68,1,21608.95,NULL,'2024-05-26 10:17:35','2024-05-26 10:17:35',NULL),(3224,7812,911,40720,1566,3,221,1,5491.24,NULL,'2024-05-26 10:17:35','2024-05-26 10:17:35',NULL),(3225,7812,911,40720,1566,3,57,2,129999.96,NULL,'2024-05-26 10:17:35','2024-05-26 10:17:35',NULL),(3226,7812,912,40720,1566,3,217,1,98968.29,NULL,'2024-05-26 10:18:22','2024-05-26 10:18:22',NULL),(3227,7812,912,40720,1566,3,68,1,20783.34,NULL,'2024-05-26 10:18:22','2024-05-26 10:18:22',NULL),(3228,7812,912,40720,1566,3,221,1,5281.43,NULL,'2024-05-26 10:18:22','2024-05-26 10:18:22',NULL),(3229,7812,912,40720,1566,3,57,2,125033.06,NULL,'2024-05-26 10:18:22','2024-05-26 10:18:22',NULL),(3230,7812,913,40720,1566,3,217,1,79167.12,NULL,'2024-05-26 10:19:02','2024-05-26 10:19:02',NULL),(3231,7812,913,40720,1566,3,68,1,16625.10,NULL,'2024-05-26 10:19:02','2024-05-26 10:19:02',NULL),(3232,7812,913,40720,1566,3,221,1,4224.75,NULL,'2024-05-26 10:19:02','2024-05-26 10:19:02',NULL),(3233,7812,913,40720,1566,3,57,2,100016.97,NULL,'2024-05-26 10:19:02','2024-05-26 10:19:02',NULL),(3234,7812,914,40720,1566,3,217,1,103090.15,NULL,'2024-05-26 10:19:47','2024-05-26 10:19:47',NULL),(3235,7812,914,40720,1566,3,68,1,21648.93,NULL,'2024-05-26 10:19:47','2024-05-26 10:19:47',NULL),(3236,7812,914,40720,1566,3,221,1,5268.87,NULL,'2024-05-26 10:19:47','2024-05-26 10:19:47',NULL),(3237,7812,914,40720,1566,3,57,2,130007.95,NULL,'2024-05-26 10:19:47','2024-05-26 10:19:47',NULL),(3238,7812,915,40720,1566,3,217,1,34299.95,NULL,'2024-05-26 10:20:24','2024-05-26 10:20:24',NULL),(3239,7812,915,40720,1566,3,68,1,7202.99,NULL,'2024-05-26 10:20:24','2024-05-26 10:20:24',NULL),(3240,7812,915,40720,1566,3,221,1,1497.11,NULL,'2024-05-26 10:20:24','2024-05-26 10:20:24',NULL),(3241,7812,915,40720,1566,3,57,2,43000.05,NULL,'2024-05-26 10:20:24','2024-05-26 10:20:24',NULL),(3242,7812,916,40720,1566,3,217,1,36888.77,NULL,'2024-05-26 10:21:31','2024-05-26 10:21:31',NULL),(3243,7812,916,40720,1566,3,68,1,7746.64,NULL,'2024-05-26 10:21:31','2024-05-26 10:21:31',NULL),(3244,7812,916,40720,1566,3,221,1,1968.57,NULL,'2024-05-26 10:21:31','2024-05-26 10:21:31',NULL),(3245,7812,916,40720,1566,3,57,2,46603.98,NULL,'2024-05-26 10:21:31','2024-05-26 10:21:31',NULL),(3246,7812,917,40720,1566,3,217,1,34681.19,NULL,'2024-05-26 10:22:11','2024-05-26 10:22:11',NULL),(3247,7812,917,40720,1566,3,68,1,7283.05,NULL,'2024-05-26 10:22:11','2024-05-26 10:22:11',NULL),(3248,7812,917,40720,1566,3,221,1,1850.76,NULL,'2024-05-26 10:22:11','2024-05-26 10:22:11',NULL),(3249,7812,917,40720,1566,3,57,2,43815.00,NULL,'2024-05-26 10:22:11','2024-05-26 10:22:11',NULL),(3250,7812,918,40720,1566,3,217,1,231299.78,NULL,'2024-05-26 10:23:05','2024-05-26 10:23:05',NULL),(3251,7812,918,40720,1566,3,68,1,48572.95,NULL,'2024-05-26 10:23:05','2024-05-26 10:23:05',NULL),(3252,7812,918,40720,1566,3,221,1,5131.31,NULL,'2024-05-26 10:23:05','2024-05-26 10:23:05',NULL),(3253,7812,918,40720,1566,3,57,2,285004.04,NULL,'2024-05-26 10:23:05','2024-05-26 10:23:05',NULL),(3254,7812,919,40720,1566,3,217,1,237461.11,NULL,'2024-05-26 10:26:19','2024-05-26 10:26:19',NULL);
INSERT INTO `balance_libro_details` VALUES (3255,7812,919,40720,1566,3,68,1,49866.83,NULL,'2024-05-26 10:26:19','2024-05-26 10:26:19',NULL),(3256,7812,919,40720,1566,3,221,1,12672.10,NULL,'2024-05-26 10:26:19','2024-05-26 10:26:19',NULL),(3257,7812,919,40720,1566,3,57,2,300000.04,NULL,'2024-05-26 10:26:19','2024-05-26 10:26:19',NULL),(3258,7812,920,40720,1566,15,68,2,302750.97,NULL,'2024-05-26 11:00:06','2024-05-26 11:00:06',NULL),(3259,7812,920,40720,1566,15,353,2,100695.47,NULL,'2024-05-26 11:00:06','2024-05-26 11:00:06',NULL),(3260,7812,920,40720,1566,15,353,1,403446.44,NULL,'2024-05-26 11:00:06','2024-05-26 11:00:06',NULL),(3261,7812,921,40825,4564,3,217,1,24457.55,NULL,'2024-06-18 16:46:27','2024-06-18 16:46:27',NULL),(3262,7812,921,40825,4564,3,68,1,5136.09,NULL,'2024-06-18 16:46:27','2024-06-18 16:46:27',NULL),(3263,7812,921,40825,4564,3,221,1,406.31,NULL,'2024-06-18 16:46:27','2024-06-18 16:46:27',NULL),(3264,7812,921,40825,4564,3,57,2,29999.95,NULL,'2024-06-18 16:46:27','2024-06-18 16:46:27',NULL),(3265,7812,922,40825,4564,3,217,1,70930.27,NULL,'2024-06-18 16:47:05','2024-06-18 16:47:05',NULL),(3266,7812,922,40825,4564,3,68,1,14895.36,NULL,'2024-06-18 16:47:05','2024-06-18 16:47:05',NULL),(3267,7812,922,40825,4564,3,221,1,1178.36,NULL,'2024-06-18 16:47:05','2024-06-18 16:47:05',NULL),(3268,7812,922,40825,4564,3,57,2,87003.99,NULL,'2024-06-18 16:47:05','2024-06-18 16:47:05',NULL),(3269,7812,923,40825,4564,3,217,1,16305.03,NULL,'2024-06-18 16:47:55','2024-06-18 16:47:55',NULL),(3270,7812,923,40825,4564,3,68,1,3424.06,NULL,'2024-06-18 16:47:55','2024-06-18 16:47:55',NULL),(3271,7812,923,40825,4564,3,221,1,270.87,NULL,'2024-06-18 16:47:55','2024-06-18 16:47:55',NULL),(3272,7812,923,40825,4564,3,57,2,19999.96,NULL,'2024-06-18 16:47:55','2024-06-18 16:47:55',NULL),(3273,7812,924,40825,4564,3,217,1,40846.44,NULL,'2024-06-18 16:49:33','2024-06-18 16:49:33',NULL),(3274,7812,924,40825,4564,3,68,1,8577.75,NULL,'2024-06-18 16:49:33','2024-06-18 16:49:33',NULL),(3275,7812,924,40825,4564,3,221,1,575.70,NULL,'2024-06-18 16:49:33','2024-06-18 16:49:33',NULL),(3276,7812,924,40825,4564,3,57,2,49999.89,NULL,'2024-06-18 16:49:33','2024-06-18 16:49:33',NULL),(3277,7812,925,40825,4564,3,217,1,66041.58,NULL,'2024-06-18 16:52:25','2024-06-18 16:52:25',NULL),(3278,7812,925,40825,4564,3,68,1,13868.73,NULL,'2024-06-18 16:52:25','2024-06-18 16:52:25',NULL),(3279,7812,925,40825,4564,3,221,1,5135.74,NULL,'2024-06-18 16:52:25','2024-06-18 16:52:25',NULL),(3280,7812,925,40825,4564,3,57,2,85046.05,NULL,'2024-06-18 16:52:25','2024-06-18 16:52:25',NULL),(3281,7812,926,40825,4564,3,217,1,229742.79,NULL,'2024-06-18 16:54:26','2024-06-18 16:54:26',NULL),(3282,7812,926,40825,4564,3,68,1,48245.99,NULL,'2024-06-18 16:54:26','2024-06-18 16:54:26',NULL),(3283,7812,926,40825,4564,3,221,1,22011.22,NULL,'2024-06-18 16:54:26','2024-06-18 16:54:26',NULL),(3284,7812,926,40825,4564,3,57,2,300000.00,NULL,'2024-06-18 16:54:26','2024-06-18 16:54:26',NULL),(3285,7812,927,40825,4564,3,217,1,153161.85,NULL,'2024-06-18 16:55:02','2024-06-18 16:55:02',NULL),(3286,7812,927,40825,4564,3,68,1,32163.99,NULL,'2024-06-18 16:55:02','2024-06-18 16:55:02',NULL),(3287,7812,927,40825,4564,3,221,1,14674.15,NULL,'2024-06-18 16:55:02','2024-06-18 16:55:02',NULL),(3288,7812,927,40825,4564,3,57,2,199999.99,NULL,'2024-06-18 16:55:03','2024-06-18 16:55:03',NULL),(3289,7812,928,40825,4564,2,96,2,542872.00,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3290,7812,928,40825,4564,2,67,2,114003.12,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3291,7812,928,40825,4564,2,218,2,-0.02,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3292,7812,928,40825,4564,2,13,1,656875.10,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3293,7812,929,40825,4564,2,96,2,541178.67,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3294,7812,929,40825,4564,2,67,2,113647.52,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3295,7812,929,40825,4564,2,218,2,0.01,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL);
INSERT INTO `balance_libro_details` VALUES (3296,7812,929,40825,4564,2,13,1,654826.20,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3297,7812,930,40825,4564,2,96,2,560820.95,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3298,7812,930,40825,4564,2,67,2,117772.40,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3299,7812,930,40825,4564,2,218,2,0.01,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3300,7812,930,40825,4564,2,13,1,678593.36,NULL,'2024-06-18 16:58:25','2024-06-18 16:58:25',NULL),(3301,7812,931,40825,4564,2,96,2,506398.67,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3302,7812,931,40825,4564,2,67,2,106343.72,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3303,7812,931,40825,4564,2,218,2,0.01,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3304,7812,931,40825,4564,2,13,1,612742.40,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3305,7812,932,40825,4564,2,96,2,517456.86,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3306,7812,932,40825,4564,2,67,2,108665.94,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3307,7812,932,40825,4564,2,218,2,-0.02,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3308,7812,932,40825,4564,2,13,1,626122.78,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3309,7812,933,40825,4564,2,96,2,541524.62,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3310,7812,933,40825,4564,2,67,2,113720.17,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3311,7812,933,40825,4564,2,218,2,-0.02,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3312,7812,933,40825,4564,2,13,1,655244.77,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3313,7812,934,40825,4564,2,96,2,953680.00,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3314,7812,934,40825,4564,2,67,2,200272.80,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3315,7812,934,40825,4564,2,13,1,1153952.80,NULL,'2024-06-18 16:58:26','2024-06-18 16:58:26',NULL),(3316,7812,935,40720,1567,2,96,2,650388.19,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3317,7812,935,40720,1567,2,67,2,136581.52,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3318,7812,935,40720,1567,2,218,2,0.01,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3319,7812,935,40720,1567,2,13,1,786969.72,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3320,7812,936,40720,1567,2,96,2,664473.05,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3321,7812,936,40720,1567,2,67,2,139539.34,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3322,7812,936,40720,1567,2,218,2,-0.01,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3323,7812,936,40720,1567,2,13,1,804012.38,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3324,7812,937,40720,1567,2,96,2,684771.76,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3325,7812,937,40720,1567,2,67,2,143802.07,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3326,7812,937,40720,1567,2,218,2,0.02,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3327,7812,937,40720,1567,2,13,1,828573.85,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3328,7812,938,40720,1567,2,96,2,657430.62,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3329,7812,938,40720,1567,2,67,2,138060.43,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3330,7812,938,40720,1567,2,13,1,795491.05,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3331,7812,939,40720,1567,2,96,2,634646.33,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3332,7812,939,40720,1567,2,67,2,133275.73,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3333,7812,939,40720,1567,2,218,2,-0.01,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3334,7812,939,40720,1567,2,13,1,767922.05,NULL,'2024-06-23 15:57:33','2024-06-23 15:57:33',NULL),(3335,7812,940,40720,1567,2,96,2,953960.00,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3336,7812,940,40720,1567,2,67,2,200331.60,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL);
INSERT INTO `balance_libro_details` VALUES (3337,7812,940,40720,1567,2,13,1,1154291.60,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3338,7812,941,40720,1567,2,96,2,204000.00,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3339,7812,941,40720,1567,2,67,2,42840.00,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3340,7812,941,40720,1567,2,13,1,246840.00,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3341,7812,942,40720,1567,2,96,2,100560.00,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3342,7812,942,40720,1567,2,67,2,21117.60,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3343,7812,942,40720,1567,2,13,1,121677.60,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3344,7812,943,40720,1567,2,96,2,745500.00,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3345,7812,943,40720,1567,2,67,2,156555.00,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3346,7812,943,40720,1567,2,13,1,902055.00,NULL,'2024-06-23 15:57:34','2024-06-23 15:57:34',NULL),(3347,7812,944,40720,1567,3,217,1,27645.79,NULL,'2024-06-23 15:57:49','2024-07-09 10:15:10','2024-07-09 10:15:10'),(3348,7812,944,40720,1567,3,68,1,3620.20,NULL,'2024-06-23 15:57:49','2024-07-09 10:15:10','2024-07-09 10:15:10'),(3349,7812,944,40720,1567,3,57,2,31265.99,NULL,'2024-06-23 15:57:49','2024-07-09 10:15:10','2024-07-09 10:15:10'),(3350,7812,945,40720,1567,3,250,1,0.00,NULL,'2024-06-23 15:57:49','2024-07-09 10:15:34','2024-07-09 10:15:34'),(3351,7812,945,40720,1567,3,250,1,54999.00,NULL,'2024-06-23 15:57:49','2024-07-09 10:15:34','2024-07-09 10:15:34'),(3352,7812,945,40720,1567,3,57,2,54999.00,NULL,'2024-06-23 15:57:49','2024-07-09 10:15:34','2024-07-09 10:15:34'),(3353,7812,946,40720,1567,3,250,1,0.00,NULL,'2024-06-23 15:57:49','2024-07-09 10:15:51','2024-07-09 10:15:51'),(3354,7812,946,40720,1567,3,250,1,66499.00,NULL,'2024-06-23 15:57:49','2024-07-09 10:15:51','2024-07-09 10:15:51'),(3355,7812,946,40720,1567,3,57,2,66499.00,NULL,'2024-06-23 15:57:49','2024-07-09 10:15:51','2024-07-09 10:15:51'),(3356,7812,947,40720,1567,3,217,1,14554.04,NULL,'2024-06-23 15:57:49','2024-07-09 10:16:26','2024-07-09 10:16:26'),(3357,7812,947,40720,1567,3,68,1,3056.35,NULL,'2024-06-23 15:57:49','2024-07-09 10:16:26','2024-07-09 10:16:26'),(3358,7812,947,40720,1567,3,217,1,2389.59,NULL,'2024-06-23 15:57:49','2024-07-09 10:16:26','2024-07-09 10:16:26'),(3359,7812,947,40720,1567,3,57,2,19999.98,NULL,'2024-06-23 15:57:49','2024-07-09 10:16:26','2024-07-09 10:16:26'),(3360,7812,948,40720,1567,3,217,1,26446.29,NULL,'2024-06-23 15:57:49','2024-07-09 10:16:48','2024-07-09 10:16:48'),(3361,7812,948,40720,1567,3,68,1,5553.72,NULL,'2024-06-23 15:57:49','2024-07-09 10:16:48','2024-07-09 10:16:48'),(3362,7812,948,40720,1567,3,217,1,-0.01,NULL,'2024-06-23 15:57:49','2024-07-09 10:16:48','2024-07-09 10:16:48'),(3363,7812,948,40720,1567,3,57,2,32000.00,NULL,'2024-06-23 15:57:49','2024-07-09 10:16:48','2024-07-09 10:16:48'),(3364,7812,949,40720,1567,3,250,1,120000.00,NULL,'2024-06-23 15:57:50','2024-07-09 10:17:05','2024-07-09 10:17:05'),(3365,7812,949,40720,1567,3,57,2,120000.00,NULL,'2024-06-23 15:57:50','2024-07-09 10:17:05','2024-07-09 10:17:05'),(3366,7812,950,40720,1567,3,217,2,38367.77,NULL,'2024-06-23 15:57:50','2024-07-09 10:17:19','2024-07-09 10:17:19'),(3367,7812,950,40720,1567,3,67,2,8057.23,NULL,'2024-06-23 15:57:50','2024-07-09 10:17:19','2024-07-09 10:17:19'),(3368,7812,950,40720,1567,3,57,1,46425.00,NULL,'2024-06-23 15:57:50','2024-07-09 10:17:19','2024-07-09 10:17:19'),(3369,7812,951,40720,1567,3,217,1,70480.84,NULL,'2024-06-23 16:06:12','2024-06-23 16:06:12',NULL),(3370,7812,951,40720,1567,3,68,1,14800.98,NULL,'2024-06-23 16:06:12','2024-06-23 16:06:12',NULL),(3371,7812,951,40720,1567,3,221,1,3761.21,NULL,'2024-06-23 16:06:12','2024-06-23 16:06:12',NULL),(3372,7812,951,40720,1567,3,57,2,89043.03,NULL,'2024-06-23 16:06:12','2024-06-23 16:06:12',NULL),(3373,7812,952,40720,1567,3,217,1,142296.94,NULL,'2024-06-23 16:06:55','2024-06-23 16:06:55',NULL);
INSERT INTO `balance_libro_details` VALUES (3374,7812,952,40720,1567,3,68,1,29882.36,NULL,'2024-06-23 16:06:55','2024-06-23 16:06:55',NULL),(3375,7812,952,40720,1567,3,221,1,7593.67,NULL,'2024-06-23 16:06:55','2024-06-23 16:06:55',NULL),(3376,7812,952,40720,1567,3,57,2,179772.97,NULL,'2024-06-23 16:06:55','2024-06-23 16:06:55',NULL),(3377,7812,953,40720,1567,3,217,1,20126.15,NULL,'2024-06-23 16:07:46','2024-06-23 16:07:46',NULL),(3378,7812,953,40720,1567,3,68,1,4226.49,NULL,'2024-06-23 16:07:46','2024-06-23 16:07:46',NULL),(3379,7812,953,40720,1567,3,221,1,1655.39,NULL,'2024-06-23 16:07:46','2024-06-23 16:07:46',NULL),(3380,7812,953,40720,1567,3,57,2,26008.03,NULL,'2024-06-23 16:07:46','2024-06-23 16:07:46',NULL),(3381,7812,954,40720,1567,3,217,1,27228.53,NULL,'2024-06-23 16:08:47','2024-06-23 16:08:47',NULL),(3382,7812,954,40720,1567,3,68,1,5717.99,NULL,'2024-06-23 16:08:47','2024-06-23 16:08:47',NULL),(3383,7812,954,40720,1567,3,221,1,2073.48,NULL,'2024-06-23 16:08:47','2024-06-23 16:08:47',NULL),(3384,7812,954,40720,1567,3,57,2,35020.00,NULL,'2024-06-23 16:08:47','2024-06-23 16:08:47',NULL),(3385,7812,955,40720,1567,3,217,1,31445.33,NULL,'2024-06-23 16:09:43','2024-06-23 16:09:43',NULL),(3386,7812,955,40720,1567,3,68,1,6603.52,NULL,'2024-06-23 16:09:43','2024-06-23 16:09:43',NULL),(3387,7812,955,40720,1567,3,221,1,1951.18,NULL,'2024-06-23 16:09:43','2024-06-23 16:09:43',NULL),(3388,7812,955,40720,1567,3,57,2,40000.03,NULL,'2024-06-23 16:09:43','2024-06-23 16:09:43',NULL),(3389,7812,956,40720,1567,3,217,1,166554.96,NULL,'2024-06-23 16:10:50','2024-06-23 16:10:50',NULL),(3390,7812,956,40720,1567,3,68,1,34976.54,NULL,'2024-06-23 16:10:50','2024-06-23 16:10:50',NULL),(3391,7812,956,40720,1567,3,221,1,13475.44,NULL,'2024-06-23 16:10:50','2024-06-23 16:10:50',NULL),(3392,7812,956,40720,1567,3,57,2,215006.94,NULL,'2024-06-23 16:10:50','2024-06-23 16:10:50',NULL),(3393,7812,957,40720,1567,3,217,1,116087.97,NULL,'2024-06-23 16:12:18','2024-06-23 16:12:18',NULL),(3394,7812,957,40720,1567,3,68,1,24378.47,NULL,'2024-06-23 16:12:18','2024-06-23 16:12:18',NULL),(3395,7812,957,40720,1567,3,221,1,8783.56,NULL,'2024-06-23 16:12:18','2024-06-23 16:12:18',NULL),(3396,7812,957,40720,1567,3,57,2,149250.00,NULL,'2024-06-23 16:12:18','2024-06-23 16:12:18',NULL),(3397,7812,958,40720,1567,3,217,1,24109.93,NULL,'2024-06-23 16:13:06','2024-06-23 16:13:06',NULL),(3398,7812,958,40720,1567,3,68,1,5063.09,NULL,'2024-06-23 16:13:06','2024-06-23 16:13:06',NULL),(3399,7812,958,40720,1567,3,221,1,1835.99,NULL,'2024-06-23 16:13:06','2024-06-23 16:13:06',NULL),(3400,7812,958,40720,1567,3,57,2,31009.01,NULL,'2024-06-23 16:13:06','2024-06-23 16:13:06',NULL),(3401,7812,959,40720,1567,3,217,1,77751.35,NULL,'2024-06-23 16:13:58','2024-06-23 16:13:58',NULL),(3402,7812,959,40720,1567,3,68,1,16327.78,NULL,'2024-06-23 16:13:58','2024-06-23 16:13:58',NULL),(3403,7812,959,40720,1567,3,221,1,5920.84,NULL,'2024-06-23 16:13:58','2024-06-23 16:13:58',NULL),(3404,7812,959,40720,1567,3,57,2,99999.97,NULL,'2024-06-23 16:13:58','2024-06-23 16:13:58',NULL),(3405,7812,960,40720,1567,3,217,1,77923.78,NULL,'2024-06-23 16:14:43','2024-06-23 16:14:43',NULL),(3406,7812,960,40720,1567,3,68,1,16363.99,NULL,'2024-06-23 16:14:43','2024-06-23 16:14:43',NULL),(3407,7812,960,40720,1567,3,221,1,5712.26,NULL,'2024-06-23 16:14:43','2024-06-23 16:14:43',NULL),(3408,7812,960,40720,1567,3,57,2,100000.03,NULL,'2024-06-23 16:14:43','2024-06-23 16:14:43',NULL),(3409,7812,961,40720,1567,3,217,1,42460.03,NULL,'2024-06-23 16:15:58','2024-06-23 16:15:58',NULL),(3410,7812,961,40720,1567,3,68,1,8916.61,NULL,'2024-06-23 16:15:58','2024-06-23 16:15:58',NULL),(3411,7812,961,40720,1567,3,221,1,3233.37,NULL,'2024-06-23 16:15:58','2024-06-23 16:15:58',NULL),(3412,7812,961,40720,1567,3,57,2,54610.01,NULL,'2024-06-23 16:15:58','2024-06-23 16:15:58',NULL),(3413,7812,962,40720,1567,3,217,1,84640.80,NULL,'2024-06-23 16:16:46','2024-06-23 16:16:46',NULL),(3414,7812,962,40720,1567,3,68,1,17774.57,NULL,'2024-06-23 16:16:46','2024-06-23 16:16:46',NULL);
INSERT INTO `balance_libro_details` VALUES (3415,7812,962,40720,1567,3,221,1,7635.68,NULL,'2024-06-23 16:16:46','2024-06-23 16:16:46',NULL),(3416,7812,962,40720,1567,3,57,2,110051.05,NULL,'2024-06-23 16:16:46','2024-06-23 16:16:46',NULL),(3417,7812,963,40720,1567,3,217,1,7467.21,NULL,'2024-06-23 16:19:09','2024-06-23 16:19:09',NULL),(3418,7812,963,40720,1567,3,68,1,1568.11,NULL,'2024-06-23 16:19:09','2024-06-23 16:19:09',NULL),(3419,7812,963,40720,1567,3,221,1,964.70,NULL,'2024-06-23 16:19:09','2024-06-23 16:19:09',NULL),(3420,7812,963,40720,1567,3,57,2,10000.02,NULL,'2024-06-23 16:19:09','2024-06-23 16:19:09',NULL),(3421,7812,964,40720,1567,3,217,1,77757.65,NULL,'2024-06-23 16:20:27','2024-06-23 16:20:27',NULL),(3422,7812,964,40720,1567,3,68,1,16329.11,NULL,'2024-06-23 16:20:27','2024-06-23 16:20:27',NULL),(3423,7812,964,40720,1567,3,221,1,5921.31,NULL,'2024-06-23 16:20:27','2024-06-23 16:20:27',NULL),(3424,7812,964,40720,1567,3,57,2,100008.07,NULL,'2024-06-23 16:20:27','2024-06-23 16:20:27',NULL),(3425,7812,965,40720,1567,3,217,1,97117.76,NULL,'2024-06-23 16:21:16','2024-06-23 16:21:16',NULL),(3426,7812,965,40720,1567,3,68,1,20394.73,NULL,'2024-06-23 16:21:16','2024-06-23 16:21:16',NULL),(3427,7812,965,40720,1567,3,221,1,7118.48,NULL,'2024-06-23 16:21:16','2024-06-23 16:21:16',NULL),(3428,7812,965,40720,1567,3,57,2,124630.97,NULL,'2024-06-23 16:21:16','2024-06-23 16:21:16',NULL),(3429,7812,966,40720,1567,3,217,1,11200.76,NULL,'2024-06-23 16:22:01','2024-06-23 16:22:01',NULL),(3430,7812,966,40720,1567,3,68,1,2352.16,NULL,'2024-06-23 16:22:01','2024-06-23 16:22:01',NULL),(3431,7812,966,40720,1567,3,221,1,1447.04,NULL,'2024-06-23 16:22:01','2024-06-23 16:22:01',NULL),(3432,7812,966,40720,1567,3,57,2,14999.96,NULL,'2024-06-23 16:22:01','2024-06-23 16:22:01',NULL),(3433,7812,967,40720,1567,3,217,1,73132.97,NULL,'2024-06-23 16:22:46','2024-06-23 16:22:46',NULL),(3434,7812,967,40720,1567,3,68,1,15357.92,NULL,'2024-06-23 16:22:46','2024-06-23 16:22:46',NULL),(3435,7812,967,40720,1567,3,221,1,5569.14,NULL,'2024-06-23 16:22:46','2024-06-23 16:22:46',NULL),(3436,7812,967,40720,1567,3,57,2,94060.03,NULL,'2024-06-23 16:22:46','2024-06-23 16:22:46',NULL),(3437,7812,968,40720,1567,3,217,1,81317.21,NULL,'2024-06-23 16:26:24','2024-06-23 16:26:24',NULL),(3438,7812,968,40720,1567,3,68,1,17076.61,NULL,'2024-06-23 16:26:24','2024-06-23 16:26:24',NULL),(3439,7812,968,40720,1567,3,221,1,1606.17,NULL,'2024-06-23 16:26:24','2024-06-23 16:26:24',NULL),(3440,7812,968,40720,1567,3,57,2,99999.99,NULL,'2024-06-23 16:26:24','2024-06-23 16:26:24',NULL),(3441,7812,969,40720,1567,3,217,1,116626.79,NULL,'2024-06-23 16:30:19','2024-06-23 16:30:19',NULL),(3442,7812,969,40720,1567,3,68,1,24491.63,NULL,'2024-06-23 16:30:19','2024-06-23 16:30:19',NULL),(3443,7812,969,40720,1567,3,221,1,8881.24,NULL,'2024-06-23 16:30:19','2024-06-23 16:30:19',NULL),(3444,7812,969,40720,1567,3,136,1,0.39,NULL,'2024-06-23 16:30:19','2024-06-23 16:30:19',NULL),(3445,7812,969,40720,1567,3,57,2,150000.05,NULL,'2024-06-23 16:30:19','2024-06-23 16:30:19',NULL),(3446,7812,970,40720,1567,3,217,1,77751.19,NULL,'2024-06-23 16:31:25','2024-06-23 16:31:25',NULL),(3447,7812,970,40720,1567,3,68,1,16327.75,NULL,'2024-06-23 16:31:25','2024-06-23 16:31:25',NULL),(3448,7812,970,40720,1567,3,221,1,5920.83,NULL,'2024-06-23 16:31:25','2024-06-23 16:31:25',NULL),(3449,7812,970,40720,1567,3,136,1,0.20,NULL,'2024-06-23 16:31:25','2024-06-23 16:31:25',NULL),(3450,7812,970,40720,1567,3,57,2,99999.97,NULL,'2024-06-23 16:31:25','2024-06-23 16:31:25',NULL),(3451,7812,971,40720,1567,3,217,1,8464.65,NULL,'2024-06-23 16:32:55','2024-06-23 16:32:55',NULL),(3452,7812,971,40720,1567,3,68,1,1777.58,NULL,'2024-06-23 16:32:55','2024-06-23 16:32:55',NULL),(3453,7812,971,40720,1567,3,221,1,757.77,NULL,'2024-06-23 16:32:55','2024-06-23 16:32:55',NULL),(3454,7812,971,40720,1567,3,57,2,11000.00,NULL,'2024-06-23 16:32:55','2024-06-23 16:32:55',NULL),(3455,7812,972,40720,1567,3,217,1,15537.19,NULL,'2024-06-23 16:33:49','2024-06-23 16:33:49',NULL);
INSERT INTO `balance_libro_details` VALUES (3456,7812,972,40720,1567,3,68,1,3262.81,NULL,'2024-06-23 16:33:49','2024-06-23 16:33:49',NULL),(3457,7812,972,40720,1567,3,57,2,18800.00,NULL,'2024-06-23 16:33:49','2024-06-23 16:33:49',NULL),(3458,7812,973,40720,1567,2,96,2,15269.67,NULL,'2024-06-23 16:36:22','2024-07-09 10:51:35','2024-07-09 10:51:35'),(3459,7812,973,40720,1567,2,67,2,3206.63,NULL,'2024-06-23 16:36:22','2024-07-09 10:51:35','2024-07-09 10:51:35'),(3460,7812,973,40720,1567,2,1401,2,1525.70,NULL,'2024-06-23 16:36:22','2024-07-09 10:51:35','2024-07-09 10:51:35'),(3461,7812,973,40720,1567,2,13,1,20002.00,NULL,'2024-06-23 16:36:22','2024-07-09 10:51:35','2024-07-09 10:51:35'),(3462,7812,974,40720,1567,2,96,2,5066.51,NULL,'2024-06-23 16:37:00','2024-07-09 10:51:26','2024-07-09 10:51:26'),(3463,7812,974,40720,1567,2,67,2,1063.97,NULL,'2024-06-23 16:37:00','2024-07-09 10:51:26','2024-07-09 10:51:26'),(3464,7812,974,40720,1567,2,1401,2,869.48,NULL,'2024-06-23 16:37:00','2024-07-09 10:51:26','2024-07-09 10:51:26'),(3465,7812,974,40720,1567,2,13,1,6999.96,NULL,'2024-06-23 16:37:00','2024-07-09 10:51:26','2024-07-09 10:51:26'),(3466,7812,975,40720,1567,2,96,2,17370.97,NULL,'2024-06-23 16:37:39','2024-07-09 10:51:17','2024-07-09 10:51:17'),(3467,7812,975,40720,1567,2,67,2,3647.90,NULL,'2024-06-23 16:37:39','2024-07-09 10:51:17','2024-07-09 10:51:17'),(3468,7812,975,40720,1567,2,1401,2,2981.10,NULL,'2024-06-23 16:37:39','2024-07-09 10:51:17','2024-07-09 10:51:17'),(3469,7812,975,40720,1567,2,13,1,23999.97,NULL,'2024-06-23 16:37:39','2024-07-09 10:51:17','2024-07-09 10:51:17'),(3470,7812,976,40720,1567,2,96,2,27504.04,NULL,'2024-06-23 16:38:21','2024-07-09 10:51:08','2024-07-09 10:51:08'),(3471,7812,976,40720,1567,2,67,2,5775.85,NULL,'2024-06-23 16:38:21','2024-07-09 10:51:08','2024-07-09 10:51:08'),(3472,7812,976,40720,1567,2,1401,2,4720.09,NULL,'2024-06-23 16:38:21','2024-07-09 10:51:08','2024-07-09 10:51:08'),(3473,7812,976,40720,1567,2,13,1,37999.98,NULL,'2024-06-23 16:38:21','2024-07-09 10:51:08','2024-07-09 10:51:08'),(3474,7812,977,40720,1567,2,96,2,76340.76,NULL,'2024-06-23 16:38:59','2024-07-09 10:50:54','2024-07-09 10:50:54'),(3475,7812,977,40720,1567,2,67,2,16031.56,NULL,'2024-06-23 16:38:59','2024-07-09 10:50:54','2024-07-09 10:50:54'),(3476,7812,977,40720,1567,2,1401,2,7627.72,NULL,'2024-06-23 16:38:59','2024-07-09 10:50:54','2024-07-09 10:50:54'),(3477,7812,977,40720,1567,2,13,1,100000.04,NULL,'2024-06-23 16:38:59','2024-07-09 10:50:54','2024-07-09 10:50:54'),(3478,7812,978,40720,1567,2,96,2,91612.72,NULL,'2024-06-23 16:39:42','2024-07-09 10:50:41','2024-07-09 10:50:41'),(3479,7812,978,40720,1567,2,67,2,19238.67,NULL,'2024-06-23 16:39:42','2024-07-09 10:50:41','2024-07-09 10:50:41'),(3480,7812,978,40720,1567,2,1401,2,9153.65,NULL,'2024-06-23 16:39:42','2024-07-09 10:50:41','2024-07-09 10:50:41'),(3481,7812,978,40720,1567,2,13,1,120005.04,NULL,'2024-06-23 16:39:42','2024-07-09 10:50:41','2024-07-09 10:50:41'),(3482,7812,979,40720,1567,2,96,2,27761.26,NULL,'2024-06-23 16:41:44','2024-07-09 10:50:29','2024-07-09 10:50:29'),(3483,7812,979,40720,1567,2,67,2,5829.86,NULL,'2024-06-23 16:41:44','2024-07-09 10:50:29','2024-07-09 10:50:29'),(3484,7812,979,40720,1567,2,1401,2,3408.90,NULL,'2024-06-23 16:41:44','2024-07-09 10:50:29','2024-07-09 10:50:29'),(3485,7812,979,40720,1567,2,136,2,0.01,NULL,'2024-06-23 16:41:44','2024-07-09 10:50:29','2024-07-09 10:50:29'),(3486,7812,979,40720,1567,2,13,1,37000.03,NULL,'2024-06-23 16:41:44','2024-07-09 10:50:29','2024-07-09 10:50:29'),(3487,7812,980,40720,1567,2,96,2,7444.26,NULL,'2024-06-23 16:42:50','2024-07-09 10:50:12','2024-07-09 10:50:12'),(3488,7812,980,40720,1567,2,67,2,1563.29,NULL,'2024-06-23 16:42:50','2024-07-09 10:50:12','2024-07-09 10:50:12'),(3489,7812,980,40720,1567,2,1401,2,992.43,NULL,'2024-06-23 16:42:50','2024-07-09 10:50:12','2024-07-09 10:50:12'),(3490,7812,980,40720,1567,2,13,1,9999.98,NULL,'2024-06-23 16:42:50','2024-07-09 10:50:12','2024-07-09 10:50:12');
INSERT INTO `balance_libro_details` VALUES (3491,7812,981,40720,1567,3,217,1,15923.41,NULL,'2024-06-30 19:09:48','2024-06-30 19:09:48',NULL),(3492,7812,981,40720,1567,3,68,1,3343.92,NULL,'2024-06-30 19:09:48','2024-06-30 19:09:48',NULL),(3493,7812,981,40720,1567,3,221,1,2732.68,NULL,'2024-06-30 19:09:48','2024-06-30 19:09:48',NULL),(3494,7812,981,40720,1567,3,57,2,22000.01,NULL,'2024-06-30 19:09:48','2024-06-30 19:09:48',NULL),(3495,7812,982,40720,1567,3,217,1,107225.50,NULL,'2024-06-30 19:10:51','2024-06-30 19:10:51',NULL),(3496,7812,982,40720,1567,3,68,1,22517.36,NULL,'2024-06-30 19:10:51','2024-06-30 19:10:51',NULL),(3497,7812,982,40720,1567,3,221,1,10276.15,NULL,'2024-06-30 19:10:51','2024-06-30 19:10:51',NULL),(3498,7812,982,40720,1567,3,57,2,140019.01,NULL,'2024-06-30 19:10:51','2024-06-30 19:10:51',NULL),(3499,7812,983,40720,1567,3,217,1,7411.44,NULL,'2024-06-30 19:11:44','2024-06-30 19:11:44',NULL),(3500,7812,983,40720,1567,3,68,1,1556.40,NULL,'2024-06-30 19:11:44','2024-06-30 19:11:44',NULL),(3501,7812,983,40720,1567,3,221,1,1032.16,NULL,'2024-06-30 19:11:44','2024-06-30 19:11:44',NULL),(3502,7812,983,40720,1567,3,57,2,10000.00,NULL,'2024-06-30 19:11:44','2024-06-30 19:11:44',NULL),(3503,7812,984,40720,1567,3,217,1,21723.12,NULL,'2024-06-30 19:12:23','2024-06-30 19:12:23',NULL),(3504,7812,984,40720,1567,3,68,1,4561.86,NULL,'2024-06-30 19:12:23','2024-06-30 19:12:23',NULL),(3505,7812,984,40720,1567,3,221,1,3728.00,NULL,'2024-06-30 19:12:23','2024-06-30 19:12:23',NULL),(3506,7812,984,40720,1567,3,57,2,30012.98,NULL,'2024-06-30 19:12:23','2024-06-30 19:12:23',NULL),(3507,7812,985,40720,1567,3,217,1,91650.88,NULL,'2024-06-30 19:13:03','2024-06-30 19:13:03',NULL),(3508,7812,985,40720,1567,3,68,1,19246.68,NULL,'2024-06-30 19:13:03','2024-06-30 19:13:03',NULL),(3509,7812,985,40720,1567,3,221,1,9157.46,NULL,'2024-06-30 19:13:03','2024-06-30 19:13:03',NULL),(3510,7812,985,40720,1567,3,57,2,120055.02,NULL,'2024-06-30 19:13:03','2024-06-30 19:13:03',NULL),(3511,7812,986,40720,1567,3,217,1,191642.74,NULL,'2024-06-30 19:13:37','2024-06-30 19:13:37',NULL),(3512,7812,986,40720,1567,3,68,1,40244.98,NULL,'2024-06-30 19:13:37','2024-06-30 19:13:37',NULL),(3513,7812,986,40720,1567,3,221,1,19148.33,NULL,'2024-06-30 19:13:37','2024-06-30 19:13:37',NULL),(3514,7812,986,40720,1567,3,57,2,251036.05,NULL,'2024-06-30 19:13:37','2024-06-30 19:13:37',NULL),(3515,7812,987,40720,1567,3,217,1,22234.32,NULL,'2024-06-30 19:14:21','2024-06-30 19:14:21',NULL),(3516,7812,987,40720,1567,3,68,1,4669.21,NULL,'2024-06-30 19:14:21','2024-06-30 19:14:21',NULL),(3517,7812,987,40720,1567,3,221,1,3096.48,NULL,'2024-06-30 19:14:21','2024-06-30 19:14:21',NULL),(3518,7812,987,40720,1567,3,57,2,30000.01,NULL,'2024-06-30 19:14:21','2024-06-30 19:14:21',NULL),(3519,7812,988,40720,1567,3,217,1,98347.60,NULL,'2024-06-30 19:15:14','2024-06-30 19:15:14',NULL),(3520,7812,988,40720,1567,3,68,1,20653.00,NULL,'2024-06-30 19:15:14','2024-06-30 19:15:14',NULL),(3521,7812,988,40720,1567,3,221,1,10864.46,NULL,'2024-06-30 19:15:14','2024-06-30 19:15:14',NULL),(3522,7812,988,40720,1567,3,57,2,129865.06,NULL,'2024-06-30 19:15:14','2024-06-30 19:15:14',NULL),(3523,7812,989,40720,1567,3,217,1,11983.48,NULL,'2024-06-30 19:16:09','2024-06-30 19:16:09',NULL),(3524,7812,989,40720,1567,3,68,1,2516.53,NULL,'2024-06-30 19:16:09','2024-06-30 19:16:09',NULL),(3525,7812,989,40720,1567,3,57,2,14500.01,NULL,'2024-06-30 19:16:09','2024-06-30 19:16:09',NULL),(3526,7812,990,40720,1567,3,217,1,23901.73,NULL,'2024-06-30 19:19:06','2024-06-30 19:19:06',NULL),(3527,7812,990,40720,1567,3,68,1,5019.36,NULL,'2024-06-30 19:19:06','2024-06-30 19:19:06',NULL),(3528,7812,990,40720,1567,3,221,1,3087.89,NULL,'2024-06-30 19:19:06','2024-06-30 19:19:06',NULL),(3529,7812,990,40720,1567,3,57,2,32008.98,NULL,'2024-06-30 19:19:06','2024-06-30 19:19:06',NULL),(3530,7812,991,40720,1567,3,217,1,171065.47,NULL,'2024-06-30 19:19:45','2024-06-30 19:19:45',NULL),(3531,7812,991,40720,1567,3,68,1,35923.75,NULL,'2024-06-30 19:19:45','2024-06-30 19:19:45',NULL);
INSERT INTO `balance_libro_details` VALUES (3532,7812,991,40720,1567,3,221,1,13026.79,NULL,'2024-06-30 19:19:45','2024-06-30 19:19:45',NULL),(3533,7812,991,40720,1567,3,57,2,220016.01,NULL,'2024-06-30 19:19:45','2024-06-30 19:19:45',NULL),(3534,7812,992,40720,1567,3,217,1,11200.76,NULL,'2024-06-30 19:20:39','2024-06-30 19:20:39',NULL),(3535,7812,992,40720,1567,3,68,1,2352.16,NULL,'2024-06-30 19:20:39','2024-06-30 19:20:39',NULL),(3536,7812,992,40720,1567,3,221,1,1447.04,NULL,'2024-06-30 19:20:39','2024-06-30 19:20:39',NULL),(3537,7812,992,40720,1567,3,57,2,14999.96,NULL,'2024-06-30 19:20:39','2024-06-30 19:20:39',NULL),(3538,7812,993,40720,1567,3,217,1,7277.06,NULL,'2024-06-30 19:21:46','2024-06-30 19:21:46',NULL),(3539,7812,993,40720,1567,3,68,1,1528.18,NULL,'2024-06-30 19:21:46','2024-06-30 19:21:46',NULL),(3540,7812,993,40720,1567,3,221,1,1194.80,NULL,'2024-06-30 19:21:46','2024-06-30 19:21:46',NULL),(3541,7812,993,40720,1567,3,57,2,10000.04,NULL,'2024-06-30 19:21:46','2024-06-30 19:21:46',NULL),(3542,7812,994,40720,1567,3,217,1,176301.56,NULL,'2024-06-30 19:22:35','2024-06-30 19:22:35',NULL),(3543,7812,994,40720,1567,3,68,1,37023.33,NULL,'2024-06-30 19:22:35','2024-06-30 19:22:35',NULL),(3544,7812,994,40720,1567,3,221,1,16891.12,NULL,'2024-06-30 19:22:35','2024-06-30 19:22:35',NULL),(3545,7812,994,40720,1567,3,57,2,230216.01,NULL,'2024-06-30 19:22:35','2024-06-30 19:22:35',NULL),(3546,7812,995,40720,1567,3,217,1,14554.04,NULL,'2024-06-30 19:23:21','2024-06-30 19:23:21',NULL),(3547,7812,995,40720,1567,3,68,1,3056.35,NULL,'2024-06-30 19:23:21','2024-06-30 19:23:21',NULL),(3548,7812,995,40720,1567,3,221,1,2389.59,NULL,'2024-06-30 19:23:21','2024-06-30 19:23:21',NULL),(3549,7812,995,40720,1567,3,57,2,19999.98,NULL,'2024-06-30 19:23:21','2024-06-30 19:23:21',NULL),(3550,7812,996,40720,1567,3,217,1,34461.45,NULL,'2024-06-30 19:24:30','2024-06-30 19:24:30',NULL),(3551,7812,996,40720,1567,3,68,1,7236.90,NULL,'2024-06-30 19:24:30','2024-06-30 19:24:30',NULL),(3552,7812,996,40720,1567,3,221,1,3301.69,NULL,'2024-06-30 19:24:30','2024-06-30 19:24:30',NULL),(3553,7812,996,40720,1567,3,57,2,45000.04,NULL,'2024-06-30 19:24:30','2024-06-30 19:24:30',NULL),(3554,7812,997,40720,1567,3,217,1,91897.15,NULL,'2024-06-30 19:25:12','2024-06-30 19:25:12',NULL),(3555,7812,997,40720,1567,3,68,1,19298.40,NULL,'2024-06-30 19:25:12','2024-06-30 19:25:12',NULL),(3556,7812,997,40720,1567,3,221,1,8804.49,NULL,'2024-06-30 19:25:12','2024-06-30 19:25:12',NULL),(3557,7812,997,40720,1567,3,57,2,120000.04,NULL,'2024-06-30 19:25:12','2024-06-30 19:25:12',NULL),(3558,7812,998,40720,1567,3,217,1,91932.34,NULL,'2024-06-30 19:25:47','2024-06-30 19:25:47',NULL),(3559,7812,998,40720,1567,3,68,1,19305.79,NULL,'2024-06-30 19:25:48','2024-06-30 19:25:48',NULL),(3560,7812,998,40720,1567,3,221,1,8807.86,NULL,'2024-06-30 19:25:48','2024-06-30 19:25:48',NULL),(3561,7812,998,40720,1567,3,57,2,120045.99,NULL,'2024-06-30 19:25:48','2024-06-30 19:25:48',NULL),(3562,7812,999,40720,1567,3,217,1,10032.91,NULL,'2024-06-30 19:26:30','2024-06-30 19:26:30',NULL),(3563,7812,999,40720,1567,3,68,1,2106.91,NULL,'2024-06-30 19:26:30','2024-06-30 19:26:30',NULL),(3564,7812,999,40720,1567,3,221,1,961.23,NULL,'2024-06-30 19:26:30','2024-06-30 19:26:30',NULL),(3565,7812,999,40720,1567,3,57,2,13101.05,NULL,'2024-06-30 19:26:30','2024-06-30 19:26:30',NULL),(3566,7812,1000,40720,1567,3,217,1,30632.36,NULL,'2024-06-30 19:27:15','2024-06-30 19:27:15',NULL),(3567,7812,1000,40720,1567,3,68,1,6432.80,NULL,'2024-06-30 19:27:15','2024-06-30 19:27:15',NULL),(3568,7812,1000,40720,1567,3,221,1,2934.83,NULL,'2024-06-30 19:27:15','2024-06-30 19:27:15',NULL),(3569,7812,1000,40720,1567,3,57,2,39999.99,NULL,'2024-06-30 19:27:15','2024-06-30 19:27:15',NULL),(3570,7812,1001,40720,1567,3,217,1,31299.24,NULL,'2024-06-30 19:28:02','2024-06-30 19:28:02',NULL),(3571,7812,1001,40720,1567,3,68,1,6572.84,NULL,'2024-06-30 19:28:02','2024-06-30 19:28:02',NULL),(3572,7812,1001,40720,1567,3,221,1,5138.95,NULL,'2024-06-30 19:28:02','2024-06-30 19:28:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3573,7812,1001,40720,1567,3,57,2,43011.03,NULL,'2024-06-30 19:28:02','2024-06-30 19:28:02',NULL),(3574,7812,1002,40720,1567,3,217,1,42125.66,NULL,'2024-06-30 19:28:46','2024-06-30 19:28:46',NULL),(3575,7812,1002,40720,1567,3,68,1,8846.39,NULL,'2024-06-30 19:28:46','2024-06-30 19:28:46',NULL),(3576,7812,1002,40720,1567,3,221,1,4035.98,NULL,'2024-06-30 19:28:46','2024-06-30 19:28:46',NULL),(3577,7812,1002,40720,1567,3,57,2,55008.03,NULL,'2024-06-30 19:28:46','2024-06-30 19:28:46',NULL),(3578,7812,1003,40720,1567,3,217,1,81948.45,NULL,'2024-06-30 19:30:05','2024-06-30 19:30:05',NULL),(3579,7812,1003,40720,1567,3,68,1,17209.17,NULL,'2024-06-30 19:30:05','2024-06-30 19:30:05',NULL),(3580,7812,1003,40720,1567,3,221,1,7851.32,NULL,'2024-06-30 19:30:05','2024-06-30 19:30:05',NULL),(3581,7812,1003,40720,1567,3,57,2,107008.94,NULL,'2024-06-30 19:30:05','2024-06-30 19:30:05',NULL),(3582,7812,1004,40720,1567,3,217,1,22974.25,NULL,'2024-06-30 19:30:48','2024-06-30 19:30:48',NULL),(3583,7812,1004,40720,1567,3,68,1,4824.59,NULL,'2024-06-30 19:30:48','2024-06-30 19:30:48',NULL),(3584,7812,1004,40720,1567,3,221,1,2201.12,NULL,'2024-06-30 19:30:48','2024-06-30 19:30:48',NULL),(3585,7812,1004,40720,1567,3,57,2,29999.96,NULL,'2024-06-30 19:30:48','2024-06-30 19:30:48',NULL),(3586,7812,1005,40720,1567,3,217,1,96881.75,NULL,'2024-06-30 19:31:36','2024-06-30 19:31:36',NULL),(3587,7812,1005,40720,1567,3,68,1,20345.17,NULL,'2024-06-30 19:31:36','2024-06-30 19:31:36',NULL),(3588,7812,1005,40720,1567,3,221,1,9282.06,NULL,'2024-06-30 19:31:36','2024-06-30 19:31:36',NULL),(3589,7812,1005,40720,1567,3,57,2,126508.98,NULL,'2024-06-30 19:31:36','2024-06-30 19:31:36',NULL),(3590,7812,1006,40720,1567,3,217,1,110129.54,NULL,'2024-06-30 19:32:24','2024-06-30 19:32:24',NULL),(3591,7812,1006,40720,1567,3,68,1,23127.20,NULL,'2024-06-30 19:32:24','2024-06-30 19:32:24',NULL),(3592,7812,1006,40720,1567,3,221,1,10551.30,NULL,'2024-06-30 19:32:24','2024-06-30 19:32:24',NULL),(3593,7812,1006,40720,1567,3,57,2,143808.04,NULL,'2024-06-30 19:32:24','2024-06-30 19:32:24',NULL),(3594,7812,1007,40720,1567,3,217,1,76618.43,NULL,'2024-06-30 19:33:15','2024-06-30 19:33:15',NULL),(3595,7812,1007,40720,1567,3,68,1,16089.87,NULL,'2024-06-30 19:33:15','2024-06-30 19:33:15',NULL),(3596,7812,1007,40720,1567,3,221,1,7340.66,NULL,'2024-06-30 19:33:15','2024-06-30 19:33:15',NULL),(3597,7812,1007,40720,1567,3,57,2,100048.96,NULL,'2024-06-30 19:33:15','2024-06-30 19:33:15',NULL),(3598,7812,1008,40720,1567,3,217,1,29844.56,NULL,'2024-06-30 19:34:06','2024-06-30 19:34:06',NULL),(3599,7812,1008,40720,1567,3,68,1,6267.36,NULL,'2024-06-30 19:34:06','2024-06-30 19:34:06',NULL),(3600,7812,1008,40720,1567,3,221,1,4900.11,NULL,'2024-06-30 19:34:06','2024-06-30 19:34:06',NULL),(3601,7812,1008,40720,1567,3,57,2,41012.03,NULL,'2024-06-30 19:34:06','2024-06-30 19:34:06',NULL),(3602,7812,1009,40720,1567,3,217,1,153167.96,NULL,'2024-06-30 19:34:45','2024-06-30 19:34:45',NULL),(3603,7812,1009,40720,1567,3,68,1,32165.27,NULL,'2024-06-30 19:34:45','2024-06-30 19:34:45',NULL),(3604,7812,1009,40720,1567,3,221,1,14674.73,NULL,'2024-06-30 19:34:45','2024-06-30 19:34:45',NULL),(3605,7812,1009,40720,1567,3,57,2,200007.96,NULL,'2024-06-30 19:34:45','2024-06-30 19:34:45',NULL),(3606,7812,1010,40720,1567,3,217,1,114871.40,NULL,'2024-06-30 19:35:33','2024-06-30 19:35:33',NULL),(3607,7812,1010,40720,1567,3,68,1,24122.99,NULL,'2024-06-30 19:35:33','2024-06-30 19:35:33',NULL),(3608,7812,1010,40720,1567,3,221,1,11005.61,NULL,'2024-06-30 19:35:33','2024-06-30 19:35:33',NULL),(3609,7812,1010,40720,1567,3,57,2,150000.00,NULL,'2024-06-30 19:35:33','2024-06-30 19:35:33',NULL),(3610,7812,1011,40720,1567,3,217,1,229742.79,NULL,'2024-06-30 19:36:37','2024-06-30 19:36:37',NULL),(3611,7812,1011,40720,1567,3,68,1,48245.99,NULL,'2024-06-30 19:36:37','2024-06-30 19:36:37',NULL),(3612,7812,1011,40720,1567,3,221,1,22011.22,NULL,'2024-06-30 19:36:37','2024-06-30 19:36:37',NULL);
INSERT INTO `balance_libro_details` VALUES (3613,7812,1011,40720,1567,3,57,2,300000.00,NULL,'2024-06-30 19:36:37','2024-06-30 19:36:37',NULL),(3614,7812,1012,40720,1567,3,217,1,76442.56,NULL,'2024-06-30 19:37:34','2024-06-30 19:37:34',NULL),(3615,7812,1012,40720,1567,3,68,1,16052.94,NULL,'2024-06-30 19:37:34','2024-06-30 19:37:34',NULL),(3616,7812,1012,40720,1567,3,221,1,7504.46,NULL,'2024-06-30 19:37:34','2024-06-30 19:37:34',NULL),(3617,7812,1012,40720,1567,3,57,2,99999.96,NULL,'2024-06-30 19:37:34','2024-06-30 19:37:34',NULL),(3618,7812,1013,40720,1567,3,217,1,7810.08,NULL,'2024-06-30 19:38:49','2024-06-30 19:38:49',NULL),(3619,7812,1013,40720,1567,3,68,1,1640.12,NULL,'2024-06-30 19:38:49','2024-06-30 19:38:49',NULL),(3620,7812,1013,40720,1567,3,57,2,9450.20,NULL,'2024-06-30 19:38:49','2024-06-30 19:38:49',NULL),(3621,7812,1014,40720,1567,3,217,1,145924.98,NULL,'2024-06-30 19:39:28','2024-06-30 19:39:28',NULL),(3622,7812,1014,40720,1567,3,68,1,30644.25,NULL,'2024-06-30 19:39:28','2024-06-30 19:39:28',NULL),(3623,7812,1014,40720,1567,3,221,1,13980.80,NULL,'2024-06-30 19:39:28','2024-06-30 19:39:28',NULL),(3624,7812,1014,40720,1567,3,57,2,190550.03,NULL,'2024-06-30 19:39:28','2024-06-30 19:39:28',NULL),(3625,7812,1015,40825,4564,3,217,1,292942.81,NULL,'2024-07-06 09:24:17','2024-07-06 09:24:17',NULL),(3626,7812,1015,40825,4564,3,68,1,61517.99,NULL,'2024-07-06 09:24:17','2024-07-06 09:24:17',NULL),(3627,7812,1015,40825,4564,3,221,1,5541.90,NULL,'2024-07-06 09:24:17','2024-07-06 09:24:17',NULL),(3628,7812,1015,40825,4564,3,57,2,360002.70,NULL,'2024-07-06 09:24:17','2024-07-06 09:24:17',NULL),(3629,7812,1016,40825,4564,3,217,1,317355.36,NULL,'2024-07-06 09:26:12','2024-07-06 09:26:12',NULL),(3630,7812,1016,40825,4564,3,68,1,66644.63,NULL,'2024-07-06 09:26:12','2024-07-06 09:26:12',NULL),(3631,7812,1016,40825,4564,3,221,1,6003.74,NULL,'2024-07-06 09:26:12','2024-07-06 09:26:12',NULL),(3632,7812,1016,40825,4564,3,57,2,390003.73,NULL,'2024-07-06 09:26:12','2024-07-06 09:26:12',NULL),(3633,7812,1017,40825,4564,3,217,1,229742.78,NULL,'2024-07-06 09:30:10','2024-07-06 09:30:10',NULL),(3634,7812,1017,40825,4564,3,68,1,48245.98,NULL,'2024-07-06 09:30:10','2024-07-06 09:30:10',NULL),(3635,7812,1017,40825,4564,3,221,1,22011.22,NULL,'2024-07-06 09:30:10','2024-07-06 09:30:10',NULL),(3636,7812,1017,40825,4564,3,136,1,0.02,NULL,'2024-07-06 09:30:10','2024-07-06 09:30:10',NULL),(3637,7812,1017,40825,4564,3,57,2,300000.00,NULL,'2024-07-06 09:30:10','2024-07-06 09:30:10',NULL),(3638,7812,1018,40825,4564,3,217,1,272143.34,NULL,'2024-07-06 09:33:37','2024-07-06 09:33:37',NULL),(3639,7812,1018,40825,4564,3,68,1,57150.10,NULL,'2024-07-06 09:33:37','2024-07-06 09:33:37',NULL),(3640,7812,1018,40825,4564,3,221,1,26073.53,NULL,'2024-07-06 09:33:37','2024-07-06 09:33:37',NULL),(3641,7812,1018,40825,4564,3,57,2,355366.97,NULL,'2024-07-06 09:33:37','2024-07-06 09:33:37',NULL),(3642,7812,1019,40825,4564,3,217,1,140924.23,NULL,'2024-07-06 09:37:49','2024-07-06 09:37:49',NULL),(3643,7812,1019,40825,4564,3,68,1,29594.09,NULL,'2024-07-06 09:37:49','2024-07-06 09:37:49',NULL),(3644,7812,1019,40825,4564,3,221,1,13501.68,NULL,'2024-07-06 09:37:49','2024-07-06 09:37:49',NULL),(3645,7812,1019,40825,4564,3,57,2,184020.00,NULL,'2024-07-06 09:37:49','2024-07-06 09:37:49',NULL),(3646,7812,1020,40825,4564,3,217,1,229742.79,NULL,'2024-07-06 09:40:08','2024-07-06 09:40:08',NULL),(3647,7812,1020,40825,4564,3,68,1,48245.99,NULL,'2024-07-06 09:40:08','2024-07-06 09:40:08',NULL),(3648,7812,1020,40825,4564,3,221,1,22011.22,NULL,'2024-07-06 09:40:08','2024-07-06 09:40:08',NULL),(3649,7812,1020,40825,4564,3,57,2,300000.00,NULL,'2024-07-06 09:40:08','2024-07-06 09:40:08',NULL),(3650,7812,1021,40825,4564,3,217,1,229742.79,NULL,'2024-07-06 09:43:13','2024-07-06 09:43:13',NULL),(3651,7812,1021,40825,4564,3,68,1,48245.99,NULL,'2024-07-06 09:43:13','2024-07-06 09:43:13',NULL),(3652,7812,1021,40825,4564,3,221,1,22011.22,NULL,'2024-07-06 09:43:13','2024-07-06 09:43:13',NULL);
INSERT INTO `balance_libro_details` VALUES (3653,7812,1021,40825,4564,3,57,2,300000.00,NULL,'2024-07-06 09:43:13','2024-07-06 09:43:13',NULL),(3654,7812,1022,40825,4564,15,67,1,874425.67,NULL,'2024-07-09 10:11:33','2024-07-09 10:11:33',NULL),(3655,7812,1022,40825,4564,15,68,2,485956.72,NULL,'2024-07-09 10:11:33','2024-07-09 10:11:33',NULL),(3656,7812,1022,40825,4564,15,353,2,398912.66,NULL,'2024-07-09 10:11:33','2024-07-09 10:11:33',NULL),(3657,7812,1022,40825,4564,15,354,2,388885.04,NULL,'2024-07-09 10:11:33','2024-07-09 10:11:33',NULL),(3658,7812,1022,40825,4564,15,353,1,10443.71,NULL,'2024-07-09 10:11:33','2024-07-09 10:11:33',NULL),(3659,7812,1022,40825,4564,15,354,1,388885.04,NULL,'2024-07-09 10:11:33','2024-07-09 10:11:33',NULL),(3660,7812,1023,40720,1567,3,217,1,27645.79,NULL,'2024-07-09 10:26:15','2024-07-09 11:06:12','2024-07-09 11:06:12'),(3661,7812,1023,40720,1567,3,68,1,3620.20,NULL,'2024-07-09 10:26:15','2024-07-09 11:06:12','2024-07-09 11:06:12'),(3662,7812,1023,40720,1567,3,57,2,31265.99,NULL,'2024-07-09 10:26:15','2024-07-09 11:06:12','2024-07-09 11:06:12'),(3663,7812,1024,40720,1567,3,250,1,0.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3664,7812,1024,40720,1567,3,250,1,54999.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3665,7812,1024,40720,1567,3,57,2,54999.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3666,7812,1025,40720,1567,3,250,1,0.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3667,7812,1025,40720,1567,3,250,1,66499.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3668,7812,1025,40720,1567,3,57,2,66499.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3669,7812,1026,40720,1567,3,217,1,14554.04,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3670,7812,1026,40720,1567,3,68,1,3056.35,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3671,7812,1026,40720,1567,3,217,1,2389.59,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3672,7812,1026,40720,1567,3,57,2,19999.98,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3673,7812,1027,40720,1567,3,217,1,26446.29,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3674,7812,1027,40720,1567,3,68,1,5553.72,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3675,7812,1027,40720,1567,3,217,1,-0.01,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3676,7812,1027,40720,1567,3,57,2,32000.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3677,7812,1028,40720,1567,3,250,1,120000.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3678,7812,1028,40720,1567,3,57,2,120000.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3679,7812,1029,40720,1567,3,217,2,38367.77,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3680,7812,1029,40720,1567,3,67,2,8057.23,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3681,7812,1029,40720,1567,3,57,1,46425.00,NULL,'2024-07-09 10:26:15','2024-07-09 10:26:15',NULL),(3682,7812,1030,40720,1567,3,217,1,6832.22,NULL,'2024-07-09 11:06:12','2024-07-09 11:07:33','2024-07-09 11:07:33'),(3683,7812,1030,40720,1567,3,68,1,1434.77,NULL,'2024-07-09 11:06:12','2024-07-09 11:07:33','2024-07-09 11:07:33'),(3684,7812,1030,40720,1567,3,217,1,20813.57,NULL,'2024-07-09 11:06:12','2024-07-09 11:07:33','2024-07-09 11:07:33'),(3685,7812,1030,40720,1567,3,68,1,2185.42,NULL,'2024-07-09 11:06:12','2024-07-09 11:07:33','2024-07-09 11:07:33'),(3686,7812,1030,40720,1567,3,57,2,31265.98,NULL,'2024-07-09 11:06:12','2024-07-09 11:07:33','2024-07-09 11:07:33'),(3687,7812,1031,40720,1567,3,217,1,6832.22,NULL,'2024-07-09 11:07:33','2024-07-09 11:07:33',NULL),(3688,7812,1031,40720,1567,3,68,1,1434.77,NULL,'2024-07-09 11:07:33','2024-07-09 11:07:33',NULL),(3689,7812,1031,40720,1567,3,217,1,20813.57,NULL,'2024-07-09 11:07:33','2024-07-09 11:07:33',NULL),(3690,7812,1031,40720,1567,3,68,1,2185.42,NULL,'2024-07-09 11:07:33','2024-07-09 11:07:33',NULL),(3691,7812,1031,40720,1567,3,57,2,31265.98,NULL,'2024-07-09 11:07:33','2024-07-09 11:07:33',NULL);
INSERT INTO `balance_libro_details` VALUES (3692,7812,1032,40720,1567,15,67,1,1120160.52,NULL,'2024-07-09 11:17:44','2024-07-09 11:17:44',NULL),(3693,7812,1032,40720,1567,15,68,2,830949.06,NULL,'2024-07-09 11:17:44','2024-07-09 11:17:44',NULL),(3694,7812,1032,40720,1567,15,353,2,403446.44,NULL,'2024-07-09 11:17:44','2024-07-09 11:17:44',NULL),(3695,7812,1032,40720,1567,15,353,1,114234.98,NULL,'2024-07-09 11:17:44','2024-07-09 11:17:44',NULL),(3696,7812,1033,40720,1568,2,96,2,569993.90,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3697,7812,1033,40720,1568,2,67,2,119698.72,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3698,7812,1033,40720,1568,2,218,2,0.02,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3699,7812,1033,40720,1568,2,13,1,689692.64,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3700,7812,1034,40720,1568,2,96,2,664473.05,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3701,7812,1034,40720,1568,2,67,2,139539.34,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3702,7812,1034,40720,1568,2,218,2,-0.01,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3703,7812,1034,40720,1568,2,13,1,804012.38,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3704,7812,1035,40720,1568,2,96,1,664473.05,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3705,7812,1035,40720,1568,2,68,1,139539.34,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3706,7812,1035,40720,1568,2,218,1,-0.01,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3707,7812,1035,40720,1568,2,13,2,804012.38,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3708,7812,1036,40720,1568,2,96,2,843360.00,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3709,7812,1036,40720,1568,2,67,2,177105.60,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3710,7812,1036,40720,1568,2,13,1,1020465.60,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3711,7812,1037,40720,1568,2,96,2,848500.00,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3712,7812,1037,40720,1568,2,67,2,178185.00,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3713,7812,1037,40720,1568,2,13,1,1026685.00,NULL,'2024-07-22 17:26:25','2024-07-22 17:26:25',NULL),(3714,7812,1038,40720,1568,3,250,2,0.00,NULL,'2024-07-22 17:28:00','2024-07-22 17:59:57','2024-07-22 17:59:57'),(3715,7812,1038,40720,1568,3,250,2,54999.00,NULL,'2024-07-22 17:28:00','2024-07-22 17:59:57','2024-07-22 17:59:57'),(3716,7812,1038,40720,1568,3,57,1,54999.00,NULL,'2024-07-22 17:28:00','2024-07-22 17:59:57','2024-07-22 17:59:57'),(3717,7812,1039,40720,1568,3,217,1,17272.73,NULL,'2024-07-22 17:28:00','2024-07-22 17:28:00',NULL),(3718,7812,1039,40720,1568,3,68,1,3627.27,NULL,'2024-07-22 17:28:00','2024-07-22 17:28:00',NULL),(3719,7812,1039,40720,1568,3,57,2,20900.00,NULL,'2024-07-22 17:28:00','2024-07-22 17:28:00',NULL),(3720,7812,1040,40720,1568,3,250,1,0.00,NULL,'2024-07-22 17:28:00','2024-07-22 17:59:40','2024-07-22 17:59:40'),(3721,7812,1040,40720,1568,3,250,1,76490.00,NULL,'2024-07-22 17:28:00','2024-07-22 17:59:40','2024-07-22 17:59:40'),(3722,7812,1040,40720,1568,3,57,2,76490.00,NULL,'2024-07-22 17:28:00','2024-07-22 17:59:40','2024-07-22 17:59:40'),(3723,7812,1041,40720,1568,3,217,1,71457.63,NULL,'2024-07-22 17:28:00','2024-07-22 17:28:00',NULL),(3724,7812,1041,40720,1568,3,68,1,15006.10,NULL,'2024-07-22 17:28:00','2024-07-22 17:28:00',NULL),(3725,7812,1041,40720,1568,3,217,1,5545.88,NULL,'2024-07-22 17:28:00','2024-07-22 17:28:00',NULL),(3726,7812,1041,40720,1568,3,57,2,92009.61,NULL,'2024-07-22 17:28:00','2024-07-22 17:28:00',NULL),(3727,7812,1042,40720,1568,3,217,1,7315.16,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3728,7812,1042,40720,1568,3,68,1,1536.18,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3729,7812,1042,40720,1568,3,217,1,1148.67,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3730,7812,1042,40720,1568,3,57,2,10000.01,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL);
INSERT INTO `balance_libro_details` VALUES (3731,7812,1043,40720,1568,3,217,1,189917.36,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3732,7812,1043,40720,1568,3,68,1,39882.65,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3733,7812,1043,40720,1568,3,57,2,229800.01,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3734,7812,1044,40720,1568,3,217,1,1500000.00,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3735,7812,1044,40720,1568,3,68,1,315000.00,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3736,7812,1044,40720,1568,3,57,2,1815000.00,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3737,7812,1045,40720,1568,3,217,1,189917.36,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3738,7812,1045,40720,1568,3,68,1,39882.65,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3739,7812,1045,40720,1568,3,57,2,229800.01,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3740,7812,1046,40720,1568,3,217,1,256694.19,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3741,7812,1046,40720,1568,3,68,1,53905.78,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3742,7812,1046,40720,1568,3,217,1,0.04,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3743,7812,1046,40720,1568,3,57,2,310600.01,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3744,7812,1047,40720,1568,3,217,1,11404.96,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3745,7812,1047,40720,1568,3,68,1,2395.04,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3746,7812,1047,40720,1568,3,57,2,13800.00,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3747,7812,1048,40720,1568,3,217,1,25454.55,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3748,7812,1048,40720,1568,3,68,1,5345.46,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3749,7812,1048,40720,1568,3,57,2,30800.01,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3750,7812,1049,40720,1568,3,217,1,73223.14,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3751,7812,1049,40720,1568,3,68,1,15376.86,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3752,7812,1049,40720,1568,3,57,2,88600.00,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3753,7812,1050,40720,1568,3,217,1,73223.14,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3754,7812,1050,40720,1568,3,68,1,15376.86,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3755,7812,1050,40720,1568,3,57,2,88600.00,NULL,'2024-07-22 17:28:01','2024-07-22 17:28:01',NULL),(3756,7812,1051,40720,1568,15,67,1,614528.66,NULL,'2024-07-22 18:08:51','2024-07-22 18:08:51',NULL),(3757,7812,1051,40720,1568,15,68,2,646874.19,NULL,'2024-07-22 18:08:51','2024-07-22 18:08:51',NULL),(3758,7812,1051,40720,1568,15,353,2,114234.98,NULL,'2024-07-22 18:08:51','2024-07-22 18:08:51',NULL),(3759,7812,1051,40720,1568,15,353,1,178529.60,NULL,'2024-07-22 18:08:51','2024-07-22 18:08:51',NULL),(3760,7812,1051,40720,1568,15,136,2,31949.09,NULL,'2024-07-22 18:08:51','2024-07-22 18:08:51',NULL),(3761,7812,1052,40825,4565,3,217,1,118034.73,NULL,'2024-07-26 19:00:24','2024-07-26 19:00:24',NULL),(3762,7812,1052,40825,4565,3,68,1,24787.29,NULL,'2024-07-26 19:00:24','2024-07-26 19:00:24',NULL),(3763,7812,1052,40825,4565,3,221,1,2185.53,NULL,'2024-07-26 19:00:24','2024-07-26 19:00:24',NULL),(3764,7812,1052,40825,4565,3,57,2,145007.55,NULL,'2024-07-26 19:00:24','2024-07-26 19:00:24',NULL),(3765,7812,1053,40825,4565,3,217,1,293040.48,NULL,'2024-07-26 19:01:13','2024-07-26 19:01:13',NULL),(3766,7812,1053,40825,4565,3,68,1,61538.50,NULL,'2024-07-26 19:01:13','2024-07-26 19:01:13',NULL),(3767,7812,1053,40825,4565,3,221,1,5425.95,NULL,'2024-07-26 19:01:13','2024-07-26 19:01:13',NULL),(3768,7812,1053,40825,4565,3,57,2,360004.93,NULL,'2024-07-26 19:01:13','2024-07-26 19:01:13',NULL),(3769,7812,1054,40825,4565,3,217,1,191293.28,NULL,'2024-07-26 19:02:01','2024-07-26 19:02:01',NULL),(3770,7812,1054,40825,4565,3,68,1,40171.59,NULL,'2024-07-26 19:02:01','2024-07-26 19:02:01',NULL);
INSERT INTO `balance_libro_details` VALUES (3771,7812,1054,40825,4565,3,221,1,3542.00,NULL,'2024-07-26 19:02:01','2024-07-26 19:02:01',NULL),(3772,7812,1054,40825,4565,3,57,2,235006.87,NULL,'2024-07-26 19:02:01','2024-07-26 19:02:01',NULL),(3773,7812,1055,40825,4565,3,217,1,185181.54,NULL,'2024-07-26 19:02:38','2024-07-26 19:02:38',NULL),(3774,7812,1055,40825,4565,3,68,1,38888.12,NULL,'2024-07-26 19:02:38','2024-07-26 19:02:38',NULL),(3775,7812,1055,40825,4565,3,221,1,3428.83,NULL,'2024-07-26 19:02:38','2024-07-26 19:02:38',NULL),(3776,7812,1055,40825,4565,3,57,2,227498.49,NULL,'2024-07-26 19:02:38','2024-07-26 19:02:38',NULL),(3777,7812,1056,40825,4565,3,217,1,8113.40,NULL,'2024-07-26 19:03:25','2024-07-26 19:03:25',NULL),(3778,7812,1056,40825,4565,3,68,1,1703.81,NULL,'2024-07-26 19:03:25','2024-07-26 19:03:25',NULL),(3779,7812,1056,40825,4565,3,221,1,162.79,NULL,'2024-07-26 19:03:25','2024-07-26 19:03:25',NULL),(3780,7812,1056,40825,4565,3,57,2,9980.00,NULL,'2024-07-26 19:03:25','2024-07-26 19:03:25',NULL),(3781,7812,1057,40825,4565,3,217,1,315871.82,NULL,'2024-07-26 19:04:17','2024-07-26 19:04:17',NULL),(3782,7812,1057,40825,4565,3,68,1,66333.08,NULL,'2024-07-26 19:04:17','2024-07-26 19:04:17',NULL),(3783,7812,1057,40825,4565,3,221,1,5848.70,NULL,'2024-07-26 19:04:17','2024-07-26 19:04:17',NULL),(3784,7812,1057,40825,4565,3,57,2,388053.60,NULL,'2024-07-26 19:04:17','2024-07-26 19:04:17',NULL),(3785,7812,1058,40825,4565,3,217,1,152138.53,NULL,'2024-07-26 19:05:49','2024-07-26 19:05:49',NULL),(3786,7812,1058,40825,4565,3,68,1,31949.09,NULL,'2024-07-26 19:05:49','2024-07-26 19:05:49',NULL),(3787,7812,1058,40825,4565,3,221,1,15912.35,NULL,'2024-07-26 19:05:49','2024-07-26 19:05:49',NULL),(3788,7812,1058,40825,4565,3,57,2,199999.97,NULL,'2024-07-26 19:05:49','2024-07-26 19:05:49',NULL),(3789,7812,1059,40825,4565,3,217,1,209953.46,NULL,'2024-07-26 19:06:39','2024-07-26 19:06:39',NULL),(3790,7812,1059,40825,4565,3,68,1,44090.23,NULL,'2024-07-26 19:06:39','2024-07-26 19:06:39',NULL),(3791,7812,1059,40825,4565,3,221,1,21959.28,NULL,'2024-07-26 19:06:39','2024-07-26 19:06:39',NULL),(3792,7812,1059,40825,4565,3,57,2,276002.97,NULL,'2024-07-26 19:06:39','2024-07-26 19:06:39',NULL),(3793,7812,1060,40825,4565,3,217,1,240358.41,NULL,'2024-07-26 19:07:22','2024-07-26 19:07:22',NULL),(3794,7812,1060,40825,4565,3,68,1,50475.27,NULL,'2024-07-26 19:07:22','2024-07-26 19:07:22',NULL),(3795,7812,1060,40825,4565,3,221,1,25139.37,NULL,'2024-07-26 19:07:22','2024-07-26 19:07:22',NULL),(3796,7812,1060,40825,4565,3,57,2,315973.05,NULL,'2024-07-26 19:07:22','2024-07-26 19:07:22',NULL),(3797,7812,1061,40825,4565,3,217,1,76069.27,NULL,'2024-07-26 19:08:05','2024-07-26 19:08:05',NULL),(3798,7812,1061,40825,4565,3,68,1,15974.55,NULL,'2024-07-26 19:08:05','2024-07-26 19:08:05',NULL),(3799,7812,1061,40825,4565,3,221,1,7956.18,NULL,'2024-07-26 19:08:05','2024-07-26 19:08:05',NULL),(3800,7812,1061,40825,4565,3,57,2,100000.00,NULL,'2024-07-26 19:08:05','2024-07-26 19:08:05',NULL),(3801,7812,1062,40825,4565,3,217,1,228207.79,NULL,'2024-07-26 19:08:43','2024-07-26 19:08:43',NULL),(3802,7812,1062,40825,4565,3,68,1,47923.64,NULL,'2024-07-26 19:08:43','2024-07-26 19:08:43',NULL),(3803,7812,1062,40825,4565,3,221,1,23868.54,NULL,'2024-07-26 19:08:43','2024-07-26 19:08:43',NULL),(3804,7812,1062,40825,4565,3,57,2,299999.97,NULL,'2024-07-26 19:08:43','2024-07-26 19:08:43',NULL),(3805,7812,1063,40825,4565,2,96,2,1699250.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3806,7812,1063,40825,4565,2,67,2,356842.50,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3807,7812,1063,40825,4565,2,13,1,2056092.50,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3808,7812,1064,40825,4565,2,96,2,577320.33,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3809,7812,1064,40825,4565,2,67,2,121237.27,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3810,7812,1064,40825,4565,2,218,2,-0.01,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL);
INSERT INTO `balance_libro_details` VALUES (3811,7812,1064,40825,4565,2,13,1,698557.59,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3812,7812,1065,40825,4565,2,96,2,1906240.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3813,7812,1065,40825,4565,2,67,2,400310.40,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3814,7812,1065,40825,4565,2,13,1,2306550.40,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3815,7812,1066,40825,4565,2,96,2,850000.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3816,7812,1066,40825,4565,2,67,2,178500.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3817,7812,1066,40825,4565,2,13,1,1028500.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3818,7812,1067,40825,4565,2,96,1,850000.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3819,7812,1067,40825,4565,2,68,1,178500.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3820,7812,1067,40825,4565,2,13,2,1028500.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3821,7812,1068,40825,4565,2,96,2,763000.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3822,7812,1068,40825,4565,2,67,2,160230.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3823,7812,1068,40825,4565,2,13,1,923230.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3824,7812,1069,40825,4565,2,96,2,851000.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3825,7812,1069,40825,4565,2,67,2,178710.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3826,7812,1069,40825,4565,2,13,1,1029710.00,NULL,'2024-07-26 19:13:39','2024-07-26 19:13:39',NULL),(3827,7812,1070,40825,4565,2,96,2,855500.00,NULL,'2024-07-26 19:13:40','2024-07-26 19:13:40',NULL),(3828,7812,1070,40825,4565,2,67,2,179655.00,NULL,'2024-07-26 19:13:40','2024-07-26 19:13:40',NULL),(3829,7812,1070,40825,4565,2,13,1,1035155.00,NULL,'2024-07-26 19:13:40','2024-07-26 19:13:40',NULL),(3830,7812,1071,40825,4565,2,96,2,627812.86,NULL,'2024-07-26 19:13:40','2024-07-26 19:13:40',NULL),(3831,7812,1071,40825,4565,2,67,2,131840.70,NULL,'2024-07-26 19:13:40','2024-07-26 19:13:40',NULL),(3832,7812,1071,40825,4565,2,218,2,-0.02,NULL,'2024-07-26 19:13:40','2024-07-26 19:13:40',NULL),(3833,7812,1071,40825,4565,2,13,1,759653.54,NULL,'2024-07-26 19:13:40','2024-07-26 19:13:40',NULL),(3834,7812,1072,40825,4565,3,217,1,312647.78,NULL,'2024-08-03 16:00:52','2024-08-03 16:00:52',NULL),(3835,7812,1072,40825,4565,3,68,1,65656.03,NULL,'2024-08-03 16:00:52','2024-08-03 16:00:52',NULL),(3836,7812,1072,40825,4565,3,221,1,32700.21,NULL,'2024-08-03 16:00:52','2024-08-03 16:00:52',NULL),(3837,7812,1072,40825,4565,3,57,2,411004.02,NULL,'2024-08-03 16:00:52','2024-08-03 16:00:52',NULL),(3838,7812,1073,40825,4565,3,217,1,230491.41,NULL,'2024-08-03 16:02:05','2024-08-03 16:02:05',NULL),(3839,7812,1073,40825,4565,3,68,1,48403.20,NULL,'2024-08-03 16:02:05','2024-08-03 16:02:05',NULL),(3840,7812,1073,40825,4565,3,221,1,24107.38,NULL,'2024-08-03 16:02:05','2024-08-03 16:02:05',NULL),(3841,7812,1073,40825,4565,3,57,2,303001.99,NULL,'2024-08-03 16:02:05','2024-08-03 16:02:05',NULL),(3842,7812,1074,40825,4566,3,217,1,314609.55,NULL,'2024-08-03 16:03:22','2024-09-14 17:25:13','2024-09-14 17:25:13'),(3843,7812,1074,40825,4566,3,68,1,66068.01,NULL,'2024-08-03 16:03:22','2024-09-14 17:25:13','2024-09-14 17:25:13'),(3844,7812,1074,40825,4566,3,221,1,35332.44,NULL,'2024-08-03 16:03:22','2024-09-14 17:25:13','2024-09-14 17:25:13'),(3845,7812,1074,40825,4566,3,57,2,416010.00,NULL,'2024-08-03 16:03:22','2024-09-14 17:25:13','2024-09-14 17:25:13'),(3846,7812,1075,40825,4566,3,217,1,302501.92,NULL,'2024-08-03 16:04:12','2024-09-14 17:25:38','2024-09-14 17:25:38'),(3847,7812,1075,40825,4566,3,68,1,63525.40,NULL,'2024-08-03 16:04:12','2024-09-14 17:25:38','2024-09-14 17:25:38'),(3848,7812,1075,40825,4566,3,221,1,33972.69,NULL,'2024-08-03 16:04:12','2024-09-14 17:25:38','2024-09-14 17:25:38'),(3849,7812,1075,40825,4566,3,57,2,400000.01,NULL,'2024-08-03 16:04:12','2024-09-14 17:25:38','2024-09-14 17:25:38');
INSERT INTO `balance_libro_details` VALUES (3850,7812,1076,40825,4565,3,217,1,209198.20,NULL,'2024-08-03 16:05:46','2024-08-03 16:05:46',NULL),(3851,7812,1076,40825,4565,3,68,1,43931.62,NULL,'2024-08-03 16:05:46','2024-08-03 16:05:46',NULL),(3852,7812,1076,40825,4565,3,221,1,3873.53,NULL,'2024-08-03 16:05:46','2024-08-03 16:05:46',NULL),(3853,7812,1076,40825,4565,3,57,2,257003.35,NULL,'2024-08-03 16:05:46','2024-08-03 16:05:46',NULL),(3854,7812,1077,40825,4566,2,96,2,862250.00,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3855,7812,1077,40825,4566,2,67,2,181072.50,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3856,7812,1077,40825,4566,2,13,1,1043322.50,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3857,7812,1078,40825,4566,2,96,2,903120.00,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3858,7812,1078,40825,4566,2,67,2,189655.20,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3859,7812,1078,40825,4566,2,13,1,1092775.20,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3860,7812,1079,40825,4566,2,96,2,1093016.43,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3861,7812,1079,40825,4566,2,67,2,229533.45,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3862,7812,1079,40825,4566,2,218,2,0.01,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3863,7812,1079,40825,4566,2,13,1,1322549.89,NULL,'2024-08-03 16:16:21','2024-08-03 16:16:21',NULL),(3864,7812,1080,40825,4566,3,217,1,247933.90,NULL,'2024-08-03 16:17:59','2024-09-14 17:25:29','2024-09-14 17:25:29'),(3865,7812,1080,40825,4566,3,68,1,52066.12,NULL,'2024-08-03 16:17:59','2024-09-14 17:25:29','2024-09-14 17:25:29'),(3866,7812,1080,40825,4566,3,217,1,-0.01,NULL,'2024-08-03 16:17:59','2024-09-14 17:25:29','2024-09-14 17:25:29'),(3867,7812,1080,40825,4566,3,57,2,300000.01,NULL,'2024-08-03 16:17:59','2024-09-14 17:25:29','2024-09-14 17:25:29'),(3868,7812,1081,40825,4566,3,217,1,53223.14,NULL,'2024-08-03 16:17:59','2024-09-14 17:25:21','2024-09-14 17:25:21'),(3869,7812,1081,40825,4566,3,68,1,11176.86,NULL,'2024-08-03 16:17:59','2024-09-14 17:25:21','2024-09-14 17:25:21'),(3870,7812,1081,40825,4566,3,57,2,64400.00,NULL,'2024-08-03 16:17:59','2024-09-14 17:25:21','2024-09-14 17:25:21'),(3871,7812,1082,40825,4566,3,250,1,0.00,NULL,'2024-08-03 16:17:59','2024-09-14 17:24:57','2024-09-14 17:24:57'),(3872,7812,1082,40825,4566,3,250,1,223713.62,NULL,'2024-08-03 16:17:59','2024-09-14 17:24:57','2024-09-14 17:24:57'),(3873,7812,1082,40825,4566,3,57,2,223713.62,NULL,'2024-08-03 16:17:59','2024-09-14 17:24:57','2024-09-14 17:24:57'),(3874,7812,1083,40720,1569,2,96,2,654530.81,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3875,7812,1083,40720,1569,2,67,2,137451.47,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3876,7812,1083,40720,1569,2,218,2,-0.01,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3877,7812,1083,40720,1569,2,13,1,791982.27,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3878,7812,1084,40720,1569,2,96,2,843750.00,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3879,7812,1084,40720,1569,2,67,2,177187.50,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3880,7812,1084,40720,1569,2,13,1,1020937.50,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3881,7812,1085,40720,1569,2,96,2,571271.38,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3882,7812,1085,40720,1569,2,67,2,119966.99,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3883,7812,1085,40720,1569,2,218,2,0.02,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3884,7812,1085,40720,1569,2,13,1,691238.39,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3885,7812,1086,40720,1569,2,96,2,948640.00,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3886,7812,1086,40720,1569,2,67,2,199214.40,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3887,7812,1086,40720,1569,2,13,1,1147854.40,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL);
INSERT INTO `balance_libro_details` VALUES (3888,7812,1087,40720,1569,2,96,2,513712.14,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3889,7812,1087,40720,1569,2,67,2,107879.55,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3890,7812,1087,40720,1569,2,218,2,0.02,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3891,7812,1087,40720,1569,2,13,1,621591.71,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3892,7812,1088,40720,1569,2,96,2,665715.81,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3893,7812,1088,40720,1569,2,67,2,139800.32,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3894,7812,1088,40720,1569,2,218,2,0.01,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3895,7812,1088,40720,1569,2,13,1,805516.14,NULL,'2024-08-21 18:14:00','2024-08-21 18:14:00',NULL),(3896,7812,1089,40720,1569,2,96,2,660330.43,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3897,7812,1089,40720,1569,2,67,2,138669.39,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3898,7812,1089,40720,1569,2,218,2,0.01,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3899,7812,1089,40720,1569,2,13,1,798999.83,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3900,7812,1090,40720,1569,2,96,2,664887.29,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3901,7812,1090,40720,1569,2,67,2,139626.33,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3902,7812,1090,40720,1569,2,218,2,0.01,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3903,7812,1090,40720,1569,2,13,1,804513.63,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3904,7812,1091,40720,1569,2,96,2,676486.57,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3905,7812,1091,40720,1569,2,67,2,142062.18,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3906,7812,1091,40720,1569,2,218,2,0.01,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3907,7812,1091,40720,1569,2,13,1,818548.76,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3908,7812,1092,40720,1569,2,96,2,670686.95,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3909,7812,1092,40720,1569,2,67,2,140844.26,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3910,7812,1092,40720,1569,2,218,2,-0.01,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3911,7812,1092,40720,1569,2,13,1,811531.20,NULL,'2024-08-21 18:14:01','2024-08-21 18:14:01',NULL),(3912,7812,1093,40720,1569,3,217,1,14132.23,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3913,7812,1093,40720,1569,3,68,1,2967.77,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3914,7812,1093,40720,1569,3,57,2,17100.00,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3915,7812,1094,40720,1569,3,217,1,40054.36,NULL,'2024-08-21 18:14:34','2024-09-02 17:35:42','2024-09-02 17:35:42'),(3916,7812,1094,40720,1569,3,68,1,4447.13,NULL,'2024-08-21 18:14:34','2024-09-02 17:35:42','2024-09-02 17:35:42'),(3917,7812,1094,40720,1569,3,57,2,44501.49,NULL,'2024-08-21 18:14:34','2024-09-02 17:35:42','2024-09-02 17:35:42'),(3918,7812,1095,40720,1569,3,217,1,238016.53,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3919,7812,1095,40720,1569,3,68,1,49983.47,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3920,7812,1095,40720,1569,3,57,2,288000.00,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3921,7812,1096,40720,1569,3,217,1,84380.17,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3922,7812,1096,40720,1569,3,68,1,17719.84,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3923,7812,1096,40720,1569,3,57,2,102100.01,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3924,7812,1097,40720,1569,3,217,1,83982.83,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3925,7812,1097,40720,1569,3,68,1,17636.39,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3926,7812,1097,40720,1569,3,57,2,101619.22,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3927,7812,1098,40720,1569,3,217,1,350000.00,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL);
INSERT INTO `balance_libro_details` VALUES (3928,7812,1098,40720,1569,3,68,1,36750.00,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3929,7812,1098,40720,1569,3,57,2,386750.00,NULL,'2024-08-21 18:14:34','2024-08-21 18:14:34',NULL),(3930,7812,1099,40720,1569,3,217,1,5000.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3931,7812,1099,40720,1569,3,68,1,525.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3932,7812,1099,40720,1569,3,57,2,5525.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3933,7812,1100,40720,1569,3,217,1,525000.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3934,7812,1100,40720,1569,3,68,1,55125.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3935,7812,1100,40720,1569,3,57,2,580125.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3936,7812,1101,40720,1569,3,217,1,4500.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3937,7812,1101,40720,1569,3,68,1,472.50,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3938,7812,1101,40720,1569,3,57,2,4972.50,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3939,7812,1102,40720,1569,3,217,1,561983.47,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3940,7812,1102,40720,1569,3,68,1,118016.53,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3941,7812,1102,40720,1569,3,57,2,680000.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3942,7812,1103,40720,1569,3,217,1,420000.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3943,7812,1103,40720,1569,3,68,1,44100.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3944,7812,1103,40720,1569,3,57,2,464100.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3945,7812,1104,40720,1569,3,217,1,35206.61,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3946,7812,1104,40720,1569,3,68,1,7393.39,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3947,7812,1104,40720,1569,3,57,2,42600.00,NULL,'2024-08-21 18:14:35','2024-08-21 18:14:35',NULL),(3948,7812,1105,40720,1569,3,217,1,152138.53,NULL,'2024-09-01 18:51:36','2024-09-01 18:55:28','2024-09-01 18:55:28'),(3949,7812,1105,40720,1569,3,68,1,31949.09,NULL,'2024-09-01 18:51:36','2024-09-01 18:55:28','2024-09-01 18:55:28'),(3950,7812,1105,40720,1569,3,221,1,15912.35,NULL,'2024-09-01 18:51:36','2024-09-01 18:55:28','2024-09-01 18:55:28'),(3951,7812,1105,40720,1569,3,57,2,199999.97,NULL,'2024-09-01 18:51:36','2024-09-01 18:55:28','2024-09-01 18:55:28'),(3952,7812,1106,40720,1569,3,217,1,241145.67,NULL,'2024-09-01 18:57:57','2024-09-01 18:57:57',NULL),(3953,7812,1106,40720,1569,3,68,1,50640.59,NULL,'2024-09-01 18:57:57','2024-09-01 18:57:57',NULL),(3954,7812,1106,40720,1569,3,221,1,25221.72,NULL,'2024-09-01 18:57:57','2024-09-01 18:57:57',NULL),(3955,7812,1106,40720,1569,3,57,2,317007.98,NULL,'2024-09-01 18:57:57','2024-09-01 18:57:57',NULL),(3956,7812,1107,40720,1569,3,217,1,343123.44,NULL,'2024-09-01 18:58:52','2024-09-01 18:58:52',NULL),(3957,7812,1107,40720,1569,3,68,1,72055.92,NULL,'2024-09-01 18:58:52','2024-09-01 18:58:52',NULL),(3958,7812,1107,40720,1569,3,221,1,35887.71,NULL,'2024-09-01 18:58:52','2024-09-01 18:58:52',NULL),(3959,7812,1107,40720,1569,3,57,2,451067.07,NULL,'2024-09-01 18:58:52','2024-09-01 18:58:52',NULL),(3960,7812,1108,40720,1569,3,217,1,54067.72,NULL,'2024-09-01 19:00:15','2024-09-01 19:00:15',NULL),(3961,7812,1108,40720,1569,3,68,1,11354.22,NULL,'2024-09-01 19:00:15','2024-09-01 19:00:15',NULL),(3962,7812,1108,40720,1569,3,221,1,5655.01,NULL,'2024-09-01 19:00:15','2024-09-01 19:00:15',NULL),(3963,7812,1108,40720,1569,3,57,2,71076.95,NULL,'2024-09-01 19:00:15','2024-09-01 19:00:15',NULL),(3964,7812,1109,40720,1569,3,217,1,76082.22,NULL,'2024-09-01 19:01:07','2024-09-01 19:01:07',NULL),(3965,7812,1109,40720,1569,3,68,1,15977.27,NULL,'2024-09-01 19:01:07','2024-09-01 19:01:07',NULL),(3966,7812,1109,40720,1569,3,221,1,7957.53,NULL,'2024-09-01 19:01:07','2024-09-01 19:01:07',NULL),(3967,7812,1109,40720,1569,3,57,2,100017.02,NULL,'2024-09-01 19:01:07','2024-09-01 19:01:07',NULL);
INSERT INTO `balance_libro_details` VALUES (3968,7812,1110,40720,1569,3,217,1,107596.43,NULL,'2024-09-01 19:02:19','2024-09-01 19:02:19',NULL),(3969,7812,1110,40720,1569,3,68,1,22595.25,NULL,'2024-09-01 19:02:19','2024-09-01 19:02:19',NULL),(3970,7812,1110,40720,1569,3,221,1,9888.28,NULL,'2024-09-01 19:02:19','2024-09-01 19:02:19',NULL),(3971,7812,1110,40720,1569,3,57,2,140079.96,NULL,'2024-09-01 19:02:19','2024-09-01 19:02:19',NULL),(3972,7812,1111,40720,1569,3,217,1,79881.10,NULL,'2024-09-01 19:03:04','2024-09-01 19:03:04',NULL),(3973,7812,1111,40720,1569,3,68,1,16775.03,NULL,'2024-09-01 19:03:04','2024-09-01 19:03:04',NULL),(3974,7812,1111,40720,1569,3,221,1,8354.86,NULL,'2024-09-01 19:03:04','2024-09-01 19:03:04',NULL),(3975,7812,1111,40720,1569,3,57,2,105010.99,NULL,'2024-09-01 19:03:04','2024-09-01 19:03:04',NULL),(3976,7812,1112,40720,1569,3,217,1,91823.96,NULL,'2024-09-01 19:03:42','2024-09-01 19:03:42',NULL),(3977,7812,1112,40720,1569,3,68,1,19283.03,NULL,'2024-09-01 19:03:42','2024-09-01 19:03:42',NULL),(3978,7812,1112,40720,1569,3,221,1,9603.98,NULL,'2024-09-01 19:03:42','2024-09-01 19:03:42',NULL),(3979,7812,1112,40720,1569,3,57,2,120710.97,NULL,'2024-09-01 19:03:42','2024-09-01 19:03:42',NULL),(3980,7812,1113,40720,1569,3,217,1,91283.15,NULL,'2024-09-01 19:04:19','2024-09-01 19:04:19',NULL),(3981,7812,1113,40720,1569,3,68,1,19169.46,NULL,'2024-09-01 19:04:19','2024-09-01 19:04:19',NULL),(3982,7812,1113,40720,1569,3,221,1,9547.42,NULL,'2024-09-01 19:04:19','2024-09-01 19:04:19',NULL),(3983,7812,1113,40720,1569,3,57,2,120000.03,NULL,'2024-09-01 19:04:19','2024-09-01 19:04:19',NULL),(3984,7812,1114,40720,1569,3,217,1,295355.27,NULL,'2024-09-01 19:13:07','2024-09-01 19:13:07',NULL),(3985,7812,1114,40720,1569,3,68,1,62024.61,NULL,'2024-09-01 19:13:07','2024-09-01 19:13:07',NULL),(3986,7812,1114,40720,1569,3,221,1,33170.08,NULL,'2024-09-01 19:13:07','2024-09-01 19:13:07',NULL),(3987,7812,1114,40720,1569,3,57,2,390549.96,NULL,'2024-09-01 19:13:07','2024-09-01 19:13:07',NULL),(3988,7812,1115,40720,1569,3,217,1,302501.92,NULL,'2024-09-01 19:13:46','2024-09-01 19:14:25','2024-09-01 19:14:25'),(3989,7812,1115,40720,1569,3,68,1,63525.40,NULL,'2024-09-01 19:13:46','2024-09-01 19:14:25','2024-09-01 19:14:25'),(3990,7812,1115,40720,1569,3,221,1,33972.69,NULL,'2024-09-01 19:13:46','2024-09-01 19:14:25','2024-09-01 19:14:25'),(3991,7812,1115,40720,1569,3,57,2,400000.01,NULL,'2024-09-01 19:13:46','2024-09-01 19:14:25','2024-09-01 19:14:25'),(3992,7812,1116,40720,1569,3,217,1,302501.92,NULL,'2024-09-01 19:14:25','2024-09-01 19:14:25',NULL),(3993,7812,1116,40720,1569,3,68,1,63525.40,NULL,'2024-09-01 19:14:25','2024-09-01 19:14:25',NULL),(3994,7812,1116,40720,1569,3,221,1,33972.69,NULL,'2024-09-01 19:14:25','2024-09-01 19:14:25',NULL),(3995,7812,1116,40720,1569,3,57,2,400000.01,NULL,'2024-09-01 19:14:25','2024-09-01 19:14:25',NULL),(3996,7812,1117,40720,1569,3,217,1,151250.92,NULL,'2024-09-01 19:15:51','2024-09-01 19:15:51',NULL),(3997,7812,1117,40720,1569,3,68,1,31762.69,NULL,'2024-09-01 19:15:51','2024-09-01 19:15:51',NULL),(3998,7812,1117,40720,1569,3,221,1,16986.34,NULL,'2024-09-01 19:15:51','2024-09-01 19:15:51',NULL),(3999,7812,1117,40720,1569,3,57,2,199999.95,NULL,'2024-09-01 19:15:51','2024-09-01 19:15:51',NULL),(4000,7812,1118,40720,1569,3,217,1,30250.19,NULL,'2024-09-01 19:17:32','2024-09-01 19:17:32',NULL),(4001,7812,1118,40720,1569,3,68,1,6352.54,NULL,'2024-09-01 19:17:32','2024-09-01 19:17:32',NULL),(4002,7812,1118,40720,1569,3,221,1,3397.27,NULL,'2024-09-01 19:17:32','2024-09-01 19:17:32',NULL),(4003,7812,1118,40720,1569,3,57,2,40000.00,NULL,'2024-09-01 19:17:32','2024-09-01 19:17:32',NULL),(4004,7812,1119,40720,1569,3,217,1,10784.00,NULL,'2024-09-01 19:18:26','2024-09-01 19:18:26',NULL),(4005,7812,1119,40720,1569,3,68,1,2264.64,NULL,'2024-09-01 19:18:26','2024-09-01 19:18:26',NULL),(4006,7812,1119,40720,1569,3,221,1,1951.38,NULL,'2024-09-01 19:18:26','2024-09-01 19:18:26',NULL);
INSERT INTO `balance_libro_details` VALUES (4007,7812,1119,40720,1569,3,57,2,15000.02,NULL,'2024-09-01 19:18:26','2024-09-01 19:18:26',NULL),(4008,7812,1120,40720,1569,3,217,1,25171.27,NULL,'2024-09-01 19:19:06','2024-09-01 19:19:06',NULL),(4009,7812,1120,40720,1569,3,68,1,5285.97,NULL,'2024-09-01 19:19:06','2024-09-01 19:19:06',NULL),(4010,7812,1120,40720,1569,3,221,1,4554.78,NULL,'2024-09-01 19:19:06','2024-09-01 19:19:06',NULL),(4011,7812,1120,40720,1569,3,57,2,35012.02,NULL,'2024-09-01 19:19:06','2024-09-01 19:19:06',NULL),(4012,7812,1121,40720,1569,3,217,1,30250.20,NULL,'2024-09-01 19:20:20','2024-09-01 19:20:20',NULL),(4013,7812,1121,40720,1569,3,68,1,6352.54,NULL,'2024-09-01 19:20:20','2024-09-01 19:20:20',NULL),(4014,7812,1121,40720,1569,3,221,1,3397.27,NULL,'2024-09-01 19:20:20','2024-09-01 19:20:20',NULL),(4015,7812,1121,40720,1569,3,57,2,40000.01,NULL,'2024-09-01 19:20:20','2024-09-01 19:20:20',NULL),(4016,7812,1122,40720,1569,3,217,1,151251.02,NULL,'2024-09-01 19:21:31','2024-09-01 19:21:31',NULL),(4017,7812,1122,40720,1569,3,68,1,31762.71,NULL,'2024-09-01 19:21:31','2024-09-01 19:21:31',NULL),(4018,7812,1122,40720,1569,3,221,1,16986.34,NULL,'2024-09-01 19:21:31','2024-09-01 19:21:31',NULL),(4019,7812,1122,40720,1569,3,57,2,200000.07,NULL,'2024-09-01 19:21:31','2024-09-01 19:21:31',NULL),(4020,7812,1123,40720,1569,3,217,1,90798.21,NULL,'2024-09-01 19:22:25','2024-09-01 19:22:25',NULL),(4021,7812,1123,40720,1569,3,68,1,19067.62,NULL,'2024-09-01 19:22:25','2024-09-01 19:22:25',NULL),(4022,7812,1123,40720,1569,3,221,1,10197.15,NULL,'2024-09-01 19:22:25','2024-09-01 19:22:25',NULL),(4023,7812,1123,40720,1569,3,57,2,120062.98,NULL,'2024-09-01 19:22:25','2024-09-01 19:22:25',NULL),(4024,7812,1124,40720,1569,3,217,1,113442.04,NULL,'2024-09-01 19:23:16','2024-09-01 19:23:16',NULL),(4025,7812,1124,40720,1569,3,68,1,23822.83,NULL,'2024-09-01 19:23:16','2024-09-01 19:23:16',NULL),(4026,7812,1124,40720,1569,3,221,1,12740.19,NULL,'2024-09-01 19:23:16','2024-09-01 19:23:16',NULL),(4027,7812,1124,40720,1569,3,57,2,150005.06,NULL,'2024-09-01 19:23:16','2024-09-01 19:23:16',NULL),(4028,7812,1125,40720,1569,3,217,1,14378.67,NULL,'2024-09-01 19:24:25','2024-09-01 19:24:25',NULL),(4029,7812,1125,40720,1569,3,68,1,3019.52,NULL,'2024-09-01 19:24:25','2024-09-01 19:24:25',NULL),(4030,7812,1125,40720,1569,3,221,1,2601.84,NULL,'2024-09-01 19:24:25','2024-09-01 19:24:25',NULL),(4031,7812,1125,40720,1569,3,57,2,20000.03,NULL,'2024-09-01 19:24:25','2024-09-01 19:24:25',NULL),(4032,7812,1126,40720,1569,3,217,1,28757.26,NULL,'2024-09-01 19:25:32','2024-09-01 19:25:32',NULL),(4033,7812,1126,40720,1569,3,68,1,6039.02,NULL,'2024-09-01 19:25:32','2024-09-01 19:25:32',NULL),(4034,7812,1126,40720,1569,3,221,1,5203.67,NULL,'2024-09-01 19:25:32','2024-09-01 19:25:32',NULL),(4035,7812,1126,40720,1569,3,57,2,39999.95,NULL,'2024-09-01 19:25:32','2024-09-01 19:25:32',NULL),(4036,7812,1127,40720,1569,3,217,1,105875.66,NULL,'2024-09-01 19:26:31','2024-09-01 19:26:31',NULL),(4037,7812,1127,40720,1569,3,68,1,22233.89,NULL,'2024-09-01 19:26:31','2024-09-01 19:26:31',NULL),(4038,7812,1127,40720,1569,3,221,1,11890.44,NULL,'2024-09-01 19:26:31','2024-09-01 19:26:31',NULL),(4039,7812,1127,40720,1569,3,57,2,139999.99,NULL,'2024-09-01 19:26:31','2024-09-01 19:26:31',NULL),(4040,7812,1128,40720,1569,3,217,1,23724.79,NULL,'2024-09-01 19:28:02','2024-09-01 19:28:02',NULL),(4041,7812,1128,40720,1569,3,68,1,4982.21,NULL,'2024-09-01 19:28:02','2024-09-01 19:28:02',NULL),(4042,7812,1128,40720,1569,3,221,1,4293.04,NULL,'2024-09-01 19:28:02','2024-09-01 19:28:02',NULL),(4043,7812,1128,40720,1569,3,57,2,33000.04,NULL,'2024-09-01 19:28:03','2024-09-01 19:28:03',NULL),(4044,7812,1129,40720,1569,3,217,1,85843.98,NULL,'2024-09-01 19:28:33','2024-09-01 19:28:33',NULL),(4045,7812,1129,40720,1569,3,68,1,18027.24,NULL,'2024-09-01 19:28:33','2024-09-01 19:28:33',NULL),(4046,7812,1129,40720,1569,3,221,1,9640.77,NULL,'2024-09-01 19:28:33','2024-09-01 19:28:33',NULL);
INSERT INTO `balance_libro_details` VALUES (4047,7812,1129,40720,1569,3,57,2,113511.99,NULL,'2024-09-01 19:28:33','2024-09-01 19:28:33',NULL),(4048,7812,1130,40720,1569,3,217,1,23449.93,NULL,'2024-09-01 19:29:06','2024-09-01 19:29:06',NULL),(4049,7812,1130,40720,1569,3,68,1,4924.49,NULL,'2024-09-01 19:29:06','2024-09-01 19:29:06',NULL),(4050,7812,1130,40720,1569,3,221,1,2633.56,NULL,'2024-09-01 19:29:06','2024-09-01 19:29:06',NULL),(4051,7812,1130,40720,1569,3,57,2,31007.98,NULL,'2024-09-01 19:29:06','2024-09-01 19:29:06',NULL),(4052,7812,1131,40720,1569,3,217,1,37063.32,NULL,'2024-09-01 19:29:47','2024-09-01 19:29:47',NULL),(4053,7812,1131,40720,1569,3,68,1,7783.30,NULL,'2024-09-01 19:29:47','2024-09-01 19:29:47',NULL),(4054,7812,1131,40720,1569,3,221,1,4162.42,NULL,'2024-09-01 19:29:47','2024-09-01 19:29:47',NULL),(4055,7812,1131,40720,1569,3,57,2,49009.04,NULL,'2024-09-01 19:29:47','2024-09-01 19:29:47',NULL),(4056,7812,1132,40720,1569,3,217,1,81818.18,NULL,'2024-09-01 19:31:17','2024-09-01 19:31:17',NULL),(4057,7812,1132,40720,1569,3,68,1,17181.82,NULL,'2024-09-01 19:31:17','2024-09-01 19:31:17',NULL),(4058,7812,1132,40720,1569,3,57,2,99000.00,NULL,'2024-09-01 19:31:17','2024-09-01 19:31:17',NULL),(4059,7812,1133,40720,1569,3,217,1,55710.74,NULL,'2024-09-01 19:32:11','2024-09-01 19:32:11',NULL),(4060,7812,1133,40720,1569,3,68,1,11699.26,NULL,'2024-09-01 19:32:11','2024-09-01 19:32:11',NULL),(4061,7812,1133,40720,1569,3,57,2,67410.00,NULL,'2024-09-01 19:32:11','2024-09-01 19:32:11',NULL),(4062,7812,1134,40720,1569,3,217,1,90765.67,NULL,'2024-09-02 16:46:19','2024-09-02 16:46:19',NULL),(4063,7812,1134,40720,1569,3,68,1,19060.79,NULL,'2024-09-02 16:46:19','2024-09-02 16:46:19',NULL),(4064,7812,1134,40720,1569,3,221,1,10193.50,NULL,'2024-09-02 16:46:19','2024-09-02 16:46:19',NULL),(4065,7812,1134,40720,1569,3,57,2,120019.96,NULL,'2024-09-02 16:46:19','2024-09-02 16:46:19',NULL),(4066,7812,1135,40720,1569,3,217,1,98313.13,NULL,'2024-09-02 16:47:22','2024-09-02 16:47:22',NULL),(4067,7812,1135,40720,1569,3,68,1,20645.76,NULL,'2024-09-02 16:47:22','2024-09-02 16:47:22',NULL),(4068,7812,1135,40720,1569,3,221,1,11041.12,NULL,'2024-09-02 16:47:22','2024-09-02 16:47:22',NULL),(4069,7812,1135,40720,1569,3,57,2,130000.01,NULL,'2024-09-02 16:47:22','2024-09-02 16:47:22',NULL),(4070,7812,1136,40720,1569,3,217,1,33153.42,NULL,'2024-09-02 16:48:05','2024-09-02 16:48:05',NULL),(4071,7812,1136,40720,1569,3,68,1,6962.22,NULL,'2024-09-02 16:48:05','2024-09-02 16:48:05',NULL),(4072,7812,1136,40720,1569,3,221,1,3723.32,NULL,'2024-09-02 16:48:05','2024-09-02 16:48:05',NULL),(4073,7812,1136,40720,1569,3,57,2,43838.96,NULL,'2024-09-02 16:48:05','2024-09-02 16:48:05',NULL),(4074,7812,1137,40720,1569,3,217,1,30253.20,NULL,'2024-09-02 16:48:48','2024-09-02 16:48:48',NULL),(4075,7812,1137,40720,1569,3,68,1,6353.17,NULL,'2024-09-02 16:48:48','2024-09-02 16:48:48',NULL),(4076,7812,1137,40720,1569,3,221,1,3397.61,NULL,'2024-09-02 16:48:48','2024-09-02 16:48:48',NULL),(4077,7812,1137,40720,1569,3,57,2,40003.98,NULL,'2024-09-02 16:48:48','2024-09-02 16:48:48',NULL),(4078,7812,1138,40720,1569,3,217,1,113444.28,NULL,'2024-09-02 16:49:39','2024-09-02 16:49:39',NULL),(4079,7812,1138,40720,1569,3,68,1,23823.30,NULL,'2024-09-02 16:49:39','2024-09-02 16:49:39',NULL),(4080,7812,1138,40720,1569,3,221,1,12740.43,NULL,'2024-09-02 16:49:39','2024-09-02 16:49:39',NULL),(4081,7812,1138,40720,1569,3,57,2,150008.01,NULL,'2024-09-02 16:49:39','2024-09-02 16:49:39',NULL),(4082,7812,1139,40720,1569,3,217,1,39327.48,NULL,'2024-09-02 16:50:15','2024-09-02 16:50:15',NULL),(4083,7812,1139,40720,1569,3,68,1,8258.77,NULL,'2024-09-02 16:50:15','2024-09-02 16:50:15',NULL),(4084,7812,1139,40720,1569,3,221,1,4416.70,NULL,'2024-09-02 16:50:15','2024-09-02 16:50:15',NULL),(4085,7812,1139,40720,1569,3,57,2,52002.95,NULL,'2024-09-02 16:50:15','2024-09-02 16:50:15',NULL),(4086,7812,1140,40720,1569,3,217,1,14393.77,NULL,'2024-09-02 16:51:11','2024-09-02 16:51:11',NULL);
INSERT INTO `balance_libro_details` VALUES (4087,7812,1140,40720,1569,3,68,1,3022.69,NULL,'2024-09-02 16:51:11','2024-09-02 16:51:11',NULL),(4088,7812,1140,40720,1569,3,221,1,2604.58,NULL,'2024-09-02 16:51:11','2024-09-02 16:51:11',NULL),(4089,7812,1140,40720,1569,3,57,2,20021.04,NULL,'2024-09-02 16:51:11','2024-09-02 16:51:11',NULL),(4090,7812,1141,40720,1569,3,217,1,10786.17,NULL,'2024-09-02 16:51:56','2024-09-02 16:51:56',NULL),(4091,7812,1141,40720,1569,3,68,1,2265.10,NULL,'2024-09-02 16:51:56','2024-09-02 16:51:56',NULL),(4092,7812,1141,40720,1569,3,221,1,1951.77,NULL,'2024-09-02 16:51:56','2024-09-02 16:51:56',NULL),(4093,7812,1141,40720,1569,3,57,2,15003.04,NULL,'2024-09-02 16:51:56','2024-09-02 16:51:56',NULL),(4094,7812,1142,40720,1569,3,217,1,14747.15,NULL,'2024-09-02 16:53:22','2024-09-02 16:53:22',NULL),(4095,7812,1142,40720,1569,3,68,1,3096.90,NULL,'2024-09-02 16:53:22','2024-09-02 16:53:22',NULL),(4096,7812,1142,40720,1569,3,221,1,2161.91,NULL,'2024-09-02 16:53:22','2024-09-02 16:53:22',NULL),(4097,7812,1142,40720,1569,3,57,2,20005.96,NULL,'2024-09-02 16:53:22','2024-09-02 16:53:22',NULL),(4098,7812,1143,40720,1569,3,217,1,83226.60,NULL,'2024-09-02 16:54:09','2024-09-02 16:54:09',NULL),(4099,7812,1143,40720,1569,3,68,1,17477.59,NULL,'2024-09-02 16:54:09','2024-09-02 16:54:09',NULL),(4100,7812,1143,40720,1569,3,221,1,9346.82,NULL,'2024-09-02 16:54:09','2024-09-02 16:54:09',NULL),(4101,7812,1143,40720,1569,3,57,2,110051.01,NULL,'2024-09-02 16:54:09','2024-09-02 16:54:09',NULL),(4102,7812,1144,40720,1569,3,217,1,350702.39,NULL,'2024-09-02 16:54:41','2024-09-02 16:54:41',NULL),(4103,7812,1144,40720,1569,3,68,1,73647.50,NULL,'2024-09-02 16:54:41','2024-09-02 16:54:41',NULL),(4104,7812,1144,40720,1569,3,221,1,33600.12,NULL,'2024-09-02 16:54:41','2024-09-02 16:54:41',NULL),(4105,7812,1144,40720,1569,3,57,2,457950.01,NULL,'2024-09-02 16:54:41','2024-09-02 16:54:41',NULL),(4106,7812,1145,40720,1569,3,217,1,21568.01,NULL,'2024-09-02 16:55:22','2024-09-02 16:55:22',NULL),(4107,7812,1145,40720,1569,3,68,1,4529.28,NULL,'2024-09-02 16:55:22','2024-09-02 16:55:22',NULL),(4108,7812,1145,40720,1569,3,221,1,3902.76,NULL,'2024-09-02 16:55:22','2024-09-02 16:55:22',NULL),(4109,7812,1145,40720,1569,3,57,2,30000.05,NULL,'2024-09-02 16:55:22','2024-09-02 16:55:22',NULL),(4110,7812,1146,40720,1569,3,217,1,200761.60,NULL,'2024-09-02 16:56:29','2024-09-02 16:56:29',NULL),(4111,7812,1146,40720,1569,3,68,1,42159.94,NULL,'2024-09-02 16:56:29','2024-09-02 16:56:29',NULL),(4112,7812,1146,40720,1569,3,221,1,19081.48,NULL,'2024-09-02 16:56:29','2024-09-02 16:56:29',NULL),(4113,7812,1146,40720,1569,3,57,2,262003.02,NULL,'2024-09-02 16:56:29','2024-09-02 16:56:29',NULL),(4114,7812,1147,40720,1569,3,217,1,37812.73,NULL,'2024-09-02 16:57:38','2024-09-02 16:57:38',NULL),(4115,7812,1147,40720,1569,3,68,1,7940.67,NULL,'2024-09-02 16:57:38','2024-09-02 16:57:38',NULL),(4116,7812,1147,40720,1569,3,221,1,4246.58,NULL,'2024-09-02 16:57:38','2024-09-02 16:57:38',NULL),(4117,7812,1147,40720,1569,3,57,2,49999.98,NULL,'2024-09-02 16:57:38','2024-09-02 16:57:38',NULL),(4118,7812,1148,40720,1569,3,217,1,226876.46,NULL,'2024-09-02 16:58:33','2024-09-02 16:58:33',NULL),(4119,7812,1148,40720,1569,3,68,1,47644.06,NULL,'2024-09-02 16:58:33','2024-09-02 16:58:33',NULL),(4120,7812,1148,40720,1569,3,221,1,25479.52,NULL,'2024-09-02 16:58:33','2024-09-02 16:58:33',NULL),(4121,7812,1148,40720,1569,3,57,2,300000.04,NULL,'2024-09-02 16:58:33','2024-09-02 16:58:33',NULL),(4122,7812,1149,40720,1569,3,217,1,75625.46,NULL,'2024-09-02 16:59:09','2024-09-02 16:59:09',NULL),(4123,7812,1149,40720,1569,3,68,1,15881.35,NULL,'2024-09-02 16:59:09','2024-09-02 16:59:09',NULL),(4124,7812,1149,40720,1569,3,221,1,8493.17,NULL,'2024-09-02 16:59:09','2024-09-02 16:59:09',NULL),(4125,7812,1149,40720,1569,3,57,2,99999.98,NULL,'2024-09-02 16:59:09','2024-09-02 16:59:09',NULL),(4126,7812,1150,40720,1569,3,217,1,151250.92,NULL,'2024-09-02 16:59:48','2024-09-02 16:59:48',NULL);
INSERT INTO `balance_libro_details` VALUES (4127,7812,1150,40720,1569,3,68,1,31762.69,NULL,'2024-09-02 16:59:48','2024-09-02 16:59:48',NULL),(4128,7812,1150,40720,1569,3,221,1,16986.34,NULL,'2024-09-02 16:59:48','2024-09-02 16:59:48',NULL),(4129,7812,1150,40720,1569,3,57,2,199999.95,NULL,'2024-09-02 16:59:48','2024-09-02 16:59:48',NULL),(4130,7812,1151,40720,1569,3,217,1,202329.44,NULL,'2024-09-02 17:02:59','2024-09-02 17:02:59',NULL),(4131,7812,1151,40720,1569,3,68,1,42489.18,NULL,'2024-09-02 17:02:59','2024-09-02 17:02:59',NULL),(4132,7812,1151,40720,1569,3,221,1,5181.42,NULL,'2024-09-02 17:02:59','2024-09-02 17:02:59',NULL),(4133,7812,1151,40720,1569,3,57,2,250000.04,NULL,'2024-09-02 17:02:59','2024-09-02 17:02:59',NULL),(4134,7812,1152,40720,1569,3,217,1,7810.08,NULL,'2024-09-02 17:03:45','2024-09-02 17:03:45',NULL),(4135,7812,1152,40720,1569,3,68,1,1640.12,NULL,'2024-09-02 17:03:45','2024-09-02 17:03:45',NULL),(4136,7812,1152,40720,1569,3,57,2,9450.20,NULL,'2024-09-02 17:03:45','2024-09-02 17:03:45',NULL),(4137,7812,1153,40720,1569,3,217,1,40054.36,NULL,'2024-09-02 17:35:42','2024-09-02 17:35:42',NULL),(4138,7812,1153,40720,1569,3,68,1,4205.71,NULL,'2024-09-02 17:35:42','2024-09-02 17:35:42',NULL),(4139,7812,1153,40720,1569,3,220,1,241.42,NULL,'2024-09-02 17:35:42','2024-09-02 17:35:42',NULL),(4140,7812,1153,40720,1569,3,57,2,44501.49,NULL,'2024-09-02 17:35:42','2024-09-02 17:35:42',NULL),(4141,7812,1154,40720,1569,15,67,1,1442702.39,NULL,'2024-09-02 18:00:25','2024-09-02 18:00:25',NULL),(4142,7812,1154,40720,1569,15,68,2,1309519.73,NULL,'2024-09-02 18:00:25','2024-09-02 18:00:25',NULL),(4143,7812,1154,40720,1569,15,353,2,178529.60,NULL,'2024-09-02 18:00:25','2024-09-02 18:00:25',NULL),(4144,7812,1154,40720,1569,15,220,2,241.42,NULL,'2024-09-02 18:00:25','2024-09-02 18:00:25',NULL),(4145,7812,1154,40720,1569,15,353,1,45346.94,NULL,'2024-09-02 18:00:25','2024-09-02 18:00:25',NULL),(4146,7812,1154,40720,1569,15,136,1,241.42,NULL,'2024-09-02 18:00:25','2024-09-02 18:00:25',NULL),(4147,7812,1155,40825,4565,3,221,1,45295.12,NULL,'2024-09-08 09:49:34','2024-09-08 10:13:29','2024-09-08 10:13:29'),(4148,7812,1155,40825,4565,3,242,1,2441.96,NULL,'2024-09-08 09:49:34','2024-09-08 10:13:29','2024-09-08 10:13:29'),(4149,7812,1155,40825,4565,3,250,1,228207.81,NULL,'2024-09-08 09:49:34','2024-09-08 10:13:29','2024-09-08 10:13:29'),(4150,7812,1155,40825,4565,3,68,1,47923.64,NULL,'2024-09-08 09:49:34','2024-09-08 10:13:29','2024-09-08 10:13:29'),(4151,7812,1155,40825,4565,3,250,1,23868.56,NULL,'2024-09-08 09:49:34','2024-09-08 10:13:29','2024-09-08 10:13:29'),(4152,7812,1155,40825,4565,3,57,2,347737.09,NULL,'2024-09-08 09:49:34','2024-09-08 10:13:29','2024-09-08 10:13:29'),(4153,7812,1156,40825,4565,3,221,1,15098.37,NULL,'2024-09-08 09:49:34','2024-09-08 10:02:13','2024-09-08 10:02:13'),(4154,7812,1156,40825,4565,3,242,1,813.99,NULL,'2024-09-08 09:49:34','2024-09-08 10:02:13','2024-09-08 10:02:13'),(4155,7812,1156,40825,4565,3,250,1,76069.29,NULL,'2024-09-08 09:49:34','2024-09-08 10:02:13','2024-09-08 10:02:13'),(4156,7812,1156,40825,4565,3,68,1,15974.55,NULL,'2024-09-08 09:49:34','2024-09-08 10:02:13','2024-09-08 10:02:13'),(4157,7812,1156,40825,4565,3,250,1,7956.20,NULL,'2024-09-08 09:49:34','2024-09-08 10:02:13','2024-09-08 10:02:13'),(4158,7812,1156,40825,4565,3,57,2,115912.40,NULL,'2024-09-08 09:49:34','2024-09-08 10:02:13','2024-09-08 10:02:13'),(4159,7812,1157,40825,4565,3,221,1,47706.77,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:53','2024-09-08 10:01:53'),(4160,7812,1157,40825,4565,3,242,1,2571.97,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:53','2024-09-08 10:01:53'),(4161,7812,1157,40825,4565,3,250,1,240358.43,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:53','2024-09-08 10:01:53'),(4162,7812,1157,40825,4565,3,68,1,50475.27,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:53','2024-09-08 10:01:53'),(4163,7812,1157,40825,4565,3,250,1,25139.39,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:53','2024-09-08 10:01:53');
INSERT INTO `balance_libro_details` VALUES (4164,7812,1157,40825,4565,3,57,2,366251.83,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:53','2024-09-08 10:01:53'),(4165,7812,1158,40825,4565,3,221,1,62054.91,NULL,'2024-09-08 09:49:34','2024-09-08 10:11:23','2024-09-08 10:11:23'),(4166,7812,1158,40825,4565,3,242,1,3345.51,NULL,'2024-09-08 09:49:34','2024-09-08 10:11:23','2024-09-08 10:11:23'),(4167,7812,1158,40825,4565,3,250,1,312647.76,NULL,'2024-09-08 09:49:34','2024-09-08 10:11:23','2024-09-08 10:11:23'),(4168,7812,1158,40825,4565,3,68,1,65656.03,NULL,'2024-09-08 09:49:34','2024-09-08 10:11:23','2024-09-08 10:11:23'),(4169,7812,1158,40825,4565,3,250,1,32700.19,NULL,'2024-09-08 09:49:34','2024-09-08 10:11:23','2024-09-08 10:11:23'),(4170,7812,1158,40825,4565,3,57,2,476404.40,NULL,'2024-09-08 09:49:34','2024-09-08 10:11:23','2024-09-08 10:11:23'),(4171,7812,1159,40825,4565,3,221,1,41671.94,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:22','2024-09-08 10:01:22'),(4172,7812,1159,40825,4565,3,242,1,2246.62,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:22','2024-09-08 10:01:22'),(4173,7812,1159,40825,4565,3,250,1,209953.48,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:22','2024-09-08 10:01:22'),(4174,7812,1159,40825,4565,3,68,1,44090.23,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:22','2024-09-08 10:01:22'),(4175,7812,1159,40825,4565,3,250,1,21959.30,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:22','2024-09-08 10:01:22'),(4176,7812,1159,40825,4565,3,57,2,319921.57,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:22','2024-09-08 10:01:22'),(4177,7812,1160,40825,4565,3,221,1,30196.73,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:04','2024-09-08 10:01:04'),(4178,7812,1160,40825,4565,3,242,1,1627.97,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:04','2024-09-08 10:01:04'),(4179,7812,1160,40825,4565,3,250,1,152138.52,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:04','2024-09-08 10:01:04'),(4180,7812,1160,40825,4565,3,68,1,31949.09,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:04','2024-09-08 10:01:04'),(4181,7812,1160,40825,4565,3,250,1,15912.34,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:04','2024-09-08 10:01:04'),(4182,7812,1160,40825,4565,3,57,2,231824.65,NULL,'2024-09-08 09:49:34','2024-09-08 10:01:04','2024-09-08 10:01:04'),(4183,7812,1161,40825,4566,3,217,1,218433.71,NULL,'2024-09-08 11:12:26','2024-09-08 11:12:26',NULL),(4184,7812,1161,40825,4566,3,68,1,45871.08,NULL,'2024-09-08 11:12:26','2024-09-08 11:12:26',NULL),(4185,7812,1161,40825,4566,3,221,1,3924.87,NULL,'2024-09-08 11:12:26','2024-09-08 11:12:26',NULL),(4186,7812,1161,40825,4566,3,57,2,268229.66,NULL,'2024-09-08 11:12:26','2024-09-08 11:12:26',NULL),(4187,7812,1162,40825,4565,15,67,1,1707325.87,NULL,'2024-09-08 11:22:08','2024-09-08 11:22:08',NULL),(4188,7812,1162,40825,4565,15,68,2,760326.02,NULL,'2024-09-08 11:22:08','2024-09-08 11:22:08',NULL),(4189,7812,1162,40825,4565,15,353,2,10443.71,NULL,'2024-09-08 11:22:08','2024-09-08 11:22:08',NULL),(4190,7812,1162,40825,4565,15,354,2,388885.04,NULL,'2024-09-08 11:22:08','2024-09-08 11:22:08',NULL),(4191,7812,1162,40825,4565,15,74,2,547671.10,NULL,'2024-09-08 11:22:08','2024-09-08 11:22:08',NULL),(4192,7812,1163,40825,4567,3,217,1,22597.48,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4193,7812,1163,40825,4567,3,68,1,4745.47,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4194,7812,1163,40825,4567,3,217,1,2657.10,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4195,7812,1163,40825,4567,3,57,2,30000.05,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4196,7812,1164,40825,4567,3,217,1,23072.86,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4197,7812,1164,40825,4567,3,68,1,4845.30,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4198,7812,1164,40825,4567,3,217,1,2081.85,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4199,7812,1164,40825,4567,3,57,2,30000.01,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4200,7812,1165,40825,4567,3,217,1,23072.86,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL);
INSERT INTO `balance_libro_details` VALUES (4201,7812,1165,40825,4567,3,68,1,4845.30,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4202,7812,1165,40825,4567,3,217,1,2081.85,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4203,7812,1165,40825,4567,3,57,2,30000.01,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4204,7812,1166,40825,4567,3,217,1,60224.04,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4205,7812,1166,40825,4567,3,68,1,12647.05,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4206,7812,1166,40825,4567,3,217,1,5433.96,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4207,7812,1166,40825,4567,3,57,2,78305.05,NULL,'2024-09-14 09:46:40','2024-09-14 09:46:40',NULL),(4208,7812,1167,40825,4566,3,221,1,67049.97,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4209,7812,1167,40825,4566,3,242,1,3614.91,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4210,7812,1167,40825,4566,3,250,1,314609.57,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4211,7812,1167,40825,4566,3,68,1,66068.01,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4212,7812,1167,40825,4566,3,250,1,35332.46,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4213,7812,1167,40825,4566,3,57,2,486674.92,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4214,7812,1168,40825,4566,3,250,1,247933.90,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4215,7812,1168,40825,4566,3,68,1,52066.12,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4216,7812,1168,40825,4566,3,250,1,0.01,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4217,7812,1168,40825,4566,3,57,2,300000.03,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4218,7812,1169,40825,4566,3,221,1,64469.58,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4219,7812,1169,40825,4566,3,242,1,3475.80,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4220,7812,1169,40825,4566,3,250,1,302501.90,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4221,7812,1169,40825,4566,3,68,1,63525.40,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4222,7812,1169,40825,4566,3,250,1,33972.67,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4223,7812,1169,40825,4566,3,57,2,467945.35,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4224,7812,1170,40825,4566,3,217,1,223713.62,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4225,7812,1170,40825,4566,3,57,2,223713.62,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4226,7812,1171,40825,4566,3,250,1,53223.14,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4227,7812,1171,40825,4566,3,68,1,11176.86,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4228,7812,1171,40825,4566,3,57,2,64400.00,NULL,'2024-09-14 17:34:21','2024-09-14 17:34:21',NULL),(4229,7812,1172,40825,4566,15,67,1,600261.15,NULL,'2024-09-14 18:04:18','2024-09-14 18:04:18',NULL),(4230,7812,1172,40825,4566,15,68,2,238707.47,NULL,'2024-09-14 18:04:18','2024-09-14 18:04:18',NULL),(4231,7812,1172,40825,4566,15,74,2,361553.68,NULL,'2024-09-14 18:04:18','2024-09-14 18:04:18',NULL),(4232,7812,1173,40825,4567,15,68,2,27083.12,NULL,'2024-09-14 18:06:27','2024-09-14 18:06:27',NULL),(4233,7812,1173,40825,4567,15,353,1,27083.12,NULL,'2024-09-14 18:06:27','2024-09-14 18:06:27',NULL),(4234,7812,1174,40720,1570,3,250,1,350000.00,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4235,7812,1174,40720,1570,3,68,1,36750.00,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4236,7812,1174,40720,1570,3,57,2,386750.00,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4237,7812,1175,40720,1570,3,221,1,5162.94,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4238,7812,1175,40720,1570,3,242,1,278.36,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4239,7812,1175,40720,1570,3,250,1,22544.95,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4240,7812,1175,40720,1570,3,68,1,4734.44,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL);
INSERT INTO `balance_libro_details` VALUES (4241,7812,1175,40720,1570,3,250,1,2720.65,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4242,7812,1175,40720,1570,3,57,2,35441.34,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4243,7812,1176,40720,1570,3,250,1,350000.00,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4244,7812,1176,40720,1570,3,68,1,36750.00,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4245,7812,1176,40720,1570,3,57,2,386750.00,NULL,'2024-09-26 16:25:41','2024-09-26 16:25:41',NULL),(4246,7812,1177,40720,1570,3,250,1,700000.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4247,7812,1177,40720,1570,3,68,1,73500.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4248,7812,1177,40720,1570,3,57,2,773500.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4249,7812,1178,40720,1570,3,250,1,175000.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4250,7812,1178,40720,1570,3,68,1,18375.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4251,7812,1178,40720,1570,3,57,2,193375.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4252,7812,1179,40720,1570,3,250,1,11404.96,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4253,7812,1179,40720,1570,3,68,1,2395.04,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4254,7812,1179,40720,1570,3,57,2,13800.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4255,7812,1180,40720,1570,3,250,1,700000.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4256,7812,1180,40720,1570,3,68,1,73500.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4257,7812,1180,40720,1570,3,57,2,773500.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4258,7812,1181,40720,1570,3,221,1,1269.20,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4259,7812,1181,40720,1570,3,250,1,7215.57,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4260,7812,1181,40720,1570,3,68,1,1515.27,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4261,7812,1181,40720,1570,3,57,2,10000.04,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4262,7812,1182,40720,1570,3,242,1,68158.81,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4263,7812,1182,40720,1570,3,250,1,1893300.17,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4264,7812,1182,40720,1570,3,68,1,198796.52,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4265,7812,1182,40720,1570,3,57,2,2160255.50,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4266,7812,1183,40720,1570,3,250,1,525000.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4267,7812,1183,40720,1570,3,68,1,55125.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4268,7812,1183,40720,1570,3,57,2,580125.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4269,7812,1184,40720,1570,3,250,1,700000.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4270,7812,1184,40720,1570,3,68,1,73500.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4271,7812,1184,40720,1570,3,57,2,773500.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4272,7812,1185,40720,1570,3,250,1,17355.37,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4273,7812,1185,40720,1570,3,68,1,3644.63,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4274,7812,1185,40720,1570,3,57,2,21000.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4275,7812,1186,40720,1570,3,250,1,350000.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4276,7812,1186,40720,1570,3,68,1,36750.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4277,7812,1186,40720,1570,3,57,2,386750.00,NULL,'2024-09-26 16:25:42','2024-09-26 16:25:42',NULL),(4278,7812,1187,40720,1570,2,96,2,186691.52,NULL,'2024-09-26 16:27:00','2024-09-26 16:27:00',NULL),(4279,7812,1187,40720,1570,2,67,2,39205.22,NULL,'2024-09-26 16:27:00','2024-09-26 16:27:00',NULL),(4280,7812,1187,40720,1570,2,13,1,225896.74,NULL,'2024-09-26 16:27:00','2024-09-26 16:27:00',NULL);
INSERT INTO `balance_libro_details` VALUES (4281,7812,1188,40720,1570,2,96,2,583325.14,NULL,'2024-09-26 16:27:00','2024-09-26 16:27:00',NULL),(4282,7812,1188,40720,1570,2,67,2,122498.28,NULL,'2024-09-26 16:27:00','2024-09-26 16:27:00',NULL),(4283,7812,1188,40720,1570,2,218,2,0.01,NULL,'2024-09-26 16:27:00','2024-09-26 16:27:00',NULL),(4284,7812,1188,40720,1570,2,13,1,705823.43,NULL,'2024-09-26 16:27:00','2024-09-26 16:27:00',NULL),(4285,7812,1189,40720,1570,15,67,1,161703.50,NULL,'2024-09-26 16:35:12','2024-09-26 16:35:12',NULL),(4286,7812,1189,40720,1570,15,68,2,615335.90,NULL,'2024-09-26 16:35:12','2024-09-26 16:35:12',NULL),(4287,7812,1189,40720,1570,15,353,2,45346.94,NULL,'2024-09-26 16:35:12','2024-09-26 16:35:12',NULL),(4288,7812,1189,40720,1570,15,353,1,498979.34,NULL,'2024-09-26 16:35:12','2024-09-26 16:35:12',NULL),(4289,7812,1190,40825,4568,3,217,1,22954.62,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4290,7812,1190,40825,4568,3,68,1,4820.47,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4291,7812,1190,40825,4568,3,217,1,2233.87,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4292,7812,1190,40825,4568,3,57,2,30008.96,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4293,7812,1191,40825,4568,3,217,1,132231.40,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4294,7812,1191,40825,4568,3,68,1,27768.60,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4295,7812,1191,40825,4568,3,57,2,160000.00,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4296,7812,1192,40825,4568,3,250,1,8000.00,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4297,7812,1192,40825,4568,3,57,2,8000.00,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4298,7812,1193,40825,4568,3,217,1,48760.33,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4299,7812,1193,40825,4568,3,68,1,10239.67,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4300,7812,1193,40825,4568,3,57,2,59000.00,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4301,7812,1194,40825,4568,3,250,1,0.00,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4302,7812,1194,40825,4568,3,250,1,201197.00,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4303,7812,1194,40825,4568,3,57,2,201197.00,NULL,'2024-10-14 17:16:39','2024-10-14 17:16:39',NULL),(4304,7812,1195,40825,4568,3,250,1,0.00,NULL,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(4305,7812,1195,40825,4568,3,250,1,42998.99,NULL,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(4306,7812,1195,40825,4568,3,57,2,42998.99,NULL,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(4307,7812,1196,40825,4568,3,250,1,0.00,NULL,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(4308,7812,1196,40825,4568,3,250,1,135166.80,NULL,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(4309,7812,1196,40825,4568,3,57,2,135166.80,NULL,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(4310,7812,1197,40825,4568,3,217,1,284297.52,NULL,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(4311,7812,1197,40825,4568,3,68,1,59702.48,NULL,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(4312,7812,1197,40825,4568,3,57,2,344000.00,NULL,'2024-10-14 17:16:40','2024-10-14 17:16:40',NULL),(4313,7812,1198,40825,4568,15,68,2,102531.21,NULL,'2024-10-14 17:21:27','2024-10-14 17:21:27',NULL),(4314,7812,1198,40825,4568,15,353,2,27083.12,NULL,'2024-10-14 17:21:27','2024-10-14 17:21:27',NULL),(4315,7812,1198,40825,4568,15,353,1,129614.33,NULL,'2024-10-14 17:21:27','2024-10-14 17:21:27',NULL),(4316,7812,1199,40720,1571,3,250,1,525000.00,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4317,7812,1199,40720,1571,3,68,1,55125.00,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4318,7812,1199,40720,1571,3,57,2,580125.00,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4319,7812,1200,40720,1571,3,221,1,155.38,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4320,7812,1200,40720,1571,3,250,1,5179.43,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL);
INSERT INTO `balance_libro_details` VALUES (4321,7812,1200,40720,1571,3,68,1,1087.68,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4322,7812,1200,40720,1571,3,57,2,6422.49,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4323,7812,1201,40720,1571,3,250,1,630000.00,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4324,7812,1201,40720,1571,3,68,1,66150.00,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4325,7812,1201,40720,1571,3,57,2,696150.00,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4326,7812,1202,40720,1571,3,250,1,600000.00,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4327,7812,1202,40720,1571,3,68,1,63000.00,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4328,7812,1202,40720,1571,3,57,2,663000.00,NULL,'2024-11-19 17:24:19','2024-11-19 17:24:19',NULL),(4329,7812,1203,40720,1571,3,250,1,525000.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4330,7812,1203,40720,1571,3,68,1,55125.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4331,7812,1203,40720,1571,3,57,2,580125.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4332,7812,1204,40720,1571,3,221,1,50582.81,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4333,7812,1204,40720,1571,3,242,1,2727.19,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4334,7812,1204,40720,1571,3,250,1,225905.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4335,7812,1204,40720,1571,3,68,1,47440.05,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4336,7812,1204,40720,1571,3,250,1,26655.02,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4337,7812,1204,40720,1571,3,57,2,353310.07,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4338,7812,1205,40720,1571,3,221,1,26.41,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4339,7812,1205,40720,1571,3,250,1,880.18,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4340,7812,1205,40720,1571,3,68,1,92.42,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4341,7812,1205,40720,1571,3,57,2,999.01,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4342,7812,1206,40720,1571,3,250,1,525000.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4343,7812,1206,40720,1571,3,68,1,55125.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4344,7812,1206,40720,1571,3,57,2,580125.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4345,7812,1207,40720,1571,3,250,1,280000.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4346,7812,1207,40720,1571,3,68,1,29400.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4347,7812,1207,40720,1571,3,57,2,309400.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4348,7812,1208,40720,1571,3,250,1,350000.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4349,7812,1208,40720,1571,3,68,1,36750.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4350,7812,1208,40720,1571,3,57,2,386750.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4351,7812,1209,40720,1571,3,250,1,525000.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4352,7812,1209,40720,1571,3,68,1,55125.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4353,7812,1209,40720,1571,3,57,2,580125.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4354,7812,1210,40720,1571,3,250,1,750000.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4355,7812,1210,40720,1571,3,68,1,78750.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4356,7812,1210,40720,1571,3,57,2,828750.00,NULL,'2024-11-19 17:24:20','2024-11-19 17:24:20',NULL),(4357,7812,1211,40720,1571,15,68,2,543170.15,NULL,'2024-11-19 17:30:09','2024-11-19 17:30:09',NULL),(4358,7812,1211,40720,1571,15,353,2,498979.34,NULL,'2024-11-19 17:30:09','2024-11-19 17:30:09',NULL),(4359,7812,1211,40720,1571,15,353,1,1042149.49,NULL,'2024-11-19 17:30:09','2024-11-19 17:30:09',NULL),(4360,7812,1212,40720,1572,3,250,1,121900.86,NULL,'2024-11-19 17:32:55','2024-11-19 17:32:55',NULL);
INSERT INTO `balance_libro_details` VALUES (4361,7812,1212,40720,1572,3,68,1,25599.18,NULL,'2024-11-19 17:32:55','2024-11-19 17:32:55',NULL),(4362,7812,1212,40720,1572,3,250,1,0.02,NULL,'2024-11-19 17:32:55','2024-11-19 17:32:55',NULL),(4363,7812,1212,40720,1572,3,57,2,147500.06,NULL,'2024-11-19 17:32:55','2024-11-19 17:32:55',NULL),(4364,7812,1213,40720,1572,3,250,1,500000.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4365,7812,1213,40720,1572,3,68,1,52500.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4366,7812,1213,40720,1572,3,57,2,552500.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4367,7812,1214,40720,1572,3,221,1,6883.93,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4368,7812,1214,40720,1572,3,242,1,371.15,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4369,7812,1214,40720,1572,3,250,1,30059.90,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4370,7812,1214,40720,1572,3,68,1,6312.58,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4371,7812,1214,40720,1572,3,250,1,3627.52,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4372,7812,1214,40720,1572,3,57,2,47255.08,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4373,7812,1215,40720,1572,3,250,1,500000.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4374,7812,1215,40720,1572,3,68,1,52500.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4375,7812,1215,40720,1572,3,57,2,552500.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4376,7812,1216,40720,1572,3,250,1,750000.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4377,7812,1216,40720,1572,3,68,1,78750.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4378,7812,1216,40720,1572,3,57,2,828750.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4379,7812,1217,40720,1572,3,221,1,6883.36,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4380,7812,1217,40720,1572,3,242,1,371.12,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4381,7812,1217,40720,1572,3,250,1,30060.10,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4382,7812,1217,40720,1572,3,68,1,6312.62,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4383,7812,1217,40720,1572,3,250,1,3627.23,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4384,7812,1217,40720,1572,3,57,2,47254.43,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4385,7812,1218,40720,1572,3,217,1,785123.95,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4386,7812,1218,40720,1572,3,68,1,164876.03,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4387,7812,1218,40720,1572,3,217,1,0.02,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4388,7812,1218,40720,1572,3,57,2,950000.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4389,7812,1219,40720,1572,3,250,1,26498.36,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4390,7812,1219,40720,1572,3,68,1,2782.33,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4391,7812,1219,40720,1572,3,57,2,29280.69,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4392,7812,1220,40720,1572,3,217,1,58460.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4393,7812,1220,40720,1572,3,57,2,58460.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4394,7812,1221,40720,1572,3,250,1,53524.79,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4395,7812,1221,40720,1572,3,68,1,11240.21,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4396,7812,1221,40720,1572,3,57,2,64765.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4397,7812,1222,40720,1572,3,250,1,15537.19,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4398,7812,1222,40720,1572,3,68,1,3262.81,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4399,7812,1222,40720,1572,3,57,2,18800.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4400,7812,1223,40720,1572,3,221,1,6885.79,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL);
INSERT INTO `balance_libro_details` VALUES (4401,7812,1223,40720,1572,3,242,1,371.25,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4402,7812,1223,40720,1572,3,250,1,30068.14,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4403,7812,1223,40720,1572,3,68,1,6314.31,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4404,7812,1223,40720,1572,3,250,1,3628.54,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4405,7812,1223,40720,1572,3,57,2,47268.03,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4406,7812,1224,40720,1572,3,250,1,500000.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4407,7812,1224,40720,1572,3,68,1,52500.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4408,7812,1224,40720,1572,3,57,2,552500.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4409,7812,1225,40720,1572,3,250,1,1500000.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4410,7812,1225,40720,1572,3,68,1,157500.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4411,7812,1225,40720,1572,3,57,2,1657500.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4412,7812,1226,40720,1572,3,221,1,8604.87,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4413,7812,1226,40720,1572,3,242,1,463.93,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4414,7812,1226,40720,1572,3,250,1,37574.81,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4415,7812,1226,40720,1572,3,68,1,7890.71,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4416,7812,1226,40720,1572,3,250,1,4534.38,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4417,7812,1226,40720,1572,3,57,2,59068.70,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4418,7812,1227,40720,1572,3,250,1,600000.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4419,7812,1227,40720,1572,3,68,1,63000.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4420,7812,1227,40720,1572,3,57,2,663000.00,NULL,'2024-11-19 17:32:56','2024-11-19 17:32:56',NULL),(4421,7812,1228,40720,1572,3,250,1,147107.44,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4422,7812,1228,40720,1572,3,68,1,30892.56,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4423,7812,1228,40720,1572,3,57,2,178000.00,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4424,7812,1229,40720,1572,3,250,1,120909.09,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4425,7812,1229,40720,1572,3,68,1,25390.91,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4426,7812,1229,40720,1572,3,57,2,146300.00,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4427,7812,1230,40720,1572,3,250,1,400000.00,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4428,7812,1230,40720,1572,3,68,1,42000.00,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4429,7812,1230,40720,1572,3,57,2,442000.00,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4430,7812,1231,40720,1572,3,221,1,6195.53,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4431,7812,1231,40720,1572,3,242,1,334.03,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4432,7812,1231,40720,1572,3,250,1,27053.90,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4433,7812,1231,40720,1572,3,68,1,5681.32,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4434,7812,1231,40720,1572,3,250,1,3264.76,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4435,7812,1231,40720,1572,3,57,2,42529.54,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4436,7812,1232,40720,1572,3,250,1,2892.56,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4437,7812,1232,40720,1572,3,68,1,607.44,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4438,7812,1232,40720,1572,3,57,2,3500.00,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4439,7812,1233,40720,1572,3,250,1,500000.00,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4440,7812,1233,40720,1572,3,68,1,52500.00,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL);
INSERT INTO `balance_libro_details` VALUES (4441,7812,1233,40720,1572,3,57,2,552500.00,NULL,'2024-11-19 17:32:57','2024-11-19 17:32:57',NULL),(4442,7812,1234,40720,1572,15,68,2,848413.00,NULL,'2024-11-19 17:37:46','2024-11-19 17:37:46',NULL),(4443,7812,1234,40720,1572,15,353,2,1042149.49,NULL,'2024-11-19 17:37:46','2024-11-19 17:37:46',NULL),(4444,7812,1234,40720,1572,15,353,1,1890562.49,NULL,'2024-11-19 17:37:46','2024-11-19 17:37:46',NULL),(4445,7812,1235,40825,4569,2,96,2,878640.00,NULL,'2024-11-19 17:45:13','2024-11-19 17:45:13',NULL),(4446,7812,1235,40825,4569,2,67,2,184514.40,NULL,'2024-11-19 17:45:13','2024-11-19 17:45:13',NULL),(4447,7812,1235,40825,4569,2,13,1,1063154.40,NULL,'2024-11-19 17:45:13','2024-11-19 17:45:13',NULL),(4448,7812,1236,40825,4569,3,221,1,21513.44,NULL,'2024-11-19 17:46:32','2024-11-19 17:46:32',NULL),(4449,7812,1236,40825,4569,3,242,1,1159.90,NULL,'2024-11-19 17:46:32','2024-11-19 17:46:32',NULL),(4450,7812,1236,40825,4569,3,250,1,93942.48,NULL,'2024-11-19 17:46:32','2024-11-19 17:46:32',NULL),(4451,7812,1236,40825,4569,3,68,1,19727.92,NULL,'2024-11-19 17:46:32','2024-11-19 17:46:32',NULL),(4452,7812,1236,40825,4569,3,250,1,11336.69,NULL,'2024-11-19 17:46:32','2024-11-19 17:46:32',NULL),(4453,7812,1236,40825,4569,3,57,2,147680.43,NULL,'2024-11-19 17:46:32','2024-11-19 17:46:32',NULL),(4454,7812,1237,40825,4569,3,221,1,8608.85,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4455,7812,1237,40825,4569,3,242,1,464.15,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4456,7812,1237,40825,4569,3,250,1,37592.19,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4457,7812,1237,40825,4569,3,68,1,7894.36,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4458,7812,1237,40825,4569,3,250,1,4536.52,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4459,7812,1237,40825,4569,3,57,2,59096.07,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4460,7812,1238,40825,4569,3,217,1,210000.00,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4461,7812,1238,40825,4569,3,57,2,210000.00,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4462,7812,1239,40825,4569,3,250,1,118097.52,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4463,7812,1239,40825,4569,3,68,1,24800.48,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4464,7812,1239,40825,4569,3,57,2,142898.00,NULL,'2024-11-19 17:46:33','2024-11-19 17:46:33',NULL),(4465,7812,1240,40825,4569,15,67,1,184514.40,NULL,'2025-02-03 17:41:06','2025-02-03 17:41:06',NULL),(4466,7812,1240,40825,4569,15,68,2,52422.76,NULL,'2025-02-03 17:41:06','2025-02-03 17:41:06',NULL),(4467,7812,1240,40825,4569,15,353,2,129614.33,NULL,'2025-02-03 17:41:06','2025-02-03 17:41:06',NULL),(4468,7812,1240,40825,4569,15,74,2,2477.31,NULL,'2025-02-03 17:41:06','2025-02-03 17:41:06',NULL),(4469,7812,1241,40825,4570,3,250,1,62809.92,NULL,'2025-02-03 17:43:38','2025-02-03 17:43:38',NULL),(4470,7812,1241,40825,4570,3,68,1,13190.08,NULL,'2025-02-03 17:43:38','2025-02-03 17:43:38',NULL),(4471,7812,1241,40825,4570,3,57,2,76000.00,NULL,'2025-02-03 17:43:38','2025-02-03 17:43:38',NULL),(4472,7812,1242,40825,4571,3,250,1,158677.69,NULL,'2025-02-03 17:44:25','2025-02-03 17:44:25',NULL),(4473,7812,1242,40825,4571,3,68,1,33322.31,NULL,'2025-02-03 17:44:25','2025-02-03 17:44:25',NULL),(4474,7812,1242,40825,4571,3,57,2,192000.00,NULL,'2025-02-03 17:44:25','2025-02-03 17:44:25',NULL),(4475,7812,1243,40825,4575,3,217,1,412231.38,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4476,7812,1243,40825,4575,3,68,1,86568.59,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4477,7812,1243,40825,4575,3,217,1,0.02,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4478,7812,1243,40825,4575,3,57,2,498799.99,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4479,7812,1244,40825,4575,3,250,1,180165.29,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4480,7812,1244,40825,4575,3,68,1,37834.71,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL);
INSERT INTO `balance_libro_details` VALUES (4481,7812,1244,40825,4575,3,57,2,218000.00,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4482,7812,1245,40825,4575,3,250,1,160578.51,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4483,7812,1245,40825,4575,3,68,1,33721.49,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4484,7812,1245,40825,4575,3,57,2,194300.00,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4485,7812,1246,40825,4575,3,250,1,16528.92,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4486,7812,1246,40825,4575,3,68,1,3471.07,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4487,7812,1246,40825,4575,3,57,2,19999.99,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4488,7812,1247,40825,4575,3,250,2,180165.29,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4489,7812,1247,40825,4575,3,67,2,37834.71,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4490,7812,1247,40825,4575,3,57,1,218000.00,NULL,'2025-02-03 17:44:46','2025-02-03 17:44:46',NULL),(4491,7812,1248,40825,4570,15,68,2,13190.08,NULL,'2025-02-03 17:46:53','2025-02-03 17:46:53',NULL),(4492,7812,1248,40825,4570,15,353,1,13190.08,NULL,'2025-02-03 17:46:53','2025-02-03 17:46:53',NULL),(4493,7812,1249,40825,4571,15,68,2,33322.31,NULL,'2025-02-03 17:48:35','2025-02-03 17:48:35',NULL),(4494,7812,1249,40825,4571,15,353,2,13190.08,NULL,'2025-02-03 17:48:35','2025-02-03 17:48:35',NULL),(4495,7812,1249,40825,4571,15,353,1,46512.39,NULL,'2025-02-03 17:48:35','2025-02-03 17:48:35',NULL),(4496,7812,1250,40825,4575,15,67,1,37834.71,NULL,'2025-02-03 17:55:10','2025-02-03 17:55:10',NULL),(4497,7812,1250,40825,4575,15,68,2,161595.86,NULL,'2025-02-03 17:55:10','2025-02-03 17:55:10',NULL),(4498,7812,1250,40825,4575,15,353,2,46512.39,NULL,'2025-02-03 17:55:10','2025-02-03 17:55:10',NULL),(4499,7812,1250,40825,4575,15,353,1,170273.54,NULL,'2025-02-03 17:55:10','2025-02-03 17:55:10',NULL),(4500,7812,1251,40720,1573,3,250,1,750000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4501,7812,1251,40720,1573,3,68,1,78750.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4502,7812,1251,40720,1573,3,57,2,828750.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4503,7812,1252,40720,1573,3,250,1,300000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4504,7812,1252,40720,1573,3,68,1,31500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4505,7812,1252,40720,1573,3,57,2,331500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4506,7812,1253,40720,1573,3,250,1,300000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4507,7812,1253,40720,1573,3,68,1,31500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4508,7812,1253,40720,1573,3,57,2,331500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4509,7812,1254,40720,1573,3,250,1,300000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4510,7812,1254,40720,1573,3,68,1,31500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4511,7812,1254,40720,1573,3,57,2,331500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4512,7812,1255,40720,1573,3,250,1,12396.69,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4513,7812,1255,40720,1573,3,68,1,2603.30,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4514,7812,1255,40720,1573,3,57,2,14999.99,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4515,7812,1256,40720,1573,3,250,1,300000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4516,7812,1256,40720,1573,3,68,1,31500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4517,7812,1256,40720,1573,3,57,2,331500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4518,7812,1257,40720,1573,3,250,1,300000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4519,7812,1257,40720,1573,3,68,1,31500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4520,7812,1257,40720,1573,3,57,2,331500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL);
INSERT INTO `balance_libro_details` VALUES (4521,7812,1258,40720,1573,3,250,1,99173.55,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4522,7812,1258,40720,1573,3,68,1,20826.45,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4523,7812,1258,40720,1573,3,57,2,120000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4524,7812,1259,40720,1573,3,250,1,300000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4525,7812,1259,40720,1573,3,68,1,31500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4526,7812,1259,40720,1573,3,57,2,331500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4527,7812,1260,40720,1573,3,250,1,44628.10,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4528,7812,1260,40720,1573,3,68,1,9371.90,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4529,7812,1260,40720,1573,3,57,2,54000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4530,7812,1261,40720,1573,3,250,1,300000.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4531,7812,1261,40720,1573,3,68,1,31500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4532,7812,1261,40720,1573,3,57,2,331500.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4533,7812,1262,40720,1573,3,217,1,27900.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4534,7812,1262,40720,1573,3,57,2,27900.00,NULL,'2025-02-16 10:18:00','2025-02-16 10:18:00',NULL),(4535,7812,1263,40720,1574,3,250,1,300000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4536,7812,1263,40720,1574,3,68,1,31500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4537,7812,1263,40720,1574,3,57,2,331500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4538,7812,1264,40720,1574,3,250,1,9917.36,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4539,7812,1264,40720,1574,3,68,1,2082.65,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4540,7812,1264,40720,1574,3,57,2,12000.01,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4541,7812,1265,40720,1574,3,250,1,300000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4542,7812,1265,40720,1574,3,68,1,31500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4543,7812,1265,40720,1574,3,57,2,331500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4544,7812,1266,40720,1574,3,250,1,300000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4545,7812,1266,40720,1574,3,68,1,31500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4546,7812,1266,40720,1574,3,57,2,331500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4547,7812,1267,40720,1574,3,217,1,60000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4548,7812,1267,40720,1574,3,57,2,60000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4549,7812,1268,40720,1574,3,217,1,40000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4550,7812,1268,40720,1574,3,57,2,40000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4551,7812,1269,40720,1574,3,250,1,300000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4552,7812,1269,40720,1574,3,68,1,31500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4553,7812,1269,40720,1574,3,57,2,331500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4554,7812,1270,40720,1574,3,217,1,207107.38,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4555,7812,1270,40720,1574,3,68,1,43492.55,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4556,7812,1270,40720,1574,3,217,1,0.08,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4557,7812,1270,40720,1574,3,57,2,250600.01,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4558,7812,1271,40720,1574,3,250,1,1314027.15,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4559,7812,1271,40720,1574,3,68,1,137972.85,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4560,7812,1271,40720,1574,3,57,2,1452000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL);
INSERT INTO `balance_libro_details` VALUES (4561,7812,1272,40720,1574,3,221,1,9608.27,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4562,7812,1272,40720,1574,3,242,1,285.49,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4563,7812,1272,40720,1574,3,250,1,20705.05,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4564,7812,1272,40720,1574,3,68,1,4348.06,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4565,7812,1272,40720,1574,3,250,1,4946.90,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4566,7812,1272,40720,1574,3,57,2,39893.77,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4567,7812,1273,40720,1574,3,250,1,300000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4568,7812,1273,40720,1574,3,68,1,31500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4569,7812,1273,40720,1574,3,57,2,331500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4570,7812,1274,40720,1574,3,250,1,300000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4571,7812,1274,40720,1574,3,68,1,31500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4572,7812,1274,40720,1574,3,57,2,331500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4573,7812,1275,40720,1574,3,250,1,300000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4574,7812,1275,40720,1574,3,68,1,31500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4575,7812,1275,40720,1574,3,57,2,331500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4576,7812,1276,40720,1574,3,250,1,300000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4577,7812,1276,40720,1574,3,68,1,31500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4578,7812,1276,40720,1574,3,57,2,331500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4579,7812,1277,40720,1574,3,250,1,300000.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4580,7812,1277,40720,1574,3,68,1,31500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4581,7812,1277,40720,1574,3,57,2,331500.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4582,7812,1278,40720,1574,3,57,2,0.00,NULL,'2025-02-16 10:18:17','2025-02-16 10:18:17',NULL),(4583,7812,1279,40720,1578,3,217,1,300000.00,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4584,7812,1279,40720,1578,3,68,1,31500.00,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4585,7812,1279,40720,1578,3,57,2,331500.00,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4586,7812,1280,40720,1578,3,217,1,52905.81,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4587,7812,1280,40720,1578,3,68,1,11110.22,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4588,7812,1280,40720,1578,3,217,1,6013.91,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4589,7812,1280,40720,1578,3,57,2,70029.94,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4590,7812,1281,40720,1578,3,217,1,9008.26,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4591,7812,1281,40720,1578,3,68,1,1891.73,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4592,7812,1281,40720,1578,3,57,2,10899.99,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4593,7812,1282,40720,1578,3,217,1,300000.00,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4594,7812,1282,40720,1578,3,68,1,31500.00,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4595,7812,1282,40720,1578,3,57,2,331500.00,NULL,'2025-02-16 10:18:38','2025-02-16 10:18:38',NULL),(4596,7812,1283,40720,1578,3,217,1,38781.82,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4597,7812,1283,40720,1578,3,68,1,8144.18,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4598,7812,1283,40720,1578,3,57,2,46926.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4599,7812,1284,40720,1578,3,217,1,300000.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4600,7812,1284,40720,1578,3,68,1,31500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL);
INSERT INTO `balance_libro_details` VALUES (4601,7812,1284,40720,1578,3,57,2,331500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4602,7812,1285,40720,1578,3,217,1,300000.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4603,7812,1285,40720,1578,3,68,1,31500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4604,7812,1285,40720,1578,3,57,2,331500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4605,7812,1286,40720,1578,3,217,1,300000.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4606,7812,1286,40720,1578,3,68,1,31500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4607,7812,1286,40720,1578,3,57,2,331500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4608,7812,1287,40720,1578,3,217,1,300000.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4609,7812,1287,40720,1578,3,68,1,31500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4610,7812,1287,40720,1578,3,57,2,331500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4611,7812,1288,40720,1578,3,217,1,79008.24,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4612,7812,1288,40720,1578,3,68,1,16591.73,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4613,7812,1288,40720,1578,3,217,1,0.02,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4614,7812,1288,40720,1578,3,57,2,95599.99,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4615,7812,1289,40720,1578,3,217,1,222149.33,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4616,7812,1289,40720,1578,3,68,1,46651.36,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4617,7812,1289,40720,1578,3,217,1,0.03,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4618,7812,1289,40720,1578,3,57,2,268800.72,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4619,7812,1290,40720,1578,3,217,1,196722.95,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4620,7812,1290,40720,1578,3,68,1,41311.82,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4621,7812,1290,40720,1578,3,217,1,0.01,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4622,7812,1290,40720,1578,3,57,2,238034.78,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4623,7812,1291,40720,1578,3,217,1,203716.81,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4624,7812,1291,40720,1578,3,68,1,42780.53,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4625,7812,1291,40720,1578,3,217,1,-0.01,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4626,7812,1291,40720,1578,3,57,2,246497.33,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4627,7812,1292,40720,1578,3,217,1,203716.81,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4628,7812,1292,40720,1578,3,68,1,42780.53,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4629,7812,1292,40720,1578,3,217,1,-0.01,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4630,7812,1292,40720,1578,3,57,2,246497.33,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4631,7812,1293,40720,1578,3,217,1,300000.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4632,7812,1293,40720,1578,3,68,1,31500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4633,7812,1293,40720,1578,3,57,2,331500.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4634,7812,1294,40720,1578,3,217,1,11570.25,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4635,7812,1294,40720,1578,3,68,1,2429.75,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4636,7812,1294,40720,1578,3,57,2,14000.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4637,7812,1295,40720,1578,3,217,1,60838.84,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4638,7812,1295,40720,1578,3,68,1,12776.16,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4639,7812,1295,40720,1578,3,57,2,73615.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4640,7812,1296,40720,1578,3,217,1,67859.71,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL);
INSERT INTO `balance_libro_details` VALUES (4641,7812,1296,40720,1578,3,68,1,7125.27,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4642,7812,1296,40720,1578,3,217,1,0.02,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4643,7812,1296,40720,1578,3,57,2,74985.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4644,7812,1297,40720,1578,3,217,1,450000.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4645,7812,1297,40720,1578,3,68,1,47250.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4646,7812,1297,40720,1578,3,57,2,497250.00,NULL,'2025-02-16 10:18:39','2025-02-16 10:18:39',NULL),(4647,7812,1298,40720,1573,15,68,2,332051.65,NULL,'2025-02-16 10:22:15','2025-02-16 10:22:15',NULL),(4648,7812,1298,40720,1573,15,353,2,1890562.49,NULL,'2025-02-16 10:22:15','2025-02-16 10:22:15',NULL),(4649,7812,1298,40720,1573,15,353,1,2222614.14,NULL,'2025-02-16 10:22:15','2025-02-16 10:22:15',NULL),(4650,7812,1299,40720,1574,15,68,2,471396.11,NULL,'2025-02-16 10:24:26','2025-02-16 10:24:26',NULL),(4651,7812,1299,40720,1574,15,353,2,2222614.14,NULL,'2025-02-16 10:24:26','2025-02-16 10:24:26',NULL),(4652,7812,1299,40720,1574,15,353,1,2694010.25,NULL,'2025-02-16 10:24:26','2025-02-16 10:24:26',NULL),(4653,7812,1300,40720,1578,3,221,1,5179.89,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4654,7812,1300,40720,1578,3,242,1,153.91,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4655,7812,1300,40720,1578,3,250,1,14324.90,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4656,7812,1300,40720,1578,3,68,1,3008.23,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4657,7812,1300,40720,1578,3,250,1,2666.90,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4658,7812,1300,40720,1578,3,57,2,25333.83,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4659,7812,1301,40720,1578,3,221,1,9801.13,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4660,7812,1301,40720,1578,3,242,1,291.27,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4661,7812,1301,40720,1578,3,250,1,20623.00,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4662,7812,1301,40720,1578,3,68,1,4330.83,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4663,7812,1301,40720,1578,3,250,1,5046.21,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4664,7812,1301,40720,1578,3,57,2,40092.44,NULL,'2025-02-16 10:31:23','2025-02-16 10:31:23',NULL),(4665,7812,1302,40720,1578,15,68,2,508682.34,NULL,'2025-02-16 10:35:48','2025-02-16 10:35:48',NULL),(4666,7812,1302,40720,1578,15,353,2,2694010.25,NULL,'2025-02-16 10:35:48','2025-02-16 10:35:48',NULL),(4667,7812,1302,40720,1578,15,353,1,3202692.59,NULL,'2025-02-16 10:35:48','2025-02-16 10:35:48',NULL),(4668,7812,1303,40825,4576,3,217,1,520247.95,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4669,7812,1303,40825,4576,3,68,1,109252.07,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4670,7812,1303,40825,4576,3,217,1,0.02,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4671,7812,1303,40825,4576,3,57,2,629500.04,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4672,7812,1304,40825,4576,3,250,1,23000.00,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4673,7812,1304,40825,4576,3,57,2,23000.00,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4674,7812,1305,40825,4576,3,242,1,289.26,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4675,7812,1305,40825,4576,3,217,1,4132.23,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4676,7812,1305,40825,4576,3,68,1,867.77,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4677,7812,1305,40825,4576,3,57,2,5289.26,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4678,7812,1306,40825,4576,3,242,1,2834.71,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4679,7812,1306,40825,4576,3,217,1,40495.86,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4680,7812,1306,40825,4576,3,68,1,8504.13,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL);
INSERT INTO `balance_libro_details` VALUES (4681,7812,1306,40825,4576,3,57,2,51834.70,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4682,7812,1307,40825,4576,3,217,1,26280.99,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4683,7812,1307,40825,4576,3,68,1,5519.01,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4684,7812,1307,40825,4576,3,57,2,31800.00,NULL,'2025-04-02 19:31:32','2025-04-02 19:31:32',NULL),(4685,7812,1308,40825,4576,15,68,2,124142.98,NULL,'2025-04-02 19:35:34','2025-04-02 19:35:34',NULL),(4686,7812,1308,40825,4576,15,353,2,170273.54,NULL,'2025-04-02 19:35:34','2025-04-02 19:35:34',NULL),(4687,7812,1308,40825,4576,15,353,1,294416.52,NULL,'2025-04-02 19:35:34','2025-04-02 19:35:34',NULL),(4688,7812,1309,40825,4577,15,353,2,294416.52,NULL,'2025-04-02 19:39:09','2025-04-02 19:39:09',NULL),(4689,7812,1309,40825,4577,15,353,1,294416.52,NULL,'2025-04-02 19:39:09','2025-04-02 19:39:09',NULL),(4690,7812,1310,40825,4578,3,217,1,137851.24,NULL,'2025-06-07 08:48:27','2025-06-07 08:48:27',NULL),(4691,7812,1310,40825,4578,3,68,1,28948.76,NULL,'2025-06-07 08:48:27','2025-06-07 08:48:27',NULL),(4692,7812,1310,40825,4578,3,57,2,166800.00,NULL,'2025-06-07 08:48:27','2025-06-07 08:48:27',NULL),(4693,7812,1311,40825,4578,3,250,1,360956.79,NULL,'2025-06-07 08:48:27','2025-06-07 08:48:27',NULL),(4694,7812,1311,40825,4578,3,57,2,360956.79,NULL,'2025-06-07 08:48:27','2025-06-07 08:48:27',NULL),(4695,7812,1312,40825,4580,3,217,1,427698.35,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:37','2025-06-07 09:06:37'),(4696,7812,1312,40825,4580,3,68,1,89816.65,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:37','2025-06-07 09:06:37'),(4697,7812,1312,40825,4580,3,217,1,7485.00,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:37','2025-06-07 09:06:37'),(4698,7812,1312,40825,4580,3,57,2,525000.00,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:37','2025-06-07 09:06:37'),(4699,7812,1313,40825,4580,3,217,1,23966.94,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:37','2025-06-07 09:06:37'),(4700,7812,1313,40825,4580,3,68,1,5033.06,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:37','2025-06-07 09:06:37'),(4701,7812,1313,40825,4580,3,57,2,29000.00,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:37','2025-06-07 09:06:37'),(4702,7812,1314,40825,4580,3,217,1,82644.63,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:24','2025-06-07 09:06:24'),(4703,7812,1314,40825,4580,3,68,1,17355.37,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:24','2025-06-07 09:06:24'),(4704,7812,1314,40825,4580,3,57,2,100000.00,NULL,'2025-06-07 08:53:33','2025-06-07 09:06:24','2025-06-07 09:06:24'),(4705,7812,1315,40825,4578,15,68,2,28948.76,NULL,'2025-06-07 08:57:19','2025-06-07 08:57:19',NULL),(4706,7812,1315,40825,4578,15,353,2,294416.52,NULL,'2025-06-07 08:57:19','2025-06-07 08:57:19',NULL),(4707,7812,1315,40825,4578,15,353,1,323365.28,NULL,'2025-06-07 08:57:19','2025-06-07 08:57:19',NULL),(4708,7812,1316,40825,4580,15,68,2,112205.08,NULL,'2025-06-07 08:57:42','2025-06-07 08:57:55','2025-06-07 08:57:55'),(4709,7812,1316,40825,4580,15,353,1,112205.08,NULL,'2025-06-07 08:57:42','2025-06-07 08:57:55','2025-06-07 08:57:55'),(4710,7812,1317,40825,4579,3,217,1,427698.35,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(4711,7812,1317,40825,4579,3,68,1,89816.65,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(4712,7812,1317,40825,4579,3,217,1,7485.00,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(4713,7812,1317,40825,4579,3,57,2,525000.00,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(4714,7812,1318,40825,4579,3,217,1,23966.94,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(4715,7812,1318,40825,4579,3,68,1,5033.06,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(4716,7812,1318,40825,4579,3,57,2,29000.00,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(4717,7812,1319,40825,4579,3,217,1,82644.63,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(4718,7812,1319,40825,4579,3,68,1,17355.37,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL);
INSERT INTO `balance_libro_details` VALUES (4719,7812,1319,40825,4579,3,57,2,100000.00,NULL,'2025-06-07 09:07:03','2025-06-07 09:07:03',NULL),(4720,7812,1321,40825,4579,15,68,2,112205.08,NULL,'2025-06-07 09:10:07','2025-06-07 09:10:07',NULL),(4721,7812,1321,40825,4579,15,353,2,323365.28,NULL,'2025-06-07 09:10:07','2025-06-07 09:10:07',NULL),(4722,7812,1321,40825,4579,15,353,1,435570.36,NULL,'2025-06-07 09:10:07','2025-06-07 09:10:07',NULL),(4723,7812,1322,40720,1579,3,217,1,300000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4724,7812,1322,40720,1579,3,68,1,31500.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4725,7812,1322,40720,1579,3,57,2,331500.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4726,7812,1323,40720,1579,3,217,1,16803.31,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4727,7812,1323,40720,1579,3,68,1,3528.69,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4728,7812,1323,40720,1579,3,57,2,20332.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4729,7812,1324,40720,1579,3,250,1,186557.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4730,7812,1324,40720,1579,3,57,2,186557.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4731,7812,1325,40720,1579,3,217,1,300000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4732,7812,1325,40720,1579,3,68,1,31500.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4733,7812,1325,40720,1579,3,57,2,331500.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4734,7812,1326,40720,1579,3,217,1,450000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4735,7812,1326,40720,1579,3,68,1,47250.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4736,7812,1326,40720,1579,3,57,2,497250.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4737,7812,1327,40720,1579,3,217,1,18979.33,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4738,7812,1327,40720,1579,3,68,1,3985.66,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4739,7812,1327,40720,1579,3,57,2,22964.99,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4740,7812,1328,40720,1579,3,217,1,123966.94,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4741,7812,1328,40720,1579,3,68,1,26033.06,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4742,7812,1328,40720,1579,3,57,2,150000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4743,7812,1329,40720,1579,3,221,1,842.46,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4744,7812,1329,40720,1579,3,217,1,17898.80,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4745,7812,1329,40720,1579,3,68,1,3758.75,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4746,7812,1329,40720,1579,3,217,1,0.01,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4747,7812,1329,40720,1579,3,57,2,22500.02,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4748,7812,1330,40720,1579,3,217,1,375000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4749,7812,1330,40720,1579,3,68,1,39375.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4750,7812,1330,40720,1579,3,57,2,414375.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4751,7812,1331,40720,1579,3,217,1,450000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4752,7812,1331,40720,1579,3,68,1,47250.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4753,7812,1331,40720,1579,3,57,2,497250.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4754,7812,1332,40720,1579,3,217,1,450000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4755,7812,1332,40720,1579,3,68,1,47250.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4756,7812,1332,40720,1579,3,57,2,497250.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4757,7812,1333,40720,1579,3,250,1,97078.41,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4758,7812,1333,40720,1579,3,57,2,97078.41,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL);
INSERT INTO `balance_libro_details` VALUES (4759,7812,1334,40720,1579,3,250,1,36363.62,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4760,7812,1334,40720,1579,3,68,1,7636.36,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4761,7812,1334,40720,1579,3,250,1,0.02,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4762,7812,1334,40720,1579,3,57,2,44000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4763,7812,1335,40720,1579,3,250,1,9090.90,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4764,7812,1335,40720,1579,3,68,1,1909.09,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4765,7812,1335,40720,1579,3,250,1,0.01,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4766,7812,1335,40720,1579,3,57,2,11000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4767,7812,1336,40720,1579,3,217,1,11570.25,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4768,7812,1336,40720,1579,3,68,1,2429.75,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4769,7812,1336,40720,1579,3,57,2,14000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4770,7812,1337,40720,1579,3,217,1,270000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4771,7812,1337,40720,1579,3,68,1,28350.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4772,7812,1337,40720,1579,3,57,2,298350.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4773,7812,1338,40720,1579,3,217,1,240000.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4774,7812,1338,40720,1579,3,68,1,25200.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4775,7812,1338,40720,1579,3,57,2,265200.00,NULL,'2025-06-07 09:12:51','2025-06-07 09:12:51',NULL),(4776,7812,1339,40720,1580,3,217,1,300000.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4777,7812,1339,40720,1580,3,68,1,31500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4778,7812,1339,40720,1580,3,57,2,331500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4779,7812,1340,40720,1580,3,217,1,300000.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4780,7812,1340,40720,1580,3,68,1,31500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4781,7812,1340,40720,1580,3,57,2,331500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4782,7812,1341,40720,1580,3,217,1,72727.29,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4783,7812,1341,40720,1580,3,68,1,15272.73,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4784,7812,1341,40720,1580,3,217,1,0.02,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4785,7812,1341,40720,1580,3,57,2,88000.04,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4786,7812,1342,40720,1580,3,217,1,300000.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4787,7812,1342,40720,1580,3,68,1,31500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4788,7812,1342,40720,1580,3,57,2,331500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4789,7812,1343,40720,1580,3,217,1,70660.41,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4790,7812,1343,40720,1580,3,68,1,14838.69,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4791,7812,1343,40720,1580,3,57,2,85499.10,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4792,7812,1344,40720,1580,3,217,1,450000.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4793,7812,1344,40720,1580,3,68,1,47250.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4794,7812,1344,40720,1580,3,57,2,497250.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4795,7812,1345,40720,1580,3,217,1,300000.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4796,7812,1345,40720,1580,3,68,1,31500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4797,7812,1345,40720,1580,3,57,2,331500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4798,7812,1346,40720,1580,3,217,1,300000.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL);
INSERT INTO `balance_libro_details` VALUES (4799,7812,1346,40720,1580,3,68,1,31500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4800,7812,1346,40720,1580,3,57,2,331500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4801,7812,1347,40720,1580,3,217,1,300000.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4802,7812,1347,40720,1580,3,68,1,31500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4803,7812,1347,40720,1580,3,57,2,331500.00,NULL,'2025-06-07 09:15:12','2025-06-07 09:15:12',NULL),(4804,7812,1348,40720,1580,3,221,1,3880.71,NULL,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(4805,7812,1348,40720,1580,3,217,1,107797.52,NULL,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(4806,7812,1348,40720,1580,3,68,1,22637.48,NULL,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(4807,7812,1348,40720,1580,3,57,2,134315.71,NULL,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(4808,7812,1349,40720,1580,3,217,1,300000.00,NULL,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(4809,7812,1349,40720,1580,3,68,1,31500.00,NULL,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(4810,7812,1349,40720,1580,3,57,2,331500.00,NULL,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(4811,7812,1350,40720,1580,3,250,1,27500.00,NULL,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(4812,7812,1350,40720,1580,3,57,2,27500.00,NULL,'2025-06-07 09:15:13','2025-06-07 09:15:13',NULL),(4813,7812,1351,40720,1581,2,96,2,652156.90,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4814,7812,1351,40720,1581,2,67,2,136952.95,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4815,7812,1351,40720,1581,2,218,2,0.02,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4816,7812,1351,40720,1581,2,13,1,789109.87,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4817,7812,1352,40720,1581,2,96,2,747903.19,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4818,7812,1352,40720,1581,2,67,2,157059.67,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4819,7812,1352,40720,1581,2,218,2,0.01,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4820,7812,1352,40720,1581,2,13,1,904962.87,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4821,7812,1353,40720,1581,2,96,2,818930.00,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4822,7812,1353,40720,1581,2,67,2,171975.30,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4823,7812,1353,40720,1581,2,13,1,990905.30,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4824,7812,1354,40720,1581,2,96,2,1481660.00,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4825,7812,1354,40720,1581,2,67,2,311148.60,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4826,7812,1354,40720,1581,2,13,1,1792808.60,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4827,7812,1355,40720,1581,2,96,2,1555254.81,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4828,7812,1355,40720,1581,2,67,2,326603.51,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4829,7812,1355,40720,1581,2,218,2,0.01,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4830,7812,1355,40720,1581,2,13,1,1881858.33,NULL,'2025-06-07 09:17:39','2025-06-07 09:17:39',NULL),(4831,7812,1356,40720,1581,3,217,1,133057.85,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4832,7812,1356,40720,1581,3,68,1,27942.15,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4833,7812,1356,40720,1581,3,57,2,161000.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4834,7812,1357,40720,1581,3,217,1,300000.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4835,7812,1357,40720,1581,3,68,1,31500.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4836,7812,1357,40720,1581,3,57,2,331500.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4837,7812,1358,40720,1581,3,250,1,1770000.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4838,7812,1358,40720,1581,3,57,2,1770000.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL);
INSERT INTO `balance_libro_details` VALUES (4839,7812,1359,40720,1581,3,217,1,118532.80,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4840,7812,1359,40720,1581,3,68,1,24891.89,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4841,7812,1359,40720,1581,3,57,2,143424.69,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4842,7812,1360,40720,1581,3,221,1,24861.47,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4843,7812,1360,40720,1581,3,217,1,152263.25,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4844,7812,1360,40720,1581,3,68,1,31975.28,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4845,7812,1360,40720,1581,3,57,2,209100.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4846,7812,1361,40720,1581,3,217,1,300000.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4847,7812,1361,40720,1581,3,68,1,31500.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4848,7812,1361,40720,1581,3,57,2,331500.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4849,7812,1362,40720,1581,3,217,1,20661.16,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4850,7812,1362,40720,1581,3,68,1,4338.84,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4851,7812,1362,40720,1581,3,57,2,25000.00,NULL,'2025-06-07 09:17:47','2025-06-07 09:17:47',NULL),(4852,7812,1363,40720,1581,3,217,1,150000.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4853,7812,1363,40720,1581,3,68,1,15750.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4854,7812,1363,40720,1581,3,57,2,165750.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4855,7812,1364,40720,1581,3,217,1,65514.40,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4856,7812,1364,40720,1581,3,68,1,13758.02,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4857,7812,1364,40720,1581,3,57,2,79272.42,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4858,7812,1365,40720,1581,3,250,1,1000000.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4859,7812,1365,40720,1581,3,57,2,1000000.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4860,7812,1366,40720,1581,3,221,1,32545.10,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4861,7812,1366,40720,1581,3,242,1,3709.43,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4862,7812,1366,40720,1581,3,217,1,217971.52,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4863,7812,1366,40720,1581,3,68,1,45774.02,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4864,7812,1366,40720,1581,3,217,1,0.01,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4865,7812,1366,40720,1581,3,57,2,300000.08,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4866,7812,1367,40720,1581,3,221,1,32545.10,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4867,7812,1367,40720,1581,3,242,1,3709.43,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4868,7812,1367,40720,1581,3,217,1,217971.48,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4869,7812,1367,40720,1581,3,68,1,45774.01,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4870,7812,1367,40720,1581,3,217,1,0.02,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4871,7812,1367,40720,1581,3,57,2,300000.04,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4872,7812,1368,40720,1581,3,221,2,32545.10,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4873,7812,1368,40720,1581,3,242,2,3709.43,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4874,7812,1368,40720,1581,3,250,2,217971.52,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4875,7812,1368,40720,1581,3,67,2,45774.02,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4876,7812,1368,40720,1581,3,250,2,0.01,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4877,7812,1368,40720,1581,3,57,1,300000.08,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4878,7812,1369,40720,1581,3,221,1,33148.62,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL);
INSERT INTO `balance_libro_details` VALUES (4879,7812,1369,40720,1581,3,217,1,203017.67,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4880,7812,1369,40720,1581,3,68,1,42633.71,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4881,7812,1369,40720,1581,3,57,2,278800.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4882,7812,1370,40720,1581,3,221,1,8114.05,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4883,7812,1370,40720,1581,3,242,1,497.04,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4884,7812,1370,40720,1581,3,217,1,35866.86,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4885,7812,1370,40720,1581,3,68,1,7532.04,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4886,7812,1370,40720,1581,3,217,1,0.02,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4887,7812,1370,40720,1581,3,57,2,52010.01,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4888,7812,1371,40720,1581,3,217,1,150000.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4889,7812,1371,40720,1581,3,68,1,15750.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4890,7812,1371,40720,1581,3,57,2,165750.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4891,7812,1372,40720,1581,3,217,1,300000.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4892,7812,1372,40720,1581,3,68,1,31500.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4893,7812,1372,40720,1581,3,57,2,331500.00,NULL,'2025-06-07 09:17:48','2025-06-07 09:17:48',NULL),(4894,7812,1373,40720,1582,2,96,2,581118.24,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4895,7812,1373,40720,1582,2,67,2,122034.83,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4896,7812,1373,40720,1582,2,218,2,0.01,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4897,7812,1373,40720,1582,2,13,1,703153.08,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4898,7812,1374,40720,1582,2,96,2,1861347.81,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4899,7812,1374,40720,1582,2,67,2,390883.04,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4900,7812,1374,40720,1582,2,218,2,0.03,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4901,7812,1374,40720,1582,2,13,1,2252230.88,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4902,7812,1375,40720,1582,2,96,2,1541741.86,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4903,7812,1375,40720,1582,2,67,2,323765.79,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4904,7812,1375,40720,1582,2,218,2,0.02,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4905,7812,1375,40720,1582,2,13,1,1865507.67,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4906,7812,1376,40720,1582,2,96,2,859960.76,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4907,7812,1376,40720,1582,2,67,2,180591.76,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4908,7812,1376,40720,1582,2,218,2,0.01,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4909,7812,1376,40720,1582,2,13,1,1040552.53,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4910,7812,1377,40720,1582,2,96,2,599235.57,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4911,7812,1377,40720,1582,2,67,2,125839.47,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4912,7812,1377,40720,1582,2,218,2,0.01,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4913,7812,1377,40720,1582,2,13,1,725075.05,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4914,7812,1378,40720,1582,2,96,2,1789131.95,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4915,7812,1378,40720,1582,2,67,2,375717.71,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4916,7812,1378,40720,1582,2,218,2,0.02,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4917,7812,1378,40720,1582,2,13,1,2164849.68,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4918,7812,1379,40720,1582,2,96,2,2517210.71,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL);
INSERT INTO `balance_libro_details` VALUES (4919,7812,1379,40720,1582,2,67,2,528614.25,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4920,7812,1379,40720,1582,2,218,2,0.02,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4921,7812,1379,40720,1582,2,13,1,3045824.98,NULL,'2025-06-07 09:21:03','2025-06-07 09:21:03',NULL),(4922,7812,1380,40720,1582,3,217,1,180000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4923,7812,1380,40720,1582,3,68,1,18900.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4924,7812,1380,40720,1582,3,57,2,198900.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4925,7812,1381,40720,1582,3,221,1,180.57,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4926,7812,1381,40720,1582,3,217,1,6019.10,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4927,7812,1381,40720,1582,3,68,1,1264.01,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4928,7812,1381,40720,1582,3,57,2,7463.68,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4929,7812,1382,40720,1582,3,217,1,74305.04,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4930,7812,1382,40720,1582,3,68,1,15604.06,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4931,7812,1382,40720,1582,3,57,2,89909.10,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4932,7812,1383,40720,1582,3,217,1,210000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4933,7812,1383,40720,1582,3,68,1,22050.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4934,7812,1383,40720,1582,3,57,2,232050.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4935,7812,1384,40720,1582,3,217,1,150000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4936,7812,1384,40720,1582,3,68,1,15750.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4937,7812,1384,40720,1582,3,57,2,165750.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4938,7812,1385,40720,1582,3,217,1,148760.33,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4939,7812,1385,40720,1582,3,68,1,31239.67,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4940,7812,1385,40720,1582,3,57,2,180000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4941,7812,1386,40720,1582,3,250,1,99008.24,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4942,7812,1386,40720,1582,3,68,1,20791.73,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4943,7812,1386,40720,1582,3,250,1,0.02,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4944,7812,1386,40720,1582,3,57,2,119799.99,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4945,7812,1387,40720,1582,3,217,1,210000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4946,7812,1387,40720,1582,3,68,1,22050.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4947,7812,1387,40720,1582,3,57,2,232050.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4948,7812,1388,40720,1582,3,217,1,150000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4949,7812,1388,40720,1582,3,68,1,15750.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4950,7812,1388,40720,1582,3,57,2,165750.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4951,7812,1389,40720,1582,3,250,1,312741.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4952,7812,1389,40720,1582,3,57,2,312741.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4953,7812,1390,40720,1582,3,217,1,150000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4954,7812,1390,40720,1582,3,68,1,15750.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4955,7812,1390,40720,1582,3,57,2,165750.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4956,7812,1391,40720,1582,3,217,1,225000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4957,7812,1391,40720,1582,3,68,1,23625.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4958,7812,1391,40720,1582,3,57,2,248625.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL);
INSERT INTO `balance_libro_details` VALUES (4959,7812,1392,40720,1582,3,217,1,210000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4960,7812,1392,40720,1582,3,68,1,22050.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4961,7812,1392,40720,1582,3,57,2,232050.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4962,7812,1393,40720,1582,3,217,1,150000.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4963,7812,1393,40720,1582,3,68,1,15750.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4964,7812,1393,40720,1582,3,57,2,165750.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4965,7812,1394,40720,1582,3,250,1,165461.51,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4966,7812,1394,40720,1582,3,57,2,165461.51,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4967,7812,1395,40720,1582,3,250,1,83600.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4968,7812,1395,40720,1582,3,57,2,83600.00,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4969,7812,1396,40720,1582,3,250,1,170456.12,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4970,7812,1396,40720,1582,3,57,2,170456.12,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4971,7812,1397,40720,1582,3,250,1,136264.06,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4972,7812,1397,40720,1582,3,57,2,136264.06,NULL,'2025-06-07 09:21:13','2025-06-07 09:21:13',NULL),(4973,7812,1398,40720,1579,15,68,2,346956.36,NULL,'2025-06-07 09:25:39','2025-06-07 09:25:39',NULL),(4974,7812,1398,40720,1579,15,353,2,3202692.59,NULL,'2025-06-07 09:25:39','2025-06-07 09:25:39',NULL),(4975,7812,1398,40720,1579,15,353,1,3549648.95,NULL,'2025-06-07 09:25:39','2025-06-07 09:25:39',NULL),(4976,7812,1399,40720,1580,15,68,2,320498.90,NULL,'2025-06-07 09:30:06','2025-06-07 09:30:06',NULL),(4977,7812,1399,40720,1580,15,353,2,3549648.95,NULL,'2025-06-07 09:30:06','2025-06-07 09:30:06',NULL),(4978,7812,1399,40720,1580,15,353,1,3870147.85,NULL,'2025-06-07 09:30:06','2025-06-07 09:30:06',NULL),(4979,7812,1400,40720,1581,15,67,1,1149514.05,NULL,'2025-06-07 09:35:23','2025-06-07 09:35:23',NULL),(4980,7812,1400,40720,1581,15,68,2,370619.97,NULL,'2025-06-07 09:35:23','2025-06-07 09:35:23',NULL),(4981,7812,1400,40720,1581,15,353,2,3870147.85,NULL,'2025-06-07 09:35:23','2025-06-07 09:35:23',NULL),(4982,7812,1400,40720,1581,15,353,1,3091253.77,NULL,'2025-06-07 09:35:23','2025-06-07 09:35:23',NULL),(4983,7812,1401,40720,1582,15,67,1,2047446.85,NULL,'2025-06-07 09:38:14','2025-06-07 09:38:14',NULL),(4984,7812,1401,40720,1582,15,68,2,240574.47,NULL,'2025-06-07 09:38:14','2025-06-07 09:38:14',NULL),(4985,7812,1401,40720,1582,15,353,2,3091253.77,NULL,'2025-06-07 09:38:14','2025-06-07 09:38:14',NULL),(4986,7812,1401,40720,1582,15,353,1,1284381.39,NULL,'2025-06-07 09:38:14','2025-06-07 09:38:14',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_credentials`
--

DROP TABLE IF EXISTS `bind_apibank_credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_credentials` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que configuró las credenciales',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta de tesorería vinculada',
  `env` enum('sandbox','prod') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Ambiente: sandbox o producción',
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Usuario de Bind APIBank',
  `password` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Password encriptado con Laravel Crypt',
  `cert_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Path absoluto al certificado SSL del cliente (.crt)',
  `key_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Path absoluto a la llave privada SSL (.key)',
  `key_password` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Password de la llave privada (si está protegida con password)',
  `jwt_token` text COLLATE utf8mb4_unicode_ci COMMENT 'Token JWT actual',
  `jwt_expires_at` datetime DEFAULT NULL COMMENT 'Fecha de expiración del token JWT',
  `bind_account_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ID de cuenta en Bind (obtenido al hacer login)',
  `active` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Credencial activa?',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bind_apibank_cred_person` (`person_id`),
  KEY `idx_bind_apibank_cred_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_cred_active` (`active`),
  KEY `idx_bind_apibank_cred_bind_acc` (`bind_account_id`),
  KEY `idx_bind_apibank_cred_person_active` (`person_id`,`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_credentials`
--

LOCK TABLES `bind_apibank_credentials` WRITE;
/*!40000 ALTER TABLE `bind_apibank_credentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_movements`
--

DROP TABLE IF EXISTS `bind_apibank_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_movements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que ejecutó la sincronización',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta de tesorería',
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL COMMENT 'Movimiento en tesorería (vinculación bidireccional)',
  `bind_movement_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ID único del movimiento en Bind',
  `type` enum('in','out','fee') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo: in=transferencia entrante, out=transferencia saliente, fee=comisión',
  `status` enum('settled','pending','failed') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Estado del movimiento',
  `amount` decimal(15,2) NOT NULL COMMENT 'Monto del movimiento',
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ARS' COMMENT 'Moneda (ARS, USD)',
  `from_cbu_cvu` varchar(22) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CBU/CVU origen',
  `from_titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Titular de la cuenta origen',
  `from_cuit` varchar(13) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CUIT del titular origen',
  `to_cbu_cvu` varchar(22) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CBU/CVU destino',
  `to_titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Titular de la cuenta destino',
  `to_cuit` varchar(13) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CUIT del titular destino',
  `concept` text COLLATE utf8mb4_unicode_ci COMMENT 'Concepto/descripción del movimiento',
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Referencia del movimiento',
  `executed_at` datetime DEFAULT NULL COMMENT 'Fecha de ejecución del movimiento en Bind',
  `raw_response` json DEFAULT NULL COMMENT 'Respuesta completa de la API de Bind (para auditoría)',
  `is_synced_to_treasury` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ya sincronizado a tesorería?',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_bind_apibank_mov_bind_id` (`bind_movement_id`),
  KEY `idx_bind_apibank_mov_person` (`person_id`),
  KEY `idx_bind_apibank_mov_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_mov_tesoreria` (`cta_cte_tesoreria_id`),
  KEY `idx_bind_apibank_mov_synced` (`is_synced_to_treasury`),
  KEY `idx_bind_apibank_mov_executed` (`executed_at`),
  KEY `idx_bind_apibank_mov_type_status` (`type`,`status`),
  KEY `idx_bind_apibank_mov_person_synced` (`person_id`,`is_synced_to_treasury`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_movements`
--

LOCK TABLES `bind_apibank_movements` WRITE;
/*!40000 ALTER TABLE `bind_apibank_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_sync_logs`
--

DROP TABLE IF EXISTS `bind_apibank_sync_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_sync_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que ejecutó la sincronización',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta sincronizada',
  `sync_type` enum('movements','balance','transfers','webhook') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo de sincronización: movements=movimientos, balance=saldo, transfers=transferencias, webhook=desde webhook',
  `last_sync_at` datetime NOT NULL COMMENT 'Fecha/hora de la sincronización',
  `records_synced` int(11) NOT NULL DEFAULT '0' COMMENT 'Cantidad de registros sincronizados',
  `status` enum('success','error') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Estado de la sincronización',
  `error_message` text COLLATE utf8mb4_unicode_ci COMMENT 'Mensaje de error (si status=error)',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bind_apibank_sync_person` (`person_id`),
  KEY `idx_bind_apibank_sync_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_sync_type` (`sync_type`),
  KEY `idx_bind_apibank_sync_last` (`last_sync_at`),
  KEY `idx_bind_apibank_sync_type_status` (`sync_type`,`status`),
  KEY `idx_bind_apibank_sync_person_type` (`person_id`,`sync_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_sync_logs`
--

LOCK TABLES `bind_apibank_sync_logs` WRITE;
/*!40000 ALTER TABLE `bind_apibank_sync_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_sync_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_transfers`
--

DROP TABLE IF EXISTS `bind_apibank_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_transfers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que ejecutó la transferencia',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta origen de la transferencia',
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL COMMENT 'Movimiento en tesorería resultante (vinculación)',
  `bind_transfer_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ID de transferencia en Bind',
  `numero_operacion` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Número de operación bancaria',
  `cbu_origin` varchar(22) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'CBU origen (nuestra cuenta)',
  `cbu_destination` varchar(22) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CBU destino',
  `alias_destination` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Alias destino (alternativo a CBU)',
  `amount` decimal(15,2) NOT NULL COMMENT 'Monto de la transferencia',
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ARS' COMMENT 'Moneda (ARS, USD)',
  `concept` text COLLATE utf8mb4_unicode_ci COMMENT 'Concepto de la transferencia',
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Referencia interna (ej: FAC-001-1234)',
  `type` enum('INMEDIATA','PROGRAMADA') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'INMEDIATA' COMMENT 'Tipo de transferencia',
  `status` enum('PENDIENTE','APROBADA','RECHAZADA','CANCELADA') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PENDIENTE' COMMENT 'Estado de la transferencia',
  `scheduled_at` datetime DEFAULT NULL COMMENT 'Fecha programada (si type=PROGRAMADA)',
  `executed_at` datetime DEFAULT NULL COMMENT 'Fecha de ejecución real',
  `comision` decimal(15,2) DEFAULT '0.00' COMMENT 'Comisión cobrada por Bind',
  `iva_comision` decimal(15,2) DEFAULT '0.00' COMMENT 'IVA de la comisión',
  `total_debitado` decimal(15,2) DEFAULT NULL COMMENT 'Total debitado (monto + comisión + IVA)',
  `raw_response` json DEFAULT NULL COMMENT 'Respuesta completa de la API de Bind',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bind_apibank_trf_person` (`person_id`),
  KEY `idx_bind_apibank_trf_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_trf_tesoreria` (`cta_cte_tesoreria_id`),
  KEY `idx_bind_apibank_trf_status` (`status`),
  KEY `idx_bind_apibank_trf_bind_id` (`bind_transfer_id`),
  KEY `idx_bind_apibank_trf_executed` (`executed_at`),
  KEY `idx_bind_apibank_trf_type_status` (`type`,`status`),
  KEY `idx_bind_apibank_trf_person_status` (`person_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_transfers`
--

LOCK TABLES `bind_apibank_transfers` WRITE;
/*!40000 ALTER TABLE `bind_apibank_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-09-11 21:18:01',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-09-11 21:18:01',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-09-11 21:18:01',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-11 21:18:01','2022-09-11 21:18:01',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-11 21:18:18','2022-09-11 21:18:18',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-11 21:18:18','2022-09-11 21:18:18',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-11 21:18:18','2022-09-11 21:18:18',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-11 21:18:18','2022-09-11 21:18:18',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-11 21:18:30','2022-09-11 21:18:30',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-11 21:18:30','2022-09-11 21:18:30',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-11 21:18:30','2022-09-11 21:18:30',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-11 21:18:30','2022-09-11 21:18:30',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:04:33','2023-05-30 15:04:33',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:04:33','2023-05-30 15:04:33',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:04:33','2023-05-30 15:04:33',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:04:33','2023-05-30 15:04:33',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:04:33','2023-05-30 15:04:33',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:04:33','2023-05-30 15:04:33',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
INSERT INTO `bs_per_ddjjs` VALUES (1,7812,2022,40720,0.00,0.00,11282141.08,0.00,0.00,0.00,0.00,NULL,'2023-06-08 08:11:13','2023-06-08 08:11:13',NULL);
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
INSERT INTO `bs_pers_detail_anticipos` VALUES (1,1,40720,1,0.00,'2023-06-08 08:11:13','2023-06-08 08:11:13',NULL),(2,1,40720,2,0.00,'2023-06-08 08:11:13','2023-06-08 08:11:13',NULL),(3,1,40720,3,0.00,'2023-06-08 08:11:13','2023-06-08 08:11:13',NULL);
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
INSERT INTO `bs_pers_detail_bienes` VALUES (1,1,40720,11,'',0.00,0.00,'','2023-06-08 08:11:13','2023-06-08 08:11:13',NULL),(2,1,40720,1,'',0.00,0.00,'','2023-06-08 17:10:00','2023-06-08 17:10:00',NULL),(3,1,40720,7,'',0.00,0.00,'','2023-06-22 08:40:09','2023-06-22 08:40:09',NULL);
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `inv_ot_id` bigint(20) unsigned DEFAULT NULL,
  `calendar_tur_dispo_dato_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  KEY `calendar_calendar_tur_dispo_dato_id_foreign` (`calendar_tur_dispo_dato_id`),
  KEY `calendar_inv_ot_id_foreign` (`inv_ot_id`),
  CONSTRAINT `calendar_calendar_tur_dispo_dato_id_foreign` FOREIGN KEY (`calendar_tur_dispo_dato_id`) REFERENCES `calendar_tur_dispo_datos` (`id`),
  CONSTRAINT `calendar_inv_ot_id_foreign` FOREIGN KEY (`inv_ot_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
INSERT INTO `calendar` VALUES (1,NULL,40719,NULL,NULL,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-01-23 10:00:00',1,NULL,'2023-01-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(2,NULL,40719,NULL,NULL,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-03-23 10:00:00',1,NULL,'2023-03-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(3,NULL,40719,NULL,NULL,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-05-23 10:00:00',1,NULL,'2023-05-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(4,NULL,40719,NULL,NULL,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-07-21 10:00:00',1,NULL,'2023-07-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(5,NULL,40719,NULL,NULL,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-09-22 10:00:00',1,NULL,'2023-09-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(6,NULL,40719,NULL,NULL,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-11-24 10:00:00',1,NULL,'2023-11-24 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(7,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(8,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(9,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(10,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(11,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(12,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(13,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(14,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-08-22 10:00:00',1,NULL,'2023-08-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(15,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(16,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(17,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(18,NULL,40719,NULL,NULL,NULL,NULL,'Monotributo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(19,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-01-06 10:00:00',1,NULL,'2023-01-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (20,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-02-07 10:00:00',1,NULL,'2023-02-07 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(21,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-03-07 10:00:00',1,NULL,'2023-03-07 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(22,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-04-06 10:00:00',1,NULL,'2023-04-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(23,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-05-08 10:00:00',1,NULL,'2023-05-08 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(24,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-06-06 10:00:00',1,NULL,'2023-06-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(25,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-07-06 10:00:00',1,NULL,'2023-07-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(26,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-08-08 10:00:00',1,NULL,'2023-08-08 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(27,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-09-06 10:00:00',1,NULL,'2023-09-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(28,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-10-06 10:00:00',1,NULL,'2023-10-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(29,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-11-07 10:00:00',1,NULL,'2023-11-07 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(30,NULL,40720,NULL,NULL,NULL,NULL,'Autonomos',NULL,NULL,'','2023-12-06 10:00:00',1,NULL,'2023-12-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(31,NULL,40720,NULL,NULL,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-02-14 10:00:00',1,NULL,'2023-02-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(32,NULL,40720,NULL,NULL,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-04-14 10:00:00',1,NULL,'2023-04-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(33,NULL,40720,NULL,NULL,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(34,NULL,40720,NULL,NULL,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(35,NULL,40720,NULL,NULL,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(36,NULL,40720,NULL,NULL,NULL,NULL,'Ganancia Personas Humanas',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(37,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(38,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-02-24 10:00:00',1,NULL,'2023-02-24 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (39,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-03-22 10:00:00',1,NULL,'2023-03-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(40,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(41,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(42,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-06-23 10:00:00',1,NULL,'2023-06-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(43,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(44,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-08-23 10:00:00',1,NULL,'2023-08-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(45,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(46,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(47,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-11-23 10:00:00',1,NULL,'2023-11-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(48,NULL,40720,NULL,NULL,NULL,NULL,'IVA',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(49,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-01-17 10:00:00',1,NULL,'2023-01-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(50,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-02-16 10:00:00',1,NULL,'2023-02-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(51,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-03-16 10:00:00',1,NULL,'2023-03-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(52,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(53,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-05-16 10:00:00',1,NULL,'2023-05-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(54,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-06-16 10:00:00',1,NULL,'2023-06-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(55,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(56,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-08-16 10:00:00',1,NULL,'2023-08-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(57,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-09-18 10:00:00',1,NULL,'2023-09-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (58,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(59,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-11-16 10:00:00',1,NULL,'2023-11-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(60,NULL,40720,NULL,NULL,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-12-18 10:00:00',1,NULL,'2023-12-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:35:23',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:35:23',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:35:23',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:35:23',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:35:23',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:35:23',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:23',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:23',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',8992597.87,749383.16,'No Excluida','0',30,3330,2091301.83,4182.60,4182.60,13663.17,19239.97,37085.74,37085.74,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',13175201.52,1097933.46,'No Excluida','0',45,5000,2091301.83,7946.95,7946.95,15029.49,19239.97,42216.41,42216.41,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',18473166.15,1539430.51,'No Excluida','0',60,6700,2858112.50,13663.17,12547.81,16532.44,19239.97,49435.58,48320.22,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',22934610.05,1911217.50,'No Excluida','0',85,10000,2858112.50,22307.22,20773.60,18185.68,22864.90,63357.80,61824.18,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',26977793.60,2248149.47,'No Excluida','0',110,13000,3624923.17,41826.04,33181.99,20004.25,27884.02,89714.31,81070.26,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',33809379.57,2817448.30,'No Excluida','0',150,16500,3624923.17,58835.29,43220.24,22004.67,32066.63,112906.59,97291.54,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',40431835.35,3369319.61,'No Excluida','0',200,20000,4322023.77,107074.65,53537.32,30806.54,34576.19,172457.38,118920.05,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',61344853.64,5112071.14,'No Excluida','0',200,20000,6273905.49,306724.27,153362.13,43129.16,41547.19,391400.62,238038.48,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',68664410.05,5722034.17,'Venta de Bs Muebles','0',200,20000,6273905.49,609963.03,243985.21,60380.82,51306.61,721650.46,355672.64,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',78632948.76,6552745.73,'Venta de Bs Muebles','0',200,20000,6273905.49,731955.63,292782.26,84533.15,57580.51,874069.29,434895.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',94805682.90,7900473.58,'Venta de Bs Muebles','0',200,20000,6273905.49,1024737.89,341579.30,118346.41,65806.30,1208890.60,525732.01,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (2,7812,NULL,'mariacarolinA10',NULL,1,40719,1,'2022-09-15 16:27:01','2022-09-15 16:27:01',NULL),(14,7812,'clave fiscal daniel','Daniel03112022',NULL,1,40787,1,'2023-05-29 07:50:35','2023-05-29 07:50:35',NULL),(18,7812,NULL,'Cristian2024',NULL,1,40825,1,'2023-12-14 07:35:50','2023-12-14 07:35:50',NULL),(19,7812,'AFIP','Jorgees2024',NULL,1,40720,1,'2024-09-02 17:05:32','2024-09-02 17:05:32',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL),(2,NULL,'Articulo 6',6,0,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL),(3,NULL,'Articulo 7',7,0,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL),(4,NULL,'Articulo 8',8,0,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL),(5,NULL,'Articulo 9',9,0,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL),(6,NULL,'Articulo 10',10,0,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL),(7,NULL,'Articulo 11',11,0,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL),(8,NULL,'Articulo 12',12,0,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL),(9,NULL,'Articulo 13',13,0,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL),(10,NULL,'Articulo 14',14,1,'2022-09-11 21:18:18','2022-09-11 21:18:19',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conciliaciones`
--

DROP TABLE IF EXISTS `conciliaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conciliaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_conciliado` decimal(13,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conciliaciones_person_id_foreign` (`person_id`),
  CONSTRAINT `conciliaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conciliaciones`
--

LOCK TABLES `conciliaciones` WRITE;
/*!40000 ALTER TABLE `conciliaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `conciliaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conciliaciones_details`
--

DROP TABLE IF EXISTS `conciliaciones_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conciliaciones_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conciliacion_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conciliaciones_details_person_id_foreign` (`person_id`),
  KEY `conciliaciones_details_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  CONSTRAINT `conciliaciones_details_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `conciliaciones_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conciliaciones_details`
--

LOCK TABLES `conciliaciones_details` WRITE;
/*!40000 ALTER TABLE `conciliaciones_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conciliaciones_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,'2025-02-11 16:34:54','2025-02-11 16:34:54'),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,'2025-02-11 16:34:54','2025-02-11 16:34:54'),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,'2025-02-11 16:34:54','2025-02-11 16:34:54'),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,'2025-02-11 16:34:54','2025-02-11 16:34:54'),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,'2025-02-11 16:34:54','2025-02-11 16:34:54'),(15,NULL,15,'IVA No Alcanzado',0,1,1,NULL,'2025-02-11 19:34:54',NULL),(16,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,'2025-02-11 16:34:54','2025-02-11 16:34:54');
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb